#ifndef __NAND_API_H__
#define __NAND_API_H__

#define PROGRAM_NAME "libnandapi"

int nand_open(const char *pathname, int flags);

off_t nand_seek(int fd, off_t offset, int whence);

off64_t nand_seek64(int fd, off64_t offset, int whence);

ssize_t nand_read(int fd, void *buf, size_t count);

ssize_t nand_write(int fd, void *buf, size_t count);

ssize_t nand_write_force(int fd, void *buf, size_t count);

int nand_close(int fd);

off_t nand_query_offset(int fd);

size_t nand_query_blk_size(int fd);

#endif

