
#define UUID_GAP			0x1800
#define UUID_GATT			0x1801
#define UUID_DEVINFO		0x180a
#define UUID_HEART_RATE			0x180d
#define UUID_HEART_RATE_MSRMT		0x2a37
#define UUID_HEART_RATE_BODY		0x2a38
#define UUID_HEART_RATE_CTRL		0x2a39

#define UUID_CENTRAL_ADDR_RESOL		0x2aa6

#define ATT_CID 4

#include <syslog.h>

#define PRLOG(...) \
	do { \
		syslog(LOG_DEBUG, "[GATT server]# "__VA_ARGS__); \
	} while (0)

#define PRERR(...) \
	do { \
		syslog(LOG_ERR, "[GATT error ]# "__VA_ARGS__); \
	} while (0)

#define PRLOG_DUMP(...) \
	do { \
		print_dmup_data(__VA_ARGS__); \
	} while (0)

#ifndef MIN
#define MIN(a, b) ((a) < (b) ? (a) : (b))
#endif

#define COLOR_OFF	"\x1B[0m"
#define COLOR_RED	"\x1B[0;91m"
#define COLOR_GREEN	"\x1B[0;92m"
#define COLOR_YELLOW	"\x1B[0;93m"
#define COLOR_BLUE	"\x1B[0;94m"
#define COLOR_MAGENTA	"\x1B[0;95m"
#define COLOR_BOLDGRAY	"\x1B[1;30m"
#define COLOR_BOLDWHITE	"\x1B[1;37m"

#define BTGATT_NOTIFY_RT_STATUS		0x00000001
#define BTGATT_NOTIFY_WIFI_STATUS	0x00000001
#define BTGATT_NOTIFY_WIFI_BAND		0x00000002
#define BTGATT_NOTIFY_WIFI_SSID		0x00000004
#define BTGATT_NOTIFY_WIFI_PASS		0x00000008
#define BTGATT_NOTIFY_WIFI_STA		0x00000010
#define BTGATT_NOTIFY_WIFI_ENC		0x00000020
#define BTGATT_NOTIFY_WIFI_CACDETECT	0x00000100
#define BTGATT_NOTIFY_LTE_STATUS	0x00000001
#define BTGATT_NOTIFY_LTE_TRAF		0x00000002
#define BTGATT_NOTIFY_FW_STATUS		0x00000001
#define BTGATT_NOTIFY_FW_UPDATE		0x00000002
#define BTGATT_NOTIFY_SERVER_CONTROL		0x00000001

struct server {
	int fd;
	struct bt_att *att;
	struct gatt_db *db;
	struct bt_gatt_server *gatt;

	uint8_t *device_name;
	size_t name_len;
	
	int appearance;
	int peripheral_pref_conn;
	int central_addr_resol;
	
	uint8_t *manuf_name;
	size_t manuf_len;
	
	uint8_t *model_num;
	size_t model_len;

	uint8_t *fw_revision;
	size_t fw_rev_len;

	uint8_t *hw_revision;
	size_t hw_rev_len;

	uint8_t *pnp_id;
	size_t pnp_id_len;

	uint16_t necpf_rt_notify_handle;
	uint16_t necpf_wifi_notify_handle;
	uint16_t necpf_lte_notify_handle;
	uint16_t necpf_fw_notify_handle;
	uint16_t necpf_server_control_notify_handle;

	uint16_t gatt_svc_chngd_handle;
	bool svc_chngd_enabled;
	
	uint8_t auth_key[512];
	int auth_stat;
	uint8_t auth_val[512];
	uint8_t auth_val_512[512];
	uint8_t auth_val_512_s[512];

	uint16_t hr_handle;
	uint16_t hr_msrmt_handle;
	uint16_t hr_energy_expended;
	bool hr_visible;
	bool hr_msrmt_enabled;
	int hr_ee_count;
	unsigned int hr_timeout_id;
};

/*** GAP Service ***/
void gap_device_name_read_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

void gap_device_name_write_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					const uint8_t *value, size_t len,
					uint8_t opcode, struct bt_att *att,
					void *user_data);


void gap_device_name_ext_prop_read_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

void gap_appearance_read_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

void gap_peripheral_pref_conn_read_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

void gap_central_addr_resol_read_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

/*** GATT Service ***/
void gatt_service_changed_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

void gatt_svc_chngd_ccc_read_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

void gatt_svc_chngd_ccc_write_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					const uint8_t *value, size_t len,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

/*** Device Information Service ***/
void devinfo_manuf_name_read_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

void devinfo_model_number_read_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

void devinfo_fw_revision_read_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

void devinfo_hw_revision_read_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

void devinfo_pnp_id_read_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

/*** Authorization Service ***/
void auth_key_read_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

void auth_stat_read_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

void auth_val_write_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					const uint8_t *value, size_t len,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

/*** NEC Platforms Service ***/
void necpf_rt_notify_read_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

void necpf_rt_notify_cb(struct server *server, uint32_t notify);

void necpf_rt_notify_ccc_read_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

void necpf_rt_status_read_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

void necpf_rt_cmd_write_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					const uint8_t *value, size_t len,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

void necpf_wifi_notify_read_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

void necpf_wifi_notify_cb(struct server *server, uint32_t notify);

void necpf_wifi_notify_ccc_read_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

void necpf_wifi_status_read_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

void necpf_wifi_band_read_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

void necpf_wifi_ssid_read_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

void necpf_wifi_pass_read_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

void necpf_wifi_count_read_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

void necpf_wifi_encrypt_read_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

void necpf_wifi_cmd_write_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					const uint8_t *value, size_t len,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

void necpf_lte_notify_read_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

void necpf_lte_notify_cb(struct server *server, uint32_t notify);

void necpf_lte_notify_ccc_read_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

void necpf_lte_status_read_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

void necpf_lte_traffic_read_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

void necpf_lte_cmd_write_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					const uint8_t *value, size_t len,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

void necpf_fw_notify_read_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

void necpf_fw_notify_cb(struct server *server, uint32_t notify);

void necpf_fw_notify_ccc_read_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

void necpf_fw_status_read_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

void necpf_fw_update_read_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

void necpf_fw_cmd_write_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					const uint8_t *value, size_t len,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

void necpf_server_control_notify_read_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

void necpf_server_control_notify_cb(struct server *server, uint32_t notify);

void necpf_server_control_notify_ccc_read_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

void necpf_server_status_read_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

void necpf_server_traffic_data_read_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

void necpf_server_free_date_read_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

void necpf_server_availability_dams_read_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

void necpf_server_free_alert_dams_read_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					uint8_t opcode, struct bt_att *att,
					void *user_data);

void necpf_server_control_command_write_cb(struct gatt_db_attribute *attrib,
					unsigned int id, uint16_t offset,
					const uint8_t *value, size_t len,
					uint8_t opcode, struct bt_att *att,
					void *user_data);


static void print_prompt(void)
{
	syslog(LOG_DEBUG, "[GATT server]# ");
//	fflush(stdout);
}

static void print_dmup_data(const uint8_t *value, size_t len)
{
	int i;
	char buf[256];
	
	if (value == NULL) {
		syslog(LOG_DEBUG, "[GATT server]# NULL\n");
		print_prompt();
		return;
	}
	
	memset(buf, 0, 256);
	for (i = 0; i < len; i++) {
		sprintf(buf + (3 * (i % 8)), "%02x ", value[i]);
		if ((i % 8) == 7) {
			syslog(LOG_DEBUG, "[GATT server]# %s", buf);
			memset(buf, 0, 256);
		}
	}
	syslog(LOG_DEBUG, "[GATT server]# %s", buf);
}
