/* Copyright (c) 2016, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 */

#ifndef WCD9306_REGISTERS_H
#define WCD9306_REGISTERS_H

#include <linux/mfd/wcd9xxx/wcd9xxx_registers.h>
#include <linux/types.h>

#define TAPAN_A_CHIP_CTL			(0x000)
#define TAPAN_A_CHIP_CTL__POR				(0x00)
#define TAPAN_A_CHIP_STATUS			(0x001)
#define TAPAN_A_CHIP_STATUS__POR				(0x00)
#define TAPAN_A_CHIP_ID_BYTE_0			(0x004)
#define TAPAN_A_CHIP_ID_BYTE_0__POR				(0x00)
#define TAPAN_A_CHIP_ID_BYTE_1			(0x005)
#define TAPAN_A_CHIP_ID_BYTE_1__POR				(0x00)
#define TAPAN_A_CHIP_ID_BYTE_2			(0x006)
#define TAPAN_A_CHIP_ID_BYTE_2__POR				(0x03)
#define TAPAN_A_CHIP_ID_BYTE_3			(0x007)
#define TAPAN_A_CHIP_ID_BYTE_3__POR				(0x01)
#define TAPAN_A_CHIP_VERSION			(0x008)
#define TAPAN_A_CHIP_VERSION__POR				(0x20)
#define TAPAN_A_CHIP_DEBUG_CTL			(0x009)
#define TAPAN_A_CHIP_DEBUG_CTL__POR				(0x00)
#define TAPAN_A_SLAVE_ID_1			(0x00C)
#define TAPAN_A_SLAVE_ID_1__POR				(0x77)
#define TAPAN_A_SLAVE_ID_2			(0x00D)
#define TAPAN_A_SLAVE_ID_2__POR				(0x66)
#define TAPAN_A_SLAVE_ID_3			(0x00E)
#define TAPAN_A_SLAVE_ID_3__POR				(0x55)
#define TAPAN_A_PIN_CTL_OE0			(0x010)
#define TAPAN_A_PIN_CTL_OE0__POR				(0x00)
#define TAPAN_A_PIN_CTL_DATA0			(0x012)
#define TAPAN_A_PIN_CTL_DATA0__POR				(0x00)
#define TAPAN_A_HDRIVE_GENERIC			(0x018)
#define TAPAN_A_HDRIVE_GENERIC__POR				(0x00)
#define TAPAN_A_HDRIVE_OVERRIDE			(0x019)
#define TAPAN_A_HDRIVE_OVERRIDE__POR				(0x08)
#define TAPAN_A_ANA_CSR_WAIT_STATE			(0x020)
#define TAPAN_A_ANA_CSR_WAIT_STATE__POR				(0x44)
#define TAPAN_A_PROCESS_MONITOR_CTL0			(0x040)
#define TAPAN_A_PROCESS_MONITOR_CTL0__POR				(0x80)
#define TAPAN_A_PROCESS_MONITOR_CTL1			(0x041)
#define TAPAN_A_PROCESS_MONITOR_CTL1__POR				(0x00)
#define TAPAN_A_PROCESS_MONITOR_CTL2			(0x042)
#define TAPAN_A_PROCESS_MONITOR_CTL2__POR				(0x00)
#define TAPAN_A_PROCESS_MONITOR_CTL3			(0x043)
#define TAPAN_A_PROCESS_MONITOR_CTL3__POR				(0x01)
#define TAPAN_A_QFUSE_CTL			(0x048)
#define TAPAN_A_QFUSE_CTL__POR				(0x00)
#define TAPAN_A_QFUSE_STATUS			(0x049)
#define TAPAN_A_QFUSE_STATUS__POR				(0x00)
#define TAPAN_A_QFUSE_DATA_OUT0			(0x04A)
#define TAPAN_A_QFUSE_DATA_OUT0__POR				(0x00)
#define TAPAN_A_QFUSE_DATA_OUT1			(0x04B)
#define TAPAN_A_QFUSE_DATA_OUT1__POR				(0x00)
#define TAPAN_A_QFUSE_DATA_OUT2			(0x04C)
#define TAPAN_A_QFUSE_DATA_OUT2__POR				(0x00)
#define TAPAN_A_QFUSE_DATA_OUT3			(0x04D)
#define TAPAN_A_QFUSE_DATA_OUT3__POR				(0x00)
#define TAPAN_A_QFUSE_DATA_OUT4			(0x04E)
#define TAPAN_A_QFUSE_DATA_OUT4__POR				(0x00)
#define TAPAN_A_QFUSE_DATA_OUT5			(0x04F)
#define TAPAN_A_QFUSE_DATA_OUT5__POR				(0x00)
#define TAPAN_A_QFUSE_DATA_OUT6			(0x050)
#define TAPAN_A_QFUSE_DATA_OUT6__POR				(0x00)
#define TAPAN_A_QFUSE_DATA_OUT7			(0x051)
#define TAPAN_A_QFUSE_DATA_OUT7__POR				(0x00)
#define TAPAN_A_CDC_CTL			(0x080)
#define TAPAN_A_CDC_CTL__POR				(0x00)
#define TAPAN_A_LEAKAGE_CTL			(0x088)
#define TAPAN_A_LEAKAGE_CTL__POR				(0x04)
#define TAPAN_A_INTR_MODE			(0x090)
#define TAPAN_A_INTR_MODE__POR				(0x00)
#define TAPAN_A_INTR_MASK0			(0x094)
#define TAPAN_A_INTR_MASK0__POR				(0xFF)
#define TAPAN_A_INTR_MASK1			(0x095)
#define TAPAN_A_INTR_MASK1__POR				(0xFF)
#define TAPAN_A_INTR_MASK2			(0x096)
#define TAPAN_A_INTR_MASK2__POR				(0x3F)
#define TAPAN_A_INTR_MASK3			(0x097)
#define TAPAN_A_INTR_MASK3__POR				(0x3F)
#define TAPAN_A_INTR_STATUS0			(0x098)
#define TAPAN_A_INTR_STATUS0__POR				(0x00)
#define TAPAN_A_INTR_STATUS1			(0x099)
#define TAPAN_A_INTR_STATUS1__POR				(0x00)
#define TAPAN_A_INTR_STATUS2			(0x09A)
#define TAPAN_A_INTR_STATUS2__POR				(0x00)
#define TAPAN_A_INTR_STATUS3			(0x09B)
#define TAPAN_A_INTR_STATUS3__POR				(0x00)
#define TAPAN_A_INTR_CLEAR0			(0x09C)
#define TAPAN_A_INTR_CLEAR0__POR				(0x00)
#define TAPAN_A_INTR_CLEAR1			(0x09D)
#define TAPAN_A_INTR_CLEAR1__POR				(0x00)
#define TAPAN_A_INTR_CLEAR2			(0x09E)
#define TAPAN_A_INTR_CLEAR2__POR				(0x00)
#define TAPAN_A_INTR_CLEAR3			(0x09F)
#define TAPAN_A_INTR_CLEAR3__POR				(0x00)
#define TAPAN_A_INTR_LEVEL0			(0x0A0)
#define TAPAN_A_INTR_LEVEL0__POR				(0x01)
#define TAPAN_A_INTR_LEVEL1			(0x0A1)
#define TAPAN_A_INTR_LEVEL1__POR				(0x00)
#define TAPAN_A_INTR_LEVEL2			(0x0A2)
#define TAPAN_A_INTR_LEVEL2__POR				(0x00)
#define TAPAN_A_INTR_LEVEL3			(0x0A3)
#define TAPAN_A_INTR_LEVEL3__POR				(0x00)
#define TAPAN_A_INTR_TEST0			(0x0A4)
#define TAPAN_A_INTR_TEST0__POR				(0x00)
#define TAPAN_A_INTR_TEST1			(0x0A5)
#define TAPAN_A_INTR_TEST1__POR				(0x00)
#define TAPAN_A_INTR_TEST2			(0x0A6)
#define TAPAN_A_INTR_TEST2__POR				(0x00)
#define TAPAN_A_INTR_TEST3			(0x0A7)
#define TAPAN_A_INTR_TEST3__POR				(0x00)
#define TAPAN_A_INTR_SET0			(0x0A8)
#define TAPAN_A_INTR_SET0__POR				(0x00)
#define TAPAN_A_INTR_SET1			(0x0A9)
#define TAPAN_A_INTR_SET1__POR				(0x00)
#define TAPAN_A_INTR_SET2			(0x0AA)
#define TAPAN_A_INTR_SET2__POR				(0x00)
#define TAPAN_A_INTR_SET3			(0x0AB)
#define TAPAN_A_INTR_SET3__POR				(0x00)
#define TAPAN_A_INTR_DESTN0			(0x0AC)
#define TAPAN_A_INTR_DESTN0__POR				(0x00)
#define TAPAN_A_INTR_DESTN1			(0x0AD)
#define TAPAN_A_INTR_DESTN1__POR				(0x00)
#define TAPAN_A_INTR_DESTN2			(0x0AE)
#define TAPAN_A_INTR_DESTN2__POR				(0x00)
#define TAPAN_A_INTR_DESTN3			(0x0AF)
#define TAPAN_A_INTR_DESTN3__POR				(0x00)
#define TAPAN_A_CDC_DMIC_DATA0_MODE			(0x0C0)
#define TAPAN_A_CDC_DMIC_DATA0_MODE__POR				(0x00)
#define TAPAN_A_CDC_DMIC_CLK0_MODE			(0x0C1)
#define TAPAN_A_CDC_DMIC_CLK0_MODE__POR				(0x00)
#define TAPAN_A_CDC_DMIC_DATA1_MODE			(0x0C2)
#define TAPAN_A_CDC_DMIC_DATA1_MODE__POR				(0x00)
#define TAPAN_A_CDC_DMIC_CLK1_MODE			(0x0C3)
#define TAPAN_A_CDC_DMIC_CLK1_MODE__POR				(0x00)
#define TAPAN_A_CDC_INTR_MODE			(0x0C4)
#define TAPAN_A_CDC_INTR_MODE__POR				(0x00)
#define TAPAN_A_BIAS_REF_CTL			(0x100)
#define TAPAN_A_BIAS_REF_CTL__POR				(0x1C)
#define TAPAN_A_BIAS_CENTRAL_BG_CTL			(0x101)
#define TAPAN_A_BIAS_CENTRAL_BG_CTL__POR				(0x50)
#define TAPAN_A_BIAS_PRECHRG_CTL			(0x102)
#define TAPAN_A_BIAS_PRECHRG_CTL__POR				(0x07)
#define TAPAN_A_BIAS_CURR_CTL_1			(0x103)
#define TAPAN_A_BIAS_CURR_CTL_1__POR				(0x52)
#define TAPAN_A_BIAS_CURR_CTL_2			(0x104)
#define TAPAN_A_BIAS_CURR_CTL_2__POR				(0x00)
#define TAPAN_A_BIAS_OSC_BG_CTL			(0x105)
#define TAPAN_A_BIAS_OSC_BG_CTL__POR				(0x16)
#define TAPAN_A_CLK_BUFF_EN1			(0x108)
#define TAPAN_A_CLK_BUFF_EN1__POR				(0x04)
#define TAPAN_A_CLK_BUFF_EN2			(0x109)
#define TAPAN_A_CLK_BUFF_EN2__POR				(0x02)
#define TAPAN_A_LDO_H_MODE_1			(0x110)
#define TAPAN_A_LDO_H_MODE_1__POR				(0x65)
#define TAPAN_A_LDO_H_MODE_2			(0x111)
#define TAPAN_A_LDO_H_MODE_2__POR				(0xA8)
#define TAPAN_A_LDO_H_LOOP_CTL			(0x112)
#define TAPAN_A_LDO_H_LOOP_CTL__POR				(0x6B)
#define TAPAN_A_LDO_H_COMP_1			(0x113)
#define TAPAN_A_LDO_H_COMP_1__POR				(0x84)
#define TAPAN_A_LDO_H_COMP_2			(0x114)
#define TAPAN_A_LDO_H_COMP_2__POR				(0xE0)
#define TAPAN_A_LDO_H_BIAS_1			(0x115)
#define TAPAN_A_LDO_H_BIAS_1__POR				(0x6D)
#define TAPAN_A_LDO_H_BIAS_2			(0x116)
#define TAPAN_A_LDO_H_BIAS_2__POR				(0xA5)
#define TAPAN_A_LDO_H_BIAS_3			(0x117)
#define TAPAN_A_LDO_H_BIAS_3__POR				(0x60)
#define TAPAN_A_MICB_CFILT_1_CTL			(0x128)
#define TAPAN_A_MICB_CFILT_1_CTL__POR				(0x40)
#define TAPAN_A_MICB_CFILT_1_VAL			(0x129)
#define TAPAN_A_MICB_CFILT_1_VAL__POR				(0x80)
#define TAPAN_A_MICB_CFILT_1_PRECHRG			(0x12A)
#define TAPAN_A_MICB_CFILT_1_PRECHRG__POR				(0x00)
#define TAPAN_A_MICB_1_CTL			(0x12B)
#define TAPAN_A_MICB_1_CTL__POR				(0x02)
#define TAPAN_A_MICB_1_INT_RBIAS			(0x12C)
#define TAPAN_A_MICB_1_INT_RBIAS__POR				(0x24)
#define TAPAN_A_MICB_1_MBHC			(0x12D)
#define TAPAN_A_MICB_1_MBHC__POR				(0x01)
#define TAPAN_A_MICB_CFILT_2_CTL			(0x12E)
#define TAPAN_A_MICB_CFILT_2_CTL__POR				(0x40)
#define TAPAN_A_MICB_CFILT_2_VAL			(0x12F)
#define TAPAN_A_MICB_CFILT_2_VAL__POR				(0x80)
#define TAPAN_A_MICB_CFILT_2_PRECHRG			(0x130)
#define TAPAN_A_MICB_CFILT_2_PRECHRG__POR				(0x00)
#define TAPAN_A_MICB_2_CTL			(0x131)
#define TAPAN_A_MICB_2_CTL__POR				(0x12)
#define TAPAN_A_MICB_2_INT_RBIAS			(0x132)
#define TAPAN_A_MICB_2_INT_RBIAS__POR				(0x24)
#define TAPAN_A_MICB_2_MBHC			(0x133)
#define TAPAN_A_MICB_2_MBHC__POR				(0x02)
#define TAPAN_A_MICB_CFILT_3_CTL			(0x134)
#define TAPAN_A_MICB_CFILT_3_CTL__POR				(0x40)
#define TAPAN_A_MICB_CFILT_3_VAL			(0x135)
#define TAPAN_A_MICB_CFILT_3_VAL__POR				(0x80)
#define TAPAN_A_MICB_CFILT_3_PRECHRG			(0x136)
#define TAPAN_A_MICB_CFILT_3_PRECHRG__POR				(0x00)
#define TAPAN_A_MICB_3_CTL			(0x137)
#define TAPAN_A_MICB_3_CTL__POR				(0x02)
#define TAPAN_A_MICB_3_INT_RBIAS			(0x138)
#define TAPAN_A_MICB_3_INT_RBIAS__POR				(0x24)
#define TAPAN_A_MICB_3_MBHC			(0x139)
#define TAPAN_A_MICB_3_MBHC__POR				(0x00)
#define TAPAN_A_MBHC_INSERT_DETECT			(0x14A)
#define TAPAN_A_MBHC_INSERT_DETECT__POR				(0x00)
#define TAPAN_A_MBHC_INSERT_DET_STATUS			(0x14B)
#define TAPAN_A_MBHC_INSERT_DET_STATUS__POR				(0x00)
#define TAPAN_A_TX_COM_BIAS			(0x14C)
#define TAPAN_A_TX_COM_BIAS__POR				(0xF0)
#define TAPAN_A_MBHC_SCALING_MUX_1			(0x14E)
#define TAPAN_A_MBHC_SCALING_MUX_1__POR				(0x00)
#define TAPAN_A_MBHC_SCALING_MUX_2			(0x14F)
#define TAPAN_A_MBHC_SCALING_MUX_2__POR				(0x80)
#define TAPAN_A_RESERVED_MAD_ANA_CTRL			(0x150)
#define TAPAN_A_RESERVED_MAD_ANA_CTRL__POR				(0xF1)
#define TAPAN_A_TX_SUP_SWITCH_CTRL_1			(0x151)
#define TAPAN_A_TX_SUP_SWITCH_CTRL_1__POR				(0x00)
#define TAPAN_A_TX_SUP_SWITCH_CTRL_2			(0x152)
#define TAPAN_A_TX_SUP_SWITCH_CTRL_2__POR				(0x80)
#define TAPAN_A_TX_1_EN			(0x153)
#define TAPAN_A_TX_1_EN__POR				(0x02)
#define TAPAN_A_TX_2_EN			(0x154)
#define TAPAN_A_TX_2_EN__POR				(0x02)
#define TAPAN_A_TX_1_2_ADC_CH1			(0x155)
#define TAPAN_A_TX_1_2_ADC_CH1__POR				(0x44)
#define TAPAN_A_TX_1_2_ADC_CH2			(0x156)
#define TAPAN_A_TX_1_2_ADC_CH2__POR				(0x44)
#define TAPAN_A_TX_1_2_ATEST_REFCTRL			(0x157)
#define TAPAN_A_TX_1_2_ATEST_REFCTRL__POR				(0x00)
#define TAPAN_A_TX_1_2_TEST_CTL			(0x158)
#define TAPAN_A_TX_1_2_TEST_CTL__POR				(0x38)
#define TAPAN_A_TX_1_2_TEST_BLOCK_EN			(0x159)
#define TAPAN_A_TX_1_2_TEST_BLOCK_EN__POR				(0xFC)
#define TAPAN_A_TX_1_2_TXFE_CLKDIV			(0x15A)
#define TAPAN_A_TX_1_2_TXFE_CLKDIV__POR				(0x55)
#define TAPAN_A_TX_1_2_SAR_ERR_CH1			(0x15B)
#define TAPAN_A_TX_1_2_SAR_ERR_CH1__POR				(0x00)
#define TAPAN_A_TX_1_2_SAR_ERR_CH2			(0x15C)
#define TAPAN_A_TX_1_2_SAR_ERR_CH2__POR				(0x00)
#define TAPAN_A_TX_3_EN			(0x15D)
#define TAPAN_A_TX_3_EN__POR				(0x00)
#define TAPAN_A_TX_1_2_TEST_EN			(0x15E)
#define TAPAN_A_TX_1_2_TEST_EN__POR				(0xCC)
#define TAPAN_A_TX_4_5_TXFE_SC_CTL			(0x15F)
#define TAPAN_A_TX_4_5_TXFE_SC_CTL__POR				(0x00)
#define TAPAN_A_TX_4_5_TEST_EN			(0x160)
#define TAPAN_A_TX_4_5_TEST_EN__POR				(0xCC)
#define TAPAN_A_TX_4_EN			(0x167)
#define TAPAN_A_TX_4_EN__POR				(0x02)
#define TAPAN_A_TX_5_EN			(0x168)
#define TAPAN_A_TX_5_EN__POR				(0x02)
#define TAPAN_A_TX_4_5_ADC_CH4			(0x169)
#define TAPAN_A_TX_4_5_ADC_CH4__POR				(0x44)
#define TAPAN_A_TX_4_5_ADC_CH5			(0x16A)
#define TAPAN_A_TX_4_5_ADC_CH5__POR				(0x44)
#define TAPAN_A_TX_4_5_ATEST_REFCTRL			(0x16B)
#define TAPAN_A_TX_4_5_ATEST_REFCTRL__POR				(0x00)
#define TAPAN_A_TX_4_5_TEST_CTL			(0x16C)
#define TAPAN_A_TX_4_5_TEST_CTL__POR				(0x38)
#define TAPAN_A_TX_4_5_TEST_BLOCK_EN			(0x16D)
#define TAPAN_A_TX_4_5_TEST_BLOCK_EN__POR				(0xFC)
#define TAPAN_A_TX_4_5_TXFE_CKDIV			(0x16E)
#define TAPAN_A_TX_4_5_TXFE_CKDIV__POR				(0x55)
#define TAPAN_A_TX_4_5_SAR_ERR_CH4			(0x16F)
#define TAPAN_A_TX_4_5_SAR_ERR_CH4__POR				(0x00)
#define TAPAN_A_TX_4_5_SAR_ERR_CH5			(0x170)
#define TAPAN_A_TX_4_5_SAR_ERR_CH5__POR				(0x00)
#define TAPAN_A_TX_7_MBHC_EN			(0x171)
#define TAPAN_A_TX_7_MBHC_EN__POR				(0x0C)
#define TAPAN_A_TX_7_MBHC_ATEST_REFCTRL			(0x172)
#define TAPAN_A_TX_7_MBHC_ATEST_REFCTRL__POR				(0x00)
#define TAPAN_A_TX_7_MBHC_ADC			(0x173)
#define TAPAN_A_TX_7_MBHC_ADC__POR				(0x44)
#define TAPAN_A_TX_7_MBHC_TEST_CTL			(0x174)
#define TAPAN_A_TX_7_MBHC_TEST_CTL__POR				(0x38)
#define TAPAN_A_TX_7_MBHC_SAR_ERR			(0x175)
#define TAPAN_A_TX_7_MBHC_SAR_ERR__POR				(0x00)
#define TAPAN_A_TX_7_TXFE_CLKDIV			(0x176)
#define TAPAN_A_TX_7_TXFE_CLKDIV__POR				(0x0B)
#define TAPAN_A_BUCK_MODE_1			(0x181)
#define TAPAN_A_BUCK_MODE_1__POR				(0x21)
#define TAPAN_A_BUCK_MODE_2			(0x182)
#define TAPAN_A_BUCK_MODE_2__POR				(0xFF)
#define TAPAN_A_BUCK_MODE_3			(0x183)
#define TAPAN_A_BUCK_MODE_3__POR				(0xCE)
#define TAPAN_A_BUCK_MODE_4			(0x184)
#define TAPAN_A_BUCK_MODE_4__POR				(0x3A)
#define TAPAN_A_BUCK_MODE_5			(0x185)
#define TAPAN_A_BUCK_MODE_5__POR				(0x00)
#define TAPAN_A_BUCK_CTRL_VCL_1			(0x186)
#define TAPAN_A_BUCK_CTRL_VCL_1__POR				(0x08)
#define TAPAN_A_BUCK_CTRL_VCL_2			(0x187)
#define TAPAN_A_BUCK_CTRL_VCL_2__POR				(0xA3)
#define TAPAN_A_BUCK_CTRL_VCL_3			(0x188)
#define TAPAN_A_BUCK_CTRL_VCL_3__POR				(0x82)
#define TAPAN_A_BUCK_CTRL_CCL_1			(0x189)
#define TAPAN_A_BUCK_CTRL_CCL_1__POR				(0x5B)
#define TAPAN_A_BUCK_CTRL_CCL_2			(0x18A)
#define TAPAN_A_BUCK_CTRL_CCL_2__POR				(0xDC)
#define TAPAN_A_BUCK_CTRL_CCL_3			(0x18B)
#define TAPAN_A_BUCK_CTRL_CCL_3__POR				(0x6A)
#define TAPAN_A_BUCK_CTRL_CCL_4			(0x18C)
#define TAPAN_A_BUCK_CTRL_CCL_4__POR				(0x50)
#define TAPAN_A_BUCK_CTRL_PWM_DRVR_1			(0x18D)
#define TAPAN_A_BUCK_CTRL_PWM_DRVR_1__POR				(0x50)
#define TAPAN_A_BUCK_CTRL_PWM_DRVR_2			(0x18E)
#define TAPAN_A_BUCK_CTRL_PWM_DRVR_2__POR				(0x64)
#define TAPAN_A_BUCK_CTRL_PWM_DRVR_3			(0x18F)
#define TAPAN_A_BUCK_CTRL_PWM_DRVR_3__POR				(0x77)
#define TAPAN_A_BUCK_TMUX_A_D			(0x190)
#define TAPAN_A_BUCK_TMUX_A_D__POR				(0x00)
#define TAPAN_A_NCP_BUCKREF			(0x191)
#define TAPAN_A_NCP_BUCKREF__POR				(0x00)
#define TAPAN_A_NCP_EN			(0x192)
#define TAPAN_A_NCP_EN__POR				(0xFE)
#define TAPAN_A_NCP_CLK			(0x193)
#define TAPAN_A_NCP_CLK__POR				(0x94)
#define TAPAN_A_NCP_STATIC			(0x194)
#define TAPAN_A_NCP_STATIC__POR				(0x28)
#define TAPAN_A_NCP_VTH_LOW			(0x195)
#define TAPAN_A_NCP_VTH_LOW__POR				(0x88)
#define TAPAN_A_NCP_VTH_HIGH			(0x196)
#define TAPAN_A_NCP_VTH_HIGH__POR				(0xA0)
#define TAPAN_A_NCP_ATEST			(0x197)
#define TAPAN_A_NCP_ATEST__POR				(0x00)
#define TAPAN_A_NCP_DTEST			(0x198)
#define TAPAN_A_NCP_DTEST__POR				(0x10)
#define TAPAN_A_NCP_DLY1			(0x199)
#define TAPAN_A_NCP_DLY1__POR				(0x06)
#define TAPAN_A_NCP_DLY2			(0x19A)
#define TAPAN_A_NCP_DLY2__POR				(0x06)
#define TAPAN_A_RX_AUX_SW_CTL			(0x19B)
#define TAPAN_A_RX_AUX_SW_CTL__POR				(0x00)
#define TAPAN_A_RX_PA_AUX_IN_CONN			(0x19C)
#define TAPAN_A_RX_PA_AUX_IN_CONN__POR				(0x00)
#define TAPAN_A_RX_COM_TIMER_DIV			(0x19E)
#define TAPAN_A_RX_COM_TIMER_DIV__POR				(0xE8)
#define TAPAN_A_RX_COM_OCP_CTL			(0x19F)
#define TAPAN_A_RX_COM_OCP_CTL__POR				(0x1F)
#define TAPAN_A_RX_COM_OCP_COUNT			(0x1A0)
#define TAPAN_A_RX_COM_OCP_COUNT__POR				(0x77)
#define TAPAN_A_RX_COM_DAC_CTL			(0x1A1)
#define TAPAN_A_RX_COM_DAC_CTL__POR				(0x00)
#define TAPAN_A_RX_COM_BIAS			(0x1A2)
#define TAPAN_A_RX_COM_BIAS__POR				(0x00)
#define TAPAN_A_RX_HPH_AUTO_CHOP			(0x1A4)
#define TAPAN_A_RX_HPH_AUTO_CHOP__POR				(0x38)
#define TAPAN_A_RX_HPH_CHOP_CTL			(0x1A5)
#define TAPAN_A_RX_HPH_CHOP_CTL__POR				(0xA4)
#define TAPAN_A_RX_HPH_BIAS_PA			(0x1A6)
#define TAPAN_A_RX_HPH_BIAS_PA__POR				(0x7A)
#define TAPAN_A_RX_HPH_BIAS_LDO			(0x1A7)
#define TAPAN_A_RX_HPH_BIAS_LDO__POR				(0x87)
#define TAPAN_A_RX_HPH_BIAS_CNP			(0x1A8)
#define TAPAN_A_RX_HPH_BIAS_CNP__POR				(0x8A)
#define TAPAN_A_RX_HPH_BIAS_WG_OCP			(0x1A9)
#define TAPAN_A_RX_HPH_BIAS_WG_OCP__POR				(0x2A)
#define TAPAN_A_RX_HPH_OCP_CTL			(0x1AA)
#define TAPAN_A_RX_HPH_OCP_CTL__POR				(0x69)
#define TAPAN_A_RX_HPH_CNP_EN			(0x1AB)
#define TAPAN_A_RX_HPH_CNP_EN__POR				(0x80)
#define TAPAN_A_RX_HPH_CNP_WG_CTL			(0x1AC)
#define TAPAN_A_RX_HPH_CNP_WG_CTL__POR				(0xDE)
#define TAPAN_A_RX_HPH_CNP_WG_TIME			(0x1AD)
#define TAPAN_A_RX_HPH_CNP_WG_TIME__POR				(0x15)
#define TAPAN_A_RX_HPH_L_GAIN			(0x1AE)
#define TAPAN_A_RX_HPH_L_GAIN__POR				(0x00)
#define TAPAN_A_RX_HPH_L_TEST			(0x1AF)
#define TAPAN_A_RX_HPH_L_TEST__POR				(0x00)
#define TAPAN_A_RX_HPH_L_PA_CTL			(0x1B0)
#define TAPAN_A_RX_HPH_L_PA_CTL__POR				(0x40)
#define TAPAN_A_RX_HPH_L_DAC_CTL			(0x1B1)
#define TAPAN_A_RX_HPH_L_DAC_CTL__POR				(0x00)
#define TAPAN_A_RX_HPH_L_ATEST			(0x1B2)
#define TAPAN_A_RX_HPH_L_ATEST__POR				(0x00)
#define TAPAN_A_RX_HPH_L_STATUS			(0x1B3)
#define TAPAN_A_RX_HPH_L_STATUS__POR				(0x00)
#define TAPAN_A_RX_HPH_R_GAIN			(0x1B4)
#define TAPAN_A_RX_HPH_R_GAIN__POR				(0x00)
#define TAPAN_A_RX_HPH_R_TEST			(0x1B5)
#define TAPAN_A_RX_HPH_R_TEST__POR				(0x00)
#define TAPAN_A_RX_HPH_R_PA_CTL			(0x1B6)
#define TAPAN_A_RX_HPH_R_PA_CTL__POR				(0x40)
#define TAPAN_A_RX_HPH_R_DAC_CTL			(0x1B7)
#define TAPAN_A_RX_HPH_R_DAC_CTL__POR				(0x00)
#define TAPAN_A_RX_HPH_R_ATEST			(0x1B8)
#define TAPAN_A_RX_HPH_R_ATEST__POR				(0x00)
#define TAPAN_A_RX_HPH_R_STATUS			(0x1B9)
#define TAPAN_A_RX_HPH_R_STATUS__POR				(0x00)
#define TAPAN_A_RX_EAR_BIAS_PA			(0x1BA)
#define TAPAN_A_RX_EAR_BIAS_PA__POR				(0x76)
#define TAPAN_A_RX_EAR_BIAS_CMBUFF			(0x1BB)
#define TAPAN_A_RX_EAR_BIAS_CMBUFF__POR				(0xA0)
#define TAPAN_A_RX_EAR_EN			(0x1BC)
#define TAPAN_A_RX_EAR_EN__POR				(0x00)
#define TAPAN_A_RX_EAR_GAIN			(0x1BD)
#define TAPAN_A_RX_EAR_GAIN__POR				(0x02)
#define TAPAN_A_RX_EAR_CMBUFF			(0x1BE)
#define TAPAN_A_RX_EAR_CMBUFF__POR				(0x05)
#define TAPAN_A_RX_EAR_ICTL			(0x1BF)
#define TAPAN_A_RX_EAR_ICTL__POR				(0x40)
#define TAPAN_A_RX_EAR_CCOMP			(0x1C0)
#define TAPAN_A_RX_EAR_CCOMP__POR				(0x08)
#define TAPAN_A_RX_EAR_VCM			(0x1C1)
#define TAPAN_A_RX_EAR_VCM__POR				(0x03)
#define TAPAN_A_RX_EAR_CNP			(0x1C2)
#define TAPAN_A_RX_EAR_CNP__POR				(0xF2)
#define TAPAN_A_RX_EAR_DAC_CTL_ATEST			(0x1C3)
#define TAPAN_A_RX_EAR_DAC_CTL_ATEST__POR				(0x00)
#define TAPAN_A_RX_EAR_STATUS			(0x1C5)
#define TAPAN_A_RX_EAR_STATUS__POR				(0x04)
#define TAPAN_A_RX_LINE_BIAS_PA			(0x1C6)
#define TAPAN_A_RX_LINE_BIAS_PA__POR				(0x78)
#define TAPAN_A_RX_BUCK_BIAS1			(0x1C7)
#define TAPAN_A_RX_BUCK_BIAS1__POR				(0x42)
#define TAPAN_A_RX_BUCK_BIAS2			(0x1C8)
#define TAPAN_A_RX_BUCK_BIAS2__POR				(0x84)
#define TAPAN_A_RX_LINE_COM			(0x1C9)
#define TAPAN_A_RX_LINE_COM__POR				(0x80)
#define TAPAN_A_RX_LINE_CNP_EN			(0x1CA)
#define TAPAN_A_RX_LINE_CNP_EN__POR				(0x00)
#define TAPAN_A_RX_LINE_CNP_WG_CTL			(0x1CB)
#define TAPAN_A_RX_LINE_CNP_WG_CTL__POR				(0x00)
#define TAPAN_A_RX_LINE_CNP_WG_TIME			(0x1CC)
#define TAPAN_A_RX_LINE_CNP_WG_TIME__POR				(0x04)
#define TAPAN_A_RX_LINE_1_GAIN			(0x1CD)
#define TAPAN_A_RX_LINE_1_GAIN__POR				(0x00)
#define TAPAN_A_RX_LINE_1_TEST			(0x1CE)
#define TAPAN_A_RX_LINE_1_TEST__POR				(0x00)
#define TAPAN_A_RX_LINE_1_DAC_CTL			(0x1CF)
#define TAPAN_A_RX_LINE_1_DAC_CTL__POR				(0x00)
#define TAPAN_A_RX_LINE_1_STATUS			(0x1D0)
#define TAPAN_A_RX_LINE_1_STATUS__POR				(0x00)
#define TAPAN_A_RX_LINE_2_GAIN			(0x1D1)
#define TAPAN_A_RX_LINE_2_GAIN__POR				(0x00)
#define TAPAN_A_RX_LINE_2_TEST			(0x1D2)
#define TAPAN_A_RX_LINE_2_TEST__POR				(0x00)
#define TAPAN_A_RX_LINE_2_DAC_CTL			(0x1D3)
#define TAPAN_A_RX_LINE_2_DAC_CTL__POR				(0x00)
#define TAPAN_A_RX_LINE_2_STATUS			(0x1D4)
#define TAPAN_A_RX_LINE_2_STATUS__POR				(0x00)
#define TAPAN_A_RX_LINE_CNP_DBG			(0x1DD)
#define TAPAN_A_RX_LINE_CNP_DBG__POR				(0x00)
#define TAPAN_A_SPKR_DRV_EN			(0x1DF)
#define TAPAN_A_SPKR_DRV_EN__POR				(0x6F)
#define TAPAN_A_SPKR_DRV_GAIN			(0x1E0)
#define TAPAN_A_SPKR_DRV_GAIN__POR				(0x00)
#define TAPAN_A_SPKR_DRV_DAC_CTL			(0x1E1)
#define TAPAN_A_SPKR_DRV_DAC_CTL__POR				(0x04)
#define TAPAN_A_SPKR_DRV_OCP_CTL			(0x1E2)
#define TAPAN_A_SPKR_DRV_OCP_CTL__POR				(0x98)
#define TAPAN_A_SPKR_DRV_CLIP_DET			(0x1E3)
#define TAPAN_A_SPKR_DRV_CLIP_DET__POR				(0x48)
#define TAPAN_A_SPKR_DRV_IEC			(0x1E4)
#define TAPAN_A_SPKR_DRV_IEC__POR				(0x28)
#define TAPAN_A_SPKR_DRV_DBG_DAC			(0x1E5)
#define TAPAN_A_SPKR_DRV_DBG_DAC__POR				(0x05)
#define TAPAN_A_SPKR_DRV_DBG_PA			(0x1E6)
#define TAPAN_A_SPKR_DRV_DBG_PA__POR				(0x18)
#define TAPAN_A_SPKR_DRV_DBG_PWRSTG			(0x1E7)
#define TAPAN_A_SPKR_DRV_DBG_PWRSTG__POR				(0x00)
#define TAPAN_A_SPKR_DRV_BIAS_LDO			(0x1E8)
#define TAPAN_A_SPKR_DRV_BIAS_LDO__POR				(0x45)
#define TAPAN_A_SPKR_DRV_BIAS_INT			(0x1E9)
#define TAPAN_A_SPKR_DRV_BIAS_INT__POR				(0xA5)
#define TAPAN_A_SPKR_DRV_BIAS_PA			(0x1EA)
#define TAPAN_A_SPKR_DRV_BIAS_PA__POR				(0x55)
#define TAPAN_A_SPKR_DRV_STATUS_OCP			(0x1EB)
#define TAPAN_A_SPKR_DRV_STATUS_OCP__POR				(0x00)
#define TAPAN_A_SPKR_DRV_STATUS_PA			(0x1EC)
#define TAPAN_A_SPKR_DRV_STATUS_PA__POR				(0x00)
#define TAPAN_A_RC_OSC_FREQ			(0x1FA)
#define TAPAN_A_RC_OSC_FREQ__POR				(0x46)
#define TAPAN_A_RC_OSC_TEST			(0x1FB)
#define TAPAN_A_RC_OSC_TEST__POR				(0x0A)
#define TAPAN_A_RC_OSC_STATUS			(0x1FC)
#define TAPAN_A_RC_OSC_STATUS__POR				(0x18)
#define TAPAN_A_RC_OSC_TUNER			(0x1FD)
#define TAPAN_A_RC_OSC_TUNER__POR				(0x00)
#define TAPAN_A_MBHC_HPH			(0x1FE)
#define TAPAN_A_MBHC_HPH__POR				(0x44)
#define TAPAN_A_CDC_ANC1_B1_CTL			(0x200)
#define TAPAN_A_CDC_ANC1_B1_CTL__POR				(0x00)
#define TAPAN_A_CDC_ANC2_B1_CTL			(0x280)
#define TAPAN_A_CDC_ANC2_B1_CTL__POR				(0x00)
#define TAPAN_A_CDC_ANC1_SHIFT			(0x201)
#define TAPAN_A_CDC_ANC1_SHIFT__POR				(0x00)
#define TAPAN_A_CDC_ANC2_SHIFT			(0x281)
#define TAPAN_A_CDC_ANC2_SHIFT__POR				(0x00)
#define TAPAN_A_CDC_ANC1_IIR_B1_CTL			(0x202)
#define TAPAN_A_CDC_ANC1_IIR_B1_CTL__POR				(0x00)
#define TAPAN_A_CDC_ANC2_IIR_B1_CTL			(0x282)
#define TAPAN_A_CDC_ANC2_IIR_B1_CTL__POR				(0x00)
#define TAPAN_A_CDC_ANC1_IIR_B2_CTL			(0x203)
#define TAPAN_A_CDC_ANC1_IIR_B2_CTL__POR				(0x00)
#define TAPAN_A_CDC_ANC2_IIR_B2_CTL			(0x283)
#define TAPAN_A_CDC_ANC2_IIR_B2_CTL__POR				(0x00)
#define TAPAN_A_CDC_ANC1_IIR_B3_CTL			(0x204)
#define TAPAN_A_CDC_ANC1_IIR_B3_CTL__POR				(0x00)
#define TAPAN_A_CDC_ANC2_IIR_B3_CTL			(0x284)
#define TAPAN_A_CDC_ANC2_IIR_B3_CTL__POR				(0x00)
#define TAPAN_A_CDC_ANC1_LPF_B1_CTL			(0x206)
#define TAPAN_A_CDC_ANC1_LPF_B1_CTL__POR				(0x00)
#define TAPAN_A_CDC_ANC2_LPF_B1_CTL			(0x286)
#define TAPAN_A_CDC_ANC2_LPF_B1_CTL__POR				(0x00)
#define TAPAN_A_CDC_ANC1_LPF_B2_CTL			(0x207)
#define TAPAN_A_CDC_ANC1_LPF_B2_CTL__POR				(0x00)
#define TAPAN_A_CDC_ANC2_LPF_B2_CTL			(0x287)
#define TAPAN_A_CDC_ANC2_LPF_B2_CTL__POR				(0x00)
#define TAPAN_A_CDC_ANC1_SPARE			(0x209)
#define TAPAN_A_CDC_ANC1_SPARE__POR				(0x00)
#define TAPAN_A_CDC_ANC2_SPARE			(0x289)
#define TAPAN_A_CDC_ANC2_SPARE__POR				(0x00)
#define TAPAN_A_CDC_ANC1_SMLPF_CTL			(0x20A)
#define TAPAN_A_CDC_ANC1_SMLPF_CTL__POR				(0x00)
#define TAPAN_A_CDC_ANC2_SMLPF_CTL			(0x28A)
#define TAPAN_A_CDC_ANC2_SMLPF_CTL__POR				(0x00)
#define TAPAN_A_CDC_ANC1_DCFLT_CTL			(0x20B)
#define TAPAN_A_CDC_ANC1_DCFLT_CTL__POR				(0x00)
#define TAPAN_A_CDC_ANC2_DCFLT_CTL			(0x28B)
#define TAPAN_A_CDC_ANC2_DCFLT_CTL__POR				(0x00)
#define TAPAN_A_CDC_ANC1_GAIN_CTL			(0x20C)
#define TAPAN_A_CDC_ANC1_GAIN_CTL__POR				(0x00)
#define TAPAN_A_CDC_ANC2_GAIN_CTL			(0x28C)
#define TAPAN_A_CDC_ANC2_GAIN_CTL__POR				(0x00)
#define TAPAN_A_CDC_ANC1_B2_CTL			(0x20D)
#define TAPAN_A_CDC_ANC1_B2_CTL__POR				(0x00)
#define TAPAN_A_CDC_ANC2_B2_CTL			(0x28D)
#define TAPAN_A_CDC_ANC2_B2_CTL__POR				(0x00)
#define TAPAN_A_CDC_TX1_VOL_CTL_TIMER			(0x220)
#define TAPAN_A_CDC_TX1_VOL_CTL_TIMER__POR				(0x00)
#define TAPAN_A_CDC_TX2_VOL_CTL_TIMER			(0x228)
#define TAPAN_A_CDC_TX2_VOL_CTL_TIMER__POR				(0x00)
#define TAPAN_A_CDC_TX3_VOL_CTL_TIMER			(0x230)
#define TAPAN_A_CDC_TX3_VOL_CTL_TIMER__POR				(0x00)
#define TAPAN_A_CDC_TX4_VOL_CTL_TIMER			(0x238)
#define TAPAN_A_CDC_TX4_VOL_CTL_TIMER__POR				(0x00)
#define TAPAN_A_CDC_TX1_VOL_CTL_GAIN			(0x221)
#define TAPAN_A_CDC_TX1_VOL_CTL_GAIN__POR				(0x00)
#define TAPAN_A_CDC_TX2_VOL_CTL_GAIN			(0x229)
#define TAPAN_A_CDC_TX2_VOL_CTL_GAIN__POR				(0x00)
#define TAPAN_A_CDC_TX3_VOL_CTL_GAIN			(0x231)
#define TAPAN_A_CDC_TX3_VOL_CTL_GAIN__POR				(0x00)
#define TAPAN_A_CDC_TX4_VOL_CTL_GAIN			(0x239)
#define TAPAN_A_CDC_TX4_VOL_CTL_GAIN__POR				(0x00)
#define TAPAN_A_CDC_TX1_VOL_CTL_CFG			(0x222)
#define TAPAN_A_CDC_TX1_VOL_CTL_CFG__POR				(0x00)
#define TAPAN_A_CDC_TX2_VOL_CTL_CFG			(0x22A)
#define TAPAN_A_CDC_TX2_VOL_CTL_CFG__POR				(0x00)
#define TAPAN_A_CDC_TX3_VOL_CTL_CFG			(0x232)
#define TAPAN_A_CDC_TX3_VOL_CTL_CFG__POR				(0x00)
#define TAPAN_A_CDC_TX4_VOL_CTL_CFG			(0x23A)
#define TAPAN_A_CDC_TX4_VOL_CTL_CFG__POR				(0x00)
#define TAPAN_A_CDC_TX1_MUX_CTL			(0x223)
#define TAPAN_A_CDC_TX1_MUX_CTL__POR				(0x08)
#define TAPAN_A_CDC_TX2_MUX_CTL			(0x22B)
#define TAPAN_A_CDC_TX2_MUX_CTL__POR				(0x08)
#define TAPAN_A_CDC_TX3_MUX_CTL			(0x233)
#define TAPAN_A_CDC_TX3_MUX_CTL__POR				(0x08)
#define TAPAN_A_CDC_TX4_MUX_CTL			(0x23B)
#define TAPAN_A_CDC_TX4_MUX_CTL__POR				(0x08)
#define TAPAN_A_CDC_TX1_CLK_FS_CTL			(0x224)
#define TAPAN_A_CDC_TX1_CLK_FS_CTL__POR				(0x03)
#define TAPAN_A_CDC_TX2_CLK_FS_CTL			(0x22C)
#define TAPAN_A_CDC_TX2_CLK_FS_CTL__POR				(0x03)
#define TAPAN_A_CDC_TX3_CLK_FS_CTL			(0x234)
#define TAPAN_A_CDC_TX3_CLK_FS_CTL__POR				(0x03)
#define TAPAN_A_CDC_TX4_CLK_FS_CTL			(0x23C)
#define TAPAN_A_CDC_TX4_CLK_FS_CTL__POR				(0x03)
#define TAPAN_A_CDC_TX1_DMIC_CTL			(0x225)
#define TAPAN_A_CDC_TX1_DMIC_CTL__POR				(0x00)
#define TAPAN_A_CDC_TX2_DMIC_CTL			(0x22D)
#define TAPAN_A_CDC_TX2_DMIC_CTL__POR				(0x00)
#define TAPAN_A_CDC_TX3_DMIC_CTL			(0x235)
#define TAPAN_A_CDC_TX3_DMIC_CTL__POR				(0x00)
#define TAPAN_A_CDC_TX4_DMIC_CTL			(0x23D)
#define TAPAN_A_CDC_TX4_DMIC_CTL__POR				(0x00)
#define TAPAN_A_CDC_DEBUG_B1_CTL			(0x278)
#define TAPAN_A_CDC_DEBUG_B1_CTL__POR				(0x00)
#define TAPAN_A_CDC_DEBUG_B2_CTL			(0x279)
#define TAPAN_A_CDC_DEBUG_B2_CTL__POR				(0x00)
#define TAPAN_A_CDC_DEBUG_B3_CTL			(0x27A)
#define TAPAN_A_CDC_DEBUG_B3_CTL__POR				(0x00)
#define TAPAN_A_CDC_DEBUG_B4_CTL			(0x27B)
#define TAPAN_A_CDC_DEBUG_B4_CTL__POR				(0x00)
#define TAPAN_A_CDC_DEBUG_B5_CTL			(0x27C)
#define TAPAN_A_CDC_DEBUG_B5_CTL__POR				(0x00)
#define TAPAN_A_CDC_DEBUG_B6_CTL			(0x27D)
#define TAPAN_A_CDC_DEBUG_B6_CTL__POR				(0x00)
#define TAPAN_A_CDC_DEBUG_B7_CTL			(0x27E)
#define TAPAN_A_CDC_DEBUG_B7_CTL__POR				(0x00)
#define TAPAN_A_CDC_SRC1_PDA_CFG			(0x2A0)
#define TAPAN_A_CDC_SRC1_PDA_CFG__POR				(0x00)
#define TAPAN_A_CDC_SRC2_PDA_CFG			(0x2A8)
#define TAPAN_A_CDC_SRC2_PDA_CFG__POR				(0x00)
#define TAPAN_A_CDC_SRC1_FS_CTL			(0x2A1)
#define TAPAN_A_CDC_SRC1_FS_CTL__POR				(0x1B)
#define TAPAN_A_CDC_SRC2_FS_CTL			(0x2A9)
#define TAPAN_A_CDC_SRC2_FS_CTL__POR				(0x1B)
#define TAPAN_A_CDC_RX1_B1_CTL			(0x2B0)
#define TAPAN_A_CDC_RX1_B1_CTL__POR				(0x00)
#define TAPAN_A_CDC_RX2_B1_CTL			(0x2B8)
#define TAPAN_A_CDC_RX2_B1_CTL__POR				(0x00)
#define TAPAN_A_CDC_RX3_B1_CTL			(0x2C0)
#define TAPAN_A_CDC_RX3_B1_CTL__POR				(0x00)
#define TAPAN_A_CDC_RX4_B1_CTL			(0x2C8)
#define TAPAN_A_CDC_RX4_B1_CTL__POR				(0x00)
#define TAPAN_A_CDC_RX1_B2_CTL			(0x2B1)
#define TAPAN_A_CDC_RX1_B2_CTL__POR				(0x00)
#define TAPAN_A_CDC_RX2_B2_CTL			(0x2B9)
#define TAPAN_A_CDC_RX2_B2_CTL__POR				(0x00)
#define TAPAN_A_CDC_RX3_B2_CTL			(0x2C1)
#define TAPAN_A_CDC_RX3_B2_CTL__POR				(0x00)
#define TAPAN_A_CDC_RX4_B2_CTL			(0x2C9)
#define TAPAN_A_CDC_RX4_B2_CTL__POR				(0x00)
#define TAPAN_A_CDC_RX1_B3_CTL			(0x2B2)
#define TAPAN_A_CDC_RX1_B3_CTL__POR				(0x00)
#define TAPAN_A_CDC_RX2_B3_CTL			(0x2BA)
#define TAPAN_A_CDC_RX2_B3_CTL__POR				(0x00)
#define TAPAN_A_CDC_RX3_B3_CTL			(0x2C2)
#define TAPAN_A_CDC_RX3_B3_CTL__POR				(0x00)
#define TAPAN_A_CDC_RX4_B3_CTL			(0x2CA)
#define TAPAN_A_CDC_RX4_B3_CTL__POR				(0x00)
#define TAPAN_A_CDC_RX1_B4_CTL			(0x2B3)
#define TAPAN_A_CDC_RX1_B4_CTL__POR				(0x00)
#define TAPAN_A_CDC_RX2_B4_CTL			(0x2BB)
#define TAPAN_A_CDC_RX2_B4_CTL__POR				(0x00)
#define TAPAN_A_CDC_RX3_B4_CTL			(0x2C3)
#define TAPAN_A_CDC_RX3_B4_CTL__POR				(0x00)
#define TAPAN_A_CDC_RX4_B4_CTL			(0x2CB)
#define TAPAN_A_CDC_RX4_B4_CTL__POR				(0x00)
#define TAPAN_A_CDC_RX1_B5_CTL			(0x2B4)
#define TAPAN_A_CDC_RX1_B5_CTL__POR				(0x78)
#define TAPAN_A_CDC_RX2_B5_CTL			(0x2BC)
#define TAPAN_A_CDC_RX2_B5_CTL__POR				(0x78)
#define TAPAN_A_CDC_RX3_B5_CTL			(0x2C4)
#define TAPAN_A_CDC_RX3_B5_CTL__POR				(0x78)
#define TAPAN_A_CDC_RX4_B5_CTL			(0x2CC)
#define TAPAN_A_CDC_RX4_B5_CTL__POR				(0x78)
#define TAPAN_A_CDC_RX1_B6_CTL			(0x2B5)
#define TAPAN_A_CDC_RX1_B6_CTL__POR				(0x80)
#define TAPAN_A_CDC_RX2_B6_CTL			(0x2BD)
#define TAPAN_A_CDC_RX2_B6_CTL__POR				(0x80)
#define TAPAN_A_CDC_RX3_B6_CTL			(0x2C5)
#define TAPAN_A_CDC_RX3_B6_CTL__POR				(0x80)
#define TAPAN_A_CDC_RX4_B6_CTL			(0x2CD)
#define TAPAN_A_CDC_RX4_B6_CTL__POR				(0x80)
#define TAPAN_A_CDC_RX1_VOL_CTL_B1_CTL			(0x2B6)
#define TAPAN_A_CDC_RX1_VOL_CTL_B1_CTL__POR				(0x00)
#define TAPAN_A_CDC_RX2_VOL_CTL_B1_CTL			(0x2BE)
#define TAPAN_A_CDC_RX2_VOL_CTL_B1_CTL__POR				(0x00)
#define TAPAN_A_CDC_RX3_VOL_CTL_B1_CTL			(0x2C6)
#define TAPAN_A_CDC_RX3_VOL_CTL_B1_CTL__POR				(0x00)
#define TAPAN_A_CDC_RX4_VOL_CTL_B1_CTL			(0x2CE)
#define TAPAN_A_CDC_RX4_VOL_CTL_B1_CTL__POR				(0x00)
#define TAPAN_A_CDC_RX1_VOL_CTL_B2_CTL			(0x2B7)
#define TAPAN_A_CDC_RX1_VOL_CTL_B2_CTL__POR				(0x00)
#define TAPAN_A_CDC_RX2_VOL_CTL_B2_CTL			(0x2BF)
#define TAPAN_A_CDC_RX2_VOL_CTL_B2_CTL__POR				(0x00)
#define TAPAN_A_CDC_RX3_VOL_CTL_B2_CTL			(0x2C7)
#define TAPAN_A_CDC_RX3_VOL_CTL_B2_CTL__POR				(0x00)
#define TAPAN_A_CDC_RX4_VOL_CTL_B2_CTL			(0x2CF)
#define TAPAN_A_CDC_RX4_VOL_CTL_B2_CTL__POR				(0x00)
#define TAPAN_A_CDC_CLK_ANC_RESET_CTL			(0x300)
#define TAPAN_A_CDC_CLK_ANC_RESET_CTL__POR				(0x00)
#define TAPAN_A_CDC_CLK_RX_RESET_CTL			(0x301)
#define TAPAN_A_CDC_CLK_RX_RESET_CTL__POR				(0x00)
#define TAPAN_A_CDC_CLK_TX_RESET_B1_CTL			(0x302)
#define TAPAN_A_CDC_CLK_TX_RESET_B1_CTL__POR				(0x00)
#define TAPAN_A_CDC_CLK_TX_RESET_B2_CTL			(0x303)
#define TAPAN_A_CDC_CLK_TX_RESET_B2_CTL__POR				(0x00)
#define TAPAN_A_CDC_CLK_DMIC_B1_CTL			(0x304)
#define TAPAN_A_CDC_CLK_DMIC_B1_CTL__POR				(0x00)
#define TAPAN_A_CDC_CLK_DMIC_B2_CTL			(0x305)
#define TAPAN_A_CDC_CLK_DMIC_B2_CTL__POR				(0x00)
#define TAPAN_A_CDC_CLK_I2S_CTL			(0x306)
#define TAPAN_A_CDC_CLK_I2S_CTL__POR				(0x03)
#define TAPAN_A_CDC_CLK_OTHR_RESET_B1_CTL			(0x308)
#define TAPAN_A_CDC_CLK_OTHR_RESET_B1_CTL__POR				(0x00)
#define TAPAN_A_CDC_CLK_OTHR_RESET_B2_CTL			(0x309)
#define TAPAN_A_CDC_CLK_OTHR_RESET_B2_CTL__POR				(0x00)
#define TAPAN_A_CDC_CLK_TX_CLK_EN_B1_CTL			(0x30A)
#define TAPAN_A_CDC_CLK_TX_CLK_EN_B1_CTL__POR				(0x00)
#define TAPAN_A_CDC_CLK_TX_CLK_EN_B2_CTL			(0x30B)
#define TAPAN_A_CDC_CLK_TX_CLK_EN_B2_CTL__POR				(0x00)
#define TAPAN_A_CDC_CLK_OTHR_CTL			(0x30C)
#define TAPAN_A_CDC_CLK_OTHR_CTL__POR				(0x00)
#define TAPAN_A_CDC_CLK_RDAC_CLK_EN_CTL			(0x30D)
#define TAPAN_A_CDC_CLK_RDAC_CLK_EN_CTL__POR				(0x00)
#define TAPAN_A_CDC_CLK_ANC_CLK_EN_CTL			(0x30E)
#define TAPAN_A_CDC_CLK_ANC_CLK_EN_CTL__POR				(0x00)
#define TAPAN_A_CDC_CLK_RX_B1_CTL			(0x30F)
#define TAPAN_A_CDC_CLK_RX_B1_CTL__POR				(0x00)
#define TAPAN_A_CDC_CLK_RX_B2_CTL			(0x310)
#define TAPAN_A_CDC_CLK_RX_B2_CTL__POR				(0x00)
#define TAPAN_A_CDC_CLK_MCLK_CTL			(0x311)
#define TAPAN_A_CDC_CLK_MCLK_CTL__POR				(0x00)
#define TAPAN_A_CDC_CLK_PDM_CTL			(0x312)
#define TAPAN_A_CDC_CLK_PDM_CTL__POR				(0x00)
#define TAPAN_A_CDC_CLK_SD_CTL			(0x313)
#define TAPAN_A_CDC_CLK_SD_CTL__POR				(0x00)
#define TAPAN_A_CDC_CLK_POWER_CTL			(0x314)
#define TAPAN_A_CDC_CLK_POWER_CTL__POR				(0x03)
#define TAPAN_A_CDC_CLSH_B1_CTL			(0x320)
#define TAPAN_A_CDC_CLSH_B1_CTL__POR				(0x22)
#define TAPAN_A_CDC_CLSH_B2_CTL			(0x321)
#define TAPAN_A_CDC_CLSH_B2_CTL__POR				(0x35)
#define TAPAN_A_CDC_CLSH_B3_CTL			(0x322)
#define TAPAN_A_CDC_CLSH_B3_CTL__POR				(0x3B)
#define TAPAN_A_CDC_CLSH_BUCK_NCP_VARS			(0x323)
#define TAPAN_A_CDC_CLSH_BUCK_NCP_VARS__POR				(0x04)
#define TAPAN_A_CDC_CLSH_IDLE_HPH_THSD			(0x324)
#define TAPAN_A_CDC_CLSH_IDLE_HPH_THSD__POR				(0x12)
#define TAPAN_A_CDC_CLSH_IDLE_EAR_THSD			(0x325)
#define TAPAN_A_CDC_CLSH_IDLE_EAR_THSD__POR				(0x0C)
#define TAPAN_A_CDC_CLSH_FCLKONLY_HPH_THSD			(0x326)
#define TAPAN_A_CDC_CLSH_FCLKONLY_HPH_THSD__POR				(0x18)
#define TAPAN_A_CDC_CLSH_FCLKONLY_EAR_THSD			(0x327)
#define TAPAN_A_CDC_CLSH_FCLKONLY_EAR_THSD__POR				(0x23)
#define TAPAN_A_CDC_CLSH_K_ADDR			(0x328)
#define TAPAN_A_CDC_CLSH_K_ADDR__POR				(0x00)
#define TAPAN_A_CDC_CLSH_K_DATA			(0x329)
#define TAPAN_A_CDC_CLSH_K_DATA__POR				(0xA4)
#define TAPAN_A_CDC_CLSH_I_PA_FACT_HPH_L			(0x32A)
#define TAPAN_A_CDC_CLSH_I_PA_FACT_HPH_L__POR				(0xD7)
#define TAPAN_A_CDC_CLSH_I_PA_FACT_HPH_U			(0x32B)
#define TAPAN_A_CDC_CLSH_I_PA_FACT_HPH_U__POR				(0x05)
#define TAPAN_A_CDC_CLSH_I_PA_FACT_EAR_L			(0x32C)
#define TAPAN_A_CDC_CLSH_I_PA_FACT_EAR_L__POR				(0x60)
#define TAPAN_A_CDC_CLSH_I_PA_FACT_EAR_U			(0x32D)
#define TAPAN_A_CDC_CLSH_I_PA_FACT_EAR_U__POR				(0x09)
#define TAPAN_A_CDC_CLSH_V_PA_HD_EAR			(0x32E)
#define TAPAN_A_CDC_CLSH_V_PA_HD_EAR__POR				(0x0D)
#define TAPAN_A_CDC_CLSH_V_PA_HD_HPH			(0x32F)
#define TAPAN_A_CDC_CLSH_V_PA_HD_HPH__POR				(0x0D)
#define TAPAN_A_CDC_CLSH_V_PA_MIN_EAR			(0x330)
#define TAPAN_A_CDC_CLSH_V_PA_MIN_EAR__POR				(0x3A)
#define TAPAN_A_CDC_CLSH_V_PA_MIN_HPH			(0x331)
#define TAPAN_A_CDC_CLSH_V_PA_MIN_HPH__POR				(0x1D)
#define TAPAN_A_CDC_IIR1_GAIN_B1_CTL			(0x340)
#define TAPAN_A_CDC_IIR1_GAIN_B1_CTL__POR				(0x00)
#define TAPAN_A_CDC_IIR2_GAIN_B1_CTL			(0x350)
#define TAPAN_A_CDC_IIR2_GAIN_B1_CTL__POR				(0x00)
#define TAPAN_A_CDC_IIR1_GAIN_B2_CTL			(0x341)
#define TAPAN_A_CDC_IIR1_GAIN_B2_CTL__POR				(0x00)
#define TAPAN_A_CDC_IIR2_GAIN_B2_CTL			(0x351)
#define TAPAN_A_CDC_IIR2_GAIN_B2_CTL__POR				(0x00)
#define TAPAN_A_CDC_IIR1_GAIN_B3_CTL			(0x342)
#define TAPAN_A_CDC_IIR1_GAIN_B3_CTL__POR				(0x00)
#define TAPAN_A_CDC_IIR2_GAIN_B3_CTL			(0x352)
#define TAPAN_A_CDC_IIR2_GAIN_B3_CTL__POR				(0x00)
#define TAPAN_A_CDC_IIR1_GAIN_B4_CTL			(0x343)
#define TAPAN_A_CDC_IIR1_GAIN_B4_CTL__POR				(0x00)
#define TAPAN_A_CDC_IIR2_GAIN_B4_CTL			(0x353)
#define TAPAN_A_CDC_IIR2_GAIN_B4_CTL__POR				(0x00)
#define TAPAN_A_CDC_IIR1_GAIN_B5_CTL			(0x344)
#define TAPAN_A_CDC_IIR1_GAIN_B5_CTL__POR				(0x00)
#define TAPAN_A_CDC_IIR2_GAIN_B5_CTL			(0x354)
#define TAPAN_A_CDC_IIR2_GAIN_B5_CTL__POR				(0x00)
#define TAPAN_A_CDC_IIR1_GAIN_B6_CTL			(0x345)
#define TAPAN_A_CDC_IIR1_GAIN_B6_CTL__POR				(0x00)
#define TAPAN_A_CDC_IIR2_GAIN_B6_CTL			(0x355)
#define TAPAN_A_CDC_IIR2_GAIN_B6_CTL__POR				(0x00)
#define TAPAN_A_CDC_IIR1_GAIN_B7_CTL			(0x346)
#define TAPAN_A_CDC_IIR1_GAIN_B7_CTL__POR				(0x00)
#define TAPAN_A_CDC_IIR2_GAIN_B7_CTL			(0x356)
#define TAPAN_A_CDC_IIR2_GAIN_B7_CTL__POR				(0x00)
#define TAPAN_A_CDC_IIR1_GAIN_B8_CTL			(0x347)
#define TAPAN_A_CDC_IIR1_GAIN_B8_CTL__POR				(0x00)
#define TAPAN_A_CDC_IIR2_GAIN_B8_CTL			(0x357)
#define TAPAN_A_CDC_IIR2_GAIN_B8_CTL__POR				(0x00)
#define TAPAN_A_CDC_IIR1_CTL			(0x348)
#define TAPAN_A_CDC_IIR1_CTL__POR				(0x40)
#define TAPAN_A_CDC_IIR2_CTL			(0x358)
#define TAPAN_A_CDC_IIR2_CTL__POR				(0x40)
#define TAPAN_A_CDC_IIR1_GAIN_TIMER_CTL			(0x349)
#define TAPAN_A_CDC_IIR1_GAIN_TIMER_CTL__POR				(0x00)
#define TAPAN_A_CDC_IIR2_GAIN_TIMER_CTL			(0x359)
#define TAPAN_A_CDC_IIR2_GAIN_TIMER_CTL__POR				(0x00)
#define TAPAN_A_CDC_IIR1_COEF_B1_CTL			(0x34A)
#define TAPAN_A_CDC_IIR1_COEF_B1_CTL__POR				(0x00)
#define TAPAN_A_CDC_IIR2_COEF_B1_CTL			(0x35A)
#define TAPAN_A_CDC_IIR2_COEF_B1_CTL__POR				(0x00)
#define TAPAN_A_CDC_IIR1_COEF_B2_CTL			(0x34B)
#define TAPAN_A_CDC_IIR1_COEF_B2_CTL__POR				(0x00)
#define TAPAN_A_CDC_IIR2_COEF_B2_CTL			(0x35B)
#define TAPAN_A_CDC_IIR2_COEF_B2_CTL__POR				(0x00)
#define TAPAN_A_CDC_TOP_GAIN_UPDATE			(0x360)
#define TAPAN_A_CDC_TOP_GAIN_UPDATE__POR				(0x00)
#define TAPAN_A_CDC_COMP0_B1_CTL			(0x368)
#define TAPAN_A_CDC_COMP0_B1_CTL__POR				(0x30)
#define TAPAN_A_CDC_COMP1_B1_CTL			(0x370)
#define TAPAN_A_CDC_COMP1_B1_CTL__POR				(0x30)
#define TAPAN_A_CDC_COMP2_B1_CTL			(0x378)
#define TAPAN_A_CDC_COMP2_B1_CTL__POR				(0x30)
#define TAPAN_A_CDC_COMP0_B2_CTL			(0x369)
#define TAPAN_A_CDC_COMP0_B2_CTL__POR				(0xB5)
#define TAPAN_A_CDC_COMP1_B2_CTL			(0x371)
#define TAPAN_A_CDC_COMP1_B2_CTL__POR				(0xB5)
#define TAPAN_A_CDC_COMP2_B2_CTL			(0x379)
#define TAPAN_A_CDC_COMP2_B2_CTL__POR				(0xB5)
#define TAPAN_A_CDC_COMP0_B3_CTL			(0x36A)
#define TAPAN_A_CDC_COMP0_B3_CTL__POR				(0x28)
#define TAPAN_A_CDC_COMP1_B3_CTL			(0x372)
#define TAPAN_A_CDC_COMP1_B3_CTL__POR				(0x28)
#define TAPAN_A_CDC_COMP2_B3_CTL			(0x37A)
#define TAPAN_A_CDC_COMP2_B3_CTL__POR				(0x28)
#define TAPAN_A_CDC_COMP0_B4_CTL			(0x36B)
#define TAPAN_A_CDC_COMP0_B4_CTL__POR				(0x37)
#define TAPAN_A_CDC_COMP1_B4_CTL			(0x373)
#define TAPAN_A_CDC_COMP1_B4_CTL__POR				(0x37)
#define TAPAN_A_CDC_COMP2_B4_CTL			(0x37B)
#define TAPAN_A_CDC_COMP2_B4_CTL__POR				(0x37)
#define TAPAN_A_CDC_COMP0_B5_CTL			(0x36C)
#define TAPAN_A_CDC_COMP0_B5_CTL__POR				(0x7F)
#define TAPAN_A_CDC_COMP1_B5_CTL			(0x374)
#define TAPAN_A_CDC_COMP1_B5_CTL__POR				(0x7F)
#define TAPAN_A_CDC_COMP2_B5_CTL			(0x37C)
#define TAPAN_A_CDC_COMP2_B5_CTL__POR				(0x7F)
#define TAPAN_A_CDC_COMP0_B6_CTL			(0x36D)
#define TAPAN_A_CDC_COMP0_B6_CTL__POR				(0x00)
#define TAPAN_A_CDC_COMP1_B6_CTL			(0x375)
#define TAPAN_A_CDC_COMP1_B6_CTL__POR				(0x00)
#define TAPAN_A_CDC_COMP2_B6_CTL			(0x37D)
#define TAPAN_A_CDC_COMP2_B6_CTL__POR				(0x00)
#define TAPAN_A_CDC_COMP0_SHUT_DOWN_STATUS			(0x36E)
#define TAPAN_A_CDC_COMP0_SHUT_DOWN_STATUS__POR				(0x03)
#define TAPAN_A_CDC_COMP1_SHUT_DOWN_STATUS			(0x376)
#define TAPAN_A_CDC_COMP1_SHUT_DOWN_STATUS__POR				(0x03)
#define TAPAN_A_CDC_COMP2_SHUT_DOWN_STATUS			(0x37E)
#define TAPAN_A_CDC_COMP2_SHUT_DOWN_STATUS__POR				(0x03)
#define TAPAN_A_CDC_COMP0_FS_CFG			(0x36F)
#define TAPAN_A_CDC_COMP0_FS_CFG__POR				(0x03)
#define TAPAN_A_CDC_COMP1_FS_CFG			(0x377)
#define TAPAN_A_CDC_COMP1_FS_CFG__POR				(0x03)
#define TAPAN_A_CDC_COMP2_FS_CFG			(0x37F)
#define TAPAN_A_CDC_COMP2_FS_CFG__POR				(0x03)
#define TAPAN_A_CDC_CONN_RX1_B1_CTL			(0x380)
#define TAPAN_A_CDC_CONN_RX1_B1_CTL__POR				(0x00)
#define TAPAN_A_CDC_CONN_RX1_B2_CTL			(0x381)
#define TAPAN_A_CDC_CONN_RX1_B2_CTL__POR				(0x00)
#define TAPAN_A_CDC_CONN_RX1_B3_CTL			(0x382)
#define TAPAN_A_CDC_CONN_RX1_B3_CTL__POR				(0x00)
#define TAPAN_A_CDC_CONN_RX2_B1_CTL			(0x383)
#define TAPAN_A_CDC_CONN_RX2_B1_CTL__POR				(0x00)
#define TAPAN_A_CDC_CONN_RX2_B2_CTL			(0x384)
#define TAPAN_A_CDC_CONN_RX2_B2_CTL__POR				(0x00)
#define TAPAN_A_CDC_CONN_RX2_B3_CTL			(0x385)
#define TAPAN_A_CDC_CONN_RX2_B3_CTL__POR				(0x00)
#define TAPAN_A_CDC_CONN_RX3_B1_CTL			(0x386)
#define TAPAN_A_CDC_CONN_RX3_B1_CTL__POR				(0x00)
#define TAPAN_A_CDC_CONN_RX3_B2_CTL			(0x387)
#define TAPAN_A_CDC_CONN_RX3_B2_CTL__POR				(0x00)
#define TAPAN_A_CDC_CONN_RX4_B1_CTL			(0x388)
#define TAPAN_A_CDC_CONN_RX4_B1_CTL__POR				(0x00)
#define TAPAN_A_CDC_CONN_RX4_B2_CTL			(0x389)
#define TAPAN_A_CDC_CONN_RX4_B2_CTL__POR				(0x00)
#define TAPAN_A_CDC_CONN_RX4_B3_CTL			(0x38A)
#define TAPAN_A_CDC_CONN_RX4_B3_CTL__POR				(0x00)
#define TAPAN_A_CDC_CONN_ANC_B1_CTL			(0x391)
#define TAPAN_A_CDC_CONN_ANC_B1_CTL__POR				(0x00)
#define TAPAN_A_CDC_CONN_ANC_B2_CTL			(0x392)
#define TAPAN_A_CDC_CONN_ANC_B2_CTL__POR				(0x00)
#define TAPAN_A_CDC_CONN_TX_B1_CTL			(0x393)
#define TAPAN_A_CDC_CONN_TX_B1_CTL__POR				(0x00)
#define TAPAN_A_CDC_CONN_TX_B2_CTL			(0x394)
#define TAPAN_A_CDC_CONN_TX_B2_CTL__POR				(0x00)
#define TAPAN_A_CDC_CONN_TX_B3_CTL			(0x395)
#define TAPAN_A_CDC_CONN_TX_B3_CTL__POR				(0x00)
#define TAPAN_A_CDC_CONN_TX_B4_CTL			(0x396)
#define TAPAN_A_CDC_CONN_TX_B4_CTL__POR				(0x00)
#define TAPAN_A_CDC_CONN_EQ1_B1_CTL			(0x397)
#define TAPAN_A_CDC_CONN_EQ1_B1_CTL__POR				(0x00)
#define TAPAN_A_CDC_CONN_EQ1_B2_CTL			(0x398)
#define TAPAN_A_CDC_CONN_EQ1_B2_CTL__POR				(0x00)
#define TAPAN_A_CDC_CONN_EQ1_B3_CTL			(0x399)
#define TAPAN_A_CDC_CONN_EQ1_B3_CTL__POR				(0x00)
#define TAPAN_A_CDC_CONN_EQ1_B4_CTL			(0x39A)
#define TAPAN_A_CDC_CONN_EQ1_B4_CTL__POR				(0x00)
#define TAPAN_A_CDC_CONN_EQ2_B1_CTL			(0x39B)
#define TAPAN_A_CDC_CONN_EQ2_B1_CTL__POR				(0x00)
#define TAPAN_A_CDC_CONN_EQ2_B2_CTL			(0x39C)
#define TAPAN_A_CDC_CONN_EQ2_B2_CTL__POR				(0x00)
#define TAPAN_A_CDC_CONN_EQ2_B3_CTL			(0x39D)
#define TAPAN_A_CDC_CONN_EQ2_B3_CTL__POR				(0x00)
#define TAPAN_A_CDC_CONN_EQ2_B4_CTL			(0x39E)
#define TAPAN_A_CDC_CONN_EQ2_B4_CTL__POR				(0x00)
#define TAPAN_A_CDC_CONN_SRC1_B1_CTL			(0x39F)
#define TAPAN_A_CDC_CONN_SRC1_B1_CTL__POR				(0x00)
#define TAPAN_A_CDC_CONN_SRC1_B2_CTL			(0x3A0)
#define TAPAN_A_CDC_CONN_SRC1_B2_CTL__POR				(0x00)
#define TAPAN_A_CDC_CONN_SRC2_B1_CTL			(0x3A1)
#define TAPAN_A_CDC_CONN_SRC2_B1_CTL__POR				(0x00)
#define TAPAN_A_CDC_CONN_SRC2_B2_CTL			(0x3A2)
#define TAPAN_A_CDC_CONN_SRC2_B2_CTL__POR				(0x00)
#define TAPAN_A_CDC_CONN_TX_SB_B1_CTL			(0x3A3)
#define TAPAN_A_CDC_CONN_TX_SB_B1_CTL__POR				(0x00)
#define TAPAN_A_CDC_CONN_TX_SB_B2_CTL			(0x3A4)
#define TAPAN_A_CDC_CONN_TX_SB_B2_CTL__POR				(0x00)
#define TAPAN_A_CDC_CONN_TX_SB_B3_CTL			(0x3A5)
#define TAPAN_A_CDC_CONN_TX_SB_B3_CTL__POR				(0x00)
#define TAPAN_A_CDC_CONN_TX_SB_B4_CTL			(0x3A6)
#define TAPAN_A_CDC_CONN_TX_SB_B4_CTL__POR				(0x00)
#define TAPAN_A_CDC_CONN_TX_SB_B5_CTL			(0x3A7)
#define TAPAN_A_CDC_CONN_TX_SB_B5_CTL__POR				(0x00)
#define TAPAN_A_CDC_CONN_TX_SB_B11_CTL			(0x3AD)
#define TAPAN_A_CDC_CONN_TX_SB_B11_CTL__POR				(0x00)
#define TAPAN_A_CDC_CONN_RX_SB_B1_CTL			(0x3AE)
#define TAPAN_A_CDC_CONN_RX_SB_B1_CTL__POR				(0x00)
#define TAPAN_A_CDC_CONN_RX_SB_B2_CTL			(0x3AF)
#define TAPAN_A_CDC_CONN_RX_SB_B2_CTL__POR				(0x00)
#define TAPAN_A_CDC_CONN_CLSH_CTL			(0x3B0)
#define TAPAN_A_CDC_CONN_CLSH_CTL__POR				(0x00)
#define TAPAN_A_CDC_CONN_MISC			(0x3B1)
#define TAPAN_A_CDC_CONN_MISC__POR				(0x01)
#define TAPAN_A_CDC_MBHC_EN_CTL			(0x3C0)
#define TAPAN_A_CDC_MBHC_EN_CTL__POR				(0x00)
#define TAPAN_A_CDC_MBHC_FIR_B1_CFG			(0x3C1)
#define TAPAN_A_CDC_MBHC_FIR_B1_CFG__POR				(0x00)
#define TAPAN_A_CDC_MBHC_FIR_B2_CFG			(0x3C2)
#define TAPAN_A_CDC_MBHC_FIR_B2_CFG__POR				(0x06)
#define TAPAN_A_CDC_MBHC_TIMER_B1_CTL			(0x3C3)
#define TAPAN_A_CDC_MBHC_TIMER_B1_CTL__POR				(0x03)
#define TAPAN_A_CDC_MBHC_TIMER_B2_CTL			(0x3C4)
#define TAPAN_A_CDC_MBHC_TIMER_B2_CTL__POR				(0x09)
#define TAPAN_A_CDC_MBHC_TIMER_B3_CTL			(0x3C5)
#define TAPAN_A_CDC_MBHC_TIMER_B3_CTL__POR				(0x1E)
#define TAPAN_A_CDC_MBHC_TIMER_B4_CTL			(0x3C6)
#define TAPAN_A_CDC_MBHC_TIMER_B4_CTL__POR				(0x45)
#define TAPAN_A_CDC_MBHC_TIMER_B5_CTL			(0x3C7)
#define TAPAN_A_CDC_MBHC_TIMER_B5_CTL__POR				(0x04)
#define TAPAN_A_CDC_MBHC_TIMER_B6_CTL			(0x3C8)
#define TAPAN_A_CDC_MBHC_TIMER_B6_CTL__POR				(0x78)
#define TAPAN_A_CDC_MBHC_B1_STATUS			(0x3C9)
#define TAPAN_A_CDC_MBHC_B1_STATUS__POR				(0x00)
#define TAPAN_A_CDC_MBHC_B2_STATUS			(0x3CA)
#define TAPAN_A_CDC_MBHC_B2_STATUS__POR				(0x00)
#define TAPAN_A_CDC_MBHC_B3_STATUS			(0x3CB)
#define TAPAN_A_CDC_MBHC_B3_STATUS__POR				(0x00)
#define TAPAN_A_CDC_MBHC_B4_STATUS			(0x3CC)
#define TAPAN_A_CDC_MBHC_B4_STATUS__POR				(0x00)
#define TAPAN_A_CDC_MBHC_B5_STATUS			(0x3CD)
#define TAPAN_A_CDC_MBHC_B5_STATUS__POR				(0x00)
#define TAPAN_A_CDC_MBHC_B1_CTL			(0x3CE)
#define TAPAN_A_CDC_MBHC_B1_CTL__POR				(0xC0)
#define TAPAN_A_CDC_MBHC_B2_CTL			(0x3CF)
#define TAPAN_A_CDC_MBHC_B2_CTL__POR				(0x5D)
#define TAPAN_A_CDC_MBHC_VOLT_B1_CTL			(0x3D0)
#define TAPAN_A_CDC_MBHC_VOLT_B1_CTL__POR				(0x00)
#define TAPAN_A_CDC_MBHC_VOLT_B2_CTL			(0x3D1)
#define TAPAN_A_CDC_MBHC_VOLT_B2_CTL__POR				(0x00)
#define TAPAN_A_CDC_MBHC_VOLT_B3_CTL			(0x3D2)
#define TAPAN_A_CDC_MBHC_VOLT_B3_CTL__POR				(0x00)
#define TAPAN_A_CDC_MBHC_VOLT_B4_CTL			(0x3D3)
#define TAPAN_A_CDC_MBHC_VOLT_B4_CTL__POR				(0x00)
#define TAPAN_A_CDC_MBHC_VOLT_B5_CTL			(0x3D4)
#define TAPAN_A_CDC_MBHC_VOLT_B5_CTL__POR				(0x00)
#define TAPAN_A_CDC_MBHC_VOLT_B6_CTL			(0x3D5)
#define TAPAN_A_CDC_MBHC_VOLT_B6_CTL__POR				(0x00)
#define TAPAN_A_CDC_MBHC_VOLT_B7_CTL			(0x3D6)
#define TAPAN_A_CDC_MBHC_VOLT_B7_CTL__POR				(0xFF)
#define TAPAN_A_CDC_MBHC_VOLT_B8_CTL			(0x3D7)
#define TAPAN_A_CDC_MBHC_VOLT_B8_CTL__POR				(0x07)
#define TAPAN_A_CDC_MBHC_VOLT_B9_CTL			(0x3D8)
#define TAPAN_A_CDC_MBHC_VOLT_B9_CTL__POR				(0xFF)
#define TAPAN_A_CDC_MBHC_VOLT_B10_CTL			(0x3D9)
#define TAPAN_A_CDC_MBHC_VOLT_B10_CTL__POR				(0x7F)
#define TAPAN_A_CDC_MBHC_VOLT_B11_CTL			(0x3DA)
#define TAPAN_A_CDC_MBHC_VOLT_B11_CTL__POR				(0x00)
#define TAPAN_A_CDC_MBHC_VOLT_B12_CTL			(0x3DB)
#define TAPAN_A_CDC_MBHC_VOLT_B12_CTL__POR				(0x80)
#define TAPAN_A_CDC_MBHC_CLK_CTL			(0x3DC)
#define TAPAN_A_CDC_MBHC_CLK_CTL__POR				(0x00)
#define TAPAN_A_CDC_MBHC_INT_CTL			(0x3DD)
#define TAPAN_A_CDC_MBHC_INT_CTL__POR				(0x00)
#define TAPAN_A_CDC_MBHC_DEBUG_CTL			(0x3DE)
#define TAPAN_A_CDC_MBHC_DEBUG_CTL__POR				(0x00)
#define TAPAN_A_CDC_MBHC_SPARE			(0x3DF)
#define TAPAN_A_CDC_MBHC_SPARE__POR				(0x00)

/* SLIMBUS Slave Registers */
#define TAPAN_SLIM_PGD_PORT_INT_EN0                     (0x30)
#define TAPAN_SLIM_PGD_PORT_INT_STATUS_RX_0             (0x34)
#define TAPAN_SLIM_PGD_PORT_INT_STATUS_RX_1             (0x35)
#define TAPAN_SLIM_PGD_PORT_INT_STATUS_TX_0             (0x36)
#define TAPAN_SLIM_PGD_PORT_INT_STATUS_TX_1             (0x37)
#define TAPAN_SLIM_PGD_PORT_INT_CLR_RX_0                (0x38)
#define TAPAN_SLIM_PGD_PORT_INT_CLR_RX_1                (0x39)
#define TAPAN_SLIM_PGD_PORT_INT_CLR_TX_0                (0x3A)
#define TAPAN_SLIM_PGD_PORT_INT_CLR_TX_1                (0x3B)
#define TAPAN_SLIM_PGD_PORT_INT_RX_SOURCE0		(0x60)
#define TAPAN_SLIM_PGD_PORT_INT_TX_SOURCE0		(0x70)

/* Macros for Packing Register Writes into a U32 */
#define TAPAN_PACKED_REG_SIZE sizeof(u32)

#define TAPAN_CODEC_PACK_ENTRY(reg, mask, val) ((val & 0xff) | \
	((mask & 0xff) << 8) | ((reg & 0xffff) << 16))

#define TAPAN_CODEC_UNPACK_ENTRY(packed, reg, mask, val) \
	do { \
		((reg) = ((packed >> 16) & (0xffff))); \
		((mask) = ((packed >> 8) & (0xff))); \
		((val) = ((packed) & (0xff))); \
	} while (0)
#endif

#define TAPAN_SB_PGD_PORT_RX_BASE   0x40
#define TAPAN_SB_PGD_PORT_TX_BASE   0x50
#define TAPAN_REGISTER_START_OFFSET 0x800
#define TAPAN_NUM_REGISTERS         0x400
#define TAPAN_MAX_REGISTER         (TAPAN_NUM_REGISTERS-1)
#define TAPAN_CACHE_SIZE            TAPAN_NUM_REGISTERS
extern const u8 tapan_reg_readable[TAPAN_CACHE_SIZE];
