/*
 *      Header file of AP mib
 *      Authors: David Hsu	<davidhsu@realtek.com.tw>
 *
 *      $Id: apmib.h,v 1.54 2009/09/15 02:12:24 bradhuang Exp $
 *
 */


#ifndef INCLUDE_APMIB_H
#define INCLUDE_APMIB_H

/* Forrest, 2007.11.07.
 * If you want to let APMIB adopt shared memory mechanism, define it to 1.
 * Or define it to 0 will go back to original local copy mechanism.
 * Note: 
 *   1. I only use shared memory for HW Configuration (pHwSetting), Default 
 *      Configuration (pMibDef) and Current Configuration (pMib). There is
 *      no shared memory for each linkchain now.
 *   2. Because uClibc does not support POSIX inter-process semaphore, I have
 *      to use SYSTEM V semaphore and shared memory. So if you want to adopt
 *      shared memory mechanism, you must go to turn on CONFIG_SYSVIPC 
 *      kernel config to support it.
 */
#ifdef CONFIG_APMIB_SHARED 
	#define CONFIG_APMIB_SHARED_MEMORY	1
#else
	#define CONFIG_APMIB_SHARED_MEMORY	0
#endif
#include <endian.h>
#include "list.h"

// added by rock /////////////////////////////////////////
#ifdef VOIP_SUPPORT
#include "voip_flash.h"
#include "voip_flash_mib.h"
#endif

#if defined(CONFIG_DOMAIN_NAME_QUERY_SUPPORT)
//#define LOGDEBUG_ENABLED
#endif

#if __BYTE_ORDER == __LITTLE_ENDIAN
    #define _LITTLE_ENDIAN_
#elif __BYTE_ORDER == __BIG_ENDIAN
    #define _BIG_ENDIAN_
#endif

#ifdef ADVANCED_IPQOS
#define ADVANCED_IPQOS_DEF_CHAR_VALUE 255
#endif


#define MBSSID

#ifdef FAST_BSS_TRANSITION
#define MAX_VWLAN_FTKH_NUM			8
#define MAX_WLAN_FTKH_NUM			(8*(NUM_VWLAN_INTERFACE+1))
#define MAX_FTKH_NUM 8
#endif


//hf
//#define CONFIG_RTL_BT_CLIENT

#define COMPRESS_MIB_SETTING
#define MIB_TLV

//WNC-JDR230-YUAN-I-CHOU, Realtek patch [CheeperSW:0342]
#define BRIDGE_PARTITION	// Support wlan partition in bridge mode
//WNC-JDR230-YUAN-I-CHOU, Realtek patch [CheeperSW:0342] End
#ifdef MIB_TLV
#define MIB_TABLE_LIST 0x8000
#else
#define MIB_TABLE_LIST 0x0
#endif

//#ifdef HOME_GATEWAY
//#define GW_QOS_ENGINE
//#endif
#ifdef ENABLE_QOS // thru makefile
	#ifndef QOS_BY_BANDWIDTH
		#define GW_QOS_ENGINE
	#endif
#endif
#if defined(VOIP_SUPPORT) || defined(CONFIG_APP_TR069) || defined(FAST_BSS_TRANSITION) || defined(RTK_CAPWAP)
#ifndef HEADER_LEN_INT
#define HEADER_LEN_INT
#endif
#endif
#define HEADER_LEN_INT
#ifdef QOS_OF_TR069
#ifndef _PATH_TR069_QOS_CONFIG_
#define _PATH_TR069_QOS_CONFIG_ "\var\Tr069QosConfig"
#endif
#endif
#if defined(CONFIG_RTL_92D_SUPPORT)||defined(CONFIG_RTL_DUAL_PCIESLOT_BIWLAN)
#define NUM_WLAN_INTERFACE		2	// number of wlan interface supported
#else
#define NUM_WLAN_INTERFACE		1	// number of wlan interface supported
#endif

#if defined(CONFIG_RTL_819X)
#define NUM_WLAN_MULTIPLE_SSID	8	// number of wlan ssid support
#else
//!CONFIG_RTL_8196B => rtl8651c+rtl8190
#define NUM_WLAN_MULTIPLE_SSID	5	// number of wlan ssid support
#endif

#ifdef MBSSID 
#define NUM_VWLAN		4	// number of virtual wlan interface supported
#else
#define NUM_VWLAN		0
#endif

//#ifdef CONFIG_RTL8196B_GW_8M
//#define MAX_WDS_NUM			4
//#else
#define MAX_WDS_NUM			8
//#endif

#if 1 	/* WNC-MR0000-[Voyager]-Libera-20131218- ForceDHCPServer for Repeater mode*/
#include <sys/stat.h>
#define FORCE_DHCP_S "/var/forceDhcpS"
#endif

#if defined(UNIVERSAL_REPEATER) && defined(CONFIG_RTL_ULINKER)
	#define NUM_VWLAN_INTERFACE		NUM_VWLAN+4  //+4 is ulinker_ap, ulinker_cl, ulinker_rpt, repeater(vxd)
#elif defined(CONFIG_RTL_ULINKER)
	#define NUM_VWLAN_INTERFACE		NUM_VWLAN+2  //+2 is ulinker_ap, ulinker_cl
#elif defined(UNIVERSAL_REPEATER)
#define NUM_VWLAN_INTERFACE		NUM_VWLAN+1
#else
#define NUM_VWLAN_INTERFACE		NUM_VWLAN
#endif

#if defined(UNIVERSAL_REPEATER) && defined(CONFIG_RTL_ULINKER)
	#define ULINKER_AP_MIB	(NUM_VWLAN_INTERFACE-3)
	#define ULINKER_CL_MIB	(NUM_VWLAN_INTERFACE-2)
	#define ULINKER_RPT_MIB (NUM_VWLAN_INTERFACE-1)
#elif defined(CONFIG_RTL_ULINKER)
	#define ULINKER_AP_MIB	(NUM_VWLAN_INTERFACE-1)
	#define ULINKER_CL_MIB	(NUM_VWLAN_INTERFACE)
#endif

// WLAN MIB id
#define MIB_WLAN_SSID			1
#define MIB_WLAN_CHANNEL		2
#define MIB_WLAN_WEP			3
#define MIB_WLAN_WEP64_KEY1		4
#define MIB_WLAN_WEP64_KEY2		5
#define MIB_WLAN_WEP64_KEY3		6
#define MIB_WLAN_WEP64_KEY4		7
#define MIB_WLAN_WEP128_KEY1		8
#define MIB_WLAN_WEP128_KEY2		9
#define MIB_WLAN_WEP128_KEY3		10
#define MIB_WLAN_WEP128_KEY4		11
#define MIB_WLAN_WEP_KEY_TYPE		12
#define MIB_WLAN_WEP_DEFAULT_KEY	13
#define MIB_WLAN_FRAG_THRESHOLD		14
#define MIB_WLAN_SUPPORTED_RATES		15
#define MIB_WLAN_BEACON_INTERVAL	16
#define MIB_WLAN_PREAMBLE_TYPE		17
#define MIB_WLAN_BASIC_RATES		18
#define MIB_WLAN_RTS_THRESHOLD		19
#define MIB_WLAN_AUTH_TYPE		20
#define MIB_WLAN_HIDDEN_SSID		21
#define MIB_WLAN_WLAN_DISABLED		22
#define MIB_ELAN_MAC_ADDR		23
#define MIB_WLAN_WLAN_MAC_ADDR		24
#define MIB_WLAN_ENCRYPT		25
#define MIB_WLAN_ENABLE_SUPP_NONWPA	26
#define MIB_WLAN_SUPP_NONWPA		27
#define MIB_WLAN_WPA_AUTH		28
#define MIB_WLAN_WPA_CIPHER_SUITE	29
#define MIB_WLAN_WPA_PSK		30
#define MIB_WLAN_WPA_GROUP_REKEY_TIME	31
#define MIB_WLAN_RS_IP			32
#define MIB_WLAN_RS_PORT		33
#define MIB_WLAN_RS_PASSWORD		34
#define MIB_WLAN_ENABLE_1X		35
#define MIB_WLAN_PSK_FORMAT		36
#define MIB_WLAN_WPA2_PRE_AUTH		37
#define MIB_WLAN_WPA2_CIPHER_SUITE	38
#define MIB_WLAN_ACCOUNT_RS_ENABLED	39
#define MIB_WLAN_ACCOUNT_RS_IP		40
#define MIB_WLAN_ACCOUNT_RS_PORT	41
#define MIB_WLAN_ACCOUNT_RS_PASSWORD	42
#define MIB_WLAN_ACCOUNT_RS_UPDATE_ENABLED	43
#define MIB_WLAN_ACCOUNT_RS_UPDATE_DELAY	44
#define MIB_WLAN_MAC_AUTH_ENABLED	45
#define MIB_WLAN_RS_MAXRETRY		46
#define MIB_WLAN_RS_INTERVAL_TIME	47
#define MIB_WLAN_ACCOUNT_RS_MAXRETRY	48
#define MIB_WLAN_ACCOUNT_RS_INTERVAL_TIME 49

#define MIB_WLAN_INACTIVITY_TIME	50
#define MIB_WLAN_RATE_ADAPTIVE_ENABLED	51
#define MIB_WLAN_MACAC_ENABLED		52
#define MIB_WLAN_MACAC_NUM			53
#define MIB_WLAN_MACAC_ADDR			((MIB_WLAN_MACAC_NUM+1)|MIB_TABLE_LIST)
#define MIB_WLAN_AC_ADDR_ADD		((MIB_WLAN_MACAC_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_WLAN_AC_ADDR_DEL		((MIB_WLAN_MACAC_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_WLAN_AC_ADDR_DELALL		((MIB_WLAN_MACAC_NUM+4)|MIB_DELALL_TBL_ENTRY)
#define MIB_WLAN_DTIM_PERIOD		58
#define MIB_WLAN_MODE			59
#define MIB_WLAN_NETWORK_TYPE		60
#define MIB_WLAN_DEFAULT_SSID		61	// used while configured as Ad-hoc and no any other Ad-hoc could be joined
						// it will use this default SSID to start BSS
#define MIB_WLAN_IAPP_DISABLED		62
#define MIB_WLAN_WDS_ENABLED		63
#define MIB_WLAN_WDS_NUM		64
#define MIB_WLAN_WDS			((MIB_WLAN_WDS_NUM+1)|MIB_TABLE_LIST)
#define MIB_WLAN_WDS_ADD		((MIB_WLAN_WDS_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_WLAN_WDS_DEL		((MIB_WLAN_WDS_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_WLAN_WDS_DELALL		((MIB_WLAN_WDS_NUM+4)|MIB_DELALL_TBL_ENTRY)
#define MIB_WLAN_WDS_ENCRYPT		69
#define MIB_WLAN_WDS_WEP_FORMAT		70
#define MIB_WLAN_WDS_WEP_KEY		71
#define MIB_WLAN_WDS_PSK_FORMAT		72
#define MIB_WLAN_WDS_PSK		73
#define MIB_WLAN_BAND			74
#define MIB_WLAN_FIX_RATE		75
#define MIB_WLAN_BLOCK_RELAY		76
#define MIB_WLAN_MACCLONE_ENABLED	77
#define MIB_WLAN_PROTECTION_DISABLED 	78
#ifdef TLS_CLIENT
//sc_yang for client mode TLS
#define MIB_CERTROOT_TBL_NUM			79
#define MIB_CERTROOT_TBL			((MIB_CERTROOT_TBL_NUM+1)|MIB_TABLE_LIST)
#define MIB_CERTROOT_ADD			((MIB_CERTROOT_TBL_NUM+2)|MIB_ADD_TBL_ENTRY)	
#define MIB_CERTROOT_DEL			((MIB_CERTROOT_TBL_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_CERTROOT_DELALL			((MIB_CERTROOT_TBL_NUM+4)|MIB_DELALL_TBL_ENTRY)
#define MIB_CERTUSER_TBL_NUM			84
#define MIB_CERTUSER_TBL			((MIB_CERTUSER_TBL_NUM+1)|MIB_TABLE_LIST)
#define MIB_CERTUSER_ADD			((MIB_CERTUSER_TBL_NUM+2)|MIB_ADD_TBL_ENTRY)	
#define MIB_CERTUSER_DEL			((MIB_CERTUSER_TBL_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_CERTUSER_DELALL			((MIB_CERTUSER_TBL_NUM+4)|MIB_DELALL_TBL_ENTRY)
#endif

// for WMM
#define MIB_WLAN_WMM_ENABLED 89

#ifdef WLAN_EASY_CONFIG
#define MIB_WLAN_EASYCFG_ENABLED	90
#define MIB_WLAN_EASYCFG_MODE		91
#define MIB_WLAN_EASYCFG_SSID		92
#define MIB_WLAN_EASYCFG_KEY		93
#define MIB_WLAN_EASYCFG_ALG_REQ	94
#define MIB_WLAN_EASYCFG_ALG_SUPP	95
#define MIB_WLAN_EASYCFG_DIGEST		96
#define MIB_WLAN_EASYCFG_ROLE		97
#define MIB_WLAN_EASYCFG_SCAN_SSID	98
#define MIB_WLAN_EASYCFG_WLAN_MODE	99
#endif // WLAN_EASY_CONFIG

#ifdef MIB_TLV
#define MIB_ROOT	(100|MIB_TABLE_LIST)
#define MIB_WLAN_ROOT	(101|MIB_TABLE_LIST)
#else  //etop modify
#define MIB_ROOT	(100|MIB_TABLE_LIST)
#define MIB_WLAN_ROOT	(101|MIB_TABLE_LIST)

#endif
#if defined(CONFIG_RTL_8198_AP_ROOT) || defined(CONFIG_RTL_8197D_AP)
#define MIB_NTP_ENABLED                 151
#define MIB_NTP_SERVER_ID               152
#define MIB_NTP_TIMEZONE                153
#define MIB_NTP_SERVER_IP1              154
#define MIB_NTP_SERVER_IP2              155
#define MIB_NTP_SERVER_IP3              2255
#define MIB_NTP_SERVER_IP4              2256
#define MIB_NTP_SERVER_IP5              2257
#define MIB_NTP_SERVER_IP6              2258
#endif

#define MIB_WAN_MAC_ADDR		100
#define MIB_WAN_IP_ADDR			101
#define MIB_WAN_SUBNET_MASK		102
#define MIB_WAN_DEFAULT_GATEWAY		103
#define MIB_WAN_DHCP			104
#define MIB_DNS_MODE		105
#define MIB_PPP_USER_NAME			106
#define MIB_PPP_PASSWORD		107
#define MIB_PPP_IDLE_TIME		108
#define MIB_PPP_CONNECT_TYPE		109

#ifdef HOME_GATEWAY

#define MIB_PORTFW_ENABLED		110
#define MIB_PORTFW_TBL_NUM			111
#define MIB_PORTFW_TBL			((MIB_PORTFW_TBL_NUM+1)|MIB_TABLE_LIST)
#define MIB_PORTFW_ADD			((MIB_PORTFW_TBL_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_PORTFW_DEL			((MIB_PORTFW_TBL_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_PORTFW_MOD			((MIB_PORTFW_TBL_NUM+3)|MIB_DEL_TBL_ENTRY | MIB_MOD_TBL_ENTRY)
#define MIB_PORTFW_DELALL		((MIB_PORTFW_TBL_NUM+4)|MIB_DELALL_TBL_ENTRY)
#define MIB_IPFILTER_ENABLED		116
#define MIB_IPFILTER_TBL_NUM		117
#define MIB_IPFILTER_TBL		((MIB_IPFILTER_TBL_NUM+1)|MIB_TABLE_LIST)
#define MIB_IPFILTER_ADD		((MIB_IPFILTER_TBL_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_IPFILTER_DEL		((MIB_IPFILTER_TBL_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_IPFILTER_DELALL		((MIB_IPFILTER_TBL_NUM+4)|MIB_DELALL_TBL_ENTRY)
#define MIB_MACFILTER_ENABLED		122
#define MIB_MACFILTER_TBL_NUM		123
#define MIB_MACFILTER_TBL			((MIB_MACFILTER_TBL_NUM+1)|MIB_TABLE_LIST)
#define MIB_MACFILTER_ADD		((MIB_MACFILTER_TBL_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_MACFILTER_DEL		((MIB_MACFILTER_TBL_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_MACFILTER_DELALL		((MIB_MACFILTER_TBL_NUM+4)|MIB_DELALL_TBL_ENTRY)
#define MIB_PORTFILTER_ENABLED		128
#define MIB_PORTFILTER_TBL_NUM		129
#define MIB_PORTFILTER_TBL			((MIB_PORTFILTER_TBL_NUM+1)|MIB_TABLE_LIST)
#define MIB_PORTFILTER_ADD		((MIB_PORTFILTER_TBL_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_PORTFILTER_DEL		((MIB_PORTFILTER_TBL_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_PORTFILTER_DELALL		((MIB_PORTFILTER_TBL_NUM+4)|MIB_DELALL_TBL_ENTRY)
#define MIB_TRIGGERPORT_ENABLED		134
#define MIB_TRIGGERPORT_TBL_NUM		135
#define MIB_TRIGGERPORT_TBL			((MIB_TRIGGERPORT_TBL_NUM+1)|MIB_TABLE_LIST)
#define MIB_TRIGGERPORT_ADD		((MIB_TRIGGERPORT_TBL_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_TRIGGERPORT_DEL		((MIB_TRIGGERPORT_TBL_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_TRIGGERPORT_DELALL		((MIB_TRIGGERPORT_TBL_NUM+4)|MIB_DELALL_TBL_ENTRY)
#define MIB_DMZ_ENABLED			140
#define MIB_DMZ_HOST			141
#define MIB_UPNP_ENABLED		142
#define MIB_UPNP_IGD_NAME		143
#endif //#ifdef HOME_GATEWAY

#define MIB_PPP_MTU_SIZE		144
#define MIB_PPTP_IP_ADDR			145
#define MIB_PPTP_SUBNET_MASK		146
#define MIB_PPTP_SERVER_IP_ADDR		147
#define MIB_PPTP_USER_NAME			148
#define MIB_PPTP_PASSWORD		149
#define MIB_PPTP_MTU_SIZE		150
#define MIB_NTP_ENABLED 		151
#define MIB_NTP_SERVER_ID 		152
#define MIB_NTP_TIMEZONE 		153
#define MIB_NTP_SERVER_IP1		154
#define MIB_NTP_SERVER_IP2		155
#define MIB_NTP_SERVER_IP3              2255
#define MIB_NTP_SERVER_IP4              2256
#define MIB_NTP_SERVER_IP5              2257
#define MIB_NTP_SERVER_IP6              2258
#define MIB_PPTP_SECURITY_ENABLED 	156
#define MIB_FIXED_IP_MTU_SIZE	157
#define MIB_DHCP_MTU_SIZE		158
#define MIB_PPTP_MPPC_ENABLED	159

#ifdef HOME_GATEWAY

#ifdef VPN_SUPPORT
#define MIB_IPSECTUNNEL_ENABLED		160
#define MIB_IPSECTUNNEL_TBL_NUM		161
#define MIB_IPSECTUNNEL_TBL		((MIB_IPSECTUNNEL_TBL_NUM+1)|MIB_TABLE_LIST)
#define MIB_IPSECTUNNEL_ADD		((MIB_IPSECTUNNEL_TBL_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_IPSECTUNNEL_DEL		((MIB_IPSECTUNNEL_TBL_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_IPSECTUNNEL_DELALL		((MIB_IPSECTUNNEL_TBL_NUM+4)|MIB_DELALL_TBL_ENTRY)
#define MIB_IPSEC_NATT_ENABLED		167
#define MIB_IPSEC_RSA_FILE 		168
#endif
#endif // HOME_GATEWAY

#define MIB_IP_ADDR			170
#define MIB_SUBNET_MASK			171
#define MIB_DEFAULT_GATEWAY		172
#define MIB_DHCP			173
#define MIB_DHCP_CLIENT_START		174
#define MIB_DHCP_CLIENT_END		175
#define MIB_DNS1			176
#define MIB_DNS2			177
#define MIB_DNS3			178
#define MIB_STP_ENABLED			179
#ifdef SUPER_NAME_SUPPORT
#define MIB_SUPER_NAME			180
#define MIB_SUPER_PASSWORD		181
#endif
#define MIB_USER_NAME			182
#define	MIB_USER_PASSWORD		183
#define MIB_SCRLOG_ENABLED			184
#define MIB_AUTO_DISCOVERY_ENABLED	185
#define MIB_DEVICE_NAME			186

#ifdef HOME_GATEWAY			
#define MIB_DDNS_ENABLED		187
#define MIB_DDNS_TYPE			188
#define MIB_DDNS_DOMAIN_NAME		189
#define MIB_DDNS_USER			190
#define MIB_DDNS_PASSWORD		191
#endif
#define MIB_OP_MODE			192
#define MIB_WISP_WAN_ID			193

#ifdef HOME_GATEWAY
#define	MIB_WEB_WAN_ACCESS_ENABLED		194
#if defined(CONFIG_RTL_WEB_WAN_ACCESS_PORT)
#define	MIB_WEB_WAN_ACCESS_PORT		    256
#endif
#define	MIB_PING_WAN_ACCESS_ENABLED		195
#define MIB_HOST_NAME			197
#endif

#define MIB_DOMAIN_NAME			198

#ifdef CONFIG_PMKCACHE
#define MIB_WLAN_MAX_PMKSA		199 //for PMKCache
#endif

#ifdef MIB_TLV
//#define MIB_TABLE_LIST 0x8000
#define MIB_ID_MASK (0x8000-1)
#define MIB_HW_ROOT	(200|MIB_TABLE_LIST)
#define MIB_HW_WLAN_ROOT	(201|MIB_TABLE_LIST)
#define MIB_ADD_TBL_ENTRY 		0x10000
#define MIB_DEL_TBL_ENTRY 		0x20000
#define MIB_DELALL_TBL_ENTRY 	        0x40000
#define MIB_MOD_TBL_ENTRY 		0x100000
#define MIB_WLAN_TBL  			0x80000
#else //etop modify :for config
//#define MIB_TABLE_LIST 0x8000
#define MIB_ID_MASK (0x8000-1)
#define MIB_HW_ROOT	(200|MIB_TABLE_LIST)
#define MIB_HW_WLAN_ROOT	(201|MIB_TABLE_LIST)
#define MIB_ADD_TBL_ENTRY 		0x10000
#define MIB_DEL_TBL_ENTRY 		0x20000
#define MIB_MOD_TBL_ENTRY 		0x100000
#define MIB_DELALL_TBL_ENTRY 	        0x40000
#define MIB_WLAN_TBL  			0x80000
#endif // #ifdef MIB_TLV

// Hardware setting MIB
#define MIB_HW_BOARD_VER		200
#define MIB_HW_NIC0_ADDR		201
#define MIB_HW_NIC1_ADDR		202
#define MIB_HW_WLAN_ADDR		203
#define MIB_HW_REG_DOMAIN		204
#define MIB_HW_RF_TYPE			205
#define MIB_HW_TX_POWER_CCK		206
#define MIB_HW_TX_POWER_OFDM		207
#define MIB_HW_ANT_DIVERSITY		208
#define MIB_HW_TX_ANT			209
#define MIB_HW_CCA_MODE			210
#define MIB_HW_PHY_TYPE			211
#define MIB_HW_LED_TYPE			212
#define MIB_HW_INIT_GAIN		213

//#define CUSTOMER_HW_SETTING_SUPPORT
#ifdef CUSTOMER_HW_SETTING_SUPPORT
#define CUSTOMER_HW_MIB_BaseId 4000
#define MIB_CUSTOMER_HW_ROOT	(CUSTOMER_HW_MIB_BaseId|MIB_TABLE_LIST)
#define MIB_CUSTOMER_HW_SERIAL_NUM CUSTOMER_HW_MIB_BaseId+1


#endif

#ifdef TLS_CLIENT
#define MIB_ROOT_IDX			214
#define MIB_USER_IDX			215
#endif
#ifdef ROUTE_SUPPORT
#define MIB_STATICROUTE_ENABLED         216
#define MIB_STATICROUTE_TBL_NUM         217
#define MIB_STATICROUTE_TBL             ((MIB_STATICROUTE_TBL_NUM+1)|MIB_TABLE_LIST) /*218*/
#define MIB_STATICROUTE_ADD             ((MIB_STATICROUTE_TBL_NUM+2) | MIB_ADD_TBL_ENTRY)
#define MIB_STATICROUTE_DEL             ((MIB_STATICROUTE_TBL_NUM+3) | MIB_DEL_TBL_ENTRY)
#define MIB_STATICROUTE_MOD             ((MIB_STATICROUTE_TBL_NUM+3) | MIB_DEL_TBL_ENTRY | MIB_MOD_TBL_ENTRY)
#define MIB_STATICROUTE_DELALL          ((MIB_STATICROUTE_TBL_NUM+4) | MIB_DELALL_TBL_ENTRY)/*221*/
#define MIB_RIP_ENABLED			222
#define MIB_RIP_LAN_TX 			223
#define MIB_RIP_LAN_RX 			224
#define MIB_RIP_WAN_TX 			225
#define MIB_RIP_WAN_RX 			226
#ifdef RIP6_SUPPORT
#define MIB_RIP6_ENABLED			222+2254
#endif
#endif

#define MIB_REMOTELOG_ENABLED 		227
#define MIB_REMOTELOG_SERVER		228

#ifdef HOME_GATEWAY
#ifdef DOS_SUPPORT
#define MIB_DOS_ENABLED 			229
#define MIB_DOS_SYSSYN_FLOOD 		230
#define MIB_DOS_SYSFIN_FLOOD 		231
#define MIB_DOS_SYSUDP_FLOOD 		232
#define MIB_DOS_SYSICMP_FLOOD 	233
#define MIB_DOS_PIPSYN_FLOOD 		234
#define MIB_DOS_PIPFIN_FLOOD 		235
#define MIB_DOS_PIPUDP_FLOOD 		236
#define MIB_DOS_PIPICMP_FLOOD 		237
#define MIB_DOS_BLOCK_TIME 		238
#endif
#define MIB_URLFILTER_ENABLED		239
#define MIB_URLFILTER_TBL_NUM			240
#define MIB_URLFILTER_TBL			((MIB_URLFILTER_TBL_NUM+1)|MIB_TABLE_LIST)
#define MIB_URLFILTER_ADD			((MIB_URLFILTER_TBL_NUM+2) | MIB_ADD_TBL_ENTRY)
#define MIB_URLFILTER_DEL			((MIB_URLFILTER_TBL_NUM+3) | MIB_DEL_TBL_ENTRY)
#define MIB_URLFILTER_DELALL		        ((MIB_URLFILTER_TBL_NUM+4)| MIB_DELALL_TBL_ENTRY)
//#define MIB_URLFILTER_MODE		255

#define MIB_VPN_PASSTHRU_IPSEC_ENABLED	245
#define MIB_VPN_PASSTHRU_PPTP_ENABLED	246
#define MIB_VPN_PASSTHRU_L2TP_ENABLED	247
//This MIB define would be the same as other if IPV6 enabled
//#define MIB_CUSTOM_PASSTHRU_ENABLED		386
#define MIB_CUSTOM_PASSTHRU_ENABLED			17200
#endif

//#ifdef SNMP_SUPPORT Keith remove
#define MIB_SNMP_RO_COMMUNITY           248
#define MIB_SNMP_RW_COMMUNITY           249
//#endif Keith remove
#ifdef UNIVERSAL_REPEATER
#define MIB_REPEATER_ENABLED1		250
#define MIB_REPEATER_SSID1		251
#define MIB_REPEATER_ENABLED2		252
#define MIB_REPEATER_SSID2		253
#endif

// added by rock /////////////////////////////////////////
#ifdef VOIP_SUPPORT
#define MIB_VOIP_CFG			254
#endif // VOIP_SUPPORT

#define MIB_URLFILTER_MODE		255

#define MIB_WIFI_SPECIFIC		260

#define MIB_PPP_SERVICE_NAME			261

#define MIB_WLAN_TURBO_MODE			262
#define MIB_WLAN_RFPOWER_SCALE		263
/* WNC-NMR0000-JOE-PENG-20140724-Implemen section 4.4.38 site survey page of Linear step 2 (repeater mode) */
#define MIB_WLAN_MULTI_STAGE_CONNECTION		264
/* WNC-NMR0000-JOE-PENG-20140806-Implement section 5.22.8 Take Over Broadcast-SSID from AP */
#define MIB_WLAN_TAKE_OVER_SSID		265
/* WNC-NMR0000-JOE-PENG-20170713-Apply Realtek patch 20170707_NEC_3411B_97F_NICM2U.rar to Aero-G codebase-start */
#ifdef CONFIG_NIC_M2U
#define MIB_NIC_M2U		266
#endif
/* WNC-NMR0000-JOE-PENG-20170713-Apply Realtek patch 20170707_NEC_3411B_97F_NICM2U.rar to Aero-G codebase-end */
#ifdef WIFI_SIMPLE_CONFIG
#define MIB_WLAN_WSC_SW_PIN 	268	/* WNC-MR0000-[Voyager]-Libera-20131216- new MIB for software PIN code of WPS */
//libera -- , spec. changed by D02-0000040692_V1.4.0_Pocket_SW_SpecChangeRequest
#define MIB_WLAN_WSC_CFG_BY_EXREG_DISABLE 	269	/* WNC-MR000-Libera-20130619- new spec: Disable configured by exReg */// 20130731-spec.V1.6.0 recover
#define MIB_WLAN_WSC_DISABLE 		270
#define MIB_WLAN_WSC_METHOD			271
#define MIB_WLAN_WSC_CONFIGURED		272
#define MIB_HW_WSC_PIN				273
#define MIB_WLAN_WSC_AUTH			274
#define MIB_WLAN_WSC_ENC				275
#define MIB_WLAN_WSC_MANUAL_ENABLED 	276
#define MIB_WLAN_WSC_PSK				277
#define MIB_WLAN_WSC_SSID			278
#define MIB_WLAN_WSC_UPNP_ENABLED	279
#define MIB_WLAN_WSC_REGISTRAR_ENABLED 	280
#define MIB_WLAN_WSC_CONFIGBYEXTREG 	281
#endif
//Brad addd
#define MIB_DAYLIGHT_SAVE		282
#define MIB_IGMP_PROXY_DISABLED		283
//Brad add for 11N
#define MIB_WLAN_CHANNEL_BONDING 284
#define MIB_WLAN_CONTROL_SIDEBAND 285
#define MIB_WLAN_AGGREGATION 286
#define MIB_WLAN_SHORT_GI 287
//Brad define 
#define MIB_WLAN_WEP64_KEY		288
#define MIB_WLAN_WEP128_KEY		289

#define MIB_HW_11N_XCAP			290
#define MIB_HW_11N_RXIMR		291
#define MIB_DHCPRSVDIP_ENABLED		292
#define MIB_DHCPRSVDIP_TBL_NUM		293
#define MIB_DHCPRSVDIP_TBL			((MIB_DHCPRSVDIP_TBL_NUM+1)|MIB_TABLE_LIST)
#define MIB_DHCPRSVDIP_ADD       	((MIB_DHCPRSVDIP_TBL_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_DHCPRSVDIP_DEL        	((MIB_DHCPRSVDIP_TBL_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_DHCPRSVDIP_MOD			((MIB_DHCPRSVDIP_TBL_NUM+3)|MIB_DEL_TBL_ENTRY | MIB_MOD_TBL_ENTRY)
#define MIB_DHCPRSVDIP_DELALL		((MIB_DHCPRSVDIP_TBL_NUM+4)|MIB_DELALL_TBL_ENTRY)
#define MIB_HW_11N_LOFDMPWD    298
#define MIB_HW_11N_ANTPWD_B     299
#define MIB_HW_11N_ANTPWD_C     300
#define MIB_HW_11N_ANTPWD_D     301
#define MIB_HW_11N_THER_RFIC        302
#define MIB_HW_WLAN_ADDR1		303
#define MIB_HW_WLAN_ADDR2		304
#define MIB_HW_WLAN_ADDR3		305
#define MIB_HW_WLAN_ADDR4		306

// GW_QOS_ENGINE
#define MIB_QOS_ENABLED		       307
#define MIB_QOS_AUTO_UPLINK_SPEED      308
#define MIB_QOS_MANUAL_UPLINK_SPEED    309
#define MIB_QOS_RULE_TBL_NUM	       310
#define MIB_QOS_RULE_TBL		      ((MIB_QOS_RULE_TBL_NUM+1)|MIB_TABLE_LIST)
#define MIB_QOS_ADD		       		((MIB_QOS_RULE_TBL_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_QOS_DEL		            ((MIB_QOS_RULE_TBL_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_QOS_MOD					((MIB_QOS_RULE_TBL_NUM+3)|MIB_DEL_TBL_ENTRY | MIB_MOD_TBL_ENTRY)
#define MIB_QOS_DELALL		        ((MIB_QOS_RULE_TBL_NUM+4)|MIB_DELALL_TBL_ENTRY)

#define MIB_WLAN_ACCESS			315
#define MIB_WLAN_PRIORITY		316

#define MIB_START_MP	317

#define MIB_SYSTIME_YEAR	321
#define MIB_SYSTIME_MON	322
#define MIB_SYSTIME_DAY		323
#define MIB_SYSTIME_HOUR	324
#define MIB_SYSTIME_MIN		325
#define MIB_SYSTIME_SEC		326
#define MIB_IGMP_FAST_LEAVE_DISABLED  	327

/* # keith: add l2tp support. 20080515 */
#define MIB_L2TP_IP_ADDR					331
#define MIB_L2TP_SUBNET_MASK			332
#define MIB_L2TP_SERVER_IP_ADDR			333
#define MIB_L2TP_USER_NAME				334
#define MIB_L2TP_PASSWORD			335
#define MIB_L2TP_MTU_SIZE			336
#define MIB_L2TP_CONNECTION_TYPE	337
#define MIB_L2TP_IDLE_TIME 			338

// Patch for our router under another router to dial up l2tp
#define MIB_L2TP_DEFAULT_GW		339

// Patch for our router under another router to dial up pptp
#define MIB_PPTP_DEFAULT_GW	340
#define MIB_PPTP_WAN_IP_DYNAMIC 	341
#ifdef CONFIG_GET_SERVER_IP_BY_DOMAIN
#define MIB_PPTP_SERVER_DOMAIN	342
#define MIB_PPTP_GET_SERV_BY_DOMAIN 343
#endif
#ifndef _PATH_PROCNET_DEV
#define _PATH_PROCNET_DEV "/proc/net/dev"
#endif
#ifndef _PATH_PROCNET_IFINET6
#define _PATH_PROCNET_IFINET6 "/proc/net/if_inet6"
#endif
#define MIB_HAME_LANG 16029
#ifdef CONFIG_IPV6
#ifdef CONFIG_IPV6_CE_ROUTER_SUPPORT
#define	MIB_IPV6_ULA_ENABLE		350
#define	MIB_IPV6_ULA_MODE		351
#define MIB_IPV6_ADDR_ULA_PARAM	352
#endif
#define MIB_IPV6_ID                        370
#define MIB_IPV6_RADVD_PARAM 		(MIB_IPV6_ID)
#define MIB_IPV6_DNSV6_PARAM 		(MIB_IPV6_ID+1)
#define MIB_IPV6_DHCPV6S_PARAM 		(MIB_IPV6_ID+2)
#define MIB_IPV6_ADDR_PARAM 		(MIB_IPV6_ID+3)
#define MIB_IPV6_TUNNEL_PARAM 		(MIB_IPV6_ID+4)
#define MIB_IPV6_DHCPV6C_PARAM 		(MIB_IPV6_ID+5)
#define MIB_IPV6_ADDR6_PARAM 		(MIB_IPV6_ID+6)
#define MIB_IPV6_ADDR_LAN_PARAM 	(MIB_IPV6_ID+7)
#define MIB_IPV6_ADDR_WAN_PARAM 	(MIB_IPV6_ID+8)
#define MIB_IPV6_ADDR_GW_PARAM		(MIB_IPV6_ID+9)
#define MIB_IPV6_ADDR_PFEFIX_PARAM	(MIB_IPV6_ID+10)
#define MIB_IPV6_ADDR_DNS_PARAM		(MIB_IPV6_ID+11)
#define MIB_IPV6_ADDR_DNS_SECONDARY	369
#define MIB_IPV6_ORIGIN_TYPE		(MIB_IPV6_ID+12)
#define MIB_IPV6_LINK_TYPE			(MIB_IPV6_ID+13)
#define MIB_IPV6_WAN_ENABLE			(MIB_IPV6_ID+14)
#define MIB_IPV6_DNS_AUTO			(MIB_IPV6_ID+15)
#define MIB_MLD_PROXY_DISABLED		(MIB_IPV6_ID+16)
#define MIB_IPV6_DHCP_MODE			(MIB_IPV6_ID+17)
#define MIB_IPV6_DHCP_PD_ENABLE		(MIB_IPV6_ID+18)
#define MIB_IPV6_DHCP_RAPID_COMMIT_ENABLE		(MIB_IPV6_ID+19)
#define MIB_IPV6_DHCPC_RAPID_COMMIT		(MIB_IPV6_ID+20)
#ifdef TR181_SUPPORT
#define IPV6_DHCPC_SENDOPT_NUM	10
#define IPV6_DHCPC_RCVOPT_NUM	16
#define MIB_IPV6_DHCPC_REQUEST_ADDR	(MIB_IPV6_ID+21)
#define MIB_IPV6_DHCPC_SUGGESTEDT1		(MIB_IPV6_ID+22)
#define MIB_IPV6_DHCPC_SUGGESTEDT2		(MIB_IPV6_ID+23)
#define MIB_IPV6_DHCPC_SENDOPT_TBL_NUM	(MIB_IPV6_ID+25)
#define MIB_IPV6_DHCPC_SENDOPT_TBL  ((MIB_IPV6_DHCPC_SENDOPT_TBL_NUM+1)|MIB_TABLE_LIST) 
#define MIB_IPV6_DHCPC_SENDOPT_MOD  ((MIB_IPV6_DHCPC_SENDOPT_TBL_NUM+3) | MIB_DEL_TBL_ENTRY | MIB_MOD_TBL_ENTRY)

#define MIB_IPV6_DHCPC_SENDOPT_ENABLE	(MIB_IPV6_ID+31)
#define MIB_IPV6_DHCPC_SENDOPT_TAG		(MIB_IPV6_ID+32)
#define MIB_IPV6_DHCPC_SENDOPT_VALUE	(MIB_IPV6_ID+33)
#define MIB_IPV6_DHCPC_IFACE			(MIB_IPV6_ID+34)
#define MIB_IPV6_DHCPC_SENDOPT_INDEX	(MIB_IPV6_ID+35)


#endif
#ifdef CONFIG_APP_RADVD_WAN
#define MIB_IPV6_RADVD_PARAM_WAN 		(MIB_IPV6_ID+36)
#endif

#define MIB_IPV6_DNS_FORWARD			(MIB_IPV6_ID+37)


typedef enum IPV6_ORIGIN_T_
{
	IPV6_ORIGIN_DHCP =0,
	IPV6_ORIGIN_STATIC =1,
#ifdef CONFIG_SIXRD_SUPPORT
	IPV6_ORIGIN_6RD = 2,
#endif
	IPV6_ORIGIN_NONE =3
} IPV6_ORIGIN_T;

typedef enum IPV6_LINKTYPE_T_
{
	IPV6_LINKTYPE_IP=0,
	IPV6_LINKTYPE_PPP=1
}IPV6_LINKTYPE_T;

typedef enum IPV6_DHCP_MODE_T_
{
	IPV6_DHCP_STATELESS=0,
	IPV6_DHCP_STATEFUL=1
}IPV6_DHCP_MODE_T;


#endif

#ifdef TR181_SUPPORT
/* add for Device.DNS. Device.DNS.Client. and Device.DNS.Client.Server.{i}. */
#define MIB_DNS_CLIENT_ENABLE 406
#ifdef CONFIG_IPV6
#define DNS_CLIENT_SERVER_NUM 10
#else
#define DNS_CLIENT_SERVER_NUM 6
#endif
#define MIB_DNS_CLIENT_SERVER_TBL_NUM	408
#define MIB_DNS_CLIENT_SERVER_TBL  ((MIB_DNS_CLIENT_SERVER_TBL_NUM+1)|MIB_TABLE_LIST) 
#define MIB_DNS_CLIENT_SERVER_MOD  ((MIB_DNS_CLIENT_SERVER_TBL_NUM+3) | MIB_DEL_TBL_ENTRY | MIB_MOD_TBL_ENTRY)

#define MIB_DNS_CLIENT_SERVER_INDEX 414
#define MIB_DNS_CLIENT_SERVER_ENABLE 415
#define MIB_DNS_CLIENT_SERVER_STATUS 416
//#define MIB_DNS_CLIENT_SERVER_ALIAS MIB_IPV6_ID+47
#define MIB_DNS_CLIENT_SERVER_IPADDR 418
//#define MIB_DNS_CLIENT_SERVER_IF MIB_IPV6_ID+49
#define MIB_DNS_CLIENT_SERVER_TYPE 420
#endif

#ifdef CONFIG_IPV6
#ifdef CONFIG_DSLITE_SUPPORT
#define MIB_IPV6_ADDR_AFTR_PARAM	421
#define MIB_DSLITE_MODE				422
#endif
#ifdef CONFIG_SIXRD_SUPPORT
#define MIB_IPV6_6RD_PREFIX_PARAM	423
#define MIB_IPV4_6RD_MASK_LEN		424
#define MIB_IPV4_6RD_BR_ADDR		425
#endif
#endif

// SNMP, Forrest added, 2007.10.25.
#ifdef CONFIG_SNMP
#define MIB_SNMP_ENABLED		435
#define MIB_SNMP_NAME			436
#define MIB_SNMP_LOCATION		437
#define MIB_SNMP_CONTACT		438
#define MIB_SNMP_RWCOMMUNITY	439
#define MIB_SNMP_ROCOMMUNITY	440
#define MIB_SNMP_TRAP_RECEIVER1	441
#define MIB_SNMP_TRAP_RECEIVER2	442
#define MIB_SNMP_TRAP_RECEIVER3	443
#endif

//### add by sen_liu 2011.3.29 TX Beamforming added to mib in 92D
#define MIB_WLAN_TX_BEAMFORMING	450
//### end

/*hf add for country str*/
#define MIB_WLAN_COUNTRY_STRING 451
/*end*/

#define MIB_WLAN_TX_RESTRICT 452
#define MIB_WLAN_RX_RESTRICT 453

#define MIB_WLAN_TXBF_MU	454


//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20130314, Add 5G band select
#define MIB_WLAN_BAND_5G_SELECT 488
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20130314, Add 5G band select End

/* # keith: add l2tp support. 20080515 */
#ifdef CONFIG_GET_SERVER_IP_BY_DOMAIN
#define MIB_L2TP_GET_SERV_BY_DOMAIN 499
#define MIB_L2TP_SERVER_DOMAIN		500
#endif
#define MIB_L2TP_WAN_IP_DYNAMIC		501
#define MIB_L2TP_GATEWAY		502
//SCHEDULE

#define MIB_WLAN_SCHEDULE_ENABLED		503
#define MIB_WLAN_SCHEDULE_TBL_NUM			504
#define MIB_WLAN_SCHEDULE_TBL			((MIB_WLAN_SCHEDULE_TBL_NUM+1)|MIB_TABLE_LIST)
#define MIB_WLAN_SCHEDULE_ADD			((MIB_WLAN_SCHEDULE_TBL_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_WLAN_SCHEDULE_DEL			((MIB_WLAN_SCHEDULE_TBL_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_WLAN_SCHEDULE_MOD			((MIB_WLAN_SCHEDULE_TBL_NUM+3)|MIB_DEL_TBL_ENTRY| MIB_MOD_TBL_ENTRY)
#define MIB_WLAN_SCHEDULE_DELALL			((MIB_WLAN_SCHEDULE_TBL_NUM+4)|MIB_DELALL_TBL_ENTRY)

#define MIB_PPTP_CONNECTION_TYPE	509
#define MIB_PPTP_IDLE_TIME 			510


//NewAdd For rtl8196B
#define MIB_HW_WLAN_ADDR5		511
#define MIB_HW_WLAN_ADDR6		512
#define MIB_HW_WLAN_ADDR7		513

#define MIB_HW_TX_POWER_OFDM_1S 514
#define MIB_HW_TX_POWER_OFDM_2S 515
#define MIB_HW_11N_LOFDMPWDA    516
#define MIB_HW_11N_LOFDMPWDB    517
#define MIB_HW_11N_TSSI1     518
#define MIB_HW_11N_TSSI2     519
#define MIB_HW_11N_THER 520
#define MIB_HW_11N_TRSWITCH 521        //MIB_HW_11N_ESERVED1->MIB_HW_11N_TRSWITCH
#define MIB_HW_11N_TRSWPAPE_C9 522
#define MIB_HW_11N_TRSWPAPE_CC 523
#define MIB_HW_11N_TARGET_PWR 524
#define MIB_HW_11N_PA_TYPE 525
#define MIB_HW_11N_THER_2 526
#define MIB_HW_11N_XCAP_2 527
#define MIB_HW_11N_KFREE_ENABLE 528

/*-----end-----*/

// SNMP maximum length of fields, Forrest added, 2007.10.25.
#ifdef CONFIG_SNMP
#define MAX_SNMP_NAME_LEN		64
#define MAX_SNMP_LOCATION_LEN		64
#define MAX_SNMP_CONTACT_LEN		64
#define MAX_SNMP_COMMUNITY_LEN          64
#endif

#ifdef CONFIG_APP_SIMPLE_CONFIG
#define MAX_SC_DEVICE_NAME	64
#endif

#ifndef CONFIG_WNC_REMOVE_MESH
//=========add for MESH=========
//#ifdef CONFIG_RTK_MESH Keith remove
#define MIB_WLAN_MESH_ENABLE    644	//new feature:Mesh enable/disable
#define MIB_WLAN_MESH_ROOT_ENABLE   551
#define MIB_WLAN_MESH_ID			554
#define MIB_WLAN_MESH_MAX_NEIGHTBOR	555
#define MIB_WLAN_MESH_ENCRYPT		559
#define MIB_WLAN_MESH_PSK_FORMAT	560
#define MIB_WLAN_MESH_WPA_PSK		561
#define MIB_WLAN_MESH_WPA_AUTH		562
#define MIB_WLAN_MESH_WPA2_CIPHER_SUITE	563

//#ifdef _MESH_ACL_ENABLE_ Keith remove
#define MIB_WLAN_MESH_ACL_ENABLED		580
#define MIB_WLAN_MESH_ACL_NUM			581
#define MIB_WLAN_MESH_ACL_ADDR			((MIB_WLAN_MESH_ACL_NUM+1)|MIB_TABLE_LIST)
#define MIB_WLAN_MESH_ACL_ADDR_ADD		((MIB_WLAN_MESH_ACL_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_WLAN_MESH_ACL_ADDR_DEL		((MIB_WLAN_MESH_ACL_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_WLAN_MESH_ACL_ADDR_DELALL	((MIB_WLAN_MESH_ACL_NUM+4)|MIB_DELALL_TBL_ENTRY)
//#endif Keith remove

#define MIB_WLAN_MESH_TEST_PARAM1		600
#define MIB_WLAN_MESH_TEST_PARAM2		601
#define MIB_WLAN_MESH_TEST_PARAM3		602
#define MIB_WLAN_MESH_TEST_PARAM4		603
#define MIB_WLAN_MESH_TEST_PARAM5		604
#define MIB_WLAN_MESH_TEST_PARAM6		605
#define MIB_WLAN_MESH_TEST_PARAM7		606
#define MIB_WLAN_MESH_TEST_PARAM8		607
#define MIB_WLAN_MESH_TEST_PARAM9		608
#define MIB_WLAN_MESH_TEST_PARAMA		609
#define MIB_WLAN_MESH_TEST_PARAMB		610
#define MIB_WLAN_MESH_TEST_PARAMC		611
#define MIB_WLAN_MESH_TEST_PARAMD		612
#define MIB_WLAN_MESH_TEST_PARAME		613
#define MIB_WLAN_MESH_TEST_PARAMF		614
#define MIB_WLAN_MESH_TEST_PARAMSTR1		615
//#endif // CONFIG_RTK_MESH Keith remove
//=========add for MESH=========
#endif

#define MIB_VLANCONFIG_ENABLED		616
#define MIB_VLANCONFIG_TBL_NUM		617
#define MIB_VLANCONFIG_TBL			((MIB_VLANCONFIG_TBL_NUM+1)|MIB_TABLE_LIST)
#define MIB_VLANCONFIG_ADD       	((MIB_VLANCONFIG_TBL_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_VLANCONFIG_DEL        	((MIB_VLANCONFIG_TBL_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_VLANCONFIG_MOD			((MIB_VLANCONFIG_TBL_NUM+3)|MIB_DEL_TBL_ENTRY | MIB_MOD_TBL_ENTRY)
#define MIB_VLANCONFIG_DELALL		((MIB_VLANCONFIG_TBL_NUM+4)|MIB_DELALL_TBL_ENTRY)

//#ifdef CONFIG_RTL_WAPI_SUPPORT Keith remove
//WAPI start from 630
#define MIB_WLAN_WAPI_PSK   				630
#define MIB_WLAN_WAPI_PSKLEN   			631
#define MIB_WLAN_WAPI_PSK_FORMAT		632
#define MIB_WLAN_WAPI_AUTH				633
#define MIB_WLAN_WAPI_ASIPADDR    			634
#define MIB_WLAN_WAPI_SEARCHINFO    635
#define MIB_WLAN_WAPI_SEARCHINDEX    636
#define MIB_WLAN_WAPI_MCASTREKEY    637
#define MIB_WLAN_WAPI_MCAST_TIME    638
#define MIB_WLAN_WAPI_MCAST_PACKETS    639
#define MIB_WLAN_WAPI_UCASTREKEY    640
#define MIB_WLAN_WAPI_UCAST_TIME    641
#define MIB_WLAN_WAPI_UCAST_PACKETS    642
#define MIB_WLAN_WAPI_CA_INIT                 643



#define MIB_NAT_ENABLED 645
#define MIB_WLAN_STBC_ENABLED 646
#define MIB_WLAN_COEXIST_ENABLED 647
#define MIB_WLAN_LDPC_ENABLED 648
#define MIB_SAMBA_ENABLED 650
// GW_QOS_ENGINE
#define MIB_QOS_AUTO_DOWNLINK_SPEED      651
#define MIB_QOS_MANUAL_DOWNLINK_SPEED      652
#define MIB_MIB_VER 655

//Added to support two remote as and one local as at the same time
#define MIB_WLAN_WAPI_CERT_SEL    		656

#define MIB_WLAN_WAPI_AUTH_MODE_2or3_CERT 657

//WNC-NMRXXXX-Yuan-I-Chou-20160811, Configured value restoration support
//We use this MIB as flag
//#ifdef DEFSETTING_AUTO_UPDATE
#define MIB_NEED_AUTO_UPDATE 658
//#endif
//WNC-NMRXXXX-Yuan-I-Chou-20160811, Configured value restoration support End

//11n onoff TKIP
#define MIB_WLAN_11N_ONOFF_TKIP		660

#define MIB_WLAN_LOWEST_MLCST_RATE 663
#define MIB_WLAN_MC2U_DISABLED	664



#define MIB_WLAN_TDLS_PROHIBITED 	665
#define MIB_WLAN_TDLS_CS_PROHIBITED 666



//=========add for STA Control=========
#define MIB_WLAN_STACTRL_ENABLE    670
#define MIB_WLAN_STACTRL_PREFER    671

//#ifdef CONFIG_RTL_WAPI_SUPPORT Keith remove
#define CERTS_DATABASE  "/var/myca/index.txt"
#define ONE_DAY_SECONDS 86400
#define USER_NAME_LEN 32
typedef struct _CertsDbEntry_ {
        unsigned char userName[USER_NAME_LEN];  //user name of this user cert
        unsigned long serial;                   //serial of this cert
        unsigned short validDays;               //total valid days of this cert
        unsigned short validDaysLeft;           //the left valid days of this cert
        unsigned char certType;                 //0(default): X.509; others: reserved
        unsigned char certStatus;               //0(default): valid; 1: expired; 2: revoked
} CERTS_DB_ENTRY_T, *CERTS_DB_ENTRY_Tp;
//#endif Keith remove
//WAPI END





#if (defined CONFIG_RTL_BT_CLIENT) || (defined CONFIG_RTL_TRANSMISSION)
#define MIB_BT_UPLOAD_DIR	680
#define MIB_BT_DOWNLOAD_DIR 681
#define MIB_BT_TOTAL_ULIMIT 682
#define MIB_BT_TOTAL_DLIMIT 683
#define MIB_BT_REFRESH_TIME 684
#define MIB_BT_ENABLED 685
#endif

#define MIB_WLAN_ACK_TIMEOUT	686

#ifdef WLAN_HS2_CONFIG
#define MIB_WLAN_HS2_ENABLE	687
#endif

#ifdef CONFIG_IEEE80211W
#define MIB_WLAN_IEEE80211W	688
#define MIB_WLAN_SHA256_ENABLE	689

#endif

#define MIB_WLAN_MFIWAC_CONFIGURED	    690
#define MIB_MFI_WAC_DEVICE_NAME			691
#define MIB_MFI_AIRPLAY_PASSWD			692
// 2-2.4G, 5-5G
#define MIB_MFI_WAC_BAND                693
#define MIB_HAP_ACCESSORY_SETUPCODE     3000 //mark_kit

#define BRIDGE_ETHERNET		0
#define BRIDGE_PPPOE		1
#define BRIDGE_DISABLE		2
typedef enum { IP_BRIDGE=0, IP_ROUTE=1, IP_PPP=2} CMODE_T; //WANIface Mode Not the Method of getting IP address
/*+++++added by Jack for Tr-069 configuration+++++*/
#if !defined(CONFIG_APP_TR069)
#define ALIASNAME_VC   "vc" 
#define ALIASNAME_BR   "br" 
#define ALIASNAME_NAS  "nas"
#define ALIASNAME_DSL  "dsl"
#define ALIASNAME_ETH  "eth"
#define ALIASNAME_WLAN "wlan"
#define ALIASNAME_PPP  "ppp"
#define ALIASNAME_MWNAS  "nas0_"
#define ALIASNAME_ETH0DOT  "eth0."
#define _PRMT_TR143_				1
#if defined(_PRMT_TR143_)
#define RTL_DEV_NAME_NUM(name,num)	name#num

#define ALIASNAME_VC0   RTL_DEV_NAME_NUM(ALIASNAME_VC,0)//"vc0" 
#define ALIASNAME_BR0   RTL_DEV_NAME_NUM(ALIASNAME_BR,0)//"br0" 
#define ALIASNAME_WLAN0  RTL_DEV_NAME_NUM(ALIASNAME_WLAN,0)//"wlan0"
#define ALIASNAME_WLAN1  RTL_DEV_NAME_NUM(ALIASNAME_WLAN,1)//"wlan1"
#define ALIASNAME_NAS0  RTL_DEV_NAME_NUM(ALIASNAME_NAS,0)//nas0
#define ALIASNAME_DSL0  RTL_DEV_NAME_NUM(ALIASNAME_DSL,0)//dsl0
#define ALIASNAME_ETH0  RTL_DEV_NAME_NUM(ALIASNAME_ETH,0)//eth0
#define ALIASNAME_PPP0  RTL_DEV_NAME_NUM(ALIASNAME_PPP,0)//ppp0

#define ALIASNAME_VAP   "-vap" //must include '-' at fast
#define ALIASNAME_WLAN0_VAP  RTL_DEV_NAME_NUM(ALIASNAME_WLAN0,-vap)//"wlan0-vap"
#define ALIASNAME_WLAN1_VAP  RTL_DEV_NAME_NUM(ALIASNAME_WLAN1,-vap)//"wlan1-vap"
#define ALIASNAME_WLAN0__VAP  RTL_DEV_NAME_NUM(ALIASNAME_WLAN0,_vap)//"wlan0_vap"
#define ALIASNAME_WLAN0__VAP0  RTL_DEV_NAME_NUM(ALIASNAME_WLAN0__VAP,0)//"wlan0_vap0"
#define ALIASNAME_WLAN0__VAP1  RTL_DEV_NAME_NUM(ALIASNAME_WLAN0__VAP,1)//"wlan0_vap1"
#define ALIASNAME_WLAN0__VAP2  RTL_DEV_NAME_NUM(ALIASNAME_WLAN0__VAP,2)//"wlan0_vap2"
#define ALIASNAME_WLAN0__VAP3  RTL_DEV_NAME_NUM(ALIASNAME_WLAN0__VAP,3)//"wlan0_vap3"

#define ALIASNAME_WLAN0_VAP0  RTL_DEV_NAME_NUM(ALIASNAME_WLAN0_VAP,0)//"wlan0-vap0"
#define ALIASNAME_WLAN0_VAP1  RTL_DEV_NAME_NUM(ALIASNAME_WLAN0_VAP,1)//"wlan0-vap1"
#define ALIASNAME_WLAN0_VAP2  RTL_DEV_NAME_NUM(ALIASNAME_WLAN0_VAP,2)//"wlan0-vap2"
#define ALIASNAME_WLAN0_VAP3  RTL_DEV_NAME_NUM(ALIASNAME_WLAN0_VAP,3)//"wlan0-vap3"

#define ALIASNAME_WLAN1_VAP0  RTL_DEV_NAME_NUM(ALIASNAME_WLAN1_VAP,0)//"wlan0-vap0"
#define ALIASNAME_WLAN1_VAP1  RTL_DEV_NAME_NUM(ALIASNAME_WLAN1_VAP,1)//"wlan0-vap0"
#define ALIASNAME_WLAN1_VAP2  RTL_DEV_NAME_NUM(ALIASNAME_WLAN1_VAP,2)//"wlan0-vap0"
#define ALIASNAME_WLAN1_VAP3  RTL_DEV_NAME_NUM(ALIASNAME_WLAN1_VAP,3)//"wlan0-vap0"

#define ALIASNAME_ETH0DOT2  RTL_DEV_NAME_NUM(ALIASNAME_ETH0DOT,2)
#define ALIASNAME_ETH0DOT3  RTL_DEV_NAME_NUM(ALIASNAME_ETH0DOT,3)
#define ALIASNAME_ETH0DOT4  RTL_DEV_NAME_NUM(ALIASNAME_ETH0DOT,4)
#define ALIASNAME_ETH0DOT5  RTL_DEV_NAME_NUM(ALIASNAME_ETH0DOT,5)

#define ALIASNAME_ETH0_SW  RTL_DEV_NAME_NUM(ALIASNAME_ETH0,_sw)
#define ALIASNAME_ETH0_SW0  RTL_DEV_NAME_NUM(ALIASNAME_ETH0_SW,0)
#define ALIASNAME_ETH0_SW1  RTL_DEV_NAME_NUM(ALIASNAME_ETH0_SW,1)
#define ALIASNAME_ETH0_SW2  RTL_DEV_NAME_NUM(ALIASNAME_ETH0_SW,2)
#define ALIASNAME_ETH0_SW3 RTL_DEV_NAME_NUM(ALIASNAME_ETH0_SW,3)

#define ALIASNAME_BR00  RTL_DEV_NAME_NUM(ALIASNAME_BR0,:0)
#define ALIASNAME_BR01  RTL_DEV_NAME_NUM(ALIASNAME_BR0,:1)

typedef enum
{
	ITF_ALL=0,
	ITF_WAN,	//wan pppx or vcx
	ITF_LAN,	//br0

	ITF_ETH0,	//eth0
	ITF_ETH0_SW0,	//eth0_sw0
	ITF_ETH0_SW1,	//eth0_sw1
	ITF_ETH0_SW2,	//eth0_sw2
	ITF_ETH0_SW3,	//eth0_sw3
	
	ITF_WLAN0,	//wlan0
	ITF_WLAN0_VAP0,	//wlan0-vap0
	ITF_WLAN0_VAP1,	//wlan0-vap1
	ITF_WLAN0_VAP2,	//wlan0-vap2
	ITF_WLAN0_VAP3,	//wlan0-vap3
	
	ITF_WLAN1,	//wlan0
	ITF_WLAN1_VAP0,	//wlan0-vap0
	ITF_WLAN1_VAP1,	//wlan0-vap1
	ITF_WLAN1_VAP2,	//wlan0-vap2
	ITF_WLAN1_VAP3,	//wlan0-vap3
	
	ITF_USB0,	//usb0
	
	ITF_END		//last one
} ITF_T;

#endif

#define mib_get(S, T)  apmib_get(S, T)
#define mib_set(S, T)  apmib_set(S, T)
#define mib_update(S)  apmib_update(S)

#endif

#ifdef CONFIG_APP_TR069
/* Keith add for tr069 --start */
#undef mib_get
#undef mib_set
#undef mib_update
#define MAX_WAN_NAME_LEN				40	// E8 WAN connection name
// resv | media | ppp | vc
#define MAX_VC_NUM					8
#define MAX_PPP_NUM					8
#define PHY_INTF(x)				(x | 0xff00)/*physical interface*/
#define VC_INDEX(x)				(x & 0x0ff)
#define ETH_INDEX(x)				(x & 0x0ff)
#define PPP_INDEX(x)				((x  >> 8) & 0x0ff)
#define MEDIA_INDEX(x)				((x >> 16) & 0x0ff)
#define TO_IFINDEX(x,y,z)			((x<<16) | (y<<8) | z)
#define DUMMY_VC_INDEX				0xff
#define DUMMY_PPP_INDEX				0xff
#define DUMMY_IFINDEX				0xffff
#define NA_PPP			0xefff
#define NA_VC			0xffff
#define MAX_POE_PER_VC		5
#define STR_LEN_64    64
//bit24~bit31 reserved for lan index, maybe multiple lan will support in future 
#define LAN_INDEX(x) ((x >> 24) & 0xff) 

#define MSG_SIZE (sizeof(struct cwmp_msg) - sizeof(int))
enum {
	eMSG_SEND = 10,
	eMSG_EVENT_CONNREQ,
	eMSG_TIMER,
	eMSG_RECV,
	eMSG_USERDATA_CHANGE,
	eMSG_ACTIVE_NOTIFY
};

struct cwmp_msg {
	int	msg_type;
	int	msg_datatype;
	void*	msg_data;
};

#define _PRMT_X_TELEFONICA_ES_DHCPOPTION_	1

#if defined(_PRMT_X_TELEFONICA_ES_DHCPOPTION_)
#define _CWMP_MIB_	1

#define MODE_LEN			15
#define OPTION_LEN			32
#define OPTION_60_LEN		100
#define GENERAL_LEN			64
#define OPTION_RSV_LEN		100
#define DHCP_OPT_VAL_LEN	OPTION_RSV_LEN+1
#define MAX_DHCP_SERVER_OPTION_NUM	5
#define MAX_DHCP_CLIENT_OPTION_NUM	5
#define MAX_DHCPS_SERVING_POOL_NUM	10

enum e_DHCPOpUsedFor
{
	eUsedFor_DHCPServer = 1,
	eUsedFor_DHCPServer_ServingPool,
	eUsedFor_DHCPClient_Sent,
	eUsedFor_DHCPClient_Req
};
#endif /* #if defined(_PRMT_X_TELEFONICA_ES_DHCPOPTION_) */


typedef enum { MEDIA_ATM, MEDIA_ETH } MEDIA_TYPE_T;
typedef enum { APPTYPE_TR069_INTERNET, APPTYPE_INTERNET, APPTYPE_TR069,
		 APPTYPE_OTHER, APPTYPE_VOICE, APPTYPE_TR069_VOICE,
		 APPTYPE_VOICE_INTERNET, APPTYPE_TR069_VOICE_INTERNET } APPTYPE_T;
typedef enum { PPP_AUTH_AUTO=0, PPP_AUTH_PAP, PPP_AUTH_CHAP, PPP_AUTH_NONE } PPP_AUTH_T;		 

#define mib_get(S, T)  apmib_get(S, T)
#define mib_set(S, T)  apmib_set(S, T)
#define mib_update(S)  apmib_update(S)
#define LANDEVNAME2BR0(a) do{ if(a && (strncmp(a, "eth0", 4)==0||strncmp(a, "wlan0", 5)==0||strncmp(a, "usb0", 4)==0)) strcpy(a, "br0"); }while(0)
	
#ifdef CONFIG_USER_CWMP_WITH_SSL
#define _CWMP_WITH_SSL_				1
#endif //CONFIG_USER_CWMP_WITH_SSL

#if defined(CONFIG_USER_CWMP_WITH_TR143)
#define _PRMT_TR143_				1
#endif

#define TIME_ZONE
#define _PRMT_USERINTERFACE_
#define WLAN_SUPPORT
#define _PRMT_CAPABILITIES_
#define _PRMT_DEVICECONFIG_
#define _TR_111_PRMT_
#if defined(CONFIG_APP_TR069)&&defined(CONFIG_RTL_HTTP_REDIRECT_TR098)
#define _SUPPORT_CAPTIVEPORTAL_PROFILE_
#endif
//#define _PRMT_X_REALTEK_VLANID_

#ifdef MBSSID
#define WLAN_MBSSID			1
#endif

#ifdef UNIVERSAL_REPEATER
#define WLAN_REPEATER
#endif

#define MAC_FILTER
#define ENABLE_WPAAES_WPA2TKIP

//--- for TR098 -------------------------------
#define MOD_FOR_TR098 /* brucehou */
#if defined(MOD_FOR_TR098)
	#define MOD_FOR_TR098_LAYER3FWD
	#define MOD_FOR_TR098_LANDEVICE
	#define MOD_FOR_TR098_VAP
	#define MOD_FOR_TR098_PORTMAP

	
	#if defined(CONFIG_RTL_92D_SUPPORT)
		#define MOD_FOR_TR098_DUALBAND
	#endif

#endif	/* #if defined(MOD_FOR_TR098) */
//--- for TR098 -------------------------------

/* Keith add for tr069 --end */
///////////////////////////////////////////////////////////////////////////Enable for E8C 
#define ALIASNAME_VC   "vc" 
#define ALIASNAME_BR   "br" 
#define ALIASNAME_NAS  "nas"
#define ALIASNAME_DSL  "dsl"
#define ALIASNAME_ETH  "eth"
#define ALIASNAME_WLAN "wlan"
#define ALIASNAME_PPP  "ppp"
#define ALIASNAME_MWNAS  "nas0_"
#define ALIASNAME_ETH0DOT  "eth0."

#if defined(_PRMT_TR143_)
#define RTL_DEV_NAME_NUM(name,num)	name#num

#define ALIASNAME_VC0   RTL_DEV_NAME_NUM(ALIASNAME_VC,0)//"vc0" 
#define ALIASNAME_BR0   RTL_DEV_NAME_NUM(ALIASNAME_BR,0)//"br0" 
#define ALIASNAME_WLAN0  RTL_DEV_NAME_NUM(ALIASNAME_WLAN,0)//"wlan0"
#define ALIASNAME_WLAN1  RTL_DEV_NAME_NUM(ALIASNAME_WLAN,1)//"wlan1"
#define ALIASNAME_NAS0  RTL_DEV_NAME_NUM(ALIASNAME_NAS,0)//nas0
#define ALIASNAME_DSL0  RTL_DEV_NAME_NUM(ALIASNAME_DSL,0)//dsl0
#define ALIASNAME_ETH0  RTL_DEV_NAME_NUM(ALIASNAME_ETH,0)//eth0
#define ALIASNAME_ETH1  RTL_DEV_NAME_NUM(ALIASNAME_ETH,1)//eth1
#define ALIASNAME_PPP0  RTL_DEV_NAME_NUM(ALIASNAME_PPP,0)//ppp0

#define ALIASNAME_VAP   "-vap" //must include '-' at fast
#define ALIASNAME_WLAN0_VAP  RTL_DEV_NAME_NUM(ALIASNAME_WLAN0,-vap)//"wlan0-vap"
#define ALIASNAME_WLAN1_VAP  RTL_DEV_NAME_NUM(ALIASNAME_WLAN1,-vap)//"wlan1-vap"
#define ALIASNAME_WLAN0__VAP  RTL_DEV_NAME_NUM(ALIASNAME_WLAN0,_vap)//"wlan0_vap"
#define ALIASNAME_WLAN0__VAP0  RTL_DEV_NAME_NUM(ALIASNAME_WLAN0__VAP,0)//"wlan0_vap0"
#define ALIASNAME_WLAN0__VAP1  RTL_DEV_NAME_NUM(ALIASNAME_WLAN0__VAP,1)//"wlan0_vap1"
#define ALIASNAME_WLAN0__VAP2  RTL_DEV_NAME_NUM(ALIASNAME_WLAN0__VAP,2)//"wlan0_vap2"
#define ALIASNAME_WLAN0__VAP3  RTL_DEV_NAME_NUM(ALIASNAME_WLAN0__VAP,3)//"wlan0_vap3"

#define ALIASNAME_WLAN0_VAP0  RTL_DEV_NAME_NUM(ALIASNAME_WLAN0_VAP,0)//"wlan0-vap0"
#define ALIASNAME_WLAN0_VAP1  RTL_DEV_NAME_NUM(ALIASNAME_WLAN0_VAP,1)//"wlan0-vap1"
#define ALIASNAME_WLAN0_VAP2  RTL_DEV_NAME_NUM(ALIASNAME_WLAN0_VAP,2)//"wlan0-vap2"
#define ALIASNAME_WLAN0_VAP3  RTL_DEV_NAME_NUM(ALIASNAME_WLAN0_VAP,3)//"wlan0-vap3"

#define ALIASNAME_WLAN1_VAP0  RTL_DEV_NAME_NUM(ALIASNAME_WLAN1_VAP,0)//"wlan0-vap0"
#define ALIASNAME_WLAN1_VAP1  RTL_DEV_NAME_NUM(ALIASNAME_WLAN1_VAP,1)//"wlan0-vap0"
#define ALIASNAME_WLAN1_VAP2  RTL_DEV_NAME_NUM(ALIASNAME_WLAN1_VAP,2)//"wlan0-vap0"
#define ALIASNAME_WLAN1_VAP3  RTL_DEV_NAME_NUM(ALIASNAME_WLAN1_VAP,3)//"wlan0-vap0"

#define ALIASNAME_ETH0DOT2  RTL_DEV_NAME_NUM(ALIASNAME_ETH0DOT,2)
#define ALIASNAME_ETH0DOT3  RTL_DEV_NAME_NUM(ALIASNAME_ETH0DOT,3)
#define ALIASNAME_ETH0DOT4  RTL_DEV_NAME_NUM(ALIASNAME_ETH0DOT,4)
#define ALIASNAME_ETH0DOT5  RTL_DEV_NAME_NUM(ALIASNAME_ETH0DOT,5)

#define ALIASNAME_ETH0_SW  RTL_DEV_NAME_NUM(ALIASNAME_ETH0,_sw)
#define ALIASNAME_ETH0_SW0  RTL_DEV_NAME_NUM(ALIASNAME_ETH0_SW,0)
#define ALIASNAME_ETH0_SW1  RTL_DEV_NAME_NUM(ALIASNAME_ETH0_SW,1)
#define ALIASNAME_ETH0_SW2  RTL_DEV_NAME_NUM(ALIASNAME_ETH0_SW,2)
#define ALIASNAME_ETH0_SW3 RTL_DEV_NAME_NUM(ALIASNAME_ETH0_SW,3)

#define ALIASNAME_BR00  RTL_DEV_NAME_NUM(ALIASNAME_BR0,:0)
#define ALIASNAME_BR01  RTL_DEV_NAME_NUM(ALIASNAME_BR0,:1)

typedef enum
{
	ITF_ALL=0,
	ITF_WAN,	//wan pppx or vcx
	ITF_LAN,	//br0

	ITF_ETH0,	//eth0
	ITF_ETH0_SW0,	//eth0_sw0
	ITF_ETH0_SW1,	//eth0_sw1
	ITF_ETH0_SW2,	//eth0_sw2
	ITF_ETH0_SW3,	//eth0_sw3
	
	ITF_WLAN0,	//wlan0
	ITF_WLAN0_VAP0,	//wlan0-vap0
	ITF_WLAN0_VAP1,	//wlan0-vap1
	ITF_WLAN0_VAP2,	//wlan0-vap2
	ITF_WLAN0_VAP3,	//wlan0-vap3
	
	ITF_WLAN1,	//wlan0
	ITF_WLAN1_VAP0,	//wlan0-vap0
	ITF_WLAN1_VAP1,	//wlan0-vap1
	ITF_WLAN1_VAP2,	//wlan0-vap2
	ITF_WLAN1_VAP3,	//wlan0-vap3
	
	ITF_USB0,	//usb0
	
	ITF_END		//last one
} ITF_T;
extern char *strItf[];
#endif //_PRMT_TR143_

#define DEF_MANUFACTURER_STR		"REALTEK SEMICONDUCTOR CORP."
#define DEF_MANUFACTUREROUI_STR		"00E04C" 

#define DEF_PRODUCTCLASS_STR		"IGD"

#define CWMP_ID						700 
#define MIB_CWMP_ENABLED						CWMP_ID + 0 
#define MIB_CWMP_PROVISIONINGCODE				CWMP_ID + 1	//069
#define MIB_CWMP_ACS_URL					CWMP_ID + 2			//069
#define MIB_CWMP_ACS_USERNAME				CWMP_ID + 3		//069
#define MIB_CWMP_ACS_PASSWORD				CWMP_ID + 4		//069
#define MIB_CWMP_INFORM_ENABLE				CWMP_ID + 5		//069
#define MIB_CWMP_INFORM_INTERVAL				CWMP_ID + 6		//069
#define MIB_CWMP_INFORM_TIME				CWMP_ID + 7
#define MIB_CWMP_CONREQ_USERNAME				CWMP_ID + 8
#define MIB_CWMP_CONREQ_PASSWORD				CWMP_ID + 9
#define MIB_CWMP_ACS_UPGRADESMANAGED			CWMP_ID + 10	//069
#define MIB_CWMP_LAN_CONFIGPASSWD				CWMP_ID + 11
#define MIB_CWMP_SERIALNUMBER					CWMP_ID + 12		//069
#define MIB_CWMP_DHCP_SERVERCONF				CWMP_ID + 13
#define MIB_CWMP_LAN_IPIFENABLE					CWMP_ID + 14
#define MIB_CWMP_LAN_ETHIFENABLE				CWMP_ID + 15
#define MIB_CWMP_WLAN_BASICENCRY				CWMP_ID + 16
#define MIB_CWMP_WLAN_WPAENCRY					CWMP_ID + 17
#define MIB_CWMP_DL_COMMANDKEY				CWMP_ID + 18
#define MIB_CWMP_DL_STARTTIME				CWMP_ID + 19
#define MIB_CWMP_DL_COMPLETETIME				CWMP_ID + 20
#define MIB_CWMP_DL_FAULTCODE				CWMP_ID + 21
#define MIB_CWMP_INFORM_EVENTCODE				CWMP_ID + 22
#define MIB_CWMP_RB_COMMANDKEY				CWMP_ID + 23
#define MIB_CWMP_ACS_PARAMETERKEY				CWMP_ID + 24
#define MIB_CWMP_CERT_PASSWORD				CWMP_ID + 25
#define MIB_CWMP_FLAG					CWMP_ID + 26
#define MIB_CWMP_SI_COMMANDKEY				CWMP_ID + 27	/*ScheduleInform's commandkey*/

#ifdef _PRMT_USERINTERFACE_						/*InternetGatewayDevice.UserInterface.*/
#define MIB_UIF_PW_REQUIRED					CWMP_ID + 28 	/*PasswordRequired*/
#define MIB_UIF_PW_USER_SEL					CWMP_ID + 29	/*PasswordUserSelectable*/
#define MIB_UIF_UPGRADE					CWMP_ID + 30	/*UpgradeAvailable*/
#define MIB_UIF_WARRANTYDATE				CWMP_ID + 31	/*WarrantyDate*/
#define MIB_UIF_AUTOUPDATESERVER				CWMP_ID + 32	/*AutoUpdateServer*/
#define MIB_UIF_USERUPDATESERVER				CWMP_ID + 33	/*UserUpdateServer*/
#endif /*_PRMT_USERINTERFACE_*/

#define MIB_CWMP_ACS_KICKURL				CWMP_ID + 74
#define MIB_CWMP_ACS_DOWNLOADURL				CWMP_ID + 75
#define MIB_CWMP_CONREQ_PORT				CWMP_ID + 76 /*port for connection request*/
#define MIB_CWMP_CONREQ_PATH				CWMP_ID + 77 /*path for connection request*/
#define MIB_CWMP_FLAG2					CWMP_ID + 78 

//#ifdef _PRMT_TR143_
#define MIB_TR143_UDPECHO_ENABLE				CWMP_ID + 79
#define MIB_TR143_UDPECHO_ITFTYPE				CWMP_ID + 80
#define MIB_TR143_UDPECHO_SRCIP				CWMP_ID + 81
#define MIB_TR143_UDPECHO_PORT				CWMP_ID + 82
#define MIB_TR143_UDPECHO_PLUS				CWMP_ID + 83
//#endif //_PRMT_TR143_

#define MIB_CWMP_NOTIFY_LIST					CWMP_ID + 84
#define MIB_CWMP_ACS_URL_OLD					CWMP_ID + 85			//069

#define MIB_CWMP_USERINFO_RESULT				CWMP_ID + 92
#define MIB_CWMP_NEED_REBOOT					CWMP_ID + 93
#define MIB_CWMP_PERSISTENT_DATA				CWMP_ID + 97

#define MIB_CWMP_PARAMETERKEY			CWMP_ID + 109

#define MIB_CWMP_PPPCON_INSTNUM			CWMP_ID + 110
#define MIB_CWMP_IPCON_INSTNUM			CWMP_ID + 111
#define MIB_CWMP_PPPCON_CREATED			CWMP_ID + 112
#define MIB_CWMP_IPCON_CREATED			CWMP_ID + 113
#define MIB_CWMP_LAN_ETHIFDISABLE		CWMP_ID + 114
#define MIB_CWMP_WAN_ETHIFDISABLE		CWMP_ID + 115

#define MIB_CWMP_SW_PORT1_DISABLE		CWMP_ID + 116
#define MIB_CWMP_SW_PORT1_MAXBITRATE	CWMP_ID + 117
#define MIB_CWMP_SW_PORT1_DUPLEXMODE	CWMP_ID + 118

#define MIB_CWMP_SW_PORT2_DISABLE		CWMP_ID + 119
#define MIB_CWMP_SW_PORT2_MAXBITRATE	CWMP_ID + 120
#define MIB_CWMP_SW_PORT2_DUPLEXMODE	CWMP_ID + 121

#define MIB_CWMP_SW_PORT3_DISABLE		CWMP_ID + 122
#define MIB_CWMP_SW_PORT3_MAXBITRATE	CWMP_ID + 123
#define MIB_CWMP_SW_PORT3_DUPLEXMODE	CWMP_ID + 124

#define MIB_CWMP_SW_PORT4_DISABLE		CWMP_ID + 125
#define MIB_CWMP_SW_PORT4_MAXBITRATE	CWMP_ID + 126
#define MIB_CWMP_SW_PORT4_DUPLEXMODE	CWMP_ID + 127

#define MIB_CWMP_SW_PORT5_DISABLE		CWMP_ID + 128
#define MIB_CWMP_SW_PORT5_MAXBITRATE	CWMP_ID + 129
#define MIB_CWMP_SW_PORT5_DUPLEXMODE	CWMP_ID + 130

#define MIB_CWMP_RETRY_MIN_WAIT_INTERVAL	CWMP_ID + 131
#define MIB_CWMP_RETRY_INTERVAL_MUTIPLIER	CWMP_ID + 132

#define MIB_CWMP_UDP_CONN_REQ_ADDR			CWMP_ID + 133
#define MIB_CWMP_STUN_EN					CWMP_ID + 134
#define MIB_CWMP_STUN_SERVER_ADDR			CWMP_ID + 135
#define MIB_CWMP_STUN_SERVER_PORT			CWMP_ID + 136
#define MIB_CWMP_STUN_USERNAME				CWMP_ID + 137
#define MIB_CWMP_STUN_PASSWORD				CWMP_ID + 138
#define MIB_CWMP_STUN_MAX_KEEP_ALIVE_PERIOD	CWMP_ID + 139
#define MIB_CWMP_STUN_MIN_KEEP_ALIVE_PERIOD	CWMP_ID + 140
#define MIB_CWMP_NAT_DETECTED				CWMP_ID + 141

#define MIB_CWMP_DEF_ACT_NOTIF_THROTTLE		CWMP_ID + 142	/*DefaultActiveNotificationThrottle*/
#define MIB_CWMP_MANAGE_DEV_NOTIF_LIMIT		CWMP_ID + 143	/*ManageableDeviceNotificationLimit*/

#ifdef _PRMT_USERINTERFACE_	
#define MIB_UIF_PW_SHARED					CWMP_ID + 144	/*SharedPassword*/
#define MIB_UIF_CUR_LANG					CWMP_ID + 145	/*CurrentLanguage*/
#endif /*_PRMT_USERINTERFACE_*/

#define MIB_DHCP_SERVER_OPTION_TBL_NUM      CWMP_ID+146
#define MIB_DHCP_SERVER_OPTION_TBL          ((MIB_DHCP_SERVER_OPTION_TBL_NUM+1)|MIB_TABLE_LIST)
#define MIB_DHCP_SERVER_OPTION_ADD          ((MIB_DHCP_SERVER_OPTION_TBL_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_DHCP_SERVER_OPTION_DEL          ((MIB_DHCP_SERVER_OPTION_TBL_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_DHCP_SERVER_OPTION_MOD          ((MIB_DHCP_SERVER_OPTION_TBL_NUM+3)|MIB_DEL_TBL_ENTRY | MIB_MOD_TBL_ENTRY)
#define MIB_DHCP_SERVER_OPTION_DELALL       ((MIB_DHCP_SERVER_OPTION_TBL_NUM+4)|MIB_DELALL_TBL_ENTRY)

#define MIB_DHCP_CLIENT_OPTION_TBL_NUM      CWMP_ID+147
#define MIB_DHCP_CLIENT_OPTION_TBL          ((MIB_DHCP_CLIENT_OPTION_TBL_NUM+1)|MIB_TABLE_LIST)
#define MIB_DHCP_CLIENT_OPTION_ADD          ((MIB_DHCP_CLIENT_OPTION_TBL_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_DHCP_CLIENT_OPTION_DEL          ((MIB_DHCP_CLIENT_OPTION_TBL_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_DHCP_CLIENT_OPTION_MOD          ((MIB_DHCP_CLIENT_OPTION_TBL_NUM+3)|MIB_DEL_TBL_ENTRY | MIB_MOD_TBL_ENTRY)
#define MIB_DHCP_CLIENT_OPTION_DELALL       ((MIB_DHCP_CLIENT_OPTION_TBL_NUM+4)|MIB_DELALL_TBL_ENTRY)

#define MIB_DHCPS_SERVING_POOL_TBL_NUM      CWMP_ID+148
#define MIB_DHCPS_SERVING_POOL_TBL          ((MIB_DHCPS_SERVING_POOL_TBL_NUM+1)|MIB_TABLE_LIST)
#define MIB_DHCPS_SERVING_POOL_ADD          ((MIB_DHCPS_SERVING_POOL_TBL_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_DHCPS_SERVING_POOL_DEL          ((MIB_DHCPS_SERVING_POOL_TBL_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_DHCPS_SERVING_POOL_MOD          ((MIB_DHCPS_SERVING_POOL_TBL_NUM+3)|MIB_DEL_TBL_ENTRY | MIB_MOD_TBL_ENTRY)
#define MIB_DHCPS_SERVING_POOL_DELALL       ((MIB_DHCPS_SERVING_POOL_TBL_NUM+4)|MIB_DELALL_TBL_ENTRY)

#define MIB_CWMP_PPPOE_WAN_VLANID		CWMP_ID + 149

#ifdef _SUPPORT_CAPTIVEPORTAL_PROFILE_
#define MIB_CAPTIVEPORTAL_ENABLE				CWMP_ID + 150
#define MIB_CAPTIVEPORTAL_URL					CWMP_ID + 151
#define MIB_CAP_PORTAL_ALLOW_TBL_NUM			CWMP_ID + 152
#define MIB_CAP_PORTAL_ALLOW_TBL				((MIB_CAP_PORTAL_ALLOW_TBL_NUM+1)|MIB_TABLE_LIST)
#define MIB_CAP_PORTAL_ALLOW_TBL_ADD			((MIB_CAP_PORTAL_ALLOW_TBL_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_CAP_PORTAL_ALLOW_TBL_DEL			((MIB_CAP_PORTAL_ALLOW_TBL_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_CAP_PORTAL_ALLOW_TBL_MOD          	((MIB_CAP_PORTAL_ALLOW_TBL_NUM+3)|MIB_DEL_TBL_ENTRY | MIB_MOD_TBL_ENTRY)
#define MIB_CAP_PORTAL_ALLOW_TBL_DELALL			((MIB_CAP_PORTAL_ALLOW_TBL_NUM+4)|MIB_DELALL_TBL_ENTRY)
#endif
#define MIB_CWMP_DNS_DISABLE			CWMP_ID + 160
#define MIB_CWMP_MIB_END				CWMP_ID + 200	/* Reserve 200 mib for tr069*/
#endif /*CONFIG_APP_TR069*/

#define MIB_TEST_DATA		10000

#define MIB_DHCPRSVDIP_IPADDR		1001
#define MIB_DHCPRSVDIP_MACADDR		1002
#define MIB_DHCPRSVDIP_HOSTNAME		1003
#define MIB_DHCPRSVDIP_INSTANCENUM	1004
#ifdef SUPPORT_DHCP_PORT_IP_BIND
#define MIB_DHCPRSVDIP_PORTID		1005
#endif
#ifdef _PRMT_X_TELEFONICA_ES_DHCPOPTION_
#define MIB_DHCPRSVDIP_ENTRY_ENABLED        1006
#endif

#define MIB_SCHEDULE_TEXT		1011
#define MIB_SCHEDULE_ECO		1012
#define MIB_SCHEDULE_FTIME		1013
#define MIB_SCHEDULE_TTIME		1014
#define MIB_SCHEDULE_DAY		1015

#define MIB_PORTFW_IPADDR		1021
#define MIB_PORTFW_FROMPORT		1022
#define MIB_PORTFW_TOPORT		1023
#define MIB_PORTFW_PROTOTYPE		1024
#define MIB_PORTFW_COMMENT		1025
#define MIB_PORTFW_SVRPORT		1026
#define MIB_PORTFW_SVRNAME		1027
#define MIB_PORTFW_INSTANCENUM		1028
#define MIB_PORTFW_WANIFACE_ID		1029
#if defined(CONFIG_RTL_PORTFW_EXTEND)
#define MIB_PORTFW_ENABLED				1017
#define MIB_PORTFW_EXTERNEL_FROMPORT 	1018
#define MIB_PORTFW_EXTERNEL_TOPORT		1019
#define MIB_PORTFW_REMOTE_IPADDR		1020
#endif

#define MIB_IPFILTER_IPADDR		1031
#define MIB_IPFILTER_PROTOTYPE		1032
#define MIB_IPFILTER_COMMENT		1033
#define MIB_IPFILTER_IP6ADDR		1034
#define MIB_IPFILTER_IP_VERSION		1035

#define MIB_PORTFILTER_FROMPORT		1041
#define MIB_PORTFILTER_TOPORT		1042
#define MIB_PORTFILTER_PROTOTYPE		1043
#define MIB_PORTFILTER_COMMENT		1044
#define MIB_PORTFILTER_IPVERSION	1045

#define MIB_MACFILTER_MACADDR		1051
#define MIB_MACFILTER_COMMENT		1052

#ifdef _SUPPORT_CAPTIVEPORTAL_PROFILE_
#define MIB_CAP_PORTAL_IP		1978
#endif

#define MIB_TRIGGERPORT_TRI_FROMPORT		1061
#define MIB_TRIGGERPORT_TRI_TOPORT	1062
#define MIB_TRIGGERPORT_TRI_PROTOTYPE		1063
#define MIB_TRIGGERPORT_INC_FROMPORT	1064
#define MIB_TRIGGERPORT_INC_TOPORT	1065
#define MIB_TRIGGERPORT_INC_PROTOTYPE		1066
#define MIB_TRIGGERPORT_COMMENT	1067

#define MIB_URLFILTER_URLADDR	1071
#define MIB_URLFILTER_RULE_MODE	1072
#ifdef URL_FILTER_USER_MODE_SUPPORT
#define MIB_URLFILTER_IPADDR	1073
#define MIB_URLFILTER_MACADDR   1074
#define MIB_URLFILTER_USR_MODE  1075
#endif

#define MIB_VLANCONFIG_ENTRY_ENABLED	1081
#define MIB_VLANCONFIG_NETIFACE	1082
#define MIB_VLANCONFIG_TAGGED	1083
#define MIB_VLANCONFIG_UNTAGGED	1084
#define MIB_VLANCONFIG_PRIORITY	1085
#define MIB_VLANCONFIG_CFI	1086
#define MIB_VLANCONFIG_GROUPID	1087
#define MIB_VLANCONFIG_VLANID	1088
#if defined(CONFIG_RTK_BRIDGE_VLAN_SUPPORT) || defined(CONFIG_RTL_HW_VLAN_SUPPORT)
#define MIB_VLANCONFIG_FORWARDING_RULE 1089
#endif

#define MIB_STATICROUTE_DSTADDR	1091
#define MIB_STATICROUTE_NETMASK	1092
#define MIB_STATICROUTE_GATEWAY	1093
#define MIB_STATICROUTE_INTERFACE	1094
#define MIB_STATICROUTE_METRIC	1095

#define MIB_IPSECTUNNEL_TUNNELID	1101
#define MIB_IPSECTUNNEL_AUTHTYPE	1102
#define MIB_IPSECTUNNEL_LCTYPE	1103
#define MIB_IPSECTUNNEL_LC_IPADDR	1104
#define MIB_IPSECTUNNEL_LC_MASKLEN	1105
#define MIB_IPSECTUNNEL_RTTYPE	1106
#define MIB_IPSECTUNNEL_RT_IPADDR	1107
#define MIB_IPSECTUNNEL_RT_MASKLEN	1108
#define MIB_IPSECTUNNEL_RT_GWADDR	1109
#define MIB_IPSECTUNNEL_KEYMODE	1110
#define MIB_IPSECTUNNEL_ESPAH	1111
#define MIB_IPSECTUNNEL_ESPENCR	1112
#define MIB_IPSECTUNNEL_ESPAUTH	1113
#define MIB_IPSECTUNNEL_AHAUTH	1114
#define MIB_IPSECTUNNEL_CONTYPE	1115
#define MIB_IPSECTUNNEL_PSKEY	1116
#define MIB_IPSECTUNNEL_RSAKEY	1117
#define MIB_IPSECTUNNEL_SPI	1118
#define MIB_IPSECTUNNEL_ENCRKEY	1119
#define MIB_IPSECTUNNEL_AUTHKEY	1120
#define MIB_IPSECTUNNEL_ENABLE	1121
#define MIB_IPSECTUNNEL_CONNNAME	1122
#define MIB_IPSECTUNNEL_LCIDTYPE	1123
#define MIB_IPSECTUNNEL_RTIDTYPE	1124
#define MIB_IPSECTUNNEL_LCID	1125
#define MIB_IPSECTUNNEL_RTID	1126
#define MIB_IPSECTUNNEL_IKELIFETIME	1127
#define MIB_IPSECTUNNEL_IKEENCR	1128
#define MIB_IPSECTUNNEL_IKEAUTH	1129
#define MIB_IPSECTUNNEL_IKEKEYGROUP	1130
#define MIB_IPSECTUNNEL_IPSECLIFETIME	1131
#define MIB_IPSECTUNNEL_IPSECPFS	1132

#define MIB_CERTROOT_COMMENT	1151

#define MIB_CERTUSER_COMMENT	1161
#define MIB_CERTROOT_PASS	1162

#define MIB_QOS_ENTRY_NAME 1171
#define MIB_QOS_ENTRY_ENABLED 1172
#define MIB_QOS_PRIORITY 1173
#define MIB_QOS_PROTOCOL 1174
#define MIB_QOS_LOCAL_IP_START 1175
#define MIB_QOS_LOCAL_IP_END 1176
#define MIB_QOS_LOCAL_PORT_START 1177
#define MIB_QOS_LOCAL_PORT_END 1178
#define MIB_QOS_REMOTE_IP_START 1179
#define MIB_QOS_REMOTE_IP_END 1180
#define MIB_QOS_REMOTE_PORT_START 1181
#define MIB_QOS_REMOTE_PORT_END 1182

#define MIB_IPQOS_ENTRY_NAME 1191
#define MIB_IPQOS_ENABLED 1192
#define MIB_IPQOS_MAC 1193
#define MIB_IPQOS_MODE 1194
#define MIB_IPQOS_LOCAL_IP_START 1195
#define MIB_IPQOS_LOCAL_IP_END 1196
#define MIB_IPQOS_BANDWIDTH 1197
#define MIB_IPQOS_BANDWIDTH_DOWNLINK 1198
#define MIB_IPQOS_LAYER7_PROTOCOL 1199
#define MIB_IPQOS_IPV6_SRC 1200
#ifdef QOS_CLASSIFY_BY_DSCP
#define MIB_IPQOS_DSCP 1230
#endif

#ifndef CONFIG_WNC_REMOVE_MESH
#define MIB_MECH_ACL_MACADDR 1201
#define MIB_MECH_ACL_COMMENT 1202
#endif

#define MIB_WLAN_ACL_ADDR_MACADDR 1211
//WNC-NMRXXXX-D2R030-YUAN-I-CHOU-20160311, mark this to save some SW MIB space
//#define MIB_WLAN_ACL_ADDR_COMMENT 1212

#define MIB_WLAN_WDS_MACADDR 1221
#define MIB_WLAN_WDS_FIXEDTXRATE 1222
#define MIB_WLAN_WDS_COMMENT 1223

#ifdef FAST_BSS_TRANSITION
#define MIB_WLAN_FTKH_MACADDR 1224
#define MIB_WLAN_FTKH_NAS_ID 1225
#define MIB_WLAN_FTKH_KEY 1226
#define MIB_WLAN_FTKH_OPCLASS 1227 /*for 11k neighbor report*/
#define MIB_WLAN_FTKH_CHANNEL 1228 /*for 11k neighbor report*/
#define MIB_WLAN_FT_ENABLE 1229
#define MIB_WLAN_FT_MDID 1230
#define MIB_WLAN_FT_OVER_DS 1231
#define MIB_WLAN_FT_RES_REQUEST 1232
#define MIB_WLAN_FT_R0KEY_TO 1233
#define MIB_WLAN_FT_REASOC_TO 1234
#define MIB_WLAN_FT_R0KH_ID 1235
#define MIB_WLAN_FT_PUSH 1236
#define MIB_WLAN_FTKH_NUM 1237
#define MIB_WLAN_FTKH			((MIB_WLAN_FTKH_NUM+1)|MIB_TABLE_LIST)
#define MIB_WLAN_FTKH_ADD		((MIB_WLAN_FTKH_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_WLAN_FTKH_DEL		((MIB_WLAN_FTKH_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_WLAN_FTKH_DELALL		((MIB_WLAN_FTKH_NUM+4)|MIB_DELALL_TBL_ENTRY)

#endif

//=========add for DOT11K =========
#define MIB_WLAN_DOT11K_ENABLE    1250

//=========add for CONFIG_IEEE80211V =========
#define MIB_WLAN_DOT11V_ENABLE    1251


//#ifdef CONFIG_RTL_FLASH_DUAL_IMAGE_ENABLE
#define MIB_DUALBANK_ENABLED			1300
#define MIB_WLAN_PHY_BAND_SELECT			1301
#define MIB_WLAN_MAC_PHY_MODE			1302
#define MIB_WLAN_BAND2G5G_SELECT			1303
//#endif

//MIBs for 802.1x wlan client mode
#ifdef CONFIG_RTL_802_1X_CLIENT_SUPPORT
#define MIB_WLAN_EAP_TYPE 				1311
#define MIB_WLAN_EAP_INSIDE_TYPE 		1312
#define MIB_WLAN_EAP_USER_ID				1313
#define MIB_WLAN_RS_USER_NAME			1314
#define MIB_WLAN_RS_USER_PASSWD			1315
#define MIB_WLAN_RS_USER_CERT_PASSWD	1316
#define MIB_WLAN_RS_BAND_SEL 				1317
#endif

/* USB3G */
#define MIB_USB3G_USER              1400
#define MIB_USB3G_PASS              1401
#define MIB_USB3G_PIN               1402
#define MIB_USB3G_APN               1403
#define MIB_USB3G_DIALNUM           1404
#define MIB_USB3G_CONN_TYPE         1405
#define MIB_USB3G_IDLE_TIME         1406
#define MIB_USB3G_MTU_SIZE          1407
#define MIB_LTE4G			        1408

/*for P2P_SUPPORT*/
#define MIB_WLAN_P2P_TYPE          			1450
#define MIB_WLAN_P2P_INTENT         		1451
#define MIB_WLAN_P2P_LISTEN_CHANNEL         1452
#define MIB_WLAN_P2P_OPERATION_CHANNEL      1453
#define MIB_WLAN_RS2_IP			1454
#define MIB_WLAN_RS2_PORT		1455
#define MIB_WLAN_RS2_PASSWORD		1456
#define MIB_WLAN_RS2_MAXRETRY		1457
#define MIB_WLAN_RS2_INTERVAL_TIME	1458
#define MIB_WLAN_ACCOUNT_RS2_IP		1459
#define MIB_WLAN_ACCOUNT_RS2_PORT	1460
#define MIB_WLAN_ACCOUNT_RS2_PASSWORD	1461
#define MIB_WLAN_RS_REAUTH_TO	1462
#define MIB_WLAN_FUNC_OFF	1463


#if defined(CONFIG_RTL_ULINKER)
#define MIB_ULINKER_AUTO     1470
#define MIB_ULINKER_CURRENT_MODE	1471
#define MIB_ULINKER_LATEST_MODE	1472
#define MIB_ULINKER_CURRENT_WLAN_MODE	1473
#define MIB_ULINKER_LATEST_WLAN_MODE	1474

#define MIB_ULINKER_REPEATER_ENABLED1	1475
#define MIB_ULINKER_REPEATER_ENABLED2	1476

#endif

#if defined(CONFIG_APP_SIMPLE_CONFIG)
#define MIB_WLAN_SC_ENABLED				1480
#define MIB_WLAN_SC_SAVE_PROFILE			1481
//#define MIB_HW_SC_PIN						1482
//#define MIB_HW_SC_DEFAULT_PIN				1483
#define MIB_WLAN_SC_SYNC_PROFILE			1484
#define MIB_WLAN_SC_PASSWD				1485
#define MIB_SC_DEVICE_NAME					1486
#define MIB_SC_DEVICE_TYPE					1487
#define MIB_WLAN_SC_PIN_ENABLED				1488
#endif

/*multi pppoe*/
//dzh begin
//#define MIB_PPP_USER_NAME			106
#define MIB_PPP_CONNECT_COUNT		1499

#define MIB_PPP_USER_NAME2			1500
#define MIB_PPP_PASSWORD2			1501
#define MIB_PPP_USER_NAME3			1502
#define MIB_PPP_PASSWORD3			1503
#define MIB_PPP_USER_NAME4			1504
#define MIB_PPP_PASSWORD4			1505


#define MIB_PPP_SERVICE_NAME2		1506
#define MIB_PPP_SERVICE_NAME3		1507
#define MIB_PPP_SERVICE_NAME4		1508

#define MIB_PPP_IDLE_TIME2			1509
#define MIB_PPP_CONNECT_TYPE2		1510
#define MIB_PPP_IDLE_TIME3			1511
#define MIB_PPP_CONNECT_TYPE3		1512
#define MIB_PPP_IDLE_TIME4			1513
#define MIB_PPP_CONNECT_TYPE4		1514

#define MIB_PPP_MTU_SIZE2			1515
#define MIB_PPP_MTU_SIZE3			1516
#define MIB_PPP_MTU_SIZE4			1517


#define MIB_PPP_SESSION_NUM2		1522
#define MIB_PPP_SERVER_MAC2			1523
#define MIB_PPP_SESSION_NUM3		1524
#define MIB_PPP_SERVER_MAC3			1525
#define MIB_PPP_SESSION_NUM4		1526
#define MIB_PPP_SERVER_MAC4			1527

//add for subnet
#define MIB_SUBNET1_COUNT			1528
#define MIB_SUBNET1_F1_START		1529
#define MIB_SUBNET1_F1_END			1530
#define MIB_SUBNET1_F2_START		1531
#define MIB_SUBNET1_F2_END			1532
#define MIB_SUBNET1_F3_START		1533
#define MIB_SUBNET1_F3_END			1534
#define MIB_SUBNET2_COUNT			1535
#define MIB_SUBNET2_F1_START		1536
#define MIB_SUBNET2_F1_END			1537
#define MIB_SUBNET2_F2_START		1538
#define MIB_SUBNET2_F2_END			1539
#define MIB_SUBNET2_F3_START		1540
#define MIB_SUBNET2_F3_END			1541
#define MIB_SUBNET3_COUNT			1542
#define MIB_SUBNET3_F1_START		1543
#define MIB_SUBNET3_F1_END			1544
#define MIB_SUBNET3_F2_START		1545
#define MIB_SUBNET3_F2_END			1546
#define MIB_SUBNET3_F3_START		1547
#define MIB_SUBNET3_F3_END			1548
#define MIB_SUBNET4_COUNT			1549
#define MIB_SUBNET4_F1_START		1550
#define MIB_SUBNET4_F1_END			1551
#define MIB_SUBNET4_F2_START		1552
#define MIB_SUBNET4_F2_END			1553
#define MIB_SUBNET4_F3_START		1554
#define MIB_SUBNET4_F3_END			1555


#define MIB_PPP_SUBNET1				1556
#define MIB_PPP_SUBNET2				1557
#define MIB_PPP_SUBNET3				1558
#define MIB_PPP_SUBNET4				1559

#ifdef CONFIG_CPU_UTILIZATION
#define MIB_ENABLE_CPU_UTILIZATION		1580
#define MIB_CPU_UTILIZATION_INTERVAL	1581
#endif


#define DHCP_SERVER_OPTION_ID	1590
#define MIB_DHCP_SERVER_OPTION_ENABLED			(DHCP_SERVER_OPTION_ID+0)
#define MIB_DHCP_SERVER_OPTION_USEDFOR			(DHCP_SERVER_OPTION_ID+1)
#define MIB_DHCP_SERVER_OPTION_ORDER			(DHCP_SERVER_OPTION_ID+2)
#define MIB_DHCP_SERVER_OPTION_TAG				(DHCP_SERVER_OPTION_ID+3)
#define MIB_DHCP_SERVER_OPTION_LEN				(DHCP_SERVER_OPTION_ID+4)
#define MIB_DHCP_SERVER_OPTION_VALUE			(DHCP_SERVER_OPTION_ID+5)
#define MIB_DHCP_SERVER_OPTION_IFINDEX			(DHCP_SERVER_OPTION_ID+6)
#define MIB_DHCP_SERVER_OPTION_DHCPOPTINSTNUM	(DHCP_SERVER_OPTION_ID+7)
#define MIB_DHCP_SERVER_OPTION_DHCPCONSPINSTNUM	(DHCP_SERVER_OPTION_ID+8)

#define DHCP_CLIENT_OPTION_ID	1600
#define MIB_DHCP_CLIENT_OPTION_ENABLED			(DHCP_CLIENT_OPTION_ID+0)
#define MIB_DHCP_CLIENT_OPTION_USEDFOR			(DHCP_CLIENT_OPTION_ID+1)
#define MIB_DHCP_CLIENT_OPTION_ORDER			(DHCP_CLIENT_OPTION_ID+2)
#define MIB_DHCP_CLIENT_OPTION_TAG				(DHCP_CLIENT_OPTION_ID+3)
#define MIB_DHCP_CLIENT_OPTION_LEN				(DHCP_SERVER_OPTION_ID+4)
#define MIB_DHCP_CLIENT_OPTION_VALUE			(DHCP_CLIENT_OPTION_ID+5)
#define MIB_DHCP_CLIENT_OPTION_IFINDEX			(DHCP_CLIENT_OPTION_ID+6)
#define MIB_DHCP_CLIENT_OPTION_DHCPOPTINSTNUM	(DHCP_CLIENT_OPTION_ID+7)
#define MIB_DHCP_CLIENT_OPTION_DHCPCONSPINSTNUM	(DHCP_CLIENT_OPTION_ID+8)

#define DHCPS_SERVING_POOL_ID   1610
#define MIB_DHCPS_SERVING_POOL_ENABLE           (DHCPS_SERVING_POOL_ID+0)
#define MIB_DHCPS_SERVING_POOL_POOLORDER        (DHCPS_SERVING_POOL_ID+1)
#define MIB_DHCPS_SERVING_POOL_POOLNAME         (DHCPS_SERVING_POOL_ID+2)
#define MIB_DHCPS_SERVING_POOL_DEVICETYPE       (DHCPS_SERVING_POOL_ID+3)
#define MIB_DHCPS_SERVING_POOL_RSVOPTCODE       (DHCPS_SERVING_POOL_ID+4)
#define MIB_DHCPS_SERVING_POOL_SOURCEINTERFACE  (DHCPS_SERVING_POOL_ID+5)
#define MIB_DHCPS_SERVING_POOL_VENDORCLASS      (DHCPS_SERVING_POOL_ID+6)
#define MIB_DHCPS_SERVING_POOL_VENDORCLASSFLAG  (DHCPS_SERVING_POOL_ID+7)
#define MIB_DHCPS_SERVING_POOL_VENDORCLASSMODE  (DHCPS_SERVING_POOL_ID+8)
#define MIB_DHCPS_SERVING_POOL_CLIENTID         (DHCPS_SERVING_POOL_ID+9)
#define MIB_DHCPS_SERVING_POOL_CLIENTIDFLAG     (DHCPS_SERVING_POOL_ID+10)
#define MIB_DHCPS_SERVING_POOL_USERCLASS        (DHCPS_SERVING_POOL_ID+11)
#define MIB_DHCPS_SERVING_POOL_USERCLASSFLAG    (DHCPS_SERVING_POOL_ID+12)
#define MIB_DHCPS_SERVING_POOL_CHADDR           (DHCPS_SERVING_POOL_ID+13)
#define MIB_DHCPS_SERVING_POOL_CHADDRMASK       (DHCPS_SERVING_POOL_ID+14)  
#define MIB_DHCPS_SERVING_POOL_CHADDRFLAG       (DHCPS_SERVING_POOL_ID+15)
#define MIB_DHCPS_SERVING_POOL_LOCALSERVED      (DHCPS_SERVING_POOL_ID+16)
#define MIB_DHCPS_SERVING_POOL_STARTADDR        (DHCPS_SERVING_POOL_ID+17)
#define MIB_DHCPS_SERVING_POOL_ENDADDR          (DHCPS_SERVING_POOL_ID+18)
#define MIB_DHCPS_SERVING_POOL_SUBNETMASK       (DHCPS_SERVING_POOL_ID+19)
#define MIB_DHCPS_SERVING_POOL_IPROUTER         (DHCPS_SERVING_POOL_ID+20)
#define MIB_DHCPS_SERVING_POOL_DNSSERVER1       (DHCPS_SERVING_POOL_ID+21)
#define MIB_DHCPS_SERVING_POOL_DNSSERVER2       (DHCPS_SERVING_POOL_ID+22)
#define MIB_DHCPS_SERVING_POOL_DNSSERVER3       (DHCPS_SERVING_POOL_ID+23)
#define MIB_DHCPS_SERVING_POOL_DOMAINNAME       (DHCPS_SERVING_POOL_ID+24)
#define MIB_DHCPS_SERVING_POOL_LEASETIME        (DHCPS_SERVING_POOL_ID+25)
#define MIB_DHCPS_SERVING_POOL_DHCPRELAYIP      (DHCPS_SERVING_POOL_ID+26)
#define MIB_DHCPS_SERVING_POOL_DNSSERVERMODE    (DHCPS_SERVING_POOL_ID+27)
//#ifdef _CWMP_MIB_
#define MIB_DHCPS_SERVING_POOL_INSTANCENUM      (DHCPS_SERVING_POOL_ID+28)
//#endif


#define MIB_LAN_DHCP_CONFIGURABLE					1749

#define MIB_STATICROUTE_ENABLE			1776
#define MIB_STATICROUTE_TYPE				1777
#define MIB_STATICROUTE_SRCADDR			1778
#define MIB_STATICROUTE_SRCNETMASK		1779
#define MIB_STATICROUTE_IFACEINDEX		1780
#define MIB_STATICROUTE_INSTANCENUM	1781
#define MIB_STATICROUTE_FLAGS			1782

#define MIB_WLAN_CWMP_WLANCONFIG_INSTNUM 	1783


//////////////////////////////////////////////////////////////////////////
#define MIB_CWMP_WLANCONF_ENABLED		1784
#define MIB_CWMP_WLANCONF_TBL_NUM		1785
#define MIB_CWMP_WLANCONF_TBL			((MIB_CWMP_WLANCONF_TBL_NUM+1)|MIB_TABLE_LIST)
#define MIB_CWMP_WLANCONF_ADD		((MIB_CWMP_WLANCONF_TBL_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_CWMP_WLANCONF_DEL		((MIB_CWMP_WLANCONF_TBL_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_CWMP_WLANCONF_MOD			((MIB_CWMP_WLANCONF_TBL_NUM+3)|MIB_DEL_TBL_ENTRY | MIB_MOD_TBL_ENTRY) //brucehou
#define MIB_CWMP_WLANCONF_DELALL		((MIB_CWMP_WLANCONF_TBL_NUM+4)|MIB_DELALL_TBL_ENTRY)

#define MAX_CWMP_WLANCONF_NUM			12

#define MIB_CWMP_WLANCONF_INSTANCENUM		1790
#define MIB_CWMP_WLANCONF_ROOT_IDX			1791
#define MIB_CWMP_WLANCONF_VWLAN_IDX		1792
#define MIB_CWMP_WLANCONF_ISCONFIGURED		1793
#define MIB_CWMP_WLANCONF_RFBAND			1794

#define VLAN_WAN								2000
#define MIB_VLAN_WAN_ENALE                      VLAN_WAN  + 1
#define MIB_VLAN_WAN_TAG                        VLAN_WAN  + 2

#define MIB_VLAN_WAN_BRIDGE_ENABLE              VLAN_WAN  + 3
#define MIB_VLAN_WAN_BRIDGE_TAG                 VLAN_WAN  + 4
#define MIB_VLAN_WAN_BRIDGE_PORT                VLAN_WAN  + 5
#define MIB_VLAN_WAN_BRIDGE_MULTICAST_ENABLE    VLAN_WAN  + 6
#define MIB_VLAN_WAN_BRIDGE_MULTICAST_TAG       VLAN_WAN  + 7

#define MIB_VLAN_WAN_HOST_ENABLE				VLAN_WAN  + 8
#define MIB_VLAN_WAN_HOST_TAG					VLAN_WAN  + 9
#define MIB_VLAN_WAN_HOST_PRI					VLAN_WAN  + 10
#define MIB_VLAN_WAN_WIFI_ROOT_ENABLE			VLAN_WAN  + 11
#define MIB_VLAN_WAN_WIFI_ROOT_TAG				VLAN_WAN  + 12
#define MIB_VLAN_WAN_WIFI_ROOT_PRI				VLAN_WAN  + 13
#define MIB_VLAN_WAN_WIFI_VAP0_ENABLE			VLAN_WAN  + 14
#define MIB_VLAN_WAN_WIFI_VAP0_TAG				VLAN_WAN  + 15
#define MIB_VLAN_WAN_WIFI_VAP0_PRI				VLAN_WAN  + 16
#define MIB_VLAN_WAN_WIFI_VAP1_ENABLE			VLAN_WAN  + 17
#define MIB_VLAN_WAN_WIFI_VAP1_TAG				VLAN_WAN  + 18
#define MIB_VLAN_WAN_WIFI_VAP1_PRI				VLAN_WAN  + 19
#define MIB_VLAN_WAN_WIFI_VAP2_ENABLE			VLAN_WAN  + 20
#define MIB_VLAN_WAN_WIFI_VAP2_TAG				VLAN_WAN  + 21
#define MIB_VLAN_WAN_WIFI_VAP2_PRI				VLAN_WAN  + 22
#define MIB_VLAN_WAN_WIFI_VAP3_ENABLE			VLAN_WAN  + 23
#define MIB_VLAN_WAN_WIFI_VAP3_TAG				VLAN_WAN  + 24
#define MIB_VLAN_WAN_WIFI_VAP3_PRI				VLAN_WAN  + 25

// Reserve 100 mib for vlan wan tag
#define MIB_VLAN_WAN_TAG_ID_END					VLAN_WAN  + 99 // 2099


#ifdef WLAN_PROFILE
#define WLAN_PROFILE_ID							2100
#define MIB_PROFILE_ENABLED1					(WLAN_PROFILE_ID+0)
#define MIB_PROFILE_NUM1						(WLAN_PROFILE_ID+1)
#define MIB_PROFILE_TBL1						((WLAN_PROFILE_ID+2)|MIB_TABLE_LIST)
#define MIB_PROFILE_ADD1						((WLAN_PROFILE_ID+3)|MIB_ADD_TBL_ENTRY)
#define MIB_PROFILE_DEL1						((WLAN_PROFILE_ID+4)|MIB_DEL_TBL_ENTRY)
#define MIB_PROFILE_MOD1			                      ((WLAN_PROFILE_ID+4) | MIB_DEL_TBL_ENTRY | MIB_MOD_TBL_ENTRY)
#define MIB_PROFILE_DELALL1						((WLAN_PROFILE_ID+5)|MIB_DELALL_TBL_ENTRY)
#define MIB_PROFILE_SSID						(WLAN_PROFILE_ID+6)
#define MIB_PROFILE_ENC							(WLAN_PROFILE_ID+7)
#define MIB_PROFILE_AUTH						(WLAN_PROFILE_ID+8)
#define MIB_PROFILE_WPA_CIPHER					(WLAN_PROFILE_ID+9)
#define MIB_PROFILE_WPA_PSK						(WLAN_PROFILE_ID+10)
#define MIB_PROFILE_WEP_DEFAULT_KEY				(WLAN_PROFILE_ID+11)
#define MIB_PROFILE_WEP_KEY1					(WLAN_PROFILE_ID+12)
#define MIB_PROFILE_WEP_KEY2					(WLAN_PROFILE_ID+13)
#define MIB_PROFILE_WEP_KEY3					(WLAN_PROFILE_ID+14)
#define MIB_PROFILE_WEP_KEY4					(WLAN_PROFILE_ID+15)
#define MIB_PROFILE_ENABLED2					(WLAN_PROFILE_ID+16)
#define MIB_PROFILE_WEP_KEY_TYPE					(WLAN_PROFILE_ID+17)
#define MIB_PROFILE_PSK_FORMAT					(WLAN_PROFILE_ID+18)
#define MIB_PROFILE_NUM2						(WLAN_PROFILE_ID+19)
#define MIB_PROFILE_TBL2						((WLAN_PROFILE_ID+20)|MIB_TABLE_LIST)
#define MIB_PROFILE_ADD2						((WLAN_PROFILE_ID+21)|MIB_ADD_TBL_ENTRY)
#define MIB_PROFILE_DEL2						((WLAN_PROFILE_ID+22)|MIB_DEL_TBL_ENTRY)
#define MIB_PROFILE_MOD2			                      ((WLAN_PROFILE_ID+22) | MIB_DEL_TBL_ENTRY | MIB_MOD_TBL_ENTRY)
#define MIB_PROFILE_DELALL2						((WLAN_PROFILE_ID+23)|MIB_DELALL_TBL_ENTRY)
/* WNC-NMR0000-HENG-I-CHEN-20130606-Add items that NEC spec. need */
#define MIB_PROFILE_ACTIVE						(WLAN_PROFILE_ID+24)
#define MIB_PROFILE_NAME						(WLAN_PROFILE_ID+25)
#define MIB_PROFILE_WISP_TYPE					(WLAN_PROFILE_ID+26)
#define MIB_PROFILE_WISP_LOGIN					(WLAN_PROFILE_ID+27)
#define MIB_PROFILE_WISP_PASS					(WLAN_PROFILE_ID+28)
#define MIB_PROFILE_WISP_AUTOLOGIN				(WLAN_PROFILE_ID+29)
/* WNC-NMR0000-HENG-I-CHEN-20130606-End */
#if 1	/* WNC-MR000-Libera-20130702- new spec: Create a MIB for Profile switch interval */
#define MIB_PROFILE_LOOP_INTERVAL				(WLAN_PROFILE_ID+30)
#endif
#endif // WLAN_PROFILE

#define IP6_ADDR_LEN					16
#define MAX_PPP_NAME_LEN				63
//dzh end
#ifdef CONFIG_APP_TR069
/* define the len of the entities */
#define CWMP_LANCONF_PASSWD_LEN	64
#define CWMP_SERIALNUMBER_LEN	64
#define CWMP_COMMAND_KEY_LEN	32

/* define the len of the entities */
#define CWMP_PROVISION_CODE_LEN	32 //64 in spec
#define CWMP_ACS_URL_LEN	64 //256 in spec
#ifdef _SUPPORT_CAPTIVEPORTAL_PROFILE_
#define CWMP_CAP_PORTAL_URL_LEN	2000 //2000 in spec
#endif
#define CWMP_ACS_USERNAME_LEN	32 //256 in spec
#define CWMP_ACS_PASSWD_LEN	32 //256 in spec
#define CWMP_CONREQ_USERNAME_LEN	32 //256 in spec
#define CWMP_CONREQ_PASSWD_LEN	32 //256 in spec
#define CONN_REQ_PATH_LEN	32 //32 in spec
#define CWMP_KICK_URL 32 //64 in spec
#define CWMP_DOWNLOAD_URL 32 //64 in spec
#define CWMP_CERT_PASSWD_LEN	32 //64 in spec
#define CWMP_NOTIFY_LIST_LEN (2) //No limitation in spec
#define CWMP_UDP_CONN_REQ_ADDR_LEN	256
#define CWMP_STUN_SERVER_ADDR_LEN	256
#define CWMP_STUN_USERNAME_LEN	256
#define CWMP_STUN_PASSWORD_LEN	256
#define IP_ADDR_LEN 4
/* define the cwmp_flag */
#define CWMP_FLAG_DEBUG_MSG	0x01
#define CWMP_FLAG_CERT_AUTH      0x02
#define CWMP_FLAG_SENDGETRPC    0x04
#define CWMP_FLAG_SKIPMREBOOT   0x08
#define CWMP_FLAG_DELAY         	0x10
#define CWMP_FLAG_AUTORUN          0x20
#define CWMP_FLAG_CTINFORMEXT	0x40
#define CWMP_FLAG_SELFREBOOT    0x80
/*flag for CWMP_FLAG2 setting*/
#define CWMP_FLAG2_DIS_CONREQ_AUTH		0x01  /*disable connection request authentication*/
#define CWMP_FLAG2_DEFAULT_WANIP_IN_INFORM	0x02  /*bring the default wan ip in the inform*/
#define CWMP_FLAG2_NULL_TO_SKIP_AUTH 0x04
/*action type for applying new values*/
#define CWMP_NONE		0
#define CWMP_START		1
#define CWMP_STOP		2
#define CWMP_RESTART		3

/*EC_xxxxx event must consist with those defined in cwmp_rpc.h*/
#define EC_X_CT_COM_ACCOUNT	0x10000	/*X_CT-COM_ACCOUNTCHANGE*/

#endif /*CONFIG_APP_TR069*/

#if defined(CONFIG_RTL_8198C)||defined(CONFIG_RTL_8196C) || defined(CONFIG_RTL_8198) || defined(CONFIG_RTL_819XD) || defined(CONFIG_RTL_8196E) || defined(CONFIG_RTL_8198B)  || defined(CONFIG_RTL_8881A) || defined(CONFIG_RTL_8197F)
/*new add since new platform rtl8196c*/
#define MIB_HW_TX_POWER_CCK_A 901
#define MIB_HW_TX_POWER_CCK_B 902
#define MIB_HW_TX_POWER_HT40_1S_A 903
#define MIB_HW_TX_POWER_HT40_1S_B 904
#define MIB_HW_TX_POWER_DIFF_HT40_2S 905
#define MIB_HW_TX_POWER_DIFF_HT20 906
#define MIB_HW_TX_POWER_DIFF_OFDM 907
#define MIB_HW_11N_RESERVED9 908
#define MIB_HW_11N_RESERVED10 909
#define MIB_HW_TX_POWER_5G_HT40_1S_A 910
#define MIB_HW_TX_POWER_5G_HT40_1S_B 911
#define MIB_HW_TX_POWER_DIFF_5G_HT40_2S 912
#define MIB_HW_TX_POWER_DIFF_5G_HT20 913
#define MIB_HW_TX_POWER_DIFF_5G_OFDM 914
/*new add end*/
#endif

#if defined(CONFIG_WLAN_HAL_8814AE)
#define MIB_HW_TX_POWER_CCK_C 2336
#define MIB_HW_TX_POWER_CCK_D 2337
#define MIB_HW_TX_POWER_HT40_1S_C 2338
#define MIB_HW_TX_POWER_HT40_1S_D 2339
#define MIB_HW_TX_POWER_5G_HT40_1S_C 2340
#define MIB_HW_TX_POWER_5G_HT40_1S_D 2341
#endif

#if defined(CONFIG_RTL_8812_SUPPORT) || defined(CONFIG_WLAN_HAL_8814AE) || defined(CONFIG_WLAN_HAL_8881A) || defined(CONFIG_WLAN_HAL_8822BE)
#define MIB_HW_TX_POWER_DIFF_20BW1S_OFDM1T_A		2200		
#define MIB_HW_TX_POWER_DIFF_40BW2S_20BW2S_A		2201
#define MIB_HW_TX_POWER_DIFF_OFDM2T_CCK2T_A			2202
#define MIB_HW_TX_POWER_DIFF_40BW3S_20BW3S_A		2203
#define MIB_HW_TX_POWER_DIFF_OFDM3T_CCK3T_A			2204
#define MIB_HW_TX_POWER_DIFF_40BW4S_20BW4S_A		2205
#define MIB_HW_TX_POWER_DIFF_OFDM4T_CCK4T_A			2206

#define MIB_HW_TX_POWER_DIFF_5G_20BW1S_OFDM1T_A		2207
#define MIB_HW_TX_POWER_DIFF_5G_40BW2S_20BW2S_A		2208
#define MIB_HW_TX_POWER_DIFF_5G_40BW3S_20BW3S_A		2209
#define MIB_HW_TX_POWER_DIFF_5G_40BW4S_20BW4S_A		2210
#define MIB_HW_TX_POWER_DIFF_5G_RSVD_OFDM4T_A		2211
#define MIB_HW_TX_POWER_DIFF_5G_80BW1S_160BW1S_A	2212
#define MIB_HW_TX_POWER_DIFF_5G_80BW2S_160BW2S_A	2213
#define MIB_HW_TX_POWER_DIFF_5G_80BW3S_160BW3S_A	2214
#define MIB_HW_TX_POWER_DIFF_5G_80BW4S_160BW4S_A	2215


#define MIB_HW_TX_POWER_DIFF_20BW1S_OFDM1T_B		2220		
#define MIB_HW_TX_POWER_DIFF_40BW2S_20BW2S_B		2221
#define MIB_HW_TX_POWER_DIFF_OFDM2T_CCK2T_B			2222
#define MIB_HW_TX_POWER_DIFF_40BW3S_20BW3S_B		2223
#define MIB_HW_TX_POWER_DIFF_OFDM3T_CCK3T_B			2224
#define MIB_HW_TX_POWER_DIFF_40BW4S_20BW4S_B		2225
#define MIB_HW_TX_POWER_DIFF_OFDM4T_CCK4T_B			2226

#define MIB_HW_TX_POWER_DIFF_5G_20BW1S_OFDM1T_B		2227
#define MIB_HW_TX_POWER_DIFF_5G_40BW2S_20BW2S_B		2228
#define MIB_HW_TX_POWER_DIFF_5G_40BW3S_20BW3S_B		2229
#define MIB_HW_TX_POWER_DIFF_5G_40BW4S_20BW4S_B		2230
#define MIB_HW_TX_POWER_DIFF_5G_RSVD_OFDM4T_B		2231
#define MIB_HW_TX_POWER_DIFF_5G_80BW1S_160BW1S_B	2232
#define MIB_HW_TX_POWER_DIFF_5G_80BW2S_160BW2S_B	2233
#define MIB_HW_TX_POWER_DIFF_5G_80BW3S_160BW3S_B	2234
#define MIB_HW_TX_POWER_DIFF_5G_80BW4S_160BW4S_B	2235
#endif

#if defined(CONFIG_WLAN_HAL_8814AE)
#define MIB_HW_TX_POWER_DIFF_20BW1S_OFDM1T_C		2300
#define MIB_HW_TX_POWER_DIFF_40BW2S_20BW2S_C		2301
#define MIB_HW_TX_POWER_DIFF_OFDM2T_CCK2T_C			2302
#define MIB_HW_TX_POWER_DIFF_40BW3S_20BW3S_C		2303
#define MIB_HW_TX_POWER_DIFF_OFDM3T_CCK3T_C			2304
#define MIB_HW_TX_POWER_DIFF_40BW4S_20BW4S_C		2305
#define MIB_HW_TX_POWER_DIFF_OFDM4T_CCK4T_C			2306

#define MIB_HW_TX_POWER_DIFF_5G_20BW1S_OFDM1T_C		2307
#define MIB_HW_TX_POWER_DIFF_5G_40BW2S_20BW2S_C		2308
#define MIB_HW_TX_POWER_DIFF_5G_40BW3S_20BW3S_C		2309
#define MIB_HW_TX_POWER_DIFF_5G_40BW4S_20BW4S_C		2310
#define MIB_HW_TX_POWER_DIFF_5G_RSVD_OFDM4T_C		2311
#define MIB_HW_TX_POWER_DIFF_5G_80BW1S_160BW1S_C	2312
#define MIB_HW_TX_POWER_DIFF_5G_80BW2S_160BW2S_C	2313
#define MIB_HW_TX_POWER_DIFF_5G_80BW3S_160BW3S_C	2314
#define MIB_HW_TX_POWER_DIFF_5G_80BW4S_160BW4S_C	2315

#define MIB_HW_TX_POWER_DIFF_20BW1S_OFDM1T_D		2320
#define MIB_HW_TX_POWER_DIFF_40BW2S_20BW2S_D		2321
#define MIB_HW_TX_POWER_DIFF_OFDM2T_CCK2T_D			2322
#define MIB_HW_TX_POWER_DIFF_40BW3S_20BW3S_D		2323
#define MIB_HW_TX_POWER_DIFF_OFDM3T_CCK3T_D			2324
#define MIB_HW_TX_POWER_DIFF_40BW4S_20BW4S_D		2325
#define MIB_HW_TX_POWER_DIFF_OFDM4T_CCK4T_D			2326

#define MIB_HW_TX_POWER_DIFF_5G_20BW1S_OFDM1T_D		2327
#define MIB_HW_TX_POWER_DIFF_5G_40BW2S_20BW2S_D		2328
#define MIB_HW_TX_POWER_DIFF_5G_40BW3S_20BW3S_D		2329
#define MIB_HW_TX_POWER_DIFF_5G_40BW4S_20BW4S_D		2330
#define MIB_HW_TX_POWER_DIFF_5G_RSVD_OFDM4T_D		2331
#define MIB_HW_TX_POWER_DIFF_5G_80BW1S_160BW1S_D	2332
#define MIB_HW_TX_POWER_DIFF_5G_80BW2S_160BW2S_D	2333
#define MIB_HW_TX_POWER_DIFF_5G_80BW3S_160BW3S_D	2334
#define MIB_HW_TX_POWER_DIFF_5G_80BW4S_160BW4S_D	2335
#endif
#ifdef SAMBA_WEB_SUPPORT
#define MIB_STORAGE_USER_TBL_NUM					2540
#define MIB_STORAGE_USER_TBL			((MIB_STORAGE_USER_TBL_NUM+1)|MIB_TABLE_LIST)
#define MIB_STORAGE_USER_ADD			((MIB_STORAGE_USER_TBL_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_STORAGE_USER_DEL			((MIB_STORAGE_USER_TBL_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_STORAGE_USER_MOD			((MIB_STORAGE_USER_TBL_NUM+3)|MIB_DEL_TBL_ENTRY | MIB_MOD_TBL_ENTRY)
#define MIB_STORAGE_USER_DELALL			((MIB_STORAGE_USER_TBL_NUM+4)|MIB_DELALL_TBL_ENTRY)


#define MIB_STORAGE_GROUP_TBL_NUM					2550
#define MIB_STORAGE_GROUP_TBL			((MIB_STORAGE_GROUP_TBL_NUM+1)|MIB_TABLE_LIST)
#define MIB_STORAGE_GROUP_ADD			((MIB_STORAGE_GROUP_TBL_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_STORAGE_GROUP_DEL			((MIB_STORAGE_GROUP_TBL_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_STORAGE_GROUP_MOD			((MIB_STORAGE_GROUP_TBL_NUM+3)|MIB_DEL_TBL_ENTRY | MIB_MOD_TBL_ENTRY)
#define MIB_STORAGE_GROUP_DELALL		((MIB_STORAGE_GROUP_TBL_NUM+4)|MIB_DELALL_TBL_ENTRY)

#define MIB_STORAGE_USER_NAME						2501
#define MIB_STORAGE_USER_PASSWD						2502
#define MIB_STORAGE_USER_GROUP						2503

#define MIB_STORAGE_GROUP_NAME						2511
#define MIB_STORAGE_GROUP_ACCESS					2512
#define MIB_STORAGE_GROUP_SHAREFOLDER_FLAG			2513
#define MIB_STORAGE_GROUP_DISPLAYNAME				2514
#define	MIB_STORAGE_GROUP_SHAREFOLDER				2515

#define MIB_STORAGE_ANON_ENABLE						2520
//#define MIB_STORAGE_ANON_FTP_ENABLE					2521
#define MIB_STORAGE_ANON_DISK_ENABLE				2522

#define MIB_STORAGE_FOLDER_LOCAL					2523
#define MIB_STORAGE_GROUP_EDIT_INDEX				2524
#define MIB_STORAGE_USER_EDIT_INDEX					2525
#define MIB_STORAGE_FOLDER_EDIT_NAME				2526

#define MIB_STORAGE_SHAREINFO_TBL_NUM				2530
#define MIB_STORAGE_SHAREINFO_TBL			((MIB_STORAGE_SHAREINFO_TBL_NUM+1)|MIB_TABLE_LIST)
#define MIB_STORAGE_SHAREINFO_ADD			((MIB_STORAGE_SHAREINFO_TBL_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_STORAGE_SHAREINFO_DEL			((MIB_STORAGE_SHAREINFO_TBL_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_STORAGE_SHAREINFO_MOD			((MIB_STORAGE_SHAREINFO_TBL_NUM+3)|MIB_DEL_TBL_ENTRY | MIB_MOD_TBL_ENTRY)
#define MIB_STORAGE_SHAREINFO_DELALL		((MIB_STORAGE_SHAREINFO_TBL_NUM+4)|MIB_DELALL_TBL_ENTRY)
#define MIB_STORAGE_SHAREINFO_FOLDERNAME			2531
#define MIB_STORAGE_SHAREINFO_FOLDERPATH			2532
#define MIB_STORAGE_SHAREINFO_OWNUSER				2533
#define MIB_STORAGE_SHAREINFO_PERMISSION			2534
#endif
#ifdef CONFIG_RTL_ETH_802DOT1X_SUPPORT
#define MIB_ELAN_RS_IP			3032
#define MIB_ELAN_RS_PORT		3033
#define MIB_ELAN_RS_PASSWORD		3034
#define MIB_ELAN_ENABLE_1X		3035
#define MIB_ELAN_RS_REAUTH_TO	3036
#define MIB_ELAN_ACCOUNT_RS_ENABLED	3039
#define MIB_ELAN_ACCOUNT_RS_IP		3040
#define MIB_ELAN_ACCOUNT_RS_PORT	3041
#define MIB_ELAN_ACCOUNT_RS_PASSWORD	3042
#define MIB_ELAN_ACCOUNT_RS_UPDATE_ENABLED	3043
#define MIB_ELAN_ACCOUNT_RS_UPDATE_DELAY	3044
#define MIB_ELAN_MAC_AUTH_ENABLED	3045
#define MIB_ELAN_RS_MAXRETRY		3046
#define MIB_ELAN_RS_INTERVAL_TIME	3047
#define MIB_ELAN_ACCOUNT_RS_MAXRETRY	3048
#define MIB_ELAN_ACCOUNT_RS_INTERVAL_TIME 3049
#define MIB_ELAN_DOT1X_MODE				  3050
#define MIB_ELAN_DOT1X_PROXY_TYPE		  3051
#define MIB_ELAN_DOT1X_CLIENT_MODE_PORT_MASK 3052
#define MIB_ELAN_DOT1X_PROXY_MODE_PORT_MASK	3053


#define MIB_ELAN_INACTIVITY_TIME	3054
#define MIB_ELAN_EAPOL_UNICAST_ENABLED 3055
#ifdef CONFIG_RTL_ETH_802DOT1X_CLIENT_MODE_SUPPORT
#define MIB_ELAN_EAP_TYPE 				3056
#define MIB_ELAN_EAP_INSIDE_TYPE 		3057
#define MIB_ELAN_EAP_USER_ID			3058
#define MIB_ELAN_RS_USER_NAME			3059
#define MIB_ELAN_RS_USER_PASSWD			3060
#define MIB_ELAN_RS_USER_CERT_PASSWD	3061
#define MIB_ELAN_EAP_PHASE2_TYPE		3062
#define MIB_ELAN_PHASE2_EAP_METHOD		3063
#endif
typedef enum {ETH_DOT1X_CLIENT_MODE=1,ETH_DOT1X_PROXY_MODE=2}ETH_DOT1X_MODE_T;
#define MIB_ELAN_DOT1X_PORT_ENABLED		3070
#define MIB_ELAN_DOT1X_PORT_NUMBER		3071
#define MIB_ELAN_DOT1X_SERVER_PORT		3072

#define MIB_ELAN_DOT1X_TBL_NUM	       	3073
#define MIB_ELAN_DOT1X_TBL		      ((MIB_ELAN_DOT1X_TBL_NUM+1)|MIB_TABLE_LIST)
#define MIB_ELAN_DOT1X_ADD		      ((MIB_ELAN_DOT1X_TBL_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_ELAN_DOT1X_DEL		      ((MIB_ELAN_DOT1X_TBL_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_ELAN_DOT1X_DELALL		  ((MIB_ELAN_DOT1X_TBL_NUM+4)|MIB_DELALL_TBL_ENTRY)

#define MAX_ELAN_DOT1X_PORTNUM (5) /* eth0~eth4 */
#define ETH_DOT1X_CLIENT_PORT	(4)
#define ETH_DOT1X_PROXY_SNOOPING_MODE_ENABLE_BIT	(1<<0)
#define ETH_DOT1X_CLIENT_MODE_ENABLE_BIT	(1<<1)
#define ETH_DOT1X_PROXY_MODE_ENABLE_BIT	(1<<0)


#define ETH_DOT1X_CLIENT_MODE_BIT			(1<<0)
#define ETH_DOT1X_PROXY_MODE_BIT			(1<<1)
#define ETH_DOT1X_SNOOPING_MODE_BIT			(1<<2)
#endif

#define MIB_WLAN_RETRY_LIMIT	2252
#define MIB_WLAN_UAPSD_ENABLED	2253
#define MIB_WLAN_REGULATORY_DOMAIN	2254
#define MIB_PPPOE_DHCP_ENABLED	2259

#define MAX_L2TP_BUFF_LEN		128

#define MIB_PPP_SESSION_NUM	940
#define MIB_PPP_SERVER_MAC	941
#define MIB_L2TP_PAYLOAD    942
#define MIB_L2TP_PAYLOAD_LENGTH	943
#define MIB_L2TP_NS 944
#define MIB_DHCP_LEASE_TIME     945
/* WNC-MR1532-JOE-PENG-20120411-Patch PPPoE Disconnect solution from Realtek */
#define MIB_PPP_NORMAL_FINISH		946
/* WNC-MR1532-JOE-PENG-20120411-end */

/*--- airtime fairness -------------------------------------------------------*/
#ifdef CONFIG_RTL_AIRTIME
#define MAX_AIRTIME_NUM 20

#define AIRTIME_ID             3100
#define MIB_AIRTIME_ENABLED    (AIRTIME_ID+0)
#define MIB_AIRTIME_MODE       (AIRTIME_ID+1)
#define MIB_AIRTIME_IFTIME     (AIRTIME_ID+2)
#define MIB_AIRTIME_TBL_NUM    (AIRTIME_ID+3)
#define MIB_AIRTIME_TBL        ((MIB_AIRTIME_TBL_NUM+1)|MIB_TABLE_LIST)
#define MIB_AIRTIME_ADD        ((MIB_AIRTIME_TBL_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_AIRTIME_DEL        ((MIB_AIRTIME_TBL_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_AIRTIME_DELALL     ((MIB_AIRTIME_TBL_NUM+4)|MIB_DELALL_TBL_ENTRY)

#define MIB_AIRTIME_MACADDR (AIRTIME_ID+4)
#define MIB_AIRTIME_IPADDR  (AIRTIME_ID+5)
#define MIB_AIRTIME_STATIME (AIRTIME_ID+6)
#define MIB_AIRTIME_COMMENT (AIRTIME_ID+7)

#define AIRTIME2_ID             (AIRTIME_ID+8)
#define MIB_AIRTIME2_ENABLED    (AIRTIME2_ID+0)
#define MIB_AIRTIME2_MODE       (AIRTIME2_ID+1)
#define MIB_AIRTIME2_IFTIME     (AIRTIME2_ID+2)
#define MIB_AIRTIME2_TBL_NUM    (AIRTIME2_ID+3)
#define MIB_AIRTIME2_TBL        ((MIB_AIRTIME2_TBL_NUM+1)|MIB_TABLE_LIST)
#define MIB_AIRTIME2_ADD        ((MIB_AIRTIME2_TBL_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_AIRTIME2_DEL        ((MIB_AIRTIME2_TBL_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_AIRTIME2_DELALL     ((MIB_AIRTIME2_TBL_NUM+4)|MIB_DELALL_TBL_ENTRY)

typedef enum {
	ATM_SSID_AUTO = 1,
	ATM_SSID_MANUAL,
	ATM_DEVICE_AUTO,
	ATM_DEVICE_MANUAL
} AIRTIME_MODE_T;

#endif /* CONFIG_RTL_AIRTIME */
/*----------------------------------------------------------------------------*/


#define MIB_CONFIG_TAG 7621

/*=========add for DS-Lite===========*/
#ifdef CONFIG_IPV6
#define BASE_ID_FOR_DSLITE 19080
#define MIB_DSLITE_ENABLE 			BASE_ID_FOR_DSLITE + 0
#define MIB_DSLITE_AFTR_AUTO_CONF		BASE_ID_FOR_DSLITE + 1
#define MIB_DSLITE_AFTR_SPECIFY_TYPE	BASE_ID_FOR_DSLITE + 2
#define MIB_DSLITE_AFTR_FQDN			BASE_ID_FOR_DSLITE + 3
#define MIB_DSLITE_AFTR_IPV6_ADDR		BASE_ID_FOR_DSLITE + 4
#define AFTR_FQDN_MAX_LEN				254
#endif
/*=========end DS-Lite===========*/

/*=========add for MAP-E===========*/
#ifdef CONFIG_IPV6
#ifdef CONFIG_MAP_E_SUPPORT
#define BASE_ID_FOR_MAPE 19090 // redefine id in user area
#define MIB_MAPE_ENABLE 			BASE_ID_FOR_MAPE + 0
#if 0 // disable original map-e
#define BASE_ID_FOR_MAPE 3450  // currently use 3450~3459
#define MIB_MAPE_ENABLE 			BASE_ID_FOR_MAPE + 0
#define MIB_MAPE_MODE				BASE_ID_FOR_MAPE + 1
#define MIB_IPV6_MAPE_PREFIX		BASE_ID_FOR_MAPE + 2
#define MIB_IPV4_MAPE				BASE_ID_FOR_MAPE + 3
#define MIB_IPV4_MAPE_PREFIX_LEN	BASE_ID_FOR_MAPE + 4
#define MIB_IPV6_MAPE_BR_ADDR		BASE_ID_FOR_MAPE + 5
#define MIB_MAPE_PSID_OFFSET		BASE_ID_FOR_MAPE + 6
#define MIB_MAPE_PSID_LEN			BASE_ID_FOR_MAPE + 7
#define MIB_MAPE_PSID				BASE_ID_FOR_MAPE + 8
#endif
#endif
#endif
/*=========end MAP-E===========*/

/*=========add for Fixed IP Address===========*/
#ifdef CONFIG_IPV6
#ifdef CONFIG_FIXEDIP_SUPPORT
#define BASE_ID_FOR_FIXEDIP		19400
#define MIB_FIXEDIP_ENABLE			(BASE_ID_FOR_FIXEDIP + 0)
#define MIB_FIXEDIP_BR_AUTO_CONF	(BASE_ID_FOR_FIXEDIP + 1)
#define MIB_FIXEDIP_GLOBALIP		(BASE_ID_FOR_FIXEDIP + 2)
#define MIB_FIXEDIP_MASKLEN			(BASE_ID_FOR_FIXEDIP + 3)
#define MIB_FIXEDIP_CPEIPV6			(BASE_ID_FOR_FIXEDIP + 4)
#define MIB_FIXEDIP_REMOTEIPV6		(BASE_ID_FOR_FIXEDIP + 5)
#define MIB_FIXEDIP_HOSTNAME		(BASE_ID_FOR_FIXEDIP + 6)
#define MIB_FIXEDIP_GUIGLOBALIP		(BASE_ID_FOR_FIXEDIP + 7)
#define MIB_FIXEDIP_GUIMASKLEN		(BASE_ID_FOR_FIXEDIP + 8)
#define MIB_FIXEDIP_BK_IPADDR		(BASE_ID_FOR_FIXEDIP + 9)
#define MIB_FIXEDIP_BK_SUBNET_MASK	(BASE_ID_FOR_FIXEDIP + 10)
#define FIXEDIP_HOSTNAME_MAX_LEN				256
#endif
#endif
/*=========end Fixed IP Address===========*/

/* ==== CAPWAP start =======*/
#ifdef RTK_CAPWAP // currently use 2360~2385
#define MIB_CAPWAP_MODE			2360
	typedef enum {
		CAPWAP_DISABLE = 0,
		CAPWAP_WTP_ENABLE = (1<<0),
		CAPWAP_AC_ENABLE = (1<<1),
		CAPWAP_BOTH_ENABLE = (CAPWAP_WTP_ENABLE | CAPWAP_AC_ENABLE),
	} CAPWAP_MODE_T;

// for WTP (if WTP enabled or both enabled)
#define MIB_CAPWAP_WTP_ID		2361	// 0 is invalid
#define MIB_CAPWAP_AC_IP		2362

// for AC (if AC enabled or both enabled)
#define MIB_CAPWAP_WTP_DEFAULT_FWID	2364
#define MIB_CAPWAP_WTP_CONFIG_TBL_NUM	2365	// <= MAX_CAPWAP_WTP_NUM
#define MIB_CAPWAP_WTP_CONFIG_TBL		((MIB_CAPWAP_WTP_CONFIG_TBL_NUM+1)|MIB_TABLE_LIST)
#define MIB_CAPWAP_WTP_CONFIG_ADD		((MIB_CAPWAP_WTP_CONFIG_TBL_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_CAPWAP_WTP_CONFIG_DEL		((MIB_CAPWAP_WTP_CONFIG_TBL_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_CAPWAP_WTP_CONFIG_DELALL	((MIB_CAPWAP_WTP_CONFIG_TBL_NUM+4)|MIB_DELALL_TBL_ENTRY)

#define MIB_CAPWAP_CFG_WTP_ID			2370	// 0 is invalid
#define MIB_CAPWAP_CFG_RADIO_NUM		2371	// radios per wtp <= MAX_CAPWAP_RADIO_NUM
#define MIB_CAPWAP_CFG_WLAN_NUM			2372	// wlans per radio <= MAX_CAPWAP_WLAN_NUM

#define MIB_CAPWAP_CFG_RFPOWER_SCALE	2373	// for multiple radios
/*
	typedef enum {
		POWER_SCALE_100 = 0,
		POWER_SCALE_70 = 1,
		POWER_SCALE_50 = 2,
		POWER_SCALE_35 = 3,
		POWER_SCALE_15 = 4,
	} WLAN_POWER_SCALE_T;
 */
#define MIB_CAPWAP_CFG_CHANNEL			2374	// for multiple radios
#define MIB_CAPWAP_CFG_WLAN				2375	// for multiple wlans (vaps)
#define MIB_CAPWAP_CFG_FWID			2376	// per wtp

#define MIB_CAPWAP_CFG_WLAN_ENABLE		2380	// for each wlan (vap)
#define MIB_CAPWAP_CFG_KEY_TYPE			2381	// for each wlan (vap)
	typedef enum {
		CAPWAP_KEY_TYPE_NONE = 0,
		CAPWAP_KEY_TYPE_SHARED_WEP40,
		CAPWAP_KEY_TYPE_SHARED_WEP104,
		CAPWAP_KEY_TYPE_SHARED_WPA_AES,
		CAPWAP_KEY_TYPE_SHARED_WPA_TKIP,
		CAPWAP_KEY_TYPE_SHARED_WPA2_AES,
		CAPWAP_KEY_TYPE_SHARED_WPA2_TKIP,
	} CAPWAP_KEY_TYPE_T;
#define MIB_CAPWAP_CFG_PSK_FORMAT		2382	// for each wlan (vap)
	typedef enum {
		PSK_FORMAT_PASSPHRASE = 0,
		PSK_FORMAT_HEX = 1,
	}PASK_FORMAT_T;
#define MIB_CAPWAP_CFG_KEY				2383	// for each wlan (vap)
#define MIB_CAPWAP_CFG_SSID				2384	// for each wlan (vap)
#define MIB_CAPWAP_CFG_BSSID			2385	// for each wlan (vap)

#define MAX_CAPWAP_WTP_NUM		50	// max wtps for one AC
#define MAX_CAPWAP_RADIO_NUM	2 	// radios per wtp
#define MAX_CAPWAP_WLAN_NUM		5	// max wlans per radio
#define MAX_CAPWAP_FWID_BUF_SIZE	32
#endif //#ifdef RTK_CAPWAP
/* ==== CAPWAP end =======*/

/* ==== NASFILTER START ==== */
#define CUSTOMER_ID					3300
#define MIB_NASFILTER_ENABLED		CUSTOMER_ID + 0
#define MIB_NASFILTER_TBL_NUM		CUSTOMER_ID + 1 
#define MIB_NASFILTER_TBL			((MIB_NASFILTER_TBL_NUM+1)|MIB_TABLE_LIST)
#define MIB_NASFILTER_ADD			((MIB_NASFILTER_TBL_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_NASFILTER_DEL			((MIB_NASFILTER_TBL_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_NASFILTER_DELALL		((MIB_NASFILTER_TBL_NUM+4)|MIB_DELALL_TBL_ENTRY)
/* ==== NASFILTER END ==== */
#ifdef CONFIG_APP_WEAVE
#define MIB_WEAVE_REGISTERED 3000
#define MIB_WEAVE_CONFIG 3001
#endif
/* ==== Linux 802.1Q-Vlan START ==== */
#ifdef CONFIG_8021Q_VLAN_SUPPORTED
#define MIB_VLAN_TYPE						3400
#define MIB_VLAN_ID							3401
#define MIB_VLAN_PRIORITY					3402
#define MIB_VLAN_MEMBER_PORT_MASK			3403
#define MIB_VLAN_TAGGED_PORT_MASK			3404

#define MIB_VLAN_HW_NAT_LAN_VID				3410
#define MIB_VLAN_PVID_ARRAY					3411
#define MIB_VLAN_OPMODE						3412
#define MIB_VLAN_ENABLED					3413
#define MIB_VLAN_TBL_NUM					3414
#define MIB_VLAN_TBL					((MIB_VLAN_TBL_NUM+1)|MIB_TABLE_LIST)
#define MIB_VLAN_ADD       				((MIB_VLAN_TBL_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_VLAN_DEL        			((MIB_VLAN_TBL_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_VLAN_MOD					((MIB_VLAN_TBL_NUM+3)|MIB_DEL_TBL_ENTRY| MIB_MOD_TBL_ENTRY)
#define MIB_VLAN_DELALL					((MIB_VLAN_TBL_NUM+4)|MIB_DELALL_TBL_ENTRY)
#endif
/* ==== Linux 802.1Q-Vlan END ==== */


/* ==== ADVANCED_IPQOS start ==== */
#if defined(ADVANCED_IPQOS)
#define MIB_IPQOS_DST_MAC 			3500
#define MIB_IPQOS_PROTOCOL 			3501
#define MIB_IPQOS_LOCAL_PORT_START 	3502
#define MIB_IPQOS_LOCAL_PORT_END	3503
#define MIB_IPQOS_REMOTE_IP_START	3504
#define MIB_IPQOS_REMOTE_IP_END		3505
#define MIB_IPQOS_REMOTE_PORT_START 3506
#define MIB_IPQOS_REMOTE_PORT_END 	3507
#define MIB_IPQOS_DSCP				3508
#define MIB_IPQOS_VLAN_PRI 			3509
#define MIB_IPQOS_POLICY 			3510
#define MIB_IPQOS_PRIORITY 			3511
#define MIB_IPQOS_WEIGHT 			3512
//#define MIB_IPQOS_PRIORITY 			3513
#define MIB_IPQOS_PHYPORT			3514
#define MIB_IPQOS_REMARK_DSCP		3515
#define MIB_IPQOS_REMARK_VLAN_PRI	3516
#define MIB_IPQOS_IPVERSION			3517
#endif
/* ==== ADVANCED_IPQOS end ==== */

/* ==== Tr098 qos mib define begin =====================*/
#ifdef QOS_OF_TR069
#define MIB_QOS_ENABLE                          8000
#define MIB_QOS_MAX_QUEUE                       8001
#define MIB_QOS_MAX_QUEUE_ENTRIES               8002
#define MIB_QOS_DEF_QUEUE                       8003
#define MIB_QOS_DEF_DSCP_MARK                   8004
#define MIB_QOS_DEF_ETHERNET_PRIO_MARK          8005
#define MIB_QOS_DEF_FORWORDING_POLICY           8006
#define MIB_QOS_DEF_TRAFFIC_CLASS               8007
#define MIB_QOS_AVAIL_APP_LIST                  8008
#define MIB_QOS_DEF_POLICER                     8009

#define MIB_QOS_CLASS_TBL_NUM                   8020
#define MIB_QOS_CLASS_TBL                       ((MIB_QOS_CLASS_TBL_NUM+1)|MIB_TABLE_LIST)
#define MIB_QOS_CLASS_ADD                       ((MIB_QOS_CLASS_TBL_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_QOS_CLASS_DEL                       ((MIB_QOS_CLASS_TBL_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_QOS_CLASS_MOD                       ((MIB_QOS_CLASS_TBL_NUM+3)|MIB_DEL_TBL_ENTRY|MIB_MOD_TBL_ENTRY)
#define MIB_QOS_CLASS_DELALL                    ((MIB_QOS_CLASS_TBL_NUM+4)|MIB_DELALL_TBL_ENTRY)

#define MIB_QOSCLASS_INTERFACE                  (MIB_QOS_CLASS_TBL_NUM+10)
#define MIB_QOSCLASS_DEST_IP		            (MIB_QOS_CLASS_TBL_NUM+11)
#define MIB_QOSCLASS_DEST_MASK		            (MIB_QOS_CLASS_TBL_NUM+12)
#define MIB_QOSCLASS_DEST_IP_EXCLUDE	        (MIB_QOS_CLASS_TBL_NUM+13)
#define MIB_QOSCLASS_SOURCE_IP		            (MIB_QOS_CLASS_TBL_NUM+14)
#define MIB_QOSCLASS_SOURCE_MASK	            (MIB_QOS_CLASS_TBL_NUM+15)
#define MIB_QOSCLASS_SOURCE_IP_EXCLUDE	        (MIB_QOS_CLASS_TBL_NUM+16)
#define MIB_QOSCLASS_PROTOCOL		            (MIB_QOS_CLASS_TBL_NUM+17)
#define MIB_QOSCLASS_PROTOCOL_EXCLUDE	        (MIB_QOS_CLASS_TBL_NUM+18)
#define MIB_QOSCLASS_DEST_PORT		            (MIB_QOS_CLASS_TBL_NUM+19)
#define MIB_QOSCLASS_DEST_PORT_RANGE_MAX	    (MIB_QOS_CLASS_TBL_NUM+20)
#define MIB_QOSCLASS_DEST_PORT_EXCLUDE		    (MIB_QOS_CLASS_TBL_NUM+21)
#define MIB_QOSCLASS_SOURCE_PORT			    (MIB_QOS_CLASS_TBL_NUM+22)
#define MIB_QOSCLASS_SOURCE_PORT_RANGE_MAX	    (MIB_QOS_CLASS_TBL_NUM+23)
#define MIB_QOSCLASS_SOURCE_PORT_EXCLUDE	    (MIB_QOS_CLASS_TBL_NUM+24)
#define MIB_QOSCLASS_SOURCE_MAC_ADDRESS		    (MIB_QOS_CLASS_TBL_NUM+25)
#define MIB_QOSCLASS_SOURCE_MAC_EXCLUDE		    (MIB_QOS_CLASS_TBL_NUM+26)
#define MIB_QOSCLASS_DEST_MAC_ADDRESS           (MIB_QOS_CLASS_TBL_NUM+27)
#define MIB_QOSCLASS_DSCP_CHECK				    (MIB_QOS_CLASS_TBL_NUM+28)
#define MIB_QOSCLASS_DSCP_MARK				    (MIB_QOS_CLASS_TBL_NUM+29)
#define MIB_QOSCLASS_ETHERNET_PRIORITY_CHECK	(MIB_QOS_CLASS_TBL_NUM+30)
#define MIB_QOSCLASS_ETHERNET_PRIORITY_MARK		(MIB_QOS_CLASS_TBL_NUM+31)
#define MIB_QOSCLASS_VLAN_ID_CHECK				(MIB_QOS_CLASS_TBL_NUM+32)
#define MIB_QOSCLASS_QUEUE						(MIB_QOS_CLASS_TBL_NUM+33)
#define MIB_QOSCLASS_INSTANCENUM                (MIB_QOS_CLASS_TBL_NUM+34)
#define MIB_QOSCLASS_ENABLE                     (MIB_QOS_CLASS_TBL_NUM+35)
#define MIB_QOSCLASS_STATUS                     (MIB_QOS_CLASS_TBL_NUM+36)
#define MIB_QOSCLASS_ALIAS                      (MIB_QOS_CLASS_TBL_NUM+37)
#define MIB_QOSCLASS_ORDER                      (MIB_QOS_CLASS_TBL_NUM+38)
#define MIB_QOSCLASS_SOURCE_MAC_MASK            (MIB_QOS_CLASS_TBL_NUM+39)
#define MIB_QOSCLASS_DEST_MAC_MASK              (MIB_QOS_CLASS_TBL_NUM+40)
#define MIB_QOSCLASS_DEST_MAC_EXCLUDE           (MIB_QOS_CLASS_TBL_NUM+41)
#define MIB_QOSCLASS_ETHERTYPE                  (MIB_QOS_CLASS_TBL_NUM+42)
#define MIB_QOSCLASS_THERTYPE_EXCLUDE           (MIB_QOS_CLASS_TBL_NUM+43)
#define MIB_QOSCLASS_SSAP_EXCLUDE               (MIB_QOS_CLASS_TBL_NUM+44)
#define MIB_QOSCLASS_SSAP                       (MIB_QOS_CLASS_TBL_NUM+45)
#define MIB_QOSCLASS_DSAP                       (MIB_QOS_CLASS_TBL_NUM+46)
#define MIB_QOSCLASS_DSAP_EXCLUDE               (MIB_QOS_CLASS_TBL_NUM+47)
#define MIB_QOSCLASS_LLC_CONTROL                (MIB_QOS_CLASS_TBL_NUM+48)
#define MIB_QOSCLASS_LLC_CONTROL_EXCLUDE        (MIB_QOS_CLASS_TBL_NUM+49)
#define MIB_QOSCLASS_SNAPOUI                    (MIB_QOS_CLASS_TBL_NUM+50)
#define MIB_QOSCLASS_SANPOUI_EXCLUDE            (MIB_QOS_CLASS_TBL_NUM+51)
#define MIB_QOSCLASS_SOURCE_VENDOR_CLASSID      (MIB_QOS_CLASS_TBL_NUM+52)
#define MIB_QOSCLASS_SOURCE_VENDOR_CLASSID_EXCLUDE              (MIB_QOS_CLASS_TBL_NUM+53)
#define MIB_QOSCLASS_SOURCE_VENDOR_CLASSID_MODE                 (MIB_QOS_CLASS_TBL_NUM+54)
#define MIB_QOSCLASS_DEST_VENDOR_CLASSID                        (MIB_QOS_CLASS_TBL_NUM+55)
#define MIB_QOSCLASS_DEST_VENDOR_CLASSID_EXCLUDE                (MIB_QOS_CLASS_TBL_NUM+56)
#define MIB_QOSCLASS_DEST_VENDOR_CLASSID_MODE                   (MIB_QOS_CLASS_TBL_NUM+57)
#define MIB_QOSCLASS_SOURCE_CLIENTID                            (MIB_QOS_CLASS_TBL_NUM+58)
#define MIB_QOSCLASS_SOURCE_CLIENTID_EXCLUDE                    (MIB_QOS_CLASS_TBL_NUM+59)
#define MIB_QOSCLASS_DEST_CLIENTID                              (MIB_QOS_CLASS_TBL_NUM+60)
#define MIB_QOSCLASS_DEST_CLIENTID_EXCLUDE                      (MIB_QOS_CLASS_TBL_NUM+61)
#define MIB_QOSCLASS_SOURCE_USER_CLASSID                        (MIB_QOS_CLASS_TBL_NUM+62)
#define MIB_QOSCLASS_SOURCE_USER_CLASSID_EXCLUDE                (MIB_QOS_CLASS_TBL_NUM+63)
#define MIB_QOSCLASS_DEST_USER_CLASSID                          (MIB_QOS_CLASS_TBL_NUM+64)
#define MIB_QOSCLASS_DEST_USER_CLASSID_EXCLUDE                  (MIB_QOS_CLASS_TBL_NUM+65)
#define MIB_QOSCLASS_SOURCE_VENDOR_SPECIFIC_INFO                (MIB_QOS_CLASS_TBL_NUM+66)
#define MIB_QOSCLASS_SOURCE_VENDOR_SPECIFIC_INFO_EXCLUDE        (MIB_QOS_CLASS_TBL_NUM+67)
#define MIB_QOSCLASS_SOURCE_VENDOR_SPECIFIC_INFO_ENTERPRISE     (MIB_QOS_CLASS_TBL_NUM+68)
#define MIB_QOSCLASS_SOURCE_VENDOR_SPECIFIC_INFO_SUB_OPTION     (MIB_QOS_CLASS_TBL_NUM+69)
#define MIB_QOSCLASS_SOURCE_VENDOR_SPECIFIC_INFO_MODE           (MIB_QOS_CLASS_TBL_NUM+70)
#define MIB_QOSCLASS_DEST_VENDOR_SPECIFIC_INFO                  (MIB_QOS_CLASS_TBL_NUM+71)
#define MIB_QOSCLASS_DEST_VENDOR_SPECIFIC_INFO_EXCLUDE          (MIB_QOS_CLASS_TBL_NUM+72)
#define MIB_QOSCLASS_DEST_VENDOR_SPECIFIC_INFO_ENTERPRISE       (MIB_QOS_CLASS_TBL_NUM+73)
#define MIB_QOSCLASS_DEST_VENDOR_SPECIFIC_INFO_SUB_OPTION       (MIB_QOS_CLASS_TBL_NUM+74)
#define MIB_QOSCLASS_DEST_VENDOR_SPECIFIC_INFO_MODE             (MIB_QOS_CLASS_TBL_NUM+75)
#define MIB_QOSCLASS_TCPACK                                     (MIB_QOS_CLASS_TBL_NUM+76)
#define MIB_QOSCLASS_TCPACK_EXCLUDE                             (MIB_QOS_CLASS_TBL_NUM+77)
#define MIB_QOSCLASS_IP_LENGTH_MIN                              (MIB_QOS_CLASS_TBL_NUM+78)
#define MIB_QOSCLASS_IP_LENGTH_MAX                              (MIB_QOS_CLASS_TBL_NUM+79)
#define MIB_QOSCLASS_IP_LENGTH_EXCLUDE                          (MIB_QOS_CLASS_TBL_NUM+80)
#define MIB_QOSCLASS_DSCP_EXCLUDE                               (MIB_QOS_CLASS_TBL_NUM+81)
#define MIB_QOSCLASS_ETHERNET_PRIO_EXCLUDE                      (MIB_QOS_CLASS_TBL_NUM+82)     
#define MIB_QOSCLASS_VLAN_ID_EXCLUDE                            (MIB_QOS_CLASS_TBL_NUM+83)
#define MIB_QOSCLASS_OUT_OF_BAND_INFO                           (MIB_QOS_CLASS_TBL_NUM+84)
#define MIB_QOSCLASS_FORWARDING_POLICY                          (MIB_QOS_CLASS_TBL_NUM+85)
#define MIB_QOSCLASS_TRAFFIC_CLASS                              (MIB_QOS_CLASS_TBL_NUM+86)
#define MIB_QOSCLASS_POLICER                                    (MIB_QOS_CLASS_TBL_NUM+87)
#define MIB_QOSCLASS_APP                                        (MIB_QOS_CLASS_TBL_NUM+88)
#define MIB_QOSCLASS_KEY                                        (MIB_QOS_CLASS_TBL_NUM+89) 


#define MIB_QOS_QUEUE_TBL_NUM                   8160 //mark_qos
#define MIB_QOS_QUEUE_TBL                       ((MIB_QOS_QUEUE_TBL_NUM+1)|MIB_TABLE_LIST)
#define MIB_QOS_QUEUE_ADD                       ((MIB_QOS_QUEUE_TBL_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_QOS_QUEUE_DEL                       ((MIB_QOS_QUEUE_TBL_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_QOS_QUEUE_MOD                       ((MIB_QOS_QUEUE_TBL_NUM+3)|MIB_DEL_TBL_ENTRY|MIB_MOD_TBL_ENTRY)
#define MIB_QOS_QUEUE_DELALL                    ((MIB_QOS_QUEUE_TBL_NUM+4)|MIB_DELALL_TBL_ENTRY)


#define MIB_QOSQUEUE_KEY                  		(MIB_QOS_QUEUE_TBL_NUM+9)
#define MIB_QOSQUEUE_INTERFACE                  (MIB_QOS_QUEUE_TBL_NUM+10)
#define MIB_QOSQUEUE_WEIGHT                     (MIB_QOS_QUEUE_TBL_NUM+11)
#define MIB_QOSQUEUE_PRECEDENCE                 (MIB_QOS_QUEUE_TBL_NUM+12)
#define MIB_QOSQUEUE_SCHEDULER_ALGORITHM        (MIB_QOS_QUEUE_TBL_NUM+13)
#define MIB_QOSQUEUE_SHAPING_RATE               (MIB_QOS_QUEUE_TBL_NUM+14)
#define MIB_QOSQUEUE_SHAPING_BURST_SIZE         (MIB_QOS_QUEUE_TBL_NUM+15)
#define MIB_QOSQUEUE_INSTANCENUM                (MIB_QOS_QUEUE_TBL_NUM+16)
#define MIB_QOSQUEUE_ENABLE                     (MIB_QOS_QUEUE_TBL_NUM+17)
#define MIB_QOSQUEUE_STATUS                     (MIB_QOS_QUEUE_TBL_NUM+18)
#define MIB_QOSQUEUE_ALIAS                      (MIB_QOS_QUEUE_TBL_NUM+19)
#define MIB_QOSQUEUE_TRAFFIC_CLASSES            (MIB_QOS_QUEUE_TBL_NUM+20)
#define MIB_QOSQUEUE_BUFFER_LENGTH              (MIB_QOS_QUEUE_TBL_NUM+21)
#define MIB_QOSQUEUE_RED_THRESHOLD             	(MIB_QOS_QUEUE_TBL_NUM+22)
#define MIB_QOSQUEUE_RED_PERCENTAGE          	(MIB_QOS_QUEUE_TBL_NUM+23)
#define MIB_QOSQUEUE_DROP_ALGORITHM          	(MIB_QOS_QUEUE_TBL_NUM+24)

/*app table*/
#define MIB_TR098_QOS_APP_TBL_NUM				8200
#define MIB_TR098_QOS_APP_TBL				((MIB_TR098_QOS_APP_TBL_NUM+1)|MIB_TABLE_LIST)
#define MIB_TR098_QOS_APP_ADD				((MIB_TR098_QOS_APP_TBL_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_TR098_QOS_APP_DEL				((MIB_TR098_QOS_APP_TBL_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_TR098_QOS_APP_MOD				((MIB_TR098_QOS_APP_TBL_NUM+3)|MIB_DEL_TBL_ENTRY | MIB_MOD_TBL_ENTRY)
#define MIB_TR098_QOS_APP_DELALL			((MIB_TR098_QOS_APP_TBL_NUM+4)|MIB_DELALL_TBL_ENTRY)

#define MIB_TR098_QOS_APP_KEY				(MIB_TR098_QOS_APP_TBL_NUM+6)
#define MIB_TR098_QOS_APP_ENABLE			(MIB_TR098_QOS_APP_TBL_NUM+7)
#define MIB_TR098_QOS_APP_STATUS			(MIB_TR098_QOS_APP_TBL_NUM+8)
#define MIB_TR098_QOS_APP_PROTOCOLID		(MIB_TR098_QOS_APP_TBL_NUM+9)
#define MIB_TR098_QOS_APP_NAME				(MIB_TR098_QOS_APP_TBL_NUM+10)
#define MIB_TR098_QOS_APP_DFTPOLICY			(MIB_TR098_QOS_APP_TBL_NUM+11)
#define MIB_TR098_QOS_APP_DFTCLASS			(MIB_TR098_QOS_APP_TBL_NUM+12)
#define MIB_TR098_QOS_APP_DFTPOLICER		(MIB_TR098_QOS_APP_TBL_NUM+13)
#define MIB_TR098_QOS_APP_DFTQUEUE			(MIB_TR098_QOS_APP_TBL_NUM+14)
#define MIB_TR098_QOS_APP_DFTDSCPMARK		(MIB_TR098_QOS_APP_TBL_NUM+15)
#define MIB_TR098_QOS_APP_DFT8021PMARK		(MIB_TR098_QOS_APP_TBL_NUM+16)
#define MIB_TR098_QOS_APP_ALIAS				(MIB_TR098_QOS_APP_TBL_NUM+17)
#define MIB_TR098_QOS_APP_INSTANCENUM		(MIB_TR098_QOS_APP_TBL_NUM+18)	

/*flow table*/
#define MIB_TR098_QOS_FLOW_TBL_NUM			8225
#define MIB_TR098_QOS_FLOW_TBL				((MIB_TR098_QOS_FLOW_TBL_NUM+1)|MIB_TABLE_LIST)
#define MIB_TR098_QOS_FLOW_ADD				((MIB_TR098_QOS_FLOW_TBL_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_TR098_QOS_FLOW_DEL				((MIB_TR098_QOS_FLOW_TBL_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_TR098_QOS_FLOW_MOD				((MIB_TR098_QOS_FLOW_TBL_NUM+3)|MIB_DEL_TBL_ENTRY | MIB_MOD_TBL_ENTRY)
#define MIB_TR098_QOS_FLOW_DELALL			((MIB_TR098_QOS_FLOW_TBL_NUM+4)|MIB_DELALL_TBL_ENTRY)

#define MIB_TR098_QOS_FLOW_KEY				(MIB_TR098_QOS_FLOW_TBL_NUM+6)
#define MIB_TR098_QOS_FLOW_ENABLE			(MIB_TR098_QOS_FLOW_TBL_NUM+7)
#define MIB_TR098_QOS_FLOW_STATUS			(MIB_TR098_QOS_FLOW_TBL_NUM+8)
#define MIB_TR098_QOS_FLOW_TYPE				(MIB_TR098_QOS_FLOW_TBL_NUM+9)
#define MIB_TR098_QOS_FLOW_TYPEPARA			(MIB_TR098_QOS_FLOW_TBL_NUM+10)
#define MIB_TR098_QOS_FLOW_NAME				(MIB_TR098_QOS_FLOW_TBL_NUM+11)
#define MIB_TR098_QOS_FLOW_APPID			(MIB_TR098_QOS_FLOW_TBL_NUM+12)
#define MIB_TR098_QOS_FLOW_POLICY			(MIB_TR098_QOS_FLOW_TBL_NUM+13)
#define MIB_TR098_QOS_FLOW_CLASS			(MIB_TR098_QOS_FLOW_TBL_NUM+14)
#define MIB_TR098_QOS_FLOW_POLICER			(MIB_TR098_QOS_FLOW_TBL_NUM+15)
#define MIB_TR098_QOS_FLOW_QUEUE			(MIB_TR098_QOS_FLOW_TBL_NUM+16)
#define MIB_TR098_QOS_FLOW_DSCPMARK			(MIB_TR098_QOS_FLOW_TBL_NUM+17)
#define MIB_TR098_QOS_FLOW_8021PMARK		(MIB_TR098_QOS_FLOW_TBL_NUM+18)
#define MIB_TR098_QOS_FLOW_ALIAS			(MIB_TR098_QOS_FLOW_TBL_NUM+19)
#define MIB_TR098_QOS_FLOW_INSTANCENUM		(MIB_TR098_QOS_FLOW_TBL_NUM+20)

//mark_qos
//policer
#define MIB_QOS_POLICER_TBL_NUM       		8300
#define MIB_QOS_POLICER_TBL           		((MIB_QOS_POLICER_TBL_NUM+1)|MIB_TABLE_LIST)
#define MIB_QOS_POLICER_ADD       			((MIB_QOS_POLICER_TBL_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_QOS_POLICER_DEL       			((MIB_QOS_POLICER_TBL_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_QOS_POLICER_MOD		  			((MIB_QOS_POLICER_TBL_NUM+3)|MIB_DEL_TBL_ENTRY | MIB_MOD_TBL_ENTRY)
#define MIB_QOS_POLICER_DELALL    			((MIB_QOS_POLICER_TBL_NUM+4)|MIB_DELALL_TBL_ENTRY)

#define MIB_QOSPOLICER_KEY                  8310
#define MIB_QOSPOLICER_ENABLE              	(MIB_QOSPOLICER_KEY+1)
#define MIB_QOSPOLICER_ALIAS               	(MIB_QOSPOLICER_KEY+2)
#define MIB_QOSPOLICER_COMMITTED_RATE    	(MIB_QOSPOLICER_KEY+3)
#define MIB_QOSPOLICER_COMMITTED_BURSTSIZE 	(MIB_QOSPOLICER_KEY+4)
#define MIB_QOSPOLICER_EXCESS_BURSTSIZE   	(MIB_QOSPOLICER_KEY+5)
#define MIB_QOSPOLICER_PEAKRATE           	(MIB_QOSPOLICER_KEY+6)
#define MIB_QOSPOLICER_PEAK_BURSTSIZE      	(MIB_QOSPOLICER_KEY+7)
#define MIB_QOSPOLICER_METERTYPE          	(MIB_QOSPOLICER_KEY+8)
#define MIB_QOSPOLICER_POSSIBLE_METERTYPE  	(MIB_QOSPOLICER_KEY+9)
#define MIB_QOSPOLICER_CONFORM_ACTION     	(MIB_QOSPOLICER_KEY+10)
#define MIB_QOSPOLICER_PARTIALCONFORM_ACTION	(MIB_QOSPOLICER_KEY+11)
#define MIB_QOSPOLICER_NONCONFORM_ACTION      	(MIB_QOSPOLICER_KEY+12)
#define  MIB_QOSPOLICER_INSTANCENUM 			(MIB_QOSPOLICER_KEY+13)
//queuestats
#define MIB_QOS_QUEUESTATS_TBL_NUM       	8330
#define MIB_QOS_QUEUESTATS_TBL           	((MIB_QOS_QUEUESTATS_TBL_NUM+1)|MIB_TABLE_LIST)
#define MIB_QOS_QUEUESTATS_ADD       		((MIB_QOS_QUEUESTATS_TBL_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_QOS_QUEUESTATS_DEL       		((MIB_QOS_QUEUESTATS_TBL_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_QOS_QUEUESTATS_MOD		 		((MIB_QOS_QUEUESTATS_TBL_NUM+3)|MIB_DEL_TBL_ENTRY | MIB_MOD_TBL_ENTRY)
#define MIB_QOS_QUEUESTATS_DELALL    		((MIB_QOS_QUEUESTATS_TBL_NUM+4)|MIB_DELALL_TBL_ENTRY)


#define MIB_QOSQUEUESTATS_INSTANCENUM     	8340
#define MIB_QOSQUEUESTATS_ENABLE          	(MIB_QOSQUEUESTATS_INSTANCENUM+1)
#define MIB_QOSQUEUESTATS_ALIAS            	(MIB_QOSQUEUESTATS_INSTANCENUM+2)
#define MIB_QOSQUEUESTATS_QUEUE            	(MIB_QOSQUEUESTATS_INSTANCENUM+3)
#define MIB_QOSQUEUESTATS_INTERFACE        	(MIB_QOSQUEUESTATS_INSTANCENUM+4)
#endif 
/* ==== Tr098 qos mib define end=====================*/

#ifdef CONFIG_APP_OPENVPN
#define MIB_OPENVPN_ENABLED	3530
#define MIB_OPENVPN_MODE		3531
#define MIB_OPENVPN_PORT		3532
#define MIB_OPENVPN_AUTH_TYPE 3533
#define MIB_OPENVPN_AUTH_NONE 3534
#endif

/* ==== multiple wan mib define start =====================*/
/*
	mib logical address range  using base addr plus offset.
*/
#ifdef RTK_REINIT_SUPPORT
#define MIB_STARTUP_TIMES	3999
#endif
#ifdef MULTI_WAN_SUPPORT
#define MIB_MULTIPLE_WAN_BASE  		4000	/*basic value for multiple wan*/
#define MIB_ID_BASIC_OFFSET 			0		/*basic mib offset*/
#define MIB_ID_WAN_OFFSET 				500		/*wan mib offset*/
#define MIB_ID_LAN_OFFSET 				800		/*lan mib offset*/
#define MIB_ID_WIFI_OFFSET 				1000		/*wifi mib offset*/
#define MIB_ID_TR069_OFFSET 			1500		/*tr069 mib offset*/
#define MIB_ID_IPV6_OFFSET 				2000	/*IPv6 mib offset*/
#define MIB_ID_STRUCT_OFFSET  			2500	/*struct mib offset*/

/*basic  mib define*/
#define MIB_BASIC_LOGICAL_ADDR	(MIB_MULTIPLE_WAN_BASE + MIB_ID_BASIC_OFFSET)
/*basic  mib define end */

/*wan mib define*/
#define MIB_WAN_LOGICAL_ADDR	(MIB_MULTIPLE_WAN_BASE + MIB_ID_WAN_OFFSET)
#define MIB_WANIFACE_IFINDEX				MIB_WAN_LOGICAL_ADDR + 1
#define MIB_WANIFACE_NAPT					MIB_WAN_LOGICAL_ADDR + 2
#define MIB_WANIFACE_CMODE					MIB_WAN_LOGICAL_ADDR + 3
#define MIB_WANIFACE_BRMODE					MIB_WAN_LOGICAL_ADDR + 4
#define MIB_WANIFACE_PPPUSERNAME			MIB_WAN_LOGICAL_ADDR + 5
#define MIB_WANIFACE_PPPPASSWD				MIB_WAN_LOGICAL_ADDR + 6
#define MIB_WANIFACE_PPPAUTH				MIB_WAN_LOGICAL_ADDR + 7
#define MIB_WANIFACE_PPPACNAME				MIB_WAN_LOGICAL_ADDR + 8
#define MIB_WANIFACE_PPPCTYPE				MIB_WAN_LOGICAL_ADDR + 9
#define MIB_WANIFACE_PPPIDLETIME			MIB_WAN_LOGICAL_ADDR + 10
#define MIB_WANIFACE_ENABLEQOS				MIB_WAN_LOGICAL_ADDR + 11
#define MIB_WANIFACE_ENABLEIGMP				MIB_WAN_LOGICAL_ADDR + 12
#define MIB_WANIFACE_ADDRESSTYPE			MIB_WAN_LOGICAL_ADDR + 13
#define MIB_WANIFACE_RIP					MIB_WAN_LOGICAL_ADDR + 14
#define MIB_WANIFACE_IPADDR					MIB_WAN_LOGICAL_ADDR + 15
#define MIB_WANIFACE_REMOTEIPADDR			MIB_WAN_LOGICAL_ADDR + 16
#define MIB_WANIFACE_DEFAULTGW				MIB_WAN_LOGICAL_ADDR + 17
#define MIB_WANIFACE_MTU					MIB_WAN_LOGICAL_ADDR + 18
#define MIB_WANIFACE_ENABLE					MIB_WAN_LOGICAL_ADDR + 19
#define MIB_WANIFACE_NETMASK				MIB_WAN_LOGICAL_ADDR + 20
#define MIB_WANIFACE_IPUNNUMBERED			MIB_WAN_LOGICAL_ADDR + 21
#define MIB_WANIFACE_VLAN					MIB_WAN_LOGICAL_ADDR + 22
#define MIB_WANIFACE_VLANID					MIB_WAN_LOGICAL_ADDR + 23
#define MIB_WANIFACE_VPRIORITY				MIB_WAN_LOGICAL_ADDR + 24
#define MIB_WANIFACE_LANDEV_INSTNUM			MIB_WAN_LOGICAL_ADDR + 25
#define MIB_WANIFACE_ITFGROUP				MIB_WAN_LOGICAL_ADDR + 26
#define MIB_WANIFACE_CPEPPPIFINDEX			MIB_WAN_LOGICAL_ADDR + 27
#define MIB_WANIFACE_CPEIPINDEX				MIB_WAN_LOGICAL_ADDR + 28
#define MIB_WANIFACE_CONNDISABLE			MIB_WAN_LOGICAL_ADDR + 29
#define MIB_WANIFACE_TR069_CONDEVINSTNUM	MIB_WAN_LOGICAL_ADDR + 30
#define MIB_WANIFACE_TR069_CONIPINSTNUM		MIB_WAN_LOGICAL_ADDR + 31
#define MIB_WANIFACE_TR069_CONPPPINSTNUM	MIB_WAN_LOGICAL_ADDR + 32
#define MIB_WANIFACE_TR069_AUTODISTIME		MIB_WAN_LOGICAL_ADDR + 33
#define MIB_WANIFACE_TR069_WARNDISDELAY		MIB_WAN_LOGICAL_ADDR + 34
#define MIB_WANIFACE_PPPSERVICENAME			MIB_WAN_LOGICAL_ADDR + 35
#define MIB_WANIFACE_WANNAME				MIB_WAN_LOGICAL_ADDR + 36
#define MIB_WANIFACE_TR069_TR143UDPECHOITF	MIB_WAN_LOGICAL_ADDR + 37
#define MIB_WANIFACE_PPPOEPROXYENABLE		MIB_WAN_LOGICAL_ADDR + 38
#define MIB_WANIFACE_PPPOEPROXYMAXUSER		MIB_WAN_LOGICAL_ADDR + 39
#define MIB_WANIFACE_SERVICELIST			MIB_WAN_LOGICAL_ADDR + 40
#define MIB_WANIFACE_APPLICATIONTYPE		MIB_WAN_LOGICAL_ADDR + 41
#define MIB_WANIFACE_DISABLELANDHCP			MIB_WAN_LOGICAL_ADDR + 42
#define MIB_WANIFACE_SVTYPE					MIB_WAN_LOGICAL_ADDR + 43
#define MIB_WANIFACE_PPPIP					MIB_WAN_LOGICAL_ADDR + 44
#define MIB_WANIFACE_IPPROTOCOL				MIB_WAN_LOGICAL_ADDR + 45
#define MIB_WANIFACE_IPV6_ADDRMODE			MIB_WAN_LOGICAL_ADDR + 46
#define MIB_WANIFACE_IPV6_IPV6ADDR			MIB_WAN_LOGICAL_ADDR + 47
#define MIB_WANIFACE_IPV6_REMOTEIPV6ADDR	MIB_WAN_LOGICAL_ADDR + 48
#define MIB_WANIFACE_IPV6_IPV6ADDRPREFIXLEN	MIB_WAN_LOGICAL_ADDR + 49
#define MIB_WANIFACE_IPV6_IPV6DHCP			MIB_WAN_LOGICAL_ADDR + 50
#define MIB_WANIFACE_IPV6_IPV6DHCPREQUEST	MIB_WAN_LOGICAL_ADDR + 51
#define MIB_WANIFACE_IPV6_REMOTEIPV6ENDPOINTADDR	MIB_WAN_LOGICAL_ADDR + 52
#define MIB_WANIFACE_BR_ROUTE_FLAG			MIB_WAN_LOGICAL_ADDR + 53
#define MIB_WANIFACE_ENABLELANDHCP			MIB_WAN_LOGICAL_ADDR + 54
#define MIB_WANIFACE_MULTICAST_VLAN			MIB_WAN_LOGICAL_ADDR + 55
#define MIB_WANIFACE_DHCP_HOSTNAME			MIB_WAN_LOGICAL_ADDR + 56
#define MIB_WANIFACE_STATIC_IP_MTU			MIB_WAN_LOGICAL_ADDR + 57
#define MIB_WANIFACE_DHCP_MTU				MIB_WAN_LOGICAL_ADDR + 58
#define MIB_WANIFACE_PPPOE_MTU				MIB_WAN_LOGICAL_ADDR + 59
#define MIB_WANIFACE_DNS_AUTO				MIB_WAN_LOGICAL_ADDR + 60
#define MIB_WANIFACE_DNS1					MIB_WAN_LOGICAL_ADDR + 61
#define MIB_WANIFACE_DNS2					MIB_WAN_LOGICAL_ADDR + 62
#define MIB_WANIFACE_DNS3					MIB_WAN_LOGICAL_ADDR + 63
#define MIB_WANIFACE_PPPCSTATUS				MIB_WAN_LOGICAL_ADDR + 64
#define MIB_WANIFACE_MAC_ADDR				MIB_WAN_LOGICAL_ADDR + 65

#define MIB_WANIFACE_CURRENT_IDX 			MIB_WAN_LOGICAL_ADDR + 66
#define MIB_WANIFACE_BINDING_LAN_PORTS		MIB_WAN_LOGICAL_ADDR + 67
#define MIB_WANIFACE_ENABLEUPNP				MIB_WAN_LOGICAL_ADDR + 68

#define MIB_WANIFACE_L2TP_IP_ADDR			MIB_WAN_LOGICAL_ADDR + 69
#define MIB_WANIFACE_L2TP_SUBNET_MASK		MIB_WAN_LOGICAL_ADDR + 70
#define MIB_WANIFACE_L2TP_SERVER_IP_ADDR	MIB_WAN_LOGICAL_ADDR + 71
#define MIB_WANIFACE_L2TP_GATEWAY			MIB_WAN_LOGICAL_ADDR + 72
#define MIB_WANIFACE_L2TP_USER_NAME			MIB_WAN_LOGICAL_ADDR + 73
#define MIB_WANIFACE_L2TP_PASSWORD			MIB_WAN_LOGICAL_ADDR + 74
#define MIB_WANIFACE_L2TP_MTU_SIZE			MIB_WAN_LOGICAL_ADDR + 75
#define MIB_WANIFACE_L2TP_IDLE_TIME			MIB_WAN_LOGICAL_ADDR + 76
#define MIB_WANIFACE_L2TP_CONNECTION_TYPE	MIB_WAN_LOGICAL_ADDR + 77

#define MIB_WANIFACE_PPTP_IP_ADDR			MIB_WAN_LOGICAL_ADDR + 78
#define MIB_WANIFACE_PPTP_SUBNET_MASK		MIB_WAN_LOGICAL_ADDR + 79
#define MIB_WANIFACE_PPTP_SERVER_IP_ADDR	MIB_WAN_LOGICAL_ADDR + 80
#define MIB_WANIFACE_PPTP_GATEWAY			MIB_WAN_LOGICAL_ADDR + 81
#define MIB_WANIFACE_PPTP_USER_NAME			MIB_WAN_LOGICAL_ADDR + 82
#define MIB_WANIFACE_PPTP_PASSWORD			MIB_WAN_LOGICAL_ADDR + 83
#define MIB_WANIFACE_PPTP_MTU_SIZE			MIB_WAN_LOGICAL_ADDR + 84
#define MIB_WANIFACE_PPTP_IDLE_TIME			MIB_WAN_LOGICAL_ADDR + 85
#define MIB_WANIFACE_PPTP_CONNECTION_TYPE	MIB_WAN_LOGICAL_ADDR + 86
#define MIB_WANIFACE_PPTP_SECURITY_ENABLED		MIB_WAN_LOGICAL_ADDR + 87
#define MIB_WANIFACE_PPTP_MPPC_ENABLED			MIB_WAN_LOGICAL_ADDR + 88

#ifdef CONFIG_ISP_IGMPPROXY_MULTIWAN
#define MIB_WANIFACE_ON_PHYIF				MIB_WAN_LOGICAL_ADDR + 89
#endif

/*wan mib define end */

/*lan  mib define*/
#define MIB_LAN_LOGICAL_ADDR		(MIB_MULTIPLE_WAN_BASE + MIB_ID_LAN_OFFSET)
/*lan  mib define end */

/*wifi mib define*/
#define MIB_WIFI_LOGICAL_ADDR		(MIB_MULTIPLE_WAN_BASE + MIB_ID_WIFI_OFFSET)
/*wifi mib  define end */

/*tr069 mib define*/
#define MIB_TR069_LOGICAL_ADDR		(MIB_MULTIPLE_WAN_BASE + MIB_ID_TR069_OFFSET)
/*tr069 mib  define end */

/*IPv6 mib define*/
#define MIB_IPV6_LOGICAL_ADDR		(MIB_MULTIPLE_WAN_BASE + MIB_ID_IPV6_OFFSET)
#define MIB_WANIFACE_IPV6_ENABLE		MIB_IPV6_LOGICAL_ADDR + 1
/*IPv6 mib define end */


/*struct mib define*/
#define MIB_STRUCT_LOGICAL_ADDR	(MIB_MULTIPLE_WAN_BASE + MIB_ID_STRUCT_OFFSET)

/* struct define */
#define MIB_WANIFACE_ENABLED	MIB_STRUCT_LOGICAL_ADDR +1
#define MIB_WANIFACE_TBL_NUM	MIB_STRUCT_LOGICAL_ADDR + 2
#define MIB_WANIFACE_TBL		((MIB_WANIFACE_TBL_NUM+1)|MIB_TABLE_LIST)
#define MIB_WANIFACE_ADD		((MIB_WANIFACE_TBL_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_WANIFACE_DEL		((MIB_WANIFACE_TBL_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_WANIFACE_MOD		((MIB_WANIFACE_TBL_NUM+3)|MIB_DEL_TBL_ENTRY | MIB_MOD_TBL_ENTRY)
#define MIB_WANIFACE_DELALL		((MIB_WANIFACE_TBL_NUM+4)|MIB_DELALL_TBL_ENTRY)
/*struct define  end*/

/*struct mib  define end */
#endif
/* ==== multiple wan mib define end =====================*/


/* ==== multiple wan type/macro  define start =====================*/
#ifdef MULTI_WAN_SUPPORT

#define MAX_WANIFACE_NUM				8  

#if !defined(SINGLE_WAN_SUPPORT)
#define WANIFACE_NUM 4			
#else
#define WANIFACE_NUM 1
#endif

#define WAN_INTERFACE_LAN_PORT_NUM 4
#define WAN_INTERFACE_WLAN_PORT_NUM 10
#define WLAN0_SSID_NUM 5
#define WLAN1_SSID_NUM 5
#define MULTI_BRNAME_FORMAT "br%d"
#define WAN_IFNAME_FORMAT "eth1.%d"
#define LAN_BRNAME_FORMAT "br%d"

#define ETH_IF_NUM 5+WANIFACE_NUM  //eth0,2,3,4,1 eth1.1 ...
#define WLAN_IF_NUM 1+NUM_VWLAN+1+1+MAX_WDS_NUM
//root+vap+vxd+mesh+wds
#define ALL_IF_NUM ETH_IF_NUM+WLAN_IF_NUM*NUM_WLAN_INTERFACE
typedef enum IF_INDEX_
{
	IF_ETH0_IDX=0,
	IF_ETH2_IDX,
	IF_ETH3_IDX,
	IF_ETH4_IDX,
	IF_ETH1_IDX,
	IF_ETH1_1_IDX,
	//should be eth1.x, total WANIFACE_NUM
	
	IF_WLAN0_IDX=ETH_IF_NUM,
	//..... should be wlan0 vap index, total NUM_VWLAN
	IF_WLAN0_VXD_IDX=ETH_IF_NUM+NUM_VWLAN+1,
	//... should be wlan0 mesh and wds	
	
	IF_WLAN1_IDX=ETH_IF_NUM+WLAN_IF_NUM,	
	// wlan1 vaps 
	IF_WLAN1_VXD_IDX=ETH_IF_NUM+WLAN_IF_NUM+NUM_VWLAN+1,
	//wlan1 mesh and wds
	
	IF_IDX_END=ALL_IF_NUM
} IF_INDEX_T;

typedef enum IF_TYPE_
{
	IF_TYPE_DISABLED=0,
	IF_TYPE_LAN,
	IF_TYPE_WAN,
	IF_TYPE_NOTSUPPORT
} IF_TYPE_T;

typedef enum WanIntfacesType_
{
	NO_WAN=0,
	WAN1,
	WAN2,
	WAN3,
	WAN4
} WanIntfacesType;
typedef enum { WAN_ID1=1, WAN_ID2=2,WAN_ID3=3,WAN_ID4=4,WAN_ID_ROOT=5 } WANID_T;
typedef enum IP_PROTOCOL_MODE_T_
{
	IP_PROTOCOL_MODE_IPV4=0,
	IP_PROTOCOL_MODE_IPV6=1,
	IP_PROTOCOL_MODE_BOTH=2
} IP_PROTOCOL_MODE_T;


#define X_CT_SRV_TR069		0x01
#define X_CT_SRV_INTERNET	0x02
#define X_CT_SRV_OTHER		0x04
#define X_CT_SRV_VOICE		0x08

#define _PRMT_X_CT_EXT_ENABLE_
#if defined(_PRMT_X_CT_EXT_ENABLE_)


typedef enum { NO_REQUEST = 0, REQUEST_BREAK = 1, REQUEST_SUCCESS = 2 } REQUEST_STATUS;
typedef enum { NO_SET = 99, NOW_SETTING = 0, SET_SUCCESS = 1, SET_FAULT = 2 } REMOTE_SET_STATUS;
typedef enum { PING_ENABLED = 0, PING_RUNNING = 1, PING_STOPPED = 2} PINGCONFIG_STATE;

#define NEW_SETTING "/var/newsetting"
#define PVC_FILE "/var/pvc_file"
#define SSID_FILE "/var/ssid_file"
#define USERLIMIT_FILE "/var/userlimit_file"
#define QOS_FILE "/var/qos_file"
#define REBOOT_DELAY_FILE "/var/rebootdelay"
#define REMOTE_SETSAVE_FILE "/var/config/remote_save"
#define CONNREQ_STATUS_FILE "/var/connreq_status"
#define INFORM_STATUS_FILE "/var/inform_status"

#define CONFIG_BOA_WEB_E8B_CH		1

#define CONFIG_ETHWAN				1
#define CONFIG_EPONWAN				1
#define BR_ROUTE_ONEPVC				1 //set bridge and route connection on one vlanid
#define _PRMT_USBRESTORE            	1
#endif

#if !defined(CONFIG_APP_TR069)
#define MIB_WLAN_ACK_TIMEOUT	686
#define BRIDGE_ETHERNET		0
#define BRIDGE_PPPOE		1
#define BRIDGE_DISABLE		2
#define MAX_VC_NUM					8
#define MAX_PPP_NUM					8
#define PHY_INTF(x)				(x | 0xff00)/*physical interface*/
#define VC_INDEX(x)				(x & 0x0ff)
#define ETH_INDEX(x)				(x & 0x0ff)
#define PPP_INDEX(x)				((x  >> 8) & 0x0ff)
#define MEDIA_INDEX(x)				((x >> 16) & 0x0ff)
#define TO_IFINDEX(x,y,z)			((x<<16) | (y<<8) | z)
#define DUMMY_VC_INDEX				0xff
#define DUMMY_PPP_INDEX				0xff
#define DUMMY_IFINDEX				0xffff
#define NA_PPP			0xefff
#define NA_VC			0xffff
#define MAX_POE_PER_VC		5
#define STR_LEN_64    64

typedef enum { MEDIA_ATM, MEDIA_ETH } MEDIA_TYPE_T;
typedef enum { APPTYPE_TR069_INTERNET, APPTYPE_INTERNET, APPTYPE_TR069,
		 APPTYPE_OTHER, APPTYPE_VOICE, APPTYPE_TR069_VOICE,
		 APPTYPE_VOICE_INTERNET, APPTYPE_TR069_VOICE_INTERNET } APPTYPE_T;
typedef enum { PPP_AUTH_AUTO=0, PPP_AUTH_PAP, PPP_AUTH_CHAP, PPP_AUTH_NONE } PPP_AUTH_T;
#endif
#endif
/* ==== multiple wan type/macro define end  =====================*/
// WNC MIB ID are defined here
/* WNC-MR1524-JOE-PENG-20120308-Implement NEC PPP Keep Alive */
#if defined(CONFIG_WNC_NEC_PPP_KEEP_ALIVE)
#define MIB_PPP_KEEP_ALIVE_ENABLED     16000
#endif
/* WNC-MR1524-JOE-PENG-20120308-end */
/* WNC-MR1530-Yuan-I-Chou-20120327-Add HW MIB */
// NEC Random Key and Config ID
#define MIB_HW_RANDOM_KEY		16100
#define MIB_HW_CONFIG_ID		16101
// Product name
#define MIB_HW_PRODUCT_NAME		16102
// SN
#define MIB_HW_SN				16103
// Telnet daemon state
#define MIB_HW_TELNETS_ENABLED	16104
// Factory default flag
#define MIB_HW_DEFAULT_STATE	16105
// NEC original function FLAG
#define MIB_HW_CMNSEC_VALUE		16106
// NEC emergency bank check
//#define MIB_HW_EMERGENCY_BANK_CHECK	16107
/* WNC-MR1530-Yuan-I-Chou-20120327-End */

/* WNC-NMR0000-HENG-I-Chen-20130712-Add HW MIB MP_OPMODE for MP test of Pocket */
#define MIB_HW_MP_OPMODE		16108
/* WNC-NMR0000-HENG-I-Chen-20130712-End */

//WNC-NMRXXXX-D2R030-YUAN-I-CHOU-20151220, Spider sensor support MIB
#define MIB_HW_SENSOR_SUPPORTED						16109

#if 1	/* WNC-NMR0000-[Alicia]-Libera-20190812-New SSID generation modification-start */
#define MIB_HW_2G_PRI_SSID		16110
#define MIB_HW_2G_SEC_SSID		16111
#define MIB_HW_5G_PRI_SSID		16112
#define MIB_HW_5G_SEC_SSID		16113
#define MIB_HW_PRI_ENC_KEY		16114
#define MIB_HW_SEC_ENC_KEY		16115
#define MIB_HW_WEB_PW			16116
#define MIB_HW_WPS_PIN_CODE		16117
#endif /* WNC-NMR0000-[Alicia]-Libera-20190812-New SSID generation modification-end */

/* WNC-MR1530-Yuan-I-Chou-20120328-Add netBIOS name */
// NetBIOS device name
#define MIB_NETBIOS_NAME		16200

//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140320, Replace HW_DEFAULT_STATE to DEFAULT_STATE
// Factory default flag
#define MIB_DEFAULT_STATE		16210

//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140516, Add EEE, JUMBO frame, PAUSE frame MIB
// EEE function
#define MIB_EEE_STATE			16220
// Pause frame support
#define MIB_PAUSE_FRAME_STATE	16221
// Jumbo frame support
#define MIB_JUMBO_FRAME_STATE	16222
//WNC-NMR822849-JDR230-YUAN-I-CHOU-20141123, Add IGMP/MLD snooping enable/disable function
#define MIB_IGMP_SNOOP_DISABLED	16223
#define MIB_MLD_SNOOP_DISABLED	16224
//WNC-NMR822849-JDR230-YUAN-I-CHOU-20141123, Add IGMP/MLD snooping enable/disable function End
/* WNC-NMR0000-JOE-PENG-20170719-Implement flash MIB, default value and system init related of Aero-G IGMP function */
#define MIB_IGMP_MAX_REG_NUMBER					16225
#define MIB_IGMP_COMPATIBILITY_ENABLED			16226
#define MIB_IGMP_ROBUST_VARIABLE				16227
#define MIB_IGMP_QUERY_INTERVAL					16228
#define MIB_IGMP_QUERY_RESPONSE_INTERVAL		16229
#define MIB_IGMP_STARTUP_QUERY_INTERVAL			16230
#define MIB_IGMP_LAST_MEMBER_QUERY_INTERVAL		16231
#define MIB_IGMP_UNSOLICITED_REPORT_INTERVAL	16232
/* WNC-NMR0000-JOE-PENG-20170719-Implement flash MIB, default value and system init related of Aero-G IGMP function */

#ifdef WIFI_SIMPLE_CONFIG
// WPS type (rakuraku or WPS or both)
#define MIB_WLAN_WSC_TYPE		16300
//WNC-NMRXXX-JDR230-Yuan-I-Chou-20140527-Add WSC priority
// WPS priority (2.4G or 5G)
#define MIB_WLAN_WSC_PRIORITY	16301
#endif
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140516, Add Rakuraku only MIB for Change secondary SSID behavior
// Raku only MIB
#define MIB_WLAN_RAKURAKU_ONLY		16310

//WNC-NMRXXX-JDR230-Yuan-I-Chou-20140527-Add TV mode support
#define MIB_WLAN_TVMODE_SUPPORT		16311

//WNC-NMRXXX-JDR230-Yuan-I-Chou-20140527-Add Multicast forwarding control
#define MIB_WLAN_MC_FORWARD_TYPE	16312

/* WNC-NMR000-[Linear]-Libera-20140807- SPEC: Repeater mode - Step2 - Add 5GHZ_SCAN_INTERVAL MIB*/
#define MIB_WLAN_SCAN_5GHZ_INTERVAL 16313

/* WNC-NMR000-[Linear]-Libera-20140807- SPEC: Repeater mode - Step2 - Add PASSIVE_SCAN_PER_CHANNEL MIB*/
#define MIB_WLAN_PASSIVE_SCAN_PER_CHANNEL 16314

/* WNC-MR1527-Heng-I-Chen-20120330-Add NetChk MIB */
// NEC Internet Reachability Check flag
#define MIB_NETCHK				16400
/* WNC-MR1527-Heng-I-Chen-20120330-End */

/* WNC-NMR0000-JOE-PENG-20140925-Implement SSDP Reflector Prevention */
/* Implement "Source Address Validation" in router mode */
#define MIB_SRC_ADDR_CHECK		16401

/* NMR0000-20160726-Implement responsive GUI page of Aero model-start */
#define MIB_TCP_TIME_OUT		16402
#define MIB_UDP_TIME_OUT		16403
#define MIB_WEB_WAN_ACCESS_SRC_ANY_ENABLED		16404
#define MIB_WEB_WAN_ACCESS_SRC_IP_ADDR			16405
#define MIB_WEB_WAN_ACCESS_SRC_SUBNET_MASK		16406
/* NMR0000-20160726-Implement responsive GUI page of Aero model-end */
/* WNC-MR0000-David@D2R032-20160720-Modification for NEC Aero, Start */
#define MIB_MANUAL_GATEWAY_ENABLED			16407
/* WNC-MR0000-David@D2R032-20160720-Modification for NEC Aero, End */
/* NMR1273-20161005-Fix bug 1081 and 1273 on Aero model-start */
#define MIB_WAN_DHCP_OLD			16408
/* NMR1273-20161005-Fix bug 1081 and 1273 on Aero model-end */

/* WNC-MR0000-Libera-20130301-Add WLAN_WSC_BAND_SEL MIB */
// Sonic needs this flag for rakuraku/WPS to identify radio
#define MIB_WLAN_WSC_BAND_SEL				16450
/* WNC-MR0000-Libera-20130301-End */

/* WNC-NMR000-[Aero/Thalys]-Libera-20160606- responsive GUI porting: Band steering-start */
#define MIB_WLAN_BAND_STEER 	16476
#define MIB_WLAN_COPY_5GTO2G	16477
#define MIB_WLAN_SSID_BAK		16478
#define MIB_WLAN_ENCRYPT_BAK	16479
#define MIB_WLAN_WPA_PSK_BAK	16480
#define MIB_WLAN_WPA_GROUP_REKEY_TIME_BAK	16481
#define MIB_WLAN_BLOCK_RELAY_BAK			16482
#define MIB_WLAN_HIDDEN_SSID_BAK			16483
#define MIB_WLAN_MACAC_ENABLED_BAK			16484
#define MIB_WLAN_WPA_CIPHER_SUITE_BAK		16485	/* WNC-NMR000-[Aero/Thalys]-Libera-20160803- Taking over setting value_+bandsteering */
#define MIB_WLAN_WPA2_CIPHER_SUITE_BAK		16486	/* WNC-NMR000-[Aero/Thalys]-Libera-20160803- Taking over setting value_+bandsteering */
/* WNC-NMR000-[Aero/Thalys]-Libera-20160606- responsive GUI porting: Band steering-end */

/* WNC-NMR0000-Libera-20171103 - MAP-E MTD partition-start */
#define JFFS2_MTD		("/dev/mtdblock2")
/* WNC-NMR0000-Libera-20171103 - MAP-E MTD partition-end */


#ifdef CONFIG_APP_AUTOCH2
#define MIB_AUTOCH2_ENABLE	16490
#endif

/* WNC-MRXXXX-Yuan-I-Chou-20120418-Add FW upgrade MIB */
#define MIB_FW_URL				16500
#define MIB_FW_VERSION			16501
#define MIB_AIM_URL				16502
#define MIB_MAINTE_VUP			16503
/* WNC-MRXXXX-Yuan-I-Chou-20120418-End */

//WNC-NMR00000-D2R031-HENG-I-CHEN-20160114: Add GUI expire time setting #BEGIN
#define MIB_GUI_EXPIRE_TIME		16520
//WNC-NMR00000-D2R031-HENG-I-CHEN-20160114: Add GUI expire time setting #END

/* WNC-MRXXXX-Yuan-I-Chou-20120514-Separate operation mode MIB */
//Router, Gateway mode
#define MIB_RT_IP_ADDR				16600
#define MIB_RT_SUBNET_MASK			16601
#define MIB_RT_DEFAULT_GATEWAY		16602
#define MIB_RT_DNS1					16603
#define MIB_RT_DNS2					16604
#define MIB_RT_DNS_MODE				16605
/* WNC-NMR0000-JOE-PENG-20140805-Fix bug DUT does not save LAN setting after user change LAN setting and change OP mode between bridge and converter mode */
#define MIB_RT_DHCP					16606
/* WNC-MR0000-JOE-PENG-20130730-Add MIB to record DHCP server range and lease time of router mode->start */
#define MIB_RT_DHCP_CLIENT_START	16607
#define MIB_RT_DHCP_CLIENT_END		16608
#define MIB_RT_DHCP_LEASE_TIME		16609
/* WNC-MR0000-JOE-PENG-20130730-Add MIB to record DHCP server range and lease time of router mode->end */
//WNC-NMR822849-JDR230-YUAN-I-CHOU-20141123, Add IGMP/MLD snooping enable/disable function
#define MIB_RT_IGMP_SNOOP_DISABLED	16610
#define MIB_RT_MLD_SNOOP_DISABLED	16611
//WNC-NMR822849-JDR230-YUAN-I-CHOU-20141123, Add IGMP/MLD snooping enable/disable function End

//AP, Bridge mode
#define MIB_AP_IP_ADDR				16700
#define MIB_AP_SUBNET_MASK			16701
#define MIB_AP_DEFAULT_GATEWAY		16702
#define MIB_AP_DNS1					16703
#define MIB_AP_DNS2					16704
#define MIB_AP_DNS_MODE				16705
/* WNC-MR0000-JOE-PENG-20130730-Add MIB_AP_DHCP */
#define MIB_AP_DHCP					16706
//WNC-NMR822849-JDR230-YUAN-I-CHOU-20141123, Add IGMP/MLD snooping enable/disable function
#define MIB_AP_IGMP_SNOOP_DISABLED	16710
#define MIB_AP_MLD_SNOOP_DISABLED	16711
//WNC-NMR822849-JDR230-YUAN-I-CHOU-20141123, Add IGMP/MLD snooping enable/disable function End

//CNV/RPT mode
#define MIB_CNV_IP_ADDR				16750
#define MIB_CNV_SUBNET_MASK			16751
#define MIB_CNV_DEFAULT_GATEWAY		16752
#define MIB_CNV_DNS1				16753
#define MIB_CNV_DNS2				16754
#define MIB_CNV_DNS_MODE			16755
/* WNC-NMR0000-JOE-PENG-20140610-Fix bug "In converter mode, user could not change LAN setting to static IP mode" */
#define MIB_CNV_DHCP				16756
//WNC-NMR822849-JDR230-YUAN-I-CHOU-20141123, Add IGMP/MLD snooping enable/disable function
#define MIB_CNV_IGMP_SNOOP_DISABLED	16760
#define MIB_CNV_MLD_SNOOP_DISABLED	16761
//WNC-NMR822849-JDR230-YUAN-I-CHOU-20141123, Add IGMP/MLD snooping enable/disable function End

/* WNC-MRXXXX-Yuan-I-Chou-20120514-End */

/* WNC-NMR0000-Heng-I-Chen-20130709-Add IS_SET_CONNECT MIB */
// NEC wlan profile set flag
#define MIB_IS_SET_CONNECT			16800
/* WNC-NMR0000-Heng-I-Chen-20130709-End */

/* WNC-MR0000-JOE-PENG-20130717-Implement 4.4.32 RakuRaku QR according to spec. 1.4.0->start */
/* Add QR_SERVER_URL MIB */
#define MIB_QR_SERVER_URL			16801
/* WNC-MR0000-JOE-PENG-20130717-Implement 4.4.32 RakuRaku QR according to spec. 1.4.0->end */

/* WNC-NMR0000-JOE-PENG-20131127-Implement section 5.23.4.4 Aterm-HTTP interface->start */
/* Add NEC_ACCESS_TIMER_SUPPORTED MIB */
#define MIB_NEC_ACCESS_TIMER_SUPPORTED			16802
/* WNC-NMR0000-JOE-PENG-20131127-Implement section 5.23.4.4 Aterm-HTTP interface->end */
//WNC-NMRXXXX-D2R030-YUAN-I-CHOU-20151220, Spider new NEC MIB
#define MIB_NEC_MAC_ADDRESS_FILTERING_ENTRY			16803
#define MIB_NEC_AIM_ACCESS_AFTER_INITIALIZATION		16804
//WNC-NMRXXXX-D2R030-YUAN-I-CHOU-20151220, Spider new NEC MIB End

/* WNC-NMR0000-JOE-PENG-20151125-Implement sensor related GUI page of spider model-start */
/* Add SENSOR_NOTIFY_SENSITIVITY MIB */
#define MIB_SENSOR_NOTIFY_SENSITIVITY			16805

/* Add SENSOR_LIGHT related MIB */
#define MIB_SENSOR_LIGHT_ENABLE				16806
#define MIB_SENSOR_LIGHT_COLOR				16807
#define MIB_SENSOR_LIGHT_ILLUMINANCE			16808
#define MIB_SENSOR_LIGHT_SENSITIVITY			16809
#define MIB_SENSOR_LIGHT_START_TIME_HOUR		16810
#define MIB_SENSOR_LIGHT_START_TIME_MIN			16811
#define MIB_SENSOR_LIGHT_END_TIME_HOUR			16812
#define MIB_SENSOR_LIGHT_END_TIME_MIN			16813
/* WNC-NMR0000-JOE-PENG-20151125-Implement sensor related GUI page of spider model-end */

/* WNC-NMR0000-MIKE-YEH-20160111-Implement LED mode control related GUI page of spider model-start */
#define MIB_LED_LIGHT_MODE						16814
/* WNC-NMR0000-MIKE-YEH-20160111-Implement LED mode control related GUI page of spider model-end */

/* WNC-NMR0000-MIKE-YEH-20160111-Implement client ACL related GUI page of spider model-start */
#define MIB_CLIENT_ACL_MODE						16815
/* WNC-NMR0000-MIKE-YEH-20160111-Implement client ACL related GUI page of spider model-end */

/* WNC-NMR0000-MIKE-YEH-20160111-Implement DHCP client gateway enable related GUI page of spider model-start */
#define MIB_DHCP_CLIENT_GW_ENABLE				16816
/* WNC-NMR0000-MIKE-YEH-20160111-Implement DHCP client gateway enable related GUI page of spider model-end */

/* WNC-NMR0000-MIKE-YEH-20160111-Implement DHCP client DNS enable related GUI page of spider model-start */
#define MIB_DHCP_CLIENT_DNS_ENABLE				16817
/* WNC-NMR0000-MIKE-YEH-20160111-Implement DHCP client DNS enable related GUI page of spider model-end */
/* NMR0000-20160204-Fix bug number 16 "The status of detail screen isn't kept after another screen is displayed" in Firmware NEC check 20160201.xlsx-start */
#define MIB_ADVANCED_MENU_ENABLE				16818
/* NMR0000-20160204-Fix bug number 16 "The status of detail screen isn't kept after another screen is displayed" in Firmware NEC check 20160201.xlsx-end */

#ifdef CONFIG_APP_ACCESSTIMER
// WNC-NMR0000-JDR230-HENG-I-CHEN-2014-01-05: Implement Access Timer feature #BEGIN
#define MIB_ACCESS_TIMER_ENABLED	16900
#define MIB_ACCESS_TIMER_TBL_NUM	16901
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-01-12: fix MIB ID of Access Timer feature #BEGIN
#define MIB_ACCESS_TIMER_TBL		((MIB_ACCESS_TIMER_TBL_NUM+1)|MIB_TABLE_LIST)
#define MIB_ACCESS_TIMER_ADD		((MIB_ACCESS_TIMER_TBL_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_ACCESS_TIMER_DEL		((MIB_ACCESS_TIMER_TBL_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_ACCESS_TIMER_DELALL		((MIB_ACCESS_TIMER_TBL_NUM+4)|MIB_DELALL_TBL_ENTRY)
#define MIB_ACCESS_TIMER_MACADDR	16907
#define MIB_ACCESS_TIMER_CATEGORY	16908
#define MIB_ACCESS_TIMER_NAME		16909
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-01-12: fix MIB ID of Access Timer feature #END
#define MIB_ACCESS_TIMER_SUN		16910
#define MIB_ACCESS_TIMER_MON		16911
#define MIB_ACCESS_TIMER_TUE		16912
#define MIB_ACCESS_TIMER_WED		16913
#define MIB_ACCESS_TIMER_THU		16914
#define MIB_ACCESS_TIMER_FRI		16915
#define MIB_ACCESS_TIMER_SAT		16916
#define MIB_ACCESS_TIMER_TMP		16917
#define MIB_ACCESS_TIMER_TMPDAY		16918
// WNC-NMR0000-JDR230-HENG-I-CHEN-2014-01-05: Implement Access Timer feature #END
#endif	//#ifdef CONFIG_APP_ACCESSTIMER

// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #BEGIN
// WNC-NMR00000-D2R031-HENG-I-CHEN-2015-12-11: Implement Iniquitous Client feature #BEGIN
#ifdef CONFIG_APP_INIQUITOUS_CLIENT
#define MIB_INIQUITOUS_STA_TBL_NUM	17000
#define MIB_INIQUITOUS_STA_TBL		((MIB_INIQUITOUS_STA_TBL_NUM+1)|MIB_TABLE_LIST)
#define MIB_INIQUITOUS_STA_ADD		((MIB_INIQUITOUS_STA_TBL_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_INIQUITOUS_STA_DEL		((MIB_INIQUITOUS_STA_TBL_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_INIQUITOUS_STA_DELALL		((MIB_INIQUITOUS_STA_TBL_NUM+4)|MIB_DELALL_TBL_ENTRY)
#define MIB_INIQUITOUS_STA_MACADDR	17005
#define MIB_INIQUITOUS_STA_NAME		17006
#endif	//##ifdef CONFIG_APP_INIQUITOUS_CLIENT
// WNC-NMR00000-D2R031-HENG-I-CHEN-2015-12-11: Implement Iniquitous Client feature #END
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #END


/* WNC-NMR0000-MIKE-YEH-20160812-Implement user defined wan ip */
#define MIB_WAN_ADDR_USER_DEF				17100
#define MIB_WAN_GATEWAY_ADDR_USER_DEF		17101
#define MIB_WAN_DNS_ADDR_USER_DEF			17102

//Please refer above above above..... for this MIB value
//#define MIB_CUSTOM_PASSTHRU_ENABLED			17200

#if 1 /* WNC-NMR0000-Jog-20160801, IPv4 packet filter */
#define MIB_PACKETFILTERWAN_ENABLED	18000
#define MIB_PACKETFILTERWAN_TBL_NUM	18001
#define MIB_PACKETFILTERWAN_TBL			((MIB_PACKETFILTERWAN_TBL_NUM+1)|MIB_TABLE_LIST)
#define MIB_PACKETFILTERWAN_ADD		((MIB_PACKETFILTERWAN_TBL_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_PACKETFILTERWAN_DEL			((MIB_PACKETFILTERWAN_TBL_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_PACKETFILTERWAN_DELALL		((MIB_PACKETFILTERWAN_TBL_NUM+4)|MIB_DELALL_TBL_ENTRY)
#define MIB_PACKETFILTERLAN_ENABLED		18010
#define MIB_PACKETFILTERLAN_TBL_NUM		18011
#define MIB_PACKETFILTERLAN_TBL			((MIB_PACKETFILTERLAN_TBL_NUM+1)|MIB_TABLE_LIST)
#define MIB_PACKETFILTERLAN_ADD			((MIB_PACKETFILTERLAN_TBL_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_PACKETFILTERLAN_DEL			((MIB_PACKETFILTERLAN_TBL_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_PACKETFILTERLAN_DELALL		((MIB_PACKETFILTERLAN_TBL_NUM+4)|MIB_DELALL_TBL_ENTRY)
//IPv6 packet filter
#define MIB_PACKETFILTERWAN_V6_ENABLED	18020
#define MIB_PACKETFILTERWAN_V6_TBL_NUM	18021
#define MIB_PACKETFILTERWAN_V6_TBL		((MIB_PACKETFILTERWAN_V6_TBL_NUM+1)|MIB_TABLE_LIST)
#define MIB_PACKETFILTERWAN_V6_ADD	((MIB_PACKETFILTERWAN_V6_TBL_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_PACKETFILTERWAN_V6_DEL		((MIB_PACKETFILTERWAN_V6_TBL_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_PACKETFILTERWAN_V6_DELALL	((MIB_PACKETFILTERWAN_V6_TBL_NUM+4)|MIB_DELALL_TBL_ENTRY)
#define MIB_PACKETFILTERLAN_V6_ENABLED	18030
#define MIB_PACKETFILTERLAN_V6_TBL_NUM	18031
#define MIB_PACKETFILTERLAN_V6_TBL		((MIB_PACKETFILTERLAN_V6_TBL_NUM+1)|MIB_TABLE_LIST)
#define MIB_PACKETFILTERLAN_V6_ADD	((MIB_PACKETFILTERLAN_V6_TBL_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_PACKETFILTERLAN_V6_DEL		((MIB_PACKETFILTERLAN_V6_TBL_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_PACKETFILTERLAN_V6_DELALL	((MIB_PACKETFILTERLAN_V6_TBL_NUM+4)|MIB_DELALL_TBL_ENTRY)
#define MIB_PACKETFILTER_INTERFACE		18100
#define MIB_PACKETFILTER_PRIORITY			18101
#define MIB_PACKETFILTER_ACTION			18102
#define MIB_PACKETFILTER_DIRECTION		18103
#define MIB_PACKETFILTER_PROTOTYPE		18104
#define MIB_PACKETFILTER_PROTONUM		18105
#define MIB_PACKETFILTER_TCPFLAG			18106
#define MIB_PACKETFILTER_ICMPMSG		18107
#define MIB_PACKETFILTER_ICMPTYPE		18108
#define MIB_PACKETFILTER_ICMPCODE		18109
#define MIB_PACKETFILTER_SRCIPTYPE		18110
#define MIB_PACKETFILTER_SRCIPADDR		18111
#define MIB_PACKETFILTER_SRCIPMASK		18112
#define MIB_PACKETFILTER_SRCPORTTYPE		18113
#define MIB_PACKETFILTER_SRCFROMPORT	18114
#define MIB_PACKETFILTER_SRCTOPORT		18115
#define MIB_PACKETFILTER_DSTIPTYPE		18116
#define MIB_PACKETFILTER_DSTIPADDR		18117
#define MIB_PACKETFILTER_DSTIPMASK		18118
#define MIB_PACKETFILTER_DSTPORTTYPE		18119
#define MIB_PACKETFILTER_DSTFROMPORT	18120
#define MIB_PACKETFILTER_DSTTOPORT		18121
#define MIB_PACKETFILTER_IPVERSION		18122
#define MIB_PACKETFILTER_SRCIPADDRV6	18123
#define MIB_PACKETFILTER_DSTIPADDRV6	18124
#endif

#ifdef CONFIG_IPV6
#define MIB_IPV6_WAN_HOST_MODE_ENABLE	19000
#define MIB_ND_PROXY_ENABLED 19001
#define MIB_IPV6_FIREWALL_ENABLED 19002
#define MIB_NEC_IPV6_DHCPV6S_ENABLE					19003
#define MIB_NEC_IPV6_DHCPV6S_DNS_OPTION_ENABLE		19004
#define MIB_NEC_IPV6_DHCPV6S_DNS_OPTION_ADDR_TYPE	19005
#define MIB_NEC_IPV6_RADVD_RDNSS_ENABLE				19006
#endif
#define MIB_UPPER_MAPE_MODE 		19007
#define MIB_TM_SECURITY_ENABLED		19008
#define MIB_IPV4_OVER_IPV6_AUTO_SELECT	19009
#define MIB_VNE_TYPE	19010

//MAP-E Port Mapping
#define MIB_PORTFW_MAPE_ENABLED		19100
#define MIB_PORTFW_MAPE_TBL_NUM		19101
#define MIB_PORTFW_MAPE_TBL			((MIB_PORTFW_MAPE_TBL_NUM+1)|MIB_TABLE_LIST)
#define MIB_PORTFW_MAPE_ADD			((MIB_PORTFW_MAPE_TBL_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_PORTFW_MAPE_DEL			((MIB_PORTFW_MAPE_TBL_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_PORTFW_MAPE_MOD			((MIB_PORTFW_MAPE_TBL_NUM+3)|MIB_DEL_TBL_ENTRY | MIB_MOD_TBL_ENTRY)
#define MIB_PORTFW_MAPE_DELALL			((MIB_PORTFW_MAPE_TBL_NUM+4)|MIB_DELALL_TBL_ENTRY)

#define MIB_PORTFW_MAPE_IPADDR		19200
#define MIB_PORTFW_MAPE_MAPPORT 	19201
#define MIB_PORTFW_MAPE_DSTPORT 	19202
#define MIB_PORTFW_MAPE_DSTTOPORT 	19203
#define MIB_PORTFW_MAPE_PROTOTYPE 	19204
#define MIB_PORTFW_MAPE_COMMENT 	19205

#define MIB_PORTFW_MAPE_PAIR_TBL_NUM		19300
#define MIB_PORTFW_MAPE_PAIR_TBL			((MIB_PORTFW_MAPE_PAIR_TBL_NUM+1)|MIB_TABLE_LIST)
#define MIB_PORTFW_MAPE_PAIR_ADD			((MIB_PORTFW_MAPE_PAIR_TBL_NUM+2)|MIB_ADD_TBL_ENTRY)
#define MIB_PORTFW_MAPE_PAIR_DEL			((MIB_PORTFW_MAPE_PAIR_TBL_NUM+3)|MIB_DEL_TBL_ENTRY)
#define MIB_PORTFW_MAPE_PAIR_MOD			((MIB_PORTFW_MAPE_PAIR_TBL_NUM+3)|MIB_DEL_TBL_ENTRY | MIB_MOD_TBL_ENTRY)
#define MIB_PORTFW_MAPE_PAIR_DELALL		((MIB_PORTFW_MAPE_PAIR_TBL_NUM+4)|MIB_DELALL_TBL_ENTRY)

#define MIB_IPV6_DNS_MODE	19500
#define MIB_IPV6_DNS1		19501
#define MIB_IPV6_DNS2		19502

/* WNC-NMR2235-MIKE-YEH-20170123-Can not access any more the quick setting web page. */
#define MIB_SSL_RW_TIMEOUT	18600


// MIB value and constant
#ifdef CONFIG_IPV6
#define IFNAMESIZE 32
#define MAX_PREFIX_NUM 2
#define RR_MAX_NUM 2
#define NAMSIZE 32
#define MAX_DNAME_SIZE 128
#endif
#define MAX_REGULATORY_DOMAIN	4
#define MAX_SSID_LEN			33
#define WEP64_KEY_LEN			5
#define WEP128_KEY_LEN			13
#define MAX_NAME_LEN			31
/* NMR1746-20160902-Fix bug 1746 [Aero] The strange page will indicate after input the host name-start */
#define MAX_NAME_LEN_65			65
/* NMR1746-20160902-Fix bug 1746 [Aero] The strange page will indicate after input the host name-end */
#define COMMENT_LEN			21
#define MAX_CCK_CHAN_NUM		14
#define MAX_OFDM_CHAN_NUM		162
#define MAX_SERVER_DOMAIN_LEN	32
#define MAX_2G_CHANNEL_NUM_MIB		14
#define MAX_5G_CHANNEL_NUM_MIB		196
#define PASSWORD_SIZE	65
#ifdef CONFIG_APP_WEAVE
#define MAX_WEAVE_CONFIG_LENGTH 1024
#define WEAVE_FILE_PATH "/var/lib/weave/weave_settings.json"
#endif
#if defined(CONFIG_RTL_8812_SUPPORT) || defined(CONFIG_WLAN_HAL_8814AE) || defined(CONFIG_WLAN_HAL_8881A)
#define MAX_5G_DIFF_NUM		14
#endif
#define MIN_PSK_LEN			8
#define MAX_PSK_LEN			64
#define MAX_RS_PASS_LEN			65
#define MAX_DOMAIN_LEN			51
#define MAX_NAME_LEN_LONG		129

#define TX_RATE_1M			0x01
#define TX_RATE_2M			0x02
#define TX_RATE_5M			0x04
#define TX_RATE_11M			0x08

#define TX_RATE_6M			0x10
#define TX_RATE_9M			0x20
#define TX_RATE_12M			0x40
#define TX_RATE_18M			0x80
#define TX_RATE_24M			0x100
#define TX_RATE_36M			0x200
#define TX_RATE_48M			0x400
#define TX_RATE_54M			0x800

#define MAX_WLAN_AC_NUM			60

#ifndef CONFIG_WNC_REMOVE_MESH
//#if defined(CONFIG_RTK_MESH) && defined(_MESH_ACL_ENABLE_) Keith remove
#define MAX_MESH_ACL_NUM	MAX_WLAN_AC_NUM
//#endif Keith remove
#endif

#ifdef _SUPPORT_CAPTIVEPORTAL_PROFILE_
#define MAX_CAP_PORTAL_ALLOW_NUM		500
#endif

#define MAX_CERTROOT_NUM			5
#define MAX_CERTUSER_NUM			5	
#ifdef HOME_GATEWAY
#define MAX_FILTER_NUM			50//WNC-NMR0000-David-20160804, PortForwarding changed to 50
#define MAX_URLFILTER_NUM		16
#if 1 /* WNC-NMR0000-Jog-20160801, IPv4 packet filter */
#define MAX_PACKETFILTER_NUM	50
#endif
#ifdef VPN_SUPPORT
#define MAX_TUNNEL_NUM			10
#define MAX_RSA_FILE_LEN		2048
#define MAX_RSA_KEY_LEN			380
#define MAX_ENCRKEY_LEN			49
#define MAX_AUTHKEY_LEN			41
#define MAX_SPI_LEN			5
#endif
#define MAX_QOS_RULE_NUM		10
#endif
#define MAX_ROUTE_NUM			10
#define MAX_DHCP_RSVD_IP_NUM 20
#define MAXFNAME			60
#ifdef QOS_OF_TR069
#define MAX_QOS_CLASS_NUM        16
#define MAX_QOS_QUEUE_NUM        16
#define MAX_CLASS_INTERFACE_LEN  256
#define MAX_QUEUE_INTERFACE_LEN  256
#define MAC_ADDR_LEN             6 
#define MAX_APP_LIST_LEN         1024
//#define MAX_STATUS_LEN           10
#define MAX_ALIAS_LEN            64
#define MAX_TR098_APP_TBL_NUM	8
#define MAX_TR098_FLOW_TBL_NUM	8
#define MAX_MODE_LEN            9
#define MAX_ID_LEN              256
#define MAX_INFO_LEN            256

#define MAX_STATUS_LEN  16
#define MAX_TR098_NAME_LEN  64
#define MAX_IDENTIFY_LEN 256

#define MAX_QOS_POLICER_NUM        16 //mark_qos
#define MAX_PLOICER_ALIAS_LEN  64
#define MAX_PLOICER_STRING_LEN 32
#define MAX_QOS_QUEUESTATS_NUM        16
#endif

#ifdef WLAN_EASY_CONFIG
#define MAX_ACF_KEY_LEN			64
#define MAX_ACF_DIGEST_LEN		32
#endif

//#ifdef SNMP_SUPPORT Keith remove
#define MAX_SNMP_COMMUNITY_LEN                  64
//#endif Keith remove

#if 1	//def WIFI_SIMPLE_CONFIG	//WNC-NMR0000-[Alicia]-Libera-20190812-New SSID generation modification-for existed model build error
#define PIN_LEN					8
#endif

#define IFNAMSIZE       16
#if defined(CONFIG_RTL_8198_AP_ROOT) && defined(GMII_ENABLED) || defined(CONFIG_RTK_BRIDGE_VLAN_SUPPORT)
#define MAX_IFACE_VLAN_CONFIG (7+5*2) /* eth0~eth6, 2*(wlanX,wlanX-va0~wlanX-va3)no wds and vxd*/
#else
#define MAX_IFACE_VLAN_CONFIG (6+5*2) /* eth0~eth5, 2*(wlanX,wlanX-va0~wlanX-va3)no wds and vxd*/
#endif

#if defined(CONFIG_8021Q_VLAN_SUPPORTED)
#define MAX_VLAN_CONFIG_NUM 16
#define MAX_VLAN_PORT_NUM 24
#endif

#ifdef WLAN_PROFILE
/* WNC-NMR0000-HENG-I-CHEN-20130606-Change number of wlan profiles */
#define MAX_WLAN_PROFILE_NUM	8
/* WNC-NMR0000-HENG-I-CHEN-20130606-End */
#define PROFILE_BOTTOM_UP
#endif

/*WNC-NMR000-[Linear]-Libera-20140626-140626_3.4.7.1_patch_NEC.7z: wps_priority_band for converter-start*/
#define CONFIG_COMBINE_TWO_WPS_DEAMON_FOR_CLIENT //combine two client mode deamon into one
/*WNC-NMR000-[Linear]-Libera-20140626-140626_3.4.7.1_patch_NEC.7z: wps_priority_band for converter-end*/
#if defined(UNIVERSAL_REPEATER)
#define CONFIG_SMART_REPEATER
/* WNC-MR0000-[Voyager]-Libera-20131210- repeater mode -start */
#define CONFIG_CHEEPER_REPEATER	/* WNC-MR0000-Libera-Jan-20121101- new spec. - Repeater mode */
#define CONFIG_REPEATER_WPS_SUPPORT	/*	WNC-MR0000-Libera-Jan-20121101- new spec. - Repeater with WPS client (control wlan0-vxd)-open this flag*/
/* WNC-MR0000-[Voyager]-Libera-20131210- repeater mode -end*/
//#define CONFIG_REPEATER_WPS_SUPPORT
//#define CONFIG_WPS_EITHER_AP_OR_VXD //either one. When enable repeater, the wps is working for virtual client. Otherwise wps is working for root AP.
//#define CONFIG_ONLY_SUPPORT_CLIENT_REPEATER_WPS //if and only if root is client mode, the virtual vxd support wps
#endif

#define NEW_SCHEDULE_SUPPORT
#if defined(NEW_SCHEDULE_SUPPORT)
//#define MAX_SCHEDULE_NUM 10
#define MAX_SCHEDULE_NUM 3	/* WNC-MR0000-Libera-20120308- for Cheeper requirement*/
#else
/*Brad add for schedule*/
#define MAX_SCHEDULE_NUM 1
#endif

/* # keith: add l2tp support. 20080515 */
#define MAX_PPTP_HOST_NAME_LEN 64

#ifdef SAMBA_WEB_SUPPORT
#define MAX_USER_NUM			10
#define MAX_GROUP_NUM			10
#define	MAX_SHAREINFO_NUM		10
#define MAX_USER_NAME_LEN		16
#define MAX_USER_PASSWD_LEN		16
#define MAX_GROUP_NAME_LEN		10
#define MAX_FOLDER_NAME_LEN		30
#define	MAX_DISPLAY_NAME_LEN	10
#define	MAX_SHAREINFO_LEN		8
#define	MAX_SHAREINFO_PATH_LEN	48
#define	MAX_SHAREINFO_FOLDERNAME_LEN 32
#define MAX_OWNER_LEN 32
#endif

#ifdef __mips__
#ifdef CONFIG_MTD_NAND
#define FLASH_DEVICE_SETTING	("/hw_setting/hw.bin")		//mtdblock1 
//#define FLASH_DEVICE_NAME		("/dev/mtdblock0")			//boot
#define FLASH_DEVICE_NAME		("/dev/mtdblock2")			//linux+webpage
#define FLASH_DEVICE_NAME1		("/dev/mtdblock3")			// rootfs
#ifdef MTD_NAME_MAPPING
#define FLASH_BOOT_NAME			"boot"
#define FLASH_SETTING_NAME		"setting"
#define FLASH_WEBPAGE_NAME		"linux"
#define FLASH_LINUX_NAME		"linux"
#define FLASH_ROOTFS_NAME		"rootfs"
#define FLASH_SETTING_NAME2		"setting2"
#define FLASH_WEBPAGE_NAME2		"linux2"
#define FLASH_LINUX_NAME2		"linux2"
#define FLASH_ROOTFS_NAME2		"rootfs2"
#endif
#else
#define FLASH_DEVICE_NAME		("/dev/mtdblock0")
#define FLASH_DEVICE_NAME1		("/dev/mtdblock1")
#ifdef MTD_NAME_MAPPING
#ifndef CONFIG_RTL_FLASH_DUAL_IMAGE_ENABLE
#define FLASH_BOOT_NAME			"boot+cfg+linux"
#define FLASH_SETTING_NAME		"boot+cfg+linux"
#define FLASH_WEBPAGE_NAME		"boot+cfg+linux"
#define FLASH_LINUX_NAME		"boot+cfg+linux"
#define FLASH_ROOTFS_NAME		"rootfs"
#else
#define FLASH_BOOT_NAME			"boot+cfg+linux"
#define FLASH_SETTING_NAME		"boot+cfg+linux"
#define FLASH_WEBPAGE_NAME		"boot+cfg+linux"
#define FLASH_LINUX_NAME		"boot+cfg+linux"
#define FLASH_ROOTFS_NAME		"rootfs"
#define FLASH_WEBPAGE_NAME2		"boot+cfg+linux2"
#define FLASH_LINUX_NAME2		"boot+cfg+linux2"
#define FLASH_ROOTFS_NAME2		"rootfs2"
#endif
#endif
#endif
#else
#define FLASH_DEVICE_NAME		("setting.bin")
#define FLASH_DEVICE_NAME1		("setting1.bin")
#endif


/* NAND FLASH Layout */
#ifdef CONFIG_MTD_NAND
#define NAND_BOOT_PARTITION_SIZE		0x500000
#define NAND_SETTING_PARTITION_SIZE		0x300000
#define NAND_BOOT_SETTING_SIZE			(NAND_BOOT_PARTITION_SIZE+NAND_SETTING_PARTITION_SIZE)
#endif

#ifndef CONFIG_MTD_NAND
#ifdef CONFIG_RTL_FLASH_MAPPING_ENABLE
#define HW_SETTING_OFFSET		CONFIG_RTL_HW_SETTING_OFFSET
#define DEFAULT_SETTING_OFFSET          CONFIG_RTL_DEFAULT_SETTING_OFFSET
#define CURRENT_SETTING_OFFSET		CONFIG_RTL_CURRENT_SETTING_OFFSET
#define WEB_PAGE_OFFSET			CONFIG_RTL_WEB_PAGES_OFFSET
#define CODE_IMAGE_OFFSET               CONFIG_RTL_CODE_IMAGE_OFFSET
#define ROOT_IMAGE_OFFSET		CONFIG_RTL_ROOT_IMAGE_OFFSET
#else
#define HW_SETTING_OFFSET		0x6000
#define DEFAULT_SETTING_OFFSET	0x8000
#define CURRENT_SETTING_OFFSET		0xc000
#define WEB_PAGE_OFFSET			0x10000
#define CODE_IMAGE_OFFSET		0x20000
#define ROOT_IMAGE_OFFSET		0xE0000
#endif
#else
#ifdef CONFIG_RTL_FLASH_MAPPING_ENABLE
#define HW_SETTING_OFFSET		(CONFIG_RTL_HW_SETTING_OFFSET-NAND_BOOT_PARTITION_SIZE)
#define DEFAULT_SETTING_OFFSET	(CONFIG_RTL_DEFAULT_SETTING_OFFSET-NAND_BOOT_PARTITION_SIZE)
#define CURRENT_SETTING_OFFSET	(CONFIG_RTL_CURRENT_SETTING_OFFSET-NAND_BOOT_PARTITION_SIZE)
#define WEB_PAGE_OFFSET			CONFIG_RTL_WEB_PAGES_OFFSET
#define CODE_IMAGE_OFFSET		CONFIG_RTL_CODE_IMAGE_OFFSET
#define ROOT_IMAGE_OFFSET		CONFIG_RTL_ROOT_IMAGE_OFFSET
#else
#define HW_SETTING_OFFSET		0x0
#define DEFAULT_SETTING_OFFSET	0x2000
#define CURRENT_SETTING_OFFSET	0x6000
#define WEB_PAGE_OFFSET			0x800000
#define CODE_IMAGE_OFFSET		0x900000
#define ROOT_IMAGE_OFFSET		0xE00000
#endif
#endif

#ifdef CUSTOMER_HW_SETTING_SUPPORT
#define CUSTOMER_HW_SETTING_SIZE 0x400 //left 1K,enlarge it but not cover hw_setting
#define CUSTOMER_HW_SETTING_OFFSET DEFAULT_SETTING_OFFSET-CUSTOMER_HW_SETTING_SIZE
#define CUSTOMER_HW_SETTING_SECTOR_LEN CUSTOMER_HW_SETTING_SIZE
#endif
#ifdef HOME_GATEWAY
	#define CERT_PAGE_OFFSET	0x3f0000
#else
	#define CERT_PAGE_OFFSET	0x1f0000
#endif

#ifdef CONFIG_RTL_FLASH_MAPPING_ENABLE
#define HW_SETTING_SECTOR_LEN (CONFIG_RTL_DEFAULT_SETTING_OFFSET-CONFIG_RTL_HW_SETTING_OFFSET)
#define DEFAULT_SETTING_SECTOR_LEN	(CONFIG_RTL_CURRENT_SETTING_OFFSET-CONFIG_RTL_DEFAULT_SETTING_OFFSET)
#define CURRENT_SETTING_SECTOR_LEN	(CONFIG_RTL_WEB_PAGES_OFFSET-CONFIG_RTL_CURRENT_SETTING_OFFSET)
#else
#define HW_SETTING_SECTOR_LEN           (0x8000-0x6000)
#define DEFAULT_SETTING_SECTOR_LEN      (0xc000-0x8000)
#define CURRENT_SETTING_SECTOR_LEN      (0x10000-0xc000)
#endif

#ifndef WIN32
#define __PACK__		__attribute__ ((packed))
#else
#define __PACK__
#endif


/* Config/fw image file header */

#if 0
typedef enum { HW_SETTING=1,
#ifdef CUSTOMER_HW_SETTING_SUPPORT
CUSTOMER_HW_SETTING=8,
#endif
DEFAULT_SETTING=2, CURRENT_SETTING=4} CONFIG_DATA_T;
#endif //SDK 3.4.10.B3
//WNC-JDR230-HENGI
typedef enum { HW_SETTING=1, DEFAULT_SETTING=2, CURRENT_SETTING=4, FEATURE_KEY=8} CONFIG_DATA_T;

#if defined(CONFIG_RTL_8196B)
// update tag
#define HW_SETTING_HEADER_TAG		((char *)"h6")
//Brad add for distinguish ap(da:default setting for ap) or gateway(dg: default setting for gateway) platform
#if (defined(HOME_GATEWAY) && defined(VPN_SUPPORT))
#define DEFAULT_SETTING_HEADER_TAG	((char *)"6V")
#elif (defined(HOME_GATEWAY))
#define DEFAULT_SETTING_HEADER_TAG	((char *)"6G")
#else
#define DEFAULT_SETTING_HEADER_TAG	((char *)"6A")
#endif
//Brad add for distinguish ap(ca:current setting for ap) or gateway(cg: current setting for gateway) platform
#if (defined(HOME_GATEWAY) && defined(VPN_SUPPORT))
#define CURRENT_SETTING_HEADER_TAG	((char *)"6v")
#elif (defined(HOME_GATEWAY))
#define CURRENT_SETTING_HEADER_TAG	((char *)"6g")
#else
#define CURRENT_SETTING_HEADER_TAG	((char *)"6a")
#endif
// force tag
#define HW_SETTING_HEADER_FORCE_TAG	((char *)"Hf")
#define DEFAULT_SETTING_HEADER_FORCE_TAG ((char *)"Df")
#define CURRENT_SETTING_HEADER_FORCE_TAG ((char *)"Cf")
// upgrade
#define HW_SETTING_HEADER_UPGRADE_TAG	((char *)"Hu")
#define DEFAULT_SETTING_HEADER_UPGRADE_TAG ((char *)"Du")
#define CURRENT_SETTING_HEADER_UPGRADE_TAG ((char *)"Cu")
#elif defined(CONFIG_RTL_8198C)||defined(CONFIG_RTL_8196C) || defined(CONFIG_RTL_8198) || defined(CONFIG_RTL_819XD) || defined(CONFIG_RTL_8196E) || defined(CONFIG_RTL_8198B) || defined(CONFIG_RTL_8197F)

// update tag
#define HW_SETTING_HEADER_TAG		((char *)"H6")
#if (defined(HOME_GATEWAY) && defined(VPN_SUPPORT))
#define DEFAULT_SETTING_HEADER_TAG	((char *)"6V")
#elif (defined(HOME_GATEWAY))
#define DEFAULT_SETTING_HEADER_TAG	((char *)"6G")
#else
#define DEFAULT_SETTING_HEADER_TAG	((char *)"6A")
#endif
#if (defined(HOME_GATEWAY) && defined(VPN_SUPPORT))
#define CURRENT_SETTING_HEADER_TAG	((char *)"6v")
#elif (defined(HOME_GATEWAY))
#define CURRENT_SETTING_HEADER_TAG	((char *)"6g")
#else
#define CURRENT_SETTING_HEADER_TAG	((char *)"6a")
#endif
// force tag
#define HW_SETTING_HEADER_FORCE_TAG	((char *)"Hf")
#define DEFAULT_SETTING_HEADER_FORCE_TAG ((char *)"Df")
#define CURRENT_SETTING_HEADER_FORCE_TAG ((char *)"Cf")
// upgrade
#define HW_SETTING_HEADER_UPGRADE_TAG	((char *)"Hu")
#define DEFAULT_SETTING_HEADER_UPGRADE_TAG ((char *)"Du")
#define CURRENT_SETTING_HEADER_UPGRADE_TAG ((char *)"Cu")
#else
// update tag
#define HW_SETTING_HEADER_TAG		((char *)"hs")
#if (defined(HOME_GATEWAY) && defined(VPN_SUPPORT))
#define DEFAULT_SETTING_HEADER_TAG	((char *)"dv")
#elif (defined(HOME_GATEWAY))
#define DEFAULT_SETTING_HEADER_TAG	((char *)"dg")
#else
#define DEFAULT_SETTING_HEADER_TAG	((char *)"da")
#endif
#if (defined(HOME_GATEWAY) && defined(VPN_SUPPORT))
#define CURRENT_SETTING_HEADER_TAG	((char *)"cv")
#elif (defined(HOME_GATEWAY))
#define CURRENT_SETTING_HEADER_TAG	((char *)"cg")
#else
#define CURRENT_SETTING_HEADER_TAG	((char *)"ca")
#endif
// force tag
#define HW_SETTING_HEADER_FORCE_TAG	((char *)"hf")
#define DEFAULT_SETTING_HEADER_FORCE_TAG ((char *)"df")
#define CURRENT_SETTING_HEADER_FORCE_TAG ((char *)"cf")
// upgrade
#define HW_SETTING_HEADER_UPGRADE_TAG	((char *)"hu")
#define DEFAULT_SETTING_HEADER_UPGRADE_TAG ((char *)"du")
#define CURRENT_SETTING_HEADER_UPGRADE_TAG ((char *)"cu")
#endif //#if defined(CONFIG_RTL_8196B)
#ifdef CUSTOMER_HW_SETTING_SUPPORT
#define CUSTOMER_HW_SETTING_HEADER_TAG ((char *)"us")
#endif

//WNC-JDR230-HENGI
#define TELNET_ENABLE_HEADER_TAG ((char *)"te")

#if 0//def CONFIG_RTL8196B_GW_8M
#undef DEFAULT_SETTING_HEADER_TAG	
#define DEFAULT_SETTING_HEADER_TAG	((char *)"61")

#undef CURRENT_SETTING_HEADER_TAG	
#define CURRENT_SETTING_HEADER_TAG	((char *)"62")
#endif


#define TAG_LEN				2

#if defined(CONFIG_RTL_8196B)

#define HW_SETTING_VER			1	// hw setting version
#define DEFAULT_SETTING_VER		2	// default setting version
#define CURRENT_SETTING_VER		DEFAULT_SETTING_VER // current setting version

#elif defined(CONFIG_RTL_8198C)||defined(CONFIG_RTL_8196C) || defined(CONFIG_RTL_8198) || defined(CONFIG_RTL_819XD) || defined(CONFIG_RTL_8196E) || defined(CONFIG_RTL_8198B) || defined(CONFIG_RTL_8197F)
#define HW_SETTING_VER			1	// hw setting version
#ifdef HEADER_LEN_INT
/*if not HEADER_LEN_INT, using different ver to restore default*/
#define DEFAULT_SETTING_VER		3	// default setting version
#define CURRENT_SETTING_VER		DEFAULT_SETTING_VER // current setting version
#else
#define DEFAULT_SETTING_VER		1	// default setting version
#define CURRENT_SETTING_VER		DEFAULT_SETTING_VER // current setting version
#endif
#else

#define HW_SETTING_VER			3	// hw setting version
#define DEFAULT_SETTING_VER		4	// default setting version
#define CURRENT_SETTING_VER		DEFAULT_SETTING_VER // current setting version

#endif
#ifdef CUSTOMER_HW_SETTING_SUPPORT
#define CUSTOMER_HW_SETTING_VER 8
#endif

#if defined(CONFIG_RTL_8196B)
#define FW_HEADER_WITH_ROOT	((char *)"cr6b")
#define FW_HEADER			((char *)"cs6b")
#elif defined(CONFIG_RTL_8198C)||defined(CONFIG_RTL_8196C) || defined(CONFIG_RTL_8198) || defined(CONFIG_RTL_819XD) || defined(CONFIG_RTL_8196E) || defined(CONFIG_RTL_8198B) || defined(CONFIG_RTL_8197F)
#define FW_HEADER_WITH_ROOT	((char *)"cr6c")
#define FW_HEADER			((char *)"cs6c")
#else
#define FW_HEADER_WITH_ROOT	((char *)"csro")
#define FW_HEADER			((char *)"csys")
#endif //#if defined(CONFIG_RTL_8196B)

#if defined(CONFIG_RTL_8196B)
#if (defined(HOME_GATEWAY) && defined(VPN_SUPPORT))
#define WEB_HEADER			((char *)"w6bv")
#elif (defined(HOME_GATEWAY))
#define WEB_HEADER			((char *)"w6bg")
#else
#define WEB_HEADER			((char *)"w6ba")
#endif
#elif defined(CONFIG_RTL_8198C)||defined(CONFIG_RTL_8196C) || defined(CONFIG_RTL_8198) || defined(CONFIG_RTL_819XD) || defined(CONFIG_RTL_8196E) || defined(CONFIG_RTL_8198B) || defined(CONFIG_RTL_8197F)
#if (defined(HOME_GATEWAY) && defined(VPN_SUPPORT))
#define WEB_HEADER			((char *)"w6cv")
#elif (defined(HOME_GATEWAY))
#define WEB_HEADER			((char *)"w6cg")
#else
#define WEB_HEADER			((char *)"w6ca")
#endif
#else
#if (defined(HOME_GATEWAY) && defined(VPN_SUPPORT))
#define WEB_HEADER			((char *)"webv")
#elif (defined(HOME_GATEWAY))
#define WEB_HEADER			((char *)"webg")
#else
#define WEB_HEADER			((char *)"weba")
#endif
#endif //#if defined(CONFIG_RTL_8196B)

#if defined(CONFIG_RTL_8196B)
#define ROOT_HEADER			((char *)"r6br")
#elif defined(CONFIG_RTL_8198C)||defined(CONFIG_RTL_8196C) || defined(CONFIG_RTL_8198) || defined(CONFIG_RTL_819XD) || defined(CONFIG_RTL_8196E) || defined(CONFIG_RTL_8198B) || defined(CONFIG_RTL_8197F)
#define ROOT_HEADER			((char *)"r6cr")
#else
#define ROOT_HEADER			((char *)"root")
#endif //#if defined(CONFIG_RTL_8196B)

#define CERT_HEADER			((char *)"cert")
#define BOOT_HEADER			((char *)"boot")
#define ALL_HEADER			((char *)"allp")
#define SIGNATURE_LEN			4

/* wlan driver ioctl id */
#define SIOCGIWRTLSTAINFO   		0x8B30	// get station table information
#define SIOCGIWRTLSTANUM		0x8B31	// get the number of stations in table
#define SIOCGIWRTLSCANREQ		0x8B33	// scan request
#define SIOCGIWRTLGETBSSDB		0x8B34	// get bss data base
#define SIOCGIWRTLJOINREQ		0x8B35	// join request
#define SIOCGIWRTLJOINREQSTATUS		0x8B36	// get status of join request
#define SIOCGIWRTLGETBSSINFO		0x8B37	// get currnet bss info
#define SIOCGIWRTLGETWDSINFO		0x8B38
#define SIOCGMISCDATA	0x8B48	// get misc data

/*for P2P_SUPPORT*/
#define SIOCP2PSCANREQ   		0x8BD2	// p2p scan request
#define SIOCP2PGETRESULT  	0x8BD3 // get p2p discovery result
#define SIOCP2PPROVREQ		0x8BD4	// issue provision discovery request
#define SIOCP2WSCMETHODCONF	0x8BD5	// report event and state
#define SIOCP2PPGETEVNIND	0x8BD6	// report event and state

#define SIOCP2P_WSC_REPORT_STATE			0x8BD7
#define SIOCP2P_REPORT_CLIENT_STATE			0x8BD8	// report client connect state



//=========add for MESH=========
//#ifdef CONFIG_RTK_MESH Keith remove
// by GANTOE for site survey 2008/12/26 
#define SIOCJOINMESH 0x8B94 
#define SIOCCHECKMESHLINK 0x8B95
//#endif Keith remove
//=========add for MESH=========

#define MAC_ADDR_LEN    6
#define MAX_STA_NUM			64	// max support sta number

/* flag of sta info */
#define STA_INFO_FLAG_AUTH_OPEN     	0x01
#define STA_INFO_FLAG_AUTH_WEP      	0x02
#define STA_INFO_FLAG_ASOC          	0x04
#define STA_INFO_FLAG_ASLEEP        	0x08

// bit value for hw board id
#if 0
// Old code and no longer used
#define ETH_PHY_TYPE			1
#define BOOT_PORT_SELECT		2
#define USE_ETH0_WAN			4
#endif
#define WLAN_RF_2T2R			1

#ifdef WIFI_SIMPLE_CONFIG
enum { WSC_AUTH_OPEN=1, WSC_AUTH_WPAPSK=2, WSC_AUTH_SHARED=4, WSC_AUTH_WPA=8, WSC_AUTH_WPA2=0x10, WSC_AUTH_WPA2PSK=0x20, WSC_AUTH_WPA2PSKMIXED=0x22 };
enum { WSC_ENCRYPT_NONE=1, WSC_ENCRYPT_WEP=2, WSC_ENCRYPT_TKIP=4, WSC_ENCRYPT_AES=8, WSC_ENCRYPT_TKIPAES=12 };

enum { 	
CONFIG_METHOD_ETH=0x2, 
	CONFIG_METHOD_PIN=0x4, 	
	CONFIG_METHOD_DISPLAY=0x8  ,		
	CONFIG_METHOD_PBC=0x80 , 	
	CONFIG_METHOD_KEYPAD=0x100   
};
/* WNC-NMR2289-[Rafale]-Libera-20170220-request: WPS PIN enable/disable-start*/
//WPS2.0
enum { 
	CONFIG_METHOD_VIRTUAL_PBC=0x280,
	CONFIG_METHOD_PHYSICAL_PBC=0x480,
	CONFIG_METHOD_VIRTUAL_PIN=0x2008,
	CONFIG_METHOD_PHYSICAL_PIN=0x4008
};
/*WNC-NMR2289-[Rafale]-Libera-20170220-request: WPS PIN enable/disable-end */


enum { CONFIG_BY_INTERNAL_REGISTRAR=1, CONFIG_BY_EXTERNAL_REGISTRAR=2};

/* WNC-MR1530-Yuan-I-Chou-20120328-Add WSC type */
// WPS type (rakuraku or WPS or both)
enum { WSC_TYPE_RAKURAKU = 1, WSC_TYPE_WPS = 2, WSC_TYPE_BOTH = 3 };

//WNC-NMRXXX-JDR230-Yuan-I-Chou-20140527-Add WSC priority
// WPS priority (2.4G or 5G)
enum { WSC_PRIORITY_2G = 1, WSC_PRIORITY_5G = 2 };

#endif
//WNC-NMRXXXX-D2R030-YUAN-I-CHOU-20151220, Spider MIB_NEC_MAC_ADDRESS_FILTERING_ENTRY VALUE
enum { BY_INPUT = 0, BY_SYNC = 1 };
//WNC-NMRXXXX-D2R030-YUAN-I-CHOU-20151220, Spider MIB_NEC_AIM_ACCESS_AFTER_INITIALIZATION VALUE
enum { NOT_YET = 0, ACCESSED = 1 };

/* WNC-NMR0000-JOE-PENG-20140724-Implemen section 4.4.38 site survey page of Linear step 2 (repeater mode) */
enum { MULTI_STAGE_CONNECTION_1 = 1, MULTI_STAGE_CONNECTION_2 = 2, MULTI_STAGE_CONNECTION_3 = 3 };

//WNC-NMRXXX-JDR230-Yuan-I-Chou-20140527-Add TV mode support
enum { TV_DISABLED = 0, TV_ENABLED = 1 , TV_AUTO = 2 };

//WNC-NMRXXX-JDR230-Yuan-I-Chou-20140527-Add Multicast forwarding control
enum { FORWARD_ALL = 1 , FORWARD_NONSTREAMING = 2 };

//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160111-Add Light OFF state support
enum { LOS_ALL_ON = 0 , LOS_ALL_OFF_BUT_POWER = 1 , LOS_ALL_OFF = 2 };

typedef enum {
	ENCRYPT_WPA_TKIP = 2,
	ENCRYPT_WPA_AES = 3,
	ENCRYPT_WPA2_AES = 4,
	ENCRYPT_WPA2_TKIP = 5,
} WPAENCRYPT_T;
typedef enum { ENCRYPT_DISABLED=0, ENCRYPT_WEP=1, ENCRYPT_WPA=2, ENCRYPT_WPA2=4, ENCRYPT_WPA2_MIXED=6 ,ENCRYPT_WAPI=7} ENCRYPT_T;
typedef enum { WDS_ENCRYPT_DISABLED=0, WDS_ENCRYPT_WEP64=1, WDS_ENCRYPT_WEP128=2, WDS_ENCRYPT_TKIP=3, WDS_ENCRYPT_AES=4} WDS_ENCRYPT_T;
typedef enum { SUPP_NONWPA_NONE=0,SUPP_NONWPA_WEP=1,SUPP_NONWPA_1X=2} SUPP_NONWAP_T;
typedef enum { WPA_AUTH_AUTO=1, WPA_AUTH_PSK=2 } WPA_AUTH_T;
typedef enum { WAPI_AUTH_AUTO=1, WAPI_AUTH_PSK=2 } WAPI_AUTH_T;
typedef enum { WPA_CIPHER_TKIP=1, WPA_CIPHER_AES=2, WPA_CIPHER_MIXED=3 } WPA_CIPHER_T;
typedef enum { NO_MGMT_FRAME_PROTECTION = 0, MGMT_FRAME_PROTECTION_OPTIONAL = 1, MGMT_FRAME_PROTECTION_REQUIRED = 2} WPA_11W_T;
typedef enum { WEP_DISABLED=0, WEP64=1, WEP128=2 } WEP_T;
typedef enum { KEY_ASCII=0, KEY_HEX } KEY_TYPE_T;
typedef enum { LONG_PREAMBLE=0, SHORT_PREAMBLE=1 } PREAMBLE_T;
typedef enum { DHCP_DISABLED=0, DHCP_CLIENT=1, DHCP_SERVER=2, PPPOE=3, PPTP=4, DHCP_RELAY=5,L2TP=6, DHCP_AUTO=15 , USB3G=16, AFTR=17, DHCP_AUTO_WAN=19,BRIDGE=20, DHCP_NONE=99  } DHCP_T; /* # keith: add l2tp support. 20080515 */
typedef enum { DHCP_LAN_NONE=0, DHCP_LAN_CLIENT=1, DHCP_LAN_SERVER=2, DHCP_LAN_RELAY=3 } DHCP_TYPE_T; //keith add. LAN SIDE DHCP TYPE
typedef enum { GATEWAY_MODE=0, BRIDGE_MODE=1, WISP_MODE=2 } OPMODE_T;
typedef enum { DISABLE_MODE=0, RIP1_MODE=1, RIP2_MODE=2 } RIP_OPMODE_T; 
/* WNC-MR0000-David@D2R032-20160722-Modification for NEC Aero, Start */
typedef enum { AUTO_GAEWAY=0, MANUAL_GATEWAY=1 } AUTO_GATEWAY_T;//AUTO_GATEWAY: gateway setting is from server rather than user input.
/* WNC-MR0000-David@D2R032-20160722-Modification for NEC Aero, End */

#ifdef RIP6_SUPPORT
typedef enum { RIP6_DISABLE=0, RIP6_ENABLE=1 } RIP6_OPMODE_T;
#endif
typedef enum { FCC=1, IC, ETSI, SPAIN, FRANCE, MKK } REG_DOMAIN_T;
typedef enum { AUTH_OPEN=0, AUTH_SHARED, AUTH_BOTH } AUTH_TYPE_T;
typedef enum { DNS_AUTO=0, DNS_MANUAL } DNS_TYPE_T;
#if defined(CONFIG_DYNAMIC_WAN_IP)
typedef enum { DYNAMIC_IP=0, STATIC_IP } WAN_IP_TYPE_T;
#endif
typedef enum { CONTINUOUS=0, CONNECT_ON_DEMAND, MANUAL } PPP_CONNECT_TYPE_T;
typedef enum { RF_INTERSIL=1, RF_RFMD=2, RF_PHILIP=3, RF_MAXIM=4, RF_GCT=5,
 		RF_MAXIM_AG=6, RF_ZEBRA=7, RF_8255=8 } RF_TYPE_T;
typedef enum { LED_TX_RX=0, LED_LINK_TXRX=1, LED_LINKTXRX=2 } LED_TYPE_T;
typedef enum { VLAN_FORWARD_DISABLED=0, VLAN_FORWARD_BRIDGE=1, VLAN_FORWARD_NAT=2 } VLAN_FORWARD_TYPE_T;

typedef enum { CHIP_UNKNOWN=0, CHIP_RTL8188C=1, CHIP_RTL8192C=2, CHIP_RTL8192D=3, CHIP_RTL8192E=4,CHIP_RTL8188E=5, } CHIP_VERSION_T;

#ifdef CONFIG_APP_OPENVPN
typedef enum { NAME_PWD=0, CERTS=1, PWD_CERTS=2 } OPENVPN_AUTH_TYPE_T;
#endif
typedef enum { 
	AP_MODE=0, 
	CLIENT_MODE=1, 
	WDS_MODE=2, 
	AP_WDS_MODE=3, 
	AP_MESH_MODE=4, 
	MESH_MODE=5, 
	MP_MODE=7,
	P2P_SUPPORT_MODE=8
} WLAN_MODE_T;

//=========add for MESH=========

typedef enum { INFRASTRUCTURE=0, ADHOC=1 } NETWORK_TYPE_T;
typedef enum { BAND_11B=1, BAND_11G=2, BAND_11BG=3, BAND_11A=4, BAND_11N=8, BAND_5G_11AN=12, 
	BAND_5G_11AC=64,BAND_5G_11AAC=68,BAND_5G_11NAC=72,BAND_5G_11ANAC=76} BAND_TYPE_T;
typedef enum { DISABLED=0, A_MPDU=1, A_MSDU=2, A_MIXED=3} AGGREGATION_MODE_T;	// GANTOE & epopen: DISABLED=0 original is DISABLE=0, Because conflict with ../../auth/include/1x_common.h in AP/net-snmp-5.x.x
typedef enum { PHYBAND_OFF=0, PHYBAND_2G=1, PHYBAND_5G=2 } PHYBAND_TYPE_T;
typedef enum { SMACSPHY=0, DMACSPHY=1, DMACDPHY=2 } MACPHYMODE_TYPE_T;
typedef enum { BANDMODE2G=0, BANDMODE5G=1, BANDMODEBOTH=2, BANDMODESINGLE=3 } WLANBAND2G5GMODE_TYPE_T;

#ifdef HOME_GATEWAY
#ifdef VPN_SUPPORT
typedef enum { IKE_MODE=0, MANUAL_MODE=1} KEY_MODE_T;
typedef enum { SINGLE_ADDR=0, SUBNET_ADDR=1, ANY_ADDR=2, NATT_ADDR=3} ADDRESS_MODE_T;
typedef enum { INITIATOR=0, RESPONDER=1} CONN_TYPE_T;
typedef enum { MD5_ALGO=0, AUTH_ALGO=1} AUTH_MODE_T;
typedef enum { ESP_PROTO=0, AH_PROTO=1} IPSEC_PROTO_T;
typedef enum { TRI_DES_ALGO=0, AES_ALGO=1, NONE_ALGO=2} ENCR_MODE_T;
// DH1=768 bits, DH2=1024 bits, DH5= 1536
typedef enum { DH1_GRP=0, DH2_GRP=1, DH5_GRP=2} KEY_GROUP_T;
#endif // VPN_SUPPORT
typedef enum { PROTO_BOTH=3, PROTO_TCP=1, PROTO_UDP=2 } PROTO_TYPE_T;
typedef enum { IPv4=4, IPv6=6 } IP_VERSION_T;
#if 1 /* WNC-NMR0000-Jog-20160801, IPv4 packet filter */
typedef enum {ACTION_DROP=0, ACTION_PASS=1} ACTION_T;
typedef enum {DIR_IN=0, DIR_OUT=1} DIRECTION_T;
typedef enum {PROTOCOL_IP=0, PROTOCOL_ICMP=1, PROTOCOL_TCP=2, PROTOCOL_UDP=3, PROTOCOL_OTHER=4} PROTOCOL_TYPE_T;
typedef enum {TCPFLAG_UNSPEC=0, TCPFLAG_ACK=1, TCPFLAG_FIN=2, TCPFLAG_PSH=3, TCPFLAG_RST=4, TCPFLAG_SYN=5, TCPFLAG_URG=6} TCPFLAG_T;
typedef enum {ICMPMSG_UNSPEC=0, ICMPMSG_CODESPEC=1, ICMPMSG_ECHO=2, ICMPMSG_ECHOREPLY=3, ICMPMSG_REDIRECT=4} ICMPMSG_T;
typedef enum {IPADDRTYPE_ANY=0, IPADDRTYPE_LOCALHOST=1, IPADDRTYPE_SPEC=2} IPADDRTYPE_T;
typedef enum {PORTTYPE_ANY=0, PORTYPE_RANGE=1} PORTTYPE_T;
#endif
#endif // HOME_GATEWAY

#ifdef WLAN_EASY_CONFIG
enum { MODE_BUTTON=1, MODE_QUESTION=2 };
enum {
	ACF_ALGORITHM_WEP64	= 0x01,
	ACF_ALGORITHM_WEP128	= 0x02,
	ACF_ALGORITHM_WPA_TKIP	= 0x04,
	ACF_ALGORITHM_WPA_AES	= 0x08,
	ACF_ALGORITHM_WPA2_TKIP	= 0x10,
	ACF_ALGORITHM_WPA2_AES	= 0x20,
};
enum {	ROLE_SERVER=1, ROLE_CLIENT=2, ROLE_ADHOC=4};
#endif // WLAN_EASY_CONFIG

enum {TURBO_AUTO=0, TURBO_ON=1, TURBO_OFF=2};

enum {VNE_TYPE_DEFAULT=0, VNE_TYPE_DS_LITE=2, VNE_TYPE_MAPE_JPNE=3, VNE_TYPE_MAPE_COM=6};

#if defined(CONFIG_RTL_802_1X_CLIENT_SUPPORT) || defined(CONFIG_RTL_ETH_802DOT1X_CLIENT_MODE_SUPPORT)

typedef enum { EAP_MD5=0, EAP_TLS=1, EAP_PEAP=2,EAP_TTLS=3 } EAP_TYPE_T;
typedef enum { INSIDE_MSCHAPV2=0 } INSIDE_TYPE_T;
#define MAX_EAP_USER_ID_LEN 64
#define MAX_RS_USER_NAME_LEN 64
#define MAX_RS_USER_PASS_LEN 64
#define MAX_RS_USER_CERT_PASS_LEN 64
#define RS_USER_CERT_5G	"/var/1x/client_5g.pem"
#define RS_ROOT_CERT_5G	"/var/1x/ca_5g.pem"
#define RS_USER_CERT_2G	"/var/1x/client_2g.pem"
#define RS_ROOT_CERT_2G	"/var/1x/ca_2g.pem"
#define RS_USER_CERT_TMP "/var/1x/client_tmp.pem"
#define RS_ROOT_CERT_TMP "/var/1x/ca_tmp.pem"
#if defined(CONFIG_RTL_ETH_802DOT1X_CLIENT_MODE_SUPPORT)
typedef enum { TTLS_PHASE2_EAP=0,TTLS_PHASE2_PAP=1,TTLS_PHASE2_CHAP=2,TTLS_PHASE2_MSCHAP=3,TTLS_PHASE2_MSCHAPV2=4 } TTLS_PHASE2_TYPE_T;
typedef enum { TTLS_PHASE2_EAP_MD5=0 } TTLS_PHASE2_EAP_METHOD_T;

#define RS_USER_CERT_ETH	"/var/1x/client_eth.pem"
#define RS_ROOT_CERT_ETH	"/var/1x/ca_eth.pem"
#define CERT_SIZE 0x12000	//48KB,for ethernet 1x should be sync with users/auth/src/rwCertSrc/rsCertCommon.h
#else
#define CERT_SIZE 0x8000	//32KB, should be sync with users/auth/src/rwCertSrc/rsCertCommon.h
#endif
#endif



#if defined(CONFIG_RTL_ULINKER)
#include "rtl_ulinker.h"
#endif



#if defined(_LITTLE_ENDIAN_)
#define DWORD_SWAP(v) ( (((v&0xff)<<24)&0xff000000) | ((((v>>8)&0xff)<<16)&0xff0000) | \
				((((v>>16)&0xff)<<8)&0xff00) | (((v>>24)&0xff)&0xff) )
#define WORD_SWAP(v) ((unsigned short)(((v>>8)&0xff) | ((v<<8)&0xff00)))
#elif defined(_BIG_ENDIAN_)
#define DWORD_SWAP(v) (v)
#define WORD_SWAP(v) (v)
#else
#error "Endian is not defined"
#endif

#ifdef HEADER_LEN_INT
#define HEADER_SWAP(v) DWORD_SWAP(v)
#else 
#define HEADER_SWAP(v) WORD_SWAP(v)
#endif
/* scramble saved configuration data */
#define ENCODE_DATA(data,len) { \
	int i; \
	for (i=0; i<len; i++) \
		data[i] = ~ ( data[i] + 0x38); \
}

#define DECODE_DATA(data,len) { \
	int i; \
	for (i=0; i<len; i++) \
		data[i] = ~data[i] - 0x38;	\
}

/* Do checksum and verification for configuration data */
#ifndef WIN32
static inline unsigned char CHECKSUM(unsigned char *data, int len)
#else
__inline unsigned char CHECKSUM(unsigned char *data, int len)
#endif
{
	int i;
	unsigned char sum=0;

	for (i=0; i<len; i++)
		sum += data[i];

	sum = ~sum + 1;
	return sum;
}
#define CHECKSUM_LEN_MAX 0x800000
#ifndef WIN32
static inline int CHECKSUM_OK(unsigned char *data, int len)
#else
__inline int CHECKSUM_OK(unsigned char *data, int len)
#endif
{
	int i;
	unsigned char sum=0;

	if(len<0||len>CHECKSUM_LEN_MAX)
		return 0;
	for (i=0; i<len; i++)
		sum += data[i];

	if (sum == 0)
		return 1;
	else
		return 0;
}

enum { 
	STATS_AUTH_OPEN=0,
	STATS_AUTH_SHARE=1,
	STATS_PSK_WPA=2,
	STATS_PSK_WPA2=3,
	STATS_ETP_WPA=4,
	STATS_ETP_WPA2=5
};

typedef enum{
        DOT11_ENC_NONE  = 0,
        DOT11_ENC_WEP40 = 1,
        DOT11_ENC_TKIP  = 2,
        DOT11_ENC_WRAP  = 3,
        DOT11_ENC_CCMP  = 4,
        DOT11_ENC_WEP104= 5,
        DOT11_ENC_BIP   = 6,
        DOT11_ENC_WAPI  = 6
} DOT11_ENC_ALGO;

/* WLAN sta info structure */
typedef struct wlan_sta_info {
	unsigned short	aid;
	unsigned char	addr[6];
	unsigned long	tx_packets;
	unsigned long	rx_packets;
	unsigned long	expired_time;	// 10 msec unit
	unsigned short	flag;
	unsigned char	txOperaRates;
	unsigned char	rssi;
	unsigned long	link_time;		// 1 sec unit
	unsigned long	tx_fail;
	unsigned long	tx_bytes;
	unsigned long	rx_bytes;
	unsigned char	network;
	unsigned char	ht_info;	// bit0: 0=20M mode, 1=40M mode; bit1: 0=longGI, 1=shortGI
	unsigned char	RxOperaRate;
// WNC-NMR01369-D2R031-HENG-I-CHEN-20160224: set inAuthorizing when WPA PSK negotiation is not completed #BEGIN
	//unsigned char 	resv[5];
	unsigned char	auth_type;
	unsigned char	cipher_type;
	unsigned char	inAuthorizing;
	unsigned short	resv2;
// WNC-NMR01369-D2R031-HENG-I-CHEN-20160224: set inAuthorizing when WPA PSK negotiation is not completed #END
} WLAN_STA_INFO_T, *WLAN_STA_INFO_Tp;

typedef struct wlan_rate{
unsigned int id;
unsigned char rate[20];
}WLAN_RATE_T, *WLAN_RATE_Tp;
typedef enum { 
	MCS0=0x80, 
	MCS1=0x81, 
	MCS2=0x82,
	MCS3=0x83,
	MCS4=0x84,
	MCS5=0x85,
	MCS6=0x86,
	MCS7=0x87,
	MCS8=0x88,
	MCS9=0x89,
	MCS10=0x8a,
	MCS11=0x8b,
	MCS12=0x8c,
	MCS13=0x8d,
	MCS14=0x8e,
	MCS15=0x8f
	} RATE_11N_T;

#ifdef WIN32
#pragma pack(1)
#endif



#ifdef CONFIG_RTL_P2P_SUPPORT
//#define P2P_DEBUG(fmt, args...) printf("(%s %d):"fmt,__FUNCTION__ , __LINE__ , ## args)
#define P2P_DEBUG(fmt, args...) 
typedef enum { 
	P2P_DEVICE=1, 
	P2P_PRE_CLIENT=2,
	P2P_CLIENT=3,
	P2P_PRE_GO=4,	 // after GO nego , we are GO and proceed WSC exchange
	P2P_TMP_GO=5	 // after GO nego , we are GO and proceed WSC exchange is done
} P2P_TPYE_ENUM_T;
#endif



//zj: eco featrue
#define ECO_LEDDIM_MASK		0x08
#define ECO_TIMER_MASK			0x04
#define ECO_EVERYDAY_MASK		0x02
#define ECO_24HOURS_MASK			0x01

#define ECO_DAY_MASK			0x0000007F
#define ECO_SUNDAY_MASK		0x00000001
#define ECO_MONDAY_MASK		0x00000002
#define ECO_TUESDAY_MASK		0x00000004
#define ECO_WEDNESDAY_MASK	0x00000008
#define ECO_THURSDAY_MASK		0x00000010
#define ECO_FRIDAY_MASK		0x00000020
#define ECO_SATURDAY_MASK		0x00000040

#define SCHEDULE_NAME_LEN		20
typedef struct schedule_entry {
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
	_ctype _cname _crepeat;

#define MIB_SCHEDULE_IMPORT
#include "mibdef.h"
#undef MIB_SCHEDULE_IMPORT

#undef MIBDEF
}__PACK__ SCHEDULE_T, *SCHEDULE_Tp;



typedef struct macfilter_entry {
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
	_ctype _cname _crepeat;

#define MIB_MACFILTER_IMPORT
#include "mibdef.h"
#undef MIB_MACFILTER_IMPORT

#undef MIBDEF
}__PACK__ MACFILTER_T, *MACFILTER_Tp;

#ifdef _SUPPORT_CAPTIVEPORTAL_PROFILE_
typedef struct capPortalAllow_entry {
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
	_ctype _cname _crepeat;

#define MIB_CAP_PORTAL_IMPORT
#include "mibdef.h"
#undef MIB_CAP_PORTAL_IMPORT

#undef MIBDEF
}__PACK__ CAP_PORTAL_T, *CAP_PORTAL_Tp;
#endif

#ifdef HOME_GATEWAY
typedef struct urlfilter_entry {	
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
	_ctype _cname _crepeat;

#define MIB_URLFILTER_IMPORT
#include "mibdef.h"
#undef MIB_URLFILTER_IMPORT

#undef MIBDEF
}__PACK__ URLFILTER_T, *URLFILTER_Tp;

typedef struct portfw_entry {
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
	_ctype _cname _crepeat;

#define MIB_PORTFW_IMPORT
#include "mibdef.h"
#undef MIB_PORTFW_IMPORT

#undef MIBDEF
}__PACK__ PORTFW_T, *PORTFW_Tp;

//MAP-E Port Mapping
typedef struct portfw_mape_entry {
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
	_ctype _cname _crepeat;

#define MIB_PORTFW_MAPE_IMPORT
#include "mibdef.h"
#undef MIB_PORTFW_MAPE_IMPORT

#undef MIBDEF
}__PACK__ PORTFW_MAPE_T, *PORTFW_MAPE_Tp;


typedef struct ipfilter_entry {
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
	_ctype _cname _crepeat;

#define MIB_IPFILTER_IMPORT
#include "mibdef.h"
#undef MIB_IPFILTER_IMPORT

#undef MIBDEF
}__PACK__ IPFILTER_T, *IPFILTER_Tp;

#ifdef SAMBA_WEB_SUPPORT
typedef struct storage_userentry {
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
	_ctype _cname _crepeat;
#define MIB_STORAGE_USER_IMPORT
#include "mibdef.h"
#undef MIB_STORAGE_USER_IMPORT

#undef MIBDEF
}__PACK__ STORAGE_USER_T, *STORAGE_USER_Tp;

typedef struct storage_groupentry {
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
	_ctype _cname _crepeat;

#define MIB_STORAGE_GROUP_IMPORT
#include "mibdef.h"
#undef MIB_STORAGE_GROUP_IMPORT

#undef MIBDEF
}__PACK__ STORAGE_GROUP_T, *STORAGE_GROUP_Tp;
typedef struct storage_shareinfoentry {
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id  ) \
	_ctype _cname _crepeat;

#define MIB_STORAGE_SHAREINFO_IMPORT
#include "mibdef.h"
#undef MIB_STORAGE_SHAREINFO_IMPORT

#undef MIBDEF
}__PACK__ STORAGE_SHAREINFO_T, *STORAGE_SHAREINFO_Tp;
#endif

typedef struct portfilter_entry {
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
	_ctype _cname _crepeat;

#define MIB_PORTFILTER_IMPORT
#include "mibdef.h"
#undef MIB_PORTFILTER_IMPORT

#undef MIBDEF
}__PACK__ PORTFILTER_T, *PORTFILTER_Tp;

typedef struct triggerport_entry {
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
	_ctype _cname _crepeat;

#define MIB_TRIGGERPORT_IMPORT
#include "mibdef.h"
#undef MIB_TRIGGERPORT_IMPORT

#undef MIBDEF
}__PACK__ TRIGGERPORT_T, *TRIGGERPORT_Tp;

#ifdef GW_QOS_ENGINE
#define MAX_QOS_NAME_LEN    15
typedef struct qos_entry {
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
	_ctype _cname _crepeat;

#define MIB_QOS_IMPORT
#include "mibdef.h"
#undef MIB_QOS_IMPORT

#undef MIBDEF
}__PACK__ QOS_T, *QOS_Tp;
#endif

#ifdef QOS_BY_BANDWIDTH
#define QOS_RESTRICT_MIN	0x01
#define QOS_RESTRICT_MAX	0x02
#define QOS_RESTRICT_IP		0x04
#define QOS_RESTRICT_MAC	0x08
#define QOS_RESTRICT_IPV6	0x10
#define QOS_RESTRICT_ALL	0x20
#define QOS_RESTRICT_PHYPORT  0x40
#define QOS_RESTRICT_DSCP     0x80
#define QOS_RESTRICT_1P       0x100

#define MAX_QOS_NAME_LEN    15

typedef struct qos_entry {
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
	_ctype _cname _crepeat;

#define MIB_IPQOS_IMPORT
#include "mibdef.h"
#undef MIB_IPQOS_IMPORT

#undef MIBDEF
}__PACK__ IPQOS_T, *IPQOS_Tp;
#endif

#ifdef QOS_OF_TR069
typedef struct qosqueue_entry {
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
	_ctype _cname _crepeat;

#define MIB_QOSQUEUE_IMPORT
#include "mibdef.h"
#undef MIB_QOSQUEUE_IMPORT

#undef MIBDEF
}__PACK__ QOSQUEUE_T, *QOSQUEUE_Tp;

typedef struct qosclass_entry {
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
	_ctype _cname _crepeat;

#define MIB_QOSCLASS_IMPORT
#include "mibdef.h"
#undef MIB_QOSCLASS_IMPORT

#undef MIBDEF
}__PACK__ QOSCLASS_T, *QOSCLASS_Tp;

typedef struct tr098_appconf_entry {	
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
	_ctype _cname _crepeat;

#define MIB_TR098_APP_CONFIG_IMPORT
#include "mibdef.h"
#undef MIB_TR098_APP_CONFIG_IMPORT

#undef MIBDEF
}__PACK__ TR098_APPCONF_T, *TR098_APPCONF_Tp;


typedef struct tr098_flowconf_entry {	
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
	_ctype _cname _crepeat;

#define MIB_TR098_FLOW_CONFIG_IMPORT
#include "mibdef.h"
#undef MIB_TR098_FLOW_CONFIG_IMPORT

#undef MIBDEF
}__PACK__ TR098_FLOWCONF_T, *TR098_FLOWCONF_Tp;

//mark_qos
typedef struct qospolicer_entry {
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
	_ctype _cname _crepeat;

#define MIB_QOSPOLICER_IMPORT
#include "mibdef.h"
#undef MIB_QOSPOLICER_IMPORT

#undef MIBDEF
}__PACK__ QOSPOLICER_T, *QOSPOLICER_Tp;

typedef struct qosqueuestats_entry {
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
	_ctype _cname _crepeat;

#define MIB_QOSQUEUESTATS_IMPORT
#include "mibdef.h"
#undef MIB_QOSQUEUESTATS_IMPORT

#undef MIBDEF
}__PACK__ QOSQUEUESTATS_T, *QOSQUEUESTATS_Tp;

#endif
#if defined(CONFIG_RTL_ETH_802DOT1X_SUPPORT)
typedef struct ethdot1x_entry {
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
	_ctype _cname _crepeat;

#define MIB_ETH_DOT1X_IMPORT
#include "mibdef.h"
#undef MIB_ETH_DOT1X_IMPORT

#undef MIBDEF
}__PACK__ ETHDOT1X_T, *ETHDOT1X_Tp;
#endif

#ifdef VPN_SUPPORT
typedef struct ipsectunnel_entry {
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
	_ctype _cname _crepeat;

#define MIB_IPSECTUNNEL_IMPORT
#include "mibdef.h"
#undef MIB_IPSECTUNNEL_IMPORT

#undef MIBDEF
}__PACK__ IPSECTUNNEL_T, *IPSECTUNNEL_Tp;
#endif // VPN_SUPPORT

#ifdef CONFIG_RTL_AIRTIME
typedef struct airtime_entry {
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
	_ctype _cname _crepeat;

#define MIB_AIRTIME_IMPORT
#include "mibdef.h"
#undef MIB_AIRTIME_IMPORT

#undef MIBDEF
}__PACK__ AIRTIME_T, *AIRTIME_Tp;
#endif /* CONFIG_RTL_AIRTIME*/

#ifdef CONFIG_IPV6
#define uint16 unsigned short
#define uint8 unsigned char
#define uint32 unsigned int
#ifdef TR181_SUPPORT
typedef struct ipv6DhcpcSendOptTbl_entry {
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
	_ctype _cname _crepeat;

#define MIB_IPV6_DHCPC_SENDOPT_IMPORT
#include "mibdef.h"
#undef MIB_IPV6_DHCPC_SENDOPT_IMPORT

#undef MIBDEF
}__PACK__ DHCPV6C_SENDOPT_T, *DHCPV6C_SENDOPT_Tp;
#endif
/*radvd*/
struct AdvPrefix {
        uint16    		Prefix[8];
        uint8                  PrefixLen;
        uint8                     AdvOnLinkFlag;
        uint8                     AdvAutonomousFlag;
        uint32                AdvValidLifetime;
        uint32                AdvPreferredLifetime;
 
        /* Mobile IPv6 extensions */
        uint8                     AdvRouterAddr;
 
        /* 6to4 extensions */
        char                    if6to4[IFNAMESIZE];
        uint8                     enabled;

#ifdef CONFIG_IPV6_CE_ROUTER_SUPPORT
		/* prefix mode: Manually, PD, ULA prefix */
		uint8			prefix_mode;
#endif
}__PACK__;

struct Interface {
	  char                    Name[IFNAMESIZE]; /* interface name */
        uint32                  MaxRtrAdvInterval;
        uint32                  MinRtrAdvInterval;
        uint32                  MinDelayBetweenRAs;
        uint8                    AdvManagedFlag;
        uint8                    AdvOtherConfigFlag;
        uint32                   AdvLinkMTU;
        uint32			   AdvReachableTime;
        uint32                  AdvRetransTimer;
        uint8                   AdvCurHopLimit;
        uint16                  AdvDefaultLifetime;
        char                    AdvDefaultPreference[IFNAMESIZE];
        uint8                       AdvSourceLLAddress;
        uint8                       UnicastOnly;
	 struct AdvPrefix prefix[MAX_PREFIX_NUM];
}__PACK__;

typedef struct radvdCfgParam_s
{
	uint8 enabled;
       /*support br0 only*/
	struct Interface interface;
}__PACK__ radvdCfgParam_t, *radvdCfgParam_Tp;

struct duid_t{
	uint16 duid_type;
	uint16 hw_type;
	uint8 mac[6];		
};


/*dnsv6*/
struct rrResource
{
	char domainName[MAX_DNAME_SIZE];
	uint16 address[8];
}__PACK__;

typedef struct dnsv6CfgParam_s
{
       uint8 enabled;
	/*default name myrouter*/
	char routerName[NAMSIZE];
	struct rrResource rr[RR_MAX_NUM];
}__PACK__ dnsv6CfgParam_t, *dnsv6CfgParam_Tp;

/*dhcp6s*/
typedef struct dhcp6sCfgParam_s
{
       uint8 	enabled; 
	 char  	DNSaddr6[48];
#ifdef CONFIG_IPV6_CE_ROUTER_SUPPORT
	uint8	addr6PrefixMode;
#endif
	 char  	addr6PoolS[48];
 	 char  	addr6PoolE[48];
	/*default name interface*/
	char interfaceNameds[NAMSIZE];
	
}__PACK__ dhcp6sCfgParam_t, *dhcp6sCfgParam_Tp;

/*dhcp6pd*/
typedef struct dhcp6pdCfgParam_s
{
	 uint32 sla_len;		/* SLA ID length in bits */
	 uint32 sla_id;			/* need more than 32bits? */
	 char 	ifName[NAMSIZE];
}__PACK__ dhcp6pdCfgParam_t, *dhcp6pdCfgParam_Tp;
	
/*dhcp6c*/
typedef struct dhcp6cCfgParam_s
{
    uint8 	enabled;
	dhcp6pdCfgParam_t	dhcp6pd;	
	char 	ifName[NAMSIZE];
}__PACK__ dhcp6cCfgParam_t, *dhcp6cCfgParam_Tp;



/*IPv6 Addr*/
typedef struct addrIPv6CfgParam_s
{
        int        enabled;      /* 0:off 1:on */
        int        prefix_len[2];
        uint16     addrIPv6[2][8];
}__PACK__ addrIPv6CfgParam_t,*daddrIPv6CfgParam_Tp;

/*IPv6 Addr*/
typedef struct addr6CfgParam_s
{
        int        prefix_len;
        uint16     addrIPv6[8];
}__PACK__ addr6CfgParam_t,*addr6CfgParam_Tp;

/*Tunnel*/
typedef struct tunnelCfgParam_s
{
       uint8 	enabled;	
}__PACK__ tunnelCfgParam_t, *tunnelCfgParam_Tp;
#endif

#if 1 /* WNC-NMR0000-Jog-20160801, IPv4 packet filter */
typedef struct packetfilter_entry {
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
	_ctype _cname _crepeat;

#define MIB_PACKETFILTER_IMPORT
#include "mibdef.h"
#undef MIB_PACKETFILTER_IMPORT

#undef MIBDEF
}__PACK__ PACKETFILTER_T, *PACKETFILTER_Tp;
#endif

#ifdef TR181_SUPPORT
typedef struct dnsClientServerTbl_entry {
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
	_ctype _cname _crepeat;

#define MIB_DNS_CLIENT_SERVER_IMPORT
#include "mibdef.h"
#undef MIB_DNS_CLIENT_SERVER_IMPORT

#undef MIBDEF
}__PACK__ DNS_CLIENT_SERVER_T, *DNS_CLIENT_SERVER_Tp;

#endif

#if defined(_PRMT_X_TELEFONICA_ES_DHCPOPTION_)
typedef struct dhcpoption_entry {
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
	_ctype _cname _crepeat;

#define MIB_DHCPDOPTION_IMPORT
#include "mibdef.h"
#undef MIB_DHCPDOPTION_IMPORT

#undef MIBDEF
}__PACK__ MIB_CE_DHCP_OPTION_T, *MIB_CE_DHCP_OPTION_Tp;

typedef struct dhcp_serving_pool {
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
	_ctype _cname _crepeat;

#define MIB_DHCPS_SERVING_POOL_IMPORT
#include "mibdef.h"
#undef MIB_DHCPS_SERVING_POOL_IMPORT

#undef MIBDEF
}__PACK__ DHCPS_SERVING_POOL_T,*DHCPS_SERVING_POOL_Tp;
#endif /* #if defined(_PRMT_X_TELEFONICA_ES_DHCPOPTION_) */

#if defined(_PRMT_X_TELEFONICA_ES_DHCPOPTION_) //do we need this?
typedef struct atmvc_entry {
	unsigned int ifIndex;	// resv | media | ppp | vc
	unsigned char vpi;
	unsigned char qos;
	unsigned short vci;
	unsigned short pcr;
	unsigned short scr;
	unsigned short mbs;
	unsigned int cdvt;
	unsigned char encap;
	unsigned char napt;
	unsigned char cmode;
	unsigned char brmode;	// 0: transparent bridging, 1: PPPoE bridging
	unsigned char pppUsername[MAX_PPP_NAME_LEN+1];
	unsigned char pppPassword[MAX_NAME_LEN];
	unsigned char pppAuth;	// 0:AUTO, 1:PAP, 2:CHAP
	unsigned char pppACName[MAX_NAME_LEN];
	unsigned char pppServiceName[MAX_NAME_LEN];
	unsigned char pppCtype;
	unsigned short pppIdleTime;
#ifdef CONFIG_USER_IP_QOS
	unsigned char enableIpQos;
#endif
#ifdef CONFIG_IGMPPROXY_MULTIWAN
	unsigned char enableIGMP;
#endif
	unsigned char ipDhcp;
	unsigned char rip;
	unsigned char ipAddr[IP_ADDR_LEN];
	unsigned char remoteIpAddr[IP_ADDR_LEN];
	unsigned char dgw;
	unsigned int mtu;
	unsigned char enable;
	unsigned char netMask[IP_ADDR_LEN];	// Jenny; Subnet mask
	unsigned char ipunnumbered;	// Jenny, unnumbered(1)
// Mason Yu. combine_1p_4p_PortMapping, enable_802_1p_090722
#if defined(ITF_GROUP) || defined(NEW_PORTMAPPING)
	// used for VLAN mapping
	unsigned char vlan;
	unsigned short vid;
	unsigned short vprio;	// 802.1p priority bits
	unsigned char vpass;	// vlan passthrough
	// used for interface group
	unsigned short itfGroup;
#endif
	unsigned long cpePppIfIndex;   // Mason Yu. Remote Management
	unsigned long cpeIpIndex;      // Mason Yu. Remote Management

#ifdef _CWMP_MIB_ /*jiunming, for cwmp-tr069*/
	unsigned char connDisable; //0:enable, 1:disable
	unsigned int ConDevInstNum;
	unsigned int ConIPInstNum;
	unsigned int ConPPPInstNum;
	unsigned short autoDisTime;	// Jenny, TR-069 PPP AutoDisconnectTime
	unsigned short warnDisDelay;	// Jenny, TR-069 PPP WarnDisconnectDelay

#ifdef _PRMT_TR143_
	unsigned char TR143UDPEchoItf;
#endif //_PRMT_TR143_
#ifdef _PRMT_X_CT_COM_WANEXT_
	unsigned short ServiceList;
#endif //_PRMT_X_CT_COM_WANEXT_
#endif //_CWMP_MIB_
unsigned char WanName[MAX_NAME_LEN];	//Name of this wan connection
#ifdef CONFIG_USER_PPPOE_PROXY
	unsigned char PPPoEProxyEnable;
	unsigned int  PPPoEProxyMaxUser;
#endif //CONFIG_USER_PPPOE_PROXY
	unsigned int applicationtype;  //TR069(1), INTERNET(2), IPTV(4), VOICE(8)
	//char applicationname[MAX_NAME_LEN];
#ifdef CONFIG_SPPPD_STATICIP
	unsigned char pppIp;	// Jenny, static PPPoE
#endif
#ifdef CONFIG_USER_WT_146
	unsigned char	bfd_enable;
	unsigned char	bfd_opmode;
	unsigned char	bfd_role;
	unsigned int	bfd_mintxint;
	unsigned int	bfd_minrxint;
	unsigned int	bfd_minechorxint;
	unsigned char	bfd_detectmult;
	unsigned char	bfd_authtype;
	unsigned char	bfd_authkeyid;
	unsigned char	bfd_authkeylen;
	unsigned char	bfd_authkey[BFD_MAX_KEY_LEN];
	unsigned char	bfd_dscp;
	unsigned char	bfd_ethprio;
#endif //CONFIG_USER_WT_146

#ifdef CONFIG_IPV6
	unsigned char	IpProtocol;          // 1: IPv4, 2:IPv6, 3: IPv4 and IPv6
	unsigned char	AddrMode;            // Bitmap, bit0: Slaac, bit1: Static, bit2: DS-Lite , bit3: 6rd
	unsigned char Ipv6Addr[IP6_ADDR_LEN];
	unsigned char RemoteIpv6Addr[IP6_ADDR_LEN];
	unsigned char Ipv6AddrPrefixLen;
	unsigned char Ipv6Dhcp;            // 0: disable, 1: enable
	unsigned char	Ipv6DhcpRequest;     // Bitmap, bit0: Request Address, bit1: Request Prefix
	unsigned char RemoteIpv6EndPointAddr[IP6_ADDR_LEN];
#endif
    //6rd
#if defined(CONFIG_IPV6) && defined(CONFIG_IPV6_SIT_6RD)
	unsigned char SixrdBRv4IP[IP_ADDR_LEN];
	unsigned char SixrdIPv4MaskLen;
	unsigned char SixrdPrefix[IP6_ADDR_LEN];
	unsigned char SixrdPrefixLen;
#endif
	unsigned char MacAddr[MAC_ADDR_LEN];
#ifdef CONFIG_RTK_RG_INIT
	int rg_wan_idx;
#endif
#if defined(CONFIG_GPON_FEATURE)
	unsigned char sid;
#endif
} __PACK__ MIB_CE_ATM_VC_T, *MIB_CE_ATM_VC_Tp;
#endif /* #if defined(_PRMT_X_TELEFONICA_ES_DHCPOPTION_) */

#endif // HOME_GATEWAY

#ifdef TLS_CLIENT
typedef struct certroot_entry {
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
	_ctype _cname _crepeat;

#define MIB_CERTROOT_IMPORT
#include "mibdef.h"
#undef MIB_CERTROOT_IMPORT

#undef MIBDEF
}__PACK__ CERTROOT_T, *CERTROOT_Tp;
typedef struct certUser_entry {
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
	_ctype _cname _crepeat;

#define MIB_CERTUSER_IMPORT
#include "mibdef.h"
#undef MIB_CERTUSER_IMPORT

#undef MIBDEF
}__PACK__ CERTUSER_T, *CERTUSER_Tp;
#endif
#ifdef HOME_GATEWAY
#ifdef ROUTE_SUPPORT
typedef struct staticRoute_entry {
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
	_ctype _cname _crepeat;

#define MIB_STATICROUTE_IMPORT
#include "mibdef.h"
#undef MIB_STATICROUTE_IMPORT

#undef MIBDEF
}__PACK__ STATICROUTE_T, *STATICROUTE_Tp;
#endif
#endif

typedef struct dhcpRsvdIP_entry {	
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
	_ctype _cname _crepeat;

#define MIB_DHCPRSVDIP_IMPORT
#include "mibdef.h"
#undef MIB_DHCPRSVDIP_IMPORT

#undef MIBDEF
}__PACK__ DHCPRSVDIP_T, *DHCPRSVDIP_Tp;

typedef struct wlanwds_entry {
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
	_ctype _cname _crepeat;

#define MIB_WDS_IMPORT
#include "mibdef.h"
#undef MIB_WDS_IMPORT
}__PACK__ WDS_T, *WDS_Tp;


#ifdef FAST_BSS_TRANSITION
typedef struct wlanftkh_entry {
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
	_ctype _cname _crepeat;

#define MIB_FTKH_IMPORT
#include "mibdef.h"
#undef MIB_FTKH_IMPORT
}__PACK__ FTKH_T, *FTKH_Tp;
#endif
#ifdef WLAN_PROFILE
typedef struct wlan_profile_entry {
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
	_ctype _cname _crepeat;

#define MIB_WLAN_PROFILE_IMPORT
#include "mibdef.h"
#undef MIB_WLAN_PROFILE_IMPORT
#undef MIBDEF
}__PACK__ WLAN_PROFILE_T, *WLAN_PROFILE_Tp;
#endif

#if defined(VLAN_CONFIG_SUPPORTED) 
typedef struct vlan_lanconfig_entry {	
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
	_ctype _cname _crepeat;

#define MIB_VLAN_CONFIG_IMPORT
#include "mibdef.h"
#undef MIB_VLAN_CONFIG_IMPORT

#undef MIBDEF
}__PACK__ VLAN_CONFIG_T, *VLAN_CONFIG_Tp;
#endif

#if defined(CONFIG_8021Q_VLAN_SUPPORTED) 
typedef struct vlan_config_entry {	
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
	_ctype _cname _crepeat;

#define MIB_VLAN_CONFIG_IMPORT
#include "mibdef.h"
#undef MIB_VLAN_CONFIG_IMPORT

#undef MIBDEF
}__PACK__ VLAN_CONFIG_T, *VLAN_CONFIG_Tp;
#endif

typedef struct hw_wlan_setting {
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
	_ctype _cname _crepeat;

#define MIB_HW_WLAN_IMPORT
#include "mibdef.h"
#undef MIB_HW_WLAN_IMPORT

#undef MIBDEF
}__PACK__ HW_WLAN_SETTING_T, *HW_WLAN_SETTING_Tp;

typedef struct hw_setting {
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
	_ctype _cname _crepeat;

#define MIB_HW_IMPORT
#include "mibdef.h"
#undef MIB_HW_IMPORT

#undef MIBDEF
}__PACK__ HW_SETTING_T, *HW_SETTING_Tp;

typedef struct config_wlan_setting {
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
	_ctype _cname _crepeat;

#define MIB_CONFIG_WLAN_SETTING_IMPORT
#include "mibdef.h"
#undef MIB_CONFIG_WLAN_SETTING_IMPORT

#undef MIBDEF	
}__PACK__ CONFIG_WLAN_SETTING_T, *CONFIG_WLAN_SETTING_Tp;

#if defined( MULTI_WAN_SUPPORT )
typedef struct wanIface_entry {
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id) \
	_ctype _cname _crepeat;

#define MIB_WANIFACE_IMPORT
#include "mibdef.h"
#undef MIB_WANIFACE_IMPORT

#undef MIBDEF
}__PACK__ WANIFACE_T, *WANIFACE_Tp;

#endif
#ifdef CUSTOMER_HW_SETTING_SUPPORT
typedef struct customer_hw_setting {
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl ) \
	_ctype _cname _crepeat;

#define MIB_CUSTOMER_HW_IMPORT
#include "mibdef.h"
#undef MIB_CUSTOMER_HW_IMPORT

#undef MIBDEF
}__PACK__ CUSTOMER_HW_SETTING_T, *CUSTOMER_HW_SETTING_Tp;
#endif

#ifdef CONFIG_APP_TR069
#if defined(WLAN_SUPPORT)
typedef struct cwmp_wlanconf_entry {

 #define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
	_ctype _cname _crepeat;

#define MIB_CWMP_WLANCONF_IMPORT
#include "mibdef.h"
#undef MIB_CWMP_WLANCONF_IMPORT

#undef MIBDEF		
	
} __PACK__ CWMP_WLANCONF_T, *CWMP_WLANCONF_Tp;
#endif //#if defined(WLAN_SUPPORT)
#endif//#ifdef CONFIG_APP_TR069

#ifdef RTK_CAPWAP
typedef struct {
#define MIBDEF(_ctype,	  _cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
		  _ctype _cname _crepeat;
  #define MIB_CAPWAP_WLAN_CONFIG_IMPORT
	#include "mibdef.h"
  #undef MIB_CAPWAP_WLAN_CONFIG_IMPORT
#undef MIBDEF	  
} __PACK__ CAPWAP_WLAN_CONFIG_T, *CAPWAP_WLAN_CONFIG_Tp;
typedef struct {
  #define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
		_ctype _cname _crepeat;
    #define MIB_CAPWAP_WTP_CONFIG_IMPORT
      #include "mibdef.h"
    #undef MIB_CAPWAP_WTP_CONFIG_IMPORT
  #undef MIBDEF		
} __PACK__ CAPWAP_WTP_CONFIG_T, *CAPWAP_WTP_CONFIG_Tp;
#endif // #ifdef RTK_CAPWAP

#ifdef CONFIG_APP_ACCESSTIMER
// WNC-NMR0000-JDR230-HENG-I-CHEN-2014-01-05: Implement Access Timer feature #BEGIN
typedef struct access_timer_entry {
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id  ) \
	_ctype _cname _crepeat;

#define MIB_ACCESS_TIMER_IMPORT
#include "mibdef.h"
#undef MIB_ACCESS_TIMER_IMPORT

#undef MIBDEF
}__PACK__ ACCESS_TIMER_T, *ACCESS_TIMER_Tp;
// WNC-NMR0000-JDR230-HENG-I-CHEN-2014-01-05: Implement Access Timer feature #END
#endif	//#ifdef CONFIG_APP_ACCESSTIMER

// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #BEGIN
#ifdef CONFIG_APP_INIQUITOUS_CLIENT
typedef struct iniquitous_sta_entry {
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id  ) \
	_ctype _cname _crepeat;

#define MIB_INIQUITOUS_CLIENT_IMPORT
#include "mibdef.h"
#undef MIB_INIQUITOUS_CLIENT_IMPORT

#undef MIBDEF
}__PACK__ INIQUITOUS_STA_T, *INIQUITOUS_STA_Tp;
// WNC-NMR0000-JDR230-HENG-I-CHEN-2014-01-05: Implement Access Timer feature #END
#endif	//#ifdef CONFIG_APP_INIQUITOUS_CLIENT
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #END

typedef struct config_setting {
#define MIBDEF(_ctype,	_cname, _crepeat, _mib_name, _mib_type, _mib_parents_ctype, _default_value, _next_tbl, decision_id, reinit_id ) \
_ctype _cname _crepeat;

#define MIB_IMPORT
#include "mibdef.h"
#undef MIB_IMPORT

#undef MIBDEF
}__PACK__ APMIB_T, *APMIB_Tp;

#ifdef HEADER_LEN_INT
typedef struct hw_param_header {
	unsigned char signature[SIGNATURE_LEN];  // Tag + version
	unsigned short len;
}__PACK__ HW_PARAM_HEADER_T, *HW_PARAM_HEADER_Tp;
#endif

/* Config file header */
typedef struct param_header {
	unsigned char signature[SIGNATURE_LEN];  // Tag + version
#ifdef HEADER_LEN_INT
	unsigned int len;
#else
	unsigned short len;
#endif
}__PACK__ PARAM_HEADER_T, *PARAM_HEADER_Tp;

/* Firmware image file header */
typedef struct img_header {
	unsigned char signature[SIGNATURE_LEN];
	unsigned int startAddr;
	unsigned int burnAddr;
	unsigned int len;
}__PACK__ IMG_HEADER_T, *IMG_HEADER_Tp;

/* Web page file header */
typedef IMG_HEADER_T WEB_HEADER_T;
typedef IMG_HEADER_Tp WEB_HEADER_Tp;
#ifdef TLS_CLIENT
typedef IMG_HEADER_T CERT_HEADER_T;
typedef IMG_HEADER_Tp CERT_HEADER_Tp;
#endif
typedef struct _file_entry {
	char name[MAXFNAME];
	unsigned int size;
}__PACK__ FILE_ENTRY_T, *FILE_ENTRY_Tp;

#ifdef COMPRESS_MIB_SETTING
/* Compress config setting file header */
#if 1
#define	COMP_TRACE	fprintf
#else
#define COMP_TRACE(...) do {} while(0)
#endif

#define COMP_SIGNATURE_LEN			6
#define COMP_HS_SIGNATURE			"COMPHS"
#ifdef CUSTOMER_HW_SETTING_SUPPORT
#define COMP_US_SIGNATURE			"COMPUS"
#endif
#define COMP_CS_SIGNATURE			"COMPCS"
#define COMP_DS_SIGNATURE			"COMPDS"
typedef struct compress_mib_header {
	unsigned char signature[COMP_SIGNATURE_LEN];
	unsigned short compRate;
	unsigned int compLen;
}__PACK__ COMPRESS_MIB_HEADER_T, *COMPRESS_MIB_HEADER_Tp;

#endif // #ifdef COMPRESS_MIB_SETTING

#ifdef WIN32
#pragma pack()
#endif
typedef enum { 
		BYTE_T, 
		WORD_T, 
		STRING_T, 
		BYTE5_T, 
		BYTE6_T, 
		BYTE13_T, 
		IA_T, 
		DWORD_T, 
		BYTE_ARRAY_T, 	
		DWORD_ARRAY_T,
#ifdef HOME_GATEWAY
#ifdef CONFIG_IPV6
		RADVDPREFIX_T,
		DNSV6_T,
		DHCPV6S_T,
		DHCPV6C_T,
		ADDR6_T,
		ADDRV6_T,
		TUNNEL6_T,
#endif
#endif
#ifdef VOIP_SUPPORT 
		VOIP_T,
#endif
#ifdef RTK_CAPWAP
		CAPWAP_ALL_WLANS_CONFIG_T,
#endif
	/* upper are Non-table array type */
		
	/* below are table array type */			
		TABLE_LIST_T,	
		WLAC_ARRAY_T,
#ifdef TR181_SUPPORT
#ifdef CONFIG_IPV6
		DHCPV6C_SENDOPT_ARRAY_T,
#endif
		DNS_CLIENT_SERVER_ARRAY_T,
#endif
	DHCPRSVDIP_ARRY_T,	
#ifdef HOME_GATEWAY
		PORTFW_ARRAY_T, 
		PORTFW_MAPE_ARRAY_T, 
		PORTFW_MAPE_PAIR_ARRAY_T,
		IPFILTER_ARRAY_T, 
		PORTFILTER_ARRAY_T,
#if 1 /* WNC-NMR0000-Jog-20160801, IPv4 packet filter */
		PACKETFILTERWAN_ARRAY_T,
		PACKETFILTERLAN_ARRAY_T,
#endif		
		/* IPv6 packet filter */
		PACKETFILTERWAN_V6_ARRAY_T,
		PACKETFILTERLAN_V6_ARRAY_T,
		MACFILTER_ARRAY_T, 
		URLFILTER_ARRAY_T,
		TRIGGERPORT_ARRAY_T,
#ifdef ROUTE_SUPPORT		
		STATICROUTE_ARRAY_T,
#endif		

#if defined(_PRMT_X_TELEFONICA_ES_DHCPOPTION_)
		DHCP_SERVER_OPTION_ARRAY_T, 
		DHCP_CLIENT_OPTION_ARRAY_T, 
		DHCPS_SERVING_POOL_ARRAY_T, 
#endif

#ifdef _SUPPORT_CAPTIVEPORTAL_PROFILE_
		CAP_PORTAL_ALLOW_ARRAY_T,
#endif
#ifdef VPN_SUPPORT
		IPSECTUNNEL_ARRAY_T,
#endif
#endif // #ifdef HOME_GATEWAY		
		WDS_ARRAY_T,
#ifdef FAST_BSS_TRANSITION
		FTKH_ARRAY_T,
#endif
#ifdef TLS_CLIENT		
		CERTROOT_ARRAY_T,
		CERTUSER_ARRAY_T,
#endif		

#if defined(GW_QOS_ENGINE) || defined(QOS_BY_BANDWIDTH)
		QOS_ARRAY_T,
#endif

#ifdef QOS_OF_TR069
       QOS_CLASS_ARRAY_T,
       QOS_QUEUE_ARRAY_T,
       TR098_APPCONF_ARRAY_T,
       TR098_FLOWCONF_ARRAY_T,
       QOS_POLICER_ARRAY_T, //mark_qos
       QOS_QUEUESTATS_ARRAY_T, 
#endif


#ifndef CONFIG_WNC_REMOVE_MESH
//#if defined(CONFIG_RTK_MESH) && defined(_MESH_ACL_ENABLE_) Keith remove
		MESH_ACL_ARRAY_T,
//#endif
#endif
	        SCHEDULE_ARRAY_T, 
#if defined(VLAN_CONFIG_SUPPORTED)
	        VLANCONFIG_ARRAY_T,
#endif
#if defined(CONFIG_8021Q_VLAN_SUPPORTED)
	        VLAN_ARRAY_T,
#endif

#ifdef WLAN_PROFILE
		PROFILE_ARRAY_T,
#endif
#ifdef CONFIG_APP_TR069
#if defined(WLAN_SUPPORT)
	CWMP_WLANCONF_ARRAY_T,
#endif

#endif//#ifdef CONFIG_APP_TR069
#ifdef HOME_GATEWAY
#ifdef SAMBA_WEB_SUPPORT
	STORAGE_USER_ARRAY_T,
	STORAGE_GROUP_ARRAY_T,
	STORAGE_SHAREINFO_ARRAY_T,
#endif
#endif
#if defined(CONFIG_RTL_ETH_802DOT1X_SUPPORT)
	 ETHDOT1X_ARRAY_T,
#endif	     

#ifdef RTK_CAPWAP
	CAPWAP_WTP_CONFIG_ARRAY_T,
#endif
#ifdef MULTI_WAN_SUPPORT 
	WANIFACE_ARRAY_T
#endif	
#ifdef CONFIG_RTL_AIRTIME
		AIRTIME_ARRAY_T, 
#endif
// WNC-NMR0000-JDR230-HENG-I-CHEN-2014-01-05: Implement Access Timer feature #BEGIN
#ifdef CONFIG_APP_ACCESSTIMER
    ACCESS_TIMER_ARRAY_T,
#endif	//#ifdef CONFIG_APP_ACCESSTIMER
// WNC-NMR0000-JDR230-HENG-I-CHEN-2014-01-05: Implement Access Timer feature #END
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #BEGIN
    INIQUITOUS_STA_ARRAY_T,
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #END
	     } TYPE_T;


//////////////////////////////////////////////////////////
int apmib_init_HW(void);
int apmib_init(void);
int apmib_reinit(void);
char *apmib_hwconf(void);
char * apmib_load_data_to_csconf(char* dataSource);
char *apmib_csconf(void);
char *apmib_dsconf(void);
//WNC-D2R030-HENGI
char *apmib_btconf(void *conf, int size);
//WNC-NMRXXXX-Yuan-I-Chou-20160811, Configured value restoration support
int apmib_get_ds_mib(int length);
char *apmib_ds_from_code(void);
int save_cs_ds_to_file(void);
//WNC-NMRXXXX-Yuan-I-Chou-20160811, Configured value restoration support End
int apmib_get(int id, void *value);
int apmib_getDef(int id, void *value);
//WNC-D2R030-HENGI
int apmib_getBoot(int id, void *value);
int apmib_set(int id, void *value);
int apmib_setDef(int id, void *value);
//WNC-D2R030-HENGI
int apmib_setBoot(int id, void *value);
int apmib_update(CONFIG_DATA_T type);
int apmib_updateDef(void);
int apmib_updateFlash(CONFIG_DATA_T type, char *data, int len, int force, int ver);
int update_linkchain(int fmt, void *Entry_old, void *Entry_new, int type_size);
int mibtbl_check(void);
#ifdef DEFSETTING_AUTO_UPDATE
int apmib_dsAutoUpdate(void);
#endif
//char* get_time();
	
extern APMIB_Tp pMib, pMibDef;
extern HW_SETTING_Tp pHwSetting;
#ifdef HEADER_LEN_INT
extern HW_PARAM_HEADER_T hsHeader;
extern PARAM_HEADER_T dsHeader, csHeader;
#else
extern PARAM_HEADER_T hsHeader, dsHeader, csHeader;
#endif
#ifdef DEFSETTING_AUTO_UPDATE
extern APMIB_Tp pMibLastDef;
extern PARAM_HEADER_T lastDsHeader;
#endif
#ifdef CUSTOMER_HW_SETTING_SUPPORT
extern PARAM_HEADER_T customerHwHeader;
#endif

extern int wlan_idx;
extern int vwlan_idx;
#ifdef MULTI_WAN_SUPPORT
extern int wan_idx;
#endif
#ifdef HTTP_FILE_SERVER_HTM_UI
#define PATH_MAX_LEN 256
#define FILE_INFO_MAX_LEN 64
extern char httpfile_dirpath[PATH_MAX_LEN];
extern char httpfile_type;
extern char httpfile_order;
#endif
#if 1 /* WNC-NMR0000-Jog-Lin-20151221, store select SSID and encrypt method temporarily for site survey responsive GUI */
extern char selectSSID[128];
extern char selectBSSID[128];
extern char selectEncryptStr[128];
extern int selectEncrypt;
extern int selectWlanIdx;
extern int selectChannel;
#endif /* WNC-NMR0000-Jog-Lin-20151221, end */
#define grayOutWPS "/var/web/grayOutWPS"	/* WNC-NMR000-Libera-20120608- for Spec. 1.8 */
#define rakurakuRun "/tmp/wzcm_status"	/* WNC-CheeperSW:0513-Libera-20120627-  Hide vap1 status when rakuraku start */
#if 1 /* WNC-NMR0000-Jog-20160801, IPv4 packet filter */
extern char addIface[8];
#endif

#ifdef GW_QOS_ENGINE
extern void getVal12(char *value, char **p1, char **p2, char **p3, char **p4, char **p5, char **p6, char **p7,
                                char **p8, char **p9, char **p10, char **p11, char **p12);
#define QOS_FORMAT 	("%d, %d, %d, %s, %s, %d, %d, %s, %s, %d, %d, %s")
#endif

#ifdef QOS_BY_BANDWIDTH
//#define QOS_FORMAT 	("%d, %s, %d, %s, %s, %d, %s")
#define QOS_FORMAT 	("%d, %02x%02x%02x%02x%02x%02x, %d, %s, %s, %d, %d, %s, %s")
#endif

#if CONFIG_APMIB_SHARED_MEMORY == 1
#define HWCONF_SHM_KEY	0
#define DSCONF_SHM_KEY	1
#define CSCONF_SHM_KEY	2

#if 0
#ifdef AP_CONTROLER_SUPPORT
#define CONF_SHM_VFLASH_KEY 3
int apmib_virtual_flash_malloc();

#endif
#ifdef CUSTOMER_HW_SETTING_SUPPORT
#define CUSTOMER_HW_SHM_KEY 3
#endif
#endif // SDK 3.4.10.B3
#ifdef DEFSETTING_AUTO_UPDATE
#define LAST_DSCONF_SHM_KEY 4
#endif
//WNC-D2R030-HENGI
#define BTCONF_SHM_KEY	3

//WNC-NMRXXXX-Yuan-I-Chou-20160811, Configured value restoration support
#define DS_FROM_CODE_SHM_KEY 4
//WNC-NMRXXXX-Yuan-I-Chou-20160811, Configured value restoration support End

int apmib_sem_lock(void);
int apmib_sem_unlock(void);
int apmib_shm_free(void *shm_memory, int shm_key);
#endif

//#ifdef CONFIG_IPV6
#ifdef TR181_SUPPORT
int tr181_ipv6_get(char * name,void * value);
int tr181_ipv6_set(char * name,void * value);
#endif
//#endif
//#if defined(CONFIG_USBDISK_UPDATE_IMAGE)
#define USB_UPLOAD_FORM_PATH "/tmp/usb/sda1/fw.bin"
//#endif
//### add by sen_liu 2011.4.21 sync the system log update (enlarge from 1 pcs to 8 pcs) to  SDKv2.5 from kernel 2.4
#define RINGLOG
#ifdef RINGLOG /* ring log */
#define MAX_LOG_SIZE	8  /* unit is kbyte */
#define LOG_SPLIT		7  /* can't greater than 99 */
	/*
		for /var/log/messages.(LOG_SPLIT-1) to /var/log/messages.0 and then  /var/log/messages
		ex: LOG_SPLIT = 7, we will have
		/var/log/messages.6
			...
		/var/log/messages.0
		/var/log/messages
	*/
#endif /* ring log */
typedef enum { 
	HW_MIB_AREA=1, 
	HW_MIB_WLAN_AREA,
	DEF_MIB_AREA,
	DEF_MIB_WLAN_AREA,
#ifdef MULTI_WAN_SUPPORT
	DEF_MIB_WAN_AREA,
#endif

	MIB_AREA,
	MIB_WLAN_AREA,
#ifdef MULTI_WAN_SUPPORT
	MIB_WAN_AREA,
#endif
	MIB_AREA_NUM
} CONFIG_AREA_T;

//### end
void set_timeZone(void);
#ifdef MIB_TLV
#ifdef RTK_REINIT_SUPPORT
#include "rtkEvent.h"
#define REINIT_MIBCHANGE_ARGS_FILE "/var/tmp/reinit_changemib_args"
typedef enum 
{
	DECISION_BEGINFUNC_FUNC_ID=0,
	DECISION_NULL_FUNC_ID,
	DECISION_BRIDGE_BIND_FUNC_ID,
	DECISION_LAN_IP_FUNC_ID,
	DECISION_LAN_MAC_FUNC_ID,
	DECISION_NTP_ENABLE_FUNC_ID,
	DECISION_REINIT_ALL_FUNC_ID,
	DECISION_WISP_WAN_ID_FUNC_ID,
	DECISION_WLAN_DISABLE_FUNC_ID=100,
	DECISION_WLAN_PROPERTY_FUNC_ID,
	DECISION_WLAN_REPEATER_FUNC_ID,
	DECISION_WLAN_SCHEDULE_FUNC_ID,
	DECISION_WLAN_APP_FUNC_ID,
#ifdef WLAN_PROFILE
	DECISION_WLAN_PROFILE_FUNC_ID,
#endif
	DECISION_WLAN_BLOCK_RELAY_ID,
		/*...*/
	DECISION_END_FUNC_ID,

	
	REINIT_BEGIN_FUNC_ID=200,
	REINIT_NULL_FUNC_ID,
	REINIT_WLAN_FUNC_ID=300,
	REINIT_WLAN_BLOCK_RELAY_FUNC_ID,
	REINIT_WLAN_SCHEDULE_FUNC_ID,
	REINIT_WLAN_APP_FUNC_ID,
	REINIT_WLAN_END,
	
	REINIT_SYSTEM_TIME_FUNC_ID=400,
	REINIT_SYSTEM_PASSWD_FUNC_ID,
	REINIT_SYSTEM_LOG_FUNC_ID,
#ifdef CONFIG_CPU_UTILIZATION
	REINIT_SYSTEM_CPU_UTILIZATION_FUNC_ID,
#endif
	REINIT_SYSTEM_END,
	REINIT_LAN_FUNC_ID=500,
	REINIT_LAN_MAC_FUNC_ID,
	REINIT_LAN_STP_FUNC_ID,
	REINIT_LAN_END,
	INIT_MISC_FUNC_ID,
	REINIT_LAN_APP_BEGIN=600,
	REINIT_LAN_APP_DHCP_FUNC_ID,
#ifdef CONFIG_DOMAIN_NAME_QUERY_SUPPORT
	REINIT_LAN_APP_DOMAIN_QUERY_DNRD_FUNC_ID,
#endif
#ifndef STAND_ALONE_MINIUPNP
	REINIT_LAN_APP_MINIUPNP_FUNC_ID,
#endif
#ifdef CONFIG_AUTO_DHCP_CHECK
	REINIT_LAN_APP_Auto_DHCP_CHECK_FUNC_ID,
#endif
#ifdef SAMBA_WEB_SUPPORT
	REINIT_LAN_APP_SAMBA_WEB_FUNC_ID,
#endif
#if defined(CONFIG_APP_TR069)	
	REINIT_LAN_APP_TR069_FUNC_ID,
#endif
#if defined(CONFIG_RTL_ETH_802DOT1X_SUPPORT)
	REINIT_LAN_APP_ETH_802DOT1X_FUNC_ID,
#endif
#ifdef RTK_CAPWAP	
	REINIT_LAN_APP_CAPWAP_FUNC_ID,
#endif
	REINIT_LAN_APP_END,
	REINIT_WANAPP_NTP_FUNC_ID=700,
	REINIT_WAN_START_FUNC_ID,
#ifdef DOS_SUPPORT
	REINIT_WAN_DOS_FUNC_ID,
#endif
	REINIT_FIREWALL_DMZ_ID,
	REINIT_FIREWALL_PORTFORWARD_ID,
	REINIT_FIREWALL_PORTFORWARD_MAPE_ID,
	REINIT_FIREWALL_URLFILTER_ID,	
	REINIT_FIREWALL_MACFILTER_ID,
	REINIT_FIREWALL_IPFILTER_ID,	
	REINIT_FIREWALL_PORTFILTER_ID,
#if 1 /* WNC-NMR0000-Jog-20160801, IPv4 packet filter */
	REINIT_FIREWALL_PACKETFILTER_ID,
#endif
	REINIT_FIREWALL_PINGACCESS_ID,
	REINIT_FIREWALL_WEBACCESS_ID,
	REINIT_STAITC_ROUTE_ID,
	/*...*/
	REINIT_END_FUNC_ID
} MIB_CHANGE_FUNC_ID;



typedef struct MibChangeFuncItem_
{
	char name[MAX_NAME_LEN_LONG];
	MIB_CHANGE_FUNC_ID change_func_id;
	int (*mib_change_func)(BASE_DATA_Tp data);
	int priority;
} MibChangeFuncItem_t, *MibChangeFuncItem_tp;



typedef struct MibChangeNode_
{
	BASE_DATA_T base;
	
	int id;
	int length;
	unsigned char * value;	
	MIB_CHANGE_FUNC_ID change_func_id;
	struct list_head list;

	int parentPipeFd;//only used for decison function run in child process
	#define mibChangeNode_wlan_idx base.wlan_idx
	#define mibChangeNode_vwlan_idx base.vwlan_idx
	#define mibChangeNode_wan_idx base.wan_idx
} MibChangeNode_t, *MibChangeNode_tp;


typedef struct WAN_DATA_MODULE_{
	unsigned char virtual_wan_iface[32];	
	unsigned char wan_iface[32];
	unsigned char lan_iface[32];
	unsigned char ip_addr[20];	
	unsigned char sub_net[20];
	unsigned char gw_addr[20];	
	unsigned char dns_addr[20];		
	unsigned int  wan_type;
	
}WAN_DATA_MODULE_T,*WAN_DATA_MODULE_Tp;

typedef struct WAN_DATA_
{
	BASE_DATA_T base;
	WAN_DATA_MODULE_T wan_data;	
} WAN_DATA_T, *WAN_DATA_Tp;

typedef struct LAN_DATA_MODULE_{
	unsigned char iface[32];
	unsigned char ip_addr[20];	
	unsigned char sub_net[20];
	unsigned char gw_addr[20];	
	unsigned char dns_addr[20];	
}LAN_DATA_MODULE_T,*LAN_DATA_MODULE_Tp;

typedef struct LAN_DATA_
{
	BASE_DATA_T base;
	LAN_DATA_MODULE_T lan_data;
} LAN_DATA_T, *LAN_DATA_Tp;

void dumpMibChangeListInfo(MibChangeNode_tp node);
int apmib_rtkReinit_get(int id, void* value,int wlanIdx,int vwlanIdx,int wanIdx);
void apmib_rtkReinit_setIdx(int wlanIdx,int vwlanIdx,int wanIdx);
#endif//reinit_support
#endif//mib_tlv
#endif // INCLUDE_APMIB_H
