// SPDX-License-Identifier: GPL-2.0+
/*
 * (C) Copyright 2000
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 */

/* #define	DEBUG	*/

#include <common.h>
#include <autoboot.h>
#include <bootstage.h>
#include <cli.h>
#include <command.h>
#include <console.h>
#include <env.h>
#include <init.h>
#include <net.h>
#include <version_string.h>
#include <efi_loader.h>
#include <u-boot/md5.h>

/* porting stop boot - Start */
#ifdef CONFIG_STOP_BOOT
int monitor_packet_result;
int stop_boot_flag;
#endif
/* porting stop boot - End */

static void run_preboot_environment_command(void)
{
	char *p;

	p = env_get("preboot");
	if (p != NULL) {
		int prev = 0;

		if (IS_ENABLED(CONFIG_AUTOBOOT_KEYED))
			prev = disable_ctrlc(1); /* disable Ctrl-C checking */

		run_command_list(p, -1, 0);

		if (IS_ENABLED(CONFIG_AUTOBOOT_KEYED))
			disable_ctrlc(prev);	/* restore Ctrl-C checking */
	}
}

/* Porting console password - Start */
#if defined(CONFIG_PASSWORD_ENABLE) 
#define PASSWORD_PROMPT         "<Password>\n" 
void console_password(void){ 
		uchar pwd[33]; 
		int len=0, match=1; 
		uchar boot_pwd[16]={0x01, 0x02, 0x03, 0x04,
		                    0x05, 0x06, 0x07, 0x08,
		                    0x09, 0x0a, 0x0b, 0x0c,
		                    0x0d, 0x0e, 0x0f, 0x10 }; 
		uchar digest[16]; 

		printf(PASSWORD_PROMPT); 
		while (((pwd[len] = getchar()) != '\r') && (len < 32)){ 
			len++; 
		}
		pwd[len] = '\0'; 

		md5(pwd, len, digest); 
		for(int i=0;i<16;i++) { 
			if(boot_pwd[i]!=digest[i]) { 
				match=0; 
				break; 
			} 
		} 
		
		if (match == 0) 
			while(1); 
} 
#endif 
/* Porting console password - End */ 

/* We come here after U-Boot is initialised and ready to process commands */
void main_loop(void)
{
	const char *s;

	bootstage_mark_name(BOOTSTAGE_ID_MAIN_LOOP, "main_loop");

	if (IS_ENABLED(CONFIG_VERSION_VARIABLE))
		env_set("ver", version_string);  /* set version variable */

	cli_init();

	if (IS_ENABLED(CONFIG_USE_PREBOOT))
		run_preboot_environment_command();

	if (IS_ENABLED(CONFIG_UPDATE_TFTP))
		update_tftp(0UL, NULL, NULL);

	if (IS_ENABLED(CONFIG_EFI_CAPSULE_ON_DISK_EARLY)) {
		/* efi_init_early() already called */
		if (efi_init_obj_list() == EFI_SUCCESS)
			efi_launch_capsules();
	}

/* porting stop boot - Start */
#ifdef CONFIG_STOP_BOOT
	stop_boot_flag = 0;
	s = env_get("stop_boot");
	stop_boot_flag = s ? (int)simple_strtol(s, NULL, 10) : 0;
	
	monitor_packet_result=0;
	run_command("stop_boot",0);
	printf("monitor_packet_result %d\n",monitor_packet_result);
	if(monitor_packet_result>0){
		stop_boot_flag=1;
	}
	// s = env_get("bootcmd");
#endif
/* porting stop boot - End */
/* porting stop boot - Start */
#ifdef CONFIG_STOP_BOOT
	if(stop_boot_flag != 1) {
#endif
/* porting stop boot - End */
	s = bootdelay_process();
	if (cli_process_fdt(&s))
		cli_secure_boot_cmd(s);

/* porting stop boot - Start */
#ifdef CONFIG_STOP_BOOT
	}
#endif
/* porting stop boot - End */
 
/* porting stop boot - Start */
#ifdef CONFIG_STOP_BOOT
#ifdef CONFIG_CMD_TELNETD
	if(stop_boot_flag==1){
		run_command("telnetd",0);
#if defined(CONFIG_PASSWORD_ENABLE)
		console_password();
		printf("\n");
#endif 
	}
#endif
#endif
/* porting stop boot - End */
	autoboot_command(s);

	cli_loop();
	panic("No CLI available");
}
