// SPDX-License-Identifier: GPL-2.0
/*
 * Copyright (C) 2021 MediaTek Inc. All Rights Reserved.
 *
 * Author: Weijie Gao <weijie.gao@mediatek.com>
 *
 * Generic image booting command
 */

#include <command.h>
#include <linux/types.h>

#include "boot_helper.h"

static int do_mtkboardboot(struct cmd_tbl *cmdtp, int flag, int argc,
			   char *const argv[])
{
	int ret;
#ifdef CONFIG_DUAL_IMAGE
	const char *env;
	int bank_id = 0;
	char *bootargs;

#define boot_args_0 "console=ttyS0,115200n1 loglevel=8 ubi.mtd=ubi_0 earlycon=uart8250,mmio32,0x11002000"
#define boot_args_1 "console=ttyS0,115200n1 loglevel=8 ubi.mtd=ubi_1 earlycon=uart8250,mmio32,0x11002000"
#endif

#ifdef CONFIG_DUAL_IMAGE
	env = env_get("bank_id");
	if (!env) {
		env_set("bank_id", "0");
	}
	if (env && env[0] == '1')
		bank_id = 1;
	
	if (bank_id == 0)
		bootargs = boot_args_0;
	else
		bootargs = boot_args_1;

	env_set("bootargs", bootargs);
	ret = board_boot_default(bank_id);
	
	if (ret) {
		if (bank_id == 0) {
			bank_id = 1;
			env_set("bank_id", "1");
			bootargs = boot_args_1;
		} else {
			bank_id = 0;
			env_set("bank_id", "0");
			bootargs = boot_args_0;
		}
		
		env_set("bootargs", bootargs);
		ret = board_boot_default(bank_id);
	}
#else
	ret = board_boot_default();
#endif
	if (ret)
		return CMD_RET_FAILURE;

	return CMD_RET_SUCCESS;
}

U_BOOT_CMD(mtkboardboot, 1, 0, do_mtkboardboot,
	   "Boot MTK firmware", ""
);
