// SPDX-License-Identifier: GPL-2.0+
/*
 * (C) Copyright 2000
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 */

/* #define	DEBUG	*/

#include <common.h>
#include <autoboot.h>
#include <bootstage.h>
#include <cli.h>
#include <command.h>
#include <console.h>
#include <env.h>
#include <init.h>
#include <net.h>
#include <version_string.h>
#include <efi_loader.h>

/* porting stop boot - Start */
#ifdef CONFIG_STOP_BOOT
int monitor_packet_result;
int stop_boot_flag;
#endif
/* porting stop boot - End */

static void run_preboot_environment_command(void)
{
	char *p;

	p = env_get("preboot");
	if (p != NULL) {
		int prev = 0;

		if (IS_ENABLED(CONFIG_AUTOBOOT_KEYED))
			prev = disable_ctrlc(1); /* disable Ctrl-C checking */

		run_command_list(p, -1, 0);

		if (IS_ENABLED(CONFIG_AUTOBOOT_KEYED))
			disable_ctrlc(prev);	/* restore Ctrl-C checking */
	}
}

/* We come here after U-Boot is initialised and ready to process commands */
void main_loop(void)
{
	const char *s;

	bootstage_mark_name(BOOTSTAGE_ID_MAIN_LOOP, "main_loop");

	if (IS_ENABLED(CONFIG_VERSION_VARIABLE))
		env_set("ver", version_string);  /* set version variable */

	cli_init();

	if (IS_ENABLED(CONFIG_USE_PREBOOT))
		run_preboot_environment_command();

	if (IS_ENABLED(CONFIG_UPDATE_TFTP))
		update_tftp(0UL, NULL, NULL);

	if (IS_ENABLED(CONFIG_EFI_CAPSULE_ON_DISK_EARLY))
		efi_launch_capsules();

/* porting stop boot - Start */
#ifdef CONFIG_STOP_BOOT
	stop_boot_flag = 0;
	s = env_get("stop_boot");
	stop_boot_flag = s ? (int)simple_strtol(s, NULL, 10) : 0;
	
	monitor_packet_result=0;
	run_command("stop_boot",0);
	printf("monitor_packet_result %d\n",monitor_packet_result);
	if(monitor_packet_result>0){
		stop_boot_flag=1;
	}
	// s = env_get("bootcmd");
#endif
/* porting stop boot - End */
/* porting stop boot - Start */
#ifdef CONFIG_STOP_BOOT
	if(stop_boot_flag != 1) {
#endif
/* porting stop boot - End */
	s = bootdelay_process();
	if (cli_process_fdt(&s))
		cli_secure_boot_cmd(s);

/* porting stop boot - Start */
#ifdef CONFIG_STOP_BOOT
	}
#endif
/* porting stop boot - End */
 
/* porting stop boot - Start */
#ifdef CONFIG_STOP_BOOT
#ifdef CONFIG_CMD_TELNETD
	if(stop_boot_flag==1){
		run_command("telnetd",0);
	}
#endif
#endif
/* porting stop boot - End */
	autoboot_command(s);

	cli_loop();
	panic("No CLI available");
}
