/* ALPHA patch, 20111110 Daniel Chen */

#include <common.h>
#include <seama.h>
#include <u-boot/md5.h>
#include <linux/string.h>

int SEAMA_valid = 0;
char *SEAMA_signature = NULL;		/* signature (in meta), the signature of this f/w */
int SEAMA_noheader = 0;			/* noheader (in meta), DO NOT write seama header */
char *SEAMA_type = NULL;		/* type (in meta), image type. */
seamahdr_t *SEAMA_image = NULL;
size_t SEAMA_size = 0;
uchar *SEAMA_rawimage  = NULL;

int verify_seama(uchar * ptr, size_t size)
{
	seamahdr_t * hdr;
	ulong msize, isize;
	char * meta = NULL;
	uchar * csum = NULL;
	uchar * data = NULL;
	size_t index = 0;
	int i;
	uchar digest[16];

	debug("%s: data=0x%p, size=%d\n",__func__, ptr, size);

	/* reset the SEAMA status */
	SEAMA_valid             = 0;
	SEAMA_signature = NULL;
	SEAMA_image             = NULL;
	SEAMA_size              = 0;
	SEAMA_rawimage  = NULL;

	while (index < size)
	{
		hdr = (seamahdr_t *)&ptr[index];
		index += sizeof(seamahdr_t);
		if (hdr->magic != htonl(SEAMA_MAGIC)) break;
		msize = (ulong)ntohs(hdr->metasize);
		isize = (ulong)ntohl(hdr->size);

		SEAMA_type = NULL;
		SEAMA_noheader = 0;

		/* Get checksum pointer */
		if (isize == 0) csum = NULL;
		else
		{
			csum = &ptr[index];
			index += 16;
		}

		/* parse meta */
		if (msize == 0) {
			meta = NULL;
		} else {
			/* get meta pointer */
			meta = (char *)&ptr[index];
			index += msize;

			printf("SEAMA ==========================================\n");
			printf("  magic      : %08x\n", ntohl(hdr->magic));
			printf("  meta size  : %lu bytes\n", msize);
			/* walk through the meta data. */
			for (i=0; i<msize; i+=(strlen((const char *)&meta[i])+1))
			{
				printf("  meta data  : %s\n", &meta[i]);
				if (strncasecmp((char *)&meta[i], "signature=", 10)==0)
					SEAMA_signature = (char *)&meta[i+10];
				else if (strcasecmp((char *)&meta[i], "type=firmware")==0)
					SEAMA_type = &meta[i+5];
				else if (strcasecmp((char *)&meta[i], "noheader=1")==0)
					SEAMA_noheader = 1;
			}
			printf("  image size : %lu bytes\n", isize);

		}

		//debug("%s: signature=[%s], type=[%s]\n",__func__,SEAMA_signature,SEAMA_type);

		if (isize > 0)
		{
			data = &ptr[index];
			index += isize;

			printf("  checksum   : ");
			for (i=0; i<16; i++) printf("%02X", csum[i]);
			printf("\n");

			md5(data, isize, digest);

			printf("  digest     : ");
			for (i=0; i<16; i++) printf("%02X", digest[i]);
			printf("\n");

			if (memcmp(digest, csum, 16)==0 && SEAMA_type)
			{
				SEAMA_image             = hdr;
				SEAMA_size              = sizeof(seamahdr_t) + 16 + msize + isize;
				SEAMA_rawimage  = data;
				SEAMA_valid             = 1;
				printf("  Selected !!!\n");
			}
		}
		printf("================================================\n");
	}

	return SEAMA_valid;
}
