// SPDX-License-Identifier: BSD-3-Clause
/*
 * Copyright 2020-2021, 2023-2024 NXP
 */
#ifndef S32CC_CLK_REGS_H
#define S32CC_CLK_REGS_H

#include <lib/utils_def.h>

#define FXOSC_BASE_ADDR			(0x40050000UL)

/* FXOSC */
#define FXOSC_CTRL(FXOSC)		((FXOSC) + 0x0UL)
#define FXOSC_CTRL_OSC_BYP		BIT_32(31U)
#define FXOSC_CTRL_COMP_EN		BIT_32(24U)
#define FXOSC_CTRL_EOCV_OFFSET		16U
#define FXOSC_CTRL_EOCV_MASK		GENMASK_32(23U, FXOSC_CTRL_EOCV_OFFSET)
#define FXOSC_CTRL_EOCV(VAL)		(FXOSC_CTRL_EOCV_MASK & \
					 ((uint32_t)(VAL) << FXOSC_CTRL_EOCV_OFFSET))
#define FXOSC_CTRL_GM_SEL_OFFSET	4U
#define FXOSC_CTRL_GM_SEL_MASK		GENMASK_32(7U, FXOSC_CTRL_GM_SEL_OFFSET)
#define FXOSC_CTRL_GM_SEL(VAL)		(FXOSC_CTRL_GM_SEL_MASK & \
					 ((uint32_t)(VAL) << FXOSC_CTRL_GM_SEL_OFFSET))
#define FXOSC_CTRL_OSCON		BIT_32(0U)

#define FXOSC_STAT(FXOSC)		((FXOSC) + 0x4UL)
#define FXOSC_STAT_OSC_STAT		BIT_32(31U)

#endif /* S32CC_CLK_REGS_H */
