// SPDX-License-Identifier: BSD-3-Clause
/*
 * Copyright (c) 2024, MediaTek Inc. All rights reserved.
 *
 * Author: Weijie Gao <weijie.gao@mediatek.com>
 */
#ifndef _MTK_DUAL_FIP_H_
#define _MTK_DUAL_FIP_H_

#include <stdint.h>
#include <stdbool.h>

#define FIP_NUM				2

struct dual_fip_result {
	uint32_t ver;
	uint32_t crc;
	uint8_t fip_state[FIP_NUM];
	uint8_t padding[4 - (FIP_NUM % 4)];
};

#define DUAL_FIP_VER			1
#define DUAL_FIP_RESULT_LEN		sizeof(struct dual_fip_result)

#define DUAL_FIP_STATE_OK		0
#define DUAL_FIP_STATE_NODEV		0x80
#define DUAL_FIP_STATE_WAS_BAD		0xff

void dual_fip_init(void);
void set_fip_dev_invalid(bool fip2);
bool check_dual_fip(void);
void flush_dual_fip_result(void);

#endif /* _MTK_DUAL_FIP_H_ */
