/*----------------------------------------------------------------------------*
 * Copyright Statement:                                                       *
 *                                                                            *
 *   This software/firmware and related documentation ("MediaTek Software")   *
 * are protected under international and related jurisdictions'copyright laws *
 * as unpublished works. The information contained herein is confidential and *
 * proprietary to MediaTek Inc. Without the prior written permission of       *
 * MediaTek Inc., any reproduction, modification, use or disclosure of        *
 * MediaTek Software, and information contained herein, in whole or in part,  *
 * shall be strictly prohibited.                                              *
 * MediaTek Inc. Copyright (C) 2010. All rights reserved.                     *
 *                                                                            *
 *   BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND     *
 * AGREES TO THE FOLLOWING:                                                   *
 *                                                                            *
 *   1)Any and all intellectual property rights (including without            *
 * limitation, patent, copyright, and trade secrets) in and to this           *
 * Software/firmware and related documentation ("MediaTek Software") shall    *
 * remain the exclusive property of MediaTek Inc. Any and all intellectual    *
 * property rights (including without limitation, patent, copyright, and      *
 * trade secrets) in and to any modifications and derivatives to MediaTek     *
 * Software, whoever made, shall also remain the exclusive property of        *
 * MediaTek Inc.  Nothing herein shall be construed as any transfer of any    *
 * title to any intellectual property right in MediaTek Software to Receiver. *
 *                                                                            *
 *   2)This MediaTek Software Receiver received from MediaTek Inc. and/or its *
 * representatives is provided to Receiver on an "AS IS" basis only.          *
 * MediaTek Inc. expressly disclaims all warranties, expressed or implied,    *
 * including but not limited to any implied warranties of merchantability,    *
 * non-infringement and fitness for a particular purpose and any warranties   *
 * arising out of course of performance, course of dealing or usage of trade. *
 * MediaTek Inc. does not provide any warranty whatsoever with respect to the *
 * software of any third party which may be used by, incorporated in, or      *
 * supplied with the MediaTek Software, and Receiver agrees to look only to   *
 * such third parties for any warranty claim relating thereto.  Receiver      *
 * expressly acknowledges that it is Receiver's sole responsibility to obtain *
 * from any third party all proper licenses contained in or delivered with    *
 * MediaTek Software.  MediaTek is not responsible for any MediaTek Software  *
 * releases made to Receiver's specifications or to conform to a particular   *
 * standard or open forum.                                                    *
 *                                                                            *
 *   3)Receiver further acknowledge that Receiver may, either presently       *
 * and/or in the future, instruct MediaTek Inc. to assist it in the           *
 * development and the implementation, in accordance with Receiver's designs, *
 * of certain softwares relating to Receiver's product(s) (the "Services").   *
 * Except as may be otherwise agreed to in writing, no warranties of any      *
 * kind, whether express or implied, are given by MediaTek Inc. with respect  *
 * to the Services provided, and the Services are provided on an "AS IS"      *
 * basis. Receiver further acknowledges that the Services may contain errors  *
 * that testing is important and it is solely responsible for fully testing   *
 * the Services and/or derivatives thereof before they are used, sublicensed  *
 * or distributed. Should there be any third party action brought against     *
 * MediaTek Inc. arising out of or relating to the Services, Receiver agree   *
 * to fully indemnify and hold MediaTek Inc. harmless.  If the parties        *
 * mutually agree to enter into or continue a business relationship or other  *
 * arrangement, the terms and conditions set forth herein shall remain        *
 * effective and, unless explicitly stated otherwise, shall prevail in the    *
 * event of a conflict in the terms in any agreements entered into between    *
 * the parties.                                                               *
 *                                                                            *
 *   4)Receiver's sole and exclusive remedy and MediaTek Inc.'s entire and    *
 * cumulative liability with respect to MediaTek Software released hereunder  *
 * will be, at MediaTek Inc.'s sole discretion, to replace or revise the      *
 * MediaTek Software at issue.                                                *
 *                                                                            *
 *   5)The transaction contemplated hereunder shall be construed in           *
 * accordance with the laws of Singapore, excluding its conflict of laws      *
 * principles.  Any disputes, controversies or claims arising thereof and     *
 * related thereto shall be settled via arbitration in Singapore, under the   *
 * then current rules of the International Chamber of Commerce (ICC).  The    *
 * arbitration shall be conducted in English. The awards of the arbitration   *
 * shall be final and binding upon both parties and shall be entered and      *
 * enforceable in any court of competent jurisdiction.                        *
 *---------------------------------------------------------------------------*/
 
#include "ddr_kgd_test.h"

#define KGD_4Gb 
#define SEC_KGD
#define DRAMC_NAO_BASE_ADDRESS 0x10234000
#define POS_BANK_NUM 0



int pat_pass;

DRAMC_CTX_T *p; //take the p from the main flow

void kgd_bist_test(DRAMC_CTX_T *DramcConfig_BIST)//(unsigned int addr, unsigned int num, unsigned int offset,  unsigned int data)
{
  /* TINFO="kgd bist begin"*/  
    u32 mode;
    u32 stop_addr;
	pat_pass = 0x1 ;

	p = DramcConfig_BIST; 
#if __SLT__
	mcSHOW_SLT_MSG(("\nKGD test start !!, Channel is %d , normal version\n", p->channel));
#endif

	mcSHOW_DBG_MSG("\nKGD test start !!, Channel is %d , normal version\n", p->channel);

    //RG_RDPATMODE       [28:27] = 1, 0: fix pattern, 1: addr patttern, 2: LFSR pseudo random(only support RG_WAITRDPOPEN =1) 
    //RG_WRPATMODE       [26:25] = 1; 0: fix pattern, 1: addr patttern, 2: LFSR pseudo random(only support RG_WAITWRPOPEN =1)
    //RG_BISTHWFLOW      [24]    = 0; 0: write -> read, 1: write -> rmw1 -> rmw2 -> read      
    //RG_BISTADRMODE     [23:21] = 0; 0: Y-march, 1: BK interleave, 2: X-march, 3: X-march+BK interleave, 4~7: PC3/4 linear Mode(Y,BK,X,X+BK)
    //RG_BISTHWCTLEN     [20]    = 1;
    //RG_BISTMODE        [19:17] = 3; 0: write, 1: read, 2:write after read, 3:read after write  
    //RG_WAITRDPOPEN     [16]    = 0;
    //RG_WAITWRPOPEN     [15]    = 0;  
    //RG_DIESIZE         [14:13] = 2; 0: 2Gb, 1: 4Gb, 2: 8Gb, 3: 16Gb
    //RG_BISTEN          [ 9]    = 1;
    //RG_BIST_NORMAL_EN  [ 8]    = 0;
    //RG_BIST_REQ_LEN1   [ 7]    = 0; 0:noraml, 1:4X with 256bit (DDR3-4X-2133-X32)

    if(p->dram_type == TYPE_DDR4)
		mode = 0x00a62100;	    //[14:13] RG_DIESIZE = 2'd1: 4Gb(512MB)
	else
		mode = 0x00a60100;		//[14:13] RG_DIESIZE = 2'd0: 2Gb(256MB)
	stop_addr = 0x01ffffff;	    //Test The End of Memory Size ; 1GB - 0x7ff ~ 1GB  //ori is "0x01ffffff" 


	/*
    #ifndef KGD_OLD_MODE
	mode = mode | 0x00800000;    //[23]=1 : PC3/4 linear Mode 
    #endif
    //#ifdef KGD_BK_INTERLEAVE
	mode = mode | 0x00200000;    //[21]=1 : BK interleave
    //#endif*/
    
    #ifdef KGD_BIST_LFSR_TEST
	mode = mode | 0x14018000;   //RG_RDPATMODE       [28:27] = 2, 0: fix pattern, 1: addr patttern, 2: LFSR pseudo random(only support RG_WAITRDPOPEN =1) 
				    //RG_WRPATMODE       [26:25] = 2; 0: fix pattern, 1: addr patttern, 2: LFSR pseudo random(only support RG_WAITWRPOPEN =1)
				    //RG_WAITRDPOPEN     [16]    = 1;
				    //RG_WAITWRPOPEN     [15]    = 1;  
    #endif

	/* Mike Jacob update version 2*/
	kgd_bist_test_pre_setting(DRAMC_NAO_BASE_ADDRESS, stop_addr, CHANNEL_A);
    #if defined(DRAM_3CH) || defined(DRAM_3CH_SWAP) || defined(DDR4_2666_3200_COMBO)
    kgd_bist_test_pre_setting(DRAMC_NAO_BASE_ADDRESS, stop_addr, CHANNEL_C);
    #endif

    kgd_bist_test_check(1,mode,100);

	mode = mode | 0x00000c00;	    //RG_RDPATINV[11]    = 1, RG_WRPATINV[10]    = 1

    //#ifdef KGD_OLD_MODE
	//WRITE_REG_BIST(DRAMC_REG_ADDR(DRAMC_NAO_BASE_ADDRESS + 0x468), 0x10);	//[4] RG_ROWHAMCOL[0]=1
	//#if defined(DRAM_3CH) || defined(DRAM_3CH_SWAP) || defined(DDR4_2666_3200_COMBO)
	//WRITE_REG_BIST(DRAMC_REG_ADDR((DRAMC_NAO_BASE_ADDRESS + 0x468))+SHIFT_TO_CHC_ADDR, 0x10); //[4] RG_ROWHAMCOL[0]=1
	//#endif
	kgd_bist_test_check(1,mode,100);	//HW CTRL Mode, test col = 8, 18, 28, ...
    //#endif

#ifdef TEST_START_END_MEMORY_ONLY //Mike Jacob update version 2
    //Test The End of Memory Size
    WRITE_REG_BIST(DRAMC_REG_ADDR(DRAMC_NAO_BASE_ADDRESS + 0x450), (stop_addr - 0x7ff));
	WRITE_REG_BIST(DRAMC_REG_ADDR(DRAMC_NAO_BASE_ADDRESS + 0x454), stop_addr);
    #if defined(DRAM_3CH) || defined(DRAM_3CH_SWAP) || defined(DDR4_2666_3200_COMBO)
	WRITE_REG_BIST(DRAMC_REG_ADDR((DRAMC_NAO_BASE_ADDRESS + 0x450))+SHIFT_TO_CHC_ADDR, (stop_addr - 0x7ff));
	WRITE_REG_BIST(DRAMC_REG_ADDR((DRAMC_NAO_BASE_ADDRESS + 0x454))+SHIFT_TO_CHC_ADDR, stop_addr);
    #endif

    kgd_bist_test_check(1,mode,100);

	mode = mode & ~0x00000c00;	    //RG_RDPATINV[11]    = 0, RG_WRPATINV[10]    = 0

    //#ifdef KGD_OLD_MODE
	//WRITE_REG_BIST(DRAMC_REG_ADDR(DRAMC_NAO_BASE_ADDRESS + 0x468), 0x0);	//RG_ROWHAMCOL[0]=0
	//#if defined(DRAM_3CH) || defined(DRAM_3CH_SWAP) || defined(DDR4_2666_3200_COMBO)
	//WRITE_REG_BIST(DRAMC_REG_ADDR((DRAMC_NAO_BASE_ADDRESS + 0x468))+SHIFT_TO_CHC_ADDR, 0x0);	//RG_ROWHAMCOL[0]=0
	//#endif
	kgd_bist_test_check(1,mode,100);
    //#endif
#endif //Mike Jacob update version 2
#if __SLT__
	mcSHOW_SLT_MSG(("\nAll KGD bist(Full memory) test PASS!!\n"));
#endif

	mcSHOW_DBG_MSG("\nAll KGD bist(Full memory) test PASS!!\n");
	/* TINFO="All kgd bist test PASS!! " */

//	mcSHOW_DBG_MSG("\n%s:%d: Keep going on the boundary test\n", __func__, __LINE__);
//	kgd_bist_boundary_test();

//	mcSHOW_DBG_MSG("\n%s:%d: Keep going on the pin connecttivity test\n", __func__, __LINE__);
//	kgd_bist_pin_connecttivity_test();
	

}

void kgd_bist_test_pre_setting(u64 addr, u32 stop_addr, u32 channel_shifter)	//(unsigned int addr, unsigned int num, unsigned int offset,  unsigned int data) //Mike Jacob update version 2
{

	mcSHOW_DBG_MSG("\n KGD bist test pre-setting start !!\n");

    WRITE_REG_BIST(DRAMC_REG_ADDR(addr+0x444)+(channel_shifter << POS_BANK_NUM), 0x01234567);//LFSR pattern seed
	WRITE_REG_BIST(DRAMC_REG_ADDR(addr+0x448)+(channel_shifter << POS_BANK_NUM), 0x89abcdef);//LFSR pattern seed
	
    //RG_BIST_START_ADR
	WRITE_REG_BIST(DRAMC_REG_ADDR(addr+0x450)+(channel_shifter << POS_BANK_NUM), 0x0);

    //RG_BIST_STOP_ADR
#ifdef TEST_START_END_MEMORY_ONLY //Mike Jacob update version 2 
	WRITE_REG_BIST(DRAMC_REG_ADDR(addr+0x454)+(channel_shifter << POS_BANK_NUM), 0x1fff);
#else
	WRITE_REG_BIST(DRAMC_REG_ADDR(addr+0x454)+(channel_shifter << POS_BANK_NUM), stop_addr);
#endif

    //RG_WRTESTPAT : write fix pattern
	WRITE_REG_BIST(DRAMC_REG_ADDR(addr+0x458)+(channel_shifter << POS_BANK_NUM), 0x5AA5A55A);

    //RG_RDTESTPAT : read fix pattern
	WRITE_REG_BIST(DRAMC_REG_ADDR(addr+0x45c)+(channel_shifter << POS_BANK_NUM), 0x5AA5A55A);

}

void kgd_bist_test_check(u32 pass, u32 mode, u32 waitus)
{

  u32 a=0;
  u32 mode0;
#if defined(DRAM_3CH) || defined(DRAM_3CH_SWAP) || defined(DDR4_2666_3200_COMBO)
  u32 mode1;
#endif

  mcSHOW_DBG_MSG("\n KGD bist result check\n");
#if __SLT__
  mcSHOW_SLT_MSG(("\n KGD bist result check\n"));
#endif
    #ifndef DDR3_EN
	mode0 = mode;
    #elif defined(DRAM_1CH) || defined(DRAM_3CH_SWAP)
	mode0 = mode;
    #else   //defined(DRAM_2CH) || defined(DRAM_3CH) || defined(DRAM_4CH)
	mode0 = mode | 0x00000080;	//[7] RG_BIST_REQ_LEN1 = 1 : 4X with 256bit (DDR3-4X-2133-X32)
    #endif

#if defined(DRAM_3CH) || defined(DRAM_3CH_SWAP) || defined(DDR4_2666_3200_COMBO)
    #ifndef DDR3_EN
	mode1 = mode;
    #elif defined(DRAM_3CH_SWAP)    //CH1 : DDR3 X32
	mode1 = mode | 0x00000080;	//[7] RG_BIST_REQ_LEN1 = 1 : 4X with 256bit (DDR3-4X-2133-X32)
    #else
	mode1 = mode;
	#endif
#endif

	WRITE_REG_BIST(DRAMC_REG_ADDR(DRAMC_NAO_BASE_ADDRESS+0x44c), mode0);
	WRITE_REG_BIST(DRAMC_REG_ADDR(DRAMC_NAO_BASE_ADDRESS+0x44c), (mode0 | 0x00000200));	//[9] RG_BISTEN = 1
    #if defined(DRAM_3CH) || defined(DRAM_3CH_SWAP) || defined(DDR4_2666_3200_COMBO)
	WRITE_REG_BIST(DRAMC_REG_ADDR((DRAMC_NAO_BASE_ADDRESS+0x44c))+SHIFT_TO_CHC_ADDR, mode1);
	WRITE_REG_BIST(DRAMC_REG_ADDR((DRAMC_NAO_BASE_ADDRESS+0x44c))+SHIFT_TO_CHC_ADDR, (mode1 | 0x00000200));	//[9] RG_BISTEN = 1
    #endif

  while (1)
  {
    if (( (READ_REG_BIST(DRAMC_REG_ADDR(DRAMC_NAO_BASE_ADDRESS+0x250))) & 0x2) > 0 )   //[1] BIST_CPT
      break;
  
    //if (a>10000){
    //  /* TINFO="ERROR : DRAMC0 kgd bist test NOT finish!!"*/
    //  *APMCU_MDM_TM_ENDFAIL = 0x0;
    //}
      
      a++; 
      mcDELAY_US(100);//mike KGD debug now - delay 100us
  }

    if ( ((READ_REG_BIST(DRAMC_REG_ADDR(DRAMC_NAO_BASE_ADDRESS+0x250))) & 0x1) > 0 )   //[0] BIST_ERR
	{
#if __SLT__
		mcSHOW_SLT_MSG(("\n%s:%d: KGD BIST ERROR !\n", __func__, __LINE__));
		while(1);
#endif
		mcSHOW_DBG_MSG("\n%s:%d: KGD BIST ERROR !\n", __func__, __LINE__);
		while(1);
    }

#if defined(DRAM_4CH) || defined(DRAM_3CH) || defined(DRAM_3CH_SWAP) || defined(DDR4_2666_3200_COMBO)
  a=0;
  while (1)
  {
    if (( (READ_REG_BIST(DRAMC_REG_ADDR((DRAMC_NAO_BASE_ADDRESS+0x250))+SHIFT_TO_CHC_ADDR)) & 0x2) > 0 )   //[1] BIST_CPT
      break;
  
    //if (a>10000){
    //  /* TINFO="ERROR : kgd bist test NOT finish!!"*/
    //  *APMCU_MDM_TM_ENDFAIL = 0x0;
    //}
      
      a++; 
      mcDELAY_US(100);//mike KGD debug now - delay 100us
  }

    if (( (READ_REG_BIST(DRAMC_REG_ADDR((DRAMC_NAO_BASE_ADDRESS+0x250))+SHIFT_TO_CHC_ADDR)) & 0x1) > 0 )  //[0] BIST_ERR
	{
#if __SLT__
		mcSHOW_SLT_MSG(("\n%s:%d: KGD BIST ERROR !\n", __func__, __LINE__));
		while(1)
#endif
		mcSHOW_DBG_MSG("\n%s:%d: KGD BIST ERROR !\n", __func__, __LINE__);
		while(1)
		{
		   //do nothing ...
		}
    }

    /* TINFO="DRAMC2 kgd bist test PASS!! " */
#endif

} 

void kgd_bist_boundary_test()	//(unsigned int addr, unsigned int num, unsigned int offset,  unsigned int data)
{
    /* TINFO="kgd bist boundary test begin"*/  
    u32 mode;
    u32 start_addr,stop_addr;

	mcSHOW_DBG_MSG("\n%s:%d: KGD Boundary test start !!\n", __func__, __LINE__);
    
    WRITE_REG_BIST(DRAMC_REG_ADDR(DRAMC_NAO_BASE_ADDRESS+0x458), 0x55555555); //RG_WRTESTPAT : write fix pattern
    WRITE_REG_BIST(DRAMC_REG_ADDR(DRAMC_NAO_BASE_ADDRESS+0x45c), 0x55555555); //RG_RDTESTPAT : read fix pattern
    
    #if defined(DRAM_3CH) || defined(DRAM_3CH_SWAP) || defined(DDR4_2666_3200_COMBO)
	WRITE_REG_BIST(DRAMC_REG_ADDR((DRAMC_NAO_BASE_ADDRESS+0x458))+SHIFT_TO_CHC_ADDR, 0x55555555); //RG_WRTESTPAT : write fix pattern
    WRITE_REG_BIST(DRAMC_REG_ADDR((DRAMC_NAO_BASE_ADDRESS+0x45c))+SHIFT_TO_CHC_ADDR, 0x55555555); //RG_RDTESTPAT : read fix pattern
    #endif

    //RG_RDPATMODE       [28:27] = 0, 0: fix pattern, 1: addr patttern, 2: LFSR pseudo random(only support RG_WAITRDPOPEN =1) 
    //RG_WRPATMODE       [26:25] = 0; 0: fix pattern, 1: addr patttern, 2: LFSR pseudo random(only support RG_WAITWRPOPEN =1)
    //RG_BISTHWFLOW      [24]    = 0; 0: write -> read, 1: write -> rmw1 -> rmw2 -> read      
    //RG_BISTADRMODE     [23:21] = 5; 0: Y-march, 1: Y-march+BK interleave, 2: X-march, 3: X-march+BK interleave, 4~7: PC3/4 linear Mode(Y,BK,X,X+BK)
    //RG_BISTHWCTLEN     [20]    = 1;
    //RG_BISTMODE        [19:17] = 0; 0: write, 1: read, 2:write after read, 3:read after write  
    //RG_WAITRDPOPEN     [16]    = 0;
    //RG_WAITWRPOPEN     [15]    = 0;  
    //RG_DIESIZE         [14:13] = 1; 0: 2Gb, 1: 4Gb, 2: 8Gb, 3: 16Gb
    //RG_BISTEN          [ 9]    = 0;
    //RG_BIST_NORMAL_EN  [ 8]    = 0;
    //RG_BIST_REQ_LEN1   [ 7]    = 0; 0:noraml, 1:4X with 256bit (DDR3-4X-2133-X32)

    //Zone 0/1
    #ifdef SEC_KGD
	#ifdef KGD_4Gb
	    mode = 0x00b02000;		//4Gb  : [23:21] = 5 (Y-march+BK interleave), [14:13] RG_DIESIZE = 2'd1
	    start_addr = 0x1000000;	//4Gb  : ROW[24:10] = 0x4000, COL[9:3] =  0x0, BK[2:0] = 0
	    stop_addr  = 0x10003ff;	//4Gb  : ROW[24:10] = 0x4000, COL[9:3] = 0x7f, BK[2:0] = 7
	#else   //DDR4
	    mode = 0x00b06000;		//16Gb : [23:21] = 5 (Y-march+BK interleave), [14:13] RG_DIESIZE = 2'd3
	    start_addr = 0x1000000;	//16Gb : ROW[26:10] = 0x4000, COL[9:3] =  0x0, BK[2:0] = 0
	    stop_addr  = 0x10003ff;	//16Gb : ROW[26:10] = 0x4000, COL[9:3] = 0x7f, BK[2:0] = 7
	#endif
    #else   //NANYA_KGD
	#ifdef KGD_4Gb
	    mode = 0x00b02000;		//4Gb  : [23:21] = 5 (Y-march+BK interleave), [14:13] RG_DIESIZE = 2'd1
	    start_addr = 0x17ffc00;	//4Gb  : ROW[24:10] = 0x5fff, COL[9:3] =  0x0, BK[2:0] = 0
	    stop_addr  = 0x17fffff;	//4Gb  : ROW[24:10] = 0x5fff, COL[9:3] = 0x7f, BK[2:0] = 7
	#else   //DDR4
	    mode = 0x00b06000;		//16Gb : [23:21] = 5 (Y-march+BK interleave), [14:13] RG_DIESIZE = 2'd3
	    start_addr = 0x17ffc00;	//16Gb : ROW[26:10] = 0x5fff, COL[9:3] =  0x0, BK[2:0] = 0
	    stop_addr  = 0x17fffff;	//16Gb : ROW[26:10] = 0x5fff, COL[9:3] = 0x7f, BK[2:0] = 7
	#endif
    #endif

    kgd_bist_boundary_test_pre_setting(DRAMC_NAO_BASE_ADDRESS,start_addr,stop_addr, CHANNEL_A);
    #if defined(DRAM_3CH) || defined(DRAM_3CH_SWAP) || defined(DDR4_2666_3200_COMBO)
    kgd_bist_boundary_test_pre_setting(DRAMC_NAO_BASE_ADDRESS,start_addr,stop_addr, CHANNEL_C);
    #endif
    kgd_bist_test_check(1,mode,100);


    //RG_RDPATMODE       [28:27] = 0, 0: fix pattern, 1: addr patttern, 2: LFSR pseudo random(only support RG_WAITRDPOPEN =1) 
    //RG_WRPATMODE       [26:25] = 0; 0: fix pattern, 1: addr patttern, 2: LFSR pseudo random(only support RG_WAITWRPOPEN =1)
    //RG_BISTHWFLOW      [24]    = 0; 0: write -> read, 1: write -> rmw1 -> rmw2 -> read      
    //RG_BISTADRMODE     [23:21] = 6; 0: Y-march, 1: Y-march+BK interleave, 2: X-march, 3: X-march+BK interleave, 4~7: PC3/4 linear Mode(Y,BK,X,X+BK)
    //RG_BISTHWCTLEN     [20]    = 1;
    //RG_BISTMODE        [19:17] = 0; 0: write, 1: read, 2:write after read, 3:read after write  
    //RG_WAITRDPOPEN     [16]    = 0;
    //RG_WAITWRPOPEN     [15]    = 0;  
    //RG_DIESIZE         [14:13] = 1; 0: 2Gb, 1: 4Gb, 2: 8Gb, 3: 16Gb
    //RG_BISTEN          [ 9]    = 0;
    //RG_BIST_NORMAL_EN  [ 8]    = 0;
    //RG_BIST_REQ_LEN1   [ 7]    = 0; 0:noraml, 1:4X with 256bit (DDR3-4X-2133-X32)
 
    //Zone 3/4/5/6
    #ifdef KGD_4Gb
	mode = 0x00d02000;	    //4Gb  : [23:21] = 6 (X-march), [14:13] RG_DIESIZE = 2'd1
    #else   //DDR4
	mode = 0x00d06000;	    //16Gb : [23:21] = 6 (X-march), [14:13] RG_DIESIZE = 2'd3
    #endif

    kgd_bist_boundary_test_launch(mode);

	mcSHOW_DBG_MSG("\n%s:%d: KGD bist boundary test PASS!!\n", __func__, __LINE__);

    /* TINFO="kgd bist boundary test PASS"*/  

}

void kgd_bist_boundary_test_launch(u32 mode)	//(unsigned int addr, unsigned int num, unsigned int offset,  unsigned int data)
{
    u32 start_addr,stop_addr;

	mcSHOW_DBG_MSG("\n%s:%d: KGD Boundary test launch\n", __func__, __LINE__);

    #ifdef SEC_KGD
	//Col = 0x0, BK = 0
	#ifdef KGD_4Gb
	start_addr = 0x0000000;	//4Gb  : BK[24:22] = 0, COL[21:15] = 0, ROW[14:0] = 0x0
	stop_addr  = 0x0007fff;	//4Gb  : BK[24:22] = 0, COL[21:15] = 0, ROW[14:0] = 0x7fff
	#else   //DDR4         
	start_addr = 0x0000000;	//16Gb : BK[26:24] = 0, COL[23:17] = 0, ROW[16:0] = 0x0
	stop_addr  = 0x001ffff;	//16Gb : BK[26:24] = 0, COL[23:17] = 0, ROW[16:0] = 0x1ffff
	#endif
    #else   //NANYA_KGD
	//Col = 0x0, BK = 6
	#ifdef KGD_4Gb
	start_addr = 0x1800000;	//4Gb  : BK[24:22] = 6, COL[21:15] = 0, ROW[14:0] = 0x0
	stop_addr  = 0x1807fff;	//4Gb  : BK[24:22] = 6, COL[21:15] = 0, ROW[14:0] = 0x7fff
	#else   //DDR4         
	start_addr = 0x6000000;	//16Gb : BK[26:24] = 6, COL[23:17] = 0, ROW[16:0] = 0x0
	stop_addr  = 0x601ffff;	//16Gb : BK[26:24] = 6, COL[23:17] = 0, ROW[16:0] = 0x1ffff
	#endif
    #endif

    kgd_bist_boundary_test_pre_setting(DRAMC_NAO_BASE_ADDRESS, start_addr, stop_addr, CHANNEL_A);
    #if defined(DRAM_3CH) || defined(DRAM_3CH_SWAP) || defined(DDR4_2666_3200_COMBO)
    kgd_bist_boundary_test_pre_setting(DRAMC_NAO_BASE_ADDRESS, start_addr, stop_addr, CHANNEL_C);
    #endif
    kgd_bist_test_check(1,mode,100);
    

    #ifdef SEC_KGD
		//Col = 0x0, BK = 1
		#ifdef KGD_4Gb
		    start_addr = 0x0400000;	//4Gb  : BK[24:22] = 1, COL[21:15] = 0, ROW[14:0] = 0x0
		    stop_addr  = 0x0407fff;	//4Gb  : BK[24:22] = 1, COL[21:15] = 0, ROW[14:0] = 0x7fff
		#else   //DDR4
		    start_addr = 0x1000000;	//16Gb : BK[26:24] = 1, COL[23:17] = 0, ROW[16:0] = 0x0
		    stop_addr  = 0x101ffff;	//16Gb : BK[26:24] = 1, COL[23:17] = 0, ROW[16:0] = 0x1ffff
		#endif
    #else   //NANYA_KGD
		//Col = 0x0, BK = 7
		#ifdef KGD_4Gb
		    start_addr = 0x1c00000;	//4Gb  : BK[24:22] = 7, COL[21:15] = 0, ROW[14:0] = 0x0
		    stop_addr  = 0x1c07fff;	//4Gb  : BK[24:22] = 7, COL[21:15] = 0, ROW[14:0] = 0x7fff
		#else   //DDR4
		    start_addr = 0x7000000;	//16Gb : BK[26:24] = 7, COL[23:17] = 0, ROW[16:0] = 0x0
		    stop_addr  = 0x701ffff;	//16Gb : BK[26:24] = 7, COL[23:17] = 0, ROW[16:0] = 0x1ffff
		#endif
    #endif

    kgd_bist_boundary_test_pre_setting( DRAMC_NAO_BASE_ADDRESS, start_addr, stop_addr, CHANNEL_A);
    #if defined(DRAM_3CH) || defined(DRAM_3CH_SWAP) || defined(DDR4_2666_3200_COMBO)
    kgd_bist_boundary_test_pre_setting( DRAMC_NAO_BASE_ADDRESS, start_addr, stop_addr, CHANNEL_C);
    #endif

    kgd_bist_test_check(1,mode,100);


    #ifdef SEC_KGD
		//Col = 0x3F8, BK = 2
		#ifdef KGD_4Gb
		    start_addr = 0x0bf8000;	//4Gb  : BK[24:22] = 2, COL[21:15] = 0x7f : ROW[14:0] = 0x0
		    stop_addr  = 0x0bfffff;	//4Gb  : BK[24:22] = 2, COL[21:15] = 0x7f : ROW[14:0] = 0x7fff
		#else   //DDR4                                      
		    start_addr = 0x2fe0000;	//16Gb : BK[26:24] = 2, COL[23:17] = 0x7f : ROW[16:0] = 0x0
		    stop_addr  = 0x2ffffff;	//16Gb : BK[26:24] = 2, COL[23:17] = 0x7f : ROW[16:0] = 0x1ffff
		#endif
    #else   //NANYA_KGD
		//Col = 0x3F8, BK = 0
		#ifdef KGD_4Gb
		    start_addr = 0x03f8000;	//4Gb  : BK[24:22] = 0, COL[21:15] = 0x7f : ROW[14:0] = 0x0
		    stop_addr  = 0x03fffff;	//4Gb  : BK[24:22] = 0, COL[21:15] = 0x7f : ROW[14:0] = 0x7fff
		#else   //DDR4                                      
		    start_addr = 0x0fe0000;	//16Gb : BK[26:24] = 0, COL[23:17] = 0x7f : ROW[16:0] = 0x0
		    stop_addr  = 0x0ffffff;	//16Gb : BK[26:24] = 0, COL[23:17] = 0x7f : ROW[16:0] = 0x1ffff
		#endif
    #endif

    kgd_bist_boundary_test_pre_setting( DRAMC_NAO_BASE_ADDRESS, start_addr, stop_addr, CHANNEL_A);
    #if defined(DRAM_3CH) || defined(DRAM_3CH_SWAP) || defined(DDR4_2666_3200_COMBO)
    kgd_bist_boundary_test_pre_setting( DRAMC_NAO_BASE_ADDRESS, start_addr, stop_addr, CHANNEL_C);
    #endif

    kgd_bist_test_check(1,mode,100);


    #ifdef SEC_KGD
		//Col = 0x3F8, BK = 3
		#ifdef KGD_4Gb
		    start_addr = 0x0ff8000;	//4Gb  : BK[24:22] = 3, COL[21:15] = 0x7f : ROW[14:0] = 0x0
		    stop_addr  = 0x0ffffff;	//4Gb  : BK[24:22] = 3, COL[21:15] = 0x7f : ROW[14:0] = 0x7fff
		#else   //DDR4 
		    start_addr = 0x3fe0000;	//16Gb : BK[26:24] = 3, COL[23:17] = 0x7f : ROW[16:0] = 0x0
		    stop_addr  = 0x3ffffff;	//16Gb : BK[26:24] = 3, COL[23:17] = 0x7f : ROW[16:0] = 0x1ffff
		#endif
    #else   //NANYA_KGD
		//Col = 0x3F8, BK = 1
		#ifdef KGD_4Gb
		    start_addr = 0x07f8000;	//4Gb  : BK[24:22] = 1, COL[21:15] = 0x7f : ROW[14:0] = 0x0
		    stop_addr  = 0x07fffff;	//4Gb  : BK[24:22] = 1, COL[21:15] = 0x7f : ROW[14:0] = 0x7fff
		#else   //DDR4 
		    start_addr = 0x1fe0000;	//16Gb : BK[26:24] = 1, COL[23:17] = 0x7f : ROW[16:0] = 0x0
		    stop_addr  = 0x1ffffff;	//16Gb : BK[26:24] = 1, COL[23:17] = 0x7f : ROW[16:0] = 0x1ffff
		#endif
    #endif

    kgd_bist_boundary_test_pre_setting( DRAMC_NAO_BASE_ADDRESS, start_addr, stop_addr, CHANNEL_A);
    #if defined(DRAM_3CH) || defined(DRAM_3CH_SWAP) || defined(DDR4_2666_3200_COMBO)
    kgd_bist_boundary_test_pre_setting( DRAMC_NAO_BASE_ADDRESS, start_addr, stop_addr, CHANNEL_C);
    #endif

    kgd_bist_test_check(1,mode,100);

}

void kgd_bist_boundary_test_pre_setting(u64 bank,u32 start_addr,u32 stop_addr, u32 channel_shifter)	//(unsigned int addr, unsigned int num, unsigned int offset,  unsigned int data)
{

	mcSHOW_DBG_MSG("\n%s:%d: KGD Boundary test pre setting\n", __func__, __LINE__);

    //RG_BIST_START_ADR
    WRITE_REG_BIST(DRAMC_REG_ADDR(bank+0x450)+(channel_shifter << POS_BANK_NUM), start_addr);

    //RG_BIST_STOP_ADR
    WRITE_REG_BIST(DRAMC_REG_ADDR(bank+0x454)+(channel_shifter << POS_BANK_NUM), stop_addr);

}


void kgd_bist_pin_connecttivity_test()
{
    /* TINFO="kgd bist pin connecttivity test begin"*/  
    u32 mode;
    u32 start_addr,stop_addr,addr,addr_x3,nxt_addr,data;

    //RG_RDPATMODE       [28:27] = 0, 0: fix pattern, 1: addr patttern, 2: LFSR pseudo random(only support RG_WAITRDPOPEN =1) 
    //RG_WRPATMODE       [26:25] = 0; 0: fix pattern, 1: addr patttern, 2: LFSR pseudo random(only support RG_WAITWRPOPEN =1)
    //RG_BISTHWFLOW      [24]    = 0; 0: write -> read, 1: write -> rmw1 -> rmw2 -> read      
    //RG_BISTADRMODE     [23:21] = 6; 0: Y-march, 1: Y-march+BK interleave, 2: X-march, 3: X-march+BK interleave, 4~7: PC3/4 linear Mode(Y,BK,X,X+BK)
    //RG_BISTHWCTLEN     [20]    = 0;
    //RG_BISTMODE        [19:17] = 0; 0: write, 1: read, 2:write after read, 3:read after write  
    //RG_WAITRDPOPEN     [16]    = 0;
    //RG_WAITWRPOPEN     [15]    = 0;  
    //RG_DIESIZE         [14:13] = 1; 0: 2Gb, 1: 4Gb, 2: 8Gb, 3: 16Gb
    //RG_BISTEN          [ 9]    = 0;
    //RG_BIST_NORMAL_EN  [ 8]    = 1;
    //RG_BIST_REQ_LEN1   [ 7]    = 0; 0:noraml, 1:4X with 256bit (DDR3-4X-2133-X32)
 
    #ifdef KGD_4Gb
	mode = 0x00802100;	    //4Gb  : [23:21] = 4 (Y-march), [14:13] RG_DIESIZE = 2'd1
    #else   //DDR4
	mode = 0x00806100;	    //16Gb : [23:21] = 4 (Y-march), [14:13] RG_DIESIZE = 2'd3
    #endif

    #ifdef KGD_4Gb
    	start_addr  = 0x80;	    //4Gb  : ROW[21:7] = 0x1
    	stop_addr   = 0x1000000;    //4Gb  : BK[24:22] = 0x4
    #else   //DDR4         
    	start_addr  = 0x80;	    //16Gb : ROW[23:7] = 0x1
	stop_addr   = 0x4000000;    //16Gb : BK[26:24] = 0x4
    #endif

    //High Bias Leak Test
    addr = start_addr;
    while(addr <= stop_addr)
    {
    mcSHOW_DBG_MSG("\n%s:%d: connecttivity test-1 \n", __func__, __LINE__);
	nxt_addr = addr<<1;
	kgd_bist_pin_connecttivity_test_launch(mode,    addr, 0x55555555, 0);    //Write
	kgd_bist_pin_connecttivity_test_launch(mode,       0, 0xaaaaaaaa, 0);    //Write complement data at 0x0
	kgd_bist_pin_connecttivity_test_launch(mode,    addr, 0x55555555, 1);    //Read
	addr = nxt_addr;
    }

    //Low Bias Leak Test
    addr = start_addr;
    while(addr <= stop_addr)
    {
    mcSHOW_DBG_MSG("\n%s:%d: connecttivity test-2 \n", __func__, __LINE__);
	nxt_addr = addr<<1;
	kgd_bist_pin_connecttivity_test_launch(mode,       0, 0x55555555, 0);    //Write
	kgd_bist_pin_connecttivity_test_launch(mode,    addr, 0xaaaaaaaa, 0);    //Write complement data at 0x0
	kgd_bist_pin_connecttivity_test_launch(mode,       0, 0x55555555, 1);    //Read
	addr = nxt_addr;
    }

	
    //Pin-Pin Leak Test
    addr = start_addr;
    while(addr < stop_addr)
    {
    mcSHOW_DBG_MSG("\n%s:%d: connecttivity test-3 \n", __func__, __LINE__);
	nxt_addr = addr<<1;
	addr_x3  = nxt_addr | addr;
	kgd_bist_pin_connecttivity_test_launch(mode,    addr, 0x55555555, 0);    //Write
	kgd_bist_pin_connecttivity_test_launch(mode,       0, 0xaaaaaaaa, 0);    //Write complement data at 0x0
	kgd_bist_pin_connecttivity_test_launch(mode, addr_x3, 0xaaaaaaaa, 0);    //Write complement data at addr*3
	kgd_bist_pin_connecttivity_test_launch(mode,    addr, 0x55555555, 1);    //Read
	addr = nxt_addr;
    }

    //DQ Leak to High Test
    addr = 0x0;
    data = 0x00010001;
    while(addr < 0x10)
    {
     mcSHOW_DBG_MSG("\n%s:%d: connecttivity test-4 \n", __func__, __LINE__);
	kgd_bist_pin_connecttivity_test_launch(mode,    addr, data, 0);    //Write
	kgd_bist_pin_connecttivity_test_launch(mode,    addr, data, 1);    //Read
	addr = addr+1;
	data = ((data<<1) & 0xffffffff);
    }

    //DQ Leak to Low Test
    addr = 0x0;
    data = 0xfffefffe;
    while(addr < 0x10)
    {
     mcSHOW_DBG_MSG("\n%s:%d: connecttivity test-5 \n", __func__, __LINE__);
	kgd_bist_pin_connecttivity_test_launch(mode,    addr, data, 0);    //Write
	kgd_bist_pin_connecttivity_test_launch(mode,    addr, data, 1);    //Read
	addr = addr+1;
	data = ((data<<1) & 0xffffffff) +1;
    }

	mcSHOW_DBG_MSG("\n%s:%d: KGD bist pin connecttivity test PASS!!\n", __func__, __LINE__);
	
    /* TINFO="kgd bist pin connecttivity test PASS"*/  

}


void kgd_bist_pin_connecttivity_test_launch(u32 mode, u32 addr,  u32 data,  u32 read)
{

	WRITE_REG_BIST(DRAMC_REG_ADDR(DRAMC_NAO_BASE_ADDRESS+0x450), addr);	    //RG_BIST_START_ADR
	WRITE_REG_BIST(DRAMC_REG_ADDR(DRAMC_NAO_BASE_ADDRESS+0x454), addr);	    //RG_BIST_STOP_ADR
	WRITE_REG_BIST(DRAMC_REG_ADDR(DRAMC_NAO_BASE_ADDRESS+0x458), data);	    //RG_WRTESTPAT : write fix pattern
	WRITE_REG_BIST(DRAMC_REG_ADDR(DRAMC_NAO_BASE_ADDRESS+0x45c), data);     //RG_RDTESTPAT : read fix pattern
    #if defined(DRAM_3CH) || defined(DRAM_3CH_SWAP) || defined(DDR4_2666_3200_COMBO)
	WRITE_REG_BIST(DRAMC_REG_ADDR((DRAMC_NAO_BASE_ADDRESS+0x450)) + SHIFT_TO_CHC_ADDR, addr);	    //RG_BIST_START_ADR
	WRITE_REG_BIST(DRAMC_REG_ADDR((DRAMC_NAO_BASE_ADDRESS+0x454)) + SHIFT_TO_CHC_ADDR, addr);	    //RG_BIST_STOP_ADR
	WRITE_REG_BIST(DRAMC_REG_ADDR((DRAMC_NAO_BASE_ADDRESS+0x458)) + SHIFT_TO_CHC_ADDR, data);	    //RG_WRTESTPAT : write fix pattern
	WRITE_REG_BIST(DRAMC_REG_ADDR((DRAMC_NAO_BASE_ADDRESS+0x45c)) + SHIFT_TO_CHC_ADDR, data);     //RG_RDTESTPAT : read fix pattern
    #endif

    mode = mode | (read<<17);  //[19:17] RG_BISTMODE = 0: write, 1: read
    kgd_bist_test_check(1,mode,1);
    
}

#ifdef HIGH_LOW_SPEED_TEST

#define CHANNEL_AB 0
#define CHANNEL_CD 1

#define REG32(reg)        (*(volatile u32*)(APMCU_RIUBASE+ (reg)))
#define REG16(reg)        (*(volatile u16*)(APMCU_RIUBASE+ (reg)))

void fpc_kgd_high_low_speed_test ()	//(unsigned int addr, unsigned int num, unsigned int offset,  unsigned int data)
{
    unsigned int frq_result=0;
    unsigned int frq_meter_offset = 10;
    //unsigned int temp_rdata;
    pat_pass = 0x1 ;


    *((UINT32P)(APMCU_RIUBASE+X32_DDRPHY_CHA+0x06a0)) &= ~0x00000002;  //[1] = 1'h0
    //temp_rdata = *((UINT32P)(APMCU_RIUBASE+X32_DDRPHY_CHA+0x066c));
    //temp_rdata =  temp_rdata & ~0x00000030;  //[5:4] = 2'h0
    *((UINT32P)(APMCU_RIUBASE+X32_DDRPHY_CHA+0x066c)) = 0x260bff80; //[5:4] RG_clk_mem_sel= 2'h0
    delay_us_fpc  (1) ;
    //temp_rdata =  temp_rdata |  0x00000001;  //[0]   = 1'h1
    *((UINT32P)(APMCU_RIUBASE+X32_DDRPHY_CHA+0x066c)) = 0x260bff81; //[0]   RG_w_chg_mem=1
    delay_us_fpc  (1) ;
    //temp_rdata =  temp_rdata & ~0x00000001;  //[0]   = 1'h0
    *((UINT32P)(APMCU_RIUBASE+X32_DDRPHY_CHA+0x066c)) = 0x260bff80; //[0]   RG_w_chg_mem=0
    delay_us_fpc  (1) ;


    *((UINT32P)(APMCU_RIUBASE+X32_DDRPHY_CHA+0x0900)) &= ~0x1c000000;  //[28:26] = 3'h0
    *((UINT32P)(APMCU_RIUBASE+X32_DDRPHY_CHA+0x0900)) |=  0x04000000;  //[28:26] SHU_PHYPLL0_RG_RPHYPLL_IBIAS = 3'h1

    //temp_rdata = *((UINT32P)(APMCU_RIUBASE+X32_DDRPHY_CHA+0x0040));
    //temp_rdata = temp_rdata & 0xffffff00;  //[7:0] = 8'h0
    //temp_rdata = temp_rdata | 0x00000032;
    *((UINT32P)(APMCU_RIUBASE+X32_DDRPHY_CHA+0x0040)) = 0x00000232;  //[7:4] PLL0_RG_DDRPLL_LOOP_DIV_SECOND = 4'h3
                                                                     //[1:0] PLL0_RG_DDRPLL_LOOP_DIV_FIRST  = 2'h2

    *((UINT16P)(APMCU_RIUBASE+RIU_MIU_SSC_CH0+0x018*4)) = 0xAF8B;   //[15: 0]			    reg_ddfset[15: 0]
    *((UINT16P)(APMCU_RIUBASE+RIU_MIU_SSC_CH0+0x019*4)) = 0x0018;   //[12]	reg_ddrpll_reset,   reg_ddfset[23:16]
    *((UINT16P)(APMCU_RIUBASE+RIU_MIU_SSC_CH1+0x018*4)) = 0xAF8B;   //[15: 0]			    reg_ddfset[15: 0]
    *((UINT16P)(APMCU_RIUBASE+RIU_MIU_SSC_CH1+0x019*4)) = 0x0018;   //[12]	reg_ddrpll_reset,   reg_ddfset[23:16]

    delay_us_fpc  (10) ;
 
    frq_result = FTFMeter(CHANNEL_AB, 2,420,10) ;  //DRAMC_CGCLK_CHA
    if( (frq_result == 0 ) )
    {
	pat_pass = 0x0 ;
      SET_FPC_GPIO_FLAG__PAT_DBG_2
    }

    frq_result = FTFMeter(CHANNEL_CD, 2,420,10) ;  //DRAMC_CGCLK_CHA
    if( (frq_result == 0 ) )
    {
	pat_pass = 0x0 ;
      SET_FPC_GPIO_FLAG__PAT_DBG_3
    }


    //disable DDRPHY
    *((UINT32P)(APMCU_RIUBASE+X32_DDRPHY_CHA+0x0000)) = 0x00000000;  //[31] RG_RG_RPHYPLL_EN
    delay_us_fpc  (500) ;

    *((UINT32P)(APMCU_RIUBASE+X32_DDRPHY_CHA+0x0900)) &= ~0x1c000000;  //[28:26] SHU_PHYPLL0_RG_RPHYPLL_IBIAS = 3'h0

    //temp_rdata = *((UINT32P)(APMCU_RIUBASE+X32_DDRPHY_CHA+0x0040));
    //temp_rdata = temp_rdata & 0xffffff00;  //[7:0] = 8'h0
    //temp_rdata = temp_rdata | 0x00000022;
    *((UINT32P)(APMCU_RIUBASE+X32_DDRPHY_CHA+0x0040)) = 0x00000222;  //[7:4] PLL0_RG_DDRPLL_LOOP_DIV_SECOND = 4'h2
                                                                     //[1:0] PLL0_RG_DDRPLL_LOOP_DIV_FIRST  = 2'h2

    *((UINT16P)(APMCU_RIUBASE+RIU_MIU_SSC_CH0+0x018*4)) = 0x7B7D;   //[15: 0]			    reg_ddfset[15: 0]
    *((UINT16P)(APMCU_RIUBASE+RIU_MIU_SSC_CH0+0x019*4)) = 0x0029;   //[12]	reg_ddrpll_reset,   reg_ddfset[23:16]
    *((UINT16P)(APMCU_RIUBASE+RIU_MIU_SSC_CH1+0x018*4)) = 0x7B7D;   //[15: 0]			    reg_ddfset[15: 0]
    *((UINT16P)(APMCU_RIUBASE+RIU_MIU_SSC_CH1+0x019*4)) = 0x0029;   //[12]	reg_ddrpll_reset,   reg_ddfset[23:16]

    delay_us_fpc  (10) ;

    //enable DDRPHY
    *((UINT32P)(APMCU_RIUBASE+X32_DDRPHY_CHA+0x0000)) = 0x80000000;  //[31] RG_RG_RPHYPLL_EN
    delay_us_fpc  (500) ;
 
    frq_result = FTFMeter(CHANNEL_AB, 2,333,10) ;  //DRAMC_CGCLK_CHA
    if( (frq_result == 0 ) )
    {
	pat_pass = 0x0 ;
      SET_FPC_GPIO_FLAG__PAT_DBG_4
    }


    frq_result = FTFMeter(CHANNEL_CD, 2,333,10) ;  //DRAMC_CGCLK_CHA
    if( (frq_result == 0 ) )
    {
	pat_pass = 0x0 ;
      SET_FPC_GPIO_FLAG__PAT_DBG_5
    }



    if (pat_pass == 0x1) {
      SET_FPC_GPIO_FLAG__PAT_PASS
    }
    else{
      SET_FPC_GPIO_FLAG__PAT_FAIL
    }


}

#endif


#ifdef DRV_EFUSE_TEST
void fpc_kgd_64b_drv_driving_test ()	//(unsigned int addr, unsigned int num, unsigned int offset,  unsigned int data)
{
    int mode;
    

//1	select GPIO	1
  *((UINT32P)(APMCU_RIUBASE+X32_DDRPHY_CHA+0x04D0)) |=  0x01000000;  //[24] RG_TX_ARCMD_SEL_GPIO
  *((UINT32P)(APMCU_RIUBASE+X32_DDRPHY_CHA+0x0550)) |=  0x01000000;  //[24] RG_TX_ARDQ_SEL_GPIO_B0
  *((UINT32P)(APMCU_RIUBASE+X32_DDRPHY_CHA+0x05D0)) |=  0x01000000;  //[24] RG_TX_ARDQ_SEL_GPIO_B1
//2	Release OENZ	0
  *((UINT32P)(APMCU_RIUBASE+X32_DDRPHY_CHA+0x04D0)) &= ~0x00100000;  //[20] RG_TX_ARCMD_GPIO_OENZ
  *((UINT32P)(APMCU_RIUBASE+X32_DDRPHY_CHA+0x0550)) &= ~0x00100000;  //[20] RG_TX_ARDQ_GPIO_OENZ_B0
  *((UINT32P)(APMCU_RIUBASE+X32_DDRPHY_CHA+0x05D0)) &= ~0x00100000;  //[20] RG_TX_ARDQ_GPIO_OENZ_B1
//3	Enable TX	1
  *((UINT32P)(APMCU_RIUBASE+X32_DDRPHY_CHA+0x0480)) |=  0x00000004;  //[2] RG_TX_ARCMD_EN
  *((UINT32P)(APMCU_RIUBASE+X32_DDRPHY_CHA+0x0500)) |=  0x00000004;  //[2] RG_TX_ARDQ_EN_B0
  *((UINT32P)(APMCU_RIUBASE+X32_DDRPHY_CHA+0x0580)) |=  0x00000004;  //[2] RG_TX_ARDQ_EN_B1

#ifdef DRV_63_DRIVING_HIGH_TEST
//4	GPIO set high	1
  *((UINT32P)(APMCU_RIUBASE+X32_DDRPHY_CHA+0x04D0)) |=  0x00000400;  //[10]   RG_TX_ARCMD_GPIO
  *((UINT32P)(APMCU_RIUBASE+X32_DDRPHY_CHA+0x04BC)) |=  0x00003f3f;  //[13:8] RG_TX_ARCMD_DRVP
                                                                     //[5:0]  RG_TX_ARCMD_DRVN
#endif


#ifdef DRV_39_DRIVING_HIGH_TEST
//4	GPIO set high	1
  *((UINT32P)(APMCU_RIUBASE+X32_DDRPHY_CHA+0x04D0)) |=  0x00000400;  //[10]   RG_TX_ARCMD_GPIO
  *((UINT32P)(APMCU_RIUBASE+X32_DDRPHY_CHA+0x04BC)) |=  0x00002727;  //[13:8] RG_TX_ARCMD_DRVP
                                                                     //[5:0]  RG_TX_ARCMD_DRVN
#endif

#ifdef DRV_63_DRIVING_LOW_TEST
//4	GPIO set low	0
  *((UINT32P)(APMCU_RIUBASE+X32_DDRPHY_CHA+0x04D0)) &= ~0x00000400;  //[10]   RG_TX_ARCMD_GPIO
  *((UINT32P)(APMCU_RIUBASE+X32_DDRPHY_CHA+0x04BC)) |=  0x00003f3f;  //[13:8] RG_TX_ARCMD_DRVP
                                                                     //[5:0]  RG_TX_ARCMD_DRVN
#endif


#ifdef DRV_39_DRIVING_LOW_TEST
//4	GPIO set low	0
  *((UINT32P)(APMCU_RIUBASE+X32_DDRPHY_CHA+0x04D0)) &= ~0x00000400;  //[10]   RG_TX_ARCMD_GPIO
  *((UINT32P)(APMCU_RIUBASE+X32_DDRPHY_CHA+0x04BC)) |=  0x00002727;  //[13:8] RG_TX_ARCMD_DRVP
                                                                     //[5:0]  RG_TX_ARCMD_DRVN
#endif

  mcDELAY_US(100);
    SET_FPC_GPIO_FLAG__PAT_PASS

}
#endif




#ifdef RX_LDO_VOLTAGE_TEST

void fpc_kgd_64b_rx_ldo_voltage_test ()	//(unsigned int addr, unsigned int num, unsigned int offset,  unsigned int data)
{
    int reg_rdata_cha;
    int reg_rdata_chc;

    DramcBroadcastOnOff(0);
    reg_rdata_cha = *((UINT32P)(APMCU_RIUBASE+X32_DDRPHY_CHA+0x0044));
    reg_rdata_chc = *((UINT32P)(APMCU_RIUBASE+X32_DDRPHY_CHC+0x0044));

    #ifdef DDR3_EN
	reg_rdata_cha |=  (0x1 << 0);      //[0:0]   RG_DDRLDO_EN		= 1'h1
	reg_rdata_cha &= ~(0x3 << 1);      //[2:1]   RG_DDRLDO_IDC[1:0]		= 2'h0
	reg_rdata_cha &= ~(0x3 << 4);      //[5:4]   RG_DDRLDO_VBN_VOSEL[1:0]   = 2'h0
	reg_rdata_cha &= ~(0x3 << 6);      //[7:6]   RG_DDRLDO_VBP_VOSEL[1:0]   = 2'h0
	reg_rdata_cha &= ~(0x1 << 8);      //[8:8]   RG_LDO_DDR4_SEL		= 1'h0
	reg_rdata_cha &= ~(0x1 << 17);     //[17:17] RG_RX_LDO_PD		= 1'h0
	reg_rdata_cha &= ~(0x7 << 20);     //[22:20] RG_RX_LDO_OUTPUT_SEL[2:0]  = 3'h0
	
	reg_rdata_chc |=  (0x1 << 0);      //[0:0]   RG_DDRLDO_EN		= 1'h1
	reg_rdata_chc &= ~(0x3 << 1);      //[2:1]   RG_DDRLDO_IDC[1:0]		= 2'h0
	reg_rdata_chc &= ~(0x3 << 4);      //[5:4]   RG_DDRLDO_VBN_VOSEL[1:0]   = 2'h0
	reg_rdata_chc &= ~(0x3 << 6);      //[7:6]   RG_DDRLDO_VBP_VOSEL[1:0]   = 2'h0
	reg_rdata_chc &= ~(0x1 << 8);      //[8:8]   RG_LDO_DDR4_SEL		= 1'h0
	reg_rdata_chc &= ~(0x1 << 17);     //[17:17] RG_RX_LDO_PD		= 1'h0
	reg_rdata_chc &= ~(0x7 << 20);     //[22:20] RG_RX_LDO_OUTPUT_SEL[2:0]  = 3'h0
    #else //DDR4
	reg_rdata_cha |=  (0x1 << 0);       //[0:0]   RG_DDRLDO_EN		  = 1'h1
	reg_rdata_cha |=  (0x3 << 1);       //[2:1]   RG_DDRLDO_IDC[1:0]	  = 2'h1
	reg_rdata_cha &= ~(0x3 << 4);       //[5:4]   RG_DDRLDO_VBN_VOSEL[1:0]	  = 2'h0
	reg_rdata_cha &= ~(0x3 << 6);       //[7:6]   RG_DDRLDO_VBP_VOSEL[1:0]	  = 2'h0
	reg_rdata_cha |=  (0x1 << 8);       //[8:8]   RG_LDO_DDR4_SEL		  = 1'h1
	reg_rdata_cha &= ~(0x1 << 17);      //[17:17] RG_RX_LDO_PD		  = 1'h0
	reg_rdata_cha &= ~(0x7 << 20);      //[22:20] RG_RX_LDO_OUTPUT_SEL[2:0]	  = 3'h0
	
	reg_rdata_chc |=  (0x1 << 0);       //[0:0]   RG_DDRLDO_EN		  = 1'h1
	reg_rdata_chc |=  (0x3 << 1);       //[2:1]   RG_DDRLDO_IDC[1:0]	  = 2'h1
	reg_rdata_chc &= ~(0x3 << 4);       //[5:4]   RG_DDRLDO_VBN_VOSEL[1:0]	  = 2'h0
	reg_rdata_chc &= ~(0x3 << 6);       //[7:6]   RG_DDRLDO_VBP_VOSEL[1:0]	  = 2'h0
	reg_rdata_chc |=  (0x1 << 8);       //[8:8]   RG_LDO_DDR4_SEL		  = 1'h1
	reg_rdata_chc &= ~(0x1 << 17);      //[17:17] RG_RX_LDO_PD		  = 1'h0
	reg_rdata_chc &= ~(0x7 << 20);      //[22:20] RG_RX_LDO_OUTPUT_SEL[2:0]	  = 3'h0
    #endif

    *((UINT32P)(APMCU_RIUBASE+X32_DDRPHY_CHA+0x0044)) = reg_rdata_cha;
    *((UINT32P)(APMCU_RIUBASE+X32_DDRPHY_CHC+0x0044)) = reg_rdata_chc;
    mcDELAY_US(100);
    SET_FPC_GPIO_FLAG__PAT_PASS

}

#endif



