#ifndef _KGD_COMMON__FUNCTIONS_H
#define _KGD_COMMON__FUNCTIONS_H

#include "dramc_common.h"
#include "dramc_int_global.h"
#include "x_hal_io.h"


#define READ_REGISTER_UINT32_BIST(reg) \
    (*(volatile UINT32 * const)(reg))
#define WRITE_REGISTER_UINT32_BIST(reg, val) \
    (*(volatile UINT32 * const)(reg)) = (val)
#define INREG32_BIST(x)                  READ_REGISTER_UINT32_BIST((UINT32*)(x))
#define DRV_Reg32_BIST(addr)             INREG32_BIST(addr)

#define OUTREG32_BIST(x, y)              WRITE_REGISTER_UINT32_BIST((UINT32*)(x), (UINT32)(y))
#define DRV_WriteReg32_BIST(addr, data)  OUTREG32_BIST(addr, data)

#define READ_REG_BIST(REG)           INREG32_BIST(REG)
#define WRITE_REG_BIST(REG, VAL)     OUTREG32_BIST(REG, VAL)

/************************************************************************************************
 *
 *  Common Definition (Full memory API)
 *
 ************************************************************************************************/
void kgd_bist_test_pre_setting(u64 addr, u32 stop_addr, u32 channel_shifter); //mike jacob update for version 2
void kgd_bist_test_check(u32 pass, u32 mode, u32 waitus);


/************************************************************************************************
 *
 *  Boundary test API Definition
 *
 ************************************************************************************************/
void kgd_bist_boundary_test();
void kgd_bist_boundary_test_launch(u32 mode);
void kgd_bist_boundary_test_pre_setting(u64 bank, u32 start_addr, u32 stop_addr, u32 channel_shifter);


/************************************************************************************************
 *
 *  Pin Connecttivity API Definition
 *
 ************************************************************************************************/
void kgd_bist_pin_connecttivity_test();
void kgd_bist_pin_connecttivity_test_launch(u32 mode, u32 addr, u32 data ,u32 read);


#endif //_KGD_COMMON__FUNCTIONS_H
