#include "dramc_common.h"

//==============================================================


#if 0
void vSetPHY2ChannelMapping(DRAMC_CTX_T *p, U8 u1Channel)
{
  p->channel = u1Channel;
}

U8 vGetPHY2ChannelMapping(DRAMC_CTX_T *p)
{
  return p->channel;
}

void vSetRank(DRAMC_CTX_T *p, U8 ucRank)
{
  p->rank = ucRank;
}

U8 u1GetRank(DRAMC_CTX_T *p)
{
  return p->rank;
}

void DramcBroadcastOnOff(U32 bOnOff)
{
  if(bOnOff)
  {
    broadcast_on();
    mcSHOW_DBG_MSG("Broadcast ON\n");
  }
  else
  {
    broadcast_off();
    mcSHOW_DBG_MSG("Broadcast OFF\n");
  }
}

U8 u1IsLP4Family(DRAM_DRAM_TYPE_T dram_type)
{
    if (dram_type == TYPE_LPDDR4 || dram_type == TYPE_LPDDR4X || dram_type == TYPE_LPDDR4P)
        return 1;
    else
        return 0;
}

void setFreqGroup(DRAMC_CTX_T *p)
{

    /* Below listed conditions represent freqs that exist in ACTimingTable
     * -> Should cover freqGroup settings for all real freq values
     */
    if (u1IsLP4Family(p->dram_type))
    {
        if (p->frequency <= 400) // DDR800
        {
            p->freqGroup = 400;
        }
        else if (p->frequency <= 600) // DDR1200
        {
            p->freqGroup = 600;
        }
        else if (p->frequency <= 800) // DDR1600
        {
            p->freqGroup = 800;
        }
        else if (p->frequency <= 1200) //DDR2400, DDR2280
        {
            p->freqGroup = 1200;
        }
        else if (p->frequency <= 1333) // DDR2667
        {
            p->freqGroup = 1333;
        }
        else if (p->frequency <= 1600) // DDR3200
        {
            p->freqGroup = 1600;
        }
        else  // DDR3733
        {
            p->freqGroup = 1866;
        }
    }
    else
    {
        if (p->frequency <= 600) // DDR1200
        {
            p->freqGroup = 600;
        }
        else if (p->frequency <= 667) // DDR1333
        {
            p->freqGroup = 667;
        }
        else if (p->frequency <= 800) // DDR1600
        {
            p->freqGroup = 800;
        }
        else // DDR1866
        {
            p->freqGroup = 933;
        }
    }

    mcSHOW_DBG_MSG3(("[setFreqGroup] p-> frequency %u, freqGroup: %u\n", p->frequency, p->freqGroup));
    return;
}

void DDRPhyFreqSel(DRAMC_CTX_T *p, DRAM_PLL_FREQ_SEL_T sel)
{
    p->freq_sel = sel;

    switch(p->freq_sel)
    {
        case LP4_DDR3733:
            p->frequency=1866;
            break;
        case LP4_DDR3200:
            p->frequency=1600;
            break;
        case LP4_DDR2667:
            p->frequency=1333;
            break;
        case LP4_DDR2400:
            p->frequency=1200;
            break;
        case LP4_DDR1600:
            p->frequency=800;
            break;
        case LP4_DDR1200:
            p->frequency=600;
            break;
        case LP4_DDR800:
            p->frequency=400;
            break;
        default:
            p->frequency=800;
            break;
    }

    p->dram_fsp = (p->frequency < MRFSP_TERM_FREQ) ? FSP_0 : FSP_1;
    p->odt_onoff = (p->frequency < MRFSP_TERM_FREQ) ? ODT_OFF : ODT_ON;
#if (ENABLE_DQ3200_UNTERM == 1)
    if ((p->frequency==1333) || (p->frequency==1600))
        p->odt_onoff = ODT_OFF;
#endif

    if(p->dram_type == TYPE_LPDDR4P)
        p->odt_onoff = ODT_OFF;

    setFreqGroup(p); /* Set p->freqGroup to support freqs not in ACTimingTable */

    ///TODO: add DBI_onoff by condition
    //p->DBI_onoff = p->odt_onoff;
}

void vSetDFSFreqSelByTable(DRAMC_CTX_T *p, DRAM_DFS_FREQUENCY_TABLE_T *pFreqTable)
{
    p->pDFSTable = pFreqTable;
    DDRPhyFreqSel(p, p->pDFSTable->freq_sel);
}

DIV_MODE_T vGet_Div_Mode(DRAMC_CTX_T *p)
{
    return p->pDFSTable->divmode;
}

DRAM_CBT_MODE_T vGet_Dram_CBT_Mode(DRAMC_CTX_T *p)
{
    if(p->dram_cbt_mode[RANK_0] == CBT_NORMAL_MODE && p->dram_cbt_mode[RANK_1] == CBT_NORMAL_MODE)
    {
        return CBT_NORMAL_MODE;
    }
    else // For Mixed mode & Byte mode LP4
    {
        return CBT_BYTE_MODE1;
    }
}
#endif


