//#include <stdint.h>//for intptr_t
#include "emi_hw.h"
#include "dramc_common.h"
#include "dramc_int_global.h"
#include "x_hal_io.h"
#include "fake_engine.h"
#include "ett_test.h"
#if __ETT__
#include <barriers.h>
#endif

int global_fake_engine_loop = 1;

int Reg_Sync_Writel(U32 addr, unsigned int val)
{
    (*(volatile unsigned int *)(addr)) = val;
    //mcSHOW_DBG_MSG("@@@ Write Reg:0x%X Value:0x%X\n", addr, val);
    dsb();
    return 0;
}


unsigned int Reg_Readl(U32 addr)
{
    return (*(volatile unsigned int *)(addr));
}

void Set_EMI_Golden_Setting(void)
{
    Reg_Sync_Writel(0x10219400, 0x00FF0008);
    Reg_Sync_Writel(0x1021d400, 0x00FF0008);
    Reg_Sync_Writel(0x10219068, 0x00600000);
    Reg_Sync_Writel(0x1021d068, 0x00600000);
    Reg_Sync_Writel(0x10235050, 0x38460016);
    Reg_Sync_Writel(0x10245050, 0x38460016);
    Reg_Sync_Writel(0x10255050, 0x38460016);
    Reg_Sync_Writel(0x10265050, 0x38460016);
    Reg_Sync_Writel(0x10219400, 0x00FF0000);
    Reg_Sync_Writel(0x1021d400, 0x00FF0000);
}

void Set_Display_Power_On(void)//int spm_mtcmos_ctrl_dis(int state)
{
    Reg_Sync_Writel(POWERON_CONFIG_EN, (SPM_PROJECT_CODE << 16) | (0x1 << 0));

    /* STA_POWER_ON */
    /* TINFO="Start to turn on DIS" */
    /* TINFO="Set PWR_ON = 1" */
    Reg_Sync_Writel(DIS_PWR_CON, Reg_Readl(DIS_PWR_CON) | PWR_ON);
    /* TINFO="Set PWR_ON_2ND = 1" */
    Reg_Sync_Writel(DIS_PWR_CON, Reg_Readl(DIS_PWR_CON) | PWR_ON_2ND);
#ifndef IGNORE_MTCMOS_CHECK
    /* TINFO="Wait until PWR_STATUS = 1 and PWR_STATUS_2ND = 1" */
    while (((Reg_Readl(PWR_STATUS) & DIS_PWR_STA_MASK) != DIS_PWR_STA_MASK)
        || ((Reg_Readl(PWR_STATUS_2ND) & DIS_PWR_STA_MASK) != DIS_PWR_STA_MASK)) {
            /* No logic between pwr_on and pwr_ack. Print SRAM / MTCMOS control and PWR_ACK for debug. */
    }
#endif
    /* TINFO="Set PWR_CLK_DIS = 0" */
    Reg_Sync_Writel(DIS_PWR_CON, Reg_Readl(DIS_PWR_CON) & ~PWR_CLK_DIS);
    /* TINFO="Set PWR_ISO = 0" */
    Reg_Sync_Writel(DIS_PWR_CON, Reg_Readl(DIS_PWR_CON) & ~PWR_ISO);
    /* TINFO="Set PWR_RST_B = 1" */
    Reg_Sync_Writel(DIS_PWR_CON, Reg_Readl(DIS_PWR_CON) | PWR_RST_B);
    /* TINFO="Set SRAM_PDN = 0" */
    Reg_Sync_Writel(DIS_PWR_CON, Reg_Readl(DIS_PWR_CON) & ~(0x1 << 8));
#ifndef IGNORE_MTCMOS_CHECK
    /* TINFO="Wait until DIS_SRAM_PDN_ACK_BIT0 = 0" */
    while (Reg_Readl(DIS_PWR_CON) & DIS_SRAM_PDN_ACK_BIT0) {
            /* Need hf_fmm_ck for SRAM PDN delay IP. */
    }
#endif

    return;
}


static void Smi_Init(void)//enable larb0, larb1, larb2, larb3
{
    int i;
    U32 u4Value = 0;

    //Enable DISP SMI clock
    Reg_Sync_Writel(MMSYS_CG_CLR0, (0x1 << 11) | (0x1 << 17) | (0x1 << 27)); //enalbe emi_common and gals clock
    Reg_Sync_Writel(MMSYS_CG_CLR1, 0x1); //enalbe emi_common and gals clock

    //Enable MDP SMI_COMMON
    Reg_Sync_Writel(DISP_SMI_MON_ENA_MON0, 0);
    Reg_Sync_Writel(DISP_SMI_MON_CLR_MON0, 1);
    Reg_Sync_Writel(DISP_SMI_BUS_SEL, 0x4444);

    //Enable LARB 0~1
    Reg_Sync_Writel(MMSYS_CG_CLR1, 1<<19);

    //Disable IO_MMU
    for (i =0 ; i <31 ; i++) 
    {
        u4Value = Reg_Readl(SMI_LARB0_BASE + 0x380 + (i<<2));
        Reg_Sync_Writel(SMI_LARB0_BASE + 0x380 + (i<<2), u4Value & 0xfffffffe);
        u4Value = Reg_Readl(SMI_LARB0_BASE + 0xF80 + (i<<2));
        Reg_Sync_Writel(SMI_LARB0_BASE + 0xF80 + (i<<2), u4Value & 0xfffffffe);

        u4Value = Reg_Readl(SMI_LARB1_BASE + 0x380 + (i<<2));
        Reg_Sync_Writel(SMI_LARB1_BASE + 0x380 + (i<<2), u4Value & 0xfffffffe);
        u4Value = Reg_Readl(SMI_LARB1_BASE + 0xF80 + (i<<2));
        Reg_Sync_Writel(SMI_LARB1_BASE + 0xF80 + (i<<2), u4Value & 0xfffffffe);

   }
}

U32 global_fake_engine_start_addr1_wr = FAKE_ENG_WR_ADDR;
U32 global_fake_engine_start_addr2_wr = FAKE_ENG2_WR_ADDR;
U32 global_fake_engine_start_addr1_rd = FAKE_ENG_RD_ADDR;
U32 global_fake_engine_start_addr2_rd = FAKE_ENG2_RD_ADDR;
U8 global_fake_engine_burst_length = 8;
int global_fake_engine_delay = 0;
int global_toogle_length = FAKE_ENGINE_TOGGLE_BITS_128;

void Fake_Engine_Presetting(DRAMC_CTX_T * p)//Infra_Fake_Engine_Preprocess
{
    int i = 0;
    U32 u4Value = 0;

    if(p->support_rank_num == RANK_SINGLE) //Set Read/Write address to R0
    {
        global_fake_engine_start_addr1_wr = 0x40400000;
        global_fake_engine_start_addr2_wr = 0x50400000;
        global_fake_engine_start_addr1_rd = 0x40400000;
        global_fake_engine_start_addr2_rd = 0x50400000;
    }

    //SET_POWER_ON
    //mcSHOW_DBG_MSG_LPS("display pwr on\n");
    Set_Display_Power_On();

    Reg_Sync_Writel(MMSYS_CG_CLR0, 0xffffffff);
    Reg_Sync_Writel(MMSYS_CG_CLR1, 0xffffffff);
    Reg_Sync_Writel(MMSYS_CG_CLR2, 0xffffffff);

    //SMI init
    Smi_Init();

    //CKSEL
    Reg_Sync_Writel(CLK_CFG_1_CLR, 0xf);
    Reg_Sync_Writel(CLK_CFG_1_SET, 0x8);    
    Reg_Sync_Writel(CLK_CFG_UPDATE, 1<<4);   

    //EMI/DRAMC setting
    DramcBroadcastOnOff(DRAMC_BROADCAST_ON);    

    Reg_Sync_Writel(MMSYS_RDMA_SHARE_SRAM_CON, 0x30);
    Reg_Sync_Writel(EMI_IOCL, 0xcfcfcfcf);
    Reg_Sync_Writel(EMI_IOCL_2ND, 0x77777777);
    Reg_Sync_Writel(EMI_IOCM, 0xcfcfcfcf);
    Reg_Sync_Writel(EMI_IOCM_2ND, 0xcfcfcfcf);
    DramcBroadcastOnOff(DRAMC_BROADCAST_OFF);  

    Set_EMI_Golden_Setting();
}


static void Check_Fake_Engine_State(void)
{
    U32 u4value = 0;

    u4value = *(volatile unsigned int*)(DISP_FAKE_ENG_STATE);
    mcSHOW_DBG_MSG_LPS("\nCheck Agent1: ");
    if(u4value & 0x01)
    {
        u4value = *(volatile unsigned int*)(DISP_FAKE_ENG_STATE); 
        mcSHOW_DBG_MSG_LPS("Agent1 is still busy\n");
    }

    u4value = *(volatile unsigned int*)(DISP_FAKE_ENG2_STATE);
    mcSHOW_DBG_MSG_LPS("\nCheck Agent2: ");
    if(u4value & 0x01)
    {
        u4value = *(volatile unsigned int*)(DISP_FAKE_ENG2_STATE); 
        mcSHOW_DBG_MSG_LPS("Agent2 is still busy\n");
    }
}


void Fake_Engine_Set_RW_Address(U32 u4ReadAddr, U32 u4WriteAddr)
{
    Reg_Sync_Writel(DISP_FAKE_ENG_RD_ADDR, u4ReadAddr);
    Reg_Sync_Writel(DISP_FAKE_ENG_WR_ADDR, u4WriteAddr);
}


void Fake_Engine2_Set_RW_Address(U32 u4ReadAddr, U32 u4WriteAddr)
{
    Reg_Sync_Writel(DISP_FAKE_ENG2_RD_ADDR, u4ReadAddr);
    Reg_Sync_Writel(DISP_FAKE_ENG2_WR_ADDR, u4WriteAddr);
}

#define REAL_PWR_ESTIMATION 0//0: for power correlation 1: for real case, toogle 32->256
#define CHECK_FAKE_ENGINE_WRITE_WITH_CPU
static void MM_Fake_Engine_Access(TRANS_TYPE trans_type, int loop)
{
    U32 u4value = 0;
    U32 u4TestLen = 0x800;

    //Engine 1
    Fake_Engine_Set_RW_Address(global_fake_engine_start_addr1_rd, global_fake_engine_start_addr1_wr);
#if REAL_PWR_ESTIMATION 
    if(loop == 1)
    {
        Reg_Sync_Writel(DISP_FAKE_ENG_CON0, (2<<24) | (1<<22) | u4TestLen);//CON0: patter(24th):toggle every 64bits, loop mode(22th), length = 2048 
    }
    else
    {
        Reg_Sync_Writel(DISP_FAKE_ENG_CON0, (2<<24) | u4TestLen);//CON0: patter(24th):toggle every 64bits, length = 2048         
    }
#else
    if(loop == 1)
    {
        Reg_Sync_Writel(DISP_FAKE_ENG_CON0, (global_toogle_length<<24) | (1<<22) | u4TestLen);//CON0: patter(24th):toggle every 64bits, loop mode(22th), length = 2048 
    }
    else
    {
        Reg_Sync_Writel(DISP_FAKE_ENG_CON0, (global_toogle_length<<24) | u4TestLen);//CON0: patter(24th):toggle every 64bits, length = 2048         
    }
#endif

    if(trans_type == R)//FER
    {
        Reg_Sync_Writel(DISP_FAKE_ENG_CON1, ((global_fake_engine_burst_length - 1)<<12) | (1<<11) | (global_fake_engine_delay & 0x3FF));//CON1: burst lenght = 8, disable write
    }
    else if(trans_type == W)//FEW
    {
        Reg_Sync_Writel(DISP_FAKE_ENG_CON1, ((global_fake_engine_burst_length - 1)<<12) | (1<<10) | (global_fake_engine_delay & 0x3FF));//CON1: burst lenght = 8, disable read
    }
    else if(trans_type == RW)//FERW
    {
        Reg_Sync_Writel(DISP_FAKE_ENG_CON1, ((global_fake_engine_burst_length - 1)<<12) | (global_fake_engine_delay & 0x3FF));//CON1: burst lenght = 8
    }
    else
    {
        mcSHOW_DBG_MSG_LPS("! Wrong command type in FakeAgentAccess...\n");
    }

#if REAL_PWR_ESTIMATION 
    Reg_Sync_Writel(DISP_FAKE_ENG_RST, 1);
    Reg_Sync_Writel(DISP_FAKE_ENG_RST, 0);
#endif
    
    //Engine 1
    Reg_Sync_Writel(DISP_FAKE_ENG_EN, 1);//disable fake
    Reg_Sync_Writel(DISP_FAKE_ENG_EN, 3);//enable fake

#if REAL_PWR_ESTIMATION 
    if(loop == 1)
    {
        Reg_Sync_Writel(DISP_FAKE_ENG_CON0, (5<<24) | (1<<22) | u4TestLen);//CON0: patter(24th):toggle every 64bits, loop mode(22th), length = 2048 
    }
    else
    {
        Reg_Sync_Writel(DISP_FAKE_ENG_CON0, (5<<24) | u4TestLen);//CON0: patter(24th):toggle every 64bits, length = 2048         
    }
#endif

    if(loop == 0)
    {
        Reg_Sync_Writel(DISP_FAKE_ENG_EN, 1);//disable fake
    }
    return;
}


static void MM_Fake_Engine2_Access(TRANS_TYPE trans_type, int loop)
{
    U32 u4value = 0;
    U32 u4TestLen = 0x800;

    //Engine 1
    Fake_Engine2_Set_RW_Address(global_fake_engine_start_addr2_rd, global_fake_engine_start_addr2_wr);

#if REAL_PWR_ESTIMATION 
    if(loop == 1)
    {
        Reg_Sync_Writel(DISP_FAKE_ENG2_CON0, (2<<24) | (1<<22) | u4TestLen);//CON0: patter(24th):toggle every 64bits, loop mode(22th), length = 2048 
    }
    else
    {
        Reg_Sync_Writel(DISP_FAKE_ENG2_CON0, (2<<24) | u4TestLen);//CON0: patter(24th):toggle every 64bits, length = 2048         
    }
#else
    if(loop == 1)
    {
        Reg_Sync_Writel(DISP_FAKE_ENG2_CON0, (global_toogle_length<<24) | (1<<22) | u4TestLen);//CON0: patter(24th):toggle every 64bits, loop mode(22th), length = 2048 
    }
    else
    {
        Reg_Sync_Writel(DISP_FAKE_ENG2_CON0, (global_toogle_length<<24) | u4TestLen);//CON0: patter(24th):toggle every 64bits, length = 2048         
    }
#endif

    if(trans_type == R)//FER
    {
        Reg_Sync_Writel(DISP_FAKE_ENG2_CON1, ((global_fake_engine_burst_length - 1)<<12) | (1<<11) | (global_fake_engine_delay & 0x3FF));//CON1: burst lenght = 8, disable write
    }
    else if(trans_type == W)//FEW
    {
        Reg_Sync_Writel(DISP_FAKE_ENG2_CON1, ((global_fake_engine_burst_length - 1)<<12) | (1<<10) | (global_fake_engine_delay & 0x3FF));//CON1: burst lenght = 8, disable read
    }
    else if(trans_type == RW)//FERW
    {
        Reg_Sync_Writel(DISP_FAKE_ENG2_CON1, ((global_fake_engine_burst_length - 1)<<12) | (global_fake_engine_delay & 0x3FF));//CON1: burst lenght = 8
    }
    else
    {
        mcSHOW_DBG_MSG_LPS("! Wrong command type in FakeAgentAccess...\n");
    }

#if REAL_PWR_ESTIMATION 
    Reg_Sync_Writel(DISP_FAKE_ENG2_RST, 1);
    Reg_Sync_Writel(DISP_FAKE_ENG2_RST, 0);
#endif
    //Engine 2
    Reg_Sync_Writel(DISP_FAKE_ENG2_EN, 1);//disable fake
    Reg_Sync_Writel(DISP_FAKE_ENG2_EN, 3);//enable fake

#if REAL_PWR_ESTIMATION 
    if(loop == 1)
    {
        Reg_Sync_Writel(DISP_FAKE_ENG2_CON0, (5<<24) | (1<<22) | u4TestLen);//CON0: patter(24th):toggle every 64bits, loop mode(22th), length = 2048 
    }
    else
    {
        Reg_Sync_Writel(DISP_FAKE_ENG2_CON0, (5<<24) | u4TestLen);//CON0: patter(24th):toggle every 64bits, length = 2048         
    }
#endif

    if(loop == 0)
    {
        Reg_Sync_Writel(DISP_FAKE_ENG2_EN, 1);//disable fake
    }
    return;
}


void Fake_Engine_Access(DRAMC_CTX_T *p, TRANS_TYPE trans_type, int loop)
{
    MM_Fake_Engine_Access(trans_type, loop);
    MM_Fake_Engine2_Access(trans_type, loop);
    return;
}


void Disable_Fake_Engine(void)
{
    //mcSHOW_DBG_MSG_LPS("\nDisable Fake Agent...\n");
    Reg_Sync_Writel(DISP_FAKE_ENG_EN, 1);//disable fake engine 1
    Reg_Sync_Writel(DISP_FAKE_ENG2_EN, 1);//disable fake engine 2
}


void Enable_Fake_Engine(void)
{
    //mcSHOW_DBG_MSG_LPS("\nEnable Fake Agent...\n");
    Reg_Sync_Writel(DISP_FAKE_ENG_EN, 3);//enable fake engine 1
    Reg_Sync_Writel(DISP_FAKE_ENG2_EN, 3);//enable fake engine 2
}


static void Check_Fake_Engine_Pattern(U32 u4addr)
{
    U32 i = 0;
    static U32 u32Count = 0;

    //mcSHOW_DBG_MSG_LPS("Fake Engine check [0x%X] [%d times]", u4addr, u32Count);
    mcSHOW_DBG_MSG_LPS("Fake Engine check [%d times]", u32Count);
    for(i = u4addr; i<(u4addr + 0x200); i+=0x10)//Check 0x200 * 0x10 = 512 * 16 = 8192B
    {
        if((*((volatile U32 *)(i)) == 0xFFFFFFFF)&&
            (*((volatile U32 *)(i+4)) == 0xFFFFFFFF)&&
            (*((volatile U32 *)(i+8)) == 0x0)&&
            (*((volatile U32 *)(i+12)) == 0x0))
        {
            mcSHOW_DBG_MSG_LPS(".");
        }        
        else
        {
            mcSHOW_DBG_MSG_LPS("!Mismatch @ Add:[0x%X] = [0x%X][0x%X][0x%X][0x%X]!!!!!!\n", i, 
                *((volatile U32 *)(i)),
                *((volatile U32 *)(i+4)),
                *((volatile U32 *)(i+8)),
                *((volatile U32 *)(i+12)));
            while(1);
        }
    }
    mcSHOW_DBG_MSG_LPS("\n");
    u32Count += 1;
}


void Check_Fake_Engine_Write_toggle_64bits(U32 u4WriteAddr)
{
    Check_Fake_Engine_Pattern(u4WriteAddr);
} 


void Fake_Engine_Read_Write(DRAMC_CTX_T *p)
{
    mcSHOW_DBG_MSG("\nFERW\n");
    
    Fake_Engine_Access(p, RW, 1);
    Monitor_Bw(p, W);
#if MEASURE_DRAM_POWER_INDEX
    Check_Dram_Power_Index(p);
#endif     
#if SUPPORT_PICG_MONITOR
    Support_PICG_Monitor(p);
#endif
    while(1)
    {
        Check_Fake_Engine_State();
    }
    return;
}

#if SUPPORT_REQ_QUEUE_READ_LATERNCY_MONITOR
#define READ_LATERCY_CMD_RG_NUMBER 8
void Check_Read_Latency(DRAMC_CTX_T *p)//Just for ETT testing
{
    int iCmdIndex = 0;
    U32 u4RegArray[8] = {0};
    U32 u4maxValue = 0;
    U32 u4RegValue = 0;
    U32 u4RegValue1 = 0;

    vIO32WriteFldAlign(DRAMC_REG_ADDR(DRAMC_REG_DRAMC_PD_CTRL), 0, DRAMC_PD_CTRL_DCMEN2);//Set DRAMC_PD_CTRL_DCMEN2 to 0 of 2 channels in advance
    Reg_Sync_Writel(EMI_BMEN, Reg_Readl(EMI_BMEN) & ~0x3);//DQ0_TOGGLE_COUNTER will be 0 after disable EMI bus monitor

    //Set BUSMONEN_SW = 0 and MONPAUSE=0  to clear counter
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_DMMONITOR), P_Fld(0, DMMONITOR_BUSMONEN_SW) 
        | P_Fld(0, DMMONITOR_MONPAUSE_SW));
    
    vIO32WriteFldAlign(DRAMC_REG_ADDR(DRAMC_REG_DMMONITOR), 1, DMMONITOR_BUSMONEN_SW);//Trigger 8 latency counter
    mcDELAY_MS(100);
    vIO32WriteFldAlign(DRAMC_REG_ADDR(DRAMC_REG_DMMONITOR), 1, DMMONITOR_MONPAUSE_SW);//Stop max counter/flag update
    
    for(iCmdIndex = 0; iCmdIndex<READ_LATERCY_CMD_RG_NUMBER; iCmdIndex++)
    {
        u4RegArray[iCmdIndex] = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_LAT_COUNTER_CMD0 + iCmdIndex * 4), LAT_COUNTER_CMD0_LAT_CMD0_CNT_MAX);
        //mcSHOW_DBG_MSG_LPS("LAT_CMD%d_CNT_MAX[%d]\n", iCmdIndex, u4RegArray[iCmdIndex]);
    }    

    //find max 
    u4maxValue = u4RegArray[0];
    for(iCmdIndex = 1; iCmdIndex<READ_LATERCY_CMD_RG_NUMBER; iCmdIndex++)
    {
        if(u4RegArray[iCmdIndex] > u4maxValue)
            u4maxValue = u4RegArray[iCmdIndex];        
    }
    u4RegValue = u4IO32Read4B(DRAMC_REG_ADDR(DRAMC_REG_LAT_COUNTER_AVER));
    u4RegValue1 = u4IO32Read4B(DRAMC_REG_ADDR(DRAMC_REG_LAT_COUNTER_NUM));
    mcSHOW_DBG_MSG_LPS("%d \t%d \t%d \n", u4maxValue, u4RegValue, u4RegValue1);
}
#endif // SUPPORT_REQ_QUEUE_READ_LATERNCY_MONITOR

static void Fake_Engine_Bandwidth_Common(TRANS_TYPE trans_type);
#if SUPPORT_REQ_QUEUE_READ_LATERNCY_MONITOR
    #define FAKE_ENGINE_REQUEST_SIZE 6
    const int iRequestBw[FAKE_ENGINE_REQUEST_SIZE] = {90, 80, 60, 40, 20, 10};
    U16 u2RequestDelay[FAKE_ENGINE_REQUEST_SIZE] = {0};
#else
    #define FAKE_ENGINE_REQUEST_SIZE 16
    const int iRequestBw[FAKE_ENGINE_REQUEST_SIZE] = {90, 80, 70, 60, 50, 40, 30, 25, 20, 15, 10, 5, 4, 3, 2, 1};
    U16 u2RequestDelay[FAKE_ENGINE_REQUEST_SIZE] = {0};
#endif
void Fake_Engine_Read(DRAMC_CTX_T *p)
{
    int i = 0;
#if SUPPORT_REQ_QUEUE_READ_LATERNCY_MONITOR
    int iDelayIdx;
    DRAM_CHANNEL_T bkChannel = p->channel;
    Fake_Engine_Bandwidth_Common(R);

    for(p->channel = CHANNEL_A; p->channel < p->support_channel_num;  p->channel++)
    {
        mcSHOW_DBG_MSG_LPS("\nCH%c\n", 'A'+p->channel);
        for(i=0; i<2; i++)
        {
            vIO32WriteFldAlign_All(DRAMC_REG_REFCTRL1, (U32)i, REFCTRL1_REF_OVERHEAD_SLOW_REFPB_ENA); 
            mcSHOW_DBG_MSG_LPS("\nREF_OVERHEAD_SLOW_REFPB_ENA = %d\n", i);

            for(iDelayIdx = FAKE_ENGINE_REQUEST_SIZE - 1; iDelayIdx>=0; iDelayIdx--)
            {
                global_fake_engine_delay = u2RequestDelay[iDelayIdx];
                Fake_Engine_Access(p, W, 0);//Write with no loop
                Fake_Engine_Access(p, R, global_fake_engine_loop);
                Check_Read_Latency(p);
            }
        }
    }
    p->channel = bkChannel;
#elif SUPPORT_REQ_QUEUE_BLOCK_ALE
    DRAM_CHANNEL_T bkChannel = p->channel;
    Fake_Engine_Access(p, W, 0);//Write with no loop
    Fake_Engine_Access(p, R, global_fake_engine_loop);
    Monitor_Bw(p, R);
    for(p->channel = CHANNEL_A; p->channel <= CHANNEL_B;  p->channel++)
    {
        for(i=0; i<10; i++)
        {

            mcSHOW_DBG_MSG_LPS("\nCH%s times[%d]\n", 'A'+p->channel, i+1);
            Check_Req_Queue_Block_Ale(p);
        }
    }
    p->channel = bkChannel;
#else //Normal case
    mcSHOW_DBG_MSG("\nFER\n");
    //Fake_Engine_Access(p, W, 0);//Write with no loop
    Fake_Engine_Access(p, R, 1);
    Monitor_Bw(p, R);
#if MEASURE_DRAM_POWER_INDEX
    Check_Dram_Power_Index(p);
#endif 
#if SUPPORT_PICG_MONITOR
    Support_PICG_Monitor(p);
#endif
    while(1)
    {
        Check_Fake_Engine_State();
    }
#endif 
    return;
}


void Fake_Engine_Write(DRAMC_CTX_T *p)
{
    mcSHOW_DBG_MSG("\nFEW\n");
    Fake_Engine_Access(p, W, 1);
    Monitor_Bw(p, W);
#if MEASURE_DRAM_POWER_INDEX
    Check_Dram_Power_Index(p);
#endif 
#if SUPPORT_PICG_MONITOR
    Support_PICG_Monitor(p);
#endif
    while(1)
    {
        Check_Fake_Engine_State();
    }
    return;
}


#define FAKE_ENGINE_DELAY_MAX 1024
//#define FAKE_ENGINE_DELAY_MAX 300
static void Fake_Engine_Bandwidth_Common(TRANS_TYPE trans_type)
{
    int ratio = 0;  
    int i = 0;
    U8 u1request_idx = 0;
    DRAMC_CTX_T *p = psCurrDramCtx;

    global_fake_engine_delay = 0;
    while(global_fake_engine_delay<FAKE_ENGINE_DELAY_MAX) 
    {
        if(trans_type == R)
        {
            Fake_Engine_Access(p, W, 0);//Write with no loop
        }
        Fake_Engine_Access(p, trans_type, 1);

        ratio = Monitor_Bw(p, trans_type);//return BW * 10

        if(ratio <= iRequestBw[u1request_idx] * 10)
        {
            u2RequestDelay[u1request_idx] = global_fake_engine_delay;
            u1request_idx++;
        }
        Disable_Fake_Engine();
        if(u1request_idx == FAKE_ENGINE_REQUEST_SIZE)
            break;
    
        mcDELAY_MS(1);
        global_fake_engine_delay++;
    };
    for(i=0; i<FAKE_ENGINE_REQUEST_SIZE; i++)    
    {
#if !SUPPORT_PICG_MONITOR
        //mcSHOW_DBG_MSG_LPS("\nFake Request_bandwidth:  \033[1;36m%d\033[m, delay: \033[1;36m%d\033[m", iRequestBw[i], u2RequestDelay[i]);
        if(i==0)
        {
            mcSHOW_DBG_MSG_LPS("\nType:%d (0:R 1:W 2:RW)", trans_type);
        }
        mcSHOW_DBG_MSG_LPS("\nFake Request_bandwidth: %d, delay: %d", iRequestBw[i], u2RequestDelay[i]);

#else
        mcSHOW_DBG_MSG_LPS("\n%d %d", iRequestBw[i], u2RequestDelay[i]);
        global_fake_engine_delay = u2RequestDelay[i];
        if(trans_type == R)
        {
            Fake_Engine_Access(p, W, 0);//Write with no loop
        }
        Fake_Engine_Access(p, trans_type, 1);
        Support_PICG_Monitor(p);
        Disable_Fake_Engine();
#endif        
    }
}


void Fake_Engine_Bandwidth()//API for BU, could not use in ETT
{
    int global_fake_engine_delay_back;
    DRAMC_CTX_T *p;

    global_fake_engine_delay_back = global_fake_engine_delay;
    p = psCurrDramCtx;
    
#if SUPPORT_REQ_QUEUE_READ_LATERNCY_MONITOR
    //mcSHOW_DBG_MSG_LPS("\nFake engine read bandwidth [DDR\033[1;36m%d\033[m]",p->frequency<<1);
    mcSHOW_DBG_MSG_LPS("\nFake engine read bandwidth [DDR%d]",p->frequency<<1);
    Fake_Engine_Bandwidth_Common(R);
#else
    //mcSHOW_DBG_MSG_LPS("Fake engine write bandwidth [DDR\033[1;36m%d\033[m]",p->frequency<<1);
    mcSHOW_DBG_MSG_LPS("Fake engine write bandwidth [DDR%d]",p->frequency<<1);
    Fake_Engine_Bandwidth_Common(W);

    //mcSHOW_DBG_MSG_LPS("\nFake engine read bandwidth [DDR\033[1;36m%d\033[m]",p->frequency<<1);
    mcSHOW_DBG_MSG_LPS("\nFake engine read bandwidth [DDR%d]",p->frequency<<1);
    Fake_Engine_Bandwidth_Common(R);

    //mcSHOW_DBG_MSG_LPS("\nFake engine read + write bandwidth [DDR\033[1;36m%d\033[m]",p->frequency<<1);
    mcSHOW_DBG_MSG_LPS("\nFake engine read + write bandwidth [DDR%d]",p->frequency<<1);
    Fake_Engine_Bandwidth_Common(RW);
#endif
    global_fake_engine_delay = global_fake_engine_delay_back;
    return;
}

