#ifndef _PI_API_PCDDR_H
#define _PI_API_PCDDR_H

/*----------------------------------------------------------------------
  Add PCDDR specific define & typedef & function proto-type
 ----------------------------------------------------------------------*/
#define DDR4266_FREQ    (2133)
#define DDR3733_FREQ    (1866)
#define DDR3200_FREQ    (1600)
#define DDR2933_FREQ    (1467)
#define DDR2667_FREQ    (1333)
#define DDR2400_FREQ    (1200)
#define DDR2133_FREQ    (1066)
#define DDR1866_FREQ    (933)
#define DDR1600_FREQ    (800)
#define DDR1333_FREQ    (667)
#define DDR1200_FREQ    (600)
#define DDR1066_FREQ    (533)
#define DDR800_FREQ     (400)

#define DDR4_MRFSP_TERM_FREQ DDR2133_FREQ
#define DDR_VREF_VOLTAGE_TABLE_NUM 51

#if !FOR_DV_SIMULATION_USED
#define DDR_ENABLE_ZQ_CAL               1
#define DDR_ENABLE_SW_IMPED_CAL         1
#define DDR_ENABLE_MIOCK_JMETER_CAL     1
#define DDR_ENABLE_8PHASE_CAL           1
#define DDR_ENABLE_DUTY_CAL             1
#define DDR_ENABLE_RX_INPUT_BUF_CAL     0
#define DDR_ENABLE_WRITE_LEVELING_CAL   1
#define DDR_ENABLE_DUTY_CYC_MONITOR_CAL 1
#define DDR_ENABLE_GATING_CAL           1
#define DDR_ENABLE_DATLAT_CAL           1
#define DDR_ENABLE_RX_RDDQC_CAL         1
#define DDR_ENABLE_RX_PERBIT_CAL        1
#define DDR_ENABLE_TX_PERBIT_CAL        1  // Please enable with write leveling
#define DDR_ENABLE_RX_DVS_CAL           0
#define DDR_ENABLE_TX_OE_CAL            0
#define DDR_ENABLE_RUNTIME_CONFIG       1
#else
#define DDR_ENABLE_ZQ_CAL               1
#define DDR_ENABLE_SW_IMPED_CAL         1
#define DDR_ENABLE_MIOCK_JMETER_CAL     1
#define DDR_ENABLE_8PHASE_CAL           1
#define DDR_ENABLE_DUTY_CAL             1
#define DDR_ENABLE_RX_INPUT_BUF_CAL     0
#define DDR_ENABLE_WRITE_LEVELING_CAL   1
#define DDR_ENABLE_DUTY_CYC_MONITOR_CAL 0
#define DDR_ENABLE_GATING_CAL           1
#define DDR_ENABLE_DATLAT_CAL           1
#define DDR_ENABLE_RX_RDDQC_CAL         1
#define DDR_ENABLE_RX_PERBIT_CAL        1
#define DDR_ENABLE_TX_PERBIT_CAL        1  // Please enable with write leveling
#define DDR_ENABLE_RX_DVS_CAL           0
#define DDR_ENABLE_TX_OE_CAL            0
#define DDR_ENABLE_RUNTIME_CONFIG       1  // @Darren for DV sim
#endif

#define DDR_TX_K_DQM_WITH_WDBI          0

/* Feature */
#define DDR_ENABLE_READ_DBI                         0
#define DDR_ENABLE_WRITE_DBI                        0
#define DDR_ENABLE_PER_BANK_REFRESH                 0
#define DDR_TDQSCK_PRECALCULATION_FOR_DVFS          0
#define DDR_DRAMC_MODIFIED_REFRESH_MODE             1
#define DDR_DRAMC_CKE_DEBOUNCE                      0
#define DDR_ENABLE_TX_WDQS                          0
#define DDR_ENABLE_WL_AUTOK                         0
#define DDR_DFS_ENABLE                              0
#define DDR_ENABLE_RODT_TRACKING_SAVE_MCK           0

/* Runtime Related */
#define DDR_HW_GATING                               1
#define DDR_ENABLE_TX_TRACKING                      0
#define DDR_ENABLE_RX_TRACKING                      0
#define DDR_ZQCS_ENABLE                             1
#define DDR_IMPEDANCE_TRACKING_ENABLE               0
#define DDR_TEMP_SENSOR_ENABLE                      0
#define DDR_RDSEL_TRACKING_EN                       0
#define DDR_ENABLE_DFS_RUNTIME_MRW                  0
#define DDR_ENABLE_RODT_TRACKING                    0
#define DDR_GATING_ADJUST_TXDLY_FOR_TRACKING        0
#define DDR_SPM_CONTROL_AFTERK                      0
#define DDR_HW_SAVE_FOR_SR                          0
#define DDR_CLK_FREE_FUN_FOR_DRAMC_PSEL             0
#define DDR_DUMMY_READ_FOR_TRACKING                 0

#define DV_SIMULATION_PC4   1
#define DV_SIMULATION_PC3   1

#define CFG_LPDDR_ENABLE	0
#define CFG_PCDDR_ENABLE	1

/* WA */
#define DDR_CS_DELAY_1T 0
#define ENABLE_DDR_CS_ADJUST 0
#define VREFCA_SOURCE_FROM_APHY    0

typedef struct {
    U16 mr00;
    U16 mr01;
    U16 mr02;
    U16 mr03;
    U16 mr04;
    U16 mr05;
    U16 mr06;
} ddr_mr_val_t;

typedef enum
{
	SERIAL_MODE = 0,
	PARALLEL_MODE,
	STAGGERED_MODE,
	RESERVED_MODE,
} dram_mpr_mode_t;

struct tx_dly_for_all {
    U8 mck;
    U8 ui;
    U8 pi;

    U8 mck_oe;
    U8 ui_oe;
};

struct tx_dly_per_byte {
    U8 dq_mck[DQS_NUMBER];
    U8 dq_ui[DQS_NUMBER];
    U8 dq_pi[DQS_NUMBER];

    U8 dqm_mck[DQS_NUMBER];
    U8 dqm_ui[DQS_NUMBER];
    U8 dqm_pi[DQS_NUMBER];

    U8 dq_mck_oe[DQS_NUMBER];
    U8 dq_ui_oe[DQS_NUMBER];
    U8 dqm_mck_oe[DQS_NUMBER];
    U8 dqm_ui_oe[DQS_NUMBER];
};


#define DDR_RDDQC_PINMUX_WORKAROUND 0
#define DDR_MPRR_MODE SERIAL_MODE


/* Global variables */
EXTERN DRAM_DFS_FREQUENCY_TABLE_T gFreqTbl_PC3[DRAM_DFS_SHUFFLE_MAX];
EXTERN DRAM_DFS_FREQUENCY_TABLE_T gFreqTbl_PC4[DRAM_DFS_SHUFFLE_MAX];;
EXTERN ddr_mr_val_t gMRVal[CHANNEL_NUM][RANK_MAX];
EXTERN const U8 PCDDR4_O1_Mapping_POP[CHANNEL_NUM][16];
EXTERN const U8 PCDDR3_O1_Mapping_POP[CHANNEL_NUM][16];
EXTERN const U8 PCDDR3_O1_Mapping_POP_DSC[CHANNEL_NUM][16];
EXTERN void Set_DRAM_Pinmux_Sel(DRAMC_CTX_T *p);

/* Function Protos */
EXTERN U8 is_ddr3_family(DRAMC_CTX_T *p);
EXTERN U8 is_ddr4_family(DRAMC_CTX_T *p);
EXTERN void DDR3_MRS(DRAMC_CTX_T *p, U16 reg_addr, U32 reg_op,  U8 rank);
EXTERN void DDR4_MRS(DRAMC_CTX_T *p, U16 reg_addr, U32 reg_op, U8 rank);
EXTERN void vSetCalibrationResult(DRAMC_CTX_T *p, U8 ucCalType, U8 ucResult);
EXTERN unsigned int dramc_get_vcore_voltage(void);
#endif // _PI_API_H
