#ifndef __EMI_FAKE_ENGINE_H__
#define __EMI_FAKE_ENGINE_H__

#include <emi_hw.h>

// APB Module infracfg_ao
#ifndef INFRACFG_AO_BASE
#define INFRACFG_AO_BASE         (0x10001000)
#endif
//#define DRAMC_WBR_OFF	         (0x0B4)

#ifndef INFRACFG_AO_MEM_BASE
#define INFRACFG_AO_MEM_BASE     (0x10002000)
#endif
#define INFRA_EMI_DCM_CFG0_OFF   (0x028)

#define EMI_CONH_OFF             (0x0038)
#define EMI_CONH_2ND_OFF         (0x003C)
#define EMI_IOCL_OFF             (0x00D0)
#define EMI_IOCL_2ND_OFF         (0x00D4)
#define EMI_IOCM_OFF             (0x00D8)
#define EMI_IOCM_2ND_OFF         (0x00DC)
#define EMI_CONM_OFF             (0x0060)
#define EMI_BMEN_OFF             (0x0400)
#define EMI_BCNT_OFF             (0x0408)
#define EMI_WACT_OFF             (0x0420)

// APB Module emi_fake_eng
#define EMI_FAKE_ENG_FAKE_ENG_EN_OFF             (0x000)
#define EMI_FAKE_ENG_FAKE_ENG_RST_OFF            (0x004)
#define EMI_FAKE_ENG_FAKE_ENG_DONE_OFF           (0x008)
#define EMI_FAKE_ENG_FAKE_ENG_CON0_OFF           (0x00c)
#define EMI_FAKE_ENG_FAKE_ENG_CON1_OFF	          (0x010)
#define EMI_FAKE_ENG_FAKE_ENG_CON2_OFF	          (0x014)
#define EMI_FAKE_ENG_FAKE_ENG_CON3_OFF	          (0x018)
#define EMI_FAKE_ENG_FAKE_ENG_START_ADDR_OFF     (0x01c)
#define EMI_FAKE_ENG_FAKE_ENG_START_ADDR_2ND_OFF (0x020)
#define EMI_FAKE_ENG_FAKE_ENG_ADDR_OFF           (0x024)
#define EMI_FAKE_ENG_FAKE_ENG_INIT_PAT0_OFF      (0x028)
#define EMI_FAKE_ENG_FAKE_ENG_INIT_PAT1_OFF      (0x02c)
#define EMI_FAKE_ENG_FAKE_ENG_INIT_PAT2_OFF      (0x030)
#define EMI_FAKE_ENG_FAKE_ENG_INIT_PAT3_OFF      (0x034)
#define EMI_FAKE_ENG_FAKE_ENG_INIT_PAT4_OFF      (0x038)
#define EMI_FAKE_ENG_FAKE_ENG_INIT_PAT5_OFF      (0x03c)
#define EMI_FAKE_ENG_FAKE_ENG_INIT_PAT6_OFF      (0x040)
#define EMI_FAKE_ENG_FAKE_ENG_INIT_PAT7_OFF      (0x044)
#define EMI_FAKE_ENG_FAKE_ENG_CMP_RESULT_OFF     (0x048)
#define EMI_FAKE_ENG_FAKE_ENG_FAIL_ADDR_OFF      (0x04c)
#define EMI_FAKE_ENG_FAKE_ENG_FAIL_ADDR_MSB_OFF  (0x050)
#define EMI_FAKE_ENG_FAKE_ENG_EXP_DATA0_OFF      (0x054)
#define EMI_FAKE_ENG_FAKE_ENG_EXP_DATA1_OFF      (0x058)
#define EMI_FAKE_ENG_FAKE_ENG_EXP_DATA2_OFF      (0x05c)
#define EMI_FAKE_ENG_FAKE_ENG_EXP_DATA3_OFF      (0x060)
#define EMI_FAKE_ENG_FAKE_ENG_EXP_DATA4_OFF      (0x064)
#define EMI_FAKE_ENG_FAKE_ENG_EXP_DATA5_OFF      (0x068)
#define EMI_FAKE_ENG_FAKE_ENG_EXP_DATA6_OFF      (0x06c)
#define EMI_FAKE_ENG_FAKE_ENG_EXP_DATA7_OFF      (0x070)
#define EMI_FAKE_ENG_FAKE_ENG_FAIL_DATA0_OFF     (0x074)
#define EMI_FAKE_ENG_FAKE_ENG_FAIL_DATA1_OFF     (0x078)
#define EMI_FAKE_ENG_FAKE_ENG_FAIL_DATA2_OFF     (0x07c)
#define EMI_FAKE_ENG_FAKE_ENG_FAIL_DATA3_OFF     (0x080)
#define EMI_FAKE_ENG_FAKE_ENG_FAIL_DATA4_OFF     (0x084)
#define EMI_FAKE_ENG_FAKE_ENG_FAIL_DATA5_OFF     (0x088)
#define EMI_FAKE_ENG_FAKE_ENG_FAIL_DATA6_OFF     (0x08c)
#define EMI_FAKE_ENG_FAKE_ENG_FAIL_DATA7_OFF     (0x090)
#define EMI_FAKE_ENG_BRIDGE_ADDR_MAP_OFF         (0x094)
#define EMI_FAKE_ENG_BRIDGE_LPDDR_OFF            (0x098)
#define EMI_FAKE_ENG_BRIDGE_RANK0_SIZE_OFF       (0x09c)
#define EMI_FAKE_ENG_BRIDGE_RANK1_SIZE_OFF       (0x0a0)
#define EMI_FAKE_ENG_BRIDGE_BANK_ARB_EN_OFF      (0x0a4)
#define EMI_FAKE_ENG_FAKE_ENG_CMP_FAIL_CNT_OFF   (0x0ac)
#define EMI_FAKE_ENG_FAKE_ENG_FREEZE_RESULT_OFF  (0x0c0)
#define EMI_FAKE_ENG_FAKE_ENG_IDLE_OFF           (0x0c4)
#define EMI_FAKE_ENG_FAKE_ENG_HASH_OFF           (0x0c8)

struct emi_fake_engine {
	unsigned int eng0_addr;
	unsigned int eng1_addr;
	unsigned int infracfg_addr;
	unsigned int infracfg_mem_addr;
	unsigned int emi_addr;
	unsigned int ddrphy_ao_cha_addr;
	unsigned int ddrphy_ao_chb_addr;
	unsigned int dramc_nao_cha_addr;
	unsigned int dramc_nao_chb_addr;
	unsigned int ctrl_intf;
    unsigned int FE_pre_init_done_flag;
};

typedef enum {
    EMI_FAKE_ENGINE_0,
    EMI_FAKE_ENGINE_1
} eFAKE_ENGINE_ID;

typedef enum {
    eFE_IDLE,
    eFE_RUNNING
} eFAKE_ENGINE_STATUS;

typedef struct {
    eFAKE_ENGINE_ID FE_ID;
    unsigned int wr_addr;
    unsigned int rd_addr;
    unsigned char init_done_flag;
    eFAKE_ENGINE_STATUS status;
} eEMI_FE_info;

extern void HAL_REG_32_write(unsigned int value, unsigned int addr);
extern unsigned int HAL_REG_32_read(unsigned int addr);
extern int emi_fake_engine_pre_init(void);
extern int emi_fake_engine_init(eEMI_FE_info *p_fe);
extern int start_emi_fake_engine(eEMI_FE_info *p_fe);
extern int set_emi_fake_engine_slow(eEMI_FE_info *p_fe, unsigned int slow_down,unsigned slow_down_grp);
extern void emi_fake_engine_loop_mode_enable(eEMI_FE_info *p_fe);
extern void emi_fake_engine_loop_mode_disable(eEMI_FE_info *p_fe);
extern void emi_fake_engine_check_done(eEMI_FE_info *p_fe);
extern int stop_emi_fake_engine(eEMI_FE_info *p_fe);
extern void fe_test(void);
extern void emi_fake_engine_traffic_infinite_start(eFAKE_ENGINE_ID FE_ID, unsigned int test_address, unsigned int slow_val);
extern void emi_fake_engine_traffic_infinite_stop(eFAKE_ENGINE_ID FE_ID);
extern void emi_fake_engine_both_traffic_infinite_start(unsigned int FE0_test_address, unsigned int FE1_test_address, unsigned int slow_val);
extern void emi_fake_engine_both_traffic_infinite_stop(void);

#endif
