#include "dramc_typedefs.h"
//=============================================================================
//  Fake Engine Pattern                                                                                                                                                                        
//=============================================================================
#define FAKE_ENGINE_TOGGLE_BITS_ALL_0 0 //toggle all 0
#define FAKE_ENGINE_TOGGLE_BITS_16    1 //toggle every 16bits
#define FAKE_ENGINE_TOGGLE_BITS_32    2 //toggle every 32bits
#define FAKE_ENGINE_TOGGLE_BITS_64    3 //toggle every 64bits
#define FAKE_ENGINE_TOGGLE_BITS_128   4 //toggle every 128bits
#define FAKE_ENGINE_TOGGLE_BITS_256   5 //toggle every 256bits
#define FAKE_ENGINE_TOGGLE_BITS_512   6 //toggle every 512bits
#define FAKE_ENGINE_TOGGLE_BITS_ALL_1 7 //toggle all 1

#define FAKE_ENG_ALL_ACCESS_OPTION  2 //0:all R0 1:all R1 2:default


#if (FAKE_ENG_ALL_ACCESS_OPTION == 0)
#define FAKE_ENG_RD_ADDR            0x40400000
#define FAKE_ENG_WR_ADDR            0x40400000
#define FAKE_ENG2_RD_ADDR           0x50400000
#define FAKE_ENG2_WR_ADDR           0x50400000
#elif (FAKE_ENG_ALL_ACCESS_OPTION == 1)
#define FAKE_ENG_RD_ADDR            0x80400000
#define FAKE_ENG_WR_ADDR            0x80400000
#define FAKE_ENG2_RD_ADDR           0x90400000
#define FAKE_ENG2_WR_ADDR           0x90400000
#else
#define FAKE_ENG_RD_ADDR            0x40400000
#define FAKE_ENG_WR_ADDR            0x40400000
#define FAKE_ENG2_RD_ADDR           0x80400000
#define FAKE_ENG2_WR_ADDR           0x80400000
#endif

#define SPM_BASE_ADDR 0x10006000
#define SPM_PROJECT_CODE 0xB16
#define DIS_PWR_CON (SPM_BASE_ADDR + 0x350)

#define POWERON_CONFIG_EN (SPM_BASE_ADDR + 0x0000)
#define PWR_STATUS        (SPM_BASE_ADDR + 0x016C)
#define PWR_STATUS_2ND    (SPM_BASE_ADDR + 0x0170)
#define DIS_PWR_STA_MASK                (0x1 << 20)
#define DIS_SRAM_PDN_ACK_BIT0           (0x1 << 12)
#define DIS_PROT_STEP2_0_MASK           (0x1 << 6)


/* Define MTCMOS power control */
#define PWR_RST_B                       (0x1 << 0)
#define PWR_ISO                         (0x1 << 1)
#define PWR_ON                          (0x1 << 2)
#define PWR_ON_2ND                      (0x1 << 3)
#define PWR_CLK_DIS                     (0x1 << 4)
#define SRAM_CKISO                      (0x1 << 5)
#define SRAM_ISOINT_B                   (0x1 << 6)
#define DORMANT_ENABLE                  (0x1 << 6)
#define SLPB_CLAMP                      (0x1 << 7)
#define VPROC_EXT_OFF                   (0x1 << 7)

#define DIS_PROT_STEP2_1_MASK           ((0x1 << 1) \
                        |(0x1 << 7) \
                        |(0x1 << 9) \
                        |(0x1 << 15) \
                        |(0x1 << 17) \
                        |(0x1 << 21) \
                        |(0x1 << 25) \
                        |(0x1 << 27))
#define DIS_PROT_STEP2_2_MASK           ((0x1 << 21))

#define DIS_PROT_STEP1_0_MASK           ((0x1 << 0) \
                        |(0x1 << 6) \
                        |(0x1 << 8) \
                        |(0x1 << 10) \
                        |(0x1 << 12) \
                        |(0x1 << 14) \
                        |(0x1 << 16) \
                        |(0x1 << 20) \
                        |(0x1 << 24) \
                        |(0x1 << 26))
//#define MMSYS_CONFIG_BASE 0x14116000
#define MMSYS_CG_SET0 (MMSYS_CONFIG_BASE + 0x104)
#define MMSYS_CG_CLR0 (MMSYS_CONFIG_BASE + 0x108) 
#define MMSYS_CG_SET1 (MMSYS_CONFIG_BASE + 0x114) 
#define MMSYS_CG_CLR1 (MMSYS_CONFIG_BASE + 0x118) 
#define MMSYS_CG_CLR2 (MMSYS_CONFIG_BASE + 0x1a8) 
#define MMSYS_RDMA_SHARE_SRAM_CON (MMSYS_CONFIG_BASE + 0x654) 

//#define TOPCKGEN_BASE 0x10000000
#define CLK_CFG_UPDATE		(TOPCKGEN_BASE + 0x01C0)
#define CLK_CFG_1_SET (TOPCKGEN_BASE + 0x024)
#define CLK_CFG_1_CLR (TOPCKGEN_BASE + 0x028)

//#define SMI_COMMON_BASE 0x1411f000
#define SMI_COMMON_SMI_MON_ENA_MON0 (SMI_COMMON_BASE + 0x1a0)
#define SMI_COMMON_SMI_MON_CLR_MON0 (SMI_COMMON_BASE + 0x1a4)
#define SMI_COMMON_SMI_BUS_SEL (SMI_COMMON_BASE + 0x220)

//#define MMSYSRAM_BASE 0x1f005000 
#define MMSYSRAM_DCM_DIS (MMSYSRAM_BASE + 0x3C)
#define MMSYSRAM_SEC_ADDR0 (MMSYSRAM_BASE + 0x40) 

#define DISP_SMI_COMMON_BASE 0x14002000
#define DISP_SMI_MON_ENA_MON0 (DISP_SMI_COMMON_BASE + 0x1a0)
#define DISP_SMI_MON_CLR_MON0 (DISP_SMI_COMMON_BASE + 0x1a4)
#define DISP_SMI_BUS_SEL (DISP_SMI_COMMON_BASE + 0x220)

#undef SMI_LARB0_BASE 
#undef SMI_LARB1_BASE 
#define SMI_LARB0_BASE (0x14003000)
#define SMI_LARB1_BASE (0x14004000)

//-- Fake Engine 1{Display MM}
#define DISP_FAKE_ENG_RD_ADDR       (MMSYS_CONFIG_BASE + 0x210)
#define DISP_FAKE_ENG_WR_ADDR       (MMSYS_CONFIG_BASE + 0x214)
#define DISP_FAKE_ENG_CON0          (MMSYS_CONFIG_BASE + 0x208)
#define DISP_FAKE_ENG_CON1          (MMSYS_CONFIG_BASE + 0x20C)  
#define DISP_FAKE_ENG_EN            (MMSYS_CONFIG_BASE + 0x200)
#define DISP_FAKE_ENG_STATE         (MMSYS_CONFIG_BASE + 0x218)
#define DISP_FAKE_ENG_RST           (MMSYS_CONFIG_BASE + 0x204)

//-- Fake Engine 2{Display MM}
#define DISP_FAKE_ENG2_RD_ADDR      (MMSYS_CONFIG_BASE + 0x230)
#define DISP_FAKE_ENG2_WR_ADDR      (MMSYS_CONFIG_BASE + 0x234)
#define DISP_FAKE_ENG2_CON0         (MMSYS_CONFIG_BASE + 0x228)
#define DISP_FAKE_ENG2_CON1         (MMSYS_CONFIG_BASE + 0x22C)  
#define DISP_FAKE_ENG2_EN           (MMSYS_CONFIG_BASE + 0x220)
#define DISP_FAKE_ENG2_STATE        (MMSYS_CONFIG_BASE + 0x238)
#define DISP_FAKE_ENG2_RST          (MMSYS_CONFIG_BASE + 0x224)

//-- Functions
typedef enum
{
    R = 0,
    W,
    RW
} TRANS_TYPE;

EXTERN int global_fake_engine_delay;
EXTERN int global_toogle_length;
EXTERN U8 global_fake_engine_burst_length;

EXTERN void Fake_Engine_Access(DRAMC_CTX_T *p, TRANS_TYPE trans_type, int loop);
EXTERN void Disable_Fake_Engine(void);
EXTERN void Enable_Fake_Engine(void);
EXTERN void Fake_Engine_Bandwidth(void);
EXTERN void Fake_Engine_Set_RW_Address(U32 u4ReadAddr, U32 u4WriteAddr);
EXTERN int Monitor_Bw(DRAMC_CTX_T *p, TRANS_TYPE trans_type);
EXTERN void Fake_Engine_Write(DRAMC_CTX_T *p);
EXTERN void Fake_Engine_Read(DRAMC_CTX_T *p);
EXTERN void Fake_Engine_Read_Write(DRAMC_CTX_T *p);
EXTERN void Fake_Engine_Presetting(DRAMC_CTX_T *p);
