#include "dramc_dv_init.h"
#include "dramc_pi_api_pcddr.h"

void DDR3_MRS(DRAMC_CTX_T *p, U16 reg_addr, U32 reg_op,  U8 rank)
{
#if SA_CONFIG_EN
    DramcModeRegWriteByRank(p, rank, (U8)reg_addr, (U16)reg_op);
#else
    U8 temp_MRS_RESPONSE  ;
    U8 reg_op_high_bit    ;

    mcSHOW_DBG_MSG("[DDR3_MRS] RK:%d-MA:%d-OP:0x%2x @Channle:%d\n",rank,reg_addr,reg_op,vGetPHY2ChannelMapping(p));
    reg_op_high_bit = (reg_op >> 8);
	#if 0
    //******************MRW command by scsm path**********************//
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SWCMD_CTRL0), P_Fld(rank         & 0x1  , SWCMD_CTRL0_MRSRK    )
                                                            | P_Fld(reg_addr     & 0x3  , SWCMD_CTRL0_MRSBA    )
                                                            | P_Fld(reg_op              , SWCMD_CTRL0_MRSMA    ));

    vIO32Write4B(DRAMC_REG_ADDR(DRAMC_REG_SWCMD_EN), 0);
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SWCMD_EN), P_Fld(1, SWCMD_EN_MRWEN));

   temp_MRS_RESPONSE = 0 ;
    do
    {
        temp_MRS_RESPONSE = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_SPCMDRESP), SPCMDRESP_MRW_RESPONSE) ;
    } while ( temp_MRS_RESPONSE != 1 );
    //
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SWCMD_EN), P_Fld(0, SWCMD_EN_MRWEN));
    //******************MRW command by scsm path end**********************//
	#else
    //******************MRW command by scsm rtswcmd**********************//
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SWCMD_EN         ), P_Fld(0x4                  , SWCMD_EN_RTSWCMD_SEL          ));
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SWCMD_CTRL2      ), P_Fld(rank     & 0x1       , SWCMD_CTRL2_RTSWCMD_RK        ));
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_RTSWCMD_P2S_CTRL2), P_Fld(reg_addr & 0x3       , RTSWCMD_P2S_CTRL2_RTSWCMD0_BA ));
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SWCMD_CTRL2      ), P_Fld(reg_op   & 0xff      , SWCMD_CTRL2_RTSWCMD_OP        ));
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_RTSWCMD_P2S_CTRL2), P_Fld(reg_op_high_bit & 0x3f , RTSWCMD_P2S_CTRL2_RTSWCMD0_OP_8TO13 ));
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_RTSWCMD_CNT      ), P_Fld(0x30                 , RTSWCMD_CNT_RTSWCMD_CNT       ));
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SWCMD_EN         ), P_Fld(1                    , SWCMD_EN_RTSWCMDEN            ));


    do
    {
        temp_MRS_RESPONSE = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_SPCMDRESP3), SPCMDRESP3_RTSWCMD_RESPONSE) ;
    } while ( temp_MRS_RESPONSE != 1 );

    vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SWCMD_EN), P_Fld(0, SWCMD_EN_RTSWCMDEN));
    //******************MRW command by scsm rtswcmd end**********************//
    #endif
#endif
}

void DDR3_SWZQ(DRAMC_CTX_T *p,U8 rank)
{
#if SA_CONFIG_EN
    DramcZQCalibration(p, rank);
#else
    U8 temp_ZQC_RESPONSE = 0 ;

    mcSHOW_DBG_MSG("[DDR3_ZQ] RK:%d  Enter >>>>>>>>\n",rank);
    //vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SWCMD_CTRL0), P_Fld(rank     & 0x1  , SWCMD_CTRL0_MRSRK    )
    //                                                        | P_Fld(0x400           , SWCMD_CTRL0_MRSMA    ));
    //vIO32Write4B(DRAMC_REG_ADDR(DRAMC_REG_SWCMD_EN), 0);
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SWCMD_EN), P_Fld(0xc                , SWCMD_EN_RTSWCMD_SEL));
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SWCMD_CTRL2), P_Fld(rank     & 0x1  , SWCMD_CTRL2_RTSWCMD_RK ));
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_RTSWCMD_CNT), P_Fld(0x30            , RTSWCMD_CNT_RTSWCMD_CNT ));
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SWCMD_EN), P_Fld(1                  , SWCMD_EN_RTSWCMDEN));

    //vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SWCMD_EN), P_Fld(1, SWCMD_EN_ZQCEN));

    do
    {
        temp_ZQC_RESPONSE = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_SPCMDRESP3), SPCMDRESP3_RTSWCMD_RESPONSE) ;
        //temp_ZQC_RESPONSE = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_SPCMDRESP), SPCMDRESP_MRW_RESPONSE) ;
    } while ( temp_ZQC_RESPONSE != 1 );

    vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SWCMD_EN), P_Fld(0, SWCMD_EN_RTSWCMDEN));
    //vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SWCMD_EN), P_Fld(0, SWCMD_EN_ZQCEN));
    mcSHOW_DBG_MSG("[DDR3_ZQ] RK:%d  Exit <<<<<<<<\n",rank);
    vSetCalibrationResult(p, DRAM_CALIBRATION_ZQ, DRAM_OK);
#endif
}

void PC3_dram_init_single_rank(DRAMC_CTX_T *p,PC3_DRAM_CONFIG_T *tr,U8 rank)
{
#if SA_CALIBRATION_EN
    U8 ch;
#endif
    U32 MR0;
//    U32 MR0_0TO7;
//    U32 MR0_8TO13;
    U32 MR1;
    U32 MR2;
    U32 MR3 = 0;             // MPR normal mode

    U8 MR0_BL          ;     //Burst Lenth type: 0: fix 8 1: BC4 or 8 2:BC4 fixed
    U8 MR0_RBT         ;     //Read bust type 0:Nibble sequential 1: Interleave
    U8 MR0_CL          ;     //CAS latency
    U8 MR0_TM          = 0;  //test mode 0:normal 1: test
    U8 MR0_DLL_RST     = 1;  //0:no 1: yes
    U8 MR0_WR          ;     //write recoverage timing
    U8 MR0_PPD         = 1;  //DLL control for Precharge Power down 0:slow exit 1: fast exit


    U8 MR1_DLL         = 0;  //A0:        0:Enable       1:disable
    U8 MR1_DIC         = 0;  //A5,A1     00:RZQ/6       01:RZQ/7 other reserved  output Impedance Control -40ohm  RZQ/6
    U8 MR1_RTT_NOM     ;     //A9,A6,A2 000:Disable    001:RZQ/4                 010:RZQ/2  011:RZQ/6  100:RZQ/12 101:RZQ/8 others reserved
    U8 MR1_AL          ;     //A4,A3     00:AL disabled 01:CL-1                  02:CL-2 11 Reserved
    U8 MR1_WriteLeveL  = 0;  //A7         0:disable      1:enable
    U8 MR1_TDQS        = 0;  //A11        0:disable      1:enable
    U8 MR1_QOFF        = 0;  //A12        0:Output buffer enable 1:Output buffer disable

    U8 MR2_PASR        = 0;
    U8 MR2_CWL         ;
    U8 MR2_ASR         = 1;
    U8 MR2_SRT         = 0;
    U8 MR2_RTT_WR      = p->odt_onoff ? 2 : 0;

    MR0_BL  = tr->BL;
    MR0_RBT = tr->RBT;
    MR0_CL  = tr->CL;
    MR0_WR  = tr->WR;
    MR1_RTT_NOM = tr->RTT_NORM;
    MR1_AL = tr->AL;
    MR2_CWL = tr->CWL;

    MR0 =    (0                          << 13)
           | ((MR0_PPD        & 1 )      << 12)
           | ((MR0_WR         & 7 )      <<  9)
           | ((MR0_DLL_RST    & 1 )      <<  8)
           | ((MR0_TM         & 1 )      <<  7)
           | (((MR0_CL        &0xe) >>1) <<  4)
           | ((MR0_RBT        & 1 )      <<  3)
           | ((MR0_CL         & 1 )      <<  2)
           | ((MR0_BL         & 3 )      <<  0);
/*
    MR0_0TO7 =    ((MR0_TM          & 1)      <<  7)
                | (((MR0_CL        &0xe) >>1) <<  4)
                | ((MR0_RBT        & 1 )      <<  3)
                | ((MR0_CL         & 1 )      <<  2)
                | ((MR0_BL         & 3 )      <<  0);

    MR0_8TO13 =    (0                          <<  5)
                 | ((MR0_PPD        & 1 )      <<  4)
                 | ((MR0_WR         & 7 )      <<  1)
                 | ((MR0_DLL_RST    & 1 )      <<  0);*/

    MR1 =    (0                          << 13)
           | ((MR1_QOFF       & 1 )      << 12)
           | ((MR1_TDQS       & 1 )      << 11)
           | (0                          << 10)
           | (((MR1_RTT_NOM   & 4 ) >>2) <<  9)
           | (0                          <<  8)
           | ((MR1_WriteLeveL & 1 )      <<  7)
           | (((MR1_RTT_NOM   & 2 ) >>1) <<  6)
           | (((MR1_DIC       & 2 ) >>1) <<  5)
           | ((MR1_AL         & 3 )      <<  3)
           | ((MR1_RTT_NOM    & 1 )      <<  2)
           | ((MR1_DIC        & 1 )      <<  1)
           | ((MR1_DLL        & 1 )      <<  0);

    MR2 =    (0                          << 11)
           | ((MR2_RTT_WR     & 3 )      <<  9)
           | (0                          <<  8)
           | ((MR2_SRT        & 1 )      <<  7)
           | ((MR2_ASR        & 1 )      <<  6)
           | ((MR2_CWL        & 7 )      <<  3)
           | ((MR2_PASR       & 7 )      <<  0);

    mcSHOW_DBG_MSG("[DDR3] DRAM initilization  RK:%d Enter >>>>>>>>\n",rank);
    //SetClkFreeRun(p,1);
    mcSHOW_DBG_MSG("[DDR3] Delay TXPR TRFC+10ns - 350ns(8Gb density)+10ns\n");
    mcDELAY_XNS(360);
    DDR3_MRS(p,2,MR2, rank);
    DDR3_MRS(p,3,MR3, rank);
    DDR3_MRS(p,1,MR1, rank);
    DDR3_MRS(p,0,MR0, rank);
    //DDR3_MRS(p,0,MR0_0TO7, MR0_8TO13, rank);
    DDR3_SWZQ(p,rank);
    mcSHOW_DBG_MSG("[DDR3] Delay ZQinit - 718ns for 1333 at least max(512Mck,640ns)\n");
    mcDELAY_XNS(718);
    //SetClkFreeRun(p,0);
    mcSHOW_DBG_MSG("[DDR3] DRAM initilization  RK:%d Exit <<<<<<<\n",rank);

#if SA_CALIBRATION_EN
    for (ch = CHANNEL_A; ch < p->support_channel_num; ch++) {
        gMRVal[ch][rank].mr00 = MR0;
        gMRVal[ch][rank].mr01 = MR1;
        gMRVal[ch][rank].mr02 = MR2;
        gMRVal[ch][rank].mr03 = MR3;
    }
#endif
}

void PC3_DRAM_INIT(DRAMC_CTX_T *p)
{
    int irank;
    int rank_num;
    U8 single_rank;

#if !SA_CONFIG_EN
    single_rank = DUT_p.SINGLE_RANK;
#else
    single_rank = (p->support_rank_num == RANK_SINGLE) ? 1 : 0;
#endif

    if(single_rank==1) {
        rank_num = 1;
    } else {
        rank_num = 2;
    }
#if !SA_CONFIG_EN
    U8 backup_rank   = 0;
    backup_rank = p->rank;
#endif
    mcSHOW_DBG_MSG("[DDR3] Pull Down reset.\n");
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_MISC_CTRL1), P_Fld(0, MISC_CTRL1_R_DMDA_RRESETB_I));
    mcSHOW_DBG_MSG("[DDR3] cke fix low 10ns at least.\n");
    #if DV_CONFIG_EN==1
    mcDELAY_XNS(10);
    #endif
    CKE_FIX_OFF(p, 1, 0);
    if(single_rank!=1) {
    CKE_FIX_OFF(p, 1, 1);
    }
    mcSHOW_DBG_MSG("[DDR3] Delay 200 us.\n");
    #if SA_CONFIG_EN==1
    mcDELAY_US(200);
    #endif
    mcSHOW_DBG_MSG("[DDR3] Pull Up reset.\n");
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_MISC_CTRL1), P_Fld(1, MISC_CTRL1_R_DMDA_RRESETB_I));
    mcSHOW_DBG_MSG("[DDR3] Delay 500 us.\n");
    #if SA_CONFIG_EN==1
    mcDELAY_US(500);
    #endif

    CKE_FIX_OFF(p, 0, 0);
    if(single_rank!=1)
        CKE_FIX_OFF(p, 0, 1);

#if !SA_CONFIG_EN


    for(irank=0;irank<rank_num;irank++)
    {
        CKE_FIX_ON(p, 1, irank);
        PC3_dram_init_single_rank(p,DV_p.pc3_init,irank);
        CKE_FIX_ON(p, 0, irank);
    }

    mcSHOW_DBG_MSG("[DDR3] Enable refresh.....All bank refresh only\n");
    for(irank=0;irank<rank_num;irank++)
    {
        vSetRank(p, irank);
        vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHURK_REF_CTRL), P_Fld( 0  , SHURK_REF_CTRL_PBREFEN ));
        vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_RK_REF_CTRL   ), P_Fld( 0    , RK_REF_CTRL_REFDIS	));
    }
    vSetRank(p, backup_rank);
#else
	CKE_FIX_ON(p, 1, 0);
	if(single_rank!=1) 
		CKE_FIX_ON(p, 1, 1);

	for(irank=0;irank<rank_num;irank++)
		PC3_dram_init_single_rank(p,DV_p.pc3_init,irank);
#endif
}
