/*----------------------------------------------------------------------------*
 * Copyright Statement:                                                       *
 *                                                                            *
 *   This software/firmware and related documentation ("MediaTek Software")   *
 * are protected under international and related jurisdictions'copyright laws *
 * as unpublished works. The information contained herein is confidential and *
 * proprietary to MediaTek Inc. Without the prior written permission of       *
 * MediaTek Inc., any reproduction, modification, use or disclosure of        *
 * MediaTek Software, and information contained herein, in whole or in part,  *
 * shall be strictly prohibited.                                              *
 * MediaTek Inc. Copyright (C) 2010. All rights reserved.                     *
 *                                                                            *
 *   BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND     *
 * AGREES TO THE FOLLOWING:                                                   *
 *                                                                            *
 *   1)Any and all intellectual property rights (including without            *
 * limitation, patent, copyright, and trade secrets) in and to this           *
 * Software/firmware and related documentation ("MediaTek Software") shall    *
 * remain the exclusive property of MediaTek Inc. Any and all intellectual    *
 * property rights (including without limitation, patent, copyright, and      *
 * trade secrets) in and to any modifications and derivatives to MediaTek     *
 * Software, whoever made, shall also remain the exclusive property of        *
 * MediaTek Inc.  Nothing herein shall be construed as any transfer of any    *
 * title to any intellectual property right in MediaTek Software to Receiver. *
 *                                                                            *
 *   2)This MediaTek Software Receiver received from MediaTek Inc. and/or its *
 * representatives is provided to Receiver on an "AS IS" basis only.          *
 * MediaTek Inc. expressly disclaims all warranties, expressed or implied,    *
 * including but not limited to any implied warranties of merchantability,    *
 * non-infringement and fitness for a particular purpose and any warranties   *
 * arising out of course of performance, course of dealing or usage of trade. *
 * MediaTek Inc. does not provide any warranty whatsoever with respect to the *
 * software of any third party which may be used by, incorporated in, or      *
 * supplied with the MediaTek Software, and Receiver agrees to look only to   *
 * such third parties for any warranty claim relating thereto.  Receiver      *
 * expressly acknowledges that it is Receiver's sole responsibility to obtain *
 * from any third party all proper licenses contained in or delivered with    *
 * MediaTek Software.  MediaTek is not responsible for any MediaTek Software  *
 * releases made to Receiver's specifications or to conform to a particular   *
 * standard or open forum.                                                    *
 *                                                                            *
 *   3)Receiver further acknowledge that Receiver may, either presently       *
 * and/or in the future, instruct MediaTek Inc. to assist it in the           *
 * development and the implementation, in accordance with Receiver's designs, *
 * of certain softwares relating to Receiver's product(s) (the "Services").   *
 * Except as may be otherwise agreed to in writing, no warranties of any      *
 * kind, whether express or implied, are given by MediaTek Inc. with respect  *
 * to the Services provided, and the Services are provided on an "AS IS"      *
 * basis. Receiver further acknowledges that the Services may contain errors  *
 * that testing is important and it is solely responsible for fully testing   *
 * the Services and/or derivatives thereof before they are used, sublicensed  *
 * or distributed. Should there be any third party action brought against     *
 * MediaTek Inc. arising out of or relating to the Services, Receiver agree   *
 * to fully indemnify and hold MediaTek Inc. harmless.  If the parties        *
 * mutually agree to enter into or continue a business relationship or other  *
 * arrangement, the terms and conditions set forth herein shall remain        *
 * effective and, unless explicitly stated otherwise, shall prevail in the    *
 * event of a conflict in the terms in any agreements entered into between    *
 * the parties.                                                               *
 *                                                                            *
 *   4)Receiver's sole and exclusive remedy and MediaTek Inc.'s entire and    *
 * cumulative liability with respect to MediaTek Software released hereunder  *
 * will be, at MediaTek Inc.'s sole discretion, to replace or revise the      *
 * MediaTek Software at issue.                                                *
 *                                                                            *
 *   5)The transaction contemplated hereunder shall be construed in           *
 * accordance with the laws of Singapore, excluding its conflict of laws      *
 * principles.  Any disputes, controversies or claims arising thereof and     *
 * related thereto shall be settled via arbitration in Singapore, under the   *
 * then current rules of the International Chamber of Commerce (ICC).  The    *
 * arbitration shall be conducted in English. The awards of the arbitration   *
 * shall be final and binding upon both parties and shall be entered and      *
 * enforceable in any court of competent jurisdiction.                        *
 *---------------------------------------------------------------------------*/
/*-----------------------------------------------------------------------------
 *
 * $Author: chunxue.yu $
 * $Date: 2024/04/19 $
 * $RCSfile: pi_basic_api.c,v $
 * $Revision: #2 $
 *
 *---------------------------------------------------------------------------*/

/** @file pi_basic_api.c
 *  Basic DRAMC API implementation
 */

//-----------------------------------------------------------------------------
// Include files
//-----------------------------------------------------------------------------
//#include "..\Common\pd_common.h"
//#include "Register.h"
#include "dramc_common.h"
#include "dramc_dv_init.h"
#include "dramc_int_global.h"
#include "x_hal_io.h"
#include "dramc_actiming.h"
#include "dramc_pi_api_pcddr.h"

#if __ETT__ || FOR_DV_SIMULATION_USED
#if DRAMC_CTRL_BY_SOC
#include "pll.h"
#endif
#endif

#include "dramc_top.h"

//#include "DramC_reg.h"
//#include "System_reg.h"
//#include "string.h"

//-----------------------------------------------------------------------------
// Global variables
//-----------------------------------------------------------------------------
U8 u1PrintModeRegWrite = 0;

#if DDR_ENABLE_RODT_TRACKING_SAVE_MCK
// global variables for RODT tracking & ROEN
U8 u1ODT_ON;        // infor of p->odt_onoff
U8 u1WDQS_ON = 0;   // infor of WDQS on(ROEN=1)
U8 u1RODT_TRACK = 0;  // infor of rodt tracking enable
U8 u1ROEN, u1ModeSel;//status of ROEN, MODESEL setting
#endif

void Set_DRAM_Pinmux_Sel(DRAMC_CTX_T *p)
{
#if (fcFOR_CHIP_ID == fcGriffin)
#if DRAMC_CTRL_BY_SOC
    // TODO: V23 need porting
	if (is_ddr3_family(p)) {
		//Effuse CR: 0x11D00A0C	0x0 is REBB,  0x1 is IAP  (judge bit-0)
		//if (*(volatile unsigned int*)(0x11d00a0c) & 0x1)
//		if (mt7987_bga_pkg)
			p->DRAMPinmux = PINMUX_DSC;
//		else
//			p->DRAMPinmux = PINMUX_EMCP;
	} else {
		p->DRAMPinmux = PINMUX_DSC;
	}
#endif
#else
#if !FOR_DV_SIMULATION_USED
    if (is_discrete_lpddr4())
        p->DRAMPinmux = PINMUX_DSC;
    else
#endif
        p->DRAMPinmux = PINMUX_EMCP;
#endif

	mcSHOW_DBG_MSG("[Set_DRAM_Pinmux_Sel] DRAMPinmux = %d\n", p->DRAMPinmux);
}

void Set_DQO1_Pinmux_Mapping(DRAMC_CTX_T *p)
{
    U8 *uiLPDDR_DQO1_Mapping = NULL;
    U8 backup_channel;
    U32 backup_broadcast;
    DRAM_CHANNEL_T chIdx = CHANNEL_A;

    //Backup channel & broadcast
    backup_channel = vGetPHY2ChannelMapping(p);
    backup_broadcast = GetDramcBroadcast();

    DramcBroadcastOnOff(DRAMC_BROADCAST_OFF); //Disable broadcast

	for (chIdx = CHANNEL_A; (UINT8)chIdx < (UINT8)p->support_channel_num; chIdx++)
    {
        vSetPHY2ChannelMapping(p, chIdx);

	if (is_ddr4_family(p)){
    	uiLPDDR_DQO1_Mapping = (U8 *)PCDDR4_O1_Mapping_POP[chIdx];
		}
        else{
			if (p->DRAMPinmux == PINMUX_DSC)
				uiLPDDR_DQO1_Mapping = (U8 *)PCDDR3_O1_Mapping_POP_DSC[chIdx];
			else
				uiLPDDR_DQO1_Mapping = (U8 *)PCDDR3_O1_Mapping_POP[chIdx];
        	}
        //Set MRR pin mux
        vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_MISC_DQ_SE_PINMUX_CTRL0), P_Fld(uiLPDDR_DQO1_Mapping[0], MISC_DQ_SE_PINMUX_CTRL0_DQ_PINMUX_SEL_DQ0)
                                                                            | P_Fld(uiLPDDR_DQO1_Mapping[1], MISC_DQ_SE_PINMUX_CTRL0_DQ_PINMUX_SEL_DQ1)
                                                                            | P_Fld(uiLPDDR_DQO1_Mapping[2], MISC_DQ_SE_PINMUX_CTRL0_DQ_PINMUX_SEL_DQ2)
                                                                            | P_Fld(uiLPDDR_DQO1_Mapping[3], MISC_DQ_SE_PINMUX_CTRL0_DQ_PINMUX_SEL_DQ3)
                                                                            | P_Fld(uiLPDDR_DQO1_Mapping[4], MISC_DQ_SE_PINMUX_CTRL0_DQ_PINMUX_SEL_DQ4)
                                                                            | P_Fld(uiLPDDR_DQO1_Mapping[5], MISC_DQ_SE_PINMUX_CTRL0_DQ_PINMUX_SEL_DQ5)
                                                                            | P_Fld(uiLPDDR_DQO1_Mapping[6], MISC_DQ_SE_PINMUX_CTRL0_DQ_PINMUX_SEL_DQ6)
                                                                            | P_Fld(uiLPDDR_DQO1_Mapping[7], MISC_DQ_SE_PINMUX_CTRL0_DQ_PINMUX_SEL_DQ7));
        vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_MISC_DQ_SE_PINMUX_CTRL1), P_Fld(uiLPDDR_DQO1_Mapping[8], MISC_DQ_SE_PINMUX_CTRL1_DQ_PINMUX_SEL_DQ8)
                                                                            | P_Fld(uiLPDDR_DQO1_Mapping[9], MISC_DQ_SE_PINMUX_CTRL1_DQ_PINMUX_SEL_DQ9)
                                                                            | P_Fld(uiLPDDR_DQO1_Mapping[10], MISC_DQ_SE_PINMUX_CTRL1_DQ_PINMUX_SEL_DQ10)
                                                                            | P_Fld(uiLPDDR_DQO1_Mapping[11], MISC_DQ_SE_PINMUX_CTRL1_DQ_PINMUX_SEL_DQ11)
                                                                            | P_Fld(uiLPDDR_DQO1_Mapping[12], MISC_DQ_SE_PINMUX_CTRL1_DQ_PINMUX_SEL_DQ12)
                                                                            | P_Fld(uiLPDDR_DQO1_Mapping[13], MISC_DQ_SE_PINMUX_CTRL1_DQ_PINMUX_SEL_DQ13)
                                                                            | P_Fld(uiLPDDR_DQO1_Mapping[14], MISC_DQ_SE_PINMUX_CTRL1_DQ_PINMUX_SEL_DQ14)
                                                                            | P_Fld(uiLPDDR_DQO1_Mapping[15], MISC_DQ_SE_PINMUX_CTRL1_DQ_PINMUX_SEL_DQ15));
    }

    //Recover channel & broadcast
    vSetPHY2ChannelMapping(p, backup_channel);
    DramcBroadcastOnOff(backup_broadcast);
}

static void SetRankInfoToConf(DRAMC_CTX_T *p)
{
#if FOR_DV_SIMULATION_USED == 0
    EMI_SETTINGS *emi_set;
    U32 u4value = 0;

#if (!__ETT__)//preloader
    if (emi_setting_index == -1)
        emi_set = &default_emi_setting;
    else
        emi_set = &emi_settings[emi_setting_index];
#else//ett
    emi_set = &default_emi_setting;
#endif

    u4value = ((emi_set->EMI_CONA_VAL >> 17) & 0x1)? 0: 1;//CONA 17th bit 0: Disable dual rank mode 1: Enable dual rank mode

    vIO32WriteFldMulti(DRAMC_REG_SA_RESERVE,
		P_Fld(p->dram_cbt_mode[RANK_0], SA_RESERVE_MODE_RK0) |
		P_Fld(p->dram_cbt_mode[RANK_1], SA_RESERVE_MODE_RK1) |
		P_Fld(u4value, SA_RESERVE_SINGLE_RANK));

    mcSHOW_JV_LOG_MSG("Rank info: %d emi_setting_index: %d CONA[0x%x]\n", u4value, emi_setting_index, emi_set->EMI_CONA_VAL);
#endif
    return;
}

void Global_Option_Init(DRAMC_CTX_T *p)
{
    //SaveCurrDramCtx(p);
    vSetChannelNumber(p);
    SetRankInfoToConf(p);
    vSetRankNumber(p);
//    Set_DRAM_Pinmux_Sel(p);
    Set_DQO1_Pinmux_Mapping(p);

    vInitGlobalVariablesByCondition(p);
    vInitMappingFreqArray(p);
#if DDR_ENABLE_TX_TRACKING
    DramcDQSOSCInit();
#endif

#ifdef FOR_HQA_TEST_USED
    HQA_measure_message_reset_all_data(p);
#endif
}
#if __ETT__
#define APMIXEDSYS_BASE			0x1001E000
#define MPLL_PWR_CON0		(APMIXEDSYS_BASE + 0x0270)
#define CLK_CFG_2_SET		(TOPCKGEN_BASE + 0x0024)
#define CLK_CFG_3_SET		(TOPCKGEN_BASE + 0x0034)
#endif
void MPLLInit(void)
{
#if DRAMC_CTRL_BY_SOC
//-- MPLL settings --
    unsigned int tmp;

    tmp = DRV_Reg32(MPLL_PWR_CON0);
    DRV_WriteReg32(MPLL_PWR_CON0, tmp | 0x1); //[0]=1: Turn on MPLL power

	mcDELAY_US(30);

	tmp = DRV_Reg32(MPLL_PWR_CON0);
	DRV_WriteReg32(MPLL_PWR_CON0, tmp & 0xFFFFFFFD); //[1]=0: Release MPLL_LL iso

	mcDELAY_US(1);

	tmp = DRV_Reg32(MPLL_CON0);
	DRV_WriteReg32(MPLL_CON0, tmp | 0x00000104); // MPLL[8]=1:fra_en [2]=1:PCW_CHG

	tmp = DRV_Reg32(MPLL_CON0);
	DRV_WriteReg32(MPLL_CON0, tmp | 0x1); //[0]=1: Turn on MPLL

	/* Wait 20us for PLL stable */

	mcDELAY_US(20);

	tmp = DRV_Reg32(MPLL_CON0);
	DRV_WriteReg32(MPLL_CON0, tmp | 0x00800000); // [23]=1: set DIV_RSTB to PLL_DIV macro=1

	//-- top clock MUX settings for DRAMC related clocks --

	tmp = DRV_Reg32(CLK_CFG_2_SET);
	DRV_WriteReg32(CLK_CFG_2_SET, tmp | 0x01000000); // //[25:24]=2'b01: change dramc_ref_ck clock from 40M to 26MHz

	tmp = DRV_Reg32(CLK_CFG_3_SET);
	DRV_WriteReg32(CLK_CFG_3_SET, tmp | 0x1); //[1:0]=2'b01: change pwr_dramc_md32_ck clock from 40M to 208MHz

	tmp = DRV_Reg32(CLK_CFG_UPDATE);
	DRV_WriteReg32(CLK_CFG_UPDATE, tmp | (0x3 << 11)); //Update dramc related clock
#endif
}


#if DDR_ENABLE_RODT_TRACKING_SAVE_MCK
void SetTxWDQSStatusOnOff(U8 u1OnOff)
{
      u1WDQS_ON = u1OnOff;
}
#endif


#if XRTRTR_NEW_CROSS_RK_MODE
void XRTRTR_SHU_Setting(DRAMC_CTX_T * p)
{
#if __IPMv2_TO_BE_PORTING__
    U8 u1RkSelUIMinus = 0, u1RkSelMCKMinus = 0;
    //U8 u1RankIdx = 0;
    //U8 u1Rank_backup = u1GetRank(p);

    if (vGet_DDR_Loop_Mode(p) == SEMI_OPEN_LOOP_MODE) // DDR800semi
        u1RkSelMCKMinus = 1;
    else if (p->frequency >= 1600) //DDR3200 up
        u1RkSelUIMinus = 2;

    // DV codes is included
    /*vIO32WriteFldAlign_All(DDRPHY_REG_SHU_B0_DQ6, u1ShuRkMode, SHU_B0_DQ6_RG_RX_ARDQ_RANK_SEL_SER_MODE_B0);
    vIO32WriteFldAlign_All(DDRPHY_REG_SHU_B1_DQ6, u1ShuRkMode, SHU_B1_DQ6_RG_RX_ARDQ_RANK_SEL_SER_MODE_B1);*/

    //DRAMC setting - @Darren, DV no set (double confirm)

    vIO32WriteFldMulti_All(DDRPHY_REG_SHU_MISC_RANK_SEL_STB, P_Fld(u1RkSelMCKMinus, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_MCK_MINUS)
                                       | P_Fld(u1RkSelUIMinus, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_UI_MINUS)
                                       | P_Fld(0x0, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_MCK_PLUS)
                                       | P_Fld(0x0, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_UI_PLUS)
                                       | P_Fld(0x0, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_PHASE_EN)
                                       | P_Fld(0x0, SHU_MISC_RANK_SEL_STB_RANK_SEL_RXDLY_TRACK)
                                       | P_Fld(0x1, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_TRACK)
                                       | P_Fld(0x0, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_SERMODE) // @HJ, no use
                                       | P_Fld(0x0, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_EN_B23)
                                       | P_Fld(0x1, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_EN));
    #endif
    //Darren-vIO32WriteFldAlign_All(DRAMC_REG_SHU_STBCAL, 0x1, SHU_STBCAL_DQSIEN_RX_SELPH_OPT); //@HJ, internal wire assign to 1'b1

    /*for (u1RankIdx = RANK_0; u1RankIdx < p->support_rank_num; u1RankIdx++)
    {
        vSetRank(p, u1RankIdx);
        vIO32WriteFldMulti_All(DDRPHY_REG_MISC_SHU_RK_DQSCAL, P_Fld(0x1, MISC_SHU_RK_DQSCAL_DQSIENHLMTEN)
                                           | P_Fld(0x3f, MISC_SHU_RK_DQSCAL_DQSIENHLMT)
                                           | P_Fld(0x1, MISC_SHU_RK_DQSCAL_DQSIENLLMTEN)
                                           | P_Fld(0x60, MISC_SHU_RK_DQSCAL_DQSIENLLMT));
    }
    vSetRank(p, u1Rank_backup);*/
}
#endif

#if XRTWTW_NEW_CROSS_RK_MODE
void XRTWTW_SHU_Setting(DRAMC_CTX_T * p)
{
    U8 u1RankIdx, u1ByteIdx;
    U8 u1Rank_bak = u1GetRank(p);
    U16 u2TxDly_OEN_RK[2][2] = {{0}}, u2TxPI_UPD[2] = {0}, u2TxRankINCTL, u2TxDly_OEN_RK_max, u2TxPI_UPD_max;

    for (u1RankIdx = RANK_0; u1RankIdx < p->support_rank_num; u1RankIdx++)
    {
        vSetRank(p, u1RankIdx);

        u2TxDly_OEN_RK[u1RankIdx][0] = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_SHURK_SELPH_DQ0), SHURK_SELPH_DQ0_TXDLY_OEN_DQ0); //Byte0
        u2TxDly_OEN_RK[u1RankIdx][1] = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_SHURK_SELPH_DQ0), SHURK_SELPH_DQ0_TXDLY_OEN_DQ1); //Byte1
    }
    vSetRank(p, u1Rank_bak);

    for (u1ByteIdx = 0; u1ByteIdx < (p->data_width / DQS_BIT_NUMBER); u1ByteIdx++)
    {
        u2TxDly_OEN_RK_max = (u2TxDly_OEN_RK[0][u1ByteIdx] > u2TxDly_OEN_RK[1][u1ByteIdx])? u2TxDly_OEN_RK[0][u1ByteIdx]: u2TxDly_OEN_RK[1][u1ByteIdx];
        if (p->frequency >= 1200)
            u2TxPI_UPD[u1ByteIdx] = (u2TxDly_OEN_RK_max > 2)? (u2TxDly_OEN_RK_max - 2): 0; //Byte0
        else
            u2TxPI_UPD[u1ByteIdx] = (u2TxDly_OEN_RK_max > 1)? (u2TxDly_OEN_RK_max - 1): 0; //Byte0
    }

    u2TxPI_UPD_max = (u2TxPI_UPD[0] > u2TxPI_UPD[1])? u2TxPI_UPD[0]: u2TxPI_UPD[1];
    u2TxRankINCTL = (u2TxPI_UPD_max > 1)? (u2TxPI_UPD_max - 1): 0;

    vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_NEW_XRW2W_CTRL), P_Fld(0x0, SHU_NEW_XRW2W_CTRL_TXPI_UPD_MODE)
                                           | P_Fld(u2TxPI_UPD[0], SHU_NEW_XRW2W_CTRL_TX_PI_UPDCTL_B0)
                                           | P_Fld(u2TxPI_UPD[1], SHU_NEW_XRW2W_CTRL_TX_PI_UPDCTL_B1));

    vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_TX_RANKCTL), P_Fld(0x0, SHU_TX_RANKCTL_TXRANKINCTL_ROOT)
                                            | P_Fld(u2TxRankINCTL, SHU_TX_RANKCTL_TXRANKINCTL)
                                            | P_Fld(u2TxRankINCTL, SHU_TX_RANKCTL_TXRANKINCTL_TXDLY));
}
#endif

#if TX_OE_EXTEND
static void UpdateTxOEN(DRAMC_CTX_T *p)
{
    U8 u1ByteIdx, backup_rank, ii;
    U8 u1DQ_OE_CNT;

    // For LP4
    // 1. R_DMDQOE_OPT (dramc_conf 0x8C0[11])
    //    set 1'b1: adjust DQSOE/DQOE length with R_DMDQOE_CNT
    // 2. R_DMDQOE_CNT (dramc_conf 0x8C0[10:8])
    //    set 3'h3
    // 3. Initial TX setting OE/DATA
    //    OE = DATA - 4 UI

    // For LP3
    // 1. R_DMDQOE_OPT (dramc_conf 0x8C0[11])
    //    set 1'b1: adjust DQSOE/DQOE length with R_DMDQOE_CNT
    // 2. R_DMDQOE_CNT (dramc_conf 0x8C0[10:8])
    //    set 3'h2
    // 3. Initial TX setting OE/DATA
    //    OE = DATA - 2 UI

    u1DQ_OE_CNT = 3;

    vIO32WriteFldMulti(DRAMC_REG_SHU_TX_SET0, P_Fld(1, SHU_TX_SET0_DQOE_OPT) | P_Fld(u1DQ_OE_CNT, SHU_TX_SET0_DQOE_CNT));

    backup_rank = u1GetRank(p);

    PCDDR_ShiftDQS_OENUI(p, -1, ALL_BYTES);
    ShiftDQ_OENUI_AllRK(p, -1, ALL_BYTES);
}
#endif

#if DDR_ENABLE_DUTY_CAL
#ifdef DDR_INIT_TIME_PROFILING
U32 gu4DutyCalibrationTime;
#endif
#endif

void vSet_Dram_Vrefca_Source(DRAMC_CTX_T *p)
{
    #if VREFCA_SOURCE_FROM_APHY
    vIO32WriteFldAlign_All(DRAMC_REG_ADDR(DDRPHY_REG_PHYPLL1), 0x1, PHYPLL1_RG_RPHYPLL_TST_EN); //if from aphy, DDR3 DDR4 all is 1
    #else
    vIO32WriteFldAlign_All(DRAMC_REG_ADDR(DDRPHY_REG_PHYPLL1), 0x0, PHYPLL1_RG_RPHYPLL_TST_EN);
    #endif
    // if not from Aphy, the follow setting don't care
    vIO32WriteFldMulti_All(DRAMC_REG_ADDR(DDRPHY_REG_PHYPLL1), P_Fld(0, PHYPLL1_RG_RPHYPLL_TSTCK_EN) |
                                                           P_Fld(0, PHYPLL1_RG_RPHYPLL_TST_SEL));
    vIO32WriteFldMulti_All(DRAMC_REG_ADDR(DDRPHY_REG_SHU_MISC_RVREF), P_Fld(1, SHU_MISC_RVREF_RG_RVREF_DDR3_SEL) |
                                                                  P_Fld(0, SHU_MISC_RVREF_RG_RVREF_DDR4_SEL) |
                                                                  P_Fld(0xB, SHU_MISC_RVREF_RG_RVREF_SEL_DQ));
}

void vReplaceDVInit(DRAMC_CTX_T *p)
{
    U8 u1RandIdx, backup_rank = 0;
#if fcFOR_CHIP_ID == fcGriffin
    U8 zq_sel = 0x38;
#endif

    backup_rank = p->rank;

    //Disable RX Tracking
    #if __IPMv2_TO_BE_PORTING__
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_B1_DQ5), P_Fld(0, B1_DQ5_RG_RX_ARDQS0_DVS_EN_B1));
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_B0_DQ5), P_Fld(0, B0_DQ5_RG_RX_ARDQS0_DVS_EN_B0));
    #endif
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_B0_RXDVS0), P_Fld(0, B0_RXDVS0_R_RX_DLY_TRACK_ENA_B0)
                                                            | P_Fld(0, B0_RXDVS0_R_RX_DLY_TRACK_CG_EN_B0 ));
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_B1_RXDVS0), P_Fld(0, B1_RXDVS0_R_RX_DLY_TRACK_ENA_B1)
                                                            | P_Fld(0, B1_RXDVS0_R_RX_DLY_TRACK_CG_EN_B1 ));

    for(u1RandIdx = RANK_0; u1RandIdx < p->support_rank_num; u1RandIdx++)
    {
        vSetRank(p, u1RandIdx);
        vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_RK_B0_RXDVS2), P_Fld(0, RK_B0_RXDVS2_R_RK0_RX_DLY_FAL_TRACK_GATE_ENA_B0)
                                                                    | P_Fld(0, RK_B0_RXDVS2_R_RK0_RX_DLY_RIS_TRACK_GATE_ENA_B0)
                                                                    | P_Fld(0, RK_B0_RXDVS2_R_RK0_DVS_MODE_B0));
        vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_RK_B1_RXDVS2), P_Fld(0, RK_B1_RXDVS2_R_RK0_RX_DLY_FAL_TRACK_GATE_ENA_B1)
                                                                    | P_Fld(0, RK_B1_RXDVS2_R_RK0_RX_DLY_RIS_TRACK_GATE_ENA_B1)
                                                                    | P_Fld(0, RK_B1_RXDVS2_R_RK0_DVS_MODE_B1));
    }
    vSetRank(p, backup_rank);

    vIO32WriteFldAlign(DRAMC_REG_ADDR(DRAMC_REG_CBT_WLEV_CTRL1), 0, CBT_WLEV_CTRL1_CATRAINLAT);
    vIO32WriteFldAlign(DRAMC_REG_ADDR(DRAMC_REG_SWCMD_CTRL1), 0, SWCMD_CTRL1_WRFIFO_MODE2);


    //Bringup setting review

    {
        U32 backup_broadcast = GetDramcBroadcast();
        DramcBroadcastOnOff(DRAMC_BROADCAST_OFF);

        U8 u1DQ_HYST_SEL=0x1, u1CA_HYST_SEL=0x1;
        U8 u1DQ_CAP_SEL=0x18, u1CA_CAP_SEL=0x18;
        //Critical
        //APHY
        if(p->frequency < 1200)
        {
            u1DQ_HYST_SEL = 0x1;
            u1CA_HYST_SEL = 0x1;
        }
        else
        {
            u1DQ_HYST_SEL = 0x0;
            u1CA_HYST_SEL = 0x0;
        }

        if (is_ddr3_family(p)) {
            u1DQ_CAP_SEL= 0x3;
            u1CA_CAP_SEL= 0x3;
        } else {
            u1DQ_CAP_SEL= 0x0;
            u1CA_CAP_SEL= 0x0;
        }

        vIO32WriteFldMulti_All(DDRPHY_REG_SHU_B0_DQ6, P_Fld(u1DQ_HYST_SEL, SHU_B0_DQ6_RG_ARPI_HYST_SEL_B0)
                                                    | P_Fld(u1DQ_CAP_SEL, SHU_B0_DQ6_RG_ARPI_CAP_SEL_B0));
        vIO32WriteFldMulti_All(DDRPHY_REG_SHU_B1_DQ6, P_Fld(u1DQ_HYST_SEL, SHU_B1_DQ6_RG_ARPI_HYST_SEL_B1)
                                                    | P_Fld(u1DQ_CAP_SEL, SHU_B1_DQ6_RG_ARPI_CAP_SEL_B1));
        vIO32WriteFldMulti_All(DDRPHY_REG_SHU_B2_DQ6, P_Fld(u1DQ_HYST_SEL, SHU_B2_DQ6_RG_ARPI_HYST_SEL_B2)
                                                    | P_Fld(u1DQ_CAP_SEL, SHU_B2_DQ6_RG_ARPI_CAP_SEL_B2));
        vIO32WriteFldMulti_All(DDRPHY_REG_SHU_CA_CMD6, P_Fld(u1CA_HYST_SEL, SHU_CA_CMD6_RG_ARPI_HYST_SEL_CA)
                                                    | P_Fld(u1CA_CAP_SEL, SHU_CA_CMD6_RG_ARPI_CAP_SEL_CA));

        //Jeremy
        vIO32WriteFldMulti_All(DDRPHY_REG_SHU_B0_DQ2,P_Fld((p->frequency>=2133), SHU_B0_DQ2_RG_ARPI_PSMUX_XLATCH_FORCE_DQS_B0)
                                                    | P_Fld((p->frequency>=2133), SHU_B0_DQ2_RG_ARPI_PSMUX_XLATCH_FORCE_DQ_B0)
                                                    | P_Fld(0, SHU_B0_DQ2_RG_ARPI_SMT_XLATCH_FORCE_DQS_B0)
                                                    | P_Fld(0, SHU_B0_DQ2_RG_ARPI_SMT_XLATCH_DQ_FORCE_B0));
        vIO32WriteFldMulti_All(DDRPHY_REG_SHU_B1_DQ2,P_Fld((p->frequency>=2133), SHU_B1_DQ2_RG_ARPI_PSMUX_XLATCH_FORCE_DQS_B1)
                                                    | P_Fld((p->frequency>=2133), SHU_B1_DQ2_RG_ARPI_PSMUX_XLATCH_FORCE_DQ_B1)
                                                    | P_Fld(0, SHU_B1_DQ2_RG_ARPI_SMT_XLATCH_FORCE_DQS_B1)
                                                    | P_Fld(0, SHU_B1_DQ2_RG_ARPI_SMT_XLATCH_DQ_FORCE_B1));
        vIO32WriteFldMulti_All(DDRPHY_REG_SHU_CA_CMD2,P_Fld((p->frequency>=2133), SHU_CA_CMD2_RG_ARPI_PSMUX_XLATCH_FORCE_CLK_CA)
                                                    | P_Fld((p->frequency>=2133), SHU_CA_CMD2_RG_ARPI_PSMUX_XLATCH_FORCE_CA_CA)
                                                    | P_Fld((p->frequency<=300), SHU_CA_CMD2_RG_ARPI_SMT_XLATCH_FORCE_CLK_CA)
                                                    | P_Fld((p->frequency<=300), SHU_CA_CMD2_RG_ARPI_SMT_XLATCH_CA_FORCE_CA));

        //disable RX PIPE for RX timing pass
        #if __IPMv2_TO_BE_PORTING__
        vIO32WriteFldAlign_All(DDRPHY_REG_SHU_MISC_RX_PIPE_CTRL, 0x0, SHU_MISC_RX_PIPE_CTRL_RX_PIPE_BYPASS_EN);
        #endif

        //Disable MD32 IRQ
        vIO32Write4B_All(DDRPHY_REG_MISC_DBG_IRQ_CTRL4, 0x0);

        //Disable NEW RX DCM mode
        vIO32WriteFldMulti_All(DDRPHY_REG_MISC_SHU_RX_CG_CTRL, P_Fld(0, MISC_SHU_RX_CG_CTRL_RX_DCM_WAIT_DLE_EXT_DLY)
                                                            | P_Fld(2, MISC_SHU_RX_CG_CTRL_RX_DCM_EXT_DLY)
                                                            | P_Fld(0, MISC_SHU_RX_CG_CTRL_RX_APHY_CTRL_DCM_OPT)
                                                            | P_Fld(0, MISC_SHU_RX_CG_CTRL_RX_DCM_OPT));

        vIO32WriteFldAlign_All(DRAMC_REG_HMR4, 0, HMR4_MR4INT_LIMITEN);
        vIO32WriteFldAlign_All(DRAMC_REG_REFCTRL1, 0, REFCTRL1_REFPEND_OPT1);
        vIO32WriteFldAlign_All(DRAMC_REG_REFCTRL3, 0, REFCTRL3_REF_DERATING_EN);

        vIO32WriteFldMulti_All(DRAMC_REG_DRAMC_IRQ_EN, P_Fld(0x0, DRAMC_IRQ_EN_DRAMC_IRQ_EN_RSV)
                                                    | P_Fld(0x0, DRAMC_IRQ_EN_MR4INT_EN));
        vIO32WriteFldAlign_All(DRAMC_REG_SHURK_REF_CTRL, 0, SHURK_REF_CTRL_PBREFEN);

        vIO32WriteFldAlign_All(DDRPHY_REG_CA_TX_MCK, 0x1, CA_TX_MCK_R_DMRESET_FRPHY_OPT);
		vIO32WriteFldMulti_All(DDRPHY_REG_CA_TX_MCK, P_Fld(0xa, CA_TX_MCK_R_DMRESETB_DRVP_FRPHY)
                                                    | P_Fld(0xa, CA_TX_MCK_R_DMRESETB_DRVN_FRPHY));
//!remove         vIO32WriteFldAlign_All(DDRPHY_REG_MISC_DVFSCTL2, 0x1, MISC_DVFSCTL2_RG_ADA_MCK8X_EN_SHUFFLE);

        vIO32WriteFldMulti_All(DDRPHY_REG_SHU_B0_DQ10, P_Fld(0x1, SHU_B0_DQ10_RG_RX_ARDQS_DQSSTB_RPST_HS_EN_B0)
                                                    | P_Fld(0x1, SHU_B0_DQ10_RG_RX_ARDQS_DQSSTB_CG_EN_B0));
        vIO32WriteFldMulti_All(DDRPHY_REG_SHU_B1_DQ10, P_Fld(0x1, SHU_B1_DQ10_RG_RX_ARDQS_DQSSTB_RPST_HS_EN_B1)
                                                    | P_Fld(0x1, SHU_B1_DQ10_RG_RX_ARDQS_DQSSTB_CG_EN_B1));

        vIO32WriteFldMulti_All(DDRPHY_REG_SHU_B0_DQ8, P_Fld(1, SHU_B0_DQ8_R_DMRANK_CHG_PIPE_CG_IG_B0)
                                                    | P_Fld(1, SHU_B0_DQ8_R_DMRANK_PIPE_CG_IG_B0)
                                                    | P_Fld(1, SHU_B0_DQ8_R_DMDQSIEN_RDSEL_TOG_PIPE_CG_IG_B0)
                                                    | P_Fld(1, SHU_B0_DQ8_R_DMDQSIEN_RDSEL_PIPE_CG_IG_B0)
                                                    | P_Fld(1, SHU_B0_DQ8_R_DMDQSIEN_FLAG_PIPE_CG_IG_B0)
                                                    | P_Fld(1, SHU_B0_DQ8_R_DMDQSIEN_FLAG_SYNC_CG_IG_B0)
                                                    | P_Fld(1, SHU_B0_DQ8_R_DMRXDLY_CG_IG_B0)
                                                    | P_Fld(1, SHU_B0_DQ8_R_DMRXDVS_RDSEL_TOG_PIPE_CG_IG_B0)
                                                    | P_Fld(1, SHU_B0_DQ8_R_DMRXDVS_RDSEL_PIPE_CG_IG_B0)
                                                    | P_Fld(1, SHU_B0_DQ8_R_RMRODTEN_CG_IG_B0)
                                                    | P_Fld(1, SHU_B0_DQ8_R_DMRANK_RXDLY_PIPE_CG_IG_B0));
        vIO32WriteFldMulti_All(DDRPHY_REG_SHU_B1_DQ8, P_Fld(1, SHU_B1_DQ8_R_DMRANK_CHG_PIPE_CG_IG_B1)
                                                    | P_Fld(1, SHU_B1_DQ8_R_DMRANK_PIPE_CG_IG_B1)
                                                    | P_Fld(1, SHU_B1_DQ8_R_DMDQSIEN_RDSEL_TOG_PIPE_CG_IG_B1)
                                                    | P_Fld(1, SHU_B1_DQ8_R_DMDQSIEN_RDSEL_PIPE_CG_IG_B1)
                                                    | P_Fld(1, SHU_B1_DQ8_R_DMDQSIEN_FLAG_PIPE_CG_IG_B1)
                                                    | P_Fld(1, SHU_B1_DQ8_R_DMDQSIEN_FLAG_SYNC_CG_IG_B1)
                                                    | P_Fld(1, SHU_B1_DQ8_R_DMRXDLY_CG_IG_B1)
                                                    | P_Fld(1, SHU_B1_DQ8_R_DMRXDVS_RDSEL_TOG_PIPE_CG_IG_B1)
                                                    | P_Fld(1, SHU_B1_DQ8_R_DMRXDVS_RDSEL_PIPE_CG_IG_B1)
                                                    | P_Fld(1, SHU_B1_DQ8_R_RMRODTEN_CG_IG_B1)
                                                    | P_Fld(1, SHU_B1_DQ8_R_DMRANK_RXDLY_PIPE_CG_IG_B1));
	#if 0//for ddr3 write leveling
	        vIO32WriteFldAlign_All(DDRPHY_REG_SHU_B0_DLL2, 0x1, SHU_B0_DLL2_RG_ARDQ_REV_B0);
	        vIO32WriteFldAlign_All(DDRPHY_REG_SHU_B1_DLL2, 0x1, SHU_B1_DLL2_RG_ARDQ_REV_B1);
	        vIO32WriteFldAlign_All(DDRPHY_REG_SHU_CA_DLL2, 0x1, SHU_CA_DLL2_RG_ARCMD_REV);    //Jeremy
	#endif
        #if 1
        //Follow DE - DRAMC
        //vIO32WriteFldAlign_All(DRAMC_REG_DDRCOMMON0, 1, DDRCOMMON0_DISSTOP26M);
        //vIO32WriteFldAlign_All(DRAMC_REG_TEST2_A3, 1, TEST2_A3_TEST_AID_EN);
        //vIO32WriteFldAlign_All(DRAMC_REG_TEST2_A4, 0, TEST2_A4_TESTAGENTRKSEL);
        vIO32WriteFldAlign_All(DRAMC_REG_DUMMY_RD, 0, DUMMY_RD_DQSG_DMYRD_EN);
        #if __IPMv2_TO_BE_PORTING__
        vIO32WriteFldAlign_All(DRAMC_REG_DRAMC_DBG_SEL1, 0x1e, DRAMC_DBG_SEL1_DEBUG_SEL_0);
        #endif
        vIO32WriteFldAlign_All(DRAMC_REG_SWCMD_CTRL2, 0x20, SWCMD_CTRL2_RTSWCMD_AGE);
        vIO32WriteFldAlign_All(DRAMC_REG_RTMRW_CTRL0, 0x20, RTMRW_CTRL0_RTMRW_AGE);

        vIO32WriteFldMulti_All(DRAMC_REG_DLLFRZ_CTRL, P_Fld(0, DLLFRZ_CTRL_DLLFRZ) | P_Fld(0, DLLFRZ_CTRL_DLLFRZ_MON_PBREF_OPT));
        vIO32WriteFldMulti_All(DRAMC_REG_MPC_CTRL, P_Fld(1, MPC_CTRL_RTSWCMD_HPRI_EN) | P_Fld(0, MPC_CTRL_RTMRW_HPRI_EN));
        #if __IPMv2_TO_BE_PORTING__
        vIO32WriteFldMulti_All(DRAMC_REG_HW_MRR_FUN, P_Fld(0, HW_MRR_FUN_R2MRRHPRICTL) | P_Fld(0, HW_MRR_FUN_TR2MRR_ENA));
        #endif
        vIO32WriteFldMulti_All(DRAMC_REG_ACTIMING_CTRL, P_Fld(1, ACTIMING_CTRL_REFNA_OPT) | P_Fld(1, ACTIMING_CTRL_SEQCLKRUN3));
        vIO32WriteFldAlign_All(DRAMC_REG_CKECTRL, 1, CKECTRL_RUNTIMEMRRCKEFIX);
        vIO32WriteFldMulti_All(DRAMC_REG_DVFS_CTRL0,
                P_Fld(1, DVFS_CTRL0_R_DVFS_SREF_OPT) |
                P_Fld(1, DVFS_CTRL0_DVFS_QUEFLUSH_NEW_EN));
        vIO32WriteFldAlign_All(DRAMC_REG_DVFS_TIMING_CTRL1, 1, DVFS_TIMING_CTRL1_SHU_PERIOD_GO_ZERO_CNT);
        vIO32WriteFldMulti_All(DRAMC_REG_HMR4, P_Fld(0, HMR4_REFRCNT_OPT)
                                            | P_Fld(1, HMR4_REFR_PERIOD_OPT)
                                            | P_Fld(0, HMR4_SPDR_MR4_OPT)//Resume from S0, trigger HW MR4
                                            | P_Fld(0, HMR4_HMR4_TOG_OPT));
        vIO32WriteFldAlign_All(DRAMC_REG_RX_SET0, 0, RX_SET0_SMRR_UPD_OLD);
        vIO32WriteFldMulti_All(DRAMC_REG_DRAMCTRL,
                P_Fld(1, DRAMCTRL_SHORTQ_OPT) |
                P_Fld(1, DRAMCTRL_DVFS_BLOCK_CTO_ALE_DBG_EN));

        vIO32WriteFldMulti_All(DRAMC_REG_SHU_REF0,
                P_Fld(4, SHU_REF0_MPENDREF_CNT) |
                P_Fld(1, SHU_REF0_KEEP_PBREF_OPT) |
                P_Fld(0, SHU_REF0_KEEP_PBREF));

#if ENABLE_EARLY_BG_CMD==0
        vIO32WriteFldAlign_All(DRAMC_REG_PERFCTL0, 0, PERFCTL0_EBG_EN);
#endif
        vIO32WriteFldMulti_All(DRAMC_REG_REFCTRL0, P_Fld(1, REFCTRL0_PBREF_BK_REFA_ENA) | P_Fld(2, REFCTRL0_PBREF_BK_REFA_NUM));
        vIO32WriteFldMulti_All(DRAMC_REG_REFCTRL1,
            P_Fld(0, REFCTRL1_REF_OVERHEAD_SLOW_REFPB_ENA) | /* cc mp */
            P_Fld(1, REFCTRL1_REFPB2AB_IGZQCS) |
            P_Fld(0, REFCTRL1_REFPENDINGINT_OPT1) |
            P_Fld(0, REFCTRL1_REFPEND_BLOCK_OPT) | /* cc mp */
            P_Fld(1, REFCTRL1_SREFX_REFAB_EN) | /* cc mp */
            P_Fld(1, REFCTRL1_REFPB2AB_IGIMP)); /* cc mp */
        vIO32WriteFldAlign_All(DRAMC_REG_REF_BOUNCE1,5, REF_BOUNCE1_REFRATE_DEBOUNCE_TH);
        vIO32WriteFldAlign_All(DRAMC_REG_SCSMCTRL, 1, SCSMCTRL_SC_PG_MAN_DIS);
        vIO32WriteFldAlign_All(DRAMC_REG_RTSWCMD_CNT, 0x30, RTSWCMD_CNT_RTSWCMD_CNT);
        vIO32WriteFldAlign_All(DRAMC_REG_DRAMC_IRQ_EN, 0x0, DRAMC_IRQ_EN_DRAMC_IRQ_EN_RSV);
        vIO32WriteFldAlign_All(DRAMC_REG_SHU_DCM_CTRL0, 1, SHU_DCM_CTRL0_DDRPHY_CLK_EN_OPT);
        vIO32WriteFldMulti_All(DRAMC_REG_SHU_HMR4_DVFS_CTRL0, P_Fld(0x1ff, SHU_HMR4_DVFS_CTRL0_REFRCNT) | P_Fld(0, SHU_HMR4_DVFS_CTRL0_FSPCHG_PRDCNT));
        vIO32WriteFldAlign_All(DRAMC_REG_SHU_HWSET_VRCG, 11, SHU_HWSET_VRCG_VRCGDIS_PRDCNT);
        vIO32WriteFldAlign_All(DRAMC_REG_SHU_MISC, 2, SHU_MISC_REQQUE_MAXCNT);

        vIO32WriteFldAlign_All(DDRPHY_REG_B0_RXDVS1, 0, B0_RXDVS1_RETRY_RXDLY_OPTION_B0);
        vIO32WriteFldAlign_All(DDRPHY_REG_B1_RXDVS1, 0, B1_RXDVS1_RETRY_RXDLY_OPTION_B1);

        //Follow DE - DDRPHY
        vIO32WriteFldMulti_All(DDRPHY_REG_B0_DLL_ARPI4, P_Fld(1, B0_DLL_ARPI4_RG_ARPI_BYPASS_SR_DQS_B0) | P_Fld(1, B0_DLL_ARPI4_RG_ARPI_BYPASS_SR_DQ_B0));
        vIO32WriteFldMulti_All(DDRPHY_REG_B1_DLL_ARPI4, P_Fld(1, B1_DLL_ARPI4_RG_ARPI_BYPASS_SR_DQS_B1) | P_Fld(1, B1_DLL_ARPI4_RG_ARPI_BYPASS_SR_DQ_B1));
        vIO32WriteFldMulti_All(DDRPHY_REG_CA_DLL_ARPI4, P_Fld(1, CA_DLL_ARPI4_RG_ARPI_BYPASS_SR_CLK_CA) | P_Fld(1, CA_DLL_ARPI4_RG_ARPI_BYPASS_SR_CA_CA));
        vIO32WriteFldMulti_All(DDRPHY_REG_CA_CMD11, P_Fld(0xa, CA_CMD11_RG_RRESETB_DRVN) | P_Fld(0xa, CA_CMD11_RG_RRESETB_DRVP));
        vIO32WriteFldMulti_All(DDRPHY_REG_MISC_CG_CTRL2,
                P_Fld(0x1, MISC_CG_CTRL2_RG_MEM_DCM_CG_OFF_DISABLE) |
                P_Fld(0x3, MISC_CG_CTRL2_RG_MEM_DCM_IDLE_FSEL) |
                P_Fld(0x0, MISC_CG_CTRL2_RG_MEM_DCM_FORCE_ON));
        vIO32WriteFldAlign_All(DDRPHY_REG_MISC_CLK_CTRL, 1, MISC_CLK_CTRL_DVFS_MEM_CK_MCK1X_MUX_UPDATE_EN);

#if 1 // Darren- for DDR400 open loop mode disable
        vIO32WriteFldMulti_All(DDRPHY_REG_MISC_CG_CTRL9, P_Fld(0, MISC_CG_CTRL9_RG_MCK4X_O_FB_CK_CG_OFF)
                                                        | P_Fld(0, MISC_CG_CTRL9_RG_CG_DDR400_MCK4X_O_OFF)
                                                        | P_Fld(0, MISC_CG_CTRL9_RG_MCK4X_O_OPENLOOP_MODE_EN)
                                                        | P_Fld(0, MISC_CG_CTRL9_RG_MCK4X_Q_FB_CK_CG_OFF)
                                                        | P_Fld(0, MISC_CG_CTRL9_RG_CG_DDR400_MCK4X_Q_OFF)
                                                        | P_Fld(0, MISC_CG_CTRL9_RG_MCK4X_Q_OPENLOOP_MODE_EN)
                                                        | P_Fld(0, MISC_CG_CTRL9_RG_MCK4X_I_FB_CK_CG_OFF)
                                                        | P_Fld(0, MISC_CG_CTRL9_RG_CG_DDR400_MCK4X_I_OFF)
                                                        | P_Fld(0, MISC_CG_CTRL9_RG_MCK4X_I_OPENLOOP_MODE_EN)
                                                        | P_Fld(0, MISC_CG_CTRL9_RG_M_CK_OPENLOOP_MODE_EN));
#endif
        //Darren-vIO32WriteFldAlign_All(DDRPHY_REG_MISC_DVFSCTL, 1, MISC_DVFSCTL_R_SHUFFLE_PI_RESET_ENABLE);
        #if __IPMv2_TO_BE_PORTING__
        vIO32WriteFldMulti_All(DDRPHY_REG_MISC_DVFSCTL2, P_Fld(0, MISC_DVFSCTL2_RG_DLL_SHUFFLE)); // Darren-
//!remove         vIO32WriteFldMulti_All(DDRPHY_REG_MISC_DVFSCTL2, P_Fld(1, MISC_DVFSCTL2_RG_ADA_MCK8X_EN_SHUFFLE)
//!remove                                                         | P_Fld(0, MISC_DVFSCTL2_RG_DLL_SHUFFLE)); // Darren-
        #else
//!remove         vIO32WriteFldAlign_All(DDRPHY_REG_MISC_DVFSCTL2, 1, MISC_DVFSCTL2_RG_ADA_MCK8X_EN_SHUFFLE);
        #endif

        vIO32WriteFldMulti_All(DDRPHY_REG_MISC_DVFSCTL3, P_Fld(0x0, MISC_DVFSCTL3_RG_CNT_PHY_ST_DELAY_AFT_CHG_TO_BCLK)
                                                        | P_Fld(2, MISC_DVFSCTL3_RG_DVFS_MEM_CK_SEL_SOURCE)
                                                        | P_Fld(0, MISC_DVFSCTL3_RG_DVFS_MEM_CK_SEL_DESTI)
                                                        | P_Fld(1, MISC_DVFSCTL3_RG_PHY_ST_DELAY_BEF_CHG_TO_BCLK)
                                                        | P_Fld(1, MISC_DVFSCTL3_RG_PHY_ST_DELAY_AFT_CHG_TO_MCLK));

        //Darren-vIO32WriteFldAlign_All(DDRPHY_REG_MISC_RG_DFS_CTRL, 0, MISC_RG_DFS_CTRL_SPM_DVFS_CONTROL_SEL);
        vIO32WriteFldAlign_All(DDRPHY_REG_MISC_DDR_RESERVE, 0xf, MISC_DDR_RESERVE_WDT_CONF_ISO_CNT);
        vIO32WriteFldMulti_All(DDRPHY_REG_MISC_IMP_CTRL1,
                P_Fld(1, MISC_IMP_CTRL1_RG_RIMP_SUS_ECO_OPT) |
                P_Fld(0, MISC_IMP_CTRL1_IMP_ABN_LAT_EN) |
                P_Fld(1, MISC_IMP_CTRL1_IMP_ABN_LAT_CLR) |
                P_Fld(3, MISC_IMP_CTRL1_IMP_DIFF_THD));
        vIO32WriteFldMulti_All(DDRPHY_REG_MISC_IMPCAL,
                P_Fld(1, MISC_IMPCAL_IMPCAL_BYPASS_UP_CA_DRV) |
                P_Fld(1, MISC_IMPCAL_IMPCAL_DRVUPDOPT) |
                P_Fld(1, MISC_IMPCAL_IMPBINARY) |
                P_Fld(0, MISC_IMPCAL_DQDRVSWUPD) |
                P_Fld(0, MISC_IMPCAL_DRVCGWREF));
        #if __IPMv2_TO_BE_PORTING__
        vIO32WriteFldMulti_All(DDRPHY_REG_MISC_DUTYSCAN1, P_Fld(1, MISC_DUTYSCAN1_EYESCAN_DQS_OPT) | P_Fld(1, MISC_DUTYSCAN1_RX_EYE_SCAN_CG_CTRL));
        #endif
        vIO32WriteFldMulti_All(DDRPHY_REG_MISC_DUTYSCAN1,
                P_Fld(0, MISC_DUTYSCAN1_DQSERRCNT_DIS) |
                P_Fld(1, MISC_DUTYSCAN1_EYESCAN_DQS_SYNC_EN));
        vIO32WriteFldAlign_All(DDRPHY_REG_MISC_DVFS_EMI_CLK, 0, MISC_DVFS_EMI_CLK_RG_DLL_SHUFFLE_DDRPHY);
        #if __IPMv2_TO_BE_PORTING__
        vIO32WriteFldMulti_All(DDRPHY_REG_MISC_CTRL0, P_Fld(0, MISC_CTRL0_IDLE_DCM_CHB_CDC_ECO_OPT) | P_Fld(1, MISC_CTRL0_IMPCAL_LP_ECO_OPT));
        #else
        vIO32WriteFldMulti_All(DDRPHY_REG_MISC_CTRL0,
                P_Fld(1, MISC_CTRL0_IMPCAL_LP_ECO_OPT) |
                P_Fld(1, MISC_CTRL0_IMPCAL_CDC_ECO_OPT));
        #endif
        vIO32WriteFldMulti_All(DDRPHY_REG_MISC_CTRL4, P_Fld(0, MISC_CTRL4_R_OPT2_CG_CS)
                                                    | P_Fld(0, MISC_CTRL4_R_OPT2_CG_CLK)
                                                    | P_Fld(0, MISC_CTRL4_R_OPT2_CG_CMD)
                                                    | P_Fld(0, MISC_CTRL4_R_OPT2_CG_DQSIEN)
                                                    | P_Fld(0, MISC_CTRL4_R_OPT2_CG_DQ)
                                                    | P_Fld(0, MISC_CTRL4_R_OPT2_CG_DQS)
                                                    | P_Fld(0, MISC_CTRL4_R_OPT2_CG_DQM)
                                                    | P_Fld(0, MISC_CTRL4_R_OPT2_CG_MCK)
                                                    | P_Fld(0, MISC_CTRL4_R_OPT2_MPDIV_CG));
        vIO32WriteFldMulti_All(DDRPHY_REG_MISC_CTRL5, P_Fld(0, MISC_CTRL5_R_SRAM_ISOINTB)
                                                    | P_Fld(0, MISC_CTRL5_MBIST_RSTB) /* cc mp */
                                                    | P_Fld(1, MISC_CTRL5_R_SPM_SRAM_SLP_MSK)
                                                    | P_Fld(0, MISC_CTRL5_MBIST_RSTB)
                                                    | P_Fld(1, MISC_CTRL5_R_CS_MARK)
                                                    | P_Fld(1, MISC_CTRL5_R_MBIST_MODE)
                                                    | P_Fld(0, MISC_CTRL5_R_MBIST_RPRSTB)
                                                    | P_Fld(0x324, MISC_CTRL5_R_MBIST_RPREG_LOAD));

        vIO32WriteFldMulti_All(DDRPHY_REG_MISC_CTRL6, P_Fld(0x2, MISC_CTRL6_R_SRAM_DELSEL)
                                                    | P_Fld(1, MISC_CTRL6_RG_ADA_MCK8X_EN_SHU_OPT)
                                                    | P_Fld(1, MISC_CTRL6_RG_PHDET_EN_SHU_OPT));

        vIO32WriteFldAlign_All(DDRPHY_REG_MISC_BIST_LPBK_CTRL0, 0xe, MISC_BIST_LPBK_CTRL0_BIST_SEDA_LPBK_DLE_RW);
        vIO32WriteFldAlign_All(DDRPHY_REG_MISC_OE_RODT_LPBK_CTRL0, 0x0, MISC_OE_RODT_LPBK_CTRL0_OE_RODT_LPBK_PAT_LEN);
        vIO32WriteFldMulti_All(DDRPHY_REG_MISC_CTRL0,
                P_Fld(0, MISC_DBG_IRQ_CTRL0_DQSG_RETRY_DB_RK0_B0_LATCH_SRC) |
                P_Fld(0, MISC_DBG_IRQ_CTRL0_DQSG_RETRY_DB_RK0_B1_LATCH_SRC));
        vIO32WriteFldAlign_All(DDRPHY_REG_MISC_DDR_RESERVE2, 0x600, MISC_DDR_RESERVE2_DRM_SM_HOLD_CTRL);
        vIO32WriteFldAlign_All(DDRPHY_REG_MISC_DDR_RESERVE3, 0x8004,  MISC_DDR_RESERVE3_DRM_SM_PASS_CTRL);//TBD, temp setting for low power legacy mode
        vIO32WriteFldAlign_All(DDRPHY_REG_MISC_CG_CTRL10, 0, MISC_CG_CTRL10_RG_MEM_DCM_FORCE_ON_MCK8X);

        vIO32WriteFldMulti_All(DDRPHY_REG_SHU_B0_DQ1, P_Fld(1, SHU_B0_DQ1_RG_ARPI_MIDPI_BYPASS_EN_B0)
                                                    | P_Fld(1, SHU_B0_DQ1_RG_ARPI_MIDPI_DUMMY_EN_B0)
                                                    | P_Fld(1, SHU_B0_DQ1_RG_ARPI_8PHASE_XLATCH_FORCE_B0));
        vIO32WriteFldMulti_All(DDRPHY_REG_SHU_B1_DQ1, P_Fld(1, SHU_B1_DQ1_RG_ARPI_MIDPI_BYPASS_EN_B1)
                                                    | P_Fld(1, SHU_B1_DQ1_RG_ARPI_MIDPI_DUMMY_EN_B1)
                                                    | P_Fld(1, SHU_B1_DQ1_RG_ARPI_8PHASE_XLATCH_FORCE_B1));

        vIO32WriteFldMulti_All(DDRPHY_REG_SHU_B0_DQ10, P_Fld(1, SHU_B0_DQ10_RG_RX_ARDQS_BW_SEL_B0)
                                                    | P_Fld(1, SHU_B0_DQ10_RG_RX_ARDQS_DQSSTB_RPST_HS_EN_B0)    //Critical ?
                                                    | P_Fld(1, SHU_B0_DQ10_RG_RX_ARDQS_DQSSTB_CG_EN_B0));       //Critical ?
        vIO32WriteFldMulti_All(DDRPHY_REG_SHU_B1_DQ10, P_Fld(1, SHU_B1_DQ10_RG_RX_ARDQS_BW_SEL_B1)
                                                    | P_Fld(1, SHU_B1_DQ10_RG_RX_ARDQS_DQSSTB_RPST_HS_EN_B1)    //Critical ?
                                                    | P_Fld(1, SHU_B1_DQ10_RG_RX_ARDQS_DQSSTB_CG_EN_B1));       //Critical ?

        vIO32WriteFldAlign_All(DDRPHY_REG_SHU_B0_DQ11, 1, SHU_B0_DQ11_RG_RX_ARDQ_BW_SEL_B0);
        vIO32WriteFldAlign_All(DDRPHY_REG_SHU_B1_DQ11, 1, SHU_B1_DQ11_RG_RX_ARDQ_BW_SEL_B1);

        vIO32WriteFldAlign_All(DDRPHY_REG_SHU_PHYPLL0, 0x0, SHU_PHYPLL0_RG_RPHYPLL_RESERVED);
        vIO32WriteFldAlign_All(DDRPHY_REG_SHU_CLRPLL0, 0x0, SHU_CLRPLL0_RG_RCLRPLL_RESERVED);

        vIO32WriteFldMulti_All(DDRPHY_REG_SHU_CA_CMD1, P_Fld(1, SHU_CA_CMD1_RG_ARPI_MIDPI_BYPASS_EN_CA) | P_Fld(1, SHU_CA_CMD1_RG_ARPI_MIDPI_DUMMY_EN_CA));
        //Darren-vIO32WriteFldAlign_All(DDRPHY_REG_SHU_CA_CMD10, 1, SHU_CA_CMD10_RG_RX_ARCLK_DLY_LAT_EN_CA);
        vIO32WriteFldAlign_All(DDRPHY_REG_SHU_CA_CMD11, 1, SHU_CA_CMD11_RG_RX_ARCA_BW_SEL_CA);
        vIO32WriteFldMulti_All(DDRPHY_REG_SHU_CA_CMD8, P_Fld(1, SHU_CA_CMD8_R_DMRANK_CHG_PIPE_CG_IG_CA)
                                                    | P_Fld(1, SHU_CA_CMD8_R_DMRANK_PIPE_CG_IG_CA)
                                                    | P_Fld(1, SHU_CA_CMD8_R_DMDQSIEN_RDSEL_TOG_PIPE_CG_IG_CA)
                                                    | P_Fld(1, SHU_CA_CMD8_R_DMDQSIEN_RDSEL_PIPE_CG_IG_CA)
                                                    | P_Fld(1, SHU_CA_CMD8_R_DMDQSIEN_FLAG_PIPE_CG_IG_CA)
                                                    | P_Fld(1, SHU_CA_CMD8_R_DMDQSIEN_FLAG_SYNC_CG_IG_CA)
                                                    | P_Fld(1, SHU_CA_CMD8_R_RMRX_TOPHY_CG_IG_CA)
                                                    | P_Fld(0, SHU_CA_CMD8_R_RMRODTEN_CG_IG_CA));


        vIO32WriteFldMulti_All(DDRPHY_REG_MISC_SHU_IMPEDAMCE_UPD_DIS1, P_Fld(1, MISC_SHU_IMPEDAMCE_UPD_DIS1_CMD1_ODTN_UPD_DIS)
                                                                    | P_Fld(1, MISC_SHU_IMPEDAMCE_UPD_DIS1_CMD1_DRVN_UPD_DIS)
                                                                    | P_Fld(1, MISC_SHU_IMPEDAMCE_UPD_DIS1_CMD1_DRVP_UPD_DIS)
                                                                    | P_Fld(1, MISC_SHU_IMPEDAMCE_UPD_DIS1_CS_ODTN_UPD_DIS)
                                                                    | P_Fld(1, MISC_SHU_IMPEDAMCE_UPD_DIS1_CS_DRVN_UPD_DIS)
                                                                    | P_Fld(1, MISC_SHU_IMPEDAMCE_UPD_DIS1_CS_DRVP_UPD_DIS));

        //Darren-vIO32WriteFldMulti_All(DDRPHY_REG_MISC_SHU_DVFSDLL, P_Fld(67, MISC_SHU_DVFSDLL_R_2ND_DLL_IDLE) | P_Fld(43, MISC_SHU_DVFSDLL_R_DLL_IDLE));

        //Darren-vIO32WriteFldAlign_All(DDRPHY_REG_SHU_MISC_IMPCAL1, 0, SHU_MISC_IMPCAL1_IMPCALCNT);
        //Darren-vIO32WriteFldAlign_All(DDRPHY_REG_SHU_MISC_DRVING2, 0, SHU_MISC_DRVING2_DIS_IMPCAL_ODT_EN);
        if (is_ddr3_family(p))
            vIO32WriteFldAlign_All(DDRPHY_REG_SHU_MISC_DRVING6, 9, SHU_MISC_DRVING6_IMP_TXDLY_CMD);
        else
            vIO32WriteFldAlign_All(DDRPHY_REG_SHU_MISC_DRVING6, 8, SHU_MISC_DRVING6_IMP_TXDLY_CMD);
        vIO32WriteFldAlign_All(DDRPHY_REG_SHU_MISC_IMPCAL1, 0x6, SHU_MISC_IMPCAL1_IMPCAL_CHKCYCLE);

        vIO32WriteFldMulti_All(DDRPHY_REG_MISC_SHU_RX_CG_CTRL, P_Fld(0, MISC_SHU_RX_CG_CTRL_RX_DCM_WAIT_DLE_EXT_DLY)
                                                            | P_Fld(2, MISC_SHU_RX_CG_CTRL_RX_DCM_EXT_DLY)
                                                            | P_Fld(0, MISC_SHU_RX_CG_CTRL_RX_APHY_CTRL_DCM_OPT)
                                                            | P_Fld(0, MISC_SHU_RX_CG_CTRL_RX_DCM_OPT));
        #endif

        vIO32WriteFldAlign_All(DDRPHY_REG_MISC_IO_CTRL0, 0x2, MISC_IO_CTRL0_RG_VREF_SEL);

    #if (fcFOR_CHIP_ID == fcGriffin) && !FOR_DV_SIMULATION_USED
        if (is_ddr3_family(p) && p->DRAMPinmux == PINMUX_EMCP) {
        if (*((volatile unsigned int *)(IO_BASE + 0x01f208d8)) & (1 << 7)) {
            zq_sel = *((volatile unsigned int *)(IO_BASE + 0x01f208d8)) & 0x7f;
            mcSHOW_DBG_MSG("Update ZQ_SEL to Trim value 0x%x\n", zq_sel);
        }
            vIO32WriteFldAlign_All(DDRPHY_REG_MISC_IO_CTRL0, zq_sel, MISC_IO_CTRL0_RG_ZQ_SEL);
        }
    #endif
        DramcBroadcastOnOff(backup_broadcast);
    }
}


/* vDramcInit_PreSettings(): Initial register settings(which are required to be set before all calibration flow) */
void vDramcInit_PreSettings(DRAMC_CTX_T *p)
{
#if __A60868_TO_BE_PORTING__

    /* PAD_RRESETB control sequence */
    //remove twice dram reset pin pulse before dram power on sequence flow
    vIO32WriteFldMulti(DDRPHY_CA_CMD8, P_Fld(0x0, CA_CMD8_RG_TX_RRESETB_PULL_UP) | P_Fld(0x0, CA_CMD8_RG_TX_RRESETB_PULL_DN)
                                     | P_Fld(0x1, CA_CMD8_RG_TX_RRESETB_DDR3_SEL) | P_Fld(0x0, CA_CMD8_RG_TX_RRESETB_DDR4_SEL)
                                     | P_Fld(0xa, CA_CMD8_RG_RRESETB_DRVP) | P_Fld(0xa, CA_CMD8_RG_RRESETB_DRVN));
    vIO32WriteFldAlign(DDRPHY_MISC_CTRL1, 0x1, MISC_CTRL1_R_DMRRESETB_I_OPT); //Change to glitch-free path
    //replace DDRCONF0_GDDR3RST with MISC_CTRL1_R_DMDA_RRESETB_I
    vIO32WriteFldAlign(DDRPHY_MISC_CTRL1, 0x0, MISC_CTRL1_R_DMDA_RRESETB_I);
    vIO32WriteFldAlign(DDRPHY_MISC_CTRL1, 0x1, MISC_CTRL1_R_DMDA_RRESETB_E);

#if __ETT__
    if (GetDramcBroadcast() == DRAMC_BROADCAST_OFF)
    {   // In this function, broadcast is assumed to be ON(LP4) -> Show error if broadcast is OFF
        mcSHOW_ERR_MSG("Err! Broadcast is OFF!\n");
    }
#endif
    return;
#endif
}

#if DDR_ENABLE_DUTY_CAL
void DramcInit_DutyCalibration(DRAMC_CTX_T *p)
{
    U8 channel_idx, channel_backup = vGetPHY2ChannelMapping(p);
    U32 u4backup_broadcast= GetDramcBroadcast();
#ifdef DDR_INIT_TIME_PROFILING
    U32 u4low_tick0, u4high_tick0, u4low_tick1, u4high_tick1;
#if __ETT__
    u4low_tick0 = GPT_GetTickCount(&u4high_tick0);
#else
    u4low_tick0 = get_timer(0);
#endif
#endif

    DramcBroadcastOnOff(DRAMC_BROADCAST_OFF);

#ifndef DUMP_INIT_RG_LOG_TO_DE
    if (Get_MDL_Used_Flag()==NORMAL_USED)
    {
        for (channel_idx = CHANNEL_A; channel_idx < p->support_channel_num; channel_idx++)
        {
            vSetPHY2ChannelMapping(p, channel_idx);
            DramcNewDutyCalibration(p);
        }
        vSetPHY2ChannelMapping(p, channel_backup);
    }
#endif

    DramcBroadcastOnOff(u4backup_broadcast);

#ifdef DDR_INIT_TIME_PROFILING
#if __ETT__
    u4low_tick1 = GPT_GetTickCount(&u4high_tick1);
    gu4DutyCalibrationTime = ((u4low_tick1 - u4low_tick0) * 76) / 1000000;
#else
    u4low_tick1 = get_timer(u4low_tick0);
    gu4DutyCalibrationTime = u4low_tick1;
#endif
#endif
}
#endif

void DV_InitialSettings(DRAMC_CTX_T *p)
{
#ifdef DDR_INIT_TIME_PROFILING
    U32 CPU_Cycle;
    mcSHOW_TIME_MSG("*** Data rate %d ***\n\n", p->frequency << 1);
    TimeProfileBegin();
#endif

    DramcBroadcastOnOff(DRAMC_BROADCAST_ON);

    ANA_init(p);
    DIG_STATIC_SETTING(p);
    DIG_CONFIG_SHUF(p,0,0); //temp ch0 group 0

    DramcBroadcastOnOff(DRAMC_BROADCAST_OFF);

#ifdef DDR_INIT_TIME_PROFILING
    CPU_Cycle = TimeProfileEnd();
    mcSHOW_TIME_MSG("(1)DV_InitialSettings takes %d ms\n\r", CPU_Cycle / 1000);
#endif
}

static void DV_InitialSettings_POST(DRAMC_CTX_T *p)
{
    U8 ch, ch_bak;

    ch_bak = p->channel;

    for (ch = CHANNEL_A; ch < p->support_channel_num; ch++) {
        vSetPHY2ChannelMapping(p, ch);
        DIG_HW_NONSHUF_SWITCH(p,ch);
        DIG_HW_SHUF_SWITCH(p,ch,0);
    }

    vSetPHY2ChannelMapping(p, ch_bak);
}

void SA_InitialSettings1(DRAMC_CTX_T *p)
{
#ifdef DDR_INIT_TIME_PROFILING
    U32 CPU_Cycle;
    TimeProfileBegin();
#endif

    DramcBroadcastOnOff(DRAMC_BROADCAST_ON);
    if(is_ddr4_family(p))
    {
        PC4_UpdateInitialSettings(p);
    }
    else
    {
        PC3_UpdateInitialSettings(p);
    }
    vResetDelayChainBeforeCalibration(p);
    DramcBroadcastOnOff(DRAMC_BROADCAST_OFF);

#if MRW_BACKUP
    U8 u1RKIdx;

    for(u1RKIdx=0; u1RKIdx<p->support_rank_num; u1RKIdx++)
    {
        gFSPWR_Flag[u1RKIdx]=p->dram_fsp;
    }
#endif

	DdrUpdateACTiming(p);

#ifdef FOR_HQA_REPORT_USED
    if (gHQALog_flag==1)
    {
        mcSHOW_DBG_MSG("[HQA] Log parsing, ");
        mcSHOW_DBG_MSG("\tDram Data rate = "); HQA_LOG_Print_Freq_String(p); mcSHOW_DBG_MSG("\n");
    }
#endif


#if PRINT_CALIBRATION_SUMMARY
    //default set DRAM status = NO K
    memset(p->aru4CalResultFlag, 0xffff, sizeof(p->aru4CalResultFlag));
    memset(p->aru4CalExecuteFlag, 0, sizeof(p->aru4CalExecuteFlag));
#if PRINT_CALIBRATION_SUMMARY_FASTK_CHECK
    memset(p->FastKResultFlag, 0xffff, sizeof(p->FastKResultFlag));
    memset(p->FastKExecuteFlag, 0, sizeof(p->FastKExecuteFlag));
#endif
#endif

#if __IPMv2_TO_BE_PORTING__ ///TODO: cc: remove later??
    if(!is_lp5_family(p))
        DVFSSettings(p);
#endif

    vSet_Dram_Vrefca_Source(p); //check by SA/BU

    DDRPhyFreqMeter(p);

    vSetRank(p, RANK_0);

#if DDR_ENABLE_8PHASE_CAL
#if FOR_DV_SIMULATION_USED
    if (SASimCtlGlobal.sim_8ph)
#endif
    Dramc8PhaseCal(p);
#endif

#if DDR_ENABLE_DUTY_CAL
#if FOR_DV_SIMULATION_USED
    if (SASimCtlGlobal.sim_duty)
#endif
    DramcInit_DutyCalibration(p);
#endif

#ifdef DDR_INIT_TIME_PROFILING
        CPU_Cycle = TimeProfileEnd();
        mcSHOW_TIME_MSG("  (1) SA_InitialSettings1() take %d ms\n\n", (CPU_Cycle / 1000) - gu4DutyCalibrationTime);
        mcSHOW_TIME_MSG("  (2) DramcNewDutyCalibration take %d ms\n\r", gu4DutyCalibrationTime);
#endif
}

void SA_InitialSettings2(DRAMC_CTX_T *p)
{
    DramcBroadcastOnOff(DRAMC_BROADCAST_OFF);

    memset(p->isWLevInitShift, FALSE, sizeof(p->isWLevInitShift));

    vBeforeCalibration(p);

#ifdef DUMP_INIT_RG_LOG_TO_DE /* DV sim will cause log missing if hang */
#if FOR_DV_SIMULATION_USED /* DV sim will cause log missing if hang */
    gDUMP_INIT_RG_LOG_TO_DE_RG_log_flag = 0; /* Stop dump for DV sim */
#else
    while (1);
#endif
#endif


#ifndef DUMP_INIT_RG_LOG_TO_DE
#if DDR_ENABLE_MIOCK_JMETER_CAL
    if ((Get_MDL_Used_Flag()==NORMAL_USED) && (p->frequency >= 800))
    {
        Get_RX_DelayCell(p);
    }
#endif
#endif

#ifdef DDR_INIT_TIME_PROFILING
    U32 CPU_Cycle;
    TimeProfileBegin();
#endif

#ifndef DUMP_INIT_RG_LOG_TO_DE
#if DDR_ENABLE_MIOCK_JMETER_CAL
#if FOR_DV_SIMULATION_USED
    if (SASimCtlGlobal.sim_jm)
#endif
    {
        p->u2DelayCellTimex100 = GetVcoreDelayCellTime(p);
    }
#endif
#endif

#ifdef DDR_INIT_TIME_PROFILING
    CPU_Cycle=TimeProfileEnd();
    mcSHOW_TIME_MSG("  (3) JMeter takes %d ms\n\r", CPU_Cycle / 1000);
#endif

}

DRAM_STATUS_T DramcInit(DRAMC_CTX_T *p)
{
    // TODO: PCDDR need porting
    mcSHOW_PARSER_MSG(("\n[DramcInit]\n"));
    return DRAM_OK;
}


#if ENABLE_TMRRI_NEW_MODE
void SetCKE2RankIndependent(DRAMC_CTX_T *p)
{
    #if ENABLE_TMRRI_NEW_MODE//Newly added CKE control mode API
	mcSHOW_DBG_MSG("SET_CKE_2_RANK_INDEPENDENT_RUN_TIME: ON\n");
    vCKERankCtrl(p, CKE_RANK_INDEPENDENT);
    #else //Legacy individual CKE control register settings
	mcSHOW_DBG_MSG("SET_CKE_2_RANK_INDEPENDENT_RUN_TIME: OFF\n");
	vCKERankCtrl(p, CKE_RANK_DEPENDENT);
    #endif
}
#endif


#if DDR_ENABLE_WRITE_DBI
void EnableDRAMModeRegWriteDBIAfterCalibration(DRAMC_CTX_T *p)
{
    U8 channel_idx, rank_idx;
    U8 ch_backup, rank_backup, u1FSPIdx = 0;
    S8 u1ShuffleIdx;

    ch_backup = p->channel;
    rank_backup = p->rank;

    for (channel_idx = CHANNEL_A; channel_idx < p->support_channel_num; channel_idx++)
    {
        vSetPHY2ChannelMapping(p, channel_idx);
        for (rank_idx = RANK_0; rank_idx < p->support_rank_num; rank_idx++)
        {
            vSetRank(p, rank_idx);
            for (u1FSPIdx = FSP_0; u1FSPIdx < p->support_fsp_num; u1FSPIdx++)
            {
                DramcMRWriteFldAlign(p, 13, u1FSPIdx, MR13_FSP_WR, TO_MR);
                SetDramModeRegForWriteDBIOnOff(p, u1FSPIdx, p->DBI_W_onoff[u1FSPIdx]);
            }
        }
    }

    vSetRank(p, rank_backup);
    vSetPHY2ChannelMapping(p, ch_backup);
}
#endif

#if DDR_ENABLE_READ_DBI
void EnableDRAMModeRegReadDBIAfterCalibration(DRAMC_CTX_T *p)
{
    U8 channel_idx, rank_idx;
    U8 ch_backup, rank_backup, u1FSPIdx = 0;
    S8 u1ShuffleIdx;

    ch_backup = p->channel;
    rank_backup = p->rank;

    for (channel_idx = CHANNEL_A; channel_idx < p->support_channel_num; channel_idx++)
    {
        vSetPHY2ChannelMapping(p, channel_idx);
        for (rank_idx = RANK_0; rank_idx < p->support_rank_num; rank_idx++)
        {
            vSetRank(p, rank_idx);
            for (u1FSPIdx = FSP_0; u1FSPIdx < p->support_fsp_num; u1FSPIdx++)
            {
                DramcMRWriteFldAlign(p, 13, u1FSPIdx, MR13_FSP_WR, TO_MR);
                SetDramModeRegForReadDBIOnOff(p, u1FSPIdx, p->DBI_R_onoff[u1FSPIdx]);
            }
        }
    }

    //[Ei_ger] DVT item RD2MRR & MRR2RD
    vIO32WriteFldMulti_All(DRAMC_REG_HW_MRR_FUN, P_Fld(0x1, HW_MRR_FUN_TR2MRR_ENA)
                                           | P_Fld(0x1, HW_MRR_FUN_R2MRRHPRICTL)
                                           | P_Fld(0x1, HW_MRR_FUN_MANTMRR_EN));

    vSetRank(p, rank_backup);
    vSetPHY2ChannelMapping(p, ch_backup);
}
#endif

void DramcShuTrackingDcmEnBySRAM(DRAMC_CTX_T *p)
{
#if (DDR_ENABLE_TX_TRACKING && TX_RETRY_ENABLE)
    Enable_and_Trigger_TX_Retry(p);
#endif

    // add your function
    // For example: EnableDramcPhyDCMShuffle(p, enable_dcm, u4DramcShuOffset, u4DDRPhyShuOffset, u1ShuffleIdx);
#if DDR_HW_GATING
        DDR_Enable_Gating_Tracking(p); // Enable HW gating tracking
#endif

#if ENABLE_RX_DCM_DPHY
        EnableRxDcmDPhy(p);
#endif

        Enable_ClkTxRxLatchEn(p); // for new xrank mode

#if DDR_ENABLE_TX_WDQS // @Darren, To avoid unexpected DQS toggle during calibration
        Enable_TxWDQS(p, u4DDRPhyShuOffset, u2Freq);
#endif

        int enable_dcm = 0;
#if APPLY_LOWPOWER_GOLDEN_SETTINGS
#if __ETT__
    enable_dcm = 1;
#else
    enable_dcm = (doe_get_config("dramc_dcm")) ? 0 : 1;
#endif
#endif
    EnableDramcPhyDCMShuffle(p, enable_dcm);
}

void DramcEnablePerBankRefresh(DRAMC_CTX_T *p, bool en)
{
#if __IPMv2_TO_BE_PORTING__
    if (en)
    {
        vIO32WriteFldMulti_All(DRAMC_REG_REFCTRL0, P_Fld(1, REFCTRL0_PBREF_BK_REFA_ENA) | P_Fld(2, REFCTRL0_PBREF_BK_REFA_NUM));

    #if PER_BANK_REFRESH_USE_MODE==0
            vIO32WriteFldMulti_All(DRAMC_REG_REFCTRL0, P_Fld(0, REFCTRL0_KEEP_PBREF) | P_Fld(0, REFCTRL0_KEEP_PBREF_OPT)); //Original mode
            mcSHOW_DBG_MSG("\tPER_BANK_REFRESH: Original Mode\n");
    #endif

    #if PER_BANK_REFRESH_USE_MODE==1
            vIO32WriteFldMulti_All(DRAMC_REG_REFCTRL0, P_Fld(0, REFCTRL0_KEEP_PBREF) | P_Fld(1, REFCTRL0_KEEP_PBREF_OPT)); //Hybrid mode
            mcSHOW_DBG_MSG("\tPER_BANK_REFRESH: Hybrid Mode\n");
    #endif

    #if PER_BANK_REFRESH_USE_MODE==2
            vIO32WriteFldMulti_All(DRAMC_REG_REFCTRL0, P_Fld(1, REFCTRL0_KEEP_PBREF) | P_Fld(0, REFCTRL0_KEEP_PBREF_OPT)); //Always per-bank mode
            mcSHOW_DBG_MSG("\tPER_BANK_REFRESH: Always Per-Bank Mode\n");
    #endif

        vIO32WriteFldAlign_All(DRAMC_REG_REFCTRL1, 1, REFCTRL1_REFPB2AB_IGZQCS);
    }

    vIO32WriteFldAlign_All(DRAMC_REG_SHU_CONF0, en, SHU_CONF0_PBREFEN);
#endif
}

#if ENABLE_REFRESH_RATE_DEBOUNCE
void DramcRefreshRateDeBounceEnable(DRAMC_CTX_T *p)
{
    vIO32WriteFldMulti_All(DRAMC_REG_REF_BOUNCE1, P_Fld(0x4 , REF_BOUNCE1_REFRATE_DEBOUNCE_COUNT) | // when De-bounce counter >= this count, then dramc apply new dram's MR4 value
                                                  P_Fld(5 , REF_BOUNCE1_REFRATE_DEBOUNCE_TH) |  // MR4 value >= 0.5X refresh rate, then de-bounce count active
                                                  P_Fld(0 , REF_BOUNCE1_REFRATE_DEBOUNCE_OPT) |
                                                  P_Fld(0xffff , REF_BOUNCE1_REFRATE_DEBOUNCE_DIS) ); //all bits set 1 to disable debounce function
}
#endif

#if DDR_DRAMC_MODIFIED_REFRESH_MODE
void DramcModifiedRefreshMode(DRAMC_CTX_T *p)
{
    vIO32WriteFldMulti_All(DRAMC_REG_REFCTRL1, P_Fld(1, REFCTRL1_REFPEND_OPT1) | P_Fld(0, REFCTRL1_REFPEND_OPT2));
    vIO32WriteFldAlign_All(DRAMC_REG_SHU_REF0, 4, SHU_REF0_MPENDREF_CNT);
}
#endif

#if DRAMC_CKE_DEBOUNCE
void DramcCKEDebounce(DRAMC_CTX_T *p)
{
    U8 u1CKE_DBECnt = 15;
    U8 rank_backup, u1RKIdx=0;
    if(p->frequency>=1866)
    {
        rank_backup = p->rank;
        for(u1RKIdx=0; u1RKIdx<p->support_rank_num; u1RKIdx++)
        {
            vSetRank(p, u1RKIdx);
            vIO32WriteFldAlign_All(DRAMC_REG_SHURK_CKE_CTRL, u1CKE_DBECnt, SHURK_CKE_CTRL_CKE_DBE_CNT);
            mcSHOW_DBG_MSG("CKE Debounce cnt = %d\n", u1CKE_DBECnt);
        }
        vSetRank(p, rank_backup);
    }
}
#endif

//1.Some RG setting will need to be DCM on, since not consider S0 2.ENABLE_RX_DCM_DPHY should be 1
void S0_DCMOffWA(DRAMC_CTX_T *p)//For S0 + DCM off
{
    vIO32WriteFldMulti_All(DDRPHY_REG_MISC_CG_CTRL0,
            P_Fld(0x0, MISC_CG_CTRL0_RG_CG_RX_COMB1_OFF_DISABLE) |
            P_Fld(0x0, MISC_CG_CTRL0_RG_CG_RX_COMB0_OFF_DISABLE) |
            P_Fld(0x0, MISC_CG_CTRL0_RG_CG_RX_CMD_OFF_DISABLE) |
            P_Fld(0x0, MISC_CG_CTRL0_RG_CG_COMB1_OFF_DISABLE) |
            P_Fld(0x0, MISC_CG_CTRL0_RG_CG_COMB0_OFF_DISABLE) |
            P_Fld(0x0, MISC_CG_CTRL0_RG_CG_CMD_OFF_DISABLE) |
            P_Fld(0x0, MISC_CG_CTRL0_RG_CG_COMB_OFF_DISABLE) |
            P_Fld(0x0, MISC_CG_CTRL0_RG_CG_PHY_OFF_DIABLE) |
            P_Fld(0x0, MISC_CG_CTRL0_RG_CG_DRAMC_OFF_DISABLE));
}

void DramcRunTimeConfig(DRAMC_CTX_T *p)
{
#if ENABLE_DFS_SSC_WA
	U8 cur_shu_level = vGet_Current_SRAMShuLevel(p);
	mcSHOW_DBG_MSG("DramcSSCHoppingOnOff current shuffle level: %d\n", cur_shu_level);

	DramcSSCHoppingOnOff(p, cur_shu_level, ENABLE);
#endif

#if DDR_ENABLE_RUNTIME_CONFIG
    mcSHOW_DBG_MSG("[DramcRunTimeConfig]: ON\n");
#if defined(DPM_CONTROL_AFTERK) && ((DRAMC_DFS_MODE%2) != 0)
	DPMInit(p);
	mcSHOW_DBG_MSG("DPM_CONTROL_AFTERK: ON\n");
#else
	mcSHOW_DBG_MSG("!!! DPM_CONTROL_AFTERK: OFF\n");
	mcSHOW_DBG_MSG("!!! DPM could not control APHY\n");
#endif

#if DDR_ENABLE_PER_BANK_REFRESH
    mcSHOW_DBG_MSG("PER_BANK_REFRESH: ON\n");
#else
    mcSHOW_DBG_MSG("PER_BANK_REFRESH: OFF\n");
#endif

#if REFRESH_OVERHEAD_REDUCTION
    vIO32WriteFldAlign_All(DRAMC_REG_REFCTRL1, 0x1, REFCTRL1_REF_OVERHEAD_SLOW_REFPB_ENA);
    mcSHOW_DBG_MSG("REFRESH_OVERHEAD_REDUCTION: ON\n");
#else
    mcSHOW_DBG_MSG("REFRESH_OVERHEAD_REDUCTION: OFF\n");
#endif

#if CMD_PICG_NEW_MODE
    mcSHOW_DBG_MSG("CMD_PICG_NEW_MODE: ON\n");
#else
    mcSHOW_DBG_MSG("CMD_PICG_NEW_MODE: OFF\n");
#endif

#if XRTWTW_NEW_CROSS_RK_MODE
    if (p->support_rank_num == RANK_DUAL)
    {
        //ENABLE_XRTWTW_Setting(p); // @Darren, DV codes is included
        mcSHOW_DBG_MSG("XRTWTW_NEW_MODE: ON\n");
    }
#else
    mcSHOW_DBG_MSG("XRTWTW_NEW_MODE: OFF\n");
#endif

#if XRTRTR_NEW_CROSS_RK_MODE
    if (p->support_rank_num == RANK_DUAL)
    {
	    //ENABLE_XRTRTR_Setting(p); // @Darren, DV codes is included
	    mcSHOW_DBG_MSG("XRTRTR_NEW_MODE: ON\n");
    }
#else
    mcSHOW_DBG_MSG("XRTRTR_NEW_MODE: OFF\n");
#endif

#if DDR_ENABLE_TX_TRACKING
    mcSHOW_DBG_MSG("TX_TRACKING: ON\n");
#else
    mcSHOW_DBG_MSG("TX_TRACKING: OFF\n");
#endif

#if DDR_RDSEL_TRACKING_EN
    mcSHOW_DBG_MSG("RDSEL_TRACKING: ON\n");
#else
    mcSHOW_DBG_MSG("RDSEL_TRACKING: OFF\n");
#endif

#if TDQSCK_PRECALCULATION_FOR_DVFS && DDR_DFS_ENABLE
    mcSHOW_DBG_MSG("DQS Precalculation for DVFS: ");
    /* Maoauo: Enable DQS precalculation for LP4, disable for LP3(same as Kibo) */
    DramcDQSPrecalculation_enable(p);
    mcSHOW_DBG_MSG("ON\n");
#else
    mcSHOW_DBG_MSG("DQS Precalculation for DVFS: OFF\n");
#endif

#if DDR_ENABLE_RX_TRACKING
    DramcRxInputDelayTrackingInit_Common(p);
    DramcRxInputDelayTrackingHW(p);
    mcSHOW_DBG_MSG("RX_TRACKING: ON\n");
#else
    mcSHOW_DBG_MSG("RX_TRACKING: OFF\n");
#endif

#if (DDR_ENABLE_RX_TRACKING && RX_DLY_TRACK_ONLY_FOR_DEBUG && defined(DUMMY_READ_FOR_TRACKING))
    mcSHOW_DBG_MSG("RX_DLY_TRACK_DBG: ON\n");
    DramcRxDlyTrackDebug(p);
#endif

/* HW gating - Disabled by default(in preloader) to save power (DE: HJ Huang) */
#if DDR_HW_GATING
    if (is_ddr4_family(p)) {
        mcSHOW_DBG_MSG("DDR_HW_GATING DBG: ON\n");
        DramcHWGatingDebugOnOff(p, ENABLE);
    } else {
        mcSHOW_DBG_MSG("DDR_HW_GATING DBG: OFF\n");
        DramcHWGatingDebugOnOff(p, DISABLE);
    }
#else
    mcSHOW_DBG_MSG("DDR_HW_GATING DBG: OFF\n");
    DramcHWGatingDebugOnOff(p, DISABLE);
#endif

#if DDR_ZQCS_ENABLE
    // if CHA.ZQCSMASK=1, and then set CHA.ZQCALDISB=1 first, else set CHB.ZQCALDISB=1 first
#if (fcFOR_CHIP_ID == fcGriffin)
    vIO32WriteFldAlign_All(DRAMC_REG_ZQ_SET1, 1, ZQ_SET1_ZQCSDISB);
#endif
    mcSHOW_DBG_MSG("DDR_ZQCS_ENABLE: ON\n");
#else
    vIO32WriteFldAlign_All(DRAMC_REG_ZQ_SET1, 0, ZQ_SET1_ZQCSDISB);
    mcSHOW_DBG_MSG("DDR_ZQCS_ENABLE: OFF\n");
#endif

#if RX_PICG_NEW_MODE
    mcSHOW_DBG_MSG("RX_PICG_NEW_MODE: ON\n");
#else
    mcSHOW_DBG_MSG("RX_PICG_NEW_MODE: OFF\n");
#endif

#if TX_PICG_NEW_MODE
    TXPICGNewModeEnable(p);
    mcSHOW_DBG_MSG("TX_PICG_NEW_MODE: ON\n");
#else
    mcSHOW_DBG_MSG("TX_PICG_NEW_MODE: OFF\n");
#endif

#if ENABLE_RX_DCM_DPHY
    mcSHOW_DBG_MSG("ENABLE_RX_DCM_DPHY: ON\n");
#else
    mcSHOW_DBG_MSG("ENABLE_RX_DCM_DPHY: OFF\n");
#endif

    int enable_dcm = 0;
#if APPLY_LOWPOWER_GOLDEN_SETTINGS
	#if __ETT__
    enable_dcm = 1;
    #elif (FOR_DV_SIMULATION_USED == 1)
    enable_dcm = 1;
	#else
    enable_dcm = (doe_get_config("dramc_dcm"))? 0: 1;
	#endif
#endif

//    char *str = (enable_dcm == 1)? ("ON") : ("OFF");
    EnableDramcPhyDCM(p, enable_dcm);
//    EnableDramcPhyDCMNonShuffle(p, enable_dcm);
    mcSHOW_DBG_MSG("LOWPOWER_GOLDEN_SETTINGS(DCM): %s\n", (enable_dcm == 1)? ("ON") : ("OFF"));

#if fcFOR_CHIP_ID != fcGriffin
    if(enable_dcm == 0)
    {
        S0_DCMOffWA(p);//For S0 + DCM off
    }
#endif

    DramcShuTrackingDcmEnBySRAM(p);

//Dummy read should NOT be enabled before gating tracking
#if DDR_DUMMY_READ_FOR_TRACKING
    DramcDummyReadForTrackingEnable(p);
#else
    mcSHOW_DBG_MSG("DUMMY_READ_FOR_TRACKING: OFF\n");
#endif


#if DDR_SPM_CONTROL_AFTERK
    DVFS_PRE_config(p);
    TransferToSPMControl(p);
    mcSHOW_DBG_MSG("SPM_CONTROL_AFTERK: ON\n");
#else
    mcSHOW_DBG_MSG("!!! SPM_CONTROL_AFTERK: OFF\n");
    mcSHOW_DBG_MSG("!!! SPM could not control APHY\n");
#endif

// when time profiling multi times, SW impedance tracking will fail when trakcing enable.
// ignor SW impedance tracking when doing time profling
#ifndef DDR_INIT_TIME_PROFILING
#if DDR_IMPEDANCE_TRACKING_ENABLE
    if (is_ddr4_family(p))
    {
        DramcImpedanceTrackingEnable(p);
        mcSHOW_DBG_MSG("IMPEDANCE_TRACKING: ON\n");
        DramcImpedanceHWSaving(p);
    }
#else
    mcSHOW_DBG_MSG("IMPEDANCE_TRACKING: OFF\n");
#endif
#endif

    //0x1c0[31]
    //vIO32WriteFldAlign(DRAMC_REG_ADDR(DRAMC_REG_DQSCAL0), 0, DQSCAL0_STBCALEN);

#if DDR_HW_SAVE_FOR_SR
    HwSaveForSR(p);
    mcSHOW_DBG_MSG("HW_SAVE_FOR_SR: ON\n");
#else
    mcSHOW_DBG_MSG("HW_SAVE_FOR_SR: OFF\n");
#endif

#if DDR_CLK_FREE_FUN_FOR_DRAMC_PSEL
    ClkFreeRunForDramcPsel(p);
    mcSHOW_DBG_MSG("CLK_FREE_FUN_FOR_DRAMC_PSEL: ON\n");
#else
    mcSHOW_DBG_MSG("CLK_FREE_FUN_FOR_DRAMC_PSEL: OFF\n");
#endif

#if PA_IMPROVEMENT_FOR_DRAMC_ACTIVE_POWER
    DramcPAImprove(p);
    mcSHOW_DBG_MSG("PA_IMPROVEMENT_FOR_DRAMC_ACTIVE_POWER: ON\n");
#else
    mcSHOW_DBG_MSG("PA_IMPROVEMENT_FOR_DRAMC_ACTIVE_POWER: OFF\n");
#endif

#if DDR_ENABLE_RODT_TRACKING
    mcSHOW_DBG_MSG("Read ODT Tracking: ON\n");
#else
    mcSHOW_DBG_MSG("Read ODT Tracking: OFF\n");
#endif

#if ENABLE_REFRESH_RATE_DEBOUNCE
    mcSHOW_DBG_MSG("Refresh Rate DeBounce: OFF\n");
    DramcRefreshRateDeBounceEnable(p);
#endif

#if (CHECK_GOLDEN_SETTING == TRUE)
    DRAM_STATUS_T stResult = CheckGoldenSetting(p);
    mcSHOW_DBG_MSG("End of run time ==>Golden setting check: %s\n", (stResult == DRAM_OK)? ("OK") : ("NG"));
#endif

#if DFS_NOQUEUE_FLUSH_WA && DDR_DFS_ENABLE
    EnableDFSNoQueueFlush(p);
    mcSHOW_DBG_MSG("DFS_NO_QUEUE_FLUSH: ON\n");
#else
    mcSHOW_DBG_MSG("DFS_NO_QUEUE_FLUSH: OFF\n");
#endif

#if DFS_NOQUEUE_FLUSH_LATENCY_CNT && DDR_DFS_ENABLE
    vIO32WriteFldAlign_All(DDRPHY_MD32_REG_LPIF_FSM_CFG, 1, LPIF_FSM_CFG_DBG_LATENCY_CNT_EN);
    // MD32 clock is 208M
    vIO32WriteFldMulti_All(DDRPHY_MD32_REG_SSPM_MCLK_DIV, P_Fld(0, SSPM_MCLK_DIV_MCLK_SRC)
        | P_Fld(0, SSPM_MCLK_DIV_MCLK_DIV));
    mcSHOW_DBG_MSG("DFS_NO_QUEUE_FLUSH_LATENCY_CNT: ON\n");
#else
    mcSHOW_DBG_MSG("DFS_NO_QUEUE_FLUSH_LATENCY_CNT: OFF\n");
#endif

#if ENABLE_DFS_RUNTIME_MRW && DDR_DFS_ENABLE
    DFSRuntimeFspMRW(p);
    mcSHOW_DBG_MSG("ENABLE_DFS_RUNTIME_MRW: ON\n");
#else
    mcSHOW_DBG_MSG("ENABLE_DFS_RUNTIME_MRW: OFF\n");
#endif

    vAutoRefreshSwitch(p, ENABLE);

#if 0
	vIO32WriteFldMulti_All(DRAMC_REG_ADDR(DDRPHY_REG_MISC_DDR_RESERVE2),
				P_Fld(0x600, MISC_DDR_RESERVE2_DRM_SM_HOLD_CTRL) |
				P_Fld(0x4e2, MISC_DDR_RESERVE2_WDT_TX_DIS_CNT));

	vIO32WriteFldMulti_All(DRAMC_REG_ADDR(DDRPHY_REG_MISC_DDR_RESERVE3),
				P_Fld(0, MISC_DDR_RESERVE3_WDT_DRAMC_SREF_ACK_RGMODE_EN) |
				P_Fld(0, MISC_DDR_RESERVE3_WDT_DRAMC_SREF_ACK_RGMODE) |
				P_Fld(0, MISC_DDR_RESERVE3_WDT_DRAMC_ISO_RGMODE_EN) |
				P_Fld(0, MISC_DDR_RESERVE3_WDT_DRAMC_ISO_RGMODE) |
				P_Fld(0, MISC_DDR_RESERVE3_WDT_DRAMC_SREF_RGMODE_EN) |
				P_Fld(0, MISC_DDR_RESERVE3_WDT_DRAMC_SREF_RGMODE) |
				P_Fld(0, MISC_DDR_RESERVE3_WDT_TX_DIS_EN) |
				P_Fld(0x8004, MISC_DDR_RESERVE3_DRM_SM_PASS_CTRL));

	vSetPHY2ChannelMapping(p, CHANNEL_B);
	vIO32WriteFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_MISC_DDR_RESERVE3), 1,  MISC_DDR_RESERVE3_WDT_DRAMC_SREF_ACK_RGMODE);
	vIO32WriteFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_MISC_DDR_RESERVE3), 1,  MISC_DDR_RESERVE3_WDT_DRAMC_SREF_ACK_RGMODE_EN);
	vSetPHY2ChannelMapping(p, CHANNEL_A);

	*(volatile unsigned int *)(0x1023B0C8) = 0xD0641906;
	*(volatile unsigned int *)(0x1023B0CC) = 0x90641906;
	*(volatile unsigned int *)(0x1023B138) = 0x00041800;
	*(volatile unsigned int *)(0x1023B13C) = 0x00041800;

	*(volatile unsigned int *)(0x1024B0C8) = 0xD0641906;
	*(volatile unsigned int *)(0x1024B0CC) = 0x90641906;
	*(volatile unsigned int *)(0x1024B138) = 0x00041800;
	*(volatile unsigned int *)(0x1024B13C) = 0x00041800;

	*(volatile unsigned int *)(0x1024A530) = 0x010A03F5;
//	*(volatile unsigned int *)(0x1024A850) |= 0xC0000000;
#endif

	#if 0	// check enter self-refresh counter for measument time
	vIO32WriteFldAlign_All(DRAMC_REG_ADDR(DRAMC_REG_SREF_DPD_CTRL), 1,  SREF_DPD_CTRL_SELFREF);
	vIO32WriteFldAlign_All(DRAMC_REG_ADDR(DRAMC_REG_DMMONITOR), 1, DMMONITOR_BUSMONEN_SW);//Trigger 8 latency counter
	{
		int i = 0;
		for (i = 0; i < 30; i++)
			mcSHOW_DBG_MSG("NAO 394 = 0x%x, 80 = 0x%x, 24 = 0x%x\n",
			u4IO32Read4B(DRAMC_REG_MAX_SREF_REQ_TO_ACK_LATENCY_COUNTER),
			u4IO32Read4B(DRAMC_REG_MISC_STATUSA), u4IO32Read4B(DRAMC_REG_DMMONITOR));
	}
	#endif

	#if 0	// enter self-refresh by manual
	vIO32WriteFldAlign_All(DRAMC_REG_ADDR(DDRPHY_MD32_REG_LPIF_LOW_POWER_CFG_0), 3, LPIF_LOW_POWER_CFG_0_EMI_CLK_OFF_REQ);
	while(u4IO32ReadFldAlign(DDRPHY_MD32_REG_LPIF_STATUS_4, LPIF_STATUS_4_EMI_CLK_OFF_REQ_ACK) != 0x3);
	if(u4IO32ReadFldAlign(DRAMC_REG_MISC_STATUSA, MISC_STATUSA_SREF_STATE)) {
		mcSHOW_DBG_MSG("CHA in self refresh\n");
	} else {
		mcSHOW_DBG_MSG("CHA not in self refresh\n");
	}
	#endif

#if DDR_RESERVE_NEW_MODE
    mcSHOW_DBG_MSG("DDR_RESERVE_NEW_MODE: ON\n");
    vIO32WriteFldMulti_All(DDRPHY_REG_MISC_DDR_RESERVE, P_Fld(1, MISC_DDR_RESERVE_WDT_LITE_EN) | P_Fld(0, MISC_DDR_RESERVE_WDT_SM_CLR));
#else
    mcSHOW_DBG_MSG("DDR_RESERVE_NEW_MODE: OFF\n");
    vIO32WriteFldMulti_All(DDRPHY_REG_MISC_DDR_RESERVE, P_Fld(0, MISC_DDR_RESERVE_WDT_LITE_EN) | P_Fld(1, MISC_DDR_RESERVE_WDT_SM_CLR));
#endif

#else
    mcSHOW_DBG_MSG("[DramcRunTimeConfig]: OFF\n");
#endif

    mcSHOW_DBG_MSG("=========================\n");
}


#if (ENABLE_TX_TRACKING && TX_RETRY_ENABLE)
void SPMTx_Track_Retry_OnOff(DRAMC_CTX_T *p, U8 shu_level, U8 onoff)
{
    static U8 gIsddr800TxRetry = 0;

    // MCK still available for DRAMC RG access from Joe comment
    if (shu_level == SRAM_SHU6)
    {
        gIsddr800TxRetry = 1;
    }

    if ((gIsddr800TxRetry == 1) && (shu_level != SRAM_SHU6)) //Need to do tx retry when DDR800 -> DDr1200
    {
        if (onoff == ENABLE)
        {
            mcSHOW_DBG_MSG("TX track retry: ENABLE! (DDR800 to DDR1200)\n");
            vIO32WriteFldAlign_All(DRAMC_REG_TX_RETRY_SET0, 1, TX_RETRY_SET0_XSR_TX_RETRY_BLOCK_ALE_MASK);
            mcDELAY_US(1);
            #if TX_RETRY_CONTROL_BY_SPM
            vIO32WriteFldAlign(DDRPHY_MD32_REG_LPIF_LOW_POWER_CFG_1, 1, LPIF_LOW_POWER_CFG_1_TX_TRACKING_RETRY_EN);
            #else //control by DRAMC
            vIO32WriteFldAlign_All(DRAMC_REG_TX_RETRY_SET0, 1, TX_RETRY_SET0_XSR_TX_RETRY_EN);
            #endif
        }
        else //DISABLE
        {
            mcSHOW_DBG_MSG("TX track retry: DISABLE! (DDR800 to DDR1200)\n");
            #if TX_RETRY_CONTROL_BY_SPM
            vIO32WriteFldAlign(DDRPHY_MD32_REG_LPIF_LOW_POWER_CFG_1, 0, LPIF_LOW_POWER_CFG_1_TX_TRACKING_RETRY_EN);
            #else //control by DRAMC
            vIO32WriteFldAlign_All(DRAMC_REG_TX_RETRY_SET0, 0, TX_RETRY_SET0_XSR_TX_RETRY_EN);
            #endif
            mcDELAY_US(1); //add 1us delay to wait emi and tx retry be done (because PPR_CTRL_TX_RETRY_SHU_RESP_OPT=1)
            vIO32WriteFldAlign_All(DRAMC_REG_TX_RETRY_SET0, 0, TX_RETRY_SET0_XSR_TX_RETRY_BLOCK_ALE_MASK); //enable block emi to let tx retry be finish
            gIsddr800TxRetry = 0;
        }
    }
}

#if SW_TX_RETRY_ENABLE
void SWTx_Track_Retry_OnOff(DRAMC_CTX_T *p)
{
    U8 u4Response;

    mcSHOW_DBG_MSG("SW TX track retry!\n");
    vIO32WriteFldAlign(DRAMC_REG_ADDR(DRAMC_REG_TX_RETRY_SET0), 0, TX_RETRY_SET0_XSR_TX_RETRY_SW_EN);
    vIO32WriteFldAlign(DRAMC_REG_ADDR(DRAMC_REG_TX_RETRY_SET0), 1, TX_RETRY_SET0_XSR_TX_RETRY_BLOCK_ALE_MASK);
    vIO32WriteFldAlign(DRAMC_REG_ADDR(DRAMC_REG_TX_RETRY_SET0), 1, TX_RETRY_SET0_XSR_TX_RETRY_SW_EN);
    do
    {
        u4Response = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_SPCMDRESP), SPCMDRESP_TX_RETRY_DONE_RESPONSE);
        mcDELAY_US(1);  // Wait tZQCAL(min) 1us or wait next polling
        mcSHOW_DBG_MSG3("still wait tx retry be done\n", u4Response);
    }while (u4Response == 0);
    vIO32WriteFldAlign(DRAMC_REG_ADDR(DRAMC_REG_TX_RETRY_SET0), 0, TX_RETRY_SET0_XSR_TX_RETRY_SW_EN);
    vIO32WriteFldAlign(DRAMC_REG_ADDR(DRAMC_REG_TX_RETRY_SET0), 0, TX_RETRY_SET0_XSR_TX_RETRY_BLOCK_ALE_MASK);
}
#endif
#endif

// The "ENABLE_RANK_NUMBER_AUTO_DETECTION" use this API
void DFSInitForCalibration(DRAMC_CTX_T *p)
{
#ifdef DUMP_INIT_RG_LOG_TO_DE
    gDUMP_INIT_RG_LOG_TO_DE_RG_log_flag = 1;
    mcSHOW_DUMP_INIT_RG_MSG("\n\n//=== DDR %d\n",p->frequency<<1);
#endif

    mcSHOW_DBG_MSG("MEM_TYPE=%d, freq_sel=%d\n", MEM_TYPE, p->freq_sel);
#if __SLT__
    DramcInit(p);
#endif
    DV_InitialSettings(p); // @Darren, Broadcast Off after SV_BroadcastOn_DramcInit done

    SA_InitialSettings1(p);

    DramcBroadcastOnOff(DRAMC_BROADCAST_ON);
    SetClkFreeRun(p,1); // Added by Lingyun.Wu 20200316
    DramcBroadcastOnOff(DRAMC_BROADCAST_OFF);

    u1PrintModeRegWrite = 1;
    if(is_ddr4_family(p))
    {
        PC4_DRAM_INIT(p);
    }
    else if (is_ddr3_family(p))
    {
        PC3_DRAM_INIT(p);
    }
    u1PrintModeRegWrite = 0;

    DramcBroadcastOnOff(DRAMC_BROADCAST_ON);
    SetClkFreeRun(p,0); // Added by Lingyun.Wu 20200316
    DramcBroadcastOnOff(DRAMC_BROADCAST_OFF);

    DV_InitialSettings_POST(p);
    SA_InitialSettings2(p);
}

#if 0 /* cc mark to use DV initial setting */
void DramcHWDQSGatingTracking_ModeSetting(DRAMC_CTX_T *p)
{
#if DDR_HW_GATING
#if DramcHWDQSGatingTracking_FIFO_MODE
    //REFUICHG=0, STB_SHIFT_DTCOUT_IG=0, DQSG_MODE=1, NARROW_IG=0
    vIO32WriteFldMulti_All(DRAMC_REG_ADDR(DDRPHY_REG_MISC_STBCAL),
        P_Fld(1, MISC_STBCAL_STB_DQIEN_IG) |
        P_Fld(1, MISC_STBCAL_PICHGBLOCK_NORD) |
        P_Fld(0, MISC_STBCAL_REFUICHG) |
        P_Fld(0, MISC_STBCAL_PHYVALID_IG) |
        P_Fld(0, MISC_STBCAL_STBSTATE_OPT) |
        P_Fld(0, MISC_STBCAL_STBDLELAST_FILTER) |
        P_Fld(0, MISC_STBCAL_STBDLELAST_PULSE) |
        P_Fld(0, MISC_STBCAL_STBDLELAST_OPT) |
        P_Fld(1, MISC_STBCAL_PIMASK_RKCHG_OPT));

    vIO32WriteFldMulti_All(DRAMC_REG_ADDR(DDRPHY_REG_MISC_STBCAL1),
        P_Fld(1, MISC_STBCAL1_STBCAL_FILTER) |
        //cc mark P_Fld(1, MISC_STBCAL1_STB_FLAGCLR) |
        P_Fld(1, MISC_STBCAL1_STB_SHIFT_DTCOUT_IG));

    vIO32WriteFldMulti_All(DRAMC_REG_ADDR(DDRPHY_REG_MISC_CTRL0),
        P_Fld(1, MISC_CTRL0_R_DMDQSIEN_FIFO_EN) |
        P_Fld(0, MISC_CTRL0_R_DMVALID_DLY) |
        P_Fld(0, MISC_CTRL0_R_DMVALID_DLY_OPT) |
        P_Fld(0, MISC_CTRL0_R_DMVALID_NARROW_IG));
        //cc mark P_Fld(0, MISC_CTRL0_R_DMDQSIEN_SYNCOPT));

    vIO32WriteFldAlign_All(DRAMC_REG_ADDR(DDRPHY_REG_B0_DQ6),
        0, B0_DQ6_RG_RX_ARDQ_DMRANK_OUTSEL_B0);
    vIO32WriteFldAlign_All(DRAMC_REG_ADDR(DDRPHY_REG_B1_DQ6),
        0, B1_DQ6_RG_RX_ARDQ_DMRANK_OUTSEL_B1);
    vIO32WriteFldAlign_All(DRAMC_REG_ADDR(DDRPHY_REG_CA_CMD6),
        0, CA_CMD6_RG_RX_ARCMD_DMRANK_OUTSEL);

#else
    //REFUICHG=0, STB_SHIFT_DTCOUT_IG=0, DQSG_MODE=1, NARROW_IG=0
    vIO32WriteFldMulti_All(DRAMC_REG_ADDR(DDRPHY_REG_MISC_STBCAL),
        P_Fld(1, MISC_STBCAL_STB_DQIEN_IG) |
        P_Fld(1, MISC_STBCAL_PICHGBLOCK_NORD) |
        P_Fld(0, MISC_STBCAL_REFUICHG) |
        P_Fld(0, MISC_STBCAL_PHYVALID_IG) |
        P_Fld(0, MISC_STBCAL_STBSTATE_OPT) |
        P_Fld(0, MISC_STBCAL_STBDLELAST_FILTER) |
        P_Fld(0, MISC_STBCAL_STBDLELAST_PULSE) |
        P_Fld(0, MISC_STBCAL_STBDLELAST_OPT) |
        P_Fld(1, MISC_STBCAL_PIMASK_RKCHG_OPT));

    vIO32WriteFldMulti_All(DRAMC_REG_ADDR(DDRPHY_REG_MISC_STBCAL1),
        P_Fld(1, MISC_STBCAL1_STBCAL_FILTER) |
        //cc mark P_Fld(1, MISC_STBCAL1_STB_FLAGCLR) |
        P_Fld(0, MISC_STBCAL1_STB_SHIFT_DTCOUT_IG));


    vIO32WriteFldMulti_All(DRAMC_REG_ADDR(DDRPHY_REG_MISC_CTRL0),
        P_Fld(0, MISC_CTRL0_R_DMDQSIEN_FIFO_EN) |
        P_Fld(3, MISC_CTRL0_R_DMVALID_DLY) |
        P_Fld(1, MISC_CTRL0_R_DMVALID_DLY_OPT) |
        P_Fld(0, MISC_CTRL0_R_DMVALID_NARROW_IG));
        //cc mark P_Fld(0xf, MISC_CTRL0_R_DMDQSIEN_SYNCOPT));

    vIO32WriteFldAlign_All(DRAMC_REG_ADDR(DDRPHY_REG_B0_DQ6),
        1, B0_DQ6_RG_RX_ARDQ_DMRANK_OUTSEL_B0);
    vIO32WriteFldAlign_All(DRAMC_REG_ADDR(DDRPHY_REG_B1_DQ6),
        1, B1_DQ6_RG_RX_ARDQ_DMRANK_OUTSEL_B1);
    vIO32WriteFldAlign_All(DRAMC_REG_ADDR(DDRPHY_REG_CA_CMD6),
        1, CA_CMD6_RG_RX_ARCMD_DMRANK_OUTSEL);
#endif
#endif
}
#endif

#if TX_PICG_NEW_MODE
#if 0
void GetTXPICGSetting(DRAMC_CTX_T * p)
{
    U32 u4DQS_OEN_final, u4DQ_OEN_final;
    U16 u2DQS_OEN_2T[2], u2DQS_OEN_05T[2], u2DQS_OEN_Delay[2];
    U16 u2DQ_OEN_2T[2], u2DQ_OEN_05T[2], u2DQ_OEN_Delay[2];
    U16 u2COMB_TX_SEL[2];
    U16 u2Shift_Div[2];
    U16 u2COMB_TX_PICG_CNT;
    U8 u1CHIdx, u1RankIdx, u1Rank_bak = u1GetRank(p), u1backup_CH = vGetPHY2ChannelMapping(p), u1Div_ratio;

    mcSHOW_DBG_MSG("****** GetTXPICGSetting DDR[%d] @@@\n", p->frequency * 2);

    for (u1CHIdx = 0; u1CHIdx < p->support_channel_num; u1CHIdx++)
    {
        vSetPHY2ChannelMapping(p, u1CHIdx);
        //Set TX DQS PICG
        //DQS0
        u2DQS_OEN_2T[0] = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_SHU_SELPH_DQS0), SHU_SELPH_DQS0_TXDLY_OEN_DQS0);//m
        u2DQS_OEN_05T[0] = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_SHU_SELPH_DQS1), SHU_SELPH_DQS1_DLY_OEN_DQS0);//n
        //DQS1
        u2DQS_OEN_2T[1] = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_SHU_SELPH_DQS0), SHU_SELPH_DQS0_TXDLY_OEN_DQS1);//m
        u2DQS_OEN_05T[1] = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_SHU_SELPH_DQS1), SHU_SELPH_DQS1_DLY_OEN_DQS1);//n

        mcSHOW_DBG_MSG("CH%d\n", u1CHIdx);
        mcSHOW_DBG_MSG("DQS0 m=%d n=%d \n", u2DQS_OEN_2T[0], u2DQS_OEN_05T[0]);
        mcSHOW_DBG_MSG("DQS1 m=%d n=%d \n", u2DQS_OEN_2T[1], u2DQS_OEN_05T[1]);



        u2COMB_TX_SEL[0] = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_SHU_APHY_TX_PICG_CTRL), SHU_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_DQS_SEL_P0);
        u2COMB_TX_SEL[1] = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_SHU_APHY_TX_PICG_CTRL), SHU_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_DQS_SEL_P1);
        u2COMB_TX_PICG_CNT = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_SHU_APHY_TX_PICG_CTRL), SHU_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_PICG_CNT);

        mcSHOW_DBG_MSG("TX_DQS_SEL_P0 %d \n", u2COMB_TX_SEL[0]);
        mcSHOW_DBG_MSG("TX_DQS_SEL_P1 %d \n", u2COMB_TX_SEL[1]);
        mcSHOW_DBG_MSG("COMB_TX_PICG_CNT %d \n", u2COMB_TX_PICG_CNT);

        //Set TX RK0 and RK1 DQ PICG
        for (u1RankIdx = RANK_0; u1RankIdx < p->support_rank_num; u1RankIdx++)
        {
            mcSHOW_DBG_MSG("Rank%d\n", u1RankIdx);

            vSetRank(p, u1RankIdx);
            //DQ0
            u2DQ_OEN_2T[0] = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_SHURK_SELPH_DQ0), SHURK_SELPH_DQ0_TXDLY_OEN_DQ0);//p
            u2DQ_OEN_05T[0] = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_SHURK_SELPH_DQ2), SHURK_SELPH_DQ2_DLY_OEN_DQ0);//q
            //DQ1
            u2DQ_OEN_2T[1] = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_SHURK_SELPH_DQ0), SHURK_SELPH_DQ0_TXDLY_OEN_DQ1);//p
            u2DQ_OEN_05T[1] = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_SHURK_SELPH_DQ2), SHURK_SELPH_DQ2_DLY_OEN_DQ1);//q

            mcSHOW_DBG_MSG("DQ0 p=%d q=%d \n", u2DQ_OEN_2T[0], u2DQ_OEN_05T[0]);
            mcSHOW_DBG_MSG("DQ1 p=%d q=%d \n", u2DQ_OEN_2T[1], u2DQ_OEN_05T[1]);

            u2COMB_TX_SEL[0] = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_SHURK_APHY_TX_PICG_CTRL), SHURK_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_DQ_RK_SEL_P0);
            u2COMB_TX_SEL[1] = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_SHURK_APHY_TX_PICG_CTRL), SHURK_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_DQ_RK_SEL_P1);

            mcSHOW_DBG_MSG("TX_DQ_RK_SEL_P0 %d \n", u2COMB_TX_SEL[0]);
            mcSHOW_DBG_MSG("TX_DQ_RK_SEL_P1 %d \n", u2COMB_TX_SEL[1]);
        }
        vSetRank(p, u1Rank_bak);
    }
    vSetPHY2ChannelMapping(p, u1backup_CH);
}
#endif

#define ADD_1UI_TO_APHY 1 //After A60-868/Pe-trus
void TXPICGSetting(DRAMC_CTX_T * p)
{
    U32 u4DQS_OEN_final, u4DQ_OEN_final;
    U16 u2DQS_OEN_2T[2], u2DQS_OEN_05T[2], u2DQS_OEN_Delay[2];
    U16 u2DQ_OEN_2T[2], u2DQ_OEN_05T[2], u2DQ_OEN_Delay[2];
    U16 u2COMB_TX_SEL[2];
    U16 u2Shift_DQS_Div[2];
    U16 u2Shift_DQ_Div[2];
    U16 u2COMB_TX_PICG_CNT;
    U8 u1CHIdx, u1RankIdx, u1Rank_bak = u1GetRank(p), u1backup_CH = vGetPHY2ChannelMapping(p), u1Div_ratio;

    if (vGet_Div_Mode(p) == DIV8_MODE)
    {
        u2Shift_DQS_Div[0] = 10;//phase 0
        u2Shift_DQS_Div[1] = 6;//phase 1
        u2Shift_DQ_Div[0] = 8;//phase 0
        u2Shift_DQ_Div[1] = 4;//phase 1
        u1Div_ratio = 3;
        u2COMB_TX_PICG_CNT = 2;
    }
    else //DIV4_MODE
    {
        u2Shift_DQS_Div[0] = 2;//phase 0
        u2Shift_DQS_Div[1] = 0;//phase 1, no use
        u2Shift_DQ_Div[0] = 0;//phase 0
        u2Shift_DQ_Div[1] = 0;//phase 1, no use
        u1Div_ratio = 2;
        u2COMB_TX_PICG_CNT = 3;
    }

    for (u1CHIdx = 0; u1CHIdx < p->support_channel_num; u1CHIdx++)
    {
        vSetPHY2ChannelMapping(p, u1CHIdx);
        //Set TX DQS PICG
        //DQS0
        u2DQS_OEN_2T[0] = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_SHURK_SELPH_DQS0), SHURK_SELPH_DQS0_TXDLY_OEN_DQS0);//m
        u2DQS_OEN_05T[0] = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_SHURK_SELPH_DQS1), SHURK_SELPH_DQS1_DLY_OEN_DQS0);//n
        u2DQS_OEN_Delay[0] = (u2DQS_OEN_2T[0] << u1Div_ratio) + u2DQS_OEN_05T[0];
        //DQS1
        u2DQS_OEN_2T[1] = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_SHURK_SELPH_DQS0), SHURK_SELPH_DQS0_TXDLY_OEN_DQS1);//m
        u2DQS_OEN_05T[1] = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_SHURK_SELPH_DQS1), SHURK_SELPH_DQS1_DLY_OEN_DQS1);//n
        u2DQS_OEN_Delay[1] = (u2DQS_OEN_2T[1] << u1Div_ratio) + u2DQS_OEN_05T[1];

        u4DQS_OEN_final = (u2DQS_OEN_Delay[0] > u2DQS_OEN_Delay[1])? u2DQS_OEN_Delay[1]: u2DQS_OEN_Delay[0]; //choose minimum value
        u4DQS_OEN_final += ADD_1UI_TO_APHY;


        u2COMB_TX_SEL[0] = (u4DQS_OEN_final > u2Shift_DQS_Div[0])? ((u4DQS_OEN_final - u2Shift_DQS_Div[0]) >> u1Div_ratio): 0;

        if (vGet_Div_Mode(p) == DIV4_MODE)
            u2COMB_TX_SEL[1] = 0;
        else
            u2COMB_TX_SEL[1] = (u4DQS_OEN_final > u2Shift_DQS_Div[1])? ((u4DQS_OEN_final - u2Shift_DQS_Div[1]) >> u1Div_ratio): 0;

        vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_APHY_TX_PICG_CTRL), P_Fld(u2COMB_TX_SEL[0], SHU_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_DQS_SEL_P0)
                                             | P_Fld(u2COMB_TX_SEL[1], SHU_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_DQS_SEL_P1)
                                             | P_Fld(u2COMB_TX_PICG_CNT, SHU_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_PICG_CNT));
        //Set TX RK0 and RK1 DQ PICG
        for (u1RankIdx = RANK_0; u1RankIdx < p->support_rank_num; u1RankIdx++)
        {
            vSetRank(p, u1RankIdx);
            //DQ0
            u2DQ_OEN_2T[0] = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_SHURK_SELPH_DQ0), SHURK_SELPH_DQ0_TXDLY_OEN_DQ0);
            u2DQ_OEN_05T[0] = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_SHURK_SELPH_DQ2), SHURK_SELPH_DQ2_DLY_OEN_DQ0);
            u2DQ_OEN_Delay[0] = (u2DQ_OEN_2T[0] << u1Div_ratio) + u2DQ_OEN_05T[0];
            //DQ1
            u2DQ_OEN_2T[1] = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_SHURK_SELPH_DQ0), SHURK_SELPH_DQ0_TXDLY_OEN_DQ1);
            u2DQ_OEN_05T[1] = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_SHURK_SELPH_DQ2), SHURK_SELPH_DQ2_DLY_OEN_DQ1);
            u2DQ_OEN_Delay[1] = (u2DQ_OEN_2T[1] << u1Div_ratio) + u2DQ_OEN_05T[1];


            u4DQ_OEN_final = (u2DQ_OEN_Delay[0] > u2DQ_OEN_Delay[1])? u2DQ_OEN_Delay[1]: u2DQ_OEN_Delay[0]; //choose minimum value
            u4DQ_OEN_final += ADD_1UI_TO_APHY;

            u2COMB_TX_SEL[0] = (u4DQ_OEN_final > u2Shift_DQ_Div[0])? ((u4DQ_OEN_final - u2Shift_DQ_Div[0]) >> u1Div_ratio): 0;

            if (vGet_Div_Mode(p) == DIV4_MODE)
               u2COMB_TX_SEL[1] = 0;
            else
               u2COMB_TX_SEL[1] = (u4DQ_OEN_final > u2Shift_DQ_Div[1])? ((u4DQ_OEN_final - u2Shift_DQ_Div[1]) >> u1Div_ratio): 0;

               vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHURK_APHY_TX_PICG_CTRL), P_Fld(u2COMB_TX_SEL[0], SHURK_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_DQ_RK_SEL_P0)
                                                 | P_Fld(u2COMB_TX_SEL[1], SHURK_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_DQ_RK_SEL_P1));
        }
        vSetRank(p, u1Rank_bak);
    }
    vSetPHY2ChannelMapping(p, u1backup_CH);
}
#endif


#if RX_PICG_NEW_MODE
void RXPICGSetting(DRAMC_CTX_T * p)
{
    DRAM_RANK_T bkRank = u1GetRank(p);
    U8 u1RankIdx = 0;

    vIO32WriteFldAlign(DDRPHY_REG_MISC_SHU_STBCAL, 0, MISC_SHU_STBCAL_STBCALEN);
    vIO32WriteFldAlign(DDRPHY_REG_MISC_SHU_STBCAL, 0, MISC_SHU_STBCAL_STB_SELPHCALEN);

    //PI_CG_DQSIEN new mode
    vIO32WriteFldAlign(DDRPHY_REG_MISC_STBCAL1, 1, MISC_STBCAL1_STBCNT_SHU_RST_EN);
	vIO32WriteFldAlign(DDRPHY_REG_MISC_STBCAL2, 1, MISC_STBCAL2_DQSIEN_SELPH_BY_RANK_EN);
    vIO32WriteFldAlign(DDRPHY_REG_MISC_SHU_STBCAL, 1, MISC_SHU_STBCAL_DQSIEN_PICG_MODE);

	//APHY control new mode
    vIO32WriteFldAlign(DDRPHY_REG_MISC_RX_IN_GATE_EN_CTRL, 1, MISC_RX_IN_GATE_EN_CTRL_RX_IN_GATE_EN_OPT);
	vIO32WriteFldAlign(DDRPHY_REG_MISC_RX_IN_BUFF_EN_CTRL, 1, MISC_RX_IN_BUFF_EN_CTRL_RX_IN_BUFF_EN_OPT);

    //Dummy code (based on DVT document Verification plan of RX PICG efficiency improvment.docx)
    //No need to set since HW setting or setting in other place
    //Pls. don't remove for the integrity
    {
        U8 u1TAIL_LAT = (vGet_Div_Mode(p) == DIV4_MODE) ? 1: 0;
        vIO32WriteFldAlign(DDRPHY_REG_MISC_STBCAL2, 0, MISC_STBCAL2_STB_STBENRST_EARLY_1T_EN);

        for (u1RankIdx = 0; u1RankIdx < p->support_rank_num; u1RankIdx++)//Should set 2 rank
        {
            vSetRank(p, u1RankIdx);
            vIO32WriteFldMulti(DDRPHY_REG_MISC_SHU_RK_DQSIEN_PICG_CTRL, P_Fld(u1TAIL_LAT, MISC_SHU_RK_DQSIEN_PICG_CTRL_DQSIEN_PICG_TAIL_EXT_LAT)
                    | P_Fld(0, MISC_SHU_RK_DQSIEN_PICG_CTRL_DQSIEN_PICG_HEAD_EXT_LAT));
        }
        vSetRank(p, bkRank);

        vIO32WriteFldMulti(DDRPHY_REG_MISC_RX_IN_BUFF_EN_CTRL, P_Fld(0, MISC_RX_IN_BUFF_EN_CTRL_DIS_IN_BUFF_EN)
                    | P_Fld(0, MISC_RX_IN_BUFF_EN_CTRL_FIX_IN_BUFF_EN)
                    | P_Fld(0, MISC_RX_IN_BUFF_EN_CTRL_RX_IN_BUFF_EN_4BYTE_EN));

        vIO32WriteFldMulti(DDRPHY_REG_MISC_RX_IN_GATE_EN_CTRL, P_Fld(0, MISC_RX_IN_GATE_EN_CTRL_DIS_IN_GATE_EN)
                    | P_Fld(0, MISC_RX_IN_GATE_EN_CTRL_FIX_IN_GATE_EN)
                    | P_Fld(0, MISC_RX_IN_GATE_EN_CTRL_RX_IN_GATE_EN_4BYTE_EN));

    }
#if 0
        vIO32WriteFldAlign(DRAMC_REG_STBCAL2, 0, STBCAL2_STB_STBENRST_EARLY_1T_EN);
        vIO32WriteFldMulti(DRAMC_REG_SHU_STBCAL, P_Fld(u1TAIL_LAT, SHU_STBCAL_R1_DQSIEN_PICG_TAIL_EXT_LAT)
                    | P_Fld(0, SHU_STBCAL_R1_DQSIEN_PICG_HEAD_EXT_LAT)
                    | P_Fld(u1TAIL_LAT, SHU_STBCAL_R0_DQSIEN_PICG_TAIL_EXT_LAT)
                    | P_Fld(0, SHU_STBCAL_R0_DQSIEN_PICG_HEAD_EXT_LAT));
        vIO32WriteFldMulti(DRAMC_REG_PHY_RX_INCTL, P_Fld(0, PHY_RX_INCTL_DIS_IN_BUFF_EN)
                    | P_Fld(0, PHY_RX_INCTL_FIX_IN_BUFF_EN)
                    | P_Fld(0, PHY_RX_INCTL_RX_IN_BUFF_EN_4BYTE_EN)
                    | P_Fld(0, PHY_RX_INCTL_DIS_IN_GATE_EN)
                    | P_Fld(0, PHY_RX_INCTL_FIX_IN_GATE_EN)
                    | P_Fld(0, PHY_RX_INCTL_RX_IN_GATE_EN_4BYTE_EN));
#endif
}
#endif

#ifndef DPM_CONTROL_AFTERK
void dramc_exit_with_DFS_legacy_mode(DRAMC_CTX_T * p)
{
#if !__ETT__
    //set for SPM DRAM self refresh
    vIO32WriteFldAlign(SPM_POWERON_CONFIG_EN, 1, POWERON_CONFIG_EN_BCLK_CG_EN);
    vIO32WriteFldAlign(SPM_DRAMC_DPY_CLK_SW_CON_2, 1, SPM_DRAMC_DPY_CLK_SW_CON_2_SW_PHYPLL_MODE_SW);
    vIO32WriteFldAlign(SPM_POWER_ON_VAL0, 1, SPM_POWER_ON_VAL0_SC_PHYPLL_MODE_SW);
#endif
    //Preloader exit with legacy mode for CTP load used
    vIO32WriteFldAlign_All(DDRPHY_REG_MISC_RG_DFS_CTRL, 0x0, MISC_RG_DFS_CTRL_SPM_DVFS_CONTROL_SEL);
    vIO32WriteFldAlign_All(DDRPHY_REG_PHYPLL0, 0x0, PHYPLL0_RG_RPHYPLL_EN);
    vIO32WriteFldAlign_All(DDRPHY_REG_CLRPLL0, 0x0, CLRPLL0_RG_RCLRPLL_EN);
}
#endif

#if TX_PICG_NEW_MODE
void TXPICGNewModeEnable(DRAMC_CTX_T * p)
{
    //Switch TX PICG to new mode
    vIO32WriteFldMulti_All(DDRPHY_REG_MISC_CTRL3, P_Fld(0, MISC_CTRL3_ARPI_CG_MCK_DQ_OPT)
                                         | P_Fld(0, MISC_CTRL3_ARPI_MPDIV_CG_DQ_OPT)
                                         | P_Fld(0, MISC_CTRL3_ARPI_CG_DQS_OPT)
                                         | P_Fld(0, MISC_CTRL3_ARPI_CG_DQ_OPT));
}
#endif


#if DDR_ENABLE_WRITE_DBI
void ApplyWriteDBIProtect(DRAMC_CTX_T *p, U8 onoff)
{
#if __A60868_TO_BE_PORTING__
    U8 *uiLPDDR_O1_Mapping;
    U16 Temp_PinMux_MaskWrite_WriteDBIOn = 0;
    U8 B0_PinMux_MaskWrite_WriteDBIOn = 0, B1_PinMux_MaskWrite_WriteDBIOn = 0;
    int DQ_index;

    uiLPDDR_O1_Mapping = (U8 *)uiLPDDR4_O1_Mapping_POP[p->channel];

    // Write DMI/DBI Protect Function
    // Byte0 can not have bit swap between Group1(DQ0/1) and Group2(DQ02~DQ07).
    // Byte1 can not have bit swap between Group1(DQ8/9) and Group2(DQ10~DQ15).
    // DBIWR_IMP_EN=1 and DBIWR_PINMUX_EN=1
    // set DBIWR_OPTB0[7:0] meet with Byte0 pin MUX table.
    // set DBIWR_OPTB1[7:0] meet with Byte1 pin MUX table.

    for (DQ_index = 0; DQ_index < 16; DQ_index++)
    {
        Temp_PinMux_MaskWrite_WriteDBIOn |= ((0x7C7C >> uiLPDDR_O1_Mapping[DQ_index]) & 0x1) << DQ_index;
    }
    B1_PinMux_MaskWrite_WriteDBIOn = (U8)(Temp_PinMux_MaskWrite_WriteDBIOn >> 8) & 0xff;
    B0_PinMux_MaskWrite_WriteDBIOn = (U8) Temp_PinMux_MaskWrite_WriteDBIOn & 0xff;

    vIO32WriteFldMulti_All(DRAMC_REG_ARBCTL, P_Fld(B1_PinMux_MaskWrite_WriteDBIOn, ARBCTL_DBIWR_OPT_B1)
                                           | P_Fld(B0_PinMux_MaskWrite_WriteDBIOn, ARBCTL_DBIWR_OPT_B0)
                                           | P_Fld(onoff, ARBCTL_DBIWR_PINMUX_EN)
                                           | P_Fld(onoff, ARBCTL_DBIWR_IMP_EN));
#endif
}

void ApplyWriteDBIPowerImprove(DRAMC_CTX_T *p, U8 onoff)
{

    // set DBIWR_IMP_EN = 1
    // DBIWR_OPTB0[1:0]=0, DBIWR_OPT_B0[7]=0
    // DBIWR_OPTB1[1:0]=0, DBIWR_OPT_B1[7]=0
    vIO32WriteFldMulti_All(DRAMC_REG_DBIWR_PROTECT, P_Fld(0, DBIWR_PROTECT_DBIWR_OPT_B1)
                                       | P_Fld(0, DBIWR_PROTECT_DBIWR_OPT_B0)
                                       | P_Fld(0, DBIWR_PROTECT_DBIWR_PINMUX_EN)
                                       | P_Fld(onoff, DBIWR_PROTECT_DBIWR_IMP_EN));
}
/* DDR800 mode struct declaration (declared here due Fld_wid for each register type) */
/*
typedef struct _DDR800Mode_T
{
    U8 dll_phdet_en_b0: Fld_wid(SHU_B0_DLL0_RG_ARDLL_PHDET_EN_B0_SHU);
    U8 dll_phdet_en_b1: Fld_wid(SHU_B1_DLL0_RG_ARDLL_PHDET_EN_B1_SHU);
    U8 dll_phdet_en_ca_cha: Fld_wid(SHU_CA_DLL0_RG_ARDLL_PHDET_EN_CA_SHU);
    U8 dll_phdet_en_ca_chb: Fld_wid(SHU_CA_DLL0_RG_ARDLL_PHDET_EN_CA_SHU);
    U8 phypll_ada_mck8x_en: Fld_wid(SHU_PLL22_RG_RPHYPLL_ADA_MCK8X_EN_SHU);
    U8 ddr400_en_b0: Fld_wid(SHU_B0_DQ6_RG_ARPI_DDR400_EN_B0);
    U8 ddr400_en_b1: Fld_wid(SHU_B1_DQ6_RG_ARPI_DDR400_EN_B1);
    U8 ddr400_en_ca: Fld_wid(SHU_CA_CMD6_RG_ARPI_DDR400_EN_CA);
    U8 phypll_ddr400_en: Fld_wid(SHU_PLL1_RG_RPHYPLL_DDR400_EN);
    U8 ddr400_dqs_ps_b0: Fld_wid(SHU_B0_DQ9_RG_DDR400_DQS_PS_B0);
    U8 ddr400_dqs_ps_b1: Fld_wid(SHU_B1_DQ9_RG_DDR400_DQS_PS_B1);
    U8 ddr400_dq_ps_b0: Fld_wid(SHU_B0_DQ9_RG_DDR400_DQ_PS_B0);
    U8 ddr400_dq_ps_b1: Fld_wid(SHU_B1_DQ9_RG_DDR400_DQ_PS_B1);
    U8 ddr400_dqs_ps_ca: Fld_wid(SHU_CA_CMD9_RG_DDR400_DQS_PS_CA);
    U8 ddr400_dq_ps_ca: Fld_wid(SHU_CA_CMD9_RG_DDR400_DQ_PS_CA);
    U8 ddr400_semi_en_b0: Fld_wid(SHU_B0_DQ9_RG_DDR400_SEMI_EN_B0);
    U8 ddr400_semi_en_b1: Fld_wid(SHU_B1_DQ9_RG_DDR400_SEMI_EN_B1);
    U8 ddr400_semi_en_ca: Fld_wid(SHU_CA_CMD9_RG_DDR400_SEMI_EN_CA);
    U8 ddr400_semi_open_en: Fld_wid(SHU_PLL0_RG_DDR400_SEMI_OPEN_EN);
    U8 pll0_ada_mck8x_chb_en: Fld_wid(SHU_PLL0_ADA_MCK8X_CHB_EN);
    U8 pll0_ada_mck8x_cha_en: Fld_wid(SHU_PLL0_ADA_MCK8X_CHA_EN);
} DDR800Mode_T;
*/
#endif


void RODTSettings(DRAMC_CTX_T *p)
{
    U8 u1VrefSel;
    U8 u1RankIdx, u1RankIdxBak;

    vIO32WriteFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_SHU_B0_VREF), !p->odt_onoff, SHU_B0_VREF_RG_RX_ARDQ_VREF_UNTERM_EN_B0);
    vIO32WriteFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_SHU_B1_VREF), !p->odt_onoff, SHU_B1_VREF_RG_RX_ARDQ_VREF_UNTERM_EN_B1);

    //VREF_EN
    vIO32WriteFldAlign(DDRPHY_REG_B0_DQ5, 1, B0_DQ5_RG_RX_ARDQ_VREF_EN_B0);
    vIO32WriteFldAlign(DDRPHY_REG_B1_DQ5, 1, B1_DQ5_RG_RX_ARDQ_VREF_EN_B1);

    if (is_ddr4_family(p)) {
        if (p->odt_onoff==ODT_ON)
            u1VrefSel = 0x16;
        else
            u1VrefSel = 0xe;
    } else {
        u1VrefSel = 0xe;
    }

    u1RankIdxBak = u1GetRank(p);
    for (u1RankIdx = 0; u1RankIdx < (U32)(p->support_rank_num); u1RankIdx++)
    {
        vSetRank(p, u1RankIdx);
        vIO32WriteFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_SHU_B0_DQ5), u1VrefSel, SHU_B0_DQ5_RG_RX_ARDQ_VREF_SEL_B0);
        vIO32WriteFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_SHU_B1_DQ5), u1VrefSel, SHU_B1_DQ5_RG_RX_ARDQ_VREF_SEL_B1);
    }
    vSetRank(p, u1RankIdxBak);

#if DDR_ENABLE_TX_WDQS
    vIO32WriteFldAlign(DDRPHY_REG_MISC_SHU_ODTCTRL, 1, MISC_SHU_ODTCTRL_RODTEN);
    vIO32WriteFldAlign(DDRPHY_REG_SHU_B0_DQ7, 1, SHU_B0_DQ7_R_DMRODTEN_B0);
    vIO32WriteFldAlign(DDRPHY_REG_SHU_B1_DQ7, 1, SHU_B1_DQ7_R_DMRODTEN_B1);
    vIO32WriteFldAlign(DDRPHY_REG_SHU_B2_DQ7, 1, SHU_B2_DQ7_R_DMRODTEN_B2);
#else
    vIO32WriteFldAlign(DDRPHY_REG_MISC_SHU_ODTCTRL, p->odt_onoff, MISC_SHU_ODTCTRL_RODTEN);
    vIO32WriteFldAlign(DDRPHY_REG_SHU_B0_DQ7, p->odt_onoff, SHU_B0_DQ7_R_DMRODTEN_B0);
    vIO32WriteFldAlign(DDRPHY_REG_SHU_B1_DQ7, p->odt_onoff, SHU_B1_DQ7_R_DMRODTEN_B1);
    vIO32WriteFldAlign(DDRPHY_REG_SHU_B2_DQ7, p->odt_onoff, SHU_B2_DQ7_R_DMRODTEN_B2);
#endif

#if DDR_ENABLE_RODT_TRACKING
    //RODT tracking
    vIO32WriteFldMulti(DDRPHY_REG_MISC_SHU_RODTENSTB,
        P_Fld(1, MISC_SHU_RODTENSTB_RODTENSTB_TRACK_EN) |
        P_Fld(1, MISC_SHU_RODTENSTB_RODTENSTB_TRACK_UDFLWCTRL) |
        P_Fld(0, MISC_SHU_RODTENSTB_RODTENSTB_SELPH_BY_BITTIME));
#endif

    //Darren-vIO32WriteFldAlign(DDRPHY_REG_B0_DQ6, !(p->odt_onoff), B0_DQ6_RG_TX_ARDQ_ODTEN_EXT_DIS_B0);
    //Darren-vIO32WriteFldAlign(DDRPHY_REG_B1_DQ6, !(p->odt_onoff), B1_DQ6_RG_TX_ARDQ_ODTEN_EXT_DIS_B1);
    //Darren-vIO32WriteFldAlign(DDRPHY_REG_CA_CMD6, !(p->odt_onoff), CA_CMD6_RG_TX_ARCMD_ODTEN_EXT_DIS);
    vIO32WriteFldAlign(DDRPHY_REG_SHU_B0_DQ13, !(p->odt_onoff), SHU_B0_DQ13_RG_TX_ARDQ_IO_ODT_DIS_B0);
    vIO32WriteFldAlign(DDRPHY_REG_SHU_B1_DQ13, !(p->odt_onoff), SHU_B1_DQ13_RG_TX_ARDQ_IO_ODT_DIS_B1);
    vIO32WriteFldAlign(DDRPHY_REG_SHU_CA_CMD13, !(p->odt_onoff), SHU_CA_CMD13_RG_TX_ARCA_IO_ODT_DIS_CA);

    //APHY CG disable
    vIO32WriteFldMulti(DDRPHY_REG_SHU_B0_DQ13, P_Fld(0, SHU_B0_DQ13_RG_TX_ARDQS_OE_ODTEN_CG_EN_B0)
                                            | P_Fld(0, SHU_B0_DQ13_RG_TX_ARDQM_OE_ODTEN_CG_EN_B0));
    vIO32WriteFldAlign(DDRPHY_REG_SHU_B0_DQ14, 0, SHU_B0_DQ14_RG_TX_ARDQ_OE_ODTEN_CG_EN_B0);

    vIO32WriteFldMulti(DDRPHY_REG_SHU_B1_DQ13, P_Fld(0, SHU_B1_DQ13_RG_TX_ARDQS_OE_ODTEN_CG_EN_B1)
                                            | P_Fld(0, SHU_B1_DQ13_RG_TX_ARDQM_OE_ODTEN_CG_EN_B1));
    vIO32WriteFldAlign(DDRPHY_REG_SHU_B1_DQ14, 0, SHU_B1_DQ14_RG_TX_ARDQ_OE_ODTEN_CG_EN_B1);
}

/* LP4 use 7UI mode (1)
 * LP5 lower than 4266 use 7UI mode (1)
 * LP5 higher than 4266 use 11UI mode (2)
 * LP5 higher than 4266 with better SI use 11/24UI mode (3)
 */
void DQSSTBSettings(DRAMC_CTX_T *p)
{
	unsigned int dqsien_mode = 1;

	if (is_ddr4_family(p))
		dqsien_mode = 0x1; /* Burst mode, similar as LP4 */
	else
		dqsien_mode = 0x0; /* Pulse mode */

	vIO32WriteFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_MISC_SHU_STBCAL),
		dqsien_mode, MISC_SHU_STBCAL_DQSIEN_DQSSTB_MODE);
	vIO32WriteFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_SHU_B0_DQ10),
		dqsien_mode, SHU_B0_DQ10_RG_RX_ARDQS_DQSIEN_MODE_B0);
	vIO32WriteFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_SHU_B1_DQ10),
		dqsien_mode, SHU_B1_DQ10_RG_RX_ARDQS_DQSIEN_MODE_B1);
	vIO32WriteFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_SHU_B2_DQ10),
		dqsien_mode, SHU_B2_DQ10_RG_RX_ARDQS_DQSIEN_MODE_B2);
}

void SetMck8xLowPwrOption(DRAMC_CTX_T *p)
{
#if ENABLE_REMOVE_MCK8X_UNCERT_LOWPOWER_OPTION
    U32 u4Mck8xMode = 1;
#else
    U32 u4Mck8xMode = 0;
#endif

    vIO32WriteFldMulti(DDRPHY_REG_MISC_LP_CTRL,  P_Fld( u4Mck8xMode , MISC_LP_CTRL_RG_SC_ARPI_RESETB_8X_SEQ_LP_SEL ) \
                                                              | P_Fld( u4Mck8xMode , MISC_LP_CTRL_RG_ADA_MCK8X_8X_SEQ_LP_SEL      ) \
                                                              | P_Fld( u4Mck8xMode, MISC_LP_CTRL_RG_AD_MCK8X_8X_SEQ_LP_SEL       ) \
                                                              | P_Fld( u4Mck8xMode , MISC_LP_CTRL_RG_MIDPI_EN_8X_SEQ_LP_SEL       ) \
                                                              | P_Fld( u4Mck8xMode , MISC_LP_CTRL_RG_MIDPI_CKDIV4_EN_8X_SEQ_LP_SEL) \
                                                              | P_Fld( u4Mck8xMode, MISC_LP_CTRL_RG_MCK8X_CG_SRC_LP_SEL          ) \
                                                              | P_Fld( u4Mck8xMode , MISC_LP_CTRL_RG_MCK8X_CG_SRC_AND_LP_SEL      ));

}

void PC3_UpdateInitialSettings(DRAMC_CTX_T *p)
{
//    U8 u1RankIdx, u1RankIdxBak;
    ///TODO:
    //BRINGUP-TEST
    vIO32WriteFldAlign(DDRPHY_REG_MISC_CTRL3, 0, MISC_CTRL3_ARPI_CG_CLK_OPT);
    vIO32WriteFldAlign(DDRPHY_REG_MISC_CTRL4, 0, MISC_CTRL4_R_OPT2_CG_CLK);

    //vIO32WriteFldMulti_All(DDRPHY_REG_CA_CMD2, P_Fld(1, CA_CMD2_RG_TX_ARCLK_OE_TIE_EN_CA) | P_Fld(0, CA_CMD2_RG_TX_ARCLK_OE_TIE_SEL_CA));
    //vIO32WriteFldMulti_All(DDRPHY_REG_CA_CMD2, P_Fld(1, CA_CMD2_RG_TX_ARCLKB_OE_TIE_EN_CA) | P_Fld(0, CA_CMD2_RG_TX_ARCLKB_OE_TIE_SEL_CA));
    //Set_MRR_Pinmux_Mapping(p); //Update MRR pinmux

    vReplaceDVInit(p);

    //Let CA and CS be independent
    vIO32WriteFldAlign(DDRPHY_REG_SHU_CA_CMD14, 0x50, SHU_CA_CMD14_RG_TX_ARCA_MCKIO_SEL_CA); //@yr: IPMv2 setting from Kaihsin/Lin-Yi
    //Disable perbyte option
    vIO32WriteFldMulti(DDRPHY_REG_SHU_B0_DQ7, P_Fld(0x0, SHU_B0_DQ7_R_DMRXDVS_PBYTE_DQM_EN_B0)
                                            | P_Fld(0x0, SHU_B0_DQ7_R_DMRXDVS_PBYTE_FLAG_OPT_B0)
                                            | P_Fld(0x0, SHU_B0_DQ7_R_DMRXDVS_DQM_FLAGSEL_B0));
    vIO32WriteFldMulti(DDRPHY_REG_SHU_B1_DQ7, P_Fld(0x0, SHU_B1_DQ7_R_DMRXDVS_PBYTE_DQM_EN_B1)
                                            | P_Fld(0x0, SHU_B1_DQ7_R_DMRXDVS_PBYTE_FLAG_OPT_B1)
                                            | P_Fld(0x0, SHU_B1_DQ7_R_DMRXDVS_DQM_FLAGSEL_B1));

#if RX_PICG_NEW_MODE
    RXPICGSetting(p);
#endif

#if DDR_ENABLE_SW_IMPED_CAL // Darren: Need porting by E2 IMP Calib DVT owner
#if FOR_DV_SIMULATION_USED
    if (SASimCtlGlobal.sim_sw_imp)
#endif
    {
        DramcSwImpedanceSaveRegister(p);
    }
#endif

	DQSSTBSettings(p);

    RODTSettings(p);

    //WDBI-OFF
    vIO32WriteFldAlign(DRAMC_REG_SHU_TX_SET0, 0x0, SHU_TX_SET0_DBIWR);

#if ENABLE_TPBR2PBR_REFRESH_TIMING
    vIO32WriteFldAlign(DRAMC_REG_REFCTRL1, 0x1, REFCTRL1_REF_OVERHEAD_PBR2PB_ENA); //@Derping
    vIO32WriteFldAlign(DRAMC_REG_MISCTL0, 0x1, MISCTL0_REFP_ARBMASK_PBR2PBR_ENA); //@Unique
    vIO32WriteFldAlign(DRAMC_REG_SCHEDULER_COM, 0x0, SCHEDULER_COM_PBR2PBR_OPT); //@YH
#endif

#if DDR_RDSEL_TRACKING_EN
    vIO32WriteFldAlign(DDRPHY_REG_SHU_MISC_RDSEL_TRACK, 0, SHU_MISC_RDSEL_TRACK_DMDATLAT_I); //DMDATLAT_I should be set as 0 before set datlat k value, otherwise the status flag wil be set as 1
#endif

#if ENABLE_WRITE_POST_AMBLE_1_POINT_5_TCK
    vIO32WriteFldAlign(DRAMC_REG_SHU_TX_SET0, p->dram_fsp, SHU_TX_SET0_WPST1P5T); //Set write post-amble by FSP with MR3
#else
    vIO32WriteFldAlign(DRAMC_REG_SHU_TX_SET0, 0x0, SHU_TX_SET0_WPST1P5T); //Set write post-amble by FSP with MR3
#endif

#if (!XRTRTR_NEW_CROSS_RK_MODE)
    vIO32WriteFldAlign(DDRPHY_REG_SHU_MISC_RANK_SEL_STB, 0x0, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_EN);
#endif

    //MP Setting
    vIO32WriteFldMulti(DRAMC_REG_DUMMY_RD, P_Fld(0x1, DUMMY_RD_DMYRD_REORDER_DIS) | P_Fld(0x0, DUMMY_RD_SREF_DMYRD_EN));
    vIO32WriteFldMulti(DRAMC_REG_DRAMCTRL, P_Fld(0x0, DRAMCTRL_ALL_BLOCK_CTO_ALE_DBG_EN) | P_Fld(0x1, DRAMCTRL_SELFREF_BLOCK_CTO_ALE_DBG_EN));
    vIO32WriteFldAlign(DDRPHY_REG_MISC_STBCAL2, 1, MISC_STBCAL2_DQSGCNT_BYP_REF);
    vIO32WriteFldMulti(DDRPHY_REG_MISC_CG_CTRL7,
            P_Fld(0x0, MISC_CG_CTRL7_CK_BFE_DCM_EN) |
            P_Fld(0x1, MISC_CG_CTRL7_ARMCTL_CK_OUT_CG_SEL));

    //1:8 --> data rate<=1600 set 0,  data rate<=3200 set 1, else 2
    //1:4 --> data rate<= 800 set 0,  data rate<=1600 set 1, else 2
    vIO32WriteFldMulti(DDRPHY_REG_MISC_SHU_PHY_RX_CTRL,
            P_Fld(0x2, MISC_SHU_PHY_RX_CTRL_RX_IN_BUFF_EN_HEAD) |
            P_Fld(0x1, MISC_SHU_PHY_RX_CTRL_RX_IN_GATE_EN_TAIL) |
            P_Fld(0x1, MISC_SHU_PHY_RX_CTRL_RX_IN_GATE_EN_HEAD) |
            P_Fld(0x2, MISC_SHU_PHY_RX_CTRL_RX_IN_GATE_EN_PRE_OFFSET));

    vIO32WriteFldAlign(DDRPHY_REG_MISC_SHU_CTRL0, 1, MISC_SHU_CTRL0_R_DMARPIDQ_SW); // @Darren, Fix DQ/DQM duty PI not work.

    SetMck8xLowPwrOption(p);
}


void PC4_UpdateInitialSettings(DRAMC_CTX_T *p)
{
//    U8 u1RankIdx, u1RankIdxBak;

    vIO32WriteFldAlign(DDRPHY_REG_SHU_CA_CMD14, 0x0, SHU_CA_CMD14_RG_TX_ARCA_MCKIO_SEL_CA); //Let CA and CS be independent
    //Set_MRR_Pinmux_Mapping(p); //Update MRR pinmux

    vReplaceDVInit(p);

    //Disable perbyte option
    vIO32WriteFldMulti(DDRPHY_REG_SHU_B0_DQ7, P_Fld(0x0, SHU_B0_DQ7_R_DMRXDVS_PBYTE_DQM_EN_B0)
                                            | P_Fld(0x0, SHU_B0_DQ7_R_DMRXDVS_PBYTE_FLAG_OPT_B0)
                                            | P_Fld(0x0, SHU_B0_DQ7_R_DMRXDVS_DQM_FLAGSEL_B0));
    vIO32WriteFldMulti(DDRPHY_REG_SHU_B1_DQ7, P_Fld(0x0, SHU_B1_DQ7_R_DMRXDVS_PBYTE_DQM_EN_B1)
                                            | P_Fld(0x0, SHU_B1_DQ7_R_DMRXDVS_PBYTE_FLAG_OPT_B1)
                                            | P_Fld(0x0, SHU_B1_DQ7_R_DMRXDVS_DQM_FLAGSEL_B1));
    vIO32WriteFldMulti(DDRPHY_REG_SHU_B2_DQ7, P_Fld(0x0, SHU_B2_DQ7_R_DMRXDVS_PBYTE_DQM_EN_B2)
                                            | P_Fld(0x0, SHU_B2_DQ7_R_DMRXDVS_PBYTE_FLAG_OPT_B2)
                                            | P_Fld(0x0, SHU_B2_DQ7_R_DMRXDVS_DQM_FLAGSEL_B2));

	DQSSTBSettings(p);

	///TODO: cc: need confirm DDR4 setting.
	RODTSettings(p);

#if RX_PICG_NEW_MODE
    RXPICGSetting(p);
#endif

#if DDR_ENABLE_SW_IMPED_CAL
#if FOR_DV_SIMULATION_USED
    if (SASimCtlGlobal.sim_sw_imp)
#endif
    {
        DramcSwImpedanceSaveRegister(p);
    }
#endif

#if ENABLE_TPBR2PBR_REFRESH_TIMING
    vIO32WriteFldAlign(DRAMC_REG_REFCTRL1, 0x1, REFCTRL1_REF_OVERHEAD_PBR2PB_ENA); //@Derping
    vIO32WriteFldAlign(DRAMC_REG_MISCTL0, 0x1, MISCTL0_REFP_ARBMASK_PBR2PBR_ENA); //@Unique
    vIO32WriteFldAlign(DRAMC_REG_SCHEDULER_COM, 0x0, SCHEDULER_COM_PBR2PBR_OPT); //@YH
#endif

#if DDR_RDSEL_TRACKING_EN
    vIO32WriteFldAlign(DDRPHY_REG_SHU_MISC_RDSEL_TRACK, 0, SHU_MISC_RDSEL_TRACK_DMDATLAT_I); //DMDATLAT_I should be set as 0 before set datlat k value, otherwise the status flag wil be set as 1
#endif

#if (!XRTRTR_NEW_CROSS_RK_MODE)
    vIO32WriteFldAlign(DDRPHY_REG_SHU_MISC_RANK_SEL_STB, 0x0, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_EN);
#endif

    /* cc: set this for DQSGCNT update */
    vIO32WriteFldAlign(DDRPHY_REG_MISC_STBCAL2, 1, MISC_STBCAL2_DQSGCNT_BYP_REF);

    //MP Setting
    vIO32WriteFldMulti(DRAMC_REG_DUMMY_RD, P_Fld(0x1, DUMMY_RD_DMYRD_REORDER_DIS) | P_Fld(0x0, DUMMY_RD_SREF_DMYRD_EN));
    vIO32WriteFldMulti(DRAMC_REG_DRAMCTRL, P_Fld(0x0, DRAMCTRL_ALL_BLOCK_CTO_ALE_DBG_EN) | P_Fld(0x1, DRAMCTRL_SELFREF_BLOCK_CTO_ALE_DBG_EN));
    vIO32WriteFldAlign(DDRPHY_REG_MISC_STBCAL2, 1, MISC_STBCAL2_DQSGCNT_BYP_REF);
    vIO32WriteFldMulti(DDRPHY_REG_MISC_CG_CTRL7,
            P_Fld(0x0, MISC_CG_CTRL7_CK_BFE_DCM_EN) |
            P_Fld(0x1, MISC_CG_CTRL7_ARMCTL_CK_OUT_CG_SEL));

    //1:8 --> data rate<=1600 set 0,  data rate<=3200 set 1, else 2
    //1:4 --> data rate<= 800 set 0,  data rate<=1600 set 1, else 2
    vIO32WriteFldMulti(DDRPHY_REG_MISC_SHU_PHY_RX_CTRL,
            P_Fld(0x2, MISC_SHU_PHY_RX_CTRL_RX_IN_BUFF_EN_HEAD) |
            P_Fld(0x1, MISC_SHU_PHY_RX_CTRL_RX_IN_GATE_EN_TAIL) |
            P_Fld(0x2, MISC_SHU_PHY_RX_CTRL_RX_IN_GATE_EN_PRE_OFFSET) |
            P_Fld(0x1, MISC_SHU_PHY_RX_CTRL_RX_IN_GATE_EN_HEAD));

    vIO32WriteFldAlign(DDRPHY_REG_MISC_SHU_CTRL0, 1, MISC_SHU_CTRL0_R_DMARPIDQ_SW); // @Darren, Fix DQ/DQM duty PI not work.

    SetMck8xLowPwrOption(p);
}

