/*
 * Copyright (C) 2022, MediaTek Inc. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 * Generic firmware download
 */

#ifndef _FWDL_H_
#define _FWDL_H_

#include <stdint.h>

enum fwdl_status {
	FWDL_STATUS_OK,
	FWDL_STATUS_INTERNAL_ERROR,
	FWDL_STATUS_INVALID_PARAM,
	FWDL_STATUS_INVALID_ADDRESS,
	FWDL_STATUS_INVALID_SIZE,
	FWDL_STATUS_FW_MMAP_FAILED,
	FWDL_STATUS_INVALID_FW_FORMAT,
	FWDL_STATUS_INVALID_FW_ROLE,
	FWDL_STATUS_INVALID_FW_PLATFORM,
	FWDL_STATUS_UNSUPPORTED_FW_HDR_VER,
	FWDL_STATUS_INVALID_PART_TYPE,
	FWDL_STATUS_FW_PART_TOO_LARGE,
	FWDL_STATUS_INVALID_BOOT_PART,
	FWDL_STATUS_MISSING_FW_PART,
	FWDL_STATUS_FW_VALIDATION_FAILED,
};

uint64_t fw_load(uint64_t flags, uint64_t addr, uint64_t size);

#endif /* _FWDL_H_ */
