/*
 * Copyright (C) 2023, MediaTek Inc. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include <errno.h>
#include <stdbool.h>
#include <lib/mmio.h>
#include <platform_def.h>
#include <mt7987_def.h>
#include "fwdl-internal.h"

#define WO_HDR_MAGIC				0x57464f57

/* Key hash */
extern const uint8_t wo_keyhash[];

enum wo_part_type {
	WO_PT_DEFAULT,

	__WO_PT_MAX
};

enum wo_platform {
	WO_PLAT_MT7988,

	__WO_PLAT_MAX
};

enum wo_role_type {
	WO_ROLE_DEFAULT,

	__WO_ROLE_MAX
};

static const uint16_t wo_fw_plat_ids[] = { WO_PLAT_MT7988 };
static const uint8_t wo_fw_role_ids[] = { WO_ROLE_DEFAULT };
static const uint8_t wo_fw_part_types[] = {
	WO_PT_DEFAULT,
};

static enum fwdl_status wo_do_fw_load(struct fw_image_register *fwir,
				      uint16_t plat_id, uint8_t role_id,
				      uint64_t flags)
{
	if (!fwir->part_data[0].size) {
		FWDL_E("WO: Invalid firmware payload\n");
		return FWDL_STATUS_MISSING_FW_PART;
	}

	/*
	 * TODO: Do FW loading here.
	 *
	 * Payload data is pointed by fwir->part_data[0].data
	 * Payload size is fwir->part_data[0].size
	 */

	return FWDL_STATUS_OK;
}

static struct fw_image_part_data wo_part_data[ARRAY_SIZE(wo_fw_part_types)];

struct fw_image_register wo_fwimg_reg = {
	.magic = WO_HDR_MAGIC,

#ifdef WO_KEY_HASH_VERIFY
	.keyhash = wo_keyhash,
#endif

	.plat_ids = wo_fw_plat_ids,
	.num_plats = ARRAY_SIZE(wo_fw_plat_ids),

	.role_ids = wo_fw_role_ids,
	.num_roles = ARRAY_SIZE(wo_fw_role_ids),

	.required_part_types = wo_fw_part_types,
	.num_parts = ARRAY_SIZE(wo_fw_part_types),

	.part_data = wo_part_data,
	.do_fw_load = wo_do_fw_load,
};
