/*
 * Copyright (c) 2020, MediaTek Inc. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
#include <drivers/delay_timer.h>
#include <lib/mmio.h>
#include <mcucfg.h>
#include <platform_def.h>
#include <common/debug.h>
#include "pll.h"

#define VDNR_DCM_TOP_INFRA_CTRL_0 0x1A020018
#define INFRASYS_BUS_DCM_CTRL	  0x10001004

unsigned int mtk_get_cpu_freq(void)
{
	return CPU_CLOCK/1000000;
}

void mtk_pll_init(int skip_dcm_setting)
{
	/* No PLL design in FPGA */

	/* Enable Infra bus divider  */
	if (skip_dcm_setting == 0) {
		mmio_setbits_32(VDNR_DCM_TOP_INFRA_CTRL_0, 0x0400);
		mmio_write_32(INFRASYS_BUS_DCM_CTRL, 0x5);
	}

	/*Set default MUX for topckgen */
	mmio_write_32(CLK_CFG0_SET, 0x01010101);
	mmio_write_32(CLK_CFG1_SET, 0x01020101);
	mmio_write_32(CLK_CFG2_SET, 0x01010001);
	mmio_write_32(CLK_CFG3_SET, 0x02010101);
	mmio_write_32(CLK_CFG4_SET, 0x01010101);
	mmio_write_32(CLK_CFG5_SET, 0x01010101);
	mmio_write_32(CLK_CFG6_SET, 0x01010101);
	mmio_write_32(CLK_CFG7_SET, 0x01010101);
	mmio_write_32(CLK_CFG8_SET, 0x01010101);
	mmio_write_32(CLK_CFG9_SET, 0x01010101);
	mmio_write_32(CLK_CFG10_SET, 0x01010101);
	mmio_write_32(CLK_CFG11_SET, 0x01010101);
	mmio_write_32(CLK_CFG12_SET, 0x01010101);
	mmio_write_32(CLK_CFG13_SET, 0x01010101);
	mmio_write_32(CLK_CFG14_SET, 0x01010101);
	mmio_write_32(CLK_CFG15_SET, 0x00000101);
	mmio_write_32(CLK_CFG16_SET, 0x01010100);
	mmio_write_32(CLK_CFG17_SET, 0x01010101);
	mmio_write_32(CLK_CFG18_SET, 0x00000101);

	mmio_write_32(CLK_CFG_UPDATE0, 0x7fffffff);
	mmio_write_32(CLK_CFG_UPDATE1, 0x7fffffff);
	mmio_write_32(CLK_CFG_UPDATE2, 0x00000ff8);

	/*Set default MUX for infra */
	mmio_write_32(MODULE_CLK_SEL_0, 0xffffc077);
	mmio_write_32(MODULE_CLK_SEL_1, 0x000000ff);
}
