/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (C) 2023 MediaTek Inc. All Rights Reserved.
 *
 * Author: Weijie Gao <weijie.gao@mediatek.com>
 *
 * Dual FIP implementation
 */
#ifndef _DUAL_FIP_H_
#define _DUAL_FIP_H_

#include <linux/types.h>

#define FIP_NUM				2

struct dual_fip_result {
	uint32_t ver;
	uint32_t crc;
	uint8_t fip_state[FIP_NUM];
	uint8_t padding[4 - (FIP_NUM % 4)];
};

#define DUAL_FIP_VER			1
#define DUAL_FIP_RESULT_LEN		sizeof(struct dual_fip_result)

#define DUAL_FIP_STATE_OK		0
#define DUAL_FIP_STATE_NODEV		0x80
#define DUAL_FIP_STATE_WAS_BAD		0xff

bool dual_fip_boot_from_fip1(void);
void dual_fip_read_result(void);

#endif /* _DUAL_FIP_H_ */
