// SPDX-License-Identifier: GPL-2.0+
/*
 * Copyright 2023 Freescale Semiconductor, Inc.
 * author SkyLake.Huang
 */
#include <asm/io.h>
#include <dm/device_compat.h>
#include <dm/of_access.h>
#include <dm/ofnode.h>
#include <linux/delay.h>
#include <phy.h>
#include "mt7988_2p5g_PMb_fw.h"

#define MD32_EN			BIT(0)

static int mediatek_2p5g_probe(struct phy_device *phydev)
{
	u32 *fw = NULL;
	size_t fw_length = 0;
	phys_addr_t pmb_base;
	phys_addr_t md32_en_cfg_base;
	void *addr;
	u16 reg;
	int i;

	ofnode node = ofnode_by_compatible(ofnode_null(), "mediatek,2p5gphy-fw");

	pmb_base = ofnode_get_addr_index(node, 0);
	fw = mt7988_2p5g_PMb_fw;
	fw_length = sizeof(mt7988_2p5g_PMb_fw);
	addr = map_physmem(pmb_base, fw_length, MAP_NOCACHE);
	/* Firmware is arranged in 4 byte-aligned */
	for(i = 0; i < (fw_length >> 2); i++) {
		writel(fw[i], (u32 *)addr + i);
	}
	unmap_physmem(addr, MAP_NOCACHE);

	/* Trigger FW */
	md32_en_cfg_base = ofnode_get_addr_index(node, 1);
	addr = map_physmem(md32_en_cfg_base, fw_length, MAP_NOCACHE);
	reg = readw(addr);
	writew(reg | MD32_EN, addr);
	dev_info(phydev->dev, "Firmware loading/trigger ok.\n");
	unmap_physmem(addr, MAP_NOCACHE);

	return 0;
}

U_BOOT_PHY_DRIVER(mt7988_i2p5g) = {
	.name = "Mediatek MT7988 internal 2.5GPHY",
	.uid = 0x339c11,
	.mask = 0xfffffff0,
	.features = PHY_10G_FEATURES,
	.mmds = (MDIO_MMD_PMAPMD | MDIO_MMD_PCS |
		 MDIO_MMD_PHYXS | MDIO_MMD_AN |
		 MDIO_MMD_VEND1),
	.probe = &mediatek_2p5g_probe,
	.startup = &genphy_startup,
	.shutdown = &genphy_shutdown,
};
