/* ALPHA patch, 20111110 Daniel Chen */
/*********************************************************************/
/* S E A M A ... */

#ifndef __SEAMA_IMAGE_H__
#define __SEAMA_IMAGE_H__

#define SEAMA_MAGIC     0x5EA3A417
typedef struct seama_hdr seamahdr_t;
struct seama_hdr
{
	uint32_t        magic;
	uint16_t        reserved;
	uint16_t        metasize;
	uint32_t        size;
} __attribute__ ((packed));

extern int SEAMA_valid;
extern char * SEAMA_signature;  /* signature (in meta), the signature of this f/w */
extern int SEAMA_noheader;              /* noheader (in meta), DO NOT write seama header */
extern char * SEAMA_type;               /* type (in meta), image type. */
extern seamahdr_t * SEAMA_image;
extern size_t SEAMA_size;
extern uchar * SEAMA_rawimage;
int verify_seama(uchar * ptr, size_t size);
/***********************************************************************/
/* IMAGE HEADER V2 */
#define MAX_SIGNATURE   32
#define IMG_MAX_DEVNAME         32
#define IMG_V2_MAGIC_NO         0x20040220      /* version 2 magic number */

typedef struct _imgblock imgblock_t;
struct _imgblock
{
	uint32_t        magic;          /* image magic number (should be IMG_V2_MAGIC_NO in little endian). */
	uint32_t        size;           /* size of the image. */
	uint32_t        offset;         /* offset from the beginning of the storage device. */
	char                    devname[IMG_MAX_DEVNAME];       /* null termiated string of the storage device name. ex. "/dev/mtd6" */
	unsigned char   digest[16];     /* MD5 digest of the image */
} __attribute__ ((packed));

typedef struct _imghdr2 imghdr2_t;
struct _imghdr2
{
	char                    signature[MAX_SIGNATURE];
	uint32_t        magic;  /* should be IMG_V2_MAGIC_NO in little endian. */
} __attribute__ ((packed));

extern int IMGHDRV2_valid;
extern imghdr2_t * IMGHDRV2_image;
extern size_t IMGHDRV2_size;
//extern int verify_imghdrv2(uchar * ptr, size_t size);

#endif  /* __SEAMA_IMAGE_H__ */
