#include <asm/asm-offsets.h>
#include <asm/thread_info.h>

#define PAGE_SIZE _PAGE_SIZE

/*
 * Put .bss..swapper_pg_dir as the first thing in .bss. This will
 * ensure that it has .bss alignment (64K).
 */
#define BSS_FIRST_SECTIONS *(.bss..swapper_pg_dir)

#include <asm-generic/vmlinux.lds.h>

#undef mips
#define mips mips
OUTPUT_ARCH(mips)
ENTRY(kernel_entry)
PHDRS {
	text PT_LOAD FLAGS(7);	/* RWX */
	note PT_NOTE FLAGS(4);	/* R__ */
}

#ifdef CONFIG_32BIT
	#ifdef CONFIG_CPU_LITTLE_ENDIAN
		jiffies  = jiffies_64;
	#else
		jiffies  = jiffies_64 + 4;
	#endif
#else
	jiffies  = jiffies_64;
#endif

SECTIONS
{
#ifdef CONFIG_BOOT_ELF64
	/* Read-only sections, merged into text segment: */
	/* . = 0xc000000000000000; */

	/* This is the value for an Origin kernel, taken from an IRIX kernel.  */
	/* . = 0xc00000000001c000; */

	/* Set the vaddr for the text segment to a value
	 *   >= 0xa800 0000 0001 9000 if no symmon is going to configured
	 *   >= 0xa800 0000 0030 0000 otherwise
	 */

	/* . = 0xa800000000300000; */
	. = 0xffffffff80300000;
#endif
	. = VMLINUX_LOAD_ADDRESS;
	/* read-only */
	_text = .;	/* Text and read-only data */
	.text : {
		TEXT_TEXT
		SCHED_TEXT
		LOCK_TEXT
		KPROBES_TEXT
		IRQENTRY_TEXT
		*(.text.*)
		*(.fixup)
		*(.gnu.warning)
/*#ifdef CONFIG_RTL8192SE*/
#if 1
		/* start of wlan f/w definition */
		__fw_start = . ;
		*(.rtl8192sfw.bin)
		__fw_end = . ;

		__AGC_TAB_start = . ;
		*(.AGC_TAB.txt)
		__AGC_TAB_end = . ;

		__phy_reg_start = . ;
		*(.phy_reg.txt)
		__phy_reg_end = . ;

		__phy_reg_MP_start = . ;
		*(.phy_reg_MP.txt)
		__phy_reg_MP_end = . ;

		__MACPHY_REG_start = . ;
		*(.MACPHY_REG.txt)
		__MACPHY_REG_end = . ;

		__radio_a_start = . ;
		*(.radio_a.txt)
		__radio_a_end = . ;                                                       

		__radio_b_start = . ;
		*(.radio_b.txt)
		__radio_b_end = . ;

		__PHY_REG_PG_start = .;
		*(.PHY_REG_PG.txt)
		__PHY_REG_PG_end = .;

		__PHY_to1T2R_start = .;
		*(.PHY_to1T2R.txt)
		__PHY_to1T2R_end = .;

		__PHY_to1T2R_b_start = .;
		*(.PHY_to1T2R_b.txt)
		__PHY_to1T2R_b_end = .;

		__PHY_to1T1R_start = .;
		*(.PHY_to1T1R.txt)
		__PHY_to1T1R_end = .;

		__PHY_to1T1R_b_start = .;
		*(.PHY_to1T1R_b.txt)
		__PHY_to1T1R_b_end = .;

		__radio_a_hp_start = . ;
		*(.radio_a_hp.txt)
		__radio_a_hp_end = . ;

		/* end of wlan f/w definition */
#endif

	} :text = 0
	_etext = .;	/* End of text section */

	EXCEPTION_TABLE(16)

	/* Exception table for data bus errors */
	__dbe_table : {
		__start___dbe_table = .;
		KEEP(*(__dbe_table))
		__stop___dbe_table = .;
	}

   	. = ALIGN(8192);
   	__iram = . ;
   	__iram_start = . ;
   	.iram        :
   	{
		*(.iram-gen)		/* general usage (essential) */
		*(.iram-fwd)            /* general packet forwarding used */
		*(.iram-rtkwlan)	/* realtek wlan driver */
		*(.iram-l2-fwd)         /* L2 packet forwarding */
		*(.iram-l34-fwd)        /* L34 packet forwarding */
		*(.iram-tx)		/* protocol stack TX */
		*(.iram-extdev)		/* ROMEDRV extension device fwd */
		*(.iram-crypto)		/* authetication / crypto-engine */
		*(.iram-rtkusb)		/* usb */	
		*(.iram-voip)		/* voip */
		*(.iram)		/* other usage */
		*(.iram.1)
   	}
   	__iram_tail = . ;
     	. = ALIGN(8192);
   	__iram_end = . ;

   	. = ALIGN(8192);
   	__dram = . ;
   	__dram_start = . ;
   	.dram	:
   	{
		*(.dram-wapi)           /*wapi encryption/decryption used*/
   		*(.dram-gen)		/* general usage (essential) */
		*(.dram-fwd)            /* general packet forwarding used */
   		*(.dram-l2-fwd)		/* L2 packet forwarding */
		*(.dram-l34-fwd)        /* L34 packet forwarding */
   		*(.dram-extdev)		/* ROMEDRV extension device fwd */
   		*(.dram-rtkwlan)	/* realtek wlan driver */
		*(.dram-crypto)		/* authetication / crypto-engine */
   		*(.dram-voip)		/* voip */
		*(.dram-tx)		/* protocol stack TX */
		*(.dram)		/* other usage */
		*(.dram.1)
   	}
   	__dram_tail = . ;
   	. = ALIGN(8192);
   	__dram_end = . ;

	NOTES :text :note
	.dummy : { *(.dummy) } :text

	_sdata = .;			/* Start of data section */
	RODATA

	/* writeable */
	.data : {	/* Data */
		. = . + DATAOFFSET;		/* for CONFIG_MAPPED_KERNEL */

		INIT_TASK_DATA(THREAD_SIZE)
		NOSAVE_DATA
		CACHELINE_ALIGNED_DATA(1 << CONFIG_MIPS_L1_CACHE_SHIFT)
		READ_MOSTLY_DATA(1 << CONFIG_MIPS_L1_CACHE_SHIFT)
		DATA_DATA
		CONSTRUCTORS
	}
	_gp = . + 0x8000;
	.lit8 : {
		*(.lit8)
	}
	.lit4 : {
		*(.lit4)
	}
	/* We want the small data sections together, so single-instruction offsets
	   can access them all, and initialized data all before uninitialized, so
	   we can shorten the on-disk segment size.  */
	.sdata : {
		*(.sdata)
	}
	_edata =  .;			/* End of data section */

	/* will be freed after init */
	. = ALIGN(PAGE_SIZE);		/* Init code and data */
	__init_begin = .;
	INIT_TEXT_SECTION(PAGE_SIZE)
	INIT_DATA_SECTION(16)

	. = ALIGN(4);
	.mips.machines.init : AT(ADDR(.mips.machines.init) - LOAD_OFFSET) {
		__mips_machines_start = .;
		KEEP(*(.mips.machines.init))
		__mips_machines_end = .;
	}

	/* .exit.text is discarded at runtime, not link time, to deal with
	 * references from .rodata
	 */
	.exit.text : {
		EXIT_TEXT
	}
	.exit.data : {
		EXIT_DATA
	}

	PERCPU_SECTION(1 << CONFIG_MIPS_L1_CACHE_SHIFT)
	/*
	 * Align to 64K in attempt to eliminate holes before the
	 * .bss..swapper_pg_dir section at the start of .bss.  This
	 * also satisfies PAGE_SIZE alignment as the largest page size
	 * allowed is 64K.
	 */
	. = ALIGN(0x10000);
	__init_end = .;
	/* freed after init ends here */

	/*
	 * Force .bss to 64K alignment so that .bss..swapper_pg_dir
	 * gets that alignment.	 .sbss should be empty, so there will be
	 * no holes after __init_end. */
	BSS_SECTION(0, 0x10000, 0)

	_end = . ;

	/* These mark the ABI of the kernel for debuggers.  */
	.mdebug.abi32 : {
		KEEP(*(.mdebug.abi32))
	}
	.mdebug.abi64 : {
		KEEP(*(.mdebug.abi64))
	}

	/* This is the MIPS specific mdebug section.  */
	.mdebug : {
		*(.mdebug)
	}

	STABS_DEBUG
	DWARF_DEBUG

	/* These must appear regardless of  .  */
	.gptab.sdata : {
		*(.gptab.data)
		*(.gptab.sdata)
	}
	.gptab.sbss : {
		*(.gptab.bss)
		*(.gptab.sbss)
	}

	/* Sections to be discarded */
	DISCARDS
	/DISCARD/ : {
		/* ABI crap starts here */
		*(.MIPS.options)
		*(.options)
		*(.pdr)
		*(.reginfo)
	}
}
