#ifndef _HALMAC_8821C_CFG_H_
#define _HALMAC_8821C_CFG_H_

#include "halmac_8821c_pwr_seq.h"
#include "halmac_api_8821c.h"
#include "halmac_api_8821c_usb.h"
#include "halmac_api_8821c_pcie.h"
#include "halmac_api_8821c_sdio.h"
#include "../../halmac_bit2.h"
#include "../../halmac_reg2.h"
#include "../../halmac_api.h"

#if HALMAC_PLATFORM_TESTPROGRAM
#include "halmisc_api_8821c.h"
#include "halmisc_api_8821c_usb.h"
#include "halmisc_api_8821c_sdio.h"
#include "halmisc_api_8821c_pcie.h"
#endif

#define HALMAC_TX_FIFO_SIZE_8821C				65536 /* 64k */
#define HALMAC_TX_FIFO_SIZE_LA_8821C			32768 /* 32k */
#define HALMAC_RX_FIFO_SIZE_8821C				16384 /* 16k */
#define HALMAC_TX_PAGE_SIZE_8821C				128 /* PageSize 128Byte */
#define HALMAC_TX_PAGE_SIZE_2_POWER_8821C		7 /* 128 = 2^7 */
#define HALMAC_SECURITY_CAM_ENTRY_NUM_8821C		64 /* CAM Entry Size */
#define HALMAC_TX_DESC_SIZE_8821C				48
#define HALMAC_RX_DESC_SIZE_8821C				24
#define HALMAC_WOWLAN_PATTERN_SIZE_8821C		256


#if 0
#define HALMAC_EXTRA_INFO_BUFF_SIZE_8821C				4096 /*4K*/
#define HALMAC_EXTRA_INFO_BUFF_SIZE_FULL_FIFO_8821C		16384 /*16K*/
#define HALMAC_EXTRA_INFO_BUFF_PAGE_NUM_8821C			(HALMAC_EXTRA_INFO_BUFF_SIZE_8821C/HALMAC_TX_PAGE_SIZE_8821C) /*4K*/
#define HALMAC_FW_OFFLOAD_CMD_SIZE_8821C				12 /*Fw config parameter cmd size, each 12 byte*/

#define HALMAC_H2C_CMD_ORIGINAL_SIZE_8821C		8
#define HALMAC_H2C_CMD_SIZE_UNIT_8821C			32 /* Only support 32K byte packet now */
#define HALMAC_H2C_CMD_BUFF_HEAD_8821C			0xFC00
#define HALMAC_H2C_CMD_BUFF_TAIL_8821C			0xFF80
#endif
#define HALMAC_EFUSE_SIZE_8821C							512/* 0x2000 */

#define HALMAC_CR_TRX_ENABLE_8821C	(BIT_HCI_TXDMA_EN | BIT_HCI_RXDMA_EN | BIT_TXDMA_EN | \
								 		BIT_RXDMA_EN | BIT_PROTOCOL_EN | BIT_SCHEDULE_EN | \
								 		BIT_MACTXEN | BIT_MACRXEN)

#define HALMAC_BLK_DESC_NUM_8821C						0x5 /* Only for USB */

typedef enum _HALMAC_NORMAL_RXAGG_TH_TO_8821C {
	HALMAC_NORMAL_RXAGG_THRESHOLD_8821C	= 0xFF,
	HALMAC_NORMAL_RXAGG_TIMEOUT_8821C 	= 0x01,
} HALMAC_NORMAL_RXAGG_TH_TO_8821C;

typedef enum _HALMAC_LOOPBACK_RXAGG_TH_TO_8821C {
	HALMAC_LOOPBACK_RXAGG_THRESHOLD_8821C	= 0xFF,
	HALMAC_LOOPBACK_RXAGG_TIMEOUT_8821C		= 0x01,
} HALMAC_LOOPBACK_RXAGG_TH_TO_8821C;

#if 0
typedef enum _HALMAC_NORMAL_PAGE_NUM_8821C {
	HALMAC_NORMAL_PAGE_NUM_HPQ_8821C			= 0x10,
	HALMAC_NORMAL_PAGE_NUM_NPQ_8821C			= 0x10,
	HALMAC_NORMAL_PAGE_NUM_LPQ_8821C			= 0x10,
	HALMAC_NORMAL_PAGE_NUM_EXPQ_8821C			= 0xE,
	HALMAC_NORMAL_PAGE_NUM_PUBQ_8821C			= 0x190,
	HALMAC_NORMAL_TX_PAGE_BOUNDARY_8821C		= 0x1D0,/*0x800 - 4k-2k*/
	HALMAC_NORMAL_FWCMD_BOUNDARY_8821C			= (HALMAC_NORMAL_TX_PAGE_BOUNDARY_8821C + HALMAC_EXTRA_INFO_BUFF_PAGE_NUM_8821C),/*0x800 - 4k*/
	HALMAC_NORMAL_TOTAL_PAGE_BOUNDARY_8821C		= (HALMAC_TX_FIFO_SIZE_8821C / HALMAC_TX_PAGE_SIZE_8821C),/*0x800*/
} HALMAC_NORMAL_PAGE_NUM_8821C;

typedef enum _HALMAC_LOOBACK_PAGE_NUM_8821C {
	HALMAC_LOOPBACK_PAGE_NUM_HPQ_8821C			= 0x10,
	HALMAC_LOOPBACK_PAGE_NUM_LPQ_8821C			= 0x10,
	HALMAC_LOOPBACK_PAGE_NUM_NPQ_8821C			= 0x10,
	HALMAC_LOOPBACK_PAGE_NUM_EXPQ_8821C			= 0xE,
	HALMAC_LOOPBACK_PAGE_NUM_PUBQ_8821C			= 0xC0,
	HALMAC_LOOPBACK_TX_PAGE_BOUNDARY_8821C		= 0x100,
	HALMAC_LOOPBACK_FWCMD_BOUNDARY_8821C		= (HALMAC_LOOPBACK_TX_PAGE_BOUNDARY_8821C + HALMAC_EXTRA_INFO_BUFF_PAGE_NUM_8821C),/*0x400 + 4k*/
	HALMAC_LOOPBACK_TOTAL_PAGE_BOUNDARY_8821C	= (HALMAC_TX_FIFO_SIZE_8821C / HALMAC_TX_PAGE_SIZE_8821C),/*0x800*/	
	
} HALMAC_LOOBACK_PAGE_NUM_8821C;

typedef enum _HALMAC_NORMAL_PAGE_NUM_2BULKOUT_8821C {
	HALMAC_NORMAL_PAGE_NUM_HPQ_2BULKOUT_8821C			= 0x10,
	HALMAC_NORMAL_PAGE_NUM_NPQ_2BULKOUT_8821C			= 0x10,
	HALMAC_NORMAL_PAGE_NUM_LPQ_2BULKOUT_8821C			= 0x00,
	HALMAC_NORMAL_PAGE_NUM_EXPQ_2BULKOUT_8821C			= 0x00,
	HALMAC_NORMAL_PAGE_NUM_PUBQ_2BULKOUT_8821C			= 0x1E0,
	HALMAC_NORMAL_TX_PAGE_BOUNDARY_2BULKOUT_8821C		= 0x200,/*0x800 - 4k-2k*/
	HALMAC_NORMAL_FWCMD_BOUNDARY_2BULKOUT_8821C			= (HALMAC_NORMAL_TX_PAGE_BOUNDARY_2BULKOUT_8821C + HALMAC_EXTRA_INFO_BUFF_PAGE_NUM_8821C),/*0x800 - 4k*/
	HALMAC_NORMAL_TOTAL_PAGE_BOUNDARY_2BULKOUT_8821C	= (HALMAC_TX_FIFO_SIZE_8821C / HALMAC_TX_PAGE_SIZE_8821C),/*0x800*/		
} HALMAC_NORMAL_PAGE_NUM_2BULKOUT_8821C;

typedef enum _HALMAC_LOOBACK_PAGE_NUM_2BULKOUT_8821C {
	HALMAC_LOOPBACK_PAGE_NUM_HPQ_2BULKOUT_8821C			= 0x10,
	HALMAC_LOOPBACK_PAGE_NUM_NPQ_2BULKOUT_8821C			= 0x10,
	HALMAC_LOOPBACK_PAGE_NUM_LPQ_2BULKOUT_8821C			= 0x00,
	HALMAC_LOOPBACK_PAGE_NUM_EXPQ_2BULKOUT_8821C		= 0x00,
	HALMAC_LOOPBACK_PAGE_NUM_PUBQ_2BULKOUT_8821C		= 0xE0,
	HALMAC_LOOPBACK_TX_PAGE_BOUNDARY_2BULKOUT_8821C		= 0x100,
	HALMAC_LOOPBACK_FWCMD_BOUNDARY_2BULKOUT_8821C		= (HALMAC_LOOPBACK_TX_PAGE_BOUNDARY_2BULKOUT_8821C + HALMAC_EXTRA_INFO_BUFF_PAGE_NUM_8821C),/*0x400 + 4k*/
	HALMAC_LOOPBACK_TOTAL_PAGE_BOUNDARY_2BULKOUT_8821C	= (HALMAC_TX_FIFO_SIZE_8821C / HALMAC_TX_PAGE_SIZE_8821C),/*0x800*/	
} HALMAC_LOOBACK_PAGE_NUM_2BULKOUT_8821C;

typedef enum _HALMAC_NORMAL_PAGE_NUM_3BULKOUT_8821C {
	HALMAC_NORMAL_PAGE_NUM_HPQ_3BULKOUT_8821C			= 0x10,
	HALMAC_NORMAL_PAGE_NUM_NPQ_3BULKOUT_8821C			= 0x10,
	HALMAC_NORMAL_PAGE_NUM_LPQ_3BULKOUT_8821C			= 0x10,
	HALMAC_NORMAL_PAGE_NUM_EXPQ_3BULKOUT_8821C			= 0x00,
	HALMAC_NORMAL_PAGE_NUM_PUBQ_3BULKOUT_8821C			= 0x1D0,
	HALMAC_NORMAL_TX_PAGE_BOUNDARY_3BULKOUT_8821C		= 0x200,/*0x800 - 4k-2k*/
	HALMAC_NORMAL_FWCMD_BOUNDARY_3BULKOUT_8821C			= (HALMAC_NORMAL_TX_PAGE_BOUNDARY_3BULKOUT_8821C + HALMAC_EXTRA_INFO_BUFF_PAGE_NUM_8821C),/*0x800 - 4k*/
	HALMAC_NORMAL_TOTAL_PAGE_BOUNDARY_3BULKOUT_8821C	= (HALMAC_TX_FIFO_SIZE_8821C / HALMAC_TX_PAGE_SIZE_8821C),/*0x800*/		
} HALMAC_NORMAL_PAGE_NUM_3BULKOUT_8821C;

typedef enum _HALMAC_LOOBACK_PAGE_NUM_3BULKOUT_8821C {
	HALMAC_LOOPBACK_PAGE_NUM_HPQ_3BULKOUT_8821C			= 0x10,
	HALMAC_LOOPBACK_PAGE_NUM_NPQ_3BULKOUT_8821C			= 0x10,
	HALMAC_LOOPBACK_PAGE_NUM_LPQ_3BULKOUT_8821C			= 0x10,
	HALMAC_LOOPBACK_PAGE_NUM_EXPQ_3BULKOUT_8821C		= 0x00,
	HALMAC_LOOPBACK_PAGE_NUM_PUBQ_3BULKOUT_8821C		= 0xD0,
	HALMAC_LOOPBACK_TX_PAGE_BOUNDARY_3BULKOUT_8821C		= 0x100,
	HALMAC_LOOPBACK_FWCMD_BOUNDARY_3BULKOUT_8821C		= (HALMAC_LOOPBACK_TX_PAGE_BOUNDARY_3BULKOUT_8821C + HALMAC_EXTRA_INFO_BUFF_PAGE_NUM_8821C),/*0x400 + 4k*/
	HALMAC_LOOPBACK_TOTAL_PAGE_BOUNDARY_3BULKOUT_8821C	= (HALMAC_TX_FIFO_SIZE_8821C / HALMAC_TX_PAGE_SIZE_8821C),/*0x800*/	
} HALMAC_LOOBACK_PAGE_NUM_3BULKOUT_8821C;

#endif


#define HALMAC_RSVD_DRV_PGNUM_8821C						16 /*2048*/
#define HALMAC_RSVD_H2C_EXTRAINFO_PGNUM_8821C			32 /*4096*/
#define HALMAC_RSVD_H2C_QUEUE_PGNUM_8821C				8 /*1024*/
#define HALMAC_RSVD_CPU_INSTRUCTION_PGNUM_8821C			0 /*0*/
#define HALMAC_RSVD_FW_TXBUFF_PGNUM_8821C				4 /*512*/
#define HALMAC_RSVD_PGNUM_8821C							(HALMAC_RSVD_DRV_PGNUM_8821C + \
														HALMAC_RSVD_H2C_EXTRAINFO_PGNUM_8821C + \
														HALMAC_RSVD_H2C_QUEUE_PGNUM_8821C + \
														HALMAC_RSVD_CPU_INSTRUCTION_PGNUM_8821C + \
														HALMAC_RSVD_FW_TXBUFF_PGNUM_8821C)

/*
* Normal mode
*/
#define HALMAC_NORMAL_HPQ_PGNUM_8821C		16 /*2048*/
#define HALMAC_NORMAL_NPQ_PGNUM_8821C		16 /*2048*/
#define HALMAC_NORMAL_LPQ_PGNUM_8821C		16 /*2048*/
#define HALMAC_NORMAL_EXPQ_PGNUM_8821C		14 /**/
#define HALMAC_NORMAL_GAP_PGNUM_8821C		1 /*128*/

/*
* Loopback mode
*/
#define HALMAC_LB_HPQ_PGNUM_8821C			16 /*2048*/
#define HALMAC_LB_NPQ_PGNUM_8821C			16 /*2048*/
#define HALMAC_LB_LPQ_PGNUM_8821C			16 /*2048*/
#define HALMAC_LB_EXPQ_PGNUM_8821C			14 /**/
#define HALMAC_LB_GAP_PGNUM_8821C			256 /**/

/*
* Normal mode - 2Bulkout
*/
#define HALMAC_NORMAL_2BULKOUT_HPQ_PGNUM_8821C			16 /*2048*/
#define HALMAC_NORMAL_2BULKOUT_NPQ_PGNUM_8821C			16 /*2048*/
#define HALMAC_NORMAL_2BULKOUT_LPQ_PGNUM_8821C			0 /*0*/
#define HALMAC_NORMAL_2BULKOUT_EXPQ_PGNUM_8821C			0 /*0*/
#define HALMAC_NORMAL_2BULKOUT_GAP_PGNUM_8821C			1 /*128*/

/*
* Loopback mode - 2Bulkout
*/
#define HALMAC_LB_2BULKOUT_HPQ_PGNUM_8821C				16 /*2048*/
#define HALMAC_LB_2BULKOUT_NPQ_PGNUM_8821C				16 /*2048*/
#define HALMAC_LB_2BULKOUT_LPQ_PGNUM_8821C				0 /*0*/
#define HALMAC_LB_2BULKOUT_EXPQ_PGNUM_8821C			 	0 /*0*/
#define HALMAC_LB_2BULKOUT_GAP_PGNUM_8821C				256 /**/

/*
* Normal mode - 3BULKOUT
*/
#define HALMAC_NORMAL_3BULKOUT_HPQ_PGNUM_8821C			16 /*2048*/
#define HALMAC_NORMAL_3BULKOUT_NPQ_PGNUM_8821C			16 /*2048*/
#define HALMAC_NORMAL_3BULKOUT_LPQ_PGNUM_8821C			16 /*2048*/
#define HALMAC_NORMAL_3BULKOUT_EXPQ_PGNUM_8821C			0 /*0*/
#define HALMAC_NORMAL_3BULKOUT_GAP_PGNUM_8821C			1 /*128*/

/*
* Loopback mode - 3BULKOUT
*/
#define HALMAC_LB_3BULKOUT_HPQ_PGNUM_8821C				16 /*2048*/
#define HALMAC_LB_3BULKOUT_NPQ_PGNUM_8821C				16 /*2048*/
#define HALMAC_LB_3BULKOUT_LPQ_PGNUM_8821C				16 /*2048*/
#define HALMAC_LB_3BULKOUT_EXPQ_PGNUM_8821C				0 /*0*/
#define HALMAC_LB_3BULKOUT_GAP_PGNUM_8821C				256 /**/


#endif
