#ifndef _HALMAC_88XX_CFG_H_
#define _HALMAC_88XX_CFG_H_

#include "../halmac_2_platform.h"
#include "../halmac_type.h"
#include "../halmac_hw_cfg.h"
#include "../halmac_api.h"
#include "../halmac_bit2.h"
#include "../halmac_reg2.h"
#include "halmac_pwr_seq_cmd_88xx.h"
#include "halmac_88xx_pwr_seq.h"
#include "halmac_func_88xx.h"
#include "halmac_api_88xx.h"
#include "halmac_api_88xx_usb.h"
#include "halmac_api_88xx_pcie.h"
#include "halmac_api_88xx_sdio.h"
#if HALMAC_PLATFORM_TESTPROGRAM
#include "halmisc_api_88xx.h"
#include "halmisc_api_88xx_usb.h"
#include "halmisc_api_88xx_pcie.h"
#include "halmisc_api_88xx_sdio.h"
#endif


#define HALMAC_TX_PAGE_SIZE_88XX			128 /* PageSize 128Byte */
#define HALMAC_TX_PAGE_SIZE_2_POWER_88XX	7 /* 128 = 2^7 */
#define HALMAC_C2H_DATA_OFFSET_88XX			10
#define HALMAC_RX_AGG_ALIGNMENT_SIZE_88XX	8
#define HALMAC_TX_AGG_ALIGNMENT_SIZE_88XX	8
#define HALMAC_TX_AGG_BUFF_SIZE				32768


#define HALMAC_EXTRA_INFO_BUFF_SIZE				4096 /*4K*/
#define HALMAC_EXTRA_INFO_BUFF_SIZE_FULL_FIFO	16384 /*16K*/
#define HALMAC_EXTRA_INFO_BUFF_PAGE_NUM			(HALMAC_EXTRA_INFO_BUFF_SIZE/HALMAC_TX_PAGE_SIZE_88XX) /*4K*/
#define HALMAC_FW_OFFLOAD_CMD_SIZE				12 /*Fw config parameter cmd size, each 12 byte*/

#define HALMAC_H2C_CMD_ORIGINAL_SIZE	8
#define HALMAC_H2C_CMD_SIZE_UNIT		32 /* Only support 32K byte packet now */
#define HALMAC_H2C_CMD_BUFF_HEAD		0x3FC00
#define HALMAC_H2C_CMD_BUFF_TAIL		0x3FF80

#define HALMAC_NLO_INFO_SIZE	1024

/* Download FW */
#define HALMAC_FW_SIZE_MAX				0x40000
#define HALMAC_FWHDR_SIZE				64
#define HALMAC_FW_CHKSUM_DUMMY_SIZE		8
#define HALMAC_FW_MAX_DL_SIZE			0x2000 /* need power of 2 */

/* FW header information */
#define HALMAC_FWHDR_OFFSET_VERSION			4
#define HALMAC_FWHDR_OFFSET_SUBVERSION		6
#define HALMAC_FWHDR_OFFSET_SUBINDEX		7
#define HALMAC_FWHDR_OFFSET_MEM_USAGE		24
#define HALMAC_FWHDR_OFFSET_H2C_FORMAT_VER	28 /*HALMAC_FORMAT_VER*/
#define HALMAC_FWHDR_OFFSET_DMEM_SIZE		36
#define HALMAC_FWHDR_OFFSET_IRAM_SIZE		48
#define HALMAC_FWHDR_OFFSET_ERAM_SIZE		52
#define HALMAC_FWHDR_EMEM_DL_ADDR			56

/* HW memory address */
#define HALMAC_OCPBASE_TXBUF	0x18780000
#define HALMAC_OCPBASE_DMEM		0x00200000
#define HALMAC_OCPBASE_IMEM		0x00000000

/* define the SDIO Bus CLK threshold, for avoiding CMD53 fails that result from SDIO CLK sync to ana_clk fail */
#define HALMAC_SD_CLK_THRESHOLD	150000000 /* 150MHz */

/* MAC clock */
#define HALMAC_MAC_CLOCK	80 /* 80M */

typedef enum _HALMAC_MAC_CLOCK_HW_DEF {
	HALMAC_MAC_CLOCK_HW_DEF_80M	= 0,
	HALMAC_MAC_CLOCK_HW_DEF_40M	= 1,
	HALMAC_MAC_CLOCK_HW_DEF_20M	= 2,
} HALMAC_MAC_CLOCK_HW_DEF;

/* H2C/C2H*/
#define HALMAC_H2C_CMD_SIZE			32
#define HALMAC_H2C_CMD_HDR_SIZE		8

#define HALMAC_LOGICAL_EFUSE_SIZE	0x300
#define HALMAC_RESERVED_EFUSE_SIZE	0x30

/* Interrupt mask setting */
#define HALMAC_ALL_INT_EN	0xFFFFFFFF
#define HALMAC_INT_MASK		HALMAC_ALL_INT_EN

/* Rx aggregation parameters */
typedef enum _HALMAC_NORMAL_RXAGG_TH_TO {
	HALMAC_NORMAL_RXAGG_THRESHOLD	= 0xFF,
	HALMAC_NORMAL_RXAGG_TIMEOUT		= 0x01,
} HALMAC_NORMAL_RXAGG_TH_TO;

typedef enum _HALMAC_LOOPBACK_RXAGG_TH_TO {
	HALMAC_LOOPBACK_RXAGG_THRESHOLD	= 0xFF,
	HALMAC_LOOPBACK_RXAGG_TIMEOUT	= 0x01,
} HALMAC_LOOPBACK_RXAGG_TH_TO;

/* Function enable */
#define HALMAC_FUNCTION_ENABLE	0xDC

/* FIFO size & packet size */
#define HALMAC_BASIC_RXFF_SIZE		24576 /* 24K */
#define HALMAC_WOWLAN_PATTERN_SIZE	256


/* CFEND rate */
#define HALMAC_BASIC_CFEND_RATE	0x5
#define HALMAC_STBC_CFEND_RATE	0xF

/* Response rate */
#define HALMAC_RESPONSE_RATE_BITMAP_ALL	0xFFFFF
#define HALMAC_RESPONSE_RATE			HALMAC_RESPONSE_RATE_BITMAP_ALL

/* Spec SIFS */
#define HALMAC_SIFS_CCK_PTCL	16
#define HALMAC_SIFS_OFDM_PTCL	16

/* Retry limit */
#define HALMAC_LONG_RETRY_LIMIT		8
#define HALMAC_SHORT_RETRY_LIMIT	7

/* Slot, SIFS, PIFS time */
#ifdef DEBUG_8822TX
#define HALMAC_SLOT_TIME		0x09
#else
#define HALMAC_SLOT_TIME		0x05
#endif
#define HALMAC_PIFS_TIME		0x19
#define HALMAC_SIFS_CCK_CTX		0xA
#define HALMAC_SIFS_OFDM_CTX	0xA
#define HALMAC_SIFS_CCK_TRX		0x10
#define HALMAC_SIFS_OFDM_TRX	0x10

/* TXOP limit */
#define HALMAC_VO_TXOP_LIMIT	0x186
#define HALMAC_VI_TXOP_LIMIT	0x3BC

/* NAV */
#define HALMAC_RDG_NAV		0x05
#define HALMAC_TXOP_NAV		0x1B

/* TSF */
#define HALMAC_CCK_RX_TSF	0x30
#define HALMAC_OFDM_RX_TSF	0x30

/* Send beacon related */
#define HALMAC_TBTT_PROHIBIT		0x04
#define HALMAC_TBTT_HOLD_TIME		0x064
#define HALMAC_DRIVER_EARLY_INT		0x04
#define HALMAC_BEACON_DMA_TIM		0x02
#define HALMAC_BEACON_INTERVAL		0x16

/* RX filter */
#define HALMAC_RX_FILTER0_RECIVE_ALL	0xFFFFFFF
#define HALMAC_RX_FILTER0				HALMAC_RX_FILTER0_RECIVE_ALL
#define HALMAC_RX_FILTER_RECIVE_ALL		0xFFFF
#define HALMAC_RX_FILTER				HALMAC_RX_FILTER_RECIVE_ALL

/* RCR */
#define HALMAC_RCR_CONFIG	0xE400733E

/* Security config */
#define HALMAC_SECURITY_CONFIG	0x01CC

#endif
