#ifndef HALMAC_POWER_SEQUENCE_88XX
#define HALMAC_POWER_SEQUENCE_88XX

#include "halmac_pwr_seq_cmd_88xx.h"

/*
* Check document WM-20150703-v01-JackieLau-RTL8822B_Power_Architecture.vsd
* There are 6 HW Power States:
* 0: POFF--Power Off
* 1: PDN--Power Down
* 2: CARDEMU--Card Emulation
* 3: ACT--Active Mode
* 4: LPS--Low Power State
* 5: SUS--Suspend
*
* The transision from different states are defined below
* TRANS_CARDEMU_TO_ACT
* TRANS_ACT_TO_CARDEMU
* TRANS_CARDEMU_TO_SUS
* TRANS_SUS_TO_CARDEMU
* TRANS_CARDEMU_TO_PDN
* TRANS_ACT_TO_LPS
* TRANS_LPS_TO_ACT
*
* TRANS_END
*/

#define	HALMAC_88XX_TRANS_CARDEMU_TO_ACT_STEPS	25
#define	HALMAC_88XX_TRANS_ACT_TO_CARDEMU_STEPS	15
#define	HALMAC_88XX_TRANS_CARDEMU_TO_SUS_STEPS	15
#define	HALMAC_88XX_TRANS_SUS_TO_CARDEMU_STEPS	15
#define	HALMAC_88XX_TRANS_CARDEMU_TO_PDN_STEPS	15
#define	HALMAC_88XX_TRANS_PDN_TO_CARDEMU_STEPS	15
#define	HALMAC_88XX_TRANS_ACT_TO_LPS_STEPS		20
#define	HALMAC_88XX_TRANS_LPS_TO_ACT_STEPS		15
#define	HALMAC_88XX_TRANS_END_STEPS				1


#define RTL88XX_TRANS_CARDEMU_TO_ACT														\
	/* format */																\
	/* { offset, cut_msk, fab_msk|interface_msk, base|cmd, msk, value }, // comments here*/								\
	{0x0020, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_USB_MSK|HALMAC_PWR_INTF_SDIO_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, BIT(0), BIT(0)}, /*0x20[0] = 1b'1 enable LDOA12 MACRO block for all interface*/   \
	{0x0067, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_USB_MSK|HALMAC_PWR_INTF_SDIO_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, BIT(4), 0}, /*0x67[0] = 0 to disable BT_GPS_SEL pins*/	\
	{0x0001, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_USB_MSK|HALMAC_PWR_INTF_SDIO_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_DELAY, 1, HALMAC_PWRSEQ_DELAY_MS},/*Delay 1ms*/   \
	{0x0000, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_USB_MSK|HALMAC_PWR_INTF_SDIO_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, BIT(5), 0}, /*0x00[5] = 1b'0 release analog Ips to digital ,1:isolation*/   \
	{0x0005, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_ALL_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, (BIT(4)|BIT(3)|BIT(2)), 0},/* disable SW LPS 0x04[10]=0 and WLSUS_EN 0x04[12:11]=0*/	\
	{0x0075, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_PCI_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, BIT(0) , BIT(0)},/* Disable USB suspend */	\
	{0x0004, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_PCI_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, BIT(3) , BIT(3)},/* enabled usb resume */	\
	{0x0004, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_PCI_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, BIT(3) , 0},/* disable usb resume */	\
	{0x0006, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_ALL_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_POLLING, BIT(1), BIT(1)},/* wait till 0x04[17] = 1    power ready*/	\
	{0x0075, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_PCI_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, BIT(0) , 0},/* Enable USB suspend */	\
	{0x0006, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_ALL_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, BIT(0), BIT(0)},/* release WLON reset  0x04[16]=1*/	\
	{0x0005, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_ALL_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, BIT(7), 0},/* disable HWPDN 0x04[15]=0*/	\
	{0x0005, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_ALL_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, (BIT(4)|BIT(3)), 0},/* disable WL suspend*/	\
	{0x0005, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_ALL_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, BIT(0), BIT(0)},/* polling until return 0*/	\
	{0x0005, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_ALL_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_POLLING, BIT(0), 0},/**/	\
	{0x0020, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_ALL_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, BIT(3), BIT(3)},/*Enable XTAL_CLK*/

#define RTL88XX_TRANS_ACT_TO_CARDEMU													\
	/* format */																\
	/* { offset, cut_msk, fab_msk|interface_msk, base|cmd, msk, value }, // comments here*/								\
	{0x001F, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_ALL_MSK, HALMAC_PWR_BASEADDR_MAC, HALMAC_PWR_CMD_WRITE, 0xFF, 0},/*0x1F[7:0] = 0 turn off RF*/	\
	{0x0049, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_ALL_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, BIT(1), 0},/*Enable rising edge triggering interrupt*/ \
	{0x0006, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_ALL_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, BIT(0), BIT(0)},/* release WLON reset  0x04[16]=1*/	\
	{0x0002, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_ALL_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, BIT(1), 0},/* Whole BB is reset */	\
	{0x0005, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_ALL_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, BIT(1), BIT(1)}, /*0x04[9] = 1 turn off MAC by HW state machine*/	\
	{0x0005, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_ALL_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_POLLING, BIT(1), 0}, /*wait till 0x04[9] = 0 polling until return 0 to disable*/	\
	{0x0020, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_ALL_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, BIT(3), 0},/* XTAL_CLK gated*/	\
	{0x0000, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_USB_MSK|HALMAC_PWR_INTF_SDIO_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, BIT(5), BIT(5)}, /*0x00[5] = 1b'1 analog Ips to digital ,1:isolation*/

#define RTL88XX_TRANS_CARDEMU_TO_SUS													\
	/* format */																\
	/* { offset, cut_msk, fab_msk|interface_msk, base|cmd, msk, value }, // comments here*/								\
	{0x0005, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_PCI_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, BIT(4)|BIT(3), (BIT(4)|BIT(3))}, /*0x04[12:11] = 2b'11 enable WL suspend for PCIe*/	\
	{0x0005, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_USB_MSK|HALMAC_PWR_INTF_SDIO_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, BIT(3)|BIT(4), BIT(3)}, /*0x04[12:11] = 2b'01 enable WL suspend*/	\
	{0x0007, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_SDIO_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, 0xFF, 0x20}, /*0x07[7:0] = 0x20 SDIO SOP option to disable BG/MB/ACK/SWR*/   \
	{0x0005, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_PCI_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, BIT(3)|BIT(4), BIT(3)|BIT(4)}, /*0x04[12:11] = 2b'11 enable WL suspend for PCIe*/	\
	{0x0086, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_SDIO_MSK,HALMAC_PWR_BASEADDR_SDIO,HALMAC_PWR_CMD_WRITE, BIT(0), BIT(0)}, /*Set SDIO suspend local register*/	\
	{0x0086, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_SDIO_MSK,HALMAC_PWR_BASEADDR_SDIO,HALMAC_PWR_CMD_POLLING, BIT(1), 0}, /*wait power state to suspend*/

#define RTL88XX_TRANS_SUS_TO_CARDEMU													\
	/* format */																\
	/* { offset, cut_msk, fab_msk|interface_msk, base|cmd, msk, value }, // comments here*/								\
	{0x0005, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_ALL_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, BIT(3) | BIT(7), 0}, /*clear suspend enable and power down enable*/	\
	{0x0086, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_SDIO_MSK,HALMAC_PWR_BASEADDR_SDIO,HALMAC_PWR_CMD_WRITE, BIT(0), 0}, /*Set SDIO suspend local register*/	\
	{0x0086, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_SDIO_MSK,HALMAC_PWR_BASEADDR_SDIO,HALMAC_PWR_CMD_POLLING, BIT(1), BIT(1)}, /*wait power state to suspend*/\
	{0x0005, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_ALL_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, BIT(3)|BIT(4), 0}, /*0x04[12:11] = 2b'01enable WL suspend*/

#define RTL88XX_TRANS_CARDEMU_TO_CARDDIS													\
	/* format */																\
	/* { offset, cut_msk, fab_msk|interface_msk, base|cmd, msk, value }, // comments here*/								\
	{0x0007, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_SDIO_MSK, HALMAC_PWR_BASEADDR_MAC, HALMAC_PWR_CMD_WRITE, 0xFF, 0x20}, /*0x07=0x20 , SOP option to disable BG/MB*/	\
	{0x0005, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_USB_MSK|HALMAC_PWR_INTF_SDIO_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, BIT(3)|BIT(4), BIT(3)}, /*0x04[12:11] = 2b'01 enable WL suspend*/	\
	{0x0005, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_PCI_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, BIT(2), BIT(2)}, /*0x04[10] = 1, enable SW LPS*/	\
    {0x004A, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_USB_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, BIT(0), 1}, /*0x48[16] = 1 to enable GPIO9 as EXT WAKEUP*/   \
	{0x0086, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_SDIO_MSK,HALMAC_PWR_BASEADDR_SDIO,HALMAC_PWR_CMD_WRITE, BIT(0), BIT(0)}, /*Set SDIO suspend local register*/	\
	{0x0086, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_SDIO_MSK,HALMAC_PWR_BASEADDR_SDIO,HALMAC_PWR_CMD_POLLING, BIT(1), 0}, /*wait power state to suspend*/	\
	{0x0090, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_USB_MSK|HALMAC_PWR_INTF_PCI_MSK, HALMAC_PWR_BASEADDR_MAC, HALMAC_PWR_CMD_WRITE, BIT(1), 0}, /*0x90[1]=0 , disable 32k clock*/	\
	{0x0044, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_SDIO_MSK, HALMAC_PWR_BASEADDR_SDIO, HALMAC_PWR_CMD_WRITE, 0xFF, 0}, /*0x90[1]=0 , disable 32k clock by indirect access*/	\
	{0x0040, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_SDIO_MSK, HALMAC_PWR_BASEADDR_SDIO, HALMAC_PWR_CMD_WRITE, 0xFF, 0x90}, /*0x90[1]=0 , disable 32k clock by indirect access*/	\
	{0x0041, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_SDIO_MSK, HALMAC_PWR_BASEADDR_SDIO, HALMAC_PWR_CMD_WRITE, 0xFF, 0x00}, /*0x90[1]=0 , disable 32k clock by indirect access*/	\
	{0x0042, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_SDIO_MSK, HALMAC_PWR_BASEADDR_SDIO, HALMAC_PWR_CMD_WRITE, 0xFF, 0x04}, /*0x90[1]=0 , disable 32k clock by indirect access*/	

#define RTL88XX_TRANS_CARDDIS_TO_CARDEMU													\
	/* format */																\
	/* { offset, cut_msk, fab_msk|interface_msk, base|cmd, msk, value }, // comments here*/								\
	{0x0005, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_ALL_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, BIT(3) | BIT(7), 0}, /*clear suspend enable and power down enable*/	\
	{0x0086, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_SDIO_MSK,HALMAC_PWR_BASEADDR_SDIO,HALMAC_PWR_CMD_WRITE, BIT(0), 0}, /*Set SDIO suspend local register*/	\
	{0x0086, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_SDIO_MSK,HALMAC_PWR_BASEADDR_SDIO,HALMAC_PWR_CMD_POLLING, BIT(1), BIT(1)}, /*wait power state to suspend*/\
	{0x004A, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_USB_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, BIT(0), 0}, /*0x48[16] = 0 to disable GPIO9 as EXT WAKEUP*/   \
	{0x0005, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_ALL_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, BIT(3)|BIT(4), 0}, /*0x04[12:11] = 2b'01enable WL suspend*/\
	{0x0301, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_PCI_MSK, HALMAC_PWR_BASEADDR_MAC, HALMAC_PWR_CMD_WRITE, 0xFF, 0},/*PCIe DMA start*/


#define RTL88XX_TRANS_CARDEMU_TO_PDN												\
	/* format */																\
	/* { offset, cut_msk, fab_msk|interface_msk, base|cmd, msk, value }, // comments here*/								\
	{0x0007, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_SDIO_MSK|HALMAC_PWR_INTF_USB_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, 0xFF, 0x20}, /*0x07[7:0] = 0x20 SOP option to disable BG/MB/ACK/SWR*/   \
	{0x0006, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_ALL_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, BIT(0), 0},/* 0x04[16] = 0*/\
	{0x0005, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_ALL_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, BIT(7), BIT(7)},/* 0x04[15] = 1*/

#define RTL88XX_TRANS_PDN_TO_CARDEMU												\
	/* format */																\
	/* { offset, cut_msk, fab_msk|interface_msk, base|cmd, msk, value }, // comments here*/								\
	{0x0005, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_ALL_MSK, HALMAC_PWR_BASEADDR_MAC, HALMAC_PWR_CMD_WRITE, BIT(7), 0},/* 0x04[15] = 0*/

#define RTL88XX_TRANS_ACT_TO_LPS														\
	/* format */																\
	/* { offset, cut_msk, fab_msk|interface_msk, base|cmd, msk, value }, // comments here*/								\
	{0x0301, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_PCI_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, 0xFF, 0xFF},/*PCIe DMA stop*/	\
	{0x0522, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_ALL_MSK, HALMAC_PWR_BASEADDR_MAC, HALMAC_PWR_CMD_WRITE, 0xFF, 0xFF},/*Tx Pause*/	\
	{0x05F8, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_ALL_MSK, HALMAC_PWR_BASEADDR_MAC, HALMAC_PWR_CMD_POLLING, 0xFF, 0},/*Should be zero if no packet is transmitting*/	\
	{0x05F9, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_ALL_MSK, HALMAC_PWR_BASEADDR_MAC, HALMAC_PWR_CMD_POLLING, 0xFF, 0},/*Should be zero if no packet is transmitting*/	\
	{0x05FA, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_ALL_MSK, HALMAC_PWR_BASEADDR_MAC, HALMAC_PWR_CMD_POLLING, 0xFF, 0},/*Should be zero if no packet is transmitting*/	\
	{0x05FB, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_ALL_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_POLLING, 0xFF, 0},/*Should be zero if no packet is transmitting*/	\
	{0x0002, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_ALL_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, BIT(0), 0},/*CCK and OFDM are disabled,and clock are gated*/	\
	{0x0002, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_ALL_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_DELAY, 0, HALMAC_PWRSEQ_DELAY_US},/*Delay 1us*/	\
	{0x0002, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_ALL_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, BIT(1), 0},/*Whole BB is reset*/	\
	{0x0100, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_ALL_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, 0xFF, 0x03},/*Reset MAC TRX*/	\
	{0x0101, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_ALL_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, BIT(1), 0},/*check if removed later*/	\
	{0x0093, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_SDIO_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, 0xFF, 0x00},/*When driver enter Sus/ Disable, enable LOP for BT*/	\
	{0x0553, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_ALL_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, BIT(5), BIT(5)},/*Respond TxOK to scheduler*/


#define RTL88XX_TRANS_LPS_TO_ACT															\
	/* format */																\
	/* { offset, cut_msk, fab_msk|interface_msk, base|cmd, msk, value }, // comments here*/								\
	{0x0080, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_SDIO_MSK,HALMAC_PWR_BASEADDR_SDIO,HALMAC_PWR_CMD_WRITE, 0xFF, 0x84}, /*SDIO RPWM*/\
	{0xFE58, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_USB_MSK, HALMAC_PWR_BASEADDR_MAC, HALMAC_PWR_CMD_WRITE, 0xFF, 0x84}, /*USB RPWM*/\
	{0x0361, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_PCI_MSK, HALMAC_PWR_BASEADDR_MAC, HALMAC_PWR_CMD_WRITE, 0xFF, 0x84}, /*PCIe RPWM*/\
	{0x0002, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_ALL_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_DELAY, 0, HALMAC_PWRSEQ_DELAY_MS}, /*Delay*/\
	{0x0008, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_ALL_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, BIT(4), 0}, /*.	0x08[4] = 0		 switch TSF to 40M*/\
	{0x0109, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_ALL_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_POLLING, BIT(7), 0}, /*Polling 0x109[7]=0  TSF in 40M*/\
	{0x0029, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_ALL_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, BIT(6)|BIT(7), 0}, /*.	0x29[7:6] = 2b'00	 enable BB clock*/\
	{0x0101, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_ALL_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, BIT(1), BIT(1)}, /*.	0x101[1] = 1*/\
	{0x0100, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_ALL_MSK, HALMAC_PWR_BASEADDR_MAC, HALMAC_PWR_CMD_WRITE, 0xFF, 0xFF}, /*.	0x100[7:0] = 0xFF	 enable WMAC TRX*/\
	{0x0002, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_ALL_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, BIT(1)|BIT(0), BIT(1)|BIT(0)}, /*.	0x02[1:0] = 2b'11	 enable BB macro*/\
	{0x0522, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_ALL_MSK,HALMAC_PWR_BASEADDR_MAC,HALMAC_PWR_CMD_WRITE, 0xFF, 0}, /*.	0x522 = 0*/

#define RTL88XX_TRANS_END															\
	/* format */																\
	/* { offset, cut_msk, fab_msk|interface_msk, base|cmd, msk, value }, // comments here*/								\
	{0xFFFF, HALMAC_PWR_CUT_ALL_MSK, HALMAC_PWR_FAB_ALL_MSK, HALMAC_PWR_INTF_ALL_MSK,0,HALMAC_PWR_CMD_END, 0, 0}, //


extern HALMAC_WLAN_PWR_CFG halmac_88xx_power_on_flow[HALMAC_88XX_TRANS_CARDEMU_TO_ACT_STEPS + HALMAC_88XX_TRANS_END_STEPS];
extern HALMAC_WLAN_PWR_CFG halmac_88xx_radio_off_flow[HALMAC_88XX_TRANS_ACT_TO_CARDEMU_STEPS + HALMAC_88XX_TRANS_END_STEPS];
extern HALMAC_WLAN_PWR_CFG halmac_88xx_card_disable_flow[HALMAC_88XX_TRANS_ACT_TO_CARDEMU_STEPS + HALMAC_88XX_TRANS_CARDEMU_TO_PDN_STEPS+HALMAC_88XX_TRANS_END_STEPS];
extern HALMAC_WLAN_PWR_CFG halmac_88xx_card_enable_flow[HALMAC_88XX_TRANS_ACT_TO_CARDEMU_STEPS + HALMAC_88XX_TRANS_CARDEMU_TO_PDN_STEPS+HALMAC_88XX_TRANS_END_STEPS];
extern HALMAC_WLAN_PWR_CFG halmac_88xx_suspend_flow[HALMAC_88XX_TRANS_ACT_TO_CARDEMU_STEPS + HALMAC_88XX_TRANS_CARDEMU_TO_SUS_STEPS+HALMAC_88XX_TRANS_END_STEPS];
extern HALMAC_WLAN_PWR_CFG halmac_88xx_resume_flow[HALMAC_88XX_TRANS_ACT_TO_CARDEMU_STEPS + HALMAC_88XX_TRANS_CARDEMU_TO_SUS_STEPS+HALMAC_88XX_TRANS_END_STEPS];
extern HALMAC_WLAN_PWR_CFG halmac_88xx_hwpdn_flow[HALMAC_88XX_TRANS_ACT_TO_CARDEMU_STEPS + HALMAC_88XX_TRANS_CARDEMU_TO_PDN_STEPS+HALMAC_88XX_TRANS_END_STEPS];
extern HALMAC_WLAN_PWR_CFG halmac_88xx_enter_lps_flow[HALMAC_88XX_TRANS_ACT_TO_LPS_STEPS + HALMAC_88XX_TRANS_END_STEPS];
extern HALMAC_WLAN_PWR_CFG halmac_88xx_leave_lps_flow[HALMAC_88XX_TRANS_LPS_TO_ACT_STEPS + HALMAC_88XX_TRANS_END_STEPS];

#endif

