#include "halmac_88xx_cfg.h"
#if HALMAC_PLATFORM_WINDOWS == 1 
#include "MP_Precomp.h" 
#endif

/**
* halmac_init_pcie_cfg_88xx() - init PCIE related register
* @pHalmac_adapter
* Author : KaiYuan Chang
* Return : HALMAC_RET_STATUS
*/
HALMAC_RET_STATUS
halmac_init_pcie_cfg_88xx(
	IN PHALMAC_ADAPTER	pHalmac_adapter
)
{
	VOID *pDriver_adapter = NULL;

	if (HALMAC_RET_SUCCESS != halmac_adapter_validate(pHalmac_adapter))
		return HALMAC_RET_ADAPTER_INVALID;

	if (HALMAC_RET_SUCCESS != halmac_api_validate(pHalmac_adapter))
		return HALMAC_RET_API_INVALID;

	halmac_api_record_id(pHalmac_adapter, HALMAC_API_INIT_PCIE_CFG);

	pDriver_adapter =  pHalmac_adapter->pDriver_adapter;

	PLATFORM_MSG_PRINT(pDriver_adapter, HALMAC_MSG_INIT, HALMAC_DBG_TRACE, "halmac_init_pcie_cfg_88xx ==========>\n");

	PLATFORM_MSG_PRINT(pDriver_adapter, HALMAC_MSG_INIT, HALMAC_DBG_TRACE, "halmac_init_pcie_cfg_88xx <==========\n");

	return HALMAC_RET_SUCCESS;
}

/**
* halmac_deinit_pcie_cfg_88xx() - deinit PCIE related register
* @pHalmac_adapter
* Author : KaiYuan Chang
* Return : HALMAC_RET_STATUS
*/
HALMAC_RET_STATUS
halmac_deinit_pcie_cfg_88xx(
	IN PHALMAC_ADAPTER	pHalmac_adapter
)
{
	VOID *pDriver_adapter = NULL;

	if (HALMAC_RET_SUCCESS != halmac_adapter_validate(pHalmac_adapter))
		return HALMAC_RET_ADAPTER_INVALID;
	
	if (HALMAC_RET_SUCCESS != halmac_api_validate(pHalmac_adapter))
		return HALMAC_RET_API_INVALID;	

	halmac_api_record_id(pHalmac_adapter, HALMAC_API_DEINIT_PCIE_CFG);

	pDriver_adapter = pHalmac_adapter->pDriver_adapter;

	PLATFORM_MSG_PRINT(pDriver_adapter, HALMAC_MSG_INIT, HALMAC_DBG_TRACE, "halmac_deinit_pcie_cfg_88xx ==========>\n");

	PLATFORM_MSG_PRINT(pDriver_adapter, HALMAC_MSG_INIT, HALMAC_DBG_TRACE, "halmac_deinit_pcie_cfg_88xx <==========\n");

	return HALMAC_RET_SUCCESS;
}

/**
* halmac_cfg_rx_aggregation_88xx_pcie() - config rx aggregation
* @pHalmac_adapter
* @halmac_rx_agg_mode
* Author : KaiYuan Chang/Ivan Lin
* Return : HALMAC_RET_STATUS
*/
HALMAC_RET_STATUS
halmac_cfg_rx_aggregation_88xx_pcie(
	IN PHALMAC_ADAPTER pHalmac_adapter,
	IN HALMAC_RX_AGG_MODE halmac_rx_agg_mode
)
{	
	VOID *pDriver_adapter = NULL;
	
	if (HALMAC_RET_SUCCESS != halmac_adapter_validate(pHalmac_adapter))
		return HALMAC_RET_ADAPTER_INVALID;	

	if (HALMAC_RET_SUCCESS != halmac_api_validate(pHalmac_adapter))
		return HALMAC_RET_API_INVALID;

	halmac_api_record_id(pHalmac_adapter, HALMAC_API_CFG_RX_AGGREGATION);

	pDriver_adapter =  pHalmac_adapter->pDriver_adapter;
	
	PLATFORM_MSG_PRINT(pDriver_adapter, HALMAC_MSG_INIT, HALMAC_DBG_TRACE, "halmac_cfg_rx_aggregation_88xx_pcie ==========>\n");		

	PLATFORM_MSG_PRINT(pDriver_adapter, HALMAC_MSG_INIT, HALMAC_DBG_TRACE, "halmac_cfg_rx_aggregation_88xx_pcie <==========\n");

	return HALMAC_RET_SUCCESS;
}

/**
* halmac_reg_read_8_pcie() - read 1byte register
* @pHalmac_adapter
* @halmac_offset
* Author : KaiYuan Chang/Ivan Lin
* Return : HALMAC_RET_STATUS
*/
u8 
halmac_reg_read_8_pcie(
	IN PHALMAC_ADAPTER	pHalmac_adapter,
	IN u32 halmac_offset
)
{
	VOID *pDriver_adapter = NULL;
	PHALMAC_API pHalmac_api;

	if (HALMAC_RET_SUCCESS != halmac_adapter_validate(pHalmac_adapter))
		return HALMAC_RET_ADAPTER_INVALID;
	
	if (HALMAC_RET_SUCCESS != halmac_api_validate(pHalmac_adapter))
		return HALMAC_RET_API_INVALID;
	
	pDriver_adapter = pHalmac_adapter->pDriver_adapter;
	pHalmac_api = (PHALMAC_API)pHalmac_adapter->pHalmac_api;

	return PLATFORM_REG_READ_8(pDriver_adapter, halmac_offset);
}

/**
* halmac_reg_write_8_pcie() - write 1byte register
* @pHalmac_adapter
* @halmac_offset
* @halmac_data
* Author : KaiYuan Chang/Ivan Lin
* Return : HALMAC_RET_STATUS
*/
HALMAC_RET_STATUS 
halmac_reg_write_8_pcie(
	IN PHALMAC_ADAPTER pHalmac_adapter,
	IN u32 halmac_offset,
	IN u8 halmac_data
)
{
	VOID *pDriver_adapter = NULL;
	PHALMAC_API pHalmac_api;

	if (HALMAC_RET_SUCCESS != halmac_adapter_validate(pHalmac_adapter))
		return HALMAC_RET_ADAPTER_INVALID;
	
	if (HALMAC_RET_SUCCESS != halmac_api_validate(pHalmac_adapter))
		return HALMAC_RET_API_INVALID;
	
	pDriver_adapter = pHalmac_adapter->pDriver_adapter;
	pHalmac_api = (PHALMAC_API)pHalmac_adapter->pHalmac_api;
	
	PLATFORM_REG_WRITE_8(pDriver_adapter,  halmac_offset, halmac_data);

	return HALMAC_RET_SUCCESS;
}

/**
* halmac_reg_read_16_pcie() - read 2byte register
* @pHalmac_adapter
* @halmac_offset
* Author : KaiYuan Chang/Ivan Lin
* Return : HALMAC_RET_STATUS
*/
u16 
halmac_reg_read_16_pcie(
	IN PHALMAC_ADAPTER pHalmac_adapter,
	IN u32 halmac_offset
)
{
	VOID *pDriver_adapter = NULL;
	PHALMAC_API pHalmac_api;
	
	if (HALMAC_RET_SUCCESS != halmac_adapter_validate(pHalmac_adapter))
		return HALMAC_RET_ADAPTER_INVALID;
	
	if (HALMAC_RET_SUCCESS != halmac_api_validate(pHalmac_adapter))
		return HALMAC_RET_API_INVALID;

	pDriver_adapter = pHalmac_adapter->pDriver_adapter;
	pHalmac_api = (PHALMAC_API)pHalmac_adapter->pHalmac_api;

	return PLATFORM_REG_READ_16(pDriver_adapter,  halmac_offset);;
}

/**
* halmac_reg_write_16_pcie() - write 2byte register
* @pHalmac_adapter
* @halmac_offset
* @halmac_data
* Author : KaiYuan Chang/Ivan Lin
* Return : HALMAC_RET_STATUS
*/
HALMAC_RET_STATUS 
halmac_reg_write_16_pcie(
	IN PHALMAC_ADAPTER pHalmac_adapter,
	IN u32 halmac_offset,
	IN u16 halmac_data
)
{
	VOID *pDriver_adapter = NULL;
	PHALMAC_API pHalmac_api;

	if (HALMAC_RET_SUCCESS != halmac_adapter_validate(pHalmac_adapter))
		return HALMAC_RET_ADAPTER_INVALID;
	
	if (HALMAC_RET_SUCCESS != halmac_api_validate(pHalmac_adapter))
		return HALMAC_RET_API_INVALID;
	
	pDriver_adapter = pHalmac_adapter->pDriver_adapter;
	pHalmac_api = (PHALMAC_API)pHalmac_adapter->pHalmac_api;
	
	PLATFORM_REG_WRITE_16(pDriver_adapter,  halmac_offset, halmac_data);
	
	return HALMAC_RET_SUCCESS;
}

/**
* halmac_reg_read_32_pcie() - read 4byte register
* @pHalmac_adapter
* @halmac_offset
* Author : KaiYuan Chang/Ivan Lin
* Return : HALMAC_RET_STATUS
*/
u32 
halmac_reg_read_32_pcie(
	IN PHALMAC_ADAPTER	pHalmac_adapter,
	IN u32 halmac_offset
)
{
	VOID *pDriver_adapter = NULL;
	PHALMAC_API pHalmac_api;

	if (HALMAC_RET_SUCCESS != halmac_adapter_validate(pHalmac_adapter))
		return HALMAC_RET_ADAPTER_INVALID;
	
	if (HALMAC_RET_SUCCESS != halmac_api_validate(pHalmac_adapter))
		return HALMAC_RET_API_INVALID;
	
	pDriver_adapter = pHalmac_adapter->pDriver_adapter;
	pHalmac_api = (PHALMAC_API)pHalmac_adapter->pHalmac_api;

	return PLATFORM_REG_READ_32(pDriver_adapter,  halmac_offset);
}

/**
* halmac_reg_write_32_pcie() - write 4byte register
* @pHalmac_adapter
* @halmac_offset
* @halmac_data
* Author : KaiYuan Chang/Ivan Lin
* Return : HALMAC_RET_STATUS
*/
HALMAC_RET_STATUS 
halmac_reg_write_32_pcie(
	IN PHALMAC_ADAPTER	pHalmac_adapter,
	IN u32 halmac_offset,
	IN u32 halmac_data
)
{
	VOID *pDriver_adapter = NULL;
	PHALMAC_API pHalmac_api;

	if (HALMAC_RET_SUCCESS != halmac_adapter_validate(pHalmac_adapter))
		return HALMAC_RET_ADAPTER_INVALID;
	
	if (HALMAC_RET_SUCCESS != halmac_api_validate(pHalmac_adapter))
		return HALMAC_RET_API_INVALID;
	
	pDriver_adapter = pHalmac_adapter->pDriver_adapter;
	pHalmac_api = (PHALMAC_API)pHalmac_adapter->pHalmac_api;
	
	PLATFORM_REG_WRITE_32(pDriver_adapter,  halmac_offset, halmac_data);

	return HALMAC_RET_SUCCESS;
}

