/*++
Copyright (c) Realtek Semiconductor Corp. All rights reserved.

Module Name:
	Hal8881APwrSeqCmd.c
	
Abstract:
	This file includes all kinds of Power Action event for RTL8881A and 
	corresponding hardware configurtions which are released from HW SD.
	    
Major Change History:
	When       Who               What
	---------- ---------------   -------------------------------
	2015-04-14 Eric            Create.
	
--*/

#if !defined(__ECOS) && !defined(CPTCFG_CFG80211_MODULE)
#include "HalPrecomp.h"
#else
#include "../../HalPrecomp.h"
#endif

// TODO: Filen, code below is necessary to match with 8881A setting


/* 
    drivers should parse below arrays and do the corresponding actions
*/
//3 Power on  Array
WLAN_PWR_CFG rtl8197F_power_on_flow[RTL8197F_TRANS_CARDEMU_TO_ACT_STEPS+RTL8197F_TRANS_END_STEPS]=
{
	RTL8197F_TRANS_CARDEMU_TO_ACT
	RTL8197F_TRANS_END
};

//3Radio off GPIO Array
WLAN_PWR_CFG rtl8197F_radio_off_flow[RTL8197F_TRANS_ACT_TO_CARDEMU_STEPS+RTL8197F_TRANS_END_STEPS]=
{
	RTL8197F_TRANS_ACT_TO_CARDEMU
	RTL8197F_TRANS_END
};

//3Card Disable Array
WLAN_PWR_CFG rtl8197F_card_disable_flow[RTL8197F_TRANS_ACT_TO_CARDEMU_STEPS+RTL8197F_TRANS_CARDEMU_TO_PDN_STEPS+RTL8197F_TRANS_END_STEPS]=
{
	RTL8197F_TRANS_ACT_TO_CARDEMU
	RTL8197F_TRANS_CARDEMU_TO_CARDDIS
	RTL8197F_TRANS_END
};

//3 Card Enable Array
WLAN_PWR_CFG rtl8197F_card_enable_flow[RTL8197F_TRANS_CARDDIS_TO_CARDEMU_STEPS+RTL8197F_TRANS_CARDEMU_TO_ACT_STEPS+RTL8197F_TRANS_END_STEPS]=
{
    //RTL8197F_TRANS_CARDDIS_TO_CARDEMU
    RTL8197F_TRANS_96FSOC_POWER_ON
	//RTL8197F_TRANS_CARDEMU_TO_ACT		
	RTL8197F_TRANS_END
};

//3Suspend Array
WLAN_PWR_CFG rtl8197F_suspend_flow[RTL8197F_TRANS_ACT_TO_CARDEMU_STEPS+RTL8197F_TRANS_CARDEMU_TO_SUS_STEPS+RTL8197F_TRANS_END_STEPS]=
{
	RTL8197F_TRANS_ACT_TO_CARDEMU
	RTL8197F_TRANS_CARDEMU_TO_SUS
	RTL8197F_TRANS_END
};

//3 Resume Array
WLAN_PWR_CFG rtl8197F_resume_flow[RTL8197F_TRANS_ACT_TO_CARDEMU_STEPS+RTL8197F_TRANS_CARDEMU_TO_SUS_STEPS+RTL8197F_TRANS_END_STEPS]=
{
	RTL8197F_TRANS_SUS_TO_CARDEMU
	RTL8197F_TRANS_CARDEMU_TO_ACT
	RTL8197F_TRANS_END
};



//3HWPDN Array
WLAN_PWR_CFG rtl8197F_hwpdn_flow[RTL8197F_TRANS_ACT_TO_CARDEMU_STEPS+RTL8197F_TRANS_CARDEMU_TO_PDN_STEPS+RTL8197F_TRANS_END_STEPS]=
{
	RTL8197F_TRANS_ACT_TO_CARDEMU
	RTL8197F_TRANS_CARDEMU_TO_PDN		
	RTL8197F_TRANS_END
};

//3 Enter LPS 
WLAN_PWR_CFG rtl8197F_enter_lps_flow[RTL8197F_TRANS_ACT_TO_LPS_STEPS+RTL8197F_TRANS_END_STEPS]=
{
	//FW behavior
	RTL8197F_TRANS_ACT_TO_LPS	
	RTL8197F_TRANS_END
};

//3 Leave LPS 
WLAN_PWR_CFG rtl8197F_leave_lps_flow[RTL8197F_TRANS_LPS_TO_ACT_STEPS+RTL8197F_TRANS_END_STEPS]=
{
	//FW behavior
	RTL8197F_TRANS_LPS_TO_ACT
	RTL8197F_TRANS_END
};

