/****************************************************************************** 
* 
* Copyright(c) 2007 - 2011 Realtek Corporation. All rights reserved. 
* 
* This program is free software; you can redistribute it and/or modify it 
* under the terms of version 2 of the GNU General Public License as 
* published by the Free Software Foundation. 
* 
* This program is distributed in the hope that it will be useful, but WITHOUT 
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
* FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for 
* more details. 
* 
* You should have received a copy of the GNU General Public License along with 
* this program; if not, write to the Free Software Foundation, Inc., 
* 51 Franklin Street, Fifth Floor, Boston, MA 02110, USA 
* 
* 
******************************************************************************/

/*Image2HeaderVersion: 2.22*/
#include "mp_precomp.h"
#include "../phydm_precomp.h"

#if (RTL8822B_SUPPORT == 1)
static BOOLEAN
CheckPositive(
	IN  PDM_ODM_T     pDM_Odm,
	IN  const u4Byte  Condition1,
	IN  const u4Byte  Condition2,
	IN	const u4Byte  Condition3,
	IN	const u4Byte  Condition4
)
{
	u1Byte    _BoardType = ((pDM_Odm->BoardType & BIT4) >> 4) << 0 | /* _GLNA*/
				((pDM_Odm->BoardType & BIT3) >> 3) << 1 | /* _GPA*/ 
				((pDM_Odm->BoardType & BIT7) >> 7) << 2 | /* _ALNA*/
				((pDM_Odm->BoardType & BIT6) >> 6) << 3 | /* _APA */
				((pDM_Odm->BoardType & BIT2) >> 2) << 4;  /* _BT*/  

	u4Byte	cond1   = Condition1, cond2 = Condition2, cond3 = Condition3, cond4 = Condition4;
	u4Byte    driver1 = pDM_Odm->CutVersion       << 24 | 
				(pDM_Odm->SupportInterface & 0xF0) << 16 | 
				pDM_Odm->SupportPlatform  << 16 | 
				pDM_Odm->PackageType      << 12 | 
				(pDM_Odm->SupportInterface & 0x0F) << 8  |
				_BoardType;

	u4Byte    driver2 = (pDM_Odm->TypeGLNA & 0xFF) <<  0 |  
				(pDM_Odm->TypeGPA & 0xFF)  <<  8 | 
				(pDM_Odm->TypeALNA & 0xFF) << 16 | 
				(pDM_Odm->TypeAPA & 0xFF)  << 24; 

u4Byte    driver3 = 0;

	u4Byte    driver4 = (pDM_Odm->TypeGLNA & 0xFF00) >>  8 |
				(pDM_Odm->TypeGPA & 0xFF00) |
				(pDM_Odm->TypeALNA & 0xFF00) << 8 |
				(pDM_Odm->TypeAPA & 0xFF00)  << 16;

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_TRACE, 
	("===> CheckPositive (cond1, cond2, cond3, cond4) = (0x%X 0x%X 0x%X 0x%X)\n", cond1, cond2, cond3, cond4));
	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_TRACE, 
	("===> CheckPositive (driver1, driver2, driver3, driver4) = (0x%X 0x%X 0x%X 0x%X)\n", driver1, driver2, driver3, driver4));

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_TRACE, 
	("	(Platform, Interface) = (0x%X, 0x%X)\n", pDM_Odm->SupportPlatform, pDM_Odm->SupportInterface));
	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_TRACE, 
	("	(Board, Package) = (0x%X, 0x%X)\n", pDM_Odm->BoardType, pDM_Odm->PackageType));


	/*============== Value Defined Check ===============*/
	/*QFN Type [15:12] and Cut Version [27:24] need to do value check*/
	
	if (((cond1 & 0x0000F000) != 0) && ((cond1 & 0x0000F000) != (driver1 & 0x0000F000)))
		return FALSE;
	if (((cond1 & 0x0F000000) != 0) && ((cond1 & 0x0F000000) != (driver1 & 0x0F000000)))
		return FALSE;

	/*=============== Bit Defined Check ================*/
	/* We don't care [31:28] */

	cond1   &= 0x00FF0FFF; 
	driver1 &= 0x00FF0FFF; 

	if ((cond1 & driver1) == cond1) {
		u4Byte bitMask = 0;

		if ((cond1 & 0x0F) == 0) /* BoardType is DONTCARE*/
			return TRUE;

		if ((cond1 & BIT0) != 0) /*GLNA*/
			bitMask |= 0x000000FF;
		if ((cond1 & BIT1) != 0) /*GPA*/
			bitMask |= 0x0000FF00;
		if ((cond1 & BIT2) != 0) /*ALNA*/
			bitMask |= 0x00FF0000;
		if ((cond1 & BIT3) != 0) /*APA*/
			bitMask |= 0xFF000000;

		if (((cond2 & bitMask) == (driver2 & bitMask)) && ((cond4 & bitMask) == (driver4 & bitMask)))  /* BoardType of each RF path is matched*/
			return TRUE;
		else
			return FALSE;
	} else
		return FALSE;
}
static BOOLEAN
CheckNegative(
	IN  PDM_ODM_T     pDM_Odm,
	IN  const u4Byte  Condition1,
	IN  const u4Byte  Condition2
)
{
	return TRUE;
}

/******************************************************************************
*                           RadioA.TXT
******************************************************************************/

u4Byte Array_MP_8822B_RadioA[] = { 
		0x000, 0x00030000,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x001, 0x0004002D,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x0004002D,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x0004002D,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x90002100,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0xA0000000,	0x00000000,
		0x001, 0x00040029,
	0xB0000000,	0x00000000,
		0x018, 0x00010D24,
		0x0EF, 0x00080000,
		0x033, 0x00000002,
		0x03E, 0x0000003F,
		0x03F, 0x000C0F4E,
		0x033, 0x00000001,
		0x03E, 0x00000034,
		0x03F, 0x0004080E,
		0x0EF, 0x00080000,
		0x0DF, 0x00002449,
		0x033, 0x00000024,
		0x03E, 0x0000003F,
		0x03F, 0x00060FDE,
		0x0EF, 0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000025,
		0x03E, 0x00000037,
		0x03F, 0x0006EFCE,
		0x0EF, 0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000026,
		0x03E, 0x00000037,
		0x03F, 0x0005EFCE,
		0x0EF, 0x00000000,
	0x8000200f,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FB0F8,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FB0F8,
	0x90002100,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FB0F8,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FB0F8,
	0xA0000000,	0x00000000,
		0x0B0, 0x000FF0F8,
	0xB0000000,	0x00000000,
		0x0B1, 0x0007DBE4,
		0x0B2, 0x000225D1,
		0x0B3, 0x000FC760,
		0x0B4, 0x00099DD4,
		0x0B5, 0x000400FC,
		0x0B6, 0x000187F0,
		0x0B7, 0x00030018,
		0x0B8, 0x00080800,
		0x0B9, 0x00000000,
		0x0BA, 0x00008000,
		0x0BB, 0x00000000,
		0x0BC, 0x00040000,
		0x0BD, 0x00000000,
		0x0BE, 0x00000000,
		0x0BF, 0x00000000,
		0x0C0, 0x00000000,
		0x0C1, 0x00000000,
		0x0C2, 0x00000000,
		0x0C3, 0x00000000,
		0x0C4, 0x00002402,
		0x0C5, 0x00000009,
		0x0C6, 0x00040299,
		0x0C7, 0x00055555,
		0x0C8, 0x0000C16C,
		0x0C9, 0x0001C140,
		0x0CA, 0x00000000,
		0x0CB, 0x00000000,
		0x0CC, 0x00000000,
		0x0CD, 0x00000000,
		0x0CE, 0x00090C00,
		0x0CF, 0x0006D200,
		0x0DF, 0x00000009,
		0x018, 0x00010524,
		0x089, 0x00000207,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x08A, 0x000FE186,
	0xA0000000,	0x00000000,
		0x08A, 0x000FF186,
	0xB0000000,	0x00000000,
		0x08B, 0x00061E3C,
		0x08C, 0x000112C7,
		0x08D, 0x000F4988,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x08E, 0x00064D40,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x00064D40,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x00064D40,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x00064D40,
	0x90002100,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x00064D40,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x00064D40,
	0xA0000000,	0x00000000,
		0x08E, 0x00064D40,
	0xB0000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000007,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0xA0000000,	0x00000000,
		0x03E, 0x00004000,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x00000006,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0xA0000000,	0x00000000,
		0x03E, 0x00004080,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x00000005,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x03E, 0x00004084,
	0xA0000000,	0x00000000,
		0x03E, 0x000040C8,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x00000004,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x03E, 0x00004108,
	0xA0000000,	0x00000000,
		0x03E, 0x00004190,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x00000003,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x03E, 0x0000490C,
	0xA0000000,	0x00000000,
		0x03E, 0x00004998,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x00000002,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x03E, 0x00005E00,
	0xA0000000,	0x00000000,
		0x03E, 0x00005840,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x00000001,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x03E, 0x00005862,
	0xA0000000,	0x00000000,
		0x03E, 0x000058C2,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x00000000,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x03E, 0x00005948,
	0xA0000000,	0x00000000,
		0x03E, 0x00005930,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x0000000F,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x03E, 0x00004080,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0xA0000000,	0x00000000,
		0x03E, 0x00004000,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x0000000E,
		0x03E, 0x00004080,
		0x03F, 0x000C3186,
		0x033, 0x0000000D,
		0x03E, 0x000040C8,
		0x03F, 0x000C3186,
		0x033, 0x0000000C,
		0x03E, 0x00004190,
		0x03F, 0x000C3186,
		0x033, 0x0000000B,
		0x03E, 0x00004998,
		0x03F, 0x000C3186,
		0x033, 0x0000000A,
		0x03E, 0x00005840,
		0x03F, 0x000C3186,
		0x033, 0x00000009,
		0x03E, 0x000058C2,
		0x03F, 0x000C3186,
		0x033, 0x00000008,
		0x03E, 0x00005930,
		0x03F, 0x000C3186,
		0x033, 0x00000017,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x03E, 0x00004080,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0xA0000000,	0x00000000,
		0x03E, 0x00004000,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x00000016,
		0x03E, 0x00004080,
		0x03F, 0x000C3186,
		0x033, 0x00000015,
		0x03E, 0x000040C8,
		0x03F, 0x000C3186,
		0x033, 0x00000014,
		0x03E, 0x00004190,
		0x03F, 0x000C3186,
		0x033, 0x00000013,
		0x03E, 0x00004998,
		0x03F, 0x000C3186,
		0x033, 0x00000012,
		0x03E, 0x00005840,
		0x03F, 0x000C3186,
		0x033, 0x00000011,
		0x03E, 0x000058C2,
		0x03F, 0x000C3186,
		0x033, 0x00000010,
		0x03E, 0x00005930,
		0x03F, 0x000C3186,
		0x0EF, 0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x03F, 0x0000000E,
	0xA0000000,	0x00000000,
		0x03F, 0x0000000A,
	0xB0000000,	0x00000000,
		0x033, 0x00000001,
		0x03F, 0x00000000,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
		0x018, 0x00000401,
		0x084, 0x00001209,
		0x086, 0x000001A0,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x087, 0x00068080,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x00068080,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x00068080,
	0xA0000000,	0x00000000,
		0x087, 0x000E8180,
	0xB0000000,	0x00000000,
		0x088, 0x00070020,
		0x0DE, 0x00000010,
		0x0EF, 0x00008000,
		0x033, 0x0000000F,
		0x03F, 0x0000003C,
		0x033, 0x0000000E,
		0x03F, 0x00000038,
		0x033, 0x0000000D,
		0x03F, 0x00000030,
		0x033, 0x0000000C,
		0x03F, 0x00000028,
		0x033, 0x0000000B,
		0x03F, 0x00000020,
		0x033, 0x0000000A,
		0x03F, 0x00000018,
		0x033, 0x00000009,
		0x03F, 0x00000010,
		0x033, 0x00000008,
		0x03F, 0x00000008,
		0x033, 0x00000007,
		0x03F, 0x0000003C,
		0x033, 0x00000006,
		0x03F, 0x00000038,
		0x033, 0x00000005,
		0x03F, 0x00000030,
		0x033, 0x00000004,
		0x03F, 0x00000028,
		0x033, 0x00000003,
		0x03F, 0x00000020,
		0x033, 0x00000002,
		0x03F, 0x00000018,
		0x033, 0x00000001,
		0x03F, 0x00000010,
		0x033, 0x00000000,
		0x03F, 0x00000008,
		0x0EF, 0x00000000,
		0x0B8, 0x00080A00,
		0x0B0, 0x000FF0FA,
		0x0CA, 0x00080000,
		0x0C9, 0x0001C141,
		0x0B0, 0x000FF0F8,
		0x018, 0x00018D24,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0x018, 0x00010D24,
		0x01B, 0x00075A40,
		0x0DE, 0x00000012,
		0x01D, 0x00000004,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x061, 0x0005D4A0,
		0x062, 0x0000D203,
		0x063, 0x00000062,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D4A0,
		0x062, 0x0000D203,
		0x063, 0x00000062,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D4A0,
		0x062, 0x0000D203,
		0x063, 0x00000062,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D4A0,
		0x062, 0x0000D203,
		0x063, 0x00000062,
	0x90002100,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D301,
		0x062, 0x0000D303,
		0x063, 0x00000002,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D301,
		0x062, 0x0000D303,
		0x063, 0x00000002,
	0xA0000000,	0x00000000,
		0x061, 0x0005D301,
		0x062, 0x0000D303,
		0x063, 0x00000002,
	0xB0000000,	0x00000000,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000004A0,
		0x030, 0x000014A0,
		0x030, 0x000024A0,
		0x030, 0x000034A0,
		0x030, 0x000044A0,
		0x030, 0x000054A0,
		0x030, 0x000064A0,
		0x030, 0x000074A0,
		0x030, 0x000084A0,
		0x030, 0x000094A0,
		0x030, 0x0000A4A0,
		0x030, 0x0000B4A0,
		0x0EF, 0x00000000,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000004A0,
		0x030, 0x000014A0,
		0x030, 0x000024A0,
		0x030, 0x000034A0,
		0x030, 0x000044A0,
		0x030, 0x000054A0,
		0x030, 0x000064A0,
		0x030, 0x000074A0,
		0x030, 0x000084A0,
		0x030, 0x000094A0,
		0x030, 0x0000A4A0,
		0x030, 0x0000B4A0,
		0x0EF, 0x00000000,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000004A0,
		0x030, 0x000014A0,
		0x030, 0x000024A0,
		0x030, 0x000034A0,
		0x030, 0x000044A0,
		0x030, 0x000054A0,
		0x030, 0x000064A0,
		0x030, 0x000074A0,
		0x030, 0x000084A0,
		0x030, 0x000094A0,
		0x030, 0x0000A4A0,
		0x030, 0x0000B4A0,
		0x0EF, 0x00000000,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000004A0,
		0x030, 0x000014A0,
		0x030, 0x000024A0,
		0x030, 0x000034A0,
		0x030, 0x000044A0,
		0x030, 0x000054A0,
		0x030, 0x000064A0,
		0x030, 0x000074A0,
		0x030, 0x000084A0,
		0x030, 0x000094A0,
		0x030, 0x0000A4A0,
		0x030, 0x0000B4A0,
		0x0EF, 0x00000000,
	0x90002100,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000003A0,
		0x030, 0x000013A0,
		0x030, 0x000023A0,
		0x030, 0x000033A0,
		0x030, 0x00004430,
		0x030, 0x00005430,
		0x030, 0x00006430,
		0x030, 0x00007430,
		0x030, 0x00008372,
		0x030, 0x00009372,
		0x030, 0x0000A372,
		0x030, 0x0000B372,
		0x0EF, 0x00000000,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000003A0,
		0x030, 0x000013A0,
		0x030, 0x000023A0,
		0x030, 0x000033A0,
		0x030, 0x000043A1,
		0x030, 0x000053A1,
		0x030, 0x000063A1,
		0x030, 0x000073A1,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000003A0,
		0x030, 0x000013A0,
		0x030, 0x000023A0,
		0x030, 0x000033A0,
		0x030, 0x000043A1,
		0x030, 0x000053A1,
		0x030, 0x000063A1,
		0x030, 0x000073A1,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x00000203,
		0x030, 0x00001203,
		0x030, 0x00002203,
		0x030, 0x00003203,
		0x030, 0x00004203,
		0x030, 0x00005203,
		0x030, 0x00006203,
		0x030, 0x00007203,
		0x030, 0x00008203,
		0x030, 0x00009203,
		0x030, 0x0000A203,
		0x030, 0x0000B203,
		0x0EF, 0x00000000,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x00000203,
		0x030, 0x00001203,
		0x030, 0x00002203,
		0x030, 0x00003203,
		0x030, 0x00004203,
		0x030, 0x00005203,
		0x030, 0x00006203,
		0x030, 0x00007203,
		0x030, 0x00008203,
		0x030, 0x00009203,
		0x030, 0x0000A203,
		0x030, 0x0000B203,
		0x0EF, 0x00000000,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x00000203,
		0x030, 0x00001203,
		0x030, 0x00002203,
		0x030, 0x00003203,
		0x030, 0x00004203,
		0x030, 0x00005203,
		0x030, 0x00006203,
		0x030, 0x00007203,
		0x030, 0x00008203,
		0x030, 0x00009203,
		0x030, 0x0000A203,
		0x030, 0x0000B203,
		0x0EF, 0x00000000,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x00000203,
		0x030, 0x00001203,
		0x030, 0x00002203,
		0x030, 0x00003203,
		0x030, 0x00004203,
		0x030, 0x00005203,
		0x030, 0x00006203,
		0x030, 0x00007203,
		0x030, 0x00008203,
		0x030, 0x00009203,
		0x030, 0x0000A203,
		0x030, 0x0000B203,
		0x0EF, 0x00000000,
	0x90002100,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
		0x0EF, 0x00000000,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x0EF, 0x00000000,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x0EF, 0x00000000,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x0EF, 0x00000000,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x0EF, 0x00000000,
	0x90002100,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000775,
		0x030, 0x00001343,
		0x030, 0x00002210,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x0EF, 0x00000000,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000775,
		0x030, 0x00001422,
		0x030, 0x00002210,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000775,
		0x030, 0x00001222,
		0x030, 0x00002210,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x0EF, 0x00000800,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000800,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000800,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000800,
	0x90002100,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000800,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000800,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000800,
	0xB0000000,	0x00000000,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000006,
		0x033, 0x00000021,
		0x03F, 0x00000009,
		0x033, 0x00000022,
		0x03F, 0x0000000C,
		0x033, 0x00000023,
		0x03F, 0x00000029,
		0x033, 0x00000024,
		0x03F, 0x0000002C,
		0x033, 0x00000025,
		0x03F, 0x0000004B,
		0x033, 0x00000026,
		0x03F, 0x00000448,
		0x033, 0x00000027,
		0x03F, 0x0000044B,
		0x033, 0x00000028,
		0x03F, 0x0000084B,
		0x033, 0x00000029,
		0x03F, 0x0000086B,
		0x033, 0x0000002A,
		0x03F, 0x0000086E,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000006,
		0x033, 0x00000021,
		0x03F, 0x00000009,
		0x033, 0x00000022,
		0x03F, 0x0000000C,
		0x033, 0x00000023,
		0x03F, 0x00000029,
		0x033, 0x00000024,
		0x03F, 0x0000002C,
		0x033, 0x00000025,
		0x03F, 0x0000004B,
		0x033, 0x00000026,
		0x03F, 0x00000448,
		0x033, 0x00000027,
		0x03F, 0x0000044B,
		0x033, 0x00000028,
		0x03F, 0x0000084B,
		0x033, 0x00000029,
		0x03F, 0x0000086B,
		0x033, 0x0000002A,
		0x03F, 0x0000086E,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000006,
		0x033, 0x00000021,
		0x03F, 0x00000009,
		0x033, 0x00000022,
		0x03F, 0x0000000C,
		0x033, 0x00000023,
		0x03F, 0x00000029,
		0x033, 0x00000024,
		0x03F, 0x0000002C,
		0x033, 0x00000025,
		0x03F, 0x0000004B,
		0x033, 0x00000026,
		0x03F, 0x00000448,
		0x033, 0x00000027,
		0x03F, 0x0000044B,
		0x033, 0x00000028,
		0x03F, 0x0000084B,
		0x033, 0x00000029,
		0x03F, 0x0000086B,
		0x033, 0x0000002A,
		0x03F, 0x0000086E,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000006,
		0x033, 0x00000021,
		0x03F, 0x00000009,
		0x033, 0x00000022,
		0x03F, 0x0000000C,
		0x033, 0x00000023,
		0x03F, 0x00000029,
		0x033, 0x00000024,
		0x03F, 0x0000002C,
		0x033, 0x00000025,
		0x03F, 0x0000004B,
		0x033, 0x00000026,
		0x03F, 0x00000448,
		0x033, 0x00000027,
		0x03F, 0x0000044B,
		0x033, 0x00000028,
		0x03F, 0x0000084B,
		0x033, 0x00000029,
		0x03F, 0x0000086B,
		0x033, 0x0000002A,
		0x03F, 0x0000086E,
	0x90002100,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x0000042B,
		0x033, 0x00000021,
		0x03F, 0x0000082A,
		0x033, 0x00000022,
		0x03F, 0x00000849,
		0x033, 0x00000023,
		0x03F, 0x0000084C,
		0x033, 0x00000024,
		0x03F, 0x00000C4C,
		0x033, 0x00000025,
		0x03F, 0x00000C8A,
		0x033, 0x00000026,
		0x03F, 0x00000C8D,
		0x033, 0x00000027,
		0x03F, 0x00000CEB,
		0x033, 0x00000028,
		0x03F, 0x00000CEE,
		0x033, 0x00000029,
		0x03F, 0x00000CF1,
		0x033, 0x0000002A,
		0x03F, 0x00000CF4,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x0000042B,
		0x033, 0x00000021,
		0x03F, 0x0000082A,
		0x033, 0x00000022,
		0x03F, 0x00000849,
		0x033, 0x00000023,
		0x03F, 0x0000084C,
		0x033, 0x00000024,
		0x03F, 0x00000C4C,
		0x033, 0x00000025,
		0x03F, 0x00000C8A,
		0x033, 0x00000026,
		0x03F, 0x00000C8D,
		0x033, 0x00000027,
		0x03F, 0x00000CEB,
		0x033, 0x00000028,
		0x03F, 0x00000CEE,
		0x033, 0x00000029,
		0x03F, 0x00000CF1,
		0x033, 0x0000002A,
		0x03F, 0x00000CF4,
	0xA0000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x0000042B,
		0x033, 0x00000021,
		0x03F, 0x0000082A,
		0x033, 0x00000022,
		0x03F, 0x00000849,
		0x033, 0x00000023,
		0x03F, 0x0000084C,
		0x033, 0x00000024,
		0x03F, 0x00000C4C,
		0x033, 0x00000025,
		0x03F, 0x00000C8A,
		0x033, 0x00000026,
		0x03F, 0x00000C8D,
		0x033, 0x00000027,
		0x03F, 0x00000CEB,
		0x033, 0x00000028,
		0x03F, 0x00000CEE,
		0x033, 0x00000029,
		0x03F, 0x00000CF1,
		0x033, 0x0000002A,
		0x03F, 0x00000CF4,
	0xB0000000,	0x00000000,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000006,
		0x033, 0x00000061,
		0x03F, 0x00000009,
		0x033, 0x00000062,
		0x03F, 0x0000000C,
		0x033, 0x00000063,
		0x03F, 0x00000029,
		0x033, 0x00000064,
		0x03F, 0x0000002C,
		0x033, 0x00000065,
		0x03F, 0x0000004B,
		0x033, 0x00000066,
		0x03F, 0x00000448,
		0x033, 0x00000067,
		0x03F, 0x0000044B,
		0x033, 0x00000068,
		0x03F, 0x0000084B,
		0x033, 0x00000069,
		0x03F, 0x0000086B,
		0x033, 0x0000006A,
		0x03F, 0x0000086E,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000006,
		0x033, 0x00000061,
		0x03F, 0x00000009,
		0x033, 0x00000062,
		0x03F, 0x0000000C,
		0x033, 0x00000063,
		0x03F, 0x00000029,
		0x033, 0x00000064,
		0x03F, 0x0000002C,
		0x033, 0x00000065,
		0x03F, 0x0000004B,
		0x033, 0x00000066,
		0x03F, 0x00000448,
		0x033, 0x00000067,
		0x03F, 0x0000044B,
		0x033, 0x00000068,
		0x03F, 0x0000084B,
		0x033, 0x00000069,
		0x03F, 0x0000086B,
		0x033, 0x0000006A,
		0x03F, 0x0000086E,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000006,
		0x033, 0x00000061,
		0x03F, 0x00000009,
		0x033, 0x00000062,
		0x03F, 0x0000000C,
		0x033, 0x00000063,
		0x03F, 0x00000029,
		0x033, 0x00000064,
		0x03F, 0x0000002C,
		0x033, 0x00000065,
		0x03F, 0x0000004B,
		0x033, 0x00000066,
		0x03F, 0x00000448,
		0x033, 0x00000067,
		0x03F, 0x0000044B,
		0x033, 0x00000068,
		0x03F, 0x0000084B,
		0x033, 0x00000069,
		0x03F, 0x0000086B,
		0x033, 0x0000006A,
		0x03F, 0x0000086E,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000006,
		0x033, 0x00000061,
		0x03F, 0x00000009,
		0x033, 0x00000062,
		0x03F, 0x0000000C,
		0x033, 0x00000063,
		0x03F, 0x00000029,
		0x033, 0x00000064,
		0x03F, 0x0000002C,
		0x033, 0x00000065,
		0x03F, 0x0000004B,
		0x033, 0x00000066,
		0x03F, 0x00000448,
		0x033, 0x00000067,
		0x03F, 0x0000044B,
		0x033, 0x00000068,
		0x03F, 0x0000084B,
		0x033, 0x00000069,
		0x03F, 0x0000086B,
		0x033, 0x0000006A,
		0x03F, 0x0000086E,
	0x90002100,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x0000042C,
		0x033, 0x00000061,
		0x03F, 0x0000082B,
		0x033, 0x00000062,
		0x03F, 0x0000084A,
		0x033, 0x00000063,
		0x03F, 0x0000084D,
		0x033, 0x00000064,
		0x03F, 0x00000C4D,
		0x033, 0x00000065,
		0x03F, 0x00000C8B,
		0x033, 0x00000066,
		0x03F, 0x00000C8E,
		0x033, 0x00000067,
		0x03F, 0x00000CEC,
		0x033, 0x00000068,
		0x03F, 0x00000CEF,
		0x033, 0x00000069,
		0x03F, 0x00000CF2,
		0x033, 0x0000006A,
		0x03F, 0x00000CF5,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x0000042C,
		0x033, 0x00000061,
		0x03F, 0x0000082B,
		0x033, 0x00000062,
		0x03F, 0x0000084A,
		0x033, 0x00000063,
		0x03F, 0x0000084D,
		0x033, 0x00000064,
		0x03F, 0x00000C4D,
		0x033, 0x00000065,
		0x03F, 0x00000C8B,
		0x033, 0x00000066,
		0x03F, 0x00000C8E,
		0x033, 0x00000067,
		0x03F, 0x00000CEC,
		0x033, 0x00000068,
		0x03F, 0x00000CEF,
		0x033, 0x00000069,
		0x03F, 0x00000CF2,
		0x033, 0x0000006A,
		0x03F, 0x00000CF5,
	0xA0000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x0000042C,
		0x033, 0x00000061,
		0x03F, 0x0000082B,
		0x033, 0x00000062,
		0x03F, 0x0000084A,
		0x033, 0x00000063,
		0x03F, 0x0000084D,
		0x033, 0x00000064,
		0x03F, 0x00000C4D,
		0x033, 0x00000065,
		0x03F, 0x00000C8B,
		0x033, 0x00000066,
		0x03F, 0x00000C8E,
		0x033, 0x00000067,
		0x03F, 0x00000CEC,
		0x033, 0x00000068,
		0x03F, 0x00000CEF,
		0x033, 0x00000069,
		0x03F, 0x00000CF2,
		0x033, 0x0000006A,
		0x03F, 0x00000CF5,
	0xB0000000,	0x00000000,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000006,
		0x033, 0x000000A1,
		0x03F, 0x00000009,
		0x033, 0x000000A2,
		0x03F, 0x0000000C,
		0x033, 0x000000A3,
		0x03F, 0x00000029,
		0x033, 0x000000A4,
		0x03F, 0x0000002C,
		0x033, 0x000000A5,
		0x03F, 0x0000004B,
		0x033, 0x000000A6,
		0x03F, 0x00000448,
		0x033, 0x000000A7,
		0x03F, 0x0000044B,
		0x033, 0x000000A8,
		0x03F, 0x0000084B,
		0x033, 0x000000A9,
		0x03F, 0x0000086B,
		0x033, 0x000000AA,
		0x03F, 0x0000086E,
		0x0EF, 0x00000000,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000006,
		0x033, 0x000000A1,
		0x03F, 0x00000009,
		0x033, 0x000000A2,
		0x03F, 0x0000000C,
		0x033, 0x000000A3,
		0x03F, 0x00000029,
		0x033, 0x000000A4,
		0x03F, 0x0000002C,
		0x033, 0x000000A5,
		0x03F, 0x0000004B,
		0x033, 0x000000A6,
		0x03F, 0x00000448,
		0x033, 0x000000A7,
		0x03F, 0x0000044B,
		0x033, 0x000000A8,
		0x03F, 0x0000084B,
		0x033, 0x000000A9,
		0x03F, 0x0000086B,
		0x033, 0x000000AA,
		0x03F, 0x0000086E,
		0x0EF, 0x00000000,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000006,
		0x033, 0x000000A1,
		0x03F, 0x00000009,
		0x033, 0x000000A2,
		0x03F, 0x0000000C,
		0x033, 0x000000A3,
		0x03F, 0x00000029,
		0x033, 0x000000A4,
		0x03F, 0x0000002C,
		0x033, 0x000000A5,
		0x03F, 0x0000004B,
		0x033, 0x000000A6,
		0x03F, 0x00000448,
		0x033, 0x000000A7,
		0x03F, 0x0000044B,
		0x033, 0x000000A8,
		0x03F, 0x0000084B,
		0x033, 0x000000A9,
		0x03F, 0x0000086B,
		0x033, 0x000000AA,
		0x03F, 0x0000086E,
		0x0EF, 0x00000000,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000006,
		0x033, 0x000000A1,
		0x03F, 0x00000009,
		0x033, 0x000000A2,
		0x03F, 0x0000000C,
		0x033, 0x000000A3,
		0x03F, 0x00000029,
		0x033, 0x000000A4,
		0x03F, 0x0000002C,
		0x033, 0x000000A5,
		0x03F, 0x0000004B,
		0x033, 0x000000A6,
		0x03F, 0x00000448,
		0x033, 0x000000A7,
		0x03F, 0x0000044B,
		0x033, 0x000000A8,
		0x03F, 0x0000084B,
		0x033, 0x000000A9,
		0x03F, 0x0000086B,
		0x033, 0x000000AA,
		0x03F, 0x0000086E,
		0x0EF, 0x00000000,
	0x90002100,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x0000042A,
		0x033, 0x000000A1,
		0x03F, 0x00000829,
		0x033, 0x000000A2,
		0x03F, 0x00000848,
		0x033, 0x000000A3,
		0x03F, 0x0000084B,
		0x033, 0x000000A4,
		0x03F, 0x00000C4C,
		0x033, 0x000000A5,
		0x03F, 0x00000C8A,
		0x033, 0x000000A6,
		0x03F, 0x00000C8D,
		0x033, 0x000000A7,
		0x03F, 0x00000CEB,
		0x033, 0x000000A8,
		0x03F, 0x00000CEE,
		0x033, 0x000000A9,
		0x03F, 0x00000CF1,
		0x033, 0x000000AA,
		0x03F, 0x00000CF4,
		0x0EF, 0x00000000,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x0000042A,
		0x033, 0x000000A1,
		0x03F, 0x00000829,
		0x033, 0x000000A2,
		0x03F, 0x00000848,
		0x033, 0x000000A3,
		0x03F, 0x0000084B,
		0x033, 0x000000A4,
		0x03F, 0x00000C4C,
		0x033, 0x000000A5,
		0x03F, 0x00000C8A,
		0x033, 0x000000A6,
		0x03F, 0x00000C8D,
		0x033, 0x000000A7,
		0x03F, 0x00000CEB,
		0x033, 0x000000A8,
		0x03F, 0x00000CEE,
		0x033, 0x000000A9,
		0x03F, 0x00000CF1,
		0x033, 0x000000AA,
		0x03F, 0x00000CF4,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x0000042A,
		0x033, 0x000000A1,
		0x03F, 0x00000829,
		0x033, 0x000000A2,
		0x03F, 0x00000848,
		0x033, 0x000000A3,
		0x03F, 0x0000084B,
		0x033, 0x000000A4,
		0x03F, 0x00000C4C,
		0x033, 0x000000A5,
		0x03F, 0x00000C8A,
		0x033, 0x000000A6,
		0x03F, 0x00000C8D,
		0x033, 0x000000A7,
		0x03F, 0x00000CEB,
		0x033, 0x000000A8,
		0x03F, 0x00000CEE,
		0x033, 0x000000A9,
		0x03F, 0x00000CF1,
		0x033, 0x000000AA,
		0x03F, 0x00000CF4,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x0000047C,
		0x033, 0x00000001,
		0x03F, 0x0000047C,
		0x033, 0x00000002,
		0x03F, 0x0000047C,
		0x033, 0x00000003,
		0x03F, 0x0000047C,
		0x0EF, 0x00000000,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x0000047C,
		0x033, 0x00000001,
		0x03F, 0x0000047C,
		0x033, 0x00000002,
		0x03F, 0x0000047C,
		0x033, 0x00000003,
		0x03F, 0x0000047C,
		0x0EF, 0x00000000,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x0000047C,
		0x033, 0x00000001,
		0x03F, 0x0000047C,
		0x033, 0x00000002,
		0x03F, 0x0000047C,
		0x033, 0x00000003,
		0x03F, 0x0000047C,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000004BB,
		0x033, 0x00000001,
		0x03F, 0x000004BB,
		0x033, 0x00000002,
		0x03F, 0x000004BB,
		0x033, 0x00000003,
		0x03F, 0x000004BB,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000000,
		0x03F, 0x00001726,
		0x033, 0x00000001,
		0x03F, 0x00001726,
		0x033, 0x00000002,
		0x03F, 0x00001726,
		0x033, 0x00000003,
		0x03F, 0x00001726,
		0x0EF, 0x00000000,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000000,
		0x03F, 0x00001726,
		0x033, 0x00000001,
		0x03F, 0x00001726,
		0x033, 0x00000002,
		0x03F, 0x00001726,
		0x033, 0x00000003,
		0x03F, 0x00001726,
		0x0EF, 0x00000000,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000000,
		0x03F, 0x00001726,
		0x033, 0x00000001,
		0x03F, 0x00001726,
		0x033, 0x00000002,
		0x03F, 0x00001726,
		0x033, 0x00000003,
		0x03F, 0x00001726,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000000,
		0x03F, 0x00000F34,
		0x033, 0x00000001,
		0x03F, 0x00000F34,
		0x033, 0x00000002,
		0x03F, 0x00000F34,
		0x033, 0x00000003,
		0x03F, 0x00000F34,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x081, 0x0000F400,
		0x087, 0x00016040,
		0x051, 0x00000808,
		0x052, 0x00098002,
		0x053, 0x0000FA47,
		0x054, 0x00058032,
		0x056, 0x00051000,
		0x057, 0x0000CE0A,
		0x058, 0x00082030,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x081, 0x0000F400,
		0x087, 0x00016040,
		0x051, 0x00000808,
		0x052, 0x00098002,
		0x053, 0x0000FA47,
		0x054, 0x00058032,
		0x056, 0x00051000,
		0x057, 0x0000CE0A,
		0x058, 0x00082030,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x081, 0x0000F400,
		0x087, 0x00016040,
		0x051, 0x00000808,
		0x052, 0x00098002,
		0x053, 0x0000FA47,
		0x054, 0x00058032,
		0x056, 0x00051000,
		0x057, 0x0000CE0A,
		0x058, 0x00082030,
	0xA0000000,	0x00000000,
		0x081, 0x0000F000,
		0x087, 0x00016040,
		0x051, 0x00000C00,
		0x052, 0x0007C241,
		0x053, 0x0001C069,
		0x054, 0x00078032,
		0x057, 0x0000CE0A,
		0x058, 0x00058750,
	0xB0000000,	0x00000000,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x0EF, 0x00000800,
		0x033, 0x00000000,
		0x03F, 0x00000003,
		0x033, 0x00000001,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000009,
		0x033, 0x00000003,
		0x03F, 0x00000026,
		0x033, 0x00000004,
		0x03F, 0x00000029,
		0x033, 0x00000005,
		0x03F, 0x0000002C,
		0x033, 0x00000006,
		0x03F, 0x0000002F,
		0x033, 0x00000007,
		0x03F, 0x00000033,
		0x033, 0x00000008,
		0x03F, 0x00000036,
		0x033, 0x00000009,
		0x03F, 0x00000039,
		0x033, 0x0000000A,
		0x03F, 0x0000003C,
		0x0EF, 0x00000000,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000800,
		0x033, 0x00000000,
		0x03F, 0x00000003,
		0x033, 0x00000001,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000009,
		0x033, 0x00000003,
		0x03F, 0x00000026,
		0x033, 0x00000004,
		0x03F, 0x00000029,
		0x033, 0x00000005,
		0x03F, 0x0000002C,
		0x033, 0x00000006,
		0x03F, 0x0000002F,
		0x033, 0x00000007,
		0x03F, 0x00000033,
		0x033, 0x00000008,
		0x03F, 0x00000036,
		0x033, 0x00000009,
		0x03F, 0x00000039,
		0x033, 0x0000000A,
		0x03F, 0x0000003C,
		0x0EF, 0x00000000,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000800,
		0x033, 0x00000000,
		0x03F, 0x00000003,
		0x033, 0x00000001,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000009,
		0x033, 0x00000003,
		0x03F, 0x00000026,
		0x033, 0x00000004,
		0x03F, 0x00000029,
		0x033, 0x00000005,
		0x03F, 0x0000002C,
		0x033, 0x00000006,
		0x03F, 0x0000002F,
		0x033, 0x00000007,
		0x03F, 0x00000033,
		0x033, 0x00000008,
		0x03F, 0x00000036,
		0x033, 0x00000009,
		0x03F, 0x00000039,
		0x033, 0x0000000A,
		0x03F, 0x0000003C,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000800,
		0x033, 0x00000000,
		0x03F, 0x0005142C,
		0x033, 0x00000001,
		0x03F, 0x0005144B,
		0x033, 0x00000002,
		0x03F, 0x0005144E,
		0x033, 0x00000003,
		0x03F, 0x00051C69,
		0x033, 0x00000004,
		0x03F, 0x00051C6C,
		0x033, 0x00000005,
		0x03F, 0x00051C6F,
		0x033, 0x00000006,
		0x03F, 0x00051CEB,
		0x033, 0x00000007,
		0x03F, 0x00051CEE,
		0x033, 0x00000008,
		0x03F, 0x00051CF1,
		0x033, 0x00000009,
		0x03F, 0x00051CF4,
		0x033, 0x0000000A,
		0x03F, 0x00051CF7,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000010,
		0x033, 0x00000000,
		0x008, 0x0009C060,
		0x033, 0x00000001,
		0x008, 0x0009C060,
		0x0EF, 0x00000000,
		0x033, 0x000000A2,
		0x0EF, 0x00080000,
		0x03E, 0x0000593F,
		0x03F, 0x000C0F4F,
		0x0EF, 0x00000000,
		0x033, 0x000000A3,
		0x0EF, 0x00080000,
		0x03E, 0x00005934,
		0x03F, 0x0005AFCF,
		0x0EF, 0x00000000,

};

void
ODM_ReadAndConfig_MP_8822B_RadioA(
	IN   PDM_ODM_T  pDM_Odm
)
{
	u4Byte     i         = 0;
	u1Byte     cCond;
	BOOLEAN bMatched = TRUE, bSkipped = FALSE;
	u4Byte     ArrayLen    = sizeof(Array_MP_8822B_RadioA)/sizeof(u4Byte);
	pu4Byte    Array       = Array_MP_8822B_RadioA;
	
	u4Byte	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_8822B_RadioA\n"));

	while ((i + 1) < ArrayLen) {
		v1 = Array[i];
		v2 = Array[i + 1];

		if (v1 & (BIT31 | BIT30)) {/*positive & negative condition*/
			if (v1 & BIT31) {/* positive condition*/
				cCond  = (u1Byte)((v1 & (BIT29|BIT28)) >> 28);
				if (cCond == COND_ENDIF) {/*end*/
					bMatched = TRUE;
					bSkipped = FALSE;
					ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("ENDIF\n"));
				} else if (cCond == COND_ELSE) { /*else*/
					bMatched = bSkipped?FALSE:TRUE;
					ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("ELSE\n"));
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("IF or ELSE IF\n"));
				}
			} else if (v1 & BIT30) { /*negative condition*/
				if (bSkipped == FALSE) {
					if (CheckPositive(pDM_Odm, pre_v1, pre_v2, v1, v2)) {
						bMatched = TRUE;
						bSkipped = TRUE;
					} else {
						bMatched = FALSE;
						bSkipped = FALSE;
					}
				} else
					bMatched = FALSE;
			}
		} else {
			if (bMatched)
				odm_ConfigRF_RadioA_8822B(pDM_Odm, v1, v2);
		}
		i = i + 2;
	}
}

u4Byte
ODM_GetVersion_MP_8822B_RadioA(void)
{
	   return 45;
}

/******************************************************************************
*                           RadioB.TXT
******************************************************************************/

u4Byte Array_MP_8822B_RadioB[] = { 
		0x000, 0x00030000,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x001, 0x0004002D,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x0004002D,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x0004002D,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x90002100,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x001, 0x00040029,
	0xA0000000,	0x00000000,
		0x001, 0x00040029,
	0xB0000000,	0x00000000,
		0x018, 0x00010D24,
		0x0EF, 0x00080000,
		0x033, 0x00000002,
		0x03E, 0x0000003F,
		0x03F, 0x000C0F4E,
		0x033, 0x00000001,
		0x03E, 0x00000034,
		0x03F, 0x0004080E,
		0x0EF, 0x00080000,
		0x0DF, 0x00002449,
		0x033, 0x00000024,
		0x03E, 0x0000003F,
		0x03F, 0x00060FDE,
		0x0EF, 0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000025,
		0x03E, 0x00000037,
		0x03F, 0x0006EFCE,
		0x0EF, 0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000026,
		0x03E, 0x00000037,
		0x03F, 0x0005EFCE,
		0x0EF, 0x00000000,
		0x0DF, 0x00000009,
		0x018, 0x00010524,
		0x089, 0x00000207,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x08A, 0x000FE186,
	0xA0000000,	0x00000000,
		0x08A, 0x000FF186,
	0xB0000000,	0x00000000,
		0x08B, 0x00061E3C,
		0x08C, 0x000112C7,
		0x08D, 0x000F4988,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x08E, 0x00064D40,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x00064D40,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x00064D40,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x00064D40,
	0x90002100,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x00064D40,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x00064D40,
	0xA0000000,	0x00000000,
		0x08E, 0x00064D40,
	0xB0000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000007,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x03E, 0x00004080,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0xA0000000,	0x00000000,
		0x03E, 0x00004000,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x00000006,
		0x03E, 0x00004080,
		0x03F, 0x000C3186,
		0x033, 0x00000005,
		0x03E, 0x000040C8,
		0x03F, 0x000C3186,
		0x033, 0x00000004,
		0x03E, 0x00004190,
		0x03F, 0x000C3186,
		0x033, 0x00000003,
		0x03E, 0x00004998,
		0x03F, 0x000C3186,
		0x033, 0x00000002,
		0x03E, 0x00005840,
		0x03F, 0x000C3186,
		0x033, 0x00000001,
		0x03E, 0x000058C2,
		0x03F, 0x000C3186,
		0x033, 0x00000000,
		0x03E, 0x00005930,
		0x03F, 0x000C3186,
		0x033, 0x0000000F,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x03E, 0x00004080,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0xA0000000,	0x00000000,
		0x03E, 0x00004000,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x0000000E,
		0x03E, 0x00004080,
		0x03F, 0x000C3186,
		0x033, 0x0000000D,
		0x03E, 0x000040C8,
		0x03F, 0x000C3186,
		0x033, 0x0000000C,
		0x03E, 0x00004190,
		0x03F, 0x000C3186,
		0x033, 0x0000000B,
		0x03E, 0x00004998,
		0x03F, 0x000C3186,
		0x033, 0x0000000A,
		0x03E, 0x00005840,
		0x03F, 0x000C3186,
		0x033, 0x00000009,
		0x03E, 0x000058C2,
		0x03F, 0x000C3186,
		0x033, 0x00000008,
		0x03E, 0x00005930,
		0x03F, 0x000C3186,
		0x033, 0x00000017,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x03E, 0x00004080,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00004040,
	0xA0000000,	0x00000000,
		0x03E, 0x00004000,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x00000016,
		0x03E, 0x00004080,
		0x03F, 0x000C3186,
		0x033, 0x00000015,
		0x03E, 0x000040C8,
		0x03F, 0x000C3186,
		0x033, 0x00000014,
		0x03E, 0x00004190,
		0x03F, 0x000C3186,
		0x033, 0x00000013,
		0x03E, 0x00004998,
		0x03F, 0x000C3186,
		0x033, 0x00000012,
		0x03E, 0x00005840,
		0x03F, 0x000C3186,
		0x033, 0x00000011,
		0x03E, 0x000058C2,
		0x03F, 0x000C3186,
		0x033, 0x00000010,
		0x03E, 0x00005930,
		0x03F, 0x000C3186,
		0x0EF, 0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x0000000A,
		0x033, 0x00000001,
		0x03F, 0x00000000,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
		0x018, 0x00000401,
		0x084, 0x00001209,
		0x086, 0x000001A0,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x087, 0x00068080,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x00068080,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x00068080,
	0xA0000000,	0x00000000,
		0x087, 0x000E8180,
	0xB0000000,	0x00000000,
		0x088, 0x00070020,
		0x0DE, 0x00000010,
		0x0EF, 0x00008000,
		0x033, 0x0000000F,
		0x03F, 0x0000003C,
		0x033, 0x0000000E,
		0x03F, 0x00000038,
		0x033, 0x0000000D,
		0x03F, 0x00000030,
		0x033, 0x0000000C,
		0x03F, 0x00000028,
		0x033, 0x0000000B,
		0x03F, 0x00000020,
		0x033, 0x0000000A,
		0x03F, 0x00000018,
		0x033, 0x00000009,
		0x03F, 0x00000010,
		0x033, 0x00000008,
		0x03F, 0x00000008,
		0x033, 0x00000007,
		0x03F, 0x0000003C,
		0x033, 0x00000006,
		0x03F, 0x00000038,
		0x033, 0x00000005,
		0x03F, 0x00000030,
		0x033, 0x00000004,
		0x03F, 0x00000028,
		0x033, 0x00000003,
		0x03F, 0x00000020,
		0x033, 0x00000002,
		0x03F, 0x00000018,
		0x033, 0x00000001,
		0x03F, 0x00000010,
		0x033, 0x00000000,
		0x03F, 0x00000008,
		0x0EF, 0x00000000,
		0x018, 0x00018D24,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0x018, 0x00010D24,
		0x01B, 0x00075A40,
		0x0DE, 0x00000012,
		0x01D, 0x00000004,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x061, 0x0005D4A0,
		0x062, 0x0000D203,
		0x063, 0x00000062,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D4A0,
		0x062, 0x0000D203,
		0x063, 0x00000062,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D4A0,
		0x062, 0x0000D203,
		0x063, 0x00000062,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D4A0,
		0x062, 0x0000D203,
		0x063, 0x00000062,
	0x90002100,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D2A1,
		0x062, 0x0000D3A2,
		0x063, 0x00000002,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0005D2A1,
		0x062, 0x0000D3A2,
		0x063, 0x00000002,
	0xA0000000,	0x00000000,
		0x061, 0x0005D2A1,
		0x062, 0x0000D3A2,
		0x063, 0x00000002,
	0xB0000000,	0x00000000,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000004A0,
		0x030, 0x000014A0,
		0x030, 0x000024A0,
		0x030, 0x000034A0,
		0x030, 0x000044A0,
		0x030, 0x000054A0,
		0x030, 0x000064A0,
		0x030, 0x000074A0,
		0x030, 0x000084A0,
		0x030, 0x000094A0,
		0x030, 0x0000A4A0,
		0x030, 0x0000B4A0,
		0x0EF, 0x00000000,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000004A0,
		0x030, 0x000014A0,
		0x030, 0x000024A0,
		0x030, 0x000034A0,
		0x030, 0x000044A0,
		0x030, 0x000054A0,
		0x030, 0x000064A0,
		0x030, 0x000074A0,
		0x030, 0x000084A0,
		0x030, 0x000094A0,
		0x030, 0x0000A4A0,
		0x030, 0x0000B4A0,
		0x0EF, 0x00000000,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000004A0,
		0x030, 0x000014A0,
		0x030, 0x000024A0,
		0x030, 0x000034A0,
		0x030, 0x000044A0,
		0x030, 0x000054A0,
		0x030, 0x000064A0,
		0x030, 0x000074A0,
		0x030, 0x000084A0,
		0x030, 0x000094A0,
		0x030, 0x0000A4A0,
		0x030, 0x0000B4A0,
		0x0EF, 0x00000000,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000004A0,
		0x030, 0x000014A0,
		0x030, 0x000024A0,
		0x030, 0x000034A0,
		0x030, 0x000044A0,
		0x030, 0x000054A0,
		0x030, 0x000064A0,
		0x030, 0x000074A0,
		0x030, 0x000084A0,
		0x030, 0x000094A0,
		0x030, 0x0000A4A0,
		0x030, 0x0000B4A0,
		0x0EF, 0x00000000,
	0x90002100,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000004A1,
		0x030, 0x000014A1,
		0x030, 0x000024A1,
		0x030, 0x000034A1,
		0x030, 0x000043A1,
		0x030, 0x000053A1,
		0x030, 0x000063A1,
		0x030, 0x000073A1,
		0x030, 0x000083A1,
		0x030, 0x000093A1,
		0x030, 0x0000A3A1,
		0x030, 0x0000B3A1,
		0x0EF, 0x00000000,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000004A0,
		0x030, 0x000014A0,
		0x030, 0x000024A0,
		0x030, 0x000034A0,
		0x030, 0x000043A1,
		0x030, 0x000053A1,
		0x030, 0x000063A1,
		0x030, 0x000073A1,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000004A0,
		0x030, 0x000014A0,
		0x030, 0x000024A0,
		0x030, 0x000034A0,
		0x030, 0x000043A1,
		0x030, 0x000053A1,
		0x030, 0x000063A1,
		0x030, 0x000073A1,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x00000203,
		0x030, 0x00001203,
		0x030, 0x00002203,
		0x030, 0x00003203,
		0x030, 0x00004203,
		0x030, 0x00005203,
		0x030, 0x00006203,
		0x030, 0x00007203,
		0x030, 0x00008203,
		0x030, 0x00009203,
		0x030, 0x0000A203,
		0x030, 0x0000B203,
		0x0EF, 0x00000000,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x00000203,
		0x030, 0x00001203,
		0x030, 0x00002203,
		0x030, 0x00003203,
		0x030, 0x00004203,
		0x030, 0x00005203,
		0x030, 0x00006203,
		0x030, 0x00007203,
		0x030, 0x00008203,
		0x030, 0x00009203,
		0x030, 0x0000A203,
		0x030, 0x0000B203,
		0x0EF, 0x00000000,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x00000203,
		0x030, 0x00001203,
		0x030, 0x00002203,
		0x030, 0x00003203,
		0x030, 0x00004203,
		0x030, 0x00005203,
		0x030, 0x00006203,
		0x030, 0x00007203,
		0x030, 0x00008203,
		0x030, 0x00009203,
		0x030, 0x0000A203,
		0x030, 0x0000B203,
		0x0EF, 0x00000000,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x00000203,
		0x030, 0x00001203,
		0x030, 0x00002203,
		0x030, 0x00003203,
		0x030, 0x00004203,
		0x030, 0x00005203,
		0x030, 0x00006203,
		0x030, 0x00007203,
		0x030, 0x00008203,
		0x030, 0x00009203,
		0x030, 0x0000A203,
		0x030, 0x0000B203,
		0x0EF, 0x00000000,
	0x90002100,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
		0x0EF, 0x00000000,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x000003A2,
		0x030, 0x000013A2,
		0x030, 0x000023A2,
		0x030, 0x000033A2,
		0x030, 0x000043A2,
		0x030, 0x000053A2,
		0x030, 0x000063A2,
		0x030, 0x000073A2,
		0x030, 0x000083A2,
		0x030, 0x000093A2,
		0x030, 0x0000A3A2,
		0x030, 0x0000B3A2,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x0EF, 0x00000000,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x0EF, 0x00000000,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x0EF, 0x00000000,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000645,
		0x030, 0x00001333,
		0x030, 0x00002011,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x0EF, 0x00000000,
	0x90002100,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000775,
		0x030, 0x00001222,
		0x030, 0x00002210,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x0EF, 0x00000000,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000775,
		0x030, 0x00001422,
		0x030, 0x00002210,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000775,
		0x030, 0x00001222,
		0x030, 0x00002210,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x0EF, 0x00000800,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000800,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000800,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000800,
	0x90002100,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000800,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000800,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000800,
	0xB0000000,	0x00000000,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000006,
		0x033, 0x00000021,
		0x03F, 0x00000009,
		0x033, 0x00000022,
		0x03F, 0x0000000C,
		0x033, 0x00000023,
		0x03F, 0x00000029,
		0x033, 0x00000024,
		0x03F, 0x0000002C,
		0x033, 0x00000025,
		0x03F, 0x0000004B,
		0x033, 0x00000026,
		0x03F, 0x00000448,
		0x033, 0x00000027,
		0x03F, 0x0000044B,
		0x033, 0x00000028,
		0x03F, 0x0000084B,
		0x033, 0x00000029,
		0x03F, 0x0000086B,
		0x033, 0x0000002A,
		0x03F, 0x0000086E,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000006,
		0x033, 0x00000021,
		0x03F, 0x00000009,
		0x033, 0x00000022,
		0x03F, 0x0000000C,
		0x033, 0x00000023,
		0x03F, 0x00000029,
		0x033, 0x00000024,
		0x03F, 0x0000002C,
		0x033, 0x00000025,
		0x03F, 0x0000004B,
		0x033, 0x00000026,
		0x03F, 0x00000448,
		0x033, 0x00000027,
		0x03F, 0x0000044B,
		0x033, 0x00000028,
		0x03F, 0x0000084B,
		0x033, 0x00000029,
		0x03F, 0x0000086B,
		0x033, 0x0000002A,
		0x03F, 0x0000086E,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000006,
		0x033, 0x00000021,
		0x03F, 0x00000009,
		0x033, 0x00000022,
		0x03F, 0x0000000C,
		0x033, 0x00000023,
		0x03F, 0x00000029,
		0x033, 0x00000024,
		0x03F, 0x0000002C,
		0x033, 0x00000025,
		0x03F, 0x0000004B,
		0x033, 0x00000026,
		0x03F, 0x00000448,
		0x033, 0x00000027,
		0x03F, 0x0000044B,
		0x033, 0x00000028,
		0x03F, 0x0000084B,
		0x033, 0x00000029,
		0x03F, 0x0000086B,
		0x033, 0x0000002A,
		0x03F, 0x0000086E,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000006,
		0x033, 0x00000021,
		0x03F, 0x00000009,
		0x033, 0x00000022,
		0x03F, 0x0000000C,
		0x033, 0x00000023,
		0x03F, 0x00000029,
		0x033, 0x00000024,
		0x03F, 0x0000002C,
		0x033, 0x00000025,
		0x03F, 0x0000004B,
		0x033, 0x00000026,
		0x03F, 0x00000448,
		0x033, 0x00000027,
		0x03F, 0x0000044B,
		0x033, 0x00000028,
		0x03F, 0x0000084B,
		0x033, 0x00000029,
		0x03F, 0x0000086B,
		0x033, 0x0000002A,
		0x03F, 0x0000086E,
	0x90002100,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x0000042B,
		0x033, 0x00000021,
		0x03F, 0x0000082A,
		0x033, 0x00000022,
		0x03F, 0x00000849,
		0x033, 0x00000023,
		0x03F, 0x0000084C,
		0x033, 0x00000024,
		0x03F, 0x00000C4C,
		0x033, 0x00000025,
		0x03F, 0x00000C8A,
		0x033, 0x00000026,
		0x03F, 0x00000C8D,
		0x033, 0x00000027,
		0x03F, 0x00000CEB,
		0x033, 0x00000028,
		0x03F, 0x00000CEE,
		0x033, 0x00000029,
		0x03F, 0x00000CF1,
		0x033, 0x0000002A,
		0x03F, 0x00000CF4,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x0000042B,
		0x033, 0x00000021,
		0x03F, 0x0000082A,
		0x033, 0x00000022,
		0x03F, 0x00000849,
		0x033, 0x00000023,
		0x03F, 0x0000084C,
		0x033, 0x00000024,
		0x03F, 0x00000C4C,
		0x033, 0x00000025,
		0x03F, 0x00000C8A,
		0x033, 0x00000026,
		0x03F, 0x00000C8D,
		0x033, 0x00000027,
		0x03F, 0x00000CEB,
		0x033, 0x00000028,
		0x03F, 0x00000CEE,
		0x033, 0x00000029,
		0x03F, 0x00000CF1,
		0x033, 0x0000002A,
		0x03F, 0x00000CF4,
	0xA0000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x0000042B,
		0x033, 0x00000021,
		0x03F, 0x0000082A,
		0x033, 0x00000022,
		0x03F, 0x00000849,
		0x033, 0x00000023,
		0x03F, 0x0000084C,
		0x033, 0x00000024,
		0x03F, 0x00000C4C,
		0x033, 0x00000025,
		0x03F, 0x00000C8A,
		0x033, 0x00000026,
		0x03F, 0x00000C8D,
		0x033, 0x00000027,
		0x03F, 0x00000CEB,
		0x033, 0x00000028,
		0x03F, 0x00000CEE,
		0x033, 0x00000029,
		0x03F, 0x00000CF1,
		0x033, 0x0000002A,
		0x03F, 0x00000CF4,
	0xB0000000,	0x00000000,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000006,
		0x033, 0x00000061,
		0x03F, 0x00000009,
		0x033, 0x00000062,
		0x03F, 0x0000000C,
		0x033, 0x00000063,
		0x03F, 0x00000029,
		0x033, 0x00000064,
		0x03F, 0x0000002C,
		0x033, 0x00000065,
		0x03F, 0x0000004B,
		0x033, 0x00000066,
		0x03F, 0x00000448,
		0x033, 0x00000067,
		0x03F, 0x0000044B,
		0x033, 0x00000068,
		0x03F, 0x0000084B,
		0x033, 0x00000069,
		0x03F, 0x0000086B,
		0x033, 0x0000006A,
		0x03F, 0x0000086E,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000006,
		0x033, 0x00000061,
		0x03F, 0x00000009,
		0x033, 0x00000062,
		0x03F, 0x0000000C,
		0x033, 0x00000063,
		0x03F, 0x00000029,
		0x033, 0x00000064,
		0x03F, 0x0000002C,
		0x033, 0x00000065,
		0x03F, 0x0000004B,
		0x033, 0x00000066,
		0x03F, 0x00000448,
		0x033, 0x00000067,
		0x03F, 0x0000044B,
		0x033, 0x00000068,
		0x03F, 0x0000084B,
		0x033, 0x00000069,
		0x03F, 0x0000086B,
		0x033, 0x0000006A,
		0x03F, 0x0000086E,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000006,
		0x033, 0x00000061,
		0x03F, 0x00000009,
		0x033, 0x00000062,
		0x03F, 0x0000000C,
		0x033, 0x00000063,
		0x03F, 0x00000029,
		0x033, 0x00000064,
		0x03F, 0x0000002C,
		0x033, 0x00000065,
		0x03F, 0x0000004B,
		0x033, 0x00000066,
		0x03F, 0x00000448,
		0x033, 0x00000067,
		0x03F, 0x0000044B,
		0x033, 0x00000068,
		0x03F, 0x0000084B,
		0x033, 0x00000069,
		0x03F, 0x0000086B,
		0x033, 0x0000006A,
		0x03F, 0x0000086E,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000006,
		0x033, 0x00000061,
		0x03F, 0x00000009,
		0x033, 0x00000062,
		0x03F, 0x0000000C,
		0x033, 0x00000063,
		0x03F, 0x00000029,
		0x033, 0x00000064,
		0x03F, 0x0000002C,
		0x033, 0x00000065,
		0x03F, 0x0000004B,
		0x033, 0x00000066,
		0x03F, 0x00000448,
		0x033, 0x00000067,
		0x03F, 0x0000044B,
		0x033, 0x00000068,
		0x03F, 0x0000084B,
		0x033, 0x00000069,
		0x03F, 0x0000086B,
		0x033, 0x0000006A,
		0x03F, 0x0000086E,
	0x90002100,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x0000042C,
		0x033, 0x00000061,
		0x03F, 0x0000082B,
		0x033, 0x00000062,
		0x03F, 0x0000084A,
		0x033, 0x00000063,
		0x03F, 0x0000084D,
		0x033, 0x00000064,
		0x03F, 0x00000C4E,
		0x033, 0x00000065,
		0x03F, 0x00000C8C,
		0x033, 0x00000066,
		0x03F, 0x00000C8F,
		0x033, 0x00000067,
		0x03F, 0x00000CEC,
		0x033, 0x00000068,
		0x03F, 0x00000CEF,
		0x033, 0x00000069,
		0x03F, 0x00000CF2,
		0x033, 0x0000006A,
		0x03F, 0x00000CF5,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x0000042C,
		0x033, 0x00000061,
		0x03F, 0x0000082B,
		0x033, 0x00000062,
		0x03F, 0x0000084A,
		0x033, 0x00000063,
		0x03F, 0x0000084D,
		0x033, 0x00000064,
		0x03F, 0x00000C4E,
		0x033, 0x00000065,
		0x03F, 0x00000C8C,
		0x033, 0x00000066,
		0x03F, 0x00000C8F,
		0x033, 0x00000067,
		0x03F, 0x00000CEC,
		0x033, 0x00000068,
		0x03F, 0x00000CEF,
		0x033, 0x00000069,
		0x03F, 0x00000CF2,
		0x033, 0x0000006A,
		0x03F, 0x00000CF5,
	0xA0000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x0000042C,
		0x033, 0x00000061,
		0x03F, 0x0000082B,
		0x033, 0x00000062,
		0x03F, 0x0000084A,
		0x033, 0x00000063,
		0x03F, 0x0000084D,
		0x033, 0x00000064,
		0x03F, 0x00000C4E,
		0x033, 0x00000065,
		0x03F, 0x00000C8C,
		0x033, 0x00000066,
		0x03F, 0x00000C8F,
		0x033, 0x00000067,
		0x03F, 0x00000CEC,
		0x033, 0x00000068,
		0x03F, 0x00000CEF,
		0x033, 0x00000069,
		0x03F, 0x00000CF2,
		0x033, 0x0000006A,
		0x03F, 0x00000CF5,
	0xB0000000,	0x00000000,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000006,
		0x033, 0x000000A1,
		0x03F, 0x00000009,
		0x033, 0x000000A2,
		0x03F, 0x0000000C,
		0x033, 0x000000A3,
		0x03F, 0x00000029,
		0x033, 0x000000A4,
		0x03F, 0x0000002C,
		0x033, 0x000000A5,
		0x03F, 0x0000004B,
		0x033, 0x000000A6,
		0x03F, 0x00000448,
		0x033, 0x000000A7,
		0x03F, 0x0000044B,
		0x033, 0x000000A8,
		0x03F, 0x0000084B,
		0x033, 0x000000A9,
		0x03F, 0x0000086B,
		0x033, 0x000000AA,
		0x03F, 0x0000086E,
		0x0EF, 0x00000000,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000006,
		0x033, 0x000000A1,
		0x03F, 0x00000009,
		0x033, 0x000000A2,
		0x03F, 0x0000000C,
		0x033, 0x000000A3,
		0x03F, 0x00000029,
		0x033, 0x000000A4,
		0x03F, 0x0000002C,
		0x033, 0x000000A5,
		0x03F, 0x0000004B,
		0x033, 0x000000A6,
		0x03F, 0x00000448,
		0x033, 0x000000A7,
		0x03F, 0x0000044B,
		0x033, 0x000000A8,
		0x03F, 0x0000084B,
		0x033, 0x000000A9,
		0x03F, 0x0000086B,
		0x033, 0x000000AA,
		0x03F, 0x0000086E,
		0x0EF, 0x00000000,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000006,
		0x033, 0x000000A1,
		0x03F, 0x00000009,
		0x033, 0x000000A2,
		0x03F, 0x0000000C,
		0x033, 0x000000A3,
		0x03F, 0x00000029,
		0x033, 0x000000A4,
		0x03F, 0x0000002C,
		0x033, 0x000000A5,
		0x03F, 0x0000004B,
		0x033, 0x000000A6,
		0x03F, 0x00000448,
		0x033, 0x000000A7,
		0x03F, 0x0000044B,
		0x033, 0x000000A8,
		0x03F, 0x0000084B,
		0x033, 0x000000A9,
		0x03F, 0x0000086B,
		0x033, 0x000000AA,
		0x03F, 0x0000086E,
		0x0EF, 0x00000000,
	0x9000200c,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000006,
		0x033, 0x000000A1,
		0x03F, 0x00000009,
		0x033, 0x000000A2,
		0x03F, 0x0000000C,
		0x033, 0x000000A3,
		0x03F, 0x00000029,
		0x033, 0x000000A4,
		0x03F, 0x0000002C,
		0x033, 0x000000A5,
		0x03F, 0x0000004B,
		0x033, 0x000000A6,
		0x03F, 0x00000448,
		0x033, 0x000000A7,
		0x03F, 0x0000044B,
		0x033, 0x000000A8,
		0x03F, 0x0000084B,
		0x033, 0x000000A9,
		0x03F, 0x0000086B,
		0x033, 0x000000AA,
		0x03F, 0x0000086E,
		0x0EF, 0x00000000,
	0x90002100,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x0000042A,
		0x033, 0x000000A1,
		0x03F, 0x00000829,
		0x033, 0x000000A2,
		0x03F, 0x00000848,
		0x033, 0x000000A3,
		0x03F, 0x0000084B,
		0x033, 0x000000A4,
		0x03F, 0x00000C4C,
		0x033, 0x000000A5,
		0x03F, 0x00000C8A,
		0x033, 0x000000A6,
		0x03F, 0x00000C8D,
		0x033, 0x000000A7,
		0x03F, 0x00000CEC,
		0x033, 0x000000A8,
		0x03F, 0x00000CEF,
		0x033, 0x000000A9,
		0x03F, 0x00000CF2,
		0x033, 0x000000AA,
		0x03F, 0x00000CF5,
		0x0EF, 0x00000000,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x0000042A,
		0x033, 0x000000A1,
		0x03F, 0x00000829,
		0x033, 0x000000A2,
		0x03F, 0x00000848,
		0x033, 0x000000A3,
		0x03F, 0x0000084B,
		0x033, 0x000000A4,
		0x03F, 0x00000C4C,
		0x033, 0x000000A5,
		0x03F, 0x00000C8A,
		0x033, 0x000000A6,
		0x03F, 0x00000C8D,
		0x033, 0x000000A7,
		0x03F, 0x00000CEC,
		0x033, 0x000000A8,
		0x03F, 0x00000CEF,
		0x033, 0x000000A9,
		0x03F, 0x00000CF2,
		0x033, 0x000000AA,
		0x03F, 0x00000CF5,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x0000042A,
		0x033, 0x000000A1,
		0x03F, 0x00000829,
		0x033, 0x000000A2,
		0x03F, 0x00000848,
		0x033, 0x000000A3,
		0x03F, 0x0000084B,
		0x033, 0x000000A4,
		0x03F, 0x00000C4C,
		0x033, 0x000000A5,
		0x03F, 0x00000C8A,
		0x033, 0x000000A6,
		0x03F, 0x00000C8D,
		0x033, 0x000000A7,
		0x03F, 0x00000CEC,
		0x033, 0x000000A8,
		0x03F, 0x00000CEF,
		0x033, 0x000000A9,
		0x03F, 0x00000CF2,
		0x033, 0x000000AA,
		0x03F, 0x00000CF5,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x0000265A,
		0x033, 0x00000001,
		0x03F, 0x0000265A,
		0x033, 0x00000002,
		0x03F, 0x0000265A,
		0x033, 0x00000003,
		0x03F, 0x0000265A,
		0x0EF, 0x00000000,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x0000265A,
		0x033, 0x00000001,
		0x03F, 0x0000265A,
		0x033, 0x00000002,
		0x03F, 0x0000265A,
		0x033, 0x00000003,
		0x03F, 0x0000265A,
		0x0EF, 0x00000000,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x0000265A,
		0x033, 0x00000001,
		0x03F, 0x0000265A,
		0x033, 0x00000002,
		0x03F, 0x0000265A,
		0x033, 0x00000003,
		0x03F, 0x0000265A,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000004BB,
		0x033, 0x00000001,
		0x03F, 0x000004BB,
		0x033, 0x00000002,
		0x03F, 0x000004BB,
		0x033, 0x00000003,
		0x03F, 0x000004BB,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000000,
		0x03F, 0x00000745,
		0x033, 0x00000001,
		0x03F, 0x00000745,
		0x033, 0x00000002,
		0x03F, 0x00000745,
		0x033, 0x00000003,
		0x03F, 0x00000745,
		0x0EF, 0x00000000,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000000,
		0x03F, 0x00000745,
		0x033, 0x00000001,
		0x03F, 0x00000745,
		0x033, 0x00000002,
		0x03F, 0x00000745,
		0x033, 0x00000003,
		0x03F, 0x00000745,
		0x0EF, 0x00000000,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000000,
		0x03F, 0x00000745,
		0x033, 0x00000001,
		0x03F, 0x00000745,
		0x033, 0x00000002,
		0x03F, 0x00000745,
		0x033, 0x00000003,
		0x03F, 0x00000745,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000000,
		0x03F, 0x00000F34,
		0x033, 0x00000001,
		0x03F, 0x00000F34,
		0x033, 0x00000002,
		0x03F, 0x00000F34,
		0x033, 0x00000003,
		0x03F, 0x00000F34,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x081, 0x0000F400,
		0x087, 0x00016040,
		0x051, 0x00000808,
		0x052, 0x00098002,
		0x053, 0x0000FA47,
		0x054, 0x00058032,
		0x056, 0x00051000,
		0x057, 0x0000CE0A,
		0x058, 0x00082030,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x081, 0x0000F400,
		0x087, 0x00016040,
		0x051, 0x00000808,
		0x052, 0x00098002,
		0x053, 0x0000FA47,
		0x054, 0x00058032,
		0x056, 0x00051000,
		0x057, 0x0000CE0A,
		0x058, 0x00082030,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x081, 0x0000F400,
		0x087, 0x00016040,
		0x051, 0x00000808,
		0x052, 0x00098002,
		0x053, 0x0000FA47,
		0x054, 0x00058032,
		0x056, 0x00051000,
		0x057, 0x0000CE0A,
		0x058, 0x00082030,
	0xA0000000,	0x00000000,
		0x081, 0x0000F000,
		0x087, 0x00016040,
		0x051, 0x00000C00,
		0x052, 0x0007C241,
		0x053, 0x0001C069,
		0x054, 0x00078032,
		0x057, 0x0000CE0A,
		0x058, 0x00058750,
	0xB0000000,	0x00000000,
	0x8000100f,	0x05050505,	0x40000000,	0x00000000,
		0x0EF, 0x00000800,
		0x033, 0x00000000,
		0x03F, 0x00000003,
		0x033, 0x00000001,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000009,
		0x033, 0x00000003,
		0x03F, 0x00000026,
		0x033, 0x00000004,
		0x03F, 0x00000029,
		0x033, 0x00000005,
		0x03F, 0x0000002C,
		0x033, 0x00000006,
		0x03F, 0x0000002F,
		0x033, 0x00000007,
		0x03F, 0x00000033,
		0x033, 0x00000008,
		0x03F, 0x00000036,
		0x033, 0x00000009,
		0x03F, 0x00000039,
		0x033, 0x0000000A,
		0x03F, 0x0000003C,
		0x0EF, 0x00000000,
	0x9000100f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000800,
		0x033, 0x00000000,
		0x03F, 0x00000003,
		0x033, 0x00000001,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000009,
		0x033, 0x00000003,
		0x03F, 0x00000026,
		0x033, 0x00000004,
		0x03F, 0x00000029,
		0x033, 0x00000005,
		0x03F, 0x0000002C,
		0x033, 0x00000006,
		0x03F, 0x0000002F,
		0x033, 0x00000007,
		0x03F, 0x00000033,
		0x033, 0x00000008,
		0x03F, 0x00000036,
		0x033, 0x00000009,
		0x03F, 0x00000039,
		0x033, 0x0000000A,
		0x03F, 0x0000003C,
		0x0EF, 0x00000000,
	0x9000200f,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000800,
		0x033, 0x00000000,
		0x03F, 0x00000003,
		0x033, 0x00000001,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000009,
		0x033, 0x00000003,
		0x03F, 0x00000026,
		0x033, 0x00000004,
		0x03F, 0x00000029,
		0x033, 0x00000005,
		0x03F, 0x0000002C,
		0x033, 0x00000006,
		0x03F, 0x0000002F,
		0x033, 0x00000007,
		0x03F, 0x00000033,
		0x033, 0x00000008,
		0x03F, 0x00000036,
		0x033, 0x00000009,
		0x03F, 0x00000039,
		0x033, 0x0000000A,
		0x03F, 0x0000003C,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000800,
		0x033, 0x00000000,
		0x03F, 0x0005142C,
		0x033, 0x00000001,
		0x03F, 0x0005142F,
		0x033, 0x00000002,
		0x03F, 0x00051432,
		0x033, 0x00000003,
		0x03F, 0x00051C87,
		0x033, 0x00000004,
		0x03F, 0x00051C8A,
		0x033, 0x00000005,
		0x03F, 0x00051C8D,
		0x033, 0x00000006,
		0x03F, 0x00051CEB,
		0x033, 0x00000007,
		0x03F, 0x00051CEE,
		0x033, 0x00000008,
		0x03F, 0x00051CF1,
		0x033, 0x00000009,
		0x03F, 0x00051CF4,
		0x033, 0x0000000A,
		0x03F, 0x00051CF7,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000010,
		0x033, 0x00000000,
		0x008, 0x0009C060,
		0x033, 0x00000001,
		0x008, 0x0009C060,
		0x0EF, 0x00000000,
		0x033, 0x000000A2,
		0x0EF, 0x00080000,
		0x03E, 0x0000593F,
		0x03F, 0x000C0F4F,
		0x0EF, 0x00000000,
		0x033, 0x000000A3,
		0x0EF, 0x00080000,
		0x03E, 0x00005934,
		0x03F, 0x0005AFCF,
		0x0EF, 0x00000000,

};

void
ODM_ReadAndConfig_MP_8822B_RadioB(
	IN   PDM_ODM_T  pDM_Odm
)
{
	u4Byte     i         = 0;
	u1Byte     cCond;
	BOOLEAN bMatched = TRUE, bSkipped = FALSE;
	u4Byte     ArrayLen    = sizeof(Array_MP_8822B_RadioB)/sizeof(u4Byte);
	pu4Byte    Array       = Array_MP_8822B_RadioB;
	
	u4Byte	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_8822B_RadioB\n"));

	while ((i + 1) < ArrayLen) {
		v1 = Array[i];
		v2 = Array[i + 1];

		if (v1 & (BIT31 | BIT30)) {/*positive & negative condition*/
			if (v1 & BIT31) {/* positive condition*/
				cCond  = (u1Byte)((v1 & (BIT29|BIT28)) >> 28);
				if (cCond == COND_ENDIF) {/*end*/
					bMatched = TRUE;
					bSkipped = FALSE;
					ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("ENDIF\n"));
				} else if (cCond == COND_ELSE) { /*else*/
					bMatched = bSkipped?FALSE:TRUE;
					ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("ELSE\n"));
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("IF or ELSE IF\n"));
				}
			} else if (v1 & BIT30) { /*negative condition*/
				if (bSkipped == FALSE) {
					if (CheckPositive(pDM_Odm, pre_v1, pre_v2, v1, v2)) {
						bMatched = TRUE;
						bSkipped = TRUE;
					} else {
						bMatched = FALSE;
						bSkipped = FALSE;
					}
				} else
					bMatched = FALSE;
			}
		} else {
			if (bMatched)
				odm_ConfigRF_RadioB_8822B(pDM_Odm, v1, v2);
		}
		i = i + 2;
	}
}

u4Byte
ODM_GetVersion_MP_8822B_RadioB(void)
{
	   return 45;
}

/******************************************************************************
*                           TxPowerTrack.TXT
******************************************************************************/

u1Byte gDeltaSwingTableIdx_MP_5GB_N_TxPowerTrack_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 13, 13, 14, 14, 14, 15, 15, 15, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 7, 7, 8, 8, 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
	{0, 1, 2, 2, 3, 3, 4, 4, 5, 6, 6, 7, 7, 8, 9, 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
};
u1Byte gDeltaSwingTableIdx_MP_5GB_P_TxPowerTrack_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 2, 2, 3, 4, 5, 6, 7, 8, 8, 9, 10, 11, 11, 12, 13, 14, 15, 15, 16, 17, 18, 18, 19, 19, 19, 19, 19, 19},
	{0, 1, 2, 2, 3, 4, 5, 6, 6, 7, 8, 8, 9, 9, 10, 11, 12, 12, 13, 14, 15, 16, 17, 17, 18, 18, 18, 18, 18, 18},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10, 11, 12, 13, 14, 15, 15, 16, 16, 17, 17, 17, 17, 17, 17},
};
u1Byte gDeltaSwingTableIdx_MP_5GA_N_TxPowerTrack_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 2, 2, 3, 3, 4, 5, 6, 7, 8, 8, 9, 9, 10, 11, 11, 12, 12, 12, 13, 13, 14, 14, 14, 15, 15, 15, 15, 15},
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
	{0, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
};
u1Byte gDeltaSwingTableIdx_MP_5GA_P_TxPowerTrack_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13, 14, 14, 15, 16, 17, 18, 19, 19, 20, 20, 20, 20, 20},
	{0, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 7, 8, 9, 9, 10, 11, 11, 12, 13, 14, 15, 16, 16, 17, 17, 18, 18, 18, 18},
	{0, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 11, 12, 12, 13, 14, 15, 15, 16, 17, 17, 18, 18, 18, 18, 18},
};
u1Byte gDeltaSwingTableIdx_MP_2GB_N_TxPowerTrack_8822B[]    = {0, 1, 2, 3, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13, 14, 15, 16, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18};
u1Byte gDeltaSwingTableIdx_MP_2GB_P_TxPowerTrack_8822B[]    = {0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 7, 8, 9, 10, 11, 12, 12, 13, 14, 15, 16, 17, 17, 18, 19, 20, 21, 22, 22, 22};
u1Byte gDeltaSwingTableIdx_MP_2GA_N_TxPowerTrack_8822B[]    = {0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 10, 11, 12, 13, 13, 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
u1Byte gDeltaSwingTableIdx_MP_2GA_P_TxPowerTrack_8822B[]    = {0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
u1Byte gDeltaSwingTableIdx_MP_2GCCKB_N_TxPowerTrack_8822B[] = {0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13, 14, 15, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17};
u1Byte gDeltaSwingTableIdx_MP_2GCCKB_P_TxPowerTrack_8822B[] = {0, 1, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 9, 10, 11, 12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};
u1Byte gDeltaSwingTableIdx_MP_2GCCKA_N_TxPowerTrack_8822B[] = {0, 1, 2, 3, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 13, 14, 15, 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18};
u1Byte gDeltaSwingTableIdx_MP_2GCCKA_P_TxPowerTrack_8822B[] = {0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 22, 22};

void
ODM_ReadAndConfig_MP_8822B_TxPowerTrack(
	IN   PDM_ODM_T  pDM_Odm
)
{
	PODM_RF_CAL_T  pRFCalibrateInfo = &(pDM_Odm->RFCalibrateInfo);

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_MP_8822B\n"));


	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GA_P, gDeltaSwingTableIdx_MP_2GA_P_TxPowerTrack_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GA_N, gDeltaSwingTableIdx_MP_2GA_N_TxPowerTrack_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GB_P, gDeltaSwingTableIdx_MP_2GB_P_TxPowerTrack_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GB_N, gDeltaSwingTableIdx_MP_2GB_N_TxPowerTrack_8822B, DELTA_SWINGIDX_SIZE);

	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKA_P, gDeltaSwingTableIdx_MP_2GCCKA_P_TxPowerTrack_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKA_N, gDeltaSwingTableIdx_MP_2GCCKA_N_TxPowerTrack_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKB_P, gDeltaSwingTableIdx_MP_2GCCKB_P_TxPowerTrack_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKB_N, gDeltaSwingTableIdx_MP_2GCCKB_N_TxPowerTrack_8822B, DELTA_SWINGIDX_SIZE);

	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GA_P, gDeltaSwingTableIdx_MP_5GA_P_TxPowerTrack_8822B, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GA_N, gDeltaSwingTableIdx_MP_5GA_N_TxPowerTrack_8822B, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GB_P, gDeltaSwingTableIdx_MP_5GB_P_TxPowerTrack_8822B, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GB_N, gDeltaSwingTableIdx_MP_5GB_N_TxPowerTrack_8822B, DELTA_SWINGIDX_SIZE*3);
}

/******************************************************************************
*                           TxPowerTrack_Type3_Type5.TXT
******************************************************************************/

u1Byte gDeltaSwingTableIdx_MP_5GB_N_TxPowerTrack_Type3_Type5_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
};
u1Byte gDeltaSwingTableIdx_MP_5GB_P_TxPowerTrack_Type3_Type5_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
};
u1Byte gDeltaSwingTableIdx_MP_5GA_N_TxPowerTrack_Type3_Type5_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
};
u1Byte gDeltaSwingTableIdx_MP_5GA_P_TxPowerTrack_Type3_Type5_8822B[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17},
};
u1Byte gDeltaSwingTableIdx_MP_2GB_N_TxPowerTrack_Type3_Type5_8822B[]    = {0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u1Byte gDeltaSwingTableIdx_MP_2GB_P_TxPowerTrack_Type3_Type5_8822B[]    = {0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15};
u1Byte gDeltaSwingTableIdx_MP_2GA_N_TxPowerTrack_Type3_Type5_8822B[]    = {0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u1Byte gDeltaSwingTableIdx_MP_2GA_P_TxPowerTrack_Type3_Type5_8822B[]    = {0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15};
u1Byte gDeltaSwingTableIdx_MP_2GCCKB_N_TxPowerTrack_Type3_Type5_8822B[] = {0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u1Byte gDeltaSwingTableIdx_MP_2GCCKB_P_TxPowerTrack_Type3_Type5_8822B[] = {0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15};
u1Byte gDeltaSwingTableIdx_MP_2GCCKA_N_TxPowerTrack_Type3_Type5_8822B[] = {0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12};
u1Byte gDeltaSwingTableIdx_MP_2GCCKA_P_TxPowerTrack_Type3_Type5_8822B[] = {0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15};

void
ODM_ReadAndConfig_MP_8822B_TxPowerTrack_Type3_Type5(
	IN   PDM_ODM_T  pDM_Odm
)
{
	PODM_RF_CAL_T  pRFCalibrateInfo = &(pDM_Odm->RFCalibrateInfo);

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_MP_8822B\n"));


	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GA_P, gDeltaSwingTableIdx_MP_2GA_P_TxPowerTrack_Type3_Type5_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GA_N, gDeltaSwingTableIdx_MP_2GA_N_TxPowerTrack_Type3_Type5_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GB_P, gDeltaSwingTableIdx_MP_2GB_P_TxPowerTrack_Type3_Type5_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GB_N, gDeltaSwingTableIdx_MP_2GB_N_TxPowerTrack_Type3_Type5_8822B, DELTA_SWINGIDX_SIZE);

	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKA_P, gDeltaSwingTableIdx_MP_2GCCKA_P_TxPowerTrack_Type3_Type5_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKA_N, gDeltaSwingTableIdx_MP_2GCCKA_N_TxPowerTrack_Type3_Type5_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKB_P, gDeltaSwingTableIdx_MP_2GCCKB_P_TxPowerTrack_Type3_Type5_8822B, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKB_N, gDeltaSwingTableIdx_MP_2GCCKB_N_TxPowerTrack_Type3_Type5_8822B, DELTA_SWINGIDX_SIZE);

	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GA_P, gDeltaSwingTableIdx_MP_5GA_P_TxPowerTrack_Type3_Type5_8822B, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GA_N, gDeltaSwingTableIdx_MP_5GA_N_TxPowerTrack_Type3_Type5_8822B, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GB_P, gDeltaSwingTableIdx_MP_5GB_P_TxPowerTrack_Type3_Type5_8822B, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GB_N, gDeltaSwingTableIdx_MP_5GB_N_TxPowerTrack_Type3_Type5_8822B, DELTA_SWINGIDX_SIZE*3);
}

#endif /* end of HWIMG_SUPPORT*/

