/******************************************************************************
 *
 * Copyright(c) 2016 - 2019 Realtek Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 ******************************************************************************/

#ifndef __RTL_WLAN_BITDEF_H__
#define __RTL_WLAN_BITDEF_H__

#include "halmac_hw_cfg.h"

#define CPU_OPT_WIDTH 0x1F

#if (HALMAC_8192F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8822C_SUPPORT)

#define BIT_WRITE_ENABLE BIT(31)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

#define BIT_MEM_RMV_SIGN BIT(31)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

#define BIT_QUEUE_MACID_AC_NOT_THE_SAME BIT(31)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8881A_SUPPORT)

#define BIT_SHIFT_LLTE_RWM 30
#define BIT_MASK_LLTE_RWM 0x3
#define BIT_LLTE_RWM(x) (((x) & BIT_MASK_LLTE_RWM) << BIT_SHIFT_LLTE_RWM)
#define BITS_LLTE_RWM (BIT_MASK_LLTE_RWM << BIT_SHIFT_LLTE_RWM)
#define BIT_CLEAR_LLTE_RWM(x) ((x) & (~BITS_LLTE_RWM))
#define BIT_GET_LLTE_RWM(x) (((x) >> BIT_SHIFT_LLTE_RWM) & BIT_MASK_LLTE_RWM)
#define BIT_SET_LLTE_RWM(x, v) (BIT_CLEAR_LLTE_RWM(x) | BIT_LLTE_RWM(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

#define BIT_MEM_RMV_2PRF1 BIT(29)
#define BIT_MEM_RMV_2PRF0 BIT(28)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

#define BIT_SHIFT_GTAB_ID 28
#define BIT_MASK_GTAB_ID 0x7
#define BIT_GTAB_ID(x) (((x) & BIT_MASK_GTAB_ID) << BIT_SHIFT_GTAB_ID)
#define BITS_GTAB_ID (BIT_MASK_GTAB_ID << BIT_SHIFT_GTAB_ID)
#define BIT_CLEAR_GTAB_ID(x) ((x) & (~BITS_GTAB_ID))
#define BIT_GET_GTAB_ID(x) (((x) >> BIT_SHIFT_GTAB_ID) & BIT_MASK_GTAB_ID)
#define BIT_SET_GTAB_ID(x, v) (BIT_CLEAR_GTAB_ID(x) | BIT_GTAB_ID(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT)

#define BIT_MULRW BIT(27)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

#define BIT_MEM_RMV_1PRF1 BIT(27)
#define BIT_MEM_RMV_1PRF0 BIT(26)
#define BIT_MEM_RMV_1PSR BIT(25)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || \
     HALMAC_8881A_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8197G_SUPPORT)

#define BIT_SHIFT_MBIDCAM_ADDR 24
#define BIT_MASK_MBIDCAM_ADDR 0x1f
#define BIT_MBIDCAM_ADDR(x)                                                    \
	(((x) & BIT_MASK_MBIDCAM_ADDR) << BIT_SHIFT_MBIDCAM_ADDR)
#define BITS_MBIDCAM_ADDR (BIT_MASK_MBIDCAM_ADDR << BIT_SHIFT_MBIDCAM_ADDR)
#define BIT_CLEAR_MBIDCAM_ADDR(x) ((x) & (~BITS_MBIDCAM_ADDR))
#define BIT_GET_MBIDCAM_ADDR(x)                                                \
	(((x) >> BIT_SHIFT_MBIDCAM_ADDR) & BIT_MASK_MBIDCAM_ADDR)
#define BIT_SET_MBIDCAM_ADDR(x, v)                                             \
	(BIT_CLEAR_MBIDCAM_ADDR(x) | BIT_MBIDCAM_ADDR(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

#define BIT_MEM_RMV_ROM BIT(24)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8881A_SUPPORT)

#define BIT_CPRST BIT(23)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

#define BIT_CTS_EN BIT(16)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

#define BIT_SHIFT_R_OFDM_LEN_V1 16
#define BIT_MASK_R_OFDM_LEN_V1 0xffff
#define BIT_R_OFDM_LEN_V1(x)                                                   \
	(((x) & BIT_MASK_R_OFDM_LEN_V1) << BIT_SHIFT_R_OFDM_LEN_V1)
#define BITS_R_OFDM_LEN_V1 (BIT_MASK_R_OFDM_LEN_V1 << BIT_SHIFT_R_OFDM_LEN_V1)
#define BIT_CLEAR_R_OFDM_LEN_V1(x) ((x) & (~BITS_R_OFDM_LEN_V1))
#define BIT_GET_R_OFDM_LEN_V1(x)                                               \
	(((x) >> BIT_SHIFT_R_OFDM_LEN_V1) & BIT_MASK_R_OFDM_LEN_V1)
#define BIT_SET_R_OFDM_LEN_V1(x, v)                                            \
	(BIT_CLEAR_R_OFDM_LEN_V1(x) | BIT_R_OFDM_LEN_V1(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822C_SUPPORT)

#define BIT_SHIFT_COUNTER_BASE 16
#define BIT_MASK_COUNTER_BASE 0x1fff
#define BIT_COUNTER_BASE(x)                                                    \
	(((x) & BIT_MASK_COUNTER_BASE) << BIT_SHIFT_COUNTER_BASE)
#define BITS_COUNTER_BASE (BIT_MASK_COUNTER_BASE << BIT_SHIFT_COUNTER_BASE)
#define BIT_CLEAR_COUNTER_BASE(x) ((x) & (~BITS_COUNTER_BASE))
#define BIT_GET_COUNTER_BASE(x)                                                \
	(((x) >> BIT_SHIFT_COUNTER_BASE) & BIT_MASK_COUNTER_BASE)
#define BIT_SET_COUNTER_BASE(x, v)                                             \
	(BIT_CLEAR_COUNTER_BASE(x) | BIT_COUNTER_BASE(v))

#define BIT_SHIFT_AGG_VALUE2 16
#define BIT_MASK_AGG_VALUE2 0x7f
#define BIT_AGG_VALUE2(x) (((x) & BIT_MASK_AGG_VALUE2) << BIT_SHIFT_AGG_VALUE2)
#define BITS_AGG_VALUE2 (BIT_MASK_AGG_VALUE2 << BIT_SHIFT_AGG_VALUE2)
#define BIT_CLEAR_AGG_VALUE2(x) ((x) & (~BITS_AGG_VALUE2))
#define BIT_GET_AGG_VALUE2(x)                                                  \
	(((x) >> BIT_SHIFT_AGG_VALUE2) & BIT_MASK_AGG_VALUE2)
#define BIT_SET_AGG_VALUE2(x, v) (BIT_CLEAR_AGG_VALUE2(x) | BIT_AGG_VALUE2(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

#define BIT_WMAC_SRCH_FIFOFULL BIT(15)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

#define BIT_QUEUE_MACID_AC_NOT_THE_SAME_V1 BIT(15)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

#define BIT_SHIFT_XTAL_DRV_RF1 13
#define BIT_MASK_XTAL_DRV_RF1 0x3
#define BIT_XTAL_DRV_RF1(x)                                                    \
	(((x) & BIT_MASK_XTAL_DRV_RF1) << BIT_SHIFT_XTAL_DRV_RF1)
#define BITS_XTAL_DRV_RF1 (BIT_MASK_XTAL_DRV_RF1 << BIT_SHIFT_XTAL_DRV_RF1)
#define BIT_CLEAR_XTAL_DRV_RF1(x) ((x) & (~BITS_XTAL_DRV_RF1))
#define BIT_GET_XTAL_DRV_RF1(x)                                                \
	(((x) >> BIT_SHIFT_XTAL_DRV_RF1) & BIT_MASK_XTAL_DRV_RF1)
#define BIT_SET_XTAL_DRV_RF1(x, v)                                             \
	(BIT_CLEAR_XTAL_DRV_RF1(x) | BIT_XTAL_DRV_RF1(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

#define BIT_DISABLE_B0 BIT(13)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

#define BIT_ATIMEND BIT(12)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

#define BIT_SHIFT_GTAB_ID_V1 12
#define BIT_MASK_GTAB_ID_V1 0x7
#define BIT_GTAB_ID_V1(x) (((x) & BIT_MASK_GTAB_ID_V1) << BIT_SHIFT_GTAB_ID_V1)
#define BITS_GTAB_ID_V1 (BIT_MASK_GTAB_ID_V1 << BIT_SHIFT_GTAB_ID_V1)
#define BIT_CLEAR_GTAB_ID_V1(x) ((x) & (~BITS_GTAB_ID_V1))
#define BIT_GET_GTAB_ID_V1(x)                                                  \
	(((x) >> BIT_SHIFT_GTAB_ID_V1) & BIT_MASK_GTAB_ID_V1)
#define BIT_SET_GTAB_ID_V1(x, v) (BIT_CLEAR_GTAB_ID_V1(x) | BIT_GTAB_ID_V1(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

#define BIT_SHIFT_WATCH_DOG_RECORD_V1 10
#define BIT_MASK_WATCH_DOG_RECORD_V1 0x3fff
#define BIT_WATCH_DOG_RECORD_V1(x)                                             \
	(((x) & BIT_MASK_WATCH_DOG_RECORD_V1) << BIT_SHIFT_WATCH_DOG_RECORD_V1)
#define BITS_WATCH_DOG_RECORD_V1                                               \
	(BIT_MASK_WATCH_DOG_RECORD_V1 << BIT_SHIFT_WATCH_DOG_RECORD_V1)
#define BIT_CLEAR_WATCH_DOG_RECORD_V1(x) ((x) & (~BITS_WATCH_DOG_RECORD_V1))
#define BIT_GET_WATCH_DOG_RECORD_V1(x)                                         \
	(((x) >> BIT_SHIFT_WATCH_DOG_RECORD_V1) & BIT_MASK_WATCH_DOG_RECORD_V1)
#define BIT_SET_WATCH_DOG_RECORD_V1(x, v)                                      \
	(BIT_CLEAR_WATCH_DOG_RECORD_V1(x) | BIT_WATCH_DOG_RECORD_V1(v))

#endif

#if (HALMAC_8822C_SUPPORT)

#define BIT_R_SYM_CTRL_SPS_PWMFREQ BIT(10)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8881A_SUPPORT)

#define BIT_R_8051_SPD BIT(9)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

#define BIT_R_IO_TIMEOUT_FLAG_V1 BIT(9)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822C_SUPPORT)

#define BIT_EN_RTS_REQ BIT(9)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8881A_SUPPORT)

#define BIT_EN_WATCH_DOG_V1 BIT(8)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822C_SUPPORT)

#define BIT_EN_EDCA_REQ BIT(8)

#define BIT_SHIFT_AGG_VALUE1 8
#define BIT_MASK_AGG_VALUE1 0x7f
#define BIT_AGG_VALUE1(x) (((x) & BIT_MASK_AGG_VALUE1) << BIT_SHIFT_AGG_VALUE1)
#define BITS_AGG_VALUE1 (BIT_MASK_AGG_VALUE1 << BIT_SHIFT_AGG_VALUE1)
#define BIT_CLEAR_AGG_VALUE1(x) ((x) & (~BITS_AGG_VALUE1))
#define BIT_GET_AGG_VALUE1(x)                                                  \
	(((x) >> BIT_SHIFT_AGG_VALUE1) & BIT_MASK_AGG_VALUE1)
#define BIT_SET_AGG_VALUE1(x, v) (BIT_CLEAR_AGG_VALUE1(x) | BIT_AGG_VALUE1(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

#define BIT_DIS_TXDMA_PRE BIT(7)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8881A_SUPPORT)

#define BIT_RAM_DL_SEL BIT(7)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822C_SUPPORT)

#define BIT_EN_PTCL_REQ BIT(7)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

#define BIT_DIS_RXDMA_PRE BIT(6)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822C_SUPPORT)

#define BIT_EN_SCH_REQ BIT(6)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

#define BIT_CLR_HGQ_REQ_BLOCK BIT(5)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

#define BIT_SHIFT_I2C_M_BUS_GNT_FW 4
#define BIT_MASK_I2C_M_BUS_GNT_FW 0x7
#define BIT_I2C_M_BUS_GNT_FW(x)                                                \
	(((x) & BIT_MASK_I2C_M_BUS_GNT_FW) << BIT_SHIFT_I2C_M_BUS_GNT_FW)
#define BITS_I2C_M_BUS_GNT_FW                                                  \
	(BIT_MASK_I2C_M_BUS_GNT_FW << BIT_SHIFT_I2C_M_BUS_GNT_FW)
#define BIT_CLEAR_I2C_M_BUS_GNT_FW(x) ((x) & (~BITS_I2C_M_BUS_GNT_FW))
#define BIT_GET_I2C_M_BUS_GNT_FW(x)                                            \
	(((x) >> BIT_SHIFT_I2C_M_BUS_GNT_FW) & BIT_MASK_I2C_M_BUS_GNT_FW)
#define BIT_SET_I2C_M_BUS_GNT_FW(x, v)                                         \
	(BIT_CLEAR_I2C_M_BUS_GNT_FW(x) | BIT_I2C_M_BUS_GNT_FW(v))

#define BIT_I2C_M_GNT_FW BIT(3)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

#define BIT_TXFLAG_EXIT_L1_EN BIT(2)

#endif

#if (HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822C_SUPPORT)

#define BIT_DATA_FW_STS_FILTER BIT(2)

#endif

#if (HALMAC_8822C_SUPPORT)

#define BIT_OPTION_DIS_XTAL_BG BIT(2)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

#define BIT_EN_RXDMA_ALIGN_V1 BIT(1)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

#define BIT_SHIFT_I2C_M_SPEED 1
#define BIT_MASK_I2C_M_SPEED 0x3
#define BIT_I2C_M_SPEED(x)                                                     \
	(((x) & BIT_MASK_I2C_M_SPEED) << BIT_SHIFT_I2C_M_SPEED)
#define BITS_I2C_M_SPEED (BIT_MASK_I2C_M_SPEED << BIT_SHIFT_I2C_M_SPEED)
#define BIT_CLEAR_I2C_M_SPEED(x) ((x) & (~BITS_I2C_M_SPEED))
#define BIT_GET_I2C_M_SPEED(x)                                                 \
	(((x) >> BIT_SHIFT_I2C_M_SPEED) & BIT_MASK_I2C_M_SPEED)
#define BIT_SET_I2C_M_SPEED(x, v)                                              \
	(BIT_CLEAR_I2C_M_SPEED(x) | BIT_I2C_M_SPEED(v))

#endif

#if (HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822C_SUPPORT)

#define BIT_CTRL_FW_STS_FILTER BIT(1)

#endif

#if (HALMAC_8881A_SUPPORT)

#define BIT_AFE_MBIAS BIT(1)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT)

#define BIT_SHIFT_MDIO_REG_ADDR 0
#define BIT_MASK_MDIO_REG_ADDR 0x1f
#define BIT_MDIO_REG_ADDR(x)                                                   \
	(((x) & BIT_MASK_MDIO_REG_ADDR) << BIT_SHIFT_MDIO_REG_ADDR)
#define BITS_MDIO_REG_ADDR (BIT_MASK_MDIO_REG_ADDR << BIT_SHIFT_MDIO_REG_ADDR)
#define BIT_CLEAR_MDIO_REG_ADDR(x) ((x) & (~BITS_MDIO_REG_ADDR))
#define BIT_GET_MDIO_REG_ADDR(x)                                               \
	(((x) >> BIT_SHIFT_MDIO_REG_ADDR) & BIT_MASK_MDIO_REG_ADDR)
#define BIT_SET_MDIO_REG_ADDR(x, v)                                            \
	(BIT_CLEAR_MDIO_REG_ADDR(x) | BIT_MDIO_REG_ADDR(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

#define BIT_EN_TXDMA_ALIGN_V1 BIT(0)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

#define BIT_SHIFT_RXFF0_BNDY_V2 0
#define BIT_MASK_RXFF0_BNDY_V2 0x3ffff
#define BIT_RXFF0_BNDY_V2(x)                                                   \
	(((x) & BIT_MASK_RXFF0_BNDY_V2) << BIT_SHIFT_RXFF0_BNDY_V2)
#define BITS_RXFF0_BNDY_V2 (BIT_MASK_RXFF0_BNDY_V2 << BIT_SHIFT_RXFF0_BNDY_V2)
#define BIT_CLEAR_RXFF0_BNDY_V2(x) ((x) & (~BITS_RXFF0_BNDY_V2))
#define BIT_GET_RXFF0_BNDY_V2(x)                                               \
	(((x) >> BIT_SHIFT_RXFF0_BNDY_V2) & BIT_MASK_RXFF0_BNDY_V2)
#define BIT_SET_RXFF0_BNDY_V2(x, v)                                            \
	(BIT_CLEAR_RXFF0_BNDY_V2(x) | BIT_RXFF0_BNDY_V2(v))

#define BIT_SHIFT_RXFF0_RDPTR_V2 0
#define BIT_MASK_RXFF0_RDPTR_V2 0x3ffff
#define BIT_RXFF0_RDPTR_V2(x)                                                  \
	(((x) & BIT_MASK_RXFF0_RDPTR_V2) << BIT_SHIFT_RXFF0_RDPTR_V2)
#define BITS_RXFF0_RDPTR_V2                                                    \
	(BIT_MASK_RXFF0_RDPTR_V2 << BIT_SHIFT_RXFF0_RDPTR_V2)
#define BIT_CLEAR_RXFF0_RDPTR_V2(x) ((x) & (~BITS_RXFF0_RDPTR_V2))
#define BIT_GET_RXFF0_RDPTR_V2(x)                                              \
	(((x) >> BIT_SHIFT_RXFF0_RDPTR_V2) & BIT_MASK_RXFF0_RDPTR_V2)
#define BIT_SET_RXFF0_RDPTR_V2(x, v)                                           \
	(BIT_CLEAR_RXFF0_RDPTR_V2(x) | BIT_RXFF0_RDPTR_V2(v))

#define BIT_SHIFT_RXFF0_WTPTR_V2 0
#define BIT_MASK_RXFF0_WTPTR_V2 0x3ffff
#define BIT_RXFF0_WTPTR_V2(x)                                                  \
	(((x) & BIT_MASK_RXFF0_WTPTR_V2) << BIT_SHIFT_RXFF0_WTPTR_V2)
#define BITS_RXFF0_WTPTR_V2                                                    \
	(BIT_MASK_RXFF0_WTPTR_V2 << BIT_SHIFT_RXFF0_WTPTR_V2)
#define BIT_CLEAR_RXFF0_WTPTR_V2(x) ((x) & (~BITS_RXFF0_WTPTR_V2))
#define BIT_GET_RXFF0_WTPTR_V2(x)                                              \
	(((x) >> BIT_SHIFT_RXFF0_WTPTR_V2) & BIT_MASK_RXFF0_WTPTR_V2)
#define BIT_SET_RXFF0_WTPTR_V2(x, v)                                           \
	(BIT_CLEAR_RXFF0_WTPTR_V2(x) | BIT_RXFF0_WTPTR_V2(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822C_SUPPORT)

#define BIT_SHIFT_AGG_VALUE0 0
#define BIT_MASK_AGG_VALUE0 0x7f
#define BIT_AGG_VALUE0(x) (((x) & BIT_MASK_AGG_VALUE0) << BIT_SHIFT_AGG_VALUE0)
#define BITS_AGG_VALUE0 (BIT_MASK_AGG_VALUE0 << BIT_SHIFT_AGG_VALUE0)
#define BIT_CLEAR_AGG_VALUE0(x) ((x) & (~BITS_AGG_VALUE0))
#define BIT_GET_AGG_VALUE0(x)                                                  \
	(((x) >> BIT_SHIFT_AGG_VALUE0) & BIT_MASK_AGG_VALUE0)
#define BIT_SET_AGG_VALUE0(x, v) (BIT_CLEAR_AGG_VALUE0(x) | BIT_AGG_VALUE0(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8822C_SUPPORT)

#define BIT_SHIFT_BW_CFG 0
#define BIT_MASK_BW_CFG 0x3
#define BIT_BW_CFG(x) (((x) & BIT_MASK_BW_CFG) << BIT_SHIFT_BW_CFG)
#define BITS_BW_CFG (BIT_MASK_BW_CFG << BIT_SHIFT_BW_CFG)
#define BIT_CLEAR_BW_CFG(x) ((x) & (~BITS_BW_CFG))
#define BIT_GET_BW_CFG(x) (((x) >> BIT_SHIFT_BW_CFG) & BIT_MASK_BW_CFG)
#define BIT_SET_BW_CFG(x, v) (BIT_CLEAR_BW_CFG(x) | BIT_BW_CFG(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

#define BIT_I2C_M_UNLOCK BIT(0)

#endif

#if (HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822C_SUPPORT)

#define BIT_MGNT_FW_STS_FILTER BIT(0)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8822B_SUPPORT)

#define BIT_ISO_MD2PP BIT(0)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_TX_CTRL			(Offset 0x10250000) */

#define BIT_SHIFT_SDIO_INT_TIMEOUT 16
#define BIT_MASK_SDIO_INT_TIMEOUT 0xffff
#define BIT_SDIO_INT_TIMEOUT(x)                                                \
	(((x) & BIT_MASK_SDIO_INT_TIMEOUT) << BIT_SHIFT_SDIO_INT_TIMEOUT)
#define BITS_SDIO_INT_TIMEOUT                                                  \
	(BIT_MASK_SDIO_INT_TIMEOUT << BIT_SHIFT_SDIO_INT_TIMEOUT)
#define BIT_CLEAR_SDIO_INT_TIMEOUT(x) ((x) & (~BITS_SDIO_INT_TIMEOUT))
#define BIT_GET_SDIO_INT_TIMEOUT(x)                                            \
	(((x) >> BIT_SHIFT_SDIO_INT_TIMEOUT) & BIT_MASK_SDIO_INT_TIMEOUT)
#define BIT_SET_SDIO_INT_TIMEOUT(x, v)                                         \
	(BIT_CLEAR_SDIO_INT_TIMEOUT(x) | BIT_SDIO_INT_TIMEOUT(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_ISO_CTRL			(Offset 0x0000) */

#define BIT_PWC_EV12V BIT(15)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_ISO_CTRL			(Offset 0x0000) */

#define BIT_PWC_ON2EF BIT(15)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_TX_CTRL			(Offset 0x10250000) */

#define BIT_IO_ERR_STATUS BIT(15)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_ISO_CTRL			(Offset 0x0000) */

#define BIT_PWC_EBCOEB BIT(15)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_ISO_CTRL			(Offset 0x0000) */

#define BIT_PWC_EV25V BIT(14)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_ISO_CTRL			(Offset 0x0000) */

#define BIT_PWC_EV2EF BIT(14)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_TX_CTRL			(Offset 0x10250000) */

#define BIT_CMD53_W_MIX BIT(14)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_ISO_CTRL			(Offset 0x0000) */

#define BIT_PA33V_EN BIT(13)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_TX_CTRL			(Offset 0x10250000) */

#define BIT_CMD53_TX_FORMAT BIT(13)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_ISO_CTRL			(Offset 0x0000) */

#define BIT_PA12V_EN BIT(12)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_TX_CTRL			(Offset 0x10250000) */

#define BIT_CMD53_R_TIMEOUT_MASK BIT(12)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_ISO_CTRL			(Offset 0x0000) */

#define BIT_PC_A15V BIT(12)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_ISO_CTRL			(Offset 0x0000) */

#define BIT_UA33V_EN BIT(11)
#define BIT_UA12V_EN BIT(10)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_TX_CTRL			(Offset 0x10250000) */

#define BIT_SHIFT_CMD53_R_TIMEOUT_UNIT 10
#define BIT_MASK_CMD53_R_TIMEOUT_UNIT 0x3
#define BIT_CMD53_R_TIMEOUT_UNIT(x)                                            \
	(((x) & BIT_MASK_CMD53_R_TIMEOUT_UNIT)                                 \
	 << BIT_SHIFT_CMD53_R_TIMEOUT_UNIT)
#define BITS_CMD53_R_TIMEOUT_UNIT                                              \
	(BIT_MASK_CMD53_R_TIMEOUT_UNIT << BIT_SHIFT_CMD53_R_TIMEOUT_UNIT)
#define BIT_CLEAR_CMD53_R_TIMEOUT_UNIT(x) ((x) & (~BITS_CMD53_R_TIMEOUT_UNIT))
#define BIT_GET_CMD53_R_TIMEOUT_UNIT(x)                                        \
	(((x) >> BIT_SHIFT_CMD53_R_TIMEOUT_UNIT) &                             \
	 BIT_MASK_CMD53_R_TIMEOUT_UNIT)
#define BIT_SET_CMD53_R_TIMEOUT_UNIT(x, v)                                     \
	(BIT_CLEAR_CMD53_R_TIMEOUT_UNIT(x) | BIT_CMD53_R_TIMEOUT_UNIT(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_ISO_CTRL			(Offset 0x0000) */

#define BIT_ISO_AFE_OUTPUT_SIGNAL BIT(10)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_ISO_CTRL			(Offset 0x0000) */

#define BIT_ISO_RFDIO BIT(9)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_TX_CTRL			(Offset 0x10250000) */

#define BIT_REPLY_ERRCRC_IN_DATA BIT(9)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_ISO_CTRL			(Offset 0x0000) */

#define BIT_ISO_EB2CORE BIT(8)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_ISO_CTRL			(Offset 0x0000) */

#define BIT_ISO_EF2PP BIT(8)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_TX_CTRL			(Offset 0x10250000) */

#define BIT_EN_CMD53_OVERLAP BIT(8)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_ISO_CTRL			(Offset 0x0000) */

#define BIT_ISO_DIOE BIT(7)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_ISO_CTRL			(Offset 0x0000) */

#define BIT_ISO_EXTIO BIT(7)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_TX_CTRL			(Offset 0x10250000) */

#define BIT_REPLY_ERR_IN_R5 BIT(7)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_ISO_CTRL			(Offset 0x0000) */

#define BIT_ISO_DIOP BIT(6)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SYS_ISO_CTRL			(Offset 0x0000) */

#define BIT_ISO_WLPON2PP BIT(6)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_TX_CTRL			(Offset 0x10250000) */

#define BIT_R18A_EN BIT(6)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_ISO_CTRL			(Offset 0x0000) */

#define BIT_ISO_IP2MAC_WA2PP BIT(5)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_ISO_CTRL			(Offset 0x0000) */

#define BIT_ISO_WA2PP BIT(5)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_TX_CTRL			(Offset 0x10250000) */

#define BIT_SDIO_CMD_FORCE_VLD BIT(5)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_ISO_CTRL			(Offset 0x0000) */

#define BIT_ISO_PD2CORE BIT(4)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_ISO_CTRL			(Offset 0x0000) */

#define BIT_ISO_PD2PP BIT(4)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_TX_CTRL			(Offset 0x10250000) */

#define BIT_INIT_CMD_EN BIT(4)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_ISO_CTRL			(Offset 0x0000) */

#define BIT_ISO_PA2PCIE BIT(3)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_ISO_CTRL			(Offset 0x0000) */

#define BIT_ISO_PA2PD BIT(3)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_TX_CTRL			(Offset 0x10250000) */

#define BIT_RXINT_READ_MASK_DIS BIT(3)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SDIO_TX_CTRL			(Offset 0x10250000) */

#define BIT_EN_32K_TRANS BIT(3)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_ISO_CTRL			(Offset 0x0000) */

#define BIT_ISO_UD2CORE BIT(2)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_ISO_CTRL			(Offset 0x0000) */

#define BIT_ISO_UD2PP BIT(2)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_TX_CTRL			(Offset 0x10250000) */

#define BIT_EN_RXDMA_MASK_INT BIT(2)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_ISO_CTRL			(Offset 0x0000) */

#define BIT_ISO_HD2CORE BIT(2)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_ISO_CTRL			(Offset 0x0000) */

#define BIT_ISO_UA2USB BIT(1)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_ISO_CTRL			(Offset 0x0000) */

#define BIT_ISO_UA2UD BIT(1)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_TX_CTRL			(Offset 0x10250000) */

#define BIT_EN_MASK_TIMER BIT(1)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_ISO_CTRL			(Offset 0x0000) */

#define BIT_ISO_WD2PP BIT(0)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_ISO_CTRL			(Offset 0x0000) */

#define BIT_ISO_WL2PP BIT(0)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_TX_CTRL			(Offset 0x10250000) */

#define BIT_CMD_ERR_STOP_INT_EN BIT(0)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_FUNC_EN				(Offset 0x0002) */

#define BIT_FEN_MREGEN BIT(15)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_FUNC_EN				(Offset 0x0002) */

#define BIT_FEN_HWPDN BIT(14)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_FUNC_EN				(Offset 0x0002) */

#define BIT_AIP_PD12_N BIT(14)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_FUNC_EN				(Offset 0x0002) */

#define BIT_EN_25_1 BIT(13)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_FUNC_EN				(Offset 0x0002) */

#define BIT_FEN_ELDR BIT(12)
#define BIT_FEN_DCORE BIT(11)
#define BIT_FEN_CPUEN BIT(10)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_FUNC_EN				(Offset 0x0002) */

#define BIT_FEN_DIOE BIT(9)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_FUNC_EN				(Offset 0x0002) */

#define BIT_FEN_EXTIO BIT(9)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_FUNC_EN				(Offset 0x0002) */

#define BIT_FEN_PCIED BIT(8)
#define BIT_FEN_PPLL BIT(7)
#define BIT_FEN_PCIEA BIT(6)
#define BIT_FEN_DIO_PCIE BIT(5)
#define BIT_FEN_USBD BIT(4)
#define BIT_FEN_UPLL BIT(3)
#define BIT_FEN_USBA BIT(2)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_FUNC_EN				(Offset 0x0002) */

#define BIT_FEN_BB_GLB_RSTN BIT(1)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_FUNC_EN				(Offset 0x0002) */

#define BIT_FEN_WLPHYGLB BIT(1)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_FUNC_EN				(Offset 0x0002) */

#define BIT_FEN_BBRSTB BIT(0)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_FUNC_EN				(Offset 0x0002) */

#define BIT_FEN_WLPHYFUN BIT(0)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_SOP_EABM BIT(31)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_SKP_ALD BIT(31)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_SOP_ACKF BIT(30)
#define BIT_SOP_ERCK BIT(29)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_SOP_ESWR BIT(28)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_SOP_AFEP BIT(28)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_SOP_PWMM BIT(27)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_SOP_EPWM BIT(27)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_SOP_EECK BIT(26)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_PMC_RATIO_BIT2 BIT(25)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_SOP_ANA_CLK_DIVISION_2 BIT(25)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_ROP_ENXT BIT(25)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_SOP_EXTL BIT(24)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_PMC_RATIO_BIT1 BIT(23)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_CHIPOFF_EN BIT(23)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_SYM_OP_RING_12M BIT(22)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_DIS_USB3_SUS_ALD BIT(22)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_ROP_SWPR BIT(21)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_DIS_HW_LPLDM BIT(20)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_SOP_ALD BIT(20)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_OPT_SWRST_WLMCU BIT(19)
#define BIT_RDY_SYSPWR BIT(17)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_EN_WLON BIT(16)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_APDM_HPDN BIT(15)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_PMC_RATIO_BIT0 BIT(14)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_HSUS BIT(14)
#define BIT_PDN_SEL BIT(13)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_AFSM_PCIE_SUS_EN BIT(12)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_AFSM_WLSUS_EN BIT(11)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_APFM_SWLPS BIT(10)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_APFM_SWLPS_EN BIT(10)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_APFM_OFFMAC BIT(9)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_HW_AUTO_CTRL_EXT_SWR BIT(9)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_APFN_ONMAC BIT(8)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_USE_INTERNAL_SWR_AND_LDO BIT(8)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_CHIP_PDN_EN BIT(7)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_BT_SUSEN BIT(7)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_RDY_MACDIS BIT(6)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_PD_RF BIT(5)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_RING_CLK_12M_EN BIT(4)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_CMD11_VOL_SWITCH		(Offset 0x10250004) */

#define BIT_SHIFT_CMD11_SEQ_END_DELAY 4
#define BIT_MASK_CMD11_SEQ_END_DELAY 0xf
#define BIT_CMD11_SEQ_END_DELAY(x)                                             \
	(((x) & BIT_MASK_CMD11_SEQ_END_DELAY) << BIT_SHIFT_CMD11_SEQ_END_DELAY)
#define BITS_CMD11_SEQ_END_DELAY                                               \
	(BIT_MASK_CMD11_SEQ_END_DELAY << BIT_SHIFT_CMD11_SEQ_END_DELAY)
#define BIT_CLEAR_CMD11_SEQ_END_DELAY(x) ((x) & (~BITS_CMD11_SEQ_END_DELAY))
#define BIT_GET_CMD11_SEQ_END_DELAY(x)                                         \
	(((x) >> BIT_SHIFT_CMD11_SEQ_END_DELAY) & BIT_MASK_CMD11_SEQ_END_DELAY)
#define BIT_SET_CMD11_SEQ_END_DELAY(x, v)                                      \
	(BIT_CLEAR_CMD11_SEQ_END_DELAY(x) | BIT_CMD11_SEQ_END_DELAY(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_ENPDN BIT(4)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_PFM_WOWL BIT(3)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_SW_WAKE BIT(3)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_PFM_LDKP BIT(2)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_WL_HCI_ALD BIT(1)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_ANA_CLK_DIVISION_2 BIT(1)

#define BIT_SHIFT_CMD11_SEQ_SAMPLE_INTERVAL 1
#define BIT_MASK_CMD11_SEQ_SAMPLE_INTERVAL 0x7
#define BIT_CMD11_SEQ_SAMPLE_INTERVAL(x)                                       \
	(((x) & BIT_MASK_CMD11_SEQ_SAMPLE_INTERVAL)                            \
	 << BIT_SHIFT_CMD11_SEQ_SAMPLE_INTERVAL)
#define BITS_CMD11_SEQ_SAMPLE_INTERVAL                                         \
	(BIT_MASK_CMD11_SEQ_SAMPLE_INTERVAL                                    \
	 << BIT_SHIFT_CMD11_SEQ_SAMPLE_INTERVAL)
#define BIT_CLEAR_CMD11_SEQ_SAMPLE_INTERVAL(x)                                 \
	((x) & (~BITS_CMD11_SEQ_SAMPLE_INTERVAL))
#define BIT_GET_CMD11_SEQ_SAMPLE_INTERVAL(x)                                   \
	(((x) >> BIT_SHIFT_CMD11_SEQ_SAMPLE_INTERVAL) &                        \
	 BIT_MASK_CMD11_SEQ_SAMPLE_INTERVAL)
#define BIT_SET_CMD11_SEQ_SAMPLE_INTERVAL(x, v)                                \
	(BIT_CLEAR_CMD11_SEQ_SAMPLE_INTERVAL(x) |                              \
	 BIT_CMD11_SEQ_SAMPLE_INTERVAL(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_PFM_ALDN BIT(1)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_PW_CTRL				(Offset 0x0004) */

#define BIT_PFM_LDALL BIT(0)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_CMD11_VOL_SWITCH		(Offset 0x10250004) */

#define BIT_CMD11_SEQ_EN BIT(0)

/* 2 REG_SDIO_CTRL				(Offset 0x10250005) */

#define BIT_SIG_OUT_PH BIT(0)

/* 2 REG_SDIO_DRIVING			(Offset 0x10250006) */

#define BIT_SHIFT_SDIO_DRV_TYPE_D 12
#define BIT_MASK_SDIO_DRV_TYPE_D 0xf
#define BIT_SDIO_DRV_TYPE_D(x)                                                 \
	(((x) & BIT_MASK_SDIO_DRV_TYPE_D) << BIT_SHIFT_SDIO_DRV_TYPE_D)
#define BITS_SDIO_DRV_TYPE_D                                                   \
	(BIT_MASK_SDIO_DRV_TYPE_D << BIT_SHIFT_SDIO_DRV_TYPE_D)
#define BIT_CLEAR_SDIO_DRV_TYPE_D(x) ((x) & (~BITS_SDIO_DRV_TYPE_D))
#define BIT_GET_SDIO_DRV_TYPE_D(x)                                             \
	(((x) >> BIT_SHIFT_SDIO_DRV_TYPE_D) & BIT_MASK_SDIO_DRV_TYPE_D)
#define BIT_SET_SDIO_DRV_TYPE_D(x, v)                                          \
	(BIT_CLEAR_SDIO_DRV_TYPE_D(x) | BIT_SDIO_DRV_TYPE_D(v))

#define BIT_SHIFT_SDIO_DRV_TYPE_C 8
#define BIT_MASK_SDIO_DRV_TYPE_C 0xf
#define BIT_SDIO_DRV_TYPE_C(x)                                                 \
	(((x) & BIT_MASK_SDIO_DRV_TYPE_C) << BIT_SHIFT_SDIO_DRV_TYPE_C)
#define BITS_SDIO_DRV_TYPE_C                                                   \
	(BIT_MASK_SDIO_DRV_TYPE_C << BIT_SHIFT_SDIO_DRV_TYPE_C)
#define BIT_CLEAR_SDIO_DRV_TYPE_C(x) ((x) & (~BITS_SDIO_DRV_TYPE_C))
#define BIT_GET_SDIO_DRV_TYPE_C(x)                                             \
	(((x) >> BIT_SHIFT_SDIO_DRV_TYPE_C) & BIT_MASK_SDIO_DRV_TYPE_C)
#define BIT_SET_SDIO_DRV_TYPE_C(x, v)                                          \
	(BIT_CLEAR_SDIO_DRV_TYPE_C(x) | BIT_SDIO_DRV_TYPE_C(v))

#define BIT_SHIFT_SDIO_DRV_TYPE_B 4
#define BIT_MASK_SDIO_DRV_TYPE_B 0xf
#define BIT_SDIO_DRV_TYPE_B(x)                                                 \
	(((x) & BIT_MASK_SDIO_DRV_TYPE_B) << BIT_SHIFT_SDIO_DRV_TYPE_B)
#define BITS_SDIO_DRV_TYPE_B                                                   \
	(BIT_MASK_SDIO_DRV_TYPE_B << BIT_SHIFT_SDIO_DRV_TYPE_B)
#define BIT_CLEAR_SDIO_DRV_TYPE_B(x) ((x) & (~BITS_SDIO_DRV_TYPE_B))
#define BIT_GET_SDIO_DRV_TYPE_B(x)                                             \
	(((x) >> BIT_SHIFT_SDIO_DRV_TYPE_B) & BIT_MASK_SDIO_DRV_TYPE_B)
#define BIT_SET_SDIO_DRV_TYPE_B(x, v)                                          \
	(BIT_CLEAR_SDIO_DRV_TYPE_B(x) | BIT_SDIO_DRV_TYPE_B(v))

#define BIT_SHIFT_SDIO_DRV_TYPE_A 0
#define BIT_MASK_SDIO_DRV_TYPE_A 0xf
#define BIT_SDIO_DRV_TYPE_A(x)                                                 \
	(((x) & BIT_MASK_SDIO_DRV_TYPE_A) << BIT_SHIFT_SDIO_DRV_TYPE_A)
#define BITS_SDIO_DRV_TYPE_A                                                   \
	(BIT_MASK_SDIO_DRV_TYPE_A << BIT_SHIFT_SDIO_DRV_TYPE_A)
#define BIT_CLEAR_SDIO_DRV_TYPE_A(x) ((x) & (~BITS_SDIO_DRV_TYPE_A))
#define BIT_GET_SDIO_DRV_TYPE_A(x)                                             \
	(((x) >> BIT_SHIFT_SDIO_DRV_TYPE_A) & BIT_MASK_SDIO_DRV_TYPE_A)
#define BIT_SET_SDIO_DRV_TYPE_A(x, v)                                          \
	(BIT_CLEAR_SDIO_DRV_TYPE_A(x) | BIT_SDIO_DRV_TYPE_A(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_SYS_CLK_CTRL			(Offset 0x0008) */

#define BIT_CPHY_LDO_CL_EN BIT(19)
#define BIT_CPHY_LDO_OK BIT(18)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_CLK_CTRL			(Offset 0x0008) */

#define BIT_LDO_DUMMY BIT(15)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_CLK_CTRL			(Offset 0x0008) */

#define BIT_ANA_CLK_EN BIT(15)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_SYS_CLK_CTRL			(Offset 0x0008) */

#define BIT_DATA_CPU_CLK_EN BIT(15)
#define BIT_DATA_CPU_PWC BIT(15)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_CLK_CTRL			(Offset 0x0008) */

#define BIT_CPU_CLK_EN BIT(14)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_CLK_CTRL			(Offset 0x0008) */

#define BIT_SYMREG_CLK_EN BIT(13)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_CLK_CTRL			(Offset 0x0008) */

#define BIT_RING_CLK_EN BIT(13)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_CLK_CTRL			(Offset 0x0008) */

#define BIT_HCI_CLK_EN BIT(12)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_CLK_CTRL			(Offset 0x0008) */

#define BIT_SYS_CLK_EN BIT(12)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_CLK_CTRL			(Offset 0x0008) */

#define BIT_MAC_CLK_EN BIT(11)
#define BIT_SEC_CLK_EN BIT(10)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_SYS_CLK_CTRL			(Offset 0x0008) */

#define BIT_CTRL_SPS_PWM_FREQ BIT(10)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_CLK_CTRL			(Offset 0x0008) */

#define BIT_PHY_SSC_RSTB BIT(9)
#define BIT_EXT_32K_EN BIT(8)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_CLK_CTRL			(Offset 0x0008) */

#define BIT_EXT32K_EN BIT(8)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_SYS_CLK_CTRL			(Offset 0x0008) */

#define BIT_DISABLE_OPEN_SPS_LDO BIT(8)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_CLK_CTRL			(Offset 0x0008) */

#define BIT_WL_CLK_TEST BIT(7)
#define BIT_OP_SPS_PWM_EN BIT(6)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_CLK_CTRL			(Offset 0x0008) */

#define BIT_SHIFT_MAC_CLK_SEL_V1 6
#define BIT_MASK_MAC_CLK_SEL_V1 0x3
#define BIT_MAC_CLK_SEL_V1(x)                                                  \
	(((x) & BIT_MASK_MAC_CLK_SEL_V1) << BIT_SHIFT_MAC_CLK_SEL_V1)
#define BITS_MAC_CLK_SEL_V1                                                    \
	(BIT_MASK_MAC_CLK_SEL_V1 << BIT_SHIFT_MAC_CLK_SEL_V1)
#define BIT_CLEAR_MAC_CLK_SEL_V1(x) ((x) & (~BITS_MAC_CLK_SEL_V1))
#define BIT_GET_MAC_CLK_SEL_V1(x)                                              \
	(((x) >> BIT_SHIFT_MAC_CLK_SEL_V1) & BIT_MASK_MAC_CLK_SEL_V1)
#define BIT_SET_MAC_CLK_SEL_V1(x, v)                                           \
	(BIT_CLEAR_MAC_CLK_SEL_V1(x) | BIT_MAC_CLK_SEL_V1(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_CLK_CTRL			(Offset 0x0008) */

#define BIT_LOADER_CLK_EN BIT(5)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_SYS_CLK_CTRL			(Offset 0x0008) */

#define BIT_POW_PC_LDO3 BIT(5)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_CLK_CTRL			(Offset 0x0008) */

#define BIT_MACSLP BIT(4)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_SYS_CLK_CTRL			(Offset 0x0008) */

#define BIT_POW_PC_LDO2 BIT(4)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_CLK_CTRL			(Offset 0x0008) */

#define BIT_WAKEPAD_EN BIT(3)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_SYS_CLK_CTRL			(Offset 0x0008) */

#define BIT_ENB_LDO_DIODE_L BIT(3)
#define BIT_POW_PC_LDO1 BIT(3)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_CLK_CTRL			(Offset 0x0008) */

#define BIT_ROMD16V_EN BIT(2)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_SYS_CLK_CTRL			(Offset 0x0008) */

#define BIT_AFE_BGEN_PCIE_OP BIT(2)
#define BIT_POW_PC_LDO0 BIT(2)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_CLK_CTRL			(Offset 0x0008) */

#define BIT_CKANA8M_EN BIT(1)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_SYS_CLK_CTRL			(Offset 0x0008) */

#define BIT_CKANA12M_EN BIT(1)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_CLK_CTRL			(Offset 0x0008) */

#define BIT_ANA8M_EN BIT(1)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_CLK_CTRL			(Offset 0x0008) */

#define BIT_CNTD16V_EN BIT(0)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_MONITOR			(Offset 0x10250008) */

#define BIT_SHIFT_SDIO_INT_START 0
#define BIT_MASK_SDIO_INT_START 0xffffffffL
#define BIT_SDIO_INT_START(x)                                                  \
	(((x) & BIT_MASK_SDIO_INT_START) << BIT_SHIFT_SDIO_INT_START)
#define BITS_SDIO_INT_START                                                    \
	(BIT_MASK_SDIO_INT_START << BIT_SHIFT_SDIO_INT_START)
#define BIT_CLEAR_SDIO_INT_START(x) ((x) & (~BITS_SDIO_INT_START))
#define BIT_GET_SDIO_INT_START(x)                                              \
	(((x) >> BIT_SHIFT_SDIO_INT_START) & BIT_MASK_SDIO_INT_START)
#define BIT_SET_SDIO_INT_START(x, v)                                           \
	(BIT_CLEAR_SDIO_INT_START(x) | BIT_SDIO_INT_START(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_SYS_CLK_CTRL			(Offset 0x0008) */

#define BIT_POW_POWER_CUT BIT(0)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_EEPROM_CTRL			(Offset 0x000A) */

#define BIT_SHIFT_VPDIDX 8
#define BIT_MASK_VPDIDX 0xff
#define BIT_VPDIDX(x) (((x) & BIT_MASK_VPDIDX) << BIT_SHIFT_VPDIDX)
#define BITS_VPDIDX (BIT_MASK_VPDIDX << BIT_SHIFT_VPDIDX)
#define BIT_CLEAR_VPDIDX(x) ((x) & (~BITS_VPDIDX))
#define BIT_GET_VPDIDX(x) (((x) >> BIT_SHIFT_VPDIDX) & BIT_MASK_VPDIDX)
#define BIT_SET_VPDIDX(x, v) (BIT_CLEAR_VPDIDX(x) | BIT_VPDIDX(v))

#define BIT_SHIFT_EEM1_0 6
#define BIT_MASK_EEM1_0 0x3
#define BIT_EEM1_0(x) (((x) & BIT_MASK_EEM1_0) << BIT_SHIFT_EEM1_0)
#define BITS_EEM1_0 (BIT_MASK_EEM1_0 << BIT_SHIFT_EEM1_0)
#define BIT_CLEAR_EEM1_0(x) ((x) & (~BITS_EEM1_0))
#define BIT_GET_EEM1_0(x) (((x) >> BIT_SHIFT_EEM1_0) & BIT_MASK_EEM1_0)
#define BIT_SET_EEM1_0(x, v) (BIT_CLEAR_EEM1_0(x) | BIT_EEM1_0(v))

#define BIT_AUTOLOAD_SUS BIT(5)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_EEPROM_CTRL			(Offset 0x000A) */

#define BIT_EERPOMSEL BIT(4)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_EEPROM_CTRL			(Offset 0x000A) */

#define BIT_EEPROMSEL BIT(4)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_EEPROM_CTRL			(Offset 0x000A) */

#define BIT_EECS_V1 BIT(3)
#define BIT_EESK_V1 BIT(2)
#define BIT_EEDI_V1 BIT(1)
#define BIT_EEDO_V1 BIT(0)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_MONITOR_2			(Offset 0x1025000C) */

#define BIT_CMD53_WT_EN BIT(23)

#define BIT_SHIFT_SDIO_CLK_MONITOR 21
#define BIT_MASK_SDIO_CLK_MONITOR 0x3
#define BIT_SDIO_CLK_MONITOR(x)                                                \
	(((x) & BIT_MASK_SDIO_CLK_MONITOR) << BIT_SHIFT_SDIO_CLK_MONITOR)
#define BITS_SDIO_CLK_MONITOR                                                  \
	(BIT_MASK_SDIO_CLK_MONITOR << BIT_SHIFT_SDIO_CLK_MONITOR)
#define BIT_CLEAR_SDIO_CLK_MONITOR(x) ((x) & (~BITS_SDIO_CLK_MONITOR))
#define BIT_GET_SDIO_CLK_MONITOR(x)                                            \
	(((x) >> BIT_SHIFT_SDIO_CLK_MONITOR) & BIT_MASK_SDIO_CLK_MONITOR)
#define BIT_SET_SDIO_CLK_MONITOR(x, v)                                         \
	(BIT_CLEAR_SDIO_CLK_MONITOR(x) | BIT_SDIO_CLK_MONITOR(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_EE_VPD				(Offset 0x000C) */

#define BIT_SHIFT_VPD_DATA 0
#define BIT_MASK_VPD_DATA 0xffffffffL
#define BIT_VPD_DATA(x) (((x) & BIT_MASK_VPD_DATA) << BIT_SHIFT_VPD_DATA)
#define BITS_VPD_DATA (BIT_MASK_VPD_DATA << BIT_SHIFT_VPD_DATA)
#define BIT_CLEAR_VPD_DATA(x) ((x) & (~BITS_VPD_DATA))
#define BIT_GET_VPD_DATA(x) (((x) >> BIT_SHIFT_VPD_DATA) & BIT_MASK_VPD_DATA)
#define BIT_SET_VPD_DATA(x, v) (BIT_CLEAR_VPD_DATA(x) | BIT_VPD_DATA(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_MONITOR_2			(Offset 0x1025000C) */

#define BIT_SHIFT_SDIO_CLK_CNT 0
#define BIT_MASK_SDIO_CLK_CNT 0x1fffff
#define BIT_SDIO_CLK_CNT(x)                                                    \
	(((x) & BIT_MASK_SDIO_CLK_CNT) << BIT_SHIFT_SDIO_CLK_CNT)
#define BITS_SDIO_CLK_CNT (BIT_MASK_SDIO_CLK_CNT << BIT_SHIFT_SDIO_CLK_CNT)
#define BIT_CLEAR_SDIO_CLK_CNT(x) ((x) & (~BITS_SDIO_CLK_CNT))
#define BIT_GET_SDIO_CLK_CNT(x)                                                \
	(((x) >> BIT_SHIFT_SDIO_CLK_CNT) & BIT_MASK_SDIO_CLK_CNT)
#define BIT_SET_SDIO_CLK_CNT(x, v)                                             \
	(BIT_CLEAR_SDIO_CLK_CNT(x) | BIT_SDIO_CLK_CNT(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_EE_VPD				(Offset 0x000C) */

#define BIT_SHIFT_VDP_DATA 0
#define BIT_MASK_VDP_DATA 0xffffffffL
#define BIT_VDP_DATA(x) (((x) & BIT_MASK_VDP_DATA) << BIT_SHIFT_VDP_DATA)
#define BITS_VDP_DATA (BIT_MASK_VDP_DATA << BIT_SHIFT_VDP_DATA)
#define BIT_CLEAR_VDP_DATA(x) ((x) & (~BITS_VDP_DATA))
#define BIT_GET_VDP_DATA(x) (((x) >> BIT_SHIFT_VDP_DATA) & BIT_MASK_VDP_DATA)
#define BIT_SET_VDP_DATA(x, v) (BIT_CLEAR_VDP_DATA(x) | BIT_VDP_DATA(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_SWR_CTRL1			(Offset 0x0010) */

#define BIT_SW18_C2_BIT0 BIT(31)

#endif

#if (HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_SYS_SWR_CTRL1			(Offset 0x0010) */

#define BIT_C2_L_BIT0 BIT(31)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_SWR_CTRL1			(Offset 0x0010) */

#define BIT_SHIFT_R1_L1_V1 30
#define BIT_MASK_R1_L1_V1 0x3
#define BIT_R1_L1_V1(x) (((x) & BIT_MASK_R1_L1_V1) << BIT_SHIFT_R1_L1_V1)
#define BITS_R1_L1_V1 (BIT_MASK_R1_L1_V1 << BIT_SHIFT_R1_L1_V1)
#define BIT_CLEAR_R1_L1_V1(x) ((x) & (~BITS_R1_L1_V1))
#define BIT_GET_R1_L1_V1(x) (((x) >> BIT_SHIFT_R1_L1_V1) & BIT_MASK_R1_L1_V1)
#define BIT_SET_R1_L1_V1(x, v) (BIT_CLEAR_R1_L1_V1(x) | BIT_R1_L1_V1(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_SWR_CTRL1			(Offset 0x0010) */

#define BIT_SHIFT_SW18_C1 29
#define BIT_MASK_SW18_C1 0x3
#define BIT_SW18_C1(x) (((x) & BIT_MASK_SW18_C1) << BIT_SHIFT_SW18_C1)
#define BITS_SW18_C1 (BIT_MASK_SW18_C1 << BIT_SHIFT_SW18_C1)
#define BIT_CLEAR_SW18_C1(x) ((x) & (~BITS_SW18_C1))
#define BIT_GET_SW18_C1(x) (((x) >> BIT_SHIFT_SW18_C1) & BIT_MASK_SW18_C1)
#define BIT_SET_SW18_C1(x, v) (BIT_CLEAR_SW18_C1(x) | BIT_SW18_C1(v))

#endif

#if (HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_SYS_SWR_CTRL1			(Offset 0x0010) */

#define BIT_SHIFT_C1_L 29
#define BIT_MASK_C1_L 0x3
#define BIT_C1_L(x) (((x) & BIT_MASK_C1_L) << BIT_SHIFT_C1_L)
#define BITS_C1_L (BIT_MASK_C1_L << BIT_SHIFT_C1_L)
#define BIT_CLEAR_C1_L(x) ((x) & (~BITS_C1_L))
#define BIT_GET_C1_L(x) (((x) >> BIT_SHIFT_C1_L) & BIT_MASK_C1_L)
#define BIT_SET_C1_L(x, v) (BIT_CLEAR_C1_L(x) | BIT_C1_L(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_SWR_CTRL1			(Offset 0x0010) */

#define BIT_SHIFT_C3_L1_V1 28
#define BIT_MASK_C3_L1_V1 0x3
#define BIT_C3_L1_V1(x) (((x) & BIT_MASK_C3_L1_V1) << BIT_SHIFT_C3_L1_V1)
#define BITS_C3_L1_V1 (BIT_MASK_C3_L1_V1 << BIT_SHIFT_C3_L1_V1)
#define BIT_CLEAR_C3_L1_V1(x) ((x) & (~BITS_C3_L1_V1))
#define BIT_GET_C3_L1_V1(x) (((x) >> BIT_SHIFT_C3_L1_V1) & BIT_MASK_C3_L1_V1)
#define BIT_SET_C3_L1_V1(x, v) (BIT_CLEAR_C3_L1_V1(x) | BIT_C3_L1_V1(v))

#define BIT_SHIFT_C2_L1_V1 26
#define BIT_MASK_C2_L1_V1 0x3
#define BIT_C2_L1_V1(x) (((x) & BIT_MASK_C2_L1_V1) << BIT_SHIFT_C2_L1_V1)
#define BITS_C2_L1_V1 (BIT_MASK_C2_L1_V1 << BIT_SHIFT_C2_L1_V1)
#define BIT_CLEAR_C2_L1_V1(x) ((x) & (~BITS_C2_L1_V1))
#define BIT_GET_C2_L1_V1(x) (((x) >> BIT_SHIFT_C2_L1_V1) & BIT_MASK_C2_L1_V1)
#define BIT_SET_C2_L1_V1(x, v) (BIT_CLEAR_C2_L1_V1(x) | BIT_C2_L1_V1(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_SYS_SWR_CTRL1			(Offset 0x0010) */

#define BIT_SHIFT_REG_FREQ_L 25
#define BIT_MASK_REG_FREQ_L 0x7
#define BIT_REG_FREQ_L(x) (((x) & BIT_MASK_REG_FREQ_L) << BIT_SHIFT_REG_FREQ_L)
#define BITS_REG_FREQ_L (BIT_MASK_REG_FREQ_L << BIT_SHIFT_REG_FREQ_L)
#define BIT_CLEAR_REG_FREQ_L(x) ((x) & (~BITS_REG_FREQ_L))
#define BIT_GET_REG_FREQ_L(x)                                                  \
	(((x) >> BIT_SHIFT_REG_FREQ_L) & BIT_MASK_REG_FREQ_L)
#define BIT_SET_REG_FREQ_L(x, v) (BIT_CLEAR_REG_FREQ_L(x) | BIT_REG_FREQ_L(v))

#define BIT_REG_EN_DUTY BIT(24)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_SWR_CTRL1			(Offset 0x0010) */

#define BIT_SHIFT_C1_L1_V1 24
#define BIT_MASK_C1_L1_V1 0x3
#define BIT_C1_L1_V1(x) (((x) & BIT_MASK_C1_L1_V1) << BIT_SHIFT_C1_L1_V1)
#define BITS_C1_L1_V1 (BIT_MASK_C1_L1_V1 << BIT_SHIFT_C1_L1_V1)
#define BIT_CLEAR_C1_L1_V1(x) ((x) & (~BITS_C1_L1_V1))
#define BIT_GET_C1_L1_V1(x) (((x) >> BIT_SHIFT_C1_L1_V1) & BIT_MASK_C1_L1_V1)
#define BIT_SET_C1_L1_V1(x, v) (BIT_CLEAR_C1_L1_V1(x) | BIT_C1_L1_V1(v))

#define BIT_REG_TYPE_L_V3 BIT(23)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_SYS_SWR_CTRL1			(Offset 0x0010) */

#define BIT_SHIFT_REG_MODE 22
#define BIT_MASK_REG_MODE 0x3
#define BIT_REG_MODE(x) (((x) & BIT_MASK_REG_MODE) << BIT_SHIFT_REG_MODE)
#define BITS_REG_MODE (BIT_MASK_REG_MODE << BIT_SHIFT_REG_MODE)
#define BIT_CLEAR_REG_MODE(x) ((x) & (~BITS_REG_MODE))
#define BIT_GET_REG_MODE(x) (((x) >> BIT_SHIFT_REG_MODE) & BIT_MASK_REG_MODE)
#define BIT_SET_REG_MODE(x, v) (BIT_CLEAR_REG_MODE(x) | BIT_REG_MODE(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_SWR_CTRL1			(Offset 0x0010) */

#define BIT_FPWM_L1_V1 BIT(22)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_SYS_SWR_CTRL1			(Offset 0x0010) */

#define BIT_REG_EN_SP BIT(21)
#define BIT_REG_AUTO_L BIT(20)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_SWR_CTRL1			(Offset 0x0010) */

#define BIT_SW18_SELD_BIT0 BIT(19)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_SWR_CTRL1			(Offset 0x0010) */

#define BIT_SHIFT_V15ADJ_L1 19
#define BIT_MASK_V15ADJ_L1 0x7
#define BIT_V15ADJ_L1(x) (((x) & BIT_MASK_V15ADJ_L1) << BIT_SHIFT_V15ADJ_L1)
#define BITS_V15ADJ_L1 (BIT_MASK_V15ADJ_L1 << BIT_SHIFT_V15ADJ_L1)
#define BIT_CLEAR_V15ADJ_L1(x) ((x) & (~BITS_V15ADJ_L1))
#define BIT_GET_V15ADJ_L1(x) (((x) >> BIT_SHIFT_V15ADJ_L1) & BIT_MASK_V15ADJ_L1)
#define BIT_SET_V15ADJ_L1(x, v) (BIT_CLEAR_V15ADJ_L1(x) | BIT_V15ADJ_L1(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_SWR_CTRL1			(Offset 0x0010) */

#define BIT_SW18_POWOCP BIT(18)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_SWR_CTRL1			(Offset 0x0010) */

#define BIT_SHIFT_IN_L1 16
#define BIT_MASK_IN_L1 0x7
#define BIT_IN_L1(x) (((x) & BIT_MASK_IN_L1) << BIT_SHIFT_IN_L1)
#define BITS_IN_L1 (BIT_MASK_IN_L1 << BIT_SHIFT_IN_L1)
#define BIT_CLEAR_IN_L1(x) ((x) & (~BITS_IN_L1))
#define BIT_GET_IN_L1(x) (((x) >> BIT_SHIFT_IN_L1) & BIT_MASK_IN_L1)
#define BIT_SET_IN_L1(x, v) (BIT_CLEAR_IN_L1(x) | BIT_IN_L1(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_SWR_CTRL1			(Offset 0x0010) */

#define BIT_SHIFT_SW18_OCP 15
#define BIT_MASK_SW18_OCP 0x7
#define BIT_SW18_OCP(x) (((x) & BIT_MASK_SW18_OCP) << BIT_SHIFT_SW18_OCP)
#define BITS_SW18_OCP (BIT_MASK_SW18_OCP << BIT_SHIFT_SW18_OCP)
#define BIT_CLEAR_SW18_OCP(x) ((x) & (~BITS_SW18_OCP))
#define BIT_GET_SW18_OCP(x) (((x) >> BIT_SHIFT_SW18_OCP) & BIT_MASK_SW18_OCP)
#define BIT_SET_SW18_OCP(x, v) (BIT_CLEAR_SW18_OCP(x) | BIT_SW18_OCP(v))

#endif

#if (HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_SYS_SWR_CTRL1			(Offset 0x0010) */

#define BIT_SHIFT_OCP_L1 15
#define BIT_MASK_OCP_L1 0x7
#define BIT_OCP_L1(x) (((x) & BIT_MASK_OCP_L1) << BIT_SHIFT_OCP_L1)
#define BITS_OCP_L1 (BIT_MASK_OCP_L1 << BIT_SHIFT_OCP_L1)
#define BIT_CLEAR_OCP_L1(x) ((x) & (~BITS_OCP_L1))
#define BIT_GET_OCP_L1(x) (((x) >> BIT_SHIFT_OCP_L1) & BIT_MASK_OCP_L1)
#define BIT_SET_OCP_L1(x, v) (BIT_CLEAR_OCP_L1(x) | BIT_OCP_L1(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_SWR_CTRL1			(Offset 0x0010) */

#define BIT_SHIFT_STD_L1 14
#define BIT_MASK_STD_L1 0x3
#define BIT_STD_L1(x) (((x) & BIT_MASK_STD_L1) << BIT_SHIFT_STD_L1)
#define BITS_STD_L1 (BIT_MASK_STD_L1 << BIT_SHIFT_STD_L1)
#define BIT_CLEAR_STD_L1(x) ((x) & (~BITS_STD_L1))
#define BIT_GET_STD_L1(x) (((x) >> BIT_SHIFT_STD_L1) & BIT_MASK_STD_L1)
#define BIT_SET_STD_L1(x, v) (BIT_CLEAR_STD_L1(x) | BIT_STD_L1(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_SWR_CTRL1			(Offset 0x0010) */

#define BIT_SHIFT_CF_L_BIT0_TO_1 13
#define BIT_MASK_CF_L_BIT0_TO_1 0x3
#define BIT_CF_L_BIT0_TO_1(x)                                                  \
	(((x) & BIT_MASK_CF_L_BIT0_TO_1) << BIT_SHIFT_CF_L_BIT0_TO_1)
#define BITS_CF_L_BIT0_TO_1                                                    \
	(BIT_MASK_CF_L_BIT0_TO_1 << BIT_SHIFT_CF_L_BIT0_TO_1)
#define BIT_CLEAR_CF_L_BIT0_TO_1(x) ((x) & (~BITS_CF_L_BIT0_TO_1))
#define BIT_GET_CF_L_BIT0_TO_1(x)                                              \
	(((x) >> BIT_SHIFT_CF_L_BIT0_TO_1) & BIT_MASK_CF_L_BIT0_TO_1)
#define BIT_SET_CF_L_BIT0_TO_1(x, v)                                           \
	(BIT_CLEAR_CF_L_BIT0_TO_1(x) | BIT_CF_L_BIT0_TO_1(v))

#endif

#if (HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_SYS_SWR_CTRL1			(Offset 0x0010) */

#define BIT_SHIFT_CF_L 13
#define BIT_MASK_CF_L 0x3
#define BIT_CF_L(x) (((x) & BIT_MASK_CF_L) << BIT_SHIFT_CF_L)
#define BITS_CF_L (BIT_MASK_CF_L << BIT_SHIFT_CF_L)
#define BIT_CLEAR_CF_L(x) ((x) & (~BITS_CF_L))
#define BIT_GET_CF_L(x) (((x) >> BIT_SHIFT_CF_L) & BIT_MASK_CF_L)
#define BIT_SET_CF_L(x, v) (BIT_CLEAR_CF_L(x) | BIT_CF_L(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_SWR_CTRL1			(Offset 0x0010) */

#define BIT_SW18_FPWM BIT(11)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_SWR_CTRL1			(Offset 0x0010) */

#define BIT_SPS_FPWM BIT(11)
#define BIT_WL_CTRL_SPS_PWMFREQ BIT(10)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_SWR_CTRL1			(Offset 0x0010) */

#define BIT_SHIFT_VOL_L1 10
#define BIT_MASK_VOL_L1 0xf
#define BIT_VOL_L1(x) (((x) & BIT_MASK_VOL_L1) << BIT_SHIFT_VOL_L1)
#define BITS_VOL_L1 (BIT_MASK_VOL_L1 << BIT_SHIFT_VOL_L1)
#define BIT_CLEAR_VOL_L1(x) ((x) & (~BITS_VOL_L1))
#define BIT_GET_VOL_L1(x) (((x) >> BIT_SHIFT_VOL_L1) & BIT_MASK_VOL_L1)
#define BIT_SET_VOL_L1(x, v) (BIT_CLEAR_VOL_L1(x) | BIT_VOL_L1(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_SWR_CTRL1			(Offset 0x0010) */

#define BIT_SW18_SWEN BIT(9)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_SWR_CTRL1			(Offset 0x0010) */

#define BIT_SPS_SWEN BIT(9)
#define BIT_HALF_L BIT(9)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_SWR_CTRL1			(Offset 0x0010) */

#define BIT_SW18_LDEN BIT(8)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_SWR_CTRL1			(Offset 0x0010) */

#define BIT_SPS_LDEN BIT(8)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_SWR_CTRL1			(Offset 0x0010) */

#define BIT_MAC_ID_EN BIT(7)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8814B_SUPPORT)

/* 2 REG_SYS_SWR_CTRL1			(Offset 0x0010) */

#define BIT_WL_CTRL_XTAL_CADJ BIT(6)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_SWR_CTRL1			(Offset 0x0010) */

#define BIT_LDO11_EN BIT(6)
#define BIT_AFE_P3_PC BIT(5)
#define BIT_AFE_P2_PC BIT(4)
#define BIT_AFE_P1_PC BIT(3)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_SWR_CTRL1			(Offset 0x0010) */

#define BIT_AFE_MBEN_PCIE_OPT BIT(2)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_SWR_CTRL1			(Offset 0x0010) */

#define BIT_AFE_P0_PC BIT(2)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_SWR_CTRL1			(Offset 0x0010) */

#define BIT_AFE_MBEN BIT(1)

#endif

#if (HALMAC_8812F_SUPPORT)

/* 2 REG_SDIO_CTRL_2				(Offset 0x10250010) */

#define BIT_SDIO_CLK_SMT_V1 BIT(1)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_SWR_CTRL1			(Offset 0x0010) */

#define BIT_AFE_BGEN BIT(0)

#endif

#if (HALMAC_8812F_SUPPORT)

/* 2 REG_SDIO_CTRL_2				(Offset 0x10250010) */

#define BIT_SDIO_DATA_SMT BIT(0)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_SWR_CTRL2			(Offset 0x0014) */

#define BIT_POW_ZCD_L BIT(31)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_HIMR				(Offset 0x10250014) */

#define BIT_SDIO_CRCERR_MSK BIT(31)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SDIO_HIMR				(Offset 0x10250014) */

#define BIT_IO_READY_SIGNAL_ERR_MSK BIT(31)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_SWR_CTRL2			(Offset 0x0014) */

#define BIT_ENABLE_ZCDOUT_L BIT(30)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_SYS_SWR_CTRL2			(Offset 0x0014) */

#define BIT_AUTOZCD_L BIT(30)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_HIMR				(Offset 0x10250014) */

#define BIT_SDIO_HSISR3_IND_MSK BIT(30)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SDIO_HIMR				(Offset 0x10250014) */

#define BIT_SDIO_TX_CRC__MSK BIT(30)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_HIMR				(Offset 0x10250014) */

#define BIT_SDIO_HSISR2_IND_MSK BIT(29)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_SWR_CTRL2			(Offset 0x0014) */

#define BIT_SHIFT_REG_DELAY 28
#define BIT_MASK_REG_DELAY 0x3
#define BIT_REG_DELAY(x) (((x) & BIT_MASK_REG_DELAY) << BIT_SHIFT_REG_DELAY)
#define BITS_REG_DELAY (BIT_MASK_REG_DELAY << BIT_SHIFT_REG_DELAY)
#define BIT_CLEAR_REG_DELAY(x) ((x) & (~BITS_REG_DELAY))
#define BIT_GET_REG_DELAY(x) (((x) >> BIT_SHIFT_REG_DELAY) & BIT_MASK_REG_DELAY)
#define BIT_SET_REG_DELAY(x, v) (BIT_CLEAR_REG_DELAY(x) | BIT_REG_DELAY(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_HIMR				(Offset 0x10250014) */

#define BIT_SDIO_HEISR_IND_MSK BIT(28)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_HIMR				(Offset 0x10250014) */

#define BIT_SDIO_CTWEND_MSK BIT(27)
#define BIT_SDIO_ATIMEND_E_MSK BIT(26)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_HIMR				(Offset 0x10250014) */

#define BIT_SDIIO_ATIMEND_MSK BIT(25)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SDIO_HIMR				(Offset 0x10250014) */

#define BIT_SDIO_ATIMEND_MSK BIT(25)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_SWR_CTRL2			(Offset 0x0014) */

#define BIT_SHIFT_SW18_V15ADJ 24
#define BIT_MASK_SW18_V15ADJ 0x7
#define BIT_SW18_V15ADJ(x)                                                     \
	(((x) & BIT_MASK_SW18_V15ADJ) << BIT_SHIFT_SW18_V15ADJ)
#define BITS_SW18_V15ADJ (BIT_MASK_SW18_V15ADJ << BIT_SHIFT_SW18_V15ADJ)
#define BIT_CLEAR_SW18_V15ADJ(x) ((x) & (~BITS_SW18_V15ADJ))
#define BIT_GET_SW18_V15ADJ(x)                                                 \
	(((x) >> BIT_SHIFT_SW18_V15ADJ) & BIT_MASK_SW18_V15ADJ)
#define BIT_SET_SW18_V15ADJ(x, v)                                              \
	(BIT_CLEAR_SW18_V15ADJ(x) | BIT_SW18_V15ADJ(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_SYS_SWR_CTRL2			(Offset 0x0014) */

#define BIT_SHIFT_V15ADJ_L1_V1 24
#define BIT_MASK_V15ADJ_L1_V1 0x7
#define BIT_V15ADJ_L1_V1(x)                                                    \
	(((x) & BIT_MASK_V15ADJ_L1_V1) << BIT_SHIFT_V15ADJ_L1_V1)
#define BITS_V15ADJ_L1_V1 (BIT_MASK_V15ADJ_L1_V1 << BIT_SHIFT_V15ADJ_L1_V1)
#define BIT_CLEAR_V15ADJ_L1_V1(x) ((x) & (~BITS_V15ADJ_L1_V1))
#define BIT_GET_V15ADJ_L1_V1(x)                                                \
	(((x) >> BIT_SHIFT_V15ADJ_L1_V1) & BIT_MASK_V15ADJ_L1_V1)
#define BIT_SET_V15ADJ_L1_V1(x, v)                                             \
	(BIT_CLEAR_V15ADJ_L1_V1(x) | BIT_V15ADJ_L1_V1(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_HIMR				(Offset 0x10250014) */

#define BIT_SDIO_OCPINT_MSK BIT(24)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_SWR_CTRL2			(Offset 0x0014) */

#define BIT_OCPSL BIT(24)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_HIMR				(Offset 0x10250014) */

#define BIT_SDIO_PSTIMEOUT_MSK BIT(23)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_SWR_CTRL2			(Offset 0x0014) */

#define BIT_REG_LDOF_L_V1 BIT(23)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_HIMR				(Offset 0x10250014) */

#define BIT_SDIO_GTINT4_MSK BIT(22)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_SWR_CTRL2			(Offset 0x0014) */

#define BIT_PARSW_DUMMY BIT(22)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_HIMR				(Offset 0x10250014) */

#define BIT_SDIO_GTINT3_MSK BIT(21)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_SWR_CTRL2			(Offset 0x0014) */

#define BIT_CLAMP_MAX_DUTY BIT(21)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_SWR_CTRL2			(Offset 0x0014) */

#define BIT_SHIFT_SW18_VOL 20
#define BIT_MASK_SW18_VOL 0xf
#define BIT_SW18_VOL(x) (((x) & BIT_MASK_SW18_VOL) << BIT_SHIFT_SW18_VOL)
#define BITS_SW18_VOL (BIT_MASK_SW18_VOL << BIT_SHIFT_SW18_VOL)
#define BIT_CLEAR_SW18_VOL(x) ((x) & (~BITS_SW18_VOL))
#define BIT_GET_SW18_VOL(x) (((x) >> BIT_SHIFT_SW18_VOL) & BIT_MASK_SW18_VOL)
#define BIT_SET_SW18_VOL(x, v) (BIT_CLEAR_SW18_VOL(x) | BIT_SW18_VOL(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_SYS_SWR_CTRL2			(Offset 0x0014) */

#define BIT_SHIFT_VOL_L1_V1 20
#define BIT_MASK_VOL_L1_V1 0xf
#define BIT_VOL_L1_V1(x) (((x) & BIT_MASK_VOL_L1_V1) << BIT_SHIFT_VOL_L1_V1)
#define BITS_VOL_L1_V1 (BIT_MASK_VOL_L1_V1 << BIT_SHIFT_VOL_L1_V1)
#define BIT_CLEAR_VOL_L1_V1(x) ((x) & (~BITS_VOL_L1_V1))
#define BIT_GET_VOL_L1_V1(x) (((x) >> BIT_SHIFT_VOL_L1_V1) & BIT_MASK_VOL_L1_V1)
#define BIT_SET_VOL_L1_V1(x, v) (BIT_CLEAR_VOL_L1_V1(x) | BIT_VOL_L1_V1(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_HIMR				(Offset 0x10250014) */

#define BIT_SDIO_HSISR_IND_MSK BIT(20)
#define BIT_SDIO_CPWM2_MSK BIT(19)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_SWR_CTRL2			(Offset 0x0014) */

#define BIT_SHIFT_TBOX_L1_V1 19
#define BIT_MASK_TBOX_L1_V1 0x3
#define BIT_TBOX_L1_V1(x) (((x) & BIT_MASK_TBOX_L1_V1) << BIT_SHIFT_TBOX_L1_V1)
#define BITS_TBOX_L1_V1 (BIT_MASK_TBOX_L1_V1 << BIT_SHIFT_TBOX_L1_V1)
#define BIT_CLEAR_TBOX_L1_V1(x) ((x) & (~BITS_TBOX_L1_V1))
#define BIT_GET_TBOX_L1_V1(x)                                                  \
	(((x) >> BIT_SHIFT_TBOX_L1_V1) & BIT_MASK_TBOX_L1_V1)
#define BIT_SET_TBOX_L1_V1(x, v) (BIT_CLEAR_TBOX_L1_V1(x) | BIT_TBOX_L1_V1(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_HIMR				(Offset 0x10250014) */

#define BIT_SDIO_CPWM1_MSK BIT(18)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_SWR_CTRL2			(Offset 0x0014) */

#define BIT_SHIFT_SW18_IN 17
#define BIT_MASK_SW18_IN 0x7
#define BIT_SW18_IN(x) (((x) & BIT_MASK_SW18_IN) << BIT_SHIFT_SW18_IN)
#define BITS_SW18_IN (BIT_MASK_SW18_IN << BIT_SHIFT_SW18_IN)
#define BIT_CLEAR_SW18_IN(x) ((x) & (~BITS_SW18_IN))
#define BIT_GET_SW18_IN(x) (((x) >> BIT_SHIFT_SW18_IN) & BIT_MASK_SW18_IN)
#define BIT_SET_SW18_IN(x, v) (BIT_CLEAR_SW18_IN(x) | BIT_SW18_IN(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_SYS_SWR_CTRL2			(Offset 0x0014) */

#define BIT_SHIFT_IN_L1_V1 17
#define BIT_MASK_IN_L1_V1 0x7
#define BIT_IN_L1_V1(x) (((x) & BIT_MASK_IN_L1_V1) << BIT_SHIFT_IN_L1_V1)
#define BITS_IN_L1_V1 (BIT_MASK_IN_L1_V1 << BIT_SHIFT_IN_L1_V1)
#define BIT_CLEAR_IN_L1_V1(x) ((x) & (~BITS_IN_L1_V1))
#define BIT_GET_IN_L1_V1(x) (((x) >> BIT_SHIFT_IN_L1_V1) & BIT_MASK_IN_L1_V1)
#define BIT_SET_IN_L1_V1(x, v) (BIT_CLEAR_IN_L1_V1(x) | BIT_IN_L1_V1(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_HIMR				(Offset 0x10250014) */

#define BIT_SDIO_C2HCMD_INT_MSK BIT(17)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_SWR_CTRL2			(Offset 0x0014) */

#define BIT_SHIFT_REG_DELAY_V3 17
#define BIT_MASK_REG_DELAY_V3 0x3
#define BIT_REG_DELAY_V3(x)                                                    \
	(((x) & BIT_MASK_REG_DELAY_V3) << BIT_SHIFT_REG_DELAY_V3)
#define BITS_REG_DELAY_V3 (BIT_MASK_REG_DELAY_V3 << BIT_SHIFT_REG_DELAY_V3)
#define BIT_CLEAR_REG_DELAY_V3(x) ((x) & (~BITS_REG_DELAY_V3))
#define BIT_GET_REG_DELAY_V3(x)                                                \
	(((x) >> BIT_SHIFT_REG_DELAY_V3) & BIT_MASK_REG_DELAY_V3)
#define BIT_SET_REG_DELAY_V3(x, v)                                             \
	(BIT_CLEAR_REG_DELAY_V3(x) | BIT_REG_DELAY_V3(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_HIMR				(Offset 0x10250014) */

#define BIT_SDIO_BCNERLY_INT_MSK BIT(16)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_SWR_CTRL2			(Offset 0x0014) */

#define BIT_REG_CLAMP_D_L_V2 BIT(16)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_SWR_CTRL2			(Offset 0x0014) */

#define BIT_SHIFT_SW18_TBOX 15
#define BIT_MASK_SW18_TBOX 0x3
#define BIT_SW18_TBOX(x) (((x) & BIT_MASK_SW18_TBOX) << BIT_SHIFT_SW18_TBOX)
#define BITS_SW18_TBOX (BIT_MASK_SW18_TBOX << BIT_SHIFT_SW18_TBOX)
#define BIT_CLEAR_SW18_TBOX(x) ((x) & (~BITS_SW18_TBOX))
#define BIT_GET_SW18_TBOX(x) (((x) >> BIT_SHIFT_SW18_TBOX) & BIT_MASK_SW18_TBOX)
#define BIT_SET_SW18_TBOX(x, v) (BIT_CLEAR_SW18_TBOX(x) | BIT_SW18_TBOX(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_SWR_CTRL2			(Offset 0x0014) */

#define BIT_REG_BYPASS_L_V3 BIT(15)

#endif

#if (HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_SYS_SWR_CTRL2			(Offset 0x0014) */

#define BIT_SHIFT_TBOX_L1 15
#define BIT_MASK_TBOX_L1 0x3
#define BIT_TBOX_L1(x) (((x) & BIT_MASK_TBOX_L1) << BIT_SHIFT_TBOX_L1)
#define BITS_TBOX_L1 (BIT_MASK_TBOX_L1 << BIT_SHIFT_TBOX_L1)
#define BIT_CLEAR_TBOX_L1(x) ((x) & (~BITS_TBOX_L1))
#define BIT_GET_TBOX_L1(x) (((x) >> BIT_SHIFT_TBOX_L1) & BIT_MASK_TBOX_L1)
#define BIT_SET_TBOX_L1(x, v) (BIT_CLEAR_TBOX_L1(x) | BIT_TBOX_L1(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_SWR_CTRL2			(Offset 0x0014) */

#define BIT_ENABLE_ZCDOUT_L_V3 BIT(14)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_SWR_CTRL2			(Offset 0x0014) */

#define BIT_SW18_SEL BIT(13)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_SWR_CTRL2			(Offset 0x0014) */

#define BIT_POW_ZCD_L_V3 BIT(13)
#define BIT_AREN_L1_V1 BIT(12)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_SWR_CTRL2			(Offset 0x0014) */

#define BIT_SHIFT_SW18_STD 11
#define BIT_MASK_SW18_STD 0x3
#define BIT_SW18_STD(x) (((x) & BIT_MASK_SW18_STD) << BIT_SHIFT_SW18_STD)
#define BITS_SW18_STD (BIT_MASK_SW18_STD << BIT_SHIFT_SW18_STD)
#define BIT_CLEAR_SW18_STD(x) ((x) & (~BITS_SW18_STD))
#define BIT_GET_SW18_STD(x) (((x) >> BIT_SHIFT_SW18_STD) & BIT_MASK_SW18_STD)
#define BIT_SET_SW18_STD(x, v) (BIT_CLEAR_SW18_STD(x) | BIT_SW18_STD(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_SWR_CTRL2			(Offset 0x0014) */

#define BIT_SW18_SD BIT(10)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_SWR_CTRL2			(Offset 0x0014) */

#define BIT_SW18_AREN BIT(9)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_SWR_CTRL2			(Offset 0x0014) */

#define BIT_SHIFT_OCP_V3 9
#define BIT_MASK_OCP_V3 0x7
#define BIT_OCP_V3(x) (((x) & BIT_MASK_OCP_V3) << BIT_SHIFT_OCP_V3)
#define BITS_OCP_V3 (BIT_MASK_OCP_V3 << BIT_SHIFT_OCP_V3)
#define BIT_CLEAR_OCP_V3(x) ((x) & (~BITS_OCP_V3))
#define BIT_GET_OCP_V3(x) (((x) >> BIT_SHIFT_OCP_V3) & BIT_MASK_OCP_V3)
#define BIT_SET_OCP_V3(x, v) (BIT_CLEAR_OCP_V3(x) | BIT_OCP_V3(v))

#define BIT_POWOCP_V3 BIT(8)

#endif

#if (HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_HIMR				(Offset 0x10250014) */

#define BIT_BT_INT_MASK BIT(8)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_SWR_CTRL2			(Offset 0x0014) */

#define BIT_SHIFT_SW18_R3 7
#define BIT_MASK_SW18_R3 0x3
#define BIT_SW18_R3(x) (((x) & BIT_MASK_SW18_R3) << BIT_SHIFT_SW18_R3)
#define BITS_SW18_R3 (BIT_MASK_SW18_R3 << BIT_SHIFT_SW18_R3)
#define BIT_CLEAR_SW18_R3(x) ((x) & (~BITS_SW18_R3))
#define BIT_GET_SW18_R3(x) (((x) >> BIT_SHIFT_SW18_R3) & BIT_MASK_SW18_R3)
#define BIT_SET_SW18_R3(x, v) (BIT_CLEAR_SW18_R3(x) | BIT_SW18_R3(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_HIMR				(Offset 0x10250014) */

#define BIT_SDIO_TXBCNERR_MSK BIT(7)

#endif

#if (HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_SYS_SWR_CTRL2			(Offset 0x0014) */

#define BIT_SHIFT_R3_L 7
#define BIT_MASK_R3_L 0x3
#define BIT_R3_L(x) (((x) & BIT_MASK_R3_L) << BIT_SHIFT_R3_L)
#define BITS_R3_L (BIT_MASK_R3_L << BIT_SHIFT_R3_L)
#define BIT_CLEAR_R3_L(x) ((x) & (~BITS_R3_L))
#define BIT_GET_R3_L(x) (((x) >> BIT_SHIFT_R3_L) & BIT_MASK_R3_L)
#define BIT_SET_R3_L(x, v) (BIT_CLEAR_R3_L(x) | BIT_R3_L(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_HIMR				(Offset 0x10250014) */

#define BIT_SDIO_TXBCNOK_MSK BIT(6)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_SWR_CTRL2			(Offset 0x0014) */

#define BIT_SHIFT_CF_L_V3 6
#define BIT_MASK_CF_L_V3 0x3
#define BIT_CF_L_V3(x) (((x) & BIT_MASK_CF_L_V3) << BIT_SHIFT_CF_L_V3)
#define BITS_CF_L_V3 (BIT_MASK_CF_L_V3 << BIT_SHIFT_CF_L_V3)
#define BIT_CLEAR_CF_L_V3(x) ((x) & (~BITS_CF_L_V3))
#define BIT_GET_CF_L_V3(x) (((x) >> BIT_SHIFT_CF_L_V3) & BIT_MASK_CF_L_V3)
#define BIT_SET_CF_L_V3(x, v) (BIT_CLEAR_CF_L_V3(x) | BIT_CF_L_V3(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_SWR_CTRL2			(Offset 0x0014) */

#define BIT_SHIFT_SW18_R2 5
#define BIT_MASK_SW18_R2 0x3
#define BIT_SW18_R2(x) (((x) & BIT_MASK_SW18_R2) << BIT_SHIFT_SW18_R2)
#define BITS_SW18_R2 (BIT_MASK_SW18_R2 << BIT_SHIFT_SW18_R2)
#define BIT_CLEAR_SW18_R2(x) ((x) & (~BITS_SW18_R2))
#define BIT_GET_SW18_R2(x) (((x) >> BIT_SHIFT_SW18_R2) & BIT_MASK_SW18_R2)
#define BIT_SET_SW18_R2(x, v) (BIT_CLEAR_SW18_R2(x) | BIT_SW18_R2(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_HIMR				(Offset 0x10250014) */

#define BIT_SDIO_RXFOVW_MSK BIT(5)
#define BIT_SDIO_TXFOVW_MSK BIT(4)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_SWR_CTRL2			(Offset 0x0014) */

#define BIT_SHIFT_CFC_L_BIT0_TO_1_V1 4
#define BIT_MASK_CFC_L_BIT0_TO_1_V1 0x3
#define BIT_CFC_L_BIT0_TO_1_V1(x)                                              \
	(((x) & BIT_MASK_CFC_L_BIT0_TO_1_V1) << BIT_SHIFT_CFC_L_BIT0_TO_1_V1)
#define BITS_CFC_L_BIT0_TO_1_V1                                                \
	(BIT_MASK_CFC_L_BIT0_TO_1_V1 << BIT_SHIFT_CFC_L_BIT0_TO_1_V1)
#define BIT_CLEAR_CFC_L_BIT0_TO_1_V1(x) ((x) & (~BITS_CFC_L_BIT0_TO_1_V1))
#define BIT_GET_CFC_L_BIT0_TO_1_V1(x)                                          \
	(((x) >> BIT_SHIFT_CFC_L_BIT0_TO_1_V1) & BIT_MASK_CFC_L_BIT0_TO_1_V1)
#define BIT_SET_CFC_L_BIT0_TO_1_V1(x, v)                                       \
	(BIT_CLEAR_CFC_L_BIT0_TO_1_V1(x) | BIT_CFC_L_BIT0_TO_1_V1(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_SWR_CTRL2			(Offset 0x0014) */

#define BIT_SHIFT_SW18_R1 3
#define BIT_MASK_SW18_R1 0x3
#define BIT_SW18_R1(x) (((x) & BIT_MASK_SW18_R1) << BIT_SHIFT_SW18_R1)
#define BITS_SW18_R1 (BIT_MASK_SW18_R1 << BIT_SHIFT_SW18_R1)
#define BIT_CLEAR_SW18_R1(x) ((x) & (~BITS_SW18_R1))
#define BIT_GET_SW18_R1(x) (((x) >> BIT_SHIFT_SW18_R1) & BIT_MASK_SW18_R1)
#define BIT_SET_SW18_R1(x, v) (BIT_CLEAR_SW18_R1(x) | BIT_SW18_R1(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_HIMR				(Offset 0x10250014) */

#define BIT_SDIO_RXERR_MSK BIT(3)
#define BIT_SDIO_TXERR_MSK BIT(2)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_SWR_CTRL2			(Offset 0x0014) */

#define BIT_SHIFT_R3_L1_V1 2
#define BIT_MASK_R3_L1_V1 0x3
#define BIT_R3_L1_V1(x) (((x) & BIT_MASK_R3_L1_V1) << BIT_SHIFT_R3_L1_V1)
#define BITS_R3_L1_V1 (BIT_MASK_R3_L1_V1 << BIT_SHIFT_R3_L1_V1)
#define BIT_CLEAR_R3_L1_V1(x) ((x) & (~BITS_R3_L1_V1))
#define BIT_GET_R3_L1_V1(x) (((x) >> BIT_SHIFT_R3_L1_V1) & BIT_MASK_R3_L1_V1)
#define BIT_SET_R3_L1_V1(x, v) (BIT_CLEAR_R3_L1_V1(x) | BIT_R3_L1_V1(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_SWR_CTRL2			(Offset 0x0014) */

#define BIT_SHIFT_SW18_C3 1
#define BIT_MASK_SW18_C3 0x3
#define BIT_SW18_C3(x) (((x) & BIT_MASK_SW18_C3) << BIT_SHIFT_SW18_C3)
#define BITS_SW18_C3 (BIT_MASK_SW18_C3 << BIT_SHIFT_SW18_C3)
#define BIT_CLEAR_SW18_C3(x) ((x) & (~BITS_SW18_C3))
#define BIT_GET_SW18_C3(x) (((x) >> BIT_SHIFT_SW18_C3) & BIT_MASK_SW18_C3)
#define BIT_SET_SW18_C3(x, v) (BIT_CLEAR_SW18_C3(x) | BIT_SW18_C3(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_HIMR				(Offset 0x10250014) */

#define BIT_SDIO_AVAL_MSK BIT(1)

#endif

#if (HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_SYS_SWR_CTRL2			(Offset 0x0014) */

#define BIT_SHIFT_C3_L_C3 1
#define BIT_MASK_C3_L_C3 0x3
#define BIT_C3_L_C3(x) (((x) & BIT_MASK_C3_L_C3) << BIT_SHIFT_C3_L_C3)
#define BITS_C3_L_C3 (BIT_MASK_C3_L_C3 << BIT_SHIFT_C3_L_C3)
#define BIT_CLEAR_C3_L_C3(x) ((x) & (~BITS_C3_L_C3))
#define BIT_GET_C3_L_C3(x) (((x) >> BIT_SHIFT_C3_L_C3) & BIT_MASK_C3_L_C3)
#define BIT_SET_C3_L_C3(x, v) (BIT_CLEAR_C3_L_C3(x) | BIT_C3_L_C3(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_SWR_CTRL2			(Offset 0x0014) */

#define BIT_SW18_C2_BIT1 BIT(0)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_HIMR				(Offset 0x10250014) */

#define BIT_RX_REQUEST_MSK BIT(0)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_SWR_CTRL2			(Offset 0x0014) */

#define BIT_SHIFT_R2_L1_V1 0
#define BIT_MASK_R2_L1_V1 0x3
#define BIT_R2_L1_V1(x) (((x) & BIT_MASK_R2_L1_V1) << BIT_SHIFT_R2_L1_V1)
#define BITS_R2_L1_V1 (BIT_MASK_R2_L1_V1 << BIT_SHIFT_R2_L1_V1)
#define BIT_CLEAR_R2_L1_V1(x) ((x) & (~BITS_R2_L1_V1))
#define BIT_GET_R2_L1_V1(x) (((x) >> BIT_SHIFT_R2_L1_V1) & BIT_MASK_R2_L1_V1)
#define BIT_SET_R2_L1_V1(x, v) (BIT_CLEAR_R2_L1_V1(x) | BIT_R2_L1_V1(v))

#endif

#if (HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_SYS_SWR_CTRL2			(Offset 0x0014) */

#define BIT_C2_L_BIT1 BIT(0)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_SWR_CTRL3			(Offset 0x0018) */

#define BIT_SPS18_OCP_DIS BIT(31)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_HISR				(Offset 0x10250018) */

#define BIT_SDIO_CRCERR BIT(31)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SDIO_HISR				(Offset 0x10250018) */

#define BIT_IO_READY_SIGNAL_ERR BIT(31)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_HISR				(Offset 0x10250018) */

#define BIT_SDIO_HSISR3_IND BIT(30)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SDIO_HISR				(Offset 0x10250018) */

#define BIT_TX_CRC BIT(30)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_HISR				(Offset 0x10250018) */

#define BIT_SDIO_HSISR2_IND BIT(29)
#define BIT_SDIO_HEISR_IND BIT(28)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_HISR				(Offset 0x10250018) */

#define BIT_SDIO_CTWEND BIT(27)
#define BIT_SDIO_ATIMEND_E BIT(26)
#define BIT_SDIO_ATIMEND BIT(25)
#define BIT_SDIO_OCPINT BIT(24)
#define BIT_SDIO_PSTIMEOUT BIT(23)
#define BIT_SDIO_GTINT4 BIT(22)
#define BIT_SDIO_GTINT3 BIT(21)
#define BIT_SDIO_HSISR_IND BIT(20)
#define BIT_SDIO_CPWM2 BIT(19)
#define BIT_SDIO_CPWM1 BIT(18)
#define BIT_SDIO_C2HCMD_INT BIT(17)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_SWR_CTRL3			(Offset 0x0018) */

#define BIT_SHIFT_SPS18_OCP_TH 16
#define BIT_MASK_SPS18_OCP_TH 0x7fff
#define BIT_SPS18_OCP_TH(x)                                                    \
	(((x) & BIT_MASK_SPS18_OCP_TH) << BIT_SHIFT_SPS18_OCP_TH)
#define BITS_SPS18_OCP_TH (BIT_MASK_SPS18_OCP_TH << BIT_SHIFT_SPS18_OCP_TH)
#define BIT_CLEAR_SPS18_OCP_TH(x) ((x) & (~BITS_SPS18_OCP_TH))
#define BIT_GET_SPS18_OCP_TH(x)                                                \
	(((x) >> BIT_SHIFT_SPS18_OCP_TH) & BIT_MASK_SPS18_OCP_TH)
#define BIT_SET_SPS18_OCP_TH(x, v)                                             \
	(BIT_CLEAR_SPS18_OCP_TH(x) | BIT_SPS18_OCP_TH(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_HISR				(Offset 0x10250018) */

#define BIT_SDIO_BCNERLY_INT BIT(16)

#endif

#if (HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_HISR				(Offset 0x10250018) */

#define BIT_BT_INT BIT(8)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_HISR				(Offset 0x10250018) */

#define BIT_SDIO_TXBCNERR BIT(7)
#define BIT_SDIO_TXBCNOK BIT(6)
#define BIT_SDIO_RXFOVW BIT(5)
#define BIT_SDIO_TXFOVW BIT(4)
#define BIT_SDIO_RXERR BIT(3)
#define BIT_SDIO_TXERR BIT(2)
#define BIT_SDIO_AVAL BIT(1)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_SWR_CTRL3			(Offset 0x0018) */

#define BIT_SHIFT_OCP_WINDOW 0
#define BIT_MASK_OCP_WINDOW 0xffff
#define BIT_OCP_WINDOW(x) (((x) & BIT_MASK_OCP_WINDOW) << BIT_SHIFT_OCP_WINDOW)
#define BITS_OCP_WINDOW (BIT_MASK_OCP_WINDOW << BIT_SHIFT_OCP_WINDOW)
#define BIT_CLEAR_OCP_WINDOW(x) ((x) & (~BITS_OCP_WINDOW))
#define BIT_GET_OCP_WINDOW(x)                                                  \
	(((x) >> BIT_SHIFT_OCP_WINDOW) & BIT_MASK_OCP_WINDOW)
#define BIT_SET_OCP_WINDOW(x, v) (BIT_CLEAR_OCP_WINDOW(x) | BIT_OCP_WINDOW(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_HISR				(Offset 0x10250018) */

#define BIT_RX_REQUEST BIT(0)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_RSV_CTRL				(Offset 0x001C) */

#define BIT_HREG_DBG BIT(23)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT)

/* 2 REG_RSV_CTRL				(Offset 0x001C) */

#define BIT_SHIFT_HREG_DBG_V1 12
#define BIT_MASK_HREG_DBG_V1 0xfff
#define BIT_HREG_DBG_V1(x)                                                     \
	(((x) & BIT_MASK_HREG_DBG_V1) << BIT_SHIFT_HREG_DBG_V1)
#define BITS_HREG_DBG_V1 (BIT_MASK_HREG_DBG_V1 << BIT_SHIFT_HREG_DBG_V1)
#define BIT_CLEAR_HREG_DBG_V1(x) ((x) & (~BITS_HREG_DBG_V1))
#define BIT_GET_HREG_DBG_V1(x)                                                 \
	(((x) >> BIT_SHIFT_HREG_DBG_V1) & BIT_MASK_HREG_DBG_V1)
#define BIT_SET_HREG_DBG_V1(x, v)                                              \
	(BIT_CLEAR_HREG_DBG_V1(x) | BIT_HREG_DBG_V1(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_RSV_CTRL				(Offset 0x001C) */

#define BIT_MCU_RST BIT(11)
#define BIT_WLOCK_90 BIT(10)
#define BIT_WLOCK_70 BIT(9)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_RSV_CTRL				(Offset 0x001C) */

#define BIT_WLMCUIOIF BIT(8)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_RSV_CTRL				(Offset 0x001C) */

#define BIT_WLOCK_78 BIT(8)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_RSV_CTRL				(Offset 0x001C) */

#define BIT_LOCK_ALL_EN BIT(7)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_RSV_CTRL				(Offset 0x001C) */

#define BIT_R_DIS_PRST BIT(6)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_RSV_CTRL				(Offset 0x001C) */

#define BIT_R_DIS_PRST_1 BIT(6)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_RSV_CTRL				(Offset 0x001C) */

#define BIT_WLOCK_1C_B6 BIT(5)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_RSV_CTRL				(Offset 0x001C) */

#define BIT_R_DIS_PRST_0 BIT(5)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_RSV_CTRL				(Offset 0x001C) */

#define BIT_WLOCK_40 BIT(4)
#define BIT_WLOCK_08 BIT(3)
#define BIT_WLOCK_04 BIT(2)
#define BIT_WLOCK_00 BIT(1)
#define BIT_WLOCK_ALL BIT(0)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_RX_REQ_LEN			(Offset 0x1025001C) */

#define BIT_SHIFT_RX_REQ_LEN_V1 0
#define BIT_MASK_RX_REQ_LEN_V1 0x3ffff
#define BIT_RX_REQ_LEN_V1(x)                                                   \
	(((x) & BIT_MASK_RX_REQ_LEN_V1) << BIT_SHIFT_RX_REQ_LEN_V1)
#define BITS_RX_REQ_LEN_V1 (BIT_MASK_RX_REQ_LEN_V1 << BIT_SHIFT_RX_REQ_LEN_V1)
#define BIT_CLEAR_RX_REQ_LEN_V1(x) ((x) & (~BITS_RX_REQ_LEN_V1))
#define BIT_GET_RX_REQ_LEN_V1(x)                                               \
	(((x) >> BIT_SHIFT_RX_REQ_LEN_V1) & BIT_MASK_RX_REQ_LEN_V1)
#define BIT_SET_RX_REQ_LEN_V1(x, v)                                            \
	(BIT_CLEAR_RX_REQ_LEN_V1(x) | BIT_RX_REQ_LEN_V1(v))

#endif

#if (HALMAC_8822C_SUPPORT)

/* 2 REG_RF_CTRL				(Offset 0x001F) */

#define BIT_S0_RFC_WO_0 BIT(7)
#define BIT_S0_RFC_WT_0 BIT(6)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_RF_CTRL				(Offset 0x001F) */

#define BIT_RF_SDMRSTB BIT(2)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_RF0_CTRL				(Offset 0x001F) */

#define BIT_RF0_SDMRSTB BIT(2)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_RF_CTRL				(Offset 0x001F) */

#define BIT_RF_RSTB BIT(1)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_RF0_CTRL				(Offset 0x001F) */

#define BIT_RF0_RSTB BIT(1)

#endif

#if (HALMAC_8822C_SUPPORT)

/* 2 REG_RF_CTRL				(Offset 0x001F) */

#define BIT_S0_RFC_RSTB BIT(1)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_RF_CTRL				(Offset 0x001F) */

#define BIT_RF_EN BIT(0)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_RF0_CTRL				(Offset 0x001F) */

#define BIT_RF0_EN BIT(0)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_FREE_TXPG_SEQ_V1		(Offset 0x1025001F) */

#define BIT_SHIFT_FREE_TXPG_SEQ 0
#define BIT_MASK_FREE_TXPG_SEQ 0xff
#define BIT_FREE_TXPG_SEQ(x)                                                   \
	(((x) & BIT_MASK_FREE_TXPG_SEQ) << BIT_SHIFT_FREE_TXPG_SEQ)
#define BITS_FREE_TXPG_SEQ (BIT_MASK_FREE_TXPG_SEQ << BIT_SHIFT_FREE_TXPG_SEQ)
#define BIT_CLEAR_FREE_TXPG_SEQ(x) ((x) & (~BITS_FREE_TXPG_SEQ))
#define BIT_GET_FREE_TXPG_SEQ(x)                                               \
	(((x) >> BIT_SHIFT_FREE_TXPG_SEQ) & BIT_MASK_FREE_TXPG_SEQ)
#define BIT_SET_FREE_TXPG_SEQ(x, v)                                            \
	(BIT_CLEAR_FREE_TXPG_SEQ(x) | BIT_FREE_TXPG_SEQ(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_R_SYM_WLPON_EMEM1_EN BIT(31)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_LPLDH12_RSV1 BIT(31)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_R_SYM_WLPON_EMEM0_EN BIT(30)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_LPLDH12_RSV0 BIT(30)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_SHIFT_LPLDH12_RSV 29
#define BIT_MASK_LPLDH12_RSV 0x7
#define BIT_LPLDH12_RSV(x)                                                     \
	(((x) & BIT_MASK_LPLDH12_RSV) << BIT_SHIFT_LPLDH12_RSV)
#define BITS_LPLDH12_RSV (BIT_MASK_LPLDH12_RSV << BIT_SHIFT_LPLDH12_RSV)
#define BIT_CLEAR_LPLDH12_RSV(x) ((x) & (~BITS_LPLDH12_RSV))
#define BIT_GET_LPLDH12_RSV(x)                                                 \
	(((x) >> BIT_SHIFT_LPLDH12_RSV) & BIT_MASK_LPLDH12_RSV)
#define BIT_SET_LPLDH12_RSV(x, v)                                              \
	(BIT_CLEAR_LPLDH12_RSV(x) | BIT_LPLDH12_RSV(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || \
     HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_LPLDH12_SLP BIT(28)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_R_SYM_WLPOFF_P4EN BIT(28)
#define BIT_R_SYM_WLPOFF_P3EN BIT(27)
#define BIT_R_SYM_WLPOFF_P2EN BIT(26)
#define BIT_R_SYM_WLPOFF_P1EN BIT(25)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || \
     HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_SHIFT_LPLDH12_VADJ 24
#define BIT_MASK_LPLDH12_VADJ 0xf
#define BIT_LPLDH12_VADJ(x)                                                    \
	(((x) & BIT_MASK_LPLDH12_VADJ) << BIT_SHIFT_LPLDH12_VADJ)
#define BITS_LPLDH12_VADJ (BIT_MASK_LPLDH12_VADJ << BIT_SHIFT_LPLDH12_VADJ)
#define BIT_CLEAR_LPLDH12_VADJ(x) ((x) & (~BITS_LPLDH12_VADJ))
#define BIT_GET_LPLDH12_VADJ(x)                                                \
	(((x) >> BIT_SHIFT_LPLDH12_VADJ) & BIT_MASK_LPLDH12_VADJ)
#define BIT_SET_LPLDH12_VADJ(x, v)                                             \
	(BIT_CLEAR_LPLDH12_VADJ(x) | BIT_LPLDH12_VADJ(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_R_SYM_WLPOFF_EN BIT(24)
#define BIT_R_SYM_WLPON_P3EN BIT(21)
#define BIT_R_SYM_WLPON_P2EN BIT(20)
#define BIT_R_SYM_WLPON_P1EN BIT(19)
#define BIT_R_SYM_WLPON_EN BIT(18)

#endif

#if (HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_PCIE_CALIB_EN BIT(17)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_LDH12_EN BIT(16)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_FREE_TXPG			(Offset 0x10250020) */

#define BIT_SHIFT_MID_FREEPG_V1 16
#define BIT_MASK_MID_FREEPG_V1 0xfff
#define BIT_MID_FREEPG_V1(x)                                                   \
	(((x) & BIT_MASK_MID_FREEPG_V1) << BIT_SHIFT_MID_FREEPG_V1)
#define BITS_MID_FREEPG_V1 (BIT_MASK_MID_FREEPG_V1 << BIT_SHIFT_MID_FREEPG_V1)
#define BIT_CLEAR_MID_FREEPG_V1(x) ((x) & (~BITS_MID_FREEPG_V1))
#define BIT_GET_MID_FREEPG_V1(x)                                               \
	(((x) >> BIT_SHIFT_MID_FREEPG_V1) & BIT_MASK_MID_FREEPG_V1)
#define BIT_SET_MID_FREEPG_V1(x, v)                                            \
	(BIT_CLEAR_MID_FREEPG_V1(x) | BIT_MID_FREEPG_V1(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_R_SYM_LDOV12D_STBY BIT(16)

#endif

#if (HALMAC_8812F_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_BB_POWER_CUT_CTRL_BY_BB BIT(15)

#endif

#if (HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_WLBBOFF_BIG_PWC_EN BIT(14)

#endif

#if (HALMAC_8198F_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_SHIFT_XTAL_GM_REP_V8 13
#define BIT_MASK_XTAL_GM_REP_V8 0x3
#define BIT_XTAL_GM_REP_V8(x)                                                  \
	(((x) & BIT_MASK_XTAL_GM_REP_V8) << BIT_SHIFT_XTAL_GM_REP_V8)
#define BITS_XTAL_GM_REP_V8                                                    \
	(BIT_MASK_XTAL_GM_REP_V8 << BIT_SHIFT_XTAL_GM_REP_V8)
#define BIT_CLEAR_XTAL_GM_REP_V8(x) ((x) & (~BITS_XTAL_GM_REP_V8))
#define BIT_GET_XTAL_GM_REP_V8(x)                                              \
	(((x) >> BIT_SHIFT_XTAL_GM_REP_V8) & BIT_MASK_XTAL_GM_REP_V8)
#define BIT_SET_XTAL_GM_REP_V8(x, v)                                           \
	(BIT_CLEAR_XTAL_GM_REP_V8(x) | BIT_XTAL_GM_REP_V8(v))

#endif

#if (HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_WLBBOFF_SMALL_PWC_EN BIT(13)

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_POW_REGU_P3 BIT(12)

#endif

#if (HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_WLMACOFF_BIG_PWC_EN BIT(12)

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_POW_REGU_P2 BIT(11)

#endif

#if (HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_WLPON_PWC_EN BIT(11)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_POW_REGU_P1 BIT(10)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_MEM_DS_EN BIT(9)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_R_SYM_WLBBOFF1_P4_EN BIT(9)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_LDOV12W_EN BIT(8)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_R_SYM_WLBBOFF1_P3_EN BIT(8)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_SHIFT_ANAPAR_RFC2 8
#define BIT_MASK_ANAPAR_RFC2 0xff
#define BIT_ANAPAR_RFC2(x)                                                     \
	(((x) & BIT_MASK_ANAPAR_RFC2) << BIT_SHIFT_ANAPAR_RFC2)
#define BITS_ANAPAR_RFC2 (BIT_MASK_ANAPAR_RFC2 << BIT_SHIFT_ANAPAR_RFC2)
#define BIT_CLEAR_ANAPAR_RFC2(x) ((x) & (~BITS_ANAPAR_RFC2))
#define BIT_GET_ANAPAR_RFC2(x)                                                 \
	(((x) >> BIT_SHIFT_ANAPAR_RFC2) & BIT_MASK_ANAPAR_RFC2)
#define BIT_SET_ANAPAR_RFC2(x, v)                                              \
	(BIT_CLEAR_ANAPAR_RFC2(x) | BIT_ANAPAR_RFC2(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_EX_XTAL_DRV_DIGI BIT(7)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_R_SYM_WLBBOFF1_P2_EN BIT(7)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_EX_XTAL_DRV_USB BIT(6)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_R_SYM_WLBBOFF1_P1_EN BIT(6)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_EX_XTAL_DRV_AFE BIT(5)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_SHIFT_LDA12_VOADJ 4
#define BIT_MASK_LDA12_VOADJ 0xf
#define BIT_LDA12_VOADJ(x)                                                     \
	(((x) & BIT_MASK_LDA12_VOADJ) << BIT_SHIFT_LDA12_VOADJ)
#define BITS_LDA12_VOADJ (BIT_MASK_LDA12_VOADJ << BIT_SHIFT_LDA12_VOADJ)
#define BIT_CLEAR_LDA12_VOADJ(x) ((x) & (~BITS_LDA12_VOADJ))
#define BIT_GET_LDA12_VOADJ(x)                                                 \
	(((x) >> BIT_SHIFT_LDA12_VOADJ) & BIT_MASK_LDA12_VOADJ)
#define BIT_SET_LDA12_VOADJ(x, v)                                              \
	(BIT_CLEAR_LDA12_VOADJ(x) | BIT_LDA12_VOADJ(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_EX_XTAL_DRV_RF2 BIT(4)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_R_SYM_WLBBOFF_P4_EN BIT(4)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_REG_VOS BIT(3)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_EX_XTAL_DRV_RF1 BIT(3)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_R_SYM_WLBBOFF_P3_EN BIT(3)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_POW_REGU_P0 BIT(2)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_R_SYM_WLBBOFF_P2_EN BIT(2)
#define BIT_R_SYM_WLBBOFF_P1_EN BIT(1)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_LDA12_EN BIT(0)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_POW_PLL_LDO BIT(0)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_FREE_TXPG			(Offset 0x10250020) */

#define BIT_SHIFT_HIQ_FREEPG_V1 0
#define BIT_MASK_HIQ_FREEPG_V1 0xfff
#define BIT_HIQ_FREEPG_V1(x)                                                   \
	(((x) & BIT_MASK_HIQ_FREEPG_V1) << BIT_SHIFT_HIQ_FREEPG_V1)
#define BITS_HIQ_FREEPG_V1 (BIT_MASK_HIQ_FREEPG_V1 << BIT_SHIFT_HIQ_FREEPG_V1)
#define BIT_CLEAR_HIQ_FREEPG_V1(x) ((x) & (~BITS_HIQ_FREEPG_V1))
#define BIT_GET_HIQ_FREEPG_V1(x)                                               \
	(((x) >> BIT_SHIFT_HIQ_FREEPG_V1) & BIT_MASK_HIQ_FREEPG_V1)
#define BIT_SET_HIQ_FREEPG_V1(x, v)                                            \
	(BIT_CLEAR_HIQ_FREEPG_V1(x) | BIT_HIQ_FREEPG_V1(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_R_SYM_WLBBOFF_EN BIT(0)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_LDO_CTRL			(Offset 0x0020) */

#define BIT_SHIFT_ANAPAR_RFC1 0
#define BIT_MASK_ANAPAR_RFC1 0xff
#define BIT_ANAPAR_RFC1(x)                                                     \
	(((x) & BIT_MASK_ANAPAR_RFC1) << BIT_SHIFT_ANAPAR_RFC1)
#define BITS_ANAPAR_RFC1 (BIT_MASK_ANAPAR_RFC1 << BIT_SHIFT_ANAPAR_RFC1)
#define BIT_CLEAR_ANAPAR_RFC1(x) ((x) & (~BITS_ANAPAR_RFC1))
#define BIT_GET_ANAPAR_RFC1(x)                                                 \
	(((x) >> BIT_SHIFT_ANAPAR_RFC1) & BIT_MASK_ANAPAR_RFC1)
#define BIT_SET_ANAPAR_RFC1(x, v)                                              \
	(BIT_CLEAR_ANAPAR_RFC1(x) | BIT_ANAPAR_RFC1(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_AGPIO_GPE BIT(31)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_XQSEL_V3 BIT(31)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_SHIFT_REG_CC 30
#define BIT_MASK_REG_CC 0x3
#define BIT_REG_CC(x) (((x) & BIT_MASK_REG_CC) << BIT_SHIFT_REG_CC)
#define BITS_REG_CC (BIT_MASK_REG_CC << BIT_SHIFT_REG_CC)
#define BIT_CLEAR_REG_CC(x) ((x) & (~BITS_REG_CC))
#define BIT_GET_REG_CC(x) (((x) >> BIT_SHIFT_REG_CC) & BIT_MASK_REG_CC)
#define BIT_SET_REG_CC(x, v) (BIT_CLEAR_REG_CC(x) | BIT_REG_CC(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_CKDELAY_AFE_V1 BIT(30)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_CKDLY_DIG BIT(28)
#define BIT_CKDLY_USB BIT(27)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_SHIFT_XTAL_GPIO_V1 27
#define BIT_MASK_XTAL_GPIO_V1 0x7
#define BIT_XTAL_GPIO_V1(x)                                                    \
	(((x) & BIT_MASK_XTAL_GPIO_V1) << BIT_SHIFT_XTAL_GPIO_V1)
#define BITS_XTAL_GPIO_V1 (BIT_MASK_XTAL_GPIO_V1 << BIT_SHIFT_XTAL_GPIO_V1)
#define BIT_CLEAR_XTAL_GPIO_V1(x) ((x) & (~BITS_XTAL_GPIO_V1))
#define BIT_GET_XTAL_GPIO_V1(x)                                                \
	(((x) >> BIT_SHIFT_XTAL_GPIO_V1) & BIT_MASK_XTAL_GPIO_V1)
#define BIT_SET_XTAL_GPIO_V1(x, v)                                             \
	(BIT_CLEAR_XTAL_GPIO_V1(x) | BIT_XTAL_GPIO_V1(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_CKDLY_AFE BIT(26)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_SHIFT_XTAL_CAP_XI 25
#define BIT_MASK_XTAL_CAP_XI 0x3f
#define BIT_XTAL_CAP_XI(x)                                                     \
	(((x) & BIT_MASK_XTAL_CAP_XI) << BIT_SHIFT_XTAL_CAP_XI)
#define BITS_XTAL_CAP_XI (BIT_MASK_XTAL_CAP_XI << BIT_SHIFT_XTAL_CAP_XI)
#define BIT_CLEAR_XTAL_CAP_XI(x) ((x) & (~BITS_XTAL_CAP_XI))
#define BIT_GET_XTAL_CAP_XI(x)                                                 \
	(((x) >> BIT_SHIFT_XTAL_CAP_XI) & BIT_MASK_XTAL_CAP_XI)
#define BIT_SET_XTAL_CAP_XI(x, v)                                              \
	(BIT_CLEAR_XTAL_CAP_XI(x) | BIT_XTAL_CAP_XI(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_SHIFT_XTAL_DIG_DRV_1_TO_0 25
#define BIT_MASK_XTAL_DIG_DRV_1_TO_0 0x3
#define BIT_XTAL_DIG_DRV_1_TO_0(x)                                             \
	(((x) & BIT_MASK_XTAL_DIG_DRV_1_TO_0) << BIT_SHIFT_XTAL_DIG_DRV_1_TO_0)
#define BITS_XTAL_DIG_DRV_1_TO_0                                               \
	(BIT_MASK_XTAL_DIG_DRV_1_TO_0 << BIT_SHIFT_XTAL_DIG_DRV_1_TO_0)
#define BIT_CLEAR_XTAL_DIG_DRV_1_TO_0(x) ((x) & (~BITS_XTAL_DIG_DRV_1_TO_0))
#define BIT_GET_XTAL_DIG_DRV_1_TO_0(x)                                         \
	(((x) >> BIT_SHIFT_XTAL_DIG_DRV_1_TO_0) & BIT_MASK_XTAL_DIG_DRV_1_TO_0)
#define BIT_SET_XTAL_DIG_DRV_1_TO_0(x, v)                                      \
	(BIT_CLEAR_XTAL_DIG_DRV_1_TO_0(x) | BIT_XTAL_DIG_DRV_1_TO_0(v))

#define BIT_XTAL_GDIG BIT(24)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_SHIFT_XTAL_GPIO 23
#define BIT_MASK_XTAL_GPIO 0x7
#define BIT_XTAL_GPIO(x) (((x) & BIT_MASK_XTAL_GPIO) << BIT_SHIFT_XTAL_GPIO)
#define BITS_XTAL_GPIO (BIT_MASK_XTAL_GPIO << BIT_SHIFT_XTAL_GPIO)
#define BIT_CLEAR_XTAL_GPIO(x) ((x) & (~BITS_XTAL_GPIO))
#define BIT_GET_XTAL_GPIO(x) (((x) >> BIT_SHIFT_XTAL_GPIO) & BIT_MASK_XTAL_GPIO)
#define BIT_SET_XTAL_GPIO(x, v) (BIT_CLEAR_XTAL_GPIO(x) | BIT_XTAL_GPIO(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_SHIFT_XTAL_DRV_DIGI 23
#define BIT_MASK_XTAL_DRV_DIGI 0x3
#define BIT_XTAL_DRV_DIGI(x)                                                   \
	(((x) & BIT_MASK_XTAL_DRV_DIGI) << BIT_SHIFT_XTAL_DRV_DIGI)
#define BITS_XTAL_DRV_DIGI (BIT_MASK_XTAL_DRV_DIGI << BIT_SHIFT_XTAL_DRV_DIGI)
#define BIT_CLEAR_XTAL_DRV_DIGI(x) ((x) & (~BITS_XTAL_DRV_DIGI))
#define BIT_GET_XTAL_DRV_DIGI(x)                                               \
	(((x) >> BIT_SHIFT_XTAL_DRV_DIGI) & BIT_MASK_XTAL_DRV_DIGI)
#define BIT_SET_XTAL_DRV_DIGI(x, v)                                            \
	(BIT_CLEAR_XTAL_DRV_DIGI(x) | BIT_XTAL_DRV_DIGI(v))

#define BIT_XTAL_DRV_USB_BIT1 BIT(22)

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_XTAL_DRV_RF_LATCH_V2 BIT(22)

#endif

#if (HALMAC_8814A_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_SHIFT_XTAL_RDRV_RF2_1_TO_0 22
#define BIT_MASK_XTAL_RDRV_RF2_1_TO_0 0x3
#define BIT_XTAL_RDRV_RF2_1_TO_0(x)                                            \
	(((x) & BIT_MASK_XTAL_RDRV_RF2_1_TO_0)                                 \
	 << BIT_SHIFT_XTAL_RDRV_RF2_1_TO_0)
#define BITS_XTAL_RDRV_RF2_1_TO_0                                              \
	(BIT_MASK_XTAL_RDRV_RF2_1_TO_0 << BIT_SHIFT_XTAL_RDRV_RF2_1_TO_0)
#define BIT_CLEAR_XTAL_RDRV_RF2_1_TO_0(x) ((x) & (~BITS_XTAL_RDRV_RF2_1_TO_0))
#define BIT_GET_XTAL_RDRV_RF2_1_TO_0(x)                                        \
	(((x) >> BIT_SHIFT_XTAL_RDRV_RF2_1_TO_0) &                             \
	 BIT_MASK_XTAL_RDRV_RF2_1_TO_0)
#define BIT_SET_XTAL_RDRV_RF2_1_TO_0(x, v)                                     \
	(BIT_CLEAR_XTAL_RDRV_RF2_1_TO_0(x) | BIT_XTAL_RDRV_RF2_1_TO_0(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_XTAL_GMN_4 BIT(21)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_SHIFT_MAC_CLK_SEL 20
#define BIT_MASK_MAC_CLK_SEL 0x3
#define BIT_MAC_CLK_SEL(x)                                                     \
	(((x) & BIT_MASK_MAC_CLK_SEL) << BIT_SHIFT_MAC_CLK_SEL)
#define BITS_MAC_CLK_SEL (BIT_MASK_MAC_CLK_SEL << BIT_SHIFT_MAC_CLK_SEL)
#define BIT_CLEAR_MAC_CLK_SEL(x) ((x) & (~BITS_MAC_CLK_SEL))
#define BIT_GET_MAC_CLK_SEL(x)                                                 \
	(((x) >> BIT_SHIFT_MAC_CLK_SEL) & BIT_MASK_MAC_CLK_SEL)
#define BIT_SET_MAC_CLK_SEL(x, v)                                              \
	(BIT_CLEAR_MAC_CLK_SEL(x) | BIT_MAC_CLK_SEL(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_XTAL_DRV_USB_BIT0 BIT(19)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_SHIFT_XTAL_RDRV_1_TO_0 19
#define BIT_MASK_XTAL_RDRV_1_TO_0 0x3
#define BIT_XTAL_RDRV_1_TO_0(x)                                                \
	(((x) & BIT_MASK_XTAL_RDRV_1_TO_0) << BIT_SHIFT_XTAL_RDRV_1_TO_0)
#define BITS_XTAL_RDRV_1_TO_0                                                  \
	(BIT_MASK_XTAL_RDRV_1_TO_0 << BIT_SHIFT_XTAL_RDRV_1_TO_0)
#define BIT_CLEAR_XTAL_RDRV_1_TO_0(x) ((x) & (~BITS_XTAL_RDRV_1_TO_0))
#define BIT_GET_XTAL_RDRV_1_TO_0(x)                                            \
	(((x) >> BIT_SHIFT_XTAL_RDRV_1_TO_0) & BIT_MASK_XTAL_RDRV_1_TO_0)
#define BIT_SET_XTAL_RDRV_1_TO_0(x, v)                                         \
	(BIT_CLEAR_XTAL_RDRV_1_TO_0(x) | BIT_XTAL_RDRV_1_TO_0(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_SHIFT_XTAL_DIG_DRV 18
#define BIT_MASK_XTAL_DIG_DRV 0x3
#define BIT_XTAL_DIG_DRV(x)                                                    \
	(((x) & BIT_MASK_XTAL_DIG_DRV) << BIT_SHIFT_XTAL_DIG_DRV)
#define BITS_XTAL_DIG_DRV (BIT_MASK_XTAL_DIG_DRV << BIT_SHIFT_XTAL_DIG_DRV)
#define BIT_CLEAR_XTAL_DIG_DRV(x) ((x) & (~BITS_XTAL_DIG_DRV))
#define BIT_GET_XTAL_DIG_DRV(x)                                                \
	(((x) >> BIT_SHIFT_XTAL_DIG_DRV) & BIT_MASK_XTAL_DIG_DRV)
#define BIT_SET_XTAL_DIG_DRV(x, v)                                             \
	(BIT_CLEAR_XTAL_DIG_DRV(x) | BIT_XTAL_DIG_DRV(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_XTAL_GMP_4 BIT(18)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_XTAL_GATE_DIG BIT(17)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_SHIFT_XTAL_DRV_AFE 17
#define BIT_MASK_XTAL_DRV_AFE 0x3
#define BIT_XTAL_DRV_AFE(x)                                                    \
	(((x) & BIT_MASK_XTAL_DRV_AFE) << BIT_SHIFT_XTAL_DRV_AFE)
#define BITS_XTAL_DRV_AFE (BIT_MASK_XTAL_DRV_AFE << BIT_SHIFT_XTAL_DRV_AFE)
#define BIT_CLEAR_XTAL_DRV_AFE(x) ((x) & (~BITS_XTAL_DRV_AFE))
#define BIT_GET_XTAL_DRV_AFE(x)                                                \
	(((x) >> BIT_SHIFT_XTAL_DRV_AFE) & BIT_MASK_XTAL_DRV_AFE)
#define BIT_SET_XTAL_DRV_AFE(x, v)                                             \
	(BIT_CLEAR_XTAL_DRV_AFE(x) | BIT_XTAL_DRV_AFE(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_FREE_TXPG2			(Offset 0x10250024) */

#define BIT_SHIFT_PUB_FREEPG_V1 16
#define BIT_MASK_PUB_FREEPG_V1 0xfff
#define BIT_PUB_FREEPG_V1(x)                                                   \
	(((x) & BIT_MASK_PUB_FREEPG_V1) << BIT_SHIFT_PUB_FREEPG_V1)
#define BITS_PUB_FREEPG_V1 (BIT_MASK_PUB_FREEPG_V1 << BIT_SHIFT_PUB_FREEPG_V1)
#define BIT_CLEAR_PUB_FREEPG_V1(x) ((x) & (~BITS_PUB_FREEPG_V1))
#define BIT_GET_PUB_FREEPG_V1(x)                                               \
	(((x) >> BIT_SHIFT_PUB_FREEPG_V1) & BIT_MASK_PUB_FREEPG_V1)
#define BIT_SET_PUB_FREEPG_V1(x, v)                                            \
	(BIT_CLEAR_PUB_FREEPG_V1(x) | BIT_PUB_FREEPG_V1(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_SHIFT_XTAL_ADRV_1_TO_0 16
#define BIT_MASK_XTAL_ADRV_1_TO_0 0x3
#define BIT_XTAL_ADRV_1_TO_0(x)                                                \
	(((x) & BIT_MASK_XTAL_ADRV_1_TO_0) << BIT_SHIFT_XTAL_ADRV_1_TO_0)
#define BITS_XTAL_ADRV_1_TO_0                                                  \
	(BIT_MASK_XTAL_ADRV_1_TO_0 << BIT_SHIFT_XTAL_ADRV_1_TO_0)
#define BIT_CLEAR_XTAL_ADRV_1_TO_0(x) ((x) & (~BITS_XTAL_ADRV_1_TO_0))
#define BIT_GET_XTAL_ADRV_1_TO_0(x)                                            \
	(((x) >> BIT_SHIFT_XTAL_ADRV_1_TO_0) & BIT_MASK_XTAL_ADRV_1_TO_0)
#define BIT_SET_XTAL_ADRV_1_TO_0(x, v)                                         \
	(BIT_CLEAR_XTAL_ADRV_1_TO_0(x) | BIT_XTAL_ADRV_1_TO_0(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_SHIFT_XTAL_RF_DRV 15
#define BIT_MASK_XTAL_RF_DRV 0x3
#define BIT_XTAL_RF_DRV(x)                                                     \
	(((x) & BIT_MASK_XTAL_RF_DRV) << BIT_SHIFT_XTAL_RF_DRV)
#define BITS_XTAL_RF_DRV (BIT_MASK_XTAL_RF_DRV << BIT_SHIFT_XTAL_RF_DRV)
#define BIT_CLEAR_XTAL_RF_DRV(x) ((x) & (~BITS_XTAL_RF_DRV))
#define BIT_GET_XTAL_RF_DRV(x)                                                 \
	(((x) >> BIT_SHIFT_XTAL_RF_DRV) & BIT_MASK_XTAL_RF_DRV)
#define BIT_SET_XTAL_RF_DRV(x, v)                                              \
	(BIT_CLEAR_XTAL_RF_DRV(x) | BIT_XTAL_RF_DRV(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_SHIFT_XTAL_DRV_RF2 15
#define BIT_MASK_XTAL_DRV_RF2 0x3
#define BIT_XTAL_DRV_RF2(x)                                                    \
	(((x) & BIT_MASK_XTAL_DRV_RF2) << BIT_SHIFT_XTAL_DRV_RF2)
#define BITS_XTAL_DRV_RF2 (BIT_MASK_XTAL_DRV_RF2 << BIT_SHIFT_XTAL_DRV_RF2)
#define BIT_CLEAR_XTAL_DRV_RF2(x) ((x) & (~BITS_XTAL_DRV_RF2))
#define BIT_GET_XTAL_DRV_RF2(x)                                                \
	(((x) >> BIT_SHIFT_XTAL_DRV_RF2) & BIT_MASK_XTAL_DRV_RF2)
#define BIT_SET_XTAL_DRV_RF2(x, v)                                             \
	(BIT_CLEAR_XTAL_DRV_RF2(x) | BIT_XTAL_DRV_RF2(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_XTAL_GAFE BIT(15)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_XTAL_RF_GATE BIT(14)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_SHIFT_XTAL_DDRV_1_TO_0 13
#define BIT_MASK_XTAL_DDRV_1_TO_0 0x3
#define BIT_XTAL_DDRV_1_TO_0(x)                                                \
	(((x) & BIT_MASK_XTAL_DDRV_1_TO_0) << BIT_SHIFT_XTAL_DDRV_1_TO_0)
#define BITS_XTAL_DDRV_1_TO_0                                                  \
	(BIT_MASK_XTAL_DDRV_1_TO_0 << BIT_SHIFT_XTAL_DDRV_1_TO_0)
#define BIT_CLEAR_XTAL_DDRV_1_TO_0(x) ((x) & (~BITS_XTAL_DDRV_1_TO_0))
#define BIT_GET_XTAL_DDRV_1_TO_0(x)                                            \
	(((x) >> BIT_SHIFT_XTAL_DDRV_1_TO_0) & BIT_MASK_XTAL_DDRV_1_TO_0)
#define BIT_SET_XTAL_DDRV_1_TO_0(x, v)                                         \
	(BIT_CLEAR_XTAL_DDRV_1_TO_0(x) | BIT_XTAL_DDRV_1_TO_0(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_SHIFT_XTAL_AFE_DRV 12
#define BIT_MASK_XTAL_AFE_DRV 0x3
#define BIT_XTAL_AFE_DRV(x)                                                    \
	(((x) & BIT_MASK_XTAL_AFE_DRV) << BIT_SHIFT_XTAL_AFE_DRV)
#define BITS_XTAL_AFE_DRV (BIT_MASK_XTAL_AFE_DRV << BIT_SHIFT_XTAL_AFE_DRV)
#define BIT_CLEAR_XTAL_AFE_DRV(x) ((x) & (~BITS_XTAL_AFE_DRV))
#define BIT_GET_XTAL_AFE_DRV(x)                                                \
	(((x) >> BIT_SHIFT_XTAL_AFE_DRV) & BIT_MASK_XTAL_AFE_DRV)
#define BIT_SET_XTAL_AFE_DRV(x, v)                                             \
	(BIT_CLEAR_XTAL_AFE_DRV(x) | BIT_XTAL_AFE_DRV(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_XTAL_DELAY_DIGI BIT(12)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_XTAL_GUSB BIT(12)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_XTAL_GATE_AFE BIT(11)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_XTAL_DELAY_USB BIT(11)
#define BIT_XTAL_DELAY_AFE BIT(10)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_SHIFT_XTAL_USB_DRV 9
#define BIT_MASK_XTAL_USB_DRV 0x3
#define BIT_XTAL_USB_DRV(x)                                                    \
	(((x) & BIT_MASK_XTAL_USB_DRV) << BIT_SHIFT_XTAL_USB_DRV)
#define BITS_XTAL_USB_DRV (BIT_MASK_XTAL_USB_DRV << BIT_SHIFT_XTAL_USB_DRV)
#define BIT_CLEAR_XTAL_USB_DRV(x) ((x) & (~BITS_XTAL_USB_DRV))
#define BIT_GET_XTAL_USB_DRV(x)                                                \
	(((x) >> BIT_SHIFT_XTAL_USB_DRV) & BIT_MASK_XTAL_USB_DRV)
#define BIT_SET_XTAL_USB_DRV(x, v)                                             \
	(BIT_CLEAR_XTAL_USB_DRV(x) | BIT_XTAL_USB_DRV(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_XTAL_LP_V1 BIT(9)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_XTAL_GATE_USB BIT(8)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_XTAL_GM_SEP_V1 BIT(8)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_SHIFT_XTAL_GMN_3_TO_0 8
#define BIT_MASK_XTAL_GMN_3_TO_0 0xf
#define BIT_XTAL_GMN_3_TO_0(x)                                                 \
	(((x) & BIT_MASK_XTAL_GMN_3_TO_0) << BIT_SHIFT_XTAL_GMN_3_TO_0)
#define BITS_XTAL_GMN_3_TO_0                                                   \
	(BIT_MASK_XTAL_GMN_3_TO_0 << BIT_SHIFT_XTAL_GMN_3_TO_0)
#define BIT_CLEAR_XTAL_GMN_3_TO_0(x) ((x) & (~BITS_XTAL_GMN_3_TO_0))
#define BIT_GET_XTAL_GMN_3_TO_0(x)                                             \
	(((x) >> BIT_SHIFT_XTAL_GMN_3_TO_0) & BIT_MASK_XTAL_GMN_3_TO_0)
#define BIT_SET_XTAL_GMN_3_TO_0(x, v)                                          \
	(BIT_CLEAR_XTAL_GMN_3_TO_0(x) | BIT_XTAL_GMN_3_TO_0(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_XTAL_LDO_VREF_V1 BIT(7)

#endif

#if (HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_SHIFT_XTAL_LDO_VREF 7
#define BIT_MASK_XTAL_LDO_VREF 0x7
#define BIT_XTAL_LDO_VREF(x)                                                   \
	(((x) & BIT_MASK_XTAL_LDO_VREF) << BIT_SHIFT_XTAL_LDO_VREF)
#define BITS_XTAL_LDO_VREF (BIT_MASK_XTAL_LDO_VREF << BIT_SHIFT_XTAL_LDO_VREF)
#define BIT_CLEAR_XTAL_LDO_VREF(x) ((x) & (~BITS_XTAL_LDO_VREF))
#define BIT_GET_XTAL_LDO_VREF(x)                                               \
	(((x) >> BIT_SHIFT_XTAL_LDO_VREF) & BIT_MASK_XTAL_LDO_VREF)
#define BIT_SET_XTAL_LDO_VREF(x, v)                                            \
	(BIT_CLEAR_XTAL_LDO_VREF(x) | BIT_XTAL_LDO_VREF(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_XTAL_XQSEL_RF BIT(6)
#define BIT_XTAL_XQSEL BIT(5)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_SHIFT_XTAL_GMP 4
#define BIT_MASK_XTAL_GMP 0xf
#define BIT_XTAL_GMP(x) (((x) & BIT_MASK_XTAL_GMP) << BIT_SHIFT_XTAL_GMP)
#define BITS_XTAL_GMP (BIT_MASK_XTAL_GMP << BIT_SHIFT_XTAL_GMP)
#define BIT_CLEAR_XTAL_GMP(x) ((x) & (~BITS_XTAL_GMP))
#define BIT_GET_XTAL_GMP(x) (((x) >> BIT_SHIFT_XTAL_GMP) & BIT_MASK_XTAL_GMP)
#define BIT_SET_XTAL_GMP(x, v) (BIT_CLEAR_XTAL_GMP(x) | BIT_XTAL_GMP(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_SHIFT_XTAL_GMP_3_TO_0 4
#define BIT_MASK_XTAL_GMP_3_TO_0 0xf
#define BIT_XTAL_GMP_3_TO_0(x)                                                 \
	(((x) & BIT_MASK_XTAL_GMP_3_TO_0) << BIT_SHIFT_XTAL_GMP_3_TO_0)
#define BITS_XTAL_GMP_3_TO_0                                                   \
	(BIT_MASK_XTAL_GMP_3_TO_0 << BIT_SHIFT_XTAL_GMP_3_TO_0)
#define BIT_CLEAR_XTAL_GMP_3_TO_0(x) ((x) & (~BITS_XTAL_GMP_3_TO_0))
#define BIT_GET_XTAL_GMP_3_TO_0(x)                                             \
	(((x) >> BIT_SHIFT_XTAL_GMP_3_TO_0) & BIT_MASK_XTAL_GMP_3_TO_0)
#define BIT_SET_XTAL_GMP_3_TO_0(x, v)                                          \
	(BIT_CLEAR_XTAL_GMP_3_TO_0(x) | BIT_XTAL_GMP_3_TO_0(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_SHIFT_XTAL_GMN_V2 3
#define BIT_MASK_XTAL_GMN_V2 0x3
#define BIT_XTAL_GMN_V2(x)                                                     \
	(((x) & BIT_MASK_XTAL_GMN_V2) << BIT_SHIFT_XTAL_GMN_V2)
#define BITS_XTAL_GMN_V2 (BIT_MASK_XTAL_GMN_V2 << BIT_SHIFT_XTAL_GMN_V2)
#define BIT_CLEAR_XTAL_GMN_V2(x) ((x) & (~BITS_XTAL_GMN_V2))
#define BIT_GET_XTAL_GMN_V2(x)                                                 \
	(((x) >> BIT_SHIFT_XTAL_GMN_V2) & BIT_MASK_XTAL_GMN_V2)
#define BIT_SET_XTAL_GMN_V2(x, v)                                              \
	(BIT_CLEAR_XTAL_GMN_V2(x) | BIT_XTAL_GMN_V2(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_SHIFT_XTAL_GMN_V1 3
#define BIT_MASK_XTAL_GMN_V1 0x3
#define BIT_XTAL_GMN_V1(x)                                                     \
	(((x) & BIT_MASK_XTAL_GMN_V1) << BIT_SHIFT_XTAL_GMN_V1)
#define BITS_XTAL_GMN_V1 (BIT_MASK_XTAL_GMN_V1 << BIT_SHIFT_XTAL_GMN_V1)
#define BIT_CLEAR_XTAL_GMN_V1(x) ((x) & (~BITS_XTAL_GMN_V1))
#define BIT_GET_XTAL_GMN_V1(x)                                                 \
	(((x) >> BIT_SHIFT_XTAL_GMN_V1) & BIT_MASK_XTAL_GMN_V1)
#define BIT_SET_XTAL_GMN_V1(x, v)                                              \
	(BIT_CLEAR_XTAL_GMN_V1(x) | BIT_XTAL_GMN_V1(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_SHIFT_XTAL_LDO_VCM 2
#define BIT_MASK_XTAL_LDO_VCM 0x3
#define BIT_XTAL_LDO_VCM(x)                                                    \
	(((x) & BIT_MASK_XTAL_LDO_VCM) << BIT_SHIFT_XTAL_LDO_VCM)
#define BITS_XTAL_LDO_VCM (BIT_MASK_XTAL_LDO_VCM << BIT_SHIFT_XTAL_LDO_VCM)
#define BIT_CLEAR_XTAL_LDO_VCM(x) ((x) & (~BITS_XTAL_LDO_VCM))
#define BIT_GET_XTAL_LDO_VCM(x)                                                \
	(((x) >> BIT_SHIFT_XTAL_LDO_VCM) & BIT_MASK_XTAL_LDO_VCM)
#define BIT_SET_XTAL_LDO_VCM(x, v)                                             \
	(BIT_CLEAR_XTAL_LDO_VCM(x) | BIT_XTAL_LDO_VCM(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_SHIFT_DRV_LDO_VCM_1_TO_0 2
#define BIT_MASK_DRV_LDO_VCM_1_TO_0 0x3
#define BIT_DRV_LDO_VCM_1_TO_0(x)                                              \
	(((x) & BIT_MASK_DRV_LDO_VCM_1_TO_0) << BIT_SHIFT_DRV_LDO_VCM_1_TO_0)
#define BITS_DRV_LDO_VCM_1_TO_0                                                \
	(BIT_MASK_DRV_LDO_VCM_1_TO_0 << BIT_SHIFT_DRV_LDO_VCM_1_TO_0)
#define BIT_CLEAR_DRV_LDO_VCM_1_TO_0(x) ((x) & (~BITS_DRV_LDO_VCM_1_TO_0))
#define BIT_GET_DRV_LDO_VCM_1_TO_0(x)                                          \
	(((x) >> BIT_SHIFT_DRV_LDO_VCM_1_TO_0) & BIT_MASK_DRV_LDO_VCM_1_TO_0)
#define BIT_SET_DRV_LDO_VCM_1_TO_0(x, v)                                       \
	(BIT_CLEAR_DRV_LDO_VCM_1_TO_0(x) | BIT_DRV_LDO_VCM_1_TO_0(v))

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_XTAL_DUMMY BIT(1)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_SHIFT_XTAL_GMP_V2 1
#define BIT_MASK_XTAL_GMP_V2 0x3
#define BIT_XTAL_GMP_V2(x)                                                     \
	(((x) & BIT_MASK_XTAL_GMP_V2) << BIT_SHIFT_XTAL_GMP_V2)
#define BITS_XTAL_GMP_V2 (BIT_MASK_XTAL_GMP_V2 << BIT_SHIFT_XTAL_GMP_V2)
#define BIT_CLEAR_XTAL_GMP_V2(x) ((x) & (~BITS_XTAL_GMP_V2))
#define BIT_GET_XTAL_GMP_V2(x)                                                 \
	(((x) >> BIT_SHIFT_XTAL_GMP_V2) & BIT_MASK_XTAL_GMP_V2)
#define BIT_SET_XTAL_GMP_V2(x, v)                                              \
	(BIT_CLEAR_XTAL_GMP_V2(x) | BIT_XTAL_GMP_V2(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_SHIFT_XTAL_GMP_V1 1
#define BIT_MASK_XTAL_GMP_V1 0x3
#define BIT_XTAL_GMP_V1(x)                                                     \
	(((x) & BIT_MASK_XTAL_GMP_V1) << BIT_SHIFT_XTAL_GMP_V1)
#define BITS_XTAL_GMP_V1 (BIT_MASK_XTAL_GMP_V1 << BIT_SHIFT_XTAL_GMP_V1)
#define BIT_CLEAR_XTAL_GMP_V1(x) ((x) & (~BITS_XTAL_GMP_V1))
#define BIT_GET_XTAL_GMP_V1(x)                                                 \
	(((x) >> BIT_SHIFT_XTAL_GMP_V1) & BIT_MASK_XTAL_GMP_V1)
#define BIT_SET_XTAL_GMP_V1(x, v)                                              \
	(BIT_CLEAR_XTAL_GMP_V1(x) | BIT_XTAL_GMP_V1(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_XQSEL_RF_INITIAL_V1 BIT(1)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || \
     HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL1				(Offset 0x0024) */

#define BIT_XTAL_EN BIT(0)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_FREE_TXPG2			(Offset 0x10250024) */

#define BIT_SHIFT_LOW_FREEPG_V1 0
#define BIT_MASK_LOW_FREEPG_V1 0xfff
#define BIT_LOW_FREEPG_V1(x)                                                   \
	(((x) & BIT_MASK_LOW_FREEPG_V1) << BIT_SHIFT_LOW_FREEPG_V1)
#define BITS_LOW_FREEPG_V1 (BIT_MASK_LOW_FREEPG_V1 << BIT_SHIFT_LOW_FREEPG_V1)
#define BIT_CLEAR_LOW_FREEPG_V1(x) ((x) & (~BITS_LOW_FREEPG_V1))
#define BIT_GET_LOW_FREEPG_V1(x)                                               \
	(((x) >> BIT_SHIFT_LOW_FREEPG_V1) & BIT_MASK_LOW_FREEPG_V1)
#define BIT_SET_LOW_FREEPG_V1(x, v)                                            \
	(BIT_CLEAR_LOW_FREEPG_V1(x) | BIT_LOW_FREEPG_V1(v))

#endif

#if (HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_SHIFT_REG_C3_V4 30
#define BIT_MASK_REG_C3_V4 0x3
#define BIT_REG_C3_V4(x) (((x) & BIT_MASK_REG_C3_V4) << BIT_SHIFT_REG_C3_V4)
#define BITS_REG_C3_V4 (BIT_MASK_REG_C3_V4 << BIT_SHIFT_REG_C3_V4)
#define BIT_CLEAR_REG_C3_V4(x) ((x) & (~BITS_REG_C3_V4))
#define BIT_GET_REG_C3_V4(x) (((x) >> BIT_SHIFT_REG_C3_V4) & BIT_MASK_REG_C3_V4)
#define BIT_SET_REG_C3_V4(x, v) (BIT_CLEAR_REG_C3_V4(x) | BIT_REG_C3_V4(v))

#define BIT_REG_CP_BIT1 BIT(29)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_SHIFT_XTAL_GMN 28
#define BIT_MASK_XTAL_GMN 0xf
#define BIT_XTAL_GMN(x) (((x) & BIT_MASK_XTAL_GMN) << BIT_SHIFT_XTAL_GMN)
#define BITS_XTAL_GMN (BIT_MASK_XTAL_GMN << BIT_SHIFT_XTAL_GMN)
#define BIT_CLEAR_XTAL_GMN(x) ((x) & (~BITS_XTAL_GMN))
#define BIT_GET_XTAL_GMN(x) (((x) >> BIT_SHIFT_XTAL_GMN) & BIT_MASK_XTAL_GMN)
#define BIT_SET_XTAL_GMN(x, v) (BIT_CLEAR_XTAL_GMN(x) | BIT_XTAL_GMN(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_SHIFT_IOOFFSET_3_TO_0 28
#define BIT_MASK_IOOFFSET_3_TO_0 0xf
#define BIT_IOOFFSET_3_TO_0(x)                                                 \
	(((x) & BIT_MASK_IOOFFSET_3_TO_0) << BIT_SHIFT_IOOFFSET_3_TO_0)
#define BITS_IOOFFSET_3_TO_0                                                   \
	(BIT_MASK_IOOFFSET_3_TO_0 << BIT_SHIFT_IOOFFSET_3_TO_0)
#define BIT_CLEAR_IOOFFSET_3_TO_0(x) ((x) & (~BITS_IOOFFSET_3_TO_0))
#define BIT_GET_IOOFFSET_3_TO_0(x)                                             \
	(((x) >> BIT_SHIFT_IOOFFSET_3_TO_0) & BIT_MASK_IOOFFSET_3_TO_0)
#define BIT_SET_IOOFFSET_3_TO_0(x, v)                                          \
	(BIT_CLEAR_IOOFFSET_3_TO_0(x) | BIT_IOOFFSET_3_TO_0(v))

#define BIT_REG_FREF_SEL_BIT3_V1 BIT(27)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_SHIFT_REG_VO_AD 26
#define BIT_MASK_REG_VO_AD 0x3
#define BIT_REG_VO_AD(x) (((x) & BIT_MASK_REG_VO_AD) << BIT_SHIFT_REG_VO_AD)
#define BITS_REG_VO_AD (BIT_MASK_REG_VO_AD << BIT_SHIFT_REG_VO_AD)
#define BIT_CLEAR_REG_VO_AD(x) ((x) & (~BITS_REG_VO_AD))
#define BIT_GET_REG_VO_AD(x) (((x) >> BIT_SHIFT_REG_VO_AD) & BIT_MASK_REG_VO_AD)
#define BIT_SET_REG_VO_AD(x, v) (BIT_CLEAR_REG_VO_AD(x) | BIT_REG_VO_AD(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_SHIFT_RS_SET 26
#define BIT_MASK_RS_SET 0x7
#define BIT_RS_SET(x) (((x) & BIT_MASK_RS_SET) << BIT_SHIFT_RS_SET)
#define BITS_RS_SET (BIT_MASK_RS_SET << BIT_SHIFT_RS_SET)
#define BIT_CLEAR_RS_SET(x) ((x) & (~BITS_RS_SET))
#define BIT_GET_RS_SET(x) (((x) >> BIT_SHIFT_RS_SET) & BIT_MASK_RS_SET)
#define BIT_SET_RS_SET(x, v) (BIT_CLEAR_RS_SET(x) | BIT_RS_SET(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_SHIFT_RS_SET_V2 26
#define BIT_MASK_RS_SET_V2 0x7
#define BIT_RS_SET_V2(x) (((x) & BIT_MASK_RS_SET_V2) << BIT_SHIFT_RS_SET_V2)
#define BITS_RS_SET_V2 (BIT_MASK_RS_SET_V2 << BIT_SHIFT_RS_SET_V2)
#define BIT_CLEAR_RS_SET_V2(x) ((x) & (~BITS_RS_SET_V2))
#define BIT_GET_RS_SET_V2(x) (((x) >> BIT_SHIFT_RS_SET_V2) & BIT_MASK_RS_SET_V2)
#define BIT_SET_RS_SET_V2(x, v) (BIT_CLEAR_RS_SET_V2(x) | BIT_RS_SET_V2(v))

#endif

#if (HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_SHIFT_REG_RS_V4 26
#define BIT_MASK_REG_RS_V4 0x7
#define BIT_REG_RS_V4(x) (((x) & BIT_MASK_REG_RS_V4) << BIT_SHIFT_REG_RS_V4)
#define BITS_REG_RS_V4 (BIT_MASK_REG_RS_V4 << BIT_SHIFT_REG_RS_V4)
#define BIT_CLEAR_REG_RS_V4(x) ((x) & (~BITS_REG_RS_V4))
#define BIT_GET_REG_RS_V4(x) (((x) >> BIT_SHIFT_REG_RS_V4) & BIT_MASK_REG_RS_V4)
#define BIT_SET_REG_RS_V4(x, v) (BIT_CLEAR_REG_RS_V4(x) | BIT_REG_RS_V4(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_SHIFT_V12ADJ_V1 25
#define BIT_MASK_V12ADJ_V1 0x3
#define BIT_V12ADJ_V1(x) (((x) & BIT_MASK_V12ADJ_V1) << BIT_SHIFT_V12ADJ_V1)
#define BITS_V12ADJ_V1 (BIT_MASK_V12ADJ_V1 << BIT_SHIFT_V12ADJ_V1)
#define BIT_CLEAR_V12ADJ_V1(x) ((x) & (~BITS_V12ADJ_V1))
#define BIT_GET_V12ADJ_V1(x) (((x) >> BIT_SHIFT_V12ADJ_V1) & BIT_MASK_V12ADJ_V1)
#define BIT_SET_V12ADJ_V1(x, v) (BIT_CLEAR_V12ADJ_V1(x) | BIT_V12ADJ_V1(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_OQT_FREE_TXPG_V1		(Offset 0x10250028) */

#define BIT_SHIFT_NOAC_OQT_FREEPG_V1 24
#define BIT_MASK_NOAC_OQT_FREEPG_V1 0xff
#define BIT_NOAC_OQT_FREEPG_V1(x)                                              \
	(((x) & BIT_MASK_NOAC_OQT_FREEPG_V1) << BIT_SHIFT_NOAC_OQT_FREEPG_V1)
#define BITS_NOAC_OQT_FREEPG_V1                                                \
	(BIT_MASK_NOAC_OQT_FREEPG_V1 << BIT_SHIFT_NOAC_OQT_FREEPG_V1)
#define BIT_CLEAR_NOAC_OQT_FREEPG_V1(x) ((x) & (~BITS_NOAC_OQT_FREEPG_V1))
#define BIT_GET_NOAC_OQT_FREEPG_V1(x)                                          \
	(((x) >> BIT_SHIFT_NOAC_OQT_FREEPG_V1) & BIT_MASK_NOAC_OQT_FREEPG_V1)
#define BIT_SET_NOAC_OQT_FREEPG_V1(x, v)                                       \
	(BIT_CLEAR_NOAC_OQT_FREEPG_V1(x) | BIT_NOAC_OQT_FREEPG_V1(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_PS_EN BIT(24)

#endif

#if (HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_SHIFT_REG__CS 24
#define BIT_MASK_REG__CS 0x3
#define BIT_REG__CS(x) (((x) & BIT_MASK_REG__CS) << BIT_SHIFT_REG__CS)
#define BITS_REG__CS (BIT_MASK_REG__CS << BIT_SHIFT_REG__CS)
#define BIT_CLEAR_REG__CS(x) ((x) & (~BITS_REG__CS))
#define BIT_GET_REG__CS(x) (((x) >> BIT_SHIFT_REG__CS) & BIT_MASK_REG__CS)
#define BIT_SET_REG__CS(x, v) (BIT_CLEAR_REG__CS(x) | BIT_REG__CS(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_EN_CK320M_V1 BIT(23)
#define BIT_AGPIO BIT(22)
#define BIT_REG_EDGE_SEL_V1 BIT(21)

#endif

#if (HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_SHIFT_REG_CP_OFFSET 21
#define BIT_MASK_REG_CP_OFFSET 0x7
#define BIT_REG_CP_OFFSET(x)                                                   \
	(((x) & BIT_MASK_REG_CP_OFFSET) << BIT_SHIFT_REG_CP_OFFSET)
#define BITS_REG_CP_OFFSET (BIT_MASK_REG_CP_OFFSET << BIT_SHIFT_REG_CP_OFFSET)
#define BIT_CLEAR_REG_CP_OFFSET(x) ((x) & (~BITS_REG_CP_OFFSET))
#define BIT_GET_REG_CP_OFFSET(x)                                               \
	(((x) >> BIT_SHIFT_REG_CP_OFFSET) & BIT_MASK_REG_CP_OFFSET)
#define BIT_SET_REG_CP_OFFSET(x, v)                                            \
	(BIT_CLEAR_REG_CP_OFFSET(x) | BIT_REG_CP_OFFSET(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_REG_VCO_BIAS_0 BIT(20)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_SHIFT_CP_BIAS 18
#define BIT_MASK_CP_BIAS 0x7
#define BIT_CP_BIAS(x) (((x) & BIT_MASK_CP_BIAS) << BIT_SHIFT_CP_BIAS)
#define BITS_CP_BIAS (BIT_MASK_CP_BIAS << BIT_SHIFT_CP_BIAS)
#define BIT_CLEAR_CP_BIAS(x) ((x) & (~BITS_CP_BIAS))
#define BIT_GET_CP_BIAS(x) (((x) >> BIT_SHIFT_CP_BIAS) & BIT_MASK_CP_BIAS)
#define BIT_SET_CP_BIAS(x, v) (BIT_CLEAR_CP_BIAS(x) | BIT_CP_BIAS(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_SHIFT_CP_BIAS_V2 18
#define BIT_MASK_CP_BIAS_V2 0x7
#define BIT_CP_BIAS_V2(x) (((x) & BIT_MASK_CP_BIAS_V2) << BIT_SHIFT_CP_BIAS_V2)
#define BITS_CP_BIAS_V2 (BIT_MASK_CP_BIAS_V2 << BIT_SHIFT_CP_BIAS_V2)
#define BIT_CLEAR_CP_BIAS_V2(x) ((x) & (~BITS_CP_BIAS_V2))
#define BIT_GET_CP_BIAS_V2(x)                                                  \
	(((x) >> BIT_SHIFT_CP_BIAS_V2) & BIT_MASK_CP_BIAS_V2)
#define BIT_SET_CP_BIAS_V2(x, v) (BIT_CLEAR_CP_BIAS_V2(x) | BIT_CP_BIAS_V2(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_SHIFT_REG_PLLBIAS_2_TO_0_V1 17
#define BIT_MASK_REG_PLLBIAS_2_TO_0_V1 0x7
#define BIT_REG_PLLBIAS_2_TO_0_V1(x)                                           \
	(((x) & BIT_MASK_REG_PLLBIAS_2_TO_0_V1)                                \
	 << BIT_SHIFT_REG_PLLBIAS_2_TO_0_V1)
#define BITS_REG_PLLBIAS_2_TO_0_V1                                             \
	(BIT_MASK_REG_PLLBIAS_2_TO_0_V1 << BIT_SHIFT_REG_PLLBIAS_2_TO_0_V1)
#define BIT_CLEAR_REG_PLLBIAS_2_TO_0_V1(x) ((x) & (~BITS_REG_PLLBIAS_2_TO_0_V1))
#define BIT_GET_REG_PLLBIAS_2_TO_0_V1(x)                                       \
	(((x) >> BIT_SHIFT_REG_PLLBIAS_2_TO_0_V1) &                            \
	 BIT_MASK_REG_PLLBIAS_2_TO_0_V1)
#define BIT_SET_REG_PLLBIAS_2_TO_0_V1(x, v)                                    \
	(BIT_CLEAR_REG_PLLBIAS_2_TO_0_V1(x) | BIT_REG_PLLBIAS_2_TO_0_V1(v))

#endif

#if (HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_REG_IDOUBLE_V2 BIT(17)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_FREF_SEL BIT(16)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_OQT_FREE_TXPG_V1		(Offset 0x10250028) */

#define BIT_SHIFT_AC_OQT_FREEPG_V1 16
#define BIT_MASK_AC_OQT_FREEPG_V1 0xff
#define BIT_AC_OQT_FREEPG_V1(x)                                                \
	(((x) & BIT_MASK_AC_OQT_FREEPG_V1) << BIT_SHIFT_AC_OQT_FREEPG_V1)
#define BITS_AC_OQT_FREEPG_V1                                                  \
	(BIT_MASK_AC_OQT_FREEPG_V1 << BIT_SHIFT_AC_OQT_FREEPG_V1)
#define BIT_CLEAR_AC_OQT_FREEPG_V1(x) ((x) & (~BITS_AC_OQT_FREEPG_V1))
#define BIT_GET_AC_OQT_FREEPG_V1(x)                                            \
	(((x) >> BIT_SHIFT_AC_OQT_FREEPG_V1) & BIT_MASK_AC_OQT_FREEPG_V1)
#define BIT_SET_AC_OQT_FREEPG_V1(x, v)                                         \
	(BIT_CLEAR_AC_OQT_FREEPG_V1(x) | BIT_AC_OQT_FREEPG_V1(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_REG_IDOUBLE_V1 BIT(16)

#define BIT_SHIFT_AC_OQT__FREEPG_V1 16
#define BIT_MASK_AC_OQT__FREEPG_V1 0xff
#define BIT_AC_OQT__FREEPG_V1(x)                                               \
	(((x) & BIT_MASK_AC_OQT__FREEPG_V1) << BIT_SHIFT_AC_OQT__FREEPG_V1)
#define BITS_AC_OQT__FREEPG_V1                                                 \
	(BIT_MASK_AC_OQT__FREEPG_V1 << BIT_SHIFT_AC_OQT__FREEPG_V1)
#define BIT_CLEAR_AC_OQT__FREEPG_V1(x) ((x) & (~BITS_AC_OQT__FREEPG_V1))
#define BIT_GET_AC_OQT__FREEPG_V1(x)                                           \
	(((x) >> BIT_SHIFT_AC_OQT__FREEPG_V1) & BIT_MASK_AC_OQT__FREEPG_V1)
#define BIT_SET_AC_OQT__FREEPG_V1(x, v)                                        \
	(BIT_CLEAR_AC_OQT__FREEPG_V1(x) | BIT_AC_OQT__FREEPG_V1(v))

#endif

#if (HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_EN_SYN BIT(16)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_REG_KVCO_V1 BIT(15)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_APLL_320_GATEB BIT(14)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_SHIFT_MCCO 14
#define BIT_MASK_MCCO 0x3
#define BIT_MCCO(x) (((x) & BIT_MASK_MCCO) << BIT_SHIFT_MCCO)
#define BITS_MCCO (BIT_MASK_MCCO << BIT_SHIFT_MCCO)
#define BIT_CLEAR_MCCO(x) ((x) & (~BITS_MCCO))
#define BIT_GET_MCCO(x) (((x) >> BIT_SHIFT_MCCO) & BIT_MASK_MCCO)
#define BIT_SET_MCCO(x, v) (BIT_CLEAR_MCCO(x) | BIT_MCCO(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_SHIFT_MCCO_V2 14
#define BIT_MASK_MCCO_V2 0x3
#define BIT_MCCO_V2(x) (((x) & BIT_MASK_MCCO_V2) << BIT_SHIFT_MCCO_V2)
#define BITS_MCCO_V2 (BIT_MASK_MCCO_V2 << BIT_SHIFT_MCCO_V2)
#define BIT_CLEAR_MCCO_V2(x) ((x) & (~BITS_MCCO_V2))
#define BIT_GET_MCCO_V2(x) (((x) >> BIT_SHIFT_MCCO_V2) & BIT_MASK_MCCO_V2)
#define BIT_SET_MCCO_V2(x, v) (BIT_CLEAR_MCCO_V2(x) | BIT_MCCO_V2(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_REG_VCO_BIAS_1_V1 BIT(14)
#define BIT_REG_DOGB_V1 BIT(13)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_SHIFT_CK320_EN 12
#define BIT_MASK_CK320_EN 0x3
#define BIT_CK320_EN(x) (((x) & BIT_MASK_CK320_EN) << BIT_SHIFT_CK320_EN)
#define BITS_CK320_EN (BIT_MASK_CK320_EN << BIT_SHIFT_CK320_EN)
#define BIT_CLEAR_CK320_EN(x) ((x) & (~BITS_CK320_EN))
#define BIT_GET_CK320_EN(x) (((x) >> BIT_SHIFT_CK320_EN) & BIT_MASK_CK320_EN)
#define BIT_SET_CK320_EN(x, v) (BIT_CLEAR_CK320_EN(x) | BIT_CK320_EN(v))

#endif

#if (HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_SHIFT_REG_LDO_SEL 12
#define BIT_MASK_REG_LDO_SEL 0x3
#define BIT_REG_LDO_SEL(x)                                                     \
	(((x) & BIT_MASK_REG_LDO_SEL) << BIT_SHIFT_REG_LDO_SEL)
#define BITS_REG_LDO_SEL (BIT_MASK_REG_LDO_SEL << BIT_SHIFT_REG_LDO_SEL)
#define BIT_CLEAR_REG_LDO_SEL(x) ((x) & (~BITS_REG_LDO_SEL))
#define BIT_GET_REG_LDO_SEL(x)                                                 \
	(((x) >> BIT_SHIFT_REG_LDO_SEL) & BIT_MASK_REG_LDO_SEL)
#define BIT_SET_REG_LDO_SEL(x, v)                                              \
	(BIT_CLEAR_REG_LDO_SEL(x) | BIT_REG_LDO_SEL(v))

#define BIT_REG_KVCO_V2 BIT(10)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_AGPIO_GPO BIT(9)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_SHIFT_APLL_BIAS 8
#define BIT_MASK_APLL_BIAS 0x7
#define BIT_APLL_BIAS(x) (((x) & BIT_MASK_APLL_BIAS) << BIT_SHIFT_APLL_BIAS)
#define BITS_APLL_BIAS (BIT_MASK_APLL_BIAS << BIT_SHIFT_APLL_BIAS)
#define BIT_CLEAR_APLL_BIAS(x) ((x) & (~BITS_APLL_BIAS))
#define BIT_GET_APLL_BIAS(x) (((x) >> BIT_SHIFT_APLL_BIAS) & BIT_MASK_APLL_BIAS)
#define BIT_SET_APLL_BIAS(x, v) (BIT_CLEAR_APLL_BIAS(x) | BIT_APLL_BIAS(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_SHIFT_AGPIO_DRV 7
#define BIT_MASK_AGPIO_DRV 0x3
#define BIT_AGPIO_DRV(x) (((x) & BIT_MASK_AGPIO_DRV) << BIT_SHIFT_AGPIO_DRV)
#define BITS_AGPIO_DRV (BIT_MASK_AGPIO_DRV << BIT_SHIFT_AGPIO_DRV)
#define BIT_CLEAR_AGPIO_DRV(x) ((x) & (~BITS_AGPIO_DRV))
#define BIT_GET_AGPIO_DRV(x) (((x) >> BIT_SHIFT_AGPIO_DRV) & BIT_MASK_AGPIO_DRV)
#define BIT_SET_AGPIO_DRV(x, v) (BIT_CLEAR_AGPIO_DRV(x) | BIT_AGPIO_DRV(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_SHIFT_REG_V15_3_TO_0_V1 7
#define BIT_MASK_REG_V15_3_TO_0_V1 0xf
#define BIT_REG_V15_3_TO_0_V1(x)                                               \
	(((x) & BIT_MASK_REG_V15_3_TO_0_V1) << BIT_SHIFT_REG_V15_3_TO_0_V1)
#define BITS_REG_V15_3_TO_0_V1                                                 \
	(BIT_MASK_REG_V15_3_TO_0_V1 << BIT_SHIFT_REG_V15_3_TO_0_V1)
#define BIT_CLEAR_REG_V15_3_TO_0_V1(x) ((x) & (~BITS_REG_V15_3_TO_0_V1))
#define BIT_GET_REG_V15_3_TO_0_V1(x)                                           \
	(((x) >> BIT_SHIFT_REG_V15_3_TO_0_V1) & BIT_MASK_REG_V15_3_TO_0_V1)
#define BIT_SET_REG_V15_3_TO_0_V1(x, v)                                        \
	(BIT_CLEAR_REG_V15_3_TO_0_V1(x) | BIT_REG_V15_3_TO_0_V1(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_APLL_KVCO BIT(6)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_REG_SEL_LDO_PC BIT(6)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_APLL_WDOGB BIT(4)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_SHIFT_REG_CC_1_TO_0_V1 4
#define BIT_MASK_REG_CC_1_TO_0_V1 0x3
#define BIT_REG_CC_1_TO_0_V1(x)                                                \
	(((x) & BIT_MASK_REG_CC_1_TO_0_V1) << BIT_SHIFT_REG_CC_1_TO_0_V1)
#define BITS_REG_CC_1_TO_0_V1                                                  \
	(BIT_MASK_REG_CC_1_TO_0_V1 << BIT_SHIFT_REG_CC_1_TO_0_V1)
#define BIT_CLEAR_REG_CC_1_TO_0_V1(x) ((x) & (~BITS_REG_CC_1_TO_0_V1))
#define BIT_GET_REG_CC_1_TO_0_V1(x)                                            \
	(((x) >> BIT_SHIFT_REG_CC_1_TO_0_V1) & BIT_MASK_REG_CC_1_TO_0_V1)
#define BIT_SET_REG_CC_1_TO_0_V1(x, v)                                         \
	(BIT_CLEAR_REG_CC_1_TO_0_V1(x) | BIT_REG_CC_1_TO_0_V1(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_APLL_EDGE_SEL BIT(3)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_CKDELAY_USB_V1 BIT(3)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_APLL_FREF_SEL_BIT0 BIT(2)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_ANAPARSW_POW_MAC			(Offset 0x0028) */

#define BIT_POW_LDO15 BIT(2)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_CKDELAY_DIG_V1 BIT(2)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_SHIFT_XTAL_CAP_XO 1
#define BIT_MASK_XTAL_CAP_XO 0x3f
#define BIT_XTAL_CAP_XO(x)                                                     \
	(((x) & BIT_MASK_XTAL_CAP_XO) << BIT_SHIFT_XTAL_CAP_XO)
#define BITS_XTAL_CAP_XO (BIT_MASK_XTAL_CAP_XO << BIT_SHIFT_XTAL_CAP_XO)
#define BIT_CLEAR_XTAL_CAP_XO(x) ((x) & (~BITS_XTAL_CAP_XO))
#define BIT_GET_XTAL_CAP_XO(x)                                                 \
	(((x) >> BIT_SHIFT_XTAL_CAP_XO) & BIT_MASK_XTAL_CAP_XO)
#define BIT_SET_XTAL_CAP_XO(x, v)                                              \
	(BIT_CLEAR_XTAL_CAP_XO(x) | BIT_XTAL_CAP_XO(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_ANAPARSW_POW_MAC			(Offset 0x0028) */

#define BIT_POW_SW BIT(1)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_MPLL_EN BIT(1)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_APLL_EN BIT(0)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL2				(Offset 0x0028) */

#define BIT_POW_PLL BIT(0)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_OQT_FREE_TXPG_V1		(Offset 0x10250028) */

#define BIT_SHIFT_EXQ_FREEPG_V1 0
#define BIT_MASK_EXQ_FREEPG_V1 0xfff
#define BIT_EXQ_FREEPG_V1(x)                                                   \
	(((x) & BIT_MASK_EXQ_FREEPG_V1) << BIT_SHIFT_EXQ_FREEPG_V1)
#define BITS_EXQ_FREEPG_V1 (BIT_MASK_EXQ_FREEPG_V1 << BIT_SHIFT_EXQ_FREEPG_V1)
#define BIT_CLEAR_EXQ_FREEPG_V1(x) ((x) & (~BITS_EXQ_FREEPG_V1))
#define BIT_GET_EXQ_FREEPG_V1(x)                                               \
	(((x) >> BIT_SHIFT_EXQ_FREEPG_V1) & BIT_MASK_EXQ_FREEPG_V1)
#define BIT_SET_EXQ_FREEPG_V1(x, v)                                            \
	(BIT_CLEAR_EXQ_FREEPG_V1(x) | BIT_EXQ_FREEPG_V1(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_ANAPARSW_POW_MAC			(Offset 0x0028) */

#define BIT_POW_LDO14 BIT(0)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SDIO_OQT_FREE_TXPG_V1		(Offset 0x10250028) */

#define BIT_SHIFT_EXQ__FREEPG_V1 0
#define BIT_MASK_EXQ__FREEPG_V1 0xfff
#define BIT_EXQ__FREEPG_V1(x)                                                  \
	(((x) & BIT_MASK_EXQ__FREEPG_V1) << BIT_SHIFT_EXQ__FREEPG_V1)
#define BITS_EXQ__FREEPG_V1                                                    \
	(BIT_MASK_EXQ__FREEPG_V1 << BIT_SHIFT_EXQ__FREEPG_V1)
#define BIT_CLEAR_EXQ__FREEPG_V1(x) ((x) & (~BITS_EXQ__FREEPG_V1))
#define BIT_GET_EXQ__FREEPG_V1(x)                                              \
	(((x) >> BIT_SHIFT_EXQ__FREEPG_V1) & BIT_MASK_EXQ__FREEPG_V1)
#define BIT_SET_EXQ__FREEPG_V1(x, v)                                           \
	(BIT_CLEAR_EXQ__FREEPG_V1(x) | BIT_EXQ__FREEPG_V1(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_ANAPARLDO_POW_MAC			(Offset 0x0029) */

#define BIT_LDOE25_POW_L BIT(0)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_ANAPAR_POW_MAC			(Offset 0x002A) */

#define BIT_REG_STANDBY_L BIT(19)
#define BIT_PD_REGU_L BIT(18)
#define BIT_EN_PC_BT_L BIT(17)

#define BIT_SHIFT_REG_LDOADJ_L 13
#define BIT_MASK_REG_LDOADJ_L 0xf
#define BIT_REG_LDOADJ_L(x)                                                    \
	(((x) & BIT_MASK_REG_LDOADJ_L) << BIT_SHIFT_REG_LDOADJ_L)
#define BITS_REG_LDOADJ_L (BIT_MASK_REG_LDOADJ_L << BIT_SHIFT_REG_LDOADJ_L)
#define BIT_CLEAR_REG_LDOADJ_L(x) ((x) & (~BITS_REG_LDOADJ_L))
#define BIT_GET_REG_LDOADJ_L(x)                                                \
	(((x) >> BIT_SHIFT_REG_LDOADJ_L) & BIT_MASK_REG_LDOADJ_L)
#define BIT_SET_REG_LDOADJ_L(x, v)                                             \
	(BIT_CLEAR_REG_LDOADJ_L(x) | BIT_REG_LDOADJ_L(v))

#define BIT_CK12M_EN BIT(11)
#define BIT_CK12M_SEL BIT(10)
#define BIT_EN_25_L BIT(9)
#define BIT_EN_SLEEP BIT(8)
#define BIT_DUMMY_V4 BIT(7)
#define BIT_DUMMY_V3 BIT(6)
#define BIT_DUMMY_V2 BIT(5)
#define BIT_DUMMY_V1 BIT(4)

#define BIT_SHIFT_LDOH12_V12ADJ_L 4
#define BIT_MASK_LDOH12_V12ADJ_L 0xf
#define BIT_LDOH12_V12ADJ_L(x)                                                 \
	(((x) & BIT_MASK_LDOH12_V12ADJ_L) << BIT_SHIFT_LDOH12_V12ADJ_L)
#define BITS_LDOH12_V12ADJ_L                                                   \
	(BIT_MASK_LDOH12_V12ADJ_L << BIT_SHIFT_LDOH12_V12ADJ_L)
#define BIT_CLEAR_LDOH12_V12ADJ_L(x) ((x) & (~BITS_LDOH12_V12ADJ_L))
#define BIT_GET_LDOH12_V12ADJ_L(x)                                             \
	(((x) >> BIT_SHIFT_LDOH12_V12ADJ_L) & BIT_MASK_LDOH12_V12ADJ_L)
#define BIT_SET_LDOH12_V12ADJ_L(x, v)                                          \
	(BIT_CLEAR_LDOH12_V12ADJ_L(x) | BIT_LDOH12_V12ADJ_L(v))

#define BIT_POW_PC_LDO_PORT1 BIT(3)
#define BIT_POW_PC_LDO_PORT0 BIT(2)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_ANAPAR_POW_MAC			(Offset 0x002A) */

#define BIT_POW_PLL_V1 BIT(1)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_ANAPAR_POW_MAC			(Offset 0x002A) */

#define BIT_POW_POWER_CUT_POW_LDO BIT(0)

#define BIT_SHIFT_LDOE25_V12ADJ_L_V1 0
#define BIT_MASK_LDOE25_V12ADJ_L_V1 0xf
#define BIT_LDOE25_V12ADJ_L_V1(x)                                              \
	(((x) & BIT_MASK_LDOE25_V12ADJ_L_V1) << BIT_SHIFT_LDOE25_V12ADJ_L_V1)
#define BITS_LDOE25_V12ADJ_L_V1                                                \
	(BIT_MASK_LDOE25_V12ADJ_L_V1 << BIT_SHIFT_LDOE25_V12ADJ_L_V1)
#define BIT_CLEAR_LDOE25_V12ADJ_L_V1(x) ((x) & (~BITS_LDOE25_V12ADJ_L_V1))
#define BIT_GET_LDOE25_V12ADJ_L_V1(x)                                          \
	(((x) >> BIT_SHIFT_LDOE25_V12ADJ_L_V1) & BIT_MASK_LDOE25_V12ADJ_L_V1)
#define BIT_SET_LDOE25_V12ADJ_L_V1(x, v)                                       \
	(BIT_CLEAR_LDOE25_V12ADJ_L_V1(x) | BIT_LDOE25_V12ADJ_L_V1(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_ANAPAR_POW_XTAL			(Offset 0x002B) */

#define BIT_PSTIMER_2 BIT(31)
#define BIT_PSTIMER_1 BIT(30)
#define BIT_PSTIMER_0 BIT(29)
#define BIT_TXDMA_START_INT BIT(23)
#define BIT_TXDMA_STOP_INT BIT(22)
#define BIT_HISR7_IND BIT(21)
#define BIT_HISR6_IND BIT(19)
#define BIT_HISR5_IND BIT(18)
#define BIT_HISR4_IND BIT(17)
#define BIT_HISR3_IND BIT(14)
#define BIT_HISR2_IND BIT(13)
#define BIT_POW_XTAL BIT(1)
#define BIT_POW_BG BIT(0)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL3				(Offset 0x002C) */

#define BIT_SHIFT_XTAL_RF2_DRV 30
#define BIT_MASK_XTAL_RF2_DRV 0x3
#define BIT_XTAL_RF2_DRV(x)                                                    \
	(((x) & BIT_MASK_XTAL_RF2_DRV) << BIT_SHIFT_XTAL_RF2_DRV)
#define BITS_XTAL_RF2_DRV (BIT_MASK_XTAL_RF2_DRV << BIT_SHIFT_XTAL_RF2_DRV)
#define BIT_CLEAR_XTAL_RF2_DRV(x) ((x) & (~BITS_XTAL_RF2_DRV))
#define BIT_GET_XTAL_RF2_DRV(x)                                                \
	(((x) >> BIT_SHIFT_XTAL_RF2_DRV) & BIT_MASK_XTAL_RF2_DRV)
#define BIT_SET_XTAL_RF2_DRV(x, v)                                             \
	(BIT_CLEAR_XTAL_RF2_DRV(x) | BIT_XTAL_RF2_DRV(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_CTRL3				(Offset 0x002C) */

#define BIT_REG_REF_SEL_V3 BIT(30)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL3				(Offset 0x002C) */

#define BIT_XTAL_GMN_BIT4 BIT(29)
#define BIT_XTAL_GMP_BIT4 BIT(28)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_AFE_CTRL3				(Offset 0x002C) */

#define BIT_XQSEL BIT(27)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_CTRL3				(Offset 0x002C) */

#define BIT_SHIFT_REG_FREF_SEL_2_TO_0 27
#define BIT_MASK_REG_FREF_SEL_2_TO_0 0x7
#define BIT_REG_FREF_SEL_2_TO_0(x)                                             \
	(((x) & BIT_MASK_REG_FREF_SEL_2_TO_0) << BIT_SHIFT_REG_FREF_SEL_2_TO_0)
#define BITS_REG_FREF_SEL_2_TO_0                                               \
	(BIT_MASK_REG_FREF_SEL_2_TO_0 << BIT_SHIFT_REG_FREF_SEL_2_TO_0)
#define BIT_CLEAR_REG_FREF_SEL_2_TO_0(x) ((x) & (~BITS_REG_FREF_SEL_2_TO_0))
#define BIT_GET_REG_FREF_SEL_2_TO_0(x)                                         \
	(((x) >> BIT_SHIFT_REG_FREF_SEL_2_TO_0) & BIT_MASK_REG_FREF_SEL_2_TO_0)
#define BIT_SET_REG_FREF_SEL_2_TO_0(x, v)                                      \
	(BIT_CLEAR_REG_FREF_SEL_2_TO_0(x) | BIT_REG_FREF_SEL_2_TO_0(v))

#endif

#if (HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL3				(Offset 0x002C) */

#define BIT_XQSEL_BIT0 BIT(27)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL3				(Offset 0x002C) */

#define BIT_APLL_DUMMY BIT(26)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_CTRL3				(Offset 0x002C) */

#define BIT_SHIFT_XTAL_CADJ_XOUT_5_TO_0_V1 21
#define BIT_MASK_XTAL_CADJ_XOUT_5_TO_0_V1 0x3f
#define BIT_XTAL_CADJ_XOUT_5_TO_0_V1(x)                                        \
	(((x) & BIT_MASK_XTAL_CADJ_XOUT_5_TO_0_V1)                             \
	 << BIT_SHIFT_XTAL_CADJ_XOUT_5_TO_0_V1)
#define BITS_XTAL_CADJ_XOUT_5_TO_0_V1                                          \
	(BIT_MASK_XTAL_CADJ_XOUT_5_TO_0_V1                                     \
	 << BIT_SHIFT_XTAL_CADJ_XOUT_5_TO_0_V1)
#define BIT_CLEAR_XTAL_CADJ_XOUT_5_TO_0_V1(x)                                  \
	((x) & (~BITS_XTAL_CADJ_XOUT_5_TO_0_V1))
#define BIT_GET_XTAL_CADJ_XOUT_5_TO_0_V1(x)                                    \
	(((x) >> BIT_SHIFT_XTAL_CADJ_XOUT_5_TO_0_V1) &                         \
	 BIT_MASK_XTAL_CADJ_XOUT_5_TO_0_V1)
#define BIT_SET_XTAL_CADJ_XOUT_5_TO_0_V1(x, v)                                 \
	(BIT_CLEAR_XTAL_CADJ_XOUT_5_TO_0_V1(x) |                               \
	 BIT_XTAL_CADJ_XOUT_5_TO_0_V1(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL3				(Offset 0x002C) */

#define BIT_SHIFT_XTAL_CADJ_XOUT 18
#define BIT_MASK_XTAL_CADJ_XOUT 0x3f
#define BIT_XTAL_CADJ_XOUT(x)                                                  \
	(((x) & BIT_MASK_XTAL_CADJ_XOUT) << BIT_SHIFT_XTAL_CADJ_XOUT)
#define BITS_XTAL_CADJ_XOUT                                                    \
	(BIT_MASK_XTAL_CADJ_XOUT << BIT_SHIFT_XTAL_CADJ_XOUT)
#define BIT_CLEAR_XTAL_CADJ_XOUT(x) ((x) & (~BITS_XTAL_CADJ_XOUT))
#define BIT_GET_XTAL_CADJ_XOUT(x)                                              \
	(((x) >> BIT_SHIFT_XTAL_CADJ_XOUT) & BIT_MASK_XTAL_CADJ_XOUT)
#define BIT_SET_XTAL_CADJ_XOUT(x, v)                                           \
	(BIT_CLEAR_XTAL_CADJ_XOUT(x) | BIT_XTAL_CADJ_XOUT(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_CTRL3				(Offset 0x002C) */

#define BIT_SHIFT_XTAL_CADJ_XIN_V2 15
#define BIT_MASK_XTAL_CADJ_XIN_V2 0x3f
#define BIT_XTAL_CADJ_XIN_V2(x)                                                \
	(((x) & BIT_MASK_XTAL_CADJ_XIN_V2) << BIT_SHIFT_XTAL_CADJ_XIN_V2)
#define BITS_XTAL_CADJ_XIN_V2                                                  \
	(BIT_MASK_XTAL_CADJ_XIN_V2 << BIT_SHIFT_XTAL_CADJ_XIN_V2)
#define BIT_CLEAR_XTAL_CADJ_XIN_V2(x) ((x) & (~BITS_XTAL_CADJ_XIN_V2))
#define BIT_GET_XTAL_CADJ_XIN_V2(x)                                            \
	(((x) >> BIT_SHIFT_XTAL_CADJ_XIN_V2) & BIT_MASK_XTAL_CADJ_XIN_V2)
#define BIT_SET_XTAL_CADJ_XIN_V2(x, v)                                         \
	(BIT_CLEAR_XTAL_CADJ_XIN_V2(x) | BIT_XTAL_CADJ_XIN_V2(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL3				(Offset 0x002C) */

#define BIT_SHIFT_XTAL_CADJ_XIN 12
#define BIT_MASK_XTAL_CADJ_XIN 0x3f
#define BIT_XTAL_CADJ_XIN(x)                                                   \
	(((x) & BIT_MASK_XTAL_CADJ_XIN) << BIT_SHIFT_XTAL_CADJ_XIN)
#define BITS_XTAL_CADJ_XIN (BIT_MASK_XTAL_CADJ_XIN << BIT_SHIFT_XTAL_CADJ_XIN)
#define BIT_CLEAR_XTAL_CADJ_XIN(x) ((x) & (~BITS_XTAL_CADJ_XIN))
#define BIT_GET_XTAL_CADJ_XIN(x)                                               \
	(((x) >> BIT_SHIFT_XTAL_CADJ_XIN) & BIT_MASK_XTAL_CADJ_XIN)
#define BIT_SET_XTAL_CADJ_XIN(x, v)                                            \
	(BIT_CLEAR_XTAL_CADJ_XIN(x) | BIT_XTAL_CADJ_XIN(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_CTRL3				(Offset 0x002C) */

#define BIT_SHIFT_REG_RS_V3 12
#define BIT_MASK_REG_RS_V3 0x7
#define BIT_REG_RS_V3(x) (((x) & BIT_MASK_REG_RS_V3) << BIT_SHIFT_REG_RS_V3)
#define BITS_REG_RS_V3 (BIT_MASK_REG_RS_V3 << BIT_SHIFT_REG_RS_V3)
#define BIT_CLEAR_REG_RS_V3(x) ((x) & (~BITS_REG_RS_V3))
#define BIT_GET_REG_RS_V3(x) (((x) >> BIT_SHIFT_REG_RS_V3) & BIT_MASK_REG_RS_V3)
#define BIT_SET_REG_RS_V3(x, v) (BIT_CLEAR_REG_RS_V3(x) | BIT_REG_RS_V3(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_TXPKT_EMPTY			(Offset 0x1025002C) */

#define BIT_SDIO_BCNQ_EMPTY BIT(11)
#define BIT_SDIO_HQQ_EMPTY BIT(10)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL3				(Offset 0x002C) */

#define BIT_SHIFT_REG_RS 9
#define BIT_MASK_REG_RS 0x7
#define BIT_REG_RS(x) (((x) & BIT_MASK_REG_RS) << BIT_SHIFT_REG_RS)
#define BITS_REG_RS (BIT_MASK_REG_RS << BIT_SHIFT_REG_RS)
#define BIT_CLEAR_REG_RS(x) ((x) & (~BITS_REG_RS))
#define BIT_GET_REG_RS(x) (((x) >> BIT_SHIFT_REG_RS) & BIT_MASK_REG_RS)
#define BIT_SET_REG_RS(x, v) (BIT_CLEAR_REG_RS(x) | BIT_REG_RS(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_TXPKT_EMPTY			(Offset 0x1025002C) */

#define BIT_SDIO_MQQ_EMPTY BIT(9)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_CTRL3				(Offset 0x002C) */

#define BIT_SHIFT_REG_R3_V3 9
#define BIT_MASK_REG_R3_V3 0x7
#define BIT_REG_R3_V3(x) (((x) & BIT_MASK_REG_R3_V3) << BIT_SHIFT_REG_R3_V3)
#define BITS_REG_R3_V3 (BIT_MASK_REG_R3_V3 << BIT_SHIFT_REG_R3_V3)
#define BIT_CLEAR_REG_R3_V3(x) ((x) & (~BITS_REG_R3_V3))
#define BIT_GET_REG_R3_V3(x) (((x) >> BIT_SHIFT_REG_R3_V3) & BIT_MASK_REG_R3_V3)
#define BIT_SET_REG_R3_V3(x, v) (BIT_CLEAR_REG_R3_V3(x) | BIT_REG_R3_V3(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_TXPKT_EMPTY			(Offset 0x1025002C) */

#define BIT_SDIO_MGQ_CPU_EMPTY BIT(8)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT)

/* 2 REG_AFE_CTRL3				(Offset 0x002C) */

#define BIT_SHIFT_PS_V2 7
#define BIT_MASK_PS_V2 0x7
#define BIT_PS_V2(x) (((x) & BIT_MASK_PS_V2) << BIT_SHIFT_PS_V2)
#define BITS_PS_V2 (BIT_MASK_PS_V2 << BIT_SHIFT_PS_V2)
#define BIT_CLEAR_PS_V2(x) ((x) & (~BITS_PS_V2))
#define BIT_GET_PS_V2(x) (((x) >> BIT_SHIFT_PS_V2) & BIT_MASK_PS_V2)
#define BIT_SET_PS_V2(x, v) (BIT_CLEAR_PS_V2(x) | BIT_PS_V2(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_TXPKT_EMPTY			(Offset 0x1025002C) */

#define BIT_SDIO_AC7Q_EMPTY BIT(7)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_CTRL3				(Offset 0x002C) */

#define BIT_SHIFT_REG_CS_V3 7
#define BIT_MASK_REG_CS_V3 0x3
#define BIT_REG_CS_V3(x) (((x) & BIT_MASK_REG_CS_V3) << BIT_SHIFT_REG_CS_V3)
#define BITS_REG_CS_V3 (BIT_MASK_REG_CS_V3 << BIT_SHIFT_REG_CS_V3)
#define BIT_CLEAR_REG_CS_V3(x) ((x) & (~BITS_REG_CS_V3))
#define BIT_GET_REG_CS_V3(x) (((x) >> BIT_SHIFT_REG_CS_V3) & BIT_MASK_REG_CS_V3)
#define BIT_SET_REG_CS_V3(x, v) (BIT_CLEAR_REG_CS_V3(x) | BIT_REG_CS_V3(v))

#endif

#if (HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL3				(Offset 0x002C) */

#define BIT_SHIFT_PS 7
#define BIT_MASK_PS 0x7
#define BIT_PS(x) (((x) & BIT_MASK_PS) << BIT_SHIFT_PS)
#define BITS_PS (BIT_MASK_PS << BIT_SHIFT_PS)
#define BIT_CLEAR_PS(x) ((x) & (~BITS_PS))
#define BIT_GET_PS(x) (((x) >> BIT_SHIFT_PS) & BIT_MASK_PS)
#define BIT_SET_PS(x, v) (BIT_CLEAR_PS(x) | BIT_PS(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL3				(Offset 0x002C) */

#define BIT_SHIFT_REG_R3 6
#define BIT_MASK_REG_R3 0x7
#define BIT_REG_R3(x) (((x) & BIT_MASK_REG_R3) << BIT_SHIFT_REG_R3)
#define BITS_REG_R3 (BIT_MASK_REG_R3 << BIT_SHIFT_REG_R3)
#define BIT_CLEAR_REG_R3(x) ((x) & (~BITS_REG_R3))
#define BIT_GET_REG_R3(x) (((x) >> BIT_SHIFT_REG_R3) & BIT_MASK_REG_R3)
#define BIT_SET_REG_R3(x, v) (BIT_CLEAR_REG_R3(x) | BIT_REG_R3(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL3				(Offset 0x002C) */

#define BIT_PSEN BIT(6)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_TXPKT_EMPTY			(Offset 0x1025002C) */

#define BIT_SDIO_AC6Q_EMPTY BIT(6)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL3				(Offset 0x002C) */

#define BIT_DOGENB BIT(5)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_TXPKT_EMPTY			(Offset 0x1025002C) */

#define BIT_SDIO_AC5Q_EMPTY BIT(5)

#endif

#if (HALMAC_8814A_SUPPORT)

/* 2 REG_AFE_CTRL3				(Offset 0x002C) */

#define BIT_SHIFT_REG_CP_V3 5
#define BIT_MASK_REG_CP_V3 0x3
#define BIT_REG_CP_V3(x) (((x) & BIT_MASK_REG_CP_V3) << BIT_SHIFT_REG_CP_V3)
#define BITS_REG_CP_V3 (BIT_MASK_REG_CP_V3 << BIT_SHIFT_REG_CP_V3)
#define BIT_CLEAR_REG_CP_V3(x) ((x) & (~BITS_REG_CP_V3))
#define BIT_GET_REG_CP_V3(x) (((x) >> BIT_SHIFT_REG_CP_V3) & BIT_MASK_REG_CP_V3)
#define BIT_SET_REG_CP_V3(x, v) (BIT_CLEAR_REG_CP_V3(x) | BIT_REG_CP_V3(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL3				(Offset 0x002C) */

#define BIT_SHIFT_REG_CS 4
#define BIT_MASK_REG_CS 0x3
#define BIT_REG_CS(x) (((x) & BIT_MASK_REG_CS) << BIT_SHIFT_REG_CS)
#define BITS_REG_CS (BIT_MASK_REG_CS << BIT_SHIFT_REG_CS)
#define BIT_CLEAR_REG_CS(x) ((x) & (~BITS_REG_CS))
#define BIT_GET_REG_CS(x) (((x) >> BIT_SHIFT_REG_CS) & BIT_MASK_REG_CS)
#define BIT_SET_REG_CS(x, v) (BIT_CLEAR_REG_CS(x) | BIT_REG_CS(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_TXPKT_EMPTY			(Offset 0x1025002C) */

#define BIT_SDIO_AC4Q_EMPTY BIT(4)

#endif

#if (HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL3				(Offset 0x002C) */

#define BIT_REG_MBIAS BIT(4)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_TXPKT_EMPTY			(Offset 0x1025002C) */

#define BIT_SDIO_AC3Q_EMPTY BIT(3)

#endif

#if (HALMAC_8814A_SUPPORT)

/* 2 REG_AFE_CTRL3				(Offset 0x002C) */

#define BIT_SHIFT_REG_C3_V3 3
#define BIT_MASK_REG_C3_V3 0x3
#define BIT_REG_C3_V3(x) (((x) & BIT_MASK_REG_C3_V3) << BIT_SHIFT_REG_C3_V3)
#define BITS_REG_C3_V3 (BIT_MASK_REG_C3_V3 << BIT_SHIFT_REG_C3_V3)
#define BIT_CLEAR_REG_C3_V3(x) ((x) & (~BITS_REG_C3_V3))
#define BIT_GET_REG_C3_V3(x) (((x) >> BIT_SHIFT_REG_C3_V3) & BIT_MASK_REG_C3_V3)
#define BIT_SET_REG_C3_V3(x, v) (BIT_CLEAR_REG_C3_V3(x) | BIT_REG_C3_V3(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL3				(Offset 0x002C) */

#define BIT_SHIFT_REG_CP 2
#define BIT_MASK_REG_CP 0x3
#define BIT_REG_CP(x) (((x) & BIT_MASK_REG_CP) << BIT_SHIFT_REG_CP)
#define BITS_REG_CP (BIT_MASK_REG_CP << BIT_SHIFT_REG_CP)
#define BIT_CLEAR_REG_CP(x) ((x) & (~BITS_REG_CP))
#define BIT_GET_REG_CP(x) (((x) >> BIT_SHIFT_REG_CP) & BIT_MASK_REG_CP)
#define BIT_SET_REG_CP(x, v) (BIT_CLEAR_REG_CP(x) | BIT_REG_CP(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_TXPKT_EMPTY			(Offset 0x1025002C) */

#define BIT_SDIO_AC2Q_EMPTY BIT(2)

#endif

#if (HALMAC_8814A_SUPPORT)

/* 2 REG_AFE_CTRL3				(Offset 0x002C) */

#define BIT_REG_320_SEL_V3 BIT(2)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_TXPKT_EMPTY			(Offset 0x1025002C) */

#define BIT_SDIO_AC1Q_EMPTY BIT(1)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_CTRL3				(Offset 0x002C) */

#define BIT_EN_SYN_V1 BIT(1)

#endif

#if (HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL3				(Offset 0x002C) */

#define BIT_SHIFT_REG_R3_V4 1
#define BIT_MASK_REG_R3_V4 0x7
#define BIT_REG_R3_V4(x) (((x) & BIT_MASK_REG_R3_V4) << BIT_SHIFT_REG_R3_V4)
#define BITS_REG_R3_V4 (BIT_MASK_REG_R3_V4 << BIT_SHIFT_REG_R3_V4)
#define BIT_CLEAR_REG_R3_V4(x) ((x) & (~BITS_REG_R3_V4))
#define BIT_GET_REG_R3_V4(x) (((x) >> BIT_SHIFT_REG_R3_V4) & BIT_MASK_REG_R3_V4)
#define BIT_SET_REG_R3_V4(x, v) (BIT_CLEAR_REG_R3_V4(x) | BIT_REG_R3_V4(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL3				(Offset 0x002C) */

#define BIT_SHIFT_REG_C3 0
#define BIT_MASK_REG_C3 0x3
#define BIT_REG_C3(x) (((x) & BIT_MASK_REG_C3) << BIT_SHIFT_REG_C3)
#define BITS_REG_C3 (BIT_MASK_REG_C3 << BIT_SHIFT_REG_C3)
#define BIT_CLEAR_REG_C3(x) ((x) & (~BITS_REG_C3))
#define BIT_GET_REG_C3(x) (((x) >> BIT_SHIFT_REG_C3) & BIT_MASK_REG_C3)
#define BIT_SET_REG_C3(x, v) (BIT_CLEAR_REG_C3(x) | BIT_REG_C3(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_TXPKT_EMPTY			(Offset 0x1025002C) */

#define BIT_SDIO_AC0Q_EMPTY BIT(0)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_CTRL3				(Offset 0x002C) */

#define BIT_IOOFFSET_BIT4 BIT(0)

#endif

#if (HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL3				(Offset 0x002C) */

#define BIT_REG_CP_BIT0 BIT(0)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_EFUSE_CTRL				(Offset 0x0030) */

#define BIT_EF_FLAG BIT(31)

#define BIT_SHIFT_EF_PGPD 28
#define BIT_MASK_EF_PGPD 0x7
#define BIT_EF_PGPD(x) (((x) & BIT_MASK_EF_PGPD) << BIT_SHIFT_EF_PGPD)
#define BITS_EF_PGPD (BIT_MASK_EF_PGPD << BIT_SHIFT_EF_PGPD)
#define BIT_CLEAR_EF_PGPD(x) ((x) & (~BITS_EF_PGPD))
#define BIT_GET_EF_PGPD(x) (((x) >> BIT_SHIFT_EF_PGPD) & BIT_MASK_EF_PGPD)
#define BIT_SET_EF_PGPD(x, v) (BIT_CLEAR_EF_PGPD(x) | BIT_EF_PGPD(v))

#define BIT_SHIFT_EF_RDT 24
#define BIT_MASK_EF_RDT 0xf
#define BIT_EF_RDT(x) (((x) & BIT_MASK_EF_RDT) << BIT_SHIFT_EF_RDT)
#define BITS_EF_RDT (BIT_MASK_EF_RDT << BIT_SHIFT_EF_RDT)
#define BIT_CLEAR_EF_RDT(x) ((x) & (~BITS_EF_RDT))
#define BIT_GET_EF_RDT(x) (((x) >> BIT_SHIFT_EF_RDT) & BIT_MASK_EF_RDT)
#define BIT_SET_EF_RDT(x, v) (BIT_CLEAR_EF_RDT(x) | BIT_EF_RDT(v))

#define BIT_SHIFT_EF_PGTS 20
#define BIT_MASK_EF_PGTS 0xf
#define BIT_EF_PGTS(x) (((x) & BIT_MASK_EF_PGTS) << BIT_SHIFT_EF_PGTS)
#define BITS_EF_PGTS (BIT_MASK_EF_PGTS << BIT_SHIFT_EF_PGTS)
#define BIT_CLEAR_EF_PGTS(x) ((x) & (~BITS_EF_PGTS))
#define BIT_GET_EF_PGTS(x) (((x) >> BIT_SHIFT_EF_PGTS) & BIT_MASK_EF_PGTS)
#define BIT_SET_EF_PGTS(x, v) (BIT_CLEAR_EF_PGTS(x) | BIT_EF_PGTS(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_EFUSE_CTRL				(Offset 0x0030) */

#define BIT_EF_PDWN BIT(19)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_EFUSE_CTRL				(Offset 0x0030) */

#define BIT_EF_ALDEN BIT(18)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_HTSFR_INFO			(Offset 0x10250030) */

#define BIT_SHIFT_HTSFR1 16
#define BIT_MASK_HTSFR1 0xffff
#define BIT_HTSFR1(x) (((x) & BIT_MASK_HTSFR1) << BIT_SHIFT_HTSFR1)
#define BITS_HTSFR1 (BIT_MASK_HTSFR1 << BIT_SHIFT_HTSFR1)
#define BIT_CLEAR_HTSFR1(x) ((x) & (~BITS_HTSFR1))
#define BIT_GET_HTSFR1(x) (((x) >> BIT_SHIFT_HTSFR1) & BIT_MASK_HTSFR1)
#define BIT_SET_HTSFR1(x, v) (BIT_CLEAR_HTSFR1(x) | BIT_HTSFR1(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_EFUSE_CTRL				(Offset 0x0030) */

#define BIT_SHIFT_EF_ADDR 8
#define BIT_MASK_EF_ADDR 0x3ff
#define BIT_EF_ADDR(x) (((x) & BIT_MASK_EF_ADDR) << BIT_SHIFT_EF_ADDR)
#define BITS_EF_ADDR (BIT_MASK_EF_ADDR << BIT_SHIFT_EF_ADDR)
#define BIT_CLEAR_EF_ADDR(x) ((x) & (~BITS_EF_ADDR))
#define BIT_GET_EF_ADDR(x) (((x) >> BIT_SHIFT_EF_ADDR) & BIT_MASK_EF_ADDR)
#define BIT_SET_EF_ADDR(x, v) (BIT_CLEAR_EF_ADDR(x) | BIT_EF_ADDR(v))

#define BIT_SHIFT_EF_DATA 0
#define BIT_MASK_EF_DATA 0xff
#define BIT_EF_DATA(x) (((x) & BIT_MASK_EF_DATA) << BIT_SHIFT_EF_DATA)
#define BITS_EF_DATA (BIT_MASK_EF_DATA << BIT_SHIFT_EF_DATA)
#define BIT_CLEAR_EF_DATA(x) ((x) & (~BITS_EF_DATA))
#define BIT_GET_EF_DATA(x) (((x) >> BIT_SHIFT_EF_DATA) & BIT_MASK_EF_DATA)
#define BIT_SET_EF_DATA(x, v) (BIT_CLEAR_EF_DATA(x) | BIT_EF_DATA(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_HTSFR_INFO			(Offset 0x10250030) */

#define BIT_SHIFT_HTSFR0 0
#define BIT_MASK_HTSFR0 0xffff
#define BIT_HTSFR0(x) (((x) & BIT_MASK_HTSFR0) << BIT_SHIFT_HTSFR0)
#define BITS_HTSFR0 (BIT_MASK_HTSFR0 << BIT_SHIFT_HTSFR0)
#define BIT_CLEAR_HTSFR0(x) ((x) & (~BITS_HTSFR0))
#define BIT_GET_HTSFR0(x) (((x) >> BIT_SHIFT_HTSFR0) & BIT_MASK_HTSFR0)
#define BIT_SET_HTSFR0(x, v) (BIT_CLEAR_HTSFR0(x) | BIT_HTSFR0(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || \
     HALMAC_8881A_SUPPORT)

/* 2 REG_LDO_EFUSE_CTRL			(Offset 0x0034) */

#define BIT_LDOE25_EN BIT(31)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_LDO_EFUSE_CTRL			(Offset 0x0034) */

#define BIT_SHIFT_LDOE25_VADJ_BIT0_TO_2 28
#define BIT_MASK_LDOE25_VADJ_BIT0_TO_2 0x7
#define BIT_LDOE25_VADJ_BIT0_TO_2(x)                                           \
	(((x) & BIT_MASK_LDOE25_VADJ_BIT0_TO_2)                                \
	 << BIT_SHIFT_LDOE25_VADJ_BIT0_TO_2)
#define BITS_LDOE25_VADJ_BIT0_TO_2                                             \
	(BIT_MASK_LDOE25_VADJ_BIT0_TO_2 << BIT_SHIFT_LDOE25_VADJ_BIT0_TO_2)
#define BIT_CLEAR_LDOE25_VADJ_BIT0_TO_2(x) ((x) & (~BITS_LDOE25_VADJ_BIT0_TO_2))
#define BIT_GET_LDOE25_VADJ_BIT0_TO_2(x)                                       \
	(((x) >> BIT_SHIFT_LDOE25_VADJ_BIT0_TO_2) &                            \
	 BIT_MASK_LDOE25_VADJ_BIT0_TO_2)
#define BIT_SET_LDOE25_VADJ_BIT0_TO_2(x, v)                                    \
	(BIT_CLEAR_LDOE25_VADJ_BIT0_TO_2(x) | BIT_LDOE25_VADJ_BIT0_TO_2(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_LDO_EFUSE_CTRL			(Offset 0x0034) */

#define BIT_SHIFT_LDOE25_V12ADJ_L_LOW 28
#define BIT_MASK_LDOE25_V12ADJ_L_LOW 0x7
#define BIT_LDOE25_V12ADJ_L_LOW(x)                                             \
	(((x) & BIT_MASK_LDOE25_V12ADJ_L_LOW) << BIT_SHIFT_LDOE25_V12ADJ_L_LOW)
#define BITS_LDOE25_V12ADJ_L_LOW                                               \
	(BIT_MASK_LDOE25_V12ADJ_L_LOW << BIT_SHIFT_LDOE25_V12ADJ_L_LOW)
#define BIT_CLEAR_LDOE25_V12ADJ_L_LOW(x) ((x) & (~BITS_LDOE25_V12ADJ_L_LOW))
#define BIT_GET_LDOE25_V12ADJ_L_LOW(x)                                         \
	(((x) >> BIT_SHIFT_LDOE25_V12ADJ_L_LOW) & BIT_MASK_LDOE25_V12ADJ_L_LOW)
#define BIT_SET_LDOE25_V12ADJ_L_LOW(x, v)                                      \
	(BIT_CLEAR_LDOE25_V12ADJ_L_LOW(x) | BIT_LDOE25_V12ADJ_L_LOW(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_LDO_EFUSE_CTRL			(Offset 0x0034) */

#define BIT_LDOE25_VADJ_BIT3 BIT(27)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_LDO_EFUSE_CTRL			(Offset 0x0034) */

#define BIT_LDOE25_V12ADJ_L_HIGH BIT(27)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_LDO_EFUSE_CTRL			(Offset 0x0034) */

#define BIT_SHIFT_LDOE25_V12ADJ_L 27
#define BIT_MASK_LDOE25_V12ADJ_L 0xf
#define BIT_LDOE25_V12ADJ_L(x)                                                 \
	(((x) & BIT_MASK_LDOE25_V12ADJ_L) << BIT_SHIFT_LDOE25_V12ADJ_L)
#define BITS_LDOE25_V12ADJ_L                                                   \
	(BIT_MASK_LDOE25_V12ADJ_L << BIT_SHIFT_LDOE25_V12ADJ_L)
#define BIT_CLEAR_LDOE25_V12ADJ_L(x) ((x) & (~BITS_LDOE25_V12ADJ_L))
#define BIT_GET_LDOE25_V12ADJ_L(x)                                             \
	(((x) >> BIT_SHIFT_LDOE25_V12ADJ_L) & BIT_MASK_LDOE25_V12ADJ_L)
#define BIT_SET_LDOE25_V12ADJ_L(x, v)                                          \
	(BIT_CLEAR_LDOE25_V12ADJ_L(x) | BIT_LDOE25_V12ADJ_L(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_LDO_EFUSE_CTRL			(Offset 0x0034) */

#define BIT_SHIFT_LDOE25_VADJ_3_TO_0 27
#define BIT_MASK_LDOE25_VADJ_3_TO_0 0xf
#define BIT_LDOE25_VADJ_3_TO_0(x)                                              \
	(((x) & BIT_MASK_LDOE25_VADJ_3_TO_0) << BIT_SHIFT_LDOE25_VADJ_3_TO_0)
#define BITS_LDOE25_VADJ_3_TO_0                                                \
	(BIT_MASK_LDOE25_VADJ_3_TO_0 << BIT_SHIFT_LDOE25_VADJ_3_TO_0)
#define BIT_CLEAR_LDOE25_VADJ_3_TO_0(x) ((x) & (~BITS_LDOE25_VADJ_3_TO_0))
#define BIT_GET_LDOE25_VADJ_3_TO_0(x)                                          \
	(((x) >> BIT_SHIFT_LDOE25_VADJ_3_TO_0) & BIT_MASK_LDOE25_VADJ_3_TO_0)
#define BIT_SET_LDOE25_VADJ_3_TO_0(x, v)                                       \
	(BIT_CLEAR_LDOE25_VADJ_3_TO_0(x) | BIT_LDOE25_VADJ_3_TO_0(v))

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_LDO_EFUSE_CTRL			(Offset 0x0034) */

#define BIT_EFCRES_SEL BIT(26)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_LDO_EFUSE_CTRL			(Offset 0x0034) */

#define BIT_EF_CRES_SEL BIT(26)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_LDO_EFUSE_CTRL			(Offset 0x0034) */

#define BIT_EF_CSER BIT(26)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_LDO_EFUSE_CTRL			(Offset 0x0034) */

#define BIT_SHIFT_EF_SCAN_START 16
#define BIT_MASK_EF_SCAN_START 0x1ff
#define BIT_EF_SCAN_START(x)                                                   \
	(((x) & BIT_MASK_EF_SCAN_START) << BIT_SHIFT_EF_SCAN_START)
#define BITS_EF_SCAN_START (BIT_MASK_EF_SCAN_START << BIT_SHIFT_EF_SCAN_START)
#define BIT_CLEAR_EF_SCAN_START(x) ((x) & (~BITS_EF_SCAN_START))
#define BIT_GET_EF_SCAN_START(x)                                               \
	(((x) >> BIT_SHIFT_EF_SCAN_START) & BIT_MASK_EF_SCAN_START)
#define BIT_SET_EF_SCAN_START(x, v)                                            \
	(BIT_CLEAR_EF_SCAN_START(x) | BIT_EF_SCAN_START(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_LDO_EFUSE_CTRL			(Offset 0x0034) */

#define BIT_SHIFT_EF_SCAN_START_V1 16
#define BIT_MASK_EF_SCAN_START_V1 0x3ff
#define BIT_EF_SCAN_START_V1(x)                                                \
	(((x) & BIT_MASK_EF_SCAN_START_V1) << BIT_SHIFT_EF_SCAN_START_V1)
#define BITS_EF_SCAN_START_V1                                                  \
	(BIT_MASK_EF_SCAN_START_V1 << BIT_SHIFT_EF_SCAN_START_V1)
#define BIT_CLEAR_EF_SCAN_START_V1(x) ((x) & (~BITS_EF_SCAN_START_V1))
#define BIT_GET_EF_SCAN_START_V1(x)                                            \
	(((x) >> BIT_SHIFT_EF_SCAN_START_V1) & BIT_MASK_EF_SCAN_START_V1)
#define BIT_SET_EF_SCAN_START_V1(x, v)                                         \
	(BIT_CLEAR_EF_SCAN_START_V1(x) | BIT_EF_SCAN_START_V1(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_LDO_EFUSE_CTRL			(Offset 0x0034) */

#define BIT_SHIFT_EF_SCAN_END 12
#define BIT_MASK_EF_SCAN_END 0xf
#define BIT_EF_SCAN_END(x)                                                     \
	(((x) & BIT_MASK_EF_SCAN_END) << BIT_SHIFT_EF_SCAN_END)
#define BITS_EF_SCAN_END (BIT_MASK_EF_SCAN_END << BIT_SHIFT_EF_SCAN_END)
#define BIT_CLEAR_EF_SCAN_END(x) ((x) & (~BITS_EF_SCAN_END))
#define BIT_GET_EF_SCAN_END(x)                                                 \
	(((x) >> BIT_SHIFT_EF_SCAN_END) & BIT_MASK_EF_SCAN_END)
#define BIT_SET_EF_SCAN_END(x, v)                                              \
	(BIT_CLEAR_EF_SCAN_END(x) | BIT_EF_SCAN_END(v))

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_LDO_EFUSE_CTRL			(Offset 0x0034) */

#define BIT_EF_FORCE_PGMEN BIT(11)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_LDO_EFUSE_CTRL			(Offset 0x0034) */

#define BIT_EF_PD_DIS BIT(11)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_LDO_EFUSE_CTRL			(Offset 0x0034) */

#define BIT_SCAN_EN BIT(11)
#define BIT_SW_PG_EN BIT(10)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_LDO_EFUSE_CTRL			(Offset 0x0034) */

#define BIT_SHIFT_EF_CELL_SEL 8
#define BIT_MASK_EF_CELL_SEL 0x3
#define BIT_EF_CELL_SEL(x)                                                     \
	(((x) & BIT_MASK_EF_CELL_SEL) << BIT_SHIFT_EF_CELL_SEL)
#define BITS_EF_CELL_SEL (BIT_MASK_EF_CELL_SEL << BIT_SHIFT_EF_CELL_SEL)
#define BIT_CLEAR_EF_CELL_SEL(x) ((x) & (~BITS_EF_CELL_SEL))
#define BIT_GET_EF_CELL_SEL(x)                                                 \
	(((x) >> BIT_SHIFT_EF_CELL_SEL) & BIT_MASK_EF_CELL_SEL)
#define BIT_SET_EF_CELL_SEL(x, v)                                              \
	(BIT_CLEAR_EF_CELL_SEL(x) | BIT_EF_CELL_SEL(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_LDO_EFUSE_CTRL			(Offset 0x0034) */

#define BIT_EF_TRPT BIT(7)

#define BIT_SHIFT_EF_TTHD 0
#define BIT_MASK_EF_TTHD 0x7f
#define BIT_EF_TTHD(x) (((x) & BIT_MASK_EF_TTHD) << BIT_SHIFT_EF_TTHD)
#define BITS_EF_TTHD (BIT_MASK_EF_TTHD << BIT_SHIFT_EF_TTHD)
#define BIT_CLEAR_EF_TTHD(x) ((x) & (~BITS_EF_TTHD))
#define BIT_GET_EF_TTHD(x) (((x) >> BIT_SHIFT_EF_TTHD) & BIT_MASK_EF_TTHD)
#define BIT_SET_EF_TTHD(x, v) (BIT_CLEAR_EF_TTHD(x) | BIT_EF_TTHD(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_PWR_OPTION_CTRL			(Offset 0x0038) */

#define BIT_SHIFT_UPHY_BG_ON_OPT 30
#define BIT_MASK_UPHY_BG_ON_OPT 0x3
#define BIT_UPHY_BG_ON_OPT(x)                                                  \
	(((x) & BIT_MASK_UPHY_BG_ON_OPT) << BIT_SHIFT_UPHY_BG_ON_OPT)
#define BITS_UPHY_BG_ON_OPT                                                    \
	(BIT_MASK_UPHY_BG_ON_OPT << BIT_SHIFT_UPHY_BG_ON_OPT)
#define BIT_CLEAR_UPHY_BG_ON_OPT(x) ((x) & (~BITS_UPHY_BG_ON_OPT))
#define BIT_GET_UPHY_BG_ON_OPT(x)                                              \
	(((x) >> BIT_SHIFT_UPHY_BG_ON_OPT) & BIT_MASK_UPHY_BG_ON_OPT)
#define BIT_SET_UPHY_BG_ON_OPT(x, v)                                           \
	(BIT_CLEAR_UPHY_BG_ON_OPT(x) | BIT_UPHY_BG_ON_OPT(v))

#define BIT_UPHY_BG_ON_USB2 BIT(29)
#define BIT_UPHY_BG_ON_PCIE BIT(28)
#define BIT_VD33IO_LEFT_SHD_N_ BIT(27)
#define BIT_VDIO_RIGHT1_SHD_N_ BIT(26)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_PWR_OPTION_CTRL			(Offset 0x0038) */

#define BIT_SHIFT_AFE_USB_CURRENT_SEL 26
#define BIT_MASK_AFE_USB_CURRENT_SEL 0x7
#define BIT_AFE_USB_CURRENT_SEL(x)                                             \
	(((x) & BIT_MASK_AFE_USB_CURRENT_SEL) << BIT_SHIFT_AFE_USB_CURRENT_SEL)
#define BITS_AFE_USB_CURRENT_SEL                                               \
	(BIT_MASK_AFE_USB_CURRENT_SEL << BIT_SHIFT_AFE_USB_CURRENT_SEL)
#define BIT_CLEAR_AFE_USB_CURRENT_SEL(x) ((x) & (~BITS_AFE_USB_CURRENT_SEL))
#define BIT_GET_AFE_USB_CURRENT_SEL(x)                                         \
	(((x) >> BIT_SHIFT_AFE_USB_CURRENT_SEL) & BIT_MASK_AFE_USB_CURRENT_SEL)
#define BIT_SET_AFE_USB_CURRENT_SEL(x, v)                                      \
	(BIT_CLEAR_AFE_USB_CURRENT_SEL(x) | BIT_AFE_USB_CURRENT_SEL(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_PWR_OPTION_CTRL			(Offset 0x0038) */

#define BIT_VDIO_RIGHT0_SHD_N_ BIT(25)
#define BIT_DIS_LPS_WT_PDNSUS BIT(24)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_PWR_OPTION_CTRL			(Offset 0x0038) */

#define BIT_SHIFT_AFE_USB_PATH_SEL 24
#define BIT_MASK_AFE_USB_PATH_SEL 0x3
#define BIT_AFE_USB_PATH_SEL(x)                                                \
	(((x) & BIT_MASK_AFE_USB_PATH_SEL) << BIT_SHIFT_AFE_USB_PATH_SEL)
#define BITS_AFE_USB_PATH_SEL                                                  \
	(BIT_MASK_AFE_USB_PATH_SEL << BIT_SHIFT_AFE_USB_PATH_SEL)
#define BIT_CLEAR_AFE_USB_PATH_SEL(x) ((x) & (~BITS_AFE_USB_PATH_SEL))
#define BIT_GET_AFE_USB_PATH_SEL(x)                                            \
	(((x) >> BIT_SHIFT_AFE_USB_PATH_SEL) & BIT_MASK_AFE_USB_PATH_SEL)
#define BIT_SET_AFE_USB_PATH_SEL(x, v)                                         \
	(BIT_CLEAR_AFE_USB_PATH_SEL(x) | BIT_AFE_USB_PATH_SEL(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_PWR_OPTION_CTRL			(Offset 0x0038) */

#define BIT_SHIFT_DBG_SEL_V1 16
#define BIT_MASK_DBG_SEL_V1 0xff
#define BIT_DBG_SEL_V1(x) (((x) & BIT_MASK_DBG_SEL_V1) << BIT_SHIFT_DBG_SEL_V1)
#define BITS_DBG_SEL_V1 (BIT_MASK_DBG_SEL_V1 << BIT_SHIFT_DBG_SEL_V1)
#define BIT_CLEAR_DBG_SEL_V1(x) ((x) & (~BITS_DBG_SEL_V1))
#define BIT_GET_DBG_SEL_V1(x)                                                  \
	(((x) >> BIT_SHIFT_DBG_SEL_V1) & BIT_MASK_DBG_SEL_V1)
#define BIT_SET_DBG_SEL_V1(x, v) (BIT_CLEAR_DBG_SEL_V1(x) | BIT_DBG_SEL_V1(v))

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_PWR_OPTION_CTRL			(Offset 0x0038) */

#define BIT_CLK_REQ_INPUT BIT(15)
#define BIT_USB_XTAL_CLK_SEL BIT(14)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_PWR_OPTION_CTRL			(Offset 0x0038) */

#define BIT_SHIFT_DBG_SEL_BYTE 14
#define BIT_MASK_DBG_SEL_BYTE 0x3
#define BIT_DBG_SEL_BYTE(x)                                                    \
	(((x) & BIT_MASK_DBG_SEL_BYTE) << BIT_SHIFT_DBG_SEL_BYTE)
#define BITS_DBG_SEL_BYTE (BIT_MASK_DBG_SEL_BYTE << BIT_SHIFT_DBG_SEL_BYTE)
#define BIT_CLEAR_DBG_SEL_BYTE(x) ((x) & (~BITS_DBG_SEL_BYTE))
#define BIT_GET_DBG_SEL_BYTE(x)                                                \
	(((x) >> BIT_SHIFT_DBG_SEL_BYTE) & BIT_MASK_DBG_SEL_BYTE)
#define BIT_SET_DBG_SEL_BYTE(x, v)                                             \
	(BIT_CLEAR_DBG_SEL_BYTE(x) | BIT_DBG_SEL_BYTE(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_PWR_OPTION_CTRL			(Offset 0x0038) */

#define BIT_USB_REG_XTAL_SEL BIT(14)
#define BIT_SYSON_BTIO1POW_PAD_E2 BIT(13)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_PWR_OPTION_CTRL			(Offset 0x0038) */

#define BIT_SHIFT_SYSON_SPS0_STD_L1 12
#define BIT_MASK_SYSON_SPS0_STD_L1 0x3
#define BIT_SYSON_SPS0_STD_L1(x)                                               \
	(((x) & BIT_MASK_SYSON_SPS0_STD_L1) << BIT_SHIFT_SYSON_SPS0_STD_L1)
#define BITS_SYSON_SPS0_STD_L1                                                 \
	(BIT_MASK_SYSON_SPS0_STD_L1 << BIT_SHIFT_SYSON_SPS0_STD_L1)
#define BIT_CLEAR_SYSON_SPS0_STD_L1(x) ((x) & (~BITS_SYSON_SPS0_STD_L1))
#define BIT_GET_SYSON_SPS0_STD_L1(x)                                           \
	(((x) >> BIT_SHIFT_SYSON_SPS0_STD_L1) & BIT_MASK_SYSON_SPS0_STD_L1)
#define BIT_SET_SYSON_SPS0_STD_L1(x, v)                                        \
	(BIT_CLEAR_SYSON_SPS0_STD_L1(x) | BIT_SYSON_SPS0_STD_L1(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_PWR_OPTION_CTRL			(Offset 0x0038) */

#define BIT_SHIFT_STD_L1_V1 12
#define BIT_MASK_STD_L1_V1 0x3
#define BIT_STD_L1_V1(x) (((x) & BIT_MASK_STD_L1_V1) << BIT_SHIFT_STD_L1_V1)
#define BITS_STD_L1_V1 (BIT_MASK_STD_L1_V1 << BIT_SHIFT_STD_L1_V1)
#define BIT_CLEAR_STD_L1_V1(x) ((x) & (~BITS_STD_L1_V1))
#define BIT_GET_STD_L1_V1(x) (((x) >> BIT_SHIFT_STD_L1_V1) & BIT_MASK_STD_L1_V1)
#define BIT_SET_STD_L1_V1(x, v) (BIT_CLEAR_STD_L1_V1(x) | BIT_STD_L1_V1(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_PWR_OPTION_CTRL			(Offset 0x0038) */

#define BIT_SYSON_BTIOPOW_PAD_E2 BIT(12)

#endif

#if (HALMAC_8881A_SUPPORT)

/* 2 REG_PWR_OPTION_CTRL			(Offset 0x0038) */

#define BIT_SHIFT_SYSON_LDOA12V_WT 12
#define BIT_MASK_SYSON_LDOA12V_WT 0x3
#define BIT_SYSON_LDOA12V_WT(x)                                                \
	(((x) & BIT_MASK_SYSON_LDOA12V_WT) << BIT_SHIFT_SYSON_LDOA12V_WT)
#define BITS_SYSON_LDOA12V_WT                                                  \
	(BIT_MASK_SYSON_LDOA12V_WT << BIT_SHIFT_SYSON_LDOA12V_WT)
#define BIT_CLEAR_SYSON_LDOA12V_WT(x) ((x) & (~BITS_SYSON_LDOA12V_WT))
#define BIT_GET_SYSON_LDOA12V_WT(x)                                            \
	(((x) >> BIT_SHIFT_SYSON_LDOA12V_WT) & BIT_MASK_SYSON_LDOA12V_WT)
#define BIT_SET_SYSON_LDOA12V_WT(x, v)                                         \
	(BIT_CLEAR_SYSON_LDOA12V_WT(x) | BIT_SYSON_LDOA12V_WT(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_PWR_OPTION_CTRL			(Offset 0x0038) */

#define BIT_SYSON_DBG_PAD_E2 BIT(11)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_PWR_OPTION_CTRL			(Offset 0x0038) */

#define BIT_SYSON_SDIOPOW_PAD_E2 BIT(11)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_PWR_OPTION_CTRL			(Offset 0x0038) */

#define BIT_SYSON_LED_PAD_E2 BIT(10)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_PWR_OPTION_CTRL			(Offset 0x0038) */

#define BIT_SYSON_GPEE_PAD_E2 BIT(9)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_PWR_OPTION_CTRL			(Offset 0x0038) */

#define BIT_SYSON_GPEE_PAD_E2_V33 BIT(9)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_PWR_OPTION_CTRL			(Offset 0x0038) */

#define BIT_SYSON_PCI_PAD_E2 BIT(8)

#define BIT_SHIFT_MATCH_CNT 8
#define BIT_MASK_MATCH_CNT 0xff
#define BIT_MATCH_CNT(x) (((x) & BIT_MASK_MATCH_CNT) << BIT_SHIFT_MATCH_CNT)
#define BITS_MATCH_CNT (BIT_MASK_MATCH_CNT << BIT_SHIFT_MATCH_CNT)
#define BIT_CLEAR_MATCH_CNT(x) ((x) & (~BITS_MATCH_CNT))
#define BIT_GET_MATCH_CNT(x) (((x) >> BIT_SHIFT_MATCH_CNT) & BIT_MASK_MATCH_CNT)
#define BIT_SET_MATCH_CNT(x, v) (BIT_CLEAR_MATCH_CNT(x) | BIT_MATCH_CNT(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_PWR_OPTION_CTRL			(Offset 0x0038) */

#define BIT_AUTO_SW_LDO_VOL_EN BIT(7)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_PWR_OPTION_CTRL			(Offset 0x0038) */

#define BIT_AUTO_SW_LDO_VOL_EN_V1 BIT(6)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_PWR_OPTION_CTRL			(Offset 0x0038) */

#define BIT_ADJ_LDO_VOLT BIT(6)

#endif

#if (HALMAC_8881A_SUPPORT)

/* 2 REG_PWR_OPTION_CTRL			(Offset 0x0038) */

#define BIT_SHIFT_SYSON_LDOHCI12_WT 6
#define BIT_MASK_SYSON_LDOHCI12_WT 0x3
#define BIT_SYSON_LDOHCI12_WT(x)                                               \
	(((x) & BIT_MASK_SYSON_LDOHCI12_WT) << BIT_SHIFT_SYSON_LDOHCI12_WT)
#define BITS_SYSON_LDOHCI12_WT                                                 \
	(BIT_MASK_SYSON_LDOHCI12_WT << BIT_SHIFT_SYSON_LDOHCI12_WT)
#define BIT_CLEAR_SYSON_LDOHCI12_WT(x) ((x) & (~BITS_SYSON_LDOHCI12_WT))
#define BIT_GET_SYSON_LDOHCI12_WT(x)                                           \
	(((x) >> BIT_SHIFT_SYSON_LDOHCI12_WT) & BIT_MASK_SYSON_LDOHCI12_WT)
#define BIT_SET_SYSON_LDOHCI12_WT(x, v)                                        \
	(BIT_CLEAR_SYSON_LDOHCI12_WT(x) | BIT_SYSON_LDOHCI12_WT(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_PWR_OPTION_CTRL			(Offset 0x0038) */

#define BIT_SHIFT_SYSON_SPS0WWV_WT 4
#define BIT_MASK_SYSON_SPS0WWV_WT 0x3
#define BIT_SYSON_SPS0WWV_WT(x)                                                \
	(((x) & BIT_MASK_SYSON_SPS0WWV_WT) << BIT_SHIFT_SYSON_SPS0WWV_WT)
#define BITS_SYSON_SPS0WWV_WT                                                  \
	(BIT_MASK_SYSON_SPS0WWV_WT << BIT_SHIFT_SYSON_SPS0WWV_WT)
#define BIT_CLEAR_SYSON_SPS0WWV_WT(x) ((x) & (~BITS_SYSON_SPS0WWV_WT))
#define BIT_GET_SYSON_SPS0WWV_WT(x)                                            \
	(((x) >> BIT_SHIFT_SYSON_SPS0WWV_WT) & BIT_MASK_SYSON_SPS0WWV_WT)
#define BIT_SET_SYSON_SPS0WWV_WT(x, v)                                         \
	(BIT_CLEAR_SYSON_SPS0WWV_WT(x) | BIT_SYSON_SPS0WWV_WT(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_PWR_OPTION_CTRL			(Offset 0x0038) */

#define BIT_SHIFT_SYSON_SPS0SPS_WT 4
#define BIT_MASK_SYSON_SPS0SPS_WT 0x3
#define BIT_SYSON_SPS0SPS_WT(x)                                                \
	(((x) & BIT_MASK_SYSON_SPS0SPS_WT) << BIT_SHIFT_SYSON_SPS0SPS_WT)
#define BITS_SYSON_SPS0SPS_WT                                                  \
	(BIT_MASK_SYSON_SPS0SPS_WT << BIT_SHIFT_SYSON_SPS0SPS_WT)
#define BIT_CLEAR_SYSON_SPS0SPS_WT(x) ((x) & (~BITS_SYSON_SPS0SPS_WT))
#define BIT_GET_SYSON_SPS0SPS_WT(x)                                            \
	(((x) >> BIT_SHIFT_SYSON_SPS0SPS_WT) & BIT_MASK_SYSON_SPS0SPS_WT)
#define BIT_SET_SYSON_SPS0SPS_WT(x, v)                                         \
	(BIT_CLEAR_SYSON_SPS0SPS_WT(x) | BIT_SYSON_SPS0SPS_WT(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_PWR_OPTION_CTRL			(Offset 0x0038) */

#define BIT_SHIFT_SYSON_SPS0LDO_WT 2
#define BIT_MASK_SYSON_SPS0LDO_WT 0x3
#define BIT_SYSON_SPS0LDO_WT(x)                                                \
	(((x) & BIT_MASK_SYSON_SPS0LDO_WT) << BIT_SHIFT_SYSON_SPS0LDO_WT)
#define BITS_SYSON_SPS0LDO_WT                                                  \
	(BIT_MASK_SYSON_SPS0LDO_WT << BIT_SHIFT_SYSON_SPS0LDO_WT)
#define BIT_CLEAR_SYSON_SPS0LDO_WT(x) ((x) & (~BITS_SYSON_SPS0LDO_WT))
#define BIT_GET_SYSON_SPS0LDO_WT(x)                                            \
	(((x) >> BIT_SHIFT_SYSON_SPS0LDO_WT) & BIT_MASK_SYSON_SPS0LDO_WT)
#define BIT_SET_SYSON_SPS0LDO_WT(x, v)                                         \
	(BIT_CLEAR_SYSON_SPS0LDO_WT(x) | BIT_SYSON_SPS0LDO_WT(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_PWR_OPTION_CTRL			(Offset 0x0038) */

#define BIT_SHIFT_SYSON_SPS11VLDO_WT 2
#define BIT_MASK_SYSON_SPS11VLDO_WT 0x3
#define BIT_SYSON_SPS11VLDO_WT(x)                                              \
	(((x) & BIT_MASK_SYSON_SPS11VLDO_WT) << BIT_SHIFT_SYSON_SPS11VLDO_WT)
#define BITS_SYSON_SPS11VLDO_WT                                                \
	(BIT_MASK_SYSON_SPS11VLDO_WT << BIT_SHIFT_SYSON_SPS11VLDO_WT)
#define BIT_CLEAR_SYSON_SPS11VLDO_WT(x) ((x) & (~BITS_SYSON_SPS11VLDO_WT))
#define BIT_GET_SYSON_SPS11VLDO_WT(x)                                          \
	(((x) >> BIT_SHIFT_SYSON_SPS11VLDO_WT) & BIT_MASK_SYSON_SPS11VLDO_WT)
#define BIT_SET_SYSON_SPS11VLDO_WT(x, v)                                       \
	(BIT_CLEAR_SYSON_SPS11VLDO_WT(x) | BIT_SYSON_SPS11VLDO_WT(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_PWR_OPTION_CTRL			(Offset 0x0038) */

#define BIT_SHIFT_SYSON_RCLK_SCALE 0
#define BIT_MASK_SYSON_RCLK_SCALE 0x3
#define BIT_SYSON_RCLK_SCALE(x)                                                \
	(((x) & BIT_MASK_SYSON_RCLK_SCALE) << BIT_SHIFT_SYSON_RCLK_SCALE)
#define BITS_SYSON_RCLK_SCALE                                                  \
	(BIT_MASK_SYSON_RCLK_SCALE << BIT_SHIFT_SYSON_RCLK_SCALE)
#define BIT_CLEAR_SYSON_RCLK_SCALE(x) ((x) & (~BITS_SYSON_RCLK_SCALE))
#define BIT_GET_SYSON_RCLK_SCALE(x)                                            \
	(((x) >> BIT_SHIFT_SYSON_RCLK_SCALE) & BIT_MASK_SYSON_RCLK_SCALE)
#define BIT_SET_SYSON_RCLK_SCALE(x, v)                                         \
	(BIT_CLEAR_SYSON_RCLK_SCALE(x) | BIT_SYSON_RCLK_SCALE(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_HCPWM1_V2			(Offset 0x10250038) */

#define BIT_CUR_PS BIT(0)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_CAL_TIMER				(Offset 0x003C) */

#define BIT_SHIFT_CAL_SCAL 0
#define BIT_MASK_CAL_SCAL 0xff
#define BIT_CAL_SCAL(x) (((x) & BIT_MASK_CAL_SCAL) << BIT_SHIFT_CAL_SCAL)
#define BITS_CAL_SCAL (BIT_MASK_CAL_SCAL << BIT_SHIFT_CAL_SCAL)
#define BIT_CLEAR_CAL_SCAL(x) ((x) & (~BITS_CAL_SCAL))
#define BIT_GET_CAL_SCAL(x) (((x) >> BIT_SHIFT_CAL_SCAL) & BIT_MASK_CAL_SCAL)
#define BIT_SET_CAL_SCAL(x, v) (BIT_CLEAR_CAL_SCAL(x) | BIT_CAL_SCAL(v))

/* 2 REG_ACLK_MON				(Offset 0x003E) */

#define BIT_SHIFT_RCLK_MON 5
#define BIT_MASK_RCLK_MON 0x7ff
#define BIT_RCLK_MON(x) (((x) & BIT_MASK_RCLK_MON) << BIT_SHIFT_RCLK_MON)
#define BITS_RCLK_MON (BIT_MASK_RCLK_MON << BIT_SHIFT_RCLK_MON)
#define BIT_CLEAR_RCLK_MON(x) ((x) & (~BITS_RCLK_MON))
#define BIT_GET_RCLK_MON(x) (((x) >> BIT_SHIFT_RCLK_MON) & BIT_MASK_RCLK_MON)
#define BIT_SET_RCLK_MON(x, v) (BIT_CLEAR_RCLK_MON(x) | BIT_RCLK_MON(v))

#define BIT_CAL_EN BIT(4)

#define BIT_SHIFT_DPSTU 2
#define BIT_MASK_DPSTU 0x3
#define BIT_DPSTU(x) (((x) & BIT_MASK_DPSTU) << BIT_SHIFT_DPSTU)
#define BITS_DPSTU (BIT_MASK_DPSTU << BIT_SHIFT_DPSTU)
#define BIT_CLEAR_DPSTU(x) ((x) & (~BITS_DPSTU))
#define BIT_GET_DPSTU(x) (((x) >> BIT_SHIFT_DPSTU) & BIT_MASK_DPSTU)
#define BIT_SET_DPSTU(x, v) (BIT_CLEAR_DPSTU(x) | BIT_DPSTU(v))

#define BIT_SUS_16X BIT(1)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_ACLK_MON				(Offset 0x003E) */

#define BIT_RSM_EN BIT(0)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_GPIO_MUXCFG_2			(Offset 0x003F) */

#define BIT_SOUT_GPIO8 BIT(7)
#define BIT_SOUT_GPIO5 BIT(6)
#define BIT_RFE_CTRL_5_GPIO14_V1 BIT(5)
#define BIT_RFE_CTRL_10_GPIO13_V1 BIT(4)
#define BIT_RFE_CTRL_11_GPIO4_V1 BIT(3)
#define BIT_RFE_CTRL_5_GPIO14 BIT(2)
#define BIT_RFE_CTRL_10_GPIO13 BIT(1)
#define BIT_RFE_CTRL_11_GPIO4 BIT(0)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_RFE_CTRL_3_GPIO12 BIT(31)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_PAD_D_PAPE_2G_E BIT(31)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_BT_RFE_CTRL_5_GPIO12 BIT(30)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_PAD_D_PAPE_5G_E BIT(30)

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_SIC_LOWEST_PRIORITY_V1 BIT(29)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_S0_TRSW_GPIO12 BIT(29)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_PAD_D_TRSW_E BIT(29)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_SIC_PRI_LOWEST BIT(28)

#endif

#if (HALMAC_8197F_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_SIC_LOWEST_PRIORITY BIT(28)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_RFE_CTRL_9_GPIO13 BIT(28)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_PAD_D_TRSWB_E BIT(28)

#endif

#if (HALMAC_8197F_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_WL_DSS_RSTN BIT(27)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_RFE_CTRL_9_GPIO12 BIT(27)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_PAD_D_PAPE_2G_O BIT(27)

#endif

#if (HALMAC_8197F_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_WL_DSS_EN_CLK BIT(26)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_RFE_CTRL_8_GPIO4 BIT(26)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_PAD_D_PAPE_5G_O BIT(26)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_BT_RFE_CTRL_1_GPIO13 BIT(25)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_PAD_D_TRSW_O BIT(25)

#endif

#if (HALMAC_8197F_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_SHIFT_PIN_USECASE 24
#define BIT_MASK_PIN_USECASE 0xf
#define BIT_PIN_USECASE(x)                                                     \
	(((x) & BIT_MASK_PIN_USECASE) << BIT_SHIFT_PIN_USECASE)
#define BITS_PIN_USECASE (BIT_MASK_PIN_USECASE << BIT_SHIFT_PIN_USECASE)
#define BIT_CLEAR_PIN_USECASE(x) ((x) & (~BITS_PIN_USECASE))
#define BIT_GET_PIN_USECASE(x)                                                 \
	(((x) >> BIT_SHIFT_PIN_USECASE) & BIT_MASK_PIN_USECASE)
#define BIT_SET_PIN_USECASE(x, v)                                              \
	(BIT_CLEAR_PIN_USECASE(x) | BIT_PIN_USECASE(v))

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_SHIFT_PIN_USECASE_V1 24
#define BIT_MASK_PIN_USECASE_V1 0x1f
#define BIT_PIN_USECASE_V1(x)                                                  \
	(((x) & BIT_MASK_PIN_USECASE_V1) << BIT_SHIFT_PIN_USECASE_V1)
#define BITS_PIN_USECASE_V1                                                    \
	(BIT_MASK_PIN_USECASE_V1 << BIT_SHIFT_PIN_USECASE_V1)
#define BIT_CLEAR_PIN_USECASE_V1(x) ((x) & (~BITS_PIN_USECASE_V1))
#define BIT_GET_PIN_USECASE_V1(x)                                              \
	(((x) >> BIT_SHIFT_PIN_USECASE_V1) & BIT_MASK_PIN_USECASE_V1)
#define BIT_SET_PIN_USECASE_V1(x, v)                                           \
	(BIT_CLEAR_PIN_USECASE_V1(x) | BIT_PIN_USECASE_V1(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_BT_RFE_CTRL_1_GPIO12 BIT(24)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_PAD_D_TRSWB_O BIT(24)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_EN_DATACPU_GPIO2 BIT(24)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_BT_RFE_CTRL_0_GPIO4 BIT(23)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_EN_A_ANTSEL BIT(23)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_EN_DATACPU_GPIO BIT(23)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_ANTSW_GPIO13 BIT(22)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_EN_A_ANTSELB BIT(22)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_EN_DATACPU_UART BIT(22)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_ANTSW_GPIO12 BIT(21)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_EN_D_PAPE_2G BIT(21)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_DATACPU_FSPI_EN BIT(21)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_INDIRECT_REG_CFG		(Offset 0x10250040) */

#define BIT_INDIRECT_REG_RDY BIT(20)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_ANTSWB_GPIO4 BIT(20)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_EN_D_PAPE_5G BIT(20)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_EN_GPIO8_UART_OUT BIT(20)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_FSPI_EN BIT(19)

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_SW_IO_EN BIT(19)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_INDIRECT_REG_CFG		(Offset 0x10250040) */

#define BIT_INDIRECT_REG_R BIT(19)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_WL_RTS_EXT_32K_SEL BIT(18)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_INDIRECT_REG_CFG		(Offset 0x10250040) */

#define BIT_INDIRECT_REG_W BIT(18)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_CKOUT33_EN BIT(17)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_WLBT_DPDT_SEL_EN BIT(17)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_XTAL_OUT_EN BIT(17)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_WLGP_SPI_EN BIT(16)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_WLGP_CKOUT BIT(16)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_INDIRECT_REG_CFG		(Offset 0x10250040) */

#define BIT_SHIFT_INDIRECT_REG_SIZE 16
#define BIT_MASK_INDIRECT_REG_SIZE 0x3
#define BIT_INDIRECT_REG_SIZE(x)                                               \
	(((x) & BIT_MASK_INDIRECT_REG_SIZE) << BIT_SHIFT_INDIRECT_REG_SIZE)
#define BITS_INDIRECT_REG_SIZE                                                 \
	(BIT_MASK_INDIRECT_REG_SIZE << BIT_SHIFT_INDIRECT_REG_SIZE)
#define BIT_CLEAR_INDIRECT_REG_SIZE(x) ((x) & (~BITS_INDIRECT_REG_SIZE))
#define BIT_GET_INDIRECT_REG_SIZE(x)                                           \
	(((x) >> BIT_SHIFT_INDIRECT_REG_SIZE) & BIT_MASK_INDIRECT_REG_SIZE)
#define BIT_SET_INDIRECT_REG_SIZE(x, v)                                        \
	(BIT_CLEAR_INDIRECT_REG_SIZE(x) | BIT_INDIRECT_REG_SIZE(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_WLBT_LNAON_SEL_EN BIT(16)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_SIC_LBK BIT(15)
#define BIT_ENHTP BIT(14)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_PHY_TEST_EN BIT(13)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_WLPHY_DBG_EN BIT(13)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_BT_AOD_GPIO3 BIT(13)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_SIC_23 BIT(13)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_ENSIC BIT(12)
#define BIT_SIC_SWRST BIT(11)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_PO_WIFI_PTA_PINS BIT(10)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_ENPMAC BIT(10)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_ENBTCMD BIT(9)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_COEX_MBOX BIT(9)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_BTCOEX_MBOX_EN BIT(9)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_PO_BT_PTA_PINS BIT(9)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_BTCMD_OUT_EN BIT(9)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_ENUART BIT(8)

#define BIT_SHIFT_BTMODE 6
#define BIT_MASK_BTMODE 0x3
#define BIT_BTMODE(x) (((x) & BIT_MASK_BTMODE) << BIT_SHIFT_BTMODE)
#define BITS_BTMODE (BIT_MASK_BTMODE << BIT_SHIFT_BTMODE)
#define BIT_CLEAR_BTMODE(x) ((x) & (~BITS_BTMODE))
#define BIT_GET_BTMODE(x) (((x) >> BIT_SHIFT_BTMODE) & BIT_MASK_BTMODE)
#define BIT_SET_BTMODE(x, v) (BIT_CLEAR_BTMODE(x) | BIT_BTMODE(v))

#define BIT_ENBT BIT(5)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_GEN1GEN2_SWITCH BIT(5)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_EROM_EN BIT(4)

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_ENUARTTX BIT(4)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_WLRFE_6_7_EN BIT(3)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_WLRFE_12_EN BIT(3)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_EN_D_TRSW BIT(3)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_WLRFE_4_5_EN BIT(2)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_SPDT_SEL BIT(2)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_EN_D_TRSWB BIT(2)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_GPIO_MUXCFG				(Offset 0x0040) */

#define BIT_SHIFT_GPIOSEL 0
#define BIT_MASK_GPIOSEL 0x3
#define BIT_GPIOSEL(x) (((x) & BIT_MASK_GPIOSEL) << BIT_SHIFT_GPIOSEL)
#define BITS_GPIOSEL (BIT_MASK_GPIOSEL << BIT_SHIFT_GPIOSEL)
#define BIT_CLEAR_GPIOSEL(x) ((x) & (~BITS_GPIOSEL))
#define BIT_GET_GPIOSEL(x) (((x) >> BIT_SHIFT_GPIOSEL) & BIT_MASK_GPIOSEL)
#define BIT_SET_GPIOSEL(x, v) (BIT_CLEAR_GPIOSEL(x) | BIT_GPIOSEL(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_INDIRECT_REG_CFG		(Offset 0x10250040) */

#define BIT_SHIFT_INDIRECT_REG_ADDR 0
#define BIT_MASK_INDIRECT_REG_ADDR 0xffff
#define BIT_INDIRECT_REG_ADDR(x)                                               \
	(((x) & BIT_MASK_INDIRECT_REG_ADDR) << BIT_SHIFT_INDIRECT_REG_ADDR)
#define BITS_INDIRECT_REG_ADDR                                                 \
	(BIT_MASK_INDIRECT_REG_ADDR << BIT_SHIFT_INDIRECT_REG_ADDR)
#define BIT_CLEAR_INDIRECT_REG_ADDR(x) ((x) & (~BITS_INDIRECT_REG_ADDR))
#define BIT_GET_INDIRECT_REG_ADDR(x)                                           \
	(((x) >> BIT_SHIFT_INDIRECT_REG_ADDR) & BIT_MASK_INDIRECT_REG_ADDR)
#define BIT_SET_INDIRECT_REG_ADDR(x, v)                                        \
	(BIT_CLEAR_INDIRECT_REG_ADDR(x) | BIT_INDIRECT_REG_ADDR(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_GPIO_PIN_CTRL			(Offset 0x0044) */

#define BIT_SHIFT_GPIO_MOD_7_TO_0 24
#define BIT_MASK_GPIO_MOD_7_TO_0 0xff
#define BIT_GPIO_MOD_7_TO_0(x)                                                 \
	(((x) & BIT_MASK_GPIO_MOD_7_TO_0) << BIT_SHIFT_GPIO_MOD_7_TO_0)
#define BITS_GPIO_MOD_7_TO_0                                                   \
	(BIT_MASK_GPIO_MOD_7_TO_0 << BIT_SHIFT_GPIO_MOD_7_TO_0)
#define BIT_CLEAR_GPIO_MOD_7_TO_0(x) ((x) & (~BITS_GPIO_MOD_7_TO_0))
#define BIT_GET_GPIO_MOD_7_TO_0(x)                                             \
	(((x) >> BIT_SHIFT_GPIO_MOD_7_TO_0) & BIT_MASK_GPIO_MOD_7_TO_0)
#define BIT_SET_GPIO_MOD_7_TO_0(x, v)                                          \
	(BIT_CLEAR_GPIO_MOD_7_TO_0(x) | BIT_GPIO_MOD_7_TO_0(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_GPIO_PIN_CTRL			(Offset 0x0044) */

#define BIT_SHIFT_WLGP1_SWIOMOD 24
#define BIT_MASK_WLGP1_SWIOMOD 0xff
#define BIT_WLGP1_SWIOMOD(x)                                                   \
	(((x) & BIT_MASK_WLGP1_SWIOMOD) << BIT_SHIFT_WLGP1_SWIOMOD)
#define BITS_WLGP1_SWIOMOD (BIT_MASK_WLGP1_SWIOMOD << BIT_SHIFT_WLGP1_SWIOMOD)
#define BIT_CLEAR_WLGP1_SWIOMOD(x) ((x) & (~BITS_WLGP1_SWIOMOD))
#define BIT_GET_WLGP1_SWIOMOD(x)                                               \
	(((x) >> BIT_SHIFT_WLGP1_SWIOMOD) & BIT_MASK_WLGP1_SWIOMOD)
#define BIT_SET_WLGP1_SWIOMOD(x, v)                                            \
	(BIT_CLEAR_WLGP1_SWIOMOD(x) | BIT_WLGP1_SWIOMOD(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_GPIO_PIN_CTRL			(Offset 0x0044) */

#define BIT_SHIFT_GPIO_IO_SEL_7_TO_0 16
#define BIT_MASK_GPIO_IO_SEL_7_TO_0 0xff
#define BIT_GPIO_IO_SEL_7_TO_0(x)                                              \
	(((x) & BIT_MASK_GPIO_IO_SEL_7_TO_0) << BIT_SHIFT_GPIO_IO_SEL_7_TO_0)
#define BITS_GPIO_IO_SEL_7_TO_0                                                \
	(BIT_MASK_GPIO_IO_SEL_7_TO_0 << BIT_SHIFT_GPIO_IO_SEL_7_TO_0)
#define BIT_CLEAR_GPIO_IO_SEL_7_TO_0(x) ((x) & (~BITS_GPIO_IO_SEL_7_TO_0))
#define BIT_GET_GPIO_IO_SEL_7_TO_0(x)                                          \
	(((x) >> BIT_SHIFT_GPIO_IO_SEL_7_TO_0) & BIT_MASK_GPIO_IO_SEL_7_TO_0)
#define BIT_SET_GPIO_IO_SEL_7_TO_0(x, v)                                       \
	(BIT_CLEAR_GPIO_IO_SEL_7_TO_0(x) | BIT_GPIO_IO_SEL_7_TO_0(v))

#define BIT_SHIFT_GPIO_OUT_7_TO_0 8
#define BIT_MASK_GPIO_OUT_7_TO_0 0xff
#define BIT_GPIO_OUT_7_TO_0(x)                                                 \
	(((x) & BIT_MASK_GPIO_OUT_7_TO_0) << BIT_SHIFT_GPIO_OUT_7_TO_0)
#define BITS_GPIO_OUT_7_TO_0                                                   \
	(BIT_MASK_GPIO_OUT_7_TO_0 << BIT_SHIFT_GPIO_OUT_7_TO_0)
#define BIT_CLEAR_GPIO_OUT_7_TO_0(x) ((x) & (~BITS_GPIO_OUT_7_TO_0))
#define BIT_GET_GPIO_OUT_7_TO_0(x)                                             \
	(((x) >> BIT_SHIFT_GPIO_OUT_7_TO_0) & BIT_MASK_GPIO_OUT_7_TO_0)
#define BIT_SET_GPIO_OUT_7_TO_0(x, v)                                          \
	(BIT_CLEAR_GPIO_OUT_7_TO_0(x) | BIT_GPIO_OUT_7_TO_0(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_GPIO_PIN_CTRL			(Offset 0x0044) */

#define BIT_SHIFT_GPIO_IN_7_TO_0 0
#define BIT_MASK_GPIO_IN_7_TO_0 0xff
#define BIT_GPIO_IN_7_TO_0(x)                                                  \
	(((x) & BIT_MASK_GPIO_IN_7_TO_0) << BIT_SHIFT_GPIO_IN_7_TO_0)
#define BITS_GPIO_IN_7_TO_0                                                    \
	(BIT_MASK_GPIO_IN_7_TO_0 << BIT_SHIFT_GPIO_IN_7_TO_0)
#define BIT_CLEAR_GPIO_IN_7_TO_0(x) ((x) & (~BITS_GPIO_IN_7_TO_0))
#define BIT_GET_GPIO_IN_7_TO_0(x)                                              \
	(((x) >> BIT_SHIFT_GPIO_IN_7_TO_0) & BIT_MASK_GPIO_IN_7_TO_0)
#define BIT_SET_GPIO_IN_7_TO_0(x, v)                                           \
	(BIT_CLEAR_GPIO_IN_7_TO_0(x) | BIT_GPIO_IN_7_TO_0(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_INDIRECT_REG_DATA		(Offset 0x10250044) */

#define BIT_SHIFT_INDIRECT_REG_DATA 0
#define BIT_MASK_INDIRECT_REG_DATA 0xffffffffL
#define BIT_INDIRECT_REG_DATA(x)                                               \
	(((x) & BIT_MASK_INDIRECT_REG_DATA) << BIT_SHIFT_INDIRECT_REG_DATA)
#define BITS_INDIRECT_REG_DATA                                                 \
	(BIT_MASK_INDIRECT_REG_DATA << BIT_SHIFT_INDIRECT_REG_DATA)
#define BIT_CLEAR_INDIRECT_REG_DATA(x) ((x) & (~BITS_INDIRECT_REG_DATA))
#define BIT_GET_INDIRECT_REG_DATA(x)                                           \
	(((x) >> BIT_SHIFT_INDIRECT_REG_DATA) & BIT_MASK_INDIRECT_REG_DATA)
#define BIT_SET_INDIRECT_REG_DATA(x, v)                                        \
	(BIT_CLEAR_INDIRECT_REG_DATA(x) | BIT_INDIRECT_REG_DATA(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_GPIO_INTM				(Offset 0x0048) */

#define BIT_SHIFT_MUXDBG_SEL 30
#define BIT_MASK_MUXDBG_SEL 0x3
#define BIT_MUXDBG_SEL(x) (((x) & BIT_MASK_MUXDBG_SEL) << BIT_SHIFT_MUXDBG_SEL)
#define BITS_MUXDBG_SEL (BIT_MASK_MUXDBG_SEL << BIT_SHIFT_MUXDBG_SEL)
#define BIT_CLEAR_MUXDBG_SEL(x) ((x) & (~BITS_MUXDBG_SEL))
#define BIT_GET_MUXDBG_SEL(x)                                                  \
	(((x) >> BIT_SHIFT_MUXDBG_SEL) & BIT_MASK_MUXDBG_SEL)
#define BIT_SET_MUXDBG_SEL(x, v) (BIT_CLEAR_MUXDBG_SEL(x) | BIT_MUXDBG_SEL(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_GPIO_INTM				(Offset 0x0048) */

#define BIT_PCI_LPS_LDACT BIT(29)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_GPIO_INTM				(Offset 0x0048) */

#define BIT_SHIFT_MUXDBG_SEL2 28
#define BIT_MASK_MUXDBG_SEL2 0x3
#define BIT_MUXDBG_SEL2(x)                                                     \
	(((x) & BIT_MASK_MUXDBG_SEL2) << BIT_SHIFT_MUXDBG_SEL2)
#define BITS_MUXDBG_SEL2 (BIT_MASK_MUXDBG_SEL2 << BIT_SHIFT_MUXDBG_SEL2)
#define BIT_CLEAR_MUXDBG_SEL2(x) ((x) & (~BITS_MUXDBG_SEL2))
#define BIT_GET_MUXDBG_SEL2(x)                                                 \
	(((x) >> BIT_SHIFT_MUXDBG_SEL2) & BIT_MASK_MUXDBG_SEL2)
#define BIT_SET_MUXDBG_SEL2(x, v)                                              \
	(BIT_CLEAR_MUXDBG_SEL2(x) | BIT_MUXDBG_SEL2(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_GPIO_INTM				(Offset 0x0048) */

#define BIT_GPIO_EXT_EN BIT(20)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_GPIO_INTM				(Offset 0x0048) */

#define BIT_EXTWOL1_SEL BIT(19)
#define BIT_EXTWOL1_EN BIT(18)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_GPIO_INTM				(Offset 0x0048) */

#define BIT_EXTWOL0_SEL BIT(17)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_GPIO_INTM				(Offset 0x0048) */

#define BIT_BT_EXTWOL_DIS BIT(17)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_GPIO_INTM				(Offset 0x0048) */

#define BIT_EXTWOL_SEL BIT(17)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_GPIO_INTM				(Offset 0x0048) */

#define BIT_EXTWOL0_EN BIT(16)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_GPIO_INTM				(Offset 0x0048) */

#define BIT_EXTWOL_EN BIT(16)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_GPIO_INTM				(Offset 0x0048) */

#define BIT_SHIFT_GPIO_EXT_WOL_V1 16
#define BIT_MASK_GPIO_EXT_WOL_V1 0xf
#define BIT_GPIO_EXT_WOL_V1(x)                                                 \
	(((x) & BIT_MASK_GPIO_EXT_WOL_V1) << BIT_SHIFT_GPIO_EXT_WOL_V1)
#define BITS_GPIO_EXT_WOL_V1                                                   \
	(BIT_MASK_GPIO_EXT_WOL_V1 << BIT_SHIFT_GPIO_EXT_WOL_V1)
#define BIT_CLEAR_GPIO_EXT_WOL_V1(x) ((x) & (~BITS_GPIO_EXT_WOL_V1))
#define BIT_GET_GPIO_EXT_WOL_V1(x)                                             \
	(((x) >> BIT_SHIFT_GPIO_EXT_WOL_V1) & BIT_MASK_GPIO_EXT_WOL_V1)
#define BIT_SET_GPIO_EXT_WOL_V1(x, v)                                          \
	(BIT_CLEAR_GPIO_EXT_WOL_V1(x) | BIT_GPIO_EXT_WOL_V1(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_GPIO_INTM				(Offset 0x0048) */

#define BIT_GPIOF_INT_MD BIT(15)
#define BIT_GPIOE_INT_MD BIT(14)
#define BIT_GPIOD_INT_MD BIT(13)
#define BIT_GPIOC_INT_MD BIT(12)
#define BIT_GPIOB_INT_MD BIT(11)
#define BIT_GPIOA_INT_MD BIT(10)
#define BIT_GPIO9_INT_MD BIT(9)
#define BIT_GPIO8_INT_MD BIT(8)
#define BIT_GPIO7_INT_MD BIT(7)
#define BIT_GPIO6_INT_MD BIT(6)
#define BIT_GPIO5_INT_MD BIT(5)
#define BIT_GPIO4_INT_MD BIT(4)
#define BIT_GPIO3_INT_MD BIT(3)
#define BIT_GPIO2_INT_MD BIT(2)
#define BIT_GPIO1_INT_MD BIT(1)
#define BIT_GPIO0_INT_MD BIT(0)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_LED_CFG				(Offset 0x004C) */

#define BIT_MAILBOX_1WIRE_GPIO_CFG BIT(31)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_LED_CFG				(Offset 0x004C) */

#define BIT_PAD_ANTSEL_I BIT(31)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_LED_CFG				(Offset 0x004C) */

#define BIT_ANT_SEL7_EN BIT(30)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_LED_CFG				(Offset 0x004C) */

#define BIT_BT_RF_GPIO_CFG BIT(30)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_LED_CFG				(Offset 0x004C) */

#define BIT_PAD_ANTSELB_I BIT(30)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_LED_CFG				(Offset 0x004C) */

#define BIT_ANT_SEL46_EN BIT(29)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_LED_CFG				(Offset 0x004C) */

#define BIT_BT_SDIO_INT_GPIO_CFG BIT(29)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_LED_CFG				(Offset 0x004C) */

#define BIT_PAD_D_PAPE_2G_I BIT(29)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_LED_CFG				(Offset 0x004C) */

#define BIT_ANT_SEL3_EN BIT(28)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_LED_CFG				(Offset 0x004C) */

#define BIT_MAILBOX_3WIRE_GPIO_CFG BIT(28)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_LED_CFG				(Offset 0x004C) */

#define BIT_PAD_D_PAPE_5G_I BIT(28)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_LED_CFG				(Offset 0x004C) */

#define BIT_TRSW_SEL_EN BIT(27)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_LED_CFG				(Offset 0x004C) */

#define BIT_WLBT_PAPE_SEL_EN BIT(27)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_LED_CFG				(Offset 0x004C) */

#define BIT_PAD_D_TRSW_I BIT(27)

#endif

#if (HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_LED_CFG				(Offset 0x004C) */

#define BIT_GPIO3_WL_CTRL_EN BIT(27)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_LED_CFG				(Offset 0x004C) */

#define BIT_PAPE1_SEL_EN BIT(26)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_LED_CFG				(Offset 0x004C) */

#define BIT_LNAON_SEL_EN BIT(26)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_LED_CFG				(Offset 0x004C) */

#define BIT_PAD_D_TRSWB_I BIT(26)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_LED_CFG				(Offset 0x004C) */

#define BIT_PAPE0_SEL_EN BIT(25)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_LED_CFG				(Offset 0x004C) */

#define BIT_PAPE_SEL_EN BIT(25)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_LED_CFG				(Offset 0x004C) */

#define BIT_DWH_EN BIT(25)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_LED_CFG				(Offset 0x004C) */

#define BIT_ANTSEL2_EN BIT(24)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_LED_CFG				(Offset 0x004C) */

#define BIT_ANT01_EN BIT(24)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_LED_CFG				(Offset 0x004C) */

#define BIT_DPDT_WLBT_SEL BIT(24)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_LED_CFG				(Offset 0x004C) */

#define BIT_DHW_EN BIT(24)

#endif

#if (HALMAC_8881A_SUPPORT)

/* 2 REG_LED_CFG				(Offset 0x004C) */

#define BIT_RFE_ANT_EXT_SEL BIT(24)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_LED_CFG				(Offset 0x004C) */

#define BIT_ANTSEL_EN BIT(23)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_LED_CFG				(Offset 0x004C) */

#define BIT_DPDT_SEL_EN BIT(23)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_LED_CFG				(Offset 0x004C) */

#define BIT_GPIO13_14_WL_CTRL_EN BIT(22)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_LED_CFG				(Offset 0x004C) */

#define BIT_SW_SPDT_SEL BIT(22)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_LED_CFG				(Offset 0x004C) */

#define BIT_LED2DIS_V1 BIT(22)

#endif

#if (HALMAC_8881A_SUPPORT)

/* 2 REG_LED_CFG				(Offset 0x004C) */

#define BIT_TRXIQ_DBG_EN BIT(22)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_LED_CFG				(Offset 0x004C) */

#define BIT_LED2DIS BIT(21)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_LED_CFG				(Offset 0x004C) */

#define BIT_LED0_GPIO_EN BIT(21)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_LED_CFG				(Offset 0x004C) */

#define BIT_LED2EN BIT(21)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_LED_CFG				(Offset 0x004C) */

#define BIT_LED2PL BIT(20)
#define BIT_LED2SV BIT(19)

#define BIT_SHIFT_LED2CM 16
#define BIT_MASK_LED2CM 0x7
#define BIT_LED2CM(x) (((x) & BIT_MASK_LED2CM) << BIT_SHIFT_LED2CM)
#define BITS_LED2CM (BIT_MASK_LED2CM << BIT_SHIFT_LED2CM)
#define BIT_CLEAR_LED2CM(x) ((x) & (~BITS_LED2CM))
#define BIT_GET_LED2CM(x) (((x) >> BIT_SHIFT_LED2CM) & BIT_MASK_LED2CM)
#define BIT_SET_LED2CM(x, v) (BIT_CLEAR_LED2CM(x) | BIT_LED2CM(v))

#define BIT_LED1DIS BIT(15)
#define BIT_LED1PL BIT(12)
#define BIT_LED1SV BIT(11)

#define BIT_SHIFT_LED1CM 8
#define BIT_MASK_LED1CM 0x7
#define BIT_LED1CM(x) (((x) & BIT_MASK_LED1CM) << BIT_SHIFT_LED1CM)
#define BITS_LED1CM (BIT_MASK_LED1CM << BIT_SHIFT_LED1CM)
#define BIT_CLEAR_LED1CM(x) ((x) & (~BITS_LED1CM))
#define BIT_GET_LED1CM(x) (((x) >> BIT_SHIFT_LED1CM) & BIT_MASK_LED1CM)
#define BIT_SET_LED1CM(x, v) (BIT_CLEAR_LED1CM(x) | BIT_LED1CM(v))

#define BIT_LED0DIS BIT(7)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_LED_CFG				(Offset 0x004C) */

#define BIT_SHIFT_AFE_LDO_SWR_CHECK 5
#define BIT_MASK_AFE_LDO_SWR_CHECK 0x3
#define BIT_AFE_LDO_SWR_CHECK(x)                                               \
	(((x) & BIT_MASK_AFE_LDO_SWR_CHECK) << BIT_SHIFT_AFE_LDO_SWR_CHECK)
#define BITS_AFE_LDO_SWR_CHECK                                                 \
	(BIT_MASK_AFE_LDO_SWR_CHECK << BIT_SHIFT_AFE_LDO_SWR_CHECK)
#define BIT_CLEAR_AFE_LDO_SWR_CHECK(x) ((x) & (~BITS_AFE_LDO_SWR_CHECK))
#define BIT_GET_AFE_LDO_SWR_CHECK(x)                                           \
	(((x) >> BIT_SHIFT_AFE_LDO_SWR_CHECK) & BIT_MASK_AFE_LDO_SWR_CHECK)
#define BIT_SET_AFE_LDO_SWR_CHECK(x, v)                                        \
	(BIT_CLEAR_AFE_LDO_SWR_CHECK(x) | BIT_AFE_LDO_SWR_CHECK(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_LED_CFG				(Offset 0x004C) */

#define BIT_LED0PL BIT(4)
#define BIT_LED0SV BIT(3)

#define BIT_SHIFT_LED0CM 0
#define BIT_MASK_LED0CM 0x7
#define BIT_LED0CM(x) (((x) & BIT_MASK_LED0CM) << BIT_SHIFT_LED0CM)
#define BITS_LED0CM (BIT_MASK_LED0CM << BIT_SHIFT_LED0CM)
#define BIT_CLEAR_LED0CM(x) ((x) & (~BITS_LED0CM))
#define BIT_GET_LED0CM(x) (((x) >> BIT_SHIFT_LED0CM) & BIT_MASK_LED0CM)
#define BIT_SET_LED0CM(x, v) (BIT_CLEAR_LED0CM(x) | BIT_LED0CM(v))

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_PDNINT_EN BIT(31)

#endif

#if (HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_NFC_INT_PAD_EN BIT(30)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_SPS_OCP_INT_EN BIT(29)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_SW_SPS_OCP_INT_EN BIT(29)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_PWMERR_INT_EN BIT(28)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_PWM_HW_ERR_EN BIT(28)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_GPIOF_INT_EN BIT(27)
#define BIT_FS_GPIOE_INT_EN BIT(26)
#define BIT_FS_GPIOD_INT_EN BIT(25)
#define BIT_FS_GPIOC_INT_EN BIT(24)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_ACT2RECOVERY_INT_EN BIT(24)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_GPIOB_INT_EN BIT(23)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_PCIE_GEN12_SWITCH_EN BIT(23)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_GPIOA_INT_EN BIT(22)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_HCI_SUS_EN_V1 BIT(22)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_GPIO9_INT_EN BIT(21)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_HCI_RES_EN_V1 BIT(21)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_GPIO8_INT_EN BIT(20)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_HCI_RESET_EN_V1 BIT(20)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_GPIO7_INT_EN BIT(19)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_32K_LEAVE_SETTING_EN BIT(19)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_GPIO6_INT_EN BIT(18)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_32K_ENTER_SETTING_EN BIT(18)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_GPIO5_INT_EN BIT(17)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_SIE_LPM_RSM_EN_V1 BIT(17)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_GPIO4_INT_EN BIT(16)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_SIE_LPM_ACT_EN_V1 BIT(16)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_GPIO3_INT_EN BIT(15)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_GPIOF_INT_EN_V1 BIT(15)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_GPIO2_INT_EN BIT(14)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_GPIOE_INT_EN_V1 BIT(14)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_GPIO1_INT_EN BIT(13)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_GPIOD_INT_EN_V1 BIT(13)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_GPIO0_INT_EN BIT(12)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_GPIOC_INT_EN_V1 BIT(12)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_HCI_SUS_EN BIT(11)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_GPIOB_INT_EN_V1 BIT(11)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_HCI_RES_EN BIT(10)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_GPIOA_INT_EN_V1 BIT(10)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_HCI_RESET_EN BIT(9)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_GPIO9_INT_EN_V1 BIT(9)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_AXI_EXCEPT_FINT_EN BIT(8)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_USB_SCSI_CMD_EN BIT(8)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_GPIO8_INT_EN_V1 BIT(8)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_BTON_STS_UPDATE_MSK_EN BIT(7)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_GPIO7_INT_EN_V1 BIT(7)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_ACT2RECOVERY_INT_EN_V1 BIT(6)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_GPIO6_INT_EN_V1 BIT(6)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_TRPC_TO_INT_EN BIT(5)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_GPIO5_INT_EN_V1 BIT(5)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_RPC_O_T_INT_EN BIT(4)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_HCI_TXDMA_REQ_HIMR BIT(4)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_GPIO4_INT_EN_V1 BIT(4)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_32K_LEAVE_SETTING_MAK BIT(3)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_GPIO3_INT_EN_V1 BIT(3)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_32K_ENTER_SETTING_MAK BIT(2)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_GPIO2_INT_EN_V1 BIT(2)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_USB_LPMRSM_MSK BIT(1)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_GPIO1_INT_EN_V1 BIT(1)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_USB_LPMINT_MSK BIT(0)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSIMR				(Offset 0x0050) */

#define BIT_FS_GPIO0_INT_EN_V1 BIT(0)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_PDNINT BIT(31)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_SPS_OCP_INT BIT(29)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_SW_SPS_OCP_INT BIT(29)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_PWMERR_INT BIT(28)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_PWM_HW_ERR BIT(28)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_GPIOF_INT BIT(27)
#define BIT_FS_GPIOE_INT BIT(26)
#define BIT_FS_GPIOD_INT BIT(25)
#define BIT_FS_GPIOC_INT BIT(24)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_ACT2RECOVERY_INT BIT(24)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_GPIOB_INT BIT(23)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_PCIE_GEN12_SWITCH BIT(23)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_GPIOA_INT BIT(22)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_HCI_SUS_V1 BIT(22)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_GPIO9_INT BIT(21)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_HCI_RES_V1 BIT(21)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_GPIO8_INT BIT(20)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_HCI_RESET_V1 BIT(20)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_GPIO7_INT BIT(19)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_32K_LEAVE_SETTING BIT(19)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_GPIO6_INT BIT(18)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_32K_ENTER_SETTING BIT(18)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_GPIO5_INT BIT(17)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_SIE_LPM_RSM_V1 BIT(17)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_GPIO4_INT BIT(16)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_SIE_LPM_ACT_V1 BIT(16)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_GPIO3_INT BIT(15)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_GPIOF_INT_V1 BIT(15)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_GPIO2_INT BIT(14)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_GPIOE_INT_V1 BIT(14)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_GPIO1_INT BIT(13)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_GPIOD_INT_V1 BIT(13)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_GPIO0_INT BIT(12)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_GPIOC_INT_V1 BIT(12)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_HCI_SUS_INT BIT(11)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_GPIOB_INT_V1 BIT(11)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_HCI_RES_INT BIT(10)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_GPIOA_INT_V1 BIT(10)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_HCI_RESET_INT BIT(9)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_GPIO9_INT_V1 BIT(9)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_AXI_EXCEPT_FINT BIT(8)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_USB_SCSI_CMD_INT BIT(8)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_GPIO8_INT_V1 BIT(8)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8814B_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_BTON_STS_UPDATE_INT BIT(7)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_GPIO7_INT_V1 BIT(7)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_WINTINI_RDY BIT(6)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_ACT2RECOVERY_INT_V1 BIT(6)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_ACT2RECOVERY BIT(6)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_GPIO6_INT_V1 BIT(6)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_TRPC_TO_INT_INT BIT(5)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_GPIO5_INT_V1 BIT(5)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_RPC_O_T_INT_INT BIT(4)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_HCI_TXDMA_REQ_HISR BIT(4)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_GPIO4_INT_V1 BIT(4)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_32K_LEAVE_SETTING_INT BIT(3)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_GPIO3_INT_V1 BIT(3)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_32K_ENTER_SETTING_INT BIT(2)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_GPIO2_INT_V1 BIT(2)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_USB_LPMRSM_INT BIT(1)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_GPIO1_INT_V1 BIT(1)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_USB_LPMINT_INT BIT(0)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_FSISR				(Offset 0x0054) */

#define BIT_FS_GPIO0_INT_V1 BIT(0)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_HSIMR				(Offset 0x0058) */

#define BIT_GPIOF_INT_EN BIT(31)
#define BIT_GPIOE_INT_EN BIT(30)
#define BIT_GPIOD_INT_EN BIT(29)
#define BIT_GPIOC_INT_EN BIT(28)
#define BIT_GPIOB_INT_EN BIT(27)
#define BIT_GPIOA_INT_EN BIT(26)
#define BIT_GPIO9_INT_EN BIT(25)
#define BIT_GPIO8_INT_EN BIT(24)
#define BIT_GPIO7_INT_EN BIT(23)
#define BIT_GPIO6_INT_EN BIT(22)
#define BIT_GPIO5_INT_EN BIT(21)
#define BIT_GPIO4_INT_EN BIT(20)
#define BIT_GPIO3_INT_EN BIT(19)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_HSIMR				(Offset 0x0058) */

#define BIT_GPIO2_INT_EN BIT(18)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_HSIMR				(Offset 0x0058) */

#define BIT_GPIO2_INT_EN_V1 BIT(18)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_HSIMR				(Offset 0x0058) */

#define BIT_GPIO1_INT_EN BIT(17)
#define BIT_GPIO0_INT_EN BIT(16)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_HSIMR				(Offset 0x0058) */

#define BIT_AXI_EXCEPT_HINT_EN BIT(9)
#define BIT_PDNINT_EN_V2 BIT(8)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_HSIMR				(Offset 0x0058) */

#define BIT_PDNINT_EN BIT(7)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_HSIMR				(Offset 0x0058) */

#define BIT_PDNINT_EN_V1 BIT(7)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_HSIMR				(Offset 0x0058) */

#define BIT_PDN_INT_EN BIT(7)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_HSIMR				(Offset 0x0058) */

#define BIT_RON_INT_EN BIT(6)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_HSIMR				(Offset 0x0058) */

#define BIT_RON_INT_EN_V1 BIT(6)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_HSIMR				(Offset 0x0058) */

#define BIT_SPS_OCP_INT_EN BIT(5)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_HSIMR				(Offset 0x0058) */

#define BIT_SPS_OCP_INT_EN_V1 BIT(5)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_HSIMR				(Offset 0x0058) */

#define BIT_GPIO15_0_INT_EN BIT(0)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_HSIMR				(Offset 0x0058) */

#define BIT_GPIO15_0_INT_EN_V1 BIT(0)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_HSISR				(Offset 0x005C) */

#define BIT_GPIOF_INT BIT(31)
#define BIT_GPIOE_INT BIT(30)
#define BIT_GPIOD_INT BIT(29)
#define BIT_GPIOC_INT BIT(28)
#define BIT_GPIOB_INT BIT(27)
#define BIT_GPIOA_INT BIT(26)
#define BIT_GPIO9_INT BIT(25)
#define BIT_GPIO8_INT BIT(24)
#define BIT_GPIO7_INT BIT(23)
#define BIT_GPIO6_INT BIT(22)
#define BIT_GPIO5_INT BIT(21)
#define BIT_GPIO4_INT BIT(20)
#define BIT_GPIO3_INT BIT(19)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_HSISR				(Offset 0x005C) */

#define BIT_GPIO2_INT BIT(18)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_HSISR				(Offset 0x005C) */

#define BIT_GPIO2_INT_V1 BIT(18)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_HSISR				(Offset 0x005C) */

#define BIT_GPIO1_INT BIT(17)
#define BIT_GPIO0_INT BIT(16)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_HSISR				(Offset 0x005C) */

#define BIT_AXI_EXCEPT_HINT BIT(8)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_HSISR				(Offset 0x005C) */

#define BIT_PDNINT BIT(7)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_HSISR				(Offset 0x005C) */

#define BIT_PDNINT_V1 BIT(7)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_HSISR				(Offset 0x005C) */

#define BIT_PDN_INT BIT(7)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_HSISR				(Offset 0x005C) */

#define BIT_RON_INT BIT(6)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_HSISR				(Offset 0x005C) */

#define BIT_RON_INT_V1 BIT(6)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_HSISR				(Offset 0x005C) */

#define BIT_SPS_OCP_INT BIT(5)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_HSISR				(Offset 0x005C) */

#define BIT_SPS_OCP_INT_V1 BIT(5)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_HSISR				(Offset 0x005C) */

#define BIT_GPIO15_0_INT BIT(0)
#define BIT_MCUFWDL_EN BIT(0)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_HSISR				(Offset 0x005C) */

#define BIT_GPIO15_0_INT_V1 BIT(0)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_GPIO_EXT_CTRL			(Offset 0x0060) */

#define BIT_SHIFT_GPIO_MOD_15_TO_8 24
#define BIT_MASK_GPIO_MOD_15_TO_8 0xff
#define BIT_GPIO_MOD_15_TO_8(x)                                                \
	(((x) & BIT_MASK_GPIO_MOD_15_TO_8) << BIT_SHIFT_GPIO_MOD_15_TO_8)
#define BITS_GPIO_MOD_15_TO_8                                                  \
	(BIT_MASK_GPIO_MOD_15_TO_8 << BIT_SHIFT_GPIO_MOD_15_TO_8)
#define BIT_CLEAR_GPIO_MOD_15_TO_8(x) ((x) & (~BITS_GPIO_MOD_15_TO_8))
#define BIT_GET_GPIO_MOD_15_TO_8(x)                                            \
	(((x) >> BIT_SHIFT_GPIO_MOD_15_TO_8) & BIT_MASK_GPIO_MOD_15_TO_8)
#define BIT_SET_GPIO_MOD_15_TO_8(x, v)                                         \
	(BIT_CLEAR_GPIO_MOD_15_TO_8(x) | BIT_GPIO_MOD_15_TO_8(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_GPIO_EXT_CTRL			(Offset 0x0060) */

#define BIT_ROM_DLEN BIT(19)

#define BIT_SHIFT_GPIO_IO_SEL_15_TO_8 16
#define BIT_MASK_GPIO_IO_SEL_15_TO_8 0xff
#define BIT_GPIO_IO_SEL_15_TO_8(x)                                             \
	(((x) & BIT_MASK_GPIO_IO_SEL_15_TO_8) << BIT_SHIFT_GPIO_IO_SEL_15_TO_8)
#define BITS_GPIO_IO_SEL_15_TO_8                                               \
	(BIT_MASK_GPIO_IO_SEL_15_TO_8 << BIT_SHIFT_GPIO_IO_SEL_15_TO_8)
#define BIT_CLEAR_GPIO_IO_SEL_15_TO_8(x) ((x) & (~BITS_GPIO_IO_SEL_15_TO_8))
#define BIT_GET_GPIO_IO_SEL_15_TO_8(x)                                         \
	(((x) >> BIT_SHIFT_GPIO_IO_SEL_15_TO_8) & BIT_MASK_GPIO_IO_SEL_15_TO_8)
#define BIT_SET_GPIO_IO_SEL_15_TO_8(x, v)                                      \
	(BIT_CLEAR_GPIO_IO_SEL_15_TO_8(x) | BIT_GPIO_IO_SEL_15_TO_8(v))

#define BIT_SHIFT_ROM_PGE 16
#define BIT_MASK_ROM_PGE 0x7
#define BIT_ROM_PGE(x) (((x) & BIT_MASK_ROM_PGE) << BIT_SHIFT_ROM_PGE)
#define BITS_ROM_PGE (BIT_MASK_ROM_PGE << BIT_SHIFT_ROM_PGE)
#define BIT_CLEAR_ROM_PGE(x) ((x) & (~BITS_ROM_PGE))
#define BIT_GET_ROM_PGE(x) (((x) >> BIT_SHIFT_ROM_PGE) & BIT_MASK_ROM_PGE)
#define BIT_SET_ROM_PGE(x, v) (BIT_CLEAR_ROM_PGE(x) | BIT_ROM_PGE(v))

#define BIT_SHIFT_GPIO_OUT_15_TO_8 8
#define BIT_MASK_GPIO_OUT_15_TO_8 0xff
#define BIT_GPIO_OUT_15_TO_8(x)                                                \
	(((x) & BIT_MASK_GPIO_OUT_15_TO_8) << BIT_SHIFT_GPIO_OUT_15_TO_8)
#define BITS_GPIO_OUT_15_TO_8                                                  \
	(BIT_MASK_GPIO_OUT_15_TO_8 << BIT_SHIFT_GPIO_OUT_15_TO_8)
#define BIT_CLEAR_GPIO_OUT_15_TO_8(x) ((x) & (~BITS_GPIO_OUT_15_TO_8))
#define BIT_GET_GPIO_OUT_15_TO_8(x)                                            \
	(((x) >> BIT_SHIFT_GPIO_OUT_15_TO_8) & BIT_MASK_GPIO_OUT_15_TO_8)
#define BIT_SET_GPIO_OUT_15_TO_8(x, v)                                         \
	(BIT_CLEAR_GPIO_OUT_15_TO_8(x) | BIT_GPIO_OUT_15_TO_8(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_GPIO_EXT_CTRL			(Offset 0x0060) */

#define BIT_SHIFT_GPIO_IN_15_TO_8 0
#define BIT_MASK_GPIO_IN_15_TO_8 0xff
#define BIT_GPIO_IN_15_TO_8(x)                                                 \
	(((x) & BIT_MASK_GPIO_IN_15_TO_8) << BIT_SHIFT_GPIO_IN_15_TO_8)
#define BITS_GPIO_IN_15_TO_8                                                   \
	(BIT_MASK_GPIO_IN_15_TO_8 << BIT_SHIFT_GPIO_IN_15_TO_8)
#define BIT_CLEAR_GPIO_IN_15_TO_8(x) ((x) & (~BITS_GPIO_IN_15_TO_8))
#define BIT_GET_GPIO_IN_15_TO_8(x)                                             \
	(((x) >> BIT_SHIFT_GPIO_IN_15_TO_8) & BIT_MASK_GPIO_IN_15_TO_8)
#define BIT_SET_GPIO_IN_15_TO_8(x, v)                                          \
	(BIT_CLEAR_GPIO_IN_15_TO_8(x) | BIT_GPIO_IN_15_TO_8(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_H2C				(Offset 0x10250060) */

#define BIT_SHIFT_SDIO_H2C_MSG 0
#define BIT_MASK_SDIO_H2C_MSG 0xffffffffL
#define BIT_SDIO_H2C_MSG(x)                                                    \
	(((x) & BIT_MASK_SDIO_H2C_MSG) << BIT_SHIFT_SDIO_H2C_MSG)
#define BITS_SDIO_H2C_MSG (BIT_MASK_SDIO_H2C_MSG << BIT_SHIFT_SDIO_H2C_MSG)
#define BIT_CLEAR_SDIO_H2C_MSG(x) ((x) & (~BITS_SDIO_H2C_MSG))
#define BIT_GET_SDIO_H2C_MSG(x)                                                \
	(((x) >> BIT_SHIFT_SDIO_H2C_MSG) & BIT_MASK_SDIO_H2C_MSG)
#define BIT_SET_SDIO_H2C_MSG(x, v)                                             \
	(BIT_CLEAR_SDIO_H2C_MSG(x) | BIT_SDIO_H2C_MSG(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_DATA_CPU_JTAG BIT(30)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_PAPE_WLBT_SEL BIT(29)
#define BIT_LNAON_WLBT_SEL BIT(28)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_BDEN BIT(28)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_BT_BQB_GPIO_SEL BIT(27)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_BTGP_GPG3_FEN BIT(26)
#define BIT_BTGP_GPG2_FEN BIT(25)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_BTGP_JTAG_EN BIT(24)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_BB2PP_ISO BIT(24)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_XTAL_CLK_EXTARNAL_EN BIT(23)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_BTBRI_UART_EN BIT(22)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_BTGP_UART0_EN BIT(22)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_BTGP_UART1_EN BIT(21)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_BTCOEX_PU BIT(21)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_BTGP_SPI_EN BIT(20)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_EEPROM_SEL_PD BIT(20)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_BTGP_GPIO_E2 BIT(19)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_TST_MOD_PD BIT(19)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_BTGP_GPIO_EN BIT(18)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_BOOT_FLUSH_PD BIT(18)
#define BIT_USB_XTAL_SEL1_PD BIT(17)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_SHIFT_BTGP_GPIO_SL 16
#define BIT_MASK_BTGP_GPIO_SL 0x3
#define BIT_BTGP_GPIO_SL(x)                                                    \
	(((x) & BIT_MASK_BTGP_GPIO_SL) << BIT_SHIFT_BTGP_GPIO_SL)
#define BITS_BTGP_GPIO_SL (BIT_MASK_BTGP_GPIO_SL << BIT_SHIFT_BTGP_GPIO_SL)
#define BIT_CLEAR_BTGP_GPIO_SL(x) ((x) & (~BITS_BTGP_GPIO_SL))
#define BIT_GET_BTGP_GPIO_SL(x)                                                \
	(((x) >> BIT_SHIFT_BTGP_GPIO_SL) & BIT_MASK_BTGP_GPIO_SL)
#define BIT_SET_BTGP_GPIO_SL(x, v)                                             \
	(BIT_CLEAR_BTGP_GPIO_SL(x) | BIT_BTGP_GPIO_SL(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_USB_XTAL_SEL0_PD BIT(16)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_HST_WKE_DEV_SL BIT(15)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_BTSUSB_PL BIT(15)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_WL_JTAG BIT(15)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_PAD_SDIO_SR BIT(14)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_GPIO14_OUTPUT_PL BIT(13)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_SW_DEVWHOST_POLARITY BIT(13)

#endif

#if (HALMAC_8881A_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_GPIO15_OUTPUT_PL BIT(13)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_HOST_WAKE_PAD_PULL_EN BIT(12)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_HOST_WAKE_DEV_PLL_EN BIT(12)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_HOST_WAKE_PAD_SL BIT(11)

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_SW_TRSW_3 BIT(11)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_HOST_WAKE_DEV_POLARITY BIT(11)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_PAD_TRSW_SR BIT(10)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_PAD_LNAON_SR BIT(10)

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_SW_TRSW_2 BIT(10)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_PAD_TRSW_E2 BIT(9)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_PAD_LNAON_E2 BIT(9)

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_SW_TRSW_1 BIT(9)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_A_ANTSEL_SR BIT(9)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_SW_TRSW_P_SEL_DATA BIT(8)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_SW_LNAON_G_SEL_DATA BIT(8)

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_SW_TRSW_0 BIT(8)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_A_ANTSEL_E2 BIT(8)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_SW_TRSW_N_SEL_DATA BIT(7)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_SW_LNAON_A_SEL_DATA BIT(7)

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_SW_PAPE_3 BIT(7)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_D_PAPE_2G_SR BIT(7)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_PAD_PAPE_SR BIT(6)

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_SW_PAPE_2 BIT(6)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_D_PAPE_5G_SR BIT(6)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_PAD_PAPE_E2 BIT(5)

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_SW_PAPE_1 BIT(5)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_D_TRSW_SR BIT(5)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_SW_PAPE_1_SEL_DATA BIT(4)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_SW_PAPE_G_SEL_DATA BIT(4)

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_SW_PAPE_0 BIT(4)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_D_TRSWB_SR BIT(4)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_SW_PAPE_0_SEL_DATA BIT(3)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_SW_PAPE_A_SEL_DATA BIT(3)

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_SW_ANTSEL_3 BIT(3)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_D_PAPE_2G_E2 BIT(3)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_SW_ANTSEL_2_SEL_DATA BIT(2)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_PAD_DPDT_SR BIT(2)

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_SW_ANTSEL_2 BIT(2)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_D_PAPE_5G_E2 BIT(2)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_SW_ANTSEL_N_SEL_DATA BIT(1)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_PAD_DPDT_PAD_E2 BIT(1)

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_SW_ANTSEL_1 BIT(1)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_D_TRSW_E2 BIT(1)

#endif

#if (HALMAC_8881A_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_PAD_DPDT_E2 BIT(1)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_SW_ANTSEL_P_SEL_DATA BIT(0)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_SW_DPDT_SEL_DATA BIT(0)

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_SW_ANTSEL_0 BIT(0)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_C2H				(Offset 0x10250064) */

#define BIT_SHIFT_SDIO_C2H_MSG 0
#define BIT_MASK_SDIO_C2H_MSG 0xffffffffL
#define BIT_SDIO_C2H_MSG(x)                                                    \
	(((x) & BIT_MASK_SDIO_C2H_MSG) << BIT_SHIFT_SDIO_C2H_MSG)
#define BITS_SDIO_C2H_MSG (BIT_MASK_SDIO_C2H_MSG << BIT_SHIFT_SDIO_C2H_MSG)
#define BIT_CLEAR_SDIO_C2H_MSG(x) ((x) & (~BITS_SDIO_C2H_MSG))
#define BIT_GET_SDIO_C2H_MSG(x)                                                \
	(((x) >> BIT_SHIFT_SDIO_C2H_MSG) & BIT_MASK_SDIO_C2H_MSG)
#define BIT_SET_SDIO_C2H_MSG(x, v)                                             \
	(BIT_CLEAR_SDIO_C2H_MSG(x) | BIT_SDIO_C2H_MSG(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_PAD_CTRL1				(Offset 0x0064) */

#define BIT_D_TRSWB_E2 BIT(0)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_ISO_BD2PP BIT(31)
#define BIT_LDOV12B_EN BIT(30)
#define BIT_CKEN_BTGPS BIT(29)
#define BIT_FEN_BTGPS BIT(28)
#define BIT_BTCPU_BOOTSEL BIT(27)
#define BIT_SPI_SPEEDUP BIT(26)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_BT_LPS_EN BIT(25)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_BT_LDO_MODE BIT(25)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_BT_SUS BIT(25)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_DEVWAKE_PAD_TYPE_SEL BIT(24)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_CLKREQ_PAD_PL BIT(23)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_CLKREQ_PAD_TYPE_SEL BIT(23)

#endif

#if (HALMAC_8881A_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_CKSL_BZSLP BIT(23)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_EN_CPL_TIMEOUT_PS BIT(22)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_BT_WAKE_HST_EN BIT(22)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_BTGP_WAKE_HST_EN BIT(22)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_ISO_BTPON2PP BIT(22)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_REG_TXDMA_FAIL_PS BIT(21)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_WAKE_BT_EN BIT(21)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_BTGP_WAKE_BT_EN BIT(21)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_BTCOEX_CMD BIT(21)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_EN_BT BIT(20)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_BTGP_EN BIT(20)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_BT_UART_INTF BIT(20)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_EN_HWENTR_L1 BIT(19)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_BT_SUSN_EN BIT(19)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_BTGP_SUS_EN BIT(19)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_BT_HWROF_EN BIT(19)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_S3_RF_HW_EN BIT(19)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_EN_ADV_CLKGATE BIT(18)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_BT_FUNC_EN BIT(18)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_S2_RF_HW_EN BIT(18)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_BT_HWPDN_SL BIT(17)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_S1_RF_HW_EN BIT(17)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_BT_DISN_EN BIT(16)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_BT_HWPDEN BIT(16)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_S0_RF_HW_EN BIT(16)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_BT_PDN_PULL_EN BIT(15)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_WL_PDN_PULL_EN BIT(14)
#define BIT_EXTERNAL_REQUEST_PL BIT(13)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_GPIO0_2_3_PULL_LOW_EN BIT(12)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_ISO_BA2PP BIT(11)
#define BIT_BT_AFE_LDO_EN BIT(10)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_PDN_PIN_SEL BIT(10)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_GPIO11_PULL_LOW_EN BIT(9)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_BT_AFE_PLL_EN BIT(9)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_GPIO4_PULL_LOW_EN BIT(8)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_BT_DIG_CLK_EN BIT(8)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_BT_WAKE_HST_SL BIT(7)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_BT_WAKE_HST_PL BIT(7)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_ASSERT_SPS_EN BIT(7)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_UART_BRIDGE BIT(7)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_WAKE_BT_SL BIT(6)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_WAKE_BT_PL BIT(6)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_WLAN_32K_SEL BIT(6)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_MASK_CHIPEN BIT(6)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_OSC32K_CTRL_SEL BIT(6)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_WL_DRV_EXIST_IDX BIT(5)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_ASSERT_RF_EN BIT(5)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_DOP_EHPAD BIT(4)

#endif

#if (HALMAC_8881A_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_BIT_DOP_EHPAD BIT(4)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_WL_HWROF_EN BIT(3)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_SDIO_PAD_SHUTDOWNB BIT(3)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_WL_FUNC_EN BIT(2)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_SDIO_CLK_SMT BIT(2)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_WL_BT_PWR_CTRL			(Offset 0x0068) */

#define BIT_WL_HWPDN_SL BIT(1)
#define BIT_WL_HWPDN_EN BIT(0)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SDM_DEBUG				(Offset 0x006C) */

#define BIT_SHIFT_F0N 23
#define BIT_MASK_F0N 0x7
#define BIT_F0N(x) (((x) & BIT_MASK_F0N) << BIT_SHIFT_F0N)
#define BITS_F0N (BIT_MASK_F0N << BIT_SHIFT_F0N)
#define BIT_CLEAR_F0N(x) ((x) & (~BITS_F0N))
#define BIT_GET_F0N(x) (((x) >> BIT_SHIFT_F0N) & BIT_MASK_F0N)
#define BIT_SET_F0N(x, v) (BIT_CLEAR_F0N(x) | BIT_F0N(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_SDM_DEBUG				(Offset 0x006C) */

#define BIT_BT_WAKE_DEV_EN_V1 BIT(19)
#define BIT_BT_WAKE_HST_EN_V1 BIT(18)
#define BIT_BT_WAKE_HST_PL_V1 BIT(17)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_GSSR				(Offset 0x006C) */

#define BIT_SHIFT_GPIO_15_TO_0_VAL 16
#define BIT_MASK_GPIO_15_TO_0_VAL 0xffff
#define BIT_GPIO_15_TO_0_VAL(x)                                                \
	(((x) & BIT_MASK_GPIO_15_TO_0_VAL) << BIT_SHIFT_GPIO_15_TO_0_VAL)
#define BITS_GPIO_15_TO_0_VAL                                                  \
	(BIT_MASK_GPIO_15_TO_0_VAL << BIT_SHIFT_GPIO_15_TO_0_VAL)
#define BIT_CLEAR_GPIO_15_TO_0_VAL(x) ((x) & (~BITS_GPIO_15_TO_0_VAL))
#define BIT_GET_GPIO_15_TO_0_VAL(x)                                            \
	(((x) >> BIT_SHIFT_GPIO_15_TO_0_VAL) & BIT_MASK_GPIO_15_TO_0_VAL)
#define BIT_SET_GPIO_15_TO_0_VAL(x, v)                                         \
	(BIT_CLEAR_GPIO_15_TO_0_VAL(x) | BIT_GPIO_15_TO_0_VAL(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_SDM_DEBUG				(Offset 0x006C) */

#define BIT_BT_CLKREQ_EN_V1 BIT(16)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SDM_DEBUG				(Offset 0x006C) */

#define BIT_SHIFT_F0F 10
#define BIT_MASK_F0F 0x1fff
#define BIT_F0F(x) (((x) & BIT_MASK_F0F) << BIT_SHIFT_F0F)
#define BITS_F0F (BIT_MASK_F0F << BIT_SHIFT_F0F)
#define BIT_CLEAR_F0F(x) ((x) & (~BITS_F0F))
#define BIT_GET_F0F(x) (((x) >> BIT_SHIFT_F0F) & BIT_MASK_F0F)
#define BIT_SET_F0F(x, v) (BIT_CLEAR_F0F(x) | BIT_F0F(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDM_DEBUG				(Offset 0x006C) */

#define BIT_GPIO_IE_V18 BIT(10)
#define BIT_PCIE_IE_V18 BIT(9)
#define BIT_UART_IE_V18 BIT(8)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SDM_DEBUG				(Offset 0x006C) */

#define BIT_SHIFT_DIVN 4
#define BIT_MASK_DIVN 0x3f
#define BIT_DIVN(x) (((x) & BIT_MASK_DIVN) << BIT_SHIFT_DIVN)
#define BITS_DIVN (BIT_MASK_DIVN << BIT_SHIFT_DIVN)
#define BIT_CLEAR_DIVN(x) ((x) & (~BITS_DIVN))
#define BIT_GET_DIVN(x) (((x) >> BIT_SHIFT_DIVN) & BIT_MASK_DIVN)
#define BIT_SET_DIVN(x, v) (BIT_CLEAR_DIVN(x) | BIT_DIVN(v))

#define BIT_SHIFT_BB_DBG_SEL_AFE_SDM 0
#define BIT_MASK_BB_DBG_SEL_AFE_SDM 0xf
#define BIT_BB_DBG_SEL_AFE_SDM(x)                                              \
	(((x) & BIT_MASK_BB_DBG_SEL_AFE_SDM) << BIT_SHIFT_BB_DBG_SEL_AFE_SDM)
#define BITS_BB_DBG_SEL_AFE_SDM                                                \
	(BIT_MASK_BB_DBG_SEL_AFE_SDM << BIT_SHIFT_BB_DBG_SEL_AFE_SDM)
#define BIT_CLEAR_BB_DBG_SEL_AFE_SDM(x) ((x) & (~BITS_BB_DBG_SEL_AFE_SDM))
#define BIT_GET_BB_DBG_SEL_AFE_SDM(x)                                          \
	(((x) >> BIT_SHIFT_BB_DBG_SEL_AFE_SDM) & BIT_MASK_BB_DBG_SEL_AFE_SDM)
#define BIT_SET_BB_DBG_SEL_AFE_SDM(x, v)                                       \
	(BIT_CLEAR_BB_DBG_SEL_AFE_SDM(x) | BIT_BB_DBG_SEL_AFE_SDM(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDM_DEBUG				(Offset 0x006C) */

#define BIT_SHIFT_WLCLK_PHASE 0
#define BIT_MASK_WLCLK_PHASE 0x1f
#define BIT_WLCLK_PHASE(x)                                                     \
	(((x) & BIT_MASK_WLCLK_PHASE) << BIT_SHIFT_WLCLK_PHASE)
#define BITS_WLCLK_PHASE (BIT_MASK_WLCLK_PHASE << BIT_SHIFT_WLCLK_PHASE)
#define BIT_CLEAR_WLCLK_PHASE(x) ((x) & (~BITS_WLCLK_PHASE))
#define BIT_GET_WLCLK_PHASE(x)                                                 \
	(((x) >> BIT_SHIFT_WLCLK_PHASE) & BIT_MASK_WLCLK_PHASE)
#define BIT_SET_WLCLK_PHASE(x, v)                                              \
	(BIT_CLEAR_WLCLK_PHASE(x) | BIT_WLCLK_PHASE(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_GSSR				(Offset 0x006C) */

#define BIT_SHIFT_GPIO_15_TO_0_EN 0
#define BIT_MASK_GPIO_15_TO_0_EN 0xffff
#define BIT_GPIO_15_TO_0_EN(x)                                                 \
	(((x) & BIT_MASK_GPIO_15_TO_0_EN) << BIT_SHIFT_GPIO_15_TO_0_EN)
#define BITS_GPIO_15_TO_0_EN                                                   \
	(BIT_MASK_GPIO_15_TO_0_EN << BIT_SHIFT_GPIO_15_TO_0_EN)
#define BIT_CLEAR_GPIO_15_TO_0_EN(x) ((x) & (~BITS_GPIO_15_TO_0_EN))
#define BIT_GET_GPIO_15_TO_0_EN(x)                                             \
	(((x) >> BIT_SHIFT_GPIO_15_TO_0_EN) & BIT_MASK_GPIO_15_TO_0_EN)
#define BIT_SET_GPIO_15_TO_0_EN(x, v)                                          \
	(BIT_CLEAR_GPIO_15_TO_0_EN(x) | BIT_GPIO_15_TO_0_EN(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_SDIO_CTRL			(Offset 0x0070) */

#define BIT_FORCE_RST_PCIE_APHY BIT(30)
#define BIT_FORCE_OFF_EPC BIT(29)
#define BIT_PTA_3W_MODE BIT(28)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_CLKR				(Offset 0x0070) */

#define BIT_BBRSTB_STANDBY_V1 BIT(28)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SYS_SDIO_CTRL			(Offset 0x0070) */

#define BIT_DBG_GNT_WL_BT BIT(27)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_CLKR				(Offset 0x0070) */

#define BIT_AFE_PORT3_ISO BIT(27)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SYS_SDIO_CTRL			(Offset 0x0070) */

#define BIT_LTE_MUX_CTRL_PATH BIT(26)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_CLKR				(Offset 0x0070) */

#define BIT_AFE_PORT2_ISO BIT(26)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_SDIO_CTRL			(Offset 0x0070) */

#define BIT_LTE_COEX_EN BIT(25)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SYS_SDIO_CTRL			(Offset 0x0070) */

#define BIT_LTE_COEX_UART BIT(25)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_CLKR				(Offset 0x0070) */

#define BIT_AFE_PORT1_ISO BIT(25)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_SDIO_CTRL			(Offset 0x0070) */

#define BIT_3W_LTE_GPIO_EN BIT(24)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SYS_SDIO_CTRL			(Offset 0x0070) */

#define BIT_3W_LTE_WL_GPIO BIT(24)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_CLKR				(Offset 0x0070) */

#define BIT_AFE_PORT0_ISO BIT(24)
#define BIT_USB_PWR_OFF_SEL BIT(23)
#define BIT_USB_HOST_PWR_OFF_EN_V1 BIT(22)
#define BIT_SYM_LPS_BLOCK_EN_V1 BIT(21)
#define BIT_USB_LPM_ACT_EN_V1 BIT(20)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SYS_SDIO_CTRL			(Offset 0x0070) */

#define BIT_SDIO_INT_POLARITY BIT(19)
#define BIT_SDIO_INT BIT(18)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_SDIO_CTRL			(Offset 0x0070) */

#define BIT_SDIO_OFF_EN BIT(17)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_CLKR				(Offset 0x0070) */

#define BIT_SDIO_OFF_EN_V1 BIT(17)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_SDIO_CTRL			(Offset 0x0070) */

#define BIT_SDIO_ON_EN BIT(16)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_CLKR				(Offset 0x0070) */

#define BIT_SDIO_ON_EN_V1 BIT(16)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SYS_SDIO_CTRL			(Offset 0x0070) */

#define BIT_PCIE_FORCE_PWR_NGAT BIT(13)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_CLKR				(Offset 0x0070) */

#define BIT_DIS_U3MB_INU2 BIT(13)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SYS_SDIO_CTRL			(Offset 0x0070) */

#define BIT_PCIE_CALIB_EN_V1 BIT(12)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_CLKR				(Offset 0x0070) */

#define BIT_USB3_MDIO_EN BIT(12)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SYS_SDIO_CTRL			(Offset 0x0070) */

#define BIT_PAGE3_AUXCLK_GATE BIT(11)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_CLKR				(Offset 0x0070) */

#define BIT_USB3_BG_EN BIT(11)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SYS_SDIO_CTRL			(Offset 0x0070) */

#define BIT_PCIE_WAIT_TIMEOUT_EVENT BIT(10)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_CLKR				(Offset 0x0070) */

#define BIT_USB3_MB_EN BIT(10)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SYS_SDIO_CTRL			(Offset 0x0070) */

#define BIT_PCIE_WAIT_TIME BIT(9)
#define BIT_MPCIE_REFCLK_XTAL_SEL BIT(8)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_CLKR				(Offset 0x0070) */

#define BIT_SHIFT_USB3_CK_MD 8
#define BIT_MASK_USB3_CK_MD 0x3
#define BIT_USB3_CK_MD(x) (((x) & BIT_MASK_USB3_CK_MD) << BIT_SHIFT_USB3_CK_MD)
#define BITS_USB3_CK_MD (BIT_MASK_USB3_CK_MD << BIT_SHIFT_USB3_CK_MD)
#define BIT_CLEAR_USB3_CK_MD(x) ((x) & (~BITS_USB3_CK_MD))
#define BIT_GET_USB3_CK_MD(x)                                                  \
	(((x) >> BIT_SHIFT_USB3_CK_MD) & BIT_MASK_USB3_CK_MD)
#define BIT_SET_USB3_CK_MD(x, v) (BIT_CLEAR_USB3_CK_MD(x) | BIT_USB3_CK_MD(v))

#define BIT_USB3_CKBUF BIT(7)
#define BIT_USB3_IBX_EN BIT(6)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_SYS_SDIO_CTRL			(Offset 0x0070) */

#define BIT_BT_CLKREQ_EN BIT(6)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SYS_SDIO_CTRL			(Offset 0x0070) */

#define BIT_BT_CTRL_USB_PWR_BACKDOOR BIT(5)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_CLKR				(Offset 0x0070) */

#define BIT_U3_MB_MASK BIT(5)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SYS_SDIO_CTRL			(Offset 0x0070) */

#define BIT_USB_D_STATE_HOLD BIT(4)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_CLKR				(Offset 0x0070) */

#define BIT_U3_BG_MASK BIT(4)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_SYS_SDIO_CTRL			(Offset 0x0070) */

#define BIT_SHIFT_USB_CKREF_CML_R 4
#define BIT_MASK_USB_CKREF_CML_R 0x3
#define BIT_USB_CKREF_CML_R(x)                                                 \
	(((x) & BIT_MASK_USB_CKREF_CML_R) << BIT_SHIFT_USB_CKREF_CML_R)
#define BITS_USB_CKREF_CML_R                                                   \
	(BIT_MASK_USB_CKREF_CML_R << BIT_SHIFT_USB_CKREF_CML_R)
#define BIT_CLEAR_USB_CKREF_CML_R(x) ((x) & (~BITS_USB_CKREF_CML_R))
#define BIT_GET_USB_CKREF_CML_R(x)                                             \
	(((x) >> BIT_SHIFT_USB_CKREF_CML_R) & BIT_MASK_USB_CKREF_CML_R)
#define BIT_SET_USB_CKREF_CML_R(x, v)                                          \
	(BIT_CLEAR_USB_CKREF_CML_R(x) | BIT_USB_CKREF_CML_R(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SYS_SDIO_CTRL			(Offset 0x0070) */

#define BIT_REG_FORCE_DP BIT(3)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_CLKR				(Offset 0x0070) */

#define BIT_DIS_USB3_MB_POLLING BIT(3)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_SDIO_CTRL			(Offset 0x0070) */

#define BIT_BTGP_CLKREQ_EN BIT(2)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SYS_SDIO_CTRL			(Offset 0x0070) */

#define BIT_REG_DP_MODE BIT(2)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_CLKR				(Offset 0x0070) */

#define BIT_PDN_MASK BIT(2)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_SYS_SDIO_CTRL			(Offset 0x0070) */

#define BIT_SHIFT_USB_CKREF_D2S_I 2
#define BIT_MASK_USB_CKREF_D2S_I 0x3
#define BIT_USB_CKREF_D2S_I(x)                                                 \
	(((x) & BIT_MASK_USB_CKREF_D2S_I) << BIT_SHIFT_USB_CKREF_D2S_I)
#define BITS_USB_CKREF_D2S_I                                                   \
	(BIT_MASK_USB_CKREF_D2S_I << BIT_SHIFT_USB_CKREF_D2S_I)
#define BIT_CLEAR_USB_CKREF_D2S_I(x) ((x) & (~BITS_USB_CKREF_D2S_I))
#define BIT_GET_USB_CKREF_D2S_I(x)                                             \
	(((x) >> BIT_SHIFT_USB_CKREF_D2S_I) & BIT_MASK_USB_CKREF_D2S_I)
#define BIT_SET_USB_CKREF_D2S_I(x, v)                                          \
	(BIT_CLEAR_USB_CKREF_D2S_I(x) | BIT_USB_CKREF_D2S_I(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_SDIO_CTRL			(Offset 0x0070) */

#define BIT_USB_INSTALL_EN BIT(1)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SYS_SDIO_CTRL			(Offset 0x0070) */

#define BIT_RES_USB_MASS_STORAGE_DESC BIT(1)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_CLKR				(Offset 0x0070) */

#define BIT_NO_PDN_CHIPOFF BIT(1)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_SDIO_CTRL			(Offset 0x0070) */

#define BIT_USB_BT_CLKSEL BIT(0)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SYS_SDIO_CTRL			(Offset 0x0070) */

#define BIT_USB_WAIT_TIME BIT(0)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_CLKR				(Offset 0x0070) */

#define BIT_PDN_HCOUNT BIT(0)

#endif

#if (HALMAC_8822B_SUPPORT)

/* 2 REG_SYS_SDIO_CTRL			(Offset 0x0070) */

#define BIT_SHIFT_SI_AUTHORIZATION 0
#define BIT_MASK_SI_AUTHORIZATION 0xff
#define BIT_SI_AUTHORIZATION(x)                                                \
	(((x) & BIT_MASK_SI_AUTHORIZATION) << BIT_SHIFT_SI_AUTHORIZATION)
#define BITS_SI_AUTHORIZATION                                                  \
	(BIT_MASK_SI_AUTHORIZATION << BIT_SHIFT_SI_AUTHORIZATION)
#define BIT_CLEAR_SI_AUTHORIZATION(x) ((x) & (~BITS_SI_AUTHORIZATION))
#define BIT_GET_SI_AUTHORIZATION(x)                                            \
	(((x) >> BIT_SHIFT_SI_AUTHORIZATION) & BIT_MASK_SI_AUTHORIZATION)
#define BIT_SET_SI_AUTHORIZATION(x, v)                                         \
	(BIT_CLEAR_SI_AUTHORIZATION(x) | BIT_SI_AUTHORIZATION(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_SHIFT_HCI_RATIO 30
#define BIT_MASK_HCI_RATIO 0x3
#define BIT_HCI_RATIO(x) (((x) & BIT_MASK_HCI_RATIO) << BIT_SHIFT_HCI_RATIO)
#define BITS_HCI_RATIO (BIT_MASK_HCI_RATIO << BIT_SHIFT_HCI_RATIO)
#define BIT_CLEAR_HCI_RATIO(x) ((x) & (~BITS_HCI_RATIO))
#define BIT_GET_HCI_RATIO(x) (((x) >> BIT_SHIFT_HCI_RATIO) & BIT_MASK_HCI_RATIO)
#define BIT_SET_HCI_RATIO(x, v) (BIT_CLEAR_HCI_RATIO(x) | BIT_HCI_RATIO(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_SHIFT_TSFT_SEL 29
#define BIT_MASK_TSFT_SEL 0x7
#define BIT_TSFT_SEL(x) (((x) & BIT_MASK_TSFT_SEL) << BIT_SHIFT_TSFT_SEL)
#define BITS_TSFT_SEL (BIT_MASK_TSFT_SEL << BIT_SHIFT_TSFT_SEL)
#define BIT_CLEAR_TSFT_SEL(x) ((x) & (~BITS_TSFT_SEL))
#define BIT_GET_TSFT_SEL(x) (((x) >> BIT_SHIFT_TSFT_SEL) & BIT_MASK_TSFT_SEL)
#define BIT_SET_TSFT_SEL(x, v) (BIT_CLEAR_TSFT_SEL(x) | BIT_TSFT_SEL(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_SHIFT_WAIT_HPOW_TIME 28
#define BIT_MASK_WAIT_HPOW_TIME 0x3
#define BIT_WAIT_HPOW_TIME(x)                                                  \
	(((x) & BIT_MASK_WAIT_HPOW_TIME) << BIT_SHIFT_WAIT_HPOW_TIME)
#define BITS_WAIT_HPOW_TIME                                                    \
	(BIT_MASK_WAIT_HPOW_TIME << BIT_SHIFT_WAIT_HPOW_TIME)
#define BIT_CLEAR_WAIT_HPOW_TIME(x) ((x) & (~BITS_WAIT_HPOW_TIME))
#define BIT_GET_WAIT_HPOW_TIME(x)                                              \
	(((x) >> BIT_SHIFT_WAIT_HPOW_TIME) & BIT_MASK_WAIT_HPOW_TIME)
#define BIT_SET_WAIT_HPOW_TIME(x, v)                                           \
	(BIT_CLEAR_WAIT_HPOW_TIME(x) | BIT_WAIT_HPOW_TIME(v))

#endif

#if (HALMAC_8814AMP_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_SHIFT_XTAL_SEL_0_V1 28
#define BIT_MASK_XTAL_SEL_0_V1 0xf
#define BIT_XTAL_SEL_0_V1(x)                                                   \
	(((x) & BIT_MASK_XTAL_SEL_0_V1) << BIT_SHIFT_XTAL_SEL_0_V1)
#define BITS_XTAL_SEL_0_V1 (BIT_MASK_XTAL_SEL_0_V1 << BIT_SHIFT_XTAL_SEL_0_V1)
#define BIT_CLEAR_XTAL_SEL_0_V1(x) ((x) & (~BITS_XTAL_SEL_0_V1))
#define BIT_GET_XTAL_SEL_0_V1(x)                                               \
	(((x) >> BIT_SHIFT_XTAL_SEL_0_V1) & BIT_MASK_XTAL_SEL_0_V1)
#define BIT_SET_XTAL_SEL_0_V1(x, v)                                            \
	(BIT_CLEAR_XTAL_SEL_0_V1(x) | BIT_XTAL_SEL_0_V1(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_TSFT_BAND_SEL BIT(28)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_PCIE_HPOW_OPT2 BIT(27)

#endif

#if (HALMAC_8814AMP_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_ISO_RFC2RF_3 BIT(27)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_PCIE_HPOW_OPT1 BIT(26)

#endif

#if (HALMAC_8814AMP_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_ISO_RFC2RF_2 BIT(26)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_PCIE_HPOW_OPT0 BIT(25)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_SHIFT_RPWM 24
#define BIT_MASK_RPWM 0xff
#define BIT_RPWM(x) (((x) & BIT_MASK_RPWM) << BIT_SHIFT_RPWM)
#define BITS_RPWM (BIT_MASK_RPWM << BIT_SHIFT_RPWM)
#define BIT_CLEAR_RPWM(x) ((x) & (~BITS_RPWM))
#define BIT_GET_RPWM(x) (((x) >> BIT_SHIFT_RPWM) & BIT_MASK_RPWM)
#define BIT_SET_RPWM(x, v) (BIT_CLEAR_RPWM(x) | BIT_RPWM(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_PCIE_EPC_ISO BIT(24)
#define BIT_PCIE_EPC_OPT BIT(23)
#define BIT_PCIE_SUS_OPT BIT(22)
#define BIT_PCIE_L1OF_OPT BIT(21)
#define BIT_PCIE_L1OF_LDOA BIT(20)
#define BIT_USB_SUS_LDOA BIT(19)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_SDIO_PAD_E5 BIT(18)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_USB_HOST_PWR_OFF_SEL BIT(13)

#endif

#if (HALMAC_8814A_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_R_FORCE_CLK_U3 BIT(13)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_USB_HOST_PWR_OFF_EN BIT(12)

#endif

#if (HALMAC_8814A_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_R_USB2_AUTOLOAD BIT(12)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_SYM_LPS_BLOCK_EN BIT(11)

#endif

#if (HALMAC_8814A_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_FORCE_U2CK BIT(11)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_USB_LPM_ACT_EN BIT(10)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_FORCE_CLK BIT(10)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_USB_LPM_NY BIT(9)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_IBX_EN_VALUE BIT(9)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_U2_FORCE BIT(9)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_USB_SUS_DIS BIT(8)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_IB_EN_VALUE BIT(8)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_U3_FORCE BIT(8)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_EN_LW_PWR BIT(6)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_SHIFT_SDIO_PAD_E 5
#define BIT_MASK_SDIO_PAD_E 0x7
#define BIT_SDIO_PAD_E(x) (((x) & BIT_MASK_SDIO_PAD_E) << BIT_SHIFT_SDIO_PAD_E)
#define BITS_SDIO_PAD_E (BIT_MASK_SDIO_PAD_E << BIT_SHIFT_SDIO_PAD_E)
#define BIT_CLEAR_SDIO_PAD_E(x) ((x) & (~BITS_SDIO_PAD_E))
#define BIT_GET_SDIO_PAD_E(x)                                                  \
	(((x) >> BIT_SHIFT_SDIO_PAD_E) & BIT_MASK_SDIO_PAD_E)
#define BIT_SET_SDIO_PAD_E(x, v) (BIT_CLEAR_SDIO_PAD_E(x) | BIT_SDIO_PAD_E(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_EN_REGU BIT(5)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_USB_LPPLL_EN BIT(4)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_FORCED_IB_EN BIT(4)
#define BIT_EN_PC BIT(4)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_SDIO_H3L1 BIT(4)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_PERST_SYNC_EN BIT(3)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_USB1_1_USB2_0_DECISION BIT(3)
#define BIT_EN_REGBG BIT(3)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_ROP_SW15 BIT(2)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_REG_BG_LPF BIT(2)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_SHIFT_USB23_SW_MODE 2
#define BIT_MASK_USB23_SW_MODE 0x3
#define BIT_USB23_SW_MODE(x)                                                   \
	(((x) & BIT_MASK_USB23_SW_MODE) << BIT_SHIFT_USB23_SW_MODE)
#define BITS_USB23_SW_MODE (BIT_MASK_USB23_SW_MODE << BIT_SHIFT_USB23_SW_MODE)
#define BIT_CLEAR_USB23_SW_MODE(x) ((x) & (~BITS_USB23_SW_MODE))
#define BIT_GET_USB23_SW_MODE(x)                                               \
	(((x) >> BIT_SHIFT_USB23_SW_MODE) & BIT_MASK_USB23_SW_MODE)
#define BIT_SET_USB23_SW_MODE(x, v)                                            \
	(BIT_CLEAR_USB23_SW_MODE(x) | BIT_USB23_SW_MODE(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_PCI_CKRDY_OPT BIT(1)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_PCLK_VLD_SEL BIT(1)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_PCI_VAUX_EN BIT(0)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_SHIFT_REG_BG 0
#define BIT_MASK_REG_BG 0x3
#define BIT_REG_BG(x) (((x) & BIT_MASK_REG_BG) << BIT_SHIFT_REG_BG)
#define BITS_REG_BG (BIT_MASK_REG_BG << BIT_SHIFT_REG_BG)
#define BIT_CLEAR_REG_BG(x) ((x) & (~BITS_REG_BG))
#define BIT_GET_REG_BG(x) (((x) >> BIT_SHIFT_REG_BG) & BIT_MASK_REG_BG)
#define BIT_SET_REG_BG(x, v) (BIT_CLEAR_REG_BG(x) | BIT_REG_BG(v))

#define BIT_SHIFT_REG_VADJ 0
#define BIT_MASK_REG_VADJ 0xf
#define BIT_REG_VADJ(x) (((x) & BIT_MASK_REG_VADJ) << BIT_SHIFT_REG_VADJ)
#define BITS_REG_VADJ (BIT_MASK_REG_VADJ << BIT_SHIFT_REG_VADJ)
#define BIT_CLEAR_REG_VADJ(x) ((x) & (~BITS_REG_VADJ))
#define BIT_GET_REG_VADJ(x) (((x) >> BIT_SHIFT_REG_VADJ) & BIT_MASK_REG_VADJ)
#define BIT_SET_REG_VADJ(x, v) (BIT_CLEAR_REG_VADJ(x) | BIT_REG_VADJ(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_HCI_OPT_CTRL			(Offset 0x0074) */

#define BIT_VAUX_EN BIT(0)

/* 2 REG_AFE_XTAL_CTRL_EXT			(Offset 0x0078) */

#define BIT_SDM_ORDER BIT(30)
#define BIT_XTAL_DRV_RF_LATCH_V1 BIT(29)
#define BIT_XTAL_VDD_SEL_V1 BIT(28)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL4				(Offset 0x0078) */

#define BIT_XTAL_DRV_RF_LATCH BIT(27)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_XTAL_CTRL_EXT			(Offset 0x0078) */

#define BIT_XQSEL_RF_AWAKE_V1 BIT(27)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL4				(Offset 0x0078) */

#define BIT_XTAL_VDD_SEL BIT(26)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT)

/* 2 REG_AFE_CTRL4				(Offset 0x0078) */

#define BIT_RF1_SDMRSTB BIT(26)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_XTAL_CTRL_EXT			(Offset 0x0078) */

#define BIT_GATED_XTAL_OK0_V1 BIT(26)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_AFE_CTRL4				(Offset 0x0078) */

#define BIT_XQSEL_RF BIT(25)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT)

/* 2 REG_AFE_CTRL4				(Offset 0x0078) */

#define BIT_RF1_RSTB BIT(25)

#endif

#if (HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL4				(Offset 0x0078) */

#define BIT_XQSEL_RF_AWAKE BIT(25)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_AFE_CTRL4				(Offset 0x0078) */

#define BIT_XQSEL_RF_INITIAL BIT(24)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT)

/* 2 REG_AFE_CTRL4				(Offset 0x0078) */

#define BIT_RF1_EN BIT(24)

#endif

#if (HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL4				(Offset 0x0078) */

#define BIT_XQSEL_BIT1 BIT(24)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_AFE_CTRL4				(Offset 0x0078) */

#define BIT_REG_VREF_SEL BIT(23)

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_AFE_CTRL4				(Offset 0x0078) */

#define BIT_DITHER_SDM_BIT3 BIT(23)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_XTAL_CTRL_EXT			(Offset 0x0078) */

#define BIT_SHIFT_F0N_2_TO_0 23
#define BIT_MASK_F0N_2_TO_0 0x7
#define BIT_F0N_2_TO_0(x) (((x) & BIT_MASK_F0N_2_TO_0) << BIT_SHIFT_F0N_2_TO_0)
#define BITS_F0N_2_TO_0 (BIT_MASK_F0N_2_TO_0 << BIT_SHIFT_F0N_2_TO_0)
#define BIT_CLEAR_F0N_2_TO_0(x) ((x) & (~BITS_F0N_2_TO_0))
#define BIT_GET_F0N_2_TO_0(x)                                                  \
	(((x) >> BIT_SHIFT_F0N_2_TO_0) & BIT_MASK_F0N_2_TO_0)
#define BIT_SET_F0N_2_TO_0(x, v) (BIT_CLEAR_F0N_2_TO_0(x) | BIT_F0N_2_TO_0(v))

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_AFE_CTRL4				(Offset 0x0078) */

#define BIT_REG_LPFEN BIT(22)
#define BIT_REG_KVCO BIT(21)
#define BIT_XTAL_DRV_AGPIO_BIT1 BIT(20)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT)

/* 2 REG_AFE_CTRL4				(Offset 0x0078) */

#define BIT_SHIFT_XTAL_LDO 20
#define BIT_MASK_XTAL_LDO 0x7
#define BIT_XTAL_LDO(x) (((x) & BIT_MASK_XTAL_LDO) << BIT_SHIFT_XTAL_LDO)
#define BITS_XTAL_LDO (BIT_MASK_XTAL_LDO << BIT_SHIFT_XTAL_LDO)
#define BIT_CLEAR_XTAL_LDO(x) ((x) & (~BITS_XTAL_LDO))
#define BIT_GET_XTAL_LDO(x) (((x) >> BIT_SHIFT_XTAL_LDO) & BIT_MASK_XTAL_LDO)
#define BIT_SET_XTAL_LDO(x, v) (BIT_CLEAR_XTAL_LDO(x) | BIT_XTAL_LDO(v))

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_AFE_CTRL4				(Offset 0x0078) */

#define BIT_XTAL_DRV_AGPIO_BIT0 BIT(19)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL4				(Offset 0x0078) */

#define BIT_XTAL_GRF2 BIT(18)
#define BIT_REG_REF_SEL BIT(17)
#define BIT_REG_320_SEL BIT(16)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT)

/* 2 REG_AFE_CTRL4				(Offset 0x0078) */

#define BIT_ADC_CK_SYNC_EN BIT(16)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL4				(Offset 0x0078) */

#define BIT_EN_SYM BIT(15)

#define BIT_SHIFT_IOFFSET 10
#define BIT_MASK_IOFFSET 0x1f
#define BIT_IOFFSET(x) (((x) & BIT_MASK_IOFFSET) << BIT_SHIFT_IOFFSET)
#define BITS_IOFFSET (BIT_MASK_IOFFSET << BIT_SHIFT_IOFFSET)
#define BIT_CLEAR_IOFFSET(x) ((x) & (~BITS_IOFFSET))
#define BIT_GET_IOFFSET(x) (((x) >> BIT_SHIFT_IOFFSET) & BIT_MASK_IOFFSET)
#define BIT_SET_IOFFSET(x, v) (BIT_CLEAR_IOFFSET(x) | BIT_IOFFSET(v))

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_AFE_CTRL4				(Offset 0x0078) */

#define BIT_RF2_SDMRSTB BIT(10)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_XTAL_CTRL_EXT			(Offset 0x0078) */

#define BIT_SHIFT_F0F_12_TO_0 10
#define BIT_MASK_F0F_12_TO_0 0x1fff
#define BIT_F0F_12_TO_0(x)                                                     \
	(((x) & BIT_MASK_F0F_12_TO_0) << BIT_SHIFT_F0F_12_TO_0)
#define BITS_F0F_12_TO_0 (BIT_MASK_F0F_12_TO_0 << BIT_SHIFT_F0F_12_TO_0)
#define BIT_CLEAR_F0F_12_TO_0(x) ((x) & (~BITS_F0F_12_TO_0))
#define BIT_GET_F0F_12_TO_0(x)                                                 \
	(((x) >> BIT_SHIFT_F0F_12_TO_0) & BIT_MASK_F0F_12_TO_0)
#define BIT_SET_F0F_12_TO_0(x, v)                                              \
	(BIT_CLEAR_F0F_12_TO_0(x) | BIT_F0F_12_TO_0(v))

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_AFE_CTRL4				(Offset 0x0078) */

#define BIT_RF2_RSTB BIT(9)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL4				(Offset 0x0078) */

#define BIT_SHIFT_APLL_FREF_SEL_BIT_2_TO_1 8
#define BIT_MASK_APLL_FREF_SEL_BIT_2_TO_1 0x3
#define BIT_APLL_FREF_SEL_BIT_2_TO_1(x)                                        \
	(((x) & BIT_MASK_APLL_FREF_SEL_BIT_2_TO_1)                             \
	 << BIT_SHIFT_APLL_FREF_SEL_BIT_2_TO_1)
#define BITS_APLL_FREF_SEL_BIT_2_TO_1                                          \
	(BIT_MASK_APLL_FREF_SEL_BIT_2_TO_1                                     \
	 << BIT_SHIFT_APLL_FREF_SEL_BIT_2_TO_1)
#define BIT_CLEAR_APLL_FREF_SEL_BIT_2_TO_1(x)                                  \
	((x) & (~BITS_APLL_FREF_SEL_BIT_2_TO_1))
#define BIT_GET_APLL_FREF_SEL_BIT_2_TO_1(x)                                    \
	(((x) >> BIT_SHIFT_APLL_FREF_SEL_BIT_2_TO_1) &                         \
	 BIT_MASK_APLL_FREF_SEL_BIT_2_TO_1)
#define BIT_SET_APLL_FREF_SEL_BIT_2_TO_1(x, v)                                 \
	(BIT_CLEAR_APLL_FREF_SEL_BIT_2_TO_1(x) |                               \
	 BIT_APLL_FREF_SEL_BIT_2_TO_1(v))

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_AFE_CTRL4				(Offset 0x0078) */

#define BIT_RF2_EN BIT(8)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL4				(Offset 0x0078) */

#define BIT_APLL_FREF_SEL_BIT3 BIT(7)

#define BIT_SHIFT_APLL_LDO_V12ADJ 5
#define BIT_MASK_APLL_LDO_V12ADJ 0x3
#define BIT_APLL_LDO_V12ADJ(x)                                                 \
	(((x) & BIT_MASK_APLL_LDO_V12ADJ) << BIT_SHIFT_APLL_LDO_V12ADJ)
#define BITS_APLL_LDO_V12ADJ                                                   \
	(BIT_MASK_APLL_LDO_V12ADJ << BIT_SHIFT_APLL_LDO_V12ADJ)
#define BIT_CLEAR_APLL_LDO_V12ADJ(x) ((x) & (~BITS_APLL_LDO_V12ADJ))
#define BIT_GET_APLL_LDO_V12ADJ(x)                                             \
	(((x) >> BIT_SHIFT_APLL_LDO_V12ADJ) & BIT_MASK_APLL_LDO_V12ADJ)
#define BIT_SET_APLL_LDO_V12ADJ(x, v)                                          \
	(BIT_CLEAR_APLL_LDO_V12ADJ(x) | BIT_APLL_LDO_V12ADJ(v))

#define BIT_APLL_160_GATEB BIT(4)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_XTAL_CTRL_EXT			(Offset 0x0078) */

#define BIT_SHIFT_DIVN_5_TO_0 4
#define BIT_MASK_DIVN_5_TO_0 0x3f
#define BIT_DIVN_5_TO_0(x)                                                     \
	(((x) & BIT_MASK_DIVN_5_TO_0) << BIT_SHIFT_DIVN_5_TO_0)
#define BITS_DIVN_5_TO_0 (BIT_MASK_DIVN_5_TO_0 << BIT_SHIFT_DIVN_5_TO_0)
#define BIT_CLEAR_DIVN_5_TO_0(x) ((x) & (~BITS_DIVN_5_TO_0))
#define BIT_GET_DIVN_5_TO_0(x)                                                 \
	(((x) >> BIT_SHIFT_DIVN_5_TO_0) & BIT_MASK_DIVN_5_TO_0)
#define BIT_SET_DIVN_5_TO_0(x, v)                                              \
	(BIT_CLEAR_DIVN_5_TO_0(x) | BIT_DIVN_5_TO_0(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL4				(Offset 0x0078) */

#define BIT_AFE_DUMMY BIT(3)
#define BIT_REG_IDOUBLE BIT(2)

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_AFE_CTRL4				(Offset 0x0078) */

#define BIT_RF3_SDMRSTB BIT(2)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL4				(Offset 0x0078) */

#define BIT_REG_VCO_BIAS_BIT0 BIT(1)

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_AFE_CTRL4				(Offset 0x0078) */

#define BIT_RF3_RSTB BIT(1)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AFE_CTRL4				(Offset 0x0078) */

#define BIT_REG_VCO_BIAS_BIT1 BIT(0)

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_AFE_CTRL4				(Offset 0x0078) */

#define BIT_RF3_EN BIT(0)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_AFE_XTAL_CTRL_EXT			(Offset 0x0078) */

#define BIT_SHIFT_BB_DBG_SEL_AFE_SDM_3_TO_0 0
#define BIT_MASK_BB_DBG_SEL_AFE_SDM_3_TO_0 0xf
#define BIT_BB_DBG_SEL_AFE_SDM_3_TO_0(x)                                       \
	(((x) & BIT_MASK_BB_DBG_SEL_AFE_SDM_3_TO_0)                            \
	 << BIT_SHIFT_BB_DBG_SEL_AFE_SDM_3_TO_0)
#define BITS_BB_DBG_SEL_AFE_SDM_3_TO_0                                         \
	(BIT_MASK_BB_DBG_SEL_AFE_SDM_3_TO_0                                    \
	 << BIT_SHIFT_BB_DBG_SEL_AFE_SDM_3_TO_0)
#define BIT_CLEAR_BB_DBG_SEL_AFE_SDM_3_TO_0(x)                                 \
	((x) & (~BITS_BB_DBG_SEL_AFE_SDM_3_TO_0))
#define BIT_GET_BB_DBG_SEL_AFE_SDM_3_TO_0(x)                                   \
	(((x) >> BIT_SHIFT_BB_DBG_SEL_AFE_SDM_3_TO_0) &                        \
	 BIT_MASK_BB_DBG_SEL_AFE_SDM_3_TO_0)
#define BIT_SET_BB_DBG_SEL_AFE_SDM_3_TO_0(x, v)                                \
	(BIT_CLEAR_BB_DBG_SEL_AFE_SDM_3_TO_0(x) |                              \
	 BIT_BB_DBG_SEL_AFE_SDM_3_TO_0(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_LDO_SWR_CTRL			(Offset 0x007C) */

#define BIT_SPS_EN_DIODE BIT(31)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_LDO_SWR_CTRL			(Offset 0x007C) */

#define BIT_EXT_SWR_CTRL_EN BIT(31)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_LDO_SWR_CTRL			(Offset 0x007C) */

#define BIT_REF_FREF_EDGE BIT(29)
#define BIT_REG_VREF_SEL_V1 BIT(28)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_LDO_SWR_CTRL			(Offset 0x007C) */

#define BIT_ZCD_HW_AUTO_EN BIT(27)
#define BIT_ZCD_REGSEL BIT(26)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_LDO_SWR_CTRL			(Offset 0x007C) */

#define BIT_SHIFT_REG_CP_OFFSET_4_TO_0 23
#define BIT_MASK_REG_CP_OFFSET_4_TO_0 0x1f
#define BIT_REG_CP_OFFSET_4_TO_0(x)                                            \
	(((x) & BIT_MASK_REG_CP_OFFSET_4_TO_0)                                 \
	 << BIT_SHIFT_REG_CP_OFFSET_4_TO_0)
#define BITS_REG_CP_OFFSET_4_TO_0                                              \
	(BIT_MASK_REG_CP_OFFSET_4_TO_0 << BIT_SHIFT_REG_CP_OFFSET_4_TO_0)
#define BIT_CLEAR_REG_CP_OFFSET_4_TO_0(x) ((x) & (~BITS_REG_CP_OFFSET_4_TO_0))
#define BIT_GET_REG_CP_OFFSET_4_TO_0(x)                                        \
	(((x) >> BIT_SHIFT_REG_CP_OFFSET_4_TO_0) &                             \
	 BIT_MASK_REG_CP_OFFSET_4_TO_0)
#define BIT_SET_REG_CP_OFFSET_4_TO_0(x, v)                                     \
	(BIT_CLEAR_REG_CP_OFFSET_4_TO_0(x) | BIT_REG_CP_OFFSET_4_TO_0(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_LDO_SWR_CTRL			(Offset 0x007C) */

#define BIT_SHIFT_AUTO_ZCD_IN_CODE 21
#define BIT_MASK_AUTO_ZCD_IN_CODE 0x1f
#define BIT_AUTO_ZCD_IN_CODE(x)                                                \
	(((x) & BIT_MASK_AUTO_ZCD_IN_CODE) << BIT_SHIFT_AUTO_ZCD_IN_CODE)
#define BITS_AUTO_ZCD_IN_CODE                                                  \
	(BIT_MASK_AUTO_ZCD_IN_CODE << BIT_SHIFT_AUTO_ZCD_IN_CODE)
#define BIT_CLEAR_AUTO_ZCD_IN_CODE(x) ((x) & (~BITS_AUTO_ZCD_IN_CODE))
#define BIT_GET_AUTO_ZCD_IN_CODE(x)                                            \
	(((x) >> BIT_SHIFT_AUTO_ZCD_IN_CODE) & BIT_MASK_AUTO_ZCD_IN_CODE)
#define BIT_SET_AUTO_ZCD_IN_CODE(x, v)                                         \
	(BIT_CLEAR_AUTO_ZCD_IN_CODE(x) | BIT_AUTO_ZCD_IN_CODE(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_LDO_SWR_CTRL			(Offset 0x007C) */

#define BIT_SHIFT_REG_RS_SET_2_TO_0 20
#define BIT_MASK_REG_RS_SET_2_TO_0 0x7
#define BIT_REG_RS_SET_2_TO_0(x)                                               \
	(((x) & BIT_MASK_REG_RS_SET_2_TO_0) << BIT_SHIFT_REG_RS_SET_2_TO_0)
#define BITS_REG_RS_SET_2_TO_0                                                 \
	(BIT_MASK_REG_RS_SET_2_TO_0 << BIT_SHIFT_REG_RS_SET_2_TO_0)
#define BIT_CLEAR_REG_RS_SET_2_TO_0(x) ((x) & (~BITS_REG_RS_SET_2_TO_0))
#define BIT_GET_REG_RS_SET_2_TO_0(x)                                           \
	(((x) >> BIT_SHIFT_REG_RS_SET_2_TO_0) & BIT_MASK_REG_RS_SET_2_TO_0)
#define BIT_SET_REG_RS_SET_2_TO_0(x, v)                                        \
	(BIT_CLEAR_REG_RS_SET_2_TO_0(x) | BIT_REG_RS_SET_2_TO_0(v))

#define BIT_SHIFT_REG_CS_SET_1_TO_0 18
#define BIT_MASK_REG_CS_SET_1_TO_0 0x3
#define BIT_REG_CS_SET_1_TO_0(x)                                               \
	(((x) & BIT_MASK_REG_CS_SET_1_TO_0) << BIT_SHIFT_REG_CS_SET_1_TO_0)
#define BITS_REG_CS_SET_1_TO_0                                                 \
	(BIT_MASK_REG_CS_SET_1_TO_0 << BIT_SHIFT_REG_CS_SET_1_TO_0)
#define BIT_CLEAR_REG_CS_SET_1_TO_0(x) ((x) & (~BITS_REG_CS_SET_1_TO_0))
#define BIT_GET_REG_CS_SET_1_TO_0(x)                                           \
	(((x) >> BIT_SHIFT_REG_CS_SET_1_TO_0) & BIT_MASK_REG_CS_SET_1_TO_0)
#define BIT_SET_REG_CS_SET_1_TO_0(x, v)                                        \
	(BIT_CLEAR_REG_CS_SET_1_TO_0(x) | BIT_REG_CS_SET_1_TO_0(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_LDO_SWR_CTRL			(Offset 0x007C) */

#define BIT_SHIFT_ZCD_CODE_IN_L 16
#define BIT_MASK_ZCD_CODE_IN_L 0x1f
#define BIT_ZCD_CODE_IN_L(x)                                                   \
	(((x) & BIT_MASK_ZCD_CODE_IN_L) << BIT_SHIFT_ZCD_CODE_IN_L)
#define BITS_ZCD_CODE_IN_L (BIT_MASK_ZCD_CODE_IN_L << BIT_SHIFT_ZCD_CODE_IN_L)
#define BIT_CLEAR_ZCD_CODE_IN_L(x) ((x) & (~BITS_ZCD_CODE_IN_L))
#define BIT_GET_ZCD_CODE_IN_L(x)                                               \
	(((x) >> BIT_SHIFT_ZCD_CODE_IN_L) & BIT_MASK_ZCD_CODE_IN_L)
#define BIT_SET_ZCD_CODE_IN_L(x, v)                                            \
	(BIT_CLEAR_ZCD_CODE_IN_L(x) | BIT_ZCD_CODE_IN_L(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_LDO_SWR_CTRL			(Offset 0x007C) */

#define BIT_SHIFT_REG_CP_SET_1_TO_0 16
#define BIT_MASK_REG_CP_SET_1_TO_0 0x3
#define BIT_REG_CP_SET_1_TO_0(x)                                               \
	(((x) & BIT_MASK_REG_CP_SET_1_TO_0) << BIT_SHIFT_REG_CP_SET_1_TO_0)
#define BITS_REG_CP_SET_1_TO_0                                                 \
	(BIT_MASK_REG_CP_SET_1_TO_0 << BIT_SHIFT_REG_CP_SET_1_TO_0)
#define BIT_CLEAR_REG_CP_SET_1_TO_0(x) ((x) & (~BITS_REG_CP_SET_1_TO_0))
#define BIT_GET_REG_CP_SET_1_TO_0(x)                                           \
	(((x) >> BIT_SHIFT_REG_CP_SET_1_TO_0) & BIT_MASK_REG_CP_SET_1_TO_0)
#define BIT_SET_REG_CP_SET_1_TO_0(x, v)                                        \
	(BIT_CLEAR_REG_CP_SET_1_TO_0(x) | BIT_REG_CP_SET_1_TO_0(v))

#define BIT_LPFEN BIT(15)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT)

/* 2 REG_LDO_SWR_CTRL			(Offset 0x007C) */

#define BIT_SHIFT_LDO_HV5_DUMMY 14
#define BIT_MASK_LDO_HV5_DUMMY 0x3
#define BIT_LDO_HV5_DUMMY(x)                                                   \
	(((x) & BIT_MASK_LDO_HV5_DUMMY) << BIT_SHIFT_LDO_HV5_DUMMY)
#define BITS_LDO_HV5_DUMMY (BIT_MASK_LDO_HV5_DUMMY << BIT_SHIFT_LDO_HV5_DUMMY)
#define BIT_CLEAR_LDO_HV5_DUMMY(x) ((x) & (~BITS_LDO_HV5_DUMMY))
#define BIT_GET_LDO_HV5_DUMMY(x)                                               \
	(((x) >> BIT_SHIFT_LDO_HV5_DUMMY) & BIT_MASK_LDO_HV5_DUMMY)
#define BIT_SET_LDO_HV5_DUMMY(x, v)                                            \
	(BIT_CLEAR_LDO_HV5_DUMMY(x) | BIT_LDO_HV5_DUMMY(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_LDO_SWR_CTRL			(Offset 0x007C) */

#define BIT_REG_DOGENB BIT(14)
#define BIT_REG_TEST_EN BIT(13)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_LDO_SWR_CTRL			(Offset 0x007C) */

#define BIT_SHIFT_REG_VTUNE33 12
#define BIT_MASK_REG_VTUNE33 0x3
#define BIT_REG_VTUNE33(x)                                                     \
	(((x) & BIT_MASK_REG_VTUNE33) << BIT_SHIFT_REG_VTUNE33)
#define BITS_REG_VTUNE33 (BIT_MASK_REG_VTUNE33 << BIT_SHIFT_REG_VTUNE33)
#define BIT_CLEAR_REG_VTUNE33(x) ((x) & (~BITS_REG_VTUNE33))
#define BIT_GET_REG_VTUNE33(x)                                                 \
	(((x) >> BIT_SHIFT_REG_VTUNE33) & BIT_MASK_REG_VTUNE33)
#define BIT_SET_REG_VTUNE33(x, v)                                              \
	(BIT_CLEAR_REG_VTUNE33(x) | BIT_REG_VTUNE33(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_LDO_SWR_CTRL			(Offset 0x007C) */

#define BIT_SHIFT_REG_VTUNE33_BIT0_TO_BIT1 12
#define BIT_MASK_REG_VTUNE33_BIT0_TO_BIT1 0x3
#define BIT_REG_VTUNE33_BIT0_TO_BIT1(x)                                        \
	(((x) & BIT_MASK_REG_VTUNE33_BIT0_TO_BIT1)                             \
	 << BIT_SHIFT_REG_VTUNE33_BIT0_TO_BIT1)
#define BITS_REG_VTUNE33_BIT0_TO_BIT1                                          \
	(BIT_MASK_REG_VTUNE33_BIT0_TO_BIT1                                     \
	 << BIT_SHIFT_REG_VTUNE33_BIT0_TO_BIT1)
#define BIT_CLEAR_REG_VTUNE33_BIT0_TO_BIT1(x)                                  \
	((x) & (~BITS_REG_VTUNE33_BIT0_TO_BIT1))
#define BIT_GET_REG_VTUNE33_BIT0_TO_BIT1(x)                                    \
	(((x) >> BIT_SHIFT_REG_VTUNE33_BIT0_TO_BIT1) &                         \
	 BIT_MASK_REG_VTUNE33_BIT0_TO_BIT1)
#define BIT_SET_REG_VTUNE33_BIT0_TO_BIT1(x, v)                                 \
	(BIT_CLEAR_REG_VTUNE33_BIT0_TO_BIT1(x) |                               \
	 BIT_REG_VTUNE33_BIT0_TO_BIT1(v))

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_LDO_SWR_CTRL			(Offset 0x007C) */

#define BIT_SHIFT_REG_STANDBY33 10
#define BIT_MASK_REG_STANDBY33 0x3
#define BIT_REG_STANDBY33(x)                                                   \
	(((x) & BIT_MASK_REG_STANDBY33) << BIT_SHIFT_REG_STANDBY33)
#define BITS_REG_STANDBY33 (BIT_MASK_REG_STANDBY33 << BIT_SHIFT_REG_STANDBY33)
#define BIT_CLEAR_REG_STANDBY33(x) ((x) & (~BITS_REG_STANDBY33))
#define BIT_GET_REG_STANDBY33(x)                                               \
	(((x) >> BIT_SHIFT_REG_STANDBY33) & BIT_MASK_REG_STANDBY33)
#define BIT_SET_REG_STANDBY33(x, v)                                            \
	(BIT_CLEAR_REG_STANDBY33(x) | BIT_REG_STANDBY33(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_LDO_SWR_CTRL			(Offset 0x007C) */

#define BIT_SHIFT_REG_STANDBY33_BIT0_TO_BIT1 10
#define BIT_MASK_REG_STANDBY33_BIT0_TO_BIT1 0x3
#define BIT_REG_STANDBY33_BIT0_TO_BIT1(x)                                      \
	(((x) & BIT_MASK_REG_STANDBY33_BIT0_TO_BIT1)                           \
	 << BIT_SHIFT_REG_STANDBY33_BIT0_TO_BIT1)
#define BITS_REG_STANDBY33_BIT0_TO_BIT1                                        \
	(BIT_MASK_REG_STANDBY33_BIT0_TO_BIT1                                   \
	 << BIT_SHIFT_REG_STANDBY33_BIT0_TO_BIT1)
#define BIT_CLEAR_REG_STANDBY33_BIT0_TO_BIT1(x)                                \
	((x) & (~BITS_REG_STANDBY33_BIT0_TO_BIT1))
#define BIT_GET_REG_STANDBY33_BIT0_TO_BIT1(x)                                  \
	(((x) >> BIT_SHIFT_REG_STANDBY33_BIT0_TO_BIT1) &                       \
	 BIT_MASK_REG_STANDBY33_BIT0_TO_BIT1)
#define BIT_SET_REG_STANDBY33_BIT0_TO_BIT1(x, v)                               \
	(BIT_CLEAR_REG_STANDBY33_BIT0_TO_BIT1(x) |                             \
	 BIT_REG_STANDBY33_BIT0_TO_BIT1(v))

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_LDO_SWR_CTRL			(Offset 0x007C) */

#define BIT_SHIFT_REG_LOAD33 8
#define BIT_MASK_REG_LOAD33 0x3
#define BIT_REG_LOAD33(x) (((x) & BIT_MASK_REG_LOAD33) << BIT_SHIFT_REG_LOAD33)
#define BITS_REG_LOAD33 (BIT_MASK_REG_LOAD33 << BIT_SHIFT_REG_LOAD33)
#define BIT_CLEAR_REG_LOAD33(x) ((x) & (~BITS_REG_LOAD33))
#define BIT_GET_REG_LOAD33(x)                                                  \
	(((x) >> BIT_SHIFT_REG_LOAD33) & BIT_MASK_REG_LOAD33)
#define BIT_SET_REG_LOAD33(x, v) (BIT_CLEAR_REG_LOAD33(x) | BIT_REG_LOAD33(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_LDO_SWR_CTRL			(Offset 0x007C) */

#define BIT_SHIFT_REG_LOAD33_BIT0_TO_BIT1 8
#define BIT_MASK_REG_LOAD33_BIT0_TO_BIT1 0x3
#define BIT_REG_LOAD33_BIT0_TO_BIT1(x)                                         \
	(((x) & BIT_MASK_REG_LOAD33_BIT0_TO_BIT1)                              \
	 << BIT_SHIFT_REG_LOAD33_BIT0_TO_BIT1)
#define BITS_REG_LOAD33_BIT0_TO_BIT1                                           \
	(BIT_MASK_REG_LOAD33_BIT0_TO_BIT1 << BIT_SHIFT_REG_LOAD33_BIT0_TO_BIT1)
#define BIT_CLEAR_REG_LOAD33_BIT0_TO_BIT1(x)                                   \
	((x) & (~BITS_REG_LOAD33_BIT0_TO_BIT1))
#define BIT_GET_REG_LOAD33_BIT0_TO_BIT1(x)                                     \
	(((x) >> BIT_SHIFT_REG_LOAD33_BIT0_TO_BIT1) &                          \
	 BIT_MASK_REG_LOAD33_BIT0_TO_BIT1)
#define BIT_SET_REG_LOAD33_BIT0_TO_BIT1(x, v)                                  \
	(BIT_CLEAR_REG_LOAD33_BIT0_TO_BIT1(x) | BIT_REG_LOAD33_BIT0_TO_BIT1(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_LDO_SWR_CTRL			(Offset 0x007C) */

#define BIT_SHIFT_REG_DIV_SEL 8
#define BIT_MASK_REG_DIV_SEL 0x1f
#define BIT_REG_DIV_SEL(x)                                                     \
	(((x) & BIT_MASK_REG_DIV_SEL) << BIT_SHIFT_REG_DIV_SEL)
#define BITS_REG_DIV_SEL (BIT_MASK_REG_DIV_SEL << BIT_SHIFT_REG_DIV_SEL)
#define BIT_CLEAR_REG_DIV_SEL(x) ((x) & (~BITS_REG_DIV_SEL))
#define BIT_GET_REG_DIV_SEL(x)                                                 \
	(((x) >> BIT_SHIFT_REG_DIV_SEL) & BIT_MASK_REG_DIV_SEL)
#define BIT_SET_REG_DIV_SEL(x, v)                                              \
	(BIT_CLEAR_REG_DIV_SEL(x) | BIT_REG_DIV_SEL(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_LDO_SWR_CTRL			(Offset 0x007C) */

#define BIT_REG_BYPASS_L BIT(7)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_LDO_SWR_CTRL			(Offset 0x007C) */

#define BIT_EN_CK200M BIT(7)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_LDO_SWR_CTRL			(Offset 0x007C) */

#define BIT_REG_LDOF_L BIT(6)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_LDO_SWR_CTRL			(Offset 0x007C) */

#define BIT_REG_OCPS_L BIT(5)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_LDO_SWR_CTRL			(Offset 0x007C) */

#define BIT_SHIFT_REG_KVCO_200M_1_TO_0 5
#define BIT_MASK_REG_KVCO_200M_1_TO_0 0x3
#define BIT_REG_KVCO_200M_1_TO_0(x)                                            \
	(((x) & BIT_MASK_REG_KVCO_200M_1_TO_0)                                 \
	 << BIT_SHIFT_REG_KVCO_200M_1_TO_0)
#define BITS_REG_KVCO_200M_1_TO_0                                              \
	(BIT_MASK_REG_KVCO_200M_1_TO_0 << BIT_SHIFT_REG_KVCO_200M_1_TO_0)
#define BIT_CLEAR_REG_KVCO_200M_1_TO_0(x) ((x) & (~BITS_REG_KVCO_200M_1_TO_0))
#define BIT_GET_REG_KVCO_200M_1_TO_0(x)                                        \
	(((x) >> BIT_SHIFT_REG_KVCO_200M_1_TO_0) &                             \
	 BIT_MASK_REG_KVCO_200M_1_TO_0)
#define BIT_SET_REG_KVCO_200M_1_TO_0(x, v)                                     \
	(BIT_CLEAR_REG_KVCO_200M_1_TO_0(x) | BIT_REG_KVCO_200M_1_TO_0(v))

#endif

#if (HALMAC_8822B_SUPPORT)

/* 2 REG_LDO_SWR_CTRL			(Offset 0x007C) */

#define BIT_REG_TYPE_L_V1 BIT(5)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_LDO_SWR_CTRL			(Offset 0x007C) */

#define BIT_ARENB_L BIT(3)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_LDO_SWR_CTRL			(Offset 0x007C) */

#define BIT_SHIFT_REG_CP_BIAS_200M_2_TO_0 2
#define BIT_MASK_REG_CP_BIAS_200M_2_TO_0 0x7
#define BIT_REG_CP_BIAS_200M_2_TO_0(x)                                         \
	(((x) & BIT_MASK_REG_CP_BIAS_200M_2_TO_0)                              \
	 << BIT_SHIFT_REG_CP_BIAS_200M_2_TO_0)
#define BITS_REG_CP_BIAS_200M_2_TO_0                                           \
	(BIT_MASK_REG_CP_BIAS_200M_2_TO_0 << BIT_SHIFT_REG_CP_BIAS_200M_2_TO_0)
#define BIT_CLEAR_REG_CP_BIAS_200M_2_TO_0(x)                                   \
	((x) & (~BITS_REG_CP_BIAS_200M_2_TO_0))
#define BIT_GET_REG_CP_BIAS_200M_2_TO_0(x)                                     \
	(((x) >> BIT_SHIFT_REG_CP_BIAS_200M_2_TO_0) &                          \
	 BIT_MASK_REG_CP_BIAS_200M_2_TO_0)
#define BIT_SET_REG_CP_BIAS_200M_2_TO_0(x, v)                                  \
	(BIT_CLEAR_REG_CP_BIAS_200M_2_TO_0(x) | BIT_REG_CP_BIAS_200M_2_TO_0(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_LDO_SWR_CTRL			(Offset 0x007C) */

#define BIT_SHIFT_CFC_L_BIT_1_TO_0 1
#define BIT_MASK_CFC_L_BIT_1_TO_0 0x3
#define BIT_CFC_L_BIT_1_TO_0(x)                                                \
	(((x) & BIT_MASK_CFC_L_BIT_1_TO_0) << BIT_SHIFT_CFC_L_BIT_1_TO_0)
#define BITS_CFC_L_BIT_1_TO_0                                                  \
	(BIT_MASK_CFC_L_BIT_1_TO_0 << BIT_SHIFT_CFC_L_BIT_1_TO_0)
#define BIT_CLEAR_CFC_L_BIT_1_TO_0(x) ((x) & (~BITS_CFC_L_BIT_1_TO_0))
#define BIT_GET_CFC_L_BIT_1_TO_0(x)                                            \
	(((x) >> BIT_SHIFT_CFC_L_BIT_1_TO_0) & BIT_MASK_CFC_L_BIT_1_TO_0)
#define BIT_SET_CFC_L_BIT_1_TO_0(x, v)                                         \
	(BIT_CLEAR_CFC_L_BIT_1_TO_0(x) | BIT_CFC_L_BIT_1_TO_0(v))

#endif

#if (HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_LDO_SWR_CTRL			(Offset 0x007C) */

#define BIT_SHIFT_CFC_L 1
#define BIT_MASK_CFC_L 0x3
#define BIT_CFC_L(x) (((x) & BIT_MASK_CFC_L) << BIT_SHIFT_CFC_L)
#define BITS_CFC_L (BIT_MASK_CFC_L << BIT_SHIFT_CFC_L)
#define BIT_CLEAR_CFC_L(x) ((x) & (~BITS_CFC_L))
#define BIT_GET_CFC_L(x) (((x) >> BIT_SHIFT_CFC_L) & BIT_MASK_CFC_L)
#define BIT_SET_CFC_L(x, v) (BIT_CLEAR_CFC_L(x) | BIT_CFC_L(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_LDO_SWR_CTRL			(Offset 0x007C) */

#define BIT_REG_TYPE_L BIT(0)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_LDO_SWR_CTRL			(Offset 0x007C) */

#define BIT_XCK_OUT_EN BIT(0)

#endif

#if (HALMAC_8822B_SUPPORT)

/* 2 REG_LDO_SWR_CTRL			(Offset 0x007C) */

#define BIT_REG_OCPS_L_V1 BIT(0)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_MCUFW_CTRL				(Offset 0x0080) */

#define BIT_MCUSUS_EN BIT(23)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_MCUFW_CTRL				(Offset 0x0080) */

#define BIT_ANA_PORT_EN BIT(22)
#define BIT_MAC_PORT_EN BIT(21)
#define BIT_BOOT_FSPI_EN BIT(20)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_MCUFW_CTRL				(Offset 0x0080) */

#define BIT_SHIFT_MCUROM_DL 16
#define BIT_MASK_MCUROM_DL 0xf
#define BIT_MCUROM_DL(x) (((x) & BIT_MASK_MCUROM_DL) << BIT_SHIFT_MCUROM_DL)
#define BITS_MCUROM_DL (BIT_MASK_MCUROM_DL << BIT_SHIFT_MCUROM_DL)
#define BIT_CLEAR_MCUROM_DL(x) ((x) & (~BITS_MCUROM_DL))
#define BIT_GET_MCUROM_DL(x) (((x) >> BIT_SHIFT_MCUROM_DL) & BIT_MASK_MCUROM_DL)
#define BIT_SET_MCUROM_DL(x, v) (BIT_CLEAR_MCUROM_DL(x) | BIT_MCUROM_DL(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_MCUFW_CTRL				(Offset 0x0080) */

#define BIT_FW_INIT_RDY BIT(15)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_MCUFW_CTRL				(Offset 0x0080) */

#define BIT_SHIFT_MCUFWDL_DMA_2KB_SEL 14
#define BIT_MASK_MCUFWDL_DMA_2KB_SEL 0x3
#define BIT_MCUFWDL_DMA_2KB_SEL(x)                                             \
	(((x) & BIT_MASK_MCUFWDL_DMA_2KB_SEL) << BIT_SHIFT_MCUFWDL_DMA_2KB_SEL)
#define BITS_MCUFWDL_DMA_2KB_SEL                                               \
	(BIT_MASK_MCUFWDL_DMA_2KB_SEL << BIT_SHIFT_MCUFWDL_DMA_2KB_SEL)
#define BIT_CLEAR_MCUFWDL_DMA_2KB_SEL(x) ((x) & (~BITS_MCUFWDL_DMA_2KB_SEL))
#define BIT_GET_MCUFWDL_DMA_2KB_SEL(x)                                         \
	(((x) >> BIT_SHIFT_MCUFWDL_DMA_2KB_SEL) & BIT_MASK_MCUFWDL_DMA_2KB_SEL)
#define BIT_SET_MCUFWDL_DMA_2KB_SEL(x, v)                                      \
	(BIT_CLEAR_MCUFWDL_DMA_2KB_SEL(x) | BIT_MCUFWDL_DMA_2KB_SEL(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_MCUFW_CTRL				(Offset 0x0080) */

#define BIT_FW_DW_RDY BIT(14)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_8051FW_CTRL				(Offset 0x0080) */

#define BIT_FWDL_RSVDPAGE_RDY BIT(12)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_MCUFW_CTRL				(Offset 0x0080) */

#define BIT_SHIFT_CPU_CLK_SEL 12
#define BIT_MASK_CPU_CLK_SEL 0x3
#define BIT_CPU_CLK_SEL(x)                                                     \
	(((x) & BIT_MASK_CPU_CLK_SEL) << BIT_SHIFT_CPU_CLK_SEL)
#define BITS_CPU_CLK_SEL (BIT_MASK_CPU_CLK_SEL << BIT_SHIFT_CPU_CLK_SEL)
#define BIT_CLEAR_CPU_CLK_SEL(x) ((x) & (~BITS_CPU_CLK_SEL))
#define BIT_GET_CPU_CLK_SEL(x)                                                 \
	(((x) >> BIT_SHIFT_CPU_CLK_SEL) & BIT_MASK_CPU_CLK_SEL)
#define BIT_SET_CPU_CLK_SEL(x, v)                                              \
	(BIT_CLEAR_CPU_CLK_SEL(x) | BIT_CPU_CLK_SEL(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_8051FW_CTRL				(Offset 0x0080) */

#define BIT_R_8051_ROMDLFW_EN BIT(11)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_MCUFW_CTRL				(Offset 0x0080) */

#define BIT_MCUFWDL_DMA_EN BIT(11)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_MCUFW_CTRL				(Offset 0x0080) */

#define BIT_CCLK_CHG_MASK BIT(11)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_8051FW_CTRL				(Offset 0x0080) */

#define BIT_R_8051_INIT_RDY BIT(10)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_MCUFW_CTRL				(Offset 0x0080) */

#define BIT_MCUINI_WROMRDY BIT(10)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_MCUFW_CTRL				(Offset 0x0080) */

#define BIT_FW_INIT_RDY_V1 BIT(10)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_MCUFW_CTRL				(Offset 0x0080) */

#define BIT_EMEM__TXBUF_CHKSUM_OK BIT(10)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_MCUFW_CTRL				(Offset 0x0080) */

#define BIT_EMEM_TXBUF_CHKSUM_OK BIT(10)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_MCUFW_CTRL				(Offset 0x0080) */

#define BIT_MCUTXA_SPD BIT(9)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_MCUFW_CTRL				(Offset 0x0080) */

#define BIT_EMEM_TXBUF_DW_RDY BIT(9)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_8051FW_CTRL				(Offset 0x0080) */

#define BIT_R_8051_GAT BIT(8)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_MCUFW_CTRL				(Offset 0x0080) */

#define BIT_MCUCLK_TEN BIT(8)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_MCUFW_CTRL				(Offset 0x0080) */

#define BIT_MCU_CLK_EN BIT(8)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_MCUFW_CTRL				(Offset 0x0080) */

#define BIT_EMEM_CHKSUM_OK BIT(8)
#define BIT_EMEM_DW_OK BIT(7)
#define BIT_TOGGLE BIT(7)
#define BIT_DMEM_CHKSUM_OK BIT(6)
#define BIT_ACK BIT(6)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_8051FW_CTRL				(Offset 0x0080) */

#define BIT_RFINI_RDY BIT(5)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_MCUFW_CTRL				(Offset 0x0080) */

#define BIT_MCUINI_WRFCRDY BIT(5)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_MCUFW_CTRL				(Offset 0x0080) */

#define BIT_RF_INIT_RDY BIT(5)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_MCUFW_CTRL				(Offset 0x0080) */

#define BIT_DMEM_DW_OK BIT(5)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_8051FW_CTRL				(Offset 0x0080) */

#define BIT_BBINI_RDY BIT(4)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_MCUFW_CTRL				(Offset 0x0080) */

#define BIT_MCUINI_WPHYRDY BIT(4)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_MCUFW_CTRL				(Offset 0x0080) */

#define BIT_BB_INIT_RDY BIT(4)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_MCUFW_CTRL				(Offset 0x0080) */

#define BIT_IMEM_CHKSUM_OK BIT(4)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_8051FW_CTRL				(Offset 0x0080) */

#define BIT_MACINI_RDY BIT(3)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_MCUFW_CTRL				(Offset 0x0080) */

#define BIT_MCUINI_WMACRDY BIT(3)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_MCUFW_CTRL				(Offset 0x0080) */

#define BIT_MAC_INIT_RDY BIT(3)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_MCUFW_CTRL				(Offset 0x0080) */

#define BIT_IMEM_DW_OK BIT(3)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_8051FW_CTRL				(Offset 0x0080) */

#define BIT_FWDL_CHK_RPT BIT(2)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_MCUFW_CTRL				(Offset 0x0080) */

#define BIT_IMEM_BOOT_LOAD_CHKSUM_OK BIT(2)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_8051FW_CTRL				(Offset 0x0080) */

#define BIT_MCUFWDL_RDY BIT(1)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_MCUFW_CTRL				(Offset 0x0080) */

#define BIT_IMEM_BOOT_LOAD_DW_OK BIT(1)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_MCUFW_CTRL				(Offset 0x0080) */

#define BIT_MCU_FWDL_RDY BIT(1)
#define BIT_MCU_FWDL_EN BIT(0)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_HRPWM1				(Offset 0x10250080) */

#define BIT_REQ_PS BIT(0)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_MCU_TST_CFG				(Offset 0x0084) */

#define BIT_SHIFT_8051CODE_OFS 16
#define BIT_MASK_8051CODE_OFS 0xffff
#define BIT_8051CODE_OFS(x)                                                    \
	(((x) & BIT_MASK_8051CODE_OFS) << BIT_SHIFT_8051CODE_OFS)
#define BITS_8051CODE_OFS (BIT_MASK_8051CODE_OFS << BIT_SHIFT_8051CODE_OFS)
#define BIT_CLEAR_8051CODE_OFS(x) ((x) & (~BITS_8051CODE_OFS))
#define BIT_GET_8051CODE_OFS(x)                                                \
	(((x) >> BIT_SHIFT_8051CODE_OFS) & BIT_MASK_8051CODE_OFS)
#define BIT_SET_8051CODE_OFS(x, v)                                             \
	(BIT_CLEAR_8051CODE_OFS(x) | BIT_8051CODE_OFS(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_MCU_TST_CFG				(Offset 0x0084) */

#define BIT_SHIFT_LBKTST 0
#define BIT_MASK_LBKTST 0xffff
#define BIT_LBKTST(x) (((x) & BIT_MASK_LBKTST) << BIT_SHIFT_LBKTST)
#define BITS_LBKTST (BIT_MASK_LBKTST << BIT_SHIFT_LBKTST)
#define BIT_CLEAR_LBKTST(x) ((x) & (~BITS_LBKTST))
#define BIT_GET_LBKTST(x) (((x) >> BIT_SHIFT_LBKTST) & BIT_MASK_LBKTST)
#define BIT_SET_LBKTST(x, v) (BIT_CLEAR_LBKTST(x) | BIT_LBKTST(v))

#endif

#if (HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT)

/* 2 REG_MCU_TST_CFG				(Offset 0x0084) */

#define BIT_SHIFT_C2H_MSG 0
#define BIT_MASK_C2H_MSG 0xffff
#define BIT_C2H_MSG(x) (((x) & BIT_MASK_C2H_MSG) << BIT_SHIFT_C2H_MSG)
#define BITS_C2H_MSG (BIT_MASK_C2H_MSG << BIT_SHIFT_C2H_MSG)
#define BIT_CLEAR_C2H_MSG(x) ((x) & (~BITS_C2H_MSG))
#define BIT_GET_C2H_MSG(x) (((x) >> BIT_SHIFT_C2H_MSG) & BIT_MASK_C2H_MSG)
#define BIT_SET_C2H_MSG(x, v) (BIT_CLEAR_C2H_MSG(x) | BIT_C2H_MSG(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_BUS_CTRL			(Offset 0x10250085) */

#define BIT_INT_MASK_DIS BIT(4)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_BUS_CTRL			(Offset 0x10250085) */

#define BIT_PAD_CLK_XHGE_EN BIT(3)
#define BIT_INTER_CLK_EN BIT(2)
#define BIT_EN_RPT_TXCRC BIT(1)
#define BIT_DIS_RXDMA_STS BIT(0)

#endif

#if (HALMAC_8812F_SUPPORT)

/* 2 REG_SDIO_HSUS_CTRL			(Offset 0x10250086) */

#define BIT_SPI_PHASE BIT(5)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_HSUS_CTRL			(Offset 0x10250086) */

#define BIT_INTR_CTRL BIT(4)
#define BIT_SDIO_VOLTAGE BIT(3)
#define BIT_BYPASS_INIT BIT(2)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_HSUS_CTRL			(Offset 0x10250086) */

#define BIT_HCI_RESUME_RDY BIT(1)
#define BIT_HCI_SUS_REQ BIT(0)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_HMEBOX_E0_E1			(Offset 0x0088) */

#define BIT_SHIFT_HOST_MSG_E1 16
#define BIT_MASK_HOST_MSG_E1 0xffff
#define BIT_HOST_MSG_E1(x)                                                     \
	(((x) & BIT_MASK_HOST_MSG_E1) << BIT_SHIFT_HOST_MSG_E1)
#define BITS_HOST_MSG_E1 (BIT_MASK_HOST_MSG_E1 << BIT_SHIFT_HOST_MSG_E1)
#define BIT_CLEAR_HOST_MSG_E1(x) ((x) & (~BITS_HOST_MSG_E1))
#define BIT_GET_HOST_MSG_E1(x)                                                 \
	(((x) >> BIT_SHIFT_HOST_MSG_E1) & BIT_MASK_HOST_MSG_E1)
#define BIT_SET_HOST_MSG_E1(x, v)                                              \
	(BIT_CLEAR_HOST_MSG_E1(x) | BIT_HOST_MSG_E1(v))

#define BIT_SHIFT_HOST_MSG_E0 0
#define BIT_MASK_HOST_MSG_E0 0xffff
#define BIT_HOST_MSG_E0(x)                                                     \
	(((x) & BIT_MASK_HOST_MSG_E0) << BIT_SHIFT_HOST_MSG_E0)
#define BITS_HOST_MSG_E0 (BIT_MASK_HOST_MSG_E0 << BIT_SHIFT_HOST_MSG_E0)
#define BIT_CLEAR_HOST_MSG_E0(x) ((x) & (~BITS_HOST_MSG_E0))
#define BIT_GET_HOST_MSG_E0(x)                                                 \
	(((x) >> BIT_SHIFT_HOST_MSG_E0) & BIT_MASK_HOST_MSG_E0)
#define BIT_SET_HOST_MSG_E0(x, v)                                              \
	(BIT_CLEAR_HOST_MSG_E0(x) | BIT_HOST_MSG_E0(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_RESPONSE_TIMER			(Offset 0x10250088) */

#define BIT_SHIFT_CMDIN_2RESP_TIMER 0
#define BIT_MASK_CMDIN_2RESP_TIMER 0xffff
#define BIT_CMDIN_2RESP_TIMER(x)                                               \
	(((x) & BIT_MASK_CMDIN_2RESP_TIMER) << BIT_SHIFT_CMDIN_2RESP_TIMER)
#define BITS_CMDIN_2RESP_TIMER                                                 \
	(BIT_MASK_CMDIN_2RESP_TIMER << BIT_SHIFT_CMDIN_2RESP_TIMER)
#define BIT_CLEAR_CMDIN_2RESP_TIMER(x) ((x) & (~BITS_CMDIN_2RESP_TIMER))
#define BIT_GET_CMDIN_2RESP_TIMER(x)                                           \
	(((x) >> BIT_SHIFT_CMDIN_2RESP_TIMER) & BIT_MASK_CMDIN_2RESP_TIMER)
#define BIT_SET_CMDIN_2RESP_TIMER(x, v)                                        \
	(BIT_CLEAR_CMDIN_2RESP_TIMER(x) | BIT_CMDIN_2RESP_TIMER(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SDIO_CMD_CRC			(Offset 0x1025008A) */

#define BIT_SHIFT_SDIO_CMD_CRC 1
#define BIT_MASK_SDIO_CMD_CRC 0x7f
#define BIT_SDIO_CMD_CRC(x)                                                    \
	(((x) & BIT_MASK_SDIO_CMD_CRC) << BIT_SHIFT_SDIO_CMD_CRC)
#define BITS_SDIO_CMD_CRC (BIT_MASK_SDIO_CMD_CRC << BIT_SHIFT_SDIO_CMD_CRC)
#define BIT_CLEAR_SDIO_CMD_CRC(x) ((x) & (~BITS_SDIO_CMD_CRC))
#define BIT_GET_SDIO_CMD_CRC(x)                                                \
	(((x) >> BIT_SHIFT_SDIO_CMD_CRC) & BIT_MASK_SDIO_CMD_CRC)
#define BIT_SET_SDIO_CMD_CRC(x, v)                                             \
	(BIT_CLEAR_SDIO_CMD_CRC(x) | BIT_SDIO_CMD_CRC(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_CMD_CRC			(Offset 0x1025008A) */

#define BIT_SHIFT_SDIO_CMD_CRC_V1 0
#define BIT_MASK_SDIO_CMD_CRC_V1 0xff
#define BIT_SDIO_CMD_CRC_V1(x)                                                 \
	(((x) & BIT_MASK_SDIO_CMD_CRC_V1) << BIT_SHIFT_SDIO_CMD_CRC_V1)
#define BITS_SDIO_CMD_CRC_V1                                                   \
	(BIT_MASK_SDIO_CMD_CRC_V1 << BIT_SHIFT_SDIO_CMD_CRC_V1)
#define BIT_CLEAR_SDIO_CMD_CRC_V1(x) ((x) & (~BITS_SDIO_CMD_CRC_V1))
#define BIT_GET_SDIO_CMD_CRC_V1(x)                                             \
	(((x) >> BIT_SHIFT_SDIO_CMD_CRC_V1) & BIT_MASK_SDIO_CMD_CRC_V1)
#define BIT_SET_SDIO_CMD_CRC_V1(x, v)                                          \
	(BIT_CLEAR_SDIO_CMD_CRC_V1(x) | BIT_SDIO_CMD_CRC_V1(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SDIO_CMD_CRC			(Offset 0x1025008A) */

#define BIT_SDIO_CMD_E_BIT BIT(0)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_HMEBOX_E2_E3			(Offset 0x008C) */

#define BIT_SHIFT_HOST_MSG_E3 16
#define BIT_MASK_HOST_MSG_E3 0xffff
#define BIT_HOST_MSG_E3(x)                                                     \
	(((x) & BIT_MASK_HOST_MSG_E3) << BIT_SHIFT_HOST_MSG_E3)
#define BITS_HOST_MSG_E3 (BIT_MASK_HOST_MSG_E3 << BIT_SHIFT_HOST_MSG_E3)
#define BIT_CLEAR_HOST_MSG_E3(x) ((x) & (~BITS_HOST_MSG_E3))
#define BIT_GET_HOST_MSG_E3(x)                                                 \
	(((x) >> BIT_SHIFT_HOST_MSG_E3) & BIT_MASK_HOST_MSG_E3)
#define BIT_SET_HOST_MSG_E3(x, v)                                              \
	(BIT_CLEAR_HOST_MSG_E3(x) | BIT_HOST_MSG_E3(v))

#define BIT_SHIFT_HOST_MSG_E2 0
#define BIT_MASK_HOST_MSG_E2 0xffff
#define BIT_HOST_MSG_E2(x)                                                     \
	(((x) & BIT_MASK_HOST_MSG_E2) << BIT_SHIFT_HOST_MSG_E2)
#define BITS_HOST_MSG_E2 (BIT_MASK_HOST_MSG_E2 << BIT_SHIFT_HOST_MSG_E2)
#define BIT_CLEAR_HOST_MSG_E2(x) ((x) & (~BITS_HOST_MSG_E2))
#define BIT_GET_HOST_MSG_E2(x)                                                 \
	(((x) >> BIT_SHIFT_HOST_MSG_E2) & BIT_MASK_HOST_MSG_E2)
#define BIT_SET_HOST_MSG_E2(x, v)                                              \
	(BIT_CLEAR_HOST_MSG_E2(x) | BIT_HOST_MSG_E2(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_WLLPS_CTRL				(Offset 0x0090) */

#define BIT_WLLPSOP_EABM BIT(31)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_WLLPS_CTRL				(Offset 0x0090) */

#define BIT_WLLPSOP_ACKF BIT(30)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_WLLPS_CTRL				(Offset 0x0090) */

#define BIT_TXFIFO_TH_INT BIT(30)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_WLLPS_CTRL				(Offset 0x0090) */

#define BIT_WLLPSOP_DLDM BIT(29)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_WLLPS_CTRL				(Offset 0x0090) */

#define BIT_WLLPSOP_NODS BIT(29)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_WLLPS_CTRL				(Offset 0x0090) */

#define BIT_WLLPSOP_AFEP BIT(29)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_WLLPS_CTRL				(Offset 0x0090) */

#define BIT_WLLPSOP_ESWR BIT(28)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_WLLPS_CTRL				(Offset 0x0090) */

#define BIT_LPS_DIS_SW BIT(28)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_WLLPS_CTRL				(Offset 0x0090) */

#define BIT_WLLPSOP_PWMM BIT(27)
#define BIT_WLLPSOP_EECK BIT(26)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_WLLPS_CTRL				(Offset 0x0090) */

#define BIT_WLLPSOP_WLPON BIT(25)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_WLLPS_CTRL				(Offset 0x0090) */

#define BIT_WLLPSOP_WLMACOFF BIT(25)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_WLLPS_CTRL				(Offset 0x0090) */

#define BIT_WLLPSOP_ELDO BIT(25)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_WLLPS_CTRL				(Offset 0x0090) */

#define BIT_WLLPSOP_EXTAL BIT(24)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_WLLPS_CTRL				(Offset 0x0090) */

#define BIT_WL_SYNPON_VOLTSPDN BIT(23)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_WLLPS_CTRL				(Offset 0x0090) */

#define BIT_LPS_BB_REG_EN BIT(23)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_WLLPS_CTRL				(Offset 0x0090) */

#define BIT_LOP_SKIP BIT(22)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_WLLPS_CTRL				(Offset 0x0090) */

#define BIT_WLLPSOP_WLBBOFF BIT(22)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_WLLPS_CTRL				(Offset 0x0090) */

#define BIT_LPS_BB_PWR_EN BIT(22)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_WLLPS_CTRL				(Offset 0x0090) */

#define BIT_LOP_MEMDS BIT(21)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_WLLPS_CTRL				(Offset 0x0090) */

#define BIT_WLLPSOP_WLMEM_DS BIT(21)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_WLLPS_CTRL				(Offset 0x0090) */

#define BIT_LPS_BB_GLB_EN BIT(21)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_WLLPS_CTRL				(Offset 0x0090) */

#define BIT_WLLPSOP_LDO_WAIT_TIME BIT(20)
#define BIT_WLLPSOP_ANA_CLK_DIVISION_2 BIT(19)
#define BIT_AFE_BCN BIT(18)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_WLLPS_CTRL				(Offset 0x0090) */

#define BIT_SUS_DIS_SW BIT(15)
#define BIT_SUS_SKP_PAGE0_ALD BIT(14)
#define BIT_SUS_LDO_SLEEP BIT(13)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_WLLPS_CTRL				(Offset 0x0090) */

#define BIT_SHIFT_LPLDH12_VADJ_STEP_DN 12
#define BIT_MASK_LPLDH12_VADJ_STEP_DN 0xf
#define BIT_LPLDH12_VADJ_STEP_DN(x)                                            \
	(((x) & BIT_MASK_LPLDH12_VADJ_STEP_DN)                                 \
	 << BIT_SHIFT_LPLDH12_VADJ_STEP_DN)
#define BITS_LPLDH12_VADJ_STEP_DN                                              \
	(BIT_MASK_LPLDH12_VADJ_STEP_DN << BIT_SHIFT_LPLDH12_VADJ_STEP_DN)
#define BIT_CLEAR_LPLDH12_VADJ_STEP_DN(x) ((x) & (~BITS_LPLDH12_VADJ_STEP_DN))
#define BIT_GET_LPLDH12_VADJ_STEP_DN(x)                                        \
	(((x) >> BIT_SHIFT_LPLDH12_VADJ_STEP_DN) &                             \
	 BIT_MASK_LPLDH12_VADJ_STEP_DN)
#define BIT_SET_LPLDH12_VADJ_STEP_DN(x, v)                                     \
	(BIT_CLEAR_LPLDH12_VADJ_STEP_DN(x) | BIT_LPLDH12_VADJ_STEP_DN(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_WLLPS_CTRL				(Offset 0x0090) */

#define BIT_PFM_EN_ZCD BIT(12)
#define BIT_KEEP_RFC_EN BIT(11)
#define BIT_MACON_NO_RFCISO_RELEASE BIT(10)
#define BIT_MACON_NO_AFEPORT_PWR BIT(9)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT)

/* 2 REG_WLLPS_CTRL				(Offset 0x0090) */

#define BIT_SHIFT_V15ADJ_L1_STEP_DN 8
#define BIT_MASK_V15ADJ_L1_STEP_DN 0x7
#define BIT_V15ADJ_L1_STEP_DN(x)                                               \
	(((x) & BIT_MASK_V15ADJ_L1_STEP_DN) << BIT_SHIFT_V15ADJ_L1_STEP_DN)
#define BITS_V15ADJ_L1_STEP_DN                                                 \
	(BIT_MASK_V15ADJ_L1_STEP_DN << BIT_SHIFT_V15ADJ_L1_STEP_DN)
#define BIT_CLEAR_V15ADJ_L1_STEP_DN(x) ((x) & (~BITS_V15ADJ_L1_STEP_DN))
#define BIT_GET_V15ADJ_L1_STEP_DN(x)                                           \
	(((x) >> BIT_SHIFT_V15ADJ_L1_STEP_DN) & BIT_MASK_V15ADJ_L1_STEP_DN)
#define BIT_SET_V15ADJ_L1_STEP_DN(x, v)                                        \
	(BIT_CLEAR_V15ADJ_L1_STEP_DN(x) | BIT_V15ADJ_L1_STEP_DN(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_WLLPS_CTRL				(Offset 0x0090) */

#define BIT_SHIFT_V15ADJ_L1_STEP_DN_V1 8
#define BIT_MASK_V15ADJ_L1_STEP_DN_V1 0xf
#define BIT_V15ADJ_L1_STEP_DN_V1(x)                                            \
	(((x) & BIT_MASK_V15ADJ_L1_STEP_DN_V1)                                 \
	 << BIT_SHIFT_V15ADJ_L1_STEP_DN_V1)
#define BITS_V15ADJ_L1_STEP_DN_V1                                              \
	(BIT_MASK_V15ADJ_L1_STEP_DN_V1 << BIT_SHIFT_V15ADJ_L1_STEP_DN_V1)
#define BIT_CLEAR_V15ADJ_L1_STEP_DN_V1(x) ((x) & (~BITS_V15ADJ_L1_STEP_DN_V1))
#define BIT_GET_V15ADJ_L1_STEP_DN_V1(x)                                        \
	(((x) >> BIT_SHIFT_V15ADJ_L1_STEP_DN_V1) &                             \
	 BIT_MASK_V15ADJ_L1_STEP_DN_V1)
#define BIT_SET_V15ADJ_L1_STEP_DN_V1(x, v)                                     \
	(BIT_CLEAR_V15ADJ_L1_STEP_DN_V1(x) | BIT_V15ADJ_L1_STEP_DN_V1(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_WLLPS_CTRL				(Offset 0x0090) */

#define BIT_MACON_NO_CPU_EN BIT(8)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_WLLPS_CTRL				(Offset 0x0090) */

#define BIT_LD_B15V_EN BIT(7)
#define BIT_LPRX_BCN_EN BIT(5)
#define BIT_LBN BIT(4)
#define BIT_LXSPS_UNUSED BIT(3)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_WLLPS_CTRL				(Offset 0x0090) */

#define BIT_FORCE_LEAVE_LPS BIT(3)
#define BIT_SW_AFE_MODE BIT(2)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_WLLPS_CTRL				(Offset 0x0090) */

#define BIT_REGU_32K_CLK_EN BIT(1)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_HSISR				(Offset 0x10250090) */

#define BIT_DRV_WLAN_INT_CLR BIT(1)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_WLLPS_CTRL				(Offset 0x0090) */

#define BIT_WL_LPS_EN BIT(0)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_HSISR				(Offset 0x10250090) */

#define BIT_DRV_WLAN_INT BIT(0)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_HSIMR				(Offset 0x10250091) */

#define BIT_HISR_MASK BIT(0)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT)

/* 2 REG_AFE_CTRL5				(Offset 0x0094) */

#define BIT_BB_DBG_SEL_AFE_SDM_V3 BIT(31)

#endif

#if (HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL5				(Offset 0x0094) */

#define BIT_BB_DBG_SEL_AFE_SDM_BIT0 BIT(31)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL5				(Offset 0x0094) */

#define BIT_ORDER_SDM BIT(30)
#define BIT_RFE_SEL_SDM BIT(29)

#define BIT_SHIFT_REF_SEL 25
#define BIT_MASK_REF_SEL 0xf
#define BIT_REF_SEL(x) (((x) & BIT_MASK_REF_SEL) << BIT_SHIFT_REF_SEL)
#define BITS_REF_SEL (BIT_MASK_REF_SEL << BIT_SHIFT_REF_SEL)
#define BIT_CLEAR_REF_SEL(x) ((x) & (~BITS_REF_SEL))
#define BIT_GET_REF_SEL(x) (((x) >> BIT_SHIFT_REF_SEL) & BIT_MASK_REF_SEL)
#define BIT_SET_REF_SEL(x, v) (BIT_CLEAR_REF_SEL(x) | BIT_REF_SEL(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT)

/* 2 REG_AFE_CTRL5				(Offset 0x0094) */

#define BIT_SHIFT_F0F_SDM_V2 12
#define BIT_MASK_F0F_SDM_V2 0x1fff
#define BIT_F0F_SDM_V2(x) (((x) & BIT_MASK_F0F_SDM_V2) << BIT_SHIFT_F0F_SDM_V2)
#define BITS_F0F_SDM_V2 (BIT_MASK_F0F_SDM_V2 << BIT_SHIFT_F0F_SDM_V2)
#define BIT_CLEAR_F0F_SDM_V2(x) ((x) & (~BITS_F0F_SDM_V2))
#define BIT_GET_F0F_SDM_V2(x)                                                  \
	(((x) >> BIT_SHIFT_F0F_SDM_V2) & BIT_MASK_F0F_SDM_V2)
#define BIT_SET_F0F_SDM_V2(x, v) (BIT_CLEAR_F0F_SDM_V2(x) | BIT_F0F_SDM_V2(v))

#endif

#if (HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL5				(Offset 0x0094) */

#define BIT_SHIFT_F0F_SDM 12
#define BIT_MASK_F0F_SDM 0x1fff
#define BIT_F0F_SDM(x) (((x) & BIT_MASK_F0F_SDM) << BIT_SHIFT_F0F_SDM)
#define BITS_F0F_SDM (BIT_MASK_F0F_SDM << BIT_SHIFT_F0F_SDM)
#define BIT_CLEAR_F0F_SDM(x) ((x) & (~BITS_F0F_SDM))
#define BIT_GET_F0F_SDM(x) (((x) >> BIT_SHIFT_F0F_SDM) & BIT_MASK_F0F_SDM)
#define BIT_SET_F0F_SDM(x, v) (BIT_CLEAR_F0F_SDM(x) | BIT_F0F_SDM(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT)

/* 2 REG_AFE_CTRL5				(Offset 0x0094) */

#define BIT_SHIFT_F0N_SDM_V2 9
#define BIT_MASK_F0N_SDM_V2 0x7
#define BIT_F0N_SDM_V2(x) (((x) & BIT_MASK_F0N_SDM_V2) << BIT_SHIFT_F0N_SDM_V2)
#define BITS_F0N_SDM_V2 (BIT_MASK_F0N_SDM_V2 << BIT_SHIFT_F0N_SDM_V2)
#define BIT_CLEAR_F0N_SDM_V2(x) ((x) & (~BITS_F0N_SDM_V2))
#define BIT_GET_F0N_SDM_V2(x)                                                  \
	(((x) >> BIT_SHIFT_F0N_SDM_V2) & BIT_MASK_F0N_SDM_V2)
#define BIT_SET_F0N_SDM_V2(x, v) (BIT_CLEAR_F0N_SDM_V2(x) | BIT_F0N_SDM_V2(v))

#endif

#if (HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL5				(Offset 0x0094) */

#define BIT_SHIFT_F0N_SDM 9
#define BIT_MASK_F0N_SDM 0x7
#define BIT_F0N_SDM(x) (((x) & BIT_MASK_F0N_SDM) << BIT_SHIFT_F0N_SDM)
#define BITS_F0N_SDM (BIT_MASK_F0N_SDM << BIT_SHIFT_F0N_SDM)
#define BIT_CLEAR_F0N_SDM(x) ((x) & (~BITS_F0N_SDM))
#define BIT_GET_F0N_SDM(x) (((x) >> BIT_SHIFT_F0N_SDM) & BIT_MASK_F0N_SDM)
#define BIT_SET_F0N_SDM(x, v) (BIT_CLEAR_F0N_SDM(x) | BIT_F0N_SDM(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT)

/* 2 REG_AFE_CTRL5				(Offset 0x0094) */

#define BIT_SHIFT_DIVN_SDM_V2 3
#define BIT_MASK_DIVN_SDM_V2 0x3f
#define BIT_DIVN_SDM_V2(x)                                                     \
	(((x) & BIT_MASK_DIVN_SDM_V2) << BIT_SHIFT_DIVN_SDM_V2)
#define BITS_DIVN_SDM_V2 (BIT_MASK_DIVN_SDM_V2 << BIT_SHIFT_DIVN_SDM_V2)
#define BIT_CLEAR_DIVN_SDM_V2(x) ((x) & (~BITS_DIVN_SDM_V2))
#define BIT_GET_DIVN_SDM_V2(x)                                                 \
	(((x) >> BIT_SHIFT_DIVN_SDM_V2) & BIT_MASK_DIVN_SDM_V2)
#define BIT_SET_DIVN_SDM_V2(x, v)                                              \
	(BIT_CLEAR_DIVN_SDM_V2(x) | BIT_DIVN_SDM_V2(v))

#endif

#if (HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL5				(Offset 0x0094) */

#define BIT_SHIFT_DIVN_SDM 3
#define BIT_MASK_DIVN_SDM 0x3f
#define BIT_DIVN_SDM(x) (((x) & BIT_MASK_DIVN_SDM) << BIT_SHIFT_DIVN_SDM)
#define BITS_DIVN_SDM (BIT_MASK_DIVN_SDM << BIT_SHIFT_DIVN_SDM)
#define BIT_CLEAR_DIVN_SDM(x) ((x) & (~BITS_DIVN_SDM))
#define BIT_GET_DIVN_SDM(x) (((x) >> BIT_SHIFT_DIVN_SDM) & BIT_MASK_DIVN_SDM)
#define BIT_SET_DIVN_SDM(x, v) (BIT_CLEAR_DIVN_SDM(x) | BIT_DIVN_SDM(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT)

/* 2 REG_AFE_CTRL5				(Offset 0x0094) */

#define BIT_SHIFT_DITHER_SDM_V2 0
#define BIT_MASK_DITHER_SDM_V2 0x7
#define BIT_DITHER_SDM_V2(x)                                                   \
	(((x) & BIT_MASK_DITHER_SDM_V2) << BIT_SHIFT_DITHER_SDM_V2)
#define BITS_DITHER_SDM_V2 (BIT_MASK_DITHER_SDM_V2 << BIT_SHIFT_DITHER_SDM_V2)
#define BIT_CLEAR_DITHER_SDM_V2(x) ((x) & (~BITS_DITHER_SDM_V2))
#define BIT_GET_DITHER_SDM_V2(x)                                               \
	(((x) >> BIT_SHIFT_DITHER_SDM_V2) & BIT_MASK_DITHER_SDM_V2)
#define BIT_SET_DITHER_SDM_V2(x, v)                                            \
	(BIT_CLEAR_DITHER_SDM_V2(x) | BIT_DITHER_SDM_V2(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_GPIO_DEBOUNCE_CTRL			(Offset 0x0098) */

#define BIT_WLGP_DBC1EN BIT(15)

#define BIT_SHIFT_WLGP_DBC1 8
#define BIT_MASK_WLGP_DBC1 0xf
#define BIT_WLGP_DBC1(x) (((x) & BIT_MASK_WLGP_DBC1) << BIT_SHIFT_WLGP_DBC1)
#define BITS_WLGP_DBC1 (BIT_MASK_WLGP_DBC1 << BIT_SHIFT_WLGP_DBC1)
#define BIT_CLEAR_WLGP_DBC1(x) ((x) & (~BITS_WLGP_DBC1))
#define BIT_GET_WLGP_DBC1(x) (((x) >> BIT_SHIFT_WLGP_DBC1) & BIT_MASK_WLGP_DBC1)
#define BIT_SET_WLGP_DBC1(x, v) (BIT_CLEAR_WLGP_DBC1(x) | BIT_WLGP_DBC1(v))

#define BIT_WLGP_DBC0EN BIT(7)

#define BIT_SHIFT_WLGP_DBC0 0
#define BIT_MASK_WLGP_DBC0 0xf
#define BIT_WLGP_DBC0(x) (((x) & BIT_MASK_WLGP_DBC0) << BIT_SHIFT_WLGP_DBC0)
#define BITS_WLGP_DBC0 (BIT_MASK_WLGP_DBC0 << BIT_SHIFT_WLGP_DBC0)
#define BIT_CLEAR_WLGP_DBC0(x) ((x) & (~BITS_WLGP_DBC0))
#define BIT_GET_WLGP_DBC0(x) (((x) >> BIT_SHIFT_WLGP_DBC0) & BIT_MASK_WLGP_DBC0)
#define BIT_SET_WLGP_DBC0(x, v) (BIT_CLEAR_WLGP_DBC0(x) | BIT_WLGP_DBC0(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_RPWM2				(Offset 0x009C) */

#define BIT_SHIFT_RPWM2 16
#define BIT_MASK_RPWM2 0xffff
#define BIT_RPWM2(x) (((x) & BIT_MASK_RPWM2) << BIT_SHIFT_RPWM2)
#define BITS_RPWM2 (BIT_MASK_RPWM2 << BIT_SHIFT_RPWM2)
#define BIT_CLEAR_RPWM2(x) ((x) & (~BITS_RPWM2))
#define BIT_GET_RPWM2(x) (((x) >> BIT_SHIFT_RPWM2) & BIT_MASK_RPWM2)
#define BIT_SET_RPWM2(x, v) (BIT_CLEAR_RPWM2(x) | BIT_RPWM2(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYSON_FSM_MON			(Offset 0x00A0) */

#define BIT_SHIFT_FSM_MON_SEL 24
#define BIT_MASK_FSM_MON_SEL 0x7
#define BIT_FSM_MON_SEL(x)                                                     \
	(((x) & BIT_MASK_FSM_MON_SEL) << BIT_SHIFT_FSM_MON_SEL)
#define BITS_FSM_MON_SEL (BIT_MASK_FSM_MON_SEL << BIT_SHIFT_FSM_MON_SEL)
#define BIT_CLEAR_FSM_MON_SEL(x) ((x) & (~BITS_FSM_MON_SEL))
#define BIT_GET_FSM_MON_SEL(x)                                                 \
	(((x) >> BIT_SHIFT_FSM_MON_SEL) & BIT_MASK_FSM_MON_SEL)
#define BIT_SET_FSM_MON_SEL(x, v)                                              \
	(BIT_CLEAR_FSM_MON_SEL(x) | BIT_FSM_MON_SEL(v))

#define BIT_DOP_ELDO BIT(23)
#define BIT_FSM_MON_UPD BIT(15)

#define BIT_SHIFT_FSM_PAR 0
#define BIT_MASK_FSM_PAR 0x7fff
#define BIT_FSM_PAR(x) (((x) & BIT_MASK_FSM_PAR) << BIT_SHIFT_FSM_PAR)
#define BITS_FSM_PAR (BIT_MASK_FSM_PAR << BIT_SHIFT_FSM_PAR)
#define BIT_CLEAR_FSM_PAR(x) ((x) & (~BITS_FSM_PAR))
#define BIT_GET_FSM_PAR(x) (((x) >> BIT_SHIFT_FSM_PAR) & BIT_MASK_FSM_PAR)
#define BIT_SET_FSM_PAR(x, v) (BIT_CLEAR_FSM_PAR(x) | BIT_FSM_PAR(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_AFE_CTRL6				(Offset 0x00A4) */

#define BIT_SHIFT_TSFT_SEL_V1 0
#define BIT_MASK_TSFT_SEL_V1 0x7
#define BIT_TSFT_SEL_V1(x)                                                     \
	(((x) & BIT_MASK_TSFT_SEL_V1) << BIT_SHIFT_TSFT_SEL_V1)
#define BITS_TSFT_SEL_V1 (BIT_MASK_TSFT_SEL_V1 << BIT_SHIFT_TSFT_SEL_V1)
#define BIT_CLEAR_TSFT_SEL_V1(x) ((x) & (~BITS_TSFT_SEL_V1))
#define BIT_GET_TSFT_SEL_V1(x)                                                 \
	(((x) >> BIT_SHIFT_TSFT_SEL_V1) & BIT_MASK_TSFT_SEL_V1)
#define BIT_SET_TSFT_SEL_V1(x, v)                                              \
	(BIT_CLEAR_TSFT_SEL_V1(x) | BIT_TSFT_SEL_V1(v))

#endif

#if (HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL6				(Offset 0x00A4) */

#define BIT_SHIFT_BB_DBG_SEL_AFE_SDM_BIT3_1 0
#define BIT_MASK_BB_DBG_SEL_AFE_SDM_BIT3_1 0x7
#define BIT_BB_DBG_SEL_AFE_SDM_BIT3_1(x)                                       \
	(((x) & BIT_MASK_BB_DBG_SEL_AFE_SDM_BIT3_1)                            \
	 << BIT_SHIFT_BB_DBG_SEL_AFE_SDM_BIT3_1)
#define BITS_BB_DBG_SEL_AFE_SDM_BIT3_1                                         \
	(BIT_MASK_BB_DBG_SEL_AFE_SDM_BIT3_1                                    \
	 << BIT_SHIFT_BB_DBG_SEL_AFE_SDM_BIT3_1)
#define BIT_CLEAR_BB_DBG_SEL_AFE_SDM_BIT3_1(x)                                 \
	((x) & (~BITS_BB_DBG_SEL_AFE_SDM_BIT3_1))
#define BIT_GET_BB_DBG_SEL_AFE_SDM_BIT3_1(x)                                   \
	(((x) >> BIT_SHIFT_BB_DBG_SEL_AFE_SDM_BIT3_1) &                        \
	 BIT_MASK_BB_DBG_SEL_AFE_SDM_BIT3_1)
#define BIT_SET_BB_DBG_SEL_AFE_SDM_BIT3_1(x, v)                                \
	(BIT_CLEAR_BB_DBG_SEL_AFE_SDM_BIT3_1(x) |                              \
	 BIT_BB_DBG_SEL_AFE_SDM_BIT3_1(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_PMC_DBG_CTRL1			(Offset 0x00A8) */

#define BIT_BT_INT_EN BIT(31)

#define BIT_SHIFT_RD_WR_WIFI_BT_INFO 16
#define BIT_MASK_RD_WR_WIFI_BT_INFO 0x7fff
#define BIT_RD_WR_WIFI_BT_INFO(x)                                              \
	(((x) & BIT_MASK_RD_WR_WIFI_BT_INFO) << BIT_SHIFT_RD_WR_WIFI_BT_INFO)
#define BITS_RD_WR_WIFI_BT_INFO                                                \
	(BIT_MASK_RD_WR_WIFI_BT_INFO << BIT_SHIFT_RD_WR_WIFI_BT_INFO)
#define BIT_CLEAR_RD_WR_WIFI_BT_INFO(x) ((x) & (~BITS_RD_WR_WIFI_BT_INFO))
#define BIT_GET_RD_WR_WIFI_BT_INFO(x)                                          \
	(((x) >> BIT_SHIFT_RD_WR_WIFI_BT_INFO) & BIT_MASK_RD_WR_WIFI_BT_INFO)
#define BIT_SET_RD_WR_WIFI_BT_INFO(x, v)                                       \
	(BIT_CLEAR_RD_WR_WIFI_BT_INFO(x) | BIT_RD_WR_WIFI_BT_INFO(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_PMC_DBG_CTRL1			(Offset 0x00A8) */

#define BIT_PMC_WR_OVF BIT(8)

#define BIT_SHIFT_WLPMC_ERRINT 0
#define BIT_MASK_WLPMC_ERRINT 0xff
#define BIT_WLPMC_ERRINT(x)                                                    \
	(((x) & BIT_MASK_WLPMC_ERRINT) << BIT_SHIFT_WLPMC_ERRINT)
#define BITS_WLPMC_ERRINT (BIT_MASK_WLPMC_ERRINT << BIT_SHIFT_WLPMC_ERRINT)
#define BIT_CLEAR_WLPMC_ERRINT(x) ((x) & (~BITS_WLPMC_ERRINT))
#define BIT_GET_WLPMC_ERRINT(x)                                                \
	(((x) >> BIT_SHIFT_WLPMC_ERRINT) & BIT_MASK_WLPMC_ERRINT)
#define BIT_SET_WLPMC_ERRINT(x, v)                                             \
	(BIT_CLEAR_WLPMC_ERRINT(x) | BIT_WLPMC_ERRINT(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL7				(Offset 0x00AC) */

#define BIT_SHIFT_SEL_V 30
#define BIT_MASK_SEL_V 0x3
#define BIT_SEL_V(x) (((x) & BIT_MASK_SEL_V) << BIT_SHIFT_SEL_V)
#define BITS_SEL_V (BIT_MASK_SEL_V << BIT_SHIFT_SEL_V)
#define BIT_CLEAR_SEL_V(x) ((x) & (~BITS_SEL_V))
#define BIT_GET_SEL_V(x) (((x) >> BIT_SHIFT_SEL_V) & BIT_MASK_SEL_V)
#define BIT_SET_SEL_V(x, v) (BIT_CLEAR_SEL_V(x) | BIT_SEL_V(v))

#define BIT_SEL_LDO_PC BIT(29)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL7				(Offset 0x00AC) */

#define BIT_SHIFT_CK_MON_SEL 26
#define BIT_MASK_CK_MON_SEL 0x7
#define BIT_CK_MON_SEL(x) (((x) & BIT_MASK_CK_MON_SEL) << BIT_SHIFT_CK_MON_SEL)
#define BITS_CK_MON_SEL (BIT_MASK_CK_MON_SEL << BIT_SHIFT_CK_MON_SEL)
#define BIT_CLEAR_CK_MON_SEL(x) ((x) & (~BITS_CK_MON_SEL))
#define BIT_GET_CK_MON_SEL(x)                                                  \
	(((x) >> BIT_SHIFT_CK_MON_SEL) & BIT_MASK_CK_MON_SEL)
#define BIT_SET_CK_MON_SEL(x, v) (BIT_CLEAR_CK_MON_SEL(x) | BIT_CK_MON_SEL(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_AFE_CTRL7				(Offset 0x00AC) */

#define BIT_SHIFT_CK_MON_SEL_V2 26
#define BIT_MASK_CK_MON_SEL_V2 0x7
#define BIT_CK_MON_SEL_V2(x)                                                   \
	(((x) & BIT_MASK_CK_MON_SEL_V2) << BIT_SHIFT_CK_MON_SEL_V2)
#define BITS_CK_MON_SEL_V2 (BIT_MASK_CK_MON_SEL_V2 << BIT_SHIFT_CK_MON_SEL_V2)
#define BIT_CLEAR_CK_MON_SEL_V2(x) ((x) & (~BITS_CK_MON_SEL_V2))
#define BIT_GET_CK_MON_SEL_V2(x)                                               \
	(((x) >> BIT_SHIFT_CK_MON_SEL_V2) & BIT_MASK_CK_MON_SEL_V2)
#define BIT_SET_CK_MON_SEL_V2(x, v)                                            \
	(BIT_CLEAR_CK_MON_SEL_V2(x) | BIT_CK_MON_SEL_V2(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL7				(Offset 0x00AC) */

#define BIT_CK_MON_EN BIT(25)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_AFE_CTRL7				(Offset 0x00AC) */

#define BIT_WL_DSS_SPEED_EN BIT(25)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL7				(Offset 0x00AC) */

#define BIT_FREF_EDGE BIT(24)
#define BIT_CK320M_EN BIT(23)
#define BIT_CK_5M_EN BIT(22)
#define BIT_TESTEN BIT(21)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_AFE_CTRL7				(Offset 0x00AC) */

#define BIT_LD_B12V_EN_V1 BIT(7)

#define BIT_SHIFT_WL_DSS_COUNT_OUT 0
#define BIT_MASK_WL_DSS_COUNT_OUT 0xfffff
#define BIT_WL_DSS_COUNT_OUT(x)                                                \
	(((x) & BIT_MASK_WL_DSS_COUNT_OUT) << BIT_SHIFT_WL_DSS_COUNT_OUT)
#define BITS_WL_DSS_COUNT_OUT                                                  \
	(BIT_MASK_WL_DSS_COUNT_OUT << BIT_SHIFT_WL_DSS_COUNT_OUT)
#define BIT_CLEAR_WL_DSS_COUNT_OUT(x) ((x) & (~BITS_WL_DSS_COUNT_OUT))
#define BIT_GET_WL_DSS_COUNT_OUT(x)                                            \
	(((x) >> BIT_SHIFT_WL_DSS_COUNT_OUT) & BIT_MASK_WL_DSS_COUNT_OUT)
#define BIT_SET_WL_DSS_COUNT_OUT(x, v)                                         \
	(BIT_CLEAR_WL_DSS_COUNT_OUT(x) | BIT_WL_DSS_COUNT_OUT(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_HIMR0				(Offset 0x00B0) */

#define BIT_TIMEOUT_INTERRUPT2_MASK BIT(31)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_HIMR0				(Offset 0x00B0) */

#define BIT_PSTIMER_2_MSK BIT(31)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_HIMR0				(Offset 0x00B0) */

#define BIT_TIMEOUT_INTERRUTP1_MASK BIT(30)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_HIMR0				(Offset 0x00B0) */

#define BIT_PSTIMER_1_MSK BIT(30)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_HIMR0				(Offset 0x00B0) */

#define BIT_PSTIMEOUT_MSK BIT(29)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_HIMR0				(Offset 0x00B0) */

#define BIT_PSTIMER_0_MSK BIT(29)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_HIMR0				(Offset 0x00B0) */

#define BIT_GTINT4_MSK BIT(28)
#define BIT_GTINT4 BIT(28)
#define BIT_GTINT3_MSK BIT(27)
#define BIT_GTINT3 BIT(27)
#define BIT_TXBCN0ERR_MSK BIT(26)
#define BIT_TXBCN0ERR BIT(26)
#define BIT_TXBCN0OK_MSK BIT(25)
#define BIT_TXBCN0OK BIT(25)
#define BIT_TSF_BIT32_TOGGLE_MSK BIT(24)
#define BIT_TSF_BIT32_TOGGLE BIT(24)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_HIMR0				(Offset 0x00B0) */

#define BIT_TXDMA_START_INT_MSK BIT(23)
#define BIT_TXDMA_STOP_INT_MSK BIT(22)
#define BIT_HISR7_IND_MSK BIT(21)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_HIMR0				(Offset 0x00B0) */

#define BIT_BCNDMAINT0_MSK BIT(20)
#define BIT_BCNDMAINT0 BIT(20)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_HIMR0				(Offset 0x00B0) */

#define BIT_HISR6_IND_MSK BIT(19)

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_HIMR0				(Offset 0x00B0) */

#define BIT_HISR5_MSK BIT(18)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_HIMR0				(Offset 0x00B0) */

#define BIT_HISR5_IND_MSK BIT(18)

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_HIMR0				(Offset 0x00B0) */

#define BIT_HISR4_MSK BIT(17)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_HIMR0				(Offset 0x00B0) */

#define BIT_HISR4_IND_MSK BIT(17)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_HIMR0				(Offset 0x00B0) */

#define BIT_BCNDERR0_MSK BIT(16)
#define BIT_BCNDERR0 BIT(16)
#define BIT_HSISR_IND_ON_INT_MSK BIT(15)
#define BIT_HSISR_IND_ON_INT BIT(15)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_HIMR0				(Offset 0x00B0) */

#define BIT_BCNDMAINT_E_MSK BIT(14)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_HIMR0				(Offset 0x00B0) */

#define BIT_HISR3_IND_INT_MSK BIT(14)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_HIMR0				(Offset 0x00B0) */

#define BIT_HISR3_IND_MSK BIT(14)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_HIMR0				(Offset 0x00B0) */

#define BIT_HISR2_IND_INT_MSK BIT(13)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_HIMR0				(Offset 0x00B0) */

#define BIT_HISR2_IND_MSK BIT(13)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_HIMR0				(Offset 0x00B0) */

#define BIT_CTWEND_MSK BIT(12)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_HIMR0				(Offset 0x00B0) */

#define BIT_HISR1_IND_MSK BIT(11)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_HIMR0				(Offset 0x00B0) */

#define BIT_HISR1_IND_INT_MSK BIT(11)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_HIMR0				(Offset 0x00B0) */

#define BIT_C2HCMD_MSK BIT(10)
#define BIT_C2HCMD BIT(10)
#define BIT_CPWM2_MSK BIT(9)
#define BIT_CPWM2 BIT(9)
#define BIT_CPWM_MSK BIT(8)
#define BIT_CPWM BIT(8)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_HIMR0				(Offset 0x00B0) */

#define BIT_HIGHDOK_MSK BIT(7)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_HIMR0				(Offset 0x00B0) */

#define BIT_TXDMAOK_CHANNEL15_MSK BIT(7)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_HIMR0				(Offset 0x00B0) */

#define BIT_MGTDOK_MSK BIT(6)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_HIMR0				(Offset 0x00B0) */

#define BIT_TXDMAOK_CHANNEL14_MSK BIT(6)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_HIMR0				(Offset 0x00B0) */

#define BIT_BKDOK_MSK BIT(5)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_HIMR0				(Offset 0x00B0) */

#define BIT_TXDMAOK_CHANNEL3_MSK BIT(5)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_HIMR0				(Offset 0x00B0) */

#define BIT_BEDOK_MSK BIT(4)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_HIMR0				(Offset 0x00B0) */

#define BIT_TXDMAOK_CHANNEL2_MSK BIT(4)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_HIMR0				(Offset 0x00B0) */

#define BIT_VIDOK_MSK BIT(3)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_HIMR0				(Offset 0x00B0) */

#define BIT_TXDMAOK_CHANNEL1_MSK BIT(3)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_HIMR0				(Offset 0x00B0) */

#define BIT_VODOK_MSK BIT(2)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_HIMR0				(Offset 0x00B0) */

#define BIT_TXDMAOK_CHANNEL0_MSK BIT(2)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_HIMR0				(Offset 0x00B0) */

#define BIT_RDU_MSK BIT(1)
#define BIT_RDU BIT(1)
#define BIT_RXOK_MSK BIT(0)
#define BIT_RXOK BIT(0)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_HISR0				(Offset 0x00B4) */

#define BIT_PSTIMEOUT2 BIT(31)
#define BIT_PSTIMEOUT1 BIT(30)
#define BIT_PSTIMEOUT BIT(29)

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_HISR0				(Offset 0x00B4) */

#define BIT_HISR5_IND_INT BIT(18)
#define BIT_HISR4_IND_INT BIT(17)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_HISR0				(Offset 0x00B4) */

#define BIT_BCNDMAINT_E BIT(14)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_HISR0				(Offset 0x00B4) */

#define BIT_HISR3_IND_INT BIT(14)
#define BIT_HISR2_IND_INT BIT(13)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_HISR0				(Offset 0x00B4) */

#define BIT_CTWEND BIT(12)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_HISR0				(Offset 0x00B4) */

#define BIT_HISR1_IND_INT BIT(11)
#define BIT_HIGHDOK BIT(7)
#define BIT_MGTDOK BIT(6)
#define BIT_BKDOK BIT(5)
#define BIT_BEDOK BIT(4)
#define BIT_VIDOK BIT(3)
#define BIT_VODOK BIT(2)

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_HIMR1				(Offset 0x00B8) */

#define BIT_PRETXERR_HANDLE_MSK BIT(31)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_HIMR1				(Offset 0x00B8) */

#define BIT_PRE_TX_ERR_INT_MSK BIT(31)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_HIMR1				(Offset 0x00B8) */

#define BIT_BTON_STS_UPDATE_INT BIT(29)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT)

/* 2 REG_HIMR1				(Offset 0x00B8) */

#define BIT_BTON_STS_UPDATE_MSK BIT(29)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_HIMR1				(Offset 0x00B8) */

#define BIT_BTON_STS_UPDATE_MASK BIT(29)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_HIMR1				(Offset 0x00B8) */

#define BIT_MCU_ERR_MASK BIT(28)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_HIMR1				(Offset 0x00B8) */

#define BIT_BCNDMAINT7 BIT(27)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8881A_SUPPORT)

/* 2 REG_HIMR1				(Offset 0x00B8) */

#define BIT_BCNDMAINT7_MSK BIT(27)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_HIMR1				(Offset 0x00B8) */

#define BIT_BCNDMAINT7__MSK BIT(27)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_HIMR1				(Offset 0x00B8) */

#define BIT_BCNDMAINT6 BIT(26)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8881A_SUPPORT)

/* 2 REG_HIMR1				(Offset 0x00B8) */

#define BIT_BCNDMAINT6_MSK BIT(26)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_HIMR1				(Offset 0x00B8) */

#define BIT_BCNDMAINT6__MSK BIT(26)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_HIMR1				(Offset 0x00B8) */

#define BIT_BCNDMAINT5 BIT(25)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8881A_SUPPORT)

/* 2 REG_HIMR1				(Offset 0x00B8) */

#define BIT_BCNDMAINT5_MSK BIT(25)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_HIMR1				(Offset 0x00B8) */

#define BIT_BCNDMAINT5__MSK BIT(25)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_HIMR1				(Offset 0x00B8) */

#define BIT_BCNDMAINT4 BIT(24)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8881A_SUPPORT)

/* 2 REG_HIMR1				(Offset 0x00B8) */

#define BIT_BCNDMAINT4_MSK BIT(24)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_HIMR1				(Offset 0x00B8) */

#define BIT_BCNDMAINT4__MSK BIT(24)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_HIMR1				(Offset 0x00B8) */

#define BIT_BCNDMAINT3_MSK BIT(23)
#define BIT_BCNDMAINT3 BIT(23)
#define BIT_BCNDMAINT2_MSK BIT(22)
#define BIT_BCNDMAINT2 BIT(22)
#define BIT_BCNDMAINT1_MSK BIT(21)
#define BIT_BCNDMAINT1 BIT(21)
#define BIT_BCNDERR7_MSK BIT(20)
#define BIT_BCNDERR7 BIT(20)
#define BIT_BCNDERR6_MSK BIT(19)
#define BIT_BCNDERR6 BIT(19)
#define BIT_BCNDERR5_MSK BIT(18)
#define BIT_BCNDERR5 BIT(18)
#define BIT_BCNDERR4_MSK BIT(17)
#define BIT_BCNDERR4 BIT(17)
#define BIT_BCNDERR3_MSK BIT(16)
#define BIT_BCNDERR3 BIT(16)
#define BIT_BCNDERR2_MSK BIT(15)
#define BIT_BCNDERR2 BIT(15)
#define BIT_BCNDERR1_MSK BIT(14)
#define BIT_BCNDERR1 BIT(14)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_HIMR1				(Offset 0x00B8) */

#define BIT_ATIMEND_E_MSK BIT(13)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8881A_SUPPORT)

/* 2 REG_HIMR1				(Offset 0x00B8) */

#define BIT_ATIMEND_MSK BIT(12)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_HIMR1				(Offset 0x00B8) */

#define BIT_ATIMEND__MSK BIT(12)

#endif

#if (HALMAC_8822B_SUPPORT)

/* 2 REG_HIMR1				(Offset 0x00B8) */

#define BIT_ATIMEND_E_V1_MSK BIT(12)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_HIMR1				(Offset 0x00B8) */

#define BIT_TXERR_MSK BIT(11)
#define BIT_TXERR_INT BIT(11)
#define BIT_RXERR_MSK BIT(10)
#define BIT_RXERR_INT BIT(10)
#define BIT_TXFOVW_MSK BIT(9)
#define BIT_TXFOVW BIT(9)
#define BIT_FOVW_MSK BIT(8)
#define BIT_FOVW BIT(8)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_HIMR1				(Offset 0x00B8) */

#define BIT_CPU_MGQ_EARLY_INT_MSK BIT(6)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_HIMR1				(Offset 0x00B8) */

#define BIT_CPU_MGQ_TXDONE_MSK BIT(5)
#define BIT_CPU_MGQ_TXDONE BIT(5)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_HIMR1				(Offset 0x00B8) */

#define BIT_PS_TIMER_C_MSK BIT(4)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_HIMR1				(Offset 0x00B8) */

#define BIT_PSTIMER_5_MSK BIT(4)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_HIMR1				(Offset 0x00B8) */

#define BIT_PS_TIMER_B_MSK BIT(3)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_HIMR1				(Offset 0x00B8) */

#define BIT_PSTIMER_4_MSK BIT(3)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_HIMR1				(Offset 0x00B8) */

#define BIT_PS_TIMER_A_MSK BIT(2)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_HIMR1				(Offset 0x00B8) */

#define BIT_PSTIMER_3_MSK BIT(2)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_HIMR1				(Offset 0x00B8) */

#define BIT_CPUMGQ_TX_TIMER_MSK BIT(1)
#define BIT_CPUMGQ_TX_TIMER BIT(1)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_HIMR1				(Offset 0x00B8) */

#define BIT_BB_STOPRX_INT_MSK BIT(0)

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_HISR1				(Offset 0x00BC) */

#define BIT_PRETXERR_HANDLE_INT BIT(31)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_HISR1				(Offset 0x00BC) */

#define BIT_MCU_ERR BIT(28)
#define BIT_ATIMEND_E BIT(13)

#endif

#if (HALMAC_8822B_SUPPORT)

/* 2 REG_HISR1				(Offset 0x00BC) */

#define BIT_ATIMEND_E_V1_INT BIT(12)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_HISR1				(Offset 0x00BC) */

#define BIT_PS_TIMER_C BIT(4)
#define BIT_PS_TIMER_B BIT(3)
#define BIT_PS_TIMER_A BIT(2)

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_HISR1				(Offset 0x00BC) */

#define BIT_SHIFT_SYS_PINMUX_EN 0
#define BIT_MASK_SYS_PINMUX_EN 0xfffffff
#define BIT_SYS_PINMUX_EN(x)                                                   \
	(((x) & BIT_MASK_SYS_PINMUX_EN) << BIT_SHIFT_SYS_PINMUX_EN)
#define BITS_SYS_PINMUX_EN (BIT_MASK_SYS_PINMUX_EN << BIT_SHIFT_SYS_PINMUX_EN)
#define BIT_CLEAR_SYS_PINMUX_EN(x) ((x) & (~BITS_SYS_PINMUX_EN))
#define BIT_GET_SYS_PINMUX_EN(x)                                               \
	(((x) >> BIT_SHIFT_SYS_PINMUX_EN) & BIT_MASK_SYS_PINMUX_EN)
#define BIT_SET_SYS_PINMUX_EN(x, v)                                            \
	(BIT_CLEAR_SYS_PINMUX_EN(x) | BIT_SYS_PINMUX_EN(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_SDIO_ERR_RPT			(Offset 0x102500C0) */

#define BIT_HR_FF_OVF BIT(6)
#define BIT_HR_FF_UDN BIT(5)
#define BIT_TXDMA_BUSY_ERR BIT(4)
#define BIT_TXDMA_VLD_ERR BIT(3)
#define BIT_QSEL_UNKNOWN_ERR BIT(2)
#define BIT_QSEL_MIS_ERR BIT(1)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_DBG_PORT_SEL			(Offset 0x00C0) */

#define BIT_SHIFT_DEBUG_ST 0
#define BIT_MASK_DEBUG_ST 0xffffffffL
#define BIT_DEBUG_ST(x) (((x) & BIT_MASK_DEBUG_ST) << BIT_SHIFT_DEBUG_ST)
#define BITS_DEBUG_ST (BIT_MASK_DEBUG_ST << BIT_SHIFT_DEBUG_ST)
#define BIT_CLEAR_DEBUG_ST(x) ((x) & (~BITS_DEBUG_ST))
#define BIT_GET_DEBUG_ST(x) (((x) >> BIT_SHIFT_DEBUG_ST) & BIT_MASK_DEBUG_ST)
#define BIT_SET_DEBUG_ST(x, v) (BIT_CLEAR_DEBUG_ST(x) | BIT_DEBUG_ST(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_DIOERR_RPT			(Offset 0x102500C0) */

#define BIT_SDIO_PAGE_ERR BIT(0)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_SDIO_ERR_RPT			(Offset 0x102500C0) */

#define BIT_SDIO_OVERRD_ERR BIT(0)

#define BIT_SHIFT_SDIO_DATA_REPLY_TIME 0
#define BIT_MASK_SDIO_DATA_REPLY_TIME 0x7
#define BIT_SDIO_DATA_REPLY_TIME(x)                                            \
	(((x) & BIT_MASK_SDIO_DATA_REPLY_TIME)                                 \
	 << BIT_SHIFT_SDIO_DATA_REPLY_TIME)
#define BITS_SDIO_DATA_REPLY_TIME                                              \
	(BIT_MASK_SDIO_DATA_REPLY_TIME << BIT_SHIFT_SDIO_DATA_REPLY_TIME)
#define BIT_CLEAR_SDIO_DATA_REPLY_TIME(x) ((x) & (~BITS_SDIO_DATA_REPLY_TIME))
#define BIT_GET_SDIO_DATA_REPLY_TIME(x)                                        \
	(((x) >> BIT_SHIFT_SDIO_DATA_REPLY_TIME) &                             \
	 BIT_MASK_SDIO_DATA_REPLY_TIME)
#define BIT_SET_SDIO_DATA_REPLY_TIME(x, v)                                     \
	(BIT_CLEAR_SDIO_DATA_REPLY_TIME(x) | BIT_SDIO_DATA_REPLY_TIME(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_CMD_ERRCNT			(Offset 0x102500C2) */

#define BIT_SHIFT_CMD_CRC_ERR_CNT 0
#define BIT_MASK_CMD_CRC_ERR_CNT 0xff
#define BIT_CMD_CRC_ERR_CNT(x)                                                 \
	(((x) & BIT_MASK_CMD_CRC_ERR_CNT) << BIT_SHIFT_CMD_CRC_ERR_CNT)
#define BITS_CMD_CRC_ERR_CNT                                                   \
	(BIT_MASK_CMD_CRC_ERR_CNT << BIT_SHIFT_CMD_CRC_ERR_CNT)
#define BIT_CLEAR_CMD_CRC_ERR_CNT(x) ((x) & (~BITS_CMD_CRC_ERR_CNT))
#define BIT_GET_CMD_CRC_ERR_CNT(x)                                             \
	(((x) >> BIT_SHIFT_CMD_CRC_ERR_CNT) & BIT_MASK_CMD_CRC_ERR_CNT)
#define BIT_SET_CMD_CRC_ERR_CNT(x, v)                                          \
	(BIT_CLEAR_CMD_CRC_ERR_CNT(x) | BIT_CMD_CRC_ERR_CNT(v))

/* 2 REG_SDIO_DATA_ERRCNT			(Offset 0x102500C3) */

#define BIT_SHIFT_DATA_CRC_ERR_CNT 0
#define BIT_MASK_DATA_CRC_ERR_CNT 0xff
#define BIT_DATA_CRC_ERR_CNT(x)                                                \
	(((x) & BIT_MASK_DATA_CRC_ERR_CNT) << BIT_SHIFT_DATA_CRC_ERR_CNT)
#define BITS_DATA_CRC_ERR_CNT                                                  \
	(BIT_MASK_DATA_CRC_ERR_CNT << BIT_SHIFT_DATA_CRC_ERR_CNT)
#define BIT_CLEAR_DATA_CRC_ERR_CNT(x) ((x) & (~BITS_DATA_CRC_ERR_CNT))
#define BIT_GET_DATA_CRC_ERR_CNT(x)                                            \
	(((x) >> BIT_SHIFT_DATA_CRC_ERR_CNT) & BIT_MASK_DATA_CRC_ERR_CNT)
#define BIT_SET_DATA_CRC_ERR_CNT(x, v)                                         \
	(BIT_CLEAR_DATA_CRC_ERR_CNT(x) | BIT_DATA_CRC_ERR_CNT(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_PAD_CTRL2				(Offset 0x00C4) */

#define BIT_MAC_SOP BIT(25)
#define BIT_LDO11_ST_EXT BIT(24)
#define BIT_ANTSELB_S2 BIT(23)
#define BIT_ANTSELB_S1 BIT(22)
#define BIT_ANTSEL_S3 BIT(21)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_PAD_CTRL2				(Offset 0x00C4) */

#define BIT_USB3_USB2_TRANSITION BIT(20)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_PAD_CTRL2				(Offset 0x00C4) */

#define BIT_ANTSEL_S2 BIT(20)
#define BIT_ANTSEL_S1 BIT(19)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_PAD_CTRL2				(Offset 0x00C4) */

#define BIT_SHIFT_USB23_SW_MODE_V1 18
#define BIT_MASK_USB23_SW_MODE_V1 0x3
#define BIT_USB23_SW_MODE_V1(x)                                                \
	(((x) & BIT_MASK_USB23_SW_MODE_V1) << BIT_SHIFT_USB23_SW_MODE_V1)
#define BITS_USB23_SW_MODE_V1                                                  \
	(BIT_MASK_USB23_SW_MODE_V1 << BIT_SHIFT_USB23_SW_MODE_V1)
#define BIT_CLEAR_USB23_SW_MODE_V1(x) ((x) & (~BITS_USB23_SW_MODE_V1))
#define BIT_GET_USB23_SW_MODE_V1(x)                                            \
	(((x) >> BIT_SHIFT_USB23_SW_MODE_V1) & BIT_MASK_USB23_SW_MODE_V1)
#define BIT_SET_USB23_SW_MODE_V1(x, v)                                         \
	(BIT_CLEAR_USB23_SW_MODE_V1(x) | BIT_USB23_SW_MODE_V1(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_PAD_CTRL2				(Offset 0x00C4) */

#define BIT_FCSN_PU BIT(18)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_PAD_CTRL2				(Offset 0x00C4) */

#define BIT_NO_PDN_CHIPOFF_V1 BIT(17)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_PAD_CTRL2				(Offset 0x00C4) */

#define BIT_KEEP_PAD BIT(17)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_PAD_CTRL2				(Offset 0x00C4) */

#define BIT_RSM_EN_V1 BIT(16)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_PAD_CTRL2				(Offset 0x00C4) */

#define BIT_PAD_ALD_SKP BIT(16)
#define BIT_PAD_A_ANTSEL_E BIT(11)
#define BIT_PAD_A_ANTSELB_E BIT(10)
#define BIT_PAD_A_ANTSEL_O BIT(9)
#define BIT_PAD_A_ANTSELB_O BIT(8)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_PAD_CTRL2				(Offset 0x00C4) */

#define BIT_LD_B12V_EN BIT(7)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_PAD_CTRL2				(Offset 0x00C4) */

#define BIT_B15V_EN BIT(7)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_PAD_CTRL2				(Offset 0x00C4) */

#define BIT_EESK_IOSEL BIT(6)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_PAD_CTRL2				(Offset 0x00C4) */

#define BIT_EECS_IOSEL_V1 BIT(6)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_PAD_CTRL2				(Offset 0x00C4) */

#define BIT_EESK_DATA_O BIT(5)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_PAD_CTRL2				(Offset 0x00C4) */

#define BIT_EECS_DATA_O_V1 BIT(5)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_PAD_CTRL2				(Offset 0x00C4) */

#define BIT_EESK_DATA_I BIT(4)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_PAD_CTRL2				(Offset 0x00C4) */

#define BIT_EECS_DATA_I_V1 BIT(4)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_PAD_CTRL2				(Offset 0x00C4) */

#define BIT_EECS_IOSEL BIT(2)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_PAD_CTRL2				(Offset 0x00C4) */

#define BIT_EESK_IOSEL_V1 BIT(2)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_PAD_CTRL2				(Offset 0x00C4) */

#define BIT_EECS_DATA_O BIT(1)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_PAD_CTRL2				(Offset 0x00C4) */

#define BIT_EESK_DATA_O_V1 BIT(1)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_PAD_CTRL2				(Offset 0x00C4) */

#define BIT_EECS_DATA_I BIT(0)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_PAD_CTRL2				(Offset 0x00C4) */

#define BIT_EESK_DATA_I_V1 BIT(0)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_CMD_ERR_CONTENT		(Offset 0x102500C4) */

#define BIT_SHIFT_SDIO_CMD_ERR_CONTENT 0
#define BIT_MASK_SDIO_CMD_ERR_CONTENT 0xffffffffffL
#define BIT_SDIO_CMD_ERR_CONTENT(x)                                            \
	(((x) & BIT_MASK_SDIO_CMD_ERR_CONTENT)                                 \
	 << BIT_SHIFT_SDIO_CMD_ERR_CONTENT)
#define BITS_SDIO_CMD_ERR_CONTENT                                              \
	(BIT_MASK_SDIO_CMD_ERR_CONTENT << BIT_SHIFT_SDIO_CMD_ERR_CONTENT)
#define BIT_CLEAR_SDIO_CMD_ERR_CONTENT(x) ((x) & (~BITS_SDIO_CMD_ERR_CONTENT))
#define BIT_GET_SDIO_CMD_ERR_CONTENT(x)                                        \
	(((x) >> BIT_SHIFT_SDIO_CMD_ERR_CONTENT) &                             \
	 BIT_MASK_SDIO_CMD_ERR_CONTENT)
#define BIT_SET_SDIO_CMD_ERR_CONTENT(x, v)                                     \
	(BIT_CLEAR_SDIO_CMD_ERR_CONTENT(x) | BIT_SDIO_CMD_ERR_CONTENT(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_MEM_RMC				(Offset 0x00C8) */

#define BIT_SHIFT_MEM_RME_WL_V2 4
#define BIT_MASK_MEM_RME_WL_V2 0x3f
#define BIT_MEM_RME_WL_V2(x)                                                   \
	(((x) & BIT_MASK_MEM_RME_WL_V2) << BIT_SHIFT_MEM_RME_WL_V2)
#define BITS_MEM_RME_WL_V2 (BIT_MASK_MEM_RME_WL_V2 << BIT_SHIFT_MEM_RME_WL_V2)
#define BIT_CLEAR_MEM_RME_WL_V2(x) ((x) & (~BITS_MEM_RME_WL_V2))
#define BIT_GET_MEM_RME_WL_V2(x)                                               \
	(((x) >> BIT_SHIFT_MEM_RME_WL_V2) & BIT_MASK_MEM_RME_WL_V2)
#define BIT_SET_MEM_RME_WL_V2(x, v)                                            \
	(BIT_CLEAR_MEM_RME_WL_V2(x) | BIT_MEM_RME_WL_V2(v))

#define BIT_SHIFT_MEM_RME_HCI_V2 0
#define BIT_MASK_MEM_RME_HCI_V2 0x1f
#define BIT_MEM_RME_HCI_V2(x)                                                  \
	(((x) & BIT_MASK_MEM_RME_HCI_V2) << BIT_SHIFT_MEM_RME_HCI_V2)
#define BITS_MEM_RME_HCI_V2                                                    \
	(BIT_MASK_MEM_RME_HCI_V2 << BIT_SHIFT_MEM_RME_HCI_V2)
#define BIT_CLEAR_MEM_RME_HCI_V2(x) ((x) & (~BITS_MEM_RME_HCI_V2))
#define BIT_GET_MEM_RME_HCI_V2(x)                                              \
	(((x) >> BIT_SHIFT_MEM_RME_HCI_V2) & BIT_MASK_MEM_RME_HCI_V2)
#define BIT_SET_MEM_RME_HCI_V2(x, v)                                           \
	(BIT_CLEAR_MEM_RME_HCI_V2(x) | BIT_MEM_RME_HCI_V2(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_CRC_ERR_IDX			(Offset 0x102500C9) */

#define BIT_D3_CRC_ERR BIT(4)
#define BIT_D2_CRC_ERR BIT(3)
#define BIT_D1_CRC_ERR BIT(2)
#define BIT_D0_CRC_ERR BIT(1)
#define BIT_CMD_CRC_ERR BIT(0)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_DATA_CRC			(Offset 0x102500CA) */

#define BIT_SHIFT_SDIO_DATA_CRC 0
#define BIT_MASK_SDIO_DATA_CRC 0xffff
#define BIT_SDIO_DATA_CRC(x)                                                   \
	(((x) & BIT_MASK_SDIO_DATA_CRC) << BIT_SHIFT_SDIO_DATA_CRC)
#define BITS_SDIO_DATA_CRC (BIT_MASK_SDIO_DATA_CRC << BIT_SHIFT_SDIO_DATA_CRC)
#define BIT_CLEAR_SDIO_DATA_CRC(x) ((x) & (~BITS_SDIO_DATA_CRC))
#define BIT_GET_SDIO_DATA_CRC(x)                                               \
	(((x) >> BIT_SHIFT_SDIO_DATA_CRC) & BIT_MASK_SDIO_DATA_CRC)
#define BIT_SET_SDIO_DATA_CRC(x, v)                                            \
	(BIT_CLEAR_SDIO_DATA_CRC(x) | BIT_SDIO_DATA_CRC(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_PMC_DBG_CTRL2			(Offset 0x00CC) */

#define BIT_SHIFT_EFUSE_BURN_GNT 24
#define BIT_MASK_EFUSE_BURN_GNT 0xff
#define BIT_EFUSE_BURN_GNT(x)                                                  \
	(((x) & BIT_MASK_EFUSE_BURN_GNT) << BIT_SHIFT_EFUSE_BURN_GNT)
#define BITS_EFUSE_BURN_GNT                                                    \
	(BIT_MASK_EFUSE_BURN_GNT << BIT_SHIFT_EFUSE_BURN_GNT)
#define BIT_CLEAR_EFUSE_BURN_GNT(x) ((x) & (~BITS_EFUSE_BURN_GNT))
#define BIT_GET_EFUSE_BURN_GNT(x)                                              \
	(((x) >> BIT_SHIFT_EFUSE_BURN_GNT) & BIT_MASK_EFUSE_BURN_GNT)
#define BIT_SET_EFUSE_BURN_GNT(x, v)                                           \
	(BIT_CLEAR_EFUSE_BURN_GNT(x) | BIT_EFUSE_BURN_GNT(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_PMC_DBG_CTRL2			(Offset 0x00CC) */

#define BIT_SHIFT_EFUSE_PG_PWD 24
#define BIT_MASK_EFUSE_PG_PWD 0xff
#define BIT_EFUSE_PG_PWD(x)                                                    \
	(((x) & BIT_MASK_EFUSE_PG_PWD) << BIT_SHIFT_EFUSE_PG_PWD)
#define BITS_EFUSE_PG_PWD (BIT_MASK_EFUSE_PG_PWD << BIT_SHIFT_EFUSE_PG_PWD)
#define BIT_CLEAR_EFUSE_PG_PWD(x) ((x) & (~BITS_EFUSE_PG_PWD))
#define BIT_GET_EFUSE_PG_PWD(x)                                                \
	(((x) >> BIT_SHIFT_EFUSE_PG_PWD) & BIT_MASK_EFUSE_PG_PWD)
#define BIT_SET_EFUSE_PG_PWD(x, v)                                             \
	(BIT_CLEAR_EFUSE_PG_PWD(x) | BIT_EFUSE_PG_PWD(v))

#endif

#if (HALMAC_8197G_SUPPORT)

/* 2 REG_PMC_DBG_CTRL2			(Offset 0x00CC) */

#define BIT_MEM_TEST1 BIT(17)
#define BIT_MEM_LS BIT(16)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_PMC_DBG_CTRL2			(Offset 0x00CC) */

#define BIT_DBG_READ_EN BIT(16)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_PMC_DBG_CTRL2			(Offset 0x00CC) */

#define BIT_STOP_WL_PMC BIT(9)
#define BIT_STOP_SYM_PMC BIT(8)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_PMC_DBG_CTRL2			(Offset 0x00CC) */

#define BIT_SHIFT_EDATA1_V1 8
#define BIT_MASK_EDATA1_V1 0xff
#define BIT_EDATA1_V1(x) (((x) & BIT_MASK_EDATA1_V1) << BIT_SHIFT_EDATA1_V1)
#define BITS_EDATA1_V1 (BIT_MASK_EDATA1_V1 << BIT_SHIFT_EDATA1_V1)
#define BIT_CLEAR_EDATA1_V1(x) ((x) & (~BITS_EDATA1_V1))
#define BIT_GET_EDATA1_V1(x) (((x) >> BIT_SHIFT_EDATA1_V1) & BIT_MASK_EDATA1_V1)
#define BIT_SET_EDATA1_V1(x, v) (BIT_CLEAR_EDATA1_V1(x) | BIT_EDATA1_V1(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_PMC_DBG_CTRL2			(Offset 0x00CC) */

#define BIT_BT_ACCESS_WL_PAGE0 BIT(6)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_PMC_DBG_CTRL2			(Offset 0x00CC) */

#define BIT_REG_RST_WLPMC BIT(5)
#define BIT_REG_RST_PD12N BIT(4)
#define BIT_SYSON_DIS_WLREG_WRMSK BIT(3)

#endif

#if (HALMAC_8197G_SUPPORT)

/* 2 REG_PMC_DBG_CTRL2			(Offset 0x00CC) */

#define BIT_SYM_LPS_STATUS BIT(3)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_PMC_DBG_CTRL2			(Offset 0x00CC) */

#define BIT_SYSON_DIS_PMCREG_WRMSK BIT(2)

#endif

#if (HALMAC_8197G_SUPPORT)

/* 2 REG_PMC_DBG_CTRL2			(Offset 0x00CC) */

#define BIT_SYM_HCI_TXDMA_BUSY BIT(2)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_TRANS_FIFO_STATUS		(Offset 0x102500CC) */

#define BIT_TRANS_FIFO_UNDERFLOW BIT(1)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_PMC_DBG_CTRL2			(Offset 0x00CC) */

#define BIT_SHIFT_SYSON_REG_ARB 0
#define BIT_MASK_SYSON_REG_ARB 0x3
#define BIT_SYSON_REG_ARB(x)                                                   \
	(((x) & BIT_MASK_SYSON_REG_ARB) << BIT_SHIFT_SYSON_REG_ARB)
#define BITS_SYSON_REG_ARB (BIT_MASK_SYSON_REG_ARB << BIT_SHIFT_SYSON_REG_ARB)
#define BIT_CLEAR_SYSON_REG_ARB(x) ((x) & (~BITS_SYSON_REG_ARB))
#define BIT_GET_SYSON_REG_ARB(x)                                               \
	(((x) >> BIT_SHIFT_SYSON_REG_ARB) & BIT_MASK_SYSON_REG_ARB)
#define BIT_SET_SYSON_REG_ARB(x, v)                                            \
	(BIT_CLEAR_SYSON_REG_ARB(x) | BIT_SYSON_REG_ARB(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SDIO_TRANS_FIFO_STATUS		(Offset 0x102500CC) */

#define BIT_TRANS_FIFO_OVERFLOW BIT(0)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_PMC_DBG_CTRL2			(Offset 0x00CC) */

#define BIT_SHIFT_EDATA0_V1 0
#define BIT_MASK_EDATA0_V1 0xff
#define BIT_EDATA0_V1(x) (((x) & BIT_MASK_EDATA0_V1) << BIT_SHIFT_EDATA0_V1)
#define BITS_EDATA0_V1 (BIT_MASK_EDATA0_V1 << BIT_SHIFT_EDATA0_V1)
#define BIT_CLEAR_EDATA0_V1(x) ((x) & (~BITS_EDATA0_V1))
#define BIT_GET_EDATA0_V1(x) (((x) >> BIT_SHIFT_EDATA0_V1) & BIT_MASK_EDATA0_V1)
#define BIT_SET_EDATA0_V1(x, v) (BIT_CLEAR_EDATA0_V1(x) | BIT_EDATA0_V1(v))

/* 2 REG_BIST_CTRL				(Offset 0x00D0) */

#define BIT_SCAN_PLL_BYPASS BIT(30)
#define BIT_DRF_BIST_FAIL_V1 BIT(28)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_BIST_CTRL				(Offset 0x00D0) */

#define BIT_BIST_USB_DIS BIT(27)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_BIST_CTRL				(Offset 0x00D0) */

#define BIT_DRF_BIST_READY_V1 BIT(27)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_BIST_CTRL				(Offset 0x00D0) */

#define BIT_BIST_PCI_DIS BIT(26)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_BIST_CTRL				(Offset 0x00D0) */

#define BIT_BIST_FAIL_V1 BIT(26)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_BIST_CTRL				(Offset 0x00D0) */

#define BIT_BIST_BT_DIS BIT(25)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_BIST_CTRL				(Offset 0x00D0) */

#define BIT_BIST_READY_V1 BIT(25)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_BIST_CTRL				(Offset 0x00D0) */

#define BIT_BIST_WL_DIS BIT(24)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_BIST_CTRL				(Offset 0x00D0) */

#define BIT_BIST_START_PAUSE_V1 BIT(24)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197G_SUPPORT)

/* 2 REG_BIST_CTRL				(Offset 0x00D0) */

#define BIT_SHIFT_BIST_RPT_SEL_V1 20
#define BIT_MASK_BIST_RPT_SEL_V1 0xf
#define BIT_BIST_RPT_SEL_V1(x)                                                 \
	(((x) & BIT_MASK_BIST_RPT_SEL_V1) << BIT_SHIFT_BIST_RPT_SEL_V1)
#define BITS_BIST_RPT_SEL_V1                                                   \
	(BIT_MASK_BIST_RPT_SEL_V1 << BIT_SHIFT_BIST_RPT_SEL_V1)
#define BIT_CLEAR_BIST_RPT_SEL_V1(x) ((x) & (~BITS_BIST_RPT_SEL_V1))
#define BIT_GET_BIST_RPT_SEL_V1(x)                                             \
	(((x) >> BIT_SHIFT_BIST_RPT_SEL_V1) & BIT_MASK_BIST_RPT_SEL_V1)
#define BIT_SET_BIST_RPT_SEL_V1(x, v)                                          \
	(BIT_CLEAR_BIST_RPT_SEL_V1(x) | BIT_BIST_RPT_SEL_V1(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_BIST_CTRL				(Offset 0x00D0) */

#define BIT_SHIFT_BIST_RPT_SEL 16
#define BIT_MASK_BIST_RPT_SEL 0xf
#define BIT_BIST_RPT_SEL(x)                                                    \
	(((x) & BIT_MASK_BIST_RPT_SEL) << BIT_SHIFT_BIST_RPT_SEL)
#define BITS_BIST_RPT_SEL (BIT_MASK_BIST_RPT_SEL << BIT_SHIFT_BIST_RPT_SEL)
#define BIT_CLEAR_BIST_RPT_SEL(x) ((x) & (~BITS_BIST_RPT_SEL))
#define BIT_GET_BIST_RPT_SEL(x)                                                \
	(((x) >> BIT_SHIFT_BIST_RPT_SEL) & BIT_MASK_BIST_RPT_SEL)
#define BIT_SET_BIST_RPT_SEL(x, v)                                             \
	(BIT_CLEAR_BIST_RPT_SEL(x) | BIT_BIST_RPT_SEL(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_BIST_CTRL				(Offset 0x00D0) */

#define BIT_SHIFT_MBIST_RSTNI 8
#define BIT_MASK_MBIST_RSTNI 0x3ff
#define BIT_MBIST_RSTNI(x)                                                     \
	(((x) & BIT_MASK_MBIST_RSTNI) << BIT_SHIFT_MBIST_RSTNI)
#define BITS_MBIST_RSTNI (BIT_MASK_MBIST_RSTNI << BIT_SHIFT_MBIST_RSTNI)
#define BIT_CLEAR_MBIST_RSTNI(x) ((x) & (~BITS_MBIST_RSTNI))
#define BIT_GET_MBIST_RSTNI(x)                                                 \
	(((x) >> BIT_SHIFT_MBIST_RSTNI) & BIT_MASK_MBIST_RSTNI)
#define BIT_SET_MBIST_RSTNI(x, v)                                              \
	(BIT_CLEAR_MBIST_RSTNI(x) | BIT_MBIST_RSTNI(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197G_SUPPORT)

/* 2 REG_BIST_CTRL				(Offset 0x00D0) */

#define BIT_BISD_MODE BIT(6)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT)

/* 2 REG_BIST_CTRL				(Offset 0x00D0) */

#define BIT_BIST_RESUME_PS_V1 BIT(5)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_BIST_CTRL				(Offset 0x00D0) */

#define BIT_BIST_RESUME_PS BIT(4)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT)

/* 2 REG_BIST_CTRL				(Offset 0x00D0) */

#define BIT_BIST_RESUME_V1 BIT(4)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_BIST_CTRL				(Offset 0x00D0) */

#define BIT_BIST_RESUME BIT(3)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197G_SUPPORT)

/* 2 REG_BIST_CTRL				(Offset 0x00D0) */

#define BIT_BIST_DRF BIT(3)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_BIST_CTRL				(Offset 0x00D0) */

#define BIT_BIST_NORMAL BIT(2)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_BIST_CTRL				(Offset 0x00D0) */

#define BIT_SHIFT_BIST_MODE 2
#define BIT_MASK_BIST_MODE 0x3
#define BIT_BIST_MODE(x) (((x) & BIT_MASK_BIST_MODE) << BIT_SHIFT_BIST_MODE)
#define BITS_BIST_MODE (BIT_MASK_BIST_MODE << BIT_SHIFT_BIST_MODE)
#define BIT_CLEAR_BIST_MODE(x) ((x) & (~BITS_BIST_MODE))
#define BIT_GET_BIST_MODE(x) (((x) >> BIT_SHIFT_BIST_MODE) & BIT_MASK_BIST_MODE)
#define BIT_SET_BIST_MODE(x, v) (BIT_CLEAR_BIST_MODE(x) | BIT_BIST_MODE(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_BIST_CTRL				(Offset 0x00D0) */

#define BIT_BIST_RSTN BIT(1)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197G_SUPPORT)

/* 2 REG_BIST_CTRL				(Offset 0x00D0) */

#define BIT_SYM_HCI_TADMA_ALLOW BIT(1)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_BIST_CTRL				(Offset 0x00D0) */

#define BIT_BIST_CLK_EN BIT(0)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197G_SUPPORT)

/* 2 REG_BIST_CTRL				(Offset 0x00D0) */

#define BIT_SYM_FW_CTL_HCI_TXDMA_EN BIT(0)

#define BIT_SHIFT_TDE_H2C_RD_ADDR 0
#define BIT_MASK_TDE_H2C_RD_ADDR 0x3ffff
#define BIT_TDE_H2C_RD_ADDR(x)                                                 \
	(((x) & BIT_MASK_TDE_H2C_RD_ADDR) << BIT_SHIFT_TDE_H2C_RD_ADDR)
#define BITS_TDE_H2C_RD_ADDR                                                   \
	(BIT_MASK_TDE_H2C_RD_ADDR << BIT_SHIFT_TDE_H2C_RD_ADDR)
#define BIT_CLEAR_TDE_H2C_RD_ADDR(x) ((x) & (~BITS_TDE_H2C_RD_ADDR))
#define BIT_GET_TDE_H2C_RD_ADDR(x)                                             \
	(((x) >> BIT_SHIFT_TDE_H2C_RD_ADDR) & BIT_MASK_TDE_H2C_RD_ADDR)
#define BIT_SET_TDE_H2C_RD_ADDR(x, v)                                          \
	(BIT_CLEAR_TDE_H2C_RD_ADDR(x) | BIT_TDE_H2C_RD_ADDR(v))

#define BIT_SHIFT_TDE_H2C_WR_ADDR 0
#define BIT_MASK_TDE_H2C_WR_ADDR 0x3ffff
#define BIT_TDE_H2C_WR_ADDR(x)                                                 \
	(((x) & BIT_MASK_TDE_H2C_WR_ADDR) << BIT_SHIFT_TDE_H2C_WR_ADDR)
#define BITS_TDE_H2C_WR_ADDR                                                   \
	(BIT_MASK_TDE_H2C_WR_ADDR << BIT_SHIFT_TDE_H2C_WR_ADDR)
#define BIT_CLEAR_TDE_H2C_WR_ADDR(x) ((x) & (~BITS_TDE_H2C_WR_ADDR))
#define BIT_GET_TDE_H2C_WR_ADDR(x)                                             \
	(((x) >> BIT_SHIFT_TDE_H2C_WR_ADDR) & BIT_MASK_TDE_H2C_WR_ADDR)
#define BIT_SET_TDE_H2C_WR_ADDR(x, v)                                          \
	(BIT_CLEAR_TDE_H2C_WR_ADDR(x) | BIT_TDE_H2C_WR_ADDR(v))

#define BIT_SHIFT_BCAM_CTRL 0
#define BIT_MASK_BCAM_CTRL 0xffffffffL
#define BIT_BCAM_CTRL(x) (((x) & BIT_MASK_BCAM_CTRL) << BIT_SHIFT_BCAM_CTRL)
#define BITS_BCAM_CTRL (BIT_MASK_BCAM_CTRL << BIT_SHIFT_BCAM_CTRL)
#define BIT_CLEAR_BCAM_CTRL(x) ((x) & (~BITS_BCAM_CTRL))
#define BIT_GET_BCAM_CTRL(x) (((x) >> BIT_SHIFT_BCAM_CTRL) & BIT_MASK_BCAM_CTRL)
#define BIT_SET_BCAM_CTRL(x, v) (BIT_CLEAR_BCAM_CTRL(x) | BIT_BCAM_CTRL(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_BIST_RPT				(Offset 0x00D4) */

#define BIT_SHIFT_MBIST_REPORT 0
#define BIT_MASK_MBIST_REPORT 0xffffffffL
#define BIT_MBIST_REPORT(x)                                                    \
	(((x) & BIT_MASK_MBIST_REPORT) << BIT_SHIFT_MBIST_REPORT)
#define BITS_MBIST_REPORT (BIT_MASK_MBIST_REPORT << BIT_SHIFT_MBIST_REPORT)
#define BIT_CLEAR_MBIST_REPORT(x) ((x) & (~BITS_MBIST_REPORT))
#define BIT_GET_MBIST_REPORT(x)                                                \
	(((x) >> BIT_SHIFT_MBIST_REPORT) & BIT_MASK_MBIST_REPORT)
#define BIT_SET_MBIST_REPORT(x, v)                                             \
	(BIT_CLEAR_MBIST_REPORT(x) | BIT_MBIST_REPORT(v))

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_MEM_CTRL				(Offset 0x00D8) */

#define BIT_RMV_SIGN BIT(31)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_MEM_CTRL				(Offset 0x00D8) */

#define BIT_UMEM_RME BIT(31)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_MEM_CTRL				(Offset 0x00D8) */

#define BIT_RMV_2PRF1 BIT(29)

#endif

#if (HALMAC_8198F_SUPPORT)

/* 2 REG_MEM_CTRL				(Offset 0x00D8) */

#define BIT_2PRF1_RMV BIT(29)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_MEM_CTRL				(Offset 0x00D8) */

#define BIT_RMV_2PRF0 BIT(28)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_MEM_CTRL				(Offset 0x00D8) */

#define BIT_SHIFT_BT_SPRAM 28
#define BIT_MASK_BT_SPRAM 0x3
#define BIT_BT_SPRAM(x) (((x) & BIT_MASK_BT_SPRAM) << BIT_SHIFT_BT_SPRAM)
#define BITS_BT_SPRAM (BIT_MASK_BT_SPRAM << BIT_SHIFT_BT_SPRAM)
#define BIT_CLEAR_BT_SPRAM(x) ((x) & (~BITS_BT_SPRAM))
#define BIT_GET_BT_SPRAM(x) (((x) >> BIT_SHIFT_BT_SPRAM) & BIT_MASK_BT_SPRAM)
#define BIT_SET_BT_SPRAM(x, v) (BIT_CLEAR_BT_SPRAM(x) | BIT_BT_SPRAM(v))

#endif

#if (HALMAC_8198F_SUPPORT)

/* 2 REG_MEM_CTRL				(Offset 0x00D8) */

#define BIT_2PRF0_RMV BIT(28)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_MEM_CTRL				(Offset 0x00D8) */

#define BIT_RMV_1PRF1 BIT(27)

#endif

#if (HALMAC_8198F_SUPPORT)

/* 2 REG_MEM_CTRL				(Offset 0x00D8) */

#define BIT_1PRF1_RMV BIT(27)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_MEM_CTRL				(Offset 0x00D8) */

#define BIT_RMV_1PRF0 BIT(26)

#endif

#if (HALMAC_8198F_SUPPORT)

/* 2 REG_MEM_CTRL				(Offset 0x00D8) */

#define BIT_1PRF0_RMV BIT(26)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_MEM_CTRL				(Offset 0x00D8) */

#define BIT_RMV_1PSR BIT(25)

#endif

#if (HALMAC_8198F_SUPPORT)

/* 2 REG_MEM_CTRL				(Offset 0x00D8) */

#define BIT_1PSR_RMV BIT(25)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_MEM_CTRL				(Offset 0x00D8) */

#define BIT_RMV_ROM BIT(24)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_MEM_CTRL				(Offset 0x00D8) */

#define BIT_SHIFT_BT_ROM 24
#define BIT_MASK_BT_ROM 0xf
#define BIT_BT_ROM(x) (((x) & BIT_MASK_BT_ROM) << BIT_SHIFT_BT_ROM)
#define BITS_BT_ROM (BIT_MASK_BT_ROM << BIT_SHIFT_BT_ROM)
#define BIT_CLEAR_BT_ROM(x) ((x) & (~BITS_BT_ROM))
#define BIT_GET_BT_ROM(x) (((x) >> BIT_SHIFT_BT_ROM) & BIT_MASK_BT_ROM)
#define BIT_SET_BT_ROM(x, v) (BIT_CLEAR_BT_ROM(x) | BIT_BT_ROM(v))

#endif

#if (HALMAC_8198F_SUPPORT)

/* 2 REG_MEM_CTRL				(Offset 0x00D8) */

#define BIT_ROM_RMV BIT(24)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_MEM_CTRL				(Offset 0x00D8) */

#define BIT_MEM_RMV1_2PRF1 BIT(19)

#endif

#if (HALMAC_8198F_SUPPORT)

/* 2 REG_MEM_CTRL				(Offset 0x00D8) */

#define BIT_2PRF1_RMV1 BIT(19)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_MEM_CTRL				(Offset 0x00D8) */

#define BIT_MEM_RMV1_2PRF0 BIT(18)

#endif

#if (HALMAC_8198F_SUPPORT)

/* 2 REG_MEM_CTRL				(Offset 0x00D8) */

#define BIT_2PRF0_RMV1 BIT(18)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_MEM_CTRL				(Offset 0x00D8) */

#define BIT_MEM_RMV1_1PRF1 BIT(17)

#endif

#if (HALMAC_8198F_SUPPORT)

/* 2 REG_MEM_CTRL				(Offset 0x00D8) */

#define BIT_1PRF1_RMV1 BIT(17)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_MEM_CTRL				(Offset 0x00D8) */

#define BIT_MEM_RMV1_1PRF0 BIT(16)

#endif

#if (HALMAC_8198F_SUPPORT)

/* 2 REG_MEM_CTRL				(Offset 0x00D8) */

#define BIT_1PRF0_RMV1 BIT(16)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_MEM_CTRL				(Offset 0x00D8) */

#define BIT_MEM_RMV1_1PSR BIT(15)

#endif

#if (HALMAC_8198F_SUPPORT)

/* 2 REG_MEM_CTRL				(Offset 0x00D8) */

#define BIT_1PSR_RMV1 BIT(15)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_MEM_CTRL				(Offset 0x00D8) */

#define BIT_MEM_RMV1_ROM BIT(14)

#endif

#if (HALMAC_8198F_SUPPORT)

/* 2 REG_MEM_CTRL				(Offset 0x00D8) */

#define BIT_ROM_RMV1 BIT(14)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_MEM_CTRL				(Offset 0x00D8) */

#define BIT_SHIFT_PCI_DPRAM 10
#define BIT_MASK_PCI_DPRAM 0x3
#define BIT_PCI_DPRAM(x) (((x) & BIT_MASK_PCI_DPRAM) << BIT_SHIFT_PCI_DPRAM)
#define BITS_PCI_DPRAM (BIT_MASK_PCI_DPRAM << BIT_SHIFT_PCI_DPRAM)
#define BIT_CLEAR_PCI_DPRAM(x) ((x) & (~BITS_PCI_DPRAM))
#define BIT_GET_PCI_DPRAM(x) (((x) >> BIT_SHIFT_PCI_DPRAM) & BIT_MASK_PCI_DPRAM)
#define BIT_SET_PCI_DPRAM(x, v) (BIT_CLEAR_PCI_DPRAM(x) | BIT_PCI_DPRAM(v))

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_MEM_CTRL				(Offset 0x00D8) */

#define BIT_SHIFT_MEM_RME_BT 8
#define BIT_MASK_MEM_RME_BT 0xf
#define BIT_MEM_RME_BT(x) (((x) & BIT_MASK_MEM_RME_BT) << BIT_SHIFT_MEM_RME_BT)
#define BITS_MEM_RME_BT (BIT_MASK_MEM_RME_BT << BIT_SHIFT_MEM_RME_BT)
#define BIT_CLEAR_MEM_RME_BT(x) ((x) & (~BITS_MEM_RME_BT))
#define BIT_GET_MEM_RME_BT(x)                                                  \
	(((x) >> BIT_SHIFT_MEM_RME_BT) & BIT_MASK_MEM_RME_BT)
#define BIT_SET_MEM_RME_BT(x, v) (BIT_CLEAR_MEM_RME_BT(x) | BIT_MEM_RME_BT(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_MEM_CTRL				(Offset 0x00D8) */

#define BIT_SHIFT_PCI_SPRAM 8
#define BIT_MASK_PCI_SPRAM 0x3
#define BIT_PCI_SPRAM(x) (((x) & BIT_MASK_PCI_SPRAM) << BIT_SHIFT_PCI_SPRAM)
#define BITS_PCI_SPRAM (BIT_MASK_PCI_SPRAM << BIT_SHIFT_PCI_SPRAM)
#define BIT_CLEAR_PCI_SPRAM(x) ((x) & (~BITS_PCI_SPRAM))
#define BIT_GET_PCI_SPRAM(x) (((x) >> BIT_SHIFT_PCI_SPRAM) & BIT_MASK_PCI_SPRAM)
#define BIT_SET_PCI_SPRAM(x, v) (BIT_CLEAR_PCI_SPRAM(x) | BIT_PCI_SPRAM(v))

#define BIT_SHIFT_USB_SPRAM 6
#define BIT_MASK_USB_SPRAM 0x3
#define BIT_USB_SPRAM(x) (((x) & BIT_MASK_USB_SPRAM) << BIT_SHIFT_USB_SPRAM)
#define BITS_USB_SPRAM (BIT_MASK_USB_SPRAM << BIT_SHIFT_USB_SPRAM)
#define BIT_CLEAR_USB_SPRAM(x) ((x) & (~BITS_USB_SPRAM))
#define BIT_GET_USB_SPRAM(x) (((x) >> BIT_SHIFT_USB_SPRAM) & BIT_MASK_USB_SPRAM)
#define BIT_SET_USB_SPRAM(x, v) (BIT_CLEAR_USB_SPRAM(x) | BIT_USB_SPRAM(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT)

/* 2 REG_MEM_CTRL				(Offset 0x00D8) */

#define BIT_SHIFT_MEM_RME_WL 4
#define BIT_MASK_MEM_RME_WL 0xf
#define BIT_MEM_RME_WL(x) (((x) & BIT_MASK_MEM_RME_WL) << BIT_SHIFT_MEM_RME_WL)
#define BITS_MEM_RME_WL (BIT_MASK_MEM_RME_WL << BIT_SHIFT_MEM_RME_WL)
#define BIT_CLEAR_MEM_RME_WL(x) ((x) & (~BITS_MEM_RME_WL))
#define BIT_GET_MEM_RME_WL(x)                                                  \
	(((x) >> BIT_SHIFT_MEM_RME_WL) & BIT_MASK_MEM_RME_WL)
#define BIT_SET_MEM_RME_WL(x, v) (BIT_CLEAR_MEM_RME_WL(x) | BIT_MEM_RME_WL(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_MEM_CTRL				(Offset 0x00D8) */

#define BIT_SHIFT_USB_SPRF 4
#define BIT_MASK_USB_SPRF 0x3
#define BIT_USB_SPRF(x) (((x) & BIT_MASK_USB_SPRF) << BIT_SHIFT_USB_SPRF)
#define BITS_USB_SPRF (BIT_MASK_USB_SPRF << BIT_SHIFT_USB_SPRF)
#define BIT_CLEAR_USB_SPRF(x) ((x) & (~BITS_USB_SPRF))
#define BIT_GET_USB_SPRF(x) (((x) >> BIT_SHIFT_USB_SPRF) & BIT_MASK_USB_SPRF)
#define BIT_SET_USB_SPRF(x, v) (BIT_CLEAR_USB_SPRF(x) | BIT_USB_SPRF(v))

#endif

#if (HALMAC_8198F_SUPPORT)

/* 2 REG_MEM_CTRL				(Offset 0x00D8) */

#define BIT_SHIFT_WL_RME 4
#define BIT_MASK_WL_RME 0xf
#define BIT_WL_RME(x) (((x) & BIT_MASK_WL_RME) << BIT_SHIFT_WL_RME)
#define BITS_WL_RME (BIT_MASK_WL_RME << BIT_SHIFT_WL_RME)
#define BIT_CLEAR_WL_RME(x) ((x) & (~BITS_WL_RME))
#define BIT_GET_WL_RME(x) (((x) >> BIT_SHIFT_WL_RME) & BIT_MASK_WL_RME)
#define BIT_SET_WL_RME(x, v) (BIT_CLEAR_WL_RME(x) | BIT_WL_RME(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT)

/* 2 REG_MEM_CTRL				(Offset 0x00D8) */

#define BIT_SHIFT_MEM_RME_HCI 0
#define BIT_MASK_MEM_RME_HCI 0xf
#define BIT_MEM_RME_HCI(x)                                                     \
	(((x) & BIT_MASK_MEM_RME_HCI) << BIT_SHIFT_MEM_RME_HCI)
#define BITS_MEM_RME_HCI (BIT_MASK_MEM_RME_HCI << BIT_SHIFT_MEM_RME_HCI)
#define BIT_CLEAR_MEM_RME_HCI(x) ((x) & (~BITS_MEM_RME_HCI))
#define BIT_GET_MEM_RME_HCI(x)                                                 \
	(((x) >> BIT_SHIFT_MEM_RME_HCI) & BIT_MASK_MEM_RME_HCI)
#define BIT_SET_MEM_RME_HCI(x, v)                                              \
	(BIT_CLEAR_MEM_RME_HCI(x) | BIT_MEM_RME_HCI(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_MEM_CTRL				(Offset 0x00D8) */

#define BIT_SHIFT_MCU_ROM 0
#define BIT_MASK_MCU_ROM 0xf
#define BIT_MCU_ROM(x) (((x) & BIT_MASK_MCU_ROM) << BIT_SHIFT_MCU_ROM)
#define BITS_MCU_ROM (BIT_MASK_MCU_ROM << BIT_SHIFT_MCU_ROM)
#define BIT_CLEAR_MCU_ROM(x) ((x) & (~BITS_MCU_ROM))
#define BIT_GET_MCU_ROM(x) (((x) >> BIT_SHIFT_MCU_ROM) & BIT_MASK_MCU_ROM)
#define BIT_SET_MCU_ROM(x, v) (BIT_CLEAR_MCU_ROM(x) | BIT_MCU_ROM(v))

#endif

#if (HALMAC_8198F_SUPPORT)

/* 2 REG_MEM_CTRL				(Offset 0x00D8) */

#define BIT_SHIFT_HCI_RME 0
#define BIT_MASK_HCI_RME 0xf
#define BIT_HCI_RME(x) (((x) & BIT_MASK_HCI_RME) << BIT_SHIFT_HCI_RME)
#define BITS_HCI_RME (BIT_MASK_HCI_RME << BIT_SHIFT_HCI_RME)
#define BIT_CLEAR_HCI_RME(x) ((x) & (~BITS_HCI_RME))
#define BIT_GET_HCI_RME(x) (((x) >> BIT_SHIFT_HCI_RME) & BIT_MASK_HCI_RME)
#define BIT_SET_HCI_RME(x, v) (BIT_CLEAR_HCI_RME(x) | BIT_HCI_RME(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_MEM_CTRL				(Offset 0x00D8) */

#define BIT_SHIFT_BIST_ROM 0
#define BIT_MASK_BIST_ROM 0xffffffffL
#define BIT_BIST_ROM(x) (((x) & BIT_MASK_BIST_ROM) << BIT_SHIFT_BIST_ROM)
#define BITS_BIST_ROM (BIT_MASK_BIST_ROM << BIT_SHIFT_BIST_ROM)
#define BIT_CLEAR_BIST_ROM(x) ((x) & (~BITS_BIST_ROM))
#define BIT_GET_BIST_ROM(x) (((x) >> BIT_SHIFT_BIST_ROM) & BIT_MASK_BIST_ROM)
#define BIT_SET_BIST_ROM(x, v) (BIT_CLEAR_BIST_ROM(x) | BIT_BIST_ROM(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT)

/* 2 REG_AFE_CTRL8				(Offset 0x00DC) */

#define BIT_SHIFT_BB_DBG_SEL_AFE_SDM_V4 26
#define BIT_MASK_BB_DBG_SEL_AFE_SDM_V4 0x7
#define BIT_BB_DBG_SEL_AFE_SDM_V4(x)                                           \
	(((x) & BIT_MASK_BB_DBG_SEL_AFE_SDM_V4)                                \
	 << BIT_SHIFT_BB_DBG_SEL_AFE_SDM_V4)
#define BITS_BB_DBG_SEL_AFE_SDM_V4                                             \
	(BIT_MASK_BB_DBG_SEL_AFE_SDM_V4 << BIT_SHIFT_BB_DBG_SEL_AFE_SDM_V4)
#define BIT_CLEAR_BB_DBG_SEL_AFE_SDM_V4(x) ((x) & (~BITS_BB_DBG_SEL_AFE_SDM_V4))
#define BIT_GET_BB_DBG_SEL_AFE_SDM_V4(x)                                       \
	(((x) >> BIT_SHIFT_BB_DBG_SEL_AFE_SDM_V4) &                            \
	 BIT_MASK_BB_DBG_SEL_AFE_SDM_V4)
#define BIT_SET_BB_DBG_SEL_AFE_SDM_V4(x, v)                                    \
	(BIT_CLEAR_BB_DBG_SEL_AFE_SDM_V4(x) | BIT_BB_DBG_SEL_AFE_SDM_V4(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL8				(Offset 0x00DC) */

#define BIT_SYN_AGPIO BIT(20)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_SYN_RFC_CTRL			(Offset 0x00DC) */

#define BIT_SHIFT_SYN_RF1_CTRL 8
#define BIT_MASK_SYN_RF1_CTRL 0xff
#define BIT_SYN_RF1_CTRL(x)                                                    \
	(((x) & BIT_MASK_SYN_RF1_CTRL) << BIT_SHIFT_SYN_RF1_CTRL)
#define BITS_SYN_RF1_CTRL (BIT_MASK_SYN_RF1_CTRL << BIT_SHIFT_SYN_RF1_CTRL)
#define BIT_CLEAR_SYN_RF1_CTRL(x) ((x) & (~BITS_SYN_RF1_CTRL))
#define BIT_GET_SYN_RF1_CTRL(x)                                                \
	(((x) >> BIT_SHIFT_SYN_RF1_CTRL) & BIT_MASK_SYN_RF1_CTRL)
#define BIT_SET_SYN_RF1_CTRL(x, v)                                             \
	(BIT_CLEAR_SYN_RF1_CTRL(x) | BIT_SYN_RF1_CTRL(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_AFE_CTRL8				(Offset 0x00DC) */

#define BIT_SHIFT_XTAL_GM_REP 6
#define BIT_MASK_XTAL_GM_REP 0x3
#define BIT_XTAL_GM_REP(x)                                                     \
	(((x) & BIT_MASK_XTAL_GM_REP) << BIT_SHIFT_XTAL_GM_REP)
#define BITS_XTAL_GM_REP (BIT_MASK_XTAL_GM_REP << BIT_SHIFT_XTAL_GM_REP)
#define BIT_CLEAR_XTAL_GM_REP(x) ((x) & (~BITS_XTAL_GM_REP))
#define BIT_GET_XTAL_GM_REP(x)                                                 \
	(((x) >> BIT_SHIFT_XTAL_GM_REP) & BIT_MASK_XTAL_GM_REP)
#define BIT_SET_XTAL_GM_REP(x, v)                                              \
	(BIT_CLEAR_XTAL_GM_REP(x) | BIT_XTAL_GM_REP(v))

#define BIT_XTAL_DRV_RF_LATCH_V5 BIT(5)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL8				(Offset 0x00DC) */

#define BIT_XTAL_LP BIT(4)
#define BIT_XTAL_GM_SEP BIT(3)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT)

/* 2 REG_AFE_CTRL8				(Offset 0x00DC) */

#define BIT_SHIFT_XTAL_SEL_TOK_V2 0
#define BIT_MASK_XTAL_SEL_TOK_V2 0x7
#define BIT_XTAL_SEL_TOK_V2(x)                                                 \
	(((x) & BIT_MASK_XTAL_SEL_TOK_V2) << BIT_SHIFT_XTAL_SEL_TOK_V2)
#define BITS_XTAL_SEL_TOK_V2                                                   \
	(BIT_MASK_XTAL_SEL_TOK_V2 << BIT_SHIFT_XTAL_SEL_TOK_V2)
#define BIT_CLEAR_XTAL_SEL_TOK_V2(x) ((x) & (~BITS_XTAL_SEL_TOK_V2))
#define BIT_GET_XTAL_SEL_TOK_V2(x)                                             \
	(((x) >> BIT_SHIFT_XTAL_SEL_TOK_V2) & BIT_MASK_XTAL_SEL_TOK_V2)
#define BIT_SET_XTAL_SEL_TOK_V2(x, v)                                          \
	(BIT_CLEAR_XTAL_SEL_TOK_V2(x) | BIT_XTAL_SEL_TOK_V2(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_WLAN_DBG				(Offset 0x00DC) */

#define BIT_SHIFT_WLAN_DBG 0
#define BIT_MASK_WLAN_DBG 0xffffffffL
#define BIT_WLAN_DBG(x) (((x) & BIT_MASK_WLAN_DBG) << BIT_SHIFT_WLAN_DBG)
#define BITS_WLAN_DBG (BIT_MASK_WLAN_DBG << BIT_SHIFT_WLAN_DBG)
#define BIT_CLEAR_WLAN_DBG(x) ((x) & (~BITS_WLAN_DBG))
#define BIT_GET_WLAN_DBG(x) (((x) >> BIT_SHIFT_WLAN_DBG) & BIT_MASK_WLAN_DBG)
#define BIT_SET_WLAN_DBG(x, v) (BIT_CLEAR_WLAN_DBG(x) | BIT_WLAN_DBG(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_SYN_RFC_CTRL			(Offset 0x00DC) */

#define BIT_SHIFT_SYN_RF0_CTRL 0
#define BIT_MASK_SYN_RF0_CTRL 0xff
#define BIT_SYN_RF0_CTRL(x)                                                    \
	(((x) & BIT_MASK_SYN_RF0_CTRL) << BIT_SHIFT_SYN_RF0_CTRL)
#define BITS_SYN_RF0_CTRL (BIT_MASK_SYN_RF0_CTRL << BIT_SHIFT_SYN_RF0_CTRL)
#define BIT_CLEAR_SYN_RF0_CTRL(x) ((x) & (~BITS_SYN_RF0_CTRL))
#define BIT_GET_SYN_RF0_CTRL(x)                                                \
	(((x) >> BIT_SHIFT_SYN_RF0_CTRL) & BIT_MASK_SYN_RF0_CTRL)
#define BIT_SET_SYN_RF0_CTRL(x, v)                                             \
	(BIT_CLEAR_SYN_RF0_CTRL(x) | BIT_SYN_RF0_CTRL(v))

#endif

#if (HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AFE_CTRL8				(Offset 0x00DC) */

#define BIT_SHIFT_XTAL_SEL_TOK 0
#define BIT_MASK_XTAL_SEL_TOK 0x7
#define BIT_XTAL_SEL_TOK(x)                                                    \
	(((x) & BIT_MASK_XTAL_SEL_TOK) << BIT_SHIFT_XTAL_SEL_TOK)
#define BITS_XTAL_SEL_TOK (BIT_MASK_XTAL_SEL_TOK << BIT_SHIFT_XTAL_SEL_TOK)
#define BIT_CLEAR_XTAL_SEL_TOK(x) ((x) & (~BITS_XTAL_SEL_TOK))
#define BIT_GET_XTAL_SEL_TOK(x)                                                \
	(((x) >> BIT_SHIFT_XTAL_SEL_TOK) & BIT_MASK_XTAL_SEL_TOK)
#define BIT_SET_XTAL_SEL_TOK(x, v)                                             \
	(BIT_CLEAR_XTAL_SEL_TOK(x) | BIT_XTAL_SEL_TOK(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_USB_SIE_INTF			(Offset 0x00E0) */

#define BIT_RD_SEL BIT(31)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_USB_SIE_INTF			(Offset 0x00E0) */

#define BIT_CPU_REG_SEL BIT(31)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_USB_SIE_INTF			(Offset 0x00E0) */

#define BIT_USB_SIE_INTF_WE_V1 BIT(30)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_USB_SIE_INTF			(Offset 0x00E0) */

#define BIT_USB3_REG_SEL BIT(30)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_USB_SIE_INTF			(Offset 0x00E0) */

#define BIT_USB_SIE_INTF_BYIOREG_V1 BIT(29)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_USB_SIE_INTF			(Offset 0x00E0) */

#define BIT_SHIFT_USB_SIE_EN 28
#define BIT_MASK_USB_SIE_EN 0x3
#define BIT_USB_SIE_EN(x) (((x) & BIT_MASK_USB_SIE_EN) << BIT_SHIFT_USB_SIE_EN)
#define BITS_USB_SIE_EN (BIT_MASK_USB_SIE_EN << BIT_SHIFT_USB_SIE_EN)
#define BIT_CLEAR_USB_SIE_EN(x) ((x) & (~BITS_USB_SIE_EN))
#define BIT_GET_USB_SIE_EN(x)                                                  \
	(((x) >> BIT_SHIFT_USB_SIE_EN) & BIT_MASK_USB_SIE_EN)
#define BIT_SET_USB_SIE_EN(x, v) (BIT_CLEAR_USB_SIE_EN(x) | BIT_USB_SIE_EN(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_USB_SIE_INTF			(Offset 0x00E0) */

#define BIT_USB_SIE_SELECT BIT(28)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8881A_SUPPORT)

/* 2 REG_USB_SIE_INTF			(Offset 0x00E0) */

#define BIT_USB_SIE_INTF_WE BIT(25)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_USB_SIE_INTF			(Offset 0x00E0) */

#define BIT_USB_SIE_INTF_BYIOREG BIT(24)

#define BIT_SHIFT_USB_SIE_INTF_ADDR 16
#define BIT_MASK_USB_SIE_INTF_ADDR 0xff
#define BIT_USB_SIE_INTF_ADDR(x)                                               \
	(((x) & BIT_MASK_USB_SIE_INTF_ADDR) << BIT_SHIFT_USB_SIE_INTF_ADDR)
#define BITS_USB_SIE_INTF_ADDR                                                 \
	(BIT_MASK_USB_SIE_INTF_ADDR << BIT_SHIFT_USB_SIE_INTF_ADDR)
#define BIT_CLEAR_USB_SIE_INTF_ADDR(x) ((x) & (~BITS_USB_SIE_INTF_ADDR))
#define BIT_GET_USB_SIE_INTF_ADDR(x)                                           \
	(((x) >> BIT_SHIFT_USB_SIE_INTF_ADDR) & BIT_MASK_USB_SIE_INTF_ADDR)
#define BIT_SET_USB_SIE_INTF_ADDR(x, v)                                        \
	(BIT_CLEAR_USB_SIE_INTF_ADDR(x) | BIT_USB_SIE_INTF_ADDR(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_USB_SIE_INTF			(Offset 0x00E0) */

#define BIT_SHIFT_USB_SIE_INTF_ADDR_V1 16
#define BIT_MASK_USB_SIE_INTF_ADDR_V1 0x1ff
#define BIT_USB_SIE_INTF_ADDR_V1(x)                                            \
	(((x) & BIT_MASK_USB_SIE_INTF_ADDR_V1)                                 \
	 << BIT_SHIFT_USB_SIE_INTF_ADDR_V1)
#define BITS_USB_SIE_INTF_ADDR_V1                                              \
	(BIT_MASK_USB_SIE_INTF_ADDR_V1 << BIT_SHIFT_USB_SIE_INTF_ADDR_V1)
#define BIT_CLEAR_USB_SIE_INTF_ADDR_V1(x) ((x) & (~BITS_USB_SIE_INTF_ADDR_V1))
#define BIT_GET_USB_SIE_INTF_ADDR_V1(x)                                        \
	(((x) >> BIT_SHIFT_USB_SIE_INTF_ADDR_V1) &                             \
	 BIT_MASK_USB_SIE_INTF_ADDR_V1)
#define BIT_SET_USB_SIE_INTF_ADDR_V1(x, v)                                     \
	(BIT_CLEAR_USB_SIE_INTF_ADDR_V1(x) | BIT_USB_SIE_INTF_ADDR_V1(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_USB_SIE_INTF			(Offset 0x00E0) */

#define BIT_SHIFT_USB_SIE_INTF_RD 8
#define BIT_MASK_USB_SIE_INTF_RD 0xff
#define BIT_USB_SIE_INTF_RD(x)                                                 \
	(((x) & BIT_MASK_USB_SIE_INTF_RD) << BIT_SHIFT_USB_SIE_INTF_RD)
#define BITS_USB_SIE_INTF_RD                                                   \
	(BIT_MASK_USB_SIE_INTF_RD << BIT_SHIFT_USB_SIE_INTF_RD)
#define BIT_CLEAR_USB_SIE_INTF_RD(x) ((x) & (~BITS_USB_SIE_INTF_RD))
#define BIT_GET_USB_SIE_INTF_RD(x)                                             \
	(((x) >> BIT_SHIFT_USB_SIE_INTF_RD) & BIT_MASK_USB_SIE_INTF_RD)
#define BIT_SET_USB_SIE_INTF_RD(x, v)                                          \
	(BIT_CLEAR_USB_SIE_INTF_RD(x) | BIT_USB_SIE_INTF_RD(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_USB_SIE_INTF			(Offset 0x00E0) */

#define BIT_SHIFT_NPQ_AVAL_PG 8
#define BIT_MASK_NPQ_AVAL_PG 0xff
#define BIT_NPQ_AVAL_PG(x)                                                     \
	(((x) & BIT_MASK_NPQ_AVAL_PG) << BIT_SHIFT_NPQ_AVAL_PG)
#define BITS_NPQ_AVAL_PG (BIT_MASK_NPQ_AVAL_PG << BIT_SHIFT_NPQ_AVAL_PG)
#define BIT_CLEAR_NPQ_AVAL_PG(x) ((x) & (~BITS_NPQ_AVAL_PG))
#define BIT_GET_NPQ_AVAL_PG(x)                                                 \
	(((x) >> BIT_SHIFT_NPQ_AVAL_PG) & BIT_MASK_NPQ_AVAL_PG)
#define BIT_SET_NPQ_AVAL_PG(x, v)                                              \
	(BIT_CLEAR_NPQ_AVAL_PG(x) | BIT_NPQ_AVAL_PG(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_USB_SIE_INTF			(Offset 0x00E0) */

#define BIT_SHIFT_USB_SIE_INTF_WD 0
#define BIT_MASK_USB_SIE_INTF_WD 0xff
#define BIT_USB_SIE_INTF_WD(x)                                                 \
	(((x) & BIT_MASK_USB_SIE_INTF_WD) << BIT_SHIFT_USB_SIE_INTF_WD)
#define BITS_USB_SIE_INTF_WD                                                   \
	(BIT_MASK_USB_SIE_INTF_WD << BIT_SHIFT_USB_SIE_INTF_WD)
#define BIT_CLEAR_USB_SIE_INTF_WD(x) ((x) & (~BITS_USB_SIE_INTF_WD))
#define BIT_GET_USB_SIE_INTF_WD(x)                                             \
	(((x) >> BIT_SHIFT_USB_SIE_INTF_WD) & BIT_MASK_USB_SIE_INTF_WD)
#define BIT_SET_USB_SIE_INTF_WD(x, v)                                          \
	(BIT_CLEAR_USB_SIE_INTF_WD(x) | BIT_USB_SIE_INTF_WD(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_PCIE_MIO_INTF			(Offset 0x00E4) */

#define BIT_PCIE_MIO_EXIT_L1 BIT(19)
#define BIT_PCIE_MIO_EXT BIT(18)
#define BIT_PCIE_MIO_ACK BIT(17)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_PCIE_MIO_INTF			(Offset 0x00E4) */

#define BIT_PCIE_MIO_RIO BIT(16)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_PCIE_MIO_INTF			(Offset 0x00E4) */

#define BIT_SHIFT_PCIE_MIO_ADDR_PAGE 16
#define BIT_MASK_PCIE_MIO_ADDR_PAGE 0x3
#define BIT_PCIE_MIO_ADDR_PAGE(x)                                              \
	(((x) & BIT_MASK_PCIE_MIO_ADDR_PAGE) << BIT_SHIFT_PCIE_MIO_ADDR_PAGE)
#define BITS_PCIE_MIO_ADDR_PAGE                                                \
	(BIT_MASK_PCIE_MIO_ADDR_PAGE << BIT_SHIFT_PCIE_MIO_ADDR_PAGE)
#define BIT_CLEAR_PCIE_MIO_ADDR_PAGE(x) ((x) & (~BITS_PCIE_MIO_ADDR_PAGE))
#define BIT_GET_PCIE_MIO_ADDR_PAGE(x)                                          \
	(((x) >> BIT_SHIFT_PCIE_MIO_ADDR_PAGE) & BIT_MASK_PCIE_MIO_ADDR_PAGE)
#define BIT_SET_PCIE_MIO_ADDR_PAGE(x, v)                                       \
	(BIT_CLEAR_PCIE_MIO_ADDR_PAGE(x) | BIT_PCIE_MIO_ADDR_PAGE(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_PCIE_MIO_INTF			(Offset 0x00E4) */

#define BIT_PCIE_MIO_IOREG BIT(16)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_PCIE_MIO_INTF			(Offset 0x00E4) */

#define BIT_PCIE_MIO_BYIOREG BIT(13)
#define BIT_PCIE_MIO_RE BIT(12)

#define BIT_SHIFT_PCIE_MIO_WE 8
#define BIT_MASK_PCIE_MIO_WE 0xf
#define BIT_PCIE_MIO_WE(x)                                                     \
	(((x) & BIT_MASK_PCIE_MIO_WE) << BIT_SHIFT_PCIE_MIO_WE)
#define BITS_PCIE_MIO_WE (BIT_MASK_PCIE_MIO_WE << BIT_SHIFT_PCIE_MIO_WE)
#define BIT_CLEAR_PCIE_MIO_WE(x) ((x) & (~BITS_PCIE_MIO_WE))
#define BIT_GET_PCIE_MIO_WE(x)                                                 \
	(((x) >> BIT_SHIFT_PCIE_MIO_WE) & BIT_MASK_PCIE_MIO_WE)
#define BIT_SET_PCIE_MIO_WE(x, v)                                              \
	(BIT_CLEAR_PCIE_MIO_WE(x) | BIT_PCIE_MIO_WE(v))

#define BIT_SHIFT_PCIE_MIO_ADDR 0
#define BIT_MASK_PCIE_MIO_ADDR 0xff
#define BIT_PCIE_MIO_ADDR(x)                                                   \
	(((x) & BIT_MASK_PCIE_MIO_ADDR) << BIT_SHIFT_PCIE_MIO_ADDR)
#define BITS_PCIE_MIO_ADDR (BIT_MASK_PCIE_MIO_ADDR << BIT_SHIFT_PCIE_MIO_ADDR)
#define BIT_CLEAR_PCIE_MIO_ADDR(x) ((x) & (~BITS_PCIE_MIO_ADDR))
#define BIT_GET_PCIE_MIO_ADDR(x)                                               \
	(((x) >> BIT_SHIFT_PCIE_MIO_ADDR) & BIT_MASK_PCIE_MIO_ADDR)
#define BIT_SET_PCIE_MIO_ADDR(x, v)                                            \
	(BIT_CLEAR_PCIE_MIO_ADDR(x) | BIT_PCIE_MIO_ADDR(v))

/* 2 REG_PCIE_MIO_INTD			(Offset 0x00E8) */

#define BIT_SHIFT_PCIE_MIO_DATA 0
#define BIT_MASK_PCIE_MIO_DATA 0xffffffffL
#define BIT_PCIE_MIO_DATA(x)                                                   \
	(((x) & BIT_MASK_PCIE_MIO_DATA) << BIT_SHIFT_PCIE_MIO_DATA)
#define BITS_PCIE_MIO_DATA (BIT_MASK_PCIE_MIO_DATA << BIT_SHIFT_PCIE_MIO_DATA)
#define BIT_CLEAR_PCIE_MIO_DATA(x) ((x) & (~BITS_PCIE_MIO_DATA))
#define BIT_GET_PCIE_MIO_DATA(x)                                               \
	(((x) >> BIT_SHIFT_PCIE_MIO_DATA) & BIT_MASK_PCIE_MIO_DATA)
#define BIT_SET_PCIE_MIO_DATA(x, v)                                            \
	(BIT_CLEAR_PCIE_MIO_DATA(x) | BIT_PCIE_MIO_DATA(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_HPON_FSM				(Offset 0x00EC) */

#define BIT_SUSPEND_V1 BIT(31)

#endif

#if (HALMAC_8822C_SUPPORT)

/* 2 REG_WLRF1				(Offset 0x00EC) */

#define BIT_S1_RFC_WO_0 BIT(31)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_HPON_FSM				(Offset 0x00EC) */

#define BIT_FSM_RESUME_V1 BIT(30)

#endif

#if (HALMAC_8822C_SUPPORT)

/* 2 REG_WLRF1				(Offset 0x00EC) */

#define BIT_S1_RFC_WT_0 BIT(30)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_HPON_FSM				(Offset 0x00EC) */

#define BIT_HOST_RESUME_SYNC_V1 BIT(29)
#define BIT_CHIP_PDNB_V1 BIT(28)

#define BIT_SHIFT_FSM_SUSPEND_V1 25
#define BIT_MASK_FSM_SUSPEND_V1 0x7
#define BIT_FSM_SUSPEND_V1(x)                                                  \
	(((x) & BIT_MASK_FSM_SUSPEND_V1) << BIT_SHIFT_FSM_SUSPEND_V1)
#define BITS_FSM_SUSPEND_V1                                                    \
	(BIT_MASK_FSM_SUSPEND_V1 << BIT_SHIFT_FSM_SUSPEND_V1)
#define BIT_CLEAR_FSM_SUSPEND_V1(x) ((x) & (~BITS_FSM_SUSPEND_V1))
#define BIT_GET_FSM_SUSPEND_V1(x)                                              \
	(((x) >> BIT_SHIFT_FSM_SUSPEND_V1) & BIT_MASK_FSM_SUSPEND_V1)
#define BIT_SET_FSM_SUSPEND_V1(x, v)                                           \
	(BIT_CLEAR_FSM_SUSPEND_V1(x) | BIT_FSM_SUSPEND_V1(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_WLRF1				(Offset 0x00EC) */

#define BIT_SHIFT_XTAL_SEL 25
#define BIT_MASK_XTAL_SEL 0x3
#define BIT_XTAL_SEL(x) (((x) & BIT_MASK_XTAL_SEL) << BIT_SHIFT_XTAL_SEL)
#define BITS_XTAL_SEL (BIT_MASK_XTAL_SEL << BIT_SHIFT_XTAL_SEL)
#define BIT_CLEAR_XTAL_SEL(x) ((x) & (~BITS_XTAL_SEL))
#define BIT_GET_XTAL_SEL(x) (((x) >> BIT_SHIFT_XTAL_SEL) & BIT_MASK_XTAL_SEL)
#define BIT_SET_XTAL_SEL(x, v) (BIT_CLEAR_XTAL_SEL(x) | BIT_XTAL_SEL(v))

#endif

#if (HALMAC_8822C_SUPPORT)

/* 2 REG_WLRF1				(Offset 0x00EC) */

#define BIT_S1_RFC_RSTB BIT(25)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT)

/* 2 REG_WLRF1				(Offset 0x00EC) */

#define BIT_SHIFT_WLRF1_CTRL 24
#define BIT_MASK_WLRF1_CTRL 0xff
#define BIT_WLRF1_CTRL(x) (((x) & BIT_MASK_WLRF1_CTRL) << BIT_SHIFT_WLRF1_CTRL)
#define BITS_WLRF1_CTRL (BIT_MASK_WLRF1_CTRL << BIT_SHIFT_WLRF1_CTRL)
#define BIT_CLEAR_WLRF1_CTRL(x) ((x) & (~BITS_WLRF1_CTRL))
#define BIT_GET_WLRF1_CTRL(x)                                                  \
	(((x) >> BIT_SHIFT_WLRF1_CTRL) & BIT_MASK_WLRF1_CTRL)
#define BIT_SET_WLRF1_CTRL(x, v) (BIT_CLEAR_WLRF1_CTRL(x) | BIT_WLRF1_CTRL(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_HPON_FSM				(Offset 0x00EC) */

#define BIT_PMC_ALD_V1 BIT(24)

#define BIT_SHIFT_HCI_SEL_1 22
#define BIT_MASK_HCI_SEL_1 0x3
#define BIT_HCI_SEL_1(x) (((x) & BIT_MASK_HCI_SEL_1) << BIT_SHIFT_HCI_SEL_1)
#define BITS_HCI_SEL_1 (BIT_MASK_HCI_SEL_1 << BIT_SHIFT_HCI_SEL_1)
#define BIT_CLEAR_HCI_SEL_1(x) ((x) & (~BITS_HCI_SEL_1))
#define BIT_GET_HCI_SEL_1(x) (((x) >> BIT_SHIFT_HCI_SEL_1) & BIT_MASK_HCI_SEL_1)
#define BIT_SET_HCI_SEL_1(x, v) (BIT_CLEAR_HCI_SEL_1(x) | BIT_HCI_SEL_1(v))

#define BIT_LOAD_DONE_V1 BIT(21)
#define BIT_CNT_MATCH BIT(20)
#define BIT_TIMEUP_V1 BIT(19)
#define BIT_SPS_12V_VLD BIT(18)
#define BIT_PCIERST_V1 BIT(17)
#define BIT_HOST_CLK_VLD BIT(16)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_WLRF1				(Offset 0x00EC) */

#define BIT_SHIFT_WLRF2_CTRL 16
#define BIT_MASK_WLRF2_CTRL 0xff
#define BIT_WLRF2_CTRL(x) (((x) & BIT_MASK_WLRF2_CTRL) << BIT_SHIFT_WLRF2_CTRL)
#define BITS_WLRF2_CTRL (BIT_MASK_WLRF2_CTRL << BIT_SHIFT_WLRF2_CTRL)
#define BIT_CLEAR_WLRF2_CTRL(x) ((x) & (~BITS_WLRF2_CTRL))
#define BIT_GET_WLRF2_CTRL(x)                                                  \
	(((x) >> BIT_SHIFT_WLRF2_CTRL) & BIT_MASK_WLRF2_CTRL)
#define BIT_SET_WLRF2_CTRL(x, v) (BIT_CLEAR_WLRF2_CTRL(x) | BIT_WLRF2_CTRL(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_HPON_FSM				(Offset 0x00EC) */

#define BIT_PMC_WR_V1 BIT(15)
#define BIT_PMC_DATA_V1 BIT(14)

#endif

#if (HALMAC_8822C_SUPPORT)

/* 2 REG_WLRF1				(Offset 0x00EC) */

#define BIT_XTAL_PEAKDET_OUT BIT(9)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_HPON_FSM				(Offset 0x00EC) */

#define BIT_SHIFT_PMC_ADDR_V1 8
#define BIT_MASK_PMC_ADDR_V1 0x3f
#define BIT_PMC_ADDR_V1(x)                                                     \
	(((x) & BIT_MASK_PMC_ADDR_V1) << BIT_SHIFT_PMC_ADDR_V1)
#define BITS_PMC_ADDR_V1 (BIT_MASK_PMC_ADDR_V1 << BIT_SHIFT_PMC_ADDR_V1)
#define BIT_CLEAR_PMC_ADDR_V1(x) ((x) & (~BITS_PMC_ADDR_V1))
#define BIT_GET_PMC_ADDR_V1(x)                                                 \
	(((x) >> BIT_SHIFT_PMC_ADDR_V1) & BIT_MASK_PMC_ADDR_V1)
#define BIT_SET_PMC_ADDR_V1(x, v)                                              \
	(BIT_CLEAR_PMC_ADDR_V1(x) | BIT_PMC_ADDR_V1(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_WLRF1				(Offset 0x00EC) */

#define BIT_SHIFT_WLRF3_CTRL 8
#define BIT_MASK_WLRF3_CTRL 0xff
#define BIT_WLRF3_CTRL(x) (((x) & BIT_MASK_WLRF3_CTRL) << BIT_SHIFT_WLRF3_CTRL)
#define BITS_WLRF3_CTRL (BIT_MASK_WLRF3_CTRL << BIT_SHIFT_WLRF3_CTRL)
#define BIT_CLEAR_WLRF3_CTRL(x) ((x) & (~BITS_WLRF3_CTRL))
#define BIT_GET_WLRF3_CTRL(x)                                                  \
	(((x) >> BIT_SHIFT_WLRF3_CTRL) & BIT_MASK_WLRF3_CTRL)
#define BIT_SET_WLRF3_CTRL(x, v) (BIT_CLEAR_WLRF3_CTRL(x) | BIT_WLRF3_CTRL(v))

#endif

#if (HALMAC_8822C_SUPPORT)

/* 2 REG_WLRF1				(Offset 0x00EC) */

#define BIT_XAAC_BUSY BIT(8)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_HPON_FSM				(Offset 0x00EC) */

#define BIT_PMC_COUNT_EN_V1 BIT(7)

#endif

#if (HALMAC_8822C_SUPPORT)

/* 2 REG_WLRF1				(Offset 0x00EC) */

#define BIT_XAAC_READY_V1 BIT(7)

#define BIT_SHIFT_XAAC_PK_SEL 5
#define BIT_MASK_XAAC_PK_SEL 0x3
#define BIT_XAAC_PK_SEL(x)                                                     \
	(((x) & BIT_MASK_XAAC_PK_SEL) << BIT_SHIFT_XAAC_PK_SEL)
#define BITS_XAAC_PK_SEL (BIT_MASK_XAAC_PK_SEL << BIT_SHIFT_XAAC_PK_SEL)
#define BIT_CLEAR_XAAC_PK_SEL(x) ((x) & (~BITS_XAAC_PK_SEL))
#define BIT_GET_XAAC_PK_SEL(x)                                                 \
	(((x) >> BIT_SHIFT_XAAC_PK_SEL) & BIT_MASK_XAAC_PK_SEL)
#define BIT_SET_XAAC_PK_SEL(x, v)                                              \
	(BIT_CLEAR_XAAC_PK_SEL(x) | BIT_XAAC_PK_SEL(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_HPON_FSM				(Offset 0x00EC) */

#define BIT_SHIFT_FSM_STATE_V1 0
#define BIT_MASK_FSM_STATE_V1 0x7f
#define BIT_FSM_STATE_V1(x)                                                    \
	(((x) & BIT_MASK_FSM_STATE_V1) << BIT_SHIFT_FSM_STATE_V1)
#define BITS_FSM_STATE_V1 (BIT_MASK_FSM_STATE_V1 << BIT_SHIFT_FSM_STATE_V1)
#define BIT_CLEAR_FSM_STATE_V1(x) ((x) & (~BITS_FSM_STATE_V1))
#define BIT_GET_FSM_STATE_V1(x)                                                \
	(((x) >> BIT_SHIFT_FSM_STATE_V1) & BIT_MASK_FSM_STATE_V1)
#define BIT_SET_FSM_STATE_V1(x, v)                                             \
	(BIT_CLEAR_FSM_STATE_V1(x) | BIT_FSM_STATE_V1(v))

#endif

#if (HALMAC_8822C_SUPPORT)

/* 2 REG_WLRF1				(Offset 0x00EC) */

#define BIT_SHIFT_XTAL_GM_OUT 0
#define BIT_MASK_XTAL_GM_OUT 0x1f
#define BIT_XTAL_GM_OUT(x)                                                     \
	(((x) & BIT_MASK_XTAL_GM_OUT) << BIT_SHIFT_XTAL_GM_OUT)
#define BITS_XTAL_GM_OUT (BIT_MASK_XTAL_GM_OUT << BIT_SHIFT_XTAL_GM_OUT)
#define BIT_CLEAR_XTAL_GM_OUT(x) ((x) & (~BITS_XTAL_GM_OUT))
#define BIT_GET_XTAL_GM_OUT(x)                                                 \
	(((x) >> BIT_SHIFT_XTAL_GM_OUT) & BIT_MASK_XTAL_GM_OUT)
#define BIT_SET_XTAL_GM_OUT(x, v)                                              \
	(BIT_CLEAR_XTAL_GM_OUT(x) | BIT_XTAL_GM_OUT(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_CFG1				(Offset 0x00F0) */

#define BIT_SHIFT_TRP_ICFG 28
#define BIT_MASK_TRP_ICFG 0xf
#define BIT_TRP_ICFG(x) (((x) & BIT_MASK_TRP_ICFG) << BIT_SHIFT_TRP_ICFG)
#define BITS_TRP_ICFG (BIT_MASK_TRP_ICFG << BIT_SHIFT_TRP_ICFG)
#define BIT_CLEAR_TRP_ICFG(x) ((x) & (~BITS_TRP_ICFG))
#define BIT_GET_TRP_ICFG(x) (((x) >> BIT_SHIFT_TRP_ICFG) & BIT_MASK_TRP_ICFG)
#define BIT_SET_TRP_ICFG(x, v) (BIT_CLEAR_TRP_ICFG(x) | BIT_TRP_ICFG(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_CFG1				(Offset 0x00F0) */

#define BIT_RF_TYPE_ID BIT(27)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_CFG1				(Offset 0x00F0) */

#define BIT_BD_HCI_SEL BIT(26)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_CFG1				(Offset 0x00F0) */

#define BIT_LDO_VLD BIT(26)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_CFG1				(Offset 0x00F0) */

#define BIT_SHIFT_BD_HCI_SEL_V1 26
#define BIT_MASK_BD_HCI_SEL_V1 0x3
#define BIT_BD_HCI_SEL_V1(x)                                                   \
	(((x) & BIT_MASK_BD_HCI_SEL_V1) << BIT_SHIFT_BD_HCI_SEL_V1)
#define BITS_BD_HCI_SEL_V1 (BIT_MASK_BD_HCI_SEL_V1 << BIT_SHIFT_BD_HCI_SEL_V1)
#define BIT_CLEAR_BD_HCI_SEL_V1(x) ((x) & (~BITS_BD_HCI_SEL_V1))
#define BIT_GET_BD_HCI_SEL_V1(x)                                               \
	(((x) >> BIT_SHIFT_BD_HCI_SEL_V1) & BIT_MASK_BD_HCI_SEL_V1)
#define BIT_SET_BD_HCI_SEL_V1(x, v)                                            \
	(BIT_CLEAR_BD_HCI_SEL_V1(x) | BIT_BD_HCI_SEL_V1(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_CFG1				(Offset 0x00F0) */

#define BIT_BD_PKG_SEL BIT(25)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_CFG1				(Offset 0x00F0) */

#define BIT_SPSLDO_SEL BIT(24)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SYS_CFG1				(Offset 0x00F0) */

#define BIT_INTERNAL_EXTERNAL_SWR BIT(24)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_CFG1				(Offset 0x00F0) */

#define BIT_LDO_SPS_SEL BIT(24)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_CFG1				(Offset 0x00F0) */

#define BIT_RTL_ID BIT(23)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_CFG1				(Offset 0x00F0) */

#define BIT_PAD_HWPD_IDN BIT(22)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_CFG1				(Offset 0x00F0) */

#define BIT_DIS_WL BIT(22)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_CFG1				(Offset 0x00F0) */

#define BIT_TESTMODE BIT(20)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_CFG1				(Offset 0x00F0) */

#define BIT_SHIFT_PSC_TESTCFG 20
#define BIT_MASK_PSC_TESTCFG 0x3
#define BIT_PSC_TESTCFG(x)                                                     \
	(((x) & BIT_MASK_PSC_TESTCFG) << BIT_SHIFT_PSC_TESTCFG)
#define BITS_PSC_TESTCFG (BIT_MASK_PSC_TESTCFG << BIT_SHIFT_PSC_TESTCFG)
#define BIT_CLEAR_PSC_TESTCFG(x) ((x) & (~BITS_PSC_TESTCFG))
#define BIT_GET_PSC_TESTCFG(x)                                                 \
	(((x) >> BIT_SHIFT_PSC_TESTCFG) & BIT_MASK_PSC_TESTCFG)
#define BIT_SET_PSC_TESTCFG(x, v)                                              \
	(BIT_CLEAR_PSC_TESTCFG(x) | BIT_PSC_TESTCFG(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_CFG1				(Offset 0x00F0) */

#define BIT_SHIFT_VENDOR_ID 16
#define BIT_MASK_VENDOR_ID 0xf
#define BIT_VENDOR_ID(x) (((x) & BIT_MASK_VENDOR_ID) << BIT_SHIFT_VENDOR_ID)
#define BITS_VENDOR_ID (BIT_MASK_VENDOR_ID << BIT_SHIFT_VENDOR_ID)
#define BIT_CLEAR_VENDOR_ID(x) ((x) & (~BITS_VENDOR_ID))
#define BIT_GET_VENDOR_ID(x) (((x) >> BIT_SHIFT_VENDOR_ID) & BIT_MASK_VENDOR_ID)
#define BIT_SET_VENDOR_ID(x, v) (BIT_CLEAR_VENDOR_ID(x) | BIT_VENDOR_ID(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_CFG1				(Offset 0x00F0) */

#define BIT_SHIFT_CHIP_VER_V2 16
#define BIT_MASK_CHIP_VER_V2 0xf
#define BIT_CHIP_VER_V2(x)                                                     \
	(((x) & BIT_MASK_CHIP_VER_V2) << BIT_SHIFT_CHIP_VER_V2)
#define BITS_CHIP_VER_V2 (BIT_MASK_CHIP_VER_V2 << BIT_SHIFT_CHIP_VER_V2)
#define BIT_CLEAR_CHIP_VER_V2(x) ((x) & (~BITS_CHIP_VER_V2))
#define BIT_GET_CHIP_VER_V2(x)                                                 \
	(((x) >> BIT_SHIFT_CHIP_VER_V2) & BIT_MASK_CHIP_VER_V2)
#define BIT_SET_CHIP_VER_V2(x, v)                                              \
	(BIT_CLEAR_CHIP_VER_V2(x) | BIT_CHIP_VER_V2(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_CFG1				(Offset 0x00F0) */

#define BIT_SHIFT_CHIP_VER 12
#define BIT_MASK_CHIP_VER 0xf
#define BIT_CHIP_VER(x) (((x) & BIT_MASK_CHIP_VER) << BIT_SHIFT_CHIP_VER)
#define BITS_CHIP_VER (BIT_MASK_CHIP_VER << BIT_SHIFT_CHIP_VER)
#define BIT_CLEAR_CHIP_VER(x) ((x) & (~BITS_CHIP_VER))
#define BIT_GET_CHIP_VER(x) (((x) >> BIT_SHIFT_CHIP_VER) & BIT_MASK_CHIP_VER)
#define BIT_SET_CHIP_VER(x, v) (BIT_CLEAR_CHIP_VER(x) | BIT_CHIP_VER(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_CFG1				(Offset 0x00F0) */

#define BIT_TST_MODE_SEL BIT(11)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SYS_CFG1				(Offset 0x00F0) */

#define BIT_BD_MAC3 BIT(11)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_CFG1				(Offset 0x00F0) */

#define BIT_IC_MACPHY_MODE BIT(11)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_CFG1				(Offset 0x00F0) */

#define BIT_BD_MAC1 BIT(10)
#define BIT_BD_MAC2 BIT(9)
#define BIT_SIC_IDLE BIT(8)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_CFG1				(Offset 0x00F0) */

#define BIT_SW_OFFLOAD_EN BIT(7)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_CFG1				(Offset 0x00F0) */

#define BIT_OCP_SHUTDN BIT(6)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_CFG1				(Offset 0x00F0) */

#define BIT_OCP_SHUTDN_1 BIT(6)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_CFG1				(Offset 0x00F0) */

#define BIT_V15_VLD BIT(5)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_CFG1				(Offset 0x00F0) */

#define BIT_V12_VLD BIT(5)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_CFG1				(Offset 0x00F0) */

#define BIT_PCIRSTB BIT(4)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_CFG1				(Offset 0x00F0) */

#define BIT_PCLK_VLD BIT(3)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_CFG1				(Offset 0x00F0) */

#define BIT_PCLK_VLD_1 BIT(3)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_CFG1				(Offset 0x00F0) */

#define BIT_UCLK_VLD BIT(2)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_CFG1				(Offset 0x00F0) */

#define BIT_ACLK_VLD BIT(1)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_CFG1				(Offset 0x00F0) */

#define BIT_M200CLK_VLD_V1 BIT(1)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_CFG1				(Offset 0x00F0) */

#define BIT_XCLK_VLD BIT(0)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_SYM_OSC32K_OUTSEL BIT(31)
#define BIT_BTGP_WAKE_BT_LOC_BIT0 BIT(31)

#define BIT_SHIFT_SYM_SEC_CLKSEL 30
#define BIT_MASK_SYM_SEC_CLKSEL 0x3
#define BIT_SYM_SEC_CLKSEL(x)                                                  \
	(((x) & BIT_MASK_SYM_SEC_CLKSEL) << BIT_SHIFT_SYM_SEC_CLKSEL)
#define BITS_SYM_SEC_CLKSEL                                                    \
	(BIT_MASK_SYM_SEC_CLKSEL << BIT_SHIFT_SYM_SEC_CLKSEL)
#define BIT_CLEAR_SYM_SEC_CLKSEL(x) ((x) & (~BITS_SYM_SEC_CLKSEL))
#define BIT_GET_SYM_SEC_CLKSEL(x)                                              \
	(((x) >> BIT_SHIFT_SYM_SEC_CLKSEL) & BIT_MASK_SYM_SEC_CLKSEL)
#define BIT_SET_SYM_SEC_CLKSEL(x, v)                                           \
	(BIT_CLEAR_SYM_SEC_CLKSEL(x) | BIT_SYM_SEC_CLKSEL(v))

#define BIT_SHIFT_WL_GPIO_SEL 30
#define BIT_MASK_WL_GPIO_SEL 0x3
#define BIT_WL_GPIO_SEL(x)                                                     \
	(((x) & BIT_MASK_WL_GPIO_SEL) << BIT_SHIFT_WL_GPIO_SEL)
#define BITS_WL_GPIO_SEL (BIT_MASK_WL_GPIO_SEL << BIT_SHIFT_WL_GPIO_SEL)
#define BIT_CLEAR_WL_GPIO_SEL(x) ((x) & (~BITS_WL_GPIO_SEL))
#define BIT_GET_WL_GPIO_SEL(x)                                                 \
	(((x) >> BIT_SHIFT_WL_GPIO_SEL) & BIT_MASK_WL_GPIO_SEL)
#define BIT_SET_WL_GPIO_SEL(x, v)                                              \
	(BIT_CLEAR_WL_GPIO_SEL(x) | BIT_WL_GPIO_SEL(v))

#define BIT_SHIFT_BT_MCM_CTRL_LOC 29
#define BIT_MASK_BT_MCM_CTRL_LOC 0x3
#define BIT_BT_MCM_CTRL_LOC(x)                                                 \
	(((x) & BIT_MASK_BT_MCM_CTRL_LOC) << BIT_SHIFT_BT_MCM_CTRL_LOC)
#define BITS_BT_MCM_CTRL_LOC                                                   \
	(BIT_MASK_BT_MCM_CTRL_LOC << BIT_SHIFT_BT_MCM_CTRL_LOC)
#define BIT_CLEAR_BT_MCM_CTRL_LOC(x) ((x) & (~BITS_BT_MCM_CTRL_LOC))
#define BIT_GET_BT_MCM_CTRL_LOC(x)                                             \
	(((x) >> BIT_SHIFT_BT_MCM_CTRL_LOC) & BIT_MASK_BT_MCM_CTRL_LOC)
#define BIT_SET_BT_MCM_CTRL_LOC(x, v)                                          \
	(BIT_CLEAR_BT_MCM_CTRL_LOC(x) | BIT_BT_MCM_CTRL_LOC(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_SHIFT_RF_RL_ID 28
#define BIT_MASK_RF_RL_ID 0xf
#define BIT_RF_RL_ID(x) (((x) & BIT_MASK_RF_RL_ID) << BIT_SHIFT_RF_RL_ID)
#define BITS_RF_RL_ID (BIT_MASK_RF_RL_ID << BIT_SHIFT_RF_RL_ID)
#define BIT_CLEAR_RF_RL_ID(x) ((x) & (~BITS_RF_RL_ID))
#define BIT_GET_RF_RL_ID(x) (((x) >> BIT_SHIFT_RF_RL_ID) & BIT_MASK_RF_RL_ID)
#define BIT_SET_RF_RL_ID(x, v) (BIT_CLEAR_RF_RL_ID(x) | BIT_RF_RL_ID(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_SHIFT_SYM_MAC_CLKSEL 28
#define BIT_MASK_SYM_MAC_CLKSEL 0x3
#define BIT_SYM_MAC_CLKSEL(x)                                                  \
	(((x) & BIT_MASK_SYM_MAC_CLKSEL) << BIT_SHIFT_SYM_MAC_CLKSEL)
#define BITS_SYM_MAC_CLKSEL                                                    \
	(BIT_MASK_SYM_MAC_CLKSEL << BIT_SHIFT_SYM_MAC_CLKSEL)
#define BIT_CLEAR_SYM_MAC_CLKSEL(x) ((x) & (~BITS_SYM_MAC_CLKSEL))
#define BIT_GET_SYM_MAC_CLKSEL(x)                                              \
	(((x) >> BIT_SHIFT_SYM_MAC_CLKSEL) & BIT_MASK_SYM_MAC_CLKSEL)
#define BIT_SET_SYM_MAC_CLKSEL(x, v)                                           \
	(BIT_CLEAR_SYM_MAC_CLKSEL(x) | BIT_SYM_MAC_CLKSEL(v))

#define BIT_SHIFT_SW_DPDT_LOC 27
#define BIT_MASK_SW_DPDT_LOC 0x3
#define BIT_SW_DPDT_LOC(x)                                                     \
	(((x) & BIT_MASK_SW_DPDT_LOC) << BIT_SHIFT_SW_DPDT_LOC)
#define BITS_SW_DPDT_LOC (BIT_MASK_SW_DPDT_LOC << BIT_SHIFT_SW_DPDT_LOC)
#define BIT_CLEAR_SW_DPDT_LOC(x) ((x) & (~BITS_SW_DPDT_LOC))
#define BIT_GET_SW_DPDT_LOC(x)                                                 \
	(((x) >> BIT_SHIFT_SW_DPDT_LOC) & BIT_MASK_SW_DPDT_LOC)
#define BIT_SET_SW_DPDT_LOC(x, v)                                              \
	(BIT_CLEAR_SW_DPDT_LOC(x) | BIT_SW_DPDT_LOC(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_U3_CLK_VLD BIT(27)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_WLGP_HW_DIS_LOC_BIT0 BIT(26)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_PRST_VLD_V1 BIT(26)
#define BIT_PDN BIT(25)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_SHIFT_PKG_SEL 24
#define BIT_MASK_PKG_SEL 0x3
#define BIT_PKG_SEL(x) (((x) & BIT_MASK_PKG_SEL) << BIT_SHIFT_PKG_SEL)
#define BITS_PKG_SEL (BIT_MASK_PKG_SEL << BIT_SHIFT_PKG_SEL)
#define BIT_CLEAR_PKG_SEL(x) ((x) & (~BITS_PKG_SEL))
#define BIT_GET_PKG_SEL(x) (((x) >> BIT_SHIFT_PKG_SEL) & BIT_MASK_PKG_SEL)
#define BIT_SET_PKG_SEL(x, v) (BIT_CLEAR_PKG_SEL(x) | BIT_PKG_SEL(v))

#define BIT_SHIFT_SYM_OSC32K_RCAL 24
#define BIT_MASK_SYM_OSC32K_RCAL 0x3f
#define BIT_SYM_OSC32K_RCAL(x)                                                 \
	(((x) & BIT_MASK_SYM_OSC32K_RCAL) << BIT_SHIFT_SYM_OSC32K_RCAL)
#define BITS_SYM_OSC32K_RCAL                                                   \
	(BIT_MASK_SYM_OSC32K_RCAL << BIT_SHIFT_SYM_OSC32K_RCAL)
#define BIT_CLEAR_SYM_OSC32K_RCAL(x) ((x) & (~BITS_SYM_OSC32K_RCAL))
#define BIT_GET_SYM_OSC32K_RCAL(x)                                             \
	(((x) >> BIT_SHIFT_SYM_OSC32K_RCAL) & BIT_MASK_SYM_OSC32K_RCAL)
#define BIT_SET_SYM_OSC32K_RCAL(x, v)                                          \
	(BIT_CLEAR_SYM_OSC32K_RCAL(x) | BIT_SYM_OSC32K_RCAL(v))

#define BIT_SHIFT_SW_GPIO_B_PD 24
#define BIT_MASK_SW_GPIO_B_PD 0xff
#define BIT_SW_GPIO_B_PD(x)                                                    \
	(((x) & BIT_MASK_SW_GPIO_B_PD) << BIT_SHIFT_SW_GPIO_B_PD)
#define BITS_SW_GPIO_B_PD (BIT_MASK_SW_GPIO_B_PD << BIT_SHIFT_SW_GPIO_B_PD)
#define BIT_CLEAR_SW_GPIO_B_PD(x) ((x) & (~BITS_SW_GPIO_B_PD))
#define BIT_GET_SW_GPIO_B_PD(x)                                                \
	(((x) >> BIT_SHIFT_SW_GPIO_B_PD) & BIT_MASK_SW_GPIO_B_PD)
#define BIT_SET_SW_GPIO_B_PD(x, v)                                             \
	(BIT_CLEAR_SW_GPIO_B_PD(x) | BIT_SW_GPIO_B_PD(v))

#define BIT_SHIFT_SW_GPIO_B_IN 24
#define BIT_MASK_SW_GPIO_B_IN 0xff
#define BIT_SW_GPIO_B_IN(x)                                                    \
	(((x) & BIT_MASK_SW_GPIO_B_IN) << BIT_SHIFT_SW_GPIO_B_IN)
#define BITS_SW_GPIO_B_IN (BIT_MASK_SW_GPIO_B_IN << BIT_SHIFT_SW_GPIO_B_IN)
#define BIT_CLEAR_SW_GPIO_B_IN(x) ((x) & (~BITS_SW_GPIO_B_IN))
#define BIT_GET_SW_GPIO_B_IN(x)                                                \
	(((x) >> BIT_SHIFT_SW_GPIO_B_IN) & BIT_MASK_SW_GPIO_B_IN)
#define BIT_SET_SW_GPIO_B_IN(x, v)                                             \
	(BIT_CLEAR_SW_GPIO_B_IN(x) | BIT_SW_GPIO_B_IN(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_OCP_SHUTDN_V1 BIT(24)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_SHIFT_ANT_SEL_01_LOC 23
#define BIT_MASK_ANT_SEL_01_LOC 0x7
#define BIT_ANT_SEL_01_LOC(x)                                                  \
	(((x) & BIT_MASK_ANT_SEL_01_LOC) << BIT_SHIFT_ANT_SEL_01_LOC)
#define BITS_ANT_SEL_01_LOC                                                    \
	(BIT_MASK_ANT_SEL_01_LOC << BIT_SHIFT_ANT_SEL_01_LOC)
#define BIT_CLEAR_ANT_SEL_01_LOC(x) ((x) & (~BITS_ANT_SEL_01_LOC))
#define BIT_GET_ANT_SEL_01_LOC(x)                                              \
	(((x) >> BIT_SHIFT_ANT_SEL_01_LOC) & BIT_MASK_ANT_SEL_01_LOC)
#define BIT_SET_ANT_SEL_01_LOC(x, v)                                           \
	(BIT_CLEAR_ANT_SEL_01_LOC(x) | BIT_ANT_SEL_01_LOC(v))

#define BIT_SHIFT_AUTOLOADABLE_AT_1FC 23
#define BIT_MASK_AUTOLOADABLE_AT_1FC 0x3f
#define BIT_AUTOLOADABLE_AT_1FC(x)                                             \
	(((x) & BIT_MASK_AUTOLOADABLE_AT_1FC) << BIT_SHIFT_AUTOLOADABLE_AT_1FC)
#define BITS_AUTOLOADABLE_AT_1FC                                               \
	(BIT_MASK_AUTOLOADABLE_AT_1FC << BIT_SHIFT_AUTOLOADABLE_AT_1FC)
#define BIT_CLEAR_AUTOLOADABLE_AT_1FC(x) ((x) & (~BITS_AUTOLOADABLE_AT_1FC))
#define BIT_GET_AUTOLOADABLE_AT_1FC(x)                                         \
	(((x) >> BIT_SHIFT_AUTOLOADABLE_AT_1FC) & BIT_MASK_AUTOLOADABLE_AT_1FC)
#define BIT_SET_AUTOLOADABLE_AT_1FC(x, v)                                      \
	(BIT_CLEAR_AUTOLOADABLE_AT_1FC(x) | BIT_AUTOLOADABLE_AT_1FC(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_PCLK_VLD_V1 BIT(23)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_BT_DISN_EN_V1 BIT(22)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_U2_CLK_VLD BIT(22)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_SHIFT_ANT_SEL_23_LOC 21
#define BIT_MASK_ANT_SEL_23_LOC 0x3
#define BIT_ANT_SEL_23_LOC(x)                                                  \
	(((x) & BIT_MASK_ANT_SEL_23_LOC) << BIT_SHIFT_ANT_SEL_23_LOC)
#define BITS_ANT_SEL_23_LOC                                                    \
	(BIT_MASK_ANT_SEL_23_LOC << BIT_SHIFT_ANT_SEL_23_LOC)
#define BIT_CLEAR_ANT_SEL_23_LOC(x) ((x) & (~BITS_ANT_SEL_23_LOC))
#define BIT_GET_ANT_SEL_23_LOC(x)                                              \
	(((x) >> BIT_SHIFT_ANT_SEL_23_LOC) & BIT_MASK_ANT_SEL_23_LOC)
#define BIT_SET_ANT_SEL_23_LOC(x, v)                                           \
	(BIT_CLEAR_ANT_SEL_23_LOC(x) | BIT_ANT_SEL_23_LOC(v))

#define BIT_BT_SUSN_LOC BIT(21)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_PLL_CLK_VLD BIT(21)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_SHIFT_SW_ICFG 20
#define BIT_MASK_SW_ICFG 0xf
#define BIT_SW_ICFG(x) (((x) & BIT_MASK_SW_ICFG) << BIT_SHIFT_SW_ICFG)
#define BITS_SW_ICFG (BIT_MASK_SW_ICFG << BIT_SHIFT_SW_ICFG)
#define BIT_CLEAR_SW_ICFG(x) ((x) & (~BITS_SW_ICFG))
#define BIT_GET_SW_ICFG(x) (((x) >> BIT_SHIFT_SW_ICFG) & BIT_MASK_SW_ICFG)
#define BIT_SET_SW_ICFG(x, v) (BIT_CLEAR_SW_ICFG(x) | BIT_SW_ICFG(v))

#define BIT_SYM_CONF_BYTE_ENB BIT(20)
#define BIT_WLBB_RFE_LED1 BIT(20)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_XCK_VLD BIT(20)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_HPHY_ICFG BIT(19)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_SHIFT_EXTCK32K_LOC 19
#define BIT_MASK_EXTCK32K_LOC 0x3
#define BIT_EXTCK32K_LOC(x)                                                    \
	(((x) & BIT_MASK_EXTCK32K_LOC) << BIT_SHIFT_EXTCK32K_LOC)
#define BITS_EXTCK32K_LOC (BIT_MASK_EXTCK32K_LOC << BIT_SHIFT_EXTCK32K_LOC)
#define BIT_CLEAR_EXTCK32K_LOC(x) ((x) & (~BITS_EXTCK32K_LOC))
#define BIT_GET_EXTCK32K_LOC(x)                                                \
	(((x) >> BIT_SHIFT_EXTCK32K_LOC) & BIT_MASK_EXTCK32K_LOC)
#define BIT_SET_EXTCK32K_LOC(x, v)                                             \
	(BIT_CLEAR_EXTCK32K_LOC(x) | BIT_EXTCK32K_LOC(v))

#define BIT_WLGP_LED1_EN BIT(19)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_CK200M_VLD BIT(19)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_BT_COEX_MBOX_LOC BIT(18)
#define BIT_WLGP_ANT23_EN BIT(18)

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_HCI_SEL_EMBEDDED BIT(18)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_BTEN_TRAP BIT(18)
#define BIT_PKG_EN_V1 BIT(17)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_SHIFT_SEL_0XC0 16
#define BIT_MASK_SEL_0XC0 0x3
#define BIT_SEL_0XC0(x) (((x) & BIT_MASK_SEL_0XC0) << BIT_SHIFT_SEL_0XC0)
#define BITS_SEL_0XC0 (BIT_MASK_SEL_0XC0 << BIT_SHIFT_SEL_0XC0)
#define BIT_CLEAR_SEL_0XC0(x) ((x) & (~BITS_SEL_0XC0))
#define BIT_GET_SEL_0XC0(x) (((x) >> BIT_SHIFT_SEL_0XC0) & BIT_MASK_SEL_0XC0)
#define BIT_SET_SEL_0XC0(x, v) (BIT_CLEAR_SEL_0XC0(x) | BIT_SEL_0XC0(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_SYM_MCUFWDL_DDMA_EN BIT(16)
#define BIT_SYM_SPIC_BOOT_ADDR_CMP BIT(16)

#define BIT_SHIFT_SYM_OSC32K_CLKGEN0 16
#define BIT_MASK_SYM_OSC32K_CLKGEN0 0xff
#define BIT_SYM_OSC32K_CLKGEN0(x)                                              \
	(((x) & BIT_MASK_SYM_OSC32K_CLKGEN0) << BIT_SHIFT_SYM_OSC32K_CLKGEN0)
#define BITS_SYM_OSC32K_CLKGEN0                                                \
	(BIT_MASK_SYM_OSC32K_CLKGEN0 << BIT_SHIFT_SYM_OSC32K_CLKGEN0)
#define BIT_CLEAR_SYM_OSC32K_CLKGEN0(x) ((x) & (~BITS_SYM_OSC32K_CLKGEN0))
#define BIT_GET_SYM_OSC32K_CLKGEN0(x)                                          \
	(((x) >> BIT_SHIFT_SYM_OSC32K_CLKGEN0) & BIT_MASK_SYM_OSC32K_CLKGEN0)
#define BIT_SET_SYM_OSC32K_CLKGEN0(x, v)                                       \
	(BIT_CLEAR_SYM_OSC32K_CLKGEN0(x) | BIT_SYM_OSC32K_CLKGEN0(v))

#define BIT_SHIFT_CRC16_RESULT 16
#define BIT_MASK_CRC16_RESULT 0xffff
#define BIT_CRC16_RESULT(x)                                                    \
	(((x) & BIT_MASK_CRC16_RESULT) << BIT_SHIFT_CRC16_RESULT)
#define BITS_CRC16_RESULT (BIT_MASK_CRC16_RESULT << BIT_SHIFT_CRC16_RESULT)
#define BIT_CLEAR_CRC16_RESULT(x) ((x) & (~BITS_CRC16_RESULT))
#define BIT_GET_CRC16_RESULT(x)                                                \
	(((x) >> BIT_SHIFT_CRC16_RESULT) & BIT_MASK_CRC16_RESULT)
#define BIT_SET_CRC16_RESULT(x, v)                                             \
	(BIT_CLEAR_CRC16_RESULT(x) | BIT_CRC16_RESULT(v))

#define BIT_SHIFT_BTGP_LEDIO_LOC 16
#define BIT_MASK_BTGP_LEDIO_LOC 0x3
#define BIT_BTGP_LEDIO_LOC(x)                                                  \
	(((x) & BIT_MASK_BTGP_LEDIO_LOC) << BIT_SHIFT_BTGP_LEDIO_LOC)
#define BITS_BTGP_LEDIO_LOC                                                    \
	(BIT_MASK_BTGP_LEDIO_LOC << BIT_SHIFT_BTGP_LEDIO_LOC)
#define BIT_CLEAR_BTGP_LEDIO_LOC(x) ((x) & (~BITS_BTGP_LEDIO_LOC))
#define BIT_GET_BTGP_LEDIO_LOC(x)                                              \
	(((x) >> BIT_SHIFT_BTGP_LEDIO_LOC) & BIT_MASK_BTGP_LEDIO_LOC)
#define BIT_SET_BTGP_LEDIO_LOC(x, v)                                           \
	(BIT_CLEAR_BTGP_LEDIO_LOC(x) | BIT_BTGP_LEDIO_LOC(v))

#define BIT_SHIFT_FEM_EN 16
#define BIT_MASK_FEM_EN 0x3
#define BIT_FEM_EN(x) (((x) & BIT_MASK_FEM_EN) << BIT_SHIFT_FEM_EN)
#define BITS_FEM_EN (BIT_MASK_FEM_EN << BIT_SHIFT_FEM_EN)
#define BIT_CLEAR_FEM_EN(x) ((x) & (~BITS_FEM_EN))
#define BIT_GET_FEM_EN(x) (((x) >> BIT_SHIFT_FEM_EN) & BIT_MASK_FEM_EN)
#define BIT_SET_FEM_EN(x, v) (BIT_CLEAR_FEM_EN(x) | BIT_FEM_EN(v))

#define BIT_SHIFT_SW_GPIO_B_PU 16
#define BIT_MASK_SW_GPIO_B_PU 0xff
#define BIT_SW_GPIO_B_PU(x)                                                    \
	(((x) & BIT_MASK_SW_GPIO_B_PU) << BIT_SHIFT_SW_GPIO_B_PU)
#define BITS_SW_GPIO_B_PU (BIT_MASK_SW_GPIO_B_PU << BIT_SHIFT_SW_GPIO_B_PU)
#define BIT_CLEAR_SW_GPIO_B_PU(x) ((x) & (~BITS_SW_GPIO_B_PU))
#define BIT_GET_SW_GPIO_B_PU(x)                                                \
	(((x) >> BIT_SHIFT_SW_GPIO_B_PU) & BIT_MASK_SW_GPIO_B_PU)
#define BIT_SET_SW_GPIO_B_PU(x, v)                                             \
	(BIT_CLEAR_SW_GPIO_B_PU(x) | BIT_SW_GPIO_B_PU(v))

#define BIT_SHIFT_SYM_INT_PERIODIC 16
#define BIT_MASK_SYM_INT_PERIODIC 0x3ff
#define BIT_SYM_INT_PERIODIC(x)                                                \
	(((x) & BIT_MASK_SYM_INT_PERIODIC) << BIT_SHIFT_SYM_INT_PERIODIC)
#define BITS_SYM_INT_PERIODIC                                                  \
	(BIT_MASK_SYM_INT_PERIODIC << BIT_SHIFT_SYM_INT_PERIODIC)
#define BIT_CLEAR_SYM_INT_PERIODIC(x) ((x) & (~BITS_SYM_INT_PERIODIC))
#define BIT_GET_SYM_INT_PERIODIC(x)                                            \
	(((x) >> BIT_SHIFT_SYM_INT_PERIODIC) & BIT_MASK_SYM_INT_PERIODIC)
#define BIT_SET_SYM_INT_PERIODIC(x, v)                                         \
	(BIT_CLEAR_SYM_INT_PERIODIC(x) | BIT_SYM_INT_PERIODIC(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_TRAP_LDO_SPS_V1 BIT(16)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_IDV_DPDTSEL_P BIT(15)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_MACRDY BIT(15)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_SHIFT_LTE_COEX_UART_LOC 14
#define BIT_MASK_LTE_COEX_UART_LOC 0x3
#define BIT_LTE_COEX_UART_LOC(x)                                               \
	(((x) & BIT_MASK_LTE_COEX_UART_LOC) << BIT_SHIFT_LTE_COEX_UART_LOC)
#define BITS_LTE_COEX_UART_LOC                                                 \
	(BIT_MASK_LTE_COEX_UART_LOC << BIT_SHIFT_LTE_COEX_UART_LOC)
#define BIT_CLEAR_LTE_COEX_UART_LOC(x) ((x) & (~BITS_LTE_COEX_UART_LOC))
#define BIT_GET_LTE_COEX_UART_LOC(x)                                           \
	(((x) >> BIT_SHIFT_LTE_COEX_UART_LOC) & BIT_MASK_LTE_COEX_UART_LOC)
#define BIT_SET_LTE_COEX_UART_LOC(x, v)                                        \
	(BIT_CLEAR_LTE_COEX_UART_LOC(x) | BIT_LTE_COEX_UART_LOC(v))

#define BIT_IDV_DPDTSEL_N BIT(14)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_12V_VLD BIT(14)
#define BIT_U3PHY_RST BIT(13)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_SHIFT_SYM_LDOA12V_WT 12
#define BIT_MASK_SYM_LDOA12V_WT 0x3
#define BIT_SYM_LDOA12V_WT(x)                                                  \
	(((x) & BIT_MASK_SYM_LDOA12V_WT) << BIT_SHIFT_SYM_LDOA12V_WT)
#define BITS_SYM_LDOA12V_WT                                                    \
	(BIT_MASK_SYM_LDOA12V_WT << BIT_SHIFT_SYM_LDOA12V_WT)
#define BIT_CLEAR_SYM_LDOA12V_WT(x) ((x) & (~BITS_SYM_LDOA12V_WT))
#define BIT_GET_SYM_LDOA12V_WT(x)                                              \
	(((x) >> BIT_SHIFT_SYM_LDOA12V_WT) & BIT_MASK_SYM_LDOA12V_WT)
#define BIT_SET_SYM_LDOA12V_WT(x, v)                                           \
	(BIT_CLEAR_SYM_LDOA12V_WT(x) | BIT_SYM_LDOA12V_WT(v))

#define BIT_SHIFT_SYM_OSC32K_TEMP_COMP 12
#define BIT_MASK_SYM_OSC32K_TEMP_COMP 0xf
#define BIT_SYM_OSC32K_TEMP_COMP(x)                                            \
	(((x) & BIT_MASK_SYM_OSC32K_TEMP_COMP)                                 \
	 << BIT_SHIFT_SYM_OSC32K_TEMP_COMP)
#define BITS_SYM_OSC32K_TEMP_COMP                                              \
	(BIT_MASK_SYM_OSC32K_TEMP_COMP << BIT_SHIFT_SYM_OSC32K_TEMP_COMP)
#define BIT_CLEAR_SYM_OSC32K_TEMP_COMP(x) ((x) & (~BITS_SYM_OSC32K_TEMP_COMP))
#define BIT_GET_SYM_OSC32K_TEMP_COMP(x)                                        \
	(((x) >> BIT_SHIFT_SYM_OSC32K_TEMP_COMP) &                             \
	 BIT_MASK_SYM_OSC32K_TEMP_COMP)
#define BIT_SET_SYM_OSC32K_TEMP_COMP(x, v)                                     \
	(BIT_CLEAR_SYM_OSC32K_TEMP_COMP(x) | BIT_SYM_OSC32K_TEMP_COMP(v))

#define BIT_SHIFT_LTE_3W_LOC 12
#define BIT_MASK_LTE_3W_LOC 0x3
#define BIT_LTE_3W_LOC(x) (((x) & BIT_MASK_LTE_3W_LOC) << BIT_SHIFT_LTE_3W_LOC)
#define BITS_LTE_3W_LOC (BIT_MASK_LTE_3W_LOC << BIT_SHIFT_LTE_3W_LOC)
#define BIT_CLEAR_LTE_3W_LOC(x) ((x) & (~BITS_LTE_3W_LOC))
#define BIT_GET_LTE_3W_LOC(x)                                                  \
	(((x) >> BIT_SHIFT_LTE_3W_LOC) & BIT_MASK_LTE_3W_LOC)
#define BIT_SET_LTE_3W_LOC(x, v) (BIT_CLEAR_LTE_3W_LOC(x) | BIT_LTE_3W_LOC(v))

#define BIT_SHIFT_HW_EXTWOL_LOC 12
#define BIT_MASK_HW_EXTWOL_LOC 0x3
#define BIT_HW_EXTWOL_LOC(x)                                                   \
	(((x) & BIT_MASK_HW_EXTWOL_LOC) << BIT_SHIFT_HW_EXTWOL_LOC)
#define BITS_HW_EXTWOL_LOC (BIT_MASK_HW_EXTWOL_LOC << BIT_SHIFT_HW_EXTWOL_LOC)
#define BIT_CLEAR_HW_EXTWOL_LOC(x) ((x) & (~BITS_HW_EXTWOL_LOC))
#define BIT_GET_HW_EXTWOL_LOC(x)                                               \
	(((x) >> BIT_SHIFT_HW_EXTWOL_LOC) & BIT_MASK_HW_EXTWOL_LOC)
#define BIT_SET_HW_EXTWOL_LOC(x, v)                                            \
	(BIT_CLEAR_HW_EXTWOL_LOC(x) | BIT_HW_EXTWOL_LOC(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_SHIFT_HCI_SEL_V4 12
#define BIT_MASK_HCI_SEL_V4 0x3
#define BIT_HCI_SEL_V4(x) (((x) & BIT_MASK_HCI_SEL_V4) << BIT_SHIFT_HCI_SEL_V4)
#define BITS_HCI_SEL_V4 (BIT_MASK_HCI_SEL_V4 << BIT_SHIFT_HCI_SEL_V4)
#define BIT_CLEAR_HCI_SEL_V4(x) ((x) & (~BITS_HCI_SEL_V4))
#define BIT_GET_HCI_SEL_V4(x)                                                  \
	(((x) >> BIT_SHIFT_HCI_SEL_V4) & BIT_MASK_HCI_SEL_V4)
#define BIT_SET_HCI_SEL_V4(x, v) (BIT_CLEAR_HCI_SEL_V4(x) | BIT_HCI_SEL_V4(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_USB2_SEL_V1 BIT(12)

#endif

#if (HALMAC_8822B_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_SHIFT_HCI_SEL_V3 12
#define BIT_MASK_HCI_SEL_V3 0x7
#define BIT_HCI_SEL_V3(x) (((x) & BIT_MASK_HCI_SEL_V3) << BIT_SHIFT_HCI_SEL_V3)
#define BITS_HCI_SEL_V3 (BIT_MASK_HCI_SEL_V3 << BIT_SHIFT_HCI_SEL_V3)
#define BIT_CLEAR_HCI_SEL_V3(x) ((x) & (~BITS_HCI_SEL_V3))
#define BIT_GET_HCI_SEL_V3(x)                                                  \
	(((x) >> BIT_SHIFT_HCI_SEL_V3) & BIT_MASK_HCI_SEL_V3)
#define BIT_SET_HCI_SEL_V3(x, v) (BIT_CLEAR_HCI_SEL_V3(x) | BIT_HCI_SEL_V3(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_SIC_LOC BIT(11)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_USB_OPERATION_MODE BIT(10)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_SHIFT_BTGP_WAKE_LOC 10
#define BIT_MASK_BTGP_WAKE_LOC 0x3
#define BIT_BTGP_WAKE_LOC(x)                                                   \
	(((x) & BIT_MASK_BTGP_WAKE_LOC) << BIT_SHIFT_BTGP_WAKE_LOC)
#define BITS_BTGP_WAKE_LOC (BIT_MASK_BTGP_WAKE_LOC << BIT_SHIFT_BTGP_WAKE_LOC)
#define BIT_CLEAR_BTGP_WAKE_LOC(x) ((x) & (~BITS_BTGP_WAKE_LOC))
#define BIT_GET_BTGP_WAKE_LOC(x)                                               \
	(((x) >> BIT_SHIFT_BTGP_WAKE_LOC) & BIT_MASK_BTGP_WAKE_LOC)
#define BIT_SET_BTGP_WAKE_LOC(x, v)                                            \
	(BIT_CLEAR_BTGP_WAKE_LOC(x) | BIT_BTGP_WAKE_LOC(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_BT_PDN BIT(9)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_SHIFT_WLMAC_DBG_LOC 9
#define BIT_MASK_WLMAC_DBG_LOC 0x3
#define BIT_WLMAC_DBG_LOC(x)                                                   \
	(((x) & BIT_MASK_WLMAC_DBG_LOC) << BIT_SHIFT_WLMAC_DBG_LOC)
#define BITS_WLMAC_DBG_LOC (BIT_MASK_WLMAC_DBG_LOC << BIT_SHIFT_WLMAC_DBG_LOC)
#define BIT_CLEAR_WLMAC_DBG_LOC(x) ((x) & (~BITS_WLMAC_DBG_LOC))
#define BIT_GET_WLMAC_DBG_LOC(x)                                               \
	(((x) >> BIT_SHIFT_WLMAC_DBG_LOC) & BIT_MASK_WLMAC_DBG_LOC)
#define BIT_SET_WLMAC_DBG_LOC(x, v)                                            \
	(BIT_CLEAR_WLMAC_DBG_LOC(x) | BIT_WLMAC_DBG_LOC(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_AUTO_WLPON BIT(8)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_SYM_MCU_CLK_DIV2 BIT(8)

#define BIT_SHIFT_SYM_OSC32K_LDO_V18ADJ 8
#define BIT_MASK_SYM_OSC32K_LDO_V18ADJ 0xf
#define BIT_SYM_OSC32K_LDO_V18ADJ(x)                                           \
	(((x) & BIT_MASK_SYM_OSC32K_LDO_V18ADJ)                                \
	 << BIT_SHIFT_SYM_OSC32K_LDO_V18ADJ)
#define BITS_SYM_OSC32K_LDO_V18ADJ                                             \
	(BIT_MASK_SYM_OSC32K_LDO_V18ADJ << BIT_SHIFT_SYM_OSC32K_LDO_V18ADJ)
#define BIT_CLEAR_SYM_OSC32K_LDO_V18ADJ(x) ((x) & (~BITS_SYM_OSC32K_LDO_V18ADJ))
#define BIT_GET_SYM_OSC32K_LDO_V18ADJ(x)                                       \
	(((x) >> BIT_SHIFT_SYM_OSC32K_LDO_V18ADJ) &                            \
	 BIT_MASK_SYM_OSC32K_LDO_V18ADJ)
#define BIT_SET_SYM_OSC32K_LDO_V18ADJ(x, v)                                    \
	(BIT_CLEAR_SYM_OSC32K_LDO_V18ADJ(x) | BIT_SYM_OSC32K_LDO_V18ADJ(v))

#define BIT_SHIFT_HOST_WAKE_WL_LOC 8
#define BIT_MASK_HOST_WAKE_WL_LOC 0x3
#define BIT_HOST_WAKE_WL_LOC(x)                                                \
	(((x) & BIT_MASK_HOST_WAKE_WL_LOC) << BIT_SHIFT_HOST_WAKE_WL_LOC)
#define BITS_HOST_WAKE_WL_LOC                                                  \
	(BIT_MASK_HOST_WAKE_WL_LOC << BIT_SHIFT_HOST_WAKE_WL_LOC)
#define BIT_CLEAR_HOST_WAKE_WL_LOC(x) ((x) & (~BITS_HOST_WAKE_WL_LOC))
#define BIT_GET_HOST_WAKE_WL_LOC(x)                                            \
	(((x) >> BIT_SHIFT_HOST_WAKE_WL_LOC) & BIT_MASK_HOST_WAKE_WL_LOC)
#define BIT_SET_HOST_WAKE_WL_LOC(x, v)                                         \
	(BIT_CLEAR_HOST_WAKE_WL_LOC(x) | BIT_HOST_WAKE_WL_LOC(v))

#define BIT_SHIFT_SW_GPIO_B_OE2 8
#define BIT_MASK_SW_GPIO_B_OE2 0xff
#define BIT_SW_GPIO_B_OE2(x)                                                   \
	(((x) & BIT_MASK_SW_GPIO_B_OE2) << BIT_SHIFT_SW_GPIO_B_OE2)
#define BITS_SW_GPIO_B_OE2 (BIT_MASK_SW_GPIO_B_OE2 << BIT_SHIFT_SW_GPIO_B_OE2)
#define BIT_CLEAR_SW_GPIO_B_OE2(x) ((x) & (~BITS_SW_GPIO_B_OE2))
#define BIT_GET_SW_GPIO_B_OE2(x)                                               \
	(((x) >> BIT_SHIFT_SW_GPIO_B_OE2) & BIT_MASK_SW_GPIO_B_OE2)
#define BIT_SET_SW_GPIO_B_OE2(x, v)                                            \
	(BIT_CLEAR_SW_GPIO_B_OE2(x) | BIT_SW_GPIO_B_OE2(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_SHIFT_TRAP_ICFG 8
#define BIT_MASK_TRAP_ICFG 0xf
#define BIT_TRAP_ICFG(x) (((x) & BIT_MASK_TRAP_ICFG) << BIT_SHIFT_TRAP_ICFG)
#define BITS_TRAP_ICFG (BIT_MASK_TRAP_ICFG << BIT_SHIFT_TRAP_ICFG)
#define BIT_CLEAR_TRAP_ICFG(x) ((x) & (~BITS_TRAP_ICFG))
#define BIT_GET_TRAP_ICFG(x) (((x) >> BIT_SHIFT_TRAP_ICFG) & BIT_MASK_TRAP_ICFG)
#define BIT_SET_TRAP_ICFG(x, v) (BIT_CLEAR_TRAP_ICFG(x) | BIT_TRAP_ICFG(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_WL_MODE BIT(7)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_SPI_FLASH_LOC BIT(7)

#define BIT_SHIFT_WLPHY_DBG_LOC 7
#define BIT_MASK_WLPHY_DBG_LOC 0x3
#define BIT_WLPHY_DBG_LOC(x)                                                   \
	(((x) & BIT_MASK_WLPHY_DBG_LOC) << BIT_SHIFT_WLPHY_DBG_LOC)
#define BITS_WLPHY_DBG_LOC (BIT_MASK_WLPHY_DBG_LOC << BIT_SHIFT_WLPHY_DBG_LOC)
#define BIT_CLEAR_WLPHY_DBG_LOC(x) ((x) & (~BITS_WLPHY_DBG_LOC))
#define BIT_GET_WLPHY_DBG_LOC(x)                                               \
	(((x) >> BIT_SHIFT_WLPHY_DBG_LOC) & BIT_MASK_WLPHY_DBG_LOC)
#define BIT_SET_WLPHY_DBG_LOC(x, v)                                            \
	(BIT_CLEAR_WLPHY_DBG_LOC(x) | BIT_WLPHY_DBG_LOC(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_WLAN_ID BIT(7)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_PKG_SEL_HCI BIT(6)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_SHIFT_SYM_OSC32K_COMP_LOAD_CUR 6
#define BIT_MASK_SYM_OSC32K_COMP_LOAD_CUR 0x3
#define BIT_SYM_OSC32K_COMP_LOAD_CUR(x)                                        \
	(((x) & BIT_MASK_SYM_OSC32K_COMP_LOAD_CUR)                             \
	 << BIT_SHIFT_SYM_OSC32K_COMP_LOAD_CUR)
#define BITS_SYM_OSC32K_COMP_LOAD_CUR                                          \
	(BIT_MASK_SYM_OSC32K_COMP_LOAD_CUR                                     \
	 << BIT_SHIFT_SYM_OSC32K_COMP_LOAD_CUR)
#define BIT_CLEAR_SYM_OSC32K_COMP_LOAD_CUR(x)                                  \
	((x) & (~BITS_SYM_OSC32K_COMP_LOAD_CUR))
#define BIT_GET_SYM_OSC32K_COMP_LOAD_CUR(x)                                    \
	(((x) >> BIT_SHIFT_SYM_OSC32K_COMP_LOAD_CUR) &                         \
	 BIT_MASK_SYM_OSC32K_COMP_LOAD_CUR)
#define BIT_SET_SYM_OSC32K_COMP_LOAD_CUR(x, v)                                 \
	(BIT_CLEAR_SYM_OSC32K_COMP_LOAD_CUR(x) |                               \
	 BIT_SYM_OSC32K_COMP_LOAD_CUR(v))

#define BIT_WLGP_HW_DIS_LOC_BIT1 BIT(6)
#define BIT_XTAL_CKOUT_LOC BIT(6)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_ALDN BIT(6)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_XTAL_CLKREQ_EN BIT(5)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_BTCOEX_CMDEN BIT(5)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_SHIFT_HCI_SEL 4
#define BIT_MASK_HCI_SEL 0x3
#define BIT_HCI_SEL(x) (((x) & BIT_MASK_HCI_SEL) << BIT_SHIFT_HCI_SEL)
#define BITS_HCI_SEL (BIT_MASK_HCI_SEL << BIT_SHIFT_HCI_SEL)
#define BIT_CLEAR_HCI_SEL(x) ((x) & (~BITS_HCI_SEL))
#define BIT_GET_HCI_SEL(x) (((x) >> BIT_SHIFT_HCI_SEL) & BIT_MASK_HCI_SEL)
#define BIT_SET_HCI_SEL(x, v) (BIT_CLEAR_HCI_SEL(x) | BIT_HCI_SEL(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_SYM_BOOT_SEL BIT(4)

#define BIT_SHIFT_SYM_OSC32K_COMP_LATCH_CUR 4
#define BIT_MASK_SYM_OSC32K_COMP_LATCH_CUR 0x3
#define BIT_SYM_OSC32K_COMP_LATCH_CUR(x)                                       \
	(((x) & BIT_MASK_SYM_OSC32K_COMP_LATCH_CUR)                            \
	 << BIT_SHIFT_SYM_OSC32K_COMP_LATCH_CUR)
#define BITS_SYM_OSC32K_COMP_LATCH_CUR                                         \
	(BIT_MASK_SYM_OSC32K_COMP_LATCH_CUR                                    \
	 << BIT_SHIFT_SYM_OSC32K_COMP_LATCH_CUR)
#define BIT_CLEAR_SYM_OSC32K_COMP_LATCH_CUR(x)                                 \
	((x) & (~BITS_SYM_OSC32K_COMP_LATCH_CUR))
#define BIT_GET_SYM_OSC32K_COMP_LATCH_CUR(x)                                   \
	(((x) >> BIT_SHIFT_SYM_OSC32K_COMP_LATCH_CUR) &                        \
	 BIT_MASK_SYM_OSC32K_COMP_LATCH_CUR)
#define BIT_SET_SYM_OSC32K_COMP_LATCH_CUR(x, v)                                \
	(BIT_CLEAR_SYM_OSC32K_COMP_LATCH_CUR(x) |                              \
	 BIT_SYM_OSC32K_COMP_LATCH_CUR(v))

#define BIT_SHIFT_CRC16_CHECK_MAXIMUM_ADDRESS_BOUNDARY 4
#define BIT_MASK_CRC16_CHECK_MAXIMUM_ADDRESS_BOUNDARY 0x3ff
#define BIT_CRC16_CHECK_MAXIMUM_ADDRESS_BOUNDARY(x)                            \
	(((x) & BIT_MASK_CRC16_CHECK_MAXIMUM_ADDRESS_BOUNDARY)                 \
	 << BIT_SHIFT_CRC16_CHECK_MAXIMUM_ADDRESS_BOUNDARY)
#define BITS_CRC16_CHECK_MAXIMUM_ADDRESS_BOUNDARY                              \
	(BIT_MASK_CRC16_CHECK_MAXIMUM_ADDRESS_BOUNDARY                         \
	 << BIT_SHIFT_CRC16_CHECK_MAXIMUM_ADDRESS_BOUNDARY)
#define BIT_CLEAR_CRC16_CHECK_MAXIMUM_ADDRESS_BOUNDARY(x)                      \
	((x) & (~BITS_CRC16_CHECK_MAXIMUM_ADDRESS_BOUNDARY))
#define BIT_GET_CRC16_CHECK_MAXIMUM_ADDRESS_BOUNDARY(x)                        \
	(((x) >> BIT_SHIFT_CRC16_CHECK_MAXIMUM_ADDRESS_BOUNDARY) &             \
	 BIT_MASK_CRC16_CHECK_MAXIMUM_ADDRESS_BOUNDARY)
#define BIT_SET_CRC16_CHECK_MAXIMUM_ADDRESS_BOUNDARY(x, v)                     \
	(BIT_CLEAR_CRC16_CHECK_MAXIMUM_ADDRESS_BOUNDARY(x) |                   \
	 BIT_CRC16_CHECK_MAXIMUM_ADDRESS_BOUNDARY(v))

#define BIT_HOST_WAKE_WL_EN BIT(4)

#define BIT_SHIFT_XTAL_CLKREQ_LOC 4
#define BIT_MASK_XTAL_CLKREQ_LOC 0x3
#define BIT_XTAL_CLKREQ_LOC(x)                                                 \
	(((x) & BIT_MASK_XTAL_CLKREQ_LOC) << BIT_SHIFT_XTAL_CLKREQ_LOC)
#define BITS_XTAL_CLKREQ_LOC                                                   \
	(BIT_MASK_XTAL_CLKREQ_LOC << BIT_SHIFT_XTAL_CLKREQ_LOC)
#define BIT_CLEAR_XTAL_CLKREQ_LOC(x) ((x) & (~BITS_XTAL_CLKREQ_LOC))
#define BIT_GET_XTAL_CLKREQ_LOC(x)                                             \
	(((x) >> BIT_SHIFT_XTAL_CLKREQ_LOC) & BIT_MASK_XTAL_CLKREQ_LOC)
#define BIT_SET_XTAL_CLKREQ_LOC(x, v)                                          \
	(BIT_CLEAR_XTAL_CLKREQ_LOC(x) | BIT_XTAL_CLKREQ_LOC(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_BT_EN BIT(4)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_BTGP_MCM_UART_EN BIT(3)
#define BIT_WLGP_UART_LOC BIT(3)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_SHIFT_PAD_HCI_SEL_V2 3
#define BIT_MASK_PAD_HCI_SEL_V2 0x3
#define BIT_PAD_HCI_SEL_V2(x)                                                  \
	(((x) & BIT_MASK_PAD_HCI_SEL_V2) << BIT_SHIFT_PAD_HCI_SEL_V2)
#define BITS_PAD_HCI_SEL_V2                                                    \
	(BIT_MASK_PAD_HCI_SEL_V2 << BIT_SHIFT_PAD_HCI_SEL_V2)
#define BIT_CLEAR_PAD_HCI_SEL_V2(x) ((x) & (~BITS_PAD_HCI_SEL_V2))
#define BIT_GET_PAD_HCI_SEL_V2(x)                                              \
	(((x) >> BIT_SHIFT_PAD_HCI_SEL_V2) & BIT_MASK_PAD_HCI_SEL_V2)
#define BIT_SET_PAD_HCI_SEL_V2(x, v)                                           \
	(BIT_CLEAR_PAD_HCI_SEL_V2(x) | BIT_PAD_HCI_SEL_V2(v))

#endif

#if (HALMAC_8822B_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_SHIFT_PAD_HCI_SEL_V1 3
#define BIT_MASK_PAD_HCI_SEL_V1 0x7
#define BIT_PAD_HCI_SEL_V1(x)                                                  \
	(((x) & BIT_MASK_PAD_HCI_SEL_V1) << BIT_SHIFT_PAD_HCI_SEL_V1)
#define BITS_PAD_HCI_SEL_V1                                                    \
	(BIT_MASK_PAD_HCI_SEL_V1 << BIT_SHIFT_PAD_HCI_SEL_V1)
#define BIT_CLEAR_PAD_HCI_SEL_V1(x) ((x) & (~BITS_PAD_HCI_SEL_V1))
#define BIT_GET_PAD_HCI_SEL_V1(x)                                              \
	(((x) >> BIT_SHIFT_PAD_HCI_SEL_V1) & BIT_MASK_PAD_HCI_SEL_V1)
#define BIT_SET_PAD_HCI_SEL_V1(x, v)                                           \
	(BIT_CLEAR_PAD_HCI_SEL_V1(x) | BIT_PAD_HCI_SEL_V1(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_SHIFT_PAD_HCI_SEL 2
#define BIT_MASK_PAD_HCI_SEL 0x3
#define BIT_PAD_HCI_SEL(x)                                                     \
	(((x) & BIT_MASK_PAD_HCI_SEL) << BIT_SHIFT_PAD_HCI_SEL)
#define BITS_PAD_HCI_SEL (BIT_MASK_PAD_HCI_SEL << BIT_SHIFT_PAD_HCI_SEL)
#define BIT_CLEAR_PAD_HCI_SEL(x) ((x) & (~BITS_PAD_HCI_SEL))
#define BIT_GET_PAD_HCI_SEL(x)                                                 \
	(((x) >> BIT_SHIFT_PAD_HCI_SEL) & BIT_MASK_PAD_HCI_SEL)
#define BIT_SET_PAD_HCI_SEL(x, v)                                              \
	(BIT_CLEAR_PAD_HCI_SEL(x) | BIT_PAD_HCI_SEL(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_SHIFT_SYM_OSC32K_COMP_GM_CUR 2
#define BIT_MASK_SYM_OSC32K_COMP_GM_CUR 0x3
#define BIT_SYM_OSC32K_COMP_GM_CUR(x)                                          \
	(((x) & BIT_MASK_SYM_OSC32K_COMP_GM_CUR)                               \
	 << BIT_SHIFT_SYM_OSC32K_COMP_GM_CUR)
#define BITS_SYM_OSC32K_COMP_GM_CUR                                            \
	(BIT_MASK_SYM_OSC32K_COMP_GM_CUR << BIT_SHIFT_SYM_OSC32K_COMP_GM_CUR)
#define BIT_CLEAR_SYM_OSC32K_COMP_GM_CUR(x)                                    \
	((x) & (~BITS_SYM_OSC32K_COMP_GM_CUR))
#define BIT_GET_SYM_OSC32K_COMP_GM_CUR(x)                                      \
	(((x) >> BIT_SHIFT_SYM_OSC32K_COMP_GM_CUR) &                           \
	 BIT_MASK_SYM_OSC32K_COMP_GM_CUR)
#define BIT_SET_SYM_OSC32K_COMP_GM_CUR(x, v)                                   \
	(BIT_CLEAR_SYM_OSC32K_COMP_GM_CUR(x) | BIT_SYM_OSC32K_COMP_GM_CUR(v))

#define BIT_WLGP_MCM_COEXFEN BIT(2)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_SHIFT_HCI_SEL_V2 2
#define BIT_MASK_HCI_SEL_V2 0x3
#define BIT_HCI_SEL_V2(x) (((x) & BIT_MASK_HCI_SEL_V2) << BIT_SHIFT_HCI_SEL_V2)
#define BITS_HCI_SEL_V2 (BIT_MASK_HCI_SEL_V2 << BIT_SHIFT_HCI_SEL_V2)
#define BIT_CLEAR_HCI_SEL_V2(x) ((x) & (~BITS_HCI_SEL_V2))
#define BIT_GET_HCI_SEL_V2(x)                                                  \
	(((x) >> BIT_SHIFT_HCI_SEL_V2) & BIT_MASK_HCI_SEL_V2)
#define BIT_SET_HCI_SEL_V2(x, v) (BIT_CLEAR_HCI_SEL_V2(x) | BIT_HCI_SEL_V2(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_BT_COEX_MCM_MBOX BIT(1)

#define BIT_SHIFT_BTGP_WAKE_HST_LOC 1
#define BIT_MASK_BTGP_WAKE_HST_LOC 0x3
#define BIT_BTGP_WAKE_HST_LOC(x)                                               \
	(((x) & BIT_MASK_BTGP_WAKE_HST_LOC) << BIT_SHIFT_BTGP_WAKE_HST_LOC)
#define BITS_BTGP_WAKE_HST_LOC                                                 \
	(BIT_MASK_BTGP_WAKE_HST_LOC << BIT_SHIFT_BTGP_WAKE_HST_LOC)
#define BIT_CLEAR_BTGP_WAKE_HST_LOC(x) ((x) & (~BITS_BTGP_WAKE_HST_LOC))
#define BIT_GET_BTGP_WAKE_HST_LOC(x)                                           \
	(((x) >> BIT_SHIFT_BTGP_WAKE_HST_LOC) & BIT_MASK_BTGP_WAKE_HST_LOC)
#define BIT_SET_BTGP_WAKE_HST_LOC(x, v)                                        \
	(BIT_CLEAR_BTGP_WAKE_HST_LOC(x) | BIT_BTGP_WAKE_HST_LOC(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_TST_MOD_SEL BIT(1)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_SHIFT_EFS_HCI_SEL 0
#define BIT_MASK_EFS_HCI_SEL 0x3
#define BIT_EFS_HCI_SEL(x)                                                     \
	(((x) & BIT_MASK_EFS_HCI_SEL) << BIT_SHIFT_EFS_HCI_SEL)
#define BITS_EFS_HCI_SEL (BIT_MASK_EFS_HCI_SEL << BIT_SHIFT_EFS_HCI_SEL)
#define BIT_CLEAR_EFS_HCI_SEL(x) ((x) & (~BITS_EFS_HCI_SEL))
#define BIT_GET_EFS_HCI_SEL(x)                                                 \
	(((x) >> BIT_SHIFT_EFS_HCI_SEL) & BIT_MASK_EFS_HCI_SEL)
#define BIT_SET_EFS_HCI_SEL(x, v)                                              \
	(BIT_CLEAR_EFS_HCI_SEL(x) | BIT_EFS_HCI_SEL(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_SYM_BOOT_CFG BIT(0)

#define BIT_SHIFT_SYM_SPIC_BOOT_EXT_ADDR 0
#define BIT_MASK_SYM_SPIC_BOOT_EXT_ADDR 0xffff
#define BIT_SYM_SPIC_BOOT_EXT_ADDR(x)                                          \
	(((x) & BIT_MASK_SYM_SPIC_BOOT_EXT_ADDR)                               \
	 << BIT_SHIFT_SYM_SPIC_BOOT_EXT_ADDR)
#define BITS_SYM_SPIC_BOOT_EXT_ADDR                                            \
	(BIT_MASK_SYM_SPIC_BOOT_EXT_ADDR << BIT_SHIFT_SYM_SPIC_BOOT_EXT_ADDR)
#define BIT_CLEAR_SYM_SPIC_BOOT_EXT_ADDR(x)                                    \
	((x) & (~BITS_SYM_SPIC_BOOT_EXT_ADDR))
#define BIT_GET_SYM_SPIC_BOOT_EXT_ADDR(x)                                      \
	(((x) >> BIT_SHIFT_SYM_SPIC_BOOT_EXT_ADDR) &                           \
	 BIT_MASK_SYM_SPIC_BOOT_EXT_ADDR)
#define BIT_SET_SYM_SPIC_BOOT_EXT_ADDR(x, v)                                   \
	(BIT_CLEAR_SYM_SPIC_BOOT_EXT_ADDR(x) | BIT_SYM_SPIC_BOOT_EXT_ADDR(v))

#define BIT_SHIFT_SYM_OSC32K_FREQSEL 0
#define BIT_MASK_SYM_OSC32K_FREQSEL 0x3
#define BIT_SYM_OSC32K_FREQSEL(x)                                              \
	(((x) & BIT_MASK_SYM_OSC32K_FREQSEL) << BIT_SHIFT_SYM_OSC32K_FREQSEL)
#define BITS_SYM_OSC32K_FREQSEL                                                \
	(BIT_MASK_SYM_OSC32K_FREQSEL << BIT_SHIFT_SYM_OSC32K_FREQSEL)
#define BIT_CLEAR_SYM_OSC32K_FREQSEL(x) ((x) & (~BITS_SYM_OSC32K_FREQSEL))
#define BIT_GET_SYM_OSC32K_FREQSEL(x)                                          \
	(((x) >> BIT_SHIFT_SYM_OSC32K_FREQSEL) & BIT_MASK_SYM_OSC32K_FREQSEL)
#define BIT_SET_SYM_OSC32K_FREQSEL(x, v)                                       \
	(BIT_CLEAR_SYM_OSC32K_FREQSEL(x) | BIT_SYM_OSC32K_FREQSEL(v))

#define BIT_CRC16_CHECK_ENABLE BIT(0)
#define BIT_SW_GPIO_FUNC BIT(0)
#define BIT_BTGP_WAKE_BT_LOC BIT(0)

#define BIT_SHIFT_SW_GPIO_A_OUT 0
#define BIT_MASK_SW_GPIO_A_OUT 0xffffffffL
#define BIT_SW_GPIO_A_OUT(x)                                                   \
	(((x) & BIT_MASK_SW_GPIO_A_OUT) << BIT_SHIFT_SW_GPIO_A_OUT)
#define BITS_SW_GPIO_A_OUT (BIT_MASK_SW_GPIO_A_OUT << BIT_SHIFT_SW_GPIO_A_OUT)
#define BIT_CLEAR_SW_GPIO_A_OUT(x) ((x) & (~BITS_SW_GPIO_A_OUT))
#define BIT_GET_SW_GPIO_A_OUT(x)                                               \
	(((x) >> BIT_SHIFT_SW_GPIO_A_OUT) & BIT_MASK_SW_GPIO_A_OUT)
#define BIT_SET_SW_GPIO_A_OUT(x, v)                                            \
	(BIT_CLEAR_SW_GPIO_A_OUT(x) | BIT_SW_GPIO_A_OUT(v))

#define BIT_SHIFT_SW_GPIO_A_OEN 0
#define BIT_MASK_SW_GPIO_A_OEN 0xffffffffL
#define BIT_SW_GPIO_A_OEN(x)                                                   \
	(((x) & BIT_MASK_SW_GPIO_A_OEN) << BIT_SHIFT_SW_GPIO_A_OEN)
#define BITS_SW_GPIO_A_OEN (BIT_MASK_SW_GPIO_A_OEN << BIT_SHIFT_SW_GPIO_A_OEN)
#define BIT_CLEAR_SW_GPIO_A_OEN(x) ((x) & (~BITS_SW_GPIO_A_OEN))
#define BIT_GET_SW_GPIO_A_OEN(x)                                               \
	(((x) >> BIT_SHIFT_SW_GPIO_A_OEN) & BIT_MASK_SW_GPIO_A_OEN)
#define BIT_SET_SW_GPIO_A_OEN(x, v)                                            \
	(BIT_CLEAR_SW_GPIO_A_OEN(x) | BIT_SW_GPIO_A_OEN(v))

#define BIT_SHIFT_SW_GPIO_A_OE2 0
#define BIT_MASK_SW_GPIO_A_OE2 0xffffffffL
#define BIT_SW_GPIO_A_OE2(x)                                                   \
	(((x) & BIT_MASK_SW_GPIO_A_OE2) << BIT_SHIFT_SW_GPIO_A_OE2)
#define BITS_SW_GPIO_A_OE2 (BIT_MASK_SW_GPIO_A_OE2 << BIT_SHIFT_SW_GPIO_A_OE2)
#define BIT_CLEAR_SW_GPIO_A_OE2(x) ((x) & (~BITS_SW_GPIO_A_OE2))
#define BIT_GET_SW_GPIO_A_OE2(x)                                               \
	(((x) >> BIT_SHIFT_SW_GPIO_A_OE2) & BIT_MASK_SW_GPIO_A_OE2)
#define BIT_SET_SW_GPIO_A_OE2(x, v)                                            \
	(BIT_CLEAR_SW_GPIO_A_OE2(x) | BIT_SW_GPIO_A_OE2(v))

#define BIT_SHIFT_SW_GPIO_A_PU 0
#define BIT_MASK_SW_GPIO_A_PU 0xffffffffL
#define BIT_SW_GPIO_A_PU(x)                                                    \
	(((x) & BIT_MASK_SW_GPIO_A_PU) << BIT_SHIFT_SW_GPIO_A_PU)
#define BITS_SW_GPIO_A_PU (BIT_MASK_SW_GPIO_A_PU << BIT_SHIFT_SW_GPIO_A_PU)
#define BIT_CLEAR_SW_GPIO_A_PU(x) ((x) & (~BITS_SW_GPIO_A_PU))
#define BIT_GET_SW_GPIO_A_PU(x)                                                \
	(((x) >> BIT_SHIFT_SW_GPIO_A_PU) & BIT_MASK_SW_GPIO_A_PU)
#define BIT_SET_SW_GPIO_A_PU(x, v)                                             \
	(BIT_CLEAR_SW_GPIO_A_PU(x) | BIT_SW_GPIO_A_PU(v))

#define BIT_SHIFT_SW_GPIO_A_PD 0
#define BIT_MASK_SW_GPIO_A_PD 0xffffffffL
#define BIT_SW_GPIO_A_PD(x)                                                    \
	(((x) & BIT_MASK_SW_GPIO_A_PD) << BIT_SHIFT_SW_GPIO_A_PD)
#define BITS_SW_GPIO_A_PD (BIT_MASK_SW_GPIO_A_PD << BIT_SHIFT_SW_GPIO_A_PD)
#define BIT_CLEAR_SW_GPIO_A_PD(x) ((x) & (~BITS_SW_GPIO_A_PD))
#define BIT_GET_SW_GPIO_A_PD(x)                                                \
	(((x) >> BIT_SHIFT_SW_GPIO_A_PD) & BIT_MASK_SW_GPIO_A_PD)
#define BIT_SET_SW_GPIO_A_PD(x, v)                                             \
	(BIT_CLEAR_SW_GPIO_A_PD(x) | BIT_SW_GPIO_A_PD(v))

#define BIT_SHIFT_SW_GPIO_A_IN 0
#define BIT_MASK_SW_GPIO_A_IN 0xffffffffL
#define BIT_SW_GPIO_A_IN(x)                                                    \
	(((x) & BIT_MASK_SW_GPIO_A_IN) << BIT_SHIFT_SW_GPIO_A_IN)
#define BITS_SW_GPIO_A_IN (BIT_MASK_SW_GPIO_A_IN << BIT_SHIFT_SW_GPIO_A_IN)
#define BIT_CLEAR_SW_GPIO_A_IN(x) ((x) & (~BITS_SW_GPIO_A_IN))
#define BIT_GET_SW_GPIO_A_IN(x)                                                \
	(((x) >> BIT_SHIFT_SW_GPIO_A_IN) & BIT_MASK_SW_GPIO_A_IN)
#define BIT_SET_SW_GPIO_A_IN(x, v)                                             \
	(BIT_CLEAR_SW_GPIO_A_IN(x) | BIT_SW_GPIO_A_IN(v))

#define BIT_SHIFT_SW_GPIO_B_OEN 0
#define BIT_MASK_SW_GPIO_B_OEN 0xff
#define BIT_SW_GPIO_B_OEN(x)                                                   \
	(((x) & BIT_MASK_SW_GPIO_B_OEN) << BIT_SHIFT_SW_GPIO_B_OEN)
#define BITS_SW_GPIO_B_OEN (BIT_MASK_SW_GPIO_B_OEN << BIT_SHIFT_SW_GPIO_B_OEN)
#define BIT_CLEAR_SW_GPIO_B_OEN(x) ((x) & (~BITS_SW_GPIO_B_OEN))
#define BIT_GET_SW_GPIO_B_OEN(x)                                               \
	(((x) >> BIT_SHIFT_SW_GPIO_B_OEN) & BIT_MASK_SW_GPIO_B_OEN)
#define BIT_SET_SW_GPIO_B_OEN(x, v)                                            \
	(BIT_CLEAR_SW_GPIO_B_OEN(x) | BIT_SW_GPIO_B_OEN(v))

#define BIT_SHIFT_SW_GPIO_B_OUT 0
#define BIT_MASK_SW_GPIO_B_OUT 0xff
#define BIT_SW_GPIO_B_OUT(x)                                                   \
	(((x) & BIT_MASK_SW_GPIO_B_OUT) << BIT_SHIFT_SW_GPIO_B_OUT)
#define BITS_SW_GPIO_B_OUT (BIT_MASK_SW_GPIO_B_OUT << BIT_SHIFT_SW_GPIO_B_OUT)
#define BIT_CLEAR_SW_GPIO_B_OUT(x) ((x) & (~BITS_SW_GPIO_B_OUT))
#define BIT_GET_SW_GPIO_B_OUT(x)                                               \
	(((x) >> BIT_SHIFT_SW_GPIO_B_OUT) & BIT_MASK_SW_GPIO_B_OUT)
#define BIT_SET_SW_GPIO_B_OUT(x, v)                                            \
	(BIT_CLEAR_SW_GPIO_B_OUT(x) | BIT_SW_GPIO_B_OUT(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_SHIFT_EFS_HCI_SEL_V1 0
#define BIT_MASK_EFS_HCI_SEL_V1 0x7
#define BIT_EFS_HCI_SEL_V1(x)                                                  \
	(((x) & BIT_MASK_EFS_HCI_SEL_V1) << BIT_SHIFT_EFS_HCI_SEL_V1)
#define BITS_EFS_HCI_SEL_V1                                                    \
	(BIT_MASK_EFS_HCI_SEL_V1 << BIT_SHIFT_EFS_HCI_SEL_V1)
#define BIT_CLEAR_EFS_HCI_SEL_V1(x) ((x) & (~BITS_EFS_HCI_SEL_V1))
#define BIT_GET_EFS_HCI_SEL_V1(x)                                              \
	(((x) >> BIT_SHIFT_EFS_HCI_SEL_V1) & BIT_MASK_EFS_HCI_SEL_V1)
#define BIT_SET_EFS_HCI_SEL_V1(x, v)                                           \
	(BIT_CLEAR_EFS_HCI_SEL_V1(x) | BIT_EFS_HCI_SEL_V1(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_STATUS1				(Offset 0x00F4) */

#define BIT_PAD_HWPDB BIT(0)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SYS_STATUS2				(Offset 0x00F8) */

#define BIT_HIOE_ON_TIMEOUT BIT(23)
#define BIT_SIC_ON_TIMEOUT BIT(22)
#define BIT_CPU_ON_TIMEOUT BIT(21)
#define BIT_HCI_ON_TIMEOUT BIT(20)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_STATUS2				(Offset 0x00F8) */

#define BIT_SIO_ALDN BIT(19)
#define BIT_USB_ALDN BIT(18)
#define BIT_PCI_ALDN BIT(17)
#define BIT_SYS_ALDN BIT(16)

#define BIT_SHIFT_EPVID1 8
#define BIT_MASK_EPVID1 0xff
#define BIT_EPVID1(x) (((x) & BIT_MASK_EPVID1) << BIT_SHIFT_EPVID1)
#define BITS_EPVID1 (BIT_MASK_EPVID1 << BIT_SHIFT_EPVID1)
#define BIT_CLEAR_EPVID1(x) ((x) & (~BITS_EPVID1))
#define BIT_GET_EPVID1(x) (((x) >> BIT_SHIFT_EPVID1) & BIT_MASK_EPVID1)
#define BIT_SET_EPVID1(x, v) (BIT_CLEAR_EPVID1(x) | BIT_EPVID1(v))

#define BIT_SHIFT_EPVID0 0
#define BIT_MASK_EPVID0 0xff
#define BIT_EPVID0(x) (((x) & BIT_MASK_EPVID0) << BIT_SHIFT_EPVID0)
#define BITS_EPVID0 (BIT_MASK_EPVID0 << BIT_SHIFT_EPVID0)
#define BIT_CLEAR_EPVID0(x) ((x) & (~BITS_EPVID0))
#define BIT_GET_EPVID0(x) (((x) >> BIT_SHIFT_EPVID0) & BIT_MASK_EPVID0)
#define BIT_SET_EPVID0(x, v) (BIT_CLEAR_EPVID0(x) | BIT_EPVID0(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_CFG2				(Offset 0x00FC) */

#define BIT_USB2_SEL_1 BIT(31)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_SYS_CFG2				(Offset 0x00FC) */

#define BIT_USB2_SEL BIT(31)
#define BIT_FEN_WLMAC_OFF BIT(31)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_CFG2				(Offset 0x00FC) */

#define BIT_USB3PHY_RST BIT(30)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_SYS_CFG2				(Offset 0x00FC) */

#define BIT_U3PHY_RST_V1 BIT(30)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_CFG2				(Offset 0x00FC) */

#define BIT_U3_TERM_DET BIT(29)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_SYS_CFG2				(Offset 0x00FC) */

#define BIT_U3_TERM_DETECT BIT(29)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_CFG2				(Offset 0x00FC) */

#define BIT_USB23_DBG_SEL BIT(24)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_SYS_CFG2				(Offset 0x00FC) */

#define BIT_HCI_SEL_EMBEDDED BIT(8)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_SYS_CFG2				(Offset 0x00FC) */

#define BIT_ISO_BB2PP BIT(7)
#define BIT_ISO_DENG2PP BIT(6)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_SYS_CFG2				(Offset 0x00FC) */

#define BIT_SHIFT_HW_ID 0
#define BIT_MASK_HW_ID 0xff
#define BIT_HW_ID(x) (((x) & BIT_MASK_HW_ID) << BIT_SHIFT_HW_ID)
#define BITS_HW_ID (BIT_MASK_HW_ID << BIT_SHIFT_HW_ID)
#define BIT_CLEAR_HW_ID(x) ((x) & (~BITS_HW_ID))
#define BIT_GET_HW_ID(x) (((x) >> BIT_SHIFT_HW_ID) & BIT_MASK_HW_ID)
#define BIT_SET_HW_ID(x, v) (BIT_CLEAR_HW_ID(x) | BIT_HW_ID(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_SYS_CFG2				(Offset 0x00FC) */

#define BIT_SHIFT_CHIPID 0
#define BIT_MASK_CHIPID 0xff
#define BIT_CHIPID(x) (((x) & BIT_MASK_CHIPID) << BIT_SHIFT_CHIPID)
#define BITS_CHIPID (BIT_MASK_CHIPID << BIT_SHIFT_CHIPID)
#define BIT_CLEAR_CHIPID(x) ((x) & (~BITS_CHIPID))
#define BIT_GET_CHIPID(x) (((x) >> BIT_SHIFT_CHIPID) & BIT_MASK_CHIPID)
#define BIT_SET_CHIPID(x, v) (BIT_CLEAR_CHIPID(x) | BIT_CHIPID(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_CR					(Offset 0x0100) */

#define BIT_BIST_H32BIT_SEL BIT(29)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_CR					(Offset 0x0100) */

#define BIT_MACIO_TIMEOUT_EN BIT(29)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_CR					(Offset 0x0100) */

#define BIT_SHIFT_LBMODE 24
#define BIT_MASK_LBMODE 0x1f
#define BIT_LBMODE(x) (((x) & BIT_MASK_LBMODE) << BIT_SHIFT_LBMODE)
#define BITS_LBMODE (BIT_MASK_LBMODE << BIT_SHIFT_LBMODE)
#define BIT_CLEAR_LBMODE(x) ((x) & (~BITS_LBMODE))
#define BIT_GET_LBMODE(x) (((x) >> BIT_SHIFT_LBMODE) & BIT_MASK_LBMODE)
#define BIT_SET_LBMODE(x, v) (BIT_CLEAR_LBMODE(x) | BIT_LBMODE(v))

#define BIT_SHIFT_NETYPE1 18
#define BIT_MASK_NETYPE1 0x3
#define BIT_NETYPE1(x) (((x) & BIT_MASK_NETYPE1) << BIT_SHIFT_NETYPE1)
#define BITS_NETYPE1 (BIT_MASK_NETYPE1 << BIT_SHIFT_NETYPE1)
#define BIT_CLEAR_NETYPE1(x) ((x) & (~BITS_NETYPE1))
#define BIT_GET_NETYPE1(x) (((x) >> BIT_SHIFT_NETYPE1) & BIT_MASK_NETYPE1)
#define BIT_SET_NETYPE1(x, v) (BIT_CLEAR_NETYPE1(x) | BIT_NETYPE1(v))

#define BIT_SHIFT_NETYPE0 16
#define BIT_MASK_NETYPE0 0x3
#define BIT_NETYPE0(x) (((x) & BIT_MASK_NETYPE0) << BIT_SHIFT_NETYPE0)
#define BITS_NETYPE0 (BIT_MASK_NETYPE0 << BIT_SHIFT_NETYPE0)
#define BIT_CLEAR_NETYPE0(x) ((x) & (~BITS_NETYPE0))
#define BIT_GET_NETYPE0(x) (((x) >> BIT_SHIFT_NETYPE0) & BIT_MASK_NETYPE0)
#define BIT_SET_NETYPE0(x, v) (BIT_CLEAR_NETYPE0(x) | BIT_NETYPE0(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT)

/* 2 REG_CR					(Offset 0x0100) */

#define BIT_STAT_FUNC_RST BIT(13)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_CR					(Offset 0x0100) */

#define BIT_COUNTER_STS_EN BIT(13)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_CR					(Offset 0x0100) */

#define BIT_PTA_I2C_MBOX_EN BIT(12)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_CR					(Offset 0x0100) */

#define BIT_I2C_MAILBOX_EN BIT(12)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_CR					(Offset 0x0100) */

#define BIT_SHCUT_EN BIT(11)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_CR					(Offset 0x0100) */

#define BIT_32K_CAL_TMR_EN BIT(10)
#define BIT_MAC_SEC_EN BIT(9)
#define BIT_ENSWBCN BIT(8)
#define BIT_MACRXEN BIT(7)
#define BIT_MACTXEN BIT(6)
#define BIT_SCHEDULE_EN BIT(5)
#define BIT_PROTOCOL_EN BIT(4)
#define BIT_RXDMA_EN BIT(3)
#define BIT_TXDMA_EN BIT(2)
#define BIT_HCI_RXDMA_EN BIT(1)
#define BIT_HCI_TXDMA_EN BIT(0)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_PG_SIZE				(Offset 0x0104) */

#define BIT_SHIFT_DBG_FIFO_SEL 16
#define BIT_MASK_DBG_FIFO_SEL 0xff
#define BIT_DBG_FIFO_SEL(x)                                                    \
	(((x) & BIT_MASK_DBG_FIFO_SEL) << BIT_SHIFT_DBG_FIFO_SEL)
#define BITS_DBG_FIFO_SEL (BIT_MASK_DBG_FIFO_SEL << BIT_SHIFT_DBG_FIFO_SEL)
#define BIT_CLEAR_DBG_FIFO_SEL(x) ((x) & (~BITS_DBG_FIFO_SEL))
#define BIT_GET_DBG_FIFO_SEL(x)                                                \
	(((x) >> BIT_SHIFT_DBG_FIFO_SEL) & BIT_MASK_DBG_FIFO_SEL)
#define BIT_SET_DBG_FIFO_SEL(x, v)                                             \
	(BIT_CLEAR_DBG_FIFO_SEL(x) | BIT_DBG_FIFO_SEL(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_PKT_BUFF_ACCESS_CTRL		(Offset 0x0106) */

#define BIT_SHIFT_PKT_BUFF_ACCESS_CTRL 0
#define BIT_MASK_PKT_BUFF_ACCESS_CTRL 0xff
#define BIT_PKT_BUFF_ACCESS_CTRL(x)                                            \
	(((x) & BIT_MASK_PKT_BUFF_ACCESS_CTRL)                                 \
	 << BIT_SHIFT_PKT_BUFF_ACCESS_CTRL)
#define BITS_PKT_BUFF_ACCESS_CTRL                                              \
	(BIT_MASK_PKT_BUFF_ACCESS_CTRL << BIT_SHIFT_PKT_BUFF_ACCESS_CTRL)
#define BIT_CLEAR_PKT_BUFF_ACCESS_CTRL(x) ((x) & (~BITS_PKT_BUFF_ACCESS_CTRL))
#define BIT_GET_PKT_BUFF_ACCESS_CTRL(x)                                        \
	(((x) >> BIT_SHIFT_PKT_BUFF_ACCESS_CTRL) &                             \
	 BIT_MASK_PKT_BUFF_ACCESS_CTRL)
#define BIT_SET_PKT_BUFF_ACCESS_CTRL(x, v)                                     \
	(BIT_CLEAR_PKT_BUFF_ACCESS_CTRL(x) | BIT_PKT_BUFF_ACCESS_CTRL(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_TSF_CLK_STATE			(Offset 0x0108) */

#define BIT_RXPKTBUF_DBG BIT(16)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_TSF_CLK_STATE			(Offset 0x0108) */

#define BIT_TSF_CLK_IDX BIT(15)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_TSF_CLK_STATE			(Offset 0x0108) */

#define BIT_TSF_CLK_STABLE BIT(15)

#define BIT_SHIFT_PKTBUF_DBG_ADDR 0
#define BIT_MASK_PKTBUF_DBG_ADDR 0x1fff
#define BIT_PKTBUF_DBG_ADDR(x)                                                 \
	(((x) & BIT_MASK_PKTBUF_DBG_ADDR) << BIT_SHIFT_PKTBUF_DBG_ADDR)
#define BITS_PKTBUF_DBG_ADDR                                                   \
	(BIT_MASK_PKTBUF_DBG_ADDR << BIT_SHIFT_PKTBUF_DBG_ADDR)
#define BIT_CLEAR_PKTBUF_DBG_ADDR(x) ((x) & (~BITS_PKTBUF_DBG_ADDR))
#define BIT_GET_PKTBUF_DBG_ADDR(x)                                             \
	(((x) >> BIT_SHIFT_PKTBUF_DBG_ADDR) & BIT_MASK_PKTBUF_DBG_ADDR)
#define BIT_SET_PKTBUF_DBG_ADDR(x, v)                                          \
	(BIT_CLEAR_PKTBUF_DBG_ADDR(x) | BIT_PKTBUF_DBG_ADDR(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_TXDMA_PQ_MAP			(Offset 0x010C) */

#define BIT_CSI_BW_EN BIT(31)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_TXDMA_PQ_MAP			(Offset 0x010C) */

#define BIT_SHIFT_TXDMA_HIQ_MAP_V1 19
#define BIT_MASK_TXDMA_HIQ_MAP_V1 0x7
#define BIT_TXDMA_HIQ_MAP_V1(x)                                                \
	(((x) & BIT_MASK_TXDMA_HIQ_MAP_V1) << BIT_SHIFT_TXDMA_HIQ_MAP_V1)
#define BITS_TXDMA_HIQ_MAP_V1                                                  \
	(BIT_MASK_TXDMA_HIQ_MAP_V1 << BIT_SHIFT_TXDMA_HIQ_MAP_V1)
#define BIT_CLEAR_TXDMA_HIQ_MAP_V1(x) ((x) & (~BITS_TXDMA_HIQ_MAP_V1))
#define BIT_GET_TXDMA_HIQ_MAP_V1(x)                                            \
	(((x) >> BIT_SHIFT_TXDMA_HIQ_MAP_V1) & BIT_MASK_TXDMA_HIQ_MAP_V1)
#define BIT_SET_TXDMA_HIQ_MAP_V1(x, v)                                         \
	(BIT_CLEAR_TXDMA_HIQ_MAP_V1(x) | BIT_TXDMA_HIQ_MAP_V1(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_TXDMA_PQ_MAP			(Offset 0x010C) */

#define BIT_SHIFT_TXDMA_CMQ_MAP 16
#define BIT_MASK_TXDMA_CMQ_MAP 0x3
#define BIT_TXDMA_CMQ_MAP(x)                                                   \
	(((x) & BIT_MASK_TXDMA_CMQ_MAP) << BIT_SHIFT_TXDMA_CMQ_MAP)
#define BITS_TXDMA_CMQ_MAP (BIT_MASK_TXDMA_CMQ_MAP << BIT_SHIFT_TXDMA_CMQ_MAP)
#define BIT_CLEAR_TXDMA_CMQ_MAP(x) ((x) & (~BITS_TXDMA_CMQ_MAP))
#define BIT_GET_TXDMA_CMQ_MAP(x)                                               \
	(((x) >> BIT_SHIFT_TXDMA_CMQ_MAP) & BIT_MASK_TXDMA_CMQ_MAP)
#define BIT_SET_TXDMA_CMQ_MAP(x, v)                                            \
	(BIT_CLEAR_TXDMA_CMQ_MAP(x) | BIT_TXDMA_CMQ_MAP(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_TXDMA_PQ_MAP			(Offset 0x010C) */

#define BIT_SHIFT_TXDMA_MGQ_MAP_V1 16
#define BIT_MASK_TXDMA_MGQ_MAP_V1 0x7
#define BIT_TXDMA_MGQ_MAP_V1(x)                                                \
	(((x) & BIT_MASK_TXDMA_MGQ_MAP_V1) << BIT_SHIFT_TXDMA_MGQ_MAP_V1)
#define BITS_TXDMA_MGQ_MAP_V1                                                  \
	(BIT_MASK_TXDMA_MGQ_MAP_V1 << BIT_SHIFT_TXDMA_MGQ_MAP_V1)
#define BIT_CLEAR_TXDMA_MGQ_MAP_V1(x) ((x) & (~BITS_TXDMA_MGQ_MAP_V1))
#define BIT_GET_TXDMA_MGQ_MAP_V1(x)                                            \
	(((x) >> BIT_SHIFT_TXDMA_MGQ_MAP_V1) & BIT_MASK_TXDMA_MGQ_MAP_V1)
#define BIT_SET_TXDMA_MGQ_MAP_V1(x, v)                                         \
	(BIT_CLEAR_TXDMA_MGQ_MAP_V1(x) | BIT_TXDMA_MGQ_MAP_V1(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_TXDMA_PQ_MAP			(Offset 0x010C) */

#define BIT_SHIFT_TXDMA_H2C_MAP 16
#define BIT_MASK_TXDMA_H2C_MAP 0x3
#define BIT_TXDMA_H2C_MAP(x)                                                   \
	(((x) & BIT_MASK_TXDMA_H2C_MAP) << BIT_SHIFT_TXDMA_H2C_MAP)
#define BITS_TXDMA_H2C_MAP (BIT_MASK_TXDMA_H2C_MAP << BIT_SHIFT_TXDMA_H2C_MAP)
#define BIT_CLEAR_TXDMA_H2C_MAP(x) ((x) & (~BITS_TXDMA_H2C_MAP))
#define BIT_GET_TXDMA_H2C_MAP(x)                                               \
	(((x) >> BIT_SHIFT_TXDMA_H2C_MAP) & BIT_MASK_TXDMA_H2C_MAP)
#define BIT_SET_TXDMA_H2C_MAP(x, v)                                            \
	(BIT_CLEAR_TXDMA_H2C_MAP(x) | BIT_TXDMA_H2C_MAP(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_TXDMA_PQ_MAP			(Offset 0x010C) */

#define BIT_SHIFT_TXDMA_HIQ_MAP 14
#define BIT_MASK_TXDMA_HIQ_MAP 0x3
#define BIT_TXDMA_HIQ_MAP(x)                                                   \
	(((x) & BIT_MASK_TXDMA_HIQ_MAP) << BIT_SHIFT_TXDMA_HIQ_MAP)
#define BITS_TXDMA_HIQ_MAP (BIT_MASK_TXDMA_HIQ_MAP << BIT_SHIFT_TXDMA_HIQ_MAP)
#define BIT_CLEAR_TXDMA_HIQ_MAP(x) ((x) & (~BITS_TXDMA_HIQ_MAP))
#define BIT_GET_TXDMA_HIQ_MAP(x)                                               \
	(((x) >> BIT_SHIFT_TXDMA_HIQ_MAP) & BIT_MASK_TXDMA_HIQ_MAP)
#define BIT_SET_TXDMA_HIQ_MAP(x, v)                                            \
	(BIT_CLEAR_TXDMA_HIQ_MAP(x) | BIT_TXDMA_HIQ_MAP(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_TXDMA_PQ_MAP			(Offset 0x010C) */

#define BIT_SHIFT_TXDMA_BKQ_MAP_V1 13
#define BIT_MASK_TXDMA_BKQ_MAP_V1 0x7
#define BIT_TXDMA_BKQ_MAP_V1(x)                                                \
	(((x) & BIT_MASK_TXDMA_BKQ_MAP_V1) << BIT_SHIFT_TXDMA_BKQ_MAP_V1)
#define BITS_TXDMA_BKQ_MAP_V1                                                  \
	(BIT_MASK_TXDMA_BKQ_MAP_V1 << BIT_SHIFT_TXDMA_BKQ_MAP_V1)
#define BIT_CLEAR_TXDMA_BKQ_MAP_V1(x) ((x) & (~BITS_TXDMA_BKQ_MAP_V1))
#define BIT_GET_TXDMA_BKQ_MAP_V1(x)                                            \
	(((x) >> BIT_SHIFT_TXDMA_BKQ_MAP_V1) & BIT_MASK_TXDMA_BKQ_MAP_V1)
#define BIT_SET_TXDMA_BKQ_MAP_V1(x, v)                                         \
	(BIT_CLEAR_TXDMA_BKQ_MAP_V1(x) | BIT_TXDMA_BKQ_MAP_V1(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_TXDMA_PQ_MAP			(Offset 0x010C) */

#define BIT_SHIFT_TXDMA_MGQ_MAP 12
#define BIT_MASK_TXDMA_MGQ_MAP 0x3
#define BIT_TXDMA_MGQ_MAP(x)                                                   \
	(((x) & BIT_MASK_TXDMA_MGQ_MAP) << BIT_SHIFT_TXDMA_MGQ_MAP)
#define BITS_TXDMA_MGQ_MAP (BIT_MASK_TXDMA_MGQ_MAP << BIT_SHIFT_TXDMA_MGQ_MAP)
#define BIT_CLEAR_TXDMA_MGQ_MAP(x) ((x) & (~BITS_TXDMA_MGQ_MAP))
#define BIT_GET_TXDMA_MGQ_MAP(x)                                               \
	(((x) >> BIT_SHIFT_TXDMA_MGQ_MAP) & BIT_MASK_TXDMA_MGQ_MAP)
#define BIT_SET_TXDMA_MGQ_MAP(x, v)                                            \
	(BIT_CLEAR_TXDMA_MGQ_MAP(x) | BIT_TXDMA_MGQ_MAP(v))

#define BIT_SHIFT_TXDMA_BKQ_MAP 10
#define BIT_MASK_TXDMA_BKQ_MAP 0x3
#define BIT_TXDMA_BKQ_MAP(x)                                                   \
	(((x) & BIT_MASK_TXDMA_BKQ_MAP) << BIT_SHIFT_TXDMA_BKQ_MAP)
#define BITS_TXDMA_BKQ_MAP (BIT_MASK_TXDMA_BKQ_MAP << BIT_SHIFT_TXDMA_BKQ_MAP)
#define BIT_CLEAR_TXDMA_BKQ_MAP(x) ((x) & (~BITS_TXDMA_BKQ_MAP))
#define BIT_GET_TXDMA_BKQ_MAP(x)                                               \
	(((x) >> BIT_SHIFT_TXDMA_BKQ_MAP) & BIT_MASK_TXDMA_BKQ_MAP)
#define BIT_SET_TXDMA_BKQ_MAP(x, v)                                            \
	(BIT_CLEAR_TXDMA_BKQ_MAP(x) | BIT_TXDMA_BKQ_MAP(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_TXDMA_PQ_MAP			(Offset 0x010C) */

#define BIT_SHIFT_TXDMA_BEQ_MAP_V1 10
#define BIT_MASK_TXDMA_BEQ_MAP_V1 0x7
#define BIT_TXDMA_BEQ_MAP_V1(x)                                                \
	(((x) & BIT_MASK_TXDMA_BEQ_MAP_V1) << BIT_SHIFT_TXDMA_BEQ_MAP_V1)
#define BITS_TXDMA_BEQ_MAP_V1                                                  \
	(BIT_MASK_TXDMA_BEQ_MAP_V1 << BIT_SHIFT_TXDMA_BEQ_MAP_V1)
#define BIT_CLEAR_TXDMA_BEQ_MAP_V1(x) ((x) & (~BITS_TXDMA_BEQ_MAP_V1))
#define BIT_GET_TXDMA_BEQ_MAP_V1(x)                                            \
	(((x) >> BIT_SHIFT_TXDMA_BEQ_MAP_V1) & BIT_MASK_TXDMA_BEQ_MAP_V1)
#define BIT_SET_TXDMA_BEQ_MAP_V1(x, v)                                         \
	(BIT_CLEAR_TXDMA_BEQ_MAP_V1(x) | BIT_TXDMA_BEQ_MAP_V1(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_TXDMA_PQ_MAP			(Offset 0x010C) */

#define BIT_SHIFT_TXDMA_BEQ_MAP 8
#define BIT_MASK_TXDMA_BEQ_MAP 0x3
#define BIT_TXDMA_BEQ_MAP(x)                                                   \
	(((x) & BIT_MASK_TXDMA_BEQ_MAP) << BIT_SHIFT_TXDMA_BEQ_MAP)
#define BITS_TXDMA_BEQ_MAP (BIT_MASK_TXDMA_BEQ_MAP << BIT_SHIFT_TXDMA_BEQ_MAP)
#define BIT_CLEAR_TXDMA_BEQ_MAP(x) ((x) & (~BITS_TXDMA_BEQ_MAP))
#define BIT_GET_TXDMA_BEQ_MAP(x)                                               \
	(((x) >> BIT_SHIFT_TXDMA_BEQ_MAP) & BIT_MASK_TXDMA_BEQ_MAP)
#define BIT_SET_TXDMA_BEQ_MAP(x, v)                                            \
	(BIT_CLEAR_TXDMA_BEQ_MAP(x) | BIT_TXDMA_BEQ_MAP(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_TXDMA_PQ_MAP			(Offset 0x010C) */

#define BIT_SHIFT_TXDMA_VIQ_MAP_V1 7
#define BIT_MASK_TXDMA_VIQ_MAP_V1 0x7
#define BIT_TXDMA_VIQ_MAP_V1(x)                                                \
	(((x) & BIT_MASK_TXDMA_VIQ_MAP_V1) << BIT_SHIFT_TXDMA_VIQ_MAP_V1)
#define BITS_TXDMA_VIQ_MAP_V1                                                  \
	(BIT_MASK_TXDMA_VIQ_MAP_V1 << BIT_SHIFT_TXDMA_VIQ_MAP_V1)
#define BIT_CLEAR_TXDMA_VIQ_MAP_V1(x) ((x) & (~BITS_TXDMA_VIQ_MAP_V1))
#define BIT_GET_TXDMA_VIQ_MAP_V1(x)                                            \
	(((x) >> BIT_SHIFT_TXDMA_VIQ_MAP_V1) & BIT_MASK_TXDMA_VIQ_MAP_V1)
#define BIT_SET_TXDMA_VIQ_MAP_V1(x, v)                                         \
	(BIT_CLEAR_TXDMA_VIQ_MAP_V1(x) | BIT_TXDMA_VIQ_MAP_V1(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_TXDMA_PQ_MAP			(Offset 0x010C) */

#define BIT_SHIFT_TXDMA_VIQ_MAP 6
#define BIT_MASK_TXDMA_VIQ_MAP 0x3
#define BIT_TXDMA_VIQ_MAP(x)                                                   \
	(((x) & BIT_MASK_TXDMA_VIQ_MAP) << BIT_SHIFT_TXDMA_VIQ_MAP)
#define BITS_TXDMA_VIQ_MAP (BIT_MASK_TXDMA_VIQ_MAP << BIT_SHIFT_TXDMA_VIQ_MAP)
#define BIT_CLEAR_TXDMA_VIQ_MAP(x) ((x) & (~BITS_TXDMA_VIQ_MAP))
#define BIT_GET_TXDMA_VIQ_MAP(x)                                               \
	(((x) >> BIT_SHIFT_TXDMA_VIQ_MAP) & BIT_MASK_TXDMA_VIQ_MAP)
#define BIT_SET_TXDMA_VIQ_MAP(x, v)                                            \
	(BIT_CLEAR_TXDMA_VIQ_MAP(x) | BIT_TXDMA_VIQ_MAP(v))

#define BIT_SHIFT_TXDMA_VOQ_MAP 4
#define BIT_MASK_TXDMA_VOQ_MAP 0x3
#define BIT_TXDMA_VOQ_MAP(x)                                                   \
	(((x) & BIT_MASK_TXDMA_VOQ_MAP) << BIT_SHIFT_TXDMA_VOQ_MAP)
#define BITS_TXDMA_VOQ_MAP (BIT_MASK_TXDMA_VOQ_MAP << BIT_SHIFT_TXDMA_VOQ_MAP)
#define BIT_CLEAR_TXDMA_VOQ_MAP(x) ((x) & (~BITS_TXDMA_VOQ_MAP))
#define BIT_GET_TXDMA_VOQ_MAP(x)                                               \
	(((x) >> BIT_SHIFT_TXDMA_VOQ_MAP) & BIT_MASK_TXDMA_VOQ_MAP)
#define BIT_SET_TXDMA_VOQ_MAP(x, v)                                            \
	(BIT_CLEAR_TXDMA_VOQ_MAP(x) | BIT_TXDMA_VOQ_MAP(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_TXDMA_PQ_MAP			(Offset 0x010C) */

#define BIT_SHIFT_TXDMA_VOQ_MAP_V1 4
#define BIT_MASK_TXDMA_VOQ_MAP_V1 0x7
#define BIT_TXDMA_VOQ_MAP_V1(x)                                                \
	(((x) & BIT_MASK_TXDMA_VOQ_MAP_V1) << BIT_SHIFT_TXDMA_VOQ_MAP_V1)
#define BITS_TXDMA_VOQ_MAP_V1                                                  \
	(BIT_MASK_TXDMA_VOQ_MAP_V1 << BIT_SHIFT_TXDMA_VOQ_MAP_V1)
#define BIT_CLEAR_TXDMA_VOQ_MAP_V1(x) ((x) & (~BITS_TXDMA_VOQ_MAP_V1))
#define BIT_GET_TXDMA_VOQ_MAP_V1(x)                                            \
	(((x) >> BIT_SHIFT_TXDMA_VOQ_MAP_V1) & BIT_MASK_TXDMA_VOQ_MAP_V1)
#define BIT_SET_TXDMA_VOQ_MAP_V1(x, v)                                         \
	(BIT_CLEAR_TXDMA_VOQ_MAP_V1(x) | BIT_TXDMA_VOQ_MAP_V1(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_TXDMA_PQ_MAP			(Offset 0x010C) */

#define BIT_TXDMA_BW_EN BIT(3)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_TXDMA_PQ_MAP			(Offset 0x010C) */

#define BIT_RXDMA_AGG_EN BIT(2)
#define BIT_RXSHFT_EN BIT(1)
#define BIT_RXDMA_ARBBW_EN BIT(0)

#endif

#if (HALMAC_8814A_SUPPORT)

/* 2 REG_TRXFF_BNDY				(Offset 0x0114) */

#define BIT_SHIFT_RXFFOVFL_RSV_V1 28
#define BIT_MASK_RXFFOVFL_RSV_V1 0xf
#define BIT_RXFFOVFL_RSV_V1(x)                                                 \
	(((x) & BIT_MASK_RXFFOVFL_RSV_V1) << BIT_SHIFT_RXFFOVFL_RSV_V1)
#define BITS_RXFFOVFL_RSV_V1                                                   \
	(BIT_MASK_RXFFOVFL_RSV_V1 << BIT_SHIFT_RXFFOVFL_RSV_V1)
#define BIT_CLEAR_RXFFOVFL_RSV_V1(x) ((x) & (~BITS_RXFFOVFL_RSV_V1))
#define BIT_GET_RXFFOVFL_RSV_V1(x)                                             \
	(((x) >> BIT_SHIFT_RXFFOVFL_RSV_V1) & BIT_MASK_RXFFOVFL_RSV_V1)
#define BIT_SET_RXFFOVFL_RSV_V1(x, v)                                          \
	(BIT_CLEAR_RXFFOVFL_RSV_V1(x) | BIT_RXFFOVFL_RSV_V1(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_TRXFF_BNDY				(Offset 0x0114) */

#define BIT_SHIFT_RXFF0_BNDY 16
#define BIT_MASK_RXFF0_BNDY 0xffff
#define BIT_RXFF0_BNDY(x) (((x) & BIT_MASK_RXFF0_BNDY) << BIT_SHIFT_RXFF0_BNDY)
#define BITS_RXFF0_BNDY (BIT_MASK_RXFF0_BNDY << BIT_SHIFT_RXFF0_BNDY)
#define BIT_CLEAR_RXFF0_BNDY(x) ((x) & (~BITS_RXFF0_BNDY))
#define BIT_GET_RXFF0_BNDY(x)                                                  \
	(((x) >> BIT_SHIFT_RXFF0_BNDY) & BIT_MASK_RXFF0_BNDY)
#define BIT_SET_RXFF0_BNDY(x, v) (BIT_CLEAR_RXFF0_BNDY(x) | BIT_RXFF0_BNDY(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_TRXFF_BNDY				(Offset 0x0114) */

#define BIT_SHIFT_FWFFOVFL_RSV 16
#define BIT_MASK_FWFFOVFL_RSV 0xf
#define BIT_FWFFOVFL_RSV(x)                                                    \
	(((x) & BIT_MASK_FWFFOVFL_RSV) << BIT_SHIFT_FWFFOVFL_RSV)
#define BITS_FWFFOVFL_RSV (BIT_MASK_FWFFOVFL_RSV << BIT_SHIFT_FWFFOVFL_RSV)
#define BIT_CLEAR_FWFFOVFL_RSV(x) ((x) & (~BITS_FWFFOVFL_RSV))
#define BIT_GET_FWFFOVFL_RSV(x)                                                \
	(((x) >> BIT_SHIFT_FWFFOVFL_RSV) & BIT_MASK_FWFFOVFL_RSV)
#define BIT_SET_FWFFOVFL_RSV(x, v)                                             \
	(BIT_CLEAR_FWFFOVFL_RSV(x) | BIT_FWFFOVFL_RSV(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_TRXFF_BNDY				(Offset 0x0114) */

#define BIT_SHIFT_RXFFOVFL_RSV 8
#define BIT_MASK_RXFFOVFL_RSV 0xf
#define BIT_RXFFOVFL_RSV(x)                                                    \
	(((x) & BIT_MASK_RXFFOVFL_RSV) << BIT_SHIFT_RXFFOVFL_RSV)
#define BITS_RXFFOVFL_RSV (BIT_MASK_RXFFOVFL_RSV << BIT_SHIFT_RXFFOVFL_RSV)
#define BIT_CLEAR_RXFFOVFL_RSV(x) ((x) & (~BITS_RXFFOVFL_RSV))
#define BIT_GET_RXFFOVFL_RSV(x)                                                \
	(((x) >> BIT_SHIFT_RXFFOVFL_RSV) & BIT_MASK_RXFFOVFL_RSV)
#define BIT_SET_RXFFOVFL_RSV(x, v)                                             \
	(BIT_CLEAR_RXFFOVFL_RSV(x) | BIT_RXFFOVFL_RSV(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_TRXFF_BNDY				(Offset 0x0114) */

#define BIT_SHIFT_RXFFOVFL_RSV_V2 8
#define BIT_MASK_RXFFOVFL_RSV_V2 0xf
#define BIT_RXFFOVFL_RSV_V2(x)                                                 \
	(((x) & BIT_MASK_RXFFOVFL_RSV_V2) << BIT_SHIFT_RXFFOVFL_RSV_V2)
#define BITS_RXFFOVFL_RSV_V2                                                   \
	(BIT_MASK_RXFFOVFL_RSV_V2 << BIT_SHIFT_RXFFOVFL_RSV_V2)
#define BIT_CLEAR_RXFFOVFL_RSV_V2(x) ((x) & (~BITS_RXFFOVFL_RSV_V2))
#define BIT_GET_RXFFOVFL_RSV_V2(x)                                             \
	(((x) >> BIT_SHIFT_RXFFOVFL_RSV_V2) & BIT_MASK_RXFFOVFL_RSV_V2)
#define BIT_SET_RXFFOVFL_RSV_V2(x, v)                                          \
	(BIT_CLEAR_RXFFOVFL_RSV_V2(x) | BIT_RXFFOVFL_RSV_V2(v))

#endif

#if (HALMAC_8814A_SUPPORT)

/* 2 REG_TRXFF_BNDY				(Offset 0x0114) */

#define BIT_SHIFT_RXFF0_BNDY_V1 8
#define BIT_MASK_RXFF0_BNDY_V1 0x3ffff
#define BIT_RXFF0_BNDY_V1(x)                                                   \
	(((x) & BIT_MASK_RXFF0_BNDY_V1) << BIT_SHIFT_RXFF0_BNDY_V1)
#define BITS_RXFF0_BNDY_V1 (BIT_MASK_RXFF0_BNDY_V1 << BIT_SHIFT_RXFF0_BNDY_V1)
#define BIT_CLEAR_RXFF0_BNDY_V1(x) ((x) & (~BITS_RXFF0_BNDY_V1))
#define BIT_GET_RXFF0_BNDY_V1(x)                                               \
	(((x) >> BIT_SHIFT_RXFF0_BNDY_V1) & BIT_MASK_RXFF0_BNDY_V1)
#define BIT_SET_RXFF0_BNDY_V1(x, v)                                            \
	(BIT_CLEAR_RXFF0_BNDY_V1(x) | BIT_RXFF0_BNDY_V1(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8822B_SUPPORT || \
     HALMAC_8881A_SUPPORT)

/* 2 REG_TRXFF_BNDY				(Offset 0x0114) */

#define BIT_SHIFT_TXPKTBUF_PGBNDY 0
#define BIT_MASK_TXPKTBUF_PGBNDY 0xff
#define BIT_TXPKTBUF_PGBNDY(x)                                                 \
	(((x) & BIT_MASK_TXPKTBUF_PGBNDY) << BIT_SHIFT_TXPKTBUF_PGBNDY)
#define BITS_TXPKTBUF_PGBNDY                                                   \
	(BIT_MASK_TXPKTBUF_PGBNDY << BIT_SHIFT_TXPKTBUF_PGBNDY)
#define BIT_CLEAR_TXPKTBUF_PGBNDY(x) ((x) & (~BITS_TXPKTBUF_PGBNDY))
#define BIT_GET_TXPKTBUF_PGBNDY(x)                                             \
	(((x) >> BIT_SHIFT_TXPKTBUF_PGBNDY) & BIT_MASK_TXPKTBUF_PGBNDY)
#define BIT_SET_TXPKTBUF_PGBNDY(x, v)                                          \
	(BIT_CLEAR_TXPKTBUF_PGBNDY(x) | BIT_TXPKTBUF_PGBNDY(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_PTA_I2C_MBOX			(Offset 0x0118) */

#define BIT_SHIFT_RESP_TXPOWER 18
#define BIT_MASK_RESP_TXPOWER 0x7
#define BIT_RESP_TXPOWER(x)                                                    \
	(((x) & BIT_MASK_RESP_TXPOWER) << BIT_SHIFT_RESP_TXPOWER)
#define BITS_RESP_TXPOWER (BIT_MASK_RESP_TXPOWER << BIT_SHIFT_RESP_TXPOWER)
#define BIT_CLEAR_RESP_TXPOWER(x) ((x) & (~BITS_RESP_TXPOWER))
#define BIT_GET_RESP_TXPOWER(x)                                                \
	(((x) >> BIT_SHIFT_RESP_TXPOWER) & BIT_MASK_RESP_TXPOWER)
#define BIT_SET_RESP_TXPOWER(x, v)                                             \
	(BIT_CLEAR_RESP_TXPOWER(x) | BIT_RESP_TXPOWER(v))

#endif

#if (HALMAC_8814A_SUPPORT)

/* 2 REG_FF_STATUS				(Offset 0x0118) */

#define BIT_SHIFT_RXFF0_RDPTR_V1 13
#define BIT_MASK_RXFF0_RDPTR_V1 0x3ffff
#define BIT_RXFF0_RDPTR_V1(x)                                                  \
	(((x) & BIT_MASK_RXFF0_RDPTR_V1) << BIT_SHIFT_RXFF0_RDPTR_V1)
#define BITS_RXFF0_RDPTR_V1                                                    \
	(BIT_MASK_RXFF0_RDPTR_V1 << BIT_SHIFT_RXFF0_RDPTR_V1)
#define BIT_CLEAR_RXFF0_RDPTR_V1(x) ((x) & (~BITS_RXFF0_RDPTR_V1))
#define BIT_GET_RXFF0_RDPTR_V1(x)                                              \
	(((x) >> BIT_SHIFT_RXFF0_RDPTR_V1) & BIT_MASK_RXFF0_RDPTR_V1)
#define BIT_SET_RXFF0_RDPTR_V1(x, v)                                           \
	(BIT_CLEAR_RXFF0_RDPTR_V1(x) | BIT_RXFF0_RDPTR_V1(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_PTA_I2C_MBOX			(Offset 0x0118) */

#define BIT_SHIFT_I2C_M_STATUS 8
#define BIT_MASK_I2C_M_STATUS 0xf
#define BIT_I2C_M_STATUS(x)                                                    \
	(((x) & BIT_MASK_I2C_M_STATUS) << BIT_SHIFT_I2C_M_STATUS)
#define BITS_I2C_M_STATUS (BIT_MASK_I2C_M_STATUS << BIT_SHIFT_I2C_M_STATUS)
#define BIT_CLEAR_I2C_M_STATUS(x) ((x) & (~BITS_I2C_M_STATUS))
#define BIT_GET_I2C_M_STATUS(x)                                                \
	(((x) >> BIT_SHIFT_I2C_M_STATUS) & BIT_MASK_I2C_M_STATUS)
#define BIT_SET_I2C_M_STATUS(x, v)                                             \
	(BIT_CLEAR_I2C_M_STATUS(x) | BIT_I2C_M_STATUS(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_PTA_I2C_MBOX			(Offset 0x0118) */

#define BIT_SHIFT_I2C_M_BUS_GNT 4
#define BIT_MASK_I2C_M_BUS_GNT 0x7
#define BIT_I2C_M_BUS_GNT(x)                                                   \
	(((x) & BIT_MASK_I2C_M_BUS_GNT) << BIT_SHIFT_I2C_M_BUS_GNT)
#define BITS_I2C_M_BUS_GNT (BIT_MASK_I2C_M_BUS_GNT << BIT_SHIFT_I2C_M_BUS_GNT)
#define BIT_CLEAR_I2C_M_BUS_GNT(x) ((x) & (~BITS_I2C_M_BUS_GNT))
#define BIT_GET_I2C_M_BUS_GNT(x)                                               \
	(((x) >> BIT_SHIFT_I2C_M_BUS_GNT) & BIT_MASK_I2C_M_BUS_GNT)
#define BIT_SET_I2C_M_BUS_GNT(x, v)                                            \
	(BIT_CLEAR_I2C_M_BUS_GNT(x) | BIT_I2C_M_BUS_GNT(v))

#define BIT_I2C_GNT_FW BIT(3)

#define BIT_SHIFT_I2C_DATA_RATE 1
#define BIT_MASK_I2C_DATA_RATE 0x3
#define BIT_I2C_DATA_RATE(x)                                                   \
	(((x) & BIT_MASK_I2C_DATA_RATE) << BIT_SHIFT_I2C_DATA_RATE)
#define BITS_I2C_DATA_RATE (BIT_MASK_I2C_DATA_RATE << BIT_SHIFT_I2C_DATA_RATE)
#define BIT_CLEAR_I2C_DATA_RATE(x) ((x) & (~BITS_I2C_DATA_RATE))
#define BIT_GET_I2C_DATA_RATE(x)                                               \
	(((x) >> BIT_SHIFT_I2C_DATA_RATE) & BIT_MASK_I2C_DATA_RATE)
#define BIT_SET_I2C_DATA_RATE(x, v)                                            \
	(BIT_CLEAR_I2C_DATA_RATE(x) | BIT_I2C_DATA_RATE(v))

#define BIT_I2C_SW_CONTROL_UNLOCK BIT(0)

#endif

#if (HALMAC_8814A_SUPPORT)

/* 2 REG_FF_STATUS				(Offset 0x0118) */

#define BIT_SHIFT_RXFF0_WTPTR_V1 0
#define BIT_MASK_RXFF0_WTPTR_V1 0x3ffff
#define BIT_RXFF0_WTPTR_V1(x)                                                  \
	(((x) & BIT_MASK_RXFF0_WTPTR_V1) << BIT_SHIFT_RXFF0_WTPTR_V1)
#define BITS_RXFF0_WTPTR_V1                                                    \
	(BIT_MASK_RXFF0_WTPTR_V1 << BIT_SHIFT_RXFF0_WTPTR_V1)
#define BIT_CLEAR_RXFF0_WTPTR_V1(x) ((x) & (~BITS_RXFF0_WTPTR_V1))
#define BIT_GET_RXFF0_WTPTR_V1(x)                                              \
	(((x) >> BIT_SHIFT_RXFF0_WTPTR_V1) & BIT_MASK_RXFF0_WTPTR_V1)
#define BIT_SET_RXFF0_WTPTR_V1(x, v)                                           \
	(BIT_CLEAR_RXFF0_WTPTR_V1(x) | BIT_RXFF0_WTPTR_V1(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_RXFF_PTR				(Offset 0x011C) */

#define BIT_SHIFT_RXFF0_RDPTR 16
#define BIT_MASK_RXFF0_RDPTR 0xffff
#define BIT_RXFF0_RDPTR(x)                                                     \
	(((x) & BIT_MASK_RXFF0_RDPTR) << BIT_SHIFT_RXFF0_RDPTR)
#define BITS_RXFF0_RDPTR (BIT_MASK_RXFF0_RDPTR << BIT_SHIFT_RXFF0_RDPTR)
#define BIT_CLEAR_RXFF0_RDPTR(x) ((x) & (~BITS_RXFF0_RDPTR))
#define BIT_GET_RXFF0_RDPTR(x)                                                 \
	(((x) >> BIT_SHIFT_RXFF0_RDPTR) & BIT_MASK_RXFF0_RDPTR)
#define BIT_SET_RXFF0_RDPTR(x, v)                                              \
	(BIT_CLEAR_RXFF0_RDPTR(x) | BIT_RXFF0_RDPTR(v))

#define BIT_SHIFT_RXFF0_WTPTR 0
#define BIT_MASK_RXFF0_WTPTR 0xffff
#define BIT_RXFF0_WTPTR(x)                                                     \
	(((x) & BIT_MASK_RXFF0_WTPTR) << BIT_SHIFT_RXFF0_WTPTR)
#define BITS_RXFF0_WTPTR (BIT_MASK_RXFF0_WTPTR << BIT_SHIFT_RXFF0_WTPTR)
#define BIT_CLEAR_RXFF0_WTPTR(x) ((x) & (~BITS_RXFF0_WTPTR))
#define BIT_GET_RXFF0_WTPTR(x)                                                 \
	(((x) >> BIT_SHIFT_RXFF0_WTPTR) & BIT_MASK_RXFF0_WTPTR)
#define BIT_SET_RXFF0_WTPTR(x, v)                                              \
	(BIT_CLEAR_RXFF0_WTPTR(x) | BIT_RXFF0_WTPTR(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEIMR				(Offset 0x0120) */

#define BIT_H2C_OK_INT_MSK BIT(31)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FE1IMR				(Offset 0x0120) */

#define BIT_FS_SW_PLL_LEAVE_32K_INT_EN BIT(31)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_FE1IMR				(Offset 0x0120) */

#define BIT_CPUMGQ_DROP_BY_HOLD_TIME_INT_EN BIT(31)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEIMR				(Offset 0x0120) */

#define BIT_H2C_CMD_FULL_INT_MSK BIT(30)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FE1IMR				(Offset 0x0120) */

#define BIT_FS_FWFF_FULL_INT_EN BIT(30)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_FE1IMR				(Offset 0x0120) */

#define BIT_FWFF_FULL_INT_EN BIT(30)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEIMR				(Offset 0x0120) */

#define BIT_PWR_INT_127_MSK_V1 BIT(29)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT)

/* 2 REG_FE1IMR				(Offset 0x0120) */

#define BIT_BB_STOP_RX_INT_EN BIT(29)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FE1IMR				(Offset 0x0120) */

#define BIT_FS_BB_STOP_RX_INT_EN BIT(29)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEIMR				(Offset 0x0120) */

#define BIT_PWR_INT_126_MSK BIT(28)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FE1IMR				(Offset 0x0120) */

#define BIT_FS_RXDMA2_DONE_INT_EN BIT(28)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEIMR				(Offset 0x0120) */

#define BIT_PWR_INT_125TO96_MSK BIT(27)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_FE1IMR				(Offset 0x0120) */

#define BIT_FS_RXDONE3_INT_EN BIT(27)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEIMR				(Offset 0x0120) */

#define BIT_PWR_INT_95TO64_MSK_V1 BIT(26)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FE1IMR				(Offset 0x0120) */

#define BIT_FS_RXDONE2_INT_EN BIT(26)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEIMR				(Offset 0x0120) */

#define BIT_PWR_INT_63TO32_MSK_V1 BIT(25)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FE1IMR				(Offset 0x0120) */

#define BIT_FS_RX_BCN_P4_INT_EN BIT(25)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEIMR				(Offset 0x0120) */

#define BIT_PWR_INT_31TO0_MSK_V1 BIT(24)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FE1IMR				(Offset 0x0120) */

#define BIT_FS_RX_BCN_P3_INT_EN BIT(24)
#define BIT_FS_RX_BCN_P2_INT_EN BIT(23)
#define BIT_FS_RX_BCN_P1_INT_EN BIT(22)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEIMR				(Offset 0x0120) */

#define BIT_BF0_TIMEOUT_INT_MSK BIT(21)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FE1IMR				(Offset 0x0120) */

#define BIT_FS_RX_BCN_P0_INT_EN BIT(21)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEIMR				(Offset 0x0120) */

#define BIT_BF1_TIMEOUT_INT_MSK BIT(20)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FE1IMR				(Offset 0x0120) */

#define BIT_FS_RX_UMD0_INT_EN BIT(20)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEIMR				(Offset 0x0120) */

#define BIT_EVTQ_TXDONE_INT_MSK BIT(19)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FE1IMR				(Offset 0x0120) */

#define BIT_FS_RX_UMD1_INT_EN BIT(19)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEIMR				(Offset 0x0120) */

#define BIT_EVTQ_START_INT_MSK BIT(18)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FE1IMR				(Offset 0x0120) */

#define BIT_FS_RX_BMD0_INT_EN BIT(18)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEIMR				(Offset 0x0120) */

#define BIT_TXBCN2_OK_INT_MSK BIT(17)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FE1IMR				(Offset 0x0120) */

#define BIT_FS_RX_BMD1_INT_EN BIT(17)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEIMR				(Offset 0x0120) */

#define BIT_TXBCN2_ERR_INT_MSK BIT(16)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FE1IMR				(Offset 0x0120) */

#define BIT_FS_RXDONE_INT_EN BIT(16)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEIMR				(Offset 0x0120) */

#define BIT_DWWIN_END_INT_MSK BIT(15)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FE1IMR				(Offset 0x0120) */

#define BIT_FS_WWLAN_INT_EN BIT(15)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEIMR				(Offset 0x0120) */

#define BIT_BCN2_EARLY_INT_MSK BIT(14)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FE1IMR				(Offset 0x0120) */

#define BIT_FS_SOUND_DONE_INT_EN BIT(14)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEIMR				(Offset 0x0120) */

#define BIT_TBTT1_INT_MSK BIT(13)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT)

/* 2 REG_FE1IMR				(Offset 0x0120) */

#define BIT_FS_LP_STBY_INT_EN BIT(13)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEIMR				(Offset 0x0120) */

#define BIT_PSTIMERB_INT_MSK BIT(12)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_FE1IMR				(Offset 0x0120) */

#define BIT_FS_TRL_MTR_INT_EN BIT(12)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEIMR				(Offset 0x0120) */

#define BIT_PSTIMERA_INT_MSK BIT(11)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FE1IMR				(Offset 0x0120) */

#define BIT_FS_BF1_PRETO_INT_EN BIT(11)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEIMR				(Offset 0x0120) */

#define BIT_P2P_RFOFF_EARLY_INT_MSK BIT(10)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FE1IMR				(Offset 0x0120) */

#define BIT_FS_BF0_PRETO_INT_EN BIT(10)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEIMR				(Offset 0x0120) */

#define BIT_MACID_RELEASE_INT_MSK BIT(9)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FE1IMR				(Offset 0x0120) */

#define BIT_FS_PTCL_RELEASE_MACID_INT_EN BIT(9)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEIMR				(Offset 0x0120) */

#define BIT_NANRPT_DONE_INT_MSK BIT(8)

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_FE1IMR				(Offset 0x0120) */

#define BIT_PRETXERR_HANDLE_FSIMR BIT(8)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FE1IMR				(Offset 0x0120) */

#define BIT_FS_PRETX_ERRHLD_INT_EN BIT(8)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_FE1IMR				(Offset 0x0120) */

#define BIT_PRETX_ERRHLD_INT_EN BIT(8)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEIMR				(Offset 0x0120) */

#define BIT_FTM_PTT_INT_MSK_V1 BIT(7)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_FE1IMR				(Offset 0x0120) */

#define BIT_FS_GTRD_INT_EN BIT(7)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEIMR				(Offset 0x0120) */

#define BIT_RXFTMREQ_OK_INT_MSK BIT(6)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FE1IMR				(Offset 0x0120) */

#define BIT_FS_LTE_COEX_EN BIT(6)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEIMR				(Offset 0x0120) */

#define BIT_RXFTM_INT_MSK_V1 BIT(5)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FE1IMR				(Offset 0x0120) */

#define BIT_FS_WLACTOFF_INT_EN BIT(5)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEIMR				(Offset 0x0120) */

#define BIT_TXFTM_INT_MSK_V1 BIT(4)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FE1IMR				(Offset 0x0120) */

#define BIT_FS_WLACTON_INT_EN BIT(4)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEIMR				(Offset 0x0120) */

#define BIT_LTECOEX_INT_MSK BIT(3)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FE1IMR				(Offset 0x0120) */

#define BIT_FS_BTCMD_INT_EN BIT(3)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_FEIMR				(Offset 0x0120) */

#define BIT_REG_MAILBOX_TO_I2C_INT BIT(2)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEIMR				(Offset 0x0120) */

#define BIT_MAILBOX_INT_MSK BIT(2)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FE1IMR				(Offset 0x0120) */

#define BIT_FS_REG_MAILBOX_TO_I2C_INT_EN BIT(2)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FEIMR				(Offset 0x0120) */

#define BIT_TRPC_TO_INT_EN BIT(1)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEIMR				(Offset 0x0120) */

#define BIT_FLC_DRUTO_INT_MSK BIT(1)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FE1IMR				(Offset 0x0120) */

#define BIT_FS_TRPC_TO_INT_EN_V1 BIT(1)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FEIMR				(Offset 0x0120) */

#define BIT_BIT_RPC_O_T_INT_EN BIT(0)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEIMR				(Offset 0x0120) */

#define BIT_FLC_PKTTH_INT_MSK BIT(0)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FE1IMR				(Offset 0x0120) */

#define BIT_FS_RPC_O_T_INT_EN_V1 BIT(0)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEISR				(Offset 0x0124) */

#define BIT_H2C_OK_INT BIT(31)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FE1ISR				(Offset 0x0124) */

#define BIT_FS_SW_PLL_LEAVE_32K_INT BIT(31)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_FE1ISR				(Offset 0x0124) */

#define BIT_CPUMGQ_DROP_BY_HOLD_TIME_INT BIT(31)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEISR				(Offset 0x0124) */

#define BIT_H2C_CMD_FULL_INT BIT(30)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FE1ISR				(Offset 0x0124) */

#define BIT_FS_FS_FWFF_FULL_INT BIT(30)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_FE1ISR				(Offset 0x0124) */

#define BIT_FWFF_FULL_INT BIT(30)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEISR				(Offset 0x0124) */

#define BIT_PWR_INT_127_V2 BIT(29)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT)

/* 2 REG_FE1ISR				(Offset 0x0124) */

#define BIT_BB_STOP_RX_INT BIT(29)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FE1ISR				(Offset 0x0124) */

#define BIT_FS_BB_STOP_RX_INT BIT(29)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEISR				(Offset 0x0124) */

#define BIT_PWR_INT_126 BIT(28)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FE1ISR				(Offset 0x0124) */

#define BIT_FS_RXDMA2_DONE_INT BIT(28)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEISR				(Offset 0x0124) */

#define BIT_PWR_INT_125TO96 BIT(27)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT)

/* 2 REG_FE1ISR				(Offset 0x0124) */

#define BIT_FS_RXDONE3_INT BIT(27)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_FE1ISR				(Offset 0x0124) */

#define BIT_FS_RXDONE3_INT_INT BIT(27)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEISR				(Offset 0x0124) */

#define BIT_PWR_INT_95TO64_V1 BIT(26)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FE1ISR				(Offset 0x0124) */

#define BIT_FS_RXDONE2_INT BIT(26)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEISR				(Offset 0x0124) */

#define BIT_PWR_INT_63TO32_V1 BIT(25)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FE1ISR				(Offset 0x0124) */

#define BIT_FS_RX_BCN_P4_INT BIT(25)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEISR				(Offset 0x0124) */

#define BIT_PWR_INT_31TO0_V1 BIT(24)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FE1ISR				(Offset 0x0124) */

#define BIT_FS_RX_BCN_P3_INT BIT(24)
#define BIT_FS_RX_BCN_P2_INT BIT(23)
#define BIT_FS_RX_BCN_P1_INT BIT(22)
#define BIT_FS_RX_BCN_P0_INT BIT(21)
#define BIT_FS_RX_UMD0_INT BIT(20)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEISR				(Offset 0x0124) */

#define BIT_EVTQ_TXDONE_INT BIT(19)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FE1ISR				(Offset 0x0124) */

#define BIT_FS_RX_UMD1_INT BIT(19)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEISR				(Offset 0x0124) */

#define BIT_EVTQ_START_INT BIT(18)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FE1ISR				(Offset 0x0124) */

#define BIT_FS_RX_BMD0_INT BIT(18)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEISR				(Offset 0x0124) */

#define BIT_TXBCN2_OK_INT BIT(17)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FE1ISR				(Offset 0x0124) */

#define BIT_FS_RX_BMD1_INT BIT(17)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEISR				(Offset 0x0124) */

#define BIT_TXBCN2_ERR_INT BIT(16)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FE1ISR				(Offset 0x0124) */

#define BIT_FS_RXDONE_INT BIT(16)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEISR				(Offset 0x0124) */

#define BIT_DWWIN_END_INT BIT(15)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FE1ISR				(Offset 0x0124) */

#define BIT_FS_WWLAN_INT BIT(15)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEISR				(Offset 0x0124) */

#define BIT_BCN2_EARLY_INT BIT(14)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FE1ISR				(Offset 0x0124) */

#define BIT_FS_SOUND_DONE_INT BIT(14)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEISR				(Offset 0x0124) */

#define BIT_TBTT1_INT BIT(13)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT)

/* 2 REG_FE1ISR				(Offset 0x0124) */

#define BIT_FS_LP_STBY_INT BIT(13)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEISR				(Offset 0x0124) */

#define BIT_PSTIMERB_INT BIT(12)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_FE1ISR				(Offset 0x0124) */

#define BIT_FS_TRL_MTR_INT BIT(12)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEISR				(Offset 0x0124) */

#define BIT_PSTIMERA_INT BIT(11)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FE1ISR				(Offset 0x0124) */

#define BIT_FS_BF1_PRETO_INT BIT(11)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEISR				(Offset 0x0124) */

#define BIT_P2P_RFOFF_EARLY_INT BIT(10)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FE1ISR				(Offset 0x0124) */

#define BIT_FS_BF0_PRETO_INT BIT(10)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEISR				(Offset 0x0124) */

#define BIT_MACID_RELEASE_INT BIT(9)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FE1ISR				(Offset 0x0124) */

#define BIT_FS_PTCL_RELEASE_MACID_INT BIT(9)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEISR				(Offset 0x0124) */

#define BIT_NANRPT_DONE_INT BIT(8)

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_FE1ISR				(Offset 0x0124) */

#define BIT_PRETXERR_HANDLE_FSISR BIT(8)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FE1ISR				(Offset 0x0124) */

#define BIT_FS_PRETX_ERRHLD_INT BIT(8)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_FE1ISR				(Offset 0x0124) */

#define BIT_PRETX_ERRHLD_INT BIT(8)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEISR				(Offset 0x0124) */

#define BIT_FTM_PTT_INT_V1 BIT(7)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_FE1ISR				(Offset 0x0124) */

#define BIT_SND_RDY_INT BIT(7)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEISR				(Offset 0x0124) */

#define BIT_RXFTMREQ_OK_INT BIT(6)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FE1ISR				(Offset 0x0124) */

#define BIT_FS_LTE_COEX_INT BIT(6)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEISR				(Offset 0x0124) */

#define BIT_RXFTM_INT_V1 BIT(5)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FE1ISR				(Offset 0x0124) */

#define BIT_FS_WLACTOFF_INT BIT(5)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEISR				(Offset 0x0124) */

#define BIT_TXFTM_INT_V1 BIT(4)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FE1ISR				(Offset 0x0124) */

#define BIT_FS_WLACTON_INT BIT(4)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEISR				(Offset 0x0124) */

#define BIT_LTECOEX_INT BIT(3)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FE1ISR				(Offset 0x0124) */

#define BIT_FS_BCN_RX_INT_INT BIT(3)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_FE1ISR				(Offset 0x0124) */

#define BIT_BT_CMD_INT BIT(3)

#endif

#if (HALMAC_8192E_SUPPORT)

/* 2 REG_FEISR				(Offset 0x0124) */

#define BIT_MAILBOX_TO_I2C BIT(2)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEISR				(Offset 0x0124) */

#define BIT_MAILBOX_INT BIT(2)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FE1ISR				(Offset 0x0124) */

#define BIT_FS_MAILBOX_TO_I2C_INT BIT(2)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FEISR				(Offset 0x0124) */

#define BIT_TRPC_TO_INT BIT(1)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEISR				(Offset 0x0124) */

#define BIT_FLC_DRUTO_INT BIT(1)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FE1ISR				(Offset 0x0124) */

#define BIT_FS_TRPC_TO_INT BIT(1)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FEISR				(Offset 0x0124) */

#define BIT_RPC_O_T_INT BIT(0)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FEISR				(Offset 0x0124) */

#define BIT_FLC_PKTTH_INT BIT(0)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FE1ISR				(Offset 0x0124) */

#define BIT_FS_RPC_O_T_INT BIT(0)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_CPWM				(Offset 0x012C) */

#define BIT_CPWM_TOGGLING BIT(31)

#define BIT_SHIFT_CPWM_MOD 24
#define BIT_MASK_CPWM_MOD 0x7f
#define BIT_CPWM_MOD(x) (((x) & BIT_MASK_CPWM_MOD) << BIT_SHIFT_CPWM_MOD)
#define BITS_CPWM_MOD (BIT_MASK_CPWM_MOD << BIT_SHIFT_CPWM_MOD)
#define BIT_CLEAR_CPWM_MOD(x) ((x) & (~BITS_CPWM_MOD))
#define BIT_GET_CPWM_MOD(x) (((x) >> BIT_SHIFT_CPWM_MOD) & BIT_MASK_CPWM_MOD)
#define BIT_SET_CPWM_MOD(x, v) (BIT_CLEAR_CPWM_MOD(x) | BIT_CPWM_MOD(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_PCIE_BCNDMAERR_INT_MSK BIT(31)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_FS_TXBCNOK_MB7_INT_EN BIT(31)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_SOUND_DONE_MSK BIT(30)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_SOUND_DONE_INT_MSK BIT(30)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_FS_TXBCNOK_MB6_INT_EN BIT(30)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_TRY_DONE_MSK BIT(29)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_TRY_DONE_INT_MSK BIT(29)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_FS_TXBCNOK_MB5_INT_EN BIT(29)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_TXRPT_CNT_FULL_MSK BIT(28)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_TXRPT_CNT_FULL_INT_MSK BIT(28)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_FS_TXBCNOK_MB4_INT_EN BIT(28)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_WLACTOFF_INT_EN BIT(27)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_WLACTOFF_INT_MSK BIT(27)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_FS_TXBCNOK_MB3_INT_EN BIT(27)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_WLACTON_INT_EN BIT(26)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_WLACTON_INT_MSK BIT(26)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_FS_TXBCNOK_MB2_INT_EN BIT(26)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_TXPKTIN_INT_EN BIT(25)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_TXPKTIN_INT_MSK BIT(25)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_FS_TXBCNOK_MB1_INT_EN BIT(25)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_TXBCNOK_MSK BIT(24)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_TXBCNOK_INT_MSK BIT(24)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_FS_TXBCNOK_MB0_INT_EN BIT(24)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_TXBCNERR_MSK BIT(23)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_TXBCNERR_INT_MSK BIT(23)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_FS_TXBCNERR_MB7_INT_EN BIT(23)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_RX_UMD0_EN BIT(22)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_RX_UMD0_INT_MSK BIT(22)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_FS_TXBCNERR_MB6_INT_EN BIT(22)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_RX_UMD1_EN BIT(21)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_RX_UMD1_INT_MSK BIT(21)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_FS_TXBCNERR_MB5_INT_EN BIT(21)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_RX_BMD0_EN BIT(20)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_RX_BMD0_INT_MSK BIT(20)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_FS_TXBCNERR_MB4_INT_EN BIT(20)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_RX_BMD1_EN BIT(19)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_RX_BMD1_INT_MSK BIT(19)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_FS_TXBCNERR_MB3_INT_EN BIT(19)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_BCN_RX_INT_EN BIT(18)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_BCN_RX_INT_INT_MSK BIT(18)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_FS_TXBCNERR_MB2_INT_EN BIT(18)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_TBTTINT_MSK BIT(17)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_TBTTINT_INT_MSK BIT(17)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_FS_TXBCNERR_MB1_INT_EN BIT(17)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_BCNERLY_MSK BIT(16)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_BCNERLY_INT_MSK BIT(16)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_FS_TXBCNERR_MB0_INT_EN BIT(16)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_BCNDMA7_MSK BIT(15)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_BCNDMA7_INT_MSK BIT(15)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_CPUMGN_POLLED_PKT_DONE_INT_EN BIT(15)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_CPU_MGQ_TXDONE_INT_EN BIT(15)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_BCNDMA6_MSK BIT(14)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_BCNDMA6_INT_MSK BIT(14)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_SIFS_OVERSPEC_INT_EN BIT(14)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_BCNDMA5_MSK BIT(13)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_BCNDMA5_INT_MSK BIT(13)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_FS_MGNTQ_RPTR_RELEASE_INT_EN BIT(13)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_BCNDMA4_MSK BIT(12)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_BCNDMA4_INT_MSK BIT(12)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_FS_MGNTQFF_TO_INT_EN BIT(12)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_BCNDMA3_MSK BIT(11)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_BCNDMA3_INT_MSK BIT(11)

#endif

#if (HALMAC_8197F_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_FS_DDMA1_LP_INT_ENBIT_CPUMGN_POLLED_PKT_BUSY_ERR_INT_EN BIT(11)

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_FS_CPUMGQ_ERR_INT_EN BIT(11)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_FS_DDMA1_LP_INT_EN BIT(11)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_BCNDMA2_MSK BIT(10)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_BCNDMA2_INT_MSK BIT(10)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8821C_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_FS_DDMA1_HP_INT_EN BIT(10)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_BCNDMA1_MSK BIT(9)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_BCNDMA1_INT_MSK BIT(9)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_FS_DDMA0_LP_INT_EN BIT(9)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_BCNDMA0_MSK BIT(8)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_BCNDMA0_INT_MSK BIT(8)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_FS_DDMA0_HP_INT_EN BIT(8)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_LP_STBY_MSK BIT(7)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_LP_STBY_INT_MSK BIT(7)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_FS_TRXRPT_INT_EN BIT(7)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_CTWENDINT_MSK BIT(6)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_CTWENDINT_INT_MSK BIT(6)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_FS_C2H_W_READY_INT_EN BIT(6)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_HRCV_MSK BIT(5)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_HRCV_INT_MSK BIT(5)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_FS_HRCV_INT_EN BIT(5)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_H2CCMD_MSK BIT(4)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_H2CCMD_INT_MSK BIT(4)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_FS_H2CCMD_INT_EN BIT(4)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_RXDONE_MSK BIT(3)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_RXDONE_INT_MSK BIT(3)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_FS_TXPKTIN_INT_EN BIT(3)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_ERRORHDL_MSK BIT(2)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_ERRORHDL_INT_MSK BIT(2)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_FS_ERRORHDL_INT_EN BIT(2)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_TXCCX_MSK_FW BIT(1)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_TXCCX_INT_MSK BIT(1)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_FS_TXCCX_INT_EN BIT(1)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_TXCLOSE_MSK BIT(0)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_TXCLOSE_INT_MSK BIT(0)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWIMR				(Offset 0x0130) */

#define BIT_FS_TXCLOSE_INT_EN BIT(0)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_PCIE_BCNDMAERR_INT BIT(31)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_FS_TXBCNOK_MB7_INT BIT(31)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_SOUND_DONE_INT BIT(30)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_FS_TXBCNOK_MB6_INT BIT(30)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_TRY_DONE_INT BIT(29)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_FS_TXBCNOK_MB5_INT BIT(29)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_TXRPT_CNT_FULL_INT BIT(28)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_FS_TXBCNOK_MB4_INT BIT(28)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_WLACTOFF_INT BIT(27)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_FS_TXBCNOK_MB3_INT BIT(27)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_WLACTON_INT BIT(26)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_FS_TXBCNOK_MB2_INT BIT(26)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_TXPKTIN_INT BIT(25)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_FS_TXBCNOK_MB1_INT BIT(25)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_TXBCNOK_INT BIT(24)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_FS_TXBCNOK_MB0_INT BIT(24)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_TXBCNERR_INT BIT(23)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_FS_TXBCNERR_MB7_INT BIT(23)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_RX_UMD0_INT BIT(22)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_FS_TXBCNERR_MB6_INT BIT(22)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_RX_UMD1_INT BIT(21)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_FS_TXBCNERR_MB5_INT BIT(21)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_RX_BMD0_INT BIT(20)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_FS_TXBCNERR_MB4_INT BIT(20)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_RX_BMD1_INT BIT(19)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_FS_TXBCNERR_MB3_INT BIT(19)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_BCN_RX_INT_INT BIT(18)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_FS_TXBCNERR_MB2_INT BIT(18)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_TBTTINT_INT BIT(17)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_FS_TXBCNERR_MB1_INT BIT(17)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_BCNERLY_INT BIT(16)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_FS_TXBCNERR_MB0_INT BIT(16)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_BCNDMA7_INT BIT(15)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_CPUMGN_POLLED_PKT_DONE_INT BIT(15)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_CPU_MGQ_TXDONE_INT BIT(15)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_BCNDMA6_INT BIT(14)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_SIFS_OVERSPEC_INT BIT(14)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_BCNDMA5_INT BIT(13)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_FS_MGNTQ_RPTR_RELEASE_INT BIT(13)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_BCNDMA4_INT BIT(12)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_FS_MGNTQFF_TO_INT BIT(12)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_BCNDMA3_INT BIT(11)

#endif

#if (HALMAC_8197F_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_FS_DDMA1_LP_INTBIT_CPUMGN_POLLED_PKT_BUSY_ERR_INT BIT(11)

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_FS_CPUMGQ_ERR_INT BIT(11)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_FS_DDMA1_LP_INT BIT(11)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_BCNDMA2_INT BIT(10)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8821C_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_FS_DDMA1_HP_INT BIT(10)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_FWCMD_PKTIN_INT BIT(10)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_BCNDMA1_INT BIT(9)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_FS_DDMA0_LP_INT BIT(9)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_BCNDMA0_INT BIT(8)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_FS_DDMA0_HP_INT BIT(8)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_LP_STBY_INT BIT(7)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_FS_TRXRPT_INT BIT(7)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_CTWENDINT_INT BIT(6)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_FS_C2H_W_READY_INT BIT(6)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_HRCV_INT BIT(5)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_FS_HRCV_INT BIT(5)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_H2CCMD_INT BIT(4)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_FS_H2CCMD_INT BIT(4)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_RXDONE_INT BIT(3)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_FS_TXPKTIN_INT BIT(3)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_ERRORHDL_INT BIT(2)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_FS_ERRORHDL_INT BIT(2)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_TXCCX_INT BIT(1)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_FS_TXCCX_INT BIT(1)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_TXCLOSE_INT BIT(0)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWISR				(Offset 0x0134) */

#define BIT_FS_TXCLOSE_INT BIT(0)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_GTINT6_MSK BIT(31)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_GT6INT_MSK BIT(31)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_TX_NULL1_INT_MSK BIT(30)
#define BIT_TX_NULL0_INT_MSK BIT(29)
#define BIT_MTI_BCNIVLEAR_INT_MSK BIT(28)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_ATIMINT_MSK BIT(27)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_ATIM_INT_MSK BIT(27)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_WWLAN_INT_EN BIT(26)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_WWLAN_INT_MSK BIT(26)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_C2H_W_READY_EN BIT(25)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_C2H_W_READY_MSK BIT(25)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_TRL_MTR_EN BIT(24)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_TRL_MTR_INT_MSK BIT(24)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_CLR_PS_STATUS_MSK BIT(23)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_PS_TIMER_C_EARLY_INT_EN BIT(23)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_RETRIEVE_BUFFERED_MSK BIT(22)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_RETRIEVE_BUFFERED_INT_MSK BIT(22)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_PS_TIMER_B_EARLY_INT_EN BIT(22)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_RPWMINT2_MSK BIT(21)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_RPWM2INT_MSK BIT(21)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_PS_TIMER_A_EARLY_INT_EN BIT(21)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_TSF_BIT32_TOGGLE_MSK_V1 BIT(20)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_TSF_BIT32_TOGGLE_INT_MSK BIT(20)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_CPUMGQ_TX_TIMER_EARLY_INT_EN BIT(20)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_TRIGGER_PKT_MSK BIT(19)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_PS_TIMER_C_INT_EN BIT(19)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_FW_BTCMD_INTMSK BIT(18)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_FW_BTCMD_INT_MSK BIT(18)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_PS_TIMER_B_INT_EN BIT(18)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_P2P_RFOFF_INTMSK BIT(17)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_P2P_RFOFF_INT_MSK BIT(17)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_PS_TIMER_A_INT_EN BIT(17)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_P2P_RFON_INTMSK BIT(16)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_P2P_RFON_INT_MSK BIT(16)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_CPUMGQ_TX_TIMER_INT_EN BIT(16)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_TXBCN1ERR_MSK BIT(15)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_TX_BCN1ERR_INT_MSK BIT(15)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_FS_PS_TIMEOUT2_EN BIT(15)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_TXBCN1OK_MSK BIT(14)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_TX_BCN1OK_INT_MSK BIT(14)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_FS_PS_TIMEOUT1_EN BIT(14)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_FT_ATIMEND_EMSK BIT(13)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_FT_ATIMEND_E_MSK BIT(13)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_FS_PS_TIMEOUT0_EN BIT(13)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_BCNDMAINT_EMSK BIT(12)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_BCNDMAINT_E_MSK_V1 BIT(12)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_FS_GTINT12_EN BIT(12)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_GTINT5_MSK BIT(11)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_GT5INT_MSK BIT(11)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_FS_GTINT11_EN BIT(11)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_EOSP_INT_MSK BIT(10)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_FS_GTINT10_EN BIT(10)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_RX_BCN_E_MSK BIT(9)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_RX_BCN_E_INT_MSK BIT(9)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_FS_GTINT9_EN BIT(9)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_RPWM_INT_EN BIT(8)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_RPWMINT_MSK BIT(8)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_FS_GTINT8_EN BIT(8)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_PSTIMER_MSK BIT(7)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_PSTIMER_INT_MSK BIT(7)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_FS_GTINT7_EN BIT(7)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_TIMEOUT1_MSK BIT(6)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_TIMEOUT1_INT_MSK BIT(6)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_FS_GTINT6_EN BIT(6)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_TIMEOUT0_MSK BIT(5)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_TIMEOUT0_INT_MSK BIT(5)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_FS_GTINT5_EN BIT(5)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_FT_GTINT4_MSK BIT(4)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_FT_GT4INT_MSK BIT(4)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_FS_GTINT4_EN BIT(4)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_FT_GTINT3_MSK BIT(3)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_FT_GT3INT_MSK BIT(3)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_FS_GTINT3_EN BIT(3)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_GTINT2_MSK BIT(2)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_GT2INT_MSK BIT(2)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_FS_GTINT2_EN BIT(2)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_GTINT1_MSK BIT(1)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_GT1INT_MSK BIT(1)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_FS_GTINT1_EN BIT(1)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_GTINT0_MSK BIT(0)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_GT0INT_MSK BIT(0)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FTIMR				(Offset 0x0138) */

#define BIT_FS_GTINT0_EN BIT(0)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_GT6INT BIT(31)
#define BIT_TX_NULL1_INT BIT(30)
#define BIT_TX_NULL0_INT BIT(29)
#define BIT_MTI_BCNIVLEAR_INT BIT(28)
#define BIT_ATIM_INT BIT(27)
#define BIT_WWLAN_INT BIT(26)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_PS_TIMER_5_EARLY__INT BIT(26)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_C2H_W_READY BIT(25)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_PS_TIMER_4_EARLY__INT BIT(25)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_TRL_MTR_INT BIT(24)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_PS_TIMER_3_EARLY__INT BIT(24)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_CLR_PS_STATUS BIT(23)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_PS_TIMER_C_EARLY__INT BIT(23)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_PS_TIMER_2_EARLY__INT BIT(23)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_RETRIEVE_BUFFERED_INT BIT(22)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_PS_TIMER_B_EARLY__INT BIT(22)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_PS_TIMER_1_EARLY__INT BIT(22)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_RPWM2INT BIT(21)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_PS_TIMER_A_EARLY__INT BIT(21)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_PS_TIMER_0_EARLY__INT BIT(21)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_TSF_BIT32_TOGGLE_INT_V1 BIT(20)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_CPUMGQ_TX_TIMER_EARLY_INT BIT(20)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_TRIGGER_PKT BIT(19)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_PS_TIMER_C_INT BIT(19)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_PS_TIMER_5_INT BIT(19)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_FW_BTCMD_INT BIT(18)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_PS_TIMER_B_INT BIT(18)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_PS_TIMER_4_INT BIT(18)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_P2P_RFOFF_INT BIT(17)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_PS_TIMER_A_INT BIT(17)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_PS_TIMER_3_INT BIT(17)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_P2P_RFON_INT BIT(16)

#define BIT_SHIFT_LLTINI_PDATA 16
#define BIT_MASK_LLTINI_PDATA 0xff
#define BIT_LLTINI_PDATA(x)                                                    \
	(((x) & BIT_MASK_LLTINI_PDATA) << BIT_SHIFT_LLTINI_PDATA)
#define BITS_LLTINI_PDATA (BIT_MASK_LLTINI_PDATA << BIT_SHIFT_LLTINI_PDATA)
#define BIT_CLEAR_LLTINI_PDATA(x) ((x) & (~BITS_LLTINI_PDATA))
#define BIT_GET_LLTINI_PDATA(x)                                                \
	(((x) >> BIT_SHIFT_LLTINI_PDATA) & BIT_MASK_LLTINI_PDATA)
#define BIT_SET_LLTINI_PDATA(x, v)                                             \
	(BIT_CLEAR_LLTINI_PDATA(x) | BIT_LLTINI_PDATA(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_CPUMGQ_TX_TIMER_INT BIT(16)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_TX_BCN1ERR_INT BIT(15)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_FS_PS_TIMEOUT2_INT BIT(15)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_PS_TIMER_2_INT BIT(15)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_TX_BCN1OK_INT BIT(14)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_FS_PS_TIMEOUT1_INT BIT(14)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_PS_TIMER_1_INT BIT(14)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_FT_ATIMEND_E BIT(13)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_FS_PS_TIMEOUT0_INT BIT(13)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_PS_TIMER_0_INT BIT(13)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_BCNDMAINT_E_V1 BIT(12)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_FS_GTINT12_INT BIT(12)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_GT5INT BIT(11)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_FS_GTINT11_INT BIT(11)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_EOSP_INT BIT(10)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_FS_GTINT10_INT BIT(10)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_RX_BCN_E_INT BIT(9)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_FS_GTINT9_INT BIT(9)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_RPWMINT BIT(8)

#define BIT_SHIFT_LLTINI_ADDR 8
#define BIT_MASK_LLTINI_ADDR 0xff
#define BIT_LLTINI_ADDR(x)                                                     \
	(((x) & BIT_MASK_LLTINI_ADDR) << BIT_SHIFT_LLTINI_ADDR)
#define BITS_LLTINI_ADDR (BIT_MASK_LLTINI_ADDR << BIT_SHIFT_LLTINI_ADDR)
#define BIT_CLEAR_LLTINI_ADDR(x) ((x) & (~BITS_LLTINI_ADDR))
#define BIT_GET_LLTINI_ADDR(x)                                                 \
	(((x) >> BIT_SHIFT_LLTINI_ADDR) & BIT_MASK_LLTINI_ADDR)
#define BIT_SET_LLTINI_ADDR(x, v)                                              \
	(BIT_CLEAR_LLTINI_ADDR(x) | BIT_LLTINI_ADDR(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_FS_GTINT8_INT BIT(8)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_PSTIMER_INT BIT(7)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_FS_GTINT7_INT BIT(7)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_TIMEOUT1_INT BIT(6)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_FS_GTINT6_INT BIT(6)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_TIMEOUT0_INT BIT(5)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_FS_GTINT5_INT BIT(5)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_FT_GT4INT BIT(4)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_FS_GTINT4_INT BIT(4)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_FT_GT3INT BIT(3)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_FS_GTINT3_INT BIT(3)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_GT2INT BIT(2)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_FS_GTINT2_INT BIT(2)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_GT1INT BIT(1)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_FS_GTINT1_INT BIT(1)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_GT0INT BIT(0)

#define BIT_SHIFT_LLTINI_HDATA 0
#define BIT_MASK_LLTINI_HDATA 0xff
#define BIT_LLTINI_HDATA(x)                                                    \
	(((x) & BIT_MASK_LLTINI_HDATA) << BIT_SHIFT_LLTINI_HDATA)
#define BITS_LLTINI_HDATA (BIT_MASK_LLTINI_HDATA << BIT_SHIFT_LLTINI_HDATA)
#define BIT_CLEAR_LLTINI_HDATA(x) ((x) & (~BITS_LLTINI_HDATA))
#define BIT_GET_LLTINI_HDATA(x)                                                \
	(((x) >> BIT_SHIFT_LLTINI_HDATA) & BIT_MASK_LLTINI_HDATA)
#define BIT_SET_LLTINI_HDATA(x, v)                                             \
	(BIT_CLEAR_LLTINI_HDATA(x) | BIT_LLTINI_HDATA(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FTISR				(Offset 0x013C) */

#define BIT_FS_GTINT0_INT BIT(0)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_PKTBUF_DBG_CTRL			(Offset 0x0140) */

#define BIT_SHIFT_PKTBUF_WRITE_EN 24
#define BIT_MASK_PKTBUF_WRITE_EN 0xff
#define BIT_PKTBUF_WRITE_EN(x)                                                 \
	(((x) & BIT_MASK_PKTBUF_WRITE_EN) << BIT_SHIFT_PKTBUF_WRITE_EN)
#define BITS_PKTBUF_WRITE_EN                                                   \
	(BIT_MASK_PKTBUF_WRITE_EN << BIT_SHIFT_PKTBUF_WRITE_EN)
#define BIT_CLEAR_PKTBUF_WRITE_EN(x) ((x) & (~BITS_PKTBUF_WRITE_EN))
#define BIT_GET_PKTBUF_WRITE_EN(x)                                             \
	(((x) >> BIT_SHIFT_PKTBUF_WRITE_EN) & BIT_MASK_PKTBUF_WRITE_EN)
#define BIT_SET_PKTBUF_WRITE_EN(x, v)                                          \
	(BIT_CLEAR_PKTBUF_WRITE_EN(x) | BIT_PKTBUF_WRITE_EN(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_PKTBUF_DBG_CTRL			(Offset 0x0140) */

#define BIT_TXPKT_BUF_READ_EN BIT(23)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_PKTBUF_DBG_CTRL			(Offset 0x0140) */

#define BIT_TXPKTBUF_DBG BIT(23)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_PKTBUF_DBG_CTRL			(Offset 0x0140) */

#define BIT_TXRPTBUF_DBG BIT(23)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_PKTBUF_DBG_CTRL			(Offset 0x0140) */

#define BIT_TXRPT_BUF_READ_EN BIT(20)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_PKTBUF_DBG_CTRL			(Offset 0x0140) */

#define BIT_TXRPTBUF_DBG_V2 BIT(20)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_PKTBUF_DBG_CTRL			(Offset 0x0140) */

#define BIT_TXPKTBUF_DBG_V2 BIT(20)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_PKTBUF_DBG_CTRL			(Offset 0x0140) */

#define BIT_RXPKT_BUF_READ_EN BIT(16)

#define BIT_SHIFT_PKTBUF_ADDR 0
#define BIT_MASK_PKTBUF_ADDR 0x1fff
#define BIT_PKTBUF_ADDR(x)                                                     \
	(((x) & BIT_MASK_PKTBUF_ADDR) << BIT_SHIFT_PKTBUF_ADDR)
#define BITS_PKTBUF_ADDR (BIT_MASK_PKTBUF_ADDR << BIT_SHIFT_PKTBUF_ADDR)
#define BIT_CLEAR_PKTBUF_ADDR(x) ((x) & (~BITS_PKTBUF_ADDR))
#define BIT_GET_PKTBUF_ADDR(x)                                                 \
	(((x) >> BIT_SHIFT_PKTBUF_ADDR) & BIT_MASK_PKTBUF_ADDR)
#define BIT_SET_PKTBUF_ADDR(x, v)                                              \
	(BIT_CLEAR_PKTBUF_ADDR(x) | BIT_PKTBUF_ADDR(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_PKTBUF_DBG_DATA_L			(Offset 0x0144) */

#define BIT_SHIFT_PKTBUF_DBG_DATA_L 0
#define BIT_MASK_PKTBUF_DBG_DATA_L 0xffffffffL
#define BIT_PKTBUF_DBG_DATA_L(x)                                               \
	(((x) & BIT_MASK_PKTBUF_DBG_DATA_L) << BIT_SHIFT_PKTBUF_DBG_DATA_L)
#define BITS_PKTBUF_DBG_DATA_L                                                 \
	(BIT_MASK_PKTBUF_DBG_DATA_L << BIT_SHIFT_PKTBUF_DBG_DATA_L)
#define BIT_CLEAR_PKTBUF_DBG_DATA_L(x) ((x) & (~BITS_PKTBUF_DBG_DATA_L))
#define BIT_GET_PKTBUF_DBG_DATA_L(x)                                           \
	(((x) >> BIT_SHIFT_PKTBUF_DBG_DATA_L) & BIT_MASK_PKTBUF_DBG_DATA_L)
#define BIT_SET_PKTBUF_DBG_DATA_L(x, v)                                        \
	(BIT_CLEAR_PKTBUF_DBG_DATA_L(x) | BIT_PKTBUF_DBG_DATA_L(v))

/* 2 REG_PKTBUF_DBG_DATA_H			(Offset 0x0148) */

#define BIT_SHIFT_PKTBUF_DBG_DATA_H 0
#define BIT_MASK_PKTBUF_DBG_DATA_H 0xffffffffL
#define BIT_PKTBUF_DBG_DATA_H(x)                                               \
	(((x) & BIT_MASK_PKTBUF_DBG_DATA_H) << BIT_SHIFT_PKTBUF_DBG_DATA_H)
#define BITS_PKTBUF_DBG_DATA_H                                                 \
	(BIT_MASK_PKTBUF_DBG_DATA_H << BIT_SHIFT_PKTBUF_DBG_DATA_H)
#define BIT_CLEAR_PKTBUF_DBG_DATA_H(x) ((x) & (~BITS_PKTBUF_DBG_DATA_H))
#define BIT_GET_PKTBUF_DBG_DATA_H(x)                                           \
	(((x) >> BIT_SHIFT_PKTBUF_DBG_DATA_H) & BIT_MASK_PKTBUF_DBG_DATA_H)
#define BIT_SET_PKTBUF_DBG_DATA_H(x, v)                                        \
	(BIT_CLEAR_PKTBUF_DBG_DATA_H(x) | BIT_PKTBUF_DBG_DATA_H(v))

/* 2 REG_CPWM2				(Offset 0x014C) */

#define BIT_SHIFT_L0S_TO_RCVY_NUM 16
#define BIT_MASK_L0S_TO_RCVY_NUM 0xff
#define BIT_L0S_TO_RCVY_NUM(x)                                                 \
	(((x) & BIT_MASK_L0S_TO_RCVY_NUM) << BIT_SHIFT_L0S_TO_RCVY_NUM)
#define BITS_L0S_TO_RCVY_NUM                                                   \
	(BIT_MASK_L0S_TO_RCVY_NUM << BIT_SHIFT_L0S_TO_RCVY_NUM)
#define BIT_CLEAR_L0S_TO_RCVY_NUM(x) ((x) & (~BITS_L0S_TO_RCVY_NUM))
#define BIT_GET_L0S_TO_RCVY_NUM(x)                                             \
	(((x) >> BIT_SHIFT_L0S_TO_RCVY_NUM) & BIT_MASK_L0S_TO_RCVY_NUM)
#define BIT_SET_L0S_TO_RCVY_NUM(x, v)                                          \
	(BIT_CLEAR_L0S_TO_RCVY_NUM(x) | BIT_L0S_TO_RCVY_NUM(v))

#define BIT_CPWM2_TOGGLING BIT(15)

#define BIT_SHIFT_CPWM2_MOD 0
#define BIT_MASK_CPWM2_MOD 0x7fff
#define BIT_CPWM2_MOD(x) (((x) & BIT_MASK_CPWM2_MOD) << BIT_SHIFT_CPWM2_MOD)
#define BITS_CPWM2_MOD (BIT_MASK_CPWM2_MOD << BIT_SHIFT_CPWM2_MOD)
#define BIT_CLEAR_CPWM2_MOD(x) ((x) & (~BITS_CPWM2_MOD))
#define BIT_GET_CPWM2_MOD(x) (((x) >> BIT_SHIFT_CPWM2_MOD) & BIT_MASK_CPWM2_MOD)
#define BIT_SET_CPWM2_MOD(x, v) (BIT_CLEAR_CPWM2_MOD(x) | BIT_CPWM2_MOD(v))

/* 2 REG_TC0_CTRL				(Offset 0x0150) */

#define BIT_TC0INT_EN BIT(26)
#define BIT_TC0MODE BIT(25)
#define BIT_TC0EN BIT(24)

#define BIT_SHIFT_TC0DATA 0
#define BIT_MASK_TC0DATA 0xffffff
#define BIT_TC0DATA(x) (((x) & BIT_MASK_TC0DATA) << BIT_SHIFT_TC0DATA)
#define BITS_TC0DATA (BIT_MASK_TC0DATA << BIT_SHIFT_TC0DATA)
#define BIT_CLEAR_TC0DATA(x) ((x) & (~BITS_TC0DATA))
#define BIT_GET_TC0DATA(x) (((x) >> BIT_SHIFT_TC0DATA) & BIT_MASK_TC0DATA)
#define BIT_SET_TC0DATA(x, v) (BIT_CLEAR_TC0DATA(x) | BIT_TC0DATA(v))

/* 2 REG_TC1_CTRL				(Offset 0x0154) */

#define BIT_TC1INT_EN BIT(26)
#define BIT_TC1MODE BIT(25)
#define BIT_TC1EN BIT(24)

#define BIT_SHIFT_TC1DATA 0
#define BIT_MASK_TC1DATA 0xffffff
#define BIT_TC1DATA(x) (((x) & BIT_MASK_TC1DATA) << BIT_SHIFT_TC1DATA)
#define BITS_TC1DATA (BIT_MASK_TC1DATA << BIT_SHIFT_TC1DATA)
#define BIT_CLEAR_TC1DATA(x) ((x) & (~BITS_TC1DATA))
#define BIT_GET_TC1DATA(x) (((x) >> BIT_SHIFT_TC1DATA) & BIT_MASK_TC1DATA)
#define BIT_SET_TC1DATA(x, v) (BIT_CLEAR_TC1DATA(x) | BIT_TC1DATA(v))

/* 2 REG_TC2_CTRL				(Offset 0x0158) */

#define BIT_TC2INT_EN BIT(26)
#define BIT_TC2MODE BIT(25)
#define BIT_TC2EN BIT(24)

#define BIT_SHIFT_TC2DATA 0
#define BIT_MASK_TC2DATA 0xffffff
#define BIT_TC2DATA(x) (((x) & BIT_MASK_TC2DATA) << BIT_SHIFT_TC2DATA)
#define BITS_TC2DATA (BIT_MASK_TC2DATA << BIT_SHIFT_TC2DATA)
#define BIT_CLEAR_TC2DATA(x) ((x) & (~BITS_TC2DATA))
#define BIT_GET_TC2DATA(x) (((x) >> BIT_SHIFT_TC2DATA) & BIT_MASK_TC2DATA)
#define BIT_SET_TC2DATA(x, v) (BIT_CLEAR_TC2DATA(x) | BIT_TC2DATA(v))

/* 2 REG_TC3_CTRL				(Offset 0x015C) */

#define BIT_TC3INT_EN BIT(26)
#define BIT_TC3MODE BIT(25)
#define BIT_TC3EN BIT(24)

#define BIT_SHIFT_TC3DATA 0
#define BIT_MASK_TC3DATA 0xffffff
#define BIT_TC3DATA(x) (((x) & BIT_MASK_TC3DATA) << BIT_SHIFT_TC3DATA)
#define BITS_TC3DATA (BIT_MASK_TC3DATA << BIT_SHIFT_TC3DATA)
#define BIT_CLEAR_TC3DATA(x) ((x) & (~BITS_TC3DATA))
#define BIT_GET_TC3DATA(x) (((x) >> BIT_SHIFT_TC3DATA) & BIT_MASK_TC3DATA)
#define BIT_SET_TC3DATA(x, v) (BIT_CLEAR_TC3DATA(x) | BIT_TC3DATA(v))

/* 2 REG_TC4_CTRL				(Offset 0x0160) */

#define BIT_TC4INT_EN BIT(26)
#define BIT_TC4MODE BIT(25)
#define BIT_TC4EN BIT(24)

#define BIT_SHIFT_TC4DATA 0
#define BIT_MASK_TC4DATA 0xffffff
#define BIT_TC4DATA(x) (((x) & BIT_MASK_TC4DATA) << BIT_SHIFT_TC4DATA)
#define BITS_TC4DATA (BIT_MASK_TC4DATA << BIT_SHIFT_TC4DATA)
#define BIT_CLEAR_TC4DATA(x) ((x) & (~BITS_TC4DATA))
#define BIT_GET_TC4DATA(x) (((x) >> BIT_SHIFT_TC4DATA) & BIT_MASK_TC4DATA)
#define BIT_SET_TC4DATA(x, v) (BIT_CLEAR_TC4DATA(x) | BIT_TC4DATA(v))

/* 2 REG_TCUNIT_BASE				(Offset 0x0164) */

#define BIT_SHIFT_TCUNIT_BASE 0
#define BIT_MASK_TCUNIT_BASE 0x3fff
#define BIT_TCUNIT_BASE(x)                                                     \
	(((x) & BIT_MASK_TCUNIT_BASE) << BIT_SHIFT_TCUNIT_BASE)
#define BITS_TCUNIT_BASE (BIT_MASK_TCUNIT_BASE << BIT_SHIFT_TCUNIT_BASE)
#define BIT_CLEAR_TCUNIT_BASE(x) ((x) & (~BITS_TCUNIT_BASE))
#define BIT_GET_TCUNIT_BASE(x)                                                 \
	(((x) >> BIT_SHIFT_TCUNIT_BASE) & BIT_MASK_TCUNIT_BASE)
#define BIT_SET_TCUNIT_BASE(x, v)                                              \
	(BIT_CLEAR_TCUNIT_BASE(x) | BIT_TCUNIT_BASE(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_TC5_CTRL				(Offset 0x0168) */

#define BIT_TC50INT_EN BIT(26)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_TC5_CTRL				(Offset 0x0168) */

#define BIT_TC5INT_EN BIT(26)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_TC5_CTRL				(Offset 0x0168) */

#define BIT_TC5MODE BIT(25)
#define BIT_TC5EN BIT(24)

#define BIT_SHIFT_TC5DATA 0
#define BIT_MASK_TC5DATA 0xffffff
#define BIT_TC5DATA(x) (((x) & BIT_MASK_TC5DATA) << BIT_SHIFT_TC5DATA)
#define BITS_TC5DATA (BIT_MASK_TC5DATA << BIT_SHIFT_TC5DATA)
#define BIT_CLEAR_TC5DATA(x) ((x) & (~BITS_TC5DATA))
#define BIT_GET_TC5DATA(x) (((x) >> BIT_SHIFT_TC5DATA) & BIT_MASK_TC5DATA)
#define BIT_SET_TC5DATA(x, v) (BIT_CLEAR_TC5DATA(x) | BIT_TC5DATA(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_TC6_CTRL				(Offset 0x016C) */

#define BIT_TC60INT_EN BIT(26)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_TC6_CTRL				(Offset 0x016C) */

#define BIT_TC6INT_EN BIT(26)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_TC6_CTRL				(Offset 0x016C) */

#define BIT_TC6MODE BIT(25)
#define BIT_TC6EN BIT(24)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_TC6_CTRL				(Offset 0x016C) */

#define BIT_SHIFT_SEQNUM_MID 16
#define BIT_MASK_SEQNUM_MID 0xffff
#define BIT_SEQNUM_MID(x) (((x) & BIT_MASK_SEQNUM_MID) << BIT_SHIFT_SEQNUM_MID)
#define BITS_SEQNUM_MID (BIT_MASK_SEQNUM_MID << BIT_SHIFT_SEQNUM_MID)
#define BIT_CLEAR_SEQNUM_MID(x) ((x) & (~BITS_SEQNUM_MID))
#define BIT_GET_SEQNUM_MID(x)                                                  \
	(((x) >> BIT_SHIFT_SEQNUM_MID) & BIT_MASK_SEQNUM_MID)
#define BIT_SET_SEQNUM_MID(x, v) (BIT_CLEAR_SEQNUM_MID(x) | BIT_SEQNUM_MID(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_TC6_CTRL				(Offset 0x016C) */

#define BIT_SHIFT_TC6DATA 0
#define BIT_MASK_TC6DATA 0xffffff
#define BIT_TC6DATA(x) (((x) & BIT_MASK_TC6DATA) << BIT_SHIFT_TC6DATA)
#define BITS_TC6DATA (BIT_MASK_TC6DATA << BIT_SHIFT_TC6DATA)
#define BIT_CLEAR_TC6DATA(x) ((x) & (~BITS_TC6DATA))
#define BIT_GET_TC6DATA(x) (((x) >> BIT_SHIFT_TC6DATA) & BIT_MASK_TC6DATA)
#define BIT_SET_TC6DATA(x, v) (BIT_CLEAR_TC6DATA(x) | BIT_TC6DATA(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_MBIST_DRF_FAIL			(Offset 0x0170) */

#define BIT_SHIFT_WLON_MBIST_DRF_FAIL 30
#define BIT_MASK_WLON_MBIST_DRF_FAIL 0x3
#define BIT_WLON_MBIST_DRF_FAIL(x)                                             \
	(((x) & BIT_MASK_WLON_MBIST_DRF_FAIL) << BIT_SHIFT_WLON_MBIST_DRF_FAIL)
#define BITS_WLON_MBIST_DRF_FAIL                                               \
	(BIT_MASK_WLON_MBIST_DRF_FAIL << BIT_SHIFT_WLON_MBIST_DRF_FAIL)
#define BIT_CLEAR_WLON_MBIST_DRF_FAIL(x) ((x) & (~BITS_WLON_MBIST_DRF_FAIL))
#define BIT_GET_WLON_MBIST_DRF_FAIL(x)                                         \
	(((x) >> BIT_SHIFT_WLON_MBIST_DRF_FAIL) & BIT_MASK_WLON_MBIST_DRF_FAIL)
#define BIT_SET_WLON_MBIST_DRF_FAIL(x, v)                                      \
	(BIT_CLEAR_WLON_MBIST_DRF_FAIL(x) | BIT_WLON_MBIST_DRF_FAIL(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_MBIST_FAIL				(Offset 0x0170) */

#define BIT_SHIFT_8051_MBIST_FAIL 26
#define BIT_MASK_8051_MBIST_FAIL 0x7
#define BIT_8051_MBIST_FAIL(x)                                                 \
	(((x) & BIT_MASK_8051_MBIST_FAIL) << BIT_SHIFT_8051_MBIST_FAIL)
#define BITS_8051_MBIST_FAIL                                                   \
	(BIT_MASK_8051_MBIST_FAIL << BIT_SHIFT_8051_MBIST_FAIL)
#define BIT_CLEAR_8051_MBIST_FAIL(x) ((x) & (~BITS_8051_MBIST_FAIL))
#define BIT_GET_8051_MBIST_FAIL(x)                                             \
	(((x) >> BIT_SHIFT_8051_MBIST_FAIL) & BIT_MASK_8051_MBIST_FAIL)
#define BIT_SET_8051_MBIST_FAIL(x, v)                                          \
	(BIT_CLEAR_8051_MBIST_FAIL(x) | BIT_8051_MBIST_FAIL(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_MBIST_DRF_FAIL			(Offset 0x0170) */

#define BIT_SHIFT_8051_MBIST_DRF_FAIL 26
#define BIT_MASK_8051_MBIST_DRF_FAIL 0x3f
#define BIT_8051_MBIST_DRF_FAIL(x)                                             \
	(((x) & BIT_MASK_8051_MBIST_DRF_FAIL) << BIT_SHIFT_8051_MBIST_DRF_FAIL)
#define BITS_8051_MBIST_DRF_FAIL                                               \
	(BIT_MASK_8051_MBIST_DRF_FAIL << BIT_SHIFT_8051_MBIST_DRF_FAIL)
#define BIT_CLEAR_8051_MBIST_DRF_FAIL(x) ((x) & (~BITS_8051_MBIST_DRF_FAIL))
#define BIT_GET_8051_MBIST_DRF_FAIL(x)                                         \
	(((x) >> BIT_SHIFT_8051_MBIST_DRF_FAIL) & BIT_MASK_8051_MBIST_DRF_FAIL)
#define BIT_SET_8051_MBIST_DRF_FAIL(x, v)                                      \
	(BIT_CLEAR_8051_MBIST_DRF_FAIL(x) | BIT_8051_MBIST_DRF_FAIL(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_MBIST_FAIL				(Offset 0x0170) */

#define BIT_SHIFT_USB_MBIST_FAIL 24
#define BIT_MASK_USB_MBIST_FAIL 0x3
#define BIT_USB_MBIST_FAIL(x)                                                  \
	(((x) & BIT_MASK_USB_MBIST_FAIL) << BIT_SHIFT_USB_MBIST_FAIL)
#define BITS_USB_MBIST_FAIL                                                    \
	(BIT_MASK_USB_MBIST_FAIL << BIT_SHIFT_USB_MBIST_FAIL)
#define BIT_CLEAR_USB_MBIST_FAIL(x) ((x) & (~BITS_USB_MBIST_FAIL))
#define BIT_GET_USB_MBIST_FAIL(x)                                              \
	(((x) >> BIT_SHIFT_USB_MBIST_FAIL) & BIT_MASK_USB_MBIST_FAIL)
#define BIT_SET_USB_MBIST_FAIL(x, v)                                           \
	(BIT_CLEAR_USB_MBIST_FAIL(x) | BIT_USB_MBIST_FAIL(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_MBIST_DRF_FAIL			(Offset 0x0170) */

#define BIT_SHIFT_USB_MBIST_DRF_FAIL 24
#define BIT_MASK_USB_MBIST_DRF_FAIL 0x3
#define BIT_USB_MBIST_DRF_FAIL(x)                                              \
	(((x) & BIT_MASK_USB_MBIST_DRF_FAIL) << BIT_SHIFT_USB_MBIST_DRF_FAIL)
#define BITS_USB_MBIST_DRF_FAIL                                                \
	(BIT_MASK_USB_MBIST_DRF_FAIL << BIT_SHIFT_USB_MBIST_DRF_FAIL)
#define BIT_CLEAR_USB_MBIST_DRF_FAIL(x) ((x) & (~BITS_USB_MBIST_DRF_FAIL))
#define BIT_GET_USB_MBIST_DRF_FAIL(x)                                          \
	(((x) >> BIT_SHIFT_USB_MBIST_DRF_FAIL) & BIT_MASK_USB_MBIST_DRF_FAIL)
#define BIT_SET_USB_MBIST_DRF_FAIL(x, v)                                       \
	(BIT_CLEAR_USB_MBIST_DRF_FAIL(x) | BIT_USB_MBIST_DRF_FAIL(v))

#define BIT_SHIFT_PCIE_MBIST_DRF_FAIL 18
#define BIT_MASK_PCIE_MBIST_DRF_FAIL 0x3f
#define BIT_PCIE_MBIST_DRF_FAIL(x)                                             \
	(((x) & BIT_MASK_PCIE_MBIST_DRF_FAIL) << BIT_SHIFT_PCIE_MBIST_DRF_FAIL)
#define BITS_PCIE_MBIST_DRF_FAIL                                               \
	(BIT_MASK_PCIE_MBIST_DRF_FAIL << BIT_SHIFT_PCIE_MBIST_DRF_FAIL)
#define BIT_CLEAR_PCIE_MBIST_DRF_FAIL(x) ((x) & (~BITS_PCIE_MBIST_DRF_FAIL))
#define BIT_GET_PCIE_MBIST_DRF_FAIL(x)                                         \
	(((x) >> BIT_SHIFT_PCIE_MBIST_DRF_FAIL) & BIT_MASK_PCIE_MBIST_DRF_FAIL)
#define BIT_SET_PCIE_MBIST_DRF_FAIL(x, v)                                      \
	(BIT_CLEAR_PCIE_MBIST_DRF_FAIL(x) | BIT_PCIE_MBIST_DRF_FAIL(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_MBIST_FAIL				(Offset 0x0170) */

#define BIT_SHIFT_PCIE_MBIST_FAIL 16
#define BIT_MASK_PCIE_MBIST_FAIL 0x3f
#define BIT_PCIE_MBIST_FAIL(x)                                                 \
	(((x) & BIT_MASK_PCIE_MBIST_FAIL) << BIT_SHIFT_PCIE_MBIST_FAIL)
#define BITS_PCIE_MBIST_FAIL                                                   \
	(BIT_MASK_PCIE_MBIST_FAIL << BIT_SHIFT_PCIE_MBIST_FAIL)
#define BIT_CLEAR_PCIE_MBIST_FAIL(x) ((x) & (~BITS_PCIE_MBIST_FAIL))
#define BIT_GET_PCIE_MBIST_FAIL(x)                                             \
	(((x) >> BIT_SHIFT_PCIE_MBIST_FAIL) & BIT_MASK_PCIE_MBIST_FAIL)
#define BIT_SET_PCIE_MBIST_FAIL(x, v)                                          \
	(BIT_CLEAR_PCIE_MBIST_FAIL(x) | BIT_PCIE_MBIST_FAIL(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_MBIST_DRF_FAIL			(Offset 0x0170) */

#define BIT_SHIFT_WLOFF_MBIST_DRF_FAIL 16
#define BIT_MASK_WLOFF_MBIST_DRF_FAIL 0x3fff
#define BIT_WLOFF_MBIST_DRF_FAIL(x)                                            \
	(((x) & BIT_MASK_WLOFF_MBIST_DRF_FAIL)                                 \
	 << BIT_SHIFT_WLOFF_MBIST_DRF_FAIL)
#define BITS_WLOFF_MBIST_DRF_FAIL                                              \
	(BIT_MASK_WLOFF_MBIST_DRF_FAIL << BIT_SHIFT_WLOFF_MBIST_DRF_FAIL)
#define BIT_CLEAR_WLOFF_MBIST_DRF_FAIL(x) ((x) & (~BITS_WLOFF_MBIST_DRF_FAIL))
#define BIT_GET_WLOFF_MBIST_DRF_FAIL(x)                                        \
	(((x) >> BIT_SHIFT_WLOFF_MBIST_DRF_FAIL) &                             \
	 BIT_MASK_WLOFF_MBIST_DRF_FAIL)
#define BIT_SET_WLOFF_MBIST_DRF_FAIL(x, v)                                     \
	(BIT_CLEAR_WLOFF_MBIST_DRF_FAIL(x) | BIT_WLOFF_MBIST_DRF_FAIL(v))

#define BIT_SHIFT_PCIE_MBIST_DRF_FAIL_V1 11
#define BIT_MASK_PCIE_MBIST_DRF_FAIL_V1 0x1f
#define BIT_PCIE_MBIST_DRF_FAIL_V1(x)                                          \
	(((x) & BIT_MASK_PCIE_MBIST_DRF_FAIL_V1)                               \
	 << BIT_SHIFT_PCIE_MBIST_DRF_FAIL_V1)
#define BITS_PCIE_MBIST_DRF_FAIL_V1                                            \
	(BIT_MASK_PCIE_MBIST_DRF_FAIL_V1 << BIT_SHIFT_PCIE_MBIST_DRF_FAIL_V1)
#define BIT_CLEAR_PCIE_MBIST_DRF_FAIL_V1(x)                                    \
	((x) & (~BITS_PCIE_MBIST_DRF_FAIL_V1))
#define BIT_GET_PCIE_MBIST_DRF_FAIL_V1(x)                                      \
	(((x) >> BIT_SHIFT_PCIE_MBIST_DRF_FAIL_V1) &                           \
	 BIT_MASK_PCIE_MBIST_DRF_FAIL_V1)
#define BIT_SET_PCIE_MBIST_DRF_FAIL_V1(x, v)                                   \
	(BIT_CLEAR_PCIE_MBIST_DRF_FAIL_V1(x) | BIT_PCIE_MBIST_DRF_FAIL_V1(v))

#define BIT_SHIFT_USB_MBIST_DRF_FAIL_V1 4
#define BIT_MASK_USB_MBIST_DRF_FAIL_V1 0x7f
#define BIT_USB_MBIST_DRF_FAIL_V1(x)                                           \
	(((x) & BIT_MASK_USB_MBIST_DRF_FAIL_V1)                                \
	 << BIT_SHIFT_USB_MBIST_DRF_FAIL_V1)
#define BITS_USB_MBIST_DRF_FAIL_V1                                             \
	(BIT_MASK_USB_MBIST_DRF_FAIL_V1 << BIT_SHIFT_USB_MBIST_DRF_FAIL_V1)
#define BIT_CLEAR_USB_MBIST_DRF_FAIL_V1(x) ((x) & (~BITS_USB_MBIST_DRF_FAIL_V1))
#define BIT_GET_USB_MBIST_DRF_FAIL_V1(x)                                       \
	(((x) >> BIT_SHIFT_USB_MBIST_DRF_FAIL_V1) &                            \
	 BIT_MASK_USB_MBIST_DRF_FAIL_V1)
#define BIT_SET_USB_MBIST_DRF_FAIL_V1(x, v)                                    \
	(BIT_CLEAR_USB_MBIST_DRF_FAIL_V1(x) | BIT_USB_MBIST_DRF_FAIL_V1(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_MBIST_FAIL				(Offset 0x0170) */

#define BIT_SHIFT_MAC_MBIST_FAIL 0
#define BIT_MASK_MAC_MBIST_FAIL 0xfff
#define BIT_MAC_MBIST_FAIL(x)                                                  \
	(((x) & BIT_MASK_MAC_MBIST_FAIL) << BIT_SHIFT_MAC_MBIST_FAIL)
#define BITS_MAC_MBIST_FAIL                                                    \
	(BIT_MASK_MAC_MBIST_FAIL << BIT_SHIFT_MAC_MBIST_FAIL)
#define BIT_CLEAR_MAC_MBIST_FAIL(x) ((x) & (~BITS_MAC_MBIST_FAIL))
#define BIT_GET_MAC_MBIST_FAIL(x)                                              \
	(((x) >> BIT_SHIFT_MAC_MBIST_FAIL) & BIT_MASK_MAC_MBIST_FAIL)
#define BIT_SET_MAC_MBIST_FAIL(x, v)                                           \
	(BIT_CLEAR_MAC_MBIST_FAIL(x) | BIT_MAC_MBIST_FAIL(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_MBIST_DRF_FAIL			(Offset 0x0170) */

#define BIT_SHIFT_USB_WLON_MBIST_DRF_FAIL 0
#define BIT_MASK_USB_WLON_MBIST_DRF_FAIL 0xf
#define BIT_USB_WLON_MBIST_DRF_FAIL(x)                                         \
	(((x) & BIT_MASK_USB_WLON_MBIST_DRF_FAIL)                              \
	 << BIT_SHIFT_USB_WLON_MBIST_DRF_FAIL)
#define BITS_USB_WLON_MBIST_DRF_FAIL                                           \
	(BIT_MASK_USB_WLON_MBIST_DRF_FAIL << BIT_SHIFT_USB_WLON_MBIST_DRF_FAIL)
#define BIT_CLEAR_USB_WLON_MBIST_DRF_FAIL(x)                                   \
	((x) & (~BITS_USB_WLON_MBIST_DRF_FAIL))
#define BIT_GET_USB_WLON_MBIST_DRF_FAIL(x)                                     \
	(((x) >> BIT_SHIFT_USB_WLON_MBIST_DRF_FAIL) &                          \
	 BIT_MASK_USB_WLON_MBIST_DRF_FAIL)
#define BIT_SET_USB_WLON_MBIST_DRF_FAIL(x, v)                                  \
	(BIT_CLEAR_USB_WLON_MBIST_DRF_FAIL(x) | BIT_USB_WLON_MBIST_DRF_FAIL(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_MBIST_FAIL				(Offset 0x0170) */

#define BIT_SHIFT_MAC_MBIST_FAIL_DRF 0
#define BIT_MASK_MAC_MBIST_FAIL_DRF 0x3ffff
#define BIT_MAC_MBIST_FAIL_DRF(x)                                              \
	(((x) & BIT_MASK_MAC_MBIST_FAIL_DRF) << BIT_SHIFT_MAC_MBIST_FAIL_DRF)
#define BITS_MAC_MBIST_FAIL_DRF                                                \
	(BIT_MASK_MAC_MBIST_FAIL_DRF << BIT_SHIFT_MAC_MBIST_FAIL_DRF)
#define BIT_CLEAR_MAC_MBIST_FAIL_DRF(x) ((x) & (~BITS_MAC_MBIST_FAIL_DRF))
#define BIT_GET_MAC_MBIST_FAIL_DRF(x)                                          \
	(((x) >> BIT_SHIFT_MAC_MBIST_FAIL_DRF) & BIT_MASK_MAC_MBIST_FAIL_DRF)
#define BIT_SET_MAC_MBIST_FAIL_DRF(x, v)                                       \
	(BIT_CLEAR_MAC_MBIST_FAIL_DRF(x) | BIT_MAC_MBIST_FAIL_DRF(v))

#endif

#if (HALMAC_8197G_SUPPORT)

/* 2 REG_MBIST_FAIL				(Offset 0x0170) */

#define BIT_SHIFT_MAC_MBIST_FAIL_DRF_V1 0
#define BIT_MASK_MAC_MBIST_FAIL_DRF_V1 0x7ffff
#define BIT_MAC_MBIST_FAIL_DRF_V1(x)                                           \
	(((x) & BIT_MASK_MAC_MBIST_FAIL_DRF_V1)                                \
	 << BIT_SHIFT_MAC_MBIST_FAIL_DRF_V1)
#define BITS_MAC_MBIST_FAIL_DRF_V1                                             \
	(BIT_MASK_MAC_MBIST_FAIL_DRF_V1 << BIT_SHIFT_MAC_MBIST_FAIL_DRF_V1)
#define BIT_CLEAR_MAC_MBIST_FAIL_DRF_V1(x) ((x) & (~BITS_MAC_MBIST_FAIL_DRF_V1))
#define BIT_GET_MAC_MBIST_FAIL_DRF_V1(x)                                       \
	(((x) >> BIT_SHIFT_MAC_MBIST_FAIL_DRF_V1) &                            \
	 BIT_MASK_MAC_MBIST_FAIL_DRF_V1)
#define BIT_SET_MAC_MBIST_FAIL_DRF_V1(x, v)                                    \
	(BIT_CLEAR_MAC_MBIST_FAIL_DRF_V1(x) | BIT_MAC_MBIST_FAIL_DRF_V1(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_MBIST_DRF_FAIL			(Offset 0x0170) */

#define BIT_SHIFT_MAC_MBIST_DRF_FAIL 0
#define BIT_MASK_MAC_MBIST_DRF_FAIL 0x3ffff
#define BIT_MAC_MBIST_DRF_FAIL(x)                                              \
	(((x) & BIT_MASK_MAC_MBIST_DRF_FAIL) << BIT_SHIFT_MAC_MBIST_DRF_FAIL)
#define BITS_MAC_MBIST_DRF_FAIL                                                \
	(BIT_MASK_MAC_MBIST_DRF_FAIL << BIT_SHIFT_MAC_MBIST_DRF_FAIL)
#define BIT_CLEAR_MAC_MBIST_DRF_FAIL(x) ((x) & (~BITS_MAC_MBIST_DRF_FAIL))
#define BIT_GET_MAC_MBIST_DRF_FAIL(x)                                          \
	(((x) >> BIT_SHIFT_MAC_MBIST_DRF_FAIL) & BIT_MASK_MAC_MBIST_DRF_FAIL)
#define BIT_SET_MAC_MBIST_DRF_FAIL(x, v)                                       \
	(BIT_CLEAR_MAC_MBIST_DRF_FAIL(x) | BIT_MAC_MBIST_DRF_FAIL(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_MBIST_START_PAUSE			(Offset 0x0174) */

#define BIT_SHIFT_8051_MBIST_START_PAUSE 26
#define BIT_MASK_8051_MBIST_START_PAUSE 0x7
#define BIT_8051_MBIST_START_PAUSE(x)                                          \
	(((x) & BIT_MASK_8051_MBIST_START_PAUSE)                               \
	 << BIT_SHIFT_8051_MBIST_START_PAUSE)
#define BITS_8051_MBIST_START_PAUSE                                            \
	(BIT_MASK_8051_MBIST_START_PAUSE << BIT_SHIFT_8051_MBIST_START_PAUSE)
#define BIT_CLEAR_8051_MBIST_START_PAUSE(x)                                    \
	((x) & (~BITS_8051_MBIST_START_PAUSE))
#define BIT_GET_8051_MBIST_START_PAUSE(x)                                      \
	(((x) >> BIT_SHIFT_8051_MBIST_START_PAUSE) &                           \
	 BIT_MASK_8051_MBIST_START_PAUSE)
#define BIT_SET_8051_MBIST_START_PAUSE(x, v)                                   \
	(BIT_CLEAR_8051_MBIST_START_PAUSE(x) | BIT_8051_MBIST_START_PAUSE(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_MBIST_START_PAUSE			(Offset 0x0174) */

#define BIT_SHIFT_8051_MBIST_START_PAUSE_V1 26
#define BIT_MASK_8051_MBIST_START_PAUSE_V1 0x3f
#define BIT_8051_MBIST_START_PAUSE_V1(x)                                       \
	(((x) & BIT_MASK_8051_MBIST_START_PAUSE_V1)                            \
	 << BIT_SHIFT_8051_MBIST_START_PAUSE_V1)
#define BITS_8051_MBIST_START_PAUSE_V1                                         \
	(BIT_MASK_8051_MBIST_START_PAUSE_V1                                    \
	 << BIT_SHIFT_8051_MBIST_START_PAUSE_V1)
#define BIT_CLEAR_8051_MBIST_START_PAUSE_V1(x)                                 \
	((x) & (~BITS_8051_MBIST_START_PAUSE_V1))
#define BIT_GET_8051_MBIST_START_PAUSE_V1(x)                                   \
	(((x) >> BIT_SHIFT_8051_MBIST_START_PAUSE_V1) &                        \
	 BIT_MASK_8051_MBIST_START_PAUSE_V1)
#define BIT_SET_8051_MBIST_START_PAUSE_V1(x, v)                                \
	(BIT_CLEAR_8051_MBIST_START_PAUSE_V1(x) |                              \
	 BIT_8051_MBIST_START_PAUSE_V1(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_MBIST_START_PAUSE			(Offset 0x0174) */

#define BIT_SHIFT_USB_MBIST_START_PAUSE 24
#define BIT_MASK_USB_MBIST_START_PAUSE 0x3
#define BIT_USB_MBIST_START_PAUSE(x)                                           \
	(((x) & BIT_MASK_USB_MBIST_START_PAUSE)                                \
	 << BIT_SHIFT_USB_MBIST_START_PAUSE)
#define BITS_USB_MBIST_START_PAUSE                                             \
	(BIT_MASK_USB_MBIST_START_PAUSE << BIT_SHIFT_USB_MBIST_START_PAUSE)
#define BIT_CLEAR_USB_MBIST_START_PAUSE(x) ((x) & (~BITS_USB_MBIST_START_PAUSE))
#define BIT_GET_USB_MBIST_START_PAUSE(x)                                       \
	(((x) >> BIT_SHIFT_USB_MBIST_START_PAUSE) &                            \
	 BIT_MASK_USB_MBIST_START_PAUSE)
#define BIT_SET_USB_MBIST_START_PAUSE(x, v)                                    \
	(BIT_CLEAR_USB_MBIST_START_PAUSE(x) | BIT_USB_MBIST_START_PAUSE(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_MBIST_START_PAUSE			(Offset 0x0174) */

#define BIT_SHIFT_USB_MBIST_START_PAUSE_V1 24
#define BIT_MASK_USB_MBIST_START_PAUSE_V1 0x3
#define BIT_USB_MBIST_START_PAUSE_V1(x)                                        \
	(((x) & BIT_MASK_USB_MBIST_START_PAUSE_V1)                             \
	 << BIT_SHIFT_USB_MBIST_START_PAUSE_V1)
#define BITS_USB_MBIST_START_PAUSE_V1                                          \
	(BIT_MASK_USB_MBIST_START_PAUSE_V1                                     \
	 << BIT_SHIFT_USB_MBIST_START_PAUSE_V1)
#define BIT_CLEAR_USB_MBIST_START_PAUSE_V1(x)                                  \
	((x) & (~BITS_USB_MBIST_START_PAUSE_V1))
#define BIT_GET_USB_MBIST_START_PAUSE_V1(x)                                    \
	(((x) >> BIT_SHIFT_USB_MBIST_START_PAUSE_V1) &                         \
	 BIT_MASK_USB_MBIST_START_PAUSE_V1)
#define BIT_SET_USB_MBIST_START_PAUSE_V1(x, v)                                 \
	(BIT_CLEAR_USB_MBIST_START_PAUSE_V1(x) |                               \
	 BIT_USB_MBIST_START_PAUSE_V1(v))

#define BIT_SHIFT_PCIE_MBIST_START_PAUSE_V1 18
#define BIT_MASK_PCIE_MBIST_START_PAUSE_V1 0x3f
#define BIT_PCIE_MBIST_START_PAUSE_V1(x)                                       \
	(((x) & BIT_MASK_PCIE_MBIST_START_PAUSE_V1)                            \
	 << BIT_SHIFT_PCIE_MBIST_START_PAUSE_V1)
#define BITS_PCIE_MBIST_START_PAUSE_V1                                         \
	(BIT_MASK_PCIE_MBIST_START_PAUSE_V1                                    \
	 << BIT_SHIFT_PCIE_MBIST_START_PAUSE_V1)
#define BIT_CLEAR_PCIE_MBIST_START_PAUSE_V1(x)                                 \
	((x) & (~BITS_PCIE_MBIST_START_PAUSE_V1))
#define BIT_GET_PCIE_MBIST_START_PAUSE_V1(x)                                   \
	(((x) >> BIT_SHIFT_PCIE_MBIST_START_PAUSE_V1) &                        \
	 BIT_MASK_PCIE_MBIST_START_PAUSE_V1)
#define BIT_SET_PCIE_MBIST_START_PAUSE_V1(x, v)                                \
	(BIT_CLEAR_PCIE_MBIST_START_PAUSE_V1(x) |                              \
	 BIT_PCIE_MBIST_START_PAUSE_V1(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_MBIST_START_PAUSE			(Offset 0x0174) */

#define BIT_SHIFT_PCIE_MBIST_START_PAUSE 16
#define BIT_MASK_PCIE_MBIST_START_PAUSE 0x3f
#define BIT_PCIE_MBIST_START_PAUSE(x)                                          \
	(((x) & BIT_MASK_PCIE_MBIST_START_PAUSE)                               \
	 << BIT_SHIFT_PCIE_MBIST_START_PAUSE)
#define BITS_PCIE_MBIST_START_PAUSE                                            \
	(BIT_MASK_PCIE_MBIST_START_PAUSE << BIT_SHIFT_PCIE_MBIST_START_PAUSE)
#define BIT_CLEAR_PCIE_MBIST_START_PAUSE(x)                                    \
	((x) & (~BITS_PCIE_MBIST_START_PAUSE))
#define BIT_GET_PCIE_MBIST_START_PAUSE(x)                                      \
	(((x) >> BIT_SHIFT_PCIE_MBIST_START_PAUSE) &                           \
	 BIT_MASK_PCIE_MBIST_START_PAUSE)
#define BIT_SET_PCIE_MBIST_START_PAUSE(x, v)                                   \
	(BIT_CLEAR_PCIE_MBIST_START_PAUSE(x) | BIT_PCIE_MBIST_START_PAUSE(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_MBIST_START_PAUSE			(Offset 0x0174) */

#define BIT_SHIFT_WLON_MBIST_START_PAUSE_V1 9
#define BIT_MASK_WLON_MBIST_START_PAUSE_V1 0x3
#define BIT_WLON_MBIST_START_PAUSE_V1(x)                                       \
	(((x) & BIT_MASK_WLON_MBIST_START_PAUSE_V1)                            \
	 << BIT_SHIFT_WLON_MBIST_START_PAUSE_V1)
#define BITS_WLON_MBIST_START_PAUSE_V1                                         \
	(BIT_MASK_WLON_MBIST_START_PAUSE_V1                                    \
	 << BIT_SHIFT_WLON_MBIST_START_PAUSE_V1)
#define BIT_CLEAR_WLON_MBIST_START_PAUSE_V1(x)                                 \
	((x) & (~BITS_WLON_MBIST_START_PAUSE_V1))
#define BIT_GET_WLON_MBIST_START_PAUSE_V1(x)                                   \
	(((x) >> BIT_SHIFT_WLON_MBIST_START_PAUSE_V1) &                        \
	 BIT_MASK_WLON_MBIST_START_PAUSE_V1)
#define BIT_SET_WLON_MBIST_START_PAUSE_V1(x, v)                                \
	(BIT_CLEAR_WLON_MBIST_START_PAUSE_V1(x) |                              \
	 BIT_WLON_MBIST_START_PAUSE_V1(v))

#define BIT_SHIFT_WLOFF_MBIST_START_PAUSE_V1 4
#define BIT_MASK_WLOFF_MBIST_START_PAUSE_V1 0x1f
#define BIT_WLOFF_MBIST_START_PAUSE_V1(x)                                      \
	(((x) & BIT_MASK_WLOFF_MBIST_START_PAUSE_V1)                           \
	 << BIT_SHIFT_WLOFF_MBIST_START_PAUSE_V1)
#define BITS_WLOFF_MBIST_START_PAUSE_V1                                        \
	(BIT_MASK_WLOFF_MBIST_START_PAUSE_V1                                   \
	 << BIT_SHIFT_WLOFF_MBIST_START_PAUSE_V1)
#define BIT_CLEAR_WLOFF_MBIST_START_PAUSE_V1(x)                                \
	((x) & (~BITS_WLOFF_MBIST_START_PAUSE_V1))
#define BIT_GET_WLOFF_MBIST_START_PAUSE_V1(x)                                  \
	(((x) >> BIT_SHIFT_WLOFF_MBIST_START_PAUSE_V1) &                       \
	 BIT_MASK_WLOFF_MBIST_START_PAUSE_V1)
#define BIT_SET_WLOFF_MBIST_START_PAUSE_V1(x, v)                               \
	(BIT_CLEAR_WLOFF_MBIST_START_PAUSE_V1(x) |                             \
	 BIT_WLOFF_MBIST_START_PAUSE_V1(v))

#define BIT_SHIFT_PCIE_MBIST_START_PAUSE_V2 2
#define BIT_MASK_PCIE_MBIST_START_PAUSE_V2 0x3
#define BIT_PCIE_MBIST_START_PAUSE_V2(x)                                       \
	(((x) & BIT_MASK_PCIE_MBIST_START_PAUSE_V2)                            \
	 << BIT_SHIFT_PCIE_MBIST_START_PAUSE_V2)
#define BITS_PCIE_MBIST_START_PAUSE_V2                                         \
	(BIT_MASK_PCIE_MBIST_START_PAUSE_V2                                    \
	 << BIT_SHIFT_PCIE_MBIST_START_PAUSE_V2)
#define BIT_CLEAR_PCIE_MBIST_START_PAUSE_V2(x)                                 \
	((x) & (~BITS_PCIE_MBIST_START_PAUSE_V2))
#define BIT_GET_PCIE_MBIST_START_PAUSE_V2(x)                                   \
	(((x) >> BIT_SHIFT_PCIE_MBIST_START_PAUSE_V2) &                        \
	 BIT_MASK_PCIE_MBIST_START_PAUSE_V2)
#define BIT_SET_PCIE_MBIST_START_PAUSE_V2(x, v)                                \
	(BIT_CLEAR_PCIE_MBIST_START_PAUSE_V2(x) |                              \
	 BIT_PCIE_MBIST_START_PAUSE_V2(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_MBIST_START_PAUSE			(Offset 0x0174) */

#define BIT_SHIFT_MAC_MBIST_START_PAUSE 0
#define BIT_MASK_MAC_MBIST_START_PAUSE 0xfff
#define BIT_MAC_MBIST_START_PAUSE(x)                                           \
	(((x) & BIT_MASK_MAC_MBIST_START_PAUSE)                                \
	 << BIT_SHIFT_MAC_MBIST_START_PAUSE)
#define BITS_MAC_MBIST_START_PAUSE                                             \
	(BIT_MASK_MAC_MBIST_START_PAUSE << BIT_SHIFT_MAC_MBIST_START_PAUSE)
#define BIT_CLEAR_MAC_MBIST_START_PAUSE(x) ((x) & (~BITS_MAC_MBIST_START_PAUSE))
#define BIT_GET_MAC_MBIST_START_PAUSE(x)                                       \
	(((x) >> BIT_SHIFT_MAC_MBIST_START_PAUSE) &                            \
	 BIT_MASK_MAC_MBIST_START_PAUSE)
#define BIT_SET_MAC_MBIST_START_PAUSE(x, v)                                    \
	(BIT_CLEAR_MAC_MBIST_START_PAUSE(x) | BIT_MAC_MBIST_START_PAUSE(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_MBIST_START_PAUSE			(Offset 0x0174) */

#define BIT_SHIFT_USB_MBIST_START_PAUSE_V2 0
#define BIT_MASK_USB_MBIST_START_PAUSE_V2 0x3
#define BIT_USB_MBIST_START_PAUSE_V2(x)                                        \
	(((x) & BIT_MASK_USB_MBIST_START_PAUSE_V2)                             \
	 << BIT_SHIFT_USB_MBIST_START_PAUSE_V2)
#define BITS_USB_MBIST_START_PAUSE_V2                                          \
	(BIT_MASK_USB_MBIST_START_PAUSE_V2                                     \
	 << BIT_SHIFT_USB_MBIST_START_PAUSE_V2)
#define BIT_CLEAR_USB_MBIST_START_PAUSE_V2(x)                                  \
	((x) & (~BITS_USB_MBIST_START_PAUSE_V2))
#define BIT_GET_USB_MBIST_START_PAUSE_V2(x)                                    \
	(((x) >> BIT_SHIFT_USB_MBIST_START_PAUSE_V2) &                         \
	 BIT_MASK_USB_MBIST_START_PAUSE_V2)
#define BIT_SET_USB_MBIST_START_PAUSE_V2(x, v)                                 \
	(BIT_CLEAR_USB_MBIST_START_PAUSE_V2(x) |                               \
	 BIT_USB_MBIST_START_PAUSE_V2(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_MBIST_START_PAUSE			(Offset 0x0174) */

#define BIT_SHIFT_MAC_MBIST_START_PAUSE_V1 0
#define BIT_MASK_MAC_MBIST_START_PAUSE_V1 0x3ffff
#define BIT_MAC_MBIST_START_PAUSE_V1(x)                                        \
	(((x) & BIT_MASK_MAC_MBIST_START_PAUSE_V1)                             \
	 << BIT_SHIFT_MAC_MBIST_START_PAUSE_V1)
#define BITS_MAC_MBIST_START_PAUSE_V1                                          \
	(BIT_MASK_MAC_MBIST_START_PAUSE_V1                                     \
	 << BIT_SHIFT_MAC_MBIST_START_PAUSE_V1)
#define BIT_CLEAR_MAC_MBIST_START_PAUSE_V1(x)                                  \
	((x) & (~BITS_MAC_MBIST_START_PAUSE_V1))
#define BIT_GET_MAC_MBIST_START_PAUSE_V1(x)                                    \
	(((x) >> BIT_SHIFT_MAC_MBIST_START_PAUSE_V1) &                         \
	 BIT_MASK_MAC_MBIST_START_PAUSE_V1)
#define BIT_SET_MAC_MBIST_START_PAUSE_V1(x, v)                                 \
	(BIT_CLEAR_MAC_MBIST_START_PAUSE_V1(x) |                               \
	 BIT_MAC_MBIST_START_PAUSE_V1(v))

#endif

#if (HALMAC_8197G_SUPPORT)

/* 2 REG_MBIST_START_PAUSE			(Offset 0x0174) */

#define BIT_SHIFT_MAC_MBIST_START_PAUSE_V2 0
#define BIT_MASK_MAC_MBIST_START_PAUSE_V2 0x1ff
#define BIT_MAC_MBIST_START_PAUSE_V2(x)                                        \
	(((x) & BIT_MASK_MAC_MBIST_START_PAUSE_V2)                             \
	 << BIT_SHIFT_MAC_MBIST_START_PAUSE_V2)
#define BITS_MAC_MBIST_START_PAUSE_V2                                          \
	(BIT_MASK_MAC_MBIST_START_PAUSE_V2                                     \
	 << BIT_SHIFT_MAC_MBIST_START_PAUSE_V2)
#define BIT_CLEAR_MAC_MBIST_START_PAUSE_V2(x)                                  \
	((x) & (~BITS_MAC_MBIST_START_PAUSE_V2))
#define BIT_GET_MAC_MBIST_START_PAUSE_V2(x)                                    \
	(((x) >> BIT_SHIFT_MAC_MBIST_START_PAUSE_V2) &                         \
	 BIT_MASK_MAC_MBIST_START_PAUSE_V2)
#define BIT_SET_MAC_MBIST_START_PAUSE_V2(x, v)                                 \
	(BIT_CLEAR_MAC_MBIST_START_PAUSE_V2(x) |                               \
	 BIT_MAC_MBIST_START_PAUSE_V2(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_MBIST_DONE				(Offset 0x0178) */

#define BIT_SHIFT_8051_MBIST_DONE 26
#define BIT_MASK_8051_MBIST_DONE 0x7
#define BIT_8051_MBIST_DONE(x)                                                 \
	(((x) & BIT_MASK_8051_MBIST_DONE) << BIT_SHIFT_8051_MBIST_DONE)
#define BITS_8051_MBIST_DONE                                                   \
	(BIT_MASK_8051_MBIST_DONE << BIT_SHIFT_8051_MBIST_DONE)
#define BIT_CLEAR_8051_MBIST_DONE(x) ((x) & (~BITS_8051_MBIST_DONE))
#define BIT_GET_8051_MBIST_DONE(x)                                             \
	(((x) >> BIT_SHIFT_8051_MBIST_DONE) & BIT_MASK_8051_MBIST_DONE)
#define BIT_SET_8051_MBIST_DONE(x, v)                                          \
	(BIT_CLEAR_8051_MBIST_DONE(x) | BIT_8051_MBIST_DONE(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_MBIST_DONE				(Offset 0x0178) */

#define BIT_SHIFT_8051_MBIST_DONE_V1 26
#define BIT_MASK_8051_MBIST_DONE_V1 0x3f
#define BIT_8051_MBIST_DONE_V1(x)                                              \
	(((x) & BIT_MASK_8051_MBIST_DONE_V1) << BIT_SHIFT_8051_MBIST_DONE_V1)
#define BITS_8051_MBIST_DONE_V1                                                \
	(BIT_MASK_8051_MBIST_DONE_V1 << BIT_SHIFT_8051_MBIST_DONE_V1)
#define BIT_CLEAR_8051_MBIST_DONE_V1(x) ((x) & (~BITS_8051_MBIST_DONE_V1))
#define BIT_GET_8051_MBIST_DONE_V1(x)                                          \
	(((x) >> BIT_SHIFT_8051_MBIST_DONE_V1) & BIT_MASK_8051_MBIST_DONE_V1)
#define BIT_SET_8051_MBIST_DONE_V1(x, v)                                       \
	(BIT_CLEAR_8051_MBIST_DONE_V1(x) | BIT_8051_MBIST_DONE_V1(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_MBIST_DONE				(Offset 0x0178) */

#define BIT_SHIFT_USB_MBIST_DONE 24
#define BIT_MASK_USB_MBIST_DONE 0x3
#define BIT_USB_MBIST_DONE(x)                                                  \
	(((x) & BIT_MASK_USB_MBIST_DONE) << BIT_SHIFT_USB_MBIST_DONE)
#define BITS_USB_MBIST_DONE                                                    \
	(BIT_MASK_USB_MBIST_DONE << BIT_SHIFT_USB_MBIST_DONE)
#define BIT_CLEAR_USB_MBIST_DONE(x) ((x) & (~BITS_USB_MBIST_DONE))
#define BIT_GET_USB_MBIST_DONE(x)                                              \
	(((x) >> BIT_SHIFT_USB_MBIST_DONE) & BIT_MASK_USB_MBIST_DONE)
#define BIT_SET_USB_MBIST_DONE(x, v)                                           \
	(BIT_CLEAR_USB_MBIST_DONE(x) | BIT_USB_MBIST_DONE(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_MBIST_DONE				(Offset 0x0178) */

#define BIT_SHIFT_USB_MBIST_DONE_V1 24
#define BIT_MASK_USB_MBIST_DONE_V1 0x3
#define BIT_USB_MBIST_DONE_V1(x)                                               \
	(((x) & BIT_MASK_USB_MBIST_DONE_V1) << BIT_SHIFT_USB_MBIST_DONE_V1)
#define BITS_USB_MBIST_DONE_V1                                                 \
	(BIT_MASK_USB_MBIST_DONE_V1 << BIT_SHIFT_USB_MBIST_DONE_V1)
#define BIT_CLEAR_USB_MBIST_DONE_V1(x) ((x) & (~BITS_USB_MBIST_DONE_V1))
#define BIT_GET_USB_MBIST_DONE_V1(x)                                           \
	(((x) >> BIT_SHIFT_USB_MBIST_DONE_V1) & BIT_MASK_USB_MBIST_DONE_V1)
#define BIT_SET_USB_MBIST_DONE_V1(x, v)                                        \
	(BIT_CLEAR_USB_MBIST_DONE_V1(x) | BIT_USB_MBIST_DONE_V1(v))

#define BIT_SHIFT_PCIE_MBIST_DONE_V1 18
#define BIT_MASK_PCIE_MBIST_DONE_V1 0x3f
#define BIT_PCIE_MBIST_DONE_V1(x)                                              \
	(((x) & BIT_MASK_PCIE_MBIST_DONE_V1) << BIT_SHIFT_PCIE_MBIST_DONE_V1)
#define BITS_PCIE_MBIST_DONE_V1                                                \
	(BIT_MASK_PCIE_MBIST_DONE_V1 << BIT_SHIFT_PCIE_MBIST_DONE_V1)
#define BIT_CLEAR_PCIE_MBIST_DONE_V1(x) ((x) & (~BITS_PCIE_MBIST_DONE_V1))
#define BIT_GET_PCIE_MBIST_DONE_V1(x)                                          \
	(((x) >> BIT_SHIFT_PCIE_MBIST_DONE_V1) & BIT_MASK_PCIE_MBIST_DONE_V1)
#define BIT_SET_PCIE_MBIST_DONE_V1(x, v)                                       \
	(BIT_CLEAR_PCIE_MBIST_DONE_V1(x) | BIT_PCIE_MBIST_DONE_V1(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_MBIST_DONE				(Offset 0x0178) */

#define BIT_SHIFT_PCIE_MBIST_DONE 16
#define BIT_MASK_PCIE_MBIST_DONE 0x3f
#define BIT_PCIE_MBIST_DONE(x)                                                 \
	(((x) & BIT_MASK_PCIE_MBIST_DONE) << BIT_SHIFT_PCIE_MBIST_DONE)
#define BITS_PCIE_MBIST_DONE                                                   \
	(BIT_MASK_PCIE_MBIST_DONE << BIT_SHIFT_PCIE_MBIST_DONE)
#define BIT_CLEAR_PCIE_MBIST_DONE(x) ((x) & (~BITS_PCIE_MBIST_DONE))
#define BIT_GET_PCIE_MBIST_DONE(x)                                             \
	(((x) >> BIT_SHIFT_PCIE_MBIST_DONE) & BIT_MASK_PCIE_MBIST_DONE)
#define BIT_SET_PCIE_MBIST_DONE(x, v)                                          \
	(BIT_CLEAR_PCIE_MBIST_DONE(x) | BIT_PCIE_MBIST_DONE(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_MBIST_DONE				(Offset 0x0178) */

#define BIT_SHIFT_WLON_MBIST_DONE_V1 9
#define BIT_MASK_WLON_MBIST_DONE_V1 0x3
#define BIT_WLON_MBIST_DONE_V1(x)                                              \
	(((x) & BIT_MASK_WLON_MBIST_DONE_V1) << BIT_SHIFT_WLON_MBIST_DONE_V1)
#define BITS_WLON_MBIST_DONE_V1                                                \
	(BIT_MASK_WLON_MBIST_DONE_V1 << BIT_SHIFT_WLON_MBIST_DONE_V1)
#define BIT_CLEAR_WLON_MBIST_DONE_V1(x) ((x) & (~BITS_WLON_MBIST_DONE_V1))
#define BIT_GET_WLON_MBIST_DONE_V1(x)                                          \
	(((x) >> BIT_SHIFT_WLON_MBIST_DONE_V1) & BIT_MASK_WLON_MBIST_DONE_V1)
#define BIT_SET_WLON_MBIST_DONE_V1(x, v)                                       \
	(BIT_CLEAR_WLON_MBIST_DONE_V1(x) | BIT_WLON_MBIST_DONE_V1(v))

#define BIT_SHIFT_WLOFF_MBIST_DONE_V1 4
#define BIT_MASK_WLOFF_MBIST_DONE_V1 0x1f
#define BIT_WLOFF_MBIST_DONE_V1(x)                                             \
	(((x) & BIT_MASK_WLOFF_MBIST_DONE_V1) << BIT_SHIFT_WLOFF_MBIST_DONE_V1)
#define BITS_WLOFF_MBIST_DONE_V1                                               \
	(BIT_MASK_WLOFF_MBIST_DONE_V1 << BIT_SHIFT_WLOFF_MBIST_DONE_V1)
#define BIT_CLEAR_WLOFF_MBIST_DONE_V1(x) ((x) & (~BITS_WLOFF_MBIST_DONE_V1))
#define BIT_GET_WLOFF_MBIST_DONE_V1(x)                                         \
	(((x) >> BIT_SHIFT_WLOFF_MBIST_DONE_V1) & BIT_MASK_WLOFF_MBIST_DONE_V1)
#define BIT_SET_WLOFF_MBIST_DONE_V1(x, v)                                      \
	(BIT_CLEAR_WLOFF_MBIST_DONE_V1(x) | BIT_WLOFF_MBIST_DONE_V1(v))

#define BIT_SHIFT_PCIE_MBIST_DONE_V2 2
#define BIT_MASK_PCIE_MBIST_DONE_V2 0x3
#define BIT_PCIE_MBIST_DONE_V2(x)                                              \
	(((x) & BIT_MASK_PCIE_MBIST_DONE_V2) << BIT_SHIFT_PCIE_MBIST_DONE_V2)
#define BITS_PCIE_MBIST_DONE_V2                                                \
	(BIT_MASK_PCIE_MBIST_DONE_V2 << BIT_SHIFT_PCIE_MBIST_DONE_V2)
#define BIT_CLEAR_PCIE_MBIST_DONE_V2(x) ((x) & (~BITS_PCIE_MBIST_DONE_V2))
#define BIT_GET_PCIE_MBIST_DONE_V2(x)                                          \
	(((x) >> BIT_SHIFT_PCIE_MBIST_DONE_V2) & BIT_MASK_PCIE_MBIST_DONE_V2)
#define BIT_SET_PCIE_MBIST_DONE_V2(x, v)                                       \
	(BIT_CLEAR_PCIE_MBIST_DONE_V2(x) | BIT_PCIE_MBIST_DONE_V2(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_MBIST_DONE				(Offset 0x0178) */

#define BIT_SHIFT_MAC_MBIST_DONE 0
#define BIT_MASK_MAC_MBIST_DONE 0xfff
#define BIT_MAC_MBIST_DONE(x)                                                  \
	(((x) & BIT_MASK_MAC_MBIST_DONE) << BIT_SHIFT_MAC_MBIST_DONE)
#define BITS_MAC_MBIST_DONE                                                    \
	(BIT_MASK_MAC_MBIST_DONE << BIT_SHIFT_MAC_MBIST_DONE)
#define BIT_CLEAR_MAC_MBIST_DONE(x) ((x) & (~BITS_MAC_MBIST_DONE))
#define BIT_GET_MAC_MBIST_DONE(x)                                              \
	(((x) >> BIT_SHIFT_MAC_MBIST_DONE) & BIT_MASK_MAC_MBIST_DONE)
#define BIT_SET_MAC_MBIST_DONE(x, v)                                           \
	(BIT_CLEAR_MAC_MBIST_DONE(x) | BIT_MAC_MBIST_DONE(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_MBIST_DONE				(Offset 0x0178) */

#define BIT_SHIFT_USB_MBIST_DONE_V2 0
#define BIT_MASK_USB_MBIST_DONE_V2 0x3
#define BIT_USB_MBIST_DONE_V2(x)                                               \
	(((x) & BIT_MASK_USB_MBIST_DONE_V2) << BIT_SHIFT_USB_MBIST_DONE_V2)
#define BITS_USB_MBIST_DONE_V2                                                 \
	(BIT_MASK_USB_MBIST_DONE_V2 << BIT_SHIFT_USB_MBIST_DONE_V2)
#define BIT_CLEAR_USB_MBIST_DONE_V2(x) ((x) & (~BITS_USB_MBIST_DONE_V2))
#define BIT_GET_USB_MBIST_DONE_V2(x)                                           \
	(((x) >> BIT_SHIFT_USB_MBIST_DONE_V2) & BIT_MASK_USB_MBIST_DONE_V2)
#define BIT_SET_USB_MBIST_DONE_V2(x, v)                                        \
	(BIT_CLEAR_USB_MBIST_DONE_V2(x) | BIT_USB_MBIST_DONE_V2(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_MBIST_DONE				(Offset 0x0178) */

#define BIT_SHIFT_MAC_MBIST_DONE_V1 0
#define BIT_MASK_MAC_MBIST_DONE_V1 0x3ffff
#define BIT_MAC_MBIST_DONE_V1(x)                                               \
	(((x) & BIT_MASK_MAC_MBIST_DONE_V1) << BIT_SHIFT_MAC_MBIST_DONE_V1)
#define BITS_MAC_MBIST_DONE_V1                                                 \
	(BIT_MASK_MAC_MBIST_DONE_V1 << BIT_SHIFT_MAC_MBIST_DONE_V1)
#define BIT_CLEAR_MAC_MBIST_DONE_V1(x) ((x) & (~BITS_MAC_MBIST_DONE_V1))
#define BIT_GET_MAC_MBIST_DONE_V1(x)                                           \
	(((x) >> BIT_SHIFT_MAC_MBIST_DONE_V1) & BIT_MASK_MAC_MBIST_DONE_V1)
#define BIT_SET_MAC_MBIST_DONE_V1(x, v)                                        \
	(BIT_CLEAR_MAC_MBIST_DONE_V1(x) | BIT_MAC_MBIST_DONE_V1(v))

#endif

#if (HALMAC_8197G_SUPPORT)

/* 2 REG_MBIST_DONE				(Offset 0x0178) */

#define BIT_SHIFT_MAC_MBIST_DONE_V2 0
#define BIT_MASK_MAC_MBIST_DONE_V2 0x1ff
#define BIT_MAC_MBIST_DONE_V2(x)                                               \
	(((x) & BIT_MASK_MAC_MBIST_DONE_V2) << BIT_SHIFT_MAC_MBIST_DONE_V2)
#define BITS_MAC_MBIST_DONE_V2                                                 \
	(BIT_MASK_MAC_MBIST_DONE_V2 << BIT_SHIFT_MAC_MBIST_DONE_V2)
#define BIT_CLEAR_MAC_MBIST_DONE_V2(x) ((x) & (~BITS_MAC_MBIST_DONE_V2))
#define BIT_GET_MAC_MBIST_DONE_V2(x)                                           \
	(((x) >> BIT_SHIFT_MAC_MBIST_DONE_V2) & BIT_MASK_MAC_MBIST_DONE_V2)
#define BIT_SET_MAC_MBIST_DONE_V2(x, v)                                        \
	(BIT_CLEAR_MAC_MBIST_DONE_V2(x) | BIT_MAC_MBIST_DONE_V2(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_MBIST_NRML_FAIL			(Offset 0x017C) */

#define BIT_SHIFT_WLON_MBIST_NRML_FAIL 30
#define BIT_MASK_WLON_MBIST_NRML_FAIL 0x3
#define BIT_WLON_MBIST_NRML_FAIL(x)                                            \
	(((x) & BIT_MASK_WLON_MBIST_NRML_FAIL)                                 \
	 << BIT_SHIFT_WLON_MBIST_NRML_FAIL)
#define BITS_WLON_MBIST_NRML_FAIL                                              \
	(BIT_MASK_WLON_MBIST_NRML_FAIL << BIT_SHIFT_WLON_MBIST_NRML_FAIL)
#define BIT_CLEAR_WLON_MBIST_NRML_FAIL(x) ((x) & (~BITS_WLON_MBIST_NRML_FAIL))
#define BIT_GET_WLON_MBIST_NRML_FAIL(x)                                        \
	(((x) >> BIT_SHIFT_WLON_MBIST_NRML_FAIL) &                             \
	 BIT_MASK_WLON_MBIST_NRML_FAIL)
#define BIT_SET_WLON_MBIST_NRML_FAIL(x, v)                                     \
	(BIT_CLEAR_WLON_MBIST_NRML_FAIL(x) | BIT_WLON_MBIST_NRML_FAIL(v))

#define BIT_SHIFT_WLOFF_MBIST_NRML_FAIL 16
#define BIT_MASK_WLOFF_MBIST_NRML_FAIL 0x3fff
#define BIT_WLOFF_MBIST_NRML_FAIL(x)                                           \
	(((x) & BIT_MASK_WLOFF_MBIST_NRML_FAIL)                                \
	 << BIT_SHIFT_WLOFF_MBIST_NRML_FAIL)
#define BITS_WLOFF_MBIST_NRML_FAIL                                             \
	(BIT_MASK_WLOFF_MBIST_NRML_FAIL << BIT_SHIFT_WLOFF_MBIST_NRML_FAIL)
#define BIT_CLEAR_WLOFF_MBIST_NRML_FAIL(x) ((x) & (~BITS_WLOFF_MBIST_NRML_FAIL))
#define BIT_GET_WLOFF_MBIST_NRML_FAIL(x)                                       \
	(((x) >> BIT_SHIFT_WLOFF_MBIST_NRML_FAIL) &                            \
	 BIT_MASK_WLOFF_MBIST_NRML_FAIL)
#define BIT_SET_WLOFF_MBIST_NRML_FAIL(x, v)                                    \
	(BIT_CLEAR_WLOFF_MBIST_NRML_FAIL(x) | BIT_WLOFF_MBIST_NRML_FAIL(v))

#define BIT_SHIFT_PCIE_MBIST_NRML_FAIL 11
#define BIT_MASK_PCIE_MBIST_NRML_FAIL 0x1f
#define BIT_PCIE_MBIST_NRML_FAIL(x)                                            \
	(((x) & BIT_MASK_PCIE_MBIST_NRML_FAIL)                                 \
	 << BIT_SHIFT_PCIE_MBIST_NRML_FAIL)
#define BITS_PCIE_MBIST_NRML_FAIL                                              \
	(BIT_MASK_PCIE_MBIST_NRML_FAIL << BIT_SHIFT_PCIE_MBIST_NRML_FAIL)
#define BIT_CLEAR_PCIE_MBIST_NRML_FAIL(x) ((x) & (~BITS_PCIE_MBIST_NRML_FAIL))
#define BIT_GET_PCIE_MBIST_NRML_FAIL(x)                                        \
	(((x) >> BIT_SHIFT_PCIE_MBIST_NRML_FAIL) &                             \
	 BIT_MASK_PCIE_MBIST_NRML_FAIL)
#define BIT_SET_PCIE_MBIST_NRML_FAIL(x, v)                                     \
	(BIT_CLEAR_PCIE_MBIST_NRML_FAIL(x) | BIT_PCIE_MBIST_NRML_FAIL(v))

#define BIT_SHIFT_USB_MBIST_NRML_FAIL 4
#define BIT_MASK_USB_MBIST_NRML_FAIL 0x7f
#define BIT_USB_MBIST_NRML_FAIL(x)                                             \
	(((x) & BIT_MASK_USB_MBIST_NRML_FAIL) << BIT_SHIFT_USB_MBIST_NRML_FAIL)
#define BITS_USB_MBIST_NRML_FAIL                                               \
	(BIT_MASK_USB_MBIST_NRML_FAIL << BIT_SHIFT_USB_MBIST_NRML_FAIL)
#define BIT_CLEAR_USB_MBIST_NRML_FAIL(x) ((x) & (~BITS_USB_MBIST_NRML_FAIL))
#define BIT_GET_USB_MBIST_NRML_FAIL(x)                                         \
	(((x) >> BIT_SHIFT_USB_MBIST_NRML_FAIL) & BIT_MASK_USB_MBIST_NRML_FAIL)
#define BIT_SET_USB_MBIST_NRML_FAIL(x, v)                                      \
	(BIT_CLEAR_USB_MBIST_NRML_FAIL(x) | BIT_USB_MBIST_NRML_FAIL(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_MBIST_ROM_CRC_DATA			(Offset 0x017C) */

#define BIT_SHIFT_MBIST_ROM_CRC_DATA 0
#define BIT_MASK_MBIST_ROM_CRC_DATA 0xffffffffL
#define BIT_MBIST_ROM_CRC_DATA(x)                                              \
	(((x) & BIT_MASK_MBIST_ROM_CRC_DATA) << BIT_SHIFT_MBIST_ROM_CRC_DATA)
#define BITS_MBIST_ROM_CRC_DATA                                                \
	(BIT_MASK_MBIST_ROM_CRC_DATA << BIT_SHIFT_MBIST_ROM_CRC_DATA)
#define BIT_CLEAR_MBIST_ROM_CRC_DATA(x) ((x) & (~BITS_MBIST_ROM_CRC_DATA))
#define BIT_GET_MBIST_ROM_CRC_DATA(x)                                          \
	(((x) >> BIT_SHIFT_MBIST_ROM_CRC_DATA) & BIT_MASK_MBIST_ROM_CRC_DATA)
#define BIT_SET_MBIST_ROM_CRC_DATA(x, v)                                       \
	(BIT_CLEAR_MBIST_ROM_CRC_DATA(x) | BIT_MBIST_ROM_CRC_DATA(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_MBIST_NRML_FAIL			(Offset 0x017C) */

#define BIT_SHIFT_USB_WLON_MBIST_NRML_FAIL 0
#define BIT_MASK_USB_WLON_MBIST_NRML_FAIL 0xf
#define BIT_USB_WLON_MBIST_NRML_FAIL(x)                                        \
	(((x) & BIT_MASK_USB_WLON_MBIST_NRML_FAIL)                             \
	 << BIT_SHIFT_USB_WLON_MBIST_NRML_FAIL)
#define BITS_USB_WLON_MBIST_NRML_FAIL                                          \
	(BIT_MASK_USB_WLON_MBIST_NRML_FAIL                                     \
	 << BIT_SHIFT_USB_WLON_MBIST_NRML_FAIL)
#define BIT_CLEAR_USB_WLON_MBIST_NRML_FAIL(x)                                  \
	((x) & (~BITS_USB_WLON_MBIST_NRML_FAIL))
#define BIT_GET_USB_WLON_MBIST_NRML_FAIL(x)                                    \
	(((x) >> BIT_SHIFT_USB_WLON_MBIST_NRML_FAIL) &                         \
	 BIT_MASK_USB_WLON_MBIST_NRML_FAIL)
#define BIT_SET_USB_WLON_MBIST_NRML_FAIL(x, v)                                 \
	(BIT_CLEAR_USB_WLON_MBIST_NRML_FAIL(x) |                               \
	 BIT_USB_WLON_MBIST_NRML_FAIL(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_MBIST_FAIL_NRML			(Offset 0x017C) */

#define BIT_SHIFT_MBIST_FAIL_NRML_V1 0
#define BIT_MASK_MBIST_FAIL_NRML_V1 0x3ffff
#define BIT_MBIST_FAIL_NRML_V1(x)                                              \
	(((x) & BIT_MASK_MBIST_FAIL_NRML_V1) << BIT_SHIFT_MBIST_FAIL_NRML_V1)
#define BITS_MBIST_FAIL_NRML_V1                                                \
	(BIT_MASK_MBIST_FAIL_NRML_V1 << BIT_SHIFT_MBIST_FAIL_NRML_V1)
#define BIT_CLEAR_MBIST_FAIL_NRML_V1(x) ((x) & (~BITS_MBIST_FAIL_NRML_V1))
#define BIT_GET_MBIST_FAIL_NRML_V1(x)                                          \
	(((x) >> BIT_SHIFT_MBIST_FAIL_NRML_V1) & BIT_MASK_MBIST_FAIL_NRML_V1)
#define BIT_SET_MBIST_FAIL_NRML_V1(x, v)                                       \
	(BIT_CLEAR_MBIST_FAIL_NRML_V1(x) | BIT_MBIST_FAIL_NRML_V1(v))

#endif

#if (HALMAC_8197G_SUPPORT)

/* 2 REG_MBIST_FAIL_NRML			(Offset 0x017C) */

#define BIT_SHIFT_MBIST_FAIL_NRML_V2 0
#define BIT_MASK_MBIST_FAIL_NRML_V2 0x7ffff
#define BIT_MBIST_FAIL_NRML_V2(x)                                              \
	(((x) & BIT_MASK_MBIST_FAIL_NRML_V2) << BIT_SHIFT_MBIST_FAIL_NRML_V2)
#define BITS_MBIST_FAIL_NRML_V2                                                \
	(BIT_MASK_MBIST_FAIL_NRML_V2 << BIT_SHIFT_MBIST_FAIL_NRML_V2)
#define BIT_CLEAR_MBIST_FAIL_NRML_V2(x) ((x) & (~BITS_MBIST_FAIL_NRML_V2))
#define BIT_GET_MBIST_FAIL_NRML_V2(x)                                          \
	(((x) >> BIT_SHIFT_MBIST_FAIL_NRML_V2) & BIT_MASK_MBIST_FAIL_NRML_V2)
#define BIT_SET_MBIST_FAIL_NRML_V2(x, v)                                       \
	(BIT_CLEAR_MBIST_FAIL_NRML_V2(x) | BIT_MBIST_FAIL_NRML_V2(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_MBIST_FAIL_NRML			(Offset 0x017C) */

#define BIT_SHIFT_MBIST_FAIL_NRML 0
#define BIT_MASK_MBIST_FAIL_NRML 0xffffffffL
#define BIT_MBIST_FAIL_NRML(x)                                                 \
	(((x) & BIT_MASK_MBIST_FAIL_NRML) << BIT_SHIFT_MBIST_FAIL_NRML)
#define BITS_MBIST_FAIL_NRML                                                   \
	(BIT_MASK_MBIST_FAIL_NRML << BIT_SHIFT_MBIST_FAIL_NRML)
#define BIT_CLEAR_MBIST_FAIL_NRML(x) ((x) & (~BITS_MBIST_FAIL_NRML))
#define BIT_GET_MBIST_FAIL_NRML(x)                                             \
	(((x) >> BIT_SHIFT_MBIST_FAIL_NRML) & BIT_MASK_MBIST_FAIL_NRML)
#define BIT_SET_MBIST_FAIL_NRML(x, v)                                          \
	(BIT_CLEAR_MBIST_FAIL_NRML(x) | BIT_MBIST_FAIL_NRML(v))

#define BIT_SHIFT_R_WMAC_IPV6_MYIPAD 0
#define BIT_MASK_R_WMAC_IPV6_MYIPAD 0xffffffffffffffffffffffffffffffffL
#define BIT_R_WMAC_IPV6_MYIPAD(x)                                              \
	(((x) & BIT_MASK_R_WMAC_IPV6_MYIPAD) << BIT_SHIFT_R_WMAC_IPV6_MYIPAD)
#define BITS_R_WMAC_IPV6_MYIPAD                                                \
	(BIT_MASK_R_WMAC_IPV6_MYIPAD << BIT_SHIFT_R_WMAC_IPV6_MYIPAD)
#define BIT_CLEAR_R_WMAC_IPV6_MYIPAD(x) ((x) & (~BITS_R_WMAC_IPV6_MYIPAD))
#define BIT_GET_R_WMAC_IPV6_MYIPAD(x)                                          \
	(((x) >> BIT_SHIFT_R_WMAC_IPV6_MYIPAD) & BIT_MASK_R_WMAC_IPV6_MYIPAD)
#define BIT_SET_R_WMAC_IPV6_MYIPAD(x, v)                                       \
	(BIT_CLEAR_R_WMAC_IPV6_MYIPAD(x) | BIT_R_WMAC_IPV6_MYIPAD(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_AES_DECRPT_DATA			(Offset 0x0180) */

#define BIT_SHIFT_IPS_CFG_ADDR 0
#define BIT_MASK_IPS_CFG_ADDR 0xff
#define BIT_IPS_CFG_ADDR(x)                                                    \
	(((x) & BIT_MASK_IPS_CFG_ADDR) << BIT_SHIFT_IPS_CFG_ADDR)
#define BITS_IPS_CFG_ADDR (BIT_MASK_IPS_CFG_ADDR << BIT_SHIFT_IPS_CFG_ADDR)
#define BIT_CLEAR_IPS_CFG_ADDR(x) ((x) & (~BITS_IPS_CFG_ADDR))
#define BIT_GET_IPS_CFG_ADDR(x)                                                \
	(((x) >> BIT_SHIFT_IPS_CFG_ADDR) & BIT_MASK_IPS_CFG_ADDR)
#define BIT_SET_IPS_CFG_ADDR(x, v)                                             \
	(BIT_CLEAR_IPS_CFG_ADDR(x) | BIT_IPS_CFG_ADDR(v))

/* 2 REG_AES_DECRPT_CFG			(Offset 0x0184) */

#define BIT_SHIFT_IPS_CFG_DATA 0
#define BIT_MASK_IPS_CFG_DATA 0xffffffffL
#define BIT_IPS_CFG_DATA(x)                                                    \
	(((x) & BIT_MASK_IPS_CFG_DATA) << BIT_SHIFT_IPS_CFG_DATA)
#define BITS_IPS_CFG_DATA (BIT_MASK_IPS_CFG_DATA << BIT_SHIFT_IPS_CFG_DATA)
#define BIT_CLEAR_IPS_CFG_DATA(x) ((x) & (~BITS_IPS_CFG_DATA))
#define BIT_GET_IPS_CFG_DATA(x)                                                \
	(((x) >> BIT_SHIFT_IPS_CFG_DATA) & BIT_MASK_IPS_CFG_DATA)
#define BIT_SET_IPS_CFG_DATA(x, v)                                             \
	(BIT_CLEAR_IPS_CFG_DATA(x) | BIT_IPS_CFG_DATA(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_HIOE_CTRL				(Offset 0x0188) */

#define BIT_HIOE_CFG_FILE_LOC_SEL BIT(31)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_HIOE_CTRL				(Offset 0x0188) */

#define BIT_HIOE_WRITE_REQ BIT(30)
#define BIT_HIOE_READ_REQ BIT(29)
#define BIT_INST_FORMAT_ERR BIT(25)
#define BIT_OP_TIMEOUT_ERR BIT(24)

#define BIT_SHIFT_HIOE_OP_TIMEOUT 16
#define BIT_MASK_HIOE_OP_TIMEOUT 0xff
#define BIT_HIOE_OP_TIMEOUT(x)                                                 \
	(((x) & BIT_MASK_HIOE_OP_TIMEOUT) << BIT_SHIFT_HIOE_OP_TIMEOUT)
#define BITS_HIOE_OP_TIMEOUT                                                   \
	(BIT_MASK_HIOE_OP_TIMEOUT << BIT_SHIFT_HIOE_OP_TIMEOUT)
#define BIT_CLEAR_HIOE_OP_TIMEOUT(x) ((x) & (~BITS_HIOE_OP_TIMEOUT))
#define BIT_GET_HIOE_OP_TIMEOUT(x)                                             \
	(((x) >> BIT_SHIFT_HIOE_OP_TIMEOUT) & BIT_MASK_HIOE_OP_TIMEOUT)
#define BIT_SET_HIOE_OP_TIMEOUT(x, v)                                          \
	(BIT_CLEAR_HIOE_OP_TIMEOUT(x) | BIT_HIOE_OP_TIMEOUT(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_MBIST_READ_BIST_RPT_V1		(Offset 0x0188) */

#define BIT_SHIFT_MBIST_READ_BIST_RPT 0
#define BIT_MASK_MBIST_READ_BIST_RPT 0xffffffffL
#define BIT_MBIST_READ_BIST_RPT(x)                                             \
	(((x) & BIT_MASK_MBIST_READ_BIST_RPT) << BIT_SHIFT_MBIST_READ_BIST_RPT)
#define BITS_MBIST_READ_BIST_RPT                                               \
	(BIT_MASK_MBIST_READ_BIST_RPT << BIT_SHIFT_MBIST_READ_BIST_RPT)
#define BIT_CLEAR_MBIST_READ_BIST_RPT(x) ((x) & (~BITS_MBIST_READ_BIST_RPT))
#define BIT_GET_MBIST_READ_BIST_RPT(x)                                         \
	(((x) >> BIT_SHIFT_MBIST_READ_BIST_RPT) & BIT_MASK_MBIST_READ_BIST_RPT)
#define BIT_SET_MBIST_READ_BIST_RPT(x, v)                                      \
	(BIT_CLEAR_MBIST_READ_BIST_RPT(x) | BIT_MBIST_READ_BIST_RPT(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_HIOE_CTRL				(Offset 0x0188) */

#define BIT_SHIFT_BITDATA_CHECKSUM 0
#define BIT_MASK_BITDATA_CHECKSUM 0xffff
#define BIT_BITDATA_CHECKSUM(x)                                                \
	(((x) & BIT_MASK_BITDATA_CHECKSUM) << BIT_SHIFT_BITDATA_CHECKSUM)
#define BITS_BITDATA_CHECKSUM                                                  \
	(BIT_MASK_BITDATA_CHECKSUM << BIT_SHIFT_BITDATA_CHECKSUM)
#define BIT_CLEAR_BITDATA_CHECKSUM(x) ((x) & (~BITS_BITDATA_CHECKSUM))
#define BIT_GET_BITDATA_CHECKSUM(x)                                            \
	(((x) >> BIT_SHIFT_BITDATA_CHECKSUM) & BIT_MASK_BITDATA_CHECKSUM)
#define BIT_SET_BITDATA_CHECKSUM(x, v)                                         \
	(BIT_CLEAR_BITDATA_CHECKSUM(x) | BIT_BITDATA_CHECKSUM(v))

/* 2 REG_HIOE_CFG_FILE			(Offset 0x018C) */

#define BIT_SHIFT_TXBF_END_ADDR 16
#define BIT_MASK_TXBF_END_ADDR 0xffff
#define BIT_TXBF_END_ADDR(x)                                                   \
	(((x) & BIT_MASK_TXBF_END_ADDR) << BIT_SHIFT_TXBF_END_ADDR)
#define BITS_TXBF_END_ADDR (BIT_MASK_TXBF_END_ADDR << BIT_SHIFT_TXBF_END_ADDR)
#define BIT_CLEAR_TXBF_END_ADDR(x) ((x) & (~BITS_TXBF_END_ADDR))
#define BIT_GET_TXBF_END_ADDR(x)                                               \
	(((x) >> BIT_SHIFT_TXBF_END_ADDR) & BIT_MASK_TXBF_END_ADDR)
#define BIT_SET_TXBF_END_ADDR(x, v)                                            \
	(BIT_CLEAR_TXBF_END_ADDR(x) | BIT_TXBF_END_ADDR(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT)

/* 2 REG_MACCLKFRQ				(Offset 0x018C) */

#define BIT_SHIFT_MACCLK_FREQ_LOW32 0
#define BIT_MASK_MACCLK_FREQ_LOW32 0xffffffffL
#define BIT_MACCLK_FREQ_LOW32(x)                                               \
	(((x) & BIT_MASK_MACCLK_FREQ_LOW32) << BIT_SHIFT_MACCLK_FREQ_LOW32)
#define BITS_MACCLK_FREQ_LOW32                                                 \
	(BIT_MASK_MACCLK_FREQ_LOW32 << BIT_SHIFT_MACCLK_FREQ_LOW32)
#define BIT_CLEAR_MACCLK_FREQ_LOW32(x) ((x) & (~BITS_MACCLK_FREQ_LOW32))
#define BIT_GET_MACCLK_FREQ_LOW32(x)                                           \
	(((x) >> BIT_SHIFT_MACCLK_FREQ_LOW32) & BIT_MASK_MACCLK_FREQ_LOW32)
#define BIT_SET_MACCLK_FREQ_LOW32(x, v)                                        \
	(BIT_CLEAR_MACCLK_FREQ_LOW32(x) | BIT_MACCLK_FREQ_LOW32(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_HIOE_CFG_FILE			(Offset 0x018C) */

#define BIT_SHIFT_TXBF_STR_ADDR 0
#define BIT_MASK_TXBF_STR_ADDR 0xffff
#define BIT_TXBF_STR_ADDR(x)                                                   \
	(((x) & BIT_MASK_TXBF_STR_ADDR) << BIT_SHIFT_TXBF_STR_ADDR)
#define BITS_TXBF_STR_ADDR (BIT_MASK_TXBF_STR_ADDR << BIT_SHIFT_TXBF_STR_ADDR)
#define BIT_CLEAR_TXBF_STR_ADDR(x) ((x) & (~BITS_TXBF_STR_ADDR))
#define BIT_GET_TXBF_STR_ADDR(x)                                               \
	(((x) >> BIT_SHIFT_TXBF_STR_ADDR) & BIT_MASK_TXBF_STR_ADDR)
#define BIT_SET_TXBF_STR_ADDR(x, v)                                            \
	(BIT_CLEAR_TXBF_STR_ADDR(x) | BIT_TXBF_STR_ADDR(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_TMETER				(Offset 0x0190) */

#define BIT_TEMP_VALID BIT(31)

#define BIT_SHIFT_TEMP_VALUE 24
#define BIT_MASK_TEMP_VALUE 0x3f
#define BIT_TEMP_VALUE(x) (((x) & BIT_MASK_TEMP_VALUE) << BIT_SHIFT_TEMP_VALUE)
#define BITS_TEMP_VALUE (BIT_MASK_TEMP_VALUE << BIT_SHIFT_TEMP_VALUE)
#define BIT_CLEAR_TEMP_VALUE(x) ((x) & (~BITS_TEMP_VALUE))
#define BIT_GET_TEMP_VALUE(x)                                                  \
	(((x) >> BIT_SHIFT_TEMP_VALUE) & BIT_MASK_TEMP_VALUE)
#define BIT_SET_TEMP_VALUE(x, v) (BIT_CLEAR_TEMP_VALUE(x) | BIT_TEMP_VALUE(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_TMETER				(Offset 0x0190) */

#define BIT_SHIFT_NCO_OUTCLK_FREQ 12
#define BIT_MASK_NCO_OUTCLK_FREQ 0xfffff
#define BIT_NCO_OUTCLK_FREQ(x)                                                 \
	(((x) & BIT_MASK_NCO_OUTCLK_FREQ) << BIT_SHIFT_NCO_OUTCLK_FREQ)
#define BITS_NCO_OUTCLK_FREQ                                                   \
	(BIT_MASK_NCO_OUTCLK_FREQ << BIT_SHIFT_NCO_OUTCLK_FREQ)
#define BIT_CLEAR_NCO_OUTCLK_FREQ(x) ((x) & (~BITS_NCO_OUTCLK_FREQ))
#define BIT_GET_NCO_OUTCLK_FREQ(x)                                             \
	(((x) >> BIT_SHIFT_NCO_OUTCLK_FREQ) & BIT_MASK_NCO_OUTCLK_FREQ)
#define BIT_SET_NCO_OUTCLK_FREQ(x, v)                                          \
	(BIT_CLEAR_NCO_OUTCLK_FREQ(x) | BIT_NCO_OUTCLK_FREQ(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_TMETER				(Offset 0x0190) */

#define BIT_SHIFT_REG_TMETER_TIMER 8
#define BIT_MASK_REG_TMETER_TIMER 0xfff
#define BIT_REG_TMETER_TIMER(x)                                                \
	(((x) & BIT_MASK_REG_TMETER_TIMER) << BIT_SHIFT_REG_TMETER_TIMER)
#define BITS_REG_TMETER_TIMER                                                  \
	(BIT_MASK_REG_TMETER_TIMER << BIT_SHIFT_REG_TMETER_TIMER)
#define BIT_CLEAR_REG_TMETER_TIMER(x) ((x) & (~BITS_REG_TMETER_TIMER))
#define BIT_GET_REG_TMETER_TIMER(x)                                            \
	(((x) >> BIT_SHIFT_REG_TMETER_TIMER) & BIT_MASK_REG_TMETER_TIMER)
#define BIT_SET_REG_TMETER_TIMER(x, v)                                         \
	(BIT_CLEAR_REG_TMETER_TIMER(x) | BIT_REG_TMETER_TIMER(v))

#define BIT_SHIFT_REG_TEMP_DELTA 2
#define BIT_MASK_REG_TEMP_DELTA 0x3f
#define BIT_REG_TEMP_DELTA(x)                                                  \
	(((x) & BIT_MASK_REG_TEMP_DELTA) << BIT_SHIFT_REG_TEMP_DELTA)
#define BITS_REG_TEMP_DELTA                                                    \
	(BIT_MASK_REG_TEMP_DELTA << BIT_SHIFT_REG_TEMP_DELTA)
#define BIT_CLEAR_REG_TEMP_DELTA(x) ((x) & (~BITS_REG_TEMP_DELTA))
#define BIT_GET_REG_TEMP_DELTA(x)                                              \
	(((x) >> BIT_SHIFT_REG_TEMP_DELTA) & BIT_MASK_REG_TEMP_DELTA)
#define BIT_SET_REG_TEMP_DELTA(x, v)                                           \
	(BIT_CLEAR_REG_TEMP_DELTA(x) | BIT_REG_TEMP_DELTA(v))

#define BIT_REG_TMETER_EN BIT(0)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT)

/* 2 REG_TMETER				(Offset 0x0190) */

#define BIT_SHIFT_MACCLK_FREQ_HIGH10 0
#define BIT_MASK_MACCLK_FREQ_HIGH10 0x3ff
#define BIT_MACCLK_FREQ_HIGH10(x)                                              \
	(((x) & BIT_MASK_MACCLK_FREQ_HIGH10) << BIT_SHIFT_MACCLK_FREQ_HIGH10)
#define BITS_MACCLK_FREQ_HIGH10                                                \
	(BIT_MASK_MACCLK_FREQ_HIGH10 << BIT_SHIFT_MACCLK_FREQ_HIGH10)
#define BIT_CLEAR_MACCLK_FREQ_HIGH10(x) ((x) & (~BITS_MACCLK_FREQ_HIGH10))
#define BIT_GET_MACCLK_FREQ_HIGH10(x)                                          \
	(((x) >> BIT_SHIFT_MACCLK_FREQ_HIGH10) & BIT_MASK_MACCLK_FREQ_HIGH10)
#define BIT_SET_MACCLK_FREQ_HIGH10(x, v)                                       \
	(BIT_CLEAR_MACCLK_FREQ_HIGH10(x) | BIT_MACCLK_FREQ_HIGH10(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_OSC_32K_CTRL			(Offset 0x0194) */

#define BIT_SHIFT_OSC_32K_CLKGEN_0 16
#define BIT_MASK_OSC_32K_CLKGEN_0 0xffff
#define BIT_OSC_32K_CLKGEN_0(x)                                                \
	(((x) & BIT_MASK_OSC_32K_CLKGEN_0) << BIT_SHIFT_OSC_32K_CLKGEN_0)
#define BITS_OSC_32K_CLKGEN_0                                                  \
	(BIT_MASK_OSC_32K_CLKGEN_0 << BIT_SHIFT_OSC_32K_CLKGEN_0)
#define BIT_CLEAR_OSC_32K_CLKGEN_0(x) ((x) & (~BITS_OSC_32K_CLKGEN_0))
#define BIT_GET_OSC_32K_CLKGEN_0(x)                                            \
	(((x) >> BIT_SHIFT_OSC_32K_CLKGEN_0) & BIT_MASK_OSC_32K_CLKGEN_0)
#define BIT_SET_OSC_32K_CLKGEN_0(x, v)                                         \
	(BIT_CLEAR_OSC_32K_CLKGEN_0(x) | BIT_OSC_32K_CLKGEN_0(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT)

/* 2 REG_OSC_32K_CTRL			(Offset 0x0194) */

#define BIT_32K_CLK_OUT_RDY BIT(12)

#define BIT_SHIFT_MONITOR_CYCLE_LOG2 8
#define BIT_MASK_MONITOR_CYCLE_LOG2 0xf
#define BIT_MONITOR_CYCLE_LOG2(x)                                              \
	(((x) & BIT_MASK_MONITOR_CYCLE_LOG2) << BIT_SHIFT_MONITOR_CYCLE_LOG2)
#define BITS_MONITOR_CYCLE_LOG2                                                \
	(BIT_MASK_MONITOR_CYCLE_LOG2 << BIT_SHIFT_MONITOR_CYCLE_LOG2)
#define BIT_CLEAR_MONITOR_CYCLE_LOG2(x) ((x) & (~BITS_MONITOR_CYCLE_LOG2))
#define BIT_GET_MONITOR_CYCLE_LOG2(x)                                          \
	(((x) >> BIT_SHIFT_MONITOR_CYCLE_LOG2) & BIT_MASK_MONITOR_CYCLE_LOG2)
#define BIT_SET_MONITOR_CYCLE_LOG2(x, v)                                       \
	(BIT_CLEAR_MONITOR_CYCLE_LOG2(x) | BIT_MONITOR_CYCLE_LOG2(v))

#define BIT_SHIFT_FREQVALUE_UNREGCLK 8
#define BIT_MASK_FREQVALUE_UNREGCLK 0xffffff
#define BIT_FREQVALUE_UNREGCLK(x)                                              \
	(((x) & BIT_MASK_FREQVALUE_UNREGCLK) << BIT_SHIFT_FREQVALUE_UNREGCLK)
#define BITS_FREQVALUE_UNREGCLK                                                \
	(BIT_MASK_FREQVALUE_UNREGCLK << BIT_SHIFT_FREQVALUE_UNREGCLK)
#define BIT_CLEAR_FREQVALUE_UNREGCLK(x) ((x) & (~BITS_FREQVALUE_UNREGCLK))
#define BIT_GET_FREQVALUE_UNREGCLK(x)                                          \
	(((x) >> BIT_SHIFT_FREQVALUE_UNREGCLK) & BIT_MASK_FREQVALUE_UNREGCLK)
#define BIT_SET_FREQVALUE_UNREGCLK(x, v)                                       \
	(BIT_CLEAR_FREQVALUE_UNREGCLK(x) | BIT_FREQVALUE_UNREGCLK(v))

#define BIT_CAL32K_DBGMOD BIT(7)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_OSC_32K_CTRL			(Offset 0x0194) */

#define BIT_SHIFT_OSC_32K_RES_COMP 4
#define BIT_MASK_OSC_32K_RES_COMP 0x3
#define BIT_OSC_32K_RES_COMP(x)                                                \
	(((x) & BIT_MASK_OSC_32K_RES_COMP) << BIT_SHIFT_OSC_32K_RES_COMP)
#define BITS_OSC_32K_RES_COMP                                                  \
	(BIT_MASK_OSC_32K_RES_COMP << BIT_SHIFT_OSC_32K_RES_COMP)
#define BIT_CLEAR_OSC_32K_RES_COMP(x) ((x) & (~BITS_OSC_32K_RES_COMP))
#define BIT_GET_OSC_32K_RES_COMP(x)                                            \
	(((x) >> BIT_SHIFT_OSC_32K_RES_COMP) & BIT_MASK_OSC_32K_RES_COMP)
#define BIT_SET_OSC_32K_RES_COMP(x, v)                                         \
	(BIT_CLEAR_OSC_32K_RES_COMP(x) | BIT_OSC_32K_RES_COMP(v))

#define BIT_OSC_32K_OUT_SEL BIT(3)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_OSC_32K_CTRL			(Offset 0x0194) */

#define BIT_ISO_WL_2_OSC_32K BIT(1)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_OSC_32K_CTRL			(Offset 0x0194) */

#define BIT_POW_CKGEN BIT(0)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT)

/* 2 REG_OSC_32K_CTRL			(Offset 0x0194) */

#define BIT_SHIFT_NCO_THRS 0
#define BIT_MASK_NCO_THRS 0x7f
#define BIT_NCO_THRS(x) (((x) & BIT_MASK_NCO_THRS) << BIT_SHIFT_NCO_THRS)
#define BITS_NCO_THRS (BIT_MASK_NCO_THRS << BIT_SHIFT_NCO_THRS)
#define BIT_CLEAR_NCO_THRS(x) ((x) & (~BITS_NCO_THRS))
#define BIT_GET_NCO_THRS(x) (((x) >> BIT_SHIFT_NCO_THRS) & BIT_MASK_NCO_THRS)
#define BIT_SET_NCO_THRS(x, v) (BIT_CLEAR_NCO_THRS(x) | BIT_NCO_THRS(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_32K_CAL_REG1			(Offset 0x0198) */

#define BIT_CAL_32K_REG_WR BIT(31)
#define BIT_CAL_32K_DBG_SEL BIT(22)

#define BIT_SHIFT_CAL_32K_REG_ADDR 16
#define BIT_MASK_CAL_32K_REG_ADDR 0x3f
#define BIT_CAL_32K_REG_ADDR(x)                                                \
	(((x) & BIT_MASK_CAL_32K_REG_ADDR) << BIT_SHIFT_CAL_32K_REG_ADDR)
#define BITS_CAL_32K_REG_ADDR                                                  \
	(BIT_MASK_CAL_32K_REG_ADDR << BIT_SHIFT_CAL_32K_REG_ADDR)
#define BIT_CLEAR_CAL_32K_REG_ADDR(x) ((x) & (~BITS_CAL_32K_REG_ADDR))
#define BIT_GET_CAL_32K_REG_ADDR(x)                                            \
	(((x) >> BIT_SHIFT_CAL_32K_REG_ADDR) & BIT_MASK_CAL_32K_REG_ADDR)
#define BIT_SET_CAL_32K_REG_ADDR(x, v)                                         \
	(BIT_CLEAR_CAL_32K_REG_ADDR(x) | BIT_CAL_32K_REG_ADDR(v))

#define BIT_SHIFT_CAL_32K_REG_DATA 0
#define BIT_MASK_CAL_32K_REG_DATA 0xffff
#define BIT_CAL_32K_REG_DATA(x)                                                \
	(((x) & BIT_MASK_CAL_32K_REG_DATA) << BIT_SHIFT_CAL_32K_REG_DATA)
#define BITS_CAL_32K_REG_DATA                                                  \
	(BIT_MASK_CAL_32K_REG_DATA << BIT_SHIFT_CAL_32K_REG_DATA)
#define BIT_CLEAR_CAL_32K_REG_DATA(x) ((x) & (~BITS_CAL_32K_REG_DATA))
#define BIT_GET_CAL_32K_REG_DATA(x)                                            \
	(((x) >> BIT_SHIFT_CAL_32K_REG_DATA) & BIT_MASK_CAL_32K_REG_DATA)
#define BIT_SET_CAL_32K_REG_DATA(x, v)                                         \
	(BIT_CLEAR_CAL_32K_REG_DATA(x) | BIT_CAL_32K_REG_DATA(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_C2HEVT				(Offset 0x01A0) */

#define BIT_SHIFT_C2HEVT_MSG 0
#define BIT_MASK_C2HEVT_MSG 0xffffffffffffffffffffffffffffffffL
#define BIT_C2HEVT_MSG(x) (((x) & BIT_MASK_C2HEVT_MSG) << BIT_SHIFT_C2HEVT_MSG)
#define BITS_C2HEVT_MSG (BIT_MASK_C2HEVT_MSG << BIT_SHIFT_C2HEVT_MSG)
#define BIT_CLEAR_C2HEVT_MSG(x) ((x) & (~BITS_C2HEVT_MSG))
#define BIT_GET_C2HEVT_MSG(x)                                                  \
	(((x) >> BIT_SHIFT_C2HEVT_MSG) & BIT_MASK_C2HEVT_MSG)
#define BIT_SET_C2HEVT_MSG(x, v) (BIT_CLEAR_C2HEVT_MSG(x) | BIT_C2HEVT_MSG(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_C2HEVT				(Offset 0x01A0) */

#define BIT_SHIFT_C2HEVT_MSG_V1 0
#define BIT_MASK_C2HEVT_MSG_V1 0xffffffffL
#define BIT_C2HEVT_MSG_V1(x)                                                   \
	(((x) & BIT_MASK_C2HEVT_MSG_V1) << BIT_SHIFT_C2HEVT_MSG_V1)
#define BITS_C2HEVT_MSG_V1 (BIT_MASK_C2HEVT_MSG_V1 << BIT_SHIFT_C2HEVT_MSG_V1)
#define BIT_CLEAR_C2HEVT_MSG_V1(x) ((x) & (~BITS_C2HEVT_MSG_V1))
#define BIT_GET_C2HEVT_MSG_V1(x)                                               \
	(((x) >> BIT_SHIFT_C2HEVT_MSG_V1) & BIT_MASK_C2HEVT_MSG_V1)
#define BIT_SET_C2HEVT_MSG_V1(x, v)                                            \
	(BIT_CLEAR_C2HEVT_MSG_V1(x) | BIT_C2HEVT_MSG_V1(v))

/* 2 REG_C2HEVT_1				(Offset 0x01A4) */

#define BIT_SHIFT_C2HEVT_MSG_1 0
#define BIT_MASK_C2HEVT_MSG_1 0xffffffffL
#define BIT_C2HEVT_MSG_1(x)                                                    \
	(((x) & BIT_MASK_C2HEVT_MSG_1) << BIT_SHIFT_C2HEVT_MSG_1)
#define BITS_C2HEVT_MSG_1 (BIT_MASK_C2HEVT_MSG_1 << BIT_SHIFT_C2HEVT_MSG_1)
#define BIT_CLEAR_C2HEVT_MSG_1(x) ((x) & (~BITS_C2HEVT_MSG_1))
#define BIT_GET_C2HEVT_MSG_1(x)                                                \
	(((x) >> BIT_SHIFT_C2HEVT_MSG_1) & BIT_MASK_C2HEVT_MSG_1)
#define BIT_SET_C2HEVT_MSG_1(x, v)                                             \
	(BIT_CLEAR_C2HEVT_MSG_1(x) | BIT_C2HEVT_MSG_1(v))

/* 2 REG_C2HEVT_2				(Offset 0x01A8) */

#define BIT_SHIFT_C2HEVT_MSG_2 0
#define BIT_MASK_C2HEVT_MSG_2 0xffffffffL
#define BIT_C2HEVT_MSG_2(x)                                                    \
	(((x) & BIT_MASK_C2HEVT_MSG_2) << BIT_SHIFT_C2HEVT_MSG_2)
#define BITS_C2HEVT_MSG_2 (BIT_MASK_C2HEVT_MSG_2 << BIT_SHIFT_C2HEVT_MSG_2)
#define BIT_CLEAR_C2HEVT_MSG_2(x) ((x) & (~BITS_C2HEVT_MSG_2))
#define BIT_GET_C2HEVT_MSG_2(x)                                                \
	(((x) >> BIT_SHIFT_C2HEVT_MSG_2) & BIT_MASK_C2HEVT_MSG_2)
#define BIT_SET_C2HEVT_MSG_2(x, v)                                             \
	(BIT_CLEAR_C2HEVT_MSG_2(x) | BIT_C2HEVT_MSG_2(v))

/* 2 REG_C2HEVT_3				(Offset 0x01AC) */

#define BIT_SHIFT_C2HEVT_MSG_3 0
#define BIT_MASK_C2HEVT_MSG_3 0xffffffffL
#define BIT_C2HEVT_MSG_3(x)                                                    \
	(((x) & BIT_MASK_C2HEVT_MSG_3) << BIT_SHIFT_C2HEVT_MSG_3)
#define BITS_C2HEVT_MSG_3 (BIT_MASK_C2HEVT_MSG_3 << BIT_SHIFT_C2HEVT_MSG_3)
#define BIT_CLEAR_C2HEVT_MSG_3(x) ((x) & (~BITS_C2HEVT_MSG_3))
#define BIT_GET_C2HEVT_MSG_3(x)                                                \
	(((x) >> BIT_SHIFT_C2HEVT_MSG_3) & BIT_MASK_C2HEVT_MSG_3)
#define BIT_SET_C2HEVT_MSG_3(x, v)                                             \
	(BIT_CLEAR_C2HEVT_MSG_3(x) | BIT_C2HEVT_MSG_3(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_MISC_CTRL_V1			(Offset 0x01B0) */

#define BIT_SHIFT_PHYWR_SETUP_CNT 28
#define BIT_MASK_PHYWR_SETUP_CNT 0xf
#define BIT_PHYWR_SETUP_CNT(x)                                                 \
	(((x) & BIT_MASK_PHYWR_SETUP_CNT) << BIT_SHIFT_PHYWR_SETUP_CNT)
#define BITS_PHYWR_SETUP_CNT                                                   \
	(BIT_MASK_PHYWR_SETUP_CNT << BIT_SHIFT_PHYWR_SETUP_CNT)
#define BIT_CLEAR_PHYWR_SETUP_CNT(x) ((x) & (~BITS_PHYWR_SETUP_CNT))
#define BIT_GET_PHYWR_SETUP_CNT(x)                                             \
	(((x) >> BIT_SHIFT_PHYWR_SETUP_CNT) & BIT_MASK_PHYWR_SETUP_CNT)
#define BIT_SET_PHYWR_SETUP_CNT(x, v)                                          \
	(BIT_CLEAR_PHYWR_SETUP_CNT(x) | BIT_PHYWR_SETUP_CNT(v))

#define BIT_SHIFT_PHYWR_HOLD_CNT 24
#define BIT_MASK_PHYWR_HOLD_CNT 0xf
#define BIT_PHYWR_HOLD_CNT(x)                                                  \
	(((x) & BIT_MASK_PHYWR_HOLD_CNT) << BIT_SHIFT_PHYWR_HOLD_CNT)
#define BITS_PHYWR_HOLD_CNT                                                    \
	(BIT_MASK_PHYWR_HOLD_CNT << BIT_SHIFT_PHYWR_HOLD_CNT)
#define BIT_CLEAR_PHYWR_HOLD_CNT(x) ((x) & (~BITS_PHYWR_HOLD_CNT))
#define BIT_GET_PHYWR_HOLD_CNT(x)                                              \
	(((x) >> BIT_SHIFT_PHYWR_HOLD_CNT) & BIT_MASK_PHYWR_HOLD_CNT)
#define BIT_SET_PHYWR_HOLD_CNT(x, v)                                           \
	(BIT_CLEAR_PHYWR_HOLD_CNT(x) | BIT_PHYWR_HOLD_CNT(v))

#define BIT_SHIFT_TXBUF_WKCAM_OFFSET 8
#define BIT_MASK_TXBUF_WKCAM_OFFSET 0x1fff
#define BIT_TXBUF_WKCAM_OFFSET(x)                                              \
	(((x) & BIT_MASK_TXBUF_WKCAM_OFFSET) << BIT_SHIFT_TXBUF_WKCAM_OFFSET)
#define BITS_TXBUF_WKCAM_OFFSET                                                \
	(BIT_MASK_TXBUF_WKCAM_OFFSET << BIT_SHIFT_TXBUF_WKCAM_OFFSET)
#define BIT_CLEAR_TXBUF_WKCAM_OFFSET(x) ((x) & (~BITS_TXBUF_WKCAM_OFFSET))
#define BIT_GET_TXBUF_WKCAM_OFFSET(x)                                          \
	(((x) >> BIT_SHIFT_TXBUF_WKCAM_OFFSET) & BIT_MASK_TXBUF_WKCAM_OFFSET)
#define BIT_SET_TXBUF_WKCAM_OFFSET(x, v)                                       \
	(BIT_CLEAR_TXBUF_WKCAM_OFFSET(x) | BIT_TXBUF_WKCAM_OFFSET(v))

#define BIT_SHIFT_PHYRD_WAIT_CNT 4
#define BIT_MASK_PHYRD_WAIT_CNT 0xf
#define BIT_PHYRD_WAIT_CNT(x)                                                  \
	(((x) & BIT_MASK_PHYRD_WAIT_CNT) << BIT_SHIFT_PHYRD_WAIT_CNT)
#define BITS_PHYRD_WAIT_CNT                                                    \
	(BIT_MASK_PHYRD_WAIT_CNT << BIT_SHIFT_PHYRD_WAIT_CNT)
#define BIT_CLEAR_PHYRD_WAIT_CNT(x) ((x) & (~BITS_PHYRD_WAIT_CNT))
#define BIT_GET_PHYRD_WAIT_CNT(x)                                              \
	(((x) >> BIT_SHIFT_PHYRD_WAIT_CNT) & BIT_MASK_PHYRD_WAIT_CNT)
#define BIT_SET_PHYRD_WAIT_CNT(x, v)                                           \
	(BIT_CLEAR_PHYRD_WAIT_CNT(x) | BIT_PHYRD_WAIT_CNT(v))

#define BIT_SHIFT_H2CQ_PRI 0
#define BIT_MASK_H2CQ_PRI 0x3
#define BIT_H2CQ_PRI(x) (((x) & BIT_MASK_H2CQ_PRI) << BIT_SHIFT_H2CQ_PRI)
#define BITS_H2CQ_PRI (BIT_MASK_H2CQ_PRI << BIT_SHIFT_H2CQ_PRI)
#define BIT_CLEAR_H2CQ_PRI(x) ((x) & (~BITS_H2CQ_PRI))
#define BIT_GET_H2CQ_PRI(x) (((x) >> BIT_SHIFT_H2CQ_PRI) & BIT_MASK_H2CQ_PRI)
#define BIT_SET_H2CQ_PRI(x, v) (BIT_CLEAR_H2CQ_PRI(x) | BIT_H2CQ_PRI(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_RXDESC_BUFF_RPTR			(Offset 0x01B0) */

#define BIT_SHIFT_RXDESC_BUFF_RPTR 0
#define BIT_MASK_RXDESC_BUFF_RPTR 0xffffffffL
#define BIT_RXDESC_BUFF_RPTR(x)                                                \
	(((x) & BIT_MASK_RXDESC_BUFF_RPTR) << BIT_SHIFT_RXDESC_BUFF_RPTR)
#define BITS_RXDESC_BUFF_RPTR                                                  \
	(BIT_MASK_RXDESC_BUFF_RPTR << BIT_SHIFT_RXDESC_BUFF_RPTR)
#define BIT_CLEAR_RXDESC_BUFF_RPTR(x) ((x) & (~BITS_RXDESC_BUFF_RPTR))
#define BIT_GET_RXDESC_BUFF_RPTR(x)                                            \
	(((x) >> BIT_SHIFT_RXDESC_BUFF_RPTR) & BIT_MASK_RXDESC_BUFF_RPTR)
#define BIT_SET_RXDESC_BUFF_RPTR(x, v)                                         \
	(BIT_CLEAR_RXDESC_BUFF_RPTR(x) | BIT_RXDESC_BUFF_RPTR(v))

/* 2 REG_RXDESC_BUFF_WPTR			(Offset 0x01B4) */

#define BIT_SHIFT_RXDESC_BUFF_WPTR 0
#define BIT_MASK_RXDESC_BUFF_WPTR 0xffffffffL
#define BIT_RXDESC_BUFF_WPTR(x)                                                \
	(((x) & BIT_MASK_RXDESC_BUFF_WPTR) << BIT_SHIFT_RXDESC_BUFF_WPTR)
#define BITS_RXDESC_BUFF_WPTR                                                  \
	(BIT_MASK_RXDESC_BUFF_WPTR << BIT_SHIFT_RXDESC_BUFF_WPTR)
#define BIT_CLEAR_RXDESC_BUFF_WPTR(x) ((x) & (~BITS_RXDESC_BUFF_WPTR))
#define BIT_GET_RXDESC_BUFF_WPTR(x)                                            \
	(((x) >> BIT_SHIFT_RXDESC_BUFF_WPTR) & BIT_MASK_RXDESC_BUFF_WPTR)
#define BIT_SET_RXDESC_BUFF_WPTR(x, v)                                         \
	(BIT_CLEAR_RXDESC_BUFF_WPTR(x) | BIT_RXDESC_BUFF_WPTR(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8822B_SUPPORT || \
     HALMAC_8881A_SUPPORT)

/* 2 REG_SW_DEFINED_PAGE1			(Offset 0x01B8) */

#define BIT_SHIFT_SW_DEFINED_PAGE1 0
#define BIT_MASK_SW_DEFINED_PAGE1 0xffffffffffffffffL
#define BIT_SW_DEFINED_PAGE1(x)                                                \
	(((x) & BIT_MASK_SW_DEFINED_PAGE1) << BIT_SHIFT_SW_DEFINED_PAGE1)
#define BITS_SW_DEFINED_PAGE1                                                  \
	(BIT_MASK_SW_DEFINED_PAGE1 << BIT_SHIFT_SW_DEFINED_PAGE1)
#define BIT_CLEAR_SW_DEFINED_PAGE1(x) ((x) & (~BITS_SW_DEFINED_PAGE1))
#define BIT_GET_SW_DEFINED_PAGE1(x)                                            \
	(((x) >> BIT_SHIFT_SW_DEFINED_PAGE1) & BIT_MASK_SW_DEFINED_PAGE1)
#define BIT_SET_SW_DEFINED_PAGE1(x, v)                                         \
	(BIT_CLEAR_SW_DEFINED_PAGE1(x) | BIT_SW_DEFINED_PAGE1(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_SW_DEFINED_PAGE1			(Offset 0x01B8) */

#define BIT_SHIFT_SW_DEFINED_PAGE1_V1 0
#define BIT_MASK_SW_DEFINED_PAGE1_V1 0xffffffffL
#define BIT_SW_DEFINED_PAGE1_V1(x)                                             \
	(((x) & BIT_MASK_SW_DEFINED_PAGE1_V1) << BIT_SHIFT_SW_DEFINED_PAGE1_V1)
#define BITS_SW_DEFINED_PAGE1_V1                                               \
	(BIT_MASK_SW_DEFINED_PAGE1_V1 << BIT_SHIFT_SW_DEFINED_PAGE1_V1)
#define BIT_CLEAR_SW_DEFINED_PAGE1_V1(x) ((x) & (~BITS_SW_DEFINED_PAGE1_V1))
#define BIT_GET_SW_DEFINED_PAGE1_V1(x)                                         \
	(((x) >> BIT_SHIFT_SW_DEFINED_PAGE1_V1) & BIT_MASK_SW_DEFINED_PAGE1_V1)
#define BIT_SET_SW_DEFINED_PAGE1_V1(x, v)                                      \
	(BIT_CLEAR_SW_DEFINED_PAGE1_V1(x) | BIT_SW_DEFINED_PAGE1_V1(v))

/* 2 REG_SW_DEFINED_PAGE2			(Offset 0x01BC) */

#define BIT_SHIFT_SW_DEFINED_PAGE2 0
#define BIT_MASK_SW_DEFINED_PAGE2 0xffffffffL
#define BIT_SW_DEFINED_PAGE2(x)                                                \
	(((x) & BIT_MASK_SW_DEFINED_PAGE2) << BIT_SHIFT_SW_DEFINED_PAGE2)
#define BITS_SW_DEFINED_PAGE2                                                  \
	(BIT_MASK_SW_DEFINED_PAGE2 << BIT_SHIFT_SW_DEFINED_PAGE2)
#define BIT_CLEAR_SW_DEFINED_PAGE2(x) ((x) & (~BITS_SW_DEFINED_PAGE2))
#define BIT_GET_SW_DEFINED_PAGE2(x)                                            \
	(((x) >> BIT_SHIFT_SW_DEFINED_PAGE2) & BIT_MASK_SW_DEFINED_PAGE2)
#define BIT_SET_SW_DEFINED_PAGE2(x, v)                                         \
	(BIT_CLEAR_SW_DEFINED_PAGE2(x) | BIT_SW_DEFINED_PAGE2(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_MCUTST_I				(Offset 0x01C0) */

#define BIT_SHIFT_MCUDMSG_I 0
#define BIT_MASK_MCUDMSG_I 0xffffffffL
#define BIT_MCUDMSG_I(x) (((x) & BIT_MASK_MCUDMSG_I) << BIT_SHIFT_MCUDMSG_I)
#define BITS_MCUDMSG_I (BIT_MASK_MCUDMSG_I << BIT_SHIFT_MCUDMSG_I)
#define BIT_CLEAR_MCUDMSG_I(x) ((x) & (~BITS_MCUDMSG_I))
#define BIT_GET_MCUDMSG_I(x) (((x) >> BIT_SHIFT_MCUDMSG_I) & BIT_MASK_MCUDMSG_I)
#define BIT_SET_MCUDMSG_I(x, v) (BIT_CLEAR_MCUDMSG_I(x) | BIT_MCUDMSG_I(v))

/* 2 REG_MCUTST_II				(Offset 0x01C4) */

#define BIT_SHIFT_MCUDMSG_II 0
#define BIT_MASK_MCUDMSG_II 0xffffffffL
#define BIT_MCUDMSG_II(x) (((x) & BIT_MASK_MCUDMSG_II) << BIT_SHIFT_MCUDMSG_II)
#define BITS_MCUDMSG_II (BIT_MASK_MCUDMSG_II << BIT_SHIFT_MCUDMSG_II)
#define BIT_CLEAR_MCUDMSG_II(x) ((x) & (~BITS_MCUDMSG_II))
#define BIT_GET_MCUDMSG_II(x)                                                  \
	(((x) >> BIT_SHIFT_MCUDMSG_II) & BIT_MASK_MCUDMSG_II)
#define BIT_SET_MCUDMSG_II(x, v) (BIT_CLEAR_MCUDMSG_II(x) | BIT_MCUDMSG_II(v))

/* 2 REG_FMETHR				(Offset 0x01C8) */

#define BIT_FMSG_INT BIT(31)

#define BIT_SHIFT_FW_MSG 0
#define BIT_MASK_FW_MSG 0xffffffffL
#define BIT_FW_MSG(x) (((x) & BIT_MASK_FW_MSG) << BIT_SHIFT_FW_MSG)
#define BITS_FW_MSG (BIT_MASK_FW_MSG << BIT_SHIFT_FW_MSG)
#define BIT_CLEAR_FW_MSG(x) ((x) & (~BITS_FW_MSG))
#define BIT_GET_FW_MSG(x) (((x) >> BIT_SHIFT_FW_MSG) & BIT_MASK_FW_MSG)
#define BIT_SET_FW_MSG(x, v) (BIT_CLEAR_FW_MSG(x) | BIT_FW_MSG(v))

/* 2 REG_HMETFR				(Offset 0x01CC) */

#define BIT_SHIFT_HRCV_MSG 24
#define BIT_MASK_HRCV_MSG 0xff
#define BIT_HRCV_MSG(x) (((x) & BIT_MASK_HRCV_MSG) << BIT_SHIFT_HRCV_MSG)
#define BITS_HRCV_MSG (BIT_MASK_HRCV_MSG << BIT_SHIFT_HRCV_MSG)
#define BIT_CLEAR_HRCV_MSG(x) ((x) & (~BITS_HRCV_MSG))
#define BIT_GET_HRCV_MSG(x) (((x) >> BIT_SHIFT_HRCV_MSG) & BIT_MASK_HRCV_MSG)
#define BIT_SET_HRCV_MSG(x, v) (BIT_CLEAR_HRCV_MSG(x) | BIT_HRCV_MSG(v))

#define BIT_INT_BOX3 BIT(3)
#define BIT_INT_BOX2 BIT(2)
#define BIT_INT_BOX1 BIT(1)
#define BIT_INT_BOX0 BIT(0)

/* 2 REG_HMEBOX0				(Offset 0x01D0) */

#define BIT_SHIFT_HOST_MSG_0 0
#define BIT_MASK_HOST_MSG_0 0xffffffffL
#define BIT_HOST_MSG_0(x) (((x) & BIT_MASK_HOST_MSG_0) << BIT_SHIFT_HOST_MSG_0)
#define BITS_HOST_MSG_0 (BIT_MASK_HOST_MSG_0 << BIT_SHIFT_HOST_MSG_0)
#define BIT_CLEAR_HOST_MSG_0(x) ((x) & (~BITS_HOST_MSG_0))
#define BIT_GET_HOST_MSG_0(x)                                                  \
	(((x) >> BIT_SHIFT_HOST_MSG_0) & BIT_MASK_HOST_MSG_0)
#define BIT_SET_HOST_MSG_0(x, v) (BIT_CLEAR_HOST_MSG_0(x) | BIT_HOST_MSG_0(v))

/* 2 REG_HMEBOX1				(Offset 0x01D4) */

#define BIT_SHIFT_HOST_MSG_1 0
#define BIT_MASK_HOST_MSG_1 0xffffffffL
#define BIT_HOST_MSG_1(x) (((x) & BIT_MASK_HOST_MSG_1) << BIT_SHIFT_HOST_MSG_1)
#define BITS_HOST_MSG_1 (BIT_MASK_HOST_MSG_1 << BIT_SHIFT_HOST_MSG_1)
#define BIT_CLEAR_HOST_MSG_1(x) ((x) & (~BITS_HOST_MSG_1))
#define BIT_GET_HOST_MSG_1(x)                                                  \
	(((x) >> BIT_SHIFT_HOST_MSG_1) & BIT_MASK_HOST_MSG_1)
#define BIT_SET_HOST_MSG_1(x, v) (BIT_CLEAR_HOST_MSG_1(x) | BIT_HOST_MSG_1(v))

/* 2 REG_HMEBOX2				(Offset 0x01D8) */

#define BIT_SHIFT_HOST_MSG_2 0
#define BIT_MASK_HOST_MSG_2 0xffffffffL
#define BIT_HOST_MSG_2(x) (((x) & BIT_MASK_HOST_MSG_2) << BIT_SHIFT_HOST_MSG_2)
#define BITS_HOST_MSG_2 (BIT_MASK_HOST_MSG_2 << BIT_SHIFT_HOST_MSG_2)
#define BIT_CLEAR_HOST_MSG_2(x) ((x) & (~BITS_HOST_MSG_2))
#define BIT_GET_HOST_MSG_2(x)                                                  \
	(((x) >> BIT_SHIFT_HOST_MSG_2) & BIT_MASK_HOST_MSG_2)
#define BIT_SET_HOST_MSG_2(x, v) (BIT_CLEAR_HOST_MSG_2(x) | BIT_HOST_MSG_2(v))

/* 2 REG_HMEBOX3				(Offset 0x01DC) */

#define BIT_SHIFT_HOST_MSG_3 0
#define BIT_MASK_HOST_MSG_3 0xffffffffL
#define BIT_HOST_MSG_3(x) (((x) & BIT_MASK_HOST_MSG_3) << BIT_SHIFT_HOST_MSG_3)
#define BITS_HOST_MSG_3 (BIT_MASK_HOST_MSG_3 << BIT_SHIFT_HOST_MSG_3)
#define BIT_CLEAR_HOST_MSG_3(x) ((x) & (~BITS_HOST_MSG_3))
#define BIT_GET_HOST_MSG_3(x)                                                  \
	(((x) >> BIT_SHIFT_HOST_MSG_3) & BIT_MASK_HOST_MSG_3)
#define BIT_SET_HOST_MSG_3(x, v) (BIT_CLEAR_HOST_MSG_3(x) | BIT_HOST_MSG_3(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_RXDESC_BUFF_BNDY			(Offset 0x01E0) */

#define BIT_FW_FIFO_PTR_RST BIT(18)
#define BIT_PHY_FIFO_PTR_RST BIT(17)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_LLT_INIT				(Offset 0x01E0) */

#define BIT_SHIFT_LLTINI_PDATA_V1 16
#define BIT_MASK_LLTINI_PDATA_V1 0xfff
#define BIT_LLTINI_PDATA_V1(x)                                                 \
	(((x) & BIT_MASK_LLTINI_PDATA_V1) << BIT_SHIFT_LLTINI_PDATA_V1)
#define BITS_LLTINI_PDATA_V1                                                   \
	(BIT_MASK_LLTINI_PDATA_V1 << BIT_SHIFT_LLTINI_PDATA_V1)
#define BIT_CLEAR_LLTINI_PDATA_V1(x) ((x) & (~BITS_LLTINI_PDATA_V1))
#define BIT_GET_LLTINI_PDATA_V1(x)                                             \
	(((x) >> BIT_SHIFT_LLTINI_PDATA_V1) & BIT_MASK_LLTINI_PDATA_V1)
#define BIT_SET_LLTINI_PDATA_V1(x, v)                                          \
	(BIT_CLEAR_LLTINI_PDATA_V1(x) | BIT_LLTINI_PDATA_V1(v))

#define BIT_SHIFT_LLTINI_HDATA_V1 0
#define BIT_MASK_LLTINI_HDATA_V1 0xfff
#define BIT_LLTINI_HDATA_V1(x)                                                 \
	(((x) & BIT_MASK_LLTINI_HDATA_V1) << BIT_SHIFT_LLTINI_HDATA_V1)
#define BITS_LLTINI_HDATA_V1                                                   \
	(BIT_MASK_LLTINI_HDATA_V1 << BIT_SHIFT_LLTINI_HDATA_V1)
#define BIT_CLEAR_LLTINI_HDATA_V1(x) ((x) & (~BITS_LLTINI_HDATA_V1))
#define BIT_GET_LLTINI_HDATA_V1(x)                                             \
	(((x) >> BIT_SHIFT_LLTINI_HDATA_V1) & BIT_MASK_LLTINI_HDATA_V1)
#define BIT_SET_LLTINI_HDATA_V1(x, v)                                          \
	(BIT_CLEAR_LLTINI_HDATA_V1(x) | BIT_LLTINI_HDATA_V1(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_RXDESC_BUFF_BNDY			(Offset 0x01E0) */

#define BIT_SHIFT_RXDESC_BUFF_BNDY 0
#define BIT_MASK_RXDESC_BUFF_BNDY 0xffffffffL
#define BIT_RXDESC_BUFF_BNDY(x)                                                \
	(((x) & BIT_MASK_RXDESC_BUFF_BNDY) << BIT_SHIFT_RXDESC_BUFF_BNDY)
#define BITS_RXDESC_BUFF_BNDY                                                  \
	(BIT_MASK_RXDESC_BUFF_BNDY << BIT_SHIFT_RXDESC_BUFF_BNDY)
#define BIT_CLEAR_RXDESC_BUFF_BNDY(x) ((x) & (~BITS_RXDESC_BUFF_BNDY))
#define BIT_GET_RXDESC_BUFF_BNDY(x)                                            \
	(((x) >> BIT_SHIFT_RXDESC_BUFF_BNDY) & BIT_MASK_RXDESC_BUFF_BNDY)
#define BIT_SET_RXDESC_BUFF_BNDY(x, v)                                         \
	(BIT_CLEAR_RXDESC_BUFF_BNDY(x) | BIT_RXDESC_BUFF_BNDY(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_GENTST				(Offset 0x01E4) */

#define BIT_SHIFT_GENTST 0
#define BIT_MASK_GENTST 0xffffffffL
#define BIT_GENTST(x) (((x) & BIT_MASK_GENTST) << BIT_SHIFT_GENTST)
#define BITS_GENTST (BIT_MASK_GENTST << BIT_SHIFT_GENTST)
#define BIT_CLEAR_GENTST(x) ((x) & (~BITS_GENTST))
#define BIT_GET_GENTST(x) (((x) >> BIT_SHIFT_GENTST) & BIT_MASK_GENTST)
#define BIT_SET_GENTST(x, v) (BIT_CLEAR_GENTST(x) | BIT_GENTST(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_LLT_INIT_ADDR			(Offset 0x01E4) */

#define BIT_SHIFT_LLTINI_ADDR_V1 0
#define BIT_MASK_LLTINI_ADDR_V1 0xfff
#define BIT_LLTINI_ADDR_V1(x)                                                  \
	(((x) & BIT_MASK_LLTINI_ADDR_V1) << BIT_SHIFT_LLTINI_ADDR_V1)
#define BITS_LLTINI_ADDR_V1                                                    \
	(BIT_MASK_LLTINI_ADDR_V1 << BIT_SHIFT_LLTINI_ADDR_V1)
#define BIT_CLEAR_LLTINI_ADDR_V1(x) ((x) & (~BITS_LLTINI_ADDR_V1))
#define BIT_GET_LLTINI_ADDR_V1(x)                                              \
	(((x) >> BIT_SHIFT_LLTINI_ADDR_V1) & BIT_MASK_LLTINI_ADDR_V1)
#define BIT_SET_LLTINI_ADDR_V1(x, v)                                           \
	(BIT_CLEAR_LLTINI_ADDR_V1(x) | BIT_LLTINI_ADDR_V1(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_BB_ACCESS_CTRL			(Offset 0x01E8) */

#define BIT_SHIFT_BB_WRITE_READ 30
#define BIT_MASK_BB_WRITE_READ 0x3
#define BIT_BB_WRITE_READ(x)                                                   \
	(((x) & BIT_MASK_BB_WRITE_READ) << BIT_SHIFT_BB_WRITE_READ)
#define BITS_BB_WRITE_READ (BIT_MASK_BB_WRITE_READ << BIT_SHIFT_BB_WRITE_READ)
#define BIT_CLEAR_BB_WRITE_READ(x) ((x) & (~BITS_BB_WRITE_READ))
#define BIT_GET_BB_WRITE_READ(x)                                               \
	(((x) >> BIT_SHIFT_BB_WRITE_READ) & BIT_MASK_BB_WRITE_READ)
#define BIT_SET_BB_WRITE_READ(x, v)                                            \
	(BIT_CLEAR_BB_WRITE_READ(x) | BIT_BB_WRITE_READ(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT)

/* 2 REG_BB_ACCESS_CTRL			(Offset 0x01E8) */

#define BIT_SHIFT_BB_WRITE_EN_V1 16
#define BIT_MASK_BB_WRITE_EN_V1 0xf
#define BIT_BB_WRITE_EN_V1(x)                                                  \
	(((x) & BIT_MASK_BB_WRITE_EN_V1) << BIT_SHIFT_BB_WRITE_EN_V1)
#define BITS_BB_WRITE_EN_V1                                                    \
	(BIT_MASK_BB_WRITE_EN_V1 << BIT_SHIFT_BB_WRITE_EN_V1)
#define BIT_CLEAR_BB_WRITE_EN_V1(x) ((x) & (~BITS_BB_WRITE_EN_V1))
#define BIT_GET_BB_WRITE_EN_V1(x)                                              \
	(((x) >> BIT_SHIFT_BB_WRITE_EN_V1) & BIT_MASK_BB_WRITE_EN_V1)
#define BIT_SET_BB_WRITE_EN_V1(x, v)                                           \
	(BIT_CLEAR_BB_WRITE_EN_V1(x) | BIT_BB_WRITE_EN_V1(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_BB_ACCESS_CTRL			(Offset 0x01E8) */

#define BIT_SHIFT_BB_WRITE_EN 12
#define BIT_MASK_BB_WRITE_EN 0xf
#define BIT_BB_WRITE_EN(x)                                                     \
	(((x) & BIT_MASK_BB_WRITE_EN) << BIT_SHIFT_BB_WRITE_EN)
#define BITS_BB_WRITE_EN (BIT_MASK_BB_WRITE_EN << BIT_SHIFT_BB_WRITE_EN)
#define BIT_CLEAR_BB_WRITE_EN(x) ((x) & (~BITS_BB_WRITE_EN))
#define BIT_GET_BB_WRITE_EN(x)                                                 \
	(((x) >> BIT_SHIFT_BB_WRITE_EN) & BIT_MASK_BB_WRITE_EN)
#define BIT_SET_BB_WRITE_EN(x, v)                                              \
	(BIT_CLEAR_BB_WRITE_EN(x) | BIT_BB_WRITE_EN(v))

#define BIT_SHIFT_BB_ADDR 2
#define BIT_MASK_BB_ADDR 0x1ff
#define BIT_BB_ADDR(x) (((x) & BIT_MASK_BB_ADDR) << BIT_SHIFT_BB_ADDR)
#define BITS_BB_ADDR (BIT_MASK_BB_ADDR << BIT_SHIFT_BB_ADDR)
#define BIT_CLEAR_BB_ADDR(x) ((x) & (~BITS_BB_ADDR))
#define BIT_GET_BB_ADDR(x) (((x) >> BIT_SHIFT_BB_ADDR) & BIT_MASK_BB_ADDR)
#define BIT_SET_BB_ADDR(x, v) (BIT_CLEAR_BB_ADDR(x) | BIT_BB_ADDR(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT)

/* 2 REG_BB_ACCESS_CTRL			(Offset 0x01E8) */

#define BIT_SHIFT_BB_ADDR_V1 2
#define BIT_MASK_BB_ADDR_V1 0xfff
#define BIT_BB_ADDR_V1(x) (((x) & BIT_MASK_BB_ADDR_V1) << BIT_SHIFT_BB_ADDR_V1)
#define BITS_BB_ADDR_V1 (BIT_MASK_BB_ADDR_V1 << BIT_SHIFT_BB_ADDR_V1)
#define BIT_CLEAR_BB_ADDR_V1(x) ((x) & (~BITS_BB_ADDR_V1))
#define BIT_GET_BB_ADDR_V1(x)                                                  \
	(((x) >> BIT_SHIFT_BB_ADDR_V1) & BIT_MASK_BB_ADDR_V1)
#define BIT_SET_BB_ADDR_V1(x, v) (BIT_CLEAR_BB_ADDR_V1(x) | BIT_BB_ADDR_V1(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_BB_ACCESS_CTRL			(Offset 0x01E8) */

#define BIT_BB_ERRACC BIT(0)

/* 2 REG_BB_ACCESS_DATA			(Offset 0x01EC) */

#define BIT_SHIFT_BB_DATA 0
#define BIT_MASK_BB_DATA 0xffffffffL
#define BIT_BB_DATA(x) (((x) & BIT_MASK_BB_DATA) << BIT_SHIFT_BB_DATA)
#define BITS_BB_DATA (BIT_MASK_BB_DATA << BIT_SHIFT_BB_DATA)
#define BIT_CLEAR_BB_DATA(x) ((x) & (~BITS_BB_DATA))
#define BIT_GET_BB_DATA(x) (((x) >> BIT_SHIFT_BB_DATA) & BIT_MASK_BB_DATA)
#define BIT_SET_BB_DATA(x, v) (BIT_CLEAR_BB_DATA(x) | BIT_BB_DATA(v))

/* 2 REG_HMEBOX_E0				(Offset 0x01F0) */

#define BIT_SHIFT_HMEBOX_E0 0
#define BIT_MASK_HMEBOX_E0 0xffffffffL
#define BIT_HMEBOX_E0(x) (((x) & BIT_MASK_HMEBOX_E0) << BIT_SHIFT_HMEBOX_E0)
#define BITS_HMEBOX_E0 (BIT_MASK_HMEBOX_E0 << BIT_SHIFT_HMEBOX_E0)
#define BIT_CLEAR_HMEBOX_E0(x) ((x) & (~BITS_HMEBOX_E0))
#define BIT_GET_HMEBOX_E0(x) (((x) >> BIT_SHIFT_HMEBOX_E0) & BIT_MASK_HMEBOX_E0)
#define BIT_SET_HMEBOX_E0(x, v) (BIT_CLEAR_HMEBOX_E0(x) | BIT_HMEBOX_E0(v))

/* 2 REG_HMEBOX_E1				(Offset 0x01F4) */

#define BIT_SHIFT_HMEBOX_E1 0
#define BIT_MASK_HMEBOX_E1 0xffffffffL
#define BIT_HMEBOX_E1(x) (((x) & BIT_MASK_HMEBOX_E1) << BIT_SHIFT_HMEBOX_E1)
#define BITS_HMEBOX_E1 (BIT_MASK_HMEBOX_E1 << BIT_SHIFT_HMEBOX_E1)
#define BIT_CLEAR_HMEBOX_E1(x) ((x) & (~BITS_HMEBOX_E1))
#define BIT_GET_HMEBOX_E1(x) (((x) >> BIT_SHIFT_HMEBOX_E1) & BIT_MASK_HMEBOX_E1)
#define BIT_SET_HMEBOX_E1(x, v) (BIT_CLEAR_HMEBOX_E1(x) | BIT_HMEBOX_E1(v))

/* 2 REG_HMEBOX_E2				(Offset 0x01F8) */

#define BIT_SHIFT_HMEBOX_E2 0
#define BIT_MASK_HMEBOX_E2 0xffffffffL
#define BIT_HMEBOX_E2(x) (((x) & BIT_MASK_HMEBOX_E2) << BIT_SHIFT_HMEBOX_E2)
#define BITS_HMEBOX_E2 (BIT_MASK_HMEBOX_E2 << BIT_SHIFT_HMEBOX_E2)
#define BIT_CLEAR_HMEBOX_E2(x) ((x) & (~BITS_HMEBOX_E2))
#define BIT_GET_HMEBOX_E2(x) (((x) >> BIT_SHIFT_HMEBOX_E2) & BIT_MASK_HMEBOX_E2)
#define BIT_SET_HMEBOX_E2(x, v) (BIT_CLEAR_HMEBOX_E2(x) | BIT_HMEBOX_E2(v))

/* 2 REG_HMEBOX_E3				(Offset 0x01FC) */

#define BIT_SHIFT_HMEBOX_E3 0
#define BIT_MASK_HMEBOX_E3 0xffffffffL
#define BIT_HMEBOX_E3(x) (((x) & BIT_MASK_HMEBOX_E3) << BIT_SHIFT_HMEBOX_E3)
#define BITS_HMEBOX_E3 (BIT_MASK_HMEBOX_E3 << BIT_SHIFT_HMEBOX_E3)
#define BIT_CLEAR_HMEBOX_E3(x) ((x) & (~BITS_HMEBOX_E3))
#define BIT_GET_HMEBOX_E3(x) (((x) >> BIT_SHIFT_HMEBOX_E3) & BIT_MASK_HMEBOX_E3)
#define BIT_SET_HMEBOX_E3(x, v) (BIT_CLEAR_HMEBOX_E3(x) | BIT_HMEBOX_E3(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_BCN_CTRL_0				(Offset 0x0200) */

#define BIT_BCN1_VALID BIT(31)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_RQPN_CTRL_HLPQ			(Offset 0x0200) */

#define BIT_EP2Q_PUBLIC_DIS BIT(29)
#define BIT_EP1Q_PUBLIC_DIS BIT(28)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_RQPN_CTRL_HLPQ			(Offset 0x0200) */

#define BIT_EPQ_PUBLIC_DIS BIT(27)
#define BIT_NPQ_PUBLIC_DIS BIT(26)
#define BIT_LPQ_PUBLIC_DIS BIT(25)
#define BIT_HPQ_PUBLIC_DIS BIT(24)

#define BIT_SHIFT_PUBQ 16
#define BIT_MASK_PUBQ 0xff
#define BIT_PUBQ(x) (((x) & BIT_MASK_PUBQ) << BIT_SHIFT_PUBQ)
#define BITS_PUBQ (BIT_MASK_PUBQ << BIT_SHIFT_PUBQ)
#define BIT_CLEAR_PUBQ(x) ((x) & (~BITS_PUBQ))
#define BIT_GET_PUBQ(x) (((x) >> BIT_SHIFT_PUBQ) & BIT_MASK_PUBQ)
#define BIT_SET_PUBQ(x, v) (BIT_CLEAR_PUBQ(x) | BIT_PUBQ(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FIFOPAGE_CTRL_1			(Offset 0x0200) */

#define BIT_SHIFT_TX_OQT_HE_FREE_SPACE_V1 16
#define BIT_MASK_TX_OQT_HE_FREE_SPACE_V1 0xff
#define BIT_TX_OQT_HE_FREE_SPACE_V1(x)                                         \
	(((x) & BIT_MASK_TX_OQT_HE_FREE_SPACE_V1)                              \
	 << BIT_SHIFT_TX_OQT_HE_FREE_SPACE_V1)
#define BITS_TX_OQT_HE_FREE_SPACE_V1                                           \
	(BIT_MASK_TX_OQT_HE_FREE_SPACE_V1 << BIT_SHIFT_TX_OQT_HE_FREE_SPACE_V1)
#define BIT_CLEAR_TX_OQT_HE_FREE_SPACE_V1(x)                                   \
	((x) & (~BITS_TX_OQT_HE_FREE_SPACE_V1))
#define BIT_GET_TX_OQT_HE_FREE_SPACE_V1(x)                                     \
	(((x) >> BIT_SHIFT_TX_OQT_HE_FREE_SPACE_V1) &                          \
	 BIT_MASK_TX_OQT_HE_FREE_SPACE_V1)
#define BIT_SET_TX_OQT_HE_FREE_SPACE_V1(x, v)                                  \
	(BIT_CLEAR_TX_OQT_HE_FREE_SPACE_V1(x) | BIT_TX_OQT_HE_FREE_SPACE_V1(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_BCN_CTRL_0				(Offset 0x0200) */

#define BIT_SHIFT_BCN1_HEAD 16
#define BIT_MASK_BCN1_HEAD 0xfff
#define BIT_BCN1_HEAD(x) (((x) & BIT_MASK_BCN1_HEAD) << BIT_SHIFT_BCN1_HEAD)
#define BITS_BCN1_HEAD (BIT_MASK_BCN1_HEAD << BIT_SHIFT_BCN1_HEAD)
#define BIT_CLEAR_BCN1_HEAD(x) ((x) & (~BITS_BCN1_HEAD))
#define BIT_GET_BCN1_HEAD(x) (((x) >> BIT_SHIFT_BCN1_HEAD) & BIT_MASK_BCN1_HEAD)
#define BIT_SET_BCN1_HEAD(x, v) (BIT_CLEAR_BCN1_HEAD(x) | BIT_BCN1_HEAD(v))

#define BIT_BCN0_VALID BIT(15)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_RQPN_CTRL_HLPQ			(Offset 0x0200) */

#define BIT_SHIFT_LPQ 8
#define BIT_MASK_LPQ 0xff
#define BIT_LPQ(x) (((x) & BIT_MASK_LPQ) << BIT_SHIFT_LPQ)
#define BITS_LPQ (BIT_MASK_LPQ << BIT_SHIFT_LPQ)
#define BIT_CLEAR_LPQ(x) ((x) & (~BITS_LPQ))
#define BIT_GET_LPQ(x) (((x) >> BIT_SHIFT_LPQ) & BIT_MASK_LPQ)
#define BIT_SET_LPQ(x, v) (BIT_CLEAR_LPQ(x) | BIT_LPQ(v))

#define BIT_SHIFT_HPQ 0
#define BIT_MASK_HPQ 0xff
#define BIT_HPQ(x) (((x) & BIT_MASK_HPQ) << BIT_SHIFT_HPQ)
#define BITS_HPQ (BIT_MASK_HPQ << BIT_SHIFT_HPQ)
#define BIT_CLEAR_HPQ(x) ((x) & (~BITS_HPQ))
#define BIT_GET_HPQ(x) (((x) >> BIT_SHIFT_HPQ) & BIT_MASK_HPQ)
#define BIT_SET_HPQ(x, v) (BIT_CLEAR_HPQ(x) | BIT_HPQ(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FIFOPAGE_CTRL_1			(Offset 0x0200) */

#define BIT_SHIFT_TX_OQT_NL_FREE_SPACE_V1 0
#define BIT_MASK_TX_OQT_NL_FREE_SPACE_V1 0xff
#define BIT_TX_OQT_NL_FREE_SPACE_V1(x)                                         \
	(((x) & BIT_MASK_TX_OQT_NL_FREE_SPACE_V1)                              \
	 << BIT_SHIFT_TX_OQT_NL_FREE_SPACE_V1)
#define BITS_TX_OQT_NL_FREE_SPACE_V1                                           \
	(BIT_MASK_TX_OQT_NL_FREE_SPACE_V1 << BIT_SHIFT_TX_OQT_NL_FREE_SPACE_V1)
#define BIT_CLEAR_TX_OQT_NL_FREE_SPACE_V1(x)                                   \
	((x) & (~BITS_TX_OQT_NL_FREE_SPACE_V1))
#define BIT_GET_TX_OQT_NL_FREE_SPACE_V1(x)                                     \
	(((x) >> BIT_SHIFT_TX_OQT_NL_FREE_SPACE_V1) &                          \
	 BIT_MASK_TX_OQT_NL_FREE_SPACE_V1)
#define BIT_SET_TX_OQT_NL_FREE_SPACE_V1(x, v)                                  \
	(BIT_CLEAR_TX_OQT_NL_FREE_SPACE_V1(x) | BIT_TX_OQT_NL_FREE_SPACE_V1(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_BCN_CTRL_0				(Offset 0x0200) */

#define BIT_SHIFT_BCN0_HEAD 0
#define BIT_MASK_BCN0_HEAD 0xfff
#define BIT_BCN0_HEAD(x) (((x) & BIT_MASK_BCN0_HEAD) << BIT_SHIFT_BCN0_HEAD)
#define BITS_BCN0_HEAD (BIT_MASK_BCN0_HEAD << BIT_SHIFT_BCN0_HEAD)
#define BIT_CLEAR_BCN0_HEAD(x) ((x) & (~BITS_BCN0_HEAD))
#define BIT_GET_BCN0_HEAD(x) (((x) >> BIT_SHIFT_BCN0_HEAD) & BIT_MASK_BCN0_HEAD)
#define BIT_SET_BCN0_HEAD(x, v) (BIT_CLEAR_BCN0_HEAD(x) | BIT_BCN0_HEAD(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FIFOPAGE_CTRL_2			(Offset 0x0204) */

#define BIT_BCN_VALID_1_V1 BIT(31)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_BCN_CTRL_1				(Offset 0x0204) */

#define BIT_BCN3_VALID BIT(31)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FIFOPAGE_INFO			(Offset 0x0204) */

#define BIT_SHIFT_TXPKTNUM 24
#define BIT_MASK_TXPKTNUM 0xff
#define BIT_TXPKTNUM(x) (((x) & BIT_MASK_TXPKTNUM) << BIT_SHIFT_TXPKTNUM)
#define BITS_TXPKTNUM (BIT_MASK_TXPKTNUM << BIT_SHIFT_TXPKTNUM)
#define BIT_CLEAR_TXPKTNUM(x) ((x) & (~BITS_TXPKTNUM))
#define BIT_GET_TXPKTNUM(x) (((x) >> BIT_SHIFT_TXPKTNUM) & BIT_MASK_TXPKTNUM)
#define BIT_SET_TXPKTNUM(x, v) (BIT_CLEAR_TXPKTNUM(x) | BIT_TXPKTNUM(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_BCN_CTRL_1				(Offset 0x0204) */

#define BIT_SHIFT_R_BCN_HEAD_SEL_V1 20
#define BIT_MASK_R_BCN_HEAD_SEL_V1 0x7
#define BIT_R_BCN_HEAD_SEL_V1(x)                                               \
	(((x) & BIT_MASK_R_BCN_HEAD_SEL_V1) << BIT_SHIFT_R_BCN_HEAD_SEL_V1)
#define BITS_R_BCN_HEAD_SEL_V1                                                 \
	(BIT_MASK_R_BCN_HEAD_SEL_V1 << BIT_SHIFT_R_BCN_HEAD_SEL_V1)
#define BIT_CLEAR_R_BCN_HEAD_SEL_V1(x) ((x) & (~BITS_R_BCN_HEAD_SEL_V1))
#define BIT_GET_R_BCN_HEAD_SEL_V1(x)                                           \
	(((x) >> BIT_SHIFT_R_BCN_HEAD_SEL_V1) & BIT_MASK_R_BCN_HEAD_SEL_V1)
#define BIT_SET_R_BCN_HEAD_SEL_V1(x, v)                                        \
	(BIT_CLEAR_R_BCN_HEAD_SEL_V1(x) | BIT_R_BCN_HEAD_SEL_V1(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FIFOPAGE_INFO			(Offset 0x0204) */

#define BIT_SHIFT_PUBQ_AVAL_PG 16
#define BIT_MASK_PUBQ_AVAL_PG 0xff
#define BIT_PUBQ_AVAL_PG(x)                                                    \
	(((x) & BIT_MASK_PUBQ_AVAL_PG) << BIT_SHIFT_PUBQ_AVAL_PG)
#define BITS_PUBQ_AVAL_PG (BIT_MASK_PUBQ_AVAL_PG << BIT_SHIFT_PUBQ_AVAL_PG)
#define BIT_CLEAR_PUBQ_AVAL_PG(x) ((x) & (~BITS_PUBQ_AVAL_PG))
#define BIT_GET_PUBQ_AVAL_PG(x)                                                \
	(((x) >> BIT_SHIFT_PUBQ_AVAL_PG) & BIT_MASK_PUBQ_AVAL_PG)
#define BIT_SET_PUBQ_AVAL_PG(x, v)                                             \
	(BIT_CLEAR_PUBQ_AVAL_PG(x) | BIT_PUBQ_AVAL_PG(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FIFOPAGE_CTRL_2			(Offset 0x0204) */

#define BIT_SHIFT_BCN_HEAD_1_V1 16
#define BIT_MASK_BCN_HEAD_1_V1 0xfff
#define BIT_BCN_HEAD_1_V1(x)                                                   \
	(((x) & BIT_MASK_BCN_HEAD_1_V1) << BIT_SHIFT_BCN_HEAD_1_V1)
#define BITS_BCN_HEAD_1_V1 (BIT_MASK_BCN_HEAD_1_V1 << BIT_SHIFT_BCN_HEAD_1_V1)
#define BIT_CLEAR_BCN_HEAD_1_V1(x) ((x) & (~BITS_BCN_HEAD_1_V1))
#define BIT_GET_BCN_HEAD_1_V1(x)                                               \
	(((x) >> BIT_SHIFT_BCN_HEAD_1_V1) & BIT_MASK_BCN_HEAD_1_V1)
#define BIT_SET_BCN_HEAD_1_V1(x, v)                                            \
	(BIT_CLEAR_BCN_HEAD_1_V1(x) | BIT_BCN_HEAD_1_V1(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_BCN_CTRL_1				(Offset 0x0204) */

#define BIT_SHIFT_BCN3_HEAD 16
#define BIT_MASK_BCN3_HEAD 0xfff
#define BIT_BCN3_HEAD(x) (((x) & BIT_MASK_BCN3_HEAD) << BIT_SHIFT_BCN3_HEAD)
#define BITS_BCN3_HEAD (BIT_MASK_BCN3_HEAD << BIT_SHIFT_BCN3_HEAD)
#define BIT_CLEAR_BCN3_HEAD(x) ((x) & (~BITS_BCN3_HEAD))
#define BIT_GET_BCN3_HEAD(x) (((x) >> BIT_SHIFT_BCN3_HEAD) & BIT_MASK_BCN3_HEAD)
#define BIT_SET_BCN3_HEAD(x, v) (BIT_CLEAR_BCN3_HEAD(x) | BIT_BCN3_HEAD(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FIFOPAGE_CTRL_2			(Offset 0x0204) */

#define BIT_BCN_VALID_V1 BIT(15)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_BCN_CTRL_1				(Offset 0x0204) */

#define BIT_BCN2_VALID BIT(15)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FIFOPAGE_INFO			(Offset 0x0204) */

#define BIT_SHIFT_LPQ_AVAL_PG 8
#define BIT_MASK_LPQ_AVAL_PG 0xff
#define BIT_LPQ_AVAL_PG(x)                                                     \
	(((x) & BIT_MASK_LPQ_AVAL_PG) << BIT_SHIFT_LPQ_AVAL_PG)
#define BITS_LPQ_AVAL_PG (BIT_MASK_LPQ_AVAL_PG << BIT_SHIFT_LPQ_AVAL_PG)
#define BIT_CLEAR_LPQ_AVAL_PG(x) ((x) & (~BITS_LPQ_AVAL_PG))
#define BIT_GET_LPQ_AVAL_PG(x)                                                 \
	(((x) >> BIT_SHIFT_LPQ_AVAL_PG) & BIT_MASK_LPQ_AVAL_PG)
#define BIT_SET_LPQ_AVAL_PG(x, v)                                              \
	(BIT_CLEAR_LPQ_AVAL_PG(x) | BIT_LPQ_AVAL_PG(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_BCN_CTRL_1				(Offset 0x0204) */

#define BIT_TDE_ERROR_STOP BIT(3)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_FIFOPAGE_INFO			(Offset 0x0204) */

#define BIT_SHIFT_HPQ_AVAL_PG 0
#define BIT_MASK_HPQ_AVAL_PG 0xff
#define BIT_HPQ_AVAL_PG(x)                                                     \
	(((x) & BIT_MASK_HPQ_AVAL_PG) << BIT_SHIFT_HPQ_AVAL_PG)
#define BITS_HPQ_AVAL_PG (BIT_MASK_HPQ_AVAL_PG << BIT_SHIFT_HPQ_AVAL_PG)
#define BIT_CLEAR_HPQ_AVAL_PG(x) ((x) & (~BITS_HPQ_AVAL_PG))
#define BIT_GET_HPQ_AVAL_PG(x)                                                 \
	(((x) >> BIT_SHIFT_HPQ_AVAL_PG) & BIT_MASK_HPQ_AVAL_PG)
#define BIT_SET_HPQ_AVAL_PG(x, v)                                              \
	(BIT_CLEAR_HPQ_AVAL_PG(x) | BIT_HPQ_AVAL_PG(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FIFOPAGE_CTRL_2			(Offset 0x0204) */

#define BIT_SHIFT_BCN_HEAD_V1 0
#define BIT_MASK_BCN_HEAD_V1 0xfff
#define BIT_BCN_HEAD_V1(x)                                                     \
	(((x) & BIT_MASK_BCN_HEAD_V1) << BIT_SHIFT_BCN_HEAD_V1)
#define BITS_BCN_HEAD_V1 (BIT_MASK_BCN_HEAD_V1 << BIT_SHIFT_BCN_HEAD_V1)
#define BIT_CLEAR_BCN_HEAD_V1(x) ((x) & (~BITS_BCN_HEAD_V1))
#define BIT_GET_BCN_HEAD_V1(x)                                                 \
	(((x) >> BIT_SHIFT_BCN_HEAD_V1) & BIT_MASK_BCN_HEAD_V1)
#define BIT_SET_BCN_HEAD_V1(x, v)                                              \
	(BIT_CLEAR_BCN_HEAD_V1(x) | BIT_BCN_HEAD_V1(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_BCN_CTRL_1				(Offset 0x0204) */

#define BIT_SHIFT_BCN2_HEAD 0
#define BIT_MASK_BCN2_HEAD 0xfff
#define BIT_BCN2_HEAD(x) (((x) & BIT_MASK_BCN2_HEAD) << BIT_SHIFT_BCN2_HEAD)
#define BITS_BCN2_HEAD (BIT_MASK_BCN2_HEAD << BIT_SHIFT_BCN2_HEAD)
#define BIT_CLEAR_BCN2_HEAD(x) ((x) & (~BITS_BCN2_HEAD))
#define BIT_GET_BCN2_HEAD(x) (((x) >> BIT_SHIFT_BCN2_HEAD) & BIT_MASK_BCN2_HEAD)
#define BIT_SET_BCN2_HEAD(x, v) (BIT_CLEAR_BCN2_HEAD(x) | BIT_BCN2_HEAD(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_DWBCN0_CTRL				(Offset 0x0208) */

#define BIT_SHIFT_LLT_FREE_PAGE 24
#define BIT_MASK_LLT_FREE_PAGE 0xff
#define BIT_LLT_FREE_PAGE(x)                                                   \
	(((x) & BIT_MASK_LLT_FREE_PAGE) << BIT_SHIFT_LLT_FREE_PAGE)
#define BITS_LLT_FREE_PAGE (BIT_MASK_LLT_FREE_PAGE << BIT_SHIFT_LLT_FREE_PAGE)
#define BIT_CLEAR_LLT_FREE_PAGE(x) ((x) & (~BITS_LLT_FREE_PAGE))
#define BIT_GET_LLT_FREE_PAGE(x)                                               \
	(((x) >> BIT_SHIFT_LLT_FREE_PAGE) & BIT_MASK_LLT_FREE_PAGE)
#define BIT_SET_LLT_FREE_PAGE(x, v)                                            \
	(BIT_CLEAR_LLT_FREE_PAGE(x) | BIT_LLT_FREE_PAGE(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT)

/* 2 REG_AUTO_LLT_V1				(Offset 0x0208) */

#define BIT_SHIFT_MAX_TX_PKT_FOR_USB_AND_SDIO_V1 24
#define BIT_MASK_MAX_TX_PKT_FOR_USB_AND_SDIO_V1 0xff
#define BIT_MAX_TX_PKT_FOR_USB_AND_SDIO_V1(x)                                  \
	(((x) & BIT_MASK_MAX_TX_PKT_FOR_USB_AND_SDIO_V1)                       \
	 << BIT_SHIFT_MAX_TX_PKT_FOR_USB_AND_SDIO_V1)
#define BITS_MAX_TX_PKT_FOR_USB_AND_SDIO_V1                                    \
	(BIT_MASK_MAX_TX_PKT_FOR_USB_AND_SDIO_V1                               \
	 << BIT_SHIFT_MAX_TX_PKT_FOR_USB_AND_SDIO_V1)
#define BIT_CLEAR_MAX_TX_PKT_FOR_USB_AND_SDIO_V1(x)                            \
	((x) & (~BITS_MAX_TX_PKT_FOR_USB_AND_SDIO_V1))
#define BIT_GET_MAX_TX_PKT_FOR_USB_AND_SDIO_V1(x)                              \
	(((x) >> BIT_SHIFT_MAX_TX_PKT_FOR_USB_AND_SDIO_V1) &                   \
	 BIT_MASK_MAX_TX_PKT_FOR_USB_AND_SDIO_V1)
#define BIT_SET_MAX_TX_PKT_FOR_USB_AND_SDIO_V1(x, v)                           \
	(BIT_CLEAR_MAX_TX_PKT_FOR_USB_AND_SDIO_V1(x) |                         \
	 BIT_MAX_TX_PKT_FOR_USB_AND_SDIO_V1(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_AUTO_LLT_V1				(Offset 0x0208) */

#define BIT_SHIFT_MAX_TX_PKT_V1 24
#define BIT_MASK_MAX_TX_PKT_V1 0xff
#define BIT_MAX_TX_PKT_V1(x)                                                   \
	(((x) & BIT_MASK_MAX_TX_PKT_V1) << BIT_SHIFT_MAX_TX_PKT_V1)
#define BITS_MAX_TX_PKT_V1 (BIT_MASK_MAX_TX_PKT_V1 << BIT_SHIFT_MAX_TX_PKT_V1)
#define BIT_CLEAR_MAX_TX_PKT_V1(x) ((x) & (~BITS_MAX_TX_PKT_V1))
#define BIT_GET_MAX_TX_PKT_V1(x)                                               \
	(((x) >> BIT_SHIFT_MAX_TX_PKT_V1) & BIT_MASK_MAX_TX_PKT_V1)
#define BIT_SET_MAX_TX_PKT_V1(x, v)                                            \
	(BIT_CLEAR_MAX_TX_PKT_V1(x) | BIT_MAX_TX_PKT_V1(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_AUTO_LLT_V1				(Offset 0x0208) */

#define BIT_TDE_ERROR_STOP_V1 BIT(23)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_DWBCN0_CTRL				(Offset 0x0208) */

#define BIT_BCN_VALID BIT(16)

#define BIT_SHIFT_BCN_HEAD 8
#define BIT_MASK_BCN_HEAD 0xff
#define BIT_BCN_HEAD(x) (((x) & BIT_MASK_BCN_HEAD) << BIT_SHIFT_BCN_HEAD)
#define BITS_BCN_HEAD (BIT_MASK_BCN_HEAD << BIT_SHIFT_BCN_HEAD)
#define BIT_CLEAR_BCN_HEAD(x) ((x) & (~BITS_BCN_HEAD))
#define BIT_GET_BCN_HEAD(x) (((x) >> BIT_SHIFT_BCN_HEAD) & BIT_MASK_BCN_HEAD)
#define BIT_SET_BCN_HEAD(x, v) (BIT_CLEAR_BCN_HEAD(x) | BIT_BCN_HEAD(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_AUTO_LLT_V1				(Offset 0x0208) */

#define BIT_SHIFT_LLT_FREE_PAGE_V1 8
#define BIT_MASK_LLT_FREE_PAGE_V1 0xffff
#define BIT_LLT_FREE_PAGE_V1(x)                                                \
	(((x) & BIT_MASK_LLT_FREE_PAGE_V1) << BIT_SHIFT_LLT_FREE_PAGE_V1)
#define BITS_LLT_FREE_PAGE_V1                                                  \
	(BIT_MASK_LLT_FREE_PAGE_V1 << BIT_SHIFT_LLT_FREE_PAGE_V1)
#define BIT_CLEAR_LLT_FREE_PAGE_V1(x) ((x) & (~BITS_LLT_FREE_PAGE_V1))
#define BIT_GET_LLT_FREE_PAGE_V1(x)                                            \
	(((x) >> BIT_SHIFT_LLT_FREE_PAGE_V1) & BIT_MASK_LLT_FREE_PAGE_V1)
#define BIT_SET_LLT_FREE_PAGE_V1(x, v)                                         \
	(BIT_CLEAR_LLT_FREE_PAGE_V1(x) | BIT_LLT_FREE_PAGE_V1(v))

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_AUTO_LLT_V1				(Offset 0x0208) */

#define BIT_SHIFT_LLT_FREE_PAGE_V2 8
#define BIT_MASK_LLT_FREE_PAGE_V2 0xfff
#define BIT_LLT_FREE_PAGE_V2(x)                                                \
	(((x) & BIT_MASK_LLT_FREE_PAGE_V2) << BIT_SHIFT_LLT_FREE_PAGE_V2)
#define BITS_LLT_FREE_PAGE_V2                                                  \
	(BIT_MASK_LLT_FREE_PAGE_V2 << BIT_SHIFT_LLT_FREE_PAGE_V2)
#define BIT_CLEAR_LLT_FREE_PAGE_V2(x) ((x) & (~BITS_LLT_FREE_PAGE_V2))
#define BIT_GET_LLT_FREE_PAGE_V2(x)                                            \
	(((x) >> BIT_SHIFT_LLT_FREE_PAGE_V2) & BIT_MASK_LLT_FREE_PAGE_V2)
#define BIT_SET_LLT_FREE_PAGE_V2(x, v)                                         \
	(BIT_CLEAR_LLT_FREE_PAGE_V2(x) | BIT_LLT_FREE_PAGE_V2(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_AUTO_LLT_V1				(Offset 0x0208) */

#define BIT_SHIFT_BLK_DESC_NUM 4
#define BIT_MASK_BLK_DESC_NUM 0xf
#define BIT_BLK_DESC_NUM(x)                                                    \
	(((x) & BIT_MASK_BLK_DESC_NUM) << BIT_SHIFT_BLK_DESC_NUM)
#define BITS_BLK_DESC_NUM (BIT_MASK_BLK_DESC_NUM << BIT_SHIFT_BLK_DESC_NUM)
#define BIT_CLEAR_BLK_DESC_NUM(x) ((x) & (~BITS_BLK_DESC_NUM))
#define BIT_GET_BLK_DESC_NUM(x)                                                \
	(((x) >> BIT_SHIFT_BLK_DESC_NUM) & BIT_MASK_BLK_DESC_NUM)
#define BIT_SET_BLK_DESC_NUM(x, v)                                             \
	(BIT_CLEAR_BLK_DESC_NUM(x) | BIT_BLK_DESC_NUM(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_AUTO_LLT_V1				(Offset 0x0208) */

#define BIT_R_BCN_HEAD_SEL BIT(3)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_AUTO_LLT_V1				(Offset 0x0208) */

#define BIT_R_EN_BCN_SW_HEAD_SEL BIT(2)
#define BIT_LLT_DBG_SEL BIT(1)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_DWBCN0_CTRL				(Offset 0x0208) */

#define BIT_BLK_DESC_OPT BIT(0)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_AUTO_LLT_V1				(Offset 0x0208) */

#define BIT_AUTO_INIT_LLT_V1 BIT(0)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_TXDMA_OFFSET_CHK			(Offset 0x020C) */

#define BIT_EM_CHKSUM_FIN BIT(31)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_TXDMA_OFFSET_CHK			(Offset 0x020C) */

#define BIT_EN_CHKSUM_ERR_FIN BIT(31)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_TXDMA_OFFSET_CHK			(Offset 0x020C) */

#define BIT_EMN_PCIE_DMA_MOD BIT(30)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_TXDMA_OFFSET_CHK			(Offset 0x020C) */

#define BIT_EN_PCIE_DMA_MOD BIT(30)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_TXDMA_OFFSET_CHK			(Offset 0x020C) */

#define BIT_EN_TXQUE_CLR BIT(29)
#define BIT_EN_PCIE_FIFO_MODE BIT(28)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_TXDMA_OFFSET_CHK			(Offset 0x020C) */

#define BIT_SHIFT_PG_UNDER_TH 16
#define BIT_MASK_PG_UNDER_TH 0xff
#define BIT_PG_UNDER_TH(x)                                                     \
	(((x) & BIT_MASK_PG_UNDER_TH) << BIT_SHIFT_PG_UNDER_TH)
#define BITS_PG_UNDER_TH (BIT_MASK_PG_UNDER_TH << BIT_SHIFT_PG_UNDER_TH)
#define BIT_CLEAR_PG_UNDER_TH(x) ((x) & (~BITS_PG_UNDER_TH))
#define BIT_GET_PG_UNDER_TH(x)                                                 \
	(((x) >> BIT_SHIFT_PG_UNDER_TH) & BIT_MASK_PG_UNDER_TH)
#define BIT_SET_PG_UNDER_TH(x, v)                                              \
	(BIT_CLEAR_PG_UNDER_TH(x) | BIT_PG_UNDER_TH(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_TXDMA_OFFSET_CHK			(Offset 0x020C) */

#define BIT_SHIFT_PG_UNDER_TH_V2 16
#define BIT_MASK_PG_UNDER_TH_V2 0xff
#define BIT_PG_UNDER_TH_V2(x)                                                  \
	(((x) & BIT_MASK_PG_UNDER_TH_V2) << BIT_SHIFT_PG_UNDER_TH_V2)
#define BITS_PG_UNDER_TH_V2                                                    \
	(BIT_MASK_PG_UNDER_TH_V2 << BIT_SHIFT_PG_UNDER_TH_V2)
#define BIT_CLEAR_PG_UNDER_TH_V2(x) ((x) & (~BITS_PG_UNDER_TH_V2))
#define BIT_GET_PG_UNDER_TH_V2(x)                                              \
	(((x) >> BIT_SHIFT_PG_UNDER_TH_V2) & BIT_MASK_PG_UNDER_TH_V2)
#define BIT_SET_PG_UNDER_TH_V2(x, v)                                           \
	(BIT_CLEAR_PG_UNDER_TH_V2(x) | BIT_PG_UNDER_TH_V2(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_TXDMA_OFFSET_CHK			(Offset 0x020C) */

#define BIT_SHIFT_PG_UNDER_TH_V1 16
#define BIT_MASK_PG_UNDER_TH_V1 0xfff
#define BIT_PG_UNDER_TH_V1(x)                                                  \
	(((x) & BIT_MASK_PG_UNDER_TH_V1) << BIT_SHIFT_PG_UNDER_TH_V1)
#define BITS_PG_UNDER_TH_V1                                                    \
	(BIT_MASK_PG_UNDER_TH_V1 << BIT_SHIFT_PG_UNDER_TH_V1)
#define BIT_CLEAR_PG_UNDER_TH_V1(x) ((x) & (~BITS_PG_UNDER_TH_V1))
#define BIT_GET_PG_UNDER_TH_V1(x)                                              \
	(((x) >> BIT_SHIFT_PG_UNDER_TH_V1) & BIT_MASK_PG_UNDER_TH_V1)
#define BIT_SET_PG_UNDER_TH_V1(x, v)                                           \
	(BIT_CLEAR_PG_UNDER_TH_V1(x) | BIT_PG_UNDER_TH_V1(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197G_SUPPORT)

/* 2 REG_TXDMA_OFFSET_CHK			(Offset 0x020C) */

#define BIT_EN_RESTORE_H2C_BY_RST BIT(15)

#endif

#if (HALMAC_8197F_SUPPORT)

/* 2 REG_TXDMA_OFFSET_CHK			(Offset 0x020C) */

#define BIT_EN_RESET_RESTORE_H2C BIT(15)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_TXDMA_OFFSET_CHK			(Offset 0x020C) */

#define BIT_R_EN_RESET_RESTORE_H2C BIT(15)

#endif

#if (HALMAC_8822B_SUPPORT)

/* 2 REG_TXDMA_OFFSET_CHK			(Offset 0x020C) */

#define BIT_RESTORE_H2C_ADDRESS BIT(15)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_TXDMA_OFFSET_CHK			(Offset 0x020C) */

#define BIT_SDIO_TDE_FINISH BIT(14)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_TXDMA_OFFSET_CHK			(Offset 0x020C) */

#define BIT_SDIO_TXDESC_CHKSUM_EN BIT(13)
#define BIT_RST_RDPTR BIT(12)
#define BIT_RST_WRPTR BIT(11)
#define BIT_CHK_PG_TH_EN BIT(10)
#define BIT_DROP_DATA_EN BIT(9)
#define BIT_CHECK_OFFSET_EN BIT(8)

#define BIT_SHIFT_CHECK_OFFSET 0
#define BIT_MASK_CHECK_OFFSET 0xff
#define BIT_CHECK_OFFSET(x)                                                    \
	(((x) & BIT_MASK_CHECK_OFFSET) << BIT_SHIFT_CHECK_OFFSET)
#define BITS_CHECK_OFFSET (BIT_MASK_CHECK_OFFSET << BIT_SHIFT_CHECK_OFFSET)
#define BIT_CLEAR_CHECK_OFFSET(x) ((x) & (~BITS_CHECK_OFFSET))
#define BIT_GET_CHECK_OFFSET(x)                                                \
	(((x) >> BIT_SHIFT_CHECK_OFFSET) & BIT_MASK_CHECK_OFFSET)
#define BIT_SET_CHECK_OFFSET(x, v)                                             \
	(BIT_CLEAR_CHECK_OFFSET(x) | BIT_CHECK_OFFSET(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_TXDMA_STATUS			(Offset 0x0210) */

#define BIT_LD_RQPN BIT(31)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_TXDMA_STATUS			(Offset 0x0210) */

#define BIT_AMSDU_PKT_SIZE_ERR BIT(31)
#define BIT_AMSDU_EN_ERR BIT(30)
#define BIT_CHKSUM_AMSDU_EN_ERR BIT(29)
#define BIT_TXPKTBF_REQ_ERR BIT(28)
#define BIT_OQT_UDN_16 BIT(27)
#define BIT_OQT_OVF_16 BIT(26)
#define BIT_OQT_UDN_14_15 BIT(25)
#define BIT_OQT_OVF_14_15 BIT(24)
#define BIT_OQT_UDN_13 BIT(23)
#define BIT_OQT_OVF_13 BIT(22)
#define BIT_OQT_UDN_12 BIT(21)
#define BIT_OQT_OVF_12 BIT(20)
#define BIT_OQT_UDN_8_11 BIT(19)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_TXDMA_STATUS			(Offset 0x0210) */

#define BIT_TXPKTBUF_REQ_ERR BIT(18)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_TXDMA_STATUS			(Offset 0x0210) */

#define BIT_OQT_OVF_8_11 BIT(18)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_TXDMA_STATUS			(Offset 0x0210) */

#define BIT_HI_OQT_UDN BIT(17)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_TXDMA_STATUS			(Offset 0x0210) */

#define BIT_OQT_UDN_4_7 BIT(17)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_TXDMA_STATUS			(Offset 0x0210) */

#define BIT_HI_OQT_OVF BIT(16)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_TXDMA_STATUS			(Offset 0x0210) */

#define BIT_OQT_OVF_4_7 BIT(16)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_TXDMA_STATUS			(Offset 0x0210) */

#define BIT_PAYLOAD_CHKSUM_ERR BIT(15)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_TXDMA_STATUS			(Offset 0x0210) */

#define BIT_RX_CLOSE_EN BIT(15)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_TXDMA_STATUS			(Offset 0x0210) */

#define BIT_PAYLOAD_UDN BIT(14)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_TXDMA_STATUS			(Offset 0x0210) */

#define BIT_STOP_BCNQ BIT(14)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_TXDMA_STATUS			(Offset 0x0210) */

#define BIT_PAYLOAD_OVF BIT(13)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_TXDMA_STATUS			(Offset 0x0210) */

#define BIT_STOP_MGQ BIT(13)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_TXDMA_STATUS			(Offset 0x0210) */

#define BIT_DSC_CHKSUM_FAIL BIT(12)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_TXDMA_STATUS			(Offset 0x0210) */

#define BIT_STOP_VOQ BIT(12)
#define BIT_UNKNOWN_QSEL BIT(11)
#define BIT_STOP_VIQ BIT(11)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_TXDMA_STATUS			(Offset 0x0210) */

#define BIT_EP_QSEL_DIFF BIT(10)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_TXDMA_STATUS			(Offset 0x0210) */

#define BIT_STOP_BEQ BIT(10)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_TXDMA_STATUS			(Offset 0x0210) */

#define BIT_TX_OFFS_UNMATCH BIT(9)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_TXDMA_STATUS			(Offset 0x0210) */

#define BIT_STOP_BKQ BIT(9)
#define BIT_TXOQT_UDN BIT(8)
#define BIT_STOP_RXQ BIT(8)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_TXDMA_STATUS			(Offset 0x0210) */

#define BIT_TXOQT_UDN_0_3 BIT(8)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_TXDMA_STATUS			(Offset 0x0210) */

#define BIT_TXOQT_OVF BIT(7)
#define BIT_STOP_HI7Q BIT(7)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_TXDMA_STATUS			(Offset 0x0210) */

#define BIT_TXOQT_OVF_0_3 BIT(7)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_TXDMA_STATUS			(Offset 0x0210) */

#define BIT_TXDMA_SFF_UDN BIT(6)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_TXDMA_STATUS			(Offset 0x0210) */

#define BIT_STOP_HI6Q BIT(6)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_TXDMA_STATUS			(Offset 0x0210) */

#define BIT_TXDMA_SFF_OVF BIT(5)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_TXDMA_STATUS			(Offset 0x0210) */

#define BIT_STOP_HI5Q BIT(5)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_TXDMA_STATUS			(Offset 0x0210) */

#define BIT_LLT_NULL_PG BIT(4)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_TXDMA_STATUS			(Offset 0x0210) */

#define BIT_STOP_HI4Q BIT(4)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_TXDMA_STATUS			(Offset 0x0210) */

#define BIT_PAGE_UDN BIT(3)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_TXDMA_STATUS			(Offset 0x0210) */

#define BIT_STOP_HI3Q BIT(3)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_TXDMA_STATUS			(Offset 0x0210) */

#define BIT_PAGE_OVF BIT(2)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_TXDMA_STATUS			(Offset 0x0210) */

#define BIT_STOP_HI2Q BIT(2)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_TXDMA_STATUS			(Offset 0x0210) */

#define BIT_TXFF_PG_UDN BIT(1)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_TXDMA_STATUS			(Offset 0x0210) */

#define BIT_STOP_HI1Q BIT(1)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_TXDMA_STATUS			(Offset 0x0210) */

#define BIT_TXFF_PG_OVF BIT(0)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_TXDMA_STATUS			(Offset 0x0210) */

#define BIT_STOP_HI0Q BIT(0)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_RQPN_NPQ				(Offset 0x0214) */

#define BIT_SHIFT_EXQ_AVAL_PG 24
#define BIT_MASK_EXQ_AVAL_PG 0xff
#define BIT_EXQ_AVAL_PG(x)                                                     \
	(((x) & BIT_MASK_EXQ_AVAL_PG) << BIT_SHIFT_EXQ_AVAL_PG)
#define BITS_EXQ_AVAL_PG (BIT_MASK_EXQ_AVAL_PG << BIT_SHIFT_EXQ_AVAL_PG)
#define BIT_CLEAR_EXQ_AVAL_PG(x) ((x) & (~BITS_EXQ_AVAL_PG))
#define BIT_GET_EXQ_AVAL_PG(x)                                                 \
	(((x) >> BIT_SHIFT_EXQ_AVAL_PG) & BIT_MASK_EXQ_AVAL_PG)
#define BIT_SET_EXQ_AVAL_PG(x, v)                                              \
	(BIT_CLEAR_EXQ_AVAL_PG(x) | BIT_EXQ_AVAL_PG(v))

#define BIT_SHIFT_EXQ 16
#define BIT_MASK_EXQ 0xff
#define BIT_EXQ(x) (((x) & BIT_MASK_EXQ) << BIT_SHIFT_EXQ)
#define BITS_EXQ (BIT_MASK_EXQ << BIT_SHIFT_EXQ)
#define BIT_CLEAR_EXQ(x) ((x) & (~BITS_EXQ))
#define BIT_GET_EXQ(x) (((x) >> BIT_SHIFT_EXQ) & BIT_MASK_EXQ)
#define BIT_SET_EXQ(x, v) (BIT_CLEAR_EXQ(x) | BIT_EXQ(v))

#define BIT_SHIFT_NPQ 0
#define BIT_MASK_NPQ 0xff
#define BIT_NPQ(x) (((x) & BIT_MASK_NPQ) << BIT_SHIFT_NPQ)
#define BITS_NPQ (BIT_MASK_NPQ << BIT_SHIFT_NPQ)
#define BIT_CLEAR_NPQ(x) ((x) & (~BITS_NPQ))
#define BIT_GET_NPQ(x) (((x) >> BIT_SHIFT_NPQ) & BIT_MASK_NPQ)
#define BIT_SET_NPQ(x, v) (BIT_CLEAR_NPQ(x) | BIT_NPQ(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_TQPNT1				(Offset 0x0218) */

#define BIT_HPQ_INT_EN BIT(31)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_TQPNT1				(Offset 0x0218) */

#define BIT_SHIFT_NPQ_HIGH_TH 24
#define BIT_MASK_NPQ_HIGH_TH 0xff
#define BIT_NPQ_HIGH_TH(x)                                                     \
	(((x) & BIT_MASK_NPQ_HIGH_TH) << BIT_SHIFT_NPQ_HIGH_TH)
#define BITS_NPQ_HIGH_TH (BIT_MASK_NPQ_HIGH_TH << BIT_SHIFT_NPQ_HIGH_TH)
#define BIT_CLEAR_NPQ_HIGH_TH(x) ((x) & (~BITS_NPQ_HIGH_TH))
#define BIT_GET_NPQ_HIGH_TH(x)                                                 \
	(((x) >> BIT_SHIFT_NPQ_HIGH_TH) & BIT_MASK_NPQ_HIGH_TH)
#define BIT_SET_NPQ_HIGH_TH(x, v)                                              \
	(BIT_CLEAR_NPQ_HIGH_TH(x) | BIT_NPQ_HIGH_TH(v))

#define BIT_SHIFT_NPQ_LOW_TH 16
#define BIT_MASK_NPQ_LOW_TH 0xff
#define BIT_NPQ_LOW_TH(x) (((x) & BIT_MASK_NPQ_LOW_TH) << BIT_SHIFT_NPQ_LOW_TH)
#define BITS_NPQ_LOW_TH (BIT_MASK_NPQ_LOW_TH << BIT_SHIFT_NPQ_LOW_TH)
#define BIT_CLEAR_NPQ_LOW_TH(x) ((x) & (~BITS_NPQ_LOW_TH))
#define BIT_GET_NPQ_LOW_TH(x)                                                  \
	(((x) >> BIT_SHIFT_NPQ_LOW_TH) & BIT_MASK_NPQ_LOW_TH)
#define BIT_SET_NPQ_LOW_TH(x, v) (BIT_CLEAR_NPQ_LOW_TH(x) | BIT_NPQ_LOW_TH(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_TQPNT1				(Offset 0x0218) */

#define BIT_SHIFT_HPQ_HIGH_TH_V1 16
#define BIT_MASK_HPQ_HIGH_TH_V1 0xfff
#define BIT_HPQ_HIGH_TH_V1(x)                                                  \
	(((x) & BIT_MASK_HPQ_HIGH_TH_V1) << BIT_SHIFT_HPQ_HIGH_TH_V1)
#define BITS_HPQ_HIGH_TH_V1                                                    \
	(BIT_MASK_HPQ_HIGH_TH_V1 << BIT_SHIFT_HPQ_HIGH_TH_V1)
#define BIT_CLEAR_HPQ_HIGH_TH_V1(x) ((x) & (~BITS_HPQ_HIGH_TH_V1))
#define BIT_GET_HPQ_HIGH_TH_V1(x)                                              \
	(((x) >> BIT_SHIFT_HPQ_HIGH_TH_V1) & BIT_MASK_HPQ_HIGH_TH_V1)
#define BIT_SET_HPQ_HIGH_TH_V1(x, v)                                           \
	(BIT_CLEAR_HPQ_HIGH_TH_V1(x) | BIT_HPQ_HIGH_TH_V1(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_DMA_RQPN_INFO_PUB			(Offset 0x0218) */

#define BIT_SHIFT_PUB_AVAL_PG 16
#define BIT_MASK_PUB_AVAL_PG 0xfff
#define BIT_PUB_AVAL_PG(x)                                                     \
	(((x) & BIT_MASK_PUB_AVAL_PG) << BIT_SHIFT_PUB_AVAL_PG)
#define BITS_PUB_AVAL_PG (BIT_MASK_PUB_AVAL_PG << BIT_SHIFT_PUB_AVAL_PG)
#define BIT_CLEAR_PUB_AVAL_PG(x) ((x) & (~BITS_PUB_AVAL_PG))
#define BIT_GET_PUB_AVAL_PG(x)                                                 \
	(((x) >> BIT_SHIFT_PUB_AVAL_PG) & BIT_MASK_PUB_AVAL_PG)
#define BIT_SET_PUB_AVAL_PG(x, v)                                              \
	(BIT_CLEAR_PUB_AVAL_PG(x) | BIT_PUB_AVAL_PG(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_TQPNT1				(Offset 0x0218) */

#define BIT_SHIFT_HPQ_HIGH_TH 8
#define BIT_MASK_HPQ_HIGH_TH 0xff
#define BIT_HPQ_HIGH_TH(x)                                                     \
	(((x) & BIT_MASK_HPQ_HIGH_TH) << BIT_SHIFT_HPQ_HIGH_TH)
#define BITS_HPQ_HIGH_TH (BIT_MASK_HPQ_HIGH_TH << BIT_SHIFT_HPQ_HIGH_TH)
#define BIT_CLEAR_HPQ_HIGH_TH(x) ((x) & (~BITS_HPQ_HIGH_TH))
#define BIT_GET_HPQ_HIGH_TH(x)                                                 \
	(((x) >> BIT_SHIFT_HPQ_HIGH_TH) & BIT_MASK_HPQ_HIGH_TH)
#define BIT_SET_HPQ_HIGH_TH(x, v)                                              \
	(BIT_CLEAR_HPQ_HIGH_TH(x) | BIT_HPQ_HIGH_TH(v))

#define BIT_SHIFT_HPQ_LOW_TH 0
#define BIT_MASK_HPQ_LOW_TH 0xff
#define BIT_HPQ_LOW_TH(x) (((x) & BIT_MASK_HPQ_LOW_TH) << BIT_SHIFT_HPQ_LOW_TH)
#define BITS_HPQ_LOW_TH (BIT_MASK_HPQ_LOW_TH << BIT_SHIFT_HPQ_LOW_TH)
#define BIT_CLEAR_HPQ_LOW_TH(x) ((x) & (~BITS_HPQ_LOW_TH))
#define BIT_GET_HPQ_LOW_TH(x)                                                  \
	(((x) >> BIT_SHIFT_HPQ_LOW_TH) & BIT_MASK_HPQ_LOW_TH)
#define BIT_SET_HPQ_LOW_TH(x, v) (BIT_CLEAR_HPQ_LOW_TH(x) | BIT_HPQ_LOW_TH(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_TQPNT1				(Offset 0x0218) */

#define BIT_SHIFT_HPQ_LOW_TH_V1 0
#define BIT_MASK_HPQ_LOW_TH_V1 0xfff
#define BIT_HPQ_LOW_TH_V1(x)                                                   \
	(((x) & BIT_MASK_HPQ_LOW_TH_V1) << BIT_SHIFT_HPQ_LOW_TH_V1)
#define BITS_HPQ_LOW_TH_V1 (BIT_MASK_HPQ_LOW_TH_V1 << BIT_SHIFT_HPQ_LOW_TH_V1)
#define BIT_CLEAR_HPQ_LOW_TH_V1(x) ((x) & (~BITS_HPQ_LOW_TH_V1))
#define BIT_GET_HPQ_LOW_TH_V1(x)                                               \
	(((x) >> BIT_SHIFT_HPQ_LOW_TH_V1) & BIT_MASK_HPQ_LOW_TH_V1)
#define BIT_SET_HPQ_LOW_TH_V1(x, v)                                            \
	(BIT_CLEAR_HPQ_LOW_TH_V1(x) | BIT_HPQ_LOW_TH_V1(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_DMA_RQPN_INFO_PUB			(Offset 0x0218) */

#define BIT_SHIFT_PUB_RSVD_PG 0
#define BIT_MASK_PUB_RSVD_PG 0xfff
#define BIT_PUB_RSVD_PG(x)                                                     \
	(((x) & BIT_MASK_PUB_RSVD_PG) << BIT_SHIFT_PUB_RSVD_PG)
#define BITS_PUB_RSVD_PG (BIT_MASK_PUB_RSVD_PG << BIT_SHIFT_PUB_RSVD_PG)
#define BIT_CLEAR_PUB_RSVD_PG(x) ((x) & (~BITS_PUB_RSVD_PG))
#define BIT_GET_PUB_RSVD_PG(x)                                                 \
	(((x) >> BIT_SHIFT_PUB_RSVD_PG) & BIT_MASK_PUB_RSVD_PG)
#define BIT_SET_PUB_RSVD_PG(x, v)                                              \
	(BIT_CLEAR_PUB_RSVD_PG(x) | BIT_PUB_RSVD_PG(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_TQPNT2				(Offset 0x021C) */

#define BIT_NPQ_INT_EN BIT(31)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_RQPN_CTRL_2_V1			(Offset 0x021C) */

#define BIT_LD_RQPN_V1 BIT(31)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_TQPNT2				(Offset 0x021C) */

#define BIT_SHIFT_EXQ_HIGH_TH 24
#define BIT_MASK_EXQ_HIGH_TH 0xff
#define BIT_EXQ_HIGH_TH(x)                                                     \
	(((x) & BIT_MASK_EXQ_HIGH_TH) << BIT_SHIFT_EXQ_HIGH_TH)
#define BITS_EXQ_HIGH_TH (BIT_MASK_EXQ_HIGH_TH << BIT_SHIFT_EXQ_HIGH_TH)
#define BIT_CLEAR_EXQ_HIGH_TH(x) ((x) & (~BITS_EXQ_HIGH_TH))
#define BIT_GET_EXQ_HIGH_TH(x)                                                 \
	(((x) >> BIT_SHIFT_EXQ_HIGH_TH) & BIT_MASK_EXQ_HIGH_TH)
#define BIT_SET_EXQ_HIGH_TH(x, v)                                              \
	(BIT_CLEAR_EXQ_HIGH_TH(x) | BIT_EXQ_HIGH_TH(v))

#define BIT_SHIFT_EXQ_LOW_TH 16
#define BIT_MASK_EXQ_LOW_TH 0xff
#define BIT_EXQ_LOW_TH(x) (((x) & BIT_MASK_EXQ_LOW_TH) << BIT_SHIFT_EXQ_LOW_TH)
#define BITS_EXQ_LOW_TH (BIT_MASK_EXQ_LOW_TH << BIT_SHIFT_EXQ_LOW_TH)
#define BIT_CLEAR_EXQ_LOW_TH(x) ((x) & (~BITS_EXQ_LOW_TH))
#define BIT_GET_EXQ_LOW_TH(x)                                                  \
	(((x) >> BIT_SHIFT_EXQ_LOW_TH) & BIT_MASK_EXQ_LOW_TH)
#define BIT_SET_EXQ_LOW_TH(x, v) (BIT_CLEAR_EXQ_LOW_TH(x) | BIT_EXQ_LOW_TH(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_TQPNT2				(Offset 0x021C) */

#define BIT_SHIFT_NPQ_HIGH_TH_V1 16
#define BIT_MASK_NPQ_HIGH_TH_V1 0xfff
#define BIT_NPQ_HIGH_TH_V1(x)                                                  \
	(((x) & BIT_MASK_NPQ_HIGH_TH_V1) << BIT_SHIFT_NPQ_HIGH_TH_V1)
#define BITS_NPQ_HIGH_TH_V1                                                    \
	(BIT_MASK_NPQ_HIGH_TH_V1 << BIT_SHIFT_NPQ_HIGH_TH_V1)
#define BIT_CLEAR_NPQ_HIGH_TH_V1(x) ((x) & (~BITS_NPQ_HIGH_TH_V1))
#define BIT_GET_NPQ_HIGH_TH_V1(x)                                              \
	(((x) >> BIT_SHIFT_NPQ_HIGH_TH_V1) & BIT_MASK_NPQ_HIGH_TH_V1)
#define BIT_SET_NPQ_HIGH_TH_V1(x, v)                                           \
	(BIT_CLEAR_NPQ_HIGH_TH_V1(x) | BIT_NPQ_HIGH_TH_V1(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_RQPN_CTRL_2_V1			(Offset 0x021C) */

#define BIT_CH16_PUBLIC_DIS BIT(16)
#define BIT_CH15_PUBLIC_DIS BIT(15)
#define BIT_CH14_PUBLIC_DIS BIT(14)
#define BIT_CH13_PUBLIC_DIS BIT(13)
#define BIT_CH12_PUBLIC_DIS BIT(12)
#define BIT_CH11_PUBLIC_DIS BIT(11)
#define BIT_CH10_PUBLIC_DIS BIT(10)
#define BIT_CH9_PUBLIC_DIS BIT(9)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_TQPNT2				(Offset 0x021C) */

#define BIT_SHIFT_LPQ_HIGH_TH 8
#define BIT_MASK_LPQ_HIGH_TH 0xff
#define BIT_LPQ_HIGH_TH(x)                                                     \
	(((x) & BIT_MASK_LPQ_HIGH_TH) << BIT_SHIFT_LPQ_HIGH_TH)
#define BITS_LPQ_HIGH_TH (BIT_MASK_LPQ_HIGH_TH << BIT_SHIFT_LPQ_HIGH_TH)
#define BIT_CLEAR_LPQ_HIGH_TH(x) ((x) & (~BITS_LPQ_HIGH_TH))
#define BIT_GET_LPQ_HIGH_TH(x)                                                 \
	(((x) >> BIT_SHIFT_LPQ_HIGH_TH) & BIT_MASK_LPQ_HIGH_TH)
#define BIT_SET_LPQ_HIGH_TH(x, v)                                              \
	(BIT_CLEAR_LPQ_HIGH_TH(x) | BIT_LPQ_HIGH_TH(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_RQPN_CTRL_2_V1			(Offset 0x021C) */

#define BIT_CH8_PUBLIC_DIS BIT(8)
#define BIT_CH7_PUBLIC_DIS BIT(7)
#define BIT_CH6_PUBLIC_DIS BIT(6)
#define BIT_CH5_PUBLIC_DIS BIT(5)
#define BIT_CH4_PUBLIC_DIS BIT(4)
#define BIT_CH3_PUBLIC_DIS BIT(3)
#define BIT_CH2_PUBLIC_DIS BIT(2)
#define BIT_CH1_PUBLIC_DIS BIT(1)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_TQPNT2				(Offset 0x021C) */

#define BIT_SHIFT_LPQ_LOW_TH 0
#define BIT_MASK_LPQ_LOW_TH 0xff
#define BIT_LPQ_LOW_TH(x) (((x) & BIT_MASK_LPQ_LOW_TH) << BIT_SHIFT_LPQ_LOW_TH)
#define BITS_LPQ_LOW_TH (BIT_MASK_LPQ_LOW_TH << BIT_SHIFT_LPQ_LOW_TH)
#define BIT_CLEAR_LPQ_LOW_TH(x) ((x) & (~BITS_LPQ_LOW_TH))
#define BIT_GET_LPQ_LOW_TH(x)                                                  \
	(((x) >> BIT_SHIFT_LPQ_LOW_TH) & BIT_MASK_LPQ_LOW_TH)
#define BIT_SET_LPQ_LOW_TH(x, v) (BIT_CLEAR_LPQ_LOW_TH(x) | BIT_LPQ_LOW_TH(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_TQPNT2				(Offset 0x021C) */

#define BIT_SHIFT_NPQ_LOW_TH_V1 0
#define BIT_MASK_NPQ_LOW_TH_V1 0xfff
#define BIT_NPQ_LOW_TH_V1(x)                                                   \
	(((x) & BIT_MASK_NPQ_LOW_TH_V1) << BIT_SHIFT_NPQ_LOW_TH_V1)
#define BITS_NPQ_LOW_TH_V1 (BIT_MASK_NPQ_LOW_TH_V1 << BIT_SHIFT_NPQ_LOW_TH_V1)
#define BIT_CLEAR_NPQ_LOW_TH_V1(x) ((x) & (~BITS_NPQ_LOW_TH_V1))
#define BIT_GET_NPQ_LOW_TH_V1(x)                                               \
	(((x) >> BIT_SHIFT_NPQ_LOW_TH_V1) & BIT_MASK_NPQ_LOW_TH_V1)
#define BIT_SET_NPQ_LOW_TH_V1(x, v)                                            \
	(BIT_CLEAR_NPQ_LOW_TH_V1(x) | BIT_NPQ_LOW_TH_V1(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_RQPN_CTRL_2_V1			(Offset 0x021C) */

#define BIT_CH0_PUBLIC_DIS BIT(0)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_TQPNT3				(Offset 0x0220) */

#define BIT_LPQ_INT_EN BIT(31)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_BCN_CTRL_2				(Offset 0x0220) */

#define BIT_BCN0_EXT_VALID BIT(31)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_TQPNT3				(Offset 0x0220) */

#define BIT_SHIFT_LPQ_HIGH_TH_V1 16
#define BIT_MASK_LPQ_HIGH_TH_V1 0xfff
#define BIT_LPQ_HIGH_TH_V1(x)                                                  \
	(((x) & BIT_MASK_LPQ_HIGH_TH_V1) << BIT_SHIFT_LPQ_HIGH_TH_V1)
#define BITS_LPQ_HIGH_TH_V1                                                    \
	(BIT_MASK_LPQ_HIGH_TH_V1 << BIT_SHIFT_LPQ_HIGH_TH_V1)
#define BIT_CLEAR_LPQ_HIGH_TH_V1(x) ((x) & (~BITS_LPQ_HIGH_TH_V1))
#define BIT_GET_LPQ_HIGH_TH_V1(x)                                              \
	(((x) >> BIT_SHIFT_LPQ_HIGH_TH_V1) & BIT_MASK_LPQ_HIGH_TH_V1)
#define BIT_SET_LPQ_HIGH_TH_V1(x, v)                                           \
	(BIT_CLEAR_LPQ_HIGH_TH_V1(x) | BIT_LPQ_HIGH_TH_V1(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_BCN_CTRL_2				(Offset 0x0220) */

#define BIT_SHIFT_BCN0_EXT_HEAD 16
#define BIT_MASK_BCN0_EXT_HEAD 0xfff
#define BIT_BCN0_EXT_HEAD(x)                                                   \
	(((x) & BIT_MASK_BCN0_EXT_HEAD) << BIT_SHIFT_BCN0_EXT_HEAD)
#define BITS_BCN0_EXT_HEAD (BIT_MASK_BCN0_EXT_HEAD << BIT_SHIFT_BCN0_EXT_HEAD)
#define BIT_CLEAR_BCN0_EXT_HEAD(x) ((x) & (~BITS_BCN0_EXT_HEAD))
#define BIT_GET_BCN0_EXT_HEAD(x)                                               \
	(((x) >> BIT_SHIFT_BCN0_EXT_HEAD) & BIT_MASK_BCN0_EXT_HEAD)
#define BIT_SET_BCN0_EXT_HEAD(x, v)                                            \
	(BIT_CLEAR_BCN0_EXT_HEAD(x) | BIT_BCN0_EXT_HEAD(v))

#define BIT_SHIFT_TXPKTNUM_CH4_7 16
#define BIT_MASK_TXPKTNUM_CH4_7 0xfff
#define BIT_TXPKTNUM_CH4_7(x)                                                  \
	(((x) & BIT_MASK_TXPKTNUM_CH4_7) << BIT_SHIFT_TXPKTNUM_CH4_7)
#define BITS_TXPKTNUM_CH4_7                                                    \
	(BIT_MASK_TXPKTNUM_CH4_7 << BIT_SHIFT_TXPKTNUM_CH4_7)
#define BIT_CLEAR_TXPKTNUM_CH4_7(x) ((x) & (~BITS_TXPKTNUM_CH4_7))
#define BIT_GET_TXPKTNUM_CH4_7(x)                                              \
	(((x) >> BIT_SHIFT_TXPKTNUM_CH4_7) & BIT_MASK_TXPKTNUM_CH4_7)
#define BIT_SET_TXPKTNUM_CH4_7(x, v)                                           \
	(BIT_CLEAR_TXPKTNUM_CH4_7(x) | BIT_TXPKTNUM_CH4_7(v))

#define BIT_SHIFT_TXPKTNUM_CH12 16
#define BIT_MASK_TXPKTNUM_CH12 0xfff
#define BIT_TXPKTNUM_CH12(x)                                                   \
	(((x) & BIT_MASK_TXPKTNUM_CH12) << BIT_SHIFT_TXPKTNUM_CH12)
#define BITS_TXPKTNUM_CH12 (BIT_MASK_TXPKTNUM_CH12 << BIT_SHIFT_TXPKTNUM_CH12)
#define BIT_CLEAR_TXPKTNUM_CH12(x) ((x) & (~BITS_TXPKTNUM_CH12))
#define BIT_GET_TXPKTNUM_CH12(x)                                               \
	(((x) >> BIT_SHIFT_TXPKTNUM_CH12) & BIT_MASK_TXPKTNUM_CH12)
#define BIT_SET_TXPKTNUM_CH12(x, v)                                            \
	(BIT_CLEAR_TXPKTNUM_CH12(x) | BIT_TXPKTNUM_CH12(v))

#define BIT_SHIFT_TXPKTNUM_CH14_15 16
#define BIT_MASK_TXPKTNUM_CH14_15 0xfff
#define BIT_TXPKTNUM_CH14_15(x)                                                \
	(((x) & BIT_MASK_TXPKTNUM_CH14_15) << BIT_SHIFT_TXPKTNUM_CH14_15)
#define BITS_TXPKTNUM_CH14_15                                                  \
	(BIT_MASK_TXPKTNUM_CH14_15 << BIT_SHIFT_TXPKTNUM_CH14_15)
#define BIT_CLEAR_TXPKTNUM_CH14_15(x) ((x) & (~BITS_TXPKTNUM_CH14_15))
#define BIT_GET_TXPKTNUM_CH14_15(x)                                            \
	(((x) >> BIT_SHIFT_TXPKTNUM_CH14_15) & BIT_MASK_TXPKTNUM_CH14_15)
#define BIT_SET_TXPKTNUM_CH14_15(x, v)                                         \
	(BIT_CLEAR_TXPKTNUM_CH14_15(x) | BIT_TXPKTNUM_CH14_15(v))

#define BIT_BCN4_VALID BIT(15)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_TDE_DEBUG				(Offset 0x0220) */

#define BIT_SHIFT_TDE_DEBUG 0
#define BIT_MASK_TDE_DEBUG 0xffffffffL
#define BIT_TDE_DEBUG(x) (((x) & BIT_MASK_TDE_DEBUG) << BIT_SHIFT_TDE_DEBUG)
#define BITS_TDE_DEBUG (BIT_MASK_TDE_DEBUG << BIT_SHIFT_TDE_DEBUG)
#define BIT_CLEAR_TDE_DEBUG(x) ((x) & (~BITS_TDE_DEBUG))
#define BIT_GET_TDE_DEBUG(x) (((x) >> BIT_SHIFT_TDE_DEBUG) & BIT_MASK_TDE_DEBUG)
#define BIT_SET_TDE_DEBUG(x, v) (BIT_CLEAR_TDE_DEBUG(x) | BIT_TDE_DEBUG(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_TQPNT3				(Offset 0x0220) */

#define BIT_SHIFT_LPQ_LOW_TH_V1 0
#define BIT_MASK_LPQ_LOW_TH_V1 0xfff
#define BIT_LPQ_LOW_TH_V1(x)                                                   \
	(((x) & BIT_MASK_LPQ_LOW_TH_V1) << BIT_SHIFT_LPQ_LOW_TH_V1)
#define BITS_LPQ_LOW_TH_V1 (BIT_MASK_LPQ_LOW_TH_V1 << BIT_SHIFT_LPQ_LOW_TH_V1)
#define BIT_CLEAR_LPQ_LOW_TH_V1(x) ((x) & (~BITS_LPQ_LOW_TH_V1))
#define BIT_GET_LPQ_LOW_TH_V1(x)                                               \
	(((x) >> BIT_SHIFT_LPQ_LOW_TH_V1) & BIT_MASK_LPQ_LOW_TH_V1)
#define BIT_SET_LPQ_LOW_TH_V1(x, v)                                            \
	(BIT_CLEAR_LPQ_LOW_TH_V1(x) | BIT_LPQ_LOW_TH_V1(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_BCN_CTRL_2				(Offset 0x0220) */

#define BIT_SHIFT_BCN4_HEAD 0
#define BIT_MASK_BCN4_HEAD 0xfff
#define BIT_BCN4_HEAD(x) (((x) & BIT_MASK_BCN4_HEAD) << BIT_SHIFT_BCN4_HEAD)
#define BITS_BCN4_HEAD (BIT_MASK_BCN4_HEAD << BIT_SHIFT_BCN4_HEAD)
#define BIT_CLEAR_BCN4_HEAD(x) ((x) & (~BITS_BCN4_HEAD))
#define BIT_GET_BCN4_HEAD(x) (((x) >> BIT_SHIFT_BCN4_HEAD) & BIT_MASK_BCN4_HEAD)
#define BIT_SET_BCN4_HEAD(x, v) (BIT_CLEAR_BCN4_HEAD(x) | BIT_BCN4_HEAD(v))

#define BIT_SHIFT_TXPKTNUM_CH0_3 0
#define BIT_MASK_TXPKTNUM_CH0_3 0xfff
#define BIT_TXPKTNUM_CH0_3(x)                                                  \
	(((x) & BIT_MASK_TXPKTNUM_CH0_3) << BIT_SHIFT_TXPKTNUM_CH0_3)
#define BITS_TXPKTNUM_CH0_3                                                    \
	(BIT_MASK_TXPKTNUM_CH0_3 << BIT_SHIFT_TXPKTNUM_CH0_3)
#define BIT_CLEAR_TXPKTNUM_CH0_3(x) ((x) & (~BITS_TXPKTNUM_CH0_3))
#define BIT_GET_TXPKTNUM_CH0_3(x)                                              \
	(((x) >> BIT_SHIFT_TXPKTNUM_CH0_3) & BIT_MASK_TXPKTNUM_CH0_3)
#define BIT_SET_TXPKTNUM_CH0_3(x, v)                                           \
	(BIT_CLEAR_TXPKTNUM_CH0_3(x) | BIT_TXPKTNUM_CH0_3(v))

#define BIT_SHIFT_TXPKTNUM_CH8_11 0
#define BIT_MASK_TXPKTNUM_CH8_11 0xfff
#define BIT_TXPKTNUM_CH8_11(x)                                                 \
	(((x) & BIT_MASK_TXPKTNUM_CH8_11) << BIT_SHIFT_TXPKTNUM_CH8_11)
#define BITS_TXPKTNUM_CH8_11                                                   \
	(BIT_MASK_TXPKTNUM_CH8_11 << BIT_SHIFT_TXPKTNUM_CH8_11)
#define BIT_CLEAR_TXPKTNUM_CH8_11(x) ((x) & (~BITS_TXPKTNUM_CH8_11))
#define BIT_GET_TXPKTNUM_CH8_11(x)                                             \
	(((x) >> BIT_SHIFT_TXPKTNUM_CH8_11) & BIT_MASK_TXPKTNUM_CH8_11)
#define BIT_SET_TXPKTNUM_CH8_11(x, v)                                          \
	(BIT_CLEAR_TXPKTNUM_CH8_11(x) | BIT_TXPKTNUM_CH8_11(v))

#define BIT_SHIFT_TXPKTNUM_CH13 0
#define BIT_MASK_TXPKTNUM_CH13 0xfff
#define BIT_TXPKTNUM_CH13(x)                                                   \
	(((x) & BIT_MASK_TXPKTNUM_CH13) << BIT_SHIFT_TXPKTNUM_CH13)
#define BITS_TXPKTNUM_CH13 (BIT_MASK_TXPKTNUM_CH13 << BIT_SHIFT_TXPKTNUM_CH13)
#define BIT_CLEAR_TXPKTNUM_CH13(x) ((x) & (~BITS_TXPKTNUM_CH13))
#define BIT_GET_TXPKTNUM_CH13(x)                                               \
	(((x) >> BIT_SHIFT_TXPKTNUM_CH13) & BIT_MASK_TXPKTNUM_CH13)
#define BIT_SET_TXPKTNUM_CH13(x, v)                                            \
	(BIT_CLEAR_TXPKTNUM_CH13(x) | BIT_TXPKTNUM_CH13(v))

#define BIT_SHIFT_TXPKTNUM_CH16 0
#define BIT_MASK_TXPKTNUM_CH16 0xfff
#define BIT_TXPKTNUM_CH16(x)                                                   \
	(((x) & BIT_MASK_TXPKTNUM_CH16) << BIT_SHIFT_TXPKTNUM_CH16)
#define BITS_TXPKTNUM_CH16 (BIT_MASK_TXPKTNUM_CH16 << BIT_SHIFT_TXPKTNUM_CH16)
#define BIT_CLEAR_TXPKTNUM_CH16(x) ((x) & (~BITS_TXPKTNUM_CH16))
#define BIT_GET_TXPKTNUM_CH16(x)                                               \
	(((x) >> BIT_SHIFT_TXPKTNUM_CH16) & BIT_MASK_TXPKTNUM_CH16)
#define BIT_SET_TXPKTNUM_CH16(x, v)                                            \
	(BIT_CLEAR_TXPKTNUM_CH16(x) | BIT_TXPKTNUM_CH16(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_TQPNT4				(Offset 0x0224) */

#define BIT_EXQ_INT_EN BIT(31)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AUTO_LLT				(Offset 0x0224) */

#define BIT_SHIFT_TXPKTNUM_V1 24
#define BIT_MASK_TXPKTNUM_V1 0xff
#define BIT_TXPKTNUM_V1(x)                                                     \
	(((x) & BIT_MASK_TXPKTNUM_V1) << BIT_SHIFT_TXPKTNUM_V1)
#define BITS_TXPKTNUM_V1 (BIT_MASK_TXPKTNUM_V1 << BIT_SHIFT_TXPKTNUM_V1)
#define BIT_CLEAR_TXPKTNUM_V1(x) ((x) & (~BITS_TXPKTNUM_V1))
#define BIT_GET_TXPKTNUM_V1(x)                                                 \
	(((x) >> BIT_SHIFT_TXPKTNUM_V1) & BIT_MASK_TXPKTNUM_V1)
#define BIT_SET_TXPKTNUM_V1(x, v)                                              \
	(BIT_CLEAR_TXPKTNUM_V1(x) | BIT_TXPKTNUM_V1(v))

#define BIT_TDE_DBG_SEL BIT(23)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_AUTO_LLT				(Offset 0x0224) */

#define BIT_MASK_QSEL_DIFF BIT(22)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AUTO_LLT				(Offset 0x0224) */

#define BIT_AUTO_INIT_LLT BIT(16)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_TQPNT4				(Offset 0x0224) */

#define BIT_SHIFT_EXQ_HIGH_TH_V1 16
#define BIT_MASK_EXQ_HIGH_TH_V1 0xfff
#define BIT_EXQ_HIGH_TH_V1(x)                                                  \
	(((x) & BIT_MASK_EXQ_HIGH_TH_V1) << BIT_SHIFT_EXQ_HIGH_TH_V1)
#define BITS_EXQ_HIGH_TH_V1                                                    \
	(BIT_MASK_EXQ_HIGH_TH_V1 << BIT_SHIFT_EXQ_HIGH_TH_V1)
#define BIT_CLEAR_EXQ_HIGH_TH_V1(x) ((x) & (~BITS_EXQ_HIGH_TH_V1))
#define BIT_GET_EXQ_HIGH_TH_V1(x)                                              \
	(((x) >> BIT_SHIFT_EXQ_HIGH_TH_V1) & BIT_MASK_EXQ_HIGH_TH_V1)
#define BIT_SET_EXQ_HIGH_TH_V1(x, v)                                           \
	(BIT_CLEAR_EXQ_HIGH_TH_V1(x) | BIT_EXQ_HIGH_TH_V1(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_AUTO_LLT				(Offset 0x0224) */

#define BIT_SHIFT_TX_OQT_HE_FREE_SPACE 8
#define BIT_MASK_TX_OQT_HE_FREE_SPACE 0xff
#define BIT_TX_OQT_HE_FREE_SPACE(x)                                            \
	(((x) & BIT_MASK_TX_OQT_HE_FREE_SPACE)                                 \
	 << BIT_SHIFT_TX_OQT_HE_FREE_SPACE)
#define BITS_TX_OQT_HE_FREE_SPACE                                              \
	(BIT_MASK_TX_OQT_HE_FREE_SPACE << BIT_SHIFT_TX_OQT_HE_FREE_SPACE)
#define BIT_CLEAR_TX_OQT_HE_FREE_SPACE(x) ((x) & (~BITS_TX_OQT_HE_FREE_SPACE))
#define BIT_GET_TX_OQT_HE_FREE_SPACE(x)                                        \
	(((x) >> BIT_SHIFT_TX_OQT_HE_FREE_SPACE) &                             \
	 BIT_MASK_TX_OQT_HE_FREE_SPACE)
#define BIT_SET_TX_OQT_HE_FREE_SPACE(x, v)                                     \
	(BIT_CLEAR_TX_OQT_HE_FREE_SPACE(x) | BIT_TX_OQT_HE_FREE_SPACE(v))

#define BIT_SHIFT_TX_OQT_NL_FREE_SPACE 0
#define BIT_MASK_TX_OQT_NL_FREE_SPACE 0xff
#define BIT_TX_OQT_NL_FREE_SPACE(x)                                            \
	(((x) & BIT_MASK_TX_OQT_NL_FREE_SPACE)                                 \
	 << BIT_SHIFT_TX_OQT_NL_FREE_SPACE)
#define BITS_TX_OQT_NL_FREE_SPACE                                              \
	(BIT_MASK_TX_OQT_NL_FREE_SPACE << BIT_SHIFT_TX_OQT_NL_FREE_SPACE)
#define BIT_CLEAR_TX_OQT_NL_FREE_SPACE(x) ((x) & (~BITS_TX_OQT_NL_FREE_SPACE))
#define BIT_GET_TX_OQT_NL_FREE_SPACE(x)                                        \
	(((x) >> BIT_SHIFT_TX_OQT_NL_FREE_SPACE) &                             \
	 BIT_MASK_TX_OQT_NL_FREE_SPACE)
#define BIT_SET_TX_OQT_NL_FREE_SPACE(x, v)                                     \
	(BIT_CLEAR_TX_OQT_NL_FREE_SPACE(x) | BIT_TX_OQT_NL_FREE_SPACE(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_TQPNT4				(Offset 0x0224) */

#define BIT_SHIFT_EXQ_LOW_TH_V1 0
#define BIT_MASK_EXQ_LOW_TH_V1 0xfff
#define BIT_EXQ_LOW_TH_V1(x)                                                   \
	(((x) & BIT_MASK_EXQ_LOW_TH_V1) << BIT_SHIFT_EXQ_LOW_TH_V1)
#define BITS_EXQ_LOW_TH_V1 (BIT_MASK_EXQ_LOW_TH_V1 << BIT_SHIFT_EXQ_LOW_TH_V1)
#define BIT_CLEAR_EXQ_LOW_TH_V1(x) ((x) & (~BITS_EXQ_LOW_TH_V1))
#define BIT_GET_EXQ_LOW_TH_V1(x)                                               \
	(((x) >> BIT_SHIFT_EXQ_LOW_TH_V1) & BIT_MASK_EXQ_LOW_TH_V1)
#define BIT_SET_EXQ_LOW_TH_V1(x, v)                                            \
	(BIT_CLEAR_EXQ_LOW_TH_V1(x) | BIT_EXQ_LOW_TH_V1(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_DWBCN1_CTRL				(Offset 0x0228) */

#define BIT_SHIFT_BCN_HEAD_2 24
#define BIT_MASK_BCN_HEAD_2 0xff
#define BIT_BCN_HEAD_2(x) (((x) & BIT_MASK_BCN_HEAD_2) << BIT_SHIFT_BCN_HEAD_2)
#define BITS_BCN_HEAD_2 (BIT_MASK_BCN_HEAD_2 << BIT_SHIFT_BCN_HEAD_2)
#define BIT_CLEAR_BCN_HEAD_2(x) ((x) & (~BITS_BCN_HEAD_2))
#define BIT_GET_BCN_HEAD_2(x)                                                  \
	(((x) >> BIT_SHIFT_BCN_HEAD_2) & BIT_MASK_BCN_HEAD_2)
#define BIT_SET_BCN_HEAD_2(x, v) (BIT_CLEAR_BCN_HEAD_2(x) | BIT_BCN_HEAD_2(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_DWBCN1_CTRL				(Offset 0x0228) */

#define BIT_SW_BCN_SEL BIT(20)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_DWBCN1_CTRL				(Offset 0x0228) */

#define BIT_SHIFT_SW_BCN_SEL_V1 20
#define BIT_MASK_SW_BCN_SEL_V1 0x3
#define BIT_SW_BCN_SEL_V1(x)                                                   \
	(((x) & BIT_MASK_SW_BCN_SEL_V1) << BIT_SHIFT_SW_BCN_SEL_V1)
#define BITS_SW_BCN_SEL_V1 (BIT_MASK_SW_BCN_SEL_V1 << BIT_SHIFT_SW_BCN_SEL_V1)
#define BIT_CLEAR_SW_BCN_SEL_V1(x) ((x) & (~BITS_SW_BCN_SEL_V1))
#define BIT_GET_SW_BCN_SEL_V1(x)                                               \
	(((x) >> BIT_SHIFT_SW_BCN_SEL_V1) & BIT_MASK_SW_BCN_SEL_V1)
#define BIT_SET_SW_BCN_SEL_V1(x, v)                                            \
	(BIT_CLEAR_SW_BCN_SEL_V1(x) | BIT_SW_BCN_SEL_V1(v))

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_RQPN_CTRL_1				(Offset 0x0228) */

#define BIT_ENABLE_GEN_RANDON_SLOT_TX BIT(20)
#define BIT_ENABLE_RANDOM_SHIFT_TX BIT(19)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_DWBCN1_CTRL				(Offset 0x0228) */

#define BIT_BCN_VALID_2 BIT(18)

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_RQPN_CTRL_1				(Offset 0x0228) */

#define BIT_ENABLE_EDCA_REF_FUNCTION BIT(18)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_DWBCN1_CTRL				(Offset 0x0228) */

#define BIT_SW_BCN_SEL_EN BIT(17)
#define BIT_BCN_VALID_1 BIT(16)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_RQPN_CTRL_1				(Offset 0x0228) */

#define BIT_SHIFT_TXPKTNUM_H 16
#define BIT_MASK_TXPKTNUM_H 0xffff
#define BIT_TXPKTNUM_H(x) (((x) & BIT_MASK_TXPKTNUM_H) << BIT_SHIFT_TXPKTNUM_H)
#define BITS_TXPKTNUM_H (BIT_MASK_TXPKTNUM_H << BIT_SHIFT_TXPKTNUM_H)
#define BIT_CLEAR_TXPKTNUM_H(x) ((x) & (~BITS_TXPKTNUM_H))
#define BIT_GET_TXPKTNUM_H(x)                                                  \
	(((x) >> BIT_SHIFT_TXPKTNUM_H) & BIT_MASK_TXPKTNUM_H)
#define BIT_SET_TXPKTNUM_H(x, v) (BIT_CLEAR_TXPKTNUM_H(x) | BIT_TXPKTNUM_H(v))

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_RQPN_CTRL_1				(Offset 0x0228) */

#define BIT_SHIFT_TXPKTNUM_H_V2 16
#define BIT_MASK_TXPKTNUM_H_V2 0xfff
#define BIT_TXPKTNUM_H_V2(x)                                                   \
	(((x) & BIT_MASK_TXPKTNUM_H_V2) << BIT_SHIFT_TXPKTNUM_H_V2)
#define BITS_TXPKTNUM_H_V2 (BIT_MASK_TXPKTNUM_H_V2 << BIT_SHIFT_TXPKTNUM_H_V2)
#define BIT_CLEAR_TXPKTNUM_H_V2(x) ((x) & (~BITS_TXPKTNUM_H_V2))
#define BIT_GET_TXPKTNUM_H_V2(x)                                               \
	(((x) >> BIT_SHIFT_TXPKTNUM_H_V2) & BIT_MASK_TXPKTNUM_H_V2)
#define BIT_SET_TXPKTNUM_H_V2(x, v)                                            \
	(BIT_CLEAR_TXPKTNUM_H_V2(x) | BIT_TXPKTNUM_H_V2(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_DWBCN1_CTRL				(Offset 0x0228) */

#define BIT_ADJUSTABLE_SIZE_EN BIT(15)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_DWBCN1_CTRL				(Offset 0x0228) */

#define BIT_SHIFT_BCN_HEAD_1 8
#define BIT_MASK_BCN_HEAD_1 0xff
#define BIT_BCN_HEAD_1(x) (((x) & BIT_MASK_BCN_HEAD_1) << BIT_SHIFT_BCN_HEAD_1)
#define BITS_BCN_HEAD_1 (BIT_MASK_BCN_HEAD_1 << BIT_SHIFT_BCN_HEAD_1)
#define BIT_CLEAR_BCN_HEAD_1(x) ((x) & (~BITS_BCN_HEAD_1))
#define BIT_GET_BCN_HEAD_1(x)                                                  \
	(((x) >> BIT_SHIFT_BCN_HEAD_1) & BIT_MASK_BCN_HEAD_1)
#define BIT_SET_BCN_HEAD_1(x, v) (BIT_CLEAR_BCN_HEAD_1(x) | BIT_BCN_HEAD_1(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_RQPN_CTRL_1				(Offset 0x0228) */

#define BIT_RST_PGSUB_CNT BIT(1)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_DWBCN1_CTRL				(Offset 0x0228) */

#define BIT_SHIFT_MAX_TX_PKT_FOR_USB_AND_SDIO 0
#define BIT_MASK_MAX_TX_PKT_FOR_USB_AND_SDIO 0xff
#define BIT_MAX_TX_PKT_FOR_USB_AND_SDIO(x)                                     \
	(((x) & BIT_MASK_MAX_TX_PKT_FOR_USB_AND_SDIO)                          \
	 << BIT_SHIFT_MAX_TX_PKT_FOR_USB_AND_SDIO)
#define BITS_MAX_TX_PKT_FOR_USB_AND_SDIO                                       \
	(BIT_MASK_MAX_TX_PKT_FOR_USB_AND_SDIO                                  \
	 << BIT_SHIFT_MAX_TX_PKT_FOR_USB_AND_SDIO)
#define BIT_CLEAR_MAX_TX_PKT_FOR_USB_AND_SDIO(x)                               \
	((x) & (~BITS_MAX_TX_PKT_FOR_USB_AND_SDIO))
#define BIT_GET_MAX_TX_PKT_FOR_USB_AND_SDIO(x)                                 \
	(((x) >> BIT_SHIFT_MAX_TX_PKT_FOR_USB_AND_SDIO) &                      \
	 BIT_MASK_MAX_TX_PKT_FOR_USB_AND_SDIO)
#define BIT_SET_MAX_TX_PKT_FOR_USB_AND_SDIO(x, v)                              \
	(BIT_CLEAR_MAX_TX_PKT_FOR_USB_AND_SDIO(x) |                            \
	 BIT_MAX_TX_PKT_FOR_USB_AND_SDIO(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_DWBCN1_CTRL				(Offset 0x0228) */

#define BIT_SHIFT_ALIGNMENT_SIZE 0
#define BIT_MASK_ALIGNMENT_SIZE 0xfff
#define BIT_ALIGNMENT_SIZE(x)                                                  \
	(((x) & BIT_MASK_ALIGNMENT_SIZE) << BIT_SHIFT_ALIGNMENT_SIZE)
#define BITS_ALIGNMENT_SIZE                                                    \
	(BIT_MASK_ALIGNMENT_SIZE << BIT_SHIFT_ALIGNMENT_SIZE)
#define BIT_CLEAR_ALIGNMENT_SIZE(x) ((x) & (~BITS_ALIGNMENT_SIZE))
#define BIT_GET_ALIGNMENT_SIZE(x)                                              \
	(((x) >> BIT_SHIFT_ALIGNMENT_SIZE) & BIT_MASK_ALIGNMENT_SIZE)
#define BIT_SET_ALIGNMENT_SIZE(x, v)                                           \
	(BIT_CLEAR_ALIGNMENT_SIZE(x) | BIT_ALIGNMENT_SIZE(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_RQPN_CTRL_1				(Offset 0x0228) */

#define BIT_SHIFT_TXPKTNUM_H_V1 0
#define BIT_MASK_TXPKTNUM_H_V1 0xffff
#define BIT_TXPKTNUM_H_V1(x)                                                   \
	(((x) & BIT_MASK_TXPKTNUM_H_V1) << BIT_SHIFT_TXPKTNUM_H_V1)
#define BITS_TXPKTNUM_H_V1 (BIT_MASK_TXPKTNUM_H_V1 << BIT_SHIFT_TXPKTNUM_H_V1)
#define BIT_CLEAR_TXPKTNUM_H_V1(x) ((x) & (~BITS_TXPKTNUM_H_V1))
#define BIT_GET_TXPKTNUM_H_V1(x)                                               \
	(((x) >> BIT_SHIFT_TXPKTNUM_H_V1) & BIT_MASK_TXPKTNUM_H_V1)
#define BIT_SET_TXPKTNUM_H_V1(x, v)                                            \
	(BIT_CLEAR_TXPKTNUM_H_V1(x) | BIT_TXPKTNUM_H_V1(v))

#endif

#if (HALMAC_8197G_SUPPORT)

/* 2 REG_RQPN_CTRL_1				(Offset 0x0228) */

#define BIT_SHIFT_TXPKTNUM_H_V3 0
#define BIT_MASK_TXPKTNUM_H_V3 0xfff
#define BIT_TXPKTNUM_H_V3(x)                                                   \
	(((x) & BIT_MASK_TXPKTNUM_H_V3) << BIT_SHIFT_TXPKTNUM_H_V3)
#define BITS_TXPKTNUM_H_V3 (BIT_MASK_TXPKTNUM_H_V3 << BIT_SHIFT_TXPKTNUM_H_V3)
#define BIT_CLEAR_TXPKTNUM_H_V3(x) ((x) & (~BITS_TXPKTNUM_H_V3))
#define BIT_GET_TXPKTNUM_H_V3(x)                                               \
	(((x) >> BIT_SHIFT_TXPKTNUM_H_V3) & BIT_MASK_TXPKTNUM_H_V3)
#define BIT_SET_TXPKTNUM_H_V3(x, v)                                            \
	(BIT_CLEAR_TXPKTNUM_H_V3(x) | BIT_TXPKTNUM_H_V3(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_RQPN_CTRL_1				(Offset 0x0228) */

#define BIT_SHIFT_TXPKTNUM_V3 0
#define BIT_MASK_TXPKTNUM_V3 0xfff
#define BIT_TXPKTNUM_V3(x)                                                     \
	(((x) & BIT_MASK_TXPKTNUM_V3) << BIT_SHIFT_TXPKTNUM_V3)
#define BITS_TXPKTNUM_V3 (BIT_MASK_TXPKTNUM_V3 << BIT_SHIFT_TXPKTNUM_V3)
#define BIT_CLEAR_TXPKTNUM_V3(x) ((x) & (~BITS_TXPKTNUM_V3))
#define BIT_GET_TXPKTNUM_V3(x)                                                 \
	(((x) >> BIT_SHIFT_TXPKTNUM_V3) & BIT_MASK_TXPKTNUM_V3)
#define BIT_SET_TXPKTNUM_V3(x, v)                                              \
	(BIT_CLEAR_TXPKTNUM_V3(x) | BIT_TXPKTNUM_V3(v))

#define BIT_PGSUB_CNT_EN BIT(0)

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT)

/* 2 REG_RQPN_CTRL_1				(Offset 0x0228) */

#define BIT_SHIFT_TXPKTNUM_V2 0
#define BIT_MASK_TXPKTNUM_V2 0xffff
#define BIT_TXPKTNUM_V2(x)                                                     \
	(((x) & BIT_MASK_TXPKTNUM_V2) << BIT_SHIFT_TXPKTNUM_V2)
#define BITS_TXPKTNUM_V2 (BIT_MASK_TXPKTNUM_V2 << BIT_SHIFT_TXPKTNUM_V2)
#define BIT_CLEAR_TXPKTNUM_V2(x) ((x) & (~BITS_TXPKTNUM_V2))
#define BIT_GET_TXPKTNUM_V2(x)                                                 \
	(((x) >> BIT_SHIFT_TXPKTNUM_V2) & BIT_MASK_TXPKTNUM_V2)
#define BIT_SET_TXPKTNUM_V2(x, v)                                              \
	(BIT_CLEAR_TXPKTNUM_V2(x) | BIT_TXPKTNUM_V2(v))

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_RQPN_CTRL_2				(Offset 0x022C) */

#define BIT_EX2Q_PUBLIC_DIS_V1 BIT(21)
#define BIT_EX1Q_PUBLIC_DIS_V1 BIT(20)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_RQPN_CTRL_2				(Offset 0x022C) */

#define BIT_EXQ_PUBLIC_DIS_V1 BIT(19)
#define BIT_NPQ_PUBLIC_DIS_V1 BIT(18)
#define BIT_LPQ_PUBLIC_DIS_V1 BIT(17)
#define BIT_HPQ_PUBLIC_DIS_V1 BIT(16)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_RQPN_CTRL_2				(Offset 0x022C) */

#define BIT_SDIO_TXAGG_ALIGN_ADJUST_EN BIT(15)

#define BIT_SHIFT_SDIO_TXAGG_ALIGN_SIZE 0
#define BIT_MASK_SDIO_TXAGG_ALIGN_SIZE 0xfff
#define BIT_SDIO_TXAGG_ALIGN_SIZE(x)                                           \
	(((x) & BIT_MASK_SDIO_TXAGG_ALIGN_SIZE)                                \
	 << BIT_SHIFT_SDIO_TXAGG_ALIGN_SIZE)
#define BITS_SDIO_TXAGG_ALIGN_SIZE                                             \
	(BIT_MASK_SDIO_TXAGG_ALIGN_SIZE << BIT_SHIFT_SDIO_TXAGG_ALIGN_SIZE)
#define BIT_CLEAR_SDIO_TXAGG_ALIGN_SIZE(x) ((x) & (~BITS_SDIO_TXAGG_ALIGN_SIZE))
#define BIT_GET_SDIO_TXAGG_ALIGN_SIZE(x)                                       \
	(((x) >> BIT_SHIFT_SDIO_TXAGG_ALIGN_SIZE) &                            \
	 BIT_MASK_SDIO_TXAGG_ALIGN_SIZE)
#define BIT_SET_SDIO_TXAGG_ALIGN_SIZE(x, v)                                    \
	(BIT_CLEAR_SDIO_TXAGG_ALIGN_SIZE(x) | BIT_SDIO_TXAGG_ALIGN_SIZE(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_RQPN_EXQ1_EXQ2			(Offset 0x0230) */

#define BIT_SHIFT_EXQ2_AVAL_PG 24
#define BIT_MASK_EXQ2_AVAL_PG 0xff
#define BIT_EXQ2_AVAL_PG(x)                                                    \
	(((x) & BIT_MASK_EXQ2_AVAL_PG) << BIT_SHIFT_EXQ2_AVAL_PG)
#define BITS_EXQ2_AVAL_PG (BIT_MASK_EXQ2_AVAL_PG << BIT_SHIFT_EXQ2_AVAL_PG)
#define BIT_CLEAR_EXQ2_AVAL_PG(x) ((x) & (~BITS_EXQ2_AVAL_PG))
#define BIT_GET_EXQ2_AVAL_PG(x)                                                \
	(((x) >> BIT_SHIFT_EXQ2_AVAL_PG) & BIT_MASK_EXQ2_AVAL_PG)
#define BIT_SET_EXQ2_AVAL_PG(x, v)                                             \
	(BIT_CLEAR_EXQ2_AVAL_PG(x) | BIT_EXQ2_AVAL_PG(v))

#define BIT_SHIFT_EXQ2 16
#define BIT_MASK_EXQ2 0xff
#define BIT_EXQ2(x) (((x) & BIT_MASK_EXQ2) << BIT_SHIFT_EXQ2)
#define BITS_EXQ2 (BIT_MASK_EXQ2 << BIT_SHIFT_EXQ2)
#define BIT_CLEAR_EXQ2(x) ((x) & (~BITS_EXQ2))
#define BIT_GET_EXQ2(x) (((x) >> BIT_SHIFT_EXQ2) & BIT_MASK_EXQ2)
#define BIT_SET_EXQ2(x, v) (BIT_CLEAR_EXQ2(x) | BIT_EXQ2(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FIFOPAGE_INFO_1			(Offset 0x0230) */

#define BIT_SHIFT_HPQ_AVAL_PG_V1 16
#define BIT_MASK_HPQ_AVAL_PG_V1 0xfff
#define BIT_HPQ_AVAL_PG_V1(x)                                                  \
	(((x) & BIT_MASK_HPQ_AVAL_PG_V1) << BIT_SHIFT_HPQ_AVAL_PG_V1)
#define BITS_HPQ_AVAL_PG_V1                                                    \
	(BIT_MASK_HPQ_AVAL_PG_V1 << BIT_SHIFT_HPQ_AVAL_PG_V1)
#define BIT_CLEAR_HPQ_AVAL_PG_V1(x) ((x) & (~BITS_HPQ_AVAL_PG_V1))
#define BIT_GET_HPQ_AVAL_PG_V1(x)                                              \
	(((x) >> BIT_SHIFT_HPQ_AVAL_PG_V1) & BIT_MASK_HPQ_AVAL_PG_V1)
#define BIT_SET_HPQ_AVAL_PG_V1(x, v)                                           \
	(BIT_CLEAR_HPQ_AVAL_PG_V1(x) | BIT_HPQ_AVAL_PG_V1(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_RQPN_EXQ1_EXQ2			(Offset 0x0230) */

#define BIT_SHIFT_EXQ1_AVAL_PG 8
#define BIT_MASK_EXQ1_AVAL_PG 0xff
#define BIT_EXQ1_AVAL_PG(x)                                                    \
	(((x) & BIT_MASK_EXQ1_AVAL_PG) << BIT_SHIFT_EXQ1_AVAL_PG)
#define BITS_EXQ1_AVAL_PG (BIT_MASK_EXQ1_AVAL_PG << BIT_SHIFT_EXQ1_AVAL_PG)
#define BIT_CLEAR_EXQ1_AVAL_PG(x) ((x) & (~BITS_EXQ1_AVAL_PG))
#define BIT_GET_EXQ1_AVAL_PG(x)                                                \
	(((x) >> BIT_SHIFT_EXQ1_AVAL_PG) & BIT_MASK_EXQ1_AVAL_PG)
#define BIT_SET_EXQ1_AVAL_PG(x, v)                                             \
	(BIT_CLEAR_EXQ1_AVAL_PG(x) | BIT_EXQ1_AVAL_PG(v))

#define BIT_SHIFT_EXQ1 0
#define BIT_MASK_EXQ1 0xff
#define BIT_EXQ1(x) (((x) & BIT_MASK_EXQ1) << BIT_SHIFT_EXQ1)
#define BITS_EXQ1 (BIT_MASK_EXQ1 << BIT_SHIFT_EXQ1)
#define BIT_CLEAR_EXQ1(x) ((x) & (~BITS_EXQ1))
#define BIT_GET_EXQ1(x) (((x) >> BIT_SHIFT_EXQ1) & BIT_MASK_EXQ1)
#define BIT_SET_EXQ1(x, v) (BIT_CLEAR_EXQ1(x) | BIT_EXQ1(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FIFOPAGE_INFO_1			(Offset 0x0230) */

#define BIT_SHIFT_HPQ_V1 0
#define BIT_MASK_HPQ_V1 0xfff
#define BIT_HPQ_V1(x) (((x) & BIT_MASK_HPQ_V1) << BIT_SHIFT_HPQ_V1)
#define BITS_HPQ_V1 (BIT_MASK_HPQ_V1 << BIT_SHIFT_HPQ_V1)
#define BIT_CLEAR_HPQ_V1(x) ((x) & (~BITS_HPQ_V1))
#define BIT_GET_HPQ_V1(x) (((x) >> BIT_SHIFT_HPQ_V1) & BIT_MASK_HPQ_V1)
#define BIT_SET_HPQ_V1(x, v) (BIT_CLEAR_HPQ_V1(x) | BIT_HPQ_V1(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_TQPNT3_V1				(Offset 0x0234) */

#define BIT_SHIFT_EXQ2_HIGH_TH 24
#define BIT_MASK_EXQ2_HIGH_TH 0xff
#define BIT_EXQ2_HIGH_TH(x)                                                    \
	(((x) & BIT_MASK_EXQ2_HIGH_TH) << BIT_SHIFT_EXQ2_HIGH_TH)
#define BITS_EXQ2_HIGH_TH (BIT_MASK_EXQ2_HIGH_TH << BIT_SHIFT_EXQ2_HIGH_TH)
#define BIT_CLEAR_EXQ2_HIGH_TH(x) ((x) & (~BITS_EXQ2_HIGH_TH))
#define BIT_GET_EXQ2_HIGH_TH(x)                                                \
	(((x) >> BIT_SHIFT_EXQ2_HIGH_TH) & BIT_MASK_EXQ2_HIGH_TH)
#define BIT_SET_EXQ2_HIGH_TH(x, v)                                             \
	(BIT_CLEAR_EXQ2_HIGH_TH(x) | BIT_EXQ2_HIGH_TH(v))

#define BIT_SHIFT_EXQ2_LOW_TH 16
#define BIT_MASK_EXQ2_LOW_TH 0xff
#define BIT_EXQ2_LOW_TH(x)                                                     \
	(((x) & BIT_MASK_EXQ2_LOW_TH) << BIT_SHIFT_EXQ2_LOW_TH)
#define BITS_EXQ2_LOW_TH (BIT_MASK_EXQ2_LOW_TH << BIT_SHIFT_EXQ2_LOW_TH)
#define BIT_CLEAR_EXQ2_LOW_TH(x) ((x) & (~BITS_EXQ2_LOW_TH))
#define BIT_GET_EXQ2_LOW_TH(x)                                                 \
	(((x) >> BIT_SHIFT_EXQ2_LOW_TH) & BIT_MASK_EXQ2_LOW_TH)
#define BIT_SET_EXQ2_LOW_TH(x, v)                                              \
	(BIT_CLEAR_EXQ2_LOW_TH(x) | BIT_EXQ2_LOW_TH(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FIFOPAGE_INFO_2			(Offset 0x0234) */

#define BIT_SHIFT_LPQ_AVAL_PG_V1 16
#define BIT_MASK_LPQ_AVAL_PG_V1 0xfff
#define BIT_LPQ_AVAL_PG_V1(x)                                                  \
	(((x) & BIT_MASK_LPQ_AVAL_PG_V1) << BIT_SHIFT_LPQ_AVAL_PG_V1)
#define BITS_LPQ_AVAL_PG_V1                                                    \
	(BIT_MASK_LPQ_AVAL_PG_V1 << BIT_SHIFT_LPQ_AVAL_PG_V1)
#define BIT_CLEAR_LPQ_AVAL_PG_V1(x) ((x) & (~BITS_LPQ_AVAL_PG_V1))
#define BIT_GET_LPQ_AVAL_PG_V1(x)                                              \
	(((x) >> BIT_SHIFT_LPQ_AVAL_PG_V1) & BIT_MASK_LPQ_AVAL_PG_V1)
#define BIT_SET_LPQ_AVAL_PG_V1(x, v)                                           \
	(BIT_CLEAR_LPQ_AVAL_PG_V1(x) | BIT_LPQ_AVAL_PG_V1(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_TQPNT3_V1				(Offset 0x0234) */

#define BIT_SHIFT_EXQ1_HIGH_TH 8
#define BIT_MASK_EXQ1_HIGH_TH 0xff
#define BIT_EXQ1_HIGH_TH(x)                                                    \
	(((x) & BIT_MASK_EXQ1_HIGH_TH) << BIT_SHIFT_EXQ1_HIGH_TH)
#define BITS_EXQ1_HIGH_TH (BIT_MASK_EXQ1_HIGH_TH << BIT_SHIFT_EXQ1_HIGH_TH)
#define BIT_CLEAR_EXQ1_HIGH_TH(x) ((x) & (~BITS_EXQ1_HIGH_TH))
#define BIT_GET_EXQ1_HIGH_TH(x)                                                \
	(((x) >> BIT_SHIFT_EXQ1_HIGH_TH) & BIT_MASK_EXQ1_HIGH_TH)
#define BIT_SET_EXQ1_HIGH_TH(x, v)                                             \
	(BIT_CLEAR_EXQ1_HIGH_TH(x) | BIT_EXQ1_HIGH_TH(v))

#define BIT_SHIFT_EXQ1_LOW_TH 0
#define BIT_MASK_EXQ1_LOW_TH 0xff
#define BIT_EXQ1_LOW_TH(x)                                                     \
	(((x) & BIT_MASK_EXQ1_LOW_TH) << BIT_SHIFT_EXQ1_LOW_TH)
#define BITS_EXQ1_LOW_TH (BIT_MASK_EXQ1_LOW_TH << BIT_SHIFT_EXQ1_LOW_TH)
#define BIT_CLEAR_EXQ1_LOW_TH(x) ((x) & (~BITS_EXQ1_LOW_TH))
#define BIT_GET_EXQ1_LOW_TH(x)                                                 \
	(((x) >> BIT_SHIFT_EXQ1_LOW_TH) & BIT_MASK_EXQ1_LOW_TH)
#define BIT_SET_EXQ1_LOW_TH(x, v)                                              \
	(BIT_CLEAR_EXQ1_LOW_TH(x) | BIT_EXQ1_LOW_TH(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FIFOPAGE_INFO_2			(Offset 0x0234) */

#define BIT_SHIFT_LPQ_V1 0
#define BIT_MASK_LPQ_V1 0xfff
#define BIT_LPQ_V1(x) (((x) & BIT_MASK_LPQ_V1) << BIT_SHIFT_LPQ_V1)
#define BITS_LPQ_V1 (BIT_MASK_LPQ_V1 << BIT_SHIFT_LPQ_V1)
#define BIT_CLEAR_LPQ_V1(x) ((x) & (~BITS_LPQ_V1))
#define BIT_GET_LPQ_V1(x) (((x) >> BIT_SHIFT_LPQ_V1) & BIT_MASK_LPQ_V1)
#define BIT_SET_LPQ_V1(x, v) (BIT_CLEAR_LPQ_V1(x) | BIT_LPQ_V1(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FIFOPAGE_INFO_3			(Offset 0x0238) */

#define BIT_SHIFT_NPQ_AVAL_PG_V1 16
#define BIT_MASK_NPQ_AVAL_PG_V1 0xfff
#define BIT_NPQ_AVAL_PG_V1(x)                                                  \
	(((x) & BIT_MASK_NPQ_AVAL_PG_V1) << BIT_SHIFT_NPQ_AVAL_PG_V1)
#define BITS_NPQ_AVAL_PG_V1                                                    \
	(BIT_MASK_NPQ_AVAL_PG_V1 << BIT_SHIFT_NPQ_AVAL_PG_V1)
#define BIT_CLEAR_NPQ_AVAL_PG_V1(x) ((x) & (~BITS_NPQ_AVAL_PG_V1))
#define BIT_GET_NPQ_AVAL_PG_V1(x)                                              \
	(((x) >> BIT_SHIFT_NPQ_AVAL_PG_V1) & BIT_MASK_NPQ_AVAL_PG_V1)
#define BIT_SET_NPQ_AVAL_PG_V1(x, v)                                           \
	(BIT_CLEAR_NPQ_AVAL_PG_V1(x) | BIT_NPQ_AVAL_PG_V1(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FIFOPAGE_INFO_3			(Offset 0x0238) */

#define BIT_SHIFT_NPQ_V1 0
#define BIT_MASK_NPQ_V1 0xfff
#define BIT_NPQ_V1(x) (((x) & BIT_MASK_NPQ_V1) << BIT_SHIFT_NPQ_V1)
#define BITS_NPQ_V1 (BIT_MASK_NPQ_V1 << BIT_SHIFT_NPQ_V1)
#define BIT_CLEAR_NPQ_V1(x) ((x) & (~BITS_NPQ_V1))
#define BIT_GET_NPQ_V1(x) (((x) >> BIT_SHIFT_NPQ_V1) & BIT_MASK_NPQ_V1)
#define BIT_SET_NPQ_V1(x, v) (BIT_CLEAR_NPQ_V1(x) | BIT_NPQ_V1(v))

/* 2 REG_FIFOPAGE_INFO_4			(Offset 0x023C) */

#define BIT_SHIFT_EXQ_AVAL_PG_V1 16
#define BIT_MASK_EXQ_AVAL_PG_V1 0xfff
#define BIT_EXQ_AVAL_PG_V1(x)                                                  \
	(((x) & BIT_MASK_EXQ_AVAL_PG_V1) << BIT_SHIFT_EXQ_AVAL_PG_V1)
#define BITS_EXQ_AVAL_PG_V1                                                    \
	(BIT_MASK_EXQ_AVAL_PG_V1 << BIT_SHIFT_EXQ_AVAL_PG_V1)
#define BIT_CLEAR_EXQ_AVAL_PG_V1(x) ((x) & (~BITS_EXQ_AVAL_PG_V1))
#define BIT_GET_EXQ_AVAL_PG_V1(x)                                              \
	(((x) >> BIT_SHIFT_EXQ_AVAL_PG_V1) & BIT_MASK_EXQ_AVAL_PG_V1)
#define BIT_SET_EXQ_AVAL_PG_V1(x, v)                                           \
	(BIT_CLEAR_EXQ_AVAL_PG_V1(x) | BIT_EXQ_AVAL_PG_V1(v))

#define BIT_SHIFT_EXQ_V1 0
#define BIT_MASK_EXQ_V1 0xfff
#define BIT_EXQ_V1(x) (((x) & BIT_MASK_EXQ_V1) << BIT_SHIFT_EXQ_V1)
#define BITS_EXQ_V1 (BIT_MASK_EXQ_V1 << BIT_SHIFT_EXQ_V1)
#define BIT_CLEAR_EXQ_V1(x) ((x) & (~BITS_EXQ_V1))
#define BIT_GET_EXQ_V1(x) (((x) >> BIT_SHIFT_EXQ_V1) & BIT_MASK_EXQ_V1)
#define BIT_SET_EXQ_V1(x, v) (BIT_CLEAR_EXQ_V1(x) | BIT_EXQ_V1(v))

/* 2 REG_FIFOPAGE_INFO_5			(Offset 0x0240) */

#define BIT_SHIFT_PUBQ_AVAL_PG_V1 16
#define BIT_MASK_PUBQ_AVAL_PG_V1 0xfff
#define BIT_PUBQ_AVAL_PG_V1(x)                                                 \
	(((x) & BIT_MASK_PUBQ_AVAL_PG_V1) << BIT_SHIFT_PUBQ_AVAL_PG_V1)
#define BITS_PUBQ_AVAL_PG_V1                                                   \
	(BIT_MASK_PUBQ_AVAL_PG_V1 << BIT_SHIFT_PUBQ_AVAL_PG_V1)
#define BIT_CLEAR_PUBQ_AVAL_PG_V1(x) ((x) & (~BITS_PUBQ_AVAL_PG_V1))
#define BIT_GET_PUBQ_AVAL_PG_V1(x)                                             \
	(((x) >> BIT_SHIFT_PUBQ_AVAL_PG_V1) & BIT_MASK_PUBQ_AVAL_PG_V1)
#define BIT_SET_PUBQ_AVAL_PG_V1(x, v)                                          \
	(BIT_CLEAR_PUBQ_AVAL_PG_V1(x) | BIT_PUBQ_AVAL_PG_V1(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_TX_AGG_ALIGN			(Offset 0x0240) */

#define BIT_SHIFT_HW_FLOW_CTL_EN 16
#define BIT_MASK_HW_FLOW_CTL_EN 0xffff
#define BIT_HW_FLOW_CTL_EN(x)                                                  \
	(((x) & BIT_MASK_HW_FLOW_CTL_EN) << BIT_SHIFT_HW_FLOW_CTL_EN)
#define BITS_HW_FLOW_CTL_EN                                                    \
	(BIT_MASK_HW_FLOW_CTL_EN << BIT_SHIFT_HW_FLOW_CTL_EN)
#define BIT_CLEAR_HW_FLOW_CTL_EN(x) ((x) & (~BITS_HW_FLOW_CTL_EN))
#define BIT_GET_HW_FLOW_CTL_EN(x)                                              \
	(((x) >> BIT_SHIFT_HW_FLOW_CTL_EN) & BIT_MASK_HW_FLOW_CTL_EN)
#define BIT_SET_HW_FLOW_CTL_EN(x, v)                                           \
	(BIT_CLEAR_HW_FLOW_CTL_EN(x) | BIT_HW_FLOW_CTL_EN(v))

#define BIT_SDIO_TXAGG_ALIGN_ADJUST_EN_V1 BIT(15)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FIFOPAGE_INFO_5			(Offset 0x0240) */

#define BIT_SHIFT_PUBQ_V1 0
#define BIT_MASK_PUBQ_V1 0xfff
#define BIT_PUBQ_V1(x) (((x) & BIT_MASK_PUBQ_V1) << BIT_SHIFT_PUBQ_V1)
#define BITS_PUBQ_V1 (BIT_MASK_PUBQ_V1 << BIT_SHIFT_PUBQ_V1)
#define BIT_CLEAR_PUBQ_V1(x) ((x) & (~BITS_PUBQ_V1))
#define BIT_GET_PUBQ_V1(x) (((x) >> BIT_SHIFT_PUBQ_V1) & BIT_MASK_PUBQ_V1)
#define BIT_SET_PUBQ_V1(x, v) (BIT_CLEAR_PUBQ_V1(x) | BIT_PUBQ_V1(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_TX_AGG_ALIGN			(Offset 0x0240) */

#define BIT_SHIFT_SDIO_TXAGG_ALIGN_SIZE_V1 0
#define BIT_MASK_SDIO_TXAGG_ALIGN_SIZE_V1 0xfff
#define BIT_SDIO_TXAGG_ALIGN_SIZE_V1(x)                                        \
	(((x) & BIT_MASK_SDIO_TXAGG_ALIGN_SIZE_V1)                             \
	 << BIT_SHIFT_SDIO_TXAGG_ALIGN_SIZE_V1)
#define BITS_SDIO_TXAGG_ALIGN_SIZE_V1                                          \
	(BIT_MASK_SDIO_TXAGG_ALIGN_SIZE_V1                                     \
	 << BIT_SHIFT_SDIO_TXAGG_ALIGN_SIZE_V1)
#define BIT_CLEAR_SDIO_TXAGG_ALIGN_SIZE_V1(x)                                  \
	((x) & (~BITS_SDIO_TXAGG_ALIGN_SIZE_V1))
#define BIT_GET_SDIO_TXAGG_ALIGN_SIZE_V1(x)                                    \
	(((x) >> BIT_SHIFT_SDIO_TXAGG_ALIGN_SIZE_V1) &                         \
	 BIT_MASK_SDIO_TXAGG_ALIGN_SIZE_V1)
#define BIT_SET_SDIO_TXAGG_ALIGN_SIZE_V1(x, v)                                 \
	(BIT_CLEAR_SDIO_TXAGG_ALIGN_SIZE_V1(x) |                               \
	 BIT_SDIO_TXAGG_ALIGN_SIZE_V1(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_H2C_HEAD				(Offset 0x0244) */

#define BIT_SHIFT_H2C_HEAD_V2 0
#define BIT_MASK_H2C_HEAD_V2 0xffff
#define BIT_H2C_HEAD_V2(x)                                                     \
	(((x) & BIT_MASK_H2C_HEAD_V2) << BIT_SHIFT_H2C_HEAD_V2)
#define BITS_H2C_HEAD_V2 (BIT_MASK_H2C_HEAD_V2 << BIT_SHIFT_H2C_HEAD_V2)
#define BIT_CLEAR_H2C_HEAD_V2(x) ((x) & (~BITS_H2C_HEAD_V2))
#define BIT_GET_H2C_HEAD_V2(x)                                                 \
	(((x) >> BIT_SHIFT_H2C_HEAD_V2) & BIT_MASK_H2C_HEAD_V2)
#define BIT_SET_H2C_HEAD_V2(x, v)                                              \
	(BIT_CLEAR_H2C_HEAD_V2(x) | BIT_H2C_HEAD_V2(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_H2C_HEAD				(Offset 0x0244) */

#define BIT_SHIFT_H2C_HEAD 0
#define BIT_MASK_H2C_HEAD 0x3ffff
#define BIT_H2C_HEAD(x) (((x) & BIT_MASK_H2C_HEAD) << BIT_SHIFT_H2C_HEAD)
#define BITS_H2C_HEAD (BIT_MASK_H2C_HEAD << BIT_SHIFT_H2C_HEAD)
#define BIT_CLEAR_H2C_HEAD(x) ((x) & (~BITS_H2C_HEAD))
#define BIT_GET_H2C_HEAD(x) (((x) >> BIT_SHIFT_H2C_HEAD) & BIT_MASK_H2C_HEAD)
#define BIT_SET_H2C_HEAD(x, v) (BIT_CLEAR_H2C_HEAD(x) | BIT_H2C_HEAD(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_H2C_HEAD				(Offset 0x0244) */

#define BIT_SHIFT_H2C_HEAD_V1 0
#define BIT_MASK_H2C_HEAD_V1 0x7ffff
#define BIT_H2C_HEAD_V1(x)                                                     \
	(((x) & BIT_MASK_H2C_HEAD_V1) << BIT_SHIFT_H2C_HEAD_V1)
#define BITS_H2C_HEAD_V1 (BIT_MASK_H2C_HEAD_V1 << BIT_SHIFT_H2C_HEAD_V1)
#define BIT_CLEAR_H2C_HEAD_V1(x) ((x) & (~BITS_H2C_HEAD_V1))
#define BIT_GET_H2C_HEAD_V1(x)                                                 \
	(((x) >> BIT_SHIFT_H2C_HEAD_V1) & BIT_MASK_H2C_HEAD_V1)
#define BIT_SET_H2C_HEAD_V1(x, v)                                              \
	(BIT_CLEAR_H2C_HEAD_V1(x) | BIT_H2C_HEAD_V1(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_H2C_TAIL				(Offset 0x0248) */

#define BIT_SHIFT_H2C_TAIL_V2 0
#define BIT_MASK_H2C_TAIL_V2 0xffff
#define BIT_H2C_TAIL_V2(x)                                                     \
	(((x) & BIT_MASK_H2C_TAIL_V2) << BIT_SHIFT_H2C_TAIL_V2)
#define BITS_H2C_TAIL_V2 (BIT_MASK_H2C_TAIL_V2 << BIT_SHIFT_H2C_TAIL_V2)
#define BIT_CLEAR_H2C_TAIL_V2(x) ((x) & (~BITS_H2C_TAIL_V2))
#define BIT_GET_H2C_TAIL_V2(x)                                                 \
	(((x) >> BIT_SHIFT_H2C_TAIL_V2) & BIT_MASK_H2C_TAIL_V2)
#define BIT_SET_H2C_TAIL_V2(x, v)                                              \
	(BIT_CLEAR_H2C_TAIL_V2(x) | BIT_H2C_TAIL_V2(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_H2C_TAIL				(Offset 0x0248) */

#define BIT_SHIFT_H2C_TAIL 0
#define BIT_MASK_H2C_TAIL 0x3ffff
#define BIT_H2C_TAIL(x) (((x) & BIT_MASK_H2C_TAIL) << BIT_SHIFT_H2C_TAIL)
#define BITS_H2C_TAIL (BIT_MASK_H2C_TAIL << BIT_SHIFT_H2C_TAIL)
#define BIT_CLEAR_H2C_TAIL(x) ((x) & (~BITS_H2C_TAIL))
#define BIT_GET_H2C_TAIL(x) (((x) >> BIT_SHIFT_H2C_TAIL) & BIT_MASK_H2C_TAIL)
#define BIT_SET_H2C_TAIL(x, v) (BIT_CLEAR_H2C_TAIL(x) | BIT_H2C_TAIL(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_H2C_TAIL				(Offset 0x0248) */

#define BIT_SHIFT_H2C_TAIL_V1 0
#define BIT_MASK_H2C_TAIL_V1 0x7ffff
#define BIT_H2C_TAIL_V1(x)                                                     \
	(((x) & BIT_MASK_H2C_TAIL_V1) << BIT_SHIFT_H2C_TAIL_V1)
#define BITS_H2C_TAIL_V1 (BIT_MASK_H2C_TAIL_V1 << BIT_SHIFT_H2C_TAIL_V1)
#define BIT_CLEAR_H2C_TAIL_V1(x) ((x) & (~BITS_H2C_TAIL_V1))
#define BIT_GET_H2C_TAIL_V1(x)                                                 \
	(((x) >> BIT_SHIFT_H2C_TAIL_V1) & BIT_MASK_H2C_TAIL_V1)
#define BIT_SET_H2C_TAIL_V1(x, v)                                              \
	(BIT_CLEAR_H2C_TAIL_V1(x) | BIT_H2C_TAIL_V1(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_H2C_READ_ADDR			(Offset 0x024C) */

#define BIT_SHIFT_H2C_READ_ADDR_V2 0
#define BIT_MASK_H2C_READ_ADDR_V2 0xffff
#define BIT_H2C_READ_ADDR_V2(x)                                                \
	(((x) & BIT_MASK_H2C_READ_ADDR_V2) << BIT_SHIFT_H2C_READ_ADDR_V2)
#define BITS_H2C_READ_ADDR_V2                                                  \
	(BIT_MASK_H2C_READ_ADDR_V2 << BIT_SHIFT_H2C_READ_ADDR_V2)
#define BIT_CLEAR_H2C_READ_ADDR_V2(x) ((x) & (~BITS_H2C_READ_ADDR_V2))
#define BIT_GET_H2C_READ_ADDR_V2(x)                                            \
	(((x) >> BIT_SHIFT_H2C_READ_ADDR_V2) & BIT_MASK_H2C_READ_ADDR_V2)
#define BIT_SET_H2C_READ_ADDR_V2(x, v)                                         \
	(BIT_CLEAR_H2C_READ_ADDR_V2(x) | BIT_H2C_READ_ADDR_V2(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_H2C_READ_ADDR			(Offset 0x024C) */

#define BIT_SHIFT_H2C_READ_ADDR 0
#define BIT_MASK_H2C_READ_ADDR 0x3ffff
#define BIT_H2C_READ_ADDR(x)                                                   \
	(((x) & BIT_MASK_H2C_READ_ADDR) << BIT_SHIFT_H2C_READ_ADDR)
#define BITS_H2C_READ_ADDR (BIT_MASK_H2C_READ_ADDR << BIT_SHIFT_H2C_READ_ADDR)
#define BIT_CLEAR_H2C_READ_ADDR(x) ((x) & (~BITS_H2C_READ_ADDR))
#define BIT_GET_H2C_READ_ADDR(x)                                               \
	(((x) >> BIT_SHIFT_H2C_READ_ADDR) & BIT_MASK_H2C_READ_ADDR)
#define BIT_SET_H2C_READ_ADDR(x, v)                                            \
	(BIT_CLEAR_H2C_READ_ADDR(x) | BIT_H2C_READ_ADDR(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_H2C_READ_ADDR			(Offset 0x024C) */

#define BIT_SHIFT_H2C_READ_ADDR_V1 0
#define BIT_MASK_H2C_READ_ADDR_V1 0x7ffff
#define BIT_H2C_READ_ADDR_V1(x)                                                \
	(((x) & BIT_MASK_H2C_READ_ADDR_V1) << BIT_SHIFT_H2C_READ_ADDR_V1)
#define BITS_H2C_READ_ADDR_V1                                                  \
	(BIT_MASK_H2C_READ_ADDR_V1 << BIT_SHIFT_H2C_READ_ADDR_V1)
#define BIT_CLEAR_H2C_READ_ADDR_V1(x) ((x) & (~BITS_H2C_READ_ADDR_V1))
#define BIT_GET_H2C_READ_ADDR_V1(x)                                            \
	(((x) >> BIT_SHIFT_H2C_READ_ADDR_V1) & BIT_MASK_H2C_READ_ADDR_V1)
#define BIT_SET_H2C_READ_ADDR_V1(x, v)                                         \
	(BIT_CLEAR_H2C_READ_ADDR_V1(x) | BIT_H2C_READ_ADDR_V1(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_H2C_WR_ADDR				(Offset 0x0250) */

#define BIT_SHIFT_H2C_WR_ADDR_V2 0
#define BIT_MASK_H2C_WR_ADDR_V2 0xffff
#define BIT_H2C_WR_ADDR_V2(x)                                                  \
	(((x) & BIT_MASK_H2C_WR_ADDR_V2) << BIT_SHIFT_H2C_WR_ADDR_V2)
#define BITS_H2C_WR_ADDR_V2                                                    \
	(BIT_MASK_H2C_WR_ADDR_V2 << BIT_SHIFT_H2C_WR_ADDR_V2)
#define BIT_CLEAR_H2C_WR_ADDR_V2(x) ((x) & (~BITS_H2C_WR_ADDR_V2))
#define BIT_GET_H2C_WR_ADDR_V2(x)                                              \
	(((x) >> BIT_SHIFT_H2C_WR_ADDR_V2) & BIT_MASK_H2C_WR_ADDR_V2)
#define BIT_SET_H2C_WR_ADDR_V2(x, v)                                           \
	(BIT_CLEAR_H2C_WR_ADDR_V2(x) | BIT_H2C_WR_ADDR_V2(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_H2C_WR_ADDR				(Offset 0x0250) */

#define BIT_SHIFT_H2C_WR_ADDR 0
#define BIT_MASK_H2C_WR_ADDR 0x3ffff
#define BIT_H2C_WR_ADDR(x)                                                     \
	(((x) & BIT_MASK_H2C_WR_ADDR) << BIT_SHIFT_H2C_WR_ADDR)
#define BITS_H2C_WR_ADDR (BIT_MASK_H2C_WR_ADDR << BIT_SHIFT_H2C_WR_ADDR)
#define BIT_CLEAR_H2C_WR_ADDR(x) ((x) & (~BITS_H2C_WR_ADDR))
#define BIT_GET_H2C_WR_ADDR(x)                                                 \
	(((x) >> BIT_SHIFT_H2C_WR_ADDR) & BIT_MASK_H2C_WR_ADDR)
#define BIT_SET_H2C_WR_ADDR(x, v)                                              \
	(BIT_CLEAR_H2C_WR_ADDR(x) | BIT_H2C_WR_ADDR(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_H2C_WR_ADDR				(Offset 0x0250) */

#define BIT_SHIFT_H2C_WR_ADDR_V1 0
#define BIT_MASK_H2C_WR_ADDR_V1 0x7ffff
#define BIT_H2C_WR_ADDR_V1(x)                                                  \
	(((x) & BIT_MASK_H2C_WR_ADDR_V1) << BIT_SHIFT_H2C_WR_ADDR_V1)
#define BITS_H2C_WR_ADDR_V1                                                    \
	(BIT_MASK_H2C_WR_ADDR_V1 << BIT_SHIFT_H2C_WR_ADDR_V1)
#define BIT_CLEAR_H2C_WR_ADDR_V1(x) ((x) & (~BITS_H2C_WR_ADDR_V1))
#define BIT_GET_H2C_WR_ADDR_V1(x)                                              \
	(((x) >> BIT_SHIFT_H2C_WR_ADDR_V1) & BIT_MASK_H2C_WR_ADDR_V1)
#define BIT_SET_H2C_WR_ADDR_V1(x, v)                                           \
	(BIT_CLEAR_H2C_WR_ADDR_V1(x) | BIT_H2C_WR_ADDR_V1(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_H2C_INFO				(Offset 0x0254) */

#define BIT_SHIFT_MDIO_PHY_ADDR 24
#define BIT_MASK_MDIO_PHY_ADDR 0x1f
#define BIT_MDIO_PHY_ADDR(x)                                                   \
	(((x) & BIT_MASK_MDIO_PHY_ADDR) << BIT_SHIFT_MDIO_PHY_ADDR)
#define BITS_MDIO_PHY_ADDR (BIT_MASK_MDIO_PHY_ADDR << BIT_SHIFT_MDIO_PHY_ADDR)
#define BIT_CLEAR_MDIO_PHY_ADDR(x) ((x) & (~BITS_MDIO_PHY_ADDR))
#define BIT_GET_MDIO_PHY_ADDR(x)                                               \
	(((x) >> BIT_SHIFT_MDIO_PHY_ADDR) & BIT_MASK_MDIO_PHY_ADDR)
#define BIT_SET_MDIO_PHY_ADDR(x, v)                                            \
	(BIT_CLEAR_MDIO_PHY_ADDR(x) | BIT_MDIO_PHY_ADDR(v))

#endif

#if (HALMAC_8197F_SUPPORT)

/* 2 REG_H2C_INFO				(Offset 0x0254) */

#define BIT_SHIFT_VI_PUB_LIMIT 16
#define BIT_MASK_VI_PUB_LIMIT 0xfff
#define BIT_VI_PUB_LIMIT(x)                                                    \
	(((x) & BIT_MASK_VI_PUB_LIMIT) << BIT_SHIFT_VI_PUB_LIMIT)
#define BITS_VI_PUB_LIMIT (BIT_MASK_VI_PUB_LIMIT << BIT_SHIFT_VI_PUB_LIMIT)
#define BIT_CLEAR_VI_PUB_LIMIT(x) ((x) & (~BITS_VI_PUB_LIMIT))
#define BIT_GET_VI_PUB_LIMIT(x)                                                \
	(((x) >> BIT_SHIFT_VI_PUB_LIMIT) & BIT_MASK_VI_PUB_LIMIT)
#define BIT_SET_VI_PUB_LIMIT(x, v)                                             \
	(BIT_CLEAR_VI_PUB_LIMIT(x) | BIT_VI_PUB_LIMIT(v))

#define BIT_SHIFT_BK_PUB_LIMIT 16
#define BIT_MASK_BK_PUB_LIMIT 0xfff
#define BIT_BK_PUB_LIMIT(x)                                                    \
	(((x) & BIT_MASK_BK_PUB_LIMIT) << BIT_SHIFT_BK_PUB_LIMIT)
#define BITS_BK_PUB_LIMIT (BIT_MASK_BK_PUB_LIMIT << BIT_SHIFT_BK_PUB_LIMIT)
#define BIT_CLEAR_BK_PUB_LIMIT(x) ((x) & (~BITS_BK_PUB_LIMIT))
#define BIT_GET_BK_PUB_LIMIT(x)                                                \
	(((x) >> BIT_SHIFT_BK_PUB_LIMIT) & BIT_MASK_BK_PUB_LIMIT)
#define BIT_SET_BK_PUB_LIMIT(x, v)                                             \
	(BIT_CLEAR_BK_PUB_LIMIT(x) | BIT_BK_PUB_LIMIT(v))

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_H2C_INFO				(Offset 0x0254) */

#define BIT_EX2Q_EN_PUBLIC_LIMIT BIT(13)
#define BIT_EX1Q_EN_PUBLIC_LIMIT BIT(12)

#endif

#if (HALMAC_8197F_SUPPORT)

/* 2 REG_H2C_INFO				(Offset 0x0254) */

#define BIT_EXQ_EN_PUBLIC_LIMIT BIT(11)

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_H2C_INFO				(Offset 0x0254) */

#define BIT_EQ_EN_PUBLIC_LIMIT BIT(11)

#endif

#if (HALMAC_8197F_SUPPORT)

/* 2 REG_H2C_INFO				(Offset 0x0254) */

#define BIT_NPQ_EN_PUBLIC_LIMIT BIT(10)

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_H2C_INFO				(Offset 0x0254) */

#define BIT_NQ_EN_PUBLIC_LIMIT BIT(10)

#endif

#if (HALMAC_8197F_SUPPORT)

/* 2 REG_H2C_INFO				(Offset 0x0254) */

#define BIT_LPQ_EN_PUBLIC_LIMIT BIT(9)

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_H2C_INFO				(Offset 0x0254) */

#define BIT_LQ_EN_PUBLIC_LIMIT BIT(9)

#endif

#if (HALMAC_8197F_SUPPORT)

/* 2 REG_H2C_INFO				(Offset 0x0254) */

#define BIT_HPQ_EN_PUBLIC_LIMIT BIT(8)

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_H2C_INFO				(Offset 0x0254) */

#define BIT_HQ_EN_PUBLIC_LIMIT BIT(8)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_H2C_INFO				(Offset 0x0254) */

#define BIT_H2C_SPACE_VLD BIT(3)
#define BIT_H2C_WR_ADDR_RST BIT(2)

#define BIT_SHIFT_H2C_LEN_SEL 0
#define BIT_MASK_H2C_LEN_SEL 0x3
#define BIT_H2C_LEN_SEL(x)                                                     \
	(((x) & BIT_MASK_H2C_LEN_SEL) << BIT_SHIFT_H2C_LEN_SEL)
#define BITS_H2C_LEN_SEL (BIT_MASK_H2C_LEN_SEL << BIT_SHIFT_H2C_LEN_SEL)
#define BIT_CLEAR_H2C_LEN_SEL(x) ((x) & (~BITS_H2C_LEN_SEL))
#define BIT_GET_H2C_LEN_SEL(x)                                                 \
	(((x) >> BIT_SHIFT_H2C_LEN_SEL) & BIT_MASK_H2C_LEN_SEL)
#define BIT_SET_H2C_LEN_SEL(x, v)                                              \
	(BIT_CLEAR_H2C_LEN_SEL(x) | BIT_H2C_LEN_SEL(v))

#endif

#if (HALMAC_8197F_SUPPORT)

/* 2 REG_H2C_INFO				(Offset 0x0254) */

#define BIT_SHIFT_VO_PUB_LIMIT 0
#define BIT_MASK_VO_PUB_LIMIT 0xfff
#define BIT_VO_PUB_LIMIT(x)                                                    \
	(((x) & BIT_MASK_VO_PUB_LIMIT) << BIT_SHIFT_VO_PUB_LIMIT)
#define BITS_VO_PUB_LIMIT (BIT_MASK_VO_PUB_LIMIT << BIT_SHIFT_VO_PUB_LIMIT)
#define BIT_CLEAR_VO_PUB_LIMIT(x) ((x) & (~BITS_VO_PUB_LIMIT))
#define BIT_GET_VO_PUB_LIMIT(x)                                                \
	(((x) >> BIT_SHIFT_VO_PUB_LIMIT) & BIT_MASK_VO_PUB_LIMIT)
#define BIT_SET_VO_PUB_LIMIT(x, v)                                             \
	(BIT_CLEAR_VO_PUB_LIMIT(x) | BIT_VO_PUB_LIMIT(v))

#define BIT_SHIFT_BE_PUB_LIMIT 0
#define BIT_MASK_BE_PUB_LIMIT 0xfff
#define BIT_BE_PUB_LIMIT(x)                                                    \
	(((x) & BIT_MASK_BE_PUB_LIMIT) << BIT_SHIFT_BE_PUB_LIMIT)
#define BITS_BE_PUB_LIMIT (BIT_MASK_BE_PUB_LIMIT << BIT_SHIFT_BE_PUB_LIMIT)
#define BIT_CLEAR_BE_PUB_LIMIT(x) ((x) & (~BITS_BE_PUB_LIMIT))
#define BIT_GET_BE_PUB_LIMIT(x)                                                \
	(((x) >> BIT_SHIFT_BE_PUB_LIMIT) & BIT_MASK_BE_PUB_LIMIT)
#define BIT_SET_BE_PUB_LIMIT(x, v)                                             \
	(BIT_CLEAR_BE_PUB_LIMIT(x) | BIT_BE_PUB_LIMIT(v))

#endif

#if (HALMAC_8197G_SUPPORT)

/* 2 REG_FIFOPAGE_CTRL_5			(Offset 0x0258) */

#define BIT_SHIFT_NQ_PG_PUBLIC_LIMIT 16
#define BIT_MASK_NQ_PG_PUBLIC_LIMIT 0xfff
#define BIT_NQ_PG_PUBLIC_LIMIT(x)                                              \
	(((x) & BIT_MASK_NQ_PG_PUBLIC_LIMIT) << BIT_SHIFT_NQ_PG_PUBLIC_LIMIT)
#define BITS_NQ_PG_PUBLIC_LIMIT                                                \
	(BIT_MASK_NQ_PG_PUBLIC_LIMIT << BIT_SHIFT_NQ_PG_PUBLIC_LIMIT)
#define BIT_CLEAR_NQ_PG_PUBLIC_LIMIT(x) ((x) & (~BITS_NQ_PG_PUBLIC_LIMIT))
#define BIT_GET_NQ_PG_PUBLIC_LIMIT(x)                                          \
	(((x) >> BIT_SHIFT_NQ_PG_PUBLIC_LIMIT) & BIT_MASK_NQ_PG_PUBLIC_LIMIT)
#define BIT_SET_NQ_PG_PUBLIC_LIMIT(x, v)                                       \
	(BIT_CLEAR_NQ_PG_PUBLIC_LIMIT(x) | BIT_NQ_PG_PUBLIC_LIMIT(v))

#define BIT_SHIFT_HQ_PG_PUBLIC_LIMIT 0
#define BIT_MASK_HQ_PG_PUBLIC_LIMIT 0xfff
#define BIT_HQ_PG_PUBLIC_LIMIT(x)                                              \
	(((x) & BIT_MASK_HQ_PG_PUBLIC_LIMIT) << BIT_SHIFT_HQ_PG_PUBLIC_LIMIT)
#define BITS_HQ_PG_PUBLIC_LIMIT                                                \
	(BIT_MASK_HQ_PG_PUBLIC_LIMIT << BIT_SHIFT_HQ_PG_PUBLIC_LIMIT)
#define BIT_CLEAR_HQ_PG_PUBLIC_LIMIT(x) ((x) & (~BITS_HQ_PG_PUBLIC_LIMIT))
#define BIT_GET_HQ_PG_PUBLIC_LIMIT(x)                                          \
	(((x) >> BIT_SHIFT_HQ_PG_PUBLIC_LIMIT) & BIT_MASK_HQ_PG_PUBLIC_LIMIT)
#define BIT_SET_HQ_PG_PUBLIC_LIMIT(x, v)                                       \
	(BIT_CLEAR_HQ_PG_PUBLIC_LIMIT(x) | BIT_HQ_PG_PUBLIC_LIMIT(v))

/* 2 REG_FIFOPAGE_CTRL_3			(Offset 0x025C) */

#define BIT_SHIFT_EQ_PG_PUBLIC_LIMIT 16
#define BIT_MASK_EQ_PG_PUBLIC_LIMIT 0xfff
#define BIT_EQ_PG_PUBLIC_LIMIT(x)                                              \
	(((x) & BIT_MASK_EQ_PG_PUBLIC_LIMIT) << BIT_SHIFT_EQ_PG_PUBLIC_LIMIT)
#define BITS_EQ_PG_PUBLIC_LIMIT                                                \
	(BIT_MASK_EQ_PG_PUBLIC_LIMIT << BIT_SHIFT_EQ_PG_PUBLIC_LIMIT)
#define BIT_CLEAR_EQ_PG_PUBLIC_LIMIT(x) ((x) & (~BITS_EQ_PG_PUBLIC_LIMIT))
#define BIT_GET_EQ_PG_PUBLIC_LIMIT(x)                                          \
	(((x) >> BIT_SHIFT_EQ_PG_PUBLIC_LIMIT) & BIT_MASK_EQ_PG_PUBLIC_LIMIT)
#define BIT_SET_EQ_PG_PUBLIC_LIMIT(x, v)                                       \
	(BIT_CLEAR_EQ_PG_PUBLIC_LIMIT(x) | BIT_EQ_PG_PUBLIC_LIMIT(v))

#define BIT_SHIFT_LQ_PG_PUBLIC_LIMIT 0
#define BIT_MASK_LQ_PG_PUBLIC_LIMIT 0xfff
#define BIT_LQ_PG_PUBLIC_LIMIT(x)                                              \
	(((x) & BIT_MASK_LQ_PG_PUBLIC_LIMIT) << BIT_SHIFT_LQ_PG_PUBLIC_LIMIT)
#define BITS_LQ_PG_PUBLIC_LIMIT                                                \
	(BIT_MASK_LQ_PG_PUBLIC_LIMIT << BIT_SHIFT_LQ_PG_PUBLIC_LIMIT)
#define BIT_CLEAR_LQ_PG_PUBLIC_LIMIT(x) ((x) & (~BITS_LQ_PG_PUBLIC_LIMIT))
#define BIT_GET_LQ_PG_PUBLIC_LIMIT(x)                                          \
	(((x) >> BIT_SHIFT_LQ_PG_PUBLIC_LIMIT) & BIT_MASK_LQ_PG_PUBLIC_LIMIT)
#define BIT_SET_LQ_PG_PUBLIC_LIMIT(x, v)                                       \
	(BIT_CLEAR_LQ_PG_PUBLIC_LIMIT(x) | BIT_LQ_PG_PUBLIC_LIMIT(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_DMA_OQT_0				(Offset 0x0260) */

#define BIT_SHIFT_TX_OQT_12_FREE_SPACE 24
#define BIT_MASK_TX_OQT_12_FREE_SPACE 0xff
#define BIT_TX_OQT_12_FREE_SPACE(x)                                            \
	(((x) & BIT_MASK_TX_OQT_12_FREE_SPACE)                                 \
	 << BIT_SHIFT_TX_OQT_12_FREE_SPACE)
#define BITS_TX_OQT_12_FREE_SPACE                                              \
	(BIT_MASK_TX_OQT_12_FREE_SPACE << BIT_SHIFT_TX_OQT_12_FREE_SPACE)
#define BIT_CLEAR_TX_OQT_12_FREE_SPACE(x) ((x) & (~BITS_TX_OQT_12_FREE_SPACE))
#define BIT_GET_TX_OQT_12_FREE_SPACE(x)                                        \
	(((x) >> BIT_SHIFT_TX_OQT_12_FREE_SPACE) &                             \
	 BIT_MASK_TX_OQT_12_FREE_SPACE)
#define BIT_SET_TX_OQT_12_FREE_SPACE(x, v)                                     \
	(BIT_CLEAR_TX_OQT_12_FREE_SPACE(x) | BIT_TX_OQT_12_FREE_SPACE(v))

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_TQPNT5				(Offset 0x0260) */

#define BIT_SHIFT_EX1Q_HIGH_TH_V1 16
#define BIT_MASK_EX1Q_HIGH_TH_V1 0xfff
#define BIT_EX1Q_HIGH_TH_V1(x)                                                 \
	(((x) & BIT_MASK_EX1Q_HIGH_TH_V1) << BIT_SHIFT_EX1Q_HIGH_TH_V1)
#define BITS_EX1Q_HIGH_TH_V1                                                   \
	(BIT_MASK_EX1Q_HIGH_TH_V1 << BIT_SHIFT_EX1Q_HIGH_TH_V1)
#define BIT_CLEAR_EX1Q_HIGH_TH_V1(x) ((x) & (~BITS_EX1Q_HIGH_TH_V1))
#define BIT_GET_EX1Q_HIGH_TH_V1(x)                                             \
	(((x) >> BIT_SHIFT_EX1Q_HIGH_TH_V1) & BIT_MASK_EX1Q_HIGH_TH_V1)
#define BIT_SET_EX1Q_HIGH_TH_V1(x, v)                                          \
	(BIT_CLEAR_EX1Q_HIGH_TH_V1(x) | BIT_EX1Q_HIGH_TH_V1(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_DMA_OQT_0				(Offset 0x0260) */

#define BIT_SHIFT_TX_OQT_8_11_FREE_SPACE 16
#define BIT_MASK_TX_OQT_8_11_FREE_SPACE 0xff
#define BIT_TX_OQT_8_11_FREE_SPACE(x)                                          \
	(((x) & BIT_MASK_TX_OQT_8_11_FREE_SPACE)                               \
	 << BIT_SHIFT_TX_OQT_8_11_FREE_SPACE)
#define BITS_TX_OQT_8_11_FREE_SPACE                                            \
	(BIT_MASK_TX_OQT_8_11_FREE_SPACE << BIT_SHIFT_TX_OQT_8_11_FREE_SPACE)
#define BIT_CLEAR_TX_OQT_8_11_FREE_SPACE(x)                                    \
	((x) & (~BITS_TX_OQT_8_11_FREE_SPACE))
#define BIT_GET_TX_OQT_8_11_FREE_SPACE(x)                                      \
	(((x) >> BIT_SHIFT_TX_OQT_8_11_FREE_SPACE) &                           \
	 BIT_MASK_TX_OQT_8_11_FREE_SPACE)
#define BIT_SET_TX_OQT_8_11_FREE_SPACE(x, v)                                   \
	(BIT_CLEAR_TX_OQT_8_11_FREE_SPACE(x) | BIT_TX_OQT_8_11_FREE_SPACE(v))

#define BIT_SHIFT_TX_OQT_16_FREE_SPACE 16
#define BIT_MASK_TX_OQT_16_FREE_SPACE 0xff
#define BIT_TX_OQT_16_FREE_SPACE(x)                                            \
	(((x) & BIT_MASK_TX_OQT_16_FREE_SPACE)                                 \
	 << BIT_SHIFT_TX_OQT_16_FREE_SPACE)
#define BITS_TX_OQT_16_FREE_SPACE                                              \
	(BIT_MASK_TX_OQT_16_FREE_SPACE << BIT_SHIFT_TX_OQT_16_FREE_SPACE)
#define BIT_CLEAR_TX_OQT_16_FREE_SPACE(x) ((x) & (~BITS_TX_OQT_16_FREE_SPACE))
#define BIT_GET_TX_OQT_16_FREE_SPACE(x)                                        \
	(((x) >> BIT_SHIFT_TX_OQT_16_FREE_SPACE) &                             \
	 BIT_MASK_TX_OQT_16_FREE_SPACE)
#define BIT_SET_TX_OQT_16_FREE_SPACE(x, v)                                     \
	(BIT_CLEAR_TX_OQT_16_FREE_SPACE(x) | BIT_TX_OQT_16_FREE_SPACE(v))

#define BIT_SHIFT_TX_OQT_4_7_FREE_SPACE 8
#define BIT_MASK_TX_OQT_4_7_FREE_SPACE 0xff
#define BIT_TX_OQT_4_7_FREE_SPACE(x)                                           \
	(((x) & BIT_MASK_TX_OQT_4_7_FREE_SPACE)                                \
	 << BIT_SHIFT_TX_OQT_4_7_FREE_SPACE)
#define BITS_TX_OQT_4_7_FREE_SPACE                                             \
	(BIT_MASK_TX_OQT_4_7_FREE_SPACE << BIT_SHIFT_TX_OQT_4_7_FREE_SPACE)
#define BIT_CLEAR_TX_OQT_4_7_FREE_SPACE(x) ((x) & (~BITS_TX_OQT_4_7_FREE_SPACE))
#define BIT_GET_TX_OQT_4_7_FREE_SPACE(x)                                       \
	(((x) >> BIT_SHIFT_TX_OQT_4_7_FREE_SPACE) &                            \
	 BIT_MASK_TX_OQT_4_7_FREE_SPACE)
#define BIT_SET_TX_OQT_4_7_FREE_SPACE(x, v)                                    \
	(BIT_CLEAR_TX_OQT_4_7_FREE_SPACE(x) | BIT_TX_OQT_4_7_FREE_SPACE(v))

#define BIT_SHIFT_TX_OQT_14_15_FREE_SPACE 8
#define BIT_MASK_TX_OQT_14_15_FREE_SPACE 0xff
#define BIT_TX_OQT_14_15_FREE_SPACE(x)                                         \
	(((x) & BIT_MASK_TX_OQT_14_15_FREE_SPACE)                              \
	 << BIT_SHIFT_TX_OQT_14_15_FREE_SPACE)
#define BITS_TX_OQT_14_15_FREE_SPACE                                           \
	(BIT_MASK_TX_OQT_14_15_FREE_SPACE << BIT_SHIFT_TX_OQT_14_15_FREE_SPACE)
#define BIT_CLEAR_TX_OQT_14_15_FREE_SPACE(x)                                   \
	((x) & (~BITS_TX_OQT_14_15_FREE_SPACE))
#define BIT_GET_TX_OQT_14_15_FREE_SPACE(x)                                     \
	(((x) >> BIT_SHIFT_TX_OQT_14_15_FREE_SPACE) &                          \
	 BIT_MASK_TX_OQT_14_15_FREE_SPACE)
#define BIT_SET_TX_OQT_14_15_FREE_SPACE(x, v)                                  \
	(BIT_CLEAR_TX_OQT_14_15_FREE_SPACE(x) | BIT_TX_OQT_14_15_FREE_SPACE(v))

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_TQPNT5				(Offset 0x0260) */

#define BIT_SHIFT_EX1Q_LOW_TH_V1 0
#define BIT_MASK_EX1Q_LOW_TH_V1 0xfff
#define BIT_EX1Q_LOW_TH_V1(x)                                                  \
	(((x) & BIT_MASK_EX1Q_LOW_TH_V1) << BIT_SHIFT_EX1Q_LOW_TH_V1)
#define BITS_EX1Q_LOW_TH_V1                                                    \
	(BIT_MASK_EX1Q_LOW_TH_V1 << BIT_SHIFT_EX1Q_LOW_TH_V1)
#define BIT_CLEAR_EX1Q_LOW_TH_V1(x) ((x) & (~BITS_EX1Q_LOW_TH_V1))
#define BIT_GET_EX1Q_LOW_TH_V1(x)                                              \
	(((x) >> BIT_SHIFT_EX1Q_LOW_TH_V1) & BIT_MASK_EX1Q_LOW_TH_V1)
#define BIT_SET_EX1Q_LOW_TH_V1(x, v)                                           \
	(BIT_CLEAR_EX1Q_LOW_TH_V1(x) | BIT_EX1Q_LOW_TH_V1(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_DMA_OQT_0				(Offset 0x0260) */

#define BIT_SHIFT_TX_OQT_0_3_FREE_SPACE 0
#define BIT_MASK_TX_OQT_0_3_FREE_SPACE 0xff
#define BIT_TX_OQT_0_3_FREE_SPACE(x)                                           \
	(((x) & BIT_MASK_TX_OQT_0_3_FREE_SPACE)                                \
	 << BIT_SHIFT_TX_OQT_0_3_FREE_SPACE)
#define BITS_TX_OQT_0_3_FREE_SPACE                                             \
	(BIT_MASK_TX_OQT_0_3_FREE_SPACE << BIT_SHIFT_TX_OQT_0_3_FREE_SPACE)
#define BIT_CLEAR_TX_OQT_0_3_FREE_SPACE(x) ((x) & (~BITS_TX_OQT_0_3_FREE_SPACE))
#define BIT_GET_TX_OQT_0_3_FREE_SPACE(x)                                       \
	(((x) >> BIT_SHIFT_TX_OQT_0_3_FREE_SPACE) &                            \
	 BIT_MASK_TX_OQT_0_3_FREE_SPACE)
#define BIT_SET_TX_OQT_0_3_FREE_SPACE(x, v)                                    \
	(BIT_CLEAR_TX_OQT_0_3_FREE_SPACE(x) | BIT_TX_OQT_0_3_FREE_SPACE(v))

#define BIT_SHIFT_TX_OQT_13_FREE_SPACE 0
#define BIT_MASK_TX_OQT_13_FREE_SPACE 0xff
#define BIT_TX_OQT_13_FREE_SPACE(x)                                            \
	(((x) & BIT_MASK_TX_OQT_13_FREE_SPACE)                                 \
	 << BIT_SHIFT_TX_OQT_13_FREE_SPACE)
#define BITS_TX_OQT_13_FREE_SPACE                                              \
	(BIT_MASK_TX_OQT_13_FREE_SPACE << BIT_SHIFT_TX_OQT_13_FREE_SPACE)
#define BIT_CLEAR_TX_OQT_13_FREE_SPACE(x) ((x) & (~BITS_TX_OQT_13_FREE_SPACE))
#define BIT_GET_TX_OQT_13_FREE_SPACE(x)                                        \
	(((x) >> BIT_SHIFT_TX_OQT_13_FREE_SPACE) &                             \
	 BIT_MASK_TX_OQT_13_FREE_SPACE)
#define BIT_SET_TX_OQT_13_FREE_SPACE(x, v)                                     \
	(BIT_CLEAR_TX_OQT_13_FREE_SPACE(x) | BIT_TX_OQT_13_FREE_SPACE(v))

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_TQPNT6				(Offset 0x0264) */

#define BIT_SHIFT_EX2Q_HIGH_TH_V1 16
#define BIT_MASK_EX2Q_HIGH_TH_V1 0xfff
#define BIT_EX2Q_HIGH_TH_V1(x)                                                 \
	(((x) & BIT_MASK_EX2Q_HIGH_TH_V1) << BIT_SHIFT_EX2Q_HIGH_TH_V1)
#define BITS_EX2Q_HIGH_TH_V1                                                   \
	(BIT_MASK_EX2Q_HIGH_TH_V1 << BIT_SHIFT_EX2Q_HIGH_TH_V1)
#define BIT_CLEAR_EX2Q_HIGH_TH_V1(x) ((x) & (~BITS_EX2Q_HIGH_TH_V1))
#define BIT_GET_EX2Q_HIGH_TH_V1(x)                                             \
	(((x) >> BIT_SHIFT_EX2Q_HIGH_TH_V1) & BIT_MASK_EX2Q_HIGH_TH_V1)
#define BIT_SET_EX2Q_HIGH_TH_V1(x, v)                                          \
	(BIT_CLEAR_EX2Q_HIGH_TH_V1(x) | BIT_EX2Q_HIGH_TH_V1(v))

#define BIT_SHIFT_EX2Q_LOW_TH_V1 0
#define BIT_MASK_EX2Q_LOW_TH_V1 0xfff
#define BIT_EX2Q_LOW_TH_V1(x)                                                  \
	(((x) & BIT_MASK_EX2Q_LOW_TH_V1) << BIT_SHIFT_EX2Q_LOW_TH_V1)
#define BITS_EX2Q_LOW_TH_V1                                                    \
	(BIT_MASK_EX2Q_LOW_TH_V1 << BIT_SHIFT_EX2Q_LOW_TH_V1)
#define BIT_CLEAR_EX2Q_LOW_TH_V1(x) ((x) & (~BITS_EX2Q_LOW_TH_V1))
#define BIT_GET_EX2Q_LOW_TH_V1(x)                                              \
	(((x) >> BIT_SHIFT_EX2Q_LOW_TH_V1) & BIT_MASK_EX2Q_LOW_TH_V1)
#define BIT_SET_EX2Q_LOW_TH_V1(x, v)                                           \
	(BIT_CLEAR_EX2Q_LOW_TH_V1(x) | BIT_EX2Q_LOW_TH_V1(v))

/* 2 REG_FIFOPAGE_INFO_6			(Offset 0x0268) */

#define BIT_SHIFT_EX1Q_AVAL_PG_V1 16
#define BIT_MASK_EX1Q_AVAL_PG_V1 0xfff
#define BIT_EX1Q_AVAL_PG_V1(x)                                                 \
	(((x) & BIT_MASK_EX1Q_AVAL_PG_V1) << BIT_SHIFT_EX1Q_AVAL_PG_V1)
#define BITS_EX1Q_AVAL_PG_V1                                                   \
	(BIT_MASK_EX1Q_AVAL_PG_V1 << BIT_SHIFT_EX1Q_AVAL_PG_V1)
#define BIT_CLEAR_EX1Q_AVAL_PG_V1(x) ((x) & (~BITS_EX1Q_AVAL_PG_V1))
#define BIT_GET_EX1Q_AVAL_PG_V1(x)                                             \
	(((x) >> BIT_SHIFT_EX1Q_AVAL_PG_V1) & BIT_MASK_EX1Q_AVAL_PG_V1)
#define BIT_SET_EX1Q_AVAL_PG_V1(x, v)                                          \
	(BIT_CLEAR_EX1Q_AVAL_PG_V1(x) | BIT_EX1Q_AVAL_PG_V1(v))

#define BIT_SHIFT_EX1Q_V1 0
#define BIT_MASK_EX1Q_V1 0xfff
#define BIT_EX1Q_V1(x) (((x) & BIT_MASK_EX1Q_V1) << BIT_SHIFT_EX1Q_V1)
#define BITS_EX1Q_V1 (BIT_MASK_EX1Q_V1 << BIT_SHIFT_EX1Q_V1)
#define BIT_CLEAR_EX1Q_V1(x) ((x) & (~BITS_EX1Q_V1))
#define BIT_GET_EX1Q_V1(x) (((x) >> BIT_SHIFT_EX1Q_V1) & BIT_MASK_EX1Q_V1)
#define BIT_SET_EX1Q_V1(x, v) (BIT_CLEAR_EX1Q_V1(x) | BIT_EX1Q_V1(v))

/* 2 REG_FIFOPAGE_INFO_7			(Offset 0x026C) */

#define BIT_SHIFT_EX2Q_AVAL_PG_V1 16
#define BIT_MASK_EX2Q_AVAL_PG_V1 0xfff
#define BIT_EX2Q_AVAL_PG_V1(x)                                                 \
	(((x) & BIT_MASK_EX2Q_AVAL_PG_V1) << BIT_SHIFT_EX2Q_AVAL_PG_V1)
#define BITS_EX2Q_AVAL_PG_V1                                                   \
	(BIT_MASK_EX2Q_AVAL_PG_V1 << BIT_SHIFT_EX2Q_AVAL_PG_V1)
#define BIT_CLEAR_EX2Q_AVAL_PG_V1(x) ((x) & (~BITS_EX2Q_AVAL_PG_V1))
#define BIT_GET_EX2Q_AVAL_PG_V1(x)                                             \
	(((x) >> BIT_SHIFT_EX2Q_AVAL_PG_V1) & BIT_MASK_EX2Q_AVAL_PG_V1)
#define BIT_SET_EX2Q_AVAL_PG_V1(x, v)                                          \
	(BIT_CLEAR_EX2Q_AVAL_PG_V1(x) | BIT_EX2Q_AVAL_PG_V1(v))

#define BIT_SHIFT_EX2Q_V1 0
#define BIT_MASK_EX2Q_V1 0xfff
#define BIT_EX2Q_V1(x) (((x) & BIT_MASK_EX2Q_V1) << BIT_SHIFT_EX2Q_V1)
#define BITS_EX2Q_V1 (BIT_MASK_EX2Q_V1 << BIT_SHIFT_EX2Q_V1)
#define BIT_CLEAR_EX2Q_V1(x) ((x) & (~BITS_EX2Q_V1))
#define BIT_GET_EX2Q_V1(x) (((x) >> BIT_SHIFT_EX2Q_V1) & BIT_MASK_EX2Q_V1)
#define BIT_SET_EX2Q_V1(x, v) (BIT_CLEAR_EX2Q_V1(x) | BIT_EX2Q_V1(v))

#endif

#if (HALMAC_8197G_SUPPORT)

/* 2 REG_FIFOPAGE_CTRL_4			(Offset 0x0270) */

#define BIT_SHIFT_EX1Q_PG_PUBLIC_LIMIT 16
#define BIT_MASK_EX1Q_PG_PUBLIC_LIMIT 0xfff
#define BIT_EX1Q_PG_PUBLIC_LIMIT(x)                                            \
	(((x) & BIT_MASK_EX1Q_PG_PUBLIC_LIMIT)                                 \
	 << BIT_SHIFT_EX1Q_PG_PUBLIC_LIMIT)
#define BITS_EX1Q_PG_PUBLIC_LIMIT                                              \
	(BIT_MASK_EX1Q_PG_PUBLIC_LIMIT << BIT_SHIFT_EX1Q_PG_PUBLIC_LIMIT)
#define BIT_CLEAR_EX1Q_PG_PUBLIC_LIMIT(x) ((x) & (~BITS_EX1Q_PG_PUBLIC_LIMIT))
#define BIT_GET_EX1Q_PG_PUBLIC_LIMIT(x)                                        \
	(((x) >> BIT_SHIFT_EX1Q_PG_PUBLIC_LIMIT) &                             \
	 BIT_MASK_EX1Q_PG_PUBLIC_LIMIT)
#define BIT_SET_EX1Q_PG_PUBLIC_LIMIT(x, v)                                     \
	(BIT_CLEAR_EX1Q_PG_PUBLIC_LIMIT(x) | BIT_EX1Q_PG_PUBLIC_LIMIT(v))

#define BIT_SHIFT_EX2Q_PG_PUBLIC_LIMIT 0
#define BIT_MASK_EX2Q_PG_PUBLIC_LIMIT 0xfff
#define BIT_EX2Q_PG_PUBLIC_LIMIT(x)                                            \
	(((x) & BIT_MASK_EX2Q_PG_PUBLIC_LIMIT)                                 \
	 << BIT_SHIFT_EX2Q_PG_PUBLIC_LIMIT)
#define BITS_EX2Q_PG_PUBLIC_LIMIT                                              \
	(BIT_MASK_EX2Q_PG_PUBLIC_LIMIT << BIT_SHIFT_EX2Q_PG_PUBLIC_LIMIT)
#define BIT_CLEAR_EX2Q_PG_PUBLIC_LIMIT(x) ((x) & (~BITS_EX2Q_PG_PUBLIC_LIMIT))
#define BIT_GET_EX2Q_PG_PUBLIC_LIMIT(x)                                        \
	(((x) >> BIT_SHIFT_EX2Q_PG_PUBLIC_LIMIT) &                             \
	 BIT_MASK_EX2Q_PG_PUBLIC_LIMIT)
#define BIT_SET_EX2Q_PG_PUBLIC_LIMIT(x, v)                                     \
	(BIT_CLEAR_EX2Q_PG_PUBLIC_LIMIT(x) | BIT_EX2Q_PG_PUBLIC_LIMIT(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_PGSUB_H				(Offset 0x0270) */

#define BIT_SHIFT_HPQ_PGSUB_CNT 0
#define BIT_MASK_HPQ_PGSUB_CNT 0xffffffffL
#define BIT_HPQ_PGSUB_CNT(x)                                                   \
	(((x) & BIT_MASK_HPQ_PGSUB_CNT) << BIT_SHIFT_HPQ_PGSUB_CNT)
#define BITS_HPQ_PGSUB_CNT (BIT_MASK_HPQ_PGSUB_CNT << BIT_SHIFT_HPQ_PGSUB_CNT)
#define BIT_CLEAR_HPQ_PGSUB_CNT(x) ((x) & (~BITS_HPQ_PGSUB_CNT))
#define BIT_GET_HPQ_PGSUB_CNT(x)                                               \
	(((x) >> BIT_SHIFT_HPQ_PGSUB_CNT) & BIT_MASK_HPQ_PGSUB_CNT)
#define BIT_SET_HPQ_PGSUB_CNT(x, v)                                            \
	(BIT_CLEAR_HPQ_PGSUB_CNT(x) | BIT_HPQ_PGSUB_CNT(v))

/* 2 REG_PGSUB_N				(Offset 0x0274) */

#define BIT_SHIFT_NPQ_PGSUB_CNT 0
#define BIT_MASK_NPQ_PGSUB_CNT 0xffffffffL
#define BIT_NPQ_PGSUB_CNT(x)                                                   \
	(((x) & BIT_MASK_NPQ_PGSUB_CNT) << BIT_SHIFT_NPQ_PGSUB_CNT)
#define BITS_NPQ_PGSUB_CNT (BIT_MASK_NPQ_PGSUB_CNT << BIT_SHIFT_NPQ_PGSUB_CNT)
#define BIT_CLEAR_NPQ_PGSUB_CNT(x) ((x) & (~BITS_NPQ_PGSUB_CNT))
#define BIT_GET_NPQ_PGSUB_CNT(x)                                               \
	(((x) >> BIT_SHIFT_NPQ_PGSUB_CNT) & BIT_MASK_NPQ_PGSUB_CNT)
#define BIT_SET_NPQ_PGSUB_CNT(x, v)                                            \
	(BIT_CLEAR_NPQ_PGSUB_CNT(x) | BIT_NPQ_PGSUB_CNT(v))

/* 2 REG_PGSUB_L				(Offset 0x0278) */

#define BIT_SHIFT_LPQ_PGSUB_CNT 0
#define BIT_MASK_LPQ_PGSUB_CNT 0xffffffffL
#define BIT_LPQ_PGSUB_CNT(x)                                                   \
	(((x) & BIT_MASK_LPQ_PGSUB_CNT) << BIT_SHIFT_LPQ_PGSUB_CNT)
#define BITS_LPQ_PGSUB_CNT (BIT_MASK_LPQ_PGSUB_CNT << BIT_SHIFT_LPQ_PGSUB_CNT)
#define BIT_CLEAR_LPQ_PGSUB_CNT(x) ((x) & (~BITS_LPQ_PGSUB_CNT))
#define BIT_GET_LPQ_PGSUB_CNT(x)                                               \
	(((x) >> BIT_SHIFT_LPQ_PGSUB_CNT) & BIT_MASK_LPQ_PGSUB_CNT)
#define BIT_SET_LPQ_PGSUB_CNT(x, v)                                            \
	(BIT_CLEAR_LPQ_PGSUB_CNT(x) | BIT_LPQ_PGSUB_CNT(v))

/* 2 REG_PGSUB_E				(Offset 0x027C) */

#define BIT_SHIFT_EPQ_PGSUB_CNT 0
#define BIT_MASK_EPQ_PGSUB_CNT 0xffffffffL
#define BIT_EPQ_PGSUB_CNT(x)                                                   \
	(((x) & BIT_MASK_EPQ_PGSUB_CNT) << BIT_SHIFT_EPQ_PGSUB_CNT)
#define BITS_EPQ_PGSUB_CNT (BIT_MASK_EPQ_PGSUB_CNT << BIT_SHIFT_EPQ_PGSUB_CNT)
#define BIT_CLEAR_EPQ_PGSUB_CNT(x) ((x) & (~BITS_EPQ_PGSUB_CNT))
#define BIT_GET_EPQ_PGSUB_CNT(x)                                               \
	(((x) >> BIT_SHIFT_EPQ_PGSUB_CNT) & BIT_MASK_EPQ_PGSUB_CNT)
#define BIT_SET_EPQ_PGSUB_CNT(x, v)                                            \
	(BIT_CLEAR_EPQ_PGSUB_CNT(x) | BIT_EPQ_PGSUB_CNT(v))

#define BIT_SHIFT_FWFF_PKT_STR_ADDR_V2 0
#define BIT_MASK_FWFF_PKT_STR_ADDR_V2 0x3fff
#define BIT_FWFF_PKT_STR_ADDR_V2(x)                                            \
	(((x) & BIT_MASK_FWFF_PKT_STR_ADDR_V2)                                 \
	 << BIT_SHIFT_FWFF_PKT_STR_ADDR_V2)
#define BITS_FWFF_PKT_STR_ADDR_V2                                              \
	(BIT_MASK_FWFF_PKT_STR_ADDR_V2 << BIT_SHIFT_FWFF_PKT_STR_ADDR_V2)
#define BIT_CLEAR_FWFF_PKT_STR_ADDR_V2(x) ((x) & (~BITS_FWFF_PKT_STR_ADDR_V2))
#define BIT_GET_FWFF_PKT_STR_ADDR_V2(x)                                        \
	(((x) >> BIT_SHIFT_FWFF_PKT_STR_ADDR_V2) &                             \
	 BIT_MASK_FWFF_PKT_STR_ADDR_V2)
#define BIT_SET_FWFF_PKT_STR_ADDR_V2(x, v)                                     \
	(BIT_CLEAR_FWFF_PKT_STR_ADDR_V2(x) | BIT_FWFF_PKT_STR_ADDR_V2(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_RXDMA_AGG_PG_TH			(Offset 0x0280) */

#define BIT_USB_RXDMA_AGG_EN BIT(31)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_RXDMA_AGG_PG_TH			(Offset 0x0280) */

#define BIT_RXDMA_AGG_OLD_MOD_V1 BIT(31)

#endif

#if (HALMAC_8197F_SUPPORT)

/* 2 REG_RXDMA_AGG_PG_TH			(Offset 0x0280) */

#define BIT_DMA_STORE_MODE BIT(31)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_RXDMA_AGG_PG_TH			(Offset 0x0280) */

#define BIT_DMA_STORE BIT(31)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_RXDMA_AGG_PG_TH			(Offset 0x0280) */

#define BIT_EN_FW_ADD BIT(30)

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_RXDMA_AGG_PG_TH			(Offset 0x0280) */

#define BIT_RXAGG_TH_MODE BIT(29)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_RXDMA_AGG_PG_TH			(Offset 0x0280) */

#define BIT_EN_PRE_CALC BIT(29)
#define BIT_RXAGG_SW_EN BIT(28)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_RXDMA_AGG_PG_TH			(Offset 0x0280) */

#define BIT_RXAGG_SW_TRIG BIT(27)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_RXDMA_AGG_PG_TH			(Offset 0x0280) */

#define BIT_SHIFT_BCNERR_CNT_OTHERS 24
#define BIT_MASK_BCNERR_CNT_OTHERS 0xff
#define BIT_BCNERR_CNT_OTHERS(x)                                               \
	(((x) & BIT_MASK_BCNERR_CNT_OTHERS) << BIT_SHIFT_BCNERR_CNT_OTHERS)
#define BITS_BCNERR_CNT_OTHERS                                                 \
	(BIT_MASK_BCNERR_CNT_OTHERS << BIT_SHIFT_BCNERR_CNT_OTHERS)
#define BIT_CLEAR_BCNERR_CNT_OTHERS(x) ((x) & (~BITS_BCNERR_CNT_OTHERS))
#define BIT_GET_BCNERR_CNT_OTHERS(x)                                           \
	(((x) >> BIT_SHIFT_BCNERR_CNT_OTHERS) & BIT_MASK_BCNERR_CNT_OTHERS)
#define BIT_SET_BCNERR_CNT_OTHERS(x, v)                                        \
	(BIT_CLEAR_BCNERR_CNT_OTHERS(x) | BIT_BCNERR_CNT_OTHERS(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_RXDMA_AGG_PG_TH			(Offset 0x0280) */

#define BIT_SHIFT_RXDMA_AGG_OLD_MOD 24
#define BIT_MASK_RXDMA_AGG_OLD_MOD 0xff
#define BIT_RXDMA_AGG_OLD_MOD(x)                                               \
	(((x) & BIT_MASK_RXDMA_AGG_OLD_MOD) << BIT_SHIFT_RXDMA_AGG_OLD_MOD)
#define BITS_RXDMA_AGG_OLD_MOD                                                 \
	(BIT_MASK_RXDMA_AGG_OLD_MOD << BIT_SHIFT_RXDMA_AGG_OLD_MOD)
#define BIT_CLEAR_RXDMA_AGG_OLD_MOD(x) ((x) & (~BITS_RXDMA_AGG_OLD_MOD))
#define BIT_GET_RXDMA_AGG_OLD_MOD(x)                                           \
	(((x) >> BIT_SHIFT_RXDMA_AGG_OLD_MOD) & BIT_MASK_RXDMA_AGG_OLD_MOD)
#define BIT_SET_RXDMA_AGG_OLD_MOD(x, v)                                        \
	(BIT_CLEAR_RXDMA_AGG_OLD_MOD(x) | BIT_RXDMA_AGG_OLD_MOD(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || \
     HALMAC_8881A_SUPPORT)

/* 2 REG_RXDMA_AGG_PG_TH			(Offset 0x0280) */

#define BIT_SHIFT_PKT_NUM_WOL 16
#define BIT_MASK_PKT_NUM_WOL 0xff
#define BIT_PKT_NUM_WOL(x)                                                     \
	(((x) & BIT_MASK_PKT_NUM_WOL) << BIT_SHIFT_PKT_NUM_WOL)
#define BITS_PKT_NUM_WOL (BIT_MASK_PKT_NUM_WOL << BIT_SHIFT_PKT_NUM_WOL)
#define BIT_CLEAR_PKT_NUM_WOL(x) ((x) & (~BITS_PKT_NUM_WOL))
#define BIT_GET_PKT_NUM_WOL(x)                                                 \
	(((x) >> BIT_SHIFT_PKT_NUM_WOL) & BIT_MASK_PKT_NUM_WOL)
#define BIT_SET_PKT_NUM_WOL(x, v)                                              \
	(BIT_CLEAR_PKT_NUM_WOL(x) | BIT_PKT_NUM_WOL(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_RXDMA_AGG_PG_TH			(Offset 0x0280) */

#define BIT_SHIFT_RXBCN_TIMER 16
#define BIT_MASK_RXBCN_TIMER 0xffff
#define BIT_RXBCN_TIMER(x)                                                     \
	(((x) & BIT_MASK_RXBCN_TIMER) << BIT_SHIFT_RXBCN_TIMER)
#define BITS_RXBCN_TIMER (BIT_MASK_RXBCN_TIMER << BIT_SHIFT_RXBCN_TIMER)
#define BIT_CLEAR_RXBCN_TIMER(x) ((x) & (~BITS_RXBCN_TIMER))
#define BIT_GET_RXBCN_TIMER(x)                                                 \
	(((x) >> BIT_SHIFT_RXBCN_TIMER) & BIT_MASK_RXBCN_TIMER)
#define BIT_SET_RXBCN_TIMER(x, v)                                              \
	(BIT_CLEAR_RXBCN_TIMER(x) | BIT_RXBCN_TIMER(v))

#define BIT_SHIFT_BCNERR_CNT_INVALID 16
#define BIT_MASK_BCNERR_CNT_INVALID 0xff
#define BIT_BCNERR_CNT_INVALID(x)                                              \
	(((x) & BIT_MASK_BCNERR_CNT_INVALID) << BIT_SHIFT_BCNERR_CNT_INVALID)
#define BITS_BCNERR_CNT_INVALID                                                \
	(BIT_MASK_BCNERR_CNT_INVALID << BIT_SHIFT_BCNERR_CNT_INVALID)
#define BIT_CLEAR_BCNERR_CNT_INVALID(x) ((x) & (~BITS_BCNERR_CNT_INVALID))
#define BIT_GET_BCNERR_CNT_INVALID(x)                                          \
	(((x) >> BIT_SHIFT_BCNERR_CNT_INVALID) & BIT_MASK_BCNERR_CNT_INVALID)
#define BIT_SET_BCNERR_CNT_INVALID(x, v)                                       \
	(BIT_CLEAR_BCNERR_CNT_INVALID(x) | BIT_BCNERR_CNT_INVALID(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_RXDMA_AGG_PG_TH			(Offset 0x0280) */

#define BIT_SHIFT_DMA_AGG_TO_V1 8
#define BIT_MASK_DMA_AGG_TO_V1 0xff
#define BIT_DMA_AGG_TO_V1(x)                                                   \
	(((x) & BIT_MASK_DMA_AGG_TO_V1) << BIT_SHIFT_DMA_AGG_TO_V1)
#define BITS_DMA_AGG_TO_V1 (BIT_MASK_DMA_AGG_TO_V1 << BIT_SHIFT_DMA_AGG_TO_V1)
#define BIT_CLEAR_DMA_AGG_TO_V1(x) ((x) & (~BITS_DMA_AGG_TO_V1))
#define BIT_GET_DMA_AGG_TO_V1(x)                                               \
	(((x) >> BIT_SHIFT_DMA_AGG_TO_V1) & BIT_MASK_DMA_AGG_TO_V1)
#define BIT_SET_DMA_AGG_TO_V1(x, v)                                            \
	(BIT_CLEAR_DMA_AGG_TO_V1(x) | BIT_DMA_AGG_TO_V1(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_RXDMA_AGG_PG_TH			(Offset 0x0280) */

#define BIT_SHIFT_BCNERR_CNT_MAC 8
#define BIT_MASK_BCNERR_CNT_MAC 0xff
#define BIT_BCNERR_CNT_MAC(x)                                                  \
	(((x) & BIT_MASK_BCNERR_CNT_MAC) << BIT_SHIFT_BCNERR_CNT_MAC)
#define BITS_BCNERR_CNT_MAC                                                    \
	(BIT_MASK_BCNERR_CNT_MAC << BIT_SHIFT_BCNERR_CNT_MAC)
#define BIT_CLEAR_BCNERR_CNT_MAC(x) ((x) & (~BITS_BCNERR_CNT_MAC))
#define BIT_GET_BCNERR_CNT_MAC(x)                                              \
	(((x) >> BIT_SHIFT_BCNERR_CNT_MAC) & BIT_MASK_BCNERR_CNT_MAC)
#define BIT_SET_BCNERR_CNT_MAC(x, v)                                           \
	(BIT_CLEAR_BCNERR_CNT_MAC(x) | BIT_BCNERR_CNT_MAC(v))

#endif

#if (HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_RXDMA_AGG_PG_TH			(Offset 0x0280) */

#define BIT_SHIFT_DMA_AGG_TO 8
#define BIT_MASK_DMA_AGG_TO 0xf
#define BIT_DMA_AGG_TO(x) (((x) & BIT_MASK_DMA_AGG_TO) << BIT_SHIFT_DMA_AGG_TO)
#define BITS_DMA_AGG_TO (BIT_MASK_DMA_AGG_TO << BIT_SHIFT_DMA_AGG_TO)
#define BIT_CLEAR_DMA_AGG_TO(x) ((x) & (~BITS_DMA_AGG_TO))
#define BIT_GET_DMA_AGG_TO(x)                                                  \
	(((x) >> BIT_SHIFT_DMA_AGG_TO) & BIT_MASK_DMA_AGG_TO)
#define BIT_SET_DMA_AGG_TO(x, v) (BIT_CLEAR_DMA_AGG_TO(x) | BIT_DMA_AGG_TO(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_RXDMA_AGG_PG_TH			(Offset 0x0280) */

#define BIT_SHIFT_RXDMA_AGG_PG_TH_V1 0
#define BIT_MASK_RXDMA_AGG_PG_TH_V1 0xf
#define BIT_RXDMA_AGG_PG_TH_V1(x)                                              \
	(((x) & BIT_MASK_RXDMA_AGG_PG_TH_V1) << BIT_SHIFT_RXDMA_AGG_PG_TH_V1)
#define BITS_RXDMA_AGG_PG_TH_V1                                                \
	(BIT_MASK_RXDMA_AGG_PG_TH_V1 << BIT_SHIFT_RXDMA_AGG_PG_TH_V1)
#define BIT_CLEAR_RXDMA_AGG_PG_TH_V1(x) ((x) & (~BITS_RXDMA_AGG_PG_TH_V1))
#define BIT_GET_RXDMA_AGG_PG_TH_V1(x)                                          \
	(((x) >> BIT_SHIFT_RXDMA_AGG_PG_TH_V1) & BIT_MASK_RXDMA_AGG_PG_TH_V1)
#define BIT_SET_RXDMA_AGG_PG_TH_V1(x, v)                                       \
	(BIT_CLEAR_RXDMA_AGG_PG_TH_V1(x) | BIT_RXDMA_AGG_PG_TH_V1(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT ||   \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_RXDMA_AGG_PG_TH			(Offset 0x0280) */

#define BIT_SHIFT_RXDMA_AGG_PG_TH 0
#define BIT_MASK_RXDMA_AGG_PG_TH 0xff
#define BIT_RXDMA_AGG_PG_TH(x)                                                 \
	(((x) & BIT_MASK_RXDMA_AGG_PG_TH) << BIT_SHIFT_RXDMA_AGG_PG_TH)
#define BITS_RXDMA_AGG_PG_TH                                                   \
	(BIT_MASK_RXDMA_AGG_PG_TH << BIT_SHIFT_RXDMA_AGG_PG_TH)
#define BIT_CLEAR_RXDMA_AGG_PG_TH(x) ((x) & (~BITS_RXDMA_AGG_PG_TH))
#define BIT_GET_RXDMA_AGG_PG_TH(x)                                             \
	(((x) >> BIT_SHIFT_RXDMA_AGG_PG_TH) & BIT_MASK_RXDMA_AGG_PG_TH)
#define BIT_SET_RXDMA_AGG_PG_TH(x, v)                                          \
	(BIT_CLEAR_RXDMA_AGG_PG_TH(x) | BIT_RXDMA_AGG_PG_TH(v))

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_RXDMA_AGG_PG_TH			(Offset 0x0280) */

#define BIT_SHIFT_QINFO_INDEX 0
#define BIT_MASK_QINFO_INDEX 0x1f
#define BIT_QINFO_INDEX(x)                                                     \
	(((x) & BIT_MASK_QINFO_INDEX) << BIT_SHIFT_QINFO_INDEX)
#define BITS_QINFO_INDEX (BIT_MASK_QINFO_INDEX << BIT_SHIFT_QINFO_INDEX)
#define BIT_CLEAR_QINFO_INDEX(x) ((x) & (~BITS_QINFO_INDEX))
#define BIT_GET_QINFO_INDEX(x)                                                 \
	(((x) >> BIT_SHIFT_QINFO_INDEX) & BIT_MASK_QINFO_INDEX)
#define BIT_SET_QINFO_INDEX(x, v)                                              \
	(BIT_CLEAR_QINFO_INDEX(x) | BIT_QINFO_INDEX(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_RXDMA_AGG_PG_TH			(Offset 0x0280) */

#define BIT_SHIFT_BCNERR_CNT_CCA 0
#define BIT_MASK_BCNERR_CNT_CCA 0xff
#define BIT_BCNERR_CNT_CCA(x)                                                  \
	(((x) & BIT_MASK_BCNERR_CNT_CCA) << BIT_SHIFT_BCNERR_CNT_CCA)
#define BITS_BCNERR_CNT_CCA                                                    \
	(BIT_MASK_BCNERR_CNT_CCA << BIT_SHIFT_BCNERR_CNT_CCA)
#define BIT_CLEAR_BCNERR_CNT_CCA(x) ((x) & (~BITS_BCNERR_CNT_CCA))
#define BIT_GET_BCNERR_CNT_CCA(x)                                              \
	(((x) >> BIT_SHIFT_BCNERR_CNT_CCA) & BIT_MASK_BCNERR_CNT_CCA)
#define BIT_SET_BCNERR_CNT_CCA(x, v)                                           \
	(BIT_CLEAR_BCNERR_CNT_CCA(x) | BIT_BCNERR_CNT_CCA(v))

#endif

#if (HALMAC_8814AMP_SUPPORT)

/* 2 REG_RXDMA_AGG_PG_TH			(Offset 0x0280) */

#define BIT_SHIFT_RXDMA_AGG_PG_TH_V2 0
#define BIT_MASK_RXDMA_AGG_PG_TH_V2 0xff
#define BIT_RXDMA_AGG_PG_TH_V2(x)                                              \
	(((x) & BIT_MASK_RXDMA_AGG_PG_TH_V2) << BIT_SHIFT_RXDMA_AGG_PG_TH_V2)
#define BITS_RXDMA_AGG_PG_TH_V2                                                \
	(BIT_MASK_RXDMA_AGG_PG_TH_V2 << BIT_SHIFT_RXDMA_AGG_PG_TH_V2)
#define BIT_CLEAR_RXDMA_AGG_PG_TH_V2(x) ((x) & (~BITS_RXDMA_AGG_PG_TH_V2))
#define BIT_GET_RXDMA_AGG_PG_TH_V2(x)                                          \
	(((x) >> BIT_SHIFT_RXDMA_AGG_PG_TH_V2) & BIT_MASK_RXDMA_AGG_PG_TH_V2)
#define BIT_SET_RXDMA_AGG_PG_TH_V2(x, v)                                       \
	(BIT_CLEAR_RXDMA_AGG_PG_TH_V2(x) | BIT_RXDMA_AGG_PG_TH_V2(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || \
     HALMAC_8881A_SUPPORT)

/* 2 REG_RXPKT_NUM				(Offset 0x0284) */

#define BIT_SHIFT_RXPKT_NUM 24
#define BIT_MASK_RXPKT_NUM 0xff
#define BIT_RXPKT_NUM(x) (((x) & BIT_MASK_RXPKT_NUM) << BIT_SHIFT_RXPKT_NUM)
#define BITS_RXPKT_NUM (BIT_MASK_RXPKT_NUM << BIT_SHIFT_RXPKT_NUM)
#define BIT_CLEAR_RXPKT_NUM(x) ((x) & (~BITS_RXPKT_NUM))
#define BIT_GET_RXPKT_NUM(x) (((x) >> BIT_SHIFT_RXPKT_NUM) & BIT_MASK_RXPKT_NUM)
#define BIT_SET_RXPKT_NUM(x, v) (BIT_CLEAR_RXPKT_NUM(x) | BIT_RXPKT_NUM(v))

#endif

#if (HALMAC_8192F_SUPPORT)

/* 2 REG_RXPKT_NUM				(Offset 0x0284) */

#define BIT_STOP_RXDMA BIT(20)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_RXPKT_NUM				(Offset 0x0284) */

#define BIT_SHIFT_FW_UPD_RDPTR19_TO_16 20
#define BIT_MASK_FW_UPD_RDPTR19_TO_16 0xf
#define BIT_FW_UPD_RDPTR19_TO_16(x)                                            \
	(((x) & BIT_MASK_FW_UPD_RDPTR19_TO_16)                                 \
	 << BIT_SHIFT_FW_UPD_RDPTR19_TO_16)
#define BITS_FW_UPD_RDPTR19_TO_16                                              \
	(BIT_MASK_FW_UPD_RDPTR19_TO_16 << BIT_SHIFT_FW_UPD_RDPTR19_TO_16)
#define BIT_CLEAR_FW_UPD_RDPTR19_TO_16(x) ((x) & (~BITS_FW_UPD_RDPTR19_TO_16))
#define BIT_GET_FW_UPD_RDPTR19_TO_16(x)                                        \
	(((x) >> BIT_SHIFT_FW_UPD_RDPTR19_TO_16) &                             \
	 BIT_MASK_FW_UPD_RDPTR19_TO_16)
#define BIT_SET_FW_UPD_RDPTR19_TO_16(x, v)                                     \
	(BIT_CLEAR_FW_UPD_RDPTR19_TO_16(x) | BIT_FW_UPD_RDPTR19_TO_16(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_RXPKT_NUM				(Offset 0x0284) */

#define BIT_RXDMA_REQ BIT(19)
#define BIT_RW_RELEASE_EN BIT(18)
#define BIT_RXDMA_IDLE BIT(17)
#define BIT_RXPKT_RELEASE_POLL BIT(16)

#define BIT_SHIFT_FW_UPD_RDPTR 0
#define BIT_MASK_FW_UPD_RDPTR 0xffff
#define BIT_FW_UPD_RDPTR(x)                                                    \
	(((x) & BIT_MASK_FW_UPD_RDPTR) << BIT_SHIFT_FW_UPD_RDPTR)
#define BITS_FW_UPD_RDPTR (BIT_MASK_FW_UPD_RDPTR << BIT_SHIFT_FW_UPD_RDPTR)
#define BIT_CLEAR_FW_UPD_RDPTR(x) ((x) & (~BITS_FW_UPD_RDPTR))
#define BIT_GET_FW_UPD_RDPTR(x)                                                \
	(((x) >> BIT_SHIFT_FW_UPD_RDPTR) & BIT_MASK_FW_UPD_RDPTR)
#define BIT_SET_FW_UPD_RDPTR(x, v)                                             \
	(BIT_CLEAR_FW_UPD_RDPTR(x) | BIT_FW_UPD_RDPTR(v))

#endif

#if (HALMAC_8197F_SUPPORT)

/* 2 REG_RXDMA_STATUS			(Offset 0x0288) */

#define BIT_FC2H_PKT_OVERFLOW BIT(8)

#endif

#if (HALMAC_8197G_SUPPORT)

/* 2 REG_RXDMA_STATUS			(Offset 0x0288) */

#define BIT_FC2H_PKT_OVF BIT(8)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_RXDMA_STATUS			(Offset 0x0288) */

#define BIT_C2H_PKT_OVF BIT(7)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_RXDMA_STATUS			(Offset 0x0288) */

#define BIT_AGG_CFG_ISSUE BIT(6)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_RXDMA_STATUS			(Offset 0x0288) */

#define BIT_AGG_CONFGI_ISSUE BIT(6)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_RXDMA_STATUS			(Offset 0x0288) */

#define BIT_FW_POLL_ISSUE BIT(5)
#define BIT_RX_DATA_UDN BIT(4)
#define BIT_RX_SFF_UDN BIT(3)
#define BIT_RX_SFF_OVF BIT(2)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_RXDMA_STATUS			(Offset 0x0288) */

#define BIT_USB_REQ_LEN_OVF BIT(1)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_RXDMA_STATUS			(Offset 0x0288) */

#define BIT_RXPKT_OVF BIT(0)

/* 2 REG_RXDMA_DPR				(Offset 0x028C) */

#define BIT_SHIFT_RDE_DEBUG 0
#define BIT_MASK_RDE_DEBUG 0xffffffffL
#define BIT_RDE_DEBUG(x) (((x) & BIT_MASK_RDE_DEBUG) << BIT_SHIFT_RDE_DEBUG)
#define BITS_RDE_DEBUG (BIT_MASK_RDE_DEBUG << BIT_SHIFT_RDE_DEBUG)
#define BIT_CLEAR_RDE_DEBUG(x) ((x) & (~BITS_RDE_DEBUG))
#define BIT_GET_RDE_DEBUG(x) (((x) >> BIT_SHIFT_RDE_DEBUG) & BIT_MASK_RDE_DEBUG)
#define BIT_SET_RDE_DEBUG(x, v) (BIT_CLEAR_RDE_DEBUG(x) | BIT_RDE_DEBUG(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT ||   \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_RXDMA_MODE				(Offset 0x0290) */

#define BIT_SHIFT_PKTNUM_TH_V2 24
#define BIT_MASK_PKTNUM_TH_V2 0x1f
#define BIT_PKTNUM_TH_V2(x)                                                    \
	(((x) & BIT_MASK_PKTNUM_TH_V2) << BIT_SHIFT_PKTNUM_TH_V2)
#define BITS_PKTNUM_TH_V2 (BIT_MASK_PKTNUM_TH_V2 << BIT_SHIFT_PKTNUM_TH_V2)
#define BIT_CLEAR_PKTNUM_TH_V2(x) ((x) & (~BITS_PKTNUM_TH_V2))
#define BIT_GET_PKTNUM_TH_V2(x)                                                \
	(((x) >> BIT_SHIFT_PKTNUM_TH_V2) & BIT_MASK_PKTNUM_TH_V2)
#define BIT_SET_PKTNUM_TH_V2(x, v)                                             \
	(BIT_CLEAR_PKTNUM_TH_V2(x) | BIT_PKTNUM_TH_V2(v))

#define BIT_TXBA_BREAK_USBAGG BIT(23)

#define BIT_SHIFT_PKTLEN_PARA 16
#define BIT_MASK_PKTLEN_PARA 0x7
#define BIT_PKTLEN_PARA(x)                                                     \
	(((x) & BIT_MASK_PKTLEN_PARA) << BIT_SHIFT_PKTLEN_PARA)
#define BITS_PKTLEN_PARA (BIT_MASK_PKTLEN_PARA << BIT_SHIFT_PKTLEN_PARA)
#define BIT_CLEAR_PKTLEN_PARA(x) ((x) & (~BITS_PKTLEN_PARA))
#define BIT_GET_PKTLEN_PARA(x)                                                 \
	(((x) >> BIT_SHIFT_PKTLEN_PARA) & BIT_MASK_PKTLEN_PARA)
#define BIT_SET_PKTLEN_PARA(x, v)                                              \
	(BIT_CLEAR_PKTLEN_PARA(x) | BIT_PKTLEN_PARA(v))

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_RXDMA_MODE				(Offset 0x0290) */

#define BIT_EN_SDIO_FAIL BIT(9)

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8814AMP_SUPPORT)

/* 2 REG_RXDMA_MODE				(Offset 0x0290) */

#define BIT_GRAYCODE_SYNC_WITH_BIN BIT(8)

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_RXDMA_MODE				(Offset 0x0290) */

#define BIT_RXDMA_DBD_SEL BIT(7)

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_RXDMA_MODE				(Offset 0x0290) */

#define BIT_RX_DBG_SEL BIT(7)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_RXDMA_MODE				(Offset 0x0290) */

#define BIT_EN_SPD BIT(6)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_RXDMA_MODE				(Offset 0x0290) */

#define BIT_SHIFT_BURST_SIZE 4
#define BIT_MASK_BURST_SIZE 0x3
#define BIT_BURST_SIZE(x) (((x) & BIT_MASK_BURST_SIZE) << BIT_SHIFT_BURST_SIZE)
#define BITS_BURST_SIZE (BIT_MASK_BURST_SIZE << BIT_SHIFT_BURST_SIZE)
#define BIT_CLEAR_BURST_SIZE(x) ((x) & (~BITS_BURST_SIZE))
#define BIT_GET_BURST_SIZE(x)                                                  \
	(((x) >> BIT_SHIFT_BURST_SIZE) & BIT_MASK_BURST_SIZE)
#define BIT_SET_BURST_SIZE(x, v) (BIT_CLEAR_BURST_SIZE(x) | BIT_BURST_SIZE(v))

#define BIT_SHIFT_BURST_CNT 2
#define BIT_MASK_BURST_CNT 0x3
#define BIT_BURST_CNT(x) (((x) & BIT_MASK_BURST_CNT) << BIT_SHIFT_BURST_CNT)
#define BITS_BURST_CNT (BIT_MASK_BURST_CNT << BIT_SHIFT_BURST_CNT)
#define BIT_CLEAR_BURST_CNT(x) ((x) & (~BITS_BURST_CNT))
#define BIT_GET_BURST_CNT(x) (((x) >> BIT_SHIFT_BURST_CNT) & BIT_MASK_BURST_CNT)
#define BIT_SET_BURST_CNT(x, v) (BIT_CLEAR_BURST_CNT(x) | BIT_BURST_CNT(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_RXDMA_MODE				(Offset 0x0290) */

#define BIT_DAM_MODE BIT(1)

#endif

#if (HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT ||   \
     HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_RXDMA_MODE				(Offset 0x0290) */

#define BIT_DMA_MODE BIT(1)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_C2H_PKT				(Offset 0x0294) */

#define BIT_SHIFT_R_C2H_STR_ADDR_16_TO_19 24
#define BIT_MASK_R_C2H_STR_ADDR_16_TO_19 0xf
#define BIT_R_C2H_STR_ADDR_16_TO_19(x)                                         \
	(((x) & BIT_MASK_R_C2H_STR_ADDR_16_TO_19)                              \
	 << BIT_SHIFT_R_C2H_STR_ADDR_16_TO_19)
#define BITS_R_C2H_STR_ADDR_16_TO_19                                           \
	(BIT_MASK_R_C2H_STR_ADDR_16_TO_19 << BIT_SHIFT_R_C2H_STR_ADDR_16_TO_19)
#define BIT_CLEAR_R_C2H_STR_ADDR_16_TO_19(x)                                   \
	((x) & (~BITS_R_C2H_STR_ADDR_16_TO_19))
#define BIT_GET_R_C2H_STR_ADDR_16_TO_19(x)                                     \
	(((x) >> BIT_SHIFT_R_C2H_STR_ADDR_16_TO_19) &                          \
	 BIT_MASK_R_C2H_STR_ADDR_16_TO_19)
#define BIT_SET_R_C2H_STR_ADDR_16_TO_19(x, v)                                  \
	(BIT_CLEAR_R_C2H_STR_ADDR_16_TO_19(x) | BIT_R_C2H_STR_ADDR_16_TO_19(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT ||   \
     HALMAC_8881A_SUPPORT)

/* 2 REG_C2H_PKT				(Offset 0x0294) */

#define BIT_R_C2H_PKT_REQ BIT(16)

#define BIT_SHIFT_R_C2H_STR_ADDR 0
#define BIT_MASK_R_C2H_STR_ADDR 0xffff
#define BIT_R_C2H_STR_ADDR(x)                                                  \
	(((x) & BIT_MASK_R_C2H_STR_ADDR) << BIT_SHIFT_R_C2H_STR_ADDR)
#define BITS_R_C2H_STR_ADDR                                                    \
	(BIT_MASK_R_C2H_STR_ADDR << BIT_SHIFT_R_C2H_STR_ADDR)
#define BIT_CLEAR_R_C2H_STR_ADDR(x) ((x) & (~BITS_R_C2H_STR_ADDR))
#define BIT_GET_R_C2H_STR_ADDR(x)                                              \
	(((x) >> BIT_SHIFT_R_C2H_STR_ADDR) & BIT_MASK_R_C2H_STR_ADDR)
#define BIT_SET_R_C2H_STR_ADDR(x, v)                                           \
	(BIT_CLEAR_R_C2H_STR_ADDR(x) | BIT_R_C2H_STR_ADDR(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWFF_C2H				(Offset 0x0298) */

#define BIT_SHIFT_C2H_DMA_ADDR 0
#define BIT_MASK_C2H_DMA_ADDR 0x3ffff
#define BIT_C2H_DMA_ADDR(x)                                                    \
	(((x) & BIT_MASK_C2H_DMA_ADDR) << BIT_SHIFT_C2H_DMA_ADDR)
#define BITS_C2H_DMA_ADDR (BIT_MASK_C2H_DMA_ADDR << BIT_SHIFT_C2H_DMA_ADDR)
#define BIT_CLEAR_C2H_DMA_ADDR(x) ((x) & (~BITS_C2H_DMA_ADDR))
#define BIT_GET_C2H_DMA_ADDR(x)                                                \
	(((x) >> BIT_SHIFT_C2H_DMA_ADDR) & BIT_MASK_C2H_DMA_ADDR)
#define BIT_SET_C2H_DMA_ADDR(x, v)                                             \
	(BIT_CLEAR_C2H_DMA_ADDR(x) | BIT_C2H_DMA_ADDR(v))

/* 2 REG_FWFF_CTRL				(Offset 0x029C) */

#define BIT_FWFF_DMAPKT_REQ BIT(31)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FWFF_CTRL				(Offset 0x029C) */

#define BIT_SHIFT_FWFF_DMA_PKT_NUM 16
#define BIT_MASK_FWFF_DMA_PKT_NUM 0xff
#define BIT_FWFF_DMA_PKT_NUM(x)                                                \
	(((x) & BIT_MASK_FWFF_DMA_PKT_NUM) << BIT_SHIFT_FWFF_DMA_PKT_NUM)
#define BITS_FWFF_DMA_PKT_NUM                                                  \
	(BIT_MASK_FWFF_DMA_PKT_NUM << BIT_SHIFT_FWFF_DMA_PKT_NUM)
#define BIT_CLEAR_FWFF_DMA_PKT_NUM(x) ((x) & (~BITS_FWFF_DMA_PKT_NUM))
#define BIT_GET_FWFF_DMA_PKT_NUM(x)                                            \
	(((x) >> BIT_SHIFT_FWFF_DMA_PKT_NUM) & BIT_MASK_FWFF_DMA_PKT_NUM)
#define BIT_SET_FWFF_DMA_PKT_NUM(x, v)                                         \
	(BIT_CLEAR_FWFF_DMA_PKT_NUM(x) | BIT_FWFF_DMA_PKT_NUM(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_FWFF_CTRL				(Offset 0x029C) */

#define BIT_SHIFT_FWFF_DMA_PKT_NUM_V1 16
#define BIT_MASK_FWFF_DMA_PKT_NUM_V1 0x7fff
#define BIT_FWFF_DMA_PKT_NUM_V1(x)                                             \
	(((x) & BIT_MASK_FWFF_DMA_PKT_NUM_V1) << BIT_SHIFT_FWFF_DMA_PKT_NUM_V1)
#define BITS_FWFF_DMA_PKT_NUM_V1                                               \
	(BIT_MASK_FWFF_DMA_PKT_NUM_V1 << BIT_SHIFT_FWFF_DMA_PKT_NUM_V1)
#define BIT_CLEAR_FWFF_DMA_PKT_NUM_V1(x) ((x) & (~BITS_FWFF_DMA_PKT_NUM_V1))
#define BIT_GET_FWFF_DMA_PKT_NUM_V1(x)                                         \
	(((x) >> BIT_SHIFT_FWFF_DMA_PKT_NUM_V1) & BIT_MASK_FWFF_DMA_PKT_NUM_V1)
#define BIT_SET_FWFF_DMA_PKT_NUM_V1(x, v)                                      \
	(BIT_CLEAR_FWFF_DMA_PKT_NUM_V1(x) | BIT_FWFF_DMA_PKT_NUM_V1(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT ||   \
     HALMAC_8822C_SUPPORT)

/* 2 REG_FWFF_CTRL				(Offset 0x029C) */

#define BIT_SHIFT_FWFF_STR_ADDR 0
#define BIT_MASK_FWFF_STR_ADDR 0xffff
#define BIT_FWFF_STR_ADDR(x)                                                   \
	(((x) & BIT_MASK_FWFF_STR_ADDR) << BIT_SHIFT_FWFF_STR_ADDR)
#define BITS_FWFF_STR_ADDR (BIT_MASK_FWFF_STR_ADDR << BIT_SHIFT_FWFF_STR_ADDR)
#define BIT_CLEAR_FWFF_STR_ADDR(x) ((x) & (~BITS_FWFF_STR_ADDR))
#define BIT_GET_FWFF_STR_ADDR(x)                                               \
	(((x) >> BIT_SHIFT_FWFF_STR_ADDR) & BIT_MASK_FWFF_STR_ADDR)
#define BIT_SET_FWFF_STR_ADDR(x, v)                                            \
	(BIT_CLEAR_FWFF_STR_ADDR(x) | BIT_FWFF_STR_ADDR(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8812F_SUPPORT || HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FWFF_PKT_INFO			(Offset 0x02A0) */

#define BIT_SHIFT_FWFF_PKT_QUEUED 16
#define BIT_MASK_FWFF_PKT_QUEUED 0xff
#define BIT_FWFF_PKT_QUEUED(x)                                                 \
	(((x) & BIT_MASK_FWFF_PKT_QUEUED) << BIT_SHIFT_FWFF_PKT_QUEUED)
#define BITS_FWFF_PKT_QUEUED                                                   \
	(BIT_MASK_FWFF_PKT_QUEUED << BIT_SHIFT_FWFF_PKT_QUEUED)
#define BIT_CLEAR_FWFF_PKT_QUEUED(x) ((x) & (~BITS_FWFF_PKT_QUEUED))
#define BIT_GET_FWFF_PKT_QUEUED(x)                                             \
	(((x) >> BIT_SHIFT_FWFF_PKT_QUEUED) & BIT_MASK_FWFF_PKT_QUEUED)
#define BIT_SET_FWFF_PKT_QUEUED(x, v)                                          \
	(BIT_CLEAR_FWFF_PKT_QUEUED(x) | BIT_FWFF_PKT_QUEUED(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_FWFF_PKT_INFO			(Offset 0x02A0) */

#define BIT_SHIFT_FWFF_PKT_READ_ADDR 16
#define BIT_MASK_FWFF_PKT_READ_ADDR 0xffff
#define BIT_FWFF_PKT_READ_ADDR(x)                                              \
	(((x) & BIT_MASK_FWFF_PKT_READ_ADDR) << BIT_SHIFT_FWFF_PKT_READ_ADDR)
#define BITS_FWFF_PKT_READ_ADDR                                                \
	(BIT_MASK_FWFF_PKT_READ_ADDR << BIT_SHIFT_FWFF_PKT_READ_ADDR)
#define BIT_CLEAR_FWFF_PKT_READ_ADDR(x) ((x) & (~BITS_FWFF_PKT_READ_ADDR))
#define BIT_GET_FWFF_PKT_READ_ADDR(x)                                          \
	(((x) >> BIT_SHIFT_FWFF_PKT_READ_ADDR) & BIT_MASK_FWFF_PKT_READ_ADDR)
#define BIT_SET_FWFF_PKT_READ_ADDR(x, v)                                       \
	(BIT_CLEAR_FWFF_PKT_READ_ADDR(x) | BIT_FWFF_PKT_READ_ADDR(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT)

/* 2 REG_FWFF_PKT_INFO			(Offset 0x02A0) */

#define BIT_SHIFT_FWFF_PKT_STR_ADDR 0
#define BIT_MASK_FWFF_PKT_STR_ADDR 0xffff
#define BIT_FWFF_PKT_STR_ADDR(x)                                               \
	(((x) & BIT_MASK_FWFF_PKT_STR_ADDR) << BIT_SHIFT_FWFF_PKT_STR_ADDR)
#define BITS_FWFF_PKT_STR_ADDR                                                 \
	(BIT_MASK_FWFF_PKT_STR_ADDR << BIT_SHIFT_FWFF_PKT_STR_ADDR)
#define BIT_CLEAR_FWFF_PKT_STR_ADDR(x) ((x) & (~BITS_FWFF_PKT_STR_ADDR))
#define BIT_GET_FWFF_PKT_STR_ADDR(x)                                           \
	(((x) >> BIT_SHIFT_FWFF_PKT_STR_ADDR) & BIT_MASK_FWFF_PKT_STR_ADDR)
#define BIT_SET_FWFF_PKT_STR_ADDR(x, v)                                        \
	(BIT_CLEAR_FWFF_PKT_STR_ADDR(x) | BIT_FWFF_PKT_STR_ADDR(v))

#endif

#if (HALMAC_8814AMP_SUPPORT)

/* 2 REG_FWFF_PKT_INFO			(Offset 0x02A0) */

#define BIT_SHIFT_FWFF_PKT_STR_ADDR_V1 0
#define BIT_MASK_FWFF_PKT_STR_ADDR_V1 0x7ff
#define BIT_FWFF_PKT_STR_ADDR_V1(x)                                            \
	(((x) & BIT_MASK_FWFF_PKT_STR_ADDR_V1)                                 \
	 << BIT_SHIFT_FWFF_PKT_STR_ADDR_V1)
#define BITS_FWFF_PKT_STR_ADDR_V1                                              \
	(BIT_MASK_FWFF_PKT_STR_ADDR_V1 << BIT_SHIFT_FWFF_PKT_STR_ADDR_V1)
#define BIT_CLEAR_FWFF_PKT_STR_ADDR_V1(x) ((x) & (~BITS_FWFF_PKT_STR_ADDR_V1))
#define BIT_GET_FWFF_PKT_STR_ADDR_V1(x)                                        \
	(((x) >> BIT_SHIFT_FWFF_PKT_STR_ADDR_V1) &                             \
	 BIT_MASK_FWFF_PKT_STR_ADDR_V1)
#define BIT_SET_FWFF_PKT_STR_ADDR_V1(x, v)                                     \
	(BIT_CLEAR_FWFF_PKT_STR_ADDR_V1(x) | BIT_FWFF_PKT_STR_ADDR_V1(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_FWFF_PKT_INFO			(Offset 0x02A0) */

#define BIT_SHIFT_FWFF_PKT_WRITE_ADDR 0
#define BIT_MASK_FWFF_PKT_WRITE_ADDR 0xffff
#define BIT_FWFF_PKT_WRITE_ADDR(x)                                             \
	(((x) & BIT_MASK_FWFF_PKT_WRITE_ADDR) << BIT_SHIFT_FWFF_PKT_WRITE_ADDR)
#define BITS_FWFF_PKT_WRITE_ADDR                                               \
	(BIT_MASK_FWFF_PKT_WRITE_ADDR << BIT_SHIFT_FWFF_PKT_WRITE_ADDR)
#define BIT_CLEAR_FWFF_PKT_WRITE_ADDR(x) ((x) & (~BITS_FWFF_PKT_WRITE_ADDR))
#define BIT_GET_FWFF_PKT_WRITE_ADDR(x)                                         \
	(((x) >> BIT_SHIFT_FWFF_PKT_WRITE_ADDR) & BIT_MASK_FWFF_PKT_WRITE_ADDR)
#define BIT_SET_FWFF_PKT_WRITE_ADDR(x, v)                                      \
	(BIT_CLEAR_FWFF_PKT_WRITE_ADDR(x) | BIT_FWFF_PKT_WRITE_ADDR(v))

#endif

#if (HALMAC_8197F_SUPPORT)

/* 2 REG_FC2H_INFO				(Offset 0x02A4) */

#define BIT_FC2H_PKT_REQ BIT(16)

#endif

#if (HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_FC2H_INFO				(Offset 0x02A4) */

#define BIT_FC2H_DMAPKT_REQ BIT(16)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_FC2H_INFO				(Offset 0x02A4) */

#define BIT_SHIFT_FC2H_STR_ADDR 0
#define BIT_MASK_FC2H_STR_ADDR 0xffff
#define BIT_FC2H_STR_ADDR(x)                                                   \
	(((x) & BIT_MASK_FC2H_STR_ADDR) << BIT_SHIFT_FC2H_STR_ADDR)
#define BITS_FC2H_STR_ADDR (BIT_MASK_FC2H_STR_ADDR << BIT_SHIFT_FC2H_STR_ADDR)
#define BIT_CLEAR_FC2H_STR_ADDR(x) ((x) & (~BITS_FC2H_STR_ADDR))
#define BIT_GET_FC2H_STR_ADDR(x)                                               \
	(((x) >> BIT_SHIFT_FC2H_STR_ADDR) & BIT_MASK_FC2H_STR_ADDR)
#define BIT_SET_FC2H_STR_ADDR(x, v)                                            \
	(BIT_CLEAR_FC2H_STR_ADDR(x) | BIT_FC2H_STR_ADDR(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_FWFF_PKT_INFO2			(Offset 0x02A4) */

#define BIT_SHIFT_FWFF_PKT_QUEUED_V1 0
#define BIT_MASK_FWFF_PKT_QUEUED_V1 0xffff
#define BIT_FWFF_PKT_QUEUED_V1(x)                                              \
	(((x) & BIT_MASK_FWFF_PKT_QUEUED_V1) << BIT_SHIFT_FWFF_PKT_QUEUED_V1)
#define BITS_FWFF_PKT_QUEUED_V1                                                \
	(BIT_MASK_FWFF_PKT_QUEUED_V1 << BIT_SHIFT_FWFF_PKT_QUEUED_V1)
#define BIT_CLEAR_FWFF_PKT_QUEUED_V1(x) ((x) & (~BITS_FWFF_PKT_QUEUED_V1))
#define BIT_GET_FWFF_PKT_QUEUED_V1(x)                                          \
	(((x) >> BIT_SHIFT_FWFF_PKT_QUEUED_V1) & BIT_MASK_FWFF_PKT_QUEUED_V1)
#define BIT_SET_FWFF_PKT_QUEUED_V1(x, v)                                       \
	(BIT_CLEAR_FWFF_PKT_QUEUED_V1(x) | BIT_FWFF_PKT_QUEUED_V1(v))

#define BIT_SHIFT_FW_UPD_RXDES_RD_PTR 0
#define BIT_MASK_FW_UPD_RXDES_RD_PTR 0x3ffff
#define BIT_FW_UPD_RXDES_RD_PTR(x)                                             \
	(((x) & BIT_MASK_FW_UPD_RXDES_RD_PTR) << BIT_SHIFT_FW_UPD_RXDES_RD_PTR)
#define BITS_FW_UPD_RXDES_RD_PTR                                               \
	(BIT_MASK_FW_UPD_RXDES_RD_PTR << BIT_SHIFT_FW_UPD_RXDES_RD_PTR)
#define BIT_CLEAR_FW_UPD_RXDES_RD_PTR(x) ((x) & (~BITS_FW_UPD_RXDES_RD_PTR))
#define BIT_GET_FW_UPD_RXDES_RD_PTR(x)                                         \
	(((x) >> BIT_SHIFT_FW_UPD_RXDES_RD_PTR) & BIT_MASK_FW_UPD_RXDES_RD_PTR)
#define BIT_SET_FW_UPD_RXDES_RD_PTR(x, v)                                      \
	(BIT_CLEAR_FW_UPD_RXDES_RD_PTR(x) | BIT_FW_UPD_RXDES_RD_PTR(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_RXPKTNUM				(Offset 0x02B0) */

#define BIT_SHIFT_PKT_NUM_WOL_V1 16
#define BIT_MASK_PKT_NUM_WOL_V1 0xffff
#define BIT_PKT_NUM_WOL_V1(x)                                                  \
	(((x) & BIT_MASK_PKT_NUM_WOL_V1) << BIT_SHIFT_PKT_NUM_WOL_V1)
#define BITS_PKT_NUM_WOL_V1                                                    \
	(BIT_MASK_PKT_NUM_WOL_V1 << BIT_SHIFT_PKT_NUM_WOL_V1)
#define BIT_CLEAR_PKT_NUM_WOL_V1(x) ((x) & (~BITS_PKT_NUM_WOL_V1))
#define BIT_GET_PKT_NUM_WOL_V1(x)                                              \
	(((x) >> BIT_SHIFT_PKT_NUM_WOL_V1) & BIT_MASK_PKT_NUM_WOL_V1)
#define BIT_SET_PKT_NUM_WOL_V1(x, v)                                           \
	(BIT_CLEAR_PKT_NUM_WOL_V1(x) | BIT_PKT_NUM_WOL_V1(v))

#define BIT_SHIFT_RXPKT_NUM_V1 0
#define BIT_MASK_RXPKT_NUM_V1 0xffff
#define BIT_RXPKT_NUM_V1(x)                                                    \
	(((x) & BIT_MASK_RXPKT_NUM_V1) << BIT_SHIFT_RXPKT_NUM_V1)
#define BITS_RXPKT_NUM_V1 (BIT_MASK_RXPKT_NUM_V1 << BIT_SHIFT_RXPKT_NUM_V1)
#define BIT_CLEAR_RXPKT_NUM_V1(x) ((x) & (~BITS_RXPKT_NUM_V1))
#define BIT_GET_RXPKT_NUM_V1(x)                                                \
	(((x) >> BIT_SHIFT_RXPKT_NUM_V1) & BIT_MASK_RXPKT_NUM_V1)
#define BIT_SET_RXPKT_NUM_V1(x, v)                                             \
	(BIT_CLEAR_RXPKT_NUM_V1(x) | BIT_RXPKT_NUM_V1(v))

#define BIT_SHIFT_RXPKT_NUM_TH 0
#define BIT_MASK_RXPKT_NUM_TH 0xff
#define BIT_RXPKT_NUM_TH(x)                                                    \
	(((x) & BIT_MASK_RXPKT_NUM_TH) << BIT_SHIFT_RXPKT_NUM_TH)
#define BITS_RXPKT_NUM_TH (BIT_MASK_RXPKT_NUM_TH << BIT_SHIFT_RXPKT_NUM_TH)
#define BIT_CLEAR_RXPKT_NUM_TH(x) ((x) & (~BITS_RXPKT_NUM_TH))
#define BIT_GET_RXPKT_NUM_TH(x)                                                \
	(((x) >> BIT_SHIFT_RXPKT_NUM_TH) & BIT_MASK_RXPKT_NUM_TH)
#define BIT_SET_RXPKT_NUM_TH(x, v)                                             \
	(BIT_CLEAR_RXPKT_NUM_TH(x) | BIT_RXPKT_NUM_TH(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_FW_MSG1				(Offset 0x02E0) */

#define BIT_SHIFT_FW_MSG_REG1 0
#define BIT_MASK_FW_MSG_REG1 0xffffffffL
#define BIT_FW_MSG_REG1(x)                                                     \
	(((x) & BIT_MASK_FW_MSG_REG1) << BIT_SHIFT_FW_MSG_REG1)
#define BITS_FW_MSG_REG1 (BIT_MASK_FW_MSG_REG1 << BIT_SHIFT_FW_MSG_REG1)
#define BIT_CLEAR_FW_MSG_REG1(x) ((x) & (~BITS_FW_MSG_REG1))
#define BIT_GET_FW_MSG_REG1(x)                                                 \
	(((x) >> BIT_SHIFT_FW_MSG_REG1) & BIT_MASK_FW_MSG_REG1)
#define BIT_SET_FW_MSG_REG1(x, v)                                              \
	(BIT_CLEAR_FW_MSG_REG1(x) | BIT_FW_MSG_REG1(v))

/* 2 REG_FW_MSG2				(Offset 0x02E4) */

#define BIT_SHIFT_FW_MSG_REG2 0
#define BIT_MASK_FW_MSG_REG2 0xffffffffL
#define BIT_FW_MSG_REG2(x)                                                     \
	(((x) & BIT_MASK_FW_MSG_REG2) << BIT_SHIFT_FW_MSG_REG2)
#define BITS_FW_MSG_REG2 (BIT_MASK_FW_MSG_REG2 << BIT_SHIFT_FW_MSG_REG2)
#define BIT_CLEAR_FW_MSG_REG2(x) ((x) & (~BITS_FW_MSG_REG2))
#define BIT_GET_FW_MSG_REG2(x)                                                 \
	(((x) >> BIT_SHIFT_FW_MSG_REG2) & BIT_MASK_FW_MSG_REG2)
#define BIT_SET_FW_MSG_REG2(x, v)                                              \
	(BIT_CLEAR_FW_MSG_REG2(x) | BIT_FW_MSG_REG2(v))

/* 2 REG_FW_MSG3				(Offset 0x02E8) */

#define BIT_SHIFT_FW_MSG_REG3 0
#define BIT_MASK_FW_MSG_REG3 0xffffffffL
#define BIT_FW_MSG_REG3(x)                                                     \
	(((x) & BIT_MASK_FW_MSG_REG3) << BIT_SHIFT_FW_MSG_REG3)
#define BITS_FW_MSG_REG3 (BIT_MASK_FW_MSG_REG3 << BIT_SHIFT_FW_MSG_REG3)
#define BIT_CLEAR_FW_MSG_REG3(x) ((x) & (~BITS_FW_MSG_REG3))
#define BIT_GET_FW_MSG_REG3(x)                                                 \
	(((x) >> BIT_SHIFT_FW_MSG_REG3) & BIT_MASK_FW_MSG_REG3)
#define BIT_SET_FW_MSG_REG3(x, v)                                              \
	(BIT_CLEAR_FW_MSG_REG3(x) | BIT_FW_MSG_REG3(v))

/* 2 REG_FW_MSG4				(Offset 0x02EC) */

#define BIT_SHIFT_FW_MSG_REG4 0
#define BIT_MASK_FW_MSG_REG4 0xffffffffL
#define BIT_FW_MSG_REG4(x)                                                     \
	(((x) & BIT_MASK_FW_MSG_REG4) << BIT_SHIFT_FW_MSG_REG4)
#define BITS_FW_MSG_REG4 (BIT_MASK_FW_MSG_REG4 << BIT_SHIFT_FW_MSG_REG4)
#define BIT_CLEAR_FW_MSG_REG4(x) ((x) & (~BITS_FW_MSG_REG4))
#define BIT_GET_FW_MSG_REG4(x)                                                 \
	(((x) >> BIT_SHIFT_FW_MSG_REG4) & BIT_MASK_FW_MSG_REG4)
#define BIT_SET_FW_MSG_REG4(x, v)                                              \
	(BIT_CLEAR_FW_MSG_REG4(x) | BIT_FW_MSG_REG4(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_PCIE_CTRL				(Offset 0x0300) */

#define BIT_PCIEIO_PERSTB_SEL BIT(31)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_HCI_CTRL				(Offset 0x0300) */

#define BIT_HCIIO_PERSTB_SEL BIT(31)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_PCIE_CTRL				(Offset 0x0300) */

#define BIT_SHIFT_PCIE_MAX_RXDMA 28
#define BIT_MASK_PCIE_MAX_RXDMA 0x7
#define BIT_PCIE_MAX_RXDMA(x)                                                  \
	(((x) & BIT_MASK_PCIE_MAX_RXDMA) << BIT_SHIFT_PCIE_MAX_RXDMA)
#define BITS_PCIE_MAX_RXDMA                                                    \
	(BIT_MASK_PCIE_MAX_RXDMA << BIT_SHIFT_PCIE_MAX_RXDMA)
#define BIT_CLEAR_PCIE_MAX_RXDMA(x) ((x) & (~BITS_PCIE_MAX_RXDMA))
#define BIT_GET_PCIE_MAX_RXDMA(x)                                              \
	(((x) >> BIT_SHIFT_PCIE_MAX_RXDMA) & BIT_MASK_PCIE_MAX_RXDMA)
#define BIT_SET_PCIE_MAX_RXDMA(x, v)                                           \
	(BIT_CLEAR_PCIE_MAX_RXDMA(x) | BIT_PCIE_MAX_RXDMA(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_HCI_CTRL				(Offset 0x0300) */

#define BIT_SHIFT_HCI_MAX_RXDMA 28
#define BIT_MASK_HCI_MAX_RXDMA 0x7
#define BIT_HCI_MAX_RXDMA(x)                                                   \
	(((x) & BIT_MASK_HCI_MAX_RXDMA) << BIT_SHIFT_HCI_MAX_RXDMA)
#define BITS_HCI_MAX_RXDMA (BIT_MASK_HCI_MAX_RXDMA << BIT_SHIFT_HCI_MAX_RXDMA)
#define BIT_CLEAR_HCI_MAX_RXDMA(x) ((x) & (~BITS_HCI_MAX_RXDMA))
#define BIT_GET_HCI_MAX_RXDMA(x)                                               \
	(((x) >> BIT_SHIFT_HCI_MAX_RXDMA) & BIT_MASK_HCI_MAX_RXDMA)
#define BIT_SET_HCI_MAX_RXDMA(x, v)                                            \
	(BIT_CLEAR_HCI_MAX_RXDMA(x) | BIT_HCI_MAX_RXDMA(v))

#endif

#if (HALMAC_8881A_SUPPORT)

/* 2 REG_LX_CTRL1				(Offset 0x0300) */

#define BIT_RX_LIT_EDN_SEL BIT(27)
#define BIT_TX_LIT_EDN_SEL BIT(26)
#define BIT_WT_LIT_EDN BIT(25)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_PCIE_CTRL				(Offset 0x0300) */

#define BIT_SHIFT_PCIE_MAX_TXDMA 24
#define BIT_MASK_PCIE_MAX_TXDMA 0x7
#define BIT_PCIE_MAX_TXDMA(x)                                                  \
	(((x) & BIT_MASK_PCIE_MAX_TXDMA) << BIT_SHIFT_PCIE_MAX_TXDMA)
#define BITS_PCIE_MAX_TXDMA                                                    \
	(BIT_MASK_PCIE_MAX_TXDMA << BIT_SHIFT_PCIE_MAX_TXDMA)
#define BIT_CLEAR_PCIE_MAX_TXDMA(x) ((x) & (~BITS_PCIE_MAX_TXDMA))
#define BIT_GET_PCIE_MAX_TXDMA(x)                                              \
	(((x) >> BIT_SHIFT_PCIE_MAX_TXDMA) & BIT_MASK_PCIE_MAX_TXDMA)
#define BIT_SET_PCIE_MAX_TXDMA(x, v)                                           \
	(BIT_CLEAR_PCIE_MAX_TXDMA(x) | BIT_PCIE_MAX_TXDMA(v))

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_HCI_CTRL				(Offset 0x0300) */

#define BIT_SHIFT_HCI_MAX_TXDMA 24
#define BIT_MASK_HCI_MAX_TXDMA 0x7
#define BIT_HCI_MAX_TXDMA(x)                                                   \
	(((x) & BIT_MASK_HCI_MAX_TXDMA) << BIT_SHIFT_HCI_MAX_TXDMA)
#define BITS_HCI_MAX_TXDMA (BIT_MASK_HCI_MAX_TXDMA << BIT_SHIFT_HCI_MAX_TXDMA)
#define BIT_CLEAR_HCI_MAX_TXDMA(x) ((x) & (~BITS_HCI_MAX_TXDMA))
#define BIT_GET_HCI_MAX_TXDMA(x)                                               \
	(((x) >> BIT_SHIFT_HCI_MAX_TXDMA) & BIT_MASK_HCI_MAX_TXDMA)
#define BIT_SET_HCI_MAX_TXDMA(x, v)                                            \
	(BIT_CLEAR_HCI_MAX_TXDMA(x) | BIT_HCI_MAX_TXDMA(v))

#endif

#if (HALMAC_8881A_SUPPORT)

/* 2 REG_LX_CTRL1				(Offset 0x0300) */

#define BIT_RD_LITT_EDN BIT(24)

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_PCIE_CTRL				(Offset 0x0300) */

#define BIT_PWR_SCALE_START_PS BIT(23)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_PCIE_CTRL				(Offset 0x0300) */

#define BIT_PCIE_RST_TRXDMA_INTF BIT(20)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_HCI_CTRL				(Offset 0x0300) */

#define BIT_HCI_RST_TRXDMA_INTF BIT(20)

#endif

#if (HALMAC_8881A_SUPPORT)

/* 2 REG_LX_CTRL1				(Offset 0x0300) */

#define BIT_SHIFT_MAX_RXDMA 20
#define BIT_MASK_MAX_RXDMA 0x7
#define BIT_MAX_RXDMA(x) (((x) & BIT_MASK_MAX_RXDMA) << BIT_SHIFT_MAX_RXDMA)
#define BITS_MAX_RXDMA (BIT_MASK_MAX_RXDMA << BIT_SHIFT_MAX_RXDMA)
#define BIT_CLEAR_MAX_RXDMA(x) ((x) & (~BITS_MAX_RXDMA))
#define BIT_GET_MAX_RXDMA(x) (((x) >> BIT_SHIFT_MAX_RXDMA) & BIT_MASK_MAX_RXDMA)
#define BIT_SET_MAX_RXDMA(x, v) (BIT_CLEAR_MAX_RXDMA(x) | BIT_MAX_RXDMA(v))

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_PCIE_CTRL				(Offset 0x0300) */

#define BIT_PCIE_EN_SWENT_L23 BIT(17)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_HCI_CTRL				(Offset 0x0300) */

#define BIT_HCI_EN_SWENT_L23 BIT(17)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8812F_SUPPORT ||   \
     HALMAC_8814A_SUPPORT || HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || \
     HALMAC_8821C_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_PCIE_CTRL				(Offset 0x0300) */

#define BIT_PCIE_EN_HWEXT_L1 BIT(16)

#endif

#if (HALMAC_8197F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT)

/* 2 REG_HCI_CTRL				(Offset 0x0300) */

#define BIT_HCI_EN_HWEXT_L1 BIT(16)

#endif

#if (HALMAC_8881A_SUPPORT)

/* 2 REG_LX_CTRL1				(Offset 0x0300) */

#define BIT_SHIFT_MAX_TXDMA 16
#define BIT_MASK_MAX_TXDMA 0x7
#define BIT_MAX_TXDMA(x) (((x) & BIT_MASK_MAX_TXDMA) << BIT_SHIFT_MAX_TXDMA)
#define BITS_MAX_TXDMA (BIT_MASK_MAX_TXDMA << BIT_SHIFT_MAX_TXDMA)
#define BIT_CLEAR_MAX_TXDMA(x) ((x) & (~BITS_MAX_TXDMA))
#define BIT_GET_MAX_TXDMA(x) (((x) >> BIT_SHIFT_MAX_TXDMA) & BIT_MASK_MAX_TXDMA)
#define BIT_SET_MAX_TXDMA(x, v) (BIT_CLEAR_MAX_TXDMA(x) | BIT_MAX_TXDMA(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_PCIE_CTRL				(Offset 0x0300) */

#define BIT_STOP_P0_MPRT_BCNQ4 BIT(6)
#define BIT_STOP_P0_MPRT_BCNQ3 BIT(4)
#define BIT_STOP_P0_MPRT_BCNQ2 BIT(2)
#define BIT_STOP_P0_MPRT_BCNQ1 BIT(0)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_INT_MIG				(Offset 0x0304) */

#define BIT_SHIFT_TXTTIMER_MATCH_NUM 28
#define BIT_MASK_TXTTIMER_MATCH_NUM 0xf
#define BIT_TXTTIMER_MATCH_NUM(x)                                              \
	(((x) & BIT_MASK_TXTTIMER_MATCH_NUM) << BIT_SHIFT_TXTTIMER_MATCH_NUM)
#define BITS_TXTTIMER_MATCH_NUM                                                \
	(BIT_MASK_TXTTIMER_MATCH_NUM << BIT_SHIFT_TXTTIMER_MATCH_NUM)
#define BIT_CLEAR_TXTTIMER_MATCH_NUM(x) ((x) & (~BITS_TXTTIMER_MATCH_NUM))
#define BIT_GET_TXTTIMER_MATCH_NUM(x)                                          \
	(((x) >> BIT_SHIFT_TXTTIMER_MATCH_NUM) & BIT_MASK_TXTTIMER_MATCH_NUM)
#define BIT_SET_TXTTIMER_MATCH_NUM(x, v)                                       \
	(BIT_CLEAR_TXTTIMER_MATCH_NUM(x) | BIT_TXTTIMER_MATCH_NUM(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_ACH_CTRL				(Offset 0x0304) */

#define BIT_STOP_P0HIQ19 BIT(27)
#define BIT_STOP_P0HIQ18 BIT(26)
#define BIT_STOP_P0HIQ17 BIT(25)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_INT_MIG				(Offset 0x0304) */

#define BIT_SHIFT_TXPKT_NUM_MATCH 24
#define BIT_MASK_TXPKT_NUM_MATCH 0xf
#define BIT_TXPKT_NUM_MATCH(x)                                                 \
	(((x) & BIT_MASK_TXPKT_NUM_MATCH) << BIT_SHIFT_TXPKT_NUM_MATCH)
#define BITS_TXPKT_NUM_MATCH                                                   \
	(BIT_MASK_TXPKT_NUM_MATCH << BIT_SHIFT_TXPKT_NUM_MATCH)
#define BIT_CLEAR_TXPKT_NUM_MATCH(x) ((x) & (~BITS_TXPKT_NUM_MATCH))
#define BIT_GET_TXPKT_NUM_MATCH(x)                                             \
	(((x) >> BIT_SHIFT_TXPKT_NUM_MATCH) & BIT_MASK_TXPKT_NUM_MATCH)
#define BIT_SET_TXPKT_NUM_MATCH(x, v)                                          \
	(BIT_CLEAR_TXPKT_NUM_MATCH(x) | BIT_TXPKT_NUM_MATCH(v))

#endif

#if (HALMAC_8812F_SUPPORT || HALMAC_8822C_SUPPORT)

/* 2 REG_INT_MIG				(Offset 0x0304) */

#define BIT_SHIFT_TRXCOUNTER_MATCH 24
#define BIT_MASK_TRXCOUNTER_MATCH 0xff
#define BIT_TRXCOUNTER_MATCH(x)                                                \
	(((x) & BIT_MASK_TRXCOUNTER_MATCH) << BIT_SHIFT_TRXCOUNTER_MATCH)
#define BITS_TRXCOUNTER_MATCH                                                  \
	(BIT_MASK_TRXCOUNTER_MATCH << BIT_SHIFT_TRXCOUNTER_MATCH)
#define BIT_CLEAR_TRXCOUNTER_MATCH(x) ((x) & (~BITS_TRXCOUNTER_MATCH))
#define BIT_GET_TRXCOUNTER_MATCH(x)                                            \
	(((x) >> BIT_SHIFT_TRXCOUNTER_MATCH) & BIT_MASK_TRXCOUNTER_MATCH)
#define BIT_SET_TRXCOUNTER_MATCH(x, v)                                         \
	(BIT_CLEAR_TRXCOUNTER_MATCH(x) | BIT_TRXCOUNTER_MATCH(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_ACH_CTRL				(Offset 0x0304) */

#define BIT_STOP_P0HIQ16 BIT(24)
#define BIT_RX_CLOSE_EN_V1 BIT(21)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_INT_MIG				(Offset 0x0304) */

#define BIT_SHIFT_RXTTIMER_MATCH_NUM 20
#define BIT_MASK_RXTTIMER_MATCH_NUM 0xf
#define BIT_RXTTIMER_MATCH_NUM(x)                                              \
	(((x) & BIT_MASK_RXTTIMER_MATCH_NUM) << BIT_SHIFT_RXTTIMER_MATCH_NUM)
#define BITS_RXTTIMER_MATCH_NUM                                                \
	(BIT_MASK_RXTTIMER_MATCH_NUM << BIT_SHIFT_RXTTIMER_MATCH_NUM)
#define BIT_CLEAR_RXTTIMER_MATCH_NUM(x) ((x) & (~BITS_RXTTIMER_MATCH_NUM))
#define BIT_GET_RXTTIMER_MATCH_NUM(x)                                          \
	(((x) >> BIT_SHIFT_RXTTIMER_MATCH_NUM) & BIT_MASK_RXTTIMER_MATCH_NUM)
#define BIT_SET_RXTTIMER_MATCH_NUM(x, v)                                       \
	(BIT_CLEAR_RXTTIMER_MATCH_NUM(x) | BIT_RXTTIMER_MATCH_NUM(v))

#endif

#if (HALMAC_8814B_SUPPORT)

/* 2 REG_ACH_CTRL				(Offset 0x0304) */

#define BIT_STOP_FWCMDQ BIT(20)
#define BIT_STOP_P0BCNQ BIT(18)

#endif

#if (HALMAC_8192E_SUPPORT || HALMAC_8192F_SUPPORT || HALMAC_8197F_SUPPORT ||   \
     HALMAC_8197G_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8814A_SUPPORT ||   \
     HALMAC_8814AMP_SUPPORT || HALMAC_8814B_SUPPORT || HALMAC_8821C_SUPPORT || \
     HALMAC_8822B_SUPPORT || HALMAC_8881A_SUPPORT)

/* 2 REG_INT_MIG				(Offset 0x0304) */

#define BIT_SHIFT_RXPKT_NUM_MATCH 16
#define BIT_MASK_RXPKT_NUM_MATCH 0xf
#define BIT_RXPKT_NUM_MATCH(x)                                                 \
	(((x) & BIT_MASK_RXPKT_NUM_MATCH) << BIT_SHIFT_RXPKT_NUM_MATCH)
#define BITS_RXPK