#ifndef __HAL8197G_CFG_H__
#define __HAL8197G_CFG_H__

// Need to confirm by each IC
#define NUM_TX_DESC_8197G               NUM_TX_DESC
#define RX_Q_RXBD_NUM_8197G             RX_Q_RXBD_NUM_2G//256
#define TX_CMDQ_TXBD_NUM_8197G          32
#define TX_HIQ_NUM_8197G                16
#define SIZE_TXDESC_88XX_8197G          64//temp

// TX related
#define TX_VOQ_TXBD_NUM_8197G		    NUM_TX_DESC_8197G
#define TX_VIQ_TXBD_NUM_8197G		    NUM_TX_DESC_8197G
#define TX_BEQ_TXBD_NUM_8197G	        NUM_TX_DESC_8197G
#define TX_BKQ_TXBD_NUM_8197G		    NUM_TX_DESC_8197G
#define TX_MGQ_TXBD_NUM_8197G           NUM_TX_DESC_8197G

#define NUM_TX_DESC_HQ_8197G 	        NUM_TX_DESC_HQ//(NUM_TX_DESC_8197G>>3)

// HIQ in 8197G extend to 16

#define TX_HIQ_TXBD_NUM_8197G	        (NUM_TX_DESC_HQ_8197G*TX_HIQ_NUM_8197G)
#define TOTAL_NUM_TXBD_NO_BCN_8197G     (TX_MGQ_TXBD_NUM_8197G + TX_VOQ_TXBD_NUM_8197G + TX_VIQ_TXBD_NUM_8197G + TX_BEQ_TXBD_NUM_8197G + \
                                        TX_BKQ_TXBD_NUM_8197G + TX_HIQ_TXBD_NUM_8197G + TX_CMDQ_TXBD_NUM_8197G)

#if CFG_HAL_TX_AMSDU
#define TOTAL_NUM_TXBD_FOR_AMSDU_8197G    (TX_VOQ_TXBD_NUM_8197G + TX_VIQ_TXBD_NUM_8197G + TX_BEQ_TXBD_NUM_8197G + TX_BKQ_TXBD_NUM_8197G)
#define DESC_DMA_SIZE_FOR_AMSDU_8197G     (TOTAL_NUM_TXBD_FOR_AMSDU_8197G * sizeof(TX_BUFFER_DESCRIPTOR_AMSDU))
#define DESC_DMA_PAGE_SIZE_HAL_FOR_AMSDU_8197G    (DESC_DMA_SIZE_FOR_AMSDU_8197G + HAL_PAGE_SIZE)
#endif //CFG_HAL_TX_AMSDU

// RX related 
#define TOTAL_NUM_RXBD_8197G          (RX_Q_RXBD_NUM_8197G)

// Total 
#define DESC_DMA_SIZE_NO_BCNQ_8197G \
     (TOTAL_NUM_TXBD_NO_BCN_8197G * (sizeof(TX_BUFFER_DESCRIPTOR) + SIZE_TXDESC_88XX_8197G))
     
#define DESC_DMA_SIZE_TX_MAX_8197G    (DESC_DMA_SIZE_NO_BCNQ_8197G + \
                                      (1+HAL_NUM_VWLAN) * TXBD_BEACON_OFFSET_MAX + \
                                      (1+HAL_NUM_VWLAN) * SIZE_TXDESC_88XX_8197G)

#define DESC_DMA_SIZE_RX_MAX_8197G  (TOTAL_NUM_RXBD_8197G * sizeof(RX_BUFFER_DESCRIPTOR))

#define DESC_DMA_RXSIZE_PAGE_8197G  (DESC_DMA_SIZE_RX_MAX_8197G + PAGE_SIZE)
#define DESC_DMA_TXSIZE_PAGE_8197G  (DESC_DMA_SIZE_TX_MAX_8197G + PAGE_SIZE)
#define DESC_DMA_PAGE_SIZE_MAX_8197G  (DESC_DMA_RXSIZE_PAGE_8197G + DESC_DMA_TXSIZE_PAGE_8197G + HAL_PAGE_SIZE)

#endif //__HAL8197G_CFG_H__

