#ifndef __HAL8822B_CFG_H__
#define __HAL8822B_CFG_H__

// Need to confirm by each IC
#define NUM_TX_DESC_8822B               NUM_TX_DESC
#define RX_Q_RXBD_NUM_8822B             RX_Q_RXBD_NUM//256
#define TX_CMDQ_TXBD_NUM_8822B          32
#define TX_HIQ_NUM_8822B                8
#define SIZE_TXDESC_88XX_8822B          64

// TX related
#define TX_VOQ_TXBD_NUM_8822B		    NUM_TX_DESC_8822B
#define TX_VIQ_TXBD_NUM_8822B		    NUM_TX_DESC_8822B
#define TX_BEQ_TXBD_NUM_8822B	        NUM_TX_DESC_8822B
#define TX_BKQ_TXBD_NUM_8822B		    NUM_TX_DESC_8822B
#define TX_MGQ_TXBD_NUM_8822B           NUM_TX_DESC_8822B

#define NUM_TX_DESC_HQ_8822B 	        NUM_TX_DESC_HQ//(NUM_TX_DESC_8822B>>3)

// HIQ in 8822B extend to 16

#define TX_HIQ_TXBD_NUM_8822B	        (NUM_TX_DESC_HQ_8822B*TX_HIQ_NUM_8822B)
#define TOTAL_NUM_TXBD_NO_BCN_8822B     (TX_MGQ_TXBD_NUM_8822B + TX_VOQ_TXBD_NUM_8822B + TX_VIQ_TXBD_NUM_8822B + TX_BEQ_TXBD_NUM_8822B + \
                                        TX_BKQ_TXBD_NUM_8822B + TX_HIQ_TXBD_NUM_8822B + TX_CMDQ_TXBD_NUM_8822B)

#if CFG_HAL_TX_AMSDU
#define TOTAL_NUM_TXBD_FOR_AMSDU_8822B    (TX_VOQ_TXBD_NUM_8822B + TX_VIQ_TXBD_NUM_8822B + TX_BEQ_TXBD_NUM_8822B + TX_BKQ_TXBD_NUM_8822B)
#define DESC_DMA_SIZE_FOR_AMSDU_8822B     (TOTAL_NUM_TXBD_FOR_AMSDU_8822B * sizeof(TX_BUFFER_DESCRIPTOR_AMSDU))
#define DESC_DMA_PAGE_SIZE_HAL_FOR_AMSDU_8822B    (DESC_DMA_SIZE_FOR_AMSDU_8822B + HAL_PAGE_SIZE)
#endif //CFG_HAL_TX_AMSDU

// RX related 
#define TOTAL_NUM_RXBD_8822B          (RX_Q_RXBD_NUM_8822B)

// Total 
#define DESC_DMA_SIZE_NO_BCNQ_8822B \
     (TOTAL_NUM_TXBD_NO_BCN_8822B * (sizeof(TX_BUFFER_DESCRIPTOR) + SIZE_TXDESC_88XX_8822B))
     
#define DESC_DMA_SIZE_TX_MAX_8822B    (DESC_DMA_SIZE_NO_BCNQ_8822B + \
                                      (1+HAL_NUM_VWLAN) * TXBD_BEACON_OFFSET_MAX + \
                                      (1+HAL_NUM_VWLAN) * SIZE_TXDESC_88XX_8822B)

#define DESC_DMA_SIZE_RX_MAX_8822B  (TOTAL_NUM_RXBD_8822B * sizeof(RX_BUFFER_DESCRIPTOR))

#define DESC_DMA_RXSIZE_PAGE_8822B  (DESC_DMA_SIZE_RX_MAX_8822B + PAGE_SIZE)
#define DESC_DMA_TXSIZE_PAGE_8822B  (DESC_DMA_SIZE_TX_MAX_8822B + PAGE_SIZE)
#define DESC_DMA_PAGE_SIZE_MAX_8822B  (DESC_DMA_RXSIZE_PAGE_8822B + DESC_DMA_TXSIZE_PAGE_8822B + HAL_PAGE_SIZE)

#endif //__HAL8822B_CFG_H__

