#
# RTL WLan AP Driver All In One Configure
#

#
# Wireless LAN
#

# Driver Module/Build In Driver ==> :=m/:=y
CONFIG_RTL8192CD :=m

# RTK Platform ?
RTK_BSP :=n

# Select Support WLan Chip
CONFIG_RTL_92C_SUPPORT :=n
CONFIG_RTL_92D_SUPPORT :=n
CONFIG_RTL_88E_SUPPORT :=n
CONFIG_RTL_92E_SUPPORT :=n
CONFIG_RTL_92F_SUPPORT :=y
CONFIG_RTL_8812_SUPPORT :=n
CONFIG_RTL_8814_SUPPORT :=n
CONFIG_RTL_8822_SUPPORT :=n
CONFIG_RTL_8822C_SUPPORT :=n
CONFIG_RTL_8821_SUPPORT :=n
CONFIG_RTL_8814B_SUPPORT :=n
CONFIG_RTL_8812F_SUPPORT :=n

CONCURRENT_MODE :=n

# Bus Interface Type, PCIE / USB / SDIO
CONFIG_PCI_HCI :=y
CONFIG_USB_HCI :=n
CONFIG_SDIO_HCI :=n

# RTL Platform Support
CONFIG_RTL_819X :=n
CONFIG_RTL_819XD :=n

# Driver Configuration
CONFIG_RTL8190_PRIV_SKB :=n
CONFIG_PREALLOC_MODULE :=n

CONFIG_RTL_WAPI_SUPPORT :=n

# If Use External PA, LNA ?
CONFIG_EXT_PA :=n
CONFIG_EXT_LNA :=n

# If Support Dynamic Freqence Selection ?
CONFIG_RTL_DFS_SUPPORT :=n

# Number of Virtual AP ?
ifeq ($(RTL8192CD_NUM_VWLAN),)
RTL8192CD_NUM_VWLAN := 0
endif

# If Support Client Mode ?
CONFIG_RTL_CLIENT_MODE_SUPPORT :=y
CONFIG_RTL_REPEATER_MODE_SUPPORT :=y
CONFIG_RTL_SUPPORT_MULTI_PROFILE :=n
CONFIG_RTL_MULTI_CLONE_SUPPORT :=n

# If Support Wireless Distribution System ?
CONFIG_RTL_WDS_SUPPORT :=n

# If Enable On-Chip EFuse ?
CONFIG_ENABLE_EFUSE :=y

# If support non-HAL Chip ? (92C, 92D, 88E, 8812)
CONFIG_RTL_WLAN_HAL_NOT_EXIST :=y

CONFIG_RTL_COMAPI_CFGFILE :=n
CONFIG_RTL_COMAPI_WLTOOLS :=n
CONFIG_MP_PSD_SUPPORT :=n
CONFIG_RTL_P2P_SUPPORT :=n
CONFIG_RTL_MESH_SUPPORT :=n
CONFIG_RTL_WLAN_DOS_FILTER :=n
CONFIG_TXPWR_LMT :=n
CONFIG_TX_BEAMFORMING :=y
CONFIG_RTL_WPS2_SUPPORT :=y
CONFIG_WPA_CLI :=n
CONFIG_POWER_SAVE :=n

# Select WLan PHY Clock Source, 40MHz/25MHz. For WLan module, we use 40MHz usually
CONFIG_PHY_EAT_40MHZ :=y
CONFIG_PHY_WLAN_EAT_40MHZ :=y

CONFIG_IGMP_SNOOPING_SUPPORT:=y
CONFIG_MLD_SNOOPING_SUPPORT:=y

# 802.11w support
CONFIG_RTL_11W_SUPPORT:=y
CONFIG_RTL_11W_CLI_SUPPORT:=n

# 802.11r support
CONFIG_RTL_11R_SUPPORT:=n

#802.11k support
CONFIG_RTL_DOT11K_SUPPORT:=n

#802.11v support
CONFIG_RTL_11V_SUPPORT:=n

CONFIG_BEAMFORMING_SUPPORT:=n

CONFIG_RTK_SMART_ROAMING:=n

CONFIG_SMP_LOAD_BALANCE_SUPPORT:=n

######## Don't Modify Following Code ########

EXTRA_CFLAGS += -DCONFIG_RTL8192CD

ifeq ($(RTK_BSP),n)
	EXTRA_CFLAGS += -DNOT_RTK_BSP
	EXTRA_CFLAGS += -DCONFIG_WIRELESS_LAN_MODULE
endif

ifeq ($(CONFIG_PCI_HCI),y)
	EXTRA_CFLAGS += -DCONFIG_PCI_HCI
endif

ifeq ($(CONFIG_USB_HCI),y)
	EXTRA_CFLAGS += -DCONFIG_USB_HCI
endif

ifeq ($(CONFIG_SDIO_HCI),y)
	EXTRA_CFLAGS += -DCONFIG_SDIO_HCI
	# 0: No AP power saving 1: RF off  2: beacon offload
	CONFIG_AP_PS := 0
endif

ifeq ($(CONFIG_RTL_92C_SUPPORT),y)
	CONFIG_RTL_WLAN_HAL_NOT_EXIST :=y
	EXTRA_CFLAGS += -DCONFIG_RTL_92C_SUPPORT
endif
  
ifeq ($(CONFIG_RTL_92D_SUPPORT),y)
	CONFIG_RTL_WLAN_HAL_NOT_EXIST :=y
	EXTRA_CFLAGS += -DCONFIG_RTL_92D_SUPPORT
	#EXTRA_CFLAGS += -DCONFIG_RTL_92D_DMDP
endif

ifeq ($(CONFIG_RTL_88E_SUPPORT),y)
	CONFIG_RTL_WLAN_HAL_NOT_EXIST :=y
	CONFIG_RTL_ODM_WLAN_DRIVER :=y
	EXTRA_CFLAGS += -DCONFIG_RTL_88E_SUPPORT
endif

ifeq ($(CONFIG_RTL_8812_SUPPORT),y)
#	CONFIG_RTL_DFS_SUPPORT :=n
	CONFIG_RTL_WLAN_HAL_NOT_EXIST :=y
	CONFIG_RTL_ODM_WLAN_DRIVER :=y
	EXTRA_CFLAGS += -DCONFIG_RTL_8812_SUPPORT
	ifeq ($(CONFIG_BEAMFORMING_SUPPORT), y)
		EXTRA_CFLAGS += -DCONFIG_BEAMFORMING_SUPPORT
	endif
endif

ifeq ($(CONFIG_RTL_8814_SUPPORT),y)
	CONFIG_WLAN_HAL :=y
	CONFIG_WLAN_HAL_88XX :=y
	CONFIG_WLAN_HAL_8814AE :=y
	CONFIG_RTL_ODM_WLAN_DRIVER :=y
	EXTRA_CFLAGS += -DCONFIG_WLAN_HAL_8814AE
	ifeq ($(CONFIG_BEAMFORMING_SUPPORT), y)
		EXTRA_CFLAGS += -DCONFIG_BEAMFORMING_SUPPORT
	endif
endif

ifeq ($(CONFIG_RTL_92E_SUPPORT),y)
	CONFIG_WLAN_HAL :=y
	CONFIG_WLAN_HAL_88XX :=y
	CONFIG_WLAN_HAL_8192EE :=y
	CONFIG_RTL_ODM_WLAN_DRIVER :=y
	EXTRA_CFLAGS += -DCONFIG_WLAN_HAL_8192EE
	ifeq ($(CONFIG_BEAMFORMING_SUPPORT), y)
		EXTRA_CFLAGS += -DCONFIG_BEAMFORMING_SUPPORT
	endif
endif

ifeq ($(CONFIG_RTL_92F_SUPPORT),y)
	CONFIG_WLAN_HAL :=y
	CONFIG_WLAN_HAL_88XX :=y
	CONFIG_WLAN_HAL_8192FE :=y
	CONFIG_RTL_ODM_WLAN_DRIVER :=y
	EXTRA_CFLAGS += -DCONFIG_WLAN_HAL_8192FE
	ifeq ($(CONFIG_BEAMFORMING_SUPPORT), y)
		EXTRA_CFLAGS += -DCONFIG_BEAMFORMING_SUPPORT
	endif
endif

ifeq ($(CONFIG_RTL_8822_SUPPORT),y)
	CONFIG_WLAN_HAL :=y
	CONFIG_WLAN_HAL_88XX :=y
	CONFIG_WLAN_HAL_8822BE :=y
	CONFIG_RTL_ODM_WLAN_DRIVER :=y
	CONFIG_WLAN_MACHAL_API :=y
	CONFIG_WLAN_MACHAL_API_V0 :=y
	EXTRA_CFLAGS += -DCONFIG_WLAN_HAL_8822BE
#	ifeq ($(CONFIG_BEAMFORMING_SUPPORT), y)
#		EXTRA_CFLAGS += -DCONFIG_BEAMFORMING_SUPPORT
#	endif
endif

ifeq ($(CONFIG_RTL_8822C_SUPPORT),y)
	CONFIG_WLAN_HAL :=y
	CONFIG_WLAN_HAL_88XX :=y
	CONFIG_WLAN_HAL_8822CE :=y
	CONFIG_RTL_ODM_WLAN_DRIVER :=y
	CONFIG_WLAN_MACHAL_API :=y
	CONFIG_WLAN_MACHAL_API_V0 :=y
	EXTRA_CFLAGS += -DCONFIG_WLAN_HAL_8822CE
#	ifeq ($(CONFIG_BEAMFORMING_SUPPORT), y)
#		EXTRA_CFLAGS += -DCONFIG_BEAMFORMING_SUPPORT
#	endif
endif

ifeq ($(CONFIG_RTL_8821_SUPPORT),y)
	CONFIG_WLAN_HAL :=y
	CONFIG_WLAN_HAL_88XX :=y
	CONFIG_WLAN_HAL_8821CE :=y
	CONFIG_RTL_ODM_WLAN_DRIVER :=y
	CONFIG_WLAN_MACHAL_API :=y
	CONFIG_WLAN_MACHAL_API_V0 :=y
	EXTRA_CFLAGS += -DCONFIG_WLAN_HAL_8821CE
	
	ifeq ($(CONFIG_WLAN_HAL_8821CE), y)
#		EXTRA_CFLAGS += -DCONFIG_PCIE_POWER_SAVING
	endif
endif

ifeq ($(CONFIG_RTL_8814B_SUPPORT),y)
	CONFIG_RTL_OFFLOAD_DRIVER :=y
	CONFIG_ENABLE_EFUSE :=n
	CONFIG_WLAN_HAL :=y
	CONFIG_WLAN_HAL_88XX :=y
	CONFIG_WLAN_HAL_8814BE :=y
	CONFIG_RTL_ODM_WLAN_DRIVER :=y
	CONFIG_WLAN_MACHAL_API :=y
	CONFIG_WLAN_MACHAL_API_V1 :=y
	EXTRA_CFLAGS += -DCONFIG_WLAN_HAL_8814BE
endif

ifeq ($(CONFIG_RTL_8812F_SUPPORT),y)
	CONFIG_WLAN_HAL :=y
	CONFIG_WLAN_HAL_88XX :=y
	CONFIG_WLAN_HAL_8812FE :=y
	CONFIG_RTL_ODM_WLAN_DRIVER :=y
	CONFIG_WLAN_MACHAL_API :=y
	CONFIG_WLAN_MACHAL_API_V0 :=y
	EXTRA_CFLAGS += -DCONFIG_WLAN_HAL_8812FE
#	ifeq ($(CONFIG_BEAMFORMING_SUPPORT), y)
#		EXTRA_CFLAGS += -DCONFIG_BEAMFORMING_SUPPORT
#	endif
endif

ifeq ($(CONFIG_WLAN_HAL),y)	
	EXTRA_CFLAGS += -DCONFIG_WLAN_HAL

	ifeq ($(CONFIG_WLAN_HAL_88XX),y)
		EXTRA_CFLAGS += -DCONFIG_WLAN_HAL_88XX
	endif

	ifeq ($(CONFIG_WLAN_HAL_8881A),y)
		RTL_WLAN_DATA_DIR := WlanHAL/Data/8881A
	endif
else
	EXTRA_CFLAGS += -DCONFIG_RTL_WLAN_HAL_NOT_EXIST
endif

ifeq ($(CONFIG_WLAN_MACHAL_API),y)	
	EXTRA_CFLAGS += -DCONFIG_WLAN_MACHAL_API
endif

ifeq ($(CONFIG_RTL_WLAN_HAL_NOT_EXIST),y)
	EXTRA_CFLAGS += -DCONFIG_RTL_WLAN_HAL_NOT_EXIST
endif

ifeq ($(CONFIG_RTL_ODM_WLAN_DRIVER),y)
	EXTRA_CFLAGS += -DCONFIG_RTL_ODM_WLAN_DRIVER
endif

# TODO: We need to assign which NIC is using external PA and LNA
ifeq ($(CONFIG_EXT_PA),y)
	EXTRA_CFLAGS += -DCONFIG_SLOT_0_EXT_PA
	EXTRA_CFLAGS += -DCONFIG_SLOT_1_EXT_PA
endif

ifeq ($(CONFIG_EXT_LNA),y)
	EXTRA_CFLAGS += -DCONFIG_SLOT_0_EXT_LNA
	EXTRA_CFLAGS += -DCONFIG_SLOT_1_EXT_LNA
endif

ifeq ($(CONFIG_RTL_DFS_SUPPORT),y)
	EXTRA_CFLAGS += -DCONFIG_RTL_DFS_SUPPORT
endif

ifneq ($(RTL8192CD_NUM_VWLAN),0)
	EXTRA_CFLAGS += -DCONFIG_RTL_VAP_SUPPORT
endif
EXTRA_CFLAGS += -DRTL8192CD_NUM_VWLAN=$(RTL8192CD_NUM_VWLAN)

ifeq ($(CONFIG_RTL_CLIENT_MODE_SUPPORT),y)
	EXTRA_CFLAGS += -DCONFIG_RTL_CLIENT_MODE_SUPPORT
endif

ifeq ($(CONFIG_RTL_REPEATER_MODE_SUPPORT),y)
	EXTRA_CFLAGS += -DCONFIG_RTL_REPEATER_MODE_SUPPORT
endif

ifeq ($(CONFIG_RTL_SUPPORT_MULTI_PROFILE),y)
	EXTRA_CFLAGS += -DCONFIG_RTL_SUPPORT_MULTI_PROFILE
endif

ifeq ($(CONFIG_RTL_MULTI_CLONE_SUPPORT),y)
	EXTRA_CFLAGS += -DCONFIG_RTL_MULTI_CLONE_SUPPORT
endif

ifeq ($(CONFIG_RTL_WDS_SUPPORT),y)
	EXTRA_CFLAGS += -DCONFIG_RTL_WDS_SUPPORT
endif

ifeq ($(CONFIG_ENABLE_EFUSE),y)
	EXTRA_CFLAGS += -DCONFIG_ENABLE_EFUSE
	EXTRA_CFLAGS += -DCONFIG_SLOT_0_ENABLE_EFUSE
endif

ifeq ($(CONFIG_RTL_COMAPI_CFGFILE),y)
	EXTRA_CFLAGS += -DCONFIG_RTL_COMAPI_CFGFILE
endif

ifeq ($(CONFIG_RTL_COMAPI_WLTOOLS),y)
	EXTRA_CFLAGS += -DCONFIG_RTL_COMAPI_WLTOOLS
endif

ifeq ($(CONFIG_WPA_CLI),y)
	EXTRA_CFLAGS += -DCONFIG_RTL_COMAPI_WLTOOLS -DWIFI_WPAS_CLI -DSDIO_2_PORT
endif

ifeq ($(CONFIG_MP_PSD_SUPPORT),y)
	EXTRA_CFLAGS += -DCONFIG_MP_PSD_SUPPORT
endif

ifeq ($(CONFIG_RTL_P2P_SUPPORT),y)
	EXTRA_CFLAGS += -DCONFIG_RTL_P2P_SUPPORT
endif

ifeq ($(CONFIG_TXPWR_LMT),y)
	EXTRA_CFLAGS += -DCONFIG_TXPWR_LMT
endif

ifeq ($(CONFIG_RTL_MESH_SUPPORT),y)
	EXTRA_CFLAGS += -DCONFIG_RTL_MESH_SUPPORT
endif

ifeq ($(CONFIG_RTL_WLAN_DOS_FILTER),y)
	EXTRA_CFLAGS += -DCONFIG_RTL_WLAN_DOS_FILTER
endif

ifeq ($(CONCURRENT_MODE),y)
	EXTRA_CFLAGS += -DCONCURRENT_MODE
endif

ifeq ($(CONFIG_RTL8190_PRIV_SKB),y)
	EXTRA_CFLAGS += -DCONFIG_RTL8190_PRIV_SKB
endif

ifeq ($(CONFIG_RTL_WPS2_SUPPORT),y)
	EXTRA_CFLAGS += -DCONFIG_RTL_WPS2_SUPPORT
endif

ifeq ($(CONFIG_TX_BEAMFORMING),y)
	EXTRA_CFLAGS += -DCONFIG_SLOT_0_TX_BEAMFORMING
endif

ifeq ($(CONFIG_PHY_EAT_40MHZ),y)
	EXTRA_CFLAGS += -DCONFIG_PHY_EAT_40MHZ
endif
ifeq ($(CONFIG_PHY_WLAN_EAT_40MHZ),y)
	EXTRA_CFLAGS += -DCONFIG_PHY_WLAN_EAT_40MHZ
endif

ifeq ($(CONFIG_RTL_WAPI_SUPPORT),y)
	EXTRA_CFLAGS += -DCONFIG_RTL_WAPI_SUPPORT
endif

ifeq ($(CONFIG_IGMP_SNOOPING_SUPPORT),y)
	EXTRA_CFLAGS += -D_FULLY_WIFI_IGMP_SNOOPING_SUPPORT_
endif

ifeq ($(CONFIG_MLD_SNOOPING_SUPPORT),y)
	EXTRA_CFLAGS += -D_FULLY_WIFI_MLD_SNOOPING_SUPPORT_
endif

ifeq ($(CONFIG_POWER_SAVE),y)
	EXTRA_CFLAGS += -DSDIO_AP_OFFLOAD -DCONFIG_POWER_SAVE
endif

ifeq ($(CONFIG_RTL_11W_SUPPORT),y)
	EXTRA_CFLAGS += -DCONFIG_RTL_11W_SUPPORT
endif

ifeq ($(CONFIG_RTL_11W_CLI_SUPPORT),y)
    ifeq ($(CONFIG_RTL_CLIENT_MODE_SUPPORT),y)
    	EXTRA_CFLAGS += -DCONFIG_RTL_11W_CLI_SUPPORT
    endif
endif

ifeq ($(CONFIG_RTL_11R_SUPPORT),y)
	EXTRA_CFLAGS += -DCONFIG_RTL_11R_SUPPORT
endif

ifeq ($(CONFIG_RTK_SMART_ROAMING),y)
	EXTRA_CFLAGS += -DCONFIG_RTK_SMART_ROAMING
endif

ifeq ($(CONFIG_SMP_LOAD_BALANCE_SUPPORT),y)
	EXTRA_CFLAGS += -DSMP_LOAD_BALANCE_SUPPORT
endif

ifeq ($(CONFIG_RTL_OFFLOAD_DRIVER),y)
	EXTRA_CFLAGS += -DCONFIG_RTL_OFFLOAD_DRIVER
endif
