#ifndef	_CORE_SECURITY_H_
#define _CORE_SECURITY_H_

#include "./8192cd_cfg.h"

#ifdef INCLUDE_WPS
#include "./wps/wsc.h"
#endif


#ifdef KERNEL_USER_NO_SHARE_STRUCTURE
typedef struct _DOT11_EAP_PACKET{
	unsigned char	EventId;
	unsigned char	IsMoreEvent;
	unsigned short  packet_len;
	unsigned char	packet[1550];
}DOT11_EAP_PACKET;

typedef enum{
        DOT11_PortStatus_Unauthorized,
        DOT11_PortStatus_Authorized,
        DOT11_PortStatus_Guest
}DOT11_PORT_STATUS;

/*   1. Don't use define flag
       2. any modify please also sync 
	-users/auth/include/1x_ioctl.h , 
	-users/wsc/src/wsc.h 
	-linux-DIR/driver/net/wireless/rtl8192cd/8192cd_security.h
	  (linux-DIR = linux-2.6.30 or linux-3.10)
*/
typedef enum{
    DOT11_EVENT_NO_EVENT = 1,
    DOT11_EVENT_REQUEST = 2,
    DOT11_EVENT_ASSOCIATION_IND = 3,
    DOT11_EVENT_ASSOCIATION_RSP = 4,
    DOT11_EVENT_AUTHENTICATION_IND = 5,
    DOT11_EVENT_REAUTHENTICATION_IND = 6,
    DOT11_EVENT_DEAUTHENTICATION_IND = 7,
    DOT11_EVENT_DISASSOCIATION_IND = 8,
    DOT11_EVENT_DISCONNECT_REQ = 9,
    DOT11_EVENT_SET_802DOT11 = 10,
    DOT11_EVENT_SET_KEY = 11,
    DOT11_EVENT_SET_PORT = 12,
    DOT11_EVENT_DELETE_KEY = 13,
    DOT11_EVENT_SET_RSNIE = 14,
    DOT11_EVENT_GKEY_TSC = 15,
    DOT11_EVENT_MIC_FAILURE = 16,
    DOT11_EVENT_ASSOCIATION_INFO = 17,
    DOT11_EVENT_INIT_QUEUE = 18,
    DOT11_EVENT_EAPOLSTART = 19,

	/*CONFIG_IEEE80211W*/
	DOT11_EVENT_SA_QUERY=20,
	DOT11_EVENT_SA_QUERY_RSP=21,

    DOT11_EVENT_ACC_SET_EXPIREDTIME = 31,
    DOT11_EVENT_ACC_QUERY_STATS = 32,
    DOT11_EVENT_ACC_QUERY_STATS_ALL = 33,
    DOT11_EVENT_REASSOCIATION_IND = 34,
    DOT11_EVENT_REASSOCIATION_RSP = 35,
    DOT11_EVENT_STA_QUERY_BSSID = 36,
    DOT11_EVENT_STA_QUERY_SSID = 37,
    DOT11_EVENT_EAP_PACKET = 41,

	/*RTL_WPA2_PREAUTH*/
    DOT11_EVENT_EAPOLSTART_PREAUTH = 45,
    DOT11_EVENT_EAP_PACKET_PREAUTH = 46,


    DOT11_EVENT_WPA2_MULTICAST_CIPHER = 47,
    DOT11_EVENT_WPA_MULTICAST_CIPHER = 48,

	/*AUTO_CONFIG*/
	DOT11_EVENT_AUTOCONF_ASSOCIATION_IND = 50,
	DOT11_EVENT_AUTOCONF_ASSOCIATION_CONFIRM = 51,
	DOT11_EVENT_AUTOCONF_PACKET = 52,
	DOT11_EVENT_AUTOCONF_LINK_IND = 53,

	/*WIFI_SIMPLE_CONFIG*/ 
	DOT11_EVENT_WSC_SET_IE = 55,
	DOT11_EVENT_WSC_PROBE_REQ_IND = 56,
	DOT11_EVENT_WSC_PIN_IND = 57,
	DOT11_EVENT_WSC_ASSOC_REQ_IE_IND = 58,
#ifdef INCLUDE_WPS
	DOT11_EVENT_WSC_SET_MIB=42,
	DOT11_EVENT_WSC_GET_MIB=43,
	DOT11_EVENT_REQUEST_F_INCLUDE_WPS=44,		
	DOT11_EVENT_WSC_INIT_IND = 70,
	DOT11_EVENT_WSC_EXIT_IND = 71,
	DOT11_EVENT_WSC_TERM_IND = 72,
	DOT11_EVENT_WSC_GETCONF_IND = 73,
	DOT11_EVENT_WSC_PUTCONF_IND = 74,
	DOT11_EVENT_WSC_LEDCONTROL_IND = 75,
	DOT11_EVENT_WSC_SENDMSG_IND = 76,
	DOT11_EVENT_WSC_PUTCONF = 77,
	DOT11_EVENT_WSC_SOAP = 78,
	DOT11_EVENT_WSC_PIN = 79,
	DOT11_EVENT_WSC_PBC = 80,
	DOT11_EVENT_WSC_SYS = 81,
	DOT11_EVENT_WSC_PUTWLANREQUEST_IND = 82,
	DOT11_EVENT_WSC_PUTPKT = 83,
	DOT11_EVENT_WSC_GETDEVINFO = 84,
	DOT11_EVENT_WSC_M2M4M6M8 = 85,
	DOT11_EVENT_WSC_PUTWLANRESPONSE = 86,
	DOT11_EVENT_WSC_PUTMESSAGE = 87,
	DOT11_EVENT_WSC_PUTWLREQ_PROBEIND = 88,
	DOT11_EVENT_WSC_PUTWLREQ_STATUSIND = 89,
#endif				
	/*end of WIFI_SIMPLE_CONFIG*/ 

	/*CONFIG_RTK_MESH*/
	DOT11_EVENT_PATHSEL_GEN_RREQ = 59,
	DOT11_EVENT_PATHSEL_GEN_RERR = 60,
	DOT11_EVENT_PATHSEL_RECV_RREQ = 61,
	DOT11_EVENT_PATHSEL_RECV_RREP = 62,
	DOT11_EVENT_PATHSEL_RECV_RERR = 63,
	DOT11_EVENT_PATHSEL_RECV_PANN = 65,
	DOT11_EVENT_PATHSEL_RECV_RANN = 66,
	/*CONFIG_RTK_MESH*/

	/*CONFIG_RTL_WAPI_SUPPORT*/
	DOT11_EVENT_WAPI_INIT_QUEUE =67,
	DOT11_EVENT_WAPI_READ_QUEUE = 68,
	DOT11_EVENT_WAPI_WRITE_QUEUE  =69,
	/*CONFIG_RTL_WAPI_SUPPORT*/



#if defined(CONFIG_RTL_COMAPI_CFGFILE) && defined(WIFI_SIMPLE_CONFIG)
#ifdef INCLUDE_WPS
	DOT11_EVENT_WSC_START_IND = 90,
	//EV_MODE, EV_STATUS, EV_MEHOD, EV_STEP, EV_OOB
	DOT11_EVENT_WSC_MODE_IND = 91,
	DOT11_EVENT_WSC_STATUS_IND = 92,
	DOT11_EVENT_WSC_METHOD_IND = 93,
	DOT11_EVENT_WSC_STEP_IND = 94,
	DOT11_EVENT_WSC_OOB_IND = 95,
#else
	DOT11_EVENT_WSC_START_IND = 70,
	//EV_MODE, EV_STATUS, EV_MEHOD, EV_STEP, EV_OOB
	DOT11_EVENT_WSC_MODE_IND = 71,
	DOT11_EVENT_WSC_STATUS_IND = 72,
	DOT11_EVENT_WSC_METHOD_IND = 73,
	DOT11_EVENT_WSC_STEP_IND = 74,
	DOT11_EVENT_WSC_OOB_IND = 75,
#endif
#endif


	DOT11_EVENT_WSC_SWITCH_MODE = 		100,
	DOT11_EVENT_WSC_STOP = 				101,				
	DOT11_EVENT_WSC_SWITCH_WLAN_MODE =	108,						
	DOT11_EVENT_WSC_SET_MY_PIN =	 	102,
	DOT11_EVENT_WSC_SPEC_SSID = 	103,
	DOT11_EVENT_WSC_SPEC_MAC_IND = 	104,
	DOT11_EVENT_WSC_CHANGE_MODE = 	105,	
	
	DOT11_EVENT_WSC_RM_PBC_STA=		106,
	DOT11_EVENT_WSC_CHANGE_MAC_IND = 107,		

	/*HS2_SUPPORT*/
	DOT11_EVENT_WNM_NOTIFY = 		109,
	DOT11_EVENT_GAS_INIT_REQ = 		110,
	DOT11_EVENT_GAS_COMEBACK_REQ = 	111,
	DOT11_EVENT_HS2_SET_IE = 		112,
	DOT11_EVENT_HS2_GAS_RSP = 		113,
	DOT11_EVENT_HS2_GET_TSF = 		114,
	DOT11_EVENT_HS2_TSM_REQ = 		115,
	DOT11_EVENT_HS2_GET_RSN = 		116,
	DOT11_EVENT_HS2_GET_MMPDULIMIT=117,
	DOT11_EVENT_WNM_DEAUTH_REQ = 	118,
	DOT11_EVENT_QOS_MAP_CONF = 		119,

	/*CONFIG_IEEE80211W*/ 
	DOT11_EVENT_SET_PMF = 			120,
	DOT11_EVENT_GET_IGTK_PN = 		121,
	DOT11_EVENT_INIT_PMF = 			122,	// HS2 R2 logo test

	/*RSSI_MONITOR_NCR*/
	DOT11_EVENT_RSSI_MONITOR_REPORT = 122,
	DOT11_EVENT_RSSI_MONITOR_SETTYPE = 123,	

	/*CONFIG_IEEE80211R*/
	DOT11_EVENT_FT_GET_EVENT		= 125,
	DOT11_EVENT_FT_IMD_ASSOC_IND	= 126,
	DOT11_EVENT_FT_GET_KEY			= 127,
	DOT11_EVENT_FT_SET_KEY			= 128,
	DOT11_EVENT_FT_PULL_KEY_IND		= 129,
	DOT11_EVENT_FT_ASSOC_IND		= 130,
	DOT11_EVENT_FT_KEY_EXPIRE_IND	= 131,
	DOT11_EVENT_FT_ACTION_IND		= 132,
	DOT11_EVENT_FT_QUERY_INFO		= 133,
	DOT11_EVENT_FT_SET_INFO			= 134,
	DOT11_EVENT_FT_AUTH_INSERT_R0	= 135,
	DOT11_EVENT_FT_AUTH_INSERT_R1	= 136,
	DOT11_EVENT_FT_TRIGGER_EVENT	= 137,

	/*USER_ADDIE*/
	DOT11_EVENT_USER_SETIE	= 138,

	/*SUPPORT_UCFGING_LED*/
	DOT11_EVENT_UCFGING_LED	= 139,


	/*INDICATE_LINK_CHANGE*/
	DOT11_EVENT_LINK_CHANGE_IND = 140,

	/*RTK_PEER AP and STA fast connection*/
	DOT11_EVENT_FC_DISASSOC_ALL_STA = 141,
	DOT11_EVENT_STA_ASSOCIATION_IND = 142,
#ifdef CONFIG_IEEE80211R_CLI
	DOT11_EVENT_FT_REASSOC_RSP		= 133, 
#endif
#ifdef ROAMING_SUPPORT
	DOT11_EVENT_ROAMING_STA_RSSI_ALARM = 143,
	DOT11_EVENT_ROAMING_STA_INFO_REPORT = 144,
	DOT11_EVENT_ROAMING_BSS_TRANSMIT_RESP = 145,
#endif
#ifdef BEACON_VS_IE
	EVENT_PROBE_RX_VSIE = 146,
#endif
#if defined(GENERAL_EVENT)
	DOT11_EVENT_GENERAL_GET_EVENT = 147, 
#endif
	DOT11_EVENT_UNKNOWN = 148
	
} DOT11_EVENT;
#endif
#endif
