/*
*  ## Please DO NOT edit this file!! ##
*  This file is auto-generated from the register source files.
*  Any modifications to this file will be LOST when it is re-generated.
*
*  ----------------------------------------------------------------
*  (c) Realtek Semiconductor Corp. 2008
*
*  This file is property of Realtek Semiconductor Corp.
*  All rights reserved.
*
*  Abstract: chip register definition and API of RTL8316D
*
*  ---------------------------------------------------------------- */
#include <rtk_types.h>
#include "rtl8316d_general_reg.h"
#include "rtl8316d_reg_struct.h"
#include "rtl8316d_regField_list.h"
#include <rtk_error.h>
#include <asicdrv/rtl8316d_types.h>
#include <rtl8316d_debug.h>

#ifdef  CONFIG_X86I2C 
/*
@func ret_t | rtlglue_reg32_write | Set content of asic register.
@parm uint32 | reg | Register's address.
@parm uint32 | value | Value setting to register.
@rvalue RT_ERR_OK | Success.
@rvalue RT_ERR_SMI | SMI access error.
@comm
    The value will be set to ASIC mapping address only and it is always return RT_ERR_OK while setting un-mapping address registers.    
*/
rtk_api_ret_t rtlglue_reg32_write(uint32 reg, uint32 value)
{
    rtk_api_ret_t retVal;

    retVal = smi_write(reg, value);

    if (retVal != RT_ERR_OK) 
		return RT_ERR_SMI;

    return RT_ERR_OK;
}

/*
@func ret_t | rtlglue_reg32_read | Get content of register.
@parm uint32 | reg | Register's address.
@parm uint32* | value | Value of register.
@rvalue RT_ERR_OK | Success.
@rvalue RT_ERR_SMI | SMI access error.
@comm
     Value 0x0000 will be returned for ASIC un-mapping address.    
*/
uint32 rtlglue_reg32_read(uint32 reg, uint32 *value)
{
    uint32 regData;
    rtk_api_ret_t retVal;

    retVal = smi_read(reg, &regData);
    if (retVal != RT_ERR_OK) 
		return 0;

    return (regData);
}

rtk_api_ret_t rtlglue_reg32_read_data(uint32 reg, uint32 *value)
{
    uint32 regData;
    rtk_api_ret_t retVal;

    retVal = smi_read(reg, &regData);
    if (retVal != RT_ERR_OK) 
		return RT_ERR_SMI;

    *value = regData;

    return RT_ERR_OK;
}
#endif

#define REG_ADDR(unit, reg) (SWCORE_BASE + (rtl8316d_reg_list[reg].offset))

int32 reg_read(uint32 unit, rtk_reg_list_t reg, uint32 *value)
{
    if((reg >= REG_LIST_END) || (NULL == value))
      return -1;
    *value = MEM32_READ(REG_ADDR(unit, reg));

    return SUCCESS;
}

int32 reg_write(uint32 unit, rtk_reg_list_t reg, uint32 value)
{
    if(reg >= REG_LIST_END)
       return -1;

    MEM32_WRITE(REG_ADDR(unit, reg), value);

    return SUCCESS;
}

rtk_regField_t *reg_field_find(uint32 unit, rtk_reg_list_t reg, rtk_regField_list_t field)
{
    rtk_regField_t *pField = NULL;
    uint32 i;

    pField = &rtl8316d_reg_list[reg].fields[0];

    for(i=0; i<rtl8316d_reg_list[reg].field_num; i++, pField++)
    {
        if(pField->name == field)
           return pField;
    }

    return NULL;    /* field not found */
}

int32 reg_field_get(uint32 unit, rtk_reg_list_t reg, rtk_regField_list_t field, uint32 *value, uint32 data)
{
    rtk_regField_t *pField = NULL;
    uint32 ret;

    if((reg >= REG_LIST_END) || (field >= REGFIELD_LIST_END) || (NULL == value))
        return -1;

    pField = reg_field_find(unit, reg, field);

    if(NULL == pField)
        return -1;

    ret = data >> pField->lsp;

    if(pField->len < REG_DATA_LEN)
        *value = ret & ((1 << pField->len) - 1);
    else
        *value = ret;

    return SUCCESS;
}

int32 reg_field_set(uint32 unit, rtk_reg_list_t reg, rtk_regField_list_t field, uint32 value, uint32 *data)
{
    rtk_regField_t *pField = NULL;
    uint32 mask;

    if((reg >= REG_LIST_END) || (field >= REGFIELD_LIST_END) || (NULL == data))
        return -1;

    pField = reg_field_find(unit, reg, field);

    if(NULL == pField)
        return -1;

    if(pField->len < REG_DATA_LEN)
        mask = (1 << pField->len) - 1;
    else
        mask = REG_DATA_MASK;

    *data &= ~(mask << pField->lsp);
    *data |= ((value & mask) << pField->lsp);

    return SUCCESS;
}

int32 reg_field_read(uint32 unit, rtk_reg_list_t reg, rtk_regField_list_t field, uint32 *value)
{
    uint32 data;

    if((reg >= REG_LIST_END) || (NULL == value))
       return -1;

    data = MEM32_READ(REG_ADDR(unit, reg));

    return reg_field_get(unit, reg, field, value, data);
}

int32 reg_field_write(uint32 unit, rtk_reg_list_t reg, rtk_regField_list_t field, uint32 value)
{
    uint32 data;

    if(reg >= REG_LIST_END)
       return -1;

    data = MEM32_READ(REG_ADDR(unit, reg));


    if(reg_field_set(unit, reg, field, value, &data) != SUCCESS)
      return -1;

    MEM32_WRITE(REG_ADDR(unit, reg), data);

    return SUCCESS;
}

rtk_api_ret_t _wait_op_finished(void)
{
    uint32 reg_val;
    uint32 retVal;
    uint32 cnt;
    
    cnt = 0;
    while(cnt++ < 100)
    {
        if((retVal=reg_read(RTL8316D_UNIT, PHY_REG_ACCESS_CONTROL0_FOR_CPU, &reg_val))!=RT_ERR_OK)
            return retVal;

        if (reg_val == 0)
            break;
    }

    if(cnt == 100)
    {
        rtlglue_printf("Time out: waiting phy access operation finished!\n");
        return RT_ERR_FAILED;
    }

    return RT_ERR_OK;
}

int32 phy_reg_read(uint32 phyaddr, uint32 regaddr, uint32 page, uint16* reg_data)
{
    uint32 reg_val;
    uint32 retVal;
    uint32 cnt;
        
    if ((phyaddr > 31) || (regaddr > 31) || (page > 31))  
        return  RT_ERR_INPUT;

    if (reg_data == NULL)
        return RT_ERR_NULL_POINTER;

    if ((retVal = _wait_op_finished()) != RT_ERR_OK)
        return retVal;
    
    if((retVal=reg_field_write(RTL8316D_UNIT, PHY_REG_ACCESS_CONTROL0_FOR_CPU, CPU_PHYADDR_4_0, phyaddr))!=RT_ERR_OK)
        return retVal;

    if((retVal=reg_field_write(RTL8316D_UNIT, PHY_REG_ACCESS_CONTROL0_FOR_CPU, CPU_REG_4_0, regaddr))!=RT_ERR_OK)
        return retVal;

    if((retVal=reg_field_write(RTL8316D_UNIT, PHY_REG_ACCESS_CONTROL0_FOR_CPU, CPU_PAGE_4_0, page))!=RT_ERR_OK)
        return retVal;

    if((retVal=reg_field_write(RTL8316D_UNIT, PHY_REG_ACCESS_CONTROL0_FOR_CPU, CPU_RWOP, RTL8316D_PHY_READ))!=RT_ERR_OK)
        return retVal;

    if((retVal=reg_field_write(RTL8316D_UNIT, PHY_REG_ACCESS_CONTROL0_FOR_CPU, CPU_CMD, 1))!=RT_ERR_OK)
        return retVal;

    cnt = 0;
    while(cnt++ < 100)
    {
        if((retVal=reg_field_read(RTL8316D_UNIT, PHY_REG_ACCESS_CONTROL0_FOR_CPU, CPU_CMD, &reg_val))!=RT_ERR_OK)
            return retVal;

        if (reg_val == 0)
            break;
    }

    if(cnt == 100)
    {
        rtlglue_printf("Time out\n");
        return RT_ERR_FAILED;
    }

    if((retVal=reg_field_read(RTL8316D_UNIT, PHY_REG_ACCESS_CONTROL2_FOR_CPU, CPU_ADDR_DATA_15_0, &reg_val))!=RT_ERR_OK)
        return retVal;

    *reg_data = reg_val;
    
    return RT_ERR_OK;
}

int32 phy_reg_write(uint32 phyaddr, uint32 regaddr, uint32 page, uint16 reg_data)
{
    uint32 reg_val;
    uint32 retVal;
    uint32 cnt;
    
    if ((phyaddr > 31) || (regaddr > 31) || (page > 31))  
        return  RT_ERR_INPUT;

    if ((retVal = _wait_op_finished()) != RT_ERR_OK)
        return retVal;

    if((retVal=reg_field_write(RTL8316D_UNIT, PHY_REG_ACCESS_CONTROL0_FOR_CPU, CPU_OCCUPY_PHY, 1))!=RT_ERR_OK)
        return retVal;
    
    if((retVal=reg_field_write(RTL8316D_UNIT, PHY_REG_ACCESS_CONTROL0_FOR_CPU, CPU_PHYADDR_4_0, phyaddr))!=RT_ERR_OK)
        return retVal;

    if((retVal=reg_field_write(RTL8316D_UNIT, PHY_REG_ACCESS_CONTROL0_FOR_CPU, CPU_REG_4_0, regaddr))!=RT_ERR_OK)
        return retVal;

    if((retVal=reg_field_write(RTL8316D_UNIT, PHY_REG_ACCESS_CONTROL0_FOR_CPU, CPU_PAGE_4_0, page))!=RT_ERR_OK)
        return retVal;

    reg_val = reg_data;
    if((retVal=reg_field_write(RTL8316D_UNIT, PHY_REG_ACCESS_CONTROL2_FOR_CPU, CPU_ADDR_DATA_15_0, reg_val))!=RT_ERR_OK)
        return retVal;
    
    if((retVal=reg_field_write(RTL8316D_UNIT, PHY_REG_ACCESS_CONTROL0_FOR_CPU, CPU_RWOP, RTL8316D_PHY_WRITE))!=RT_ERR_OK)
        return retVal;

    if((retVal=reg_field_write(RTL8316D_UNIT, PHY_REG_ACCESS_CONTROL0_FOR_CPU, CPU_CMD, 1))!=RT_ERR_OK)
        return retVal;

    cnt = 0;
    while(cnt++ < 100)
    {
        if((retVal=reg_field_read(RTL8316D_UNIT, PHY_REG_ACCESS_CONTROL0_FOR_CPU, CPU_CMD, &reg_val))!=RT_ERR_OK)
            return retVal;

        if (reg_val == 0)
            break;
    }

     if(cnt == 100)
     {
        rtlglue_printf("Time out: waiting operation is finished!\n");
        if((retVal=reg_field_write(RTL8316D_UNIT, PHY_REG_ACCESS_CONTROL0_FOR_CPU, CPU_OCCUPY_PHY, 0))!=RT_ERR_OK)
            return retVal;
        return RT_ERR_FAILED;
     }     

     if((retVal=reg_field_write(RTL8316D_UNIT, PHY_REG_ACCESS_CONTROL0_FOR_CPU, CPU_OCCUPY_PHY, 0))!=RT_ERR_OK)
        return retVal;
      
     return RT_ERR_OK;
}


rtk_reg_t rtl8316d_reg_list[] =
{
    {   /* register name        INDIRECT_CONTROL_FOR_CPU */
        /* offset address */    0x0,
        /* field numbers */     6,
        /* register fields */   INDIRECT_CONTROL_FOR_CPU_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        INDIRECT_DATA0_FOR_CPU */
        /* offset address */    0x4,
        /* field numbers */     1,
        /* register fields */   INDIRECT_DATA0_FOR_CPU_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        INDIRECT_DATA1_FOR_CPU */
        /* offset address */    0x8,
        /* field numbers */     1,
        /* register fields */   INDIRECT_DATA1_FOR_CPU_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        INDIRECT_DATA2_FOR_CPU */
        /* offset address */    0xC,
        /* field numbers */     1,
        /* register fields */   INDIRECT_DATA2_FOR_CPU_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        INDIRECT_DATA3_FOR_CPU */
        /* offset address */    0x10,
        /* field numbers */     1,
        /* register fields */   INDIRECT_DATA3_FOR_CPU_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        INDIRECT_DATA4_FOR_CPU */
        /* offset address */    0x14,
        /* field numbers */     3,
        /* register fields */   INDIRECT_DATA4_FOR_CPU_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        INDIRECT_DATA5_FOR_CPU */
        /* offset address */    0x18,
        /* field numbers */     1,
        /* register fields */   INDIRECT_DATA5_FOR_CPU_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        INDIRECT_DATA6_FOR_CPU */
        /* offset address */    0x1C,
        /* field numbers */     1,
        /* register fields */   INDIRECT_DATA6_FOR_CPU_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        INDIRECT_DATA7_FOR_CPU */
        /* offset address */    0x20,
        /* field numbers */     1,
        /* register fields */   INDIRECT_DATA7_FOR_CPU_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        INDIRECT_DATA8_FOR_CPU */
        /* offset address */    0x24,
        /* field numbers */     1,
        /* register fields */   INDIRECT_DATA8_FOR_CPU_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        INDIRECT_DATA9_FOR_CPU */
        /* offset address */    0x28,
        /* field numbers */     2,
        /* register fields */   INDIRECT_DATA9_FOR_CPU_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        INDIRECT_CONTROL_FOR_RRCP */
        /* offset address */    0x2C,
        /* field numbers */     5,
        /* register fields */   INDIRECT_CONTROL_FOR_RRCP_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        INDIRECT_DATA0_FOR_RRCP */
        /* offset address */    0x30,
        /* field numbers */     1,
        /* register fields */   INDIRECT_DATA0_FOR_RRCP_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        INDIRECT_DATA1_FOR_RRCP */
        /* offset address */    0x34,
        /* field numbers */     1,
        /* register fields */   INDIRECT_DATA1_FOR_RRCP_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        INDIRECT_DATA2_FOR_RRCP */
        /* offset address */    0x38,
        /* field numbers */     1,
        /* register fields */   INDIRECT_DATA2_FOR_RRCP_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        INDIRECT_DATA3_FOR_RRCP */
        /* offset address */    0x3C,
        /* field numbers */     1,
        /* register fields */   INDIRECT_DATA3_FOR_RRCP_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        INDIRECT_DATA4_FOR_RRCP */
        /* offset address */    0x40,
        /* field numbers */     3,
        /* register fields */   INDIRECT_DATA4_FOR_RRCP_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        INDIRECT_DATA5_FOR_RRCP */
        /* offset address */    0x44,
        /* field numbers */     1,
        /* register fields */   INDIRECT_DATA5_FOR_RRCP_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        INDIRECT_DATA6_FOR_RRCP */
        /* offset address */    0x48,
        /* field numbers */     1,
        /* register fields */   INDIRECT_DATA6_FOR_RRCP_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        INDIRECT_DATA7_FOR_RRCP */
        /* offset address */    0x4C,
        /* field numbers */     1,
        /* register fields */   INDIRECT_DATA7_FOR_RRCP_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        INDIRECT_DATA8_FOR_RRCP */
        /* offset address */    0x50,
        /* field numbers */     1,
        /* register fields */   INDIRECT_DATA8_FOR_RRCP_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        INDIRECT_DATA9_FOR_RRCP */
        /* offset address */    0x54,
        /* field numbers */     2,
        /* register fields */   INDIRECT_DATA9_FOR_RRCP_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        ALE_DMY0 */
        /* offset address */    0x58,
        /* field numbers */     1,
        /* register fields */   ALE_DMY0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        ALE_DMY1 */
        /* offset address */    0x5C,
        /* field numbers */     1,
        /* register fields */   ALE_DMY1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        ALE_DMY2 */
        /* offset address */    0x60,
        /* field numbers */     1,
        /* register fields */   ALE_DMY2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        ALE_DMY3 */
        /* offset address */    0x64,
        /* field numbers */     1,
        /* register fields */   ALE_DMY3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        ALE_DMY4 */
        /* offset address */    0x68,
        /* field numbers */     1,
        /* register fields */   ALE_DMY4_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        ALE_DMY5 */
        /* offset address */    0x6C,
        /* field numbers */     1,
        /* register fields */   ALE_DMY5_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        ALE_DMY6 */
        /* offset address */    0x70,
        /* field numbers */     1,
        /* register fields */   ALE_DMY6_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        ALE_DMY7 */
        /* offset address */    0x74,
        /* field numbers */     1,
        /* register fields */   ALE_DMY7_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        ALE_DMY8 */
        /* offset address */    0x78,
        /* field numbers */     1,
        /* register fields */   ALE_DMY8_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        ALE_DMY9 */
        /* offset address */    0x7C,
        /* field numbers */     1,
        /* register fields */   ALE_DMY9_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Global_MAC_Interface_Control0 */
        /* offset address */    0x10000,
        /* field numbers */     24,
        /* register fields */   GLOBAL_MAC_INTERFACE_CONTROL0_FIELDS,
        /* default value */     0x7800EC0
    },
    {   /* register name        Global_MAC_Interface_Internal0 */
        /* offset address */    0x10004,
        /* field numbers */     32,
        /* register fields */   GLOBAL_MAC_INTERFACE_INTERNAL0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Global_MAC_Interface_Internal1 */
        /* offset address */    0x10008,
        /* field numbers */     32,
        /* register fields */   GLOBAL_MAC_INTERFACE_INTERNAL1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Global_MAC_Interface_Internal2 */
        /* offset address */    0x1000C,
        /* field numbers */     28,
        /* register fields */   GLOBAL_MAC_INTERFACE_INTERNAL2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Global_MAC_Interface_Internal3 */
        /* offset address */    0x10010,
        /* field numbers */     7,
        /* register fields */   GLOBAL_MAC_INTERFACE_INTERNAL3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Interface_DMY_Regsiter */
        /* offset address */    0x10014,
        /* field numbers */     1,
        /* register fields */   INTERFACE_DMY_REGSITER_FIELDS,
        /* default value */     0x1FF
    },
    {   /* register name        Reset_Global_Control0 */
        /* offset address */    0x20000,
        /* field numbers */     5,
        /* register fields */   RESET_GLOBAL_CONTROL0_FIELDS,
        /* default value */     0xF
    },
    {   /* register name        Reset_Global_Control1 */
        /* offset address */    0x20004,
        /* field numbers */     2,
        /* register fields */   RESET_GLOBAL_CONTROL1_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        Reset_Global_Control2 */
        /* offset address */    0x20008,
        /* field numbers */     3,
        /* register fields */   RESET_GLOBAL_CONTROL2_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Reset_Global_Status */
        /* offset address */    0x2000C,
        /* field numbers */     6,
        /* register fields */   RESET_GLOBAL_STATUS_FIELDS,
        /* default value */     0x7E
    },
    {   /* register name        Reset_DMY */
        /* offset address */    0x20010,
        /* field numbers */     1,
        /* register fields */   RESET_DMY_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Global_PLL_Control0 */
        /* offset address */    0x30000,
        /* field numbers */     12,
        /* register fields */   GLOBAL_PLL_CONTROL0_FIELDS,
        /* default value */     0x70CC250
    },
    {   /* register name        Switch_PLL_Control0 */
        /* offset address */    0x30004,
        /* field numbers */     9,
        /* register fields */   SWITCH_PLL_CONTROL0_FIELDS,
        /* default value */     0x8D18
    },
    {   /* register name        IF_PLL_Control0 */
        /* offset address */    0x30008,
        /* field numbers */     10,
        /* register fields */   IF_PLL_CONTROL0_FIELDS,
        /* default value */     0x8D18
    },
    {   /* register name        Bias_Control0 */
        /* offset address */    0x3000C,
        /* field numbers */     4,
        /* register fields */   BIAS_CONTROL0_FIELDS,
        /* default value */     0x8
    },
    {   /* register name        PLL_DMY */
        /* offset address */    0x30010,
        /* field numbers */     1,
        /* register fields */   PLL_DMY_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        SMI_CONTROL */
        /* offset address */    0x40000,
        /* field numbers */     8,
        /* register fields */   SMI_CONTROL_FIELDS,
        /* default value */     0xC
    },
    {   /* register name        MAC_PHY_ADDRESS_CONFIGURE */
        /* offset address */    0x40004,
        /* field numbers */     5,
        /* register fields */   MAC_PHY_ADDRESS_CONFIGURE_FIELDS,
        /* default value */     0x5AF8
    },
    {   /* register name        PHY_REG_ACCESS_CONTROL0_for_CPU */
        /* offset address */    0x40008,
        /* field numbers */     9,
        /* register fields */   PHY_REG_ACCESS_CONTROL0_FOR_CPU_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PHY_REG_ACCESS_CONTROL1_for_CPU */
        /* offset address */    0x4000C,
        /* field numbers */     2,
        /* register fields */   PHY_REG_ACCESS_CONTROL1_FOR_CPU_FIELDS,
        /* default value */     0xFFFFFF
    },
    {   /* register name        PHY_REG_ACCESS_CONTROL2_for_CPU */
        /* offset address */    0x40010,
        /* field numbers */     2,
        /* register fields */   PHY_REG_ACCESS_CONTROL2_FOR_CPU_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PHY_REG_ACCESS_CONTROL0_for_RRCP */
        /* offset address */    0x40014,
        /* field numbers */     8,
        /* register fields */   PHY_REG_ACCESS_CONTROL0_FOR_RRCP_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PHY_REG_ACCESS_CONTROL1_for_RRCP */
        /* offset address */    0x40018,
        /* field numbers */     2,
        /* register fields */   PHY_REG_ACCESS_CONTROL1_FOR_RRCP_FIELDS,
        /* default value */     0xFFFFFF
    },
    {   /* register name        PHY_REG_ACCESS_CONTROL2_for_RRCP */
        /* offset address */    0x4001C,
        /* field numbers */     2,
        /* register fields */   PHY_REG_ACCESS_CONTROL2_FOR_RRCP_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PHY_AUTO_ACCESS_MASK0 */
        /* offset address */    0x40020,
        /* field numbers */     3,
        /* register fields */   PHY_AUTO_ACCESS_MASK0_FIELDS,
        /* default value */     0xFFFFFF
    },
    {   /* register name        PHY_AUTO_ACCESS_MASK1 */
        /* offset address */    0x40024,
        /* field numbers */     2,
        /* register fields */   PHY_AUTO_ACCESS_MASK1_FIELDS,
        /* default value */     0xFFFFFF
    },
    {   /* register name        PORT0_PROPERTY_CONFIGURE */
        /* offset address */    0x40028,
        /* field numbers */     14,
        /* register fields */   PORT0_PROPERTY_CONFIGURE_FIELDS,
        /* default value */     0x206F8
    },
    {   /* register name        PORT1_PROPERTY_CONFIGURE */
        /* offset address */    0x4002C,
        /* field numbers */     14,
        /* register fields */   PORT1_PROPERTY_CONFIGURE_FIELDS,
        /* default value */     0x206F8
    },
    {   /* register name        PORT2_PROPERTY_CONFIGURE */
        /* offset address */    0x40030,
        /* field numbers */     14,
        /* register fields */   PORT2_PROPERTY_CONFIGURE_FIELDS,
        /* default value */     0x206F8
    },
    {   /* register name        PORT3_PROPERTY_CONFIGURE */
        /* offset address */    0x40034,
        /* field numbers */     14,
        /* register fields */   PORT3_PROPERTY_CONFIGURE_FIELDS,
        /* default value */     0x206F8
    },
    {   /* register name        PORT4_PROPERTY_CONFIGURE */
        /* offset address */    0x40038,
        /* field numbers */     14,
        /* register fields */   PORT4_PROPERTY_CONFIGURE_FIELDS,
        /* default value */     0x206F8
    },
    {   /* register name        PORT5_PROPERTY_CONFIGURE */
        /* offset address */    0x4003C,
        /* field numbers */     14,
        /* register fields */   PORT5_PROPERTY_CONFIGURE_FIELDS,
        /* default value */     0x206F8
    },
    {   /* register name        PORT6_PROPERTY_CONFIGURE */
        /* offset address */    0x40040,
        /* field numbers */     14,
        /* register fields */   PORT6_PROPERTY_CONFIGURE_FIELDS,
        /* default value */     0x206F8
    },
    {   /* register name        PORT7_PROPERTY_CONFIGURE */
        /* offset address */    0x40044,
        /* field numbers */     14,
        /* register fields */   PORT7_PROPERTY_CONFIGURE_FIELDS,
        /* default value */     0x206F8
    },
    {   /* register name        PORT8_PROPERTY_CONFIGURE */
        /* offset address */    0x40048,
        /* field numbers */     14,
        /* register fields */   PORT8_PROPERTY_CONFIGURE_FIELDS,
        /* default value */     0x206F8
    },
    {   /* register name        PORT9_PROPERTY_CONFIGURE */
        /* offset address */    0x4004C,
        /* field numbers */     14,
        /* register fields */   PORT9_PROPERTY_CONFIGURE_FIELDS,
        /* default value */     0x206F8
    },
    {   /* register name        PORT10_PROPERTY_CONFIGURE */
        /* offset address */    0x40050,
        /* field numbers */     14,
        /* register fields */   PORT10_PROPERTY_CONFIGURE_FIELDS,
        /* default value */     0x206F8
    },
    {   /* register name        PORT11_PROPERTY_CONFIGURE */
        /* offset address */    0x40054,
        /* field numbers */     14,
        /* register fields */   PORT11_PROPERTY_CONFIGURE_FIELDS,
        /* default value */     0x206F8
    },
    {   /* register name        PORT12_PROPERTY_CONFIGURE */
        /* offset address */    0x40058,
        /* field numbers */     14,
        /* register fields */   PORT12_PROPERTY_CONFIGURE_FIELDS,
        /* default value */     0x206F8
    },
    {   /* register name        PORT13_PROPERTY_CONFIGURE */
        /* offset address */    0x4005C,
        /* field numbers */     14,
        /* register fields */   PORT13_PROPERTY_CONFIGURE_FIELDS,
        /* default value */     0x206F8
    },
    {   /* register name        PORT14_PROPERTY_CONFIGURE */
        /* offset address */    0x40060,
        /* field numbers */     14,
        /* register fields */   PORT14_PROPERTY_CONFIGURE_FIELDS,
        /* default value */     0x206F8
    },
    {   /* register name        PORT15_PROPERTY_CONFIGURE */
        /* offset address */    0x40064,
        /* field numbers */     14,
        /* register fields */   PORT15_PROPERTY_CONFIGURE_FIELDS,
        /* default value */     0x206F8
    },
    {   /* register name        PORT16_PROPERTY_CONFIGURE */
        /* offset address */    0x40068,
        /* field numbers */     14,
        /* register fields */   PORT16_PROPERTY_CONFIGURE_FIELDS,
        /* default value */     0x206F8
    },
    {   /* register name        PORT17_PROPERTY_CONFIGURE */
        /* offset address */    0x4006C,
        /* field numbers */     14,
        /* register fields */   PORT17_PROPERTY_CONFIGURE_FIELDS,
        /* default value */     0x206F8
    },
    {   /* register name        PORT18_PROPERTY_CONFIGURE */
        /* offset address */    0x40070,
        /* field numbers */     14,
        /* register fields */   PORT18_PROPERTY_CONFIGURE_FIELDS,
        /* default value */     0x206F8
    },
    {   /* register name        PORT19_PROPERTY_CONFIGURE */
        /* offset address */    0x40074,
        /* field numbers */     14,
        /* register fields */   PORT19_PROPERTY_CONFIGURE_FIELDS,
        /* default value */     0x206F8
    },
    {   /* register name        PORT20_PROPERTY_CONFIGURE */
        /* offset address */    0x40078,
        /* field numbers */     14,
        /* register fields */   PORT20_PROPERTY_CONFIGURE_FIELDS,
        /* default value */     0x206F8
    },
    {   /* register name        PORT21_PROPERTY_CONFIGURE */
        /* offset address */    0x4007C,
        /* field numbers */     14,
        /* register fields */   PORT21_PROPERTY_CONFIGURE_FIELDS,
        /* default value */     0x206F8
    },
    {   /* register name        PORT22_PROPERTY_CONFIGURE */
        /* offset address */    0x40080,
        /* field numbers */     16,
        /* register fields */   PORT22_PROPERTY_CONFIGURE_FIELDS,
        /* default value */     0x606F8
    },
    {   /* register name        PORT23_PROPERTY_CONFIGURE */
        /* offset address */    0x40084,
        /* field numbers */     16,
        /* register fields */   PORT23_PROPERTY_CONFIGURE_FIELDS,
        /* default value */     0x606F8
    },
    {   /* register name        PORT24_PROPERTY_CONFIGURE */
        /* offset address */    0x40088,
        /* field numbers */     16,
        /* register fields */   PORT24_PROPERTY_CONFIGURE_FIELDS,
        /* default value */     0x607F8
    },
    {   /* register name        PORT0_LINK_STATUS */
        /* offset address */    0x4008C,
        /* field numbers */     16,
        /* register fields */   PORT0_LINK_STATUS_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT1_LINK_STATUS */
        /* offset address */    0x40090,
        /* field numbers */     16,
        /* register fields */   PORT1_LINK_STATUS_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT2_LINK_STATUS */
        /* offset address */    0x40094,
        /* field numbers */     16,
        /* register fields */   PORT2_LINK_STATUS_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT3_LINK_STATUS */
        /* offset address */    0x40098,
        /* field numbers */     16,
        /* register fields */   PORT3_LINK_STATUS_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT4_LINK_STATUS */
        /* offset address */    0x4009C,
        /* field numbers */     16,
        /* register fields */   PORT4_LINK_STATUS_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT5_LINK_STATUS */
        /* offset address */    0x400A0,
        /* field numbers */     16,
        /* register fields */   PORT5_LINK_STATUS_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT6_LINK_STATUS */
        /* offset address */    0x400A4,
        /* field numbers */     16,
        /* register fields */   PORT6_LINK_STATUS_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT7_LINK_STATUS */
        /* offset address */    0x400A8,
        /* field numbers */     16,
        /* register fields */   PORT7_LINK_STATUS_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT8_LINK_STATUS */
        /* offset address */    0x400AC,
        /* field numbers */     16,
        /* register fields */   PORT8_LINK_STATUS_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT9_LINK_STATUS */
        /* offset address */    0x400B0,
        /* field numbers */     16,
        /* register fields */   PORT9_LINK_STATUS_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT10_LINK_STATUS */
        /* offset address */    0x400B4,
        /* field numbers */     16,
        /* register fields */   PORT10_LINK_STATUS_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT11_LINK_STATUS */
        /* offset address */    0x400B8,
        /* field numbers */     16,
        /* register fields */   PORT11_LINK_STATUS_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT12_LINK_STATUS */
        /* offset address */    0x400BC,
        /* field numbers */     16,
        /* register fields */   PORT12_LINK_STATUS_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT13_LINK_STATUS */
        /* offset address */    0x400C0,
        /* field numbers */     16,
        /* register fields */   PORT13_LINK_STATUS_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT14_LINK_STATUS */
        /* offset address */    0x400C4,
        /* field numbers */     16,
        /* register fields */   PORT14_LINK_STATUS_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT15_LINK_STATUS */
        /* offset address */    0x400C8,
        /* field numbers */     16,
        /* register fields */   PORT15_LINK_STATUS_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT16_LINK_STATUS */
        /* offset address */    0x400CC,
        /* field numbers */     16,
        /* register fields */   PORT16_LINK_STATUS_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT17_LINK_STATUS */
        /* offset address */    0x400D0,
        /* field numbers */     16,
        /* register fields */   PORT17_LINK_STATUS_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT18_LINK_STATUS */
        /* offset address */    0x400D4,
        /* field numbers */     16,
        /* register fields */   PORT18_LINK_STATUS_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT19_LINK_STATUS */
        /* offset address */    0x400D8,
        /* field numbers */     16,
        /* register fields */   PORT19_LINK_STATUS_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT20_LINK_STATUS */
        /* offset address */    0x400DC,
        /* field numbers */     16,
        /* register fields */   PORT20_LINK_STATUS_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT21_LINK_STATUS */
        /* offset address */    0x400E0,
        /* field numbers */     16,
        /* register fields */   PORT21_LINK_STATUS_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT22_LINK_STATUS */
        /* offset address */    0x400E4,
        /* field numbers */     16,
        /* register fields */   PORT22_LINK_STATUS_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT23_LINK_STATUS */
        /* offset address */    0x400E8,
        /* field numbers */     16,
        /* register fields */   PORT23_LINK_STATUS_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT24_LINK_STATUS */
        /* offset address */    0x400EC,
        /* field numbers */     16,
        /* register fields */   PORT24_LINK_STATUS_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PHY_address_Broadcast_Control */
        /* offset address */    0x400F0,
        /* field numbers */     2,
        /* register fields */   PHY_ADDRESS_BROADCAST_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        SMI_DMY */
        /* offset address */    0x400F4,
        /* field numbers */     1,
        /* register fields */   SMI_DMY_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        External_Access_Control */
        /* offset address */    0x50000,
        /* field numbers */     5,
        /* register fields */   EXTERNAL_ACCESS_CONTROL_FIELDS,
        /* default value */     0x10
    },
    {   /* register name        I2C_External_Access_Status */
        /* offset address */    0x50004,
        /* field numbers */     2,
        /* register fields */   I2C_EXTERNAL_ACCESS_STATUS_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        I2C_External_Access_Address */
        /* offset address */    0x50008,
        /* field numbers */     2,
        /* register fields */   I2C_EXTERNAL_ACCESS_ADDRESS_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        EEPROM_Auto_Download_Control0 */
        /* offset address */    0x5000C,
        /* field numbers */     10,
        /* register fields */   EEPROM_AUTO_DOWNLOAD_CONTROL0_FIELDS,
        /* default value */     0x3E0000
    },
    {   /* register name        EEPROM_FDR_control_regsiter */
        /* offset address */    0x50010,
        /* field numbers */     2,
        /* register fields */   EEPROM_FDR_CONTROL_REGSITER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        EEPROM_AutoDownload_MAC_Postion */
        /* offset address */    0x50014,
        /* field numbers */     2,
        /* register fields */   EEPROM_AUTODOWNLOAD_MAC_POSTION_FIELDS,
        /* default value */     0x4000400
    },
    {   /* register name        EEPROM_AutoDownload_PHY_Postion */
        /* offset address */    0x50018,
        /* field numbers */     2,
        /* register fields */   EEPROM_AUTODOWNLOAD_PHY_POSTION_FIELDS,
        /* default value */     0x4000400
    },
    {   /* register name        EEPROM_AutoDownload_LUT_Postion */
        /* offset address */    0x5001C,
        /* field numbers */     2,
        /* register fields */   EEPROM_AUTODOWNLOAD_LUT_POSTION_FIELDS,
        /* default value */     0x4000400
    },
    {   /* register name        EEPROM_Status_and_FDR_EXEC */
        /* offset address */    0x50020,
        /* field numbers */     6,
        /* register fields */   EEPROM_STATUS_AND_FDR_EXEC_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        CPU_Indirect_Access_EEPROM_Control */
        /* offset address */    0x50024,
        /* field numbers */     11,
        /* register fields */   CPU_INDIRECT_ACCESS_EEPROM_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        CPU_Indirect_Access_EEPROM_Data0 */
        /* offset address */    0x50028,
        /* field numbers */     4,
        /* register fields */   CPU_INDIRECT_ACCESS_EEPROM_DATA0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        CPU_Indirect_Access_EEPROM_Data1 */
        /* offset address */    0x5002C,
        /* field numbers */     4,
        /* register fields */   CPU_INDIRECT_ACCESS_EEPROM_DATA1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        CPU_Indirect_Access_EEPROM_Data2 */
        /* offset address */    0x50030,
        /* field numbers */     4,
        /* register fields */   CPU_INDIRECT_ACCESS_EEPROM_DATA2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        CPU_Indirect_Access_EEPROM_Data3 */
        /* offset address */    0x50034,
        /* field numbers */     4,
        /* register fields */   CPU_INDIRECT_ACCESS_EEPROM_DATA3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        CPU_Indirect_Access_EEPROM_Data4 */
        /* offset address */    0x50038,
        /* field numbers */     4,
        /* register fields */   CPU_INDIRECT_ACCESS_EEPROM_DATA4_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        CPU_Indirect_Access_EEPROM_Data5 */
        /* offset address */    0x5003C,
        /* field numbers */     4,
        /* register fields */   CPU_INDIRECT_ACCESS_EEPROM_DATA5_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        CPU_Indirect_Access_EEPROM_Data6 */
        /* offset address */    0x50040,
        /* field numbers */     4,
        /* register fields */   CPU_INDIRECT_ACCESS_EEPROM_DATA6_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        CPU_Indirect_Access_EEPROM_Data7 */
        /* offset address */    0x50044,
        /* field numbers */     4,
        /* register fields */   CPU_INDIRECT_ACCESS_EEPROM_DATA7_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        RRCP_Indirect_Access_EEPROM_Control */
        /* offset address */    0x50048,
        /* field numbers */     10,
        /* register fields */   RRCP_INDIRECT_ACCESS_EEPROM_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        RRCP_Indirect_Access_EEPROM_Data0 */
        /* offset address */    0x5004C,
        /* field numbers */     4,
        /* register fields */   RRCP_INDIRECT_ACCESS_EEPROM_DATA0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        RRCP_Indirect_Access_EEPROM_Data1 */
        /* offset address */    0x50050,
        /* field numbers */     4,
        /* register fields */   RRCP_INDIRECT_ACCESS_EEPROM_DATA1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        RRCP_Indirect_Access_EEPROM_Data2 */
        /* offset address */    0x50054,
        /* field numbers */     4,
        /* register fields */   RRCP_INDIRECT_ACCESS_EEPROM_DATA2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        RRCP_Indirect_Access_EEPROM_Data3 */
        /* offset address */    0x50058,
        /* field numbers */     4,
        /* register fields */   RRCP_INDIRECT_ACCESS_EEPROM_DATA3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        RRCP_Indirect_Access_EEPROM_Data4 */
        /* offset address */    0x5005C,
        /* field numbers */     4,
        /* register fields */   RRCP_INDIRECT_ACCESS_EEPROM_DATA4_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        RRCP_Indirect_Access_EEPROM_Data5 */
        /* offset address */    0x50060,
        /* field numbers */     4,
        /* register fields */   RRCP_INDIRECT_ACCESS_EEPROM_DATA5_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        RRCP_Indirect_Access_EEPROM_Data6 */
        /* offset address */    0x50064,
        /* field numbers */     4,
        /* register fields */   RRCP_INDIRECT_ACCESS_EEPROM_DATA6_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        RRCP_Indirect_Access_EEPROM_Data7 */
        /* offset address */    0x50068,
        /* field numbers */     4,
        /* register fields */   RRCP_INDIRECT_ACCESS_EEPROM_DATA7_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        I2C_DMY */
        /* offset address */    0x5006C,
        /* field numbers */     1,
        /* register fields */   I2C_DMY_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        IO_Driving_Ability_Control0 */
        /* offset address */    0x60000,
        /* field numbers */     1,
        /* register fields */   IO_DRIVING_ABILITY_CONTROL0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        IO_Driving_Ability_Control1 */
        /* offset address */    0x60004,
        /* field numbers */     1,
        /* register fields */   IO_DRIVING_ABILITY_CONTROL1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        IO_Driving_Ability_Control2 */
        /* offset address */    0x60008,
        /* field numbers */     1,
        /* register fields */   IO_DRIVING_ABILITY_CONTROL2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        IO_Driving_Ability_Control3 */
        /* offset address */    0x6000C,
        /* field numbers */     1,
        /* register fields */   IO_DRIVING_ABILITY_CONTROL3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        IO_Slew_Rate_Control0 */
        /* offset address */    0x60010,
        /* field numbers */     1,
        /* register fields */   IO_SLEW_RATE_CONTROL0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        IO_Slew_Rate_Control1 */
        /* offset address */    0x60014,
        /* field numbers */     1,
        /* register fields */   IO_SLEW_RATE_CONTROL1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        IO_Slew_Rate_Control2 */
        /* offset address */    0x60018,
        /* field numbers */     1,
        /* register fields */   IO_SLEW_RATE_CONTROL2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        IO_Slew_Rate_Control3 */
        /* offset address */    0x6001C,
        /* field numbers */     1,
        /* register fields */   IO_SLEW_RATE_CONTROL3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Hardware_MISC */
        /* offset address */    0x60020,
        /* field numbers */     11,
        /* register fields */   HARDWARE_MISC_FIELDS,
        /* default value */     0x3E
    },
    {   /* register name        Debug0 */
        /* offset address */    0x60024,
        /* field numbers */     1,
        /* register fields */   DEBUG0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Debug1 */
        /* offset address */    0x60028,
        /* field numbers */     1,
        /* register fields */   DEBUG1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Internal_Bonding_Debug */
        /* offset address */    0x6002C,
        /* field numbers */     2,
        /* register fields */   INTERNAL_BONDING_DEBUG_FIELDS,
        /* default value */     0xFFFFFF
    },
    {   /* register name        Internal_Strapping_Debug0 */
        /* offset address */    0x60030,
        /* field numbers */     1,
        /* register fields */   INTERNAL_STRAPPING_DEBUG0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Internal_Strapping_Debug1 */
        /* offset address */    0x60034,
        /* field numbers */     2,
        /* register fields */   INTERNAL_STRAPPING_DEBUG1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Internal_Read */
        /* offset address */    0x60038,
        /* field numbers */     2,
        /* register fields */   INTERNAL_READ_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        BIAS_Control */
        /* offset address */    0x6003C,
        /* field numbers */     7,
        /* register fields */   BIAS_CONTROL_FIELDS,
        /* default value */     0x12492
    },
    {   /* register name        SPI_Mode_Control */
        /* offset address */    0x60040,
        /* field numbers */     4,
        /* register fields */   SPI_MODE_CONTROL_FIELDS,
        /* default value */     0x6
    },
    {   /* register name        Power_Saving_Control0 */
        /* offset address */    0x60044,
        /* field numbers */     3,
        /* register fields */   POWER_SAVING_CONTROL0_FIELDS,
        /* default value */     0xFFFFFF
    },
    {   /* register name        Power_Saving_Control1 */
        /* offset address */    0x60048,
        /* field numbers */     1,
        /* register fields */   POWER_SAVING_CONTROL1_FIELDS,
        /* default value */     0xC0000000
    },
    {   /* register name        Bist_result0 */
        /* offset address */    0x68000,
        /* field numbers */     10,
        /* register fields */   BIST_RESULT0_FIELDS,
        /* default value */     0x20109
    },
    {   /* register name        Bist_result1 */
        /* offset address */    0x68004,
        /* field numbers */     2,
        /* register fields */   BIST_RESULT1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Bist_result2 */
        /* offset address */    0x68008,
        /* field numbers */     2,
        /* register fields */   BIST_RESULT2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Bist_result3 */
        /* offset address */    0x6800C,
        /* field numbers */     2,
        /* register fields */   BIST_RESULT3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Bist_result4 */
        /* offset address */    0x68010,
        /* field numbers */     13,
        /* register fields */   BIST_RESULT4_FIELDS,
        /* default value */     0x34E01
    },
    {   /* register name        Bist_result5 */
        /* offset address */    0x68014,
        /* field numbers */     2,
        /* register fields */   BIST_RESULT5_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Bist_result6 */
        /* offset address */    0x68018,
        /* field numbers */     2,
        /* register fields */   BIST_RESULT6_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Bist_result7 */
        /* offset address */    0x6801C,
        /* field numbers */     2,
        /* register fields */   BIST_RESULT7_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Bist_result8 */
        /* offset address */    0x68020,
        /* field numbers */     2,
        /* register fields */   BIST_RESULT8_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Bist_result9 */
        /* offset address */    0x68024,
        /* field numbers */     2,
        /* register fields */   BIST_RESULT9_FIELDS,
        /* default value */     0x3FFFFFF
    },
    {   /* register name        Bist_result10 */
        /* offset address */    0x68028,
        /* field numbers */     13,
        /* register fields */   BIST_RESULT10_FIELDS,
        /* default value */     0x30000030
    },
    {   /* register name        Bist_control */
        /* offset address */    0x6802C,
        /* field numbers */     2,
        /* register fields */   BIST_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Bist_result11 */
        /* offset address */    0x68030,
        /* field numbers */     1,
        /* register fields */   BIST_RESULT11_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Model_revision_Information */
        /* offset address */    0x6FFF4,
        /* field numbers */     2,
        /* register fields */   MODEL_REVISION_INFORMATION_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Model_Name_Information_Regsiter */
        /* offset address */    0x6FFF8,
        /* field numbers */     5,
        /* register fields */   MODEL_NAME_INFORMATION_REGSITER_FIELDS,
        /* default value */     0x83250000
    },
    {   /* register name        Chip_Version_ID */
        /* offset address */    0x6FFFC,
        /* field numbers */     5,
        /* register fields */   CHIP_VERSION_ID_FIELDS,
        /* default value */     0x61260000
    },
    {   /* register name        SDS_EN_TX_RX_LOOPBACK_MODE */
        /* offset address */    0x70000,
        /* field numbers */     15,
        /* register fields */   SDS_EN_TX_RX_LOOPBACK_MODE_FIELDS,
        /* default value */     0x403
    },
    {   /* register name        sds_force_tx_rx */
        /* offset address */    0x70004,
        /* field numbers */     3,
        /* register fields */   SDS_FORCE_TX_RX_FIELDS,
        /* default value */     0xFF00
    },
    {   /* register name        sds_pcs_control_0 */
        /* offset address */    0x70008,
        /* field numbers */     6,
        /* register fields */   SDS_PCS_CONTROL_0_FIELDS,
        /* default value */     0x7000
    },
    {   /* register name        sds_pcs_control_1 */
        /* offset address */    0x7000C,
        /* field numbers */     10,
        /* register fields */   SDS_PCS_CONTROL_1_FIELDS,
        /* default value */     0x7106
    },
    {   /* register name        sds_pcs_control_2 */
        /* offset address */    0x70010,
        /* field numbers */     8,
        /* register fields */   SDS_PCS_CONTROL_2_FIELDS,
        /* default value */     0x348
    },
    {   /* register name        sds_inband_access_control */
        /* offset address */    0x70014,
        /* field numbers */     8,
        /* register fields */   SDS_INBAND_ACCESS_CONTROL_FIELDS,
        /* default value */     0xE00
    },
    {   /* register name        sds_scrambler_control_0 */
        /* offset address */    0x70018,
        /* field numbers */     3,
        /* register fields */   SDS_SCRAMBLER_CONTROL_0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        sds_scrambler_control_1 */
        /* offset address */    0x7001C,
        /* field numbers */     9,
        /* register fields */   SDS_SCRAMBLER_CONTROL_1_FIELDS,
        /* default value */     0x304
    },
    {   /* register name        sds_eee_control_0 */
        /* offset address */    0x70020,
        /* field numbers */     9,
        /* register fields */   SDS_EEE_CONTROL_0_FIELDS,
        /* default value */     0x524B
    },
    {   /* register name        sds_eee_control_1 */
        /* offset address */    0x70024,
        /* field numbers */     11,
        /* register fields */   SDS_EEE_CONTROL_1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_eee_control_2 */
        /* offset address */    0x70028,
        /* field numbers */     4,
        /* register fields */   SDS_EEE_CONTROL_2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_eee_debug_counter */
        /* offset address */    0x7002C,
        /* field numbers */     5,
        /* register fields */   SDS_EEE_DEBUG_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_auto_det_control_0 */
        /* offset address */    0x70030,
        /* field numbers */     7,
        /* register fields */   SDS_AUTO_DET_CONTROL_0_FIELDS,
        /* default value */     0xE4
    },
    {   /* register name        sds_auto_det_control_1 */
        /* offset address */    0x70034,
        /* field numbers */     3,
        /* register fields */   SDS_AUTO_DET_CONTROL_1_FIELDS,
        /* default value */     0x4664
    },
    {   /* register name        sds_auto_det_control_2 */
        /* offset address */    0x70038,
        /* field numbers */     8,
        /* register fields */   SDS_AUTO_DET_CONTROL_2_FIELDS,
        /* default value */     0x53
    },
    {   /* register name        sds_master_inband_0 */
        /* offset address */    0x7003C,
        /* field numbers */     2,
        /* register fields */   SDS_MASTER_INBAND_0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_master_inband_1 */
        /* offset address */    0x70040,
        /* field numbers */     3,
        /* register fields */   SDS_MASTER_INBAND_1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_master_inband_2 */
        /* offset address */    0x70044,
        /* field numbers */     5,
        /* register fields */   SDS_MASTER_INBAND_2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_rsgp_txcfg_phy_Reg_0 */
        /* offset address */    0x70048,
        /* field numbers */     5,
        /* register fields */   SDS_RSGP_TXCFG_PHY_REG_0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_rsgp_txcfg_phy_Reg_1 */
        /* offset address */    0x7004C,
        /* field numbers */     5,
        /* register fields */   SDS_RSGP_TXCFG_PHY_REG_1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_rsgp_txcfg_mac_Reg */
        /* offset address */    0x70050,
        /* field numbers */     2,
        /* register fields */   SDS_RSGP_TXCFG_MAC_REG_FIELDS,
        /* default value */     0x4001
    },
    {   /* register name        sds_reserved0 */
        /* offset address */    0x70054,
        /* field numbers */     2,
        /* register fields */   SDS_RESERVED0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_reserved1 */
        /* offset address */    0x70058,
        /* field numbers */     2,
        /* register fields */   SDS_RESERVED1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_reserved2 */
        /* offset address */    0x7005C,
        /* field numbers */     2,
        /* register fields */   SDS_RESERVED2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_reserved3 */
        /* offset address */    0x70060,
        /* field numbers */     2,
        /* register fields */   SDS_RESERVED3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_reserved4 */
        /* offset address */    0x70064,
        /* field numbers */     2,
        /* register fields */   SDS_RESERVED4_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_debug_output_0_for_ECO */
        /* offset address */    0x70068,
        /* field numbers */     9,
        /* register fields */   SDS_DEBUG_OUTPUT_0_FOR_ECO_FIELDS,
        /* default value */     0x1C40
    },
    {   /* register name        sds_debug_select_signal_related */
        /* offset address */    0x70070,
        /* field numbers */     5,
        /* register fields */   SDS_DEBUG_SELECT_SIGNAL_RELATED_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_debug_output_0 */
        /* offset address */    0x70074,
        /* field numbers */     2,
        /* register fields */   SDS_DEBUG_OUTPUT_0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_debug_output_1 */
        /* offset address */    0x70078,
        /* field numbers */     2,
        /* register fields */   SDS_DEBUG_OUTPUT_1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_reserved5 */
        /* offset address */    0x7007C,
        /* field numbers */     2,
        /* register fields */   SDS_RESERVED5_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_ana_rg0x */
        /* offset address */    0x70080,
        /* field numbers */     12,
        /* register fields */   SDS_ANA_RG0X_FIELDS,
        /* default value */     0x8000
    },
    {   /* register name        sds_ana_rg1x */
        /* offset address */    0x70084,
        /* field numbers */     13,
        /* register fields */   SDS_ANA_RG1X_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_ana_rg2x */
        /* offset address */    0x70088,
        /* field numbers */     7,
        /* register fields */   SDS_ANA_RG2X_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_ana_rg3x */
        /* offset address */    0x7008C,
        /* field numbers */     9,
        /* register fields */   SDS_ANA_RG3X_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_ana_rg4x */
        /* offset address */    0x70090,
        /* field numbers */     5,
        /* register fields */   SDS_ANA_RG4X_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_ana_rg5x */
        /* offset address */    0x70094,
        /* field numbers */     14,
        /* register fields */   SDS_ANA_RG5X_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_ana_rg6x */
        /* offset address */    0x70098,
        /* field numbers */     12,
        /* register fields */   SDS_ANA_RG6X_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_ana_rg7x */
        /* offset address */    0x7009C,
        /* field numbers */     11,
        /* register fields */   SDS_ANA_RG7X_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_ana_rg8x */
        /* offset address */    0x700A0,
        /* field numbers */     3,
        /* register fields */   SDS_ANA_RG8X_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_ana_rg9x */
        /* offset address */    0x700A4,
        /* field numbers */     4,
        /* register fields */   SDS_ANA_RG9X_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_ana_rg10x */
        /* offset address */    0x700A8,
        /* field numbers */     7,
        /* register fields */   SDS_ANA_RG10X_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_ana_rg11x */
        /* offset address */    0x700AC,
        /* field numbers */     8,
        /* register fields */   SDS_ANA_RG11X_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_ana_rg12x */
        /* offset address */    0x700B0,
        /* field numbers */     1,
        /* register fields */   SDS_ANA_RG12X_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_ana_rg13x */
        /* offset address */    0x700B4,
        /* field numbers */     1,
        /* register fields */   SDS_ANA_RG13X_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_ana_rg14x */
        /* offset address */    0x700B8,
        /* field numbers */     1,
        /* register fields */   SDS_ANA_RG14X_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_ana_rg15x */
        /* offset address */    0x700BC,
        /* field numbers */     1,
        /* register fields */   SDS_ANA_RG15X_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_ana_rg16x */
        /* offset address */    0x700C0,
        /* field numbers */     1,
        /* register fields */   SDS_ANA_RG16X_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_ana_rg17x */
        /* offset address */    0x700C4,
        /* field numbers */     1,
        /* register fields */   SDS_ANA_RG17X_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_ana_rg18x */
        /* offset address */    0x700C8,
        /* field numbers */     1,
        /* register fields */   SDS_ANA_RG18X_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_ana_rg19x */
        /* offset address */    0x700CC,
        /* field numbers */     1,
        /* register fields */   SDS_ANA_RG19X_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_ana_rg20x */
        /* offset address */    0x700D0,
        /* field numbers */     1,
        /* register fields */   SDS_ANA_RG20X_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_ana_rg21x */
        /* offset address */    0x700D4,
        /* field numbers */     1,
        /* register fields */   SDS_ANA_RG21X_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_ana_rg22x */
        /* offset address */    0x700D8,
        /* field numbers */     1,
        /* register fields */   SDS_ANA_RG22X_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_ana_rg23x */
        /* offset address */    0x700DC,
        /* field numbers */     1,
        /* register fields */   SDS_ANA_RG23X_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_counter_status_0 */
        /* offset address */    0x700E0,
        /* field numbers */     3,
        /* register fields */   SDS_COUNTER_STATUS_0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_couner_status_1 */
        /* offset address */    0x700E4,
        /* field numbers */     3,
        /* register fields */   SDS_COUNER_STATUS_1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_counter_status_2 */
        /* offset address */    0x700E8,
        /* field numbers */     5,
        /* register fields */   SDS_COUNTER_STATUS_2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_counter_status_3 */
        /* offset address */    0x700EC,
        /* field numbers */     5,
        /* register fields */   SDS_COUNTER_STATUS_3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_debug_output_1_for_ECO */
        /* offset address */    0x700F0,
        /* field numbers */     6,
        /* register fields */   SDS_DEBUG_OUTPUT_1_FOR_ECO_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_debug_output_2_for_ECO */
        /* offset address */    0x700F4,
        /* field numbers */     3,
        /* register fields */   SDS_DEBUG_OUTPUT_2_FOR_ECO_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_signal_sync_link_status */
        /* offset address */    0x700F8,
        /* field numbers */     3,
        /* register fields */   SDS_SIGNAL_SYNC_LINK_STATUS_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        sds_reserved6 */
        /* offset address */    0x700FC,
        /* field numbers */     2,
        /* register fields */   SDS_RESERVED6_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT0_VLAN_CONTROL */
        /* offset address */    0x880000,
        /* field numbers */     6,
        /* register fields */   PORT_VLAN_CONTROL_FIELDS,
        /* default value */     0x80010
    },
    {   /* register name        PORT1_VLAN_CONTROL */
        /* offset address */    0x880100,
        /* field numbers */     6,
        /* register fields */   PORT_VLAN_CONTROL_FIELDS,
        /* default value */     0x80010
    },
    {   /* register name        PORT2_VLAN_CONTROL */
        /* offset address */    0x880200,
        /* field numbers */     6,
        /* register fields */   PORT_VLAN_CONTROL_FIELDS,
        /* default value */     0x80010
    },
    {   /* register name        PORT3_VLAN_CONTROL */
        /* offset address */    0x880300,
        /* field numbers */     6,
        /* register fields */   PORT_VLAN_CONTROL_FIELDS,
        /* default value */     0x80010
    },
    {   /* register name        PORT4_VLAN_CONTROL */
        /* offset address */    0x880400,
        /* field numbers */     6,
        /* register fields */   PORT_VLAN_CONTROL_FIELDS,
        /* default value */     0x80010
    },
    {   /* register name        PORT5_VLAN_CONTROL */
        /* offset address */    0x880500,
        /* field numbers */     6,
        /* register fields */   PORT_VLAN_CONTROL_FIELDS,
        /* default value */     0x80010
    },
    {   /* register name        PORT6_VLAN_CONTROL */
        /* offset address */    0x880600,
        /* field numbers */     6,
        /* register fields */   PORT_VLAN_CONTROL_FIELDS,
        /* default value */     0x80010
    },
    {   /* register name        PORT7_VLAN_CONTROL */
        /* offset address */    0x880700,
        /* field numbers */     6,
        /* register fields */   PORT_VLAN_CONTROL_FIELDS,
        /* default value */     0x80010
    },
    {   /* register name        PORT8_VLAN_CONTROL */
        /* offset address */    0x880800,
        /* field numbers */     6,
        /* register fields */   PORT_VLAN_CONTROL_FIELDS,
        /* default value */     0x80010
    },
    {   /* register name        PORT9_VLAN_CONTROL */
        /* offset address */    0x880900,
        /* field numbers */     6,
        /* register fields */   PORT_VLAN_CONTROL_FIELDS,
        /* default value */     0x80010
    },
    {   /* register name        PORT10_VLAN_CONTROL */
        /* offset address */    0x880A00,
        /* field numbers */     6,
        /* register fields */   PORT_VLAN_CONTROL_FIELDS,
        /* default value */     0x80010
    },
    {   /* register name        PORT11_VLAN_CONTROL */
        /* offset address */    0x880B00,
        /* field numbers */     6,
        /* register fields */   PORT_VLAN_CONTROL_FIELDS,
        /* default value */     0x80010
    },
    {   /* register name        PORT12_VLAN_CONTROL */
        /* offset address */    0x880C00,
        /* field numbers */     6,
        /* register fields */   PORT_VLAN_CONTROL_FIELDS,
        /* default value */     0x80010
    },
    {   /* register name        PORT13_VLAN_CONTROL */
        /* offset address */    0x880D00,
        /* field numbers */     6,
        /* register fields */   PORT_VLAN_CONTROL_FIELDS,
        /* default value */     0x80010
    },
    {   /* register name        PORT14_VLAN_CONTROL */
        /* offset address */    0x880E00,
        /* field numbers */     6,
        /* register fields */   PORT_VLAN_CONTROL_FIELDS,
        /* default value */     0x80010
    },
    {   /* register name        PORT15_VLAN_CONTROL */
        /* offset address */    0x880F00,
        /* field numbers */     6,
        /* register fields */   PORT_VLAN_CONTROL_FIELDS,
        /* default value */     0x80010
    },
    {   /* register name        PORT16_VLAN_CONTROL */
        /* offset address */    0x881000,
        /* field numbers */     6,
        /* register fields */   PORT_VLAN_CONTROL_FIELDS,
        /* default value */     0x80010
    },
    {   /* register name        PORT17_VLAN_CONTROL */
        /* offset address */    0x881100,
        /* field numbers */     6,
        /* register fields */   PORT_VLAN_CONTROL_FIELDS,
        /* default value */     0x80010
    },
    {   /* register name        PORT18_VLAN_CONTROL */
        /* offset address */    0x881200,
        /* field numbers */     6,
        /* register fields */   PORT_VLAN_CONTROL_FIELDS,
        /* default value */     0x80010
    },
    {   /* register name        PORT19_VLAN_CONTROL */
        /* offset address */    0x881300,
        /* field numbers */     6,
        /* register fields */   PORT_VLAN_CONTROL_FIELDS,
        /* default value */     0x80010
    },
    {   /* register name        PORT20_VLAN_CONTROL */
        /* offset address */    0x881400,
        /* field numbers */     6,
        /* register fields */   PORT_VLAN_CONTROL_FIELDS,
        /* default value */     0x80010
    },
    {   /* register name        PORT21_VLAN_CONTROL */
        /* offset address */    0x881500,
        /* field numbers */     6,
        /* register fields */   PORT_VLAN_CONTROL_FIELDS,
        /* default value */     0x80010
    },
    {   /* register name        PORT22_VLAN_CONTROL */
        /* offset address */    0x881600,
        /* field numbers */     6,
        /* register fields */   PORT_VLAN_CONTROL_FIELDS,
        /* default value */     0x80010
    },
    {   /* register name        PORT23_VLAN_CONTROL */
        /* offset address */    0x881700,
        /* field numbers */     6,
        /* register fields */   PORT_VLAN_CONTROL_FIELDS,
        /* default value */     0x80010
    },
    {   /* register name        PORT24_VLAN_CONTROL */
        /* offset address */    0x881800,
        /* field numbers */     6,
        /* register fields */   PORT_VLAN_CONTROL_FIELDS,
        /* default value */     0x80010
    },
    {   /* register name        PORT0_ACCEPT_FRAME_TYPE_CONTROL */
        /* offset address */    0x890000,
        /* field numbers */     5,
        /* register fields */   PORT_ACCEPT_FRAME_TYPE_CONTROL_FIELDS,
        /* default value */     0xF
    },
    {   /* register name        PORT1_ACCEPT_FRAME_TYPE_CONTROL */
        /* offset address */    0x890100,
        /* field numbers */     5,
        /* register fields */   PORT_ACCEPT_FRAME_TYPE_CONTROL_FIELDS,
        /* default value */     0xF
    },
    {   /* register name        PORT2_ACCEPT_FRAME_TYPE_CONTROL */
        /* offset address */    0x890200,
        /* field numbers */     5,
        /* register fields */   PORT_ACCEPT_FRAME_TYPE_CONTROL_FIELDS,
        /* default value */     0xF
    },
    {   /* register name        PORT3_ACCEPT_FRAME_TYPE_CONTROL */
        /* offset address */    0x890300,
        /* field numbers */     5,
        /* register fields */   PORT_ACCEPT_FRAME_TYPE_CONTROL_FIELDS,
        /* default value */     0xF
    },
    {   /* register name        PORT4_ACCEPT_FRAME_TYPE_CONTROL */
        /* offset address */    0x890400,
        /* field numbers */     5,
        /* register fields */   PORT_ACCEPT_FRAME_TYPE_CONTROL_FIELDS,
        /* default value */     0xF
    },
    {   /* register name        PORT5_ACCEPT_FRAME_TYPE_CONTROL */
        /* offset address */    0x890500,
        /* field numbers */     5,
        /* register fields */   PORT_ACCEPT_FRAME_TYPE_CONTROL_FIELDS,
        /* default value */     0xF
    },
    {   /* register name        PORT6_ACCEPT_FRAME_TYPE_CONTROL */
        /* offset address */    0x890600,
        /* field numbers */     5,
        /* register fields */   PORT_ACCEPT_FRAME_TYPE_CONTROL_FIELDS,
        /* default value */     0xF
    },
    {   /* register name        PORT7_ACCEPT_FRAME_TYPE_CONTROL */
        /* offset address */    0x890700,
        /* field numbers */     5,
        /* register fields */   PORT_ACCEPT_FRAME_TYPE_CONTROL_FIELDS,
        /* default value */     0xF
    },
    {   /* register name        PORT8_ACCEPT_FRAME_TYPE_CONTROL */
        /* offset address */    0x890800,
        /* field numbers */     5,
        /* register fields */   PORT_ACCEPT_FRAME_TYPE_CONTROL_FIELDS,
        /* default value */     0xF
    },
    {   /* register name        PORT9_ACCEPT_FRAME_TYPE_CONTROL */
        /* offset address */    0x890900,
        /* field numbers */     5,
        /* register fields */   PORT_ACCEPT_FRAME_TYPE_CONTROL_FIELDS,
        /* default value */     0xF
    },
    {   /* register name        PORT10_ACCEPT_FRAME_TYPE_CONTROL */
        /* offset address */    0x890A00,
        /* field numbers */     5,
        /* register fields */   PORT_ACCEPT_FRAME_TYPE_CONTROL_FIELDS,
        /* default value */     0xF
    },
    {   /* register name        PORT11_ACCEPT_FRAME_TYPE_CONTROL */
        /* offset address */    0x890B00,
        /* field numbers */     5,
        /* register fields */   PORT_ACCEPT_FRAME_TYPE_CONTROL_FIELDS,
        /* default value */     0xF
    },
    {   /* register name        PORT12_ACCEPT_FRAME_TYPE_CONTROL */
        /* offset address */    0x890C00,
        /* field numbers */     5,
        /* register fields */   PORT_ACCEPT_FRAME_TYPE_CONTROL_FIELDS,
        /* default value */     0xF
    },
    {   /* register name        PORT13_ACCEPT_FRAME_TYPE_CONTROL */
        /* offset address */    0x890D00,
        /* field numbers */     5,
        /* register fields */   PORT_ACCEPT_FRAME_TYPE_CONTROL_FIELDS,
        /* default value */     0xF
    },
    {   /* register name        PORT14_ACCEPT_FRAME_TYPE_CONTROL */
        /* offset address */    0x890E00,
        /* field numbers */     5,
        /* register fields */   PORT_ACCEPT_FRAME_TYPE_CONTROL_FIELDS,
        /* default value */     0xF
    },
    {   /* register name        PORT15_ACCEPT_FRAME_TYPE_CONTROL */
        /* offset address */    0x890F00,
        /* field numbers */     5,
        /* register fields */   PORT_ACCEPT_FRAME_TYPE_CONTROL_FIELDS,
        /* default value */     0xF
    },
    {   /* register name        PORT16_ACCEPT_FRAME_TYPE_CONTROL */
        /* offset address */    0x891000,
        /* field numbers */     5,
        /* register fields */   PORT_ACCEPT_FRAME_TYPE_CONTROL_FIELDS,
        /* default value */     0xF
    },
    {   /* register name        PORT17_ACCEPT_FRAME_TYPE_CONTROL */
        /* offset address */    0x891100,
        /* field numbers */     5,
        /* register fields */   PORT_ACCEPT_FRAME_TYPE_CONTROL_FIELDS,
        /* default value */     0xF
    },
    {   /* register name        PORT18_ACCEPT_FRAME_TYPE_CONTROL */
        /* offset address */    0x891200,
        /* field numbers */     5,
        /* register fields */   PORT_ACCEPT_FRAME_TYPE_CONTROL_FIELDS,
        /* default value */     0xF
    },
    {   /* register name        PORT19_ACCEPT_FRAME_TYPE_CONTROL */
        /* offset address */    0x891300,
        /* field numbers */     5,
        /* register fields */   PORT_ACCEPT_FRAME_TYPE_CONTROL_FIELDS,
        /* default value */     0xF
    },
    {   /* register name        PORT20_ACCEPT_FRAME_TYPE_CONTROL */
        /* offset address */    0x891400,
        /* field numbers */     5,
        /* register fields */   PORT_ACCEPT_FRAME_TYPE_CONTROL_FIELDS,
        /* default value */     0xF
    },
    {   /* register name        PORT21_ACCEPT_FRAME_TYPE_CONTROL */
        /* offset address */    0x891500,
        /* field numbers */     5,
        /* register fields */   PORT_ACCEPT_FRAME_TYPE_CONTROL_FIELDS,
        /* default value */     0xF
    },
    {   /* register name        PORT22_ACCEPT_FRAME_TYPE_CONTROL */
        /* offset address */    0x891600,
        /* field numbers */     5,
        /* register fields */   PORT_ACCEPT_FRAME_TYPE_CONTROL_FIELDS,
        /* default value */     0xF
    },
    {   /* register name        PORT23_ACCEPT_FRAME_TYPE_CONTROL */
        /* offset address */    0x891700,
        /* field numbers */     5,
        /* register fields */   PORT_ACCEPT_FRAME_TYPE_CONTROL_FIELDS,
        /* default value */     0xF
    },
    {   /* register name        PORT24_ACCEPT_FRAME_TYPE_CONTROL */
        /* offset address */    0x891800,
        /* field numbers */     5,
        /* register fields */   PORT_ACCEPT_FRAME_TYPE_CONTROL_FIELDS,
        /* default value */     0xF
    },
    {   /* register name        PORT0_IGNORE_VLAN_TAG_CONTROL */
        /* offset address */    0x890004,
        /* field numbers */     3,
        /* register fields */   PORT_IGNORE_VLAN_TAG_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT1_IGNORE_VLAN_TAG_CONTROL */
        /* offset address */    0x890104,
        /* field numbers */     3,
        /* register fields */   PORT_IGNORE_VLAN_TAG_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT2_IGNORE_VLAN_TAG_CONTROL */
        /* offset address */    0x890204,
        /* field numbers */     3,
        /* register fields */   PORT_IGNORE_VLAN_TAG_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT3_IGNORE_VLAN_TAG_CONTROL */
        /* offset address */    0x890304,
        /* field numbers */     3,
        /* register fields */   PORT_IGNORE_VLAN_TAG_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT4_IGNORE_VLAN_TAG_CONTROL */
        /* offset address */    0x890404,
        /* field numbers */     3,
        /* register fields */   PORT_IGNORE_VLAN_TAG_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT5_IGNORE_VLAN_TAG_CONTROL */
        /* offset address */    0x890504,
        /* field numbers */     3,
        /* register fields */   PORT_IGNORE_VLAN_TAG_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT6_IGNORE_VLAN_TAG_CONTROL */
        /* offset address */    0x890604,
        /* field numbers */     3,
        /* register fields */   PORT_IGNORE_VLAN_TAG_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT7_IGNORE_VLAN_TAG_CONTROL */
        /* offset address */    0x890704,
        /* field numbers */     3,
        /* register fields */   PORT_IGNORE_VLAN_TAG_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT8_IGNORE_VLAN_TAG_CONTROL */
        /* offset address */    0x890804,
        /* field numbers */     3,
        /* register fields */   PORT_IGNORE_VLAN_TAG_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT9_IGNORE_VLAN_TAG_CONTROL */
        /* offset address */    0x890904,
        /* field numbers */     3,
        /* register fields */   PORT_IGNORE_VLAN_TAG_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT10_IGNORE_VLAN_TAG_CONTROL */
        /* offset address */    0x890A04,
        /* field numbers */     3,
        /* register fields */   PORT_IGNORE_VLAN_TAG_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT11_IGNORE_VLAN_TAG_CONTROL */
        /* offset address */    0x890B04,
        /* field numbers */     3,
        /* register fields */   PORT_IGNORE_VLAN_TAG_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT12_IGNORE_VLAN_TAG_CONTROL */
        /* offset address */    0x890C04,
        /* field numbers */     3,
        /* register fields */   PORT_IGNORE_VLAN_TAG_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT13_IGNORE_VLAN_TAG_CONTROL */
        /* offset address */    0x890D04,
        /* field numbers */     3,
        /* register fields */   PORT_IGNORE_VLAN_TAG_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT14_IGNORE_VLAN_TAG_CONTROL */
        /* offset address */    0x890E04,
        /* field numbers */     3,
        /* register fields */   PORT_IGNORE_VLAN_TAG_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT15_IGNORE_VLAN_TAG_CONTROL */
        /* offset address */    0x890F04,
        /* field numbers */     3,
        /* register fields */   PORT_IGNORE_VLAN_TAG_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT16_IGNORE_VLAN_TAG_CONTROL */
        /* offset address */    0x891004,
        /* field numbers */     3,
        /* register fields */   PORT_IGNORE_VLAN_TAG_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT17_IGNORE_VLAN_TAG_CONTROL */
        /* offset address */    0x891104,
        /* field numbers */     3,
        /* register fields */   PORT_IGNORE_VLAN_TAG_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT18_IGNORE_VLAN_TAG_CONTROL */
        /* offset address */    0x891204,
        /* field numbers */     3,
        /* register fields */   PORT_IGNORE_VLAN_TAG_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT19_IGNORE_VLAN_TAG_CONTROL */
        /* offset address */    0x891304,
        /* field numbers */     3,
        /* register fields */   PORT_IGNORE_VLAN_TAG_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT20_IGNORE_VLAN_TAG_CONTROL */
        /* offset address */    0x891404,
        /* field numbers */     3,
        /* register fields */   PORT_IGNORE_VLAN_TAG_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT21_IGNORE_VLAN_TAG_CONTROL */
        /* offset address */    0x891504,
        /* field numbers */     3,
        /* register fields */   PORT_IGNORE_VLAN_TAG_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT22_IGNORE_VLAN_TAG_CONTROL */
        /* offset address */    0x891604,
        /* field numbers */     3,
        /* register fields */   PORT_IGNORE_VLAN_TAG_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT23_IGNORE_VLAN_TAG_CONTROL */
        /* offset address */    0x891704,
        /* field numbers */     3,
        /* register fields */   PORT_IGNORE_VLAN_TAG_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT24_IGNORE_VLAN_TAG_CONTROL */
        /* offset address */    0x891804,
        /* field numbers */     3,
        /* register fields */   PORT_IGNORE_VLAN_TAG_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Inner_Tag_Priority_Map_Control0 */
        /* offset address */    0xA0000,
        /* field numbers */     9,
        /* register fields */   INNER_TAG_PRIORITY_MAP_CONTROL0_FIELDS,
        /* default value */     0xFAC681
    },
    {   /* register name        Inner_Tag_Priority_Map_Control1 */
        /* offset address */    0xA0004,
        /* field numbers */     9,
        /* register fields */   INNER_TAG_PRIORITY_MAP_CONTROL1_FIELDS,
        /* default value */     0xFAC681
    },
    {   /* register name        Outer_Tag_Priority_Map_Control0 */
        /* offset address */    0xA0008,
        /* field numbers */     9,
        /* register fields */   OUTER_TAG_PRIORITY_MAP_CONTROL0_FIELDS,
        /* default value */     0xFAC681
    },
    {   /* register name        Outer_Tag_Priority_Map_Control1 */
        /* offset address */    0xA000C,
        /* field numbers */     9,
        /* register fields */   OUTER_TAG_PRIORITY_MAP_CONTROL1_FIELDS,
        /* default value */     0xFAC681
    },
    {   /* register name        Outer_Tag_Priority_Map_Control2 */
        /* offset address */    0xA0010,
        /* field numbers */     9,
        /* register fields */   OUTER_TAG_PRIORITY_MAP_CONTROL2_FIELDS,
        /* default value */     0xFAC681
    },
    {   /* register name        Outer_Tag_Priority_Map_Control3 */
        /* offset address */    0xA0014,
        /* field numbers */     9,
        /* register fields */   OUTER_TAG_PRIORITY_MAP_CONTROL3_FIELDS,
        /* default value */     0xFAC681
    },
    {   /* register name        DSCP_Priority_Map_Control0 */
        /* offset address */    0xA0018,
        /* field numbers */     16,
        /* register fields */   DSCP_PRIORITY_MAP_CONTROL0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        DSCP_Priority_Map_Control1 */
        /* offset address */    0xA001C,
        /* field numbers */     16,
        /* register fields */   DSCP_PRIORITY_MAP_CONTROL1_FIELDS,
        /* default value */     0x11110000
    },
    {   /* register name        DSCP_Priority_Map_Control2 */
        /* offset address */    0xA0020,
        /* field numbers */     16,
        /* register fields */   DSCP_PRIORITY_MAP_CONTROL2_FIELDS,
        /* default value */     0x22222211
    },
    {   /* register name        DSCP_Priority_Map_Control3 */
        /* offset address */    0xA0024,
        /* field numbers */     16,
        /* register fields */   DSCP_PRIORITY_MAP_CONTROL3_FIELDS,
        /* default value */     0x44333333
    },
    {   /* register name        DSCP_Priority_Map_Control4 */
        /* offset address */    0xA0028,
        /* field numbers */     16,
        /* register fields */   DSCP_PRIORITY_MAP_CONTROL4_FIELDS,
        /* default value */     0x55554444
    },
    {   /* register name        DSCP_Priority_Map_Control5 */
        /* offset address */    0xA002C,
        /* field numbers */     16,
        /* register fields */   DSCP_PRIORITY_MAP_CONTROL5_FIELDS,
        /* default value */     0x55555555
    },
    {   /* register name        DSCP_Priority_Map_Control6 */
        /* offset address */    0xA0030,
        /* field numbers */     16,
        /* register fields */   DSCP_PRIORITY_MAP_CONTROL6_FIELDS,
        /* default value */     0x66666666
    },
    {   /* register name        DSCP_Priority_Map_Control7 */
        /* offset address */    0xA0034,
        /* field numbers */     16,
        /* register fields */   DSCP_PRIORITY_MAP_CONTROL7_FIELDS,
        /* default value */     0x77776666
    },
    {   /* register name        DSCP_Priority_Map_Control8 */
        /* offset address */    0xA0038,
        /* field numbers */     16,
        /* register fields */   DSCP_PRIORITY_MAP_CONTROL8_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        DSCP_Priority_Map_Control9 */
        /* offset address */    0xA003C,
        /* field numbers */     16,
        /* register fields */   DSCP_PRIORITY_MAP_CONTROL9_FIELDS,
        /* default value */     0x11110000
    },
    {   /* register name        DSCP_Priority_Map_Control10 */
        /* offset address */    0xA0040,
        /* field numbers */     16,
        /* register fields */   DSCP_PRIORITY_MAP_CONTROL10_FIELDS,
        /* default value */     0x22222211
    },
    {   /* register name        DSCP_Priority_Map_Control11 */
        /* offset address */    0xA0044,
        /* field numbers */     16,
        /* register fields */   DSCP_PRIORITY_MAP_CONTROL11_FIELDS,
        /* default value */     0x44333333
    },
    {   /* register name        DSCP_Priority_Map_Control12 */
        /* offset address */    0xA0048,
        /* field numbers */     16,
        /* register fields */   DSCP_PRIORITY_MAP_CONTROL12_FIELDS,
        /* default value */     0x55554444
    },
    {   /* register name        DSCP_Priority_Map_Control13 */
        /* offset address */    0xA004C,
        /* field numbers */     16,
        /* register fields */   DSCP_PRIORITY_MAP_CONTROL13_FIELDS,
        /* default value */     0x55555555
    },
    {   /* register name        DSCP_Priority_Map_Control14 */
        /* offset address */    0xA0050,
        /* field numbers */     16,
        /* register fields */   DSCP_PRIORITY_MAP_CONTROL14_FIELDS,
        /* default value */     0x66666666
    },
    {   /* register name        DSCP_Priority_Map_Control15 */
        /* offset address */    0xA0054,
        /* field numbers */     16,
        /* register fields */   DSCP_PRIORITY_MAP_CONTROL15_FIELDS,
        /* default value */     0x77776666
    },
    {   /* register name        Priority_Arbitration_Control0 */
        /* offset address */    0xA0058,
        /* field numbers */     6,
        /* register fields */   PRIORITY_ARBITRATION_CONTROL0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Priority_Arbitration_Control1 */
        /* offset address */    0xA005C,
        /* field numbers */     6,
        /* register fields */   PRIORITY_ARBITRATION_CONTROL1_FIELDS,
        /* default value */     0x7FFF
    },
    {   /* register name        PORT0_PRIORITY_CONTROL */
        /* offset address */    0x8A0000,
        /* field numbers */     6,
        /* register fields */   PORT_PRIORITY_CONTROL_FIELDS,
        /* default value */     0x20
    },
    {   /* register name        PORT1_PRIORITY_CONTROL */
        /* offset address */    0x8A0100,
        /* field numbers */     6,
        /* register fields */   PORT_PRIORITY_CONTROL_FIELDS,
        /* default value */     0x20
    },
    {   /* register name        PORT2_PRIORITY_CONTROL */
        /* offset address */    0x8A0200,
        /* field numbers */     6,
        /* register fields */   PORT_PRIORITY_CONTROL_FIELDS,
        /* default value */     0x20
    },
    {   /* register name        PORT3_PRIORITY_CONTROL */
        /* offset address */    0x8A0300,
        /* field numbers */     6,
        /* register fields */   PORT_PRIORITY_CONTROL_FIELDS,
        /* default value */     0x20
    },
    {   /* register name        PORT4_PRIORITY_CONTROL */
        /* offset address */    0x8A0400,
        /* field numbers */     6,
        /* register fields */   PORT_PRIORITY_CONTROL_FIELDS,
        /* default value */     0x20
    },
    {   /* register name        PORT5_PRIORITY_CONTROL */
        /* offset address */    0x8A0500,
        /* field numbers */     6,
        /* register fields */   PORT_PRIORITY_CONTROL_FIELDS,
        /* default value */     0x20
    },
    {   /* register name        PORT6_PRIORITY_CONTROL */
        /* offset address */    0x8A0600,
        /* field numbers */     6,
        /* register fields */   PORT_PRIORITY_CONTROL_FIELDS,
        /* default value */     0x20
    },
    {   /* register name        PORT7_PRIORITY_CONTROL */
        /* offset address */    0x8A0700,
        /* field numbers */     6,
        /* register fields */   PORT_PRIORITY_CONTROL_FIELDS,
        /* default value */     0x20
    },
    {   /* register name        PORT8_PRIORITY_CONTROL */
        /* offset address */    0x8A0800,
        /* field numbers */     6,
        /* register fields */   PORT_PRIORITY_CONTROL_FIELDS,
        /* default value */     0x20
    },
    {   /* register name        PORT9_PRIORITY_CONTROL */
        /* offset address */    0x8A0900,
        /* field numbers */     6,
        /* register fields */   PORT_PRIORITY_CONTROL_FIELDS,
        /* default value */     0x20
    },
    {   /* register name        PORT10_PRIORITY_CONTROL */
        /* offset address */    0x8A0A00,
        /* field numbers */     6,
        /* register fields */   PORT_PRIORITY_CONTROL_FIELDS,
        /* default value */     0x20
    },
    {   /* register name        PORT11_PRIORITY_CONTROL */
        /* offset address */    0x8A0B00,
        /* field numbers */     6,
        /* register fields */   PORT_PRIORITY_CONTROL_FIELDS,
        /* default value */     0x20
    },
    {   /* register name        PORT12_PRIORITY_CONTROL */
        /* offset address */    0x8A0C00,
        /* field numbers */     6,
        /* register fields */   PORT_PRIORITY_CONTROL_FIELDS,
        /* default value */     0x20
    },
    {   /* register name        PORT13_PRIORITY_CONTROL */
        /* offset address */    0x8A0D00,
        /* field numbers */     6,
        /* register fields */   PORT_PRIORITY_CONTROL_FIELDS,
        /* default value */     0x20
    },
    {   /* register name        PORT14_PRIORITY_CONTROL */
        /* offset address */    0x8A0E00,
        /* field numbers */     6,
        /* register fields */   PORT_PRIORITY_CONTROL_FIELDS,
        /* default value */     0x20
    },
    {   /* register name        PORT15_PRIORITY_CONTROL */
        /* offset address */    0x8A0F00,
        /* field numbers */     6,
        /* register fields */   PORT_PRIORITY_CONTROL_FIELDS,
        /* default value */     0x20
    },
    {   /* register name        PORT16_PRIORITY_CONTROL */
        /* offset address */    0x8A1000,
        /* field numbers */     6,
        /* register fields */   PORT_PRIORITY_CONTROL_FIELDS,
        /* default value */     0x20
    },
    {   /* register name        PORT17_PRIORITY_CONTROL */
        /* offset address */    0x8A1100,
        /* field numbers */     6,
        /* register fields */   PORT_PRIORITY_CONTROL_FIELDS,
        /* default value */     0x20
    },
    {   /* register name        PORT18_PRIORITY_CONTROL */
        /* offset address */    0x8A1200,
        /* field numbers */     6,
        /* register fields */   PORT_PRIORITY_CONTROL_FIELDS,
        /* default value */     0x20
    },
    {   /* register name        PORT19_PRIORITY_CONTROL */
        /* offset address */    0x8A1300,
        /* field numbers */     6,
        /* register fields */   PORT_PRIORITY_CONTROL_FIELDS,
        /* default value */     0x20
    },
    {   /* register name        PORT20_PRIORITY_CONTROL */
        /* offset address */    0x8A1400,
        /* field numbers */     6,
        /* register fields */   PORT_PRIORITY_CONTROL_FIELDS,
        /* default value */     0x20
    },
    {   /* register name        PORT21_PRIORITY_CONTROL */
        /* offset address */    0x8A1500,
        /* field numbers */     6,
        /* register fields */   PORT_PRIORITY_CONTROL_FIELDS,
        /* default value */     0x20
    },
    {   /* register name        PORT22_PRIORITY_CONTROL */
        /* offset address */    0x8A1600,
        /* field numbers */     6,
        /* register fields */   PORT_PRIORITY_CONTROL_FIELDS,
        /* default value */     0x20
    },
    {   /* register name        PORT23_PRIORITY_CONTROL */
        /* offset address */    0x8A1700,
        /* field numbers */     6,
        /* register fields */   PORT_PRIORITY_CONTROL_FIELDS,
        /* default value */     0x20
    },
    {   /* register name        PORT24_PRIORITY_CONTROL */
        /* offset address */    0x8A1800,
        /* field numbers */     6,
        /* register fields */   PORT_PRIORITY_CONTROL_FIELDS,
        /* default value */     0x20
    },
    {   /* register name        PORT0_Rx_Priority_Copy_Control */
        /* offset address */    0x8A0004,
        /* field numbers */     3,
        /* register fields */   PORT_RX_PRIORITY_COPY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT1_Rx_Priority_Copy_Control */
        /* offset address */    0x8A0104,
        /* field numbers */     3,
        /* register fields */   PORT_RX_PRIORITY_COPY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT2_Rx_Priority_Copy_Control */
        /* offset address */    0x8A0204,
        /* field numbers */     3,
        /* register fields */   PORT_RX_PRIORITY_COPY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT3_Rx_Priority_Copy_Control */
        /* offset address */    0x8A0304,
        /* field numbers */     3,
        /* register fields */   PORT_RX_PRIORITY_COPY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT4_Rx_Priority_Copy_Control */
        /* offset address */    0x8A0404,
        /* field numbers */     3,
        /* register fields */   PORT_RX_PRIORITY_COPY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT5_Rx_Priority_Copy_Control */
        /* offset address */    0x8A0504,
        /* field numbers */     3,
        /* register fields */   PORT_RX_PRIORITY_COPY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT6_Rx_Priority_Copy_Control */
        /* offset address */    0x8A0604,
        /* field numbers */     3,
        /* register fields */   PORT_RX_PRIORITY_COPY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT7_Rx_Priority_Copy_Control */
        /* offset address */    0x8A0704,
        /* field numbers */     3,
        /* register fields */   PORT_RX_PRIORITY_COPY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT8_Rx_Priority_Copy_Control */
        /* offset address */    0x8A0804,
        /* field numbers */     3,
        /* register fields */   PORT_RX_PRIORITY_COPY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT9_Rx_Priority_Copy_Control */
        /* offset address */    0x8A0904,
        /* field numbers */     3,
        /* register fields */   PORT_RX_PRIORITY_COPY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT10_Rx_Priority_Copy_Control */
        /* offset address */    0x8A0A04,
        /* field numbers */     3,
        /* register fields */   PORT_RX_PRIORITY_COPY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT11_Rx_Priority_Copy_Control */
        /* offset address */    0x8A0B04,
        /* field numbers */     3,
        /* register fields */   PORT_RX_PRIORITY_COPY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT12_Rx_Priority_Copy_Control */
        /* offset address */    0x8A0C04,
        /* field numbers */     3,
        /* register fields */   PORT_RX_PRIORITY_COPY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT13_Rx_Priority_Copy_Control */
        /* offset address */    0x8A0D04,
        /* field numbers */     3,
        /* register fields */   PORT_RX_PRIORITY_COPY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT14_Rx_Priority_Copy_Control */
        /* offset address */    0x8A0E04,
        /* field numbers */     3,
        /* register fields */   PORT_RX_PRIORITY_COPY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT15_Rx_Priority_Copy_Control */
        /* offset address */    0x8A0F04,
        /* field numbers */     3,
        /* register fields */   PORT_RX_PRIORITY_COPY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT16_Rx_Priority_Copy_Control */
        /* offset address */    0x8A1004,
        /* field numbers */     3,
        /* register fields */   PORT_RX_PRIORITY_COPY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT17_Rx_Priority_Copy_Control */
        /* offset address */    0x8A1104,
        /* field numbers */     3,
        /* register fields */   PORT_RX_PRIORITY_COPY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT18_Rx_Priority_Copy_Control */
        /* offset address */    0x8A1204,
        /* field numbers */     3,
        /* register fields */   PORT_RX_PRIORITY_COPY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT19_Rx_Priority_Copy_Control */
        /* offset address */    0x8A1304,
        /* field numbers */     3,
        /* register fields */   PORT_RX_PRIORITY_COPY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT20_Rx_Priority_Copy_Control */
        /* offset address */    0x8A1404,
        /* field numbers */     3,
        /* register fields */   PORT_RX_PRIORITY_COPY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT21_Rx_Priority_Copy_Control */
        /* offset address */    0x8A1504,
        /* field numbers */     3,
        /* register fields */   PORT_RX_PRIORITY_COPY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT22_Rx_Priority_Copy_Control */
        /* offset address */    0x8A1604,
        /* field numbers */     3,
        /* register fields */   PORT_RX_PRIORITY_COPY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT23_Rx_Priority_Copy_Control */
        /* offset address */    0x8A1704,
        /* field numbers */     3,
        /* register fields */   PORT_RX_PRIORITY_COPY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT24_Rx_Priority_Copy_Control */
        /* offset address */    0x8A1804,
        /* field numbers */     3,
        /* register fields */   PORT_RX_PRIORITY_COPY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT0_Priority_Map_to_QueueNumber_Control */
        /* offset address */    0x8A0008,
        /* field numbers */     9,
        /* register fields */   PORT_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_FIELDS,
        /* default value */     0xFA50
    },
    {   /* register name        PORT1_Priority_Map_to_QueueNumber_Control */
        /* offset address */    0x8A0108,
        /* field numbers */     9,
        /* register fields */   PORT_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_FIELDS,
        /* default value */     0xFA50
    },
    {   /* register name        PORT2_Priority_Map_to_QueueNumber_Control */
        /* offset address */    0x8A0208,
        /* field numbers */     9,
        /* register fields */   PORT_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_FIELDS,
        /* default value */     0xFA50
    },
    {   /* register name        PORT3_Priority_Map_to_QueueNumber_Control */
        /* offset address */    0x8A0308,
        /* field numbers */     9,
        /* register fields */   PORT_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_FIELDS,
        /* default value */     0xFA50
    },
    {   /* register name        PORT4_Priority_Map_to_QueueNumber_Control */
        /* offset address */    0x8A0408,
        /* field numbers */     9,
        /* register fields */   PORT_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_FIELDS,
        /* default value */     0xFA50
    },
    {   /* register name        PORT5_Priority_Map_to_QueueNumber_Control */
        /* offset address */    0x8A0508,
        /* field numbers */     9,
        /* register fields */   PORT_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_FIELDS,
        /* default value */     0xFA50
    },
    {   /* register name        PORT6_Priority_Map_to_QueueNumber_Control */
        /* offset address */    0x8A0608,
        /* field numbers */     9,
        /* register fields */   PORT_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_FIELDS,
        /* default value */     0xFA50
    },
    {   /* register name        PORT7_Priority_Map_to_QueueNumber_Control */
        /* offset address */    0x8A0708,
        /* field numbers */     9,
        /* register fields */   PORT_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_FIELDS,
        /* default value */     0xFA50
    },
    {   /* register name        PORT8_Priority_Map_to_QueueNumber_Control */
        /* offset address */    0x8A0808,
        /* field numbers */     9,
        /* register fields */   PORT_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_FIELDS,
        /* default value */     0xFA50
    },
    {   /* register name        PORT9_Priority_Map_to_QueueNumber_Control */
        /* offset address */    0x8A0908,
        /* field numbers */     9,
        /* register fields */   PORT_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_FIELDS,
        /* default value */     0xFA50
    },
    {   /* register name        PORT10_Priority_Map_to_QueueNumber_Control */
        /* offset address */    0x8A0A08,
        /* field numbers */     9,
        /* register fields */   PORT_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_FIELDS,
        /* default value */     0xFA50
    },
    {   /* register name        PORT11_Priority_Map_to_QueueNumber_Control */
        /* offset address */    0x8A0B08,
        /* field numbers */     9,
        /* register fields */   PORT_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_FIELDS,
        /* default value */     0xFA50
    },
    {   /* register name        PORT12_Priority_Map_to_QueueNumber_Control */
        /* offset address */    0x8A0C08,
        /* field numbers */     9,
        /* register fields */   PORT_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_FIELDS,
        /* default value */     0xFA50
    },
    {   /* register name        PORT13_Priority_Map_to_QueueNumber_Control */
        /* offset address */    0x8A0D08,
        /* field numbers */     9,
        /* register fields */   PORT_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_FIELDS,
        /* default value */     0xFA50
    },
    {   /* register name        PORT14_Priority_Map_to_QueueNumber_Control */
        /* offset address */    0x8A0E08,
        /* field numbers */     9,
        /* register fields */   PORT_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_FIELDS,
        /* default value */     0xFA50
    },
    {   /* register name        PORT15_Priority_Map_to_QueueNumber_Control */
        /* offset address */    0x8A0F08,
        /* field numbers */     9,
        /* register fields */   PORT_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_FIELDS,
        /* default value */     0xFA50
    },
    {   /* register name        PORT16_Priority_Map_to_QueueNumber_Control */
        /* offset address */    0x8A1008,
        /* field numbers */     9,
        /* register fields */   PORT_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_FIELDS,
        /* default value */     0xFA50
    },
    {   /* register name        PORT17_Priority_Map_to_QueueNumber_Control */
        /* offset address */    0x8A1108,
        /* field numbers */     9,
        /* register fields */   PORT_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_FIELDS,
        /* default value */     0xFA50
    },
    {   /* register name        PORT18_Priority_Map_to_QueueNumber_Control */
        /* offset address */    0x8A1208,
        /* field numbers */     9,
        /* register fields */   PORT_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_FIELDS,
        /* default value */     0xFA50
    },
    {   /* register name        PORT19_Priority_Map_to_QueueNumber_Control */
        /* offset address */    0x8A1308,
        /* field numbers */     9,
        /* register fields */   PORT_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_FIELDS,
        /* default value */     0xFA50
    },
    {   /* register name        PORT20_Priority_Map_to_QueueNumber_Control */
        /* offset address */    0x8A1408,
        /* field numbers */     9,
        /* register fields */   PORT_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_FIELDS,
        /* default value */     0xFA50
    },
    {   /* register name        PORT21_Priority_Map_to_QueueNumber_Control */
        /* offset address */    0x8A1508,
        /* field numbers */     9,
        /* register fields */   PORT_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_FIELDS,
        /* default value */     0xFA50
    },
    {   /* register name        PORT22_Priority_Map_to_QueueNumber_Control */
        /* offset address */    0x8A1608,
        /* field numbers */     9,
        /* register fields */   PORT_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_FIELDS,
        /* default value */     0xFA50
    },
    {   /* register name        PORT23_Priority_Map_to_QueueNumber_Control */
        /* offset address */    0x8A1708,
        /* field numbers */     9,
        /* register fields */   PORT_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_FIELDS,
        /* default value */     0xFA50
    },
    {   /* register name        PORT24_Priority_Map_to_QueueNumber_Control */
        /* offset address */    0x8A1808,
        /* field numbers */     9,
        /* register fields */   PORT_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_FIELDS,
        /* default value */     0xFA50
    },
    {   /* register name        VLAN_Table_Lookup_Miss_Control */
        /* offset address */    0xB0000,
        /* field numbers */     3,
        /* register fields */   VLAN_TABLE_LOOKUP_MISS_CONTROL_FIELDS,
        /* default value */     0x4
    },
    {   /* register name        Address_Lookup_Based_on_VID_or_FID_Control */
        /* offset address */    0xB0004,
        /* field numbers */     4,
        /* register fields */   ADDRESS_LOOKUP_BASED_ON_VID_OR_FID_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT0_VLAN_INGRESS_FILTER_CONTROL */
        /* offset address */    0x8B0000,
        /* field numbers */     3,
        /* register fields */   PORT_VLAN_INGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT1_VLAN_INGRESS_FILTER_CONTROL */
        /* offset address */    0x8B0100,
        /* field numbers */     3,
        /* register fields */   PORT_VLAN_INGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT2_VLAN_INGRESS_FILTER_CONTROL */
        /* offset address */    0x8B0200,
        /* field numbers */     3,
        /* register fields */   PORT_VLAN_INGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT3_VLAN_INGRESS_FILTER_CONTROL */
        /* offset address */    0x8B0300,
        /* field numbers */     3,
        /* register fields */   PORT_VLAN_INGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT4_VLAN_INGRESS_FILTER_CONTROL */
        /* offset address */    0x8B0400,
        /* field numbers */     3,
        /* register fields */   PORT_VLAN_INGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT5_VLAN_INGRESS_FILTER_CONTROL */
        /* offset address */    0x8B0500,
        /* field numbers */     3,
        /* register fields */   PORT_VLAN_INGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT6_VLAN_INGRESS_FILTER_CONTROL */
        /* offset address */    0x8B0600,
        /* field numbers */     3,
        /* register fields */   PORT_VLAN_INGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT7_VLAN_INGRESS_FILTER_CONTROL */
        /* offset address */    0x8B0700,
        /* field numbers */     3,
        /* register fields */   PORT_VLAN_INGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT8_VLAN_INGRESS_FILTER_CONTROL */
        /* offset address */    0x8B0800,
        /* field numbers */     3,
        /* register fields */   PORT_VLAN_INGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT9_VLAN_INGRESS_FILTER_CONTROL */
        /* offset address */    0x8B0900,
        /* field numbers */     3,
        /* register fields */   PORT_VLAN_INGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT10_VLAN_INGRESS_FILTER_CONTROL */
        /* offset address */    0x8B0A00,
        /* field numbers */     3,
        /* register fields */   PORT_VLAN_INGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT11_VLAN_INGRESS_FILTER_CONTROL */
        /* offset address */    0x8B0B00,
        /* field numbers */     3,
        /* register fields */   PORT_VLAN_INGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT12_VLAN_INGRESS_FILTER_CONTROL */
        /* offset address */    0x8B0C00,
        /* field numbers */     3,
        /* register fields */   PORT_VLAN_INGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT13_VLAN_INGRESS_FILTER_CONTROL */
        /* offset address */    0x8B0D00,
        /* field numbers */     3,
        /* register fields */   PORT_VLAN_INGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT14_VLAN_INGRESS_FILTER_CONTROL */
        /* offset address */    0x8B0E00,
        /* field numbers */     3,
        /* register fields */   PORT_VLAN_INGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT15_VLAN_INGRESS_FILTER_CONTROL */
        /* offset address */    0x8B0F00,
        /* field numbers */     3,
        /* register fields */   PORT_VLAN_INGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT16_VLAN_INGRESS_FILTER_CONTROL */
        /* offset address */    0x8B1000,
        /* field numbers */     3,
        /* register fields */   PORT_VLAN_INGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT17_VLAN_INGRESS_FILTER_CONTROL */
        /* offset address */    0x8B1100,
        /* field numbers */     3,
        /* register fields */   PORT_VLAN_INGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT18_VLAN_INGRESS_FILTER_CONTROL */
        /* offset address */    0x8B1200,
        /* field numbers */     3,
        /* register fields */   PORT_VLAN_INGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT19_VLAN_INGRESS_FILTER_CONTROL */
        /* offset address */    0x8B1300,
        /* field numbers */     3,
        /* register fields */   PORT_VLAN_INGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT20_VLAN_INGRESS_FILTER_CONTROL */
        /* offset address */    0x8B1400,
        /* field numbers */     3,
        /* register fields */   PORT_VLAN_INGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT21_VLAN_INGRESS_FILTER_CONTROL */
        /* offset address */    0x8B1500,
        /* field numbers */     3,
        /* register fields */   PORT_VLAN_INGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT22_VLAN_INGRESS_FILTER_CONTROL */
        /* offset address */    0x8B1600,
        /* field numbers */     3,
        /* register fields */   PORT_VLAN_INGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT23_VLAN_INGRESS_FILTER_CONTROL */
        /* offset address */    0x8B1700,
        /* field numbers */     3,
        /* register fields */   PORT_VLAN_INGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT24_VLAN_INGRESS_FILTER_CONTROL */
        /* offset address */    0x8B1800,
        /* field numbers */     3,
        /* register fields */   PORT_VLAN_INGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT0_Forwarding_TAG_Select_CONTROL */
        /* offset address */    0x8B0004,
        /* field numbers */     2,
        /* register fields */   PORT_FORWARDING_TAG_SELECT_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT1_Forwarding_TAG_Select_CONTROL */
        /* offset address */    0x8B0104,
        /* field numbers */     2,
        /* register fields */   PORT_FORWARDING_TAG_SELECT_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT2_Forwarding_TAG_Select_CONTROL */
        /* offset address */    0x8B0204,
        /* field numbers */     2,
        /* register fields */   PORT_FORWARDING_TAG_SELECT_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT3_Forwarding_TAG_Select_CONTROL */
        /* offset address */    0x8B0304,
        /* field numbers */     2,
        /* register fields */   PORT_FORWARDING_TAG_SELECT_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT4_Forwarding_TAG_Select_CONTROL */
        /* offset address */    0x8B0404,
        /* field numbers */     2,
        /* register fields */   PORT_FORWARDING_TAG_SELECT_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT5_Forwarding_TAG_Select_CONTROL */
        /* offset address */    0x8B0504,
        /* field numbers */     2,
        /* register fields */   PORT_FORWARDING_TAG_SELECT_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT6_Forwarding_TAG_Select_CONTROL */
        /* offset address */    0x8B0604,
        /* field numbers */     2,
        /* register fields */   PORT_FORWARDING_TAG_SELECT_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT7_Forwarding_TAG_Select_CONTROL */
        /* offset address */    0x8B0704,
        /* field numbers */     2,
        /* register fields */   PORT_FORWARDING_TAG_SELECT_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT8_Forwarding_TAG_Select_CONTROL */
        /* offset address */    0x8B0804,
        /* field numbers */     2,
        /* register fields */   PORT_FORWARDING_TAG_SELECT_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT9_Forwarding_TAG_Select_CONTROL */
        /* offset address */    0x8B0904,
        /* field numbers */     2,
        /* register fields */   PORT_FORWARDING_TAG_SELECT_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT10_Forwarding_TAG_Select_CONTROL */
        /* offset address */    0x8B0A04,
        /* field numbers */     2,
        /* register fields */   PORT_FORWARDING_TAG_SELECT_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT11_Forwarding_TAG_Select_CONTROL */
        /* offset address */    0x8B0B04,
        /* field numbers */     2,
        /* register fields */   PORT_FORWARDING_TAG_SELECT_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT12_Forwarding_TAG_Select_CONTROL */
        /* offset address */    0x8B0C04,
        /* field numbers */     2,
        /* register fields */   PORT_FORWARDING_TAG_SELECT_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT13_Forwarding_TAG_Select_CONTROL */
        /* offset address */    0x8B0D04,
        /* field numbers */     2,
        /* register fields */   PORT_FORWARDING_TAG_SELECT_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT14_Forwarding_TAG_Select_CONTROL */
        /* offset address */    0x8B0E04,
        /* field numbers */     2,
        /* register fields */   PORT_FORWARDING_TAG_SELECT_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT15_Forwarding_TAG_Select_CONTROL */
        /* offset address */    0x8B0F04,
        /* field numbers */     2,
        /* register fields */   PORT_FORWARDING_TAG_SELECT_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT16_Forwarding_TAG_Select_CONTROL */
        /* offset address */    0x8B1004,
        /* field numbers */     2,
        /* register fields */   PORT_FORWARDING_TAG_SELECT_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT17_Forwarding_TAG_Select_CONTROL */
        /* offset address */    0x8B1104,
        /* field numbers */     2,
        /* register fields */   PORT_FORWARDING_TAG_SELECT_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT18_Forwarding_TAG_Select_CONTROL */
        /* offset address */    0x8B1204,
        /* field numbers */     2,
        /* register fields */   PORT_FORWARDING_TAG_SELECT_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT19_Forwarding_TAG_Select_CONTROL */
        /* offset address */    0x8B1304,
        /* field numbers */     2,
        /* register fields */   PORT_FORWARDING_TAG_SELECT_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT20_Forwarding_TAG_Select_CONTROL */
        /* offset address */    0x8B1404,
        /* field numbers */     2,
        /* register fields */   PORT_FORWARDING_TAG_SELECT_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT21_Forwarding_TAG_Select_CONTROL */
        /* offset address */    0x8B1504,
        /* field numbers */     2,
        /* register fields */   PORT_FORWARDING_TAG_SELECT_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT22_Forwarding_TAG_Select_CONTROL */
        /* offset address */    0x8B1604,
        /* field numbers */     2,
        /* register fields */   PORT_FORWARDING_TAG_SELECT_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT23_Forwarding_TAG_Select_CONTROL */
        /* offset address */    0x8B1704,
        /* field numbers */     2,
        /* register fields */   PORT_FORWARDING_TAG_SELECT_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT24_Forwarding_TAG_Select_CONTROL */
        /* offset address */    0x8B1804,
        /* field numbers */     2,
        /* register fields */   PORT_FORWARDING_TAG_SELECT_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT0_EGRESS_TAG_STATUS_CONTROL */
        /* offset address */    0x8B0008,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_TAG_STATUS_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT1_EGRESS_TAG_STATUS_CONTROL */
        /* offset address */    0x8B0108,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_TAG_STATUS_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT2_EGRESS_TAG_STATUS_CONTROL */
        /* offset address */    0x8B0208,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_TAG_STATUS_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT3_EGRESS_TAG_STATUS_CONTROL */
        /* offset address */    0x8B0308,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_TAG_STATUS_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT4_EGRESS_TAG_STATUS_CONTROL */
        /* offset address */    0x8B0408,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_TAG_STATUS_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT5_EGRESS_TAG_STATUS_CONTROL */
        /* offset address */    0x8B0508,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_TAG_STATUS_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT6_EGRESS_TAG_STATUS_CONTROL */
        /* offset address */    0x8B0608,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_TAG_STATUS_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT7_EGRESS_TAG_STATUS_CONTROL */
        /* offset address */    0x8B0708,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_TAG_STATUS_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT8_EGRESS_TAG_STATUS_CONTROL */
        /* offset address */    0x8B0808,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_TAG_STATUS_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT9_EGRESS_TAG_STATUS_CONTROL */
        /* offset address */    0x8B0908,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_TAG_STATUS_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT10_EGRESS_TAG_STATUS_CONTROL */
        /* offset address */    0x8B0A08,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_TAG_STATUS_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT11_EGRESS_TAG_STATUS_CONTROL */
        /* offset address */    0x8B0B08,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_TAG_STATUS_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT12_EGRESS_TAG_STATUS_CONTROL */
        /* offset address */    0x8B0C08,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_TAG_STATUS_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT13_EGRESS_TAG_STATUS_CONTROL */
        /* offset address */    0x8B0D08,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_TAG_STATUS_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT14_EGRESS_TAG_STATUS_CONTROL */
        /* offset address */    0x8B0E08,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_TAG_STATUS_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT15_EGRESS_TAG_STATUS_CONTROL */
        /* offset address */    0x8B0F08,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_TAG_STATUS_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT16_EGRESS_TAG_STATUS_CONTROL */
        /* offset address */    0x8B1008,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_TAG_STATUS_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT17_EGRESS_TAG_STATUS_CONTROL */
        /* offset address */    0x8B1108,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_TAG_STATUS_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT18_EGRESS_TAG_STATUS_CONTROL */
        /* offset address */    0x8B1208,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_TAG_STATUS_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT19_EGRESS_TAG_STATUS_CONTROL */
        /* offset address */    0x8B1308,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_TAG_STATUS_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT20_EGRESS_TAG_STATUS_CONTROL */
        /* offset address */    0x8B1408,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_TAG_STATUS_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT21_EGRESS_TAG_STATUS_CONTROL */
        /* offset address */    0x8B1508,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_TAG_STATUS_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT22_EGRESS_TAG_STATUS_CONTROL */
        /* offset address */    0x8B1608,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_TAG_STATUS_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT23_EGRESS_TAG_STATUS_CONTROL */
        /* offset address */    0x8B1708,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_TAG_STATUS_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT24_EGRESS_TAG_STATUS_CONTROL */
        /* offset address */    0x8B1808,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_TAG_STATUS_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        PORT0_VLAN_Egress_Filter_Control */
        /* offset address */    0x8B000C,
        /* field numbers */     2,
        /* register fields */   PORT_VLAN_EGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT1_VLAN_Egress_Filter_Control */
        /* offset address */    0x8B010C,
        /* field numbers */     2,
        /* register fields */   PORT_VLAN_EGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT2_VLAN_Egress_Filter_Control */
        /* offset address */    0x8B020C,
        /* field numbers */     2,
        /* register fields */   PORT_VLAN_EGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT3_VLAN_Egress_Filter_Control */
        /* offset address */    0x8B030C,
        /* field numbers */     2,
        /* register fields */   PORT_VLAN_EGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT4_VLAN_Egress_Filter_Control */
        /* offset address */    0x8B040C,
        /* field numbers */     2,
        /* register fields */   PORT_VLAN_EGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT5_VLAN_Egress_Filter_Control */
        /* offset address */    0x8B050C,
        /* field numbers */     2,
        /* register fields */   PORT_VLAN_EGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT6_VLAN_Egress_Filter_Control */
        /* offset address */    0x8B060C,
        /* field numbers */     2,
        /* register fields */   PORT_VLAN_EGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT7_VLAN_Egress_Filter_Control */
        /* offset address */    0x8B070C,
        /* field numbers */     2,
        /* register fields */   PORT_VLAN_EGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT8_VLAN_Egress_Filter_Control */
        /* offset address */    0x8B080C,
        /* field numbers */     2,
        /* register fields */   PORT_VLAN_EGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT9_VLAN_Egress_Filter_Control */
        /* offset address */    0x8B090C,
        /* field numbers */     2,
        /* register fields */   PORT_VLAN_EGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT10_VLAN_Egress_Filter_Control */
        /* offset address */    0x8B0A0C,
        /* field numbers */     2,
        /* register fields */   PORT_VLAN_EGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT11_VLAN_Egress_Filter_Control */
        /* offset address */    0x8B0B0C,
        /* field numbers */     2,
        /* register fields */   PORT_VLAN_EGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT12_VLAN_Egress_Filter_Control */
        /* offset address */    0x8B0C0C,
        /* field numbers */     2,
        /* register fields */   PORT_VLAN_EGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT13_VLAN_Egress_Filter_Control */
        /* offset address */    0x8B0D0C,
        /* field numbers */     2,
        /* register fields */   PORT_VLAN_EGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT14_VLAN_Egress_Filter_Control */
        /* offset address */    0x8B0E0C,
        /* field numbers */     2,
        /* register fields */   PORT_VLAN_EGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT15_VLAN_Egress_Filter_Control */
        /* offset address */    0x8B0F0C,
        /* field numbers */     2,
        /* register fields */   PORT_VLAN_EGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT16_VLAN_Egress_Filter_Control */
        /* offset address */    0x8B100C,
        /* field numbers */     2,
        /* register fields */   PORT_VLAN_EGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT17_VLAN_Egress_Filter_Control */
        /* offset address */    0x8B110C,
        /* field numbers */     2,
        /* register fields */   PORT_VLAN_EGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT18_VLAN_Egress_Filter_Control */
        /* offset address */    0x8B120C,
        /* field numbers */     2,
        /* register fields */   PORT_VLAN_EGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT19_VLAN_Egress_Filter_Control */
        /* offset address */    0x8B130C,
        /* field numbers */     2,
        /* register fields */   PORT_VLAN_EGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT20_VLAN_Egress_Filter_Control */
        /* offset address */    0x8B140C,
        /* field numbers */     2,
        /* register fields */   PORT_VLAN_EGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT21_VLAN_Egress_Filter_Control */
        /* offset address */    0x8B150C,
        /* field numbers */     2,
        /* register fields */   PORT_VLAN_EGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT22_VLAN_Egress_Filter_Control */
        /* offset address */    0x8B160C,
        /* field numbers */     2,
        /* register fields */   PORT_VLAN_EGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT23_VLAN_Egress_Filter_Control */
        /* offset address */    0x8B170C,
        /* field numbers */     2,
        /* register fields */   PORT_VLAN_EGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT24_VLAN_Egress_Filter_Control */
        /* offset address */    0x8B180C,
        /* field numbers */     2,
        /* register fields */   PORT_VLAN_EGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        Global_MAC_L2_Misc0 */
        /* offset address */    0x100000,
        /* field numbers */     20,
        /* register fields */   GLOBAL_MAC_L2_MISC0_FIELDS,
        /* default value */     0x1E02
    },
    {   /* register name        Port0_L2_MISC0 */
        /* offset address */    0x900000,
        /* field numbers */     11,
        /* register fields */   PORT_L2_MISC0_FIELDS,
        /* default value */     0x477
    },
    {   /* register name        Port1_L2_MISC0 */
        /* offset address */    0x900100,
        /* field numbers */     11,
        /* register fields */   PORT_L2_MISC0_FIELDS,
        /* default value */     0x477
    },
    {   /* register name        Port2_L2_MISC0 */
        /* offset address */    0x900200,
        /* field numbers */     11,
        /* register fields */   PORT_L2_MISC0_FIELDS,
        /* default value */     0x477
    },
    {   /* register name        Port3_L2_MISC0 */
        /* offset address */    0x900300,
        /* field numbers */     11,
        /* register fields */   PORT_L2_MISC0_FIELDS,
        /* default value */     0x477
    },
    {   /* register name        Port4_L2_MISC0 */
        /* offset address */    0x900400,
        /* field numbers */     11,
        /* register fields */   PORT_L2_MISC0_FIELDS,
        /* default value */     0x477
    },
    {   /* register name        Port5_L2_MISC0 */
        /* offset address */    0x900500,
        /* field numbers */     11,
        /* register fields */   PORT_L2_MISC0_FIELDS,
        /* default value */     0x477
    },
    {   /* register name        Port6_L2_MISC0 */
        /* offset address */    0x900600,
        /* field numbers */     11,
        /* register fields */   PORT_L2_MISC0_FIELDS,
        /* default value */     0x477
    },
    {   /* register name        Port7_L2_MISC0 */
        /* offset address */    0x900700,
        /* field numbers */     11,
        /* register fields */   PORT_L2_MISC0_FIELDS,
        /* default value */     0x477
    },
    {   /* register name        Port8_L2_MISC0 */
        /* offset address */    0x900800,
        /* field numbers */     11,
        /* register fields */   PORT_L2_MISC0_FIELDS,
        /* default value */     0x477
    },
    {   /* register name        Port9_L2_MISC0 */
        /* offset address */    0x900900,
        /* field numbers */     11,
        /* register fields */   PORT_L2_MISC0_FIELDS,
        /* default value */     0x477
    },
    {   /* register name        Port10_L2_MISC0 */
        /* offset address */    0x900A00,
        /* field numbers */     11,
        /* register fields */   PORT_L2_MISC0_FIELDS,
        /* default value */     0x477
    },
    {   /* register name        Port11_L2_MISC0 */
        /* offset address */    0x900B00,
        /* field numbers */     11,
        /* register fields */   PORT_L2_MISC0_FIELDS,
        /* default value */     0x477
    },
    {   /* register name        Port12_L2_MISC0 */
        /* offset address */    0x900C00,
        /* field numbers */     11,
        /* register fields */   PORT_L2_MISC0_FIELDS,
        /* default value */     0x477
    },
    {   /* register name        Port13_L2_MISC0 */
        /* offset address */    0x900D00,
        /* field numbers */     11,
        /* register fields */   PORT_L2_MISC0_FIELDS,
        /* default value */     0x477
    },
    {   /* register name        Port14_L2_MISC0 */
        /* offset address */    0x900E00,
        /* field numbers */     11,
        /* register fields */   PORT_L2_MISC0_FIELDS,
        /* default value */     0x477
    },
    {   /* register name        Port15_L2_MISC0 */
        /* offset address */    0x900F00,
        /* field numbers */     11,
        /* register fields */   PORT_L2_MISC0_FIELDS,
        /* default value */     0x477
    },
    {   /* register name        Port16_L2_MISC0 */
        /* offset address */    0x901000,
        /* field numbers */     11,
        /* register fields */   PORT_L2_MISC0_FIELDS,
        /* default value */     0x477
    },
    {   /* register name        Port17_L2_MISC0 */
        /* offset address */    0x901100,
        /* field numbers */     11,
        /* register fields */   PORT_L2_MISC0_FIELDS,
        /* default value */     0x477
    },
    {   /* register name        Port18_L2_MISC0 */
        /* offset address */    0x901200,
        /* field numbers */     11,
        /* register fields */   PORT_L2_MISC0_FIELDS,
        /* default value */     0x477
    },
    {   /* register name        Port19_L2_MISC0 */
        /* offset address */    0x901300,
        /* field numbers */     11,
        /* register fields */   PORT_L2_MISC0_FIELDS,
        /* default value */     0x477
    },
    {   /* register name        Port20_L2_MISC0 */
        /* offset address */    0x901400,
        /* field numbers */     11,
        /* register fields */   PORT_L2_MISC0_FIELDS,
        /* default value */     0x477
    },
    {   /* register name        Port21_L2_MISC0 */
        /* offset address */    0x901500,
        /* field numbers */     11,
        /* register fields */   PORT_L2_MISC0_FIELDS,
        /* default value */     0x477
    },
    {   /* register name        Port22_L2_MISC0 */
        /* offset address */    0x901600,
        /* field numbers */     11,
        /* register fields */   PORT_L2_MISC0_FIELDS,
        /* default value */     0x477
    },
    {   /* register name        Port23_L2_MISC0 */
        /* offset address */    0x901700,
        /* field numbers */     11,
        /* register fields */   PORT_L2_MISC0_FIELDS,
        /* default value */     0x477
    },
    {   /* register name        Port24_L2_MISC0 */
        /* offset address */    0x901800,
        /* field numbers */     11,
        /* register fields */   PORT_L2_MISC0_FIELDS,
        /* default value */     0x477
    },
    {   /* register name        ADDRESS_TABLE_LOOKUP_CONTROL */
        /* offset address */    0x110000,
        /* field numbers */     9,
        /* register fields */   ADDRESS_TABLE_LOOKUP_CONTROL_FIELDS,
        /* default value */     0x400
    },
    {   /* register name        ADDRESS_TABLE_LOOKUP_MISS_CONTROL */
        /* offset address */    0x110004,
        /* field numbers */     10,
        /* register fields */   ADDRESS_TABLE_LOOKUP_MISS_CONTROL_FIELDS,
        /* default value */     0x202AA
    },
    {   /* register name        ADDRESS_TABLE_MULTICAST_CONTROL0 */
        /* offset address */    0x110008,
        /* field numbers */     2,
        /* register fields */   ADDRESS_TABLE_MULTICAST_CONTROL0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        ADDRESS_TABLE_MULTICAST_CONTROL1 */
        /* offset address */    0x11000C,
        /* field numbers */     2,
        /* register fields */   ADDRESS_TABLE_MULTICAST_CONTROL1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT0_SOURCE_PORT_FILTER */
        /* offset address */    0x910000,
        /* field numbers */     2,
        /* register fields */   PORT_SOURCE_PORT_FILTER_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT1_SOURCE_PORT_FILTER */
        /* offset address */    0x910100,
        /* field numbers */     2,
        /* register fields */   PORT_SOURCE_PORT_FILTER_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT2_SOURCE_PORT_FILTER */
        /* offset address */    0x910200,
        /* field numbers */     2,
        /* register fields */   PORT_SOURCE_PORT_FILTER_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT3_SOURCE_PORT_FILTER */
        /* offset address */    0x910300,
        /* field numbers */     2,
        /* register fields */   PORT_SOURCE_PORT_FILTER_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT4_SOURCE_PORT_FILTER */
        /* offset address */    0x910400,
        /* field numbers */     2,
        /* register fields */   PORT_SOURCE_PORT_FILTER_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT5_SOURCE_PORT_FILTER */
        /* offset address */    0x910500,
        /* field numbers */     2,
        /* register fields */   PORT_SOURCE_PORT_FILTER_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT6_SOURCE_PORT_FILTER */
        /* offset address */    0x910600,
        /* field numbers */     2,
        /* register fields */   PORT_SOURCE_PORT_FILTER_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT7_SOURCE_PORT_FILTER */
        /* offset address */    0x910700,
        /* field numbers */     2,
        /* register fields */   PORT_SOURCE_PORT_FILTER_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT8_SOURCE_PORT_FILTER */
        /* offset address */    0x910800,
        /* field numbers */     2,
        /* register fields */   PORT_SOURCE_PORT_FILTER_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT9_SOURCE_PORT_FILTER */
        /* offset address */    0x910900,
        /* field numbers */     2,
        /* register fields */   PORT_SOURCE_PORT_FILTER_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT10_SOURCE_PORT_FILTER */
        /* offset address */    0x910A00,
        /* field numbers */     2,
        /* register fields */   PORT_SOURCE_PORT_FILTER_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT11_SOURCE_PORT_FILTER */
        /* offset address */    0x910B00,
        /* field numbers */     2,
        /* register fields */   PORT_SOURCE_PORT_FILTER_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT12_SOURCE_PORT_FILTER */
        /* offset address */    0x910C00,
        /* field numbers */     2,
        /* register fields */   PORT_SOURCE_PORT_FILTER_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT13_SOURCE_PORT_FILTER */
        /* offset address */    0x910D00,
        /* field numbers */     2,
        /* register fields */   PORT_SOURCE_PORT_FILTER_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT14_SOURCE_PORT_FILTER */
        /* offset address */    0x910E00,
        /* field numbers */     2,
        /* register fields */   PORT_SOURCE_PORT_FILTER_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT15_SOURCE_PORT_FILTER */
        /* offset address */    0x910F00,
        /* field numbers */     2,
        /* register fields */   PORT_SOURCE_PORT_FILTER_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT16_SOURCE_PORT_FILTER */
        /* offset address */    0x911000,
        /* field numbers */     2,
        /* register fields */   PORT_SOURCE_PORT_FILTER_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT17_SOURCE_PORT_FILTER */
        /* offset address */    0x911100,
        /* field numbers */     2,
        /* register fields */   PORT_SOURCE_PORT_FILTER_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT18_SOURCE_PORT_FILTER */
        /* offset address */    0x911200,
        /* field numbers */     2,
        /* register fields */   PORT_SOURCE_PORT_FILTER_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT19_SOURCE_PORT_FILTER */
        /* offset address */    0x911300,
        /* field numbers */     2,
        /* register fields */   PORT_SOURCE_PORT_FILTER_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT20_SOURCE_PORT_FILTER */
        /* offset address */    0x911400,
        /* field numbers */     2,
        /* register fields */   PORT_SOURCE_PORT_FILTER_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT21_SOURCE_PORT_FILTER */
        /* offset address */    0x911500,
        /* field numbers */     2,
        /* register fields */   PORT_SOURCE_PORT_FILTER_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT22_SOURCE_PORT_FILTER */
        /* offset address */    0x911600,
        /* field numbers */     2,
        /* register fields */   PORT_SOURCE_PORT_FILTER_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT23_SOURCE_PORT_FILTER */
        /* offset address */    0x911700,
        /* field numbers */     2,
        /* register fields */   PORT_SOURCE_PORT_FILTER_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT24_SOURCE_PORT_FILTER */
        /* offset address */    0x911800,
        /* field numbers */     2,
        /* register fields */   PORT_SOURCE_PORT_FILTER_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        Spanning_Tree_Port_State_Control0A */
        /* offset address */    0x120000,
        /* field numbers */     16,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL0A_FIELDS,
        /* default value */     0xFFFFFFFF
    },
    {   /* register name        Spanning_Tree_Port_State_Control0B */
        /* offset address */    0x120004,
        /* field numbers */     10,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL0B_FIELDS,
        /* default value */     0x3FFFF
    },
    {   /* register name        Spanning_Tree_Port_State_Control1A */
        /* offset address */    0x120008,
        /* field numbers */     16,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL1A_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control1B */
        /* offset address */    0x12000C,
        /* field numbers */     10,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL1B_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control2A */
        /* offset address */    0x120010,
        /* field numbers */     16,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL2A_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control2B */
        /* offset address */    0x120014,
        /* field numbers */     10,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL2B_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control3A */
        /* offset address */    0x120018,
        /* field numbers */     16,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL3A_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control3B */
        /* offset address */    0x12001C,
        /* field numbers */     10,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL3B_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control4A */
        /* offset address */    0x120020,
        /* field numbers */     16,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL4A_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control4B */
        /* offset address */    0x120024,
        /* field numbers */     10,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL4B_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control5A */
        /* offset address */    0x120028,
        /* field numbers */     16,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL5A_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control5B */
        /* offset address */    0x12002C,
        /* field numbers */     10,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL5B_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control6A */
        /* offset address */    0x120030,
        /* field numbers */     16,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL6A_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control6B */
        /* offset address */    0x120034,
        /* field numbers */     10,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL6B_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control7A */
        /* offset address */    0x120038,
        /* field numbers */     16,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL7A_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control7B */
        /* offset address */    0x12003C,
        /* field numbers */     10,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL7B_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control8A */
        /* offset address */    0x120040,
        /* field numbers */     16,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL8A_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control8B */
        /* offset address */    0x120044,
        /* field numbers */     10,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL8B_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control9A */
        /* offset address */    0x120048,
        /* field numbers */     16,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL9A_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control9B */
        /* offset address */    0x12004C,
        /* field numbers */     10,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL9B_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control10A */
        /* offset address */    0x120050,
        /* field numbers */     16,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL10A_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control10B */
        /* offset address */    0x120054,
        /* field numbers */     10,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL10B_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control11A */
        /* offset address */    0x120058,
        /* field numbers */     16,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL11A_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control11B */
        /* offset address */    0x12005C,
        /* field numbers */     10,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL11B_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control12A */
        /* offset address */    0x120060,
        /* field numbers */     16,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL12A_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control12B */
        /* offset address */    0x120064,
        /* field numbers */     10,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL12B_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control13A */
        /* offset address */    0x120068,
        /* field numbers */     16,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL13A_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control13B */
        /* offset address */    0x12006C,
        /* field numbers */     10,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL13B_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control14A */
        /* offset address */    0x120070,
        /* field numbers */     16,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL14A_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control14B */
        /* offset address */    0x120074,
        /* field numbers */     10,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL14B_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control15A */
        /* offset address */    0x120078,
        /* field numbers */     16,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL15A_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control15B */
        /* offset address */    0x12007C,
        /* field numbers */     10,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL15B_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control16A */
        /* offset address */    0x120080,
        /* field numbers */     16,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL16A_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control16B */
        /* offset address */    0x120084,
        /* field numbers */     10,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL16B_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control17A */
        /* offset address */    0x120088,
        /* field numbers */     16,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL17A_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control17B */
        /* offset address */    0x12008C,
        /* field numbers */     10,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL17B_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control18A */
        /* offset address */    0x120090,
        /* field numbers */     16,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL18A_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control18B */
        /* offset address */    0x120094,
        /* field numbers */     10,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL18B_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control19A */
        /* offset address */    0x120098,
        /* field numbers */     16,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL19A_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control19B */
        /* offset address */    0x12009C,
        /* field numbers */     10,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL19B_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control20A */
        /* offset address */    0x1200A0,
        /* field numbers */     16,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL20A_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control20B */
        /* offset address */    0x1200A4,
        /* field numbers */     10,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL20B_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control21A */
        /* offset address */    0x1200A8,
        /* field numbers */     16,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL21A_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control21B */
        /* offset address */    0x1200AC,
        /* field numbers */     10,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL21B_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control22A */
        /* offset address */    0x1200B0,
        /* field numbers */     16,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL22A_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control22B */
        /* offset address */    0x1200B4,
        /* field numbers */     10,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL22B_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control23A */
        /* offset address */    0x1200B8,
        /* field numbers */     16,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL23A_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control23B */
        /* offset address */    0x1200BC,
        /* field numbers */     10,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL23B_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control24A */
        /* offset address */    0x1200C0,
        /* field numbers */     16,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL24A_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control24B */
        /* offset address */    0x1200C4,
        /* field numbers */     10,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL24B_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control25A */
        /* offset address */    0x1200C8,
        /* field numbers */     16,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL25A_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control25B */
        /* offset address */    0x1200CC,
        /* field numbers */     10,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL25B_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control26A */
        /* offset address */    0x1200D0,
        /* field numbers */     16,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL26A_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control26B */
        /* offset address */    0x1200D4,
        /* field numbers */     10,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL26B_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control27A */
        /* offset address */    0x1200D8,
        /* field numbers */     16,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL27A_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control27B */
        /* offset address */    0x1200DC,
        /* field numbers */     10,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL27B_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control28A */
        /* offset address */    0x1200E0,
        /* field numbers */     16,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL28A_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control28B */
        /* offset address */    0x1200E4,
        /* field numbers */     10,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL28B_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control29A */
        /* offset address */    0x1200E8,
        /* field numbers */     16,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL29A_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control29B */
        /* offset address */    0x1200EC,
        /* field numbers */     10,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL29B_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control30A */
        /* offset address */    0x1200F0,
        /* field numbers */     16,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL30A_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control30B */
        /* offset address */    0x1200F4,
        /* field numbers */     10,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL30B_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control31A */
        /* offset address */    0x1200F8,
        /* field numbers */     16,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL31A_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Spanning_Tree_Port_State_Control31B */
        /* offset address */    0x1200FC,
        /* field numbers */     10,
        /* register fields */   SPANNING_TREE_PORT_STATE_CONTROL31B_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        SOURCE_MAC_LEARNING_CONTROL */
        /* offset address */    0x130000,
        /* field numbers */     11,
        /* register fields */   SOURCE_MAC_LEARNING_CONTROL_FIELDS,
        /* default value */     0x20100FA
    },
    {   /* register name        ADDRESS_TABLE_Operate_CONTROL0 */
        /* offset address */    0x130004,
        /* field numbers */     7,
        /* register fields */   ADDRESS_TABLE_OPERATE_CONTROL0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        ADDRESS_TABLE_Operate_CONTROL1 */
        /* offset address */    0x130008,
        /* field numbers */     3,
        /* register fields */   ADDRESS_TABLE_OPERATE_CONTROL1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        ADDRESS_TABLE_Operate_CONTROL2 */
        /* offset address */    0x13000C,
        /* field numbers */     1,
        /* register fields */   ADDRESS_TABLE_OPERATE_CONTROL2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        ADDRESS_TABLE_Operate_CONTROL3 */
        /* offset address */    0x130010,
        /* field numbers */     5,
        /* register fields */   ADDRESS_TABLE_OPERATE_CONTROL3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT0_MAC_ADDRESS_LEARNING_CONTROL */
        /* offset address */    0x930000,
        /* field numbers */     4,
        /* register fields */   PORT_MAC_ADDRESS_LEARNING_CONTROL_FIELDS,
        /* default value */     0x7FFFFFC
    },
    {   /* register name        PORT1_MAC_ADDRESS_LEARNING_CONTROL */
        /* offset address */    0x930100,
        /* field numbers */     4,
        /* register fields */   PORT_MAC_ADDRESS_LEARNING_CONTROL_FIELDS,
        /* default value */     0x7FFFFFC
    },
    {   /* register name        PORT2_MAC_ADDRESS_LEARNING_CONTROL */
        /* offset address */    0x930200,
        /* field numbers */     4,
        /* register fields */   PORT_MAC_ADDRESS_LEARNING_CONTROL_FIELDS,
        /* default value */     0x7FFFFFC
    },
    {   /* register name        PORT3_MAC_ADDRESS_LEARNING_CONTROL */
        /* offset address */    0x930300,
        /* field numbers */     4,
        /* register fields */   PORT_MAC_ADDRESS_LEARNING_CONTROL_FIELDS,
        /* default value */     0x7FFFFFC
    },
    {   /* register name        PORT4_MAC_ADDRESS_LEARNING_CONTROL */
        /* offset address */    0x930400,
        /* field numbers */     4,
        /* register fields */   PORT_MAC_ADDRESS_LEARNING_CONTROL_FIELDS,
        /* default value */     0x7FFFFFC
    },
    {   /* register name        PORT5_MAC_ADDRESS_LEARNING_CONTROL */
        /* offset address */    0x930500,
        /* field numbers */     4,
        /* register fields */   PORT_MAC_ADDRESS_LEARNING_CONTROL_FIELDS,
        /* default value */     0x7FFFFFC
    },
    {   /* register name        PORT6_MAC_ADDRESS_LEARNING_CONTROL */
        /* offset address */    0x930600,
        /* field numbers */     4,
        /* register fields */   PORT_MAC_ADDRESS_LEARNING_CONTROL_FIELDS,
        /* default value */     0x7FFFFFC
    },
    {   /* register name        PORT7_MAC_ADDRESS_LEARNING_CONTROL */
        /* offset address */    0x930700,
        /* field numbers */     4,
        /* register fields */   PORT_MAC_ADDRESS_LEARNING_CONTROL_FIELDS,
        /* default value */     0x7FFFFFC
    },
    {   /* register name        PORT8_MAC_ADDRESS_LEARNING_CONTROL */
        /* offset address */    0x930800,
        /* field numbers */     4,
        /* register fields */   PORT_MAC_ADDRESS_LEARNING_CONTROL_FIELDS,
        /* default value */     0x7FFFFFC
    },
    {   /* register name        PORT9_MAC_ADDRESS_LEARNING_CONTROL */
        /* offset address */    0x930900,
        /* field numbers */     4,
        /* register fields */   PORT_MAC_ADDRESS_LEARNING_CONTROL_FIELDS,
        /* default value */     0x7FFFFFC
    },
    {   /* register name        PORT10_MAC_ADDRESS_LEARNING_CONTROL */
        /* offset address */    0x930A00,
        /* field numbers */     4,
        /* register fields */   PORT_MAC_ADDRESS_LEARNING_CONTROL_FIELDS,
        /* default value */     0x7FFFFFC
    },
    {   /* register name        PORT11_MAC_ADDRESS_LEARNING_CONTROL */
        /* offset address */    0x930B00,
        /* field numbers */     4,
        /* register fields */   PORT_MAC_ADDRESS_LEARNING_CONTROL_FIELDS,
        /* default value */     0x7FFFFFC
    },
    {   /* register name        PORT12_MAC_ADDRESS_LEARNING_CONTROL */
        /* offset address */    0x930C00,
        /* field numbers */     4,
        /* register fields */   PORT_MAC_ADDRESS_LEARNING_CONTROL_FIELDS,
        /* default value */     0x7FFFFFC
    },
    {   /* register name        PORT13_MAC_ADDRESS_LEARNING_CONTROL */
        /* offset address */    0x930D00,
        /* field numbers */     4,
        /* register fields */   PORT_MAC_ADDRESS_LEARNING_CONTROL_FIELDS,
        /* default value */     0x7FFFFFC
    },
    {   /* register name        PORT14_MAC_ADDRESS_LEARNING_CONTROL */
        /* offset address */    0x930E00,
        /* field numbers */     4,
        /* register fields */   PORT_MAC_ADDRESS_LEARNING_CONTROL_FIELDS,
        /* default value */     0x7FFFFFC
    },
    {   /* register name        PORT15_MAC_ADDRESS_LEARNING_CONTROL */
        /* offset address */    0x930F00,
        /* field numbers */     4,
        /* register fields */   PORT_MAC_ADDRESS_LEARNING_CONTROL_FIELDS,
        /* default value */     0x7FFFFFC
    },
    {   /* register name        PORT16_MAC_ADDRESS_LEARNING_CONTROL */
        /* offset address */    0x931000,
        /* field numbers */     4,
        /* register fields */   PORT_MAC_ADDRESS_LEARNING_CONTROL_FIELDS,
        /* default value */     0x7FFFFFC
    },
    {   /* register name        PORT17_MAC_ADDRESS_LEARNING_CONTROL */
        /* offset address */    0x931100,
        /* field numbers */     4,
        /* register fields */   PORT_MAC_ADDRESS_LEARNING_CONTROL_FIELDS,
        /* default value */     0x7FFFFFC
    },
    {   /* register name        PORT18_MAC_ADDRESS_LEARNING_CONTROL */
        /* offset address */    0x931200,
        /* field numbers */     4,
        /* register fields */   PORT_MAC_ADDRESS_LEARNING_CONTROL_FIELDS,
        /* default value */     0x7FFFFFC
    },
    {   /* register name        PORT19_MAC_ADDRESS_LEARNING_CONTROL */
        /* offset address */    0x931300,
        /* field numbers */     4,
        /* register fields */   PORT_MAC_ADDRESS_LEARNING_CONTROL_FIELDS,
        /* default value */     0x7FFFFFC
    },
    {   /* register name        PORT20_MAC_ADDRESS_LEARNING_CONTROL */
        /* offset address */    0x931400,
        /* field numbers */     4,
        /* register fields */   PORT_MAC_ADDRESS_LEARNING_CONTROL_FIELDS,
        /* default value */     0x7FFFFFC
    },
    {   /* register name        PORT21_MAC_ADDRESS_LEARNING_CONTROL */
        /* offset address */    0x931500,
        /* field numbers */     4,
        /* register fields */   PORT_MAC_ADDRESS_LEARNING_CONTROL_FIELDS,
        /* default value */     0x7FFFFFC
    },
    {   /* register name        PORT22_MAC_ADDRESS_LEARNING_CONTROL */
        /* offset address */    0x931600,
        /* field numbers */     4,
        /* register fields */   PORT_MAC_ADDRESS_LEARNING_CONTROL_FIELDS,
        /* default value */     0x7FFFFFC
    },
    {   /* register name        PORT23_MAC_ADDRESS_LEARNING_CONTROL */
        /* offset address */    0x931700,
        /* field numbers */     4,
        /* register fields */   PORT_MAC_ADDRESS_LEARNING_CONTROL_FIELDS,
        /* default value */     0x7FFFFFC
    },
    {   /* register name        PORT24_MAC_ADDRESS_LEARNING_CONTROL */
        /* offset address */    0x931800,
        /* field numbers */     4,
        /* register fields */   PORT_MAC_ADDRESS_LEARNING_CONTROL_FIELDS,
        /* default value */     0x7FFFFFC
    },
    {   /* register name        Guest_VLAN_Global_Control */
        /* offset address */    0x140000,
        /* field numbers */     7,
        /* register fields */   GUEST_VLAN_GLOBAL_CONTROL_FIELDS,
        /* default value */     0x600
    },
    {   /* register name        Dot1X_Network_Access_Related_Control */
        /* offset address */    0x140004,
        /* field numbers */     3,
        /* register fields */   DOT1X_NETWORK_ACCESS_RELATED_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port0_Based_Dot1X_Control */
        /* offset address */    0x940000,
        /* field numbers */     3,
        /* register fields */   PORT_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port1_Based_Dot1X_Control */
        /* offset address */    0x940100,
        /* field numbers */     3,
        /* register fields */   PORT_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port2_Based_Dot1X_Control */
        /* offset address */    0x940200,
        /* field numbers */     3,
        /* register fields */   PORT_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port3_Based_Dot1X_Control */
        /* offset address */    0x940300,
        /* field numbers */     3,
        /* register fields */   PORT_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port4_Based_Dot1X_Control */
        /* offset address */    0x940400,
        /* field numbers */     3,
        /* register fields */   PORT_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port5_Based_Dot1X_Control */
        /* offset address */    0x940500,
        /* field numbers */     3,
        /* register fields */   PORT_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port6_Based_Dot1X_Control */
        /* offset address */    0x940600,
        /* field numbers */     3,
        /* register fields */   PORT_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port7_Based_Dot1X_Control */
        /* offset address */    0x940700,
        /* field numbers */     3,
        /* register fields */   PORT_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port8_Based_Dot1X_Control */
        /* offset address */    0x940800,
        /* field numbers */     3,
        /* register fields */   PORT_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port9_Based_Dot1X_Control */
        /* offset address */    0x940900,
        /* field numbers */     3,
        /* register fields */   PORT_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port10_Based_Dot1X_Control */
        /* offset address */    0x940A00,
        /* field numbers */     3,
        /* register fields */   PORT_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port11_Based_Dot1X_Control */
        /* offset address */    0x940B00,
        /* field numbers */     3,
        /* register fields */   PORT_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port12_Based_Dot1X_Control */
        /* offset address */    0x940C00,
        /* field numbers */     3,
        /* register fields */   PORT_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port13_Based_Dot1X_Control */
        /* offset address */    0x940D00,
        /* field numbers */     3,
        /* register fields */   PORT_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port14_Based_Dot1X_Control */
        /* offset address */    0x940E00,
        /* field numbers */     3,
        /* register fields */   PORT_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port15_Based_Dot1X_Control */
        /* offset address */    0x940F00,
        /* field numbers */     3,
        /* register fields */   PORT_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port16_Based_Dot1X_Control */
        /* offset address */    0x941000,
        /* field numbers */     3,
        /* register fields */   PORT_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port17_Based_Dot1X_Control */
        /* offset address */    0x941100,
        /* field numbers */     3,
        /* register fields */   PORT_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port18_Based_Dot1X_Control */
        /* offset address */    0x941200,
        /* field numbers */     3,
        /* register fields */   PORT_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port19_Based_Dot1X_Control */
        /* offset address */    0x941300,
        /* field numbers */     3,
        /* register fields */   PORT_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port20_Based_Dot1X_Control */
        /* offset address */    0x941400,
        /* field numbers */     3,
        /* register fields */   PORT_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port21_Based_Dot1X_Control */
        /* offset address */    0x941500,
        /* field numbers */     3,
        /* register fields */   PORT_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port22_Based_Dot1X_Control */
        /* offset address */    0x941600,
        /* field numbers */     3,
        /* register fields */   PORT_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port23_Based_Dot1X_Control */
        /* offset address */    0x941700,
        /* field numbers */     3,
        /* register fields */   PORT_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port24_Based_Dot1X_Control */
        /* offset address */    0x941800,
        /* field numbers */     3,
        /* register fields */   PORT_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port0_Egress_Dot1X_Control */
        /* offset address */    0x940004,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port1_Egress_Dot1X_Control */
        /* offset address */    0x940104,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port2_Egress_Dot1X_Control */
        /* offset address */    0x940204,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port3_Egress_Dot1X_Control */
        /* offset address */    0x940304,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port4_Egress_Dot1X_Control */
        /* offset address */    0x940404,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port5_Egress_Dot1X_Control */
        /* offset address */    0x940504,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port6_Egress_Dot1X_Control */
        /* offset address */    0x940604,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port7_Egress_Dot1X_Control */
        /* offset address */    0x940704,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port8_Egress_Dot1X_Control */
        /* offset address */    0x940804,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port9_Egress_Dot1X_Control */
        /* offset address */    0x940904,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port10_Egress_Dot1X_Control */
        /* offset address */    0x940A04,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port11_Egress_Dot1X_Control */
        /* offset address */    0x940B04,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port12_Egress_Dot1X_Control */
        /* offset address */    0x940C04,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port13_Egress_Dot1X_Control */
        /* offset address */    0x940D04,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port14_Egress_Dot1X_Control */
        /* offset address */    0x940E04,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port15_Egress_Dot1X_Control */
        /* offset address */    0x940F04,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port16_Egress_Dot1X_Control */
        /* offset address */    0x941004,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port17_Egress_Dot1X_Control */
        /* offset address */    0x941104,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port18_Egress_Dot1X_Control */
        /* offset address */    0x941204,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port19_Egress_Dot1X_Control */
        /* offset address */    0x941304,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port20_Egress_Dot1X_Control */
        /* offset address */    0x941404,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port21_Egress_Dot1X_Control */
        /* offset address */    0x941504,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port22_Egress_Dot1X_Control */
        /* offset address */    0x941604,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port23_Egress_Dot1X_Control */
        /* offset address */    0x941704,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port24_Egress_Dot1X_Control */
        /* offset address */    0x941804,
        /* field numbers */     2,
        /* register fields */   PORT_EGRESS_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port0_MAC_Based_Dot1X_Control */
        /* offset address */    0x940008,
        /* field numbers */     2,
        /* register fields */   PORT_MAC_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port1_MAC_Based_Dot1X_Control */
        /* offset address */    0x940108,
        /* field numbers */     2,
        /* register fields */   PORT_MAC_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port2_MAC_Based_Dot1X_Control */
        /* offset address */    0x940208,
        /* field numbers */     2,
        /* register fields */   PORT_MAC_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port3_MAC_Based_Dot1X_Control */
        /* offset address */    0x940308,
        /* field numbers */     2,
        /* register fields */   PORT_MAC_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port4_MAC_Based_Dot1X_Control */
        /* offset address */    0x940408,
        /* field numbers */     2,
        /* register fields */   PORT_MAC_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port5_MAC_Based_Dot1X_Control */
        /* offset address */    0x940508,
        /* field numbers */     2,
        /* register fields */   PORT_MAC_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port6_MAC_Based_Dot1X_Control */
        /* offset address */    0x940608,
        /* field numbers */     2,
        /* register fields */   PORT_MAC_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port7_MAC_Based_Dot1X_Control */
        /* offset address */    0x940708,
        /* field numbers */     2,
        /* register fields */   PORT_MAC_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port8_MAC_Based_Dot1X_Control */
        /* offset address */    0x940808,
        /* field numbers */     2,
        /* register fields */   PORT_MAC_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port9_MAC_Based_Dot1X_Control */
        /* offset address */    0x940908,
        /* field numbers */     2,
        /* register fields */   PORT_MAC_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port10_MAC_Based_Dot1X_Control */
        /* offset address */    0x940A08,
        /* field numbers */     2,
        /* register fields */   PORT_MAC_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port11_MAC_Based_Dot1X_Control */
        /* offset address */    0x940B08,
        /* field numbers */     2,
        /* register fields */   PORT_MAC_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port12_MAC_Based_Dot1X_Control */
        /* offset address */    0x940C08,
        /* field numbers */     2,
        /* register fields */   PORT_MAC_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port13_MAC_Based_Dot1X_Control */
        /* offset address */    0x940D08,
        /* field numbers */     2,
        /* register fields */   PORT_MAC_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port14_MAC_Based_Dot1X_Control */
        /* offset address */    0x940E08,
        /* field numbers */     2,
        /* register fields */   PORT_MAC_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port15_MAC_Based_Dot1X_Control */
        /* offset address */    0x940F08,
        /* field numbers */     2,
        /* register fields */   PORT_MAC_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port16_MAC_Based_Dot1X_Control */
        /* offset address */    0x941008,
        /* field numbers */     2,
        /* register fields */   PORT_MAC_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port17_MAC_Based_Dot1X_Control */
        /* offset address */    0x941108,
        /* field numbers */     2,
        /* register fields */   PORT_MAC_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port18_MAC_Based_Dot1X_Control */
        /* offset address */    0x941208,
        /* field numbers */     2,
        /* register fields */   PORT_MAC_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port19_MAC_Based_Dot1X_Control */
        /* offset address */    0x941308,
        /* field numbers */     2,
        /* register fields */   PORT_MAC_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port20_MAC_Based_Dot1X_Control */
        /* offset address */    0x941408,
        /* field numbers */     2,
        /* register fields */   PORT_MAC_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port21_MAC_Based_Dot1X_Control */
        /* offset address */    0x941508,
        /* field numbers */     2,
        /* register fields */   PORT_MAC_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port22_MAC_Based_Dot1X_Control */
        /* offset address */    0x941608,
        /* field numbers */     2,
        /* register fields */   PORT_MAC_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port23_MAC_Based_Dot1X_Control */
        /* offset address */    0x941708,
        /* field numbers */     2,
        /* register fields */   PORT_MAC_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port24_MAC_Based_Dot1X_Control */
        /* offset address */    0x941808,
        /* field numbers */     2,
        /* register fields */   PORT_MAC_BASED_DOT1X_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        MAC_Address_Number_Constrain_Control */
        /* offset address */    0x150000,
        /* field numbers */     2,
        /* register fields */   MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL_FIELDS,
        /* default value */     0x2
    },
    {   /* register name        PORT0_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0 */
        /* offset address */    0x950000,
        /* field numbers */     5,
        /* register fields */   PORT_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_FIELDS,
        /* default value */     0x20000000
    },
    {   /* register name        PORT1_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0 */
        /* offset address */    0x950100,
        /* field numbers */     5,
        /* register fields */   PORT_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_FIELDS,
        /* default value */     0x20000000
    },
    {   /* register name        PORT2_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0 */
        /* offset address */    0x950200,
        /* field numbers */     5,
        /* register fields */   PORT_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_FIELDS,
        /* default value */     0x20000000
    },
    {   /* register name        PORT3_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0 */
        /* offset address */    0x950300,
        /* field numbers */     5,
        /* register fields */   PORT_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_FIELDS,
        /* default value */     0x20000000
    },
    {   /* register name        PORT4_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0 */
        /* offset address */    0x950400,
        /* field numbers */     5,
        /* register fields */   PORT_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_FIELDS,
        /* default value */     0x20000000
    },
    {   /* register name        PORT5_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0 */
        /* offset address */    0x950500,
        /* field numbers */     5,
        /* register fields */   PORT_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_FIELDS,
        /* default value */     0x20000000
    },
    {   /* register name        PORT6_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0 */
        /* offset address */    0x950600,
        /* field numbers */     5,
        /* register fields */   PORT_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_FIELDS,
        /* default value */     0x20000000
    },
    {   /* register name        PORT7_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0 */
        /* offset address */    0x950700,
        /* field numbers */     5,
        /* register fields */   PORT_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_FIELDS,
        /* default value */     0x20000000
    },
    {   /* register name        PORT8_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0 */
        /* offset address */    0x950800,
        /* field numbers */     5,
        /* register fields */   PORT_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_FIELDS,
        /* default value */     0x20000000
    },
    {   /* register name        PORT9_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0 */
        /* offset address */    0x950900,
        /* field numbers */     5,
        /* register fields */   PORT_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_FIELDS,
        /* default value */     0x20000000
    },
    {   /* register name        PORT10_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0 */
        /* offset address */    0x950A00,
        /* field numbers */     5,
        /* register fields */   PORT_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_FIELDS,
        /* default value */     0x20000000
    },
    {   /* register name        PORT11_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0 */
        /* offset address */    0x950B00,
        /* field numbers */     5,
        /* register fields */   PORT_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_FIELDS,
        /* default value */     0x20000000
    },
    {   /* register name        PORT12_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0 */
        /* offset address */    0x950C00,
        /* field numbers */     5,
        /* register fields */   PORT_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_FIELDS,
        /* default value */     0x20000000
    },
    {   /* register name        PORT13_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0 */
        /* offset address */    0x950D00,
        /* field numbers */     5,
        /* register fields */   PORT_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_FIELDS,
        /* default value */     0x20000000
    },
    {   /* register name        PORT14_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0 */
        /* offset address */    0x950E00,
        /* field numbers */     5,
        /* register fields */   PORT_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_FIELDS,
        /* default value */     0x20000000
    },
    {   /* register name        PORT15_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0 */
        /* offset address */    0x950F00,
        /* field numbers */     5,
        /* register fields */   PORT_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_FIELDS,
        /* default value */     0x20000000
    },
    {   /* register name        PORT16_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0 */
        /* offset address */    0x951000,
        /* field numbers */     5,
        /* register fields */   PORT_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_FIELDS,
        /* default value */     0x20000000
    },
    {   /* register name        PORT17_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0 */
        /* offset address */    0x951100,
        /* field numbers */     5,
        /* register fields */   PORT_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_FIELDS,
        /* default value */     0x20000000
    },
    {   /* register name        PORT18_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0 */
        /* offset address */    0x951200,
        /* field numbers */     5,
        /* register fields */   PORT_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_FIELDS,
        /* default value */     0x20000000
    },
    {   /* register name        PORT19_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0 */
        /* offset address */    0x951300,
        /* field numbers */     5,
        /* register fields */   PORT_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_FIELDS,
        /* default value */     0x20000000
    },
    {   /* register name        PORT20_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0 */
        /* offset address */    0x951400,
        /* field numbers */     5,
        /* register fields */   PORT_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_FIELDS,
        /* default value */     0x20000000
    },
    {   /* register name        PORT21_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0 */
        /* offset address */    0x951500,
        /* field numbers */     5,
        /* register fields */   PORT_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_FIELDS,
        /* default value */     0x20000000
    },
    {   /* register name        PORT22_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0 */
        /* offset address */    0x951600,
        /* field numbers */     5,
        /* register fields */   PORT_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_FIELDS,
        /* default value */     0x20000000
    },
    {   /* register name        PORT23_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0 */
        /* offset address */    0x951700,
        /* field numbers */     5,
        /* register fields */   PORT_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_FIELDS,
        /* default value */     0x20000000
    },
    {   /* register name        PORT24_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0 */
        /* offset address */    0x951800,
        /* field numbers */     5,
        /* register fields */   PORT_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_FIELDS,
        /* default value */     0x20000000
    },
    {   /* register name        Attack_Prevention_Global_Control */
        /* offset address */    0x160000,
        /* field numbers */     16,
        /* register fields */   ATTACK_PREVENTION_GLOBAL_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        DoS_LENGTH_Global_Control0 */
        /* offset address */    0x160004,
        /* field numbers */     2,
        /* register fields */   DOS_LENGTH_GLOBAL_CONTROL0_FIELDS,
        /* default value */     0x200
    },
    {   /* register name        DoS_LENGTH_Global_Control1 */
        /* offset address */    0x160008,
        /* field numbers */     3,
        /* register fields */   DOS_LENGTH_GLOBAL_CONTROL1_FIELDS,
        /* default value */     0x298
    },
    {   /* register name        TRAFFSTORM_Suppression_GLOBAL0 */
        /* offset address */    0x170000,
        /* field numbers */     3,
        /* register fields */   TRAFFSTORM_SUPPRESSION_GLOBAL0_FIELDS,
        /* default value */     0x154BF
    },
    {   /* register name        TRAFFSTORM_Suppression_GLOBAL1 */
        /* offset address */    0x170004,
        /* field numbers */     2,
        /* register fields */   TRAFFSTORM_SUPPRESSION_GLOBAL1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT0_Traffic_Storm_Control0 */
        /* offset address */    0x970000,
        /* field numbers */     8,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL0_FIELDS,
        /* default value */     0x100080
    },
    {   /* register name        PORT1_Traffic_Storm_Control0 */
        /* offset address */    0x970100,
        /* field numbers */     8,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL0_FIELDS,
        /* default value */     0x100080
    },
    {   /* register name        PORT2_Traffic_Storm_Control0 */
        /* offset address */    0x970200,
        /* field numbers */     8,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL0_FIELDS,
        /* default value */     0x100080
    },
    {   /* register name        PORT3_Traffic_Storm_Control0 */
        /* offset address */    0x970300,
        /* field numbers */     8,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL0_FIELDS,
        /* default value */     0x100080
    },
    {   /* register name        PORT4_Traffic_Storm_Control0 */
        /* offset address */    0x970400,
        /* field numbers */     8,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL0_FIELDS,
        /* default value */     0x100080
    },
    {   /* register name        PORT5_Traffic_Storm_Control0 */
        /* offset address */    0x970500,
        /* field numbers */     8,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL0_FIELDS,
        /* default value */     0x100080
    },
    {   /* register name        PORT6_Traffic_Storm_Control0 */
        /* offset address */    0x970600,
        /* field numbers */     8,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL0_FIELDS,
        /* default value */     0x100080
    },
    {   /* register name        PORT7_Traffic_Storm_Control0 */
        /* offset address */    0x970700,
        /* field numbers */     8,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL0_FIELDS,
        /* default value */     0x100080
    },
    {   /* register name        PORT8_Traffic_Storm_Control0 */
        /* offset address */    0x970800,
        /* field numbers */     8,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL0_FIELDS,
        /* default value */     0x100080
    },
    {   /* register name        PORT9_Traffic_Storm_Control0 */
        /* offset address */    0x970900,
        /* field numbers */     8,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL0_FIELDS,
        /* default value */     0x100080
    },
    {   /* register name        PORT10_Traffic_Storm_Control0 */
        /* offset address */    0x970A00,
        /* field numbers */     8,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL0_FIELDS,
        /* default value */     0x100080
    },
    {   /* register name        PORT11_Traffic_Storm_Control0 */
        /* offset address */    0x970B00,
        /* field numbers */     8,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL0_FIELDS,
        /* default value */     0x100080
    },
    {   /* register name        PORT12_Traffic_Storm_Control0 */
        /* offset address */    0x970C00,
        /* field numbers */     8,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL0_FIELDS,
        /* default value */     0x100080
    },
    {   /* register name        PORT13_Traffic_Storm_Control0 */
        /* offset address */    0x970D00,
        /* field numbers */     8,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL0_FIELDS,
        /* default value */     0x100080
    },
    {   /* register name        PORT14_Traffic_Storm_Control0 */
        /* offset address */    0x970E00,
        /* field numbers */     8,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL0_FIELDS,
        /* default value */     0x100080
    },
    {   /* register name        PORT15_Traffic_Storm_Control0 */
        /* offset address */    0x970F00,
        /* field numbers */     8,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL0_FIELDS,
        /* default value */     0x100080
    },
    {   /* register name        PORT16_Traffic_Storm_Control0 */
        /* offset address */    0x971000,
        /* field numbers */     8,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL0_FIELDS,
        /* default value */     0x100080
    },
    {   /* register name        PORT17_Traffic_Storm_Control0 */
        /* offset address */    0x971100,
        /* field numbers */     8,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL0_FIELDS,
        /* default value */     0x100080
    },
    {   /* register name        PORT18_Traffic_Storm_Control0 */
        /* offset address */    0x971200,
        /* field numbers */     8,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL0_FIELDS,
        /* default value */     0x100080
    },
    {   /* register name        PORT19_Traffic_Storm_Control0 */
        /* offset address */    0x971300,
        /* field numbers */     8,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL0_FIELDS,
        /* default value */     0x100080
    },
    {   /* register name        PORT20_Traffic_Storm_Control0 */
        /* offset address */    0x971400,
        /* field numbers */     8,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL0_FIELDS,
        /* default value */     0x100080
    },
    {   /* register name        PORT21_Traffic_Storm_Control0 */
        /* offset address */    0x971500,
        /* field numbers */     8,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL0_FIELDS,
        /* default value */     0x100080
    },
    {   /* register name        PORT22_Traffic_Storm_Control0 */
        /* offset address */    0x971600,
        /* field numbers */     8,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL0_FIELDS,
        /* default value */     0x100080
    },
    {   /* register name        PORT23_Traffic_Storm_Control0 */
        /* offset address */    0x971700,
        /* field numbers */     8,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL0_FIELDS,
        /* default value */     0x100080
    },
    {   /* register name        PORT24_Traffic_Storm_Control0 */
        /* offset address */    0x971800,
        /* field numbers */     8,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL0_FIELDS,
        /* default value */     0x100080
    },
    {   /* register name        PORT0_Traffic_Storm_Control1 */
        /* offset address */    0x970004,
        /* field numbers */     2,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL1_FIELDS,
        /* default value */     0x2000
    },
    {   /* register name        PORT1_Traffic_Storm_Control1 */
        /* offset address */    0x970104,
        /* field numbers */     2,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL1_FIELDS,
        /* default value */     0x2000
    },
    {   /* register name        PORT2_Traffic_Storm_Control1 */
        /* offset address */    0x970204,
        /* field numbers */     2,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL1_FIELDS,
        /* default value */     0x2000
    },
    {   /* register name        PORT3_Traffic_Storm_Control1 */
        /* offset address */    0x970304,
        /* field numbers */     2,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL1_FIELDS,
        /* default value */     0x2000
    },
    {   /* register name        PORT4_Traffic_Storm_Control1 */
        /* offset address */    0x970404,
        /* field numbers */     2,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL1_FIELDS,
        /* default value */     0x2000
    },
    {   /* register name        PORT5_Traffic_Storm_Control1 */
        /* offset address */    0x970504,
        /* field numbers */     2,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL1_FIELDS,
        /* default value */     0x2000
    },
    {   /* register name        PORT6_Traffic_Storm_Control1 */
        /* offset address */    0x970604,
        /* field numbers */     2,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL1_FIELDS,
        /* default value */     0x2000
    },
    {   /* register name        PORT7_Traffic_Storm_Control1 */
        /* offset address */    0x970704,
        /* field numbers */     2,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL1_FIELDS,
        /* default value */     0x2000
    },
    {   /* register name        PORT8_Traffic_Storm_Control1 */
        /* offset address */    0x970804,
        /* field numbers */     2,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL1_FIELDS,
        /* default value */     0x2000
    },
    {   /* register name        PORT9_Traffic_Storm_Control1 */
        /* offset address */    0x970904,
        /* field numbers */     2,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL1_FIELDS,
        /* default value */     0x2000
    },
    {   /* register name        PORT10_Traffic_Storm_Control1 */
        /* offset address */    0x970A04,
        /* field numbers */     2,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL1_FIELDS,
        /* default value */     0x2000
    },
    {   /* register name        PORT11_Traffic_Storm_Control1 */
        /* offset address */    0x970B04,
        /* field numbers */     2,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL1_FIELDS,
        /* default value */     0x2000
    },
    {   /* register name        PORT12_Traffic_Storm_Control1 */
        /* offset address */    0x970C04,
        /* field numbers */     2,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL1_FIELDS,
        /* default value */     0x2000
    },
    {   /* register name        PORT13_Traffic_Storm_Control1 */
        /* offset address */    0x970D04,
        /* field numbers */     2,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL1_FIELDS,
        /* default value */     0x2000
    },
    {   /* register name        PORT14_Traffic_Storm_Control1 */
        /* offset address */    0x970E04,
        /* field numbers */     2,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL1_FIELDS,
        /* default value */     0x2000
    },
    {   /* register name        PORT15_Traffic_Storm_Control1 */
        /* offset address */    0x970F04,
        /* field numbers */     2,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL1_FIELDS,
        /* default value */     0x2000
    },
    {   /* register name        PORT16_Traffic_Storm_Control1 */
        /* offset address */    0x971004,
        /* field numbers */     2,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL1_FIELDS,
        /* default value */     0x2000
    },
    {   /* register name        PORT17_Traffic_Storm_Control1 */
        /* offset address */    0x971104,
        /* field numbers */     2,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL1_FIELDS,
        /* default value */     0x2000
    },
    {   /* register name        PORT18_Traffic_Storm_Control1 */
        /* offset address */    0x971204,
        /* field numbers */     2,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL1_FIELDS,
        /* default value */     0x2000
    },
    {   /* register name        PORT19_Traffic_Storm_Control1 */
        /* offset address */    0x971304,
        /* field numbers */     2,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL1_FIELDS,
        /* default value */     0x2000
    },
    {   /* register name        PORT20_Traffic_Storm_Control1 */
        /* offset address */    0x971404,
        /* field numbers */     2,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL1_FIELDS,
        /* default value */     0x2000
    },
    {   /* register name        PORT21_Traffic_Storm_Control1 */
        /* offset address */    0x971504,
        /* field numbers */     2,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL1_FIELDS,
        /* default value */     0x2000
    },
    {   /* register name        PORT22_Traffic_Storm_Control1 */
        /* offset address */    0x971604,
        /* field numbers */     2,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL1_FIELDS,
        /* default value */     0x2000
    },
    {   /* register name        PORT23_Traffic_Storm_Control1 */
        /* offset address */    0x971704,
        /* field numbers */     2,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL1_FIELDS,
        /* default value */     0x2000
    },
    {   /* register name        PORT24_Traffic_Storm_Control1 */
        /* offset address */    0x971804,
        /* field numbers */     2,
        /* register fields */   PORT_TRAFFIC_STORM_CONTROL1_FIELDS,
        /* default value */     0x2000
    },
    {   /* register name        PORT_ISOLATION_CONTROL */
        /* offset address */    0x180000,
        /* field numbers */     2,
        /* register fields */   PORT_ISOLATION_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        CPU_ISOLATION_CONTROL */
        /* offset address */    0x180004,
        /* field numbers */     3,
        /* register fields */   CPU_ISOLATION_CONTROL_FIELDS,
        /* default value */     0x2
    },
    {   /* register name        Global_EEE_MAC_Control0 */
        /* offset address */    0x1B0000,
        /* field numbers */     5,
        /* register fields */   GLOBAL_EEE_MAC_CONTROL0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Global_EEE_MAC_Control1 */
        /* offset address */    0x1B0004,
        /* field numbers */     4,
        /* register fields */   GLOBAL_EEE_MAC_CONTROL1_FIELDS,
        /* default value */     0x2464C80A
    },
    {   /* register name        Global_EEE_MAC_Control2 */
        /* offset address */    0x1B0008,
        /* field numbers */     3,
        /* register fields */   GLOBAL_EEE_MAC_CONTROL2_FIELDS,
        /* default value */     0xD
    },
    {   /* register name        Global_EEE_MAC_Control3 */
        /* offset address */    0x1B000C,
        /* field numbers */     4,
        /* register fields */   GLOBAL_EEE_MAC_CONTROL3_FIELDS,
        /* default value */     0x20A1402
    },
    {   /* register name        Global_EEE_MAC_Control4 */
        /* offset address */    0x1B0010,
        /* field numbers */     3,
        /* register fields */   GLOBAL_EEE_MAC_CONTROL4_FIELDS,
        /* default value */     0xD
    },
    {   /* register name        EEE_dmy0 */
        /* offset address */    0x1B0014,
        /* field numbers */     1,
        /* register fields */   EEE_DMY0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        EEE_dmy1 */
        /* offset address */    0x1B0018,
        /* field numbers */     1,
        /* register fields */   EEE_DMY1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        EEE_dmy2 */
        /* offset address */    0x1B001C,
        /* field numbers */     1,
        /* register fields */   EEE_DMY2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        EEE_dmy3 */
        /* offset address */    0x1B0020,
        /* field numbers */     1,
        /* register fields */   EEE_DMY3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT0_EEE_MAC_Control */
        /* offset address */    0x9B0000,
        /* field numbers */     12,
        /* register fields */   PORT_EEE_MAC_CONTROL_FIELDS,
        /* default value */     0x691800
    },
    {   /* register name        PORT1_EEE_MAC_Control */
        /* offset address */    0x9B0100,
        /* field numbers */     12,
        /* register fields */   PORT_EEE_MAC_CONTROL_FIELDS,
        /* default value */     0x691800
    },
    {   /* register name        PORT2_EEE_MAC_Control */
        /* offset address */    0x9B0200,
        /* field numbers */     12,
        /* register fields */   PORT_EEE_MAC_CONTROL_FIELDS,
        /* default value */     0x691800
    },
    {   /* register name        PORT3_EEE_MAC_Control */
        /* offset address */    0x9B0300,
        /* field numbers */     12,
        /* register fields */   PORT_EEE_MAC_CONTROL_FIELDS,
        /* default value */     0x691800
    },
    {   /* register name        PORT4_EEE_MAC_Control */
        /* offset address */    0x9B0400,
        /* field numbers */     12,
        /* register fields */   PORT_EEE_MAC_CONTROL_FIELDS,
        /* default value */     0x691800
    },
    {   /* register name        PORT5_EEE_MAC_Control */
        /* offset address */    0x9B0500,
        /* field numbers */     12,
        /* register fields */   PORT_EEE_MAC_CONTROL_FIELDS,
        /* default value */     0x691800
    },
    {   /* register name        PORT6_EEE_MAC_Control */
        /* offset address */    0x9B0600,
        /* field numbers */     12,
        /* register fields */   PORT_EEE_MAC_CONTROL_FIELDS,
        /* default value */     0x691800
    },
    {   /* register name        PORT7_EEE_MAC_Control */
        /* offset address */    0x9B0700,
        /* field numbers */     12,
        /* register fields */   PORT_EEE_MAC_CONTROL_FIELDS,
        /* default value */     0x691800
    },
    {   /* register name        PORT8_EEE_MAC_Control */
        /* offset address */    0x9B0800,
        /* field numbers */     12,
        /* register fields */   PORT_EEE_MAC_CONTROL_FIELDS,
        /* default value */     0x691800
    },
    {   /* register name        PORT9_EEE_MAC_Control */
        /* offset address */    0x9B0900,
        /* field numbers */     12,
        /* register fields */   PORT_EEE_MAC_CONTROL_FIELDS,
        /* default value */     0x691800
    },
    {   /* register name        PORT10_EEE_MAC_Control */
        /* offset address */    0x9B0A00,
        /* field numbers */     12,
        /* register fields */   PORT_EEE_MAC_CONTROL_FIELDS,
        /* default value */     0x691800
    },
    {   /* register name        PORT11_EEE_MAC_Control */
        /* offset address */    0x9B0B00,
        /* field numbers */     12,
        /* register fields */   PORT_EEE_MAC_CONTROL_FIELDS,
        /* default value */     0x691800
    },
    {   /* register name        PORT12_EEE_MAC_Control */
        /* offset address */    0x9B0C00,
        /* field numbers */     12,
        /* register fields */   PORT_EEE_MAC_CONTROL_FIELDS,
        /* default value */     0x691800
    },
    {   /* register name        PORT13_EEE_MAC_Control */
        /* offset address */    0x9B0D00,
        /* field numbers */     12,
        /* register fields */   PORT_EEE_MAC_CONTROL_FIELDS,
        /* default value */     0x691800
    },
    {   /* register name        PORT14_EEE_MAC_Control */
        /* offset address */    0x9B0E00,
        /* field numbers */     12,
        /* register fields */   PORT_EEE_MAC_CONTROL_FIELDS,
        /* default value */     0x691800
    },
    {   /* register name        PORT15_EEE_MAC_Control */
        /* offset address */    0x9B0F00,
        /* field numbers */     12,
        /* register fields */   PORT_EEE_MAC_CONTROL_FIELDS,
        /* default value */     0x691800
    },
    {   /* register name        PORT16_EEE_MAC_Control */
        /* offset address */    0x9B1000,
        /* field numbers */     12,
        /* register fields */   PORT_EEE_MAC_CONTROL_FIELDS,
        /* default value */     0x691800
    },
    {   /* register name        PORT17_EEE_MAC_Control */
        /* offset address */    0x9B1100,
        /* field numbers */     12,
        /* register fields */   PORT_EEE_MAC_CONTROL_FIELDS,
        /* default value */     0x691800
    },
    {   /* register name        PORT18_EEE_MAC_Control */
        /* offset address */    0x9B1200,
        /* field numbers */     12,
        /* register fields */   PORT_EEE_MAC_CONTROL_FIELDS,
        /* default value */     0x691800
    },
    {   /* register name        PORT19_EEE_MAC_Control */
        /* offset address */    0x9B1300,
        /* field numbers */     12,
        /* register fields */   PORT_EEE_MAC_CONTROL_FIELDS,
        /* default value */     0x691800
    },
    {   /* register name        PORT20_EEE_MAC_Control */
        /* offset address */    0x9B1400,
        /* field numbers */     12,
        /* register fields */   PORT_EEE_MAC_CONTROL_FIELDS,
        /* default value */     0x691800
    },
    {   /* register name        PORT21_EEE_MAC_Control */
        /* offset address */    0x9B1500,
        /* field numbers */     12,
        /* register fields */   PORT_EEE_MAC_CONTROL_FIELDS,
        /* default value */     0x691800
    },
    {   /* register name        PORT22_EEE_MAC_Control */
        /* offset address */    0x9B1600,
        /* field numbers */     12,
        /* register fields */   PORT_EEE_MAC_CONTROL_FIELDS,
        /* default value */     0x691800
    },
    {   /* register name        PORT23_EEE_MAC_Control */
        /* offset address */    0x9B1700,
        /* field numbers */     12,
        /* register fields */   PORT_EEE_MAC_CONTROL_FIELDS,
        /* default value */     0x691800
    },
    {   /* register name        PORT24_EEE_MAC_Control */
        /* offset address */    0x9B1800,
        /* field numbers */     12,
        /* register fields */   PORT_EEE_MAC_CONTROL_FIELDS,
        /* default value */     0x691800
    },
    {   /* register name        Port0_LPI_indication_counter0 */
        /* offset address */    0x9B0004,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port1_LPI_indication_counter0 */
        /* offset address */    0x9B0104,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port2_LPI_indication_counter0 */
        /* offset address */    0x9B0204,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port3_LPI_indication_counter0 */
        /* offset address */    0x9B0304,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port4_LPI_indication_counter0 */
        /* offset address */    0x9B0404,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port5_LPI_indication_counter0 */
        /* offset address */    0x9B0504,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port6_LPI_indication_counter0 */
        /* offset address */    0x9B0604,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port7_LPI_indication_counter0 */
        /* offset address */    0x9B0704,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port8_LPI_indication_counter0 */
        /* offset address */    0x9B0804,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port9_LPI_indication_counter0 */
        /* offset address */    0x9B0904,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port10_LPI_indication_counter0 */
        /* offset address */    0x9B0A04,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port11_LPI_indication_counter0 */
        /* offset address */    0x9B0B04,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port12_LPI_indication_counter0 */
        /* offset address */    0x9B0C04,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port13_LPI_indication_counter0 */
        /* offset address */    0x9B0D04,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port14_LPI_indication_counter0 */
        /* offset address */    0x9B0E04,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port15_LPI_indication_counter0 */
        /* offset address */    0x9B0F04,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port16_LPI_indication_counter0 */
        /* offset address */    0x9B1004,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port17_LPI_indication_counter0 */
        /* offset address */    0x9B1104,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port18_LPI_indication_counter0 */
        /* offset address */    0x9B1204,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port19_LPI_indication_counter0 */
        /* offset address */    0x9B1304,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port20_LPI_indication_counter0 */
        /* offset address */    0x9B1404,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port21_LPI_indication_counter0 */
        /* offset address */    0x9B1504,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port22_LPI_indication_counter0 */
        /* offset address */    0x9B1604,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port23_LPI_indication_counter0 */
        /* offset address */    0x9B1704,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port24_LPI_indication_counter0 */
        /* offset address */    0x9B1804,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port0_LPI_indication_counter1 */
        /* offset address */    0x9B0008,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port1_LPI_indication_counter1 */
        /* offset address */    0x9B0108,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port2_LPI_indication_counter1 */
        /* offset address */    0x9B0208,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port3_LPI_indication_counter1 */
        /* offset address */    0x9B0308,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port4_LPI_indication_counter1 */
        /* offset address */    0x9B0408,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port5_LPI_indication_counter1 */
        /* offset address */    0x9B0508,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port6_LPI_indication_counter1 */
        /* offset address */    0x9B0608,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port7_LPI_indication_counter1 */
        /* offset address */    0x9B0708,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port8_LPI_indication_counter1 */
        /* offset address */    0x9B0808,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port9_LPI_indication_counter1 */
        /* offset address */    0x9B0908,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port10_LPI_indication_counter1 */
        /* offset address */    0x9B0A08,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port11_LPI_indication_counter1 */
        /* offset address */    0x9B0B08,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port12_LPI_indication_counter1 */
        /* offset address */    0x9B0C08,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port13_LPI_indication_counter1 */
        /* offset address */    0x9B0D08,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port14_LPI_indication_counter1 */
        /* offset address */    0x9B0E08,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port15_LPI_indication_counter1 */
        /* offset address */    0x9B0F08,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port16_LPI_indication_counter1 */
        /* offset address */    0x9B1008,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port17_LPI_indication_counter1 */
        /* offset address */    0x9B1108,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port18_LPI_indication_counter1 */
        /* offset address */    0x9B1208,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port19_LPI_indication_counter1 */
        /* offset address */    0x9B1308,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port20_LPI_indication_counter1 */
        /* offset address */    0x9B1408,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port21_LPI_indication_counter1 */
        /* offset address */    0x9B1508,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port22_LPI_indication_counter1 */
        /* offset address */    0x9B1608,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port23_LPI_indication_counter1 */
        /* offset address */    0x9B1708,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port24_LPI_indication_counter1 */
        /* offset address */    0x9B1808,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port0_LPI_indication_counter2 */
        /* offset address */    0x9B000C,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port1_LPI_indication_counter2 */
        /* offset address */    0x9B010C,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port2_LPI_indication_counter2 */
        /* offset address */    0x9B020C,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port3_LPI_indication_counter2 */
        /* offset address */    0x9B030C,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port4_LPI_indication_counter2 */
        /* offset address */    0x9B040C,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port5_LPI_indication_counter2 */
        /* offset address */    0x9B050C,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port6_LPI_indication_counter2 */
        /* offset address */    0x9B060C,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port7_LPI_indication_counter2 */
        /* offset address */    0x9B070C,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port8_LPI_indication_counter2 */
        /* offset address */    0x9B080C,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port9_LPI_indication_counter2 */
        /* offset address */    0x9B090C,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port10_LPI_indication_counter2 */
        /* offset address */    0x9B0A0C,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port11_LPI_indication_counter2 */
        /* offset address */    0x9B0B0C,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port12_LPI_indication_counter2 */
        /* offset address */    0x9B0C0C,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port13_LPI_indication_counter2 */
        /* offset address */    0x9B0D0C,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port14_LPI_indication_counter2 */
        /* offset address */    0x9B0E0C,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port15_LPI_indication_counter2 */
        /* offset address */    0x9B0F0C,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port16_LPI_indication_counter2 */
        /* offset address */    0x9B100C,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port17_LPI_indication_counter2 */
        /* offset address */    0x9B110C,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port18_LPI_indication_counter2 */
        /* offset address */    0x9B120C,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port19_LPI_indication_counter2 */
        /* offset address */    0x9B130C,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port20_LPI_indication_counter2 */
        /* offset address */    0x9B140C,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port21_LPI_indication_counter2 */
        /* offset address */    0x9B150C,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port22_LPI_indication_counter2 */
        /* offset address */    0x9B160C,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port23_LPI_indication_counter2 */
        /* offset address */    0x9B170C,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port24_LPI_indication_counter2 */
        /* offset address */    0x9B180C,
        /* field numbers */     2,
        /* register fields */   PORT_LPI_INDICATION_COUNTER2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port0_Link_Down_Control */
        /* offset address */    0x9B0010,
        /* field numbers */     3,
        /* register fields */   PORT_LINK_DOWN_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port1_Link_Down_Control */
        /* offset address */    0x9B0110,
        /* field numbers */     3,
        /* register fields */   PORT_LINK_DOWN_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port2_Link_Down_Control */
        /* offset address */    0x9B0210,
        /* field numbers */     3,
        /* register fields */   PORT_LINK_DOWN_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port3_Link_Down_Control */
        /* offset address */    0x9B0310,
        /* field numbers */     3,
        /* register fields */   PORT_LINK_DOWN_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port4_Link_Down_Control */
        /* offset address */    0x9B0410,
        /* field numbers */     3,
        /* register fields */   PORT_LINK_DOWN_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port5_Link_Down_Control */
        /* offset address */    0x9B0510,
        /* field numbers */     3,
        /* register fields */   PORT_LINK_DOWN_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port6_Link_Down_Control */
        /* offset address */    0x9B0610,
        /* field numbers */     3,
        /* register fields */   PORT_LINK_DOWN_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port7_Link_Down_Control */
        /* offset address */    0x9B0710,
        /* field numbers */     3,
        /* register fields */   PORT_LINK_DOWN_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port8_Link_Down_Control */
        /* offset address */    0x9B0810,
        /* field numbers */     3,
        /* register fields */   PORT_LINK_DOWN_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port9_Link_Down_Control */
        /* offset address */    0x9B0910,
        /* field numbers */     3,
        /* register fields */   PORT_LINK_DOWN_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port10_Link_Down_Control */
        /* offset address */    0x9B0A10,
        /* field numbers */     3,
        /* register fields */   PORT_LINK_DOWN_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port11_Link_Down_Control */
        /* offset address */    0x9B0B10,
        /* field numbers */     3,
        /* register fields */   PORT_LINK_DOWN_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port12_Link_Down_Control */
        /* offset address */    0x9B0C10,
        /* field numbers */     3,
        /* register fields */   PORT_LINK_DOWN_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port13_Link_Down_Control */
        /* offset address */    0x9B0D10,
        /* field numbers */     3,
        /* register fields */   PORT_LINK_DOWN_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port14_Link_Down_Control */
        /* offset address */    0x9B0E10,
        /* field numbers */     3,
        /* register fields */   PORT_LINK_DOWN_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port15_Link_Down_Control */
        /* offset address */    0x9B0F10,
        /* field numbers */     3,
        /* register fields */   PORT_LINK_DOWN_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port16_Link_Down_Control */
        /* offset address */    0x9B1010,
        /* field numbers */     3,
        /* register fields */   PORT_LINK_DOWN_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port17_Link_Down_Control */
        /* offset address */    0x9B1110,
        /* field numbers */     3,
        /* register fields */   PORT_LINK_DOWN_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port18_Link_Down_Control */
        /* offset address */    0x9B1210,
        /* field numbers */     3,
        /* register fields */   PORT_LINK_DOWN_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port19_Link_Down_Control */
        /* offset address */    0x9B1310,
        /* field numbers */     3,
        /* register fields */   PORT_LINK_DOWN_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port20_Link_Down_Control */
        /* offset address */    0x9B1410,
        /* field numbers */     3,
        /* register fields */   PORT_LINK_DOWN_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port21_Link_Down_Control */
        /* offset address */    0x9B1510,
        /* field numbers */     3,
        /* register fields */   PORT_LINK_DOWN_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port22_Link_Down_Control */
        /* offset address */    0x9B1610,
        /* field numbers */     3,
        /* register fields */   PORT_LINK_DOWN_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port23_Link_Down_Control */
        /* offset address */    0x9B1710,
        /* field numbers */     3,
        /* register fields */   PORT_LINK_DOWN_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port24_Link_Down_Control */
        /* offset address */    0x9B1810,
        /* field numbers */     3,
        /* register fields */   PORT_LINK_DOWN_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port0_EEE_Port_dmy0 */
        /* offset address */    0x9B0014,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port1_EEE_Port_dmy0 */
        /* offset address */    0x9B0114,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port2_EEE_Port_dmy0 */
        /* offset address */    0x9B0214,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port3_EEE_Port_dmy0 */
        /* offset address */    0x9B0314,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port4_EEE_Port_dmy0 */
        /* offset address */    0x9B0414,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port5_EEE_Port_dmy0 */
        /* offset address */    0x9B0514,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port6_EEE_Port_dmy0 */
        /* offset address */    0x9B0614,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port7_EEE_Port_dmy0 */
        /* offset address */    0x9B0714,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port8_EEE_Port_dmy0 */
        /* offset address */    0x9B0814,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port9_EEE_Port_dmy0 */
        /* offset address */    0x9B0914,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port10_EEE_Port_dmy0 */
        /* offset address */    0x9B0A14,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port11_EEE_Port_dmy0 */
        /* offset address */    0x9B0B14,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port12_EEE_Port_dmy0 */
        /* offset address */    0x9B0C14,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port13_EEE_Port_dmy0 */
        /* offset address */    0x9B0D14,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port14_EEE_Port_dmy0 */
        /* offset address */    0x9B0E14,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port15_EEE_Port_dmy0 */
        /* offset address */    0x9B0F14,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port16_EEE_Port_dmy0 */
        /* offset address */    0x9B1014,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port17_EEE_Port_dmy0 */
        /* offset address */    0x9B1114,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port18_EEE_Port_dmy0 */
        /* offset address */    0x9B1214,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port19_EEE_Port_dmy0 */
        /* offset address */    0x9B1314,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port20_EEE_Port_dmy0 */
        /* offset address */    0x9B1414,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port21_EEE_Port_dmy0 */
        /* offset address */    0x9B1514,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port22_EEE_Port_dmy0 */
        /* offset address */    0x9B1614,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port23_EEE_Port_dmy0 */
        /* offset address */    0x9B1714,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port24_EEE_Port_dmy0 */
        /* offset address */    0x9B1814,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port0_EEE_Port_dmy1 */
        /* offset address */    0x9B0018,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port1_EEE_Port_dmy1 */
        /* offset address */    0x9B0118,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port2_EEE_Port_dmy1 */
        /* offset address */    0x9B0218,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port3_EEE_Port_dmy1 */
        /* offset address */    0x9B0318,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port4_EEE_Port_dmy1 */
        /* offset address */    0x9B0418,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port5_EEE_Port_dmy1 */
        /* offset address */    0x9B0518,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port6_EEE_Port_dmy1 */
        /* offset address */    0x9B0618,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port7_EEE_Port_dmy1 */
        /* offset address */    0x9B0718,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port8_EEE_Port_dmy1 */
        /* offset address */    0x9B0818,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port9_EEE_Port_dmy1 */
        /* offset address */    0x9B0918,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port10_EEE_Port_dmy1 */
        /* offset address */    0x9B0A18,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port11_EEE_Port_dmy1 */
        /* offset address */    0x9B0B18,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port12_EEE_Port_dmy1 */
        /* offset address */    0x9B0C18,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port13_EEE_Port_dmy1 */
        /* offset address */    0x9B0D18,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port14_EEE_Port_dmy1 */
        /* offset address */    0x9B0E18,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port15_EEE_Port_dmy1 */
        /* offset address */    0x9B0F18,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port16_EEE_Port_dmy1 */
        /* offset address */    0x9B1018,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port17_EEE_Port_dmy1 */
        /* offset address */    0x9B1118,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port18_EEE_Port_dmy1 */
        /* offset address */    0x9B1218,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port19_EEE_Port_dmy1 */
        /* offset address */    0x9B1318,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port20_EEE_Port_dmy1 */
        /* offset address */    0x9B1418,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port21_EEE_Port_dmy1 */
        /* offset address */    0x9B1518,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port22_EEE_Port_dmy1 */
        /* offset address */    0x9B1618,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port23_EEE_Port_dmy1 */
        /* offset address */    0x9B1718,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port24_EEE_Port_dmy1 */
        /* offset address */    0x9B1818,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port0_EEE_Port_dmy2 */
        /* offset address */    0x9B001C,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port1_EEE_Port_dmy2 */
        /* offset address */    0x9B011C,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port2_EEE_Port_dmy2 */
        /* offset address */    0x9B021C,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port3_EEE_Port_dmy2 */
        /* offset address */    0x9B031C,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port4_EEE_Port_dmy2 */
        /* offset address */    0x9B041C,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port5_EEE_Port_dmy2 */
        /* offset address */    0x9B051C,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port6_EEE_Port_dmy2 */
        /* offset address */    0x9B061C,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port7_EEE_Port_dmy2 */
        /* offset address */    0x9B071C,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port8_EEE_Port_dmy2 */
        /* offset address */    0x9B081C,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port9_EEE_Port_dmy2 */
        /* offset address */    0x9B091C,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port10_EEE_Port_dmy2 */
        /* offset address */    0x9B0A1C,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port11_EEE_Port_dmy2 */
        /* offset address */    0x9B0B1C,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port12_EEE_Port_dmy2 */
        /* offset address */    0x9B0C1C,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port13_EEE_Port_dmy2 */
        /* offset address */    0x9B0D1C,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port14_EEE_Port_dmy2 */
        /* offset address */    0x9B0E1C,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port15_EEE_Port_dmy2 */
        /* offset address */    0x9B0F1C,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port16_EEE_Port_dmy2 */
        /* offset address */    0x9B101C,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port17_EEE_Port_dmy2 */
        /* offset address */    0x9B111C,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port18_EEE_Port_dmy2 */
        /* offset address */    0x9B121C,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port19_EEE_Port_dmy2 */
        /* offset address */    0x9B131C,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port20_EEE_Port_dmy2 */
        /* offset address */    0x9B141C,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port21_EEE_Port_dmy2 */
        /* offset address */    0x9B151C,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port22_EEE_Port_dmy2 */
        /* offset address */    0x9B161C,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port23_EEE_Port_dmy2 */
        /* offset address */    0x9B171C,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port24_EEE_Port_dmy2 */
        /* offset address */    0x9B181C,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port0_EEE_Port_dmy3 */
        /* offset address */    0x9B0020,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port1_EEE_Port_dmy3 */
        /* offset address */    0x9B0120,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port2_EEE_Port_dmy3 */
        /* offset address */    0x9B0220,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port3_EEE_Port_dmy3 */
        /* offset address */    0x9B0320,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port4_EEE_Port_dmy3 */
        /* offset address */    0x9B0420,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port5_EEE_Port_dmy3 */
        /* offset address */    0x9B0520,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port6_EEE_Port_dmy3 */
        /* offset address */    0x9B0620,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port7_EEE_Port_dmy3 */
        /* offset address */    0x9B0720,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port8_EEE_Port_dmy3 */
        /* offset address */    0x9B0820,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port9_EEE_Port_dmy3 */
        /* offset address */    0x9B0920,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port10_EEE_Port_dmy3 */
        /* offset address */    0x9B0A20,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port11_EEE_Port_dmy3 */
        /* offset address */    0x9B0B20,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port12_EEE_Port_dmy3 */
        /* offset address */    0x9B0C20,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port13_EEE_Port_dmy3 */
        /* offset address */    0x9B0D20,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port14_EEE_Port_dmy3 */
        /* offset address */    0x9B0E20,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port15_EEE_Port_dmy3 */
        /* offset address */    0x9B0F20,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port16_EEE_Port_dmy3 */
        /* offset address */    0x9B1020,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port17_EEE_Port_dmy3 */
        /* offset address */    0x9B1120,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port18_EEE_Port_dmy3 */
        /* offset address */    0x9B1220,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port19_EEE_Port_dmy3 */
        /* offset address */    0x9B1320,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port20_EEE_Port_dmy3 */
        /* offset address */    0x9B1420,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port21_EEE_Port_dmy3 */
        /* offset address */    0x9B1520,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port22_EEE_Port_dmy3 */
        /* offset address */    0x9B1620,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port23_EEE_Port_dmy3 */
        /* offset address */    0x9B1720,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port24_EEE_Port_dmy3 */
        /* offset address */    0x9B1820,
        /* field numbers */     1,
        /* register fields */   PORT_EEE_PORT_DMY3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        L4Port_Range_Checking_Table_Entry0_0 */
        /* offset address */    0x200000,
        /* field numbers */     2,
        /* register fields */   L4PORT_RANGE_CHECKING_TABLE_ENTRY0_0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        L4Port_Range_Checking_Table_Entry0_1 */
        /* offset address */    0x200004,
        /* field numbers */     3,
        /* register fields */   L4PORT_RANGE_CHECKING_TABLE_ENTRY0_1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        L4Port_Range_Checking_Table_Entry1_0 */
        /* offset address */    0x200008,
        /* field numbers */     2,
        /* register fields */   L4PORT_RANGE_CHECKING_TABLE_ENTRY1_0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        L4Port_Range_Checking_Table_Entry1_1 */
        /* offset address */    0x20000C,
        /* field numbers */     3,
        /* register fields */   L4PORT_RANGE_CHECKING_TABLE_ENTRY1_1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        L4Port_Range_Checking_Table_Entry2_0 */
        /* offset address */    0x200010,
        /* field numbers */     2,
        /* register fields */   L4PORT_RANGE_CHECKING_TABLE_ENTRY2_0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        L4Port_Range_Checking_Table_Entry2_1 */
        /* offset address */    0x200014,
        /* field numbers */     3,
        /* register fields */   L4PORT_RANGE_CHECKING_TABLE_ENTRY2_1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        L4Port_Range_Checking_Table_Entry3_0 */
        /* offset address */    0x200018,
        /* field numbers */     2,
        /* register fields */   L4PORT_RANGE_CHECKING_TABLE_ENTRY3_0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        L4Port_Range_Checking_Table_Entry3_1 */
        /* offset address */    0x20001C,
        /* field numbers */     3,
        /* register fields */   L4PORT_RANGE_CHECKING_TABLE_ENTRY3_1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        VID_Range_Checking_Table_Entry0 */
        /* offset address */    0x200020,
        /* field numbers */     4,
        /* register fields */   VID_RANGE_CHECKING_TABLE_ENTRY0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        VID_Range_Checking_Table_Entry1 */
        /* offset address */    0x200024,
        /* field numbers */     4,
        /* register fields */   VID_RANGE_CHECKING_TABLE_ENTRY1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        VID_Range_Checking_Table_Entry2 */
        /* offset address */    0x200028,
        /* field numbers */     4,
        /* register fields */   VID_RANGE_CHECKING_TABLE_ENTRY2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        VID_Range_Checking_Table_Entry3 */
        /* offset address */    0x20002C,
        /* field numbers */     4,
        /* register fields */   VID_RANGE_CHECKING_TABLE_ENTRY3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        VID_Range_Checking_Table_Entry4 */
        /* offset address */    0x200030,
        /* field numbers */     4,
        /* register fields */   VID_RANGE_CHECKING_TABLE_ENTRY4_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        VID_Range_Checking_Table_Entry5 */
        /* offset address */    0x200034,
        /* field numbers */     4,
        /* register fields */   VID_RANGE_CHECKING_TABLE_ENTRY5_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        VID_Range_Checking_Table_Entry6 */
        /* offset address */    0x200038,
        /* field numbers */     4,
        /* register fields */   VID_RANGE_CHECKING_TABLE_ENTRY6_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        VID_Range_Checking_Table_Entry7 */
        /* offset address */    0x20003C,
        /* field numbers */     4,
        /* register fields */   VID_RANGE_CHECKING_TABLE_ENTRY7_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        VID_Range_Checking_Table_Entry8 */
        /* offset address */    0x200040,
        /* field numbers */     4,
        /* register fields */   VID_RANGE_CHECKING_TABLE_ENTRY8_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        VID_Range_Checking_Table_Entry9 */
        /* offset address */    0x200044,
        /* field numbers */     4,
        /* register fields */   VID_RANGE_CHECKING_TABLE_ENTRY9_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        VID_Range_Checking_Table_Entry10 */
        /* offset address */    0x200048,
        /* field numbers */     4,
        /* register fields */   VID_RANGE_CHECKING_TABLE_ENTRY10_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        VID_Range_Checking_Table_Entry11 */
        /* offset address */    0x20004C,
        /* field numbers */     4,
        /* register fields */   VID_RANGE_CHECKING_TABLE_ENTRY11_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        VID_Range_Checking_Table_Entry12 */
        /* offset address */    0x200050,
        /* field numbers */     4,
        /* register fields */   VID_RANGE_CHECKING_TABLE_ENTRY12_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        VID_Range_Checking_Table_Entry13 */
        /* offset address */    0x200054,
        /* field numbers */     4,
        /* register fields */   VID_RANGE_CHECKING_TABLE_ENTRY13_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        VID_Range_Checking_Table_Entry14 */
        /* offset address */    0x200058,
        /* field numbers */     4,
        /* register fields */   VID_RANGE_CHECKING_TABLE_ENTRY14_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        VID_Range_Checking_Table_Entry15 */
        /* offset address */    0x20005C,
        /* field numbers */     4,
        /* register fields */   VID_RANGE_CHECKING_TABLE_ENTRY15_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        IP_Range_Checking_Table_Entry0_0 */
        /* offset address */    0x200060,
        /* field numbers */     1,
        /* register fields */   IP_RANGE_CHECKING_TABLE_ENTRY0_0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        IP_Range_Checking_Table_Entry0_1 */
        /* offset address */    0x200064,
        /* field numbers */     1,
        /* register fields */   IP_RANGE_CHECKING_TABLE_ENTRY0_1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        IP_Range_Checking_Table_Entry0_2 */
        /* offset address */    0x200068,
        /* field numbers */     2,
        /* register fields */   IP_RANGE_CHECKING_TABLE_ENTRY0_2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        IP_Range_Checking_Table_Entry1_0 */
        /* offset address */    0x20006C,
        /* field numbers */     1,
        /* register fields */   IP_RANGE_CHECKING_TABLE_ENTRY1_0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        IP_Range_Checking_Table_Entry1_1 */
        /* offset address */    0x200070,
        /* field numbers */     1,
        /* register fields */   IP_RANGE_CHECKING_TABLE_ENTRY1_1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        IP_Range_Checking_Table_Entry1_2 */
        /* offset address */    0x200074,
        /* field numbers */     2,
        /* register fields */   IP_RANGE_CHECKING_TABLE_ENTRY1_2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        IP_Range_Checking_Table_Entry2_0 */
        /* offset address */    0x200078,
        /* field numbers */     1,
        /* register fields */   IP_RANGE_CHECKING_TABLE_ENTRY2_0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        IP_Range_Checking_Table_Entry2_1 */
        /* offset address */    0x20007C,
        /* field numbers */     1,
        /* register fields */   IP_RANGE_CHECKING_TABLE_ENTRY2_1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        IP_Range_Checking_Table_Entry2_2 */
        /* offset address */    0x200080,
        /* field numbers */     2,
        /* register fields */   IP_RANGE_CHECKING_TABLE_ENTRY2_2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        IP_Range_Checking_Table_Entry3_0 */
        /* offset address */    0x200084,
        /* field numbers */     1,
        /* register fields */   IP_RANGE_CHECKING_TABLE_ENTRY3_0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        IP_Range_Checking_Table_Entry3_1 */
        /* offset address */    0x200088,
        /* field numbers */     1,
        /* register fields */   IP_RANGE_CHECKING_TABLE_ENTRY3_1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        IP_Range_Checking_Table_Entry3_2 */
        /* offset address */    0x20008C,
        /* field numbers */     2,
        /* register fields */   IP_RANGE_CHECKING_TABLE_ENTRY3_2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        IP_Range_Checking_Table_Entry4_0 */
        /* offset address */    0x200090,
        /* field numbers */     1,
        /* register fields */   IP_RANGE_CHECKING_TABLE_ENTRY4_0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        IP_Range_Checking_Table_Entry4_1 */
        /* offset address */    0x200094,
        /* field numbers */     1,
        /* register fields */   IP_RANGE_CHECKING_TABLE_ENTRY4_1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        IP_Range_Checking_Table_Entry4_2 */
        /* offset address */    0x200098,
        /* field numbers */     2,
        /* register fields */   IP_RANGE_CHECKING_TABLE_ENTRY4_2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        IP_Range_Checking_Table_Entry5_0 */
        /* offset address */    0x20009C,
        /* field numbers */     1,
        /* register fields */   IP_RANGE_CHECKING_TABLE_ENTRY5_0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        IP_Range_Checking_Table_Entry5_1 */
        /* offset address */    0x2000A0,
        /* field numbers */     1,
        /* register fields */   IP_RANGE_CHECKING_TABLE_ENTRY5_1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        IP_Range_Checking_Table_Entry5_2 */
        /* offset address */    0x2000A4,
        /* field numbers */     2,
        /* register fields */   IP_RANGE_CHECKING_TABLE_ENTRY5_2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        IP_Range_Checking_Table_Entry6_0 */
        /* offset address */    0x2000A8,
        /* field numbers */     1,
        /* register fields */   IP_RANGE_CHECKING_TABLE_ENTRY6_0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        IP_Range_Checking_Table_Entry6_1 */
        /* offset address */    0x2000AC,
        /* field numbers */     1,
        /* register fields */   IP_RANGE_CHECKING_TABLE_ENTRY6_1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        IP_Range_Checking_Table_Entry6_2 */
        /* offset address */    0x2000B0,
        /* field numbers */     2,
        /* register fields */   IP_RANGE_CHECKING_TABLE_ENTRY6_2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        IP_Range_Checking_Table_Entry7_0 */
        /* offset address */    0x2000B4,
        /* field numbers */     1,
        /* register fields */   IP_RANGE_CHECKING_TABLE_ENTRY7_0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        IP_Range_Checking_Table_Entry7_1 */
        /* offset address */    0x2000B8,
        /* field numbers */     1,
        /* register fields */   IP_RANGE_CHECKING_TABLE_ENTRY7_1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        IP_Range_Checking_Table_Entry7_2 */
        /* offset address */    0x2000BC,
        /* field numbers */     2,
        /* register fields */   IP_RANGE_CHECKING_TABLE_ENTRY7_2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Source_Port_Mask_Table_Entry0 */
        /* offset address */    0x2000C0,
        /* field numbers */     2,
        /* register fields */   SOURCE_PORT_MASK_TABLE_ENTRY0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Source_Port_Mask_Table_Entry1 */
        /* offset address */    0x2000C4,
        /* field numbers */     2,
        /* register fields */   SOURCE_PORT_MASK_TABLE_ENTRY1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Source_Port_Mask_Table_Entry2 */
        /* offset address */    0x2000C8,
        /* field numbers */     2,
        /* register fields */   SOURCE_PORT_MASK_TABLE_ENTRY2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Source_Port_Mask_Table_Entry3 */
        /* offset address */    0x2000CC,
        /* field numbers */     2,
        /* register fields */   SOURCE_PORT_MASK_TABLE_ENTRY3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        User_Defined_Template_Control0 */
        /* offset address */    0x210000,
        /* field numbers */     7,
        /* register fields */   USER_DEFINED_TEMPLATE_CONTROL0_FIELDS,
        /* default value */     0xC5262E0
    },
    {   /* register name        User_Defined_Template_Control1 */
        /* offset address */    0x210004,
        /* field numbers */     4,
        /* register fields */   USER_DEFINED_TEMPLATE_CONTROL1_FIELDS,
        /* default value */     0x3589
    },
    {   /* register name        User_Defined_Template_Control2 */
        /* offset address */    0x210008,
        /* field numbers */     7,
        /* register fields */   USER_DEFINED_TEMPLATE_CONTROL2_FIELDS,
        /* default value */     0x620E2E0
    },
    {   /* register name        User_Defined_Template_Control3 */
        /* offset address */    0x21000C,
        /* field numbers */     4,
        /* register fields */   USER_DEFINED_TEMPLATE_CONTROL3_FIELDS,
        /* default value */     0x5689
    },
    {   /* register name        PIE_RESULT_REVERSE_CONTROL0 */
        /* offset address */    0x210010,
        /* field numbers */     32,
        /* register fields */   PIE_RESULT_REVERSE_CONTROL0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PIE_RESULT_REVERSE_CONTROL1 */
        /* offset address */    0x210014,
        /* field numbers */     32,
        /* register fields */   PIE_RESULT_REVERSE_CONTROL1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PIE_RESULT_REVERSE_CONTROL2 */
        /* offset address */    0x210018,
        /* field numbers */     32,
        /* register fields */   PIE_RESULT_REVERSE_CONTROL2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PIE_RESULT_REVERSE_CONTROL3 */
        /* offset address */    0x21001C,
        /* field numbers */     32,
        /* register fields */   PIE_RESULT_REVERSE_CONTROL3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PIE_Block_Priority_CONTROL */
        /* offset address */    0x210020,
        /* field numbers */     5,
        /* register fields */   PIE_BLOCK_PRIORITY_CONTROL_FIELDS,
        /* default value */     0x1B
    },
    {   /* register name        Policer_Table_Control */
        /* offset address */    0x230000,
        /* field numbers */     2,
        /* register fields */   POLICER_TABLE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        CRC_Error_Frame_Lookup_Control */
        /* offset address */    0x230004,
        /* field numbers */     3,
        /* register fields */   CRC_ERROR_FRAME_LOOKUP_CONTROL_FIELDS,
        /* default value */     0x2
    },
    {   /* register name        ACL_CopytoCPU_Control */
        /* offset address */    0x230008,
        /* field numbers */     2,
        /* register fields */   ACL_COPYTOCPU_CONTROL_FIELDS,
        /* default value */     0x2
    },
    {   /* register name        ACL_Rule_Hit_Interrupt_Control0 */
        /* offset address */    0x23000C,
        /* field numbers */     1,
        /* register fields */   ACL_RULE_HIT_INTERRUPT_CONTROL0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        ACL_Rule_Hit_Interrupt_Control1 */
        /* offset address */    0x230010,
        /* field numbers */     1,
        /* register fields */   ACL_RULE_HIT_INTERRUPT_CONTROL1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        ACL_Rule_Hit_Interrupt_Control2 */
        /* offset address */    0x230014,
        /* field numbers */     1,
        /* register fields */   ACL_RULE_HIT_INTERRUPT_CONTROL2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        ACL_Rule_Hit_Interrupt_Control3 */
        /* offset address */    0x230018,
        /* field numbers */     1,
        /* register fields */   ACL_RULE_HIT_INTERRUPT_CONTROL3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        ACL_Rule_Hit_Interrupt_Status0 */
        /* offset address */    0x23001C,
        /* field numbers */     1,
        /* register fields */   ACL_RULE_HIT_INTERRUPT_STATUS0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        ACL_Rule_Hit_Interrupt_Status1 */
        /* offset address */    0x230020,
        /* field numbers */     1,
        /* register fields */   ACL_RULE_HIT_INTERRUPT_STATUS1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        ACL_Rule_Hit_Interrupt_Status2 */
        /* offset address */    0x230024,
        /* field numbers */     1,
        /* register fields */   ACL_RULE_HIT_INTERRUPT_STATUS2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        ACL_Rule_Hit_Interrupt_Status3 */
        /* offset address */    0x230028,
        /* field numbers */     1,
        /* register fields */   ACL_RULE_HIT_INTERRUPT_STATUS3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port0_ACL_Lookup_Control */
        /* offset address */    0xA30000,
        /* field numbers */     3,
        /* register fields */   PORT_ACL_LOOKUP_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port1_ACL_Lookup_Control */
        /* offset address */    0xA30100,
        /* field numbers */     3,
        /* register fields */   PORT_ACL_LOOKUP_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port2_ACL_Lookup_Control */
        /* offset address */    0xA30200,
        /* field numbers */     3,
        /* register fields */   PORT_ACL_LOOKUP_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port3_ACL_Lookup_Control */
        /* offset address */    0xA30300,
        /* field numbers */     3,
        /* register fields */   PORT_ACL_LOOKUP_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port4_ACL_Lookup_Control */
        /* offset address */    0xA30400,
        /* field numbers */     3,
        /* register fields */   PORT_ACL_LOOKUP_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port5_ACL_Lookup_Control */
        /* offset address */    0xA30500,
        /* field numbers */     3,
        /* register fields */   PORT_ACL_LOOKUP_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port6_ACL_Lookup_Control */
        /* offset address */    0xA30600,
        /* field numbers */     3,
        /* register fields */   PORT_ACL_LOOKUP_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port7_ACL_Lookup_Control */
        /* offset address */    0xA30700,
        /* field numbers */     3,
        /* register fields */   PORT_ACL_LOOKUP_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port8_ACL_Lookup_Control */
        /* offset address */    0xA30800,
        /* field numbers */     3,
        /* register fields */   PORT_ACL_LOOKUP_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port9_ACL_Lookup_Control */
        /* offset address */    0xA30900,
        /* field numbers */     3,
        /* register fields */   PORT_ACL_LOOKUP_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port10_ACL_Lookup_Control */
        /* offset address */    0xA30A00,
        /* field numbers */     3,
        /* register fields */   PORT_ACL_LOOKUP_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port11_ACL_Lookup_Control */
        /* offset address */    0xA30B00,
        /* field numbers */     3,
        /* register fields */   PORT_ACL_LOOKUP_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port12_ACL_Lookup_Control */
        /* offset address */    0xA30C00,
        /* field numbers */     3,
        /* register fields */   PORT_ACL_LOOKUP_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port13_ACL_Lookup_Control */
        /* offset address */    0xA30D00,
        /* field numbers */     3,
        /* register fields */   PORT_ACL_LOOKUP_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port14_ACL_Lookup_Control */
        /* offset address */    0xA30E00,
        /* field numbers */     3,
        /* register fields */   PORT_ACL_LOOKUP_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port15_ACL_Lookup_Control */
        /* offset address */    0xA30F00,
        /* field numbers */     3,
        /* register fields */   PORT_ACL_LOOKUP_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port16_ACL_Lookup_Control */
        /* offset address */    0xA31000,
        /* field numbers */     3,
        /* register fields */   PORT_ACL_LOOKUP_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port17_ACL_Lookup_Control */
        /* offset address */    0xA31100,
        /* field numbers */     3,
        /* register fields */   PORT_ACL_LOOKUP_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port18_ACL_Lookup_Control */
        /* offset address */    0xA31200,
        /* field numbers */     3,
        /* register fields */   PORT_ACL_LOOKUP_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port19_ACL_Lookup_Control */
        /* offset address */    0xA31300,
        /* field numbers */     3,
        /* register fields */   PORT_ACL_LOOKUP_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port20_ACL_Lookup_Control */
        /* offset address */    0xA31400,
        /* field numbers */     3,
        /* register fields */   PORT_ACL_LOOKUP_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port21_ACL_Lookup_Control */
        /* offset address */    0xA31500,
        /* field numbers */     3,
        /* register fields */   PORT_ACL_LOOKUP_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port22_ACL_Lookup_Control */
        /* offset address */    0xA31600,
        /* field numbers */     3,
        /* register fields */   PORT_ACL_LOOKUP_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port23_ACL_Lookup_Control */
        /* offset address */    0xA31700,
        /* field numbers */     3,
        /* register fields */   PORT_ACL_LOOKUP_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port24_ACL_Lookup_Control */
        /* offset address */    0xA31800,
        /* field numbers */     3,
        /* register fields */   PORT_ACL_LOOKUP_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Flow_control_Global_Control */
        /* offset address */    0x290000,
        /* field numbers */     2,
        /* register fields */   FLOW_CONTROL_GLOBAL_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        System_drop_threshold_Control */
        /* offset address */    0x290004,
        /* field numbers */     2,
        /* register fields */   SYSTEM_DROP_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x3E7
    },
    {   /* register name        Public_page_Rx_used_High_threshold_Control0 */
        /* offset address */    0x290008,
        /* field numbers */     4,
        /* register fields */   PUBLIC_PAGE_RX_USED_HIGH_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0x1070113
    },
    {   /* register name        Public_page_Rx_used_Low_threshold_Control1 */
        /* offset address */    0x29000C,
        /* field numbers */     4,
        /* register fields */   PUBLIC_PAGE_RX_USED_LOW_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xE300EF
    },
    {   /* register name        flow_control_enable_drop_packet_number_control */
        /* offset address */    0x290010,
        /* field numbers */     3,
        /* register fields */   FLOW_CONTROL_ENABLE_DROP_PACKET_NUMBER_CONTROL_FIELDS,
        /* default value */     0x39
    },
    {   /* register name        Flow_control_off_Public_page_Rx_used_drop_on_threshold */
        /* offset address */    0x290014,
        /* field numbers */     4,
        /* register fields */   FLOW_CONTROL_OFF_PUBLIC_PAGE_RX_USED_DROP_ON_THRESHOLD_FIELDS,
        /* default value */     0xEF0113
    },
    {   /* register name        Flow_control_off_Public_page_Rx_used_drop_off_threshold */
        /* offset address */    0x290018,
        /* field numbers */     4,
        /* register fields */   FLOW_CONTROL_OFF_PUBLIC_PAGE_RX_USED_DROP_OFF_THRESHOLD_FIELDS,
        /* default value */     0xE30107
    },
    {   /* register name        PORT0_Flow_control_Control */
        /* offset address */    0xA90000,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT1_Flow_control_Control */
        /* offset address */    0xA90100,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT2_Flow_control_Control */
        /* offset address */    0xA90200,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT3_Flow_control_Control */
        /* offset address */    0xA90300,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT4_Flow_control_Control */
        /* offset address */    0xA90400,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT5_Flow_control_Control */
        /* offset address */    0xA90500,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT6_Flow_control_Control */
        /* offset address */    0xA90600,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT7_Flow_control_Control */
        /* offset address */    0xA90700,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT8_Flow_control_Control */
        /* offset address */    0xA90800,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT9_Flow_control_Control */
        /* offset address */    0xA90900,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT10_Flow_control_Control */
        /* offset address */    0xA90A00,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT11_Flow_control_Control */
        /* offset address */    0xA90B00,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT12_Flow_control_Control */
        /* offset address */    0xA90C00,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT13_Flow_control_Control */
        /* offset address */    0xA90D00,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT14_Flow_control_Control */
        /* offset address */    0xA90E00,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT15_Flow_control_Control */
        /* offset address */    0xA90F00,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT16_Flow_control_Control */
        /* offset address */    0xA91000,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT17_Flow_control_Control */
        /* offset address */    0xA91100,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT18_Flow_control_Control */
        /* offset address */    0xA91200,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT19_Flow_control_Control */
        /* offset address */    0xA91300,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT20_Flow_control_Control */
        /* offset address */    0xA91400,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT21_Flow_control_Control */
        /* offset address */    0xA91500,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT22_Flow_control_Control */
        /* offset address */    0xA91600,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT23_Flow_control_Control */
        /* offset address */    0xA91700,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT24_Flow_control_Control */
        /* offset address */    0xA91800,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT0_Flowcontrol_Tx_Queue_Drop_Enable_Control */
        /* offset address */    0xA90004,
        /* field numbers */     5,
        /* register fields */   PORT_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT1_Flowcontrol_Tx_Queue_Drop_Enable_Control */
        /* offset address */    0xA90104,
        /* field numbers */     5,
        /* register fields */   PORT_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT2_Flowcontrol_Tx_Queue_Drop_Enable_Control */
        /* offset address */    0xA90204,
        /* field numbers */     5,
        /* register fields */   PORT_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT3_Flowcontrol_Tx_Queue_Drop_Enable_Control */
        /* offset address */    0xA90304,
        /* field numbers */     5,
        /* register fields */   PORT_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT4_Flowcontrol_Tx_Queue_Drop_Enable_Control */
        /* offset address */    0xA90404,
        /* field numbers */     5,
        /* register fields */   PORT_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT5_Flowcontrol_Tx_Queue_Drop_Enable_Control */
        /* offset address */    0xA90504,
        /* field numbers */     5,
        /* register fields */   PORT_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT6_Flowcontrol_Tx_Queue_Drop_Enable_Control */
        /* offset address */    0xA90604,
        /* field numbers */     5,
        /* register fields */   PORT_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT7_Flowcontrol_Tx_Queue_Drop_Enable_Control */
        /* offset address */    0xA90704,
        /* field numbers */     5,
        /* register fields */   PORT_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT8_Flowcontrol_Tx_Queue_Drop_Enable_Control */
        /* offset address */    0xA90804,
        /* field numbers */     5,
        /* register fields */   PORT_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT9_Flowcontrol_Tx_Queue_Drop_Enable_Control */
        /* offset address */    0xA90904,
        /* field numbers */     5,
        /* register fields */   PORT_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT10_Flowcontrol_Tx_Queue_Drop_Enable_Control */
        /* offset address */    0xA90A04,
        /* field numbers */     5,
        /* register fields */   PORT_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT11_Flowcontrol_Tx_Queue_Drop_Enable_Control */
        /* offset address */    0xA90B04,
        /* field numbers */     5,
        /* register fields */   PORT_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT12_Flowcontrol_Tx_Queue_Drop_Enable_Control */
        /* offset address */    0xA90C04,
        /* field numbers */     5,
        /* register fields */   PORT_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT13_Flowcontrol_Tx_Queue_Drop_Enable_Control */
        /* offset address */    0xA90D04,
        /* field numbers */     5,
        /* register fields */   PORT_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT14_Flowcontrol_Tx_Queue_Drop_Enable_Control */
        /* offset address */    0xA90E04,
        /* field numbers */     5,
        /* register fields */   PORT_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT15_Flowcontrol_Tx_Queue_Drop_Enable_Control */
        /* offset address */    0xA90F04,
        /* field numbers */     5,
        /* register fields */   PORT_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT16_Flowcontrol_Tx_Queue_Drop_Enable_Control */
        /* offset address */    0xA91004,
        /* field numbers */     5,
        /* register fields */   PORT_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT17_Flowcontrol_Tx_Queue_Drop_Enable_Control */
        /* offset address */    0xA91104,
        /* field numbers */     5,
        /* register fields */   PORT_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT18_Flowcontrol_Tx_Queue_Drop_Enable_Control */
        /* offset address */    0xA91204,
        /* field numbers */     5,
        /* register fields */   PORT_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT19_Flowcontrol_Tx_Queue_Drop_Enable_Control */
        /* offset address */    0xA91304,
        /* field numbers */     5,
        /* register fields */   PORT_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT20_Flowcontrol_Tx_Queue_Drop_Enable_Control */
        /* offset address */    0xA91404,
        /* field numbers */     5,
        /* register fields */   PORT_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT21_Flowcontrol_Tx_Queue_Drop_Enable_Control */
        /* offset address */    0xA91504,
        /* field numbers */     5,
        /* register fields */   PORT_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT22_Flowcontrol_Tx_Queue_Drop_Enable_Control */
        /* offset address */    0xA91604,
        /* field numbers */     5,
        /* register fields */   PORT_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT23_Flowcontrol_Tx_Queue_Drop_Enable_Control */
        /* offset address */    0xA91704,
        /* field numbers */     5,
        /* register fields */   PORT_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT24_Flowcontrol_Tx_Queue_Drop_Enable_Control */
        /* offset address */    0xA91804,
        /* field numbers */     5,
        /* register fields */   PORT_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port0_Rx_Page_High_threshold_Control */
        /* offset address */    0xA90008,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port1_Rx_Page_High_threshold_Control */
        /* offset address */    0xA90108,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port2_Rx_Page_High_threshold_Control */
        /* offset address */    0xA90208,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port3_Rx_Page_High_threshold_Control */
        /* offset address */    0xA90308,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port4_Rx_Page_High_threshold_Control */
        /* offset address */    0xA90408,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port5_Rx_Page_High_threshold_Control */
        /* offset address */    0xA90508,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port6_Rx_Page_High_threshold_Control */
        /* offset address */    0xA90608,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port7_Rx_Page_High_threshold_Control */
        /* offset address */    0xA90708,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port8_Rx_Page_High_threshold_Control */
        /* offset address */    0xA90808,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port9_Rx_Page_High_threshold_Control */
        /* offset address */    0xA90908,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port10_Rx_Page_High_threshold_Control */
        /* offset address */    0xA90A08,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port11_Rx_Page_High_threshold_Control */
        /* offset address */    0xA90B08,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port12_Rx_Page_High_threshold_Control */
        /* offset address */    0xA90C08,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port13_Rx_Page_High_threshold_Control */
        /* offset address */    0xA90D08,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port14_Rx_Page_High_threshold_Control */
        /* offset address */    0xA90E08,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port15_Rx_Page_High_threshold_Control */
        /* offset address */    0xA90F08,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port16_Rx_Page_High_threshold_Control */
        /* offset address */    0xA91008,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port17_Rx_Page_High_threshold_Control */
        /* offset address */    0xA91108,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port18_Rx_Page_High_threshold_Control */
        /* offset address */    0xA91208,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port19_Rx_Page_High_threshold_Control */
        /* offset address */    0xA91308,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port20_Rx_Page_High_threshold_Control */
        /* offset address */    0xA91408,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port21_Rx_Page_High_threshold_Control */
        /* offset address */    0xA91508,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port22_Rx_Page_High_threshold_Control */
        /* offset address */    0xA91608,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port23_Rx_Page_High_threshold_Control */
        /* offset address */    0xA91708,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port24_Rx_Page_High_threshold_Control */
        /* offset address */    0xA91808,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port0_Rx_Page_Low_threshold_Control */
        /* offset address */    0xA9000C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port1_Rx_Page_Low_threshold_Control */
        /* offset address */    0xA9010C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port2_Rx_Page_Low_threshold_Control */
        /* offset address */    0xA9020C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port3_Rx_Page_Low_threshold_Control */
        /* offset address */    0xA9030C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port4_Rx_Page_Low_threshold_Control */
        /* offset address */    0xA9040C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port5_Rx_Page_Low_threshold_Control */
        /* offset address */    0xA9050C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port6_Rx_Page_Low_threshold_Control */
        /* offset address */    0xA9060C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port7_Rx_Page_Low_threshold_Control */
        /* offset address */    0xA9070C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port8_Rx_Page_Low_threshold_Control */
        /* offset address */    0xA9080C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port9_Rx_Page_Low_threshold_Control */
        /* offset address */    0xA9090C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port10_Rx_Page_Low_threshold_Control */
        /* offset address */    0xA90A0C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port11_Rx_Page_Low_threshold_Control */
        /* offset address */    0xA90B0C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port12_Rx_Page_Low_threshold_Control */
        /* offset address */    0xA90C0C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port13_Rx_Page_Low_threshold_Control */
        /* offset address */    0xA90D0C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port14_Rx_Page_Low_threshold_Control */
        /* offset address */    0xA90E0C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port15_Rx_Page_Low_threshold_Control */
        /* offset address */    0xA90F0C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port16_Rx_Page_Low_threshold_Control */
        /* offset address */    0xA9100C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port17_Rx_Page_Low_threshold_Control */
        /* offset address */    0xA9110C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port18_Rx_Page_Low_threshold_Control */
        /* offset address */    0xA9120C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port19_Rx_Page_Low_threshold_Control */
        /* offset address */    0xA9130C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port20_Rx_Page_Low_threshold_Control */
        /* offset address */    0xA9140C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port21_Rx_Page_Low_threshold_Control */
        /* offset address */    0xA9150C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port22_Rx_Page_Low_threshold_Control */
        /* offset address */    0xA9160C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port23_Rx_Page_Low_threshold_Control */
        /* offset address */    0xA9170C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port24_Rx_Page_Low_threshold_Control */
        /* offset address */    0xA9180C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port0_Rx_Page_Guarantee_threshold_Control */
        /* offset address */    0xA90010,
        /* field numbers */     2,
        /* register fields */   PORT_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0xC
    },
    {   /* register name        Port1_Rx_Page_Guarantee_threshold_Control */
        /* offset address */    0xA90110,
        /* field numbers */     2,
        /* register fields */   PORT_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0xC
    },
    {   /* register name        Port2_Rx_Page_Guarantee_threshold_Control */
        /* offset address */    0xA90210,
        /* field numbers */     2,
        /* register fields */   PORT_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0xC
    },
    {   /* register name        Port3_Rx_Page_Guarantee_threshold_Control */
        /* offset address */    0xA90310,
        /* field numbers */     2,
        /* register fields */   PORT_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0xC
    },
    {   /* register name        Port4_Rx_Page_Guarantee_threshold_Control */
        /* offset address */    0xA90410,
        /* field numbers */     2,
        /* register fields */   PORT_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0xC
    },
    {   /* register name        Port5_Rx_Page_Guarantee_threshold_Control */
        /* offset address */    0xA90510,
        /* field numbers */     2,
        /* register fields */   PORT_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0xC
    },
    {   /* register name        Port6_Rx_Page_Guarantee_threshold_Control */
        /* offset address */    0xA90610,
        /* field numbers */     2,
        /* register fields */   PORT_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0xC
    },
    {   /* register name        Port7_Rx_Page_Guarantee_threshold_Control */
        /* offset address */    0xA90710,
        /* field numbers */     2,
        /* register fields */   PORT_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0xC
    },
    {   /* register name        Port8_Rx_Page_Guarantee_threshold_Control */
        /* offset address */    0xA90810,
        /* field numbers */     2,
        /* register fields */   PORT_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0xC
    },
    {   /* register name        Port9_Rx_Page_Guarantee_threshold_Control */
        /* offset address */    0xA90910,
        /* field numbers */     2,
        /* register fields */   PORT_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0xC
    },
    {   /* register name        Port10_Rx_Page_Guarantee_threshold_Control */
        /* offset address */    0xA90A10,
        /* field numbers */     2,
        /* register fields */   PORT_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0xC
    },
    {   /* register name        Port11_Rx_Page_Guarantee_threshold_Control */
        /* offset address */    0xA90B10,
        /* field numbers */     2,
        /* register fields */   PORT_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0xC
    },
    {   /* register name        Port12_Rx_Page_Guarantee_threshold_Control */
        /* offset address */    0xA90C10,
        /* field numbers */     2,
        /* register fields */   PORT_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0xC
    },
    {   /* register name        Port13_Rx_Page_Guarantee_threshold_Control */
        /* offset address */    0xA90D10,
        /* field numbers */     2,
        /* register fields */   PORT_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0xC
    },
    {   /* register name        Port14_Rx_Page_Guarantee_threshold_Control */
        /* offset address */    0xA90E10,
        /* field numbers */     2,
        /* register fields */   PORT_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0xC
    },
    {   /* register name        Port15_Rx_Page_Guarantee_threshold_Control */
        /* offset address */    0xA90F10,
        /* field numbers */     2,
        /* register fields */   PORT_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0xC
    },
    {   /* register name        Port16_Rx_Page_Guarantee_threshold_Control */
        /* offset address */    0xA91010,
        /* field numbers */     2,
        /* register fields */   PORT_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0xC
    },
    {   /* register name        Port17_Rx_Page_Guarantee_threshold_Control */
        /* offset address */    0xA91110,
        /* field numbers */     2,
        /* register fields */   PORT_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0xC
    },
    {   /* register name        Port18_Rx_Page_Guarantee_threshold_Control */
        /* offset address */    0xA91210,
        /* field numbers */     2,
        /* register fields */   PORT_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0xC
    },
    {   /* register name        Port19_Rx_Page_Guarantee_threshold_Control */
        /* offset address */    0xA91310,
        /* field numbers */     2,
        /* register fields */   PORT_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0xC
    },
    {   /* register name        Port20_Rx_Page_Guarantee_threshold_Control */
        /* offset address */    0xA91410,
        /* field numbers */     2,
        /* register fields */   PORT_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0xC
    },
    {   /* register name        Port21_Rx_Page_Guarantee_threshold_Control */
        /* offset address */    0xA91510,
        /* field numbers */     2,
        /* register fields */   PORT_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0xC
    },
    {   /* register name        Port22_Rx_Page_Guarantee_threshold_Control */
        /* offset address */    0xA91610,
        /* field numbers */     2,
        /* register fields */   PORT_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0xC
    },
    {   /* register name        Port23_Rx_Page_Guarantee_threshold_Control */
        /* offset address */    0xA91710,
        /* field numbers */     2,
        /* register fields */   PORT_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0xC
    },
    {   /* register name        Port24_Rx_Page_Guarantee_threshold_Control */
        /* offset address */    0xA91810,
        /* field numbers */     2,
        /* register fields */   PORT_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0xC
    },
    {   /* register name        Port0_Queue_Drop_Page_threshold_Control0 */
        /* offset address */    0xA90014,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port1_Queue_Drop_Page_threshold_Control0 */
        /* offset address */    0xA90114,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port2_Queue_Drop_Page_threshold_Control0 */
        /* offset address */    0xA90214,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port3_Queue_Drop_Page_threshold_Control0 */
        /* offset address */    0xA90314,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port4_Queue_Drop_Page_threshold_Control0 */
        /* offset address */    0xA90414,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port5_Queue_Drop_Page_threshold_Control0 */
        /* offset address */    0xA90514,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port6_Queue_Drop_Page_threshold_Control0 */
        /* offset address */    0xA90614,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port7_Queue_Drop_Page_threshold_Control0 */
        /* offset address */    0xA90714,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port8_Queue_Drop_Page_threshold_Control0 */
        /* offset address */    0xA90814,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port9_Queue_Drop_Page_threshold_Control0 */
        /* offset address */    0xA90914,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port10_Queue_Drop_Page_threshold_Control0 */
        /* offset address */    0xA90A14,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port11_Queue_Drop_Page_threshold_Control0 */
        /* offset address */    0xA90B14,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port12_Queue_Drop_Page_threshold_Control0 */
        /* offset address */    0xA90C14,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port13_Queue_Drop_Page_threshold_Control0 */
        /* offset address */    0xA90D14,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port14_Queue_Drop_Page_threshold_Control0 */
        /* offset address */    0xA90E14,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port15_Queue_Drop_Page_threshold_Control0 */
        /* offset address */    0xA90F14,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port16_Queue_Drop_Page_threshold_Control0 */
        /* offset address */    0xA91014,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port17_Queue_Drop_Page_threshold_Control0 */
        /* offset address */    0xA91114,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port18_Queue_Drop_Page_threshold_Control0 */
        /* offset address */    0xA91214,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port19_Queue_Drop_Page_threshold_Control0 */
        /* offset address */    0xA91314,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port20_Queue_Drop_Page_threshold_Control0 */
        /* offset address */    0xA91414,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port21_Queue_Drop_Page_threshold_Control0 */
        /* offset address */    0xA91514,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port22_Queue_Drop_Page_threshold_Control0 */
        /* offset address */    0xA91614,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port23_Queue_Drop_Page_threshold_Control0 */
        /* offset address */    0xA91714,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port24_Queue_Drop_Page_threshold_Control0 */
        /* offset address */    0xA91814,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port0_Queue_Drop_Page_threshold_Control1 */
        /* offset address */    0xA90018,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port1_Queue_Drop_Page_threshold_Control1 */
        /* offset address */    0xA90118,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port2_Queue_Drop_Page_threshold_Control1 */
        /* offset address */    0xA90218,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port3_Queue_Drop_Page_threshold_Control1 */
        /* offset address */    0xA90318,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port4_Queue_Drop_Page_threshold_Control1 */
        /* offset address */    0xA90418,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port5_Queue_Drop_Page_threshold_Control1 */
        /* offset address */    0xA90518,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port6_Queue_Drop_Page_threshold_Control1 */
        /* offset address */    0xA90618,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port7_Queue_Drop_Page_threshold_Control1 */
        /* offset address */    0xA90718,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port8_Queue_Drop_Page_threshold_Control1 */
        /* offset address */    0xA90818,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port9_Queue_Drop_Page_threshold_Control1 */
        /* offset address */    0xA90918,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port10_Queue_Drop_Page_threshold_Control1 */
        /* offset address */    0xA90A18,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port11_Queue_Drop_Page_threshold_Control1 */
        /* offset address */    0xA90B18,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port12_Queue_Drop_Page_threshold_Control1 */
        /* offset address */    0xA90C18,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port13_Queue_Drop_Page_threshold_Control1 */
        /* offset address */    0xA90D18,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port14_Queue_Drop_Page_threshold_Control1 */
        /* offset address */    0xA90E18,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port15_Queue_Drop_Page_threshold_Control1 */
        /* offset address */    0xA90F18,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port16_Queue_Drop_Page_threshold_Control1 */
        /* offset address */    0xA91018,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port17_Queue_Drop_Page_threshold_Control1 */
        /* offset address */    0xA91118,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port18_Queue_Drop_Page_threshold_Control1 */
        /* offset address */    0xA91218,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port19_Queue_Drop_Page_threshold_Control1 */
        /* offset address */    0xA91318,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port20_Queue_Drop_Page_threshold_Control1 */
        /* offset address */    0xA91418,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port21_Queue_Drop_Page_threshold_Control1 */
        /* offset address */    0xA91518,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port22_Queue_Drop_Page_threshold_Control1 */
        /* offset address */    0xA91618,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port23_Queue_Drop_Page_threshold_Control1 */
        /* offset address */    0xA91718,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        Port24_Queue_Drop_Page_threshold_Control1 */
        /* offset address */    0xA91818,
        /* field numbers */     4,
        /* register fields */   PORT_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0x2D002D
    },
    {   /* register name        port0_drop_ability_control */
        /* offset address */    0xA9001C,
        /* field numbers */     3,
        /* register fields */   PORT_DROP_ABILITY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        port1_drop_ability_control */
        /* offset address */    0xA9011C,
        /* field numbers */     3,
        /* register fields */   PORT_DROP_ABILITY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        port2_drop_ability_control */
        /* offset address */    0xA9021C,
        /* field numbers */     3,
        /* register fields */   PORT_DROP_ABILITY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        port3_drop_ability_control */
        /* offset address */    0xA9031C,
        /* field numbers */     3,
        /* register fields */   PORT_DROP_ABILITY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        port4_drop_ability_control */
        /* offset address */    0xA9041C,
        /* field numbers */     3,
        /* register fields */   PORT_DROP_ABILITY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        port5_drop_ability_control */
        /* offset address */    0xA9051C,
        /* field numbers */     3,
        /* register fields */   PORT_DROP_ABILITY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        port6_drop_ability_control */
        /* offset address */    0xA9061C,
        /* field numbers */     3,
        /* register fields */   PORT_DROP_ABILITY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        port7_drop_ability_control */
        /* offset address */    0xA9071C,
        /* field numbers */     3,
        /* register fields */   PORT_DROP_ABILITY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        port8_drop_ability_control */
        /* offset address */    0xA9081C,
        /* field numbers */     3,
        /* register fields */   PORT_DROP_ABILITY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        port9_drop_ability_control */
        /* offset address */    0xA9091C,
        /* field numbers */     3,
        /* register fields */   PORT_DROP_ABILITY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        port10_drop_ability_control */
        /* offset address */    0xA90A1C,
        /* field numbers */     3,
        /* register fields */   PORT_DROP_ABILITY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        port11_drop_ability_control */
        /* offset address */    0xA90B1C,
        /* field numbers */     3,
        /* register fields */   PORT_DROP_ABILITY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        port12_drop_ability_control */
        /* offset address */    0xA90C1C,
        /* field numbers */     3,
        /* register fields */   PORT_DROP_ABILITY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        port13_drop_ability_control */
        /* offset address */    0xA90D1C,
        /* field numbers */     3,
        /* register fields */   PORT_DROP_ABILITY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        port14_drop_ability_control */
        /* offset address */    0xA90E1C,
        /* field numbers */     3,
        /* register fields */   PORT_DROP_ABILITY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        port15_drop_ability_control */
        /* offset address */    0xA90F1C,
        /* field numbers */     3,
        /* register fields */   PORT_DROP_ABILITY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        port16_drop_ability_control */
        /* offset address */    0xA9101C,
        /* field numbers */     3,
        /* register fields */   PORT_DROP_ABILITY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        port17_drop_ability_control */
        /* offset address */    0xA9111C,
        /* field numbers */     3,
        /* register fields */   PORT_DROP_ABILITY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        port18_drop_ability_control */
        /* offset address */    0xA9121C,
        /* field numbers */     3,
        /* register fields */   PORT_DROP_ABILITY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        port19_drop_ability_control */
        /* offset address */    0xA9131C,
        /* field numbers */     3,
        /* register fields */   PORT_DROP_ABILITY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        port20_drop_ability_control */
        /* offset address */    0xA9141C,
        /* field numbers */     3,
        /* register fields */   PORT_DROP_ABILITY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        port21_drop_ability_control */
        /* offset address */    0xA9151C,
        /* field numbers */     3,
        /* register fields */   PORT_DROP_ABILITY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        port22_drop_ability_control */
        /* offset address */    0xA9161C,
        /* field numbers */     3,
        /* register fields */   PORT_DROP_ABILITY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        port23_drop_ability_control */
        /* offset address */    0xA9171C,
        /* field numbers */     3,
        /* register fields */   PORT_DROP_ABILITY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        port24_drop_ability_control */
        /* offset address */    0xA9181C,
        /* field numbers */     3,
        /* register fields */   PORT_DROP_ABILITY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port0_Flow_control_off_port_Rx_drop_threshold_Control */
        /* offset address */    0xA90020,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x64
    },
    {   /* register name        Port1_Flow_control_off_port_Rx_drop_threshold_Control */
        /* offset address */    0xA90120,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x64
    },
    {   /* register name        Port2_Flow_control_off_port_Rx_drop_threshold_Control */
        /* offset address */    0xA90220,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x64
    },
    {   /* register name        Port3_Flow_control_off_port_Rx_drop_threshold_Control */
        /* offset address */    0xA90320,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x64
    },
    {   /* register name        Port4_Flow_control_off_port_Rx_drop_threshold_Control */
        /* offset address */    0xA90420,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x64
    },
    {   /* register name        Port5_Flow_control_off_port_Rx_drop_threshold_Control */
        /* offset address */    0xA90520,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x64
    },
    {   /* register name        Port6_Flow_control_off_port_Rx_drop_threshold_Control */
        /* offset address */    0xA90620,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x64
    },
    {   /* register name        Port7_Flow_control_off_port_Rx_drop_threshold_Control */
        /* offset address */    0xA90720,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x64
    },
    {   /* register name        Port8_Flow_control_off_port_Rx_drop_threshold_Control */
        /* offset address */    0xA90820,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x64
    },
    {   /* register name        Port9_Flow_control_off_port_Rx_drop_threshold_Control */
        /* offset address */    0xA90920,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x64
    },
    {   /* register name        Port10_Flow_control_off_port_Rx_drop_threshold_Control */
        /* offset address */    0xA90A20,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x64
    },
    {   /* register name        Port11_Flow_control_off_port_Rx_drop_threshold_Control */
        /* offset address */    0xA90B20,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x64
    },
    {   /* register name        Port12_Flow_control_off_port_Rx_drop_threshold_Control */
        /* offset address */    0xA90C20,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x64
    },
    {   /* register name        Port13_Flow_control_off_port_Rx_drop_threshold_Control */
        /* offset address */    0xA90D20,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x64
    },
    {   /* register name        Port14_Flow_control_off_port_Rx_drop_threshold_Control */
        /* offset address */    0xA90E20,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x64
    },
    {   /* register name        Port15_Flow_control_off_port_Rx_drop_threshold_Control */
        /* offset address */    0xA90F20,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x64
    },
    {   /* register name        Port16_Flow_control_off_port_Rx_drop_threshold_Control */
        /* offset address */    0xA91020,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x64
    },
    {   /* register name        Port17_Flow_control_off_port_Rx_drop_threshold_Control */
        /* offset address */    0xA91120,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x64
    },
    {   /* register name        Port18_Flow_control_off_port_Rx_drop_threshold_Control */
        /* offset address */    0xA91220,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x64
    },
    {   /* register name        Port19_Flow_control_off_port_Rx_drop_threshold_Control */
        /* offset address */    0xA91320,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x64
    },
    {   /* register name        Port20_Flow_control_off_port_Rx_drop_threshold_Control */
        /* offset address */    0xA91420,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x64
    },
    {   /* register name        Port21_Flow_control_off_port_Rx_drop_threshold_Control */
        /* offset address */    0xA91520,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x64
    },
    {   /* register name        Port22_Flow_control_off_port_Rx_drop_threshold_Control */
        /* offset address */    0xA91620,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x64
    },
    {   /* register name        Port23_Flow_control_off_port_Rx_drop_threshold_Control */
        /* offset address */    0xA91720,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x64
    },
    {   /* register name        Port24_Flow_control_off_port_Rx_drop_threshold_Control */
        /* offset address */    0xA91820,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x64
    },
    {   /* register name        Port0_Flow_control_ability_force_mode_Control */
        /* offset address */    0xA90024,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port1_Flow_control_ability_force_mode_Control */
        /* offset address */    0xA90124,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port2_Flow_control_ability_force_mode_Control */
        /* offset address */    0xA90224,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port3_Flow_control_ability_force_mode_Control */
        /* offset address */    0xA90324,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port4_Flow_control_ability_force_mode_Control */
        /* offset address */    0xA90424,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port5_Flow_control_ability_force_mode_Control */
        /* offset address */    0xA90524,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port6_Flow_control_ability_force_mode_Control */
        /* offset address */    0xA90624,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port7_Flow_control_ability_force_mode_Control */
        /* offset address */    0xA90724,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port8_Flow_control_ability_force_mode_Control */
        /* offset address */    0xA90824,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port9_Flow_control_ability_force_mode_Control */
        /* offset address */    0xA90924,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port10_Flow_control_ability_force_mode_Control */
        /* offset address */    0xA90A24,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port11_Flow_control_ability_force_mode_Control */
        /* offset address */    0xA90B24,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port12_Flow_control_ability_force_mode_Control */
        /* offset address */    0xA90C24,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port13_Flow_control_ability_force_mode_Control */
        /* offset address */    0xA90D24,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port14_Flow_control_ability_force_mode_Control */
        /* offset address */    0xA90E24,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port15_Flow_control_ability_force_mode_Control */
        /* offset address */    0xA90F24,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port16_Flow_control_ability_force_mode_Control */
        /* offset address */    0xA91024,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port17_Flow_control_ability_force_mode_Control */
        /* offset address */    0xA91124,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port18_Flow_control_ability_force_mode_Control */
        /* offset address */    0xA91224,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port19_Flow_control_ability_force_mode_Control */
        /* offset address */    0xA91324,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port20_Flow_control_ability_force_mode_Control */
        /* offset address */    0xA91424,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port21_Flow_control_ability_force_mode_Control */
        /* offset address */    0xA91524,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port22_Flow_control_ability_force_mode_Control */
        /* offset address */    0xA91624,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port23_Flow_control_ability_force_mode_Control */
        /* offset address */    0xA91724,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port24_Flow_control_ability_force_mode_Control */
        /* offset address */    0xA91824,
        /* field numbers */     2,
        /* register fields */   PORT_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port0_Rx_Page_Drop_High_threshold_Control */
        /* offset address */    0xA90028,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port1_Rx_Page_Drop_High_threshold_Control */
        /* offset address */    0xA90128,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port2_Rx_Page_Drop_High_threshold_Control */
        /* offset address */    0xA90228,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port3_Rx_Page_Drop_High_threshold_Control */
        /* offset address */    0xA90328,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port4_Rx_Page_Drop_High_threshold_Control */
        /* offset address */    0xA90428,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port5_Rx_Page_Drop_High_threshold_Control */
        /* offset address */    0xA90528,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port6_Rx_Page_Drop_High_threshold_Control */
        /* offset address */    0xA90628,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port7_Rx_Page_Drop_High_threshold_Control */
        /* offset address */    0xA90728,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port8_Rx_Page_Drop_High_threshold_Control */
        /* offset address */    0xA90828,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port9_Rx_Page_Drop_High_threshold_Control */
        /* offset address */    0xA90928,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port10_Rx_Page_Drop_High_threshold_Control */
        /* offset address */    0xA90A28,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port11_Rx_Page_Drop_High_threshold_Control */
        /* offset address */    0xA90B28,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port12_Rx_Page_Drop_High_threshold_Control */
        /* offset address */    0xA90C28,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port13_Rx_Page_Drop_High_threshold_Control */
        /* offset address */    0xA90D28,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port14_Rx_Page_Drop_High_threshold_Control */
        /* offset address */    0xA90E28,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port15_Rx_Page_Drop_High_threshold_Control */
        /* offset address */    0xA90F28,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port16_Rx_Page_Drop_High_threshold_Control */
        /* offset address */    0xA91028,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port17_Rx_Page_Drop_High_threshold_Control */
        /* offset address */    0xA91128,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port18_Rx_Page_Drop_High_threshold_Control */
        /* offset address */    0xA91228,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port19_Rx_Page_Drop_High_threshold_Control */
        /* offset address */    0xA91328,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port20_Rx_Page_Drop_High_threshold_Control */
        /* offset address */    0xA91428,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port21_Rx_Page_Drop_High_threshold_Control */
        /* offset address */    0xA91528,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port22_Rx_Page_Drop_High_threshold_Control */
        /* offset address */    0xA91628,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port23_Rx_Page_Drop_High_threshold_Control */
        /* offset address */    0xA91728,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port24_Rx_Page_Drop_High_threshold_Control */
        /* offset address */    0xA91828,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x24002D
    },
    {   /* register name        Port0_Rx_Page_Drop_Low_threshold_Control */
        /* offset address */    0xA9002C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port1_Rx_Page_Drop_Low_threshold_Control */
        /* offset address */    0xA9012C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port2_Rx_Page_Drop_Low_threshold_Control */
        /* offset address */    0xA9022C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port3_Rx_Page_Drop_Low_threshold_Control */
        /* offset address */    0xA9032C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port4_Rx_Page_Drop_Low_threshold_Control */
        /* offset address */    0xA9042C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port5_Rx_Page_Drop_Low_threshold_Control */
        /* offset address */    0xA9052C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port6_Rx_Page_Drop_Low_threshold_Control */
        /* offset address */    0xA9062C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port7_Rx_Page_Drop_Low_threshold_Control */
        /* offset address */    0xA9072C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port8_Rx_Page_Drop_Low_threshold_Control */
        /* offset address */    0xA9082C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port9_Rx_Page_Drop_Low_threshold_Control */
        /* offset address */    0xA9092C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port10_Rx_Page_Drop_Low_threshold_Control */
        /* offset address */    0xA90A2C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port11_Rx_Page_Drop_Low_threshold_Control */
        /* offset address */    0xA90B2C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port12_Rx_Page_Drop_Low_threshold_Control */
        /* offset address */    0xA90C2C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port13_Rx_Page_Drop_Low_threshold_Control */
        /* offset address */    0xA90D2C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port14_Rx_Page_Drop_Low_threshold_Control */
        /* offset address */    0xA90E2C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port15_Rx_Page_Drop_Low_threshold_Control */
        /* offset address */    0xA90F2C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port16_Rx_Page_Drop_Low_threshold_Control */
        /* offset address */    0xA9102C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port17_Rx_Page_Drop_Low_threshold_Control */
        /* offset address */    0xA9112C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port18_Rx_Page_Drop_Low_threshold_Control */
        /* offset address */    0xA9122C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port19_Rx_Page_Drop_Low_threshold_Control */
        /* offset address */    0xA9132C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port20_Rx_Page_Drop_Low_threshold_Control */
        /* offset address */    0xA9142C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port21_Rx_Page_Drop_Low_threshold_Control */
        /* offset address */    0xA9152C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port22_Rx_Page_Drop_Low_threshold_Control */
        /* offset address */    0xA9162C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port23_Rx_Page_Drop_Low_threshold_Control */
        /* offset address */    0xA9172C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        Port24_Rx_Page_Drop_Low_threshold_Control */
        /* offset address */    0xA9182C,
        /* field numbers */     4,
        /* register fields */   PORT_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_FIELDS,
        /* default value */     0x6000C
    },
    {   /* register name        INNER_TAG_PRIORITY_REMARKING_TABLE_CONTROL0 */
        /* offset address */    0x320000,
        /* field numbers */     9,
        /* register fields */   INNER_TAG_PRIORITY_REMARKING_TABLE_CONTROL0_FIELDS,
        /* default value */     0xFAC681
    },
    {   /* register name        INNER_TAG_PRIORITY_REMARKING_TABLE_CONTROL1 */
        /* offset address */    0x320004,
        /* field numbers */     9,
        /* register fields */   INNER_TAG_PRIORITY_REMARKING_TABLE_CONTROL1_FIELDS,
        /* default value */     0xFAC681
    },
    {   /* register name        OUTER_TAG_PRIORITY_AND_DEI_REMARKING_TABLE_CONTROL0 */
        /* offset address */    0x320008,
        /* field numbers */     16,
        /* register fields */   OUTER_TAG_PRIORITY_AND_DEI_REMARKING_TABLE_CONTROL0_FIELDS,
        /* default value */     0x76543201
    },
    {   /* register name        OUTER_TAG_PRIORITY_AND_DEI_REMARKING_TABLE_CONTROL1 */
        /* offset address */    0x32000C,
        /* field numbers */     16,
        /* register fields */   OUTER_TAG_PRIORITY_AND_DEI_REMARKING_TABLE_CONTROL1_FIELDS,
        /* default value */     0x76543201
    },
    {   /* register name        DSCP_REMARKING_TABLE_Control0 */
        /* offset address */    0x320010,
        /* field numbers */     6,
        /* register fields */   DSCP_REMARKING_TABLE_CONTROL0_FIELDS,
        /* default value */     0x20610200
    },
    {   /* register name        DSCP_REMARKING_TABLE_Control1 */
        /* offset address */    0x320014,
        /* field numbers */     4,
        /* register fields */   DSCP_REMARKING_TABLE_CONTROL1_FIELDS,
        /* default value */     0x38C28
    },
    {   /* register name        DSCP_REMARKING_TABLE_Control2 */
        /* offset address */    0x320018,
        /* field numbers */     6,
        /* register fields */   DSCP_REMARKING_TABLE_CONTROL2_FIELDS,
        /* default value */     0x20610200
    },
    {   /* register name        DSCP_REMARKING_TABLE_Control3 */
        /* offset address */    0x32001C,
        /* field numbers */     4,
        /* register fields */   DSCP_REMARKING_TABLE_CONTROL3_FIELDS,
        /* default value */     0x38C28
    },
    {   /* register name        PORT0_Priority_Remarking_Control */
        /* offset address */    0xB20000,
        /* field numbers */     7,
        /* register fields */   PORT_PRIORITY_REMARKING_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT1_Priority_Remarking_Control */
        /* offset address */    0xB20100,
        /* field numbers */     7,
        /* register fields */   PORT_PRIORITY_REMARKING_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT2_Priority_Remarking_Control */
        /* offset address */    0xB20200,
        /* field numbers */     7,
        /* register fields */   PORT_PRIORITY_REMARKING_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT3_Priority_Remarking_Control */
        /* offset address */    0xB20300,
        /* field numbers */     7,
        /* register fields */   PORT_PRIORITY_REMARKING_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT4_Priority_Remarking_Control */
        /* offset address */    0xB20400,
        /* field numbers */     7,
        /* register fields */   PORT_PRIORITY_REMARKING_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT5_Priority_Remarking_Control */
        /* offset address */    0xB20500,
        /* field numbers */     7,
        /* register fields */   PORT_PRIORITY_REMARKING_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT6_Priority_Remarking_Control */
        /* offset address */    0xB20600,
        /* field numbers */     7,
        /* register fields */   PORT_PRIORITY_REMARKING_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT7_Priority_Remarking_Control */
        /* offset address */    0xB20700,
        /* field numbers */     7,
        /* register fields */   PORT_PRIORITY_REMARKING_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT8_Priority_Remarking_Control */
        /* offset address */    0xB20800,
        /* field numbers */     7,
        /* register fields */   PORT_PRIORITY_REMARKING_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT9_Priority_Remarking_Control */
        /* offset address */    0xB20900,
        /* field numbers */     7,
        /* register fields */   PORT_PRIORITY_REMARKING_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT10_Priority_Remarking_Control */
        /* offset address */    0xB20A00,
        /* field numbers */     7,
        /* register fields */   PORT_PRIORITY_REMARKING_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT11_Priority_Remarking_Control */
        /* offset address */    0xB20B00,
        /* field numbers */     7,
        /* register fields */   PORT_PRIORITY_REMARKING_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT12_Priority_Remarking_Control */
        /* offset address */    0xB20C00,
        /* field numbers */     7,
        /* register fields */   PORT_PRIORITY_REMARKING_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT13_Priority_Remarking_Control */
        /* offset address */    0xB20D00,
        /* field numbers */     7,
        /* register fields */   PORT_PRIORITY_REMARKING_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT14_Priority_Remarking_Control */
        /* offset address */    0xB20E00,
        /* field numbers */     7,
        /* register fields */   PORT_PRIORITY_REMARKING_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT15_Priority_Remarking_Control */
        /* offset address */    0xB20F00,
        /* field numbers */     7,
        /* register fields */   PORT_PRIORITY_REMARKING_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT16_Priority_Remarking_Control */
        /* offset address */    0xB21000,
        /* field numbers */     7,
        /* register fields */   PORT_PRIORITY_REMARKING_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT17_Priority_Remarking_Control */
        /* offset address */    0xB21100,
        /* field numbers */     7,
        /* register fields */   PORT_PRIORITY_REMARKING_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT18_Priority_Remarking_Control */
        /* offset address */    0xB21200,
        /* field numbers */     7,
        /* register fields */   PORT_PRIORITY_REMARKING_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT19_Priority_Remarking_Control */
        /* offset address */    0xB21300,
        /* field numbers */     7,
        /* register fields */   PORT_PRIORITY_REMARKING_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT20_Priority_Remarking_Control */
        /* offset address */    0xB21400,
        /* field numbers */     7,
        /* register fields */   PORT_PRIORITY_REMARKING_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT21_Priority_Remarking_Control */
        /* offset address */    0xB21500,
        /* field numbers */     7,
        /* register fields */   PORT_PRIORITY_REMARKING_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT22_Priority_Remarking_Control */
        /* offset address */    0xB21600,
        /* field numbers */     7,
        /* register fields */   PORT_PRIORITY_REMARKING_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT23_Priority_Remarking_Control */
        /* offset address */    0xB21700,
        /* field numbers */     7,
        /* register fields */   PORT_PRIORITY_REMARKING_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT24_Priority_Remarking_Control */
        /* offset address */    0xB21800,
        /* field numbers */     7,
        /* register fields */   PORT_PRIORITY_REMARKING_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Ingress_Bandwidth_Control_Drop_Threshold_Global_Control */
        /* offset address */    0x330000,
        /* field numbers */     3,
        /* register fields */   INGRESS_BANDWIDTH_CONTROL_DROP_THRESHOLD_GLOBAL_CONTROL_FIELDS,
        /* default value */     0x10
    },
    {   /* register name        Port0_Ingress_Bandwidth_High_Low_Threshold_Control0 */
        /* offset address */    0xB30000,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port1_Ingress_Bandwidth_High_Low_Threshold_Control0 */
        /* offset address */    0xB30100,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port2_Ingress_Bandwidth_High_Low_Threshold_Control0 */
        /* offset address */    0xB30200,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port3_Ingress_Bandwidth_High_Low_Threshold_Control0 */
        /* offset address */    0xB30300,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port4_Ingress_Bandwidth_High_Low_Threshold_Control0 */
        /* offset address */    0xB30400,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port5_Ingress_Bandwidth_High_Low_Threshold_Control0 */
        /* offset address */    0xB30500,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port6_Ingress_Bandwidth_High_Low_Threshold_Control0 */
        /* offset address */    0xB30600,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port7_Ingress_Bandwidth_High_Low_Threshold_Control0 */
        /* offset address */    0xB30700,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port8_Ingress_Bandwidth_High_Low_Threshold_Control0 */
        /* offset address */    0xB30800,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port9_Ingress_Bandwidth_High_Low_Threshold_Control0 */
        /* offset address */    0xB30900,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port10_Ingress_Bandwidth_High_Low_Threshold_Control0 */
        /* offset address */    0xB30A00,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port11_Ingress_Bandwidth_High_Low_Threshold_Control0 */
        /* offset address */    0xB30B00,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port12_Ingress_Bandwidth_High_Low_Threshold_Control0 */
        /* offset address */    0xB30C00,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port13_Ingress_Bandwidth_High_Low_Threshold_Control0 */
        /* offset address */    0xB30D00,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port14_Ingress_Bandwidth_High_Low_Threshold_Control0 */
        /* offset address */    0xB30E00,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port15_Ingress_Bandwidth_High_Low_Threshold_Control0 */
        /* offset address */    0xB30F00,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port16_Ingress_Bandwidth_High_Low_Threshold_Control0 */
        /* offset address */    0xB31000,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port17_Ingress_Bandwidth_High_Low_Threshold_Control0 */
        /* offset address */    0xB31100,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port18_Ingress_Bandwidth_High_Low_Threshold_Control0 */
        /* offset address */    0xB31200,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port19_Ingress_Bandwidth_High_Low_Threshold_Control0 */
        /* offset address */    0xB31300,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port20_Ingress_Bandwidth_High_Low_Threshold_Control0 */
        /* offset address */    0xB31400,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port21_Ingress_Bandwidth_High_Low_Threshold_Control0 */
        /* offset address */    0xB31500,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port22_Ingress_Bandwidth_High_Low_Threshold_Control0 */
        /* offset address */    0xB31600,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port23_Ingress_Bandwidth_High_Low_Threshold_Control0 */
        /* offset address */    0xB31700,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port24_Ingress_Bandwidth_High_Low_Threshold_Control0 */
        /* offset address */    0xB31800,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port0_Ingress_Bandwidth__Rate_Control0 */
        /* offset address */    0xB30004,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port1_Ingress_Bandwidth__Rate_Control0 */
        /* offset address */    0xB30104,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port2_Ingress_Bandwidth__Rate_Control0 */
        /* offset address */    0xB30204,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port3_Ingress_Bandwidth__Rate_Control0 */
        /* offset address */    0xB30304,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port4_Ingress_Bandwidth__Rate_Control0 */
        /* offset address */    0xB30404,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port5_Ingress_Bandwidth__Rate_Control0 */
        /* offset address */    0xB30504,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port6_Ingress_Bandwidth__Rate_Control0 */
        /* offset address */    0xB30604,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port7_Ingress_Bandwidth__Rate_Control0 */
        /* offset address */    0xB30704,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port8_Ingress_Bandwidth__Rate_Control0 */
        /* offset address */    0xB30804,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port9_Ingress_Bandwidth__Rate_Control0 */
        /* offset address */    0xB30904,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port10_Ingress_Bandwidth__Rate_Control0 */
        /* offset address */    0xB30A04,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port11_Ingress_Bandwidth__Rate_Control0 */
        /* offset address */    0xB30B04,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port12_Ingress_Bandwidth__Rate_Control0 */
        /* offset address */    0xB30C04,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port13_Ingress_Bandwidth__Rate_Control0 */
        /* offset address */    0xB30D04,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port14_Ingress_Bandwidth__Rate_Control0 */
        /* offset address */    0xB30E04,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port15_Ingress_Bandwidth__Rate_Control0 */
        /* offset address */    0xB30F04,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port16_Ingress_Bandwidth__Rate_Control0 */
        /* offset address */    0xB31004,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port17_Ingress_Bandwidth__Rate_Control0 */
        /* offset address */    0xB31104,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port18_Ingress_Bandwidth__Rate_Control0 */
        /* offset address */    0xB31204,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port19_Ingress_Bandwidth__Rate_Control0 */
        /* offset address */    0xB31304,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port20_Ingress_Bandwidth__Rate_Control0 */
        /* offset address */    0xB31404,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port21_Ingress_Bandwidth__Rate_Control0 */
        /* offset address */    0xB31504,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port22_Ingress_Bandwidth__Rate_Control0 */
        /* offset address */    0xB31604,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port23_Ingress_Bandwidth__Rate_Control0 */
        /* offset address */    0xB31704,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port24_Ingress_Bandwidth__Rate_Control0 */
        /* offset address */    0xB31804,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port0_Ingress_Bandwidth_High_Low_Threshold_Control1 */
        /* offset address */    0xB30008,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port1_Ingress_Bandwidth_High_Low_Threshold_Control1 */
        /* offset address */    0xB30108,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port2_Ingress_Bandwidth_High_Low_Threshold_Control1 */
        /* offset address */    0xB30208,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port3_Ingress_Bandwidth_High_Low_Threshold_Control1 */
        /* offset address */    0xB30308,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port4_Ingress_Bandwidth_High_Low_Threshold_Control1 */
        /* offset address */    0xB30408,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port5_Ingress_Bandwidth_High_Low_Threshold_Control1 */
        /* offset address */    0xB30508,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port6_Ingress_Bandwidth_High_Low_Threshold_Control1 */
        /* offset address */    0xB30608,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port7_Ingress_Bandwidth_High_Low_Threshold_Control1 */
        /* offset address */    0xB30708,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port8_Ingress_Bandwidth_High_Low_Threshold_Control1 */
        /* offset address */    0xB30808,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port9_Ingress_Bandwidth_High_Low_Threshold_Control1 */
        /* offset address */    0xB30908,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port10_Ingress_Bandwidth_High_Low_Threshold_Control1 */
        /* offset address */    0xB30A08,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port11_Ingress_Bandwidth_High_Low_Threshold_Control1 */
        /* offset address */    0xB30B08,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port12_Ingress_Bandwidth_High_Low_Threshold_Control1 */
        /* offset address */    0xB30C08,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port13_Ingress_Bandwidth_High_Low_Threshold_Control1 */
        /* offset address */    0xB30D08,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port14_Ingress_Bandwidth_High_Low_Threshold_Control1 */
        /* offset address */    0xB30E08,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port15_Ingress_Bandwidth_High_Low_Threshold_Control1 */
        /* offset address */    0xB30F08,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port16_Ingress_Bandwidth_High_Low_Threshold_Control1 */
        /* offset address */    0xB31008,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port17_Ingress_Bandwidth_High_Low_Threshold_Control1 */
        /* offset address */    0xB31108,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port18_Ingress_Bandwidth_High_Low_Threshold_Control1 */
        /* offset address */    0xB31208,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port19_Ingress_Bandwidth_High_Low_Threshold_Control1 */
        /* offset address */    0xB31308,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port20_Ingress_Bandwidth_High_Low_Threshold_Control1 */
        /* offset address */    0xB31408,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port21_Ingress_Bandwidth_High_Low_Threshold_Control1 */
        /* offset address */    0xB31508,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port22_Ingress_Bandwidth_High_Low_Threshold_Control1 */
        /* offset address */    0xB31608,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port23_Ingress_Bandwidth_High_Low_Threshold_Control1 */
        /* offset address */    0xB31708,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port24_Ingress_Bandwidth_High_Low_Threshold_Control1 */
        /* offset address */    0xB31808,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFFFFF7
    },
    {   /* register name        Port0_Ingress_Bandwidth__Rate_Control1 */
        /* offset address */    0xB3000C,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port1_Ingress_Bandwidth__Rate_Control1 */
        /* offset address */    0xB3010C,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port2_Ingress_Bandwidth__Rate_Control1 */
        /* offset address */    0xB3020C,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port3_Ingress_Bandwidth__Rate_Control1 */
        /* offset address */    0xB3030C,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port4_Ingress_Bandwidth__Rate_Control1 */
        /* offset address */    0xB3040C,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port5_Ingress_Bandwidth__Rate_Control1 */
        /* offset address */    0xB3050C,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port6_Ingress_Bandwidth__Rate_Control1 */
        /* offset address */    0xB3060C,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port7_Ingress_Bandwidth__Rate_Control1 */
        /* offset address */    0xB3070C,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port8_Ingress_Bandwidth__Rate_Control1 */
        /* offset address */    0xB3080C,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port9_Ingress_Bandwidth__Rate_Control1 */
        /* offset address */    0xB3090C,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port10_Ingress_Bandwidth__Rate_Control1 */
        /* offset address */    0xB30A0C,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port11_Ingress_Bandwidth__Rate_Control1 */
        /* offset address */    0xB30B0C,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port12_Ingress_Bandwidth__Rate_Control1 */
        /* offset address */    0xB30C0C,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port13_Ingress_Bandwidth__Rate_Control1 */
        /* offset address */    0xB30D0C,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port14_Ingress_Bandwidth__Rate_Control1 */
        /* offset address */    0xB30E0C,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port15_Ingress_Bandwidth__Rate_Control1 */
        /* offset address */    0xB30F0C,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port16_Ingress_Bandwidth__Rate_Control1 */
        /* offset address */    0xB3100C,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port17_Ingress_Bandwidth__Rate_Control1 */
        /* offset address */    0xB3110C,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port18_Ingress_Bandwidth__Rate_Control1 */
        /* offset address */    0xB3120C,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port19_Ingress_Bandwidth__Rate_Control1 */
        /* offset address */    0xB3130C,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port20_Ingress_Bandwidth__Rate_Control1 */
        /* offset address */    0xB3140C,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port21_Ingress_Bandwidth__Rate_Control1 */
        /* offset address */    0xB3150C,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port22_Ingress_Bandwidth__Rate_Control1 */
        /* offset address */    0xB3160C,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port23_Ingress_Bandwidth__Rate_Control1 */
        /* offset address */    0xB3170C,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port24_Ingress_Bandwidth__Rate_Control1 */
        /* offset address */    0xB3180C,
        /* field numbers */     4,
        /* register fields */   PORT_INGRESS_BANDWIDTH__RATE_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port0_Ingress_Bandwidth_Algorithm_Control */
        /* offset address */    0xB30010,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port1_Ingress_Bandwidth_Algorithm_Control */
        /* offset address */    0xB30110,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port2_Ingress_Bandwidth_Algorithm_Control */
        /* offset address */    0xB30210,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port3_Ingress_Bandwidth_Algorithm_Control */
        /* offset address */    0xB30310,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port4_Ingress_Bandwidth_Algorithm_Control */
        /* offset address */    0xB30410,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port5_Ingress_Bandwidth_Algorithm_Control */
        /* offset address */    0xB30510,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port6_Ingress_Bandwidth_Algorithm_Control */
        /* offset address */    0xB30610,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port7_Ingress_Bandwidth_Algorithm_Control */
        /* offset address */    0xB30710,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port8_Ingress_Bandwidth_Algorithm_Control */
        /* offset address */    0xB30810,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port9_Ingress_Bandwidth_Algorithm_Control */
        /* offset address */    0xB30910,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port10_Ingress_Bandwidth_Algorithm_Control */
        /* offset address */    0xB30A10,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port11_Ingress_Bandwidth_Algorithm_Control */
        /* offset address */    0xB30B10,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port12_Ingress_Bandwidth_Algorithm_Control */
        /* offset address */    0xB30C10,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port13_Ingress_Bandwidth_Algorithm_Control */
        /* offset address */    0xB30D10,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port14_Ingress_Bandwidth_Algorithm_Control */
        /* offset address */    0xB30E10,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port15_Ingress_Bandwidth_Algorithm_Control */
        /* offset address */    0xB30F10,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port16_Ingress_Bandwidth_Algorithm_Control */
        /* offset address */    0xB31010,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port17_Ingress_Bandwidth_Algorithm_Control */
        /* offset address */    0xB31110,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port18_Ingress_Bandwidth_Algorithm_Control */
        /* offset address */    0xB31210,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port19_Ingress_Bandwidth_Algorithm_Control */
        /* offset address */    0xB31310,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port20_Ingress_Bandwidth_Algorithm_Control */
        /* offset address */    0xB31410,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port21_Ingress_Bandwidth_Algorithm_Control */
        /* offset address */    0xB31510,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port22_Ingress_Bandwidth_Algorithm_Control */
        /* offset address */    0xB31610,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port23_Ingress_Bandwidth_Algorithm_Control */
        /* offset address */    0xB31710,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port24_Ingress_Bandwidth_Algorithm_Control */
        /* offset address */    0xB31810,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Port0_Ingress_Bandwidth_Packet_Length_Control0 */
        /* offset address */    0xB30014,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port1_Ingress_Bandwidth_Packet_Length_Control0 */
        /* offset address */    0xB30114,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port2_Ingress_Bandwidth_Packet_Length_Control0 */
        /* offset address */    0xB30214,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port3_Ingress_Bandwidth_Packet_Length_Control0 */
        /* offset address */    0xB30314,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port4_Ingress_Bandwidth_Packet_Length_Control0 */
        /* offset address */    0xB30414,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port5_Ingress_Bandwidth_Packet_Length_Control0 */
        /* offset address */    0xB30514,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port6_Ingress_Bandwidth_Packet_Length_Control0 */
        /* offset address */    0xB30614,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port7_Ingress_Bandwidth_Packet_Length_Control0 */
        /* offset address */    0xB30714,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port8_Ingress_Bandwidth_Packet_Length_Control0 */
        /* offset address */    0xB30814,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port9_Ingress_Bandwidth_Packet_Length_Control0 */
        /* offset address */    0xB30914,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port10_Ingress_Bandwidth_Packet_Length_Control0 */
        /* offset address */    0xB30A14,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port11_Ingress_Bandwidth_Packet_Length_Control0 */
        /* offset address */    0xB30B14,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port12_Ingress_Bandwidth_Packet_Length_Control0 */
        /* offset address */    0xB30C14,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port13_Ingress_Bandwidth_Packet_Length_Control0 */
        /* offset address */    0xB30D14,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port14_Ingress_Bandwidth_Packet_Length_Control0 */
        /* offset address */    0xB30E14,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port15_Ingress_Bandwidth_Packet_Length_Control0 */
        /* offset address */    0xB30F14,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port16_Ingress_Bandwidth_Packet_Length_Control0 */
        /* offset address */    0xB31014,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port17_Ingress_Bandwidth_Packet_Length_Control0 */
        /* offset address */    0xB31114,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port18_Ingress_Bandwidth_Packet_Length_Control0 */
        /* offset address */    0xB31214,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port19_Ingress_Bandwidth_Packet_Length_Control0 */
        /* offset address */    0xB31314,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port20_Ingress_Bandwidth_Packet_Length_Control0 */
        /* offset address */    0xB31414,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port21_Ingress_Bandwidth_Packet_Length_Control0 */
        /* offset address */    0xB31514,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port22_Ingress_Bandwidth_Packet_Length_Control0 */
        /* offset address */    0xB31614,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port23_Ingress_Bandwidth_Packet_Length_Control0 */
        /* offset address */    0xB31714,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port24_Ingress_Bandwidth_Packet_Length_Control0 */
        /* offset address */    0xB31814,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port0_Ingress_Bandwidth_Packet_Length_Control1 */
        /* offset address */    0xB30018,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port1_Ingress_Bandwidth_Packet_Length_Control1 */
        /* offset address */    0xB30118,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port2_Ingress_Bandwidth_Packet_Length_Control1 */
        /* offset address */    0xB30218,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port3_Ingress_Bandwidth_Packet_Length_Control1 */
        /* offset address */    0xB30318,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port4_Ingress_Bandwidth_Packet_Length_Control1 */
        /* offset address */    0xB30418,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port5_Ingress_Bandwidth_Packet_Length_Control1 */
        /* offset address */    0xB30518,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port6_Ingress_Bandwidth_Packet_Length_Control1 */
        /* offset address */    0xB30618,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port7_Ingress_Bandwidth_Packet_Length_Control1 */
        /* offset address */    0xB30718,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port8_Ingress_Bandwidth_Packet_Length_Control1 */
        /* offset address */    0xB30818,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port9_Ingress_Bandwidth_Packet_Length_Control1 */
        /* offset address */    0xB30918,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port10_Ingress_Bandwidth_Packet_Length_Control1 */
        /* offset address */    0xB30A18,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port11_Ingress_Bandwidth_Packet_Length_Control1 */
        /* offset address */    0xB30B18,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port12_Ingress_Bandwidth_Packet_Length_Control1 */
        /* offset address */    0xB30C18,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port13_Ingress_Bandwidth_Packet_Length_Control1 */
        /* offset address */    0xB30D18,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port14_Ingress_Bandwidth_Packet_Length_Control1 */
        /* offset address */    0xB30E18,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port15_Ingress_Bandwidth_Packet_Length_Control1 */
        /* offset address */    0xB30F18,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port16_Ingress_Bandwidth_Packet_Length_Control1 */
        /* offset address */    0xB31018,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port17_Ingress_Bandwidth_Packet_Length_Control1 */
        /* offset address */    0xB31118,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port18_Ingress_Bandwidth_Packet_Length_Control1 */
        /* offset address */    0xB31218,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port19_Ingress_Bandwidth_Packet_Length_Control1 */
        /* offset address */    0xB31318,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port20_Ingress_Bandwidth_Packet_Length_Control1 */
        /* offset address */    0xB31418,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port21_Ingress_Bandwidth_Packet_Length_Control1 */
        /* offset address */    0xB31518,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port22_Ingress_Bandwidth_Packet_Length_Control1 */
        /* offset address */    0xB31618,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port23_Ingress_Bandwidth_Packet_Length_Control1 */
        /* offset address */    0xB31718,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port24_Ingress_Bandwidth_Packet_Length_Control1 */
        /* offset address */    0xB31818,
        /* field numbers */     3,
        /* register fields */   PORT_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        Port0_Ingress_Bandwidth_EBS_Threshold_Control0 */
        /* offset address */    0xB3001C,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port1_Ingress_Bandwidth_EBS_Threshold_Control0 */
        /* offset address */    0xB3011C,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port2_Ingress_Bandwidth_EBS_Threshold_Control0 */
        /* offset address */    0xB3021C,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port3_Ingress_Bandwidth_EBS_Threshold_Control0 */
        /* offset address */    0xB3031C,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port4_Ingress_Bandwidth_EBS_Threshold_Control0 */
        /* offset address */    0xB3041C,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port5_Ingress_Bandwidth_EBS_Threshold_Control0 */
        /* offset address */    0xB3051C,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port6_Ingress_Bandwidth_EBS_Threshold_Control0 */
        /* offset address */    0xB3061C,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port7_Ingress_Bandwidth_EBS_Threshold_Control0 */
        /* offset address */    0xB3071C,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port8_Ingress_Bandwidth_EBS_Threshold_Control0 */
        /* offset address */    0xB3081C,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port9_Ingress_Bandwidth_EBS_Threshold_Control0 */
        /* offset address */    0xB3091C,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port10_Ingress_Bandwidth_EBS_Threshold_Control0 */
        /* offset address */    0xB30A1C,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port11_Ingress_Bandwidth_EBS_Threshold_Control0 */
        /* offset address */    0xB30B1C,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port12_Ingress_Bandwidth_EBS_Threshold_Control0 */
        /* offset address */    0xB30C1C,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port13_Ingress_Bandwidth_EBS_Threshold_Control0 */
        /* offset address */    0xB30D1C,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port14_Ingress_Bandwidth_EBS_Threshold_Control0 */
        /* offset address */    0xB30E1C,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port15_Ingress_Bandwidth_EBS_Threshold_Control0 */
        /* offset address */    0xB30F1C,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port16_Ingress_Bandwidth_EBS_Threshold_Control0 */
        /* offset address */    0xB3101C,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port17_Ingress_Bandwidth_EBS_Threshold_Control0 */
        /* offset address */    0xB3111C,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port18_Ingress_Bandwidth_EBS_Threshold_Control0 */
        /* offset address */    0xB3121C,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port19_Ingress_Bandwidth_EBS_Threshold_Control0 */
        /* offset address */    0xB3131C,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port20_Ingress_Bandwidth_EBS_Threshold_Control0 */
        /* offset address */    0xB3141C,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port21_Ingress_Bandwidth_EBS_Threshold_Control0 */
        /* offset address */    0xB3151C,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port22_Ingress_Bandwidth_EBS_Threshold_Control0 */
        /* offset address */    0xB3161C,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port23_Ingress_Bandwidth_EBS_Threshold_Control0 */
        /* offset address */    0xB3171C,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port24_Ingress_Bandwidth_EBS_Threshold_Control0 */
        /* offset address */    0xB3181C,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port0_Ingress_Bandwidth_EBS_Threshold_Control1 */
        /* offset address */    0xB30020,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port1_Ingress_Bandwidth_EBS_Threshold_Control1 */
        /* offset address */    0xB30120,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port2_Ingress_Bandwidth_EBS_Threshold_Control1 */
        /* offset address */    0xB30220,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port3_Ingress_Bandwidth_EBS_Threshold_Control1 */
        /* offset address */    0xB30320,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port4_Ingress_Bandwidth_EBS_Threshold_Control1 */
        /* offset address */    0xB30420,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port5_Ingress_Bandwidth_EBS_Threshold_Control1 */
        /* offset address */    0xB30520,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port6_Ingress_Bandwidth_EBS_Threshold_Control1 */
        /* offset address */    0xB30620,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port7_Ingress_Bandwidth_EBS_Threshold_Control1 */
        /* offset address */    0xB30720,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port8_Ingress_Bandwidth_EBS_Threshold_Control1 */
        /* offset address */    0xB30820,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port9_Ingress_Bandwidth_EBS_Threshold_Control1 */
        /* offset address */    0xB30920,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port10_Ingress_Bandwidth_EBS_Threshold_Control1 */
        /* offset address */    0xB30A20,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port11_Ingress_Bandwidth_EBS_Threshold_Control1 */
        /* offset address */    0xB30B20,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port12_Ingress_Bandwidth_EBS_Threshold_Control1 */
        /* offset address */    0xB30C20,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port13_Ingress_Bandwidth_EBS_Threshold_Control1 */
        /* offset address */    0xB30D20,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port14_Ingress_Bandwidth_EBS_Threshold_Control1 */
        /* offset address */    0xB30E20,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port15_Ingress_Bandwidth_EBS_Threshold_Control1 */
        /* offset address */    0xB30F20,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port16_Ingress_Bandwidth_EBS_Threshold_Control1 */
        /* offset address */    0xB31020,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port17_Ingress_Bandwidth_EBS_Threshold_Control1 */
        /* offset address */    0xB31120,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port18_Ingress_Bandwidth_EBS_Threshold_Control1 */
        /* offset address */    0xB31220,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port19_Ingress_Bandwidth_EBS_Threshold_Control1 */
        /* offset address */    0xB31320,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port20_Ingress_Bandwidth_EBS_Threshold_Control1 */
        /* offset address */    0xB31420,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port21_Ingress_Bandwidth_EBS_Threshold_Control1 */
        /* offset address */    0xB31520,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port22_Ingress_Bandwidth_EBS_Threshold_Control1 */
        /* offset address */    0xB31620,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port23_Ingress_Bandwidth_EBS_Threshold_Control1 */
        /* offset address */    0xB31720,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Port24_Ingress_Bandwidth_EBS_Threshold_Control1 */
        /* offset address */    0xB31820,
        /* field numbers */     2,
        /* register fields */   PORT_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_FIELDS,
        /* default value */     0xFFFF
    },
    {   /* register name        Leaky_Buket_System_Control */
        /* offset address */    0x350000,
        /* field numbers */     3,
        /* register fields */   LEAKY_BUKET_SYSTEM_CONTROL_FIELDS,
        /* default value */     0x2FC55
    },
    {   /* register name        Leaky_Buket_System_Counter_Control */
        /* offset address */    0x350004,
        /* field numbers */     2,
        /* register fields */   LEAKY_BUKET_SYSTEM_COUNTER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        port_Leaky_Buket_Control */
        /* offset address */    0x350008,
        /* field numbers */     4,
        /* register fields */   PORT_LEAKY_BUKET_CONTROL_FIELDS,
        /* default value */     0x202FD
    },
    {   /* register name        PORT0_Q0_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50000,
        /* field numbers */     2,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT1_Q0_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50100,
        /* field numbers */     2,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT2_Q0_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50200,
        /* field numbers */     2,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT3_Q0_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50300,
        /* field numbers */     2,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT4_Q0_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50400,
        /* field numbers */     2,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT5_Q0_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50500,
        /* field numbers */     2,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT6_Q0_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50600,
        /* field numbers */     2,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT7_Q0_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50700,
        /* field numbers */     2,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT8_Q0_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50800,
        /* field numbers */     2,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT9_Q0_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50900,
        /* field numbers */     2,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT10_Q0_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50A00,
        /* field numbers */     2,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT11_Q0_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50B00,
        /* field numbers */     2,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT12_Q0_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50C00,
        /* field numbers */     2,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT13_Q0_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50D00,
        /* field numbers */     2,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT14_Q0_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50E00,
        /* field numbers */     2,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT15_Q0_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50F00,
        /* field numbers */     2,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT16_Q0_Scheduler_Bucket_Control0 */
        /* offset address */    0xB51000,
        /* field numbers */     2,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT17_Q0_Scheduler_Bucket_Control0 */
        /* offset address */    0xB51100,
        /* field numbers */     2,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT18_Q0_Scheduler_Bucket_Control0 */
        /* offset address */    0xB51200,
        /* field numbers */     2,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT19_Q0_Scheduler_Bucket_Control0 */
        /* offset address */    0xB51300,
        /* field numbers */     2,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT20_Q0_Scheduler_Bucket_Control0 */
        /* offset address */    0xB51400,
        /* field numbers */     2,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT21_Q0_Scheduler_Bucket_Control0 */
        /* offset address */    0xB51500,
        /* field numbers */     2,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT22_Q0_Scheduler_Bucket_Control0 */
        /* offset address */    0xB51600,
        /* field numbers */     2,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT23_Q0_Scheduler_Bucket_Control0 */
        /* offset address */    0xB51700,
        /* field numbers */     2,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT24_Q0_Scheduler_Bucket_Control0 */
        /* offset address */    0xB51800,
        /* field numbers */     2,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT0_Q0_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50004,
        /* field numbers */     5,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F81
    },
    {   /* register name        PORT1_Q0_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50104,
        /* field numbers */     5,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F81
    },
    {   /* register name        PORT2_Q0_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50204,
        /* field numbers */     5,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F81
    },
    {   /* register name        PORT3_Q0_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50304,
        /* field numbers */     5,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F81
    },
    {   /* register name        PORT4_Q0_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50404,
        /* field numbers */     5,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F81
    },
    {   /* register name        PORT5_Q0_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50504,
        /* field numbers */     5,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F81
    },
    {   /* register name        PORT6_Q0_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50604,
        /* field numbers */     5,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F81
    },
    {   /* register name        PORT7_Q0_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50704,
        /* field numbers */     5,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F81
    },
    {   /* register name        PORT8_Q0_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50804,
        /* field numbers */     5,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F81
    },
    {   /* register name        PORT9_Q0_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50904,
        /* field numbers */     5,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F81
    },
    {   /* register name        PORT10_Q0_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50A04,
        /* field numbers */     5,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F81
    },
    {   /* register name        PORT11_Q0_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50B04,
        /* field numbers */     5,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F81
    },
    {   /* register name        PORT12_Q0_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50C04,
        /* field numbers */     5,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F81
    },
    {   /* register name        PORT13_Q0_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50D04,
        /* field numbers */     5,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F81
    },
    {   /* register name        PORT14_Q0_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50E04,
        /* field numbers */     5,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F81
    },
    {   /* register name        PORT15_Q0_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50F04,
        /* field numbers */     5,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F81
    },
    {   /* register name        PORT16_Q0_Scheduler_Bucket_Control1 */
        /* offset address */    0xB51004,
        /* field numbers */     5,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F81
    },
    {   /* register name        PORT17_Q0_Scheduler_Bucket_Control1 */
        /* offset address */    0xB51104,
        /* field numbers */     5,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F81
    },
    {   /* register name        PORT18_Q0_Scheduler_Bucket_Control1 */
        /* offset address */    0xB51204,
        /* field numbers */     5,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F81
    },
    {   /* register name        PORT19_Q0_Scheduler_Bucket_Control1 */
        /* offset address */    0xB51304,
        /* field numbers */     5,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F81
    },
    {   /* register name        PORT20_Q0_Scheduler_Bucket_Control1 */
        /* offset address */    0xB51404,
        /* field numbers */     5,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F81
    },
    {   /* register name        PORT21_Q0_Scheduler_Bucket_Control1 */
        /* offset address */    0xB51504,
        /* field numbers */     5,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F81
    },
    {   /* register name        PORT22_Q0_Scheduler_Bucket_Control1 */
        /* offset address */    0xB51604,
        /* field numbers */     5,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F81
    },
    {   /* register name        PORT23_Q0_Scheduler_Bucket_Control1 */
        /* offset address */    0xB51704,
        /* field numbers */     5,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F81
    },
    {   /* register name        PORT24_Q0_Scheduler_Bucket_Control1 */
        /* offset address */    0xB51804,
        /* field numbers */     5,
        /* register fields */   PORT_Q0_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F81
    },
    {   /* register name        PORT0_Q1_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50008,
        /* field numbers */     2,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT1_Q1_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50108,
        /* field numbers */     2,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT2_Q1_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50208,
        /* field numbers */     2,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT3_Q1_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50308,
        /* field numbers */     2,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT4_Q1_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50408,
        /* field numbers */     2,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT5_Q1_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50508,
        /* field numbers */     2,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT6_Q1_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50608,
        /* field numbers */     2,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT7_Q1_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50708,
        /* field numbers */     2,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT8_Q1_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50808,
        /* field numbers */     2,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT9_Q1_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50908,
        /* field numbers */     2,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT10_Q1_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50A08,
        /* field numbers */     2,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT11_Q1_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50B08,
        /* field numbers */     2,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT12_Q1_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50C08,
        /* field numbers */     2,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT13_Q1_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50D08,
        /* field numbers */     2,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT14_Q1_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50E08,
        /* field numbers */     2,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT15_Q1_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50F08,
        /* field numbers */     2,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT16_Q1_Scheduler_Bucket_Control0 */
        /* offset address */    0xB51008,
        /* field numbers */     2,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT17_Q1_Scheduler_Bucket_Control0 */
        /* offset address */    0xB51108,
        /* field numbers */     2,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT18_Q1_Scheduler_Bucket_Control0 */
        /* offset address */    0xB51208,
        /* field numbers */     2,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT19_Q1_Scheduler_Bucket_Control0 */
        /* offset address */    0xB51308,
        /* field numbers */     2,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT20_Q1_Scheduler_Bucket_Control0 */
        /* offset address */    0xB51408,
        /* field numbers */     2,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT21_Q1_Scheduler_Bucket_Control0 */
        /* offset address */    0xB51508,
        /* field numbers */     2,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT22_Q1_Scheduler_Bucket_Control0 */
        /* offset address */    0xB51608,
        /* field numbers */     2,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT23_Q1_Scheduler_Bucket_Control0 */
        /* offset address */    0xB51708,
        /* field numbers */     2,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT24_Q1_Scheduler_Bucket_Control0 */
        /* offset address */    0xB51808,
        /* field numbers */     2,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT0_Q1_Scheduler_Bucket_Control1 */
        /* offset address */    0xB5000C,
        /* field numbers */     5,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F82
    },
    {   /* register name        PORT1_Q1_Scheduler_Bucket_Control1 */
        /* offset address */    0xB5010C,
        /* field numbers */     5,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F82
    },
    {   /* register name        PORT2_Q1_Scheduler_Bucket_Control1 */
        /* offset address */    0xB5020C,
        /* field numbers */     5,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F82
    },
    {   /* register name        PORT3_Q1_Scheduler_Bucket_Control1 */
        /* offset address */    0xB5030C,
        /* field numbers */     5,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F82
    },
    {   /* register name        PORT4_Q1_Scheduler_Bucket_Control1 */
        /* offset address */    0xB5040C,
        /* field numbers */     5,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F82
    },
    {   /* register name        PORT5_Q1_Scheduler_Bucket_Control1 */
        /* offset address */    0xB5050C,
        /* field numbers */     5,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F82
    },
    {   /* register name        PORT6_Q1_Scheduler_Bucket_Control1 */
        /* offset address */    0xB5060C,
        /* field numbers */     5,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F82
    },
    {   /* register name        PORT7_Q1_Scheduler_Bucket_Control1 */
        /* offset address */    0xB5070C,
        /* field numbers */     5,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F82
    },
    {   /* register name        PORT8_Q1_Scheduler_Bucket_Control1 */
        /* offset address */    0xB5080C,
        /* field numbers */     5,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F82
    },
    {   /* register name        PORT9_Q1_Scheduler_Bucket_Control1 */
        /* offset address */    0xB5090C,
        /* field numbers */     5,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F82
    },
    {   /* register name        PORT10_Q1_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50A0C,
        /* field numbers */     5,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F82
    },
    {   /* register name        PORT11_Q1_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50B0C,
        /* field numbers */     5,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F82
    },
    {   /* register name        PORT12_Q1_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50C0C,
        /* field numbers */     5,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F82
    },
    {   /* register name        PORT13_Q1_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50D0C,
        /* field numbers */     5,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F82
    },
    {   /* register name        PORT14_Q1_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50E0C,
        /* field numbers */     5,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F82
    },
    {   /* register name        PORT15_Q1_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50F0C,
        /* field numbers */     5,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F82
    },
    {   /* register name        PORT16_Q1_Scheduler_Bucket_Control1 */
        /* offset address */    0xB5100C,
        /* field numbers */     5,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F82
    },
    {   /* register name        PORT17_Q1_Scheduler_Bucket_Control1 */
        /* offset address */    0xB5110C,
        /* field numbers */     5,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F82
    },
    {   /* register name        PORT18_Q1_Scheduler_Bucket_Control1 */
        /* offset address */    0xB5120C,
        /* field numbers */     5,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F82
    },
    {   /* register name        PORT19_Q1_Scheduler_Bucket_Control1 */
        /* offset address */    0xB5130C,
        /* field numbers */     5,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F82
    },
    {   /* register name        PORT20_Q1_Scheduler_Bucket_Control1 */
        /* offset address */    0xB5140C,
        /* field numbers */     5,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F82
    },
    {   /* register name        PORT21_Q1_Scheduler_Bucket_Control1 */
        /* offset address */    0xB5150C,
        /* field numbers */     5,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F82
    },
    {   /* register name        PORT22_Q1_Scheduler_Bucket_Control1 */
        /* offset address */    0xB5160C,
        /* field numbers */     5,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F82
    },
    {   /* register name        PORT23_Q1_Scheduler_Bucket_Control1 */
        /* offset address */    0xB5170C,
        /* field numbers */     5,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F82
    },
    {   /* register name        PORT24_Q1_Scheduler_Bucket_Control1 */
        /* offset address */    0xB5180C,
        /* field numbers */     5,
        /* register fields */   PORT_Q1_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F82
    },
    {   /* register name        PORT0_Q2_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50010,
        /* field numbers */     2,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT1_Q2_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50110,
        /* field numbers */     2,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT2_Q2_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50210,
        /* field numbers */     2,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT3_Q2_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50310,
        /* field numbers */     2,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT4_Q2_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50410,
        /* field numbers */     2,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT5_Q2_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50510,
        /* field numbers */     2,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT6_Q2_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50610,
        /* field numbers */     2,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT7_Q2_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50710,
        /* field numbers */     2,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT8_Q2_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50810,
        /* field numbers */     2,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT9_Q2_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50910,
        /* field numbers */     2,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT10_Q2_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50A10,
        /* field numbers */     2,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT11_Q2_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50B10,
        /* field numbers */     2,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT12_Q2_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50C10,
        /* field numbers */     2,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT13_Q2_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50D10,
        /* field numbers */     2,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT14_Q2_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50E10,
        /* field numbers */     2,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT15_Q2_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50F10,
        /* field numbers */     2,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT16_Q2_Scheduler_Bucket_Control0 */
        /* offset address */    0xB51010,
        /* field numbers */     2,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT17_Q2_Scheduler_Bucket_Control0 */
        /* offset address */    0xB51110,
        /* field numbers */     2,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT18_Q2_Scheduler_Bucket_Control0 */
        /* offset address */    0xB51210,
        /* field numbers */     2,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT19_Q2_Scheduler_Bucket_Control0 */
        /* offset address */    0xB51310,
        /* field numbers */     2,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT20_Q2_Scheduler_Bucket_Control0 */
        /* offset address */    0xB51410,
        /* field numbers */     2,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT21_Q2_Scheduler_Bucket_Control0 */
        /* offset address */    0xB51510,
        /* field numbers */     2,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT22_Q2_Scheduler_Bucket_Control0 */
        /* offset address */    0xB51610,
        /* field numbers */     2,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT23_Q2_Scheduler_Bucket_Control0 */
        /* offset address */    0xB51710,
        /* field numbers */     2,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT24_Q2_Scheduler_Bucket_Control0 */
        /* offset address */    0xB51810,
        /* field numbers */     2,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT0_Q2_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50014,
        /* field numbers */     5,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F84
    },
    {   /* register name        PORT1_Q2_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50114,
        /* field numbers */     5,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F84
    },
    {   /* register name        PORT2_Q2_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50214,
        /* field numbers */     5,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F84
    },
    {   /* register name        PORT3_Q2_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50314,
        /* field numbers */     5,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F84
    },
    {   /* register name        PORT4_Q2_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50414,
        /* field numbers */     5,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F84
    },
    {   /* register name        PORT5_Q2_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50514,
        /* field numbers */     5,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F84
    },
    {   /* register name        PORT6_Q2_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50614,
        /* field numbers */     5,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F84
    },
    {   /* register name        PORT7_Q2_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50714,
        /* field numbers */     5,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F84
    },
    {   /* register name        PORT8_Q2_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50814,
        /* field numbers */     5,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F84
    },
    {   /* register name        PORT9_Q2_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50914,
        /* field numbers */     5,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F84
    },
    {   /* register name        PORT10_Q2_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50A14,
        /* field numbers */     5,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F84
    },
    {   /* register name        PORT11_Q2_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50B14,
        /* field numbers */     5,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F84
    },
    {   /* register name        PORT12_Q2_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50C14,
        /* field numbers */     5,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F84
    },
    {   /* register name        PORT13_Q2_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50D14,
        /* field numbers */     5,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F84
    },
    {   /* register name        PORT14_Q2_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50E14,
        /* field numbers */     5,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F84
    },
    {   /* register name        PORT15_Q2_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50F14,
        /* field numbers */     5,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F84
    },
    {   /* register name        PORT16_Q2_Scheduler_Bucket_Control1 */
        /* offset address */    0xB51014,
        /* field numbers */     5,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F84
    },
    {   /* register name        PORT17_Q2_Scheduler_Bucket_Control1 */
        /* offset address */    0xB51114,
        /* field numbers */     5,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F84
    },
    {   /* register name        PORT18_Q2_Scheduler_Bucket_Control1 */
        /* offset address */    0xB51214,
        /* field numbers */     5,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F84
    },
    {   /* register name        PORT19_Q2_Scheduler_Bucket_Control1 */
        /* offset address */    0xB51314,
        /* field numbers */     5,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F84
    },
    {   /* register name        PORT20_Q2_Scheduler_Bucket_Control1 */
        /* offset address */    0xB51414,
        /* field numbers */     5,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F84
    },
    {   /* register name        PORT21_Q2_Scheduler_Bucket_Control1 */
        /* offset address */    0xB51514,
        /* field numbers */     5,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F84
    },
    {   /* register name        PORT22_Q2_Scheduler_Bucket_Control1 */
        /* offset address */    0xB51614,
        /* field numbers */     5,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F84
    },
    {   /* register name        PORT23_Q2_Scheduler_Bucket_Control1 */
        /* offset address */    0xB51714,
        /* field numbers */     5,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F84
    },
    {   /* register name        PORT24_Q2_Scheduler_Bucket_Control1 */
        /* offset address */    0xB51814,
        /* field numbers */     5,
        /* register fields */   PORT_Q2_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F84
    },
    {   /* register name        PORT0_Q3_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50018,
        /* field numbers */     2,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT1_Q3_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50118,
        /* field numbers */     2,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT2_Q3_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50218,
        /* field numbers */     2,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT3_Q3_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50318,
        /* field numbers */     2,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT4_Q3_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50418,
        /* field numbers */     2,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT5_Q3_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50518,
        /* field numbers */     2,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT6_Q3_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50618,
        /* field numbers */     2,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT7_Q3_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50718,
        /* field numbers */     2,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT8_Q3_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50818,
        /* field numbers */     2,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT9_Q3_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50918,
        /* field numbers */     2,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT10_Q3_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50A18,
        /* field numbers */     2,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT11_Q3_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50B18,
        /* field numbers */     2,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT12_Q3_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50C18,
        /* field numbers */     2,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT13_Q3_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50D18,
        /* field numbers */     2,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT14_Q3_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50E18,
        /* field numbers */     2,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT15_Q3_Scheduler_Bucket_Control0 */
        /* offset address */    0xB50F18,
        /* field numbers */     2,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT16_Q3_Scheduler_Bucket_Control0 */
        /* offset address */    0xB51018,
        /* field numbers */     2,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT17_Q3_Scheduler_Bucket_Control0 */
        /* offset address */    0xB51118,
        /* field numbers */     2,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT18_Q3_Scheduler_Bucket_Control0 */
        /* offset address */    0xB51218,
        /* field numbers */     2,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT19_Q3_Scheduler_Bucket_Control0 */
        /* offset address */    0xB51318,
        /* field numbers */     2,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT20_Q3_Scheduler_Bucket_Control0 */
        /* offset address */    0xB51418,
        /* field numbers */     2,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT21_Q3_Scheduler_Bucket_Control0 */
        /* offset address */    0xB51518,
        /* field numbers */     2,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT22_Q3_Scheduler_Bucket_Control0 */
        /* offset address */    0xB51618,
        /* field numbers */     2,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT23_Q3_Scheduler_Bucket_Control0 */
        /* offset address */    0xB51718,
        /* field numbers */     2,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT24_Q3_Scheduler_Bucket_Control0 */
        /* offset address */    0xB51818,
        /* field numbers */     2,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL0_FIELDS,
        /* default value */     0xFFFF0000
    },
    {   /* register name        PORT0_Q3_Scheduler_Bucket_Control1 */
        /* offset address */    0xB5001C,
        /* field numbers */     5,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F88
    },
    {   /* register name        PORT1_Q3_Scheduler_Bucket_Control1 */
        /* offset address */    0xB5011C,
        /* field numbers */     5,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F88
    },
    {   /* register name        PORT2_Q3_Scheduler_Bucket_Control1 */
        /* offset address */    0xB5021C,
        /* field numbers */     5,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F88
    },
    {   /* register name        PORT3_Q3_Scheduler_Bucket_Control1 */
        /* offset address */    0xB5031C,
        /* field numbers */     5,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F88
    },
    {   /* register name        PORT4_Q3_Scheduler_Bucket_Control1 */
        /* offset address */    0xB5041C,
        /* field numbers */     5,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F88
    },
    {   /* register name        PORT5_Q3_Scheduler_Bucket_Control1 */
        /* offset address */    0xB5051C,
        /* field numbers */     5,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F88
    },
    {   /* register name        PORT6_Q3_Scheduler_Bucket_Control1 */
        /* offset address */    0xB5061C,
        /* field numbers */     5,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F88
    },
    {   /* register name        PORT7_Q3_Scheduler_Bucket_Control1 */
        /* offset address */    0xB5071C,
        /* field numbers */     5,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F88
    },
    {   /* register name        PORT8_Q3_Scheduler_Bucket_Control1 */
        /* offset address */    0xB5081C,
        /* field numbers */     5,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F88
    },
    {   /* register name        PORT9_Q3_Scheduler_Bucket_Control1 */
        /* offset address */    0xB5091C,
        /* field numbers */     5,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F88
    },
    {   /* register name        PORT10_Q3_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50A1C,
        /* field numbers */     5,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F88
    },
    {   /* register name        PORT11_Q3_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50B1C,
        /* field numbers */     5,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F88
    },
    {   /* register name        PORT12_Q3_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50C1C,
        /* field numbers */     5,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F88
    },
    {   /* register name        PORT13_Q3_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50D1C,
        /* field numbers */     5,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F88
    },
    {   /* register name        PORT14_Q3_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50E1C,
        /* field numbers */     5,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F88
    },
    {   /* register name        PORT15_Q3_Scheduler_Bucket_Control1 */
        /* offset address */    0xB50F1C,
        /* field numbers */     5,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F88
    },
    {   /* register name        PORT16_Q3_Scheduler_Bucket_Control1 */
        /* offset address */    0xB5101C,
        /* field numbers */     5,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F88
    },
    {   /* register name        PORT17_Q3_Scheduler_Bucket_Control1 */
        /* offset address */    0xB5111C,
        /* field numbers */     5,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F88
    },
    {   /* register name        PORT18_Q3_Scheduler_Bucket_Control1 */
        /* offset address */    0xB5121C,
        /* field numbers */     5,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F88
    },
    {   /* register name        PORT19_Q3_Scheduler_Bucket_Control1 */
        /* offset address */    0xB5131C,
        /* field numbers */     5,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F88
    },
    {   /* register name        PORT20_Q3_Scheduler_Bucket_Control1 */
        /* offset address */    0xB5141C,
        /* field numbers */     5,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F88
    },
    {   /* register name        PORT21_Q3_Scheduler_Bucket_Control1 */
        /* offset address */    0xB5151C,
        /* field numbers */     5,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F88
    },
    {   /* register name        PORT22_Q3_Scheduler_Bucket_Control1 */
        /* offset address */    0xB5161C,
        /* field numbers */     5,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F88
    },
    {   /* register name        PORT23_Q3_Scheduler_Bucket_Control1 */
        /* offset address */    0xB5171C,
        /* field numbers */     5,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F88
    },
    {   /* register name        PORT24_Q3_Scheduler_Bucket_Control1 */
        /* offset address */    0xB5181C,
        /* field numbers */     5,
        /* register fields */   PORT_Q3_SCHEDULER_BUCKET_CONTROL1_FIELDS,
        /* default value */     0x1F88
    },
    {   /* register name        PORT0_Bandwith_Control */
        /* offset address */    0xB50020,
        /* field numbers */     2,
        /* register fields */   PORT_BANDWITH_CONTROL_FIELDS,
        /* default value */     0x640
    },
    {   /* register name        PORT1_Bandwith_Control */
        /* offset address */    0xB50120,
        /* field numbers */     2,
        /* register fields */   PORT_BANDWITH_CONTROL_FIELDS,
        /* default value */     0x640
    },
    {   /* register name        PORT2_Bandwith_Control */
        /* offset address */    0xB50220,
        /* field numbers */     2,
        /* register fields */   PORT_BANDWITH_CONTROL_FIELDS,
        /* default value */     0x640
    },
    {   /* register name        PORT3_Bandwith_Control */
        /* offset address */    0xB50320,
        /* field numbers */     2,
        /* register fields */   PORT_BANDWITH_CONTROL_FIELDS,
        /* default value */     0x640
    },
    {   /* register name        PORT4_Bandwith_Control */
        /* offset address */    0xB50420,
        /* field numbers */     2,
        /* register fields */   PORT_BANDWITH_CONTROL_FIELDS,
        /* default value */     0x640
    },
    {   /* register name        PORT5_Bandwith_Control */
        /* offset address */    0xB50520,
        /* field numbers */     2,
        /* register fields */   PORT_BANDWITH_CONTROL_FIELDS,
        /* default value */     0x640
    },
    {   /* register name        PORT6_Bandwith_Control */
        /* offset address */    0xB50620,
        /* field numbers */     2,
        /* register fields */   PORT_BANDWITH_CONTROL_FIELDS,
        /* default value */     0x640
    },
    {   /* register name        PORT7_Bandwith_Control */
        /* offset address */    0xB50720,
        /* field numbers */     2,
        /* register fields */   PORT_BANDWITH_CONTROL_FIELDS,
        /* default value */     0x640
    },
    {   /* register name        PORT8_Bandwith_Control */
        /* offset address */    0xB50820,
        /* field numbers */     2,
        /* register fields */   PORT_BANDWITH_CONTROL_FIELDS,
        /* default value */     0x640
    },
    {   /* register name        PORT9_Bandwith_Control */
        /* offset address */    0xB50920,
        /* field numbers */     2,
        /* register fields */   PORT_BANDWITH_CONTROL_FIELDS,
        /* default value */     0x640
    },
    {   /* register name        PORT10_Bandwith_Control */
        /* offset address */    0xB50A20,
        /* field numbers */     2,
        /* register fields */   PORT_BANDWITH_CONTROL_FIELDS,
        /* default value */     0x640
    },
    {   /* register name        PORT11_Bandwith_Control */
        /* offset address */    0xB50B20,
        /* field numbers */     2,
        /* register fields */   PORT_BANDWITH_CONTROL_FIELDS,
        /* default value */     0x640
    },
    {   /* register name        PORT12_Bandwith_Control */
        /* offset address */    0xB50C20,
        /* field numbers */     2,
        /* register fields */   PORT_BANDWITH_CONTROL_FIELDS,
        /* default value */     0x640
    },
    {   /* register name        PORT13_Bandwith_Control */
        /* offset address */    0xB50D20,
        /* field numbers */     2,
        /* register fields */   PORT_BANDWITH_CONTROL_FIELDS,
        /* default value */     0x640
    },
    {   /* register name        PORT14_Bandwith_Control */
        /* offset address */    0xB50E20,
        /* field numbers */     2,
        /* register fields */   PORT_BANDWITH_CONTROL_FIELDS,
        /* default value */     0x640
    },
    {   /* register name        PORT15_Bandwith_Control */
        /* offset address */    0xB50F20,
        /* field numbers */     2,
        /* register fields */   PORT_BANDWITH_CONTROL_FIELDS,
        /* default value */     0x640
    },
    {   /* register name        PORT16_Bandwith_Control */
        /* offset address */    0xB51020,
        /* field numbers */     2,
        /* register fields */   PORT_BANDWITH_CONTROL_FIELDS,
        /* default value */     0x640
    },
    {   /* register name        PORT17_Bandwith_Control */
        /* offset address */    0xB51120,
        /* field numbers */     2,
        /* register fields */   PORT_BANDWITH_CONTROL_FIELDS,
        /* default value */     0x640
    },
    {   /* register name        PORT18_Bandwith_Control */
        /* offset address */    0xB51220,
        /* field numbers */     2,
        /* register fields */   PORT_BANDWITH_CONTROL_FIELDS,
        /* default value */     0x640
    },
    {   /* register name        PORT19_Bandwith_Control */
        /* offset address */    0xB51320,
        /* field numbers */     2,
        /* register fields */   PORT_BANDWITH_CONTROL_FIELDS,
        /* default value */     0x640
    },
    {   /* register name        PORT20_Bandwith_Control */
        /* offset address */    0xB51420,
        /* field numbers */     2,
        /* register fields */   PORT_BANDWITH_CONTROL_FIELDS,
        /* default value */     0x640
    },
    {   /* register name        PORT21_Bandwith_Control */
        /* offset address */    0xB51520,
        /* field numbers */     2,
        /* register fields */   PORT_BANDWITH_CONTROL_FIELDS,
        /* default value */     0x640
    },
    {   /* register name        PORT22_Bandwith_Control */
        /* offset address */    0xB51620,
        /* field numbers */     2,
        /* register fields */   PORT_BANDWITH_CONTROL_FIELDS,
        /* default value */     0x640
    },
    {   /* register name        PORT23_Bandwith_Control */
        /* offset address */    0xB51720,
        /* field numbers */     2,
        /* register fields */   PORT_BANDWITH_CONTROL_FIELDS,
        /* default value */     0x640
    },
    {   /* register name        PORT24_Bandwith_Control */
        /* offset address */    0xB51820,
        /* field numbers */     2,
        /* register fields */   PORT_BANDWITH_CONTROL_FIELDS,
        /* default value */     0x640
    },
    {   /* register name        PORT0_queue_schedule_Control */
        /* offset address */    0xB50024,
        /* field numbers */     8,
        /* register fields */   PORT_QUEUE_SCHEDULE_CONTROL_FIELDS,
        /* default value */     0x41
    },
    {   /* register name        PORT1_queue_schedule_Control */
        /* offset address */    0xB50124,
        /* field numbers */     8,
        /* register fields */   PORT_QUEUE_SCHEDULE_CONTROL_FIELDS,
        /* default value */     0x41
    },
    {   /* register name        PORT2_queue_schedule_Control */
        /* offset address */    0xB50224,
        /* field numbers */     8,
        /* register fields */   PORT_QUEUE_SCHEDULE_CONTROL_FIELDS,
        /* default value */     0x41
    },
    {   /* register name        PORT3_queue_schedule_Control */
        /* offset address */    0xB50324,
        /* field numbers */     8,
        /* register fields */   PORT_QUEUE_SCHEDULE_CONTROL_FIELDS,
        /* default value */     0x41
    },
    {   /* register name        PORT4_queue_schedule_Control */
        /* offset address */    0xB50424,
        /* field numbers */     8,
        /* register fields */   PORT_QUEUE_SCHEDULE_CONTROL_FIELDS,
        /* default value */     0x41
    },
    {   /* register name        PORT5_queue_schedule_Control */
        /* offset address */    0xB50524,
        /* field numbers */     8,
        /* register fields */   PORT_QUEUE_SCHEDULE_CONTROL_FIELDS,
        /* default value */     0x41
    },
    {   /* register name        PORT6_queue_schedule_Control */
        /* offset address */    0xB50624,
        /* field numbers */     8,
        /* register fields */   PORT_QUEUE_SCHEDULE_CONTROL_FIELDS,
        /* default value */     0x41
    },
    {   /* register name        PORT7_queue_schedule_Control */
        /* offset address */    0xB50724,
        /* field numbers */     8,
        /* register fields */   PORT_QUEUE_SCHEDULE_CONTROL_FIELDS,
        /* default value */     0x41
    },
    {   /* register name        PORT8_queue_schedule_Control */
        /* offset address */    0xB50824,
        /* field numbers */     8,
        /* register fields */   PORT_QUEUE_SCHEDULE_CONTROL_FIELDS,
        /* default value */     0x41
    },
    {   /* register name        PORT9_queue_schedule_Control */
        /* offset address */    0xB50924,
        /* field numbers */     8,
        /* register fields */   PORT_QUEUE_SCHEDULE_CONTROL_FIELDS,
        /* default value */     0x41
    },
    {   /* register name        PORT10_queue_schedule_Control */
        /* offset address */    0xB50A24,
        /* field numbers */     8,
        /* register fields */   PORT_QUEUE_SCHEDULE_CONTROL_FIELDS,
        /* default value */     0x41
    },
    {   /* register name        PORT11_queue_schedule_Control */
        /* offset address */    0xB50B24,
        /* field numbers */     8,
        /* register fields */   PORT_QUEUE_SCHEDULE_CONTROL_FIELDS,
        /* default value */     0x41
    },
    {   /* register name        PORT12_queue_schedule_Control */
        /* offset address */    0xB50C24,
        /* field numbers */     8,
        /* register fields */   PORT_QUEUE_SCHEDULE_CONTROL_FIELDS,
        /* default value */     0x41
    },
    {   /* register name        PORT13_queue_schedule_Control */
        /* offset address */    0xB50D24,
        /* field numbers */     8,
        /* register fields */   PORT_QUEUE_SCHEDULE_CONTROL_FIELDS,
        /* default value */     0x41
    },
    {   /* register name        PORT14_queue_schedule_Control */
        /* offset address */    0xB50E24,
        /* field numbers */     8,
        /* register fields */   PORT_QUEUE_SCHEDULE_CONTROL_FIELDS,
        /* default value */     0x41
    },
    {   /* register name        PORT15_queue_schedule_Control */
        /* offset address */    0xB50F24,
        /* field numbers */     8,
        /* register fields */   PORT_QUEUE_SCHEDULE_CONTROL_FIELDS,
        /* default value */     0x41
    },
    {   /* register name        PORT16_queue_schedule_Control */
        /* offset address */    0xB51024,
        /* field numbers */     8,
        /* register fields */   PORT_QUEUE_SCHEDULE_CONTROL_FIELDS,
        /* default value */     0x41
    },
    {   /* register name        PORT17_queue_schedule_Control */
        /* offset address */    0xB51124,
        /* field numbers */     8,
        /* register fields */   PORT_QUEUE_SCHEDULE_CONTROL_FIELDS,
        /* default value */     0x41
    },
    {   /* register name        PORT18_queue_schedule_Control */
        /* offset address */    0xB51224,
        /* field numbers */     8,
        /* register fields */   PORT_QUEUE_SCHEDULE_CONTROL_FIELDS,
        /* default value */     0x41
    },
    {   /* register name        PORT19_queue_schedule_Control */
        /* offset address */    0xB51324,
        /* field numbers */     8,
        /* register fields */   PORT_QUEUE_SCHEDULE_CONTROL_FIELDS,
        /* default value */     0x41
    },
    {   /* register name        PORT20_queue_schedule_Control */
        /* offset address */    0xB51424,
        /* field numbers */     8,
        /* register fields */   PORT_QUEUE_SCHEDULE_CONTROL_FIELDS,
        /* default value */     0x41
    },
    {   /* register name        PORT21_queue_schedule_Control */
        /* offset address */    0xB51524,
        /* field numbers */     8,
        /* register fields */   PORT_QUEUE_SCHEDULE_CONTROL_FIELDS,
        /* default value */     0x41
    },
    {   /* register name        PORT22_queue_schedule_Control */
        /* offset address */    0xB51624,
        /* field numbers */     8,
        /* register fields */   PORT_QUEUE_SCHEDULE_CONTROL_FIELDS,
        /* default value */     0x41
    },
    {   /* register name        PORT23_queue_schedule_Control */
        /* offset address */    0xB51724,
        /* field numbers */     8,
        /* register fields */   PORT_QUEUE_SCHEDULE_CONTROL_FIELDS,
        /* default value */     0x41
    },
    {   /* register name        PORT24_queue_schedule_Control */
        /* offset address */    0xB51824,
        /* field numbers */     8,
        /* register fields */   PORT_QUEUE_SCHEDULE_CONTROL_FIELDS,
        /* default value */     0x41
    },
    {   /* register name        PORT0_Queue_0_Packet_Number_Counter */
        /* offset address */    0xB50028,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_0_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT1_Queue_0_Packet_Number_Counter */
        /* offset address */    0xB50128,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_0_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT2_Queue_0_Packet_Number_Counter */
        /* offset address */    0xB50228,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_0_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT3_Queue_0_Packet_Number_Counter */
        /* offset address */    0xB50328,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_0_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT4_Queue_0_Packet_Number_Counter */
        /* offset address */    0xB50428,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_0_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT5_Queue_0_Packet_Number_Counter */
        /* offset address */    0xB50528,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_0_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT6_Queue_0_Packet_Number_Counter */
        /* offset address */    0xB50628,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_0_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT7_Queue_0_Packet_Number_Counter */
        /* offset address */    0xB50728,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_0_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT8_Queue_0_Packet_Number_Counter */
        /* offset address */    0xB50828,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_0_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT9_Queue_0_Packet_Number_Counter */
        /* offset address */    0xB50928,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_0_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT10_Queue_0_Packet_Number_Counter */
        /* offset address */    0xB50A28,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_0_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT11_Queue_0_Packet_Number_Counter */
        /* offset address */    0xB50B28,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_0_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT12_Queue_0_Packet_Number_Counter */
        /* offset address */    0xB50C28,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_0_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT13_Queue_0_Packet_Number_Counter */
        /* offset address */    0xB50D28,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_0_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT14_Queue_0_Packet_Number_Counter */
        /* offset address */    0xB50E28,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_0_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT15_Queue_0_Packet_Number_Counter */
        /* offset address */    0xB50F28,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_0_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT16_Queue_0_Packet_Number_Counter */
        /* offset address */    0xB51028,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_0_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT17_Queue_0_Packet_Number_Counter */
        /* offset address */    0xB51128,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_0_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT18_Queue_0_Packet_Number_Counter */
        /* offset address */    0xB51228,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_0_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT19_Queue_0_Packet_Number_Counter */
        /* offset address */    0xB51328,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_0_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT20_Queue_0_Packet_Number_Counter */
        /* offset address */    0xB51428,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_0_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT21_Queue_0_Packet_Number_Counter */
        /* offset address */    0xB51528,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_0_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT22_Queue_0_Packet_Number_Counter */
        /* offset address */    0xB51628,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_0_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT23_Queue_0_Packet_Number_Counter */
        /* offset address */    0xB51728,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_0_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT24_Queue_0_Packet_Number_Counter */
        /* offset address */    0xB51828,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_0_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT0_Queue_1_Packet_Number_Counter */
        /* offset address */    0xB5002C,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_1_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT1_Queue_1_Packet_Number_Counter */
        /* offset address */    0xB5012C,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_1_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT2_Queue_1_Packet_Number_Counter */
        /* offset address */    0xB5022C,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_1_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT3_Queue_1_Packet_Number_Counter */
        /* offset address */    0xB5032C,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_1_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT4_Queue_1_Packet_Number_Counter */
        /* offset address */    0xB5042C,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_1_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT5_Queue_1_Packet_Number_Counter */
        /* offset address */    0xB5052C,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_1_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT6_Queue_1_Packet_Number_Counter */
        /* offset address */    0xB5062C,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_1_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT7_Queue_1_Packet_Number_Counter */
        /* offset address */    0xB5072C,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_1_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT8_Queue_1_Packet_Number_Counter */
        /* offset address */    0xB5082C,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_1_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT9_Queue_1_Packet_Number_Counter */
        /* offset address */    0xB5092C,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_1_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT10_Queue_1_Packet_Number_Counter */
        /* offset address */    0xB50A2C,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_1_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT11_Queue_1_Packet_Number_Counter */
        /* offset address */    0xB50B2C,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_1_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT12_Queue_1_Packet_Number_Counter */
        /* offset address */    0xB50C2C,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_1_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT13_Queue_1_Packet_Number_Counter */
        /* offset address */    0xB50D2C,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_1_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT14_Queue_1_Packet_Number_Counter */
        /* offset address */    0xB50E2C,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_1_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT15_Queue_1_Packet_Number_Counter */
        /* offset address */    0xB50F2C,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_1_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT16_Queue_1_Packet_Number_Counter */
        /* offset address */    0xB5102C,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_1_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT17_Queue_1_Packet_Number_Counter */
        /* offset address */    0xB5112C,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_1_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT18_Queue_1_Packet_Number_Counter */
        /* offset address */    0xB5122C,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_1_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT19_Queue_1_Packet_Number_Counter */
        /* offset address */    0xB5132C,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_1_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT20_Queue_1_Packet_Number_Counter */
        /* offset address */    0xB5142C,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_1_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT21_Queue_1_Packet_Number_Counter */
        /* offset address */    0xB5152C,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_1_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT22_Queue_1_Packet_Number_Counter */
        /* offset address */    0xB5162C,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_1_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT23_Queue_1_Packet_Number_Counter */
        /* offset address */    0xB5172C,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_1_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT24_Queue_1_Packet_Number_Counter */
        /* offset address */    0xB5182C,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_1_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT0_Queue_2_Packet_Number_Counter */
        /* offset address */    0xB50030,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_2_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT1_Queue_2_Packet_Number_Counter */
        /* offset address */    0xB50130,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_2_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT2_Queue_2_Packet_Number_Counter */
        /* offset address */    0xB50230,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_2_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT3_Queue_2_Packet_Number_Counter */
        /* offset address */    0xB50330,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_2_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT4_Queue_2_Packet_Number_Counter */
        /* offset address */    0xB50430,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_2_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT5_Queue_2_Packet_Number_Counter */
        /* offset address */    0xB50530,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_2_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT6_Queue_2_Packet_Number_Counter */
        /* offset address */    0xB50630,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_2_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT7_Queue_2_Packet_Number_Counter */
        /* offset address */    0xB50730,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_2_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT8_Queue_2_Packet_Number_Counter */
        /* offset address */    0xB50830,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_2_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT9_Queue_2_Packet_Number_Counter */
        /* offset address */    0xB50930,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_2_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT10_Queue_2_Packet_Number_Counter */
        /* offset address */    0xB50A30,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_2_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT11_Queue_2_Packet_Number_Counter */
        /* offset address */    0xB50B30,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_2_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT12_Queue_2_Packet_Number_Counter */
        /* offset address */    0xB50C30,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_2_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT13_Queue_2_Packet_Number_Counter */
        /* offset address */    0xB50D30,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_2_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT14_Queue_2_Packet_Number_Counter */
        /* offset address */    0xB50E30,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_2_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT15_Queue_2_Packet_Number_Counter */
        /* offset address */    0xB50F30,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_2_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT16_Queue_2_Packet_Number_Counter */
        /* offset address */    0xB51030,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_2_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT17_Queue_2_Packet_Number_Counter */
        /* offset address */    0xB51130,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_2_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT18_Queue_2_Packet_Number_Counter */
        /* offset address */    0xB51230,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_2_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT19_Queue_2_Packet_Number_Counter */
        /* offset address */    0xB51330,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_2_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT20_Queue_2_Packet_Number_Counter */
        /* offset address */    0xB51430,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_2_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT21_Queue_2_Packet_Number_Counter */
        /* offset address */    0xB51530,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_2_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT22_Queue_2_Packet_Number_Counter */
        /* offset address */    0xB51630,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_2_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT23_Queue_2_Packet_Number_Counter */
        /* offset address */    0xB51730,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_2_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT24_Queue_2_Packet_Number_Counter */
        /* offset address */    0xB51830,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_2_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT0_Queue_3_Packet_Number_Counter */
        /* offset address */    0xB50034,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_3_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT1_Queue_3_Packet_Number_Counter */
        /* offset address */    0xB50134,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_3_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT2_Queue_3_Packet_Number_Counter */
        /* offset address */    0xB50234,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_3_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT3_Queue_3_Packet_Number_Counter */
        /* offset address */    0xB50334,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_3_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT4_Queue_3_Packet_Number_Counter */
        /* offset address */    0xB50434,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_3_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT5_Queue_3_Packet_Number_Counter */
        /* offset address */    0xB50534,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_3_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT6_Queue_3_Packet_Number_Counter */
        /* offset address */    0xB50634,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_3_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT7_Queue_3_Packet_Number_Counter */
        /* offset address */    0xB50734,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_3_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT8_Queue_3_Packet_Number_Counter */
        /* offset address */    0xB50834,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_3_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT9_Queue_3_Packet_Number_Counter */
        /* offset address */    0xB50934,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_3_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT10_Queue_3_Packet_Number_Counter */
        /* offset address */    0xB50A34,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_3_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT11_Queue_3_Packet_Number_Counter */
        /* offset address */    0xB50B34,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_3_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT12_Queue_3_Packet_Number_Counter */
        /* offset address */    0xB50C34,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_3_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT13_Queue_3_Packet_Number_Counter */
        /* offset address */    0xB50D34,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_3_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT14_Queue_3_Packet_Number_Counter */
        /* offset address */    0xB50E34,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_3_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT15_Queue_3_Packet_Number_Counter */
        /* offset address */    0xB50F34,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_3_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT16_Queue_3_Packet_Number_Counter */
        /* offset address */    0xB51034,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_3_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT17_Queue_3_Packet_Number_Counter */
        /* offset address */    0xB51134,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_3_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT18_Queue_3_Packet_Number_Counter */
        /* offset address */    0xB51234,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_3_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT19_Queue_3_Packet_Number_Counter */
        /* offset address */    0xB51334,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_3_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT20_Queue_3_Packet_Number_Counter */
        /* offset address */    0xB51434,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_3_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT21_Queue_3_Packet_Number_Counter */
        /* offset address */    0xB51534,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_3_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT22_Queue_3_Packet_Number_Counter */
        /* offset address */    0xB51634,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_3_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT23_Queue_3_Packet_Number_Counter */
        /* offset address */    0xB51734,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_3_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT24_Queue_3_Packet_Number_Counter */
        /* offset address */    0xB51834,
        /* field numbers */     1,
        /* register fields */   PORT_QUEUE_3_PACKET_NUMBER_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        LINK_AGGREGATION_MEMBER_CONTROL0 */
        /* offset address */    0x3C0000,
        /* field numbers */     2,
        /* register fields */   LINK_AGGREGATION_MEMBER_CONTROL0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        LINK_AGGREGATION_MEMBER_CONTROL1 */
        /* offset address */    0x3C0004,
        /* field numbers */     2,
        /* register fields */   LINK_AGGREGATION_MEMBER_CONTROL1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        LINK_AGGREGATION_MEMBER_CONTROL2 */
        /* offset address */    0x3C0008,
        /* field numbers */     2,
        /* register fields */   LINK_AGGREGATION_MEMBER_CONTROL2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        LINK_AGGREGATION_MEMBER_CONTROL3 */
        /* offset address */    0x3C000C,
        /* field numbers */     2,
        /* register fields */   LINK_AGGREGATION_MEMBER_CONTROL3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        LINK_AGGREGATION_CONGEST_PORT_CONTROL */
        /* offset address */    0x3C0010,
        /* field numbers */     2,
        /* register fields */   LINK_AGGREGATION_CONGEST_PORT_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        LINK_AGGREGATION_EMPTY_PORT_CONTROL */
        /* offset address */    0x3C0014,
        /* field numbers */     2,
        /* register fields */   LINK_AGGREGATION_EMPTY_PORT_CONTROL_FIELDS,
        /* default value */     0x1FFFFFF
    },
    {   /* register name        Traffic_Mirror_Control0 */
        /* offset address */    0x400000,
        /* field numbers */     8,
        /* register fields */   TRAFFIC_MIRROR_CONTROL0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Traffic_Mirror_Control1 */
        /* offset address */    0x400004,
        /* field numbers */     4,
        /* register fields */   TRAFFIC_MIRROR_CONTROL1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Traffic_Mirror_Control2 */
        /* offset address */    0x400008,
        /* field numbers */     2,
        /* register fields */   TRAFFIC_MIRROR_CONTROL2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Mirror_Port_Egress_Filter_Control */
        /* offset address */    0x40000C,
        /* field numbers */     2,
        /* register fields */   MIRROR_PORT_EGRESS_FILTER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Traffic_Mirror_Sample_Control */
        /* offset address */    0x400010,
        /* field numbers */     2,
        /* register fields */   TRAFFIC_MIRROR_SAMPLE_CONTROL_FIELDS,
        /* default value */     0x10000
    },
    {   /* register name        Traffic_Mirror_Sample_statistic */
        /* offset address */    0x400014,
        /* field numbers */     1,
        /* register fields */   TRAFFIC_MIRROR_SAMPLE_STATISTIC_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        CPU_Tag_Control */
        /* offset address */    0x500000,
        /* field numbers */     5,
        /* register fields */   CPU_TAG_CONTROL_FIELDS,
        /* default value */     0x2048899
    },
    {   /* register name        Packet_parser_PID_Control_regist_0 */
        /* offset address */    0x500004,
        /* field numbers */     2,
        /* register fields */   PACKET_PARSER_PID_CONTROL_REGIST_0_FIELDS,
        /* default value */     0x88A88100
    },
    {   /* register name        Packet_parser_PID_Control_regist_1 */
        /* offset address */    0x500008,
        /* field numbers */     2,
        /* register fields */   PACKET_PARSER_PID_CONTROL_REGIST_1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT23_PID_MASK_CONTROL */
        /* offset address */    0x50000C,
        /* field numbers */     3,
        /* register fields */   PORT23_PID_MASK_CONTROL_FIELDS,
        /* default value */     0x21
    },
    {   /* register name        PORT24_PID_MASK_CONTROL */
        /* offset address */    0x500010,
        /* field numbers */     3,
        /* register fields */   PORT24_PID_MASK_CONTROL_FIELDS,
        /* default value */     0x21
    },
    {   /* register name        Packet_parser_Layer2_Type_Control */
        /* offset address */    0x500014,
        /* field numbers */     2,
        /* register fields */   PACKET_PARSER_LAYER2_TYPE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT_MAXLEN_CONTROL */
        /* offset address */    0x500018,
        /* field numbers */     2,
        /* register fields */   PORT_MAXLEN_CONTROL_FIELDS,
        /* default value */     0x5F2
    },
    {   /* register name        PORT23_MAXLEN_CONTROL */
        /* offset address */    0x50001C,
        /* field numbers */     4,
        /* register fields */   PORT23_MAXLEN_CONTROL_FIELDS,
        /* default value */     0x5F2
    },
    {   /* register name        PORT24_MAXLEN_CONTROL */
        /* offset address */    0x500020,
        /* field numbers */     4,
        /* register fields */   PORT24_MAXLEN_CONTROL_FIELDS,
        /* default value */     0x5F2
    },
    {   /* register name        PORT0_PID_MASK_CONTROL */
        /* offset address */    0xD00000,
        /* field numbers */     3,
        /* register fields */   PORT_PID_MASK_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT1_PID_MASK_CONTROL */
        /* offset address */    0xD00100,
        /* field numbers */     3,
        /* register fields */   PORT_PID_MASK_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT2_PID_MASK_CONTROL */
        /* offset address */    0xD00200,
        /* field numbers */     3,
        /* register fields */   PORT_PID_MASK_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT3_PID_MASK_CONTROL */
        /* offset address */    0xD00300,
        /* field numbers */     3,
        /* register fields */   PORT_PID_MASK_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT4_PID_MASK_CONTROL */
        /* offset address */    0xD00400,
        /* field numbers */     3,
        /* register fields */   PORT_PID_MASK_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT5_PID_MASK_CONTROL */
        /* offset address */    0xD00500,
        /* field numbers */     3,
        /* register fields */   PORT_PID_MASK_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT6_PID_MASK_CONTROL */
        /* offset address */    0xD00600,
        /* field numbers */     3,
        /* register fields */   PORT_PID_MASK_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT7_PID_MASK_CONTROL */
        /* offset address */    0xD00700,
        /* field numbers */     3,
        /* register fields */   PORT_PID_MASK_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT8_PID_MASK_CONTROL */
        /* offset address */    0xD00800,
        /* field numbers */     3,
        /* register fields */   PORT_PID_MASK_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT9_PID_MASK_CONTROL */
        /* offset address */    0xD00900,
        /* field numbers */     3,
        /* register fields */   PORT_PID_MASK_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT10_PID_MASK_CONTROL */
        /* offset address */    0xD00A00,
        /* field numbers */     3,
        /* register fields */   PORT_PID_MASK_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT11_PID_MASK_CONTROL */
        /* offset address */    0xD00B00,
        /* field numbers */     3,
        /* register fields */   PORT_PID_MASK_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT12_PID_MASK_CONTROL */
        /* offset address */    0xD00C00,
        /* field numbers */     3,
        /* register fields */   PORT_PID_MASK_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT13_PID_MASK_CONTROL */
        /* offset address */    0xD00D00,
        /* field numbers */     3,
        /* register fields */   PORT_PID_MASK_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT14_PID_MASK_CONTROL */
        /* offset address */    0xD00E00,
        /* field numbers */     3,
        /* register fields */   PORT_PID_MASK_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT15_PID_MASK_CONTROL */
        /* offset address */    0xD00F00,
        /* field numbers */     3,
        /* register fields */   PORT_PID_MASK_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT16_PID_MASK_CONTROL */
        /* offset address */    0xD01000,
        /* field numbers */     3,
        /* register fields */   PORT_PID_MASK_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT17_PID_MASK_CONTROL */
        /* offset address */    0xD01100,
        /* field numbers */     3,
        /* register fields */   PORT_PID_MASK_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT18_PID_MASK_CONTROL */
        /* offset address */    0xD01200,
        /* field numbers */     3,
        /* register fields */   PORT_PID_MASK_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT19_PID_MASK_CONTROL */
        /* offset address */    0xD01300,
        /* field numbers */     3,
        /* register fields */   PORT_PID_MASK_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT20_PID_MASK_CONTROL */
        /* offset address */    0xD01400,
        /* field numbers */     3,
        /* register fields */   PORT_PID_MASK_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT21_PID_MASK_CONTROL */
        /* offset address */    0xD01500,
        /* field numbers */     3,
        /* register fields */   PORT_PID_MASK_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT22_PID_MASK_CONTROL */
        /* offset address */    0xD01600,
        /* field numbers */     3,
        /* register fields */   PORT_PID_MASK_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT0_CHECKSUM_ERROR_CONTROL */
        /* offset address */    0xD00004,
        /* field numbers */     2,
        /* register fields */   PORT_CHECKSUM_ERROR_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT1_CHECKSUM_ERROR_CONTROL */
        /* offset address */    0xD00104,
        /* field numbers */     2,
        /* register fields */   PORT_CHECKSUM_ERROR_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT2_CHECKSUM_ERROR_CONTROL */
        /* offset address */    0xD00204,
        /* field numbers */     2,
        /* register fields */   PORT_CHECKSUM_ERROR_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT3_CHECKSUM_ERROR_CONTROL */
        /* offset address */    0xD00304,
        /* field numbers */     2,
        /* register fields */   PORT_CHECKSUM_ERROR_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT4_CHECKSUM_ERROR_CONTROL */
        /* offset address */    0xD00404,
        /* field numbers */     2,
        /* register fields */   PORT_CHECKSUM_ERROR_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT5_CHECKSUM_ERROR_CONTROL */
        /* offset address */    0xD00504,
        /* field numbers */     2,
        /* register fields */   PORT_CHECKSUM_ERROR_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT6_CHECKSUM_ERROR_CONTROL */
        /* offset address */    0xD00604,
        /* field numbers */     2,
        /* register fields */   PORT_CHECKSUM_ERROR_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT7_CHECKSUM_ERROR_CONTROL */
        /* offset address */    0xD00704,
        /* field numbers */     2,
        /* register fields */   PORT_CHECKSUM_ERROR_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT8_CHECKSUM_ERROR_CONTROL */
        /* offset address */    0xD00804,
        /* field numbers */     2,
        /* register fields */   PORT_CHECKSUM_ERROR_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT9_CHECKSUM_ERROR_CONTROL */
        /* offset address */    0xD00904,
        /* field numbers */     2,
        /* register fields */   PORT_CHECKSUM_ERROR_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT10_CHECKSUM_ERROR_CONTROL */
        /* offset address */    0xD00A04,
        /* field numbers */     2,
        /* register fields */   PORT_CHECKSUM_ERROR_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT11_CHECKSUM_ERROR_CONTROL */
        /* offset address */    0xD00B04,
        /* field numbers */     2,
        /* register fields */   PORT_CHECKSUM_ERROR_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT12_CHECKSUM_ERROR_CONTROL */
        /* offset address */    0xD00C04,
        /* field numbers */     2,
        /* register fields */   PORT_CHECKSUM_ERROR_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT13_CHECKSUM_ERROR_CONTROL */
        /* offset address */    0xD00D04,
        /* field numbers */     2,
        /* register fields */   PORT_CHECKSUM_ERROR_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT14_CHECKSUM_ERROR_CONTROL */
        /* offset address */    0xD00E04,
        /* field numbers */     2,
        /* register fields */   PORT_CHECKSUM_ERROR_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT15_CHECKSUM_ERROR_CONTROL */
        /* offset address */    0xD00F04,
        /* field numbers */     2,
        /* register fields */   PORT_CHECKSUM_ERROR_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT16_CHECKSUM_ERROR_CONTROL */
        /* offset address */    0xD01004,
        /* field numbers */     2,
        /* register fields */   PORT_CHECKSUM_ERROR_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT17_CHECKSUM_ERROR_CONTROL */
        /* offset address */    0xD01104,
        /* field numbers */     2,
        /* register fields */   PORT_CHECKSUM_ERROR_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT18_CHECKSUM_ERROR_CONTROL */
        /* offset address */    0xD01204,
        /* field numbers */     2,
        /* register fields */   PORT_CHECKSUM_ERROR_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT19_CHECKSUM_ERROR_CONTROL */
        /* offset address */    0xD01304,
        /* field numbers */     2,
        /* register fields */   PORT_CHECKSUM_ERROR_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT20_CHECKSUM_ERROR_CONTROL */
        /* offset address */    0xD01404,
        /* field numbers */     2,
        /* register fields */   PORT_CHECKSUM_ERROR_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT21_CHECKSUM_ERROR_CONTROL */
        /* offset address */    0xD01504,
        /* field numbers */     2,
        /* register fields */   PORT_CHECKSUM_ERROR_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT22_CHECKSUM_ERROR_CONTROL */
        /* offset address */    0xD01604,
        /* field numbers */     2,
        /* register fields */   PORT_CHECKSUM_ERROR_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT23_CHECKSUM_ERROR_CONTROL */
        /* offset address */    0xD01704,
        /* field numbers */     2,
        /* register fields */   PORT_CHECKSUM_ERROR_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT24_CHECKSUM_ERROR_CONTROL */
        /* offset address */    0xD01804,
        /* field numbers */     2,
        /* register fields */   PORT_CHECKSUM_ERROR_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        PORT0_DROP_REASON */
        /* offset address */    0xD00008,
        /* field numbers */     2,
        /* register fields */   PORT_DROP_REASON_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT1_DROP_REASON */
        /* offset address */    0xD00108,
        /* field numbers */     2,
        /* register fields */   PORT_DROP_REASON_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT2_DROP_REASON */
        /* offset address */    0xD00208,
        /* field numbers */     2,
        /* register fields */   PORT_DROP_REASON_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT3_DROP_REASON */
        /* offset address */    0xD00308,
        /* field numbers */     2,
        /* register fields */   PORT_DROP_REASON_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT4_DROP_REASON */
        /* offset address */    0xD00408,
        /* field numbers */     2,
        /* register fields */   PORT_DROP_REASON_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT5_DROP_REASON */
        /* offset address */    0xD00508,
        /* field numbers */     2,
        /* register fields */   PORT_DROP_REASON_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT6_DROP_REASON */
        /* offset address */    0xD00608,
        /* field numbers */     2,
        /* register fields */   PORT_DROP_REASON_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT7_DROP_REASON */
        /* offset address */    0xD00708,
        /* field numbers */     2,
        /* register fields */   PORT_DROP_REASON_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT8_DROP_REASON */
        /* offset address */    0xD00808,
        /* field numbers */     2,
        /* register fields */   PORT_DROP_REASON_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT9_DROP_REASON */
        /* offset address */    0xD00908,
        /* field numbers */     2,
        /* register fields */   PORT_DROP_REASON_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT10_DROP_REASON */
        /* offset address */    0xD00A08,
        /* field numbers */     2,
        /* register fields */   PORT_DROP_REASON_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT11_DROP_REASON */
        /* offset address */    0xD00B08,
        /* field numbers */     2,
        /* register fields */   PORT_DROP_REASON_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT12_DROP_REASON */
        /* offset address */    0xD00C08,
        /* field numbers */     2,
        /* register fields */   PORT_DROP_REASON_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT13_DROP_REASON */
        /* offset address */    0xD00D08,
        /* field numbers */     2,
        /* register fields */   PORT_DROP_REASON_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT14_DROP_REASON */
        /* offset address */    0xD00E08,
        /* field numbers */     2,
        /* register fields */   PORT_DROP_REASON_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT15_DROP_REASON */
        /* offset address */    0xD00F08,
        /* field numbers */     2,
        /* register fields */   PORT_DROP_REASON_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT16_DROP_REASON */
        /* offset address */    0xD01008,
        /* field numbers */     2,
        /* register fields */   PORT_DROP_REASON_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT17_DROP_REASON */
        /* offset address */    0xD01108,
        /* field numbers */     2,
        /* register fields */   PORT_DROP_REASON_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT18_DROP_REASON */
        /* offset address */    0xD01208,
        /* field numbers */     2,
        /* register fields */   PORT_DROP_REASON_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT19_DROP_REASON */
        /* offset address */    0xD01308,
        /* field numbers */     2,
        /* register fields */   PORT_DROP_REASON_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT20_DROP_REASON */
        /* offset address */    0xD01408,
        /* field numbers */     2,
        /* register fields */   PORT_DROP_REASON_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT21_DROP_REASON */
        /* offset address */    0xD01508,
        /* field numbers */     2,
        /* register fields */   PORT_DROP_REASON_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT22_DROP_REASON */
        /* offset address */    0xD01608,
        /* field numbers */     2,
        /* register fields */   PORT_DROP_REASON_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT23_DROP_REASON */
        /* offset address */    0xD01708,
        /* field numbers */     2,
        /* register fields */   PORT_DROP_REASON_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT24_DROP_REASON */
        /* offset address */    0xD01808,
        /* field numbers */     2,
        /* register fields */   PORT_DROP_REASON_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        IGMP_MLD_Control */
        /* offset address */    0x510000,
        /* field numbers */     5,
        /* register fields */   IGMP_MLD_CONTROL_FIELDS,
        /* default value */     0x20
    },
    {   /* register name        Option_Header_Trap_Control */
        /* offset address */    0x510004,
        /* field numbers */     6,
        /* register fields */   OPTION_HEADER_TRAP_CONTROL_FIELDS,
        /* default value */     0x20
    },
    {   /* register name        CFI_Control */
        /* offset address */    0x510008,
        /* field numbers */     5,
        /* register fields */   CFI_CONTROL_FIELDS,
        /* default value */     0x20
    },
    {   /* register name        RMA_Control0 */
        /* offset address */    0x530000,
        /* field numbers */     16,
        /* register fields */   RMA_CONTROL0_FIELDS,
        /* default value */     0x2F3EFBCF
    },
    {   /* register name        RMA_Control1 */
        /* offset address */    0x530004,
        /* field numbers */     16,
        /* register fields */   RMA_CONTROL1_FIELDS,
        /* default value */     0x2FBEFBCF
    },
    {   /* register name        RMA_Control2 */
        /* offset address */    0x530008,
        /* field numbers */     4,
        /* register fields */   RMA_CONTROL2_FIELDS,
        /* default value */     0xF
    },
    {   /* register name        RMA_CPU_Port_Control */
        /* offset address */    0x53000C,
        /* field numbers */     2,
        /* register fields */   RMA_CPU_PORT_CONTROL_FIELDS,
        /* default value */     0x2
    },
    {   /* register name        OAM_PDU_Control */
        /* offset address */    0x540000,
        /* field numbers */     6,
        /* register fields */   OAM_PDU_CONTROL_FIELDS,
        /* default value */     0x220
    },
    {   /* register name        PORT0_OAM_PARSER_CONTROL */
        /* offset address */    0xD40000,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_PARSER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT1_OAM_PARSER_CONTROL */
        /* offset address */    0xD40100,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_PARSER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT2_OAM_PARSER_CONTROL */
        /* offset address */    0xD40200,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_PARSER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT3_OAM_PARSER_CONTROL */
        /* offset address */    0xD40300,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_PARSER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT4_OAM_PARSER_CONTROL */
        /* offset address */    0xD40400,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_PARSER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT5_OAM_PARSER_CONTROL */
        /* offset address */    0xD40500,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_PARSER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT6_OAM_PARSER_CONTROL */
        /* offset address */    0xD40600,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_PARSER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT7_OAM_PARSER_CONTROL */
        /* offset address */    0xD40700,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_PARSER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT8_OAM_PARSER_CONTROL */
        /* offset address */    0xD40800,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_PARSER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT9_OAM_PARSER_CONTROL */
        /* offset address */    0xD40900,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_PARSER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT10_OAM_PARSER_CONTROL */
        /* offset address */    0xD40A00,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_PARSER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT11_OAM_PARSER_CONTROL */
        /* offset address */    0xD40B00,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_PARSER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT12_OAM_PARSER_CONTROL */
        /* offset address */    0xD40C00,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_PARSER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT13_OAM_PARSER_CONTROL */
        /* offset address */    0xD40D00,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_PARSER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT14_OAM_PARSER_CONTROL */
        /* offset address */    0xD40E00,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_PARSER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT15_OAM_PARSER_CONTROL */
        /* offset address */    0xD40F00,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_PARSER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT16_OAM_PARSER_CONTROL */
        /* offset address */    0xD41000,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_PARSER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT17_OAM_PARSER_CONTROL */
        /* offset address */    0xD41100,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_PARSER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT18_OAM_PARSER_CONTROL */
        /* offset address */    0xD41200,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_PARSER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT19_OAM_PARSER_CONTROL */
        /* offset address */    0xD41300,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_PARSER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT20_OAM_PARSER_CONTROL */
        /* offset address */    0xD41400,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_PARSER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT21_OAM_PARSER_CONTROL */
        /* offset address */    0xD41500,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_PARSER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT22_OAM_PARSER_CONTROL */
        /* offset address */    0xD41600,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_PARSER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT23_OAM_PARSER_CONTROL */
        /* offset address */    0xD41700,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_PARSER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT24_OAM_PARSER_CONTROL */
        /* offset address */    0xD41800,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_PARSER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT0_OAM_MULTIPLEXER_CONTROL */
        /* offset address */    0xD40004,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_MULTIPLEXER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT1_OAM_MULTIPLEXER_CONTROL */
        /* offset address */    0xD40104,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_MULTIPLEXER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT2_OAM_MULTIPLEXER_CONTROL */
        /* offset address */    0xD40204,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_MULTIPLEXER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT3_OAM_MULTIPLEXER_CONTROL */
        /* offset address */    0xD40304,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_MULTIPLEXER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT4_OAM_MULTIPLEXER_CONTROL */
        /* offset address */    0xD40404,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_MULTIPLEXER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT5_OAM_MULTIPLEXER_CONTROL */
        /* offset address */    0xD40504,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_MULTIPLEXER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT6_OAM_MULTIPLEXER_CONTROL */
        /* offset address */    0xD40604,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_MULTIPLEXER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT7_OAM_MULTIPLEXER_CONTROL */
        /* offset address */    0xD40704,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_MULTIPLEXER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT8_OAM_MULTIPLEXER_CONTROL */
        /* offset address */    0xD40804,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_MULTIPLEXER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT9_OAM_MULTIPLEXER_CONTROL */
        /* offset address */    0xD40904,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_MULTIPLEXER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT10_OAM_MULTIPLEXER_CONTROL */
        /* offset address */    0xD40A04,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_MULTIPLEXER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT11_OAM_MULTIPLEXER_CONTROL */
        /* offset address */    0xD40B04,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_MULTIPLEXER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT12_OAM_MULTIPLEXER_CONTROL */
        /* offset address */    0xD40C04,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_MULTIPLEXER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT13_OAM_MULTIPLEXER_CONTROL */
        /* offset address */    0xD40D04,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_MULTIPLEXER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT14_OAM_MULTIPLEXER_CONTROL */
        /* offset address */    0xD40E04,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_MULTIPLEXER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT15_OAM_MULTIPLEXER_CONTROL */
        /* offset address */    0xD40F04,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_MULTIPLEXER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT16_OAM_MULTIPLEXER_CONTROL */
        /* offset address */    0xD41004,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_MULTIPLEXER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT17_OAM_MULTIPLEXER_CONTROL */
        /* offset address */    0xD41104,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_MULTIPLEXER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT18_OAM_MULTIPLEXER_CONTROL */
        /* offset address */    0xD41204,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_MULTIPLEXER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT19_OAM_MULTIPLEXER_CONTROL */
        /* offset address */    0xD41304,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_MULTIPLEXER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT20_OAM_MULTIPLEXER_CONTROL */
        /* offset address */    0xD41404,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_MULTIPLEXER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT21_OAM_MULTIPLEXER_CONTROL */
        /* offset address */    0xD41504,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_MULTIPLEXER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT22_OAM_MULTIPLEXER_CONTROL */
        /* offset address */    0xD41604,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_MULTIPLEXER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT23_OAM_MULTIPLEXER_CONTROL */
        /* offset address */    0xD41704,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_MULTIPLEXER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT24_OAM_MULTIPLEXER_CONTROL */
        /* offset address */    0xD41804,
        /* field numbers */     2,
        /* register fields */   PORT_OAM_MULTIPLEXER_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Dying_Gasp_Power_Monitor_Circuit_Deglitch */
        /* offset address */    0x590000,
        /* field numbers */     2,
        /* register fields */   DYING_GASP_POWER_MONITOR_CIRCUIT_DEGLITCH_FIELDS,
        /* default value */     0x32
    },
    {   /* register name        CPU_Port_Global_Control */
        /* offset address */    0x590004,
        /* field numbers */     3,
        /* register fields */   CPU_PORT_GLOBAL_CONTROL_FIELDS,
        /* default value */     0x2
    },
    {   /* register name        PORT23_OAM_Dying_Gasp_Control */
        /* offset address */    0xD91700,
        /* field numbers */     4,
        /* register fields */   PORT_OAM_DYING_GASP_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT24_OAM_Dying_Gasp_Control */
        /* offset address */    0xD91800,
        /* field numbers */     4,
        /* register fields */   PORT_OAM_DYING_GASP_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT23_OAM_Local_Dying_Gasp_Control0 */
        /* offset address */    0xD91704,
        /* field numbers */     1,
        /* register fields */   PORT_OAM_LOCAL_DYING_GASP_CONTROL0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT24_OAM_Local_Dying_Gasp_Control0 */
        /* offset address */    0xD91804,
        /* field numbers */     1,
        /* register fields */   PORT_OAM_LOCAL_DYING_GASP_CONTROL0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT23_OAM_Local_Dying_Gasp_Control1 */
        /* offset address */    0xD91708,
        /* field numbers */     1,
        /* register fields */   PORT_OAM_LOCAL_DYING_GASP_CONTROL1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT24_OAM_Local_Dying_Gasp_Control1 */
        /* offset address */    0xD91808,
        /* field numbers */     1,
        /* register fields */   PORT_OAM_LOCAL_DYING_GASP_CONTROL1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT23_OAM_Local_Dying_Gasp_Control2 */
        /* offset address */    0xD9170C,
        /* field numbers */     1,
        /* register fields */   PORT_OAM_LOCAL_DYING_GASP_CONTROL2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT24_OAM_Local_Dying_Gasp_Control2 */
        /* offset address */    0xD9180C,
        /* field numbers */     1,
        /* register fields */   PORT_OAM_LOCAL_DYING_GASP_CONTROL2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT23_OAM_Local_Dying_Gasp_Control3 */
        /* offset address */    0xD91710,
        /* field numbers */     1,
        /* register fields */   PORT_OAM_LOCAL_DYING_GASP_CONTROL3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT24_OAM_Local_Dying_Gasp_Control3 */
        /* offset address */    0xD91810,
        /* field numbers */     1,
        /* register fields */   PORT_OAM_LOCAL_DYING_GASP_CONTROL3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT23_OAM_Remote_Dying_Gasp_Control0 */
        /* offset address */    0xD91714,
        /* field numbers */     1,
        /* register fields */   PORT_OAM_REMOTE_DYING_GASP_CONTROL0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT24_OAM_Remote_Dying_Gasp_Control0 */
        /* offset address */    0xD91814,
        /* field numbers */     1,
        /* register fields */   PORT_OAM_REMOTE_DYING_GASP_CONTROL0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT23_OAM_Remote_Dying_Gasp_Control1 */
        /* offset address */    0xD91718,
        /* field numbers */     1,
        /* register fields */   PORT_OAM_REMOTE_DYING_GASP_CONTROL1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT24_OAM_Remote_Dying_Gasp_Control1 */
        /* offset address */    0xD91818,
        /* field numbers */     1,
        /* register fields */   PORT_OAM_REMOTE_DYING_GASP_CONTROL1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT23_OAM_Remote_Dying_Gasp_Control2 */
        /* offset address */    0xD9171C,
        /* field numbers */     1,
        /* register fields */   PORT_OAM_REMOTE_DYING_GASP_CONTROL2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT24_OAM_Remote_Dying_Gasp_Control2 */
        /* offset address */    0xD9181C,
        /* field numbers */     1,
        /* register fields */   PORT_OAM_REMOTE_DYING_GASP_CONTROL2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT23_OAM_Remote_Dying_Gasp_Control3 */
        /* offset address */    0xD91720,
        /* field numbers */     1,
        /* register fields */   PORT_OAM_REMOTE_DYING_GASP_CONTROL3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT24_OAM_Remote_Dying_Gasp_Control3 */
        /* offset address */    0xD91820,
        /* field numbers */     1,
        /* register fields */   PORT_OAM_REMOTE_DYING_GASP_CONTROL3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT23_TX_TAG_CONTROL */
        /* offset address */    0x550000,
        /* field numbers */     14,
        /* register fields */   PORT23_TX_TAG_CONTROL_FIELDS,
        /* default value */     0x41
    },
    {   /* register name        PORT24_TX_TAG_CONTROL */
        /* offset address */    0x550004,
        /* field numbers */     14,
        /* register fields */   PORT24_TX_TAG_CONTROL_FIELDS,
        /* default value */     0x41
    },
    {   /* register name        PORT0_TX_TAG_CONTROL */
        /* offset address */    0xD50000,
        /* field numbers */     12,
        /* register fields */   PORT_TX_TAG_CONTROL_FIELDS,
        /* default value */     0x21
    },
    {   /* register name        PORT1_TX_TAG_CONTROL */
        /* offset address */    0xD50100,
        /* field numbers */     12,
        /* register fields */   PORT_TX_TAG_CONTROL_FIELDS,
        /* default value */     0x21
    },
    {   /* register name        PORT2_TX_TAG_CONTROL */
        /* offset address */    0xD50200,
        /* field numbers */     12,
        /* register fields */   PORT_TX_TAG_CONTROL_FIELDS,
        /* default value */     0x21
    },
    {   /* register name        PORT3_TX_TAG_CONTROL */
        /* offset address */    0xD50300,
        /* field numbers */     12,
        /* register fields */   PORT_TX_TAG_CONTROL_FIELDS,
        /* default value */     0x21
    },
    {   /* register name        PORT4_TX_TAG_CONTROL */
        /* offset address */    0xD50400,
        /* field numbers */     12,
        /* register fields */   PORT_TX_TAG_CONTROL_FIELDS,
        /* default value */     0x21
    },
    {   /* register name        PORT5_TX_TAG_CONTROL */
        /* offset address */    0xD50500,
        /* field numbers */     12,
        /* register fields */   PORT_TX_TAG_CONTROL_FIELDS,
        /* default value */     0x21
    },
    {   /* register name        PORT6_TX_TAG_CONTROL */
        /* offset address */    0xD50600,
        /* field numbers */     12,
        /* register fields */   PORT_TX_TAG_CONTROL_FIELDS,
        /* default value */     0x21
    },
    {   /* register name        PORT7_TX_TAG_CONTROL */
        /* offset address */    0xD50700,
        /* field numbers */     12,
        /* register fields */   PORT_TX_TAG_CONTROL_FIELDS,
        /* default value */     0x21
    },
    {   /* register name        PORT8_TX_TAG_CONTROL */
        /* offset address */    0xD50800,
        /* field numbers */     12,
        /* register fields */   PORT_TX_TAG_CONTROL_FIELDS,
        /* default value */     0x21
    },
    {   /* register name        PORT9_TX_TAG_CONTROL */
        /* offset address */    0xD50900,
        /* field numbers */     12,
        /* register fields */   PORT_TX_TAG_CONTROL_FIELDS,
        /* default value */     0x21
    },
    {   /* register name        PORT10_TX_TAG_CONTROL */
        /* offset address */    0xD50A00,
        /* field numbers */     12,
        /* register fields */   PORT_TX_TAG_CONTROL_FIELDS,
        /* default value */     0x21
    },
    {   /* register name        PORT11_TX_TAG_CONTROL */
        /* offset address */    0xD50B00,
        /* field numbers */     12,
        /* register fields */   PORT_TX_TAG_CONTROL_FIELDS,
        /* default value */     0x21
    },
    {   /* register name        PORT12_TX_TAG_CONTROL */
        /* offset address */    0xD50C00,
        /* field numbers */     12,
        /* register fields */   PORT_TX_TAG_CONTROL_FIELDS,
        /* default value */     0x21
    },
    {   /* register name        PORT13_TX_TAG_CONTROL */
        /* offset address */    0xD50D00,
        /* field numbers */     12,
        /* register fields */   PORT_TX_TAG_CONTROL_FIELDS,
        /* default value */     0x21
    },
    {   /* register name        PORT14_TX_TAG_CONTROL */
        /* offset address */    0xD50E00,
        /* field numbers */     12,
        /* register fields */   PORT_TX_TAG_CONTROL_FIELDS,
        /* default value */     0x21
    },
    {   /* register name        PORT15_TX_TAG_CONTROL */
        /* offset address */    0xD50F00,
        /* field numbers */     12,
        /* register fields */   PORT_TX_TAG_CONTROL_FIELDS,
        /* default value */     0x21
    },
    {   /* register name        PORT16_TX_TAG_CONTROL */
        /* offset address */    0xD51000,
        /* field numbers */     12,
        /* register fields */   PORT_TX_TAG_CONTROL_FIELDS,
        /* default value */     0x21
    },
    {   /* register name        PORT17_TX_TAG_CONTROL */
        /* offset address */    0xD51100,
        /* field numbers */     12,
        /* register fields */   PORT_TX_TAG_CONTROL_FIELDS,
        /* default value */     0x21
    },
    {   /* register name        PORT18_TX_TAG_CONTROL */
        /* offset address */    0xD51200,
        /* field numbers */     12,
        /* register fields */   PORT_TX_TAG_CONTROL_FIELDS,
        /* default value */     0x21
    },
    {   /* register name        PORT19_TX_TAG_CONTROL */
        /* offset address */    0xD51300,
        /* field numbers */     12,
        /* register fields */   PORT_TX_TAG_CONTROL_FIELDS,
        /* default value */     0x21
    },
    {   /* register name        PORT20_TX_TAG_CONTROL */
        /* offset address */    0xD51400,
        /* field numbers */     12,
        /* register fields */   PORT_TX_TAG_CONTROL_FIELDS,
        /* default value */     0x21
    },
    {   /* register name        PORT21_TX_TAG_CONTROL */
        /* offset address */    0xD51500,
        /* field numbers */     12,
        /* register fields */   PORT_TX_TAG_CONTROL_FIELDS,
        /* default value */     0x21
    },
    {   /* register name        PORT22_TX_TAG_CONTROL */
        /* offset address */    0xD51600,
        /* field numbers */     12,
        /* register fields */   PORT_TX_TAG_CONTROL_FIELDS,
        /* default value */     0x21
    },
    {   /* register name        RTCT_Global_Control */
        /* offset address */    0x560000,
        /* field numbers */     13,
        /* register fields */   RTCT_GLOBAL_CONTROL_FIELDS,
        /* default value */     0x3C0
    },
    {   /* register name        RTCT_Mask */
        /* offset address */    0x560004,
        /* field numbers */     28,
        /* register fields */   RTCT_MASK_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT22_RTCT_Result0_for_giga */
        /* offset address */    0x560008,
        /* field numbers */     9,
        /* register fields */   PORT22_RTCT_RESULT0_FOR_GIGA_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT22_RTCT_Result1_for_giga */
        /* offset address */    0x56000C,
        /* field numbers */     3,
        /* register fields */   PORT22_RTCT_RESULT1_FOR_GIGA_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT23_RTCT_Result0_for_giga */
        /* offset address */    0x560010,
        /* field numbers */     9,
        /* register fields */   PORT23_RTCT_RESULT0_FOR_GIGA_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT23_RTCT_Result1_for_giga */
        /* offset address */    0x560014,
        /* field numbers */     3,
        /* register fields */   PORT23_RTCT_RESULT1_FOR_GIGA_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT24_RTCT_Result0_for_giga */
        /* offset address */    0x560018,
        /* field numbers */     9,
        /* register fields */   PORT24_RTCT_RESULT0_FOR_GIGA_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT24_RTCT_Result1_for_giga */
        /* offset address */    0x56001C,
        /* field numbers */     3,
        /* register fields */   PORT24_RTCT_RESULT1_FOR_GIGA_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT0_RTCT_Result0 */
        /* offset address */    0xD60000,
        /* field numbers */     10,
        /* register fields */   PORT_RTCT_RESULT0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT1_RTCT_Result0 */
        /* offset address */    0xD60100,
        /* field numbers */     10,
        /* register fields */   PORT_RTCT_RESULT0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT2_RTCT_Result0 */
        /* offset address */    0xD60200,
        /* field numbers */     10,
        /* register fields */   PORT_RTCT_RESULT0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT3_RTCT_Result0 */
        /* offset address */    0xD60300,
        /* field numbers */     10,
        /* register fields */   PORT_RTCT_RESULT0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT4_RTCT_Result0 */
        /* offset address */    0xD60400,
        /* field numbers */     10,
        /* register fields */   PORT_RTCT_RESULT0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT5_RTCT_Result0 */
        /* offset address */    0xD60500,
        /* field numbers */     10,
        /* register fields */   PORT_RTCT_RESULT0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT6_RTCT_Result0 */
        /* offset address */    0xD60600,
        /* field numbers */     10,
        /* register fields */   PORT_RTCT_RESULT0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT7_RTCT_Result0 */
        /* offset address */    0xD60700,
        /* field numbers */     10,
        /* register fields */   PORT_RTCT_RESULT0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT8_RTCT_Result0 */
        /* offset address */    0xD60800,
        /* field numbers */     10,
        /* register fields */   PORT_RTCT_RESULT0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT9_RTCT_Result0 */
        /* offset address */    0xD60900,
        /* field numbers */     10,
        /* register fields */   PORT_RTCT_RESULT0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT10_RTCT_Result0 */
        /* offset address */    0xD60A00,
        /* field numbers */     10,
        /* register fields */   PORT_RTCT_RESULT0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT11_RTCT_Result0 */
        /* offset address */    0xD60B00,
        /* field numbers */     10,
        /* register fields */   PORT_RTCT_RESULT0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT12_RTCT_Result0 */
        /* offset address */    0xD60C00,
        /* field numbers */     10,
        /* register fields */   PORT_RTCT_RESULT0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT13_RTCT_Result0 */
        /* offset address */    0xD60D00,
        /* field numbers */     10,
        /* register fields */   PORT_RTCT_RESULT0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT14_RTCT_Result0 */
        /* offset address */    0xD60E00,
        /* field numbers */     10,
        /* register fields */   PORT_RTCT_RESULT0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT15_RTCT_Result0 */
        /* offset address */    0xD60F00,
        /* field numbers */     10,
        /* register fields */   PORT_RTCT_RESULT0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT16_RTCT_Result0 */
        /* offset address */    0xD61000,
        /* field numbers */     10,
        /* register fields */   PORT_RTCT_RESULT0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT17_RTCT_Result0 */
        /* offset address */    0xD61100,
        /* field numbers */     10,
        /* register fields */   PORT_RTCT_RESULT0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT18_RTCT_Result0 */
        /* offset address */    0xD61200,
        /* field numbers */     10,
        /* register fields */   PORT_RTCT_RESULT0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT19_RTCT_Result0 */
        /* offset address */    0xD61300,
        /* field numbers */     10,
        /* register fields */   PORT_RTCT_RESULT0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT20_RTCT_Result0 */
        /* offset address */    0xD61400,
        /* field numbers */     10,
        /* register fields */   PORT_RTCT_RESULT0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT21_RTCT_Result0 */
        /* offset address */    0xD61500,
        /* field numbers */     10,
        /* register fields */   PORT_RTCT_RESULT0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT22_RTCT_Result0 */
        /* offset address */    0xD61600,
        /* field numbers */     10,
        /* register fields */   PORT_RTCT_RESULT0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT23_RTCT_Result0 */
        /* offset address */    0xD61700,
        /* field numbers */     10,
        /* register fields */   PORT_RTCT_RESULT0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT24_RTCT_Result0 */
        /* offset address */    0xD61800,
        /* field numbers */     10,
        /* register fields */   PORT_RTCT_RESULT0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT0_RTCT_Result1 */
        /* offset address */    0xD60004,
        /* field numbers */     3,
        /* register fields */   PORT_RTCT_RESULT1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT1_RTCT_Result1 */
        /* offset address */    0xD60104,
        /* field numbers */     3,
        /* register fields */   PORT_RTCT_RESULT1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT2_RTCT_Result1 */
        /* offset address */    0xD60204,
        /* field numbers */     3,
        /* register fields */   PORT_RTCT_RESULT1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT3_RTCT_Result1 */
        /* offset address */    0xD60304,
        /* field numbers */     3,
        /* register fields */   PORT_RTCT_RESULT1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT4_RTCT_Result1 */
        /* offset address */    0xD60404,
        /* field numbers */     3,
        /* register fields */   PORT_RTCT_RESULT1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT5_RTCT_Result1 */
        /* offset address */    0xD60504,
        /* field numbers */     3,
        /* register fields */   PORT_RTCT_RESULT1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT6_RTCT_Result1 */
        /* offset address */    0xD60604,
        /* field numbers */     3,
        /* register fields */   PORT_RTCT_RESULT1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT7_RTCT_Result1 */
        /* offset address */    0xD60704,
        /* field numbers */     3,
        /* register fields */   PORT_RTCT_RESULT1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT8_RTCT_Result1 */
        /* offset address */    0xD60804,
        /* field numbers */     3,
        /* register fields */   PORT_RTCT_RESULT1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT9_RTCT_Result1 */
        /* offset address */    0xD60904,
        /* field numbers */     3,
        /* register fields */   PORT_RTCT_RESULT1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT10_RTCT_Result1 */
        /* offset address */    0xD60A04,
        /* field numbers */     3,
        /* register fields */   PORT_RTCT_RESULT1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT11_RTCT_Result1 */
        /* offset address */    0xD60B04,
        /* field numbers */     3,
        /* register fields */   PORT_RTCT_RESULT1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT12_RTCT_Result1 */
        /* offset address */    0xD60C04,
        /* field numbers */     3,
        /* register fields */   PORT_RTCT_RESULT1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT13_RTCT_Result1 */
        /* offset address */    0xD60D04,
        /* field numbers */     3,
        /* register fields */   PORT_RTCT_RESULT1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT14_RTCT_Result1 */
        /* offset address */    0xD60E04,
        /* field numbers */     3,
        /* register fields */   PORT_RTCT_RESULT1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT15_RTCT_Result1 */
        /* offset address */    0xD60F04,
        /* field numbers */     3,
        /* register fields */   PORT_RTCT_RESULT1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT16_RTCT_Result1 */
        /* offset address */    0xD61004,
        /* field numbers */     3,
        /* register fields */   PORT_RTCT_RESULT1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT17_RTCT_Result1 */
        /* offset address */    0xD61104,
        /* field numbers */     3,
        /* register fields */   PORT_RTCT_RESULT1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT18_RTCT_Result1 */
        /* offset address */    0xD61204,
        /* field numbers */     3,
        /* register fields */   PORT_RTCT_RESULT1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT19_RTCT_Result1 */
        /* offset address */    0xD61304,
        /* field numbers */     3,
        /* register fields */   PORT_RTCT_RESULT1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT20_RTCT_Result1 */
        /* offset address */    0xD61404,
        /* field numbers */     3,
        /* register fields */   PORT_RTCT_RESULT1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT21_RTCT_Result1 */
        /* offset address */    0xD61504,
        /* field numbers */     3,
        /* register fields */   PORT_RTCT_RESULT1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT22_RTCT_Result1 */
        /* offset address */    0xD61604,
        /* field numbers */     3,
        /* register fields */   PORT_RTCT_RESULT1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT23_RTCT_Result1 */
        /* offset address */    0xD61704,
        /* field numbers */     3,
        /* register fields */   PORT_RTCT_RESULT1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT24_RTCT_Result1 */
        /* offset address */    0xD61804,
        /* field numbers */     3,
        /* register fields */   PORT_RTCT_RESULT1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        CPU_8051_Reset */
        /* offset address */    0x580000,
        /* field numbers */     3,
        /* register fields */   CPU_8051_RESET_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Command_type */
        /* offset address */    0x580004,
        /* field numbers */     5,
        /* register fields */   COMMAND_TYPE_FIELDS,
        /* default value */     0x20
    },
    {   /* register name        Destination_Memory_Address */
        /* offset address */    0x580008,
        /* field numbers */     2,
        /* register fields */   DESTINATION_MEMORY_ADDRESS_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Source_Memory_Address */
        /* offset address */    0x58000C,
        /* field numbers */     2,
        /* register fields */   SOURCE_MEMORY_ADDRESS_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Data_Length_Resigter */
        /* offset address */    0x580010,
        /* field numbers */     2,
        /* register fields */   DATA_LENGTH_RESIGTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Flash_Page_Number */
        /* offset address */    0x580014,
        /* field numbers */     2,
        /* register fields */   FLASH_PAGE_NUMBER_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        Nor_Flash_Configuration */
        /* offset address */    0x580018,
        /* field numbers */     3,
        /* register fields */   NOR_FLASH_CONFIGURATION_FIELDS,
        /* default value */     0x60
    },
    {   /* register name        INTERNAL_MEMORY_CONTROL */
        /* offset address */    0x58001C,
        /* field numbers */     4,
        /* register fields */   INTERNAL_MEMORY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        INTERNAL_MEMORY_DATA0 */
        /* offset address */    0x580020,
        /* field numbers */     1,
        /* register fields */   INTERNAL_MEMORY_DATA0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        INTERNAL_MEMORY_DATA1 */
        /* offset address */    0x580024,
        /* field numbers */     1,
        /* register fields */   INTERNAL_MEMORY_DATA1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        SwitchAccess_Address */
        /* offset address */    0x580028,
        /* field numbers */     1,
        /* register fields */   SWITCHACCESS_ADDRESS_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        SwitchAccess_Data */
        /* offset address */    0x58002C,
        /* field numbers */     1,
        /* register fields */   SWITCHACCESS_DATA_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        SwitchAccess_Control */
        /* offset address */    0x580030,
        /* field numbers */     3,
        /* register fields */   SWITCHACCESS_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Indirect_Access_Flash_Address */
        /* offset address */    0x580034,
        /* field numbers */     2,
        /* register fields */   INDIRECT_ACCESS_FLASH_ADDRESS_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Indirect_Access_Flash_Data */
        /* offset address */    0x580038,
        /* field numbers */     2,
        /* register fields */   INDIRECT_ACCESS_FLASH_DATA_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Indirect_Access_Flash_Control */
        /* offset address */    0x58003C,
        /* field numbers */     3,
        /* register fields */   INDIRECT_ACCESS_FLASH_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        SPI_Controller_Global */
        /* offset address */    0x580040,
        /* field numbers */     11,
        /* register fields */   SPI_CONTROLLER_GLOBAL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        SPI_RImode_control */
        /* offset address */    0x580044,
        /* field numbers */     8,
        /* register fields */   SPI_RIMODE_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        SPI_SMODE_Control */
        /* offset address */    0x580048,
        /* field numbers */     11,
        /* register fields */   SPI_SMODE_CONTROL_FIELDS,
        /* default value */     0x3
    },
    {   /* register name        SPI_SMODE_Address */
        /* offset address */    0x58004C,
        /* field numbers */     2,
        /* register fields */   SPI_SMODE_ADDRESS_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        SPI_SMODE_Data */
        /* offset address */    0x580050,
        /* field numbers */     1,
        /* register fields */   SPI_SMODE_DATA_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        CPU_Interrupt_PS2LVL */
        /* offset address */    0x580054,
        /* field numbers */     2,
        /* register fields */   CPU_INTERRUPT_PS2LVL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        RRCP_Global_CONTROL */
        /* offset address */    0x600000,
        /* field numbers */     19,
        /* register fields */   RRCP_GLOBAL_CONTROL_FIELDS,
        /* default value */     0x7E030
    },
    {   /* register name        RRCP_Private_Key_Control */
        /* offset address */    0x600004,
        /* field numbers */     1,
        /* register fields */   RRCP_PRIVATE_KEY_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        RRCP_Authentication_Key_Control */
        /* offset address */    0x600008,
        /* field numbers */     2,
        /* register fields */   RRCP_AUTHENTICATION_KEY_CONTROL_FIELDS,
        /* default value */     0x2379
    },
    {   /* register name        RRCP_Default_FID_Control */
        /* offset address */    0x60000C,
        /* field numbers */     2,
        /* register fields */   RRCP_DEFAULT_FID_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        RRCP_Inner_Tag_Control */
        /* offset address */    0x600010,
        /* field numbers */     4,
        /* register fields */   RRCP_INNER_TAG_CONTROL_FIELDS,
        /* default value */     0x81000000
    },
    {   /* register name        RRCP_outer_Tag_Control */
        /* offset address */    0x600014,
        /* field numbers */     4,
        /* register fields */   RRCP_OUTER_TAG_CONTROL_FIELDS,
        /* default value */     0x88A80000
    },
    {   /* register name        RRCP_Hello_indication_control */
        /* offset address */    0x600018,
        /* field numbers */     3,
        /* register fields */   RRCP_HELLO_INDICATION_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Switch_Own_MAC_Control0 */
        /* offset address */    0x60001C,
        /* field numbers */     1,
        /* register fields */   SWITCH_OWN_MAC_CONTROL0_FIELDS,
        /* default value */     0x52544C83
    },
    {   /* register name        Switch_Own_MAC_Control1 */
        /* offset address */    0x600020,
        /* field numbers */     5,
        /* register fields */   SWITCH_OWN_MAC_CONTROL1_FIELDS,
        /* default value */     0x101644
    },
    {   /* register name        Switch_CHIP_ID_Control */
        /* offset address */    0x600024,
        /* field numbers */     3,
        /* register fields */   SWITCH_CHIP_ID_CONTROL_FIELDS,
        /* default value */     0x12500
    },
    {   /* register name        Switch_Vender_ID_Control */
        /* offset address */    0x600028,
        /* field numbers */     1,
        /* register fields */   SWITCH_VENDER_ID_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        RRCP_Administrable_Control */
        /* offset address */    0x60002C,
        /* field numbers */     2,
        /* register fields */   RRCP_ADMINISTRABLE_CONTROL_FIELDS,
        /* default value */     0x1
    },
    {   /* register name        RRCP_Authenticaed_Control */
        /* offset address */    0x600030,
        /* field numbers */     2,
        /* register fields */   RRCP_AUTHENTICAED_CONTROL_FIELDS,
        /* default value */     0x1FFFFFF
    },
    {   /* register name        RRCP_Port_Debug_control */
        /* offset address */    0x600034,
        /* field numbers */     3,
        /* register fields */   RRCP_PORT_DEBUG_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Simple_Packet_Generator_Control0 */
        /* offset address */    0x600038,
        /* field numbers */     7,
        /* register fields */   SIMPLE_PACKET_GENERATOR_CONTROL0_FIELDS,
        /* default value */     0x4000
    },
    {   /* register name        Simple_Packet_Generator_Control1 */
        /* offset address */    0x60003C,
        /* field numbers */     1,
        /* register fields */   SIMPLE_PACKET_GENERATOR_CONTROL1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Simple_Packet_Generator_Control2 */
        /* offset address */    0x600040,
        /* field numbers */     2,
        /* register fields */   SIMPLE_PACKET_GENERATOR_CONTROL2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Simple_Packet_Generator_Control3 */
        /* offset address */    0x600044,
        /* field numbers */     1,
        /* register fields */   SIMPLE_PACKET_GENERATOR_CONTROL3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Simple_Packet_Generator_Control4 */
        /* offset address */    0x600048,
        /* field numbers */     2,
        /* register fields */   SIMPLE_PACKET_GENERATOR_CONTROL4_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Simple_Packet_Generator_Control5 */
        /* offset address */    0x60004C,
        /* field numbers */     1,
        /* register fields */   SIMPLE_PACKET_GENERATOR_CONTROL5_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Simple_Packet_Generator_Control6 */
        /* offset address */    0x600050,
        /* field numbers */     1,
        /* register fields */   SIMPLE_PACKET_GENERATOR_CONTROL6_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Simple_Packet_Generator_Control7 */
        /* offset address */    0x600054,
        /* field numbers */     1,
        /* register fields */   SIMPLE_PACKET_GENERATOR_CONTROL7_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Simple_Packet_Generator_Control8 */
        /* offset address */    0x600058,
        /* field numbers */     1,
        /* register fields */   SIMPLE_PACKET_GENERATOR_CONTROL8_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Simple_Packet_Generator_Control9 */
        /* offset address */    0x60005C,
        /* field numbers */     4,
        /* register fields */   SIMPLE_PACKET_GENERATOR_CONTROL9_FIELDS,
        /* default value */     0x100
    },
    {   /* register name        RRCP_Customer_Code_Control */
        /* offset address */    0x600060,
        /* field numbers */     1,
        /* register fields */   RRCP_CUSTOMER_CODE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        RTKPP_Random_Number_Control0 */
        /* offset address */    0x610000,
        /* field numbers */     1,
        /* register fields */   RTKPP_RANDOM_NUMBER_CONTROL0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        RTKPP_Random_Number_Control1 */
        /* offset address */    0x610004,
        /* field numbers */     2,
        /* register fields */   RTKPP_RANDOM_NUMBER_CONTROL1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        RTKPP_Random_Number_Control2 */
        /* offset address */    0x610008,
        /* field numbers */     1,
        /* register fields */   RTKPP_RANDOM_NUMBER_CONTROL2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        RLDP_Loop_State_Retry_Control */
        /* offset address */    0x61000C,
        /* field numbers */     3,
        /* register fields */   RLDP_LOOP_STATE_RETRY_CONTROL_FIELDS,
        /* default value */     0xFF03E8
    },
    {   /* register name        RLDP_Check_State_Retry_Control */
        /* offset address */    0x610010,
        /* field numbers */     3,
        /* register fields */   RLDP_CHECK_STATE_RETRY_CONTROL_FIELDS,
        /* default value */     0xFFEA60
    },
    {   /* register name        RLDP_Enable_Port_Mask_Control */
        /* offset address */    0x610014,
        /* field numbers */     2,
        /* register fields */   RLDP_ENABLE_PORT_MASK_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        RLDP_Loop_Port_Mask_Control */
        /* offset address */    0x610018,
        /* field numbers */     2,
        /* register fields */   RLDP_LOOP_PORT_MASK_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        RLDP_Checking_Port_Mask_Control */
        /* offset address */    0x61001C,
        /* field numbers */     2,
        /* register fields */   RLDP_CHECKING_PORT_MASK_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        RLDP_Interrupt_Pending_Mask_Control */
        /* offset address */    0x610020,
        /* field numbers */     2,
        /* register fields */   RLDP_INTERRUPT_PENDING_MASK_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Source_MAC_Moving_Port_Mask */
        /* offset address */    0x610024,
        /* field numbers */     2,
        /* register fields */   SOURCE_MAC_MOVING_PORT_MASK_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        RLDP_Global_Control */
        /* offset address */    0x610028,
        /* field numbers */     8,
        /* register fields */   RLDP_GLOBAL_CONTROL_FIELDS,
        /* default value */     0x40
    },
    {   /* register name        Tx_Disable_Global_Control */
        /* offset address */    0x61002C,
        /* field numbers */     2,
        /* register fields */   TX_DISABLE_GLOBAL_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Rx_Disable_Global_Control */
        /* offset address */    0x610030,
        /* field numbers */     2,
        /* register fields */   RX_DISABLE_GLOBAL_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        UDLD_Global_Control */
        /* offset address */    0x610034,
        /* field numbers */     6,
        /* register fields */   UDLD_GLOBAL_CONTROL_FIELDS,
        /* default value */     0x10
    },
    {   /* register name        UDLD_Enabled_Port_Mask_Control */
        /* offset address */    0x610038,
        /* field numbers */     2,
        /* register fields */   UDLD_ENABLED_PORT_MASK_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        UDL_Port_Mask_Control */
        /* offset address */    0x61003C,
        /* field numbers */     2,
        /* register fields */   UDL_PORT_MASK_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        UDL_Interrupt_Pending_Mask_Control */
        /* offset address */    0x610040,
        /* field numbers */     2,
        /* register fields */   UDL_INTERRUPT_PENDING_MASK_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT0_Loop_Port */
        /* offset address */    0xE10000,
        /* field numbers */     2,
        /* register fields */   PORT_LOOP_PORT_FIELDS,
        /* default value */     0x1F
    },
    {   /* register name        PORT1_Loop_Port */
        /* offset address */    0xE10100,
        /* field numbers */     2,
        /* register fields */   PORT_LOOP_PORT_FIELDS,
        /* default value */     0x1F
    },
    {   /* register name        PORT2_Loop_Port */
        /* offset address */    0xE10200,
        /* field numbers */     2,
        /* register fields */   PORT_LOOP_PORT_FIELDS,
        /* default value */     0x1F
    },
    {   /* register name        PORT3_Loop_Port */
        /* offset address */    0xE10300,
        /* field numbers */     2,
        /* register fields */   PORT_LOOP_PORT_FIELDS,
        /* default value */     0x1F
    },
    {   /* register name        PORT4_Loop_Port */
        /* offset address */    0xE10400,
        /* field numbers */     2,
        /* register fields */   PORT_LOOP_PORT_FIELDS,
        /* default value */     0x1F
    },
    {   /* register name        PORT5_Loop_Port */
        /* offset address */    0xE10500,
        /* field numbers */     2,
        /* register fields */   PORT_LOOP_PORT_FIELDS,
        /* default value */     0x1F
    },
    {   /* register name        PORT6_Loop_Port */
        /* offset address */    0xE10600,
        /* field numbers */     2,
        /* register fields */   PORT_LOOP_PORT_FIELDS,
        /* default value */     0x1F
    },
    {   /* register name        PORT7_Loop_Port */
        /* offset address */    0xE10700,
        /* field numbers */     2,
        /* register fields */   PORT_LOOP_PORT_FIELDS,
        /* default value */     0x1F
    },
    {   /* register name        PORT8_Loop_Port */
        /* offset address */    0xE10800,
        /* field numbers */     2,
        /* register fields */   PORT_LOOP_PORT_FIELDS,
        /* default value */     0x1F
    },
    {   /* register name        PORT9_Loop_Port */
        /* offset address */    0xE10900,
        /* field numbers */     2,
        /* register fields */   PORT_LOOP_PORT_FIELDS,
        /* default value */     0x1F
    },
    {   /* register name        PORT10_Loop_Port */
        /* offset address */    0xE10A00,
        /* field numbers */     2,
        /* register fields */   PORT_LOOP_PORT_FIELDS,
        /* default value */     0x1F
    },
    {   /* register name        PORT11_Loop_Port */
        /* offset address */    0xE10B00,
        /* field numbers */     2,
        /* register fields */   PORT_LOOP_PORT_FIELDS,
        /* default value */     0x1F
    },
    {   /* register name        PORT12_Loop_Port */
        /* offset address */    0xE10C00,
        /* field numbers */     2,
        /* register fields */   PORT_LOOP_PORT_FIELDS,
        /* default value */     0x1F
    },
    {   /* register name        PORT13_Loop_Port */
        /* offset address */    0xE10D00,
        /* field numbers */     2,
        /* register fields */   PORT_LOOP_PORT_FIELDS,
        /* default value */     0x1F
    },
    {   /* register name        PORT14_Loop_Port */
        /* offset address */    0xE10E00,
        /* field numbers */     2,
        /* register fields */   PORT_LOOP_PORT_FIELDS,
        /* default value */     0x1F
    },
    {   /* register name        PORT15_Loop_Port */
        /* offset address */    0xE10F00,
        /* field numbers */     2,
        /* register fields */   PORT_LOOP_PORT_FIELDS,
        /* default value */     0x1F
    },
    {   /* register name        PORT16_Loop_Port */
        /* offset address */    0xE11000,
        /* field numbers */     2,
        /* register fields */   PORT_LOOP_PORT_FIELDS,
        /* default value */     0x1F
    },
    {   /* register name        PORT17_Loop_Port */
        /* offset address */    0xE11100,
        /* field numbers */     2,
        /* register fields */   PORT_LOOP_PORT_FIELDS,
        /* default value */     0x1F
    },
    {   /* register name        PORT18_Loop_Port */
        /* offset address */    0xE11200,
        /* field numbers */     2,
        /* register fields */   PORT_LOOP_PORT_FIELDS,
        /* default value */     0x1F
    },
    {   /* register name        PORT19_Loop_Port */
        /* offset address */    0xE11300,
        /* field numbers */     2,
        /* register fields */   PORT_LOOP_PORT_FIELDS,
        /* default value */     0x1F
    },
    {   /* register name        PORT20_Loop_Port */
        /* offset address */    0xE11400,
        /* field numbers */     2,
        /* register fields */   PORT_LOOP_PORT_FIELDS,
        /* default value */     0x1F
    },
    {   /* register name        PORT21_Loop_Port */
        /* offset address */    0xE11500,
        /* field numbers */     2,
        /* register fields */   PORT_LOOP_PORT_FIELDS,
        /* default value */     0x1F
    },
    {   /* register name        PORT22_Loop_Port */
        /* offset address */    0xE11600,
        /* field numbers */     2,
        /* register fields */   PORT_LOOP_PORT_FIELDS,
        /* default value */     0x1F
    },
    {   /* register name        PORT23_Loop_Port */
        /* offset address */    0xE11700,
        /* field numbers */     2,
        /* register fields */   PORT_LOOP_PORT_FIELDS,
        /* default value */     0x1F
    },
    {   /* register name        PORT24_Loop_Port */
        /* offset address */    0xE11800,
        /* field numbers */     2,
        /* register fields */   PORT_LOOP_PORT_FIELDS,
        /* default value */     0x1F
    },
    {   /* register name        MIB_COUNTER_CONTROL0 */
        /* offset address */    0x640000,
        /* field numbers */     6,
        /* register fields */   MIB_COUNTER_CONTROL0_FIELDS,
        /* default value */     0x8
    },
    {   /* register name        MIB_COUNTER_CONTROL1 */
        /* offset address */    0x640004,
        /* field numbers */     29,
        /* register fields */   MIB_COUNTER_CONTROL1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        MIB_COUNTER_CONTROL2 */
        /* offset address */    0x640008,
        /* field numbers */     29,
        /* register fields */   MIB_COUNTER_CONTROL2_FIELDS,
        /* default value */     0xFFFFFFF
    },
    {   /* register name        INDIRECT_ACCESS_MIB_COUNTER_CONTROLFor_CPU */
        /* offset address */    0x64000C,
        /* field numbers */     3,
        /* register fields */   INDIRECT_ACCESS_MIB_COUNTER_CONTROLFOR_CPU_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        INDIRECT_ACCESS_MIB_COUNTER_DATA0_For_CPU */
        /* offset address */    0x640010,
        /* field numbers */     1,
        /* register fields */   INDIRECT_ACCESS_MIB_COUNTER_DATA0_FOR_CPU_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        INDIRECT_ACCESS_MIB_COUNTER_DATA1_For_CPU */
        /* offset address */    0x640014,
        /* field numbers */     1,
        /* register fields */   INDIRECT_ACCESS_MIB_COUNTER_DATA1_FOR_CPU_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        QUEUE_MIB_COUNTER_COUNT_TYPE_SELECTION */
        /* offset address */    0x640018,
        /* field numbers */     26,
        /* register fields */   QUEUE_MIB_COUNTER_COUNT_TYPE_SELECTION_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        GLOBAL_MIB_COUNTER_OVERFLOW_FLAG */
        /* offset address */    0x64001C,
        /* field numbers */     27,
        /* register fields */   GLOBAL_MIB_COUNTER_OVERFLOW_FLAG_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        SYSTEM_MIB_COUNTER_OVERFLOW_FLAG */
        /* offset address */    0x640020,
        /* field numbers */     2,
        /* register fields */   SYSTEM_MIB_COUNTER_OVERFLOW_FLAG_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT0_MIBCOUNTER_OVERFLOW_FLAG0 */
        /* offset address */    0x640024,
        /* field numbers */     32,
        /* register fields */   PORT0_MIBCOUNTER_OVERFLOW_FLAG0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT0_MIBCOUNTER_OVERFLOW_FLAG1 */
        /* offset address */    0x640028,
        /* field numbers */     9,
        /* register fields */   PORT0_MIBCOUNTER_OVERFLOW_FLAG1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT1_MIBCOUNTER_OVERFLOW_FLAG0 */
        /* offset address */    0x64002C,
        /* field numbers */     32,
        /* register fields */   PORT1_MIBCOUNTER_OVERFLOW_FLAG0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT1_MIBCOUNTER_OVERFLOW_FLAG1 */
        /* offset address */    0x640030,
        /* field numbers */     9,
        /* register fields */   PORT1_MIBCOUNTER_OVERFLOW_FLAG1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT2_MIBCOUNTER_OVERFLOW_FLAG0 */
        /* offset address */    0x640034,
        /* field numbers */     32,
        /* register fields */   PORT2_MIBCOUNTER_OVERFLOW_FLAG0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT2_MIBCOUNTER_OVERFLOW_FLAG1 */
        /* offset address */    0x640038,
        /* field numbers */     9,
        /* register fields */   PORT2_MIBCOUNTER_OVERFLOW_FLAG1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT3_MIBCOUNTER_OVERFLOW_FLAG0 */
        /* offset address */    0x64003C,
        /* field numbers */     32,
        /* register fields */   PORT3_MIBCOUNTER_OVERFLOW_FLAG0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT3_MIBCOUNTER_OVERFLOW_FLAG1 */
        /* offset address */    0x640040,
        /* field numbers */     9,
        /* register fields */   PORT3_MIBCOUNTER_OVERFLOW_FLAG1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT4_MIBCOUNTER_OVERFLOW_FLAG0 */
        /* offset address */    0x640044,
        /* field numbers */     32,
        /* register fields */   PORT4_MIBCOUNTER_OVERFLOW_FLAG0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT4_MIBCOUNTER_OVERFLOW_FLAG1 */
        /* offset address */    0x640048,
        /* field numbers */     9,
        /* register fields */   PORT4_MIBCOUNTER_OVERFLOW_FLAG1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT5_MIBCOUNTER_OVERFLOW_FLAG0 */
        /* offset address */    0x64004C,
        /* field numbers */     32,
        /* register fields */   PORT5_MIBCOUNTER_OVERFLOW_FLAG0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT5_MIBCOUNTER_OVERFLOW_FLAG1 */
        /* offset address */    0x640050,
        /* field numbers */     9,
        /* register fields */   PORT5_MIBCOUNTER_OVERFLOW_FLAG1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT6_MIBCOUNTER_OVERFLOW_FLAG0 */
        /* offset address */    0x640054,
        /* field numbers */     32,
        /* register fields */   PORT6_MIBCOUNTER_OVERFLOW_FLAG0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT6_MIBCOUNTER_OVERFLOW_FLAG1 */
        /* offset address */    0x640058,
        /* field numbers */     9,
        /* register fields */   PORT6_MIBCOUNTER_OVERFLOW_FLAG1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT7_MIBCOUNTER_OVERFLOW_FLAG0 */
        /* offset address */    0x64005C,
        /* field numbers */     32,
        /* register fields */   PORT7_MIBCOUNTER_OVERFLOW_FLAG0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT7_MIBCOUNTER_OVERFLOW_FLAG1 */
        /* offset address */    0x640060,
        /* field numbers */     9,
        /* register fields */   PORT7_MIBCOUNTER_OVERFLOW_FLAG1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT8_MIBCOUNTER_OVERFLOW_FLAG0 */
        /* offset address */    0x640064,
        /* field numbers */     32,
        /* register fields */   PORT8_MIBCOUNTER_OVERFLOW_FLAG0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT8_MIBCOUNTER_OVERFLOW_FLAG1 */
        /* offset address */    0x640068,
        /* field numbers */     9,
        /* register fields */   PORT8_MIBCOUNTER_OVERFLOW_FLAG1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT9_MIBCOUNTER_OVERFLOW_FLAG0 */
        /* offset address */    0x64006C,
        /* field numbers */     32,
        /* register fields */   PORT9_MIBCOUNTER_OVERFLOW_FLAG0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT9_MIBCOUNTER_OVERFLOW_FLAG1 */
        /* offset address */    0x640070,
        /* field numbers */     9,
        /* register fields */   PORT9_MIBCOUNTER_OVERFLOW_FLAG1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT10_MIBCOUNTER_OVERFLOW_FLAG0 */
        /* offset address */    0x640074,
        /* field numbers */     32,
        /* register fields */   PORT10_MIBCOUNTER_OVERFLOW_FLAG0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT10_MIBCOUNTER_OVERFLOW_FLAG1 */
        /* offset address */    0x640078,
        /* field numbers */     9,
        /* register fields */   PORT10_MIBCOUNTER_OVERFLOW_FLAG1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT11_MIBCOUNTER_OVERFLOW_FLAG0 */
        /* offset address */    0x64007C,
        /* field numbers */     32,
        /* register fields */   PORT11_MIBCOUNTER_OVERFLOW_FLAG0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT11_MIBCOUNTER_OVERFLOW_FLAG1 */
        /* offset address */    0x640080,
        /* field numbers */     9,
        /* register fields */   PORT11_MIBCOUNTER_OVERFLOW_FLAG1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT12_MIBCOUNTER_OVERFLOW_FLAG0 */
        /* offset address */    0x640084,
        /* field numbers */     32,
        /* register fields */   PORT12_MIBCOUNTER_OVERFLOW_FLAG0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT12_MIBCOUNTER_OVERFLOW_FLAG1 */
        /* offset address */    0x640088,
        /* field numbers */     9,
        /* register fields */   PORT12_MIBCOUNTER_OVERFLOW_FLAG1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT13_MIBCOUNTER_OVERFLOW_FLAG0 */
        /* offset address */    0x64008C,
        /* field numbers */     32,
        /* register fields */   PORT13_MIBCOUNTER_OVERFLOW_FLAG0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT13_MIBCOUNTER_OVERFLOW_FLAG1 */
        /* offset address */    0x640090,
        /* field numbers */     9,
        /* register fields */   PORT13_MIBCOUNTER_OVERFLOW_FLAG1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT14_MIBCOUNTER_OVERFLOW_FLAG0 */
        /* offset address */    0x640094,
        /* field numbers */     32,
        /* register fields */   PORT14_MIBCOUNTER_OVERFLOW_FLAG0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT14_MIBCOUNTER_OVERFLOW_FLAG1 */
        /* offset address */    0x640098,
        /* field numbers */     9,
        /* register fields */   PORT14_MIBCOUNTER_OVERFLOW_FLAG1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT15_MIBCOUNTER_OVERFLOW_FLAG0 */
        /* offset address */    0x64009C,
        /* field numbers */     32,
        /* register fields */   PORT15_MIBCOUNTER_OVERFLOW_FLAG0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT15_MIBCOUNTER_OVERFLOW_FLAG1 */
        /* offset address */    0x6400A0,
        /* field numbers */     9,
        /* register fields */   PORT15_MIBCOUNTER_OVERFLOW_FLAG1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT16_MIBCOUNTER_OVERFLOW_FLAG0 */
        /* offset address */    0x6400A4,
        /* field numbers */     32,
        /* register fields */   PORT16_MIBCOUNTER_OVERFLOW_FLAG0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT16_MIBCOUNTER_OVERFLOW_FLAG1 */
        /* offset address */    0x6400A8,
        /* field numbers */     9,
        /* register fields */   PORT16_MIBCOUNTER_OVERFLOW_FLAG1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT17_MIBCOUNTER_OVERFLOW_FLAG0 */
        /* offset address */    0x6400AC,
        /* field numbers */     32,
        /* register fields */   PORT17_MIBCOUNTER_OVERFLOW_FLAG0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT17_MIBCOUNTER_OVERFLOW_FLAG1 */
        /* offset address */    0x6400B0,
        /* field numbers */     9,
        /* register fields */   PORT17_MIBCOUNTER_OVERFLOW_FLAG1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT18_MIBCOUNTER_OVERFLOW_FLAG0 */
        /* offset address */    0x6400B4,
        /* field numbers */     32,
        /* register fields */   PORT18_MIBCOUNTER_OVERFLOW_FLAG0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT18_MIBCOUNTER_OVERFLOW_FLAG1 */
        /* offset address */    0x6400B8,
        /* field numbers */     9,
        /* register fields */   PORT18_MIBCOUNTER_OVERFLOW_FLAG1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT19_MIBCOUNTER_OVERFLOW_FLAG0 */
        /* offset address */    0x6400BC,
        /* field numbers */     32,
        /* register fields */   PORT19_MIBCOUNTER_OVERFLOW_FLAG0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT19_MIBCOUNTER_OVERFLOW_FLAG1 */
        /* offset address */    0x6400C0,
        /* field numbers */     9,
        /* register fields */   PORT19_MIBCOUNTER_OVERFLOW_FLAG1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT20_MIBCOUNTER_OVERFLOW_FLAG0 */
        /* offset address */    0x6400C4,
        /* field numbers */     32,
        /* register fields */   PORT20_MIBCOUNTER_OVERFLOW_FLAG0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT20_MIBCOUNTER_OVERFLOW_FLAG1 */
        /* offset address */    0x6400C8,
        /* field numbers */     9,
        /* register fields */   PORT20_MIBCOUNTER_OVERFLOW_FLAG1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT21_MIBCOUNTER_OVERFLOW_FLAG0 */
        /* offset address */    0x6400CC,
        /* field numbers */     32,
        /* register fields */   PORT21_MIBCOUNTER_OVERFLOW_FLAG0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT21_MIBCOUNTER_OVERFLOW_FLAG1 */
        /* offset address */    0x6400D0,
        /* field numbers */     9,
        /* register fields */   PORT21_MIBCOUNTER_OVERFLOW_FLAG1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT22_MIBCOUNTER_OVERFLOW_FLAG0 */
        /* offset address */    0x6400D4,
        /* field numbers */     32,
        /* register fields */   PORT22_MIBCOUNTER_OVERFLOW_FLAG0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT22_MIBCOUNTER_OVERFLOW_FLAG1 */
        /* offset address */    0x6400D8,
        /* field numbers */     9,
        /* register fields */   PORT22_MIBCOUNTER_OVERFLOW_FLAG1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT23_MIBCOUNTER_OVERFLOW_FLAG0 */
        /* offset address */    0x6400DC,
        /* field numbers */     32,
        /* register fields */   PORT23_MIBCOUNTER_OVERFLOW_FLAG0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT23_MIBCOUNTER_OVERFLOW_FLAG1 */
        /* offset address */    0x6400E0,
        /* field numbers */     9,
        /* register fields */   PORT23_MIBCOUNTER_OVERFLOW_FLAG1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT24_MIBCOUNTER_OVERFLOW_FLAG0 */
        /* offset address */    0x6400E4,
        /* field numbers */     32,
        /* register fields */   PORT24_MIBCOUNTER_OVERFLOW_FLAG0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT24_MIBCOUNTER_OVERFLOW_FLAG1 */
        /* offset address */    0x6400E8,
        /* field numbers */     9,
        /* register fields */   PORT24_MIBCOUNTER_OVERFLOW_FLAG1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        TEST_MODE_TRIGGER */
        /* offset address */    0x6400EC,
        /* field numbers */     4,
        /* register fields */   TEST_MODE_TRIGGER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        TEST_MODE_WRITE_DATA0 */
        /* offset address */    0x6400F0,
        /* field numbers */     1,
        /* register fields */   TEST_MODE_WRITE_DATA0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        TEST_MODE_WRITE_DATA1 */
        /* offset address */    0x6400F4,
        /* field numbers */     1,
        /* register fields */   TEST_MODE_WRITE_DATA1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        TEST_MODE_READ_DATA0 */
        /* offset address */    0x6400F8,
        /* field numbers */     1,
        /* register fields */   TEST_MODE_READ_DATA0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        TEST_MODE_READ_DATA1 */
        /* offset address */    0x6400FC,
        /* field numbers */     1,
        /* register fields */   TEST_MODE_READ_DATA1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        INDIRECT_ACCESS_MIB_COUNTER_CONTROLFor_RRCP */
        /* offset address */    0x640100,
        /* field numbers */     3,
        /* register fields */   INDIRECT_ACCESS_MIB_COUNTER_CONTROLFOR_RRCP_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        INDIRECT_ACCESS_MIB_COUNTER_DATA0_For_RRCP */
        /* offset address */    0x640104,
        /* field numbers */     1,
        /* register fields */   INDIRECT_ACCESS_MIB_COUNTER_DATA0_FOR_RRCP_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        INDIRECT_ACCESS_MIB_COUNTER_DATA1_For_RRCP */
        /* offset address */    0x640108,
        /* field numbers */     1,
        /* register fields */   INDIRECT_ACCESS_MIB_COUNTER_DATA1_FOR_RRCP_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Global_GPIO_Control0 */
        /* offset address */    0x650000,
        /* field numbers */     8,
        /* register fields */   GLOBAL_GPIO_CONTROL0_FIELDS,
        /* default value */     0x80000000
    },
    {   /* register name        Global_GPIO_Control1 */
        /* offset address */    0x650004,
        /* field numbers */     8,
        /* register fields */   GLOBAL_GPIO_CONTROL1_FIELDS,
        /* default value */     0x3473F
    },
    {   /* register name        Global_GPIO_Interrupt_Control */
        /* offset address */    0x650008,
        /* field numbers */     9,
        /* register fields */   GLOBAL_GPIO_INTERRUPT_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Global_GPIO_Interrupt_Status */
        /* offset address */    0x65000C,
        /* field numbers */     8,
        /* register fields */   GLOBAL_GPIO_INTERRUPT_STATUS_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        SWITCH_INTERRUPT_GLOBAL_CONTROL */
        /* offset address */    0x660000,
        /* field numbers */     16,
        /* register fields */   SWITCH_INTERRUPT_GLOBAL_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PER_PORT_LINK_CHANGE_INTERRUPT_CONTROL */
        /* offset address */    0x660004,
        /* field numbers */     2,
        /* register fields */   PER_PORT_LINK_CHANGE_INTERRUPT_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PACKET_DROP_INTERRUPT_CONTROL0 */
        /* offset address */    0x660008,
        /* field numbers */     32,
        /* register fields */   PACKET_DROP_INTERRUPT_CONTROL0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PACKET_DROP_INTERRUPT_CONTROL1 */
        /* offset address */    0x66000C,
        /* field numbers */     15,
        /* register fields */   PACKET_DROP_INTERRUPT_CONTROL1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PER_PORT_SA_LEARNING_CONSTRAIN_INTERRUPT_CONTROL */
        /* offset address */    0x660010,
        /* field numbers */     2,
        /* register fields */   PER_PORT_SA_LEARNING_CONSTRAIN_INTERRUPT_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        SERDES_INTERRUPT_CONTROL */
        /* offset address */    0x660014,
        /* field numbers */     18,
        /* register fields */   SERDES_INTERRUPT_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        MISC_INTERRUPT_CONTROL */
        /* offset address */    0x660018,
        /* field numbers */     3,
        /* register fields */   MISC_INTERRUPT_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        SWITCH_INTERRUPT_GLOBAL_SOURCE_STATUS */
        /* offset address */    0x66001C,
        /* field numbers */     16,
        /* register fields */   SWITCH_INTERRUPT_GLOBAL_SOURCE_STATUS_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PER_PORT_LINK_CHANGE_INTERRUPT_STATUS */
        /* offset address */    0x660020,
        /* field numbers */     2,
        /* register fields */   PER_PORT_LINK_CHANGE_INTERRUPT_STATUS_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PACKET_DROP_INTERRUPT_STATUS0 */
        /* offset address */    0x660024,
        /* field numbers */     32,
        /* register fields */   PACKET_DROP_INTERRUPT_STATUS0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PACKET_DROP_INTERRUPT_STATUS1 */
        /* offset address */    0x660028,
        /* field numbers */     15,
        /* register fields */   PACKET_DROP_INTERRUPT_STATUS1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PER_PORT_SA_LEARNING_CONSTRAIN_INTERRUPT_STATUS */
        /* offset address */    0x66002C,
        /* field numbers */     2,
        /* register fields */   PER_PORT_SA_LEARNING_CONSTRAIN_INTERRUPT_STATUS_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        SERDES_INTERRUPT_STATUS */
        /* offset address */    0x660030,
        /* field numbers */     18,
        /* register fields */   SERDES_INTERRUPT_STATUS_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        MISC_INTERRUPT_STATUS */
        /* offset address */    0x660034,
        /* field numbers */     3,
        /* register fields */   MISC_INTERRUPT_STATUS_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        SWITCH_INTERRUPT_MODE */
        /* offset address */    0x660038,
        /* field numbers */     8,
        /* register fields */   SWITCH_INTERRUPT_MODE_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        LED_CONTROL */
        /* offset address */    0x670000,
        /* field numbers */     15,
        /* register fields */   LED_CONTROL_FIELDS,
        /* default value */     0x38064
    },
    {   /* register name        SOFTWARE_LED_CONTROL0 */
        /* offset address */    0x670004,
        /* field numbers */     2,
        /* register fields */   SOFTWARE_LED_CONTROL0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        SOFTWARE_LED_CONTROL1 */
        /* offset address */    0x670008,
        /* field numbers */     2,
        /* register fields */   SOFTWARE_LED_CONTROL1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        SOFTWARE_LED_CONTROL2 */
        /* offset address */    0x67000C,
        /* field numbers */     5,
        /* register fields */   SOFTWARE_LED_CONTROL2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        LED_IC_Access_Control */
        /* offset address */    0x670010,
        /* field numbers */     5,
        /* register fields */   LED_IC_ACCESS_CONTROL_FIELDS,
        /* default value */     0x40000000
    },
    {   /* register name        LED_IC_Access_Data */
        /* offset address */    0x670014,
        /* field numbers */     2,
        /* register fields */   LED_IC_ACCESS_DATA_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        GPIO_Control */
        /* offset address */    0x670018,
        /* field numbers */     8,
        /* register fields */   GPIO_CONTROL_FIELDS,
        /* default value */     0x8000
    },
    {   /* register name        I2C_like_LED_Mode0 */
        /* offset address */    0x67001C,
        /* field numbers */     15,
        /* register fields */   I2C_LIKE_LED_MODE0_FIELDS,
        /* default value */     0x403E
    },
    {   /* register name        I2C_like_LED_Mode1 */
        /* offset address */    0x670020,
        /* field numbers */     1,
        /* register fields */   I2C_LIKE_LED_MODE1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        I2C_like_LED_Mode2 */
        /* offset address */    0x670024,
        /* field numbers */     8,
        /* register fields */   I2C_LIKE_LED_MODE2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        LED_Control0 */
        /* offset address */    0x670028,
        /* field numbers */     12,
        /* register fields */   LED_CONTROL0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        LED_Control1 */
        /* offset address */    0x67002C,
        /* field numbers */     12,
        /* register fields */   LED_CONTROL1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        LED_Control2 */
        /* offset address */    0x670030,
        /* field numbers */     7,
        /* register fields */   LED_CONTROL2_FIELDS,
        /* default value */     0x8000
    },
    {   /* register name        LED_Control3 */
        /* offset address */    0x670034,
        /* field numbers */     12,
        /* register fields */   LED_CONTROL3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        LED_Control4 */
        /* offset address */    0x670038,
        /* field numbers */     12,
        /* register fields */   LED_CONTROL4_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        LED_Control5 */
        /* offset address */    0x67003C,
        /* field numbers */     5,
        /* register fields */   LED_CONTROL5_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        LED_Control6 */
        /* offset address */    0x670040,
        /* field numbers */     12,
        /* register fields */   LED_CONTROL6_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        LED_Control7 */
        /* offset address */    0x670044,
        /* field numbers */     12,
        /* register fields */   LED_CONTROL7_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        LED_Control8 */
        /* offset address */    0x670048,
        /* field numbers */     9,
        /* register fields */   LED_CONTROL8_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        LED_Status_Control */
        /* offset address */    0x67004C,
        /* field numbers */     8,
        /* register fields */   LED_STATUS_CONTROL_FIELDS,
        /* default value */     0x6DA0980
    },
    {   /* register name        Horse_Race_Lamp_LED_Control */
        /* offset address */    0x670050,
        /* field numbers */     5,
        /* register fields */   HORSE_RACE_LAMP_LED_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        NIC_Global_Control */
        /* offset address */    0x680000,
        /* field numbers */     2,
        /* register fields */   NIC_GLOBAL_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        TXSTOP_Address */
        /* offset address */    0x680004,
        /* field numbers */     2,
        /* register fields */   TXSTOP_ADDRESS_FIELDS,
        /* default value */     0x7FF
    },
    {   /* register name        RXSTOP_Address */
        /* offset address */    0x680008,
        /* field numbers */     2,
        /* register fields */   RXSTOP_ADDRESS_FIELDS,
        /* default value */     0x3FF
    },
    {   /* register name        Rx_Buffer_Received_Data_Length */
        /* offset address */    0x68000C,
        /* field numbers */     2,
        /* register fields */   RX_BUFFER_RECEIVED_DATA_LENGTH_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Tx_Buffer_Available_Free_Space */
        /* offset address */    0x680010,
        /* field numbers */     2,
        /* register fields */   TX_BUFFER_AVAILABLE_FREE_SPACE_FIELDS,
        /* default value */     0x400
    },
    {   /* register name        Rx_Command */
        /* offset address */    0x680014,
        /* field numbers */     2,
        /* register fields */   RX_COMMAND_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Tx_Command */
        /* offset address */    0x680018,
        /* field numbers */     2,
        /* register fields */   TX_COMMAND_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        NIC_Interrupt_Status */
        /* offset address */    0x68001C,
        /* field numbers */     5,
        /* register fields */   NIC_INTERRUPT_STATUS_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        NIC_Interrupt_Mask */
        /* offset address */    0x680020,
        /* field numbers */     5,
        /* register fields */   NIC_INTERRUPT_MASK_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Rx_Control */
        /* offset address */    0x680024,
        /* field numbers */     15,
        /* register fields */   RX_CONTROL_FIELDS,
        /* default value */     0x205E
    },
    {   /* register name        Tx_Control */
        /* offset address */    0x680028,
        /* field numbers */     4,
        /* register fields */   TX_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        CPU_Rx_Current_Packet */
        /* offset address */    0x68002C,
        /* field numbers */     2,
        /* register fields */   CPU_RX_CURRENT_PACKET_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        CPU_Tx_Current_Packet */
        /* offset address */    0x680030,
        /* field numbers */     2,
        /* register fields */   CPU_TX_CURRENT_PACKET_FIELDS,
        /* default value */     0x400
    },
    {   /* register name        Multicast_Hash0 */
        /* offset address */    0x680034,
        /* field numbers */     2,
        /* register fields */   MULTICAST_HASH0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Multicast_Hash1 */
        /* offset address */    0x680038,
        /* field numbers */     2,
        /* register fields */   MULTICAST_HASH1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Multicast_Hash2 */
        /* offset address */    0x68003C,
        /* field numbers */     2,
        /* register fields */   MULTICAST_HASH2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Multicast_Hash3 */
        /* offset address */    0x680040,
        /* field numbers */     2,
        /* register fields */   MULTICAST_HASH3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Multicast_Hash4 */
        /* offset address */    0x680044,
        /* field numbers */     2,
        /* register fields */   MULTICAST_HASH4_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Multicast_Hash5 */
        /* offset address */    0x680048,
        /* field numbers */     2,
        /* register fields */   MULTICAST_HASH5_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Multicast_Hash6 */
        /* offset address */    0x68004C,
        /* field numbers */     2,
        /* register fields */   MULTICAST_HASH6_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Multicast_Hash7 */
        /* offset address */    0x680050,
        /* field numbers */     2,
        /* register fields */   MULTICAST_HASH7_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Physical_Address_Hash0 */
        /* offset address */    0x680054,
        /* field numbers */     2,
        /* register fields */   PHYSICAL_ADDRESS_HASH0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Physical_Address_Hash1 */
        /* offset address */    0x680058,
        /* field numbers */     2,
        /* register fields */   PHYSICAL_ADDRESS_HASH1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Physical_Address_Hash2 */
        /* offset address */    0x68005C,
        /* field numbers */     2,
        /* register fields */   PHYSICAL_ADDRESS_HASH2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Physical_Address_Hash3 */
        /* offset address */    0x680060,
        /* field numbers */     2,
        /* register fields */   PHYSICAL_ADDRESS_HASH3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Physical_Address_Hash4 */
        /* offset address */    0x680064,
        /* field numbers */     2,
        /* register fields */   PHYSICAL_ADDRESS_HASH4_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Physical_Address_Hash5 */
        /* offset address */    0x680068,
        /* field numbers */     2,
        /* register fields */   PHYSICAL_ADDRESS_HASH5_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Physical_Address_Hash6 */
        /* offset address */    0x68006C,
        /* field numbers */     2,
        /* register fields */   PHYSICAL_ADDRESS_HASH6_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Physical_Address_Hash7 */
        /* offset address */    0x680070,
        /* field numbers */     2,
        /* register fields */   PHYSICAL_ADDRESS_HASH7_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        SRxCurPktR */
        /* offset address */    0x680074,
        /* field numbers */     2,
        /* register fields */   SRXCURPKTR_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        STxCurPktR */
        /* offset address */    0x680078,
        /* field numbers */     2,
        /* register fields */   STXCURPKTR_FIELDS,
        /* default value */     0x400
    },
    {   /* register name        TxPktLenR */
        /* offset address */    0x68007C,
        /* field numbers */     2,
        /* register fields */   TXPKTLENR_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        STxCurUnitR */
        /* offset address */    0x680080,
        /* field numbers */     2,
        /* register fields */   STXCURUNITR_FIELDS,
        /* default value */     0x400
    },
    {   /* register name        ALE_TEST_MODE_CONTROL */
        /* offset address */    0x6A0000,
        /* field numbers */     3,
        /* register fields */   ALE_TEST_MODE_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        HEADER_STAMP_BEFORE_CR0 */
        /* offset address */    0x6A0004,
        /* field numbers */     1,
        /* register fields */   HEADER_STAMP_BEFORE_CR0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        HEADER_STAMP_BEFORE_CR1 */
        /* offset address */    0x6A0008,
        /* field numbers */     1,
        /* register fields */   HEADER_STAMP_BEFORE_CR1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        HEADER_STAMP_BEFORE_CR2 */
        /* offset address */    0x6A000C,
        /* field numbers */     1,
        /* register fields */   HEADER_STAMP_BEFORE_CR2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        HEADER_STAMP_BEFORE_CR3 */
        /* offset address */    0x6A0010,
        /* field numbers */     1,
        /* register fields */   HEADER_STAMP_BEFORE_CR3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        HEADER_STAMP_BEFORE_CR4 */
        /* offset address */    0x6A0014,
        /* field numbers */     1,
        /* register fields */   HEADER_STAMP_BEFORE_CR4_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        HEADER_STAMP_BEFORE_CR5 */
        /* offset address */    0x6A0018,
        /* field numbers */     4,
        /* register fields */   HEADER_STAMP_BEFORE_CR5_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        HEADER_STAMP_BEFORE_CR6 */
        /* offset address */    0x6A001C,
        /* field numbers */     21,
        /* register fields */   HEADER_STAMP_BEFORE_CR6_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        HEADER_STAMP_BEFORE_CR7 */
        /* offset address */    0x6A0020,
        /* field numbers */     6,
        /* register fields */   HEADER_STAMP_BEFORE_CR7_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        HEADER_STAMP_BEFORE_CR8 */
        /* offset address */    0x6A0024,
        /* field numbers */     3,
        /* register fields */   HEADER_STAMP_BEFORE_CR8_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        HEADER_STAMP_BEFORE_CR9 */
        /* offset address */    0x6A0028,
        /* field numbers */     1,
        /* register fields */   HEADER_STAMP_BEFORE_CR9_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        HEADER_STAMP_BEFORE_CR10 */
        /* offset address */    0x6A002C,
        /* field numbers */     2,
        /* register fields */   HEADER_STAMP_BEFORE_CR10_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        HEADER_STAMP_BEFORE_CR11 */
        /* offset address */    0x6A0030,
        /* field numbers */     1,
        /* register fields */   HEADER_STAMP_BEFORE_CR11_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PACKET_MODIFICATION_INFORMATION_CR0 */
        /* offset address */    0x6A0034,
        /* field numbers */     6,
        /* register fields */   PACKET_MODIFICATION_INFORMATION_CR0_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PACKET_MODIFICATION_INFORMATION_CR1 */
        /* offset address */    0x6A0038,
        /* field numbers */     11,
        /* register fields */   PACKET_MODIFICATION_INFORMATION_CR1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PACKET_MODIFICATION_INFORMATION_CR2 */
        /* offset address */    0x6A003C,
        /* field numbers */     8,
        /* register fields */   PACKET_MODIFICATION_INFORMATION_CR2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PACKET_MODIFICATION_INFORMATION_CR3 */
        /* offset address */    0x6A0040,
        /* field numbers */     5,
        /* register fields */   PACKET_MODIFICATION_INFORMATION_CR3_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PACKET_MODIFICATION_INFORMATION_CR4 */
        /* offset address */    0x6A0044,
        /* field numbers */     2,
        /* register fields */   PACKET_MODIFICATION_INFORMATION_CR4_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PACKET_PROCESS_INFORMATION0_CR0 */
        /* offset address */    0x6A0048,
        /* field numbers */     4,
        /* register fields */   PACKET_PROCESS_INFORMATION0_CR0_FIELDS,
        /* default value */     0x40
    },
    {   /* register name        PACKET_PROCESS_INFORMATION0_CR1 */
        /* offset address */    0x6A004C,
        /* field numbers */     6,
        /* register fields */   PACKET_PROCESS_INFORMATION0_CR1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PACKET_PROCESS_INFORMATION0_CR2 */
        /* offset address */    0x6A0050,
        /* field numbers */     6,
        /* register fields */   PACKET_PROCESS_INFORMATION0_CR2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PACKET_PROCESS_INFORMATION0_CR3 */
        /* offset address */    0x6A0054,
        /* field numbers */     5,
        /* register fields */   PACKET_PROCESS_INFORMATION0_CR3_FIELDS,
        /* default value */     0x80000000
    },
    {   /* register name        PACKET_PROCESS_INFORMATION0_CR4 */
        /* offset address */    0x6A0058,
        /* field numbers */     8,
        /* register fields */   PACKET_PROCESS_INFORMATION0_CR4_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PACKET_PROCESS_INFORMATION0_CR5 */
        /* offset address */    0x6A005C,
        /* field numbers */     14,
        /* register fields */   PACKET_PROCESS_INFORMATION0_CR5_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PACKET_PROCESS_INFORMATION0_CR6 */
        /* offset address */    0x6A0060,
        /* field numbers */     5,
        /* register fields */   PACKET_PROCESS_INFORMATION0_CR6_FIELDS,
        /* default value */     0xFFFFFF
    },
    {   /* register name        PACKET_PROCESS_INFORMATION0_CR7 */
        /* offset address */    0x6A0064,
        /* field numbers */     12,
        /* register fields */   PACKET_PROCESS_INFORMATION0_CR7_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PACKET_PROCESS_INFORMATION1_CR0 */
        /* offset address */    0x6A0068,
        /* field numbers */     4,
        /* register fields */   PACKET_PROCESS_INFORMATION1_CR0_FIELDS,
        /* default value */     0x40
    },
    {   /* register name        PACKET_PROCESS_INFORMATION1_CR1 */
        /* offset address */    0x6A006C,
        /* field numbers */     6,
        /* register fields */   PACKET_PROCESS_INFORMATION1_CR1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PACKET_PROCESS_INFORMATION1_CR2 */
        /* offset address */    0x6A0070,
        /* field numbers */     6,
        /* register fields */   PACKET_PROCESS_INFORMATION1_CR2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PACKET_PROCESS_INFORMATION1_CR3 */
        /* offset address */    0x6A0074,
        /* field numbers */     5,
        /* register fields */   PACKET_PROCESS_INFORMATION1_CR3_FIELDS,
        /* default value */     0x80000000
    },
    {   /* register name        PACKET_PROCESS_INFORMATION1_CR4 */
        /* offset address */    0x6A0078,
        /* field numbers */     8,
        /* register fields */   PACKET_PROCESS_INFORMATION1_CR4_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PACKET_PROCESS_INFORMATION1_CR5 */
        /* offset address */    0x6A007C,
        /* field numbers */     14,
        /* register fields */   PACKET_PROCESS_INFORMATION1_CR5_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PACKET_PROCESS_INFORMATION1_CR6 */
        /* offset address */    0x6A0080,
        /* field numbers */     5,
        /* register fields */   PACKET_PROCESS_INFORMATION1_CR6_FIELDS,
        /* default value */     0xFFFFFF
    },
    {   /* register name        PACKET_PROCESS_INFORMATION1_CR7 */
        /* offset address */    0x6A0084,
        /* field numbers */     12,
        /* register fields */   PACKET_PROCESS_INFORMATION1_CR7_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PACKET_PROCESS_INFORMATION2_CR0 */
        /* offset address */    0x6A0088,
        /* field numbers */     4,
        /* register fields */   PACKET_PROCESS_INFORMATION2_CR0_FIELDS,
        /* default value */     0x40
    },
    {   /* register name        PACKET_PROCESS_INFORMATION2_CR1 */
        /* offset address */    0x6A008C,
        /* field numbers */     6,
        /* register fields */   PACKET_PROCESS_INFORMATION2_CR1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PACKET_PROCESS_INFORMATION2_CR2 */
        /* offset address */    0x6A0090,
        /* field numbers */     6,
        /* register fields */   PACKET_PROCESS_INFORMATION2_CR2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PACKET_PROCESS_INFORMATION2_CR3 */
        /* offset address */    0x6A0094,
        /* field numbers */     5,
        /* register fields */   PACKET_PROCESS_INFORMATION2_CR3_FIELDS,
        /* default value */     0x80000000
    },
    {   /* register name        PACKET_PROCESS_INFORMATION2_CR4 */
        /* offset address */    0x6A0098,
        /* field numbers */     8,
        /* register fields */   PACKET_PROCESS_INFORMATION2_CR4_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PACKET_PROCESS_INFORMATION2_CR5 */
        /* offset address */    0x6A009C,
        /* field numbers */     14,
        /* register fields */   PACKET_PROCESS_INFORMATION2_CR5_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PACKET_PROCESS_INFORMATION2_CR6 */
        /* offset address */    0x6A00A0,
        /* field numbers */     5,
        /* register fields */   PACKET_PROCESS_INFORMATION2_CR6_FIELDS,
        /* default value */     0xFFFFFF
    },
    {   /* register name        PACKET_PROCESS_INFORMATION2_CR7 */
        /* offset address */    0x6A00A4,
        /* field numbers */     12,
        /* register fields */   PACKET_PROCESS_INFORMATION2_CR7_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PACKET_PROCESS_INFORMATION3_CR0 */
        /* offset address */    0x6A00A8,
        /* field numbers */     4,
        /* register fields */   PACKET_PROCESS_INFORMATION3_CR0_FIELDS,
        /* default value */     0x40
    },
    {   /* register name        PACKET_PROCESS_INFORMATION3_CR1 */
        /* offset address */    0x6A00AC,
        /* field numbers */     6,
        /* register fields */   PACKET_PROCESS_INFORMATION3_CR1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PACKET_PROCESS_INFORMATION3_CR2 */
        /* offset address */    0x6A00B0,
        /* field numbers */     6,
        /* register fields */   PACKET_PROCESS_INFORMATION3_CR2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PACKET_PROCESS_INFORMATION3_CR3 */
        /* offset address */    0x6A00B4,
        /* field numbers */     5,
        /* register fields */   PACKET_PROCESS_INFORMATION3_CR3_FIELDS,
        /* default value */     0x80000000
    },
    {   /* register name        PACKET_PROCESS_INFORMATION3_CR4 */
        /* offset address */    0x6A00B8,
        /* field numbers */     8,
        /* register fields */   PACKET_PROCESS_INFORMATION3_CR4_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PACKET_PROCESS_INFORMATION3_CR5 */
        /* offset address */    0x6A00BC,
        /* field numbers */     14,
        /* register fields */   PACKET_PROCESS_INFORMATION3_CR5_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PACKET_PROCESS_INFORMATION3_CR6 */
        /* offset address */    0x6A00C0,
        /* field numbers */     5,
        /* register fields */   PACKET_PROCESS_INFORMATION3_CR6_FIELDS,
        /* default value */     0xFFFFFF
    },
    {   /* register name        PACKET_PROCESS_INFORMATION3_CR7 */
        /* offset address */    0x6A00C4,
        /* field numbers */     12,
        /* register fields */   PACKET_PROCESS_INFORMATION3_CR7_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PACKET_PROCESS_INFORMATION4_CR0 */
        /* offset address */    0x6A00C8,
        /* field numbers */     4,
        /* register fields */   PACKET_PROCESS_INFORMATION4_CR0_FIELDS,
        /* default value */     0x40
    },
    {   /* register name        PACKET_PROCESS_INFORMATION4_CR1 */
        /* offset address */    0x6A00CC,
        /* field numbers */     6,
        /* register fields */   PACKET_PROCESS_INFORMATION4_CR1_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PACKET_PROCESS_INFORMATION4_CR2 */
        /* offset address */    0x6A00D0,
        /* field numbers */     6,
        /* register fields */   PACKET_PROCESS_INFORMATION4_CR2_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PACKET_PROCESS_INFORMATION4_CR3 */
        /* offset address */    0x6A00D4,
        /* field numbers */     5,
        /* register fields */   PACKET_PROCESS_INFORMATION4_CR3_FIELDS,
        /* default value */     0x80000000
    },
    {   /* register name        PACKET_PROCESS_INFORMATION4_CR4 */
        /* offset address */    0x6A00D8,
        /* field numbers */     8,
        /* register fields */   PACKET_PROCESS_INFORMATION4_CR4_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PACKET_PROCESS_INFORMATION4_CR5 */
        /* offset address */    0x6A00DC,
        /* field numbers */     14,
        /* register fields */   PACKET_PROCESS_INFORMATION4_CR5_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PACKET_PROCESS_INFORMATION4_CR6 */
        /* offset address */    0x6A00E0,
        /* field numbers */     5,
        /* register fields */   PACKET_PROCESS_INFORMATION4_CR6_FIELDS,
        /* default value */     0xFFFFFF
    },
    {   /* register name        PACKET_PROCESS_INFORMATION4_CR7 */
        /* offset address */    0x6A00E4,
        /* field numbers */     12,
        /* register fields */   PACKET_PROCESS_INFORMATION4_CR7_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        FlowCtl_Global_PageCnt_Beyond_Threshold_Times */
        /* offset address */    0x6C0000,
        /* field numbers */     2,
        /* register fields */   FLOWCTL_GLOBAL_PAGECNT_BEYOND_THRESHOLD_TIMES_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Global_Occupied_RX_Page_Peak_Counter */
        /* offset address */    0x6C0004,
        /* field numbers */     2,
        /* register fields */   GLOBAL_OCCUPIED_RX_PAGE_PEAK_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        System_page_counter */
        /* offset address */    0x6C0008,
        /* field numbers */     2,
        /* register fields */   SYSTEM_PAGE_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        Debug_Counter_reset */
        /* offset address */    0x6C000C,
        /* field numbers */     3,
        /* register fields */   DEBUG_COUNTER_RESET_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT0_RX_Occupied_Page_Counter_Beyond_Threshold_Times */
        /* offset address */    0xEC0000,
        /* field numbers */     2,
        /* register fields */   PORT_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT1_RX_Occupied_Page_Counter_Beyond_Threshold_Times */
        /* offset address */    0xEC0100,
        /* field numbers */     2,
        /* register fields */   PORT_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT2_RX_Occupied_Page_Counter_Beyond_Threshold_Times */
        /* offset address */    0xEC0200,
        /* field numbers */     2,
        /* register fields */   PORT_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT3_RX_Occupied_Page_Counter_Beyond_Threshold_Times */
        /* offset address */    0xEC0300,
        /* field numbers */     2,
        /* register fields */   PORT_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT4_RX_Occupied_Page_Counter_Beyond_Threshold_Times */
        /* offset address */    0xEC0400,
        /* field numbers */     2,
        /* register fields */   PORT_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT5_RX_Occupied_Page_Counter_Beyond_Threshold_Times */
        /* offset address */    0xEC0500,
        /* field numbers */     2,
        /* register fields */   PORT_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT6_RX_Occupied_Page_Counter_Beyond_Threshold_Times */
        /* offset address */    0xEC0600,
        /* field numbers */     2,
        /* register fields */   PORT_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT7_RX_Occupied_Page_Counter_Beyond_Threshold_Times */
        /* offset address */    0xEC0700,
        /* field numbers */     2,
        /* register fields */   PORT_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT8_RX_Occupied_Page_Counter_Beyond_Threshold_Times */
        /* offset address */    0xEC0800,
        /* field numbers */     2,
        /* register fields */   PORT_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT9_RX_Occupied_Page_Counter_Beyond_Threshold_Times */
        /* offset address */    0xEC0900,
        /* field numbers */     2,
        /* register fields */   PORT_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT10_RX_Occupied_Page_Counter_Beyond_Threshold_Times */
        /* offset address */    0xEC0A00,
        /* field numbers */     2,
        /* register fields */   PORT_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT11_RX_Occupied_Page_Counter_Beyond_Threshold_Times */
        /* offset address */    0xEC0B00,
        /* field numbers */     2,
        /* register fields */   PORT_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT12_RX_Occupied_Page_Counter_Beyond_Threshold_Times */
        /* offset address */    0xEC0C00,
        /* field numbers */     2,
        /* register fields */   PORT_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT13_RX_Occupied_Page_Counter_Beyond_Threshold_Times */
        /* offset address */    0xEC0D00,
        /* field numbers */     2,
        /* register fields */   PORT_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT14_RX_Occupied_Page_Counter_Beyond_Threshold_Times */
        /* offset address */    0xEC0E00,
        /* field numbers */     2,
        /* register fields */   PORT_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT15_RX_Occupied_Page_Counter_Beyond_Threshold_Times */
        /* offset address */    0xEC0F00,
        /* field numbers */     2,
        /* register fields */   PORT_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT16_RX_Occupied_Page_Counter_Beyond_Threshold_Times */
        /* offset address */    0xEC1000,
        /* field numbers */     2,
        /* register fields */   PORT_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT17_RX_Occupied_Page_Counter_Beyond_Threshold_Times */
        /* offset address */    0xEC1100,
        /* field numbers */     2,
        /* register fields */   PORT_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT18_RX_Occupied_Page_Counter_Beyond_Threshold_Times */
        /* offset address */    0xEC1200,
        /* field numbers */     2,
        /* register fields */   PORT_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT19_RX_Occupied_Page_Counter_Beyond_Threshold_Times */
        /* offset address */    0xEC1300,
        /* field numbers */     2,
        /* register fields */   PORT_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT20_RX_Occupied_Page_Counter_Beyond_Threshold_Times */
        /* offset address */    0xEC1400,
        /* field numbers */     2,
        /* register fields */   PORT_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT21_RX_Occupied_Page_Counter_Beyond_Threshold_Times */
        /* offset address */    0xEC1500,
        /* field numbers */     2,
        /* register fields */   PORT_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT22_RX_Occupied_Page_Counter_Beyond_Threshold_Times */
        /* offset address */    0xEC1600,
        /* field numbers */     2,
        /* register fields */   PORT_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT23_RX_Occupied_Page_Counter_Beyond_Threshold_Times */
        /* offset address */    0xEC1700,
        /* field numbers */     2,
        /* register fields */   PORT_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT24_RX_Occupied_Page_Counter_Beyond_Threshold_Times */
        /* offset address */    0xEC1800,
        /* field numbers */     2,
        /* register fields */   PORT_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT0_Current_Counter_When_Global_Reach_Peak_Value */
        /* offset address */    0xEC0004,
        /* field numbers */     2,
        /* register fields */   PORT_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT1_Current_Counter_When_Global_Reach_Peak_Value */
        /* offset address */    0xEC0104,
        /* field numbers */     2,
        /* register fields */   PORT_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT2_Current_Counter_When_Global_Reach_Peak_Value */
        /* offset address */    0xEC0204,
        /* field numbers */     2,
        /* register fields */   PORT_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT3_Current_Counter_When_Global_Reach_Peak_Value */
        /* offset address */    0xEC0304,
        /* field numbers */     2,
        /* register fields */   PORT_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT4_Current_Counter_When_Global_Reach_Peak_Value */
        /* offset address */    0xEC0404,
        /* field numbers */     2,
        /* register fields */   PORT_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT5_Current_Counter_When_Global_Reach_Peak_Value */
        /* offset address */    0xEC0504,
        /* field numbers */     2,
        /* register fields */   PORT_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT6_Current_Counter_When_Global_Reach_Peak_Value */
        /* offset address */    0xEC0604,
        /* field numbers */     2,
        /* register fields */   PORT_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT7_Current_Counter_When_Global_Reach_Peak_Value */
        /* offset address */    0xEC0704,
        /* field numbers */     2,
        /* register fields */   PORT_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT8_Current_Counter_When_Global_Reach_Peak_Value */
        /* offset address */    0xEC0804,
        /* field numbers */     2,
        /* register fields */   PORT_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT9_Current_Counter_When_Global_Reach_Peak_Value */
        /* offset address */    0xEC0904,
        /* field numbers */     2,
        /* register fields */   PORT_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT10_Current_Counter_When_Global_Reach_Peak_Value */
        /* offset address */    0xEC0A04,
        /* field numbers */     2,
        /* register fields */   PORT_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT11_Current_Counter_When_Global_Reach_Peak_Value */
        /* offset address */    0xEC0B04,
        /* field numbers */     2,
        /* register fields */   PORT_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT12_Current_Counter_When_Global_Reach_Peak_Value */
        /* offset address */    0xEC0C04,
        /* field numbers */     2,
        /* register fields */   PORT_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT13_Current_Counter_When_Global_Reach_Peak_Value */
        /* offset address */    0xEC0D04,
        /* field numbers */     2,
        /* register fields */   PORT_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT14_Current_Counter_When_Global_Reach_Peak_Value */
        /* offset address */    0xEC0E04,
        /* field numbers */     2,
        /* register fields */   PORT_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT15_Current_Counter_When_Global_Reach_Peak_Value */
        /* offset address */    0xEC0F04,
        /* field numbers */     2,
        /* register fields */   PORT_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT16_Current_Counter_When_Global_Reach_Peak_Value */
        /* offset address */    0xEC1004,
        /* field numbers */     2,
        /* register fields */   PORT_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT17_Current_Counter_When_Global_Reach_Peak_Value */
        /* offset address */    0xEC1104,
        /* field numbers */     2,
        /* register fields */   PORT_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT18_Current_Counter_When_Global_Reach_Peak_Value */
        /* offset address */    0xEC1204,
        /* field numbers */     2,
        /* register fields */   PORT_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT19_Current_Counter_When_Global_Reach_Peak_Value */
        /* offset address */    0xEC1304,
        /* field numbers */     2,
        /* register fields */   PORT_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT20_Current_Counter_When_Global_Reach_Peak_Value */
        /* offset address */    0xEC1404,
        /* field numbers */     2,
        /* register fields */   PORT_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT21_Current_Counter_When_Global_Reach_Peak_Value */
        /* offset address */    0xEC1504,
        /* field numbers */     2,
        /* register fields */   PORT_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT22_Current_Counter_When_Global_Reach_Peak_Value */
        /* offset address */    0xEC1604,
        /* field numbers */     2,
        /* register fields */   PORT_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT23_Current_Counter_When_Global_Reach_Peak_Value */
        /* offset address */    0xEC1704,
        /* field numbers */     2,
        /* register fields */   PORT_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT24_Current_Counter_When_Global_Reach_Peak_Value */
        /* offset address */    0xEC1804,
        /* field numbers */     2,
        /* register fields */   PORT_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT0_Occupied_RX_Page_Peak_Counter */
        /* offset address */    0xEC0008,
        /* field numbers */     4,
        /* register fields */   PORT_OCCUPIED_RX_PAGE_PEAK_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT1_Occupied_RX_Page_Peak_Counter */
        /* offset address */    0xEC0108,
        /* field numbers */     4,
        /* register fields */   PORT_OCCUPIED_RX_PAGE_PEAK_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT2_Occupied_RX_Page_Peak_Counter */
        /* offset address */    0xEC0208,
        /* field numbers */     4,
        /* register fields */   PORT_OCCUPIED_RX_PAGE_PEAK_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT3_Occupied_RX_Page_Peak_Counter */
        /* offset address */    0xEC0308,
        /* field numbers */     4,
        /* register fields */   PORT_OCCUPIED_RX_PAGE_PEAK_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT4_Occupied_RX_Page_Peak_Counter */
        /* offset address */    0xEC0408,
        /* field numbers */     4,
        /* register fields */   PORT_OCCUPIED_RX_PAGE_PEAK_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT5_Occupied_RX_Page_Peak_Counter */
        /* offset address */    0xEC0508,
        /* field numbers */     4,
        /* register fields */   PORT_OCCUPIED_RX_PAGE_PEAK_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT6_Occupied_RX_Page_Peak_Counter */
        /* offset address */    0xEC0608,
        /* field numbers */     4,
        /* register fields */   PORT_OCCUPIED_RX_PAGE_PEAK_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT7_Occupied_RX_Page_Peak_Counter */
        /* offset address */    0xEC0708,
        /* field numbers */     4,
        /* register fields */   PORT_OCCUPIED_RX_PAGE_PEAK_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT8_Occupied_RX_Page_Peak_Counter */
        /* offset address */    0xEC0808,
        /* field numbers */     4,
        /* register fields */   PORT_OCCUPIED_RX_PAGE_PEAK_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT9_Occupied_RX_Page_Peak_Counter */
        /* offset address */    0xEC0908,
        /* field numbers */     4,
        /* register fields */   PORT_OCCUPIED_RX_PAGE_PEAK_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT10_Occupied_RX_Page_Peak_Counter */
        /* offset address */    0xEC0A08,
        /* field numbers */     4,
        /* register fields */   PORT_OCCUPIED_RX_PAGE_PEAK_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT11_Occupied_RX_Page_Peak_Counter */
        /* offset address */    0xEC0B08,
        /* field numbers */     4,
        /* register fields */   PORT_OCCUPIED_RX_PAGE_PEAK_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT12_Occupied_RX_Page_Peak_Counter */
        /* offset address */    0xEC0C08,
        /* field numbers */     4,
        /* register fields */   PORT_OCCUPIED_RX_PAGE_PEAK_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT13_Occupied_RX_Page_Peak_Counter */
        /* offset address */    0xEC0D08,
        /* field numbers */     4,
        /* register fields */   PORT_OCCUPIED_RX_PAGE_PEAK_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT14_Occupied_RX_Page_Peak_Counter */
        /* offset address */    0xEC0E08,
        /* field numbers */     4,
        /* register fields */   PORT_OCCUPIED_RX_PAGE_PEAK_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT15_Occupied_RX_Page_Peak_Counter */
        /* offset address */    0xEC0F08,
        /* field numbers */     4,
        /* register fields */   PORT_OCCUPIED_RX_PAGE_PEAK_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT16_Occupied_RX_Page_Peak_Counter */
        /* offset address */    0xEC1008,
        /* field numbers */     4,
        /* register fields */   PORT_OCCUPIED_RX_PAGE_PEAK_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT17_Occupied_RX_Page_Peak_Counter */
        /* offset address */    0xEC1108,
        /* field numbers */     4,
        /* register fields */   PORT_OCCUPIED_RX_PAGE_PEAK_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT18_Occupied_RX_Page_Peak_Counter */
        /* offset address */    0xEC1208,
        /* field numbers */     4,
        /* register fields */   PORT_OCCUPIED_RX_PAGE_PEAK_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT19_Occupied_RX_Page_Peak_Counter */
        /* offset address */    0xEC1308,
        /* field numbers */     4,
        /* register fields */   PORT_OCCUPIED_RX_PAGE_PEAK_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT20_Occupied_RX_Page_Peak_Counter */
        /* offset address */    0xEC1408,
        /* field numbers */     4,
        /* register fields */   PORT_OCCUPIED_RX_PAGE_PEAK_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT21_Occupied_RX_Page_Peak_Counter */
        /* offset address */    0xEC1508,
        /* field numbers */     4,
        /* register fields */   PORT_OCCUPIED_RX_PAGE_PEAK_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT22_Occupied_RX_Page_Peak_Counter */
        /* offset address */    0xEC1608,
        /* field numbers */     4,
        /* register fields */   PORT_OCCUPIED_RX_PAGE_PEAK_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT23_Occupied_RX_Page_Peak_Counter */
        /* offset address */    0xEC1708,
        /* field numbers */     4,
        /* register fields */   PORT_OCCUPIED_RX_PAGE_PEAK_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        PORT24_Occupied_RX_Page_Peak_Counter */
        /* offset address */    0xEC1808,
        /* field numbers */     4,
        /* register fields */   PORT_OCCUPIED_RX_PAGE_PEAK_COUNTER_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        MAC_MII_Test_Mode_TX_Control */
        /* offset address */    0x6E0000,
        /* field numbers */     2,
        /* register fields */   MAC_MII_TEST_MODE_TX_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        MAC_MII_Test_Mode_RX_Control */
        /* offset address */    0x6E0004,
        /* field numbers */     2,
        /* register fields */   MAC_MII_TEST_MODE_RX_CONTROL_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        MAC_TEST_MODE_GMII_RX */
        /* offset address */    0x6E0008,
        /* field numbers */     5,
        /* register fields */   MAC_TEST_MODE_GMII_RX_FIELDS,
        /* default value */     0x0
    },
    {   /* register name        MAC_TEST_MODE_GMII_TX */
        /* offset address */    0x6E000C,
        /* field numbers */     5,
        /* register fields */   MAC_TEST_MODE_GMII_TX_FIELDS,
        /* default value */     0x0
    },
};
