/*
 * Copyright(c) Realtek Semiconductor Corporation, 2008
 * All rights reserved.
 *
 * $Revision$
 * $Date$
 *
 * Purpose : Definition function prototype of RTK API.
 *
 * Feature : Function prototype definition
 *
 */

#ifndef __RTK_API_H__
#define __RTK_API_H__

/*
 * Include Files
 */
#include <rtk_types.h>
#include <rtk_error.h>

#include <port.h>
#include <qos.h>
#include <acl.h>
#include <storm.h>
#include <cpu.h>
#include <dot1x.h>
#include <eee.h>
#include <igmp.h>
#include <interrupt.h>
#include <l2.h>
#include <leaky.h>
#include <led.h>
#include <mirror.h>
#include <oam.h>
#include <ptp.h>
#include <rate.h>
#include <rldp.h>
#include <stat.h>
#include <trap.h>
#include <trunk.h>
#include <vlan.h>
#include <oam.h>
/*
 * Data Type Declaration
 */
#define ENABLE                                      1
#define DISABLE                                     0

#define PHY_CONTROL_REG                             0
#define PHY_STATUS_REG                              1
#define PHY_AN_ADVERTISEMENT_REG                    4
#define PHY_AN_LINKPARTNER_REG                      5
#define PHY_1000_BASET_CONTROL_REG                  9
#define PHY_1000_BASET_STATUS_REG                   10
//#define PHY_RESOLVED_REG                            17

#ifndef CONFIG_RTL_CUSTOM_PASSTHRU
#define CONFIG_RTL_CUSTOM_PASSTHRU 1
#endif

#if defined(CONFIG_RTL_CUSTOM_PASSTHRU)
#define PASSTHRU_VLAN_ID 100
#endif

typedef enum rtk_switch_maxPktLen_e
{
    MAXPKTLEN_1522B = 0,
    MAXPKTLEN_1536B,
    MAXPKTLEN_1552B,
    MAXPKTLEN_16000B,
    MAXPKTLEN_END
} rtk_switch_maxPktLen_t;

#endif /* __RTK_API_H__ */

