#ifndef __HAL8197F_CFG_H__
#define __HAL8197F_CFG_H__

// Need to confirm by each IC
#define NUM_TX_DESC_8197F               NUM_TX_DESC
#define RX_Q_RXBD_NUM_8197F             RX_Q_RXBD_NUM//256
#define TX_CMDQ_TXBD_NUM_8197F          32
#define TX_HIQ_NUM_8197F                16
#define SIZE_TXDESC_88XX_8197F          64//48

// TX related
#define TX_VOQ_TXBD_NUM_8197F		    NUM_TX_DESC_8197F
#define TX_VIQ_TXBD_NUM_8197F		    NUM_TX_DESC_8197F
#define TX_BEQ_TXBD_NUM_8197F	        NUM_TX_DESC_8197F
#define TX_BKQ_TXBD_NUM_8197F		    NUM_TX_DESC_8197F
#define TX_MGQ_TXBD_NUM_8197F           NUM_TX_DESC_8197F

#define NUM_TX_DESC_HQ_8197F 	        NUM_TX_DESC_HQ//(NUM_TX_DESC_8197F>>3)

// HIQ in 8197F extend to 16

#define TX_HIQ_TXBD_NUM_8197F	        (NUM_TX_DESC_HQ_8197F*TX_HIQ_NUM_8197F)
#define TOTAL_NUM_TXBD_NO_BCN_8197F     (TX_MGQ_TXBD_NUM_8197F + TX_VOQ_TXBD_NUM_8197F + TX_VIQ_TXBD_NUM_8197F + TX_BEQ_TXBD_NUM_8197F + \
                                        TX_BKQ_TXBD_NUM_8197F + TX_HIQ_TXBD_NUM_8197F + TX_CMDQ_TXBD_NUM_8197F)

#if CFG_HAL_TX_AMSDU
#define TOTAL_NUM_TXBD_FOR_AMSDU_8197F    (TX_VOQ_TXBD_NUM_8197F + TX_VIQ_TXBD_NUM_8197F + TX_BEQ_TXBD_NUM_8197F + TX_BKQ_TXBD_NUM_8197F)
#define DESC_DMA_SIZE_FOR_AMSDU_8197F     (TOTAL_NUM_TXBD_FOR_AMSDU_8197F * sizeof(TX_BUFFER_DESCRIPTOR_AMSDU))
#define DESC_DMA_PAGE_SIZE_HAL_FOR_AMSDU_8197F    (DESC_DMA_SIZE_FOR_AMSDU_8197F + HAL_PAGE_SIZE)
#endif //CFG_HAL_TX_AMSDU

// RX related 
#define TOTAL_NUM_RXBD_8197F          (RX_Q_RXBD_NUM_8197F)

// Total 
#define DESC_DMA_SIZE_NO_BCNQ_8197F \
     (TOTAL_NUM_TXBD_NO_BCN_8197F * (sizeof(TX_BUFFER_DESCRIPTOR) + SIZE_TXDESC_88XX_8197F))
     
#define DESC_DMA_SIZE_TX_MAX_8197F    (DESC_DMA_SIZE_NO_BCNQ_8197F + \
                                      (1+HAL_NUM_VWLAN) * TXBD_BEACON_OFFSET_MAX + \
                                      (1+HAL_NUM_VWLAN) * SIZE_TXDESC_88XX_8197F)

#define DESC_DMA_SIZE_RX_MAX_8197F  (TOTAL_NUM_RXBD_8197F * sizeof(RX_BUFFER_DESCRIPTOR))

#define DESC_DMA_RXSIZE_PAGE_8197F  (DESC_DMA_SIZE_RX_MAX_8197F + PAGE_SIZE)
#define DESC_DMA_TXSIZE_PAGE_8197F  (DESC_DMA_SIZE_TX_MAX_8197F + PAGE_SIZE)
#define DESC_DMA_PAGE_SIZE_MAX_8197F  (DESC_DMA_RXSIZE_PAGE_8197F + DESC_DMA_TXSIZE_PAGE_8197F + HAL_PAGE_SIZE)

#endif //__HAL8197F_CFG_H__


