#ifndef __HAL8812F_CFG_H__
#define __HAL8812F_CFG_H__

// Need to confirm by each IC
#define NUM_TX_DESC_8812F               NUM_TX_DESC
#define RX_Q_RXBD_NUM_8812F             RX_Q_RXBD_NUM//256
#define TX_CMDQ_TXBD_NUM_8812F          32
#define TX_HIQ_NUM_8812F                8
#define SIZE_TXDESC_88XX_8812F          64

// TX related
#define TX_VOQ_TXBD_NUM_8812F		    NUM_TX_DESC_8812F
#define TX_VIQ_TXBD_NUM_8812F		    NUM_TX_DESC_8812F
#define TX_BEQ_TXBD_NUM_8812F	        NUM_TX_DESC_8812F
#define TX_BKQ_TXBD_NUM_8812F		    NUM_TX_DESC_8812F
#define TX_MGQ_TXBD_NUM_8812F           NUM_TX_DESC_8812F

#define NUM_TX_DESC_HQ_8812F 	        NUM_TX_DESC_HQ//(NUM_TX_DESC_8812F>>3)

// HIQ in 8812F extend to 16

#define TX_HIQ_TXBD_NUM_8812F	        (NUM_TX_DESC_HQ_8812F*TX_HIQ_NUM_8812F)
#define TOTAL_NUM_TXBD_NO_BCN_8812F     (TX_MGQ_TXBD_NUM_8812F + TX_VOQ_TXBD_NUM_8812F + TX_VIQ_TXBD_NUM_8812F + TX_BEQ_TXBD_NUM_8812F + \
                                        TX_BKQ_TXBD_NUM_8812F + TX_HIQ_TXBD_NUM_8812F + TX_CMDQ_TXBD_NUM_8812F)

#if CFG_HAL_TX_AMSDU
#define TOTAL_NUM_TXBD_FOR_AMSDU_8812F    (TX_VOQ_TXBD_NUM_8812F + TX_VIQ_TXBD_NUM_8812F + TX_BEQ_TXBD_NUM_8812F + TX_BKQ_TXBD_NUM_8812F)
#define DESC_DMA_SIZE_FOR_AMSDU_8812F     (TOTAL_NUM_TXBD_FOR_AMSDU_8812F * sizeof(TX_BUFFER_DESCRIPTOR_AMSDU))
#define DESC_DMA_PAGE_SIZE_HAL_FOR_AMSDU_8812F    (DESC_DMA_SIZE_FOR_AMSDU_8812F + HAL_PAGE_SIZE)
#endif //CFG_HAL_TX_AMSDU

// RX related 
#define TOTAL_NUM_RXBD_8812F          (RX_Q_RXBD_NUM_8812F)

// Total 
#define DESC_DMA_SIZE_NO_BCNQ_8812F \
     (TOTAL_NUM_TXBD_NO_BCN_8812F * (sizeof(TX_BUFFER_DESCRIPTOR) + SIZE_TXDESC_88XX_8812F))
     
	 #define DESC_DMA_SIZE_TX_MAX_8812F    (DESC_DMA_SIZE_NO_BCNQ_8812F + \
                                      (1+HAL_NUM_VWLAN) * TXBD_BEACON_OFFSET_MAX + \
                                      (1+HAL_NUM_VWLAN) * SIZE_TXDESC_88XX_8812F)

#define DESC_DMA_SIZE_RX_MAX_8812F  (TOTAL_NUM_RXBD_8812F * sizeof(RX_BUFFER_DESCRIPTOR))

#define DESC_DMA_RXSIZE_PAGE_8812F  (DESC_DMA_SIZE_RX_MAX_8812F + PAGE_SIZE)
#define DESC_DMA_TXSIZE_PAGE_8812F  (DESC_DMA_SIZE_TX_MAX_8812F + PAGE_SIZE)
#define DESC_DMA_PAGE_SIZE_MAX_8812F  (DESC_DMA_RXSIZE_PAGE_8812F + DESC_DMA_TXSIZE_PAGE_8812F + HAL_PAGE_SIZE)

#endif //__HAL8812F_CFG_H__

