#ifndef __HAL8814B_CFG_H__
#define __HAL8814B_CFG_H__

// Need to confirm by each IC
#define NUM_TX_DESC_8814B               NUM_TX_DESC
#if defined(CONFIG_PE_ENABLE)
#define RX_Q_RXBD_NUM_8814B             0
#else
#define RX_Q_RXBD_NUM_8814B             NUM_RX_DESC
#endif
#define TX_CMDQ_TXBD_NUM_8814B          32
#define NUM_TX_DESC_CMDQ_8814B        	32
#define TX_HIQ_NUM_8814B                16
#define SIZE_TXDESC_88XX_8814B          64


// TX related
#if defined(CONFIG_PE_ENABLE)
#define TX_VOQ_TXBD_NUM_8814B		    0
#define TX_VIQ_TXBD_NUM_8814B		    0
#define TX_BEQ_TXBD_NUM_8814B	        0
#define TX_BKQ_TXBD_NUM_8814B		    0
#else
#define TX_VOQ_TXBD_NUM_8814B		    NUM_TX_DESC_8814B
#define TX_VIQ_TXBD_NUM_8814B		    NUM_TX_DESC_8814B
#define TX_BEQ_TXBD_NUM_8814B	        NUM_TX_DESC_8814B
#define TX_BKQ_TXBD_NUM_8814B		    NUM_TX_DESC_8814B
#endif
#define TX_MGQ_TXBD_NUM_8814B           NUM_TX_DESC_8814B

#define NUM_TX_DESC_HQ_8814B 	        NUM_TX_DESC_HQ//(NUM_TX_DESC_8814B>>4)
#define TX_FWCMDQ_TXBD_NUM_8814B	    NUM_TX_DESC_CMDQ_8814B

#define TX_ACH4_TXBD_NUM_8814B		    NUM_TX_DESC_8814B
#define TX_ACH5_TXBD_NUM_8814B		    NUM_TX_DESC_8814B
#define TX_ACH6_TXBD_NUM_8814B		    NUM_TX_DESC_8814B
#define TX_ACH7_TXBD_NUM_8814B		    NUM_TX_DESC_8814B
#define TX_ACH8_TXBD_NUM_8814B		    NUM_TX_DESC_8814B
#define TX_ACH9_TXBD_NUM_8814B		    NUM_TX_DESC_8814B
#define TX_ACH10_TXBD_NUM_8814B		    NUM_TX_DESC_8814B
#define TX_ACH11_TXBD_NUM_8814B		    NUM_TX_DESC_8814B
#define TX_ACH12_TXBD_NUM_8814B		    NUM_TX_DESC_8814B
#define TX_ACH13_TXBD_NUM_8814B		    NUM_TX_DESC_8814B


#define TX_HI0Q_TXBD_NUM_8814B	    NUM_TX_DESC_HQ
#define TX_HI1Q_TXBD_NUM_8814B	    NUM_TX_DESC_HQ
#define TX_HI2Q_TXBD_NUM_8814B	    NUM_TX_DESC_HQ
#define TX_HI3Q_TXBD_NUM_8814B	    NUM_TX_DESC_HQ
#define TX_HI4Q_TXBD_NUM_8814B	    NUM_TX_DESC_HQ
#define TX_HI5Q_TXBD_NUM_8814B	    NUM_TX_DESC_HQ
#define TX_HI6Q_TXBD_NUM_8814B	    NUM_TX_DESC_HQ
#define TX_HI7Q_TXBD_NUM_8814B	    NUM_TX_DESC_HQ

#define TX_HI8Q_TXBD_NUM_8814B	    NUM_TX_DESC_HQ
#define TX_HI9Q_TXBD_NUM_8814B	    NUM_TX_DESC_HQ
#define TX_HI10Q_TXBD_NUM_8814B	    NUM_TX_DESC_HQ
#define TX_HI11Q_TXBD_NUM_8814B	    NUM_TX_DESC_HQ
#define TX_HI12Q_TXBD_NUM_8814B	    NUM_TX_DESC_HQ
#define TX_HI13Q_TXBD_NUM_8814B	    NUM_TX_DESC_HQ
#define TX_HI14Q_TXBD_NUM_8814B	    NUM_TX_DESC_HQ
#define TX_HI15Q_TXBD_NUM_8814B	    NUM_TX_DESC_HQ
#define TX_HI16Q_TXBD_NUM_8814B	    NUM_TX_DESC_HQ
#define TX_HI17Q_TXBD_NUM_8814B	    NUM_TX_DESC_HQ
#define TX_HI18Q_TXBD_NUM_8814B	    NUM_TX_DESC_HQ
#define TX_HI19Q_TXBD_NUM_8814B	    NUM_TX_DESC_HQ

// HIQ in 8814B extend to 16

#define TX_HIQ_TXBD_NUM_8814B	        (NUM_TX_DESC_HQ_8814B*TX_HIQ_NUM_8814B)
#define TOTAL_NUM_TXBD_NO_BCN_8814B     (TX_MGQ_TXBD_NUM_8814B + TX_VOQ_TXBD_NUM_8814B + TX_VIQ_TXBD_NUM_8814B + TX_BEQ_TXBD_NUM_8814B + TX_BKQ_TXBD_NUM_8814B +\
										TX_ACH4_TXBD_NUM_8814B + TX_ACH5_TXBD_NUM_8814B + TX_ACH6_TXBD_NUM_8814B + TX_ACH7_TXBD_NUM_8814B + \
										TX_ACH8_TXBD_NUM_8814B + TX_ACH9_TXBD_NUM_8814B + TX_ACH10_TXBD_NUM_8814B +TX_ACH11_TXBD_NUM_8814B + \
										TX_ACH12_TXBD_NUM_8814B + TX_ACH13_TXBD_NUM_8814B + \
                                        TX_HIQ_TXBD_NUM_8814B + TX_CMDQ_TXBD_NUM_8814B + TX_FWCMDQ_TXBD_NUM_8814B)

#if CFG_HAL_TX_AMSDU
#define TOTAL_NUM_TXBD_FOR_AMSDU_8814B    (TX_VOQ_TXBD_NUM_8814B + TX_VIQ_TXBD_NUM_8814B + TX_BEQ_TXBD_NUM_8814B + TX_BKQ_TXBD_NUM_8814B)
#define DESC_DMA_SIZE_FOR_AMSDU_8814B     (TOTAL_NUM_TXBD_FOR_AMSDU_8814B * sizeof(TX_BUFFER_DESCRIPTOR_AMSDU))
#define DESC_DMA_PAGE_SIZE_HAL_FOR_AMSDU_8814B    (DESC_DMA_SIZE_FOR_AMSDU_8814B + HAL_PAGE_SIZE)
#endif //CFG_HAL_TX_AMSDU

// RX related 
#define TOTAL_NUM_RXBD_8814B          (RX_Q_RXBD_NUM_8814B)

// Total 
#define DESC_DMA_SIZE_NO_BCNQ_8814B \
     (TOTAL_NUM_TXBD_NO_BCN_8814B * (sizeof(TX_BUFFER_DESCRIPTOR) + SIZE_TXDESC_88XX_8814B))
     
#define DESC_DMA_SIZE_TX_MAX_8814B    (DESC_DMA_SIZE_NO_BCNQ_8814B + \
                                      (1+HAL_NUM_VWLAN) * TXBD_BEACON_OFFSET_MAX + \
                                      (1+HAL_NUM_VWLAN) * SIZE_TXDESC_88XX_8814B)

#define DESC_DMA_SIZE_RX_MAX_8814B  (TOTAL_NUM_RXBD_8814B * sizeof(RX_BUFFER_DESCRIPTOR))

#define DESC_DMA_RXSIZE_PAGE_8814B  (DESC_DMA_SIZE_RX_MAX_8814B + PAGE_SIZE)
#define DESC_DMA_TXSIZE_PAGE_8814B  (DESC_DMA_SIZE_TX_MAX_8814B + PAGE_SIZE)
#define DESC_DMA_PAGE_SIZE_MAX_8814B  (DESC_DMA_RXSIZE_PAGE_8814B + DESC_DMA_TXSIZE_PAGE_8814B + HAL_PAGE_SIZE)






#ifdef CONFIG_RTL_OFFLOAD_DRIVER

#define TX_CH04Q_TXBD_NUM_8814B		NONBE_TXDESC
#define TX_CH05Q_TXBD_NUM_8814B		NONBE_TXDESC
#define TX_CH06Q_TXBD_NUM_8814B		NONBE_TXDESC
#define TX_CH07Q_TXBD_NUM_8814B		NONBE_TXDESC
#define TX_CH08Q_TXBD_NUM_8814B		NONBE_TXDESC
#define TX_CH09Q_TXBD_NUM_8814B		NONBE_TXDESC
#define TX_CH10Q_TXBD_NUM_8814B		NONBE_TXDESC
#define TX_CH11Q_TXBD_NUM_8814B		NONBE_TXDESC
#define TX_DATAQ1_TXBD_NUM_8814B		NONBE_TXDESC
#define TX_DATAQ2_TXBD_NUM_8814B		NONBE_TXDESC
#define TX_DATA_EMG_TXBD_NUM_8814B	NONBE_TXDESC
#define TX_BCNQ_TXBD_NUM_OFLD_8814B   NONBE_TXDESC
#define TX_CMDQ_TXBD_NUM_OFLD_8814B   NONBE_TXDESC


#define TX_HIQ_NUM_OFLD_8814B           20
#define TX_HIQ_TXBD_NUM_OFLD_8814B	        (NUM_TX_DESC_HQ_8814B*TX_HIQ_NUM_OFLD_8814B)

#define TOTAL_NUM_TXBD_NO_BCN_OFLD_8814B   (TX_BEQ_TXBD_NUM_8814B + TX_BKQ_TXBD_NUM_8814B + TX_VIQ_TXBD_NUM_8814B + TX_VOQ_TXBD_NUM_8814B + \
                                    TX_CH04Q_TXBD_NUM_8814B + TX_CH05Q_TXBD_NUM_8814B + TX_CH06Q_TXBD_NUM_8814B + TX_CH07Q_TXBD_NUM_8814B + \
                                    TX_CH08Q_TXBD_NUM_8814B + TX_CH09Q_TXBD_NUM_8814B + TX_CH10Q_TXBD_NUM_8814B + TX_CH11Q_TXBD_NUM_8814B + \
                                    TX_DATAQ1_TXBD_NUM_8814B + TX_DATAQ2_TXBD_NUM_8814B + \
                                    TX_MGQ_TXBD_NUM_8814B + TX_BCNQ_TXBD_NUM_OFLD_8814B + TX_CMDQ_TXBD_NUM_OFLD_8814B + \
                                    TX_HIQ_TXBD_NUM_OFLD_8814B)


/* @brief 8814B DMA-simulation memory size */
 // beacon use high-queue at simulation
#define H2D_DESC_8814B_DMA_SIZE \
    (RX_Q_RXBD_NUM_8814B * sizeof(RX_BUFFER_DESCRIPTOR) + \
     TOTAL_NUM_TXBD_NO_BCN_OFLD_8814B * (sizeof(TX_BUFFER_DESCRIPTOR) + (sizeof(H2D_TXDMA_INFO))) )
    
#define H2D_DESC_8814B_DMA_SIZE_MAX (H2D_DESC_8814B_DMA_SIZE /*+ HAL_PAGE_SIZE*/)

#define DESC_DMA_SIZE_RX_MAX_DCOFLD_8814B  RX_Q_RXBD_NUM_8814B * sizeof(RX_BUFFER_DESCRIPTOR)
#define DESC_DMA_SIZE_TX_MAX_DCOFLD_8814B  TOTAL_NUM_TXBD_NO_BCN_OFLD_8814B * (sizeof(TX_BUFFER_DESCRIPTOR) + (sizeof(H2D_TXDMA_INFO)))
#define DESC_DMA_RXSIZE_PAGE_DCOFLD_8814B  (DESC_DMA_SIZE_RX_MAX_DCOFLD_8814B + PAGE_SIZE)
#define DESC_DMA_TXSIZE_PAGE_DCOFLD_8814B  (DESC_DMA_SIZE_TX_MAX_DCOFLD_8814B + PAGE_SIZE)
#define H2D_DESC_8814B_TX_DMA_SIZE_MAX (DESC_DMA_SIZE_TX_MAX_DCOFLD_8814B /*+ HAL_PAGE_SIZE*/)


#ifdef CONFIG_PE_ENABLE
#define DATAQ_IDX_DCOFLD_MIN   HCI_TX_DMA_QUEUE_BK_V2 //0
#define DATAQ_IDX_DCOFLD_MAX   HCI_TX_DMA_QUEUE_VO_V2 //15
#endif //CONFIG_PE_ENABLE

#endif //CONFIG_RTL_OFFLOAD_DRIVER



#endif //__HAL8814B_CFG_H__

