/******************************************************************************
 *
 * Copyright(c) 2007 - 2017 Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * The full GNU General Public License is included in this distribution in the
 * file called LICENSE.
 *
 * Contact Information:
 * wlanfae <wlanfae@realtek.com>
 * Realtek Corporation, No. 2, Innovation Road II, Hsinchu Science Park,
 * Hsinchu 300, Taiwan.
 *
 * Larry Finger <Larry.Finger@lwfinger.net>
 *
 *****************************************************************************/

/*Image2HeaderVersion: R3 1.5.5*/
#include "mp_precomp.h"

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
#if RT_PLATFORM == PLATFORM_MACOSX
#include "phydm_precomp.h"
#else
#include "../phydm_precomp.h"
#endif
#else
#include "../../phydm_precomp.h"
#endif

#define D_S_SIZE DELTA_SWINGIDX_SIZE
#define D_ST_SIZE DELTA_SWINTSSI_SIZE

#if (RTL8814B_SUPPORT == 1)
static boolean
check_positive(struct dm_struct *dm,
	       const u32	condition1,
	       const u32	condition2,
	       const u32	condition3,
	       const u32	condition4
)
{
	u32	cond1 = condition1, cond2 = condition2,
		cond3 = condition3, cond4 = condition4;

	u8	cut_version_for_para =
		(dm->cut_version ==  ODM_CUT_A) ? 15 : dm->cut_version;

	u8	pkg_type_for_para =
		(dm->package_type == 0) ? 15 : dm->package_type;

	u32	driver1 = cut_version_for_para << 24 |
			(dm->support_interface & 0xF0) << 16 |
			dm->support_platform << 16 |
			pkg_type_for_para << 12 |
			(dm->support_interface & 0x0F) << 8  |
			dm->rfe_type;

	u32	driver2 = (dm->type_glna & 0xFF) <<  0 |
			(dm->type_gpa & 0xFF)  <<  8 |
			(dm->type_alna & 0xFF) << 16 |
			(dm->type_apa & 0xFF)  << 24;

	u32	driver3 = 0;

	u32	driver4 = (dm->type_glna & 0xFF00) >>  8 |
			(dm->type_gpa & 0xFF00) |
			(dm->type_alna & 0xFF00) << 8 |
			(dm->type_apa & 0xFF00)  << 16;

	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "===> %s (cond1, cond2, cond3, cond4) = (0x%X 0x%X 0x%X 0x%X)\n",
		  __func__, cond1, cond2, cond3, cond4);
	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "===> %s (driver1, driver2, driver3, driver4) = (0x%X 0x%X 0x%X 0x%X)\n",
		  __func__, driver1, driver2, driver3, driver4);

	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "	(Platform, Interface) = (0x%X, 0x%X)\n",
		  dm->support_platform, dm->support_interface);
	PHYDM_DBG(dm, ODM_COMP_INIT, "	(RFE, Package) = (0x%X, 0x%X)\n",
		  dm->rfe_type, dm->package_type);

	/*============== value Defined Check ===============*/
	/*cut version [27:24] need to do value check*/
	if (((cond1 & 0x0F000000) != 0) &&
	    ((cond1 & 0x0F000000) != (driver1 & 0x0F000000)))
		return false;

	/*pkg type [15:12] need to do value check*/
	if (((cond1 & 0x0000F000) != 0) &&
	    ((cond1 & 0x0000F000) != (driver1 & 0x0000F000)))
		return false;

	/*interface [11:8] need to do value check*/
	if (((cond1 & 0x00000F00) != 0) &&
	    ((cond1 & 0x00000F00) != (driver1 & 0x00000F00)))
		return false;
	/*=============== Bit Defined Check ================*/
	/* We don't care [31:28] */

	cond1 &= 0x000000FF;
	driver1 &= 0x000000FF;

	if (cond1 == driver1)
		return true;
	else
		return false;
}


/******************************************************************************
 *                           radioa.TXT
 ******************************************************************************/

const u32 array_mp_8814b_radioa[] = {
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x0008D9C0,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x00082700,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x0008D9C0,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x0008D9C0,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x0008D9C0,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x00082700,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x0008D9C0,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x0008D9C0,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x0008D9C0,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x0008D9C0,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x00082700,
	0xA0000000,	0x00000000,
		0x058, 0x00082700,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x0DD, 0x00000010,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x0DD, 0x00000010,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x0DD, 0x00000010,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x0DD, 0x00000010,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x0DD, 0x00000010,
	0xA0000000,	0x00000000,
		0x000, 0x00030000,
		0x0DD, 0x00000010,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000001,
		0x03E, 0x00000244,
		0x03F, 0x000000F7,
		0x033, 0x00000002,
		0x03E, 0x000003FC,
		0x03F, 0x000000F7,
		0x033, 0x00000003,
		0x03E, 0x00000245,
		0x03F, 0x000AFCF7,
		0x033, 0x00000004,
		0x03E, 0x000003F6,
		0x03F, 0x0000F9F7,
		0x033, 0x00000007,
		0x03E, 0x000003FD,
		0x03F, 0x000EFCF7,
		0x0EF, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000001,
		0x03E, 0x00000244,
		0x03F, 0x000000F7,
		0x033, 0x00000002,
		0x03E, 0x000003FC,
		0x03F, 0x000000F7,
		0x033, 0x00000003,
		0x03E, 0x00000245,
		0x03F, 0x000AFCF7,
		0x033, 0x00000004,
		0x03E, 0x000003F6,
		0x03F, 0x0000F9F7,
		0x033, 0x00000007,
		0x03E, 0x000003FD,
		0x03F, 0x000EFCF7,
		0x0EF, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000001,
		0x03E, 0x00000244,
		0x03F, 0x000000F7,
		0x033, 0x00000002,
		0x03E, 0x000003FC,
		0x03F, 0x000000F7,
		0x033, 0x00000003,
		0x03E, 0x00000245,
		0x03F, 0x000AFCF7,
		0x033, 0x00000004,
		0x03E, 0x000003F6,
		0x03F, 0x0000F9F7,
		0x033, 0x00000007,
		0x03E, 0x000003FD,
		0x03F, 0x000EFCF7,
		0x0EF, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000001,
		0x03E, 0x00000244,
		0x03F, 0x000000F7,
		0x033, 0x00000002,
		0x03E, 0x000003FC,
		0x03F, 0x000000F7,
		0x033, 0x00000003,
		0x03E, 0x00000245,
		0x03F, 0x000AFCF7,
		0x033, 0x00000004,
		0x03E, 0x000003F6,
		0x03F, 0x0000F9F7,
		0x033, 0x00000007,
		0x03E, 0x000003FD,
		0x03F, 0x000EFCF7,
		0x0EF, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000001,
		0x03E, 0x00000244,
		0x03F, 0x000000F7,
		0x033, 0x00000002,
		0x03E, 0x000003FC,
		0x03F, 0x000000F7,
		0x033, 0x00000003,
		0x03E, 0x00000245,
		0x03F, 0x000AFCF7,
		0x033, 0x00000004,
		0x03E, 0x000003F6,
		0x03F, 0x0000F9F7,
		0x033, 0x00000007,
		0x03E, 0x000003FD,
		0x03F, 0x000EFCF7,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000001,
		0x03E, 0x00000244,
		0x03F, 0x000000F7,
		0x033, 0x00000002,
		0x03E, 0x000003FC,
		0x03F, 0x000000F7,
		0x033, 0x00000003,
		0x03E, 0x00000245,
		0x03F, 0x000AFCF7,
		0x033, 0x00000004,
		0x03E, 0x000003F6,
		0x03F, 0x0000F9F7,
		0x033, 0x00000007,
		0x03E, 0x000003FD,
		0x03F, 0x000EFCF7,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x09E, 0x000F8009,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x09E, 0x000F8009,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x09E, 0x000F8009,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x09E, 0x000F8009,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x09E, 0x000F8009,
	0xA0000000,	0x00000000,
		0x09E, 0x000F8009,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0xA0000000,	0x00000000,
		0x018, 0x00013124,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00000006,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00000006,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00000006,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00000006,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00000006,
	0xA0000000,	0x00000000,
		0x018, 0x00000006,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x0005512D,
		0x080, 0x000CE800,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x0005516D,
		0x080, 0x000CE800,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x0005512D,
		0x080, 0x000CE800,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x0005516D,
		0x080, 0x000CE800,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x0005512D,
		0x080, 0x000CE800,
	0xA0000000,	0x00000000,
		0x087, 0x0005512D,
		0x080, 0x000CE800,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x082, 0x00003300,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x082, 0x00003300,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x082, 0x00003300,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x082, 0x00003300,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x082, 0x00003300,
	0xA0000000,	0x00000000,
		0x082, 0x00003300,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0C0, 0x0007FC00,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0C0, 0x0007FC00,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0C0, 0x0007FC00,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0C0, 0x0007FC00,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0C0, 0x0007FC00,
	0xA0000000,	0x00000000,
		0x0C0, 0x0007FC00,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x01A, 0x00040004,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x01A, 0x00040004,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x01A, 0x00040004,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x01A, 0x00040004,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x01A, 0x00040004,
	0xA0000000,	0x00000000,
		0x01A, 0x00040004,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0000D3A5,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0000D3A5,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0000D3A5,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0000D3A5,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0000D3A5,
	0xA0000000,	0x00000000,
		0x061, 0x0000D3A5,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00010000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00010000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00010000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00010000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00010000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00010000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000F04,
		0x033, 0x00000021,
		0x03F, 0x00000F64,
		0x033, 0x00000022,
		0x03F, 0x00002E04,
		0x033, 0x00000023,
		0x03F, 0x00004E85,
		0x033, 0x00000024,
		0x03F, 0x00004E88,
		0x033, 0x00000025,
		0x03F, 0x00006F05,
		0x033, 0x00000026,
		0x03F, 0x00006FE7,
		0x033, 0x00000027,
		0x03F, 0x00006FEA,
		0x033, 0x00000028,
		0x03F, 0x00006FED,
		0x033, 0x00000029,
		0x03F, 0x00006FF0,
		0x033, 0x0000002A,
		0x03F, 0x00006FF3,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000F04,
		0x033, 0x00000021,
		0x03F, 0x00000F64,
		0x033, 0x00000022,
		0x03F, 0x00002E04,
		0x033, 0x00000023,
		0x03F, 0x00004E85,
		0x033, 0x00000024,
		0x03F, 0x00004E88,
		0x033, 0x00000025,
		0x03F, 0x00006F05,
		0x033, 0x00000026,
		0x03F, 0x00006FE7,
		0x033, 0x00000027,
		0x03F, 0x00006FEA,
		0x033, 0x00000028,
		0x03F, 0x00006FED,
		0x033, 0x00000029,
		0x03F, 0x00006FF0,
		0x033, 0x0000002A,
		0x03F, 0x00006FF3,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000F04,
		0x033, 0x00000021,
		0x03F, 0x00000F64,
		0x033, 0x00000022,
		0x03F, 0x00002E04,
		0x033, 0x00000023,
		0x03F, 0x00004E85,
		0x033, 0x00000024,
		0x03F, 0x00004E88,
		0x033, 0x00000025,
		0x03F, 0x00006F05,
		0x033, 0x00000026,
		0x03F, 0x00006FE7,
		0x033, 0x00000027,
		0x03F, 0x00006FEA,
		0x033, 0x00000028,
		0x03F, 0x00006FED,
		0x033, 0x00000029,
		0x03F, 0x00006FF0,
		0x033, 0x0000002A,
		0x03F, 0x00006FF3,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000F04,
		0x033, 0x00000021,
		0x03F, 0x00000F64,
		0x033, 0x00000022,
		0x03F, 0x00002E04,
		0x033, 0x00000023,
		0x03F, 0x00004E85,
		0x033, 0x00000024,
		0x03F, 0x00004E88,
		0x033, 0x00000025,
		0x03F, 0x00006F05,
		0x033, 0x00000026,
		0x03F, 0x00006FE7,
		0x033, 0x00000027,
		0x03F, 0x00006FEA,
		0x033, 0x00000028,
		0x03F, 0x00006FED,
		0x033, 0x00000029,
		0x03F, 0x00006FF0,
		0x033, 0x0000002A,
		0x03F, 0x00006FF3,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000F04,
		0x033, 0x00000021,
		0x03F, 0x00000F64,
		0x033, 0x00000022,
		0x03F, 0x00002E04,
		0x033, 0x00000023,
		0x03F, 0x00004E85,
		0x033, 0x00000024,
		0x03F, 0x00004E88,
		0x033, 0x00000025,
		0x03F, 0x00006F05,
		0x033, 0x00000026,
		0x03F, 0x00006FE7,
		0x033, 0x00000027,
		0x03F, 0x00006FEA,
		0x033, 0x00000028,
		0x03F, 0x00006FED,
		0x033, 0x00000029,
		0x03F, 0x00006FF0,
		0x033, 0x0000002A,
		0x03F, 0x00006FF3,
	0xA0000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000F04,
		0x033, 0x00000021,
		0x03F, 0x00000F64,
		0x033, 0x00000022,
		0x03F, 0x00002E04,
		0x033, 0x00000023,
		0x03F, 0x00004E85,
		0x033, 0x00000024,
		0x03F, 0x00004E88,
		0x033, 0x00000025,
		0x03F, 0x00006F05,
		0x033, 0x00000026,
		0x03F, 0x00006FE7,
		0x033, 0x00000027,
		0x03F, 0x00006FEA,
		0x033, 0x00000028,
		0x03F, 0x00006FED,
		0x033, 0x00000029,
		0x03F, 0x00006FF0,
		0x033, 0x0000002A,
		0x03F, 0x00006FF3,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000F04,
		0x033, 0x00000061,
		0x03F, 0x00000F64,
		0x033, 0x00000062,
		0x03F, 0x00002E04,
		0x033, 0x00000063,
		0x03F, 0x00004E85,
		0x033, 0x00000064,
		0x03F, 0x00004E88,
		0x033, 0x00000065,
		0x03F, 0x00006F05,
		0x033, 0x00000066,
		0x03F, 0x00006FE7,
		0x033, 0x00000067,
		0x03F, 0x00006FEA,
		0x033, 0x00000068,
		0x03F, 0x00006FED,
		0x033, 0x00000069,
		0x03F, 0x00006FF0,
		0x033, 0x0000006A,
		0x03F, 0x00006FF3,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000E64,
		0x033, 0x00000061,
		0x03F, 0x00000E85,
		0x033, 0x00000062,
		0x03F, 0x00000EE4,
		0x033, 0x00000063,
		0x03F, 0x00000EE7,
		0x033, 0x00000064,
		0x03F, 0x00000EEA,
		0x033, 0x00000065,
		0x03F, 0x00004E65,
		0x033, 0x00000066,
		0x03F, 0x00002EA7,
		0x033, 0x00000067,
		0x03F, 0x00002EAA,
		0x033, 0x00000068,
		0x03F, 0x00002EAD,
		0x033, 0x00000069,
		0x03F, 0x00002EB0,
		0x033, 0x0000006A,
		0x03F, 0x00002EB3,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000E64,
		0x033, 0x00000061,
		0x03F, 0x00000E85,
		0x033, 0x00000062,
		0x03F, 0x00000EE4,
		0x033, 0x00000063,
		0x03F, 0x00000EE7,
		0x033, 0x00000064,
		0x03F, 0x00000EEA,
		0x033, 0x00000065,
		0x03F, 0x00004E65,
		0x033, 0x00000066,
		0x03F, 0x00002EA7,
		0x033, 0x00000067,
		0x03F, 0x00002EAA,
		0x033, 0x00000068,
		0x03F, 0x00002EAD,
		0x033, 0x00000069,
		0x03F, 0x00002EB0,
		0x033, 0x0000006A,
		0x03F, 0x00002EB3,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000E64,
		0x033, 0x00000061,
		0x03F, 0x00000E85,
		0x033, 0x00000062,
		0x03F, 0x00000EE4,
		0x033, 0x00000063,
		0x03F, 0x00000EE7,
		0x033, 0x00000064,
		0x03F, 0x00000EEA,
		0x033, 0x00000065,
		0x03F, 0x00004E65,
		0x033, 0x00000066,
		0x03F, 0x00002EA7,
		0x033, 0x00000067,
		0x03F, 0x00002EAA,
		0x033, 0x00000068,
		0x03F, 0x00002EAD,
		0x033, 0x00000069,
		0x03F, 0x00002EB0,
		0x033, 0x0000006A,
		0x03F, 0x00002EB3,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000E64,
		0x033, 0x00000061,
		0x03F, 0x00000E85,
		0x033, 0x00000062,
		0x03F, 0x00000EE4,
		0x033, 0x00000063,
		0x03F, 0x00000EE7,
		0x033, 0x00000064,
		0x03F, 0x00000EEA,
		0x033, 0x00000065,
		0x03F, 0x00004E65,
		0x033, 0x00000066,
		0x03F, 0x00002EA7,
		0x033, 0x00000067,
		0x03F, 0x00002EAA,
		0x033, 0x00000068,
		0x03F, 0x00002EAD,
		0x033, 0x00000069,
		0x03F, 0x00002EB0,
		0x033, 0x0000006A,
		0x03F, 0x00002EB3,
	0xA0000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000E64,
		0x033, 0x00000061,
		0x03F, 0x00000E85,
		0x033, 0x00000062,
		0x03F, 0x00000EE4,
		0x033, 0x00000063,
		0x03F, 0x00000EE7,
		0x033, 0x00000064,
		0x03F, 0x00000EEA,
		0x033, 0x00000065,
		0x03F, 0x00004E65,
		0x033, 0x00000066,
		0x03F, 0x00002EA7,
		0x033, 0x00000067,
		0x03F, 0x00002EAA,
		0x033, 0x00000068,
		0x03F, 0x00002EAD,
		0x033, 0x00000069,
		0x03F, 0x00002EB0,
		0x033, 0x0000006A,
		0x03F, 0x00002EB3,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000203,
		0x033, 0x00000201,
		0x03F, 0x00000206,
		0x033, 0x00000202,
		0x03F, 0x00000209,
		0x033, 0x00000203,
		0x03F, 0x00000226,
		0x033, 0x00000204,
		0x03F, 0x00000229,
		0x033, 0x00000205,
		0x03F, 0x00000266,
		0x033, 0x00000206,
		0x03F, 0x00000269,
		0x033, 0x00000207,
		0x03F, 0x0000026C,
		0x033, 0x00000208,
		0x03F, 0x00000469,
		0x033, 0x00000209,
		0x03F, 0x0000046C,
		0x033, 0x0000020A,
		0x03F, 0x0000046C,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000445,
		0x033, 0x00000201,
		0x03F, 0x00000448,
		0x033, 0x00000202,
		0x03F, 0x00000468,
		0x033, 0x00000203,
		0x03F, 0x00000668,
		0x033, 0x00000204,
		0x03F, 0x00000E67,
		0x033, 0x00000205,
		0x03F, 0x00000EA6,
		0x033, 0x00000206,
		0x03F, 0x00000EE7,
		0x033, 0x00000207,
		0x03F, 0x00000EEA,
		0x033, 0x00000208,
		0x03F, 0x00000EED,
		0x033, 0x00000209,
		0x03F, 0x00000EF0,
		0x033, 0x0000020A,
		0x03F, 0x00000EF3,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000203,
		0x033, 0x00000201,
		0x03F, 0x00000206,
		0x033, 0x00000202,
		0x03F, 0x00000209,
		0x033, 0x00000203,
		0x03F, 0x00000226,
		0x033, 0x00000204,
		0x03F, 0x00000229,
		0x033, 0x00000205,
		0x03F, 0x00000266,
		0x033, 0x00000206,
		0x03F, 0x00000269,
		0x033, 0x00000207,
		0x03F, 0x0000026C,
		0x033, 0x00000208,
		0x03F, 0x00000469,
		0x033, 0x00000209,
		0x03F, 0x0000046C,
		0x033, 0x0000020A,
		0x03F, 0x0000046C,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000203,
		0x033, 0x00000201,
		0x03F, 0x00000206,
		0x033, 0x00000202,
		0x03F, 0x00000209,
		0x033, 0x00000203,
		0x03F, 0x00000226,
		0x033, 0x00000204,
		0x03F, 0x00000229,
		0x033, 0x00000205,
		0x03F, 0x00000266,
		0x033, 0x00000206,
		0x03F, 0x00000269,
		0x033, 0x00000207,
		0x03F, 0x0000026C,
		0x033, 0x00000208,
		0x03F, 0x00000469,
		0x033, 0x00000209,
		0x03F, 0x0000046C,
		0x033, 0x0000020A,
		0x03F, 0x0000046C,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000203,
		0x033, 0x00000201,
		0x03F, 0x00000206,
		0x033, 0x00000202,
		0x03F, 0x00000209,
		0x033, 0x00000203,
		0x03F, 0x00000226,
		0x033, 0x00000204,
		0x03F, 0x00000229,
		0x033, 0x00000205,
		0x03F, 0x00000266,
		0x033, 0x00000206,
		0x03F, 0x00000269,
		0x033, 0x00000207,
		0x03F, 0x0000026C,
		0x033, 0x00000208,
		0x03F, 0x00000469,
		0x033, 0x00000209,
		0x03F, 0x0000046C,
		0x033, 0x0000020A,
		0x03F, 0x0000046C,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000445,
		0x033, 0x00000201,
		0x03F, 0x00000448,
		0x033, 0x00000202,
		0x03F, 0x00000468,
		0x033, 0x00000203,
		0x03F, 0x00000668,
		0x033, 0x00000204,
		0x03F, 0x00000E67,
		0x033, 0x00000205,
		0x03F, 0x00000EA6,
		0x033, 0x00000206,
		0x03F, 0x00000EE7,
		0x033, 0x00000207,
		0x03F, 0x00000EEA,
		0x033, 0x00000208,
		0x03F, 0x00000EED,
		0x033, 0x00000209,
		0x03F, 0x00000EF0,
		0x033, 0x0000020A,
		0x03F, 0x00000EF3,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000203,
		0x033, 0x00000201,
		0x03F, 0x00000206,
		0x033, 0x00000202,
		0x03F, 0x00000209,
		0x033, 0x00000203,
		0x03F, 0x00000226,
		0x033, 0x00000204,
		0x03F, 0x00000229,
		0x033, 0x00000205,
		0x03F, 0x00000266,
		0x033, 0x00000206,
		0x03F, 0x00000269,
		0x033, 0x00000207,
		0x03F, 0x0000026C,
		0x033, 0x00000208,
		0x03F, 0x00000469,
		0x033, 0x00000209,
		0x03F, 0x0000046C,
		0x033, 0x0000020A,
		0x03F, 0x0000046C,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000203,
		0x033, 0x00000201,
		0x03F, 0x00000206,
		0x033, 0x00000202,
		0x03F, 0x00000209,
		0x033, 0x00000203,
		0x03F, 0x00000226,
		0x033, 0x00000204,
		0x03F, 0x00000229,
		0x033, 0x00000205,
		0x03F, 0x00000266,
		0x033, 0x00000206,
		0x03F, 0x00000269,
		0x033, 0x00000207,
		0x03F, 0x0000026C,
		0x033, 0x00000208,
		0x03F, 0x00000469,
		0x033, 0x00000209,
		0x03F, 0x0000046C,
		0x033, 0x0000020A,
		0x03F, 0x0000046C,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000203,
		0x033, 0x00000201,
		0x03F, 0x00000206,
		0x033, 0x00000202,
		0x03F, 0x00000209,
		0x033, 0x00000203,
		0x03F, 0x00000226,
		0x033, 0x00000204,
		0x03F, 0x00000229,
		0x033, 0x00000205,
		0x03F, 0x00000266,
		0x033, 0x00000206,
		0x03F, 0x00000269,
		0x033, 0x00000207,
		0x03F, 0x0000026C,
		0x033, 0x00000208,
		0x03F, 0x00000469,
		0x033, 0x00000209,
		0x03F, 0x0000046C,
		0x033, 0x0000020A,
		0x03F, 0x0000046C,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000203,
		0x033, 0x00000201,
		0x03F, 0x00000206,
		0x033, 0x00000202,
		0x03F, 0x00000209,
		0x033, 0x00000203,
		0x03F, 0x00000226,
		0x033, 0x00000204,
		0x03F, 0x00000229,
		0x033, 0x00000205,
		0x03F, 0x00000266,
		0x033, 0x00000206,
		0x03F, 0x00000269,
		0x033, 0x00000207,
		0x03F, 0x0000026C,
		0x033, 0x00000208,
		0x03F, 0x00000469,
		0x033, 0x00000209,
		0x03F, 0x0000046C,
		0x033, 0x0000020A,
		0x03F, 0x0000046C,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000445,
		0x033, 0x00000201,
		0x03F, 0x00000448,
		0x033, 0x00000202,
		0x03F, 0x00000468,
		0x033, 0x00000203,
		0x03F, 0x00000668,
		0x033, 0x00000204,
		0x03F, 0x00000E67,
		0x033, 0x00000205,
		0x03F, 0x00000EA6,
		0x033, 0x00000206,
		0x03F, 0x00000EE7,
		0x033, 0x00000207,
		0x03F, 0x00000EEA,
		0x033, 0x00000208,
		0x03F, 0x00000EED,
		0x033, 0x00000209,
		0x03F, 0x00000EF0,
		0x033, 0x0000020A,
		0x03F, 0x00000EF3,
	0xA0000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000445,
		0x033, 0x00000201,
		0x03F, 0x00000448,
		0x033, 0x00000202,
		0x03F, 0x00000468,
		0x033, 0x00000203,
		0x03F, 0x00000668,
		0x033, 0x00000204,
		0x03F, 0x00000E67,
		0x033, 0x00000205,
		0x03F, 0x00000EA6,
		0x033, 0x00000206,
		0x03F, 0x00000EE7,
		0x033, 0x00000207,
		0x03F, 0x00000EEA,
		0x033, 0x00000208,
		0x03F, 0x00000EED,
		0x033, 0x00000209,
		0x03F, 0x00000EF0,
		0x033, 0x0000020A,
		0x03F, 0x00000EF3,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000203,
		0x033, 0x00000281,
		0x03F, 0x00000206,
		0x033, 0x00000282,
		0x03F, 0x00000209,
		0x033, 0x00000283,
		0x03F, 0x00000226,
		0x033, 0x00000284,
		0x03F, 0x00000229,
		0x033, 0x00000285,
		0x03F, 0x00000266,
		0x033, 0x00000286,
		0x03F, 0x00000269,
		0x033, 0x00000287,
		0x03F, 0x0000026C,
		0x033, 0x00000288,
		0x03F, 0x00000469,
		0x033, 0x00000289,
		0x03F, 0x0000046C,
		0x033, 0x0000028A,
		0x03F, 0x0000046C,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000445,
		0x033, 0x00000281,
		0x03F, 0x00000465,
		0x033, 0x00000282,
		0x03F, 0x00000468,
		0x033, 0x00000283,
		0x03F, 0x00000668,
		0x033, 0x00000284,
		0x03F, 0x00000E67,
		0x033, 0x00000285,
		0x03F, 0x00000EA6,
		0x033, 0x00000286,
		0x03F, 0x00000EE7,
		0x033, 0x00000287,
		0x03F, 0x00000EEA,
		0x033, 0x00000288,
		0x03F, 0x00000EED,
		0x033, 0x00000289,
		0x03F, 0x00000EF0,
		0x033, 0x0000028A,
		0x03F, 0x00000EF3,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000203,
		0x033, 0x00000281,
		0x03F, 0x00000206,
		0x033, 0x00000282,
		0x03F, 0x00000209,
		0x033, 0x00000283,
		0x03F, 0x00000226,
		0x033, 0x00000284,
		0x03F, 0x00000229,
		0x033, 0x00000285,
		0x03F, 0x00000266,
		0x033, 0x00000286,
		0x03F, 0x00000269,
		0x033, 0x00000287,
		0x03F, 0x0000026C,
		0x033, 0x00000288,
		0x03F, 0x00000469,
		0x033, 0x00000289,
		0x03F, 0x0000046C,
		0x033, 0x0000028A,
		0x03F, 0x0000046C,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000203,
		0x033, 0x00000281,
		0x03F, 0x00000206,
		0x033, 0x00000282,
		0x03F, 0x00000209,
		0x033, 0x00000283,
		0x03F, 0x00000226,
		0x033, 0x00000284,
		0x03F, 0x00000229,
		0x033, 0x00000285,
		0x03F, 0x00000266,
		0x033, 0x00000286,
		0x03F, 0x00000269,
		0x033, 0x00000287,
		0x03F, 0x0000026C,
		0x033, 0x00000288,
		0x03F, 0x00000469,
		0x033, 0x00000289,
		0x03F, 0x0000046C,
		0x033, 0x0000028A,
		0x03F, 0x0000046C,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000203,
		0x033, 0x00000281,
		0x03F, 0x00000206,
		0x033, 0x00000282,
		0x03F, 0x00000209,
		0x033, 0x00000283,
		0x03F, 0x00000226,
		0x033, 0x00000284,
		0x03F, 0x00000229,
		0x033, 0x00000285,
		0x03F, 0x00000266,
		0x033, 0x00000286,
		0x03F, 0x00000269,
		0x033, 0x00000287,
		0x03F, 0x0000026C,
		0x033, 0x00000288,
		0x03F, 0x00000469,
		0x033, 0x00000289,
		0x03F, 0x0000046C,
		0x033, 0x0000028A,
		0x03F, 0x0000046C,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000445,
		0x033, 0x00000281,
		0x03F, 0x00000465,
		0x033, 0x00000282,
		0x03F, 0x00000468,
		0x033, 0x00000283,
		0x03F, 0x00000668,
		0x033, 0x00000284,
		0x03F, 0x00000E67,
		0x033, 0x00000285,
		0x03F, 0x00000EA6,
		0x033, 0x00000286,
		0x03F, 0x00000EE7,
		0x033, 0x00000287,
		0x03F, 0x00000EEA,
		0x033, 0x00000288,
		0x03F, 0x00000EED,
		0x033, 0x00000289,
		0x03F, 0x00000EF0,
		0x033, 0x0000028A,
		0x03F, 0x00000EF3,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000203,
		0x033, 0x00000281,
		0x03F, 0x00000206,
		0x033, 0x00000282,
		0x03F, 0x00000209,
		0x033, 0x00000283,
		0x03F, 0x00000226,
		0x033, 0x00000284,
		0x03F, 0x00000229,
		0x033, 0x00000285,
		0x03F, 0x00000266,
		0x033, 0x00000286,
		0x03F, 0x00000269,
		0x033, 0x00000287,
		0x03F, 0x0000026C,
		0x033, 0x00000288,
		0x03F, 0x00000469,
		0x033, 0x00000289,
		0x03F, 0x0000046C,
		0x033, 0x0000028A,
		0x03F, 0x0000046C,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000203,
		0x033, 0x00000281,
		0x03F, 0x00000206,
		0x033, 0x00000282,
		0x03F, 0x00000209,
		0x033, 0x00000283,
		0x03F, 0x00000226,
		0x033, 0x00000284,
		0x03F, 0x00000229,
		0x033, 0x00000285,
		0x03F, 0x00000266,
		0x033, 0x00000286,
		0x03F, 0x00000269,
		0x033, 0x00000287,
		0x03F, 0x0000026C,
		0x033, 0x00000288,
		0x03F, 0x00000469,
		0x033, 0x00000289,
		0x03F, 0x0000046C,
		0x033, 0x0000028A,
		0x03F, 0x0000046C,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000203,
		0x033, 0x00000281,
		0x03F, 0x00000206,
		0x033, 0x00000282,
		0x03F, 0x00000209,
		0x033, 0x00000283,
		0x03F, 0x00000226,
		0x033, 0x00000284,
		0x03F, 0x00000229,
		0x033, 0x00000285,
		0x03F, 0x00000266,
		0x033, 0x00000286,
		0x03F, 0x00000269,
		0x033, 0x00000287,
		0x03F, 0x0000026C,
		0x033, 0x00000288,
		0x03F, 0x00000469,
		0x033, 0x00000289,
		0x03F, 0x0000046C,
		0x033, 0x0000028A,
		0x03F, 0x0000046C,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000203,
		0x033, 0x00000281,
		0x03F, 0x00000206,
		0x033, 0x00000282,
		0x03F, 0x00000209,
		0x033, 0x00000283,
		0x03F, 0x00000226,
		0x033, 0x00000284,
		0x03F, 0x00000229,
		0x033, 0x00000285,
		0x03F, 0x00000266,
		0x033, 0x00000286,
		0x03F, 0x00000269,
		0x033, 0x00000287,
		0x03F, 0x0000026C,
		0x033, 0x00000288,
		0x03F, 0x00000469,
		0x033, 0x00000289,
		0x03F, 0x0000046C,
		0x033, 0x0000028A,
		0x03F, 0x0000046C,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000445,
		0x033, 0x00000281,
		0x03F, 0x00000465,
		0x033, 0x00000282,
		0x03F, 0x00000468,
		0x033, 0x00000283,
		0x03F, 0x00000668,
		0x033, 0x00000284,
		0x03F, 0x00000E67,
		0x033, 0x00000285,
		0x03F, 0x00000EA6,
		0x033, 0x00000286,
		0x03F, 0x00000EE7,
		0x033, 0x00000287,
		0x03F, 0x00000EEA,
		0x033, 0x00000288,
		0x03F, 0x00000EED,
		0x033, 0x00000289,
		0x03F, 0x00000EF0,
		0x033, 0x0000028A,
		0x03F, 0x00000EF3,
	0xA0000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000445,
		0x033, 0x00000281,
		0x03F, 0x00000465,
		0x033, 0x00000282,
		0x03F, 0x00000468,
		0x033, 0x00000283,
		0x03F, 0x00000668,
		0x033, 0x00000284,
		0x03F, 0x00000E67,
		0x033, 0x00000285,
		0x03F, 0x00000EA6,
		0x033, 0x00000286,
		0x03F, 0x00000EE7,
		0x033, 0x00000287,
		0x03F, 0x00000EEA,
		0x033, 0x00000288,
		0x03F, 0x00000EED,
		0x033, 0x00000289,
		0x03F, 0x00000EF0,
		0x033, 0x0000028A,
		0x03F, 0x00000EF3,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000203,
		0x033, 0x00000301,
		0x03F, 0x00000206,
		0x033, 0x00000302,
		0x03F, 0x00000209,
		0x033, 0x00000303,
		0x03F, 0x00000226,
		0x033, 0x00000304,
		0x03F, 0x00000229,
		0x033, 0x00000305,
		0x03F, 0x00000266,
		0x033, 0x00000306,
		0x03F, 0x00000269,
		0x033, 0x00000307,
		0x03F, 0x0000026C,
		0x033, 0x00000308,
		0x03F, 0x00000469,
		0x033, 0x00000309,
		0x03F, 0x0000046C,
		0x033, 0x0000030A,
		0x03F, 0x0000046C,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000445,
		0x033, 0x00000301,
		0x03F, 0x00000465,
		0x033, 0x00000302,
		0x03F, 0x00000468,
		0x033, 0x00000303,
		0x03F, 0x00000668,
		0x033, 0x00000304,
		0x03F, 0x00000E67,
		0x033, 0x00000305,
		0x03F, 0x00000EA6,
		0x033, 0x00000306,
		0x03F, 0x00000EE7,
		0x033, 0x00000307,
		0x03F, 0x00000EEA,
		0x033, 0x00000308,
		0x03F, 0x00000EED,
		0x033, 0x00000309,
		0x03F, 0x00000EF0,
		0x033, 0x0000030A,
		0x03F, 0x00000EF3,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000203,
		0x033, 0x00000301,
		0x03F, 0x00000206,
		0x033, 0x00000302,
		0x03F, 0x00000209,
		0x033, 0x00000303,
		0x03F, 0x00000226,
		0x033, 0x00000304,
		0x03F, 0x00000229,
		0x033, 0x00000305,
		0x03F, 0x00000266,
		0x033, 0x00000306,
		0x03F, 0x00000269,
		0x033, 0x00000307,
		0x03F, 0x0000026C,
		0x033, 0x00000308,
		0x03F, 0x00000469,
		0x033, 0x00000309,
		0x03F, 0x0000046C,
		0x033, 0x0000030A,
		0x03F, 0x0000046C,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000203,
		0x033, 0x00000301,
		0x03F, 0x00000206,
		0x033, 0x00000302,
		0x03F, 0x00000209,
		0x033, 0x00000303,
		0x03F, 0x00000226,
		0x033, 0x00000304,
		0x03F, 0x00000229,
		0x033, 0x00000305,
		0x03F, 0x00000266,
		0x033, 0x00000306,
		0x03F, 0x00000269,
		0x033, 0x00000307,
		0x03F, 0x0000026C,
		0x033, 0x00000308,
		0x03F, 0x00000469,
		0x033, 0x00000309,
		0x03F, 0x0000046C,
		0x033, 0x0000030A,
		0x03F, 0x0000046C,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000203,
		0x033, 0x00000301,
		0x03F, 0x00000206,
		0x033, 0x00000302,
		0x03F, 0x00000209,
		0x033, 0x00000303,
		0x03F, 0x00000226,
		0x033, 0x00000304,
		0x03F, 0x00000229,
		0x033, 0x00000305,
		0x03F, 0x00000266,
		0x033, 0x00000306,
		0x03F, 0x00000269,
		0x033, 0x00000307,
		0x03F, 0x0000026C,
		0x033, 0x00000308,
		0x03F, 0x00000469,
		0x033, 0x00000309,
		0x03F, 0x0000046C,
		0x033, 0x0000030A,
		0x03F, 0x0000046C,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000445,
		0x033, 0x00000301,
		0x03F, 0x00000465,
		0x033, 0x00000302,
		0x03F, 0x00000468,
		0x033, 0x00000303,
		0x03F, 0x00000668,
		0x033, 0x00000304,
		0x03F, 0x00000E67,
		0x033, 0x00000305,
		0x03F, 0x00000EA6,
		0x033, 0x00000306,
		0x03F, 0x00000EE7,
		0x033, 0x00000307,
		0x03F, 0x00000EEA,
		0x033, 0x00000308,
		0x03F, 0x00000EED,
		0x033, 0x00000309,
		0x03F, 0x00000EF0,
		0x033, 0x0000030A,
		0x03F, 0x00000EF3,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000203,
		0x033, 0x00000301,
		0x03F, 0x00000206,
		0x033, 0x00000302,
		0x03F, 0x00000209,
		0x033, 0x00000303,
		0x03F, 0x00000226,
		0x033, 0x00000304,
		0x03F, 0x00000229,
		0x033, 0x00000305,
		0x03F, 0x00000266,
		0x033, 0x00000306,
		0x03F, 0x00000269,
		0x033, 0x00000307,
		0x03F, 0x0000026C,
		0x033, 0x00000308,
		0x03F, 0x00000469,
		0x033, 0x00000309,
		0x03F, 0x0000046C,
		0x033, 0x0000030A,
		0x03F, 0x0000046C,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000203,
		0x033, 0x00000301,
		0x03F, 0x00000206,
		0x033, 0x00000302,
		0x03F, 0x00000209,
		0x033, 0x00000303,
		0x03F, 0x00000226,
		0x033, 0x00000304,
		0x03F, 0x00000229,
		0x033, 0x00000305,
		0x03F, 0x00000266,
		0x033, 0x00000306,
		0x03F, 0x00000269,
		0x033, 0x00000307,
		0x03F, 0x0000026C,
		0x033, 0x00000308,
		0x03F, 0x00000469,
		0x033, 0x00000309,
		0x03F, 0x0000046C,
		0x033, 0x0000030A,
		0x03F, 0x0000046C,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000203,
		0x033, 0x00000301,
		0x03F, 0x00000206,
		0x033, 0x00000302,
		0x03F, 0x00000209,
		0x033, 0x00000303,
		0x03F, 0x00000226,
		0x033, 0x00000304,
		0x03F, 0x00000229,
		0x033, 0x00000305,
		0x03F, 0x00000266,
		0x033, 0x00000306,
		0x03F, 0x00000269,
		0x033, 0x00000307,
		0x03F, 0x0000026C,
		0x033, 0x00000308,
		0x03F, 0x00000469,
		0x033, 0x00000309,
		0x03F, 0x0000046C,
		0x033, 0x0000030A,
		0x03F, 0x0000046C,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000203,
		0x033, 0x00000301,
		0x03F, 0x00000206,
		0x033, 0x00000302,
		0x03F, 0x00000209,
		0x033, 0x00000303,
		0x03F, 0x00000226,
		0x033, 0x00000304,
		0x03F, 0x00000229,
		0x033, 0x00000305,
		0x03F, 0x00000266,
		0x033, 0x00000306,
		0x03F, 0x00000269,
		0x033, 0x00000307,
		0x03F, 0x0000026C,
		0x033, 0x00000308,
		0x03F, 0x00000469,
		0x033, 0x00000309,
		0x03F, 0x0000046C,
		0x033, 0x0000030A,
		0x03F, 0x0000046C,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000445,
		0x033, 0x00000301,
		0x03F, 0x00000465,
		0x033, 0x00000302,
		0x03F, 0x00000468,
		0x033, 0x00000303,
		0x03F, 0x00000668,
		0x033, 0x00000304,
		0x03F, 0x00000E67,
		0x033, 0x00000305,
		0x03F, 0x00000EA6,
		0x033, 0x00000306,
		0x03F, 0x00000EE7,
		0x033, 0x00000307,
		0x03F, 0x00000EEA,
		0x033, 0x00000308,
		0x03F, 0x00000EED,
		0x033, 0x00000309,
		0x03F, 0x00000EF0,
		0x033, 0x0000030A,
		0x03F, 0x00000EF3,
	0xA0000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000445,
		0x033, 0x00000301,
		0x03F, 0x00000465,
		0x033, 0x00000302,
		0x03F, 0x00000468,
		0x033, 0x00000303,
		0x03F, 0x00000668,
		0x033, 0x00000304,
		0x03F, 0x00000E67,
		0x033, 0x00000305,
		0x03F, 0x00000EA6,
		0x033, 0x00000306,
		0x03F, 0x00000EE7,
		0x033, 0x00000307,
		0x03F, 0x00000EEA,
		0x033, 0x00000308,
		0x03F, 0x00000EED,
		0x033, 0x00000309,
		0x03F, 0x00000EF0,
		0x033, 0x0000030A,
		0x03F, 0x00000EF3,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00040000,
		0x033, 0x00000001,
		0x03F, 0x000C0001,
		0x0EE, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00040000,
		0x033, 0x00000001,
		0x03F, 0x000C0001,
		0x0EE, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00040000,
		0x033, 0x00000001,
		0x03F, 0x000C0001,
		0x0EE, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00040000,
		0x033, 0x00000001,
		0x03F, 0x000C0001,
		0x0EE, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00040000,
		0x033, 0x00000001,
		0x03F, 0x000C0001,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00040000,
		0x033, 0x00000001,
		0x03F, 0x000C0001,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x030, 0x00000000,
		0x03F, 0x000150F9,
		0x030, 0x00010000,
		0x03F, 0x000150F9,
		0x030, 0x00020000,
		0x03F, 0x000150F9,
		0x030, 0x00030000,
		0x03F, 0x000150F9,
		0x030, 0x00040000,
		0x03F, 0x000150F9,
		0x030, 0x00050000,
		0x03F, 0x000150F9,
		0x030, 0x00060000,
		0x03F, 0x000150F9,
		0x030, 0x00070000,
		0x03F, 0x000150F9,
		0x030, 0x00080000,
		0x03F, 0x000150F9,
		0x030, 0x00090000,
		0x03F, 0x000150F9,
		0x030, 0x000A0000,
		0x03F, 0x000150F9,
		0x030, 0x000B0000,
		0x03F, 0x000150F9,
		0x030, 0x000C0000,
		0x03F, 0x000150F9,
		0x030, 0x000D0000,
		0x03F, 0x000150F9,
		0x030, 0x000E0000,
		0x03F, 0x000150F9,
		0x030, 0x000F0000,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x030, 0x00000000,
		0x03F, 0x000150F9,
		0x030, 0x00010000,
		0x03F, 0x000150F9,
		0x030, 0x00020000,
		0x03F, 0x000150F9,
		0x030, 0x00030000,
		0x03F, 0x000150F9,
		0x030, 0x00040000,
		0x03F, 0x000150F9,
		0x030, 0x00050000,
		0x03F, 0x000150F9,
		0x030, 0x00060000,
		0x03F, 0x000150F9,
		0x030, 0x00070000,
		0x03F, 0x000150F9,
		0x030, 0x00080000,
		0x03F, 0x000150F9,
		0x030, 0x00090000,
		0x03F, 0x000150F9,
		0x030, 0x000A0000,
		0x03F, 0x000150F9,
		0x030, 0x000B0000,
		0x03F, 0x000150F9,
		0x030, 0x000C0000,
		0x03F, 0x000150F9,
		0x030, 0x000D0000,
		0x03F, 0x000150F9,
		0x030, 0x000E0000,
		0x03F, 0x000150F9,
		0x030, 0x000F0000,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x030, 0x00000000,
		0x03F, 0x000150F9,
		0x030, 0x00010000,
		0x03F, 0x000150F9,
		0x030, 0x00020000,
		0x03F, 0x000150F9,
		0x030, 0x00030000,
		0x03F, 0x000150F9,
		0x030, 0x00040000,
		0x03F, 0x000150F9,
		0x030, 0x00050000,
		0x03F, 0x000150F9,
		0x030, 0x00060000,
		0x03F, 0x000150F9,
		0x030, 0x00070000,
		0x03F, 0x000150F9,
		0x030, 0x00080000,
		0x03F, 0x000150F9,
		0x030, 0x00090000,
		0x03F, 0x000150F9,
		0x030, 0x000A0000,
		0x03F, 0x000150F9,
		0x030, 0x000B0000,
		0x03F, 0x000150F9,
		0x030, 0x000C0000,
		0x03F, 0x000150F9,
		0x030, 0x000D0000,
		0x03F, 0x000150F9,
		0x030, 0x000E0000,
		0x03F, 0x000150F9,
		0x030, 0x000F0000,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x030, 0x00000000,
		0x03F, 0x000150F9,
		0x030, 0x00010000,
		0x03F, 0x000150F9,
		0x030, 0x00020000,
		0x03F, 0x000150F9,
		0x030, 0x00030000,
		0x03F, 0x000150F9,
		0x030, 0x00040000,
		0x03F, 0x000150F9,
		0x030, 0x00050000,
		0x03F, 0x000150F9,
		0x030, 0x00060000,
		0x03F, 0x000150F9,
		0x030, 0x00070000,
		0x03F, 0x000150F9,
		0x030, 0x00080000,
		0x03F, 0x000150F9,
		0x030, 0x00090000,
		0x03F, 0x000150F9,
		0x030, 0x000A0000,
		0x03F, 0x000150F9,
		0x030, 0x000B0000,
		0x03F, 0x000150F9,
		0x030, 0x000C0000,
		0x03F, 0x000150F9,
		0x030, 0x000D0000,
		0x03F, 0x000150F9,
		0x030, 0x000E0000,
		0x03F, 0x000150F9,
		0x030, 0x000F0000,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x030, 0x00000000,
		0x03F, 0x000150F9,
		0x030, 0x00010000,
		0x03F, 0x000150F9,
		0x030, 0x00020000,
		0x03F, 0x000150F9,
		0x030, 0x00030000,
		0x03F, 0x000150F9,
		0x030, 0x00040000,
		0x03F, 0x000150F9,
		0x030, 0x00050000,
		0x03F, 0x000150F9,
		0x030, 0x00060000,
		0x03F, 0x000150F9,
		0x030, 0x00070000,
		0x03F, 0x000150F9,
		0x030, 0x00080000,
		0x03F, 0x000150F9,
		0x030, 0x00090000,
		0x03F, 0x000150F9,
		0x030, 0x000A0000,
		0x03F, 0x000150F9,
		0x030, 0x000B0000,
		0x03F, 0x000150F9,
		0x030, 0x000C0000,
		0x03F, 0x000150F9,
		0x030, 0x000D0000,
		0x03F, 0x000150F9,
		0x030, 0x000E0000,
		0x03F, 0x000150F9,
		0x030, 0x000F0000,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000400,
		0x030, 0x00000000,
		0x03F, 0x000150F9,
		0x030, 0x00010000,
		0x03F, 0x000150F9,
		0x030, 0x00020000,
		0x03F, 0x000150F9,
		0x030, 0x00030000,
		0x03F, 0x000150F9,
		0x030, 0x00040000,
		0x03F, 0x000150F9,
		0x030, 0x00050000,
		0x03F, 0x000150F9,
		0x030, 0x00060000,
		0x03F, 0x000150F9,
		0x030, 0x00070000,
		0x03F, 0x000150F9,
		0x030, 0x00080000,
		0x03F, 0x000150F9,
		0x030, 0x00090000,
		0x03F, 0x000150F9,
		0x030, 0x000A0000,
		0x03F, 0x000150F9,
		0x030, 0x000B0000,
		0x03F, 0x000150F9,
		0x030, 0x000C0000,
		0x03F, 0x000150F9,
		0x030, 0x000D0000,
		0x03F, 0x000150F9,
		0x030, 0x000E0000,
		0x03F, 0x000150F9,
		0x030, 0x000F0000,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000001,
		0x03F, 0x000150F9,
		0x033, 0x0000000B,
		0x03F, 0x000150F9,
		0x033, 0x00000023,
		0x03F, 0x000150F9,
		0x033, 0x00000029,
		0x03F, 0x000150F9,
		0x033, 0x0000002A,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000001,
		0x03F, 0x000150F9,
		0x033, 0x0000000B,
		0x03F, 0x000150F9,
		0x033, 0x00000023,
		0x03F, 0x000150F9,
		0x033, 0x00000029,
		0x03F, 0x000150F9,
		0x033, 0x0000002A,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000001,
		0x03F, 0x000150F9,
		0x033, 0x0000000B,
		0x03F, 0x000150F9,
		0x033, 0x00000023,
		0x03F, 0x000150F9,
		0x033, 0x00000029,
		0x03F, 0x000150F9,
		0x033, 0x0000002A,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000001,
		0x03F, 0x000150F9,
		0x033, 0x0000000B,
		0x03F, 0x000150F9,
		0x033, 0x00000023,
		0x03F, 0x000150F9,
		0x033, 0x00000029,
		0x03F, 0x000150F9,
		0x033, 0x0000002A,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000001,
		0x03F, 0x000150F9,
		0x033, 0x0000000B,
		0x03F, 0x000150F9,
		0x033, 0x00000023,
		0x03F, 0x000150F9,
		0x033, 0x00000029,
		0x03F, 0x000150F9,
		0x033, 0x0000002A,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000001,
		0x03F, 0x000150F9,
		0x033, 0x0000000B,
		0x03F, 0x000150F9,
		0x033, 0x00000023,
		0x03F, 0x000150F9,
		0x033, 0x00000029,
		0x03F, 0x000150F9,
		0x033, 0x0000002A,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x000000A4,
		0x030, 0x000010A4,
		0x030, 0x000020A4,
		0x030, 0x000030A4,
		0x030, 0x000040D4,
		0x030, 0x000050D4,
		0x030, 0x000060D4,
		0x030, 0x000070D4,
		0x030, 0x000080B4,
		0x030, 0x000090B4,
		0x030, 0x0000A0B4,
		0x030, 0x0000B0B4,
		0x0EE, 0x00000000,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x000002A4,
		0x030, 0x000012A4,
		0x030, 0x000022A4,
		0x030, 0x000032A4,
		0x030, 0x000042A4,
		0x030, 0x000052A4,
		0x030, 0x000062A4,
		0x030, 0x000072A4,
		0x030, 0x000083B4,
		0x030, 0x000093B4,
		0x030, 0x0000A3B4,
		0x030, 0x0000B3B4,
		0x0EE, 0x00000000,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x000000A4,
		0x030, 0x000010A4,
		0x030, 0x000020A4,
		0x030, 0x000030A4,
		0x030, 0x000040D4,
		0x030, 0x000050D4,
		0x030, 0x000060D4,
		0x030, 0x000070D4,
		0x030, 0x000080B4,
		0x030, 0x000090B4,
		0x030, 0x0000A0B4,
		0x030, 0x0000B0B4,
		0x0EE, 0x00000000,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x000000A4,
		0x030, 0x000010A4,
		0x030, 0x000020A4,
		0x030, 0x000030A4,
		0x030, 0x000040D4,
		0x030, 0x000050D4,
		0x030, 0x000060D4,
		0x030, 0x000070D4,
		0x030, 0x000080B4,
		0x030, 0x000090B4,
		0x030, 0x0000A0B4,
		0x030, 0x0000B0B4,
		0x0EE, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x000000A4,
		0x030, 0x000010A4,
		0x030, 0x000020A4,
		0x030, 0x000030A4,
		0x030, 0x000040D4,
		0x030, 0x000050D4,
		0x030, 0x000060D4,
		0x030, 0x000070D4,
		0x030, 0x000080B4,
		0x030, 0x000090B4,
		0x030, 0x0000A0B4,
		0x030, 0x0000B0B4,
		0x0EE, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x000002A4,
		0x030, 0x000012A4,
		0x030, 0x000022A4,
		0x030, 0x000032A4,
		0x030, 0x000042A4,
		0x030, 0x000052A4,
		0x030, 0x000062A4,
		0x030, 0x000072A4,
		0x030, 0x000083B4,
		0x030, 0x000093B4,
		0x030, 0x0000A3B4,
		0x030, 0x0000B3B4,
		0x0EE, 0x00000000,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x000000A4,
		0x030, 0x000010A4,
		0x030, 0x000020A4,
		0x030, 0x000030A4,
		0x030, 0x000040D4,
		0x030, 0x000050D4,
		0x030, 0x000060D4,
		0x030, 0x000070D4,
		0x030, 0x000080B4,
		0x030, 0x000090B4,
		0x030, 0x0000A0B4,
		0x030, 0x0000B0B4,
		0x0EE, 0x00000000,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x000000A4,
		0x030, 0x000010A4,
		0x030, 0x000020A4,
		0x030, 0x000030A4,
		0x030, 0x000040D4,
		0x030, 0x000050D4,
		0x030, 0x000060D4,
		0x030, 0x000070D4,
		0x030, 0x000080B4,
		0x030, 0x000090B4,
		0x030, 0x0000A0B4,
		0x030, 0x0000B0B4,
		0x0EE, 0x00000000,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x000000A4,
		0x030, 0x000010A4,
		0x030, 0x000020A4,
		0x030, 0x000030A4,
		0x030, 0x000040D4,
		0x030, 0x000050D4,
		0x030, 0x000060D4,
		0x030, 0x000070D4,
		0x030, 0x000080B4,
		0x030, 0x000090B4,
		0x030, 0x0000A0B4,
		0x030, 0x0000B0B4,
		0x0EE, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x000000A4,
		0x030, 0x000010A4,
		0x030, 0x000020A4,
		0x030, 0x000030A4,
		0x030, 0x000040D4,
		0x030, 0x000050D4,
		0x030, 0x000060D4,
		0x030, 0x000070D4,
		0x030, 0x000080B4,
		0x030, 0x000090B4,
		0x030, 0x0000A0B4,
		0x030, 0x0000B0B4,
		0x0EE, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x000002A4,
		0x030, 0x000012A4,
		0x030, 0x000022A4,
		0x030, 0x000032A4,
		0x030, 0x000042A4,
		0x030, 0x000052A4,
		0x030, 0x000062A4,
		0x030, 0x000072A4,
		0x030, 0x000083B4,
		0x030, 0x000093B4,
		0x030, 0x0000A3B4,
		0x030, 0x0000B3B4,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x000002A4,
		0x030, 0x000012A4,
		0x030, 0x000022A4,
		0x030, 0x000032A4,
		0x030, 0x000042A4,
		0x030, 0x000052A4,
		0x030, 0x000062A4,
		0x030, 0x000072A4,
		0x030, 0x000083B4,
		0x030, 0x000093B4,
		0x030, 0x0000A3B4,
		0x030, 0x0000B3B4,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000400,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x0EE, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000400,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x0EE, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000400,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x0EE, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000400,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x0EE, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000400,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000400,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x000000A4,
		0x030, 0x000010A4,
		0x030, 0x000020A4,
		0x030, 0x000030A4,
		0x030, 0x000040A4,
		0x030, 0x000050A4,
		0x030, 0x000060D4,
		0x030, 0x000070D4,
		0x030, 0x000080D4,
		0x030, 0x000090D4,
		0x030, 0x0000A0D4,
		0x030, 0x0000B0D4,
		0x030, 0x0000C0B4,
		0x030, 0x0000D0B4,
		0x030, 0x0000E0B4,
		0x0EE, 0x00000000,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x000002A4,
		0x030, 0x000012A4,
		0x030, 0x000022A4,
		0x030, 0x000032A4,
		0x030, 0x000042A4,
		0x030, 0x000052A4,
		0x030, 0x000062A4,
		0x030, 0x000072A4,
		0x030, 0x000082A4,
		0x030, 0x000092A4,
		0x030, 0x0000A2A4,
		0x030, 0x0000B2A4,
		0x030, 0x0000C3B4,
		0x030, 0x0000D3B4,
		0x030, 0x0000E3B4,
		0x0EE, 0x00000000,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x000000A4,
		0x030, 0x000010A4,
		0x030, 0x000020A4,
		0x030, 0x000030A4,
		0x030, 0x000040A4,
		0x030, 0x000050A4,
		0x030, 0x000060D4,
		0x030, 0x000070D4,
		0x030, 0x000080D4,
		0x030, 0x000090D4,
		0x030, 0x0000A0D4,
		0x030, 0x0000B0D4,
		0x030, 0x0000C0B4,
		0x030, 0x0000D0B4,
		0x030, 0x0000E0B4,
		0x0EE, 0x00000000,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x000000A4,
		0x030, 0x000010A4,
		0x030, 0x000020A4,
		0x030, 0x000030A4,
		0x030, 0x000040A4,
		0x030, 0x000050A4,
		0x030, 0x000060D4,
		0x030, 0x000070D4,
		0x030, 0x000080D4,
		0x030, 0x000090D4,
		0x030, 0x0000A0D4,
		0x030, 0x0000B0D4,
		0x030, 0x0000C0B4,
		0x030, 0x0000D0B4,
		0x030, 0x0000E0B4,
		0x0EE, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x000000A4,
		0x030, 0x000010A4,
		0x030, 0x000020A4,
		0x030, 0x000030A4,
		0x030, 0x000040A4,
		0x030, 0x000050A4,
		0x030, 0x000060D4,
		0x030, 0x000070D4,
		0x030, 0x000080D4,
		0x030, 0x000090D4,
		0x030, 0x0000A0D4,
		0x030, 0x0000B0D4,
		0x030, 0x0000C0B4,
		0x030, 0x0000D0B4,
		0x030, 0x0000E0B4,
		0x0EE, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x000002A4,
		0x030, 0x000012A4,
		0x030, 0x000022A4,
		0x030, 0x000032A4,
		0x030, 0x000042A4,
		0x030, 0x000052A4,
		0x030, 0x000062A4,
		0x030, 0x000072A4,
		0x030, 0x000082A4,
		0x030, 0x000092A4,
		0x030, 0x0000A2A4,
		0x030, 0x0000B2A4,
		0x030, 0x0000C3B4,
		0x030, 0x0000D3B4,
		0x030, 0x0000E3B4,
		0x0EE, 0x00000000,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x000000A4,
		0x030, 0x000010A4,
		0x030, 0x000020A4,
		0x030, 0x000030A4,
		0x030, 0x000040A4,
		0x030, 0x000050A4,
		0x030, 0x000060D4,
		0x030, 0x000070D4,
		0x030, 0x000080D4,
		0x030, 0x000090D4,
		0x030, 0x0000A0D4,
		0x030, 0x0000B0D4,
		0x030, 0x0000C0B4,
		0x030, 0x0000D0B4,
		0x030, 0x0000E0B4,
		0x0EE, 0x00000000,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x000000A4,
		0x030, 0x000010A4,
		0x030, 0x000020A4,
		0x030, 0x000030A4,
		0x030, 0x000040A4,
		0x030, 0x000050A4,
		0x030, 0x000060D4,
		0x030, 0x000070D4,
		0x030, 0x000080D4,
		0x030, 0x000090D4,
		0x030, 0x0000A0D4,
		0x030, 0x0000B0D4,
		0x030, 0x0000C0B4,
		0x030, 0x0000D0B4,
		0x030, 0x0000E0B4,
		0x0EE, 0x00000000,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x000000A4,
		0x030, 0x000010A4,
		0x030, 0x000020A4,
		0x030, 0x000030A4,
		0x030, 0x000040A4,
		0x030, 0x000050A4,
		0x030, 0x000060D4,
		0x030, 0x000070D4,
		0x030, 0x000080D4,
		0x030, 0x000090D4,
		0x030, 0x0000A0D4,
		0x030, 0x0000B0D4,
		0x030, 0x0000C0B4,
		0x030, 0x0000D0B4,
		0x030, 0x0000E0B4,
		0x0EE, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x000000A4,
		0x030, 0x000010A4,
		0x030, 0x000020A4,
		0x030, 0x000030A4,
		0x030, 0x000040A4,
		0x030, 0x000050A4,
		0x030, 0x000060D4,
		0x030, 0x000070D4,
		0x030, 0x000080D4,
		0x030, 0x000090D4,
		0x030, 0x0000A0D4,
		0x030, 0x0000B0D4,
		0x030, 0x0000C0B4,
		0x030, 0x0000D0B4,
		0x030, 0x0000E0B4,
		0x0EE, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x000002A4,
		0x030, 0x000012A4,
		0x030, 0x000022A4,
		0x030, 0x000032A4,
		0x030, 0x000042A4,
		0x030, 0x000052A4,
		0x030, 0x000062A4,
		0x030, 0x000072A4,
		0x030, 0x000082A4,
		0x030, 0x000092A4,
		0x030, 0x0000A2A4,
		0x030, 0x0000B2A4,
		0x030, 0x0000C3B4,
		0x030, 0x0000D3B4,
		0x030, 0x0000E3B4,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x000002A4,
		0x030, 0x000012A4,
		0x030, 0x000022A4,
		0x030, 0x000032A4,
		0x030, 0x000042A4,
		0x030, 0x000052A4,
		0x030, 0x000062A4,
		0x030, 0x000072A4,
		0x030, 0x000082A4,
		0x030, 0x000092A4,
		0x030, 0x0000A2A4,
		0x030, 0x0000B2A4,
		0x030, 0x0000C3B4,
		0x030, 0x0000D3B4,
		0x030, 0x0000E3B4,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000800,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x030, 0x0000C0B8,
		0x030, 0x0000D0B8,
		0x030, 0x0000E0B8,
		0x0EE, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000800,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x030, 0x0000C0B8,
		0x030, 0x0000D0B8,
		0x030, 0x0000E0B8,
		0x0EE, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000800,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x030, 0x0000C0B8,
		0x030, 0x0000D0B8,
		0x030, 0x0000E0B8,
		0x0EE, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000800,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x030, 0x0000C0B8,
		0x030, 0x0000D0B8,
		0x030, 0x0000E0B8,
		0x0EE, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000800,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x030, 0x0000C0B8,
		0x030, 0x0000D0B8,
		0x030, 0x0000E0B8,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000800,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x030, 0x0000C0B8,
		0x030, 0x0000D0B8,
		0x030, 0x0000E0B8,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00001000,
		0x030, 0x00000CDA,
		0x030, 0x00001776,
		0x030, 0x00002462,
		0x030, 0x00003462,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x030, 0x0000700F,
		0x0EE, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00001000,
		0x030, 0x00000CDA,
		0x030, 0x00001776,
		0x030, 0x00002462,
		0x030, 0x00003462,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x030, 0x0000700F,
		0x0EE, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00001000,
		0x030, 0x00000CDA,
		0x030, 0x00001776,
		0x030, 0x00002462,
		0x030, 0x00003462,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x030, 0x0000700F,
		0x0EE, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00001000,
		0x030, 0x00000CDA,
		0x030, 0x00001776,
		0x030, 0x00002462,
		0x030, 0x00003462,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x030, 0x0000700F,
		0x0EE, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00001000,
		0x030, 0x00000CDA,
		0x030, 0x00001776,
		0x030, 0x00002462,
		0x030, 0x00003462,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x030, 0x0000700F,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00001000,
		0x030, 0x00000CDA,
		0x030, 0x00001776,
		0x030, 0x00002462,
		0x030, 0x00003462,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x030, 0x0000700F,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x0004026A,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x0004026A,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x0004026A,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x0004026A,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x0004026A,
	0xA0000000,	0x00000000,
		0x063, 0x0004026A,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000D8DEF,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x00008DF7,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000D8DEF,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000D8DEF,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000D8DEF,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x00008DF7,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000D8DEF,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000D8DEF,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000D8DEF,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000D8DEF,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x00008DF7,
	0xA0000000,	0x00000000,
		0x08A, 0x00008DF7,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A6560,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A6560,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A6560,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A6560,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A6560,
	0xA0000000,	0x00000000,
		0x08E, 0x000A6560,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00020000,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000006,
		0x03E, 0x00008802,
		0x03F, 0x00007903,
		0x033, 0x00000005,
		0x03E, 0x00008805,
		0x03F, 0x00027903,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00027903,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00017903,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000000,
		0x03E, 0x00008922,
		0x03F, 0x00007903,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x00000006,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x00000005,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000000,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000006,
		0x03E, 0x00008802,
		0x03F, 0x00017903,
		0x033, 0x00000005,
		0x03E, 0x00008806,
		0x03F, 0x00017903,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00067903,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00027903,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00017903,
		0x033, 0x00000000,
		0x03E, 0x00008921,
		0x03F, 0x00047903,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000006,
		0x03E, 0x00008802,
		0x03F, 0x00007903,
		0x033, 0x00000005,
		0x03E, 0x00008805,
		0x03F, 0x00007903,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000003,
		0x03E, 0x00008826,
		0x03F, 0x00027903,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000000,
		0x03E, 0x00008922,
		0x03F, 0x00027903,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000006,
		0x03E, 0x00008802,
		0x03F, 0x00007903,
		0x033, 0x00000005,
		0x03E, 0x00008805,
		0x03F, 0x00027903,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00027903,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00017903,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000000,
		0x03E, 0x00008922,
		0x03F, 0x00007903,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x00000006,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x00000005,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000000,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000006,
		0x03E, 0x00008801,
		0x03F, 0x00017903,
		0x033, 0x00000005,
		0x03E, 0x00008805,
		0x03F, 0x00007903,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000003,
		0x03E, 0x00008826,
		0x03F, 0x00027903,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000000,
		0x03E, 0x00008922,
		0x03F, 0x00027903,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000006,
		0x03E, 0x00008802,
		0x03F, 0x00017903,
		0x033, 0x00000005,
		0x03E, 0x00008806,
		0x03F, 0x00017903,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00067903,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00027903,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00017903,
		0x033, 0x00000000,
		0x03E, 0x00008921,
		0x03F, 0x00047903,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000006,
		0x03E, 0x00008802,
		0x03F, 0x00007903,
		0x033, 0x00000005,
		0x03E, 0x00008805,
		0x03F, 0x00007903,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000003,
		0x03E, 0x00008826,
		0x03F, 0x00027903,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000000,
		0x03E, 0x00008922,
		0x03F, 0x00027903,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000006,
		0x03E, 0x00008802,
		0x03F, 0x00007903,
		0x033, 0x00000005,
		0x03E, 0x00008805,
		0x03F, 0x00027903,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00027903,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00017903,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000000,
		0x03E, 0x00008922,
		0x03F, 0x00007903,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x00000006,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x00000005,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000000,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
	0xA0000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x00000006,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x00000005,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000000,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x0000000E,
		0x03E, 0x00008801,
		0x03F, 0x00017903,
		0x033, 0x0000000D,
		0x03E, 0x00008806,
		0x03F, 0x00007903,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00027903,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000008,
		0x03E, 0x00008922,
		0x03F, 0x00027903,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x0000000E,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x0000000D,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000008,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x0000000E,
		0x03E, 0x00008802,
		0x03F, 0x00007903,
		0x033, 0x0000000D,
		0x03E, 0x00008806,
		0x03F, 0x00007903,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00077903,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000008,
		0x03E, 0x00008922,
		0x03F, 0x00017903,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x0000000E,
		0x03E, 0x00008801,
		0x03F, 0x00007903,
		0x033, 0x0000000D,
		0x03E, 0x00008804,
		0x03F, 0x00027903,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00037903,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00017903,
		0x033, 0x00000008,
		0x03E, 0x00008922,
		0x03F, 0x00047903,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x0000000E,
		0x03E, 0x00008801,
		0x03F, 0x00017903,
		0x033, 0x0000000D,
		0x03E, 0x00008806,
		0x03F, 0x00007903,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00027903,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000008,
		0x03E, 0x00008922,
		0x03F, 0x00027903,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x0000000E,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x0000000D,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000008,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x0000000E,
		0x03E, 0x00008800,
		0x03F, 0x00017903,
		0x033, 0x0000000D,
		0x03E, 0x00008804,
		0x03F, 0x00007903,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00017903,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000008,
		0x03E, 0x00008922,
		0x03F, 0x00047903,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x0000000E,
		0x03E, 0x00008802,
		0x03F, 0x00007903,
		0x033, 0x0000000D,
		0x03E, 0x00008806,
		0x03F, 0x00007903,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00077903,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000008,
		0x03E, 0x00008922,
		0x03F, 0x00017903,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x0000000E,
		0x03E, 0x00008801,
		0x03F, 0x00007903,
		0x033, 0x0000000D,
		0x03E, 0x00008804,
		0x03F, 0x00027903,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00037903,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00017903,
		0x033, 0x00000008,
		0x03E, 0x00008922,
		0x03F, 0x00047903,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x0000000E,
		0x03E, 0x00008801,
		0x03F, 0x00017903,
		0x033, 0x0000000D,
		0x03E, 0x00008806,
		0x03F, 0x00007903,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00027903,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000008,
		0x03E, 0x00008922,
		0x03F, 0x00027903,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x0000000E,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x0000000D,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000008,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
	0xA0000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x0000000E,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x0000000D,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000008,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000016,
		0x03E, 0x00008800,
		0x03F, 0x00027903,
		0x033, 0x00000015,
		0x03E, 0x00008803,
		0x03F, 0x00007903,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00007903,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00017903,
		0x033, 0x00000010,
		0x03E, 0x00008922,
		0x03F, 0x00017903,
		0x0EF, 0x00000000,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x00000016,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x00000015,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000010,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
		0x0EF, 0x00000000,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000016,
		0x03E, 0x00008801,
		0x03F, 0x00017903,
		0x033, 0x00000015,
		0x03E, 0x00008804,
		0x03F, 0x00007903,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00057903,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00027903,
		0x033, 0x00000010,
		0x03E, 0x00008922,
		0x03F, 0x00027903,
		0x0EF, 0x00000000,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000016,
		0x03E, 0x00008801,
		0x03F, 0x00007903,
		0x033, 0x00000015,
		0x03E, 0x00008802,
		0x03F, 0x00007903,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00017903,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000010,
		0x03E, 0x00008921,
		0x03F, 0x00017903,
		0x0EF, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000016,
		0x03E, 0x00008800,
		0x03F, 0x00027903,
		0x033, 0x00000015,
		0x03E, 0x00008803,
		0x03F, 0x00007903,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00007903,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00017903,
		0x033, 0x00000010,
		0x03E, 0x00008922,
		0x03F, 0x00017903,
		0x0EF, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x00000016,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x00000015,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000010,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
		0x0EF, 0x00000000,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000016,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000015,
		0x03E, 0x00008802,
		0x03F, 0x00007903,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00007903,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000010,
		0x03E, 0x000088C2,
		0x03F, 0x00027903,
		0x0EF, 0x00000000,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000016,
		0x03E, 0x00008801,
		0x03F, 0x00017903,
		0x033, 0x00000015,
		0x03E, 0x00008804,
		0x03F, 0x00007903,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00057903,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00027903,
		0x033, 0x00000010,
		0x03E, 0x00008922,
		0x03F, 0x00027903,
		0x0EF, 0x00000000,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000016,
		0x03E, 0x00008801,
		0x03F, 0x00007903,
		0x033, 0x00000015,
		0x03E, 0x00008802,
		0x03F, 0x00007903,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00017903,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000010,
		0x03E, 0x00008921,
		0x03F, 0x00017903,
		0x0EF, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000016,
		0x03E, 0x00008800,
		0x03F, 0x00027903,
		0x033, 0x00000015,
		0x03E, 0x00008803,
		0x03F, 0x00007903,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00007903,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00017903,
		0x033, 0x00000010,
		0x03E, 0x00008922,
		0x03F, 0x00017903,
		0x0EF, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x00000016,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x00000015,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000010,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x00000016,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x00000015,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000010,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x0000000D,
		0x033, 0x00000001,
		0x03F, 0x00000004,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x0000000D,
		0x033, 0x00000001,
		0x03F, 0x00000004,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x0000000D,
		0x033, 0x00000001,
		0x03F, 0x00000004,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x0000000D,
		0x033, 0x00000001,
		0x03F, 0x00000004,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x0000000D,
		0x033, 0x00000001,
		0x03F, 0x00000004,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x0000000D,
		0x033, 0x00000001,
		0x03F, 0x00000004,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x00000000,
		0x03F, 0x000C0000,
		0x033, 0x00000001,
		0x03F, 0x000C0000,
		0x0EF, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x00000000,
		0x03F, 0x000C0000,
		0x033, 0x00000001,
		0x03F, 0x000C0000,
		0x0EF, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x00000000,
		0x03F, 0x000C0000,
		0x033, 0x00000001,
		0x03F, 0x000C0000,
		0x0EF, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x00000000,
		0x03F, 0x000C0000,
		0x033, 0x00000001,
		0x03F, 0x000C0000,
		0x0EF, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x00000000,
		0x03F, 0x000C0000,
		0x033, 0x00000001,
		0x03F, 0x000C0000,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x00000000,
		0x03F, 0x000C0000,
		0x033, 0x00000001,
		0x03F, 0x000C0000,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0xA0000000,	0x00000000,
		0x018, 0x00013124,
	0xB0000000,	0x00000000,
		0x0FE, 0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x01B, 0x00000240,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x01B, 0x00000240,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x01B, 0x00000240,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x01B, 0x00000240,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x01B, 0x00000240,
	0xA0000000,	0x00000000,
		0x01B, 0x00000240,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000002,
		0x033, 0x00000010,
		0x03F, 0x00000861,
		0x033, 0x00000011,
		0x03F, 0x00000AAA,
		0x033, 0x00000012,
		0x03F, 0x00000BEF,
		0x033, 0x00000013,
		0x03F, 0x00000D34,
		0x0EE, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000002,
		0x033, 0x00000010,
		0x03F, 0x00000861,
		0x033, 0x00000011,
		0x03F, 0x00000AAA,
		0x033, 0x00000012,
		0x03F, 0x00000BEF,
		0x033, 0x00000013,
		0x03F, 0x00000D34,
		0x0EE, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000002,
		0x033, 0x00000010,
		0x03F, 0x00000861,
		0x033, 0x00000011,
		0x03F, 0x00000AAA,
		0x033, 0x00000012,
		0x03F, 0x00000BEF,
		0x033, 0x00000013,
		0x03F, 0x00000D34,
		0x0EE, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000002,
		0x033, 0x00000010,
		0x03F, 0x00000861,
		0x033, 0x00000011,
		0x03F, 0x00000AAA,
		0x033, 0x00000012,
		0x03F, 0x00000BEF,
		0x033, 0x00000013,
		0x03F, 0x00000D34,
		0x0EE, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000002,
		0x033, 0x00000010,
		0x03F, 0x00000861,
		0x033, 0x00000011,
		0x03F, 0x00000AAA,
		0x033, 0x00000012,
		0x03F, 0x00000BEF,
		0x033, 0x00000013,
		0x03F, 0x00000D34,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000002,
		0x033, 0x00000010,
		0x03F, 0x00000861,
		0x033, 0x00000011,
		0x03F, 0x00000AAA,
		0x033, 0x00000012,
		0x03F, 0x00000BEF,
		0x033, 0x00000013,
		0x03F, 0x00000D34,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0DE, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0DE, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0DE, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0DE, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0DE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0DE, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x057, 0x0004B5AA,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x057, 0x0004B5AA,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x057, 0x0004B5AA,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x057, 0x0004B5AA,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x057, 0x0004B5AA,
	0xA0000000,	0x00000000,
		0x057, 0x0004B5AA,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000010,
		0x008, 0x00078200,
		0x0EF, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000010,
		0x008, 0x00078200,
		0x0EF, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000010,
		0x008, 0x00078200,
		0x0EF, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000010,
		0x008, 0x00078200,
		0x0EF, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000010,
		0x008, 0x00078200,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000010,
		0x008, 0x00078200,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x05B, 0x000E801E,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x05B, 0x000E801E,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x05B, 0x000E801E,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x05B, 0x000E801E,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x05B, 0x000E801E,
	0xA0000000,	0x00000000,
		0x05B, 0x000E801E,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x018, 0x00000C03,
		0x08F, 0x00000AAC,
		0x069, 0x0000003F,
		0x067, 0x00084200,
		0x067, 0x00084201,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x018, 0x00000C03,
		0x08F, 0x00000AAC,
		0x069, 0x0000003F,
		0x067, 0x00084200,
		0x067, 0x00084201,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x018, 0x00000C03,
		0x08F, 0x00000AAC,
		0x069, 0x0000003F,
		0x067, 0x00084200,
		0x067, 0x00084201,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x018, 0x00000C03,
		0x08F, 0x00000AAC,
		0x069, 0x0000003F,
		0x067, 0x00084200,
		0x067, 0x00084201,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x018, 0x00000C03,
		0x08F, 0x00000AAC,
		0x069, 0x0000003F,
		0x067, 0x00084200,
		0x067, 0x00084201,
	0xA0000000,	0x00000000,
		0x000, 0x00030000,
		0x018, 0x00000C03,
		0x08F, 0x00000AAC,
		0x069, 0x0000003F,
		0x067, 0x00084200,
		0x067, 0x00084201,
	0xB0000000,	0x00000000,
		0xFFE, 0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x00084200,
		0x0DF, 0x00002000,
		0x082, 0x00003364,
		0x068, 0x00084210,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x00084200,
		0x0DF, 0x00002000,
		0x082, 0x00003364,
		0x068, 0x00084210,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x00084200,
		0x0DF, 0x00002000,
		0x082, 0x00003364,
		0x068, 0x00084210,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x00084200,
		0x0DF, 0x00002000,
		0x082, 0x00003364,
		0x068, 0x00084210,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x00084200,
		0x0DF, 0x00002000,
		0x082, 0x00003364,
		0x068, 0x00084210,
	0xA0000000,	0x00000000,
		0x067, 0x00084200,
		0x0DF, 0x00002000,
		0x082, 0x00003364,
		0x068, 0x00084210,
	0xB0000000,	0x00000000,
		0xFFE, 0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x082, 0x00003354,
		0x068, 0x00084210,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x082, 0x00003354,
		0x068, 0x00084210,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x082, 0x00003354,
		0x068, 0x00084210,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x082, 0x00003354,
		0x068, 0x00084210,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x082, 0x00003354,
		0x068, 0x00084210,
	0xA0000000,	0x00000000,
		0x068, 0x00084200,
		0x082, 0x00003354,
		0x068, 0x00084210,
	0xB0000000,	0x00000000,
		0xFFE, 0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x0DF, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x0DF, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x0DF, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x0DF, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x0DF, 0x00000000,
	0xA0000000,	0x00000000,
		0x068, 0x00084200,
		0x0DF, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x06F, 0x00014311,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x06F, 0x00014311,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x06F, 0x00014311,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x06F, 0x00014311,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x06F, 0x00014311,
	0xA0000000,	0x00000000,
		0x06F, 0x00014311,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x06E, 0x00000291,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x06E, 0x00000291,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x06E, 0x00000291,
	0x92000000,	0x00000000,	0x40000000,	0x00000000,
		0x06E, 0x00000311,
	0x92000003,	0x00000000,	0x40000000,	0x00000000,
		0x06E, 0x00000311,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x06E, 0x00000291,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x06E, 0x00000291,
	0xA0000000,	0x00000000,
		0x06E, 0x00000291,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0xFFFF, 0x0000FFFF,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0xFFFF, 0x0000FFFF,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0xFFFF, 0x0000FFFF,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0xFFFF, 0x0000FFFF,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0xFFFF, 0x0000FFFF,
	0xA0000000,	0x00000000,
		0xFFFF, 0x0000FFFF,
	0xB0000000,	0x00000000,

};

void
odm_read_and_config_mp_8814b_radioa(struct dm_struct *dm)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len =
			sizeof(array_mp_8814b_radioa) / sizeof(u32);
	u32	*array = (u32 *)array_mp_8814b_radioa;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;
	u32	a1 = 0, a2 = 0, a3 = 0, a4 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  =
					(u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT,
						  "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (!is_skipped) {
					a1 = pre_v1; a2 = pre_v2;
					a3 = v1; a4 = v2;
					if (check_positive(dm,
							   a1, a2, a3, a4)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else {
					is_matched = false;
				}
			}
		} else {
			if (is_matched)
				odm_config_rf_radio_a_8814b(dm, v1, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8814b_radioa(void)
{
		return 46;
}

/******************************************************************************
 *                           radiob.TXT
 ******************************************************************************/

const u32 array_mp_8814b_radiob[] = {
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x0008D9C0,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x0007A000,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x0008D9C0,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x0008D9C0,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x0008D9C0,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x0007A000,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x0008D9C0,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x0008D9C0,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x0008D9C0,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x0008D9C0,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x0007A000,
	0xA0000000,	0x00000000,
		0x058, 0x0007A000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x0DD, 0x00000010,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x0DD, 0x00000010,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x0DD, 0x00000010,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x0DD, 0x00000010,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x0DD, 0x00000010,
	0xA0000000,	0x00000000,
		0x000, 0x00030000,
		0x0DD, 0x00000010,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000001,
		0x03E, 0x00000244,
		0x03F, 0x000000F7,
		0x033, 0x00000002,
		0x03E, 0x000003FC,
		0x03F, 0x000000F7,
		0x033, 0x00000003,
		0x03E, 0x00000245,
		0x03F, 0x000AFCF7,
		0x033, 0x00000004,
		0x03E, 0x000003F6,
		0x03F, 0x0000F9F7,
		0x033, 0x00000007,
		0x03E, 0x000003FD,
		0x03F, 0x000EFCF7,
		0x0EF, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000001,
		0x03E, 0x00000244,
		0x03F, 0x000000F7,
		0x033, 0x00000002,
		0x03E, 0x000003FC,
		0x03F, 0x000000F7,
		0x033, 0x00000003,
		0x03E, 0x00000245,
		0x03F, 0x000AFCF7,
		0x033, 0x00000004,
		0x03E, 0x000003F6,
		0x03F, 0x0000F9F7,
		0x033, 0x00000007,
		0x03E, 0x000003FD,
		0x03F, 0x000EFCF7,
		0x0EF, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000001,
		0x03E, 0x00000244,
		0x03F, 0x000000F7,
		0x033, 0x00000002,
		0x03E, 0x000003FC,
		0x03F, 0x000000F7,
		0x033, 0x00000003,
		0x03E, 0x00000245,
		0x03F, 0x000AFCF7,
		0x033, 0x00000004,
		0x03E, 0x000003F6,
		0x03F, 0x0000F9F7,
		0x033, 0x00000007,
		0x03E, 0x000003FD,
		0x03F, 0x000EFCF7,
		0x0EF, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000001,
		0x03E, 0x00000244,
		0x03F, 0x000000F7,
		0x033, 0x00000002,
		0x03E, 0x000003FC,
		0x03F, 0x000000F7,
		0x033, 0x00000003,
		0x03E, 0x00000245,
		0x03F, 0x000AFCF7,
		0x033, 0x00000004,
		0x03E, 0x000003F6,
		0x03F, 0x0000F9F7,
		0x033, 0x00000007,
		0x03E, 0x000003FD,
		0x03F, 0x000EFCF7,
		0x0EF, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000001,
		0x03E, 0x00000244,
		0x03F, 0x000000F7,
		0x033, 0x00000002,
		0x03E, 0x000003FC,
		0x03F, 0x000000F7,
		0x033, 0x00000003,
		0x03E, 0x00000245,
		0x03F, 0x000AFCF7,
		0x033, 0x00000004,
		0x03E, 0x000003F6,
		0x03F, 0x0000F9F7,
		0x033, 0x00000007,
		0x03E, 0x000003FD,
		0x03F, 0x000EFCF7,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000001,
		0x03E, 0x00000244,
		0x03F, 0x000000F7,
		0x033, 0x00000002,
		0x03E, 0x000003FC,
		0x03F, 0x000000F7,
		0x033, 0x00000003,
		0x03E, 0x00000245,
		0x03F, 0x000AFCF7,
		0x033, 0x00000004,
		0x03E, 0x000003F6,
		0x03F, 0x0000F9F7,
		0x033, 0x00000007,
		0x03E, 0x000003FD,
		0x03F, 0x000EFCF7,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x09E, 0x000F8009,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x09E, 0x000F8009,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x09E, 0x000F8009,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x09E, 0x000F8009,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x09E, 0x000F8009,
	0xA0000000,	0x00000000,
		0x09E, 0x000F8009,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0xA0000000,	0x00000000,
		0x018, 0x00013124,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00000006,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00000006,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00000006,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00000006,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00000006,
	0xA0000000,	0x00000000,
		0x018, 0x00000006,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x0005512D,
		0x080, 0x000CE800,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x0005516D,
		0x080, 0x000CE800,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x0005512D,
		0x080, 0x000CE800,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x0005516D,
		0x080, 0x000CE800,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x0005512D,
		0x080, 0x000CE800,
	0xA0000000,	0x00000000,
		0x087, 0x0005512D,
		0x080, 0x000CE800,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x082, 0x00003300,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x082, 0x00003300,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x082, 0x00003300,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x082, 0x00003300,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x082, 0x00003300,
	0xA0000000,	0x00000000,
		0x082, 0x00003300,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0C0, 0x0007FC00,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0C0, 0x0007FC00,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0C0, 0x0007FC00,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0C0, 0x0007FC00,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0C0, 0x0007FC00,
	0xA0000000,	0x00000000,
		0x0C0, 0x0007FC00,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x01A, 0x00040004,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x01A, 0x00040004,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x01A, 0x00040004,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x01A, 0x00040004,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x01A, 0x00040004,
	0xA0000000,	0x00000000,
		0x01A, 0x00040004,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0000D3A5,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0000D3A5,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0000D3A5,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0000D3A5,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0000D3A5,
	0xA0000000,	0x00000000,
		0x061, 0x0000D3A5,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00010000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00010000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00010000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00010000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00010000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00010000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000F04,
		0x033, 0x00000021,
		0x03F, 0x00000F64,
		0x033, 0x00000022,
		0x03F, 0x00002E04,
		0x033, 0x00000023,
		0x03F, 0x00004E85,
		0x033, 0x00000024,
		0x03F, 0x00004E88,
		0x033, 0x00000025,
		0x03F, 0x00006F05,
		0x033, 0x00000026,
		0x03F, 0x00006FE7,
		0x033, 0x00000027,
		0x03F, 0x00006FEA,
		0x033, 0x00000028,
		0x03F, 0x00006FED,
		0x033, 0x00000029,
		0x03F, 0x00006FF0,
		0x033, 0x0000002A,
		0x03F, 0x00006FF3,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000289,
		0x033, 0x00000021,
		0x03F, 0x000002C9,
		0x033, 0x00000022,
		0x03F, 0x0000030A,
		0x033, 0x00000023,
		0x03F, 0x0000050A,
		0x033, 0x00000024,
		0x03F, 0x0000072A,
		0x033, 0x00000025,
		0x03F, 0x00000B2B,
		0x033, 0x00000026,
		0x03F, 0x00000F8B,
		0x033, 0x00000027,
		0x03F, 0x000026EB,
		0x033, 0x00000028,
		0x03F, 0x00000F33,
		0x033, 0x00000029,
		0x03F, 0x00000F94,
		0x033, 0x0000002A,
		0x03F, 0x00000FB8,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000F04,
		0x033, 0x00000021,
		0x03F, 0x00000F64,
		0x033, 0x00000022,
		0x03F, 0x00002E04,
		0x033, 0x00000023,
		0x03F, 0x00004E85,
		0x033, 0x00000024,
		0x03F, 0x00004E88,
		0x033, 0x00000025,
		0x03F, 0x00006F05,
		0x033, 0x00000026,
		0x03F, 0x00006FE7,
		0x033, 0x00000027,
		0x03F, 0x00006FEA,
		0x033, 0x00000028,
		0x03F, 0x00006FED,
		0x033, 0x00000029,
		0x03F, 0x00006FF0,
		0x033, 0x0000002A,
		0x03F, 0x00006FF3,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000289,
		0x033, 0x00000021,
		0x03F, 0x000002C9,
		0x033, 0x00000022,
		0x03F, 0x0000030A,
		0x033, 0x00000023,
		0x03F, 0x0000050A,
		0x033, 0x00000024,
		0x03F, 0x0000072A,
		0x033, 0x00000025,
		0x03F, 0x00000B2B,
		0x033, 0x00000026,
		0x03F, 0x00000F8B,
		0x033, 0x00000027,
		0x03F, 0x000026EB,
		0x033, 0x00000028,
		0x03F, 0x00000F33,
		0x033, 0x00000029,
		0x03F, 0x00000F94,
		0x033, 0x0000002A,
		0x03F, 0x00000FB8,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000F04,
		0x033, 0x00000021,
		0x03F, 0x00000F64,
		0x033, 0x00000022,
		0x03F, 0x00002E04,
		0x033, 0x00000023,
		0x03F, 0x00004E85,
		0x033, 0x00000024,
		0x03F, 0x00004E88,
		0x033, 0x00000025,
		0x03F, 0x00006F05,
		0x033, 0x00000026,
		0x03F, 0x00006FE7,
		0x033, 0x00000027,
		0x03F, 0x00006FEA,
		0x033, 0x00000028,
		0x03F, 0x00006FED,
		0x033, 0x00000029,
		0x03F, 0x00006FF0,
		0x033, 0x0000002A,
		0x03F, 0x00006FF3,
	0xA0000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000F04,
		0x033, 0x00000021,
		0x03F, 0x00000F64,
		0x033, 0x00000022,
		0x03F, 0x00002E04,
		0x033, 0x00000023,
		0x03F, 0x00004E85,
		0x033, 0x00000024,
		0x03F, 0x00004E88,
		0x033, 0x00000025,
		0x03F, 0x00006F05,
		0x033, 0x00000026,
		0x03F, 0x00006FE7,
		0x033, 0x00000027,
		0x03F, 0x00006FEA,
		0x033, 0x00000028,
		0x03F, 0x00006FED,
		0x033, 0x00000029,
		0x03F, 0x00006FF0,
		0x033, 0x0000002A,
		0x03F, 0x00006FF3,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000F04,
		0x033, 0x00000061,
		0x03F, 0x00000F64,
		0x033, 0x00000062,
		0x03F, 0x00002E04,
		0x033, 0x00000063,
		0x03F, 0x00004E85,
		0x033, 0x00000064,
		0x03F, 0x00004E88,
		0x033, 0x00000065,
		0x03F, 0x00006F05,
		0x033, 0x00000066,
		0x03F, 0x00006FE7,
		0x033, 0x00000067,
		0x03F, 0x00006FEA,
		0x033, 0x00000068,
		0x03F, 0x00006FED,
		0x033, 0x00000069,
		0x03F, 0x00006FF0,
		0x033, 0x0000006A,
		0x03F, 0x00006FF3,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000048,
		0x033, 0x00000061,
		0x03F, 0x0000004B,
		0x033, 0x00000062,
		0x03F, 0x000000C6,
		0x033, 0x00000063,
		0x03F, 0x00000107,
		0x033, 0x00000064,
		0x03F, 0x0000010A,
		0x033, 0x00000065,
		0x03F, 0x00002007,
		0x033, 0x00000066,
		0x03F, 0x00000349,
		0x033, 0x00000067,
		0x03F, 0x000003C9,
		0x033, 0x00000068,
		0x03F, 0x000005E9,
		0x033, 0x00000069,
		0x03F, 0x0000260A,
		0x033, 0x0000006A,
		0x03F, 0x0000260D,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000E64,
		0x033, 0x00000061,
		0x03F, 0x00000E85,
		0x033, 0x00000062,
		0x03F, 0x00000EE4,
		0x033, 0x00000063,
		0x03F, 0x00000EE7,
		0x033, 0x00000064,
		0x03F, 0x00000EEA,
		0x033, 0x00000065,
		0x03F, 0x00004E65,
		0x033, 0x00000066,
		0x03F, 0x00002EA7,
		0x033, 0x00000067,
		0x03F, 0x00002EAA,
		0x033, 0x00000068,
		0x03F, 0x00002EAD,
		0x033, 0x00000069,
		0x03F, 0x00002EB0,
		0x033, 0x0000006A,
		0x03F, 0x00002EB3,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000048,
		0x033, 0x00000061,
		0x03F, 0x0000004B,
		0x033, 0x00000062,
		0x03F, 0x000000C6,
		0x033, 0x00000063,
		0x03F, 0x00000107,
		0x033, 0x00000064,
		0x03F, 0x0000010A,
		0x033, 0x00000065,
		0x03F, 0x00002007,
		0x033, 0x00000066,
		0x03F, 0x00000349,
		0x033, 0x00000067,
		0x03F, 0x000003C9,
		0x033, 0x00000068,
		0x03F, 0x000005E9,
		0x033, 0x00000069,
		0x03F, 0x0000260A,
		0x033, 0x0000006A,
		0x03F, 0x0000260D,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000E64,
		0x033, 0x00000061,
		0x03F, 0x00000E85,
		0x033, 0x00000062,
		0x03F, 0x00000EE4,
		0x033, 0x00000063,
		0x03F, 0x00000EE7,
		0x033, 0x00000064,
		0x03F, 0x00000EEA,
		0x033, 0x00000065,
		0x03F, 0x00004E65,
		0x033, 0x00000066,
		0x03F, 0x00002EA7,
		0x033, 0x00000067,
		0x03F, 0x00002EAA,
		0x033, 0x00000068,
		0x03F, 0x00002EAD,
		0x033, 0x00000069,
		0x03F, 0x00002EB0,
		0x033, 0x0000006A,
		0x03F, 0x00002EB3,
	0xA0000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000E64,
		0x033, 0x00000061,
		0x03F, 0x00000E85,
		0x033, 0x00000062,
		0x03F, 0x00000EE4,
		0x033, 0x00000063,
		0x03F, 0x00000EE7,
		0x033, 0x00000064,
		0x03F, 0x00000EEA,
		0x033, 0x00000065,
		0x03F, 0x00004E65,
		0x033, 0x00000066,
		0x03F, 0x00002EA7,
		0x033, 0x00000067,
		0x03F, 0x00002EAA,
		0x033, 0x00000068,
		0x03F, 0x00002EAD,
		0x033, 0x00000069,
		0x03F, 0x00002EB0,
		0x033, 0x0000006A,
		0x03F, 0x00002EB3,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000205,
		0x033, 0x00000201,
		0x03F, 0x00000222,
		0x033, 0x00000202,
		0x03F, 0x00000225,
		0x033, 0x00000203,
		0x03F, 0x00000228,
		0x033, 0x00000204,
		0x03F, 0x0000022B,
		0x033, 0x00000205,
		0x03F, 0x00000428,
		0x033, 0x00000206,
		0x03F, 0x00000628,
		0x033, 0x00000207,
		0x03F, 0x0000062B,
		0x033, 0x00000208,
		0x03F, 0x0000062E,
		0x033, 0x00000209,
		0x03F, 0x0000066B,
		0x033, 0x0000020A,
		0x03F, 0x0000066E,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000444,
		0x033, 0x00000201,
		0x03F, 0x00000447,
		0x033, 0x00000202,
		0x03F, 0x00000647,
		0x033, 0x00000203,
		0x03F, 0x00000E46,
		0x033, 0x00000204,
		0x03F, 0x00000E66,
		0x033, 0x00000205,
		0x03F, 0x00000EC4,
		0x033, 0x00000206,
		0x03F, 0x00000EE6,
		0x033, 0x00000207,
		0x03F, 0x00000EE9,
		0x033, 0x00000208,
		0x03F, 0x00000EEC,
		0x033, 0x00000209,
		0x03F, 0x00000EEF,
		0x033, 0x0000020A,
		0x03F, 0x00000EF2,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000205,
		0x033, 0x00000201,
		0x03F, 0x00000222,
		0x033, 0x00000202,
		0x03F, 0x00000225,
		0x033, 0x00000203,
		0x03F, 0x00000228,
		0x033, 0x00000204,
		0x03F, 0x0000022B,
		0x033, 0x00000205,
		0x03F, 0x00000428,
		0x033, 0x00000206,
		0x03F, 0x00000628,
		0x033, 0x00000207,
		0x03F, 0x0000062B,
		0x033, 0x00000208,
		0x03F, 0x0000062E,
		0x033, 0x00000209,
		0x03F, 0x0000066B,
		0x033, 0x0000020A,
		0x03F, 0x0000066E,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000205,
		0x033, 0x00000201,
		0x03F, 0x00000222,
		0x033, 0x00000202,
		0x03F, 0x00000225,
		0x033, 0x00000203,
		0x03F, 0x00000228,
		0x033, 0x00000204,
		0x03F, 0x0000022B,
		0x033, 0x00000205,
		0x03F, 0x00000428,
		0x033, 0x00000206,
		0x03F, 0x00000628,
		0x033, 0x00000207,
		0x03F, 0x0000062B,
		0x033, 0x00000208,
		0x03F, 0x0000062E,
		0x033, 0x00000209,
		0x03F, 0x0000066B,
		0x033, 0x0000020A,
		0x03F, 0x0000066E,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000205,
		0x033, 0x00000201,
		0x03F, 0x00000222,
		0x033, 0x00000202,
		0x03F, 0x00000225,
		0x033, 0x00000203,
		0x03F, 0x00000228,
		0x033, 0x00000204,
		0x03F, 0x0000022B,
		0x033, 0x00000205,
		0x03F, 0x00000428,
		0x033, 0x00000206,
		0x03F, 0x00000628,
		0x033, 0x00000207,
		0x03F, 0x0000062B,
		0x033, 0x00000208,
		0x03F, 0x0000062E,
		0x033, 0x00000209,
		0x03F, 0x0000066B,
		0x033, 0x0000020A,
		0x03F, 0x0000066E,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000444,
		0x033, 0x00000201,
		0x03F, 0x00000447,
		0x033, 0x00000202,
		0x03F, 0x00000647,
		0x033, 0x00000203,
		0x03F, 0x00000E46,
		0x033, 0x00000204,
		0x03F, 0x00000E66,
		0x033, 0x00000205,
		0x03F, 0x00000EC4,
		0x033, 0x00000206,
		0x03F, 0x00000EE6,
		0x033, 0x00000207,
		0x03F, 0x00000EE9,
		0x033, 0x00000208,
		0x03F, 0x00000EEC,
		0x033, 0x00000209,
		0x03F, 0x00000EEF,
		0x033, 0x0000020A,
		0x03F, 0x00000EF2,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000205,
		0x033, 0x00000201,
		0x03F, 0x00000222,
		0x033, 0x00000202,
		0x03F, 0x00000225,
		0x033, 0x00000203,
		0x03F, 0x00000228,
		0x033, 0x00000204,
		0x03F, 0x0000022B,
		0x033, 0x00000205,
		0x03F, 0x00000428,
		0x033, 0x00000206,
		0x03F, 0x00000628,
		0x033, 0x00000207,
		0x03F, 0x0000062B,
		0x033, 0x00000208,
		0x03F, 0x0000062E,
		0x033, 0x00000209,
		0x03F, 0x0000066B,
		0x033, 0x0000020A,
		0x03F, 0x0000066E,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000205,
		0x033, 0x00000201,
		0x03F, 0x00000222,
		0x033, 0x00000202,
		0x03F, 0x00000225,
		0x033, 0x00000203,
		0x03F, 0x00000228,
		0x033, 0x00000204,
		0x03F, 0x0000022B,
		0x033, 0x00000205,
		0x03F, 0x00000428,
		0x033, 0x00000206,
		0x03F, 0x00000628,
		0x033, 0x00000207,
		0x03F, 0x0000062B,
		0x033, 0x00000208,
		0x03F, 0x0000062E,
		0x033, 0x00000209,
		0x03F, 0x0000066B,
		0x033, 0x0000020A,
		0x03F, 0x0000066E,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000205,
		0x033, 0x00000201,
		0x03F, 0x00000222,
		0x033, 0x00000202,
		0x03F, 0x00000225,
		0x033, 0x00000203,
		0x03F, 0x00000228,
		0x033, 0x00000204,
		0x03F, 0x0000022B,
		0x033, 0x00000205,
		0x03F, 0x00000428,
		0x033, 0x00000206,
		0x03F, 0x00000628,
		0x033, 0x00000207,
		0x03F, 0x0000062B,
		0x033, 0x00000208,
		0x03F, 0x0000062E,
		0x033, 0x00000209,
		0x03F, 0x0000066B,
		0x033, 0x0000020A,
		0x03F, 0x0000066E,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000205,
		0x033, 0x00000201,
		0x03F, 0x00000222,
		0x033, 0x00000202,
		0x03F, 0x00000225,
		0x033, 0x00000203,
		0x03F, 0x00000228,
		0x033, 0x00000204,
		0x03F, 0x0000022B,
		0x033, 0x00000205,
		0x03F, 0x00000428,
		0x033, 0x00000206,
		0x03F, 0x00000628,
		0x033, 0x00000207,
		0x03F, 0x0000062B,
		0x033, 0x00000208,
		0x03F, 0x0000062E,
		0x033, 0x00000209,
		0x03F, 0x0000066B,
		0x033, 0x0000020A,
		0x03F, 0x0000066E,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000444,
		0x033, 0x00000201,
		0x03F, 0x00000447,
		0x033, 0x00000202,
		0x03F, 0x00000647,
		0x033, 0x00000203,
		0x03F, 0x00000E46,
		0x033, 0x00000204,
		0x03F, 0x00000E66,
		0x033, 0x00000205,
		0x03F, 0x00000EC4,
		0x033, 0x00000206,
		0x03F, 0x00000EE6,
		0x033, 0x00000207,
		0x03F, 0x00000EE9,
		0x033, 0x00000208,
		0x03F, 0x00000EEC,
		0x033, 0x00000209,
		0x03F, 0x00000EEF,
		0x033, 0x0000020A,
		0x03F, 0x00000EF2,
	0xA0000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000444,
		0x033, 0x00000201,
		0x03F, 0x00000447,
		0x033, 0x00000202,
		0x03F, 0x00000647,
		0x033, 0x00000203,
		0x03F, 0x00000E46,
		0x033, 0x00000204,
		0x03F, 0x00000E66,
		0x033, 0x00000205,
		0x03F, 0x00000EC4,
		0x033, 0x00000206,
		0x03F, 0x00000EE6,
		0x033, 0x00000207,
		0x03F, 0x00000EE9,
		0x033, 0x00000208,
		0x03F, 0x00000EEC,
		0x033, 0x00000209,
		0x03F, 0x00000EEF,
		0x033, 0x0000020A,
		0x03F, 0x00000EF2,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000205,
		0x033, 0x00000281,
		0x03F, 0x00000222,
		0x033, 0x00000282,
		0x03F, 0x00000225,
		0x033, 0x00000283,
		0x03F, 0x00000228,
		0x033, 0x00000284,
		0x03F, 0x0000022B,
		0x033, 0x00000285,
		0x03F, 0x00000428,
		0x033, 0x00000286,
		0x03F, 0x00000628,
		0x033, 0x00000287,
		0x03F, 0x0000062B,
		0x033, 0x00000288,
		0x03F, 0x0000062E,
		0x033, 0x00000289,
		0x03F, 0x0000066B,
		0x033, 0x0000028A,
		0x03F, 0x0000066E,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000445,
		0x033, 0x00000281,
		0x03F, 0x00000448,
		0x033, 0x00000282,
		0x03F, 0x00000648,
		0x033, 0x00000283,
		0x03F, 0x00000E47,
		0x033, 0x00000284,
		0x03F, 0x00000E67,
		0x033, 0x00000285,
		0x03F, 0x00000EC5,
		0x033, 0x00000286,
		0x03F, 0x00000EE7,
		0x033, 0x00000287,
		0x03F, 0x00000EEA,
		0x033, 0x00000288,
		0x03F, 0x00000EED,
		0x033, 0x00000289,
		0x03F, 0x00000EF0,
		0x033, 0x0000028A,
		0x03F, 0x00000EF3,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000205,
		0x033, 0x00000281,
		0x03F, 0x00000222,
		0x033, 0x00000282,
		0x03F, 0x00000225,
		0x033, 0x00000283,
		0x03F, 0x00000228,
		0x033, 0x00000284,
		0x03F, 0x0000022B,
		0x033, 0x00000285,
		0x03F, 0x00000428,
		0x033, 0x00000286,
		0x03F, 0x00000628,
		0x033, 0x00000287,
		0x03F, 0x0000062B,
		0x033, 0x00000288,
		0x03F, 0x0000062E,
		0x033, 0x00000289,
		0x03F, 0x0000066B,
		0x033, 0x0000028A,
		0x03F, 0x0000066E,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000205,
		0x033, 0x00000281,
		0x03F, 0x00000222,
		0x033, 0x00000282,
		0x03F, 0x00000225,
		0x033, 0x00000283,
		0x03F, 0x00000228,
		0x033, 0x00000284,
		0x03F, 0x0000022B,
		0x033, 0x00000285,
		0x03F, 0x00000428,
		0x033, 0x00000286,
		0x03F, 0x00000628,
		0x033, 0x00000287,
		0x03F, 0x0000062B,
		0x033, 0x00000288,
		0x03F, 0x0000062E,
		0x033, 0x00000289,
		0x03F, 0x0000066B,
		0x033, 0x0000028A,
		0x03F, 0x0000066E,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000205,
		0x033, 0x00000281,
		0x03F, 0x00000222,
		0x033, 0x00000282,
		0x03F, 0x00000225,
		0x033, 0x00000283,
		0x03F, 0x00000228,
		0x033, 0x00000284,
		0x03F, 0x0000022B,
		0x033, 0x00000285,
		0x03F, 0x00000428,
		0x033, 0x00000286,
		0x03F, 0x00000628,
		0x033, 0x00000287,
		0x03F, 0x0000062B,
		0x033, 0x00000288,
		0x03F, 0x0000062E,
		0x033, 0x00000289,
		0x03F, 0x0000066B,
		0x033, 0x0000028A,
		0x03F, 0x0000066E,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000445,
		0x033, 0x00000281,
		0x03F, 0x00000448,
		0x033, 0x00000282,
		0x03F, 0x00000648,
		0x033, 0x00000283,
		0x03F, 0x00000E47,
		0x033, 0x00000284,
		0x03F, 0x00000E67,
		0x033, 0x00000285,
		0x03F, 0x00000EC5,
		0x033, 0x00000286,
		0x03F, 0x00000EE7,
		0x033, 0x00000287,
		0x03F, 0x00000EEA,
		0x033, 0x00000288,
		0x03F, 0x00000EED,
		0x033, 0x00000289,
		0x03F, 0x00000EF0,
		0x033, 0x0000028A,
		0x03F, 0x00000EF3,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000205,
		0x033, 0x00000281,
		0x03F, 0x00000222,
		0x033, 0x00000282,
		0x03F, 0x00000225,
		0x033, 0x00000283,
		0x03F, 0x00000228,
		0x033, 0x00000284,
		0x03F, 0x0000022B,
		0x033, 0x00000285,
		0x03F, 0x00000428,
		0x033, 0x00000286,
		0x03F, 0x00000628,
		0x033, 0x00000287,
		0x03F, 0x0000062B,
		0x033, 0x00000288,
		0x03F, 0x0000062E,
		0x033, 0x00000289,
		0x03F, 0x0000066B,
		0x033, 0x0000028A,
		0x03F, 0x0000066E,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000205,
		0x033, 0x00000281,
		0x03F, 0x00000222,
		0x033, 0x00000282,
		0x03F, 0x00000225,
		0x033, 0x00000283,
		0x03F, 0x00000228,
		0x033, 0x00000284,
		0x03F, 0x0000022B,
		0x033, 0x00000285,
		0x03F, 0x00000428,
		0x033, 0x00000286,
		0x03F, 0x00000628,
		0x033, 0x00000287,
		0x03F, 0x0000062B,
		0x033, 0x00000288,
		0x03F, 0x0000062E,
		0x033, 0x00000289,
		0x03F, 0x0000066B,
		0x033, 0x0000028A,
		0x03F, 0x0000066E,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000205,
		0x033, 0x00000281,
		0x03F, 0x00000222,
		0x033, 0x00000282,
		0x03F, 0x00000225,
		0x033, 0x00000283,
		0x03F, 0x00000228,
		0x033, 0x00000284,
		0x03F, 0x0000022B,
		0x033, 0x00000285,
		0x03F, 0x00000428,
		0x033, 0x00000286,
		0x03F, 0x00000628,
		0x033, 0x00000287,
		0x03F, 0x0000062B,
		0x033, 0x00000288,
		0x03F, 0x0000062E,
		0x033, 0x00000289,
		0x03F, 0x0000066B,
		0x033, 0x0000028A,
		0x03F, 0x0000066E,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000205,
		0x033, 0x00000281,
		0x03F, 0x00000222,
		0x033, 0x00000282,
		0x03F, 0x00000225,
		0x033, 0x00000283,
		0x03F, 0x00000228,
		0x033, 0x00000284,
		0x03F, 0x0000022B,
		0x033, 0x00000285,
		0x03F, 0x00000428,
		0x033, 0x00000286,
		0x03F, 0x00000628,
		0x033, 0x00000287,
		0x03F, 0x0000062B,
		0x033, 0x00000288,
		0x03F, 0x0000062E,
		0x033, 0x00000289,
		0x03F, 0x0000066B,
		0x033, 0x0000028A,
		0x03F, 0x0000066E,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000445,
		0x033, 0x00000281,
		0x03F, 0x00000448,
		0x033, 0x00000282,
		0x03F, 0x00000648,
		0x033, 0x00000283,
		0x03F, 0x00000E47,
		0x033, 0x00000284,
		0x03F, 0x00000E67,
		0x033, 0x00000285,
		0x03F, 0x00000EC5,
		0x033, 0x00000286,
		0x03F, 0x00000EE7,
		0x033, 0x00000287,
		0x03F, 0x00000EEA,
		0x033, 0x00000288,
		0x03F, 0x00000EED,
		0x033, 0x00000289,
		0x03F, 0x00000EF0,
		0x033, 0x0000028A,
		0x03F, 0x00000EF3,
	0xA0000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000445,
		0x033, 0x00000281,
		0x03F, 0x00000448,
		0x033, 0x00000282,
		0x03F, 0x00000648,
		0x033, 0x00000283,
		0x03F, 0x00000E47,
		0x033, 0x00000284,
		0x03F, 0x00000E67,
		0x033, 0x00000285,
		0x03F, 0x00000EC5,
		0x033, 0x00000286,
		0x03F, 0x00000EE7,
		0x033, 0x00000287,
		0x03F, 0x00000EEA,
		0x033, 0x00000288,
		0x03F, 0x00000EED,
		0x033, 0x00000289,
		0x03F, 0x00000EF0,
		0x033, 0x0000028A,
		0x03F, 0x00000EF3,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000205,
		0x033, 0x00000301,
		0x03F, 0x00000222,
		0x033, 0x00000302,
		0x03F, 0x00000225,
		0x033, 0x00000303,
		0x03F, 0x00000228,
		0x033, 0x00000304,
		0x03F, 0x0000022B,
		0x033, 0x00000305,
		0x03F, 0x00000428,
		0x033, 0x00000306,
		0x03F, 0x00000628,
		0x033, 0x00000307,
		0x03F, 0x0000062B,
		0x033, 0x00000308,
		0x03F, 0x0000062E,
		0x033, 0x00000309,
		0x03F, 0x0000066B,
		0x033, 0x0000030A,
		0x03F, 0x0000066E,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000445,
		0x033, 0x00000301,
		0x03F, 0x00000448,
		0x033, 0x00000302,
		0x03F, 0x00000648,
		0x033, 0x00000303,
		0x03F, 0x00000E47,
		0x033, 0x00000304,
		0x03F, 0x00000E67,
		0x033, 0x00000305,
		0x03F, 0x00000EC5,
		0x033, 0x00000306,
		0x03F, 0x00000EE7,
		0x033, 0x00000307,
		0x03F, 0x00000EEA,
		0x033, 0x00000308,
		0x03F, 0x00000EED,
		0x033, 0x00000309,
		0x03F, 0x00000EF0,
		0x033, 0x0000030A,
		0x03F, 0x00000EF3,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000205,
		0x033, 0x00000301,
		0x03F, 0x00000222,
		0x033, 0x00000302,
		0x03F, 0x00000225,
		0x033, 0x00000303,
		0x03F, 0x00000228,
		0x033, 0x00000304,
		0x03F, 0x0000022B,
		0x033, 0x00000305,
		0x03F, 0x00000428,
		0x033, 0x00000306,
		0x03F, 0x00000628,
		0x033, 0x00000307,
		0x03F, 0x0000062B,
		0x033, 0x00000308,
		0x03F, 0x0000062E,
		0x033, 0x00000309,
		0x03F, 0x0000066B,
		0x033, 0x0000030A,
		0x03F, 0x0000066E,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000205,
		0x033, 0x00000301,
		0x03F, 0x00000222,
		0x033, 0x00000302,
		0x03F, 0x00000225,
		0x033, 0x00000303,
		0x03F, 0x00000228,
		0x033, 0x00000304,
		0x03F, 0x0000022B,
		0x033, 0x00000305,
		0x03F, 0x00000428,
		0x033, 0x00000306,
		0x03F, 0x00000628,
		0x033, 0x00000307,
		0x03F, 0x0000062B,
		0x033, 0x00000308,
		0x03F, 0x0000062E,
		0x033, 0x00000309,
		0x03F, 0x0000066B,
		0x033, 0x0000030A,
		0x03F, 0x0000066E,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000205,
		0x033, 0x00000301,
		0x03F, 0x00000222,
		0x033, 0x00000302,
		0x03F, 0x00000225,
		0x033, 0x00000303,
		0x03F, 0x00000228,
		0x033, 0x00000304,
		0x03F, 0x0000022B,
		0x033, 0x00000305,
		0x03F, 0x00000428,
		0x033, 0x00000306,
		0x03F, 0x00000628,
		0x033, 0x00000307,
		0x03F, 0x0000062B,
		0x033, 0x00000308,
		0x03F, 0x0000062E,
		0x033, 0x00000309,
		0x03F, 0x0000066B,
		0x033, 0x0000030A,
		0x03F, 0x0000066E,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000445,
		0x033, 0x00000301,
		0x03F, 0x00000448,
		0x033, 0x00000302,
		0x03F, 0x00000648,
		0x033, 0x00000303,
		0x03F, 0x00000E47,
		0x033, 0x00000304,
		0x03F, 0x00000E67,
		0x033, 0x00000305,
		0x03F, 0x00000EC5,
		0x033, 0x00000306,
		0x03F, 0x00000EE7,
		0x033, 0x00000307,
		0x03F, 0x00000EEA,
		0x033, 0x00000308,
		0x03F, 0x00000EED,
		0x033, 0x00000309,
		0x03F, 0x00000EF0,
		0x033, 0x0000030A,
		0x03F, 0x00000EF3,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000205,
		0x033, 0x00000301,
		0x03F, 0x00000222,
		0x033, 0x00000302,
		0x03F, 0x00000225,
		0x033, 0x00000303,
		0x03F, 0x00000228,
		0x033, 0x00000304,
		0x03F, 0x0000022B,
		0x033, 0x00000305,
		0x03F, 0x00000428,
		0x033, 0x00000306,
		0x03F, 0x00000628,
		0x033, 0x00000307,
		0x03F, 0x0000062B,
		0x033, 0x00000308,
		0x03F, 0x0000062E,
		0x033, 0x00000309,
		0x03F, 0x0000066B,
		0x033, 0x0000030A,
		0x03F, 0x0000066E,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000205,
		0x033, 0x00000301,
		0x03F, 0x00000222,
		0x033, 0x00000302,
		0x03F, 0x00000225,
		0x033, 0x00000303,
		0x03F, 0x00000228,
		0x033, 0x00000304,
		0x03F, 0x0000022B,
		0x033, 0x00000305,
		0x03F, 0x00000428,
		0x033, 0x00000306,
		0x03F, 0x00000628,
		0x033, 0x00000307,
		0x03F, 0x0000062B,
		0x033, 0x00000308,
		0x03F, 0x0000062E,
		0x033, 0x00000309,
		0x03F, 0x0000066B,
		0x033, 0x0000030A,
		0x03F, 0x0000066E,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000205,
		0x033, 0x00000301,
		0x03F, 0x00000222,
		0x033, 0x00000302,
		0x03F, 0x00000225,
		0x033, 0x00000303,
		0x03F, 0x00000228,
		0x033, 0x00000304,
		0x03F, 0x0000022B,
		0x033, 0x00000305,
		0x03F, 0x00000428,
		0x033, 0x00000306,
		0x03F, 0x00000628,
		0x033, 0x00000307,
		0x03F, 0x0000062B,
		0x033, 0x00000308,
		0x03F, 0x0000062E,
		0x033, 0x00000309,
		0x03F, 0x0000066B,
		0x033, 0x0000030A,
		0x03F, 0x0000066E,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000205,
		0x033, 0x00000301,
		0x03F, 0x00000222,
		0x033, 0x00000302,
		0x03F, 0x00000225,
		0x033, 0x00000303,
		0x03F, 0x00000228,
		0x033, 0x00000304,
		0x03F, 0x0000022B,
		0x033, 0x00000305,
		0x03F, 0x00000428,
		0x033, 0x00000306,
		0x03F, 0x00000628,
		0x033, 0x00000307,
		0x03F, 0x0000062B,
		0x033, 0x00000308,
		0x03F, 0x0000062E,
		0x033, 0x00000309,
		0x03F, 0x0000066B,
		0x033, 0x0000030A,
		0x03F, 0x0000066E,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000445,
		0x033, 0x00000301,
		0x03F, 0x00000448,
		0x033, 0x00000302,
		0x03F, 0x00000648,
		0x033, 0x00000303,
		0x03F, 0x00000E47,
		0x033, 0x00000304,
		0x03F, 0x00000E67,
		0x033, 0x00000305,
		0x03F, 0x00000EC5,
		0x033, 0x00000306,
		0x03F, 0x00000EE7,
		0x033, 0x00000307,
		0x03F, 0x00000EEA,
		0x033, 0x00000308,
		0x03F, 0x00000EED,
		0x033, 0x00000309,
		0x03F, 0x00000EF0,
		0x033, 0x0000030A,
		0x03F, 0x00000EF3,
	0xA0000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000445,
		0x033, 0x00000301,
		0x03F, 0x00000448,
		0x033, 0x00000302,
		0x03F, 0x00000648,
		0x033, 0x00000303,
		0x03F, 0x00000E47,
		0x033, 0x00000304,
		0x03F, 0x00000E67,
		0x033, 0x00000305,
		0x03F, 0x00000EC5,
		0x033, 0x00000306,
		0x03F, 0x00000EE7,
		0x033, 0x00000307,
		0x03F, 0x00000EEA,
		0x033, 0x00000308,
		0x03F, 0x00000EED,
		0x033, 0x00000309,
		0x03F, 0x00000EF0,
		0x033, 0x0000030A,
		0x03F, 0x00000EF3,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00040000,
		0x033, 0x00000001,
		0x03F, 0x000C0001,
		0x0EE, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00040000,
		0x033, 0x00000001,
		0x03F, 0x000C0001,
		0x0EE, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00040000,
		0x033, 0x00000001,
		0x03F, 0x000C0001,
		0x0EE, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00040000,
		0x033, 0x00000001,
		0x03F, 0x000C0001,
		0x0EE, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00040000,
		0x033, 0x00000001,
		0x03F, 0x000C0001,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00040000,
		0x033, 0x00000001,
		0x03F, 0x000C0001,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x030, 0x00000000,
		0x03F, 0x000150F9,
		0x030, 0x00010000,
		0x03F, 0x000150F9,
		0x030, 0x00020000,
		0x03F, 0x000150F9,
		0x030, 0x00030000,
		0x03F, 0x000150F9,
		0x030, 0x00040000,
		0x03F, 0x000150F9,
		0x030, 0x00050000,
		0x03F, 0x000150F9,
		0x030, 0x00060000,
		0x03F, 0x000150F9,
		0x030, 0x00070000,
		0x03F, 0x000150F9,
		0x030, 0x00080000,
		0x03F, 0x000150F9,
		0x030, 0x00090000,
		0x03F, 0x000150F9,
		0x030, 0x000A0000,
		0x03F, 0x000150F9,
		0x030, 0x000B0000,
		0x03F, 0x000150F9,
		0x030, 0x000C0000,
		0x03F, 0x000150F9,
		0x030, 0x000D0000,
		0x03F, 0x000150F9,
		0x030, 0x000E0000,
		0x03F, 0x000150F9,
		0x030, 0x000F0000,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x030, 0x00000000,
		0x03F, 0x000150F9,
		0x030, 0x00010000,
		0x03F, 0x000150F9,
		0x030, 0x00020000,
		0x03F, 0x000150F9,
		0x030, 0x00030000,
		0x03F, 0x000150F9,
		0x030, 0x00040000,
		0x03F, 0x000150F9,
		0x030, 0x00050000,
		0x03F, 0x000150F9,
		0x030, 0x00060000,
		0x03F, 0x000150F9,
		0x030, 0x00070000,
		0x03F, 0x000150F9,
		0x030, 0x00080000,
		0x03F, 0x000150F9,
		0x030, 0x00090000,
		0x03F, 0x000150F9,
		0x030, 0x000A0000,
		0x03F, 0x000150F9,
		0x030, 0x000B0000,
		0x03F, 0x000150F9,
		0x030, 0x000C0000,
		0x03F, 0x000150F9,
		0x030, 0x000D0000,
		0x03F, 0x000150F9,
		0x030, 0x000E0000,
		0x03F, 0x000150F9,
		0x030, 0x000F0000,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x030, 0x00000000,
		0x03F, 0x000150F9,
		0x030, 0x00010000,
		0x03F, 0x000150F9,
		0x030, 0x00020000,
		0x03F, 0x000150F9,
		0x030, 0x00030000,
		0x03F, 0x000150F9,
		0x030, 0x00040000,
		0x03F, 0x000150F9,
		0x030, 0x00050000,
		0x03F, 0x000150F9,
		0x030, 0x00060000,
		0x03F, 0x000150F9,
		0x030, 0x00070000,
		0x03F, 0x000150F9,
		0x030, 0x00080000,
		0x03F, 0x000150F9,
		0x030, 0x00090000,
		0x03F, 0x000150F9,
		0x030, 0x000A0000,
		0x03F, 0x000150F9,
		0x030, 0x000B0000,
		0x03F, 0x000150F9,
		0x030, 0x000C0000,
		0x03F, 0x000150F9,
		0x030, 0x000D0000,
		0x03F, 0x000150F9,
		0x030, 0x000E0000,
		0x03F, 0x000150F9,
		0x030, 0x000F0000,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x030, 0x00000000,
		0x03F, 0x000150F9,
		0x030, 0x00010000,
		0x03F, 0x000150F9,
		0x030, 0x00020000,
		0x03F, 0x000150F9,
		0x030, 0x00030000,
		0x03F, 0x000150F9,
		0x030, 0x00040000,
		0x03F, 0x000150F9,
		0x030, 0x00050000,
		0x03F, 0x000150F9,
		0x030, 0x00060000,
		0x03F, 0x000150F9,
		0x030, 0x00070000,
		0x03F, 0x000150F9,
		0x030, 0x00080000,
		0x03F, 0x000150F9,
		0x030, 0x00090000,
		0x03F, 0x000150F9,
		0x030, 0x000A0000,
		0x03F, 0x000150F9,
		0x030, 0x000B0000,
		0x03F, 0x000150F9,
		0x030, 0x000C0000,
		0x03F, 0x000150F9,
		0x030, 0x000D0000,
		0x03F, 0x000150F9,
		0x030, 0x000E0000,
		0x03F, 0x000150F9,
		0x030, 0x000F0000,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x030, 0x00000000,
		0x03F, 0x000150F9,
		0x030, 0x00010000,
		0x03F, 0x000150F9,
		0x030, 0x00020000,
		0x03F, 0x000150F9,
		0x030, 0x00030000,
		0x03F, 0x000150F9,
		0x030, 0x00040000,
		0x03F, 0x000150F9,
		0x030, 0x00050000,
		0x03F, 0x000150F9,
		0x030, 0x00060000,
		0x03F, 0x000150F9,
		0x030, 0x00070000,
		0x03F, 0x000150F9,
		0x030, 0x00080000,
		0x03F, 0x000150F9,
		0x030, 0x00090000,
		0x03F, 0x000150F9,
		0x030, 0x000A0000,
		0x03F, 0x000150F9,
		0x030, 0x000B0000,
		0x03F, 0x000150F9,
		0x030, 0x000C0000,
		0x03F, 0x000150F9,
		0x030, 0x000D0000,
		0x03F, 0x000150F9,
		0x030, 0x000E0000,
		0x03F, 0x000150F9,
		0x030, 0x000F0000,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000400,
		0x030, 0x00000000,
		0x03F, 0x000150F9,
		0x030, 0x00010000,
		0x03F, 0x000150F9,
		0x030, 0x00020000,
		0x03F, 0x000150F9,
		0x030, 0x00030000,
		0x03F, 0x000150F9,
		0x030, 0x00040000,
		0x03F, 0x000150F9,
		0x030, 0x00050000,
		0x03F, 0x000150F9,
		0x030, 0x00060000,
		0x03F, 0x000150F9,
		0x030, 0x00070000,
		0x03F, 0x000150F9,
		0x030, 0x00080000,
		0x03F, 0x000150F9,
		0x030, 0x00090000,
		0x03F, 0x000150F9,
		0x030, 0x000A0000,
		0x03F, 0x000150F9,
		0x030, 0x000B0000,
		0x03F, 0x000150F9,
		0x030, 0x000C0000,
		0x03F, 0x000150F9,
		0x030, 0x000D0000,
		0x03F, 0x000150F9,
		0x030, 0x000E0000,
		0x03F, 0x000150F9,
		0x030, 0x000F0000,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000001,
		0x03F, 0x000150F9,
		0x033, 0x0000000B,
		0x03F, 0x000150F9,
		0x033, 0x00000023,
		0x03F, 0x000150F9,
		0x033, 0x00000029,
		0x03F, 0x000150F9,
		0x033, 0x0000002A,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000001,
		0x03F, 0x000150F9,
		0x033, 0x0000000B,
		0x03F, 0x000150F9,
		0x033, 0x00000023,
		0x03F, 0x000150F9,
		0x033, 0x00000029,
		0x03F, 0x000150F9,
		0x033, 0x0000002A,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000001,
		0x03F, 0x000150F9,
		0x033, 0x0000000B,
		0x03F, 0x000150F9,
		0x033, 0x00000023,
		0x03F, 0x000150F9,
		0x033, 0x00000029,
		0x03F, 0x000150F9,
		0x033, 0x0000002A,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000001,
		0x03F, 0x000150F9,
		0x033, 0x0000000B,
		0x03F, 0x000150F9,
		0x033, 0x00000023,
		0x03F, 0x000150F9,
		0x033, 0x00000029,
		0x03F, 0x000150F9,
		0x033, 0x0000002A,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000001,
		0x03F, 0x000150F9,
		0x033, 0x0000000B,
		0x03F, 0x000150F9,
		0x033, 0x00000023,
		0x03F, 0x000150F9,
		0x033, 0x00000029,
		0x03F, 0x000150F9,
		0x033, 0x0000002A,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000001,
		0x03F, 0x000150F9,
		0x033, 0x0000000B,
		0x03F, 0x000150F9,
		0x033, 0x00000023,
		0x03F, 0x000150F9,
		0x033, 0x00000029,
		0x03F, 0x000150F9,
		0x033, 0x0000002A,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x00000054,
		0x030, 0x00001054,
		0x030, 0x00002054,
		0x030, 0x00003054,
		0x030, 0x00004024,
		0x030, 0x00005024,
		0x030, 0x00006024,
		0x030, 0x00007024,
		0x030, 0x00008024,
		0x030, 0x00009024,
		0x030, 0x0000A024,
		0x030, 0x0000B024,
		0x0EE, 0x00000000,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x00000254,
		0x030, 0x00001254,
		0x030, 0x00002254,
		0x030, 0x00003254,
		0x030, 0x00004474,
		0x030, 0x00005474,
		0x030, 0x00006474,
		0x030, 0x00007474,
		0x030, 0x00008484,
		0x030, 0x00009484,
		0x030, 0x0000A484,
		0x030, 0x0000B484,
		0x0EE, 0x00000000,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x00000054,
		0x030, 0x00001054,
		0x030, 0x00002054,
		0x030, 0x00003054,
		0x030, 0x00004024,
		0x030, 0x00005024,
		0x030, 0x00006024,
		0x030, 0x00007024,
		0x030, 0x00008024,
		0x030, 0x00009024,
		0x030, 0x0000A024,
		0x030, 0x0000B024,
		0x0EE, 0x00000000,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x00000054,
		0x030, 0x00001054,
		0x030, 0x00002054,
		0x030, 0x00003054,
		0x030, 0x00004024,
		0x030, 0x00005024,
		0x030, 0x00006024,
		0x030, 0x00007024,
		0x030, 0x00008024,
		0x030, 0x00009024,
		0x030, 0x0000A024,
		0x030, 0x0000B024,
		0x0EE, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x00000054,
		0x030, 0x00001054,
		0x030, 0x00002054,
		0x030, 0x00003054,
		0x030, 0x00004024,
		0x030, 0x00005024,
		0x030, 0x00006024,
		0x030, 0x00007024,
		0x030, 0x00008024,
		0x030, 0x00009024,
		0x030, 0x0000A024,
		0x030, 0x0000B024,
		0x0EE, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x00000254,
		0x030, 0x00001254,
		0x030, 0x00002254,
		0x030, 0x00003254,
		0x030, 0x00004474,
		0x030, 0x00005474,
		0x030, 0x00006474,
		0x030, 0x00007474,
		0x030, 0x00008484,
		0x030, 0x00009484,
		0x030, 0x0000A484,
		0x030, 0x0000B484,
		0x0EE, 0x00000000,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x00000054,
		0x030, 0x00001054,
		0x030, 0x00002054,
		0x030, 0x00003054,
		0x030, 0x00004024,
		0x030, 0x00005024,
		0x030, 0x00006024,
		0x030, 0x00007024,
		0x030, 0x00008024,
		0x030, 0x00009024,
		0x030, 0x0000A024,
		0x030, 0x0000B024,
		0x0EE, 0x00000000,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x00000054,
		0x030, 0x00001054,
		0x030, 0x00002054,
		0x030, 0x00003054,
		0x030, 0x00004024,
		0x030, 0x00005024,
		0x030, 0x00006024,
		0x030, 0x00007024,
		0x030, 0x00008024,
		0x030, 0x00009024,
		0x030, 0x0000A024,
		0x030, 0x0000B024,
		0x0EE, 0x00000000,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x00000054,
		0x030, 0x00001054,
		0x030, 0x00002054,
		0x030, 0x00003054,
		0x030, 0x00004024,
		0x030, 0x00005024,
		0x030, 0x00006024,
		0x030, 0x00007024,
		0x030, 0x00008024,
		0x030, 0x00009024,
		0x030, 0x0000A024,
		0x030, 0x0000B024,
		0x0EE, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x00000054,
		0x030, 0x00001054,
		0x030, 0x00002054,
		0x030, 0x00003054,
		0x030, 0x00004024,
		0x030, 0x00005024,
		0x030, 0x00006024,
		0x030, 0x00007024,
		0x030, 0x00008024,
		0x030, 0x00009024,
		0x030, 0x0000A024,
		0x030, 0x0000B024,
		0x0EE, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x00000254,
		0x030, 0x00001254,
		0x030, 0x00002254,
		0x030, 0x00003254,
		0x030, 0x00004474,
		0x030, 0x00005474,
		0x030, 0x00006474,
		0x030, 0x00007474,
		0x030, 0x00008484,
		0x030, 0x00009484,
		0x030, 0x0000A484,
		0x030, 0x0000B484,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x00000254,
		0x030, 0x00001254,
		0x030, 0x00002254,
		0x030, 0x00003254,
		0x030, 0x00004474,
		0x030, 0x00005474,
		0x030, 0x00006474,
		0x030, 0x00007474,
		0x030, 0x00008484,
		0x030, 0x00009484,
		0x030, 0x0000A484,
		0x030, 0x0000B484,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000400,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x0EE, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000400,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x0EE, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000400,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x0EE, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000400,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x0EE, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000400,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000400,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x00000054,
		0x030, 0x00001054,
		0x030, 0x00002054,
		0x030, 0x00003054,
		0x030, 0x00004054,
		0x030, 0x00005054,
		0x030, 0x00006024,
		0x030, 0x00007024,
		0x030, 0x00008024,
		0x030, 0x00009024,
		0x030, 0x0000A024,
		0x030, 0x0000B024,
		0x030, 0x0000C024,
		0x030, 0x0000D024,
		0x030, 0x0000E024,
		0x0EE, 0x00000000,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x00000254,
		0x030, 0x00001254,
		0x030, 0x00002254,
		0x030, 0x00003254,
		0x030, 0x00004254,
		0x030, 0x00005254,
		0x030, 0x00006474,
		0x030, 0x00007474,
		0x030, 0x00008474,
		0x030, 0x00009474,
		0x030, 0x0000A474,
		0x030, 0x0000B484,
		0x030, 0x0000C484,
		0x030, 0x0000D484,
		0x030, 0x0000E484,
		0x0EE, 0x00000000,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x00000054,
		0x030, 0x00001054,
		0x030, 0x00002054,
		0x030, 0x00003054,
		0x030, 0x00004054,
		0x030, 0x00005054,
		0x030, 0x00006024,
		0x030, 0x00007024,
		0x030, 0x00008024,
		0x030, 0x00009024,
		0x030, 0x0000A024,
		0x030, 0x0000B024,
		0x030, 0x0000C024,
		0x030, 0x0000D024,
		0x030, 0x0000E024,
		0x0EE, 0x00000000,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x00000054,
		0x030, 0x00001054,
		0x030, 0x00002054,
		0x030, 0x00003054,
		0x030, 0x00004054,
		0x030, 0x00005054,
		0x030, 0x00006024,
		0x030, 0x00007024,
		0x030, 0x00008024,
		0x030, 0x00009024,
		0x030, 0x0000A024,
		0x030, 0x0000B024,
		0x030, 0x0000C024,
		0x030, 0x0000D024,
		0x030, 0x0000E024,
		0x0EE, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x00000054,
		0x030, 0x00001054,
		0x030, 0x00002054,
		0x030, 0x00003054,
		0x030, 0x00004054,
		0x030, 0x00005054,
		0x030, 0x00006024,
		0x030, 0x00007024,
		0x030, 0x00008024,
		0x030, 0x00009024,
		0x030, 0x0000A024,
		0x030, 0x0000B024,
		0x030, 0x0000C024,
		0x030, 0x0000D024,
		0x030, 0x0000E024,
		0x0EE, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x00000254,
		0x030, 0x00001254,
		0x030, 0x00002254,
		0x030, 0x00003254,
		0x030, 0x00004254,
		0x030, 0x00005254,
		0x030, 0x00006474,
		0x030, 0x00007474,
		0x030, 0x00008474,
		0x030, 0x00009474,
		0x030, 0x0000A474,
		0x030, 0x0000B484,
		0x030, 0x0000C484,
		0x030, 0x0000D484,
		0x030, 0x0000E484,
		0x0EE, 0x00000000,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x00000054,
		0x030, 0x00001054,
		0x030, 0x00002054,
		0x030, 0x00003054,
		0x030, 0x00004054,
		0x030, 0x00005054,
		0x030, 0x00006024,
		0x030, 0x00007024,
		0x030, 0x00008024,
		0x030, 0x00009024,
		0x030, 0x0000A024,
		0x030, 0x0000B024,
		0x030, 0x0000C024,
		0x030, 0x0000D024,
		0x030, 0x0000E024,
		0x0EE, 0x00000000,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x00000054,
		0x030, 0x00001054,
		0x030, 0x00002054,
		0x030, 0x00003054,
		0x030, 0x00004054,
		0x030, 0x00005054,
		0x030, 0x00006024,
		0x030, 0x00007024,
		0x030, 0x00008024,
		0x030, 0x00009024,
		0x030, 0x0000A024,
		0x030, 0x0000B024,
		0x030, 0x0000C024,
		0x030, 0x0000D024,
		0x030, 0x0000E024,
		0x0EE, 0x00000000,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x00000054,
		0x030, 0x00001054,
		0x030, 0x00002054,
		0x030, 0x00003054,
		0x030, 0x00004054,
		0x030, 0x00005054,
		0x030, 0x00006024,
		0x030, 0x00007024,
		0x030, 0x00008024,
		0x030, 0x00009024,
		0x030, 0x0000A024,
		0x030, 0x0000B024,
		0x030, 0x0000C024,
		0x030, 0x0000D024,
		0x030, 0x0000E024,
		0x0EE, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x00000054,
		0x030, 0x00001054,
		0x030, 0x00002054,
		0x030, 0x00003054,
		0x030, 0x00004054,
		0x030, 0x00005054,
		0x030, 0x00006024,
		0x030, 0x00007024,
		0x030, 0x00008024,
		0x030, 0x00009024,
		0x030, 0x0000A024,
		0x030, 0x0000B024,
		0x030, 0x0000C024,
		0x030, 0x0000D024,
		0x030, 0x0000E024,
		0x0EE, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x00000254,
		0x030, 0x00001254,
		0x030, 0x00002254,
		0x030, 0x00003254,
		0x030, 0x00004254,
		0x030, 0x00005254,
		0x030, 0x00006474,
		0x030, 0x00007474,
		0x030, 0x00008474,
		0x030, 0x00009474,
		0x030, 0x0000A474,
		0x030, 0x0000B484,
		0x030, 0x0000C484,
		0x030, 0x0000D484,
		0x030, 0x0000E484,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x00000254,
		0x030, 0x00001254,
		0x030, 0x00002254,
		0x030, 0x00003254,
		0x030, 0x00004254,
		0x030, 0x00005254,
		0x030, 0x00006474,
		0x030, 0x00007474,
		0x030, 0x00008474,
		0x030, 0x00009474,
		0x030, 0x0000A474,
		0x030, 0x0000B484,
		0x030, 0x0000C484,
		0x030, 0x0000D484,
		0x030, 0x0000E484,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000800,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x030, 0x0000C0B8,
		0x030, 0x0000D0B8,
		0x030, 0x0000E0B8,
		0x0EE, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000800,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x030, 0x0000C0B8,
		0x030, 0x0000D0B8,
		0x030, 0x0000E0B8,
		0x0EE, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000800,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x030, 0x0000C0B8,
		0x030, 0x0000D0B8,
		0x030, 0x0000E0B8,
		0x0EE, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000800,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x030, 0x0000C0B8,
		0x030, 0x0000D0B8,
		0x030, 0x0000E0B8,
		0x0EE, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000800,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x030, 0x0000C0B8,
		0x030, 0x0000D0B8,
		0x030, 0x0000E0B8,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000800,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x030, 0x0000C0B8,
		0x030, 0x0000D0B8,
		0x030, 0x0000E0B8,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00001000,
		0x030, 0x00000CDE,
		0x030, 0x00001778,
		0x030, 0x00002351,
		0x030, 0x00003351,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x030, 0x00007000,
		0x0EE, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00001000,
		0x030, 0x00000CDE,
		0x030, 0x00001778,
		0x030, 0x00002351,
		0x030, 0x00003351,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x030, 0x00007000,
		0x0EE, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00001000,
		0x030, 0x00000CDE,
		0x030, 0x00001778,
		0x030, 0x00002351,
		0x030, 0x00003351,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x030, 0x00007000,
		0x0EE, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00001000,
		0x030, 0x00000CDE,
		0x030, 0x00001778,
		0x030, 0x00002351,
		0x030, 0x00003351,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x030, 0x00007000,
		0x0EE, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00001000,
		0x030, 0x00000CDE,
		0x030, 0x00001778,
		0x030, 0x00002351,
		0x030, 0x00003351,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x030, 0x00007000,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00001000,
		0x030, 0x00000CDE,
		0x030, 0x00001778,
		0x030, 0x00002351,
		0x030, 0x00003351,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x030, 0x00007000,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x0004026A,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x0004026A,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x0004026A,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x0004026A,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x0004026A,
	0xA0000000,	0x00000000,
		0x063, 0x0004026A,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000D8DEF,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x00008DF7,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000D8DEF,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000D8DEF,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000D8DEF,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x00008DF7,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000D8DEF,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000D8DEF,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000D8DEF,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000D8DEF,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x00008DF7,
	0xA0000000,	0x00000000,
		0x08A, 0x00008DF7,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A6560,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A6560,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A6560,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A6560,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A6560,
	0xA0000000,	0x00000000,
		0x08E, 0x000A6560,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00020000,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000006,
		0x03E, 0x00008801,
		0x03F, 0x00017903,
		0x033, 0x00000005,
		0x03E, 0x00008806,
		0x03F, 0x00007903,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00007903,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00027903,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000000,
		0x03E, 0x00008922,
		0x03F, 0x00017903,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x00000006,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x00000005,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000000,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000006,
		0x03E, 0x00008802,
		0x03F, 0x00007903,
		0x033, 0x00000005,
		0x03E, 0x00008806,
		0x03F, 0x00007903,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00057903,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00017903,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00017903,
		0x033, 0x00000000,
		0x03E, 0x00008922,
		0x03F, 0x00017903,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000006,
		0x03E, 0x00008800,
		0x03F, 0x00047903,
		0x033, 0x00000005,
		0x03E, 0x00008805,
		0x03F, 0x00007903,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00007903,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00017903,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000000,
		0x03E, 0x00008922,
		0x03F, 0x00037903,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000006,
		0x03E, 0x00008801,
		0x03F, 0x00017903,
		0x033, 0x00000005,
		0x03E, 0x00008806,
		0x03F, 0x00007903,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00007903,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00027903,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000000,
		0x03E, 0x00008922,
		0x03F, 0x00017903,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x00000006,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x00000005,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000000,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000006,
		0x03E, 0x00008800,
		0x03F, 0x00037903,
		0x033, 0x00000005,
		0x03E, 0x00008805,
		0x03F, 0x00007903,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00007903,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00017903,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000000,
		0x03E, 0x00008922,
		0x03F, 0x00017903,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000006,
		0x03E, 0x00008802,
		0x03F, 0x00007903,
		0x033, 0x00000005,
		0x03E, 0x00008806,
		0x03F, 0x00007903,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00057903,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00017903,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00017903,
		0x033, 0x00000000,
		0x03E, 0x00008922,
		0x03F, 0x00017903,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000006,
		0x03E, 0x00008800,
		0x03F, 0x00047903,
		0x033, 0x00000005,
		0x03E, 0x00008805,
		0x03F, 0x00007903,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00007903,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00017903,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000000,
		0x03E, 0x00008922,
		0x03F, 0x00037903,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000006,
		0x03E, 0x00008801,
		0x03F, 0x00017903,
		0x033, 0x00000005,
		0x03E, 0x00008806,
		0x03F, 0x00007903,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00007903,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00027903,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000000,
		0x03E, 0x00008922,
		0x03F, 0x00017903,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x00000006,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x00000005,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000000,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
	0xA0000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x00000006,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x00000005,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000000,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x0000000E,
		0x03E, 0x00008802,
		0x03F, 0x00007903,
		0x033, 0x0000000D,
		0x03E, 0x00008806,
		0x03F, 0x00017903,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00027903,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000008,
		0x03E, 0x00008922,
		0x03F, 0x00007903,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x0000000E,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x0000000D,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000008,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x0000000E,
		0x03E, 0x00008802,
		0x03F, 0x00017903,
		0x033, 0x0000000D,
		0x03E, 0x00008806,
		0x03F, 0x00007903,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00077903,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000008,
		0x03E, 0x00008921,
		0x03F, 0x00007983,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x0000000E,
		0x03E, 0x00008800,
		0x03F, 0x00027903,
		0x033, 0x0000000D,
		0x03E, 0x00008805,
		0x03F, 0x00007903,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00027903,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000008,
		0x03E, 0x00008922,
		0x03F, 0x00047903,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x0000000E,
		0x03E, 0x00008802,
		0x03F, 0x00007903,
		0x033, 0x0000000D,
		0x03E, 0x00008806,
		0x03F, 0x00017903,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00027903,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000008,
		0x03E, 0x00008922,
		0x03F, 0x00007903,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x0000000E,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x0000000D,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000008,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x0000000E,
		0x03E, 0x00008801,
		0x03F, 0x00007903,
		0x033, 0x0000000D,
		0x03E, 0x00008805,
		0x03F, 0x00007903,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00027903,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000008,
		0x03E, 0x00008922,
		0x03F, 0x00027903,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x0000000E,
		0x03E, 0x00008802,
		0x03F, 0x00017903,
		0x033, 0x0000000D,
		0x03E, 0x00008806,
		0x03F, 0x00007903,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00077903,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000008,
		0x03E, 0x00008921,
		0x03F, 0x00007983,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x0000000E,
		0x03E, 0x00008800,
		0x03F, 0x00027903,
		0x033, 0x0000000D,
		0x03E, 0x00008805,
		0x03F, 0x00007903,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00027903,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000008,
		0x03E, 0x00008922,
		0x03F, 0x00047903,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x0000000E,
		0x03E, 0x00008802,
		0x03F, 0x00007903,
		0x033, 0x0000000D,
		0x03E, 0x00008806,
		0x03F, 0x00017903,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00027903,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000008,
		0x03E, 0x00008922,
		0x03F, 0x00007903,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x0000000E,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x0000000D,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000008,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
	0xA0000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x0000000E,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x0000000D,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000008,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000016,
		0x03E, 0x00008801,
		0x03F, 0x00007903,
		0x033, 0x00000015,
		0x03E, 0x00008804,
		0x03F, 0x00007903,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00017903,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000010,
		0x03E, 0x00008921,
		0x03F, 0x00007983,
		0x0EF, 0x00000000,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x00000016,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x00000015,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000010,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
		0x0EF, 0x00000000,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000016,
		0x03E, 0x00008801,
		0x03F, 0x00017903,
		0x033, 0x00000015,
		0x03E, 0x00008804,
		0x03F, 0x00007903,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00057903,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000010,
		0x03E, 0x00008921,
		0x03F, 0x00017903,
		0x0EF, 0x00000000,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000016,
		0x03E, 0x00008800,
		0x03F, 0x00047903,
		0x033, 0x00000015,
		0x03E, 0x00008802,
		0x03F, 0x00007903,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00017903,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000010,
		0x03E, 0x00008921,
		0x03F, 0x00007903,
		0x0EF, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000016,
		0x03E, 0x00008801,
		0x03F, 0x00007903,
		0x033, 0x00000015,
		0x03E, 0x00008804,
		0x03F, 0x00007903,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00017903,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000010,
		0x03E, 0x00008921,
		0x03F, 0x00007983,
		0x0EF, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x00000016,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x00000015,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000010,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
		0x0EF, 0x00000000,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000016,
		0x03E, 0x00008800,
		0x03F, 0x00027903,
		0x033, 0x00000015,
		0x03E, 0x00008802,
		0x03F, 0x00007903,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00017903,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000010,
		0x03E, 0x00008922,
		0x03F, 0x00007903,
		0x0EF, 0x00000000,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000016,
		0x03E, 0x00008801,
		0x03F, 0x00017903,
		0x033, 0x00000015,
		0x03E, 0x00008804,
		0x03F, 0x00007903,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00057903,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000010,
		0x03E, 0x00008921,
		0x03F, 0x00017903,
		0x0EF, 0x00000000,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000016,
		0x03E, 0x00008800,
		0x03F, 0x00047903,
		0x033, 0x00000015,
		0x03E, 0x00008802,
		0x03F, 0x00007903,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00017903,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000010,
		0x03E, 0x00008921,
		0x03F, 0x00007903,
		0x0EF, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000016,
		0x03E, 0x00008801,
		0x03F, 0x00007903,
		0x033, 0x00000015,
		0x03E, 0x00008804,
		0x03F, 0x00007903,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00017903,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000010,
		0x03E, 0x00008921,
		0x03F, 0x00007983,
		0x0EF, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x00000016,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x00000015,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000010,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x00000016,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x00000015,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000010,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x0000000D,
		0x033, 0x00000001,
		0x03F, 0x00000004,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x0000000D,
		0x033, 0x00000001,
		0x03F, 0x00000004,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x0000000D,
		0x033, 0x00000001,
		0x03F, 0x00000004,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x0000000D,
		0x033, 0x00000001,
		0x03F, 0x00000004,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x0000000D,
		0x033, 0x00000001,
		0x03F, 0x00000004,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x0000000D,
		0x033, 0x00000001,
		0x03F, 0x00000004,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x00000000,
		0x03F, 0x000C0000,
		0x033, 0x00000001,
		0x03F, 0x000C0000,
		0x0EF, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x00000000,
		0x03F, 0x000C0000,
		0x033, 0x00000001,
		0x03F, 0x000C0000,
		0x0EF, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x00000000,
		0x03F, 0x000C0000,
		0x033, 0x00000001,
		0x03F, 0x000C0000,
		0x0EF, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x00000000,
		0x03F, 0x000C0000,
		0x033, 0x00000001,
		0x03F, 0x000C0000,
		0x0EF, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x00000000,
		0x03F, 0x000C0000,
		0x033, 0x00000001,
		0x03F, 0x000C0000,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x00000000,
		0x03F, 0x000C0000,
		0x033, 0x00000001,
		0x03F, 0x000C0000,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0xA0000000,	0x00000000,
		0x018, 0x00013124,
	0xB0000000,	0x00000000,
		0x0FE, 0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x01B, 0x00000240,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x01B, 0x00000240,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x01B, 0x00000240,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x01B, 0x00000240,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x01B, 0x00000240,
	0xA0000000,	0x00000000,
		0x01B, 0x00000240,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000002,
		0x033, 0x00000010,
		0x03F, 0x00000104,
		0x033, 0x00000011,
		0x03F, 0x00000965,
		0x033, 0x00000012,
		0x03F, 0x00000A28,
		0x033, 0x00000013,
		0x03F, 0x00000B2C,
		0x0EE, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000002,
		0x033, 0x00000010,
		0x03F, 0x00000104,
		0x033, 0x00000011,
		0x03F, 0x00000965,
		0x033, 0x00000012,
		0x03F, 0x00000A28,
		0x033, 0x00000013,
		0x03F, 0x00000B2C,
		0x0EE, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000002,
		0x033, 0x00000010,
		0x03F, 0x00000104,
		0x033, 0x00000011,
		0x03F, 0x00000965,
		0x033, 0x00000012,
		0x03F, 0x00000A28,
		0x033, 0x00000013,
		0x03F, 0x00000B2C,
		0x0EE, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000002,
		0x033, 0x00000010,
		0x03F, 0x00000104,
		0x033, 0x00000011,
		0x03F, 0x00000965,
		0x033, 0x00000012,
		0x03F, 0x00000A28,
		0x033, 0x00000013,
		0x03F, 0x00000B2C,
		0x0EE, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000002,
		0x033, 0x00000010,
		0x03F, 0x00000104,
		0x033, 0x00000011,
		0x03F, 0x00000965,
		0x033, 0x00000012,
		0x03F, 0x00000A28,
		0x033, 0x00000013,
		0x03F, 0x00000B2C,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000002,
		0x033, 0x00000010,
		0x03F, 0x00000104,
		0x033, 0x00000011,
		0x03F, 0x00000965,
		0x033, 0x00000012,
		0x03F, 0x00000A28,
		0x033, 0x00000013,
		0x03F, 0x00000B2C,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0DE, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0DE, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0DE, 0x00080000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0DE, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0DE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0DE, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x057, 0x0004B5AA,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x057, 0x0004B5AA,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x057, 0x0004B5AA,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x057, 0x0004B5AA,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x057, 0x0004B5AA,
	0xA0000000,	0x00000000,
		0x057, 0x0004B5AA,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000010,
		0x008, 0x00078200,
		0x0EF, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000010,
		0x008, 0x00078200,
		0x0EF, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000010,
		0x008, 0x00078200,
		0x0EF, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000010,
		0x008, 0x00078200,
		0x0EF, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000010,
		0x008, 0x00078200,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000010,
		0x008, 0x00078200,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x018, 0x00000C03,
		0x08F, 0x00000AAC,
		0x069, 0x0000003F,
		0x067, 0x00084200,
		0x067, 0x00084201,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x018, 0x00000C03,
		0x08F, 0x00000AAC,
		0x069, 0x0000003F,
		0x067, 0x00084200,
		0x067, 0x00084201,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x018, 0x00000C03,
		0x08F, 0x00000AAC,
		0x069, 0x0000003F,
		0x067, 0x00084200,
		0x067, 0x00084201,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x018, 0x00000C03,
		0x08F, 0x00000AAC,
		0x069, 0x0000003F,
		0x067, 0x00084200,
		0x067, 0x00084201,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x018, 0x00000C03,
		0x08F, 0x00000AAC,
		0x069, 0x0000003F,
		0x067, 0x00084200,
		0x067, 0x00084201,
	0xA0000000,	0x00000000,
		0x000, 0x00030000,
		0x018, 0x00000C03,
		0x08F, 0x00000AAC,
		0x069, 0x0000003F,
		0x067, 0x00084200,
		0x067, 0x00084201,
	0xB0000000,	0x00000000,
		0xFFE, 0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x00084200,
		0x0DF, 0x00002000,
		0x082, 0x00003364,
		0x068, 0x00084210,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x00084200,
		0x0DF, 0x00002000,
		0x082, 0x00003364,
		0x068, 0x00084210,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x00084200,
		0x0DF, 0x00002000,
		0x082, 0x00003364,
		0x068, 0x00084210,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x00084200,
		0x0DF, 0x00002000,
		0x082, 0x00003364,
		0x068, 0x00084210,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x00084200,
		0x0DF, 0x00002000,
		0x082, 0x00003364,
		0x068, 0x00084210,
	0xA0000000,	0x00000000,
		0x067, 0x00084200,
		0x0DF, 0x00002000,
		0x082, 0x00003364,
		0x068, 0x00084210,
	0xB0000000,	0x00000000,
		0xFFE, 0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x082, 0x00003354,
		0x068, 0x00084210,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x082, 0x00003354,
		0x068, 0x00084210,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x082, 0x00003354,
		0x068, 0x00084210,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x082, 0x00003354,
		0x068, 0x00084210,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x082, 0x00003354,
		0x068, 0x00084210,
	0xA0000000,	0x00000000,
		0x068, 0x00084200,
		0x082, 0x00003354,
		0x068, 0x00084210,
	0xB0000000,	0x00000000,
		0xFFE, 0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x0DF, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x0DF, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x0DF, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x0DF, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x0DF, 0x00000000,
	0xA0000000,	0x00000000,
		0x068, 0x00084200,
		0x0DF, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x06F, 0x00014311,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x06F, 0x00014311,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x06F, 0x00014311,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x06F, 0x00014311,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x06F, 0x00014311,
	0xA0000000,	0x00000000,
		0x06F, 0x00014311,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x06E, 0x00000211,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x06E, 0x00000211,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x06E, 0x00000211,
	0x92000000,	0x00000000,	0x40000000,	0x00000000,
		0x06E, 0x00000311,
	0x92000003,	0x00000000,	0x40000000,	0x00000000,
		0x06E, 0x00000311,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x06E, 0x00000211,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x06E, 0x00000211,
	0xA0000000,	0x00000000,
		0x06E, 0x00000211,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0xFFFF, 0x0000FFFF,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0xFFFF, 0x0000FFFF,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0xFFFF, 0x0000FFFF,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0xFFFF, 0x0000FFFF,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0xFFFF, 0x0000FFFF,
	0xA0000000,	0x00000000,
		0xFFFF, 0x0000FFFF,
	0xB0000000,	0x00000000,

};

void
odm_read_and_config_mp_8814b_radiob(struct dm_struct *dm)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len =
			sizeof(array_mp_8814b_radiob) / sizeof(u32);
	u32	*array = (u32 *)array_mp_8814b_radiob;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;
	u32	a1 = 0, a2 = 0, a3 = 0, a4 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  =
					(u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT,
						  "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (!is_skipped) {
					a1 = pre_v1; a2 = pre_v2;
					a3 = v1; a4 = v2;
					if (check_positive(dm,
							   a1, a2, a3, a4)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else {
					is_matched = false;
				}
			}
		} else {
			if (is_matched)
				odm_config_rf_radio_b_8814b(dm, v1, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8814b_radiob(void)
{
		return 46;
}

/******************************************************************************
 *                           radioc.TXT
 ******************************************************************************/

const u32 array_mp_8814b_radioc[] = {
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x0008D9C0,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x00071C00,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x0008D9C0,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x0008D9C0,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x0008D9C0,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x00071C00,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x0008D9C0,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x0008D9C0,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x0008D9C0,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x0008D9C0,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x00071C00,
	0xA0000000,	0x00000000,
		0x058, 0x00071C00,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x0DD, 0x00000010,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x0DD, 0x00000010,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x0DD, 0x00000010,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x0DD, 0x00000010,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x0DD, 0x00000010,
	0xA0000000,	0x00000000,
		0x000, 0x00030000,
		0x0DD, 0x00000010,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000001,
		0x03E, 0x00000244,
		0x03F, 0x000000F7,
		0x033, 0x00000002,
		0x03E, 0x000003FC,
		0x03F, 0x000000F7,
		0x033, 0x00000003,
		0x03E, 0x00000245,
		0x03F, 0x000AFCF7,
		0x033, 0x00000004,
		0x03E, 0x000003F6,
		0x03F, 0x0000F9F7,
		0x033, 0x00000007,
		0x03E, 0x000003FD,
		0x03F, 0x000EFCF7,
		0x0EF, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000001,
		0x03E, 0x00000244,
		0x03F, 0x000000F7,
		0x033, 0x00000002,
		0x03E, 0x000003FC,
		0x03F, 0x000000F7,
		0x033, 0x00000003,
		0x03E, 0x00000245,
		0x03F, 0x000AFCF7,
		0x033, 0x00000004,
		0x03E, 0x000003F6,
		0x03F, 0x0000F9F7,
		0x033, 0x00000007,
		0x03E, 0x000003FD,
		0x03F, 0x000EFCF7,
		0x0EF, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000001,
		0x03E, 0x00000244,
		0x03F, 0x000000F7,
		0x033, 0x00000002,
		0x03E, 0x000003FC,
		0x03F, 0x000000F7,
		0x033, 0x00000003,
		0x03E, 0x00000245,
		0x03F, 0x000AFCF7,
		0x033, 0x00000004,
		0x03E, 0x000003F6,
		0x03F, 0x0000F9F7,
		0x033, 0x00000007,
		0x03E, 0x000003FD,
		0x03F, 0x000EFCF7,
		0x0EF, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000001,
		0x03E, 0x00000244,
		0x03F, 0x000000F7,
		0x033, 0x00000002,
		0x03E, 0x000003FC,
		0x03F, 0x000000F7,
		0x033, 0x00000003,
		0x03E, 0x00000245,
		0x03F, 0x000AFCF7,
		0x033, 0x00000004,
		0x03E, 0x000003F6,
		0x03F, 0x0000F9F7,
		0x033, 0x00000007,
		0x03E, 0x000003FD,
		0x03F, 0x000EFCF7,
		0x0EF, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000001,
		0x03E, 0x00000244,
		0x03F, 0x000000F7,
		0x033, 0x00000002,
		0x03E, 0x000003FC,
		0x03F, 0x000000F7,
		0x033, 0x00000003,
		0x03E, 0x00000245,
		0x03F, 0x000AFCF7,
		0x033, 0x00000004,
		0x03E, 0x000003F6,
		0x03F, 0x0000F9F7,
		0x033, 0x00000007,
		0x03E, 0x000003FD,
		0x03F, 0x000EFCF7,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000001,
		0x03E, 0x00000244,
		0x03F, 0x000000F7,
		0x033, 0x00000002,
		0x03E, 0x000003FC,
		0x03F, 0x000000F7,
		0x033, 0x00000003,
		0x03E, 0x00000245,
		0x03F, 0x000AFCF7,
		0x033, 0x00000004,
		0x03E, 0x000003F6,
		0x03F, 0x0000F9F7,
		0x033, 0x00000007,
		0x03E, 0x000003FD,
		0x03F, 0x000EFCF7,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x09E, 0x000F8009,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x09E, 0x000F8009,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x09E, 0x000F8009,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x09E, 0x000F8009,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x09E, 0x000F8009,
	0xA0000000,	0x00000000,
		0x09E, 0x000F8009,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0xA0000000,	0x00000000,
		0x018, 0x00013124,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00000006,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00000006,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00000006,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00000006,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00000006,
	0xA0000000,	0x00000000,
		0x018, 0x00000006,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x0005512D,
		0x080, 0x000CE800,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x0005516D,
		0x080, 0x000CE800,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x0005512D,
		0x080, 0x000CE800,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x0005516D,
		0x080, 0x000CE800,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x0005512D,
		0x080, 0x000CE800,
	0xA0000000,	0x00000000,
		0x087, 0x0005512D,
		0x080, 0x000CE800,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x082, 0x00003300,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x082, 0x00003300,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x082, 0x00003300,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x082, 0x00003300,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x082, 0x00003300,
	0xA0000000,	0x00000000,
		0x082, 0x00003300,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0C0, 0x0007FC00,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0C0, 0x0007FC00,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0C0, 0x0007FC00,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0C0, 0x0007FC00,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0C0, 0x0007FC00,
	0xA0000000,	0x00000000,
		0x0C0, 0x0007FC00,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x01A, 0x00040004,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x01A, 0x00040004,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x01A, 0x00040004,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x01A, 0x00040004,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x01A, 0x00040004,
	0xA0000000,	0x00000000,
		0x01A, 0x00040004,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0000D3A5,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0000D3A5,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0000D3A5,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0000D3A5,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0000D3A5,
	0xA0000000,	0x00000000,
		0x061, 0x0000D3A5,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00010000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00010000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00010000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00010000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00010000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00010000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000F04,
		0x033, 0x00000021,
		0x03F, 0x00000F64,
		0x033, 0x00000022,
		0x03F, 0x00002E04,
		0x033, 0x00000023,
		0x03F, 0x00004E85,
		0x033, 0x00000024,
		0x03F, 0x00004E88,
		0x033, 0x00000025,
		0x03F, 0x00006F05,
		0x033, 0x00000026,
		0x03F, 0x00006FE7,
		0x033, 0x00000027,
		0x03F, 0x00006FEA,
		0x033, 0x00000028,
		0x03F, 0x00006FED,
		0x033, 0x00000029,
		0x03F, 0x00006FF0,
		0x033, 0x0000002A,
		0x03F, 0x00006FF3,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000F04,
		0x033, 0x00000021,
		0x03F, 0x00000F64,
		0x033, 0x00000022,
		0x03F, 0x00002E04,
		0x033, 0x00000023,
		0x03F, 0x00004E85,
		0x033, 0x00000024,
		0x03F, 0x00004E88,
		0x033, 0x00000025,
		0x03F, 0x00006F05,
		0x033, 0x00000026,
		0x03F, 0x00006FE7,
		0x033, 0x00000027,
		0x03F, 0x00006FEA,
		0x033, 0x00000028,
		0x03F, 0x00006FED,
		0x033, 0x00000029,
		0x03F, 0x00006FF0,
		0x033, 0x0000002A,
		0x03F, 0x00006FF3,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000F04,
		0x033, 0x00000021,
		0x03F, 0x00000F64,
		0x033, 0x00000022,
		0x03F, 0x00002E04,
		0x033, 0x00000023,
		0x03F, 0x00004E85,
		0x033, 0x00000024,
		0x03F, 0x00004E88,
		0x033, 0x00000025,
		0x03F, 0x00006F05,
		0x033, 0x00000026,
		0x03F, 0x00006FE7,
		0x033, 0x00000027,
		0x03F, 0x00006FEA,
		0x033, 0x00000028,
		0x03F, 0x00006FED,
		0x033, 0x00000029,
		0x03F, 0x00006FF0,
		0x033, 0x0000002A,
		0x03F, 0x00006FF3,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000F04,
		0x033, 0x00000021,
		0x03F, 0x00000F64,
		0x033, 0x00000022,
		0x03F, 0x00002E04,
		0x033, 0x00000023,
		0x03F, 0x00004E85,
		0x033, 0x00000024,
		0x03F, 0x00004E88,
		0x033, 0x00000025,
		0x03F, 0x00006F05,
		0x033, 0x00000026,
		0x03F, 0x00006FE7,
		0x033, 0x00000027,
		0x03F, 0x00006FEA,
		0x033, 0x00000028,
		0x03F, 0x00006FED,
		0x033, 0x00000029,
		0x03F, 0x00006FF0,
		0x033, 0x0000002A,
		0x03F, 0x00006FF3,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000F04,
		0x033, 0x00000021,
		0x03F, 0x00000F64,
		0x033, 0x00000022,
		0x03F, 0x00002E04,
		0x033, 0x00000023,
		0x03F, 0x00004E85,
		0x033, 0x00000024,
		0x03F, 0x00004E88,
		0x033, 0x00000025,
		0x03F, 0x00006F05,
		0x033, 0x00000026,
		0x03F, 0x00006FE7,
		0x033, 0x00000027,
		0x03F, 0x00006FEA,
		0x033, 0x00000028,
		0x03F, 0x00006FED,
		0x033, 0x00000029,
		0x03F, 0x00006FF0,
		0x033, 0x0000002A,
		0x03F, 0x00006FF3,
	0xA0000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000F04,
		0x033, 0x00000021,
		0x03F, 0x00000F64,
		0x033, 0x00000022,
		0x03F, 0x00002E04,
		0x033, 0x00000023,
		0x03F, 0x00004E85,
		0x033, 0x00000024,
		0x03F, 0x00004E88,
		0x033, 0x00000025,
		0x03F, 0x00006F05,
		0x033, 0x00000026,
		0x03F, 0x00006FE7,
		0x033, 0x00000027,
		0x03F, 0x00006FEA,
		0x033, 0x00000028,
		0x03F, 0x00006FED,
		0x033, 0x00000029,
		0x03F, 0x00006FF0,
		0x033, 0x0000002A,
		0x03F, 0x00006FF3,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000F04,
		0x033, 0x00000061,
		0x03F, 0x00000F64,
		0x033, 0x00000062,
		0x03F, 0x00002E04,
		0x033, 0x00000063,
		0x03F, 0x00004E85,
		0x033, 0x00000064,
		0x03F, 0x00004E88,
		0x033, 0x00000065,
		0x03F, 0x00006F05,
		0x033, 0x00000066,
		0x03F, 0x00006FE7,
		0x033, 0x00000067,
		0x03F, 0x00006FEA,
		0x033, 0x00000068,
		0x03F, 0x00006FED,
		0x033, 0x00000069,
		0x03F, 0x00006FF0,
		0x033, 0x0000006A,
		0x03F, 0x00006FF3,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000E64,
		0x033, 0x00000061,
		0x03F, 0x00000E85,
		0x033, 0x00000062,
		0x03F, 0x00000EE4,
		0x033, 0x00000063,
		0x03F, 0x00000EE7,
		0x033, 0x00000064,
		0x03F, 0x00000EEA,
		0x033, 0x00000065,
		0x03F, 0x00004E65,
		0x033, 0x00000066,
		0x03F, 0x00002EA7,
		0x033, 0x00000067,
		0x03F, 0x00002EAA,
		0x033, 0x00000068,
		0x03F, 0x00002EAD,
		0x033, 0x00000069,
		0x03F, 0x00002EB0,
		0x033, 0x0000006A,
		0x03F, 0x00002EB3,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000E64,
		0x033, 0x00000061,
		0x03F, 0x00000E85,
		0x033, 0x00000062,
		0x03F, 0x00000EE4,
		0x033, 0x00000063,
		0x03F, 0x00000EE7,
		0x033, 0x00000064,
		0x03F, 0x00000EEA,
		0x033, 0x00000065,
		0x03F, 0x00004E65,
		0x033, 0x00000066,
		0x03F, 0x00002EA7,
		0x033, 0x00000067,
		0x03F, 0x00002EAA,
		0x033, 0x00000068,
		0x03F, 0x00002EAD,
		0x033, 0x00000069,
		0x03F, 0x00002EB0,
		0x033, 0x0000006A,
		0x03F, 0x00002EB3,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000E64,
		0x033, 0x00000061,
		0x03F, 0x00000E85,
		0x033, 0x00000062,
		0x03F, 0x00000EE4,
		0x033, 0x00000063,
		0x03F, 0x00000EE7,
		0x033, 0x00000064,
		0x03F, 0x00000EEA,
		0x033, 0x00000065,
		0x03F, 0x00004E65,
		0x033, 0x00000066,
		0x03F, 0x00002EA7,
		0x033, 0x00000067,
		0x03F, 0x00002EAA,
		0x033, 0x00000068,
		0x03F, 0x00002EAD,
		0x033, 0x00000069,
		0x03F, 0x00002EB0,
		0x033, 0x0000006A,
		0x03F, 0x00002EB3,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000E64,
		0x033, 0x00000061,
		0x03F, 0x00000E85,
		0x033, 0x00000062,
		0x03F, 0x00000EE4,
		0x033, 0x00000063,
		0x03F, 0x00000EE7,
		0x033, 0x00000064,
		0x03F, 0x00000EEA,
		0x033, 0x00000065,
		0x03F, 0x00004E65,
		0x033, 0x00000066,
		0x03F, 0x00002EA7,
		0x033, 0x00000067,
		0x03F, 0x00002EAA,
		0x033, 0x00000068,
		0x03F, 0x00002EAD,
		0x033, 0x00000069,
		0x03F, 0x00002EB0,
		0x033, 0x0000006A,
		0x03F, 0x00002EB3,
	0xA0000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000E64,
		0x033, 0x00000061,
		0x03F, 0x00000E85,
		0x033, 0x00000062,
		0x03F, 0x00000EE4,
		0x033, 0x00000063,
		0x03F, 0x00000EE7,
		0x033, 0x00000064,
		0x03F, 0x00000EEA,
		0x033, 0x00000065,
		0x03F, 0x00004E65,
		0x033, 0x00000066,
		0x03F, 0x00002EA7,
		0x033, 0x00000067,
		0x03F, 0x00002EAA,
		0x033, 0x00000068,
		0x03F, 0x00002EAD,
		0x033, 0x00000069,
		0x03F, 0x00002EB0,
		0x033, 0x0000006A,
		0x03F, 0x00002EB3,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000203,
		0x033, 0x00000201,
		0x03F, 0x00000206,
		0x033, 0x00000202,
		0x03F, 0x00000209,
		0x033, 0x00000203,
		0x03F, 0x00000226,
		0x033, 0x00000204,
		0x03F, 0x00000229,
		0x033, 0x00000205,
		0x03F, 0x00000266,
		0x033, 0x00000206,
		0x03F, 0x00000269,
		0x033, 0x00000207,
		0x03F, 0x0000026C,
		0x033, 0x00000208,
		0x03F, 0x00000469,
		0x033, 0x00000209,
		0x03F, 0x0000046C,
		0x033, 0x0000020A,
		0x03F, 0x0000046C,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000445,
		0x033, 0x00000201,
		0x03F, 0x00000448,
		0x033, 0x00000202,
		0x03F, 0x00000468,
		0x033, 0x00000203,
		0x03F, 0x00000668,
		0x033, 0x00000204,
		0x03F, 0x00000E67,
		0x033, 0x00000205,
		0x03F, 0x00000EA6,
		0x033, 0x00000206,
		0x03F, 0x00000EE7,
		0x033, 0x00000207,
		0x03F, 0x00000EEA,
		0x033, 0x00000208,
		0x03F, 0x00000EED,
		0x033, 0x00000209,
		0x03F, 0x00000EF0,
		0x033, 0x0000020A,
		0x03F, 0x00000EF3,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000203,
		0x033, 0x00000201,
		0x03F, 0x00000206,
		0x033, 0x00000202,
		0x03F, 0x00000209,
		0x033, 0x00000203,
		0x03F, 0x00000226,
		0x033, 0x00000204,
		0x03F, 0x00000229,
		0x033, 0x00000205,
		0x03F, 0x00000266,
		0x033, 0x00000206,
		0x03F, 0x00000269,
		0x033, 0x00000207,
		0x03F, 0x0000026C,
		0x033, 0x00000208,
		0x03F, 0x00000469,
		0x033, 0x00000209,
		0x03F, 0x0000046C,
		0x033, 0x0000020A,
		0x03F, 0x0000046C,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000203,
		0x033, 0x00000201,
		0x03F, 0x00000206,
		0x033, 0x00000202,
		0x03F, 0x00000209,
		0x033, 0x00000203,
		0x03F, 0x00000226,
		0x033, 0x00000204,
		0x03F, 0x00000229,
		0x033, 0x00000205,
		0x03F, 0x00000266,
		0x033, 0x00000206,
		0x03F, 0x00000269,
		0x033, 0x00000207,
		0x03F, 0x0000026C,
		0x033, 0x00000208,
		0x03F, 0x00000469,
		0x033, 0x00000209,
		0x03F, 0x0000046C,
		0x033, 0x0000020A,
		0x03F, 0x0000046C,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000203,
		0x033, 0x00000201,
		0x03F, 0x00000206,
		0x033, 0x00000202,
		0x03F, 0x00000209,
		0x033, 0x00000203,
		0x03F, 0x00000226,
		0x033, 0x00000204,
		0x03F, 0x00000229,
		0x033, 0x00000205,
		0x03F, 0x00000266,
		0x033, 0x00000206,
		0x03F, 0x00000269,
		0x033, 0x00000207,
		0x03F, 0x0000026C,
		0x033, 0x00000208,
		0x03F, 0x00000469,
		0x033, 0x00000209,
		0x03F, 0x0000046C,
		0x033, 0x0000020A,
		0x03F, 0x0000046C,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000445,
		0x033, 0x00000201,
		0x03F, 0x00000448,
		0x033, 0x00000202,
		0x03F, 0x00000468,
		0x033, 0x00000203,
		0x03F, 0x00000668,
		0x033, 0x00000204,
		0x03F, 0x00000E67,
		0x033, 0x00000205,
		0x03F, 0x00000EA6,
		0x033, 0x00000206,
		0x03F, 0x00000EE7,
		0x033, 0x00000207,
		0x03F, 0x00000EEA,
		0x033, 0x00000208,
		0x03F, 0x00000EED,
		0x033, 0x00000209,
		0x03F, 0x00000EF0,
		0x033, 0x0000020A,
		0x03F, 0x00000EF3,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000203,
		0x033, 0x00000201,
		0x03F, 0x00000206,
		0x033, 0x00000202,
		0x03F, 0x00000209,
		0x033, 0x00000203,
		0x03F, 0x00000226,
		0x033, 0x00000204,
		0x03F, 0x00000229,
		0x033, 0x00000205,
		0x03F, 0x00000266,
		0x033, 0x00000206,
		0x03F, 0x00000269,
		0x033, 0x00000207,
		0x03F, 0x0000026C,
		0x033, 0x00000208,
		0x03F, 0x00000469,
		0x033, 0x00000209,
		0x03F, 0x0000046C,
		0x033, 0x0000020A,
		0x03F, 0x0000046C,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000203,
		0x033, 0x00000201,
		0x03F, 0x00000206,
		0x033, 0x00000202,
		0x03F, 0x00000209,
		0x033, 0x00000203,
		0x03F, 0x00000226,
		0x033, 0x00000204,
		0x03F, 0x00000229,
		0x033, 0x00000205,
		0x03F, 0x00000266,
		0x033, 0x00000206,
		0x03F, 0x00000269,
		0x033, 0x00000207,
		0x03F, 0x0000026C,
		0x033, 0x00000208,
		0x03F, 0x00000469,
		0x033, 0x00000209,
		0x03F, 0x0000046C,
		0x033, 0x0000020A,
		0x03F, 0x0000046C,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000203,
		0x033, 0x00000201,
		0x03F, 0x00000206,
		0x033, 0x00000202,
		0x03F, 0x00000209,
		0x033, 0x00000203,
		0x03F, 0x00000226,
		0x033, 0x00000204,
		0x03F, 0x00000229,
		0x033, 0x00000205,
		0x03F, 0x00000266,
		0x033, 0x00000206,
		0x03F, 0x00000269,
		0x033, 0x00000207,
		0x03F, 0x0000026C,
		0x033, 0x00000208,
		0x03F, 0x00000469,
		0x033, 0x00000209,
		0x03F, 0x0000046C,
		0x033, 0x0000020A,
		0x03F, 0x0000046C,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000203,
		0x033, 0x00000201,
		0x03F, 0x00000206,
		0x033, 0x00000202,
		0x03F, 0x00000209,
		0x033, 0x00000203,
		0x03F, 0x00000226,
		0x033, 0x00000204,
		0x03F, 0x00000229,
		0x033, 0x00000205,
		0x03F, 0x00000266,
		0x033, 0x00000206,
		0x03F, 0x00000269,
		0x033, 0x00000207,
		0x03F, 0x0000026C,
		0x033, 0x00000208,
		0x03F, 0x00000469,
		0x033, 0x00000209,
		0x03F, 0x0000046C,
		0x033, 0x0000020A,
		0x03F, 0x0000046C,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000445,
		0x033, 0x00000201,
		0x03F, 0x00000448,
		0x033, 0x00000202,
		0x03F, 0x00000468,
		0x033, 0x00000203,
		0x03F, 0x00000668,
		0x033, 0x00000204,
		0x03F, 0x00000E67,
		0x033, 0x00000205,
		0x03F, 0x00000EA6,
		0x033, 0x00000206,
		0x03F, 0x00000EE7,
		0x033, 0x00000207,
		0x03F, 0x00000EEA,
		0x033, 0x00000208,
		0x03F, 0x00000EED,
		0x033, 0x00000209,
		0x03F, 0x00000EF0,
		0x033, 0x0000020A,
		0x03F, 0x00000EF3,
	0xA0000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000445,
		0x033, 0x00000201,
		0x03F, 0x00000448,
		0x033, 0x00000202,
		0x03F, 0x00000468,
		0x033, 0x00000203,
		0x03F, 0x00000668,
		0x033, 0x00000204,
		0x03F, 0x00000E67,
		0x033, 0x00000205,
		0x03F, 0x00000EA6,
		0x033, 0x00000206,
		0x03F, 0x00000EE7,
		0x033, 0x00000207,
		0x03F, 0x00000EEA,
		0x033, 0x00000208,
		0x03F, 0x00000EED,
		0x033, 0x00000209,
		0x03F, 0x00000EF0,
		0x033, 0x0000020A,
		0x03F, 0x00000EF3,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000203,
		0x033, 0x00000281,
		0x03F, 0x00000206,
		0x033, 0x00000282,
		0x03F, 0x00000209,
		0x033, 0x00000283,
		0x03F, 0x00000226,
		0x033, 0x00000284,
		0x03F, 0x00000229,
		0x033, 0x00000285,
		0x03F, 0x00000266,
		0x033, 0x00000286,
		0x03F, 0x00000269,
		0x033, 0x00000287,
		0x03F, 0x0000026C,
		0x033, 0x00000288,
		0x03F, 0x00000469,
		0x033, 0x00000289,
		0x03F, 0x0000046C,
		0x033, 0x0000028A,
		0x03F, 0x0000046C,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000445,
		0x033, 0x00000281,
		0x03F, 0x00000465,
		0x033, 0x00000282,
		0x03F, 0x00000468,
		0x033, 0x00000283,
		0x03F, 0x00000668,
		0x033, 0x00000284,
		0x03F, 0x00000E67,
		0x033, 0x00000285,
		0x03F, 0x00000EA6,
		0x033, 0x00000286,
		0x03F, 0x00000EE7,
		0x033, 0x00000287,
		0x03F, 0x00000EEA,
		0x033, 0x00000288,
		0x03F, 0x00000EED,
		0x033, 0x00000289,
		0x03F, 0x00000EF0,
		0x033, 0x0000028A,
		0x03F, 0x00000EF3,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000203,
		0x033, 0x00000281,
		0x03F, 0x00000206,
		0x033, 0x00000282,
		0x03F, 0x00000209,
		0x033, 0x00000283,
		0x03F, 0x00000226,
		0x033, 0x00000284,
		0x03F, 0x00000229,
		0x033, 0x00000285,
		0x03F, 0x00000266,
		0x033, 0x00000286,
		0x03F, 0x00000269,
		0x033, 0x00000287,
		0x03F, 0x0000026C,
		0x033, 0x00000288,
		0x03F, 0x00000469,
		0x033, 0x00000289,
		0x03F, 0x0000046C,
		0x033, 0x0000028A,
		0x03F, 0x0000046C,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000203,
		0x033, 0x00000281,
		0x03F, 0x00000206,
		0x033, 0x00000282,
		0x03F, 0x00000209,
		0x033, 0x00000283,
		0x03F, 0x00000226,
		0x033, 0x00000284,
		0x03F, 0x00000229,
		0x033, 0x00000285,
		0x03F, 0x00000266,
		0x033, 0x00000286,
		0x03F, 0x00000269,
		0x033, 0x00000287,
		0x03F, 0x0000026C,
		0x033, 0x00000288,
		0x03F, 0x00000469,
		0x033, 0x00000289,
		0x03F, 0x0000046C,
		0x033, 0x0000028A,
		0x03F, 0x0000046C,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000203,
		0x033, 0x00000281,
		0x03F, 0x00000206,
		0x033, 0x00000282,
		0x03F, 0x00000209,
		0x033, 0x00000283,
		0x03F, 0x00000226,
		0x033, 0x00000284,
		0x03F, 0x00000229,
		0x033, 0x00000285,
		0x03F, 0x00000266,
		0x033, 0x00000286,
		0x03F, 0x00000269,
		0x033, 0x00000287,
		0x03F, 0x0000026C,
		0x033, 0x00000288,
		0x03F, 0x00000469,
		0x033, 0x00000289,
		0x03F, 0x0000046C,
		0x033, 0x0000028A,
		0x03F, 0x0000046C,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000445,
		0x033, 0x00000281,
		0x03F, 0x00000465,
		0x033, 0x00000282,
		0x03F, 0x00000468,
		0x033, 0x00000283,
		0x03F, 0x00000668,
		0x033, 0x00000284,
		0x03F, 0x00000E67,
		0x033, 0x00000285,
		0x03F, 0x00000EA6,
		0x033, 0x00000286,
		0x03F, 0x00000EE7,
		0x033, 0x00000287,
		0x03F, 0x00000EEA,
		0x033, 0x00000288,
		0x03F, 0x00000EED,
		0x033, 0x00000289,
		0x03F, 0x00000EF0,
		0x033, 0x0000028A,
		0x03F, 0x00000EF3,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000203,
		0x033, 0x00000281,
		0x03F, 0x00000206,
		0x033, 0x00000282,
		0x03F, 0x00000209,
		0x033, 0x00000283,
		0x03F, 0x00000226,
		0x033, 0x00000284,
		0x03F, 0x00000229,
		0x033, 0x00000285,
		0x03F, 0x00000266,
		0x033, 0x00000286,
		0x03F, 0x00000269,
		0x033, 0x00000287,
		0x03F, 0x0000026C,
		0x033, 0x00000288,
		0x03F, 0x00000469,
		0x033, 0x00000289,
		0x03F, 0x0000046C,
		0x033, 0x0000028A,
		0x03F, 0x0000046C,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000203,
		0x033, 0x00000281,
		0x03F, 0x00000206,
		0x033, 0x00000282,
		0x03F, 0x00000209,
		0x033, 0x00000283,
		0x03F, 0x00000226,
		0x033, 0x00000284,
		0x03F, 0x00000229,
		0x033, 0x00000285,
		0x03F, 0x00000266,
		0x033, 0x00000286,
		0x03F, 0x00000269,
		0x033, 0x00000287,
		0x03F, 0x0000026C,
		0x033, 0x00000288,
		0x03F, 0x00000469,
		0x033, 0x00000289,
		0x03F, 0x0000046C,
		0x033, 0x0000028A,
		0x03F, 0x0000046C,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000203,
		0x033, 0x00000281,
		0x03F, 0x00000206,
		0x033, 0x00000282,
		0x03F, 0x00000209,
		0x033, 0x00000283,
		0x03F, 0x00000226,
		0x033, 0x00000284,
		0x03F, 0x00000229,
		0x033, 0x00000285,
		0x03F, 0x00000266,
		0x033, 0x00000286,
		0x03F, 0x00000269,
		0x033, 0x00000287,
		0x03F, 0x0000026C,
		0x033, 0x00000288,
		0x03F, 0x00000469,
		0x033, 0x00000289,
		0x03F, 0x0000046C,
		0x033, 0x0000028A,
		0x03F, 0x0000046C,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000203,
		0x033, 0x00000281,
		0x03F, 0x00000206,
		0x033, 0x00000282,
		0x03F, 0x00000209,
		0x033, 0x00000283,
		0x03F, 0x00000226,
		0x033, 0x00000284,
		0x03F, 0x00000229,
		0x033, 0x00000285,
		0x03F, 0x00000266,
		0x033, 0x00000286,
		0x03F, 0x00000269,
		0x033, 0x00000287,
		0x03F, 0x0000026C,
		0x033, 0x00000288,
		0x03F, 0x00000469,
		0x033, 0x00000289,
		0x03F, 0x0000046C,
		0x033, 0x0000028A,
		0x03F, 0x0000046C,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000445,
		0x033, 0x00000281,
		0x03F, 0x00000465,
		0x033, 0x00000282,
		0x03F, 0x00000468,
		0x033, 0x00000283,
		0x03F, 0x00000668,
		0x033, 0x00000284,
		0x03F, 0x00000E67,
		0x033, 0x00000285,
		0x03F, 0x00000EA6,
		0x033, 0x00000286,
		0x03F, 0x00000EE7,
		0x033, 0x00000287,
		0x03F, 0x00000EEA,
		0x033, 0x00000288,
		0x03F, 0x00000EED,
		0x033, 0x00000289,
		0x03F, 0x00000EF0,
		0x033, 0x0000028A,
		0x03F, 0x00000EF3,
	0xA0000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000445,
		0x033, 0x00000281,
		0x03F, 0x00000465,
		0x033, 0x00000282,
		0x03F, 0x00000468,
		0x033, 0x00000283,
		0x03F, 0x00000668,
		0x033, 0x00000284,
		0x03F, 0x00000E67,
		0x033, 0x00000285,
		0x03F, 0x00000EA6,
		0x033, 0x00000286,
		0x03F, 0x00000EE7,
		0x033, 0x00000287,
		0x03F, 0x00000EEA,
		0x033, 0x00000288,
		0x03F, 0x00000EED,
		0x033, 0x00000289,
		0x03F, 0x00000EF0,
		0x033, 0x0000028A,
		0x03F, 0x00000EF3,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000203,
		0x033, 0x00000301,
		0x03F, 0x00000206,
		0x033, 0x00000302,
		0x03F, 0x00000209,
		0x033, 0x00000303,
		0x03F, 0x00000226,
		0x033, 0x00000304,
		0x03F, 0x00000229,
		0x033, 0x00000305,
		0x03F, 0x00000266,
		0x033, 0x00000306,
		0x03F, 0x00000269,
		0x033, 0x00000307,
		0x03F, 0x0000026C,
		0x033, 0x00000308,
		0x03F, 0x00000469,
		0x033, 0x00000309,
		0x03F, 0x0000046C,
		0x033, 0x0000030A,
		0x03F, 0x0000046C,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000445,
		0x033, 0x00000301,
		0x03F, 0x00000465,
		0x033, 0x00000302,
		0x03F, 0x00000468,
		0x033, 0x00000303,
		0x03F, 0x00000668,
		0x033, 0x00000304,
		0x03F, 0x00000E67,
		0x033, 0x00000305,
		0x03F, 0x00000EA6,
		0x033, 0x00000306,
		0x03F, 0x00000EE7,
		0x033, 0x00000307,
		0x03F, 0x00000EEA,
		0x033, 0x00000308,
		0x03F, 0x00000EED,
		0x033, 0x00000309,
		0x03F, 0x00000EF0,
		0x033, 0x0000030A,
		0x03F, 0x00000EF3,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000203,
		0x033, 0x00000301,
		0x03F, 0x00000206,
		0x033, 0x00000302,
		0x03F, 0x00000209,
		0x033, 0x00000303,
		0x03F, 0x00000226,
		0x033, 0x00000304,
		0x03F, 0x00000229,
		0x033, 0x00000305,
		0x03F, 0x00000266,
		0x033, 0x00000306,
		0x03F, 0x00000269,
		0x033, 0x00000307,
		0x03F, 0x0000026C,
		0x033, 0x00000308,
		0x03F, 0x00000469,
		0x033, 0x00000309,
		0x03F, 0x0000046C,
		0x033, 0x0000030A,
		0x03F, 0x0000046C,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000203,
		0x033, 0x00000301,
		0x03F, 0x00000206,
		0x033, 0x00000302,
		0x03F, 0x00000209,
		0x033, 0x00000303,
		0x03F, 0x00000226,
		0x033, 0x00000304,
		0x03F, 0x00000229,
		0x033, 0x00000305,
		0x03F, 0x00000266,
		0x033, 0x00000306,
		0x03F, 0x00000269,
		0x033, 0x00000307,
		0x03F, 0x0000026C,
		0x033, 0x00000308,
		0x03F, 0x00000469,
		0x033, 0x00000309,
		0x03F, 0x0000046C,
		0x033, 0x0000030A,
		0x03F, 0x0000046C,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000203,
		0x033, 0x00000301,
		0x03F, 0x00000206,
		0x033, 0x00000302,
		0x03F, 0x00000209,
		0x033, 0x00000303,
		0x03F, 0x00000226,
		0x033, 0x00000304,
		0x03F, 0x00000229,
		0x033, 0x00000305,
		0x03F, 0x00000266,
		0x033, 0x00000306,
		0x03F, 0x00000269,
		0x033, 0x00000307,
		0x03F, 0x0000026C,
		0x033, 0x00000308,
		0x03F, 0x00000469,
		0x033, 0x00000309,
		0x03F, 0x0000046C,
		0x033, 0x0000030A,
		0x03F, 0x0000046C,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000445,
		0x033, 0x00000301,
		0x03F, 0x00000465,
		0x033, 0x00000302,
		0x03F, 0x00000468,
		0x033, 0x00000303,
		0x03F, 0x00000668,
		0x033, 0x00000304,
		0x03F, 0x00000E67,
		0x033, 0x00000305,
		0x03F, 0x00000EA6,
		0x033, 0x00000306,
		0x03F, 0x00000EE7,
		0x033, 0x00000307,
		0x03F, 0x00000EEA,
		0x033, 0x00000308,
		0x03F, 0x00000EED,
		0x033, 0x00000309,
		0x03F, 0x00000EF0,
		0x033, 0x0000030A,
		0x03F, 0x00000EF3,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000203,
		0x033, 0x00000301,
		0x03F, 0x00000206,
		0x033, 0x00000302,
		0x03F, 0x00000209,
		0x033, 0x00000303,
		0x03F, 0x00000226,
		0x033, 0x00000304,
		0x03F, 0x00000229,
		0x033, 0x00000305,
		0x03F, 0x00000266,
		0x033, 0x00000306,
		0x03F, 0x00000269,
		0x033, 0x00000307,
		0x03F, 0x0000026C,
		0x033, 0x00000308,
		0x03F, 0x00000469,
		0x033, 0x00000309,
		0x03F, 0x0000046C,
		0x033, 0x0000030A,
		0x03F, 0x0000046C,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000203,
		0x033, 0x00000301,
		0x03F, 0x00000206,
		0x033, 0x00000302,
		0x03F, 0x00000209,
		0x033, 0x00000303,
		0x03F, 0x00000226,
		0x033, 0x00000304,
		0x03F, 0x00000229,
		0x033, 0x00000305,
		0x03F, 0x00000266,
		0x033, 0x00000306,
		0x03F, 0x00000269,
		0x033, 0x00000307,
		0x03F, 0x0000026C,
		0x033, 0x00000308,
		0x03F, 0x00000469,
		0x033, 0x00000309,
		0x03F, 0x0000046C,
		0x033, 0x0000030A,
		0x03F, 0x0000046C,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000203,
		0x033, 0x00000301,
		0x03F, 0x00000206,
		0x033, 0x00000302,
		0x03F, 0x00000209,
		0x033, 0x00000303,
		0x03F, 0x00000226,
		0x033, 0x00000304,
		0x03F, 0x00000229,
		0x033, 0x00000305,
		0x03F, 0x00000266,
		0x033, 0x00000306,
		0x03F, 0x00000269,
		0x033, 0x00000307,
		0x03F, 0x0000026C,
		0x033, 0x00000308,
		0x03F, 0x00000469,
		0x033, 0x00000309,
		0x03F, 0x0000046C,
		0x033, 0x0000030A,
		0x03F, 0x0000046C,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000203,
		0x033, 0x00000301,
		0x03F, 0x00000206,
		0x033, 0x00000302,
		0x03F, 0x00000209,
		0x033, 0x00000303,
		0x03F, 0x00000226,
		0x033, 0x00000304,
		0x03F, 0x00000229,
		0x033, 0x00000305,
		0x03F, 0x00000266,
		0x033, 0x00000306,
		0x03F, 0x00000269,
		0x033, 0x00000307,
		0x03F, 0x0000026C,
		0x033, 0x00000308,
		0x03F, 0x00000469,
		0x033, 0x00000309,
		0x03F, 0x0000046C,
		0x033, 0x0000030A,
		0x03F, 0x0000046C,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000445,
		0x033, 0x00000301,
		0x03F, 0x00000465,
		0x033, 0x00000302,
		0x03F, 0x00000468,
		0x033, 0x00000303,
		0x03F, 0x00000668,
		0x033, 0x00000304,
		0x03F, 0x00000E67,
		0x033, 0x00000305,
		0x03F, 0x00000EA6,
		0x033, 0x00000306,
		0x03F, 0x00000EE7,
		0x033, 0x00000307,
		0x03F, 0x00000EEA,
		0x033, 0x00000308,
		0x03F, 0x00000EED,
		0x033, 0x00000309,
		0x03F, 0x00000EF0,
		0x033, 0x0000030A,
		0x03F, 0x00000EF3,
	0xA0000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000445,
		0x033, 0x00000301,
		0x03F, 0x00000465,
		0x033, 0x00000302,
		0x03F, 0x00000468,
		0x033, 0x00000303,
		0x03F, 0x00000668,
		0x033, 0x00000304,
		0x03F, 0x00000E67,
		0x033, 0x00000305,
		0x03F, 0x00000EA6,
		0x033, 0x00000306,
		0x03F, 0x00000EE7,
		0x033, 0x00000307,
		0x03F, 0x00000EEA,
		0x033, 0x00000308,
		0x03F, 0x00000EED,
		0x033, 0x00000309,
		0x03F, 0x00000EF0,
		0x033, 0x0000030A,
		0x03F, 0x00000EF3,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00040000,
		0x033, 0x00000001,
		0x03F, 0x000C0001,
		0x0EE, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00040000,
		0x033, 0x00000001,
		0x03F, 0x000C0001,
		0x0EE, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00040000,
		0x033, 0x00000001,
		0x03F, 0x000C0001,
		0x0EE, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00040000,
		0x033, 0x00000001,
		0x03F, 0x000C0001,
		0x0EE, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00040000,
		0x033, 0x00000001,
		0x03F, 0x000C0001,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00040000,
		0x033, 0x00000001,
		0x03F, 0x000C0001,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x030, 0x00000000,
		0x03F, 0x000150F9,
		0x030, 0x00010000,
		0x03F, 0x000150F9,
		0x030, 0x00020000,
		0x03F, 0x000150F9,
		0x030, 0x00030000,
		0x03F, 0x000150F9,
		0x030, 0x00040000,
		0x03F, 0x000150F9,
		0x030, 0x00050000,
		0x03F, 0x000150F9,
		0x030, 0x00060000,
		0x03F, 0x000150F9,
		0x030, 0x00070000,
		0x03F, 0x000150F9,
		0x030, 0x00080000,
		0x03F, 0x000150F9,
		0x030, 0x00090000,
		0x03F, 0x000150F9,
		0x030, 0x000A0000,
		0x03F, 0x000150F9,
		0x030, 0x000B0000,
		0x03F, 0x000150F9,
		0x030, 0x000C0000,
		0x03F, 0x000150F9,
		0x030, 0x000D0000,
		0x03F, 0x000150F9,
		0x030, 0x000E0000,
		0x03F, 0x000150F9,
		0x030, 0x000F0000,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x030, 0x00000000,
		0x03F, 0x000150F9,
		0x030, 0x00010000,
		0x03F, 0x000150F9,
		0x030, 0x00020000,
		0x03F, 0x000150F9,
		0x030, 0x00030000,
		0x03F, 0x000150F9,
		0x030, 0x00040000,
		0x03F, 0x000150F9,
		0x030, 0x00050000,
		0x03F, 0x000150F9,
		0x030, 0x00060000,
		0x03F, 0x000150F9,
		0x030, 0x00070000,
		0x03F, 0x000150F9,
		0x030, 0x00080000,
		0x03F, 0x000150F9,
		0x030, 0x00090000,
		0x03F, 0x000150F9,
		0x030, 0x000A0000,
		0x03F, 0x000150F9,
		0x030, 0x000B0000,
		0x03F, 0x000150F9,
		0x030, 0x000C0000,
		0x03F, 0x000150F9,
		0x030, 0x000D0000,
		0x03F, 0x000150F9,
		0x030, 0x000E0000,
		0x03F, 0x000150F9,
		0x030, 0x000F0000,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x030, 0x00000000,
		0x03F, 0x000150F9,
		0x030, 0x00010000,
		0x03F, 0x000150F9,
		0x030, 0x00020000,
		0x03F, 0x000150F9,
		0x030, 0x00030000,
		0x03F, 0x000150F9,
		0x030, 0x00040000,
		0x03F, 0x000150F9,
		0x030, 0x00050000,
		0x03F, 0x000150F9,
		0x030, 0x00060000,
		0x03F, 0x000150F9,
		0x030, 0x00070000,
		0x03F, 0x000150F9,
		0x030, 0x00080000,
		0x03F, 0x000150F9,
		0x030, 0x00090000,
		0x03F, 0x000150F9,
		0x030, 0x000A0000,
		0x03F, 0x000150F9,
		0x030, 0x000B0000,
		0x03F, 0x000150F9,
		0x030, 0x000C0000,
		0x03F, 0x000150F9,
		0x030, 0x000D0000,
		0x03F, 0x000150F9,
		0x030, 0x000E0000,
		0x03F, 0x000150F9,
		0x030, 0x000F0000,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x030, 0x00000000,
		0x03F, 0x000150F9,
		0x030, 0x00010000,
		0x03F, 0x000150F9,
		0x030, 0x00020000,
		0x03F, 0x000150F9,
		0x030, 0x00030000,
		0x03F, 0x000150F9,
		0x030, 0x00040000,
		0x03F, 0x000150F9,
		0x030, 0x00050000,
		0x03F, 0x000150F9,
		0x030, 0x00060000,
		0x03F, 0x000150F9,
		0x030, 0x00070000,
		0x03F, 0x000150F9,
		0x030, 0x00080000,
		0x03F, 0x000150F9,
		0x030, 0x00090000,
		0x03F, 0x000150F9,
		0x030, 0x000A0000,
		0x03F, 0x000150F9,
		0x030, 0x000B0000,
		0x03F, 0x000150F9,
		0x030, 0x000C0000,
		0x03F, 0x000150F9,
		0x030, 0x000D0000,
		0x03F, 0x000150F9,
		0x030, 0x000E0000,
		0x03F, 0x000150F9,
		0x030, 0x000F0000,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x030, 0x00000000,
		0x03F, 0x000150F9,
		0x030, 0x00010000,
		0x03F, 0x000150F9,
		0x030, 0x00020000,
		0x03F, 0x000150F9,
		0x030, 0x00030000,
		0x03F, 0x000150F9,
		0x030, 0x00040000,
		0x03F, 0x000150F9,
		0x030, 0x00050000,
		0x03F, 0x000150F9,
		0x030, 0x00060000,
		0x03F, 0x000150F9,
		0x030, 0x00070000,
		0x03F, 0x000150F9,
		0x030, 0x00080000,
		0x03F, 0x000150F9,
		0x030, 0x00090000,
		0x03F, 0x000150F9,
		0x030, 0x000A0000,
		0x03F, 0x000150F9,
		0x030, 0x000B0000,
		0x03F, 0x000150F9,
		0x030, 0x000C0000,
		0x03F, 0x000150F9,
		0x030, 0x000D0000,
		0x03F, 0x000150F9,
		0x030, 0x000E0000,
		0x03F, 0x000150F9,
		0x030, 0x000F0000,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000400,
		0x030, 0x00000000,
		0x03F, 0x000150F9,
		0x030, 0x00010000,
		0x03F, 0x000150F9,
		0x030, 0x00020000,
		0x03F, 0x000150F9,
		0x030, 0x00030000,
		0x03F, 0x000150F9,
		0x030, 0x00040000,
		0x03F, 0x000150F9,
		0x030, 0x00050000,
		0x03F, 0x000150F9,
		0x030, 0x00060000,
		0x03F, 0x000150F9,
		0x030, 0x00070000,
		0x03F, 0x000150F9,
		0x030, 0x00080000,
		0x03F, 0x000150F9,
		0x030, 0x00090000,
		0x03F, 0x000150F9,
		0x030, 0x000A0000,
		0x03F, 0x000150F9,
		0x030, 0x000B0000,
		0x03F, 0x000150F9,
		0x030, 0x000C0000,
		0x03F, 0x000150F9,
		0x030, 0x000D0000,
		0x03F, 0x000150F9,
		0x030, 0x000E0000,
		0x03F, 0x000150F9,
		0x030, 0x000F0000,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000001,
		0x03F, 0x000150F9,
		0x033, 0x0000000B,
		0x03F, 0x000150F9,
		0x033, 0x00000023,
		0x03F, 0x000150F9,
		0x033, 0x00000029,
		0x03F, 0x000150F9,
		0x033, 0x0000002A,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000001,
		0x03F, 0x000150F9,
		0x033, 0x0000000B,
		0x03F, 0x000150F9,
		0x033, 0x00000023,
		0x03F, 0x000150F9,
		0x033, 0x00000029,
		0x03F, 0x000150F9,
		0x033, 0x0000002A,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000001,
		0x03F, 0x000150F9,
		0x033, 0x0000000B,
		0x03F, 0x000150F9,
		0x033, 0x00000023,
		0x03F, 0x000150F9,
		0x033, 0x00000029,
		0x03F, 0x000150F9,
		0x033, 0x0000002A,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000001,
		0x03F, 0x000150F9,
		0x033, 0x0000000B,
		0x03F, 0x000150F9,
		0x033, 0x00000023,
		0x03F, 0x000150F9,
		0x033, 0x00000029,
		0x03F, 0x000150F9,
		0x033, 0x0000002A,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000001,
		0x03F, 0x000150F9,
		0x033, 0x0000000B,
		0x03F, 0x000150F9,
		0x033, 0x00000023,
		0x03F, 0x000150F9,
		0x033, 0x00000029,
		0x03F, 0x000150F9,
		0x033, 0x0000002A,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000001,
		0x03F, 0x000150F9,
		0x033, 0x0000000B,
		0x03F, 0x000150F9,
		0x033, 0x00000023,
		0x03F, 0x000150F9,
		0x033, 0x00000029,
		0x03F, 0x000150F9,
		0x033, 0x0000002A,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x000000A4,
		0x030, 0x000010A4,
		0x030, 0x000020A4,
		0x030, 0x000030A4,
		0x030, 0x000040D4,
		0x030, 0x000050D4,
		0x030, 0x000060D4,
		0x030, 0x000070D4,
		0x030, 0x000080B4,
		0x030, 0x000090B4,
		0x030, 0x0000A0B4,
		0x030, 0x0000B0B4,
		0x0EE, 0x00000000,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x000002A4,
		0x030, 0x000012A4,
		0x030, 0x000022A4,
		0x030, 0x000032A4,
		0x030, 0x000042A4,
		0x030, 0x000052A4,
		0x030, 0x000062A4,
		0x030, 0x000072A4,
		0x030, 0x000083B4,
		0x030, 0x000093B4,
		0x030, 0x0000A3B4,
		0x030, 0x0000B3B4,
		0x0EE, 0x00000000,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x000000A4,
		0x030, 0x000010A4,
		0x030, 0x000020A4,
		0x030, 0x000030A4,
		0x030, 0x000040D4,
		0x030, 0x000050D4,
		0x030, 0x000060D4,
		0x030, 0x000070D4,
		0x030, 0x000080B4,
		0x030, 0x000090B4,
		0x030, 0x0000A0B4,
		0x030, 0x0000B0B4,
		0x0EE, 0x00000000,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x000000A4,
		0x030, 0x000010A4,
		0x030, 0x000020A4,
		0x030, 0x000030A4,
		0x030, 0x000040D4,
		0x030, 0x000050D4,
		0x030, 0x000060D4,
		0x030, 0x000070D4,
		0x030, 0x000080B4,
		0x030, 0x000090B4,
		0x030, 0x0000A0B4,
		0x030, 0x0000B0B4,
		0x0EE, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x000000A4,
		0x030, 0x000010A4,
		0x030, 0x000020A4,
		0x030, 0x000030A4,
		0x030, 0x000040D4,
		0x030, 0x000050D4,
		0x030, 0x000060D4,
		0x030, 0x000070D4,
		0x030, 0x000080B4,
		0x030, 0x000090B4,
		0x030, 0x0000A0B4,
		0x030, 0x0000B0B4,
		0x0EE, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x000002A4,
		0x030, 0x000012A4,
		0x030, 0x000022A4,
		0x030, 0x000032A4,
		0x030, 0x000042A4,
		0x030, 0x000052A4,
		0x030, 0x000062A4,
		0x030, 0x000072A4,
		0x030, 0x000083B4,
		0x030, 0x000093B4,
		0x030, 0x0000A3B4,
		0x030, 0x0000B3B4,
		0x0EE, 0x00000000,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x000000A4,
		0x030, 0x000010A4,
		0x030, 0x000020A4,
		0x030, 0x000030A4,
		0x030, 0x000040D4,
		0x030, 0x000050D4,
		0x030, 0x000060D4,
		0x030, 0x000070D4,
		0x030, 0x000080B4,
		0x030, 0x000090B4,
		0x030, 0x0000A0B4,
		0x030, 0x0000B0B4,
		0x0EE, 0x00000000,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x000000A4,
		0x030, 0x000010A4,
		0x030, 0x000020A4,
		0x030, 0x000030A4,
		0x030, 0x000040D4,
		0x030, 0x000050D4,
		0x030, 0x000060D4,
		0x030, 0x000070D4,
		0x030, 0x000080B4,
		0x030, 0x000090B4,
		0x030, 0x0000A0B4,
		0x030, 0x0000B0B4,
		0x0EE, 0x00000000,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x000000A4,
		0x030, 0x000010A4,
		0x030, 0x000020A4,
		0x030, 0x000030A4,
		0x030, 0x000040D4,
		0x030, 0x000050D4,
		0x030, 0x000060D4,
		0x030, 0x000070D4,
		0x030, 0x000080B4,
		0x030, 0x000090B4,
		0x030, 0x0000A0B4,
		0x030, 0x0000B0B4,
		0x0EE, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x000000A4,
		0x030, 0x000010A4,
		0x030, 0x000020A4,
		0x030, 0x000030A4,
		0x030, 0x000040D4,
		0x030, 0x000050D4,
		0x030, 0x000060D4,
		0x030, 0x000070D4,
		0x030, 0x000080B4,
		0x030, 0x000090B4,
		0x030, 0x0000A0B4,
		0x030, 0x0000B0B4,
		0x0EE, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x000002A4,
		0x030, 0x000012A4,
		0x030, 0x000022A4,
		0x030, 0x000032A4,
		0x030, 0x000042A4,
		0x030, 0x000052A4,
		0x030, 0x000062A4,
		0x030, 0x000072A4,
		0x030, 0x000083B4,
		0x030, 0x000093B4,
		0x030, 0x0000A3B4,
		0x030, 0x0000B3B4,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x000002A4,
		0x030, 0x000012A4,
		0x030, 0x000022A4,
		0x030, 0x000032A4,
		0x030, 0x000042A4,
		0x030, 0x000052A4,
		0x030, 0x000062A4,
		0x030, 0x000072A4,
		0x030, 0x000083B4,
		0x030, 0x000093B4,
		0x030, 0x0000A3B4,
		0x030, 0x0000B3B4,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000400,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x0EE, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000400,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x0EE, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000400,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x0EE, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000400,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x0EE, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000400,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000400,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x000000A4,
		0x030, 0x000010A4,
		0x030, 0x000020A4,
		0x030, 0x000030A4,
		0x030, 0x000040A4,
		0x030, 0x000050A4,
		0x030, 0x000060D4,
		0x030, 0x000070D4,
		0x030, 0x000080D4,
		0x030, 0x000090D4,
		0x030, 0x0000A0D4,
		0x030, 0x0000B0D4,
		0x030, 0x0000C0B4,
		0x030, 0x0000D0B4,
		0x030, 0x0000E0B4,
		0x0EE, 0x00000000,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x000002A4,
		0x030, 0x000012A4,
		0x030, 0x000022A4,
		0x030, 0x000032A4,
		0x030, 0x000042A4,
		0x030, 0x000052A4,
		0x030, 0x000062A4,
		0x030, 0x000072A4,
		0x030, 0x000082A4,
		0x030, 0x000092A4,
		0x030, 0x0000A2A4,
		0x030, 0x0000B2A4,
		0x030, 0x0000C3B4,
		0x030, 0x0000D3B4,
		0x030, 0x0000E3B4,
		0x0EE, 0x00000000,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x000000A4,
		0x030, 0x000010A4,
		0x030, 0x000020A4,
		0x030, 0x000030A4,
		0x030, 0x000040A4,
		0x030, 0x000050A4,
		0x030, 0x000060D4,
		0x030, 0x000070D4,
		0x030, 0x000080D4,
		0x030, 0x000090D4,
		0x030, 0x0000A0D4,
		0x030, 0x0000B0D4,
		0x030, 0x0000C0B4,
		0x030, 0x0000D0B4,
		0x030, 0x0000E0B4,
		0x0EE, 0x00000000,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x000000A4,
		0x030, 0x000010A4,
		0x030, 0x000020A4,
		0x030, 0x000030A4,
		0x030, 0x000040A4,
		0x030, 0x000050A4,
		0x030, 0x000060D4,
		0x030, 0x000070D4,
		0x030, 0x000080D4,
		0x030, 0x000090D4,
		0x030, 0x0000A0D4,
		0x030, 0x0000B0D4,
		0x030, 0x0000C0B4,
		0x030, 0x0000D0B4,
		0x030, 0x0000E0B4,
		0x0EE, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x000000A4,
		0x030, 0x000010A4,
		0x030, 0x000020A4,
		0x030, 0x000030A4,
		0x030, 0x000040A4,
		0x030, 0x000050A4,
		0x030, 0x000060D4,
		0x030, 0x000070D4,
		0x030, 0x000080D4,
		0x030, 0x000090D4,
		0x030, 0x0000A0D4,
		0x030, 0x0000B0D4,
		0x030, 0x0000C0B4,
		0x030, 0x0000D0B4,
		0x030, 0x0000E0B4,
		0x0EE, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x000002A4,
		0x030, 0x000012A4,
		0x030, 0x000022A4,
		0x030, 0x000032A4,
		0x030, 0x000042A4,
		0x030, 0x000052A4,
		0x030, 0x000062A4,
		0x030, 0x000072A4,
		0x030, 0x000082A4,
		0x030, 0x000092A4,
		0x030, 0x0000A2A4,
		0x030, 0x0000B2A4,
		0x030, 0x0000C3B4,
		0x030, 0x0000D3B4,
		0x030, 0x0000E3B4,
		0x0EE, 0x00000000,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x000000A4,
		0x030, 0x000010A4,
		0x030, 0x000020A4,
		0x030, 0x000030A4,
		0x030, 0x000040A4,
		0x030, 0x000050A4,
		0x030, 0x000060D4,
		0x030, 0x000070D4,
		0x030, 0x000080D4,
		0x030, 0x000090D4,
		0x030, 0x0000A0D4,
		0x030, 0x0000B0D4,
		0x030, 0x0000C0B4,
		0x030, 0x0000D0B4,
		0x030, 0x0000E0B4,
		0x0EE, 0x00000000,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x000000A4,
		0x030, 0x000010A4,
		0x030, 0x000020A4,
		0x030, 0x000030A4,
		0x030, 0x000040A4,
		0x030, 0x000050A4,
		0x030, 0x000060D4,
		0x030, 0x000070D4,
		0x030, 0x000080D4,
		0x030, 0x000090D4,
		0x030, 0x0000A0D4,
		0x030, 0x0000B0D4,
		0x030, 0x0000C0B4,
		0x030, 0x0000D0B4,
		0x030, 0x0000E0B4,
		0x0EE, 0x00000000,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x000000A4,
		0x030, 0x000010A4,
		0x030, 0x000020A4,
		0x030, 0x000030A4,
		0x030, 0x000040A4,
		0x030, 0x000050A4,
		0x030, 0x000060D4,
		0x030, 0x000070D4,
		0x030, 0x000080D4,
		0x030, 0x000090D4,
		0x030, 0x0000A0D4,
		0x030, 0x0000B0D4,
		0x030, 0x0000C0B4,
		0x030, 0x0000D0B4,
		0x030, 0x0000E0B4,
		0x0EE, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x000000A4,
		0x030, 0x000010A4,
		0x030, 0x000020A4,
		0x030, 0x000030A4,
		0x030, 0x000040A4,
		0x030, 0x000050A4,
		0x030, 0x000060D4,
		0x030, 0x000070D4,
		0x030, 0x000080D4,
		0x030, 0x000090D4,
		0x030, 0x0000A0D4,
		0x030, 0x0000B0D4,
		0x030, 0x0000C0B4,
		0x030, 0x0000D0B4,
		0x030, 0x0000E0B4,
		0x0EE, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x000002A4,
		0x030, 0x000012A4,
		0x030, 0x000022A4,
		0x030, 0x000032A4,
		0x030, 0x000042A4,
		0x030, 0x000052A4,
		0x030, 0x000062A4,
		0x030, 0x000072A4,
		0x030, 0x000082A4,
		0x030, 0x000092A4,
		0x030, 0x0000A2A4,
		0x030, 0x0000B2A4,
		0x030, 0x0000C3B4,
		0x030, 0x0000D3B4,
		0x030, 0x0000E3B4,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x000002A4,
		0x030, 0x000012A4,
		0x030, 0x000022A4,
		0x030, 0x000032A4,
		0x030, 0x000042A4,
		0x030, 0x000052A4,
		0x030, 0x000062A4,
		0x030, 0x000072A4,
		0x030, 0x000082A4,
		0x030, 0x000092A4,
		0x030, 0x0000A2A4,
		0x030, 0x0000B2A4,
		0x030, 0x0000C3B4,
		0x030, 0x0000D3B4,
		0x030, 0x0000E3B4,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000800,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x030, 0x0000C0B8,
		0x030, 0x0000D0B8,
		0x030, 0x0000E0B8,
		0x0EE, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000800,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x030, 0x0000C0B8,
		0x030, 0x0000D0B8,
		0x030, 0x0000E0B8,
		0x0EE, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000800,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x030, 0x0000C0B8,
		0x030, 0x0000D0B8,
		0x030, 0x0000E0B8,
		0x0EE, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000800,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x030, 0x0000C0B8,
		0x030, 0x0000D0B8,
		0x030, 0x0000E0B8,
		0x0EE, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000800,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x030, 0x0000C0B8,
		0x030, 0x0000D0B8,
		0x030, 0x0000E0B8,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000800,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x030, 0x0000C0B8,
		0x030, 0x0000D0B8,
		0x030, 0x0000E0B8,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00001000,
		0x030, 0x00000CDA,
		0x030, 0x00001776,
		0x030, 0x00002462,
		0x030, 0x00003462,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x030, 0x0000700F,
		0x0EE, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00001000,
		0x030, 0x00000CDA,
		0x030, 0x00001776,
		0x030, 0x00002462,
		0x030, 0x00003462,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x030, 0x0000700F,
		0x0EE, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00001000,
		0x030, 0x00000CDA,
		0x030, 0x00001776,
		0x030, 0x00002462,
		0x030, 0x00003462,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x030, 0x0000700F,
		0x0EE, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00001000,
		0x030, 0x00000CDA,
		0x030, 0x00001776,
		0x030, 0x00002462,
		0x030, 0x00003462,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x030, 0x0000700F,
		0x0EE, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00001000,
		0x030, 0x00000CDA,
		0x030, 0x00001776,
		0x030, 0x00002462,
		0x030, 0x00003462,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x030, 0x0000700F,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00001000,
		0x030, 0x00000CDA,
		0x030, 0x00001776,
		0x030, 0x00002462,
		0x030, 0x00003462,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x030, 0x0000700F,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x0004026A,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x0004026A,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x0004026A,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x0004026A,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x0004026A,
	0xA0000000,	0x00000000,
		0x063, 0x0004026A,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000D8DEF,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x00008DF7,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000D8DEF,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000D8DEF,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000D8DEF,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x00008DF7,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000D8DEF,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000D8DEF,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000D8DEF,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000D8DEF,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x00008DF7,
	0xA0000000,	0x00000000,
		0x08A, 0x00008DF7,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A6560,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A6560,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A6560,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A6560,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A6560,
	0xA0000000,	0x00000000,
		0x08E, 0x000A6560,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00020000,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000006,
		0x03E, 0x00008802,
		0x03F, 0x00007903,
		0x033, 0x00000005,
		0x03E, 0x00008805,
		0x03F, 0x00027903,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00027903,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000000,
		0x03E, 0x00008921,
		0x03F, 0x00027903,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x00000006,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x00000005,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000000,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000006,
		0x03E, 0x00008802,
		0x03F, 0x00027903,
		0x033, 0x00000005,
		0x03E, 0x00008806,
		0x03F, 0x00027903,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00077903,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00017903,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00017903,
		0x033, 0x00000000,
		0x03E, 0x00008922,
		0x03F, 0x00017903,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000006,
		0x03E, 0x00008802,
		0x03F, 0x00027903,
		0x033, 0x00000005,
		0x03E, 0x00008806,
		0x03F, 0x00017903,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00027903,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000000,
		0x03E, 0x000088C2,
		0x03F, 0x00027903,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000006,
		0x03E, 0x00008802,
		0x03F, 0x00007903,
		0x033, 0x00000005,
		0x03E, 0x00008805,
		0x03F, 0x00027903,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00027903,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000000,
		0x03E, 0x00008921,
		0x03F, 0x00027903,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x00000006,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x00000005,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000000,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000006,
		0x03E, 0x00008802,
		0x03F, 0x00007903,
		0x033, 0x00000005,
		0x03E, 0x00008806,
		0x03F, 0x00017903,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00027903,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000000,
		0x03E, 0x000088C2,
		0x03F, 0x00007903,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000006,
		0x03E, 0x00008802,
		0x03F, 0x00027903,
		0x033, 0x00000005,
		0x03E, 0x00008806,
		0x03F, 0x00027903,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00077903,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00017903,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00017903,
		0x033, 0x00000000,
		0x03E, 0x00008922,
		0x03F, 0x00017903,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000006,
		0x03E, 0x00008802,
		0x03F, 0x00027903,
		0x033, 0x00000005,
		0x03E, 0x00008806,
		0x03F, 0x00017903,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00027903,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000000,
		0x03E, 0x000088C2,
		0x03F, 0x00027903,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000006,
		0x03E, 0x00008802,
		0x03F, 0x00007903,
		0x033, 0x00000005,
		0x03E, 0x00008805,
		0x03F, 0x00027903,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00027903,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000000,
		0x03E, 0x00008921,
		0x03F, 0x00027903,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x00000006,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x00000005,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000000,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
	0xA0000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x00000006,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x00000005,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000000,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x0000000E,
		0x03E, 0x00008802,
		0x03F, 0x00017903,
		0x033, 0x0000000D,
		0x03E, 0x00008806,
		0x03F, 0x00027903,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00047903,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000008,
		0x03E, 0x00008921,
		0x03F, 0x00007903,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x0000000E,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x0000000D,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000008,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x0000000E,
		0x03E, 0x00008802,
		0x03F, 0x00047903,
		0x033, 0x0000000D,
		0x03E, 0x00008806,
		0x03F, 0x00007903,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00067903,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00077903,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000008,
		0x03E, 0x0000888B,
		0x03F, 0x00007903,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x0000000E,
		0x03E, 0x00008802,
		0x03F, 0x00017903,
		0x033, 0x0000000D,
		0x03E, 0x00008805,
		0x03F, 0x00027903,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00047903,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00017903,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00017903,
		0x033, 0x00000008,
		0x03E, 0x000088C2,
		0x03F, 0x00037903,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x0000000E,
		0x03E, 0x00008802,
		0x03F, 0x00017903,
		0x033, 0x0000000D,
		0x03E, 0x00008806,
		0x03F, 0x00027903,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00047903,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000008,
		0x03E, 0x00008921,
		0x03F, 0x00007903,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x0000000E,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x0000000D,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000008,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x0000000E,
		0x03E, 0x00008802,
		0x03F, 0x00017903,
		0x033, 0x0000000D,
		0x03E, 0x00008805,
		0x03F, 0x00027903,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00047903,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000008,
		0x03E, 0x000088C2,
		0x03F, 0x00007903,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x0000000E,
		0x03E, 0x00008802,
		0x03F, 0x00047903,
		0x033, 0x0000000D,
		0x03E, 0x00008806,
		0x03F, 0x00007903,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00067903,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00077903,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000008,
		0x03E, 0x0000888B,
		0x03F, 0x00007903,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x0000000E,
		0x03E, 0x00008802,
		0x03F, 0x00017903,
		0x033, 0x0000000D,
		0x03E, 0x00008805,
		0x03F, 0x00027903,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00047903,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00017903,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00017903,
		0x033, 0x00000008,
		0x03E, 0x000088C2,
		0x03F, 0x00037903,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x0000000E,
		0x03E, 0x00008802,
		0x03F, 0x00017903,
		0x033, 0x0000000D,
		0x03E, 0x00008806,
		0x03F, 0x00027903,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00047903,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000008,
		0x03E, 0x00008921,
		0x03F, 0x00007903,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x0000000E,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x0000000D,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000008,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
	0xA0000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x0000000E,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x0000000D,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000008,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000016,
		0x03E, 0x00008802,
		0x03F, 0x00027903,
		0x033, 0x00000015,
		0x03E, 0x00008806,
		0x03F, 0x00027903,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00047903,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000010,
		0x03E, 0x00008920,
		0x03F, 0x00007903,
		0x0EF, 0x00000000,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x00000016,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x00000015,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000010,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
		0x0EF, 0x00000000,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000016,
		0x03E, 0x00008802,
		0x03F, 0x00017903,
		0x033, 0x00000015,
		0x03E, 0x00008806,
		0x03F, 0x00027903,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00067903,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00067903,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00017903,
		0x033, 0x00000010,
		0x03E, 0x0000888B,
		0x03F, 0x00017903,
		0x0EF, 0x00000000,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000016,
		0x03E, 0x00008802,
		0x03F, 0x00007903,
		0x033, 0x00000015,
		0x03E, 0x00008806,
		0x03F, 0x00017903,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00037903,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000010,
		0x03E, 0x000088C0,
		0x03F, 0x00037903,
		0x0EF, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000016,
		0x03E, 0x00008802,
		0x03F, 0x00027903,
		0x033, 0x00000015,
		0x03E, 0x00008806,
		0x03F, 0x00027903,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00047903,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000010,
		0x03E, 0x00008920,
		0x03F, 0x00007903,
		0x0EF, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x00000016,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x00000015,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000010,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
		0x0EF, 0x00000000,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000016,
		0x03E, 0x00008802,
		0x03F, 0x00017903,
		0x033, 0x00000015,
		0x03E, 0x00008806,
		0x03F, 0x00017903,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00037903,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000010,
		0x03E, 0x000088C0,
		0x03F, 0x00017903,
		0x0EF, 0x00000000,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000016,
		0x03E, 0x00008802,
		0x03F, 0x00017903,
		0x033, 0x00000015,
		0x03E, 0x00008806,
		0x03F, 0x00027903,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00067903,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00067903,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00017903,
		0x033, 0x00000010,
		0x03E, 0x0000888B,
		0x03F, 0x00017903,
		0x0EF, 0x00000000,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000016,
		0x03E, 0x00008802,
		0x03F, 0x00007903,
		0x033, 0x00000015,
		0x03E, 0x00008806,
		0x03F, 0x00017903,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00037903,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000010,
		0x03E, 0x000088C0,
		0x03F, 0x00037903,
		0x0EF, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000016,
		0x03E, 0x00008802,
		0x03F, 0x00027903,
		0x033, 0x00000015,
		0x03E, 0x00008806,
		0x03F, 0x00027903,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00047903,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000010,
		0x03E, 0x00008920,
		0x03F, 0x00007903,
		0x0EF, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x00000016,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x00000015,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000010,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x00000016,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x00000015,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000010,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x0000000D,
		0x033, 0x00000001,
		0x03F, 0x00000004,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x0000000D,
		0x033, 0x00000001,
		0x03F, 0x00000004,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x0000000D,
		0x033, 0x00000001,
		0x03F, 0x00000004,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x0000000D,
		0x033, 0x00000001,
		0x03F, 0x00000004,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x0000000D,
		0x033, 0x00000001,
		0x03F, 0x00000004,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x0000000D,
		0x033, 0x00000001,
		0x03F, 0x00000004,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x00000000,
		0x03F, 0x000C0000,
		0x033, 0x00000001,
		0x03F, 0x000C0000,
		0x0EF, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x00000000,
		0x03F, 0x000C0000,
		0x033, 0x00000001,
		0x03F, 0x000C0000,
		0x0EF, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x00000000,
		0x03F, 0x000C0000,
		0x033, 0x00000001,
		0x03F, 0x000C0000,
		0x0EF, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x00000000,
		0x03F, 0x000C0000,
		0x033, 0x00000001,
		0x03F, 0x000C0000,
		0x0EF, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x00000000,
		0x03F, 0x000C0000,
		0x033, 0x00000001,
		0x03F, 0x000C0000,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x00000000,
		0x03F, 0x000C0000,
		0x033, 0x00000001,
		0x03F, 0x000C0000,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0xA0000000,	0x00000000,
		0x018, 0x00013124,
	0xB0000000,	0x00000000,
		0x0FE, 0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x01B, 0x00000240,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x01B, 0x00000240,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x01B, 0x00000240,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x01B, 0x00000240,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x01B, 0x00000240,
	0xA0000000,	0x00000000,
		0x01B, 0x00000240,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000002,
		0x033, 0x00000010,
		0x03F, 0x00000041,
		0x033, 0x00000011,
		0x03F, 0x00000AEB,
		0x033, 0x00000012,
		0x03F, 0x00000B6D,
		0x033, 0x00000013,
		0x03F, 0x00000CB0,
		0x0EE, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000002,
		0x033, 0x00000010,
		0x03F, 0x00000041,
		0x033, 0x00000011,
		0x03F, 0x00000AEB,
		0x033, 0x00000012,
		0x03F, 0x00000B6D,
		0x033, 0x00000013,
		0x03F, 0x00000CB0,
		0x0EE, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000002,
		0x033, 0x00000010,
		0x03F, 0x00000041,
		0x033, 0x00000011,
		0x03F, 0x00000AEB,
		0x033, 0x00000012,
		0x03F, 0x00000B6D,
		0x033, 0x00000013,
		0x03F, 0x00000CB0,
		0x0EE, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000002,
		0x033, 0x00000010,
		0x03F, 0x00000041,
		0x033, 0x00000011,
		0x03F, 0x00000AEB,
		0x033, 0x00000012,
		0x03F, 0x00000B6D,
		0x033, 0x00000013,
		0x03F, 0x00000CB0,
		0x0EE, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000002,
		0x033, 0x00000010,
		0x03F, 0x00000041,
		0x033, 0x00000011,
		0x03F, 0x00000AEB,
		0x033, 0x00000012,
		0x03F, 0x00000B6D,
		0x033, 0x00000013,
		0x03F, 0x00000CB0,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000002,
		0x033, 0x00000010,
		0x03F, 0x00000041,
		0x033, 0x00000011,
		0x03F, 0x00000AEB,
		0x033, 0x00000012,
		0x03F, 0x00000B6D,
		0x033, 0x00000013,
		0x03F, 0x00000CB0,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0DE, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0DE, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0DE, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0DE, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0DE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0DE, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x057, 0x0004B5AA,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x057, 0x0004B5AA,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x057, 0x0004B5AA,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x057, 0x0004B5AA,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x057, 0x0004B5AA,
	0xA0000000,	0x00000000,
		0x057, 0x0004B5AA,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000010,
		0x008, 0x00078200,
		0x0EF, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000010,
		0x008, 0x00078200,
		0x0EF, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000010,
		0x008, 0x00078200,
		0x0EF, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000010,
		0x008, 0x00078200,
		0x0EF, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000010,
		0x008, 0x00078200,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000010,
		0x008, 0x00078200,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x018, 0x00000C03,
		0x08F, 0x00000AAC,
		0x069, 0x0000003F,
		0x067, 0x00084200,
		0x067, 0x00084201,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x018, 0x00000C03,
		0x08F, 0x00000AAC,
		0x069, 0x0000003F,
		0x067, 0x00084200,
		0x067, 0x00084201,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x018, 0x00000C03,
		0x08F, 0x00000AAC,
		0x069, 0x0000003F,
		0x067, 0x00084200,
		0x067, 0x00084201,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x018, 0x00000C03,
		0x08F, 0x00000AAC,
		0x069, 0x0000003F,
		0x067, 0x00084200,
		0x067, 0x00084201,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x018, 0x00000C03,
		0x08F, 0x00000AAC,
		0x069, 0x0000003F,
		0x067, 0x00084200,
		0x067, 0x00084201,
	0xA0000000,	0x00000000,
		0x000, 0x00030000,
		0x018, 0x00000C03,
		0x08F, 0x00000AAC,
		0x069, 0x0000003F,
		0x067, 0x00084200,
		0x067, 0x00084201,
	0xB0000000,	0x00000000,
		0xFFE, 0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x00084200,
		0x0DF, 0x00002000,
		0x082, 0x00003364,
		0x068, 0x00084210,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x00084200,
		0x0DF, 0x00002000,
		0x082, 0x00003364,
		0x068, 0x00084210,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x00084200,
		0x0DF, 0x00002000,
		0x082, 0x00003364,
		0x068, 0x00084210,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x00084200,
		0x0DF, 0x00002000,
		0x082, 0x00003364,
		0x068, 0x00084210,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x00084200,
		0x0DF, 0x00002000,
		0x082, 0x00003364,
		0x068, 0x00084210,
	0xA0000000,	0x00000000,
		0x067, 0x00084200,
		0x0DF, 0x00002000,
		0x082, 0x00003364,
		0x068, 0x00084210,
	0xB0000000,	0x00000000,
		0xFFE, 0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x082, 0x00003354,
		0x068, 0x00084210,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x082, 0x00003354,
		0x068, 0x00084210,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x082, 0x00003354,
		0x068, 0x00084210,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x082, 0x00003354,
		0x068, 0x00084210,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x082, 0x00003354,
		0x068, 0x00084210,
	0xA0000000,	0x00000000,
		0x068, 0x00084200,
		0x082, 0x00003354,
		0x068, 0x00084210,
	0xB0000000,	0x00000000,
		0xFFE, 0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x0DF, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x0DF, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x0DF, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x0DF, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x0DF, 0x00000000,
	0xA0000000,	0x00000000,
		0x068, 0x00084200,
		0x0DF, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x06F, 0x00014311,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x06F, 0x00014311,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x06F, 0x00014311,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x06F, 0x00014311,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x06F, 0x00014311,
	0xA0000000,	0x00000000,
		0x06F, 0x00014311,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x06E, 0x00000231,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x06E, 0x00000231,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x06E, 0x00000231,
	0x92000000,	0x00000000,	0x40000000,	0x00000000,
		0x06E, 0x00000311,
	0x92000003,	0x00000000,	0x40000000,	0x00000000,
		0x06E, 0x00000311,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x06E, 0x00000231,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x06E, 0x00000231,
	0xA0000000,	0x00000000,
		0x06E, 0x00000231,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0xFFFF, 0x0000FFFF,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0xFFFF, 0x0000FFFF,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0xFFFF, 0x0000FFFF,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0xFFFF, 0x0000FFFF,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0xFFFF, 0x0000FFFF,
	0xA0000000,	0x00000000,
		0xFFFF, 0x0000FFFF,
	0xB0000000,	0x00000000,

};

void
odm_read_and_config_mp_8814b_radioc(struct dm_struct *dm)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len =
			sizeof(array_mp_8814b_radioc) / sizeof(u32);
	u32	*array = (u32 *)array_mp_8814b_radioc;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;
	u32	a1 = 0, a2 = 0, a3 = 0, a4 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  =
					(u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT,
						  "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (!is_skipped) {
					a1 = pre_v1; a2 = pre_v2;
					a3 = v1; a4 = v2;
					if (check_positive(dm,
							   a1, a2, a3, a4)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else {
					is_matched = false;
				}
			}
		} else {
			if (is_matched)
				odm_config_rf_radio_c_8814b(dm, v1, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8814b_radioc(void)
{
		return 46;
}

/******************************************************************************
 *                           radiod.TXT
 ******************************************************************************/

const u32 array_mp_8814b_radiod[] = {
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x0008D9C0,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x0006E100,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x0008D9C0,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x0008D9C0,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x0008D9C0,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x0006E100,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x0008D9C0,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x0008D9C0,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x0008D9C0,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x0008D9C0,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x0006E100,
	0xA0000000,	0x00000000,
		0x058, 0x0006E100,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x0DD, 0x00000010,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x0DD, 0x00000010,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x0DD, 0x00000010,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x0DD, 0x00000010,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x0DD, 0x00000010,
	0xA0000000,	0x00000000,
		0x000, 0x00030000,
		0x0DD, 0x00000010,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000001,
		0x03E, 0x00000244,
		0x03F, 0x000000F7,
		0x033, 0x00000002,
		0x03E, 0x000003FC,
		0x03F, 0x000000F7,
		0x033, 0x00000003,
		0x03E, 0x00000245,
		0x03F, 0x000AFCF7,
		0x033, 0x00000004,
		0x03E, 0x000003F6,
		0x03F, 0x0000F9F7,
		0x033, 0x00000007,
		0x03E, 0x000003FD,
		0x03F, 0x000EFCF7,
		0x0EF, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000001,
		0x03E, 0x00000244,
		0x03F, 0x000000F7,
		0x033, 0x00000002,
		0x03E, 0x000003FC,
		0x03F, 0x000000F7,
		0x033, 0x00000003,
		0x03E, 0x00000245,
		0x03F, 0x000AFCF7,
		0x033, 0x00000004,
		0x03E, 0x000003F6,
		0x03F, 0x0000F9F7,
		0x033, 0x00000007,
		0x03E, 0x000003FD,
		0x03F, 0x000EFCF7,
		0x0EF, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000001,
		0x03E, 0x00000244,
		0x03F, 0x000000F7,
		0x033, 0x00000002,
		0x03E, 0x000003FC,
		0x03F, 0x000000F7,
		0x033, 0x00000003,
		0x03E, 0x00000245,
		0x03F, 0x000AFCF7,
		0x033, 0x00000004,
		0x03E, 0x000003F6,
		0x03F, 0x0000F9F7,
		0x033, 0x00000007,
		0x03E, 0x000003FD,
		0x03F, 0x000EFCF7,
		0x0EF, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000001,
		0x03E, 0x00000244,
		0x03F, 0x000000F7,
		0x033, 0x00000002,
		0x03E, 0x000003FC,
		0x03F, 0x000000F7,
		0x033, 0x00000003,
		0x03E, 0x00000245,
		0x03F, 0x000AFCF7,
		0x033, 0x00000004,
		0x03E, 0x000003F6,
		0x03F, 0x0000F9F7,
		0x033, 0x00000007,
		0x03E, 0x000003FD,
		0x03F, 0x000EFCF7,
		0x0EF, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000001,
		0x03E, 0x00000244,
		0x03F, 0x000000F7,
		0x033, 0x00000002,
		0x03E, 0x000003FC,
		0x03F, 0x000000F7,
		0x033, 0x00000003,
		0x03E, 0x00000245,
		0x03F, 0x000AFCF7,
		0x033, 0x00000004,
		0x03E, 0x000003F6,
		0x03F, 0x0000F9F7,
		0x033, 0x00000007,
		0x03E, 0x000003FD,
		0x03F, 0x000EFCF7,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000001,
		0x03E, 0x00000244,
		0x03F, 0x000000F7,
		0x033, 0x00000002,
		0x03E, 0x000003FC,
		0x03F, 0x000000F7,
		0x033, 0x00000003,
		0x03E, 0x00000245,
		0x03F, 0x000AFCF7,
		0x033, 0x00000004,
		0x03E, 0x000003F6,
		0x03F, 0x0000F9F7,
		0x033, 0x00000007,
		0x03E, 0x000003FD,
		0x03F, 0x000EFCF7,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x09E, 0x000F8009,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x09E, 0x000F8009,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x09E, 0x000F8009,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x09E, 0x000F8009,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x09E, 0x000F8009,
	0xA0000000,	0x00000000,
		0x09E, 0x000F8009,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0xA0000000,	0x00000000,
		0x018, 0x00013124,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00000006,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00000006,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00000006,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00000006,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00000006,
	0xA0000000,	0x00000000,
		0x018, 0x00000006,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x0005512D,
		0x080, 0x000CE800,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x0005516D,
		0x080, 0x000CE800,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x0005512D,
		0x080, 0x000CE800,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x0005516D,
		0x080, 0x000CE800,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x0005512D,
		0x080, 0x000CE800,
	0xA0000000,	0x00000000,
		0x087, 0x0005512D,
		0x080, 0x000CE800,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x082, 0x00003300,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x082, 0x00003300,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x082, 0x00003300,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x082, 0x00003300,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x082, 0x00003300,
	0xA0000000,	0x00000000,
		0x082, 0x00003300,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0C0, 0x0007FC00,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0C0, 0x0007FC00,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0C0, 0x0007FC00,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0C0, 0x0007FC00,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0C0, 0x0007FC00,
	0xA0000000,	0x00000000,
		0x0C0, 0x0007FC00,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x01A, 0x00040004,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x01A, 0x00040004,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x01A, 0x00040004,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x01A, 0x00040004,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x01A, 0x00040004,
	0xA0000000,	0x00000000,
		0x01A, 0x00040004,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0000D3A5,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0000D3A5,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0000D3A5,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0000D3A5,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0000D3A5,
	0xA0000000,	0x00000000,
		0x061, 0x0000D3A5,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00010000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00010000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00010000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00010000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00010000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00010000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000F04,
		0x033, 0x00000021,
		0x03F, 0x00000F64,
		0x033, 0x00000022,
		0x03F, 0x00002E04,
		0x033, 0x00000023,
		0x03F, 0x00004E85,
		0x033, 0x00000024,
		0x03F, 0x00004E88,
		0x033, 0x00000025,
		0x03F, 0x00006F05,
		0x033, 0x00000026,
		0x03F, 0x00006FE7,
		0x033, 0x00000027,
		0x03F, 0x00006FEA,
		0x033, 0x00000028,
		0x03F, 0x00006FED,
		0x033, 0x00000029,
		0x03F, 0x00006FF0,
		0x033, 0x0000002A,
		0x03F, 0x00006FF3,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000289,
		0x033, 0x00000021,
		0x03F, 0x000002C9,
		0x033, 0x00000022,
		0x03F, 0x0000030A,
		0x033, 0x00000023,
		0x03F, 0x0000050A,
		0x033, 0x00000024,
		0x03F, 0x0000072A,
		0x033, 0x00000025,
		0x03F, 0x00000B2B,
		0x033, 0x00000026,
		0x03F, 0x00000F8B,
		0x033, 0x00000027,
		0x03F, 0x000026EB,
		0x033, 0x00000028,
		0x03F, 0x00000F33,
		0x033, 0x00000029,
		0x03F, 0x00000F94,
		0x033, 0x0000002A,
		0x03F, 0x00000FB8,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000F04,
		0x033, 0x00000021,
		0x03F, 0x00000F64,
		0x033, 0x00000022,
		0x03F, 0x00002E04,
		0x033, 0x00000023,
		0x03F, 0x00004E85,
		0x033, 0x00000024,
		0x03F, 0x00004E88,
		0x033, 0x00000025,
		0x03F, 0x00006F05,
		0x033, 0x00000026,
		0x03F, 0x00006FE7,
		0x033, 0x00000027,
		0x03F, 0x00006FEA,
		0x033, 0x00000028,
		0x03F, 0x00006FED,
		0x033, 0x00000029,
		0x03F, 0x00006FF0,
		0x033, 0x0000002A,
		0x03F, 0x00006FF3,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000289,
		0x033, 0x00000021,
		0x03F, 0x000002C9,
		0x033, 0x00000022,
		0x03F, 0x0000030A,
		0x033, 0x00000023,
		0x03F, 0x0000050A,
		0x033, 0x00000024,
		0x03F, 0x0000072A,
		0x033, 0x00000025,
		0x03F, 0x00000B2B,
		0x033, 0x00000026,
		0x03F, 0x00000F8B,
		0x033, 0x00000027,
		0x03F, 0x000026EB,
		0x033, 0x00000028,
		0x03F, 0x00000F33,
		0x033, 0x00000029,
		0x03F, 0x00000F94,
		0x033, 0x0000002A,
		0x03F, 0x00000FB8,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000F04,
		0x033, 0x00000021,
		0x03F, 0x00000F64,
		0x033, 0x00000022,
		0x03F, 0x00002E04,
		0x033, 0x00000023,
		0x03F, 0x00004E85,
		0x033, 0x00000024,
		0x03F, 0x00004E88,
		0x033, 0x00000025,
		0x03F, 0x00006F05,
		0x033, 0x00000026,
		0x03F, 0x00006FE7,
		0x033, 0x00000027,
		0x03F, 0x00006FEA,
		0x033, 0x00000028,
		0x03F, 0x00006FED,
		0x033, 0x00000029,
		0x03F, 0x00006FF0,
		0x033, 0x0000002A,
		0x03F, 0x00006FF3,
	0xA0000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000F04,
		0x033, 0x00000021,
		0x03F, 0x00000F64,
		0x033, 0x00000022,
		0x03F, 0x00002E04,
		0x033, 0x00000023,
		0x03F, 0x00004E85,
		0x033, 0x00000024,
		0x03F, 0x00004E88,
		0x033, 0x00000025,
		0x03F, 0x00006F05,
		0x033, 0x00000026,
		0x03F, 0x00006FE7,
		0x033, 0x00000027,
		0x03F, 0x00006FEA,
		0x033, 0x00000028,
		0x03F, 0x00006FED,
		0x033, 0x00000029,
		0x03F, 0x00006FF0,
		0x033, 0x0000002A,
		0x03F, 0x00006FF3,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000F04,
		0x033, 0x00000061,
		0x03F, 0x00000F64,
		0x033, 0x00000062,
		0x03F, 0x00002E04,
		0x033, 0x00000063,
		0x03F, 0x00004E85,
		0x033, 0x00000064,
		0x03F, 0x00004E88,
		0x033, 0x00000065,
		0x03F, 0x00006F05,
		0x033, 0x00000066,
		0x03F, 0x00006FE7,
		0x033, 0x00000067,
		0x03F, 0x00006FEA,
		0x033, 0x00000068,
		0x03F, 0x00006FED,
		0x033, 0x00000069,
		0x03F, 0x00006FF0,
		0x033, 0x0000006A,
		0x03F, 0x00006FF3,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000048,
		0x033, 0x00000061,
		0x03F, 0x0000004B,
		0x033, 0x00000062,
		0x03F, 0x000000C6,
		0x033, 0x00000063,
		0x03F, 0x00000107,
		0x033, 0x00000064,
		0x03F, 0x0000010A,
		0x033, 0x00000065,
		0x03F, 0x00002007,
		0x033, 0x00000066,
		0x03F, 0x00000349,
		0x033, 0x00000067,
		0x03F, 0x000003C9,
		0x033, 0x00000068,
		0x03F, 0x000005E9,
		0x033, 0x00000069,
		0x03F, 0x0000260A,
		0x033, 0x0000006A,
		0x03F, 0x0000260D,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000E64,
		0x033, 0x00000061,
		0x03F, 0x00000E85,
		0x033, 0x00000062,
		0x03F, 0x00000EE4,
		0x033, 0x00000063,
		0x03F, 0x00000EE7,
		0x033, 0x00000064,
		0x03F, 0x00000EEA,
		0x033, 0x00000065,
		0x03F, 0x00004E65,
		0x033, 0x00000066,
		0x03F, 0x00002EA7,
		0x033, 0x00000067,
		0x03F, 0x00002EAA,
		0x033, 0x00000068,
		0x03F, 0x00002EAD,
		0x033, 0x00000069,
		0x03F, 0x00002EB0,
		0x033, 0x0000006A,
		0x03F, 0x00002EB3,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000048,
		0x033, 0x00000061,
		0x03F, 0x0000004B,
		0x033, 0x00000062,
		0x03F, 0x000000C6,
		0x033, 0x00000063,
		0x03F, 0x00000107,
		0x033, 0x00000064,
		0x03F, 0x0000010A,
		0x033, 0x00000065,
		0x03F, 0x00002007,
		0x033, 0x00000066,
		0x03F, 0x00000349,
		0x033, 0x00000067,
		0x03F, 0x000003C9,
		0x033, 0x00000068,
		0x03F, 0x000005E9,
		0x033, 0x00000069,
		0x03F, 0x0000260A,
		0x033, 0x0000006A,
		0x03F, 0x0000260D,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000E64,
		0x033, 0x00000061,
		0x03F, 0x00000E85,
		0x033, 0x00000062,
		0x03F, 0x00000EE4,
		0x033, 0x00000063,
		0x03F, 0x00000EE7,
		0x033, 0x00000064,
		0x03F, 0x00000EEA,
		0x033, 0x00000065,
		0x03F, 0x00004E65,
		0x033, 0x00000066,
		0x03F, 0x00002EA7,
		0x033, 0x00000067,
		0x03F, 0x00002EAA,
		0x033, 0x00000068,
		0x03F, 0x00002EAD,
		0x033, 0x00000069,
		0x03F, 0x00002EB0,
		0x033, 0x0000006A,
		0x03F, 0x00002EB3,
	0xA0000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000E64,
		0x033, 0x00000061,
		0x03F, 0x00000E85,
		0x033, 0x00000062,
		0x03F, 0x00000EE4,
		0x033, 0x00000063,
		0x03F, 0x00000EE7,
		0x033, 0x00000064,
		0x03F, 0x00000EEA,
		0x033, 0x00000065,
		0x03F, 0x00004E65,
		0x033, 0x00000066,
		0x03F, 0x00002EA7,
		0x033, 0x00000067,
		0x03F, 0x00002EAA,
		0x033, 0x00000068,
		0x03F, 0x00002EAD,
		0x033, 0x00000069,
		0x03F, 0x00002EB0,
		0x033, 0x0000006A,
		0x03F, 0x00002EB3,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000205,
		0x033, 0x00000201,
		0x03F, 0x00000222,
		0x033, 0x00000202,
		0x03F, 0x00000225,
		0x033, 0x00000203,
		0x03F, 0x00000228,
		0x033, 0x00000204,
		0x03F, 0x0000022B,
		0x033, 0x00000205,
		0x03F, 0x00000428,
		0x033, 0x00000206,
		0x03F, 0x00000628,
		0x033, 0x00000207,
		0x03F, 0x0000062B,
		0x033, 0x00000208,
		0x03F, 0x00000668,
		0x033, 0x00000209,
		0x03F, 0x0000066B,
		0x033, 0x0000020A,
		0x03F, 0x0000066E,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000444,
		0x033, 0x00000201,
		0x03F, 0x00000447,
		0x033, 0x00000202,
		0x03F, 0x00000647,
		0x033, 0x00000203,
		0x03F, 0x00000E46,
		0x033, 0x00000204,
		0x03F, 0x00000E66,
		0x033, 0x00000205,
		0x03F, 0x00000EC4,
		0x033, 0x00000206,
		0x03F, 0x00000EE6,
		0x033, 0x00000207,
		0x03F, 0x00000EE9,
		0x033, 0x00000208,
		0x03F, 0x00000EEC,
		0x033, 0x00000209,
		0x03F, 0x00000EEF,
		0x033, 0x0000020A,
		0x03F, 0x00000EF2,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000205,
		0x033, 0x00000201,
		0x03F, 0x00000222,
		0x033, 0x00000202,
		0x03F, 0x00000225,
		0x033, 0x00000203,
		0x03F, 0x00000228,
		0x033, 0x00000204,
		0x03F, 0x0000022B,
		0x033, 0x00000205,
		0x03F, 0x00000428,
		0x033, 0x00000206,
		0x03F, 0x00000628,
		0x033, 0x00000207,
		0x03F, 0x0000062B,
		0x033, 0x00000208,
		0x03F, 0x00000668,
		0x033, 0x00000209,
		0x03F, 0x0000066B,
		0x033, 0x0000020A,
		0x03F, 0x0000066E,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000205,
		0x033, 0x00000201,
		0x03F, 0x00000222,
		0x033, 0x00000202,
		0x03F, 0x00000225,
		0x033, 0x00000203,
		0x03F, 0x00000228,
		0x033, 0x00000204,
		0x03F, 0x0000022B,
		0x033, 0x00000205,
		0x03F, 0x00000428,
		0x033, 0x00000206,
		0x03F, 0x00000628,
		0x033, 0x00000207,
		0x03F, 0x0000062B,
		0x033, 0x00000208,
		0x03F, 0x00000668,
		0x033, 0x00000209,
		0x03F, 0x0000066B,
		0x033, 0x0000020A,
		0x03F, 0x0000066E,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000205,
		0x033, 0x00000201,
		0x03F, 0x00000222,
		0x033, 0x00000202,
		0x03F, 0x00000225,
		0x033, 0x00000203,
		0x03F, 0x00000228,
		0x033, 0x00000204,
		0x03F, 0x0000022B,
		0x033, 0x00000205,
		0x03F, 0x00000428,
		0x033, 0x00000206,
		0x03F, 0x00000628,
		0x033, 0x00000207,
		0x03F, 0x0000062B,
		0x033, 0x00000208,
		0x03F, 0x00000668,
		0x033, 0x00000209,
		0x03F, 0x0000066B,
		0x033, 0x0000020A,
		0x03F, 0x0000066E,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000444,
		0x033, 0x00000201,
		0x03F, 0x00000447,
		0x033, 0x00000202,
		0x03F, 0x00000647,
		0x033, 0x00000203,
		0x03F, 0x00000E46,
		0x033, 0x00000204,
		0x03F, 0x00000E66,
		0x033, 0x00000205,
		0x03F, 0x00000EC4,
		0x033, 0x00000206,
		0x03F, 0x00000EE6,
		0x033, 0x00000207,
		0x03F, 0x00000EE9,
		0x033, 0x00000208,
		0x03F, 0x00000EEC,
		0x033, 0x00000209,
		0x03F, 0x00000EEF,
		0x033, 0x0000020A,
		0x03F, 0x00000EF2,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000205,
		0x033, 0x00000201,
		0x03F, 0x00000222,
		0x033, 0x00000202,
		0x03F, 0x00000225,
		0x033, 0x00000203,
		0x03F, 0x00000228,
		0x033, 0x00000204,
		0x03F, 0x0000022B,
		0x033, 0x00000205,
		0x03F, 0x00000428,
		0x033, 0x00000206,
		0x03F, 0x00000628,
		0x033, 0x00000207,
		0x03F, 0x0000062B,
		0x033, 0x00000208,
		0x03F, 0x00000668,
		0x033, 0x00000209,
		0x03F, 0x0000066B,
		0x033, 0x0000020A,
		0x03F, 0x0000066E,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000205,
		0x033, 0x00000201,
		0x03F, 0x00000222,
		0x033, 0x00000202,
		0x03F, 0x00000225,
		0x033, 0x00000203,
		0x03F, 0x00000228,
		0x033, 0x00000204,
		0x03F, 0x0000022B,
		0x033, 0x00000205,
		0x03F, 0x00000428,
		0x033, 0x00000206,
		0x03F, 0x00000628,
		0x033, 0x00000207,
		0x03F, 0x0000062B,
		0x033, 0x00000208,
		0x03F, 0x00000668,
		0x033, 0x00000209,
		0x03F, 0x0000066B,
		0x033, 0x0000020A,
		0x03F, 0x0000066E,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000205,
		0x033, 0x00000201,
		0x03F, 0x00000222,
		0x033, 0x00000202,
		0x03F, 0x00000225,
		0x033, 0x00000203,
		0x03F, 0x00000228,
		0x033, 0x00000204,
		0x03F, 0x0000022B,
		0x033, 0x00000205,
		0x03F, 0x00000428,
		0x033, 0x00000206,
		0x03F, 0x00000628,
		0x033, 0x00000207,
		0x03F, 0x0000062B,
		0x033, 0x00000208,
		0x03F, 0x00000668,
		0x033, 0x00000209,
		0x03F, 0x0000066B,
		0x033, 0x0000020A,
		0x03F, 0x0000066E,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000205,
		0x033, 0x00000201,
		0x03F, 0x00000222,
		0x033, 0x00000202,
		0x03F, 0x00000225,
		0x033, 0x00000203,
		0x03F, 0x00000228,
		0x033, 0x00000204,
		0x03F, 0x0000022B,
		0x033, 0x00000205,
		0x03F, 0x00000428,
		0x033, 0x00000206,
		0x03F, 0x00000628,
		0x033, 0x00000207,
		0x03F, 0x0000062B,
		0x033, 0x00000208,
		0x03F, 0x00000668,
		0x033, 0x00000209,
		0x03F, 0x0000066B,
		0x033, 0x0000020A,
		0x03F, 0x0000066E,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000444,
		0x033, 0x00000201,
		0x03F, 0x00000447,
		0x033, 0x00000202,
		0x03F, 0x00000647,
		0x033, 0x00000203,
		0x03F, 0x00000E46,
		0x033, 0x00000204,
		0x03F, 0x00000E66,
		0x033, 0x00000205,
		0x03F, 0x00000EC4,
		0x033, 0x00000206,
		0x03F, 0x00000EE6,
		0x033, 0x00000207,
		0x03F, 0x00000EE9,
		0x033, 0x00000208,
		0x03F, 0x00000EEC,
		0x033, 0x00000209,
		0x03F, 0x00000EEF,
		0x033, 0x0000020A,
		0x03F, 0x00000EF2,
	0xA0000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000444,
		0x033, 0x00000201,
		0x03F, 0x00000447,
		0x033, 0x00000202,
		0x03F, 0x00000647,
		0x033, 0x00000203,
		0x03F, 0x00000E46,
		0x033, 0x00000204,
		0x03F, 0x00000E66,
		0x033, 0x00000205,
		0x03F, 0x00000EC4,
		0x033, 0x00000206,
		0x03F, 0x00000EE6,
		0x033, 0x00000207,
		0x03F, 0x00000EE9,
		0x033, 0x00000208,
		0x03F, 0x00000EEC,
		0x033, 0x00000209,
		0x03F, 0x00000EEF,
		0x033, 0x0000020A,
		0x03F, 0x00000EF2,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000205,
		0x033, 0x00000281,
		0x03F, 0x00000222,
		0x033, 0x00000282,
		0x03F, 0x00000225,
		0x033, 0x00000283,
		0x03F, 0x00000228,
		0x033, 0x00000284,
		0x03F, 0x0000022B,
		0x033, 0x00000285,
		0x03F, 0x00000428,
		0x033, 0x00000286,
		0x03F, 0x00000628,
		0x033, 0x00000287,
		0x03F, 0x0000062B,
		0x033, 0x00000288,
		0x03F, 0x0000064B,
		0x033, 0x00000289,
		0x03F, 0x0000066B,
		0x033, 0x0000028A,
		0x03F, 0x0000066E,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000445,
		0x033, 0x00000281,
		0x03F, 0x00000448,
		0x033, 0x00000282,
		0x03F, 0x00000648,
		0x033, 0x00000283,
		0x03F, 0x00000E47,
		0x033, 0x00000284,
		0x03F, 0x00000E67,
		0x033, 0x00000285,
		0x03F, 0x00000EC5,
		0x033, 0x00000286,
		0x03F, 0x00000EE7,
		0x033, 0x00000287,
		0x03F, 0x00000EEA,
		0x033, 0x00000288,
		0x03F, 0x00000EED,
		0x033, 0x00000289,
		0x03F, 0x00000EF0,
		0x033, 0x0000028A,
		0x03F, 0x00000EF3,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000205,
		0x033, 0x00000281,
		0x03F, 0x00000222,
		0x033, 0x00000282,
		0x03F, 0x00000225,
		0x033, 0x00000283,
		0x03F, 0x00000228,
		0x033, 0x00000284,
		0x03F, 0x0000022B,
		0x033, 0x00000285,
		0x03F, 0x00000428,
		0x033, 0x00000286,
		0x03F, 0x00000628,
		0x033, 0x00000287,
		0x03F, 0x0000062B,
		0x033, 0x00000288,
		0x03F, 0x0000064B,
		0x033, 0x00000289,
		0x03F, 0x0000066B,
		0x033, 0x0000028A,
		0x03F, 0x0000066E,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000205,
		0x033, 0x00000281,
		0x03F, 0x00000222,
		0x033, 0x00000282,
		0x03F, 0x00000225,
		0x033, 0x00000283,
		0x03F, 0x00000228,
		0x033, 0x00000284,
		0x03F, 0x0000022B,
		0x033, 0x00000285,
		0x03F, 0x00000428,
		0x033, 0x00000286,
		0x03F, 0x00000628,
		0x033, 0x00000287,
		0x03F, 0x0000062B,
		0x033, 0x00000288,
		0x03F, 0x0000064B,
		0x033, 0x00000289,
		0x03F, 0x0000066B,
		0x033, 0x0000028A,
		0x03F, 0x0000066E,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000205,
		0x033, 0x00000281,
		0x03F, 0x00000222,
		0x033, 0x00000282,
		0x03F, 0x00000225,
		0x033, 0x00000283,
		0x03F, 0x00000228,
		0x033, 0x00000284,
		0x03F, 0x0000022B,
		0x033, 0x00000285,
		0x03F, 0x00000428,
		0x033, 0x00000286,
		0x03F, 0x00000628,
		0x033, 0x00000287,
		0x03F, 0x0000062B,
		0x033, 0x00000288,
		0x03F, 0x0000064B,
		0x033, 0x00000289,
		0x03F, 0x0000066B,
		0x033, 0x0000028A,
		0x03F, 0x0000066E,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000445,
		0x033, 0x00000281,
		0x03F, 0x00000448,
		0x033, 0x00000282,
		0x03F, 0x00000648,
		0x033, 0x00000283,
		0x03F, 0x00000E47,
		0x033, 0x00000284,
		0x03F, 0x00000E67,
		0x033, 0x00000285,
		0x03F, 0x00000EC5,
		0x033, 0x00000286,
		0x03F, 0x00000EE7,
		0x033, 0x00000287,
		0x03F, 0x00000EEA,
		0x033, 0x00000288,
		0x03F, 0x00000EED,
		0x033, 0x00000289,
		0x03F, 0x00000EF0,
		0x033, 0x0000028A,
		0x03F, 0x00000EF3,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000205,
		0x033, 0x00000281,
		0x03F, 0x00000222,
		0x033, 0x00000282,
		0x03F, 0x00000225,
		0x033, 0x00000283,
		0x03F, 0x00000228,
		0x033, 0x00000284,
		0x03F, 0x0000022B,
		0x033, 0x00000285,
		0x03F, 0x00000428,
		0x033, 0x00000286,
		0x03F, 0x00000628,
		0x033, 0x00000287,
		0x03F, 0x0000062B,
		0x033, 0x00000288,
		0x03F, 0x0000064B,
		0x033, 0x00000289,
		0x03F, 0x0000066B,
		0x033, 0x0000028A,
		0x03F, 0x0000066E,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000205,
		0x033, 0x00000281,
		0x03F, 0x00000222,
		0x033, 0x00000282,
		0x03F, 0x00000225,
		0x033, 0x00000283,
		0x03F, 0x00000228,
		0x033, 0x00000284,
		0x03F, 0x0000022B,
		0x033, 0x00000285,
		0x03F, 0x00000428,
		0x033, 0x00000286,
		0x03F, 0x00000628,
		0x033, 0x00000287,
		0x03F, 0x0000062B,
		0x033, 0x00000288,
		0x03F, 0x0000064B,
		0x033, 0x00000289,
		0x03F, 0x0000066B,
		0x033, 0x0000028A,
		0x03F, 0x0000066E,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000205,
		0x033, 0x00000281,
		0x03F, 0x00000222,
		0x033, 0x00000282,
		0x03F, 0x00000225,
		0x033, 0x00000283,
		0x03F, 0x00000228,
		0x033, 0x00000284,
		0x03F, 0x0000022B,
		0x033, 0x00000285,
		0x03F, 0x00000428,
		0x033, 0x00000286,
		0x03F, 0x00000628,
		0x033, 0x00000287,
		0x03F, 0x0000062B,
		0x033, 0x00000288,
		0x03F, 0x0000064B,
		0x033, 0x00000289,
		0x03F, 0x0000066B,
		0x033, 0x0000028A,
		0x03F, 0x0000066E,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000205,
		0x033, 0x00000281,
		0x03F, 0x00000222,
		0x033, 0x00000282,
		0x03F, 0x00000225,
		0x033, 0x00000283,
		0x03F, 0x00000228,
		0x033, 0x00000284,
		0x03F, 0x0000022B,
		0x033, 0x00000285,
		0x03F, 0x00000428,
		0x033, 0x00000286,
		0x03F, 0x00000628,
		0x033, 0x00000287,
		0x03F, 0x0000062B,
		0x033, 0x00000288,
		0x03F, 0x0000064B,
		0x033, 0x00000289,
		0x03F, 0x0000066B,
		0x033, 0x0000028A,
		0x03F, 0x0000066E,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000445,
		0x033, 0x00000281,
		0x03F, 0x00000448,
		0x033, 0x00000282,
		0x03F, 0x00000648,
		0x033, 0x00000283,
		0x03F, 0x00000E47,
		0x033, 0x00000284,
		0x03F, 0x00000E67,
		0x033, 0x00000285,
		0x03F, 0x00000EC5,
		0x033, 0x00000286,
		0x03F, 0x00000EE7,
		0x033, 0x00000287,
		0x03F, 0x00000EEA,
		0x033, 0x00000288,
		0x03F, 0x00000EED,
		0x033, 0x00000289,
		0x03F, 0x00000EF0,
		0x033, 0x0000028A,
		0x03F, 0x00000EF3,
	0xA0000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000445,
		0x033, 0x00000281,
		0x03F, 0x00000448,
		0x033, 0x00000282,
		0x03F, 0x00000648,
		0x033, 0x00000283,
		0x03F, 0x00000E47,
		0x033, 0x00000284,
		0x03F, 0x00000E67,
		0x033, 0x00000285,
		0x03F, 0x00000EC5,
		0x033, 0x00000286,
		0x03F, 0x00000EE7,
		0x033, 0x00000287,
		0x03F, 0x00000EEA,
		0x033, 0x00000288,
		0x03F, 0x00000EED,
		0x033, 0x00000289,
		0x03F, 0x00000EF0,
		0x033, 0x0000028A,
		0x03F, 0x00000EF3,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000205,
		0x033, 0x00000301,
		0x03F, 0x00000222,
		0x033, 0x00000302,
		0x03F, 0x00000225,
		0x033, 0x00000303,
		0x03F, 0x00000228,
		0x033, 0x00000304,
		0x03F, 0x0000022B,
		0x033, 0x00000305,
		0x03F, 0x00000428,
		0x033, 0x00000306,
		0x03F, 0x0000042B,
		0x033, 0x00000307,
		0x03F, 0x0000062B,
		0x033, 0x00000308,
		0x03F, 0x00000668,
		0x033, 0x00000309,
		0x03F, 0x0000066B,
		0x033, 0x0000030A,
		0x03F, 0x0000066E,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000445,
		0x033, 0x00000301,
		0x03F, 0x00000448,
		0x033, 0x00000302,
		0x03F, 0x00000648,
		0x033, 0x00000303,
		0x03F, 0x00000E47,
		0x033, 0x00000304,
		0x03F, 0x00000E67,
		0x033, 0x00000305,
		0x03F, 0x00000EC5,
		0x033, 0x00000306,
		0x03F, 0x00000EE7,
		0x033, 0x00000307,
		0x03F, 0x00000EEA,
		0x033, 0x00000308,
		0x03F, 0x00000EED,
		0x033, 0x00000309,
		0x03F, 0x00000EF0,
		0x033, 0x0000030A,
		0x03F, 0x00000EF3,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000205,
		0x033, 0x00000301,
		0x03F, 0x00000222,
		0x033, 0x00000302,
		0x03F, 0x00000225,
		0x033, 0x00000303,
		0x03F, 0x00000228,
		0x033, 0x00000304,
		0x03F, 0x0000022B,
		0x033, 0x00000305,
		0x03F, 0x00000428,
		0x033, 0x00000306,
		0x03F, 0x0000042B,
		0x033, 0x00000307,
		0x03F, 0x0000062B,
		0x033, 0x00000308,
		0x03F, 0x00000668,
		0x033, 0x00000309,
		0x03F, 0x0000066B,
		0x033, 0x0000030A,
		0x03F, 0x0000066E,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000205,
		0x033, 0x00000301,
		0x03F, 0x00000222,
		0x033, 0x00000302,
		0x03F, 0x00000225,
		0x033, 0x00000303,
		0x03F, 0x00000228,
		0x033, 0x00000304,
		0x03F, 0x0000022B,
		0x033, 0x00000305,
		0x03F, 0x00000428,
		0x033, 0x00000306,
		0x03F, 0x0000042B,
		0x033, 0x00000307,
		0x03F, 0x0000062B,
		0x033, 0x00000308,
		0x03F, 0x00000668,
		0x033, 0x00000309,
		0x03F, 0x0000066B,
		0x033, 0x0000030A,
		0x03F, 0x0000066E,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000205,
		0x033, 0x00000301,
		0x03F, 0x00000222,
		0x033, 0x00000302,
		0x03F, 0x00000225,
		0x033, 0x00000303,
		0x03F, 0x00000228,
		0x033, 0x00000304,
		0x03F, 0x0000022B,
		0x033, 0x00000305,
		0x03F, 0x00000428,
		0x033, 0x00000306,
		0x03F, 0x0000042B,
		0x033, 0x00000307,
		0x03F, 0x0000062B,
		0x033, 0x00000308,
		0x03F, 0x00000668,
		0x033, 0x00000309,
		0x03F, 0x0000066B,
		0x033, 0x0000030A,
		0x03F, 0x0000066E,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000445,
		0x033, 0x00000301,
		0x03F, 0x00000448,
		0x033, 0x00000302,
		0x03F, 0x00000648,
		0x033, 0x00000303,
		0x03F, 0x00000E47,
		0x033, 0x00000304,
		0x03F, 0x00000E67,
		0x033, 0x00000305,
		0x03F, 0x00000EC5,
		0x033, 0x00000306,
		0x03F, 0x00000EE7,
		0x033, 0x00000307,
		0x03F, 0x00000EEA,
		0x033, 0x00000308,
		0x03F, 0x00000EED,
		0x033, 0x00000309,
		0x03F, 0x00000EF0,
		0x033, 0x0000030A,
		0x03F, 0x00000EF3,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000205,
		0x033, 0x00000301,
		0x03F, 0x00000222,
		0x033, 0x00000302,
		0x03F, 0x00000225,
		0x033, 0x00000303,
		0x03F, 0x00000228,
		0x033, 0x00000304,
		0x03F, 0x0000022B,
		0x033, 0x00000305,
		0x03F, 0x00000428,
		0x033, 0x00000306,
		0x03F, 0x0000042B,
		0x033, 0x00000307,
		0x03F, 0x0000062B,
		0x033, 0x00000308,
		0x03F, 0x00000668,
		0x033, 0x00000309,
		0x03F, 0x0000066B,
		0x033, 0x0000030A,
		0x03F, 0x0000066E,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000205,
		0x033, 0x00000301,
		0x03F, 0x00000222,
		0x033, 0x00000302,
		0x03F, 0x00000225,
		0x033, 0x00000303,
		0x03F, 0x00000228,
		0x033, 0x00000304,
		0x03F, 0x0000022B,
		0x033, 0x00000305,
		0x03F, 0x00000428,
		0x033, 0x00000306,
		0x03F, 0x0000042B,
		0x033, 0x00000307,
		0x03F, 0x0000062B,
		0x033, 0x00000308,
		0x03F, 0x00000668,
		0x033, 0x00000309,
		0x03F, 0x0000066B,
		0x033, 0x0000030A,
		0x03F, 0x0000066E,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000205,
		0x033, 0x00000301,
		0x03F, 0x00000222,
		0x033, 0x00000302,
		0x03F, 0x00000225,
		0x033, 0x00000303,
		0x03F, 0x00000228,
		0x033, 0x00000304,
		0x03F, 0x0000022B,
		0x033, 0x00000305,
		0x03F, 0x00000428,
		0x033, 0x00000306,
		0x03F, 0x0000042B,
		0x033, 0x00000307,
		0x03F, 0x0000062B,
		0x033, 0x00000308,
		0x03F, 0x00000668,
		0x033, 0x00000309,
		0x03F, 0x0000066B,
		0x033, 0x0000030A,
		0x03F, 0x0000066E,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000205,
		0x033, 0x00000301,
		0x03F, 0x00000222,
		0x033, 0x00000302,
		0x03F, 0x00000225,
		0x033, 0x00000303,
		0x03F, 0x00000228,
		0x033, 0x00000304,
		0x03F, 0x0000022B,
		0x033, 0x00000305,
		0x03F, 0x00000428,
		0x033, 0x00000306,
		0x03F, 0x0000042B,
		0x033, 0x00000307,
		0x03F, 0x0000062B,
		0x033, 0x00000308,
		0x03F, 0x00000668,
		0x033, 0x00000309,
		0x03F, 0x0000066B,
		0x033, 0x0000030A,
		0x03F, 0x0000066E,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000445,
		0x033, 0x00000301,
		0x03F, 0x00000448,
		0x033, 0x00000302,
		0x03F, 0x00000648,
		0x033, 0x00000303,
		0x03F, 0x00000E47,
		0x033, 0x00000304,
		0x03F, 0x00000E67,
		0x033, 0x00000305,
		0x03F, 0x00000EC5,
		0x033, 0x00000306,
		0x03F, 0x00000EE7,
		0x033, 0x00000307,
		0x03F, 0x00000EEA,
		0x033, 0x00000308,
		0x03F, 0x00000EED,
		0x033, 0x00000309,
		0x03F, 0x00000EF0,
		0x033, 0x0000030A,
		0x03F, 0x00000EF3,
	0xA0000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000445,
		0x033, 0x00000301,
		0x03F, 0x00000448,
		0x033, 0x00000302,
		0x03F, 0x00000648,
		0x033, 0x00000303,
		0x03F, 0x00000E47,
		0x033, 0x00000304,
		0x03F, 0x00000E67,
		0x033, 0x00000305,
		0x03F, 0x00000EC5,
		0x033, 0x00000306,
		0x03F, 0x00000EE7,
		0x033, 0x00000307,
		0x03F, 0x00000EEA,
		0x033, 0x00000308,
		0x03F, 0x00000EED,
		0x033, 0x00000309,
		0x03F, 0x00000EF0,
		0x033, 0x0000030A,
		0x03F, 0x00000EF3,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00040000,
		0x033, 0x00000001,
		0x03F, 0x000C0001,
		0x0EE, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00040000,
		0x033, 0x00000001,
		0x03F, 0x000C0001,
		0x0EE, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00040000,
		0x033, 0x00000001,
		0x03F, 0x000C0001,
		0x0EE, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00040000,
		0x033, 0x00000001,
		0x03F, 0x000C0001,
		0x0EE, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00040000,
		0x033, 0x00000001,
		0x03F, 0x000C0001,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00040000,
		0x033, 0x00000001,
		0x03F, 0x000C0001,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x030, 0x00000000,
		0x03F, 0x000150F9,
		0x030, 0x00010000,
		0x03F, 0x000150F9,
		0x030, 0x00020000,
		0x03F, 0x000150F9,
		0x030, 0x00030000,
		0x03F, 0x000150F9,
		0x030, 0x00040000,
		0x03F, 0x000150F9,
		0x030, 0x00050000,
		0x03F, 0x000150F9,
		0x030, 0x00060000,
		0x03F, 0x000150F9,
		0x030, 0x00070000,
		0x03F, 0x000150F9,
		0x030, 0x00080000,
		0x03F, 0x000150F9,
		0x030, 0x00090000,
		0x03F, 0x000150F9,
		0x030, 0x000A0000,
		0x03F, 0x000150F9,
		0x030, 0x000B0000,
		0x03F, 0x000150F9,
		0x030, 0x000C0000,
		0x03F, 0x000150F9,
		0x030, 0x000D0000,
		0x03F, 0x000150F9,
		0x030, 0x000E0000,
		0x03F, 0x000150F9,
		0x030, 0x000F0000,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x030, 0x00000000,
		0x03F, 0x000150F9,
		0x030, 0x00010000,
		0x03F, 0x000150F9,
		0x030, 0x00020000,
		0x03F, 0x000150F9,
		0x030, 0x00030000,
		0x03F, 0x000150F9,
		0x030, 0x00040000,
		0x03F, 0x000150F9,
		0x030, 0x00050000,
		0x03F, 0x000150F9,
		0x030, 0x00060000,
		0x03F, 0x000150F9,
		0x030, 0x00070000,
		0x03F, 0x000150F9,
		0x030, 0x00080000,
		0x03F, 0x000150F9,
		0x030, 0x00090000,
		0x03F, 0x000150F9,
		0x030, 0x000A0000,
		0x03F, 0x000150F9,
		0x030, 0x000B0000,
		0x03F, 0x000150F9,
		0x030, 0x000C0000,
		0x03F, 0x000150F9,
		0x030, 0x000D0000,
		0x03F, 0x000150F9,
		0x030, 0x000E0000,
		0x03F, 0x000150F9,
		0x030, 0x000F0000,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x030, 0x00000000,
		0x03F, 0x000150F9,
		0x030, 0x00010000,
		0x03F, 0x000150F9,
		0x030, 0x00020000,
		0x03F, 0x000150F9,
		0x030, 0x00030000,
		0x03F, 0x000150F9,
		0x030, 0x00040000,
		0x03F, 0x000150F9,
		0x030, 0x00050000,
		0x03F, 0x000150F9,
		0x030, 0x00060000,
		0x03F, 0x000150F9,
		0x030, 0x00070000,
		0x03F, 0x000150F9,
		0x030, 0x00080000,
		0x03F, 0x000150F9,
		0x030, 0x00090000,
		0x03F, 0x000150F9,
		0x030, 0x000A0000,
		0x03F, 0x000150F9,
		0x030, 0x000B0000,
		0x03F, 0x000150F9,
		0x030, 0x000C0000,
		0x03F, 0x000150F9,
		0x030, 0x000D0000,
		0x03F, 0x000150F9,
		0x030, 0x000E0000,
		0x03F, 0x000150F9,
		0x030, 0x000F0000,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x030, 0x00000000,
		0x03F, 0x000150F9,
		0x030, 0x00010000,
		0x03F, 0x000150F9,
		0x030, 0x00020000,
		0x03F, 0x000150F9,
		0x030, 0x00030000,
		0x03F, 0x000150F9,
		0x030, 0x00040000,
		0x03F, 0x000150F9,
		0x030, 0x00050000,
		0x03F, 0x000150F9,
		0x030, 0x00060000,
		0x03F, 0x000150F9,
		0x030, 0x00070000,
		0x03F, 0x000150F9,
		0x030, 0x00080000,
		0x03F, 0x000150F9,
		0x030, 0x00090000,
		0x03F, 0x000150F9,
		0x030, 0x000A0000,
		0x03F, 0x000150F9,
		0x030, 0x000B0000,
		0x03F, 0x000150F9,
		0x030, 0x000C0000,
		0x03F, 0x000150F9,
		0x030, 0x000D0000,
		0x03F, 0x000150F9,
		0x030, 0x000E0000,
		0x03F, 0x000150F9,
		0x030, 0x000F0000,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x030, 0x00000000,
		0x03F, 0x000150F9,
		0x030, 0x00010000,
		0x03F, 0x000150F9,
		0x030, 0x00020000,
		0x03F, 0x000150F9,
		0x030, 0x00030000,
		0x03F, 0x000150F9,
		0x030, 0x00040000,
		0x03F, 0x000150F9,
		0x030, 0x00050000,
		0x03F, 0x000150F9,
		0x030, 0x00060000,
		0x03F, 0x000150F9,
		0x030, 0x00070000,
		0x03F, 0x000150F9,
		0x030, 0x00080000,
		0x03F, 0x000150F9,
		0x030, 0x00090000,
		0x03F, 0x000150F9,
		0x030, 0x000A0000,
		0x03F, 0x000150F9,
		0x030, 0x000B0000,
		0x03F, 0x000150F9,
		0x030, 0x000C0000,
		0x03F, 0x000150F9,
		0x030, 0x000D0000,
		0x03F, 0x000150F9,
		0x030, 0x000E0000,
		0x03F, 0x000150F9,
		0x030, 0x000F0000,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000400,
		0x030, 0x00000000,
		0x03F, 0x000150F9,
		0x030, 0x00010000,
		0x03F, 0x000150F9,
		0x030, 0x00020000,
		0x03F, 0x000150F9,
		0x030, 0x00030000,
		0x03F, 0x000150F9,
		0x030, 0x00040000,
		0x03F, 0x000150F9,
		0x030, 0x00050000,
		0x03F, 0x000150F9,
		0x030, 0x00060000,
		0x03F, 0x000150F9,
		0x030, 0x00070000,
		0x03F, 0x000150F9,
		0x030, 0x00080000,
		0x03F, 0x000150F9,
		0x030, 0x00090000,
		0x03F, 0x000150F9,
		0x030, 0x000A0000,
		0x03F, 0x000150F9,
		0x030, 0x000B0000,
		0x03F, 0x000150F9,
		0x030, 0x000C0000,
		0x03F, 0x000150F9,
		0x030, 0x000D0000,
		0x03F, 0x000150F9,
		0x030, 0x000E0000,
		0x03F, 0x000150F9,
		0x030, 0x000F0000,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000001,
		0x03F, 0x000150F9,
		0x033, 0x0000000B,
		0x03F, 0x000150F9,
		0x033, 0x00000023,
		0x03F, 0x000150F9,
		0x033, 0x00000029,
		0x03F, 0x000150F9,
		0x033, 0x0000002A,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000001,
		0x03F, 0x000150F9,
		0x033, 0x0000000B,
		0x03F, 0x000150F9,
		0x033, 0x00000023,
		0x03F, 0x000150F9,
		0x033, 0x00000029,
		0x03F, 0x000150F9,
		0x033, 0x0000002A,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000001,
		0x03F, 0x000150F9,
		0x033, 0x0000000B,
		0x03F, 0x000150F9,
		0x033, 0x00000023,
		0x03F, 0x000150F9,
		0x033, 0x00000029,
		0x03F, 0x000150F9,
		0x033, 0x0000002A,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000001,
		0x03F, 0x000150F9,
		0x033, 0x0000000B,
		0x03F, 0x000150F9,
		0x033, 0x00000023,
		0x03F, 0x000150F9,
		0x033, 0x00000029,
		0x03F, 0x000150F9,
		0x033, 0x0000002A,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000001,
		0x03F, 0x000150F9,
		0x033, 0x0000000B,
		0x03F, 0x000150F9,
		0x033, 0x00000023,
		0x03F, 0x000150F9,
		0x033, 0x00000029,
		0x03F, 0x000150F9,
		0x033, 0x0000002A,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000001,
		0x03F, 0x000150F9,
		0x033, 0x0000000B,
		0x03F, 0x000150F9,
		0x033, 0x00000023,
		0x03F, 0x000150F9,
		0x033, 0x00000029,
		0x03F, 0x000150F9,
		0x033, 0x0000002A,
		0x03F, 0x000150F9,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x00000054,
		0x030, 0x00001054,
		0x030, 0x00002054,
		0x030, 0x00003054,
		0x030, 0x00004024,
		0x030, 0x00005024,
		0x030, 0x00006024,
		0x030, 0x00007024,
		0x030, 0x00008024,
		0x030, 0x00009024,
		0x030, 0x0000A024,
		0x030, 0x0000B024,
		0x0EE, 0x00000000,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x00000254,
		0x030, 0x00001254,
		0x030, 0x00002254,
		0x030, 0x00003254,
		0x030, 0x00004474,
		0x030, 0x00005474,
		0x030, 0x00006474,
		0x030, 0x00007474,
		0x030, 0x00008484,
		0x030, 0x00009484,
		0x030, 0x0000A484,
		0x030, 0x0000B484,
		0x0EE, 0x00000000,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x00000054,
		0x030, 0x00001054,
		0x030, 0x00002054,
		0x030, 0x00003054,
		0x030, 0x00004024,
		0x030, 0x00005024,
		0x030, 0x00006024,
		0x030, 0x00007024,
		0x030, 0x00008024,
		0x030, 0x00009024,
		0x030, 0x0000A024,
		0x030, 0x0000B024,
		0x0EE, 0x00000000,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x00000054,
		0x030, 0x00001054,
		0x030, 0x00002054,
		0x030, 0x00003054,
		0x030, 0x00004024,
		0x030, 0x00005024,
		0x030, 0x00006024,
		0x030, 0x00007024,
		0x030, 0x00008024,
		0x030, 0x00009024,
		0x030, 0x0000A024,
		0x030, 0x0000B024,
		0x0EE, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x00000054,
		0x030, 0x00001054,
		0x030, 0x00002054,
		0x030, 0x00003054,
		0x030, 0x00004024,
		0x030, 0x00005024,
		0x030, 0x00006024,
		0x030, 0x00007024,
		0x030, 0x00008024,
		0x030, 0x00009024,
		0x030, 0x0000A024,
		0x030, 0x0000B024,
		0x0EE, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x00000254,
		0x030, 0x00001254,
		0x030, 0x00002254,
		0x030, 0x00003254,
		0x030, 0x00004474,
		0x030, 0x00005474,
		0x030, 0x00006474,
		0x030, 0x00007474,
		0x030, 0x00008484,
		0x030, 0x00009484,
		0x030, 0x0000A484,
		0x030, 0x0000B484,
		0x0EE, 0x00000000,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x00000054,
		0x030, 0x00001054,
		0x030, 0x00002054,
		0x030, 0x00003054,
		0x030, 0x00004024,
		0x030, 0x00005024,
		0x030, 0x00006024,
		0x030, 0x00007024,
		0x030, 0x00008024,
		0x030, 0x00009024,
		0x030, 0x0000A024,
		0x030, 0x0000B024,
		0x0EE, 0x00000000,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x00000054,
		0x030, 0x00001054,
		0x030, 0x00002054,
		0x030, 0x00003054,
		0x030, 0x00004024,
		0x030, 0x00005024,
		0x030, 0x00006024,
		0x030, 0x00007024,
		0x030, 0x00008024,
		0x030, 0x00009024,
		0x030, 0x0000A024,
		0x030, 0x0000B024,
		0x0EE, 0x00000000,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x00000054,
		0x030, 0x00001054,
		0x030, 0x00002054,
		0x030, 0x00003054,
		0x030, 0x00004024,
		0x030, 0x00005024,
		0x030, 0x00006024,
		0x030, 0x00007024,
		0x030, 0x00008024,
		0x030, 0x00009024,
		0x030, 0x0000A024,
		0x030, 0x0000B024,
		0x0EE, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x00000054,
		0x030, 0x00001054,
		0x030, 0x00002054,
		0x030, 0x00003054,
		0x030, 0x00004024,
		0x030, 0x00005024,
		0x030, 0x00006024,
		0x030, 0x00007024,
		0x030, 0x00008024,
		0x030, 0x00009024,
		0x030, 0x0000A024,
		0x030, 0x0000B024,
		0x0EE, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x00000254,
		0x030, 0x00001254,
		0x030, 0x00002254,
		0x030, 0x00003254,
		0x030, 0x00004474,
		0x030, 0x00005474,
		0x030, 0x00006474,
		0x030, 0x00007474,
		0x030, 0x00008484,
		0x030, 0x00009484,
		0x030, 0x0000A484,
		0x030, 0x0000B484,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x00000254,
		0x030, 0x00001254,
		0x030, 0x00002254,
		0x030, 0x00003254,
		0x030, 0x00004474,
		0x030, 0x00005474,
		0x030, 0x00006474,
		0x030, 0x00007474,
		0x030, 0x00008484,
		0x030, 0x00009484,
		0x030, 0x0000A484,
		0x030, 0x0000B484,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000400,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x0EE, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000400,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x0EE, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000400,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x0EE, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000400,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x0EE, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000400,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000400,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x00000054,
		0x030, 0x00001054,
		0x030, 0x00002054,
		0x030, 0x00003054,
		0x030, 0x00004054,
		0x030, 0x00005054,
		0x030, 0x00006024,
		0x030, 0x00007024,
		0x030, 0x00008024,
		0x030, 0x00009024,
		0x030, 0x0000A024,
		0x030, 0x0000B024,
		0x030, 0x0000C024,
		0x030, 0x0000D024,
		0x030, 0x0000E024,
		0x0EE, 0x00000000,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x00000254,
		0x030, 0x00001254,
		0x030, 0x00002254,
		0x030, 0x00003254,
		0x030, 0x00004254,
		0x030, 0x00005254,
		0x030, 0x00006474,
		0x030, 0x00007474,
		0x030, 0x00008474,
		0x030, 0x00009474,
		0x030, 0x0000A474,
		0x030, 0x0000B484,
		0x030, 0x0000C484,
		0x030, 0x0000D484,
		0x030, 0x0000E484,
		0x0EE, 0x00000000,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x00000054,
		0x030, 0x00001054,
		0x030, 0x00002054,
		0x030, 0x00003054,
		0x030, 0x00004054,
		0x030, 0x00005054,
		0x030, 0x00006024,
		0x030, 0x00007024,
		0x030, 0x00008024,
		0x030, 0x00009024,
		0x030, 0x0000A024,
		0x030, 0x0000B024,
		0x030, 0x0000C024,
		0x030, 0x0000D024,
		0x030, 0x0000E024,
		0x0EE, 0x00000000,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x00000054,
		0x030, 0x00001054,
		0x030, 0x00002054,
		0x030, 0x00003054,
		0x030, 0x00004054,
		0x030, 0x00005054,
		0x030, 0x00006024,
		0x030, 0x00007024,
		0x030, 0x00008024,
		0x030, 0x00009024,
		0x030, 0x0000A024,
		0x030, 0x0000B024,
		0x030, 0x0000C024,
		0x030, 0x0000D024,
		0x030, 0x0000E024,
		0x0EE, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x00000054,
		0x030, 0x00001054,
		0x030, 0x00002054,
		0x030, 0x00003054,
		0x030, 0x00004054,
		0x030, 0x00005054,
		0x030, 0x00006024,
		0x030, 0x00007024,
		0x030, 0x00008024,
		0x030, 0x00009024,
		0x030, 0x0000A024,
		0x030, 0x0000B024,
		0x030, 0x0000C024,
		0x030, 0x0000D024,
		0x030, 0x0000E024,
		0x0EE, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x00000254,
		0x030, 0x00001254,
		0x030, 0x00002254,
		0x030, 0x00003254,
		0x030, 0x00004254,
		0x030, 0x00005254,
		0x030, 0x00006474,
		0x030, 0x00007474,
		0x030, 0x00008474,
		0x030, 0x00009474,
		0x030, 0x0000A474,
		0x030, 0x0000B484,
		0x030, 0x0000C484,
		0x030, 0x0000D484,
		0x030, 0x0000E484,
		0x0EE, 0x00000000,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x00000054,
		0x030, 0x00001054,
		0x030, 0x00002054,
		0x030, 0x00003054,
		0x030, 0x00004054,
		0x030, 0x00005054,
		0x030, 0x00006024,
		0x030, 0x00007024,
		0x030, 0x00008024,
		0x030, 0x00009024,
		0x030, 0x0000A024,
		0x030, 0x0000B024,
		0x030, 0x0000C024,
		0x030, 0x0000D024,
		0x030, 0x0000E024,
		0x0EE, 0x00000000,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x00000054,
		0x030, 0x00001054,
		0x030, 0x00002054,
		0x030, 0x00003054,
		0x030, 0x00004054,
		0x030, 0x00005054,
		0x030, 0x00006024,
		0x030, 0x00007024,
		0x030, 0x00008024,
		0x030, 0x00009024,
		0x030, 0x0000A024,
		0x030, 0x0000B024,
		0x030, 0x0000C024,
		0x030, 0x0000D024,
		0x030, 0x0000E024,
		0x0EE, 0x00000000,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x00000054,
		0x030, 0x00001054,
		0x030, 0x00002054,
		0x030, 0x00003054,
		0x030, 0x00004054,
		0x030, 0x00005054,
		0x030, 0x00006024,
		0x030, 0x00007024,
		0x030, 0x00008024,
		0x030, 0x00009024,
		0x030, 0x0000A024,
		0x030, 0x0000B024,
		0x030, 0x0000C024,
		0x030, 0x0000D024,
		0x030, 0x0000E024,
		0x0EE, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x00000054,
		0x030, 0x00001054,
		0x030, 0x00002054,
		0x030, 0x00003054,
		0x030, 0x00004054,
		0x030, 0x00005054,
		0x030, 0x00006024,
		0x030, 0x00007024,
		0x030, 0x00008024,
		0x030, 0x00009024,
		0x030, 0x0000A024,
		0x030, 0x0000B024,
		0x030, 0x0000C024,
		0x030, 0x0000D024,
		0x030, 0x0000E024,
		0x0EE, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x00000254,
		0x030, 0x00001254,
		0x030, 0x00002254,
		0x030, 0x00003254,
		0x030, 0x00004254,
		0x030, 0x00005254,
		0x030, 0x00006474,
		0x030, 0x00007474,
		0x030, 0x00008474,
		0x030, 0x00009474,
		0x030, 0x0000A474,
		0x030, 0x0000B484,
		0x030, 0x0000C484,
		0x030, 0x0000D484,
		0x030, 0x0000E484,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x00000254,
		0x030, 0x00001254,
		0x030, 0x00002254,
		0x030, 0x00003254,
		0x030, 0x00004254,
		0x030, 0x00005254,
		0x030, 0x00006474,
		0x030, 0x00007474,
		0x030, 0x00008474,
		0x030, 0x00009474,
		0x030, 0x0000A474,
		0x030, 0x0000B484,
		0x030, 0x0000C484,
		0x030, 0x0000D484,
		0x030, 0x0000E484,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000800,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x030, 0x0000C0B8,
		0x030, 0x0000D0B8,
		0x030, 0x0000E0B8,
		0x0EE, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000800,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x030, 0x0000C0B8,
		0x030, 0x0000D0B8,
		0x030, 0x0000E0B8,
		0x0EE, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000800,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x030, 0x0000C0B8,
		0x030, 0x0000D0B8,
		0x030, 0x0000E0B8,
		0x0EE, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000800,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x030, 0x0000C0B8,
		0x030, 0x0000D0B8,
		0x030, 0x0000E0B8,
		0x0EE, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000800,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x030, 0x0000C0B8,
		0x030, 0x0000D0B8,
		0x030, 0x0000E0B8,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000800,
		0x030, 0x000000B8,
		0x030, 0x000010B8,
		0x030, 0x000020B8,
		0x030, 0x000030B8,
		0x030, 0x000040B8,
		0x030, 0x000050B8,
		0x030, 0x000060B8,
		0x030, 0x000070B8,
		0x030, 0x000080B8,
		0x030, 0x000090B8,
		0x030, 0x0000A0B8,
		0x030, 0x0000B0B8,
		0x030, 0x0000C0B8,
		0x030, 0x0000D0B8,
		0x030, 0x0000E0B8,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00001000,
		0x030, 0x00000CDE,
		0x030, 0x00001778,
		0x030, 0x00002351,
		0x030, 0x00003351,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x030, 0x00007000,
		0x0EE, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00001000,
		0x030, 0x00000CDE,
		0x030, 0x00001778,
		0x030, 0x00002351,
		0x030, 0x00003351,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x030, 0x00007000,
		0x0EE, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00001000,
		0x030, 0x00000CDE,
		0x030, 0x00001778,
		0x030, 0x00002351,
		0x030, 0x00003351,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x030, 0x00007000,
		0x0EE, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00001000,
		0x030, 0x00000CDE,
		0x030, 0x00001778,
		0x030, 0x00002351,
		0x030, 0x00003351,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x030, 0x00007000,
		0x0EE, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00001000,
		0x030, 0x00000CDE,
		0x030, 0x00001778,
		0x030, 0x00002351,
		0x030, 0x00003351,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x030, 0x00007000,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00001000,
		0x030, 0x00000CDE,
		0x030, 0x00001778,
		0x030, 0x00002351,
		0x030, 0x00003351,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x030, 0x00007000,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x0004026A,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x0004026A,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x0004026A,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x0004026A,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x0004026A,
	0xA0000000,	0x00000000,
		0x063, 0x0004026A,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000D8DEF,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x00008DF7,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000D8DEF,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000D8DEF,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000D8DEF,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x00008DF7,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000D8DEF,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000D8DEF,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000D8DEF,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000D8DEF,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x00008DF7,
	0xA0000000,	0x00000000,
		0x08A, 0x00008DF7,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A6560,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A6560,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A6560,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A6560,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A6560,
	0xA0000000,	0x00000000,
		0x08E, 0x000A6560,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00020000,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000006,
		0x03E, 0x00008801,
		0x03F, 0x00017903,
		0x033, 0x00000005,
		0x03E, 0x00008806,
		0x03F, 0x00007903,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00027903,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000000,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x00000006,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x00000005,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000000,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000006,
		0x03E, 0x00008803,
		0x03F, 0x00017903,
		0x033, 0x00000005,
		0x03E, 0x00008806,
		0x03F, 0x00027903,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00077903,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000000,
		0x03E, 0x00008921,
		0x03F, 0x00017903,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000006,
		0x03E, 0x00008801,
		0x03F, 0x00027903,
		0x033, 0x00000005,
		0x03E, 0x00008806,
		0x03F, 0x00007903,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00027903,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000000,
		0x03E, 0x000088C2,
		0x03F, 0x00027903,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000006,
		0x03E, 0x00008801,
		0x03F, 0x00017903,
		0x033, 0x00000005,
		0x03E, 0x00008806,
		0x03F, 0x00007903,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00027903,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000000,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x00000006,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x00000005,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000000,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000006,
		0x03E, 0x00008801,
		0x03F, 0x00017903,
		0x033, 0x00000005,
		0x03E, 0x00008806,
		0x03F, 0x00007903,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00027903,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000000,
		0x03E, 0x000088C2,
		0x03F, 0x00007903,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000006,
		0x03E, 0x00008803,
		0x03F, 0x00017903,
		0x033, 0x00000005,
		0x03E, 0x00008806,
		0x03F, 0x00027903,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00077903,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000000,
		0x03E, 0x00008921,
		0x03F, 0x00017903,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000006,
		0x03E, 0x00008801,
		0x03F, 0x00027903,
		0x033, 0x00000005,
		0x03E, 0x00008806,
		0x03F, 0x00007903,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00027903,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000000,
		0x03E, 0x000088C2,
		0x03F, 0x00027903,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000006,
		0x03E, 0x00008801,
		0x03F, 0x00017903,
		0x033, 0x00000005,
		0x03E, 0x00008806,
		0x03F, 0x00007903,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00027903,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000000,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x00000006,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x00000005,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000000,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
	0xA0000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x00000006,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x00000005,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x00000004,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x00000003,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x00000002,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000001,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000000,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x0000000E,
		0x03E, 0x00008802,
		0x03F, 0x00007903,
		0x033, 0x0000000D,
		0x03E, 0x00008806,
		0x03F, 0x00027903,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00057903,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000008,
		0x03E, 0x00008922,
		0x03F, 0x00007903,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x0000000E,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x0000000D,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000008,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x0000000E,
		0x03E, 0x00008802,
		0x03F, 0x00037903,
		0x033, 0x0000000D,
		0x03E, 0x00008806,
		0x03F, 0x00007903,
		0x033, 0x0000000C,
		0x03E, 0x00008824,
		0x03F, 0x00027903,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00077903,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000008,
		0x03E, 0x00008920,
		0x03F, 0x00007903,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x0000000E,
		0x03E, 0x00008801,
		0x03F, 0x00017903,
		0x033, 0x0000000D,
		0x03E, 0x00008806,
		0x03F, 0x00027903,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00057903,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000008,
		0x03E, 0x00008922,
		0x03F, 0x00027903,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x0000000E,
		0x03E, 0x00008802,
		0x03F, 0x00007903,
		0x033, 0x0000000D,
		0x03E, 0x00008806,
		0x03F, 0x00027903,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00057903,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000008,
		0x03E, 0x00008922,
		0x03F, 0x00007903,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x0000000E,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x0000000D,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000008,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x0000000E,
		0x03E, 0x00008802,
		0x03F, 0x00007903,
		0x033, 0x0000000D,
		0x03E, 0x00008806,
		0x03F, 0x00027903,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00057903,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000008,
		0x03E, 0x00008921,
		0x03F, 0x00017903,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x0000000E,
		0x03E, 0x00008802,
		0x03F, 0x00037903,
		0x033, 0x0000000D,
		0x03E, 0x00008806,
		0x03F, 0x00007903,
		0x033, 0x0000000C,
		0x03E, 0x00008824,
		0x03F, 0x00027903,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00077903,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000008,
		0x03E, 0x00008920,
		0x03F, 0x00007903,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x0000000E,
		0x03E, 0x00008801,
		0x03F, 0x00017903,
		0x033, 0x0000000D,
		0x03E, 0x00008806,
		0x03F, 0x00027903,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00057903,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000008,
		0x03E, 0x00008922,
		0x03F, 0x00027903,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x0000000E,
		0x03E, 0x00008802,
		0x03F, 0x00007903,
		0x033, 0x0000000D,
		0x03E, 0x00008806,
		0x03F, 0x00027903,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00057903,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000008,
		0x03E, 0x00008922,
		0x03F, 0x00007903,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x0000000E,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x0000000D,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000008,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
	0xA0000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x0000000E,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x0000000D,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x0000000C,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x0000000B,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x0000000A,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000009,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000008,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000016,
		0x03E, 0x00008802,
		0x03F, 0x00027903,
		0x033, 0x00000015,
		0x03E, 0x00008806,
		0x03F, 0x00017903,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00047903,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000010,
		0x03E, 0x00008920,
		0x03F, 0x00007903,
		0x0EF, 0x00000000,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x00000016,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x00000015,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000010,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
		0x0EF, 0x00000000,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000016,
		0x03E, 0x00008802,
		0x03F, 0x00007903,
		0x033, 0x00000015,
		0x03E, 0x00008806,
		0x03F, 0x00027903,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00057903,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00067903,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000010,
		0x03E, 0x00008920,
		0x03F, 0x00007903,
		0x0EF, 0x00000000,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000016,
		0x03E, 0x00008802,
		0x03F, 0x00007903,
		0x033, 0x00000015,
		0x03E, 0x00008806,
		0x03F, 0x00017903,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00047903,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000010,
		0x03E, 0x00008920,
		0x03F, 0x00017903,
		0x0EF, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000016,
		0x03E, 0x00008802,
		0x03F, 0x00027903,
		0x033, 0x00000015,
		0x03E, 0x00008806,
		0x03F, 0x00017903,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00047903,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000010,
		0x03E, 0x00008920,
		0x03F, 0x00007903,
		0x0EF, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x00000016,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x00000015,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000010,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
		0x0EF, 0x00000000,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000016,
		0x03E, 0x00008802,
		0x03F, 0x00007903,
		0x033, 0x00000015,
		0x03E, 0x00008806,
		0x03F, 0x00017903,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00047903,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000010,
		0x03E, 0x00008920,
		0x03F, 0x00017903,
		0x0EF, 0x00000000,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000016,
		0x03E, 0x00008802,
		0x03F, 0x00007903,
		0x033, 0x00000015,
		0x03E, 0x00008806,
		0x03F, 0x00027903,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00057903,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00067903,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000010,
		0x03E, 0x00008920,
		0x03F, 0x00007903,
		0x0EF, 0x00000000,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000016,
		0x03E, 0x00008802,
		0x03F, 0x00007903,
		0x033, 0x00000015,
		0x03E, 0x00008806,
		0x03F, 0x00017903,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00047903,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000010,
		0x03E, 0x00008920,
		0x03F, 0x00017903,
		0x0EF, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007903,
		0x033, 0x00000016,
		0x03E, 0x00008802,
		0x03F, 0x00027903,
		0x033, 0x00000015,
		0x03E, 0x00008806,
		0x03F, 0x00017903,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027903,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00047903,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007903,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00007903,
		0x033, 0x00000010,
		0x03E, 0x00008920,
		0x03F, 0x00007903,
		0x0EF, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x00000016,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x00000015,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000010,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008800,
		0x03F, 0x00007983,
		0x033, 0x00000016,
		0x03E, 0x00008802,
		0x03F, 0x00007983,
		0x033, 0x00000015,
		0x03E, 0x00008806,
		0x03F, 0x00007983,
		0x033, 0x00000014,
		0x03E, 0x00008807,
		0x03F, 0x00027983,
		0x033, 0x00000013,
		0x03E, 0x00008827,
		0x03F, 0x00057983,
		0x033, 0x00000012,
		0x03E, 0x00008860,
		0x03F, 0x00007983,
		0x033, 0x00000011,
		0x03E, 0x000088A0,
		0x03F, 0x00007983,
		0x033, 0x00000010,
		0x03E, 0x00008922,
		0x03F, 0x00007983,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x0000000D,
		0x033, 0x00000001,
		0x03F, 0x00000004,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x0000000D,
		0x033, 0x00000001,
		0x03F, 0x00000004,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x0000000D,
		0x033, 0x00000001,
		0x03F, 0x00000004,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x0000000D,
		0x033, 0x00000001,
		0x03F, 0x00000004,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x0000000D,
		0x033, 0x00000001,
		0x03F, 0x00000004,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x0000000D,
		0x033, 0x00000001,
		0x03F, 0x00000004,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x00000000,
		0x03F, 0x000C0000,
		0x033, 0x00000001,
		0x03F, 0x000C0000,
		0x0EF, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x00000000,
		0x03F, 0x000C0000,
		0x033, 0x00000001,
		0x03F, 0x000C0000,
		0x0EF, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x00000000,
		0x03F, 0x000C0000,
		0x033, 0x00000001,
		0x03F, 0x000C0000,
		0x0EF, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x00000000,
		0x03F, 0x000C0000,
		0x033, 0x00000001,
		0x03F, 0x000C0000,
		0x0EF, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x00000000,
		0x03F, 0x000C0000,
		0x033, 0x00000001,
		0x03F, 0x000C0000,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x00000000,
		0x03F, 0x000C0000,
		0x033, 0x00000001,
		0x03F, 0x000C0000,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0xA0000000,	0x00000000,
		0x018, 0x00013124,
	0xB0000000,	0x00000000,
		0x0FE, 0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x01B, 0x00000240,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x01B, 0x00000240,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x01B, 0x00000240,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x01B, 0x00000240,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x01B, 0x00000240,
	0xA0000000,	0x00000000,
		0x01B, 0x00000240,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000002,
		0x033, 0x00000010,
		0x03F, 0x00000041,
		0x033, 0x00000011,
		0x03F, 0x000009A6,
		0x033, 0x00000012,
		0x03F, 0x00000AAA,
		0x033, 0x00000013,
		0x03F, 0x00000B6D,
		0x0EE, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000002,
		0x033, 0x00000010,
		0x03F, 0x00000041,
		0x033, 0x00000011,
		0x03F, 0x000009A6,
		0x033, 0x00000012,
		0x03F, 0x00000AAA,
		0x033, 0x00000013,
		0x03F, 0x00000B6D,
		0x0EE, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000002,
		0x033, 0x00000010,
		0x03F, 0x00000041,
		0x033, 0x00000011,
		0x03F, 0x000009A6,
		0x033, 0x00000012,
		0x03F, 0x00000AAA,
		0x033, 0x00000013,
		0x03F, 0x00000B6D,
		0x0EE, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000002,
		0x033, 0x00000010,
		0x03F, 0x00000041,
		0x033, 0x00000011,
		0x03F, 0x000009A6,
		0x033, 0x00000012,
		0x03F, 0x00000AAA,
		0x033, 0x00000013,
		0x03F, 0x00000B6D,
		0x0EE, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000002,
		0x033, 0x00000010,
		0x03F, 0x00000041,
		0x033, 0x00000011,
		0x03F, 0x000009A6,
		0x033, 0x00000012,
		0x03F, 0x00000AAA,
		0x033, 0x00000013,
		0x03F, 0x00000B6D,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000002,
		0x033, 0x00000010,
		0x03F, 0x00000041,
		0x033, 0x00000011,
		0x03F, 0x000009A6,
		0x033, 0x00000012,
		0x03F, 0x00000AAA,
		0x033, 0x00000013,
		0x03F, 0x00000B6D,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0DE, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0DE, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0DE, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0DE, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0DE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0DE, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x057, 0x0004B5AA,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x057, 0x0004B5AA,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x057, 0x0004B5AA,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x057, 0x0004B5AA,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x057, 0x0004B5AA,
	0xA0000000,	0x00000000,
		0x057, 0x0004B5AA,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000010,
		0x008, 0x00078200,
		0x0EF, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000010,
		0x008, 0x00078200,
		0x0EF, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000010,
		0x008, 0x00078200,
		0x0EF, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000010,
		0x008, 0x00078200,
		0x0EF, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000010,
		0x008, 0x00078200,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000010,
		0x008, 0x00078200,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x018, 0x00000C03,
		0x08F, 0x00000AAC,
		0x069, 0x0000003F,
		0x067, 0x00084200,
		0x067, 0x00084201,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x018, 0x00000C03,
		0x08F, 0x00000AAC,
		0x069, 0x0000003F,
		0x067, 0x00084200,
		0x067, 0x00084201,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x018, 0x00000C03,
		0x08F, 0x00000AAC,
		0x069, 0x0000003F,
		0x067, 0x00084200,
		0x067, 0x00084201,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x018, 0x00000C03,
		0x08F, 0x00000AAC,
		0x069, 0x0000003F,
		0x067, 0x00084200,
		0x067, 0x00084201,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x018, 0x00000C03,
		0x08F, 0x00000AAC,
		0x069, 0x0000003F,
		0x067, 0x00084200,
		0x067, 0x00084201,
	0xA0000000,	0x00000000,
		0x000, 0x00030000,
		0x018, 0x00000C03,
		0x08F, 0x00000AAC,
		0x069, 0x0000003F,
		0x067, 0x00084200,
		0x067, 0x00084201,
	0xB0000000,	0x00000000,
		0xFFE, 0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x00084200,
		0x0DF, 0x00002000,
		0x082, 0x00003364,
		0x068, 0x00084210,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x00084200,
		0x0DF, 0x00002000,
		0x082, 0x00003364,
		0x068, 0x00084210,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x00084200,
		0x0DF, 0x00002000,
		0x082, 0x00003364,
		0x068, 0x00084210,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x00084200,
		0x0DF, 0x00002000,
		0x082, 0x00003364,
		0x068, 0x00084210,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x00084200,
		0x0DF, 0x00002000,
		0x082, 0x00003364,
		0x068, 0x00084210,
	0xA0000000,	0x00000000,
		0x067, 0x00084200,
		0x0DF, 0x00002000,
		0x082, 0x00003364,
		0x068, 0x00084210,
	0xB0000000,	0x00000000,
		0xFFE, 0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x082, 0x00003354,
		0x068, 0x00084210,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x082, 0x00003354,
		0x068, 0x00084210,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x082, 0x00003354,
		0x068, 0x00084210,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x082, 0x00003354,
		0x068, 0x00084210,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x082, 0x00003354,
		0x068, 0x00084210,
	0xA0000000,	0x00000000,
		0x068, 0x00084200,
		0x082, 0x00003354,
		0x068, 0x00084210,
	0xB0000000,	0x00000000,
		0xFFE, 0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x0DF, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x0DF, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x0DF, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x0DF, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x0DF, 0x00000000,
	0xA0000000,	0x00000000,
		0x068, 0x00084200,
		0x0DF, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x06F, 0x00014311,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x06F, 0x00014311,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x06F, 0x00014311,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x06F, 0x00014311,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x06F, 0x00014311,
	0xA0000000,	0x00000000,
		0x06F, 0x00014311,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0x06E, 0x00000211,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x06E, 0x00000211,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x06E, 0x00000211,
	0x92000000,	0x00000000,	0x40000000,	0x00000000,
		0x06E, 0x00000311,
	0x92000003,	0x00000000,	0x40000000,	0x00000000,
		0x06E, 0x00000311,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x06E, 0x00000211,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x06E, 0x00000211,
	0xA0000000,	0x00000000,
		0x06E, 0x00000211,
	0xB0000000,	0x00000000,
	0x81000003,	0x00000000,	0x40000000,	0x00000000,
		0xFFFF, 0x0000FFFF,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0xFFFF, 0x0000FFFF,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0xFFFF, 0x0000FFFF,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0xFFFF, 0x0000FFFF,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0xFFFF, 0x0000FFFF,
	0xA0000000,	0x00000000,
		0xFFFF, 0x0000FFFF,
	0xB0000000,	0x00000000,

};

void
odm_read_and_config_mp_8814b_radiod(struct dm_struct *dm)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len =
			sizeof(array_mp_8814b_radiod) / sizeof(u32);
	u32	*array = (u32 *)array_mp_8814b_radiod;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;
	u32	a1 = 0, a2 = 0, a3 = 0, a4 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  =
					(u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT,
						  "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (!is_skipped) {
					a1 = pre_v1; a2 = pre_v2;
					a3 = v1; a4 = v2;
					if (check_positive(dm,
							   a1, a2, a3, a4)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else {
					is_matched = false;
				}
			}
		} else {
			if (is_matched)
				odm_config_rf_radio_d_8814b(dm, v1, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8814b_radiod(void)
{
		return 46;
}

/******************************************************************************
 *                           radiosyn0.TXT
 ******************************************************************************/

const u32 array_mp_8814b_radiosyn0[] = {
		0x000, 0x00020000,
		0x018, 0x00013124,
		0x00C, 0x00006318,
		0x004, 0x000BD402,
		0x00F, 0x00000020,
		0x009, 0x0001C180,
		0x027, 0x00038418,
		0x00E, 0x00000004,
		0x033, 0x00000000,
		0x03F, 0x00000066,
		0x033, 0x00000001,
		0x03F, 0x0000006A,
		0x00E, 0x00000000,
		0x00E, 0x00000001,
		0x033, 0x00000000,
		0x03F, 0x000002C9,
		0x033, 0x00000001,
		0x03F, 0x000002C9,
		0x033, 0x00000002,
		0x03F, 0x000002A9,
		0x033, 0x00000003,
		0x03F, 0x000002A9,
		0x033, 0x00000004,
		0x03F, 0x00000289,
		0x033, 0x00000005,
		0x03F, 0x00000289,
		0x033, 0x00000006,
		0x03F, 0x000002E9,
		0x033, 0x00000007,
		0x03F, 0x00000883,
		0x00E, 0x00000000,
		0x00E, 0x00000040,
		0x033, 0x00000000,
		0x03F, 0x00000012,
		0x033, 0x00000001,
		0x03F, 0x00000052,
		0x033, 0x00000002,
		0x03F, 0x00000012,
		0x033, 0x00000002,
		0x03F, 0x00000012,
		0x033, 0x00000004,
		0x03F, 0x00000052,
		0x033, 0x00000005,
		0x03F, 0x00000052,
		0x033, 0x00000006,
		0x03F, 0x00000052,
		0x033, 0x00000007,
		0x03F, 0x00000052,
		0x00E, 0x00000000,
		0x00E, 0x00000008,
		0x033, 0x00000000,
		0x03E, 0x0000001F,
		0x03F, 0x00012FC8,
		0x00E, 0x00000000,
		0x000, 0x00020000,
		0x018, 0x0001B126,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0x018, 0x00013124,
		0xFFFF, 0x0000FFFF,

};

void
odm_read_and_config_mp_8814b_radiosyn0(struct dm_struct *dm)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len =
			sizeof(array_mp_8814b_radiosyn0) / sizeof(u32);
	u32	*array = (u32 *)array_mp_8814b_radiosyn0;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;
	u32	a1 = 0, a2 = 0, a3 = 0, a4 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  =
					(u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT,
						  "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (!is_skipped) {
					a1 = pre_v1; a2 = pre_v2;
					a3 = v1; a4 = v2;
					if (check_positive(dm,
							   a1, a2, a3, a4)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else {
					is_matched = false;
				}
			}
		} else {
			if (is_matched)
				odm_config_rf_radio_syn0_8814b(dm, v1, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8814b_radiosyn0(void)
{
		return 46;
}

/******************************************************************************
 *                           radiosyn1.TXT
 ******************************************************************************/

const u32 array_mp_8814b_radiosyn1[] = {
		0x018, 0x00013124,
		0x000, 0x00020000,
		0x018, 0x00013124,
		0x00C, 0x0000631A,
		0x004, 0x000BD402,
		0x00F, 0x00000020,
		0x009, 0x0001C180,
		0x027, 0x00038418,
		0x00E, 0x00000004,
		0x033, 0x00000000,
		0x03F, 0x00000032,
		0x033, 0x00000001,
		0x03F, 0x00000052,
		0x00E, 0x00000000,
		0x00E, 0x00000001,
		0x033, 0x00000000,
		0x03F, 0x000002C9,
		0x033, 0x00000001,
		0x03F, 0x000002C9,
		0x033, 0x00000002,
		0x03F, 0x000002A9,
		0x033, 0x00000003,
		0x03F, 0x000002A9,
		0x033, 0x00000004,
		0x03F, 0x00000289,
		0x033, 0x00000005,
		0x03F, 0x00000289,
		0x033, 0x00000006,
		0x03F, 0x000002E9,
		0x033, 0x00000007,
		0x03F, 0x00000883,
		0x00E, 0x00000000,
		0x00E, 0x00000040,
		0x033, 0x00000000,
		0x03F, 0x00000012,
		0x033, 0x00000001,
		0x03F, 0x00000052,
		0x033, 0x00000002,
		0x03F, 0x00000012,
		0x033, 0x00000002,
		0x03F, 0x00000012,
		0x033, 0x00000004,
		0x03F, 0x00000052,
		0x033, 0x00000005,
		0x03F, 0x00000052,
		0x033, 0x00000006,
		0x03F, 0x00000052,
		0x033, 0x00000007,
		0x03F, 0x00000052,
		0x00E, 0x00000000,
		0x00E, 0x00000008,
		0x033, 0x00000000,
		0x03E, 0x0000001F,
		0x03F, 0x00012FC8,
		0x00E, 0x00000000,
		0x000, 0x00020000,
		0x018, 0x0001B126,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0x018, 0x00013124,
		0xFFFF, 0x0000FFFF,

};

void
odm_read_and_config_mp_8814b_radiosyn1(struct dm_struct *dm)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len =
			sizeof(array_mp_8814b_radiosyn1) / sizeof(u32);
	u32	*array = (u32 *)array_mp_8814b_radiosyn1;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;
	u32	a1 = 0, a2 = 0, a3 = 0, a4 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  =
					(u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT,
						  "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (!is_skipped) {
					a1 = pre_v1; a2 = pre_v2;
					a3 = v1; a4 = v2;
					if (check_positive(dm,
							   a1, a2, a3, a4)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else {
					is_matched = false;
				}
			}
		} else {
			if (is_matched)
				odm_config_rf_radio_syn1_8814b(dm, v1, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8814b_radiosyn1(void)
{
		return 46;
}

/******************************************************************************
 *                           txpowertrack.TXT
 ******************************************************************************/

#ifdef CONFIG_8814B
const u8 delta_swingidx_mp_5gd_n_txpwrtrk_8814b[][D_S_SIZE] = {
	{0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 7, 7, 8, 9, 9, 10, 11,
	 11, 12, 13, 13, 14, 15, 15, 16, 17, 17, 18, 19, 19},
	{0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 7, 8, 9, 9, 10, 10,
	 11, 12, 12, 13, 13, 14, 15, 15, 16, 17, 17, 18},
	{0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 17, 18, 19},
};

const u8 delta_swingidx_mp_5gd_p_txpwrtrk_8814b[][D_S_SIZE] = {
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
	 17, 18, 19, 20, 21, 22, 23, 24, 25, 25, 25, 25, 25},
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
	 17, 17, 18, 19, 20, 21, 22, 23, 24, 25, 25, 25, 25},
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
	 17, 17, 18, 19, 20, 21, 22, 23, 24, 25, 25, 25, 25},
};

const u8 delta_swingidx_mp_5gc_n_txpwrtrk_8814b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 10, 10,
	 11, 12, 13, 14, 15, 15, 15, 15, 16, 16, 17, 18},
	{0, 1, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10, 11,
	 12, 12, 13, 14, 15, 15, 16, 17, 17, 18, 19, 19, 20},
	{0, 1, 1, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 11, 11,
	 12, 13, 13, 14, 14, 15, 16, 17, 18, 18, 19, 20, 20},
};

const u8 delta_swingidx_mp_5gc_p_txpwrtrk_8814b[][D_S_SIZE] = {
	{0, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
	 16, 16, 17, 18, 19, 20, 21, 21, 22, 23, 24, 25, 25},
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
	 17, 17, 18, 19, 20, 21, 22, 23, 24, 24, 25, 25, 25},
	{0, 1, 2, 3, 4, 5, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
	 16, 16, 17, 18, 19, 20, 21, 22, 23, 23, 24, 25, 25},
};

const u8 delta_swingidx_mp_5gb_n_txpwrtrk_8814b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17, 17},
	{0, 1, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10, 11,
	 12, 12, 13, 14, 15, 15, 16, 17, 17, 18, 19, 19, 20},
	{0, 1, 1, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 11, 11,
	 12, 13, 13, 14, 14, 15, 16, 17, 18, 18, 19, 20, 20},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_8814b[][D_S_SIZE] = {
	{0, 1, 2, 3, 3, 4, 5, 6, 7, 8, 8, 9, 10, 11, 12, 13, 14,
	 15, 15, 16, 17, 18, 18, 19, 20, 21, 22, 23, 23, 24},
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
	 17, 18, 18, 19, 20, 21, 22, 23, 24, 25, 25, 25, 25},
	{0, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
	 16, 16, 17, 18, 19, 20, 20, 21, 22, 23, 24, 25, 25},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_8814b[][D_S_SIZE] = {
	{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8,
	 8, 9, 9, 10, 11, 11, 11, 11, 12, 12, 13, 13, 14},
	{0, 1, 1, 2, 3, 4, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 11,
	 12, 13, 14, 14, 15, 16, 16, 17, 18, 19, 19, 20, 21},
	{0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 17, 18, 19},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_8814b[][D_S_SIZE] = {
	{0, 1, 2, 2, 3, 4, 5, 6, 7, 7, 8, 9, 10, 11, 12, 12, 13,
	 14, 15, 16, 16, 17, 18, 19, 20, 21, 21, 22, 23, 24},
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
	 17, 18, 19, 20, 21, 22, 23, 23, 24, 25, 25, 25, 25},
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
	 17, 17, 18, 19, 20, 21, 22, 23, 24, 25, 25, 25, 25},
};

const u8 delta_swingidx_mp_2gd_n_txpwrtrk_8814b[]    = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2gd_p_txpwrtrk_8814b[]    = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2gc_n_txpwrtrk_8814b[]    = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2gc_p_txpwrtrk_8814b[]    = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2gb_n_txpwrtrk_8814b[]    = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_8814b[]    = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_8814b[]    = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_8814b[]    = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_d_n_txpwrtrk_8814b[] = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_d_p_txpwrtrk_8814b[] = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_c_n_txpwrtrk_8814b[] = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_c_p_txpwrtrk_8814b[] = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_8814b[] = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_8814b[] = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_8814b[] = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_8814b[] = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
#endif

void
odm_read_and_config_mp_8814b_txpowertrack(struct dm_struct *dm)
{
#ifdef CONFIG_8814B

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8814b\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gc_p,
		(void *)delta_swingidx_mp_2gc_p_txpwrtrk_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gc_n,
		(void *)delta_swingidx_mp_2gc_n_txpwrtrk_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gd_p,
		(void *)delta_swingidx_mp_2gd_p_txpwrtrk_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gd_n,
		(void *)delta_swingidx_mp_2gd_n_txpwrtrk_8814b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_c_p,
		(void *)delta_swingidx_mp_2g_cck_c_p_txpwrtrk_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_c_n,
		(void *)delta_swingidx_mp_2g_cck_c_n_txpwrtrk_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_d_p,
		(void *)delta_swingidx_mp_2g_cck_d_p_txpwrtrk_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_d_n,
		(void *)delta_swingidx_mp_2g_cck_d_n_txpwrtrk_8814b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gc_p,
		(void *)delta_swingidx_mp_5gc_p_txpwrtrk_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gc_n,
		(void *)delta_swingidx_mp_5gc_n_txpwrtrk_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gd_p,
		(void *)delta_swingidx_mp_5gd_p_txpwrtrk_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gd_n,
		(void *)delta_swingidx_mp_5gd_n_txpwrtrk_8814b,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_type0.TXT
 ******************************************************************************/

#ifdef CONFIG_8814B_TYPE0
const u8 delta_swingidx_mp_5gd_n_txpwrtrk_type0_8814b[][D_S_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
};

const u8 delta_swingidx_mp_5gd_p_txpwrtrk_type0_8814b[][D_S_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
};

const u8 delta_swingidx_mp_5gc_n_txpwrtrk_type0_8814b[][D_S_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
};

const u8 delta_swingidx_mp_5gc_p_txpwrtrk_type0_8814b[][D_S_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
};

const u8 delta_swingidx_mp_5gb_n_txpwrtrk_type0_8814b[][D_S_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_type0_8814b[][D_S_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_type0_8814b[][D_S_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_type0_8814b[][D_S_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
};

const u8 delta_swingidx_mp_2gd_n_txpwrtrk_type0_8814b[]    = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2gd_p_txpwrtrk_type0_8814b[]    = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2gc_n_txpwrtrk_type0_8814b[]    = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2gc_p_txpwrtrk_type0_8814b[]    = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2gb_n_txpwrtrk_type0_8814b[]    = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_type0_8814b[]    = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_type0_8814b[]    = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_type0_8814b[]    = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2g_cck_d_n_txpwrtrk_type0_8814b[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2g_cck_d_p_txpwrtrk_type0_8814b[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2g_cck_c_n_txpwrtrk_type0_8814b[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2g_cck_c_p_txpwrtrk_type0_8814b[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type0_8814b[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type0_8814b[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type0_8814b[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type0_8814b[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
#endif

void
odm_read_and_config_mp_8814b_txpowertrack_type0(struct dm_struct *dm)
{
#ifdef CONFIG_8814B_TYPE0

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8814b\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_type0_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_type0_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_type0_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_type0_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gc_p,
		(void *)delta_swingidx_mp_2gc_p_txpwrtrk_type0_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gc_n,
		(void *)delta_swingidx_mp_2gc_n_txpwrtrk_type0_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gd_p,
		(void *)delta_swingidx_mp_2gd_p_txpwrtrk_type0_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gd_n,
		(void *)delta_swingidx_mp_2gd_n_txpwrtrk_type0_8814b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type0_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type0_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type0_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type0_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_c_p,
		(void *)delta_swingidx_mp_2g_cck_c_p_txpwrtrk_type0_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_c_n,
		(void *)delta_swingidx_mp_2g_cck_c_n_txpwrtrk_type0_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_d_p,
		(void *)delta_swingidx_mp_2g_cck_d_p_txpwrtrk_type0_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_d_n,
		(void *)delta_swingidx_mp_2g_cck_d_n_txpwrtrk_type0_8814b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_type0_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_type0_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_type0_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_type0_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gc_p,
		(void *)delta_swingidx_mp_5gc_p_txpwrtrk_type0_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gc_n,
		(void *)delta_swingidx_mp_5gc_n_txpwrtrk_type0_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gd_p,
		(void *)delta_swingidx_mp_5gd_p_txpwrtrk_type0_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gd_n,
		(void *)delta_swingidx_mp_5gd_n_txpwrtrk_type0_8814b,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_type1.TXT
 ******************************************************************************/

#ifdef CONFIG_8814B_TYPE1
const u8 delta_swingidx_mp_5gd_n_txpwrtrk_type1_8814b[][D_S_SIZE] = {
	{1, 3, 5, 5, 6, 7, 9, 11, 12, 13, 15, 15, 16, 18, 19, 20,
	 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20},
	{1, 3, 5, 6, 6, 8, 9, 11, 12, 13, 15, 16, 17, 18, 20, 20,
	 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20},
	{1, 3, 5, 7, 8, 10, 11, 12, 13, 14, 15, 16, 17, 19, 20, 21,
	 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21},
};

const u8 delta_swingidx_mp_5gd_p_txpwrtrk_type1_8814b[][D_S_SIZE] = {
	{1, 2, 3, 5, 6, 7, 8, 10, 12, 14, 16, 17, 19, 20, 22, 24,
	 25, 27, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29},
	{1, 2, 3, 5, 6, 7, 8, 11, 12, 14, 16, 18, 20, 21, 23, 24,
	 26, 28, 29, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31},
	{1, 2, 3, 5, 6, 7, 9, 11, 12, 14, 17, 18, 20, 21, 23, 24,
	 26, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29},
};

const u8 delta_swingidx_mp_5gc_n_txpwrtrk_type1_8814b[][D_S_SIZE] = {
	{1, 3, 5, 5, 6, 7, 9, 11, 12, 13, 15, 15, 16, 18, 18, 19,
	 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19},
	{1, 2, 4, 5, 7, 9, 10, 11, 11, 12, 14, 15, 16, 17, 18, 19,
	 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19},
	{1, 3, 5, 7, 8, 10, 11, 12, 12, 13, 15, 16, 17, 18, 20, 21,
	 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21},
};

const u8 delta_swingidx_mp_5gc_p_txpwrtrk_type1_8814b[][D_S_SIZE] = {
	{1, 2, 3, 5, 6, 7, 9, 10, 12, 14, 16, 17, 19, 20, 22, 23,
	 25, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29},
	{1, 2, 3, 5, 6, 7, 9, 11, 12, 14, 16, 17, 19, 20, 22, 23,
	 24, 27, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29},
	{1, 2, 3, 6, 7, 8, 9, 11, 12, 14, 17, 18, 20, 21, 23, 24,
	 26, 29, 31, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32},
};

const u8 delta_swingidx_mp_5gb_n_txpwrtrk_type1_8814b[][D_S_SIZE] = {
	{1, 3, 4, 6, 8, 9, 10, 12, 12, 13, 15, 15, 16, 18, 19, 20,
	 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20},
	{1, 2, 4, 5, 7, 9, 10, 11, 11, 12, 14, 15, 16, 17, 18, 19,
	 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19},
	{1, 3, 5, 7, 8, 10, 11, 12, 12, 13, 15, 16, 17, 18, 20, 21,
	 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_type1_8814b[][D_S_SIZE] = {
	{1, 2, 3, 4, 5, 6, 8, 10, 11, 13, 15, 16, 18, 20, 22, 23,
	 24, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28},
	{1, 2, 3, 4, 5, 7, 9, 11, 12, 14, 15, 16, 19, 21, 22, 23,
	 25, 27, 28, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30},
	{1, 2, 3, 4, 5, 7, 9, 11, 12, 14, 15, 16, 19, 21, 23, 24,
	 26, 27, 28, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_type1_8814b[][D_S_SIZE] = {
	{1, 4, 5, 5, 7, 9, 10, 11, 11, 12, 14, 14, 15, 17, 19, 19,
	 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19},
	{1, 3, 4, 5, 6, 8, 9, 10, 12, 12, 13, 14, 15, 16, 18, 18,
	 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18},
	{1, 4, 5, 6, 7, 9, 10, 11, 13, 14, 15, 16, 17, 18, 20, 20,
	 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_type1_8814b[][D_S_SIZE] = {
	{1, 2, 3, 4, 5, 6, 8, 10, 11, 13, 14, 15, 18, 19, 21, 22,
	 24, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27},
	{1, 2, 3, 4, 5, 6, 8, 10, 11, 13, 14, 15, 18, 19, 21, 22,
	 24, 25, 26, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28},
	{1, 2, 3, 4, 5, 7, 9, 11, 12, 14, 15, 16, 19, 21, 23, 24,
	 25, 26, 28, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31},
};

const u8 delta_swingidx_mp_2gd_n_txpwrtrk_type1_8814b[]    = {
	0, 1, 2, 4, 4, 5, 5, 6, 8, 9, 9, 10, 10, 11, 13, 14,
	 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15};
const u8 delta_swingidx_mp_2gd_p_txpwrtrk_type1_8814b[]    = {
	0, 0, 1, 2, 4, 4, 5, 7, 8, 9, 9, 10, 11, 12, 13, 14,
	 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2gc_n_txpwrtrk_type1_8814b[]    = {
	0, 1, 2, 3, 3, 4, 5, 6, 7, 8, 8, 9, 10, 11, 12, 13, 13,
	 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14};
const u8 delta_swingidx_mp_2gc_p_txpwrtrk_type1_8814b[]    = {
	0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 11, 12, 13,
	 14, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16};
const u8 delta_swingidx_mp_2gb_n_txpwrtrk_type1_8814b[]    = {
	0, 1, 2, 3, 4, 5, 5, 6, 7, 7, 8, 9, 11, 11, 12, 14, 14,
	 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_type1_8814b[]    = {
	0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 11, 12, 13,
	 15, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_type1_8814b[]    = {
	0, 1, 2, 3, 4, 5, 5, 6, 8, 8, 9, 10, 11, 12, 13, 14,
	 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_type1_8814b[]    = {
	0, 1, 2, 2, 4, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13, 14,
	 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
const u8 delta_swingidx_mp_2g_cck_d_n_txpwrtrk_type1_8814b[] = {
	0, 1, 2, 3, 4, 5, 6, 6, 7, 8, 8, 9, 10, 11, 11, 11, 12,
	 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
const u8 delta_swingidx_mp_2g_cck_d_p_txpwrtrk_type1_8814b[] = {
	1, 2, 3, 3, 4, 5, 6, 7, 9, 9, 10, 11, 12, 13, 14, 15,
	 16, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_c_n_txpwrtrk_type1_8814b[] = {
	0, 1, 2, 3, 4, 5, 6, 7, 7, 8, 9, 9, 10, 11, 11, 12, 12,
	 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13};
const u8 delta_swingidx_mp_2g_cck_c_p_txpwrtrk_type1_8814b[] = {
	1, 2, 3, 3, 4, 6, 6, 7, 9, 9, 10, 11, 12, 12, 13, 14,
	 15, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type1_8814b[] = {
	0, 1, 2, 3, 4, 5, 6, 6, 7, 8, 9, 10, 10, 11, 11, 12,
	 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type1_8814b[] = {
	1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 11, 12, 13, 14, 16,
	 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type1_8814b[] = {
	0, 1, 2, 3, 3, 4, 6, 6, 7, 8, 8, 9, 10, 10, 10, 12, 13,
	 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type1_8814b[] = {
	1, 3, 3, 4, 5, 6, 7, 8, 9, 9, 10, 11, 12, 14, 15, 16,
	 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
#endif

void
odm_read_and_config_mp_8814b_txpowertrack_type1(struct dm_struct *dm)
{
#ifdef CONFIG_8814B_TYPE1

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8814b\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_type1_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_type1_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_type1_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_type1_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gc_p,
		(void *)delta_swingidx_mp_2gc_p_txpwrtrk_type1_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gc_n,
		(void *)delta_swingidx_mp_2gc_n_txpwrtrk_type1_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gd_p,
		(void *)delta_swingidx_mp_2gd_p_txpwrtrk_type1_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gd_n,
		(void *)delta_swingidx_mp_2gd_n_txpwrtrk_type1_8814b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type1_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type1_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type1_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type1_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_c_p,
		(void *)delta_swingidx_mp_2g_cck_c_p_txpwrtrk_type1_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_c_n,
		(void *)delta_swingidx_mp_2g_cck_c_n_txpwrtrk_type1_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_d_p,
		(void *)delta_swingidx_mp_2g_cck_d_p_txpwrtrk_type1_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_d_n,
		(void *)delta_swingidx_mp_2g_cck_d_n_txpwrtrk_type1_8814b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_type1_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_type1_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_type1_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_type1_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gc_p,
		(void *)delta_swingidx_mp_5gc_p_txpwrtrk_type1_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gc_n,
		(void *)delta_swingidx_mp_5gc_n_txpwrtrk_type1_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gd_p,
		(void *)delta_swingidx_mp_5gd_p_txpwrtrk_type1_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gd_n,
		(void *)delta_swingidx_mp_5gd_n_txpwrtrk_type1_8814b,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_type2.TXT
 ******************************************************************************/

#ifdef CONFIG_8814B_TYPE2
const u8 delta_swingidx_mp_5gd_n_txpwrtrk_type2_8814b[][D_S_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
};

const u8 delta_swingidx_mp_5gd_p_txpwrtrk_type2_8814b[][D_S_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
};

const u8 delta_swingidx_mp_5gc_n_txpwrtrk_type2_8814b[][D_S_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
};

const u8 delta_swingidx_mp_5gc_p_txpwrtrk_type2_8814b[][D_S_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
};

const u8 delta_swingidx_mp_5gb_n_txpwrtrk_type2_8814b[][D_S_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_type2_8814b[][D_S_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_type2_8814b[][D_S_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_type2_8814b[][D_S_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
};

const u8 delta_swingidx_mp_2gd_n_txpwrtrk_type2_8814b[]    = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2gd_p_txpwrtrk_type2_8814b[]    = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2gc_n_txpwrtrk_type2_8814b[]    = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2gc_p_txpwrtrk_type2_8814b[]    = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2gb_n_txpwrtrk_type2_8814b[]    = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_type2_8814b[]    = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_type2_8814b[]    = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_type2_8814b[]    = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2g_cck_d_n_txpwrtrk_type2_8814b[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2g_cck_d_p_txpwrtrk_type2_8814b[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2g_cck_c_n_txpwrtrk_type2_8814b[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2g_cck_c_p_txpwrtrk_type2_8814b[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type2_8814b[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type2_8814b[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type2_8814b[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type2_8814b[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
#endif

void
odm_read_and_config_mp_8814b_txpowertrack_type2(struct dm_struct *dm)
{
#ifdef CONFIG_8814B_TYPE2

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8814b\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_type2_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_type2_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_type2_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_type2_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gc_p,
		(void *)delta_swingidx_mp_2gc_p_txpwrtrk_type2_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gc_n,
		(void *)delta_swingidx_mp_2gc_n_txpwrtrk_type2_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gd_p,
		(void *)delta_swingidx_mp_2gd_p_txpwrtrk_type2_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gd_n,
		(void *)delta_swingidx_mp_2gd_n_txpwrtrk_type2_8814b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type2_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type2_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type2_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type2_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_c_p,
		(void *)delta_swingidx_mp_2g_cck_c_p_txpwrtrk_type2_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_c_n,
		(void *)delta_swingidx_mp_2g_cck_c_n_txpwrtrk_type2_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_d_p,
		(void *)delta_swingidx_mp_2g_cck_d_p_txpwrtrk_type2_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_d_n,
		(void *)delta_swingidx_mp_2g_cck_d_n_txpwrtrk_type2_8814b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_type2_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_type2_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_type2_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_type2_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gc_p,
		(void *)delta_swingidx_mp_5gc_p_txpwrtrk_type2_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gc_n,
		(void *)delta_swingidx_mp_5gc_n_txpwrtrk_type2_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gd_p,
		(void *)delta_swingidx_mp_5gd_p_txpwrtrk_type2_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gd_n,
		(void *)delta_swingidx_mp_5gd_n_txpwrtrk_type2_8814b,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_type3.TXT
 ******************************************************************************/

#ifdef CONFIG_8814B_TYPE3
const u8 delta_swingidx_mp_5gd_n_txpwrtrk_type3_8814b[][D_S_SIZE] = {
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
};

const u8 delta_swingidx_mp_5gd_p_txpwrtrk_type3_8814b[][D_S_SIZE] = {
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
};

const u8 delta_swingidx_mp_5gc_n_txpwrtrk_type3_8814b[][D_S_SIZE] = {
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
};

const u8 delta_swingidx_mp_5gc_p_txpwrtrk_type3_8814b[][D_S_SIZE] = {
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
};

const u8 delta_swingidx_mp_5gb_n_txpwrtrk_type3_8814b[][D_S_SIZE] = {
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_type3_8814b[][D_S_SIZE] = {
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_type3_8814b[][D_S_SIZE] = {
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_type3_8814b[][D_S_SIZE] = {
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
};

const u8 delta_swingidx_mp_2gd_n_txpwrtrk_type3_8814b[]    = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2gd_p_txpwrtrk_type3_8814b[]    = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2gc_n_txpwrtrk_type3_8814b[]    = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2gc_p_txpwrtrk_type3_8814b[]    = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2gb_n_txpwrtrk_type3_8814b[]    = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_type3_8814b[]    = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_type3_8814b[]    = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_type3_8814b[]    = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_d_n_txpwrtrk_type3_8814b[] = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_d_p_txpwrtrk_type3_8814b[] = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_c_n_txpwrtrk_type3_8814b[] = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_c_p_txpwrtrk_type3_8814b[] = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type3_8814b[] = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type3_8814b[] = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type3_8814b[] = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type3_8814b[] = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
#endif

void
odm_read_and_config_mp_8814b_txpowertrack_type3(struct dm_struct *dm)
{
#ifdef CONFIG_8814B_TYPE3

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8814b\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_type3_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_type3_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_type3_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_type3_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gc_p,
		(void *)delta_swingidx_mp_2gc_p_txpwrtrk_type3_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gc_n,
		(void *)delta_swingidx_mp_2gc_n_txpwrtrk_type3_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gd_p,
		(void *)delta_swingidx_mp_2gd_p_txpwrtrk_type3_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gd_n,
		(void *)delta_swingidx_mp_2gd_n_txpwrtrk_type3_8814b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type3_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type3_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type3_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type3_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_c_p,
		(void *)delta_swingidx_mp_2g_cck_c_p_txpwrtrk_type3_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_c_n,
		(void *)delta_swingidx_mp_2g_cck_c_n_txpwrtrk_type3_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_d_p,
		(void *)delta_swingidx_mp_2g_cck_d_p_txpwrtrk_type3_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_d_n,
		(void *)delta_swingidx_mp_2g_cck_d_n_txpwrtrk_type3_8814b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_type3_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_type3_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_type3_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_type3_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gc_p,
		(void *)delta_swingidx_mp_5gc_p_txpwrtrk_type3_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gc_n,
		(void *)delta_swingidx_mp_5gc_n_txpwrtrk_type3_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gd_p,
		(void *)delta_swingidx_mp_5gd_p_txpwrtrk_type3_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gd_n,
		(void *)delta_swingidx_mp_5gd_n_txpwrtrk_type3_8814b,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_type4.TXT
 ******************************************************************************/

#ifdef CONFIG_8814B_TYPE4
const u8 delta_swingidx_mp_5gd_n_txpwrtrk_type4_8814b[][D_S_SIZE] = {
	{1, 3, 5, 5, 6, 7, 9, 11, 12, 13, 15, 15, 16, 18, 19, 20,
	 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20},
	{1, 3, 5, 6, 6, 8, 9, 11, 12, 13, 15, 16, 17, 18, 20, 20,
	 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20},
	{1, 3, 5, 7, 8, 10, 11, 12, 13, 14, 15, 16, 17, 19, 20, 21,
	 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21},
};

const u8 delta_swingidx_mp_5gd_p_txpwrtrk_type4_8814b[][D_S_SIZE] = {
	{1, 2, 3, 5, 6, 7, 8, 10, 12, 14, 16, 17, 19, 20, 22, 24,
	 25, 27, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29},
	{1, 2, 3, 5, 6, 7, 8, 11, 12, 14, 16, 18, 20, 21, 23, 24,
	 26, 28, 29, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31},
	{1, 2, 3, 5, 6, 7, 9, 11, 12, 14, 17, 18, 20, 21, 23, 24,
	 26, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29},
};

const u8 delta_swingidx_mp_5gc_n_txpwrtrk_type4_8814b[][D_S_SIZE] = {
	{1, 3, 5, 5, 6, 7, 9, 11, 12, 13, 15, 15, 16, 18, 18, 19,
	 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19},
	{1, 2, 4, 5, 7, 9, 10, 11, 11, 12, 14, 15, 16, 17, 18, 19,
	 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19},
	{1, 3, 5, 7, 8, 10, 11, 12, 12, 13, 15, 16, 17, 18, 20, 21,
	 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21},
};

const u8 delta_swingidx_mp_5gc_p_txpwrtrk_type4_8814b[][D_S_SIZE] = {
	{1, 2, 3, 5, 6, 7, 9, 10, 12, 14, 16, 17, 19, 20, 22, 23,
	 25, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29},
	{1, 2, 3, 5, 6, 7, 9, 11, 12, 14, 16, 17, 19, 20, 22, 23,
	 24, 27, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29},
	{1, 2, 3, 6, 7, 8, 9, 11, 12, 14, 17, 18, 20, 21, 23, 24,
	 26, 29, 31, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32},
};

const u8 delta_swingidx_mp_5gb_n_txpwrtrk_type4_8814b[][D_S_SIZE] = {
	{1, 3, 4, 6, 8, 9, 10, 12, 12, 13, 15, 15, 16, 18, 19, 20,
	 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20},
	{1, 2, 4, 5, 7, 9, 10, 11, 11, 12, 14, 15, 16, 17, 18, 19,
	 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19},
	{1, 3, 5, 7, 8, 10, 11, 12, 12, 13, 15, 16, 17, 18, 20, 21,
	 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_type4_8814b[][D_S_SIZE] = {
	{1, 2, 3, 4, 5, 6, 8, 10, 11, 13, 15, 16, 18, 20, 22, 23,
	 24, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28},
	{1, 2, 3, 4, 5, 7, 9, 11, 12, 14, 15, 16, 19, 21, 22, 23,
	 25, 27, 28, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30},
	{1, 2, 3, 4, 5, 7, 9, 11, 12, 14, 15, 16, 19, 21, 23, 24,
	 26, 27, 28, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_type4_8814b[][D_S_SIZE] = {
	{1, 4, 5, 5, 7, 9, 10, 11, 11, 12, 14, 14, 15, 17, 19, 19,
	 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19},
	{1, 3, 4, 5, 6, 8, 9, 10, 12, 12, 13, 14, 15, 16, 18, 18,
	 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18},
	{1, 4, 5, 6, 7, 9, 10, 11, 13, 14, 15, 16, 17, 18, 20, 20,
	 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_type4_8814b[][D_S_SIZE] = {
	{1, 2, 3, 4, 5, 6, 8, 10, 11, 13, 14, 15, 18, 19, 21, 22,
	 24, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27},
	{1, 2, 3, 4, 5, 6, 8, 10, 11, 13, 14, 15, 18, 19, 21, 22,
	 24, 25, 26, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28},
	{1, 2, 3, 4, 5, 7, 9, 11, 12, 14, 15, 16, 19, 21, 23, 24,
	 25, 26, 28, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31},
};

const u8 delta_swingidx_mp_2gd_n_txpwrtrk_type4_8814b[]    = {
	0, 1, 2, 4, 4, 5, 5, 6, 8, 9, 9, 10, 10, 11, 13, 14,
	 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15};
const u8 delta_swingidx_mp_2gd_p_txpwrtrk_type4_8814b[]    = {
	0, 0, 1, 2, 4, 4, 5, 7, 8, 9, 9, 10, 11, 12, 13, 14,
	 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2gc_n_txpwrtrk_type4_8814b[]    = {
	0, 1, 2, 3, 3, 4, 5, 6, 7, 8, 8, 9, 10, 11, 12, 13, 13,
	 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14};
const u8 delta_swingidx_mp_2gc_p_txpwrtrk_type4_8814b[]    = {
	0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 11, 12, 13,
	 14, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16};
const u8 delta_swingidx_mp_2gb_n_txpwrtrk_type4_8814b[]    = {
	0, 1, 2, 3, 4, 5, 5, 6, 7, 7, 8, 9, 11, 11, 12, 14, 14,
	 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_type4_8814b[]    = {
	0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 11, 12, 13,
	 15, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_type4_8814b[]    = {
	0, 1, 2, 3, 4, 5, 5, 6, 8, 8, 9, 10, 11, 12, 13, 14,
	 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_type4_8814b[]    = {
	0, 1, 2, 2, 4, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13, 14,
	 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
const u8 delta_swingidx_mp_2g_cck_d_n_txpwrtrk_type4_8814b[] = {
	0, 1, 2, 3, 4, 5, 6, 6, 7, 8, 8, 9, 10, 11, 11, 11, 12,
	 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
const u8 delta_swingidx_mp_2g_cck_d_p_txpwrtrk_type4_8814b[] = {
	1, 2, 3, 3, 4, 5, 6, 7, 9, 9, 10, 11, 12, 13, 14, 15,
	 16, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_c_n_txpwrtrk_type4_8814b[] = {
	0, 1, 2, 3, 4, 5, 6, 7, 7, 8, 9, 9, 10, 11, 11, 12, 12,
	 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13};
const u8 delta_swingidx_mp_2g_cck_c_p_txpwrtrk_type4_8814b[] = {
	1, 2, 3, 3, 4, 6, 6, 7, 9, 9, 10, 11, 12, 12, 13, 14,
	 15, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type4_8814b[] = {
	0, 1, 2, 3, 4, 5, 6, 6, 7, 8, 9, 10, 10, 11, 11, 12,
	 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type4_8814b[] = {
	1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 11, 12, 13, 14, 16,
	 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type4_8814b[] = {
	0, 1, 2, 3, 3, 4, 6, 6, 7, 8, 8, 9, 10, 10, 10, 12, 13,
	 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type4_8814b[] = {
	1, 3, 3, 4, 5, 6, 7, 8, 9, 9, 10, 11, 12, 14, 15, 16,
	 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
#endif

void
odm_read_and_config_mp_8814b_txpowertrack_type4(struct dm_struct *dm)
{
#ifdef CONFIG_8814B_TYPE4

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8814b\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_type4_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_type4_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_type4_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_type4_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gc_p,
		(void *)delta_swingidx_mp_2gc_p_txpwrtrk_type4_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gc_n,
		(void *)delta_swingidx_mp_2gc_n_txpwrtrk_type4_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gd_p,
		(void *)delta_swingidx_mp_2gd_p_txpwrtrk_type4_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gd_n,
		(void *)delta_swingidx_mp_2gd_n_txpwrtrk_type4_8814b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type4_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type4_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type4_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type4_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_c_p,
		(void *)delta_swingidx_mp_2g_cck_c_p_txpwrtrk_type4_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_c_n,
		(void *)delta_swingidx_mp_2g_cck_c_n_txpwrtrk_type4_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_d_p,
		(void *)delta_swingidx_mp_2g_cck_d_p_txpwrtrk_type4_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_d_n,
		(void *)delta_swingidx_mp_2g_cck_d_n_txpwrtrk_type4_8814b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_type4_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_type4_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_type4_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_type4_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gc_p,
		(void *)delta_swingidx_mp_5gc_p_txpwrtrk_type4_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gc_n,
		(void *)delta_swingidx_mp_5gc_n_txpwrtrk_type4_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gd_p,
		(void *)delta_swingidx_mp_5gd_p_txpwrtrk_type4_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gd_n,
		(void *)delta_swingidx_mp_5gd_n_txpwrtrk_type4_8814b,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_type5.TXT
 ******************************************************************************/

#ifdef CONFIG_8814B_TYPE5
const u8 delta_swingidx_mp_5gd_n_txpwrtrk_type5_8814b[][D_S_SIZE] = {
	{1, 3, 5, 5, 6, 7, 9, 11, 12, 13, 15, 15, 16, 18, 19, 20,
	 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20},
	{1, 3, 5, 6, 6, 8, 9, 11, 12, 13, 15, 16, 17, 18, 20, 20,
	 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20},
	{1, 3, 5, 7, 8, 10, 11, 12, 13, 14, 15, 16, 17, 19, 20, 21,
	 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21},
};

const u8 delta_swingidx_mp_5gd_p_txpwrtrk_type5_8814b[][D_S_SIZE] = {
	{1, 2, 3, 5, 6, 7, 8, 10, 12, 14, 16, 17, 19, 20, 22, 24,
	 25, 27, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29},
	{1, 2, 3, 5, 6, 7, 8, 11, 12, 14, 16, 18, 20, 21, 23, 24,
	 26, 28, 29, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31},
	{1, 2, 3, 5, 6, 7, 9, 11, 12, 14, 17, 18, 20, 21, 23, 24,
	 26, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29},
};

const u8 delta_swingidx_mp_5gc_n_txpwrtrk_type5_8814b[][D_S_SIZE] = {
	{1, 3, 5, 5, 6, 7, 9, 11, 12, 13, 15, 15, 16, 18, 18, 19,
	 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19},
	{1, 2, 4, 5, 7, 9, 10, 11, 11, 12, 14, 15, 16, 17, 18, 19,
	 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19},
	{1, 3, 5, 7, 8, 10, 11, 12, 12, 13, 15, 16, 17, 18, 20, 21,
	 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21},
};

const u8 delta_swingidx_mp_5gc_p_txpwrtrk_type5_8814b[][D_S_SIZE] = {
	{1, 2, 3, 5, 6, 7, 9, 10, 12, 14, 16, 17, 19, 20, 22, 23,
	 25, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29},
	{1, 2, 3, 5, 6, 7, 9, 11, 12, 14, 16, 17, 19, 20, 22, 23,
	 24, 27, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29},
	{1, 2, 3, 6, 7, 8, 9, 11, 12, 14, 17, 18, 20, 21, 23, 24,
	 26, 29, 31, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32},
};

const u8 delta_swingidx_mp_5gb_n_txpwrtrk_type5_8814b[][D_S_SIZE] = {
	{1, 3, 4, 6, 8, 9, 10, 12, 12, 13, 15, 15, 16, 18, 19, 20,
	 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20},
	{1, 2, 4, 5, 7, 9, 10, 11, 11, 12, 14, 15, 16, 17, 18, 19,
	 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19},
	{1, 3, 5, 7, 8, 10, 11, 12, 12, 13, 15, 16, 17, 18, 20, 21,
	 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_type5_8814b[][D_S_SIZE] = {
	{1, 2, 3, 4, 5, 6, 8, 10, 11, 13, 15, 16, 18, 20, 22, 23,
	 24, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28},
	{1, 2, 3, 4, 5, 7, 9, 11, 12, 14, 15, 16, 19, 21, 22, 23,
	 25, 27, 28, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30},
	{1, 2, 3, 4, 5, 7, 9, 11, 12, 14, 15, 16, 19, 21, 23, 24,
	 26, 27, 28, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_type5_8814b[][D_S_SIZE] = {
	{1, 4, 5, 5, 7, 9, 10, 11, 11, 12, 14, 14, 15, 17, 19, 19,
	 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19},
	{1, 3, 4, 5, 6, 8, 9, 10, 12, 12, 13, 14, 15, 16, 18, 18,
	 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18},
	{1, 4, 5, 6, 7, 9, 10, 11, 13, 14, 15, 16, 17, 18, 20, 20,
	 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_type5_8814b[][D_S_SIZE] = {
	{1, 2, 3, 4, 5, 6, 8, 10, 11, 13, 14, 15, 18, 19, 21, 22,
	 24, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27},
	{1, 2, 3, 4, 5, 6, 8, 10, 11, 13, 14, 15, 18, 19, 21, 22,
	 24, 25, 26, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28},
	{1, 2, 3, 4, 5, 7, 9, 11, 12, 14, 15, 16, 19, 21, 23, 24,
	 25, 26, 28, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31},
};

const u8 delta_swingidx_mp_2gd_n_txpwrtrk_type5_8814b[]    = {
	0, 1, 2, 4, 4, 5, 5, 6, 8, 9, 9, 10, 10, 11, 13, 14,
	 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15};
const u8 delta_swingidx_mp_2gd_p_txpwrtrk_type5_8814b[]    = {
	0, 0, 1, 2, 4, 4, 5, 7, 8, 9, 9, 10, 11, 12, 13, 14,
	 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2gc_n_txpwrtrk_type5_8814b[]    = {
	0, 1, 2, 3, 3, 4, 5, 6, 7, 8, 8, 9, 10, 11, 12, 13, 13,
	 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14};
const u8 delta_swingidx_mp_2gc_p_txpwrtrk_type5_8814b[]    = {
	0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 11, 12, 13,
	 14, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16};
const u8 delta_swingidx_mp_2gb_n_txpwrtrk_type5_8814b[]    = {
	0, 1, 2, 3, 4, 5, 5, 6, 7, 7, 8, 9, 11, 11, 12, 14, 14,
	 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_type5_8814b[]    = {
	0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 11, 12, 13,
	 15, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_type5_8814b[]    = {
	0, 1, 2, 3, 4, 5, 5, 6, 8, 8, 9, 10, 11, 12, 13, 14,
	 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_type5_8814b[]    = {
	0, 1, 2, 2, 4, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13, 14,
	 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
const u8 delta_swingidx_mp_2g_cck_d_n_txpwrtrk_type5_8814b[] = {
	0, 1, 2, 3, 4, 5, 6, 6, 7, 8, 8, 9, 10, 11, 11, 11, 12,
	 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
const u8 delta_swingidx_mp_2g_cck_d_p_txpwrtrk_type5_8814b[] = {
	1, 2, 3, 3, 4, 5, 6, 7, 9, 9, 10, 11, 12, 13, 14, 15,
	 16, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_c_n_txpwrtrk_type5_8814b[] = {
	0, 1, 2, 3, 4, 5, 6, 7, 7, 8, 9, 9, 10, 11, 11, 12, 12,
	 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13};
const u8 delta_swingidx_mp_2g_cck_c_p_txpwrtrk_type5_8814b[] = {
	1, 2, 3, 3, 4, 6, 6, 7, 9, 9, 10, 11, 12, 12, 13, 14,
	 15, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type5_8814b[] = {
	0, 1, 2, 3, 4, 5, 6, 6, 7, 8, 9, 10, 10, 11, 11, 12,
	 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type5_8814b[] = {
	1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 11, 12, 13, 14, 16,
	 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type5_8814b[] = {
	0, 1, 2, 3, 3, 4, 6, 6, 7, 8, 8, 9, 10, 10, 10, 12, 13,
	 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type5_8814b[] = {
	1, 3, 3, 4, 5, 6, 7, 8, 9, 9, 10, 11, 12, 14, 15, 16,
	 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
#endif

void
odm_read_and_config_mp_8814b_txpowertrack_type5(struct dm_struct *dm)
{
#ifdef CONFIG_8814B_TYPE5

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8814b\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_type5_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_type5_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_type5_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_type5_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gc_p,
		(void *)delta_swingidx_mp_2gc_p_txpwrtrk_type5_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gc_n,
		(void *)delta_swingidx_mp_2gc_n_txpwrtrk_type5_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gd_p,
		(void *)delta_swingidx_mp_2gd_p_txpwrtrk_type5_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gd_n,
		(void *)delta_swingidx_mp_2gd_n_txpwrtrk_type5_8814b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type5_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type5_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type5_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type5_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_c_p,
		(void *)delta_swingidx_mp_2g_cck_c_p_txpwrtrk_type5_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_c_n,
		(void *)delta_swingidx_mp_2g_cck_c_n_txpwrtrk_type5_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_d_p,
		(void *)delta_swingidx_mp_2g_cck_d_p_txpwrtrk_type5_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_d_n,
		(void *)delta_swingidx_mp_2g_cck_d_n_txpwrtrk_type5_8814b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_type5_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_type5_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_type5_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_type5_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gc_p,
		(void *)delta_swingidx_mp_5gc_p_txpwrtrk_type5_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gc_n,
		(void *)delta_swingidx_mp_5gc_n_txpwrtrk_type5_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gd_p,
		(void *)delta_swingidx_mp_5gd_p_txpwrtrk_type5_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gd_n,
		(void *)delta_swingidx_mp_5gd_n_txpwrtrk_type5_8814b,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_type6.TXT
 ******************************************************************************/

#ifdef CONFIG_8814B_TYPE6
const u8 delta_swingidx_mp_5gd_n_txpwrtrk_type6_8814b[][D_S_SIZE] = {
	{1, 3, 5, 5, 6, 7, 9, 11, 12, 13, 15, 15, 16, 18, 19, 20,
	 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20},
	{1, 3, 5, 6, 6, 8, 9, 11, 12, 13, 15, 16, 17, 18, 20, 20,
	 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20},
	{1, 3, 5, 7, 8, 10, 11, 12, 13, 14, 15, 16, 17, 19, 20, 21,
	 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21},
};

const u8 delta_swingidx_mp_5gd_p_txpwrtrk_type6_8814b[][D_S_SIZE] = {
	{1, 2, 3, 5, 6, 7, 8, 10, 12, 14, 16, 17, 19, 20, 22, 24,
	 25, 27, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29},
	{1, 2, 3, 5, 6, 7, 8, 11, 12, 14, 16, 18, 20, 21, 23, 24,
	 26, 28, 29, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31},
	{1, 2, 3, 5, 6, 7, 9, 11, 12, 14, 17, 18, 20, 21, 23, 24,
	 26, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29},
};

const u8 delta_swingidx_mp_5gc_n_txpwrtrk_type6_8814b[][D_S_SIZE] = {
	{1, 3, 5, 5, 6, 7, 9, 11, 12, 13, 15, 15, 16, 18, 18, 19,
	 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19},
	{1, 2, 4, 5, 7, 9, 10, 11, 11, 12, 14, 15, 16, 17, 18, 19,
	 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19},
	{1, 3, 5, 7, 8, 10, 11, 12, 12, 13, 15, 16, 17, 18, 20, 21,
	 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21},
};

const u8 delta_swingidx_mp_5gc_p_txpwrtrk_type6_8814b[][D_S_SIZE] = {
	{1, 2, 3, 5, 6, 7, 9, 10, 12, 14, 16, 17, 19, 20, 22, 23,
	 25, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29},
	{1, 2, 3, 5, 6, 7, 9, 11, 12, 14, 16, 17, 19, 20, 22, 23,
	 24, 27, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29},
	{1, 2, 3, 6, 7, 8, 9, 11, 12, 14, 17, 18, 20, 21, 23, 24,
	 26, 29, 31, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32},
};

const u8 delta_swingidx_mp_5gb_n_txpwrtrk_type6_8814b[][D_S_SIZE] = {
	{1, 3, 4, 6, 8, 9, 10, 12, 12, 13, 15, 15, 16, 18, 19, 20,
	 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20},
	{1, 2, 4, 5, 7, 9, 10, 11, 11, 12, 14, 15, 16, 17, 18, 19,
	 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19},
	{1, 3, 5, 7, 8, 10, 11, 12, 12, 13, 15, 16, 17, 18, 20, 21,
	 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_type6_8814b[][D_S_SIZE] = {
	{1, 2, 3, 4, 5, 6, 8, 10, 11, 13, 15, 16, 18, 20, 22, 23,
	 24, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28},
	{1, 2, 3, 4, 5, 7, 9, 11, 12, 14, 15, 16, 19, 21, 22, 23,
	 25, 27, 28, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30},
	{1, 2, 3, 4, 5, 7, 9, 11, 12, 14, 15, 16, 19, 21, 23, 24,
	 26, 27, 28, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_type6_8814b[][D_S_SIZE] = {
	{1, 4, 5, 5, 7, 9, 10, 11, 11, 12, 14, 14, 15, 17, 19, 19,
	 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19},
	{1, 3, 4, 5, 6, 8, 9, 10, 12, 12, 13, 14, 15, 16, 18, 18,
	 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18},
	{1, 4, 5, 6, 7, 9, 10, 11, 13, 14, 15, 16, 17, 18, 20, 20,
	 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_type6_8814b[][D_S_SIZE] = {
	{1, 2, 3, 4, 5, 6, 8, 10, 11, 13, 14, 15, 18, 19, 21, 22,
	 24, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27},
	{1, 2, 3, 4, 5, 6, 8, 10, 11, 13, 14, 15, 18, 19, 21, 22,
	 24, 25, 26, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28},
	{1, 2, 3, 4, 5, 7, 9, 11, 12, 14, 15, 16, 19, 21, 23, 24,
	 25, 26, 28, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31},
};

const u8 delta_swingidx_mp_2gd_n_txpwrtrk_type6_8814b[]    = {
	0, 1, 2, 4, 4, 5, 5, 6, 8, 9, 9, 10, 10, 11, 13, 14,
	 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15};
const u8 delta_swingidx_mp_2gd_p_txpwrtrk_type6_8814b[]    = {
	0, 0, 1, 2, 4, 4, 5, 7, 8, 9, 9, 10, 11, 12, 13, 14,
	 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2gc_n_txpwrtrk_type6_8814b[]    = {
	0, 1, 2, 3, 3, 4, 5, 6, 7, 8, 8, 9, 10, 11, 12, 13, 13,
	 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14};
const u8 delta_swingidx_mp_2gc_p_txpwrtrk_type6_8814b[]    = {
	0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 11, 12, 13,
	 14, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16};
const u8 delta_swingidx_mp_2gb_n_txpwrtrk_type6_8814b[]    = {
	0, 1, 2, 3, 4, 5, 5, 6, 7, 7, 8, 9, 11, 11, 12, 14, 14,
	 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_type6_8814b[]    = {
	0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 11, 12, 13,
	 15, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_type6_8814b[]    = {
	0, 1, 2, 3, 4, 5, 5, 6, 8, 8, 9, 10, 11, 12, 13, 14,
	 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_type6_8814b[]    = {
	0, 1, 2, 2, 4, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13, 14,
	 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
const u8 delta_swingidx_mp_2g_cck_d_n_txpwrtrk_type6_8814b[] = {
	0, 1, 2, 3, 4, 5, 6, 6, 7, 8, 8, 9, 10, 11, 11, 11, 12,
	 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
const u8 delta_swingidx_mp_2g_cck_d_p_txpwrtrk_type6_8814b[] = {
	1, 2, 3, 3, 4, 5, 6, 7, 9, 9, 10, 11, 12, 13, 14, 15,
	 16, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_c_n_txpwrtrk_type6_8814b[] = {
	0, 1, 2, 3, 4, 5, 6, 7, 7, 8, 9, 9, 10, 11, 11, 12, 12,
	 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13};
const u8 delta_swingidx_mp_2g_cck_c_p_txpwrtrk_type6_8814b[] = {
	1, 2, 3, 3, 4, 6, 6, 7, 9, 9, 10, 11, 12, 12, 13, 14,
	 15, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type6_8814b[] = {
	0, 1, 2, 3, 4, 5, 6, 6, 7, 8, 9, 10, 10, 11, 11, 12,
	 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type6_8814b[] = {
	1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 11, 12, 13, 14, 16,
	 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type6_8814b[] = {
	0, 1, 2, 3, 3, 4, 6, 6, 7, 8, 8, 9, 10, 10, 10, 12, 13,
	 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type6_8814b[] = {
	1, 3, 3, 4, 5, 6, 7, 8, 9, 9, 10, 11, 12, 14, 15, 16,
	 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
#endif

void
odm_read_and_config_mp_8814b_txpowertrack_type6(struct dm_struct *dm)
{
#ifdef CONFIG_8814B_TYPE6

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8814b\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_type6_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_type6_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_type6_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_type6_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gc_p,
		(void *)delta_swingidx_mp_2gc_p_txpwrtrk_type6_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gc_n,
		(void *)delta_swingidx_mp_2gc_n_txpwrtrk_type6_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gd_p,
		(void *)delta_swingidx_mp_2gd_p_txpwrtrk_type6_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gd_n,
		(void *)delta_swingidx_mp_2gd_n_txpwrtrk_type6_8814b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type6_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type6_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type6_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type6_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_c_p,
		(void *)delta_swingidx_mp_2g_cck_c_p_txpwrtrk_type6_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_c_n,
		(void *)delta_swingidx_mp_2g_cck_c_n_txpwrtrk_type6_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_d_p,
		(void *)delta_swingidx_mp_2g_cck_d_p_txpwrtrk_type6_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_d_n,
		(void *)delta_swingidx_mp_2g_cck_d_n_txpwrtrk_type6_8814b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_type6_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_type6_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_type6_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_type6_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gc_p,
		(void *)delta_swingidx_mp_5gc_p_txpwrtrk_type6_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gc_n,
		(void *)delta_swingidx_mp_5gc_n_txpwrtrk_type6_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gd_p,
		(void *)delta_swingidx_mp_5gd_p_txpwrtrk_type6_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gd_n,
		(void *)delta_swingidx_mp_5gd_n_txpwrtrk_type6_8814b,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_type8.TXT
 ******************************************************************************/

#ifdef CONFIG_8814B_TYPE8
const u8 delta_swingidx_mp_5gd_n_txpwrtrk_type8_8814b[][D_S_SIZE] = {
	{0, 2, 3, 4, 5, 5, 6, 6, 7, 10, 10, 10, 11, 11, 12, 13,
	 14, 15, 15, 15, 16, 16, 17, 17, 18, 18, 19, 19, 19},
	{0, 1, 1, 2, 2, 3, 6, 6, 7, 7, 8, 8, 10, 10, 12, 12, 12,
	 13, 13, 13, 15, 16, 16, 16, 17, 17, 17, 18, 18},
	{0, 1, 1, 1, 3, 5, 5, 5, 6, 7, 8, 9, 10, 10, 11, 11, 11,
	 12, 12, 15, 15, 16, 16, 17, 17, 18, 18, 19, 19},
};

const u8 delta_swingidx_mp_5gd_p_txpwrtrk_type8_8814b[][D_S_SIZE] = {
	{0, 1, 2, 3, 3, 4, 5, 7, 8, 8, 8, 11, 12, 13, 13, 13,
	 14, 15, 16, 18, 18, 19, 19, 19, 20, 20, 20, 21, 21},
	{0, 2, 4, 5, 6, 6, 7, 8, 10, 10, 11, 12, 13, 15, 15, 16,
	 16, 17, 18, 19, 20, 21, 21, 22, 22, 22, 22, 22, 22},
	{0, 1, 2, 4, 5, 6, 6, 7, 8, 10, 11, 12, 12, 13, 13, 14,
	 15, 15, 16, 16, 18, 20, 21, 22, 22, 22, 23, 23, 23},
};

const u8 delta_swingidx_mp_5gc_n_txpwrtrk_type8_8814b[][D_S_SIZE] = {
	{0, 2, 3, 4, 4, 4, 5, 6, 8, 9, 9, 9, 10, 10, 11, 12, 13,
	 13, 14, 14, 15, 15, 16, 16, 17, 17, 18, 18, 18},
	{0, 2, 3, 4, 4, 5, 6, 7, 8, 9, 10, 10, 11, 13, 14, 14,
	 14, 14, 17, 18, 19, 19, 19, 20, 20, 21, 21, 22, 22},
	{0, 1, 1, 2, 2, 3, 5, 5, 6, 7, 7, 8, 11, 11, 12, 12, 13,
	 15, 15, 16, 16, 17, 17, 17, 18, 18, 18, 19, 19},
};

const u8 delta_swingidx_mp_5gc_p_txpwrtrk_type8_8814b[][D_S_SIZE] = {
	{0, 1, 3, 3, 5, 6, 6, 7, 8, 8, 8, 11, 12, 13, 13, 13,
	 14, 15, 15, 18, 18, 19, 19, 19, 20, 20, 20, 21, 21},
	{0, 1, 3, 5, 6, 7, 7, 8, 9, 9, 12, 13, 13, 13, 14, 14,
	 15, 16, 17, 18, 19, 19, 20, 20, 21, 21, 22, 22, 22},
	{0, 1, 2, 3, 3, 3, 5, 7, 8, 8, 8, 10, 11, 13, 13, 14,
	 14, 16, 17, 18, 19, 19, 20, 20, 20, 21, 21, 21, 22},
};

const u8 delta_swingidx_mp_5gb_n_txpwrtrk_type8_8814b[][D_S_SIZE] = {
	{0, 1, 1, 1, 3, 5, 6, 6, 6, 7, 8, 9, 10, 10, 11, 11, 12,
	 15, 15, 15, 16, 16, 17, 17, 18, 18, 19, 19, 19},
	{0, 2, 3, 4, 4, 5, 6, 7, 8, 9, 10, 10, 11, 13, 14, 14,
	 14, 14, 17, 18, 19, 19, 19, 20, 20, 21, 21, 22, 22},
	{0, 1, 1, 2, 2, 3, 5, 5, 6, 7, 7, 8, 11, 11, 12, 12, 13,
	 15, 15, 16, 16, 17, 17, 17, 18, 18, 18, 19, 19},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_type8_8814b[][D_S_SIZE] = {
	{0, 1, 2, 3, 4, 6, 6, 7, 8, 8, 9, 12, 12, 13, 13, 14,
	 16, 16, 16, 17, 18, 19, 21, 21, 21, 22, 22, 22, 22},
	{0, 1, 2, 3, 3, 4, 5, 7, 8, 8, 9, 9, 11, 13, 13, 13, 14,
	 15, 16, 17, 18, 18, 19, 19, 19, 20, 20, 21, 21},
	{0, 1, 3, 4, 5, 6, 6, 7, 10, 10, 11, 12, 12, 13, 14, 15,
	 15, 16, 16, 17, 19, 20, 22, 22, 22, 23, 23, 23, 24},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_type8_8814b[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 2, 5, 5, 6, 7, 8, 8, 9, 9, 10, 10, 11,
	 12, 12, 13, 13, 13, 14, 14, 15, 15, 16, 16, 17},
	{0, 1, 1, 2, 2, 5, 5, 6, 6, 9, 10, 10, 11, 11, 11, 13,
	 14, 14, 15, 15, 16, 16, 17, 17, 18, 18, 19, 19, 19},
	{0, 1, 2, 4, 4, 5, 6, 6, 7, 9, 10, 10, 11, 12, 13, 14,
	 15, 16, 18, 18, 19, 19, 19, 20, 20, 20, 21, 21, 21},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_type8_8814b[][D_S_SIZE] = {
	{0, 3, 5, 5, 6, 6, 7, 7, 10, 10, 11, 11, 12, 12, 12, 14,
	 15, 15, 15, 16, 17, 18, 20, 21, 21, 22, 22, 22, 22},
	{0, 1, 2, 3, 5, 6, 6, 7, 8, 8, 8, 11, 11, 12, 12, 13,
	 14, 14, 15, 16, 17, 17, 18, 18, 18, 19, 19, 20, 20},
	{0, 1, 2, 3, 5, 6, 6, 7, 8, 8, 9, 11, 11, 12, 13, 14,
	 15, 15, 16, 18, 19, 20, 20, 20, 21, 21, 21, 22, 22},
};

const u8 delta_swingidx_mp_2gd_n_txpwrtrk_type8_8814b[]    = {
	0, 1, 2, 4, 4, 5, 5, 6, 8, 9, 9, 10, 10, 11, 13, 14,
	 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15};
const u8 delta_swingidx_mp_2gd_p_txpwrtrk_type8_8814b[]    = {
	0, 0, 1, 2, 4, 4, 5, 7, 8, 9, 9, 10, 11, 12, 13, 14,
	 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2gc_n_txpwrtrk_type8_8814b[]    = {
	0, 1, 2, 3, 3, 4, 5, 6, 7, 8, 8, 9, 10, 11, 12, 13, 13,
	 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14};
const u8 delta_swingidx_mp_2gc_p_txpwrtrk_type8_8814b[]    = {
	0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 11, 12, 13,
	 14, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16};
const u8 delta_swingidx_mp_2gb_n_txpwrtrk_type8_8814b[]    = {
	0, 1, 2, 3, 4, 5, 5, 6, 7, 7, 8, 9, 11, 11, 12, 14, 14,
	 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_type8_8814b[]    = {
	0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 11, 12, 13,
	 15, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_type8_8814b[]    = {
	0, 1, 2, 3, 4, 5, 5, 6, 8, 8, 9, 10, 11, 12, 13, 14,
	 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_type8_8814b[]    = {
	0, 1, 2, 2, 4, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13, 14,
	 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
const u8 delta_swingidx_mp_2g_cck_d_n_txpwrtrk_type8_8814b[] = {
	0, 1, 2, 3, 4, 5, 6, 6, 7, 8, 8, 9, 10, 11, 11, 11, 12,
	 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
const u8 delta_swingidx_mp_2g_cck_d_p_txpwrtrk_type8_8814b[] = {
	1, 2, 3, 3, 4, 5, 6, 7, 9, 9, 10, 11, 12, 13, 14, 15,
	 16, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_c_n_txpwrtrk_type8_8814b[] = {
	0, 1, 2, 3, 4, 5, 6, 7, 7, 8, 9, 9, 10, 11, 11, 12, 12,
	 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13};
const u8 delta_swingidx_mp_2g_cck_c_p_txpwrtrk_type8_8814b[] = {
	1, 2, 3, 3, 4, 6, 6, 7, 9, 9, 10, 11, 12, 12, 13, 14,
	 15, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type8_8814b[] = {
	0, 1, 2, 3, 4, 5, 6, 6, 7, 8, 9, 10, 10, 11, 11, 12,
	 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type8_8814b[] = {
	1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 11, 12, 13, 14, 16,
	 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type8_8814b[] = {
	0, 1, 2, 3, 3, 4, 6, 6, 7, 8, 8, 9, 10, 10, 10, 12, 13,
	 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type8_8814b[] = {
	1, 3, 3, 4, 5, 6, 7, 8, 9, 9, 10, 11, 12, 14, 15, 16,
	 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
#endif

void
odm_read_and_config_mp_8814b_txpowertrack_type8(struct dm_struct *dm)
{
#ifdef CONFIG_8814B_TYPE8

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8814b\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_type8_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_type8_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_type8_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_type8_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gc_p,
		(void *)delta_swingidx_mp_2gc_p_txpwrtrk_type8_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gc_n,
		(void *)delta_swingidx_mp_2gc_n_txpwrtrk_type8_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gd_p,
		(void *)delta_swingidx_mp_2gd_p_txpwrtrk_type8_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gd_n,
		(void *)delta_swingidx_mp_2gd_n_txpwrtrk_type8_8814b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type8_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type8_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type8_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type8_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_c_p,
		(void *)delta_swingidx_mp_2g_cck_c_p_txpwrtrk_type8_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_c_n,
		(void *)delta_swingidx_mp_2g_cck_c_n_txpwrtrk_type8_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_d_p,
		(void *)delta_swingidx_mp_2g_cck_d_p_txpwrtrk_type8_8814b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_d_n,
		(void *)delta_swingidx_mp_2g_cck_d_n_txpwrtrk_type8_8814b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_type8_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_type8_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_type8_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_type8_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gc_p,
		(void *)delta_swingidx_mp_5gc_p_txpwrtrk_type8_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gc_n,
		(void *)delta_swingidx_mp_5gc_n_txpwrtrk_type8_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gd_p,
		(void *)delta_swingidx_mp_5gd_p_txpwrtrk_type8_8814b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gd_n,
		(void *)delta_swingidx_mp_5gd_n_txpwrtrk_type8_8814b,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpwr_lmt.TXT
 ******************************************************************************/

#ifdef CONFIG_8814B
const char *array_mp_8814b_txpwr_lmt[] = {
	"FCC", "2.4G", "20M", "CCK", "1T", "01", "80",
	"ETSI", "2.4G", "20M", "CCK", "1T", "01", "64",
	"MKK", "2.4G", "20M", "CCK", "1T", "01", "64",
	"FCC", "2.4G", "20M", "CCK", "1T", "02", "80",
	"ETSI", "2.4G", "20M", "CCK", "1T", "02", "64",
	"MKK", "2.4G", "20M", "CCK", "1T", "02", "64",
	"FCC", "2.4G", "20M", "CCK", "1T", "03", "80",
	"ETSI", "2.4G", "20M", "CCK", "1T", "03", "64",
	"MKK", "2.4G", "20M", "CCK", "1T", "03", "64",
	"FCC", "2.4G", "20M", "CCK", "1T", "04", "80",
	"ETSI", "2.4G", "20M", "CCK", "1T", "04", "64",
	"MKK", "2.4G", "20M", "CCK", "1T", "04", "64",
	"FCC", "2.4G", "20M", "CCK", "1T", "05", "80",
	"ETSI", "2.4G", "20M", "CCK", "1T", "05", "64",
	"MKK", "2.4G", "20M", "CCK", "1T", "05", "64",
	"FCC", "2.4G", "20M", "CCK", "1T", "06", "80",
	"ETSI", "2.4G", "20M", "CCK", "1T", "06", "64",
	"MKK", "2.4G", "20M", "CCK", "1T", "06", "64",
	"FCC", "2.4G", "20M", "CCK", "1T", "07", "80",
	"ETSI", "2.4G", "20M", "CCK", "1T", "07", "64",
	"MKK", "2.4G", "20M", "CCK", "1T", "07", "64",
	"FCC", "2.4G", "20M", "CCK", "1T", "08", "80",
	"ETSI", "2.4G", "20M", "CCK", "1T", "08", "64",
	"MKK", "2.4G", "20M", "CCK", "1T", "08", "64",
	"FCC", "2.4G", "20M", "CCK", "1T", "09", "80",
	"ETSI", "2.4G", "20M", "CCK", "1T", "09", "64",
	"MKK", "2.4G", "20M", "CCK", "1T", "09", "64",
	"FCC", "2.4G", "20M", "CCK", "1T", "10", "80",
	"ETSI", "2.4G", "20M", "CCK", "1T", "10", "64",
	"MKK", "2.4G", "20M", "CCK", "1T", "10", "64",
	"FCC", "2.4G", "20M", "CCK", "1T", "11", "80",
	"ETSI", "2.4G", "20M", "CCK", "1T", "11", "64",
	"MKK", "2.4G", "20M", "CCK", "1T", "11", "64",
	"FCC", "2.4G", "20M", "CCK", "1T", "12", "127",
	"ETSI", "2.4G", "20M", "CCK", "1T", "12", "64",
	"MKK", "2.4G", "20M", "CCK", "1T", "12", "64",
	"FCC", "2.4G", "20M", "CCK", "1T", "13", "127",
	"ETSI", "2.4G", "20M", "CCK", "1T", "13", "64",
	"MKK", "2.4G", "20M", "CCK", "1T", "13", "64",
	"FCC", "2.4G", "20M", "CCK", "1T", "14", "127",
	"ETSI", "2.4G", "20M", "CCK", "1T", "14", "127",
	"MKK", "2.4G", "20M", "CCK", "1T", "14", "64",
	"FCC", "2.4G", "20M", "OFDM", "1T", "01", "56",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "01", "64",
	"MKK", "2.4G", "20M", "OFDM", "1T", "01", "64",
	"FCC", "2.4G", "20M", "OFDM", "1T", "02", "80",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "02", "64",
	"MKK", "2.4G", "20M", "OFDM", "1T", "02", "64",
	"FCC", "2.4G", "20M", "OFDM", "1T", "03", "80",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "03", "64",
	"MKK", "2.4G", "20M", "OFDM", "1T", "03", "64",
	"FCC", "2.4G", "20M", "OFDM", "1T", "04", "80",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "04", "64",
	"MKK", "2.4G", "20M", "OFDM", "1T", "04", "64",
	"FCC", "2.4G", "20M", "OFDM", "1T", "05", "80",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "05", "64",
	"MKK", "2.4G", "20M", "OFDM", "1T", "05", "64",
	"FCC", "2.4G", "20M", "OFDM", "1T", "06", "80",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "06", "64",
	"MKK", "2.4G", "20M", "OFDM", "1T", "06", "64",
	"FCC", "2.4G", "20M", "OFDM", "1T", "07", "80",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "07", "64",
	"MKK", "2.4G", "20M", "OFDM", "1T", "07", "64",
	"FCC", "2.4G", "20M", "OFDM", "1T", "08", "80",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "08", "64",
	"MKK", "2.4G", "20M", "OFDM", "1T", "08", "64",
	"FCC", "2.4G", "20M", "OFDM", "1T", "09", "80",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "09", "64",
	"MKK", "2.4G", "20M", "OFDM", "1T", "09", "64",
	"FCC", "2.4G", "20M", "OFDM", "1T", "10", "80",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "10", "64",
	"MKK", "2.4G", "20M", "OFDM", "1T", "10", "64",
	"FCC", "2.4G", "20M", "OFDM", "1T", "11", "52",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "11", "64",
	"MKK", "2.4G", "20M", "OFDM", "1T", "11", "64",
	"FCC", "2.4G", "20M", "OFDM", "1T", "12", "127",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "12", "64",
	"MKK", "2.4G", "20M", "OFDM", "1T", "12", "64",
	"FCC", "2.4G", "20M", "OFDM", "1T", "13", "127",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "13", "64",
	"MKK", "2.4G", "20M", "OFDM", "1T", "13", "64",
	"FCC", "2.4G", "20M", "OFDM", "1T", "14", "127",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "14", "127",
	"MKK", "2.4G", "20M", "OFDM", "1T", "14", "127",
	"FCC", "2.4G", "20M", "HT", "1T", "01", "60",
	"ETSI", "2.4G", "20M", "HT", "1T", "01", "64",
	"MKK", "2.4G", "20M", "HT", "1T", "01", "64",
	"FCC", "2.4G", "20M", "HT", "1T", "02", "80",
	"ETSI", "2.4G", "20M", "HT", "1T", "02", "64",
	"MKK", "2.4G", "20M", "HT", "1T", "02", "64",
	"FCC", "2.4G", "20M", "HT", "1T", "03", "80",
	"ETSI", "2.4G", "20M", "HT", "1T", "03", "64",
	"MKK", "2.4G", "20M", "HT", "1T", "03", "64",
	"FCC", "2.4G", "20M", "HT", "1T", "04", "80",
	"ETSI", "2.4G", "20M", "HT", "1T", "04", "64",
	"MKK", "2.4G", "20M", "HT", "1T", "04", "64",
	"FCC", "2.4G", "20M", "HT", "1T", "05", "80",
	"ETSI", "2.4G", "20M", "HT", "1T", "05", "64",
	"MKK", "2.4G", "20M", "HT", "1T", "05", "64",
	"FCC", "2.4G", "20M", "HT", "1T", "06", "80",
	"ETSI", "2.4G", "20M", "HT", "1T", "06", "64",
	"MKK", "2.4G", "20M", "HT", "1T", "06", "64",
	"FCC", "2.4G", "20M", "HT", "1T", "07", "80",
	"ETSI", "2.4G", "20M", "HT", "1T", "07", "64",
	"MKK", "2.4G", "20M", "HT", "1T", "07", "64",
	"FCC", "2.4G", "20M", "HT", "1T", "08", "80",
	"ETSI", "2.4G", "20M", "HT", "1T", "08", "64",
	"MKK", "2.4G", "20M", "HT", "1T", "08", "64",
	"FCC", "2.4G", "20M", "HT", "1T", "09", "80",
	"ETSI", "2.4G", "20M", "HT", "1T", "09", "64",
	"MKK", "2.4G", "20M", "HT", "1T", "09", "64",
	"FCC", "2.4G", "20M", "HT", "1T", "10", "80",
	"ETSI", "2.4G", "20M", "HT", "1T", "10", "64",
	"MKK", "2.4G", "20M", "HT", "1T", "10", "64",
	"FCC", "2.4G", "20M", "HT", "1T", "11", "60",
	"ETSI", "2.4G", "20M", "HT", "1T", "11", "64",
	"MKK", "2.4G", "20M", "HT", "1T", "11", "64",
	"FCC", "2.4G", "20M", "HT", "1T", "12", "127",
	"ETSI", "2.4G", "20M", "HT", "1T", "12", "64",
	"MKK", "2.4G", "20M", "HT", "1T", "12", "64",
	"FCC", "2.4G", "20M", "HT", "1T", "13", "127",
	"ETSI", "2.4G", "20M", "HT", "1T", "13", "64",
	"MKK", "2.4G", "20M", "HT", "1T", "13", "64",
	"FCC", "2.4G", "20M", "HT", "1T", "14", "127",
	"ETSI", "2.4G", "20M", "HT", "1T", "14", "127",
	"MKK", "2.4G", "20M", "HT", "1T", "14", "127",
	"FCC", "2.4G", "20M", "HT", "2T", "01", "56",
	"ETSI", "2.4G", "20M", "HT", "2T", "01", "64",
	"MKK", "2.4G", "20M", "HT", "2T", "01", "64",
	"FCC", "2.4G", "20M", "HT", "2T", "02", "80",
	"ETSI", "2.4G", "20M", "HT", "2T", "02", "64",
	"MKK", "2.4G", "20M", "HT", "2T", "02", "64",
	"FCC", "2.4G", "20M", "HT", "2T", "03", "80",
	"ETSI", "2.4G", "20M", "HT", "2T", "03", "64",
	"MKK", "2.4G", "20M", "HT", "2T", "03", "64",
	"FCC", "2.4G", "20M", "HT", "2T", "04", "80",
	"ETSI", "2.4G", "20M", "HT", "2T", "04", "64",
	"MKK", "2.4G", "20M", "HT", "2T", "04", "64",
	"FCC", "2.4G", "20M", "HT", "2T", "05", "80",
	"ETSI", "2.4G", "20M", "HT", "2T", "05", "64",
	"MKK", "2.4G", "20M", "HT", "2T", "05", "64",
	"FCC", "2.4G", "20M", "HT", "2T", "06", "80",
	"ETSI", "2.4G", "20M", "HT", "2T", "06", "64",
	"MKK", "2.4G", "20M", "HT", "2T", "06", "64",
	"FCC", "2.4G", "20M", "HT", "2T", "07", "80",
	"ETSI", "2.4G", "20M", "HT", "2T", "07", "64",
	"MKK", "2.4G", "20M", "HT", "2T", "07", "64",
	"FCC", "2.4G", "20M", "HT", "2T", "08", "80",
	"ETSI", "2.4G", "20M", "HT", "2T", "08", "64",
	"MKK", "2.4G", "20M", "HT", "2T", "08", "64",
	"FCC", "2.4G", "20M", "HT", "2T", "09", "80",
	"ETSI", "2.4G", "20M", "HT", "2T", "09", "64",
	"MKK", "2.4G", "20M", "HT", "2T", "09", "64",
	"FCC", "2.4G", "20M", "HT", "2T", "10", "80",
	"ETSI", "2.4G", "20M", "HT", "2T", "10", "64",
	"MKK", "2.4G", "20M", "HT", "2T", "10", "64",
	"FCC", "2.4G", "20M", "HT", "2T", "11", "48",
	"ETSI", "2.4G", "20M", "HT", "2T", "11", "64",
	"MKK", "2.4G", "20M", "HT", "2T", "11", "64",
	"FCC", "2.4G", "20M", "HT", "2T", "12", "127",
	"ETSI", "2.4G", "20M", "HT", "2T", "12", "64",
	"MKK", "2.4G", "20M", "HT", "2T", "12", "64",
	"FCC", "2.4G", "20M", "HT", "2T", "13", "127",
	"ETSI", "2.4G", "20M", "HT", "2T", "13", "64",
	"MKK", "2.4G", "20M", "HT", "2T", "13", "64",
	"FCC", "2.4G", "20M", "HT", "2T", "14", "127",
	"ETSI", "2.4G", "20M", "HT", "2T", "14", "127",
	"MKK", "2.4G", "20M", "HT", "2T", "14", "127",
	"FCC", "2.4G", "20M", "HT", "3T", "01", "56",
	"ETSI", "2.4G", "20M", "HT", "3T", "01", "64",
	"MKK", "2.4G", "20M", "HT", "3T", "01", "64",
	"FCC", "2.4G", "20M", "HT", "3T", "02", "80",
	"ETSI", "2.4G", "20M", "HT", "3T", "02", "64",
	"MKK", "2.4G", "20M", "HT", "3T", "02", "64",
	"FCC", "2.4G", "20M", "HT", "3T", "03", "80",
	"ETSI", "2.4G", "20M", "HT", "3T", "03", "64",
	"MKK", "2.4G", "20M", "HT", "3T", "03", "64",
	"FCC", "2.4G", "20M", "HT", "3T", "04", "80",
	"ETSI", "2.4G", "20M", "HT", "3T", "04", "64",
	"MKK", "2.4G", "20M", "HT", "3T", "04", "64",
	"FCC", "2.4G", "20M", "HT", "3T", "05", "80",
	"ETSI", "2.4G", "20M", "HT", "3T", "05", "64",
	"MKK", "2.4G", "20M", "HT", "3T", "05", "64",
	"FCC", "2.4G", "20M", "HT", "3T", "06", "80",
	"ETSI", "2.4G", "20M", "HT", "3T", "06", "64",
	"MKK", "2.4G", "20M", "HT", "3T", "06", "64",
	"FCC", "2.4G", "20M", "HT", "3T", "07", "80",
	"ETSI", "2.4G", "20M", "HT", "3T", "07", "64",
	"MKK", "2.4G", "20M", "HT", "3T", "07", "64",
	"FCC", "2.4G", "20M", "HT", "3T", "08", "80",
	"ETSI", "2.4G", "20M", "HT", "3T", "08", "64",
	"MKK", "2.4G", "20M", "HT", "3T", "08", "64",
	"FCC", "2.4G", "20M", "HT", "3T", "09", "80",
	"ETSI", "2.4G", "20M", "HT", "3T", "09", "64",
	"MKK", "2.4G", "20M", "HT", "3T", "09", "64",
	"FCC", "2.4G", "20M", "HT", "3T", "10", "80",
	"ETSI", "2.4G", "20M", "HT", "3T", "10", "64",
	"MKK", "2.4G", "20M", "HT", "3T", "10", "64",
	"FCC", "2.4G", "20M", "HT", "3T", "11", "48",
	"ETSI", "2.4G", "20M", "HT", "3T", "11", "64",
	"MKK", "2.4G", "20M", "HT", "3T", "11", "64",
	"FCC", "2.4G", "20M", "HT", "3T", "12", "127",
	"ETSI", "2.4G", "20M", "HT", "3T", "12", "64",
	"MKK", "2.4G", "20M", "HT", "3T", "12", "64",
	"FCC", "2.4G", "20M", "HT", "3T", "13", "127",
	"ETSI", "2.4G", "20M", "HT", "3T", "13", "64",
	"MKK", "2.4G", "20M", "HT", "3T", "13", "64",
	"FCC", "2.4G", "20M", "HT", "3T", "14", "127",
	"ETSI", "2.4G", "20M", "HT", "3T", "14", "127",
	"MKK", "2.4G", "20M", "HT", "3T", "14", "127",
	"FCC", "2.4G", "20M", "HT", "4T", "01", "56",
	"ETSI", "2.4G", "20M", "HT", "4T", "01", "64",
	"MKK", "2.4G", "20M", "HT", "4T", "01", "64",
	"FCC", "2.4G", "20M", "HT", "4T", "02", "80",
	"ETSI", "2.4G", "20M", "HT", "4T", "02", "64",
	"MKK", "2.4G", "20M", "HT", "4T", "02", "64",
	"FCC", "2.4G", "20M", "HT", "4T", "03", "80",
	"ETSI", "2.4G", "20M", "HT", "4T", "03", "64",
	"MKK", "2.4G", "20M", "HT", "4T", "03", "64",
	"FCC", "2.4G", "20M", "HT", "4T", "04", "80",
	"ETSI", "2.4G", "20M", "HT", "4T", "04", "64",
	"MKK", "2.4G", "20M", "HT", "4T", "04", "64",
	"FCC", "2.4G", "20M", "HT", "4T", "05", "80",
	"ETSI", "2.4G", "20M", "HT", "4T", "05", "64",
	"MKK", "2.4G", "20M", "HT", "4T", "05", "64",
	"FCC", "2.4G", "20M", "HT", "4T", "06", "80",
	"ETSI", "2.4G", "20M", "HT", "4T", "06", "64",
	"MKK", "2.4G", "20M", "HT", "4T", "06", "64",
	"FCC", "2.4G", "20M", "HT", "4T", "07", "80",
	"ETSI", "2.4G", "20M", "HT", "4T", "07", "64",
	"MKK", "2.4G", "20M", "HT", "4T", "07", "64",
	"FCC", "2.4G", "20M", "HT", "4T", "08", "80",
	"ETSI", "2.4G", "20M", "HT", "4T", "08", "64",
	"MKK", "2.4G", "20M", "HT", "4T", "08", "64",
	"FCC", "2.4G", "20M", "HT", "4T", "09", "80",
	"ETSI", "2.4G", "20M", "HT", "4T", "09", "64",
	"MKK", "2.4G", "20M", "HT", "4T", "09", "64",
	"FCC", "2.4G", "20M", "HT", "4T", "10", "80",
	"ETSI", "2.4G", "20M", "HT", "4T", "10", "64",
	"MKK", "2.4G", "20M", "HT", "4T", "10", "64",
	"FCC", "2.4G", "20M", "HT", "4T", "11", "48",
	"ETSI", "2.4G", "20M", "HT", "4T", "11", "64",
	"MKK", "2.4G", "20M", "HT", "4T", "11", "64",
	"FCC", "2.4G", "20M", "HT", "4T", "12", "127",
	"ETSI", "2.4G", "20M", "HT", "4T", "12", "64",
	"MKK", "2.4G", "20M", "HT", "4T", "12", "64",
	"FCC", "2.4G", "20M", "HT", "4T", "13", "127",
	"ETSI", "2.4G", "20M", "HT", "4T", "13", "64",
	"MKK", "2.4G", "20M", "HT", "4T", "13", "64",
	"FCC", "2.4G", "20M", "HT", "4T", "14", "127",
	"ETSI", "2.4G", "20M", "HT", "4T", "14", "127",
	"MKK", "2.4G", "20M", "HT", "4T", "14", "127",
	"FCC", "2.4G", "40M", "HT", "1T", "01", "127",
	"ETSI", "2.4G", "40M", "HT", "1T", "01", "127",
	"MKK", "2.4G", "40M", "HT", "1T", "01", "127",
	"FCC", "2.4G", "40M", "HT", "1T", "02", "127",
	"ETSI", "2.4G", "40M", "HT", "1T", "02", "127",
	"MKK", "2.4G", "40M", "HT", "1T", "02", "127",
	"FCC", "2.4G", "40M", "HT", "1T", "03", "60",
	"ETSI", "2.4G", "40M", "HT", "1T", "03", "64",
	"MKK", "2.4G", "40M", "HT", "1T", "03", "64",
	"FCC", "2.4G", "40M", "HT", "1T", "04", "68",
	"ETSI", "2.4G", "40M", "HT", "1T", "04", "64",
	"MKK", "2.4G", "40M", "HT", "1T", "04", "64",
	"FCC", "2.4G", "40M", "HT", "1T", "05", "68",
	"ETSI", "2.4G", "40M", "HT", "1T", "05", "64",
	"MKK", "2.4G", "40M", "HT", "1T", "05", "64",
	"FCC", "2.4G", "40M", "HT", "1T", "06", "68",
	"ETSI", "2.4G", "40M", "HT", "1T", "06", "64",
	"MKK", "2.4G", "40M", "HT", "1T", "06", "64",
	"FCC", "2.4G", "40M", "HT", "1T", "07", "68",
	"ETSI", "2.4G", "40M", "HT", "1T", "07", "64",
	"MKK", "2.4G", "40M", "HT", "1T", "07", "64",
	"FCC", "2.4G", "40M", "HT", "1T", "08", "68",
	"ETSI", "2.4G", "40M", "HT", "1T", "08", "64",
	"MKK", "2.4G", "40M", "HT", "1T", "08", "64",
	"FCC", "2.4G", "40M", "HT", "1T", "09", "60",
	"ETSI", "2.4G", "40M", "HT", "1T", "09", "64",
	"MKK", "2.4G", "40M", "HT", "1T", "09", "64",
	"FCC", "2.4G", "40M", "HT", "1T", "10", "127",
	"ETSI", "2.4G", "40M", "HT", "1T", "10", "64",
	"MKK", "2.4G", "40M", "HT", "1T", "10", "64",
	"FCC", "2.4G", "40M", "HT", "1T", "11", "127",
	"ETSI", "2.4G", "40M", "HT", "1T", "11", "64",
	"MKK", "2.4G", "40M", "HT", "1T", "11", "64",
	"FCC", "2.4G", "40M", "HT", "1T", "12", "127",
	"ETSI", "2.4G", "40M", "HT", "1T", "12", "64",
	"MKK", "2.4G", "40M", "HT", "1T", "12", "64",
	"FCC", "2.4G", "40M", "HT", "1T", "13", "127",
	"ETSI", "2.4G", "40M", "HT", "1T", "13", "64",
	"MKK", "2.4G", "40M", "HT", "1T", "13", "64",
	"FCC", "2.4G", "40M", "HT", "1T", "14", "127",
	"ETSI", "2.4G", "40M", "HT", "1T", "14", "127",
	"MKK", "2.4G", "40M", "HT", "1T", "14", "127",
	"FCC", "2.4G", "40M", "HT", "2T", "01", "127",
	"ETSI", "2.4G", "40M", "HT", "2T", "01", "127",
	"MKK", "2.4G", "40M", "HT", "2T", "01", "127",
	"FCC", "2.4G", "40M", "HT", "2T", "02", "127",
	"ETSI", "2.4G", "40M", "HT", "2T", "02", "127",
	"MKK", "2.4G", "40M", "HT", "2T", "02", "127",
	"FCC", "2.4G", "40M", "HT", "2T", "03", "52",
	"ETSI", "2.4G", "40M", "HT", "2T", "03", "64",
	"MKK", "2.4G", "40M", "HT", "2T", "03", "64",
	"FCC", "2.4G", "40M", "HT", "2T", "04", "56",
	"ETSI", "2.4G", "40M", "HT", "2T", "04", "64",
	"MKK", "2.4G", "40M", "HT", "2T", "04", "64",
	"FCC", "2.4G", "40M", "HT", "2T", "05", "56",
	"ETSI", "2.4G", "40M", "HT", "2T", "05", "64",
	"MKK", "2.4G", "40M", "HT", "2T", "05", "64",
	"FCC", "2.4G", "40M", "HT", "2T", "06", "56",
	"ETSI", "2.4G", "40M", "HT", "2T", "06", "64",
	"MKK", "2.4G", "40M", "HT", "2T", "06", "64",
	"FCC", "2.4G", "40M", "HT", "2T", "07", "56",
	"ETSI", "2.4G", "40M", "HT", "2T", "07", "64",
	"MKK", "2.4G", "40M", "HT", "2T", "07", "64",
	"FCC", "2.4G", "40M", "HT", "2T", "08", "56",
	"ETSI", "2.4G", "40M", "HT", "2T", "08", "64",
	"MKK", "2.4G", "40M", "HT", "2T", "08", "64",
	"FCC", "2.4G", "40M", "HT", "2T", "09", "48",
	"ETSI", "2.4G", "40M", "HT", "2T", "09", "64",
	"MKK", "2.4G", "40M", "HT", "2T", "09", "64",
	"FCC", "2.4G", "40M", "HT", "2T", "10", "127",
	"ETSI", "2.4G", "40M", "HT", "2T", "10", "64",
	"MKK", "2.4G", "40M", "HT", "2T", "10", "64",
	"FCC", "2.4G", "40M", "HT", "2T", "11", "127",
	"ETSI", "2.4G", "40M", "HT", "2T", "11", "64",
	"MKK", "2.4G", "40M", "HT", "2T", "11", "64",
	"FCC", "2.4G", "40M", "HT", "2T", "12", "127",
	"ETSI", "2.4G", "40M", "HT", "2T", "12", "64",
	"MKK", "2.4G", "40M", "HT", "2T", "12", "64",
	"FCC", "2.4G", "40M", "HT", "2T", "13", "127",
	"ETSI", "2.4G", "40M", "HT", "2T", "13", "64",
	"MKK", "2.4G", "40M", "HT", "2T", "13", "64",
	"FCC", "2.4G", "40M", "HT", "2T", "14", "127",
	"ETSI", "2.4G", "40M", "HT", "2T", "14", "127",
	"MKK", "2.4G", "40M", "HT", "2T", "14", "127",
	"FCC", "2.4G", "40M", "HT", "3T", "01", "127",
	"ETSI", "2.4G", "40M", "HT", "3T", "01", "127",
	"MKK", "2.4G", "40M", "HT", "3T", "01", "127",
	"FCC", "2.4G", "40M", "HT", "3T", "02", "127",
	"ETSI", "2.4G", "40M", "HT", "3T", "02", "127",
	"MKK", "2.4G", "40M", "HT", "3T", "02", "127",
	"FCC", "2.4G", "40M", "HT", "3T", "03", "52",
	"ETSI", "2.4G", "40M", "HT", "3T", "03", "64",
	"MKK", "2.4G", "40M", "HT", "3T", "03", "64",
	"FCC", "2.4G", "40M", "HT", "3T", "04", "56",
	"ETSI", "2.4G", "40M", "HT", "3T", "04", "64",
	"MKK", "2.4G", "40M", "HT", "3T", "04", "64",
	"FCC", "2.4G", "40M", "HT", "3T", "05", "56",
	"ETSI", "2.4G", "40M", "HT", "3T", "05", "64",
	"MKK", "2.4G", "40M", "HT", "3T", "05", "64",
	"FCC", "2.4G", "40M", "HT", "3T", "06", "56",
	"ETSI", "2.4G", "40M", "HT", "3T", "06", "64",
	"MKK", "2.4G", "40M", "HT", "3T", "06", "64",
	"FCC", "2.4G", "40M", "HT", "3T", "07", "56",
	"ETSI", "2.4G", "40M", "HT", "3T", "07", "64",
	"MKK", "2.4G", "40M", "HT", "3T", "07", "64",
	"FCC", "2.4G", "40M", "HT", "3T", "08", "56",
	"ETSI", "2.4G", "40M", "HT", "3T", "08", "64",
	"MKK", "2.4G", "40M", "HT", "3T", "08", "64",
	"FCC", "2.4G", "40M", "HT", "3T", "09", "48",
	"ETSI", "2.4G", "40M", "HT", "3T", "09", "64",
	"MKK", "2.4G", "40M", "HT", "3T", "09", "64",
	"FCC", "2.4G", "40M", "HT", "3T", "10", "127",
	"ETSI", "2.4G", "40M", "HT", "3T", "10", "64",
	"MKK", "2.4G", "40M", "HT", "3T", "10", "64",
	"FCC", "2.4G", "40M", "HT", "3T", "11", "127",
	"ETSI", "2.4G", "40M", "HT", "3T", "11", "64",
	"MKK", "2.4G", "40M", "HT", "3T", "11", "64",
	"FCC", "2.4G", "40M", "HT", "3T", "12", "127",
	"ETSI", "2.4G", "40M", "HT", "3T", "12", "64",
	"MKK", "2.4G", "40M", "HT", "3T", "12", "64",
	"FCC", "2.4G", "40M", "HT", "3T", "13", "127",
	"ETSI", "2.4G", "40M", "HT", "3T", "13", "64",
	"MKK", "2.4G", "40M", "HT", "3T", "13", "64",
	"FCC", "2.4G", "40M", "HT", "3T", "14", "127",
	"ETSI", "2.4G", "40M", "HT", "3T", "14", "127",
	"MKK", "2.4G", "40M", "HT", "3T", "14", "127",
	"FCC", "2.4G", "40M", "HT", "4T", "01", "127",
	"ETSI", "2.4G", "40M", "HT", "4T", "01", "127",
	"MKK", "2.4G", "40M", "HT", "4T", "01", "127",
	"FCC", "2.4G", "40M", "HT", "4T", "02", "127",
	"ETSI", "2.4G", "40M", "HT", "4T", "02", "127",
	"MKK", "2.4G", "40M", "HT", "4T", "02", "127",
	"FCC", "2.4G", "40M", "HT", "4T", "03", "52",
	"ETSI", "2.4G", "40M", "HT", "4T", "03", "64",
	"MKK", "2.4G", "40M", "HT", "4T", "03", "64",
	"FCC", "2.4G", "40M", "HT", "4T", "04", "56",
	"ETSI", "2.4G", "40M", "HT", "4T", "04", "64",
	"MKK", "2.4G", "40M", "HT", "4T", "04", "64",
	"FCC", "2.4G", "40M", "HT", "4T", "05", "56",
	"ETSI", "2.4G", "40M", "HT", "4T", "05", "64",
	"MKK", "2.4G", "40M", "HT", "4T", "05", "64",
	"FCC", "2.4G", "40M", "HT", "4T", "06", "56",
	"ETSI", "2.4G", "40M", "HT", "4T", "06", "64",
	"MKK", "2.4G", "40M", "HT", "4T", "06", "64",
	"FCC", "2.4G", "40M", "HT", "4T", "07", "56",
	"ETSI", "2.4G", "40M", "HT", "4T", "07", "64",
	"MKK", "2.4G", "40M", "HT", "4T", "07", "64",
	"FCC", "2.4G", "40M", "HT", "4T", "08", "56",
	"ETSI", "2.4G", "40M", "HT", "4T", "08", "64",
	"MKK", "2.4G", "40M", "HT", "4T", "08", "64",
	"FCC", "2.4G", "40M", "HT", "4T", "09", "48",
	"ETSI", "2.4G", "40M", "HT", "4T", "09", "64",
	"MKK", "2.4G", "40M", "HT", "4T", "09", "64",
	"FCC", "2.4G", "40M", "HT", "4T", "10", "127",
	"ETSI", "2.4G", "40M", "HT", "4T", "10", "64",
	"MKK", "2.4G", "40M", "HT", "4T", "10", "64",
	"FCC", "2.4G", "40M", "HT", "4T", "11", "127",
	"ETSI", "2.4G", "40M", "HT", "4T", "11", "64",
	"MKK", "2.4G", "40M", "HT", "4T", "11", "64",
	"FCC", "2.4G", "40M", "HT", "4T", "12", "127",
	"ETSI", "2.4G", "40M", "HT", "4T", "12", "64",
	"MKK", "2.4G", "40M", "HT", "4T", "12", "64",
	"FCC", "2.4G", "40M", "HT", "4T", "13", "127",
	"ETSI", "2.4G", "40M", "HT", "4T", "13", "64",
	"MKK", "2.4G", "40M", "HT", "4T", "13", "64",
	"FCC", "2.4G", "40M", "HT", "4T", "14", "127",
	"ETSI", "2.4G", "40M", "HT", "4T", "14", "127",
	"MKK", "2.4G", "40M", "HT", "4T", "14", "127",
	"FCC", "5G", "20M", "OFDM", "1T", "36", "72",
	"ETSI", "5G", "20M", "OFDM", "1T", "36", "80",
	"MKK", "5G", "20M", "OFDM", "1T", "36", "80",
	"FCC", "5G", "20M", "OFDM", "1T", "40", "80",
	"ETSI", "5G", "20M", "OFDM", "1T", "40", "80",
	"MKK", "5G", "20M", "OFDM", "1T", "40", "80",
	"FCC", "5G", "20M", "OFDM", "1T", "44", "80",
	"ETSI", "5G", "20M", "OFDM", "1T", "44", "80",
	"MKK", "5G", "20M", "OFDM", "1T", "44", "80",
	"FCC", "5G", "20M", "OFDM", "1T", "48", "80",
	"ETSI", "5G", "20M", "OFDM", "1T", "48", "80",
	"MKK", "5G", "20M", "OFDM", "1T", "48", "80",
	"FCC", "5G", "20M", "OFDM", "1T", "52", "80",
	"ETSI", "5G", "20M", "OFDM", "1T", "52", "80",
	"MKK", "5G", "20M", "OFDM", "1T", "52", "80",
	"FCC", "5G", "20M", "OFDM", "1T", "56", "80",
	"ETSI", "5G", "20M", "OFDM", "1T", "56", "80",
	"MKK", "5G", "20M", "OFDM", "1T", "56", "80",
	"FCC", "5G", "20M", "OFDM", "1T", "60", "80",
	"ETSI", "5G", "20M", "OFDM", "1T", "60", "80",
	"MKK", "5G", "20M", "OFDM", "1T", "60", "80",
	"FCC", "5G", "20M", "OFDM", "1T", "64", "72",
	"ETSI", "5G", "20M", "OFDM", "1T", "64", "80",
	"MKK", "5G", "20M", "OFDM", "1T", "64", "80",
	"FCC", "5G", "20M", "OFDM", "1T", "100", "64",
	"ETSI", "5G", "20M", "OFDM", "1T", "100", "80",
	"MKK", "5G", "20M", "OFDM", "1T", "100", "80",
	"FCC", "5G", "20M", "OFDM", "1T", "104", "80",
	"ETSI", "5G", "20M", "OFDM", "1T", "104", "80",
	"MKK", "5G", "20M", "OFDM", "1T", "104", "80",
	"FCC", "5G", "20M", "OFDM", "1T", "108", "80",
	"ETSI", "5G", "20M", "OFDM", "1T", "108", "80",
	"MKK", "5G", "20M", "OFDM", "1T", "108", "80",
	"FCC", "5G", "20M", "OFDM", "1T", "112", "80",
	"ETSI", "5G", "20M", "OFDM", "1T", "112", "80",
	"MKK", "5G", "20M", "OFDM", "1T", "112", "80",
	"FCC", "5G", "20M", "OFDM", "1T", "116", "80",
	"ETSI", "5G", "20M", "OFDM", "1T", "116", "80",
	"MKK", "5G", "20M", "OFDM", "1T", "116", "80",
	"FCC", "5G", "20M", "OFDM", "1T", "120", "80",
	"ETSI", "5G", "20M", "OFDM", "1T", "120", "80",
	"MKK", "5G", "20M", "OFDM", "1T", "120", "80",
	"FCC", "5G", "20M", "OFDM", "1T", "124", "80",
	"ETSI", "5G", "20M", "OFDM", "1T", "124", "80",
	"MKK", "5G", "20M", "OFDM", "1T", "124", "80",
	"FCC", "5G", "20M", "OFDM", "1T", "128", "80",
	"ETSI", "5G", "20M", "OFDM", "1T", "128", "80",
	"MKK", "5G", "20M", "OFDM", "1T", "128", "80",
	"FCC", "5G", "20M", "OFDM", "1T", "132", "80",
	"ETSI", "5G", "20M", "OFDM", "1T", "132", "80",
	"MKK", "5G", "20M", "OFDM", "1T", "132", "80",
	"FCC", "5G", "20M", "OFDM", "1T", "136", "80",
	"ETSI", "5G", "20M", "OFDM", "1T", "136", "80",
	"MKK", "5G", "20M", "OFDM", "1T", "136", "80",
	"FCC", "5G", "20M", "OFDM", "1T", "140", "56",
	"ETSI", "5G", "20M", "OFDM", "1T", "140", "80",
	"MKK", "5G", "20M", "OFDM", "1T", "140", "80",
	"FCC", "5G", "20M", "OFDM", "1T", "149", "80",
	"ETSI", "5G", "20M", "OFDM", "1T", "149", "80",
	"MKK", "5G", "20M", "OFDM", "1T", "149", "127",
	"FCC", "5G", "20M", "OFDM", "1T", "153", "80",
	"ETSI", "5G", "20M", "OFDM", "1T", "153", "80",
	"MKK", "5G", "20M", "OFDM", "1T", "153", "127",
	"FCC", "5G", "20M", "OFDM", "1T", "157", "80",
	"ETSI", "5G", "20M", "OFDM", "1T", "157", "80",
	"MKK", "5G", "20M", "OFDM", "1T", "157", "127",
	"FCC", "5G", "20M", "OFDM", "1T", "161", "80",
	"ETSI", "5G", "20M", "OFDM", "1T", "161", "80",
	"MKK", "5G", "20M", "OFDM", "1T", "161", "127",
	"FCC", "5G", "20M", "OFDM", "1T", "165", "80",
	"ETSI", "5G", "20M", "OFDM", "1T", "165", "80",
	"MKK", "5G", "20M", "OFDM", "1T", "165", "127",
	"FCC", "5G", "20M", "HT", "1T", "36", "72",
	"ETSI", "5G", "20M", "HT", "1T", "36", "80",
	"MKK", "5G", "20M", "HT", "1T", "36", "80",
	"FCC", "5G", "20M", "HT", "1T", "40", "80",
	"ETSI", "5G", "20M", "HT", "1T", "40", "80",
	"MKK", "5G", "20M", "HT", "1T", "40", "80",
	"FCC", "5G", "20M", "HT", "1T", "44", "80",
	"ETSI", "5G", "20M", "HT", "1T", "44", "80",
	"MKK", "5G", "20M", "HT", "1T", "44", "80",
	"FCC", "5G", "20M", "HT", "1T", "48", "80",
	"ETSI", "5G", "20M", "HT", "1T", "48", "80",
	"MKK", "5G", "20M", "HT", "1T", "48", "80",
	"FCC", "5G", "20M", "HT", "1T", "52", "80",
	"ETSI", "5G", "20M", "HT", "1T", "52", "80",
	"MKK", "5G", "20M", "HT", "1T", "52", "80",
	"FCC", "5G", "20M", "HT", "1T", "56", "80",
	"ETSI", "5G", "20M", "HT", "1T", "56", "80",
	"MKK", "5G", "20M", "HT", "1T", "56", "80",
	"FCC", "5G", "20M", "HT", "1T", "60", "80",
	"ETSI", "5G", "20M", "HT", "1T", "60", "80",
	"MKK", "5G", "20M", "HT", "1T", "60", "80",
	"FCC", "5G", "20M", "HT", "1T", "64", "72",
	"ETSI", "5G", "20M", "HT", "1T", "64", "80",
	"MKK", "5G", "20M", "HT", "1T", "64", "80",
	"FCC", "5G", "20M", "HT", "1T", "100", "64",
	"ETSI", "5G", "20M", "HT", "1T", "100", "80",
	"MKK", "5G", "20M", "HT", "1T", "100", "80",
	"FCC", "5G", "20M", "HT", "1T", "104", "80",
	"ETSI", "5G", "20M", "HT", "1T", "104", "80",
	"MKK", "5G", "20M", "HT", "1T", "104", "80",
	"FCC", "5G", "20M", "HT", "1T", "108", "80",
	"ETSI", "5G", "20M", "HT", "1T", "108", "80",
	"MKK", "5G", "20M", "HT", "1T", "108", "80",
	"FCC", "5G", "20M", "HT", "1T", "112", "80",
	"ETSI", "5G", "20M", "HT", "1T", "112", "80",
	"MKK", "5G", "20M", "HT", "1T", "112", "80",
	"FCC", "5G", "20M", "HT", "1T", "116", "80",
	"ETSI", "5G", "20M", "HT", "1T", "116", "80",
	"MKK", "5G", "20M", "HT", "1T", "116", "80",
	"FCC", "5G", "20M", "HT", "1T", "120", "80",
	"ETSI", "5G", "20M", "HT", "1T", "120", "80",
	"MKK", "5G", "20M", "HT", "1T", "120", "80",
	"FCC", "5G", "20M", "HT", "1T", "124", "80",
	"ETSI", "5G", "20M", "HT", "1T", "124", "80",
	"MKK", "5G", "20M", "HT", "1T", "124", "80",
	"FCC", "5G", "20M", "HT", "1T", "128", "80",
	"ETSI", "5G", "20M", "HT", "1T", "128", "80",
	"MKK", "5G", "20M", "HT", "1T", "128", "80",
	"FCC", "5G", "20M", "HT", "1T", "132", "80",
	"ETSI", "5G", "20M", "HT", "1T", "132", "80",
	"MKK", "5G", "20M", "HT", "1T", "132", "80",
	"FCC", "5G", "20M", "HT", "1T", "136", "80",
	"ETSI", "5G", "20M", "HT", "1T", "136", "80",
	"MKK", "5G", "20M", "HT", "1T", "136", "80",
	"FCC", "5G", "20M", "HT", "1T", "140", "56",
	"ETSI", "5G", "20M", "HT", "1T", "140", "80",
	"MKK", "5G", "20M", "HT", "1T", "140", "80",
	"FCC", "5G", "20M", "HT", "1T", "149", "80",
	"ETSI", "5G", "20M", "HT", "1T", "149", "80",
	"MKK", "5G", "20M", "HT", "1T", "149", "127",
	"FCC", "5G", "20M", "HT", "1T", "153", "80",
	"ETSI", "5G", "20M", "HT", "1T", "153", "80",
	"MKK", "5G", "20M", "HT", "1T", "153", "127",
	"FCC", "5G", "20M", "HT", "1T", "157", "80",
	"ETSI", "5G", "20M", "HT", "1T", "157", "80",
	"MKK", "5G", "20M", "HT", "1T", "157", "127",
	"FCC", "5G", "20M", "HT", "1T", "161", "80",
	"ETSI", "5G", "20M", "HT", "1T", "161", "80",
	"MKK", "5G", "20M", "HT", "1T", "161", "127",
	"FCC", "5G", "20M", "HT", "1T", "165", "80",
	"ETSI", "5G", "20M", "HT", "1T", "165", "80",
	"MKK", "5G", "20M", "HT", "1T", "165", "127",
	"FCC", "5G", "20M", "HT", "2T", "36", "64",
	"ETSI", "5G", "20M", "HT", "2T", "36", "80",
	"MKK", "5G", "20M", "HT", "2T", "36", "80",
	"FCC", "5G", "20M", "HT", "2T", "40", "80",
	"ETSI", "5G", "20M", "HT", "2T", "40", "80",
	"MKK", "5G", "20M", "HT", "2T", "40", "80",
	"FCC", "5G", "20M", "HT", "2T", "44", "80",
	"ETSI", "5G", "20M", "HT", "2T", "44", "80",
	"MKK", "5G", "20M", "HT", "2T", "44", "80",
	"FCC", "5G", "20M", "HT", "2T", "48", "80",
	"ETSI", "5G", "20M", "HT", "2T", "48", "80",
	"MKK", "5G", "20M", "HT", "2T", "48", "80",
	"FCC", "5G", "20M", "HT", "2T", "52", "80",
	"ETSI", "5G", "20M", "HT", "2T", "52", "80",
	"MKK", "5G", "20M", "HT", "2T", "52", "80",
	"FCC", "5G", "20M", "HT", "2T", "56", "80",
	"ETSI", "5G", "20M", "HT", "2T", "56", "80",
	"MKK", "5G", "20M", "HT", "2T", "56", "80",
	"FCC", "5G", "20M", "HT", "2T", "60", "80",
	"ETSI", "5G", "20M", "HT", "2T", "60", "80",
	"MKK", "5G", "20M", "HT", "2T", "60", "80",
	"FCC", "5G", "20M", "HT", "2T", "64", "64",
	"ETSI", "5G", "20M", "HT", "2T", "64", "80",
	"MKK", "5G", "20M", "HT", "2T", "64", "80",
	"FCC", "5G", "20M", "HT", "2T", "100", "64",
	"ETSI", "5G", "20M", "HT", "2T", "100", "80",
	"MKK", "5G", "20M", "HT", "2T", "100", "80",
	"FCC", "5G", "20M", "HT", "2T", "104", "80",
	"ETSI", "5G", "20M", "HT", "2T", "104", "80",
	"MKK", "5G", "20M", "HT", "2T", "104", "80",
	"FCC", "5G", "20M", "HT", "2T", "108", "80",
	"ETSI", "5G", "20M", "HT", "2T", "108", "80",
	"MKK", "5G", "20M", "HT", "2T", "108", "80",
	"FCC", "5G", "20M", "HT", "2T", "112", "80",
	"ETSI", "5G", "20M", "HT", "2T", "112", "80",
	"MKK", "5G", "20M", "HT", "2T", "112", "80",
	"FCC", "5G", "20M", "HT", "2T", "116", "80",
	"ETSI", "5G", "20M", "HT", "2T", "116", "80",
	"MKK", "5G", "20M", "HT", "2T", "116", "80",
	"FCC", "5G", "20M", "HT", "2T", "120", "80",
	"ETSI", "5G", "20M", "HT", "2T", "120", "80",
	"MKK", "5G", "20M", "HT", "2T", "120", "80",
	"FCC", "5G", "20M", "HT", "2T", "124", "80",
	"ETSI", "5G", "20M", "HT", "2T", "124", "80",
	"MKK", "5G", "20M", "HT", "2T", "124", "80",
	"FCC", "5G", "20M", "HT", "2T", "128", "80",
	"ETSI", "5G", "20M", "HT", "2T", "128", "80",
	"MKK", "5G", "20M", "HT", "2T", "128", "80",
	"FCC", "5G", "20M", "HT", "2T", "132", "80",
	"ETSI", "5G", "20M", "HT", "2T", "132", "80",
	"MKK", "5G", "20M", "HT", "2T", "132", "80",
	"FCC", "5G", "20M", "HT", "2T", "136", "80",
	"ETSI", "5G", "20M", "HT", "2T", "136", "80",
	"MKK", "5G", "20M", "HT", "2T", "136", "80",
	"FCC", "5G", "20M", "HT", "2T", "140", "60",
	"ETSI", "5G", "20M", "HT", "2T", "140", "80",
	"MKK", "5G", "20M", "HT", "2T", "140", "80",
	"FCC", "5G", "20M", "HT", "2T", "149", "80",
	"ETSI", "5G", "20M", "HT", "2T", "149", "80",
	"MKK", "5G", "20M", "HT", "2T", "149", "127",
	"FCC", "5G", "20M", "HT", "2T", "153", "80",
	"ETSI", "5G", "20M", "HT", "2T", "153", "80",
	"MKK", "5G", "20M", "HT", "2T", "153", "127",
	"FCC", "5G", "20M", "HT", "2T", "157", "80",
	"ETSI", "5G", "20M", "HT", "2T", "157", "80",
	"MKK", "5G", "20M", "HT", "2T", "157", "127",
	"FCC", "5G", "20M", "HT", "2T", "161", "80",
	"ETSI", "5G", "20M", "HT", "2T", "161", "80",
	"MKK", "5G", "20M", "HT", "2T", "161", "127",
	"FCC", "5G", "20M", "HT", "2T", "165", "80",
	"ETSI", "5G", "20M", "HT", "2T", "165", "80",
	"MKK", "5G", "20M", "HT", "2T", "165", "127",
	"FCC", "5G", "20M", "HT", "3T", "36", "64",
	"ETSI", "5G", "20M", "HT", "3T", "36", "80",
	"MKK", "5G", "20M", "HT", "3T", "36", "80",
	"FCC", "5G", "20M", "HT", "3T", "40", "80",
	"ETSI", "5G", "20M", "HT", "3T", "40", "80",
	"MKK", "5G", "20M", "HT", "3T", "40", "80",
	"FCC", "5G", "20M", "HT", "3T", "44", "80",
	"ETSI", "5G", "20M", "HT", "3T", "44", "80",
	"MKK", "5G", "20M", "HT", "3T", "44", "80",
	"FCC", "5G", "20M", "HT", "3T", "48", "80",
	"ETSI", "5G", "20M", "HT", "3T", "48", "80",
	"MKK", "5G", "20M", "HT", "3T", "48", "80",
	"FCC", "5G", "20M", "HT", "3T", "52", "80",
	"ETSI", "5G", "20M", "HT", "3T", "52", "80",
	"MKK", "5G", "20M", "HT", "3T", "52", "80",
	"FCC", "5G", "20M", "HT", "3T", "56", "80",
	"ETSI", "5G", "20M", "HT", "3T", "56", "80",
	"MKK", "5G", "20M", "HT", "3T", "56", "80",
	"FCC", "5G", "20M", "HT", "3T", "60", "80",
	"ETSI", "5G", "20M", "HT", "3T", "60", "80",
	"MKK", "5G", "20M", "HT", "3T", "60", "80",
	"FCC", "5G", "20M", "HT", "3T", "64", "64",
	"ETSI", "5G", "20M", "HT", "3T", "64", "80",
	"MKK", "5G", "20M", "HT", "3T", "64", "80",
	"FCC", "5G", "20M", "HT", "3T", "100", "64",
	"ETSI", "5G", "20M", "HT", "3T", "100", "80",
	"MKK", "5G", "20M", "HT", "3T", "100", "80",
	"FCC", "5G", "20M", "HT", "3T", "104", "80",
	"ETSI", "5G", "20M", "HT", "3T", "104", "80",
	"MKK", "5G", "20M", "HT", "3T", "104", "80",
	"FCC", "5G", "20M", "HT", "3T", "108", "80",
	"ETSI", "5G", "20M", "HT", "3T", "108", "80",
	"MKK", "5G", "20M", "HT", "3T", "108", "80",
	"FCC", "5G", "20M", "HT", "3T", "112", "80",
	"ETSI", "5G", "20M", "HT", "3T", "112", "80",
	"MKK", "5G", "20M", "HT", "3T", "112", "80",
	"FCC", "5G", "20M", "HT", "3T", "116", "80",
	"ETSI", "5G", "20M", "HT", "3T", "116", "80",
	"MKK", "5G", "20M", "HT", "3T", "116", "80",
	"FCC", "5G", "20M", "HT", "3T", "120", "80",
	"ETSI", "5G", "20M", "HT", "3T", "120", "80",
	"MKK", "5G", "20M", "HT", "3T", "120", "80",
	"FCC", "5G", "20M", "HT", "3T", "124", "80",
	"ETSI", "5G", "20M", "HT", "3T", "124", "80",
	"MKK", "5G", "20M", "HT", "3T", "124", "80",
	"FCC", "5G", "20M", "HT", "3T", "128", "80",
	"ETSI", "5G", "20M", "HT", "3T", "128", "80",
	"MKK", "5G", "20M", "HT", "3T", "128", "80",
	"FCC", "5G", "20M", "HT", "3T", "132", "80",
	"ETSI", "5G", "20M", "HT", "3T", "132", "80",
	"MKK", "5G", "20M", "HT", "3T", "132", "80",
	"FCC", "5G", "20M", "HT", "3T", "136", "80",
	"ETSI", "5G", "20M", "HT", "3T", "136", "80",
	"MKK", "5G", "20M", "HT", "3T", "136", "80",
	"FCC", "5G", "20M", "HT", "3T", "140", "60",
	"ETSI", "5G", "20M", "HT", "3T", "140", "80",
	"MKK", "5G", "20M", "HT", "3T", "140", "80",
	"FCC", "5G", "20M", "HT", "3T", "149", "80",
	"ETSI", "5G", "20M", "HT", "3T", "149", "80",
	"MKK", "5G", "20M", "HT", "3T", "149", "127",
	"FCC", "5G", "20M", "HT", "3T", "153", "80",
	"ETSI", "5G", "20M", "HT", "3T", "153", "80",
	"MKK", "5G", "20M", "HT", "3T", "153", "127",
	"FCC", "5G", "20M", "HT", "3T", "157", "80",
	"ETSI", "5G", "20M", "HT", "3T", "157", "80",
	"MKK", "5G", "20M", "HT", "3T", "157", "127",
	"FCC", "5G", "20M", "HT", "3T", "161", "80",
	"ETSI", "5G", "20M", "HT", "3T", "161", "80",
	"MKK", "5G", "20M", "HT", "3T", "161", "127",
	"FCC", "5G", "20M", "HT", "3T", "165", "80",
	"ETSI", "5G", "20M", "HT", "3T", "165", "80",
	"MKK", "5G", "20M", "HT", "3T", "165", "127",
	"FCC", "5G", "20M", "HT", "4T", "36", "64",
	"ETSI", "5G", "20M", "HT", "4T", "36", "80",
	"MKK", "5G", "20M", "HT", "4T", "36", "80",
	"FCC", "5G", "20M", "HT", "4T", "40", "80",
	"ETSI", "5G", "20M", "HT", "4T", "40", "80",
	"MKK", "5G", "20M", "HT", "4T", "40", "80",
	"FCC", "5G", "20M", "HT", "4T", "44", "80",
	"ETSI", "5G", "20M", "HT", "4T", "44", "80",
	"MKK", "5G", "20M", "HT", "4T", "44", "80",
	"FCC", "5G", "20M", "HT", "4T", "48", "80",
	"ETSI", "5G", "20M", "HT", "4T", "48", "80",
	"MKK", "5G", "20M", "HT", "4T", "48", "80",
	"FCC", "5G", "20M", "HT", "4T", "52", "80",
	"ETSI", "5G", "20M", "HT", "4T", "52", "80",
	"MKK", "5G", "20M", "HT", "4T", "52", "80",
	"FCC", "5G", "20M", "HT", "4T", "56", "80",
	"ETSI", "5G", "20M", "HT", "4T", "56", "80",
	"MKK", "5G", "20M", "HT", "4T", "56", "80",
	"FCC", "5G", "20M", "HT", "4T", "60", "80",
	"ETSI", "5G", "20M", "HT", "4T", "60", "80",
	"MKK", "5G", "20M", "HT", "4T", "60", "80",
	"FCC", "5G", "20M", "HT", "4T", "64", "64",
	"ETSI", "5G", "20M", "HT", "4T", "64", "80",
	"MKK", "5G", "20M", "HT", "4T", "64", "80",
	"FCC", "5G", "20M", "HT", "4T", "100", "64",
	"ETSI", "5G", "20M", "HT", "4T", "100", "80",
	"MKK", "5G", "20M", "HT", "4T", "100", "80",
	"FCC", "5G", "20M", "HT", "4T", "104", "80",
	"ETSI", "5G", "20M", "HT", "4T", "104", "80",
	"MKK", "5G", "20M", "HT", "4T", "104", "80",
	"FCC", "5G", "20M", "HT", "4T", "108", "80",
	"ETSI", "5G", "20M", "HT", "4T", "108", "80",
	"MKK", "5G", "20M", "HT", "4T", "108", "80",
	"FCC", "5G", "20M", "HT", "4T", "112", "80",
	"ETSI", "5G", "20M", "HT", "4T", "112", "80",
	"MKK", "5G", "20M", "HT", "4T", "112", "80",
	"FCC", "5G", "20M", "HT", "4T", "116", "80",
	"ETSI", "5G", "20M", "HT", "4T", "116", "80",
	"MKK", "5G", "20M", "HT", "4T", "116", "80",
	"FCC", "5G", "20M", "HT", "4T", "120", "80",
	"ETSI", "5G", "20M", "HT", "4T", "120", "80",
	"MKK", "5G", "20M", "HT", "4T", "120", "80",
	"FCC", "5G", "20M", "HT", "4T", "124", "80",
	"ETSI", "5G", "20M", "HT", "4T", "124", "80",
	"MKK", "5G", "20M", "HT", "4T", "124", "80",
	"FCC", "5G", "20M", "HT", "4T", "128", "80",
	"ETSI", "5G", "20M", "HT", "4T", "128", "80",
	"MKK", "5G", "20M", "HT", "4T", "128", "80",
	"FCC", "5G", "20M", "HT", "4T", "132", "80",
	"ETSI", "5G", "20M", "HT", "4T", "132", "80",
	"MKK", "5G", "20M", "HT", "4T", "132", "80",
	"FCC", "5G", "20M", "HT", "4T", "136", "80",
	"ETSI", "5G", "20M", "HT", "4T", "136", "80",
	"MKK", "5G", "20M", "HT", "4T", "136", "80",
	"FCC", "5G", "20M", "HT", "4T", "140", "60",
	"ETSI", "5G", "20M", "HT", "4T", "140", "80",
	"MKK", "5G", "20M", "HT", "4T", "140", "80",
	"FCC", "5G", "20M", "HT", "4T", "149", "80",
	"ETSI", "5G", "20M", "HT", "4T", "149", "80",
	"MKK", "5G", "20M", "HT", "4T", "149", "127",
	"FCC", "5G", "20M", "HT", "4T", "153", "80",
	"ETSI", "5G", "20M", "HT", "4T", "153", "80",
	"MKK", "5G", "20M", "HT", "4T", "153", "127",
	"FCC", "5G", "20M", "HT", "4T", "157", "80",
	"ETSI", "5G", "20M", "HT", "4T", "157", "80",
	"MKK", "5G", "20M", "HT", "4T", "157", "127",
	"FCC", "5G", "20M", "HT", "4T", "161", "80",
	"ETSI", "5G", "20M", "HT", "4T", "161", "80",
	"MKK", "5G", "20M", "HT", "4T", "161", "127",
	"FCC", "5G", "20M", "HT", "4T", "165", "80",
	"ETSI", "5G", "20M", "HT", "4T", "165", "80",
	"MKK", "5G", "20M", "HT", "4T", "165", "127",
	"FCC", "5G", "40M", "HT", "1T", "38", "64",
	"ETSI", "5G", "40M", "HT", "1T", "38", "80",
	"MKK", "5G", "40M", "HT", "1T", "38", "80",
	"FCC", "5G", "40M", "HT", "1T", "46", "80",
	"ETSI", "5G", "40M", "HT", "1T", "46", "80",
	"MKK", "5G", "40M", "HT", "1T", "46", "80",
	"FCC", "5G", "40M", "HT", "1T", "54", "80",
	"ETSI", "5G", "40M", "HT", "1T", "54", "80",
	"MKK", "5G", "40M", "HT", "1T", "54", "80",
	"FCC", "5G", "40M", "HT", "1T", "62", "64",
	"ETSI", "5G", "40M", "HT", "1T", "62", "80",
	"MKK", "5G", "40M", "HT", "1T", "62", "80",
	"FCC", "5G", "40M", "HT", "1T", "102", "60",
	"ETSI", "5G", "40M", "HT", "1T", "102", "80",
	"MKK", "5G", "40M", "HT", "1T", "102", "80",
	"FCC", "5G", "40M", "HT", "1T", "110", "80",
	"ETSI", "5G", "40M", "HT", "1T", "110", "80",
	"MKK", "5G", "40M", "HT", "1T", "110", "80",
	"FCC", "5G", "40M", "HT", "1T", "118", "80",
	"ETSI", "5G", "40M", "HT", "1T", "118", "80",
	"MKK", "5G", "40M", "HT", "1T", "118", "80",
	"FCC", "5G", "40M", "HT", "1T", "126", "80",
	"ETSI", "5G", "40M", "HT", "1T", "126", "80",
	"MKK", "5G", "40M", "HT", "1T", "126", "80",
	"FCC", "5G", "40M", "HT", "1T", "134", "68",
	"ETSI", "5G", "40M", "HT", "1T", "134", "80",
	"MKK", "5G", "40M", "HT", "1T", "134", "80",
	"FCC", "5G", "40M", "HT", "1T", "142", "68",
	"ETSI", "5G", "40M", "HT", "1T", "142", "80",
	"MKK", "5G", "40M", "HT", "1T", "142", "80",
	"FCC", "5G", "40M", "HT", "1T", "151", "80",
	"ETSI", "5G", "40M", "HT", "1T", "151", "80",
	"MKK", "5G", "40M", "HT", "1T", "151", "127",
	"FCC", "5G", "40M", "HT", "1T", "159", "80",
	"ETSI", "5G", "40M", "HT", "1T", "159", "80",
	"MKK", "5G", "40M", "HT", "1T", "159", "127",
	"FCC", "5G", "40M", "HT", "1T", "167", "80",
	"ETSI", "5G", "40M", "HT", "1T", "167", "80",
	"MKK", "5G", "40M", "HT", "1T", "167", "127",
	"FCC", "5G", "40M", "HT", "1T", "175", "80",
	"ETSI", "5G", "40M", "HT", "1T", "175", "80",
	"MKK", "5G", "40M", "HT", "1T", "175", "127",
	"FCC", "5G", "40M", "HT", "2T", "38", "56",
	"ETSI", "5G", "40M", "HT", "2T", "38", "80",
	"MKK", "5G", "40M", "HT", "2T", "38", "80",
	"FCC", "5G", "40M", "HT", "2T", "46", "80",
	"ETSI", "5G", "40M", "HT", "2T", "46", "80",
	"MKK", "5G", "40M", "HT", "2T", "46", "80",
	"FCC", "5G", "40M", "HT", "2T", "54", "80",
	"ETSI", "5G", "40M", "HT", "2T", "54", "80",
	"MKK", "5G", "40M", "HT", "2T", "54", "80",
	"FCC", "5G", "40M", "HT", "2T", "62", "60",
	"ETSI", "5G", "40M", "HT", "2T", "62", "80",
	"MKK", "5G", "40M", "HT", "2T", "62", "80",
	"FCC", "5G", "40M", "HT", "2T", "102", "60",
	"ETSI", "5G", "40M", "HT", "2T", "102", "80",
	"MKK", "5G", "40M", "HT", "2T", "102", "80",
	"FCC", "5G", "40M", "HT", "2T", "110", "80",
	"ETSI", "5G", "40M", "HT", "2T", "110", "80",
	"MKK", "5G", "40M", "HT", "2T", "110", "80",
	"FCC", "5G", "40M", "HT", "2T", "118", "80",
	"ETSI", "5G", "40M", "HT", "2T", "118", "80",
	"MKK", "5G", "40M", "HT", "2T", "118", "80",
	"FCC", "5G", "40M", "HT", "2T", "126", "80",
	"ETSI", "5G", "40M", "HT", "2T", "126", "80",
	"MKK", "5G", "40M", "HT", "2T", "126", "80",
	"FCC", "5G", "40M", "HT", "2T", "134", "64",
	"ETSI", "5G", "40M", "HT", "2T", "134", "80",
	"MKK", "5G", "40M", "HT", "2T", "134", "80",
	"FCC", "5G", "40M", "HT", "2T", "142", "64",
	"ETSI", "5G", "40M", "HT", "2T", "142", "80",
	"MKK", "5G", "40M", "HT", "2T", "142", "80",
	"FCC", "5G", "40M", "HT", "2T", "151", "80",
	"ETSI", "5G", "40M", "HT", "2T", "151", "80",
	"MKK", "5G", "40M", "HT", "2T", "151", "127",
	"FCC", "5G", "40M", "HT", "2T", "159", "80",
	"ETSI", "5G", "40M", "HT", "2T", "159", "80",
	"MKK", "5G", "40M", "HT", "2T", "159", "127",
	"FCC", "5G", "40M", "HT", "2T", "167", "80",
	"ETSI", "5G", "40M", "HT", "2T", "167", "80",
	"MKK", "5G", "40M", "HT", "2T", "167", "127",
	"FCC", "5G", "40M", "HT", "2T", "175", "80",
	"ETSI", "5G", "40M", "HT", "2T", "175", "80",
	"MKK", "5G", "40M", "HT", "2T", "175", "127",
	"FCC", "5G", "40M", "HT", "3T", "38", "56",
	"ETSI", "5G", "40M", "HT", "3T", "38", "80",
	"MKK", "5G", "40M", "HT", "3T", "38", "80",
	"FCC", "5G", "40M", "HT", "3T", "46", "80",
	"ETSI", "5G", "40M", "HT", "3T", "46", "80",
	"MKK", "5G", "40M", "HT", "3T", "46", "80",
	"FCC", "5G", "40M", "HT", "3T", "54", "80",
	"ETSI", "5G", "40M", "HT", "3T", "54", "80",
	"MKK", "5G", "40M", "HT", "3T", "54", "80",
	"FCC", "5G", "40M", "HT", "3T", "62", "60",
	"ETSI", "5G", "40M", "HT", "3T", "62", "80",
	"MKK", "5G", "40M", "HT", "3T", "62", "80",
	"FCC", "5G", "40M", "HT", "3T", "102", "60",
	"ETSI", "5G", "40M", "HT", "3T", "102", "80",
	"MKK", "5G", "40M", "HT", "3T", "102", "80",
	"FCC", "5G", "40M", "HT", "3T", "110", "80",
	"ETSI", "5G", "40M", "HT", "3T", "110", "80",
	"MKK", "5G", "40M", "HT", "3T", "110", "80",
	"FCC", "5G", "40M", "HT", "3T", "118", "80",
	"ETSI", "5G", "40M", "HT", "3T", "118", "80",
	"MKK", "5G", "40M", "HT", "3T", "118", "80",
	"FCC", "5G", "40M", "HT", "3T", "126", "80",
	"ETSI", "5G", "40M", "HT", "3T", "126", "80",
	"MKK", "5G", "40M", "HT", "3T", "126", "80",
	"FCC", "5G", "40M", "HT", "3T", "134", "64",
	"ETSI", "5G", "40M", "HT", "3T", "134", "80",
	"MKK", "5G", "40M", "HT", "3T", "134", "80",
	"FCC", "5G", "40M", "HT", "3T", "142", "64",
	"ETSI", "5G", "40M", "HT", "3T", "142", "80",
	"MKK", "5G", "40M", "HT", "3T", "142", "80",
	"FCC", "5G", "40M", "HT", "3T", "151", "80",
	"ETSI", "5G", "40M", "HT", "3T", "151", "80",
	"MKK", "5G", "40M", "HT", "3T", "151", "127",
	"FCC", "5G", "40M", "HT", "3T", "159", "80",
	"ETSI", "5G", "40M", "HT", "3T", "159", "80",
	"MKK", "5G", "40M", "HT", "3T", "159", "127",
	"FCC", "5G", "40M", "HT", "3T", "167", "80",
	"ETSI", "5G", "40M", "HT", "3T", "167", "80",
	"MKK", "5G", "40M", "HT", "3T", "167", "127",
	"FCC", "5G", "40M", "HT", "3T", "175", "80",
	"ETSI", "5G", "40M", "HT", "3T", "175", "80",
	"MKK", "5G", "40M", "HT", "3T", "175", "127",
	"FCC", "5G", "40M", "HT", "4T", "38", "56",
	"ETSI", "5G", "40M", "HT", "4T", "38", "80",
	"MKK", "5G", "40M", "HT", "4T", "38", "80",
	"FCC", "5G", "40M", "HT", "4T", "46", "80",
	"ETSI", "5G", "40M", "HT", "4T", "46", "80",
	"MKK", "5G", "40M", "HT", "4T", "46", "80",
	"FCC", "5G", "40M", "HT", "4T", "54", "80",
	"ETSI", "5G", "40M", "HT", "4T", "54", "80",
	"MKK", "5G", "40M", "HT", "4T", "54", "80",
	"FCC", "5G", "40M", "HT", "4T", "62", "60",
	"ETSI", "5G", "40M", "HT", "4T", "62", "80",
	"MKK", "5G", "40M", "HT", "4T", "62", "80",
	"FCC", "5G", "40M", "HT", "4T", "102", "60",
	"ETSI", "5G", "40M", "HT", "4T", "102", "80",
	"MKK", "5G", "40M", "HT", "4T", "102", "80",
	"FCC", "5G", "40M", "HT", "4T", "110", "80",
	"ETSI", "5G", "40M", "HT", "4T", "110", "80",
	"MKK", "5G", "40M", "HT", "4T", "110", "80",
	"FCC", "5G", "40M", "HT", "4T", "118", "80",
	"ETSI", "5G", "40M", "HT", "4T", "118", "80",
	"MKK", "5G", "40M", "HT", "4T", "118", "80",
	"FCC", "5G", "40M", "HT", "4T", "126", "80",
	"ETSI", "5G", "40M", "HT", "4T", "126", "80",
	"MKK", "5G", "40M", "HT", "4T", "126", "80",
	"FCC", "5G", "40M", "HT", "4T", "134", "64",
	"ETSI", "5G", "40M", "HT", "4T", "134", "80",
	"MKK", "5G", "40M", "HT", "4T", "134", "80",
	"FCC", "5G", "40M", "HT", "4T", "142", "64",
	"ETSI", "5G", "40M", "HT", "4T", "142", "80",
	"MKK", "5G", "40M", "HT", "4T", "142", "80",
	"FCC", "5G", "40M", "HT", "4T", "151", "80",
	"ETSI", "5G", "40M", "HT", "4T", "151", "80",
	"MKK", "5G", "40M", "HT", "4T", "151", "127",
	"FCC", "5G", "40M", "HT", "4T", "159", "80",
	"ETSI", "5G", "40M", "HT", "4T", "159", "80",
	"MKK", "5G", "40M", "HT", "4T", "159", "127",
	"FCC", "5G", "40M", "HT", "4T", "167", "80",
	"ETSI", "5G", "40M", "HT", "4T", "167", "80",
	"MKK", "5G", "40M", "HT", "4T", "167", "127",
	"FCC", "5G", "40M", "HT", "4T", "175", "80",
	"ETSI", "5G", "40M", "HT", "4T", "175", "80",
	"MKK", "5G", "40M", "HT", "4T", "175", "127",
	"FCC", "5G", "80M", "VHT", "1T", "42", "60",
	"ETSI", "5G", "80M", "VHT", "1T", "42", "80",
	"MKK", "5G", "80M", "VHT", "1T", "42", "80",
	"FCC", "5G", "80M", "VHT", "1T", "58", "56",
	"ETSI", "5G", "80M", "VHT", "1T", "58", "80",
	"MKK", "5G", "80M", "VHT", "1T", "58", "80",
	"FCC", "5G", "80M", "VHT", "1T", "106", "56",
	"ETSI", "5G", "80M", "VHT", "1T", "106", "80",
	"MKK", "5G", "80M", "VHT", "1T", "106", "80",
	"FCC", "5G", "80M", "VHT", "1T", "122", "56",
	"ETSI", "5G", "80M", "VHT", "1T", "122", "80",
	"MKK", "5G", "80M", "VHT", "1T", "122", "80",
	"FCC", "5G", "80M", "VHT", "1T", "155", "80",
	"ETSI", "5G", "80M", "VHT", "1T", "155", "80",
	"MKK", "5G", "80M", "VHT", "1T", "155", "127",
	"FCC", "5G", "80M", "VHT", "2T", "42", "52",
	"ETSI", "5G", "80M", "VHT", "2T", "42", "80",
	"MKK", "5G", "80M", "VHT", "2T", "42", "80",
	"FCC", "5G", "80M", "VHT", "2T", "58", "52",
	"ETSI", "5G", "80M", "VHT", "2T", "58", "80",
	"MKK", "5G", "80M", "VHT", "2T", "58", "80",
	"FCC", "5G", "80M", "VHT", "2T", "106", "52",
	"ETSI", "5G", "80M", "VHT", "2T", "106", "80",
	"MKK", "5G", "80M", "VHT", "2T", "106", "80",
	"FCC", "5G", "80M", "VHT", "2T", "122", "52",
	"ETSI", "5G", "80M", "VHT", "2T", "122", "80",
	"MKK", "5G", "80M", "VHT", "2T", "122", "80",
	"FCC", "5G", "80M", "VHT", "2T", "155", "80",
	"ETSI", "5G", "80M", "VHT", "2T", "155", "80",
	"MKK", "5G", "80M", "VHT", "2T", "155", "127",
	"FCC", "5G", "80M", "VHT", "3T", "42", "52",
	"ETSI", "5G", "80M", "VHT", "3T", "42", "80",
	"MKK", "5G", "80M", "VHT", "3T", "42", "80",
	"FCC", "5G", "80M", "VHT", "3T", "58", "52",
	"ETSI", "5G", "80M", "VHT", "3T", "58", "80",
	"MKK", "5G", "80M", "VHT", "3T", "58", "80",
	"FCC", "5G", "80M", "VHT", "3T", "106", "52",
	"ETSI", "5G", "80M", "VHT", "3T", "106", "80",
	"MKK", "5G", "80M", "VHT", "3T", "106", "80",
	"FCC", "5G", "80M", "VHT", "3T", "122", "52",
	"ETSI", "5G", "80M", "VHT", "3T", "122", "80",
	"MKK", "5G", "80M", "VHT", "3T", "122", "80",
	"FCC", "5G", "80M", "VHT", "3T", "155", "80",
	"ETSI", "5G", "80M", "VHT", "3T", "155", "80",
	"MKK", "5G", "80M", "VHT", "3T", "155", "127",
	"FCC", "5G", "80M", "VHT", "4T", "42", "52",
	"ETSI", "5G", "80M", "VHT", "4T", "42", "80",
	"MKK", "5G", "80M", "VHT", "4T", "42", "80",
	"FCC", "5G", "80M", "VHT", "4T", "58", "52",
	"ETSI", "5G", "80M", "VHT", "4T", "58", "80",
	"MKK", "5G", "80M", "VHT", "4T", "58", "80",
	"FCC", "5G", "80M", "VHT", "4T", "106", "52",
	"ETSI", "5G", "80M", "VHT", "4T", "106", "80",
	"MKK", "5G", "80M", "VHT", "4T", "106", "80",
	"FCC", "5G", "80M", "VHT", "4T", "122", "52",
	"ETSI", "5G", "80M", "VHT", "4T", "122", "80",
	"MKK", "5G", "80M", "VHT", "4T", "122", "80",
	"FCC", "5G", "80M", "VHT", "4T", "155", "80",
	"ETSI", "5G", "80M", "VHT", "4T", "155", "80",
	"MKK", "5G", "80M", "VHT", "4T", "155", "127"
};
#endif

void
odm_read_and_config_mp_8814b_txpwr_lmt(struct dm_struct *dm)
{
#ifdef CONFIG_8814B

	u32	i = 0;
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
	u32	array_len =
			sizeof(array_mp_8814b_txpwr_lmt) / sizeof(u8);
	u8	*array = (u8 *)array_mp_8814b_txpwr_lmt;
#else
	u32	array_len =
			sizeof(array_mp_8814b_txpwr_lmt) / sizeof(u8 *);
	u8	**array = (u8 **)array_mp_8814b_txpwr_lmt;
#endif

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrLmt, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrLmt = array_len / 7;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	for (i = 0; i < array_len; i += 7) {
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
		u8	regulation = array[i];
		u8	band = array[i + 1];
		u8	bandwidth = array[i + 2];
		u8	rate = array[i + 3];
		u8	rf_path = array[i + 4];
		u8	chnl = array[i + 5];
		u8	val = array[i + 6];
#else
		u8	*regulation = array[i];
		u8	*band = array[i + 1];
		u8	*bandwidth = array[i + 2];
		u8	*rate = array[i + 3];
		u8	*rf_path = array[i + 4];
		u8	*chnl = array[i + 5];
		u8	*val = array[i + 6];
#endif

		odm_config_bb_txpwr_lmt_8814b(dm, regulation, band, bandwidth,
					      rate, rf_path, chnl, val);
#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
		rsprintf((char *)hal_data->BufOfLinesPwrLmt[i / 7], 100, "\"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\",",
			 regulation, band, bandwidth, rate, rf_path, chnl, val);
#endif
	}

#endif
}

#endif /* end of HWIMG_SUPPORT*/

