/******************************************************************************
 *
 * Copyright(c) 2007 - 2017 Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * The full GNU General Public License is included in this distribution in the
 * file called LICENSE.
 *
 * Contact Information:
 * wlanfae <wlanfae@realtek.com>
 * Realtek Corporation, No. 2, Innovation Road II, Hsinchu Science Park,
 * Hsinchu 300, Taiwan.
 *
 * Larry Finger <Larry.Finger@lwfinger.net>
 *
 *****************************************************************************/

/*Image2HeaderVersion: R3 1.5.7*/
#include "mp_precomp.h"
#include "../phydm_precomp.h"

#if (RTL8710C_SUPPORT == 1)
static boolean
check_positive(struct dm_struct *dm,
	       const u32	condition1,
	       const u32	condition2,
	       const u32	condition3,
	       const u32	condition4
)
{
	u32	cond1 = condition1, cond2 = condition2,
		cond3 = condition3, cond4 = condition4;

	u8	cut_version_for_para =
		(dm->cut_version ==  ODM_CUT_A) ? 15 : dm->cut_version;

	u8	pkg_type_for_para =
		(dm->package_type == 0) ? 15 : dm->package_type;

	u32	driver1 = cut_version_for_para << 24 |
			(dm->support_interface & 0xF0) << 16 |
			dm->support_platform << 16 |
			pkg_type_for_para << 12 |
			(dm->support_interface & 0x0F) << 8  |
			dm->rfe_type;

	u32	driver2 = (dm->type_glna & 0xFF) <<  0 |
			(dm->type_gpa & 0xFF)  <<  8 |
			(dm->type_alna & 0xFF) << 16 |
			(dm->type_apa & 0xFF)  << 24;

	u32	driver3 = 0;

	u32	driver4 = (dm->type_glna & 0xFF00) >>  8 |
			(dm->type_gpa & 0xFF00) |
			(dm->type_alna & 0xFF00) << 8 |
			(dm->type_apa & 0xFF00)  << 16;

	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "===> %s (cond1, cond2, cond3, cond4) = (0x%X 0x%X 0x%X 0x%X)\n",
		  __func__, cond1, cond2, cond3, cond4);
	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "===> %s (driver1, driver2, driver3, driver4) = (0x%X 0x%X 0x%X 0x%X)\n",
		  __func__, driver1, driver2, driver3, driver4);

	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "	(Platform, Interface) = (0x%X, 0x%X)\n",
		  dm->support_platform, dm->support_interface);
	PHYDM_DBG(dm, ODM_COMP_INIT, "	(RFE, Package) = (0x%X, 0x%X)\n",
		  dm->rfe_type, dm->package_type);

	/*============== value Defined Check ===============*/
	/*cut version [27:24] need to do value check*/
	if (((cond1 & 0x0F000000) != 0) &&
	    ((cond1 & 0x0F000000) != (driver1 & 0x0F000000)))
		return false;

	/*pkg type [15:12] need to do value check*/
	if (((cond1 & 0x0000F000) != 0) &&
	    ((cond1 & 0x0000F000) != (driver1 & 0x0000F000)))
		return false;

	/*interface [11:8] need to do value check*/
	if (((cond1 & 0x00000F00) != 0) &&
	    ((cond1 & 0x00000F00) != (driver1 & 0x00000F00)))
		return false;
	/*=============== Bit Defined Check ================*/
	/* We don't care [31:28] */

	cond1 &= 0x000000FF;
	driver1 &= 0x000000FF;

	if (cond1 == driver1)
		return true;
	else
		return false;
}


/******************************************************************************
 *                           agc_tab.TXT
 ******************************************************************************/

const u32 array_mp_8710c_agc_tab[] = {
	0x8f000000,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0xFF000001,
		0xC78, 0xFF010001,
		0xC78, 0xFF020001,
		0xC78, 0xFE030001,
		0xC78, 0xFD040001,
		0xC78, 0xFC050001,
		0xC78, 0xFB060001,
		0xC78, 0xFA070001,
		0xC78, 0xF9080001,
		0xC78, 0xF8090001,
		0xC78, 0xF70A0001,
		0xC78, 0xF60B0001,
		0xC78, 0xF50C0001,
		0xC78, 0xF40D0001,
		0xC78, 0xF30E0001,
		0xC78, 0xF20F0001,
		0xC78, 0xF1100001,
		0xC78, 0xF0110001,
		0xC78, 0xEF120001,
		0xC78, 0xEE130001,
		0xC78, 0xED140001,
		0xC78, 0xEC150001,
		0xC78, 0xEB160001,
		0xC78, 0xEA170001,
		0xC78, 0xE9180001,
		0xC78, 0xE8190001,
		0xC78, 0xE71A0001,
		0xC78, 0xE61B0001,
		0xC78, 0xC91C0001,
		0xC78, 0xC81D0001,
		0xC78, 0xC71E0001,
		0xC78, 0xC61F0001,
		0xC78, 0xC5200001,
		0xC78, 0x8B210001,
		0xC78, 0x8A220001,
		0xC78, 0x89230001,
		0xC78, 0x88240001,
		0xC78, 0x87250001,
		0xC78, 0x86260001,
		0xC78, 0x85270001,
		0xC78, 0x84280001,
		0xC78, 0x83290001,
		0xC78, 0x822A0001,
		0xC78, 0x482B0001,
		0xC78, 0x472C0001,
		0xC78, 0x462D0001,
		0xC78, 0x452E0001,
		0xC78, 0x272F0001,
		0xC78, 0x26300001,
		0xC78, 0x25310001,
		0xC78, 0x24320001,
		0xC78, 0x07330001,
		0xC78, 0x06340001,
		0xC78, 0x05350001,
		0xC78, 0x04360001,
		0xC78, 0x03370001,
		0xC78, 0x02380001,
		0xC78, 0x02390001,
		0xC78, 0x023A0001,
		0xC78, 0x023B0001,
		0xC78, 0x023C0001,
		0xC78, 0x023D0001,
		0xC78, 0x023E0001,
		0xC78, 0x023F0001,
	0xA0000000,	0x00000000,
		0xC78, 0xFF000001,
		0xC78, 0xFF010001,
		0xC78, 0xFF020001,
		0xC78, 0xFE030001,
		0xC78, 0xFD040001,
		0xC78, 0xFC050001,
		0xC78, 0xFB060001,
		0xC78, 0xFA070001,
		0xC78, 0xF9080001,
		0xC78, 0xF8090001,
		0xC78, 0xF70A0001,
		0xC78, 0xF60B0001,
		0xC78, 0xF50C0001,
		0xC78, 0xF40D0001,
		0xC78, 0xF30E0001,
		0xC78, 0xF20F0001,
		0xC78, 0xF1100001,
		0xC78, 0xF0110001,
		0xC78, 0xEF120001,
		0xC78, 0xEE130001,
		0xC78, 0xED140001,
		0xC78, 0xEC150001,
		0xC78, 0xEB160001,
		0xC78, 0xEA170001,
		0xC78, 0xE9180001,
		0xC78, 0xE8190001,
		0xC78, 0xE71A0001,
		0xC78, 0xE61B0001,
		0xC78, 0xC91C0001,
		0xC78, 0xC81D0001,
		0xC78, 0xC71E0001,
		0xC78, 0xC61F0001,
		0xC78, 0xC5200001,
		0xC78, 0xC4210001,
		0xC78, 0xC3220001,
		0xC78, 0xC2230001,
		0xC78, 0xC1240001,
		0xC78, 0x86250001,
		0xC78, 0x85260001,
		0xC78, 0x84270001,
		0xC78, 0x83280001,
		0xC78, 0x82290001,
		0xC78, 0x2B2A0001,
		0xC78, 0x2A2B0001,
		0xC78, 0x292C0001,
		0xC78, 0x282D0001,
		0xC78, 0x272E0001,
		0xC78, 0x262F0001,
		0xC78, 0x25300001,
		0xC78, 0x24310001,
		0xC78, 0x23320001,
		0xC78, 0x06330001,
		0xC78, 0x05340001,
		0xC78, 0x04350001,
		0xC78, 0x03360001,
		0xC78, 0x02370001,
		0xC78, 0x02380001,
		0xC78, 0x02390001,
		0xC78, 0x023A0001,
		0xC78, 0x023B0001,
		0xC78, 0x023C0001,
		0xC78, 0x023D0001,
		0xC78, 0x023E0001,
		0xC78, 0x023F0001,
	0xB0000000,	0x00000000,
	0x8f000000,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0xFF004001,
		0xC78, 0xFF014001,
		0xC78, 0xFF024001,
		0xC78, 0xFE034001,
		0xC78, 0xFD044001,
		0xC78, 0xFC054001,
		0xC78, 0xFB064001,
		0xC78, 0xFA074001,
		0xC78, 0xF9084001,
		0xC78, 0xF8094001,
		0xC78, 0xF70A4001,
		0xC78, 0xF60B4001,
		0xC78, 0xF50C4001,
		0xC78, 0xF40D4001,
		0xC78, 0xF30E4001,
		0xC78, 0xBA0F4001,
		0xC78, 0xB9104001,
		0xC78, 0xB8114001,
		0xC78, 0xB7124001,
		0xC78, 0xB6134001,
		0xC78, 0x98144001,
		0xC78, 0x97154001,
		0xC78, 0x96164001,
		0xC78, 0x95174001,
		0xC78, 0x94184001,
		0xC78, 0x93194001,
		0xC78, 0x921A4001,
		0xC78, 0x911B4001,
		0xC78, 0x901C4001,
		0xC78, 0x8F1D4001,
		0xC78, 0x8E1E4001,
		0xC78, 0x8D1F4001,
		0xC78, 0x8C204001,
		0xC78, 0x8B214001,
		0xC78, 0x8A224001,
		0xC78, 0x89234001,
		0xC78, 0x88244001,
		0xC78, 0x87254001,
		0xC78, 0x86264001,
		0xC78, 0x85274001,
		0xC78, 0x84284001,
		0xC78, 0x83294001,
		0xC78, 0x822A4001,
		0xC78, 0x482B4001,
		0xC78, 0x472C4001,
		0xC78, 0x462D4001,
		0xC78, 0x452E4001,
		0xC78, 0x272F4001,
		0xC78, 0x26304001,
		0xC78, 0x25314001,
		0xC78, 0x24324001,
		0xC78, 0x07334001,
		0xC78, 0x06344001,
		0xC78, 0x05354001,
		0xC78, 0x04364001,
		0xC78, 0x03374001,
		0xC78, 0x02384001,
		0xC78, 0x02394001,
		0xC78, 0x023A4001,
		0xC78, 0x023B4001,
		0xC78, 0x023C4001,
		0xC78, 0x023D4001,
		0xC78, 0x023E4001,
		0xC78, 0x023F4001,
		0xC50, 0x69553422,
		0xC50, 0x69553420,
	0xA0000000,	0x00000000,
		0xC78, 0xFF004001,
		0xC78, 0xFF014001,
		0xC78, 0xFF024001,
		0xC78, 0xFE034001,
		0xC78, 0xFD044001,
		0xC78, 0xFC054001,
		0xC78, 0xFB064001,
		0xC78, 0xFA074001,
		0xC78, 0xF9084001,
		0xC78, 0xF8094001,
		0xC78, 0xF70A4001,
		0xC78, 0xF60B4001,
		0xC78, 0xF50C4001,
		0xC78, 0xF40D4001,
		0xC78, 0xF30E4001,
		0xC78, 0xBA0F4001,
		0xC78, 0xB9104001,
		0xC78, 0xB8114001,
		0xC78, 0xB7124001,
		0xC78, 0xB6134001,
		0xC78, 0x98144001,
		0xC78, 0x97154001,
		0xC78, 0x96164001,
		0xC78, 0x95174001,
		0xC78, 0x94184001,
		0xC78, 0x93194001,
		0xC78, 0x921A4001,
		0xC78, 0x911B4001,
		0xC78, 0x901C4001,
		0xC78, 0x8F1D4001,
		0xC78, 0x8E1E4001,
		0xC78, 0x8D1F4001,
		0xC78, 0x8C204001,
		0xC78, 0xC4214001,
		0xC78, 0xC3224001,
		0xC78, 0xC2234001,
		0xC78, 0xC1244001,
		0xC78, 0x86254001,
		0xC78, 0x85264001,
		0xC78, 0x84274001,
		0xC78, 0x83284001,
		0xC78, 0x82294001,
		0xC78, 0x2B2A4001,
		0xC78, 0x2A2B4001,
		0xC78, 0x292C4001,
		0xC78, 0x282D4001,
		0xC78, 0x272E4001,
		0xC78, 0x262F4001,
		0xC78, 0x25304001,
		0xC78, 0x24314001,
		0xC78, 0x23324001,
		0xC78, 0x06334001,
		0xC78, 0x05344001,
		0xC78, 0x04354001,
		0xC78, 0x03364001,
		0xC78, 0x02374001,
		0xC78, 0x02384001,
		0xC78, 0x02394001,
		0xC78, 0x023A4001,
		0xC78, 0x023B4001,
		0xC78, 0x023C4001,
		0xC78, 0x023D4001,
		0xC78, 0x023E4001,
		0xC78, 0x023F4001,
		0xC50, 0x69553422,
		0xC50, 0x69553420,
	0xB0000000,	0x00000000,

};

void
odm_read_and_config_mp_8710c_agc_tab(struct dm_struct *dm)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len =
			sizeof(array_mp_8710c_agc_tab) / sizeof(u32);
	u32	*array = (u32 *)array_mp_8710c_agc_tab;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;
	u32	a1 = 0, a2 = 0, a3 = 0, a4 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  =
					(u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT,
						  "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (!is_skipped) {
					a1 = pre_v1; a2 = pre_v2;
					a3 = v1; a4 = v2;
					if (check_positive(dm,
							   a1, a2, a3, a4)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else {
					is_matched = false;
				}
			}
		} else {
			if (is_matched)
				odm_config_bb_agc_8710c(dm, v1, MASKDWORD, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8710c_agc_tab(void)
{
		return 5;
}

/******************************************************************************
 *                           phy_reg.TXT
 ******************************************************************************/

const u32 array_mp_8710c_phy_reg[] = {
		0x800, 0x80044D00,
		0x804, 0x00000001,
		0x808, 0x00FCD000,
		0x80C, 0x0000000A,
		0x810, 0x10001331,
		0x814, 0x020C3910,
		0x818, 0x00240385,
		0x81C, 0x00000000,
		0x820, 0x01000100,
		0x824, 0x00390204,
		0x828, 0x00000000,
		0x82C, 0x00000000,
		0x830, 0x00000000,
		0x834, 0x00000000,
		0x838, 0x00000000,
		0x83C, 0x00000000,
		0x840, 0x00010000,
		0x844, 0x00000000,
		0x848, 0x00000000,
		0x84C, 0x00000000,
		0x850, 0x00030000,
		0x854, 0x00000000,
		0x858, 0x7E5D569A,
		0x85C, 0x569A569A,
		0x860, 0x00000130,
		0x864, 0x40000000,
		0x868, 0x00000000,
		0x86C, 0x4E4E4E00,
		0x870, 0x00050000,
		0x874, 0x25005000,
		0x878, 0x00000808,
		0x87C, 0x004F0201,
	0x8f000000,	0x00000000,	0x40000000,	0x00000000,
		0x880, 0xE2043616,
	0xA0000000,	0x00000000,
		0x880, 0xE4043616,
	0xB0000000,	0x00000000,
		0x884, 0x2E4005E0,
		0x888, 0x00000003,
		0x88C, 0xCCC400C0,
		0x890, 0x00000800,
		0x894, 0xFFFFFFFE,
		0x898, 0x40302010,
		0x89C, 0x00706050,
		0x900, 0x00000000,
		0x904, 0x00000023,
		0x908, 0x00000000,
		0x90C, 0x81121111,
		0x910, 0x00000402,
		0x914, 0x00000201,
		0x920, 0x18C6318C,
		0x924, 0x0000018C,
		0x948, 0x99000000,
		0x94C, 0x00000010,
		0x950, 0x00003000,
	0x8f000000,	0x00000000,	0x40000000,	0x00000000,
		0x954, 0x3AA80000,
	0xA0000000,	0x00000000,
		0x954, 0x3A380000,
	0xB0000000,	0x00000000,
		0x958, 0x4BC58E7A,
		0x95C, 0x04EB9B79,
		0x96C, 0x00000003,
		0x970, 0x00000000,
		0x974, 0x00000000,
		0x978, 0x00000000,
		0x97C, 0x13000000,
		0x980, 0x00000000,
		0xA00, 0x00D047C8,
		0xA04, 0xC0FF0008,
		0xA08, 0x88838300,
		0xA0C, 0x2E20100F,
		0xA10, 0x8D00BB78,
		0xA14, 0x11144028,
		0xA18, 0x00881117,
		0xA1C, 0x89140F00,
		0xA20, 0xE82C0001,
		0xA24, 0x64B80C1C,
		0xA28, 0x00158810,
		0xA2C, 0x10998000,
		0xA70, 0x00008000,
		0xA74, 0x80800100,
		0xA78, 0x000009F0,
		0xA7C, 0x225B0606,
		0xA80, 0x20807530,
		0xA84, 0x00200200,
		0xA88, 0x00000080,
		0xA8C, 0x00000000,
		0xA90, 0x00000000,
		0xA94, 0x00000000,
		0xA98, 0x00000000,
		0xA9C, 0x00560000,
		0xAA0, 0x00000000,
		0xAA4, 0x00020014,
		0xAA8, 0xBA0A0008,
		0xAAC, 0x01235667,
		0xAB0, 0x00000000,
		0xAB4, 0x00201402,
		0xAB8, 0x0000001C,
		0xABC, 0x0000F7FF,
		0xAC0, 0xD4C0A742,
		0xAC4, 0x00000000,
		0xAC8, 0x00000F09,
		0xACC, 0x00000F08,
		0xAD0, 0xA1052A10,
		0xAD4, 0x4C9DC452,
		0xAD8, 0x8A024024,
		0xADC, 0x00224001,
		0xAE0, 0x17000391,
		0xAE8, 0x00000805,
		0xB2C, 0x00000000,
		0xC00, 0x48071D40,
		0xC04, 0x03A05611,
		0xC08, 0x000000E4,
		0xC0C, 0x6C6C6C6C,
		0xC10, 0x30800000,
		0xC14, 0x40000100,
		0xC18, 0x08800000,
		0xC1C, 0x40000100,
		0xC20, 0x00000000,
		0xC24, 0x00000000,
		0xC28, 0x00000000,
		0xC2C, 0x00000000,
	0x8f000000,	0x00000000,	0x40000000,	0x00000000,
		0xC30, 0x69E98C48,
	0xA0000000,	0x00000000,
		0xC30, 0x69E96C48,
	0xB0000000,	0x00000000,
		0xC34, 0x31000040,
		0xC38, 0x21A88080,
		0xC3C, 0x000012CC,
		0xC40, 0x1F78403F,
		0xC44, 0x00010036,
		0xC48, 0xEC020106,
		0xC4C, 0x007F037F,
		0xC50, 0x69553420,
		0xC54, 0x43BC0094,
		0xC58, 0x00001129,
		0xC5C, 0x00250492,
		0xC60, 0x00280A00,
		0xC64, 0x710C848B,
		0xC68, 0x47C034FF,
		0xC6C, 0x00000036,
		0xC70, 0x2C7F000D,
		0xC74, 0x02C600DB,
		0xC78, 0x0000001F,
		0xC7C, 0x00B91612,
		0xC80, 0x40000100,
		0xC84, 0x31F60000,
		0xC88, 0x1051B75F,
		0xC8C, 0x20200109,
		0xC90, 0x00122A42,
		0xC94, 0x00000000,
		0xC98, 0x00121820,
		0xC9C, 0x00007F7F,
		0xCA0, 0x00FD8000,
		0xCA4, 0x800000A0,
		0xCA8, 0x04E6C606,
		0xCAC, 0x21C44F60,
		0xCB0, 0x00000000,
		0xCB4, 0x00000000,
		0xCB8, 0x00000000,
		0xCBC, 0x28000000,
		0xCC0, 0x1051B75F,
		0xCC4, 0x00000109,
		0xCC8, 0x000442D6,
		0xCCC, 0x00000000,
		0xCD0, 0x000001C8,
		0xCD4, 0x001C8000,
		0xCD8, 0x00000100,
		0xCDC, 0x40100000,
		0xCE0, 0x00222220,
		0xCE4, 0x20000000,
		0xCE8, 0x37644302,
		0xCEC, 0x2F97D40C,
		0xD00, 0x04030740,
	0x8f000000,	0x00000000,	0x40000000,	0x00000000,
		0xD04, 0x40020401,
	0xA0000000,	0x00000000,
		0xD04, 0xC0020401,
	0xB0000000,	0x00000000,
		0xD08, 0x0000907F,
		0xD0C, 0x20010201,
		0xD10, 0xA0633333,
	0x8f000000,	0x00000000,	0x40000000,	0x00000000,
		0xD14, 0x3333BC53,
	0xA0000000,	0x00000000,
		0xD14, 0x3333BC77,
	0xB0000000,	0x00000000,
		0xD18, 0x7A8F5B6F,
	0x8f000000,	0x00000000,	0x40000000,	0x00000000,
		0xD2C, 0xCB979175,
	0xA0000000,	0x00000000,
		0xD2C, 0xDB979175,
	0xB0000000,	0x00000000,
		0xD30, 0x00000000,
		0xD34, 0x40608000,
		0xD38, 0xE9F5A000,
		0xD3C, 0x40127353,
		0xD40, 0x00000000,
		0xD44, 0x00000000,
		0xD48, 0x00000000,
		0xD4C, 0x00000000,
		0xD50, 0x04BC6028,
		0xD54, 0x00000000,
		0xD58, 0x00000282,
		0xD5C, 0x30032064,
		0xD60, 0x4653DE54,
		0xD64, 0x04518A3C,
		0xD68, 0x00001081,
		0xD7C, 0x00600000,
		0xD80, 0x5002EAAE,
		0xE00, 0x5A5A5A5A,
		0xE04, 0x5A5A5A5A,
		0xE08, 0x03904E5A,
		0xE10, 0x5A5A5A5A,
		0xE14, 0x5A5A5A5A,
		0xE18, 0x5A5A5A5A,
		0xE1C, 0x5A5A5A5A,
		0xE28, 0x00000000,
		0xE30, 0x1000DC1F,
		0xE34, 0x10008C1F,
		0xE38, 0x02140102,
		0xE3C, 0x681604C2,
		0xE40, 0x01007C00,
		0xE44, 0x01004800,
		0xE48, 0xFB000000,
		0xE4C, 0x000028D1,
		0xE50, 0x1000DC1F,
		0xE54, 0x10008C1F,
		0xE58, 0x02140102,
		0xE5C, 0x28160D05,
		0xE60, 0x0000C008,
		0xE68, 0x001B25A4,
		0xE64, 0x281600A0,
		0xE6C, 0x01C00010,
		0xE70, 0x01C00016,
		0xE74, 0x02000010,
		0xE78, 0x02000010,
		0xE7C, 0x02000010,
		0xE80, 0x02000010,
		0xE84, 0x01C00010,
		0xE88, 0x02000010,
		0xE8C, 0x01C00010,
		0xED0, 0x01C00010,
		0xED4, 0x01C00010,
		0xED8, 0x01C00010,
		0xEDC, 0x00000010,
		0xEE0, 0x00000010,
		0xEEC, 0x03C00010,
		0xF14, 0x00000003,
		0xF00, 0x00100300,
		0xF08, 0x0000800B,
		0xF0C, 0x0000F007,
		0xF10, 0x0000A487,
		0xF1C, 0x80000064,
		0xF38, 0x00030155,
		0xF3C, 0x0000003A,
		0xF4C, 0x13000000,
		0xF50, 0x00000000,
		0xF18, 0x00000000,

};

void
odm_read_and_config_mp_8710c_phy_reg(struct dm_struct *dm)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len =
			sizeof(array_mp_8710c_phy_reg) / sizeof(u32);
	u32	*array = (u32 *)array_mp_8710c_phy_reg;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;
	u32	a1 = 0, a2 = 0, a3 = 0, a4 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  =
					(u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT,
						  "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (!is_skipped) {
					a1 = pre_v1; a2 = pre_v2;
					a3 = v1; a4 = v2;
					if (check_positive(dm,
							   a1, a2, a3, a4)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else {
					is_matched = false;
				}
			}
		} else {
			if (is_matched)
				odm_config_bb_phy_8710c(dm, v1, MASKDWORD, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8710c_phy_reg(void)
{
		return 5;
}

/******************************************************************************
 *                           phy_reg_pg.TXT
 ******************************************************************************/

#ifdef CONFIG_8710C
_WEAK const u32 array_mp_8710c_phy_reg_pg[] = {
	0, 0, 0, 0x00000e08, 0x0000ff00, 0x00003400,
	0, 0, 0, 0x0000086c, 0xffffff00, 0x34343400,
	0, 0, 0, 0x00000e00, 0xffffffff, 0x36383838,
	0, 0, 0, 0x00000e04, 0xffffffff, 0x30323436,
	0, 0, 0, 0x00000e10, 0xffffffff, 0x32363636,
	0, 0, 0, 0x00000e14, 0xffffffff, 0x28283032
};

#endif

void
odm_read_and_config_mp_8710c_phy_reg_pg(struct dm_struct *dm)
{
#ifdef CONFIG_8710C

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8710c_phy_reg_pg) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8710c_phy_reg_pg;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8710c(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

#endif /* end of HWIMG_SUPPORT*/

