#ifndef _FAST_TUNNEL_CORE_H_
#define _FAST_TUNNEL_CORE_H_

#define ERROR_BIT (1<<0)
#define TRACE_BIT (1<<1)
#define INFO_BIT (1<<2)
#define DEBUG_BIT (1<<3)

#define FAST_TUNNEL_DEBUG 1
#ifdef FAST_TUNNEL_DEBUG
extern int tunnel_debug_level;

#define RTL_TUNNEL_FP_ERROR(fmt,args...) \
	if((tunnel_debug_level & ERROR_BIT)) \
		printk("[%s_%d]: "fmt"\n", __FUNCTION__, __LINE__, ## args);

#define RTL_TUNNEL_FP_TRACE(fmt,args...)\
	if((tunnel_debug_level & TRACE_BIT)) \
		printk("[%s_%d]: "fmt"\n", __FUNCTION__, __LINE__, ## args);

#define RTL_TUNNEL_FP_INFO(fmt,args...)\
	if((tunnel_debug_level & INFO_BIT)) \
		printk("[%s_%d]: "fmt"\n", __FUNCTION__, __LINE__, ## args);

#define RTL_TUNNEL_FP_DEBUG(fmt,args...) \
	if((tunnel_debug_level & DEBUG_BIT)) \
		printk("[%s_%d]: "fmt"\n", __FUNCTION__, __LINE__, ## args);

#else
#define RTL_TUNNEL_FP_ERROR(fmt,args...) \
	if((tunnel_debug_level & ERROR_BIT)) \
		printk("[%s_%d]: "fmt"\n", __FUNCTION__, __LINE__, ## args);
#define RTL_TUNNEL_FP_TRACE(fmt,args...)
#define RTL_TUNNEL_FP_INFO(fmt,args...)
#define RTL_TUNNEL_FP_DEBUG(fmt,args...) 
#endif

//#define RTL_FASTPATH_FRAGMENT_SUPPORT 1

#define WAN_DEV_NAME "eth1"
#define CHECK_IPV4_TCPUDP_CHECKSUM 2

enum TUNNEL_BOUND
{
	MAPE_OUT_BOUND = 0,
	MAPE_IN_BOUND = 1,
	MAPE_DPI_OUT_BOUND = 2,
	MAPE_DPI_IN_BOUND = 3,
	DSLITE_OUT_BOUND = 4,
	DSLITE_IN_BOUND = 5,
	DSLITE_DPI_OUT_BOUND = 6,
	DSLITE_DPI_IN_BOUND = 7,
};

typedef struct tunnel_cache{
	uint32 cache_cnt;
	struct list_head cache_head;
} TUNNEL_CACHE_T, *TUNNEL_CACHE_Tp;

extern TUNNEL_CACHE_T tunnelCache;

typedef struct ipv6_cache{
	struct	in6_addr src6;
	struct	in6_addr dst6;
	int protocol;
	uint32 last_used;
	struct list_head list;
} IPv6_CACHE_T, *IPv6_CACHE_Tp;

extern int tunnel_get_br0_ip_mask(u_int32_t *ip,u_int32_t *mask);

extern void tunnel_adjust_ipv4_ttl(struct iphdr *ip4h);
extern int is_tunnel46_rx_from_lan_dev(const struct sk_buff *skb);
extern int is_tunnel46_to_local_network(u32 addr, u32 lanAddr, u32 lanMask);
extern int is_tunnel64_rx_from_wan_device(struct sk_buff * skb);
extern int is_ip4_header_valid(struct iphdr *ip4h, int fastFlag);
extern int is_tcp_udp_header_valid(struct iphdr *ip4h, struct tcphdr *tcphudph, int fastFlag);
extern void set_tunnel46_ipv6_header(struct iphdr *ip4h, struct ipv6hdr *ip6h, struct in6_addr *src6_addr, struct in6_addr *dst6_addr);

extern int tunnel46_ipv6_route_input(struct sk_buff *skb);
extern int tunnel46_ipv6_mtu_check(struct sk_buff *skb, struct iphdr *ip4h, uint8 protocol);
extern void tunnel46_recover_ipv4_pkt(struct sk_buff **skb);
extern int tunnel46_ipv6_output6(struct sk_buff *skb, int (*output)(struct sk_buff *), u32 app_value, u8 type);
#ifdef RTL_FASTPATH_FRAGMENT_SUPPORT
extern int tunnel46_ipv6_fragment(struct sk_buff *skb, int (*output)(struct sk_buff *), u32 app_value, u8 type);
#endif
extern int tunnel46_finish_output6(struct sk_buff *skb);

extern void tunnel64_recover_ipv6_pkt(struct sk_buff **skb, char *tmpIPv6h,int ipv6extlen);
extern struct iphdr *ipv6_find_ipv4_hdr(struct sk_buff *skb, u32 *phlen);

extern int tunel64_ipv4_route_input(struct sk_buff  *skb, __be32 daddr, void *ct);

extern int tunnel_dpi_hook_for_app_type(struct sk_buff *pskb, u32 app_type, u8 type);

#ifdef CONFIG_RTL_FAST_MAP_E
/* For MAP-E ip_id with PSID */
typedef struct map_e_fp_portset {
	struct list_head list;
	uint32_t id;		
	uint16_t port_min;	
	uint16_t port_max;	
} map_e_fp_portset_list;

struct map_e_fp_info {
	map_e_fp_portset_list portset_list;	/* portset list */
	uint16_t portset_num;		/* the total num of port set */
	uint16_t portset_id;		/* 0x34 */

	uint16_t current_portset_id;	/* the last ip->id used in portset */
	uint16_t current_portset_index; /* ip_id belongs to a portset, the index it located at of portset_num */
};
extern struct map_e_fp_info map_e_fastpath_info;
extern int fast_map_e_fw;
extern unsigned int statistic_map_e_fp;
extern unsigned int statistic_map_e_fp_ul_fail;
extern unsigned int statistic_map_e_fp_dl_fail;

extern char map_e_tunnel_name[IFNAMSIZ];

extern int __init map_e_fast_forward_init(void);
extern void __exit map_e_fast_forward_exit(void);

extern int map_e_fast_enter(struct sk_buff *pskb);
#endif //#ifdef CONFIG_RTL_FAST_MAP_E

#ifdef CONFIG_RTL_FAST_DSLITE
extern int fast_dslite_fw;
extern unsigned int statistic_dslite_fp;
extern int init_dslite_info;
extern char dslite_tunnel_name[IFNAMSIZ];

extern int __init dslite_fast_forward_init(void);
extern void __exit dslite_fast_forward_exit(void);

extern int dslite_fast_enter(struct sk_buff *pskb);
#endif //#ifdef CONFIG_RTL_FAST_DSLITE

#endif
