
//#include <linux/config.h>
#include <sys/sysinfo.h>/* WNC-NMR0000-JOE-PENG-20140114-Fix bug "After device time was set by Access-timer Page, web server of DUT will return 403 error when browser submits form in Access-timer Page" */
#include <stdio.h>
#include <string.h> //davidhsu
#include <stdarg.h>
#include "boa.h"
#include "libwnc.h"/* WNC-NMR0000-JOE-PENG-20140127-Mv API for detecting WPS or RakuRaku is running to WNC library (libwnc.so) */

/* NMR1351-20160217-Fix bug 1351 [Linear/Alvia] Can't Firmware Version UP to use Some PC to use Browser */
int upload_file_size_too_big=0;

#ifdef SUPPORT_ASP

#include "asp_page.h"
#include "apmib.h"
#include "apform.h"
#include "utility.h"/* WNC-NMR0528-JOE-PENG-20140115-Fix bug 528 "During RakuRaku or WPS, Can upgrade firmware" in Voyager */
/* NMR1223-20151203-Patch NEC solution to fix bug 1223 [Linear][Alvia] CSRF vulnerability was found */
#include "sessionid.h"

extern void create_chklist_file(int type);
extern int isPackExist;
temp_mem_t root_temp;
char *query_temp_var=NULL; 
char str_boundry[MAX_BOUNDRY_LEN]; //used to store boundry


char *WAN_IF;
char *BRIDGE_IF;
char *ELAN_IF;
char *ELAN2_IF;
char *ELAN3_IF;
char *ELAN4_IF;
char *PPPOE_IF;
char WLAN_IF[20];
int wlan_num;
#ifdef MBSSID
int vwlan_num=0;
int mssid_idx=0;
#endif
int last_wantype=-1;

/* WNC-MR0000-Heng-I-Chen-20120503-Internet Reachability Check uses saved netbiosname */
extern char nbname[17];
/* WNC-MR0000-Heng-I-Chen-20120503-End */

extern int accesstimer_guardmsg;


//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
asp_name_t root_asp[] = {
	{"getInfo", getInfo},
	{"getIndex", getIndex},
#if defined(CONFIG_RTL_P2P_SUPPORT)
	{"getWifiP2PState", getWifiP2PState},
	{"wlP2PScanTbl", wlP2PScanTbl},
#endif
	{"wirelessClientList", wirelessClientList},
	{"wlSiteSurveyTbl", wlSiteSurveyTbl},
#if 1	/* WNC-MR0000-Libera-Jan-20121101- new spec. - Repeater mode */
	{"wlSiteSurveyWncTbl", wlSiteSurveyWncTbl},
#endif

	{"wlWdsList", wlWdsList},
#if defined(WLAN_PROFILE)	
	{"wlProfileList", wlProfileList},
	{"wlProfileTblList", wlProfileTblList},
#endif //#if defined(WLAN_PROFILE)	
	{"wdsList", wdsList},
#ifdef MBSSID
	{"getVirtualIndex", getVirtualIndex},
	{"getVirtualInfo", getVirtualInfo},
#endif
#if defined(NEW_SCHEDULE_SUPPORT)
	{"wlSchList", wlSchList},
#endif
	{"getScheduleInfo", getScheduleInfo},
	{"wlAcList", wlAcList},
	//modify by nctu
	{"getModeCombobox", getModeCombobox},
	{"getDHCPModeCombobox", getDHCPModeCombobox},
#ifdef CONFIG_RTK_MESH
#ifdef 	_11s_TEST_MODE_
	{"wlRxStatics", wlRxStatics},
#endif
#ifdef _MESH_ACL_ENABLE_
	{"wlMeshAcList", wlMeshAcList},
#endif
	{"wlMeshNeighborTable", wlMeshNeighborTable},
	{"wlMeshRoutingTable", wlMeshRoutingTable},
	{"wlMeshProxyTable", wlMeshProxyTable},
	{"wlMeshRootInfo", wlMeshRootInfo},
	{"wlMeshPortalTable", wlMeshPortalTable},
#endif
#ifdef TLS_CLIENT	
	{"certRootList", certRootList},	
	{"certUserList", certUserList},
#endif
	{"dhcpClientList", dhcpClientList},
	{"dhcpRsvdIp_List", dhcpRsvdIp_List},
#if defined(POWER_CONSUMPTION_SUPPORT)
	{"getPowerConsumption", getPowerConsumption},
#endif
#if defined(VLAN_CONFIG_SUPPORTED)
	{"getVlanList", getVlanList},
#endif
#ifdef HOME_GATEWAY
#if 0  //sc_yang
	{"showWanPage", showWanPage},
#endif
	{"portFwList", portFwList},
	{"ipFilterList", ipFilterList},
	{"portFilterList", portFilterList},
	{"macFilterList", macFilterList},
	{"urlFilterList", urlFilterList},
	//{"triggerPortList", triggerPortList},
#ifdef ROUTE_SUPPORT
	{"staticRouteList", staticRouteList},
	{"kernelRouteList", kernelRouteList},
#ifdef RIP6_SUPPORT
	{"kernelRoute6List", kernelRoute6List},
#endif
#endif
#if defined(GW_QOS_ENGINE)
	{"qosList", qosList},
#elif defined(QOS_BY_BANDWIDTH)	
	{"ipQosList", ipQosList},
	{"l7QosList", l7QosList},
#endif
#ifdef CONFIG_IPV6
	{"getIPv6Info", getIPv6Info},
	{"getIPv6WanInfo", getIPv6WanInfo},
	{"getIPv6Status", getIPv6Status},
	{"getIPv6BasicInfo", getIPv6BasicInfo},	
#endif
#if defined(WLAN_PROFILE)
	{"getWlProfileInfo", getWlProfileInfo},
#endif
#endif //HOME_GATEWAY
	{"sysLogList", sysLogList},
	{"sysCmdLog", sysCmdLog},
#ifdef CONFIG_APP_TR069
	{"TR069ConPageShow", TR069ConPageShow},
#endif
#ifdef HTTP_FILE_SERVER_SUPPORTED
	{"dump_directory_index", dump_directory_index},
	{"Check_directory_status", Check_directory_status},
	{"Upload_st", Upload_st},
#ifdef HTTP_FILE_SERVER_HTM_UI
	{"dump_httpFileDir_init",dump_httpFileDir_init},
	{"dump_ListHead",dump_ListHead},
	{"dumpDirectList",dumpDirectList},
	{"dump_uploadDiv",dump_uploadDiv},
#endif
#endif
#ifdef VOIP_SUPPORT
	{"voip_general_get", asp_voip_GeneralGet},
	{"voip_dialplan_get", asp_voip_DialPlanGet},
	{"voip_tone_get", asp_voip_ToneGet},
	{"voip_ring_get", asp_voip_RingGet},
	{"voip_other_get", asp_voip_OtherGet},
	{"voip_config_get", asp_voip_ConfigGet},
	{"voip_fwupdate_get", asp_voip_FwupdateGet},
	{"voip_net_get", asp_voip_NetGet},
#ifdef CONFIG_RTK_VOIP_SIP_TLS
	{"voip_TLSGetCertInfo", asp_voip_TLSGetCertInfo},
#endif
#endif
#ifdef SAMBA_WEB_SUPPORT
	{"DiskList",DiskList},
	{"Storage_DispalyUser",Storage_DispalyUser},
	{"Storage_DispalyGroup",Storage_DispalyGroup},
	{"Storage_GetGroupMember",Storage_GetGroupMember},
	//{"Storage_CreateFolder",Storage_CreateFolder},
	{"FolderList",FolderList},
	{"ShareFolderList",ShareFolderList},
	{"Storage_GeDirRoot",Storage_GeDirRoot},
	{"UserEditName",UserEditName},
	{"GroupEditName",GroupEditName},
#endif
#if defined(CONFIG_RTL_ETH_802DOT1X_SUPPORT)
	{"getEthDot1xList", getEthDot1xList},
#endif
	{"get_InternetChk", asp_get_InternetChk},
/* WNC-MR0000-Heng-I-Chen-20120509-Get Maintain Version Up Setting */
	{"get_maintevup", asp_get_maintevup},
/* WNC-MR0000-Heng-I-Chen-20120509-End */
	{"check_emergency", asp_check_emergency}, /* WNC-MR0000-Rita-20121017-check that if EMERGENCY_BANK_CHECK is larger than FW_VERSION */
	{"ntp_update", asp_ntp_update}, /* WNC-MR0000-Rita-20121012-GUI Spec 1.9 */
	{"updateWlanIdx", updateWlanIdx}, /* WNC-NMR0000-Rita-20130122-Update wlan_idx */
	{"radarDetected", asp_radarDetected},/* WNC-NMR0000-V1.5.0_Sonic_SpecChangeRequest_4.15.2-To check whether radar is detected */
// WNC-NMR0000-JDR230-HENG-I-CHEN-20130802-Add function to handle single profile
#ifdef WLAN_PROFILE
	{"getSelectProfile", getSelectProfile},
#endif
#ifdef CONFIG_APP_ACCESSTIMER
// WNC-NMR0000-JDR230-HENG-I-CHEN-20130802-End
// WNC-NMR0000-JDR230-HENG-I-CHEN-2014-01-05: Implement Access Timer feature #BEGIN
	{"getAccesstimer", getAccesstimer},
// WNC-NMR0000-JDR230-HENG-I-CHEN-2014-01-05: Implement Access Timer feature #END
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-01-12: Implement Access Timer feature #BEGIN
	{"getAccesstimerSta", getAccesstimerSta},
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-01-12: Implement Access Timer feature #END
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-01-27: Implement Access Timer feature #BEGIN
	{"getAccesstimerSchedule", getAccesstimerSchedule},
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-01-27: Implement Access Timer feature #END
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-02-06: Implement Access Timer feature #BEGIN
	{"getAccesstimerTemporary", getAccesstimerTemporary},
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-02-06: Implement Access Timer feature #END
#endif	//#ifdef CONFIG_APP_ACCESSTIMER
	/* NMR1223-20151203-Patch NEC solution to fix bug 1223 [Linear][Alvia] CSRF vulnerability was found */
	{"embed_SessionId",embed_SessionId},
	{NULL, NULL}
};

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
form_name_t root_form[] = {
	{"formWlanSetup", formWlanSetup},
	{"formWlanRedirect", formWlanRedirect},
#if 0
	{"formWep64", formWep64},
	{"formWep128", formWep128},
#endif
	{"formWep", formWep},
#ifdef MBSSID
	{"formWlanMultipleAP", formWlanMultipleAP},
#endif
#ifdef CONFIG_RTK_MESH
	{"formMeshSetup", formMeshSetup},
	{"formMeshProxy", formMeshProxy},
	//{"formMeshProxyTbl", formMeshProxyTbl},
	{"formMeshStatus", formMeshStatus},
#ifdef 	_11s_TEST_MODE_
	{"asdfgh", formEngineeringMode},
	{"zxcvbnm", formEngineeringMode2},
#endif
#ifdef _MESH_ACL_ENABLE_
	{"formMeshACLSetup", formMeshACLSetup},
#endif
#endif
	{"formTcpipSetup", formTcpipSetup},
	{"formPasswordSetup", formPasswordSetup},
	{"formLogout", formLogout},
	{"formUpload", formUpload},
	{"formUploadToEbank", formUploadToEbank}, /* WNC-MR0000-Rita-20121120-upgrade firmware to Ebank */
#if defined(CONFIG_USBDISK_UPDATE_IMAGE)
	{"formUploadFromUsb", formUploadFromUsb},
#endif
#ifdef CONFIG_RTL_WAPI_SUPPORT
	{"formWapiReKey", formWapiReKey},
	{"formUploadWapiCert", formUploadWapiCert},
	{"formUploadWapiCertAS0", formUploadWapiCertAS0},
	{"formUploadWapiCertAS1", formUploadWapiCertAS1},
	{"formWapiCertManagement", formWapiCertManagement},
	{"formWapiCertDistribute", formWapiCertDistribute},
#endif
#ifdef CONFIG_RTL_802_1X_CLIENT_SUPPORT
	{"formUpload8021xUserCert", formUpload8021xUserCert},
#endif
#ifdef CONFIG_RTL_ETH_802DOT1X_CLIENT_MODE_SUPPORT
	{"formUploadEth8021xUserCert",formUploadEth8021xUserCert},
#endif
#if defined(CONFIG_RTL_ETH_802DOT1X_SUPPORT)
	{"formEthDot1x", formEthDot1x},
#endif
#ifdef TLS_CLIENT	
	{"formCertUpload", formCertUpload},
#endif
	{"formWlAc", formWlAc},
	{"formWncWlAc", formWncWlAc},	/* WNC-NMR015-Libera-20120417- handle rootAP and vap1 MAC Access Controll */
	{"formAdvanceSetup", formAdvanceSetup},
	{"formReflashClientTbl", formReflashClientTbl},
	{"formWlEncrypt", formWlEncrypt},
	{"formStaticDHCP", formStaticDHCP},
#if defined(CONFIG_RTL_92D_SUPPORT) || defined(CONFIG_RTL_8881A_SELECTIVE)
        {"formWlanBand2G5G", formWlanBand2G5G},
#endif

#if defined(VLAN_CONFIG_SUPPORTED)
	{"formVlan", formVlan},
#endif
#ifdef HOME_GATEWAY
#if defined(CONFIG_RTK_VLAN_WAN_TAG_SUPPORT)
	{"formVlanWAN", formVlanWAN},
#endif
	{"formWanTcpipSetup", formWanTcpipSetup},
#ifdef ROUTE_SUPPORT
	{"formRoute", formRoute},
#endif
	{"formPortFw", formPortFw},
	{"formFilter", formFilter},
	//{"formTriggerPort", formTriggerPort},
	{"formDMZ", formDMZ},
	{"formDdns", formDdns},
	{"formOpMode", formOpMode},
#if defined(CONFIG_RTL_ULINKER)
	{"formUlkOpMode", formUlkOpMode},
#endif	
#if defined(CONFIG_RTL_FLASH_DUAL_IMAGE_ENABLE)	
	{"formDualFirmware", formDualFirmware},
#endif
#if defined(GW_QOS_ENGINE)
	{"formQoS", formQoS},
#elif defined(QOS_BY_BANDWIDTH)	
	{"formIpQoS", formIpQoS},
#endif
#ifdef CONFIG_RTL_BT_CLIENT
	{"formBTBasicSetting",formBTBasicSetting},
	{"formBTClientSetting",formBTClientSetting},
	{"formBTFileSetting",formBTFileSetting},
	{"formBTNewTorrent",formBTNewTorrent},
#endif
#ifdef DOS_SUPPORT
	{"formDosCfg", formDosCfg},
#endif
#ifdef CONFIG_IPV6
	{"formRadvd", formRadvd},
	{"formDnsv6", formDnsv6},
	{"formDhcpv6s", formDhcpv6s},
	{"formIPv6Addr", formIPv6Addr},
	{"formIpv6Setup", formIpv6Setup},
	{"formTunnel6", formTunnel6},	
#endif
#else
	{"formSetTime", formSetTime},
#endif //HOME_GATEWAY
	// by sc_yang
	{"formNtp", formNtp},
	{"formTimeUpdate", formTimeUpdate}, /*WNC-MR0000-Rita-20121106-ntp update*/
	{"formSetDeviceTime", formSetDeviceTime}, /* WNC-NMR0000-JOE-PENG-20131218-Implement section 5.23.3.1.3 (Set device time automatically by Web server) */
	{"formAdvSettings", formAdvSettings}, /* WNC-NMR822849-JOE-PENG-20141124-Create hidden page adv_settings.htm for NEC to enable or disable IGMP and MLD snooping */
	{"formWizard", formWizard},
	{"formPocketWizard", formPocketWizard},
	{"formWncWlan", formWncWlan},	/* WNC-MR0000-Libera-20120308- wlan page with multi-form for Cheeper */
	{"formWncWlanBasic", formWncWlanBasic},	/* WNC-NMR0000-Rita-20130122-V1.0.0_Sonic_SpecChangeRequest_3.4.5-Wlan Basic Setting */
#ifdef REBOOT_CHECK	
	{"formRebootCheck", formRebootCheck},
#if defined(WLAN_PROFILE)	
	{"formSiteSurveyProfile", formSiteSurveyProfile},	
#endif //#if defined(WLAN_PROFILE)		
#endif	
	/* WNC-NMR2293-JOE-PENG-20170216-Comment formSysCmd related codes-start */
	//{"formSysCmd", formSysCmd},
	/* WNC-NMR2293-JOE-PENG-20170216-Comment formSysCmd related codes-end */
	{"formSysLog", formSysLog},
#ifdef CONFIG_APP_SMTP_CLIENT
	{"formSmtpClient", formSmtpClient},
#endif
#if defined(CONFIG_SNMP)
	{"formSetSNMP", formSetSNMP},
#endif
	{"formSaveConfig", formSaveConfig},
	{"formUploadConfig", formUploadConfig},
	{"formReboot", formReboot},/* WNC-MR0000-JOE-PENG-20120405-Implement reboot page */
	{"formSchedule", formSchedule},
#if defined(NEW_SCHEDULE_SUPPORT)	
	{"formNewSchedule", formNewSchedule},	
#endif 
#if defined(CONFIG_RTL_P2P_SUPPORT)
	{"formWiFiDirect", formWiFiDirect},
	{"formWlP2PScan", formWlP2PScan},
#endif
	{"formWirelessTbl", formWirelessTbl},
	{"formStats", formStats},
	{"formWlSiteSurvey", formWlSiteSurvey},
#if 1	/* WNC-MR0000-Libera-Jan-20121101- new spec. - Repeater mode */	    
	{"formWlWncSiteSurvey", formWlWncSiteSurvey},	/* WNC-MR0000-Libera-Jan-20121101- new spec. - Repeater mode */
	{"formWlWncSiteSurveyReboot", formWlWncSiteSurveyReboot},	/* WNC-NMR0000-JOE-PENG-20140606-Correct messages of converter mode site survey page according to section 4.4.36 of Linear Spec. V1.1.0 */
	{"formWlWncWlan", formWlWncWlan},  /* WNC-MR0000-Rita-20121207- new spec. - Repeater mode *//* WNC-MR0000-[Voyager]-Libera-20131210- repeater mode */
#endif
	{"formWlWds", formWlWds},
	{"formWdsEncrypt", formWdsEncrypt},
#ifdef WLAN_EASY_CONFIG
	{"formAutoCfg", formAutoCfg},
#endif
#ifdef WIFI_SIMPLE_CONFIG
	{"formWsc", formWsc},
#endif
#ifdef LOGIN_URL
	{"formLogin", formLogin},
#endif
#ifdef CONFIG_APP_TR069
	{"formTR069Config", formTR069Config},
#ifdef _CWMP_WITH_SSL_

	{"formTR069CPECert", formTR069CPECert},
	{"formTR069CACert", formTR069CACert},
#endif
#endif
#ifdef HTTP_FILE_SERVER_SUPPORTED
	{"formusbdisk_uploadfile", formusbdisk_uploadfile},
#endif
#ifdef VOIP_SUPPORT
	{"voip_general_set", asp_voip_GeneralSet},
	{"voip_dialplan_set", asp_voip_DialPlanSet},
	{"voip_tone_set", asp_voip_ToneSet},
	{"voip_ring_set", asp_voip_RingSet},
	{"voip_other_set", asp_voip_OtherSet},
	{"voip_config_set", asp_voip_ConfigSet},
	{"voip_fw_set", asp_voip_FwSet},
	{"voip_net_set", asp_voip_NetSet},
#ifdef CONFIG_RTK_VOIP_IVR
	{"voip_ivrreq_set", asp_voip_IvrReqSet},
#endif
#ifdef CONFIG_RTK_VOIP_SIP_TLS
	{voip_TLSCertUpload, asp_voip_TLSCertUpload},
#endif
#endif

#ifdef SAMBA_WEB_SUPPORT
	{"formDiskCfg",formDiskCfg},
	
	{"formDiskManagementAnon",formDiskManagementAnon},
	{"formDiskManagementUser",formDiskManagementUser},
	{"formDiskManagementGroup",formDiskManagementGroup},
	
	{"formDiskCreateUser",formDiskCreateUser},
	{"formDiskCreateGroup",formDiskCreateGroup},
	{"formDiskEditUser",formDiskEditUser},
	{"formDiskEditGroup",formDiskEditGroup},

	{"formDiskCreateShare",formDiskCreateShare},
	{"formDiskCreateFolder",formDiskCreateFolder},
#endif

#ifdef CONFIG_CPU_UTILIZATION
	{"formCpuUtilization",formCpuUtilization},
#endif
/* WNC-MRXXXX-Heng-I-Chen-20120503-Add Online Version Up function */
	{"formOnlineVersionUp", formOnlineVersionUp},
/* WNC-MRXXXX-Heng-I-Chen-20120503-End */
/* WNC-MRXXXX-Heng-I-Chen-20120508-Add Maintain Version Up Setting */
	{"formMaintainVersionUp", formMaintainVersionUp},
/* WNC-MRXXXX-Heng-I-Chen-20120508-End */
#ifdef WLAN_PROFILE
// WNC-NMR0000-JDR230-HENG-I-CHEN-20130802-Add function to handle single profile
	{"formWlanSelectProfile", formWlanSelectProfile},
	{"formWlanDeleteProfile", formWlanDeleteProfile},
	{"formWlanEditProfile", formWlanEditProfile},
// WNC-NMR0000-JDR230-HENG-I-CHEN-20130802-End
	{"formWlanSetProfile", formWlanSetProfile},
#endif
#ifdef CONFIG_APP_ACCESSTIMER
// WNC-NMR0000-JDR230-HENG-I-CHEN-2014-01-05: Implement Access Timer feature #BEGIN
	{"formAccesstimerSet", formAccesstimerSet},
// WNC-NMR0000-JDR230-HENG-I-CHEN-2014-01-05: Implement Access Timer feature #END		
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-01-12: Implement Access Timer feature #BEGIN
	{"formAccesstimerStaSet", formAccesstimerStaSet},
	{"formAccesstimerStaReg", formAccesstimerStaReg},
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-01-12: Implement Access Timer feature #END
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-01-27: Implement Access Timer feature #BEGIN
	{"formAccessstimerSchedulerSet", formAccessstimerSchedulerSet},
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-01-27: Implement Access Timer feature #END
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-02-06: Implement Access Timer feature #BEGIN
	{"formAccessstimerTemporarySet", formAccessstimerTemporarySet},
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-02-06: Implement Access Timer feature #END
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-03-04: Implement Access Timer feature #BEGIN
	{"formAccesstimerStaSetCategory", formAccesstimerStaSetCategory},
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-03-04: Implement Access Timer feature #END
	{"formAccesstimerGoto", formAccesstimerGoto},
#endif	//#ifdef CONFIG_APP_ACCESSTIMER
	{NULL, NULL}
};

/* WNC-NMR0035-JOE-PENG-20120618-Patch Realtek's CSRF prevention solution */
#ifdef CSRF_SECURITY_PATCH
#include <time.h>

#define EXPIRE_TIME					900	// in sec

/* WNC-NMR0604-JOE-PENG-20140304-modify CSRF mechanism for bug 604, 606 and 607-start */
/* Change macro MAX_TBL_SIZE (Maximum number of CSRF entry) from 5 to 100 */
//#define MAX_TBL_SIZE				5
#define MAX_TBL_SIZE				100
/* WNC-NMR0604-JOE-PENG-20140304-modify CSRF mechanism for bug 604, 606 and 607-end */

//WNC-JDR230-YUAN-I-CHOU, Apply Realtek Patch. [CheeperSW:0676]
extern int get_mac_from_IP(char *MAC, char *remote_IP);
//WNC-JDR230-YUAN-I-CHOU, Apply Realtek Patch End. [CheeperSW:0676]
struct goform_entry {
	int	valid;		
//WNC-JDR230-YUAN-I-CHOU, Apply Realtek Patch. [CheeperSW:0676]
	unsigned int hash_id;
//WNC-JDR230-YUAN-I-CHOU, Apply Realtek Patch End. [CheeperSW:0676]
	char name[80];
	/* NMR1223-20151203-Patch NEC solution to fix bug 1223 [Linear][Alvia] CSRF vulnerability was found-start */
	char session[32+2];
//	char old_session[32+2];
	/* NMR1222-20151203-Patch NEC solution to fix bug 1222 [Linear][Alvia] CSRF vulnerability was found-end */
	time_t time;
};

struct goform_entry  security_tbl[MAX_TBL_SIZE] = {\
		{0}, {0}, {0}, {0}};


//WNC-JDR230-YUAN-I-CHOU, Apply Realtek Patch. [CheeperSW:0676]
unsigned int JSHash(char* str, unsigned int len)
{
   unsigned int hash = 1315423911;
   unsigned int i    = 0;

   for(i = 0; i < len; str++, i++)
   {
      hash ^= ((hash << 5) + (*str) + (hash >> 2));
   }

   return hash;
}

unsigned int hash_IP_MAC(request *req)
{
	struct in_addr ip;
	char buf[20], mac[20];
	/* WNC-NMR0266-JOE-PENG-20121212-Fix bug that device can not set the all functions via WAN port even if WAN port access is enabled. */
	int m1=0, m2=0, m3=0, m4=0, m5=0, m6=0;

	inet_aton(req->remote_ip_addr, &ip);

	/* WNC-NMR0266-JOE-PENG-20121212-Fix bug that device can not set the all functions via WAN port even if WAN port access is enabled.-->start */
	memset(mac,0x00,sizeof(mac));

	if (get_mac_from_IP(mac, req->remote_ip_addr) == 1) {
		sscanf(mac, "%x:%x:%x:%x:%x:%x", &m1, &m2, &m3, &m4, &m5, &m6);
	}
	/* WNC-NMR0266-JOE-PENG-20121212-Fix bug that device can not set the all functions via WAN port even if WAN port access is enabled.-->end */
	snprintf(buf, sizeof(buf), "%x%x%x%x%x%x%x", m1, m2, m3, m4, m5, m6, ip);

	return JSHash(buf, strlen(buf));
}
//WNC-JDR230-YUAN-I-CHOU, Apply Realtek Patch End. [CheeperSW:0676]
//WNC-JDR230-YUAN-I-CHOU, Apply Realtek Patch. [CheeperSW:0676]
//void log_boaform(char *form)
void log_boaform(char *form, request *req)
//WNC-JDR230-YUAN-I-CHOU, Apply Realtek Patch End. [CheeperSW:0676]
{
	int i, oldest_entry=-1;
	/* WNC-NMR0000-JOE-PENG-20140114-Fix bug "After device time was set by Access-timer Page, web server of DUT will return 403 error when browser submits form in Access-timer Page"-start */
	//time_t t, oldest_time=-1;
	time_t oldest_time=-1, temp_current_time=0;
	struct sysinfo info;
	/* WNC-NMR0604-JOE-PENG-20140304-modify CSRF mechanism for bug 604, 606 and 607-start */
	/* Make log_boaform() logs different CSRF entry if client with different IP gets same form */
	unsigned int temp_hash_id=0;

	temp_hash_id = hash_IP_MAC(req);
	/* WNC-NMR0604-JOE-PENG-20140304-modify CSRF mechanism for bug 604, 606 and 607-end */

	for (i=0; i<MAX_TBL_SIZE; i++) {
		/* Get uptime (Seconds) */
		sysinfo(&info);
		temp_current_time = (time_t) info.uptime ;

		if (!security_tbl[i].valid ||
				(security_tbl[i].valid && 
					(temp_current_time - security_tbl[i].time) > EXPIRE_TIME) ||
					/* WNC-NMR0604-JOE-PENG-20140304-modify CSRF mechanism for bug 604, 606 and 607 */
					/* Make log_boaform() logs different CSRF entry if client with different IP gets same form */
					(security_tbl[i].valid && !strcmp(form, security_tbl[i].name) && temp_hash_id==security_tbl[i].hash_id)) {	
			break;					
		}	
		else {
			if (security_tbl[i].valid) {
				if (oldest_entry == -1 || security_tbl[i].time < oldest_time) {
					oldest_entry = i;
					oldest_time = security_tbl[i].time;
				}				
			}			
		}		
	}

	if ((i < MAX_TBL_SIZE) || (i == MAX_TBL_SIZE && oldest_entry != -1)) {		
		if (i == MAX_TBL_SIZE)
			i = oldest_entry;
		
		/* WNC-NMR0000-JOE-PENG-20140911-Fix bug 2150 (STRING_OVERFLOW) in StaticCodeCheck_Linear_Delta1.xls -start */
		//strcpy(security_tbl[i].name, form);
		/* WNC-NMR0000-JOE-PENG-20150203-Fix coverity bug 120 (buffer_size_warning) of Alvia beta 4 in StaticCodeCheck_Alvia.zip-start */
		//strncpy(security_tbl[i].name, form, sizeof(security_tbl[i].name));
		strncpy(security_tbl[i].name, form, sizeof(security_tbl[i].name)-1);
		security_tbl[i].name[sizeof(security_tbl[i].name)-1] = '\0';
		/* WNC-NMR0000-JOE-PENG-20150203-Fix coverity bug 120 (buffer_size_warning) of Alvia beta 4 in StaticCodeCheck_Alvia.zip-end */
		/* WNC-NMR0000-JOE-PENG-20140911-Fix bug 2150 (STRING_OVERFLOW) in StaticCodeCheck_Linear_Delta1.xls -end */

		/* Get uptime (Seconds) */
		sysinfo(&info);
		temp_current_time = (time_t) info.uptime ;

//WNC-JDR230-YUAN-I-CHOU, Apply Realtek Patch. [CheeperSW:0676]
		security_tbl[i].hash_id = hash_IP_MAC(req);
//WNC-JDR230-YUAN-I-CHOU, Apply Realtek Patch End. [CheeperSW:0676]
		security_tbl[i].time = temp_current_time;
		/* NMR1223-20151203-Patch NEC solution to fix bug 1223 [Linear][Alvia] CSRF vulnerability was found-start */
		if( strcmp(security_tbl[i].session, GetSessionID()) ){
//			strncpy(security_tbl[i].old_session, security_tbl[i].session, sizeof(security_tbl[i].old_session)); //  for accesstimer, sitesurvey
			strncpy(security_tbl[i].session, GetSessionID(), sizeof(security_tbl[i].session));
		}
		/* NMR1223-20151203-Patch NEC solution to fix bug 1223 [Linear][Alvia] CSRF vulnerability was found-end */
		security_tbl[i].valid = 1;		
		
		
		/* NMR1223-20151203-Patch NEC solution to fix bug 1223 [Linear][Alvia] CSRF vulnerability was found */
//		printf("change [%02d] form=[%s] ssid=[%s] oldssid=[%s]\n",i,security_tbl[i].name,security_tbl[i].session,security_tbl[i].old_session);

	}
	/* WNC-NMR0000-JOE-PENG-20140114-Fix bug "After device time was set by Access-timer Page, web server of DUT will return 403 error when browser submits form in Access-timer Page"-end */
}

/* WNC-NMR0604-JOE-PENG-20140304-modify CSRF mechanism for bug 604, 606 and 607-start */
/* Make delete_boaform() delete CSRF entry according to form name and IP of client */
static void delete_boaform(char *form, request *req)
{
	int i;
	unsigned int temp_hash_id=0;

	temp_hash_id = hash_IP_MAC(req);

//for allow save config multi-times 
	if(strcmp(form,"formSaveConfig")==0)
		return;
	
	for (i=0; i<MAX_TBL_SIZE; i++) {
		if (security_tbl[i].valid && !strcmp(form, security_tbl[i].name) && temp_hash_id==security_tbl[i].hash_id) {
			security_tbl[i].valid = 0;
			break;
		}		
	}
}
/* WNC-NMR0604-JOE-PENG-20140304-modify CSRF mechanism for bug 604, 606 and 607-end */


//WNC-JDR230-YUAN-I-CHOU, Apply Realtek Patch. [CheeperSW:0676]
//static int is_valid_boaform(char *form) 
/* NMR1223-20151203-Patch NEC solution to fix bug 1223 [Linear][Alvia] CSRF vulnerability was found */
static int is_valid_boaform(char *form, request *req, char *session) 
//WNC-JDR230-YUAN-I-CHOU, Apply Realtek Patch End. [CheeperSW:0676]
{
	int i, valid=0;
	/* WNC-NMR0000-JOE-PENG-20140114-Fix bug "After device time was set by Access-timer Page, web server of DUT will return 403 error when browser submits form in Access-timer Page"-start */
	//time_t t;
	time_t temp_current_time=0;
	struct sysinfo info;

	for (i=0; i<MAX_TBL_SIZE; i++) {
//WNC-JDR230-YUAN-I-CHOU, Apply Realtek Patch. [CheeperSW:0676]
/* NMR1223-20151203-Patch NEC solution to fix bug 1223 [Linear][Alvia] CSRF vulnerability was found-start */
//		if (security_tbl[i].valid && !strcmp(form, security_tbl[i].name)) {
		if (security_tbl[i].valid && !strcmp(form, security_tbl[i].name) 
			&& security_tbl[i].hash_id == hash_IP_MAC(req)
			&& ( strcmp(security_tbl[i].session,"") &&  !strcmp(session, security_tbl[i].session))
//			     || ( strcmp(security_tbl[i].old_session,"") && !strcmp(session, security_tbl[i].old_session))
				) {
/* NMR1222-20151203-Patch NEC solution to fix bug 1222 [Linear][Alvia] CSRF vulnerability was found-end */
//WNC-JDR230-YUAN-I-CHOU, Apply Realtek Patch End. [CheeperSW:0676]
			/* Get uptime (Seconds) */
			sysinfo(&info);
			temp_current_time = (time_t) info.uptime ;

			if	((temp_current_time - security_tbl[i].time) > EXPIRE_TIME) {					
				security_tbl[i].valid = 0;
				break;
			}				
			valid = 1;
			break;
		/* NMR1351-20160217-Fix bug 1351 [Linear/Alvia] Can't Firmware Version UP to use Some PC to use Browser-start */
		} else if (security_tbl[i].valid && !strcmp(form, security_tbl[i].name) 
				&& security_tbl[i].hash_id == hash_IP_MAC(req)) {
			if (upload_file_size_too_big==1) {
				/* Set upload_file_size_too_big to 0 */
				upload_file_size_too_big=0;

				/* Get uptime (Seconds) */
				sysinfo(&info);
				temp_current_time = (time_t) info.uptime ;

				if	((temp_current_time - security_tbl[i].time) > EXPIRE_TIME) {					
					security_tbl[i].valid = 0;
					break;
				}				
				valid = 1;
				break;
			}
		}
		/* NMR1351-20160217-Fix bug 1351 [Linear/Alvia] Can't Firmware Version UP to use Some PC to use Browser-end */
	}	
	/* WNC-NMR0000-JOE-PENG-20140114-Fix bug "After device time was set by Access-timer Page, web server of DUT will return 403 error when browser submits form in Access-timer Page"-end */
	return valid;
}

static int is_any_log()
{
	int i;
	for (i=0; i<MAX_TBL_SIZE; i++) {
		if (security_tbl[i].valid)
			return 1;
	}
	return 0;
}
#endif // ASP_SECURITY_PATCH
/* WNC-NMR0035-JOE-PENG-20120618-end */

/******************************************************************************/
int addTempStr(char *str)
{
	temp_mem_t *temp,*newtemp;

	temp = &root_temp;
	while (temp->next) {
		temp = temp->next;
	}
	newtemp = (temp_mem_t *)malloc(sizeof(temp_mem_t));
	if (newtemp==NULL)
		return FAILED;
	newtemp->str = str;
	newtemp->next = NULL;
	temp->next = newtemp;	
	return SUCCESS;
}

void freeAllTempStr(void)
{
	temp_mem_t *temp,*ntemp;
	
	temp = root_temp.next;
	root_temp.next = NULL;
	while (1) {
		if (temp==NULL)
			break;
		ntemp = temp->next;
		free(temp->str);
		free(temp);
		temp = ntemp;
	}
}

int getcgiparam(char *dst,char *query_string,char *param,int maxlen)
{
	int len,plen;
	int y;
	char *end_str;
	
	end_str = query_string + strlen(query_string);
	plen = strlen(param);
	while (*query_string && query_string <= end_str) {
		len = strlen(query_string);
		if ((len=strlen(query_string)) > plen) {
			if (!strncmp(query_string,param,plen)) {
				if (query_string[plen] == '=') { //copy parameter
					query_string += plen+1;
					y = 0;
					while ((*query_string)&&(*query_string!='&')) {
						if ((*query_string=='%') && (strlen(query_string)>2)) {
							if ((isxdigit(query_string[1])) && (isxdigit(query_string[2]))) {
								if (y<maxlen) {
									dst[y++] = ((toupper(query_string[1])>='A'?toupper(query_string[1])-'A'+0xa:toupper(query_string[1])-'0') << 4)
									+ (toupper(query_string[2])>='A'?toupper(query_string[2])-'A'+0xa:toupper(query_string[2])-'0');
								}
								query_string += 3;
								continue;
							}
						}
						if (*query_string=='+')	{
							if (y < maxlen)
								dst[y++] = ' ';
							query_string++;
							continue;
						}
						if (y<maxlen)
							dst[y++] = *query_string;
						query_string++;
					}
					if (y<maxlen)
						dst[y] = 0;
					return y;
				}
			}
		}
		while ((*query_string)&&(*query_string!='&'))
			query_string++;
		if(!(*query_string))
			break;
		query_string++;
	}
	if (maxlen)
		dst[0] = 0;
	return -1;
}
char *memstr(char *membuf, char *param, int memsize)
{
	char charfind;
	char charmem;
	char charfindfisrt;
	char *findpos;
	char *mempos;
	int  mmsz;

	if ((charfindfisrt = *param++) == 0) {
        return membuf;
    }

    while (memsize-- > 0) {
        charmem = *membuf++;
        if (charmem == charfindfisrt) {
            findpos = param;
            mempos = membuf;
            mmsz = memsize;

            while ((charfind = *findpos++) != 0) {
                if (mmsz-- <= 0) {
                    return NULL;
                }
                charmem = *mempos++;

                if (charmem != charfind) {
                    break;
                }
            }

            if (charfind == 0) {
                return (membuf - 1);
            }
        }
    }
    return NULL;
}

/* NMR1351-20160217-Fix bug 1351 [Linear/Alvia] Can't Firmware Version UP to use Some PC to use Browser */
int rtl_mime_get_boundry(char *query_string, int query_string_len, request *req)
{
	char *substr_start,*ptr;
	/* NMR1351-20160217-Fix bug 1351 [Linear/Alvia] Can't Firmware Version UP to use Some PC to use Browser-start */
	//char *substr="----------------------------";
	char *substr="------";
	/* NMR1351-20160217-Fix bug 1351 [Linear/Alvia] Can't Firmware Version UP to use Some PC to use Browser-end */
	substr_start=memstr(query_string,substr,query_string_len);

	/* NMR1470-20160316-Fix bug 1470 [Sonic/Pocket] CSRF not Work the specific procedure-start */
	/* If boundary string exists in HTTP header, then we get boundary string from HTTP header */
	if (req->multipart_boundary) {
		if (strcmp(req->multipart_boundary, "") != 0) {
			//if (substr_start==NULL) {
				/* NMR1351-20160217-Fix bug 1351 [Linear/Alvia] Can't Firmware Version UP to use Some PC to use Browser-start */
			//	upload_file_size_too_big=1;
				/* NMR1351-20160217-Fix bug 1351 [Linear/Alvia] Can't Firmware Version UP to use Some PC to use Browser-end */
			//	return -1;
			//} else {
				strncpy(str_boundry, req->multipart_boundary, MAX_BOUNDRY_LEN);
				return 0;
			//}
		}
	}

	if(substr_start==NULL)
	{
		printf("can't get boundry string\n");
		return -1;
	}
	/* NMR1470-20160316-Fix bug 1470 [Sonic/Pocket] CSRF not Work the specific procedure-end */

	/* NMR1351-20160217-Fix bug 1351 [Linear/Alvia] Can't Firmware Version UP to use Some PC to use Browser-start */
	/* If boundary string does not exist in HTTP header, then we get boundary string from HTTP body */
	{
		int i=0;
		ptr=substr_start;
		while( (ptr[i] !=0x0d || ptr[i+1] !=0x0a) && i<MAX_BOUNDRY_LEN)
		{	
			str_boundry[i]=ptr[i];
			i++;
		}
		if(i>=MAX_BOUNDRY_LEN)
		{
			printf("the string of boundry is too long\n");
			return -1;
		}
		str_boundry[i]=0;
	}
	/* NMR1351-20160217-Fix bug 1351 [Linear/Alvia] Can't Firmware Version UP to use Some PC to use Browser-end */
	return 0;
}
	
char *rtl_mime_find_boundry(char *query_string, int query_string_len)
{
	char *substr_start;	
	substr_start=memstr(query_string,str_boundry,query_string_len);
	if(substr_start==NULL)
		return NULL;
	int len=strlen(str_boundry);
	substr_start+=len;	 
	return (substr_start+2);
}
	
char *rtl_mime_get_name(char *query_string,char *param,int query_string_len)
{
	char *ptr=NULL;
	ptr=memstr(query_string,param,query_string_len);
	if(ptr==NULL)
		return NULL;
	return ptr;
}

/* NMR1351-20160217-Fix bug 1351 [Linear/Alvia] Can't Firmware Version UP to use Some PC to use Browser */
int mime_get_var(char *dst,char *query_string, int query_string_len,char *param,int maxlen, request *req)
{
	int len,plen;
	int i,reval;
	char *cur_boundry,*next_boundry,*pname;
	
	char *query_string_orig=query_string;
	plen = strlen(param);
	/* NMR1351-20160217-Fix bug 1351 [Linear/Alvia] Can't Firmware Version UP to use Some PC to use Browser */
	reval=rtl_mime_get_boundry(query_string,query_string_len, req);
	if(reval<0)
		return -1;
	int boundry_len=strlen(str_boundry);	
	cur_boundry=rtl_mime_find_boundry(query_string,query_string_len);	
	if(cur_boundry==NULL)
	{
		printf("can't find the first boundry\n");
		return -1;
	}
	query_string_len-=(cur_boundry-query_string_orig);
	while (query_string_len > 0) {		
		
		if(query_string_len<boundry_len+2)
		{
			printf("the query_string_len is less than boundry_len\n");
			break;
		}
		next_boundry=rtl_mime_find_boundry(cur_boundry,query_string_len);
		if(next_boundry==NULL)
		{
			printf("can't find the next boundry\n");
			return -1;
		}
		len=next_boundry-cur_boundry;
		if((pname=rtl_mime_get_name(cur_boundry,param,len))!=NULL)
		{
			pname+=plen+1;	
		
			while((pname[0]) != 0x0d || (pname[1] !=0x0a) || (pname[2] != 0x0d) || (pname[3] != 0x0a))
				pname++;
		/*Skip 0xd 0xa 0xd 0xa*/
			if ((pname[0]) == 0x0d && (pname[1]==0x0a) &&  (pname[2] == 0x0d) && (pname[3] == 0x0a)) { //copy parameter
				pname += 4;			 
				for(i=0;i<next_boundry-pname-boundry_len-2-2;i++)
					dst[i]=pname[i];
			
				dst[i]=0;			 
 		
				return i;
			}
		}
		else 
		{
			cur_boundry=next_boundry;
			query_string_len-=len;			
		}			
	}
	if (maxlen)
		dst[0] = 0;
	return -1;
}
char *req_get_cstream_var_in_mime(request *req, char *var, char *defaultGetValue,int *data_len)
{
	/* WNC-MR0000-JDR230-YUAN-I-CHOU-Fix warnings of cppcheck */
	char *buf = NULL;
	int ret = 0; //WNC-NMR0000-Rita-20130306-Error_467-fix warnings of cppcheck (uninitialized value).
	if (req->method == M_POST) {		
		int i;
		buf = (char *)malloc(req->upload_len+1);
		if (buf == NULL)
			return (char *)defaultGetValue;
		req->post_data_idx = 0;
		memcpy(buf, req->upload_data, req->upload_len);
		buf[req->upload_len] = 0;
	
		i = req->upload_len -1;
		
		while (i > 0) {
			if ((buf[i]==0x0a)||(buf[i]==0x0d))
				buf[i]=0;
			else
				break;
			i--;
		}
	
	}

	if(buf != NULL) {
		/* NMR1351-20160217-Fix bug 1351 [Linear/Alvia] Can't Firmware Version UP to use Some PC to use Browser */
		ret = mime_get_var(query_temp_var,buf,req->upload_len,var,MAX_QUERY_TEMP_VAL_SIZE, req);
	}

	if (ret < 0)
		return (char *)defaultGetValue;
	buf = (char *)malloc(ret+1);
	if(data_len!=NULL)		
		*data_len=ret;
	memcpy(buf, query_temp_var, ret);
	buf[ret] = 0;
	addTempStr(buf);
	return (char *)buf; //this buffer will be free by freeAllTempStr().
}

char *req_get_cstream_var(request *req, char *var, char *defaultGetValue)
{
	char *buf;
#ifndef NEW_POST
	struct stat statbuf;
#endif
	int ret=-1;
	
	if (req->method == M_POST) {
		int i;
// davidhsu --------------------------------
#ifndef NEW_POST
		fstat(req->post_data_fd, &statbuf);
		buf = (char *)malloc(statbuf.st_size+1);
		if (buf == NULL)
			return (char *)defaultGetValue;
		lseek(req->post_data_fd, SEEK_SET, 0);
		read(req->post_data_fd,buf,statbuf.st_size);
		buf[statbuf.st_size] = 0;
		i = statbuf.st_size - 1;
#else
		buf = (char *)malloc(req->post_data_len+1);
		if (buf == NULL)
			return (char *)defaultGetValue;
		req->post_data_idx = 0;
		memcpy(buf, req->post_data, req->post_data_len);
		buf[req->post_data_len] = 0;
		i = req->post_data_len -1;
#endif
//-------------------------------------------
		while (i > 0) {
			if ((buf[i]==0x0a)||(buf[i]==0x0d))
				buf[i]=0;
			else
				break;
			i--;
		}
	}
	else {
		buf = req->query_string;
	}

	if (buf != NULL) {
		ret = getcgiparam(query_temp_var,buf,var,MAX_QUERY_TEMP_VAL_SIZE);	
	}
	
	if (req->method == M_POST)
		free(buf);
	
	if (ret < 0)
		return (char *)defaultGetValue;
	buf = (char *)malloc(ret+1);
	memcpy(buf, query_temp_var, ret);
	buf[ret] = 0;
	addTempStr(buf);
	return (char *)buf; //this buffer will be free by freeAllTempStr().
}

void asp_init(int argc,char **argv)
{
	/* WNC-MR0000-JDR230-YUAN-I-CHOU-Fix warnings of cppcheck */
	int i, num = 0;
	char interface[10];
	extern int getWlStaNum(char *interface, int *num);

	root_temp.next=NULL;
	root_temp.str=NULL;	
	
	// david ---- queury number of wlan interface ----------------
	wlan_num = 0;
	for (i=0; i<NUM_WLAN_INTERFACE; i++) {
		snprintf(interface, sizeof(interface), "wlan%d", i);
		if (getWlStaNum(interface, &num) < 0)
			break;
		wlan_num++;
	}
	
#if defined(VOIP_SUPPORT) && defined(ATA867x)
	// no wlan interface in ATA867x
#else
	if (wlan_num==0)
		wlan_num = 1;	// set 1 as default
#endif

#ifdef MBSSID
	vwlan_num = NUM_VWLAN_INTERFACE; 
#endif
	//---------------------------------------------------------

//conti:
	root_temp.next = NULL;
	root_temp.str = NULL;	

	if (apmib_init() == 0) {
		printf("Initialize AP MIB failed!%s:%d\n",__FUNCTION__,__LINE__);
		return;
	}

	save_cs_to_file();
	apmib_get(MIB_WAN_DHCP, (void *)&last_wantype);

/* WNC-MR0000-Heng-I-Chen-20120503-Internet Reachability Check uses saved netbiosname */
	apmib_get( MIB_NETBIOS_NAME, (void *)&nbname);
/* WNC-MR0000-Heng-I-Chen-20120503-End */
			
	/* determine interface name by mib value */
	WAN_IF = "eth1";
	BRIDGE_IF = "br0";
	ELAN_IF = "eth0";
	ELAN2_IF = "eth2";
	ELAN3_IF = "eth3";
	ELAN4_IF = "eth4";

#ifdef HOME_GATEWAY
	PPPOE_IF = "ppp0";
#elif defined(VOIP_SUPPORT) && defined(ATA867x)
	BRIDGE_IF = "eth0";
	ELAN_IF = "eth0";
#else
	BRIDGE_IF = "br0";
	ELAN_IF = "eth0";
#endif
	strlcpy(WLAN_IF, "wlan0", 20);
	//---------------------------

	query_temp_var = (char *)malloc(MAX_QUERY_TEMP_VAL_SIZE);
	if (query_temp_var==NULL)
		exit(0);
	return;
	
//main_end:
	//shmdt(pRomeCfgParam);
	//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20130814, fix coverity error 829
	//exit(0);
}

int allocNewBuffer(request *req)
{
	char *newBuffer;

	newBuffer = (char *)malloc(req->max_buffer_size*2+1);
	if (newBuffer == NULL)
		return FAILED;
	memcpy(newBuffer, req->buffer, req->max_buffer_size);
	req->max_buffer_size <<= 1;	
	free(req->buffer);	
	req->buffer = newBuffer;
	return SUCCESS;
}

int update_content_length(request *req)
{
	char *content_len_orig1;
	char *content_len_orig2;
	int orig_char_length=0;
	int exact_content_len=0;
	char *content_len_start;
	char buff[32];
	
	content_len_orig1 = strstr(req->buffer, "Content-Length:");
	if (content_len_orig1==NULL) //do nothing
		return 0;
	content_len_orig2 = strstr(content_len_orig1, "\r\n");
	content_len_start = strstr((content_len_orig2+2), "\r\n")+strlen("\r\n");
	content_len_orig1 = content_len_orig1 + strlen("Content-Length: ");
	orig_char_length = content_len_orig2 - content_len_orig1;
	if (orig_char_length < 32) {
		memcpy(buff, content_len_orig1, orig_char_length);
		buff[orig_char_length] = '\0';
	}
	else {
		memcpy(buff, content_len_orig1, 31);
		buff[31] = '\0';
	}
	/*
	fprintf(stderr, "buff=%s orig_char_length=%d\n", buff, orig_char_length);
	fprintf(stderr, "req->buffer_start=%d req->buffer_end=%d\n", req->buffer_start, req->buffer_end);
	fprintf(stderr, "req->buffer=%p\n", req->buffer);
	fprintf(stderr, "req->buffer+req->buffer_start=%p\n", req->buffer+req->buffer_start);
	fprintf(stderr, "req->buffer+req->buffer_end=%p\n", req->buffer+req->buffer_end);
	fprintf(stderr, "content_len_start=%p\n", content_len_start);
	*/
	exact_content_len = ((req->buffer+req->buffer_end) - content_len_start);
	//fprintf(stderr, "exact_content_len=%d\n", exact_content_len);
	if(atoi(buff) != exact_content_len) {
		//fprintf(stderr, "need to update the content length!\n");
		snprintf(buff, sizeof(buff), "%d", exact_content_len);
		if ((strlen(buff)+1) <= orig_char_length){
			memset(content_len_orig1,0,orig_char_length);
			memcpy(content_len_orig1, buff, strlen(buff));
		}
	}
	return exact_content_len;
}
		
void handleForm(request *req)
{
	char *ptr;
	int i;
	#define SCRIPT_ALIAS "/boafrm/"
	
//fprintf(stderr, "###%s:%d req->request_uri=%s###\n", __FILE__, __LINE__, req->request_uri);
	ptr = strstr(req->request_uri, SCRIPT_ALIAS);
	apmib_get(MIB_WAN_DHCP, (void *)&last_wantype);
	if (ptr==NULL) {
		send_r_not_found(req);
		return;
	}
	else {
		/* NMR1223-20151203-Patch NEC solution to fix bug 1223 [Linear][Alvia] CSRF vulnerability was found */
		char *session;
		form_name_t *now_form;
		ptr+=strlen(SCRIPT_ALIAS);

		/* NMR1223-20151203-Patch NEC solution to fix bug 1223 [Linear][Alvia] CSRF vulnerability was found-start */
		session = req_get_cstream_var(req, ("SESSION_ID"), "");
		if( !strlen(session) ) 
			session = req_get_cstream_var_in_mime(req, ("SESSION_ID"), "",NULL);
		/* NMR1223-20151203-Patch NEC solution to fix bug 1223 [Linear][Alvia] CSRF vulnerability was found-end */

		for (i=0; root_form[i].name!=NULL; i++) {
			now_form = &root_form[i];
			if ((strlen(ptr) == strlen(now_form->name)) &&
			    (memcmp(ptr,now_form->name,strlen(now_form->name))==0)) {

/* WNC-NMR0035-JOE-PENG-20120618-Patch Realtek's CSRF prevention solution */
#ifdef CSRF_SECURITY_PATCH
#ifdef HTTP_FILE_SERVER_SUPPORTED
				if(strcmp(now_form->name,"formusbdisk_uploadfile")==0)
				{
//					log_boaform(now_form->name);	
					log_boaform(now_form->name, req);	
				}
#endif
//				if ( !is_any_log() || !is_valid_boaform(now_form->name))	{
				/* NMR1223-20151203-Patch NEC solution to fix bug 1223 [Linear][Alvia] CSRF vulnerability was found */
				if ( !is_any_log() || !is_valid_boaform(now_form->name, req, session))	{
//WNC-JDR230-YUAN-I-CHOU, Apply Realtek Patch End. [CheeperSW:0676]
				#if defined(CONFIG_APP_FWD)
					{
						if (!strcmp(now_form->name, "formUpload"))
						{
							extern int get_shm_id();
							extern int clear_fwupload_shm();
							int shm_id = get_shm_id();	
							clear_fwupload_shm(shm_id);
						}
					}
				#endif					
#ifdef CONFIG_APP_ACCESSTIMER
// WNC-NMR0669-JDR231-HENG-I-CHEN-2014-05-16: fix CSRF protection behavior for Access Timer pages #BEGIN
					if ((!strcmp(now_form->name, "formAccesstimerStaSet"))) {
// WNC-NMR0669-JDR231-HENG-I-CHEN-2014-05-16: fix CSRF protection behavior for Access Timer pages #END
						accesstimer_guardmsg = 2;
						send_redirect_perm(req, ACCESS_TIMER_GUARD_PAGE);
// WNC-NMR0669-JDR231-HENG-I-CHEN-2014-05-16: fix CSRF protection behavior for Access Timer pages #BEGIN
					} else if ((!strcmp(now_form->name, "formAccesstimerStaReg"))) {
						
						char *submitUrl;

						accesstimer_guardmsg = 2;

						submitUrl = req_get_cstream_var(req, ("submit-url"), "");

						if (strcmp(submitUrl, "/kodomo_frame.htm") == 0) {
							req_format_write(req, "<script> top.doJump(\"%s\"); </script>", ACCESS_TIMER_GUARD_PAGE);
						} else {
							send_redirect_perm(req, ACCESS_TIMER_GUARD_PAGE);
						}
						
					} else if ((!strcmp(now_form->name, "formAccesstimerSet")) ||
						(!strcmp(now_form->name, "formAccessstimerSchedulerSet")) ||
						(!strcmp(now_form->name, "formAccessstimerTemporarySet")) ||
						(!strcmp(now_form->name, "formAccesstimerStaSetCategory")) ||
						(!strcmp(now_form->name, "formAccesstimerGoto"))) {
// WNC-NMR0669-JDR231-HENG-I-CHEN-2014-05-16: fix CSRF protection behavior for Access Timer pages #END
						accesstimer_guardmsg = 2;
						req_format_write(req, "<script> top.doJump(\"%s\"); </script>", ACCESS_TIMER_GUARD_PAGE);
					} else 
#endif	//#ifdef CONFIG_APP_ACCESSTIMER
					{
						send_r_forbidden(req);
					}
					return;					
				}
				/* WNC-NMR0604-JOE-PENG-20140304-modify CSRF mechanism for bug 604, 606 and 607-start */
#ifdef CONFIG_APP_ACCESSTIMER
				if ((!strcmp(now_form->name, "formAccesstimerSet")) ||
					(!strcmp(now_form->name, "formAccesstimerStaSet")) ||
					(!strcmp(now_form->name, "formAccesstimerStaReg")) ||
					(!strcmp(now_form->name, "formAccessstimerSchedulerSet")) ||
					(!strcmp(now_form->name, "formAccessstimerTemporarySet")) ||
					(!strcmp(now_form->name, "formAccesstimerStaSetCategory")) ||
					(!strcmp(now_form->name, "formAccesstimerGoto"))) {
					/* Make delete_boaform() does not delete Access Timer related forms */
				} else
#endif	//#ifdef CONFIG_APP_ACCESSTIMER
				{
					/* Make delete_boaform() delete CSRF entry according to form name and IP of client */
					//delete_boaform(now_form->name);
					delete_boaform(now_form->name, req);
				}
				/* WNC-NMR0604-JOE-PENG-20140304-modify CSRF mechanism for bug 604, 606 and 607-end */
#endif				
/* WNC-NMR0035-JOE-PENG-20120618-end */

				send_r_request_ok2(req);		/* All's well */	
/*#ifdef USE_AUTH
				if (req->auth_flag == 1) { // user
					//brad add for wizard
					if(!strcmp(req->request_uri,"/boafrm/formSetEnableWizard")){
						send_redirect_perm(req, "/wizard_back.htm");
					}else{
						//ptr= (char *)req_get_cstream_var(req, ("webpage"), (""));					
						//strcpy(last_url, ptr);				
						//sprintf(ok_msg,"%s","\"Only <b>admin</b> account can change the settings.<br>\""); 				
						//send_redirect_perm(req, WEB_PAGE_APPLY_OK);	
						ptr= (char *)req_get_cstream_var(req, ("webpage"), (""));
						if(ptr ==NULL)
							sprintf(last_url, "/%s", directory_index);
						else
							strcpy(last_url, ptr);	
										
						if(!strcmp(req->request_uri,"/boafrm/formSetRestorePrev") || !strcmp(req->request_uri,"/boafrm/formSetFactory")){
							sprintf(last_url, "%s","util_savesetting.asp");
							if (req->upload_data)
								free(req->upload_data);	
						}
						if(!strcmp(req->request_uri,"/boafrm/formFirmwareUpgrade")){
							sprintf(last_url, "%s","util_firmware.asp");	
							if (req->upload_data)
								free(req->upload_data);	
						}	
						if(!strcmp(req->request_uri,"/boafrm/formWPS")){
							wps_action= (char *)req_get_cstream_var(req, ("wpsAction"), (""));
							if(!strcmp(wps_action, "pbc") || !strcmp(wps_action, "pin")){
								now_form->function(req,NULL,NULL);
								freeAllTempStr();
								return;
							}
						}	
						sprintf(ok_msg,"%s","\"Only <b>admin</b> account can change the settings.<br>\"");
						send_redirect_perm(req, WEB_PAGE_APPLY_OK);	
						}			
				}
				else
#endif*/
				now_form->function(req,NULL,NULL);

#ifdef HTTP_FILE_SERVER_SUPPORTED  
			if(req->FileUploadAct == 1){
				if(strstr(req->UserBrowser, "MSIE")){
					update_content_length(req);
				}
			}
			else  
#endif    	
				update_content_length(req);
				freeAllTempStr();
				return;
			}
		}
	}
	send_r_not_found(req);
}

void handleScript(request *req,char *left1,char *right1)
{
	char *left=left1,*right=right1;
	asp_name_t *now_asp;
	unsigned int funcNameLength;
	int i, j;
	
	left += 2;
	right -= 1;
	while (1) {
		while (*left==' ') {if(left>=right) break;++left;}
		while (*left==';') {if(left>=right) break;++left;}
		while (*left=='(') {if(left>=right) break;++left;}
		while (*left==')') {if(left>=right) break;++left;}
		while (*left==',') {if(left>=right) break;++left;}
		if (left >= right)
			break;

		/* count the function name length */
		{
			char *ptr = left;

			funcNameLength = 0;
			while (*ptr!='(' && *ptr!=' ') {
				ptr++;
				funcNameLength++;
				if ((unsigned int )ptr >= (unsigned int)right) {
					break;
				}
			}
		}

		for (j=0; root_asp[j].name!=NULL; j++) {
			now_asp = &root_asp[j];
			if ((strlen(now_asp->name) == funcNameLength) &&
			    (memcmp(left,now_asp->name,strlen(now_asp->name))==0)) {
				char *leftc,*rightc;
				int argc=0;
				char *argv[8]={NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL};
				
				left += strlen(now_asp->name);
				while (1) {
					int size,exit=0;
					while (1) {
						if (*left==')') {
							exit=1;
							break;
						}
						if (*left=='\"')
							break;
						if ((unsigned int)left > (unsigned int)right) {
							exit=1;
							break;
						}
						left++;	
					}
					
					if (exit==1)
						break;					
					leftc = left;
					leftc++;
					rightc = strstr(leftc,"\"");
					if (rightc==NULL)
						break;
					size = (unsigned int)rightc-(unsigned int)leftc+1;
					argv[argc] = (char *)malloc(size);
					if (argv[argc]==NULL)
						break;
					memcpy(argv[argc],leftc,size-1);
					argv[argc][size-1] = '\0';
					argc++;
					left = rightc + 1;
				}
				//fprintf(stderr, "###%s:%d now_asp->name=%s###\n", __FILE__, __LINE__, now_asp->name);
				now_asp->function(req,argc,argv);
				for (i=0; i<argc; i++)
					free(argv[i]);
				break;
			}
		}
		++left;
	}
}
#endif

extern request inner_req;
/* WNC-MR0000-JDR230-YUAN-I-CHOU-Enlarge buffer size */
extern char inner_req_buff[4096];
extern int middle_segment; //Brad add for update content length
int req_format_write(request *req, char *format, ...)
{
	int bob;
	va_list args;
	/* WNC-MR0000-JDR230-YUAN-I-CHOU-Enlarge buffer size */
	char temp[4096];

	if (!req || !format)
		return 0;
	va_start(args, format);
	vsnprintf(temp, sizeof(temp), format, args);
	va_end(args);
	bob = strlen(temp);
	if ((void*)req == (void*)(&inner_req)) {
		strlcpy(inner_req_buff, temp, sizeof(inner_req_buff));
	}
	else {
#ifndef SUPPORT_ASP
		if ((bob+req->buffer_end) > BUFFER_SIZE)
			bob = BUFFER_SIZE - req->buffer_end;
#else
		while ((bob+req->buffer_end+10) > req->max_buffer_size) {  //Brad modify
			int ret;
			ret = allocNewBuffer(req);
			if (ret==FAILED) {
				bob = BUFFER_SIZE - req->buffer_end;
				break;
			}
		}
#endif
		middle_segment = middle_segment + bob; //brad add for update exact length of asp file
		if (bob > 0) {
			memcpy((req->buffer+req->buffer_end), temp, bob);	
			req->buffer_end += bob;
		}
	}
	return bob;
}
int getIncludeCss(request *wp)
{
#ifdef CONFIG_APP_BOA_NEW_UI
		return req_format_write(wp,  "<link href=\"/style.css\" rel=\"stylesheet\" type=\"text/css\">");
#else
		return req_format_write(wp,  "<style>h2{font-weight:bold;color:rgb(0,0,255);}\
		tr.tbl_head {\
		background-color: #7f7f7f;\
		}\
		tr.tbl_body {\
		background-color: #b7b7b7;\
		}\
		td.tbl_title {\
		background-color: #008000;\
		color: #FFFFFF;\
		font-weight: bold;\
		}\
		</style>");
#endif
}

