/*
 *   Handling routines for LED lightening functions
 *
 *  $Id: 8192cd_led.c,v 1.1 2012/05/04 12:49:07 jimmylin Exp $
 *
 *  Copyright (c) 2012 Realtek Semiconductor Corp.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 */

#define _8192CD_LED_C_

#include "./8192cd_cfg.h"
#include "./8192cd.h"
#include "./8192cd_headers.h"
#include "./8192cd_debug.h"

static int rpt_act_led_state = 0;
static int tv_led_state = 0;
static int led_state = 0;


// for SW LED ----------------------------------------------------
#ifdef RTL8190_SWGPIO_LED
static void set_swGpio_LED(struct rtl8192cd_priv *priv, unsigned int ledNum, int flag)
{
	unsigned int ledItem;	/* parameter to decode GPIO item */

	if (ledNum >= SWLED_GPIORT_CNT)
		return;

	ledItem = SWLED_GPIORT_ITEM(LED_ROUTE, ledNum);

	if (ledItem & SWLED_GPIORT_ENABLEMSK)
	{
		/* get the corresponding information (GPIO number/Active high or low) of LED */
		int gpio;
		int activeMode;	/* !=0 : Active High, ==0 : Active Low */

		gpio = ledItem & SWLED_GPIORT_RTBITMSK;
		activeMode = ledItem & SWLED_GPIORT_HLMSK;

		if (flag) {	/* Turn ON LED */
			if (activeMode)	/* Active High */
				RTL_W8(0x90, RTL_R8(0x90) | BIT(gpio));
			else			/* Active Low */
				RTL_W8(0x90, RTL_R8(0x90) &~ BIT(gpio));
		}
		else {	/* Turn OFF LED */
			if (activeMode)	/* Active High */
				RTL_W8(0x90, RTL_R8(0x90) &~ BIT(gpio));
			else			/* Active Low */
				RTL_W8(0x90, RTL_R8(0x90) | BIT(gpio));
		}
	}
}
#endif // RTL8190_SWGPIO_LED


static void set_sw_LED0(struct rtl8192cd_priv *priv, int flag)
{
#ifdef RTL8190_SWGPIO_LED
	if (LED_ROUTE)
		set_swGpio_LED(priv, 0, flag);
#elif defined(CONFIG_RTL8672) || defined(NOT_RTK_BSP)
	if (flag)
		RTL_W32(LEDCFG, (RTL_R32(LEDCFG) & 0xfffffff0) | LED0SV);
	else
		RTL_W32(LEDCFG, RTL_R32(LEDCFG) & 0xfffffff0);
#else
	if ((GET_CHIP_VER(priv) == VERSION_8188E)||(GET_CHIP_VER(priv) == VERSION_8192E)) {
#ifdef RTLWIFINIC_GPIO_CONTROL
		if (flag)
			RTLWIFINIC_GPIO_write(5, 0);
		else
			RTLWIFINIC_GPIO_write(5, 1);
#endif
	}
	else if ((GET_CHIP_VER(priv) == VERSION_8812E)) {
		if (flag)
			RTL_W32(LEDCFG, (RTL_R32(LEDCFG) & 0xfffff0ff) | LED1SV);
		else
			RTL_W32(LEDCFG, RTL_R32(LEDCFG) & 0xfffff0ff);
	}
	else if (GET_CHIP_VER(priv) == VERSION_8881A) {
		if (flag)
			writel(readl(IO_TYPE_CAST(0xb800350c)) | BIT(24), IO_TYPE_CAST(0xb800350c));
		else
			writel(readl(IO_TYPE_CAST(0xb800350c)) & ~BIT(24), IO_TYPE_CAST(0xb800350c));
	}
	else {
		if (flag)
			RTL_W32(LEDCFG, (RTL_R32(LEDCFG) & 0xfffffff0) | LED0SV);
		else
			RTL_W32(LEDCFG, RTL_R32(LEDCFG) & 0xfffffff0);
	}
#endif
}


static void set_sw_LED1(struct rtl8192cd_priv *priv, int flag)
{
#ifdef RTL8190_SWGPIO_LED
	if (LED_ROUTE)
		set_swGpio_LED(priv, 1, flag);
#elif defined(CONFIG_RTL8672) || defined(NOT_RTK_BSP)
	if (flag)
		RTL_W32(LEDCFG, (RTL_R32(LEDCFG) & 0xfffff0ff) | LED1SV);
	else
		RTL_W32(LEDCFG, RTL_R32(LEDCFG) & 0xfffff0ff);
#else
	if ((GET_CHIP_VER(priv) == VERSION_8188E)||(GET_CHIP_VER(priv) == VERSION_8192E)) {
#ifdef RTLWIFINIC_GPIO_CONTROL
		if (flag)
			RTLWIFINIC_GPIO_write(5, 0);
		else
			RTLWIFINIC_GPIO_write(5, 1);
#endif		
	}
#if defined(CONFIG_RTL_92D_SUPPORT)
	else if (GET_CHIP_VER(priv) == VERSION_8192D) {
		if (flag)
			RTL_W32(LEDCFG, (RTL_R32(LEDCFG) & 0xfffff0ff) | LED1SV_92D);
		else
			RTL_W32(LEDCFG, RTL_R32(LEDCFG) & 0xfffff0ff);
	}
#endif	
	else if (GET_CHIP_VER(priv) == VERSION_8192C){
		if (flag)
			RTL_W32(LEDCFG, (RTL_R32(LEDCFG) & 0xfffff0ff) | LED1SV);
		else
			RTL_W32(LEDCFG, RTL_R32(LEDCFG) & 0xfffff0ff);
	}
#endif
}


static void set_sw_LED2(struct rtl8192cd_priv *priv, int flag)
{
#ifdef RTL8190_SWGPIO_LED
	if (LED_ROUTE)
		set_swGpio_LED(priv, 2, flag);
#elif defined(CONFIG_RTL8672) || defined(NOT_RTK_BSP)
	if (flag)
		RTL_W32(LEDCFG, (RTL_R32(LEDCFG) & 0xfff0ffff) | LED2SV);
	else
		RTL_W32(LEDCFG, RTL_R32(LEDCFG) & 0xfff0ffff);
#else

	if ((GET_CHIP_VER(priv) == VERSION_8188E)||(GET_CHIP_VER(priv) == VERSION_8192E)) {
#ifdef RTLWIFINIC_GPIO_CONTROL
		if (flag)
			RTLWIFINIC_GPIO_write(5, 0);
		else
			RTLWIFINIC_GPIO_write(5, 1);
#endif		
	}
#if defined(CONFIG_RTL_92D_SUPPORT)
	else if (GET_CHIP_VER(priv) == VERSION_8192D) {
		if (flag)
			RTL_W32(LEDCFG, (RTL_R32(LEDCFG) & 0xfff0ffff) | LED2SV_92D);
		else
			RTL_W32(LEDCFG, RTL_R32(LEDCFG) & 0xfff0ffff);
	}
#endif	
	else if (GET_CHIP_VER(priv) == VERSION_8192C){
		if (flag)
			RTL_W32(LEDCFG, (RTL_R32(LEDCFG) & 0xfff0ffff) | LED2SV);
		else
			RTL_W32(LEDCFG, RTL_R32(LEDCFG) & 0xfff0ffff);
	}
#endif
}


//WNC-JDR230-NMRXXXX-YUAN-I-CHOU-20140522, Add wireless LED
#define REG32(reg)      (*(volatile unsigned int *)(reg))
#define PABCD_DAT		0xB800350C
#define PEFGH_DAT		0xB8003528

static void set_sw_LED(struct rtl8192cd_priv *priv, int flag)
{
	//printk("set_sw_LED [%s] [%d]\n", priv->dev->name, flag);

	//ON = 0, OFF = 1
	if (GET_CHIP_VER(priv) == VERSION_8192E) {

		//printk("rpt_act_led_state [%d] priv->pshare->cnv_rpt_mode [%d]\n", rpt_act_led_state, priv->pshare->cnv_rpt_mode);
		
		if (priv->pshare->cnv_rpt_mode == 1) {
			//CNV or RPT mode
			if (rpt_act_led_state == 0) {
				//Not connected
				flag = 1;
				//OFF LED
			}
		}
		
		if (priv->pshare->LED_force_off == 1) {
			flag = 1;
			//OFF LED
		}

		//2.4G
		//printk("2G [%d] flag[%d]\n", priv->pshare->rssi_led_flag, flag);
		switch (priv->pshare->rssi_led_flag) {
			case 0: //RT, AP mode, or RootAP is not connected in CNV/RPT mode
			case 3: // High signal strength
				//Green LED only, turn OFF Red LED
				REG32(PEFGH_DAT) = (REG32(PEFGH_DAT) & (~(1<<27)));//2.4G Red
				if (!flag) { //ON
					REG32(PABCD_DAT) = (REG32(PABCD_DAT) & (~(1<<16)));//2.4G Green
				}
				else { //OFF
					REG32(PABCD_DAT) = (REG32(PABCD_DAT) | (1<<16));//2.4G Green
				}
				break;
			case 2: // Middle signal strength
				if (!flag) { //ON
					REG32(PABCD_DAT) = (REG32(PABCD_DAT) & (~(1<<16)));//2.4G Green
					REG32(PEFGH_DAT) = (REG32(PEFGH_DAT) | (1<<27));//2.4G Red
				}
				else { //OFF
					REG32(PABCD_DAT) = (REG32(PABCD_DAT) | (1<<16));//2.4G Green
					REG32(PEFGH_DAT) = (REG32(PEFGH_DAT) & (~(1<<27)));//2.4G Red
				}
				break;
			case 1: // Low signal strength
				//Red LED only, turn OFF Green LED
				REG32(PABCD_DAT) = (REG32(PABCD_DAT) | (1<<16));//2.4G Green
				
				if (!flag) { //ON
					REG32(PEFGH_DAT) = (REG32(PEFGH_DAT) | (1<<27));//2.4G Red
				}
				else { //OFF
					REG32(PEFGH_DAT) = (REG32(PEFGH_DAT) & (~(1<<27)));//2.4G Red
				}
				break;
			default:
				//WTF!!?
				break;
		}
	}
	if (GET_CHIP_VER(priv) == VERSION_8812E) {

		//printk("rpt_act_led_state [%d] priv->pshare->cnv_rpt_mode [%d]\n", rpt_act_led_state, priv->pshare->cnv_rpt_mode);
		
		if (priv->pshare->cnv_rpt_mode == 1) {
			//CNV or RPT mode
			if (rpt_act_led_state == 0) {
				//Not connected
				flag = 1;
				//OFF LED
			}
		}
		
		if (priv->pshare->LED_force_off == 1) {
			flag = 1;
			//OFF LED
		}

		//5G
		//printk("5G [%d]\n", priv->pshare->rssi_led_flag);
		switch (priv->pshare->rssi_led_flag) {
			case 0: //RT, AP mode, or RootAP is not connected in CNV/RPT mode
			case 3: // High signal strength
				//Green LED only, turn OFF Red LED

				//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140807, modify 5G red LED off condition.
				if (led_state == 0) {
				//NOT in DFS red LEDs blink mode
				//If we turn off 5G red LED during DFS red LEDs blink mode, would cause strange LED behavior
					REG32(PEFGH_DAT) = (REG32(PEFGH_DAT) & (~(1<<28)));//5G Red
				}

				if (!flag) { //ON
					REG32(PABCD_DAT) = (REG32(PABCD_DAT) & (~(1<<23)));//5G Green
				}
				else { //OFF
					REG32(PABCD_DAT) = (REG32(PABCD_DAT) | (1<<23));//5G Green
				}
				break;
			case 2: // Middle signal strength
				if (!flag) { //ON
					REG32(PABCD_DAT) = (REG32(PABCD_DAT) & (~(1<<23)));//5G Green
					REG32(PEFGH_DAT) = (REG32(PEFGH_DAT) | (1<<28));//5G Red
				}
				else { //OFF
					REG32(PABCD_DAT) = (REG32(PABCD_DAT) | (1<<23));//5G Green
					REG32(PEFGH_DAT) = (REG32(PEFGH_DAT) & (~(1<<28)));//5G Red
				}
				break;
			case 1: // Low signal strength
				//Red LED only, turn OFF Green LED
				REG32(PABCD_DAT) = (REG32(PABCD_DAT) | (1<<23));//5G Green
				if (!flag) { //ON
					REG32(PEFGH_DAT) = (REG32(PEFGH_DAT) | (1<<28));//5G Red
				}
				else { //OFF
					REG32(PEFGH_DAT) = (REG32(PEFGH_DAT) & (~(1<<28)));//5G Red
				}
				break;
			default:
				//WTF!!?
				break;
		}
	}
}

static void LED_Interval_timeout(unsigned long task_priv)
{
	struct rtl8192cd_priv *priv = (struct rtl8192cd_priv *)task_priv;

	if (!(priv->drv_state & DRV_STATE_OPEN))
		return;
	if (!priv->pshare->set_led_in_progress) {
		set_sw_LED(priv, priv->pshare->LED_Toggle);
	}
//	if (priv->pshare->LED_force_off == 1) {
//		set_sw_LED(priv, 1);
//	}
	if (priv->pshare->LED_Toggle)
		mod_timer(&priv->pshare->LED_Timer, jiffies + RTL_MILISECONDS_TO_JIFFIES(50));
	else
		mod_timer(&priv->pshare->LED_Timer, jiffies + priv->pshare->LED_Interval);

	priv->pshare->LED_Toggle = (priv->pshare->LED_Toggle + 1) % 2;
}

#if 0
static void LED_Interval_timeout(unsigned long task_priv)
{
	struct rtl8192cd_priv *priv = (struct rtl8192cd_priv *)task_priv;
	int led_on_time= LED_ON_TIME;

	if (!(priv->drv_state & DRV_STATE_OPEN))
		return;

#ifdef PCIE_POWER_SAVING
	if ((priv->pwr_state != L1) && (priv->pwr_state != L2))
#endif
	{
		if (!priv->pshare->set_led_in_progress) {
#if defined(CONFIG_RTL8672) || defined(NOT_RTK_BSP)
#ifdef CONFIG_RTL_88E_SUPPORT
			if (GET_CHIP_VER(priv) == VERSION_8188E)
				set_sw_LED2(priv, priv->pshare->LED_Toggle);
			else
#endif
#ifdef CONFIG_WLAN_HAL_8192EE
			if (GET_CHIP_VER(priv) == VERSION_8192E)
				set_sw_LED0(priv, priv->pshare->LED_Toggle);
			else
#endif
#ifdef CONFIG_RTL_8812_SUPPORT
			if (GET_CHIP_VER(priv) == VERSION_8812E)
				set_sw_LED1(priv, priv->pshare->LED_Toggle);
			else
#endif
#endif // CONFIG_RTL8672 || NOT_RTK_BSP
			if ((LED_TYPE == LEDTYPE_SW_LINKTXRX) ||
				(LED_TYPE == LEDTYPE_SW_LINKTXRXDATA) ||
				(LED_TYPE == LEDTYPE_SW_ENABLETXRXDATA) ||
				((LED_TYPE == LEDTYPE_SW_ADATA_GDATA) && (priv->pshare->curr_band == BAND_5G)) ||
				(LED_TYPE == LEDTYPE_SW_LED2_GPIO8_LINKTXRX) ||
				(LED_TYPE == LEDTYPE_SW_LED2_GPIO8_ENABLETXRXDATA) ||
				(LED_TYPE == LEDTYPE_SW_LED2_GPIO10_LINKTXRX) ||
				(LED_TYPE == LEDTYPE_SW_LED2_GPIO8_LINKTXRXDATA) ||
				(LED_TYPE == LEDTYPE_SW_LED2_GPIO8_ASOCTXRXDATA) ||
				(LED_TYPE == LEDTYPE_SW_LED2_GPIO10_ENABLETXRXDATA) ||
				(LED_TYPE == LEDTYPE_SW_LED2_GPIO10_ENABLETXRXDATA_92D) ||
				(LED_TYPE == LEDTYPE_SW_LED1_GPIO9_LINKTXRX_92D) ||
				(LED_TYPE == LEDTYPE_SW_LED2_GPIO10_LINKTXRX_92D))
			{
				if ((LED_TYPE == LEDTYPE_SW_LED2_GPIO8_LINKTXRX) ||
					(LED_TYPE == LEDTYPE_SW_LED2_GPIO8_ENABLETXRXDATA) ||
					(LED_TYPE == LEDTYPE_SW_LED2_GPIO10_LINKTXRX) ||
					(LED_TYPE == LEDTYPE_SW_LED2_GPIO8_LINKTXRXDATA) ||
					(LED_TYPE == LEDTYPE_SW_LED2_GPIO8_ASOCTXRXDATA) ||
					(LED_TYPE == LEDTYPE_SW_LED2_GPIO10_ENABLETXRXDATA) ||
					(LED_TYPE == LEDTYPE_SW_LED2_GPIO10_ENABLETXRXDATA_92D) ||
					(LED_TYPE == LEDTYPE_SW_LED2_GPIO10_LINKTXRX_92D))
					set_sw_LED2(priv, priv->pshare->LED_Toggle);
				else if (LED_TYPE == LEDTYPE_SW_LED1_GPIO9_LINKTXRX_92D)
					set_sw_LED1(priv, priv->pshare->LED_Toggle);
				else
					set_sw_LED0(priv, priv->pshare->LED_Toggle);
			} else {
				set_sw_LED1(priv, priv->pshare->LED_Toggle);
			}
		}
	}

	if( (LED_TYPE == LEDTYPE_SW_LED2_GPIO8_ASOCTXRXDATA) && 
	    (!(OPMODE & WIFI_ASOC_STATE)))  //client not assco  , mark_led
	{		
		led_on_time = LED_NOBLINK_TIME;
	}

	if ( priv->pshare->LED_Toggle == priv->pshare->LED_ToggleStart) {
		mod_timer(&priv->pshare->LED_Timer, jiffies + priv->pshare->LED_Interval);
	} else {
		if 	(LED_TYPE == LEDTYPE_SW_CUSTOM1)
			mod_timer(&priv->pshare->LED_Timer, jiffies + priv->pshare->LED_Interval);
		else
			mod_timer(&priv->pshare->LED_Timer, jiffies + led_on_time); 
	}

	priv->pshare->LED_Toggle = (priv->pshare->LED_Toggle + 1) % 2;
}
#endif

void enable_sw_LED(struct rtl8192cd_priv *priv, int init)
{

	if (timer_pending(&priv->pshare->LED_Timer)) {
		printk("SW LED is already opened\n");
		return;
	}

	printk("enable_sw_LED [%d]\n", init);
	priv->pshare->LED_Interval = RTL_MILISECONDS_TO_JIFFIES(50);
	priv->pshare->LED_Toggle = 0;
	priv->pshare->LED_ToggleStart = LED_OFF;
	priv->pshare->LED_tx_cnt_log = 0;
	priv->pshare->LED_rx_cnt_log = 0;
	priv->pshare->LED_tx_cnt = 0;
	priv->pshare->LED_rx_cnt = 0;

	set_sw_LED(priv, LED_ON);

	priv->pshare->LED_ToggleStart = LED_ON;

	if (init) {
		init_timer(&priv->pshare->LED_Timer);
		priv->pshare->LED_Timer.expires = jiffies + priv->pshare->LED_Interval;
		priv->pshare->LED_Timer.data = (unsigned long) priv;
		priv->pshare->LED_Timer.function = &LED_Interval_timeout;
		mod_timer(&priv->pshare->LED_Timer, jiffies + priv->pshare->LED_Interval);
	}
}

#if 0
void enable_sw_LED(struct rtl8192cd_priv *priv, int init)
{
#if (defined(HW_ANT_SWITCH) || defined(SW_ANT_SWITCH))&&( defined(CONFIG_RTL_92C_SUPPORT) || defined(CONFIG_RTL_92D_SUPPORT))
		int b23 = RTL_R32(LEDCFG) & BIT(23);
#endif

	if (LED_TYPE == LEDTYPE_SW_LED2_GPIO8_ASOCTXRXDATA) 
		if (!(OPMODE & WIFI_STATION_STATE)) // if it is not Client mode , then run orignal 12 type
			LED_TYPE = LEDTYPE_SW_LED2_GPIO8_ENABLETXRXDATA ;  
	     
	// configure mac to use SW LED
#if defined(CONFIG_RTL8672) || defined(NOT_RTK_BSP)
#ifdef CONFIG_RTL_88E_SUPPORT
	if (GET_CHIP_VER(priv) == VERSION_8188E)
		RTL_W32(LEDCFG, (RTL_R32(LEDCFG)&0xFF00FFFF) | LED2EN | LED2SV);
	else
#endif
#ifdef CONFIG_WLAN_HAL_8192EE
	if (GET_CHIP_VER(priv) == VERSION_8192E)
		RTL_W32(LEDCFG, (RTL_R32(LEDCFG)&0xFFFFFF00) | LED0SV);
	else
#endif
#else // !CONFIG_RTL8672 && !NOT_RTK_BSP

#if defined(CONFIG_RTL_88E_SUPPORT) || defined(CONFIG_WLAN_HAL_8192EE) //mark_ecos	
	if ((GET_CHIP_VER(priv) == VERSION_8188E)||(GET_CHIP_VER(priv) == VERSION_8192E))
	{
#ifdef RTLWIFINIC_GPIO_CONTROL
		RTLWIFINIC_GPIO_config(5, 0x10);
#endif
	}
	else 
#endif
#endif // CONFIG_RTL8672 || NOT_RTK_BSP
	if (GET_CHIP_VER(priv) == VERSION_8812E)
		RTL_W32(LEDCFG, BIT(13) | LED1SV);
	else
#ifdef CONFIG_WLAN_HAL_8881A
	if (GET_CHIP_VER(priv) == VERSION_8881A) {
		writel(readl(IO_TYPE_CAST(0xb8000044)) | BIT(15) | BIT(16), IO_TYPE_CAST(0xb8000044));
		writel(readl(IO_TYPE_CAST(0xb8003500)) & ~BIT(24), IO_TYPE_CAST(0xb8003500));
		writel(readl(IO_TYPE_CAST(0xb8003508)) | BIT(24), IO_TYPE_CAST(0xb8003508));
		writel(readl(IO_TYPE_CAST(0xb800350c)) | BIT(24), IO_TYPE_CAST(0xb800350c));
	} else
#endif
	{
		if (LED_TYPE == LEDTYPE_SW_LED2_GPIO10_LINKTXRX)
			RTL_W32(LEDCFG, (RTL_R32(LEDCFG)&0xFF00FFFF) | LED2EN | LED2SV);
	else if (LED_TYPE == LEDTYPE_SW_LED2_GPIO10_ENABLETXRXDATA)
		RTL_W32(LEDCFG, (RTL_R32(LEDCFG)&0xFF00FFFF) | LED2EN | LED2SV);
#ifdef CONFIG_RTL_92D_SUPPORT
	else if ((LED_TYPE == LEDTYPE_SW_LED2_GPIO10_LINKTXRX_92D) ||
		(LED_TYPE == LEDTYPE_SW_LED2_GPIO10_ENABLETXRXDATA_92D))
			RTL_W32(LEDCFG,(RTL_R32(LEDCFG)&0xFF00FFFF)| LED2DIS_92D | LED2SV_92D);
		else if (LED_TYPE == LEDTYPE_SW_LED1_GPIO9_LINKTXRX_92D)
			RTL_W32(LEDCFG, (RTL_R32(LEDCFG)&0xFFFF00FF)|LED1DIS_92D | LED1SV_92D); 	
#endif
		else if ((LED_TYPE == LEDTYPE_SW_LED2_GPIO8_LINKTXRX) ||
			(LED_TYPE == LEDTYPE_SW_LED2_GPIO8_ENABLETXRXDATA) ||
			(LED_TYPE == LEDTYPE_SW_LED2_GPIO8_ASOCTXRXDATA) || 	
			(LED_TYPE == LEDTYPE_SW_LED2_GPIO8_LINKTXRXDATA))
			RTL_W32(LEDCFG, (RTL_R32(LEDCFG)&0xFF00FFFF) | GP8_LED | LED2EN | LED2SV);
		else
			RTL_W32(LEDCFG, LED2SV | LED1SV | LED0SV);
	}

	priv->pshare->LED_Interval = LED_INTERVAL_TIME;
	priv->pshare->LED_Toggle = 0;
	priv->pshare->LED_ToggleStart = LED_OFF;
	priv->pshare->LED_tx_cnt_log = 0;
	priv->pshare->LED_rx_cnt_log = 0;
	priv->pshare->LED_tx_cnt = 0;
	priv->pshare->LED_rx_cnt = 0;

	if ((LED_TYPE == LEDTYPE_SW_ENABLE_TXRXDATA) ||
		(LED_TYPE == LEDTYPE_SW_ENABLETXRXDATA)) {
		set_sw_LED0(priv, LED_ON);
		set_sw_LED1(priv, LED_OFF);

		if (LED_TYPE == LEDTYPE_SW_ENABLETXRXDATA)
			priv->pshare->LED_ToggleStart = LED_ON;
	} else if ((LED_TYPE == LEDTYPE_SW_LED2_GPIO10_ENABLETXRXDATA) ||
		(LED_TYPE == LEDTYPE_SW_LED2_GPIO10_ENABLETXRXDATA_92D)) {
		set_sw_LED2(priv, LED_ON);
		priv->pshare->LED_ToggleStart = LED_ON;
	} else if (LED_TYPE == LEDTYPE_SW_ADATA_GDATA) {
		priv->pshare->LED_ToggleStart = LED_ON;
		if (priv->pshare->curr_band == BAND_5G) {
			set_sw_LED0(priv, LED_ON);
			set_sw_LED1(priv, LED_OFF);
		}
		else {	// 11G
			set_sw_LED0(priv, LED_OFF);
			set_sw_LED1(priv, LED_ON);
		}
	}
	else if (LED_TYPE == LEDTYPE_SW_ENABLETXRXDATA_1) {
		set_sw_LED0(priv, LED_OFF);
		set_sw_LED1(priv, LED_ON);
		priv->pshare->LED_ToggleStart = LED_ON;
	}
	else if ((LED_TYPE == LEDTYPE_SW_LED2_GPIO8_ENABLETXRXDATA) ||
		(LED_TYPE == LEDTYPE_SW_LED2_GPIO8_ASOCTXRXDATA) ) {
		set_sw_LED2(priv, LED_ON);
		priv->pshare->LED_ToggleStart = LED_ON;
	}
	else if ((LED_TYPE == LEDTYPE_SW_LED2_GPIO8_LINKTXRX) ||
		(LED_TYPE == LEDTYPE_SW_LED2_GPIO10_LINKTXRX) ||
		(LED_TYPE == LEDTYPE_SW_LED2_GPIO8_LINKTXRXDATA)) {
		set_sw_LED2(priv, LED_OFF);
	}
	else {
		set_sw_LED0(priv, LED_OFF);
		set_sw_LED1(priv, LED_OFF);
		set_sw_LED2(priv, LED_OFF);
	}

#if (defined(HW_ANT_SWITCH) || defined(SW_ANT_SWITCH))&&( defined(CONFIG_RTL_92C_SUPPORT) || defined(CONFIG_RTL_92D_SUPPORT))
	RTL_W32(LEDCFG, b23 | RTL_R32(LEDCFG));
#endif

	if (init) {
		init_timer(&priv->pshare->LED_Timer);
#if defined(CONFIG_PCI_HCI)
		priv->pshare->LED_Timer.data = (unsigned long) priv;
		priv->pshare->LED_Timer.function = &LED_Interval_timeout;
#elif defined(CONFIG_USB_HCI) || defined(CONFIG_SDIO_HCI)
		priv->pshare->LED_Timer.data = (unsigned long) &priv->pshare->LED_Timer_event;
		priv->pshare->LED_Timer.function = timer_event_timer_fn;
		INIT_TIMER_EVENT_ENTRY(&priv->pshare->LED_Timer_event,
			LED_Interval_timeout, (unsigned long)priv);
#endif

		mod_timer(&priv->pshare->LED_Timer, jiffies + priv->pshare->LED_Interval);
	}
}
#endif
//WNC-JDR230-NMRXXXX-YUAN-I-CHOU-20140522, Add wireless LED End


void disable_sw_LED(struct rtl8192cd_priv *priv)
{
	if ((LED_TYPE == LEDTYPE_SW_LED2_GPIO8_LINKTXRX) ||
		(LED_TYPE == LEDTYPE_SW_LED2_GPIO8_ENABLETXRXDATA) ||
		(LED_TYPE == LEDTYPE_SW_LED2_GPIO10_LINKTXRX) ||
		(LED_TYPE == LEDTYPE_SW_LED2_GPIO8_LINKTXRXDATA) ||
		(LED_TYPE == LEDTYPE_SW_LED2_GPIO8_ASOCTXRXDATA)) {
		set_sw_LED2(priv, LED_OFF);
	} else {
//WNC-JDR230-NMRXXXX-YUAN-I-CHOU-20140522, Add wireless LED
	printk("disable_sw_LED\n");
	set_sw_LED(priv, LED_OFF);
	//set_sw_LED0(priv, LED_OFF);
	//set_sw_LED1(priv, LED_OFF);
	//set_sw_LED2(priv, LED_OFF);
//WNC-JDR230-NMRXXXX-YUAN-I-CHOU-20140522, Add wireless LED End
	}
	if (timer_pending(&priv->pshare->LED_Timer))
		del_timer_sync(&priv->pshare->LED_Timer);
}

//WNC-JDR230-NMRXXXX-YUAN-I-CHOU-20140522, Add wireless LED
void calculate_sw_LED_interval(struct rtl8192cd_priv *priv)
{
	unsigned int delta = 0;
	int i, scale_num=0;

	if (priv->pshare->set_led_in_progress)
		return;

	// calculate counter delta
	delta += UINT32_DIFF(priv->pshare->LED_tx_cnt, priv->pshare->LED_tx_cnt_log);
	delta += UINT32_DIFF(priv->pshare->LED_rx_cnt, priv->pshare->LED_rx_cnt_log);
	priv->pshare->LED_tx_cnt_log = priv->pshare->LED_tx_cnt;
	priv->pshare->LED_rx_cnt_log = priv->pshare->LED_rx_cnt;

	// update interval according to delta
	if (delta == 0) {
		if (priv->pshare->LED_Interval == LED_NOBLINK_TIME)
			mod_timer(&priv->pshare->LED_Timer, jiffies + priv->pshare->LED_Interval);
		else
			priv->pshare->LED_Interval = LED_NOBLINK_TIME;

		set_sw_LED(priv, LED_ON);
	} else {
		priv->pshare->LED_Interval = RTL_MILISECONDS_TO_JIFFIES(50);
	}
}

#if 0
void calculate_sw_LED_interval(struct rtl8192cd_priv *priv)
{
	unsigned int delta = 0;
	int i, scale_num=0;

	if (priv->pshare->set_led_in_progress)
		return;

	if( (LED_TYPE == LEDTYPE_SW_LED2_GPIO8_ASOCTXRXDATA) && 
	    (!(OPMODE & WIFI_ASOC_STATE)))  //client not assco  , mark_led
      {        
      	 priv->pshare->LED_Interval = LED_NOBLINK_TIME; // force one second
      	 priv->pshare->LED_tx_cnt_log = priv->pshare->LED_tx_cnt; // sync tx/rx cnt
	 priv->pshare->LED_rx_cnt_log = priv->pshare->LED_rx_cnt;      
	 return ;
      }

	// calculate counter delta
	delta += UINT32_DIFF(priv->pshare->LED_tx_cnt, priv->pshare->LED_tx_cnt_log);
	delta += UINT32_DIFF(priv->pshare->LED_rx_cnt, priv->pshare->LED_rx_cnt_log);
	priv->pshare->LED_tx_cnt_log = priv->pshare->LED_tx_cnt;
	priv->pshare->LED_rx_cnt_log = priv->pshare->LED_rx_cnt;

	// update interval according to delta
	if (delta == 0) {
		if (LED_TYPE == LEDTYPE_SW_CUSTOM1) {
			if (priv->pshare->LED_Interval != RTL_SECONDS_TO_JIFFIES(1)) {
				priv->pshare->LED_Interval = RTL_SECONDS_TO_JIFFIES(1);
				mod_timer(&priv->pshare->LED_Timer, jiffies + priv->pshare->LED_Interval);
			}
		} else {
			if (priv->pshare->LED_Interval == LED_NOBLINK_TIME)
				mod_timer(&priv->pshare->LED_Timer, jiffies + priv->pshare->LED_Interval);
			else
				priv->pshare->LED_Interval = LED_NOBLINK_TIME;
		}
	} else {
		if ((priv->pmib->dot11BssType.net_work_type & WIRELESS_11G) ||
			(priv->pmib->dot11BssType.net_work_type & WIRELESS_11A))
			scale_num = LED_MAX_PACKET_CNT_AG / LED_MAX_SCALE;
		else
			scale_num = LED_MAX_PACKET_CNT_B / LED_MAX_SCALE;

		if ((LED_TYPE == LEDTYPE_SW_LINK_TXRX) ||
			(LED_TYPE == LEDTYPE_SW_LINKTXRX) ||
			(LED_TYPE == LEDTYPE_SW_LED2_GPIO8_LINKTXRX) ||
			(LED_TYPE == LEDTYPE_SW_LED2_GPIO10_LINKTXRX) ||
			(LED_TYPE == LEDTYPE_SW_LED2_GPIO8_LINKTXRXDATA) ||
			(LED_TYPE == LEDTYPE_SW_LED1_GPIO9_LINKTXRX_92D) ||
			(LED_TYPE == LEDTYPE_SW_LED2_GPIO10_LINKTXRX_92D) ||
			(LED_TYPE == LEDTYPE_SW_CUSTOM1))
			scale_num = scale_num*2;

		for (i=1; i<=LED_MAX_SCALE; i++) {
			if (delta < i*scale_num)
				break;
		}

		if (priv->pshare->rf_ft_var.ledBlinkingFreq > 1) {
			i = i*priv->pshare->rf_ft_var.ledBlinkingFreq;
			if (i > LED_MAX_SCALE)
				i = LED_MAX_SCALE;
		}

		priv->pshare->LED_Interval = ((LED_MAX_SCALE-i+1)*LED_INTERVAL_TIME)/LED_MAX_SCALE;

		if (priv->pshare->LED_Interval < LED_ON_TIME)
			priv->pshare->LED_Interval = LED_ON_TIME;
	}

	if ((LED_TYPE == LEDTYPE_SW_LINKTXRX) ||
		(LED_TYPE == LEDTYPE_SW_LINKTXRXDATA) ||
		(LED_TYPE == LEDTYPE_SW_LED2_GPIO8_LINKTXRX) ||
		(LED_TYPE == LEDTYPE_SW_LED2_GPIO10_LINKTXRX) ||
		(LED_TYPE == LEDTYPE_SW_LED2_GPIO8_LINKTXRXDATA) ||
		(LED_TYPE == LEDTYPE_SW_LED1_GPIO9_LINKTXRX_92D) ||
		(LED_TYPE == LEDTYPE_SW_LED2_GPIO10_LINKTXRX_92D)) {
		if (priv->link_status)
			priv->pshare->LED_ToggleStart = LED_ON;
		else
			priv->pshare->LED_ToggleStart = LED_OFF;
	} else {
		if (priv->pshare->set_led_in_progress)
			return;

		if ((LED_TYPE == LEDTYPE_SW_LINK_TXRX) ||
			(LED_TYPE == LEDTYPE_SW_LINK_TXRXDATA)) {
			if (priv->link_status)
				set_sw_LED0(priv, LED_ON);
			else
				set_sw_LED0(priv, LED_OFF);
		} else if (LED_TYPE == LEDTYPE_SW_ADATA_GDATA) {
			if (priv->pshare->curr_band == BAND_5G) {
				set_sw_LED0(priv, LED_ON);
				set_sw_LED1(priv, LED_OFF);
			} else {	// 11A
				set_sw_LED0(priv, LED_OFF);
				set_sw_LED1(priv, LED_ON);
			}
		}
	}
}
#endif
//WNC-JDR230-NMRXXXX-YUAN-I-CHOU-20140522, Add wireless LED End

#if 0

void set_wireless_LED_steady_on(int led_num, struct net_device *dev)
{
	struct rtl8192cd_priv *priv;

	if (led_num != LED_0 && led_num != LED_1 && led_num != LED_2)
		return;

#ifdef NETDEV_NO_PRIV
	if (dev == NULL || netdev_priv(dev) == NULL)
		return;

	priv = ((struct rtl8192cd_priv *)netdev_priv(dev))->wlan_priv;
#else
	if (dev == NULL || dev->priv == NULL)
		return;

	priv = (struct rtl8192cd_priv *)dev->priv;
#endif


	if (priv->pshare == NULL)
		return;

	priv->pshare->set_led_in_progress = 1;

	if ((LED_TYPE >= LEDTYPE_HW_TX_RX) && (LED_TYPE <= LEDTYPE_HW_LINKACT_INFRA)) {
		enable_sw_LED(priv, 0);
	}
	else if ((LED_TYPE >= LEDTYPE_SW_LINK_TXRX) && (LED_TYPE < LEDTYPE_SW_MAX)) {
		if (timer_pending(&priv->pshare->LED_Timer))
			del_timer_sync(&priv->pshare->LED_Timer);
	}

	if (led_num == LED_0)
		set_sw_LED0(priv, LED_ON);
	else if (led_num == LED_1)
		set_sw_LED1(priv, LED_ON);
	else
		set_sw_LED2(priv, LED_ON);
}


void recover_wireless_LED(struct net_device *dev)
{
	struct rtl8192cd_priv *priv;

#ifdef NETDEV_NO_PRIV
	if (dev == NULL || netdev_priv(dev) == NULL)
		return;
	
	priv = ((struct rtl8192cd_priv *)netdev_priv(dev))->wlan_priv;
#else
	if (dev == NULL || dev->priv == NULL)
		return;

	priv = (struct rtl8192cd_priv *)dev->priv;
#endif

	if (!priv->pshare->set_led_in_progress)
		return;

	// for HW/SW LED
	if ((LED_TYPE >= LEDTYPE_HW_TX_RX) && (LED_TYPE <= LEDTYPE_HW_LINKACT_INFRA)) {
		set_sw_LED0(priv, LED_OFF);
		set_sw_LED1(priv, LED_OFF);
		set_sw_LED2(priv, LED_OFF);
		enable_hw_LED(priv, LED_TYPE);
	}
	else if ((LED_TYPE >= LEDTYPE_SW_LINK_TXRX) && (LED_TYPE < LEDTYPE_SW_MAX)) {
		enable_sw_LED(priv, 0);
		mod_timer(&priv->pshare->LED_Timer, jiffies + priv->pshare->LED_Interval);
	}

	priv->pshare->set_led_in_progress = 0;
}
#endif


void control_wireless_led(struct rtl8192cd_priv *priv, int enable)
{
	if (enable == 0) {
		priv->pshare->set_led_in_progress = 1;
//WNC-JDR230-NMRXXXX-YUAN-I-CHOU-20140522, Add wireless LED
		//set_sw_LED0(priv, LED_OFF);
		//set_sw_LED1(priv, LED_OFF);
		//set_sw_LED2(priv, LED_OFF);
//WNC-JDR230-NMRXXXX-YUAN-I-CHOU-20140522, Add wireless LED End
		dfsoff_5g_redled(priv);
	}
	else if (enable == 1) {
		priv->pshare->set_led_in_progress = 1;
//WNC-JDR230-NMRXXXX-YUAN-I-CHOU-20140522, Add wireless LED
		//set_sw_LED0(priv, LED_ON);
		//set_sw_LED1(priv, LED_ON);
		//set_sw_LED2(priv, LED_ON);
//WNC-JDR230-NMRXXXX-YUAN-I-CHOU-20140522, Add wireless LED End
	}
	else if (enable == 2) {
//WNC-JDR230-NMRXXXX-YUAN-I-CHOU-20140522, Add wireless LED
		//set_sw_LED0(priv, priv->pshare->LED_ToggleStart);
		//set_sw_LED1(priv, priv->pshare->LED_ToggleStart);
		//set_sw_LED2(priv, priv->pshare->LED_ToggleStart);
//WNC-JDR230-NMRXXXX-YUAN-I-CHOU-20140522, Add wireless LED End
		priv->pshare->set_led_in_progress = 0;
	}
}


#ifdef CONFIG_RTL_ULINKER
static struct rtl8192cd_priv *root_priv = NULL;

void enable_sys_LED(struct rtl8192cd_priv *priv)
{
#ifdef RTLWIFINIC_GPIO_CONTROL
	RTLWIFINIC_GPIO_config(4, 0x10);
#endif
	root_priv = priv;
}


void renable_sw_LED(void)
{
	struct rtl8192cd_priv *priv = root_priv;

	if ((LED_TYPE >= LEDTYPE_SW_LINK_TXRX) && (LED_TYPE < LEDTYPE_SW_MAX)) {
		priv->pshare->set_led_in_progress = 1;
		disable_sw_LED(priv);
		priv->pshare->set_led_in_progress = 0;
		enable_sw_LED(priv, 1);
	}
}

#endif /* #ifdef CONFIG_RTL_ULINKER */

//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140210, move to 8192cd_led.c
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20130323, add DFS LED support
//static int led_state = 0;

#define REG32(reg)      (*(volatile unsigned int *)(reg))
#define PABCD_DIR 0xB8003508
#define PEFGH_DIR 0xB8003524

void dfsblink_5g_redled (struct rtl8192cd_priv *priv){
	rl_gpio_led_info led;

	//WNC-NMR410-JDR230-YUAN-I-CHOU-20130429, LED blinks while CAC_enable
	if ((led_state == 0) && priv->pmib->dot11DFSEntry.CAC_enable) {

		//Disable 5G Green / TV Green LED by setting DIR
		REG32(PABCD_DIR) = (REG32(PABCD_DIR) & (~(1<<23)));
		REG32(PEFGH_DIR) = (REG32(PEFGH_DIR) & (~(1<<0)));

		printk("Blink 5G Red LED. \n");
		led.gpio = 16;
		led.on = 5;
		led.off = 5;
		led.blinks = 4000;
		led.rests = 0;
		led.times = 4000;
		rl_gpio_led_set(led);
		led_state = 1;
	}
}

//WNC-NMR892-JDR230-YUAN-I-CHOU-20150113, restore TV LED behavior after CAC period
//Move from below
#define RTL_GPIOE0 (1<<0)

void dfsoff_5g_redled (struct rtl8192cd_priv *priv){
	rl_gpio_led_info led;

	if (led_state == 1) {

		//Enable 5G Green / TV Green LED by setting DIR
		REG32(PABCD_DIR) = (REG32(PABCD_DIR) | (1<<23));
		REG32(PEFGH_DIR) = (REG32(PEFGH_DIR) | (1<<0));

//WNC-NMR892-JDR230-YUAN-I-CHOU-20150113, restore TV LED behavior after CAC period
		if (tv_led_state > 0) {
			//TV LED should be ON
			REG32(PEFGH_DAT) = (REG32(PEFGH_DAT) & (~(RTL_GPIOE0)));//Turn ON TV LED
		}
//WNC-NMR892-JDR230-YUAN-I-CHOU-20150113, restore TV LED behavior after CAC period End

		printk("OFF 5G RED LED\n");
		//Cancel combination control
		led.gpio = 16;
		led.on = 0;
		led.off = 0;
		led.blinks = 0;
		led.rests = 0;
		led.times = 0;
		rl_gpio_led_set(led);
		led.gpio = 6;
		led.on = 0;
		led.off = 4000;
		led.blinks = 1;
		led.rests = 0;
		led.times = 4000;
		rl_gpio_led_set(led);
		led.gpio = 12;
		led.on = 0;
		led.off = 4000;
		led.blinks = 1;
		led.rests = 0;
		led.times = 4000;
		rl_gpio_led_set(led);

		led_state = 0;
	}
}

//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20130323, add DFS LED support End
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20130712, add WISP LED support
static int act_led_state = 0;

void wispblink_act_greenled (struct rtl8192cd_priv *priv){
	rl_gpio_led_info led;

	if (act_led_state == 0) {
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20131106, Modify LED behavior for Pocket 2 CL
#ifdef CONFIG_WNC_MODEL
		//printk("CONFIG_WNC_MODEL [%s] \n", CONFIG_WNC_MODEL);
		if (memcmp(CONFIG_WNC_MODEL, "rnrk-n3-cl", 11) == 0) {
			printk("Blink ACT ORANGE LED. \n");
			led.gpio = 10;
		} else {
			printk("Blink ACT GREEN LED. \n");
			led.gpio = 1;
		}
#else
		printk("Blink ACT GREEN LED. \n");
		led.gpio = 1;
#endif
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20131106, Modify LED behavior for Pocket 2 CL End
		led.on = 2;
		led.off = 2;
		led.blinks = 4000;
		led.rests = 0;
		led.times = 4000;
		//rl_gpio_led_set(led);
		act_led_state = 1;
	}
}

void wispoff_act_greenled (struct rtl8192cd_priv *priv){
	rl_gpio_led_info led;

	if (act_led_state == 1) {
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20131106, Modify LED behavior for Pocket 2 CL
#ifdef CONFIG_WNC_MODEL
		//printk("CONFIG_WNC_MODEL [%s] \n", CONFIG_WNC_MODEL);
		if (memcmp(CONFIG_WNC_MODEL, "rnrk-n3-cl", 11) == 0) {
			printk("OFF ACT ORANGE LED\n");
			led.gpio = 10;
		} else {
			printk("OFF ACT GREEN LED\n");
			led.gpio = 1;		
		}
#else
		printk("OFF ACT GREEN LED\n");
		led.gpio = 1;
#endif
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20131106, Modify LED behavior for Pocket 2 CL End
		led.on = 0;
		led.off = 4000;
		led.blinks = 1;
		led.rests = 0;
		led.times = 4000;
		//rl_gpio_led_set(led);
		act_led_state = 0;
	}
}
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20130712, add WISP LED support End
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20131217, add Repeater LED support

//WNC, Linear doesn't have this Spec.
#if 0

//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140128, Blink orange ACT while Auth, turn on while get IP.
void rptblink_act_orangeled (struct rtl8192cd_priv *priv){
	rl_gpio_led_info led;

	if (rpt_act_led_state == 0) {
		printk("%s BLINK ACT ORANGE LED\n", __func__);
		led.gpio = 10;
		led.on = 2;
		led.off = 2;
		led.blinks = 4000;
		led.rests = 0;
		led.times = 4000;
		//rl_gpio_led_set(led);
		rpt_act_led_state = 1;
	}
}
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140128, Blink orange ACT while Auth, turn on while get IP End
#endif
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140609, turn ON ACT Green while connect to AP.
void rpton_act_orangeled (struct rtl8192cd_priv *priv){
	rl_gpio_led_info led;

//WNC-NMR676-JDR230-YUAN-I-CHOU-20140618, Don't turn on Repeater connected LED while forced DHCP server mode
	if (priv->pshare->LED_force_off == 1) {
		//Don't trigger ACT LED while forced DHCP server mode.
		return;
	}
//WNC-NMR676-JDR230-YUAN-I-CHOU-20140618, Don't turn on Repeater connected LED while forced DHCP server mode End

	if (rpt_act_led_state == 0) {
	//from led state is blink
		printk("%s ON ACT GREEN LED\n", __func__);
		led.gpio = 1;
		led.on = 4000;
		led.off = 0;
		led.blinks = 1;
		led.rests = 0;
		led.times = 4000;
		rl_gpio_led_set(led);
		rpt_act_led_state = 1;
	}
}

void rptoff_act_orangeled (struct rtl8192cd_priv *priv){
	rl_gpio_led_info led;

	if (rpt_act_led_state == 1) {
		printk("%s OFF ACT GREEN LED\n", __func__);
		led.gpio = 1;
		led.on = 0;
		led.off = 4000;
		led.blinks = 1;
		led.rests = 0;
		led.times = 4000;
		rl_gpio_led_set(led);
		rpt_act_led_state = 0;

//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20141120, Turn OFF 2G 5G LED when ACT turn OFF.
		//Besides set flag to LED OFF, Turn OFF LEDs in here, too!
		REG32(PABCD_DAT) = (REG32(PABCD_DAT) | (1<<16));//2.4G Green
		REG32(PEFGH_DAT) = (REG32(PEFGH_DAT) & (~(1<<27)));//2.4G Red
		REG32(PABCD_DAT) = (REG32(PABCD_DAT) | (1<<23));//5G Green
		REG32(PEFGH_DAT) = (REG32(PEFGH_DAT) & (~(1<<28)));//5G Red
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20141120, Turn OFF 2G 5G LED when ACT turn OFF End.
	}
}
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140609, turn ON ACT Green while connect to AP End.
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20131217, add Repeater LED support End
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140210, move to 8192cd_led.c End

//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140618, TV LED
//WNC-NMR892-JDR230-YUAN-I-CHOU-20150113, restore TV LED behavior after CAC period
//Move to UP
//#define RTL_GPIOE0 (1<<0)

//flag : 0 = TV mode enable / disable
//flag : 1 = TV mode auto-enable / auto-disable
//flag : 2 = ECMv2 STA connected in 5G or not, STA general flag
//flag : 100 = Force OFF TV LED when interface off

void tv_led_ongreen (struct rtl8192cd_priv *priv, int flag){

	if (priv->pshare->LED_force_off == 1) {
		//Don't trigger TV LED while forced DHCP server mode.
		tv_led_state = 0;
		return;
	}

	//printk("ON flag [%d] tv_led_state [%d]\n", flag, tv_led_state);
	if (tv_led_state == 0) {
		// LED is OFF state
		//printk("tv_led_ongreen [%s]\n", priv->dev->name);
		REG32(PEFGH_DAT) = (REG32(PEFGH_DAT) & (~(RTL_GPIOE0)));
	}
	tv_led_state |= (1<<flag);
	//printk("ON tv_led_state [%d]\n", tv_led_state);
	//Add flag into state

	return;
}

void tv_led_offgreen (struct rtl8192cd_priv *priv, int flag){
	int i = 0;

	//printk("[%s] OFF flag [%d] tv_led_state [%d]\n", priv->dev->name, flag, tv_led_state);

	//WNC-NMR1716-D2R030-YUAN-I-CHOU-20160719, Turn OFF TV LED if all wireless interfaces are OFF
	if (flag == 100) {
		for (i = 0; i < 2 ; i++) {
			if (wlan_device[i].priv && (wlan_device[i].priv != GET_ROOT(priv))) {
				//Other radio's root interface
				//printk("[%s %d] %s\n", __func__, __LINE__, wlan_device[i].priv->dev->name);
				if (!(wlan_device[i].priv->drv_state & DRV_STATE_OPEN)) {
					//printk("[%s %d]\n", __func__, __LINE__);
					//Other radio's root interface doesn't OPEN, and we receive flag 100.
					//Turn OFF TV LED.
					tv_led_state = 0;
					REG32(PEFGH_DAT) = (REG32(PEFGH_DAT) | (RTL_GPIOE0));
					return;
				}
			}
		}
	}
	//WNC-NMR1716-D2R030-YUAN-I-CHOU-20160719, Turn OFF TV LED if all wireless interfaces are OFF End

	if ((tv_led_state & (1<<0))) {
		//TV mode is enabled in any radio, ignore TV mode disable LED
			return;
	}

	if (tv_led_state && ((tv_led_state & (~(1<<flag)))== 0)) {
		//(LED is ON state) and (state will be 0 if remove flag from state)
		//printk("tv_led_offgreen [%s]\n", priv->dev->name);
		REG32(PEFGH_DAT) = (REG32(PEFGH_DAT) | (RTL_GPIOE0));
	}
	tv_led_state &= (~(1<<flag));
	//printk("OFF tv_led_state [%d]\n", tv_led_state);
	//Remove flag from state
	return;
}
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140618, TV LED End

