/*
 * FILE NAME rtl_gpio.c
 *
 * BRIEF MODULE DESCRIPTION
 *  GPIO For Flash Reload Default
 *
 *  Author: jimmylin@realtek.com.tw
 *
 *  Copyright (c) 2011 Realtek Semiconductor Corp.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 */


#include <generated/autoconf.h>
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/version.h>
#include <linux/interrupt.h>
#include <asm/errno.h>
#include <asm/io.h>
#include <asm/uaccess.h>
#include <linux/miscdevice.h>
#include <linux/pci.h>
#include <linux/delay.h>
#include <linux/slab.h>
#include <linux/sched.h>
#include <linux/init.h>
#include <linux/types.h>
#include <linux/reboot.h>
#include <linux/kmod.h>
#include <linux/proc_fs.h>
#include <linux/gpio.h>
#include <linux/device.h>
#include <linux/seq_file.h>
#include <linux/platform_device.h>
#include <linux/platform_data/rtl819x-gpio.h>
//#include <bspchip.h>

//#define CONFIG_USING_JTAG 1
#define AUTO_CONFIG

#define OLD_STYLE

//WNC-JDR230-YUAN-I-CHOU-20140421, Add LED control function
#define RL_GPIO_LED_FREQ (HZ/10)
#define RL_GPIO_NUMBER 18

#define RL_GPIO_LED_LOW_ACT		1
#define RL_GPIO_LED_INFINITY	4000

typedef struct {
	int gpio;				//gpio number
	unsigned int on;		//interval of led on
	unsigned int off;		//interval of led off
	unsigned int blinks;		//number of blinking cycles
	unsigned int rests;		//number of break cycles
	unsigned int times;		//blinking times
} rl_gpio_led_info;

struct rl_gpio_led_status_t {
	int ticks;
	unsigned int ons;
	unsigned int offs;
	unsigned int resting;
	unsigned int times;
} rl_gpio_led_stat[RL_GPIO_NUMBER];

struct timer_list rl_gpio_led_timer;
rl_gpio_led_info rl_gpio_led_data[RL_GPIO_NUMBER];

//WNC-D2R230-NMR1752-YUAN-I-CHOU-20170110, Trigger WPS End LED after 10 seconds from WPS Success LED triggered.
struct timer_list wps_over_timer;
static void wps_over_do_timer(unsigned long unused);
//WNC-D2R230-NMR1752-YUAN-I-CHOU-20170110, Trigger WPS End LED after 10 seconds from WPS Success LED triggered End.

//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160114-Add Light OFF state support
struct timer_list rl_skip_led_LOS_timer; // 3 minutes timer
int led_LOS_mode = 0;	//MIB information
int skip_LOS_mode = 1;	//Skip led_LOS_mode, turn ON all LED
int cencel_LOS_mode = 0;	//cancel led_LOS_mode flag
extern void rtl8192_led_force_off (int wlan_index, int state);	//Wireless LED function
extern int rtk_led_modeForce_set(int port, int group, int mode);	//Ethernet LED function
//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160114-Add Light OFF state support End

extern int rl_gpio_led_set(rl_gpio_led_info led);
extern void rl_gpio_led_init_timer(void);
//WNC-JDR230-YUAN-I-CHOU-20140421, Add LED control function End

/*
enabled immediate mode pbc ; must enabled "USE_INTERRUPT_GPIO" and "IMMEDIATE_PBC"
gpio will rx pbc event and trigger wscd by signal method
note:also need enabled IMMEDIATE_PBC at wsc.h (sdk/users/wsc/src/)
*/
//#define USE_INTERRUPT_GPIO	//undefine USE_INTERRUPT_GPIO
//#define IMMEDIATE_PBC 

#ifdef IMMEDIATE_PBC
int	wscd_pid = 0;
struct pid *wscd_pid_Ptr=NULL;
#endif

///////////////////////////////////////////////////////
#define PROBE_TIME	5
#define PROBE_NULL		0
#define PROBE_ACTIVE	1
#define PROBE_RESET		2
#define PROBE_RELOAD	3
#define RTL_R32(addr)		(*(volatile unsigned long *)(addr))
//WNC-JDR230-MRXXXX-Jimmy-20160804, Add to write register correctly
//#define RTL_W32(addr, l)	((*(volatile unsigned long*)(addr)) = (l))
#define RTL_W32(addr, l)		\
do {						\
	((*(volatile unsigned long*)(addr)) = (l));	\
	int round = 0;	\
	while (1)	\
	{	\
		if (l != (RTL_R32(addr)))	\
			((*(volatile unsigned long*)(addr)) = (l));	\
		else	\
			break;	\
			\
		if (++round > 10000) {	\
					printk("%s[%d] LED while (1) goes too many\n", __FUNCTION__, __LINE__);	\
					break;	\
				}	\
	}	\
} while(0)


#define RTL_R8(addr)		(*(volatile unsigned char*)(addr))
#define RTL_W8(addr, l)		((*(volatile unsigned char*)(addr)) = (l))

//#define  GPIO_DEBUG
#ifdef GPIO_DEBUG
/* note: prints function name for you */
#  define DPRINTK(fmt, args...) printk("%s: " fmt, __FUNCTION__ , ## args)
#else
#  define DPRINTK(fmt, args...)
#endif

static struct timer_list probe_timer;
static unsigned int    probe_counter;
static unsigned int    probe_state;

//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add Reset button function
static unsigned int		skip = 0;//WNC-NMRXXXX-YUAN-I-CHOU-20120503, for button control
static char 			default_flag = '2';//WNC-NMRXXXX-YUAN-I-CHOU-20120503, for default button status
//static char default_flag='0';
static int 				raku_flag = 2;
static int 				wps_flag = 2;//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140128, Reset button can't be used while WPS is running
//WNC-NMR643-JDR230-YUAN-I-CHOU-20140317, Add flag to decide when should we detect reset button behavior
static int 				sys_rdy_flag = 0;
//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add Reset button function End

//Brad add for update flash check 20080711
int start_count_time=0;
int Reboot_Wait=0;

static unsigned int wps_btn_gnum, wps_led_gnum, reset_btn_gnum, reset_led_gnum, slidesw1_gnum, slidesw2_gnum, hwid_gnum, rtl819x_gpio_actlow = 0;

//static int get_dc_pwr_plugged_state(void);

#if defined(USE_INTERRUPT_GPIO)
struct gpio_wps_device
{
	unsigned int name;
};
struct gpio_wps_device priv_gpio_wps_device;
#endif

#ifdef USE_INTERRUPT_GPIO
static int wps_button_push = 0;
#endif

int reset_button_pressed(void)
{	
	//return gpio_get_value(reset_btn_gnum) ^ (rtl819x_gpio_actlow ? 1 : 0 );
	return gpio_get_value(reset_btn_gnum) ^ (0);
}

#if 0
void reset_led_on(void)
{
	gpio_set_value(reset_led_gnum, (rtl819x_gpio_actlow ? 0 : 1));
}

void reset_led_off(void)
{
	gpio_set_value(reset_led_gnum, (rtl819x_gpio_actlow ? 1 : 0));
}
#endif

//WNC
//#ifdef AUTO_CONFIG
#if 0
static unsigned int		AutoCfg_LED_Blink;
static unsigned int		AutoCfg_LED_Toggle;
static unsigned int		AutoCfg_LED_Slow_Blink;
static unsigned int		AutoCfg_LED_Slow_Toggle;

void autoconfig_gpio_off(void)
{
	gpio_set_value(wps_led_gnum, (rtl819x_gpio_actlow ? 1 : 0));
	AutoCfg_LED_Blink = 0;
}

void autoconfig_gpio_on(void)
{
	gpio_set_value(wps_led_gnum, (rtl819x_gpio_actlow ? 0 : 1));
	AutoCfg_LED_Blink = 0;
}

void autoconfig_gpio_blink(void)
{
	gpio_set_value(wps_led_gnum, (rtl819x_gpio_actlow ? 0 : 1));
	AutoCfg_LED_Blink = 1;
	AutoCfg_LED_Toggle = 1;
    /*check if 98C support slow blink?*/
	////AutoCfg_LED_Slow_Blink = 0;
}

int autoconfig_button_pressed(void)
{
	return gpio_get_value(wps_btn_gnum) ^ (rtl819x_gpio_actlow ? 1 : 0);
}

void autoconfig_led_on(void)
{
	gpio_set_value(wps_led_gnum, (rtl819x_gpio_actlow ? 0 : 1));
}

void autoconfig_led_off(void)
{
	gpio_set_value(wps_led_gnum, (rtl819x_gpio_actlow ? 1 : 0));
}
#endif // end of AUTO_CONFIG

//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160126-Add Light OFF state support
#ifndef REG32
#define REG32(reg)		(*((volatile unsigned long *)(reg)))
#endif

#define PIN_MUX_SEL13 	0xb8000834
#define PEFGH_CNR		0xb800351c
#define PEFGH_DIR       0xb8003524
#define PEFGH_DAT       0xb8003528

/*
enum RTL8367C_LEDFORCEMODE{
    LEDFORCEMODE_NORMAL=0,
    LEDFORCEMODE_BLINK,
    LEDFORCEMODE_OFF,
    LEDFORCEMODE_ON,
    LEDFORCEMODE_END,
};
*/

void ethernet_led_ctl (int HW, int value) {
	int i = 0;

	printk("ethernet_led_ctl, HW[%d], value[%d]\n", HW, value);
	if (HW == 1) {
		// HW control LED, don't care value
		for (i = 0; i < 5; i++) {
			//(port id, LED group (we use group 1), normal mode ( 0 ))
			rtk_led_modeForce_set(i, 1, 0);
		}
	} else if (HW == 0) {
		// SW control LED, don't care value too
		for (i = 0; i < 5; i++) {
			//(port id, LED group (we use group 1), LED OFFl mode ( 2 ))
			rtk_led_modeForce_set(i, 1, 2);
		}
	}
	return;
}

void skip_los_config_set (void) {
	//Restore all LED to normal behavior

	//Restore wireless LED
	rtl8192_led_force_off(0, 2);
	rtl8192_led_force_off(1, 2);
	//Restore ethernet LED
	ethernet_led_ctl(1, 0);
}
//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160126-Add Light OFF state support End

static void rtl_gpio_timer(unsigned long data)
{
	unsigned int pressed=1;
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,27)
	struct pid *pid;
#endif

	if(reset_button_pressed() == 1) //mark_es
	{
		pressed = 0;
//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add Reset button function
#if 0
		//turn off LED0
		reset_led_off();
#endif
//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add Reset button function End
	}
	else
	{
//WNC-NMR643-JDR230-YUAN-I-CHOU-20140317, Add flag to decide when should we detect reset button behavior
		if (raku_flag == 1 || wps_flag == 1 || sys_rdy_flag == 0) {
			//rakuraku is running, ignore reset button event.
			probe_counter = 0;
		}
		printk("Key pressed %d!\n", probe_counter+1);
	}

//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add Reset button function
#if 0
	if (!autoconfig_button_pressed())
	{
#ifdef USE_INTERRUPT_GPIO
		wps_button_push = 0;
#endif
	}else{
#ifdef USE_INTERRUPT_GPIO
		wps_button_push++;
#endif
	}
#endif
//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add Reset button function End

	if (probe_state == PROBE_NULL)
	{
		if (pressed)
		{
			probe_state = PROBE_ACTIVE;
			probe_counter++;
		}
		else
			probe_counter = 0;
	}
	else if (probe_state == PROBE_ACTIVE)
	{
		if (pressed)
		{
//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add Reset button function
			rl_gpio_led_info led;
//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add Reset button function End
			probe_counter++;

//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add Reset button function
			if (!skip && (default_flag == '1') && (probe_counter >= 2)) {
				//normal state
				default_flag = '2';

//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160114-Add Light OFF state support
// Not in skip LOS mode --> trigger skip LOS mode.
// Restore wireless LED
// Add timer to switch back to LOS mode
				if (skip_LOS_mode == 0) {
					skip_LOS_mode = 1;
					skip_los_config_set();
					//Add timer
					//init_timer(&rl_skip_led_LOS_timer);
					//rl_skip_led_LOS_timer.expires = jiffies + 3*60*HZ;
					//add_timer(&rl_skip_led_LOS_timer);
					//mod_timer(&rl_skip_led_LOS_timer, jiffies + 3*60*HZ);
				}
				printk("Skip Light OFF state for 3 minutes [reset - normal]\n");
				//we would extend skip LOS timer even we are in skip LOS mode
				mod_timer(&rl_skip_led_LOS_timer, jiffies + 3*60*HZ);
//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160114-Add Light OFF state support End

				printk(" normal state \n");
//WNC-NMR1583-D2R030-Yuan-I-Chou-20160414-Turn ON LED after FLASH programming process is completed.
#if 0
				led.gpio = 4;
				led.on = 4000;
				led.off = 0;
				led.blinks = 1;
				led.rests = 0;
				led.times = 4000;
				rl_gpio_led_set(led);

				led.gpio = 5;
				led.on = 0;
				led.off = 4000;
				led.blinks = 1;
				led.rests = 0;
				led.times = 4000;
				rl_gpio_led_set(led);
#endif
//WNC-NMR1583-D2R030-Yuan-I-Chou-20160414-Turn ON LED after FLASH programming process is completed End.
				skip = 1;
//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160114-Add Light OFF state support
			} else if (!skip && (default_flag == '2') && (probe_counter == 2)) {
				// In normal state and user presses reset button 2 seconds.
				if (skip_LOS_mode == 0) {
					skip_LOS_mode = 1;
					skip_los_config_set();
					//Add timer
					//init_timer(&rl_skip_led_LOS_timer);
					//rl_skip_led_LOS_timer.expires = jiffies + 3*60*HZ;
					//add_timer(&rl_skip_led_LOS_timer);
					//mod_timer(&rl_skip_led_LOS_timer, jiffies + 3*60*HZ);
				}
				printk("Skip Light OFF state for 3 minutes [reset - init]\n");
				mod_timer(&rl_skip_led_LOS_timer, jiffies + 3*60*HZ);
//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160114-Add Light OFF state support End
			} else if (!skip && (default_flag == '2') && (probe_counter >= PROBE_TIME)) {

				//initial state
				default_flag = '1';

				printk(" initial state \n");
//WNC-NMR1583-D2R030-Yuan-I-Chou-20160414-Turn ON LED after FLASH programming process is completed.
#if 0
				led.gpio = 4;
				led.on = 0;
				led.off = 4000;
				led.blinks = 1;
				led.rests = 0;
				led.times = 4000;
				rl_gpio_led_set(led);

				led.gpio = 5;
				led.on = 5;
				led.off = 5;
				led.blinks = 2;
				led.rests = 0;
				led.times = 4000;
				rl_gpio_led_set(led);
#endif
//WNC-NMR1583-D2R030-Yuan-I-Chou-20160414-Turn ON LED after FLASH programming process is completed End.
				skip = 1;
			}
//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add Reset button function End

//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add Reset button function
#if 0
			if ((probe_counter >=2 ) && (probe_counter <=PROBE_TIME))
			{
				DPRINTK("2-5 turn on led\n");
				//turn on LED0
				reset_led_on();
			}
			else if (probe_counter >= PROBE_TIME)
			{
				// sparkling LED0
				DPRINTK(">5 \n");
				if (probe_counter & 1)
				{ 				
					reset_led_off();
				}	
				else
				{
					reset_led_on();
				}	
			}
#endif
//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add Reset button function End
		}
		else
		{
//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add Reset button function
			probe_state = PROBE_NULL;
			probe_counter = 0;
			skip = 0;
//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add Reset button function End
//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add Reset button function
#if 0
			if (probe_counter < 2)
			{
				probe_state = PROBE_NULL;
				probe_counter = 0;
				DPRINTK("<2 \n");
				#if defined(CONFIG_RTL865X_SC)
					ResetToAutoCfgBtn = 1;
				#endif
			}
			else if (probe_counter >= PROBE_TIME)
			{
				//reload default
				default_flag = '1';
				//kernel_thread(reset_flash_default, (void *)1, SIGCHLD);
				return;
			}
			else
			{
				DPRINTK("2-5 reset 1\n");
			#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,27)
				kill_proc(1,SIGTERM,1);
			#else
				pid = get_pid(find_vpid(1));
				kill_pid(pid,SIGTERM,1);
			#endif
				DPRINTK("2-5 reset 2\n");
				//kernel_thread(reset_flash_default, 0, SIGCHLD);
				return;
			}
#endif
//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add Reset button function End
		}
	}

//WNC
//#ifdef AUTO_CONFIG
#if 0
	if (AutoCfg_LED_Blink==1)
	{
		if (AutoCfg_LED_Toggle) {
			autoconfig_led_off();
		}
		else {
			autoconfig_led_on();
		}
				
		if(AutoCfg_LED_Slow_Blink)
		{
			if(AutoCfg_LED_Slow_Toggle)
				AutoCfg_LED_Toggle = AutoCfg_LED_Toggle;
			else
				AutoCfg_LED_Toggle = AutoCfg_LED_Toggle? 0 : 1;
			
			AutoCfg_LED_Slow_Toggle = AutoCfg_LED_Slow_Toggle? 0 : 1;
		}
		else
			AutoCfg_LED_Toggle = AutoCfg_LED_Toggle? 0 : 1;
		
	}
#endif	/* AUTO_CONFIG */

	mod_timer(&probe_timer, jiffies + HZ);
}

#ifdef CONFIG_RTL_FLASH_DUAL_IMAGE_ENABLE

#define SYSTEM_CONTRL_DUMMY_REG 0xb8003504

int is_bank2_root()
{
	//boot code will steal System's dummy register bit0 (set to 1 ---> bank2 booting
	//for 8198 formal chip 
	
	if ((RTL_R32(SYSTEM_CONTRL_DUMMY_REG)) & (0x00000001))  // steal for boot bank idenfy
		return 1;
	
	return 0;
}
static int read_bootbank_proc(struct seq_file *s, void *v)
{
	int len;
	char flag='1';

	if (is_bank2_root())  // steal for boot bank idenfy
		flag='2';


	seq_printf(s,"%c\n", flag);

	return 0;
#if 0		
	len = sprintf(page, "%c\n", flag);

	if (len <= off+count) *eof = 1;
	*start = page + off;
	len -= off;
	if (len > count) len = count;
	if (len < 0) len = 0;
	return len;
#endif
}

int bootbank_open(struct inode *inode, struct file *file)
{
        return(single_open(file, read_bootbank_proc, NULL));
}

struct file_operations bootbank_proc_fops = {
        .open           = bootbank_open,
        .read            = seq_read,
        .llseek          = seq_lseek,
        .release        = single_release,
};

#endif


#ifdef AUTO_CONFIG
#if defined(USE_INTERRUPT_GPIO)
static irqreturn_t gpio_interrupt_isr(int irq, void *dev_instance)
{
	DPRINTK("gpio irq %d interrupt triggered\n", irq);
	wps_button_push = 1; 		

#ifdef IMMEDIATE_PBC
	if(wscd_pid>0)
	{
		rcu_read_lock();
		wscd_pid_Ptr = get_pid(find_vpid(wscd_pid));
		rcu_read_unlock();	

		if(wscd_pid_Ptr){
			printk("(%s %d);signal wscd ;pid=%d\n",__FUNCTION__ , __LINE__,wscd_pid);			
			kill_pid(wscd_pid_Ptr, SIGUSR2, 1);
			
		}
	}
#endif

	return IRQ_HANDLED;
}
#endif /* USE_INTERRUPT_GPIO */

// WNC-MRXXXX-Yuan-I-Chou-20140421-separate GPIO and LED GPIO proc file
static int read_led_proc(struct seq_file *s, void *v)
{
	//int len;
	char flag = 0;

	flag = '1';
	seq_printf(s, "%c\n", flag);
	return 0;
}
//WNC-JDR230-YUAN-I-CHOU-20140421, Add LED control function End

// WNC-MRXXXX-David-20140421-add reset button proc-Start
static int read_proc_reset_btn(struct seq_file *s, void *v)
{
	//int len;
	char flag = 0;

	//if (gpio_get_value(reset_btn_gnum) ^ (rtl819x_gpio_actlow ? 1 : 0 )) {
	if (gpio_get_value(reset_btn_gnum) ^ (0)) {
		flag = '0';
	} else {
		flag = '1';
	}

	seq_printf(s, "%c\n", flag);
	return 0;
}
// WNC-MRXXXX-David-20140421-add reset button proc-End

//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add Slide switch function
//static int read_proc_slide_sw(char *page, char **start, off_t off, int count, int *eof, void *data)
static int read_proc_slide_sw(struct seq_file *s, void *v)
{
	//int len;
	char flag = 0;

	//[D0][D1]
	//RT : 11, CNV : 10, AP : 01, 

	//if (gpio_get_value(slidesw1_gnum) ^ (rtl819x_gpio_actlow ? 1 : 0 ))
	if (gpio_get_value(slidesw1_gnum) ^ (0))
	{
		flag |= 0x10;
	}
	//if (gpio_get_value(slidesw2_gnum) ^ (rtl819x_gpio_actlow ? 1 : 0 ))
	if (gpio_get_value(slidesw2_gnum) ^ (0))
	{
		flag |= 0x01;
	}

	seq_printf(s, "%X\n", flag);
	return 0;

}
//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add Slide switch function End

//WNC-NMR160,357-JDR230-YUAN-I-CHOU-20130327, Reset button can't be used while RakuRaku is running
static int raku_read_proc(struct seq_file *s, void *v)
{
	seq_printf(s, "%d\n", raku_flag);
	return 0;
}
//WNC-NMR160,357-JDR230-YUAN-I-CHOU-20130327, Reset button can't be used while RakuRaku is running End

//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140128, Reset button can't be used while WPS is running
static int wps_read_proc(struct seq_file *s, void *v)
{
	seq_printf(s, "%d\n", wps_flag);
	return 0;
}
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140128, Reset button can't be used while WPS is running

//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add MODEL ID function
static int read_proc_modelid(struct seq_file *s, void *v)
{
	short flag = 0;

	if (gpio_get_value(hwid_gnum) ^ (0)) {
		flag = '1';
	} else {
		flag = '0';
	}

	seq_printf(s, "%c\n", flag);
	return 0;
}
//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add MODEL ID function End

//static int read_proc(char *page, char **start, off_t off, int count, int *eof, void *data)
static int read_proc(struct seq_file *s, void *v)
{
//	int len;
	char flag;

#if  defined(USE_INTERRUPT_GPIO)
// 2009-0414		
	if (wps_button_push) {
		flag = '1';
		//wps_button_push = 0; //mark it for select wlan interface by button pressed time		
	}
	else{
//WNC
		//if (gpio_get_value(wps_btn_gnum) ^ (rtl819x_gpio_actlow ? 1 : 0 )) {
		if (gpio_get_value(wps_btn_gnum) ^ (0)) {
			flag = '0';
		}else{
			//printk("wps button be held \n");
			flag = '1';
		}
	}
// 2009-0414		
#else

//WNC
	//if (gpio_get_value(wps_btn_gnum) ^ (rtl819x_gpio_actlow ? 1 : 0 ))
	if (gpio_get_value(wps_btn_gnum) ^ (0))
		flag = '0';
	else 
		flag = '1';
	
#endif // CONFIG_RTL865X_KLD					
//	len = sprintf(page, "%c\n", flag);
	seq_printf(s, "%c\n", flag);
	return 0;	
}

#ifdef CONFIG_RTL_KERNEL_MIPS16_CHAR
__NOMIPS16
#endif 

// WNC-MRXXXX-Yuan-I-Chou-20140421-separate GPIO and LED GPIO proc file
/* NMR1568-20160408-Fix bug 1568 [Spider] The time from detection to light-on is little long-start */

#define GN_TV_LED_R 23
#define GN_CNV_LED_R 26
#define GN_CNV_LED_G 27
#define GN_TV_LED_G 28
#define GN_5G_LED_G 29
#define GN_2G_LED_G 30
#define GN_ACT_LED_G 31
#define GN_POWER_LED_G 32
#define GN_POWER_LED_R 33
#define GN_ACT_LED_R 54
#define GN_2G_LED_R 56
#define GN_5G_LED_R 57

#define RTL_GPIOC7 (1<<23)
#define RTL_GPIOD2 (1<<26)
#define RTL_GPIOD3 (1<<27)
#define RTL_GPIOD4 (1<<28)
#define RTL_GPIOD5 (1<<29)
#define RTL_GPIOD6 (1<<30)
#define RTL_GPIOD7 (1<<31)
#define RTL_GPIOE0 (1<<0)
#define RTL_GPIOE1 (1<<1)
#define RTL_GPIOG6 (1<<22)
#define RTL_GPIOH0 (1<<24)
#define RTL_GPIOH1 (1<<25)
#define PABCD_DAT		0xB800350C


void __LED_ON(int led_num)
{
	int gpio_num = 0; 
	//printk("__LED_ON [%d]\n", led_num);

	switch (led_num) {
		case 0: //ACTIVE RED, high active, G6
			#ifdef OLD_STYLE
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) | (RTL_GPIOG6)));
			#else
			__gpio_set_value(GN_ACT_LED_R, 1);
			#endif
			break;
		case 1: //ACTIVE GREEN, low active, D7
			#ifdef OLD_STYLE
			RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) & (~(RTL_GPIOD7))));
			#else
			__gpio_set_value(GN_ACT_LED_G, 0);
			#endif
			break;
		case 2: //2.4G RED, high active, H0
			#ifdef OLD_STYLE
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) | (RTL_GPIOH0)));
			#else
			__gpio_set_value(GN_2G_LED_R, 1);
			#endif
			break;
		case 3: //2.4G GREEN, low active, D6
			#ifdef OLD_STYLE
			RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) & (~(RTL_GPIOD6))));
			#else
			__gpio_set_value(GN_2G_LED_G, 0);
			#endif
			break;
		case 4: //POWER GREEN, high active, E0
			#ifdef OLD_STYLE
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) | (RTL_GPIOE0)));
			#else
			__gpio_set_value(GN_POWER_LED_G, 1);
			#endif
			break;
		case 5: //POWER RED, high active, E1
			#ifdef OLD_STYLE
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) | (RTL_GPIOE1)));
			#else
			__gpio_set_value(GN_POWER_LED_R, 1);
			#endif
			break;
		case 6: //5G RED, high active, H1
			#ifdef OLD_STYLE
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) | (RTL_GPIOH1)));
			#else
			__gpio_set_value(GN_5G_LED_R, 1);
			#endif
			break;
		case 7: //5G GREEN, low active, D5
			#ifdef OLD_STYLE
			RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) & (~(RTL_GPIOD5))));
			#else
			__gpio_set_value(GN_5G_LED_G, 0);
			#endif
			break;
		//Combination...
		case 8: //All GREEN LEDs
			#ifdef OLD_STYLE
			RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) & (~(RTL_GPIOD7 | RTL_GPIOD6 | RTL_GPIOD5 | RTL_GPIOD4 | RTL_GPIOD3))));
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) | (RTL_GPIOE0)));
			#else
			__gpio_set_value(GN_ACT_LED_G, 0);
			__gpio_set_value(GN_2G_LED_G, 0);
			__gpio_set_value(GN_POWER_LED_G, 1);
			__gpio_set_value(GN_5G_LED_G, 0);
			#endif
			break;
		case 9: //POWER GREEN + POWER RED
			#ifdef OLD_STYLE
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) | (RTL_GPIOE0 | RTL_GPIOE1)));
			#else
			__gpio_set_value(GN_POWER_LED_G, 1);
			__gpio_set_value(GN_POWER_LED_R, 1);
			#endif
			break;
		case 10: //ACTIVE GREEN + ACTIVE RED
			#ifdef OLD_STYLE
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) | (RTL_GPIOG6)));
			RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) & (~(RTL_GPIOD7))));
			#else
			__gpio_set_value(GN_ACT_LED_G, 0);
			__gpio_set_value(GN_ACT_LED_R, 1);
			#endif
			break;
		case 11: //All GREEN LEDs except Power GREEN
			#ifdef OLD_STYLE
			RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) & (~(RTL_GPIOD7 | RTL_GPIOD6 | RTL_GPIOD5 | RTL_GPIOD4 | RTL_GPIOD3))));
			#else
			__gpio_set_value(GN_ACT_LED_G, 0);
			__gpio_set_value(GN_2G_LED_G, 0);
			__gpio_set_value(GN_5G_LED_G, 0);
			#endif
			break;
		//Combination End...
		case 12: //TV GREEN, low active, D4
			#ifdef OLD_STYLE
			RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) & (~(RTL_GPIOD4))));
			#else
			__gpio_set_value(GN_TV_LED_G, 0);
			#endif
			break;
		case 13: //TV RED, high active, C7
			#ifdef OLD_STYLE
			RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) | (RTL_GPIOC7)));
			#else
			__gpio_set_value(GN_TV_LED_R, 1);
			#endif
			break;
		case 14: //CNV RED, low active, D2
			#ifdef OLD_STYLE
			RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) & (~(RTL_GPIOD2))));
			#else
			__gpio_set_value(GN_CNV_LED_R, 0);
			#endif
			break;
		case 15: //CNV GREEN, low active, D3
			#ifdef OLD_STYLE
			RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) & (~(RTL_GPIOD3))));
			#else
			__gpio_set_value(GN_CNV_LED_G, 0);
			#endif
			break;
		case 16: //5G RED and TV RED
			#ifdef OLD_STYLE
			RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) | (RTL_GPIOC7)));//TV RED
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) | (RTL_GPIOH1)));//5G RED
			#else
			__gpio_set_value(GN_TV_LED_R, 1);
			__gpio_set_value(GN_5G_LED_R, 1);
			#endif
			break;
		case 17: //2.4G GREEN and 2.4G RED
			#ifdef OLD_STYLE
				RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) & (~(RTL_GPIOD6))));//2.4G Green
				RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) | (RTL_GPIOH0)));//2.4G Red
			#else
				__gpio_set_value(GN_2G_LED_G, 0);
				__gpio_set_value(GN_2G_LED_R, 1);
			#endif
				break;

		default: // ???
			break;
	}
}

void __LED_OFF(int led_num)
{
	int gpio_num = 0; 
	//printk("__LED_OFF [%d]\n", led_num);

	switch (led_num) {
		case 0: //ACTIVE RED, high active, G6
			#ifdef OLD_STYLE
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) & (~(RTL_GPIOG6))));
			#else
			__gpio_set_value(GN_ACT_LED_R, 0);
			#endif
			break;
		case 1: //ACTIVE GREEN, low active, D7
			#ifdef OLD_STYLE
			RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) | (RTL_GPIOD7)));
			#else
			__gpio_set_value(GN_ACT_LED_G, 1);
			#endif
			break;
		case 2: //2.4G RED, high active, H0
			#ifdef OLD_STYLE
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) & (~(RTL_GPIOH0))));
			#else
			__gpio_set_value(GN_2G_LED_R, 0);
			#endif
			break;
		case 3: //2.4G GREEN, low active, D6
			#ifdef OLD_STYLE
			RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) | (RTL_GPIOD6)));
			#else
			__gpio_set_value(GN_2G_LED_G, 1);
			#endif
			break;
		case 4: //POWER GREEN, high active, E0
			#ifdef OLD_STYLE
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) & (~(RTL_GPIOE0))));
			#else
			__gpio_set_value(GN_POWER_LED_G, 0);
			#endif
			break;
		case 5: //POWER RED, high active, E1
			#ifdef OLD_STYLE
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) & (~(RTL_GPIOE1))));
			#else
			__gpio_set_value(GN_POWER_LED_R, 0);
			#endif
			break;
		case 6: //5G RED, high active, H1
			#ifdef OLD_STYLE
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) & (~(RTL_GPIOH1))));
			#else
			__gpio_set_value(GN_5G_LED_R, 0);
			#endif
			break;
		case 7: //5G GREEN, low active, D5
			#ifdef OLD_STYLE
			RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) | (RTL_GPIOD5)));
			#else
			__gpio_set_value(GN_5G_LED_G, 1);
			#endif
			break;
		//Combination...
		case 8: //All GREEN LEDs
			#ifdef OLD_STYLE
			RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) | (RTL_GPIOD7 | RTL_GPIOD6 | RTL_GPIOD5 | RTL_GPIOD4 | RTL_GPIOD3)));
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) & (~(RTL_GPIOE0))));
			#else
			__gpio_set_value(GN_ACT_LED_G, 1);
			__gpio_set_value(GN_2G_LED_G, 1);
			__gpio_set_value(GN_POWER_LED_G, 0);
			__gpio_set_value(GN_5G_LED_G, 1);
			#endif
			break;
		case 9: //POWER GREEN + POWER RED
			#ifdef OLD_STYLE
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) & (~(RTL_GPIOE0 | RTL_GPIOE1))));
			#else
			__gpio_set_value(GN_POWER_LED_G, 0);
			__gpio_set_value(GN_POWER_LED_R, 0);
			#endif
			break;
		case 10: //ACTIVE GREEN + ACTIVE RED
			#ifdef OLD_STYLE
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) & (~(RTL_GPIOG6))));
			RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) | (RTL_GPIOD7)));
			#else
			__gpio_set_value(GN_ACT_LED_G, 1);
			__gpio_set_value(GN_ACT_LED_R, 0);
			#endif
			break;
		case 11: //All GREEN LEDs except Power GREEN
			#ifdef OLD_STYLE
			RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) | (RTL_GPIOD7 | RTL_GPIOD6 | RTL_GPIOD5 | RTL_GPIOD4 | RTL_GPIOD3)));
			#else
			__gpio_set_value(GN_ACT_LED_G, 1);
			__gpio_set_value(GN_2G_LED_G, 1);
			__gpio_set_value(GN_5G_LED_G, 1);
			#endif
			break;
		//Combination End...
		case 12: //TV GREEN, low active, D4
			#ifdef OLD_STYLE
			RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) | (RTL_GPIOD4)));
			#else
			__gpio_set_value(GN_TV_LED_G, 1);
			#endif
			break;
		case 13: //TV RED, high active, C7
			#ifdef OLD_STYLE
			RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) & (~(RTL_GPIOC7))));
			#else
			__gpio_set_value(GN_TV_LED_R, 0);
			#endif
			break;
		case 14: //CNV RED, low active, D2
			#ifdef OLD_STYLE
			RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) | (RTL_GPIOD2)));
			#else
			__gpio_set_value(GN_CNV_LED_R, 1);
			#endif
			break;
		case 15: //CNV GREEN, low active, D3
			#ifdef OLD_STYLE
			RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) | (RTL_GPIOD3)));
			#else
			__gpio_set_value(GN_CNV_LED_G, 1);
			#endif
			break;
		case 16: //5G RED and TV RED
			#ifdef OLD_STYLE
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) & (~(RTL_GPIOH1))));
			RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) & (~(RTL_GPIOC7))));
			#else
			__gpio_set_value(GN_5G_LED_R, 0);
			__gpio_set_value(GN_TV_LED_R, 0);
			#endif
			break;
			case 17: //2.4G GREEN and 2.4G RED
			#ifdef OLD_STYLE
			RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) | (RTL_GPIOD6)));//2.4G Green
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) & (~(RTL_GPIOH0))));//2.4G Red
			#else
			__gpio_set_value(GN_2G_LED_G, 1);
			__gpio_set_value(GN_2G_LED_R, 0);
			#endif
			break;

		default: // ???
			break;
	}
}

static int write_led_proc(struct file *file, const char *buffer, unsigned long count, void *data)
{
	unsigned char led_command[100];

	memset(led_command, '\0', 100);

	if (count < 2)
		return -EFAULT;

	//printk("write_led_proc: %s\n", buffer);

//LED configuration
	rl_gpio_led_info led;
	if (buffer && !copy_from_user(&led_command, buffer, 100)) {
//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160114-Add Light OFF state support
//LOS=X, X = MIB infomation = led_LOS_mode
		if (!strncmp(led_command, "LOS=", 4)) {
			led_LOS_mode = led_command[4] - '0';
			printk("led_LOS_mode = [%d]\n", led_LOS_mode);
		} else if (!strncmp(led_command, "SLOS", 4)) {
//SLOS = Skip LOS mode
			printk("Skip Light OFF state for 3 minutes [via cli]\n");
			if (skip_LOS_mode == 0) {
				skip_LOS_mode = 1;
				skip_los_config_set();
				//Reset timer to 3 minutes
				//init_timer(&rl_skip_led_LOS_timer);
				//rl_skip_led_LOS_timer.expires = jiffies + 3*60*HZ;
				//add_timer(&rl_skip_led_LOS_timer);
				//mod_timer(&rl_skip_led_LOS_timer, jiffies + 3*60*HZ);
			}
			//we would extend skip LOS timer even we are in skip LOS mode
			mod_timer(&rl_skip_led_LOS_timer, jiffies + 3*60*HZ);
		} else if (!strncmp(led_command, "CLOS", 4)) {
//CLOS = Cancel LOS mode
			if (cencel_LOS_mode == 0) {
				printk("Cancel Light OFF state\n");
				if (skip_LOS_mode == 0) {
					//Not in Skip LOS mode --> no skip_led_LOS_timer
					skip_LOS_mode = 1;
					skip_los_config_set();
				} else {
					//in Skip LOS mode or cancel LOS mode
					if (timer_pending(&rl_skip_led_LOS_timer)) {
						//in Skip LOS mode, remove timer
						del_timer(&rl_skip_led_LOS_timer);
						//needed?
						skip_LOS_mode = 1;
						skip_los_config_set();
					}
				}
				cencel_LOS_mode = 1;
			}
		} else if (!strncmp(led_command, "RLOS", 4)) {
//RLOS = Recover LOS mode
			if (cencel_LOS_mode == 1) {
				printk("Restore Light OFF state behavior\n");

				skip_LOS_mode = 0;	//Cancel Skip LOS mode flag
				if (led_LOS_mode != 0) {
					//Disable Wireless LED function
					rtl8192_led_force_off(0, 0);
					rtl8192_led_force_off(1, 0);
					//Disable Ethernet LED (HW control -> SW control and OFF)
					ethernet_led_ctl(0, 1);
				}
				cencel_LOS_mode = 0;
			}
		} else {
			if (!sscanf(&led_command, "%ld %ld %ld %ld %ld %ld\n", 
				&led.gpio,&led.on,&led.off,&led.blinks,&led.rests,&led.times))
			return -EINVAL;

			//printk("led_command %s\n", led_command);
			rl_gpio_led_set(led);
		}
//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160114-Add Light OFF state support End
		return count;
	}
	else
		return -EFAULT;
	
}
// WNC-MRXXXX-Yuan-I-Chou-20140421-End

//WNC-JDR230-NMRXXXX-Yuan-I-Chou-20140421-WPS LED control
int handle_wps_led(int flag)
{
	rl_gpio_led_info led;

	printk(" handle_wps_led [%d]\n", flag);
	switch (flag) {
		case 9:				//END
			led.gpio = 5;	//Power RED LED OFF
			led.on = 0;
			led.off = 4000;
			led.blinks = 1;
			led.rests = 0;
			led.times = 4000;
			rl_gpio_led_set(led);
			led.gpio = 4;	//Power Green LED ON
			led.on = 4000;
			led.off = 0;
			led.blinks = 1;
			led.rests = 0;
			led.times = 4000;
			rl_gpio_led_set(led);
			break;
		case 2:
			led.gpio = 4;	//Power Green LED blink 2 minutes
			led.on = 5;
			led.off = 5;
			led.blinks = 2;
			led.rests = 0;
			led.times = 120;
			rl_gpio_led_set(led);
			break;
		case 8:				//ERROR
			led.gpio = 4;	//Power Green LED OFF
			led.on = 0;
			led.off = 4000;
			led.blinks = 1;
			led.rests = 0;
			led.times = 4000;
			rl_gpio_led_set(led);
			led.gpio = 5;	//Power Red LED blink 1 time
			led.on = 100;
			led.off = 0;
			led.blinks = 1;
			led.rests = 0;
			led.times = 1;
			rl_gpio_led_set(led);
			break;
		case 7:				//SUCCESS
			led.gpio = 4;	//Power Green LED blink 1 time
			led.on = 100;
			led.off = 0;
			led.blinks = 1;
			led.rests = 0;
			led.times = 1;
			rl_gpio_led_set(led);
			led.gpio = 5;	//Power Red LED blink 1 time
			led.on = 100;
			led.off = 0;
			led.blinks = 1;
			led.rests = 0;
			led.times = 1;
			rl_gpio_led_set(led);

//WNC-D2R230-NMR1752-YUAN-I-CHOU-20170110, Trigger WPS End LED after 10 seconds from WPS Success LED triggered.
			if (timer_pending(&wps_over_timer)) {
				del_timer(&wps_over_timer);
			}

			init_timer(&wps_over_timer);
			wps_over_timer.data = (unsigned long)NULL;
			wps_over_timer.function = &wps_over_do_timer;
			wps_over_timer.expires = jiffies + 10 * HZ;
			mod_timer(&wps_over_timer, jiffies + 10 * HZ);
//WNC-D2R230-NMR1752-YUAN-I-CHOU-20170110, Trigger WPS End LED after 10 seconds from WPS Success LED triggered End.

			break;
		case 6:				//OVERLAPPED
			led.gpio = 4;	//Power Green LED OFF
			led.on = 0;
			led.off = 4000;
			led.blinks = 1;
			led.rests = 0;
			led.times = 4000;
			rl_gpio_led_set(led);
			led.gpio = 5;	//Power Red LED blink patterm for 10 period
			led.on = 1;
			led.off = 1;
			led.blinks = 10;
			led.rests = 5;
			led.times = 10;
			rl_gpio_led_set(led);
			break;
	}
}
//WNC-JDR230-NMRXXXX-Yuan-I-Chou-20140421-WPS LED control End

//WNC-D2R230-NMR1752-YUAN-I-CHOU-20170110, Trigger WPS End LED after 10 seconds from WPS Success LED triggered.
static void wps_over_do_timer(unsigned long unused)
{
	printk("WPS over timer triggered\n");
	handle_wps_led(9);
	return;
}
//WNC-D2R230-NMR1752-YUAN-I-CHOU-20170110, Trigger WPS End LED after 10 seconds from WPS Success LED triggered End.

static int write_proc(struct file *file, const char *buffer, unsigned long count, void *data)
{
	char flag[20];
//Brad add for update flash check 20080711

	char start_count[10], wait[10];

	if (count < 2)
		return -EFAULT;

	DPRINTK("file: %08x, buffer: %s, count: %lu, data: %08x\n",
		(unsigned int)file, buffer, count, (unsigned int)data);

	if (buffer && !copy_from_user(&flag, buffer, 1)) {
		if (flag[0] == 'E') {
			/* Fix me, if autoconfig_gpio_init() needed again */
		}
//WNC-NMR643-JDR230-YUAN-I-CHOU-20140317, Add flag to decide when should we detect reset button behavior
		else if (flag[0] == 'z') {
			sys_rdy_flag = 1;
		}
//WNC-NMR643-JDR230-YUAN-I-CHOU-20140317, Add flag to decide when should we detect reset button behavior End

//WNC-JDR230-NMRXXXX-Yuan-I-Chou-20140421-WPS LED control
		else if (flag[0] == '9')	//END
			handle_wps_led(9);
		else if (flag[0] == '7')	//SUCCESS
			handle_wps_led(7);
		else if (flag[0] == '6')	//OVERLAPPED
			handle_wps_led(6);
		else if (flag[0] == '2')
			handle_wps_led(2);
		else if (flag[0] == '8')	//ERROR
			handle_wps_led(8);
#if 0
		else if (flag[0] == '0')
			autoconfig_gpio_off();
		else if (flag[0] == '1')
			autoconfig_gpio_on();
		else if (flag[0] == '2')
			autoconfig_gpio_blink();
#endif
//WNC-JDR230-NMRXXXX-Yuan-I-Chou-20140421-WPS LED control End
//Brad add for update flash check 20080711
		else if (flag[0] == '4'){
			start_count_time= 1;
			sscanf(buffer, "%s %s", start_count, wait);
			Reboot_Wait = (simple_strtol(wait,NULL,0))*100;
		}

		else
			{}

		return count;
	}
	else
		return -EFAULT;
}
#ifdef IMMEDIATE_PBC
static unsigned long atoi_dec(char *s)
{
	unsigned long k = 0;

	k = 0;
	while (*s != '\0' && *s >= '0' && *s <= '9') {
		k = 10 * k + (*s - '0');
		s++;
	}
	return k;
}
static int read_gpio_wscd_pid(char *page, char **start, off_t off,
				int count, int *eof, void *data)
{
	int len;
	char flag;

	DPRINTK("wscd_pid=%d\n",wscd_pid);	
	
	len = sprintf(page, "%d\n", wscd_pid);
	if (len <= off+count) *eof = 1;
	*start = page + off;
	len -= off;
	if (len > count) len = count;
	if (len < 0) len = 0;
	return len;
}
static int write_gpio_wscd_pid(struct file *file, const char *buffer,
				unsigned long count, void *data)
{
	char flag[20];
	char start_count[10], wait[10];
	if (count < 2)
		return -EFAULT;

	DPRINTK("file: %08x, buffer: %s, count: %lu, data: %08x\n",
		(unsigned int)file, buffer, count, (unsigned int)data);

	if (buffer && !copy_from_user(&flag, buffer, 1)) {

		wscd_pid = atoi_dec(buffer);
		DPRINTK("wscd_pid=%d\n",wscd_pid);	
		return count;
	}
	else{
		return -EFAULT;
	}
}
#endif
#endif // AUTO_CONFIG

//static int default_read_proc(char *page, char **start, off_t off, int count, int *eof, void *data)
static int default_read_proc(struct seq_file *s, void *v)
{
#if 0
	int len;

	len = sprintf(page, "%c\n", default_flag);
	if (len <= off+count) *eof = 1;
	  *start = page + off;
	len -= off;
	if (len>count) len = count;
	if (len<0) len = 0;
	  return len;
#else
	seq_printf(s, "%c\n", default_flag);
	return 0;
#endif
}

#ifdef CONFIG_RTL_KERNEL_MIPS16_CHAR
__NOMIPS16
#endif 
static int default_write_proc(struct file *file, const char *buffer,
				unsigned long count, void *data)
{
	if (count < 2)
		return -EFAULT;
	if (buffer && !copy_from_user(&default_flag, buffer, 1)) {
		return count;
	}
	return -EFAULT;
}

//WNC-NMR160,357-JDR230-YUAN-I-CHOU-20130327, Reset button can't be used while RakuRaku is running
#ifdef CONFIG_RTL_KERNEL_MIPS16_CHAR
__NOMIPS16
#endif 
static int raku_write_proc(struct file *file, const char *buffer, unsigned long count, void *data)
{
	char flag = 0;

	if (count < 2)
		return -EFAULT;
	if (buffer && !copy_from_user(&flag, buffer, 1)) {
		//printk("raku_flagc = %c\n", flag);
		raku_flag = flag - '0';
		//printk("raku_flag = %d\n", raku_flag);
		return count;
	}
	return -EFAULT;
}
//WNC-NMR160,357-JDR230-YUAN-I-CHOU-20130327, Reset button can't be used while RakuRaku is running End

//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140128, Reset button can't be used while WPS is running
#ifdef CONFIG_RTL_KERNEL_MIPS16_CHAR
__NOMIPS16
#endif 
static int wps_write_proc(struct file *file, const char *buffer, unsigned long count, void *data)
{
	char flag = 0;

	if (count < 2)
		return -EFAULT;
	if (buffer && !copy_from_user(&flag, buffer, 1)) {
		//printk("wps_flagc = %c\n", flag);
		wps_flag = flag - '0';
		//printk("wps_flag = %d\n", wps_flag);
		return count;
	}
	return -EFAULT;
}
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140128, Reset button can't be used while WPS is running End

#ifdef CONFIG_PROC_FS

extern struct proc_dir_entry proc_root;

int gpio_single_open(struct inode *inode, struct file *file)
{
        return(single_open(file, read_proc, NULL));
}

static ssize_t gpio_single_write(struct file * file, const char __user * userbuf,
		     size_t count, loff_t * off)
{
	return write_proc(file, userbuf,count, off);
}


struct file_operations gpio_proc_fops = {
        .open           = gpio_single_open,
	 .write		= gpio_single_write,
        .read           = seq_read,
        .llseek         = seq_lseek,
        .release        = single_release,
};

int load_default_single_open(struct inode *inode, struct file *file)
{
        return(single_open(file, default_read_proc, NULL));
}

static ssize_t load_default_single_write(struct file * file, const char __user * userbuf,
		     size_t count, loff_t * off)
{
	return default_write_proc(file, userbuf,count, off);
}

struct file_operations load_default_proc_fops = {
        .open           = load_default_single_open,
	 .write           = load_default_single_write,
        .read            = seq_read,
        .llseek          = seq_lseek,
        .release        = single_release,
};

//WNC
int wpsrun_single_open(struct inode *inode, struct file *file)
{
        return(single_open(file, wps_read_proc, NULL));
}

static ssize_t wpsrun_single_write(struct file * file, const char __user * userbuf,
		     size_t count, loff_t * off)
{
	return wps_write_proc(file, userbuf,count, off);
}

struct file_operations wpsrun_proc_fops = {
        .open           = wpsrun_single_open,
	 	.write           = wpsrun_single_write,
        .read            = seq_read,
        .llseek          = seq_lseek,
        .release        = single_release,
};

int rakurun_single_open(struct inode *inode, struct file *file)
{
        return(single_open(file, raku_read_proc, NULL));
}

static ssize_t rakurun_single_write(struct file * file, const char __user * userbuf,
		     size_t count, loff_t * off)
{
	return raku_write_proc(file, userbuf,count, off);
}

struct file_operations rakurun_proc_fops = {
        .open           = rakurun_single_open,
	 	.write           = rakurun_single_write,
        .read            = seq_read,
        .llseek          = seq_lseek,
        .release        = single_release,
};

int ledgpio_single_open(struct inode *inode, struct file *file)
{
        return(single_open(file, read_led_proc, NULL));
}

static ssize_t ledgpio_single_write(struct file * file, const char __user * userbuf,
		     size_t count, loff_t * off)
{
	return write_led_proc(file, userbuf,count, off);
}

struct file_operations ledgpio_proc_fops = {
        .open           = ledgpio_single_open,
	 	.write           = ledgpio_single_write,
        .read            = seq_read,
        .llseek          = seq_lseek,
        .release        = single_release,
};

int reset_btn_single_open(struct inode *inode, struct file *file)
{
        return(single_open(file, read_proc_reset_btn, NULL));
}

struct file_operations reset_btn_proc_fops = {
        .open           = reset_btn_single_open,
        .read            = seq_read,
        .llseek          = seq_lseek,
        .release        = single_release,
};

int modelid_single_open(struct inode *inode, struct file *file)
{
        return(single_open(file, read_proc_modelid, NULL));
}

struct file_operations modelid_proc_fops = {
        .open           = modelid_single_open,
        .read            = seq_read,
        .llseek          = seq_lseek,
        .release        = single_release,
};

//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add Slide switch function
int slide_sw_single_open(struct inode *inode, struct file *file)
{
        return(single_open(file, read_proc_slide_sw, NULL));
}

struct file_operations slide_sw_proc_fops = {
        .open           = slide_sw_single_open,
        .read            = seq_read,
        .llseek          = seq_lseek,
        .release        = single_release,
};
//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add Slide switch function End


#endif

#if 0 // example
struct proc_dir_entry *hostap_proc;

static int __init hostap_init(void)
{
	if (init_net.proc_net != NULL) {
		hostap_proc = proc_mkdir("rtl865x", &proc_root);
		if (!hostap_proc)
			printk(KERN_WARNING "Failed to mkdir "
			       "/proc/rtl865x\n");
	} else
		hostap_proc = NULL;

	return 0;
}

static void __exit hostap_exit(void)
{
	if (hostap_proc != NULL) {
		hostap_proc = NULL;
		remove_proc_entry("rtl865x", &proc_root);
	}
}
#endif

int __init rtl_gpio_init(void)
{
#if defined(USE_INTERRUPT_GPIO)
	int irq, err;
#endif

#if defined(IMMEDIATE_PBC)
	struct proc_dir_entry *res=NULL;
#endif

	printk("Realtek GPIO Driver for Flash Reload Default\n");

	#if defined(USE_INTERRUPT_GPIO)
	if((irq = gpio_to_irq(wps_btn_gnum)) < 0)
		printk(KERN_ERR "error: gpio to irq%d failed!\n", irq);
       
	if((err = request_irq(irq, gpio_interrupt_isr, IRQF_SHARED | IRQF_TRIGGER_FALLING
			, "wps btn", (void *)&priv_gpio_wps_device)))
		printk(KERN_ERR "error: gpio request_irq(%d) error(%d)!\n", irq, err);

    #endif
    #ifdef AUTO_CONFIG
#if 0	
	res = create_proc_entry("gpio", 0, NULL);
	if (res) {
		res->read_proc = read_proc;
		res->write_proc = write_proc;
	}
	else {
		printk("Realtek GPIO Driver, create proc failed!\n");
	}
#else
	proc_create_data("gpio", 0, &proc_root,
			 &gpio_proc_fops, NULL);
#endif

    #ifdef	USE_INTERRUPT_GPIO
    #ifdef  IMMEDIATE_PBC
	res = create_proc_entry("gpio_wscd_pid", 0, NULL);
	if (res)
	{
		res->read_proc = read_gpio_wscd_pid;
		res->write_proc = write_gpio_wscd_pid;
		DPRINTK("create gpio_wscd_pid OK!!!\n\n");
	}
	else{
		printk("create gpio_wscd_pid failed!\n\n");
	}
    #endif	
    #endif
#endif /* AUTO_CONFIG */
//WNC start our initialization
//WNC-JDR230-YUAN-I-CHOU-20140421, Add LED control function
	rl_gpio_led_init_timer();
//WNC-JDR230-YUAN-I-CHOU-20140421, Add LED control function End

// WNC-MRXXXX-Yuan-I-Chou-20120515-separate GPIO and LED GPIO proc file
	proc_create_data("ledgpio", 0, &proc_root, &ledgpio_proc_fops, NULL);
// WNC-MRXXXX-Yuan-I-Chou-20120515-End
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20131126, Slide switch support for Voyager
	proc_create_data("slide_sw", 0, &proc_root, &slide_sw_proc_fops, NULL);
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20131126, Slide switch support for Voyager
//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20131127, Add MODEL ID function
	proc_create_data("modelid", 0, &proc_root, &modelid_proc_fops, NULL);
//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20131127, Add MODEL ID function End
// WNC-MRXXXX-David-20120521-add reset button proc-Start
	proc_create_data("reset_btn", 0, &proc_root, &reset_btn_proc_fops, NULL);
// WNC-MRXXXX-David-20120521-add reset button proc-End
//WNC-NMR160,357-JDR230-YUAN-I-CHOU-20130327, Reset button can't be used while RakuRaku is running
	proc_create_data("rakurun", 0, &proc_root, &rakurun_proc_fops, NULL);
//WNC-NMR160,357-JDR230-YUAN-I-CHOU-20130327, Reset button can't be used while RakuRaku is running End
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140128, Reset button can't be used while WPS is running
	proc_create_data("wpsrun", 0, &proc_root, &wpsrun_proc_fops, NULL);
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140128, Reset button can't be used while WPS is running End

#if 0
	res = create_proc_entry("load_default", 0, NULL);
	if (res) {
		res->read_proc = default_read_proc;
		res->write_proc = default_write_proc;
	}
#else	
	proc_create_data("load_default", 0, &proc_root,
			 &load_default_proc_fops, NULL);
#endif

#ifdef CONFIG_RTL_FLASH_DUAL_IMAGE_ENABLE	
	proc_create_data("bootbank", 0, &proc_root,
			&bootbank_proc_fops, NULL);
#endif

	init_timer(&probe_timer);
	probe_counter = 0;
	probe_state = PROBE_NULL;
	probe_timer.expires = jiffies + HZ;
	probe_timer.data = (unsigned long)NULL;
	probe_timer.function = &rtl_gpio_timer;
	mod_timer(&probe_timer, jiffies + HZ);

	return 0;
}


static void __exit rtl_gpio_exit(void)
{
	printk("Unload Realtek GPIO Driver \n");
	del_timer_sync(&probe_timer);

	del_timer_sync(&rl_gpio_led_timer);
//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160114-Add Light OFF state support
	del_timer_sync(&rl_skip_led_LOS_timer);
}

//WNC-JDR230-YUAN-I-CHOU-20140421, Add LED control function
//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160114-Add Light OFF state support
static void rl_skip_led_LOS_do_timer(unsigned long unused)
{
	printk("skip_LOS_mode [%d]", skip_LOS_mode);
	skip_LOS_mode = 0;	//Cancel Skip LOS mode flag
	if (led_LOS_mode != 0) {
		//Disable Wireless LED function
		rtl8192_led_force_off(0, 0);
		rtl8192_led_force_off(1, 0);
		//Disable Ethernet LED (HW control -> SW control and OFF)
		ethernet_led_ctl(0, 1);//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160126-Add Light OFF state support
		//(0,0) for ES1 board, (0,1) for ES2 and after board
	}
	printk(" to [%d]\n", skip_LOS_mode);
	return;
}
//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160114-Add Light OFF state support End

static void rl_gpio_led_do_timer(unsigned long unused)
{
	int i;
	unsigned int x;
	unsigned int a, b, c, d, o, t;

	for (i = 0; i < RL_GPIO_NUMBER; i++) {
		rl_gpio_led_stat[i].ticks++;
		if (rl_gpio_led_data[i].gpio == -1) //-1 means unused
			continue;
		if (rl_gpio_led_data[i].on == RL_GPIO_LED_INFINITY ||
			rl_gpio_led_data[i].off == 0) { //always on
//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160114-Add Light OFF state support
			//Skip light OFF state (3 minutes)
			//Light OFF state = disable
			//Light OFF state = except power LED and receive turn ON LED green/red event
			//Sensor LED
			if (skip_LOS_mode == 1 || led_LOS_mode == 0 || (led_LOS_mode == 1 && (i == 4 || i == 5 || i == 9)))
				__LED_ON(i);
			else
				__LED_OFF(i);
//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160114-Add Light OFF state support End
			continue;
		}
		if (rl_gpio_led_data[i].off == RL_GPIO_LED_INFINITY ||
				rl_gpio_led_data[i].rests == RL_GPIO_LED_INFINITY ||
				rl_gpio_led_data[i].on == 0 ||
				rl_gpio_led_data[i].blinks == 0 ||
				rl_gpio_led_data[i].times == 0) { //always off
			__LED_OFF(i);
			continue;
		}

		//led turn on or off
		if (rl_gpio_led_data[i].blinks == RL_GPIO_LED_INFINITY ||
				rl_gpio_led_data[i].rests == 0) { //always blinking
			x = rl_gpio_led_stat[i].ticks % (rl_gpio_led_data[i].on
					+ rl_gpio_led_data[i].off);
		}
		else {
			a = rl_gpio_led_data[i].blinks / 2;
			b = rl_gpio_led_data[i].rests / 2;
			c = rl_gpio_led_data[i].blinks % 2;
			d = rl_gpio_led_data[i].rests % 2;
			o = rl_gpio_led_data[i].on + rl_gpio_led_data[i].off;
			//t = blinking ticks
			t = a * o + rl_gpio_led_data[i].on * c;
			//x = ticks % (blinking ticks + resting ticks)
			x = rl_gpio_led_stat[i].ticks %
				(t + b * o + rl_gpio_led_data[i].on * d);
			//starts from 0 at resting cycles
			if (x >= t)
				x -= t;
			x %= o;
		}
		if (x < rl_gpio_led_data[i].on) {
//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160114-Add Light OFF state support
			//Skip light OFF state (3 minutes)
			//Light OFF state = disable
			//Light OFF state = except power LED and receive turn ON LED green/red event
			//Sensor LED
			if (skip_LOS_mode == 1 || led_LOS_mode == 0 || (led_LOS_mode == 1 && (i == 4 || i == 5 || i == 9))) {
				//WNC-NMR1566-D2R030-Yuan-I-Chou-20160407-Workaround for self test and force DHCP LED interference
				//2.4G RED LED want turn ON, but self test LED (number 11) is still active
				//Turn OFF 2.4G RED
				if ((i == 2) && (rl_gpio_led_data[11].gpio != -1)) {
					__LED_OFF(i);
				} else
				//WNC-NMR1566-D2R030-Yuan-I-Chou-20160407-Workaround for self test and force DHCP LED interference End
					__LED_ON(i);
			} else
				__LED_OFF(i);
//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160114-Add Light OFF state support End
			if (rl_gpio_led_stat[i].ticks && x == 0)
				rl_gpio_led_stat[i].offs++;
		}
		else {
			__LED_OFF(i);
			if (x == rl_gpio_led_data[i].on)
				rl_gpio_led_stat[i].ons++;
		}

		//blinking or resting
		if (rl_gpio_led_data[i].blinks == RL_GPIO_LED_INFINITY){
			// || rl_gpio_led_data[i].rests == 0) { //always blinking
			continue;
		}
		else {
			x = rl_gpio_led_stat[i].ons + rl_gpio_led_stat[i].offs;
			if (!rl_gpio_led_stat[i].resting) {
				if (x >= rl_gpio_led_data[i].blinks) {
					rl_gpio_led_stat[i].resting = 1;
					rl_gpio_led_stat[i].ons = 0;
					rl_gpio_led_stat[i].offs = 0;
					rl_gpio_led_stat[i].times++;
				}
			}
			else {
				if (x >= rl_gpio_led_data[i].rests) {
					rl_gpio_led_stat[i].resting = 0;
					rl_gpio_led_stat[i].ons = 0;
					rl_gpio_led_stat[i].offs = 0;
				}
			}
		}
		if (rl_gpio_led_stat[i].resting) {
			__LED_OFF(i);
		}

		//number of times
		if (rl_gpio_led_data[i].times != RL_GPIO_LED_INFINITY)
		{
			if (rl_gpio_led_stat[i].times >=
					rl_gpio_led_data[i].times) {
				__LED_OFF(i);
				rl_gpio_led_data[i].gpio = -1; //stop
			}
		}
	}

	//init_timer(&rl_gpio_led_timer);
	//rl_gpio_led_timer.expires = jiffies + RL_GPIO_LED_FREQ;
	//add_timer(&rl_gpio_led_timer);
	mod_timer(&rl_gpio_led_timer, jiffies + RL_GPIO_LED_FREQ);
}

void rl_gpio_led_init_timer(void)
{
	int i;

	printk("rl_gpio_led_init_timer\n");

	for (i = 0; i < RL_GPIO_NUMBER; i++)
		rl_gpio_led_data[i].gpio = -1; //-1 means unused

	//rl_gpio_init();

	init_timer(&rl_gpio_led_timer);
	rl_gpio_led_timer.data = (unsigned long)NULL;
	rl_gpio_led_timer.function = &rl_gpio_led_do_timer;
	rl_gpio_led_timer.expires = jiffies + RL_GPIO_LED_FREQ;
	mod_timer(&rl_gpio_led_timer, jiffies + RL_GPIO_LED_FREQ);


//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160114-Add Light OFF state support
	init_timer(&rl_skip_led_LOS_timer);
	rl_skip_led_LOS_timer.data = (unsigned long)NULL;
	rl_skip_led_LOS_timer.function = &rl_skip_led_LOS_do_timer;
	// 3 minutes
	rl_skip_led_LOS_timer.expires = jiffies + 3*60*HZ;
	mod_timer(&rl_skip_led_LOS_timer, jiffies + 3*60*HZ);
//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160114-Add Light OFF state support End

}

int rl_gpio_led_set(rl_gpio_led_info led)
{

	printk("rl_gpio_led_set [%d] [%d] [%d] [%d] [%d] [%d]\n", 
		led.gpio, led.on, led.off, led.blinks, led.rests, led.times);

	if (0 <= led.gpio && led.gpio < RL_GPIO_NUMBER) {
		if (led.on > RL_GPIO_LED_INFINITY)
			led.on = RL_GPIO_LED_INFINITY;
		if (led.off > RL_GPIO_LED_INFINITY)
			led.off = RL_GPIO_LED_INFINITY;
		if (led.blinks > RL_GPIO_LED_INFINITY)
			led.blinks = RL_GPIO_LED_INFINITY;
		if (led.rests > RL_GPIO_LED_INFINITY)
			led.rests = RL_GPIO_LED_INFINITY;
		if (led.times > RL_GPIO_LED_INFINITY)
			led.times = RL_GPIO_LED_INFINITY;
		if (led.on == 0 && led.off == 0 && led.blinks == 0 &&
				led.rests == 0) {
			rl_gpio_led_data[led.gpio].gpio = -1; //stop it
			return 0;
		}

		//register led data
		rl_gpio_led_data[led.gpio].gpio = led.gpio;
		rl_gpio_led_data[led.gpio].on = (led.on == 0)? 1 : led.on;
		rl_gpio_led_data[led.gpio].off = (led.off == 0)? 1 : led.off;
		rl_gpio_led_data[led.gpio].blinks = (led.blinks == 0)? 1 : led.blinks;
		rl_gpio_led_data[led.gpio].rests = (led.rests == 0)? 0 : led.rests;
		rl_gpio_led_data[led.gpio].times = (led.times == 0)? 1 : led.times;

		//clear previous led status
		rl_gpio_led_stat[led.gpio].ticks = -1;
		rl_gpio_led_stat[led.gpio].ons = 0;
		rl_gpio_led_stat[led.gpio].offs = 0;
		rl_gpio_led_stat[led.gpio].resting = 0;
		rl_gpio_led_stat[led.gpio].times = 0;

	}
	else {
		printk("gpio(%d) out of range\n", led.gpio);
		return -1;
	}
	return 0;
}
//WNC-JDR230-YUAN-I-CHOU-20130207, Add LED control function End

module_exit(rtl_gpio_exit);
module_init(rtl_gpio_init);

static int rtl819x_led_probe(struct platform_device *dev) {
	struct rtl819x_gpio_platdata *pdata = dev->dev.platform_data;
	int ret = 0;

//WNC-NMRXXXX-D2R030-YUAN-I-CHOU-20160102 - Modify Spider GPIO
	//if(!strcmp(pdata->name, "reset led"))
		//reset_led_gnum = pdata->gpio;
	//else if(!strcmp(pdata->name, "wps led"))
		//wps_led_gnum = pdata->gpio;
	
	//if(reset_led_gnum != wps_led_gnum)
	//printk("rtl819x_led_probe, name[%s], pin [%d]\n", pdata->name, pdata->gpio);
//WNC-NMRXXXX-D2R030-YUAN-I-CHOU-20160102 - Modify Spider GPIO End
#if LINUX_VERSION_CODE >= KERNEL_VERSION(3,10,0)
		ret = devm_gpio_request_one(&dev->dev, pdata->gpio, GPIOF_OUT_INIT_HIGH | GPIOF_EXPORT_DIR_FIXED, pdata->name);
#else
		if((ret = gpio_request_one(pdata->gpio, GPIOF_OUT_INIT_HIGH, pdata->name)) == 0)
			ret = gpio_export(pdata->gpio, false);
#endif
	
	if(ret < 0)
		return ret;

//WNC-NMRXXXX-D2R030-YUAN-I-CHOU-20160102 - Modify aero GPIO
	//Init all LED here !
	//LED init would set 0 to all GPIO, we would set 1 for low active LED to turn OFF.
	//Also, we would set 1 to Power Green LED (high active)
	//if(!strcmp(pdata->name, "POWER_LED_G"))
		//__gpio_set_value(pdata->gpio, 1);
	switch (pdata->gpio) {
		case GN_CNV_LED_R:
		case GN_CNV_LED_G:
		case GN_TV_LED_G:
		case GN_5G_LED_G:
		case GN_2G_LED_G:
		case GN_ACT_LED_G:
		case GN_POWER_LED_G:
			__gpio_set_value(pdata->gpio, 1);
			break;
	}
//WNC-NMRXXXX-D2R030-YUAN-I-CHOU-20160102 - Modify aero GPIO End

	if(pdata->flags & RTL819X_GPIO_ACTLOW) {
		gpio_sysfs_set_active_low(pdata->gpio, 1);
		rtl819x_gpio_actlow = RTL819X_GPIO_ACTLOW;
	}
	return ret;
}

static struct platform_driver rtl819x_led_driver = {
	.probe		= rtl819x_led_probe,
//	.remove		= rtl819x_led_remove,
	.driver		= {
		.name	= "rtl819x_led",
		.owner	= THIS_MODULE,
	}, 
};
#if LINUX_VERSION_CODE >= KERNEL_VERSION(3,2,0)
module_platform_driver(rtl819x_led_driver);
#else
static int __init rtl819x_led_driver_init(void)
{
	return platform_driver_register(&rtl819x_led_driver);
}
module_init(rtl819x_led_driver_init);
#endif

static int rtl819x_btn_probe(struct platform_device *dev) {
	struct rtl819x_gpio_platdata *pdata = dev->dev.platform_data;
	int ret = 0;
	
	if(!strcmp(pdata->name, "reset btn"))
		reset_btn_gnum = pdata->gpio;
	else if(!strcmp(pdata->name, "wps btn"))
		wps_btn_gnum = pdata->gpio;
//WNC-NMRXXXX-D2R030-YUAN-I-CHOU-20160102 - Modify aero GPIO
	else if(!strcmp(pdata->name, "slide sw1"))
		slidesw1_gnum = pdata->gpio;
	else if(!strcmp(pdata->name, "slide sw2"))
		slidesw2_gnum = pdata->gpio;
	else if(!strcmp(pdata->name, "HW ID"))
		hwid_gnum = pdata->gpio;
//WNC-NMRXXXX-D2R030-YUAN-I-CHOU-20160102 - Modify aero GPIO End
	
#if LINUX_VERSION_CODE >= KERNEL_VERSION(3,10,0)
	ret = devm_gpio_request_one(&dev->dev, pdata->gpio, GPIOF_IN | GPIOF_EXPORT_DIR_FIXED, pdata->name);
#else
	if((ret = gpio_request_one(pdata->gpio, GPIOF_IN, pdata->name)) == 0)
		ret = gpio_export(pdata->gpio, false);
#endif
	
	if(ret < 0)
		return ret;
	
	if(pdata->flags & RTL819X_GPIO_ACTLOW)
		gpio_sysfs_set_active_low(pdata->gpio, 1);
	
	return ret;
}

static struct platform_driver rtl819x_btn_driver = {
	.probe		= rtl819x_btn_probe,
//	.remove		= rtl819x_btn_remove,
	.driver		= {
		.name	= "rtl819x_btn",
		.owner	= THIS_MODULE,
	}, 
};
#if LINUX_VERSION_CODE >= KERNEL_VERSION(3,2,0)
module_platform_driver(rtl819x_btn_driver);
#else
static int __init rtl819x_btn_driver_init(void)
{
	return platform_driver_register(&rtl819x_btn_driver);
}
module_init(rtl819x_btn_driver_init);
#endif

MODULE_LICENSE("GPL");
MODULE_DESCRIPTION("GPIO driver for Reload default");

