/*
*  ## Please DO NOT edit this file!! ##
*  This file is auto-generated from the register source files.
*  Any modifications to this file will be LOST when it is re-generated.
*
*  ----------------------------------------------------------------
*  (c) Realtek Semiconductor Corp. 2008
*
*  This file is property of Realtek Semiconductor Corp.
*  All rights reserved.
*
*  Abstract: chip register definition and API of RTL8316D
*
*  ---------------------------------------------------------------- */

#ifndef __RTL8316D_GENERAL_REG_H__
#define __RTL8316D_GENERAL_REG_H__

#if 0
typedef unsigned char uint8;
typedef unsigned short uint16;
typedef unsigned int uint32;
typedef unsigned long long uint64;

typedef char int8;
typedef short int16;
typedef int int32;
typedef long long int64;
#endif

#ifndef NULL
#define NULL 0
#endif
#ifndef SUCCESS
#define SUCCESS 0
#endif
#ifndef FAILED
#define FAILED -1
#endif

/* Register access macro (REG*()) */
#ifndef REG32
#define REG32(reg)      (*((volatile uint32 *)(reg)))
#endif
#ifndef REG16
#define REG16(reg)      (*((volatile uint16 *)(reg)))
#endif
#ifndef REG8
#define REG8(reg)       (*((volatile uint8  *)(reg)))

#endif
/* Register access macro (READ_MEM32() and WRITE_MEM32()). */
#if defined(__MODEL_USER__)
/*
 * big_endian() is a macro to make endian consistence between BIG-Endian board and x86 PC.
 * All the ASIC registers stored in memory will be stored at big-endian order.
 * Therefore, we will see the same result when memory dump ASIC registers.
 */
#define big_endian32(x) ((((x)&0xff000000)>>24)|(((x)&0x00ff0000)>>8)|(((x)&0x0000ff00)<<8)|(((x)&0x000000ff)<<24))
#define big_endian16(x) (((x)>>8)|(((x)&0x000000ff)<<8))
#else
#define big_endian32(x) (x)
#define big_endian16(x) (x)
#endif
#define big_endian(x) big_endian32(x) /* backward-compatible */

#define  CONFIG_X86I2C 		1

#ifdef  CONFIG_X86I2C 
#define MEM32_READ(reg) rtlglue_reg32_read(reg, NULL)
#define MEM32_WRITE(reg,val) rtlglue_reg32_write(reg, val)
#else
#define MEM32_READ(reg) big_endian(REG32(reg))
#define MEM32_WRITE(reg,val) REG32(reg)=big_endian(val)
#endif
#define MEM16_READ(reg) big_endian16(REG16(reg))
#define MEM16_WRITE(reg,val) REG16(reg)=big_endian16(val)
#define MEM8_READ(reg) (REG8(reg))
#define MEM8_WRITE(reg,val) REG8(reg)=(val)

/* Define SWCORE_BASE for ASIC or Model Code */
#define REAL_SWCORE_BASE    0xBB000000UL
#if defined(__MODEL_USER__) || defined(__MODEL_KERNEL__)
extern int8 *pVirtualSWReg;
//#define SWCORE_BASE        ((uint32)pVirtualSWReg)
#define SWCORE_BASE        0xBB000000UL
#else
#define SWCORE_BASE        REAL_SWCORE_BASE
#endif

/* Module: TABLE ACCESS */
#define TABLE_ACCESS_BASE            0xBB000000
#define INDIRECT_CONTROL_FOR_CPU_ADDR        (0x0 + TABLE_ACCESS_BASE)
#define INDIRECT_DATA0_FOR_CPU_ADDR        (0x4 + TABLE_ACCESS_BASE)
#define INDIRECT_DATA1_FOR_CPU_ADDR        (0x8 + TABLE_ACCESS_BASE)
#define INDIRECT_DATA2_FOR_CPU_ADDR        (0xC + TABLE_ACCESS_BASE)
#define INDIRECT_DATA3_FOR_CPU_ADDR        (0x10 + TABLE_ACCESS_BASE)
#define INDIRECT_DATA4_FOR_CPU_ADDR        (0x14 + TABLE_ACCESS_BASE)
#define INDIRECT_DATA5_FOR_CPU_ADDR        (0x18 + TABLE_ACCESS_BASE)
#define INDIRECT_DATA6_FOR_CPU_ADDR        (0x1C + TABLE_ACCESS_BASE)
#define INDIRECT_DATA7_FOR_CPU_ADDR        (0x20 + TABLE_ACCESS_BASE)
#define INDIRECT_DATA8_FOR_CPU_ADDR        (0x24 + TABLE_ACCESS_BASE)
#define INDIRECT_DATA9_FOR_CPU_ADDR        (0x28 + TABLE_ACCESS_BASE)
#define INDIRECT_CONTROL_FOR_RRCP_ADDR        (0x2C + TABLE_ACCESS_BASE)
#define INDIRECT_DATA0_FOR_RRCP_ADDR        (0x30 + TABLE_ACCESS_BASE)
#define INDIRECT_DATA1_FOR_RRCP_ADDR        (0x34 + TABLE_ACCESS_BASE)
#define INDIRECT_DATA2_FOR_RRCP_ADDR        (0x38 + TABLE_ACCESS_BASE)
#define INDIRECT_DATA3_FOR_RRCP_ADDR        (0x3C + TABLE_ACCESS_BASE)
#define INDIRECT_DATA4_FOR_RRCP_ADDR        (0x40 + TABLE_ACCESS_BASE)
#define INDIRECT_DATA5_FOR_RRCP_ADDR        (0x44 + TABLE_ACCESS_BASE)
#define INDIRECT_DATA6_FOR_RRCP_ADDR        (0x48 + TABLE_ACCESS_BASE)
#define INDIRECT_DATA7_FOR_RRCP_ADDR        (0x4C + TABLE_ACCESS_BASE)
#define INDIRECT_DATA8_FOR_RRCP_ADDR        (0x50 + TABLE_ACCESS_BASE)
#define INDIRECT_DATA9_FOR_RRCP_ADDR        (0x54 + TABLE_ACCESS_BASE)
#define ALE_DMY0_ADDR        (0x58 + TABLE_ACCESS_BASE)
#define ALE_DMY1_ADDR        (0x5C + TABLE_ACCESS_BASE)
#define ALE_DMY2_ADDR        (0x60 + TABLE_ACCESS_BASE)
#define ALE_DMY3_ADDR        (0x64 + TABLE_ACCESS_BASE)
#define ALE_DMY4_ADDR        (0x68 + TABLE_ACCESS_BASE)
#define ALE_DMY5_ADDR        (0x6C + TABLE_ACCESS_BASE)
#define ALE_DMY6_ADDR        (0x70 + TABLE_ACCESS_BASE)
#define ALE_DMY7_ADDR        (0x74 + TABLE_ACCESS_BASE)
#define ALE_DMY8_ADDR        (0x78 + TABLE_ACCESS_BASE)
#define ALE_DMY9_ADDR        (0x7C + TABLE_ACCESS_BASE)
#define VLAN_CTRL_ADDR        0x0
#define VLAN_DATA_ADDR        (0x3 + VLAN_CTRL_ADDR)
#define VLAN_SIZE        512
#define VLAN_RW_OFFSET        95
#define VLAN_RW_MASK        (0x1 << VLAN_RW_OFFSET)
#define VLAN_BUSY_OFFSET        94
#define VLAN_BUSY_MASK        (0x1 << VLAN_BUSY_OFFSET)
#define VLAN_FAIL_OFFSET        93
#define VLAN_FAIL_MASK        (0x1 << VLAN_FAIL_OFFSET)
#define VLAN_CAM_CTRL_ADDR        0x0
#define VLAN_CAM_DATA_ADDR        (0x4 + VLAN_CAM_CTRL_ADDR)
#define VLAN_CAM_SIZE        16
#define VLAN_CAM_RW_OFFSET        127
#define VLAN_CAM_RW_MASK        (0x1 << VLAN_CAM_RW_OFFSET)
#define VLAN_CAM_BUSY_OFFSET        126
#define VLAN_CAM_BUSY_MASK        (0x1 << VLAN_CAM_BUSY_OFFSET)
#define VLAN_CAM_FAIL_OFFSET        125
#define VLAN_CAM_FAIL_MASK        (0x1 << VLAN_CAM_FAIL_OFFSET)
#define L2_TABLE_CTRL_ADDR        0x0
#define L2_TABLE_DATA_ADDR        (0x3 + L2_TABLE_CTRL_ADDR)
#define L2_TABLE_SIZE        8192
#define L2_TABLE_RW_OFFSET        95
#define L2_TABLE_RW_MASK        (0x1 << L2_TABLE_RW_OFFSET)
#define L2_TABLE_BUSY_OFFSET        94
#define L2_TABLE_BUSY_MASK        (0x1 << L2_TABLE_BUSY_OFFSET)
#define L2_TABLE_FAIL_OFFSET        93
#define L2_TABLE_FAIL_MASK        (0x1 << L2_TABLE_FAIL_OFFSET)
#define FORWARDING_CTRL_ADDR        0x0
#define FORWARDING_DATA_ADDR        (0x1 + FORWARDING_CTRL_ADDR)
#define FORWARDING_SIZE        256
#define FORWARDING_RW_OFFSET        31
#define FORWARDING_RW_MASK        (0x1 << FORWARDING_RW_OFFSET)
#define FORWARDING_BUSY_OFFSET        30
#define FORWARDING_BUSY_MASK        (0x1 << FORWARDING_BUSY_OFFSET)
#define FORWARDING_FAIL_OFFSET        29
#define FORWARDING_FAIL_MASK        (0x1 << FORWARDING_FAIL_OFFSET)
#define ACTION_TABLE_CTRL_ADDR        0x0
#define ACTION_TABLE_DATA_ADDR        (0x5 + ACTION_TABLE_CTRL_ADDR)
#define ACTION_TABLE_SIZE        128
#define ACTION_TABLE_RW_OFFSET        159
#define ACTION_TABLE_RW_MASK        (0x1 << ACTION_TABLE_RW_OFFSET)
#define ACTION_TABLE_BUSY_OFFSET        158
#define ACTION_TABLE_BUSY_MASK        (0x1 << ACTION_TABLE_BUSY_OFFSET)
#define ACTION_TABLE_FAIL_OFFSET        157
#define ACTION_TABLE_FAIL_MASK        (0x1 << ACTION_TABLE_FAIL_OFFSET)
#define ACL_COUNTER_CTRL_ADDR        0x0
#define ACL_COUNTER_DATA_ADDR        (0x3 + ACL_COUNTER_CTRL_ADDR)
#define ACL_COUNTER_SIZE        128
#define ACL_COUNTER_RW_OFFSET        95
#define ACL_COUNTER_RW_MASK        (0x1 << ACL_COUNTER_RW_OFFSET)
#define ACL_COUNTER_BUSY_OFFSET        94
#define ACL_COUNTER_BUSY_MASK        (0x1 << ACL_COUNTER_BUSY_OFFSET)
#define ACL_COUNTER_FAIL_OFFSET        93
#define ACL_COUNTER_FAIL_MASK        (0x1 << ACL_COUNTER_FAIL_OFFSET)
#define POLICER_CTRL_ADDR        0x0
#define POLICER_DATA_ADDR        (0x3 + POLICER_CTRL_ADDR)
#define POLICER_SIZE        128
#define POLICER_RW_OFFSET        95
#define POLICER_RW_MASK        (0x1 << POLICER_RW_OFFSET)
#define POLICER_BUSY_OFFSET        94
#define POLICER_BUSY_MASK        (0x1 << POLICER_BUSY_OFFSET)
#define POLICER_FAIL_OFFSET        93
#define POLICER_FAIL_MASK        (0x1 << POLICER_FAIL_OFFSET)
#define PIE_TABLE_CTRL_ADDR        0x0
#define PIE_TABLE_DATA_ADDR        (0xB + PIE_TABLE_CTRL_ADDR)
#define PIE_TABLE_SIZE        128
#define PIE_TABLE_RW_OFFSET        351
#define PIE_TABLE_RW_MASK        (0x1 << PIE_TABLE_RW_OFFSET)
#define PIE_TABLE_BUSY_OFFSET        350
#define PIE_TABLE_BUSY_MASK        (0x1 << PIE_TABLE_BUSY_OFFSET)
#define PIE_TABLE_FAIL_OFFSET        349
#define PIE_TABLE_FAIL_MASK        (0x1 << PIE_TABLE_FAIL_OFFSET)

/* Module: INTERFACE */
#define INTERFACE_BASE            0xBB010000
#define GLOBAL_MAC_INTERFACE_CONTROL0_ADDR        (0x0 + INTERFACE_BASE)
#define GLOBAL_MAC_INTERFACE_INTERNAL0_ADDR        (0x4 + INTERFACE_BASE)
#define GLOBAL_MAC_INTERFACE_INTERNAL1_ADDR        (0x8 + INTERFACE_BASE)
#define GLOBAL_MAC_INTERFACE_INTERNAL2_ADDR        (0xC + INTERFACE_BASE)
#define GLOBAL_MAC_INTERFACE_INTERNAL3_ADDR        (0x10 + INTERFACE_BASE)
#define INTERFACE_DMY_REGSITER_ADDR        (0x14 + INTERFACE_BASE)

/* Module: RESET */
#define RESET_BASE            0xBB020000
#define RESET_GLOBAL_CONTROL0_ADDR        (0x0 + RESET_BASE)
#define RESET_GLOBAL_CONTROL1_ADDR        (0x4 + RESET_BASE)
#define RESET_GLOBAL_CONTROL2_ADDR        (0x8 + RESET_BASE)
#define RESET_GLOBAL_STATUS_ADDR        (0xC + RESET_BASE)
#define RESET_DMY_ADDR        (0x10 + RESET_BASE)

/* Module: PLL AND BIAS */
#define PLL_AND_BIAS_BASE            0xBB030000
#define GLOBAL_PLL_CONTROL0_ADDR        (0x0 + PLL_AND_BIAS_BASE)
#define SWITCH_PLL_CONTROL0_ADDR        (0x4 + PLL_AND_BIAS_BASE)
#define IF_PLL_CONTROL0_ADDR        (0x8 + PLL_AND_BIAS_BASE)
#define BIAS_CONTROL0_ADDR        (0xC + PLL_AND_BIAS_BASE)
#define PLL_DMY_ADDR        (0x10 + PLL_AND_BIAS_BASE)

/* Module: SMI */
#define SMI_BASE            0xBB040000
#define SMI_CONTROL_ADDR        (0x0 + SMI_BASE)
#define MAC_PHY_ADDRESS_CONFIGURE_ADDR        (0x4 + SMI_BASE)
#define PHY_REG_ACCESS_CONTROL0_FOR_CPU_ADDR        (0x8 + SMI_BASE)
#define PHY_REG_ACCESS_CONTROL1_FOR_CPU_ADDR        (0xC + SMI_BASE)
#define PHY_REG_ACCESS_CONTROL2_FOR_CPU_ADDR        (0x10 + SMI_BASE)
#define PHY_REG_ACCESS_CONTROL0_FOR_RRCP_ADDR        (0x14 + SMI_BASE)
#define PHY_REG_ACCESS_CONTROL1_FOR_RRCP_ADDR        (0x18 + SMI_BASE)
#define PHY_REG_ACCESS_CONTROL2_FOR_RRCP_ADDR        (0x1C + SMI_BASE)
#define PHY_AUTO_ACCESS_MASK0_ADDR        (0x20 + SMI_BASE)
#define PHY_AUTO_ACCESS_MASK1_ADDR        (0x24 + SMI_BASE)
#define PORT0_PROPERTY_CONFIGURE_ADDR        (0x28 + SMI_BASE)
#define PORT1_PROPERTY_CONFIGURE_ADDR        (0x2C + SMI_BASE)
#define PORT2_PROPERTY_CONFIGURE_ADDR        (0x30 + SMI_BASE)
#define PORT3_PROPERTY_CONFIGURE_ADDR        (0x34 + SMI_BASE)
#define PORT4_PROPERTY_CONFIGURE_ADDR        (0x38 + SMI_BASE)
#define PORT5_PROPERTY_CONFIGURE_ADDR        (0x3C + SMI_BASE)
#define PORT6_PROPERTY_CONFIGURE_ADDR        (0x40 + SMI_BASE)
#define PORT7_PROPERTY_CONFIGURE_ADDR        (0x44 + SMI_BASE)
#define PORT8_PROPERTY_CONFIGURE_ADDR        (0x48 + SMI_BASE)
#define PORT9_PROPERTY_CONFIGURE_ADDR        (0x4C + SMI_BASE)
#define PORT10_PROPERTY_CONFIGURE_ADDR        (0x50 + SMI_BASE)
#define PORT11_PROPERTY_CONFIGURE_ADDR        (0x54 + SMI_BASE)
#define PORT12_PROPERTY_CONFIGURE_ADDR        (0x58 + SMI_BASE)
#define PORT13_PROPERTY_CONFIGURE_ADDR        (0x5C + SMI_BASE)
#define PORT14_PROPERTY_CONFIGURE_ADDR        (0x60 + SMI_BASE)
#define PORT15_PROPERTY_CONFIGURE_ADDR        (0x64 + SMI_BASE)
#define PORT16_PROPERTY_CONFIGURE_ADDR        (0x68 + SMI_BASE)
#define PORT17_PROPERTY_CONFIGURE_ADDR        (0x6C + SMI_BASE)
#define PORT18_PROPERTY_CONFIGURE_ADDR        (0x70 + SMI_BASE)
#define PORT19_PROPERTY_CONFIGURE_ADDR        (0x74 + SMI_BASE)
#define PORT20_PROPERTY_CONFIGURE_ADDR        (0x78 + SMI_BASE)
#define PORT21_PROPERTY_CONFIGURE_ADDR        (0x7C + SMI_BASE)
#define PORT22_PROPERTY_CONFIGURE_ADDR        (0x80 + SMI_BASE)
#define PORT23_PROPERTY_CONFIGURE_ADDR        (0x84 + SMI_BASE)
#define PORT24_PROPERTY_CONFIGURE_ADDR        (0x88 + SMI_BASE)
#define PORT0_LINK_STATUS_ADDR        (0x8C + SMI_BASE)
#define PORT1_LINK_STATUS_ADDR        (0x90 + SMI_BASE)
#define PORT2_LINK_STATUS_ADDR        (0x94 + SMI_BASE)
#define PORT3_LINK_STATUS_ADDR        (0x98 + SMI_BASE)
#define PORT4_LINK_STATUS_ADDR        (0x9C + SMI_BASE)
#define PORT5_LINK_STATUS_ADDR        (0xA0 + SMI_BASE)
#define PORT6_LINK_STATUS_ADDR        (0xA4 + SMI_BASE)
#define PORT7_LINK_STATUS_ADDR        (0xA8 + SMI_BASE)
#define PORT8_LINK_STATUS_ADDR        (0xAC + SMI_BASE)
#define PORT9_LINK_STATUS_ADDR        (0xB0 + SMI_BASE)
#define PORT10_LINK_STATUS_ADDR        (0xB4 + SMI_BASE)
#define PORT11_LINK_STATUS_ADDR        (0xB8 + SMI_BASE)
#define PORT12_LINK_STATUS_ADDR        (0xBC + SMI_BASE)
#define PORT13_LINK_STATUS_ADDR        (0xC0 + SMI_BASE)
#define PORT14_LINK_STATUS_ADDR        (0xC4 + SMI_BASE)
#define PORT15_LINK_STATUS_ADDR        (0xC8 + SMI_BASE)
#define PORT16_LINK_STATUS_ADDR        (0xCC + SMI_BASE)
#define PORT17_LINK_STATUS_ADDR        (0xD0 + SMI_BASE)
#define PORT18_LINK_STATUS_ADDR        (0xD4 + SMI_BASE)
#define PORT19_LINK_STATUS_ADDR        (0xD8 + SMI_BASE)
#define PORT20_LINK_STATUS_ADDR        (0xDC + SMI_BASE)
#define PORT21_LINK_STATUS_ADDR        (0xE0 + SMI_BASE)
#define PORT22_LINK_STATUS_ADDR        (0xE4 + SMI_BASE)
#define PORT23_LINK_STATUS_ADDR        (0xE8 + SMI_BASE)
#define PORT24_LINK_STATUS_ADDR        (0xEC + SMI_BASE)
#define PHY_ADDRESS_BROADCAST_CONTROL_ADDR        (0xF0 + SMI_BASE)
#define SMI_DMY_ADDR        (0xF4 + SMI_BASE)

/* Module: I2C */
#define I2C_BASE            0xBB050000
#define EXTERNAL_ACCESS_CONTROL_ADDR        (0x0 + I2C_BASE)
#define I2C_EXTERNAL_ACCESS_STATUS_ADDR        (0x4 + I2C_BASE)
#define I2C_EXTERNAL_ACCESS_ADDRESS_ADDR        (0x8 + I2C_BASE)
#define EEPROM_AUTO_DOWNLOAD_CONTROL0_ADDR        (0xC + I2C_BASE)
#define EEPROM_FDR_CONTROL_REGSITER_ADDR        (0x10 + I2C_BASE)
#define EEPROM_AUTODOWNLOAD_MAC_POSTION_ADDR        (0x14 + I2C_BASE)
#define EEPROM_AUTODOWNLOAD_PHY_POSTION_ADDR        (0x18 + I2C_BASE)
#define EEPROM_AUTODOWNLOAD_LUT_POSTION_ADDR        (0x1C + I2C_BASE)
#define EEPROM_STATUS_AND_FDR_EXEC_ADDR        (0x20 + I2C_BASE)
#define CPU_INDIRECT_ACCESS_EEPROM_CONTROL_ADDR        (0x24 + I2C_BASE)
#define CPU_INDIRECT_ACCESS_EEPROM_DATA0_ADDR        (0x28 + I2C_BASE)
#define CPU_INDIRECT_ACCESS_EEPROM_DATA1_ADDR        (0x2C + I2C_BASE)
#define CPU_INDIRECT_ACCESS_EEPROM_DATA2_ADDR        (0x30 + I2C_BASE)
#define CPU_INDIRECT_ACCESS_EEPROM_DATA3_ADDR        (0x34 + I2C_BASE)
#define CPU_INDIRECT_ACCESS_EEPROM_DATA4_ADDR        (0x38 + I2C_BASE)
#define CPU_INDIRECT_ACCESS_EEPROM_DATA5_ADDR        (0x3C + I2C_BASE)
#define CPU_INDIRECT_ACCESS_EEPROM_DATA6_ADDR        (0x40 + I2C_BASE)
#define CPU_INDIRECT_ACCESS_EEPROM_DATA7_ADDR        (0x44 + I2C_BASE)
#define RRCP_INDIRECT_ACCESS_EEPROM_CONTROL_ADDR        (0x48 + I2C_BASE)
#define RRCP_INDIRECT_ACCESS_EEPROM_DATA0_ADDR        (0x4C + I2C_BASE)
#define RRCP_INDIRECT_ACCESS_EEPROM_DATA1_ADDR        (0x50 + I2C_BASE)
#define RRCP_INDIRECT_ACCESS_EEPROM_DATA2_ADDR        (0x54 + I2C_BASE)
#define RRCP_INDIRECT_ACCESS_EEPROM_DATA3_ADDR        (0x58 + I2C_BASE)
#define RRCP_INDIRECT_ACCESS_EEPROM_DATA4_ADDR        (0x5C + I2C_BASE)
#define RRCP_INDIRECT_ACCESS_EEPROM_DATA5_ADDR        (0x60 + I2C_BASE)
#define RRCP_INDIRECT_ACCESS_EEPROM_DATA6_ADDR        (0x64 + I2C_BASE)
#define RRCP_INDIRECT_ACCESS_EEPROM_DATA7_ADDR        (0x68 + I2C_BASE)
#define I2C_DMY_ADDR        (0x6C + I2C_BASE)

/* Module: HARDWARE MISC */
#define HARDWARE_MISC_BASE            0xBB060000
#define IO_DRIVING_ABILITY_CONTROL0_ADDR        (0x0 + HARDWARE_MISC_BASE)
#define IO_DRIVING_ABILITY_CONTROL1_ADDR        (0x4 + HARDWARE_MISC_BASE)
#define IO_DRIVING_ABILITY_CONTROL2_ADDR        (0x8 + HARDWARE_MISC_BASE)
#define IO_DRIVING_ABILITY_CONTROL3_ADDR        (0xC + HARDWARE_MISC_BASE)
#define IO_SLEW_RATE_CONTROL0_ADDR        (0x10 + HARDWARE_MISC_BASE)
#define IO_SLEW_RATE_CONTROL1_ADDR        (0x14 + HARDWARE_MISC_BASE)
#define IO_SLEW_RATE_CONTROL2_ADDR        (0x18 + HARDWARE_MISC_BASE)
#define IO_SLEW_RATE_CONTROL3_ADDR        (0x1C + HARDWARE_MISC_BASE)
#define HARDWARE_MISC_ADDR        (0x20 + HARDWARE_MISC_BASE)
#define DEBUG0_ADDR        (0x24 + HARDWARE_MISC_BASE)
#define DEBUG1_ADDR        (0x28 + HARDWARE_MISC_BASE)
#define INTERNAL_BONDING_DEBUG_ADDR        (0x2C + HARDWARE_MISC_BASE)
#define INTERNAL_STRAPPING_DEBUG0_ADDR        (0x30 + HARDWARE_MISC_BASE)
#define INTERNAL_STRAPPING_DEBUG1_ADDR        (0x34 + HARDWARE_MISC_BASE)
#define INTERNAL_READ_ADDR        (0x38 + HARDWARE_MISC_BASE)
#define BIAS_CONTROL_ADDR        (0x3C + HARDWARE_MISC_BASE)
#define SPI_MODE_CONTROL_ADDR        (0x40 + HARDWARE_MISC_BASE)
#define POWER_SAVING_CONTROL0_ADDR        (0x44 + HARDWARE_MISC_BASE)
#define POWER_SAVING_CONTROL1_ADDR        (0x48 + HARDWARE_MISC_BASE)

/* Module: BIST */
#define BIST_BASE            0xBB068000
#define BIST_RESULT0_ADDR        (0x0 + BIST_BASE)
#define BIST_RESULT1_ADDR        (0x4 + BIST_BASE)
#define BIST_RESULT2_ADDR        (0x8 + BIST_BASE)
#define BIST_RESULT3_ADDR        (0xC + BIST_BASE)
#define BIST_RESULT4_ADDR        (0x10 + BIST_BASE)
#define BIST_RESULT5_ADDR        (0x14 + BIST_BASE)
#define BIST_RESULT6_ADDR        (0x18 + BIST_BASE)
#define BIST_RESULT7_ADDR        (0x1C + BIST_BASE)
#define BIST_RESULT8_ADDR        (0x20 + BIST_BASE)
#define BIST_RESULT9_ADDR        (0x24 + BIST_BASE)
#define BIST_RESULT10_ADDR        (0x28 + BIST_BASE)
#define BIST_CONTROL_ADDR        (0x2C + BIST_BASE)
#define BIST_RESULT11_ADDR        (0x30 + BIST_BASE)

/* Module: CHIP VERSION */
#define CHIP_VERSION_BASE            0xBB06FFF4
#define MODEL_REVISION_INFORMATION_ADDR        (0x0 + CHIP_VERSION_BASE)
#define MODEL_NAME_INFORMATION_REGSITER_ADDR        (0x4 + CHIP_VERSION_BASE)
#define CHIP_VERSION_ID_ADDR        (0x8 + CHIP_VERSION_BASE)

/* Module: SERDES */
#define SERDES_BASE            0xBB070000
#define SDS_EN_TX_RX_LOOPBACK_MODE_ADDR        (0x0 + SERDES_BASE)
#define SDS_FORCE_TX_RX_ADDR        (0x4 + SERDES_BASE)
#define SDS_PCS_CONTROL_0_ADDR        (0x8 + SERDES_BASE)
#define SDS_PCS_CONTROL_1_ADDR        (0xC + SERDES_BASE)
#define SDS_PCS_CONTROL_2_ADDR        (0x10 + SERDES_BASE)
#define SDS_INBAND_ACCESS_CONTROL_ADDR        (0x14 + SERDES_BASE)
#define SDS_SCRAMBLER_CONTROL_0_ADDR        (0x18 + SERDES_BASE)
#define SDS_SCRAMBLER_CONTROL_1_ADDR        (0x1C + SERDES_BASE)
#define SDS_EEE_CONTROL_0_ADDR        (0x20 + SERDES_BASE)
#define SDS_EEE_CONTROL_1_ADDR        (0x24 + SERDES_BASE)
#define SDS_EEE_CONTROL_2_ADDR        (0x28 + SERDES_BASE)
#define SDS_EEE_DEBUG_COUNTER_ADDR        (0x2C + SERDES_BASE)
#define SDS_AUTO_DET_CONTROL_0_ADDR        (0x30 + SERDES_BASE)
#define SDS_AUTO_DET_CONTROL_1_ADDR        (0x34 + SERDES_BASE)
#define SDS_AUTO_DET_CONTROL_2_ADDR        (0x38 + SERDES_BASE)
#define SDS_MASTER_INBAND_0_ADDR        (0x3C + SERDES_BASE)
#define SDS_MASTER_INBAND_1_ADDR        (0x40 + SERDES_BASE)
#define SDS_MASTER_INBAND_2_ADDR        (0x44 + SERDES_BASE)
#define SDS_RSGP_TXCFG_PHY_REG_0_ADDR        (0x48 + SERDES_BASE)
#define SDS_RSGP_TXCFG_PHY_REG_1_ADDR        (0x4C + SERDES_BASE)
#define SDS_RSGP_TXCFG_MAC_REG_ADDR        (0x50 + SERDES_BASE)
#define SDS_RESERVED0_ADDR        (0x54 + SERDES_BASE)
#define SDS_RESERVED1_ADDR        (0x58 + SERDES_BASE)
#define SDS_RESERVED2_ADDR        (0x5C + SERDES_BASE)
#define SDS_RESERVED3_ADDR        (0x60 + SERDES_BASE)
#define SDS_RESERVED4_ADDR        (0x64 + SERDES_BASE)
#define SDS_DEBUG_OUTPUT_0_FOR_ECO_ADDR        (0x68 + SERDES_BASE)
#define SDS_DEBUG_SELECT_SIGNAL_RELATED_ADDR        (0x70 + SERDES_BASE)
#define SDS_DEBUG_OUTPUT_0_ADDR        (0x74 + SERDES_BASE)
#define SDS_DEBUG_OUTPUT_1_ADDR        (0x78 + SERDES_BASE)
#define SDS_RESERVED5_ADDR        (0x7C + SERDES_BASE)
#define SDS_ANA_RG0X_ADDR        (0x80 + SERDES_BASE)
#define SDS_ANA_RG1X_ADDR        (0x84 + SERDES_BASE)
#define SDS_ANA_RG2X_ADDR        (0x88 + SERDES_BASE)
#define SDS_ANA_RG3X_ADDR        (0x8C + SERDES_BASE)
#define SDS_ANA_RG4X_ADDR        (0x90 + SERDES_BASE)
#define SDS_ANA_RG5X_ADDR        (0x94 + SERDES_BASE)
#define SDS_ANA_RG6X_ADDR        (0x98 + SERDES_BASE)
#define SDS_ANA_RG7X_ADDR        (0x9C + SERDES_BASE)
#define SDS_ANA_RG8X_ADDR        (0xA0 + SERDES_BASE)
#define SDS_ANA_RG9X_ADDR        (0xA4 + SERDES_BASE)
#define SDS_ANA_RG10X_ADDR        (0xA8 + SERDES_BASE)
#define SDS_ANA_RG11X_ADDR        (0xAC + SERDES_BASE)
#define SDS_ANA_RG12X_ADDR        (0xB0 + SERDES_BASE)
#define SDS_ANA_RG13X_ADDR        (0xB4 + SERDES_BASE)
#define SDS_ANA_RG14X_ADDR        (0xB8 + SERDES_BASE)
#define SDS_ANA_RG15X_ADDR        (0xBC + SERDES_BASE)
#define SDS_ANA_RG16X_ADDR        (0xC0 + SERDES_BASE)
#define SDS_ANA_RG17X_ADDR        (0xC4 + SERDES_BASE)
#define SDS_ANA_RG18X_ADDR        (0xC8 + SERDES_BASE)
#define SDS_ANA_RG19X_ADDR        (0xCC + SERDES_BASE)
#define SDS_ANA_RG20X_ADDR        (0xD0 + SERDES_BASE)
#define SDS_ANA_RG21X_ADDR        (0xD4 + SERDES_BASE)
#define SDS_ANA_RG22X_ADDR        (0xD8 + SERDES_BASE)
#define SDS_ANA_RG23X_ADDR        (0xDC + SERDES_BASE)
#define SDS_COUNTER_STATUS_0_ADDR        (0xE0 + SERDES_BASE)
#define SDS_COUNER_STATUS_1_ADDR        (0xE4 + SERDES_BASE)
#define SDS_COUNTER_STATUS_2_ADDR        (0xE8 + SERDES_BASE)
#define SDS_COUNTER_STATUS_3_ADDR        (0xEC + SERDES_BASE)
#define SDS_DEBUG_OUTPUT_1_FOR_ECO_ADDR        (0xF0 + SERDES_BASE)
#define SDS_DEBUG_OUTPUT_2_FOR_ECO_ADDR        (0xF4 + SERDES_BASE)
#define SDS_SIGNAL_SYNC_LINK_STATUS_ADDR        (0xF8 + SERDES_BASE)
#define SDS_RESERVED6_ADDR        (0xFC + SERDES_BASE)

/* Module: PORT_BASED VLAN */
#define PORT_BASED_VLAN_BASE            0xBB080000
#define PORT0_VLAN_CONTROL_ADDR        (0x800000 + PORT_BASED_VLAN_BASE)
#define PORT1_VLAN_CONTROL_ADDR        (0x800100 + PORT_BASED_VLAN_BASE)
#define PORT2_VLAN_CONTROL_ADDR        (0x800200 + PORT_BASED_VLAN_BASE)
#define PORT3_VLAN_CONTROL_ADDR        (0x800300 + PORT_BASED_VLAN_BASE)
#define PORT4_VLAN_CONTROL_ADDR        (0x800400 + PORT_BASED_VLAN_BASE)
#define PORT5_VLAN_CONTROL_ADDR        (0x800500 + PORT_BASED_VLAN_BASE)
#define PORT6_VLAN_CONTROL_ADDR        (0x800600 + PORT_BASED_VLAN_BASE)
#define PORT7_VLAN_CONTROL_ADDR        (0x800700 + PORT_BASED_VLAN_BASE)
#define PORT8_VLAN_CONTROL_ADDR        (0x800800 + PORT_BASED_VLAN_BASE)
#define PORT9_VLAN_CONTROL_ADDR        (0x800900 + PORT_BASED_VLAN_BASE)
#define PORT10_VLAN_CONTROL_ADDR        (0x800A00 + PORT_BASED_VLAN_BASE)
#define PORT11_VLAN_CONTROL_ADDR        (0x800B00 + PORT_BASED_VLAN_BASE)
#define PORT12_VLAN_CONTROL_ADDR        (0x800C00 + PORT_BASED_VLAN_BASE)
#define PORT13_VLAN_CONTROL_ADDR        (0x800D00 + PORT_BASED_VLAN_BASE)
#define PORT14_VLAN_CONTROL_ADDR        (0x800E00 + PORT_BASED_VLAN_BASE)
#define PORT15_VLAN_CONTROL_ADDR        (0x800F00 + PORT_BASED_VLAN_BASE)
#define PORT16_VLAN_CONTROL_ADDR        (0x801000 + PORT_BASED_VLAN_BASE)
#define PORT17_VLAN_CONTROL_ADDR        (0x801100 + PORT_BASED_VLAN_BASE)
#define PORT18_VLAN_CONTROL_ADDR        (0x801200 + PORT_BASED_VLAN_BASE)
#define PORT19_VLAN_CONTROL_ADDR        (0x801300 + PORT_BASED_VLAN_BASE)
#define PORT20_VLAN_CONTROL_ADDR        (0x801400 + PORT_BASED_VLAN_BASE)
#define PORT21_VLAN_CONTROL_ADDR        (0x801500 + PORT_BASED_VLAN_BASE)
#define PORT22_VLAN_CONTROL_ADDR        (0x801600 + PORT_BASED_VLAN_BASE)
#define PORT23_VLAN_CONTROL_ADDR        (0x801700 + PORT_BASED_VLAN_BASE)
#define PORT24_VLAN_CONTROL_ADDR        (0x801800 + PORT_BASED_VLAN_BASE)

/* Module: VLAN DECISION */
#define VLAN_DECISION_BASE            0xBB090000
#define PORT0_ACCEPT_FRAME_TYPE_CONTROL_ADDR        (0x800000 + VLAN_DECISION_BASE)
#define PORT1_ACCEPT_FRAME_TYPE_CONTROL_ADDR        (0x800100 + VLAN_DECISION_BASE)
#define PORT2_ACCEPT_FRAME_TYPE_CONTROL_ADDR        (0x800200 + VLAN_DECISION_BASE)
#define PORT3_ACCEPT_FRAME_TYPE_CONTROL_ADDR        (0x800300 + VLAN_DECISION_BASE)
#define PORT4_ACCEPT_FRAME_TYPE_CONTROL_ADDR        (0x800400 + VLAN_DECISION_BASE)
#define PORT5_ACCEPT_FRAME_TYPE_CONTROL_ADDR        (0x800500 + VLAN_DECISION_BASE)
#define PORT6_ACCEPT_FRAME_TYPE_CONTROL_ADDR        (0x800600 + VLAN_DECISION_BASE)
#define PORT7_ACCEPT_FRAME_TYPE_CONTROL_ADDR        (0x800700 + VLAN_DECISION_BASE)
#define PORT8_ACCEPT_FRAME_TYPE_CONTROL_ADDR        (0x800800 + VLAN_DECISION_BASE)
#define PORT9_ACCEPT_FRAME_TYPE_CONTROL_ADDR        (0x800900 + VLAN_DECISION_BASE)
#define PORT10_ACCEPT_FRAME_TYPE_CONTROL_ADDR        (0x800A00 + VLAN_DECISION_BASE)
#define PORT11_ACCEPT_FRAME_TYPE_CONTROL_ADDR        (0x800B00 + VLAN_DECISION_BASE)
#define PORT12_ACCEPT_FRAME_TYPE_CONTROL_ADDR        (0x800C00 + VLAN_DECISION_BASE)
#define PORT13_ACCEPT_FRAME_TYPE_CONTROL_ADDR        (0x800D00 + VLAN_DECISION_BASE)
#define PORT14_ACCEPT_FRAME_TYPE_CONTROL_ADDR        (0x800E00 + VLAN_DECISION_BASE)
#define PORT15_ACCEPT_FRAME_TYPE_CONTROL_ADDR        (0x800F00 + VLAN_DECISION_BASE)
#define PORT16_ACCEPT_FRAME_TYPE_CONTROL_ADDR        (0x801000 + VLAN_DECISION_BASE)
#define PORT17_ACCEPT_FRAME_TYPE_CONTROL_ADDR        (0x801100 + VLAN_DECISION_BASE)
#define PORT18_ACCEPT_FRAME_TYPE_CONTROL_ADDR        (0x801200 + VLAN_DECISION_BASE)
#define PORT19_ACCEPT_FRAME_TYPE_CONTROL_ADDR        (0x801300 + VLAN_DECISION_BASE)
#define PORT20_ACCEPT_FRAME_TYPE_CONTROL_ADDR        (0x801400 + VLAN_DECISION_BASE)
#define PORT21_ACCEPT_FRAME_TYPE_CONTROL_ADDR        (0x801500 + VLAN_DECISION_BASE)
#define PORT22_ACCEPT_FRAME_TYPE_CONTROL_ADDR        (0x801600 + VLAN_DECISION_BASE)
#define PORT23_ACCEPT_FRAME_TYPE_CONTROL_ADDR        (0x801700 + VLAN_DECISION_BASE)
#define PORT24_ACCEPT_FRAME_TYPE_CONTROL_ADDR        (0x801800 + VLAN_DECISION_BASE)
#define PORT0_IGNORE_VLAN_TAG_CONTROL_ADDR        (0x800004 + VLAN_DECISION_BASE)
#define PORT1_IGNORE_VLAN_TAG_CONTROL_ADDR        (0x800104 + VLAN_DECISION_BASE)
#define PORT2_IGNORE_VLAN_TAG_CONTROL_ADDR        (0x800204 + VLAN_DECISION_BASE)
#define PORT3_IGNORE_VLAN_TAG_CONTROL_ADDR        (0x800304 + VLAN_DECISION_BASE)
#define PORT4_IGNORE_VLAN_TAG_CONTROL_ADDR        (0x800404 + VLAN_DECISION_BASE)
#define PORT5_IGNORE_VLAN_TAG_CONTROL_ADDR        (0x800504 + VLAN_DECISION_BASE)
#define PORT6_IGNORE_VLAN_TAG_CONTROL_ADDR        (0x800604 + VLAN_DECISION_BASE)
#define PORT7_IGNORE_VLAN_TAG_CONTROL_ADDR        (0x800704 + VLAN_DECISION_BASE)
#define PORT8_IGNORE_VLAN_TAG_CONTROL_ADDR        (0x800804 + VLAN_DECISION_BASE)
#define PORT9_IGNORE_VLAN_TAG_CONTROL_ADDR        (0x800904 + VLAN_DECISION_BASE)
#define PORT10_IGNORE_VLAN_TAG_CONTROL_ADDR        (0x800A04 + VLAN_DECISION_BASE)
#define PORT11_IGNORE_VLAN_TAG_CONTROL_ADDR        (0x800B04 + VLAN_DECISION_BASE)
#define PORT12_IGNORE_VLAN_TAG_CONTROL_ADDR        (0x800C04 + VLAN_DECISION_BASE)
#define PORT13_IGNORE_VLAN_TAG_CONTROL_ADDR        (0x800D04 + VLAN_DECISION_BASE)
#define PORT14_IGNORE_VLAN_TAG_CONTROL_ADDR        (0x800E04 + VLAN_DECISION_BASE)
#define PORT15_IGNORE_VLAN_TAG_CONTROL_ADDR        (0x800F04 + VLAN_DECISION_BASE)
#define PORT16_IGNORE_VLAN_TAG_CONTROL_ADDR        (0x801004 + VLAN_DECISION_BASE)
#define PORT17_IGNORE_VLAN_TAG_CONTROL_ADDR        (0x801104 + VLAN_DECISION_BASE)
#define PORT18_IGNORE_VLAN_TAG_CONTROL_ADDR        (0x801204 + VLAN_DECISION_BASE)
#define PORT19_IGNORE_VLAN_TAG_CONTROL_ADDR        (0x801304 + VLAN_DECISION_BASE)
#define PORT20_IGNORE_VLAN_TAG_CONTROL_ADDR        (0x801404 + VLAN_DECISION_BASE)
#define PORT21_IGNORE_VLAN_TAG_CONTROL_ADDR        (0x801504 + VLAN_DECISION_BASE)
#define PORT22_IGNORE_VLAN_TAG_CONTROL_ADDR        (0x801604 + VLAN_DECISION_BASE)
#define PORT23_IGNORE_VLAN_TAG_CONTROL_ADDR        (0x801704 + VLAN_DECISION_BASE)
#define PORT24_IGNORE_VLAN_TAG_CONTROL_ADDR        (0x801804 + VLAN_DECISION_BASE)

/* Module: VLAN PRIORITY EXTRACTION */
#define VLAN_PRIORITY_EXTRACTION_BASE            0xBB0A0000
#define INNER_TAG_PRIORITY_MAP_CONTROL0_ADDR        (0x0 + VLAN_PRIORITY_EXTRACTION_BASE)
#define INNER_TAG_PRIORITY_MAP_CONTROL1_ADDR        (0x4 + VLAN_PRIORITY_EXTRACTION_BASE)
#define OUTER_TAG_PRIORITY_MAP_CONTROL0_ADDR        (0x8 + VLAN_PRIORITY_EXTRACTION_BASE)
#define OUTER_TAG_PRIORITY_MAP_CONTROL1_ADDR        (0xC + VLAN_PRIORITY_EXTRACTION_BASE)
#define OUTER_TAG_PRIORITY_MAP_CONTROL2_ADDR        (0x10 + VLAN_PRIORITY_EXTRACTION_BASE)
#define OUTER_TAG_PRIORITY_MAP_CONTROL3_ADDR        (0x14 + VLAN_PRIORITY_EXTRACTION_BASE)
#define DSCP_PRIORITY_MAP_CONTROL0_ADDR        (0x18 + VLAN_PRIORITY_EXTRACTION_BASE)
#define DSCP_PRIORITY_MAP_CONTROL1_ADDR        (0x1C + VLAN_PRIORITY_EXTRACTION_BASE)
#define DSCP_PRIORITY_MAP_CONTROL2_ADDR        (0x20 + VLAN_PRIORITY_EXTRACTION_BASE)
#define DSCP_PRIORITY_MAP_CONTROL3_ADDR        (0x24 + VLAN_PRIORITY_EXTRACTION_BASE)
#define DSCP_PRIORITY_MAP_CONTROL4_ADDR        (0x28 + VLAN_PRIORITY_EXTRACTION_BASE)
#define DSCP_PRIORITY_MAP_CONTROL5_ADDR        (0x2C + VLAN_PRIORITY_EXTRACTION_BASE)
#define DSCP_PRIORITY_MAP_CONTROL6_ADDR        (0x30 + VLAN_PRIORITY_EXTRACTION_BASE)
#define DSCP_PRIORITY_MAP_CONTROL7_ADDR        (0x34 + VLAN_PRIORITY_EXTRACTION_BASE)
#define DSCP_PRIORITY_MAP_CONTROL8_ADDR        (0x38 + VLAN_PRIORITY_EXTRACTION_BASE)
#define DSCP_PRIORITY_MAP_CONTROL9_ADDR        (0x3C + VLAN_PRIORITY_EXTRACTION_BASE)
#define DSCP_PRIORITY_MAP_CONTROL10_ADDR        (0x40 + VLAN_PRIORITY_EXTRACTION_BASE)
#define DSCP_PRIORITY_MAP_CONTROL11_ADDR        (0x44 + VLAN_PRIORITY_EXTRACTION_BASE)
#define DSCP_PRIORITY_MAP_CONTROL12_ADDR        (0x48 + VLAN_PRIORITY_EXTRACTION_BASE)
#define DSCP_PRIORITY_MAP_CONTROL13_ADDR        (0x4C + VLAN_PRIORITY_EXTRACTION_BASE)
#define DSCP_PRIORITY_MAP_CONTROL14_ADDR        (0x50 + VLAN_PRIORITY_EXTRACTION_BASE)
#define DSCP_PRIORITY_MAP_CONTROL15_ADDR        (0x54 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PRIORITY_ARBITRATION_CONTROL0_ADDR        (0x58 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PRIORITY_ARBITRATION_CONTROL1_ADDR        (0x5C + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT0_PRIORITY_CONTROL_ADDR        (0x800000 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT1_PRIORITY_CONTROL_ADDR        (0x800100 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT2_PRIORITY_CONTROL_ADDR        (0x800200 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT3_PRIORITY_CONTROL_ADDR        (0x800300 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT4_PRIORITY_CONTROL_ADDR        (0x800400 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT5_PRIORITY_CONTROL_ADDR        (0x800500 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT6_PRIORITY_CONTROL_ADDR        (0x800600 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT7_PRIORITY_CONTROL_ADDR        (0x800700 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT8_PRIORITY_CONTROL_ADDR        (0x800800 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT9_PRIORITY_CONTROL_ADDR        (0x800900 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT10_PRIORITY_CONTROL_ADDR        (0x800A00 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT11_PRIORITY_CONTROL_ADDR        (0x800B00 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT12_PRIORITY_CONTROL_ADDR        (0x800C00 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT13_PRIORITY_CONTROL_ADDR        (0x800D00 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT14_PRIORITY_CONTROL_ADDR        (0x800E00 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT15_PRIORITY_CONTROL_ADDR        (0x800F00 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT16_PRIORITY_CONTROL_ADDR        (0x801000 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT17_PRIORITY_CONTROL_ADDR        (0x801100 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT18_PRIORITY_CONTROL_ADDR        (0x801200 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT19_PRIORITY_CONTROL_ADDR        (0x801300 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT20_PRIORITY_CONTROL_ADDR        (0x801400 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT21_PRIORITY_CONTROL_ADDR        (0x801500 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT22_PRIORITY_CONTROL_ADDR        (0x801600 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT23_PRIORITY_CONTROL_ADDR        (0x801700 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT24_PRIORITY_CONTROL_ADDR        (0x801800 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT0_RX_PRIORITY_COPY_CONTROL_ADDR        (0x800004 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT1_RX_PRIORITY_COPY_CONTROL_ADDR        (0x800104 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT2_RX_PRIORITY_COPY_CONTROL_ADDR        (0x800204 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT3_RX_PRIORITY_COPY_CONTROL_ADDR        (0x800304 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT4_RX_PRIORITY_COPY_CONTROL_ADDR        (0x800404 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT5_RX_PRIORITY_COPY_CONTROL_ADDR        (0x800504 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT6_RX_PRIORITY_COPY_CONTROL_ADDR        (0x800604 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT7_RX_PRIORITY_COPY_CONTROL_ADDR        (0x800704 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT8_RX_PRIORITY_COPY_CONTROL_ADDR        (0x800804 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT9_RX_PRIORITY_COPY_CONTROL_ADDR        (0x800904 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT10_RX_PRIORITY_COPY_CONTROL_ADDR        (0x800A04 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT11_RX_PRIORITY_COPY_CONTROL_ADDR        (0x800B04 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT12_RX_PRIORITY_COPY_CONTROL_ADDR        (0x800C04 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT13_RX_PRIORITY_COPY_CONTROL_ADDR        (0x800D04 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT14_RX_PRIORITY_COPY_CONTROL_ADDR        (0x800E04 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT15_RX_PRIORITY_COPY_CONTROL_ADDR        (0x800F04 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT16_RX_PRIORITY_COPY_CONTROL_ADDR        (0x801004 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT17_RX_PRIORITY_COPY_CONTROL_ADDR        (0x801104 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT18_RX_PRIORITY_COPY_CONTROL_ADDR        (0x801204 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT19_RX_PRIORITY_COPY_CONTROL_ADDR        (0x801304 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT20_RX_PRIORITY_COPY_CONTROL_ADDR        (0x801404 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT21_RX_PRIORITY_COPY_CONTROL_ADDR        (0x801504 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT22_RX_PRIORITY_COPY_CONTROL_ADDR        (0x801604 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT23_RX_PRIORITY_COPY_CONTROL_ADDR        (0x801704 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT24_RX_PRIORITY_COPY_CONTROL_ADDR        (0x801804 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT0_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_ADDR        (0x800008 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT1_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_ADDR        (0x800108 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT2_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_ADDR        (0x800208 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT3_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_ADDR        (0x800308 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT4_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_ADDR        (0x800408 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT5_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_ADDR        (0x800508 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT6_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_ADDR        (0x800608 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT7_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_ADDR        (0x800708 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT8_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_ADDR        (0x800808 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT9_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_ADDR        (0x800908 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT10_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_ADDR        (0x800A08 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT11_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_ADDR        (0x800B08 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT12_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_ADDR        (0x800C08 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT13_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_ADDR        (0x800D08 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT14_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_ADDR        (0x800E08 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT15_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_ADDR        (0x800F08 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT16_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_ADDR        (0x801008 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT17_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_ADDR        (0x801108 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT18_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_ADDR        (0x801208 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT19_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_ADDR        (0x801308 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT20_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_ADDR        (0x801408 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT21_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_ADDR        (0x801508 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT22_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_ADDR        (0x801608 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT23_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_ADDR        (0x801708 + VLAN_PRIORITY_EXTRACTION_BASE)
#define PORT24_PRIORITY_MAP_TO_QUEUENUMBER_CONTROL_ADDR        (0x801808 + VLAN_PRIORITY_EXTRACTION_BASE)

/* Module: VLAN TABLE LOOKUP AND TAG STATUS */
#define VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE            0xBB0B0000
#define VLAN_TABLE_LOOKUP_MISS_CONTROL_ADDR        (0x0 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define ADDRESS_LOOKUP_BASED_ON_VID_OR_FID_CONTROL_ADDR        (0x4 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT0_VLAN_INGRESS_FILTER_CONTROL_ADDR        (0x800000 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT1_VLAN_INGRESS_FILTER_CONTROL_ADDR        (0x800100 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT2_VLAN_INGRESS_FILTER_CONTROL_ADDR        (0x800200 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT3_VLAN_INGRESS_FILTER_CONTROL_ADDR        (0x800300 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT4_VLAN_INGRESS_FILTER_CONTROL_ADDR        (0x800400 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT5_VLAN_INGRESS_FILTER_CONTROL_ADDR        (0x800500 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT6_VLAN_INGRESS_FILTER_CONTROL_ADDR        (0x800600 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT7_VLAN_INGRESS_FILTER_CONTROL_ADDR        (0x800700 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT8_VLAN_INGRESS_FILTER_CONTROL_ADDR        (0x800800 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT9_VLAN_INGRESS_FILTER_CONTROL_ADDR        (0x800900 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT10_VLAN_INGRESS_FILTER_CONTROL_ADDR        (0x800A00 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT11_VLAN_INGRESS_FILTER_CONTROL_ADDR        (0x800B00 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT12_VLAN_INGRESS_FILTER_CONTROL_ADDR        (0x800C00 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT13_VLAN_INGRESS_FILTER_CONTROL_ADDR        (0x800D00 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT14_VLAN_INGRESS_FILTER_CONTROL_ADDR        (0x800E00 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT15_VLAN_INGRESS_FILTER_CONTROL_ADDR        (0x800F00 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT16_VLAN_INGRESS_FILTER_CONTROL_ADDR        (0x801000 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT17_VLAN_INGRESS_FILTER_CONTROL_ADDR        (0x801100 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT18_VLAN_INGRESS_FILTER_CONTROL_ADDR        (0x801200 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT19_VLAN_INGRESS_FILTER_CONTROL_ADDR        (0x801300 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT20_VLAN_INGRESS_FILTER_CONTROL_ADDR        (0x801400 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT21_VLAN_INGRESS_FILTER_CONTROL_ADDR        (0x801500 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT22_VLAN_INGRESS_FILTER_CONTROL_ADDR        (0x801600 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT23_VLAN_INGRESS_FILTER_CONTROL_ADDR        (0x801700 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT24_VLAN_INGRESS_FILTER_CONTROL_ADDR        (0x801800 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT0_FORWARDING_TAG_SELECT_CONTROL_ADDR        (0x800004 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT1_FORWARDING_TAG_SELECT_CONTROL_ADDR        (0x800104 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT2_FORWARDING_TAG_SELECT_CONTROL_ADDR        (0x800204 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT3_FORWARDING_TAG_SELECT_CONTROL_ADDR        (0x800304 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT4_FORWARDING_TAG_SELECT_CONTROL_ADDR        (0x800404 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT5_FORWARDING_TAG_SELECT_CONTROL_ADDR        (0x800504 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT6_FORWARDING_TAG_SELECT_CONTROL_ADDR        (0x800604 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT7_FORWARDING_TAG_SELECT_CONTROL_ADDR        (0x800704 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT8_FORWARDING_TAG_SELECT_CONTROL_ADDR        (0x800804 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT9_FORWARDING_TAG_SELECT_CONTROL_ADDR        (0x800904 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT10_FORWARDING_TAG_SELECT_CONTROL_ADDR        (0x800A04 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT11_FORWARDING_TAG_SELECT_CONTROL_ADDR        (0x800B04 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT12_FORWARDING_TAG_SELECT_CONTROL_ADDR        (0x800C04 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT13_FORWARDING_TAG_SELECT_CONTROL_ADDR        (0x800D04 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT14_FORWARDING_TAG_SELECT_CONTROL_ADDR        (0x800E04 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT15_FORWARDING_TAG_SELECT_CONTROL_ADDR        (0x800F04 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT16_FORWARDING_TAG_SELECT_CONTROL_ADDR        (0x801004 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT17_FORWARDING_TAG_SELECT_CONTROL_ADDR        (0x801104 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT18_FORWARDING_TAG_SELECT_CONTROL_ADDR        (0x801204 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT19_FORWARDING_TAG_SELECT_CONTROL_ADDR        (0x801304 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT20_FORWARDING_TAG_SELECT_CONTROL_ADDR        (0x801404 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT21_FORWARDING_TAG_SELECT_CONTROL_ADDR        (0x801504 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT22_FORWARDING_TAG_SELECT_CONTROL_ADDR        (0x801604 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT23_FORWARDING_TAG_SELECT_CONTROL_ADDR        (0x801704 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT24_FORWARDING_TAG_SELECT_CONTROL_ADDR        (0x801804 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT0_EGRESS_TAG_STATUS_CONTROL_ADDR        (0x800008 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT1_EGRESS_TAG_STATUS_CONTROL_ADDR        (0x800108 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT2_EGRESS_TAG_STATUS_CONTROL_ADDR        (0x800208 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT3_EGRESS_TAG_STATUS_CONTROL_ADDR        (0x800308 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT4_EGRESS_TAG_STATUS_CONTROL_ADDR        (0x800408 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT5_EGRESS_TAG_STATUS_CONTROL_ADDR        (0x800508 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT6_EGRESS_TAG_STATUS_CONTROL_ADDR        (0x800608 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT7_EGRESS_TAG_STATUS_CONTROL_ADDR        (0x800708 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT8_EGRESS_TAG_STATUS_CONTROL_ADDR        (0x800808 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT9_EGRESS_TAG_STATUS_CONTROL_ADDR        (0x800908 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT10_EGRESS_TAG_STATUS_CONTROL_ADDR        (0x800A08 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT11_EGRESS_TAG_STATUS_CONTROL_ADDR        (0x800B08 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT12_EGRESS_TAG_STATUS_CONTROL_ADDR        (0x800C08 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT13_EGRESS_TAG_STATUS_CONTROL_ADDR        (0x800D08 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT14_EGRESS_TAG_STATUS_CONTROL_ADDR        (0x800E08 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT15_EGRESS_TAG_STATUS_CONTROL_ADDR        (0x800F08 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT16_EGRESS_TAG_STATUS_CONTROL_ADDR        (0x801008 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT17_EGRESS_TAG_STATUS_CONTROL_ADDR        (0x801108 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT18_EGRESS_TAG_STATUS_CONTROL_ADDR        (0x801208 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT19_EGRESS_TAG_STATUS_CONTROL_ADDR        (0x801308 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT20_EGRESS_TAG_STATUS_CONTROL_ADDR        (0x801408 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT21_EGRESS_TAG_STATUS_CONTROL_ADDR        (0x801508 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT22_EGRESS_TAG_STATUS_CONTROL_ADDR        (0x801608 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT23_EGRESS_TAG_STATUS_CONTROL_ADDR        (0x801708 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT24_EGRESS_TAG_STATUS_CONTROL_ADDR        (0x801808 + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT0_VLAN_EGRESS_FILTER_CONTROL_ADDR        (0x80000C + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT1_VLAN_EGRESS_FILTER_CONTROL_ADDR        (0x80010C + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT2_VLAN_EGRESS_FILTER_CONTROL_ADDR        (0x80020C + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT3_VLAN_EGRESS_FILTER_CONTROL_ADDR        (0x80030C + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT4_VLAN_EGRESS_FILTER_CONTROL_ADDR        (0x80040C + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT5_VLAN_EGRESS_FILTER_CONTROL_ADDR        (0x80050C + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT6_VLAN_EGRESS_FILTER_CONTROL_ADDR        (0x80060C + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT7_VLAN_EGRESS_FILTER_CONTROL_ADDR        (0x80070C + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT8_VLAN_EGRESS_FILTER_CONTROL_ADDR        (0x80080C + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT9_VLAN_EGRESS_FILTER_CONTROL_ADDR        (0x80090C + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT10_VLAN_EGRESS_FILTER_CONTROL_ADDR        (0x800A0C + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT11_VLAN_EGRESS_FILTER_CONTROL_ADDR        (0x800B0C + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT12_VLAN_EGRESS_FILTER_CONTROL_ADDR        (0x800C0C + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT13_VLAN_EGRESS_FILTER_CONTROL_ADDR        (0x800D0C + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT14_VLAN_EGRESS_FILTER_CONTROL_ADDR        (0x800E0C + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT15_VLAN_EGRESS_FILTER_CONTROL_ADDR        (0x800F0C + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT16_VLAN_EGRESS_FILTER_CONTROL_ADDR        (0x80100C + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT17_VLAN_EGRESS_FILTER_CONTROL_ADDR        (0x80110C + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT18_VLAN_EGRESS_FILTER_CONTROL_ADDR        (0x80120C + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT19_VLAN_EGRESS_FILTER_CONTROL_ADDR        (0x80130C + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT20_VLAN_EGRESS_FILTER_CONTROL_ADDR        (0x80140C + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT21_VLAN_EGRESS_FILTER_CONTROL_ADDR        (0x80150C + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT22_VLAN_EGRESS_FILTER_CONTROL_ADDR        (0x80160C + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT23_VLAN_EGRESS_FILTER_CONTROL_ADDR        (0x80170C + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)
#define PORT24_VLAN_EGRESS_FILTER_CONTROL_ADDR        (0x80180C + VLAN_TABLE_LOOKUP_AND_TAG_STATUS_BASE)

/* Module: L2 MISC */
#define L2_MISC_BASE            0xBB100000
#define GLOBAL_MAC_L2_MISC0_ADDR        (0x0 + L2_MISC_BASE)
#define PORT0_L2_MISC0_ADDR        (0x800000 + L2_MISC_BASE)
#define PORT1_L2_MISC0_ADDR        (0x800100 + L2_MISC_BASE)
#define PORT2_L2_MISC0_ADDR        (0x800200 + L2_MISC_BASE)
#define PORT3_L2_MISC0_ADDR        (0x800300 + L2_MISC_BASE)
#define PORT4_L2_MISC0_ADDR        (0x800400 + L2_MISC_BASE)
#define PORT5_L2_MISC0_ADDR        (0x800500 + L2_MISC_BASE)
#define PORT6_L2_MISC0_ADDR        (0x800600 + L2_MISC_BASE)
#define PORT7_L2_MISC0_ADDR        (0x800700 + L2_MISC_BASE)
#define PORT8_L2_MISC0_ADDR        (0x800800 + L2_MISC_BASE)
#define PORT9_L2_MISC0_ADDR        (0x800900 + L2_MISC_BASE)
#define PORT10_L2_MISC0_ADDR        (0x800A00 + L2_MISC_BASE)
#define PORT11_L2_MISC0_ADDR        (0x800B00 + L2_MISC_BASE)
#define PORT12_L2_MISC0_ADDR        (0x800C00 + L2_MISC_BASE)
#define PORT13_L2_MISC0_ADDR        (0x800D00 + L2_MISC_BASE)
#define PORT14_L2_MISC0_ADDR        (0x800E00 + L2_MISC_BASE)
#define PORT15_L2_MISC0_ADDR        (0x800F00 + L2_MISC_BASE)
#define PORT16_L2_MISC0_ADDR        (0x801000 + L2_MISC_BASE)
#define PORT17_L2_MISC0_ADDR        (0x801100 + L2_MISC_BASE)
#define PORT18_L2_MISC0_ADDR        (0x801200 + L2_MISC_BASE)
#define PORT19_L2_MISC0_ADDR        (0x801300 + L2_MISC_BASE)
#define PORT20_L2_MISC0_ADDR        (0x801400 + L2_MISC_BASE)
#define PORT21_L2_MISC0_ADDR        (0x801500 + L2_MISC_BASE)
#define PORT22_L2_MISC0_ADDR        (0x801600 + L2_MISC_BASE)
#define PORT23_L2_MISC0_ADDR        (0x801700 + L2_MISC_BASE)
#define PORT24_L2_MISC0_ADDR        (0x801800 + L2_MISC_BASE)

/* Module: ADDRESS TABLE LOOKUP */
#define ADDRESS_TABLE_LOOKUP_BASE            0xBB110000
#define ADDRESS_TABLE_LOOKUP_CONTROL_ADDR        (0x0 + ADDRESS_TABLE_LOOKUP_BASE)
#define ADDRESS_TABLE_LOOKUP_MISS_CONTROL_ADDR        (0x4 + ADDRESS_TABLE_LOOKUP_BASE)
#define ADDRESS_TABLE_MULTICAST_CONTROL0_ADDR        (0x8 + ADDRESS_TABLE_LOOKUP_BASE)
#define ADDRESS_TABLE_MULTICAST_CONTROL1_ADDR        (0xC + ADDRESS_TABLE_LOOKUP_BASE)
#define PORT0_SOURCE_PORT_FILTER_ADDR        (0x800000 + ADDRESS_TABLE_LOOKUP_BASE)
#define PORT1_SOURCE_PORT_FILTER_ADDR        (0x800100 + ADDRESS_TABLE_LOOKUP_BASE)
#define PORT2_SOURCE_PORT_FILTER_ADDR        (0x800200 + ADDRESS_TABLE_LOOKUP_BASE)
#define PORT3_SOURCE_PORT_FILTER_ADDR        (0x800300 + ADDRESS_TABLE_LOOKUP_BASE)
#define PORT4_SOURCE_PORT_FILTER_ADDR        (0x800400 + ADDRESS_TABLE_LOOKUP_BASE)
#define PORT5_SOURCE_PORT_FILTER_ADDR        (0x800500 + ADDRESS_TABLE_LOOKUP_BASE)
#define PORT6_SOURCE_PORT_FILTER_ADDR        (0x800600 + ADDRESS_TABLE_LOOKUP_BASE)
#define PORT7_SOURCE_PORT_FILTER_ADDR        (0x800700 + ADDRESS_TABLE_LOOKUP_BASE)
#define PORT8_SOURCE_PORT_FILTER_ADDR        (0x800800 + ADDRESS_TABLE_LOOKUP_BASE)
#define PORT9_SOURCE_PORT_FILTER_ADDR        (0x800900 + ADDRESS_TABLE_LOOKUP_BASE)
#define PORT10_SOURCE_PORT_FILTER_ADDR        (0x800A00 + ADDRESS_TABLE_LOOKUP_BASE)
#define PORT11_SOURCE_PORT_FILTER_ADDR        (0x800B00 + ADDRESS_TABLE_LOOKUP_BASE)
#define PORT12_SOURCE_PORT_FILTER_ADDR        (0x800C00 + ADDRESS_TABLE_LOOKUP_BASE)
#define PORT13_SOURCE_PORT_FILTER_ADDR        (0x800D00 + ADDRESS_TABLE_LOOKUP_BASE)
#define PORT14_SOURCE_PORT_FILTER_ADDR        (0x800E00 + ADDRESS_TABLE_LOOKUP_BASE)
#define PORT15_SOURCE_PORT_FILTER_ADDR        (0x800F00 + ADDRESS_TABLE_LOOKUP_BASE)
#define PORT16_SOURCE_PORT_FILTER_ADDR        (0x801000 + ADDRESS_TABLE_LOOKUP_BASE)
#define PORT17_SOURCE_PORT_FILTER_ADDR        (0x801100 + ADDRESS_TABLE_LOOKUP_BASE)
#define PORT18_SOURCE_PORT_FILTER_ADDR        (0x801200 + ADDRESS_TABLE_LOOKUP_BASE)
#define PORT19_SOURCE_PORT_FILTER_ADDR        (0x801300 + ADDRESS_TABLE_LOOKUP_BASE)
#define PORT20_SOURCE_PORT_FILTER_ADDR        (0x801400 + ADDRESS_TABLE_LOOKUP_BASE)
#define PORT21_SOURCE_PORT_FILTER_ADDR        (0x801500 + ADDRESS_TABLE_LOOKUP_BASE)
#define PORT22_SOURCE_PORT_FILTER_ADDR        (0x801600 + ADDRESS_TABLE_LOOKUP_BASE)
#define PORT23_SOURCE_PORT_FILTER_ADDR        (0x801700 + ADDRESS_TABLE_LOOKUP_BASE)
#define PORT24_SOURCE_PORT_FILTER_ADDR        (0x801800 + ADDRESS_TABLE_LOOKUP_BASE)

/* Module: SPANNING TREE */
#define SPANNING_TREE_BASE            0xBB120000
#define SPANNING_TREE_PORT_STATE_CONTROL0A_ADDR        (0x0 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL0B_ADDR        (0x4 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL1A_ADDR        (0x8 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL1B_ADDR        (0xC + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL2A_ADDR        (0x10 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL2B_ADDR        (0x14 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL3A_ADDR        (0x18 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL3B_ADDR        (0x1C + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL4A_ADDR        (0x20 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL4B_ADDR        (0x24 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL5A_ADDR        (0x28 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL5B_ADDR        (0x2C + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL6A_ADDR        (0x30 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL6B_ADDR        (0x34 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL7A_ADDR        (0x38 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL7B_ADDR        (0x3C + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL8A_ADDR        (0x40 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL8B_ADDR        (0x44 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL9A_ADDR        (0x48 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL9B_ADDR        (0x4C + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL10A_ADDR        (0x50 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL10B_ADDR        (0x54 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL11A_ADDR        (0x58 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL11B_ADDR        (0x5C + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL12A_ADDR        (0x60 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL12B_ADDR        (0x64 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL13A_ADDR        (0x68 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL13B_ADDR        (0x6C + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL14A_ADDR        (0x70 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL14B_ADDR        (0x74 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL15A_ADDR        (0x78 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL15B_ADDR        (0x7C + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL16A_ADDR        (0x80 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL16B_ADDR        (0x84 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL17A_ADDR        (0x88 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL17B_ADDR        (0x8C + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL18A_ADDR        (0x90 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL18B_ADDR        (0x94 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL19A_ADDR        (0x98 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL19B_ADDR        (0x9C + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL20A_ADDR        (0xA0 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL20B_ADDR        (0xA4 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL21A_ADDR        (0xA8 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL21B_ADDR        (0xAC + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL22A_ADDR        (0xB0 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL22B_ADDR        (0xB4 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL23A_ADDR        (0xB8 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL23B_ADDR        (0xBC + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL24A_ADDR        (0xC0 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL24B_ADDR        (0xC4 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL25A_ADDR        (0xC8 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL25B_ADDR        (0xCC + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL26A_ADDR        (0xD0 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL26B_ADDR        (0xD4 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL27A_ADDR        (0xD8 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL27B_ADDR        (0xDC + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL28A_ADDR        (0xE0 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL28B_ADDR        (0xE4 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL29A_ADDR        (0xE8 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL29B_ADDR        (0xEC + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL30A_ADDR        (0xF0 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL30B_ADDR        (0xF4 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL31A_ADDR        (0xF8 + SPANNING_TREE_BASE)
#define SPANNING_TREE_PORT_STATE_CONTROL31B_ADDR        (0xFC + SPANNING_TREE_BASE)

/* Module: SOURCE MAC LEARNING */
#define SOURCE_MAC_LEARNING_BASE            0xBB130000
#define SOURCE_MAC_LEARNING_CONTROL_ADDR        (0x0 + SOURCE_MAC_LEARNING_BASE)
#define ADDRESS_TABLE_OPERATE_CONTROL0_ADDR        (0x4 + SOURCE_MAC_LEARNING_BASE)
#define ADDRESS_TABLE_OPERATE_CONTROL1_ADDR        (0x8 + SOURCE_MAC_LEARNING_BASE)
#define ADDRESS_TABLE_OPERATE_CONTROL2_ADDR        (0xC + SOURCE_MAC_LEARNING_BASE)
#define ADDRESS_TABLE_OPERATE_CONTROL3_ADDR        (0x10 + SOURCE_MAC_LEARNING_BASE)
#define PORT0_MAC_ADDRESS_LEARNING_CONTROL_ADDR        (0x800000 + SOURCE_MAC_LEARNING_BASE)
#define PORT1_MAC_ADDRESS_LEARNING_CONTROL_ADDR        (0x800100 + SOURCE_MAC_LEARNING_BASE)
#define PORT2_MAC_ADDRESS_LEARNING_CONTROL_ADDR        (0x800200 + SOURCE_MAC_LEARNING_BASE)
#define PORT3_MAC_ADDRESS_LEARNING_CONTROL_ADDR        (0x800300 + SOURCE_MAC_LEARNING_BASE)
#define PORT4_MAC_ADDRESS_LEARNING_CONTROL_ADDR        (0x800400 + SOURCE_MAC_LEARNING_BASE)
#define PORT5_MAC_ADDRESS_LEARNING_CONTROL_ADDR        (0x800500 + SOURCE_MAC_LEARNING_BASE)
#define PORT6_MAC_ADDRESS_LEARNING_CONTROL_ADDR        (0x800600 + SOURCE_MAC_LEARNING_BASE)
#define PORT7_MAC_ADDRESS_LEARNING_CONTROL_ADDR        (0x800700 + SOURCE_MAC_LEARNING_BASE)
#define PORT8_MAC_ADDRESS_LEARNING_CONTROL_ADDR        (0x800800 + SOURCE_MAC_LEARNING_BASE)
#define PORT9_MAC_ADDRESS_LEARNING_CONTROL_ADDR        (0x800900 + SOURCE_MAC_LEARNING_BASE)
#define PORT10_MAC_ADDRESS_LEARNING_CONTROL_ADDR        (0x800A00 + SOURCE_MAC_LEARNING_BASE)
#define PORT11_MAC_ADDRESS_LEARNING_CONTROL_ADDR        (0x800B00 + SOURCE_MAC_LEARNING_BASE)
#define PORT12_MAC_ADDRESS_LEARNING_CONTROL_ADDR        (0x800C00 + SOURCE_MAC_LEARNING_BASE)
#define PORT13_MAC_ADDRESS_LEARNING_CONTROL_ADDR        (0x800D00 + SOURCE_MAC_LEARNING_BASE)
#define PORT14_MAC_ADDRESS_LEARNING_CONTROL_ADDR        (0x800E00 + SOURCE_MAC_LEARNING_BASE)
#define PORT15_MAC_ADDRESS_LEARNING_CONTROL_ADDR        (0x800F00 + SOURCE_MAC_LEARNING_BASE)
#define PORT16_MAC_ADDRESS_LEARNING_CONTROL_ADDR        (0x801000 + SOURCE_MAC_LEARNING_BASE)
#define PORT17_MAC_ADDRESS_LEARNING_CONTROL_ADDR        (0x801100 + SOURCE_MAC_LEARNING_BASE)
#define PORT18_MAC_ADDRESS_LEARNING_CONTROL_ADDR        (0x801200 + SOURCE_MAC_LEARNING_BASE)
#define PORT19_MAC_ADDRESS_LEARNING_CONTROL_ADDR        (0x801300 + SOURCE_MAC_LEARNING_BASE)
#define PORT20_MAC_ADDRESS_LEARNING_CONTROL_ADDR        (0x801400 + SOURCE_MAC_LEARNING_BASE)
#define PORT21_MAC_ADDRESS_LEARNING_CONTROL_ADDR        (0x801500 + SOURCE_MAC_LEARNING_BASE)
#define PORT22_MAC_ADDRESS_LEARNING_CONTROL_ADDR        (0x801600 + SOURCE_MAC_LEARNING_BASE)
#define PORT23_MAC_ADDRESS_LEARNING_CONTROL_ADDR        (0x801700 + SOURCE_MAC_LEARNING_BASE)
#define PORT24_MAC_ADDRESS_LEARNING_CONTROL_ADDR        (0x801800 + SOURCE_MAC_LEARNING_BASE)

/* Module: DOT1X */
#define DOT1X_BASE            0xBB140000
#define GUEST_VLAN_GLOBAL_CONTROL_ADDR        (0x0 + DOT1X_BASE)
#define DOT1X_NETWORK_ACCESS_RELATED_CONTROL_ADDR        (0x4 + DOT1X_BASE)
#define PORT0_BASED_DOT1X_CONTROL_ADDR        (0x800000 + DOT1X_BASE)
#define PORT1_BASED_DOT1X_CONTROL_ADDR        (0x800100 + DOT1X_BASE)
#define PORT2_BASED_DOT1X_CONTROL_ADDR        (0x800200 + DOT1X_BASE)
#define PORT3_BASED_DOT1X_CONTROL_ADDR        (0x800300 + DOT1X_BASE)
#define PORT4_BASED_DOT1X_CONTROL_ADDR        (0x800400 + DOT1X_BASE)
#define PORT5_BASED_DOT1X_CONTROL_ADDR        (0x800500 + DOT1X_BASE)
#define PORT6_BASED_DOT1X_CONTROL_ADDR        (0x800600 + DOT1X_BASE)
#define PORT7_BASED_DOT1X_CONTROL_ADDR        (0x800700 + DOT1X_BASE)
#define PORT8_BASED_DOT1X_CONTROL_ADDR        (0x800800 + DOT1X_BASE)
#define PORT9_BASED_DOT1X_CONTROL_ADDR        (0x800900 + DOT1X_BASE)
#define PORT10_BASED_DOT1X_CONTROL_ADDR        (0x800A00 + DOT1X_BASE)
#define PORT11_BASED_DOT1X_CONTROL_ADDR        (0x800B00 + DOT1X_BASE)
#define PORT12_BASED_DOT1X_CONTROL_ADDR        (0x800C00 + DOT1X_BASE)
#define PORT13_BASED_DOT1X_CONTROL_ADDR        (0x800D00 + DOT1X_BASE)
#define PORT14_BASED_DOT1X_CONTROL_ADDR        (0x800E00 + DOT1X_BASE)
#define PORT15_BASED_DOT1X_CONTROL_ADDR        (0x800F00 + DOT1X_BASE)
#define PORT16_BASED_DOT1X_CONTROL_ADDR        (0x801000 + DOT1X_BASE)
#define PORT17_BASED_DOT1X_CONTROL_ADDR        (0x801100 + DOT1X_BASE)
#define PORT18_BASED_DOT1X_CONTROL_ADDR        (0x801200 + DOT1X_BASE)
#define PORT19_BASED_DOT1X_CONTROL_ADDR        (0x801300 + DOT1X_BASE)
#define PORT20_BASED_DOT1X_CONTROL_ADDR        (0x801400 + DOT1X_BASE)
#define PORT21_BASED_DOT1X_CONTROL_ADDR        (0x801500 + DOT1X_BASE)
#define PORT22_BASED_DOT1X_CONTROL_ADDR        (0x801600 + DOT1X_BASE)
#define PORT23_BASED_DOT1X_CONTROL_ADDR        (0x801700 + DOT1X_BASE)
#define PORT24_BASED_DOT1X_CONTROL_ADDR        (0x801800 + DOT1X_BASE)
#define PORT0_EGRESS_DOT1X_CONTROL_ADDR        (0x800004 + DOT1X_BASE)
#define PORT1_EGRESS_DOT1X_CONTROL_ADDR        (0x800104 + DOT1X_BASE)
#define PORT2_EGRESS_DOT1X_CONTROL_ADDR        (0x800204 + DOT1X_BASE)
#define PORT3_EGRESS_DOT1X_CONTROL_ADDR        (0x800304 + DOT1X_BASE)
#define PORT4_EGRESS_DOT1X_CONTROL_ADDR        (0x800404 + DOT1X_BASE)
#define PORT5_EGRESS_DOT1X_CONTROL_ADDR        (0x800504 + DOT1X_BASE)
#define PORT6_EGRESS_DOT1X_CONTROL_ADDR        (0x800604 + DOT1X_BASE)
#define PORT7_EGRESS_DOT1X_CONTROL_ADDR        (0x800704 + DOT1X_BASE)
#define PORT8_EGRESS_DOT1X_CONTROL_ADDR        (0x800804 + DOT1X_BASE)
#define PORT9_EGRESS_DOT1X_CONTROL_ADDR        (0x800904 + DOT1X_BASE)
#define PORT10_EGRESS_DOT1X_CONTROL_ADDR        (0x800A04 + DOT1X_BASE)
#define PORT11_EGRESS_DOT1X_CONTROL_ADDR        (0x800B04 + DOT1X_BASE)
#define PORT12_EGRESS_DOT1X_CONTROL_ADDR        (0x800C04 + DOT1X_BASE)
#define PORT13_EGRESS_DOT1X_CONTROL_ADDR        (0x800D04 + DOT1X_BASE)
#define PORT14_EGRESS_DOT1X_CONTROL_ADDR        (0x800E04 + DOT1X_BASE)
#define PORT15_EGRESS_DOT1X_CONTROL_ADDR        (0x800F04 + DOT1X_BASE)
#define PORT16_EGRESS_DOT1X_CONTROL_ADDR        (0x801004 + DOT1X_BASE)
#define PORT17_EGRESS_DOT1X_CONTROL_ADDR        (0x801104 + DOT1X_BASE)
#define PORT18_EGRESS_DOT1X_CONTROL_ADDR        (0x801204 + DOT1X_BASE)
#define PORT19_EGRESS_DOT1X_CONTROL_ADDR        (0x801304 + DOT1X_BASE)
#define PORT20_EGRESS_DOT1X_CONTROL_ADDR        (0x801404 + DOT1X_BASE)
#define PORT21_EGRESS_DOT1X_CONTROL_ADDR        (0x801504 + DOT1X_BASE)
#define PORT22_EGRESS_DOT1X_CONTROL_ADDR        (0x801604 + DOT1X_BASE)
#define PORT23_EGRESS_DOT1X_CONTROL_ADDR        (0x801704 + DOT1X_BASE)
#define PORT24_EGRESS_DOT1X_CONTROL_ADDR        (0x801804 + DOT1X_BASE)
#define PORT0_MAC_BASED_DOT1X_CONTROL_ADDR        (0x800008 + DOT1X_BASE)
#define PORT1_MAC_BASED_DOT1X_CONTROL_ADDR        (0x800108 + DOT1X_BASE)
#define PORT2_MAC_BASED_DOT1X_CONTROL_ADDR        (0x800208 + DOT1X_BASE)
#define PORT3_MAC_BASED_DOT1X_CONTROL_ADDR        (0x800308 + DOT1X_BASE)
#define PORT4_MAC_BASED_DOT1X_CONTROL_ADDR        (0x800408 + DOT1X_BASE)
#define PORT5_MAC_BASED_DOT1X_CONTROL_ADDR        (0x800508 + DOT1X_BASE)
#define PORT6_MAC_BASED_DOT1X_CONTROL_ADDR        (0x800608 + DOT1X_BASE)
#define PORT7_MAC_BASED_DOT1X_CONTROL_ADDR        (0x800708 + DOT1X_BASE)
#define PORT8_MAC_BASED_DOT1X_CONTROL_ADDR        (0x800808 + DOT1X_BASE)
#define PORT9_MAC_BASED_DOT1X_CONTROL_ADDR        (0x800908 + DOT1X_BASE)
#define PORT10_MAC_BASED_DOT1X_CONTROL_ADDR        (0x800A08 + DOT1X_BASE)
#define PORT11_MAC_BASED_DOT1X_CONTROL_ADDR        (0x800B08 + DOT1X_BASE)
#define PORT12_MAC_BASED_DOT1X_CONTROL_ADDR        (0x800C08 + DOT1X_BASE)
#define PORT13_MAC_BASED_DOT1X_CONTROL_ADDR        (0x800D08 + DOT1X_BASE)
#define PORT14_MAC_BASED_DOT1X_CONTROL_ADDR        (0x800E08 + DOT1X_BASE)
#define PORT15_MAC_BASED_DOT1X_CONTROL_ADDR        (0x800F08 + DOT1X_BASE)
#define PORT16_MAC_BASED_DOT1X_CONTROL_ADDR        (0x801008 + DOT1X_BASE)
#define PORT17_MAC_BASED_DOT1X_CONTROL_ADDR        (0x801108 + DOT1X_BASE)
#define PORT18_MAC_BASED_DOT1X_CONTROL_ADDR        (0x801208 + DOT1X_BASE)
#define PORT19_MAC_BASED_DOT1X_CONTROL_ADDR        (0x801308 + DOT1X_BASE)
#define PORT20_MAC_BASED_DOT1X_CONTROL_ADDR        (0x801408 + DOT1X_BASE)
#define PORT21_MAC_BASED_DOT1X_CONTROL_ADDR        (0x801508 + DOT1X_BASE)
#define PORT22_MAC_BASED_DOT1X_CONTROL_ADDR        (0x801608 + DOT1X_BASE)
#define PORT23_MAC_BASED_DOT1X_CONTROL_ADDR        (0x801708 + DOT1X_BASE)
#define PORT24_MAC_BASED_DOT1X_CONTROL_ADDR        (0x801808 + DOT1X_BASE)

/* Module: L2 ENTRY NUMBER CONSTRAIN */
#define L2_ENTRY_NUMBER_CONSTRAIN_BASE            0xBB150000
#define MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL_ADDR        (0x0 + L2_ENTRY_NUMBER_CONSTRAIN_BASE)
#define PORT0_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_ADDR        (0x800000 + L2_ENTRY_NUMBER_CONSTRAIN_BASE)
#define PORT1_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_ADDR        (0x800100 + L2_ENTRY_NUMBER_CONSTRAIN_BASE)
#define PORT2_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_ADDR        (0x800200 + L2_ENTRY_NUMBER_CONSTRAIN_BASE)
#define PORT3_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_ADDR        (0x800300 + L2_ENTRY_NUMBER_CONSTRAIN_BASE)
#define PORT4_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_ADDR        (0x800400 + L2_ENTRY_NUMBER_CONSTRAIN_BASE)
#define PORT5_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_ADDR        (0x800500 + L2_ENTRY_NUMBER_CONSTRAIN_BASE)
#define PORT6_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_ADDR        (0x800600 + L2_ENTRY_NUMBER_CONSTRAIN_BASE)
#define PORT7_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_ADDR        (0x800700 + L2_ENTRY_NUMBER_CONSTRAIN_BASE)
#define PORT8_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_ADDR        (0x800800 + L2_ENTRY_NUMBER_CONSTRAIN_BASE)
#define PORT9_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_ADDR        (0x800900 + L2_ENTRY_NUMBER_CONSTRAIN_BASE)
#define PORT10_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_ADDR        (0x800A00 + L2_ENTRY_NUMBER_CONSTRAIN_BASE)
#define PORT11_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_ADDR        (0x800B00 + L2_ENTRY_NUMBER_CONSTRAIN_BASE)
#define PORT12_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_ADDR        (0x800C00 + L2_ENTRY_NUMBER_CONSTRAIN_BASE)
#define PORT13_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_ADDR        (0x800D00 + L2_ENTRY_NUMBER_CONSTRAIN_BASE)
#define PORT14_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_ADDR        (0x800E00 + L2_ENTRY_NUMBER_CONSTRAIN_BASE)
#define PORT15_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_ADDR        (0x800F00 + L2_ENTRY_NUMBER_CONSTRAIN_BASE)
#define PORT16_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_ADDR        (0x801000 + L2_ENTRY_NUMBER_CONSTRAIN_BASE)
#define PORT17_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_ADDR        (0x801100 + L2_ENTRY_NUMBER_CONSTRAIN_BASE)
#define PORT18_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_ADDR        (0x801200 + L2_ENTRY_NUMBER_CONSTRAIN_BASE)
#define PORT19_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_ADDR        (0x801300 + L2_ENTRY_NUMBER_CONSTRAIN_BASE)
#define PORT20_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_ADDR        (0x801400 + L2_ENTRY_NUMBER_CONSTRAIN_BASE)
#define PORT21_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_ADDR        (0x801500 + L2_ENTRY_NUMBER_CONSTRAIN_BASE)
#define PORT22_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_ADDR        (0x801600 + L2_ENTRY_NUMBER_CONSTRAIN_BASE)
#define PORT23_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_ADDR        (0x801700 + L2_ENTRY_NUMBER_CONSTRAIN_BASE)
#define PORT24_MAC_ADDRESS_NUMBER_CONSTRAIN_CONTROL0_ADDR        (0x801800 + L2_ENTRY_NUMBER_CONSTRAIN_BASE)

/* Module: ATTACK PREVENTION */
#define ATTACK_PREVENTION_BASE            0xBB160000
#define ATTACK_PREVENTION_GLOBAL_CONTROL_ADDR        (0x0 + ATTACK_PREVENTION_BASE)
#define DOS_LENGTH_GLOBAL_CONTROL0_ADDR        (0x4 + ATTACK_PREVENTION_BASE)
#define DOS_LENGTH_GLOBAL_CONTROL1_ADDR        (0x8 + ATTACK_PREVENTION_BASE)

/* Module: STORM CONTROL */
#define STORM_CONTROL_BASE            0xBB170000
#define TRAFFSTORM_SUPPRESSION_GLOBAL0_ADDR        (0x0 + STORM_CONTROL_BASE)
#define TRAFFSTORM_SUPPRESSION_GLOBAL1_ADDR        (0x4 + STORM_CONTROL_BASE)
#define PORT0_TRAFFIC_STORM_CONTROL0_ADDR        (0x800000 + STORM_CONTROL_BASE)
#define PORT1_TRAFFIC_STORM_CONTROL0_ADDR        (0x800100 + STORM_CONTROL_BASE)
#define PORT2_TRAFFIC_STORM_CONTROL0_ADDR        (0x800200 + STORM_CONTROL_BASE)
#define PORT3_TRAFFIC_STORM_CONTROL0_ADDR        (0x800300 + STORM_CONTROL_BASE)
#define PORT4_TRAFFIC_STORM_CONTROL0_ADDR        (0x800400 + STORM_CONTROL_BASE)
#define PORT5_TRAFFIC_STORM_CONTROL0_ADDR        (0x800500 + STORM_CONTROL_BASE)
#define PORT6_TRAFFIC_STORM_CONTROL0_ADDR        (0x800600 + STORM_CONTROL_BASE)
#define PORT7_TRAFFIC_STORM_CONTROL0_ADDR        (0x800700 + STORM_CONTROL_BASE)
#define PORT8_TRAFFIC_STORM_CONTROL0_ADDR        (0x800800 + STORM_CONTROL_BASE)
#define PORT9_TRAFFIC_STORM_CONTROL0_ADDR        (0x800900 + STORM_CONTROL_BASE)
#define PORT10_TRAFFIC_STORM_CONTROL0_ADDR        (0x800A00 + STORM_CONTROL_BASE)
#define PORT11_TRAFFIC_STORM_CONTROL0_ADDR        (0x800B00 + STORM_CONTROL_BASE)
#define PORT12_TRAFFIC_STORM_CONTROL0_ADDR        (0x800C00 + STORM_CONTROL_BASE)
#define PORT13_TRAFFIC_STORM_CONTROL0_ADDR        (0x800D00 + STORM_CONTROL_BASE)
#define PORT14_TRAFFIC_STORM_CONTROL0_ADDR        (0x800E00 + STORM_CONTROL_BASE)
#define PORT15_TRAFFIC_STORM_CONTROL0_ADDR        (0x800F00 + STORM_CONTROL_BASE)
#define PORT16_TRAFFIC_STORM_CONTROL0_ADDR        (0x801000 + STORM_CONTROL_BASE)
#define PORT17_TRAFFIC_STORM_CONTROL0_ADDR        (0x801100 + STORM_CONTROL_BASE)
#define PORT18_TRAFFIC_STORM_CONTROL0_ADDR        (0x801200 + STORM_CONTROL_BASE)
#define PORT19_TRAFFIC_STORM_CONTROL0_ADDR        (0x801300 + STORM_CONTROL_BASE)
#define PORT20_TRAFFIC_STORM_CONTROL0_ADDR        (0x801400 + STORM_CONTROL_BASE)
#define PORT21_TRAFFIC_STORM_CONTROL0_ADDR        (0x801500 + STORM_CONTROL_BASE)
#define PORT22_TRAFFIC_STORM_CONTROL0_ADDR        (0x801600 + STORM_CONTROL_BASE)
#define PORT23_TRAFFIC_STORM_CONTROL0_ADDR        (0x801700 + STORM_CONTROL_BASE)
#define PORT24_TRAFFIC_STORM_CONTROL0_ADDR        (0x801800 + STORM_CONTROL_BASE)
#define PORT0_TRAFFIC_STORM_CONTROL1_ADDR        (0x800004 + STORM_CONTROL_BASE)
#define PORT1_TRAFFIC_STORM_CONTROL1_ADDR        (0x800104 + STORM_CONTROL_BASE)
#define PORT2_TRAFFIC_STORM_CONTROL1_ADDR        (0x800204 + STORM_CONTROL_BASE)
#define PORT3_TRAFFIC_STORM_CONTROL1_ADDR        (0x800304 + STORM_CONTROL_BASE)
#define PORT4_TRAFFIC_STORM_CONTROL1_ADDR        (0x800404 + STORM_CONTROL_BASE)
#define PORT5_TRAFFIC_STORM_CONTROL1_ADDR        (0x800504 + STORM_CONTROL_BASE)
#define PORT6_TRAFFIC_STORM_CONTROL1_ADDR        (0x800604 + STORM_CONTROL_BASE)
#define PORT7_TRAFFIC_STORM_CONTROL1_ADDR        (0x800704 + STORM_CONTROL_BASE)
#define PORT8_TRAFFIC_STORM_CONTROL1_ADDR        (0x800804 + STORM_CONTROL_BASE)
#define PORT9_TRAFFIC_STORM_CONTROL1_ADDR        (0x800904 + STORM_CONTROL_BASE)
#define PORT10_TRAFFIC_STORM_CONTROL1_ADDR        (0x800A04 + STORM_CONTROL_BASE)
#define PORT11_TRAFFIC_STORM_CONTROL1_ADDR        (0x800B04 + STORM_CONTROL_BASE)
#define PORT12_TRAFFIC_STORM_CONTROL1_ADDR        (0x800C04 + STORM_CONTROL_BASE)
#define PORT13_TRAFFIC_STORM_CONTROL1_ADDR        (0x800D04 + STORM_CONTROL_BASE)
#define PORT14_TRAFFIC_STORM_CONTROL1_ADDR        (0x800E04 + STORM_CONTROL_BASE)
#define PORT15_TRAFFIC_STORM_CONTROL1_ADDR        (0x800F04 + STORM_CONTROL_BASE)
#define PORT16_TRAFFIC_STORM_CONTROL1_ADDR        (0x801004 + STORM_CONTROL_BASE)
#define PORT17_TRAFFIC_STORM_CONTROL1_ADDR        (0x801104 + STORM_CONTROL_BASE)
#define PORT18_TRAFFIC_STORM_CONTROL1_ADDR        (0x801204 + STORM_CONTROL_BASE)
#define PORT19_TRAFFIC_STORM_CONTROL1_ADDR        (0x801304 + STORM_CONTROL_BASE)
#define PORT20_TRAFFIC_STORM_CONTROL1_ADDR        (0x801404 + STORM_CONTROL_BASE)
#define PORT21_TRAFFIC_STORM_CONTROL1_ADDR        (0x801504 + STORM_CONTROL_BASE)
#define PORT22_TRAFFIC_STORM_CONTROL1_ADDR        (0x801604 + STORM_CONTROL_BASE)
#define PORT23_TRAFFIC_STORM_CONTROL1_ADDR        (0x801704 + STORM_CONTROL_BASE)
#define PORT24_TRAFFIC_STORM_CONTROL1_ADDR        (0x801804 + STORM_CONTROL_BASE)

/* Module: PORT ISOLATION */
#define PORT_ISOLATION_BASE            0xBB180000
#define PORT_ISOLATION_CONTROL_ADDR        (0x0 + PORT_ISOLATION_BASE)
#define CPU_ISOLATION_CONTROL_ADDR        (0x4 + PORT_ISOLATION_BASE)

/* Module: IGMP SNOOPING */
#define IGMP_SNOOPING_BASE            0xBB1A0000

/* Module: EEE MAC CONTROL */
#define EEE_MAC_CONTROL_BASE            0xBB1B0000
#define GLOBAL_EEE_MAC_CONTROL0_ADDR        (0x0 + EEE_MAC_CONTROL_BASE)
#define GLOBAL_EEE_MAC_CONTROL1_ADDR        (0x4 + EEE_MAC_CONTROL_BASE)
#define GLOBAL_EEE_MAC_CONTROL2_ADDR        (0x8 + EEE_MAC_CONTROL_BASE)
#define GLOBAL_EEE_MAC_CONTROL3_ADDR        (0xC + EEE_MAC_CONTROL_BASE)
#define GLOBAL_EEE_MAC_CONTROL4_ADDR        (0x10 + EEE_MAC_CONTROL_BASE)
#define EEE_DMY0_ADDR        (0x14 + EEE_MAC_CONTROL_BASE)
#define EEE_DMY1_ADDR        (0x18 + EEE_MAC_CONTROL_BASE)
#define EEE_DMY2_ADDR        (0x1C + EEE_MAC_CONTROL_BASE)
#define EEE_DMY3_ADDR        (0x20 + EEE_MAC_CONTROL_BASE)
#define PORT0_EEE_MAC_CONTROL_ADDR        (0x800000 + EEE_MAC_CONTROL_BASE)
#define PORT1_EEE_MAC_CONTROL_ADDR        (0x800100 + EEE_MAC_CONTROL_BASE)
#define PORT2_EEE_MAC_CONTROL_ADDR        (0x800200 + EEE_MAC_CONTROL_BASE)
#define PORT3_EEE_MAC_CONTROL_ADDR        (0x800300 + EEE_MAC_CONTROL_BASE)
#define PORT4_EEE_MAC_CONTROL_ADDR        (0x800400 + EEE_MAC_CONTROL_BASE)
#define PORT5_EEE_MAC_CONTROL_ADDR        (0x800500 + EEE_MAC_CONTROL_BASE)
#define PORT6_EEE_MAC_CONTROL_ADDR        (0x800600 + EEE_MAC_CONTROL_BASE)
#define PORT7_EEE_MAC_CONTROL_ADDR        (0x800700 + EEE_MAC_CONTROL_BASE)
#define PORT8_EEE_MAC_CONTROL_ADDR        (0x800800 + EEE_MAC_CONTROL_BASE)
#define PORT9_EEE_MAC_CONTROL_ADDR        (0x800900 + EEE_MAC_CONTROL_BASE)
#define PORT10_EEE_MAC_CONTROL_ADDR        (0x800A00 + EEE_MAC_CONTROL_BASE)
#define PORT11_EEE_MAC_CONTROL_ADDR        (0x800B00 + EEE_MAC_CONTROL_BASE)
#define PORT12_EEE_MAC_CONTROL_ADDR        (0x800C00 + EEE_MAC_CONTROL_BASE)
#define PORT13_EEE_MAC_CONTROL_ADDR        (0x800D00 + EEE_MAC_CONTROL_BASE)
#define PORT14_EEE_MAC_CONTROL_ADDR        (0x800E00 + EEE_MAC_CONTROL_BASE)
#define PORT15_EEE_MAC_CONTROL_ADDR        (0x800F00 + EEE_MAC_CONTROL_BASE)
#define PORT16_EEE_MAC_CONTROL_ADDR        (0x801000 + EEE_MAC_CONTROL_BASE)
#define PORT17_EEE_MAC_CONTROL_ADDR        (0x801100 + EEE_MAC_CONTROL_BASE)
#define PORT18_EEE_MAC_CONTROL_ADDR        (0x801200 + EEE_MAC_CONTROL_BASE)
#define PORT19_EEE_MAC_CONTROL_ADDR        (0x801300 + EEE_MAC_CONTROL_BASE)
#define PORT20_EEE_MAC_CONTROL_ADDR        (0x801400 + EEE_MAC_CONTROL_BASE)
#define PORT21_EEE_MAC_CONTROL_ADDR        (0x801500 + EEE_MAC_CONTROL_BASE)
#define PORT22_EEE_MAC_CONTROL_ADDR        (0x801600 + EEE_MAC_CONTROL_BASE)
#define PORT23_EEE_MAC_CONTROL_ADDR        (0x801700 + EEE_MAC_CONTROL_BASE)
#define PORT24_EEE_MAC_CONTROL_ADDR        (0x801800 + EEE_MAC_CONTROL_BASE)
#define PORT0_LPI_INDICATION_COUNTER0_ADDR        (0x800004 + EEE_MAC_CONTROL_BASE)
#define PORT1_LPI_INDICATION_COUNTER0_ADDR        (0x800104 + EEE_MAC_CONTROL_BASE)
#define PORT2_LPI_INDICATION_COUNTER0_ADDR        (0x800204 + EEE_MAC_CONTROL_BASE)
#define PORT3_LPI_INDICATION_COUNTER0_ADDR        (0x800304 + EEE_MAC_CONTROL_BASE)
#define PORT4_LPI_INDICATION_COUNTER0_ADDR        (0x800404 + EEE_MAC_CONTROL_BASE)
#define PORT5_LPI_INDICATION_COUNTER0_ADDR        (0x800504 + EEE_MAC_CONTROL_BASE)
#define PORT6_LPI_INDICATION_COUNTER0_ADDR        (0x800604 + EEE_MAC_CONTROL_BASE)
#define PORT7_LPI_INDICATION_COUNTER0_ADDR        (0x800704 + EEE_MAC_CONTROL_BASE)
#define PORT8_LPI_INDICATION_COUNTER0_ADDR        (0x800804 + EEE_MAC_CONTROL_BASE)
#define PORT9_LPI_INDICATION_COUNTER0_ADDR        (0x800904 + EEE_MAC_CONTROL_BASE)
#define PORT10_LPI_INDICATION_COUNTER0_ADDR        (0x800A04 + EEE_MAC_CONTROL_BASE)
#define PORT11_LPI_INDICATION_COUNTER0_ADDR        (0x800B04 + EEE_MAC_CONTROL_BASE)
#define PORT12_LPI_INDICATION_COUNTER0_ADDR        (0x800C04 + EEE_MAC_CONTROL_BASE)
#define PORT13_LPI_INDICATION_COUNTER0_ADDR        (0x800D04 + EEE_MAC_CONTROL_BASE)
#define PORT14_LPI_INDICATION_COUNTER0_ADDR        (0x800E04 + EEE_MAC_CONTROL_BASE)
#define PORT15_LPI_INDICATION_COUNTER0_ADDR        (0x800F04 + EEE_MAC_CONTROL_BASE)
#define PORT16_LPI_INDICATION_COUNTER0_ADDR        (0x801004 + EEE_MAC_CONTROL_BASE)
#define PORT17_LPI_INDICATION_COUNTER0_ADDR        (0x801104 + EEE_MAC_CONTROL_BASE)
#define PORT18_LPI_INDICATION_COUNTER0_ADDR        (0x801204 + EEE_MAC_CONTROL_BASE)
#define PORT19_LPI_INDICATION_COUNTER0_ADDR        (0x801304 + EEE_MAC_CONTROL_BASE)
#define PORT20_LPI_INDICATION_COUNTER0_ADDR        (0x801404 + EEE_MAC_CONTROL_BASE)
#define PORT21_LPI_INDICATION_COUNTER0_ADDR        (0x801504 + EEE_MAC_CONTROL_BASE)
#define PORT22_LPI_INDICATION_COUNTER0_ADDR        (0x801604 + EEE_MAC_CONTROL_BASE)
#define PORT23_LPI_INDICATION_COUNTER0_ADDR        (0x801704 + EEE_MAC_CONTROL_BASE)
#define PORT24_LPI_INDICATION_COUNTER0_ADDR        (0x801804 + EEE_MAC_CONTROL_BASE)
#define PORT0_LPI_INDICATION_COUNTER1_ADDR        (0x800008 + EEE_MAC_CONTROL_BASE)
#define PORT1_LPI_INDICATION_COUNTER1_ADDR        (0x800108 + EEE_MAC_CONTROL_BASE)
#define PORT2_LPI_INDICATION_COUNTER1_ADDR        (0x800208 + EEE_MAC_CONTROL_BASE)
#define PORT3_LPI_INDICATION_COUNTER1_ADDR        (0x800308 + EEE_MAC_CONTROL_BASE)
#define PORT4_LPI_INDICATION_COUNTER1_ADDR        (0x800408 + EEE_MAC_CONTROL_BASE)
#define PORT5_LPI_INDICATION_COUNTER1_ADDR        (0x800508 + EEE_MAC_CONTROL_BASE)
#define PORT6_LPI_INDICATION_COUNTER1_ADDR        (0x800608 + EEE_MAC_CONTROL_BASE)
#define PORT7_LPI_INDICATION_COUNTER1_ADDR        (0x800708 + EEE_MAC_CONTROL_BASE)
#define PORT8_LPI_INDICATION_COUNTER1_ADDR        (0x800808 + EEE_MAC_CONTROL_BASE)
#define PORT9_LPI_INDICATION_COUNTER1_ADDR        (0x800908 + EEE_MAC_CONTROL_BASE)
#define PORT10_LPI_INDICATION_COUNTER1_ADDR        (0x800A08 + EEE_MAC_CONTROL_BASE)
#define PORT11_LPI_INDICATION_COUNTER1_ADDR        (0x800B08 + EEE_MAC_CONTROL_BASE)
#define PORT12_LPI_INDICATION_COUNTER1_ADDR        (0x800C08 + EEE_MAC_CONTROL_BASE)
#define PORT13_LPI_INDICATION_COUNTER1_ADDR        (0x800D08 + EEE_MAC_CONTROL_BASE)
#define PORT14_LPI_INDICATION_COUNTER1_ADDR        (0x800E08 + EEE_MAC_CONTROL_BASE)
#define PORT15_LPI_INDICATION_COUNTER1_ADDR        (0x800F08 + EEE_MAC_CONTROL_BASE)
#define PORT16_LPI_INDICATION_COUNTER1_ADDR        (0x801008 + EEE_MAC_CONTROL_BASE)
#define PORT17_LPI_INDICATION_COUNTER1_ADDR        (0x801108 + EEE_MAC_CONTROL_BASE)
#define PORT18_LPI_INDICATION_COUNTER1_ADDR        (0x801208 + EEE_MAC_CONTROL_BASE)
#define PORT19_LPI_INDICATION_COUNTER1_ADDR        (0x801308 + EEE_MAC_CONTROL_BASE)
#define PORT20_LPI_INDICATION_COUNTER1_ADDR        (0x801408 + EEE_MAC_CONTROL_BASE)
#define PORT21_LPI_INDICATION_COUNTER1_ADDR        (0x801508 + EEE_MAC_CONTROL_BASE)
#define PORT22_LPI_INDICATION_COUNTER1_ADDR        (0x801608 + EEE_MAC_CONTROL_BASE)
#define PORT23_LPI_INDICATION_COUNTER1_ADDR        (0x801708 + EEE_MAC_CONTROL_BASE)
#define PORT24_LPI_INDICATION_COUNTER1_ADDR        (0x801808 + EEE_MAC_CONTROL_BASE)
#define PORT0_LPI_INDICATION_COUNTER2_ADDR        (0x80000C + EEE_MAC_CONTROL_BASE)
#define PORT1_LPI_INDICATION_COUNTER2_ADDR        (0x80010C + EEE_MAC_CONTROL_BASE)
#define PORT2_LPI_INDICATION_COUNTER2_ADDR        (0x80020C + EEE_MAC_CONTROL_BASE)
#define PORT3_LPI_INDICATION_COUNTER2_ADDR        (0x80030C + EEE_MAC_CONTROL_BASE)
#define PORT4_LPI_INDICATION_COUNTER2_ADDR        (0x80040C + EEE_MAC_CONTROL_BASE)
#define PORT5_LPI_INDICATION_COUNTER2_ADDR        (0x80050C + EEE_MAC_CONTROL_BASE)
#define PORT6_LPI_INDICATION_COUNTER2_ADDR        (0x80060C + EEE_MAC_CONTROL_BASE)
#define PORT7_LPI_INDICATION_COUNTER2_ADDR        (0x80070C + EEE_MAC_CONTROL_BASE)
#define PORT8_LPI_INDICATION_COUNTER2_ADDR        (0x80080C + EEE_MAC_CONTROL_BASE)
#define PORT9_LPI_INDICATION_COUNTER2_ADDR        (0x80090C + EEE_MAC_CONTROL_BASE)
#define PORT10_LPI_INDICATION_COUNTER2_ADDR        (0x800A0C + EEE_MAC_CONTROL_BASE)
#define PORT11_LPI_INDICATION_COUNTER2_ADDR        (0x800B0C + EEE_MAC_CONTROL_BASE)
#define PORT12_LPI_INDICATION_COUNTER2_ADDR        (0x800C0C + EEE_MAC_CONTROL_BASE)
#define PORT13_LPI_INDICATION_COUNTER2_ADDR        (0x800D0C + EEE_MAC_CONTROL_BASE)
#define PORT14_LPI_INDICATION_COUNTER2_ADDR        (0x800E0C + EEE_MAC_CONTROL_BASE)
#define PORT15_LPI_INDICATION_COUNTER2_ADDR        (0x800F0C + EEE_MAC_CONTROL_BASE)
#define PORT16_LPI_INDICATION_COUNTER2_ADDR        (0x80100C + EEE_MAC_CONTROL_BASE)
#define PORT17_LPI_INDICATION_COUNTER2_ADDR        (0x80110C + EEE_MAC_CONTROL_BASE)
#define PORT18_LPI_INDICATION_COUNTER2_ADDR        (0x80120C + EEE_MAC_CONTROL_BASE)
#define PORT19_LPI_INDICATION_COUNTER2_ADDR        (0x80130C + EEE_MAC_CONTROL_BASE)
#define PORT20_LPI_INDICATION_COUNTER2_ADDR        (0x80140C + EEE_MAC_CONTROL_BASE)
#define PORT21_LPI_INDICATION_COUNTER2_ADDR        (0x80150C + EEE_MAC_CONTROL_BASE)
#define PORT22_LPI_INDICATION_COUNTER2_ADDR        (0x80160C + EEE_MAC_CONTROL_BASE)
#define PORT23_LPI_INDICATION_COUNTER2_ADDR        (0x80170C + EEE_MAC_CONTROL_BASE)
#define PORT24_LPI_INDICATION_COUNTER2_ADDR        (0x80180C + EEE_MAC_CONTROL_BASE)
#define PORT0_LINK_DOWN_CONTROL_ADDR        (0x800010 + EEE_MAC_CONTROL_BASE)
#define PORT1_LINK_DOWN_CONTROL_ADDR        (0x800110 + EEE_MAC_CONTROL_BASE)
#define PORT2_LINK_DOWN_CONTROL_ADDR        (0x800210 + EEE_MAC_CONTROL_BASE)
#define PORT3_LINK_DOWN_CONTROL_ADDR        (0x800310 + EEE_MAC_CONTROL_BASE)
#define PORT4_LINK_DOWN_CONTROL_ADDR        (0x800410 + EEE_MAC_CONTROL_BASE)
#define PORT5_LINK_DOWN_CONTROL_ADDR        (0x800510 + EEE_MAC_CONTROL_BASE)
#define PORT6_LINK_DOWN_CONTROL_ADDR        (0x800610 + EEE_MAC_CONTROL_BASE)
#define PORT7_LINK_DOWN_CONTROL_ADDR        (0x800710 + EEE_MAC_CONTROL_BASE)
#define PORT8_LINK_DOWN_CONTROL_ADDR        (0x800810 + EEE_MAC_CONTROL_BASE)
#define PORT9_LINK_DOWN_CONTROL_ADDR        (0x800910 + EEE_MAC_CONTROL_BASE)
#define PORT10_LINK_DOWN_CONTROL_ADDR        (0x800A10 + EEE_MAC_CONTROL_BASE)
#define PORT11_LINK_DOWN_CONTROL_ADDR        (0x800B10 + EEE_MAC_CONTROL_BASE)
#define PORT12_LINK_DOWN_CONTROL_ADDR        (0x800C10 + EEE_MAC_CONTROL_BASE)
#define PORT13_LINK_DOWN_CONTROL_ADDR        (0x800D10 + EEE_MAC_CONTROL_BASE)
#define PORT14_LINK_DOWN_CONTROL_ADDR        (0x800E10 + EEE_MAC_CONTROL_BASE)
#define PORT15_LINK_DOWN_CONTROL_ADDR        (0x800F10 + EEE_MAC_CONTROL_BASE)
#define PORT16_LINK_DOWN_CONTROL_ADDR        (0x801010 + EEE_MAC_CONTROL_BASE)
#define PORT17_LINK_DOWN_CONTROL_ADDR        (0x801110 + EEE_MAC_CONTROL_BASE)
#define PORT18_LINK_DOWN_CONTROL_ADDR        (0x801210 + EEE_MAC_CONTROL_BASE)
#define PORT19_LINK_DOWN_CONTROL_ADDR        (0x801310 + EEE_MAC_CONTROL_BASE)
#define PORT20_LINK_DOWN_CONTROL_ADDR        (0x801410 + EEE_MAC_CONTROL_BASE)
#define PORT21_LINK_DOWN_CONTROL_ADDR        (0x801510 + EEE_MAC_CONTROL_BASE)
#define PORT22_LINK_DOWN_CONTROL_ADDR        (0x801610 + EEE_MAC_CONTROL_BASE)
#define PORT23_LINK_DOWN_CONTROL_ADDR        (0x801710 + EEE_MAC_CONTROL_BASE)
#define PORT24_LINK_DOWN_CONTROL_ADDR        (0x801810 + EEE_MAC_CONTROL_BASE)
#define PORT0_EEE_PORT_DMY0_ADDR        (0x800014 + EEE_MAC_CONTROL_BASE)
#define PORT1_EEE_PORT_DMY0_ADDR        (0x800114 + EEE_MAC_CONTROL_BASE)
#define PORT2_EEE_PORT_DMY0_ADDR        (0x800214 + EEE_MAC_CONTROL_BASE)
#define PORT3_EEE_PORT_DMY0_ADDR        (0x800314 + EEE_MAC_CONTROL_BASE)
#define PORT4_EEE_PORT_DMY0_ADDR        (0x800414 + EEE_MAC_CONTROL_BASE)
#define PORT5_EEE_PORT_DMY0_ADDR        (0x800514 + EEE_MAC_CONTROL_BASE)
#define PORT6_EEE_PORT_DMY0_ADDR        (0x800614 + EEE_MAC_CONTROL_BASE)
#define PORT7_EEE_PORT_DMY0_ADDR        (0x800714 + EEE_MAC_CONTROL_BASE)
#define PORT8_EEE_PORT_DMY0_ADDR        (0x800814 + EEE_MAC_CONTROL_BASE)
#define PORT9_EEE_PORT_DMY0_ADDR        (0x800914 + EEE_MAC_CONTROL_BASE)
#define PORT10_EEE_PORT_DMY0_ADDR        (0x800A14 + EEE_MAC_CONTROL_BASE)
#define PORT11_EEE_PORT_DMY0_ADDR        (0x800B14 + EEE_MAC_CONTROL_BASE)
#define PORT12_EEE_PORT_DMY0_ADDR        (0x800C14 + EEE_MAC_CONTROL_BASE)
#define PORT13_EEE_PORT_DMY0_ADDR        (0x800D14 + EEE_MAC_CONTROL_BASE)
#define PORT14_EEE_PORT_DMY0_ADDR        (0x800E14 + EEE_MAC_CONTROL_BASE)
#define PORT15_EEE_PORT_DMY0_ADDR        (0x800F14 + EEE_MAC_CONTROL_BASE)
#define PORT16_EEE_PORT_DMY0_ADDR        (0x801014 + EEE_MAC_CONTROL_BASE)
#define PORT17_EEE_PORT_DMY0_ADDR        (0x801114 + EEE_MAC_CONTROL_BASE)
#define PORT18_EEE_PORT_DMY0_ADDR        (0x801214 + EEE_MAC_CONTROL_BASE)
#define PORT19_EEE_PORT_DMY0_ADDR        (0x801314 + EEE_MAC_CONTROL_BASE)
#define PORT20_EEE_PORT_DMY0_ADDR        (0x801414 + EEE_MAC_CONTROL_BASE)
#define PORT21_EEE_PORT_DMY0_ADDR        (0x801514 + EEE_MAC_CONTROL_BASE)
#define PORT22_EEE_PORT_DMY0_ADDR        (0x801614 + EEE_MAC_CONTROL_BASE)
#define PORT23_EEE_PORT_DMY0_ADDR        (0x801714 + EEE_MAC_CONTROL_BASE)
#define PORT24_EEE_PORT_DMY0_ADDR        (0x801814 + EEE_MAC_CONTROL_BASE)
#define PORT0_EEE_PORT_DMY1_ADDR        (0x800018 + EEE_MAC_CONTROL_BASE)
#define PORT1_EEE_PORT_DMY1_ADDR        (0x800118 + EEE_MAC_CONTROL_BASE)
#define PORT2_EEE_PORT_DMY1_ADDR        (0x800218 + EEE_MAC_CONTROL_BASE)
#define PORT3_EEE_PORT_DMY1_ADDR        (0x800318 + EEE_MAC_CONTROL_BASE)
#define PORT4_EEE_PORT_DMY1_ADDR        (0x800418 + EEE_MAC_CONTROL_BASE)
#define PORT5_EEE_PORT_DMY1_ADDR        (0x800518 + EEE_MAC_CONTROL_BASE)
#define PORT6_EEE_PORT_DMY1_ADDR        (0x800618 + EEE_MAC_CONTROL_BASE)
#define PORT7_EEE_PORT_DMY1_ADDR        (0x800718 + EEE_MAC_CONTROL_BASE)
#define PORT8_EEE_PORT_DMY1_ADDR        (0x800818 + EEE_MAC_CONTROL_BASE)
#define PORT9_EEE_PORT_DMY1_ADDR        (0x800918 + EEE_MAC_CONTROL_BASE)
#define PORT10_EEE_PORT_DMY1_ADDR        (0x800A18 + EEE_MAC_CONTROL_BASE)
#define PORT11_EEE_PORT_DMY1_ADDR        (0x800B18 + EEE_MAC_CONTROL_BASE)
#define PORT12_EEE_PORT_DMY1_ADDR        (0x800C18 + EEE_MAC_CONTROL_BASE)
#define PORT13_EEE_PORT_DMY1_ADDR        (0x800D18 + EEE_MAC_CONTROL_BASE)
#define PORT14_EEE_PORT_DMY1_ADDR        (0x800E18 + EEE_MAC_CONTROL_BASE)
#define PORT15_EEE_PORT_DMY1_ADDR        (0x800F18 + EEE_MAC_CONTROL_BASE)
#define PORT16_EEE_PORT_DMY1_ADDR        (0x801018 + EEE_MAC_CONTROL_BASE)
#define PORT17_EEE_PORT_DMY1_ADDR        (0x801118 + EEE_MAC_CONTROL_BASE)
#define PORT18_EEE_PORT_DMY1_ADDR        (0x801218 + EEE_MAC_CONTROL_BASE)
#define PORT19_EEE_PORT_DMY1_ADDR        (0x801318 + EEE_MAC_CONTROL_BASE)
#define PORT20_EEE_PORT_DMY1_ADDR        (0x801418 + EEE_MAC_CONTROL_BASE)
#define PORT21_EEE_PORT_DMY1_ADDR        (0x801518 + EEE_MAC_CONTROL_BASE)
#define PORT22_EEE_PORT_DMY1_ADDR        (0x801618 + EEE_MAC_CONTROL_BASE)
#define PORT23_EEE_PORT_DMY1_ADDR        (0x801718 + EEE_MAC_CONTROL_BASE)
#define PORT24_EEE_PORT_DMY1_ADDR        (0x801818 + EEE_MAC_CONTROL_BASE)
#define PORT0_EEE_PORT_DMY2_ADDR        (0x80001C + EEE_MAC_CONTROL_BASE)
#define PORT1_EEE_PORT_DMY2_ADDR        (0x80011C + EEE_MAC_CONTROL_BASE)
#define PORT2_EEE_PORT_DMY2_ADDR        (0x80021C + EEE_MAC_CONTROL_BASE)
#define PORT3_EEE_PORT_DMY2_ADDR        (0x80031C + EEE_MAC_CONTROL_BASE)
#define PORT4_EEE_PORT_DMY2_ADDR        (0x80041C + EEE_MAC_CONTROL_BASE)
#define PORT5_EEE_PORT_DMY2_ADDR        (0x80051C + EEE_MAC_CONTROL_BASE)
#define PORT6_EEE_PORT_DMY2_ADDR        (0x80061C + EEE_MAC_CONTROL_BASE)
#define PORT7_EEE_PORT_DMY2_ADDR        (0x80071C + EEE_MAC_CONTROL_BASE)
#define PORT8_EEE_PORT_DMY2_ADDR        (0x80081C + EEE_MAC_CONTROL_BASE)
#define PORT9_EEE_PORT_DMY2_ADDR        (0x80091C + EEE_MAC_CONTROL_BASE)
#define PORT10_EEE_PORT_DMY2_ADDR        (0x800A1C + EEE_MAC_CONTROL_BASE)
#define PORT11_EEE_PORT_DMY2_ADDR        (0x800B1C + EEE_MAC_CONTROL_BASE)
#define PORT12_EEE_PORT_DMY2_ADDR        (0x800C1C + EEE_MAC_CONTROL_BASE)
#define PORT13_EEE_PORT_DMY2_ADDR        (0x800D1C + EEE_MAC_CONTROL_BASE)
#define PORT14_EEE_PORT_DMY2_ADDR        (0x800E1C + EEE_MAC_CONTROL_BASE)
#define PORT15_EEE_PORT_DMY2_ADDR        (0x800F1C + EEE_MAC_CONTROL_BASE)
#define PORT16_EEE_PORT_DMY2_ADDR        (0x80101C + EEE_MAC_CONTROL_BASE)
#define PORT17_EEE_PORT_DMY2_ADDR        (0x80111C + EEE_MAC_CONTROL_BASE)
#define PORT18_EEE_PORT_DMY2_ADDR        (0x80121C + EEE_MAC_CONTROL_BASE)
#define PORT19_EEE_PORT_DMY2_ADDR        (0x80131C + EEE_MAC_CONTROL_BASE)
#define PORT20_EEE_PORT_DMY2_ADDR        (0x80141C + EEE_MAC_CONTROL_BASE)
#define PORT21_EEE_PORT_DMY2_ADDR        (0x80151C + EEE_MAC_CONTROL_BASE)
#define PORT22_EEE_PORT_DMY2_ADDR        (0x80161C + EEE_MAC_CONTROL_BASE)
#define PORT23_EEE_PORT_DMY2_ADDR        (0x80171C + EEE_MAC_CONTROL_BASE)
#define PORT24_EEE_PORT_DMY2_ADDR        (0x80181C + EEE_MAC_CONTROL_BASE)
#define PORT0_EEE_PORT_DMY3_ADDR        (0x800020 + EEE_MAC_CONTROL_BASE)
#define PORT1_EEE_PORT_DMY3_ADDR        (0x800120 + EEE_MAC_CONTROL_BASE)
#define PORT2_EEE_PORT_DMY3_ADDR        (0x800220 + EEE_MAC_CONTROL_BASE)
#define PORT3_EEE_PORT_DMY3_ADDR        (0x800320 + EEE_MAC_CONTROL_BASE)
#define PORT4_EEE_PORT_DMY3_ADDR        (0x800420 + EEE_MAC_CONTROL_BASE)
#define PORT5_EEE_PORT_DMY3_ADDR        (0x800520 + EEE_MAC_CONTROL_BASE)
#define PORT6_EEE_PORT_DMY3_ADDR        (0x800620 + EEE_MAC_CONTROL_BASE)
#define PORT7_EEE_PORT_DMY3_ADDR        (0x800720 + EEE_MAC_CONTROL_BASE)
#define PORT8_EEE_PORT_DMY3_ADDR        (0x800820 + EEE_MAC_CONTROL_BASE)
#define PORT9_EEE_PORT_DMY3_ADDR        (0x800920 + EEE_MAC_CONTROL_BASE)
#define PORT10_EEE_PORT_DMY3_ADDR        (0x800A20 + EEE_MAC_CONTROL_BASE)
#define PORT11_EEE_PORT_DMY3_ADDR        (0x800B20 + EEE_MAC_CONTROL_BASE)
#define PORT12_EEE_PORT_DMY3_ADDR        (0x800C20 + EEE_MAC_CONTROL_BASE)
#define PORT13_EEE_PORT_DMY3_ADDR        (0x800D20 + EEE_MAC_CONTROL_BASE)
#define PORT14_EEE_PORT_DMY3_ADDR        (0x800E20 + EEE_MAC_CONTROL_BASE)
#define PORT15_EEE_PORT_DMY3_ADDR        (0x800F20 + EEE_MAC_CONTROL_BASE)
#define PORT16_EEE_PORT_DMY3_ADDR        (0x801020 + EEE_MAC_CONTROL_BASE)
#define PORT17_EEE_PORT_DMY3_ADDR        (0x801120 + EEE_MAC_CONTROL_BASE)
#define PORT18_EEE_PORT_DMY3_ADDR        (0x801220 + EEE_MAC_CONTROL_BASE)
#define PORT19_EEE_PORT_DMY3_ADDR        (0x801320 + EEE_MAC_CONTROL_BASE)
#define PORT20_EEE_PORT_DMY3_ADDR        (0x801420 + EEE_MAC_CONTROL_BASE)
#define PORT21_EEE_PORT_DMY3_ADDR        (0x801520 + EEE_MAC_CONTROL_BASE)
#define PORT22_EEE_PORT_DMY3_ADDR        (0x801620 + EEE_MAC_CONTROL_BASE)
#define PORT23_EEE_PORT_DMY3_ADDR        (0x801720 + EEE_MAC_CONTROL_BASE)
#define PORT24_EEE_PORT_DMY3_ADDR        (0x801820 + EEE_MAC_CONTROL_BASE)

/* Module: RANGE CHECK */
#define RANGE_CHECK_BASE            0xBB200000
#define L4PORT_RANGE_CHECKING_TABLE_ENTRY0_0_ADDR        (0x0 + RANGE_CHECK_BASE)
#define L4PORT_RANGE_CHECKING_TABLE_ENTRY0_1_ADDR        (0x4 + RANGE_CHECK_BASE)
#define L4PORT_RANGE_CHECKING_TABLE_ENTRY1_0_ADDR        (0x8 + RANGE_CHECK_BASE)
#define L4PORT_RANGE_CHECKING_TABLE_ENTRY1_1_ADDR        (0xC + RANGE_CHECK_BASE)
#define L4PORT_RANGE_CHECKING_TABLE_ENTRY2_0_ADDR        (0x10 + RANGE_CHECK_BASE)
#define L4PORT_RANGE_CHECKING_TABLE_ENTRY2_1_ADDR        (0x14 + RANGE_CHECK_BASE)
#define L4PORT_RANGE_CHECKING_TABLE_ENTRY3_0_ADDR        (0x18 + RANGE_CHECK_BASE)
#define L4PORT_RANGE_CHECKING_TABLE_ENTRY3_1_ADDR        (0x1C + RANGE_CHECK_BASE)
#define VID_RANGE_CHECKING_TABLE_ENTRY0_ADDR        (0x20 + RANGE_CHECK_BASE)
#define VID_RANGE_CHECKING_TABLE_ENTRY1_ADDR        (0x24 + RANGE_CHECK_BASE)
#define VID_RANGE_CHECKING_TABLE_ENTRY2_ADDR        (0x28 + RANGE_CHECK_BASE)
#define VID_RANGE_CHECKING_TABLE_ENTRY3_ADDR        (0x2C + RANGE_CHECK_BASE)
#define VID_RANGE_CHECKING_TABLE_ENTRY4_ADDR        (0x30 + RANGE_CHECK_BASE)
#define VID_RANGE_CHECKING_TABLE_ENTRY5_ADDR        (0x34 + RANGE_CHECK_BASE)
#define VID_RANGE_CHECKING_TABLE_ENTRY6_ADDR        (0x38 + RANGE_CHECK_BASE)
#define VID_RANGE_CHECKING_TABLE_ENTRY7_ADDR        (0x3C + RANGE_CHECK_BASE)
#define VID_RANGE_CHECKING_TABLE_ENTRY8_ADDR        (0x40 + RANGE_CHECK_BASE)
#define VID_RANGE_CHECKING_TABLE_ENTRY9_ADDR        (0x44 + RANGE_CHECK_BASE)
#define VID_RANGE_CHECKING_TABLE_ENTRY10_ADDR        (0x48 + RANGE_CHECK_BASE)
#define VID_RANGE_CHECKING_TABLE_ENTRY11_ADDR        (0x4C + RANGE_CHECK_BASE)
#define VID_RANGE_CHECKING_TABLE_ENTRY12_ADDR        (0x50 + RANGE_CHECK_BASE)
#define VID_RANGE_CHECKING_TABLE_ENTRY13_ADDR        (0x54 + RANGE_CHECK_BASE)
#define VID_RANGE_CHECKING_TABLE_ENTRY14_ADDR        (0x58 + RANGE_CHECK_BASE)
#define VID_RANGE_CHECKING_TABLE_ENTRY15_ADDR        (0x5C + RANGE_CHECK_BASE)
#define IP_RANGE_CHECKING_TABLE_ENTRY0_0_ADDR        (0x60 + RANGE_CHECK_BASE)
#define IP_RANGE_CHECKING_TABLE_ENTRY0_1_ADDR        (0x64 + RANGE_CHECK_BASE)
#define IP_RANGE_CHECKING_TABLE_ENTRY0_2_ADDR        (0x68 + RANGE_CHECK_BASE)
#define IP_RANGE_CHECKING_TABLE_ENTRY1_0_ADDR        (0x6C + RANGE_CHECK_BASE)
#define IP_RANGE_CHECKING_TABLE_ENTRY1_1_ADDR        (0x70 + RANGE_CHECK_BASE)
#define IP_RANGE_CHECKING_TABLE_ENTRY1_2_ADDR        (0x74 + RANGE_CHECK_BASE)
#define IP_RANGE_CHECKING_TABLE_ENTRY2_0_ADDR        (0x78 + RANGE_CHECK_BASE)
#define IP_RANGE_CHECKING_TABLE_ENTRY2_1_ADDR        (0x7C + RANGE_CHECK_BASE)
#define IP_RANGE_CHECKING_TABLE_ENTRY2_2_ADDR        (0x80 + RANGE_CHECK_BASE)
#define IP_RANGE_CHECKING_TABLE_ENTRY3_0_ADDR        (0x84 + RANGE_CHECK_BASE)
#define IP_RANGE_CHECKING_TABLE_ENTRY3_1_ADDR        (0x88 + RANGE_CHECK_BASE)
#define IP_RANGE_CHECKING_TABLE_ENTRY3_2_ADDR        (0x8C + RANGE_CHECK_BASE)
#define IP_RANGE_CHECKING_TABLE_ENTRY4_0_ADDR        (0x90 + RANGE_CHECK_BASE)
#define IP_RANGE_CHECKING_TABLE_ENTRY4_1_ADDR        (0x94 + RANGE_CHECK_BASE)
#define IP_RANGE_CHECKING_TABLE_ENTRY4_2_ADDR        (0x98 + RANGE_CHECK_BASE)
#define IP_RANGE_CHECKING_TABLE_ENTRY5_0_ADDR        (0x9C + RANGE_CHECK_BASE)
#define IP_RANGE_CHECKING_TABLE_ENTRY5_1_ADDR        (0xA0 + RANGE_CHECK_BASE)
#define IP_RANGE_CHECKING_TABLE_ENTRY5_2_ADDR        (0xA4 + RANGE_CHECK_BASE)
#define IP_RANGE_CHECKING_TABLE_ENTRY6_0_ADDR        (0xA8 + RANGE_CHECK_BASE)
#define IP_RANGE_CHECKING_TABLE_ENTRY6_1_ADDR        (0xAC + RANGE_CHECK_BASE)
#define IP_RANGE_CHECKING_TABLE_ENTRY6_2_ADDR        (0xB0 + RANGE_CHECK_BASE)
#define IP_RANGE_CHECKING_TABLE_ENTRY7_0_ADDR        (0xB4 + RANGE_CHECK_BASE)
#define IP_RANGE_CHECKING_TABLE_ENTRY7_1_ADDR        (0xB8 + RANGE_CHECK_BASE)
#define IP_RANGE_CHECKING_TABLE_ENTRY7_2_ADDR        (0xBC + RANGE_CHECK_BASE)
#define SOURCE_PORT_MASK_TABLE_ENTRY0_ADDR        (0xC0 + RANGE_CHECK_BASE)
#define SOURCE_PORT_MASK_TABLE_ENTRY1_ADDR        (0xC4 + RANGE_CHECK_BASE)
#define SOURCE_PORT_MASK_TABLE_ENTRY2_ADDR        (0xC8 + RANGE_CHECK_BASE)
#define SOURCE_PORT_MASK_TABLE_ENTRY3_ADDR        (0xCC + RANGE_CHECK_BASE)

/* Module: PIE LOOKUP AND TEMPLATE GENARATOR */
#define PIE_LOOKUP_AND_TEMPLATE_GENARATOR_BASE            0xBB210000
#define USER_DEFINED_TEMPLATE_CONTROL0_ADDR        (0x0 + PIE_LOOKUP_AND_TEMPLATE_GENARATOR_BASE)
#define USER_DEFINED_TEMPLATE_CONTROL1_ADDR        (0x4 + PIE_LOOKUP_AND_TEMPLATE_GENARATOR_BASE)
#define USER_DEFINED_TEMPLATE_CONTROL2_ADDR        (0x8 + PIE_LOOKUP_AND_TEMPLATE_GENARATOR_BASE)
#define USER_DEFINED_TEMPLATE_CONTROL3_ADDR        (0xC + PIE_LOOKUP_AND_TEMPLATE_GENARATOR_BASE)
#define PIE_RESULT_REVERSE_CONTROL0_ADDR        (0x10 + PIE_LOOKUP_AND_TEMPLATE_GENARATOR_BASE)
#define PIE_RESULT_REVERSE_CONTROL1_ADDR        (0x14 + PIE_LOOKUP_AND_TEMPLATE_GENARATOR_BASE)
#define PIE_RESULT_REVERSE_CONTROL2_ADDR        (0x18 + PIE_LOOKUP_AND_TEMPLATE_GENARATOR_BASE)
#define PIE_RESULT_REVERSE_CONTROL3_ADDR        (0x1C + PIE_LOOKUP_AND_TEMPLATE_GENARATOR_BASE)
#define PIE_BLOCK_PRIORITY_CONTROL_ADDR        (0x20 + PIE_LOOKUP_AND_TEMPLATE_GENARATOR_BASE)

/* Module: ACL */
#define ACL_BASE            0xBB230000
#define POLICER_TABLE_CONTROL_ADDR        (0x0 + ACL_BASE)
#define CRC_ERROR_FRAME_LOOKUP_CONTROL_ADDR        (0x4 + ACL_BASE)
#define ACL_COPYTOCPU_CONTROL_ADDR        (0x8 + ACL_BASE)
#define ACL_RULE_HIT_INTERRUPT_CONTROL0_ADDR        (0xC + ACL_BASE)
#define ACL_RULE_HIT_INTERRUPT_CONTROL1_ADDR        (0x10 + ACL_BASE)
#define ACL_RULE_HIT_INTERRUPT_CONTROL2_ADDR        (0x14 + ACL_BASE)
#define ACL_RULE_HIT_INTERRUPT_CONTROL3_ADDR        (0x18 + ACL_BASE)
#define ACL_RULE_HIT_INTERRUPT_STATUS0_ADDR        (0x1C + ACL_BASE)
#define ACL_RULE_HIT_INTERRUPT_STATUS1_ADDR        (0x20 + ACL_BASE)
#define ACL_RULE_HIT_INTERRUPT_STATUS2_ADDR        (0x24 + ACL_BASE)
#define ACL_RULE_HIT_INTERRUPT_STATUS3_ADDR        (0x28 + ACL_BASE)
#define PORT0_ACL_LOOKUP_CONTROL_ADDR        (0x800000 + ACL_BASE)
#define PORT1_ACL_LOOKUP_CONTROL_ADDR        (0x800100 + ACL_BASE)
#define PORT2_ACL_LOOKUP_CONTROL_ADDR        (0x800200 + ACL_BASE)
#define PORT3_ACL_LOOKUP_CONTROL_ADDR        (0x800300 + ACL_BASE)
#define PORT4_ACL_LOOKUP_CONTROL_ADDR        (0x800400 + ACL_BASE)
#define PORT5_ACL_LOOKUP_CONTROL_ADDR        (0x800500 + ACL_BASE)
#define PORT6_ACL_LOOKUP_CONTROL_ADDR        (0x800600 + ACL_BASE)
#define PORT7_ACL_LOOKUP_CONTROL_ADDR        (0x800700 + ACL_BASE)
#define PORT8_ACL_LOOKUP_CONTROL_ADDR        (0x800800 + ACL_BASE)
#define PORT9_ACL_LOOKUP_CONTROL_ADDR        (0x800900 + ACL_BASE)
#define PORT10_ACL_LOOKUP_CONTROL_ADDR        (0x800A00 + ACL_BASE)
#define PORT11_ACL_LOOKUP_CONTROL_ADDR        (0x800B00 + ACL_BASE)
#define PORT12_ACL_LOOKUP_CONTROL_ADDR        (0x800C00 + ACL_BASE)
#define PORT13_ACL_LOOKUP_CONTROL_ADDR        (0x800D00 + ACL_BASE)
#define PORT14_ACL_LOOKUP_CONTROL_ADDR        (0x800E00 + ACL_BASE)
#define PORT15_ACL_LOOKUP_CONTROL_ADDR        (0x800F00 + ACL_BASE)
#define PORT16_ACL_LOOKUP_CONTROL_ADDR        (0x801000 + ACL_BASE)
#define PORT17_ACL_LOOKUP_CONTROL_ADDR        (0x801100 + ACL_BASE)
#define PORT18_ACL_LOOKUP_CONTROL_ADDR        (0x801200 + ACL_BASE)
#define PORT19_ACL_LOOKUP_CONTROL_ADDR        (0x801300 + ACL_BASE)
#define PORT20_ACL_LOOKUP_CONTROL_ADDR        (0x801400 + ACL_BASE)
#define PORT21_ACL_LOOKUP_CONTROL_ADDR        (0x801500 + ACL_BASE)
#define PORT22_ACL_LOOKUP_CONTROL_ADDR        (0x801600 + ACL_BASE)
#define PORT23_ACL_LOOKUP_CONTROL_ADDR        (0x801700 + ACL_BASE)
#define PORT24_ACL_LOOKUP_CONTROL_ADDR        (0x801800 + ACL_BASE)

/* Module: FLOW CONTROL */
#define FLOW_CONTROL_BASE            0xBB290000
#define FLOW_CONTROL_GLOBAL_CONTROL_ADDR        (0x0 + FLOW_CONTROL_BASE)
#define SYSTEM_DROP_THRESHOLD_CONTROL_ADDR        (0x4 + FLOW_CONTROL_BASE)
#define PUBLIC_PAGE_RX_USED_HIGH_THRESHOLD_CONTROL0_ADDR        (0x8 + FLOW_CONTROL_BASE)
#define PUBLIC_PAGE_RX_USED_LOW_THRESHOLD_CONTROL1_ADDR        (0xC + FLOW_CONTROL_BASE)
#define FLOW_CONTROL_ENABLE_DROP_PACKET_NUMBER_CONTROL_ADDR        (0x10 + FLOW_CONTROL_BASE)
#define FLOW_CONTROL_OFF_PUBLIC_PAGE_RX_USED_DROP_ON_THRESHOLD_ADDR        (0x14 + FLOW_CONTROL_BASE)
#define FLOW_CONTROL_OFF_PUBLIC_PAGE_RX_USED_DROP_OFF_THRESHOLD_ADDR        (0x18 + FLOW_CONTROL_BASE)
#define PORT0_FLOW_CONTROL_CONTROL_ADDR        (0x800000 + FLOW_CONTROL_BASE)
#define PORT1_FLOW_CONTROL_CONTROL_ADDR        (0x800100 + FLOW_CONTROL_BASE)
#define PORT2_FLOW_CONTROL_CONTROL_ADDR        (0x800200 + FLOW_CONTROL_BASE)
#define PORT3_FLOW_CONTROL_CONTROL_ADDR        (0x800300 + FLOW_CONTROL_BASE)
#define PORT4_FLOW_CONTROL_CONTROL_ADDR        (0x800400 + FLOW_CONTROL_BASE)
#define PORT5_FLOW_CONTROL_CONTROL_ADDR        (0x800500 + FLOW_CONTROL_BASE)
#define PORT6_FLOW_CONTROL_CONTROL_ADDR        (0x800600 + FLOW_CONTROL_BASE)
#define PORT7_FLOW_CONTROL_CONTROL_ADDR        (0x800700 + FLOW_CONTROL_BASE)
#define PORT8_FLOW_CONTROL_CONTROL_ADDR        (0x800800 + FLOW_CONTROL_BASE)
#define PORT9_FLOW_CONTROL_CONTROL_ADDR        (0x800900 + FLOW_CONTROL_BASE)
#define PORT10_FLOW_CONTROL_CONTROL_ADDR        (0x800A00 + FLOW_CONTROL_BASE)
#define PORT11_FLOW_CONTROL_CONTROL_ADDR        (0x800B00 + FLOW_CONTROL_BASE)
#define PORT12_FLOW_CONTROL_CONTROL_ADDR        (0x800C00 + FLOW_CONTROL_BASE)
#define PORT13_FLOW_CONTROL_CONTROL_ADDR        (0x800D00 + FLOW_CONTROL_BASE)
#define PORT14_FLOW_CONTROL_CONTROL_ADDR        (0x800E00 + FLOW_CONTROL_BASE)
#define PORT15_FLOW_CONTROL_CONTROL_ADDR        (0x800F00 + FLOW_CONTROL_BASE)
#define PORT16_FLOW_CONTROL_CONTROL_ADDR        (0x801000 + FLOW_CONTROL_BASE)
#define PORT17_FLOW_CONTROL_CONTROL_ADDR        (0x801100 + FLOW_CONTROL_BASE)
#define PORT18_FLOW_CONTROL_CONTROL_ADDR        (0x801200 + FLOW_CONTROL_BASE)
#define PORT19_FLOW_CONTROL_CONTROL_ADDR        (0x801300 + FLOW_CONTROL_BASE)
#define PORT20_FLOW_CONTROL_CONTROL_ADDR        (0x801400 + FLOW_CONTROL_BASE)
#define PORT21_FLOW_CONTROL_CONTROL_ADDR        (0x801500 + FLOW_CONTROL_BASE)
#define PORT22_FLOW_CONTROL_CONTROL_ADDR        (0x801600 + FLOW_CONTROL_BASE)
#define PORT23_FLOW_CONTROL_CONTROL_ADDR        (0x801700 + FLOW_CONTROL_BASE)
#define PORT24_FLOW_CONTROL_CONTROL_ADDR        (0x801800 + FLOW_CONTROL_BASE)
#define PORT0_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_ADDR        (0x800004 + FLOW_CONTROL_BASE)
#define PORT1_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_ADDR        (0x800104 + FLOW_CONTROL_BASE)
#define PORT2_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_ADDR        (0x800204 + FLOW_CONTROL_BASE)
#define PORT3_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_ADDR        (0x800304 + FLOW_CONTROL_BASE)
#define PORT4_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_ADDR        (0x800404 + FLOW_CONTROL_BASE)
#define PORT5_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_ADDR        (0x800504 + FLOW_CONTROL_BASE)
#define PORT6_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_ADDR        (0x800604 + FLOW_CONTROL_BASE)
#define PORT7_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_ADDR        (0x800704 + FLOW_CONTROL_BASE)
#define PORT8_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_ADDR        (0x800804 + FLOW_CONTROL_BASE)
#define PORT9_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_ADDR        (0x800904 + FLOW_CONTROL_BASE)
#define PORT10_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_ADDR        (0x800A04 + FLOW_CONTROL_BASE)
#define PORT11_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_ADDR        (0x800B04 + FLOW_CONTROL_BASE)
#define PORT12_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_ADDR        (0x800C04 + FLOW_CONTROL_BASE)
#define PORT13_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_ADDR        (0x800D04 + FLOW_CONTROL_BASE)
#define PORT14_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_ADDR        (0x800E04 + FLOW_CONTROL_BASE)
#define PORT15_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_ADDR        (0x800F04 + FLOW_CONTROL_BASE)
#define PORT16_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_ADDR        (0x801004 + FLOW_CONTROL_BASE)
#define PORT17_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_ADDR        (0x801104 + FLOW_CONTROL_BASE)
#define PORT18_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_ADDR        (0x801204 + FLOW_CONTROL_BASE)
#define PORT19_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_ADDR        (0x801304 + FLOW_CONTROL_BASE)
#define PORT20_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_ADDR        (0x801404 + FLOW_CONTROL_BASE)
#define PORT21_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_ADDR        (0x801504 + FLOW_CONTROL_BASE)
#define PORT22_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_ADDR        (0x801604 + FLOW_CONTROL_BASE)
#define PORT23_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_ADDR        (0x801704 + FLOW_CONTROL_BASE)
#define PORT24_FLOWCONTROL_TX_QUEUE_DROP_ENABLE_CONTROL_ADDR        (0x801804 + FLOW_CONTROL_BASE)
#define PORT0_RX_PAGE_HIGH_THRESHOLD_CONTROL_ADDR        (0x800008 + FLOW_CONTROL_BASE)
#define PORT1_RX_PAGE_HIGH_THRESHOLD_CONTROL_ADDR        (0x800108 + FLOW_CONTROL_BASE)
#define PORT2_RX_PAGE_HIGH_THRESHOLD_CONTROL_ADDR        (0x800208 + FLOW_CONTROL_BASE)
#define PORT3_RX_PAGE_HIGH_THRESHOLD_CONTROL_ADDR        (0x800308 + FLOW_CONTROL_BASE)
#define PORT4_RX_PAGE_HIGH_THRESHOLD_CONTROL_ADDR        (0x800408 + FLOW_CONTROL_BASE)
#define PORT5_RX_PAGE_HIGH_THRESHOLD_CONTROL_ADDR        (0x800508 + FLOW_CONTROL_BASE)
#define PORT6_RX_PAGE_HIGH_THRESHOLD_CONTROL_ADDR        (0x800608 + FLOW_CONTROL_BASE)
#define PORT7_RX_PAGE_HIGH_THRESHOLD_CONTROL_ADDR        (0x800708 + FLOW_CONTROL_BASE)
#define PORT8_RX_PAGE_HIGH_THRESHOLD_CONTROL_ADDR        (0x800808 + FLOW_CONTROL_BASE)
#define PORT9_RX_PAGE_HIGH_THRESHOLD_CONTROL_ADDR        (0x800908 + FLOW_CONTROL_BASE)
#define PORT10_RX_PAGE_HIGH_THRESHOLD_CONTROL_ADDR        (0x800A08 + FLOW_CONTROL_BASE)
#define PORT11_RX_PAGE_HIGH_THRESHOLD_CONTROL_ADDR        (0x800B08 + FLOW_CONTROL_BASE)
#define PORT12_RX_PAGE_HIGH_THRESHOLD_CONTROL_ADDR        (0x800C08 + FLOW_CONTROL_BASE)
#define PORT13_RX_PAGE_HIGH_THRESHOLD_CONTROL_ADDR        (0x800D08 + FLOW_CONTROL_BASE)
#define PORT14_RX_PAGE_HIGH_THRESHOLD_CONTROL_ADDR        (0x800E08 + FLOW_CONTROL_BASE)
#define PORT15_RX_PAGE_HIGH_THRESHOLD_CONTROL_ADDR        (0x800F08 + FLOW_CONTROL_BASE)
#define PORT16_RX_PAGE_HIGH_THRESHOLD_CONTROL_ADDR        (0x801008 + FLOW_CONTROL_BASE)
#define PORT17_RX_PAGE_HIGH_THRESHOLD_CONTROL_ADDR        (0x801108 + FLOW_CONTROL_BASE)
#define PORT18_RX_PAGE_HIGH_THRESHOLD_CONTROL_ADDR        (0x801208 + FLOW_CONTROL_BASE)
#define PORT19_RX_PAGE_HIGH_THRESHOLD_CONTROL_ADDR        (0x801308 + FLOW_CONTROL_BASE)
#define PORT20_RX_PAGE_HIGH_THRESHOLD_CONTROL_ADDR        (0x801408 + FLOW_CONTROL_BASE)
#define PORT21_RX_PAGE_HIGH_THRESHOLD_CONTROL_ADDR        (0x801508 + FLOW_CONTROL_BASE)
#define PORT22_RX_PAGE_HIGH_THRESHOLD_CONTROL_ADDR        (0x801608 + FLOW_CONTROL_BASE)
#define PORT23_RX_PAGE_HIGH_THRESHOLD_CONTROL_ADDR        (0x801708 + FLOW_CONTROL_BASE)
#define PORT24_RX_PAGE_HIGH_THRESHOLD_CONTROL_ADDR        (0x801808 + FLOW_CONTROL_BASE)
#define PORT0_RX_PAGE_LOW_THRESHOLD_CONTROL_ADDR        (0x80000C + FLOW_CONTROL_BASE)
#define PORT1_RX_PAGE_LOW_THRESHOLD_CONTROL_ADDR        (0x80010C + FLOW_CONTROL_BASE)
#define PORT2_RX_PAGE_LOW_THRESHOLD_CONTROL_ADDR        (0x80020C + FLOW_CONTROL_BASE)
#define PORT3_RX_PAGE_LOW_THRESHOLD_CONTROL_ADDR        (0x80030C + FLOW_CONTROL_BASE)
#define PORT4_RX_PAGE_LOW_THRESHOLD_CONTROL_ADDR        (0x80040C + FLOW_CONTROL_BASE)
#define PORT5_RX_PAGE_LOW_THRESHOLD_CONTROL_ADDR        (0x80050C + FLOW_CONTROL_BASE)
#define PORT6_RX_PAGE_LOW_THRESHOLD_CONTROL_ADDR        (0x80060C + FLOW_CONTROL_BASE)
#define PORT7_RX_PAGE_LOW_THRESHOLD_CONTROL_ADDR        (0x80070C + FLOW_CONTROL_BASE)
#define PORT8_RX_PAGE_LOW_THRESHOLD_CONTROL_ADDR        (0x80080C + FLOW_CONTROL_BASE)
#define PORT9_RX_PAGE_LOW_THRESHOLD_CONTROL_ADDR        (0x80090C + FLOW_CONTROL_BASE)
#define PORT10_RX_PAGE_LOW_THRESHOLD_CONTROL_ADDR        (0x800A0C + FLOW_CONTROL_BASE)
#define PORT11_RX_PAGE_LOW_THRESHOLD_CONTROL_ADDR        (0x800B0C + FLOW_CONTROL_BASE)
#define PORT12_RX_PAGE_LOW_THRESHOLD_CONTROL_ADDR        (0x800C0C + FLOW_CONTROL_BASE)
#define PORT13_RX_PAGE_LOW_THRESHOLD_CONTROL_ADDR        (0x800D0C + FLOW_CONTROL_BASE)
#define PORT14_RX_PAGE_LOW_THRESHOLD_CONTROL_ADDR        (0x800E0C + FLOW_CONTROL_BASE)
#define PORT15_RX_PAGE_LOW_THRESHOLD_CONTROL_ADDR        (0x800F0C + FLOW_CONTROL_BASE)
#define PORT16_RX_PAGE_LOW_THRESHOLD_CONTROL_ADDR        (0x80100C + FLOW_CONTROL_BASE)
#define PORT17_RX_PAGE_LOW_THRESHOLD_CONTROL_ADDR        (0x80110C + FLOW_CONTROL_BASE)
#define PORT18_RX_PAGE_LOW_THRESHOLD_CONTROL_ADDR        (0x80120C + FLOW_CONTROL_BASE)
#define PORT19_RX_PAGE_LOW_THRESHOLD_CONTROL_ADDR        (0x80130C + FLOW_CONTROL_BASE)
#define PORT20_RX_PAGE_LOW_THRESHOLD_CONTROL_ADDR        (0x80140C + FLOW_CONTROL_BASE)
#define PORT21_RX_PAGE_LOW_THRESHOLD_CONTROL_ADDR        (0x80150C + FLOW_CONTROL_BASE)
#define PORT22_RX_PAGE_LOW_THRESHOLD_CONTROL_ADDR        (0x80160C + FLOW_CONTROL_BASE)
#define PORT23_RX_PAGE_LOW_THRESHOLD_CONTROL_ADDR        (0x80170C + FLOW_CONTROL_BASE)
#define PORT24_RX_PAGE_LOW_THRESHOLD_CONTROL_ADDR        (0x80180C + FLOW_CONTROL_BASE)
#define PORT0_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_ADDR        (0x800010 + FLOW_CONTROL_BASE)
#define PORT1_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_ADDR        (0x800110 + FLOW_CONTROL_BASE)
#define PORT2_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_ADDR        (0x800210 + FLOW_CONTROL_BASE)
#define PORT3_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_ADDR        (0x800310 + FLOW_CONTROL_BASE)
#define PORT4_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_ADDR        (0x800410 + FLOW_CONTROL_BASE)
#define PORT5_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_ADDR        (0x800510 + FLOW_CONTROL_BASE)
#define PORT6_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_ADDR        (0x800610 + FLOW_CONTROL_BASE)
#define PORT7_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_ADDR        (0x800710 + FLOW_CONTROL_BASE)
#define PORT8_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_ADDR        (0x800810 + FLOW_CONTROL_BASE)
#define PORT9_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_ADDR        (0x800910 + FLOW_CONTROL_BASE)
#define PORT10_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_ADDR        (0x800A10 + FLOW_CONTROL_BASE)
#define PORT11_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_ADDR        (0x800B10 + FLOW_CONTROL_BASE)
#define PORT12_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_ADDR        (0x800C10 + FLOW_CONTROL_BASE)
#define PORT13_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_ADDR        (0x800D10 + FLOW_CONTROL_BASE)
#define PORT14_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_ADDR        (0x800E10 + FLOW_CONTROL_BASE)
#define PORT15_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_ADDR        (0x800F10 + FLOW_CONTROL_BASE)
#define PORT16_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_ADDR        (0x801010 + FLOW_CONTROL_BASE)
#define PORT17_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_ADDR        (0x801110 + FLOW_CONTROL_BASE)
#define PORT18_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_ADDR        (0x801210 + FLOW_CONTROL_BASE)
#define PORT19_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_ADDR        (0x801310 + FLOW_CONTROL_BASE)
#define PORT20_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_ADDR        (0x801410 + FLOW_CONTROL_BASE)
#define PORT21_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_ADDR        (0x801510 + FLOW_CONTROL_BASE)
#define PORT22_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_ADDR        (0x801610 + FLOW_CONTROL_BASE)
#define PORT23_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_ADDR        (0x801710 + FLOW_CONTROL_BASE)
#define PORT24_RX_PAGE_GUARANTEE_THRESHOLD_CONTROL_ADDR        (0x801810 + FLOW_CONTROL_BASE)
#define PORT0_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_ADDR        (0x800014 + FLOW_CONTROL_BASE)
#define PORT1_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_ADDR        (0x800114 + FLOW_CONTROL_BASE)
#define PORT2_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_ADDR        (0x800214 + FLOW_CONTROL_BASE)
#define PORT3_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_ADDR        (0x800314 + FLOW_CONTROL_BASE)
#define PORT4_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_ADDR        (0x800414 + FLOW_CONTROL_BASE)
#define PORT5_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_ADDR        (0x800514 + FLOW_CONTROL_BASE)
#define PORT6_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_ADDR        (0x800614 + FLOW_CONTROL_BASE)
#define PORT7_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_ADDR        (0x800714 + FLOW_CONTROL_BASE)
#define PORT8_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_ADDR        (0x800814 + FLOW_CONTROL_BASE)
#define PORT9_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_ADDR        (0x800914 + FLOW_CONTROL_BASE)
#define PORT10_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_ADDR        (0x800A14 + FLOW_CONTROL_BASE)
#define PORT11_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_ADDR        (0x800B14 + FLOW_CONTROL_BASE)
#define PORT12_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_ADDR        (0x800C14 + FLOW_CONTROL_BASE)
#define PORT13_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_ADDR        (0x800D14 + FLOW_CONTROL_BASE)
#define PORT14_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_ADDR        (0x800E14 + FLOW_CONTROL_BASE)
#define PORT15_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_ADDR        (0x800F14 + FLOW_CONTROL_BASE)
#define PORT16_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_ADDR        (0x801014 + FLOW_CONTROL_BASE)
#define PORT17_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_ADDR        (0x801114 + FLOW_CONTROL_BASE)
#define PORT18_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_ADDR        (0x801214 + FLOW_CONTROL_BASE)
#define PORT19_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_ADDR        (0x801314 + FLOW_CONTROL_BASE)
#define PORT20_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_ADDR        (0x801414 + FLOW_CONTROL_BASE)
#define PORT21_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_ADDR        (0x801514 + FLOW_CONTROL_BASE)
#define PORT22_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_ADDR        (0x801614 + FLOW_CONTROL_BASE)
#define PORT23_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_ADDR        (0x801714 + FLOW_CONTROL_BASE)
#define PORT24_QUEUE_DROP_PAGE_THRESHOLD_CONTROL0_ADDR        (0x801814 + FLOW_CONTROL_BASE)
#define PORT0_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_ADDR        (0x800018 + FLOW_CONTROL_BASE)
#define PORT1_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_ADDR        (0x800118 + FLOW_CONTROL_BASE)
#define PORT2_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_ADDR        (0x800218 + FLOW_CONTROL_BASE)
#define PORT3_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_ADDR        (0x800318 + FLOW_CONTROL_BASE)
#define PORT4_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_ADDR        (0x800418 + FLOW_CONTROL_BASE)
#define PORT5_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_ADDR        (0x800518 + FLOW_CONTROL_BASE)
#define PORT6_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_ADDR        (0x800618 + FLOW_CONTROL_BASE)
#define PORT7_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_ADDR        (0x800718 + FLOW_CONTROL_BASE)
#define PORT8_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_ADDR        (0x800818 + FLOW_CONTROL_BASE)
#define PORT9_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_ADDR        (0x800918 + FLOW_CONTROL_BASE)
#define PORT10_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_ADDR        (0x800A18 + FLOW_CONTROL_BASE)
#define PORT11_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_ADDR        (0x800B18 + FLOW_CONTROL_BASE)
#define PORT12_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_ADDR        (0x800C18 + FLOW_CONTROL_BASE)
#define PORT13_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_ADDR        (0x800D18 + FLOW_CONTROL_BASE)
#define PORT14_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_ADDR        (0x800E18 + FLOW_CONTROL_BASE)
#define PORT15_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_ADDR        (0x800F18 + FLOW_CONTROL_BASE)
#define PORT16_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_ADDR        (0x801018 + FLOW_CONTROL_BASE)
#define PORT17_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_ADDR        (0x801118 + FLOW_CONTROL_BASE)
#define PORT18_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_ADDR        (0x801218 + FLOW_CONTROL_BASE)
#define PORT19_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_ADDR        (0x801318 + FLOW_CONTROL_BASE)
#define PORT20_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_ADDR        (0x801418 + FLOW_CONTROL_BASE)
#define PORT21_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_ADDR        (0x801518 + FLOW_CONTROL_BASE)
#define PORT22_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_ADDR        (0x801618 + FLOW_CONTROL_BASE)
#define PORT23_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_ADDR        (0x801718 + FLOW_CONTROL_BASE)
#define PORT24_QUEUE_DROP_PAGE_THRESHOLD_CONTROL1_ADDR        (0x801818 + FLOW_CONTROL_BASE)
#define PORT0_DROP_ABILITY_CONTROL_ADDR        (0x80001C + FLOW_CONTROL_BASE)
#define PORT1_DROP_ABILITY_CONTROL_ADDR        (0x80011C + FLOW_CONTROL_BASE)
#define PORT2_DROP_ABILITY_CONTROL_ADDR        (0x80021C + FLOW_CONTROL_BASE)
#define PORT3_DROP_ABILITY_CONTROL_ADDR        (0x80031C + FLOW_CONTROL_BASE)
#define PORT4_DROP_ABILITY_CONTROL_ADDR        (0x80041C + FLOW_CONTROL_BASE)
#define PORT5_DROP_ABILITY_CONTROL_ADDR        (0x80051C + FLOW_CONTROL_BASE)
#define PORT6_DROP_ABILITY_CONTROL_ADDR        (0x80061C + FLOW_CONTROL_BASE)
#define PORT7_DROP_ABILITY_CONTROL_ADDR        (0x80071C + FLOW_CONTROL_BASE)
#define PORT8_DROP_ABILITY_CONTROL_ADDR        (0x80081C + FLOW_CONTROL_BASE)
#define PORT9_DROP_ABILITY_CONTROL_ADDR        (0x80091C + FLOW_CONTROL_BASE)
#define PORT10_DROP_ABILITY_CONTROL_ADDR        (0x800A1C + FLOW_CONTROL_BASE)
#define PORT11_DROP_ABILITY_CONTROL_ADDR        (0x800B1C + FLOW_CONTROL_BASE)
#define PORT12_DROP_ABILITY_CONTROL_ADDR        (0x800C1C + FLOW_CONTROL_BASE)
#define PORT13_DROP_ABILITY_CONTROL_ADDR        (0x800D1C + FLOW_CONTROL_BASE)
#define PORT14_DROP_ABILITY_CONTROL_ADDR        (0x800E1C + FLOW_CONTROL_BASE)
#define PORT15_DROP_ABILITY_CONTROL_ADDR        (0x800F1C + FLOW_CONTROL_BASE)
#define PORT16_DROP_ABILITY_CONTROL_ADDR        (0x80101C + FLOW_CONTROL_BASE)
#define PORT17_DROP_ABILITY_CONTROL_ADDR        (0x80111C + FLOW_CONTROL_BASE)
#define PORT18_DROP_ABILITY_CONTROL_ADDR        (0x80121C + FLOW_CONTROL_BASE)
#define PORT19_DROP_ABILITY_CONTROL_ADDR        (0x80131C + FLOW_CONTROL_BASE)
#define PORT20_DROP_ABILITY_CONTROL_ADDR        (0x80141C + FLOW_CONTROL_BASE)
#define PORT21_DROP_ABILITY_CONTROL_ADDR        (0x80151C + FLOW_CONTROL_BASE)
#define PORT22_DROP_ABILITY_CONTROL_ADDR        (0x80161C + FLOW_CONTROL_BASE)
#define PORT23_DROP_ABILITY_CONTROL_ADDR        (0x80171C + FLOW_CONTROL_BASE)
#define PORT24_DROP_ABILITY_CONTROL_ADDR        (0x80181C + FLOW_CONTROL_BASE)
#define PORT0_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_ADDR        (0x800020 + FLOW_CONTROL_BASE)
#define PORT1_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_ADDR        (0x800120 + FLOW_CONTROL_BASE)
#define PORT2_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_ADDR        (0x800220 + FLOW_CONTROL_BASE)
#define PORT3_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_ADDR        (0x800320 + FLOW_CONTROL_BASE)
#define PORT4_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_ADDR        (0x800420 + FLOW_CONTROL_BASE)
#define PORT5_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_ADDR        (0x800520 + FLOW_CONTROL_BASE)
#define PORT6_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_ADDR        (0x800620 + FLOW_CONTROL_BASE)
#define PORT7_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_ADDR        (0x800720 + FLOW_CONTROL_BASE)
#define PORT8_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_ADDR        (0x800820 + FLOW_CONTROL_BASE)
#define PORT9_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_ADDR        (0x800920 + FLOW_CONTROL_BASE)
#define PORT10_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_ADDR        (0x800A20 + FLOW_CONTROL_BASE)
#define PORT11_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_ADDR        (0x800B20 + FLOW_CONTROL_BASE)
#define PORT12_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_ADDR        (0x800C20 + FLOW_CONTROL_BASE)
#define PORT13_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_ADDR        (0x800D20 + FLOW_CONTROL_BASE)
#define PORT14_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_ADDR        (0x800E20 + FLOW_CONTROL_BASE)
#define PORT15_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_ADDR        (0x800F20 + FLOW_CONTROL_BASE)
#define PORT16_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_ADDR        (0x801020 + FLOW_CONTROL_BASE)
#define PORT17_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_ADDR        (0x801120 + FLOW_CONTROL_BASE)
#define PORT18_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_ADDR        (0x801220 + FLOW_CONTROL_BASE)
#define PORT19_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_ADDR        (0x801320 + FLOW_CONTROL_BASE)
#define PORT20_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_ADDR        (0x801420 + FLOW_CONTROL_BASE)
#define PORT21_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_ADDR        (0x801520 + FLOW_CONTROL_BASE)
#define PORT22_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_ADDR        (0x801620 + FLOW_CONTROL_BASE)
#define PORT23_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_ADDR        (0x801720 + FLOW_CONTROL_BASE)
#define PORT24_FLOW_CONTROL_OFF_PORT_RX_DROP_THRESHOLD_CONTROL_ADDR        (0x801820 + FLOW_CONTROL_BASE)
#define PORT0_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_ADDR        (0x800024 + FLOW_CONTROL_BASE)
#define PORT1_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_ADDR        (0x800124 + FLOW_CONTROL_BASE)
#define PORT2_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_ADDR        (0x800224 + FLOW_CONTROL_BASE)
#define PORT3_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_ADDR        (0x800324 + FLOW_CONTROL_BASE)
#define PORT4_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_ADDR        (0x800424 + FLOW_CONTROL_BASE)
#define PORT5_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_ADDR        (0x800524 + FLOW_CONTROL_BASE)
#define PORT6_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_ADDR        (0x800624 + FLOW_CONTROL_BASE)
#define PORT7_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_ADDR        (0x800724 + FLOW_CONTROL_BASE)
#define PORT8_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_ADDR        (0x800824 + FLOW_CONTROL_BASE)
#define PORT9_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_ADDR        (0x800924 + FLOW_CONTROL_BASE)
#define PORT10_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_ADDR        (0x800A24 + FLOW_CONTROL_BASE)
#define PORT11_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_ADDR        (0x800B24 + FLOW_CONTROL_BASE)
#define PORT12_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_ADDR        (0x800C24 + FLOW_CONTROL_BASE)
#define PORT13_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_ADDR        (0x800D24 + FLOW_CONTROL_BASE)
#define PORT14_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_ADDR        (0x800E24 + FLOW_CONTROL_BASE)
#define PORT15_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_ADDR        (0x800F24 + FLOW_CONTROL_BASE)
#define PORT16_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_ADDR        (0x801024 + FLOW_CONTROL_BASE)
#define PORT17_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_ADDR        (0x801124 + FLOW_CONTROL_BASE)
#define PORT18_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_ADDR        (0x801224 + FLOW_CONTROL_BASE)
#define PORT19_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_ADDR        (0x801324 + FLOW_CONTROL_BASE)
#define PORT20_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_ADDR        (0x801424 + FLOW_CONTROL_BASE)
#define PORT21_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_ADDR        (0x801524 + FLOW_CONTROL_BASE)
#define PORT22_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_ADDR        (0x801624 + FLOW_CONTROL_BASE)
#define PORT23_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_ADDR        (0x801724 + FLOW_CONTROL_BASE)
#define PORT24_FLOW_CONTROL_ABILITY_FORCE_MODE_CONTROL_ADDR        (0x801824 + FLOW_CONTROL_BASE)
#define PORT0_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_ADDR        (0x800028 + FLOW_CONTROL_BASE)
#define PORT1_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_ADDR        (0x800128 + FLOW_CONTROL_BASE)
#define PORT2_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_ADDR        (0x800228 + FLOW_CONTROL_BASE)
#define PORT3_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_ADDR        (0x800328 + FLOW_CONTROL_BASE)
#define PORT4_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_ADDR        (0x800428 + FLOW_CONTROL_BASE)
#define PORT5_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_ADDR        (0x800528 + FLOW_CONTROL_BASE)
#define PORT6_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_ADDR        (0x800628 + FLOW_CONTROL_BASE)
#define PORT7_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_ADDR        (0x800728 + FLOW_CONTROL_BASE)
#define PORT8_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_ADDR        (0x800828 + FLOW_CONTROL_BASE)
#define PORT9_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_ADDR        (0x800928 + FLOW_CONTROL_BASE)
#define PORT10_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_ADDR        (0x800A28 + FLOW_CONTROL_BASE)
#define PORT11_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_ADDR        (0x800B28 + FLOW_CONTROL_BASE)
#define PORT12_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_ADDR        (0x800C28 + FLOW_CONTROL_BASE)
#define PORT13_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_ADDR        (0x800D28 + FLOW_CONTROL_BASE)
#define PORT14_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_ADDR        (0x800E28 + FLOW_CONTROL_BASE)
#define PORT15_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_ADDR        (0x800F28 + FLOW_CONTROL_BASE)
#define PORT16_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_ADDR        (0x801028 + FLOW_CONTROL_BASE)
#define PORT17_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_ADDR        (0x801128 + FLOW_CONTROL_BASE)
#define PORT18_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_ADDR        (0x801228 + FLOW_CONTROL_BASE)
#define PORT19_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_ADDR        (0x801328 + FLOW_CONTROL_BASE)
#define PORT20_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_ADDR        (0x801428 + FLOW_CONTROL_BASE)
#define PORT21_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_ADDR        (0x801528 + FLOW_CONTROL_BASE)
#define PORT22_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_ADDR        (0x801628 + FLOW_CONTROL_BASE)
#define PORT23_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_ADDR        (0x801728 + FLOW_CONTROL_BASE)
#define PORT24_RX_PAGE_DROP_HIGH_THRESHOLD_CONTROL_ADDR        (0x801828 + FLOW_CONTROL_BASE)
#define PORT0_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_ADDR        (0x80002C + FLOW_CONTROL_BASE)
#define PORT1_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_ADDR        (0x80012C + FLOW_CONTROL_BASE)
#define PORT2_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_ADDR        (0x80022C + FLOW_CONTROL_BASE)
#define PORT3_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_ADDR        (0x80032C + FLOW_CONTROL_BASE)
#define PORT4_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_ADDR        (0x80042C + FLOW_CONTROL_BASE)
#define PORT5_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_ADDR        (0x80052C + FLOW_CONTROL_BASE)
#define PORT6_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_ADDR        (0x80062C + FLOW_CONTROL_BASE)
#define PORT7_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_ADDR        (0x80072C + FLOW_CONTROL_BASE)
#define PORT8_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_ADDR        (0x80082C + FLOW_CONTROL_BASE)
#define PORT9_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_ADDR        (0x80092C + FLOW_CONTROL_BASE)
#define PORT10_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_ADDR        (0x800A2C + FLOW_CONTROL_BASE)
#define PORT11_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_ADDR        (0x800B2C + FLOW_CONTROL_BASE)
#define PORT12_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_ADDR        (0x800C2C + FLOW_CONTROL_BASE)
#define PORT13_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_ADDR        (0x800D2C + FLOW_CONTROL_BASE)
#define PORT14_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_ADDR        (0x800E2C + FLOW_CONTROL_BASE)
#define PORT15_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_ADDR        (0x800F2C + FLOW_CONTROL_BASE)
#define PORT16_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_ADDR        (0x80102C + FLOW_CONTROL_BASE)
#define PORT17_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_ADDR        (0x80112C + FLOW_CONTROL_BASE)
#define PORT18_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_ADDR        (0x80122C + FLOW_CONTROL_BASE)
#define PORT19_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_ADDR        (0x80132C + FLOW_CONTROL_BASE)
#define PORT20_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_ADDR        (0x80142C + FLOW_CONTROL_BASE)
#define PORT21_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_ADDR        (0x80152C + FLOW_CONTROL_BASE)
#define PORT22_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_ADDR        (0x80162C + FLOW_CONTROL_BASE)
#define PORT23_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_ADDR        (0x80172C + FLOW_CONTROL_BASE)
#define PORT24_RX_PAGE_DROP_LOW_THRESHOLD_CONTROL_ADDR        (0x80182C + FLOW_CONTROL_BASE)

/* Module: REMARKING */
#define REMARKING_BASE            0xBB320000
#define INNER_TAG_PRIORITY_REMARKING_TABLE_CONTROL0_ADDR        (0x0 + REMARKING_BASE)
#define INNER_TAG_PRIORITY_REMARKING_TABLE_CONTROL1_ADDR        (0x4 + REMARKING_BASE)
#define OUTER_TAG_PRIORITY_AND_DEI_REMARKING_TABLE_CONTROL0_ADDR        (0x8 + REMARKING_BASE)
#define OUTER_TAG_PRIORITY_AND_DEI_REMARKING_TABLE_CONTROL1_ADDR        (0xC + REMARKING_BASE)
#define DSCP_REMARKING_TABLE_CONTROL0_ADDR        (0x10 + REMARKING_BASE)
#define DSCP_REMARKING_TABLE_CONTROL1_ADDR        (0x14 + REMARKING_BASE)
#define DSCP_REMARKING_TABLE_CONTROL2_ADDR        (0x18 + REMARKING_BASE)
#define DSCP_REMARKING_TABLE_CONTROL3_ADDR        (0x1C + REMARKING_BASE)
#define PORT0_PRIORITY_REMARKING_CONTROL_ADDR        (0x800000 + REMARKING_BASE)
#define PORT1_PRIORITY_REMARKING_CONTROL_ADDR        (0x800100 + REMARKING_BASE)
#define PORT2_PRIORITY_REMARKING_CONTROL_ADDR        (0x800200 + REMARKING_BASE)
#define PORT3_PRIORITY_REMARKING_CONTROL_ADDR        (0x800300 + REMARKING_BASE)
#define PORT4_PRIORITY_REMARKING_CONTROL_ADDR        (0x800400 + REMARKING_BASE)
#define PORT5_PRIORITY_REMARKING_CONTROL_ADDR        (0x800500 + REMARKING_BASE)
#define PORT6_PRIORITY_REMARKING_CONTROL_ADDR        (0x800600 + REMARKING_BASE)
#define PORT7_PRIORITY_REMARKING_CONTROL_ADDR        (0x800700 + REMARKING_BASE)
#define PORT8_PRIORITY_REMARKING_CONTROL_ADDR        (0x800800 + REMARKING_BASE)
#define PORT9_PRIORITY_REMARKING_CONTROL_ADDR        (0x800900 + REMARKING_BASE)
#define PORT10_PRIORITY_REMARKING_CONTROL_ADDR        (0x800A00 + REMARKING_BASE)
#define PORT11_PRIORITY_REMARKING_CONTROL_ADDR        (0x800B00 + REMARKING_BASE)
#define PORT12_PRIORITY_REMARKING_CONTROL_ADDR        (0x800C00 + REMARKING_BASE)
#define PORT13_PRIORITY_REMARKING_CONTROL_ADDR        (0x800D00 + REMARKING_BASE)
#define PORT14_PRIORITY_REMARKING_CONTROL_ADDR        (0x800E00 + REMARKING_BASE)
#define PORT15_PRIORITY_REMARKING_CONTROL_ADDR        (0x800F00 + REMARKING_BASE)
#define PORT16_PRIORITY_REMARKING_CONTROL_ADDR        (0x801000 + REMARKING_BASE)
#define PORT17_PRIORITY_REMARKING_CONTROL_ADDR        (0x801100 + REMARKING_BASE)
#define PORT18_PRIORITY_REMARKING_CONTROL_ADDR        (0x801200 + REMARKING_BASE)
#define PORT19_PRIORITY_REMARKING_CONTROL_ADDR        (0x801300 + REMARKING_BASE)
#define PORT20_PRIORITY_REMARKING_CONTROL_ADDR        (0x801400 + REMARKING_BASE)
#define PORT21_PRIORITY_REMARKING_CONTROL_ADDR        (0x801500 + REMARKING_BASE)
#define PORT22_PRIORITY_REMARKING_CONTROL_ADDR        (0x801600 + REMARKING_BASE)
#define PORT23_PRIORITY_REMARKING_CONTROL_ADDR        (0x801700 + REMARKING_BASE)
#define PORT24_PRIORITY_REMARKING_CONTROL_ADDR        (0x801800 + REMARKING_BASE)

/* Module: INGRESS AND EGRESS BANDWIDTH CONTROL */
#define INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE            0xBB330000
#define INGRESS_BANDWIDTH_CONTROL_DROP_THRESHOLD_GLOBAL_CONTROL_ADDR        (0x0 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT0_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_ADDR        (0x800000 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT1_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_ADDR        (0x800100 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT2_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_ADDR        (0x800200 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT3_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_ADDR        (0x800300 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT4_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_ADDR        (0x800400 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT5_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_ADDR        (0x800500 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT6_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_ADDR        (0x800600 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT7_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_ADDR        (0x800700 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT8_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_ADDR        (0x800800 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT9_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_ADDR        (0x800900 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT10_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_ADDR        (0x800A00 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT11_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_ADDR        (0x800B00 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT12_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_ADDR        (0x800C00 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT13_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_ADDR        (0x800D00 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT14_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_ADDR        (0x800E00 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT15_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_ADDR        (0x800F00 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT16_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_ADDR        (0x801000 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT17_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_ADDR        (0x801100 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT18_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_ADDR        (0x801200 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT19_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_ADDR        (0x801300 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT20_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_ADDR        (0x801400 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT21_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_ADDR        (0x801500 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT22_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_ADDR        (0x801600 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT23_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_ADDR        (0x801700 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT24_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL0_ADDR        (0x801800 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT0_INGRESS_BANDWIDTH__RATE_CONTROL0_ADDR        (0x800004 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT1_INGRESS_BANDWIDTH__RATE_CONTROL0_ADDR        (0x800104 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT2_INGRESS_BANDWIDTH__RATE_CONTROL0_ADDR        (0x800204 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT3_INGRESS_BANDWIDTH__RATE_CONTROL0_ADDR        (0x800304 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT4_INGRESS_BANDWIDTH__RATE_CONTROL0_ADDR        (0x800404 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT5_INGRESS_BANDWIDTH__RATE_CONTROL0_ADDR        (0x800504 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT6_INGRESS_BANDWIDTH__RATE_CONTROL0_ADDR        (0x800604 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT7_INGRESS_BANDWIDTH__RATE_CONTROL0_ADDR        (0x800704 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT8_INGRESS_BANDWIDTH__RATE_CONTROL0_ADDR        (0x800804 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT9_INGRESS_BANDWIDTH__RATE_CONTROL0_ADDR        (0x800904 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT10_INGRESS_BANDWIDTH__RATE_CONTROL0_ADDR        (0x800A04 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT11_INGRESS_BANDWIDTH__RATE_CONTROL0_ADDR        (0x800B04 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT12_INGRESS_BANDWIDTH__RATE_CONTROL0_ADDR        (0x800C04 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT13_INGRESS_BANDWIDTH__RATE_CONTROL0_ADDR        (0x800D04 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT14_INGRESS_BANDWIDTH__RATE_CONTROL0_ADDR        (0x800E04 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT15_INGRESS_BANDWIDTH__RATE_CONTROL0_ADDR        (0x800F04 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT16_INGRESS_BANDWIDTH__RATE_CONTROL0_ADDR        (0x801004 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT17_INGRESS_BANDWIDTH__RATE_CONTROL0_ADDR        (0x801104 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT18_INGRESS_BANDWIDTH__RATE_CONTROL0_ADDR        (0x801204 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT19_INGRESS_BANDWIDTH__RATE_CONTROL0_ADDR        (0x801304 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT20_INGRESS_BANDWIDTH__RATE_CONTROL0_ADDR        (0x801404 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT21_INGRESS_BANDWIDTH__RATE_CONTROL0_ADDR        (0x801504 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT22_INGRESS_BANDWIDTH__RATE_CONTROL0_ADDR        (0x801604 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT23_INGRESS_BANDWIDTH__RATE_CONTROL0_ADDR        (0x801704 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT24_INGRESS_BANDWIDTH__RATE_CONTROL0_ADDR        (0x801804 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT0_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_ADDR        (0x800008 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT1_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_ADDR        (0x800108 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT2_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_ADDR        (0x800208 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT3_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_ADDR        (0x800308 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT4_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_ADDR        (0x800408 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT5_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_ADDR        (0x800508 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT6_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_ADDR        (0x800608 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT7_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_ADDR        (0x800708 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT8_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_ADDR        (0x800808 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT9_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_ADDR        (0x800908 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT10_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_ADDR        (0x800A08 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT11_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_ADDR        (0x800B08 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT12_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_ADDR        (0x800C08 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT13_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_ADDR        (0x800D08 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT14_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_ADDR        (0x800E08 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT15_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_ADDR        (0x800F08 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT16_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_ADDR        (0x801008 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT17_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_ADDR        (0x801108 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT18_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_ADDR        (0x801208 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT19_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_ADDR        (0x801308 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT20_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_ADDR        (0x801408 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT21_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_ADDR        (0x801508 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT22_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_ADDR        (0x801608 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT23_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_ADDR        (0x801708 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT24_INGRESS_BANDWIDTH_HIGH_LOW_THRESHOLD_CONTROL1_ADDR        (0x801808 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT0_INGRESS_BANDWIDTH__RATE_CONTROL1_ADDR        (0x80000C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT1_INGRESS_BANDWIDTH__RATE_CONTROL1_ADDR        (0x80010C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT2_INGRESS_BANDWIDTH__RATE_CONTROL1_ADDR        (0x80020C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT3_INGRESS_BANDWIDTH__RATE_CONTROL1_ADDR        (0x80030C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT4_INGRESS_BANDWIDTH__RATE_CONTROL1_ADDR        (0x80040C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT5_INGRESS_BANDWIDTH__RATE_CONTROL1_ADDR        (0x80050C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT6_INGRESS_BANDWIDTH__RATE_CONTROL1_ADDR        (0x80060C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT7_INGRESS_BANDWIDTH__RATE_CONTROL1_ADDR        (0x80070C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT8_INGRESS_BANDWIDTH__RATE_CONTROL1_ADDR        (0x80080C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT9_INGRESS_BANDWIDTH__RATE_CONTROL1_ADDR        (0x80090C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT10_INGRESS_BANDWIDTH__RATE_CONTROL1_ADDR        (0x800A0C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT11_INGRESS_BANDWIDTH__RATE_CONTROL1_ADDR        (0x800B0C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT12_INGRESS_BANDWIDTH__RATE_CONTROL1_ADDR        (0x800C0C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT13_INGRESS_BANDWIDTH__RATE_CONTROL1_ADDR        (0x800D0C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT14_INGRESS_BANDWIDTH__RATE_CONTROL1_ADDR        (0x800E0C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT15_INGRESS_BANDWIDTH__RATE_CONTROL1_ADDR        (0x800F0C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT16_INGRESS_BANDWIDTH__RATE_CONTROL1_ADDR        (0x80100C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT17_INGRESS_BANDWIDTH__RATE_CONTROL1_ADDR        (0x80110C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT18_INGRESS_BANDWIDTH__RATE_CONTROL1_ADDR        (0x80120C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT19_INGRESS_BANDWIDTH__RATE_CONTROL1_ADDR        (0x80130C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT20_INGRESS_BANDWIDTH__RATE_CONTROL1_ADDR        (0x80140C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT21_INGRESS_BANDWIDTH__RATE_CONTROL1_ADDR        (0x80150C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT22_INGRESS_BANDWIDTH__RATE_CONTROL1_ADDR        (0x80160C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT23_INGRESS_BANDWIDTH__RATE_CONTROL1_ADDR        (0x80170C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT24_INGRESS_BANDWIDTH__RATE_CONTROL1_ADDR        (0x80180C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT0_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_ADDR        (0x800010 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT1_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_ADDR        (0x800110 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT2_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_ADDR        (0x800210 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT3_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_ADDR        (0x800310 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT4_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_ADDR        (0x800410 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT5_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_ADDR        (0x800510 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT6_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_ADDR        (0x800610 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT7_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_ADDR        (0x800710 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT8_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_ADDR        (0x800810 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT9_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_ADDR        (0x800910 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT10_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_ADDR        (0x800A10 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT11_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_ADDR        (0x800B10 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT12_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_ADDR        (0x800C10 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT13_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_ADDR        (0x800D10 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT14_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_ADDR        (0x800E10 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT15_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_ADDR        (0x800F10 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT16_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_ADDR        (0x801010 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT17_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_ADDR        (0x801110 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT18_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_ADDR        (0x801210 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT19_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_ADDR        (0x801310 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT20_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_ADDR        (0x801410 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT21_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_ADDR        (0x801510 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT22_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_ADDR        (0x801610 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT23_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_ADDR        (0x801710 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT24_INGRESS_BANDWIDTH_ALGORITHM_CONTROL_ADDR        (0x801810 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT0_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_ADDR        (0x800014 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT1_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_ADDR        (0x800114 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT2_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_ADDR        (0x800214 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT3_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_ADDR        (0x800314 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT4_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_ADDR        (0x800414 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT5_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_ADDR        (0x800514 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT6_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_ADDR        (0x800614 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT7_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_ADDR        (0x800714 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT8_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_ADDR        (0x800814 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT9_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_ADDR        (0x800914 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT10_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_ADDR        (0x800A14 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT11_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_ADDR        (0x800B14 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT12_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_ADDR        (0x800C14 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT13_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_ADDR        (0x800D14 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT14_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_ADDR        (0x800E14 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT15_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_ADDR        (0x800F14 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT16_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_ADDR        (0x801014 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT17_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_ADDR        (0x801114 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT18_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_ADDR        (0x801214 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT19_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_ADDR        (0x801314 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT20_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_ADDR        (0x801414 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT21_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_ADDR        (0x801514 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT22_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_ADDR        (0x801614 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT23_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_ADDR        (0x801714 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT24_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL0_ADDR        (0x801814 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT0_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_ADDR        (0x800018 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT1_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_ADDR        (0x800118 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT2_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_ADDR        (0x800218 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT3_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_ADDR        (0x800318 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT4_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_ADDR        (0x800418 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT5_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_ADDR        (0x800518 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT6_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_ADDR        (0x800618 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT7_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_ADDR        (0x800718 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT8_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_ADDR        (0x800818 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT9_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_ADDR        (0x800918 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT10_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_ADDR        (0x800A18 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT11_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_ADDR        (0x800B18 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT12_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_ADDR        (0x800C18 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT13_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_ADDR        (0x800D18 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT14_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_ADDR        (0x800E18 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT15_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_ADDR        (0x800F18 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT16_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_ADDR        (0x801018 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT17_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_ADDR        (0x801118 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT18_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_ADDR        (0x801218 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT19_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_ADDR        (0x801318 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT20_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_ADDR        (0x801418 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT21_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_ADDR        (0x801518 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT22_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_ADDR        (0x801618 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT23_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_ADDR        (0x801718 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT24_INGRESS_BANDWIDTH_PACKET_LENGTH_CONTROL1_ADDR        (0x801818 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT0_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_ADDR        (0x80001C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT1_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_ADDR        (0x80011C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT2_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_ADDR        (0x80021C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT3_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_ADDR        (0x80031C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT4_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_ADDR        (0x80041C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT5_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_ADDR        (0x80051C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT6_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_ADDR        (0x80061C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT7_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_ADDR        (0x80071C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT8_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_ADDR        (0x80081C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT9_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_ADDR        (0x80091C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT10_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_ADDR        (0x800A1C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT11_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_ADDR        (0x800B1C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT12_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_ADDR        (0x800C1C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT13_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_ADDR        (0x800D1C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT14_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_ADDR        (0x800E1C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT15_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_ADDR        (0x800F1C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT16_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_ADDR        (0x80101C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT17_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_ADDR        (0x80111C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT18_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_ADDR        (0x80121C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT19_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_ADDR        (0x80131C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT20_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_ADDR        (0x80141C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT21_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_ADDR        (0x80151C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT22_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_ADDR        (0x80161C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT23_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_ADDR        (0x80171C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT24_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL0_ADDR        (0x80181C + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT0_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_ADDR        (0x800020 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT1_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_ADDR        (0x800120 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT2_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_ADDR        (0x800220 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT3_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_ADDR        (0x800320 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT4_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_ADDR        (0x800420 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT5_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_ADDR        (0x800520 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT6_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_ADDR        (0x800620 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT7_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_ADDR        (0x800720 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT8_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_ADDR        (0x800820 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT9_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_ADDR        (0x800920 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT10_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_ADDR        (0x800A20 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT11_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_ADDR        (0x800B20 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT12_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_ADDR        (0x800C20 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT13_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_ADDR        (0x800D20 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT14_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_ADDR        (0x800E20 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT15_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_ADDR        (0x800F20 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT16_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_ADDR        (0x801020 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT17_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_ADDR        (0x801120 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT18_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_ADDR        (0x801220 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT19_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_ADDR        (0x801320 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT20_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_ADDR        (0x801420 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT21_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_ADDR        (0x801520 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT22_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_ADDR        (0x801620 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT23_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_ADDR        (0x801720 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)
#define PORT24_INGRESS_BANDWIDTH_EBS_THRESHOLD_CONTROL1_ADDR        (0x801820 + INGRESS_AND_EGRESS_BANDWIDTH_CONTROL_BASE)

/* Module: QUEUE MANAGEMENT AND QUEUE SCHEDULE */
#define QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE            0xBB350000
#define LEAKY_BUKET_SYSTEM_CONTROL_ADDR        (0x0 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define LEAKY_BUKET_SYSTEM_COUNTER_CONTROL_ADDR        (0x4 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT_LEAKY_BUKET_CONTROL_ADDR        (0x8 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT0_Q0_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800000 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT1_Q0_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800100 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT2_Q0_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800200 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT3_Q0_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800300 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT4_Q0_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800400 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT5_Q0_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800500 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT6_Q0_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800600 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT7_Q0_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800700 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT8_Q0_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800800 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT9_Q0_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800900 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT10_Q0_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800A00 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT11_Q0_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800B00 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT12_Q0_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800C00 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT13_Q0_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800D00 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT14_Q0_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800E00 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT15_Q0_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800F00 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT16_Q0_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x801000 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT17_Q0_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x801100 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT18_Q0_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x801200 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT19_Q0_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x801300 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT20_Q0_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x801400 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT21_Q0_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x801500 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT22_Q0_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x801600 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT23_Q0_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x801700 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT24_Q0_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x801800 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT0_Q0_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800004 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT1_Q0_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800104 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT2_Q0_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800204 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT3_Q0_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800304 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT4_Q0_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800404 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT5_Q0_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800504 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT6_Q0_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800604 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT7_Q0_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800704 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT8_Q0_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800804 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT9_Q0_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800904 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT10_Q0_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800A04 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT11_Q0_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800B04 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT12_Q0_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800C04 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT13_Q0_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800D04 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT14_Q0_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800E04 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT15_Q0_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800F04 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT16_Q0_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x801004 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT17_Q0_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x801104 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT18_Q0_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x801204 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT19_Q0_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x801304 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT20_Q0_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x801404 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT21_Q0_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x801504 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT22_Q0_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x801604 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT23_Q0_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x801704 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT24_Q0_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x801804 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT0_Q1_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800008 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT1_Q1_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800108 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT2_Q1_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800208 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT3_Q1_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800308 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT4_Q1_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800408 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT5_Q1_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800508 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT6_Q1_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800608 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT7_Q1_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800708 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT8_Q1_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800808 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT9_Q1_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800908 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT10_Q1_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800A08 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT11_Q1_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800B08 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT12_Q1_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800C08 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT13_Q1_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800D08 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT14_Q1_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800E08 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT15_Q1_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800F08 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT16_Q1_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x801008 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT17_Q1_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x801108 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT18_Q1_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x801208 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT19_Q1_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x801308 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT20_Q1_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x801408 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT21_Q1_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x801508 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT22_Q1_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x801608 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT23_Q1_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x801708 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT24_Q1_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x801808 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT0_Q1_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x80000C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT1_Q1_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x80010C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT2_Q1_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x80020C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT3_Q1_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x80030C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT4_Q1_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x80040C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT5_Q1_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x80050C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT6_Q1_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x80060C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT7_Q1_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x80070C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT8_Q1_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x80080C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT9_Q1_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x80090C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT10_Q1_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800A0C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT11_Q1_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800B0C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT12_Q1_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800C0C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT13_Q1_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800D0C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT14_Q1_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800E0C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT15_Q1_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800F0C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT16_Q1_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x80100C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT17_Q1_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x80110C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT18_Q1_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x80120C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT19_Q1_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x80130C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT20_Q1_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x80140C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT21_Q1_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x80150C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT22_Q1_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x80160C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT23_Q1_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x80170C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT24_Q1_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x80180C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT0_Q2_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800010 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT1_Q2_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800110 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT2_Q2_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800210 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT3_Q2_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800310 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT4_Q2_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800410 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT5_Q2_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800510 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT6_Q2_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800610 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT7_Q2_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800710 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT8_Q2_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800810 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT9_Q2_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800910 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT10_Q2_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800A10 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT11_Q2_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800B10 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT12_Q2_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800C10 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT13_Q2_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800D10 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT14_Q2_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800E10 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT15_Q2_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800F10 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT16_Q2_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x801010 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT17_Q2_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x801110 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT18_Q2_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x801210 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT19_Q2_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x801310 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT20_Q2_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x801410 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT21_Q2_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x801510 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT22_Q2_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x801610 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT23_Q2_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x801710 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT24_Q2_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x801810 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT0_Q2_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800014 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT1_Q2_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800114 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT2_Q2_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800214 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT3_Q2_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800314 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT4_Q2_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800414 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT5_Q2_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800514 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT6_Q2_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800614 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT7_Q2_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800714 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT8_Q2_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800814 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT9_Q2_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800914 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT10_Q2_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800A14 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT11_Q2_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800B14 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT12_Q2_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800C14 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT13_Q2_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800D14 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT14_Q2_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800E14 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT15_Q2_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800F14 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT16_Q2_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x801014 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT17_Q2_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x801114 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT18_Q2_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x801214 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT19_Q2_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x801314 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT20_Q2_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x801414 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT21_Q2_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x801514 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT22_Q2_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x801614 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT23_Q2_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x801714 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT24_Q2_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x801814 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT0_Q3_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800018 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT1_Q3_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800118 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT2_Q3_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800218 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT3_Q3_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800318 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT4_Q3_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800418 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT5_Q3_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800518 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT6_Q3_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800618 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT7_Q3_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800718 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT8_Q3_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800818 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT9_Q3_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800918 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT10_Q3_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800A18 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT11_Q3_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800B18 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT12_Q3_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800C18 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT13_Q3_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800D18 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT14_Q3_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800E18 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT15_Q3_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x800F18 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT16_Q3_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x801018 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT17_Q3_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x801118 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT18_Q3_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x801218 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT19_Q3_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x801318 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT20_Q3_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x801418 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT21_Q3_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x801518 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT22_Q3_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x801618 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT23_Q3_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x801718 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT24_Q3_SCHEDULER_BUCKET_CONTROL0_ADDR        (0x801818 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT0_Q3_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x80001C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT1_Q3_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x80011C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT2_Q3_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x80021C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT3_Q3_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x80031C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT4_Q3_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x80041C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT5_Q3_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x80051C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT6_Q3_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x80061C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT7_Q3_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x80071C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT8_Q3_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x80081C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT9_Q3_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x80091C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT10_Q3_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800A1C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT11_Q3_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800B1C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT12_Q3_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800C1C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT13_Q3_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800D1C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT14_Q3_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800E1C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT15_Q3_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x800F1C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT16_Q3_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x80101C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT17_Q3_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x80111C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT18_Q3_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x80121C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT19_Q3_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x80131C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT20_Q3_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x80141C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT21_Q3_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x80151C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT22_Q3_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x80161C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT23_Q3_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x80171C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT24_Q3_SCHEDULER_BUCKET_CONTROL1_ADDR        (0x80181C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT0_BANDWITH_CONTROL_ADDR        (0x800020 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT1_BANDWITH_CONTROL_ADDR        (0x800120 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT2_BANDWITH_CONTROL_ADDR        (0x800220 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT3_BANDWITH_CONTROL_ADDR        (0x800320 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT4_BANDWITH_CONTROL_ADDR        (0x800420 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT5_BANDWITH_CONTROL_ADDR        (0x800520 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT6_BANDWITH_CONTROL_ADDR        (0x800620 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT7_BANDWITH_CONTROL_ADDR        (0x800720 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT8_BANDWITH_CONTROL_ADDR        (0x800820 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT9_BANDWITH_CONTROL_ADDR        (0x800920 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT10_BANDWITH_CONTROL_ADDR        (0x800A20 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT11_BANDWITH_CONTROL_ADDR        (0x800B20 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT12_BANDWITH_CONTROL_ADDR        (0x800C20 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT13_BANDWITH_CONTROL_ADDR        (0x800D20 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT14_BANDWITH_CONTROL_ADDR        (0x800E20 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT15_BANDWITH_CONTROL_ADDR        (0x800F20 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT16_BANDWITH_CONTROL_ADDR        (0x801020 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT17_BANDWITH_CONTROL_ADDR        (0x801120 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT18_BANDWITH_CONTROL_ADDR        (0x801220 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT19_BANDWITH_CONTROL_ADDR        (0x801320 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT20_BANDWITH_CONTROL_ADDR        (0x801420 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT21_BANDWITH_CONTROL_ADDR        (0x801520 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT22_BANDWITH_CONTROL_ADDR        (0x801620 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT23_BANDWITH_CONTROL_ADDR        (0x801720 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT24_BANDWITH_CONTROL_ADDR        (0x801820 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT0_QUEUE_SCHEDULE_CONTROL_ADDR        (0x800024 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT1_QUEUE_SCHEDULE_CONTROL_ADDR        (0x800124 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT2_QUEUE_SCHEDULE_CONTROL_ADDR        (0x800224 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT3_QUEUE_SCHEDULE_CONTROL_ADDR        (0x800324 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT4_QUEUE_SCHEDULE_CONTROL_ADDR        (0x800424 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT5_QUEUE_SCHEDULE_CONTROL_ADDR        (0x800524 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT6_QUEUE_SCHEDULE_CONTROL_ADDR        (0x800624 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT7_QUEUE_SCHEDULE_CONTROL_ADDR        (0x800724 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT8_QUEUE_SCHEDULE_CONTROL_ADDR        (0x800824 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT9_QUEUE_SCHEDULE_CONTROL_ADDR        (0x800924 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT10_QUEUE_SCHEDULE_CONTROL_ADDR        (0x800A24 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT11_QUEUE_SCHEDULE_CONTROL_ADDR        (0x800B24 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT12_QUEUE_SCHEDULE_CONTROL_ADDR        (0x800C24 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT13_QUEUE_SCHEDULE_CONTROL_ADDR        (0x800D24 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT14_QUEUE_SCHEDULE_CONTROL_ADDR        (0x800E24 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT15_QUEUE_SCHEDULE_CONTROL_ADDR        (0x800F24 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT16_QUEUE_SCHEDULE_CONTROL_ADDR        (0x801024 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT17_QUEUE_SCHEDULE_CONTROL_ADDR        (0x801124 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT18_QUEUE_SCHEDULE_CONTROL_ADDR        (0x801224 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT19_QUEUE_SCHEDULE_CONTROL_ADDR        (0x801324 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT20_QUEUE_SCHEDULE_CONTROL_ADDR        (0x801424 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT21_QUEUE_SCHEDULE_CONTROL_ADDR        (0x801524 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT22_QUEUE_SCHEDULE_CONTROL_ADDR        (0x801624 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT23_QUEUE_SCHEDULE_CONTROL_ADDR        (0x801724 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT24_QUEUE_SCHEDULE_CONTROL_ADDR        (0x801824 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT0_QUEUE_0_PACKET_NUMBER_COUNTER_ADDR        (0x800028 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT1_QUEUE_0_PACKET_NUMBER_COUNTER_ADDR        (0x800128 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT2_QUEUE_0_PACKET_NUMBER_COUNTER_ADDR        (0x800228 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT3_QUEUE_0_PACKET_NUMBER_COUNTER_ADDR        (0x800328 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT4_QUEUE_0_PACKET_NUMBER_COUNTER_ADDR        (0x800428 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT5_QUEUE_0_PACKET_NUMBER_COUNTER_ADDR        (0x800528 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT6_QUEUE_0_PACKET_NUMBER_COUNTER_ADDR        (0x800628 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT7_QUEUE_0_PACKET_NUMBER_COUNTER_ADDR        (0x800728 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT8_QUEUE_0_PACKET_NUMBER_COUNTER_ADDR        (0x800828 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT9_QUEUE_0_PACKET_NUMBER_COUNTER_ADDR        (0x800928 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT10_QUEUE_0_PACKET_NUMBER_COUNTER_ADDR        (0x800A28 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT11_QUEUE_0_PACKET_NUMBER_COUNTER_ADDR        (0x800B28 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT12_QUEUE_0_PACKET_NUMBER_COUNTER_ADDR        (0x800C28 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT13_QUEUE_0_PACKET_NUMBER_COUNTER_ADDR        (0x800D28 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT14_QUEUE_0_PACKET_NUMBER_COUNTER_ADDR        (0x800E28 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT15_QUEUE_0_PACKET_NUMBER_COUNTER_ADDR        (0x800F28 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT16_QUEUE_0_PACKET_NUMBER_COUNTER_ADDR        (0x801028 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT17_QUEUE_0_PACKET_NUMBER_COUNTER_ADDR        (0x801128 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT18_QUEUE_0_PACKET_NUMBER_COUNTER_ADDR        (0x801228 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT19_QUEUE_0_PACKET_NUMBER_COUNTER_ADDR        (0x801328 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT20_QUEUE_0_PACKET_NUMBER_COUNTER_ADDR        (0x801428 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT21_QUEUE_0_PACKET_NUMBER_COUNTER_ADDR        (0x801528 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT22_QUEUE_0_PACKET_NUMBER_COUNTER_ADDR        (0x801628 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT23_QUEUE_0_PACKET_NUMBER_COUNTER_ADDR        (0x801728 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT24_QUEUE_0_PACKET_NUMBER_COUNTER_ADDR        (0x801828 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT0_QUEUE_1_PACKET_NUMBER_COUNTER_ADDR        (0x80002C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT1_QUEUE_1_PACKET_NUMBER_COUNTER_ADDR        (0x80012C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT2_QUEUE_1_PACKET_NUMBER_COUNTER_ADDR        (0x80022C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT3_QUEUE_1_PACKET_NUMBER_COUNTER_ADDR        (0x80032C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT4_QUEUE_1_PACKET_NUMBER_COUNTER_ADDR        (0x80042C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT5_QUEUE_1_PACKET_NUMBER_COUNTER_ADDR        (0x80052C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT6_QUEUE_1_PACKET_NUMBER_COUNTER_ADDR        (0x80062C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT7_QUEUE_1_PACKET_NUMBER_COUNTER_ADDR        (0x80072C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT8_QUEUE_1_PACKET_NUMBER_COUNTER_ADDR        (0x80082C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT9_QUEUE_1_PACKET_NUMBER_COUNTER_ADDR        (0x80092C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT10_QUEUE_1_PACKET_NUMBER_COUNTER_ADDR        (0x800A2C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT11_QUEUE_1_PACKET_NUMBER_COUNTER_ADDR        (0x800B2C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT12_QUEUE_1_PACKET_NUMBER_COUNTER_ADDR        (0x800C2C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT13_QUEUE_1_PACKET_NUMBER_COUNTER_ADDR        (0x800D2C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT14_QUEUE_1_PACKET_NUMBER_COUNTER_ADDR        (0x800E2C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT15_QUEUE_1_PACKET_NUMBER_COUNTER_ADDR        (0x800F2C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT16_QUEUE_1_PACKET_NUMBER_COUNTER_ADDR        (0x80102C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT17_QUEUE_1_PACKET_NUMBER_COUNTER_ADDR        (0x80112C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT18_QUEUE_1_PACKET_NUMBER_COUNTER_ADDR        (0x80122C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT19_QUEUE_1_PACKET_NUMBER_COUNTER_ADDR        (0x80132C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT20_QUEUE_1_PACKET_NUMBER_COUNTER_ADDR        (0x80142C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT21_QUEUE_1_PACKET_NUMBER_COUNTER_ADDR        (0x80152C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT22_QUEUE_1_PACKET_NUMBER_COUNTER_ADDR        (0x80162C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT23_QUEUE_1_PACKET_NUMBER_COUNTER_ADDR        (0x80172C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT24_QUEUE_1_PACKET_NUMBER_COUNTER_ADDR        (0x80182C + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT0_QUEUE_2_PACKET_NUMBER_COUNTER_ADDR        (0x800030 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT1_QUEUE_2_PACKET_NUMBER_COUNTER_ADDR        (0x800130 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT2_QUEUE_2_PACKET_NUMBER_COUNTER_ADDR        (0x800230 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT3_QUEUE_2_PACKET_NUMBER_COUNTER_ADDR        (0x800330 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT4_QUEUE_2_PACKET_NUMBER_COUNTER_ADDR        (0x800430 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT5_QUEUE_2_PACKET_NUMBER_COUNTER_ADDR        (0x800530 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT6_QUEUE_2_PACKET_NUMBER_COUNTER_ADDR        (0x800630 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT7_QUEUE_2_PACKET_NUMBER_COUNTER_ADDR        (0x800730 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT8_QUEUE_2_PACKET_NUMBER_COUNTER_ADDR        (0x800830 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT9_QUEUE_2_PACKET_NUMBER_COUNTER_ADDR        (0x800930 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT10_QUEUE_2_PACKET_NUMBER_COUNTER_ADDR        (0x800A30 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT11_QUEUE_2_PACKET_NUMBER_COUNTER_ADDR        (0x800B30 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT12_QUEUE_2_PACKET_NUMBER_COUNTER_ADDR        (0x800C30 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT13_QUEUE_2_PACKET_NUMBER_COUNTER_ADDR        (0x800D30 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT14_QUEUE_2_PACKET_NUMBER_COUNTER_ADDR        (0x800E30 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT15_QUEUE_2_PACKET_NUMBER_COUNTER_ADDR        (0x800F30 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT16_QUEUE_2_PACKET_NUMBER_COUNTER_ADDR        (0x801030 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT17_QUEUE_2_PACKET_NUMBER_COUNTER_ADDR        (0x801130 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT18_QUEUE_2_PACKET_NUMBER_COUNTER_ADDR        (0x801230 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT19_QUEUE_2_PACKET_NUMBER_COUNTER_ADDR        (0x801330 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT20_QUEUE_2_PACKET_NUMBER_COUNTER_ADDR        (0x801430 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT21_QUEUE_2_PACKET_NUMBER_COUNTER_ADDR        (0x801530 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT22_QUEUE_2_PACKET_NUMBER_COUNTER_ADDR        (0x801630 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT23_QUEUE_2_PACKET_NUMBER_COUNTER_ADDR        (0x801730 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT24_QUEUE_2_PACKET_NUMBER_COUNTER_ADDR        (0x801830 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT0_QUEUE_3_PACKET_NUMBER_COUNTER_ADDR        (0x800034 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT1_QUEUE_3_PACKET_NUMBER_COUNTER_ADDR        (0x800134 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT2_QUEUE_3_PACKET_NUMBER_COUNTER_ADDR        (0x800234 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT3_QUEUE_3_PACKET_NUMBER_COUNTER_ADDR        (0x800334 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT4_QUEUE_3_PACKET_NUMBER_COUNTER_ADDR        (0x800434 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT5_QUEUE_3_PACKET_NUMBER_COUNTER_ADDR        (0x800534 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT6_QUEUE_3_PACKET_NUMBER_COUNTER_ADDR        (0x800634 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT7_QUEUE_3_PACKET_NUMBER_COUNTER_ADDR        (0x800734 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT8_QUEUE_3_PACKET_NUMBER_COUNTER_ADDR        (0x800834 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT9_QUEUE_3_PACKET_NUMBER_COUNTER_ADDR        (0x800934 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT10_QUEUE_3_PACKET_NUMBER_COUNTER_ADDR        (0x800A34 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT11_QUEUE_3_PACKET_NUMBER_COUNTER_ADDR        (0x800B34 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT12_QUEUE_3_PACKET_NUMBER_COUNTER_ADDR        (0x800C34 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT13_QUEUE_3_PACKET_NUMBER_COUNTER_ADDR        (0x800D34 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT14_QUEUE_3_PACKET_NUMBER_COUNTER_ADDR        (0x800E34 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT15_QUEUE_3_PACKET_NUMBER_COUNTER_ADDR        (0x800F34 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT16_QUEUE_3_PACKET_NUMBER_COUNTER_ADDR        (0x801034 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT17_QUEUE_3_PACKET_NUMBER_COUNTER_ADDR        (0x801134 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT18_QUEUE_3_PACKET_NUMBER_COUNTER_ADDR        (0x801234 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT19_QUEUE_3_PACKET_NUMBER_COUNTER_ADDR        (0x801334 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT20_QUEUE_3_PACKET_NUMBER_COUNTER_ADDR        (0x801434 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT21_QUEUE_3_PACKET_NUMBER_COUNTER_ADDR        (0x801534 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT22_QUEUE_3_PACKET_NUMBER_COUNTER_ADDR        (0x801634 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT23_QUEUE_3_PACKET_NUMBER_COUNTER_ADDR        (0x801734 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)
#define PORT24_QUEUE_3_PACKET_NUMBER_COUNTER_ADDR        (0x801834 + QUEUE_MANAGEMENT_AND_QUEUE_SCHEDULE_BASE)

/* Module: LINK AGGREGATION */
#define LINK_AGGREGATION_BASE            0xBB3C0000
#define LINK_AGGREGATION_MEMBER_CONTROL0_ADDR        (0x0 + LINK_AGGREGATION_BASE)
#define LINK_AGGREGATION_MEMBER_CONTROL1_ADDR        (0x4 + LINK_AGGREGATION_BASE)
#define LINK_AGGREGATION_MEMBER_CONTROL2_ADDR        (0x8 + LINK_AGGREGATION_BASE)
#define LINK_AGGREGATION_MEMBER_CONTROL3_ADDR        (0xC + LINK_AGGREGATION_BASE)
#define LINK_AGGREGATION_CONGEST_PORT_CONTROL_ADDR        (0x10 + LINK_AGGREGATION_BASE)
#define LINK_AGGREGATION_EMPTY_PORT_CONTROL_ADDR        (0x14 + LINK_AGGREGATION_BASE)

/* Module: MIRRORING */
#define MIRRORING_BASE            0xBB400000
#define TRAFFIC_MIRROR_CONTROL0_ADDR        (0x0 + MIRRORING_BASE)
#define TRAFFIC_MIRROR_CONTROL1_ADDR        (0x4 + MIRRORING_BASE)
#define TRAFFIC_MIRROR_CONTROL2_ADDR        (0x8 + MIRRORING_BASE)
#define MIRROR_PORT_EGRESS_FILTER_CONTROL_ADDR        (0xC + MIRRORING_BASE)
#define TRAFFIC_MIRROR_SAMPLE_CONTROL_ADDR        (0x10 + MIRRORING_BASE)
#define TRAFFIC_MIRROR_SAMPLE_STATISTIC_ADDR        (0x14 + MIRRORING_BASE)

/* Module: PACKET PARSER */
#define PACKET_PARSER_BASE            0xBB500000
#define CPU_TAG_CONTROL_ADDR        (0x0 + PACKET_PARSER_BASE)
#define PACKET_PARSER_PID_CONTROL_REGIST_0_ADDR        (0x4 + PACKET_PARSER_BASE)
#define PACKET_PARSER_PID_CONTROL_REGIST_1_ADDR        (0x8 + PACKET_PARSER_BASE)
#define PORT23_PID_MASK_CONTROL_ADDR        (0xC + PACKET_PARSER_BASE)
#define PORT24_PID_MASK_CONTROL_ADDR        (0x10 + PACKET_PARSER_BASE)
#define PACKET_PARSER_LAYER2_TYPE_CONTROL_ADDR        (0x14 + PACKET_PARSER_BASE)
#define PORT_MAXLEN_CONTROL_ADDR        (0x18 + PACKET_PARSER_BASE)
#define PORT23_MAXLEN_CONTROL_ADDR        (0x1C + PACKET_PARSER_BASE)
#define PORT24_MAXLEN_CONTROL_ADDR        (0x20 + PACKET_PARSER_BASE)
#define PORT0_PID_MASK_CONTROL_ADDR        (0x800000 + PACKET_PARSER_BASE)
#define PORT1_PID_MASK_CONTROL_ADDR        (0x800100 + PACKET_PARSER_BASE)
#define PORT2_PID_MASK_CONTROL_ADDR        (0x800200 + PACKET_PARSER_BASE)
#define PORT3_PID_MASK_CONTROL_ADDR        (0x800300 + PACKET_PARSER_BASE)
#define PORT4_PID_MASK_CONTROL_ADDR        (0x800400 + PACKET_PARSER_BASE)
#define PORT5_PID_MASK_CONTROL_ADDR        (0x800500 + PACKET_PARSER_BASE)
#define PORT6_PID_MASK_CONTROL_ADDR        (0x800600 + PACKET_PARSER_BASE)
#define PORT7_PID_MASK_CONTROL_ADDR        (0x800700 + PACKET_PARSER_BASE)
#define PORT8_PID_MASK_CONTROL_ADDR        (0x800800 + PACKET_PARSER_BASE)
#define PORT9_PID_MASK_CONTROL_ADDR        (0x800900 + PACKET_PARSER_BASE)
#define PORT10_PID_MASK_CONTROL_ADDR        (0x800A00 + PACKET_PARSER_BASE)
#define PORT11_PID_MASK_CONTROL_ADDR        (0x800B00 + PACKET_PARSER_BASE)
#define PORT12_PID_MASK_CONTROL_ADDR        (0x800C00 + PACKET_PARSER_BASE)
#define PORT13_PID_MASK_CONTROL_ADDR        (0x800D00 + PACKET_PARSER_BASE)
#define PORT14_PID_MASK_CONTROL_ADDR        (0x800E00 + PACKET_PARSER_BASE)
#define PORT15_PID_MASK_CONTROL_ADDR        (0x800F00 + PACKET_PARSER_BASE)
#define PORT16_PID_MASK_CONTROL_ADDR        (0x801000 + PACKET_PARSER_BASE)
#define PORT17_PID_MASK_CONTROL_ADDR        (0x801100 + PACKET_PARSER_BASE)
#define PORT18_PID_MASK_CONTROL_ADDR        (0x801200 + PACKET_PARSER_BASE)
#define PORT19_PID_MASK_CONTROL_ADDR        (0x801300 + PACKET_PARSER_BASE)
#define PORT20_PID_MASK_CONTROL_ADDR        (0x801400 + PACKET_PARSER_BASE)
#define PORT21_PID_MASK_CONTROL_ADDR        (0x801500 + PACKET_PARSER_BASE)
#define PORT22_PID_MASK_CONTROL_ADDR        (0x801600 + PACKET_PARSER_BASE)
#define PORT0_CHECKSUM_ERROR_CONTROL_ADDR        (0x800004 + PACKET_PARSER_BASE)
#define PORT1_CHECKSUM_ERROR_CONTROL_ADDR        (0x800104 + PACKET_PARSER_BASE)
#define PORT2_CHECKSUM_ERROR_CONTROL_ADDR        (0x800204 + PACKET_PARSER_BASE)
#define PORT3_CHECKSUM_ERROR_CONTROL_ADDR        (0x800304 + PACKET_PARSER_BASE)
#define PORT4_CHECKSUM_ERROR_CONTROL_ADDR        (0x800404 + PACKET_PARSER_BASE)
#define PORT5_CHECKSUM_ERROR_CONTROL_ADDR        (0x800504 + PACKET_PARSER_BASE)
#define PORT6_CHECKSUM_ERROR_CONTROL_ADDR        (0x800604 + PACKET_PARSER_BASE)
#define PORT7_CHECKSUM_ERROR_CONTROL_ADDR        (0x800704 + PACKET_PARSER_BASE)
#define PORT8_CHECKSUM_ERROR_CONTROL_ADDR        (0x800804 + PACKET_PARSER_BASE)
#define PORT9_CHECKSUM_ERROR_CONTROL_ADDR        (0x800904 + PACKET_PARSER_BASE)
#define PORT10_CHECKSUM_ERROR_CONTROL_ADDR        (0x800A04 + PACKET_PARSER_BASE)
#define PORT11_CHECKSUM_ERROR_CONTROL_ADDR        (0x800B04 + PACKET_PARSER_BASE)
#define PORT12_CHECKSUM_ERROR_CONTROL_ADDR        (0x800C04 + PACKET_PARSER_BASE)
#define PORT13_CHECKSUM_ERROR_CONTROL_ADDR        (0x800D04 + PACKET_PARSER_BASE)
#define PORT14_CHECKSUM_ERROR_CONTROL_ADDR        (0x800E04 + PACKET_PARSER_BASE)
#define PORT15_CHECKSUM_ERROR_CONTROL_ADDR        (0x800F04 + PACKET_PARSER_BASE)
#define PORT16_CHECKSUM_ERROR_CONTROL_ADDR        (0x801004 + PACKET_PARSER_BASE)
#define PORT17_CHECKSUM_ERROR_CONTROL_ADDR        (0x801104 + PACKET_PARSER_BASE)
#define PORT18_CHECKSUM_ERROR_CONTROL_ADDR        (0x801204 + PACKET_PARSER_BASE)
#define PORT19_CHECKSUM_ERROR_CONTROL_ADDR        (0x801304 + PACKET_PARSER_BASE)
#define PORT20_CHECKSUM_ERROR_CONTROL_ADDR        (0x801404 + PACKET_PARSER_BASE)
#define PORT21_CHECKSUM_ERROR_CONTROL_ADDR        (0x801504 + PACKET_PARSER_BASE)
#define PORT22_CHECKSUM_ERROR_CONTROL_ADDR        (0x801604 + PACKET_PARSER_BASE)
#define PORT23_CHECKSUM_ERROR_CONTROL_ADDR        (0x801704 + PACKET_PARSER_BASE)
#define PORT24_CHECKSUM_ERROR_CONTROL_ADDR        (0x801804 + PACKET_PARSER_BASE)
#define PORT0_DROP_REASON_ADDR        (0x800008 + PACKET_PARSER_BASE)
#define PORT1_DROP_REASON_ADDR        (0x800108 + PACKET_PARSER_BASE)
#define PORT2_DROP_REASON_ADDR        (0x800208 + PACKET_PARSER_BASE)
#define PORT3_DROP_REASON_ADDR        (0x800308 + PACKET_PARSER_BASE)
#define PORT4_DROP_REASON_ADDR        (0x800408 + PACKET_PARSER_BASE)
#define PORT5_DROP_REASON_ADDR        (0x800508 + PACKET_PARSER_BASE)
#define PORT6_DROP_REASON_ADDR        (0x800608 + PACKET_PARSER_BASE)
#define PORT7_DROP_REASON_ADDR        (0x800708 + PACKET_PARSER_BASE)
#define PORT8_DROP_REASON_ADDR        (0x800808 + PACKET_PARSER_BASE)
#define PORT9_DROP_REASON_ADDR        (0x800908 + PACKET_PARSER_BASE)
#define PORT10_DROP_REASON_ADDR        (0x800A08 + PACKET_PARSER_BASE)
#define PORT11_DROP_REASON_ADDR        (0x800B08 + PACKET_PARSER_BASE)
#define PORT12_DROP_REASON_ADDR        (0x800C08 + PACKET_PARSER_BASE)
#define PORT13_DROP_REASON_ADDR        (0x800D08 + PACKET_PARSER_BASE)
#define PORT14_DROP_REASON_ADDR        (0x800E08 + PACKET_PARSER_BASE)
#define PORT15_DROP_REASON_ADDR        (0x800F08 + PACKET_PARSER_BASE)
#define PORT16_DROP_REASON_ADDR        (0x801008 + PACKET_PARSER_BASE)
#define PORT17_DROP_REASON_ADDR        (0x801108 + PACKET_PARSER_BASE)
#define PORT18_DROP_REASON_ADDR        (0x801208 + PACKET_PARSER_BASE)
#define PORT19_DROP_REASON_ADDR        (0x801308 + PACKET_PARSER_BASE)
#define PORT20_DROP_REASON_ADDR        (0x801408 + PACKET_PARSER_BASE)
#define PORT21_DROP_REASON_ADDR        (0x801508 + PACKET_PARSER_BASE)
#define PORT22_DROP_REASON_ADDR        (0x801608 + PACKET_PARSER_BASE)
#define PORT23_DROP_REASON_ADDR        (0x801708 + PACKET_PARSER_BASE)
#define PORT24_DROP_REASON_ADDR        (0x801808 + PACKET_PARSER_BASE)

/* Module: ALE MISC */
#define ALE_MISC_BASE            0xBB510000
#define IGMP_MLD_CONTROL_ADDR        (0x0 + ALE_MISC_BASE)
#define OPTION_HEADER_TRAP_CONTROL_ADDR        (0x4 + ALE_MISC_BASE)
#define CFI_CONTROL_ADDR        (0x8 + ALE_MISC_BASE)

/* Module: RMA */
#define RMA_BASE            0xBB530000
#define RMA_CONTROL0_ADDR        (0x0 + RMA_BASE)
#define RMA_CONTROL1_ADDR        (0x4 + RMA_BASE)
#define RMA_CONTROL2_ADDR        (0x8 + RMA_BASE)
#define RMA_CPU_PORT_CONTROL_ADDR        (0xC + RMA_BASE)

/* Module: OAM */
#define OAM_BASE            0xBB540000
#define OAM_PDU_CONTROL_ADDR        (0x0 + OAM_BASE)
#define PORT0_OAM_PARSER_CONTROL_ADDR        (0x800000 + OAM_BASE)
#define PORT1_OAM_PARSER_CONTROL_ADDR        (0x800100 + OAM_BASE)
#define PORT2_OAM_PARSER_CONTROL_ADDR        (0x800200 + OAM_BASE)
#define PORT3_OAM_PARSER_CONTROL_ADDR        (0x800300 + OAM_BASE)
#define PORT4_OAM_PARSER_CONTROL_ADDR        (0x800400 + OAM_BASE)
#define PORT5_OAM_PARSER_CONTROL_ADDR        (0x800500 + OAM_BASE)
#define PORT6_OAM_PARSER_CONTROL_ADDR        (0x800600 + OAM_BASE)
#define PORT7_OAM_PARSER_CONTROL_ADDR        (0x800700 + OAM_BASE)
#define PORT8_OAM_PARSER_CONTROL_ADDR        (0x800800 + OAM_BASE)
#define PORT9_OAM_PARSER_CONTROL_ADDR        (0x800900 + OAM_BASE)
#define PORT10_OAM_PARSER_CONTROL_ADDR        (0x800A00 + OAM_BASE)
#define PORT11_OAM_PARSER_CONTROL_ADDR        (0x800B00 + OAM_BASE)
#define PORT12_OAM_PARSER_CONTROL_ADDR        (0x800C00 + OAM_BASE)
#define PORT13_OAM_PARSER_CONTROL_ADDR        (0x800D00 + OAM_BASE)
#define PORT14_OAM_PARSER_CONTROL_ADDR        (0x800E00 + OAM_BASE)
#define PORT15_OAM_PARSER_CONTROL_ADDR        (0x800F00 + OAM_BASE)
#define PORT16_OAM_PARSER_CONTROL_ADDR        (0x801000 + OAM_BASE)
#define PORT17_OAM_PARSER_CONTROL_ADDR        (0x801100 + OAM_BASE)
#define PORT18_OAM_PARSER_CONTROL_ADDR        (0x801200 + OAM_BASE)
#define PORT19_OAM_PARSER_CONTROL_ADDR        (0x801300 + OAM_BASE)
#define PORT20_OAM_PARSER_CONTROL_ADDR        (0x801400 + OAM_BASE)
#define PORT21_OAM_PARSER_CONTROL_ADDR        (0x801500 + OAM_BASE)
#define PORT22_OAM_PARSER_CONTROL_ADDR        (0x801600 + OAM_BASE)
#define PORT23_OAM_PARSER_CONTROL_ADDR        (0x801700 + OAM_BASE)
#define PORT24_OAM_PARSER_CONTROL_ADDR        (0x801800 + OAM_BASE)
#define PORT0_OAM_MULTIPLEXER_CONTROL_ADDR        (0x800004 + OAM_BASE)
#define PORT1_OAM_MULTIPLEXER_CONTROL_ADDR        (0x800104 + OAM_BASE)
#define PORT2_OAM_MULTIPLEXER_CONTROL_ADDR        (0x800204 + OAM_BASE)
#define PORT3_OAM_MULTIPLEXER_CONTROL_ADDR        (0x800304 + OAM_BASE)
#define PORT4_OAM_MULTIPLEXER_CONTROL_ADDR        (0x800404 + OAM_BASE)
#define PORT5_OAM_MULTIPLEXER_CONTROL_ADDR        (0x800504 + OAM_BASE)
#define PORT6_OAM_MULTIPLEXER_CONTROL_ADDR        (0x800604 + OAM_BASE)
#define PORT7_OAM_MULTIPLEXER_CONTROL_ADDR        (0x800704 + OAM_BASE)
#define PORT8_OAM_MULTIPLEXER_CONTROL_ADDR        (0x800804 + OAM_BASE)
#define PORT9_OAM_MULTIPLEXER_CONTROL_ADDR        (0x800904 + OAM_BASE)
#define PORT10_OAM_MULTIPLEXER_CONTROL_ADDR        (0x800A04 + OAM_BASE)
#define PORT11_OAM_MULTIPLEXER_CONTROL_ADDR        (0x800B04 + OAM_BASE)
#define PORT12_OAM_MULTIPLEXER_CONTROL_ADDR        (0x800C04 + OAM_BASE)
#define PORT13_OAM_MULTIPLEXER_CONTROL_ADDR        (0x800D04 + OAM_BASE)
#define PORT14_OAM_MULTIPLEXER_CONTROL_ADDR        (0x800E04 + OAM_BASE)
#define PORT15_OAM_MULTIPLEXER_CONTROL_ADDR        (0x800F04 + OAM_BASE)
#define PORT16_OAM_MULTIPLEXER_CONTROL_ADDR        (0x801004 + OAM_BASE)
#define PORT17_OAM_MULTIPLEXER_CONTROL_ADDR        (0x801104 + OAM_BASE)
#define PORT18_OAM_MULTIPLEXER_CONTROL_ADDR        (0x801204 + OAM_BASE)
#define PORT19_OAM_MULTIPLEXER_CONTROL_ADDR        (0x801304 + OAM_BASE)
#define PORT20_OAM_MULTIPLEXER_CONTROL_ADDR        (0x801404 + OAM_BASE)
#define PORT21_OAM_MULTIPLEXER_CONTROL_ADDR        (0x801504 + OAM_BASE)
#define PORT22_OAM_MULTIPLEXER_CONTROL_ADDR        (0x801604 + OAM_BASE)
#define PORT23_OAM_MULTIPLEXER_CONTROL_ADDR        (0x801704 + OAM_BASE)
#define PORT24_OAM_MULTIPLEXER_CONTROL_ADDR        (0x801804 + OAM_BASE)

/* Module: DUMMY PORT */
#define DUMMY_PORT_BASE            0xBB590000
#define DYING_GASP_POWER_MONITOR_CIRCUIT_DEGLITCH_ADDR        (0x0 + DUMMY_PORT_BASE)
#define CPU_PORT_GLOBAL_CONTROL_ADDR        (0x4 + DUMMY_PORT_BASE)
#define PORT23_OAM_DYING_GASP_CONTROL_ADDR        (0x801700 + DUMMY_PORT_BASE)
#define PORT24_OAM_DYING_GASP_CONTROL_ADDR        (0x801800 + DUMMY_PORT_BASE)
#define PORT23_OAM_LOCAL_DYING_GASP_CONTROL0_ADDR        (0x801704 + DUMMY_PORT_BASE)
#define PORT24_OAM_LOCAL_DYING_GASP_CONTROL0_ADDR        (0x801804 + DUMMY_PORT_BASE)
#define PORT23_OAM_LOCAL_DYING_GASP_CONTROL1_ADDR        (0x801708 + DUMMY_PORT_BASE)
#define PORT24_OAM_LOCAL_DYING_GASP_CONTROL1_ADDR        (0x801808 + DUMMY_PORT_BASE)
#define PORT23_OAM_LOCAL_DYING_GASP_CONTROL2_ADDR        (0x80170C + DUMMY_PORT_BASE)
#define PORT24_OAM_LOCAL_DYING_GASP_CONTROL2_ADDR        (0x80180C + DUMMY_PORT_BASE)
#define PORT23_OAM_LOCAL_DYING_GASP_CONTROL3_ADDR        (0x801710 + DUMMY_PORT_BASE)
#define PORT24_OAM_LOCAL_DYING_GASP_CONTROL3_ADDR        (0x801810 + DUMMY_PORT_BASE)
#define PORT23_OAM_REMOTE_DYING_GASP_CONTROL0_ADDR        (0x801714 + DUMMY_PORT_BASE)
#define PORT24_OAM_REMOTE_DYING_GASP_CONTROL0_ADDR        (0x801814 + DUMMY_PORT_BASE)
#define PORT23_OAM_REMOTE_DYING_GASP_CONTROL1_ADDR        (0x801718 + DUMMY_PORT_BASE)
#define PORT24_OAM_REMOTE_DYING_GASP_CONTROL1_ADDR        (0x801818 + DUMMY_PORT_BASE)
#define PORT23_OAM_REMOTE_DYING_GASP_CONTROL2_ADDR        (0x80171C + DUMMY_PORT_BASE)
#define PORT24_OAM_REMOTE_DYING_GASP_CONTROL2_ADDR        (0x80181C + DUMMY_PORT_BASE)
#define PORT23_OAM_REMOTE_DYING_GASP_CONTROL3_ADDR        (0x801720 + DUMMY_PORT_BASE)
#define PORT24_OAM_REMOTE_DYING_GASP_CONTROL3_ADDR        (0x801820 + DUMMY_PORT_BASE)

/* Module: TX MODIFICATION */
#define TX_MODIFICATION_BASE            0xBB550000
#define PORT23_TX_TAG_CONTROL_ADDR        (0x0 + TX_MODIFICATION_BASE)
#define PORT24_TX_TAG_CONTROL_ADDR        (0x4 + TX_MODIFICATION_BASE)
#define PORT0_TX_TAG_CONTROL_ADDR        (0x800000 + TX_MODIFICATION_BASE)
#define PORT1_TX_TAG_CONTROL_ADDR        (0x800100 + TX_MODIFICATION_BASE)
#define PORT2_TX_TAG_CONTROL_ADDR        (0x800200 + TX_MODIFICATION_BASE)
#define PORT3_TX_TAG_CONTROL_ADDR        (0x800300 + TX_MODIFICATION_BASE)
#define PORT4_TX_TAG_CONTROL_ADDR        (0x800400 + TX_MODIFICATION_BASE)
#define PORT5_TX_TAG_CONTROL_ADDR        (0x800500 + TX_MODIFICATION_BASE)
#define PORT6_TX_TAG_CONTROL_ADDR        (0x800600 + TX_MODIFICATION_BASE)
#define PORT7_TX_TAG_CONTROL_ADDR        (0x800700 + TX_MODIFICATION_BASE)
#define PORT8_TX_TAG_CONTROL_ADDR        (0x800800 + TX_MODIFICATION_BASE)
#define PORT9_TX_TAG_CONTROL_ADDR        (0x800900 + TX_MODIFICATION_BASE)
#define PORT10_TX_TAG_CONTROL_ADDR        (0x800A00 + TX_MODIFICATION_BASE)
#define PORT11_TX_TAG_CONTROL_ADDR        (0x800B00 + TX_MODIFICATION_BASE)
#define PORT12_TX_TAG_CONTROL_ADDR        (0x800C00 + TX_MODIFICATION_BASE)
#define PORT13_TX_TAG_CONTROL_ADDR        (0x800D00 + TX_MODIFICATION_BASE)
#define PORT14_TX_TAG_CONTROL_ADDR        (0x800E00 + TX_MODIFICATION_BASE)
#define PORT15_TX_TAG_CONTROL_ADDR        (0x800F00 + TX_MODIFICATION_BASE)
#define PORT16_TX_TAG_CONTROL_ADDR        (0x801000 + TX_MODIFICATION_BASE)
#define PORT17_TX_TAG_CONTROL_ADDR        (0x801100 + TX_MODIFICATION_BASE)
#define PORT18_TX_TAG_CONTROL_ADDR        (0x801200 + TX_MODIFICATION_BASE)
#define PORT19_TX_TAG_CONTROL_ADDR        (0x801300 + TX_MODIFICATION_BASE)
#define PORT20_TX_TAG_CONTROL_ADDR        (0x801400 + TX_MODIFICATION_BASE)
#define PORT21_TX_TAG_CONTROL_ADDR        (0x801500 + TX_MODIFICATION_BASE)
#define PORT22_TX_TAG_CONTROL_ADDR        (0x801600 + TX_MODIFICATION_BASE)

/* Module: RTCT */
#define RTCT_BASE            0xBB560000
#define RTCT_GLOBAL_CONTROL_ADDR        (0x0 + RTCT_BASE)
#define RTCT_MASK_ADDR        (0x4 + RTCT_BASE)
#define PORT22_RTCT_RESULT0_FOR_GIGA_ADDR        (0x8 + RTCT_BASE)
#define PORT22_RTCT_RESULT1_FOR_GIGA_ADDR        (0xC + RTCT_BASE)
#define PORT23_RTCT_RESULT0_FOR_GIGA_ADDR        (0x10 + RTCT_BASE)
#define PORT23_RTCT_RESULT1_FOR_GIGA_ADDR        (0x14 + RTCT_BASE)
#define PORT24_RTCT_RESULT0_FOR_GIGA_ADDR        (0x18 + RTCT_BASE)
#define PORT24_RTCT_RESULT1_FOR_GIGA_ADDR        (0x1C + RTCT_BASE)
#define PORT0_RTCT_RESULT0_ADDR        (0x800000 + RTCT_BASE)
#define PORT1_RTCT_RESULT0_ADDR        (0x800100 + RTCT_BASE)
#define PORT2_RTCT_RESULT0_ADDR        (0x800200 + RTCT_BASE)
#define PORT3_RTCT_RESULT0_ADDR        (0x800300 + RTCT_BASE)
#define PORT4_RTCT_RESULT0_ADDR        (0x800400 + RTCT_BASE)
#define PORT5_RTCT_RESULT0_ADDR        (0x800500 + RTCT_BASE)
#define PORT6_RTCT_RESULT0_ADDR        (0x800600 + RTCT_BASE)
#define PORT7_RTCT_RESULT0_ADDR        (0x800700 + RTCT_BASE)
#define PORT8_RTCT_RESULT0_ADDR        (0x800800 + RTCT_BASE)
#define PORT9_RTCT_RESULT0_ADDR        (0x800900 + RTCT_BASE)
#define PORT10_RTCT_RESULT0_ADDR        (0x800A00 + RTCT_BASE)
#define PORT11_RTCT_RESULT0_ADDR        (0x800B00 + RTCT_BASE)
#define PORT12_RTCT_RESULT0_ADDR        (0x800C00 + RTCT_BASE)
#define PORT13_RTCT_RESULT0_ADDR        (0x800D00 + RTCT_BASE)
#define PORT14_RTCT_RESULT0_ADDR        (0x800E00 + RTCT_BASE)
#define PORT15_RTCT_RESULT0_ADDR        (0x800F00 + RTCT_BASE)
#define PORT16_RTCT_RESULT0_ADDR        (0x801000 + RTCT_BASE)
#define PORT17_RTCT_RESULT0_ADDR        (0x801100 + RTCT_BASE)
#define PORT18_RTCT_RESULT0_ADDR        (0x801200 + RTCT_BASE)
#define PORT19_RTCT_RESULT0_ADDR        (0x801300 + RTCT_BASE)
#define PORT20_RTCT_RESULT0_ADDR        (0x801400 + RTCT_BASE)
#define PORT21_RTCT_RESULT0_ADDR        (0x801500 + RTCT_BASE)
#define PORT22_RTCT_RESULT0_ADDR        (0x801600 + RTCT_BASE)
#define PORT23_RTCT_RESULT0_ADDR        (0x801700 + RTCT_BASE)
#define PORT24_RTCT_RESULT0_ADDR        (0x801800 + RTCT_BASE)
#define PORT0_RTCT_RESULT1_ADDR        (0x800004 + RTCT_BASE)
#define PORT1_RTCT_RESULT1_ADDR        (0x800104 + RTCT_BASE)
#define PORT2_RTCT_RESULT1_ADDR        (0x800204 + RTCT_BASE)
#define PORT3_RTCT_RESULT1_ADDR        (0x800304 + RTCT_BASE)
#define PORT4_RTCT_RESULT1_ADDR        (0x800404 + RTCT_BASE)
#define PORT5_RTCT_RESULT1_ADDR        (0x800504 + RTCT_BASE)
#define PORT6_RTCT_RESULT1_ADDR        (0x800604 + RTCT_BASE)
#define PORT7_RTCT_RESULT1_ADDR        (0x800704 + RTCT_BASE)
#define PORT8_RTCT_RESULT1_ADDR        (0x800804 + RTCT_BASE)
#define PORT9_RTCT_RESULT1_ADDR        (0x800904 + RTCT_BASE)
#define PORT10_RTCT_RESULT1_ADDR        (0x800A04 + RTCT_BASE)
#define PORT11_RTCT_RESULT1_ADDR        (0x800B04 + RTCT_BASE)
#define PORT12_RTCT_RESULT1_ADDR        (0x800C04 + RTCT_BASE)
#define PORT13_RTCT_RESULT1_ADDR        (0x800D04 + RTCT_BASE)
#define PORT14_RTCT_RESULT1_ADDR        (0x800E04 + RTCT_BASE)
#define PORT15_RTCT_RESULT1_ADDR        (0x800F04 + RTCT_BASE)
#define PORT16_RTCT_RESULT1_ADDR        (0x801004 + RTCT_BASE)
#define PORT17_RTCT_RESULT1_ADDR        (0x801104 + RTCT_BASE)
#define PORT18_RTCT_RESULT1_ADDR        (0x801204 + RTCT_BASE)
#define PORT19_RTCT_RESULT1_ADDR        (0x801304 + RTCT_BASE)
#define PORT20_RTCT_RESULT1_ADDR        (0x801404 + RTCT_BASE)
#define PORT21_RTCT_RESULT1_ADDR        (0x801504 + RTCT_BASE)
#define PORT22_RTCT_RESULT1_ADDR        (0x801604 + RTCT_BASE)
#define PORT23_RTCT_RESULT1_ADDR        (0x801704 + RTCT_BASE)
#define PORT24_RTCT_RESULT1_ADDR        (0x801804 + RTCT_BASE)

/* Module: CPU RELEATED */
#define CPU_RELEATED_BASE            0xBB580000
#define CPU_8051_RESET_ADDR        (0x0 + CPU_RELEATED_BASE)
#define COMMAND_TYPE_ADDR        (0x4 + CPU_RELEATED_BASE)
#define DESTINATION_MEMORY_ADDRESS_ADDR        (0x8 + CPU_RELEATED_BASE)
#define SOURCE_MEMORY_ADDRESS_ADDR        (0xC + CPU_RELEATED_BASE)
#define DATA_LENGTH_RESIGTER_ADDR        (0x10 + CPU_RELEATED_BASE)
#define FLASH_PAGE_NUMBER_ADDR        (0x14 + CPU_RELEATED_BASE)
#define NOR_FLASH_CONFIGURATION_ADDR        (0x18 + CPU_RELEATED_BASE)
#define INTERNAL_MEMORY_CONTROL_ADDR        (0x1C + CPU_RELEATED_BASE)
#define INTERNAL_MEMORY_DATA0_ADDR        (0x20 + CPU_RELEATED_BASE)
#define INTERNAL_MEMORY_DATA1_ADDR        (0x24 + CPU_RELEATED_BASE)
#define SWITCHACCESS_ADDRESS_ADDR        (0x28 + CPU_RELEATED_BASE)
#define SWITCHACCESS_DATA_ADDR        (0x2C + CPU_RELEATED_BASE)
#define SWITCHACCESS_CONTROL_ADDR        (0x30 + CPU_RELEATED_BASE)
#define INDIRECT_ACCESS_FLASH_ADDRESS_ADDR        (0x34 + CPU_RELEATED_BASE)
#define INDIRECT_ACCESS_FLASH_DATA_ADDR        (0x38 + CPU_RELEATED_BASE)
#define INDIRECT_ACCESS_FLASH_CONTROL_ADDR        (0x3C + CPU_RELEATED_BASE)
#define SPI_CONTROLLER_GLOBAL_ADDR        (0x40 + CPU_RELEATED_BASE)
#define SPI_RIMODE_CONTROL_ADDR        (0x44 + CPU_RELEATED_BASE)
#define SPI_SMODE_CONTROL_ADDR        (0x48 + CPU_RELEATED_BASE)
#define SPI_SMODE_ADDRESS_ADDR        (0x4C + CPU_RELEATED_BASE)
#define SPI_SMODE_DATA_ADDR        (0x50 + CPU_RELEATED_BASE)
#define CPU_INTERRUPT_PS2LVL_ADDR        (0x54 + CPU_RELEATED_BASE)

/* Module: RRCP */
#define RRCP_BASE            0xBB600000
#define RRCP_GLOBAL_CONTROL_ADDR        (0x0 + RRCP_BASE)
#define RRCP_PRIVATE_KEY_CONTROL_ADDR        (0x4 + RRCP_BASE)
#define RRCP_AUTHENTICATION_KEY_CONTROL_ADDR        (0x8 + RRCP_BASE)
#define RRCP_DEFAULT_FID_CONTROL_ADDR        (0xC + RRCP_BASE)
#define RRCP_INNER_TAG_CONTROL_ADDR        (0x10 + RRCP_BASE)
#define RRCP_OUTER_TAG_CONTROL_ADDR        (0x14 + RRCP_BASE)
#define RRCP_HELLO_INDICATION_CONTROL_ADDR        (0x18 + RRCP_BASE)
#define SWITCH_OWN_MAC_CONTROL0_ADDR        (0x1C + RRCP_BASE)
#define SWITCH_OWN_MAC_CONTROL1_ADDR        (0x20 + RRCP_BASE)
#define SWITCH_CHIP_ID_CONTROL_ADDR        (0x24 + RRCP_BASE)
#define SWITCH_VENDER_ID_CONTROL_ADDR        (0x28 + RRCP_BASE)
#define RRCP_ADMINISTRABLE_CONTROL_ADDR        (0x2C + RRCP_BASE)
#define RRCP_AUTHENTICAED_CONTROL_ADDR        (0x30 + RRCP_BASE)
#define RRCP_PORT_DEBUG_CONTROL_ADDR        (0x34 + RRCP_BASE)
#define SIMPLE_PACKET_GENERATOR_CONTROL0_ADDR        (0x38 + RRCP_BASE)
#define SIMPLE_PACKET_GENERATOR_CONTROL1_ADDR        (0x3C + RRCP_BASE)
#define SIMPLE_PACKET_GENERATOR_CONTROL2_ADDR        (0x40 + RRCP_BASE)
#define SIMPLE_PACKET_GENERATOR_CONTROL3_ADDR        (0x44 + RRCP_BASE)
#define SIMPLE_PACKET_GENERATOR_CONTROL4_ADDR        (0x48 + RRCP_BASE)
#define SIMPLE_PACKET_GENERATOR_CONTROL5_ADDR        (0x4C + RRCP_BASE)
#define SIMPLE_PACKET_GENERATOR_CONTROL6_ADDR        (0x50 + RRCP_BASE)
#define SIMPLE_PACKET_GENERATOR_CONTROL7_ADDR        (0x54 + RRCP_BASE)
#define SIMPLE_PACKET_GENERATOR_CONTROL8_ADDR        (0x58 + RRCP_BASE)
#define SIMPLE_PACKET_GENERATOR_CONTROL9_ADDR        (0x5C + RRCP_BASE)
#define RRCP_CUSTOMER_CODE_CONTROL_ADDR        (0x60 + RRCP_BASE)

/* Module: RLDP AND UDLD */
#define RLDP_AND_UDLD_BASE            0xBB610000
#define RTKPP_RANDOM_NUMBER_CONTROL0_ADDR        (0x0 + RLDP_AND_UDLD_BASE)
#define RTKPP_RANDOM_NUMBER_CONTROL1_ADDR        (0x4 + RLDP_AND_UDLD_BASE)
#define RTKPP_RANDOM_NUMBER_CONTROL2_ADDR        (0x8 + RLDP_AND_UDLD_BASE)
#define RLDP_LOOP_STATE_RETRY_CONTROL_ADDR        (0xC + RLDP_AND_UDLD_BASE)
#define RLDP_CHECK_STATE_RETRY_CONTROL_ADDR        (0x10 + RLDP_AND_UDLD_BASE)
#define RLDP_ENABLE_PORT_MASK_CONTROL_ADDR        (0x14 + RLDP_AND_UDLD_BASE)
#define RLDP_LOOP_PORT_MASK_CONTROL_ADDR        (0x18 + RLDP_AND_UDLD_BASE)
#define RLDP_CHECKING_PORT_MASK_CONTROL_ADDR        (0x1C + RLDP_AND_UDLD_BASE)
#define RLDP_INTERRUPT_PENDING_MASK_CONTROL_ADDR        (0x20 + RLDP_AND_UDLD_BASE)
#define SOURCE_MAC_MOVING_PORT_MASK_ADDR        (0x24 + RLDP_AND_UDLD_BASE)
#define RLDP_GLOBAL_CONTROL_ADDR        (0x28 + RLDP_AND_UDLD_BASE)
#define TX_DISABLE_GLOBAL_CONTROL_ADDR        (0x2C + RLDP_AND_UDLD_BASE)
#define RX_DISABLE_GLOBAL_CONTROL_ADDR        (0x30 + RLDP_AND_UDLD_BASE)
#define UDLD_GLOBAL_CONTROL_ADDR        (0x34 + RLDP_AND_UDLD_BASE)
#define UDLD_ENABLED_PORT_MASK_CONTROL_ADDR        (0x38 + RLDP_AND_UDLD_BASE)
#define UDL_PORT_MASK_CONTROL_ADDR        (0x3C + RLDP_AND_UDLD_BASE)
#define UDL_INTERRUPT_PENDING_MASK_CONTROL_ADDR        (0x40 + RLDP_AND_UDLD_BASE)
#define PORT0_LOOP_PORT_ADDR        (0x800000 + RLDP_AND_UDLD_BASE)
#define PORT1_LOOP_PORT_ADDR        (0x800100 + RLDP_AND_UDLD_BASE)
#define PORT2_LOOP_PORT_ADDR        (0x800200 + RLDP_AND_UDLD_BASE)
#define PORT3_LOOP_PORT_ADDR        (0x800300 + RLDP_AND_UDLD_BASE)
#define PORT4_LOOP_PORT_ADDR        (0x800400 + RLDP_AND_UDLD_BASE)
#define PORT5_LOOP_PORT_ADDR        (0x800500 + RLDP_AND_UDLD_BASE)
#define PORT6_LOOP_PORT_ADDR        (0x800600 + RLDP_AND_UDLD_BASE)
#define PORT7_LOOP_PORT_ADDR        (0x800700 + RLDP_AND_UDLD_BASE)
#define PORT8_LOOP_PORT_ADDR        (0x800800 + RLDP_AND_UDLD_BASE)
#define PORT9_LOOP_PORT_ADDR        (0x800900 + RLDP_AND_UDLD_BASE)
#define PORT10_LOOP_PORT_ADDR        (0x800A00 + RLDP_AND_UDLD_BASE)
#define PORT11_LOOP_PORT_ADDR        (0x800B00 + RLDP_AND_UDLD_BASE)
#define PORT12_LOOP_PORT_ADDR        (0x800C00 + RLDP_AND_UDLD_BASE)
#define PORT13_LOOP_PORT_ADDR        (0x800D00 + RLDP_AND_UDLD_BASE)
#define PORT14_LOOP_PORT_ADDR        (0x800E00 + RLDP_AND_UDLD_BASE)
#define PORT15_LOOP_PORT_ADDR        (0x800F00 + RLDP_AND_UDLD_BASE)
#define PORT16_LOOP_PORT_ADDR        (0x801000 + RLDP_AND_UDLD_BASE)
#define PORT17_LOOP_PORT_ADDR        (0x801100 + RLDP_AND_UDLD_BASE)
#define PORT18_LOOP_PORT_ADDR        (0x801200 + RLDP_AND_UDLD_BASE)
#define PORT19_LOOP_PORT_ADDR        (0x801300 + RLDP_AND_UDLD_BASE)
#define PORT20_LOOP_PORT_ADDR        (0x801400 + RLDP_AND_UDLD_BASE)
#define PORT21_LOOP_PORT_ADDR        (0x801500 + RLDP_AND_UDLD_BASE)
#define PORT22_LOOP_PORT_ADDR        (0x801600 + RLDP_AND_UDLD_BASE)
#define PORT23_LOOP_PORT_ADDR        (0x801700 + RLDP_AND_UDLD_BASE)
#define PORT24_LOOP_PORT_ADDR        (0x801800 + RLDP_AND_UDLD_BASE)

/* Module: MIB COUNTER */
#define MIB_COUNTER_BASE            0xBB640000
#define MIB_COUNTER_CONTROL0_ADDR        (0x0 + MIB_COUNTER_BASE)
#define MIB_COUNTER_CONTROL1_ADDR        (0x4 + MIB_COUNTER_BASE)
#define MIB_COUNTER_CONTROL2_ADDR        (0x8 + MIB_COUNTER_BASE)
#define INDIRECT_ACCESS_MIB_COUNTER_CONTROLFOR_CPU_ADDR        (0xC + MIB_COUNTER_BASE)
#define INDIRECT_ACCESS_MIB_COUNTER_DATA0_FOR_CPU_ADDR        (0x10 + MIB_COUNTER_BASE)
#define INDIRECT_ACCESS_MIB_COUNTER_DATA1_FOR_CPU_ADDR        (0x14 + MIB_COUNTER_BASE)
#define QUEUE_MIB_COUNTER_COUNT_TYPE_SELECTION_ADDR        (0x18 + MIB_COUNTER_BASE)
#define GLOBAL_MIB_COUNTER_OVERFLOW_FLAG_ADDR        (0x1C + MIB_COUNTER_BASE)
#define SYSTEM_MIB_COUNTER_OVERFLOW_FLAG_ADDR        (0x20 + MIB_COUNTER_BASE)
#define PORT0_MIBCOUNTER_OVERFLOW_FLAG0_ADDR        (0x24 + MIB_COUNTER_BASE)
#define PORT0_MIBCOUNTER_OVERFLOW_FLAG1_ADDR        (0x28 + MIB_COUNTER_BASE)
#define PORT1_MIBCOUNTER_OVERFLOW_FLAG0_ADDR        (0x2C + MIB_COUNTER_BASE)
#define PORT1_MIBCOUNTER_OVERFLOW_FLAG1_ADDR        (0x30 + MIB_COUNTER_BASE)
#define PORT2_MIBCOUNTER_OVERFLOW_FLAG0_ADDR        (0x34 + MIB_COUNTER_BASE)
#define PORT2_MIBCOUNTER_OVERFLOW_FLAG1_ADDR        (0x38 + MIB_COUNTER_BASE)
#define PORT3_MIBCOUNTER_OVERFLOW_FLAG0_ADDR        (0x3C + MIB_COUNTER_BASE)
#define PORT3_MIBCOUNTER_OVERFLOW_FLAG1_ADDR        (0x40 + MIB_COUNTER_BASE)
#define PORT4_MIBCOUNTER_OVERFLOW_FLAG0_ADDR        (0x44 + MIB_COUNTER_BASE)
#define PORT4_MIBCOUNTER_OVERFLOW_FLAG1_ADDR        (0x48 + MIB_COUNTER_BASE)
#define PORT5_MIBCOUNTER_OVERFLOW_FLAG0_ADDR        (0x4C + MIB_COUNTER_BASE)
#define PORT5_MIBCOUNTER_OVERFLOW_FLAG1_ADDR        (0x50 + MIB_COUNTER_BASE)
#define PORT6_MIBCOUNTER_OVERFLOW_FLAG0_ADDR        (0x54 + MIB_COUNTER_BASE)
#define PORT6_MIBCOUNTER_OVERFLOW_FLAG1_ADDR        (0x58 + MIB_COUNTER_BASE)
#define PORT7_MIBCOUNTER_OVERFLOW_FLAG0_ADDR        (0x5C + MIB_COUNTER_BASE)
#define PORT7_MIBCOUNTER_OVERFLOW_FLAG1_ADDR        (0x60 + MIB_COUNTER_BASE)
#define PORT8_MIBCOUNTER_OVERFLOW_FLAG0_ADDR        (0x64 + MIB_COUNTER_BASE)
#define PORT8_MIBCOUNTER_OVERFLOW_FLAG1_ADDR        (0x68 + MIB_COUNTER_BASE)
#define PORT9_MIBCOUNTER_OVERFLOW_FLAG0_ADDR        (0x6C + MIB_COUNTER_BASE)
#define PORT9_MIBCOUNTER_OVERFLOW_FLAG1_ADDR        (0x70 + MIB_COUNTER_BASE)
#define PORT10_MIBCOUNTER_OVERFLOW_FLAG0_ADDR        (0x74 + MIB_COUNTER_BASE)
#define PORT10_MIBCOUNTER_OVERFLOW_FLAG1_ADDR        (0x78 + MIB_COUNTER_BASE)
#define PORT11_MIBCOUNTER_OVERFLOW_FLAG0_ADDR        (0x7C + MIB_COUNTER_BASE)
#define PORT11_MIBCOUNTER_OVERFLOW_FLAG1_ADDR        (0x80 + MIB_COUNTER_BASE)
#define PORT12_MIBCOUNTER_OVERFLOW_FLAG0_ADDR        (0x84 + MIB_COUNTER_BASE)
#define PORT12_MIBCOUNTER_OVERFLOW_FLAG1_ADDR        (0x88 + MIB_COUNTER_BASE)
#define PORT13_MIBCOUNTER_OVERFLOW_FLAG0_ADDR        (0x8C + MIB_COUNTER_BASE)
#define PORT13_MIBCOUNTER_OVERFLOW_FLAG1_ADDR        (0x90 + MIB_COUNTER_BASE)
#define PORT14_MIBCOUNTER_OVERFLOW_FLAG0_ADDR        (0x94 + MIB_COUNTER_BASE)
#define PORT14_MIBCOUNTER_OVERFLOW_FLAG1_ADDR        (0x98 + MIB_COUNTER_BASE)
#define PORT15_MIBCOUNTER_OVERFLOW_FLAG0_ADDR        (0x9C + MIB_COUNTER_BASE)
#define PORT15_MIBCOUNTER_OVERFLOW_FLAG1_ADDR        (0xA0 + MIB_COUNTER_BASE)
#define PORT16_MIBCOUNTER_OVERFLOW_FLAG0_ADDR        (0xA4 + MIB_COUNTER_BASE)
#define PORT16_MIBCOUNTER_OVERFLOW_FLAG1_ADDR        (0xA8 + MIB_COUNTER_BASE)
#define PORT17_MIBCOUNTER_OVERFLOW_FLAG0_ADDR        (0xAC + MIB_COUNTER_BASE)
#define PORT17_MIBCOUNTER_OVERFLOW_FLAG1_ADDR        (0xB0 + MIB_COUNTER_BASE)
#define PORT18_MIBCOUNTER_OVERFLOW_FLAG0_ADDR        (0xB4 + MIB_COUNTER_BASE)
#define PORT18_MIBCOUNTER_OVERFLOW_FLAG1_ADDR        (0xB8 + MIB_COUNTER_BASE)
#define PORT19_MIBCOUNTER_OVERFLOW_FLAG0_ADDR        (0xBC + MIB_COUNTER_BASE)
#define PORT19_MIBCOUNTER_OVERFLOW_FLAG1_ADDR        (0xC0 + MIB_COUNTER_BASE)
#define PORT20_MIBCOUNTER_OVERFLOW_FLAG0_ADDR        (0xC4 + MIB_COUNTER_BASE)
#define PORT20_MIBCOUNTER_OVERFLOW_FLAG1_ADDR        (0xC8 + MIB_COUNTER_BASE)
#define PORT21_MIBCOUNTER_OVERFLOW_FLAG0_ADDR        (0xCC + MIB_COUNTER_BASE)
#define PORT21_MIBCOUNTER_OVERFLOW_FLAG1_ADDR        (0xD0 + MIB_COUNTER_BASE)
#define PORT22_MIBCOUNTER_OVERFLOW_FLAG0_ADDR        (0xD4 + MIB_COUNTER_BASE)
#define PORT22_MIBCOUNTER_OVERFLOW_FLAG1_ADDR        (0xD8 + MIB_COUNTER_BASE)
#define PORT23_MIBCOUNTER_OVERFLOW_FLAG0_ADDR        (0xDC + MIB_COUNTER_BASE)
#define PORT23_MIBCOUNTER_OVERFLOW_FLAG1_ADDR        (0xE0 + MIB_COUNTER_BASE)
#define PORT24_MIBCOUNTER_OVERFLOW_FLAG0_ADDR        (0xE4 + MIB_COUNTER_BASE)
#define PORT24_MIBCOUNTER_OVERFLOW_FLAG1_ADDR        (0xE8 + MIB_COUNTER_BASE)
#define TEST_MODE_TRIGGER_ADDR        (0xEC + MIB_COUNTER_BASE)
#define TEST_MODE_WRITE_DATA0_ADDR        (0xF0 + MIB_COUNTER_BASE)
#define TEST_MODE_WRITE_DATA1_ADDR        (0xF4 + MIB_COUNTER_BASE)
#define TEST_MODE_READ_DATA0_ADDR        (0xF8 + MIB_COUNTER_BASE)
#define TEST_MODE_READ_DATA1_ADDR        (0xFC + MIB_COUNTER_BASE)
#define INDIRECT_ACCESS_MIB_COUNTER_CONTROLFOR_RRCP_ADDR        (0x100 + MIB_COUNTER_BASE)
#define INDIRECT_ACCESS_MIB_COUNTER_DATA0_FOR_RRCP_ADDR        (0x104 + MIB_COUNTER_BASE)
#define INDIRECT_ACCESS_MIB_COUNTER_DATA1_FOR_RRCP_ADDR        (0x108 + MIB_COUNTER_BASE)

/* Module: GPIO */
#define GPIO_BASE            0xBB650000
#define GLOBAL_GPIO_CONTROL0_ADDR        (0x0 + GPIO_BASE)
#define GLOBAL_GPIO_CONTROL1_ADDR        (0x4 + GPIO_BASE)
#define GLOBAL_GPIO_INTERRUPT_CONTROL_ADDR        (0x8 + GPIO_BASE)
#define GLOBAL_GPIO_INTERRUPT_STATUS_ADDR        (0xC + GPIO_BASE)

/* Module: INTERRUPT */
#define INTERRUPT_BASE            0xBB660000
#define SWITCH_INTERRUPT_GLOBAL_CONTROL_ADDR        (0x0 + INTERRUPT_BASE)
#define PER_PORT_LINK_CHANGE_INTERRUPT_CONTROL_ADDR        (0x4 + INTERRUPT_BASE)
#define PACKET_DROP_INTERRUPT_CONTROL0_ADDR        (0x8 + INTERRUPT_BASE)
#define PACKET_DROP_INTERRUPT_CONTROL1_ADDR        (0xC + INTERRUPT_BASE)
#define PER_PORT_SA_LEARNING_CONSTRAIN_INTERRUPT_CONTROL_ADDR        (0x10 + INTERRUPT_BASE)
#define SERDES_INTERRUPT_CONTROL_ADDR        (0x14 + INTERRUPT_BASE)
#define MISC_INTERRUPT_CONTROL_ADDR        (0x18 + INTERRUPT_BASE)
#define SWITCH_INTERRUPT_GLOBAL_SOURCE_STATUS_ADDR        (0x1C + INTERRUPT_BASE)
#define PER_PORT_LINK_CHANGE_INTERRUPT_STATUS_ADDR        (0x20 + INTERRUPT_BASE)
#define PACKET_DROP_INTERRUPT_STATUS0_ADDR        (0x24 + INTERRUPT_BASE)
#define PACKET_DROP_INTERRUPT_STATUS1_ADDR        (0x28 + INTERRUPT_BASE)
#define PER_PORT_SA_LEARNING_CONSTRAIN_INTERRUPT_STATUS_ADDR        (0x2C + INTERRUPT_BASE)
#define SERDES_INTERRUPT_STATUS_ADDR        (0x30 + INTERRUPT_BASE)
#define MISC_INTERRUPT_STATUS_ADDR        (0x34 + INTERRUPT_BASE)
#define SWITCH_INTERRUPT_MODE_ADDR        (0x38 + INTERRUPT_BASE)

/* Module: LED */
#define LED_BASE            0xBB670000
#define LED_CONTROL_ADDR        (0x0 + LED_BASE)
#define SOFTWARE_LED_CONTROL0_ADDR        (0x4 + LED_BASE)
#define SOFTWARE_LED_CONTROL1_ADDR        (0x8 + LED_BASE)
#define SOFTWARE_LED_CONTROL2_ADDR        (0xC + LED_BASE)
#define LED_IC_ACCESS_CONTROL_ADDR        (0x10 + LED_BASE)
#define LED_IC_ACCESS_DATA_ADDR        (0x14 + LED_BASE)
#define GPIO_CONTROL_ADDR        (0x18 + LED_BASE)
#define I2C_LIKE_LED_MODE0_ADDR        (0x1C + LED_BASE)
#define I2C_LIKE_LED_MODE1_ADDR        (0x20 + LED_BASE)
#define I2C_LIKE_LED_MODE2_ADDR        (0x24 + LED_BASE)
#define LED_CONTROL0_ADDR        (0x28 + LED_BASE)
#define LED_CONTROL1_ADDR        (0x2C + LED_BASE)
#define LED_CONTROL2_ADDR        (0x30 + LED_BASE)
#define LED_CONTROL3_ADDR        (0x34 + LED_BASE)
#define LED_CONTROL4_ADDR        (0x38 + LED_BASE)
#define LED_CONTROL5_ADDR        (0x3C + LED_BASE)
#define LED_CONTROL6_ADDR        (0x40 + LED_BASE)
#define LED_CONTROL7_ADDR        (0x44 + LED_BASE)
#define LED_CONTROL8_ADDR        (0x48 + LED_BASE)
#define LED_STATUS_CONTROL_ADDR        (0x4C + LED_BASE)
#define HORSE_RACE_LAMP_LED_CONTROL_ADDR        (0x50 + LED_BASE)

/* Module: NIC */
#define NIC_BASE            0xBB680000
#define NIC_GLOBAL_CONTROL_ADDR        (0x0 + NIC_BASE)
#define TXSTOP_ADDRESS_ADDR        (0x4 + NIC_BASE)
#define RXSTOP_ADDRESS_ADDR        (0x8 + NIC_BASE)
#define RX_BUFFER_RECEIVED_DATA_LENGTH_ADDR        (0xC + NIC_BASE)
#define TX_BUFFER_AVAILABLE_FREE_SPACE_ADDR        (0x10 + NIC_BASE)
#define RX_COMMAND_ADDR        (0x14 + NIC_BASE)
#define TX_COMMAND_ADDR        (0x18 + NIC_BASE)
#define NIC_INTERRUPT_STATUS_ADDR        (0x1C + NIC_BASE)
#define NIC_INTERRUPT_MASK_ADDR        (0x20 + NIC_BASE)
#define RX_CONTROL_ADDR        (0x24 + NIC_BASE)
#define TX_CONTROL_ADDR        (0x28 + NIC_BASE)
#define CPU_RX_CURRENT_PACKET_ADDR        (0x2C + NIC_BASE)
#define CPU_TX_CURRENT_PACKET_ADDR        (0x30 + NIC_BASE)
#define MULTICAST_HASH0_ADDR        (0x34 + NIC_BASE)
#define MULTICAST_HASH1_ADDR        (0x38 + NIC_BASE)
#define MULTICAST_HASH2_ADDR        (0x3C + NIC_BASE)
#define MULTICAST_HASH3_ADDR        (0x40 + NIC_BASE)
#define MULTICAST_HASH4_ADDR        (0x44 + NIC_BASE)
#define MULTICAST_HASH5_ADDR        (0x48 + NIC_BASE)
#define MULTICAST_HASH6_ADDR        (0x4C + NIC_BASE)
#define MULTICAST_HASH7_ADDR        (0x50 + NIC_BASE)
#define PHYSICAL_ADDRESS_HASH0_ADDR        (0x54 + NIC_BASE)
#define PHYSICAL_ADDRESS_HASH1_ADDR        (0x58 + NIC_BASE)
#define PHYSICAL_ADDRESS_HASH2_ADDR        (0x5C + NIC_BASE)
#define PHYSICAL_ADDRESS_HASH3_ADDR        (0x60 + NIC_BASE)
#define PHYSICAL_ADDRESS_HASH4_ADDR        (0x64 + NIC_BASE)
#define PHYSICAL_ADDRESS_HASH5_ADDR        (0x68 + NIC_BASE)
#define PHYSICAL_ADDRESS_HASH6_ADDR        (0x6C + NIC_BASE)
#define PHYSICAL_ADDRESS_HASH7_ADDR        (0x70 + NIC_BASE)
#define SRXCURPKTR_ADDR        (0x74 + NIC_BASE)
#define STXCURPKTR_ADDR        (0x78 + NIC_BASE)
#define TXPKTLENR_ADDR        (0x7C + NIC_BASE)
#define STXCURUNITR_ADDR        (0x80 + NIC_BASE)

/* Module: ALE RELATED DIAGNOSTIC */
#define ALE_RELATED_DIAGNOSTIC_BASE            0xBB6A0000
#define ALE_TEST_MODE_CONTROL_ADDR        (0x0 + ALE_RELATED_DIAGNOSTIC_BASE)
#define HEADER_STAMP_BEFORE_CR0_ADDR        (0x4 + ALE_RELATED_DIAGNOSTIC_BASE)
#define HEADER_STAMP_BEFORE_CR1_ADDR        (0x8 + ALE_RELATED_DIAGNOSTIC_BASE)
#define HEADER_STAMP_BEFORE_CR2_ADDR        (0xC + ALE_RELATED_DIAGNOSTIC_BASE)
#define HEADER_STAMP_BEFORE_CR3_ADDR        (0x10 + ALE_RELATED_DIAGNOSTIC_BASE)
#define HEADER_STAMP_BEFORE_CR4_ADDR        (0x14 + ALE_RELATED_DIAGNOSTIC_BASE)
#define HEADER_STAMP_BEFORE_CR5_ADDR        (0x18 + ALE_RELATED_DIAGNOSTIC_BASE)
#define HEADER_STAMP_BEFORE_CR6_ADDR        (0x1C + ALE_RELATED_DIAGNOSTIC_BASE)
#define HEADER_STAMP_BEFORE_CR7_ADDR        (0x20 + ALE_RELATED_DIAGNOSTIC_BASE)
#define HEADER_STAMP_BEFORE_CR8_ADDR        (0x24 + ALE_RELATED_DIAGNOSTIC_BASE)
#define HEADER_STAMP_BEFORE_CR9_ADDR        (0x28 + ALE_RELATED_DIAGNOSTIC_BASE)
#define HEADER_STAMP_BEFORE_CR10_ADDR        (0x2C + ALE_RELATED_DIAGNOSTIC_BASE)
#define HEADER_STAMP_BEFORE_CR11_ADDR        (0x30 + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_MODIFICATION_INFORMATION_CR0_ADDR        (0x34 + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_MODIFICATION_INFORMATION_CR1_ADDR        (0x38 + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_MODIFICATION_INFORMATION_CR2_ADDR        (0x3C + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_MODIFICATION_INFORMATION_CR3_ADDR        (0x40 + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_MODIFICATION_INFORMATION_CR4_ADDR        (0x44 + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_PROCESS_INFORMATION0_CR0_ADDR        (0x48 + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_PROCESS_INFORMATION0_CR1_ADDR        (0x4C + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_PROCESS_INFORMATION0_CR2_ADDR        (0x50 + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_PROCESS_INFORMATION0_CR3_ADDR        (0x54 + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_PROCESS_INFORMATION0_CR4_ADDR        (0x58 + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_PROCESS_INFORMATION0_CR5_ADDR        (0x5C + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_PROCESS_INFORMATION0_CR6_ADDR        (0x60 + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_PROCESS_INFORMATION0_CR7_ADDR        (0x64 + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_PROCESS_INFORMATION1_CR0_ADDR        (0x68 + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_PROCESS_INFORMATION1_CR1_ADDR        (0x6C + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_PROCESS_INFORMATION1_CR2_ADDR        (0x70 + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_PROCESS_INFORMATION1_CR3_ADDR        (0x74 + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_PROCESS_INFORMATION1_CR4_ADDR        (0x78 + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_PROCESS_INFORMATION1_CR5_ADDR        (0x7C + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_PROCESS_INFORMATION1_CR6_ADDR        (0x80 + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_PROCESS_INFORMATION1_CR7_ADDR        (0x84 + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_PROCESS_INFORMATION2_CR0_ADDR        (0x88 + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_PROCESS_INFORMATION2_CR1_ADDR        (0x8C + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_PROCESS_INFORMATION2_CR2_ADDR        (0x90 + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_PROCESS_INFORMATION2_CR3_ADDR        (0x94 + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_PROCESS_INFORMATION2_CR4_ADDR        (0x98 + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_PROCESS_INFORMATION2_CR5_ADDR        (0x9C + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_PROCESS_INFORMATION2_CR6_ADDR        (0xA0 + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_PROCESS_INFORMATION2_CR7_ADDR        (0xA4 + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_PROCESS_INFORMATION3_CR0_ADDR        (0xA8 + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_PROCESS_INFORMATION3_CR1_ADDR        (0xAC + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_PROCESS_INFORMATION3_CR2_ADDR        (0xB0 + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_PROCESS_INFORMATION3_CR3_ADDR        (0xB4 + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_PROCESS_INFORMATION3_CR4_ADDR        (0xB8 + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_PROCESS_INFORMATION3_CR5_ADDR        (0xBC + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_PROCESS_INFORMATION3_CR6_ADDR        (0xC0 + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_PROCESS_INFORMATION3_CR7_ADDR        (0xC4 + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_PROCESS_INFORMATION4_CR0_ADDR        (0xC8 + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_PROCESS_INFORMATION4_CR1_ADDR        (0xCC + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_PROCESS_INFORMATION4_CR2_ADDR        (0xD0 + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_PROCESS_INFORMATION4_CR3_ADDR        (0xD4 + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_PROCESS_INFORMATION4_CR4_ADDR        (0xD8 + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_PROCESS_INFORMATION4_CR5_ADDR        (0xDC + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_PROCESS_INFORMATION4_CR6_ADDR        (0xE0 + ALE_RELATED_DIAGNOSTIC_BASE)
#define PACKET_PROCESS_INFORMATION4_CR7_ADDR        (0xE4 + ALE_RELATED_DIAGNOSTIC_BASE)

/* Module: FLOW CONTROL DIAGNOSTIC */
#define FLOW_CONTROL_DIAGNOSTIC_BASE            0xBB6C0000
#define FLOWCTL_GLOBAL_PAGECNT_BEYOND_THRESHOLD_TIMES_ADDR        (0x0 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define GLOBAL_OCCUPIED_RX_PAGE_PEAK_COUNTER_ADDR        (0x4 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define SYSTEM_PAGE_COUNTER_ADDR        (0x8 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define DEBUG_COUNTER_RESET_ADDR        (0xC + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT0_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_ADDR        (0x800000 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT1_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_ADDR        (0x800100 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT2_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_ADDR        (0x800200 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT3_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_ADDR        (0x800300 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT4_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_ADDR        (0x800400 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT5_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_ADDR        (0x800500 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT6_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_ADDR        (0x800600 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT7_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_ADDR        (0x800700 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT8_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_ADDR        (0x800800 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT9_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_ADDR        (0x800900 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT10_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_ADDR        (0x800A00 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT11_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_ADDR        (0x800B00 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT12_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_ADDR        (0x800C00 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT13_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_ADDR        (0x800D00 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT14_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_ADDR        (0x800E00 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT15_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_ADDR        (0x800F00 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT16_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_ADDR        (0x801000 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT17_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_ADDR        (0x801100 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT18_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_ADDR        (0x801200 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT19_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_ADDR        (0x801300 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT20_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_ADDR        (0x801400 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT21_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_ADDR        (0x801500 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT22_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_ADDR        (0x801600 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT23_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_ADDR        (0x801700 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT24_RX_OCCUPIED_PAGE_COUNTER_BEYOND_THRESHOLD_TIMES_ADDR        (0x801800 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT0_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_ADDR        (0x800004 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT1_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_ADDR        (0x800104 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT2_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_ADDR        (0x800204 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT3_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_ADDR        (0x800304 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT4_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_ADDR        (0x800404 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT5_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_ADDR        (0x800504 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT6_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_ADDR        (0x800604 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT7_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_ADDR        (0x800704 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT8_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_ADDR        (0x800804 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT9_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_ADDR        (0x800904 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT10_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_ADDR        (0x800A04 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT11_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_ADDR        (0x800B04 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT12_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_ADDR        (0x800C04 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT13_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_ADDR        (0x800D04 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT14_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_ADDR        (0x800E04 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT15_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_ADDR        (0x800F04 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT16_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_ADDR        (0x801004 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT17_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_ADDR        (0x801104 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT18_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_ADDR        (0x801204 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT19_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_ADDR        (0x801304 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT20_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_ADDR        (0x801404 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT21_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_ADDR        (0x801504 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT22_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_ADDR        (0x801604 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT23_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_ADDR        (0x801704 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT24_CURRENT_COUNTER_WHEN_GLOBAL_REACH_PEAK_VALUE_ADDR        (0x801804 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT0_OCCUPIED_RX_PAGE_PEAK_COUNTER_ADDR        (0x800008 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT1_OCCUPIED_RX_PAGE_PEAK_COUNTER_ADDR        (0x800108 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT2_OCCUPIED_RX_PAGE_PEAK_COUNTER_ADDR        (0x800208 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT3_OCCUPIED_RX_PAGE_PEAK_COUNTER_ADDR        (0x800308 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT4_OCCUPIED_RX_PAGE_PEAK_COUNTER_ADDR        (0x800408 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT5_OCCUPIED_RX_PAGE_PEAK_COUNTER_ADDR        (0x800508 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT6_OCCUPIED_RX_PAGE_PEAK_COUNTER_ADDR        (0x800608 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT7_OCCUPIED_RX_PAGE_PEAK_COUNTER_ADDR        (0x800708 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT8_OCCUPIED_RX_PAGE_PEAK_COUNTER_ADDR        (0x800808 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT9_OCCUPIED_RX_PAGE_PEAK_COUNTER_ADDR        (0x800908 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT10_OCCUPIED_RX_PAGE_PEAK_COUNTER_ADDR        (0x800A08 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT11_OCCUPIED_RX_PAGE_PEAK_COUNTER_ADDR        (0x800B08 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT12_OCCUPIED_RX_PAGE_PEAK_COUNTER_ADDR        (0x800C08 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT13_OCCUPIED_RX_PAGE_PEAK_COUNTER_ADDR        (0x800D08 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT14_OCCUPIED_RX_PAGE_PEAK_COUNTER_ADDR        (0x800E08 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT15_OCCUPIED_RX_PAGE_PEAK_COUNTER_ADDR        (0x800F08 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT16_OCCUPIED_RX_PAGE_PEAK_COUNTER_ADDR        (0x801008 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT17_OCCUPIED_RX_PAGE_PEAK_COUNTER_ADDR        (0x801108 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT18_OCCUPIED_RX_PAGE_PEAK_COUNTER_ADDR        (0x801208 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT19_OCCUPIED_RX_PAGE_PEAK_COUNTER_ADDR        (0x801308 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT20_OCCUPIED_RX_PAGE_PEAK_COUNTER_ADDR        (0x801408 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT21_OCCUPIED_RX_PAGE_PEAK_COUNTER_ADDR        (0x801508 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT22_OCCUPIED_RX_PAGE_PEAK_COUNTER_ADDR        (0x801608 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT23_OCCUPIED_RX_PAGE_PEAK_COUNTER_ADDR        (0x801708 + FLOW_CONTROL_DIAGNOSTIC_BASE)
#define PORT24_OCCUPIED_RX_PAGE_PEAK_COUNTER_ADDR        (0x801808 + FLOW_CONTROL_DIAGNOSTIC_BASE)

/* Module: MII TEST RELATED DIAGNOSTIC */
#define MII_TEST_RELATED_DIAGNOSTIC_BASE            0xBB6E0000
#define MAC_MII_TEST_MODE_TX_CONTROL_ADDR        (0x0 + MII_TEST_RELATED_DIAGNOSTIC_BASE)
#define MAC_MII_TEST_MODE_RX_CONTROL_ADDR        (0x4 + MII_TEST_RELATED_DIAGNOSTIC_BASE)
#define MAC_TEST_MODE_GMII_RX_ADDR        (0x8 + MII_TEST_RELATED_DIAGNOSTIC_BASE)
#define MAC_TEST_MODE_GMII_TX_ADDR        (0xC + MII_TEST_RELATED_DIAGNOSTIC_BASE)

/* Module: CODE PROTECTION */
#define CODE_PROTECTION_BASE            0xBB700000

#endif    /* __RTL8316D_GENERAL_REG_H__ */
