/*
 *      Web server handler routines for wlan stuffs
 *
 *      Authors: David Hsu	<davidhsu@realtek.com.tw>
 *
 *      $Id: fmwlan.c,v 1.69 2009/09/04 07:06:23 keith_huang Exp $
 *
 */

#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#ifdef WIFI_SIMPLE_CONFIG
#include <sys/time.h>
#endif

#include "boa.h"
#include "asp_page.h"
#include "apmib.h"
#include "apform.h"
#include "utility.h"

#ifdef WLAN_EASY_CONFIG
#include "../md5.h"
#endif

// added by rock /////////////////////////////////////////
#ifdef VOIP_SUPPORT 
#include "web_voip.h"
#endif

#include "libwnc.h" //WNC-NMRXXX-JDR230-YUAN-I-CHOU-20131218, LIBWNC support

//#define SDEBUG(fmt, args...) printf("[%s %d]"fmt,__FUNCTION__,__LINE__,## args)
#define SDEBUG(fmt, args...) {}
//#define P2P_DEBUG(fmt, args...) printf("[%s %d]"fmt,__FUNCTION__,__LINE__,## args)
#define P2P_DEBUG(fmt, args...) {}

/* WNC-NMR0034-JOE-PENG-20120426-Fix cross-site scripting(XSS) */
extern void translate_control_code(char *buffer);
/* WNC-NMR0265-HENGI-CHEN-20121214-Fix bug Space character of SSID wouldn't be dipslayed */
extern void translate_control_code_and_space(char *buffer);
/* WNC-NMR0265-HENGI-CHEN-20121214-End */
/* WNC-NMR0034-JOE-PENG-20120426-end */
/* WNC-NMR0000-HENG-I-CHEN-20130722-Change Profile HEX Wep Key from binery to string */
extern void convert_bin_to_str(unsigned char *bin, int len, char *out);
/* WNC-NMR0000-HENG-I-CHEN-20130722-End */
/* WNC-NMR0000-HENG-I-CHEN-20130813: Fix loginID and password can't display special character */
extern void convert_to_hexstr (unsigned char *str, int len, char *out);
/* WNC-NMR0000-HENG-I-CHEN-20130813: End */
/* WNC-NMR0000-HENG-I-CHEN-20130816: convert string for javascript */
extern void convert_for_javascript (unsigned char *str, char *out, int size);
/* WNC-NMR0000-HENG-I-CHEN-20130816: End */

#if defined(CONFIG_DOMAIN_NAME_QUERY_SUPPORT)
extern void Stop_Domain_Query_Process(void);
extern void Reset_Domain_Query_Setting(void);
extern int Start_Domain_Query_Process;
#endif

#ifdef  CONFIG_RTL_P2P_SUPPORT
/*it indicate which interface we need to query P2P state 
   or no interface need to query(no any interface under P2P mode)
   when wifi mode change then refill it to 255*/
static int p2p_query_which_interface=255;
#endif

#ifdef WLAN_EASY_CONFIG
#define DO_CONFIG_WAIT_TIME	60
#define CONFIG_SUCCESS		0
#define AUTOCONF_PID_FILENAME	("/var/run/autoconf.pid")

static int wait_config = CONFIG_SUCCESS;
#endif

static SS_STATUS_Tp pStatus=NULL;

#ifdef CONFIG_RTK_MESH
        #define _FILE_MESH_ASSOC "mesh_assoc_mpinfo"
        #define _FILE_MESH_ROUTE "mesh_pathsel_routetable"
		#define _FILE_MESH_ROOT  "mesh_root_info"
		#define _FILE_MESH_PROXY "mesh_proxy_table"
		#define _FILE_MESH_PORTAL "mesh_portal_table"		
		#define _FILE_MESHSTATS  "mesh_stats"
#endif // CONFIG_RTK_MESH

#ifdef WIFI_SIMPLE_CONFIG
enum {	CALLED_FROM_WLANHANDLER=1, CALLED_FROM_WEPHANDLER=2, CALLED_FROM_WPAHANDLER=3, CALLED_FROM_ADVANCEHANDLER=4};
struct wps_config_info_struct {
	int caller_id;
	int wlan_mode;
	int auth;
	int shared_type;
	int wep_enc;
	int wpa_enc;
	int wpa2_enc;
	unsigned char ssid[MAX_SSID_LEN];
	int KeyId;
	unsigned char wep64Key1[WEP64_KEY_LEN];
	unsigned char wep64Key2[WEP64_KEY_LEN];
	unsigned char wep64Key3[WEP64_KEY_LEN];
	unsigned char wep64Key4[WEP64_KEY_LEN];
	unsigned char wep128Key1[WEP128_KEY_LEN];
	unsigned char wep128Key2[WEP128_KEY_LEN];
	unsigned char wep128Key3[WEP128_KEY_LEN];
	unsigned char wep128Key4[WEP128_KEY_LEN];
	unsigned char wpaPSK[MAX_PSK_LEN+1];
};
static struct wps_config_info_struct wps_config_info;
static void update_wps_configured(int reset_flag);
#endif

/* WNC-NMR0000-JOE-PENG-20140813-Fix bug that site survey page does not recover old setting value if Wi-Fi vxd inerface connection fails and user chooses recovering setting-start */
/* This structure is used to record old settings of DUT before site survey page try repeater connection. */
/* Once repeater connection fail, we could use this structure to recover settings of DUT */
struct repeater_config_info_struct {
	int vxd_encrypt[NUM_WLAN_INTERFACE];
	int vxd_wpa_cipher_suite[NUM_WLAN_INTERFACE];
	int vxd_wsc_auth[NUM_WLAN_INTERFACE];
	int vxd_wsc_priority[NUM_WLAN_INTERFACE];
	int vap0_wlan_disabled[NUM_WLAN_INTERFACE];
	int multi_stage_connection[NUM_WLAN_INTERFACE];
	int rfpower_scale[NUM_WLAN_INTERFACE];
	unsigned char vxd_ssid[NUM_WLAN_INTERFACE][MAX_SSID_LEN];
	unsigned char vxd_wpa_psk[NUM_WLAN_INTERFACE][MAX_PSK_LEN+1];
};
static struct repeater_config_info_struct old_repeater_config_info, new_repeater_config_info;

/* This API is used to save repeater config setting */
int save_repeater_config_setting(struct repeater_config_info_struct *repeater_config_info_t) {
	int orig_wlan_idx=0;
	int orig_vwlan_idx=0;
	int count=0;

	/* Clear old setting */
	memset(repeater_config_info_t, 0, sizeof(struct repeater_config_info_struct));

	/* Save old wlan_idx and vwlan_idx */
	orig_wlan_idx=wlan_idx;
	orig_vwlan_idx=vwlan_idx;

	/* Save vxd setting of each radio */
	vwlan_idx=NUM_VWLAN_INTERFACE;
	for(count=0;count<NUM_WLAN_INTERFACE;count++) {
		wlan_idx = count;

		apmib_get(MIB_WLAN_ENCRYPT, (void *)&(repeater_config_info_t->vxd_encrypt[count]));
		apmib_get(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&(repeater_config_info_t->vxd_wpa_cipher_suite[count]));
		apmib_get(MIB_WLAN_WSC_AUTH, (void *)&(repeater_config_info_t->vxd_wsc_auth[count]));
		apmib_get(MIB_WLAN_WSC_PRIORITY, (void *)&(repeater_config_info_t->vxd_wsc_priority[count]));
		apmib_get(MIB_WLAN_MULTI_STAGE_CONNECTION, (void *)&(repeater_config_info_t->multi_stage_connection[count]));
		apmib_get(MIB_WLAN_RFPOWER_SCALE, (void *)&(repeater_config_info_t->rfpower_scale[count]));
		apmib_get(MIB_WLAN_SSID, (void *)repeater_config_info_t->vxd_ssid[count]); 
		apmib_get(MIB_WLAN_WPA_PSK, (void *)repeater_config_info_t->vxd_wpa_psk[count]);
	}

	/* Save wlanX-va0 setting of each radio */
	vwlan_idx=1;
	for(count=0;count<NUM_WLAN_INTERFACE;count++) {
		wlan_idx = count;

		apmib_get(MIB_WLAN_WLAN_DISABLED, (void *)&(repeater_config_info_t->vap0_wlan_disabled[count]));
	}

	/* Recover old wlan_idx and vwlan_idx */
	wlan_idx=orig_wlan_idx;
	vwlan_idx=orig_vwlan_idx;

	return 0;
}

/* WNC-NMR773-[Linear]-Libera-20141002- Specified SSID setting issue-not reflected at other setting-start */
/* WNC-NMR786-[Linear]-Libera-20141008-fixed the function: Can be set value after connection failed - modification*/
/* This API is used to roll back profile config setting */
int robk_profile_config_setting(struct repeater_config_info_struct *repeater_config_info_t, int wlan_if) {
	int orig_wlan_idx=0;
	int orig_vwlan_idx=0;
	int count1=0, count2=0;

	/* Save old wlan_idx and vwlan_idx */
	orig_wlan_idx=wlan_idx;
	orig_vwlan_idx=vwlan_idx;

	//printf("### wlan%d roll back!\n",wlan_if);
	/* Set setting of each radio */
	//for(count1=0;count1<NUM_WLAN_INTERFACE;count1++) {
	count1 = wlan_if;
		for(count2=0;count2<NUM_VWLAN_INTERFACE+1;count2++) {
			wlan_idx = count1;
			vwlan_idx = count2;

			/* Set setting to wlanX-va0 
			if (vwlan_idx==1) {
				apmib_set(MIB_WLAN_WLAN_DISABLED, (void *)&(repeater_config_info_t->vap0_wlan_disabled[count1]));
			}*/

			/* Set setting to wlanX-vxd */
			if (vwlan_idx==NUM_VWLAN_INTERFACE) {
			/*	apmib_set(MIB_WLAN_ENCRYPT, (void *)&(repeater_config_info_t->vxd_encrypt[count1]));
				apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&(repeater_config_info_t->vxd_wpa_cipher_suite[count1]));
				apmib_set(MIB_WLAN_WSC_AUTH, (void *)&(repeater_config_info_t->vxd_wsc_auth[count1]));
				apmib_set(MIB_WLAN_WSC_PRIORITY, (void *)&(repeater_config_info_t->vxd_wsc_priority[count1])); */
				apmib_set(MIB_WLAN_SSID, (void *)repeater_config_info_t->vxd_ssid[count1]); 
				apmib_set(MIB_WLAN_WSC_SSID, (void *)repeater_config_info_t->vxd_ssid[count1]); 
			/*	apmib_set(MIB_WLAN_WPA_PSK, (void *)repeater_config_info_t->vxd_wpa_psk[count1]);
				apmib_set(MIB_WLAN_WSC_PSK, (void *)repeater_config_info_t->vxd_wpa_psk[count1]);*/
			}

		}
	//}

	/* Recover old wlan_idx and vwlan_idx */
	wlan_idx=orig_wlan_idx;
	vwlan_idx=orig_vwlan_idx;

	/* Update setting to flash */
	apmib_update_web(CURRENT_SETTING);

	return 0;
}
/* WNC-NMR773-[Linear]-Libera-20141002- Specified SSID setting issue-not reflected at other setting-end */

/* This API is used to set repeater config setting */
int set_repeater_config_setting(struct repeater_config_info_struct *repeater_config_info_t) {
	int orig_wlan_idx=0;
	int orig_vwlan_idx=0;
	int count1=0, count2=0;

	/* Save old wlan_idx and vwlan_idx */
	orig_wlan_idx=wlan_idx;
	orig_vwlan_idx=vwlan_idx;

	/* Set setting of each radio */
	for(count1=0;count1<NUM_WLAN_INTERFACE;count1++) {
		for(count2=0;count2<NUM_VWLAN_INTERFACE+1;count2++) {
			wlan_idx = count1;
			vwlan_idx = count2;

			/* Set setting to wlanX-va0 */
			if (vwlan_idx==1) {
				apmib_set(MIB_WLAN_WLAN_DISABLED, (void *)&(repeater_config_info_t->vap0_wlan_disabled[count1]));
			}

			/* Set setting to wlanX-vxd */
			if (vwlan_idx==NUM_VWLAN_INTERFACE) {
				apmib_set(MIB_WLAN_ENCRYPT, (void *)&(repeater_config_info_t->vxd_encrypt[count1]));
				apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&(repeater_config_info_t->vxd_wpa_cipher_suite[count1]));
				apmib_set(MIB_WLAN_WSC_AUTH, (void *)&(repeater_config_info_t->vxd_wsc_auth[count1]));
				apmib_set(MIB_WLAN_WSC_PRIORITY, (void *)&(repeater_config_info_t->vxd_wsc_priority[count1]));
				apmib_set(MIB_WLAN_SSID, (void *)repeater_config_info_t->vxd_ssid[count1]); 
				apmib_set(MIB_WLAN_WSC_SSID, (void *)repeater_config_info_t->vxd_ssid[count1]); 
				apmib_set(MIB_WLAN_WPA_PSK, (void *)repeater_config_info_t->vxd_wpa_psk[count1]);
				apmib_set(MIB_WLAN_WSC_PSK, (void *)repeater_config_info_t->vxd_wpa_psk[count1]);
			}

			/* Set setting to wlanX, wlanX-va0, wlanX-va1, wlanX-vxd */
			if ((vwlan_idx==0) || (vwlan_idx==1) || (vwlan_idx==2) ||(vwlan_idx==NUM_VWLAN_INTERFACE)) {
				apmib_set(MIB_WLAN_MULTI_STAGE_CONNECTION, (void *)&(repeater_config_info_t->multi_stage_connection[count1]));
				apmib_set(MIB_WLAN_RFPOWER_SCALE, (void *)&(repeater_config_info_t->rfpower_scale[count1]));
			}
		}
	}

	/* Recover old wlan_idx and vwlan_idx */
	wlan_idx=orig_wlan_idx;
	vwlan_idx=orig_vwlan_idx;

	/* Update setting to flash */
	apmib_update_web(CURRENT_SETTING);

	return 0;
}
/* WNC-NMR0000-JOE-PENG-20140813-Fix bug that site survey page does not recover old setting value if Wi-Fi vxd inerface connection fails and user chooses recovering setting-end */

#if defined(CONFIG_RTL_92D_SUPPORT)
static int _isBandModeBoth()
{
	int val = 0; //WNC-NMR0000-Rita-20130305-Error_375-fix warnings of cppcheck (uninitialized value).
	apmib_get(MIB_WLAN_BAND2G5G_SELECT, (void *)&val);
	if(val == BANDMODEBOTH)
		return 1;
	else
		return 0;
}
#endif

static void _Start_Wlan_Applications(void)
{

	#if defined (CONFIG_RTL_92D_SUPPORT)
	if(_isBandModeBoth())
		system("sysconf wlanapp start wlan0 wlan1 br0");
	else
		system("sysconf wlanapp start wlan0 br0");
	#else
	system("sysconf wlanapp start wlan0 br0");
	#endif
	sleep(1);
	/*sysconf upnpd 1(isgateway) 1(opmode is bridge)*/
	system("sysconf upnpd 1 1");
	sleep(1);
}


//changes in following table should be synced to MCS_DATA_RATEStr[] in 8190n_proc.c
WLAN_RATE_T rate_11n_table_20M_LONG[]={
	{MCS0, 	"6.5"},
	{MCS1, 	"13"},
	{MCS2, 	"19.5"},
	{MCS3, 	"26"},
	{MCS4, 	"39"},
	{MCS5, 	"52"},
	{MCS6, 	"58.5"},
	{MCS7, 	"65"},
	{MCS8, 	"13"},
	{MCS9, 	"26"},
	{MCS10, 	"39"},
	{MCS11, 	"52"},
	{MCS12, 	"78"},
	{MCS13, 	"104"},
	{MCS14, 	"117"},
	{MCS15, 	"130"},
	{0}
};
WLAN_RATE_T rate_11n_table_20M_SHORT[]={
	{MCS0, 	"7.2"},
	{MCS1, 	"14.4"},
	{MCS2, 	"21.7"},
	{MCS3, 	"28.9"},
	{MCS4, 	"43.3"},
	{MCS5, 	"57.8"},
	{MCS6, 	"65"},
	{MCS7, 	"72.2"},
	{MCS8, 	"14.4"},
	{MCS9, 	"28.9"},
	{MCS10, 	"43.3"},
	{MCS11, 	"57.8"},
	{MCS12, 	"86.7"},
	{MCS13, 	"115.6"},
	{MCS14, 	"130"},
	{MCS15, 	"144.5"},
	{0}
};
WLAN_RATE_T rate_11n_table_40M_LONG[]={
	{MCS0, 	"13.5"},
	{MCS1, 	"27"},
	{MCS2, 	"40.5"},
	{MCS3, 	"54"},
	{MCS4, 	"81"},
	{MCS5, 	"108"},
	{MCS6, 	"121.5"},
	{MCS7, 	"135"},
	{MCS8, 	"27"},
	{MCS9, 	"54"},
	{MCS10, 	"81"},
	{MCS11, 	"108"},
	{MCS12, 	"162"},
	{MCS13, 	"216"},
	{MCS14, 	"243"},
	{MCS15, 	"270"},
	{0}
};
WLAN_RATE_T rate_11n_table_40M_SHORT[]={
	{MCS0, 	"15"},
	{MCS1, 	"30"},
	{MCS2, 	"45"},
	{MCS3, 	"60"},
	{MCS4, 	"90"},
	{MCS5, 	"120"},
	{MCS6, 	"135"},
	{MCS7, 	"150"},
	{MCS8, 	"30"},
	{MCS9, 	"60"},
	{MCS10, 	"90"},
	{MCS11, 	"120"},
	{MCS12, 	"180"},
	{MCS13, 	"240"},
	{MCS14, 	"270"},
	{MCS15, 	"300"},
	{0}
};

WLAN_RATE_T tx_fixed_rate[]={
	{1, "1"},
	{(1<<1), 	"2"},
	{(1<<2), 	"5.5"},
	{(1<<3), 	"11"},
	{(1<<4), 	"6"},
	{(1<<5), 	"9"},
	{(1<<6), 	"12"},
	{(1<<7), 	"18"},
	{(1<<8), 	"24"},
	{(1<<9), 	"36"},
	{(1<<10), 	"48"},
	{(1<<11), 	"54"},
	{(1<<12), 	"MCS0"},
	{(1<<13), 	"MCS1"},
	{(1<<14), 	"MCS2"},
	{(1<<15), 	"MCS3"},
	{(1<<16), 	"MCS4"},
	{(1<<17), 	"MCS5"},
	{(1<<18), 	"MCS6"},
	{(1<<19), 	"MCS7"},
	{(1<<20), 	"MCS8"},
	{(1<<21), 	"MCS9"},
	{(1<<22), 	"MCS10"},
	{(1<<23), 	"MCS11"},
	{(1<<24), 	"MCS12"},
	{(1<<25), 	"MCS13"},
	{(1<<26), 	"MCS14"},
	{(1<<27), 	"MCS15"},
	{((1<<31)+0), 	"NSS1-MCS0"},
	{((1<<31)+1), 	"NSS1-MCS1"},
	{((1<<31)+2), 	"NSS1-MCS2"},
	{((1<<31)+3), 	"NSS1-MCS3"},
	{((1<<31)+4), 	"NSS1-MCS4"},
	{((1<<31)+5), 	"NSS1-MCS5"},
	{((1<<31)+6), 	"NSS1-MCS6"},
	{((1<<31)+7), 	"NSS1-MCS7"},
	{((1<<31)+8), 	"NSS1-MCS8"},
	{((1<<31)+9), 	"NSS1-MCS9"},
	{((1<<31)+10), 	"NSS2-MCS0"},
	{((1<<31)+11), 	"NSS2-MCS1"},
	{((1<<31)+12), 	"NSS2-MCS2"},
	{((1<<31)+13), 	"NSS2-MCS3"},
	{((1<<31)+14), 	"NSS2-MCS4"},
	{((1<<31)+15), 	"NSS2-MCS5"},
	{((1<<31)+16), 	"NSS2-MCS6"},
	{((1<<31)+17), 	"NSS2-MCS7"},
	{((1<<31)+18), 	"NSS2-MCS8"},
	{((1<<31)+19), 	"NSS2-MCS9"},
	{0}
};
//changes in following table should be synced to VHT_MCS_DATA_RATE[] in 8812_vht_gen.c
// 				20/40/80,	ShortGI,	MCS Rate 
const unsigned short VHT_MCS_DATA_RATE[3][2][30] = 
	{	{	{13, 26, 39, 52, 78, 104, 117, 130, 156, 156,
			 26, 52, 78, 104, 156, 208, 234, 260, 312, 312, 
			 39, 78, 117, 156, 234, 312, 351, 390, 468, 520},					// Long GI, 20MHz
			 
			{14, 29, 43, 58, 87, 116, 130, 144, 173, 173,
			 29, 58, 87, 116, 173, 231, 260, 289, 347, 347,
			 43, 86, 130, 173, 260, 347, 390, 433, 520, 578}			},		// Short GI, 20MHz
			 
		{	{27, 54, 81, 108, 162, 216, 243, 270, 324, 360, 
			 54, 108, 162, 216, 324, 432, 486, 540, 648, 720, 
			 81, 162, 243, 342, 486, 648, 729, 810, 972, 1080}, 				// Long GI, 40MHz
			 
			{30, 60, 90, 120, 180, 240, 270, 300,360, 400, 
			 60, 120, 180, 240, 360, 480, 540, 600, 720, 800,
			 90, 180, 270, 360, 540, 720, 810, 900, 1080, 1200}			},		// Short GI, 40MHz
			 
		{	{59, 117,  176, 234, 351, 468, 527, 585, 702, 780,
			 117, 234, 351, 468, 702, 936, 1053, 1170, 1404, 1560, 
			 176, 351, 527, 702, 1053, 1408, 1408, 1745, 2106, 2340}, 			// Long GI, 80MHz
			 
			{65, 130, 195, 260, 390, 520, 585, 650, 780, 867, 
			 130, 260, 390, 520, 780, 1040, 1170, 1300, 1560, 1733, 
			 195, 390, 585, 780, 1170, 1560, 1560, 1950, 2340, 2600}	}		// Short GI, 80MHz
			 
	};


/////////////////////////////////////////////////////////////////////////////
#ifndef NO_ACTION
//Patch: kill some daemons to free some RAM in order to call "init.sh gw al"l more quickly
//which need more tests
void killSomeDaemon(void)
{
	system("killall -9 sleep 2> /dev/null");
       system("killall -9 routed 2> /dev/null");
//	system("killall -9 pppoe 2> /dev/null");
//	system("killall -9 pppd 2> /dev/null");
//	system("killall -9 pptp 2> /dev/null");
	system("killall -9 dnrd 2> /dev/null");
	system("killall -9 ntpclient 2> /dev/null");
//	system("killall -9 miniigd 2> /dev/null");	//comment for miniigd iptables rule recovery
	system("killall -9 lld2d 2> /dev/null");
//	system("killall -9 l2tpd 2> /dev/null");	
//	system("killall -9 udhcpc 2> /dev/null");	
//	system("killall -9 udhcpd 2> /dev/null");	
	system("killall -9 reload 2> /dev/null");		
	system("killall -9 iapp 2> /dev/null");	
	system("killall -9 wscd 2> /dev/null");
	system("killall -9 mini_upnpd 2> /dev/null");
	system("killall -9 iwcontrol 2> /dev/null");
	system("killall -9 auth 2> /dev/null");
	system("killall -9 disc_server 2> /dev/null");
	system("killall -9 igmpproxy 2> /dev/null");
	system("echo 1,1 > /proc/br_mCastFastFwd");
	system("killall -9 syslogd 2> /dev/null");
	system("killall -9 klogd 2> /dev/null");
	
	system("killall -9 ppp_inet 2> /dev/null");
#ifdef WLAN_HS2_CONFIG	
	system("killall -9 hs2 2> /dev/null");	
#endif
#ifdef CONFIG_IPV6
	system("killall -9 dhcp6c 2> /dev/null");
	system("killall -9 dhcp6s 2> /dev/null");
	system("killall -9 radvd 2> /dev/null");
	system("killall -9 ecmh 2> /dev/null");
	//kill mldproxy
	system("killall -9 mldproxy 2> /dev/null");
#endif
#ifdef CONFIG_SNMP
	system("killall -9 snmpd 2> /dev/null");
	system("rm -f /var/run/snmpd.pid");
#endif
}
#ifdef RTK_REINIT_SUPPORT
void run_init_script(char *arg)
{
	//printf("%s:%d run nothing!\n",__FUNCTION__,__LINE__);
}
#else
void run_init_script(char *arg)
{
#ifdef NO_ACTION
	// do nothing
#else
	int pid=0;
	int i;
	char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};
	
#ifdef REBOOT_CHECK
	if(run_init_script_flag == 1){
#endif

	/* WNC-MR1541-JOE-PENG-20120412-Implement PPPoE part of WAN interface status */
	/* Need to clean file "pppAuthError1" when system execute reinit. */
	unlink("/etc/ppp/pppAuthError1");
	/* WNC-MR1541-JOE-PENG-20120412-end */

#ifdef RTK_USB3G
	system("killall -9 mnet 2> /dev/null");
	system("killall -9 hub-ctrl 2> /dev/null");
	system("killall -9 usb_modeswitch 2> /dev/null");
    system("killall -9 ppp_inet 2> /dev/null");
    system("killall -9 pppd 2> /dev/null");
    system("rm /etc/ppp/connectfile >/dev/null 2>&1");
#endif /* #ifdef RTK_USB3G */

#if defined(CONFIG_DOMAIN_NAME_QUERY_SUPPORT)
	Stop_Domain_Query_Process();
	Reset_Domain_Query_Setting();
#endif

#if defined(CONFIG_RTL_ULINKER)
{
	extern int kill_ppp(void);
	int wan_mode, op_mode;

	apmib_get(MIB_OP_MODE,(void *)&op_mode);
	apmib_get(MIB_WAN_DHCP,(void *)&wan_mode);
	if(wan_mode == PPPOE && op_mode == GATEWAY_MODE)
		kill_ppp();
	
	stop_dhcpc();
	stop_dhcpd();
	clean_auto_dhcp_flag();
	disable_bridge_dhcp_filter();
}
#endif

	snprintf(tmpBuf, MAX_MSG_BUFFER_SIZE, "%s/%s.pid", _DHCPD_PID_PATH, _DHCPD_PROG_NAME);
	pid = getPid(tmpBuf);
	if ( pid > 0)
		kill(pid, SIGUSR1);
		
	usleep(1000);
	
	if ( pid > 0){
		system("killall -9 udhcpd 2> /dev/null");
		system("rm -f /var/run/udhcpd.pid 2> /dev/null");
	}

	//Patch: kill some daemons to free some RAM in order to call "init.sh gw all" more quickly
	//which need more tests especially for 8196c 2m/16m
	killSomeDaemon();
	
	system("killsh.sh");	// kill all running script	
#ifdef CONFIG_IPV6
	system("ip tunnel del tun 2> /dev/null");
#ifdef CONFIG_DSLITE_SUPPORT
	system("ip -6 tunnel del ds-lite 2> /dev/null"); //delete ds-lite tunnel
	system("rm -f /var/ds-lite.script 2> /dev/null");
#endif
#ifdef CONFIG_SIXRD_SUPPORT
	system("ip tunnel del tun6rd 2> /dev/null");
#endif
#endif

#ifdef REBOOT_CHECK
	run_init_script_flag = 0;
	needReboot = 0;
#endif
// added by rock /////////////////////////////////////////
#ifdef VOIP_SUPPORT
	web_restart_solar();
#endif

	pid = fork();
/*	
       	if (pid)
               	waitpid(pid, NULL, 0);
   	else 
*/ 
	if (pid == 0) {
#ifdef HOME_GATEWAY
		sprintf(tmpBuf, "%s gw %s", _CONFIG_SCRIPT_PROG, arg);
#elif defined(VOIP_SUPPORT) && defined(ATA867x)
		sprintf(tmpBuf, "%s ATA867x %s", _CONFIG_SCRIPT_PROG, arg);
#else
		sprintf(tmpBuf, "%s ap %s", _CONFIG_SCRIPT_PROG, arg);
#endif
		for(i=3; i<sysconf(_SC_OPEN_MAX); i++)
                	close(i);
		sleep(1);
		system(tmpBuf);
		exit(1);
	}
#ifdef REBOOT_CHECK
}
	else
	{
	}
#endif
#endif
}
#endif
#endif //#ifndef NO_ACTION

/////////////////////////////////////////////////////////////////////////////
static inline int isAllStar(char *data)
{
	int i;
	for (i=0; i<strlen(data); i++) {
		if (data[i] != '*')
			return 0;
	}
	return 1;
}
//////////////////////
#ifndef HOME_GATEWAY
void formSetTime(request *wp, char *path, char *query)
{
	char *submitUrl,*strVal;
	char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};
	int time_value=0;
	int cur_year=0;

	submitUrl = req_get_cstream_var(wp, ("submit-url"), "");   
	strVal = req_get_cstream_var(wp, ("save"), "");   
#if defined(APPLY_CHANGE_DIRECT_SUPPORT)
	if(strVal[0]==0){
		strVal = req_get_cstream_var(wp, ("save_apply"), "");
	}
#endif
	if(strVal[0]){		
		struct tm tm_time;
		time_t tm;
		memcpy(&tm_time, localtime(&tm), sizeof(tm_time));
		tm_time.tm_sec = 0;
		tm_time.tm_min = 0;
		tm_time.tm_hour = 0;
		tm_time.tm_isdst = -1;  /* Be sure to recheck dst. */
		strVal = req_get_cstream_var(wp, ("year"), "");	
		cur_year= atoi(strVal);
		tm_time.tm_year = atoi(strVal) - 1900;
		strVal = req_get_cstream_var(wp, ("month"), "");	
		tm_time.tm_mon = atoi(strVal)-1;
		strVal = req_get_cstream_var(wp, ("day"), "");	
		tm_time.tm_mday = atoi(strVal);
		strVal = req_get_cstream_var(wp, ("hour"), "");	
		tm_time.tm_hour = atoi(strVal);
		strVal = req_get_cstream_var(wp, ("minute"), "");	
		tm_time.tm_min = atoi(strVal);
		strVal = req_get_cstream_var(wp, ("second"), "");	
		tm_time.tm_sec = atoi(strVal);
		tm = mktime(&tm_time);
		if(tm < 0){
			sprintf(tmpBuf, "set Time Error\n");
			goto setErr_end;
		}
		if(stime(&tm) < 0){
			sprintf(tmpBuf, "set Time Error\n");
			goto setErr_end;
		}
		
		apmib_set( MIB_SYSTIME_YEAR, (void *)&cur_year);
		time_value = tm_time.tm_mon;
		apmib_set( MIB_SYSTIME_MON, (void *)&time_value);
		time_value = tm_time.tm_mday;
		apmib_set( MIB_SYSTIME_DAY, (void *)&time_value);
		time_value = tm_time.tm_hour;
		apmib_set( MIB_SYSTIME_HOUR, (void *)&time_value);
		time_value = tm_time.tm_min;
		apmib_set( MIB_SYSTIME_MIN, (void *)&time_value);
		time_value = tm_time.tm_sec;
		apmib_set( MIB_SYSTIME_SEC, (void *)&time_value);
	}
	
	apmib_update_web(CURRENT_SETTING);
	OK_MSG(submitUrl);
	return;
setErr_end:
	ERR_MSG(tmpBuf);	
}

#endif

#if defined(NEW_SCHEDULE_SUPPORT)
int wlSchList(request *wp, int argc, char **argv)
{
	SCHEDULE_T entry;
	char *strToken;
	int cmpResult=0;
	int  index=0;
	
	int orig_wlan_idx=0;
	int orig_vwlan_idx=0;

	cmpResult= strncmp(argv[0], "wlSchList_", strlen("wlSchList_"));
	strToken=strstr(argv[0], "_");
	index= atoi(strToken+1);

	index++;

	/* Save old wlan_idx and vwlan_idx */
	orig_wlan_idx=wlan_idx;
	orig_vwlan_idx=vwlan_idx;

	wlan_idx = 0;
	vwlan_idx = 0;

	if(index <= MAX_SCHEDULE_NUM)
	{
		*((char *)&entry) = (char)index;
		if ( !apmib_get(MIB_WLAN_SCHEDULE_TBL, (void *)&entry))
		{
			fprintf(stderr,"Get schedule entry fail\n");
			wlan_idx = orig_wlan_idx;
			vwlan_idx = orig_vwlan_idx;
			return -1;
		}												
		
		
		/* eco/day/fTime/tTime/week */
		req_format_write(wp, ("%d|%d|%d|%d"), entry.eco, entry.day, entry.fTime, entry.tTime);
	}
	else
	{
		req_format_write(wp, ("0|0|0|0") );
	}

	wlan_idx = orig_wlan_idx;
	vwlan_idx = orig_vwlan_idx;

	return 0;
}
#endif //#if defined(NEW_SCHEDULE_SUPPORT)

void formSchedule(request *wp, char *path, char *query)
{
	char	tmpBuf[MAX_MSG_BUFFER_SIZE];
	char *strHours, *strEnabled, *strWeekdays, *strStime, *strEtime;
	SCHEDULE_T entry;
	int entryNum=0;
	char *submitUrl;
	int isEnabled=0;
	memset(&entry,0,sizeof(SCHEDULE_T)); //WNC-NMR0000-Rita-20130305-Error_401-fix warnings of cppcheck (uninitialized value).
	submitUrl = req_get_cstream_var(wp, ("webpage"), "");   // hidden page
	
	
	if ( !apmib_set(MIB_WLAN_SCHEDULE_DELALL, (void *)&entry)) {
			strcpy(tmpBuf, ("Delete table entry error!"));
			goto setErr_schedule;
	}
	memset(&entry, '\0', sizeof(entry));
	
	strEnabled = req_get_cstream_var(wp, ("enabled_sch"), "");
	if(strcmp(strEnabled,"true") == 0) // the entry is enabled
	{
			entry.eco |= ECO_LEDDIM_MASK;
			isEnabled = 1;
	}else{
			entry.eco &= ~ECO_LEDDIM_MASK;
			isEnabled = 0;
	}
	apmib_set(MIB_WLAN_SCHEDULE_ENABLED,(void *)&isEnabled);
	snprintf((char *)entry.text, sizeof(entry.text), "%s", "wlanSchedule");	
	
	strWeekdays = req_get_cstream_var(wp, ("weekdays"), "");
	entry.day = atoi(strWeekdays);

	

	if(strcmp(strWeekdays, "127") ==0)
	{
		entry.eco |= ECO_EVERYDAY_MASK;
	}else
		entry.eco &= ~ECO_EVERYDAY_MASK;
		  
	strHours = req_get_cstream_var(wp, ("all_day"), "");	

	if(strcmp(strHours,"on") == 0) // the entry is enabled 24 hours
	{
		entry.eco |= ECO_24HOURS_MASK;
		
	}else
		entry.eco &= ~ECO_24HOURS_MASK;

	strStime = req_get_cstream_var(wp, ("start_time"), "");
	if(strStime[0])
		entry.fTime = atoi(strStime);

	strEtime = req_get_cstream_var(wp, ("end_time"), "");
	if(strEtime[0])
		entry.tTime = atoi(strEtime);
	
	if(entry.eco & ECO_24HOURS_MASK){
			entry.fTime = 0;
			entry.tTime = 1440;
	}
	
	if ( !apmib_get(MIB_WLAN_SCHEDULE_TBL_NUM, (void *)&entryNum)) 
	{
			strcpy(tmpBuf, ("\"Get entry number error!\""));
			goto setErr_schedule;
	}
	if ( !apmib_set(MIB_WLAN_SCHEDULE_ADD,(void *)&entry)) {
			strcpy(tmpBuf, ("Add table entry error!"));
			goto setErr_schedule;
	}
	
	
	
	
	apmib_update_web(CURRENT_SETTING);
#ifndef NO_ACTION
	run_init_script("bridge");
#endif

OK_MSG(submitUrl);
	return;

setErr_schedule:
	ERR_MSG(tmpBuf);
	
}

#if defined(NEW_SCHEDULE_SUPPORT)
void formNewSchedule(request *wp, char *path, char *query)
{
	SCHEDULE_T entry;
	char *submitUrl,*strTmp;
	int	i, j, wlsch_onoff;
	int wlsch_enabled_rules = 0;
	char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};
	
//displayPostDate(wp->post_data);	
	
/* WNC-NMR0313-Heng-I-Chen-20130308-Backup wlan index value */
	apmib_save_wlanIdx();
/* WNC-NMR0313-Heng-I-Chen-20130308-End */
	strTmp= req_get_cstream_var(wp, ("wlsch_onoff"), "");
	if(strTmp[0])
	{
		wlsch_onoff = atoi(strTmp);

/* WNC-NMR0313-Heng-I-Chen-20130308-Apply Schedule to all wlan interface */
		for(j=0; j<NUM_WLAN_INTERFACE ; j++)
		{
			char *wlanif[8];
			snprintf(wlanif, sizeof(wlanif), "wlan%d", j);
			
			SetWlan_idx(wlanif);

			if (!apmib_set(MIB_WLAN_SCHEDULE_ENABLED, (void *)&wlsch_onoff))
			{
				strncpy(tmpBuf, ("set  MIB_WLAN_SCHEDULE_ENABLED error!"), sizeof(tmpBuf));
				goto setErr_schedule;
			}
		}
/* WNC-NMR0313-Heng-I-Chen-20130308-End */
	}
    memset(&entry,0,sizeof(SCHEDULE_T)); //WNC-NMR0000-Rita-20130305-Error_454-fix warnings of cppcheck (uninitialized value).
/* WNC-NMR0313-Heng-I-Chen-20130308-Apply Schedule to all wlan interface */
	for(j=0; j<NUM_WLAN_INTERFACE ; j++)
	{
		char *wlanif[8];
		snprintf(wlanif, sizeof(wlanif), "wlan%d", j);
		
		SetWlan_idx(wlanif);

		if ( !apmib_set(MIB_WLAN_SCHEDULE_DELALL, (void *)&entry)) {
			strncpy(tmpBuf, ("MIB_WLAN_SCHEDULE_DELALL error!"), sizeof(tmpBuf));
			goto setErr_schedule;
		}
	}
/* WNC-NMR0313-Heng-I-Chen-20130308-End */
	
	for(i=1; i<=MAX_SCHEDULE_NUM ; i++)
	{
		int index;
		memset(&entry, '\0', sizeof(entry));
		
		*((char *)&entry) = (char)i;
		apmib_get(MIB_WLAN_SCHEDULE_TBL, (void *)&entry);			

		index = i-1;
			
		memset(tmpBuf,0x00, sizeof(tmpBuf));			
		snprintf(tmpBuf, sizeof(tmpBuf),"wlsch_enable_%d",index);
		strTmp = req_get_cstream_var(wp, tmpBuf, "");
		if(strTmp[0])
		{
			entry.eco = atoi(strTmp);
			if (entry.eco)
				wlsch_enabled_rules++;
		}
		
		memset(tmpBuf,0x00, sizeof(tmpBuf));			
		snprintf(tmpBuf, sizeof(tmpBuf),"wlsch_day_%d",index);
		strTmp = req_get_cstream_var(wp, tmpBuf, "");
		if(strTmp[0])
		{
			entry.day = atoi(strTmp);
		}
		
		memset(tmpBuf,0x00, sizeof(tmpBuf));			
		snprintf(tmpBuf, sizeof(tmpBuf),"wlsch_from_%d",index);
		strTmp = req_get_cstream_var(wp, tmpBuf, "");
		if (strTmp[0]) {
			entry.fTime = atoi(strTmp);
		}
		
		memset(tmpBuf,0x00, sizeof(tmpBuf));			
		snprintf(tmpBuf, sizeof(tmpBuf),"wlsch_to_%d",index);
		strTmp = req_get_cstream_var(wp, tmpBuf, "");
		if(strTmp[0])
		{
			entry.tTime = atoi(strTmp);
		}

/* WNC-NMR0313-Heng-I-Chen-20130308-Apply Schedule to all wlan interface */
		for(j=0; j<NUM_WLAN_INTERFACE ; j++)
		{
			char *wlanif[8];
			snprintf(wlanif, sizeof(wlanif), "wlan%d", j);
			
			SetWlan_idx(wlanif);

			if ( apmib_set(MIB_WLAN_SCHEDULE_ADD, (void *)&entry) == 0)
			{
				strncpy(tmpBuf, ("MIB_WLAN_SCHEDULE_ADD error!"), sizeof(tmpBuf));
				goto setErr_schedule;
			}
		}
/* WNC-NMR0313-Heng-I-Chen-20130308-End */
	}
	
#ifdef CONFIG_APP_ACCESSTIMER
// WNC-NMR0000-JDR230-HENG-I-CHEN-2014-01-05: Implement Access Timer feature #BEGIN
	if (wlsch_enabled_rules > 0) {
		int enabled = 0;
		apmib_set(MIB_ACCESS_TIMER_ENABLED, (void *)&enabled);
	}
// WNC-NMR0000-JDR230-HENG-I-CHEN-2014-01-05: Implement Access Timer feature #END
#endif	//#ifdef CONFIG_APP_ACCESSTIMER
	

	submitUrl = req_get_cstream_var(wp, ("submit-url"), "");   // hidden page
/* WNC-NMR0313-Heng-I-Chen-20130308-Restore wlan index value */
	apmib_recov_wlanIdx();
/* WNC-NMR0313-Heng-I-Chen-20130308-End */

	apmib_update_web(CURRENT_SETTING);
#ifndef NO_ACTION
	run_init_script("all");
#endif
	OK_MSG(submitUrl);
	return;

setErr_schedule:
/* WNC-NMR0313-Heng-I-Chen-20130308-Restore wlan index value */
	apmib_recov_wlanIdx();
/* WNC-NMR0313-Heng-I-Chen-20130308-End */
	ERR_MSG(tmpBuf);
	
}
#endif // #if defined(NEW_SCHEDULE_SUPPORT)

int getScheduleInfo(request *wp, int argc, char **argv)
{
	int	entryNum=0, i;
	SCHEDULE_T entry;
	int everyday=0, hours24=0;
	int dayWeek=0;
	char tmpBuf[200];
	unsigned char buffer[200];
	int isEnabled=0;
	char *strToken;
	int cmpResult=0;
	int index=0;
	char	*name_arg;

	//printf("get parameter=%s\n", argv[0]);
	name_arg = argv[0];
	if (name_arg == NULL) {
   		fprintf(stderr, "Insufficient args\n");
   		return -1;
   	}
   	
	if ( !strcmp(name_arg, ("wlan_state")) ) {
		bss_info bss;
		getWlBssInfo(WLAN_IF, &bss);
		if (bss.state == STATE_DISABLED) 
			strcpy((char *)buffer, "Disabled");
		else
			strcpy((char *)buffer, "Enabled");	
		req_format_write(wp, "%s", buffer);
		return 0;
	}else if(!strcmp(name_arg, ("system_time"))){
		#ifdef HOME_GATEWAY
					return 0;
		#else
		
		return req_format_write(wp,"%s","menu.addItem(\"System Time\", \"time.htm\", \"\", \"Setup System Time\");");
		#endif
	} 		
	cmpResult= strncmp(name_arg, "getentry_", 9);
	strToken=strstr(name_arg, "_");
	
	index= atoi(strToken+1);
	
	if ( !apmib_get(MIB_WLAN_SCHEDULE_TBL_NUM, (void *)&entryNum)) {
  		strcpy(tmpBuf, "Get table entry error!");
		return -1;
	}
	apmib_get(MIB_WLAN_SCHEDULE_ENABLED,(void *)&isEnabled);
	if(isEnabled==0){
		req_format_write(wp,"%s", "wlanSchedule-0-0-0-0-0-0");
		return 0;
	}
		
		for (i=1; i<=entryNum; i++) {
				*((char *)&entry) = (char)i;
				if ( !apmib_get(MIB_WLAN_SCHEDULE_TBL, (void *)&entry)){
					fprintf(stderr,"Get SCHEDULE entry fail\n");
					return -1;
				}
				if(entry.eco & ECO_EVERYDAY_MASK)
					everyday = 1;
				else
					everyday = 0;
				
				if(entry.eco & ECO_24HOURS_MASK)
					hours24 = 1;
				else
					hours24 = 0;
					
				if(everyday == 1)
				{
					dayWeek = 127; /* 01111111 */
				}
				else
				{
					dayWeek=entry.day;					
				}
				
				if(hours24 == 1)
				{
					entry.fTime=0;
					entry.tTime=1435;
				}
				
				if(index==i){
					req_format_write(wp,"%s-%d-%d-%d-%d-%d-%d",entry.text, isEnabled, everyday, dayWeek, hours24, entry.fTime, entry.tTime);   
				}
		}

	
	return 0;
	
	
	
}

#ifdef UNIVERSAL_REPEATER
void setRepeaterSsid(int wlanid, int rptid, char *str_ssid)
{
	char wlanifStr[10];
	char tmpStr[MAX_SSID_LEN]={0};  //WNC-NMR0000-Rita-20130305-Error_398-fix warnings of cppcheck (uninitialized value).

	/* WNC-NMR000-[Linear]-Libera-20140919-coverity-error-1060- OVERRUN-start */
	if(rptid==MIB_L2TP_PAYLOAD){
		printf("[warning]: need to use MIB_L2TP_PAYLOAD?");
		return;
	}
	/* WNC-NMR000-[Linear]-Libera-20140919-coverity-error-1060- OVERRUN-end */		
	apmib_save_wlanIdx();
	sprintf(wlanifStr,"wlan%d-vxd",wlanid);
	SetWlan_idx(wlanifStr);	
	
	apmib_get(MIB_WLAN_SSID, (void *)tmpStr);
	
	if(strcmp(tmpStr, str_ssid) != 0 && strcmp(str_ssid, tmpStr) != 0)
	{
		int is_configured = 1;
		
		apmib_set(MIB_WLAN_WSC_CONFIGURED, (void *)&is_configured);
		
		sprintf(tmpStr,"%s",str_ssid);
		apmib_set(MIB_WLAN_SSID, (void *)tmpStr);
		apmib_set(MIB_WLAN_WSC_SSID, (void *)tmpStr);
		/* WNC-NMR0000-Rita-20130314-Error_27,Error_100-fix warnings of cppcheck (OVERRUN).-Start */
		if(rptid == MIB_REPEATER_SSID1)
			apmib_set(MIB_REPEATER_SSID1, (void *)tmpStr);
		else if(rptid == MIB_REPEATER_SSID2)
			apmib_set(MIB_REPEATER_SSID2, (void *)tmpStr);
		/* WNC-NMR0000-Rita-20130314-End */
		apmib_set(rptid, (void *)tmpStr);
	}
	
	sprintf(wlanifStr,"wlan%d",wlanid);
	SetWlan_idx(wlanifStr);
	apmib_recov_wlanIdx();
}
#endif

////////////////////

#if defined(WLAN_PROFILE)
int addWlProfileHandler(request *wp, char *tmpBuf, int wlan_id)
{
	char *tmpStr;
	char varName[20];

	int add_to_profile = 0;
	
	if(!memcmp(tmpBuf, "wps_client_profile", 18))
	{
		add_to_profile=1;
	}

	if(add_to_profile == 0)
	{
	sprintf(varName, "wizardAddProfile%d", wlan_id);
	tmpStr = req_get_cstream_var(wp, varName, "");
	if(tmpStr[0])
			add_to_profile = 1;
	}
	
	if(add_to_profile == 1)
	{
		int profile_num_id, profile_tbl_id, profile_add_id, profile_delall_id;
		WLAN_PROFILE_T entry;
		char strSSID[64]={0};
		int encryptVal=0;//WNC-NMR0000-Rita-20130306-Error_483-fix warnings of cppcheck (uninitialized value).
		int entryNum=0; //WNC-NMR0000-Rita-20130305-Error_459-fix warnings of cppcheck (uninitialized value).
		int auth;

		if(wlan_id == 0)
		{
			profile_num_id = MIB_PROFILE_NUM1;
			profile_tbl_id = MIB_PROFILE_TBL1;
			profile_add_id = MIB_PROFILE_ADD1;
			profile_delall_id = MIB_PROFILE_DELALL1;
		}
		else
		{
			profile_num_id = MIB_PROFILE_NUM2;
			profile_tbl_id = MIB_PROFILE_TBL2;
			profile_add_id = MIB_PROFILE_ADD2;
			profile_delall_id = MIB_PROFILE_DELALL2;			
		}
		
		apmib_get(profile_num_id, (void *)&entryNum);

		if ( (entryNum + 1) > MAX_WLAN_PROFILE_NUM) {
			strcpy(tmpBuf, ("Cannot add new entry because table is full!"));
			goto setErr_end;
		}
		
		memset(&entry, 0x00, sizeof(WLAN_PROFILE_T));
		entry.wpa_cipher = 8;//WPA_CIPHER_AES
		
		

		apmib_get(MIB_WLAN_SSID, (void *)strSSID);
		/* WNC-NMR0000-JOE-PENG-20140911-Fix bug 2179 (STRING_OVERFLOW) in StaticCodeCheck_Linear_Delta1.xls */
		//strcpy(entry.ssid, strSSID);
		strncpy(entry.ssid, strSSID, MAX_SSID_LEN);
		/* WNC-NMR0000-JOE-PENG-20140911-Fix bug 2179 (STRING_OVERFLOW) in StaticCodeCheck_Linear_Delta1.xls */

		apmib_get(MIB_WLAN_ENCRYPT, (void *)&encryptVal);

		if(encryptVal == ENCRYPT_WEP)
		{
			int wepType = 0;//WNC-NMR0000-Rita-20130306-Error_492-fix warnings of cppcheck (uninitialized value).
			int authType=0; //WNC-NMR0000-Rita-20130310-Error_526-fix warnings of cppcheck (uninitialized value).
			int defKey=0;//WNC-NMR0000-Rita-20130310-Error_529-fix warnings of cppcheck (uninitialized value).
			char key[30];
			int keyType=0;//WNC-NMR0000-Rita-20130310-Error_534-fix warnings of cppcheck (uninitialized value).
			
			apmib_get( MIB_WLAN_WEP, (void *)&wepType);
			if(wepType == WEP64)
			{
				entry.encryption = WEP64;

				memset(key, 0x00, sizeof(key));					
				apmib_get(MIB_WLAN_WEP64_KEY1, (void *)key);
				strcpy(entry.wepKey1, key);

				memset(key, 0x00, sizeof(key));
				apmib_get(MIB_WLAN_WEP64_KEY2, (void *)key);
				strcpy(entry.wepKey2, key);

				memset(key, 0x00, sizeof(key));
				apmib_get(MIB_WLAN_WEP64_KEY3, (void *)key);
				strcpy(entry.wepKey3, key);

				memset(key, 0x00, sizeof(key));
				apmib_get(MIB_WLAN_WEP64_KEY4, (void *)key);
				strcpy(entry.wepKey4, key);
			}
			else
			{
				entry.encryption = WEP128;
				
				memset(key, 0x00, sizeof(key));
				apmib_get(MIB_WLAN_WEP128_KEY1, (void *)key);
				strcpy(entry.wepKey1, key);

				memset(key, 0x00, sizeof(key));
				apmib_get(MIB_WLAN_WEP128_KEY2, (void *)key);
				strcpy(entry.wepKey2, key);

				memset(key, 0x00, sizeof(key));
				apmib_get(MIB_WLAN_WEP128_KEY3, (void *)key);
				strcpy(entry.wepKey3, key);

				memset(key, 0x00, sizeof(key));
				apmib_get(MIB_WLAN_WEP128_KEY4, (void *)key);
				strcpy(entry.wepKey4, key);
			}

			apmib_get( MIB_WLAN_AUTH_TYPE, (void *)&authType);
			entry.auth = authType;

			apmib_get( MIB_WLAN_WEP_DEFAULT_KEY, (void *)&defKey);
			entry.wep_default_key = defKey;

			apmib_get( MIB_WLAN_WEP_KEY_TYPE, (void *)&keyType);
			entry.wepKeyType = keyType;

			
		}
		else if(encryptVal > ENCRYPT_WEP)
		{
			int cipherSuite=0;//WNC-NMR0000-Rita-20130310-Error_543,Error_547-fix warnings of cppcheck (uninitialized value).
			int pskFormat=0;//WNC-NMR0000-Rita-20130310-Error_554-fix warnings of cppcheck (uninitialized value).
			char wpaPsk[65]={0};
			
			if(encryptVal== ENCRYPT_WPA)
			{
				entry.encryption = 3;
				apmib_get( MIB_WLAN_WPA_CIPHER_SUITE, (void *)&cipherSuite);
			}
			else if(encryptVal== ENCRYPT_WPA2)
			{
				entry.encryption = 4;
				apmib_get( MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&cipherSuite);
			}
			else
			{
#if 1	/* NMR0000-[Aero]-20161011-patch: fmwlan-3411b.c ++*/
				entry.encryption = 6;
				apmib_get( MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&cipherSuite);	
				//get remote AP real security  form sitsurvey for wpa only
#else	/* NMR0000-[Aero]-20161011-patch: fmwlan-3411b.c --*/
				if(pStatus != NULL)         //pStatus is valid only after site survey
				{

				int i,find=0;
				BssDscr *pBss;
				char ssidbuf[33];
				for (i=0; i<pStatus->number && pStatus->number!=0xff; i++) {
					pBss = &pStatus->bssdb[i];
					memcpy(ssidbuf, pBss->bdSsIdBuf, pBss->bdSsId.Length);
					ssidbuf[pBss->bdSsId.Length] = '\0';
					if(!strcmp(entry.ssid,ssidbuf)){
						find = 1;
						if (pBss->bdTstamp[0] & 0x0000ffff) {//WPA
							entry.encryption = 3;
							if (((pBss->bdTstamp[0] & 0x00000f00) >> 8) == 0x5)
								cipherSuite = WPA_CIPHER_MIXED;
							else if (((pBss->bdTstamp[0] & 0x00000f00) >> 8) == 0x4)
								cipherSuite = WPA_CIPHER_AES;
							else if (((pBss->bdTstamp[0] & 0x00000f00) >> 8) == 0x1)
								cipherSuite = WPA_CIPHER_TKIP;
						}
						if (pBss->bdTstamp[0] & 0xffff0000){
							entry.encryption = 4;
							apmib_get( MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&cipherSuite);
						}
						break;
					}				
				}
				}
				if(find == 0){
					entry.encryption = 4;
					apmib_get( MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&cipherSuite);
				}
#endif		/* NMR0000-[Aero]-20161011-patch: fmwlan-3411b.c -end*/		
			}

			
			if(cipherSuite == WPA_CIPHER_TKIP)
				entry.wpa_cipher = 2;
			else if (cipherSuite == WPA_CIPHER_AES)	/* NMR0000-[Aero]-20161011-patch: fmwlan-3411b.c */
				entry.wpa_cipher = 8;
			else
				entry.wpa_cipher =10;	/* NMR0000-[Aero]-20161011-patch: fmwlan-3411b.c */

			apmib_get( MIB_WLAN_WPA_AUTH, (void *)&auth);
			if(auth == WPA_AUTH_AUTO){//==1 radius
				entry.auth = 1;
			}
			else{//==2  psk
				entry.auth = 2;
			}

			apmib_get( MIB_WLAN_PSK_FORMAT, (void *)&pskFormat);
			entry.wpaPSKFormat = pskFormat;

			apmib_get(MIB_WLAN_WPA_PSK,  (void *)wpaPsk);

			strcpy(entry.wpaPSK, wpaPsk);
			
		}
		else
		{
			entry.encryption = ENCRYPT_DISABLED;
		}

#if defined(PROFILE_BOTTOM_UP)
		WLAN_PROFILE_T oriEntry[MAX_WLAN_PROFILE_NUM];
		int roop=0;

		for(roop=0 ; roop<entryNum; roop++)
		{
			memset(oriEntry+roop, 0x00, sizeof(WLAN_PROFILE_T));
			*((char *)(oriEntry+roop)) = (char)(roop+1);
			apmib_get(profile_tbl_id, (void *)(oriEntry+roop));
		}

		apmib_set(profile_delall_id, (void *)&entry);

#endif

		if ( apmib_set(profile_add_id, (void *)&entry) == 0) {
			strcpy(tmpBuf, ("Add table entry error!"));
			goto setErr_end;
		}

#if defined(PROFILE_BOTTOM_UP)
		for(roop=0 ; roop<entryNum; roop++)
		{
			if(!memcmp((oriEntry[roop]).ssid, entry.ssid, strlen(entry.ssid)))
			{
				printf("this profile is exist, replace it with new configuration\n");
				continue;
			}
			else
			apmib_set(profile_add_id, (void *)(oriEntry+roop));
		}
#endif

	}

	return 0 ;
	
setErr_end:
	return -1 ;	
}

// WNC-NMR0000-JDR230-HENG-I-CHEN-20130802-Add function to handle single profile
WLAN_PROFILE_T temp_profile;
int profile_index;

int editWlProfileHandler(request *wp, int profile_index, WLAN_PROFILE_T *edit_entry)
{

	WLAN_PROFILE_T tempEntries[MAX_WLAN_PROFILE_NUM];
	int i=0, entryNum=0;

	apmib_get(MIB_PROFILE_NUM1, (void *)&entryNum);

	for(i=0 ; i<entryNum; i++)
	{
		if (profile_index == i + 1 ) {
			memcpy(tempEntries+i, edit_entry, sizeof(WLAN_PROFILE_T));
		} else {								
			memset(tempEntries+i, 0x00, sizeof(WLAN_PROFILE_T));
			*((char *)(tempEntries+i)) = (char)(i+1);
			apmib_get(MIB_PROFILE_TBL1, (void *)(tempEntries+i));
		}
	}
	if (profile_index >= entryNum+1) {
		memcpy(tempEntries+i, edit_entry, sizeof(WLAN_PROFILE_T));
		entryNum++;
	}

	apmib_set(MIB_PROFILE_DELALL1, (void *)&tempEntries);

	for(i=0 ; i<entryNum; i++)
	{
		apmib_set(MIB_PROFILE_ADD1, (void *)(tempEntries+i));
	}

	apmib_update_web(CURRENT_SETTING);

	return 0 ;
}

void formWlanEditProfile(request *wp, char *path, char *query)
{
	char *submitUrl,*strVal;
	int index;
	int mainType = -1;
	int subType = -1;
	int customSetting = 0;
	int keylen = 0;
//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20130103, Apply Realtek SDK 3.3.1 Alpha Patch
	//char tmpBuf[100];
	char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};
//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20130103, Apply Realtek SDK 3.3.1 Alpha Patch End
	int active = temp_profile.active;

//	WLAN_PROFILE_T tempEntry;

	submitUrl = req_get_cstream_var(wp, ("submit-url"), "");

	strVal = req_get_cstream_var(wp, ("profileIndex"), NULL);
	if (!strVal) {
		strcpy(tmpBuf, ("There is no index of profile!"));
		goto setErr_EditProfile;
	}
	
	index = atoi(strVal);

	memset(&temp_profile, 0, sizeof(WLAN_PROFILE_T));

	temp_profile.active = active;

	strVal = req_get_cstream_var(wp, ("profileName"), NULL);
	if (!strVal) {
		strcpy(tmpBuf, ("There is no name of profile!"));
		goto setErr_EditProfile;
	}

	/* WNC-MR0000-JOE-PENG-20130806-Fix bug that profile name could only store 32 characters in profile edit page */
	strncpy(temp_profile.profileName, strVal, 64);

	strVal = req_get_cstream_var(wp, ("wispType"), NULL);

	if (!strVal) {
		sprintf(tmpBuf, ("Cannot find profile type !"));
		goto setErr_EditProfile;
	}

	mainType = atoi(strVal);
	
	if (mainType) {
		strVal = req_get_cstream_var(wp, ("wispSubtype"), NULL);

		if (!strVal) {
			sprintf(tmpBuf, ("Cannot find profile subtype !"));
			goto setErr_EditProfile;
		}
		
		subType = atoi(strVal); 
		
		temp_profile.wispType = subType;
		
		if (subType % 16 == 15) {
			customSetting = 1;
		} else {
			customSetting = 0;
			switch(subType) {
				case 16:
					strncpy(temp_profile.ssid, "mobilepoint", MAX_SSID_LEN);
					temp_profile.encryption = 1;
					temp_profile.wepKeyType = KEY_HEX;
					temp_profile.auth = AUTH_BOTH;
					if ( !string_to_hex("696177616b", temp_profile.wepKey1, 10)) {
		   				strcpy(tmpBuf, ("Invalid wep-key value!"));
						goto setErr_EditProfile;
					}
					memcpy(temp_profile.wepKey2, temp_profile.wepKey1, WEP128_KEY_LEN*2+1);
					memcpy(temp_profile.wepKey3, temp_profile.wepKey1, WEP128_KEY_LEN*2+1);
					memcpy(temp_profile.wepKey4, temp_profile.wepKey1, WEP128_KEY_LEN*2+1);
					break;
				case 32:
					strncpy(temp_profile.ssid, "Wi2", MAX_SSID_LEN);
					temp_profile.encryption = 0;
					break;
				case 33:
					strncpy(temp_profile.ssid, "Wi2_club", MAX_SSID_LEN);
					temp_profile.encryption = 4;
					temp_profile.wpa_cipher = 8;//WPA_CIPHER_AES
					strncpy(temp_profile.wpaPSK, "rkhd7392", MAX_PSK_LEN);
					break;
				case 34:
					strncpy(temp_profile.ssid, "Wi2premium", MAX_SSID_LEN);
					temp_profile.encryption = 0;
					break;
				case 35:
					strncpy(temp_profile.ssid, "Wi2premium_club", MAX_SSID_LEN);
					temp_profile.encryption = 4;
					temp_profile.wpa_cipher = 8;//WPA_CIPHER_AES
					strncpy(temp_profile.wpaPSK, "m3wen2uc", MAX_PSK_LEN);
					break;
			}
		}

		strVal = req_get_cstream_var(wp, ("autoLogin"), NULL);

		if (strVal) {
			temp_profile.wispAutoLogin = 1;

			strVal = req_get_cstream_var(wp, ("loginID"), NULL);

			if (!strVal) {
				sprintf(tmpBuf, ("Cannot find profile Login ID !")); 
			}

			strncpy(temp_profile.wispLogin, strVal, 128);

			strVal = req_get_cstream_var(wp, ("password"), NULL);

			if (!strVal) {
				sprintf(tmpBuf, ("Cannot find profile password !"));
				goto setErr_EditProfile;
			}

			strncpy(temp_profile.wispPass, strVal, 64);
		} else {
			temp_profile.wispAutoLogin = 0;
		}		
		
	} else {
		temp_profile.wispType = 0;
		temp_profile.wispAutoLogin = 0;
		customSetting = 1;
	}
	
	if (customSetting) {	
		strVal = req_get_cstream_var(wp, ("profileSSID"), NULL);
		if (!strVal) {
			strcpy(tmpBuf, ("There is no SSID of profile!"));
			goto setErr_EditProfile;
		}

		strncpy(temp_profile.ssid, strVal, MAX_SSID_LEN);
  		temp_profile.ssid[MAX_SSID_LEN-1]= '\0';	/* WNC-NMR000-[Linear]-Libera-20140912-coverity-error-155-BUFFER_SIZE_WARNING */

		strVal = req_get_cstream_var(wp, ("profileEncrypt"), NULL);

		if (!strVal) {
			sprintf(tmpBuf, ("Cannot find profile Encryption type !"));
			goto setErr_EditProfile;
		}
		
		if (strncmp(strVal, "None", 5) == 0) {
			temp_profile.encryption = 0;
			keylen = 0;
		} else if (strncmp(strVal, "WEP", 4) == 0) {
		                            
			temp_profile.auth = AUTH_BOTH;
												 
			strVal = req_get_cstream_var(wp, ("profileKeyLen"), NULL);
	
			if (!strVal) {
				sprintf(tmpBuf, ("Cannot find profile WEP Key Length !"));
				goto setErr_EditProfile;
			}
			
			if (atoi(strVal) == 64) {
				temp_profile.encryption = 1;
				keylen = 5;								
			} else {
				temp_profile.encryption = 2;
				keylen = 13;
			}
			
			strVal = req_get_cstream_var(wp, ("profileKeyType"), NULL);
	
			if (!strVal) {
				sprintf(tmpBuf, ("Cannot find profile WEP Key Type !"));
				goto setErr_EditProfile;
			}
			
			if (strncmp(strVal, "HEX", 4) == 0) {
				keylen *= 2;
				temp_profile.wepKeyType = KEY_HEX;
			} else {
				temp_profile.wepKeyType = KEY_ASCII;
			}

			strVal = req_get_cstream_var(wp, ("profileKey"), NULL);
		
			if (!strVal) {
				sprintf(tmpBuf, ("Cannot find profile WEP Key !"));
				goto setErr_EditProfile;
			}
			
/* WNC-NMR0000-HENG-I-CHEN-20130722-Change Profile HEX Wep Key from string to binery */
			if (temp_profile.wepKeyType == KEY_ASCII) { // ASCII
				strncpy(temp_profile.wepKey1, strVal, keylen);
				strncpy(temp_profile.wepKey2, strVal, keylen);
				strncpy(temp_profile.wepKey3, strVal, keylen);
				strncpy(temp_profile.wepKey4, strVal, keylen);
			} else { // HEX
				memset(temp_profile.wepKey1, 0, WEP128_KEY_LEN*2+1);
				if ( !string_to_hex(strVal, temp_profile.wepKey1, keylen)) {
	   				strcpy(tmpBuf, ("Invalid wep-key value!"));
					goto setErr_EditProfile;
				}
				memcpy(temp_profile.wepKey2, temp_profile.wepKey1, WEP128_KEY_LEN*2+1);
				memcpy(temp_profile.wepKey3, temp_profile.wepKey1, WEP128_KEY_LEN*2+1);
				memcpy(temp_profile.wepKey4, temp_profile.wepKey1, WEP128_KEY_LEN*2+1);
			}
/* WNC-NMR0000-HENG-I-CHEN-20130722-End */
				
		} else {
/* WNC-NMR0000-JDR230-HENG-I-CHEN-20130717-Fix wpa chipher for wlan profile */
			if (strncmp(strVal, "WPA-PSK(TKIP)", 14) == 0) {
				temp_profile.encryption = 3;
				temp_profile.wpa_cipher = 2;//WPA_CIPHER_TKIP
			} else if (strncmp(strVal, "WPA-PSK(AES)", 13) == 0) {
				temp_profile.encryption = 3;
				temp_profile.wpa_cipher = 8;//WPA_CIPHER_AES
			} else if (strncmp(strVal, "WPA2-PSK(TKIP)", 15) == 0) {
				temp_profile.encryption = 4;
				temp_profile.wpa_cipher = 2;//WPA_CIPHER_TKIP
			} else if (strncmp(strVal, "WPA2-PSK(AES)", 14) == 0) {
				temp_profile.encryption = 4;
				temp_profile.wpa_cipher = 8;//WPA_CIPHER_AES
			}
/* WNC-NMR0000-JDR230-HENG-I-CHEN-20130717-End */
			strVal = req_get_cstream_var(wp, ("profileKey"), NULL);
		
			if (!strVal) {
				sprintf(tmpBuf, ("Cannot find profile PSK Key !"));
				goto setErr_EditProfile;
			}
			
			strncpy(temp_profile.wpaPSK, strVal, MAX_PSK_LEN);
			
			if (strlen(temp_profile.wpaPSK) == 64) {
				temp_profile.wpaPSKFormat = 1;
			} else {
				temp_profile.wpaPSKFormat = 0;
			}
		}
	}

	editWlProfileHandler(wp, index, &temp_profile);
	
	send_redirect_perm(wp, WLAN_PROFILE_LIST_PAGE);

	return;
setErr_EditProfile:
	ERR_MSG(tmpBuf);
}
// WNC-NMR0000-JDR230-HENG-I-CHEN-20130802-End

#endif //#if defined(WLAN_PROFILE)

#if defined(WLAN_PROFILE)
static int wlProfileHandler(request *wp, char *tmpBuf, int wlan_id)
{
	char *strVal, *strSSID;
	char varName[20], strtmp[80];
	char *strAddWlProfile, *strAddRptProfile, *strDelSelProfile, *strDelAllProfile, *strWlProfileEnabled;
	int profile_num_id, profile_tbl_id, profile_add_id, profile_del_id, profile_delall_id, profile_enabled_id;
	int entryNum=0; //WNC-NMR0000-Rita-20130310-Error_551,Error_586,Error_604-fix warnings of cppcheck (uninitialized value).
	int wlProfileEnabled;
	WLAN_PROFILE_T entry={0};
	int mode;
	int val =0;//WNC-NMR0000-Rita-20130305-Error_388-fix warnings of cppcheck (uninitialized value).
	
	memset(&entry,0,sizeof(WLAN_PROFILE_T));//WNC-NMR0000-Rita-20130310-Error_607-fix warnings of cppcheck (uninitialized value).
//displayPostDate(wp->post_data);
	sprintf(varName, "mode%d", wlan_id);
	strVal = req_get_cstream_var(wp, varName, "");

	if(strVal[0] == 0)
	{
		int val=0;

		apmib_get( MIB_WLAN_MODE, (void *)&val);
		sprintf(strtmp,"%d",val);
		strVal = strtmp;		
	}

	
	if ( strVal[0] ) {
		mode = strVal[0] - '0';

		if (mode == CLIENT_MODE) {
			ENCRYPT_T encrypt;
      		apmib_get( MIB_WLAN_ENCRYPT,  (void *)&encrypt);
		if (encrypt &  ENCRYPT_WPA2_MIXED) {
			int format = 0; //WNC-NMR0000-Rita-20130305-Error_440-fix warnings of cppcheck (uninitialized value).
			apmib_get( MIB_WLAN_WPA_AUTH, (void *)&format);
			if (format & 1) { // radius
#ifdef CONFIG_RTL_802_1X_CLIENT_SUPPORT
				//Support wlan client mode with Enterprise (RADIUS)
#else
				strcpy(tmpBuf, ("You cannot set client mode with Enterprise (RADIUS) !<br><br>Please change the encryption method in security page first."));
				goto setErr_wlan;
#endif
			}
		}
		else if (encrypt == ENCRYPT_WEP || encrypt == 0) {
			int use1x = 0; //WNC-NMR0000-Rita-20130306-Error_473-fix warnings of cppcheck (uninitialized value).
			apmib_get( MIB_WLAN_ENABLE_1X, (void *)&use1x);
			if (use1x & 1) {
#ifdef CONFIG_RTL_802_1X_CLIENT_SUPPORT
				//Support wlan client mode with Enterprise (RADIUS)
#else
				strcpy(tmpBuf, ("You cannot set client mode with 802.1x enabled!<br><br>Please change the encryption method in security page first."));
				goto setErr_wlan;
#endif
			}
		}
		sprintf(varName, "wlanMacClone%d", wlan_id);
		strVal = req_get_cstream_var(wp, varName, "");
		if ( !strcmp(strVal, "ON"))
			val = 1 ;
		else
			val = 0 ;
		if ( apmib_set( MIB_WLAN_MACCLONE_ENABLED, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set wlan Mac clone error!"));
			goto setErr_wlan;
		}
	}

	if ( apmib_set( MIB_WLAN_MODE, (void *)&mode) == 0) {
			strcpy(tmpBuf, ("Set MIB_WLAN_MODE error!"));
		goto setErr_wlan;
	}
	
#ifdef WLAN_EASY_CONFIG
	apmib_set( MIB_WLAN_EASYCFG_WLAN_MODE, (void *)&mode);
#endif
	

}
		
	if(wlan_id == 0)
	{
		profile_num_id = MIB_PROFILE_NUM1;
		profile_tbl_id = MIB_PROFILE_TBL1;
		profile_add_id = MIB_PROFILE_ADD1;
		profile_del_id = MIB_PROFILE_DEL1;
		profile_delall_id = MIB_PROFILE_DELALL1;
		profile_enabled_id = MIB_PROFILE_ENABLED1;
	}
	else
	{
		profile_num_id = MIB_PROFILE_NUM2;
		profile_tbl_id = MIB_PROFILE_TBL2;
		profile_add_id = MIB_PROFILE_ADD2;		
		profile_del_id = MIB_PROFILE_DEL2;
		profile_delall_id = MIB_PROFILE_DELALL2;
		profile_enabled_id = MIB_PROFILE_ENABLED2;
	}
	

	strWlProfileEnabled = req_get_cstream_var(wp, ("wlProfileEnabled"), "");
	strAddWlProfile = req_get_cstream_var(wp, ("addWlProfile"), "");
	strAddRptProfile = req_get_cstream_var(wp, ("addRptProfile"), "");
	strDelSelProfile = req_get_cstream_var(wp, ("delSelWlProfile"), "");
	strDelAllProfile = req_get_cstream_var(wp, ("delAllWlProfile"), "");
	
	if (strWlProfileEnabled[0]) {
			wlProfileEnabled = atoi(strWlProfileEnabled);
			apmib_set( profile_enabled_id, (void *)&wlProfileEnabled);			
	}
	else
	{
		wlProfileEnabled = 0;
		apmib_set( profile_enabled_id, (void *)&wlProfileEnabled);
	}
	
	/* Add entry */
	if (strAddWlProfile[0]) 
	{
		strcpy(tmpBuf,"wps_client_profile");
		addWlProfileHandler(NULL, tmpBuf, wlan_idx);
#if 0
		int del_ret; 

		memset(&entry,0x00, sizeof(WLAN_PROFILE_T));
		entry.wpa_cipher = 8; //WPA_CIPHER_AES
		
		sprintf(varName, "ssid%d", wlan_id);
   		strSSID = req_get_cstream_var(wp, varName, "");
   		strcpy(entry.ssid, strSSID);
   	

		apmib_get(profile_num_id, (void *)&entryNum);
		
		if ( (entryNum + 1) > MAX_WLAN_PROFILE_NUM) {
			strcpy(tmpBuf, ("Cannot add new entry because table is full!"));
			goto setErr_wlan;
		}

#if defined(PROFILE_BOTTOM_UP)
		WLAN_PROFILE_T oriEntry[MAX_WLAN_PROFILE_NUM];
		int roop=0;

		for(roop=0 ; roop<entryNum; roop++)
		{
			memset(oriEntry+roop, 0x00, sizeof(WLAN_PROFILE_T));
			*((char *)(oriEntry+roop)) = (char)(roop+1);
			apmib_get(profile_tbl_id, (void *)(oriEntry+roop));

//printf("\r\n oriEntry[roop].ssid=[%s],__[%s-%u]\r\n",oriEntry[roop].ssid,__FILE__,__LINE__);

		}

		apmib_set(profile_delall_id, (void *)&entry);

#endif
		// set to MIB. try to delete it first to avoid duplicate case
		del_ret = apmib_set(profile_del_id, (void *)&entry);
		if ( apmib_set(profile_add_id, (void *)&entry) == 0) {
			strcpy(tmpBuf, ("Add table entry error!"));
			goto setErr_wlan;
		}

#if defined(PROFILE_BOTTOM_UP)
		for(roop=0 ; roop<entryNum; roop++)
		{
			apmib_set(profile_add_id, (void *)(oriEntry+roop));
		}
#endif
		if(del_ret == 1)
		{
			//printf("\r\n Duplicate add profile__[%s-%u]\r\n",__FILE__,__LINE__);
			strcpy(tmpBuf, ("Add Profile duplicately!"));
			goto setErr_wlan;
		}

		sprintf(varName, "ssid%d", wlan_id);
		strSSID = req_get_cstream_var(wp, varName, "");
		if ( strSSID[0] ) {
			if ( apmib_set(MIB_WLAN_SSID, (void *)strSSID) == 0) {
	   	 			strcpy(tmpBuf, ("Set SSID error!"));
					goto setErr_wlan;
			}
		}
		else if ( mode == 1 && !strSSID[0] ) { // client and NULL SSID
			if ( apmib_set(MIB_WLAN_SSID, (void *)strSSID) == 0) {
	   	 			strcpy(tmpBuf, ("Set SSID error!"));
					goto setErr_wlan;
			}
		}
#endif		

	}

	if (strAddRptProfile[0]) 
	{
		unsigned char wlan_iface_name[16];
		sprintf(wlan_iface_name, "wlan%d-vxd", wlan_idx);
		SetWlan_idx(wlan_iface_name);
		strcpy(tmpBuf,"wps_client_profile");
		addWlProfileHandler(NULL, tmpBuf, wlan_idx);
		sprintf(wlan_iface_name, "wlan%d", wlan_idx);
		SetWlan_idx(wlan_iface_name);
#if 0	
		int id, rpt_enabled;
		int del_ret; 

		memset(&entry,0x00, sizeof(WLAN_PROFILE_T));
		entry.wpa_cipher = 8; //WPA_CIPHER_AES
		
		sprintf(varName, "repeaterSSID%d", wlan_id);
   	strSSID = req_get_cstream_var(wp, varName, "");
   	strcpy(entry.ssid, strSSID);
   	
		apmib_get(profile_num_id, (void *)&entryNum);
		
		if ( (entryNum + 1) > MAX_WLAN_PROFILE_NUM) {
			strcpy(tmpBuf, ("Cannot add new entry because table is full!"));
			goto setErr_wlan;
		}

#if defined(PROFILE_BOTTOM_UP)
		WLAN_PROFILE_T oriEntry[MAX_WLAN_PROFILE_NUM];
		int roop=0;

		for(roop=0 ; roop<entryNum; roop++)
		{
			memset(oriEntry+roop, 0x00, sizeof(WLAN_PROFILE_T));
			*((char *)(oriEntry+roop)) = (char)(roop+1);
			apmib_get(profile_tbl_id, (void *)(oriEntry+roop));

//printf("\r\n oriEntry[roop].ssid=[%s],__[%s-%u]\r\n",oriEntry[roop].ssid,__FILE__,__LINE__);

		}

		apmib_set(profile_delall_id, (void *)&entry);

#endif
		// set to MIB. try to delete it first to avoid duplicate case
		del_ret = apmib_set(profile_del_id, (void *)&entry);
		if ( apmib_set(profile_add_id, (void *)&entry) == 0) {
			strcpy(tmpBuf, ("Add table entry error!"));
			goto setErr_wlan;
		}

#if defined(PROFILE_BOTTOM_UP)
		for(roop=0 ; roop<entryNum; roop++)
		{
			apmib_set(profile_add_id, (void *)(oriEntry+roop));
		}
#endif

		if(del_ret == 1)
		{
			//printf("\r\n Duplicate add profile__[%s-%u]\r\n",__FILE__,__LINE__);
			strcpy(tmpBuf, ("Add Profile duplicately!"));
			goto setErr_wlan;
		}

		/* WNC-MR0000-JOE-PENG-20130806-Fix bug that MIB_REPEATER_ENABLED1 is set to 0 if user set WIFI and not reboot. This cause status page incorrect in wireless WAN mode->start */
		if (wlan_id == 0)
			id = MIB_REPEATER_ENABLED1;
		else
			id = MIB_REPEATER_ENABLED2;
		apmib_get(id, (void *)&val);

		sprintf(varName, "repeaterEnabled%d", wlan_id);
		strVal = req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			if ( !strcmp(strVal, "ON"))
				val = 1 ;
			else
				val = 0 ;
		}
		/* WNC-MR0000-JOE-PENG-20130806-Fix bug that MIB_REPEATER_ENABLED1 is set to 0 if user set WIFI and not reboot. This cause status page incorrect in wireless WAN mode->end */

#if defined(CONFIG_RTL_ULINKER)
		if (wlan_id == 0)
			id = MIB_REPEATER_ENABLED1;
		else
			id = MIB_REPEATER_ENABLED2;
		apmib_get(id, (void *)&rpt_enabled);
		if(mode == AP_MODE && rpt_enabled == 1) //ulinker repeater mode
		{
			val = 1;
		}
#endif
			
		if (wlan_id == 0)
			id = MIB_REPEATER_ENABLED1;
		else
			id = MIB_REPEATER_ENABLED2;
		apmib_set(id, (void *)&val);

		if (val == 1) {
			sprintf(varName, "repeaterSSID%d", wlan_id);
			/* WNC-NMR0348-JOE-PENG-20130329-Fix Page Fault occurs during setting on GUI */
			strVal = req_get_cstream_var(wp, varName, "");
			if (strVal[0]){
				if (wlan_id == 0)
					id = MIB_REPEATER_SSID1;
				else
					id = MIB_REPEATER_SSID2;
					
				setRepeaterSsid(wlan_id, id, strVal);
			}
		}
#endif

	}


	
	/* Delete entry */
	if (strDelSelProfile[0]) {
		int i;
		apmib_get(profile_num_id, (void *)&entryNum);

			
		for (i=entryNum; i>0; i--) {
			strVal = NULL;
			snprintf(strtmp, 20, "select%d", i);

			strVal = req_get_cstream_var(wp, strtmp, "");
			if(strVal == NULL)
				continue;
				
			if ( !strcmp(strVal, "ON") ) {

				*((char *)&entry) = (char)i;
				
				if ( !apmib_get(profile_tbl_id, (void *)&entry)) {
					strcpy(tmpBuf, ("Get table entry error!"));
					goto setErr_wlan;
				}
				if ( !apmib_set(profile_del_id, (void *)&entry)) {
					strcpy(tmpBuf, ("Delete table entry error!"));
					goto setErr_wlan;
				}
			}
		}

	}

	/* Delete all entry */
	if ( strDelAllProfile[0]) {

		if ( !apmib_set(profile_delall_id, (void *)&entry)) {
			strcpy(tmpBuf, ("Delete all table error!"));
			goto setErr_wlan;
		}
	}


	return  0;

setErr_wlan:
	return -1 ;	
	
}

#endif //#if defined(WLAN_PROFILE)

/*----------------------------------------------------------------------------*/
#ifdef CONFIG_RTL_AIRTIME
enum {
	sbNormal =1,
	sbAddStaion,
	sbDelSel,
	sbDelAll,
};

struct sb_action_s {
	int  action;
	char *name;
};

struct sb_action_s sb_action[] = {
	{ sbNormal,    "applyChanges"},
	{ sbAddStaion, "addStation"},
	{ sbDelSel,    "deleteSelRule"},
	{ sbDelAll,    "deleteAllRules"},
};

void formAirtime(request *wp, char *path, char *query)
{
	char tmpBuf[100];
	int entryNum;
	struct in_addr curIpAddr, curSubnet;
	unsigned long v1, v2, v3;
	int num_id, get_id, add_id, del_id, delall_id, enable_id, mode_id, iftime_id;
#ifndef NO_ACTION
	int pid;
#endif
	
	AIRTIME_T atmEntry, atmEntryTmp;

	char *strVal, *submitUrl;
	char *strIpAddr, *strMacAddr, *strAlocation;

	void *pEntry;
	int i;
	int enabled, mode, total, submit = 0;
	int vWLanIdxBak, val;

	vWLanIdxBak = vwlan_idx;
	
	if (wlan_idx == 0) {
		num_id = MIB_AIRTIME_TBL_NUM;
		get_id = MIB_AIRTIME_TBL;
		add_id = MIB_AIRTIME_ADD;
		del_id = MIB_AIRTIME_DEL;
		delall_id = MIB_AIRTIME_DELALL;
		enable_id = MIB_AIRTIME_ENABLED;
		mode_id   = MIB_AIRTIME_MODE;
		iftime_id = MIB_AIRTIME_IFTIME;
	}
	else {
		num_id = MIB_AIRTIME2_TBL_NUM;
		get_id = MIB_AIRTIME2_TBL;
		add_id = MIB_AIRTIME2_ADD;
		del_id = MIB_AIRTIME2_DEL;
		delall_id = MIB_AIRTIME2_DELALL;
		enable_id = MIB_AIRTIME2_ENABLED;		
		mode_id   = MIB_AIRTIME2_MODE;
		iftime_id = MIB_AIRTIME2_IFTIME;
	}
	
	memset(&atmEntry, '\0', sizeof(atmEntry));
	pEntry = (void *)&atmEntry;

	/* set submit action */
	total = sizeof(sb_action)/sizeof(struct sb_action_s);
	for (i = 0; i < total; i++) {
		strVal = NULL;
		strVal = req_get_cstream_var(wp, (sb_action[i].name), "");
		if (strVal[0]) {
			submit = sb_action[i].action;
			break;
		}
	}
	if (submit == 0) {
		goto setOk_airtime;
	}

	/*--- set MIB_AIRTIME_ENABLED --------------------------------------------*/
	if (submit == sbNormal)
	{
		strVal = NULL;
		strVal = req_get_cstream_var(wp, ("airtime_mode_select"), "");
		if (strcmp(strVal, "0") == 0)
			enabled = 0;
		else
			enabled = 1;

		if (apmib_set(enable_id, (void *)&enabled) == 0) {
			strcpy(tmpBuf, ("Set enabled flag error!"));
			goto setErr_airtime;
		}
	}

	/*--- set MIB_AIRTIME_MODE -----------------------------------------------*/
	if (enabled || submit != sbNormal) {
		strVal = NULL;
		strVal = req_get_cstream_var(wp, ("airtime_mode"), "");
		if (strVal[0]) {
			mode = atoi(strVal);

			if (mode < ATM_SSID_AUTO || mode > ATM_DEVICE_MANUAL) {
				strcpy(tmpBuf, ("Set mode error! unknown mode!!"));
				goto setErr_airtime;
			}

			if (apmib_set(mode_id, (void *)&mode) == 0) {
				strcpy(tmpBuf, ("Set mode error!"));
				goto setErr_airtime;
			}
		}
	}

	/*--- set MIB_AIRTIME_IFTIME ---------------------------------------------*/
	if (enabled && mode == ATM_SSID_MANUAL) {
		char time[6], count=0;

		if (NUM_VWLAN_INTERFACE+1 > 6) {
			strcpy(tmpBuf, ("Set SSID Base Mode error!"));
			goto setErr_airtime;
		}

		vWLanIdxBak = vwlan_idx;
		for (i=0; i<=NUM_VWLAN_INTERFACE; i++) {
			strVal = NULL;
			sprintf(tmpBuf, "time%d", i);
			strVal = req_get_cstream_var(wp, (tmpBuf), "");
			if (strVal[0]) {
				time[i] = atoi(strVal);
			}
			else {
				vwlan_idx = i; 
				apmib_get(MIB_WLAN_WLAN_DISABLED, (void *)&val);
				if (val == 1)
					time[i] = 0;
				else {
					strcpy(tmpBuf, ("Set SSID Base Mode error!"
						" Empty allocation!!"));
					goto setErr_airtime;	
				}
			}

			if (time[i] <0 || time[i]>100) {
				strcpy(tmpBuf, ("Set SSID Base Mode error!"
					" allocation must be 0~100!!"));
				goto setErr_airtime;	
			}

			count += time[i];
		}
		vwlan_idx = vWLanIdxBak;

		if (count > 100) {
			strcpy(tmpBuf, ("Set SSID Base Mode error!"
				" Totoal allocation must be less than 100!!"));
			goto setErr_airtime;
		}

		if (apmib_set(iftime_id, (void *)time) == 0) {
			strcpy(tmpBuf, ("Set SSID Base Mode error!"));
			goto setErr_airtime;
		}
	}

	/*--- set MIB_AIRTIME_TBL ------------------------------------------------*/
	if (submit == sbAddStaion) {	
		strIpAddr = strMacAddr = strAlocation = NULL;

		strIpAddr    = req_get_cstream_var(wp, ("ipaddr"),  "");
		strMacAddr   = req_get_cstream_var(wp, ("macaddr"), "");
		strAlocation = req_get_cstream_var(wp, ("allocation"), "");

		if (!strAlocation[0]) {
			strcpy(tmpBuf, ("Error! Please fill allocation!"));
			goto setErr_airtime;
		}

		if (!strIpAddr[0] && !strMacAddr[0]) {
			strcpy(tmpBuf, ("Error! Please fill ipaddr or macaddr!"));
			goto setErr_airtime;
		}

		/*----- set ipaddr ---------*/
		if (strIpAddr[0]) {
			inet_aton(strIpAddr, (struct in_addr *)&atmEntry.ipAddr);
			getInAddr(BRIDGE_IF, IP_ADDR, (void *)&curIpAddr);
			getInAddr(BRIDGE_IF, SUBNET_MASK, (void *)&curSubnet);

			v1 = *((unsigned long *)atmEntry.ipAddr);
			v2 = *((unsigned long *)&curIpAddr);
			v3 = *((unsigned long *)&curSubnet);

			/* check ip subnet */
			if ((v1 & v3) != (v2 & v3)) {
				strcpy(tmpBuf, ("Invalid IP address!"
					" It should be set within the current subnet."));
				goto setErr_airtime;
			}

			/* check ip exist? */
			apmib_get(num_id, (void *)&entryNum);
			for (i=1; i<=entryNum; i++) {
				memset(&atmEntryTmp, 0x00, sizeof(atmEntryTmp));
				*((char *)&atmEntryTmp) = (char)i;
				if (apmib_get(get_id, (void *)&atmEntryTmp)) {
					if (*((unsigned long *)atmEntry.ipAddr) == 
						*((unsigned long *)atmEntryTmp.ipAddr)) {
						strcpy(tmpBuf, ("ip address exist!"));
						goto setErr_airtime;	
					}
				}
			}
		}	

		/*----- set macaddr --------*/
		if (strMacAddr[0]) {
			if (strlen(strMacAddr)!=12 || !string_to_hex(strMacAddr, atmEntry.macAddr, 12)) {
				strcpy(tmpBuf, ("Error! Invalid MAC address."));
				goto setErr_airtime;
			}
			
			/* check mac exist? */
			apmib_get(num_id, (void *)&entryNum);
			for (i=1; i<=entryNum; i++) {
				memset(&atmEntryTmp, 0x00, sizeof(atmEntryTmp));
				*((char *)&atmEntryTmp) = (char)i;
				if (apmib_get(get_id, (void *)&atmEntryTmp)) {
					if (!memcmp(atmEntryTmp.macAddr, atmEntry.macAddr, 6)) {
						strcpy(tmpBuf, ("mac address exist!"));
						goto setErr_airtime;
					}
				}
			}
		}

		/*----- set allocation -----*/
		if (strAlocation[0]) {
			total = atmEntry.atm_time = atoi(strAlocation);

			/* check sum of total allocation */
			apmib_get(num_id, (void *)&entryNum);
			for (i=1; i<=entryNum; i++) {
				memset(&atmEntryTmp, 0x00, sizeof(atmEntryTmp));
				*((char *)&atmEntryTmp) = (char)i;
				if (apmib_get(get_id, (void *)&atmEntryTmp)) {
					total += atmEntryTmp.atm_time;
				}
			}
			if (total > 100) {
				strcpy(tmpBuf, ("Total Allocation must be less than 100!"));
				goto setErr_airtime;				
			}
		}

		/*----- set commet ---------*/
		strVal = NULL;
		strVal = req_get_cstream_var(wp, ("comment"), "");
		if (strVal[0]) {
			if (strlen(strVal) > COMMENT_LEN-1) {
				strcpy(tmpBuf, ("Error! Comment length too long."));
				goto setErr_airtime;
			}
			strcpy((char *)atmEntry.comment, strVal);
		}

		if (!apmib_get(num_id, (void *)&entryNum)) {
			strcpy(tmpBuf, ("Get entry number error!"));
			goto setErr_airtime;
		}

		if ((entryNum + 1) > MAX_AIRTIME_NUM) {
			strcpy(tmpBuf, ("Cannot add new Staion because table is full!"));
			goto setErr_airtime;
		}

		/* set to MIB. try to delete it first to avoid duplicate case */
		apmib_set(del_id, pEntry);
		if (apmib_set(add_id, pEntry) == 0) {
			strcpy(tmpBuf, ("Add table entry error!"));
			goto setErr_airtime;
		}
	}

	/*--- del selection ------------------------------------------------------*/
	if (submit == sbDelSel) {
		if (!apmib_get(num_id, (void *)&entryNum)) {
			strcpy(tmpBuf, ("Get entry number error!"));
			goto setErr_airtime;
		}
		for (i=entryNum; i>0; i--) {
			snprintf(tmpBuf, 20, "select%d", i);

			strVal = req_get_cstream_var(wp, tmpBuf, "");
			if (!strcmp(strVal, "ON") ) {

				*((char *)pEntry) = (char)i;
				if ( !apmib_get(get_id, pEntry)) {
					strcpy(tmpBuf, ("Get table entry error!"));
					goto setErr_airtime;
				}
				if ( !apmib_set(del_id, pEntry)) {
					strcpy(tmpBuf, ("Delete table entry error!"));
					goto setErr_airtime;
				}
			}
		}
	}

	/*--- del all ------------------------------------------------------------*/
	if (submit == sbDelAll) {
		if (!apmib_set(delall_id, pEntry)) {
			strcpy(tmpBuf, ("Delete all table error!"));
			goto setErr_airtime;
		}
	}

setOk_airtime:
	if (submit == sbAddStaion) {
		needReboot = 0;
	}
	else {
		needReboot = 1;	
	}
	apmib_update_web(CURRENT_SETTING);

	submitUrl = req_get_cstream_var(wp, "submit-url", ""); // hidden page

#ifdef REBOOT_CHECK
	if(needReboot == 1)
	{
		OK_MSG(submitUrl);
		return;
	}
#endif

	if (submitUrl[0])
		send_redirect_perm(wp, submitUrl);
  	return;

setErr_airtime:
	vwlan_idx = vWLanIdxBak;
	ERR_MSG(tmpBuf);
}

int airTimeList(request *wp, int argc, char **argv)
{
	int	nBytesSent=0, entryNum, i;
	AIRTIME_T entry;
	char	*type, *ip;
	int tbl_id, num_id;
	
	if (wlan_idx == 0) {
		tbl_id = MIB_AIRTIME_TBL;
		num_id = MIB_AIRTIME_TBL_NUM;
	}
	else {
		tbl_id = MIB_AIRTIME2_TBL;
		num_id = MIB_AIRTIME2_TBL_NUM;		
	}

	if ( !apmib_get(num_id, (void *)&entryNum)) {
  		fprintf(stderr, "Get table entry error!\n");
		return -1;
	}

	nBytesSent += req_format_write(wp, ("<tr class=\"tbl_head\">"
      	"<td align=center width=\"30%%\" ><font size=\"2\"><b>IP/MAC Address</b></font></td>\n"
      	"<td align=center width=\"25%%\" ><font size=\"2\"><b>Allcation %%</b></font></td>\n"
      	"<td align=center width=\"30%%\" ><font size=\"2\"><b>Comment</b></font></td>\n"
      	"<td align=center width=\"15%%\" ><font size=\"2\"><b>Select</b></font></td></tr>\n"));

	for (i=1; i<=entryNum; i++) {
		*((char *)&entry) = (char)i;
		if ( !apmib_get(tbl_id, (void *)&entry))
			return -1;

		if (strcmp(inet_ntoa(*((struct in_addr *)entry.ipAddr)), "0.0.0.0") == 0) {
			/* show mac */
			nBytesSent += req_format_write(wp, ("<tr>"
					"<td align=center width=\"30%%\" ><font size=\"2\">%02x:%02x:%02x:%02x:%02x:%02x</td>\n"
	      			"<td align=center width=\"25%%\" ><font size=\"2\">%d</td>\n"
	      			"<td align=center width=\"30%%\" ><font size=\"2\">%s</td>\n"
	      			"<td align=center width=\"15%%\" ><input type=\"checkbox\" name=\"select%d\" value=\"ON\"></td></tr>\n"),
					entry.macAddr[0], entry.macAddr[1], entry.macAddr[2],
					entry.macAddr[3], entry.macAddr[4], entry.macAddr[5],
					entry.atm_time, entry.comment, i);
		}
		else {
			/* show ip */
			nBytesSent += req_format_write(wp, ("<tr>"
				"<td align=center width=\"30%%\" ><font size=\"2\">%s</td>\n"
	      			"<td align=center width=\"25%%\" ><font size=\"2\">%d</td>\n"
	      			"<td align=center width=\"30%%\" ><font size=\"2\">%s</td>\n"
	      			"<td align=center width=\"15%%\" ><input type=\"checkbox\" name=\"select%d\" value=\"ON\"></td></tr>\n"),
					inet_ntoa(*((struct in_addr *)entry.ipAddr)),
					entry.atm_time, entry.comment, i);
		}
	}
	return nBytesSent;
}
#endif /*CONFIG_RTL_AIRTIME*/
/*----------------------------------------------------------------------------*/

#ifdef  CONFIG_RTL_P2P_SUPPORT
void generate_random_str(unsigned char *data,int len)
{
	char *String0Z="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
	int idx;	
	srand(time(0));   
	for(idx=0;idx<len;idx++){
		data[idx] = String0Z[ rand() % strlen(String0Z)];
	}
	data[len]='\0';
}

void generate_GO_ssid(void)

{
    unsigned char SSIDStr[33];    
	unsigned char tmpstr[3];
    int idx;

    for(idx=0;idx<33;idx++)
        memset(SSIDStr,'\0',33);
    
	generate_random_str(tmpstr,2);
    tmpstr[2]='\0';
    sprintf(SSIDStr,"DIRECT-%s-RTK",tmpstr);
    apmib_set(MIB_WLAN_SSID, (void *)SSIDStr);    
	SDEBUG("set SSID=[%s]\n",SSIDStr);	    
}
void generate_GO_PSK(void)

{
	unsigned char tmpstr[65];
	generate_random_str(tmpstr,8);
    tmpstr[8]='\0';
    apmib_set( MIB_WLAN_WPA_PSK, (void *)tmpstr);		    
    apmib_set( MIB_WLAN_WSC_PSK, (void *)tmpstr);		        

	SDEBUG("set PSK=[%s]\n",tmpstr);	
}	

#endif
int wlanHandler(request *wp, char *tmpBuf, int *mode, int wlan_id)
{
  char *strSSID, *strChan, *strDisabled, *strVal, strtmp[80];
	int chan, disabled ;
	NETWORK_TYPE_T net;
	char *strRate;
	int val=0; //WNC-NMR0000-Rita-20130306-Error_512-fix warnings of cppcheck (uninitialized value).
	char varName[32]={0}; //WNC-NMR0000-Rita-20130305-Error_69-enlarge array size from 20 to 32 to fix overrun issue..
	int band_no=0;
	int cur_band=0;
    #ifdef  CONFIG_RTL_P2P_SUPPORT
    p2p_query_which_interface=255;	
    #endif    
    //displayPostDate(wp->post_data);
	
	sprintf(varName, "wlanDisabled%d", wlan_id);
	strDisabled = req_get_cstream_var(wp, varName, "");
	if ( !strcmp(strDisabled, "ON"))
		disabled = 1;
	else
		disabled = 0;
	if ( apmib_set( MIB_WLAN_WLAN_DISABLED, (void *)&disabled) == 0) {
  		strcpy(tmpBuf, ("Set disabled flag error!"));
		goto setErr_wlan;
	}

	if ( disabled )
		return 0;

#ifdef WIFI_SIMPLE_CONFIG
	memset(&wps_config_info, 0, sizeof(struct wps_config_info_struct));
	wps_config_info.caller_id = CALLED_FROM_WLANHANDLER;
	apmib_get(MIB_WLAN_SSID, (void *)wps_config_info.ssid);	
	apmib_get(MIB_WLAN_MODE, (void *)&wps_config_info.wlan_mode);
#endif

	sprintf(varName, "regdomain%d", wlan_id);
	strVal = req_get_cstream_var(wp, varName, "");
	if(strVal[0]){
		apmib_get(MIB_HW_REG_DOMAIN, (void *)&val);
		if(val != atoi(strVal)){
			val=atoi(strVal);
			if ( apmib_set(MIB_HW_REG_DOMAIN, (void *)&val) == 0) {
					strcpy(tmpBuf, ("Set wlan regdomain error!"));
					goto setErr_wlan;
			}
			apmib_update(HW_SETTING);
		}
	}

	sprintf(varName, "countrystr%d", wlan_id);
	strVal = req_get_cstream_var(wp, varName, "");
	if(strVal[0]){
			if (apmib_set(MIB_WLAN_COUNTRY_STRING, (void *)strVal) == 0) {
					strcpy(tmpBuf, ("Set wlan countrystr error!"));
					goto setErr_wlan;
			}
	}

	sprintf(varName, "tx_restrict%d", wlan_id);
	strVal = req_get_cstream_var(wp, varName, "");
	if(strVal[0])
	{
		val=atoi(strVal);
		if (apmib_set(MIB_WLAN_TX_RESTRICT, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set MIB_WLAN_TX_RESTRICT error!"));
			goto setErr_wlan;
		}
	}

	sprintf(varName, "rx_restrict%d", wlan_id);
	strVal = req_get_cstream_var(wp, varName, "");
	if(strVal[0])
	{
		val=atoi(strVal);
		if (apmib_set(MIB_WLAN_RX_RESTRICT, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set MIB_WLAN_RX_RESTRICT error!"));
			goto setErr_wlan;
		}
	}

	sprintf(varName, "mode%d", wlan_id);
	strVal = req_get_cstream_var(wp, varName, "");

	if(strVal[0] == 0)
	{
		int val=0;

		apmib_get( MIB_WLAN_MODE, (void *)&val);
		sprintf(strtmp,"%d",val);
		strVal = strtmp;		
	}


	if ( strVal[0] ) {
#ifndef CONFIG_RTK_MESH
		if (strVal[0]!= '0' && strVal[0]!= '1' && strVal[0]!= '2' &&  strVal[0]!= '3'
#ifdef CONFIG_RTL_P2P_SUPPORT
		&&  strVal[0]!= '8'
#endif
		) {
#else
#ifdef CONFIG_NEW_MESH_UI
		if (strVal[0]!= '0' && strVal[0]!= '1' && strVal[0]!= '2' &&  strVal[0]!= '3' &&  strVal[0]!= '4' &&  strVal[0]!= '5' ) {
#else
		if (strVal[0]!= '0' && strVal[0]!= '1' && strVal[0]!= '2' &&  strVal[0]!= '3' &&  strVal[0]!= '4' &&  strVal[0]!= '5' &&  strVal[0]!= '6'&&  strVal[0]!= '7') {
#endif
#endif // CONFIG_RTK_MESH
			printf("%s\n",strVal[0]);
  			strcpy(tmpBuf, ("Invalid mode value!"));
			goto setErr_wlan;
		}
		*mode = strVal[0] - '0';

		if (*mode == CLIENT_MODE) {
			ENCRYPT_T encrypt;
      		apmib_get( MIB_WLAN_ENCRYPT,  (void *)&encrypt);
			if (encrypt &  ENCRYPT_WPA2_MIXED) {
				int format=0;//WNC-NMR0000-Rita-20130310-Error_538-fix warnings of cppcheck (uninitialized value).
				apmib_get( MIB_WLAN_WPA_AUTH, (void *)&format);
				if (format & 1) { // radius
#ifdef CONFIG_RTL_802_1X_CLIENT_SUPPORT
					//Support wlan client mode with Enterprise (RADIUS)
#else
					strcpy(tmpBuf, ("You cannot set client mode with Enterprise (RADIUS) !<br><br>Please change the encryption method in security page first."));
					goto setErr_wlan;
#endif
				}
			}
			else if (encrypt == ENCRYPT_WEP || encrypt == 0) {
				int use1x = 0;//WNC-NMR0000-Rita-20130305-Error_545-fix warnings of cppcheck (uninitialized value).
				apmib_get( MIB_WLAN_ENABLE_1X, (void *)&use1x);
				if (use1x & 1) {
#ifdef CONFIG_RTL_802_1X_CLIENT_SUPPORT
					//Support wlan client mode with Enterprise (RADIUS)
#else
					strcpy(tmpBuf, ("You cannot set client mode with 802.1x enabled!<br><br>Please change the encryption method in security page first."));
					goto setErr_wlan;
#endif
				}
			}
			sprintf(varName, "wlanMacClone%d", wlan_id);
			strVal = req_get_cstream_var(wp, varName, "");
			if ( !strcmp(strVal, "ON"))
				val = 1 ;
			else
				val = 0 ;
			if ( apmib_set( MIB_WLAN_MACCLONE_ENABLED, (void *)&val) == 0) {
				strcpy(tmpBuf, ("Set wlan Mac clone error!"));
				goto setErr_wlan;
			}
		}

		if ( apmib_set( MIB_WLAN_MODE, (void *)mode) == 0) {
   			strcpy(tmpBuf, ("Set MIB_WLAN_MODE error!"));
			goto setErr_wlan;
		}

#ifdef WLAN_EASY_CONFIG
		apmib_set( MIB_WLAN_EASYCFG_WLAN_MODE, (void *)mode);
#endif

	}

	sprintf(varName, "ssid%d", wlan_id);
   	strSSID = req_get_cstream_var(wp, varName, "");	
	if ( strSSID[0] ) {
		if ( apmib_set(MIB_WLAN_SSID, (void *)strSSID) == 0) {
   	 			strcpy(tmpBuf, ("Set SSID error!"));
				goto setErr_wlan;
		}
	}
	else if ( *mode == 1 && !strSSID[0] ) { // client and NULL SSID
		if ( apmib_set(MIB_WLAN_SSID, (void *)strSSID) == 0) {
   	 			strcpy(tmpBuf, ("Set SSID error!"));
				goto setErr_wlan;
		}
	}

	sprintf(varName, "chan%d", wlan_id);
	strChan = req_get_cstream_var(wp, varName, "");
	if ( strChan[0] ) {
		errno=0;
		chan = strtol( strChan, (char **)NULL, 10);
		if (errno) {
   			strcpy(tmpBuf, ("Invalid channel number!"));
			goto setErr_wlan;
		}
		if ( apmib_set( MIB_WLAN_CHANNEL, (void *)&chan) == 0) {
   			strcpy(tmpBuf, ("Set channel number error!"));
			goto setErr_wlan;
		}

		/* WNC-NMR0008-JOE-PENG-20120418-Fix wireless side band error on wireless client card */
		if ((chan>0) && (chan<5)) {
			/* Set control side to 1(Upper band) if channel is between 1 to 4. */
			val = 1;
		} else {
			/* Set control side to 0(Lower band) if channel is not between 1 to 4. */
			val = 0;
		}

		if ( apmib_set(MIB_WLAN_CONTROL_SIDEBAND, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set MIB_WLAN_CONTROL_SIDEBAND failed!"));
			goto setErr_wlan;
		}
		/* WNC-NMR0008-JOE-PENG-20120418-end */
	}

	sprintf(varName, "type%d", wlan_id);
	strVal = req_get_cstream_var(wp, varName, "");
	if (strVal[0]) {
		if (strVal[0]!= '0' && strVal[0]!= '1') {
  			strcpy(tmpBuf, ("Invalid network type value!"));
			goto setErr_wlan;
		}
		if (strVal[0] == '0')
			net = INFRASTRUCTURE;
		else
			net = ADHOC;
		if ( apmib_set(MIB_WLAN_NETWORK_TYPE, (void *)&net) == 0) {
			strcpy(tmpBuf, ("Set MIB_WLAN_NETWORK_TYPE failed!"));
			goto setErr_wlan;
		}
	}

	sprintf(varName, "band%d", wlan_id);
	strVal = req_get_cstream_var(wp, varName, "");
	if ( strVal[0] ) 
	{
		int wlan_onoff_tkip=0;//WNC-NMR0000-Rita-20130310-Error_589-fix warnings of cppcheck (uninitialized value).

		apmib_get( MIB_WLAN_11N_ONOFF_TKIP, (void *)&wlan_onoff_tkip);
				
		band_no = strtol( strVal, (char **)NULL, 10);
		if (band_no < 0 || band_no > 78) { //8812 //ac2g
  			strcpy(tmpBuf, ("Invalid band value!"));
			goto setErr_wlan;
		}
		//val = (strVal[0] - '0' + 1);
		if(wlan_onoff_tkip == 0) //Wifi request
		{
			int wpaCipher=0;//WNC-NMR0000-Rita-20130310-Error_598-fix warnings of cppcheck (uninitialized value).
			int wpa2Cipher=0;//WNC-NMR0000-Rita-20130310-Error_599-fix warnings of cppcheck (uninitialized value).
			int wdsEncrypt=0;//WNC-NMR0000-Rita-20130310-Error_600-fix warnings of cppcheck (uninitialized value).
			int wlan_encrypt=0;
			int encrypt;
			
			apmib_get( MIB_WLAN_ENCRYPT, (void *)&wlan_encrypt);
			apmib_get(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&wpaCipher);
			apmib_get(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&wpa2Cipher);
			apmib_get( MIB_WLAN_WDS_ENCRYPT, (void *)&wdsEncrypt);
			
			if(*mode != CLIENT_MODE && (band_no == 7 || band_no == 9 || band_no == 10 || band_no == 11 || band_no == 63 || band_no == 71 || band_no == 75)) //7:n; 9:gn; 10:bgn 11:5g_an
			{
				
				if(wlan_encrypt ==ENCRYPT_WPA || wlan_encrypt ==ENCRYPT_WPA2){
				wpaCipher &= ~WPA_CIPHER_TKIP;
					if(wpaCipher== 0)
						wpaCipher =  WPA_CIPHER_AES;
				//apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&wpaCipher);
				
				wpa2Cipher &= ~WPA_CIPHER_TKIP;
					if(wpa2Cipher== 0)
						wpa2Cipher =  WPA_CIPHER_AES;
				apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&wpa2Cipher);

				encrypt=WSC_ENCRYPT_AES;
				apmib_set(MIB_WLAN_WSC_ENC, (void *)&encrypt);
				}
				if(wdsEncrypt == WDS_ENCRYPT_TKIP)
				{
					wdsEncrypt = WDS_ENCRYPT_DISABLED;
					apmib_set( MIB_WLAN_WDS_ENCRYPT, (void *)&wdsEncrypt);
				}
			}		
		}
		val = (band_no + 1);
		if ( apmib_set( MIB_WLAN_BAND, (void *)&val) == 0) {
   			strcpy(tmpBuf, ("Set band error!"));
			goto setErr_wlan;
		}
		//change vap band when root ap band not include vap band
		int root_ap_band = val;
		//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140916, Fix bug 2681 (UNINIT) in StaticCodeCheck_Linear_Delta1.xls
		//int vap_idx,vap_val,tmp_i;
		int vap_idx, vap_val = 0, tmp_i;
		int old_vwlan_idx = vwlan_idx;

		for (vap_idx=1; vap_idx<=4; vap_idx++) {
			vwlan_idx = vap_idx; 
			apmib_get(MIB_WLAN_WLAN_DISABLED, (void *)&vap_val);
			if(!vap_val)//ON
			{
				apmib_get(MIB_WLAN_BAND, (void *)&vap_val);
				if(((vap_val&1) && (!(root_ap_band&1))) || ((vap_val&2) && (!(root_ap_band&2))) || ((vap_val&8) && (!(root_ap_band&8))) || ((vap_val&4) && (!(root_ap_band&4))) || ((vap_val&64) && (!(root_ap_band&64))))
				{
					apmib_set(MIB_WLAN_BAND, (void *)&root_ap_band);
					vap_val = 0;
					apmib_set(MIB_WLAN_BASIC_RATES, (void *)&vap_val);		
					apmib_set(MIB_WLAN_SUPPORTED_RATES, (void *)&vap_val);
					if(root_ap_band&8)//11N, no TKIP
					{
						//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140916, Fix bug 2687, 2688, 2689 (UNINIT) in StaticCodeCheck_Linear_Delta1.xls
						//int wpaCipher;
						//int wpa2Cipher;
						//int wlan_encrypt;						
						int wpaCipher = 0;
						int wpa2Cipher = 0;
						int wlan_encrypt = 0;
						apmib_get(MIB_WLAN_ENCRYPT, (void *)&wlan_encrypt);
						apmib_get(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&wpaCipher);
						apmib_get(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&wpa2Cipher);
						if(wlan_encrypt ==ENCRYPT_WPA || wlan_encrypt ==ENCRYPT_WPA2 || wlan_encrypt == ENCRYPT_WPA2_MIXED){
							wpaCipher &= ~WPA_CIPHER_TKIP;
							if(wpaCipher== 0)
								wpaCipher =  WPA_CIPHER_AES;
							//apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&wpaCipher);
							
							wpa2Cipher &= ~WPA_CIPHER_TKIP;
							if(wpa2Cipher== 0)
								wpa2Cipher =  WPA_CIPHER_AES;
							apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&wpa2Cipher);
						}
					}
				}
			}
		}
		vwlan_idx = old_vwlan_idx;
		
#if defined(CONFIG_RTL_8812_SUPPORT)
		{
			int band2G5GSelect = 0;
			strVal = req_get_cstream_var(wp, "Band2G5GSupport", ""); //wlan0 PHYBAND_TYPE
			if(strVal[0] != 0)
			{
				band2G5GSelect = atoi(strVal);
				printf("band2G5GSelect = %d\n", band2G5GSelect);
			}
			sprintf(varName,"wlan%d_phyband",wlan_id+1);
			strVal = req_get_cstream_var(wp, varName, "");

			if(band_no==3 || band_no==11 || band_no==63 || band_no==71 || band_no==75)
				val = 2;
			else if(band_no==7)
			{
				if(strVal[0] != 0)// from wizard
					if(memcmp(strVal,"5GHz",4) == 0)
						val = 2;
					else
						val = 1;
				else
				val = band2G5GSelect;
			}
			else
				val = 1;

			if ( apmib_set( MIB_WLAN_PHY_BAND_SELECT, (void *)&val) == 0) {
				strcpy(tmpBuf, ("Set band error!"));
					goto setErr_wlan;
			}
		}
#endif
	}

	// set tx rate
	sprintf(varName, "txRate%d", wlan_id);
	strRate = req_get_cstream_var(wp, varName, "");
	if ( strRate[0] ) {
		if ( strRate[0] == '0' ) { // auto
			val = 1;
			if ( apmib_set(MIB_WLAN_RATE_ADAPTIVE_ENABLED, (void *)&val) == 0) {
				strcpy(tmpBuf, ("Set rate adaptive failed!"));
				goto setErr_wlan;
			}
		}
		else  {
			val = 0;
			if ( apmib_set(MIB_WLAN_RATE_ADAPTIVE_ENABLED, (void *)&val) == 0) {
				strcpy(tmpBuf, ("Set rate adaptive failed!"));
				goto setErr_wlan;
			}  
			val = atoi(strRate);

			if(val<29)
				val = 1 << (val-1);
			else if(val>=29 && val<37)
				val = ((1<<28) + val-29);
			else
				val = ((1<<31) + val-37);
			
			if ( apmib_set(MIB_WLAN_FIX_RATE, (void *)&val) == 0) {
				strcpy(tmpBuf, ("Set fix rate failed!"));
				goto setErr_wlan;
			}
		}			
	}

	sprintf(varName, "basicrates%d", wlan_id);
	strRate = req_get_cstream_var(wp, varName, "");	
	if ( strRate[0] ) {
		val = atoi(strRate);		
		if ( apmib_set(MIB_WLAN_BASIC_RATES, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set Tx basic rate failed!"));
			goto setErr_wlan;
		}
	}

	sprintf(varName, "operrates%d", wlan_id);
	strRate = req_get_cstream_var(wp, varName, "");	
	if ( strRate[0] ) {
		val = atoi(strRate);
		if ( apmib_set(MIB_WLAN_SUPPORTED_RATES, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set Tx operation rate failed!"));
			goto setErr_wlan;
		}
	}

	// set hidden SSID
	sprintf(varName, "hiddenSSID%d", wlan_id);
	strVal = req_get_cstream_var(wp, varName, "");
	if (strVal[0]) {
		if ( strVal[0] == '0')
			val = 0;
		else if (strVal[0] == '1')
			val = 1;
		else {
			strcpy(tmpBuf, ("Error! Invalid Channel Bonding."));
			goto setErr_wlan;
		}
		if ( apmib_set(MIB_WLAN_HIDDEN_SSID, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set hidden ssid failed!"));
			goto setErr_wlan;
		}
	}
	sprintf(varName, "wlanwmm%d", wlan_id);
	strVal= req_get_cstream_var(wp, varName, "");
	if (strVal[0]) {
		if ( strVal[0] == '0')
			val = 0;
		else if (strVal[0] == '1')
			val = 1;
		else {
			strcpy(tmpBuf, ("Error! Invalid WMM value."));
			goto setErr_wlan;
		}
		if ( apmib_set(MIB_WLAN_WMM_ENABLED, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set MIB_WLAN_WMM_ENABLED failed!"));
			goto setErr_wlan;
		}
	}else{
		//enable wmm in 11N mode always
			apmib_get( MIB_WLAN_BAND, (void *)&cur_band);
			if(cur_band == 10 || cur_band ==11){
				val = 1;
				if ( apmib_set(MIB_WLAN_WMM_ENABLED, (void *)&val) == 0) {
					strcpy(tmpBuf, ("Set MIB_WLAN_WMM_ENABLED failed!"));
					goto setErr_wlan;
				}
			}
	}
// for 11N
	sprintf(varName, "channelbound%d", wlan_id);
	strVal = req_get_cstream_var(wp, varName, "");
	if (strVal[0]) {
		if ( strVal[0] == '0')
			val = 0;
		else if (strVal[0] == '1')
			val = 1;
		else if (strVal[0] == '2') //8812
		{
			val = 2;
		}
		else {
			strcpy(tmpBuf, ("Error! Invalid Channel Bonding."));
			goto setErr_wlan;
		}
		if ( apmib_set(MIB_WLAN_CHANNEL_BONDING, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set MIB_WLAN_CHANNEL_BONDING failed!"));
			goto setErr_wlan;
		}
	}

	sprintf(varName, "controlsideband%d", wlan_id);
	strVal= req_get_cstream_var(wp, varName, "");
	if (strVal[0]) {
		if ( strVal[0] == '0')
			val = 0;
		else if ( strVal[0] == '1')
			val = 1;
		else {
			strcpy(tmpBuf, ("Error! Invalid Control SideBand."));
			goto setErr_wlan;
		}
		if ( apmib_set(MIB_WLAN_CONTROL_SIDEBAND, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set MIB_WLAN_CONTROL_SIDEBAND failed!"));
			goto setErr_wlan;
		}
	}

//

	sprintf(varName, "basicrates%d", wlan_id);
	strRate = req_get_cstream_var(wp, varName, "");
	if ( strRate[0] ) {
		val = atoi(strRate);

		if ( val && apmib_set(MIB_WLAN_BASIC_RATES, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set Tx basic rate failed!"));
			goto setErr_wlan;
		}
	}

	sprintf(varName, "operrates%d", wlan_id);
	strRate = req_get_cstream_var(wp, varName, "");
	if ( strRate[0] ) {
		val = atoi(strRate);
		if ( val && apmib_set(MIB_WLAN_SUPPORTED_RATES, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set Tx operation rate failed!"));
			goto setErr_wlan;
		}
	}	//do twice ??

#ifdef UNIVERSAL_REPEATER
#ifdef CONFIG_RTL_P2P_SUPPORT
    if( *mode == 8)
    {
        SDEBUG("\n");    
        val=0;
        apmib_set(MIB_REPEATER_ENABLED1, (void *)&val);
        apmib_set(MIB_REPEATER_ENABLED2, (void *)&val);
    }
    else
#endif
    {	
        int id;
    	sprintf(varName, "repeaterEnabled%d", wlan_id);
    	strVal = req_get_cstream_var(wp, ("lan_ip"), "");
	
    	if ((strVal==NULL || strVal[0]==0)   // not called from wizard	
    			//&& (*mode != WDS_MODE)	&& (*mode != CLIENT_MODE)
    		) 
    		{
    		int rpt_enabled;
		
		/* WNC-MR0000-JOE-PENG-20130806-Fix bug that MIB_REPEATER_ENABLED1 is set to 0 if user set WIFI and not reboot. This cause status page incorrect in wireless WAN mode->start */
		if (wlan_id == 0)
			id = MIB_REPEATER_ENABLED1;
		else
			id = MIB_REPEATER_ENABLED2;
		apmib_get(id, (void *)&val);

		strVal = req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
    		if ( !strcmp(strVal, "ON")){
    			val = 1 ;
    		}else{
#ifdef  RTL_MULTI_REPEATER_MODE_SUPPORT		
                if (wlan_id == 0)
                    id = MIB_REPEATER_ENABLED1;
                else
                    id = MIB_REPEATER_ENABLED2;

                apmib_get(id, (void *)&rpt_enabled);

                if(rpt_enabled==2){
                    val = 2 ;
                }else
#endif
                {
                    val = 0 ;
                }
			}
            }
		/* WNC-MR0000-JOE-PENG-20130806-Fix bug that MIB_REPEATER_ENABLED1 is set to 0 if user set WIFI and not reboot. This cause status page incorrect in wireless WAN mode->end */
			
#if defined(CONFIG_RTL_ULINKER)
    		if (wlan_id == 0)
    			id = MIB_REPEATER_ENABLED1;
    		else
    			id = MIB_REPEATER_ENABLED2;
    		apmib_get(id, (void *)&rpt_enabled);
    		if(*mode == AP_MODE && rpt_enabled == 1) //ulinker repeater mode
    		{
    			val = 1;
    		}
#endif
			
    		if (wlan_id == 0)
    			id = MIB_REPEATER_ENABLED1;
    		else
    			id = MIB_REPEATER_ENABLED2;
			
    		if (*mode == AP_MODE || *mode == AP_WDS_MODE || *mode == AP_MESH_MODE)	/* NMR0000-[Aero]-20161011-patch: fmwlan-3411b.c */
	    		apmib_set(id, (void *)&val);

    		if (val == 1) {
    			sprintf(varName, "repeaterSSID%d", wlan_id);
			/* WNC-NMR0348-JOE-PENG-20130329-Fix Page Fault occurs during setting on GUI */
			strVal = req_get_cstream_var(wp, varName, "");
			if (strVal[0]){
    				if (wlan_id == 0)
    					id = MIB_REPEATER_SSID1;
    				else
    					id = MIB_REPEATER_SSID2;
    				setRepeaterSsid(wlan_id, id, strVal);
    			}
    		}

#ifdef MBSSID
    		int old_idx = vwlan_idx;
    		vwlan_idx = NUM_VWLAN_INTERFACE; // repeater interface
    		int disable;
    		if (val)
    			disable = 0;
    		else
    			disable = 1;		
    		apmib_set(MIB_WLAN_WLAN_DISABLED, (void *)&disable);

    		if (!disable) {
    			if (*mode == CLIENT_MODE)
    				val = AP_MODE;
    			else
    				val = CLIENT_MODE;
    			apmib_set(MIB_WLAN_MODE, (void *)&val);			
    			apmib_set(MIB_WLAN_SSID, (void *)strVal);			
    		}

    		if (val == CLIENT_MODE) {
    			// if client mode, check if Radius or mixed mode encryption is used
    			apmib_get(MIB_WLAN_ENCRYPT, (void *)&val);

    			if (val <= ENCRYPT_WEP) {				
    				apmib_get( MIB_WLAN_ENABLE_1X, (void *)&val);
    				if (val != 0) {
    					val = 0;
    					apmib_set( MIB_WLAN_ENABLE_1X, (void *)&val);				
    				}
    			}	
    			else if (val == ENCRYPT_WPA2_MIXED) {
					apmib_get(MIB_WLAN_WPA_AUTH, (void *)&val);
    				if ((val == 0) || (val & 1)) { // if no or radius, force to psk
    					val = 2;
    					apmib_set(MIB_WLAN_WPA_AUTH, (void *)&val);
    				}
					//when mixed mode set both tkip and aes
					val = WPA_CIPHER_MIXED;
					apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&val);	
					apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&val);	
    			}
    			else if (val == ENCRYPT_WPA) {	
    				apmib_get(MIB_WLAN_WPA_AUTH, (void *)&val);
    				if ((val == 0) || (val & 1)) { // if no or radius, force to psk
    					val = 2;
    					apmib_set(MIB_WLAN_WPA_AUTH, (void *)&val);
    				}				
    				apmib_get(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&val);
    				if ((val == 0) || (val == WPA_CIPHER_MIXED)) {
    					val = WPA_CIPHER_AES;
    					//apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&val);					
    				}
    			}
    			else if (val == ENCRYPT_WPA2) {	
    				apmib_get(MIB_WLAN_WPA_AUTH, (void *)&val);
    				if ((val == 0) || (val & 1)) { // if no or radius, force to psk
    					val = 2;
    					apmib_set(MIB_WLAN_WPA_AUTH, (void *)&val);
    				}				
    				apmib_get(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&val);
    				if ((val == 0) || (val == WPA_CIPHER_MIXED)) {
    					val = WPA_CIPHER_AES;
    					apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&val);					
    				}
    			}	
    		}

    		vwlan_idx = old_idx;
#endif	
    	}
    	else{ //call from wizard
    		if(*mode == WDS_MODE || *mode == CLIENT_MODE){
    			if (wlan_id == 0)
    				id = MIB_REPEATER_ENABLED1;
    			else
    				id = MIB_REPEATER_ENABLED2;
    			val = 0;
    			apmib_set(id, (void *)&val);
    		}
    	}
    }
#endif

#ifdef WIFI_SIMPLE_CONFIG
	sprintf(varName, "wps_clear_configure_by_reg%d", wlan_id);
	/* WNC-NMR0348-JOE-PENG-20130329-Fix Page Fault occurs during setting on GUI */
	strVal = req_get_cstream_var(wp, varName, "");
	val = 0;
	if (strVal && strVal[0])
		val = atoi(strVal);
	update_wps_configured(val);
#endif
#ifdef  CONFIG_RTL_P2P_SUPPORT
        if(*mode == P2P_SUPPORT_MODE){
            unsigned char WPA2PSKstr[65];
            int p2p_type = 0;            
            int val2 ;
        
            p2p_type = P2P_DEVICE;            // default p2p dev
            apmib_set( MIB_WLAN_P2P_TYPE, (void *)&p2p_type);// default as GO            

            /*disabled DHCP*/
            val2=0;
            apmib_set( MIB_DHCP, (void *)&val2);

            if(p2p_type == P2P_TMP_GO){
                /*if P2P type is GO, prepare GO's SSID*/                
                sprintf(varName, "ssid%d", wlan_id);
                strSSID = req_get_cstream_var(wp, varName, ""); 
                if ( strSSID[0] ) {
                    if(strncmp(strSSID,"DIRECT-",7) || strlen(strSSID)<9){
                        SDEBUG("\n");                    
                        generate_GO_ssid();
                    }
                }else{
                    SDEBUG("\n");
                    generate_GO_ssid();
                }            

                 /*if P2P type is GO, WPA2-AES,and PSK*/                                
                val2=4;
                apmib_set( MIB_WLAN_ENCRYPT, (void *)&val2);                
                val2=2;            
                apmib_set( MIB_WLAN_AUTH_TYPE, (void *)&val2);
                val2=2;
                apmib_set( MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&val2);

                /*MIB_WLAN_WPA_PSK ;MIB_WLAN_WSC_PSK */            


                apmib_get( MIB_WLAN_WPA_PSK, (void *)WPA2PSKstr);		                    
                if(strlen(WPA2PSKstr)<8)
                    generate_GO_PSK();

                val2=1;
                apmib_set( MIB_WLAN_WSC_CONFIGURED, (void *)&val2);                
                val2=32;            
                apmib_set( MIB_WLAN_WSC_AUTH, (void *)&val2);                
                val2=8;            
                apmib_set( MIB_WLAN_WSC_ENC, (void *)&val2);                                         

            }
      }                
#endif //end of CONFIG_RTL_P2P_SUPPORT

	return  0;
setErr_wlan:
	return -1 ;
}

/* WNC-NMR0000-Rita-20130122-Wlan basic setting handler */
int wlanWncBasicHandler(request *wp, char *tmpBuf)
{
  	char *strDisabled, *strVal;
	int disabled ;
	int val;
	char varName[20];

	//Rita--TODO-if both radios disables need to return
	/*
	sprintf(varName, "wlanDisabled%d", wlan_id);
	strDisabled = req_get_cstream_var(wp, varName, "");
	if ( !strcmp(strDisabled, "ON"))
		disabled = 1;
	else
		disabled = 0;
	if ( apmib_set( MIB_WLAN_WLAN_DISABLED, (void *)&disabled) == 0) {
  		strcpy(tmpBuf, ("Set disabled flag error!"));
		goto setErr_wlan;
	}

	if ( disabled )
		return 0; 
	*/

int wlanIdx=0;
for(wlanIdx=0; wlanIdx < NUM_WLAN_INTERFACE; wlanIdx++){
#ifdef WIFI_SIMPLE_CONFIG
		unsigned char wlanif[10];
		memset(wlanif,0x00,sizeof(wlanif));
		sprintf(wlanif, "wlan%d",wlanIdx);
		SetWlan_idx(wlanif);
	memset(&wps_config_info, 0, sizeof(struct wps_config_info_struct));
	wps_config_info.caller_id = CALLED_FROM_WLANHANDLER;
	apmib_get(MIB_WLAN_SSID, (void *)wps_config_info.ssid);
	apmib_get(MIB_WLAN_MODE, (void *)&wps_config_info.wlan_mode);

	/* WNC-MR0000-Libera-20120515- WPS for NEC */
	sprintf(varName, "wps");	//only fow root AP
	strVal = req_get_cstream_var(wp, varName, "");
	if (strVal[0]) {
		if ( strVal[0] == '1')
			val = 1;
		else if (strVal[0] == '2')
			val = 2;
		else if (strVal[0] == '3')
			val = 3;		
		else {
			strcpy(tmpBuf, ("Error! Invalid WPS TYPE."));
			goto setErr_wlan;
		}
		if ( apmib_set(MIB_WLAN_WSC_TYPE, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set WPS type failed!"));
			goto setErr_wlan;
		}
	}
	/* WNC-MR0000-Libera-20120515- WPS for NEC -END*/
#endif
	
#ifdef WIFI_SIMPLE_CONFIG  //Rita-TODO: does it need? wlan_id??
	//sprintf(varName, "wps_clear_configure_by_reg%d", wlan_id); //rita--
	/* WNC-NMR0348-JOE-PENG-20130329-Fix Page Fault occurs during setting on GUI */
	//strVal = req_get_cstream_var(wp, varName, ""); //rita--
	strVal = req_get_cstream_var(wp, "wps_clear_configure_by_reg", "");
	val = 0;
	if (strVal[0])
		val = atoi(strVal);
	update_wps_configured(val);
#if 0	/* WNC-MR000-Libera-20130703- Pocket spec.: change interface: wlan0->wlan0-va0, wlan0-va0->wlan0-va1 (2) */
		int tmp_vwlan_idx=0, tmp_wlan_idx=0;
		tmp_wlan_idx=wlan_idx;
		tmp_vwlan_idx=vwlan_idx;
		wlan_idx = 0;		//radio0
		vwlan_idx = 1;	//wlan0-va0
		update_wps_configured(val);
		wlan_idx = tmp_wlan_idx;
		vwlan_idx = tmp_vwlan_idx;
#endif	
#endif
} //end of for-loop-Apply WPS to both dual radios 
	return  0;
setErr_wlan:
	return -1 ;
}
#if 1	/* WNC-NMR000-[Aero/Thalys]-Libera-20160606- responsive GUI porting-start */
enum {
	NOTHING = 0,
	COPY5GTO2G = 1,
	RECOVER2G = 2,
	UPDATE5GTO2G =3	/* WNC-NMR1795-[Aero]-20160921- [request] [Bandsteering]: 2G sync. 5G*/
};

int copy5gto2g(int copy)
{
	char ssid_bak[MAX_SSID_LEN]={0}, ssid_2g[MAX_SSID_LEN]={0},ssid_5g[MAX_SSID_LEN]={0}; 
	ENCRYPT_T encrypt_bak, encrypt_2g,encrypt_5g;
	WPA_CIPHER_T wpa_cipher_bak,wpa2_cipher_bak,wpa_cipher_2g,wpa2_cipher_2g,wpa_cipher_5g,wpa2_cipher_5g;	/* WNC-NMR000-[Aero/Thalys]-Libera-20160803- Taking over setting value_+bandsteering */
	char key_bak[500], key_2g[500],key_5g[500];
	int rkey_bak=0,rkey_2g=0,rkey_5g=0;
	int block_bak=0,block_2g=0,block_5g=0;
	int hidden_bak=0,hidden_2g=0,hidden_5g=0;
	int macac_bak=0,macac_2g=0,macac_5g=0;
	int cp5gto2g=0, isBakDiffer2g=0, is5gDiffer2g=0, bandsteer=0;

	//printf("WNC: Func: %s, Line: %d\n",__FUNCTION__ , __LINE__);
	apmib_get(MIB_WLAN_BAND_STEER, (void *)&bandsteer);
	apmib_get(MIB_WLAN_COPY_5GTO2G, (void *)&cp5gto2g);

#if 1	//Get backup mib	
	printf("copy5gto2g(%d)\n",copy);
	apmib_get(MIB_WLAN_SSID_BAK, (void *)ssid_bak);
	
	apmib_get(MIB_WLAN_ENCRYPT_BAK, (void *)&encrypt_bak);	
	key_bak[0]='\0';
	apmib_get(MIB_WLAN_WPA_PSK_BAK, (void *)key_bak);
	apmib_get( MIB_WLAN_WPA_GROUP_REKEY_TIME_BAK, (void *)&rkey_bak);
	apmib_get( MIB_WLAN_BLOCK_RELAY_BAK, (void *)&block_bak);
	apmib_get( MIB_WLAN_HIDDEN_SSID_BAK, (void *)&hidden_bak);
	apmib_get( MIB_WLAN_MACAC_ENABLED_BAK, (void *)&macac_bak); 
	apmib_get( MIB_WLAN_WPA_CIPHER_SUITE_BAK, (void *)&wpa_cipher_bak);
	apmib_get( MIB_WLAN_WPA2_CIPHER_SUITE_BAK, (void *)&wpa2_cipher_bak);
	printf("[BandSteering][backup MIB]ssid=%s, encrypt=%d, key=%s, rkey=%d, block=%d, hidden=%d, macac=%d, wpa_cipher_bak=%d, wpa2_cipher_bak=%d\n",ssid_bak,encrypt_bak,key_bak,rkey_bak,block_bak,hidden_bak,macac_bak,wpa_cipher_bak,wpa2_cipher_bak);
#endif
#if 1	//Get 2g mib
	apmib_save_wlanIdx();
	SetWlan_idx("wlan0"); 

	apmib_get(MIB_WLAN_SSID, (void *)ssid_2g);
	apmib_get(MIB_WLAN_ENCRYPT, (void *)&encrypt_2g);
	key_2g[0]='\0';
	apmib_get(MIB_WLAN_WPA_PSK, (void *)key_2g);
	apmib_get( MIB_WLAN_WPA_GROUP_REKEY_TIME, (void *)&rkey_2g);
	apmib_get( MIB_WLAN_BLOCK_RELAY, (void *)&block_2g);
	apmib_get( MIB_WLAN_HIDDEN_SSID, (void *)&hidden_2g);
	apmib_get( MIB_WLAN_MACAC_ENABLED, (void *)&macac_2g);	
	apmib_get( MIB_WLAN_WPA_CIPHER_SUITE, (void *)&wpa_cipher_2g);
	apmib_get( MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&wpa2_cipher_2g);
	apmib_recov_wlanIdx();	
	printf("[BandSteering][2G MIB]ssid=%s, encrypt=%d, key=%s, rkey=%d, block=%d, hidden=%d, macac=%d, wpa_cipher=%d, wpa2_cipher=%d\n",ssid_2g,encrypt_2g,key_2g,rkey_2g,block_2g,hidden_2g,macac_2g, wpa_cipher_2g,wpa2_cipher_2g);
#endif
#if 1	//Get 5g mib
	apmib_save_wlanIdx();
	SetWlan_idx("wlan1"); 

	apmib_get(MIB_WLAN_SSID, (void *)ssid_5g);
	apmib_get(MIB_WLAN_ENCRYPT, (void *)&encrypt_5g);
	key_5g[0]='\0';
	apmib_get(MIB_WLAN_WPA_PSK, (void *)key_5g);
	apmib_get( MIB_WLAN_WPA_GROUP_REKEY_TIME, (void *)&rkey_5g);
	apmib_get( MIB_WLAN_BLOCK_RELAY, (void *)&block_5g);
	apmib_get( MIB_WLAN_HIDDEN_SSID, (void *)&hidden_5g);
	apmib_get( MIB_WLAN_MACAC_ENABLED, (void *)&macac_5g);
	apmib_get( MIB_WLAN_WPA_CIPHER_SUITE, (void *)&wpa_cipher_5g);
	apmib_get( MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&wpa2_cipher_5g);
	apmib_recov_wlanIdx();	
	printf("[BandSteering][5G MIB]ssid=%s, encrypt=%d, key=%s, rkey=%d, block=%d, hidden=%d, macac=%d, wpa_cipher=%d, wpa2_cipher=%d \n",ssid_5g,encrypt_5g,key_5g,rkey_5g,block_5g,hidden_5g,macac_5g,wpa_cipher_5g,wpa2_cipher_5g);
#endif

#if 1	/* Diff backup data and 2G */
	if (strcmp(ssid_bak,ssid_2g) ||	/* WNC-NMR2687-Libera-20171026 - string wasn't compared completely *///if (memcmp(ssid_bak,ssid_2g,strlen(ssid_2g)) ||
			(encrypt_bak!=encrypt_2g) || 
			strcmp(key_bak,key_2g) ||/* WNC-NMR2687-Libera-20171026 - string wasn't compared completely *///memcmp(key_bak,key_2g,strlen(key_2g)) ||
			(rkey_bak != rkey_2g) ||
			(block_bak != block_2g) ||
			(hidden_bak != hidden_2g) ||
			(macac_bak != macac_2g))
	{
		printf("[BandSteering] BAK differs 2G !\n");
		isBakDiffer2g=1;
	}
#endif

#if 1	/* Diff 2G and 5G */
	if (strcmp(ssid_5g,ssid_2g) ||  /* WNC-NMR2687-Libera-20171026 - string wasn't compared completely *///if (memcmp(ssid_5g,ssid_2g,strlen(ssid_2g)) ||
			(encrypt_5g!=encrypt_2g) || 
			strcmp(key_5g,key_2g) ||		 /* WNC-NMR2687-Libera-20171026 - string wasn't compared completely *///memcmp(key_5g,key_2g,strlen(key_2g)) ||
			(rkey_5g != rkey_2g) ||
			(block_5g != block_2g) ||
			(hidden_5g != hidden_2g) ||
			(macac_5g != macac_2g))
	{
		printf("[BandSteering] 2G differs 5G !\n");
		is5gDiffer2g=1;
	}
#endif

	printf("[BandSteering] bandsteer=%d, cp5gto2g=%d, is5gDiffer2g=%d, isBakDiffer2g=%d\n",bandsteer,cp5gto2g,is5gDiffer2g, isBakDiffer2g);

	switch (copy) {
		case COPY5GTO2G:
			if ((bandsteer==1) && ((isBakDiffer2g==1) || (is5gDiffer2g==1)) && (cp5gto2g != 1)){	//cp5gto2g is unchanged config.
				printf("[BandSteering] Backup 2G profile !\n");
				/* Backup 2G profile */
#if 1	
				//printf("copy5gto2g(%d)\n",copy);
				apmib_set( MIB_WLAN_SSID_BAK, (void *)ssid_2g);
				apmib_set( MIB_WLAN_ENCRYPT_BAK, (void *)&encrypt_2g);	
				//key_2g[0]='\0';
				apmib_set( MIB_WLAN_WPA_PSK_BAK, (void *)key_2g);
				apmib_set( MIB_WLAN_WPA_GROUP_REKEY_TIME_BAK, (void *)&rkey_2g);
				apmib_set( MIB_WLAN_BLOCK_RELAY_BAK, (void *)&block_2g);
				apmib_set( MIB_WLAN_HIDDEN_SSID_BAK, (void *)&hidden_2g);
				apmib_set( MIB_WLAN_MACAC_ENABLED_BAK, (void *)&macac_2g); 
				apmib_set( MIB_WLAN_WPA_CIPHER_SUITE_BAK, (void *)&wpa_cipher_2g);
				apmib_set( MIB_WLAN_WPA2_CIPHER_SUITE_BAK, (void *)&wpa2_cipher_2g);
				//printf("[backup MIB]ssid=%s, encrypt=%d, key=%s, rkey=%d, block=%d, hidden=%d, macac=%d\n",ssid_bak,encrypt_bak,key_bak,rkey_bak,block_bak,hidden_bak,macac_bak);
#endif

				/* Copy 5G to 2G */
#if 1
				printf("[BandSteering] Copy 5G to 2G !\n");

				apmib_save_wlanIdx();
				SetWlan_idx("wlan0"); 
			
				apmib_set(MIB_WLAN_SSID, (void *)ssid_5g);
				apmib_set(MIB_WLAN_ENCRYPT, (void *)&encrypt_5g);
				//key_5g[0]='\0';
				apmib_set(MIB_WLAN_WPA_PSK, (void *)key_5g);
				apmib_set( MIB_WLAN_WPA_GROUP_REKEY_TIME, (void *)&rkey_5g);
				apmib_set( MIB_WLAN_BLOCK_RELAY, (void *)&block_5g);
				apmib_set( MIB_WLAN_HIDDEN_SSID, (void *)&hidden_5g);
				apmib_set( MIB_WLAN_MACAC_ENABLED, (void *)&macac_5g);
				/* WNC-NMR1816-[Aero]-Libera-20160919-comment2: cipher is wrong.-start */
				apmib_set( MIB_WLAN_WPA_CIPHER_SUITE, (void *)&wpa_cipher_5g);
				apmib_set( MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&wpa2_cipher_5g);
				/* WNC-NMR1816-[Aero]-Libera-20160919-comment2: cipher is wrong.-end */
				/* NMR2140-[Aero]-20161202 - BandSteering updates WSC-start */
				wps_config_info.caller_id = CALLED_FROM_WLANHANDLER;
				update_wps_configured(0); 
				wps_config_info.caller_id = CALLED_FROM_WPAHANDLER;
				update_wps_configured(0);
				/* NMR2140-[Aero]-20161202 - BandSteering updates WSC-end */
				apmib_recov_wlanIdx();	
				//printf("[2G MIB]ssid=%s, encrypt=%d, key=%s, rkey=%d, block=%d, hidden=%d, macac=%d\n",ssid_2g,encrypt_2g,key_2g,rkey_2g,block_2g,hidden_2g,macac_2g);
#endif	
			}
			break;
		case RECOVER2G:
			if ((bandsteer==0) && (isBakDiffer2g==1) && (is5gDiffer2g==0) && (cp5gto2g==1 || cp5gto2g==3)){	//cp5gto2g is unchanged config. /* WNC-NMR1795-[Aero]-20160921- [request] [Bandsteering]: 2G sync. 5G*/
				printf("[BandSteering] Rollback to 2G !\n");
				/* Rollback to 2G */
#if 1
				apmib_save_wlanIdx();
				SetWlan_idx("wlan0");
				apmib_set(MIB_WLAN_SSID, (void *)ssid_bak);
				apmib_set(MIB_WLAN_ENCRYPT, (void *)&encrypt_bak);
				//key_bak[0]='\0';
				apmib_set(MIB_WLAN_WPA_PSK, (void *)key_bak);
				apmib_set( MIB_WLAN_WPA_GROUP_REKEY_TIME, (void *)&rkey_bak);
				apmib_set( MIB_WLAN_BLOCK_RELAY, (void *)&block_bak);
				apmib_set( MIB_WLAN_HIDDEN_SSID, (void *)&hidden_bak);
				apmib_set( MIB_WLAN_MACAC_ENABLED, (void *)&macac_bak);
				/* WNC-NMR1816-[Aero]-Libera-20160919-comment2: cipher is wrong.-start */
				apmib_set( MIB_WLAN_WPA_CIPHER_SUITE, (void *)&wpa_cipher_bak);
				apmib_set( MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&wpa2_cipher_bak);
				/* WNC-NMR1816-[Aero]-Libera-20160919-comment2: cipher is wrong.-end */
				/* NMR2140-[Aero]-20161202 - BandSteering updates WSC-start */
				wps_config_info.caller_id = CALLED_FROM_WLANHANDLER;
				update_wps_configured(0); 
				wps_config_info.caller_id = CALLED_FROM_WPAHANDLER;
				update_wps_configured(0);
				/* NMR2140-[Aero]-20161202 - BandSteering updates WSC-end */
				apmib_recov_wlanIdx();
				//printf("[2G MIB]ssid=%s, encrypt=%d, key=%s, rkey=%d, block=%d, hidden=%d, macac=%d\n",ssid_2g,encrypt_2g,key_2g,rkey_2g,block_2g,hidden_2g,macac_2g);
#endif
			}
			break;
		case UPDATE5GTO2G:	/* WNC-NMR1795-[Aero]-20160921- [request] [Bandsteering]: 2G sync. 5G*/
			printf("[BandSteering] UPDATE 5G TO 2G!\n");
#if 1
			apmib_save_wlanIdx();
			SetWlan_idx("wlan0"); 
		
			apmib_set(MIB_WLAN_SSID, (void *)ssid_5g);
			apmib_set(MIB_WLAN_ENCRYPT, (void *)&encrypt_5g);
			//key_5g[0]='\0';
			apmib_set(MIB_WLAN_WPA_PSK, (void *)key_5g);
			apmib_set( MIB_WLAN_WPA_GROUP_REKEY_TIME, (void *)&rkey_5g);
			apmib_set( MIB_WLAN_BLOCK_RELAY, (void *)&block_5g);
			apmib_set( MIB_WLAN_HIDDEN_SSID, (void *)&hidden_5g);
			apmib_set( MIB_WLAN_MACAC_ENABLED, (void *)&macac_5g);
			/* WNC-NMR1816-[Aero]-Libera-20160919-comment2: cipher is wrong.-start */
			apmib_set( MIB_WLAN_WPA_CIPHER_SUITE, (void *)&wpa_cipher_5g);
			apmib_set( MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&wpa2_cipher_5g);
			/* WNC-NMR1816-[Aero]-Libera-20160919-comment2: cipher is wrong.-end */
			/* NMR2140-[Aero]-20161202 - BandSteering updates WSC-start */
			wps_config_info.caller_id = CALLED_FROM_WLANHANDLER;
			update_wps_configured(0); 
			wps_config_info.caller_id = CALLED_FROM_WPAHANDLER;
			update_wps_configured(0);
			/* NMR2140-[Aero]-20161202 - BandSteering updates WSC-end */
			apmib_recov_wlanIdx();	
			printf("[2G MIB]ssid=%s, encrypt=%d, key=%s, rkey=%d, block=%d, hidden=%d, macac=%d\n",ssid_2g,encrypt_2g,key_2g,rkey_2g,block_2g,hidden_2g,macac_2g);
#endif
			break;
		case NOTHING:
			printf("Won't copy\n");
		default:
			break;
	}	
	

	

	return 0;
}
#endif	/* WNC-NMR000-[Aero/Thalys]-Libera-20160606- responsive GUI porting-end */

#if 1 /* WNC-MR0000-Libera-20120308- wlan, advanced, multi-ap, and security all in one for Cheeper. */
int wlanWncHandler(request *wp, char *tmpBuf, int *mode, int wlan_id)
{
  char *strSSID, *strChan, *strDisabled, *strVal, strtmp[20], *strProtection, *strValue , *strPower, *strEnabled;
	int chan, disabled=0 ;
	NETWORK_TYPE_T net;
	char *strRate;
	int val, old_vwlan_idx, idx, enabled;
	char varName[32]={0}; //WNC-NMR0000-Rita-20130305-Error_72-enlarge array size from 20 to 32 to fix overrun issue.
	int band_no=0;
	int cur_band=0;

//displayPostDate(wp->post_data);

	sprintf(varName, "wlanDisabled%d", wlan_id);
	strDisabled = req_get_cstream_var(wp, varName, "");
	if(*strDisabled){
	if ( !strcmp(strDisabled, "ON"))
		disabled = 1;
	else
		disabled = 0;
	if ( apmib_set( MIB_WLAN_WLAN_DISABLED, (void *)&disabled) == 0) {
  		strcpy(tmpBuf, ("Set disabled flag error!"));
		goto setErr_wlan;
	}
	}
	if ( disabled )
		return 0;

#ifdef WIFI_SIMPLE_CONFIG
	memset(&wps_config_info, 0, sizeof(struct wps_config_info_struct));
	wps_config_info.caller_id = CALLED_FROM_WLANHANDLER;
	apmib_get(MIB_WLAN_SSID, (void *)wps_config_info.ssid);
	apmib_get(MIB_WLAN_MODE, (void *)&wps_config_info.wlan_mode);

	/* WNC-MR0000-Libera-20120515- WPS for NEC */
	sprintf(varName, "wps");	//only for root AP
	strVal = req_get_cstream_var(wp, varName, "");
	if (strVal[0]) {
		if ( strVal[0] == '1')	//RakuRaku
			val = 1;
		else if (strVal[0] == '2')	//WPS
			val = 2;
		else if (strVal[0] == '3')	//auto
			val = 3;
		else {
			strcpy(tmpBuf, ("Error! Invalid WPS TYPE."));
			goto setErr_wlan;
		}
		if ( apmib_set(MIB_WLAN_WSC_TYPE, (void *)&val) == 0) {	//check vap0 and root setting!
			strcpy(tmpBuf, ("Set WPS type failed!"));
			goto setErr_wlan;
		}
	}
	/* WNC-MR0000-Libera-20120515- WPS for NEC -END*/
#endif

	sprintf(varName, "regdomain%d", wlan_id);
	strVal = req_get_cstream_var(wp, varName, "");
	if(strVal[0]){
		apmib_get(MIB_HW_REG_DOMAIN, (void *)&val);
		if(val != atoi(strVal)){
			val=atoi(strVal);
			if ( apmib_set(MIB_HW_REG_DOMAIN, (void *)&val) == 0) {
					strcpy(tmpBuf, ("Set wlan regdomain error!"));
					goto setErr_wlan;
			}
			apmib_update(HW_SETTING);
		}
	}

	sprintf(varName, "countrystr%d", wlan_id);
	strVal = req_get_cstream_var(wp, varName, "");
	if(strVal[0]){
			if (apmib_set(MIB_WLAN_COUNTRY_STRING, (void *)strVal) == 0) {
					strcpy(tmpBuf, ("Set wlan countrystr error!"));
					goto setErr_wlan;
			}
	}

	sprintf(varName, "mode%d", wlan_id);
	strVal = req_get_cstream_var(wp, varName, "");

	if(strVal[0] == 0)
	{
		int val;

		apmib_get( MIB_WLAN_MODE, (void *)&val);
		sprintf(strtmp,"%d",val);
		strVal = strtmp;
	}


	if ( strVal[0] ) {
#ifndef CONFIG_RTK_MESH
		if (strVal[0]!= '0' && strVal[0]!= '1' && strVal[0]!= '2' &&  strVal[0]!= '3'
#ifdef CONFIG_RTL_P2P_SUPPORT
		&&  strVal[0]!= '8'
#endif
		) {
#else
#ifdef CONFIG_NEW_MESH_UI
		if (strVal[0]!= '0' && strVal[0]!= '1' && strVal[0]!= '2' &&  strVal[0]!= '3' &&  strVal[0]!= '4' &&  strVal[0]!= '5' ) {
#else
		if (strVal[0]!= '0' && strVal[0]!= '1' && strVal[0]!= '2' &&  strVal[0]!= '3' &&  strVal[0]!= '4' &&  strVal[0]!= '5' &&  strVal[0]!= '6'&&  strVal[0]!= '7') {
#endif
#endif // CONFIG_RTK_MESH
			printf("%s\n",strVal[0]);
  			strcpy(tmpBuf, ("Invalid mode value!"));
			goto setErr_wlan;
		}
		*mode = strVal[0] - '0';

		if (*mode == CLIENT_MODE) {
			ENCRYPT_T encrypt;
      		apmib_get( MIB_WLAN_ENCRYPT,  (void *)&encrypt);
			if (encrypt &  ENCRYPT_WPA2_MIXED) {
				int format;
				apmib_get( MIB_WLAN_WPA_AUTH, (void *)&format);
				if (format & 1) { // radius
#ifdef CONFIG_RTL_802_1X_CLIENT_SUPPORT
					//Support wlan client mode with Enterprise (RADIUS)
#else
					strcpy(tmpBuf, ("You cannot set client mode with Enterprise (RADIUS) !<br><br>Please change the encryption method in security page first."));
					goto setErr_wlan;
#endif
				}
			}
			else if (encrypt == ENCRYPT_WEP || encrypt == 0) {
				int use1x;
				apmib_get( MIB_WLAN_ENABLE_1X, (void *)&use1x);
				if (use1x & 1) {
#ifdef CONFIG_RTL_802_1X_CLIENT_SUPPORT
					//Support wlan client mode with Enterprise (RADIUS)
#else
					strcpy(tmpBuf, ("You cannot set client mode with 802.1x enabled!<br><br>Please change the encryption method in security page first."));
					goto setErr_wlan;
#endif
				}
			}
			sprintf(varName, "wlanMacClone%d", wlan_id);
			strVal = req_get_cstream_var(wp, varName, "");
			if ( !strcmp(strVal, "ON"))
				val = 1 ;
			else
				val = 0 ;
			if ( apmib_set( MIB_WLAN_MACCLONE_ENABLED, (void *)&val) == 0) {
				strcpy(tmpBuf, ("Set wlan Mac clone error!"));
				goto setErr_wlan;
			}
		}

		if ( apmib_set( MIB_WLAN_MODE, (void *)mode) == 0) {
   			strcpy(tmpBuf, ("Set MIB_WLAN_MODE error!"));
			goto setErr_wlan;
		}

#ifdef WLAN_EASY_CONFIG
		apmib_set( MIB_WLAN_EASYCFG_WLAN_MODE, (void *)mode);
#endif

	}

	sprintf(varName, "ssid%d", wlan_id);
   	strSSID = req_get_cstream_var(wp, varName, "");

	/* WNC-NMR000-[Aero/Thalys]-MIKE-YEH-20160824-error check on server side. */
	if(lw_NullCheck(strSSID) == -1 || lw_SsidNameCheck(strSSID) == -1)
	{
		send_redirect_perm(wp, LW_GUI_INPUT_ERR_PAGE);
		return;
	}

	if ( strSSID[0] ) {
		if ( apmib_set(MIB_WLAN_SSID, (void *)strSSID) == 0) {
   	 			strcpy(tmpBuf, ("Set SSID error!"));
				goto setErr_wlan;
		}
	}
	else if ( *mode == 1 && !strSSID[0] ) { // client and NULL SSID
		if ( apmib_set(MIB_WLAN_SSID, (void *)strSSID) == 0) {
   	 			strcpy(tmpBuf, ("Set SSID error!"));
				goto setErr_wlan;
		}
	}

	/* WNC-NMR0372-Rita-20130409-WLAN_CHANNEL_BONDING should be saved to MIB before WLAN_CHANNEL */
	// for 11N
	sprintf(varName, "channelbound%d", wlan_id);
	strVal = req_get_cstream_var(wp, varName, "");
	if (strVal[0]) {
		if ( strVal[0] == '0')
			val = 0;
		else if (strVal[0] == '1')
			val = 1;
		//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20130103, Apply Realtek SDK 3.3.1 Alpha Patch
		else if (strVal[0] == '2') //8812
		{
			val = 2;
		}
		//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20130103, Apply Realtek SDK 3.3.1
		else {
			strcpy(tmpBuf, ("Error! Invalid Channel Bonding."));
			goto setErr_wlan;
		}
		if ( apmib_set(MIB_WLAN_CHANNEL_BONDING, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set MIB_WLAN_CHANNEL_BONDING failed!"));
			goto setErr_wlan;
		}
	}
	sprintf(varName, "chan%d", wlan_id);
	strChan = req_get_cstream_var(wp, varName, "");
	if ( strChan[0] ) {
		errno=0;
		chan = strtol( strChan, (char **)NULL, 10);
		if (errno) {
   			strcpy(tmpBuf, ("Invalid channel number!"));
			goto setErr_wlan;
		}
		/* WNC-NMR0326-Rita-20130314-5GHz channel select spec.
			Auto -> WLAN1_BAND_5G_SELECT = 7
			W52 -> WLAN1_BAND_5G_SELECT = 1
			W53 -> WLAN1_BAND_5G_SELECT = 2
			W56 -> WLAN1_BAND_5G_SELECT = 4
			WLAN1_CHANNEL = 0
		*/
		if(wlan_id == 0){ //2GHz
#if 1	/* NMR2238-[Aero][Request]-20170111-11k correspondence for GUI-start */
			int autoch2=0;
			sprintf(varName, "AUTO_CHANNEL");	//only for root AP
			strVal = req_get_cstream_var(wp, varName, "");
			if (strVal[0]) {
				//printf("WNC:AUTO_CHANNEL=%s, Func: %s, Line: %d\n",strVal[0],__FUNCTION__ , __LINE__);//??
				if ( strVal[0] == '1'){	//Auto Channel selection is [ON] and AutoCH2 is [OFF]		
					autoch2 = 0;
					chan = 0;
				} else if (strVal[0] == '2'){	//Auto Channel selection is [ON] and AutoCH2 is [ON]
					autoch2 = 1;
					chan = 0;
				} else if (strVal[0] == '0'){	// Auto Channel selection is [OFF] and AutoCH2 is [OFF]
					autoch2 = 0;
				} else {
					strcpy(tmpBuf, ("Error! Invalid AUTO_CHANNEL value."));
					goto setErr_wlan;
				}
				if ( apmib_set( MIB_AUTOCH2_ENABLE, (void *)&autoch2) == 0) {
					strcpy(tmpBuf, ("Set autoch2 error!"));
					goto setErr_wlan;
				}	
			}
#endif	/* NMR2238-[Aero][Request]-20170111-11k correspondence for GUI-end */
			if ( apmib_set( MIB_WLAN_CHANNEL, (void *)&chan) == 0) {
	   			strcpy(tmpBuf, ("Set channel number error!"));
				goto setErr_wlan;
			}
		}
		else if(wlan_id == 1){ //5GHz
			if ( apmib_set( MIB_WLAN_BAND_5G_SELECT, (void *)&chan) == 0) {
	   			strcpy(tmpBuf, ("Set band 5G select error!"));
				goto setErr_wlan;
			}
		
			/* WNC-NMR0372-Rita-20130416-5GHz Channel Spec-
				HT80 W52 -> channel = 40
				HT80 W53 -> channel = 56
				HT80 W56 -> channel = 0
				HT20 W52,53,56 -> channel = 0
			*/
			int channel = 0; 
			int val=0;
			if ( !apmib_get(MIB_WLAN_CHANNEL_BONDING, (void *)&val) )
				return -1;
			if(val==2){//HT80
				if(chan==1) //W52
					channel = 36;	/* WNC-NMR000-[Linear]-Libera-20140502- SPEC.v0.2.0 - 5GHz change*/
				if(chan==2) // W53
				    channel = 52;	/* WNC-NMR000-[Linear]-Libera-20140502- SPEC.v0.2.0 - 5GHz change*/
			}
			if ( apmib_set( MIB_WLAN_CHANNEL, (void *)&channel) == 0) {
	   			strcpy(tmpBuf, ("Set channel number error!"));
				goto setErr_wlan;
			}
		}		
		/* WNC-NMR0326-Rita-20130314-End */
	}

	sprintf(varName, "type%d", wlan_id);
	strVal = req_get_cstream_var(wp, varName, "");
	if (strVal[0]) {
		if (strVal[0]!= '0' && strVal[0]!= '1') {
  			strcpy(tmpBuf, ("Invalid network type value!"));
			goto setErr_wlan;
		}
		if (strVal[0] == '0')
			net = INFRASTRUCTURE;
		else
			net = ADHOC;
		if ( apmib_set(MIB_WLAN_NETWORK_TYPE, (void *)&net) == 0) {
			strcpy(tmpBuf, ("Set MIB_WLAN_NETWORK_TYPE failed!"));
			goto setErr_wlan;
		}
	}

	sprintf(varName, "band%d", wlan_id);
	strVal = req_get_cstream_var(wp, varName, "");
	if ( strVal[0] )
	{
		int wlan_onoff_tkip=0;//WNC-NMR0000-Rita-20130310-Error_587-fix warnings of cppcheck (uninitialized value).

		apmib_get( MIB_WLAN_11N_ONOFF_TKIP, (void *)&wlan_onoff_tkip);

		band_no = strtol( strVal, (char **)NULL, 10);
		//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20130103, Apply Realtek SDK 3.3.1 Alpha Patch 
		//if (band_no < 0 || band_no > 19) {
		if (band_no < 0 || band_no > 76) { //8812
		//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20130103, Apply Realtek SDK 3.3.1 Alpha Patch End
  			strcpy(tmpBuf, ("Invalid band value!"));
			goto setErr_wlan;
		}
		//val = (strVal[0] - '0' + 1);
		if(wlan_onoff_tkip == 0) //Wifi request
		{
			int wpaCipher=0;//WNC-NMR0000-Rita-20130310-Error_590-fix warnings of cppcheck (uninitialized value).
			int wpa2Cipher=0;//WNC-NMR0000-Rita-20130310-Error_591-fix warnings of cppcheck (uninitialized value).
			int wdsEncrypt=0;//WNC-NMR0000-Rita-20130310-Error_592-fix warnings of cppcheck (uninitialized value).
			int wlan_encrypt=0;

			apmib_get( MIB_WLAN_ENCRYPT, (void *)&wlan_encrypt);
			apmib_get(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&wpaCipher);
			apmib_get(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&wpa2Cipher);
			apmib_get( MIB_WLAN_WDS_ENCRYPT, (void *)&wdsEncrypt);

			//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20130103, Apply Realtek SDK 3.3.1 Alpha Patch
			//if(*mode != CLIENT_MODE && (band_no == 7 || band_no == 9 || band_no == 10 || band_no == 11)) //7:n; 9:gn; 10:bgn 11:5g_an
			if(*mode != CLIENT_MODE && (band_no == 7 || band_no == 9 || band_no == 10 || band_no == 11 || band_no == 75)) //7:n; 9:gn; 10:bgn 11:5g_an
			//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20130103, Apply Realtek SDK 3.3.1 Alpha Patch End
			{

				if(wlan_encrypt ==ENCRYPT_WPA || wlan_encrypt ==ENCRYPT_WPA2){
				wpaCipher &= ~WPA_CIPHER_TKIP;
					if(wpaCipher== 0)
						wpaCipher =  WPA_CIPHER_AES;
				apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&wpaCipher);

				wpa2Cipher &= ~WPA_CIPHER_TKIP;
					if(wpa2Cipher== 0)
						wpa2Cipher =  WPA_CIPHER_AES;
				apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&wpa2Cipher);
				}
				if(wdsEncrypt == WDS_ENCRYPT_TKIP)
				{
					wdsEncrypt = WDS_ENCRYPT_DISABLED;
					apmib_set( MIB_WLAN_WDS_ENCRYPT, (void *)&wdsEncrypt);
				}
			}
		}
		val = (band_no + 1);
		if ( apmib_set( MIB_WLAN_BAND, (void *)&val) == 0) {
   			strcpy(tmpBuf, ("Set band error!"));
			goto setErr_wlan;
		}
//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20130103, Apply Realtek SDK 3.3.1 Alpha Patch	
#if defined(CONFIG_RTL_8812_SUPPORT)
		{
			int band2G5GSelect = 0;
			strVal = req_get_cstream_var(wp, "Band2G5GSupport", ""); //wlan0 PHYBAND_TYPE
			if(strVal[0] != 0)
			{
				band2G5GSelect = atoi(strVal);
				//printf("band2G5GSelect = %d\n", band2G5GSelect);
			}


			if(band_no==3 || band_no==11 || band_no==75)
				val = 2;
			else if(band_no==7)
			{
				val = band2G5GSelect;
			}
			else
				val = 1;

			if ( apmib_set( MIB_WLAN_PHY_BAND_SELECT, (void *)&val) == 0) {
				strcpy(tmpBuf, ("Set band error!"));
					goto setErr_wlan;
			}
		}
#endif
//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20130103, Apply Realtek SDK 3.3.1 Alpha Patch End
	}

	// set tx rate
	sprintf(varName, "txRate%d", wlan_id);
	strRate = req_get_cstream_var(wp, varName, "");
	if ( strRate[0] ) {
		if ( strRate[0] == '0' ) { // auto
			val = 1;
			if ( apmib_set(MIB_WLAN_RATE_ADAPTIVE_ENABLED, (void *)&val) == 0) {
				strcpy(tmpBuf, ("Set rate adaptive failed!"));
				goto setErr_wlan;
			}
		}
		else  {
			val = 0;
			if ( apmib_set(MIB_WLAN_RATE_ADAPTIVE_ENABLED, (void *)&val) == 0) {
				strcpy(tmpBuf, ("Set rate adaptive failed!"));
				goto setErr_wlan;
			}
			val = atoi(strRate);
			//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20130103, Apply Realtek SDK 3.3.1 Alpha Patch
			if(val<30)
			//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20130103, Apply Realtek SDK 3.3.1 Alpha Patch End
				val = 1 << (val-1);
			//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20130103, Apply Realtek SDK 3.3.1 Alpha Patch
			else
				val = ((1<<31) + (val -30));
			if ( apmib_set(MIB_WLAN_FIX_RATE, (void *)&val) == 0) {
				strcpy(tmpBuf, ("Set fix rate failed!"));
				goto setErr_wlan;
			}
		}
	}

	sprintf(varName, "basicrates%d", wlan_id);
	strRate = req_get_cstream_var(wp, varName, "");
	if ( strRate[0] ) {
		val = atoi(strRate);
		if ( apmib_set(MIB_WLAN_BASIC_RATES, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set Tx basic rate failed!"));
			goto setErr_wlan;
		}
	}

	sprintf(varName, "operrates%d", wlan_id);
	strRate = req_get_cstream_var(wp, varName, "");
	if ( strRate[0] ) {
		val = atoi(strRate);
		if ( apmib_set(MIB_WLAN_SUPPORTED_RATES, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set Tx operation rate failed!"));
			goto setErr_wlan;
		}
	}

#if 1	/* WNC-MR0000-Libera-20120308- moved from advance page by Cheeper. */
	// set protection
	strProtection= req_get_cstream_var(wp, ("11g_protection"), "");
	if (strProtection[0]) {
		if (!strcmp(strProtection, ("no")))
			val = 1;
		else if (!strcmp(strProtection, ("yes")))
			val = 0;
		else {
			strcpy(tmpBuf, ("Error! Invalid 11g Protection value."));
			goto setErr_wlan;
		}
		if ( apmib_set(MIB_WLAN_PROTECTION_DISABLED, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set MIB_WLAN_PROTECTION_DISABLED failed!"));
			goto setErr_wlan;
		}
	}

	//set 20/40MHz coexist
	strValue = req_get_cstream_var(wp, ("coexist_"), "");
		if (strValue[0]) {
			if (!strcmp(strValue, ("enable")))
				val = 1;
			else
				val = 0;
			apmib_set(MIB_WLAN_COEXIST_ENABLED, (void *)&val);
		}

	//set RF power
	strPower= req_get_cstream_var(wp, ("RFPower"), "");
	if (strPower[0]) {
		if (!strcmp(strPower, ("0")))
			val = 0;
		else if (!strcmp(strPower, ("1")))
			val = 1;
		else if (!strcmp(strPower, ("2")))
			val = 2;
		else if (!strcmp(strPower, ("3")))
			val = 3;
		else if (!strcmp(strPower, ("4")))
			val = 4;
		/* NMR1774-20161212-Fix bug 1774  [Aero] The wireless power item is wrong when rf power scale 25% or 12.5% is selected-start */
		else if (!strcmp(strPower, ("5")))
			val = 5;
		else if (!strcmp(strPower, ("6")))
			val = 6;
		/* NMR1774-20161212-Fix bug 1774  [Aero] The wireless power item is wrong when rf power scale 25% or 12.5% is selected-end */
		else {
			strcpy(tmpBuf, ("Error! Invalid RF output power value."));
			goto setErr_wlan;
		}
		if ( apmib_set(MIB_WLAN_RFPOWER_SCALE, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set MIB_WLAN_RFPOWER_SCALE failed!"));
			goto setErr_wlan;
		}
	}

// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-06-09: Add TV mode #BEGIN
	strValue= req_get_cstream_var(wp, ("tvmode"), "");
	if (strValue[0]) {
		val = atoi(strValue);		
		if ( apmib_set(MIB_WLAN_TVMODE_SUPPORT, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set MIB_WLAN_TVMODE_SUPPORT failed!"));
			goto setErr_wlan;
		}
	}
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-06-09: Add TV mode #END
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-06-10: Add Multicast control #BEGIN
	strValue= req_get_cstream_var(wp, ("MCforward"), "");
	if (strValue[0]) {
		val = atoi(strValue);		
		if ( apmib_set(MIB_WLAN_MC_FORWARD_TYPE, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set MIB_WLAN_MC_FORWARD_TYPE failed!"));
			goto setErr_wlan;
		}
	}

	strValue= req_get_cstream_var(wp, ("MCrate"), "");
	if (strValue[0]) {
		val = atoi(strValue);		
		if ( apmib_set(MIB_WLAN_LOWEST_MLCST_RATE, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set MIB_WLAN_LOWEST_MLCST_RATE failed!"));
			goto setErr_wlan;
		}
	}
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-06-10: Add Multicast control #END

// WNC-NMR0000-D2R230-MIKE-YEH-2017-04-27: Add AMPDU+AMSDU #BEGIN
	sprintf(varName, "amsdu%d", wlan_id);
	strValue = req_get_cstream_var(wp, varName, "");
	if (strValue[0]) {
		val = atoi(strValue);
		if ( apmib_set(MIB_WLAN_AGGREGATION, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set MIB_WLAN_AGGREGATION failed!"));
			goto setErr_wlan;
		}
	}

	sprintf(varName, "amsdu_sec%d", wlan_id);
	strValue = req_get_cstream_var(wp, varName, "");
	if (strValue[0]) {
		int old_vwlan_idx = vwlan_idx;
		vwlan_idx = 1;
		val = atoi(strValue);
		if ( apmib_set(MIB_WLAN_AGGREGATION, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set MIB_WLAN_AGGREGATION failed!"));
			vwlan_idx = old_vwlan_idx;
			goto setErr_wlan;
		}
		vwlan_idx = old_vwlan_idx;
	}
// WNC-NMR0000-D2R230-MIKE-YEH-2017-04-27: Add AMPDU+AMSDU #END

#endif
#if 1	/* WNC-NMR000-[Aero/Thalys]-Libera-20160606- responsive GUI porting*/ //set rekey	
	strValue= req_get_cstream_var(wp, ("rkey_intvl"), "");

	/* WNC-NMR000-[Aero/Thalys]-MIKE-YEH-20160824-error check on server side. */
	{
		int wifi_mode = WIFI_MODE_AP;
			
		if(lw_get_wifi_mode(&wifi_mode) == 1) {
			if((wifi_mode == WIFI_MODE_AP) && (lw_NullCheck(strValue) == -1 || lw_DigitalRangeCheck(strValue, 0, 86400) == -1))
			{
				send_redirect_perm(wp, LW_GUI_INPUT_ERR_PAGE);
				return;
			}
		}
	}

	if (strValue[0]) {
		val = atoi(strValue);		
		if ( apmib_set(MIB_WLAN_WPA_GROUP_REKEY_TIME, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set MIB_WLAN_WPA_GROUP_REKEY_TIME failed!"));
			goto setErr_wlan;
		}
	}
#endif
	// set hidden SSID
	sprintf(varName, "hiddenSSID%d", wlan_id);
	strVal = req_get_cstream_var(wp, varName, "");
	if (strVal[0]) {
		/* WNC-NMR0000-JOE-PENG-20140806-Implement section 5.22.8 Take Over Broadcast-SSID from AP-start */
		if (access("/tmp/MODE_CNV", F_OK) == 0 || access("/tmp/MODE_RPT", F_OK) == 0) {/* converter or repeater mode */
			int take_over_ssid=0;

			if ( strVal[0] == '0') {
				/* Case of disable hidden ssid */
				val = 0;
				take_over_ssid = 0;
			} else if (strVal[0] == '1') {
				/* Case of enable hidden ssid */
				val = 1;
				take_over_ssid = 0;
			} else if (strVal[0] == '2') {
				/* Case of take over ssid */
				/* In this case, we must set val to 0 (disable hidden ssid),
					else OnProbeReq() in 8192cd_sme.c will always make DUT to enable hidden ssid state */
				val = 0;
				take_over_ssid = 1;
			} else {
				strcpy(tmpBuf, ("Error! Invalid hidden ssid."));
				goto setErr_wlan;
			}

			if ( apmib_set(MIB_WLAN_HIDDEN_SSID, (void *)&val) == 0) {
				strcpy(tmpBuf, ("Set hidden ssid failed!"));
				goto setErr_wlan;
			}

			{
				int orig_vwlan_idx=0;
				
				/* Back up original vwlan index */
				orig_vwlan_idx=vwlan_idx;
				
				/* GUI setting of "Take over SSID" is saved in MIB of vxd interface */
				vwlan_idx = NUM_VWLAN_INTERFACE; // repeater interface

				if ( apmib_set(MIB_WLAN_TAKE_OVER_SSID, (void *)&take_over_ssid) == 0) {
					strcpy(tmpBuf, ("Set take over ssid failed!"));
					/* Recover original vwlan index */
					vwlan_idx=orig_vwlan_idx;
					goto setErr_wlan;
				}

				/* Recover original vwlan index */
				vwlan_idx=orig_vwlan_idx;
			}
		} else {
			if ( strVal[0] == '0') {
				val = 0;
			} else if (strVal[0] == '1') {
				val = 1;
			} else {
				strcpy(tmpBuf, ("Error! Invalid hidden ssid."));
				goto setErr_wlan;
			}
			if ( apmib_set(MIB_WLAN_HIDDEN_SSID, (void *)&val) == 0) {
				strcpy(tmpBuf, ("Set hidden ssid failed!"));
				goto setErr_wlan;
			}
		}
		/* WNC-NMR0000-JOE-PENG-20140806-Implement section 5.22.8 Take Over Broadcast-SSID from AP-end */
	}
	sprintf(varName, "wlanwmm%d", wlan_id);
	strVal= req_get_cstream_var(wp, varName, "");
	if (strVal[0]) {
		if ( strVal[0] == '0')
			val = 0;
		else if (strVal[0] == '1')
			val = 1;
		else {
			strcpy(tmpBuf, ("Error! Invalid WMM value."));
			goto setErr_wlan;
		}
		if ( apmib_set(MIB_WLAN_WMM_ENABLED, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set MIB_WLAN_WMM_ENABLED failed!"));
			goto setErr_wlan;
		}
	}else{
		//enable wmm in 11N mode always
			apmib_get( MIB_WLAN_BAND, (void *)&cur_band);
			if(cur_band == 10 || cur_band ==11){
				val = 1;
				if ( apmib_set(MIB_WLAN_WMM_ENABLED, (void *)&val) == 0) {
					strcpy(tmpBuf, ("Set MIB_WLAN_WMM_ENABLED failed!"));
					goto setErr_wlan;
				}
			}
	}
/* WNC-NMR0008-JOE-PENG-20120418-Fix wireless side band error on wireless client card */
#if 0
	sprintf(varName, "controlsideband%d", wlan_id);
	strVal= req_get_cstream_var(wp, varName, "");
	if (strVal[0]) {
		if ( strVal[0] == '0')
			val = 0;
		else if ( strVal[0] == '1')
			val = 1;
		else {
			strcpy(tmpBuf, ("Error! Invalid Control SideBand."));
			goto setErr_wlan;
		}
		if ( apmib_set(MIB_WLAN_CONTROL_SIDEBAND, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set MIB_WLAN_CONTROL_SIDEBAND failed!"));
			goto setErr_wlan;
		}
	}
#endif
/* WNC-NMR0008-JOE-PENG-20120418-end */
//

	sprintf(varName, "basicrates%d", wlan_id);
	strRate = req_get_cstream_var(wp, varName, "");
	if ( strRate[0] ) {
		val = atoi(strRate);

		if ( val && apmib_set(MIB_WLAN_BASIC_RATES, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set Tx basic rate failed!"));
			goto setErr_wlan;
		}
	}

	sprintf(varName, "operrates%d", wlan_id);
	strRate = req_get_cstream_var(wp, varName, "");
	if ( strRate[0] ) {
		val = atoi(strRate);
		if ( val && apmib_set(MIB_WLAN_SUPPORTED_RATES, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set Tx operation rate failed!"));
			goto setErr_wlan;
		}
	}	//do twice ??

#ifdef UNIVERSAL_REPEATER
#ifdef CONFIG_RTK_MESH
	if( *mode >= 4 && *mode <=7)
	{
		val=0;
		apmib_set(MIB_REPEATER_ENABLED1, (void *)&val);
		apmib_set(MIB_REPEATER_ENABLED2, (void *)&val);
	}
	else
#endif
{	int id;
	sprintf(varName, "repeaterEnabled%d", wlan_id);
	strVal = req_get_cstream_var(wp, ("lan_ip"), "");

	if ((strVal==NULL || strVal[0]==0)   // not called from wizard
			//&& (*mode != WDS_MODE)	&& (*mode != CLIENT_MODE)
		)
		{
		int rpt_enabled;


		/* WNC-MR0000-JOE-PENG-20130806-Fix bug that MIB_REPEATER_ENABLED1 is set to 0 if user set WIFI and not reboot. This cause status page incorrect in wireless WAN mode->start */
		if (wlan_id == 0)
			id = MIB_REPEATER_ENABLED1;
		else
			id = MIB_REPEATER_ENABLED2;
		apmib_get(id, (void *)&val);

		strVal = req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			if ( !strcmp(strVal, "ON"))
				val = 1 ;
			else
				val = 0 ;
		}
		/* WNC-MR0000-JOE-PENG-20130806-Fix bug that MIB_REPEATER_ENABLED1 is set to 0 if user set WIFI and not reboot. This cause status page incorrect in wireless WAN mode->end */

#if defined(CONFIG_RTL_ULINKER)
		if (wlan_id == 0)
			id = MIB_REPEATER_ENABLED1;
		else
			id = MIB_REPEATER_ENABLED2;
		apmib_get(id, (void *)&rpt_enabled);
		if(*mode == AP_MODE && rpt_enabled == 1) //ulinker repeater mode
		{
			val = 1;
		}
#endif

		if (wlan_id == 0)
			id = MIB_REPEATER_ENABLED1;
		else
			id = MIB_REPEATER_ENABLED2;

		if (*mode == AP_MODE || *mode == AP_WDS_MODE || *mode == AP_MESH_MODE)	/* NMR0000-[Aero]-20161011-patch: fmwlan-3411b.c */
			apmib_set(id, (void *)&val);

		if (val == 1) {
			sprintf(varName, "repeaterSSID%d", wlan_id);
			/* WNC-NMR0348-JOE-PENG-20130329-Fix Page Fault occurs during setting on GUI */
			strVal = req_get_cstream_var(wp, varName, "");
			if (strVal[0]){
				if (wlan_id == 0)
					id = MIB_REPEATER_SSID1;
				else
					id = MIB_REPEATER_SSID2;

				setRepeaterSsid(wlan_id, id, strVal);
			}
		}

#ifdef MBSSID
		/* WNC-NMR0000-JOE-PENG-20140814-Fix bug that WLANX_VAP4_SSID was clear to NULL string after user set settings in Wi-Fi 2.4G or 5G setting page-start */
		if (access("/tmp/MODE_RPT", F_OK) != 0)//not repeater mode
		{
			int old_idx = vwlan_idx;
			vwlan_idx = NUM_VWLAN_INTERFACE; // repeater interface
			int disable;
			if (val)
				disable = 0;
			else
				disable = 1;
			apmib_set(MIB_WLAN_WLAN_DISABLED, (void *)&disable);

			if (!disable) {
				if (*mode == CLIENT_MODE)
					val = AP_MODE;
				else
					val = CLIENT_MODE;
				apmib_set(MIB_WLAN_MODE, (void *)&val);
				apmib_set(MIB_WLAN_SSID, (void *)strVal);
			}

			if (val == CLIENT_MODE) {
				// if client mode, check if Radius or mixed mode encryption is used
				apmib_get(MIB_WLAN_ENCRYPT, (void *)&val);

				if (val <= ENCRYPT_WEP) {
					apmib_get( MIB_WLAN_ENABLE_1X, (void *)&val);
					if (val != 0) {
						val = 0;
						apmib_set( MIB_WLAN_ENABLE_1X, (void *)&val);
					}
				}
				else if (val == ENCRYPT_WPA2_MIXED) {
					val = ENCRYPT_DISABLED;
					apmib_set(MIB_WLAN_ENCRYPT, (void *)&val);
				}
				else if (val == ENCRYPT_WPA) {
					apmib_get(MIB_WLAN_WPA_AUTH, (void *)&val);
					if ((val == 0) || (val & 1)) { // if no or radius, force to psk
						val = 2;
						apmib_set(MIB_WLAN_WPA_AUTH, (void *)&val);
					}
					apmib_get(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&val);
					if ((val == 0) || (val == WPA_CIPHER_MIXED)) {
						val = WPA_CIPHER_AES;
						apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&val);
					}
				}
				else if (val == ENCRYPT_WPA2) {
					apmib_get(MIB_WLAN_WPA_AUTH, (void *)&val);
					if ((val == 0) || (val & 1)) { // if no or radius, force to psk
						val = 2;
						apmib_set(MIB_WLAN_WPA_AUTH, (void *)&val);
					}
					apmib_get(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&val);
					if ((val == 0) || (val == WPA_CIPHER_MIXED)) {
						val = WPA_CIPHER_AES;
						apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&val);
					}
				}
			}

			vwlan_idx = old_idx;
		}
		/* WNC-NMR0000-JOE-PENG-20140814-Fix bug that WLANX_VAP4_SSID was clear to NULL string after user set settings in Wi-Fi 2.4G or 5G setting page-end */
#endif
	}
}
#endif

#if 1	/* WNC-MR0000-Libera-20120308- Multipule AP for Cheeper */
	if(vwlan_idx > 0){
//	if(vwlan_idx > 1){	/* WNC-MR000-Libera-20130703- Pocket spec.: change interface: wlan0->wlan0-va0, wlan0-va0->wlan0-va1 */
		sprintf(varName, "wl_disable%d", vwlan_idx);
		strVal = req_get_cstream_var(wp, varName, "");
		if ( !strcmp(strVal, "ON")) //vap-wlan-enable
			disabled = 0;
		else
			disabled = 1;
		apmib_set(MIB_WLAN_WLAN_DISABLED, (void *)&disabled);

		sprintf(varName, "wl_band%d", vwlan_idx);
		strVal = req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			band_no = strtol( strVal, (char **)NULL, 10);
			val = (band_no + 1);
			apmib_set(MIB_WLAN_BAND, (void *)&val);
		}

		sprintf(varName, "wl_ssid%d", vwlan_idx);
		strVal = req_get_cstream_var(wp, varName, "");

		/* WNC-NMR000-[Aero/Thalys]-MIKE-YEH-20160824-error check on server side. */
		if(lw_NullCheck(strVal) == -1 || lw_SsidNameCheck(strVal) == -1)
		{
			send_redirect_perm(wp, LW_GUI_INPUT_ERR_PAGE);
			return;
		}
		
		if (strVal[0])
			apmib_set( MIB_WLAN_SSID, (void *)strVal);

		sprintf(varName, "TxRate%d", vwlan_idx);
		strVal = req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			if ( strVal[0] == '0' ) { // auto
				val = 1;
				apmib_set(MIB_WLAN_RATE_ADAPTIVE_ENABLED, (void *)&val);
			}
			else  {
				val = 0;
				apmib_set(MIB_WLAN_RATE_ADAPTIVE_ENABLED, (void *)&val);
				val = atoi(strVal);
				val = 1 << (val-1);
				apmib_set(MIB_WLAN_FIX_RATE, (void *)&val);
			}
		}

		sprintf(varName, "wl_hide_ssid%d", vwlan_idx);
		strVal = req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			if ( strVal[0] == '0')
				val = 0;
			else
				val = 1;
			apmib_set(MIB_WLAN_HIDDEN_SSID, (void *)&val);
		}

		sprintf(varName, "wl_wmm_capable%d", vwlan_idx);
		strVal= req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			if ( strVal[0] == '0')
				val = 0;
			else
				val = 1;
			apmib_set(MIB_WLAN_WMM_ENABLED, (void *)&val);
		}
		else {	//enable wmm in 11N mode always
			int cur_band = 0;//WNC-NMR0000-Rita-20130305-Error_619-fix warnings of cppcheck (uninitialized value).
			apmib_get(MIB_WLAN_BAND, (void *)&cur_band);
			if(cur_band == 10 || cur_band ==11) {
				val = 1;
				apmib_set(MIB_WLAN_WMM_ENABLED, (void *)&val);
			}
		}

		sprintf(varName, "wl_access%d", vwlan_idx);
		strVal= req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			if ( strVal[0] == '0')
				val = 0;
			else
				val = 1;
			apmib_set(MIB_WLAN_ACCESS, (void *)&val);
			//WNC-MRXXXX-YUAN-I-CHOU-20120407, wlan partition
			apmib_set(MIB_WLAN_BLOCK_RELAY, (void *)&val);
		}

		// force basic and support rate to zero to let driver set default
		val = 0;
		apmib_set(MIB_WLAN_BASIC_RATES, (void *)&val);
		apmib_set(MIB_WLAN_SUPPORTED_RATES, (void *)&val);

#if 1	/* WNC-NMR000-[Aero/Thalys]-Libera-20160606- responsive GUI porting*/ //set rekey	
		sprintf(varName, "rkey_intvl%d", vwlan_idx);
		strValue = req_get_cstream_var(wp, varName, "");

		/* WNC-NMR000-[Aero/Thalys]-MIKE-YEH-20160824-error check on server side. */
		{
			int wifi_mode = WIFI_MODE_AP;
				
			if(lw_get_wifi_mode(&wifi_mode) == 1) {
				if((wifi_mode == WIFI_MODE_AP) && (lw_NullCheck(strValue) == -1 || lw_DigitalRangeCheck(strValue, 0, 86400) == -1))
				{
					send_redirect_perm(wp, LW_GUI_INPUT_ERR_PAGE);
					return;
				}
			}
		}

		if (strValue[0]) {
			val = atoi(strValue);		
			if ( apmib_set(MIB_WLAN_WPA_GROUP_REKEY_TIME, (void *)&val) == 0) {
				strcpy(tmpBuf, ("Set MIB_WLAN_WPA_GROUP_REKEY_TIME failed!, vwlan_idx=%d\n", vwlan_idx));
				goto setErr_wlan;
			}
		}
#endif

		}
#endif

#if 0	/* WNC-MR0000-Libera-20120308- Multipule AP for Cheeper */
	old_vwlan_idx = vwlan_idx;
	for (idx=1; idx<=4; idx++) {
		vwlan_idx = idx;

		sprintf(varName, "wl_disable%d", idx);
		strVal = req_get_cstream_var(wp, varName, "");
		if ( !strcmp(strVal, "ON"))
			disabled = 0;
		else
			disabled = 1;
		apmib_set(MIB_WLAN_WLAN_DISABLED, (void *)&disabled);

		if (disabled)
			continue;

		sprintf(varName, "wl_band%d", idx);
		strVal = req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			band_no = strtol( strVal, (char **)NULL, 10);
			val = (band_no + 1);
			apmib_set(MIB_WLAN_BAND, (void *)&val);
		}

		sprintf(varName, "wl_ssid%d", idx);
		strVal = req_get_cstream_var(wp, varName, "");
		if (strVal[0])
			apmib_set( MIB_WLAN_SSID, (void *)strVal);

		sprintf(varName, "TxRate%d", idx);
		strVal = req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			if ( strVal[0] == '0' ) { // auto
				val = 1;
				apmib_set(MIB_WLAN_RATE_ADAPTIVE_ENABLED, (void *)&val);
			}
			else  {
				val = 0;
				apmib_set(MIB_WLAN_RATE_ADAPTIVE_ENABLED, (void *)&val);
				val = atoi(strVal);
				val = 1 << (val-1);
				apmib_set(MIB_WLAN_FIX_RATE, (void *)&val);
			}
		}

		sprintf(varName, "wl_hide_ssid%d", idx);
		strVal = req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			if ( strVal[0] == '0')
				val = 0;
			else
				val = 1;
			apmib_set(MIB_WLAN_HIDDEN_SSID, (void *)&val);
		}

		sprintf(varName, "wl_wmm_capable%d", idx);
		strVal= req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			if ( strVal[0] == '0')
				val = 0;
			else
				val = 1;
			apmib_set(MIB_WLAN_WMM_ENABLED, (void *)&val);
		}
		else {	//enable wmm in 11N mode always
			int cur_band;
			apmib_get(MIB_WLAN_BAND, (void *)&cur_band);
			if(cur_band == 10 || cur_band ==11) {
				val = 1;
				apmib_set(MIB_WLAN_WMM_ENABLED, (void *)&val);
			}
		}

		sprintf(varName, "wl_access%d", idx);
		strVal= req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			if ( strVal[0] == '0')
				val = 0;
			else
				val = 1;
			apmib_set(MIB_WLAN_ACCESS, (void *)&val);
			//WNC-MRXXXX-YUAN-I-CHOU-20120407, wlan partition
			apmib_set(MIB_WLAN_BLOCK_RELAY, (void *)&val);
		}

		// force basic and support rate to zero to let driver set default
		val = 0;
		apmib_set(MIB_WLAN_BASIC_RATES, (void *)&val);
		apmib_set(MIB_WLAN_SUPPORTED_RATES, (void *)&val);

	}
	vwlan_idx = old_vwlan_idx;
#endif
#ifdef WIFI_SIMPLE_CONFIG
	sprintf(varName, "wps_clear_configure_by_reg%d", wlan_id);
	/* WNC-NMR0348-JOE-PENG-20130329-Fix Page Fault occurs during setting on GUI */
	strVal = req_get_cstream_var(wp, varName, "");
	val = 0;
	if (strVal[0])
		val = atoi(strVal);
	update_wps_configured(val);
#if 0	/* WNC-MR000-Libera-20131009 - for wlan0-va0 compares */	
	/* WNC-MR000-Libera-20130703- Pocket spec.: change interface: wlan0->wlan0-va0, wlan0-va0->wlan0-va1 (2) */
	int tmp_vwlan_idx=0, tmp_wlan_idx=0;
	tmp_wlan_idx=wlan_idx;
	tmp_vwlan_idx=vwlan_idx;
	wlan_idx = 0;		//radio0
	vwlan_idx = 1;	//wlan0-va0
	update_wps_configured(val);
	wlan_idx = tmp_wlan_idx;
	vwlan_idx = tmp_vwlan_idx;
#endif
#endif

	return  0;
setErr_wlan:
	return -1 ;
}
#endif	/* WNC-MR0000-Libera-20120308- wlan, advanced, multi-ap, and security all in one for Cheeper. -END */

#ifdef CONFIG_RTK_MESH
/////////////////////////////////////////////////////////////////////////////

int meshWpaHandler(request *wp, char *tmpBuf, int wlan_id)
{
  	char *strEncrypt, *strVal;
	ENCRYPT_T encrypt;
	int	intVal, getPSK=1, len;	

	char varName[20];

	sprintf(varName, "mesh_method%d", wlan_id);
   	strEncrypt = req_get_cstream_var(wp, varName, "");
	if (!strEncrypt[0]) {
 		strcpy(tmpBuf, ("Error! no encryption method."));
		goto setErr_mEncrypt;
	}
	encrypt = (ENCRYPT_T) strEncrypt[0] - '0';
	if (encrypt!=ENCRYPT_DISABLED &&  encrypt != ENCRYPT_WPA2 ) {
		strcpy(tmpBuf, ("Invalid encryption method!"));
		goto setErr_mEncrypt;
	}

	if (apmib_set( MIB_WLAN_MESH_ENCRYPT, (void *)&encrypt) == 0) {
  		strcpy(tmpBuf, ("Set MIB_WLAN_MESH_ENCRYPT mib error!"));
		goto setErr_mEncrypt;
	}

	if(encrypt == ENCRYPT_WPA2)
	{
		// WPA authentication  ( RADIU / Pre-Shared Key )
		intVal = WPA_AUTH_PSK;		
		if ( apmib_set(MIB_WLAN_MESH_WPA_AUTH, (void *)&intVal) == 0) {
				strcpy(tmpBuf, ("Set MIB_WLAN_MESH_AUTH_TYPE failed!"));
				goto setErr_mEncrypt;
		}

		// cipher suite	 (TKIP / AES)
		intVal =   WPA_CIPHER_AES ;		
		if ( apmib_set(MIB_WLAN_MESH_WPA2_CIPHER_SUITE, (void *)&intVal) == 0) {
				strcpy(tmpBuf, ("Set MIB_WLAN_MESH_WPA2_UNICIPHER failed!"));
				goto setErr_mEncrypt;
		}

		// pre-shared key
		if ( getPSK ) {
			int oldFormat, oldPskLen, i;

			sprintf(varName, "mesh_pskFormat%d", wlan_id);
   			strVal = req_get_cstream_var(wp, varName, "");
			if (!strVal[0]) {
	 			strcpy(tmpBuf, ("Error! no psk format."));
				goto setErr_mEncrypt;
			}
			intVal = strVal[0] - '0';
			if (intVal != 0 && intVal != 1) {
	 			strcpy(tmpBuf, ("Error! invalid psk format."));
				goto setErr_mEncrypt;
			}

			// remember current psk format and length to compare to default case "****"
			apmib_get(MIB_WLAN_MESH_PSK_FORMAT, (void *)&oldFormat);
			apmib_get(MIB_WLAN_MESH_WPA_PSK, (void *)tmpBuf);
			oldPskLen = strlen(tmpBuf);

			sprintf(varName, "mesh_pskValue%d", wlan_id);
			strVal = req_get_cstream_var(wp, varName, "");
			len = strlen(strVal);

			if (oldFormat == intVal && len == oldPskLen ) {
				if(!strcmp(strVal,tmpBuf))
					goto mRekey_time;
			}

			if ( apmib_set(MIB_WLAN_MESH_PSK_FORMAT, (void *)&intVal) == 0) {
				strcpy(tmpBuf, ("Set MIB_WLAN_MESH_PSK_FORMAT failed!"));
				goto setErr_mEncrypt;
			}

			if (intVal==1) { // hex
				if (len!=MAX_PSK_LEN || !string_to_hex(strVal, tmpBuf, MAX_PSK_LEN)) {
	 				strcpy(tmpBuf, ("Error! invalid psk value."));
					goto setErr_mEncrypt;
				}
			}
			else { // passphras
				if (len==0 || len > (MAX_PSK_LEN-1) ) {
	 				strcpy(tmpBuf, ("Error! invalid psk value."));
					goto setErr_mEncrypt;
				}
			}
			if ( !apmib_set(MIB_WLAN_MESH_WPA_PSK, (void *)strVal)) {
				strcpy(tmpBuf, ("Set MIB_WLAN_MESH_WPA_PSK error!"));
				goto setErr_mEncrypt;
			}
		}	
	}
mRekey_time:
		// group key rekey time			
	return 0 ;
setErr_mEncrypt:
	return -1 ;		
}	


#ifdef _MESH_ACL_ENABLE_
int wlMeshAcList(request *wp, int argc, char **argv)
{
	int nBytesSent=0, entryNum, i;
	MACFILTER_T entry;
	char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};

	if ( !apmib_get(MIB_WLAN_MESH_ACL_NUM, (void *)&entryNum)) {
  		fprintf(stderr, "Get MIB_WLAN_MESH_ACL_NUM table entry error!\n");
		return -1;
	}

	nBytesSent += req_format_write(wp, ("<tr class=\"tbl_head\">"
      	"<td align=center width=\"45%%\" ><font size=\"2\"><b>MAC Address</b></font></td>\n"
      	"<td align=center width=\"35%%\" ><font size=\"2\"><b>Comment</b></font></td>\n"
      	"<td align=center width=\"20%%\" ><font size=\"2\"><b>Select</b></font></td></tr>\n"));

	for (i=1; i<=entryNum; i++) {
		*((char *)&entry) = (char)i;
		if ( !apmib_get(MIB_WLAN_MESH_ACL_ADDR, (void *)&entry))
			return -1;

		snprintf(tmpBuf, MAX_MSG_BUFFER_SIZE, ("%02x:%02x:%02x:%02x:%02x:%02x"),
			entry.macAddr[0], entry.macAddr[1], entry.macAddr[2],
			entry.macAddr[3], entry.macAddr[4], entry.macAddr[5]);

		nBytesSent += req_format_write(wp, ("<tr class=\"tbl_body\">"
			"<td align=center width=\"45%%\" ><font size=\"2\">%s</td>\n"
      			"<td align=center width=\"35%%\" ><font size=\"2\">%s</td>\n"
       			"<td align=center width=\"20%%\" ><input type=\"checkbox\" name=\"select%d\" value=\"ON\"></td></tr>\n"),
				tmpBuf, entry.comment, i);
	}
	return nBytesSent;
}

void formMeshACLSetup(request *wp, char *path, char *query)
{
	char *submitUrl;
	char *strAddMac, *strDelMac, *strDelAllMac, *strVal, *strEnabled;
	int entryNum, i, enabled;
	MACFILTER_T macEntry;
	char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};

	strAddMac = req_get_cstream_var(wp, ("addMeshAclMac"), "");
	strDelMac = req_get_cstream_var(wp, ("deleteSelMeshAclMac"), "");
	strDelAllMac = req_get_cstream_var(wp, ("deleteAllMeshAclMac"), "");
	strEnabled = req_get_cstream_var(wp, ("meshAclEnabled"), "");
	submitUrl = req_get_cstream_var(wp, ("mesh-url"), "");   // hidden page

	if (strAddMac[0]) {
		/*if ( !strcmp(strEnabled, "ON"))
			enabled = 1;
		else
			enabled = 0; */ //by sc_yang
		 enabled = strEnabled[0] - '0';
		if ( apmib_set( MIB_WLAN_MESH_ACL_ENABLED, (void *)&enabled) == 0) {
  			strcpy(tmpBuf, ("Set enabled flag error!"));
			goto setErr_meshACL;
		}

		strVal = req_get_cstream_var(wp, ("aclmac"), "");
		if ( !strVal[0] ) {		// For Disable/Allow/Deny mode setting.
//			strcpy(tmpBuf, ("Error! No mac address to set."));
			goto meshAclExit;
		}
		if (strlen(strVal)!=12 || !string_to_hex(strVal, macEntry.macAddr, 12)) {
			strcpy(tmpBuf, ("Error! Invalid MAC address."));
			goto setErr_meshACL;
		}

		strVal = req_get_cstream_var(wp, ("aclcomment"), "");
		if ( strVal[0] ) {
			if (strlen(strVal) > COMMENT_LEN-1) {
				strcpy(tmpBuf, ("Error! Comment length too long."));
				goto setErr_meshACL;
			}
			strcpy(macEntry.comment, strVal);
		}
		else
			macEntry.comment[0] = '\0';

		if ( !apmib_get(MIB_WLAN_MESH_ACL_NUM, (void *)&entryNum)) {
			strcpy(tmpBuf, ("Get entry number error!"));
			goto setErr_meshACL;
		}
		if ( (entryNum + 1) > MAX_MESH_ACL_NUM) {
			strcpy(tmpBuf, ("Cannot add new entry, Because table is full!"));
			goto setErr_meshACL;
		}

		// set to MIB. try to delete it first to avoid duplicate case
		apmib_set(MIB_WLAN_MESH_ACL_ADDR_DEL, (void *)&macEntry);
		if ( apmib_set(MIB_WLAN_MESH_ACL_ADDR_ADD, (void *)&macEntry) == 0) {
			strcpy(tmpBuf, ("Add table entry error!"));
			goto setErr_meshACL;
		}
		goto meshAclExit;
	}

	/* Delete entry */
	if (strDelMac[0]) {
		if ( !apmib_get(MIB_WLAN_MESH_ACL_NUM, (void *)&entryNum)) {
			strcpy(tmpBuf, ("Get entry number error!"));
			goto setErr_meshACL;
		}
		for (i=entryNum; i>0; i--) {
			snprintf(tmpBuf, 20, "select%d", i);

			strVal = req_get_cstream_var(wp, tmpBuf, "");
			if ( !strcmp(strVal, "ON") ) {

				*((char *)&macEntry) = (char)i;
				if ( !apmib_get(MIB_WLAN_MESH_ACL_ADDR, (void *)&macEntry)) {
					strcpy(tmpBuf, ("Get table entry error!"));
					goto setErr_meshACL;
				}
				if ( !apmib_set(MIB_WLAN_MESH_ACL_ADDR_DEL, (void *)&macEntry)) {
					strcpy(tmpBuf, ("Delete table entry error!"));
					goto setErr_meshACL;
				}
			}
		}
		goto meshAclExit;
	}

	/* Delete all entry */
	if ( strDelAllMac[0]) {
		if ( !apmib_set(MIB_WLAN_MESH_ACL_ADDR_DELALL, (void *)&macEntry)) {
			strcpy(tmpBuf, ("Delete all table error!"));
			goto setErr_meshACL;
		}
		goto meshAclExit;
	}

meshAclExit:
#ifndef NO_ACTION
        run_init_script("bridge");
#endif
        apmib_update(CURRENT_SETTING);

        submitUrl = req_get_cstream_var(wp, ("mesh-url"), "");   // hidden page
#ifdef REBOOT_CHECK
        OK_MSG(submitUrl);
#else
	RECONNECT_MSG(submitUrl);       // display reconnect msg to remote
#endif

        return;

setErr_meshACL:
        ERR_MSG(tmpBuf);
}
#endif	// _MESH_ACL_ENABLE_

int formMeshProxyTbl(request *wp, char *path, char *query)
{
        char *submitUrl,*refresh;

        submitUrl = req_get_cstream_var(wp, ("mesh-url"), "");   // hidden page
        refresh = req_get_cstream_var(wp, ("refresh"), "");

        if ( refresh[0] )
        {
                send_redirect_perm(wp, submitUrl);
                return;
        }
}
char * _get_token( FILE * fPtr,char * token,char * data )
{
        char buf[512];
        char * pch;

        strcpy( data,"");

        if( fgets(buf, sizeof buf, fPtr) == NULL ) // get a new line
                return NULL;

        pch = strstr( buf, token ); //parse the tag

        if( pch == NULL )
                return NULL;

        pch += strlen( token );

        sprintf( data,"%s",pch );                  // set data

        return pch;
}


void strtolower(char *str, int len)
{
	int i;
	for (i = 0; i<len; i++) {
		str[i] = tolower(str[i]);
	}
}


void formMeshProxy(request *wp, char *path, char *query)
{
	char *strPrxyOwnr;
	int nRecordCount=0;
	FILE *fh;
	char buf[512];
	char sta[20],owner[20], macstr[20];
	
	strPrxyOwnr = req_get_cstream_var(wp, ("owner"), "");
	strtolower(strPrxyOwnr, 12);
	
	// show proxy
	if ( strPrxyOwnr[0] )
	{
		sprintf(macstr, "%c%c:%c%c:%c%c:%c%c:%c%c:%c%c", strPrxyOwnr[0],strPrxyOwnr[1],strPrxyOwnr[2]
			,strPrxyOwnr[3],strPrxyOwnr[4],strPrxyOwnr[5],strPrxyOwnr[6],strPrxyOwnr[7],strPrxyOwnr[8]
			,strPrxyOwnr[9],strPrxyOwnr[10],strPrxyOwnr[11]);
		req_format_write(wp, ("<html><! Copyright (c) Realtek Semiconductor Corp., 2003~2005. All Rights Reserved. ->\n"));
		req_format_write(wp, ("<head><meta http-equiv=\"Content-Type\" content=\"text/html\">\n"));
		//req_format_write(wp, ("<script type=\"text/javascript\" src=\"util_gw.js\"></script>\n"));
		req_format_write(wp, ("<title>Proxy Table</title></head>\n"));
		req_format_write(wp, ("<blockquote><h2><font color=\"#0000FF\">Active Client Table - %s</font></h2>\n"), macstr);
		req_format_write(wp, ("<body><form action=./boafrm/formMeshProxy method=POST name=\"formMeshProxy\">\n"));
		req_format_write(wp, ("<table border=0 width=550 cellspacing=4 cellpadding=0>\n"));
		req_format_write(wp, ("<tr><font size=2>\n"));
		req_format_write(wp, ("This table shows the MAC address for each proxied wired or wireless client\n"));
		req_format_write(wp, ("</font></tr>\n"));
		req_format_write(wp, ("<tr><hr size=1 noshade align=top></tr></table>\n"));
		
		
		req_format_write(wp, ("<table border=1 width=200>\n"));
		//req_format_write(wp, ("<tr><font size=4><b>Proxy Table </b></font></tr>\n"));
		
				
		req_format_write(wp, ("<tr class=\"tbl_head\">"
		//"<td align=center width=\"50%%\"><font size=\"2\"><b>MP MAC Address</b></font></td>\n"
		"<td align=center><font size=\"2\"><b>Client MAC Address</b></font></td></tr>\n"));
		
		sprintf(buf,"/proc/wlan%d/%s",wlan_idx,_FILE_MESH_PROXY);
        fh = fopen(buf, "r");
		if (!fh)
		{
				printf("Warning: cannot open %s\n",buf );
				return -1;
		}
		
		while( fgets(buf, sizeof buf, fh) != NULL )
		{
			if( strstr(buf,"table info...") != NULL )
			{
				_get_token( fh,"STA_MAC: ",sta );
				_get_token( fh,"OWNER_MAC: ",owner );
				strtolower(owner, 12);
				if (!strncmp(strPrxyOwnr,owner,12)){
					req_format_write(wp,("<tr class=\"tbl_body\">"
							"<td align=center width=\"50%%\"><font size=\"2\">%s</td>\n"),sta);
					nRecordCount++;
				}
			}
		}
		
		fclose(fh);
		
		if(nRecordCount == 0)
		{
			req_format_write(wp,("<tr class=\"tbl_body\">"
					"<td align=center width=\"17%%\"><font size=\"2\">None</td>\n"));
		}
				
		req_format_write(wp,("</tr></table>\n"));
		req_format_write(wp,("<input type=\"hidden\" value=\"%s\" name=\"owner\">\n"), strPrxyOwnr);
		req_format_write(wp,("<p><input type=\"submit\" value=\"Refresh\" name=\"refresh\">&nbsp;&nbsp;\n"));
		req_format_write(wp,("<input type=\"button\" value=\" Close \" name=\"close\" onClick=\"javascript: window.close();\"><p>\n"));
		req_format_write(wp,("</form>\n"));
		req_format_write(wp, ("</blockquote></body></html>"));
	}
}

void formMeshSetup(request *wp, char *path, char *query)
{
        char *submitUrl,*meshRootEnabled,*refresh, *strMeshID, *strEnabled;
        int enabled,meshenable=0;
        char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};
        int warn=0;
		
#ifdef CONFIG_NEW_MESH_UI
		#if 1
		meshRootEnabled = req_get_cstream_var(wp, ("meshRootEnabled"), "");
		#else
		meshRootEnabled = "ON";
		#endif
#else
        meshRootEnabled = req_get_cstream_var(wp, ("meshRootEnabled"), "");
#endif
        strMeshID = req_get_cstream_var(wp, ("meshID"), "");
        submitUrl = req_get_cstream_var(wp, ("mesh-url"), "");   // hidden page
        refresh = req_get_cstream_var(wp, ("refresh"), "");
		//new feature:Mesh enable/disable
		strEnabled = req_get_cstream_var(wp, ("wlanMeshEnable"), "");

		// refresh button response
        if ( refresh[0] )
        {
        		send_redirect_perm(wp, submitUrl);
                return;
        }
		
		if ( !strcmp(strEnabled, "ON"))
			meshenable = 1;
		else
			meshenable = 0;

		if ( apmib_set(MIB_WLAN_MESH_ENABLE, (void *)&meshenable) == 0)
        {
                strcpy( tmpBuf, ("Set mesh enable error!"));
                goto setErr_mesh;
        }

		if( !meshenable )
			goto setupEnd;

		// backbone privacy settings
		
		if(meshWpaHandler(wp, tmpBuf, wlan_idx) < 0)
			goto setErr_mesh;
		
#ifdef CONFIG_NEW_MESH_UI
	if(!strcmp(meshRootEnabled, "ON"))
            enabled = 1 ;
    else
            enabled = 0 ;
#else
        if(!strcmp(meshRootEnabled, "ON"))
                enabled = 1 ;
        else
                enabled = 0 ;
#endif
        if ( apmib_set(MIB_WLAN_MESH_ROOT_ENABLE, (void *)&enabled) == 0)
        {
                strcpy( tmpBuf, ("Set mesh Root enable error!"));
                goto setErr_mesh;
        }

        if (strMeshID[0])
        {
//              if (strlen(strMeshID)!=12 || !string_to_hex(strMeshID, tmpBuf, 12)) {
                if (strlen(strMeshID)>32) {
                        strcpy(tmpBuf, ("Error! Invalid Mesh ID."));
                        goto setErr_mesh;
                }
                if ( apmib_set(MIB_WLAN_MESH_ID, (void *)strMeshID) == 0)
                {
                        strcpy(tmpBuf, ("Set MIB_WLAN_MESH_ID error!"));
                        goto setErr_mesh;
                }
        }
setupEnd:
        apmib_update(CURRENT_SETTING);

#ifndef NO_ACTION
        run_init_script("bridge");
#endif

        submitUrl = req_get_cstream_var(wp, ("mesh-url"), "");   // hidden page
        if (warn) {
                OK_MSG1(tmpBuf, submitUrl);
        }
        else {
#ifdef REBOOT_CHECK
		OK_MSG(submitUrl);
#else
		RECONNECT_MSG(submitUrl);       // display reconnect msg to remote
#endif
        }
        return;

setErr_mesh:
        ERR_MSG(tmpBuf);
}

#endif // CONFIG_RTK_MESH

/////////////////////////////////////////////////////////////////////////////
#if defined(CONFIG_RTL_92D_SUPPORT) || defined(CONFIG_RTL_8881A_SELECTIVE)

#if 0
void swapWlanMibSetting(unsigned char wlanifNumA, unsigned char wlanifNumB)
{
	unsigned char *wlanMibBuf=NULL;
	unsigned int totalSize = sizeof(CONFIG_WLAN_SETTING_T)*(NUM_VWLAN_INTERFACE+1); // 4vap+1rpt+1root
	wlanMibBuf = malloc(totalSize); 
#if 0	
	printf("\r\n wlanifNumA=[%u],__[%s-%u]\r\n",wlanifNumA,__FILE__,__LINE__);
	printf("\r\n wlanifNumB=[%u],__[%s-%u]\r\n",wlanifNumB,__FILE__,__LINE__);
	
	printf("\r\n pMib->wlan[wlanifNumA]=[0x%x],__[%s-%u]\r\n",pMib->wlan[wlanifNumA],__FILE__,__LINE__);
	printf("\r\n pMib->wlan[wlanifNumB]=[0x%x],__[%s-%u]\r\n",pMib->wlan[wlanifNumB],__FILE__,__LINE__);
	
	printf("\r\n pMib->wlan[0][0].wlanDisabled=[%u],__[%s-%u]\r\n",pMib->wlan[0][0].wlanDisabled,__FILE__,__LINE__);
	printf("\r\n pMib->wlan[0][0].phyBandSelect=[%u],__[%s-%u]\r\n",pMib->wlan[0][0].phyBandSelect,__FILE__,__LINE__);
	printf("\r\n pMib->wlan[0][0].channel=[%u],__[%s-%u]\r\n",pMib->wlan[0][0].channel,__FILE__,__LINE__);
	
	printf("\r\n pMib->wlan[1][0].wlanDisabled=[%u],__[%s-%u]\r\n",pMib->wlan[1][0].wlanDisabled,__FILE__,__LINE__);
	printf("\r\n pMib->wlan[1][0].phyBandSelect=[%u],__[%s-%u]\r\n",pMib->wlan[1][0].phyBandSelect,__FILE__,__LINE__);
	printf("\r\n pMib->wlan[1][0].channel=[%u],__[%s-%u]\r\n",pMib->wlan[1][0].channel,__FILE__,__LINE__);
#endif			
	if(wlanMibBuf != NULL)
	{
		memcpy(wlanMibBuf, pMib->wlan[wlanifNumA], totalSize);
		memcpy(pMib->wlan[wlanifNumA], pMib->wlan[wlanifNumB], totalSize);
		memcpy(pMib->wlan[wlanifNumB], wlanMibBuf, totalSize);
	
		free(wlanMibBuf);
	}
	
#if 0	
	printf("\r\n pMib->wlan[0][0].wlanDisabled=[%u],__[%s-%u]\r\n",pMib->wlan[0][0].wlanDisabled,__FILE__,__LINE__);
	printf("\r\n pMib->wlan[0][0].phyBandSelect=[%u],__[%s-%u]\r\n",pMib->wlan[0][0].phyBandSelect,__FILE__,__LINE__);
	printf("\r\n pMib->wlan[0][0].channel=[%u],__[%s-%u]\r\n",pMib->wlan[0][0].channel,__FILE__,__LINE__);
	
	printf("\r\n pMib->wlan[1][0].wlanDisabled=[%u],__[%s-%u]\r\n",pMib->wlan[1][0].wlanDisabled,__FILE__,__LINE__);
	printf("\r\n pMib->wlan[1][0].phyBandSelect=[%u],__[%s-%u]\r\n",pMib->wlan[1][0].phyBandSelect,__FILE__,__LINE__);
	printf("\r\n pMib->wlan[1][0].channel=[%u],__[%s-%u]\r\n",pMib->wlan[1][0].channel,__FILE__,__LINE__);
#endif	
#ifdef UNIVERSAL_REPEATER
	int rptEnable1, rptEnable2;
	char rptSsid1[MAX_SSID_LEN], rptSsid2[MAX_SSID_LEN];
	
	memset(rptSsid1, 0x00, MAX_SSID_LEN);
	memset(rptSsid2, 0x00, MAX_SSID_LEN);
	
	apmib_get(MIB_REPEATER_ENABLED1, (void *)&rptEnable1);
	apmib_get(MIB_REPEATER_ENABLED2, (void *)&rptEnable2);
	apmib_get(MIB_REPEATER_SSID1, (void *)rptSsid1);
	apmib_get(MIB_REPEATER_SSID2, (void *)rptSsid2);
	
	apmib_set(MIB_REPEATER_ENABLED1, (void *)&rptEnable2);
	apmib_set(MIB_REPEATER_ENABLED2, (void *)&rptEnable1);
	apmib_set(MIB_REPEATER_SSID1, (void *)rptSsid2);
	apmib_set(MIB_REPEATER_SSID2, (void *)rptSsid1);
#endif
#if VLAN_CONFIG_SUPPORTED 
	unsigned char *vlanMibBuf=NULL;
	totalSize = sizeof(VLAN_CONFIG_T)*5; // 4vap+1root
	vlanMibBuf = malloc(totalSize);
	if(vlanMibBuf != NULL)
	{
		memcpy(vlanMibBuf, pMib->VlanConfigArray+4, totalSize);
		memcpy(pMib->VlanConfigArray+4, pMib->VlanConfigArray+9, totalSize);
		memcpy(pMib->VlanConfigArray+9, vlanMibBuf, totalSize);
	
		free(vlanMibBuf);
	}
	
#endif
}
#endif

void formWlanBand2G5G(request *wp, char *path, char *query)
{
	char *submitUrl;
	char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};
	char *tmpStr;
	int wlanBand2G5GSelect=0;//WNC-NMR0000-Rita-20130305-Error_426-fix warnings of cppcheck (uninitialized value).
	char lan_ip_buf[30]={0}, lan_ip[30];//WNC-NMR0000-Rita-20130310-Error_570-fix warnings of cppcheck (uninitialized value).
	int i;
	
//displayPostDate(wp->post_data);
	
	submitUrl = req_get_cstream_var(wp, ("submit-url"), "");   // hidden page

	tmpStr = req_get_cstream_var(wp, ("wlBandMode"), "");  
	if(tmpStr[0]){
		wlanBand2G5GSelect = atoi(tmpStr);
	}
	if(wlanBand2G5GSelect<BANDMODE2G || wlanBand2G5GSelect>BANDMODESINGLE)
	{
		goto setErr;
	}
	else
	{	
		apmib_set(MIB_WLAN_BAND2G5G_SELECT,(void *)&wlanBand2G5GSelect);
	}
	
	/* init all wireless interface is set radio off and DMACDPHY */
	for(i=0 ; i<NUM_WLAN_INTERFACE ; i++)
	{
		unsigned char wlanif[10];
		memset(wlanif,0x00,sizeof(wlanif));
		sprintf(wlanif, "wlan%d",i);
		if(SetWlan_idx(wlanif))
		{
			int intVal;
#if defined(CONFIG_RTL_92D_SUPPORT) && defined(CONFIG_RTL_92D_DMDP) && !defined(CONFIG_RTL_DUAL_PCIESLOT_BIWLAN_D)
			intVal = DMACDPHY;
#else	
			intVal = SMACSPHY;
#endif
			apmib_set(MIB_WLAN_MAC_PHY_MODE, (void *)&intVal);
			intVal = 1;
			apmib_set(MIB_WLAN_WLAN_DISABLED, (void *)&intVal);
		}						
	}
	
	/* Set expect wireless interface is radio on and SMACSPHY */
	if(wlanBand2G5GSelect == BANDMODE2G)
	{
		short wlanif;
		unsigned char wlanIfStr[10];
		int intVal=0;			
		wlanif = whichWlanIfIs(PHYBAND_2G);
		
		memset(wlanIfStr,0x00,sizeof(wlanIfStr));		
		sprintf(wlanIfStr, "wlan%d",wlanif);
		
		if(SetWlan_idx(wlanIfStr))
		{
			int val;
			val = 0;
			apmib_set(MIB_WLAN_WLAN_DISABLED, (void *)&val);
			val = SMACSPHY;
			apmib_set(MIB_WLAN_MAC_PHY_MODE, (void *)&val);
		}
		
		/* we can't up wlan1 alone, so we swap wlan0 and wlan1 settings */
		if(wlanif != 0)
		{
			/* WNC-NMR000-[Linear]-Libera-20140919-coverity-error-840-NEGATIVE_RETURNS-start */
			if (wlanif < 0){
				printf("[error]:wlanif no match! File: %s, Func: %s, Line: %d @@\n", __FILE__,__FUNCTION__ , __LINE__);
				goto setErr;
			}
			/* WNC-NMR000-[Linear]-Libera-20140919-coverity-error-840-NEGATIVE_RETURNS-end */
			if(wlanif < NUM_WLAN_INTERFACE)	/* WNC-NMR000-[Linear]-Libera-20140919-coverity-error-1090-OVERRUN */
				swapWlanMibSetting(0,wlanif);
			else
				printf("[Error] Not support wlanif=%d, Func: %s, Line: %d\n",wlanif,__FUNCTION__ , __LINE__);	/* WNC-NMR000-[Linear]-Libera-20140919-coverity-error-1090-OVERRUN */
		}	
		
		intVal=0;
		apmib_set(MIB_WISP_WAN_ID, (void *)&intVal);
	}
	else if(wlanBand2G5GSelect == BANDMODE5G)
	{
		short wlanif;
		unsigned char wlanIfStr[10];
		int intVal=0;		
		wlanif = whichWlanIfIs(PHYBAND_5G);
		
		memset(wlanIfStr,0x00,sizeof(wlanIfStr));		
		sprintf(wlanIfStr, "wlan%d",wlanif);
		
		if(SetWlan_idx(wlanIfStr))
		{
			int val;
			val = 0;
			apmib_set(MIB_WLAN_WLAN_DISABLED, (void *)&val);
			val = SMACSPHY;
			apmib_set(MIB_WLAN_MAC_PHY_MODE, (void *)&val);
		}
		
		/* we can't up wlan1 alone, so we swap wlan0 and wlan1 settings */
		if(wlanif != 0)
		{
			if(wlanif < NUM_WLAN_INTERFACE)	/* WNC-NMR000-[Linear]-Libera-20140919-coverity-error-1101-OVERRUN */
				swapWlanMibSetting(0,wlanif);
			else
				printf("[Error] Not support wlanif=%d, Func: %s, Line: %d\n",wlanif,__FUNCTION__ , __LINE__);	/* WNC-NMR000-[Linear]-Libera-20140919-coverity-error-1101-OVERRUN */
	
		}	

		intVal=0;
		apmib_set(MIB_WISP_WAN_ID, (void *)&intVal);
	}
	/* Set both wireless interface is radio on and DMACDPHY */
	else if(wlanBand2G5GSelect == BANDMODEBOTH)
	{
		short wlanif;
		
		for(i=0 ; i<NUM_WLAN_INTERFACE ; i++)
		{
			unsigned char wlanif[10];
			memset(wlanif,0x00,sizeof(wlanif));
			sprintf(wlanif, "wlan%d",i);
			if(SetWlan_idx(wlanif))
			{
				int intVal;
#if defined(CONFIG_RTL_92D_SUPPORT) && defined(CONFIG_RTL_92D_DMDP) && !defined(CONFIG_RTL_DUAL_PCIESLOT_BIWLAN_D)
				intVal = DMACDPHY;
#else
				intVal = SMACSPHY;
#endif
				apmib_set(MIB_WLAN_MAC_PHY_MODE, (void *)&intVal);
				intVal = 0;
				apmib_set(MIB_WLAN_WLAN_DISABLED, (void *)&intVal);
			}
		}
				
		unsigned char wlanIfStr[10];				
		wlanif = whichWlanIfIs(PHYBAND_5G);
		
		/* 92d rule, 5g must up in wlan0 */
		/* phybandcheck */
		if(wlanif != 0)
		{
			swapWlanMibSetting(0,1);			
		}
	}							
	if(wlanBand2G5GSelect == BANDMODESINGLE)
	{
		int intVal=0;
		for(i=0 ; i<NUM_WLAN_INTERFACE ; i++)
		{
			unsigned char wlanif[10];
			memset(wlanif,0x00,sizeof(wlanif));
			sprintf(wlanif, "wlan%d",i);
			if(SetWlan_idx(wlanif))
			{
				int intVal;
				intVal = SMACSPHY;
				apmib_set(MIB_WLAN_MAC_PHY_MODE, (void *)&intVal);				
			}
		}
		
		SetWlan_idx("wlan0");
		intVal = 0;
		apmib_set(MIB_WLAN_WLAN_DISABLED, (void *)&intVal);
#ifndef CONFIG_RTL_8881A_SELECTIVE
		SetWlan_idx("wlan1");
		intVal = 1;
		apmib_set(MIB_WLAN_WLAN_DISABLED, (void *)&intVal);
#endif		
		intVal=0;
		apmib_set(MIB_WISP_WAN_ID, (void *)&intVal);
	}							
	/* set wlan index to 0 to avoid get wrong index when singleband*/
	wlan_idx = 0;
	apmib_update_web(CURRENT_SETTING);
	
#ifdef REBOOT_CHECK
	run_init_script_flag = 1;
#endif		


#ifndef NO_ACTION
	run_init_script("all");
#endif
	apmib_get( MIB_IP_ADDR,  (void *)lan_ip_buf) ;
  sprintf(lan_ip,"%s",inet_ntoa(*((struct in_addr *)lan_ip_buf)) );
  	
  sprintf(tmpBuf,"%s","<h4>Change setting successfully!<BR><BR>Do not turn off or reboot the Device during this time.</h4>");
	OK_MSG_FW(tmpBuf, submitUrl,APPLY_COUNTDOWN_TIME,lan_ip);
return;

setErr:
	ERR_MSG(tmpBuf);
}
#endif //#if defined(CONFIG_RTL_92D_SUPPORT)

#if 1	/* WNC-MR0000-Libera-20120308- wlan page with multi-form for Cheeper */
int wepWncHandler(request *wp, char *tmpBuf, int wlan_id)
{
   	char  *wepKey;
   	char *strKeyLen, *strFormat, /* *strKeyId, */ *strEnabled;
	char key[30];
	int enabled, keyLen, ret, i;
	WEP_T wep;
	ENCRYPT_T encrypt=ENCRYPT_WEP;
	char varName[32]={0}; //WNC-NMR0000-Rita-20130305-Error_63-enlarge array size from 20 to 32 to fix overrun issue.

#ifdef WIFI_SIMPLE_CONFIG
#ifdef MBSSID
	if (vwlan_idx == 0)
	//if (vwlan_idx == 0 || vwlan_idx == 1)	/* WNC-MR000-Libera-20130703- Pocket spec.: change interface: wlan0->wlan0-va0, wlan0-va0->wlan0-va1 */
#endif
	{
		memset(&wps_config_info, 0, sizeof(struct wps_config_info_struct));
		wps_config_info.caller_id = CALLED_FROM_WEPHANDLER;
		apmib_get(MIB_WLAN_ENCRYPT, (void *)&wps_config_info.auth);
		apmib_get(MIB_WLAN_WEP, (void *)&wps_config_info.wep_enc);
		apmib_get(MIB_WLAN_WEP_DEFAULT_KEY, (void *)&wps_config_info.KeyId);
		apmib_get(MIB_WLAN_WEP64_KEY1, (void *)wps_config_info.wep64Key1);
		apmib_get(MIB_WLAN_WEP64_KEY2, (void *)wps_config_info.wep64Key2);
		apmib_get(MIB_WLAN_WEP64_KEY3, (void *)wps_config_info.wep64Key3);
		apmib_get(MIB_WLAN_WEP64_KEY4, (void *)wps_config_info.wep64Key4);
		apmib_get(MIB_WLAN_WEP128_KEY1, (void *)wps_config_info.wep128Key1);
		apmib_get(MIB_WLAN_WEP128_KEY2, (void *)wps_config_info.wep128Key2);
		apmib_get(MIB_WLAN_WEP128_KEY3, (void *)wps_config_info.wep128Key3);
		apmib_get(MIB_WLAN_WEP128_KEY4, (void *)wps_config_info.wep128Key4);
	}
#endif
/*
	sprintf(varName, "wepEnabled%d%d", wlan_id,vwlan_idx);
	strEnabled = req_get_cstream_var(wp, varName, "");
	if ( !strcmp(strEnabled, "ON"))
		enabled = 1;
	else
		enabled = 0;
*/
	enabled = 1;

#if 0	/* WNC-MR000-Libera-20130703- Pocket spec.: change interface: wlan0->wlan0-va0, wlan0-va0->wlan0-va1 */
		int temp_vwlan_idx=0;
		temp_vwlan_idx = vwlan_idx;
		if(vwlan_idx==1){
			temp_vwlan_idx=0;
		}
#endif

	//libera ++ for add auth type setting
	sprintf(varName, "authType%d%d", wlan_id,vwlan_idx);
	//sprintf(varName, "authType%d%d", wlan_id, temp_vwlan_idx);	/* WNC-MR000-Libera-20130703- Pocket spec.: change interface: wlan0->wlan0-va0, wlan0-va0->wlan0-va1 */

	char *strAuth = req_get_cstream_var(wp, varName, "");
	AUTH_TYPE_T authType;
	if (strAuth[0]) { // new UI
		if (!strcmp(strAuth, ("open")))
			authType = AUTH_OPEN;
		else if ( !strcmp(strAuth, ("shared")))
			authType = AUTH_SHARED;
		else
			authType = AUTH_BOTH;
		apmib_set(MIB_WLAN_AUTH_TYPE, (void *)&authType);
		if ( apmib_set(MIB_WLAN_AUTH_TYPE, (void *)&authType) == 0) {
			strcpy(tmpBuf, ("Set authentication failed!"));
			goto setErr_wep;
		}
	}
	//libera ++ for add auth type setting - end
	if ( enabled ) {
		sprintf(varName, "length%d%d", wlan_id,vwlan_idx);
		//sprintf(varName, "length%d%d", wlan_id, temp_vwlan_idx);	/* WNC-MR000-Libera-20130703- Pocket spec.: change interface: wlan0->wlan0-va0, wlan0-va0->wlan0-va1 */		 
		strKeyLen = req_get_cstream_var(wp, varName, "");
		if (!strKeyLen[0]) {
 			strcpy(tmpBuf, ("Key length must exist!"));
			goto setErr_wep;
		}
		if (strKeyLen[0]!='1' && strKeyLen[0]!='2') {
 			strcpy(tmpBuf, ("Invalid key length value!"));
			goto setErr_wep;
		}
		if (strKeyLen[0] == '1')
			wep = WEP64;
		else
			wep = WEP128;
	}
	else
		wep = WEP_DISABLED;

	if ( apmib_set( MIB_WLAN_WEP, (void *)&wep) == 0) {
  		strcpy(tmpBuf, ("Set WEP MIB error!"));
		goto setErr_wep;
	}

	if (wep == WEP_DISABLED)
		encrypt = ENCRYPT_DISABLED;

	if (apmib_set( MIB_WLAN_ENCRYPT, (void *)&encrypt) == 0) {
		strcpy(tmpBuf, ("Set MIB_WLAN_ENCRYPT mib error!"));
		goto setErr_wep;
	}

	if (wep == WEP_DISABLED)
		return 0 ;


	sprintf(varName, "format%d%d", wlan_id,vwlan_idx);
	//sprintf(varName, "format%d%d", wlan_id, temp_vwlan_idx);	/* WNC-MR000-Libera-20130703- Pocket spec.: change interface: wlan0->wlan0-va0, wlan0-va0->wlan0-va1 */
	strFormat = req_get_cstream_var(wp, varName, "");
	if (!strFormat[0]) {
 		strcpy(tmpBuf, ("Key type must exist!"));
		goto setErr_wep;
	}

	if (strFormat[0]!='1' && strFormat[0]!='2') {
		strcpy(tmpBuf, ("Invalid key type value!"));
		goto setErr_wep;
	}

	i = strFormat[0] - '0' - 1;
	if ( apmib_set( MIB_WLAN_WEP_KEY_TYPE, (void *)&i) == 0) {
  		strcpy(tmpBuf, ("Set WEP key type error!"));
		goto setErr_wep;
	}

	if (wep == WEP64) {
		if (strFormat[0]=='1')
			keyLen = WEP64_KEY_LEN;
		else
			keyLen = WEP64_KEY_LEN*2;
	}
	else {
		if (strFormat[0]=='1')
			keyLen = WEP128_KEY_LEN;
		else
			keyLen = WEP128_KEY_LEN*2;
	}

		sprintf(varName, "key%d%d", wlan_id, vwlan_idx);
		//sprintf(varName, "key%d%d", wlan_id, temp_vwlan_idx);	/* WNC-MR000-Libera-20130703- Pocket spec.: change interface: wlan0->wlan0-va0, wlan0-va0->wlan0-va1 */
	wepKey = req_get_cstream_var(wp, varName, "");

	if  (wepKey[0]) {
		if (strlen(wepKey) != keyLen) {
/* WNC-MRXXXX-JOE-PENG-20120403-Modification for NEC GUI customization */
#if 1
			sprintf(tmpBuf, ("̵ͤǤ%d ǻꤷƤ"), keyLen);
			goto ErrPopup_WncWep;
#else
			sprintf(tmpBuf, ("Invalid key length! Expect length is %d"), keyLen);
			goto setErr_wep;
#endif
/* WNC-MRXXXX-JOE-PENG-20120403-end */
		}
		if ( !isAllStar(wepKey) ) {
			if (strFormat[0] == '1') // ascii
				strcpy(key, wepKey);
			else { // hex
				if ( !string_to_hex(wepKey, key, keyLen)) {
/* WNC-MRXXXX-JOE-PENG-20120403-Modification for NEC GUI customization */
#if 1
					/* WNC-NMR0177-JOE-PENG-20120711-Change full-width  to  because full-width  would show incorrectly or disappear in Android 2.X and 4.X */
					/* WNC-Spec.1.12-Rita-20121029-Change alert message */
					strcpy(tmpBuf, ("̵ͤǤ16ʿ:A(a)F(f),09ǻꤷƤ"));
					//strcpy(tmpBuf, ("̵ͤǤ09ޤafǻꤷƤ"));
					goto ErrPopup_WncWep;
#else
	   				strcpy(tmpBuf, ("Invalid wep-key value!"));
					goto setErr_wep;
#endif
/* WNC-MRXXXX-JOE-PENG-20120403-end */

				}
			}
			if (wep == WEP64){
				ret=apmib_set(MIB_WLAN_WEP64_KEY1, (void *)key);
				ret=apmib_set(MIB_WLAN_WEP64_KEY2, (void *)key);
				ret=apmib_set(MIB_WLAN_WEP64_KEY3, (void *)key);
				ret=apmib_set(MIB_WLAN_WEP64_KEY4, (void *)key);
			}else{
				ret=apmib_set(MIB_WLAN_WEP128_KEY1, (void *)key);
				ret=apmib_set(MIB_WLAN_WEP128_KEY2, (void *)key);
				ret=apmib_set(MIB_WLAN_WEP128_KEY3, (void *)key);
				ret=apmib_set(MIB_WLAN_WEP128_KEY4, (void *)key);
			}
			if (!ret) {
	 			strcpy(tmpBuf, ("Set wep-key error!"));
				goto setErr_wep;
			}
		}
	}

#ifdef WIFI_SIMPLE_CONFIG
#ifdef MBSSID
	//if (vwlan_idx == 0 || vwlan_idx == 1)/* WNC-MR000-Libera-20130703- Pocket spec.: change interface: wlan0->wlan0-va0, wlan0-va0->wlan0-va1 */
	if (vwlan_idx == 0)
#endif
	{
		sprintf(varName, "wps_clear_configure_by_reg%d", wlan_id);
		/* WNC-NMR0348-JOE-PENG-20130329-Fix Page Fault occurs during setting on GUI */
		wepKey = req_get_cstream_var(wp, varName, "");
		ret = 0;
		if (wepKey[0])
			ret = atoi(wepKey);
		update_wps_configured(ret);
#if 0	/* WNC-MR000-Libera-20130703- Pocket spec.: change interface: wlan0->wlan0-va0, wlan0-va0->wlan0-va1 (2) */
		int tmp_vwlan_idx=0, tmp_wlan_idx=0;
		tmp_wlan_idx=wlan_idx;
		tmp_vwlan_idx=vwlan_idx;
		wlan_idx = 0;		//radio0
		vwlan_idx = 1;	//wlan0-va0
		update_wps_configured(ret);
		wlan_idx = tmp_wlan_idx;
		vwlan_idx = tmp_vwlan_idx;
#endif
	}
#endif

#if defined(UNIVERSAL_REPEATER) && defined(CONFIG_REPEATER_WPS_SUPPORT)
	if (vwlan_idx == NUM_VWLAN_INTERFACE)
	{
		sprintf(varName, "wps_clear_configure_by_reg%d", wlan_id);
		/* WNC-NMR0348-JOE-PENG-20130329-Fix Page Fault occurs during setting on GUI */
		wepKey = req_get_cstream_var(wp, varName, "");
		ret = 0;
		if (wepKey[0])
			ret = atoi(wepKey);
		update_wps_configured(ret);
	}
#endif

	return 0 ;
setErr_wep:
	return -1 ;

/* WNC-MR0000-JOE-PENG-20120403-for popup error alert */
ErrPopup_WncWep:
	return -2;
/* WNC-MR0000-JOE-PENG-20120403-end */
}

int wpaWncHandler(request *wp, char *tmpBuf, int wlan_id)
{
   	char *strEncrypt, *strVal;
	ENCRYPT_T encrypt;
	int enableRS=0, intVal=0, getPSK=0, len, val=0; //WNC-NMR0000-Rita-20130306-Error_494,Error_544,Error_596-fix warnings of cppcheck (uninitialized value).
	unsigned long reKeyTime;
	SUPP_NONWAP_T suppNonWPA;
	struct in_addr inIp;
	char varName[32];

#if 0	/* WNC-MR000-Libera-20130703- Pocket spec.: change interface: wlan0->wlan0-va0, wlan0-va0->wlan0-va1 */
	int temp_vwlan_idx=0;
	temp_vwlan_idx = vwlan_idx;
	if(vwlan_idx==1){
		temp_vwlan_idx=0;
	}
#endif

	sprintf(varName, "method%d%d", wlan_id, vwlan_idx);
	//sprintf(varName, "method%d%d", wlan_id, temp_vwlan_idx);	/* WNC-MR000-Libera-20130703- Pocket spec.: change interface: wlan0->wlan0-va0, wlan0-va0->wlan0-va1 */

   	strEncrypt = req_get_cstream_var(wp, varName, "");
	if (!strEncrypt[0]) {
 		strcpy(tmpBuf, ("Error! no encryption method."));
		goto setErr_encrypt;
	}
	encrypt = (ENCRYPT_T) strEncrypt[0] - '0';
	if (encrypt!=ENCRYPT_DISABLED && encrypt!=ENCRYPT_WEP && encrypt!=ENCRYPT_WPA
		&& encrypt != ENCRYPT_WPA2 && encrypt != ENCRYPT_WPA2_MIXED

) {
		strcpy(tmpBuf, ("Invalid encryption method!"));
		goto setErr_encrypt;
	}

#ifdef WIFI_SIMPLE_CONFIG
#ifdef MBSSID
	if (vwlan_idx == 0)
	//if (vwlan_idx == 0 || vwlan_idx == 1)	/* WNC-MR000-Libera-20130703- Pocket spec.: change interface: wlan0->wlan0-va0, wlan0-va0->wlan0-va1 */
#endif
	{
		memset(&wps_config_info, 0, sizeof(struct wps_config_info_struct));
		wps_config_info.caller_id = CALLED_FROM_WPAHANDLER;
		apmib_get(MIB_WLAN_ENCRYPT, (void *)&wps_config_info.auth);
		apmib_get(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&wps_config_info.wpa_enc);
		apmib_get(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&wps_config_info.wpa2_enc);
		apmib_get(MIB_WLAN_WPA_PSK, (void *)wps_config_info.wpaPSK);
	}
#endif


	if (apmib_set( MIB_WLAN_ENCRYPT, (void *)&encrypt) == 0) {
  		strcpy(tmpBuf, ("Set MIB_WLAN_ENCRYPT mib error!"));
		goto setErr_encrypt;
	}

	if (encrypt == ENCRYPT_DISABLED || encrypt == ENCRYPT_WEP) {
		sprintf(varName, "use1x%d%d", wlan_id, vwlan_idx);
		//sprintf(varName, "use1x%d%d", wlan_id, temp_vwlan_idx);	/* WNC-MR000-Libera-20130703- Pocket spec.: change interface: wlan0->wlan0-va0, wlan0-va0->wlan0-va1 */		
		strVal = req_get_cstream_var(wp, varName, "");
		if ( !strcmp(strVal, "ON")) {
			apmib_get( MIB_WLAN_MODE, (void *)&intVal);
			if (intVal !=AP_MODE && intVal != AP_WDS_MODE) { // not AP mode

				strcpy(tmpBuf, ("Error! 802.1x authentication cannot be used when device is set to client mode."));
				goto setErr_encrypt;
				//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20130814, fix coverity error 831
				//intVal = 0;
			}
			else {
				intVal = 1;
				enableRS = 1;
			}
		}
		else
			intVal = 0;

		if ( apmib_set( MIB_WLAN_ENABLE_1X, (void *)&intVal) == 0) {
  			strcpy(tmpBuf, ("Set 1x enable flag error!"));
			goto setErr_encrypt;
		}

		if (encrypt == ENCRYPT_WEP) {
	 		WEP_T wep;
			if ( !apmib_get( MIB_WLAN_WEP,  (void *)&wep) ) {
				strcpy(tmpBuf, ("Get MIB_WLAN_WEP MIB error!"));
				goto setErr_encrypt;
			}
			if (wep == WEP_DISABLED) {
				wep = WEP64;
				if ( apmib_set( MIB_WLAN_WEP, (void *)&wep) == 0) {
		  			strcpy(tmpBuf, ("Set WEP MIB error!"));
					goto setErr_encrypt;
				}
			}
		}
		else {
			sprintf(varName, "useMacAuth%d", wlan_id);
			strVal = req_get_cstream_var(wp, varName, "");
			if ( !strcmp(strVal, "ON")) {
				intVal = 1;
				enableRS = 1;
			}
			else
				intVal = 0;
			if ( apmib_set( MIB_WLAN_MAC_AUTH_ENABLED, (void *)&intVal) == 0) {
  				strcpy(tmpBuf, ("Set MIB_WLAN_MAC_AUTH_ENABLED MIB error!"));
				goto setErr_encrypt;
			}
		}
	}
	else {
		// support nonWPA client

		sprintf(varName, "nonWpaSupp%d", wlan_id);
 		strVal = req_get_cstream_var(wp, varName, "");
		apmib_get( MIB_WLAN_ENABLE_SUPP_NONWPA, (void *)&intVal);
		if(strVal[0])
		{
		if ( !strcmp(strVal, "ON"))
			intVal = 1;
		else
			intVal = 0;
		}
		if ( apmib_set( MIB_WLAN_ENABLE_SUPP_NONWPA, (void *)&intVal) == 0) {
  			strcpy(tmpBuf, ("Set MIB_WLAN_ENABLE_SUPP_NONWPA mib error!"));
			goto setErr_encrypt;
		}
		if ( intVal ) {
			suppNonWPA = SUPP_NONWPA_NONE;
			sprintf(varName, "nonWpaWep%d", wlan_id);
			strVal = req_get_cstream_var(wp, varName, "");
			if ( !strcmp(strVal, "ON"))
				suppNonWPA |= SUPP_NONWPA_WEP;

			sprintf(varName, "nonWpa1x%d", wlan_id);
			strVal = req_get_cstream_var(wp, varName, "");
			if ( !strcmp(strVal, "ON")) {
				suppNonWPA |= SUPP_NONWPA_1X;
				enableRS = 1;
			}

			if ( apmib_set( MIB_WLAN_SUPP_NONWPA, (void *)&suppNonWPA) == 0) {
  				strcpy(tmpBuf, ("Set MIB_WLAN_SUPP_NONWPA mib error!"));
				goto setErr_encrypt;
			}
		}

		// WPA authentication
		sprintf(varName, "wpaAuth%d%d", wlan_id, vwlan_idx);
		//sprintf(varName, "wpaAuth%d%d", wlan_id, temp_vwlan_idx);	/* WNC-MR000-Libera-20130703- Pocket spec.: change interface: wlan0->wlan0-va0, wlan0-va0->wlan0-va1 */
		strVal = req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			if ( !strcmp(strVal, ("eap"))) {
				apmib_get( MIB_WLAN_MODE, (void *)&intVal);
#ifndef TLS_CLIENT
				if (intVal!=AP_MODE && intVal!=AP_WDS_MODE) { // not AP mode
#ifdef CONFIG_RTL_802_1X_CLIENT_SUPPORT
//omission
#else
					strcpy(tmpBuf, ("Error! WPA-RADIUS cannot be used when device is set to client mode."));
					goto setErr_encrypt;
#endif
				}
#endif
				intVal = WPA_AUTH_AUTO;
				enableRS = 1;
			}
			else if ( !strcmp(strVal, ("psk"))) {
				intVal = WPA_AUTH_PSK;
				getPSK = 1;

			}
			else {
				strcpy(tmpBuf, ("Error! Invalid wpa authentication value."));
				goto setErr_encrypt;
			}
			if ( apmib_set(MIB_WLAN_WPA_AUTH, (void *)&intVal) == 0) {
				strcpy(tmpBuf, ("Set MIB_WLAN_AUTH_TYPE failed!"));
				goto setErr_encrypt;
			}
		}

		// cipher suite
		// sc_yang write the ciphersuite according to  encrypt for wpa
		// wpa mixed mode is not implemented yet.

// get cipher suite from user setting, for wpa-aes -------------------
#if 0
		intVal = 0 ;
		if( (encrypt ==  ENCRYPT_WPA) || (encrypt == ENCRYPT_WPA2_MIXED) )
			intVal =   WPA_CIPHER_TKIP ;
		if ( apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&intVal) == 0) {
				strcpy(tmpBuf, ("Set MIB_WLAN_WPA_CIPHER_SUITE failed!"));
				goto setErr_encrypt;
		}
		//set wpa2UniCipher  for wpa2
		// wpa2 mixed mode is not implemented yet.
		intVal = 0 ;
		if( (encrypt ==  ENCRYPT_WPA2) || (encrypt == ENCRYPT_WPA2_MIXED) )
			intVal =   WPA_CIPHER_AES ;
		if ( apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&intVal) == 0) {
				strcpy(tmpBuf, ("Set MIB_WLAN_WPA2_UNICIPHER failed!"));
				goto setErr_encrypt;
		}
#endif
		//if ((encrypt == ENCRYPT_WPA) || (encrypt == ENCRYPT_WPA2_MIXED))
		{
			sprintf(varName, "ciphersuite%d%d", wlan_id, vwlan_idx);
			//sprintf(varName, "ciphersuite%d%d", wlan_id, temp_vwlan_idx);	/* WNC-MR000-Libera-20130703- Pocket spec.: change interface: wlan0->wlan0-va0, wlan0-va0->wlan0-va1 */
			strVal = req_get_cstream_var(wp, varName, "");
			if (strVal[0]) {
				intVal = 0;
				if ( strstr(strVal, ("tkip")))
					intVal |= WPA_CIPHER_TKIP;
				if ( strstr(strVal, ("aes")))
					intVal |= WPA_CIPHER_AES;
				if (intVal == 0) {
					strcpy(tmpBuf, ("Invalid value of cipher suite!"));
					goto setErr_encrypt;
				}
			}
			else{
				int band_value=0;
				 apmib_get( MIB_WLAN_BAND, (void *)&band_value);
				 if(band_value == 10 || band_value ==11)
				 	intVal = WPA_CIPHER_AES;
				 else
					intVal = WPA_CIPHER_TKIP;
			}

			// check if both TKIP and AES cipher are selected in client mode
			apmib_get(MIB_WLAN_MODE, (void *)&val);
			if (val == CLIENT_MODE) {
				apmib_get(MIB_WLAN_NETWORK_TYPE, &val);
				if (val == INFRASTRUCTURE && intVal == WPA_CIPHER_MIXED) {
					strcpy(tmpBuf, ("Error! Can't set cipher to TKIP + AES when device is set to client mode."));
					goto setErr_encrypt;
				}
			}	// david+2006-1-11
			if ( apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&intVal) == 0) {
				strcpy(tmpBuf, ("Set MIB_WLAN_WPA_CIPHER_SUITE failed!"));
				goto setErr_encrypt;
			}
		}
		//if ((encrypt == ENCRYPT_WPA2) || (encrypt == ENCRYPT_WPA2_MIXED))
		{
			sprintf(varName, "wpa2ciphersuite%d%d", wlan_id, vwlan_idx);
			//sprintf(varName, "wpa2ciphersuite%d%d", wlan_id, temp_vwlan_idx);	/* WNC-MR000-Libera-20130703- Pocket spec.: change interface: wlan0->wlan0-va0, wlan0-va0->wlan0-va1 */
			strVal = req_get_cstream_var(wp, varName, "");
			if (strVal[0]) {
				intVal = 0;
				if ( strstr(strVal, ("tkip")))
					intVal |= WPA_CIPHER_TKIP;
				if ( strstr(strVal, ("aes")))
					intVal |= WPA_CIPHER_AES;
				if (intVal == 0) {
					strcpy(tmpBuf, ("Invalid value of wpa2 cipher suite!"));
					goto setErr_encrypt;
				}
			}
			else
				intVal = WPA_CIPHER_AES;

			// check if both TKIP and AES cipher are selected in client mode
			apmib_get(MIB_WLAN_MODE, (void *)&val);
			if (val == CLIENT_MODE) {
				apmib_get(MIB_WLAN_NETWORK_TYPE, &val);
				if (val == INFRASTRUCTURE && intVal == WPA_CIPHER_MIXED) {
					strcpy(tmpBuf, ("Error! Can't set cipher to TKIP + AES when device is set to client mode."));
					goto setErr_encrypt;
				}
			}	// david+2006-1-11
			if ( apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&intVal) == 0) {
				strcpy(tmpBuf, ("Set MIB_WLAN_WPA2_CIPHER_SUITE failed!"));
				goto setErr_encrypt;
			}
		}
//-------------------------------------------------- david, 2005-8-03

		if( ((encrypt ==  ENCRYPT_WPA2) || (encrypt == ENCRYPT_WPA2_MIXED)) &&
		    enableRS == 1){
			sprintf(varName, "preAuth%d", wlan_id);
			strVal = req_get_cstream_var(wp, varName, "");
			if ( !strcmp(strVal, "ON"))
				intVal = 1 ;
			else
				intVal = 0 ;
			if ( apmib_set(MIB_WLAN_WPA2_PRE_AUTH, (void *)&intVal) == 0) {
				strcpy(tmpBuf, ("Set MIB_WLAN_WPA_CIPHER_SUITE failed!"));
				goto setErr_encrypt;
			}
		}
		// pre-shared key
		if ( getPSK ) {
			//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20130814, fix coverity error 821
			int oldFormat = 0, oldPskLen, i;

			sprintf(varName, "pskFormat%d%d", wlan_id, vwlan_idx);
			//sprintf(varName, "pskFormat%d%d", wlan_id, temp_vwlan_idx);	/* WNC-MR000-Libera-20130703- Pocket spec.: change interface: wlan0->wlan0-va0, wlan0-va0->wlan0-va1 */
   			strVal = req_get_cstream_var(wp, varName, "");
			if (!strVal[0]) {
	 			strcpy(tmpBuf, ("Error! no psk format."));
				goto setErr_encrypt;
			}
			intVal = strVal[0] - '0';
			if (intVal != 0 && intVal != 1) {
	 			strcpy(tmpBuf, ("Error! invalid psk format."));
				goto setErr_encrypt;
			}

			// remember current psk format and length to compare to default case "****"
			apmib_get(MIB_WLAN_PSK_FORMAT, (void *)&oldFormat);
			apmib_get(MIB_WLAN_WPA_PSK, (void *)tmpBuf);
			oldPskLen = strlen(tmpBuf);

			sprintf(varName, "pskValue%d%d", wlan_id, vwlan_idx);
			//sprintf(varName, "pskValue%d%d", wlan_id, temp_vwlan_idx);	/* WNC-MR000-Libera-20130703- Pocket spec.: change interface: wlan0->wlan0-va0, wlan0-va0->wlan0-va1 */
			strVal = req_get_cstream_var(wp, varName, "");
			len = strlen(strVal);

			if (oldFormat == intVal && len == oldPskLen ) {
				for (i=0; i<len; i++) {
					if ( strVal[i] != '*' )
						break;
				}
				if (i == len)
					goto rekey_time;
			}

			if ( apmib_set(MIB_WLAN_PSK_FORMAT, (void *)&intVal) == 0) {
				strcpy(tmpBuf, ("Set MIB_WLAN_PSK_FORMAT failed!"));
				goto setErr_encrypt;
			}

			if (intVal==1) { // hex
				if (len!=MAX_PSK_LEN || !string_to_hex(strVal, tmpBuf, MAX_PSK_LEN)) {
	 				strcpy(tmpBuf, ("Error! invalid psk value."));
					goto setErr_encrypt;
				}
			}
			else { // passphras
#if 1 /* spider project , Mike Yeh */			
				if (len==0 || len > MAX_PSK_LEN ) {
#else			
				if (len==0 || len > (MAX_PSK_LEN-1) ) {
#endif
	 				strcpy(tmpBuf, ("Error! invalid psk value."));
					goto setErr_encrypt;
				}
			}
			if ( !apmib_set(MIB_WLAN_WPA_PSK, (void *)strVal)) {
				strcpy(tmpBuf, ("Set MIB_WLAN_WPA_PSK error!"));
				goto setErr_encrypt;
			}
		}
rekey_time:
		// group key rekey time
		reKeyTime = 0;
		sprintf(varName, "groupKeyTimeDay%d", wlan_id);
		strVal = req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, ("Error! Invalid value of rekey day."));
				goto setErr_encrypt;
			}
			reKeyTime += intVal*86400;
		}
		sprintf(varName, "groupKeyTimeHr%d", wlan_id);
		strVal = req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, ("Error! Invalid value of rekey hr."));
				goto setErr_encrypt;
			}
			reKeyTime += intVal*3600;
		}
		sprintf(varName, "groupKeyTimeMin%d", wlan_id);
		strVal = req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, ("Error! Invalid value of rekey min."));
				goto setErr_encrypt;
			}
			reKeyTime += intVal*60;
		}

		sprintf(varName, "groupKeyTimeSec%d", wlan_id);
		strVal = req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, ("Error! Invalid value of rekey sec."));
				goto setErr_encrypt;
			}
			reKeyTime += intVal;
		}
		if (reKeyTime) {
			if ( !apmib_set(MIB_WLAN_WPA_GROUP_REKEY_TIME, (void *)&reKeyTime)) {
				strcpy(tmpBuf, ("Set MIB_WLAN_WPA_GROUP_REKEY_TIME error!"));
				goto setErr_encrypt;
			}
		}
	}

	apmib_set( MIB_WLAN_ENABLE_1X, (void *)&enableRS);
	if (enableRS == 1) { // if 1x enabled, get RADIUS server info
		{
		sprintf(varName, "radiusPort%d", wlan_id);
		strVal = req_get_cstream_var(wp, varName, "");
		if (!strVal[0]) {
			strcpy(tmpBuf, ("No RS port number!"));
			goto setErr_encrypt;
		}
		if (!string_to_dec(strVal, &intVal) || intVal<=0 || intVal>65535) {
			strcpy(tmpBuf, ("Error! Invalid value of RS port number."));
			goto setErr_encrypt;
		}
		if ( !apmib_set(MIB_WLAN_RS_PORT, (void *)&intVal)) {
			strcpy(tmpBuf, ("Set RS port error!"));
			goto setErr_encrypt;
		}
		sprintf(varName, "radiusIP%d", wlan_id);
		strVal = req_get_cstream_var(wp, varName, "");
		if (!strVal[0]) {
			strcpy(tmpBuf, ("No RS IP address!"));
			goto setErr_encrypt;
		}
		if ( !inet_aton(strVal, &inIp) ) {
			strcpy(tmpBuf, ("Invalid RS IP-address value!"));
			goto setErr_encrypt;
		}
		if ( !apmib_set(MIB_WLAN_RS_IP, (void *)&inIp)) {
			strcpy(tmpBuf, ("Set RS IP-address error!"));
			goto setErr_encrypt;
		}
		sprintf(varName, "radiusPass%d", wlan_id);
		strVal = req_get_cstream_var(wp, varName, "");
		if (strlen(strVal) > (MAX_RS_PASS_LEN -1) ) {
			strcpy(tmpBuf, ("RS password length too long!"));
			goto setErr_encrypt;
		}
		if ( !apmib_set(MIB_WLAN_RS_PASSWORD, (void *)strVal)) {
			strcpy(tmpBuf, ("Set RS password error!"));
			goto setErr_encrypt;
		}

		sprintf(varName, "radiusRetry%d", wlan_id);
		strVal = req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, ("Invalid RS retry value!"));
				goto setErr_encrypt;
			}
			if ( !apmib_set(MIB_WLAN_RS_MAXRETRY, (void *)&intVal)) {
				strcpy(tmpBuf, ("Set MIB_WLAN_RS_MAXRETRY error!"));
				goto setErr_encrypt;
			}
		}
		sprintf(varName, "radiusTime%d", wlan_id);
		strVal = req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, ("Invalid RS time value!"));
				goto setErr_encrypt;
			}
			if ( !apmib_set(MIB_WLAN_RS_INTERVAL_TIME, (void *)&intVal)) {
				strcpy(tmpBuf, ("Set MIB_WLAN_RS_INTERVAL_TIME error!"));
				goto setErr_encrypt;
			}
		}
		sprintf(varName, "useAccount%d", wlan_id);
		strVal = req_get_cstream_var(wp, varName, "");
		if ( !strcmp(strVal, "ON"))
			intVal = 1;
		else
			intVal = 0;
		if ( apmib_set( MIB_WLAN_ACCOUNT_RS_ENABLED, (void *)&intVal) == 0) {
  			strcpy(tmpBuf, ("Set MIB_WLAN_ACCOUNT_RS_ENABLED mib error!"));
			goto setErr_encrypt;
		}
		if (intVal == 0)
			goto get_wepkey;

		sprintf(varName, "accountPort%d", wlan_id);
		strVal = req_get_cstream_var(wp, varName, "");
		if (!strVal[0]) {
			strcpy(tmpBuf, ("No account RS port number!"));
			goto setErr_encrypt;
		}
		if (!string_to_dec(strVal, &intVal) || intVal<=0 || intVal>65535) {
			strcpy(tmpBuf, ("Error! Invalid value of account RS port number."));
			goto setErr_encrypt;
		}
		if ( !apmib_set(MIB_WLAN_ACCOUNT_RS_PORT, (void *)&intVal)) {
			strcpy(tmpBuf, ("Set account RS port error!"));
			goto setErr_encrypt;
		}
		sprintf(varName, "accountIP%d", wlan_id);
		strVal = req_get_cstream_var(wp, varName, "");
		if (!strVal[0]) {
			strcpy(tmpBuf, ("No account RS IP address!"));
			goto setErr_encrypt;
		}
		if ( !inet_aton(strVal, &inIp) ) {
			strcpy(tmpBuf, ("Invalid account RS IP-address value!"));
			goto setErr_encrypt;
		}
		if ( !apmib_set(MIB_WLAN_ACCOUNT_RS_IP, (void *)&inIp)) {
			strcpy(tmpBuf, ("Set account RS IP-address error!"));
			goto setErr_encrypt;
		}
		sprintf(varName, "accountPass%d", wlan_id);
		strVal = req_get_cstream_var(wp, varName, "");
		if (strlen(strVal) > (MAX_RS_PASS_LEN -1) ) {
			strcpy(tmpBuf, ("Account RS password length too long!"));
			goto setErr_encrypt;
		}
		if ( !apmib_set(MIB_WLAN_ACCOUNT_RS_PASSWORD, (void *)strVal)) {
			strcpy(tmpBuf, ("Set account RS password error!"));
			goto setErr_encrypt;
		}
		sprintf(varName, "accountRetry%d", wlan_id);
		strVal = req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, ("Invalid account RS retry value!"));
				goto setErr_encrypt;
			}
			if ( !apmib_set(MIB_WLAN_ACCOUNT_RS_MAXRETRY, (void *)&intVal)) {
				strcpy(tmpBuf, ("Set MIB_WLAN_ACCOUNT_RS_MAXRETRY error!"));
				goto setErr_encrypt;
			}
		}
		sprintf(varName, "accountTime%d", wlan_id);
		strVal = req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, ("Invalid account RS time value!"));
				goto setErr_encrypt;
			}
			if ( !apmib_set(MIB_WLAN_ACCOUNT_RS_INTERVAL_TIME, (void *)&intVal)) {
				strcpy(tmpBuf, ("Set MIB_WLAN_ACCOUNT_RS_INTERVAL_TIME error!"));
				goto setErr_encrypt;
			}
		}
		sprintf(varName, "accountUpdateEnabled%d", wlan_id);
		strVal = req_get_cstream_var(wp, varName, "");
		if ( !strcmp(strVal, "ON"))
			intVal = 1;
		else
			intVal = 0;
		if ( apmib_set( MIB_WLAN_ACCOUNT_RS_UPDATE_ENABLED, (void *)&intVal) == 0) {
			strcpy(tmpBuf, ("Set MIB_WLAN_ACCOUNT_RS_UPDATE_ENABLED mib error!"));
			goto setErr_encrypt;
		}
		sprintf(varName, "accountUpdateTime%d", wlan_id);
		strVal = req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, ("Error! Invalid value of update time"));
				goto setErr_encrypt;
			}
			if ( !apmib_set(MIB_WLAN_ACCOUNT_RS_UPDATE_DELAY, (void *)&intVal)) {
				strcpy(tmpBuf, ("Set MIB_WLAN_ACCOUNT_RS_UPDATE_DELAY mib error!"));
				goto setErr_encrypt;
			}
		}

get_wepkey:
		// get 802.1x WEP key length
		sprintf(varName, "wepKeyLen%d", wlan_id);
		strVal = req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			if ( !strcmp(strVal, ("wep64")))
				intVal = WEP64;
			else if ( !strcmp(strVal, ("wep128")))
				intVal = WEP128;
			else {
				strcpy(tmpBuf, ("Error! Invalid wepkeylen value."));
				goto setErr_encrypt;
			}
			if ( apmib_set(MIB_WLAN_WEP, (void *)&intVal) == 0) {
				strcpy(tmpBuf, ("Set MIB_WLAN_WEP failed!"));
				goto setErr_encrypt;
			}
		}
	}
	}

#ifdef WIFI_SIMPLE_CONFIG
#ifdef MBSSID
	if (vwlan_idx == 0)
	//if (vwlan_idx == 0 || vwlan_idx == 1)/* WNC-MR000-Libera-20130703- Pocket spec.: change interface: wlan0->wlan0-va0, wlan0-va0->wlan0-va1 */
#endif
	{
		sprintf(varName, "wps_clear_configure_by_reg%d", wlan_id);
		/* WNC-NMR0348-JOE-PENG-20130329-Fix Page Fault occurs during setting on GUI */
		strVal = req_get_cstream_var(wp, varName, "");
		val = 0;
		if (strVal[0])
			val = atoi(strVal);
		update_wps_configured(val);
#if 0	/* WNC-MR000-Libera-20130703- Pocket spec.: change interface: wlan0->wlan0-va0, wlan0-va0->wlan0-va1 (2) */
		int tmp_vwlan_idx=0, tmp_wlan_idx=0;
		tmp_wlan_idx=wlan_idx;
		tmp_vwlan_idx=vwlan_idx;
		wlan_idx = 0;		//radio0
		vwlan_idx = 1;	//wlan0-va0
		update_wps_configured(val);
		wlan_idx = tmp_wlan_idx;
		vwlan_idx = tmp_vwlan_idx;
#endif

	}
#endif
	return 0 ;
setErr_encrypt:
	fprintf(stderr, "ERROR:%s- %s:%d\n",tmpBuf,__FILE__, __LINE__);
	return -1 ;
}

#endif	/* WNC-MR0000-Libera-20120308- wlan page with multi-form for Cheeper - END */



void formWlanSetup(request *wp, char *path, char *query)
{
	char *submitUrl;
	char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};
	int mode=-1;
	int warn=0;
	int val;	
	char *strVal=NULL;	
#if defined(CONFIG_RTL_92D_SUPPORT)
	int wlanif=0;
	
	PHYBAND_TYPE_T phyBandSelect = PHYBAND_OFF; 
	int wlanBand2G5GSelect=PHYBAND_OFF;
#endif
//displayPostDate(wp->post_data);	

#if defined(CONFIG_RTL_92D_SUPPORT)		
	apmib_get(MIB_WLAN_BAND2G5G_SELECT,(void *)&wlanBand2G5GSelect);

	if(wlanBand2G5GSelect == BANDMODESINGLE)
	{

		
		strVal=req_get_cstream_var(wp,("Band2G5GSupport"),"");
		if(strVal[0])
		{
			
			phyBandSelect= atoi(strVal);		
			wlanif = whichWlanIfIs(phyBandSelect);			
				

			if(wlanif != 0)
			{
				/* WNC-NMR000-[Linear]-Libera-20140919-coverity-error-830-NEGATIVE_RETURNS-start */
				if (wlanif<0){
					strcpy(tmpBuf, ("No wlanif is matched!"));
					printf("\r\n __[%s-%u]\r\n",__FILE__,__LINE__);
					goto setErr_wlan;
				}
				/* WNC-NMR000-[Linear]-Libera-20140919-coverity-error-830-NEGATIVE_RETURNS-start */
				val = 1;
				apmib_set(MIB_WLAN_WLAN_DISABLED, (void *)&val); //close original interface

//printf("\r\n __[%s-%u]\r\n",__FILE__,__LINE__);
				/* Swap selected band to wlan0 */
				if(wlanif < NUM_WLAN_INTERFACE)	/* WNC-NMR000-[Linear]-Libera-20140919-coverity-error-1066-OVERRUN */
					swapWlanMibSetting(0,wlanif);
				else
					printf("[Error] Not support wlanif=%d, Func: %s, Line: %d\n",wlanif,__FUNCTION__ , __LINE__);	/* WNC-NMR000-[Linear]-Libera-20140919-coverity-error-1066-OVERRUN */
					
//printf("\r\n __[%s-%u]\r\n",__FILE__,__LINE__);

				val = 0;
				apmib_set(MIB_WLAN_WLAN_DISABLED, (void *)&val); //enable after interface
				//apmib_update_web(CURRENT_SETTING);
			}
		}
		
#if defined(CONFIG_RTL_P2P_SUPPORT)		
		char varName[20];
		sprintf(varName, "mode%d", wlan_idx);
		strVal = req_get_cstream_var(wp, varName, "");
	
		if(strVal[0] == NULL)
		{
			char strtmp[20];
			
			apmib_get( MIB_WLAN_MODE, (void *)&val);
			sprintf(strtmp,"%d",val);
			strVal = strtmp;		
		}
		
		val=atoi(strVal);
		
		if(val == P2P_SUPPORT_MODE)
		{
			int ori_wlan_idx = wlan_idx;
			int val2 = 0;
			apmib_set( MIB_DHCP, (void *)&val2);
			
			wlan_idx = 0;
			apmib_set( MIB_WLAN_MODE, (void *)&val);
			
			wlan_idx = 1;
			apmib_set( MIB_WLAN_MODE, (void *)&val);
			
			wlan_idx = ori_wlan_idx;
			
		}
#endif //#if defined(CONFIG_RTL_P2P_SUPPORT)
		
	}
#endif //#if defined(CONFIG_RTL_92D_SUPPORT)

//printf("\r\n __[%s-%u]\r\n",__FILE__,__LINE__);


	if(wlanHandler(wp, tmpBuf, &mode, wlan_idx) < 0)
		goto setErr_wlan ;
#if defined(WLAN_PROFILE)
	if(wlProfileHandler(wp, tmpBuf, wlan_idx) < 0)
	{
//printf("\r\n __[%s-%u]\r\n",__FILE__,__LINE__);	
		goto setErr_wlan;
	}
	
#endif //#if defined(WLAN_PROFILE)	

	if (mode == 1) { // not AP mode
		//set cipher suit to AES + tkip if wpa2 mixed mode is set
		ENCRYPT_T encrypt;
		int intVal;
		apmib_get( MIB_WLAN_ENCRYPT, (void *)&encrypt);
		if(encrypt == ENCRYPT_WPA2_MIXED){
			intVal =   WPA_CIPHER_MIXED ;
			
			if ( apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&intVal) == 0) {
				strcpy(tmpBuf, ("Set MIB_WLAN_WPA2_UNICIPHER failed!"));
				goto setErr_wlan;
			}
			intVal =   WPA_CIPHER_MIXED;
			if ( apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&intVal) == 0) {
				strcpy(tmpBuf, ("Set MIB_WLAN_WPA_CIPHER_SUITE failed!"));
				goto setErr_wlan;
			}
		}
	}
	if (mode != 1) { // AP mode
		//set wpa2-aes  if wpa mode is set
		ENCRYPT_T encrypt;
		int intVal;
		apmib_get( MIB_WLAN_ENCRYPT, (void *)&encrypt);
		if(encrypt == ENCRYPT_WPA){
			intVal =   WPA_CIPHER_AES ;
			if ( apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&intVal) == 0) {
				strcpy(tmpBuf, ("Set MIB_WLAN_WPA2_UNICIPHER failed!"));
				goto setErr_wlan;
			}
			encrypt = ENCRYPT_WPA2;
			if ( apmib_set(MIB_WLAN_ENCRYPT, (void *)&encrypt) == 0) {
				strcpy(tmpBuf, ("Set MIB_WLAN_WPA2_UNICIPHER failed!"));
				goto setErr_wlan;
			}
			strcpy(tmpBuf, ("Warning! WPA encryption is only supported in client Mode. <BR> Change to WPA2 Encryption."));
			warn = 1;
		}
	}
	
	apmib_update_web(CURRENT_SETTING);

#ifndef NO_ACTION
	run_init_script("bridge");
#endif

	submitUrl = req_get_cstream_var(wp, ("wlan-url"), "");   // hidden page
	if (warn) {
		OK_MSG1(tmpBuf, submitUrl);
	}
	else {
		OK_MSG(submitUrl);
	}
	return;

setErr_wlan:
	ERR_MSG(tmpBuf);
}

int wepHandler(request *wp, char *tmpBuf, int wlan_id)
{
   	char  *wepKey;
   	char *strKeyLen, *strFormat, *strAuth, /* *strKeyId, */ *strEnabled;
	char key[30];
	int enabled, keyLen, ret, i;
	WEP_T wep;
	ENCRYPT_T encrypt=ENCRYPT_WEP;
	char varName[32]={0};//WNC-NMR0000-Rita-20130305-Error_65-enlarge array size from 20 to 32 to fix overrun issue.
	int wlanMode, rptEnabled;

//printf("\r\n wlan_idx=[%d],vwlan_idx=[%d],__[%s-%u]\r\n",wlan_idx,vwlan_idx,__FILE__,__LINE__);	
//displayPostDate(wp->post_data);

#if 0 //NO need to change authType in client mode??? Keith
	apmib_get( MIB_WLAN_MODE, (void *)&wlanMode);
	if(wlan_id == 0)
		apmib_get( MIB_REPEATER_ENABLED1, (void *)&rptEnabled);
	else
		apmib_get( MIB_REPEATER_ENABLED2, (void *)&rptEnabled);

//printf("\r\n wlanMode=[%d],rptEnabled=[%d],__[%s-%u]\r\n",wlanMode,rptEnabled,__FILE__,__LINE__);	

	if(wlanMode == CLIENT_MODE || ((wlanMode == AP_MODE || wlanMode == AP_WDS_MODE) && rptEnabled == 1))
	{
		int auahType;
		
		apmib_get( MIB_WLAN_AUTH_TYPE, (void *)&auahType);
//printf("\r\n auahType=[%d],__[%s-%u]\r\n",auahType,__FILE__,__LINE__);	

		if(auahType == AUTH_BOTH)
		{
			auahType= AUTH_OPEN;
//printf("\r\n auahType=[%d],__[%s-%u]\r\n",auahType,__FILE__,__LINE__);				
			apmib_set( MIB_WLAN_AUTH_TYPE, (void *)&auahType);
		}
		
	}
#endif //#if 0 //NO need to change authType in client mode??? Keith

#ifdef WIFI_SIMPLE_CONFIG
#ifdef MBSSID
	if (vwlan_idx == 0)
#endif
	{
		memset(&wps_config_info, 0, sizeof(struct wps_config_info_struct));
		wps_config_info.caller_id = CALLED_FROM_WEPHANDLER;
		apmib_get(MIB_WLAN_ENCRYPT, (void *)&wps_config_info.auth);
		apmib_get(MIB_WLAN_WEP, (void *)&wps_config_info.wep_enc);
		apmib_get(MIB_WLAN_WEP_DEFAULT_KEY, (void *)&wps_config_info.KeyId);
		apmib_get(MIB_WLAN_WEP64_KEY1, (void *)wps_config_info.wep64Key1);
		apmib_get(MIB_WLAN_WEP64_KEY2, (void *)wps_config_info.wep64Key2);
		apmib_get(MIB_WLAN_WEP64_KEY3, (void *)wps_config_info.wep64Key3);
		apmib_get(MIB_WLAN_WEP64_KEY4, (void *)wps_config_info.wep64Key4);
		apmib_get(MIB_WLAN_WEP128_KEY1, (void *)wps_config_info.wep128Key1);
		apmib_get(MIB_WLAN_WEP128_KEY2, (void *)wps_config_info.wep128Key2);
		apmib_get(MIB_WLAN_WEP128_KEY3, (void *)wps_config_info.wep128Key3);
		apmib_get(MIB_WLAN_WEP128_KEY4, (void *)wps_config_info.wep128Key4);
	}
#endif

	sprintf(varName, "wepEnabled%d", wlan_id);
	strEnabled = req_get_cstream_var(wp, varName, "");
	if ( !strcmp(strEnabled, "ON"))
		enabled = 1;
	else
		enabled = 0;

	if ( enabled ) {
		sprintf(varName, "length%d", wlan_id);
		strKeyLen = req_get_cstream_var(wp, varName, "");
		if (!strKeyLen[0]) {
 			strcpy(tmpBuf, ("Key length must exist!"));
			goto setErr_wep;
		}
		if (strKeyLen[0]!='1' && strKeyLen[0]!='2') {
 			strcpy(tmpBuf, ("Invalid key length value!"));
			goto setErr_wep;
		}
		if (strKeyLen[0] == '1')
			wep = WEP64;
		else
			wep = WEP128;
	}
	else
		wep = WEP_DISABLED;

	if ( apmib_set( MIB_WLAN_WEP, (void *)&wep) == 0) {
  		strcpy(tmpBuf, ("Set WEP MIB error!"));
		goto setErr_wep;
	}

	if (wep == WEP_DISABLED)
		encrypt = ENCRYPT_DISABLED;

	if (apmib_set( MIB_WLAN_ENCRYPT, (void *)&encrypt) == 0) {
		strcpy(tmpBuf, ("Set MIB_WLAN_ENCRYPT mib error!"));
		goto setErr_wep;
	}

	if (wep == WEP_DISABLED)
		return 0 ;


	sprintf(varName, "authType%d", wlan_id);
	strAuth = req_get_cstream_var(wp, varName, "");
	if (strAuth[0]) { // new UI
		int authType;
		if (!strcmp(strAuth, ("open")))
			authType = AUTH_OPEN;
		else if ( !strcmp(strAuth, ("shared")))
			authType = AUTH_SHARED;
		else 
			authType = AUTH_BOTH;
		apmib_set(MIB_WLAN_AUTH_TYPE, (void *)&authType);
	}
				
	sprintf(varName, "format%d", wlan_id);
	strFormat = req_get_cstream_var(wp, varName, "");
	if (!strFormat[0]) {
 		strcpy(tmpBuf, ("Key type must exist!"));
		goto setErr_wep;
	}

	if (strFormat[0]!='1' && strFormat[0]!='2') {
		strcpy(tmpBuf, ("Invalid key type value!"));
		goto setErr_wep;
	}

	i = strFormat[0] - '0' - 1;
	if ( apmib_set( MIB_WLAN_WEP_KEY_TYPE, (void *)&i) == 0) {
  		strcpy(tmpBuf, ("Set WEP key type error!"));
		goto setErr_wep;
	}

	if (wep == WEP64) {
		if (strFormat[0]=='1')
			keyLen = WEP64_KEY_LEN;
		else
			keyLen = WEP64_KEY_LEN*2;
	}
	else {
		if (strFormat[0]=='1')
			keyLen = WEP128_KEY_LEN;
		else
			keyLen = WEP128_KEY_LEN*2;
	}
	
		sprintf(varName, "key%d", wlan_id);
	wepKey = req_get_cstream_var(wp, varName, "");
	if  (wepKey[0]) {
		if (strlen(wepKey) != keyLen) {
			sprintf(tmpBuf, ("Invalid key length! Expect length is %d"), keyLen);
			goto setErr_wep;
		}
		if ( !isAllStar(wepKey) ) {
			if (strFormat[0] == '1') // ascii
				strcpy(key, wepKey);
			else { // hex
				if ( !string_to_hex(wepKey, key, keyLen)) {
	   				strcpy(tmpBuf, ("Invalid wep-key value!"));
					goto setErr_wep;
				}
			}
			if (wep == WEP64){
				ret=apmib_set(MIB_WLAN_WEP64_KEY1, (void *)key);
				ret=apmib_set(MIB_WLAN_WEP64_KEY2, (void *)key);
				ret=apmib_set(MIB_WLAN_WEP64_KEY3, (void *)key);
				ret=apmib_set(MIB_WLAN_WEP64_KEY4, (void *)key);
			}else{
				ret=apmib_set(MIB_WLAN_WEP128_KEY1, (void *)key);
				ret=apmib_set(MIB_WLAN_WEP128_KEY2, (void *)key);
				ret=apmib_set(MIB_WLAN_WEP128_KEY3, (void *)key);
				ret=apmib_set(MIB_WLAN_WEP128_KEY4, (void *)key);
			}
			if (!ret) {
	 			strcpy(tmpBuf, ("Set wep-key error!"));
				goto setErr_wep;
			}
		}
	}

	
	
#if 0
	sprintf(varName, "defaultTxKeyId%d", wlan_id);
	strKeyId = req_get_cstream_var(wp, varName, "");
	if ( strKeyId[0] ) {
		if ( strKeyId[0]!='1' && strKeyId[0]!='2' && strKeyId[0]!='3' && strKeyId[0]!='4' ) {
	 		strcpy(tmpBuf, ("Invalid default tx key id!"));
   			goto setErr_wep;
		}
		i = strKeyId[0] - '0' - 1;
		if ( !apmib_set( MIB_WLAN_WEP_DEFAULT_KEY, (void *)&i ) ) {
	 		strcpy(tmpBuf, ("Set default tx key id error!"));
   			goto setErr_wep;
		}
	}

	sprintf(varName, "key1%d", wlan_id);
	wepKey = req_get_cstream_var(wp, varName, "");
	if  (wepKey[0]) {
		if (strlen(wepKey) != keyLen) {
			strcpy(tmpBuf, ("Invalid key 1 length!"));
			goto setErr_wep;
		}
		if ( !isAllStar(wepKey) ) {
			if (strFormat[0] == '1') // ascii
				strcpy(key, wepKey);
			else { // hex
				if ( !string_to_hex(wepKey, key, keyLen)) {
	   				strcpy(tmpBuf, ("Invalid wep-key1 value!"));
					goto setErr_wep;
				}
			}
			if (wep == WEP64)
				ret=apmib_set(MIB_WLAN_WEP64_KEY1, (void *)key);
			else
				ret=apmib_set(MIB_WLAN_WEP128_KEY1, (void *)key);
			if (!ret) {
	 			strcpy(tmpBuf, ("Set wep-key1 error!"));
				goto setErr_wep;
			}
		}
	}
	sprintf(varName, "key2%d", wlan_id);
	wepKey = req_get_cstream_var(wp, varName, "");
	if  (wepKey[0]) {
		if (strlen(wepKey) != keyLen) {
			strcpy(tmpBuf, ("Invalid key 2 length!"));
			goto setErr_wep;
		}
		if ( !isAllStar(wepKey) ) {
			if (strFormat[0] == '1') // ascii
				strcpy(key, wepKey);
			else { // hex
				if ( !string_to_hex(wepKey, key, keyLen)) {
	   				strcpy(tmpBuf, ("Invalid wep-key2 value!"));
   					goto setErr_wep;
				}
			}
			if (wep == WEP64)
				ret=apmib_set(MIB_WLAN_WEP64_KEY2, (void *)key);
			else
				ret=apmib_set(MIB_WLAN_WEP128_KEY2, (void *)key);
			if (!ret) {
	 			strcpy(tmpBuf, ("Set wep-key2 error!"));
				goto setErr_wep;
			}
		}
	}

	sprintf(varName, "key3%d", wlan_id);
	wepKey = req_get_cstream_var(wp, varName, "");
	if  (wepKey[0]) {
		if (strlen(wepKey) != keyLen) {
			strcpy(tmpBuf, ("Invalid key 3 length!"));
			goto setErr_wep;
		}
		if ( !isAllStar(wepKey) ) {
			if (strFormat[0] == '1') // ascii
				strcpy(key, wepKey);
			else { // hex
				if ( !string_to_hex(wepKey, key, keyLen)) {
	   				strcpy(tmpBuf, ("Invalid wep-key3 value!"));
   					goto setErr_wep;
				}
			}
			if (wep == WEP64)
				ret=apmib_set(MIB_WLAN_WEP64_KEY3, (void *)key);
			else
				ret=apmib_set(MIB_WLAN_WEP128_KEY3, (void *)key);
			if (!ret) {
	 			strcpy(tmpBuf, ("Set wep-key3 error!"));
				goto setErr_wep;
			}
		}
	}

	sprintf(varName, "key4%d", wlan_id);
	wepKey = req_get_cstream_var(wp, varName, "");
	if  (wepKey[0]) {
		if (strlen(wepKey) != keyLen) {
			strcpy(tmpBuf, ("Invalid key 1 length!"));
			goto setErr_wep;
		}
		if ( !isAllStar(wepKey) ) {
			if (strFormat[0] == '1') // ascii
				strcpy(key, wepKey);
			else { // hex
				if ( !string_to_hex(wepKey, key, keyLen)) {
	   				strcpy(tmpBuf, ("Invalid wep-key4 value!"));
   					goto setErr_wep;
				}
			}
			if (wep == WEP64)
				ret=apmib_set(MIB_WLAN_WEP64_KEY4, (void *)key);
			else
				ret=apmib_set(MIB_WLAN_WEP128_KEY4, (void *)key);
			if (!ret) {
	 			strcpy(tmpBuf, ("Set wep-key4 error!"));
				goto setErr_wep;
			}
		}
	}	
#endif
#ifdef WIFI_SIMPLE_CONFIG
	#ifdef MBSSID
	if (vwlan_idx == 0)
#endif
	{
		sprintf(varName, "wps_clear_configure_by_reg%d", wlan_id);
		/* WNC-NMR0348-JOE-PENG-20130329-Fix Page Fault occurs during setting on GUI */
		wepKey = req_get_cstream_var(wp, varName, "");
		ret = 0;
		if (wepKey[0])
			ret = atoi(wepKey);
		update_wps_configured(ret);
	}
#endif

#if defined(UNIVERSAL_REPEATER) && defined(CONFIG_REPEATER_WPS_SUPPORT)
	if (vwlan_idx == NUM_VWLAN_INTERFACE)
	{
		sprintf(varName, "wps_clear_configure_by_reg%d", wlan_id);
		/* WNC-NMR0348-JOE-PENG-20130329-Fix Page Fault occurs during setting on GUI */
		wepKey = req_get_cstream_var(wp, varName, "");
		ret = 0;
		if (wepKey[0])
			ret = atoi(wepKey);
		update_wps_configured(ret);
	}
#endif

	return 0 ;
setErr_wep:
	return -1 ;	
}	
/////////////////////////////////////////////////////////////////////////////
void formWep(request *wp, char *path, char *query)
{
	char *submitUrl;
	char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};


	if(wepHandler(wp, tmpBuf, wlan_idx) < 0 )
		goto setErr_end ;

	apmib_update_web(CURRENT_SETTING);

#ifndef NO_ACTION
	run_init_script("bridge");
#endif

	submitUrl = req_get_cstream_var(wp, ("submit-url"), "");   // hidden page
	OK_MSG(submitUrl);

	return;

setErr_end:
	ERR_MSG(tmpBuf);
}


int wpaHandler(request *wp, char *tmpBuf, int wlan_id)
{
   	char *strEncrypt, *strVal;
	ENCRYPT_T encrypt;
	int enableRS=0, intVal=0, getPSK=0, len, val=0; //WNC-NMR0000-Rita-20130306-Error_498,Error_603,Error_614-fix warnings of cppcheck (uninitialized value).
	unsigned long reKeyTime;
	SUPP_NONWAP_T suppNonWPA;
	struct in_addr inIp;
	char varName[32];
#ifdef CONFIG_RTL_WAPI_SUPPORT
	int enableAS=0;
#endif

#ifdef CONFIG_RTL_802_1X_CLIENT_SUPPORT
	int wlan_mode;
	int intVal2;
	int wlanIdx_5G, wlanIdx_2G, rsBandSel;
#endif

	sprintf(varName, "method%d", wlan_id);
   	strEncrypt = req_get_cstream_var(wp, varName, "");
	if (!strEncrypt[0]) {
 		strcpy(tmpBuf, ("Error! no encryption method."));
		goto setErr_encrypt;
	}
	encrypt = (ENCRYPT_T) strEncrypt[0] - '0';
	if (encrypt!=ENCRYPT_DISABLED && encrypt!=ENCRYPT_WEP && encrypt!=ENCRYPT_WPA
		&& encrypt != ENCRYPT_WPA2 && encrypt != ENCRYPT_WPA2_MIXED
#ifdef CONFIG_RTL_WAPI_SUPPORT		
		&& encrypt != ENCRYPT_WAPI
#endif
) {
		strcpy(tmpBuf, ("Invalid encryption method!"));
		goto setErr_encrypt;
	}

#ifdef WIFI_SIMPLE_CONFIG
#ifdef MBSSID
	if (vwlan_idx == 0)
#endif
	{
		memset(&wps_config_info, 0, sizeof(struct wps_config_info_struct));
		wps_config_info.caller_id = CALLED_FROM_WPAHANDLER;
		apmib_get(MIB_WLAN_ENCRYPT, (void *)&wps_config_info.auth);
		apmib_get(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&wps_config_info.wpa_enc);
		apmib_get(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&wps_config_info.wpa2_enc);
		apmib_get(MIB_WLAN_WPA_PSK, (void *)wps_config_info.wpaPSK);
	}
#endif

	if (apmib_set( MIB_WLAN_ENCRYPT, (void *)&encrypt) == 0) {
  		strcpy(tmpBuf, ("Set MIB_WLAN_ENCRYPT mib error!"));
		goto setErr_encrypt;
	}

	if (encrypt == ENCRYPT_DISABLED || encrypt == ENCRYPT_WEP) {
		sprintf(varName, "use1x%d", wlan_id);
		strVal = req_get_cstream_var(wp, varName, "");
		if ( !strcmp(strVal, "ON")) {
			apmib_get( MIB_WLAN_MODE, (void *)&intVal);
			if (intVal !=AP_MODE && intVal != AP_WDS_MODE) { // not AP mode
#ifdef CONFIG_RTL_802_1X_CLIENT_SUPPORT
				if(intVal == CLIENT_MODE){//client mode
//					printf("%s(%d): WPA-RADIUS can be used when device is set to client mode\n",__FUNCTION__,__LINE__);//Added for test 
					intVal = 1;
					enableRS = 1;
				}
				else{
					strcpy(tmpBuf, ("Error! 802.1x authentication cannot be used when device is set to wds or mesh mode."));
					goto setErr_encrypt;
					intVal = 0;
				}
#else
				strcpy(tmpBuf, ("Error! 802.1x authentication cannot be used when device is set to client mode."));
				goto setErr_encrypt;
				//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20130814, fix coverity error 830
				//intVal = 0;
#endif
			}
			else {
				intVal = 1;
				enableRS = 1;
			}
		}
		else
			intVal = 0;
#ifdef WLAN_HS2_CONFIG
		if(!enableRS) {
			if ( apmib_set( MIB_WLAN_HS2_ENABLE, (void *)&intVal) == 0) {
	  			strcpy(tmpBuf, ("Set hs2 enable flag error!"));
				goto setErr_encrypt;
			}
		}
#endif		
		if ( apmib_set( MIB_WLAN_ENABLE_1X, (void *)&intVal) == 0) {
  			strcpy(tmpBuf, ("Set 1x enable flag error!"));
			goto setErr_encrypt;
		}

		if (encrypt == ENCRYPT_WEP) {
	 		WEP_T wep;
			if ( !apmib_get( MIB_WLAN_WEP,  (void *)&wep) ) {
				strcpy(tmpBuf, ("Get MIB_WLAN_WEP MIB error!"));
				goto setErr_encrypt;
			}
			if (wep == WEP_DISABLED) {
				wep = WEP64;
				if ( apmib_set( MIB_WLAN_WEP, (void *)&wep) == 0) {
		  			strcpy(tmpBuf, ("Set WEP MIB error!"));
					goto setErr_encrypt;
				}
			}
		}
		else {
			sprintf(varName, "useMacAuth%d", wlan_id);
			strVal = req_get_cstream_var(wp, varName, "");
			if ( !strcmp(strVal, "ON")) {
				intVal = 1;
				enableRS = 1;
			}
			else
				intVal = 0;
			if ( apmib_set( MIB_WLAN_MAC_AUTH_ENABLED, (void *)&intVal) == 0) {
  				strcpy(tmpBuf, ("Set MIB_WLAN_MAC_AUTH_ENABLED MIB error!"));
				goto setErr_encrypt;
			}
		}
#ifdef CONFIG_IEEE80211W
		intVal = NO_MGMT_FRAME_PROTECTION;
		if ( apmib_set(MIB_WLAN_IEEE80211W, (void *)&intVal) == 0) {
			strcpy(tmpBuf, ("Set MIB_WLAN_IEEE80211W failed!"));
			goto setErr_encrypt;							
		}
		intVal = 0;
		if ( apmib_set(MIB_WLAN_SHA256_ENABLE, (void *)&intVal) == 0) {
				strcpy(tmpBuf, ("Set MIB_WLAN_SHA256_ENABLE failed!"));
				goto setErr_encrypt;							
		}
#endif
		
	}
#ifdef CONFIG_RTL_WAPI_SUPPORT	
	else if(ENCRYPT_WAPI==encrypt)
	{
		/*WAPI handle*/
		sprintf(varName, "wapiAuth%d", wlan_id);
		strVal = req_get_cstream_var(wp, varName, "");
		if (strVal[0]) 
		{
			if ( !strcmp(strVal, ("eap")))
			{
				apmib_get( MIB_WLAN_MODE, (void *)&intVal);
				if (intVal!=AP_MODE && intVal!=AP_WDS_MODE) { // not AP mode
					strcpy(tmpBuf, ("Error! WAPI AS cannot be used when device is set to client mode."));
					goto setErr_encrypt;
				}
				intVal = WAPI_AUTH_AUTO;
				enableAS = 1;
			}
			else if ( !strcmp(strVal, ("psk"))) 
			{
				intVal = WAPI_AUTH_PSK;
				getPSK = 1;
			}
			else 
			{
				strcpy(tmpBuf, ("Error! Invalid wapi authentication value."));
				goto setErr_encrypt;
			}

			if ( apmib_set(MIB_WLAN_WAPI_AUTH, (void *)&intVal) == 0) 
			{
				strcpy(tmpBuf, ("Set MIB_WLAN_WAPI_AUTH failed!"));
				goto setErr_encrypt;
			}
		}
		// pre-shared key
		if ( getPSK ) {
			int oldFormat, oldPskLen, i;

			sprintf(varName, "wapiPskFormat%d", wlan_id);
   			strVal = req_get_cstream_var(wp, varName, "");
			if (!strVal[0]) {
	 			strcpy(tmpBuf, ("Error! no psk format."));
				goto setErr_encrypt;
			}
			intVal = strVal[0] - '0';
			if (intVal != 0 && intVal != 1) {
	 			strcpy(tmpBuf, ("Error! invalid psk format."));
				goto setErr_encrypt;
			}

			// remember current psk format and length to compare to default case "****"
			apmib_get(MIB_WLAN_WAPI_PSK_FORMAT, (void *)&oldFormat);
			apmib_get(MIB_WLAN_WPA_PSK, (void *)tmpBuf);
			oldPskLen = strlen(tmpBuf);

			sprintf(varName, "wapiPskValue%d", wlan_id);
			strVal = req_get_cstream_var(wp, varName, "");
			len = strlen(strVal);

			if (oldFormat == intVal && len == oldPskLen ) {
				if(!strcmp(strVal,tmpBuf))
					goto wapi_end;
			}

			if ( apmib_set(MIB_WLAN_WAPI_PSK_FORMAT, (void *)&intVal) == 0) {
				strcpy(tmpBuf, ("Set MIB_WLAN_PSK_FORMAT failed!"));
				goto setErr_encrypt;
			}

			if (intVal==1) { // hex
				if (/*len!=MAX_PSK_LEN ||*/!string_to_hex(strVal, tmpBuf, MAX_PSK_LEN)) {
	 				strcpy(tmpBuf, ("Error! invalid psk value."));
					goto setErr_encrypt;
				}
				if(0 ==(len % 2))
				{
					len = len/2;
				}
				else
				{
					/*wapi hex key len should be even*/
					strcpy(tmpBuf, ("Error! invalid psk len."));
					goto setErr_encrypt;
				}					
				if(!apmib_set(MIB_WLAN_WAPI_PSKLEN,(void*)&len))
				{
					strcpy(tmpBuf,("Error! Set wapi key len fault"));
				}
			}
			else { // passphras
				if (len==0 || len > (MAX_PSK_LEN-1)|| len < MIN_PSK_LEN ) {
	 				strcpy(tmpBuf, ("Error! invalid psk value."));
					goto setErr_encrypt;
				}
				if(!apmib_set(MIB_WLAN_WAPI_PSKLEN,(void*)&len))
				{
					strcpy(tmpBuf,("Error! Set wapi key len fault"));
				}
			}
			if ( !apmib_set(MIB_WLAN_WAPI_PSK, (void *)strVal)) {
				strcpy(tmpBuf, ("Set MIB_WLAN_WPA_PSK error!"));
				goto setErr_encrypt;
			}
		}
	wapi_end:
		/*save AS IP*/
		if(1==enableAS)
		{ 
			int old_vwlan_idx,i;
			sprintf(varName, "wapiASIP%d", wlan_id);
			strVal = req_get_cstream_var(wp, varName, "");
			if (!strVal[0]) {
				strcpy(tmpBuf, ("No WAPI AS address!"));
				goto setErr_encrypt;
			}
			if ( !inet_aton(strVal, &inIp) ) {
				strcpy(tmpBuf, ("Invalid AS IP-address value!"));
				goto setErr_encrypt;
			}

			sprintf(varName, "wapiCertSel%d", wlan_id);
			strVal = req_get_cstream_var(wp, varName, "");
			if (!strVal[0]) {
				strcpy(tmpBuf, ("No WAPI cert selected!"));
				goto setErr_encrypt;
			}
			intVal=atoi(strVal);

			// To record old vwlan_idx
			old_vwlan_idx=vwlan_idx;
			// Set current MIB_WLAN_WAPI_ASIPADDR and MIB_WLAN_WAPI_CERT_SEL to all wlan interfaces
			// root wlan interface and virtual wlan interface
			for(i=0;i<NUM_VWLAN_INTERFACE+1;i++)
			{
				vwlan_idx=i;
				if ( !apmib_set(MIB_WLAN_WAPI_ASIPADDR, (void *)&inIp)) {
					strcpy(tmpBuf, ("Set RS IP-address error!"));
					goto setErr_encrypt;
				}	
				if ( !apmib_set(MIB_WLAN_WAPI_CERT_SEL, (void *)&intVal)) {
					strcpy(tmpBuf, ("Set WAPI cert sel error!"));
					goto setErr_encrypt;
				}	
			}
			// Back to old vwlan_idx
			vwlan_idx=old_vwlan_idx;
		}
	}
#endif
	else {
		// support nonWPA client

		sprintf(varName, "nonWpaSupp%d", wlan_id);
 		strVal = req_get_cstream_var(wp, varName, "");
		apmib_get( MIB_WLAN_ENABLE_SUPP_NONWPA, (void *)&intVal);
		if(strVal[0])
		{
		if ( !strcmp(strVal, "ON"))
			intVal = 1;
		else
			intVal = 0;
		}
		if ( apmib_set( MIB_WLAN_ENABLE_SUPP_NONWPA, (void *)&intVal) == 0) {
  			strcpy(tmpBuf, ("Set MIB_WLAN_ENABLE_SUPP_NONWPA mib error!"));
			goto setErr_encrypt;
		}
		if ( intVal ) {
			suppNonWPA = SUPP_NONWPA_NONE;
			sprintf(varName, "nonWpaWep%d", wlan_id);
			strVal = req_get_cstream_var(wp, varName, "");
			if ( !strcmp(strVal, "ON"))
				suppNonWPA |= SUPP_NONWPA_WEP;

			sprintf(varName, "nonWpa1x%d", wlan_id);
			strVal = req_get_cstream_var(wp, varName, "");
			if ( !strcmp(strVal, "ON")) {
				suppNonWPA |= SUPP_NONWPA_1X;
				enableRS = 1;
			}

			if ( apmib_set( MIB_WLAN_SUPP_NONWPA, (void *)&suppNonWPA) == 0) {
  				strcpy(tmpBuf, ("Set MIB_WLAN_SUPP_NONWPA mib error!"));
				goto setErr_encrypt;
			}
		}

		// WPA authentication
		sprintf(varName, "wpaAuth%d", wlan_id);
		strVal = req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			if ( !strcmp(strVal, ("eap"))) {
				apmib_get( MIB_WLAN_MODE, (void *)&intVal);
#ifndef TLS_CLIENT
				if (intVal!=AP_MODE && intVal!=AP_WDS_MODE) { // not AP mode
#ifdef CONFIG_RTL_802_1X_CLIENT_SUPPORT
					if(intVal == CLIENT_MODE){//client mode
//						printf("%s(%d): WPA-RADIUS can be used when device is set to client mode\n",__FUNCTION__,__LINE__);//Added for test 
					}
					else{
						strcpy(tmpBuf, ("Error! WPA-RADIUS cannot be used when device is set to wds or mesh mode."));
						goto setErr_encrypt;
					}
						
#else
					strcpy(tmpBuf, ("Error! WPA-RADIUS cannot be used when device is set to client mode."));
					goto setErr_encrypt;
#endif
				}
#endif
				intVal = WPA_AUTH_AUTO;
				enableRS = 1;
			}
			else if ( !strcmp(strVal, ("psk"))) {
				intVal = WPA_AUTH_PSK;
				getPSK = 1;

			}
			else {
				strcpy(tmpBuf, ("Error! Invalid wpa authentication value."));
				goto setErr_encrypt;
			}
			if ( apmib_set(MIB_WLAN_WPA_AUTH, (void *)&intVal) == 0) {
				strcpy(tmpBuf, ("Set MIB_WLAN_WPA_AUTH failed!"));
				goto setErr_encrypt;
			}
		}

		// cipher suite		
		// sc_yang write the ciphersuite according to  encrypt for wpa
		// wpa mixed mode is not implemented yet.
		
// get cipher suite from user setting, for wpa-aes -------------------		
#if 0				
		intVal = 0 ;
		if( (encrypt ==  ENCRYPT_WPA) || (encrypt == ENCRYPT_WPA2_MIXED) )
			intVal =   WPA_CIPHER_TKIP ;
		if ( apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&intVal) == 0) {
				strcpy(tmpBuf, ("Set MIB_WLAN_WPA_CIPHER_SUITE failed!"));
				goto setErr_encrypt;
		}
		//set wpa2UniCipher  for wpa2
		// wpa2 mixed mode is not implemented yet.
		intVal = 0 ;
		if( (encrypt ==  ENCRYPT_WPA2) || (encrypt == ENCRYPT_WPA2_MIXED) )
			intVal =   WPA_CIPHER_AES ;
		if ( apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&intVal) == 0) {
				strcpy(tmpBuf, ("Set MIB_WLAN_WPA2_UNICIPHER failed!"));
				goto setErr_encrypt;
		}
#endif	
		//if ((encrypt == ENCRYPT_WPA) || (encrypt == ENCRYPT_WPA2_MIXED)) 
		{
			sprintf(varName, "ciphersuite%d", wlan_id);
			strVal = req_get_cstream_var(wp, varName, "");	 	
			if (strVal[0]) {
				intVal = 0;				
				if ( strstr(strVal, ("tkip"))) 
					intVal |= WPA_CIPHER_TKIP;
				if ( strstr(strVal, ("aes"))) 
					intVal |= WPA_CIPHER_AES;
				if (intVal == 0) {
					strcpy(tmpBuf, ("Invalid value of cipher suite!"));
					goto setErr_encrypt;
				}
			}
			else{
					intVal = WPA_CIPHER_MIXED;	
			}

			// check if both TKIP and AES cipher are selected in client mode
			/*apmib_get(MIB_WLAN_MODE, (void *)&val);
			if (val == CLIENT_MODE) {
				apmib_get(MIB_WLAN_NETWORK_TYPE, &val);
				if (val == INFRASTRUCTURE && intVal == WPA_CIPHER_MIXED) {
					strcpy(tmpBuf, ("Error! Can't set cipher to TKIP + AES when device is set to client mode."));
					goto setErr_encrypt;							
				}
			}*/	// david+2006-1-11
			
			if ( apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&intVal) == 0) {
				strcpy(tmpBuf, ("Set MIB_WLAN_WPA_CIPHER_SUITE failed!"));
				goto setErr_encrypt;							
			}				
		}	
#ifdef CONFIG_IEEE80211W
		{
			apmib_get(MIB_WLAN_MODE, (void *)&val);
			sprintf(varName, "wpa11w%d", wlan_id);
			strVal = req_get_cstream_var(wp, varName, "");	 	
			printf("wpa11w, strVar=%s\n",strVal);
			if (strVal[0]) {			
				if ( strstr(strVal, ("none"))) 
					intVal = NO_MGMT_FRAME_PROTECTION;
				else if ( strstr(strVal, ("capable")) && (val != CLIENT_MODE)) 	// only v3.4 supports pmf client mode
					intVal = MGMT_FRAME_PROTECTION_OPTIONAL;
				else if ( strstr(strVal, ("required")) && (val != CLIENT_MODE)) 
					intVal = MGMT_FRAME_PROTECTION_REQUIRED;
				/* NMR0000-[Aero]-20161011-patch: fmwlan-3411b.c-start */
				else if ( val == CLIENT_MODE) 
					intVal = NO_MGMT_FRAME_PROTECTION;
				/* NMR0000-[Aero]-20161011-patch: fmwlan-3411b.c-end */
				else {
					intVal = NO_MGMT_FRAME_PROTECTION;
					strcpy(tmpBuf, ("Invalid value of IEEE80211w!"));
					goto setErr_encrypt;
				}
			}
			else
				intVal = NO_MGMT_FRAME_PROTECTION;			
					
			if ( apmib_set(MIB_WLAN_IEEE80211W, (void *)&intVal) == 0) {
				strcpy(tmpBuf, ("Set MIB_WLAN_IEEE80211W failed!"));
				goto setErr_encrypt;							
			}
		}
		{
			//int intVal1;
			//apmib_get(MIB_WLAN_IEEE80211W,(void *)&intVal1);
			sprintf(varName, "wpa2EnableSHA256%d", wlan_id);
			strVal = req_get_cstream_var(wp, varName, "");	 	
			printf("wpa2EnableSHA256, strVar=%s\n",strVal);

			//if(intVal1 == MGMT_FRAME_PROTECTION_REQUIRED)
			//	intVal = 1;
			//else{
				if (strVal[0]) {			
					if ( strstr(strVal, ("disable"))) 
						intVal = 0;
					else if ( strstr(strVal, ("enable")) && (val != CLIENT_MODE))	
						intVal = 1;
					/* NMR0000-[Aero]-20161011-patch: fmwlan-3411b.c-start */
					else if ( val == CLIENT_MODE)	
						intVal = 0;
					/* NMR0000-[Aero]-20161011-patch: fmwlan-3411b.c-end */
					else {
						intVal = 0;
						strcpy(tmpBuf, ("Invalid value of wpa2EnableSHA256!"));
						goto setErr_encrypt;
					}
				}
				else
					intVal = 0;
			//}

			if ( apmib_set(MIB_WLAN_SHA256_ENABLE, (void *)&intVal) == 0) {
				strcpy(tmpBuf, ("Set MIB_WLAN_SHA256_ENABLE failed!"));
				goto setErr_encrypt;							
			}
		}
#endif	
		//if ((encrypt == ENCRYPT_WPA2) || (encrypt == ENCRYPT_WPA2_MIXED)) 
		{
			sprintf(varName, "wpa2ciphersuite%d", wlan_id);
			strVal = req_get_cstream_var(wp, varName, "");	 	
			if (strVal[0]) {
				intVal = 0;				
				if ( strstr(strVal, ("tkip"))) 
					intVal |= WPA_CIPHER_TKIP;
				if ( strstr(strVal, ("aes"))) 
					intVal |= WPA_CIPHER_AES;
				if (intVal == 0) {
					strcpy(tmpBuf, ("Invalid value of wpa2 cipher suite!"));
					goto setErr_encrypt;
				}
			}
			else
				intVal = WPA_CIPHER_MIXED;			

			// check if both TKIP and AES cipher are selected in client mode
			/*apmib_get(MIB_WLAN_MODE, (void *)&val);
			if (val == CLIENT_MODE) {
				apmib_get(MIB_WLAN_NETWORK_TYPE, &val);
				if (val == INFRASTRUCTURE && intVal == WPA_CIPHER_MIXED) {
					strcpy(tmpBuf, ("Error! Can't set cipher to TKIP + AES when device is set to client mode."));
					goto setErr_encrypt;							
				}
			}*/	// david+2006-1-11
			
			if ( apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&intVal) == 0) {
				strcpy(tmpBuf, ("Set MIB_WLAN_WPA2_CIPHER_SUITE failed!"));
				goto setErr_encrypt;							
			}
		}
//-------------------------------------------------- david, 2005-8-03	
	
		if( ((encrypt ==  ENCRYPT_WPA2) || (encrypt == ENCRYPT_WPA2_MIXED)) &&
		    enableRS == 1){
			sprintf(varName, "preAuth%d", wlan_id);
			strVal = req_get_cstream_var(wp, varName, "");
			if ( !strcmp(strVal, "ON"))
				intVal = 1 ;
			else
				intVal = 0 ;
			if ( apmib_set(MIB_WLAN_WPA2_PRE_AUTH, (void *)&intVal) == 0) {
				strcpy(tmpBuf, ("Set MIB_WLAN_WPA_CIPHER_SUITE failed!"));
				goto setErr_encrypt;
			}					
		}

		// pre-shared key
		if ( getPSK ) {
			//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20130814, fix coverity error 824
			int oldFormat = 0, oldPskLen, i;

			sprintf(varName, "pskFormat%d", wlan_id);
   			strVal = req_get_cstream_var(wp, varName, "");
			if (!strVal[0]) {
	 			strcpy(tmpBuf, ("Error! no psk format."));
				goto setErr_encrypt;
			}
			intVal = strVal[0] - '0';
			if (intVal != 0 && intVal != 1) {
	 			strcpy(tmpBuf, ("Error! invalid psk format."));
				goto setErr_encrypt;
			}

			// remember current psk format and length to compare to default case "****"
			apmib_get(MIB_WLAN_PSK_FORMAT, (void *)&oldFormat);
			apmib_get(MIB_WLAN_WPA_PSK, (void *)tmpBuf);
			oldPskLen = strlen(tmpBuf);

			sprintf(varName, "pskValue%d", wlan_id);
			strVal = req_get_cstream_var(wp, varName, "");
			rollback_control_code(strVal);
			len = strlen(strVal);

			if (oldFormat == intVal && len == oldPskLen ) {
				if(!strcmp(tmpBuf,strVal))
					goto rekey_time;
			}

			if ( apmib_set(MIB_WLAN_PSK_FORMAT, (void *)&intVal) == 0) {
				strcpy(tmpBuf, ("Set MIB_WLAN_PSK_FORMAT failed!"));
				goto setErr_encrypt;
			}

			if (intVal==1) { // hex
				if (len!=MAX_PSK_LEN || !string_to_hex(strVal, tmpBuf, MAX_PSK_LEN)) {
	 				strcpy(tmpBuf, ("Error! invalid psk value."));
					goto setErr_encrypt;
				}
			}
			else { // passphras
				if (len==0 || len > (MAX_PSK_LEN-1)|| len < MIN_PSK_LEN ) {
	 				strcpy(tmpBuf, ("Error! invalid psk value."));
					goto setErr_encrypt;
				}
			}
			if ( !apmib_set(MIB_WLAN_WPA_PSK, (void *)strVal)) {
				strcpy(tmpBuf, ("Set MIB_WLAN_WPA_PSK error!"));
				goto setErr_encrypt;
			}
		}
rekey_time:
		// group key rekey time
		reKeyTime = 0;
		sprintf(varName, "groupKeyTimeDay%d", wlan_id);
		strVal = req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, ("Error! Invalid value of rekey day."));
				goto setErr_encrypt;
			}
			reKeyTime += intVal*86400;
		}
		sprintf(varName, "groupKeyTimeHr%d", wlan_id);
		strVal = req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, ("Error! Invalid value of rekey hr."));
				goto setErr_encrypt;
			}
			reKeyTime += intVal*3600;
		}
		sprintf(varName, "groupKeyTimeMin%d", wlan_id);
		strVal = req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, ("Error! Invalid value of rekey min."));
				goto setErr_encrypt;
			}
			reKeyTime += intVal*60;
		}

		sprintf(varName, "groupKeyTimeSec%d", wlan_id);
		strVal = req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, ("Error! Invalid value of rekey sec."));
				goto setErr_encrypt;
			}
			reKeyTime += intVal;
		}
		if (reKeyTime) {
			if ( !apmib_set(MIB_WLAN_WPA_GROUP_REKEY_TIME, (void *)&reKeyTime)) {
				strcpy(tmpBuf, ("Set MIB_WLAN_WPA_GROUP_REKEY_TIME error!"));
				goto setErr_encrypt;
			}
		}
	}

	apmib_set( MIB_WLAN_ENABLE_1X, (void *)&enableRS);			
	if (enableRS == 1) { // if 1x enabled, get RADIUS server info
#ifdef CONFIG_RTL_802_1X_CLIENT_SUPPORT
		apmib_get( MIB_WLAN_MODE, (void *)&wlan_mode);
		if (wlan_mode == CLIENT_MODE) { // wlan client mode
			wlanIdx_5G=whichWlanIfIs(PHYBAND_5G);
			wlanIdx_2G=whichWlanIfIs(PHYBAND_2G);
			if(wlan_idx==wlanIdx_5G){
				rsBandSel=PHYBAND_5G;
				if ( !apmib_set(MIB_WLAN_RS_BAND_SEL, (void *)&rsBandSel)) {
					strcpy(tmpBuf, ("Set MIB_WLAN_RS_BAND_SEL error!"));
					goto setErr_encrypt;
				}
			}
			else if(wlan_idx==wlanIdx_2G){
				rsBandSel=PHYBAND_2G;
				if ( !apmib_set(MIB_WLAN_RS_BAND_SEL, (void *)&rsBandSel)) {
					strcpy(tmpBuf, ("Set MIB_WLAN_RS_BAND_SEL error!"));
					goto setErr_encrypt;
				}
			}
			else{
				rsBandSel=PHYBAND_OFF;
				if ( !apmib_set(MIB_WLAN_RS_BAND_SEL, (void *)&rsBandSel)) {
					strcpy(tmpBuf, ("Set MIB_WLAN_RS_BAND_SEL error!"));
					goto setErr_encrypt;
				}
			}
			
			sprintf(varName, "eapType%d", wlan_id);
			strVal = req_get_cstream_var(wp, varName, "");
			if (strVal[0]) {
				if ( !string_to_dec(strVal, &intVal) ) {
					strcpy(tmpBuf, ("Invalid 802.1x EAP type value!"));
					goto setErr_encrypt;
				}
				if ( !apmib_set(MIB_WLAN_EAP_TYPE, (void *)&intVal)) {
					strcpy(tmpBuf, ("Set MIB_WLAN_EAP_TYPE error!"));
					goto setErr_encrypt;
				}
			}
			else{
				strcpy(tmpBuf, ("No 802.1x EAP type!"));
				goto setErr_encrypt;
			}

			if(intVal == EAP_MD5){
				sprintf(varName, "eapUserId%d", wlan_id);
				strVal = req_get_cstream_var(wp, varName, "");
				if (strVal[0]) {
					if(strlen(strVal)>MAX_EAP_USER_ID_LEN){
						strcpy(tmpBuf, ("EAP user ID too long!"));
						goto setErr_encrypt;
					}
					if ( !apmib_set(MIB_WLAN_EAP_USER_ID, (void *)strVal)) {
						strcpy(tmpBuf, ("Set MIB_WLAN_EAP_USER_ID error!"));
						goto setErr_encrypt;
					}
				}
				else{
					strcpy(tmpBuf, ("No 802.1x EAP User ID!"));
					goto setErr_encrypt;
				}
				
				sprintf(varName, "radiusUserName%d", wlan_id);
				strVal = req_get_cstream_var(wp, varName, "");
				if (strVal[0]) {
					if(strlen(strVal)>MAX_RS_USER_NAME_LEN){
						strcpy(tmpBuf, ("RADIUS user name too long!"));
						goto setErr_encrypt;
					}
					if ( !apmib_set(MIB_WLAN_RS_USER_NAME, (void *)strVal)) {
						strcpy(tmpBuf, ("Set MIB_WLAN_RS_USER_NAME error!"));
						goto setErr_encrypt;
					}
				}
				else{
					strcpy(tmpBuf, ("No 802.1x RADIUS User Name!"));
					goto setErr_encrypt;
				}

				sprintf(varName, "radiusUserPass%d", wlan_id);
				strVal = req_get_cstream_var(wp, varName, "");
				if (strVal[0]) {
					if(strlen(strVal)>MAX_RS_USER_PASS_LEN){
						strcpy(tmpBuf, ("RADIUS user password too long!"));
						goto setErr_encrypt;
					}
					if ( !apmib_set(MIB_WLAN_RS_USER_PASSWD, (void *)strVal)) {
						strcpy(tmpBuf, ("Set MIB_WLAN_RS_USER_PASSWD error!"));
						goto setErr_encrypt;
					}
				}
				else{
					strcpy(tmpBuf, ("No 802.1x RADIUS User Password!"));
					goto setErr_encrypt;
				}
			}
			else if(intVal == EAP_TLS){
				sprintf(varName, "eapUserId%d", wlan_id);
				strVal = req_get_cstream_var(wp, varName, "");
				if (strVal[0]) {
					if(strlen(strVal)>MAX_EAP_USER_ID_LEN){
						strcpy(tmpBuf, ("EAP user ID too long!"));
						goto setErr_encrypt;
					}
					if ( !apmib_set(MIB_WLAN_EAP_USER_ID, (void *)strVal)) {
						strcpy(tmpBuf, ("Set MIB_WLAN_EAP_USER_ID error!"));
						goto setErr_encrypt;
					}
				}
				else{
					strcpy(tmpBuf, ("No 802.1x EAP User ID!"));
					goto setErr_encrypt;
				}
				
				sprintf(varName, "radiusUserCertPass%d", wlan_id);
				strVal = req_get_cstream_var(wp, varName, "");
				if (strVal[0]) {
					if(strlen(strVal)>MAX_RS_USER_CERT_PASS_LEN){
						strcpy(tmpBuf, ("RADIUS user cert password too long!"));
						goto setErr_encrypt;
					}
					if ( !apmib_set(MIB_WLAN_RS_USER_CERT_PASSWD, (void *)strVal)) {
						strcpy(tmpBuf, ("Set MIB_WLAN_RS_USER_CERT_PASSWD error!"));
						goto setErr_encrypt;
					}
				}
				else{
					if ( !apmib_set(MIB_WLAN_RS_USER_CERT_PASSWD, (void *)strVal)) {
						strcpy(tmpBuf, ("Clear MIB_WLAN_RS_USER_CERT_PASSWD error!"));
						goto setErr_encrypt;
					}
					//strcpy(tmpBuf, ("No 802.1x RADIUS user cert password!"));
					//goto setErr_encrypt;
				}

				if(rsBandSel == PHYBAND_5G){
					if(isFileExist(RS_USER_CERT_5G) != 1){
						strcpy(tmpBuf, ("No 802.1x RADIUS 5g user cert!\nPlease upload it."));
						goto setErr_encrypt;
					}
					
					if(isFileExist(RS_ROOT_CERT_5G) != 1){
						strcpy(tmpBuf, ("No 802.1x RADIUS 5g root cert!\nPlease upload it."));
						goto setErr_encrypt;
					}
				}
				else if(rsBandSel == PHYBAND_2G){
					if(isFileExist(RS_USER_CERT_2G) != 1){
						strcpy(tmpBuf, ("No 802.1x RADIUS 2g user cert!\nPlease upload it."));
						goto setErr_encrypt;
					}
					
					if(isFileExist(RS_ROOT_CERT_2G) != 1){
						strcpy(tmpBuf, ("No 802.1x RADIUS 2g root cert!\nPlease upload it."));
						goto setErr_encrypt;
					}
				}
			}
			else if(intVal == EAP_PEAP){
				sprintf(varName, "eapInsideType%d", wlan_id);
				strVal = req_get_cstream_var(wp, varName, "");
				if (strVal[0]) {
					if ( !string_to_dec(strVal, &intVal2) ) {
						strcpy(tmpBuf, ("Invalid 802.1x inside tunnel type value!"));
						goto setErr_encrypt;
					}
					if ( !apmib_set(MIB_WLAN_EAP_INSIDE_TYPE, (void *)&intVal2)) {
						strcpy(tmpBuf, ("Set MIB_WLAN_EAP_INSIDE_TYPE error!"));
						goto setErr_encrypt;
					}
				}
				else{
					strcpy(tmpBuf, ("No 802.1x inside tunnel type!"));
					goto setErr_encrypt;
				}

				if(intVal2 == INSIDE_MSCHAPV2){
					sprintf(varName, "eapUserId%d", wlan_id);
					strVal = req_get_cstream_var(wp, varName, "");
					if (strVal[0]) {
						if(strlen(strVal)>MAX_EAP_USER_ID_LEN){
							strcpy(tmpBuf, ("EAP user ID too long!"));
							goto setErr_encrypt;
						}
						if ( !apmib_set(MIB_WLAN_EAP_USER_ID, (void *)strVal)) {
							strcpy(tmpBuf, ("Set MIB_WLAN_EAP_USER_ID error!"));
							goto setErr_encrypt;
						}
					}
					else{
						strcpy(tmpBuf, ("No 802.1x EAP User ID!"));
						goto setErr_encrypt;
					}
					
					sprintf(varName, "radiusUserName%d", wlan_id);
					strVal = req_get_cstream_var(wp, varName, "");
					if (strVal[0]) {
						if(strlen(strVal)>MAX_RS_USER_NAME_LEN){
							strcpy(tmpBuf, ("RADIUS user name too long!"));
							goto setErr_encrypt;
						}
						if ( !apmib_set(MIB_WLAN_RS_USER_NAME, (void *)strVal)) {
							strcpy(tmpBuf, ("Set MIB_WLAN_RS_USER_NAME error!"));
							goto setErr_encrypt;
						}
					}
					else{
						strcpy(tmpBuf, ("No 802.1x RADIUS User Name!"));
						goto setErr_encrypt;
					}

					sprintf(varName, "radiusUserPass%d", wlan_id);
					strVal = req_get_cstream_var(wp, varName, "");
					if (strVal[0]) {
						if(strlen(strVal)>MAX_RS_USER_PASS_LEN){
							strcpy(tmpBuf, ("RADIUS user password too long!"));
							goto setErr_encrypt;
						}
						if ( !apmib_set(MIB_WLAN_RS_USER_PASSWD, (void *)strVal)) {
							strcpy(tmpBuf, ("Set MIB_WLAN_RS_USER_PASSWD error!"));
							goto setErr_encrypt;
						}
					}
					else{
						strcpy(tmpBuf, ("No 802.1x RADIUS User Password!"));
						goto setErr_encrypt;
					}

//					if(isFileExist(RS_USER_CERT) == 1){
						sprintf(varName, "radiusUserCertPass%d", wlan_id);
						strVal = req_get_cstream_var(wp, varName, "");
						if (strVal[0]) {
							if(strlen(strVal)>MAX_RS_USER_CERT_PASS_LEN){
								strcpy(tmpBuf, ("RADIUS user cert password too long!"));
								goto setErr_encrypt;
							}
							if ( !apmib_set(MIB_WLAN_RS_USER_CERT_PASSWD, (void *)strVal)) {
								strcpy(tmpBuf, ("Set MIB_WLAN_RS_USER_CERT_PASSWD error!"));
								goto setErr_encrypt;
							}
						}
						else{
							if ( !apmib_set(MIB_WLAN_RS_USER_CERT_PASSWD, (void *)strVal)) {
								strcpy(tmpBuf, ("[1] Clear MIB_WLAN_RS_USER_CERT_PASSWD error!"));
								goto setErr_encrypt;
							}
							//strcpy(tmpBuf, ("No 802.1x RADIUS user cert password!"));
							//goto setErr_encrypt;
						}
//					}
				}
				else{
					strcpy(tmpBuf, ("802.1x inside tunnel type not support!"));
					goto setErr_encrypt;
				}
			}
			else{
				strcpy(tmpBuf, ("802.1x EAP type not support!"));
				goto setErr_encrypt;
			}
		}
		else
#endif
		{
		sprintf(varName, "radiusPort%d", wlan_id);
		strVal = req_get_cstream_var(wp, varName, "");
		if (!strVal[0]) {
			strcpy(tmpBuf, ("No RS port number!"));
			goto setErr_encrypt;
		}
		if (!string_to_dec(strVal, &intVal) || intVal<=0 || intVal>65535) {
			strcpy(tmpBuf, ("Error! Invalid value of RS port number."));
			goto setErr_encrypt;
		}
		if ( !apmib_set(MIB_WLAN_RS_PORT, (void *)&intVal)) {
			strcpy(tmpBuf, ("Set RS port error!"));
			goto setErr_encrypt;
		}
		sprintf(varName, "radiusIP%d", wlan_id);
		strVal = req_get_cstream_var(wp, varName, "");
		if (!strVal[0]) {
			strcpy(tmpBuf, ("No RS IP address!"));
			goto setErr_encrypt;
		}
		if ( !inet_aton(strVal, &inIp) ) {
			strcpy(tmpBuf, ("Invalid RS IP-address value!"));
			goto setErr_encrypt;
		}
		if ( !apmib_set(MIB_WLAN_RS_IP, (void *)&inIp)) {
			strcpy(tmpBuf, ("Set RS IP-address error!"));
			goto setErr_encrypt;
		}
		sprintf(varName, "radiusPass%d", wlan_id);
		strVal = req_get_cstream_var(wp, varName, "");
		if (strlen(strVal) > (MAX_RS_PASS_LEN -1) ) {
			strcpy(tmpBuf, ("RS password length too long!"));
			goto setErr_encrypt;
		}
		if ( !apmib_set(MIB_WLAN_RS_PASSWORD, (void *)strVal)) {
			strcpy(tmpBuf, ("Set RS password error!"));
			goto setErr_encrypt;
		}

		sprintf(varName, "radiusRetry%d", wlan_id);
		strVal = req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, ("Invalid RS retry value!"));
				goto setErr_encrypt;
			}
			if ( !apmib_set(MIB_WLAN_RS_MAXRETRY, (void *)&intVal)) {
				strcpy(tmpBuf, ("Set MIB_WLAN_RS_MAXRETRY error!"));
				goto setErr_encrypt;
			}
		}
		sprintf(varName, "radiusTime%d", wlan_id);
		strVal = req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, ("Invalid RS time value!"));
				goto setErr_encrypt;
			}
			if ( !apmib_set(MIB_WLAN_RS_INTERVAL_TIME, (void *)&intVal)) {
				strcpy(tmpBuf, ("Set MIB_WLAN_RS_INTERVAL_TIME error!"));
				goto setErr_encrypt;
			}
		}
		sprintf(varName, "useAccount%d", wlan_id);
		strVal = req_get_cstream_var(wp, varName, "");
		if ( !strcmp(strVal, "ON"))
			intVal = 1;
		else
			intVal = 0;
		if ( apmib_set( MIB_WLAN_ACCOUNT_RS_ENABLED, (void *)&intVal) == 0) {
  			strcpy(tmpBuf, ("Set MIB_WLAN_ACCOUNT_RS_ENABLED mib error!"));
			goto setErr_encrypt;
		}
		if (intVal == 0)
			goto get_wepkey;

		sprintf(varName, "accountPort%d", wlan_id);
		strVal = req_get_cstream_var(wp, varName, "");
		if (!strVal[0]) {
			strcpy(tmpBuf, ("No account RS port number!"));
			goto setErr_encrypt;
		}
		if (!string_to_dec(strVal, &intVal) || intVal<=0 || intVal>65535) {
			strcpy(tmpBuf, ("Error! Invalid value of account RS port number."));
			goto setErr_encrypt;
		}
		if ( !apmib_set(MIB_WLAN_ACCOUNT_RS_PORT, (void *)&intVal)) {
			strcpy(tmpBuf, ("Set account RS port error!"));
			goto setErr_encrypt;
		}
		sprintf(varName, "accountIP%d", wlan_id);
		strVal = req_get_cstream_var(wp, varName, "");
		if (!strVal[0]) {
			strcpy(tmpBuf, ("No account RS IP address!"));
			goto setErr_encrypt;
		}
		if ( !inet_aton(strVal, &inIp) ) {
			strcpy(tmpBuf, ("Invalid account RS IP-address value!"));
			goto setErr_encrypt;
		}
		if ( !apmib_set(MIB_WLAN_ACCOUNT_RS_IP, (void *)&inIp)) {
			strcpy(tmpBuf, ("Set account RS IP-address error!"));
			goto setErr_encrypt;
		}
		sprintf(varName, "accountPass%d", wlan_id);
		strVal = req_get_cstream_var(wp, varName, "");
		if (strlen(strVal) > (MAX_RS_PASS_LEN -1) ) {
			strcpy(tmpBuf, ("Account RS password length too long!"));
			goto setErr_encrypt;
		}
		if ( !apmib_set(MIB_WLAN_ACCOUNT_RS_PASSWORD, (void *)strVal)) {
			strcpy(tmpBuf, ("Set account RS password error!"));
			goto setErr_encrypt;
		}
		sprintf(varName, "accountRetry%d", wlan_id);
		strVal = req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, ("Invalid account RS retry value!"));
				goto setErr_encrypt;
			}
			if ( !apmib_set(MIB_WLAN_ACCOUNT_RS_MAXRETRY, (void *)&intVal)) {
				strcpy(tmpBuf, ("Set MIB_WLAN_ACCOUNT_RS_MAXRETRY error!"));
				goto setErr_encrypt;
			}
		}
		sprintf(varName, "accountTime%d", wlan_id);
		strVal = req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, ("Invalid account RS time value!"));
				goto setErr_encrypt;
			}
			if ( !apmib_set(MIB_WLAN_ACCOUNT_RS_INTERVAL_TIME, (void *)&intVal)) {
				strcpy(tmpBuf, ("Set MIB_WLAN_ACCOUNT_RS_INTERVAL_TIME error!"));
				goto setErr_encrypt;
			}
		}
		sprintf(varName, "accountUpdateEnabled%d", wlan_id);
		strVal = req_get_cstream_var(wp, varName, "");
		if ( !strcmp(strVal, "ON"))
			intVal = 1;
		else
			intVal = 0;
		if ( apmib_set( MIB_WLAN_ACCOUNT_RS_UPDATE_ENABLED, (void *)&intVal) == 0) {
			strcpy(tmpBuf, ("Set MIB_WLAN_ACCOUNT_RS_UPDATE_ENABLED mib error!"));
			goto setErr_encrypt;
		}
		sprintf(varName, "accountUpdateTime%d", wlan_id);
		strVal = req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			if ( !string_to_dec(strVal, &intVal) ) {
				strcpy(tmpBuf, ("Error! Invalid value of update time"));
				goto setErr_encrypt;
			}
			if ( !apmib_set(MIB_WLAN_ACCOUNT_RS_UPDATE_DELAY, (void *)&intVal)) {
				strcpy(tmpBuf, ("Set MIB_WLAN_ACCOUNT_RS_UPDATE_DELAY mib error!"));
				goto setErr_encrypt;
			}
		}

get_wepkey:
		// get 802.1x WEP key length
		sprintf(varName, "wepKeyLen%d", wlan_id);
		strVal = req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			if ( !strcmp(strVal, ("wep64")))
				intVal = WEP64;
			else if ( !strcmp(strVal, ("wep128")))
				intVal = WEP128;
			else {
				strcpy(tmpBuf, ("Error! Invalid wepkeylen value."));
				goto setErr_encrypt;
			}
			if ( apmib_set(MIB_WLAN_WEP, (void *)&intVal) == 0) {
				strcpy(tmpBuf, ("Set MIB_WLAN_WEP failed!"));
				goto setErr_encrypt;
			}
		}
	}
#ifdef FAST_BSS_TRANSITION
		intVal = 0; // disable 11r function in 802.1x
		if ( apmib_set(MIB_WLAN_FT_ENABLE, (void *)&intVal) == 0) {
			strcpy(tmpBuf, ("Set MIB_WLAN_IEEE80211W failed!"));
			goto setErr_encrypt;							
		}
		
		if ( apmib_set(MIB_WLAN_FT_OVER_DS, (void *)&intVal) == 0) {
			strcpy(tmpBuf, ("Set MIB_WLAN_SHA256_ENABLE failed!"));
			goto setErr_encrypt;							
		}
#endif
	}

#ifdef WIFI_SIMPLE_CONFIG
#ifdef MBSSID
	if (vwlan_idx == 0)
#endif
	{
		sprintf(varName, "wps_clear_configure_by_reg%d", wlan_id);
		/* WNC-NMR0348-JOE-PENG-20130329-Fix Page Fault occurs during setting on GUI */
		strVal = req_get_cstream_var(wp, varName, "");
		val = 0;
		if (strVal[0])
			val = atoi(strVal);
		update_wps_configured(val);
	}
#endif

#if defined(UNIVERSAL_REPEATER) && defined(CONFIG_REPEATER_WPS_SUPPORT)
	if (vwlan_idx == NUM_VWLAN_INTERFACE)
	{
		sprintf(varName, "wps_clear_configure_by_reg%d", wlan_id);
		/* WNC-NMR0348-JOE-PENG-20130329-Fix Page Fault occurs during setting on GUI */
		strVal = req_get_cstream_var(wp, varName, "");
		val = 0;
		if (strVal[0])
			val = atoi(strVal);
		update_wps_configured(val);
	}
#endif

	return 0 ;
setErr_encrypt:
	return -1 ;		
}	


#if defined(WLAN_PROFILE)
int wlanProfileEncryptHandler(request *wp, char *tmpBuf)
{
	char varName[20];
	char *strEncrypt, *strVal;
	int ssid_idx = 0; //WNC-NMR0000-Rita-20130305-Error_433-fix warnings of cppcheck (uninitialized value).
	int profile_num_id,	profile_tbl_id, profile_mod_id;
	WLAN_PROFILE_T entry;
	WLAN_PROFILE_T target[2];
	ENCRYPT_T encrypt;

//displayPostDate(wp->post_data);
	memset(target, 0x00, sizeof(WLAN_PROFILE_T)*2);
	strVal = req_get_cstream_var(wp, "SSID_Setting", "");
		
	if (strVal[0])
		ssid_idx = atoi(strVal);

#if defined(UNIVERSAL_REPEATER) 
	if(ssid_idx < (1+NUM_VWLAN+1) || ssid_idx>=(1+NUM_VWLAN+1+MAX_WLAN_PROFILE_NUM))
#else
	if(ssid_idx < (1+NUM_VWLAN) || ssid_idx>=(1+NUM_VWLAN+MAX_WLAN_PROFILE_NUM))
#endif		
	{
		strcpy(tmpBuf, ("ssid_idx is invalid!!"));
		goto setErr_wlan;
	}

	
	if(wlan_idx == 0)
	{
		profile_num_id = MIB_PROFILE_NUM1;
		profile_tbl_id = MIB_PROFILE_TBL1;
		profile_mod_id = MIB_PROFILE_MOD1;
	}
	else
	{
		profile_num_id = MIB_PROFILE_NUM2;
		profile_tbl_id = MIB_PROFILE_TBL2;
		profile_mod_id = MIB_PROFILE_MOD2;
	}

#if defined(UNIVERSAL_REPEATER) 
	ssid_idx -= (1+NUM_VWLAN+1);
#else
	ssid_idx -= (1+NUM_VWLAN);
#endif
	ssid_idx++;

//printf("\r\n ssid_idx=[%d],__[%s-%u]\r\n",ssid_idx,__FILE__,__LINE__);

	*((char *)&entry) = (char)ssid_idx;
	if ( !apmib_get(profile_tbl_id, (void *)&entry)) {
		strcpy(tmpBuf, ("Get table entry error!"));
		goto setErr_wlan;
	}

	memcpy(&target[0], &entry, sizeof(WLAN_PROFILE_T));

	sprintf(varName, "method%d", wlan_idx);
	strEncrypt = req_get_cstream_var(wp, varName, "");
	encrypt = (ENCRYPT_T) strEncrypt[0] - '0';

//printf("\r\n encrypt[%d],__[%s-%u]\r\n",encrypt,__FILE__,__LINE__);

	if (encrypt==ENCRYPT_WEP) 
	{
		char *strWep, *strAuth, *strFormat, *wepKey;
		int keyLen;
		char key[30];
		
		sprintf(varName, "length%d", wlan_idx);
		strWep = req_get_cstream_var(wp, varName, "");
		if(strWep[0])
		{
			entry.encryption = atoi(strWep);
		}

		sprintf(varName, "format%d", wlan_idx);
		strFormat = req_get_cstream_var(wp, varName, "");
		if(strFormat[0])
		{
			entry.wepKeyType = atoi(strFormat)-1;
		}
		
		strAuth = req_get_cstream_var(wp, ("authType"), "");
		if (strAuth[0]) { // new UI
			if (!strcmp(strAuth, ("open")))
				entry.auth = AUTH_OPEN;
			else if ( !strcmp(strAuth, ("shared")))
				entry.auth = AUTH_SHARED;
			else 
				entry.auth = AUTH_BOTH;			
		}

		sprintf(varName, "key%d", wlan_idx);
		wepKey = req_get_cstream_var(wp, varName, "");
		if  (wepKey[0]) {

			if ( !isAllStar(wepKey) ) {

				if (entry.encryption == WEP64) {
					if (entry.wepKeyType==0)
						keyLen = WEP64_KEY_LEN;
					else
						keyLen = WEP64_KEY_LEN*2;
				}
				else 
				{
					if (entry.wepKeyType==0)
						keyLen = WEP128_KEY_LEN;
					else
						keyLen = WEP128_KEY_LEN*2;
				}
		
				if (entry.wepKeyType == 0) // ascii
					strncpy(key, wepKey, sizeof(key));/* WNC-NMR0000-JOE-PENG-20140911-Fix bug 2206 (STRING_OVERFLOW) in StaticCodeCheck_Linear_Delta1.xls */
				else // hex
				{ 
					if ( !string_to_hex(wepKey, key, keyLen)) {
		   				strcpy(tmpBuf, ("Invalid wep-key value!"));
						goto setErr_wlan;
					}
				}
				if (entry.encryption == WEP64){
					strncpy(entry.wepKey1, key, 10);
					strncpy(entry.wepKey2, key, 10);
					strncpy(entry.wepKey3, key, 10);
					strncpy(entry.wepKey4, key, 10);
				}else{
					strncpy(entry.wepKey1, key, 26);
					strncpy(entry.wepKey2, key, 26);
					strncpy(entry.wepKey3, key, 26);
					strncpy(entry.wepKey4, key, 26);
				}			
			}
		}
		
	}
	else if (encrypt > ENCRYPT_WEP) 
	{
		char *strWpaAuth, *strCipherSuite, *strPskFormat, *strPskValue;
		int cipherSuite, pskFormat;
		int getPSK=0;//WNC-NMR0000-Rita-20130310-Error_585-fix warnings of cppcheck (uninitialized value).
		// WPA authentication

		if(encrypt == ENCRYPT_WPA)
			entry.encryption = 3; //wpa
		else
			entry.encryption = 4; //wpa2
		
		sprintf(varName, "wpaAuth%d", wlan_idx);
		strWpaAuth = req_get_cstream_var(wp, varName, "");
		if (strWpaAuth[0]) 
		{
			if ( !strcmp(strWpaAuth, ("eap"))) {
				strcpy(tmpBuf, ("Invalid wpaAuth value!"));
				//goto setErr_wlan;
			}
			else if ( !strcmp(strWpaAuth, ("psk"))) {
				getPSK = 1;
			}
			else {
				strcpy(tmpBuf, ("Error! Invalid wpa authentication value."));
				goto setErr_wlan;
			}
		}

		sprintf(varName, "ciphersuite%d", wlan_idx);
		strCipherSuite = req_get_cstream_var(wp, varName, "");	 	
		if(encrypt == ENCRYPT_WPA)
		{
			if (strCipherSuite[0]) {
				cipherSuite = 0;				
				if ( strstr(strCipherSuite, ("tkip"))) 
					cipherSuite |= WPA_CIPHER_TKIP;
				if ( strstr(strCipherSuite, ("aes"))) 
					cipherSuite |= WPA_CIPHER_AES;
				if (cipherSuite == 0 || cipherSuite == WPA_CIPHER_MIXED) //check if both TKIP and AES cipher are selected in client mode
				{
					strcpy(tmpBuf, ("Invalid value of cipher suite!"));
					goto setErr_wlan;
				}

				if(cipherSuite == WPA_CIPHER_TKIP)
					entry.wpa_cipher = 2;
				else
					entry.wpa_cipher = 8;
			
			}		
		}
		else if(encrypt == ENCRYPT_WPA2)		
		{
			sprintf(varName, "wpa2ciphersuite%d", wlan_idx);
			strCipherSuite = req_get_cstream_var(wp, varName, "");	 	
			if (strCipherSuite[0]) {
				cipherSuite = 0;				
				if ( strstr(strCipherSuite, ("tkip"))) 
					cipherSuite |= WPA_CIPHER_TKIP;
				if ( strstr(strCipherSuite, ("aes"))) 
					cipherSuite |= WPA_CIPHER_AES;
				if (cipherSuite == 0 || cipherSuite == WPA_CIPHER_MIXED) //check if both TKIP and AES cipher are selected in client mode
				{
					strcpy(tmpBuf, ("Invalid value of cipher suite!"));
					goto setErr_wlan;
				}

				if(cipherSuite == WPA_CIPHER_TKIP)
					entry.wpa_cipher = 2;
				else
					entry.wpa_cipher = 8;
				
			}
		}

		// pre-shared key
		if ( getPSK ) {
			int oldFormat, oldPskLen, i;

			sprintf(varName, "pskFormat%d", wlan_idx);
   			strPskFormat = req_get_cstream_var(wp, varName, "");
			if (!strPskFormat[0]) {
	 			strcpy(tmpBuf, ("Error! no psk format."));
				goto setErr_wlan;
			}
			pskFormat = strPskFormat[0] - '0';
			if (pskFormat != 0 && pskFormat != 1) {
	 			strcpy(tmpBuf, ("Error! invalid psk format."));
				goto setErr_wlan;
			}

			// remember current psk format and length to compare to default case "****"
			sprintf(varName, "pskValue%d", wlan_idx);
			strPskValue = req_get_cstream_var(wp, varName, "");

			entry.wpaPSKFormat= pskFormat;

			if (pskFormat==1) { // hex
				if (strlen(strPskValue)!=MAX_PSK_LEN || !string_to_hex(strPskValue, tmpBuf, MAX_PSK_LEN)) {
	 				strcpy(tmpBuf, ("Error! invalid psk value."));
					goto setErr_wlan;
				}
			}
			else { // passphras
				if (strlen(strPskValue)==0 || strlen(strPskValue) > (MAX_PSK_LEN-1) ) {
	 				strcpy(tmpBuf, ("Error! invalid psk value."));
					goto setErr_wlan;
				}
			}
			strcpy(entry.wpaPSK, strPskValue);
		
		}

	}
	else
	{
		char oldSsid[32];

		/* WNC-NMR0000-JOE-PENG-20140911-Fix bug 2241 (STRING_OVERFLOW) in StaticCodeCheck_Linear_Delta1.xls -start */
		//strcpy(oldSsid, entry.ssid);
		strncpy(oldSsid, entry.ssid, sizeof(oldSsid));
		/* WNC-NMR0000-JOE-PENG-20140911-Fix bug 2241 (STRING_OVERFLOW) in StaticCodeCheck_Linear_Delta1.xls -end */
		memset(&entry, 0x00, sizeof(WLAN_PROFILE_T));
		strcpy(entry.ssid, oldSsid);
		entry.wpa_cipher = 8; //WPA_CIPHER_AES
		
	}

	memcpy(&target[1], &entry, sizeof(WLAN_PROFILE_T));

	if ( !apmib_set(profile_mod_id, (void *)&target)) {
		strcpy(tmpBuf, ("Modify table entry error!"));
		goto setErr_wlan;
	}

	return 0 ;
setErr_wlan:
	
	return -1 ;	
}
#endif //#if defined(WLAN_PROFILE)
/////////////////////////////////////////////////////////////////////////////
void formWlEncrypt(request *wp, char *path, char *query)
{
	char *submitUrl;
	char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};
	
//displayPostDate(wp->post_data);	
#ifdef MBSSID	
	char *strEncrypt, *strVal, *strVal1;
	char varName[40];
	int ssid_idx, ssid_idx2, old_idx=-1;

   	strVal1 = req_get_cstream_var(wp, "wlan_ssid_id", "");
   	strVal = req_get_cstream_var(wp, "SSID_Setting", "");
		
	if (strVal[0]) {
		ssid_idx2 = ssid_idx = atoi(strVal);

#if defined(CONFIG_RTL_ULINKER)
	if(ssid_idx == 5) //vxd
		ssid_idx = NUM_VWLAN_INTERFACE;
#endif
		
	mssid_idx = atoi(strVal1); // selected index from UI
	old_idx = vwlan_idx;
	vwlan_idx = ssid_idx;
		
#if defined(WLAN_PROFILE)
//printf("\r\n ssid_idx=[%d],__[%s-%u]\r\n",ssid_idx,__FILE__,__LINE__);

#if defined(UNIVERSAL_REPEATER) 
	if (ssid_idx2 >= (1+NUM_VWLAN+1))
#else
	if (ssid_idx2 >= (1+NUM_VWLAN))
#endif
	{
		if(wlanProfileEncryptHandler(wp, tmpBuf) == 0)
		{
			goto setOK;

		}
		else
		{
			goto setErr_end ;
		}
	}
	else
#endif //#if defined(WLAN_PROFILE)		
	{
		if (ssid_idx > NUM_VWLAN_INTERFACE) {			
			printf("Invald ssid_id!\n");
			return;
		}			
	}


		
	
		sprintf(varName, "method%d", wlan_idx);
	   	strEncrypt = req_get_cstream_var(wp, varName, "");
		ENCRYPT_T encrypt = (ENCRYPT_T) strEncrypt[0] - '0';

		if (encrypt==ENCRYPT_WEP) {
			char *strAuth = req_get_cstream_var(wp, ("authType"), "");
			AUTH_TYPE_T authType;
			if (strAuth[0]) { // new UI
				if (!strcmp(strAuth, ("open")))
					authType = AUTH_OPEN;
				else if ( !strcmp(strAuth, ("shared")))
					authType = AUTH_SHARED;
				else 
					authType = AUTH_BOTH;
				apmib_set(MIB_WLAN_AUTH_TYPE, (void *)&authType);

				sprintf(varName, "use1x%d", wlan_idx);
				strVal = req_get_cstream_var(wp, varName, "");		
			
				if (strVal[0] && strcmp(strVal, "ON")) {
					int intVal = 0;
					apmib_set( MIB_WLAN_ENABLE_1X, (void *)&intVal);			
					formWep(wp, path, query);
					vwlan_idx = old_idx;					
					return;	
				}
			}
		}
	}
	else
			mssid_idx = 0;
#endif // MBSSID
	
	if(wpaHandler(wp, tmpBuf, wlan_idx) < 0) {
#ifdef MBSSID
		if (old_idx >= 0)
			vwlan_idx = old_idx;	
#endif		
		goto setErr_end ;
	}

setOK:
	
	apmib_update_web(CURRENT_SETTING);

#ifndef NO_ACTION
	run_init_script("bridge");
#endif

	submitUrl = req_get_cstream_var(wp, ("submit-url"), "");   // hidden page
	OK_MSG(submitUrl);

#ifdef MBSSID
	if (old_idx >= 0)
		vwlan_idx = old_idx;	
#endif

	return;

setErr_end:
	ERR_MSG(tmpBuf);
}

#ifdef CONFIG_RTK_MESH

/////////////////////////////////////////////////////////////////////////////
int wlMeshNeighborTable(request *wp, int argc, char **argv)
{
    int nBytesSent=0;
    int nRecordCount=0;
    FILE *fh;
    char buf[512], network[100];
    char hwaddr[100],state[100],channel[100],link_rate[100],tx_pkts[10],rx_pkts[10];
    char rssi[100],establish_exp_time[100],bootseq_exp_time[100],dummy[100];

    nBytesSent += req_format_write(wp, ("<tr class=\"tbl_head\">"
            "<td align=center width=\"17%%\"><font size=\"2\"><b>MAC Address</b></font></td>\n"
            "<td align=center width=\"17%%\"><font size=\"2\"><b>Mode</b></font></td>\n"
            "<td align=center width=\"17%%\"><font size=\"2\"><b>Tx Packets</b></font></td>\n"
            "<td align=center width=\"17%%\"><font size=\"2\"><b>Rx Packets</b></font></td>\n"
            "<td align=center width=\"17%%\"><font size=\"2\"><b>Tx Rate (Mbps)</b></font></td>\n"
            "<td align=center width=\"17%%\"><font size=\"2\"><b>RSSI</b></font></td>\n"
            "<td align=center width=\"17%%\"><font size=\"2\"><b>Expired Time (s)</b></font></td>\n"));

    sprintf(buf,"/proc/wlan%d/%s",wlan_idx,_FILE_MESH_ASSOC);
    fh = fopen(buf, "r");
    if (!fh)
    {
        printf("Warning: cannot open %s\n",buf);
        return -1;
    }

    while( fgets(buf, sizeof buf, fh) != NULL )
    {
        if( strstr(buf,"Mesh MP_info") != NULL )
        {
            _get_token( fh,"state: ",state );
            _get_token( fh,"hwaddr: ",hwaddr );
            _get_token( fh,"mode: ",network );
            _get_token( fh,"Tx Packets: ",tx_pkts );
            _get_token( fh,"Rx Packets: ",rx_pkts );
            _get_token( fh,"Authentication: ",dummy );
            _get_token( fh,"Assocation: ",dummy );
            _get_token( fh,"LocalLinkID: ",dummy );
            _get_token( fh,"PeerLinkID: ",dummy );
            _get_token( fh,"operating_CH: ", channel );
            _get_token( fh,"CH_precedence: ", dummy );
            _get_token( fh,"R: ", link_rate );
            _get_token( fh,"Ept: ", dummy );
            _get_token( fh,"rssi: ", rssi );
            _get_token( fh,"matric: ", dummy );            
            _get_token( fh,"expire_Establish(jiffies): ", dummy );
            _get_token( fh,"(Sec): ", establish_exp_time );
            _get_token( fh,"expire_BootSeq & LLSA(jiffies): ", dummy );
            _get_token( fh,"(mSec): ", bootseq_exp_time );
            _get_token( fh,"retry: ", dummy );

            switch( atoi(state) )
            {
                case 5:
                case 6:
                    strcpy(state,"SUBORDINATE");
                    break;

                case 7:
                case 8:
                    strcpy(state,"SUPERORDINATE");
                    break;

                default:
                    break;
            }

            nBytesSent += req_format_write(wp,("<tr class=\"tbl_body\">"
                    "<td align=center width=\"17%%\"><font size=\"2\">%s</td>\n"
                    "<td align=center width=\"17%%\"><font size=\"2\">%s</td>\n"
                    "<td align=center width=\"17%%\"><font size=\"2\">%s</td>\n"
                    "<td align=center width=\"17%%\"><font size=\"2\">%s</td>\n"
                    "<td align=center width=\"17%%\"><font size=\"2\">%s</td>\n"
                    "<td align=center width=\"17%%\"><font size=\"2\">%s</td>\n"
                    "<td align=center width=\"17%%\"><font size=\"2\">%s</td>\n"),
                    hwaddr,network,tx_pkts,rx_pkts,link_rate,rssi,establish_exp_time);

            nRecordCount++;
        }
    }

    fclose(fh);

    if(nRecordCount == 0)
    {
        nBytesSent += req_format_write(wp,("<tr class=\"tbl_body\">"
                "<td align=center><font size=\"2\">None</td>"
                "<td align=center width=\"17%%\"><font size=\"2\">---</td>\n"
                "<td align=center width=\"17%%\"><font size=\"2\">---</td>\n"                        
                "<td align=center width=\"17%%\"><font size=\"2\">---</td>\n"
                "<td align=center width=\"17%%\"><font size=\"2\">---</td>\n"
                "<td align=center width=\"17%%\"><font size=\"2\">---</td>\n"
                "<td align=center width=\"17%%\"><font size=\"2\">---</td>\n"));
    }


    return nBytesSent;
}

/////////////////////////////////////////////////////////////////////////////
int wlMeshRoutingTable(request *wp, int argc, char **argv)
{
    int nBytesSent=0;
    int nRecordCount=0;
    FILE *fh;
    char buf[512];
    unsigned char mac[7];
    char putstr[20];
    int tmp;


    struct mesh_entry{
        char destMac[50],nexthopMac[50],dsn[50], isPortal[10];
        char metric[50],hopcount[10], start[50], end[50], diff[50], flag[10];
        struct mesh_entry *prev;
        struct mesh_entry *next;
    };

    struct mesh_entry *head = NULL;
    struct mesh_entry *p, *np;
        
		

    nBytesSent += req_format_write(wp, ("<tr class=\"tbl_head\">"
        "<td align=center width=\"15%%\"><font size=\"2\"><b>Destination Mesh Point</b></font></td>\n"
        "<td align=center width=\"15%%\"><font size=\"2\"><b>Next-hop Mesh Point</b></font></td>\n"
        "<td align=center width=\"10%%\"><font size=\"2\"><b>Portal Enable</b></font></td>\n"
        "<td align=center width=\"10%%\"><font size=\"2\"><b>Metric</b></font></td>\n"
        "<td align=center width=\"10%%\"><font size=\"2\"><b>Hop Count</b></font></td>\n"));

    sprintf(buf,"/proc/wlan%d/%s",wlan_idx,_FILE_MESH_ROUTE);
    fh = fopen(buf, "r");
    if (!fh)
    {
        printf("Warning: cannot open %s\n",buf );
        return -1;
    }


    while( fgets(buf, sizeof buf, fh) != NULL )
    {
        if( strstr(buf,"Mesh route") != NULL )
        {			                	
            np= malloc(sizeof(struct mesh_entry));
            np->next = NULL;
            np->prev = NULL;

            //                        _get_token( fh,"isvalid: ",isvalid );
            _get_token( fh,"destMAC: ", np->destMac );
            tmp = strlen(np->destMac)-1;
            np->destMac[tmp] = '\0';
            _get_token( fh,"nexthopMAC: ", np->nexthopMac );
            _get_token( fh,"portal enable: ", np->isPortal );
            _get_token( fh,"dsn: ", np->dsn);
            _get_token( fh,"metric: ", np->metric );
            _get_token( fh,"hopcount: ", np->hopcount );
            _get_token( fh,"start: ", np->start );
            _get_token( fh,"end: ", np->end );
            _get_token( fh,"diff: ", np->diff );
            _get_token( fh,"flag: ", np->flag );

            if (head == NULL){
                head = np;
            } else {
                p = head;
                while (p!=NULL) {
                    if (atoi(np->hopcount)< atoi(p->hopcount)){
                        if (p->prev!=NULL) {
                            p->prev->next = np;
                        }
                        np->prev = p->prev;
                        np->next = p;
                        p->prev = np;
                        break;
                    } else {
                        if (p->next == NULL) {
                            p->next = np;
                            np->prev = p;
                            break;
                        }
                        else
                            p = p->next;
                    }
                }
            }
            nRecordCount++;
        }
    }

    fclose(fh);

    //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++



    //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

    if( apmib_get(MIB_WLAN_WLAN_MAC_ADDR, (void *)mac)<0 )
        fprintf(stderr,"get mib error \n");

    if ( (mac[0]|mac[1]|mac[2]|mac[3]|mac[4]|mac[5]) == 0){
        memset(mac,0x0,sizeof(mac));
        apmib_get(MIB_HW_WLAN_ADDR, (void *)mac);
    }

    if(nRecordCount == 0)
    {
        nBytesSent += req_format_write(wp,("<tr class=\"tbl_body\">"
                "<td><font size=\"2\">None</td>"
                "<td align=center width=\"15%%\"><font size=\"2\">---</td>\n"
                "<td align=center width=\"15%%\"><font size=\"2\">---</td>\n"
                "<td align=center width=\"10%%\"><font size=\"2\">---</td>\n"                        
                "<td align=center width=\"10%%\"><font size=\"2\">---</td>\n"
                "<font size=\"2\">---</td>\n"));
    } else {

        p = head;

        while (p!=NULL){

            if (p->destMac[0] == 'M') { 	 
                sprintf(putstr, "%02X%02X%02X%02X%02X%02X"
                        , mac[0], mac[1], mac[2], mac[3], mac[4], mac[5]);
            } else {
                strcpy(putstr, p->destMac);
            }

            nBytesSent += req_format_write(wp,("<tr class=\"tbl_body\">"
                    "<td align=center width=\"15%%\"><font size=\"2\">%s</td>\n"
                    "<td align=center width=\"15%%\"><font size=\"2\">%s</td>\n"
                    "<td align=center width=\"15%%\"><font size=\"2\">%s</td>\n"
                    "<td align=center width=\"10%%\"><font size=\"2\">%s</td>\n"
                    "<td align=center width=\"10%%\"><font size=\"2\">%s</td>\n"),
                    p->destMac,p->nexthopMac,p->isPortal,p->metric,p->hopcount,putstr);
            p = p->next;
        }
    }


    return nBytesSent;
}

int wlMeshPortalTable(request *wp, int argc, char **argv)
{
        int nBytesSent=0;
        int nRecordCount=0;
        FILE *fh;
        char buf[512];
        char mac[100],timeout[100],seq[100];

        nBytesSent += req_format_write(wp, ("<tr class=\"tbl_head\">"
        "<td align=center width=\"16%%\"><font size=\"2\"><b>PortalMAC</b></font></td>\n"));

		sprintf(buf,"/proc/wlan%d/%s",wlan_idx,_FILE_MESH_PORTAL);
        fh = fopen(buf, "r");
        if (!fh)
        {
                printf("Warning: cannot open %s\n",buf );
                return -1;
        }

        while( fgets(buf, sizeof buf, fh) != NULL )
        {
                if( strstr(buf," portal table info..") != NULL )
                {
                        _get_token( fh,"PortalMAC: ",mac );
                        _get_token( fh,"timeout: ",timeout );
                        _get_token( fh,"seqNum: ",seq );

                        nBytesSent += req_format_write(wp,("<tr class=\"tbl_body\">"
                        "<td align=center width=\"16%%\"><font size=\"2\">%s</td>\n"), mac);
                        nRecordCount++;
                }
        }

        fclose(fh);

        if(nRecordCount == 0)
        {
                nBytesSent += req_format_write(wp,("<tr class=\"tbl_body\">"
                        "<td><font size=\"2\">None</td>"));
        }


        return nBytesSent;
}


/////////////////////////////////////////////////////////////////////////////
int wlMeshProxyTable(request *wp, int argc, char **argv)
{
        int nBytesSent=0;
        int nRecordCount=0;
        FILE *fh;
        char buf[512];
        char sta[100],owner[100];

        nBytesSent += req_format_write(wp, ("<tr class=\"tbl_head\">"
        "<td align=center width=\"50%%\"><font size=\"2\"><b>Owner</b></font></td>\n"
        "<td align=center width=\"50%%\"><font size=\"2\"><b>Client</b></font></td></tr>\n"));

		sprintf(buf,"/proc/wlan%d/%s",wlan_idx,_FILE_MESH_PROXY);
        fh = fopen(buf, "r");
        if (!fh)
        {
                printf("Warning: cannot open %s\n",buf );
                return -1;
        }

        while( fgets(buf, sizeof buf, fh) != NULL )
        {
                if( strstr(buf,"table info...") != NULL )
                {
                        _get_token( fh,"STA_MAC: ",sta );
                        _get_token( fh,"OWNER_MAC: ",owner );
       

                        nBytesSent += req_format_write(wp,("<tr class=\"tbl_body\">"
                                "<td align=center width=\"50%%\"><font size=\"2\">%s</td>\n"
                                "<td align=center width=\"50%%\"><font size=\"2\">%s</td>\n"),
                                owner,sta);
                        nRecordCount++;
                }
        }

        fclose(fh);

        if(nRecordCount == 0)
        {
                nBytesSent += req_format_write(wp,("<tr class=\"tbl_body\">"
                        "<td><font size=\"2\">None</td>"
                        "<td align=center width=\"17%%\"><font size=\"2\">---</td>\n"));
        }

        return nBytesSent;
}

int wlMeshRootInfo(request *wp, int argc, char **argv)
{
        int nBytesSent=0;
        FILE *fh;
        char rootmac[100],buf[100];
		char z12[]= "000000000000";
		
		sprintf(buf,"/proc/wlan%d/%s",wlan_idx,_FILE_MESH_ROOT);
        fh = fopen(buf, "r");
        if (!fh)
        {
                printf("Warning: cannot open %s\n",buf );
                return -1;
        }
	
        _get_token( fh, "ROOT_MAC: ", rootmac );
		if( memcmp(rootmac,z12,12 ) )
             nBytesSent += req_format_write(wp,"%s",  rootmac);
		else
		     nBytesSent += req_format_write(wp,("None"));

        fclose(fh);
        return nBytesSent;
}


#endif // CONFIG_RTK_MESH

/////////////////////////////////////////////////////////////////////////////

#if 1 /* for spider project */
int wlAcList(request *wp, int argc, char **argv)
{
	int nBytesSent=0, entryNum=0, i, macAclMode;//WNC-NMR0000-Rita-20130305-Error_404-fix warnings of cppcheck (uninitialized value).
	MACFILTER_T entry;
	char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};

	if ( !apmib_get( MIB_CLIENT_ACL_MODE, (void *)&macAclMode) ) {
		return -1;
	}

	if ( !apmib_get(MIB_WLAN_MACAC_NUM, (void *)&entryNum)) {
  		fprintf(stderr, "Get table entry error!\n");
		return -1;
	}

	for (i=1; i<=entryNum; i++) {
		*((char *)&entry) = (char)i;
		if ( !apmib_get(MIB_WLAN_MACAC_ADDR, (void *)&entry))
			return -1;

		if((i != 1) && ((i % 10) == 1))
		{
			int toggleBox_num;

			if(i<11)
				toggleBox_num = 1;
			else if(i<21)
				toggleBox_num = 2;
			else if(i<31)
				toggleBox_num = 3;
			else if(i<41)
				toggleBox_num = 4;
			else if(i<51)
				toggleBox_num = 5;			
			else
				toggleBox_num = 6;			

			nBytesSent += req_format_write(wp, ("</table></div>\n"
				"<div id='toggleBox%d' class='toggleBox'><table summary='ơ֥' class='wAuto mNone' id=maclist><tr>\n"
				"<th>MACɥ쥹</th><th></th></tr>\n"),
				toggleBox_num);
		}

		snprintf(tmpBuf, MAX_MSG_BUFFER_SIZE, ("%02x:%02x:%02x:%02x:%02x:%02x"),
			entry.macAddr[0], entry.macAddr[1], entry.macAddr[2],
			entry.macAddr[3], entry.macAddr[4], entry.macAddr[5]);

		{
			//char buffer[500];
	
			//strcpy(buffer, entry.comment);
			//translate_control_code(buffer);

			if(macAclMode==0)
			{
				nBytesSent += req_format_write(wp, ("<tr>\n"
					"<td>%s</td>\n"
					"<td></td>\n"
					"</tr>\n"
					"<input type=\"hidden\" value=\"\" name=\"select%d\" id=\"select%d\" >"),
					tmpBuf, i, i, i);
			}
			else
			{
				nBytesSent += req_format_write(wp, ("<tr>\n"
					"<td>%s</td>\n"
					"<td><a href=javascript:DelClick(\"select%d\"); class=\"btn light small\"></a></td>\n"
					"</tr>\n"
					"<input type=\"hidden\" value=\"\" name=\"select%d\" id=\"select%d\" >"),
					tmpBuf, i, i, i);
			}
		}
	}
	return nBytesSent;
}

#else

int wlAcList(request *wp, int argc, char **argv)
{
	int nBytesSent=0, entryNum=0, i;//WNC-NMR0000-Rita-20130305-Error_404-fix warnings of cppcheck (uninitialized value).
	MACFILTER_T entry;
	char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};

	if ( !apmib_get(MIB_WLAN_MACAC_NUM, (void *)&entryNum)) {
  		fprintf(stderr, "Get table entry error!\n");
		return -1;
	}
/*
	nBytesSent += req_format_write(wp, ("<tr>"
      	"<td align=center width=\"45%%\" bgcolor=\"#808080\"><font size=\"2\"><b>MAC Address</b></font></td>\n"
      	"<td align=center width=\"35%%\" bgcolor=\"#808080\"><font size=\"2\"><b>Comment</b></font></td>\n"
      	"<td align=center width=\"20%%\" bgcolor=\"#808080\"><font size=\"2\"><b>Select</b></font></td></tr>\n"));
*/
/* WNC-MR0000-Libera-20120308- for Japanese by NEC */
	nBytesSent += req_format_write(wp, ("<tr>"
      	"<td align=center width=\"45%%\" bgcolor=\"#808080\"><font size=\"2\"><b>MACɥ쥹</b></font></td>\n"
      	"<td align=center width=\"35%%\" bgcolor=\"#808080\"><font size=\"2\"><b></b></font></td>\n"
      	"<td align=center width=\"20%%\" bgcolor=\"#808080\"><font size=\"2\"><b></b></font></td></tr>\n"));
/* WNC-MR0000-Libera-20120308- for Japanese by NEC */
	for (i=1; i<=entryNum; i++) {
		*((char *)&entry) = (char)i;
		if ( !apmib_get(MIB_WLAN_MACAC_ADDR, (void *)&entry))
			return -1;

		snprintf(tmpBuf, MAX_MSG_BUFFER_SIZE, ("%02x:%02x:%02x:%02x:%02x:%02x"),
			entry.macAddr[0], entry.macAddr[1], entry.macAddr[2],
			entry.macAddr[3], entry.macAddr[4], entry.macAddr[5]);

		/* WNC-NMR0034-JOE-PENG-20120426-Fix cross-site scripting(XSS) */
		{
			char buffer[500];

			strcpy(buffer, entry.comment);
			translate_control_code(buffer);

			nBytesSent += req_format_write(wp, ("<tr>"
				"<td align=center width=\"45%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
	      			"<td align=center width=\"35%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
	       			"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><input type=\"checkbox\" name=\"select%d\" value=\"ON\"></td></tr>\n"),
					tmpBuf, buffer, i);
		}
		/* WNC-NMR0034-JOE-PENG-20120426-end */
	}
	return nBytesSent;
}
#endif

/////////////////////////////////////////////////////////////////////////////
/* WNC-NMR015-Libera-20120417- handle rootAP and vap1 MAC Access Controll */
void formWncWlAc(request *wp, char *path, char *query)
{
	char *strAddMac, *strDelMac, *strDelAllMac, *strVal, *submitUrl, *strEnabled;
	//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20130103, Apply Realtek SDK 3.3.1 Alpha Patch
	//	char tmpBuf[100];
		char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};
	//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20130103, Apply Realtek SDK 3.3.1 Alpha Patch End	
	int entryNum=0, i, enabled, idx,tmp_vwlan_idx,wlanIdx;//WNC-NMR0000-Rita-20130306-Error_489,Error_533-fix warnings of cppcheck (uninitialized value).
	int rptEnabled = 0; /* WNC-MR1854-MIKE-YEH-20160926-The MAC filtering does not work for secondary_SSID. */
	MACFILTER_T macEntry;

	memset(&macEntry,0,sizeof(MACFILTER_T)); //WNC-NMR0000-Rita-20130310-Error_549-fix warnings of cppcheck (uninitialized value).
	strAddMac = req_get_cstream_var(wp, ("addFilterMac"), "");
	strDelMac = req_get_cstream_var(wp, ("deleteSelFilterMac"), "");
	strDelAllMac = req_get_cstream_var(wp, ("deleteAllFilterMac"), "");
	strEnabled = req_get_cstream_var(wp, ("wlanAcEnabled"), "");
	/* WNC-NMR1390-[Spider]-Libera-20160301- warning page for WPS running-v2-start */
	if ((lw_is_rakuraku_running()==1) || (lw_is_wps_running()==1)) {
		/* If RakuRaku or WPS is running, do not exeute site survey and return directly. */
		/* Site survey page knows RakuRaku or WPS is running by ASP GET function and will pop up warning message. */
	//	if (submitUrl[0]){
			//send_redirect_perm(wp, submitUrl);
			send_redirect_perm(wp, "/cgi_html_903.html");
	//		}
		return;
	}
	/* WNC-NMR1390-[Spider]-Libera-20160301- warning page for WPS running-v2-end */

	/* WNC-MR1854-MIKE-YEH-20160926-The MAC filtering does not work for secondary_SSID. */
	apmib_get(MIB_REPEATER_ENABLED1, (void *)&rptEnabled);

/* WNC-NMR0000-Rita-20130225-Apply MAC rules to both dual radios */
for(wlanIdx=0; wlanIdx<NUM_WLAN_INTERFACE; wlanIdx++){
	unsigned char wlanif[10];
	memset(wlanif,0x00,sizeof(wlanif));
	//sprintf(wlanif, "wlan%d",wlanIdx);
	snprintf(wlanif, sizeof(wlanif), "wlan%d",wlanIdx);//2426
	SetWlan_idx(wlanif);
	/* NMR2203-20161227-[request]-Unite condition in each operation mode about UMWA and MAC filter-start */
	if (access("/tmp/MODE_RPT", F_OK) == 0) {
		system("rm /tmp/MIB_MAPPING");
	}
	/* NMR2203-20161227-[request]-Unite condition in each operation mode about UMWA and MAC filter-end */


	//for (idx=0;idx<2;idx++){
	for (idx=0;idx<3;idx++){	/* NMR2203-20161227-[request]-Unite condition in each operation mode about UMWA and MAC filter*/
#if 0		/* NMR2203-20161227-[request]-Unite condition in each operation mode about UMWA and MAC filter-start*/
		/* WNC-MR1854-MIKE-YEH-20160926-The MAC filtering does not work for secondary_SSID. */
		if(idx>=1 && rptEnabled)
			break;
#endif		/* NMR2203-20161227-[request]-Unite condition in each operation mode about UMWA and MAC filter-end*/

	//for (idx=0;idx<3;idx++){/* WNC-MR000-Libera-20130703- Pocket spec.: change interface: wlan0->wlan0-va0, wlan0-va0->wlan0-va1 */
			tmp_vwlan_idx =vwlan_idx;
			vwlan_idx = idx;
		if (strAddMac[0]) {
			/*if ( !strcmp(strEnabled, "ON"))
				enabled = 1;
			else
				enabled = 0; */ //by sc_yang

	/* WNC-MRXXXX-JOE-PENG-20120319-Modification for NEC GUI customization */
			if(strEnabled[0]){
				enabled = atoi(strEnabled);

				/* WNC-NMR0000-JOE-PENG-20131220-Set MIB MACAC_ENABLED to 3 when MAC filter is disabled. For compatible with Access-Timer-start */
				if (enabled == 0) {
					enabled = 3;
				}
				/* WNC-NMR0000-JOE-PENG-20131220-Set MIB MACAC_ENABLED to 3 when MAC filter is disabled. For compatible with Access-Timer-end */

				if ( apmib_set( MIB_WLAN_MACAC_ENABLED, (void *)&enabled) == 0) {
					//strcpy(tmpBuf, ("Set enabled flag error!"));
					strlcpy(tmpBuf, ("Set enabled flag error!"), sizeof(tmpBuf));//2426
					goto setErr_ac;
				}
			}

	/* WNC-MRXXXX-JOE-PENG-20120319-end */
			strVal = req_get_cstream_var(wp, ("comment"), "");
			if ( strVal[0] ) {
				if (strlen(strVal) > COMMENT_LEN-1) {
	/* WNC-MR0090-JOE-PENG-20120518-Fix wording error */
#if 1
	        	       /* WNC-MR0000-Rita-20121003- Modification for GUI specification 1-9-Update warning message */
			                strcpy(tmpBuf, ("̵ʥȤǤѤȾѥʤ10ʸ⡢Ⱦѱѿ20ʸʸϤƤ"));
					//strcpy(tmpBuf, ("̵ʥȤǤȾ20ʸ10ʸ˰ϤƤ"));
					goto ErrPopup_WlAc;
#else
					strcpy(tmpBuf, ("Error! Comment length too long."));
					goto setErr_ac;
#endif
	/* WNC-MR0090-JOE-PENG-20120518-end */
				}
				//strcpy((char *)macEntry.comment, strVal);
				strlcpy((char *)macEntry.comment, strVal, sizeof(macEntry.comment));		//2426
			}
			else
				macEntry.comment[0] = '\0';

#if 1 /* spider project, Mike Yeh */

			/* WNC-NMR000-[Aero/Thalys]-MIKE-YEH-20160824-error check on server side. */
			strVal = req_get_cstream_var(wp, ("mac_colon"), "");

			if(lw_NullCheck(strVal) == -1 || lw_MacAddrCheck(strVal) == -1)
			{
				send_redirect_perm(wp, LW_GUI_INPUT_ERR_PAGE);
				return;
			}

			strVal = req_get_cstream_var(wp, ("mac"), "");	
			strlower(strVal);
			if ( !strVal[0] ) {
				//strcpy(tmpBuf, ("Error! No mac address to set."));
				goto setac_ret;
			}
			
			if (strlen(strVal)!=12 || !string_to_hex(strVal, macEntry.macAddr, 12)) {
					strcpy(tmpBuf, ("Error! Invalid MAC address."));
					goto setErr_ac;
			}

			// set to MIB for MACAC. 
			if ( apmib_set(MIB_WLAN_AC_ADDR_ADD, (void *)&macEntry) == 0) {
				strcpy(tmpBuf, ("Add table entry error!"));
				goto setErr_ac;
			}
#else
			if ( !apmib_get(MIB_WLAN_MACAC_NUM, (void *)&entryNum)) {
				strcpy(tmpBuf, ("Get entry number error!"));
				goto setErr_ac;
			}
			if ( (entryNum + 1) > MAX_WLAN_AC_NUM) {
				strcpy(tmpBuf, ("Cannot add new entry because table is full!"));
				goto setErr_ac;
			}

			/* WNC-NMR0098-JOE-PENG-20120529-Fix bug that user could set the same MAC address in wireless access control page */
			strVal = req_get_cstream_var(wp, ("mac"), "");
			/* WNC-MR0508-JOE-PENG-20130927-Fix bug that GUI can input duplicate MAC address(One is all lower case, the other is all upper case) */
			strlower(strVal);
			if ( !strVal[0] ) {
	//			strcpy(tmpBuf, ("Error! No mac address to set."));
				goto setac_ret;
			}
			if (strlen(strVal)!=12 || !string_to_hex(strVal, macEntry.macAddr, 12)) {
				strcpy(tmpBuf, ("Error! Invalid MAC address."));
				goto setErr_ac;
			}

			for (i=entryNum; i>0; i--) {
				char macaddr[30];
				MACFILTER_T macEntry_temp;
				
				*((char *)&macEntry_temp) = (char)i;
				apmib_get(MIB_WLAN_MACAC_ADDR, (void *)&macEntry_temp);
				
				if (!memcmp(macEntry_temp.macAddr, "\x0\x0\x0\x0\x0\x0", 6))
					macaddr[0]='\0';
				else	
					sprintf(macaddr,"%02x%02x%02x%02x%02x%02x", macEntry_temp.macAddr[0], macEntry_temp.macAddr[1], macEntry_temp.macAddr[2], macEntry_temp.macAddr[3], macEntry_temp.macAddr[4], macEntry_temp.macAddr[5]);
				
				if(!memcmp(strVal,macaddr,12)){
					strcpy(tmpBuf, ("ƱMACɥ쥹Υȥ꤬ϿƤޤ"));
					goto ErrPopup_WlAc;
				}
			}
			/* WNC-NMR0098-JOE-PENG-20120529-end */

			// set to MIB. try to delete it first to avoid duplicate case
			apmib_set(MIB_WLAN_AC_ADDR_DEL, (void *)&macEntry);
			if ( apmib_set(MIB_WLAN_AC_ADDR_ADD, (void *)&macEntry) == 0) {
				strcpy(tmpBuf, ("Add table entry error!"));
				goto setErr_ac;
			}

#endif /* spider project, Mike Yeh */
		
		}

		/* Delete entry */
		if (strDelMac[0]) {
			if ( !apmib_get(MIB_WLAN_MACAC_NUM, (void *)&entryNum)) {
				strcpy(tmpBuf, ("Get entry number error!"));
				goto setErr_ac;
			}
			for (i=entryNum; i>0; i--) {
				snprintf(tmpBuf, 20, "select%d", i);

				strVal = req_get_cstream_var(wp, tmpBuf, "");
				if ( !strcmp(strVal, "ON") ) {

					*((char *)&macEntry) = (char)i;
					if ( !apmib_get(MIB_WLAN_MACAC_ADDR, (void *)&macEntry)) {
						strcpy(tmpBuf, ("Get table entry error!"));
						goto setErr_ac;
					}
					if ( !apmib_set(MIB_WLAN_AC_ADDR_DEL, (void *)&macEntry)) {
						strcpy(tmpBuf, ("Delete table entry error!"));
						goto setErr_ac;
					}
				}
			}
		}

		/* Delete all entry */
		if ( strDelAllMac[0]) {
			if ( !apmib_set(MIB_WLAN_AC_ADDR_DELALL, (void *)&macEntry)) {
				strcpy(tmpBuf, ("Delete all table error!"));
				goto setErr_ac;
			}
		}
	}
	/* NMR2203-20161227-[request]-Unite condition in each operation mode about UMWA and MAC filter-start */
	if (access("/tmp/MODE_RPT", F_OK) == 0) {
		system("touch /tmp/MIB_MAPPING");
	}
	/* NMR2203-20161227-[request]-Unite condition in each operation mode about UMWA and MAC filter-end */
	
vwlan_idx=tmp_vwlan_idx;
} //end for loop-Apply MAC rules to both dual radios */
setac_ret:
	apmib_update_web(CURRENT_SETTING);

#ifndef NO_ACTION
	run_init_script("bridge");
#endif

	submitUrl = req_get_cstream_var(wp, ("submit-url"), "");   // hidden page
	OK_MSG( submitUrl );
  	return;

setErr_ac:
	ERR_MSG(tmpBuf);
	/* WNC-MR0000-JOE-PENG-20120330-for popup error alert */
	return;

ErrPopup_WlAc:
	POP_ERR_MSG(tmpBuf);
	return;
	/* WNC-MR0000-JOE-PENG-20120330-end */
}
/* WNC-NMR015-Libera-20120417- handle rootAP and vap1 MAC Access Controll -END */

void formWlAc(request *wp, char *path, char *query)
{
	char *strAddMac, *strAddApply, *strDelMac, *strDelAllMac, *strVal, *submitUrl, *strEnabled;
	
	char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};
	int entryNum=0, i, enabled; //WNC-NMR0000-Rita-20130306-Error_507,Error_521-fix warnings of cppcheck (uninitialized value).
	MACFILTER_T macEntry, macEntrytmp;
	int j = 0;
	memset(&macEntry,0,sizeof(MACFILTER_T)); //WNC-NMR0000-Rita-20130310-Error_540-fix warnings of cppcheck (uninitialized value).
	
	strAddMac = req_get_cstream_var(wp, ("addFilterMac"), "");
	strAddApply = req_get_cstream_var(wp, ("save_apply"), "");
	strDelMac = req_get_cstream_var(wp, ("deleteSelFilterMac"), "");
	strDelAllMac = req_get_cstream_var(wp, ("deleteAllFilterMac"), "");
	strEnabled = req_get_cstream_var(wp, ("wlanAcEnabled"), "");

	if (strAddMac[0] || strAddApply[0]) {
		/*if ( !strcmp(strEnabled, "ON"))
			enabled = 1;
		else
			enabled = 0; */ //by sc_yang

/* WNC-MRXXXX-JOE-PENG-20120319-Modification for NEC GUI customization */
#if 1
		if(strEnabled[0]){
			enabled = atoi(strEnabled);

			/* WNC-NMR0000-JOE-PENG-20131220-Set MIB MACAC_ENABLED to 3 when MAC filter is disabled. For compatible with Access-Timer-start */
			if (enabled == 0) {
				enabled = 3;
			}
			/* WNC-NMR0000-JOE-PENG-20131220-Set MIB MACAC_ENABLED to 3 when MAC filter is disabled. For compatible with Access-Timer-end */

			if ( apmib_set( MIB_WLAN_MACAC_ENABLED, (void *)&enabled) == 0) {
				strcpy(tmpBuf, ("Set enabled flag error!"));
				goto setErr_ac;
			}
		}
#else
		/* Codes here are Realtek original codes */
		 enabled = strEnabled[0] - '0';
		if ( apmib_set( MIB_WLAN_MACAC_ENABLED, (void *)&enabled) == 0) {
  			strcpy(tmpBuf, ("Set enabled flag error!"));
			goto setErr_ac;
		}
#endif
/* WNC-MRXXXX-JOE-PENG-20120319-end */

		strVal = req_get_cstream_var(wp, ("mac"), "");
		if ( !strVal[0] ) {
//			strcpy(tmpBuf, ("Error! No mac address to set."));
			goto setac_ret;
		}
		if (strlen(strVal)!=12 || !string_to_hex(strVal, macEntry.macAddr, 12)) {
			strcpy(tmpBuf, ("Error! Invalid MAC address."));
			goto setErr_ac;
		}

		strVal = req_get_cstream_var(wp, ("comment"), "");
		if ( strVal[0] ) {
			if (strlen(strVal) > COMMENT_LEN-1) {
/* WNC-NMR0090-Joe-20120517-fix wording error */
#if 1
        	    /* WNC-MR0000-Rita-20121012- Modification for GUI specification 1-9-Update warning message */
		        strcpy(tmpBuf, ("̵ʥȤǤѤȾѥʤ10ʸ⡢Ⱦѱѿ20ʸʸϤƤ"));
				//strcpy(tmpBuf, ("̵ʥȤǤȾ20ʸ10ʸ˰ϤƤ"));
				goto ErrPopup_WlAc;
#else
				strcpy(tmpBuf, ("Error! Comment length too long."));
				goto setErr_ac;
#endif
/* WNC-NMR0090-Joe-20120517-end */
			}
			strcpy((char *)macEntry.comment, strVal);
		}
		else
			macEntry.comment[0] = '\0';

		if ( !apmib_get(MIB_WLAN_MACAC_NUM, (void *)&entryNum)) {
			strcpy(tmpBuf, ("Get entry number error!"));
			goto setErr_ac;
		}
		if ( (entryNum + 1) > MAX_WLAN_AC_NUM) {
			strcpy(tmpBuf, ("Cannot add new entry because table is full!"));
			goto setErr_ac;
		}
		
		//add same rule check
		for(j=1;j<=entryNum;j++)
		{
			memset(&macEntrytmp, 0x00, sizeof(macEntrytmp));
			*((char *)&macEntrytmp) = (char)j;
			if ( apmib_get(MIB_WLAN_MACAC_ADDR, (void *)&macEntrytmp))
			{
				if (!memcmp(macEntrytmp.macAddr, macEntry.macAddr, 6))
				{
					strcpy(tmpBuf, ("rule already exist!"));
					goto setErr_ac;
				}
					
			}
		}

		// set to MIB. try to delete it first to avoid duplicate case
		apmib_set(MIB_WLAN_AC_ADDR_DEL, (void *)&macEntry);
		if ( apmib_set(MIB_WLAN_AC_ADDR_ADD, (void *)&macEntry) == 0) {
			strcpy(tmpBuf, ("Add table entry error!"));
			goto setErr_ac;
		}
	}

	/* Delete entry */
	if (strDelMac[0]) {
		if ( !apmib_get(MIB_WLAN_MACAC_NUM, (void *)&entryNum)) {
			strcpy(tmpBuf, ("Get entry number error!"));
			goto setErr_ac;
		}
		for (i=entryNum; i>0; i--) {
			snprintf(tmpBuf, 20, "select%d", i);

			strVal = req_get_cstream_var(wp, tmpBuf, "");
			if ( !strcmp(strVal, "ON") ) {

				*((char *)&macEntry) = (char)i;
				if ( !apmib_get(MIB_WLAN_MACAC_ADDR, (void *)&macEntry)) {
					strcpy(tmpBuf, ("Get table entry error!"));
					goto setErr_ac;
				}
				if ( !apmib_set(MIB_WLAN_AC_ADDR_DEL, (void *)&macEntry)) {
					strcpy(tmpBuf, ("Delete table entry error!"));
					goto setErr_ac;
				}
			}
		}
	}

	/* Delete all entry */
	if ( strDelAllMac[0]) {
		if ( !apmib_set(MIB_WLAN_AC_ADDR_DELALL, (void *)&macEntry)) {
			strcpy(tmpBuf, ("Delete all table error!"));
			goto setErr_ac;
		}
	}

setac_ret:
	apmib_update_web(CURRENT_SETTING);

#ifndef NO_ACTION
	run_init_script("bridge");
#endif

	submitUrl = req_get_cstream_var(wp, ("submit-url"), "");   // hidden page
	OK_MSG( submitUrl );
  	return;

setErr_ac:
	ERR_MSG(tmpBuf);
	/* WNC-MR0000-JOE-PENG-20120330-for popup error alert */
	return;

ErrPopup_WlAc:
	POP_ERR_MSG(tmpBuf);
	return;
	/* WNC-MR0000-JOE-PENG-20120330-end */
}

int advanceHander(request *wp ,char *tmpBuf)
{
	char *strAuth, *strFragTh, *strRtsTh, *strBeacon, *strPreamble, *strAckTimeout;
	char *strRate, /* *strHiddenSSID, */ *strDtim, *strIapp, *strHs2, *strProtection;
	char *strTurbo, *strPower;
	char *strValue;
	char *strMc2u,*strMlcstRate;
	AUTH_TYPE_T authType;
	PREAMBLE_T preamble;
	int val;

    
#ifdef STA_CONTROL
    int stactrl_prefer_band;
    int stactrl_enable;
#endif

#ifdef WIFI_SIMPLE_CONFIG
	memset(&wps_config_info, 0, sizeof(struct wps_config_info_struct));
	wps_config_info.caller_id = CALLED_FROM_ADVANCEHANDLER;
	apmib_get(MIB_WLAN_AUTH_TYPE, (void *)&wps_config_info.shared_type);
#endif

	strAuth = req_get_cstream_var(wp, ("authType"), "");
	if (strAuth[0]) {
		if ( !strcmp(strAuth, ("open")))
			authType = AUTH_OPEN;
		else if ( !strcmp(strAuth, ("shared")))
			authType = AUTH_SHARED;
		else if ( !strcmp(strAuth, ("both")))
			authType = AUTH_BOTH;
		else {
			strcpy(tmpBuf, ("Error! Invalid authentication value."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_WLAN_AUTH_TYPE, (void *)&authType) == 0) {
			strcpy(tmpBuf, ("Set authentication failed!"));
			goto setErr_advance;
		}
	}
	strFragTh = req_get_cstream_var(wp, ("fragThreshold"), "");
	if (strFragTh[0]) {
		if ( !string_to_dec(strFragTh, &val) || val<256 || val>2346) {
			strcpy(tmpBuf, ("Error! Invalid value of fragment threshold."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_WLAN_FRAG_THRESHOLD, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set fragment threshold failed!"));
			goto setErr_advance;
		}
	}
	strRtsTh = req_get_cstream_var(wp, ("rtsThreshold"), "");
	if (strRtsTh[0]) {
		if ( !string_to_dec(strRtsTh, &val) || val<0 || val>2347) {
			strcpy(tmpBuf, ("Error! Invalid value of RTS threshold."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_WLAN_RTS_THRESHOLD, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set RTS threshold failed!"));
			goto setErr_advance;
		}
	}

	strBeacon = req_get_cstream_var(wp, ("beaconInterval"), "");
	if (strBeacon[0]) {
		if ( !string_to_dec(strBeacon, &val) || val<20 || val>1024) {
			strcpy(tmpBuf, ("Error! Invalid value of Beacon Interval."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_WLAN_BEACON_INTERVAL, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set Beacon interval failed!"));
			goto setErr_advance;
		}
	}

	strAckTimeout = req_get_cstream_var(wp, ("ackTimeout"), "");
	if (strAckTimeout[0]) {
		if ( !string_to_dec(strAckTimeout, &val) || val<0 || val>255) {
			strcpy(tmpBuf, ("Error! Invalid value of Ack timeout."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_WLAN_ACK_TIMEOUT, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set Ack timeout failed!"));
			goto setErr_advance;
		}
	}
#if 0
	// set tx rate
	strRate = req_get_cstream_var(wp, ("txRate"), "");
	if ( strRate[0] ) {
		if ( strRate[0] == '0' ) { // auto
			val = 1;
			if ( apmib_set(MIB_WLAN_RATE_ADAPTIVE_ENABLED, (void *)&val) == 0) {
				strcpy(tmpBuf, ("Set rate adaptive failed!"));
				goto setErr_advance;
			}
		}
		else  {
			val = 0;
			if ( apmib_set(MIB_WLAN_RATE_ADAPTIVE_ENABLED, (void *)&val) == 0) {
				strcpy(tmpBuf, ("Set rate adaptive failed!"));
				goto setErr_advance;
			}  
			val = atoi(strRate);
			val = 1 << (val-1);
			if ( apmib_set(MIB_WLAN_FIX_RATE, (void *)&val) == 0) {
				strcpy(tmpBuf, ("Set fix rate failed!"));
				goto setErr_advance;
			}
			strRate = req_get_cstream_var(wp, ("basicrates"), "");
			if ( strRate[0] ) {
				val = atoi(strRate);
				if ( apmib_set(MIB_WLAN_BASIC_RATES, (void *)&val) == 0) {
					strcpy(tmpBuf, ("Set Tx basic rate failed!"));
					goto setErr_advance;
				}
			}

			strRate = req_get_cstream_var(wp, ("operrates"), "");
			if ( strRate[0] ) {
				val = atoi(strRate);
				if ( apmib_set(MIB_WLAN_SUPPORTED_RATES, (void *)&val) == 0) {
					strcpy(tmpBuf, ("Set Tx operation rate failed!"));
					goto setErr_advance;
				}
			}	
		}
	}
#endif
	val = 0;
	strRate = req_get_cstream_var(wp, ("operRate1M"), "");
	if (strRate==NULL || strRate[0]==0)
		goto skip_rate_setting;
	if ( !strcmp(strRate, ("1M")))
		val |= TX_RATE_1M;
	strRate = req_get_cstream_var(wp, ("operRate2M"), "");
	if ( !strcmp(strRate, ("2M")))
		val |= TX_RATE_2M;
	strRate = req_get_cstream_var(wp, ("operRate5M"), "");
	if ( !strcmp(strRate, ("5M")))
		val |= TX_RATE_5M;
	strRate = req_get_cstream_var(wp, ("operRate11M"), "");
	if ( !strcmp(strRate, ("11M")))
		val |= TX_RATE_11M;
	strRate = req_get_cstream_var(wp, ("operRate6M"), "");
	if ( !strcmp(strRate, ("6M")))
		val |= TX_RATE_6M;
	strRate = req_get_cstream_var(wp, ("operRate9M"), "");
	if ( !strcmp(strRate, ("9M")))
		val |= TX_RATE_9M;
	strRate = req_get_cstream_var(wp, ("operRate12M"), "");
	if ( !strcmp(strRate, ("12M")))
		val |= TX_RATE_12M;
	strRate = req_get_cstream_var(wp, ("operRate18M"), "");
	if ( !strcmp(strRate, ("18M")))
		val |= TX_RATE_18M;			
	strRate = req_get_cstream_var(wp, ("operRate24M"), "");
	if ( !strcmp(strRate, ("24M")))
		val |= TX_RATE_24M;			
	strRate = req_get_cstream_var(wp, ("operRate36M"), "");
	if ( !strcmp(strRate, ("36M")))
		val |= TX_RATE_36M;			
	strRate = req_get_cstream_var(wp, ("operRate48M"), "");
	if ( !strcmp(strRate, ("48M")))
		val |= TX_RATE_48M;			
	strRate = req_get_cstream_var(wp, ("operRate54M"), "");
	if ( !strcmp(strRate, ("54M")))
		val |= TX_RATE_54M;
	if ( apmib_set(MIB_WLAN_SUPPORTED_RATES, (void *)&val) == 0) {
		strcpy(tmpBuf, ("Set Tx operation rate failed!"));
		goto setErr_advance;
	}

	// set basic tx rate
	val = 0;
	strRate = req_get_cstream_var(wp, ("basicRate1M"), "");
	if (strRate==NULL || strRate[0]==0)
		goto skip_rate_setting;	
	if ( !strcmp(strRate, ("1M")))
		val |= TX_RATE_1M;
	strRate = req_get_cstream_var(wp, ("basicRate2M"), "");
	if ( !strcmp(strRate, ("2M")))
		val |= TX_RATE_2M;
	strRate = req_get_cstream_var(wp, ("basicRate5M"), "");
	if ( !strcmp(strRate, ("5M")))
		val |= TX_RATE_5M;
	strRate = req_get_cstream_var(wp, ("basicRate11M"), "");
	if ( !strcmp(strRate, ("11M")))
		val |= TX_RATE_11M;
	strRate = req_get_cstream_var(wp, ("basicRate6M"), "");
	if ( !strcmp(strRate, ("6M")))
		val |= TX_RATE_6M;
	strRate = req_get_cstream_var(wp, ("basicRate9M"), "");
	if ( !strcmp(strRate, ("9M")))
		val |= TX_RATE_9M;
	strRate = req_get_cstream_var(wp, ("basicRate12M"), "");
	if ( !strcmp(strRate, ("12M")))
		val |= TX_RATE_12M;
	strRate = req_get_cstream_var(wp, ("basicRate18M"), "");
	if ( !strcmp(strRate, ("18M")))
		val |= TX_RATE_18M;			
	strRate = req_get_cstream_var(wp, ("basicRate24M"), "");
	if ( !strcmp(strRate, ("24M")))
		val |= TX_RATE_24M;			
	strRate = req_get_cstream_var(wp, ("basicRate36M"), "");
	if ( !strcmp(strRate, ("36M")))
		val |= TX_RATE_36M;			
	strRate = req_get_cstream_var(wp, ("basicRate48M"), "");
	if ( !strcmp(strRate, ("48M")))
		val |= TX_RATE_48M;			
	strRate = req_get_cstream_var(wp, ("basicRate54M"), "");
	if ( !strcmp(strRate, ("54M")))
		val |= TX_RATE_54M;			
	if ( apmib_set(MIB_WLAN_BASIC_RATES, (void *)&val) == 0) {
		strcpy(tmpBuf, ("Set Tx basic rate failed!"));
		goto setErr_advance;
	}		
skip_rate_setting:
	// set preamble
	strPreamble = req_get_cstream_var(wp, ("preamble"), "");
	if (strPreamble[0]) {
		if (!strcmp(strPreamble, ("long")))
			preamble = LONG_PREAMBLE;
		else if (!strcmp(strPreamble, ("short")))
			preamble = SHORT_PREAMBLE;
		else {
			strcpy(tmpBuf, ("Error! Invalid Preamble value."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_WLAN_PREAMBLE_TYPE, (void *)&preamble) == 0) {
			strcpy(tmpBuf, ("Set Preamble failed!"));
			goto setErr_advance;
		}
	}
//move to basic setting page
#if 0
	// set hidden SSID
	strHiddenSSID = req_get_cstream_var(wp, ("hiddenSSID"), "");
	if (strHiddenSSID[0]) {
		if (!strcmp(strHiddenSSID, ("no")))
			val = 0;
		else if (!strcmp(strHiddenSSID, ("yes")))
			val = 1;
		else {
			strcpy(tmpBuf, ("Error! Invalid hiddenSSID value."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_WLAN_HIDDEN_SSID, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set hidden ssid failed!"));
			goto setErr_advance;
		}
	}
#endif
	strDtim = req_get_cstream_var(wp, ("dtimPeriod"), "");
	if (strDtim[0]) {
		if ( !string_to_dec(strDtim, &val) || val<1 || val>255) {
			strcpy(tmpBuf, ("Error! Invalid value of DTIM period."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_WLAN_DTIM_PERIOD, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set DTIM period failed!"));
			goto setErr_advance;
		}
	}

	strIapp = req_get_cstream_var(wp, ("iapp"), "");
	if (strIapp[0]) {
		if (!strcmp(strIapp, ("no")))
			val = 1;
		else if (!strcmp(strIapp, ("yes")))
			val = 0;
		else {
			strcpy(tmpBuf, ("Error! Invalid IAPP value."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_WLAN_IAPP_DISABLED, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set MIB_WLAN_IAPP_DISABLED failed!"));
			goto setErr_advance;
		}
	}
#ifdef WLAN_HS2_CONFIG	

	strHs2 = req_get_cstream_var(wp, ("hs2"), "");
	if (strHs2[0]) {
		if (!strcmp(strHs2, ("no")))
			val = 0;
		else if (!strcmp(strHs2, ("yes")))
			val = 1;
		else {
			strcpy(tmpBuf, ("Error! Invalid HS2 value."));
			goto setErr_advance;
		}
		
		if ( apmib_set(MIB_WLAN_HS2_ENABLE, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set MIB_WLAN_HS2_ENABLED failed!"));
			goto setErr_advance;
		}
	}
#endif			

	strProtection= req_get_cstream_var(wp, ("11g_protection"), "");
	if (strProtection[0]) {
		if (!strcmp(strProtection, ("no")))
			val = 1;
		else if (!strcmp(strProtection, ("yes")))
			val = 0;
		else {
			strcpy(tmpBuf, ("Error! Invalid 11g Protection value."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_WLAN_PROTECTION_DISABLED, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set MIB_WLAN_PROTECTION_DISABLED failed!"));
			goto setErr_advance;
		}
	}
#if 0	
// for WMM move to basic setting

	strProtection= req_get_cstream_var(wp, ("wmm"), "");
	if (strProtection[0]) {
		if (!strcmp(strProtection, ("on")))
			val = 1;
		else if (!strcmp(strProtection, ("off")))
			val = 0;
		else {
			strcpy(tmpBuf, ("Error! Invalid WMM value."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_WLAN_WMM_ENABLED, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set MIB_WLAN_WMM_ENABLED failed!"));
			goto setErr_advance;
		}
	}
#endif	
	strTurbo = req_get_cstream_var(wp, ("turbo"), "");
	if (strTurbo[0]) {
		if (!strcmp(strTurbo, ("off")))
			val = 2;
		else if (!strcmp(strTurbo, ("always")))
			val = 1;
		else if (!strcmp(strTurbo, ("auto")))
			val = 0;
		else {
			strcpy(tmpBuf, ("Error! Invalid turbo mode value."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_WLAN_TURBO_MODE, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set MIB_WLAN_TURBO_MODE failed!"));
			goto setErr_advance;
		}
	}

	strPower= req_get_cstream_var(wp, ("RFPower"), "");
	if (strPower[0]) {		
		if (!strcmp(strPower, ("0")))
			val = 0;
		else if (!strcmp(strPower, ("1")))
			val = 1;
		else if (!strcmp(strPower, ("2")))
			val = 2;
		else if (!strcmp(strPower, ("3")))
			val = 3;
		else if (!strcmp(strPower, ("4")))
			val = 4;
		/* NMR1774-20161212-Fix bug 1774  [Aero] The wireless power item is wrong when rf power scale 25% or 12.5% is selected-start */
		else if (!strcmp(strPower, ("5")))
			val = 5;
		else if (!strcmp(strPower, ("6")))
			val = 6;
		/* NMR1774-20161212-Fix bug 1774  [Aero] The wireless power item is wrong when rf power scale 25% or 12.5% is selected-end */
		else {
			strcpy(tmpBuf, ("Error! Invalid RF output power value."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_WLAN_RFPOWER_SCALE, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set MIB_WLAN_RFPOWER_SCALE failed!"));
			goto setErr_advance;
		}
	}

// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-06-09: Add TV mode #BEGIN
	strValue= req_get_cstream_var(wp, ("tvmode"), "");
	if (strValue[0]) {
		val = atoi(strValue);		
		if ( apmib_set(MIB_WLAN_TVMODE_SUPPORT, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set MIB_WLAN_TVMODE_SUPPORT failed!"));
			goto setErr_advance;
		}
	}
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-06-09: Add TV mode #END

// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-06-10: Add Multicast control #BEGIN
	strValue= req_get_cstream_var(wp, ("MCforward"), "");
	if (strValue[0]) {
		val = atoi(strValue);		
		if ( apmib_set(MIB_WLAN_MC_FORWARD_TYPE, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set MIB_WLAN_MC_FORWARD_TYPE failed!"));
			goto setErr_advance;
		}
	}

	strValue= req_get_cstream_var(wp, ("MCrate"), "");
	if (strValue[0]) {
		val = atoi(strValue);		
		if ( apmib_set(MIB_WLAN_LOWEST_MLCST_RATE, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set MIB_WLAN_LOWEST_MLCST_RATE failed!"));
			goto setErr_advance;
		}
	}
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-06-10: Add Multicast control #END
	
#if 0
// for 11N
	strProtection= req_get_cstream_var(wp, ("channelBond0"), "");
	if (strProtection[0]) {
		if ( strProtection[0] == '0')
			val = 0;
		else if (strProtection[0] == '1')
			val = 1;
		else {
			strcpy(tmpBuf, ("Error! Invalid Channel Bonding."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_WLAN_CHANNEL_BONDING, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set MIB_WLAN_CHANNEL_BONDING failed!"));
			goto setErr_advance;
		}
	}

	strProtection= req_get_cstream_var(wp, ("sideBand0"), "");
	if (strProtection[0]) {
		if ( strProtection[0] == '0')
			val = 0;
		else if ( strProtection[0] == '1')
			val = 1;
		else {
			strcpy(tmpBuf, ("Error! Invalid Control SideBand."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_WLAN_CONTROL_SIDEBAND, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set MIB_WLAN_CONTROL_SIDEBAND failed!"));
			goto setErr_advance;
		}
	}
#endif	
	strProtection= req_get_cstream_var(wp, ("aggregation"), "");
	if (strProtection[0]) {
		if (!strcmp(strProtection, ("disable")))
			val = DISABLED;	// GANTOE & epopen: DISABLED=0 original is DISABLE=0, Because conflict with ../../auth/include/1x_common.h in AP/net-snmp-5.x.x
		else
		{/* NMR0000-[Aero]-20161011-patch: fmwlan-3411b.c-start */
			apmib_get(MIB_WLAN_PHY_BAND_SELECT, (void *)&val);	
			if(val == PHYBAND_2G)
				val = A_MPDU;
			else if(val == PHYBAND_5G)
#if defined(SUPPORT_TX_AMSDU)
				val = A_MIXED;
#else
				val = A_MPDU;
#endif
			else				
				val = A_MIXED;	
		}/* NMR0000-[Aero]-20161011-patch: fmwlan-3411b.c-end */

		if ( apmib_set(MIB_WLAN_AGGREGATION, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set MIB_WLAN_AGGREGATION failed!"));
			goto setErr_advance;
		}
	}
	strValue = req_get_cstream_var(wp, ("block_relay"), "");
		if (strValue[0]) {
			if (!strcmp(strValue, ("enable")))
				val = 1;
			else
				val = 0;			
			apmib_set(MIB_WLAN_BLOCK_RELAY, (void *)&val);
		}
	strProtection= req_get_cstream_var(wp, ("shortGI0"), "");
	if (strProtection[0]) {
		if (!strcmp(strProtection, ("on")))
			val = 1;
		else if (!strcmp(strProtection, ("off")))
			val = 0;
		else {
			strcpy(tmpBuf, ("Error! Invalid short GI."));
			goto setErr_advance;
		}
		if ( apmib_set(MIB_WLAN_SHORT_GI, (void *)&val) == 0) {
			strcpy(tmpBuf, ("Set MIB_WLAN_SHORT_GI failed!"));
			goto setErr_advance;
		}
	}

	strValue = req_get_cstream_var(wp, ("tx_stbc"), "");
		if (strValue[0]) {
			if (!strcmp(strValue, ("enable")))
				val = 1;
			else
				val = 0;	
			apmib_set(MIB_WLAN_STBC_ENABLED, (void *)&val);	
		}
		else
		{		
			int chipVersion = getWLAN_ChipVersion();
			if(chipVersion == 1)
			{
				val = 0;	
				apmib_set(MIB_WLAN_STBC_ENABLED, (void *)&val);	
			}


		}

	strValue = req_get_cstream_var(wp, ("tx_ldpc"), "");
		if (strValue[0]) {
			if (!strcmp(strValue, ("enable")))
				val = 1;
			else
				val = 0;	
			apmib_set(MIB_WLAN_LDPC_ENABLED, (void *)&val);	
		}
		else
		{		
			int chipVersion = getWLAN_ChipVersion();
			if(chipVersion == 1)
			{
				val = 0;	
				apmib_set(MIB_WLAN_LDPC_ENABLED, (void *)&val);	
			}
		}
		
	strValue = req_get_cstream_var(wp, ("coexist_"), "");
		if (strValue[0]) {
			if (!strcmp(strValue, ("enable")))
				val = 1;
			else
				val = 0;	
			apmib_set(MIB_WLAN_COEXIST_ENABLED, (void *)&val);	
		}
#ifdef TDLS_SUPPORT
	strValue = req_get_cstream_var(wp, ("tdls_prohibited_"), "");
		unsigned char tdls_prohibited;
		if (strValue[0]) {
			if (!strcmp(strValue, ("enable"))){
				val = 1;
				tdls_prohibited = true;
			}
			else {
				val = 0;
				tdls_prohibited = false;
			}
			apmib_set(MIB_WLAN_TDLS_PROHIBITED, (void *)&val);	
		}
	strValue = req_get_cstream_var(wp, ("tdls_cs_prohibited_"), "");
		if (strValue[0]) {
			if (!strcmp(strValue, ("enable")) && (tdls_prohibited== false))
				val = 1;
			else
				val = 0;	
			apmib_set(MIB_WLAN_TDLS_CS_PROHIBITED, (void *)&val);	
		}
#endif
#ifdef CONFIG_IEEE80211V
				strValue = req_get_cstream_var(wp, ("80211v_enable_"), "");
				if (!strcmp(strValue, ("enable")))
					val = 1;
				else
					val = 0;	
				apmib_set(MIB_WLAN_DOT11V_ENABLE, (void *)&val);  
#endif

#ifdef DOT11K
        strValue = req_get_cstream_var(wp, ("dot11k_"), "");
		if (!strcmp(strValue, ("enable")))
			val = 1;
		else
			val = 0;	
        apmib_set(MIB_WLAN_DOT11K_ENABLE, (void *)&val);  
#endif
        
#ifdef STA_CONTROL
        if(wlan_idx == 0) {
            strValue = req_get_cstream_var(wp, ("staControlEnabled"), "");
            if (strValue[0]) {
                stactrl_enable = 1;                    
            }
            else {
                stactrl_enable = 0;    
            }   
            apmib_set(MIB_WLAN_STACTRL_ENABLE, (void *)&stactrl_enable);  

            strValue = req_get_cstream_var(wp, ("staControlPrefer"), "");
            if (strValue[0]) {
                if (!strcmp(strValue, ("0")))
                    stactrl_prefer_band = 1;
                else
                    stactrl_prefer_band = 0;    
                apmib_set(MIB_WLAN_STACTRL_PREFER, (void *)&stactrl_prefer_band);  
            }

            wlan_idx = 1; /*set 2G setting*/
            apmib_set(MIB_WLAN_STACTRL_ENABLE, (void *)&stactrl_enable);

            stactrl_prefer_band = stactrl_prefer_band?0:1;
            apmib_set(MIB_WLAN_STACTRL_PREFER, (void *)&stactrl_prefer_band); 
            wlan_idx = 0;
        }
        
#endif
#ifdef FAST_BSS_TRANSITION	//new version
		strValue = req_get_cstream_var(wp, ("80211r_enable_"), "");
		if (strValue[0]) {
			if (!strcmp(strValue, ("enable")))
				val = 1;	
			else 
				val = 0;
			
			apmib_set(MIB_WLAN_FT_ENABLE, (void *)&val);	
		}
		strValue = req_get_cstream_var(wp, ("ft_over_ds_"), "");
		if (strValue[0]) {
			if (!strcmp(strValue, ("enable")))
				val = 1;	
			else 
				val = 0;
			
			apmib_set(MIB_WLAN_FT_OVER_DS, (void *)&val);	
		}
#endif
		//### add by sen_liu 2011.3.29 TX Beamforming update to mib in 92D 
		strValue = req_get_cstream_var(wp, ("beamforming_"), "");
		if (strValue[0]) {
			if (!strcmp(strValue, ("enable")))
				val = 1;
			else
				val = 0;	
			apmib_set(MIB_WLAN_TX_BEAMFORMING, (void *)&val);	
		}
		strValue = req_get_cstream_var(wp, ("txbf_mu_"), "");
		if (strValue[0]) {
			if (!strcmp(strValue, ("enable")))
				val = 1;
			else
				val = 0;	
			apmib_set(MIB_WLAN_TXBF_MU, (void *)&val);	
		}
		//### end
	strMc2u= req_get_cstream_var(wp, ("mc2u_"), "");
		if (strValue[0]) {
			if (!strcmp(strMc2u, ("enable")))
				val = 0;
			else
				val = 1;	
			apmib_set(MIB_WLAN_MC2U_DISABLED, (void *)&val);	
		}
	strMlcstRate = req_get_cstream_var(wp, "mlcstrate", "");
	if ( strMlcstRate[0] ) {
		if ( strMlcstRate[0] == '0' ) { // auto
			val = 0;	 
		}
		else  {
			val = 0; 
			val = atoi(strMlcstRate);

			if(val<30)
			val = 1 << (val-1);
			else
				val = ((1<<31) + (val -30));
		}
		apmib_set(MIB_WLAN_LOWEST_MLCST_RATE, (void *)&val);
	}
#ifdef WIFI_SIMPLE_CONFIG
	update_wps_configured(1);
#endif

	return 0;
setErr_advance:
	return -1 ;		
}	
/////////////////////////////////////////////////////////////////////////////
void formAdvanceSetup(request *wp, char *path, char *query)
{

	char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};
	char *submitUrl;

	if(advanceHander(wp ,tmpBuf) < 0)
		goto setErr_end;
	apmib_update_web(CURRENT_SETTING);

#ifndef NO_ACTION
	run_init_script("bridge");
#endif

	submitUrl = req_get_cstream_var(wp, ("submit-url"), "");   // hidden page

//	send_redirect_perm(wp, submitUrl);
	OK_MSG(submitUrl);
  	return;

setErr_end:
	ERR_MSG(tmpBuf);
}

void set_11ac_txrate(WLAN_STA_INFO_Tp pInfo,char* txrate)
{
	char channelWidth=0;//20M 0,40M 1,80M 2
	char shortGi=0;
	char rate_idx=pInfo->txOperaRates-0xA0;
	if(!txrate)return;
/*
	TX_USE_40M_MODE		= BIT(0),
	TX_USE_SHORT_GI		= BIT(1),
	TX_USE_80M_MODE		= BIT(2)
*/
	if(pInfo->ht_info & 0x4)
		channelWidth=2;
	else if(pInfo->ht_info & 0x1)
		channelWidth=1;
	else
		channelWidth=0;
	if(pInfo->ht_info & 0x2)
		shortGi=1;

	sprintf(txrate, "%d", VHT_MCS_DATA_RATE[channelWidth][shortGi][rate_idx]>>1);
}
/////////////////////////////////////////////////////////////////////////////
int wirelessClientList(request *wp, int argc, char **argv)
{
	int nBytesSent=0, i, found=0;
	WLAN_STA_INFO_Tp pInfo;
	char *buff;
	char mode_buf[20];
	char txrate[20];
	int rateid=0;

	buff = calloc(1, sizeof(WLAN_STA_INFO_T) * (MAX_STA_NUM+1));
	if ( buff == 0 ) {
		printf("Allocate buffer failed!\n");
		return 0;
	}

#ifdef MBSSID
	char Root_WLAN_IF[20];

	if (argc == 2) {
		int virtual_index;
		char virtual_name[20];
		strcpy(Root_WLAN_IF, WLAN_IF);
		virtual_index = atoi(argv[argc-1]) - 1;

#ifdef CONFIG_RTL8196B_GW_8M
		if (virtual_index > 0)
			return 0;
#endif
				
		sprintf(virtual_name, "-va%d", virtual_index);
		strcat(WLAN_IF, virtual_name);
	}
#endif

	if ( getWlStaInfo(WLAN_IF,  (WLAN_STA_INFO_Tp)buff ) < 0 ) {
		printf("Read wlan sta info failed!\n");

#ifdef MBSSID
		if (argc == 2)
			strcpy(WLAN_IF, Root_WLAN_IF);
#endif
		return 0;
	}

#ifdef MBSSID
	if (argc == 2)
		strcpy(WLAN_IF, Root_WLAN_IF);
#endif

	for (i=1; i<=MAX_STA_NUM; i++) {
		pInfo = (WLAN_STA_INFO_Tp)&buff[i*sizeof(WLAN_STA_INFO_T)];
		if (pInfo->aid && (pInfo->flag & STA_INFO_FLAG_ASOC)) {
			
		if(pInfo->network& BAND_5G_11AC)
			sprintf(mode_buf, "%s", (" 11ac"));
		else if(pInfo->network & BAND_11N)
			sprintf(mode_buf, "%s", (" 11n"));
		else if (pInfo->network & BAND_11G)
			sprintf(mode_buf,"%s",  (" 11g"));	
		else if (pInfo->network & BAND_11B)
			sprintf(mode_buf, "%s", (" 11b"));
		else if (pInfo->network& BAND_11A)
			sprintf(mode_buf, "%s", (" 11a"));	
		else
			sprintf(mode_buf, "%s", (" ---"));	
		
	
		if(pInfo->txOperaRates >= 0xA0) {
			//sprintf(txrate, "%d", pInfo->acTxOperaRate); 
			set_11ac_txrate(pInfo, txrate);
		} else if((pInfo->txOperaRates & 0x80) != 0x80){	
			if(pInfo->txOperaRates%2){
				sprintf(txrate, "%d%s",pInfo->txOperaRates/2, ".5"); 
			}else{
				sprintf(txrate, "%d",pInfo->txOperaRates/2); 
			}
		}else{
			if((pInfo->ht_info & 0x1)==0){ //20M
				if((pInfo->ht_info & 0x2)==0){//long
					for(rateid=0; rateid<16;rateid++){
						if(rate_11n_table_20M_LONG[rateid].id == pInfo->txOperaRates){
							sprintf(txrate, "%s", rate_11n_table_20M_LONG[rateid].rate);
							break;
						}
					}
				}else if((pInfo->ht_info & 0x2)==0x2){//short
					for(rateid=0; rateid<16;rateid++){
						if(rate_11n_table_20M_SHORT[rateid].id == pInfo->txOperaRates){
							sprintf(txrate, "%s", rate_11n_table_20M_SHORT[rateid].rate);
							break;
						}
					}
				}
			}else if((pInfo->ht_info & 0x1)==0x1){//40M
				if((pInfo->ht_info & 0x2)==0){//long
					
					for(rateid=0; rateid<16;rateid++){
						if(rate_11n_table_40M_LONG[rateid].id == pInfo->txOperaRates){
							sprintf(txrate, "%s", rate_11n_table_40M_LONG[rateid].rate);
							break;
						}
					}
				}else if((pInfo->ht_info & 0x2)==0x2){//short
					for(rateid=0; rateid<16;rateid++){
						if(rate_11n_table_40M_SHORT[rateid].id == pInfo->txOperaRates){
							sprintf(txrate, "%s", rate_11n_table_40M_SHORT[rateid].rate);
							break;
						}
					}
				}
			}
			
		}	
			nBytesSent += req_format_write(wp,	
	   		("<tr class=\"tbl_body\"><td><font size=2>%02x:%02x:%02x:%02x:%02x:%02x</td>"
			"<td><font size=2>%s</td>"
			"<td><font size=2>%d</td>"
	     		"<td><font size=2>%d</td>"
			"<td><font size=2>%s</td>"
			"<td><font size=2>%s</td>"
			"<td><font size=2>%d</td>"		
			"</tr>"),
			pInfo->addr[0],pInfo->addr[1],pInfo->addr[2],pInfo->addr[3],pInfo->addr[4],pInfo->addr[5],
			mode_buf,
			pInfo->tx_packets, pInfo->rx_packets,
			txrate,
			( (pInfo->flag & STA_INFO_FLAG_ASLEEP) ? "yes" : "no"),
			pInfo->expired_time/100
			);
			found++;
		}
	}
	if (found == 0) {
		nBytesSent += req_format_write(wp,
	   		("<tr class=\"tbl_body\"><td><font size=2>None</td>"
			"<td><font size=2>---</td>"
	     		"<td><font size=2>---</td>"
			"<td><font size=2>---</td>"
			"<td><font size=2>---</td>"
			"<td><font size=2>---</td>"
			"<td><font size=2>---</td>"
			"</tr>"));
	}

	free(buff);

	return nBytesSent;
}

/////////////////////////////////////////////////////////////////////////////
void formWirelessTbl(request *wp, char *path, char *query)
{
	char *submitUrl;

	submitUrl = req_get_cstream_var(wp, ("submit-url"), "");
	if (submitUrl[0])
		send_redirect_perm(wp, submitUrl);
}

/////////////////////////////////////////////////////////////////////////////
#ifdef MBSSID
void formWlanMultipleAP(request *wp, char *path, char *query)
{
	char *strVal, *submitUrl;
	int idx, disabled, old_vwlan_idx, band_no, val;
    int repeater_enabled=0;
    int valTmp=0;
	char varName[20];
	char redirectUrl[200];

    //displayPostDate(wp->post_data);	

	old_vwlan_idx = vwlan_idx;


     SDEBUG("wlan_idx=[%d]\n",wlan_idx);
     SDEBUG("vwlan_idx=[%d]\n",vwlan_idx);

#ifdef RTL_MULTI_REPEATER_MODE_SUPPORT         
    sprintf(varName, "switch_multi_repeater");
    strVal= req_get_cstream_var(wp, varName, "");
    if ( !strcmp(strVal, "ON")){
        
        repeater_enabled = 2;


        /*let root  interface under AP mode ; need make sure vwlan_idx==0*/ 
        valTmp=AP_MODE;
        apmib_set(MIB_WLAN_MODE, (void *)&valTmp);          // set to 0     (AP mode)
        apmib_set(MIB_WLAN_WLAN_DISABLED, (void *)&valTmp);  // set to 0   (disabled is false)    
        /*let root  interface under AP mode ; need make sure vwlan_idx==0*/ 

		valTmp = 0; // disable AP Profile
        if(wlan_idx == 0) {
			apmib_set(MIB_PROFILE_ENABLED1, (void *)&valTmp);
		} else {
			apmib_set(MIB_PROFILE_ENABLED2, (void *)&valTmp);
		}

        /*let vxd interface be disabled*/ 
        
        vwlan_idx = NUM_VWLAN_INTERFACE; 
        valTmp=1;
        apmib_set(MIB_WLAN_WLAN_DISABLED, (void *)&valTmp);  // set to 1   (disabled is tue)            
         SDEBUG("set vxd (vwlan_idx=[%d]) wlan disabled to true\n",vwlan_idx);        
        /*let vxd interface be disabled*/         


        for (idx=1; idx<=4; idx++) {
            vwlan_idx = idx; 
            if(idx==1)
                valTmp=AP_MODE;
            if(idx==2||idx==3)
                valTmp=CLIENT_MODE;            
    		apmib_set(MIB_WLAN_MODE, (void *)&valTmp);        

#ifdef RTL_MULTI_CLONE_SUPPORT    
            // let wlanx-va1; wlanx-va2 default enabled its macclone
            if(idx==2 || idx==3){
                valTmp=1;
                apmib_set(MIB_WLAN_MACCLONE_ENABLED, (void *)&valTmp);  // set to 1   (disabled is tue)            
            }
#endif
            /*let  4 th vap interface be disabled*/                     
            if(idx==4){
                valTmp=1;
                apmib_set(MIB_WLAN_WLAN_DISABLED, (void *)&valTmp);  // set to 1   (disabled is tue)            
            }
        }        
        
    }
    else{
        repeater_enabled = 0;   
        for (idx=1; idx<=3; idx++) {
            vwlan_idx = idx; 
            valTmp=AP_MODE;
    		apmib_set(MIB_WLAN_MODE, (void *)&valTmp);        
        }
    }

    /*let vxd interface be disabled*/ 
    if(wlan_idx==0){
        apmib_set(MIB_REPEATER_ENABLED1, (void *)&repeater_enabled);
        SDEBUG("MIB_REPEATER_ENABLED1 mode set to [%d]\n",repeater_enabled);
    }else{
        apmib_set(MIB_REPEATER_ENABLED2, (void *)&repeater_enabled);
        SDEBUG("MIB_REPEATER_ENABLED2 mode set to [%d]\n",repeater_enabled);

    }            
#endif        

	for (idx=1; idx<=4; idx++) {
		vwlan_idx = idx;		

		sprintf(varName, "wl_disable%d", idx);		
		strVal = req_get_cstream_var(wp, varName, "");
		if ( !strcmp(strVal, "ON"))
			disabled = 0;
		else
			disabled = 1;	
		apmib_set(MIB_WLAN_WLAN_DISABLED, (void *)&disabled);

		if (disabled)
			continue;

		sprintf(varName, "wl_band%d", idx);
		strVal = req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140916, Fix bug 2642 (UNINIT) in StaticCodeCheck_Linear_Delta1.xls
			//int wlan_onoff_tkip;
			int wlan_onoff_tkip = 0;
			band_no = strtol( strVal, (char **)NULL, 10);
			val = (band_no + 1);
			apmib_get( MIB_WLAN_11N_ONOFF_TKIP, (void *)&wlan_onoff_tkip);
				
			if(wlan_onoff_tkip == 0) //Wifi request
			{
				//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140916, Fix bug 2641, 2643 (UNINIT) in StaticCodeCheck_Linear_Delta1.xls
				//int wpaCipher;
				//int wpa2Cipher;
				int wpaCipher = 0;
				int wpa2Cipher = 0;
				int wlan_encrypt=0;
				
				apmib_get( MIB_WLAN_ENCRYPT, (void *)&wlan_encrypt);
				apmib_get(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&wpaCipher);
				apmib_get(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&wpa2Cipher);
				
				if( band_no == 7 || band_no == 9 || band_no == 10 || band_no == 11|| band_no == 63 || band_no == 71 || band_no == 75) //7:n; 9:gn; 10:bgn 11:5g_an
				{
					
					if(wlan_encrypt ==ENCRYPT_WPA || wlan_encrypt ==ENCRYPT_WPA2){
						wpaCipher &= ~WPA_CIPHER_TKIP;
							if(wpaCipher== 0)
								wpaCipher =  WPA_CIPHER_AES;
						apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&wpaCipher);
						
						wpa2Cipher &= ~WPA_CIPHER_TKIP;
							if(wpa2Cipher== 0)
								wpa2Cipher =  WPA_CIPHER_AES;
						apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&wpa2Cipher);
					}
					
				}		
			}
		
	
			apmib_set(MIB_WLAN_BAND, (void *)&val);
		}

		sprintf(varName, "wl_ssid%d", idx);
		strVal = req_get_cstream_var(wp, varName, "");
		if (strVal[0]) 
			apmib_set( MIB_WLAN_SSID, (void *)strVal);			
	
		sprintf(varName, "TxRate%d", idx);
		strVal = req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			if ( strVal[0] == '0' ) { // auto
				val = 1;
				apmib_set(MIB_WLAN_RATE_ADAPTIVE_ENABLED, (void *)&val);
			}
			else  {
				val = 0;
				apmib_set(MIB_WLAN_RATE_ADAPTIVE_ENABLED, (void *)&val);
				val = atoi(strVal);
				
				if(val<30)
				val = 1 << (val-1);
				else
					val = ((1<<31) + (val -30));				

				apmib_set(MIB_WLAN_FIX_RATE, (void *)&val);
			}
		}

		sprintf(varName, "wl_hide_ssid%d", idx);
		strVal = req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			if ( strVal[0] == '0')
				val = 0;
			else 
				val = 1;
			apmib_set(MIB_WLAN_HIDDEN_SSID, (void *)&val);
		}
	
		sprintf(varName, "wl_wmm_capable%d", idx);
		strVal= req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			if ( strVal[0] == '0')
				val = 0;
			else 
				val = 1;
			apmib_set(MIB_WLAN_WMM_ENABLED, (void *)&val);
		}
		else {	//enable wmm in 11N mode always
			int cur_band=0; //WNC-NMR0000-Rita-20130310-Error_542-fix warnings of cppcheck (uninitialized value).
			apmib_get(MIB_WLAN_BAND, (void *)&cur_band);
			if(cur_band == 10 || cur_band ==11) {
				val = 1;
				apmib_set(MIB_WLAN_WMM_ENABLED, (void *)&val);
			}
		}

		sprintf(varName, "wl_access%d", idx);
		strVal= req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			if ( strVal[0] == '0')
				val = 0;
			else 
				val = 1;
			apmib_set(MIB_WLAN_ACCESS, (void *)&val);
		}

		sprintf(varName, "tx_restrict%d", idx);
		strVal= req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			val = atoi(strVal);
			apmib_set(MIB_WLAN_TX_RESTRICT, (void *)&val);
		}

		sprintf(varName, "rx_restrict%d", idx);
		strVal= req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			val = atoi(strVal);
			apmib_set(MIB_WLAN_RX_RESTRICT, (void *)&val);
		}
		
		// force basic and support rate to zero to let driver set default
		val = 0;
		apmib_set(MIB_WLAN_BASIC_RATES, (void *)&val);		
		apmib_set(MIB_WLAN_SUPPORTED_RATES, (void *)&val);
		
		vwlan_idx = old_vwlan_idx;		
	}

	vwlan_idx = old_vwlan_idx;

	apmib_update_web(CURRENT_SETTING);

#ifndef NO_ACTION
	run_init_script("bridge");
#endif

	submitUrl = req_get_cstream_var(wp, ("submit-url"), ""); 
	
	memset(redirectUrl,0x00,sizeof(redirectUrl));
	sprintf(redirectUrl,"/boafrm/formWlanRedirect?redirect-url=%s&wlan_id=%d",submitUrl,wlan_idx);
	
	OK_MSG(redirectUrl);
}
#endif

/////////////////////////////////////////////////////////////////////////////
void formWlSiteSurvey(request *wp, char *path, char *query)
{
    char *submitUrl, *refresh, *connect, *strSel, *strVal;
	int status, idx, encrypt=0;//WNC-NMR0000-Rita-20130310-Error_622-fix warnings of cppcheck (uninitialized value).
    BssDscr *pBss=NULL;
	//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140916, Fix bug 2684 (UNINIT) in StaticCodeCheck_Linear_Delta1.xls
	//char ssidbuf[33];
    char ssidbuf[33] = {0};
    int k;
#ifdef CONFIG_RTL_802_1X_CLIENT_SUPPORT
    int wpaPSK;	// For wpa/wpa2
#endif
    unsigned char res, *pMsg=NULL;
    int wait_time, max_wait_time=5;
    char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};
#if defined(WLAN_PROFILE)
	int profile_enabled_id, profileEnabledVal, oriProfileEnabledVal=0; //WNC-NMR0000-Rita-20130310-Error_550,Error_625-fix warnings of cppcheck (uninitialized value).
#endif
    int isWizard=0;
#ifdef CONFIG_RTK_MESH 
    int mesh_enable = 0; 
    int mesh_connect = 0;
    WLAN_MODE_T mode;
    if ( !apmib_get( MIB_WLAN_MODE, (void *)&mode) ) {
        goto ss_err; 
    }

    if(mode == AP_MESH_MODE || mode == MESH_MODE) {
        if( !apmib_get( MIB_WLAN_MESH_ENABLE, (void *)&mesh_enable) ) {
            goto ss_err; 
        }
    }    

    if(mesh_enable) {
        strVal = req_get_cstream_var(wp, "select_type", "");
        if(strVal[0]) {
            if(strcmp(strVal, "mesh") == 0)
            {
                mesh_connect = 1;
            }
        }
    }
#endif 

	int vxd_wisp_wan=0;
	char wlanifp_bak[32];

//displayPostDate(wp->post_data);



	submitUrl = req_get_cstream_var(wp, ("submit-url"), "");

	refresh = req_get_cstream_var(wp, ("refresh"), "");
	if ( refresh[0] ) {
		// issue scan request
		wait_time = 0;
		while (1) {
			strVal = req_get_cstream_var(wp, ("ifname"), "");
			if(strVal[0])
			{
				sprintf(WLAN_IF,"%s",strVal);				
			}
			 
			// ==== modified by GANTOE for site survey 2008/12/26 ==== 
			switch(getWlSiteSurveyRequest(WLAN_IF, &status)) 
			{ 
				case -2: 
					printf("Auto scan running!!\n"); 
					strcpy(tmpBuf, ("Auto scan running!!please wait...")); 
					//goto ss_err; 
					break; 
				case -1: 
					printf("Site-survey request failed!\n"); 
					strcpy(tmpBuf, ("Site-survey request failed!")); 
					//goto ss_err; 
					break; 
				default: 
					break; 
			} 
			// ==== GANTOE ====
/*
			if ( getWlSiteSurveyRequest(WLAN_IF,  &status) < 0 ) {
				strcpy(tmpBuf, ("Site-survey request failed!"));
				goto ss_err;
			}
*/
			if (status != 0) {	// not ready
				if (wait_time++ > 15) {
					strcpy(tmpBuf, ("scan request timeout!"));
					goto ss_err;
				}
#ifdef	CONFIG_RTK_MESH
		// ==== modified by GANTOE for site survey 2008/12/26 ==== 
				usleep(1000000 + (rand() % 2000000));
#else
				sleep(1);
#endif
			}
			else
				break;
		}

		// wait until scan completely
		wait_time = 0;
		while (1) {
			res = 1;	// only request request status
			if ( getWlSiteSurveyResult(WLAN_IF, (SS_STATUS_Tp)&res) < 0 ) {
				strcpy(tmpBuf, ("Read site-survey status failed!"));
				free(pStatus);
				pStatus = NULL;
				goto ss_err;
			}
			if (res == 0xff) {   // in progress
			#if (defined(CONFIG_RTL_92D_SUPPORT) && defined (CONFIG_POCKET_ROUTER_SUPPORT)) || defined(CONFIG_RTL_DFS_SUPPORT)
				/*prolong wait time due to scan both 2.4G and 5G */
				if (wait_time++ > 20) 
			#else
				if (wait_time++ > 20) 
			#endif		
			{
					strcpy(tmpBuf, ("scan timeout!"));
					free(pStatus);
					pStatus = NULL;
					goto ss_err;
				}
				sleep(1);
			}
			else
				break;
		}

		if (submitUrl[0])
			send_redirect_perm(wp, submitUrl);

		return;
	}

    connect = req_get_cstream_var(wp, ("connect"), "");
    if ( connect[0] ) 
    {
        char *wlanifp, *strSSID;
        int rptEnabled=0;
        int wlan_mode=0;
        int wlanvxd_mode=0;
        char *strChannel;
        int channelIdx;

#if defined(WLAN_PROFILE)
        /* disable wireless profile first */
        if(wlan_idx == 0)
        {
            profile_enabled_id = MIB_PROFILE_ENABLED1;
        }
        else
        {
            profile_enabled_id = MIB_PROFILE_ENABLED2;
        }
        profileEnabledVal = 0;

        apmib_get(profile_enabled_id, (void *)&oriProfileEnabledVal);

        //printf("\r\n oriProfileEnabledVal=[%d],__[%s-%u]\r\n",oriProfileEnabledVal,__FILE__,__LINE__);

        apmib_set(profile_enabled_id, (void *)&profileEnabledVal);

#endif //#if defined(WLAN_PROFILE)


#ifdef CONFIG_RTK_MESH 		
        if(mesh_connect == 0) 
#endif
        {
#if 1//defined(CONFIG_RTL_ULINKER)
            if(wlan_idx == 0)
                apmib_get(MIB_REPEATER_ENABLED1, (void *)&rptEnabled);
            else
                apmib_get(MIB_REPEATER_ENABLED2, (void *)&rptEnabled);
#endif

#if 1//defined(CONFIG_SMART_REPEATER)
            int opmode=0;
            apmib_get(MIB_WLAN_MODE, (void *)&wlan_mode);
            apmib_get(MIB_OP_MODE, (void *)&opmode);

            if((rptEnabled == 1) && 
               (wlan_mode == AP_MODE || wlan_mode == AP_WDS_MODE || wlan_mode == AP_MESH_MODE || wlan_mode == MESH_MODE)            
               //&&(opmode == WISP_MODE) 
            )
            {
                vxd_wisp_wan = 1;
            }
#endif
        }

#if defined(CONFIG_RTL_92D_SUPPORT)		
		int phyBand;
		int i;
		unsigned char wlanIfStr[10];
		int band2g5gselect=0;
		apmib_get(MIB_WLAN_BAND2G5G_SELECT, (void *)&band2g5gselect);
		if(band2g5gselect != BANDMODEBOTH)
		{
			for(i=0 ; i<NUM_WLAN_INTERFACE ; i++)
			{
				unsigned char wlanif[10];
				memset(wlanif,0x00,sizeof(wlanif));
				sprintf(wlanif, "wlan%d",i);
				if(SetWlan_idx(wlanif))
				{
					int intVal = 1;
					apmib_set(MIB_WLAN_WLAN_DISABLED, (void *)&intVal);
					
				}						
			}
		
			strChannel = req_get_cstream_var(wp, ("pocket_channel"), "");
			
			if(strChannel[0])
			{
				short wlanif;
				
				
				channelIdx = atoi(strChannel);
				
				if(channelIdx > 14) // connect to 5g AP
					phyBand = PHYBAND_5G;
				else
					phyBand = PHYBAND_2G;
					
				wlanif = whichWlanIfIs(phyBand);
				
				memset(wlanIfStr,0x00,sizeof(wlanIfStr));		
				sprintf(wlanIfStr, "wlan%d",wlanif);
			
				if(SetWlan_idx(wlanIfStr))
				{
					int val;
					val = 0;
					apmib_set(MIB_WLAN_WLAN_DISABLED, (void *)&val);												
					
					apmib_get(MIB_WLAN_MODE, (void *)&wlan_mode);
																
#if defined(CONFIG_RTL_ULINKER)						
					if(wlan_mode != CLIENT_MODE && wlan_mode != WDS_MODE && rptEnabled == 1)
						;
					else
#endif
						wlan_mode = CLIENT_MODE;
						
					apmib_set(MIB_WLAN_MODE, (void *)&wlan_mode);												
				}
			
				/* we can't up wlan1 alone, so we swap wlan0 and wlan1 settings */
				if(wlanif != 0)
				{
					/* WNC-NMR000-[Linear]-Libera-20140919-coverity-error-864-NEGATIVE_RETURNS-start */
					if (wlanif < 0){
						printf("[error]:wlanif no match! File: %s, Func: %s, Line: %d @@\n", __FILE__,__FUNCTION__ , __LINE__);
						goto ss_err;
					}
					/* WNC-NMR000-[Linear]-Libera-20140919-coverity-error-864-NEGATIVE_RETURNS-end */
					
					if(wlanif < NUM_WLAN_INTERFACE)	/* WNC-NMR000-[Linear]-Libera-20140919-coverity-error-1116-OVERRUN */				
						swapWlanMibSetting(0,wlanif);
					else
						printf("[Error] Not support wlanif=%d, Func: %s, Line: %d\n",wlanif,__FUNCTION__ , __LINE__);	/* WNC-NMR000-[Linear]-Libera-20140919-coverity-error-1116-OVERRUN */
						
				}					
			}
		
		}
		
		
#endif //#if defined(CONFIG_RTL_92D_SUPPORT)
		
		wlanifp = req_get_cstream_var(wp, ("wlanif"), "");
		/* WNC-NMR2423-Libera-20170614- avoid reboot with system cmd by hacker-start */
		if (check_invalid_char(wlanifp) == 0) {
			printf("\r\n[Warning] with invalid char: wlanifp=[%s],__[%s-%u]\r\n",wlanifp,__FILE__,__LINE__);
			send_redirect_perm(wp, LW_GUI_INPUT_ERR_PAGE);
			return;
		}
		/* WNC-NMR2423-Libera-20170614- avoid reboot with system cmd by hacker-end */		
//printf("\r\n ++++++++++++wlanifp=[%s],__[%s-%u]\r\n",wlanifp,__FILE__,__LINE__);
#if defined(CONFIG_RTL_ULINKER)
		//in ulinker project, we save settings to root interface, than clone to rpt interface
#else
		if(vxd_wisp_wan== 1)
		{
			sprintf(wlanifp_bak, "%s", wlanifp);
			sprintf(wlanifp, "%s-vxd", wlanifp_bak);
		}		
#endif
		
		SetWlan_idx(wlanifp);
		
#ifdef CONFIG_RTK_MESH 		
        if(mesh_connect == 0) 
#endif
        {                
            strSSID = req_get_cstream_var(wp, ("pocketAP_ssid"), "");	
            //strSSID is BSSID, below transfer it to SSID. This fix the issue of AP ssid contains "		
            for (k=0; k<pStatus->number && pStatus->number!=0xff; k++) 
            {
                pBss = &pStatus->bssdb[k];
                snprintf(tmpBuf, 200, ("%02x:%02x:%02x:%02x:%02x:%02x"),
                    pBss->bdBssId[0], pBss->bdBssId[1], pBss->bdBssId[2],
                    pBss->bdBssId[3], pBss->bdBssId[4], pBss->bdBssId[5]);

                if(strcmp(strSSID, tmpBuf)==0)
                {
                    memcpy(ssidbuf, pBss->bdSsIdBuf, pBss->bdSsId.Length);
                    ssidbuf[pBss->bdSsId.Length] = '\0';	
                    break;
                }		
            }
            apmib_set(MIB_WLAN_SSID, (void *)ssidbuf);


#if 1//def CONFIG_SMART_REPEATER
            if(vxd_wisp_wan== 1) {
                if(wlan_idx == 0)
                    apmib_set(MIB_REPEATER_SSID1, (void *)ssidbuf);
                else
                    apmib_set(MIB_REPEATER_SSID2, (void *)ssidbuf);
            }
#endif


        }
        apmib_update(CURRENT_SETTING);

#if defined(CONFIG_RTL_ULINKER)								
		strChannel = req_get_cstream_var(wp, ("pocket_channel"), "");
			
		if(strChannel[0])
		{
			channelIdx = atoi(strChannel);
			if(wlan_mode != CLIENT_MODE && wlan_mode != WDS_MODE && rptEnabled == 1)
			{
				apmib_set( MIB_WLAN_CHANNEL,  (void *)&channelIdx);
			}
		}						
#endif		
						
		strSel = req_get_cstream_var(wp, ("select"), "");
		if (strSel[0]) {
			unsigned char res;
			NETWORK_TYPE_T net;
			int chan;

			if (pStatus == NULL) {
				strcpy(tmpBuf, ("Please refresh again!"));
				goto ss_err;

			}
			sscanf(strSel, "sel%d", &idx);

			/* WNC-NMR000-[Linear]-Libera-20140919-coverity-error-1125- OVERRUN-start */
			if (idx > 64){
				strcpy(tmpBuf, ("idx > MAX_BSS_DESC(64)!"));
				goto ss_err;
			}
			/* WNC-NMR000-[Linear]-Libera-20140919-coverity-error-1125- OVERRUN-end */
			
			if ( idx >= pStatus->number ) { // invalid index
				strcpy(tmpBuf, ("Connect failed 1!"));
				goto ss_err;
			}
#ifdef CONFIG_RTK_MESH 
            if(mesh_connect) 
            { 
                int i;
                unsigned char original_mesh_id[MESHID_LEN];
                int original_channel = 0;
                int original_offset = 0;

                int offset;
                status = 1;
                // backup related info. 
                if ( !apmib_get( MIB_WLAN_CHANNEL,  (void *)&original_channel) ) {
                    goto ss_err;
                }

                if ( !apmib_get( MIB_WLAN_CONTROL_SIDEBAND,  (void *)&original_offset) ) {
                    goto ss_err;
                }


                if(apmib_get(MIB_WLAN_MESH_ID, (void*)original_mesh_id) == 0)
                {
                    strcpy(tmpBuf, ("get MIB_WLAN_MESH_ID error!"));
                    goto ss_err;
                }

                pMsg = "Connect failed 2!!";



                if ((pStatus->bssdb[idx].bdTstamp[1] & 0x06) == 0x06)
                    offset = 1;/*HT_2NDCH_OFFSET_BELOW;*/
                else if ((pStatus->bssdb[idx].bdTstamp[1]  & 0x06) == 0x02)
                    offset = 2;/*HT_2NDCH_OFFSET_ABOVE;*/
                else {                                 
                    offset = 0;/*HT_2NDCH_OFFSET_DONTCARE;*/
                }


                if(!setWlJoinMesh(WLAN_IF, pStatus->bssdb[idx].bdMeshIdBuf - 2, pStatus->bssdb[idx].bdMeshId.Length, pStatus->bssdb[idx].ChannelNumber, offset)) // the problem of padding still exists 
                { 
                    // check whether the link has established
                    for(i = 0; i < 10; i++)	// This block might be removed when the mesh peerlink precedure has been completed
                    {
                        if(!getWlMeshLink(WLAN_IF, pStatus->bssdb[idx].bdBssId, 6))
                        {
                            char tmp[MESHID_LEN]; 
                            int channel; 
                            memcpy(tmp, pStatus->bssdb[idx].bdMeshIdBuf - 2, pStatus->bssdb[idx].bdMeshId.Length); // the problem of padding still exists 
                            tmp[pStatus->bssdb[idx].bdMeshId.Length] = '\0'; 
                            if ( apmib_set(MIB_WLAN_MESH_ID, (void *)tmp) == 0)
                            { 
                                strcpy(tmpBuf, ("Set MeshID error!")); 
                                goto ss_err; 
                            } 
                            // channel = pStatus->bssdb[idx].ChannelNumber; 
                            channel = 0; // requirement of Jason, not me 
                            if ( apmib_set(MIB_WLAN_CHANNEL, (void*)&channel) == 0)
                            { 
                                strcpy(tmpBuf, ("Set Channel error!")); 
                                goto ss_err; 
                            } 

                            if(meshWpaHandler(wp, tmpBuf, wlan_idx) < 0) {
                                strcpy(tmpBuf, ("Set WPA error!"));
                                goto ss_err;                             
                            }    

                            apmib_update_web(CURRENT_SETTING); 
                            apmib_update(CURRENT_SETTING);

#ifndef NO_ACTION
                            run_init_script("bridge");
#endif

                            pMsg = "Connect successfully!!"; 
                            status = 0;
                            break;
                        }
                        usleep(3000000);
                    }
                }
                // if failed, reset to the original channel
                if(strcmp(pMsg, "Connect successfully!!"))
                {
                    setWlJoinMesh(WLAN_IF, original_mesh_id, strlen((char *)original_mesh_id), original_channel, original_offset);
                    strcpy(tmpBuf, ("Connect failed 3!!"));
                    goto ss_err; 
                }
            } 
            else 
#endif 
			{ 
#if 1
                                unsigned char wlan_idx;
                                char *tmpStr, *wlanif;
                                char wlan_vxd_if[20];
                                char varName[20];
                                unsigned int i,val;
                                wlanif = req_get_cstream_var(wp, ("wlanif"), "");
                                //SetWlan_idx(tmpStr);
 
                                tmpStr = req_get_cstream_var(wp, ("wlan_idx"), "");
                                if(tmpStr[0])
                                        wlan_idx = atoi(tmpStr);
 
                                sprintf(varName, "method%d", wlan_idx);
 
                                tmpStr = req_get_cstream_var(wp, varName, "");
                                if(tmpStr[0])
                                {
                                        val = atoi(tmpStr);
                                        if(val == ENCRYPT_DISABLED)
                                        {
                                                ENCRYPT_T encrypt = ENCRYPT_DISABLED;
                                                apmib_set( MIB_WLAN_ENCRYPT, (void *)&encrypt);
												apmib_set( MIB_WLAN_ENABLE_1X, (void *)&encrypt);
                                        }
                                        else if(val == ENCRYPT_WEP)
                                        {
                                                if(wepHandler(wp, tmpBuf, wlan_idx) < 0)
                                                {
                                                        goto ss_err;
                                                }
                                        }
                                        else if(val > ENCRYPT_WEP && val <= ENCRYPT_WPA2_MIXED)
                                        {
                                                if(wpaHandler(wp, tmpBuf, wlan_idx) < 0)
                                                {
                                                        goto ss_err;
                                                }
                                        }
#ifdef CONFIG_RTL_WAPI_SUPPORT
						 else if(val == ENCRYPT_WAPI){
						 	if(wpaHandler(wp, tmpBuf, wlan_idx) < 0)
                                             {
                                                        goto ss_err;
                                             }
						 }
#endif
					}
#else                                
			// check encryption type match or not
			if ( !apmib_get( MIB_WLAN_ENCRYPT, (void *)&encrypt) ) {
				strcpy(tmpBuf, ("Check encryption error!"));
				goto ss_err;
			}
			else {
				// no encryption
				if (encrypt == ENCRYPT_DISABLED)
				{
					if (pStatus->bssdb[idx].bdCap & 0x00000010) {
						strcpy(tmpBuf, ("Encryption type mismatch!"));
						goto ss_err;
					}
					else
						; // success
				}
				// legacy encryption
				else if (encrypt == ENCRYPT_WEP)
				{
					if ((pStatus->bssdb[idx].bdCap & 0x00000010) == 0) {
						strcpy(tmpBuf, ("Encryption type mismatch!"));
						goto ss_err;
					}
					else if (pStatus->bssdb[idx].bdTstamp[0] != 0) {
						strcpy(tmpBuf, ("Encryption type mismatch!"));
						goto ss_err;
					}
					else
						; // success
				}
#if defined(CONFIG_RTL_WAPI_SUPPORT)
				else if (encrypt == ENCRYPT_WAPI)
				{
					if ((pStatus->bssdb[idx].bdCap & 0x00000010) == 0) {
						strcpy(tmpBuf, ("Encryption type mismatch!"));
						goto ss_err;
					}
					else if (pStatus->bssdb[idx].bdTstamp[0] != SECURITY_INFO_WAPI) {
						strcpy(tmpBuf, ("Encryption type mismatch!"));
						goto ss_err;
					}
					else
						; // success
				}
#endif
				// WPA/WPA2
				else
				{
					int isPSK, auth;
					apmib_get(MIB_WLAN_WPA_AUTH, (void *)&auth);
					if (auth == WPA_AUTH_PSK)
						isPSK = 1;
					else
						isPSK = 0;					
								
#ifdef CONFIG_RTL_802_1X_CLIENT_SUPPORT
					wpaPSK=isPSK;
#endif
								
					if ((pStatus->bssdb[idx].bdCap & 0x00000010) == 0) {
						strcpy(tmpBuf, ("Encryption type mismatch!"));
						goto ss_err;
					}
					else if (pStatus->bssdb[idx].bdTstamp[0] == 0) {
						strcpy(tmpBuf, ("Encryption type mismatch!"));
						goto ss_err;
					}
					else if (encrypt == ENCRYPT_WPA) {
						if (((pStatus->bssdb[idx].bdTstamp[0] & 0x0000ffff) == 0) || 
								(isPSK && !(pStatus->bssdb[idx].bdTstamp[0] & 0x4000)) ||
								(!isPSK && (pStatus->bssdb[idx].bdTstamp[0] & 0x4000)) ) {						
						strcpy(tmpBuf, ("Encryption type mismatch!"));
						goto ss_err;
					}
					}
					else if (encrypt == ENCRYPT_WPA2) {
						if (((pStatus->bssdb[idx].bdTstamp[0] & 0xffff0000) == 0) ||
								(isPSK && !(pStatus->bssdb[idx].bdTstamp[0] & 0x40000000)) ||
								(!isPSK && (pStatus->bssdb[idx].bdTstamp[0] & 0x40000000)) ) {
							strcpy(tmpBuf, ("Encryption type mismatch!"));
							goto ss_err;
						}
					}	
					else
						; // success
				}
			}
#endif

#if 0
			// Set SSID, network type to MIB
			memcpy(tmpBuf, pStatus->bssdb[idx].bdSsIdBuf, pStatus->bssdb[idx].bdSsId.Length);
			tmpBuf[pStatus->bssdb[idx].bdSsId.Length] = '\0';
			
			memset(tmpBuf,0x00,sizeof(tmpBuf));
			
			tmpStr = req_get_cstream_var(wp, ("pocketAP_ssid"), "");
			if(tmpStr[0])
				sprintf(tmpBuf,"%s",tmpStr);
			
//printf("\r\n tmpBuf=[%s],__[%s-%u]\r\n",tmpBuf,__FILE__,__LINE__);
			
			if ( apmib_set(MIB_WLAN_SSID, (void *)tmpBuf) == 0) {
				strcpy(tmpBuf, ("Set SSID error!"));
				goto ss_err;
			}
#endif

			if ( pStatus->bssdb[idx].bdCap & cESS )
				net = INFRASTRUCTURE;
			else
				net = ADHOC;
			
			if ( apmib_set(MIB_WLAN_NETWORK_TYPE, (void *)&net) == 0) {
				strcpy(tmpBuf, ("Set MIB_WLAN_NETWORK_TYPE failed!"));
				goto ss_err;
			}

			if (net == ADHOC) {
				chan = pStatus->bssdb[idx].ChannelNumber;
				if ( apmib_set( MIB_WLAN_CHANNEL, (void *)&chan) == 0) {
   					strcpy(tmpBuf, ("Set channel number error!"));
					goto ss_err;
				}
				int is_40m_bw ;// = (pStatus->bssdb[idx].bdTstamp[1] & 2) ? 1 : 0;
				if(pStatus->bssdb[idx].bdTstamp[1] & 64)
					is_40m_bw = 2;
				else if(pStatus->bssdb[idx].bdTstamp[1] & 2)
					is_40m_bw = 1;
				else
					is_40m_bw = 0;				
				apmib_set(MIB_WLAN_CHANNEL_BONDING, (void *)&is_40m_bw);				
			} else if (vxd_wisp_wan) {

                #ifdef CONFIG_RTK_MESH /*in mesh mode, keep the original channel*/
                if(mode != AP_MESH_MODE && mode != MESH_MODE) 
                #endif    
                {
    				//switch to flash of root interface
    				SetWlan_idx(wlanif);
    				chan = pStatus->bssdb[idx].ChannelNumber;
    				if ( apmib_set( MIB_WLAN_CHANNEL, (void *)&chan) == 0) {
    					strcpy(tmpBuf, ("Set channel number error!"));
    					goto ss_err;
    				}
				int sideband;
				apmib_get( MIB_WLAN_CONTROL_SIDEBAND, (void *)&sideband);
				if ((chan<=4 && sideband==0) || (chan>=10 && sideband==1)){
					sideband = ((sideband + 1) & 0x1);
                                     	apmib_set( MIB_WLAN_CONTROL_SIDEBAND, (void *)&sideband);
				 }
    				//switch back to flash of vxd interface
    				SetWlan_idx(wlanifp);
                }
			}

#if defined(CONFIG_RTL_ULINKER) //repeater mode: clone wlan setting to wlan-vxd and modify wlan ssid

		if(wlan_mode != CLIENT_MODE && wlan_mode != WDS_MODE && rptEnabled == 1)
		{
			int isUpnpEnabled=0;
			int ori_vwlan_idx = vwlan_idx;
			char ssidBuf[64];
			
			
			vwlan_idx = NUM_VWLAN_INTERFACE;
			
			
			/* get original setting in vxd interface */
			apmib_get(MIB_WLAN_WSC_UPNP_ENABLED, (void *)&isUpnpEnabled);
			apmib_get(MIB_WLAN_MODE, (void *)&wlanvxd_mode);
			
									
			ulinker_wlan_mib_copy(&pMib->wlan[wlan_idx][NUM_VWLAN_INTERFACE], &pMib->wlan[wlan_idx][0]);
			
			/* restore original setting in vxd interface and repeater ssid*/			
			apmib_set(MIB_WLAN_WSC_UPNP_ENABLED, (void *)&isUpnpEnabled);
			apmib_set(MIB_WLAN_MODE, (void *)&wlanvxd_mode);
			
			vwlan_idx = ori_vwlan_idx;
			
			/* add "-ext" at last of wlan ssid */
			apmib_get( MIB_WLAN_SSID,  (void *)ssidBuf);

			if(wlan_idx == 0)
				apmib_set(MIB_REPEATER_SSID1, (void *)&ssidBuf);
			else
				apmib_set(MIB_REPEATER_SSID2, (void *)&ssidBuf);

			
			if(strlen(ssidBuf)<sizeof(ssidBuf)+4)
			{
				strcat(ssidBuf,"-ext");
				apmib_set( MIB_WLAN_SSID,  (void *)ssidBuf);
				apmib_set( MIB_WLAN_WSC_SSID, (void *)ssidBuf);
			}
		}
#endif


			apmib_update_web(CURRENT_SETTING);

#if 1 //reinit wlan interface and mib
                        char command[50];
#if 1//def CONFIG_SMART_REPEATER
						if(vxd_wisp_wan){
							sprintf(command,"ifconfig %s-vxd down",wlanif);
                        	system(command);
                        }
#endif
                        sprintf(command,"ifconfig %s down",wlanif);
                        system(command);
                        sprintf(command,"flash set_mib %s",wlanif);
                        system(command);
                        sprintf(command,"ifconfig %s up",wlanif);
                        system(command);
#if 1//def CONFIG_SMART_REPEATER
						if(vxd_wisp_wan){
							sprintf(command,"flash set_mib %s-vxd",wlanif);                      
	                        system(command);
							sprintf(command,"ifconfig %s-vxd up",wlanif);
	                        system(command);
                        }
#endif                        
					
					
		#if defined(CONFIG_RTL_ULINKER)
			run_init_script_flag = 1;
		#else
			 // wlan0 entering forwarding state need some time
			sleep(3);

			_Start_Wlan_Applications();
		#endif
#endif

			res = idx;
			wait_time = 0;

#if 0	//Because reinit wlan app above, so don't need wlJoinRequest here.
			while (1) {
				if ( getWlJoinRequest(WLAN_IF, &pStatus->bssdb[idx], &res) < 0 ) {
					strcpy(tmpBuf, ("Join request failed!"));
					goto ss_err;
				}
				if ( res == 1 ) { // wait
				#if defined (CONFIG_RTL_92D_SUPPORT)  && defined (CONFIG_POCKET_ROUTER_SUPPORT)
					/*prolong join wait time for pocket ap*/
					if (wait_time++ > 10) 
				#else
					if (wait_time++ > 5) 
				#endif
					{
						strcpy(tmpBuf, ("connect-request timeout!"));
						goto ss_err;
					}
					sleep(1);
					continue;
				}
				break;
			}

			if ( res == 2 ) // invalid index
				pMsg = "Connect failed 3!";
			else 
			{
				wait_time = 0;
				while (1) {
					if ( getWlJoinResult(WLAN_IF, &res) < 0 ) {
						strcpy(tmpBuf, ("Get Join result failed!"));
						goto ss_err;
					}
					if ( res != 0xff ) { // completed
					

						break;
					}
					else
					{
						if (wait_time++ > 10) {
							strcpy(tmpBuf, ("connect timeout!"));
							goto ss_err;
						}
					}
					sleep(1);
				}

				if ( res!=STATE_Bss && res!=STATE_Ibss_Idle && res!=STATE_Ibss_Active )
					pMsg = "Connect failed 4!";
				else {					
					status = 0;
					
					apmib_get( MIB_WLAN_ENCRYPT, (void *)&encrypt);
					
					//if (encrypt == ENCRYPT_WPA || encrypt == ENCRYPT_WPA2) {
					if (encrypt == ENCRYPT_WPA || encrypt == ENCRYPT_WPA2 || encrypt == ENCRYPT_WAPI) {
						bss_info bss;
						wait_time = 0;
						
						max_wait_time=10;	//Need more test, especially for 802.1x client mode
						
						while (wait_time++ < max_wait_time) {
							getWlBssInfo(WLAN_IF, &bss);
							if (bss.state == STATE_CONNECTED){
								break;
							}
							sleep(1);
						}
						if (wait_time > max_wait_time)						
							status = 1;
					}

					if (status)
						pMsg = "Connect failed 5!";
					else
						pMsg = "Connect successfully!";
				}
			}
#else
			{
				wait_time = 0;
			#if defined(CONFIG_RTL_ULINKER)
				max_wait_time = 80;
			#else
				max_wait_time = 30;
			#endif
				while (1) 
					{

#if 1//def CONFIG_SMART_REPEATER

			
						if(vxd_wisp_wan && !strstr(WLAN_IF,"-vxd"))
							strcat(WLAN_IF,"-vxd");
						
#endif

						if ( getWlJoinResult(WLAN_IF, &res) < 0 ) {
							strcpy(tmpBuf, ("Get Join result failed!"));
							goto ss_err;
						}

					if(res==STATE_Bss  || res==STATE_Ibss_Idle || res==STATE_Ibss_Active) { // completed 
						break;
					}
					else
					{
						if (wait_time++ > max_wait_time) {
							strcpy(tmpBuf, ("connect timeout!"));
							goto ss_err;
						}
					}
					sleep(1);
				}

				if ( res!=STATE_Bss && res!=STATE_Ibss_Idle && res!=STATE_Ibss_Active )
					pMsg = (unsigned char *)"Connect failed 4!";
				else {					
					status = 0;
					
					apmib_get( MIB_WLAN_ENCRYPT, (void *)&encrypt);
					
					//if (encrypt == ENCRYPT_WPA || encrypt == ENCRYPT_WPA2) {
					if (encrypt == ENCRYPT_WPA || encrypt == ENCRYPT_WPA2 || encrypt == ENCRYPT_WPA2_MIXED || encrypt == ENCRYPT_WAPI) {
						bss_info bss;
						wait_time = 0;
						
				#if defined(CONFIG_RTL_ULINKER)
						max_wait_time = 80;
				#else
						max_wait_time=15;	//Need more test, especially for 802.1x client mode
				#endif
						while (wait_time++ < max_wait_time) {
							getWlBssInfo(WLAN_IF, &bss);
							if (bss.state == STATE_CONNECTED){
								break;
							}
							sleep(1);
						}
						if (wait_time > max_wait_time)						
							status = 1; //fail
					}

					if (status)
						pMsg =  (unsigned char *)"connect timeout!";//"Connect failed 5!";//Input negative AES password can trigger here
					else
						pMsg =  (unsigned char *)"Connect successfully!";

				}
			}
#endif
		}


#if defined(WLAN_PROFILE)
		/* disable wireless profile first */
		if(wlan_idx == 0)
		{
			profile_enabled_id = MIB_PROFILE_ENABLED1;
		}
		else
		{
			profile_enabled_id = MIB_PROFILE_ENABLED2;
		}

//printf("\r\n wlan_idx=[%d],__[%s-%u]\r\n",wlan_idx,__FILE__,__LINE__);
//printf("\r\n profile_enabled_id=[%d],__[%s-%u]\r\n",profile_enabled_id,__FILE__,__LINE__);
//printf("\r\n oriProfileEnabledVal=[%d],__[%s-%u]\r\n",oriProfileEnabledVal,__FILE__,__LINE__);
		apmib_set(profile_enabled_id, (void *)&oriProfileEnabledVal);

		apmib_update_web(CURRENT_SETTING);

#endif //#if defined(WLAN_PROFILE)


#if defined(CONFIG_POCKET_AP_SUPPORT)  
			if(!status)
			{
				pMsg = "Connect successfully! Please wait while rebooting.";
				OK_MSG1(pMsg, submitUrl);
				sleep(2);
				system("reboot");
			} 
#elif defined(CONFIG_POCKET_ROUTER_SUPPORT)// || defined(CONFIG_RTL_ULINKER)
			{
#ifndef NO_ACTION
				run_init_script("all");
#endif
				REBOOT_WAIT("/wizard.htm");
				//REBOOT_WAIT("/wlsurvey.htm");
				
			} 
#else
			{
				//RET_SURVEY_PAGE(pMsg, submitUrl, (status?0:1), wlan_idx, isWizard);
			}
#endif
		}
#if 1//defined(CONFIG_SMART_REPEATER)
		if(vxd_wisp_wan)
		{
			char*ptmp;
			SetWlan_idx(wlanifp_bak);
			ptmp=strstr(WLAN_IF,"-vxd");
			if(ptmp)
				memset(ptmp,0,sizeof(char)*strlen("-vxd"));
		}
#endif



	}
	return;

ss_err:
#if defined(WLAN_PROFILE)
	if(wlan_idx == 0)
	{
		profile_enabled_id = MIB_PROFILE_ENABLED1;
	}
	else
	{
		profile_enabled_id = MIB_PROFILE_ENABLED2;
	}

	apmib_set(profile_enabled_id, (void *)&oriProfileEnabledVal);

	apmib_update_web(CURRENT_SETTING);

#endif //#if defined(WLAN_PROFILE)

#if 1//defined(CONFIG_SMART_REPEATER)
	if(vxd_wisp_wan)
	{
		char*ptmp;
		SetWlan_idx(wlanifp_bak);
		ptmp=strstr(WLAN_IF,"-vxd");
		if(ptmp)
			memset(ptmp,0,sizeof(char)*strlen("-vxd"));
	}
#endif

	ERR_MSG(tmpBuf);
}

/////////////////////////////////////////////////////////////////////////////

/* Aero project */
void formWlWncBasic(request *wp, char *path, char *query)
{
 	char *submitUrl, *refresh, *connect, *strSel, *strVal;
	int status, idx, encrypt = 0, maintevup_reboot_flag = 0, intVal;
	unsigned char res, *pMsg=NULL;
	int wait_time, max_wait_time=5;
	char tmpBuf[100];
	int wlan_orig=0, ori_vwlan_idx=0, lan_dhcp_mode;
	int wanAddrUserDefVal = 1;
	struct in_addr inIp, inMask, inGateway, dns1, dns2;



#if 1 /* repeater mode */

	/* set WPS priority */
	strVal= req_get_cstream_var(wp, ("WPS_priority"), "");
	if (strVal[0]) {
		int orig_wlan_idx=0;
		int orig_vwlan_idx=0;
		int count1=0;
		int intVal = 0;
	
		if (!strcmp(strVal, ("5G")))
			intVal = 2;
		else if (!strcmp(strVal, ("2.4G")))
			intVal = 1;
		else {
			strcpy(tmpBuf, ("Error! Invalid WPS priority value."));
			goto ss_err;
	
		}

		orig_wlan_idx=wlan_idx;
		orig_vwlan_idx=vwlan_idx;

		/* Set WPS priority to vxd interface of each radio */
		for(count1=0;count1<NUM_WLAN_INTERFACE;count1++)
		{
			wlan_idx=count1;
			vwlan_idx = NUM_VWLAN_INTERFACE; // vxd interface
	
			apmib_set(MIB_WLAN_WSC_PRIORITY, (void *)&intVal);
		}
	
		wlan_idx=orig_wlan_idx;
		vwlan_idx=orig_vwlan_idx;
	}

	/* set 2G enabled */			
	strVal = req_get_cstream_var(wp, "wlanDisabled0", "");
	if(strVal[0]){
		int orig_wlan_idx=0;
		int orig_vwlan_idx=0;
		int intVal = 0;
	
		if ( !strcmp(strVal, "ON"))
			intVal = 1;
		else
			intVal = 0;
	
		orig_wlan_idx=wlan_idx;
		orig_vwlan_idx=vwlan_idx;
	
		/* Set Wi-Fi interface to wlan0 */
		wlan_idx = 0; //2G
		vwlan_idx = 0; 
	
		apmib_set(MIB_WLAN_WLAN_DISABLED, (void *)&intVal);
	
		wlan_idx=orig_wlan_idx;
		vwlan_idx=orig_vwlan_idx;
	}
	
	/* set 5G enabled */
	if(NUM_WLAN_INTERFACE == 2){
		strVal = req_get_cstream_var(wp, "wlanDisabled1", "");
		if(strVal[0]){
			int orig_wlan_idx=0;
			int orig_vwlan_idx=0;
			int intVal = 0;
	
			if ( !strcmp(strVal, "ON"))
				intVal = 1;
			else
				intVal = 0;
	
			orig_wlan_idx=wlan_idx;
			orig_vwlan_idx=vwlan_idx;
	
			/* Set Wi-Fi interface to wlan1 */
			wlan_idx = 1; //5G
			vwlan_idx = 0; 
	
			apmib_set(MIB_WLAN_WLAN_DISABLED, (void *)&intVal);
	
			wlan_idx=orig_wlan_idx;
			vwlan_idx=orig_vwlan_idx;
		}
	}

	/* set multi stage connection */
	strVal= req_get_cstream_var(wp, ("multiStageConnection"), "");
	if (strVal[0]) {
		int orig_wlan_idx=0;
		int orig_vwlan_idx=0;
		int count1=0;
		int intVal = 0;
	
		if (!strcmp(strVal, ("1")))
			intVal = MULTI_STAGE_CONNECTION_1;
		else if (!strcmp(strVal, ("2")))
			intVal = MULTI_STAGE_CONNECTION_2;
		else if (!strcmp(strVal, ("3")))
			intVal = MULTI_STAGE_CONNECTION_3;
		else {
			strcpy(tmpBuf, ("Error! Invalid multiStageConnection value."));
			goto ss_err;
		}
	
		orig_wlan_idx=wlan_idx;
		orig_vwlan_idx=vwlan_idx;
	
		/* Set multi stage connection to vxd interface of each radio */
		for(count1=0;count1<NUM_WLAN_INTERFACE;count1++)
		{
			int count2=0;
	
			for(count2=0;count2<NUM_VWLAN_INTERFACE+1;count2++) {
				wlan_idx = count1;
				vwlan_idx = count2;
	
				/* Multi stage of GUI setting needs to write to MIB of wlan0 (For AP side of DUT (repeater mode)) and wlan0-vxd (For Client side of DUT (repeater mode)) */
				if ((vwlan_idx==0) || (vwlan_idx==NUM_VWLAN_INTERFACE)) {
					apmib_set(MIB_WLAN_MULTI_STAGE_CONNECTION, (void *)&intVal);
				}
			}
		}
		
		wlan_idx=orig_wlan_idx;
		vwlan_idx=orig_vwlan_idx;
	}

#endif /* repeater mode */


	strVal = req_get_cstream_var(wp, ("netBIOSName"), "");

	/* WNC-NMR000-[Aero/Thalys]-MIKE-YEH-20160824-error check on server side. */
	if(lw_NullCheck(strVal) == -1 || lw_AsciiCheck(strVal) == -1)
	{
		send_redirect_perm(wp, LW_GUI_INPUT_ERR_PAGE);
		return;
	}

	if (strVal[0]) {
		if ( !apmib_set(MIB_NETBIOS_NAME, (void *)strVal)) {
  			strcpy(tmpBuf, ("Set MIB_NETBIOS_NAME MIB error!"));
			goto ss_err;
		}
	}

	/* Set DHCP mode of LAN */
	strVal = req_get_cstream_var(wp, ("dhcp"), "");
	if (strVal[0]) {
		lan_dhcp_mode = atoi(strVal);
		
		if(lan_dhcp_mode != 0 && lan_dhcp_mode != 1 && lan_dhcp_mode != 2 && lan_dhcp_mode != 15  && lan_dhcp_mode != 19){
			strcpy(tmpBuf, ("Invalid DHCP value!"));
			goto ss_err;
		}
	
		if ( !apmib_set(MIB_DHCP, (void *)&lan_dhcp_mode)) {
			strcpy(tmpBuf, ("Set DHCP error!"));
			goto ss_err;
		}


		strVal = req_get_cstream_var(wp, ("lan_ip"), "");

		/* WNC-NMR000-[Aero/Thalys]-MIKE-YEH-20160824-error check on server side. */
		if((lan_dhcp_mode == 0) && (lw_NullCheck(strVal) == -1 || lw_IPAddrCheck(strVal) == -1))
		{
			send_redirect_perm(wp, LW_GUI_INPUT_ERR_PAGE);
			return;
		}

		if ( strVal[0] ) {
			if ( !inet_aton(strVal, &inIp) ) {
				strcpy(tmpBuf, ("̵IP ɥ쥹Ǥ"));
				goto ss_err;
			}
			if ( !apmib_set( MIB_IP_ADDR, (void *)&inIp)) {
				strcpy(tmpBuf, ("Set IP-address error!"));
				goto ss_err;
			}
			if ( !apmib_set( MIB_WAN_ADDR_USER_DEF, (void *)&wanAddrUserDefVal)) {
				strcpy(tmpBuf, ("Set wan address user defined error!"));
				goto ss_err;
			}
		}

		/* WNC-NMR000-[Aero/Thalys]-MIKE-YEH-20160824-error check on server side. */
		strVal = req_get_cstream_var(wp, ("mask_bits"), "");
		
		if((lan_dhcp_mode == 0) && (lw_NullCheck(strVal) == -1 || lw_DigitalRangeCheck(strVal, 1, 32) == -1))
		{
			send_redirect_perm(wp, LW_GUI_INPUT_ERR_PAGE);
			return;
		}
	
		strVal = req_get_cstream_var(wp, ("lan_mask"), "");

		if ( strVal[0] ) {
			if ( !inet_aton(strVal, &inMask) ) {
				strcpy(tmpBuf, ("̵ʥͥåȥޥǤ"));
				goto ss_err;
			}
			if ( !apmib_set(MIB_SUBNET_MASK, (void *)&inMask)) {
				strcpy(tmpBuf, ("Set subnet-mask error!"));
				goto ss_err;
			}
		}
	
		strVal = req_get_cstream_var(wp, ("lan_gateway"), "");

		/* WNC-NMR000-[Aero/Thalys]-MIKE-YEH-20160824-error check on server side. */
		if((lan_dhcp_mode == 0) && (lw_NullCheck(strVal) == -1 || lw_IPAddrCheck(strVal) == -1))
		{
			send_redirect_perm(wp, LW_GUI_INPUT_ERR_PAGE);
			return;
		}
		
		if ( strVal[0] ) {

			/* "blank" is permitted in the set value to gateway */
			if (!strcmp(strVal, ("blank"))) {
				int blank_ip_value = 0x00000000;
			
				if ( !apmib_set(MIB_DEFAULT_GATEWAY, (void *)&blank_ip_value)) {
					strcpy(tmpBuf, "Set default-gateway error!");
					goto ss_err;
				}
			}
			else {
				if ( !inet_aton(strVal, &inGateway) ) {
					strcpy(tmpBuf, ("̵ʥȥǤ"));
					goto ss_err;
				}
				if ( !apmib_set(MIB_DEFAULT_GATEWAY, (void *)&inGateway)) {
					strcpy(tmpBuf, ("Set default-gateway error!"));
					goto ss_err;
				}
				if ( !apmib_set( MIB_WAN_GATEWAY_ADDR_USER_DEF, (void *)&wanAddrUserDefVal)) {
					strcpy(tmpBuf, ("Set wan gateway address user defined error!"));
					goto ss_err;
				}			
			}
		}
	
		strVal = req_get_cstream_var(wp, ("dns1"), "");

		/* WNC-NMR000-[Aero/Thalys]-MIKE-YEH-20160824-error check on server side. */
		if((lan_dhcp_mode == 0) && (lw_IPAddrCheck(strVal) == -1))
		{
			send_redirect_perm(wp, LW_GUI_INPUT_ERR_PAGE);
			return;
		}

		if ( strVal[0] ) {

			/* "blank" is permitted in the set value to DNS1 */
			if (!strcmp(strVal, ("blank"))) {
				int blank_ip_value = 0x00000000;
			
				if ( !apmib_set(MIB_DNS1, (void *)&blank_ip_value)) {
					strcpy(tmpBuf, "Set DNS MIB error!");
					goto ss_err;
				}
			}
			else {
				if ( !inet_aton(strVal, &dns1) ) {
					strcpy(tmpBuf, ("̵ʥץ饤ޥDNS Ǥ"));
					goto ss_err;
				}
			
				if ( !apmib_set(MIB_DNS1, (void *)&dns1)) {
					strcpy(tmpBuf, "Set DNS MIB error!");
					goto ss_err;
				}
				if ( !apmib_set( MIB_WAN_DNS_ADDR_USER_DEF, (void *)&wanAddrUserDefVal)) {
					strcpy(tmpBuf, ("Set wan gateway address user defined error!"));
					goto ss_err;
				}
			}	
		}
	
		strVal = req_get_cstream_var(wp, ("dns2"), "");

		/* WNC-NMR000-[Aero/Thalys]-MIKE-YEH-20160824-error check on server side. */
		if((lan_dhcp_mode == 0) && (lw_IPAddrCheck(strVal) == -1))
		{
			send_redirect_perm(wp, LW_GUI_INPUT_ERR_PAGE);
			return;
		}

		if ( strVal[0] ) {

			/* "blank" is permitted in the set value to DNS2 */
			if (!strcmp(strVal, ("blank"))) {
				int blank_ip_value = 0x00000000;
			
				if ( !apmib_set(MIB_DNS2, (void *)&blank_ip_value)) {
					strcpy(tmpBuf, "Set DNS MIB error!");
					goto ss_err;
				}
			}
			else {
				if ( !inet_aton(strVal, &dns2) ) {
					strcpy(tmpBuf, ("̵ʥDNS Ǥ"));
					goto ss_err;
				}
				if ( !apmib_set(MIB_DNS2, (void *)&dns2)) {
					strcpy(tmpBuf, "Set DNS MIB error!");
					goto ss_err;
				}
			}
		}
	}
	
	strVal = req_get_cstream_var(wp, ("jumbo_frame_enable"), "");
	if (strVal[0]) {
		if ( !strcmp(strVal, "ON"))
			intVal = 1;
		else
			intVal = 0;
		if ( !apmib_set(MIB_JUMBO_FRAME_STATE, (void *)&intVal)) {
			strcpy(tmpBuf, ("Set MIB_JUMBO_FRAME_STATE error!"));
			goto ss_err;
		}
	}

	strVal = req_get_cstream_var(wp, ("pause_frame_enable"), "");
	if (strVal[0]) {
		if ( !strcmp(strVal, "ON"))
			intVal = 1;
		else
			intVal = 0;
		if ( !apmib_set(MIB_PAUSE_FRAME_STATE, (void *)&intVal)) {
			strcpy(tmpBuf, ("Set MIB_PAUSE_FRAME_STATE error!"));
			goto ss_err;
		}
	}

	/* NMR2256-20170117-Implement request of bug 2256 [Aero][Request] Add one item (EEE setting) to PageID11B-start */
	strVal = req_get_cstream_var(wp, ("eeeEnabled"), "");
	if (strVal[0]) {
		if ( !strcmp(strVal, "ON"))
			intVal = 1;
		else
			intVal = 0;
		if ( !apmib_set(MIB_EEE_STATE, (void *)&intVal)) {
			strcpy(tmpBuf, ("Set MIB_EEE_STATE error!"));
			goto ss_err;
		}
	}
	/* NMR2256-20170117-Implement request of bug 2256 [Aero][Request] Add one item (EEE setting) to PageID11B-end */

	strVal = req_get_cstream_var(wp, ("srcAddrCheck"), "");
	if (strVal[0]) {
		int intVal = 0;
		
		if ( !strcmp(strVal, "ON"))
			intVal = 1;
		else
			intVal = 0;
		if ( !apmib_set(MIB_SRC_ADDR_CHECK, (void *)&intVal)) {
			strcpy(tmpBuf, ("Set MIB_SRC_ADDR_CHECK error!"));
			goto ss_err;
		}
	}

	/*  MAC ACL  */
	strVal = req_get_cstream_var(wp, ("mac_acl"), "");
	if(strVal[0]){
		int intVal = 0;
		int intVal2 = 0;

		apmib_get(MIB_CLIENT_ACL_MODE, (void *)&intVal2);
		
		if ( !strcmp(strVal, "1"))
			intVal = 1;	//MAC filter
		else
			intVal = 0;	//Accesstimer
		if ( !apmib_set(MIB_CLIENT_ACL_MODE, (void *)&intVal)) {
			strcpy(tmpBuf, ("Set MIB_CLIENT_ACL_MODE error!"));
			goto ss_err;
		}
		if (intVal != intVal2) {
			if (intVal == 1) {
				ACCESS_TIMER_T entry;
				INIQUITOUS_STA_T entry2;
				if ( !apmib_set(MIB_ACCESS_TIMER_DELALL, (void *)&entry)) {
					strcpy(tmpBuf, ("Clear Access timer error!"));
					goto ss_err;
				}
				if ( !apmib_set(MIB_INIQUITOUS_STA_DELALL, (void *)&entry2)) {
					strcpy(tmpBuf, ("Clear Iniquitous Client error!"));
					goto ss_err;
				}
				/* NMR1895-[Aero]-20161018-update NEC_MAC_ADDRESS_FILTERING_ENTRY-start */
				if ( !apmib_set(MIB_NEC_MAC_ADDRESS_FILTERING_ENTRY, (void *)&intVal)) {
					strcpy(tmpBuf, ("Clear Iniquitous Client error!"));
					goto ss_err;
				}
				/* NMR1895-[Aero]-20161018-update NEC_MAC_ADDRESS_FILTERING_ENTRY-end */
			} else {
				int i=0;
				int entryNum = 0;
				MACFILTER_T acl_entry;
				ACCESS_TIMER_T at_entry;
				
				if ( !apmib_get(MIB_WLAN_MACAC_NUM, (void *)&entryNum)) {
					strcpy(tmpBuf, ("Get mac filter table entry number error!"));
					goto ss_err;
				}

				for (i=1; i<=entryNum; i++) {
					*((char *)&acl_entry) = (char)i;
					if ( !apmib_get(MIB_WLAN_MACAC_ADDR, (void *)&acl_entry)) {
						strcpy(tmpBuf, ("Get mac filter table entry error!"));
						goto ss_err;
					}
					memset(&at_entry, 0, sizeof(ACCESS_TIMER_T));
					memcpy(at_entry.macAddr, acl_entry.macAddr, 6);
//					at_entry.category = 0;
				/*	sprintf(at_entry.name, "%.2X:%.2X:%.2X:%.2X:%.2X:%.2X",
						 at_entry.macAddr[0], at_entry.macAddr[1], at_entry.macAddr[2],
						 at_entry.macAddr[3], at_entry.macAddr[4], at_entry.macAddr[5]);*/
					snprintf(at_entry.name, sizeof(at_entry.name), "%.2X:%.2X:%.2X:%.2X:%.2X:%.2X",
						at_entry.macAddr[0], at_entry.macAddr[1], at_entry.macAddr[2],
						at_entry.macAddr[3], at_entry.macAddr[4], at_entry.macAddr[5]); //2426
					if ( !apmib_set(MIB_ACCESS_TIMER_ADD, (void *)&at_entry)) {
						strcpy(tmpBuf, ("Add access timer table entry error!"));
						goto ss_err;
					}
				}
				/* NMR1895-[Aero]-20161018-update NEC_MAC_ADDRESS_FILTERING_ENTRY-start */
				if ( !apmib_set(MIB_NEC_MAC_ADDRESS_FILTERING_ENTRY, (void *)&intVal)) {
					strcpy(tmpBuf, ("Clear Iniquitous Client error!"));
					goto ss_err;
				}
				/* NMR1895-[Aero]-20161018-update NEC_MAC_ADDRESS_FILTERING_ENTRY-end */
			}
		}
	}

	/*  LED light mode  */
	strVal = req_get_cstream_var(wp, ("led_ctl"), "");
	if(strVal[0]){
		int intVal = 0;
		
		if ( !strcmp(strVal, "1"))
			intVal = 1;
		else if ( !strcmp(strVal, "2"))
			intVal = 2;		
		else
			intVal = 0;
		if ( !apmib_set(MIB_LED_LIGHT_MODE, (void *)&intVal)) {
			strcpy(tmpBuf, ("Set MIB_LED_LIGHT_MODE error!"));
			goto ss_err;
		}
	}

	/* maintane version up */
	strVal = req_get_cstream_var(wp, ("maintevup"), "");
	if(strVal[0]){
		int intVal = 0;
		
		if ( !strcmp(strVal, "ON"))
			intVal = 1;
		else
			intVal = 0;
		if ( !apmib_set(MIB_MAINTE_VUP, (void *)&intVal)) {
			strcpy(tmpBuf, ("Set MIB_MAINTE_VUP error!"));
			goto ss_err;
		}
	}

	/* WNC-NMR1444-MIKE-YEH-20160315, The Web Spec change to PageID 11 R/C. */
	/* maintane version up reboot flag */
	strVal = req_get_cstream_var(wp, ("maintevup_reboot"), "");
	if(strVal[0]){
		int intVal = 0;
		
		if ( !strcmp(strVal, "ON"))
			maintevup_reboot_flag = 1;
		else
			maintevup_reboot_flag = 0;
	}

	/* update to flash */
	apmib_update_web(CURRENT_SETTING);

	if(maintevup_reboot_flag)
	{
		/* WNC-NMR1444-MIKE-YEH-20160315, The Web Spec change to PageID 11 R/C. */
		countdownAction = DO_REBOOT;
		send_redirect_perm(wp, "/reboot_main_finish.html");
	}
	else
	{	
		submitUrl = req_get_cstream_var(wp, ("submit-url"), "");
		OK_MSG(submitUrl);
	}
	return;

ss_err:
	ERR_MSG(tmpBuf);

}

#if 1 /* WNC-NMR0000-Jog-Lin-20151221, for site survey responsive GUI */

/* Store select SSID and encrypt method temporarily */
void formWlSelectSiteSurvey(request *wp, char *path, char *query)
{
	char *submitUrl = NULL, *tmpStr = NULL;

	submitUrl = req_get_cstream_var(wp, ("submit-url"), "");   // hidden page

	tmpStr = req_get_cstream_var(wp, ("selectSSID"), "");
	if (tmpStr[0])
	{
		memcpy(selectSSID, tmpStr, strlen(tmpStr));
	}
	
	tmpStr = req_get_cstream_var(wp, ("selectEncrypt"), "");
	if (tmpStr[0])
	{
		selectEncrypt = atoi(tmpStr);
	}

	tmpStr = req_get_cstream_var(wp, ("selectEncryptStr"), "");
	if (tmpStr[0])
	{
		memcpy(selectEncryptStr, tmpStr, strlen(tmpStr));
	}

	tmpStr = req_get_cstream_var(wp, ("selectWlanIdx"), "");
	if (tmpStr[0])
	{
		selectWlanIdx = atoi(tmpStr);
	}

	tmpStr = req_get_cstream_var(wp, ("selectChannel"), "");
	if (tmpStr[0])
	{
		selectChannel = atoi(tmpStr);
	}

	tmpStr = req_get_cstream_var(wp, ("selectBSSID"), "");
	if (tmpStr[0])
	{
		memcpy(selectBSSID, tmpStr, strlen(tmpStr));
	}

	send_redirect_perm(wp, submitUrl);
  	return;
}

#if 1	/* WNC-NMR000-[Aero/Thalys]-Libera-20160823- Server side input check-start */
int serverSide_check_wifi_sta(request *wp)
{
	char *wepKey, *pskKey;
	char *strFormat,*strEncrypt;
	char varName2[20];
	int wepFormat;
	ENCRYPT_T encrypt;
	char *strVal;
//	apmib_save_wlanIdx();
	/* check wlanx-vxd input */ 
	sprintf(varName2, "method%d", wlan_idx);
	strEncrypt = req_get_cstream_var(wp, varName2, "");
	if (!strEncrypt[0]) {
		printf("[error]Error! no encryption method.: Func: %s, Line: %d\n",__FUNCTION__ , __LINE__);
	}
	encrypt = (ENCRYPT_T) strEncrypt[0] - '0';
	
	//printf("WNC:encrypt=%d, Func: %s, Line: %d\n",encrypt,__FUNCTION__ , __LINE__);
	if (encrypt!=ENCRYPT_DISABLED && encrypt!=ENCRYPT_WEP && encrypt!=ENCRYPT_WPA
		&& encrypt != ENCRYPT_WPA2 && encrypt != ENCRYPT_WPA2_MIXED) 
	{
		printf("[error]Invalid encryption method! Func: %s, Line: %d\n",__FUNCTION__ , __LINE__);
	}
	else if(encrypt == ENCRYPT_WEP){	//select WEP option
		sprintf(varName2, "format%d", wlan_idx);
		strFormat = req_get_cstream_var(wp, varName2, "");
		if (!strFormat[0]) {
			printf("[error]Key type must exist!: Func: %s, Line: %d\n",__FUNCTION__ , __LINE__);
		}
		if (strFormat[0]!='1' && strFormat[0]!='2') {
			printf("[error]Invalid key type value!: Func: %s, Line: %d\n",__FUNCTION__ , __LINE__);
		}
		if (strFormat[0] == '1') // ascii
			wepFormat=1;
		else { // hex
			wepFormat=2;
		}
	
		sprintf(varName2, "key%d", wlan_idx);
		wepKey = req_get_cstream_var(wp, varName2, "");
		if (wepKey[0]) {
			if (lw_WEPCheck(wepKey,wepFormat)){
				//send_redirect_perm(wp, LW_GUI_INPUT_ERR_PAGE);
				return -1;
			}
		}else{
			printf("[error]:key=NULL Func: %s, Line: %d\n",__FUNCTION__ , __LINE__);
			//send_redirect_perm(wp, LW_GUI_INPUT_ERR_PAGE);
			return -1;
		}
	}
	else if (encrypt==ENCRYPT_WPA || encrypt == ENCRYPT_WPA2 || encrypt == ENCRYPT_WPA2_MIXED){ //WPA-PSK
		sprintf(varName2, "wpaAuth%d", wlan_idx);
		strVal = req_get_cstream_var(wp, varName2, "");
		if (strVal[0]) {
			if ( !strcmp(strVal, ("psk"))) {

				sprintf(varName2, "pskValue%d", wlan_idx);
				pskKey = req_get_cstream_var(wp, varName2, "");

				if (pskKey[0]) {
					if (lw_PSKCheck(pskKey)){
						printf("[error][psk]: Func: %s, Line: %d\n",__FUNCTION__ , __LINE__);
						//send_redirect_perm(wp, LW_GUI_INPUT_ERR_PAGE);
						return -1;
					}
				}else{
					printf("[error][psk]:NULL Func: %s, Line: %d\n",__FUNCTION__ , __LINE__);
					//send_redirect_perm(wp, LW_GUI_INPUT_ERR_PAGE);
					return -1;
				}
			}else{
				printf("[error][psk] not psk type!: Func: %s, Line: %d\n",__FUNCTION__ , __LINE__);
				//send_redirect_perm(wp, LW_GUI_INPUT_ERR_PAGE);
				return -1;
			}
		}
	}
//	apmib_recov_wlanIdx();
	return 0;
}
#endif	/* WNC-NMR000-[Aero/Thalys]-Libera-20160823- Server side input check-end */


void formWlSubmitSiteSurvey(request *wp, char *path, char *query)
{
 	char *submitUrl, *refresh, *connect, *strSel, *strVal = NULL;
	//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140916, Fix bug 2700 (UNINIT) in StaticCodeCheck_Linear_Delta1.xls
	int status, idx, encrypt = 0;
	unsigned char res, *pMsg=NULL;
	int wait_time, max_wait_time=5;
	char tmpBuf[100];
	int wlan_orig=0, ori_vwlan_idx=0;

	submitUrl = req_get_cstream_var(wp, ("submit-url"), "");

	refresh = req_get_cstream_var(wp, ("refresh"), "");
	/* WNC-MR0000-JOE-PENG-20130731-Show alert message when user pushs site survey button and rakuraku or WPS of DUT is running->start */
	/* WNC-NMR0000-JOE-PENG-20140127-Mv API for detecting WPS or RakuRaku is running to WNC library (libwnc.so) */
	if ((lw_is_rakuraku_running()==1) || (lw_is_wps_running()==1)) {
		/* If RakuRaku or WPS is running, do not exeute site survey and return directly. */
		/* Site survey page knows RakuRaku or WPS is running by ASP GET function and will pop up warning message. */
		if (submitUrl[0]){
			//send_redirect_perm(wp, submitUrl);
			send_redirect_perm(wp, "/cgi_html_903.html");	/* WNC-NMR1390-[Spider]-Libera-20160301- warning page for WPS running-v2-end */
			}
		return;
	}
	/* WNC-MR0000-JOE-PENG-20130731-Show alert message when user pushs site survey button and rakuraku or WPS of DUT is running->end */
	
	if ( refresh[0] ) {
	
/*WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode: Concurrent SS 2G/5G -Start*/	
		if(NUM_WLAN_INTERFACE == 2){
			/* WNC-NMR000-[Linear]-Libera-20140729- SPEC: Repeater mode - Step2 - connection management-start*/
			if (access("/tmp/MODE_RPT", F_OK) == 0 || access("/tmp/MODE_CNV", F_OK) == 0) {
				//printf("touch /var/rptonnecting\n");
				system("touch /var/rptonnecting");
				system("touch /var/ss");/* WNC-NMR1613-[Spider]-Libera-20160425- Fail Safe for continue to disconnected AP */
			}
			/* WNC-NMR000-[Linear]-Libera-20140729- SPEC: Repeater mode - Step2 - connection management-end*/

			int wlan0_disable=0, wlan1_disable=0;
			int ss_cunt=0;

			wlan_orig = wlan_idx;
			SetWlan_idx("wlan0");
			apmib_get(MIB_WLAN_WLAN_DISABLED, &wlan0_disable);
			SetWlan_idx("wlan1");
			apmib_get(MIB_WLAN_WLAN_DISABLED, &wlan1_disable);
			wlan_idx = wlan_orig;

			if (wlan0_disable==1 && wlan1_disable==0){
				//strcpy(WLAN_IF,"wlan1");
				strlcpy(WLAN_IF, "wlan1", 20);		//2426
				ss_cunt=1;	//single radio
			}else if (wlan0_disable==0 && wlan1_disable==1){
				//strcpy(WLAN_IF,"wlan0");
				strlcpy(WLAN_IF, "wlan0", 20);		//2426
				ss_cunt=1;	//single radio
			}else if(wlan0_disable==0 && wlan1_disable==0){
				//strcpy(WLAN_IF,"wlan0");
				strlcpy(WLAN_IF, "wlan0", 20);		//2426
				ss_cunt=2;	//dual radio
			}else{
				ss_cunt=0;
				printf("Wlan disable!!\n");
				strcpy(tmpBuf, ("Wlan disable!"));
				goto ss_err;		
			}

			// do ss start
			// issue scan request
			while (ss_cunt){
				ss_again:
				wait_time = 0;
				while (1) {
					/*
					strVal = req_get_cstream_var(wp, ("ifname"), "");
					if(strVal[0])
					{
						sprintf(WLAN_IF,"%s",strVal);
					}
					*/
					
					/*check if ss is ready*/
					switch(getWlSiteSurveyRequest(WLAN_IF, &status))
					{
						case -2:
							printf("-2\n");
							strcpy(tmpBuf, ("Auto scan running!!please wait..."));
							goto ss_err;
							break;
						case -1:
							printf("-2\n");
							strcpy(tmpBuf, ("Site-survey request failed!"));
							goto ss_err;
							break;
						default:
							break;
					}

					if (status != 0) {	// not ready
						if (wait_time++ > 5) {
							strcpy(tmpBuf, ("scan request timeout!"));
							goto ss_err;
						}
#ifdef	CONFIG_RTK_MESH
				// ==== modified by GANTOE for site survey 2008/12/26 ====
						usleep(1000000 + (rand() % 2000000));
#else
						sleep(1);
#endif
					}
					else
						break;
				}	

				// wait until scan completely
				wait_time = 0;
				while (1) {
					res = 1;	// only request request status	
					/*get ss result*/
					if ( getWlSiteSurveyResult(WLAN_IF, (SS_STATUS_Tp)&res) < 0 ) {
						strcpy(tmpBuf, ("Read site-survey status failed!"));
						free(pStatus);
						pStatus = NULL;
						goto ss_err;
					}
					if (res == 0xff) {   // in progress
					#if defined (CONFIG_RTL_92D_SUPPORT)  && defined (CONFIG_POCKET_ROUTER_SUPPORT)
						/*prolong wait time due to scan both 2.4G and 5G */
						if (wait_time++ > 20)
					#else
					//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140807, extend timeout value for RPT site survey
						//if (wait_time++ > 10)
						if (wait_time++ > 20)
					#endif
					{
							strcpy(tmpBuf, ("scan timeout!"));
							free(pStatus);
							pStatus = NULL;
							goto ss_err;
						}
						sleep(1);
					}
					else
						break;
				}

				/*if need scan by another radio*/
				if(ss_cunt==2){
					//swap interface.
					if (!strcmp(WLAN_IF,"wlan0")){
						//strcpy(WLAN_IF, "wlan1");
						strlcpy(WLAN_IF, "wlan1", 20);		//2426
					}else if (!strcmp(WLAN_IF,"wlan1")){
						//strcpy(WLAN_IF, "wlan0");
						strlcpy(WLAN_IF, "wlan0", 20);		//2426
					}else{
						break;
					}
					ss_cunt=0;
					goto ss_again;
				}
				break;	//ss_cunt
			}
			// do ss end
		}
		else	//original
		{
				// issue scan request
				wait_time = 0;
				while (1) {
					strVal = req_get_cstream_var(wp, ("ifname"), "");
					if(strVal[0])
					{
					//	sprintf(WLAN_IF,"%s",strVal);
						snprintf(WLAN_IF, 20, "%s", strVal);	//2426
					}
					// ==== modified by GANTOE for site survey 2008/12/26 ====
					printf("@@ [WLAN_IF: %s, Line: %d] @@\n", WLAN_IF, __LINE__);
					switch(getWlSiteSurveyRequest(WLAN_IF, &status))
					{
						case -2:
							printf("-2\n");
							strcpy(tmpBuf, ("Auto scan running!!please wait..."));
							goto ss_err;
							break;
						case -1:
							printf("-2\n");
							strcpy(tmpBuf, ("Site-survey request failed!"));
							goto ss_err;
							break;
						default:
							break;
					}
					// ==== GANTOE ====

					if (status != 0) {	// not ready
						if (wait_time++ > 5) {
							strcpy(tmpBuf, ("scan request timeout!"));
							goto ss_err;
						}
#ifdef	CONFIG_RTK_MESH
				// ==== modified by GANTOE for site survey 2008/12/26 ====
						usleep(1000000 + (rand() % 2000000));
#else
						sleep(1);
#endif
					}
					else
						break;
				}	

				// wait until scan completely
				wait_time = 0;
				while (1) {
					res = 1;	// only request request status	
					if ( getWlSiteSurveyResult(WLAN_IF, (SS_STATUS_Tp)&res) < 0 ) {
						strcpy(tmpBuf, ("Read site-survey status failed!"));
						free(pStatus);
						pStatus = NULL;
						goto ss_err;
					}
					if (res == 0xff) {   // in progress
					#if defined (CONFIG_RTL_92D_SUPPORT)  && defined (CONFIG_POCKET_ROUTER_SUPPORT)
						/*prolong wait time due to scan both 2.4G and 5G */
						if (wait_time++ > 20)
					#else
						if (wait_time++ > 10)
					#endif
					{
							strcpy(tmpBuf, ("scan timeout!"));
							free(pStatus);
							pStatus = NULL;
							goto ss_err;
						}
						sleep(1);
					}
					else
						break;
				}

		}
		if (access("/tmp/MODE_RPT", F_OK) == 0 || access("/tmp/MODE_CNV", F_OK) == 0) {
			system("rm /var/ss");/* WNC-NMR1613-[Spider]-Libera-20160425- Fail Safe for continue to disconnected AP */
		}

		if (submitUrl[0])
			send_redirect_perm(wp, submitUrl);
		return;
	}
#if 1	/* WNC-MR0000-[Voyager]-Libera-20131210- repeater mode */
	connect = req_get_cstream_var(wp, ("connect"), "");		//<--- start connect!!
	if ( connect[0] )
	{
		char *wlanifp, *strSSID;
		int rptEnabled=0;
		int wlan_mode=0;
		int wlanvxd_mode=0;
		char *strChannel;
		int channelIdx;
		char varName1[20];
		int wlanif_both=0, try_cunt=0;	/* WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode - connect to next radio */
		int opmode=0;
		int nec_rpt_vxd=0;
		char wlanifp_bak[32];
		int priority=0;	/* WNC-NMR000-[Linear]-Libera-20140729- SPEC: Repeater mode - Step2- band priority*/
		/* WNC-NMR0000-JOE-PENG-20141111-Make Linear repeater basic setting page "only save GUI settings", "not try connect" and "reboot immediately" by parameter "save_config_and_reboot=1"-start */
		int save_config_and_reboot=0;
#if 1	/* WNC-NMR000-[Aero/Thalys]-Libera-20160823- Server side input check-start */
		if(serverSide_check_wifi_sta(wp) < 0){
			send_redirect_perm(wp, LW_GUI_INPUT_ERR_PAGE);
			return -1;
		}
#endif	/* WNC-NMR000-[Aero/Thalys]-Libera-20160823- Server side input check-end */

		/* If brower sends variable "save_config_and_reboot" and the value is 1, then DUT executes "only save GUI settings", "not try connect" and "reboot immediately". */
		strVal= req_get_cstream_var(wp, ("save_config_and_reboot"), "");
		if (strVal[0]) {
			if (!strcmp(strVal, ("1"))) {
				save_config_and_reboot=1;
			}
		}
		/* WNC-NMR0000-JOE-PENG-20141111-Make Linear repeater basic setting page "only save GUI settings", "not try connect" and "reboot immediately" by parameter "save_config_and_reboot=1"-end */

		/* WNC-NMR0000-JOE-PENG-20140813-Fix bug that site survey page does not recover old setting value if Wi-Fi vxd inerface connection fails and user chooses recovering setting-start */
		/* Save old repeater setting before repeater connection test */
		save_repeater_config_setting(&old_repeater_config_info);
		/* WNC-NMR0000-JOE-PENG-20140813-Fix bug that site survey page does not recover old setting value if Wi-Fi vxd inerface connection fails and user chooses recovering setting-end */
#if 1	/* WNC-NMR758&760-[Linear]-Libera-20140916- on connecting (or disconnect), init wlan0-va0, and wlan1-va0 for issue deauth to client. */
		int wlan0_disabled=0, wlan1_disabled=0;

/* WNC-NMR0000-JOE-PENG-20141111-Make Linear repeater basic setting page "only save GUI settings", "not try connect" and "reboot immediately" by parameter "save_config_and_reboot=1" */
if (save_config_and_reboot!=1)
{
		int orig_wlan_idx=0;
		int orig_vwlan_idx=0;

		orig_wlan_idx=wlan_idx;
		orig_vwlan_idx=vwlan_idx;

		/*wlan0-va0*/
		wlan_idx=0;
		vwlan_idx=1;
		apmib_get(MIB_WLAN_WLAN_DISABLED, (void *)&wlan0_disabled);

		/*wlan1-va0*/
		wlan_idx=1;
		vwlan_idx=1;
		apmib_get(MIB_WLAN_WLAN_DISABLED, (void *)&wlan1_disabled);

		wlan_idx=orig_wlan_idx;
		vwlan_idx=orig_vwlan_idx;
		if(NUM_WLAN_INTERFACE == 2){	//dual radio
			if (access("/tmp/MODE_RPT", F_OK) == 0) {	//RPT mode
					if (wlan0_disabled==0){
						system("ifconfig wlan0-va0 down");
					}
					if (wlan1_disabled==0){
						system("ifconfig wlan1-va0 down");
					}
			}
		}
}
#endif	/* WNC-NMR758&760-[Linear]-Libera-20140916- on connecting (or disconnect), init wlan0-va0, and wlan1-va0 for issue deauth to client.-end */

		/* WNC-NMR0000-JOE-PENG-20140807-Implement section 5.22.9 Multi Stagge connection-start */
		/* WNC-NMR0000-JOE-PENG-20140724-Implemen section 4.4.38 site survey page of Linear step 2 (repeater mode)-start */
		/* Save GUI setting first then do connection test */
		{
			//set WPS priority
			strVal= req_get_cstream_var(wp, ("WPS_priority"), "");
			if (strVal[0]) {
				int orig_wlan_idx=0;
				int orig_vwlan_idx=0;
				int count1=0;
				int intVal = 0;

				if (!strcmp(strVal, ("5G")))
					intVal = 2;
				else if (!strcmp(strVal, ("2.4G")))
					intVal = 1;
				else {
					strcpy(tmpBuf, ("Error! Invalid WPS priority value."));
					goto ss_err;

				}

				orig_wlan_idx=wlan_idx;
				orig_vwlan_idx=vwlan_idx;

				/* Set WPS priority to vxd interface of each radio */
				for(count1=0;count1<NUM_WLAN_INTERFACE;count1++)
				{
					wlan_idx=count1;
					vwlan_idx = NUM_VWLAN_INTERFACE; // vxd interface

					apmib_set(MIB_WLAN_WSC_PRIORITY, (void *)&intVal);
				}

				wlan_idx=orig_wlan_idx;
				vwlan_idx=orig_vwlan_idx;
			}

			//set 2G enabled			
			strVal = req_get_cstream_var(wp, "wlanDisabled0", "");
			if(strVal[0]){
				int orig_wlan_idx=0;
				int orig_vwlan_idx=0;
				int intVal = 0;

				if ( !strcmp(strVal, "ON"))
					intVal = 1;
				else
					intVal = 0;

				orig_wlan_idx=wlan_idx;
				orig_vwlan_idx=vwlan_idx;

				/* Set Wi-Fi interface to wlan0 */
				wlan_idx = 0; //2G
				vwlan_idx = 0; 

				apmib_set(MIB_WLAN_WLAN_DISABLED, (void *)&intVal);

				wlan_idx=orig_wlan_idx;
				vwlan_idx=orig_vwlan_idx;
			}

			//set 5G enabled
			if(NUM_WLAN_INTERFACE == 2){
				strVal = req_get_cstream_var(wp, "wlanDisabled1", "");
				if(strVal[0]){
					int orig_wlan_idx=0;
					int orig_vwlan_idx=0;
					int intVal = 0;

					if ( !strcmp(strVal, "ON"))
						intVal = 1;
					else
						intVal = 0;

					orig_wlan_idx=wlan_idx;
					orig_vwlan_idx=vwlan_idx;

					/* Set Wi-Fi interface to wlan1 */
					wlan_idx = 1; //5G
					vwlan_idx = 0; 

					apmib_set(MIB_WLAN_WLAN_DISABLED, (void *)&intVal);

					wlan_idx=orig_wlan_idx;
					vwlan_idx=orig_vwlan_idx;
				}
			}

			/* set multi stage connection */
			strVal= req_get_cstream_var(wp, ("multiStageConnection"), "");
			if (strVal[0]) {
				int orig_wlan_idx=0;
				int orig_vwlan_idx=0;
				int count1=0;
				int intVal = 0;

				if (!strcmp(strVal, ("1")))
					intVal = MULTI_STAGE_CONNECTION_1;
				else if (!strcmp(strVal, ("2")))
					intVal = MULTI_STAGE_CONNECTION_2;
				else if (!strcmp(strVal, ("3")))
					intVal = MULTI_STAGE_CONNECTION_3;
				else {
					strcpy(tmpBuf, ("Error! Invalid multiStageConnection value."));
					goto ss_err;
				}

				orig_wlan_idx=wlan_idx;
				orig_vwlan_idx=vwlan_idx;

				/* Set multi stage connection to vxd interface of each radio */
				for(count1=0;count1<NUM_WLAN_INTERFACE;count1++)
				{
					/* WNC-NMR0000-JOE-PENG-20140807-Implement section 5.22.9 Multi Stagge connection-start */
					int count2=0;

					for(count2=0;count2<NUM_VWLAN_INTERFACE+1;count2++) {
						wlan_idx = count1;
						vwlan_idx = count2;

						/* Multi stage of GUI setting needs to write to MIB of wlan0 (For AP side of DUT (repeater mode)) and wlan0-vxd (For Client side of DUT (repeater mode)) */
						if ((vwlan_idx==0) || (vwlan_idx==NUM_VWLAN_INTERFACE)) {
							apmib_set(MIB_WLAN_MULTI_STAGE_CONNECTION, (void *)&intVal);
						}
					}
					/* WNC-NMR0000-JOE-PENG-20140807-Implement section 5.22.9 Multi Stagge connection-end */
				}
				
				wlan_idx=orig_wlan_idx;
				vwlan_idx=orig_vwlan_idx;
			}

			/* WNC-NMR0000-JOE-PENG-20140724-Implemen section 5.22.10 RF Output Power of Repeater of Linear step 2 (repeater mode)-start */
			/* set 2G RF power of wi-Fi root and vxd interface in converter and repeater mode */
			strVal= req_get_cstream_var(wp, ("RFPower_2G"), "");
			if (strVal[0]) {
				int orig_wlan_idx=0;
				int orig_vwlan_idx=0;
				int intVal = 0;
			
				if (!strcmp(strVal, ("0")))
					intVal = 0;
				else if (!strcmp(strVal, ("1")))
					intVal = 1;
				else if (!strcmp(strVal, ("2")))
					intVal = 2;
				else if (!strcmp(strVal, ("3")))
					intVal = 3;
				else if (!strcmp(strVal, ("4")))
					intVal = 4;
				else {
					strcpy(tmpBuf, ("Error! Invalid 2.4G RF output power value."));
					goto ss_err;
				}
			
				orig_wlan_idx=wlan_idx;
				orig_vwlan_idx=vwlan_idx;

				{
					/* WNC-NMR0000-JOE-PENG-20140718-Fix bug that in converter mode, RF output power only set to wlan0 interface and does not set to wlan0-vxd interface-start */
					int count1=0;
			
					for(count1=0;count1<NUM_VWLAN_INTERFACE+1;count1++)
					{
						wlan_idx = 0;//2.4G
						vwlan_idx = count1;
			
						/* Only set RF POWER to Wi-Fi root and vxd interface in converter and repeater mode */
						if ((vwlan_idx==0) || (vwlan_idx==NUM_VWLAN_INTERFACE)) {
							apmib_set(MIB_WLAN_RFPOWER_SCALE, (void *)&intVal);
						} else {
							continue;
						}
					}
					/* WNC-NMR0000-JOE-PENG-20140718-Fix bug that in converter mode, RF output power only set to wlan0 interface and does not set to wlan0-vxd interface-end */
				}
				
				wlan_idx=orig_wlan_idx;
				vwlan_idx=orig_vwlan_idx;
			}

			/* set 5G RF power of wi-Fi root and vxd interface in converter and repeater mode */
			if(NUM_WLAN_INTERFACE == 2){
				strVal= req_get_cstream_var(wp, ("RFPower_5G"), "");
				if (strVal[0]) {
					int orig_wlan_idx=0;
					int orig_vwlan_idx=0;
					int intVal = 0;
				
					if (!strcmp(strVal, ("0")))
						intVal = 0;
					else if (!strcmp(strVal, ("1")))
						intVal = 1;
					else if (!strcmp(strVal, ("2")))
						intVal = 2;
					else if (!strcmp(strVal, ("3")))
						intVal = 3;
					else if (!strcmp(strVal, ("4")))
						intVal = 4;
					else {
						strcpy(tmpBuf, ("Error! Invalid 5G RF output power value."));
						goto ss_err;
					}
				
					orig_wlan_idx=wlan_idx;
					orig_vwlan_idx=vwlan_idx;

					{
						/* WNC-NMR0000-JOE-PENG-20140718-Fix bug that in converter mode, RF output power only set to wlan0 interface and does not set to wlan0-vxd interface-start */
						int count1=0;
				
						for(count1=0;count1<NUM_VWLAN_INTERFACE+1;count1++)
						{
							wlan_idx = 1; //5G
							vwlan_idx = count1;
				
							/* Only set RF POWER to Wi-Fi root and vxd interface in converter and repeater mode */
							if ((vwlan_idx==0) || (vwlan_idx==NUM_VWLAN_INTERFACE)) {
								apmib_set(MIB_WLAN_RFPOWER_SCALE, (void *)&intVal);
							} else {
								continue;
							}
						}
						/* WNC-NMR0000-JOE-PENG-20140718-Fix bug that in converter mode, RF output power only set to wlan0 interface and does not set to wlan0-vxd interface-end */
					}
					
					wlan_idx=orig_wlan_idx;
					vwlan_idx=orig_vwlan_idx;
				}
			}
			/* WNC-NMR0000-JOE-PENG-20140724-Implemen section 5.22.10 RF Output Power of Repeater of Linear step 2 (repeater mode)-end */
		}
		apmib_update_web(CURRENT_SETTING);
		/* WNC-NMR0000-JOE-PENG-20140724-Implemen section 4.4.38 site survey page of Linear step 2 (repeater mode)-end */
		/* WNC-NMR0000-JOE-PENG-20140807-Implement section 5.22.9 Multi Stagge connection-end */

		/* WNC-NMR0731-JOE-PENG-20140820-Implement Spec. change request of bug 731 [Linear][Request] It can not do setting of connection condition in REP mode-start */
		/* If brower sends variable "only_save_config" and the value is 1, then DUT do not execute "try Root AP connection", save the settings instead.
			After saving the settings, GUI should show "reboot now" or "reboot later" button for user to select. */		
		/* WNC-NMR0000-JOE-PENG-20141111-Make Linear repeater basic setting page "only save GUI settings", "not try connect" and "reboot immediately" by parameter "save_config_and_reboot=1"-start */
		if (save_config_and_reboot!=1) {
			strVal= req_get_cstream_var(wp, ("only_save_config"), "");
			if (strVal[0]) {
				if (!strcmp(strVal, ("1"))) {
					OK_MSG(submitUrl);
					return;
				}
			}
		}
		/* WNC-NMR0000-JOE-PENG-20141111-Make Linear repeater basic setting page "only save GUI settings", "not try connect" and "reboot immediately" by parameter "save_config_and_reboot=1"-end */
		/* WNC-NMR0731-JOE-PENG-20140820-Implement Spec. change request of bug 731 [Linear][Request] It can not do setting of connection condition in REP mode-end */

#if 1//defined(CONFIG_RTL_ULINKER)
		if(wlan_idx == 0)
			apmib_get(MIB_REPEATER_ENABLED1, (void *)&rptEnabled);
		else
			apmib_get(MIB_REPEATER_ENABLED2, (void *)&rptEnabled);
#endif

#if defined(CONFIG_CHEEPER_REPEATER)
		// WNC-NMRXXX--JDR230-Yuan-I-Chou-20131217-Turn OFF ACT Orange LED before new connection
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20131218, Modify LED control API
		lw_ledctl(ACT_ORANGE, 0, 10, 1, 0, 1);
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20131218, Modify LED control API End

		trigger_reboot_led();

		system("touch /var/rptonnecting");
		
		apmib_get(MIB_WLAN_MODE, (void *)&wlan_mode);
		apmib_get(MIB_OP_MODE, (void *)&opmode);

		if( (wlan_mode == AP_MODE) && (rptEnabled == 1))
			nec_rpt_vxd = 1;
#endif
		wlanifp = req_get_cstream_var(wp, ("wlanif"), ""); //wlaon0 , wlan1
		/* WNC-NMR2423-Libera-20170614- avoid reboot with system cmd by hacker-start */
		if (check_invalid_char(wlanifp) == 0) {
			printf("\r\n[Warning] with invalid char: wlanifp=[%s],__[%s-%u]\r\n",wlanifp,__FILE__,__LINE__);
			send_redirect_perm(wp, LW_GUI_INPUT_ERR_PAGE);
			return;
		}
		/* WNC-NMR2423-Libera-20170614- avoid reboot with system cmd by hacker-end */
#if 1	//method 2 of auto channel
		strChannel = req_get_cstream_var(wp, ("pocket_channel"), "");
		if(strChannel[0])
		{
			channelIdx = atoi(strChannel);
			if(nec_rpt_vxd == 1)
			{
					/*char *wlanif0;
                       		 char command1[50];
					sprintf(command1,"iwpriv wlan0 set_mib switch_chan=1,%d",channelIdx);
                       		system(command1);  */							
				apmib_set( MIB_WLAN_CHANNEL,  (void *)&channelIdx);
			}
		}else{
			//unknown radio, so connect both radios.
			wlanif_both=1;	//WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode - connect to next radio
			
			/* WNC-NMR000-[Linear]-Libera-20140729- SPEC: Repeater mode - Step2- band priority-start*/
			strVal= req_get_cstream_var(wp, ("WPS_priority"), "");
			//printf("\r\n ++++++++++++WPS_priority=[%s],__[%s-%u]\r\n",strVal,__FILE__,__LINE__);
			if (strVal[0]) {
				if (!strcmp(strVal, ("5G")))
					//strcpy(wlanifp,"wlan1");
					strlcpy(wlanifp, "wlan1", 20);		//2426
				else if (!strcmp(strVal, ("2.4G")))
					//strcpy(wlanifp,"wlan0");
					strlcpy(wlanifp, "wlan0", 20);		//2426
				else {
					strcpy(tmpBuf, ("Error! Invalid WPS priority value."));
					goto ss_err;

				}
			}
			/* WNC-NMR000-[Linear]-Libera-20140729- SPEC: Repeater mode - Step2- band priority-end*/
		}
#endif
//printf("\r\n ++++++++++++wlanifp=[%s],__[%s-%u]\r\n",wlanifp,__FILE__,__LINE__);

connect_next_radio:

		SetWlan_idx(wlanifp);	//judge wlan_idx and vwlan_idx

#if 1	/* WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode */
		int funcoff=0;
		apmib_get(MIB_WLAN_FUNC_OFF, (void *)&funcoff);
#endif

#if 1 /* WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode - control alive interface - Start */
		int fun_off=0;
		char *terminal_if;

		/* WNC-NMR0000-JOE-PENG-20141111-Make Linear repeater basic setting page "only save GUI settings", "not try connect" and "reboot immediately" by parameter "save_config_and_reboot=1"-start */
		if (save_config_and_reboot!=1)
		{
			if(NUM_WLAN_INTERFACE == 2){	//dual radio
				if(rptEnabled==1 && funcoff==1){	//converter mode or RPT mode
					//printf("killall conn_mgmt\n");
					system("killall conn_mgmt");	/* WNC-NMR000-[Linear]-Libera-20140729- SPEC: Repeater mode - Step2 - connection management*/
					//while connecting, open wlan0-vxd and wlan1-vxd.

//WNC-NMR843-JDR230-YUAN-I-CHOU-20141113, Adjust "try-connect" behavior
					system("ifconfig wlan0-vxd down");
					system("ifconfig wlan1-vxd down");
#if 0
					/* WNC-NMR0819-Libera-And-JOE-20141031-Fix bug sometimes 2G and 5G vxd interface of converter will connect to Repeater at the same time and cause a4_sta_info in repeater errors. This results in that wired client under converter or repeater can not ping to root ap-start */
					if (!strcmp(wlanifp,"wlan0")){
						system("ifconfig wlan0-vxd down");
						system("iwpriv wlan0-vxd set_mib func_off=0");
						system("ifconfig wlan0-vxd up");

						system("ifconfig wlan1-vxd down");
						system("iwpriv wlan1-vxd set_mib func_off=1");
						system("ifconfig wlan1-vxd up");
						sleep(3);	// wlanx-vxd entering forwarding state need some time
					}else if (!strcmp(wlanifp,"wlan1")){
						system("ifconfig wlan1-vxd down");
						system("iwpriv wlan1-vxd set_mib func_off=0");
						system("ifconfig wlan1-vxd up");

						system("ifconfig wlan0-vxd down");
						system("iwpriv wlan0-vxd set_mib func_off=1");
						system("ifconfig wlan0-vxd up");
						sleep(3);	// wlanx-vxd entering forwarding state need some time
					}else{
						 printf("@ERROR@ Other interface: %s File: %s, Func: %s, Line: %d @@\n", wlanifp, __FILE__,__FUNCTION__ , __LINE__);
					}
					/* WNC-NMR0819-Libera-And-JOE-20141031-Fix bug sometimes 2G and 5G vxd interface of converter will connect to Repeater at the same time and cause a4_sta_info in repeater errors. This results in that wired client under converter or repeater can not ping to root ap-end */
#endif
//WNC-NMR843-JDR230-YUAN-I-CHOU-20141113, Adjust "try-connect" behavior End
				}
			}
		}
		/* WNC-NMR0000-JOE-PENG-20141111-Make Linear repeater basic setting page "only save GUI settings", "not try connect" and "reboot immediately" by parameter "save_config_and_reboot=1"-end */
#endif
		//sprintf(varName1, "SSID%d", wlan_idx);
		//sprintf(varName1, "SSID%d", 0);
		snprintf(varName1, sizeof(varName1), "SSID%d", 0); //2426
		strSSID = req_get_cstream_var(wp, varName1, "");

//		apmib_set(MIB_WLAN_SSID, (void *)strSSID);  //?

#if 0 //def CONFIG_SMART_REPEATER
		if(nec_rpt_vxd== 1)
			if(wlan_idx == 0)
				apmib_set(MIB_REPEATER_SSID1, (void *)strSSID);	//when use?
			else
				apmib_set(MIB_REPEATER_SSID2, (void *)strSSID);

#endif

//		apmib_update(CURRENT_SETTING);	//?

/* MR233-libera-20121208 - modify next button rule
		strSel = req_get_cstream_var(wp, ("select"), "");
		if (strSel[0]) {									*/
			unsigned char res;
			NETWORK_TYPE_T net;
			int chan;
/* MR233-libera-20121208 - modify next button rule
			if (pStatus == NULL) {
				strcpy(tmpBuf, ("Please refresh again!"));
				goto ss_err;

			}
			sscanf(strSel, "sel%d", &idx);
			if ( idx >= pStatus->number ) { // invalid index
				strcpy(tmpBuf, ("Connect failed 1!"));
				goto ss_err;
			}
*/

            char *tmpStr, *wlanif;
            char wlan_vxd_if[20];
            char varName[20];
            unsigned int i,val,val_wps;
           // wlanif = req_get_cstream_var(wp, ("wlanif"), "");
            //SetWlan_idx(tmpStr);

            tmpStr = req_get_cstream_var(wp, ("wlan_idx"), "");
            if(tmpStr[0])
                    wlan_idx = atoi(tmpStr);
			
           // sprintf(varName, "method%d", wlan_idx);		//non, WEP,WPAPSK, WPA2PSK
            snprintf(varName, sizeof(varName), "method%d", wlan_idx);//non, WEP,WPAPSK, WPA2PSK	//2426
            tmpStr = req_get_cstream_var(wp, varName, "");
     
            if(tmpStr[0])
            {//non, WEP,WPAPSK, WPA2PSK
                    val = atoi(tmpStr);
#if defined(CONFIG_CHEEPER_REPEATER)
				if(nec_rpt_vxd == 1){	//use wlan0-vxd to connect.
					SetWlan_idx(wlanifp);	//judge wlan_idx and vwlan_idx
						int isUpnpEnabled=0;

						ori_vwlan_idx=vwlan_idx;
						/* setting for wlan0-vxd */
						vwlan_idx = NUM_VWLAN_INTERFACE;						
						if(val == ENCRYPT_DISABLED)
							{
									ENCRYPT_T encrypt = ENCRYPT_DISABLED;
									apmib_set( MIB_WLAN_ENCRYPT, (void *)&encrypt);
							}
							else if(val == ENCRYPT_WEP)
							{
									//if(wepHandler(wp, tmpBuf, wlan_idx) < 0)
									if(wepHandler(wp, tmpBuf, 0) < 0)	/*WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode: Concurrent SS 2G/5G */
									{
											goto ss_err;
									}
							}
							else if(val > ENCRYPT_WEP && val <= ENCRYPT_WPA2_MIXED)
							{
									//if(wpaHandler(wp, tmpBuf, wlan_idx) < 0)
									if(wpaHandler(wp, tmpBuf, 0) < 0)	/*WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode: Concurrent SS 2G/5G */
									{
											goto ss_err;
									}
							}
#if 1 /* WNC-MR0000-[Voyager]-Libera-20140114- WPS2.0 client only support WPA2, so avoid setting WPA to wsc_conf */	
						if (val == ENCRYPT_WPA){
							val_wps = ENCRYPT_WPA2_MIXED;
						}
#endif
						apmib_set(MIB_WLAN_SSID, (void *)strSSID);	//vxd ssid
						/* MR000-libera-20130125 - fixed WPS encryption is asynchronous issue -start */						
						apmib_set(MIB_WLAN_WSC_SSID, (void *)strSSID);	//vxd wsc_ssid
						apmib_set(MIB_WLAN_WSC_ENC, (void *)&val_wps);		//vxd wsc_enc
						/* MR000-libera-20130125 - fixed WPS encryption is asynchronous issue -end */
						vwlan_idx=ori_vwlan_idx;						
					}
#endif
#if 0
					/* setting for wlan0 */					
                    if(val == ENCRYPT_DISABLED)
                    {
                            ENCRYPT_T encrypt = ENCRYPT_DISABLED;
                            apmib_set( MIB_WLAN_ENCRYPT, (void *)&encrypt);
                    }
                    else if(val == ENCRYPT_WEP)
                    {
                   	 		if(wepHandler(wp, tmpBuf, wlan_idx) < 0)
                            {
                                    goto ss_err;
                            }
                    }
                    else if(val > ENCRYPT_WEP && val <= ENCRYPT_WPA2_MIXED)
                    {
                    		if(wpaHandler(wp, tmpBuf, wlan_idx) < 0)
                            {
                                    goto ss_err;
                            }
                    }
				//	strcat(strSSID,"-ext");	//add SSID head
					apmib_set(MIB_WLAN_SSID, (void *)strSSID);
#endif				
				//	apmib_update(CURRENT_SETTING);
			}//non, WEP,WPAPSK, WPA2PSK
/* MR233-libera-20121208 - modify next button rule
		if ( pStatus->bssdb[idx].bdCap & cESS )
			net = INFRASTRUCTURE;
		else
			net = ADHOC;

		if ( apmib_set(MIB_WLAN_NETWORK_TYPE, (void *)&net) == 0) {
			strcpy(tmpBuf, ("Set MIB_WLAN_NETWORK_TYPE failed!"));
			fprintf(stderr,"#fmwlan.c- 3 Set MIB_WLAN_NETWORK_TYPE failed!\n");
			goto ss_err;
		}

		if (net == ADHOC) {
			chan = pStatus->bssdb[idx].ChannelNumber;
			if ( apmib_set( MIB_WLAN_CHANNEL, (void *)&chan) == 0) {
					strcpy(tmpBuf, ("Set channel number error!"));
				fprintf(stderr,"#fmwlan.c-Set channel number error!\n");
				goto ss_err;
			}
			int is_40m_bw = (pStatus->bssdb[idx].bdTstamp[1] & 2) ? 1 : 0;
			apmib_set(MIB_WLAN_CHANNEL_BONDING, (void *)&is_40m_bw);
		}
*/		
		apmib_update_web(CURRENT_SETTING);

/* WNC-NMR0000-JOE-PENG-20141111-Make Linear repeater basic setting page "only save GUI settings", "not try connect" and "reboot immediately" by parameter "save_config_and_reboot=1"-start */
#if 1 //reinit wlan interface and mib
		char command[50];
		if (save_config_and_reboot!=1) {
#ifdef CONFIG_CHEEPER_REPEATER
					if(nec_rpt_vxd){
						//sprintf(command,"ifconfig %s-vxd down",wlanifp);
						snprintf(command, sizeof(command), "ifconfig %s-vxd down", wlanifp);	//2426
                    	system(command);
                    }
#endif
					if (funcoff==0){	//WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode
	                    //sprintf(command,"ifconfig %s down",wlanifp);
						snprintf(command, sizeof(command), "ifconfig %s down", wlanifp);	//2426
	                    system(command);
	                    //sprintf(command,"flash set_mib %s",wlanifp);
						snprintf(command, sizeof(command), "flash set_mib %s", wlanifp);	//2426
	                    system(command);
	                    //sprintf(command,"ifconfig %s up",wlanifp);
						snprintf(command, sizeof(command), "ifconfig %s up", wlanifp);	//2426
	                    system(command);
					}
#ifdef CONFIG_CHEEPER_REPEATER
					if(nec_rpt_vxd){
						//sprintf(command,"flash set_mib %s-vxd",wlanifp);
						snprintf(command, sizeof(command), "flash set_mib %s-vxd", wlanifp);	//2426
                        system(command);
						//sprintf(command,"ifconfig %s-vxd up",wlanifp);
						snprintf(command, sizeof(command), "ifconfig %s-vxd up", wlanifp);	//2426
                        system(command);
                    }
#endif
		}

	#if defined(CONFIG_RTL_ULINKER)
		run_init_script_flag = 1;
	#else
		 // wlan0 entering forwarding state need some time
		if (save_config_and_reboot!=1) {
			sleep(3);
			_Start_Wlan_Applications();
		}
#if 1 /* WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode - control alive interface - Start */
		if (save_config_and_reboot!=1) {
			if(NUM_WLAN_INTERFACE == 2){	//dual radio
				if(rptEnabled==1 && funcoff==1){	//converter mode or RPT mode
					//while connecting, open wlan0-vxd and wlan1-vxd.

					/* WNC-NMR0819-Libera-And-JOE-20141031-Fix bug sometimes 2G and 5G vxd interface of converter will connect to Repeater at the same time and cause a4_sta_info in repeater errors. This results in that wired client under converter or repeater can not ping to root ap-start */
					if (!strcmp(wlanifp,"wlan0")){
						printf("[%s]func_off wlan1-vxd, func_on wlan0-vxd\n", __func__);
						system("ifconfig wlan0-vxd down");
						system("iwpriv wlan0-vxd set_mib func_off=0");
						system("ifconfig wlan0-vxd up");
						
						system("ifconfig wlan1-vxd down");
						system("iwpriv wlan1-vxd set_mib func_off=1");
						system("ifconfig wlan1-vxd up");
						sleep(3);	// wlanx-vxd entering forwarding state need some time
					}else if (!strcmp(wlanifp,"wlan1")){
						printf("[%s]func_off wlan0-vxd, func_on wlan1-vxd\n", __func__);
						system("ifconfig wlan1-vxd down");
						system("iwpriv wlan1-vxd set_mib func_off=0");
						system("ifconfig wlan1-vxd up");

						system("ifconfig wlan0-vxd down");
						system("iwpriv wlan0-vxd set_mib func_off=1");
						system("ifconfig wlan0-vxd up");
						sleep(3);	// wlanx-vxd entering forwarding state need some time
					}else{
						 printf("@ERROR@ Other interface: %s File: %s, Func: %s, Line: %d @@\n", wlanifp, __FILE__,__FUNCTION__ , __LINE__);
					}
					/* WNC-NMR0819-Libera-And-JOE-20141031-Fix bug sometimes 2G and 5G vxd interface of converter will connect to Repeater at the same time and cause a4_sta_info in repeater errors. This results in that wired client under converter or repeater can not ping to root ap-end */

#if 1	/*WNC-NMR000-[Linear]-Libera-20140619- IOCTL: SUPPORT_CLIENT_MIXED_SECURITY*/
					if (val == ENCRYPT_WPA2_MIXED){
						system("iwpriv wlan0-vxd set_mib clnt_mixed_security=1");
						system("iwpriv wlan1-vxd set_mib clnt_mixed_security=1");
					}else{
						if (val != ENCRYPT_DISABLED){	
							system("iwpriv wlan0-vxd set_mib clnt_mixed_security=0");
							system("iwpriv wlan1-vxd set_mib clnt_mixed_security=0");
						}
					}
#endif	/*WNC-NMR000-[Linear]-Libera-20140619- IOCTL: SUPPORT_CLIENT_MIXED_SECURITY -End*/
				}
			}
		}
#endif
#endif
#endif
/* WNC-NMR0000-JOE-PENG-20141111-Make Linear repeater basic setting page "only save GUI settings", "not try connect" and "reboot immediately" by parameter "save_config_and_reboot=1"-end */

#if 1		
		/* check connection state for wlan0-vxd */
		wait_time = 0;
		status = 0;
		
		/* WNC-NMR0000-JOE-PENG-20140911-Fix bug 2253 (STRING_OVERFLOW) in StaticCodeCheck_Linear_Delta1.xls -start */
		//strcpy(WLAN_IF,wlanifp);
		strncpy(WLAN_IF,wlanifp, 20);
		/* WNC-NMR0000-JOE-PENG-20140911-Fix bug 2253 (STRING_OVERFLOW) in StaticCodeCheck_Linear_Delta1.xls -end */
		if(nec_rpt_vxd && !strstr(WLAN_IF,"-vxd"))
			//strcat(WLAN_IF,"-vxd");
			strlcat(WLAN_IF,"-vxd",20);	//2426

		bss_info bss;
		apmib_get( MIB_WLAN_ENCRYPT, (void *)&encrypt);

		/* WNC-NMR0000-JOE-PENG-20141111-Make Linear repeater basic setting page "only save GUI settings", "not try connect" and "reboot immediately" by parameter "save_config_and_reboot=1"-start */
		if (save_config_and_reboot!=1) {
			if (encrypt == ENCRYPT_DISABLED || encrypt == ENCRYPT_WPA || encrypt == ENCRYPT_WPA2 || encrypt == ENCRYPT_WPA2_MIXED || encrypt == ENCRYPT_WEP) {
				//bss_info bss;
				wait_time = 0;

			//	max_wait_time=15;	//Need more test, especially for 802.1x client mode
				max_wait_time=20;

				while (wait_time++ < max_wait_time) {
					getWlBssInfo(WLAN_IF, &bss);
					printf("[%s]-[%d] bss.state[%d]\n", WLAN_IF, wait_time, bss.state);
					if (bss.state == STATE_CONNECTED){
						break;
					}
					sleep(1);
				}
				if (wait_time > max_wait_time)
					status = 1;
			}
		}
		/* WNC-NMR0000-JOE-PENG-20141111-Make Linear repeater basic setting page "only save GUI settings", "not try connect" and "reboot immediately" by parameter "save_config_and_reboot=1"-end */

/* WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode - connect to next radio - Start */
		if(NUM_WLAN_INTERFACE == 2){
			/* WNC-NMR0000-JOE-PENG-20141111-Make Linear repeater basic setting page "only save GUI settings", "not try connect" and "reboot immediately" by parameter "save_config_and_reboot=1"-start */
			if (save_config_and_reboot!=1) {
				if (wlanif_both==1 && status==1 && try_cunt==0){
					//swap interface.
					if (!strcmp(wlanifp,"wlan0")){
					//	robk_profile_config_setting(&old_repeater_config_info); /* WNC-NMR786-[Linear]-Libera-20141008-fixed the function: Can be set value after connection failed --*/
						//strcpy(wlanifp, "wlan1");
						strlcpy(wlanifp, "wlan1", 20);		//2426
					}else if (!strcmp(wlanifp,"wlan1")){
					//	robk_profile_config_setting(&old_repeater_config_info); /* WNC-NMR786-[Linear]-Libera-20141008-fixed the function: Can be set value after connection failed --*/
						//strcpy(wlanifp, "wlan0");
						strlcpy(wlanifp, "wlan0", 20);		//2426
					}
					try_cunt=1;
					goto connect_next_radio;
				}
			} else {
				/* If save_config_and_reboot is 1 and wlanif_both is 1 (Save parameter to 2 radio), then always jump to next radio and save config */
				if (wlanif_both==1 && try_cunt==0){
					//swap interface.
					if (!strcmp(wlanifp,"wlan0")){
						//strcpy(wlanifp, "wlan1");
						strlcpy(wlanifp, "wlan1", 20);		//2426
					}else if (!strcmp(wlanifp,"wlan1")){
						//strcpy(wlanifp, "wlan0");
						strlcpy(wlanifp, "wlan0", 20);		//2426
					}
					try_cunt=1;
					goto connect_next_radio;
				}
			}
			/* WNC-NMR0000-JOE-PENG-20141111-Make Linear repeater basic setting page "only save GUI settings", "not try connect" and "reboot immediately" by parameter "save_config_and_reboot=1"-end */
		}
/* WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode - connect to next radio - End */

		/* WNC-NMR0000-JOE-PENG-20141111-Make Linear repeater basic setting page "only save GUI settings", "not try connect" and "reboot immediately" by parameter "save_config_and_reboot=1"-start */
		if (save_config_and_reboot==1) {
			/* Always set status to 0 (Connect successfully) if save_config_and_reboot is 1 */
			status = 0;
		}
		/* WNC-NMR0000-JOE-PENG-20141111-Make Linear repeater basic setting page "only save GUI settings", "not try connect" and "reboot immediately" by parameter "save_config_and_reboot=1"-end */

		if (status){	/* Connect failed */
			printf("\nConnect failed!.\n");
			system("rm -f /var/rptonnecting");
			/* WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode -Start */
			pMsg =  (unsigned char *)"ƵȤ̵LAN ³ǤޤǤ<br>ͤȿǤ[]ľ[]򲡤Ƥ";
			/* WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode - End */
//WNC-NMR875-JDR230-YUAN-I-CHOU-20141205, Remove "bring up VAP" here, conn_mgmt would handle it.
//#if 1	/* WNC-NMR758&760-[Linear]-Libera-20140916- on connecting (or disconnect), init wlan0-va0, and wlan1-va0 for issue deauth to client. */
#if 0
//WNC-NMR875-JDR230-YUAN-I-CHOU-20141205, Remove "bring up VAP" here, conn_mgmt would handle it End.
{
		if(NUM_WLAN_INTERFACE == 2){	//dual radio
			if (access("/tmp/MODE_RPT", F_OK) == 0) {	//RPT mode
					if (wlan0_disabled==0){
						system("ifconfig wlan0-va0 up");
					}
					if (wlan1_disabled==0){
						system("ifconfig wlan1-va0 up");
					}
			}
		}
}
#endif	/* WNC-NMR758&760-[Linear]-Libera-20140916- on connecting (or disconnect), init wlan0-va0, and wlan1-va0 for issue deauth to client.-end */

		}else{	/* Connect successfully */
			printf("\nConnect successfully! Please wait while rebooting.\n");
			//system("rm -f /var/rptonnecting");		/* WNC-NMR000-[Linear]-Libera-20140729- SPEC: Repeater mode - Step2 - connection management - keep IP until reboot*/
			pMsg =  (unsigned char *)"ƵưԤäƤޤƵưŸڤʤǤ"; /* WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode -Start */
			//submitUrl="/status.htm";	
			submitUrl=NULL;	//go to /index.htm  //Rita--
#if 1	/* WNC-NMR786-[Linear]-Libera-20141008-fixed the function: Can be set value after connection failed-start */
		if(NUM_WLAN_INTERFACE == 2){
			/* WNC-NMR0000-JOE-PENG-20141111-Make Linear repeater basic setting page "only save GUI settings", "not try connect" and "reboot immediately" by parameter "save_config_and_reboot=1"-start */
			/* If save_config_and_reboot is 1, we do not execute "try connection". */
			/* In this case, the GUI settings need to save to flash MIB of two radios if wlanif_both and try_cunt are 1 */
			if (save_config_and_reboot!=1) {
				if (wlanif_both==1 && try_cunt==1){ //unknown band to connect and two band has be tried 
					//Roll back another band's setting for avoiding same SSID between two band.
					if (!strcmp(wlanifp,"wlan0")){
						robk_profile_config_setting(&old_repeater_config_info,1);	/* WNC-NMR773-[Linear]-Libera-20141002- Specified SSID setting issue-not reflected at other setting */
					}else if (!strcmp(wlanifp,"wlan1")){
						robk_profile_config_setting(&old_repeater_config_info,0);	/* WNC-NMR773-[Linear]-Libera-20141002- Specified SSID setting issue-not reflected at other setting */
					}
				}
			}
			/* WNC-NMR0000-JOE-PENG-20141111-Make Linear repeater basic setting page "only save GUI settings", "not try connect" and "reboot immediately" by parameter "save_config_and_reboot=1"-end */
		}
#endif	/* WNC-NMR786-[Linear]-Libera-20141008-fixed the function: Can be set value after connection failed-end */
#if 0	/* WNC-NMR806 -[Linear]-Libera-20141022- modify behavior to meet bug806 case-start*/
#if 1	/* WNC-NMR000-[Linear]-Libera-20140729- SPEC: Repeater mode - Step2- band priority-start*/
			if(wlanif_both==0){	//detect AP (by site survey)
				int intVal = 0;
				int orig_wlan_idx=0;
				int orig_vwlan_idx=0;				
/* WNC-NMR730-[Linear]-Libera-20140808- MIB_WLAN_WSC_PRIORITY should get from wlanx-vxd-start*/
				orig_wlan_idx=wlan_idx;
				orig_vwlan_idx=vwlan_idx;		
				vwlan_idx=NUM_VWLAN_INTERFACE;
				apmib_get(MIB_WLAN_WSC_PRIORITY, (void *)&intVal);
				wlan_idx=orig_wlan_idx;
				vwlan_idx=orig_vwlan_idx;
/* WNC-NMR730-[Linear]-Libera-20140808- MIB_WLAN_WSC_PRIORITY should get from wlanx-vxd-end*/
				orig_wlan_idx=wlan_idx;
				orig_vwlan_idx=vwlan_idx;	
				if(intVal==2){/*5GHz*/
					if(!strcmp(wlanifp,"wlan0")){
						int count1=0;
						intVal=1;// 2G link, change to 2G
						/* Set WPS priority to vxd interface of each radio */
						for(count1=0;count1<NUM_WLAN_INTERFACE;count1++)
						{
							wlan_idx=count1;
							vwlan_idx = NUM_VWLAN_INTERFACE; // vxd interface
							apmib_set(MIB_WLAN_WSC_PRIORITY, (void *)&intVal);
						}
						wlan_idx=orig_wlan_idx;
						vwlan_idx=orig_vwlan_idx;
					}						
				}else{/*2GHz*/
					if(!strcmp(wlanifp,"wlan1")){
						int count1=0;
						intVal=2;// 5G link, change to 5G
						/* Set WPS priority to vxd interface of each radio */
						for(count1=0;count1<NUM_WLAN_INTERFACE;count1++)
						{
							wlan_idx=count1;
							vwlan_idx = NUM_VWLAN_INTERFACE; // vxd interface
							apmib_set(MIB_WLAN_WSC_PRIORITY, (void *)&intVal);
						}
						wlan_idx=orig_wlan_idx;
						vwlan_idx=orig_vwlan_idx;
					}
				}
				
			}
#endif	/* WNC-NMR000-[Linear]-Libera-20140729- SPEC: Repeater mode - Step2- band priority-end*/
#endif	/* WNC-NMR806 -[Linear]-Libera-20141022- modify behavior to meet bug806 case-end*/
#if 1	/* WNC-NMR000-[Linear]-Libera-20140729- SPEC: Repeater mode - Step2-copy to wlanx-va1(STA I/F)*/
			if (access("/tmp/MODE_RPT", F_OK) == 0) {		//Repeater mode
				int orig_wlan_idx=0;
				int orig_vwlan_idx=0;
				orig_wlan_idx=wlan_idx;
				orig_vwlan_idx=vwlan_idx;

				/* setting for wlan0-va1(Real)--[mapping]--wlan0-va0(GUI) */ 		
				fprintf(stderr, "@ Connection OK --> copy %s-vxd to %s-va1 @\n",wlanifp,wlanifp);
				if (!strcmp(wlanifp,"wlan0")){
					wlan_idx=0;
					vwlan_idx=2;
				}else if (!strcmp(wlanifp,"wlan1")){;
					wlan_idx=1;
					vwlan_idx=2;					
				}

				if(val == ENCRYPT_DISABLED)	 /* WNC-NMR726-[Linear]-Libera-20140819- spec. issue - copy NoEncryption and ssid to wlanX-va0 */
				{
						ENCRYPT_T encrypt = ENCRYPT_DISABLED;
						apmib_set( MIB_WLAN_ENCRYPT, (void *)&encrypt);
				}
				else if(val > ENCRYPT_WEP && val <= ENCRYPT_WPA2_MIXED)
				{
						//if(wpaHandler(wp, tmpBuf, wlan_idx) < 0)
						if(wpaHandler(wp, tmpBuf, 0) < 0)	/*WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode: Concurrent SS 2G/5G */
						{
								goto ss_err;
						}
									
						int intVal=0;
#if 0	//security type judged by GUI
						strVal = req_get_cstream_var(wp, "ciphersuite_4_staif", "");						
											
							if (!strcmp(strVal, "WPA/WPA2-PSK(TKIP/AES)")){
								intVal =   WPA_CIPHER_MIXED; 
								ENCRYPT_T encrypt = ENCRYPT_WPA2_MIXED;
								apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&intVal);
								apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&intVal);
								apmib_set(MIB_WLAN_ENCRYPT, (void *)&encrypt);
							} else if (!strcmp(strVal, "WPA/WPA2-PSK(AES)")){
								intVal =   WPA_CIPHER_AES;
								ENCRYPT_T encrypt = ENCRYPT_WPA2_MIXED;
								apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&intVal);
								apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&intVal);
								apmib_set(MIB_WLAN_ENCRYPT, (void *)&encrypt);
							} else if (!strcmp(strVal, "WPA2-PSK(AES)")){
								intVal =   WPA_CIPHER_AES;
								ENCRYPT_T encrypt = ENCRYPT_WPA2;
								apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&intVal);
								apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&intVal);
								apmib_set(MIB_WLAN_ENCRYPT, (void *)&encrypt);
							}					
#else	//security type judged by driver		/* WNC-NMR000-[Linear]-Libera-20140729- SPEC: Repeater mode - Step2 - target AP security type -start*/
						/* WNC-NMR0000-JOE-PENG-20141111-Make Linear repeater basic setting page "only save GUI settings", "not try connect" and "reboot immediately" by parameter "save_config_and_reboot=1"-start */
						if (save_config_and_reboot!=1) {
							//security type judged by driver
							if (val == ENCRYPT_WPA2_MIXED){ 	//GUI-AP I/F
								/*WPA/WPA2-PSK(TKIP/AES)*/
								intVal =   WPA_CIPHER_MIXED; 
								ENCRYPT_T encrypt = ENCRYPT_WPA2_MIXED;
								apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&intVal);
								apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&intVal);
								apmib_set(MIB_WLAN_ENCRYPT, (void *)&encrypt);							
								printf("[%s]: WPA/WPA2-PSK(TKIP/AES), Line: %d\n",__FUNCTION__, __LINE__);
							} else if (val == ENCRYPT_WPA2){	//GUI-AP I/F$
								printf("[%s]: dot11EnablePSK=%d, dot11WPA2Cipher=%d, dot11WPACipher=%d @@\n",__FUNCTION__,bss.dot11EnablePSK,bss.dot11WPA2Cipher,bss.dot11WPACipher);
							
								//Target AP security type
								if (bss.dot11EnablePSK==3 && bss.dot11WPA2Cipher==10 && bss.dot11WPACipher==10){	//WPA/WPA2-PSK(TKIP/AES)
									/*WPA/WPA2-PSK(AES)*/
									intVal =   WPA_CIPHER_AES;
									ENCRYPT_T encrypt = ENCRYPT_WPA2_MIXED;
									apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&intVal);
									apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&intVal);
									apmib_set(MIB_WLAN_ENCRYPT, (void *)&encrypt);
									printf("[%s]: WPA/WPA2-PSK(AES), Line: %d\n",__FUNCTION__, __LINE__);
								} else if (bss.dot11EnablePSK==3 && bss.dot11WPA2Cipher==8 && bss.dot11WPACipher==8){	//WPA/WPA2-PSK(AES)
									/*WPA/WPA2-PSK(AES)*/
									intVal =   WPA_CIPHER_AES;
									ENCRYPT_T encrypt = ENCRYPT_WPA2_MIXED;
									apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&intVal);
									apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&intVal);
									apmib_set(MIB_WLAN_ENCRYPT, (void *)&encrypt);
									printf("[%s]: WPA/WPA2-PSK(AES), Line: %d\n",__FUNCTION__, __LINE__);
								} else if (bss.dot11EnablePSK==2 && bss.dot11WPA2Cipher==8 && bss.dot11WPACipher==0){	//WPA2-PSK(AES)
									/*WPA2-PSK(AES)*/
									intVal =   WPA_CIPHER_AES;
									ENCRYPT_T encrypt = ENCRYPT_WPA2;
									apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&intVal);
									apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&intVal);
									apmib_set(MIB_WLAN_ENCRYPT, (void *)&encrypt);
									printf("[%s]: WPA2-PSK(AES), Line: %d\n",__FUNCTION__, __LINE__);
								}
							}
						} else {
							//security type judged by GUI

							/* If save_config_and_reboot is 1, we do not execute "Try connection". so security type is judged by GUI setting */
							strVal = req_get_cstream_var(wp, "ciphersuite_4_staif", "");						
											
							if (!strcmp(strVal, "WPA/WPA2-PSK(TKIP/AES)")){
								intVal =   WPA_CIPHER_MIXED; 
								ENCRYPT_T encrypt = ENCRYPT_WPA2_MIXED;
								apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&intVal);
								apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&intVal);
								apmib_set(MIB_WLAN_ENCRYPT, (void *)&encrypt);
							} else if (!strcmp(strVal, "WPA/WPA2-PSK(AES)")){
								intVal =   WPA_CIPHER_AES;
								ENCRYPT_T encrypt = ENCRYPT_WPA2_MIXED;
								apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&intVal);
								apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&intVal);
								apmib_set(MIB_WLAN_ENCRYPT, (void *)&encrypt);
							} else if (!strcmp(strVal, "WPA2-PSK(AES)")){
								intVal =   WPA_CIPHER_AES;
								ENCRYPT_T encrypt = ENCRYPT_WPA2;
								apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&intVal);
								apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&intVal);
								apmib_set(MIB_WLAN_ENCRYPT, (void *)&encrypt);
							}
						}
						/* WNC-NMR0000-JOE-PENG-20141111-Make Linear repeater basic setting page "only save GUI settings", "not try connect" and "reboot immediately" by parameter "save_config_and_reboot=1"-end */
#endif	/* WNC-NMR000-[Linear]-Libera-20140729- SPEC: Repeater mode - Step2 - target AP security type -end*/
					//	apmib_set(MIB_WLAN_SSID, (void *)strSSID);	 /* WNC-NMR726-[Linear]-Libera-20140819- spec. issue - copy NoEncryption and ssid to wlanX-va0 */		
				}
				apmib_set(MIB_WLAN_SSID, (void *)strSSID);	 /* WNC-NMR726-[Linear]-Libera-20140819- spec. issue - copy NoEncryption and ssid to wlanX-va0 */
#if 1	/* WNC-NMR1635-[Spider]-Libera-20160429- 2/5G priority doesn't work-v2-sync. wlanx-vxd's SSID -start */
				if (wlan_idx==0){
					wlan_idx=1;
					vwlan_idx=NUM_VWLAN_INTERFACE;
				}else if (wlan_idx==1){
					wlan_idx=0;
					vwlan_idx=NUM_VWLAN_INTERFACE;
				}
/* WNC-NMR1635-[Spider]-Libera-20160429- 2/5G priority doesn't work-v3-sync. wlanx-vxd's profile-start */
				if(val == ENCRYPT_DISABLED)	 /* WNC-NMR726-[Linear]-Libera-20140819- spec. issue - copy NoEncryption and ssid to wlanX-vxd */
				{
						ENCRYPT_T encrypt = ENCRYPT_DISABLED;
						apmib_set( MIB_WLAN_ENCRYPT, (void *)&encrypt);
				}
				else if(val > ENCRYPT_WEP && val <= ENCRYPT_WPA2_MIXED)
				{
						//if(wpaHandler(wp, tmpBuf, wlan_idx) < 0)
						if(wpaHandler(wp, tmpBuf, 0) < 0)	/*WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode: Concurrent SS 2G/5G */
						{
								goto ss_err;
						}
									
						int intVal=0;
#if 1	//security type judged by driver		/* WNC-NMR000-[Linear]-Libera-20140729- SPEC: Repeater mode - Step2 - target AP security type -start*/
						/* WNC-NMR0000-JOE-PENG-20141111-Make Linear repeater basic setting page "only save GUI settings", "not try connect" and "reboot immediately" by parameter "save_config_and_reboot=1"-start */
						if (save_config_and_reboot!=1) {
							//security type judged by driver
							if (val == ENCRYPT_WPA2_MIXED){ 	//GUI-AP I/F
								/*WPA/WPA2-PSK(TKIP/AES)*/
								intVal =   WPA_CIPHER_MIXED; 
								ENCRYPT_T encrypt = ENCRYPT_WPA2_MIXED;
								apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&intVal);
								apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&intVal);
								apmib_set(MIB_WLAN_ENCRYPT, (void *)&encrypt);							
								printf("[%s]: WPA/WPA2-PSK(TKIP/AES), Line: %d\n",__FUNCTION__, __LINE__);
							} else if (val == ENCRYPT_WPA2){	//GUI-AP I/F$
								printf("[%s]: dot11EnablePSK=%d, dot11WPA2Cipher=%d, dot11WPACipher=%d @@\n",__FUNCTION__,bss.dot11EnablePSK,bss.dot11WPA2Cipher,bss.dot11WPACipher);
							
								//Target AP security type
								if (bss.dot11EnablePSK==3 && bss.dot11WPA2Cipher==10 && bss.dot11WPACipher==10){	//WPA/WPA2-PSK(TKIP/AES)
									/*WPA/WPA2-PSK(AES)*/
									intVal =   WPA_CIPHER_AES;
									ENCRYPT_T encrypt = ENCRYPT_WPA2_MIXED;
									apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&intVal);
									apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&intVal);
									apmib_set(MIB_WLAN_ENCRYPT, (void *)&encrypt);
									printf("[%s]: WPA/WPA2-PSK(AES), Line: %d\n",__FUNCTION__, __LINE__);
								} else if (bss.dot11EnablePSK==3 && bss.dot11WPA2Cipher==8 && bss.dot11WPACipher==8){	//WPA/WPA2-PSK(AES)
									/*WPA/WPA2-PSK(AES)*/
									intVal =   WPA_CIPHER_AES;
									ENCRYPT_T encrypt = ENCRYPT_WPA2_MIXED;
									apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&intVal);
									apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&intVal);
									apmib_set(MIB_WLAN_ENCRYPT, (void *)&encrypt);
									printf("[%s]: WPA/WPA2-PSK(AES), Line: %d\n",__FUNCTION__, __LINE__);
								} else if (bss.dot11EnablePSK==2 && bss.dot11WPA2Cipher==8 && bss.dot11WPACipher==0){	//WPA2-PSK(AES)
									/*WPA2-PSK(AES)*/
									intVal =   WPA_CIPHER_AES;
									ENCRYPT_T encrypt = ENCRYPT_WPA2;
									apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&intVal);
									apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&intVal);
									apmib_set(MIB_WLAN_ENCRYPT, (void *)&encrypt);
									printf("[%s]: WPA2-PSK(AES), Line: %d\n",__FUNCTION__, __LINE__);
								}
							}
						} else {
							//security type judged by GUI

							/* If save_config_and_reboot is 1, we do not execute "Try connection". so security type is judged by GUI setting */
							strVal = req_get_cstream_var(wp, "ciphersuite_4_staif", "");						
											
							if (!strcmp(strVal, "WPA/WPA2-PSK(TKIP/AES)")){
								intVal =   WPA_CIPHER_MIXED; 
								ENCRYPT_T encrypt = ENCRYPT_WPA2_MIXED;
								apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&intVal);
								apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&intVal);
								apmib_set(MIB_WLAN_ENCRYPT, (void *)&encrypt);
							} else if (!strcmp(strVal, "WPA/WPA2-PSK(AES)")){
								intVal =   WPA_CIPHER_AES;
								ENCRYPT_T encrypt = ENCRYPT_WPA2_MIXED;
								apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&intVal);
								apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&intVal);
								apmib_set(MIB_WLAN_ENCRYPT, (void *)&encrypt);
							} else if (!strcmp(strVal, "WPA2-PSK(AES)")){
								intVal =   WPA_CIPHER_AES;
								ENCRYPT_T encrypt = ENCRYPT_WPA2;
								apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&intVal);
								apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&intVal);
								apmib_set(MIB_WLAN_ENCRYPT, (void *)&encrypt);
							}
						}
						/* WNC-NMR0000-JOE-PENG-20141111-Make Linear repeater basic setting page "only save GUI settings", "not try connect" and "reboot immediately" by parameter "save_config_and_reboot=1"-end */
#endif	/* WNC-NMR000-[Linear]-Libera-20140729- SPEC: Repeater mode - Step2 - target AP security type -end*/
					//	apmib_set(MIB_WLAN_SSID, (void *)strSSID);	 /* WNC-NMR726-[Linear]-Libera-20140819- spec. issue - copy NoEncryption and ssid to wlanX-va0 */		
				}	
				/* WNC-NMR1635-[Spider]-Libera-20160429- 2/5G priority doesn't work-v3-sync. wlanx-vxd's profile-end */

				apmib_set(MIB_WLAN_SSID, (void *)strSSID);
#endif	/* WNC-NMR1635-[Spider]-Libera-20160429- 2/5G priority doesn't work-v2-sync. wlanx-vxd's SSID -end */
				wlan_idx=orig_wlan_idx;
				vwlan_idx=orig_vwlan_idx;						
			}
#else /*Cheeper*/	//if vxd connection is successful copy wlan0-vxd value to wlan0
								/* setting for wlan0 */ 		
								//fprintf(stderr, "@connection OK --> copy vxd to wlan0 @, vwlan_idx=%d\n",vwlan_idx);
								if(val == ENCRYPT_DISABLED)
								{
										ENCRYPT_T encrypt = ENCRYPT_DISABLED;
										apmib_set( MIB_WLAN_ENCRYPT, (void *)&encrypt);
								}
								else if(val == ENCRYPT_WEP)
								{
										//if(wepHandler(wp, tmpBuf, wlan_idx) < 0)
										if(wepHandler(wp, tmpBuf, 0) < 0)	/*WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode: Concurrent SS 2G/5G */
										{
												goto ss_err;
										}
								}
								else if(val > ENCRYPT_WEP && val <= ENCRYPT_WPA2_MIXED)
								{
										//if(wpaHandler(wp, tmpBuf, wlan_idx) < 0)
										if(wpaHandler(wp, tmpBuf, 0) < 0)	/*WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode: Concurrent SS 2G/5G */
										{
												goto ss_err;
										}
										int intVal;
										ENCRYPT_T encrypt = ENCRYPT_WPA2_MIXED;
										intVal =   WPA_CIPHER_MIXED;	/* WNC-NMR0272-Libera-20121217-add default setting for CIPHER =auto */
										apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&intVal);
										apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&intVal);
										apmib_set(MIB_WLAN_ENCRYPT, (void *)&encrypt);										
								}
							//	strcat(strSSID,"-ext"); //add SSID head
								apmib_set(MIB_WLAN_SSID, (void *)strSSID);
#endif
#if 1 /* WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode - control alive interface - Start */
			int fun_off=0;
			char terminal_if[16], use_if[16];
			if(NUM_WLAN_INTERFACE == 2){
				if (status!=1){	/* Connect successfully */
					if(rptEnabled==1 && funcoff==1){	//converter mode or RPT mode
						if (!strcmp(wlanifp,"wlan0")){			//use wlan0-vxd
							//strcpy(terminal_if,"wlan1-vxd");	//fun_off wlan1-vxd
							strlcpy(terminal_if, "wlan1-vxd", sizeof(terminal_if));		//2426
						}else if (!strcmp(wlanifp,"wlan1")){	//use wlan1-vxd
							//strcpy(terminal_if,"wlan0-vxd");	//fun_off wlan0-vxd
							strlcpy(terminal_if, "wlan0-vxd", sizeof(terminal_if));		//2426
						}else{
							goto unknowif;
						}
						ori_vwlan_idx=vwlan_idx;
						wlan_orig = wlan_idx;

						//sprintf(use_if, "%s-vxd", wlanifp);
						snprintf(use_if, sizeof(use_if), "%s-vxd", wlanifp);	//2426
						SetWlan_idx(use_if);
						fun_off=0;	//interface on
						apmib_set( MIB_WLAN_FUNC_OFF,  (void *)&fun_off);
						
						SetWlan_idx(terminal_if);
						fun_off=1;	//interface close
						apmib_set( MIB_WLAN_FUNC_OFF,  (void *)&fun_off);

						wlan_idx = wlan_orig;
						vwlan_idx = ori_vwlan_idx;
					}
				}
			}
			unknowif:
#endif
#if 1	//method 2 of auto channel 
			channelIdx=0;	//Cheeper spec. for wlan0 auto channel
			apmib_set( MIB_WLAN_CHANNEL,  (void *)&channelIdx);
			apmib_update_web(CURRENT_SETTING);
			//apmib_update(CURRENT_SETTING);
#endif											
		}
#endif

#if defined(CONFIG_POCKET_AP_SUPPORT)
			if(!status)
			{
				pMsg = "Connect successfully! Please wait while rebooting.";
				OK_MSG1(pMsg, submitUrl);
				sleep(2);
				system("reboot");
			}
#elif defined(CONFIG_POCKET_ROUTER_SUPPORT) || defined(CONFIG_RTL_ULINKER)
			{
#ifndef NO_ACTION
				run_init_script("all");
#endif
				REBOOT_WAIT("/wizard.htm");
				//REBOOT_WAIT("/wlsurvey.htm");

			}
#else
			{
				/* WNC-MR0000-Rita-20121130-reboot countDown page when repeater is connected */
				/* WNC-NMR0000-JOE-PENG-20140606-Correct messages of converter mode site survey page according to section 4.4.36 of Linear Spec. V1.1.0-start */
				if(!status){ //connected
					//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140916, Fix bug 2701 (UNINIT) in StaticCodeCheck_Linear_Delta1.xls
					{
						char *siteSurveySettingUrl = NULL;
						
						siteSurveySettingUrl = req_get_cstream_var(wp, ("site-survey-setting-url"), "");
						countdownAction = DO_REBOOT;
						send_redirect_perm(wp, siteSurveySettingUrl);
						system("sh /bin/reboot.sh > /dev/null");	/* WNC-NMR1570-[Spider]-Libera-20160412- can't reboot via wireless GUI */
					}
				} else { //disconnected
					/* WNC-NMR0000-JOE-PENG-20140813-Fix bug that site survey page does not recover old setting value if Wi-Fi vxd inerface connection fails and user chooses recovering setting-start */
					{
						char *connectFailUrl = NULL;
						
						connectFailUrl = req_get_cstream_var(wp, ("connect-fail-url"), "");
						send_redirect_perm(wp, connectFailUrl);
					}
					/* Save new repeater setting after repeater connection test fail */
					save_repeater_config_setting(&new_repeater_config_info);

					/* Set old repeater setting after repeater connection test fail */
					set_repeater_config_setting(&old_repeater_config_info);

					/* killall conn_mgmt before restart wlanX-vxd interface */
					system("killall conn_mgmt");

					/* Restart wlanX-vxd interface */
					{
						int count1=0;
						char temp_command[50]={0};

						for(count1=0;count1<NUM_WLAN_INTERFACE;count1++) {
							//sprintf(temp_command,"ifconfig wlan%d-vxd down",count1);
							snprintf(temp_command, sizeof(temp_command), "ifconfig wlan%d-vxd down", count1);	//2426
							system(temp_command);
						}

						for(count1=0;count1<NUM_WLAN_INTERFACE;count1++) {
							//sprintf(temp_command,"flash set_mib wlan%d-vxd",count1);
							snprintf(temp_command, sizeof(temp_command), "flash set_mib wlan%d-vxd", count1);	//2426
							system(temp_command);
						}

						for(count1=0;count1<NUM_WLAN_INTERFACE;count1++) {
							//sprintf(temp_command,"ifconfig wlan%d-vxd up",count1);
							snprintf(temp_command, sizeof(temp_command), "ifconfig wlan%d-vxd up", count1);	//2426
							system(temp_command);
						}
					}
					/* WNC-NMR0000-JOE-PENG-20140813-Fix bug that site survey page does not recover old setting value if Wi-Fi vxd inerface connection fails and user chooses recovering setting-end */

					/* WNC-NMR0000-JOE-PENG-20140724-Implemen section 4.4.38 site survey page of Linear step 2 (repeater mode)-start */

					/* WNC-NMR0000-JOE-PENG-20140813-Fix bug that site survey page does not recover old setting value if Wi-Fi vxd inerface connection fails and user chooses recovering setting-start */
					/* Restart Wi-Fi driver according to original setting */
					/* _Start_Wlan_Applications() will also execute command "conn_mgmt&". */
					_Start_Wlan_Applications(); 
					//system("conn_mgmt&");	/* WNC-NMR000-[Linear]-Libera-20140729- SPEC: Repeater mode - Step2 - connection management*/
					/* WNC-NMR0000-JOE-PENG-20140813-Fix bug that site survey page does not recover old setting value if Wi-Fi vxd inerface connection fails and user chooses recovering setting-end */
					/* WNC-NMR0000-JOE-PENG-20140724-Implemen section 4.4.38 site survey page of Linear step 2 (repeater mode)-end */

					/* WNC-NMR000-[Linear]-Libera-20140729- SPEC: Repeater mode - Step2 - connection management (Force DHCP)-start */
					struct stat status;
					if (stat(FORCE_DHCP_S, &status) == 0){
						system("iwpriv wlan0-vxd set_mib func_off=1");
						if(NUM_WLAN_INTERFACE == 2){
							system("iwpriv wlan1-vxd set_mib func_off=1");
						}
					}
					/* WNC-NMR000-[Linear]-Libera-20140729- SPEC: Repeater mode - Step2 - connection management (Force DHCP)-end */
				}
				/* WNC-NMR0000-JOE-PENG-20140606-Correct messages of converter mode site survey page according to section 4.4.36 of Linear Spec. V1.1.0-end */
				/* WNC-MR0000-Rita-2012113-End */
			}
#endif
	//	}	/* MR233-libera-20121208 - modify next button rule*/
#if defined(CONFIG_CHEEPER_REPEATER)	/*recover wlan0 interface*/
		if(nec_rpt_vxd)
		{
			char*ptmp;
			SetWlan_idx(wlanifp_bak);			
			ptmp=strstr(WLAN_IF,"-vxd");
			if(ptmp)
				memset(ptmp,0,sizeof(char)*strlen("-vxd"));
		}
#endif
	}
#endif	
	return;

ss_err:
	ERR_MSG(tmpBuf);
}

/* WNC-NMR0000-JOE-PENG-20140606-Correct messages of converter mode site survey page according to section 4.4.36 of Linear Spec. V1.1.0-start */
void formWlSubmitSiteSurveyReboot(request *wp, char *path, char *query)
{
	/* WNC-NMR0000-JOE-PENG-20140724-Implemen section 4.4.38 site survey page of Linear step 2 (repeater mode) */
 	char *submitUrl = NULL;

	/* WNC-NMR0000-JOE-PENG-20140813-Fix bug that site survey page does not recover old setting value if Wi-Fi vxd inerface connection fails and user chooses recovering setting-start */
	/* Set new repeater setting after repeater connection test fail and user still want to save setting and reboot */
	set_repeater_config_setting(&new_repeater_config_info);
	/* WNC-NMR0000-JOE-PENG-20140813-Fix bug that site survey page does not recover old setting value if Wi-Fi vxd inerface connection fails and user chooses recovering setting-end */

	submitUrl = req_get_cstream_var(wp, ("submit-url"), "");
	
	if (submitUrl[0])
	{
		countdownAction = DO_REBOOT;
		send_redirect_perm(wp, submitUrl);
	}

	return;
}
/* WNC-NMR0000-JOE-PENG-20140606-Correct messages of converter mode site survey page according to section 4.4.36 of Linear Spec. V1.1.0-end */
#endif /* WNC-NMR0000-Jog-Lin-20151221, end */

/////////////////////////////////////////////////////////////////////////////
#if 1	/* WNC-MR0000-Libera-Jan-20121101- new spec. - Repeater mode */
void formWlWncSiteSurvey(request *wp, char *path, char *query)
{
 	char *submitUrl, *refresh, *connect, *strSel, *strVal;
	//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140916, Fix bug 2700 (UNINIT) in StaticCodeCheck_Linear_Delta1.xls
	//int status, idx, encrypt;
	int status, idx, encrypt = 0;
	unsigned char res, *pMsg=NULL;
	int wait_time, max_wait_time=5;
	char tmpBuf[100];
	int wlan_orig=0, ori_vwlan_idx=0;

	submitUrl = req_get_cstream_var(wp, ("submit-url"), "");

	refresh = req_get_cstream_var(wp, ("refresh"), "");
	/* WNC-MR0000-JOE-PENG-20130731-Show alert message when user pushs site survey button and rakuraku or WPS of DUT is running->start */
	/* WNC-NMR0000-JOE-PENG-20140127-Mv API for detecting WPS or RakuRaku is running to WNC library (libwnc.so) */
	if ((lw_is_rakuraku_running()==1) || (lw_is_wps_running()==1)) {
		/* If RakuRaku or WPS is running, do not exeute site survey and return directly. */
		/* Site survey page knows RakuRaku or WPS is running by ASP GET function and will pop up warning message. */
		if (submitUrl[0])
			send_redirect_perm(wp, submitUrl);

		return;
	}
	/* WNC-MR0000-JOE-PENG-20130731-Show alert message when user pushs site survey button and rakuraku or WPS of DUT is running->end */
	
	if ( refresh[0] ) {
	
/*WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode: Concurrent SS 2G/5G -Start*/	
		if(NUM_WLAN_INTERFACE == 2){
			/* WNC-NMR000-[Linear]-Libera-20140729- SPEC: Repeater mode - Step2 - connection management-start*/
			if (access("/tmp/MODE_RPT", F_OK) == 0 || access("/tmp/MODE_CNV", F_OK) == 0) {
				//printf("touch /var/rptonnecting\n");
				system("touch /var/rptonnecting");
			}
			/* WNC-NMR000-[Linear]-Libera-20140729- SPEC: Repeater mode - Step2 - connection management-end*/

			int wlan0_disable=0, wlan1_disable=0;
			int ss_cunt=0;

			wlan_orig = wlan_idx;
			SetWlan_idx("wlan0");
			apmib_get(MIB_WLAN_WLAN_DISABLED, &wlan0_disable);
			SetWlan_idx("wlan1");
			apmib_get(MIB_WLAN_WLAN_DISABLED, &wlan1_disable);
			wlan_idx = wlan_orig;

			if (wlan0_disable==1 && wlan1_disable==0){
				strcpy(WLAN_IF,"wlan1");
				ss_cunt=1;	//single radio
			}else if (wlan0_disable==0 && wlan1_disable==1){
				strcpy(WLAN_IF,"wlan0");
				ss_cunt=1;	//single radio
			}else if(wlan0_disable==0 && wlan1_disable==0){
				strcpy(WLAN_IF,"wlan0");
				ss_cunt=2;	//dual radio
			}else{
				ss_cunt=0;
				printf("Wlan disable!!\n");
				strcpy(tmpBuf, ("Wlan disable!"));
				goto ss_err;		
			}

			// do ss start
			// issue scan request
			while (ss_cunt){
				ss_again:
				wait_time = 0;
				while (1) {
					/*
					strVal = req_get_cstream_var(wp, ("ifname"), "");
					if(strVal[0])
					{
						sprintf(WLAN_IF,"%s",strVal);
					}
					*/
					
					/*check if ss is ready*/
					switch(getWlSiteSurveyRequest(WLAN_IF, &status))
					{
						case -2:
							printf("-2\n");
							strcpy(tmpBuf, ("Auto scan running!!please wait..."));
							goto ss_err;
							break;
						case -1:
							printf("-2\n");
							strcpy(tmpBuf, ("Site-survey request failed!"));
							goto ss_err;
							break;
						default:
							break;
					}

					if (status != 0) {	// not ready
						if (wait_time++ > 5) {
							strcpy(tmpBuf, ("scan request timeout!"));
							goto ss_err;
						}
#ifdef	CONFIG_RTK_MESH
				// ==== modified by GANTOE for site survey 2008/12/26 ====
						usleep(1000000 + (rand() % 2000000));
#else
						sleep(1);
#endif
					}
					else
						break;
				}	

				// wait until scan completely
				wait_time = 0;
				while (1) {
					res = 1;	// only request request status	
					/*get ss result*/
					if ( getWlSiteSurveyResult(WLAN_IF, (SS_STATUS_Tp)&res) < 0 ) {
						strcpy(tmpBuf, ("Read site-survey status failed!"));
						free(pStatus);
						pStatus = NULL;
						goto ss_err;
					}
					if (res == 0xff) {   // in progress
					#if defined (CONFIG_RTL_92D_SUPPORT)  && defined (CONFIG_POCKET_ROUTER_SUPPORT)
						/*prolong wait time due to scan both 2.4G and 5G */
						if (wait_time++ > 20)
					#else
					//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140807, extend timeout value for RPT site survey
						//if (wait_time++ > 10)
						if (wait_time++ > 20)
					#endif
					{
							strcpy(tmpBuf, ("scan timeout!"));
							free(pStatus);
							pStatus = NULL;
							goto ss_err;
						}
						sleep(1);
					}
					else
						break;
				}

				/*if need scan by another radio*/
				if(ss_cunt==2){
					//swap interface.
					if (!strcmp(WLAN_IF,"wlan0")){
						strcpy(WLAN_IF, "wlan1");
					}else if (!strcmp(WLAN_IF,"wlan1")){
						strcpy(WLAN_IF, "wlan0");
					}else{
						break;
					}
					ss_cunt=0;
					goto ss_again;
				}
				break;	//ss_cunt
			}
			// do ss end
		}
		else	//original
		{
				// issue scan request
				wait_time = 0;
				while (1) {
					strVal = req_get_cstream_var(wp, ("ifname"), "");
					if(strVal[0])
					{
						sprintf(WLAN_IF,"%s",strVal);
					}
					// ==== modified by GANTOE for site survey 2008/12/26 ====
					printf("@@ [WLAN_IF: %s, Line: %d] @@\n", WLAN_IF, __LINE__);
					switch(getWlSiteSurveyRequest(WLAN_IF, &status))
					{
						case -2:
							printf("-2\n");
							strcpy(tmpBuf, ("Auto scan running!!please wait..."));
							goto ss_err;
							break;
						case -1:
							printf("-2\n");
							strcpy(tmpBuf, ("Site-survey request failed!"));
							goto ss_err;
							break;
						default:
							break;
					}
					// ==== GANTOE ====

					if (status != 0) {	// not ready
						if (wait_time++ > 5) {
							strcpy(tmpBuf, ("scan request timeout!"));
							goto ss_err;
						}
#ifdef	CONFIG_RTK_MESH
				// ==== modified by GANTOE for site survey 2008/12/26 ====
						usleep(1000000 + (rand() % 2000000));
#else
						sleep(1);
#endif
					}
					else
						break;
				}	

				// wait until scan completely
				wait_time = 0;
				while (1) {
					res = 1;	// only request request status	
					if ( getWlSiteSurveyResult(WLAN_IF, (SS_STATUS_Tp)&res) < 0 ) {
						strcpy(tmpBuf, ("Read site-survey status failed!"));
						free(pStatus);
						pStatus = NULL;
						goto ss_err;
					}
					if (res == 0xff) {   // in progress
					#if defined (CONFIG_RTL_92D_SUPPORT)  && defined (CONFIG_POCKET_ROUTER_SUPPORT)
						/*prolong wait time due to scan both 2.4G and 5G */
						if (wait_time++ > 20)
					#else
						if (wait_time++ > 10)
					#endif
					{
							strcpy(tmpBuf, ("scan timeout!"));
							free(pStatus);
							pStatus = NULL;
							goto ss_err;
						}
						sleep(1);
					}
					else
						break;
				}

		}

		if (submitUrl[0])
			send_redirect_perm(wp, submitUrl);
		return;
	}
#if 1	/* WNC-MR0000-[Voyager]-Libera-20131210- repeater mode */
	connect = req_get_cstream_var(wp, ("connect"), "");		//<--- start connect!!
	if ( connect[0] )
	{
		char *wlanifp, *strSSID;
		int rptEnabled=0;
		int wlan_mode=0;
		int wlanvxd_mode=0;
		char *strChannel;
		int channelIdx;
		char varName1[20];
		int wlanif_both=0, try_cunt=0;	/* WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode - connect to next radio */
		int opmode=0;
		int nec_rpt_vxd=0;
		char wlanifp_bak[32];
		int priority=0;	/* WNC-NMR000-[Linear]-Libera-20140729- SPEC: Repeater mode - Step2- band priority*/
		/* WNC-NMR0000-JOE-PENG-20141111-Make Linear repeater basic setting page "only save GUI settings", "not try connect" and "reboot immediately" by parameter "save_config_and_reboot=1"-start */
		int save_config_and_reboot=0;

		/* If brower sends variable "save_config_and_reboot" and the value is 1, then DUT executes "only save GUI settings", "not try connect" and "reboot immediately". */
		strVal= req_get_cstream_var(wp, ("save_config_and_reboot"), "");
		if (strVal[0]) {
			if (!strcmp(strVal, ("1"))) {
				save_config_and_reboot=1;
			}
		}
		/* WNC-NMR0000-JOE-PENG-20141111-Make Linear repeater basic setting page "only save GUI settings", "not try connect" and "reboot immediately" by parameter "save_config_and_reboot=1"-end */

		/* WNC-NMR0000-JOE-PENG-20140813-Fix bug that site survey page does not recover old setting value if Wi-Fi vxd inerface connection fails and user chooses recovering setting-start */
		/* Save old repeater setting before repeater connection test */
		save_repeater_config_setting(&old_repeater_config_info);
		/* WNC-NMR0000-JOE-PENG-20140813-Fix bug that site survey page does not recover old setting value if Wi-Fi vxd inerface connection fails and user chooses recovering setting-end */
#if 1	/* WNC-NMR758&760-[Linear]-Libera-20140916- on connecting (or disconnect), init wlan0-va0, and wlan1-va0 for issue deauth to client. */
		int wlan0_disabled=0, wlan1_disabled=0;

/* WNC-NMR0000-JOE-PENG-20141111-Make Linear repeater basic setting page "only save GUI settings", "not try connect" and "reboot immediately" by parameter "save_config_and_reboot=1" */
if (save_config_and_reboot!=1)
{
		int orig_wlan_idx=0;
		int orig_vwlan_idx=0;

		orig_wlan_idx=wlan_idx;
		orig_vwlan_idx=vwlan_idx;

		/*wlan0-va0*/
		wlan_idx=0;
		vwlan_idx=1;
		apmib_get(MIB_WLAN_WLAN_DISABLED, (void *)&wlan0_disabled);

		/*wlan1-va0*/
		wlan_idx=1;
		vwlan_idx=1;
		apmib_get(MIB_WLAN_WLAN_DISABLED, (void *)&wlan1_disabled);

		wlan_idx=orig_wlan_idx;
		vwlan_idx=orig_vwlan_idx;
		if(NUM_WLAN_INTERFACE == 2){	//dual radio
			if (access("/tmp/MODE_RPT", F_OK) == 0) {	//RPT mode
					if (wlan0_disabled==0){
						system("ifconfig wlan0-va0 down");
					}
					if (wlan1_disabled==0){
						system("ifconfig wlan1-va0 down");
					}
			}
		}
}
#endif	/* WNC-NMR758&760-[Linear]-Libera-20140916- on connecting (or disconnect), init wlan0-va0, and wlan1-va0 for issue deauth to client.-end */

		/* WNC-NMR0000-JOE-PENG-20140807-Implement section 5.22.9 Multi Stagge connection-start */
		/* WNC-NMR0000-JOE-PENG-20140724-Implemen section 4.4.38 site survey page of Linear step 2 (repeater mode)-start */
		/* Save GUI setting first then do connection test */
		{
			//set WPS priority
			strVal= req_get_cstream_var(wp, ("WPS_priority"), "");
			if (strVal[0]) {
				int orig_wlan_idx=0;
				int orig_vwlan_idx=0;
				int count1=0;
				int intVal = 0;

				if (!strcmp(strVal, ("5G")))
					intVal = 2;
				else if (!strcmp(strVal, ("2.4G")))
					intVal = 1;
				else {
					strcpy(tmpBuf, ("Error! Invalid WPS priority value."));
					goto ss_err;

				}

				orig_wlan_idx=wlan_idx;
				orig_vwlan_idx=vwlan_idx;

				/* Set WPS priority to vxd interface of each radio */
				for(count1=0;count1<NUM_WLAN_INTERFACE;count1++)
				{
					wlan_idx=count1;
					vwlan_idx = NUM_VWLAN_INTERFACE; // vxd interface

					apmib_set(MIB_WLAN_WSC_PRIORITY, (void *)&intVal);
				}

				wlan_idx=orig_wlan_idx;
				vwlan_idx=orig_vwlan_idx;
			}

			//set 2G enabled			
			strVal = req_get_cstream_var(wp, "wlanDisabled0", "");
			if(strVal[0]){
				int orig_wlan_idx=0;
				int orig_vwlan_idx=0;
				int intVal = 0;

				if ( !strcmp(strVal, "ON"))
					intVal = 1;
				else
					intVal = 0;

				orig_wlan_idx=wlan_idx;
				orig_vwlan_idx=vwlan_idx;

				/* Set Wi-Fi interface to wlan0 */
				wlan_idx = 0; //2G
				vwlan_idx = 0; 

				apmib_set(MIB_WLAN_WLAN_DISABLED, (void *)&intVal);

				wlan_idx=orig_wlan_idx;
				vwlan_idx=orig_vwlan_idx;
			}

			//set 5G enabled
			if(NUM_WLAN_INTERFACE == 2){
				strVal = req_get_cstream_var(wp, "wlanDisabled1", "");
				if(strVal[0]){
					int orig_wlan_idx=0;
					int orig_vwlan_idx=0;
					int intVal = 0;

					if ( !strcmp(strVal, "ON"))
						intVal = 1;
					else
						intVal = 0;

					orig_wlan_idx=wlan_idx;
					orig_vwlan_idx=vwlan_idx;

					/* Set Wi-Fi interface to wlan1 */
					wlan_idx = 1; //5G
					vwlan_idx = 0; 

					apmib_set(MIB_WLAN_WLAN_DISABLED, (void *)&intVal);

					wlan_idx=orig_wlan_idx;
					vwlan_idx=orig_vwlan_idx;
				}
			}

			/* set multi stage connection */
			strVal= req_get_cstream_var(wp, ("multiStageConnection"), "");
			if (strVal[0]) {
				int orig_wlan_idx=0;
				int orig_vwlan_idx=0;
				int count1=0;
				int intVal = 0;

				if (!strcmp(strVal, ("1")))
					intVal = MULTI_STAGE_CONNECTION_1;
				else if (!strcmp(strVal, ("2")))
					intVal = MULTI_STAGE_CONNECTION_2;
				else if (!strcmp(strVal, ("3")))
					intVal = MULTI_STAGE_CONNECTION_3;
				else {
					strcpy(tmpBuf, ("Error! Invalid multiStageConnection value."));
					goto ss_err;
				}

				orig_wlan_idx=wlan_idx;
				orig_vwlan_idx=vwlan_idx;

				/* Set multi stage connection to vxd interface of each radio */
				for(count1=0;count1<NUM_WLAN_INTERFACE;count1++)
				{
					/* WNC-NMR0000-JOE-PENG-20140807-Implement section 5.22.9 Multi Stagge connection-start */
					int count2=0;

					for(count2=0;count2<NUM_VWLAN_INTERFACE+1;count2++) {
						wlan_idx = count1;
						vwlan_idx = count2;

						/* Multi stage of GUI setting needs to write to MIB of wlan0 (For AP side of DUT (repeater mode)) and wlan0-vxd (For Client side of DUT (repeater mode)) */
						if ((vwlan_idx==0) || (vwlan_idx==NUM_VWLAN_INTERFACE)) {
							apmib_set(MIB_WLAN_MULTI_STAGE_CONNECTION, (void *)&intVal);
						}
					}
					/* WNC-NMR0000-JOE-PENG-20140807-Implement section 5.22.9 Multi Stagge connection-end */
				}
				
				wlan_idx=orig_wlan_idx;
				vwlan_idx=orig_vwlan_idx;
			}

			/* WNC-NMR0000-JOE-PENG-20140724-Implemen section 5.22.10 RF Output Power of Repeater of Linear step 2 (repeater mode)-start */
			/* set 2G RF power of wi-Fi root and vxd interface in converter and repeater mode */
			strVal= req_get_cstream_var(wp, ("RFPower_2G"), "");
			if (strVal[0]) {
				int orig_wlan_idx=0;
				int orig_vwlan_idx=0;
				int intVal = 0;
			
				if (!strcmp(strVal, ("0")))
					intVal = 0;
				else if (!strcmp(strVal, ("1")))
					intVal = 1;
				else if (!strcmp(strVal, ("2")))
					intVal = 2;
				else if (!strcmp(strVal, ("3")))
					intVal = 3;
				else if (!strcmp(strVal, ("4")))
					intVal = 4;
				else {
					strcpy(tmpBuf, ("Error! Invalid 2.4G RF output power value."));
					goto ss_err;
				}
			
				orig_wlan_idx=wlan_idx;
				orig_vwlan_idx=vwlan_idx;

				{
					/* WNC-NMR0000-JOE-PENG-20140718-Fix bug that in converter mode, RF output power only set to wlan0 interface and does not set to wlan0-vxd interface-start */
					int count1=0;
			
					for(count1=0;count1<NUM_VWLAN_INTERFACE+1;count1++)
					{
						wlan_idx = 0;//2.4G
						vwlan_idx = count1;
			
						/* Only set RF POWER to Wi-Fi root and vxd interface in converter and repeater mode */
						if ((vwlan_idx==0) || (vwlan_idx==NUM_VWLAN_INTERFACE)) {
							apmib_set(MIB_WLAN_RFPOWER_SCALE, (void *)&intVal);
						} else {
							continue;
						}
					}
					/* WNC-NMR0000-JOE-PENG-20140718-Fix bug that in converter mode, RF output power only set to wlan0 interface and does not set to wlan0-vxd interface-end */
				}
				
				wlan_idx=orig_wlan_idx;
				vwlan_idx=orig_vwlan_idx;
			}

			/* set 5G RF power of wi-Fi root and vxd interface in converter and repeater mode */
			if(NUM_WLAN_INTERFACE == 2){
				strVal= req_get_cstream_var(wp, ("RFPower_5G"), "");
				if (strVal[0]) {
					int orig_wlan_idx=0;
					int orig_vwlan_idx=0;
					int intVal = 0;
				
					if (!strcmp(strVal, ("0")))
						intVal = 0;
					else if (!strcmp(strVal, ("1")))
						intVal = 1;
					else if (!strcmp(strVal, ("2")))
						intVal = 2;
					else if (!strcmp(strVal, ("3")))
						intVal = 3;
					else if (!strcmp(strVal, ("4")))
						intVal = 4;
					else {
						strcpy(tmpBuf, ("Error! Invalid 5G RF output power value."));
						goto ss_err;
					}
				
					orig_wlan_idx=wlan_idx;
					orig_vwlan_idx=vwlan_idx;

					{
						/* WNC-NMR0000-JOE-PENG-20140718-Fix bug that in converter mode, RF output power only set to wlan0 interface and does not set to wlan0-vxd interface-start */
						int count1=0;
				
						for(count1=0;count1<NUM_VWLAN_INTERFACE+1;count1++)
						{
							wlan_idx = 1; //5G
							vwlan_idx = count1;
				
							/* Only set RF POWER to Wi-Fi root and vxd interface in converter and repeater mode */
							if ((vwlan_idx==0) || (vwlan_idx==NUM_VWLAN_INTERFACE)) {
								apmib_set(MIB_WLAN_RFPOWER_SCALE, (void *)&intVal);
							} else {
								continue;
							}
						}
						/* WNC-NMR0000-JOE-PENG-20140718-Fix bug that in converter mode, RF output power only set to wlan0 interface and does not set to wlan0-vxd interface-end */
					}
					
					wlan_idx=orig_wlan_idx;
					vwlan_idx=orig_vwlan_idx;
				}
			}
			/* WNC-NMR0000-JOE-PENG-20140724-Implemen section 5.22.10 RF Output Power of Repeater of Linear step 2 (repeater mode)-end */
		}
		apmib_update_web(CURRENT_SETTING);
		/* WNC-NMR0000-JOE-PENG-20140724-Implemen section 4.4.38 site survey page of Linear step 2 (repeater mode)-end */
		/* WNC-NMR0000-JOE-PENG-20140807-Implement section 5.22.9 Multi Stagge connection-end */

		/* WNC-NMR0731-JOE-PENG-20140820-Implement Spec. change request of bug 731 [Linear][Request] It can not do setting of connection condition in REP mode-start */
		/* If brower sends variable "only_save_config" and the value is 1, then DUT do not execute "try Root AP connection", save the settings instead.
			After saving the settings, GUI should show "reboot now" or "reboot later" button for user to select. */		
		/* WNC-NMR0000-JOE-PENG-20141111-Make Linear repeater basic setting page "only save GUI settings", "not try connect" and "reboot immediately" by parameter "save_config_and_reboot=1"-start */
		if (save_config_and_reboot!=1) {
			strVal= req_get_cstream_var(wp, ("only_save_config"), "");
			if (strVal[0]) {
				if (!strcmp(strVal, ("1"))) {
					OK_MSG(submitUrl);
					return;
				}
			}
		}
		/* WNC-NMR0000-JOE-PENG-20141111-Make Linear repeater basic setting page "only save GUI settings", "not try connect" and "reboot immediately" by parameter "save_config_and_reboot=1"-end */
		/* WNC-NMR0731-JOE-PENG-20140820-Implement Spec. change request of bug 731 [Linear][Request] It can not do setting of connection condition in REP mode-end */

#if 1//defined(CONFIG_RTL_ULINKER)
		if(wlan_idx == 0)
			apmib_get(MIB_REPEATER_ENABLED1, (void *)&rptEnabled);
		else
			apmib_get(MIB_REPEATER_ENABLED2, (void *)&rptEnabled);
#endif

#if defined(CONFIG_CHEEPER_REPEATER)
		// WNC-NMRXXX--JDR230-Yuan-I-Chou-20131217-Turn OFF ACT Orange LED before new connection
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20131218, Modify LED control API
		lw_ledctl(ACT_ORANGE, 0, 10, 1, 0, 1);
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20131218, Modify LED control API End

		trigger_reboot_led();

		system("touch /var/rptonnecting");
		
		apmib_get(MIB_WLAN_MODE, (void *)&wlan_mode);
		apmib_get(MIB_OP_MODE, (void *)&opmode);

		if( (wlan_mode == AP_MODE) && (rptEnabled == 1))
			nec_rpt_vxd = 1;
#endif
		wlanifp = req_get_cstream_var(wp, ("wlanif"), ""); //wlaon0 , wlan1
/* WNC-NMR2423-Libera-20170614- avoid reboot with system cmd by hacker-start */
		if (check_invalid_char(wlanifp) == 0) {
			printf("\r\n[Warning] with invalid char: wlanifp=[%s],__[%s-%u]\r\n",wlanifp,__FILE__,__LINE__);
			send_redirect_perm(wp, LW_GUI_INPUT_ERR_PAGE);
			return;
		}
/* WNC-NMR2423-Libera-20170614- avoid reboot with system cmd by hacker-end */
#if 1	//method 2 of auto channel
		strChannel = req_get_cstream_var(wp, ("pocket_channel"), "");
		if(strChannel[0])
		{
			channelIdx = atoi(strChannel);
			if(nec_rpt_vxd == 1)
			{
					/*char *wlanif0;
                       		 char command1[50];
					sprintf(command1,"iwpriv wlan0 set_mib switch_chan=1,%d",channelIdx);
                       		system(command1);  */							
				apmib_set( MIB_WLAN_CHANNEL,  (void *)&channelIdx);
			}
		}else{
			//unknown radio, so connect both radios.
			wlanif_both=1;	//WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode - connect to next radio
			
			/* WNC-NMR000-[Linear]-Libera-20140729- SPEC: Repeater mode - Step2- band priority-start*/
			strVal= req_get_cstream_var(wp, ("WPS_priority"), "");
			//printf("\r\n ++++++++++++WPS_priority=[%s],__[%s-%u]\r\n",strVal,__FILE__,__LINE__);
			if (strVal[0]) {
				if (!strcmp(strVal, ("5G")))
					strcpy(wlanifp,"wlan1");
				else if (!strcmp(strVal, ("2.4G")))
					strcpy(wlanifp,"wlan0");
				else {
					strcpy(tmpBuf, ("Error! Invalid WPS priority value."));
					goto ss_err;

				}
			}
			/* WNC-NMR000-[Linear]-Libera-20140729- SPEC: Repeater mode - Step2- band priority-end*/
		}
#endif
//printf("\r\n ++++++++++++wlanifp=[%s],__[%s-%u]\r\n",wlanifp,__FILE__,__LINE__);

connect_next_radio:

		SetWlan_idx(wlanifp);	//judge wlan_idx and vwlan_idx

#if 1	/* WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode */
		int funcoff=0;
		apmib_get(MIB_WLAN_FUNC_OFF, (void *)&funcoff);
#endif

#if 1 /* WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode - control alive interface - Start */
		int fun_off=0;
		char *terminal_if;

		/* WNC-NMR0000-JOE-PENG-20141111-Make Linear repeater basic setting page "only save GUI settings", "not try connect" and "reboot immediately" by parameter "save_config_and_reboot=1"-start */
		if (save_config_and_reboot!=1)
		{
			if(NUM_WLAN_INTERFACE == 2){	//dual radio
				if(rptEnabled==1 && funcoff==1){	//converter mode or RPT mode
					//printf("killall conn_mgmt\n");
					system("killall conn_mgmt");	/* WNC-NMR000-[Linear]-Libera-20140729- SPEC: Repeater mode - Step2 - connection management*/
					//while connecting, open wlan0-vxd and wlan1-vxd.

//WNC-NMR843-JDR230-YUAN-I-CHOU-20141113, Adjust "try-connect" behavior
					system("ifconfig wlan0-vxd down");
					system("ifconfig wlan1-vxd down");
#if 0
					/* WNC-NMR0819-Libera-And-JOE-20141031-Fix bug sometimes 2G and 5G vxd interface of converter will connect to Repeater at the same time and cause a4_sta_info in repeater errors. This results in that wired client under converter or repeater can not ping to root ap-start */
					if (!strcmp(wlanifp,"wlan0")){
						system("ifconfig wlan0-vxd down");
						system("iwpriv wlan0-vxd set_mib func_off=0");
						system("ifconfig wlan0-vxd up");

						system("ifconfig wlan1-vxd down");
						system("iwpriv wlan1-vxd set_mib func_off=1");
						system("ifconfig wlan1-vxd up");
						sleep(3);	// wlanx-vxd entering forwarding state need some time
					}else if (!strcmp(wlanifp,"wlan1")){
						system("ifconfig wlan1-vxd down");
						system("iwpriv wlan1-vxd set_mib func_off=0");
						system("ifconfig wlan1-vxd up");

						system("ifconfig wlan0-vxd down");
						system("iwpriv wlan0-vxd set_mib func_off=1");
						system("ifconfig wlan0-vxd up");
						sleep(3);	// wlanx-vxd entering forwarding state need some time
					}else{
						 printf("@ERROR@ Other interface: %s File: %s, Func: %s, Line: %d @@\n", wlanifp, __FILE__,__FUNCTION__ , __LINE__);
					}
					/* WNC-NMR0819-Libera-And-JOE-20141031-Fix bug sometimes 2G and 5G vxd interface of converter will connect to Repeater at the same time and cause a4_sta_info in repeater errors. This results in that wired client under converter or repeater can not ping to root ap-end */
#endif
//WNC-NMR843-JDR230-YUAN-I-CHOU-20141113, Adjust "try-connect" behavior End
				}
			}
		}
		/* WNC-NMR0000-JOE-PENG-20141111-Make Linear repeater basic setting page "only save GUI settings", "not try connect" and "reboot immediately" by parameter "save_config_and_reboot=1"-end */
#endif
		//sprintf(varName1, "SSID%d", wlan_idx);
		sprintf(varName1, "SSID%d", 0);
		strSSID = req_get_cstream_var(wp, varName1, "");

//		apmib_set(MIB_WLAN_SSID, (void *)strSSID);  //?

#if 0 //def CONFIG_SMART_REPEATER
		if(nec_rpt_vxd== 1)
			if(wlan_idx == 0)
				apmib_set(MIB_REPEATER_SSID1, (void *)strSSID);	//when use?
			else
				apmib_set(MIB_REPEATER_SSID2, (void *)strSSID);

#endif

//		apmib_update(CURRENT_SETTING);	//?

/* MR233-libera-20121208 - modify next button rule
		strSel = req_get_cstream_var(wp, ("select"), "");
		if (strSel[0]) {									*/
			unsigned char res;
			NETWORK_TYPE_T net;
			int chan;
/* MR233-libera-20121208 - modify next button rule
			if (pStatus == NULL) {
				strcpy(tmpBuf, ("Please refresh again!"));
				goto ss_err;

			}
			sscanf(strSel, "sel%d", &idx);
			if ( idx >= pStatus->number ) { // invalid index
				strcpy(tmpBuf, ("Connect failed 1!"));
				goto ss_err;
			}
*/

            char *tmpStr, *wlanif;
            char wlan_vxd_if[20];
            char varName[20];
            unsigned int i,val,val_wps;
           // wlanif = req_get_cstream_var(wp, ("wlanif"), "");
            //SetWlan_idx(tmpStr);

            tmpStr = req_get_cstream_var(wp, ("wlan_idx"), "");
            if(tmpStr[0])
                    wlan_idx = atoi(tmpStr);
			
            sprintf(varName, "method%d", wlan_idx);		//non, WEP,WPAPSK, WPA2PSK
            tmpStr = req_get_cstream_var(wp, varName, "");
     
            if(tmpStr[0])
            {//non, WEP,WPAPSK, WPA2PSK
                    val = atoi(tmpStr);
#if defined(CONFIG_CHEEPER_REPEATER)
				if(nec_rpt_vxd == 1){	//use wlan0-vxd to connect.
					SetWlan_idx(wlanifp);	//judge wlan_idx and vwlan_idx
						int isUpnpEnabled=0;

						ori_vwlan_idx=vwlan_idx;
						/* setting for wlan0-vxd */
						vwlan_idx = NUM_VWLAN_INTERFACE;						
						if(val == ENCRYPT_DISABLED)
							{
									ENCRYPT_T encrypt = ENCRYPT_DISABLED;
									apmib_set( MIB_WLAN_ENCRYPT, (void *)&encrypt);
							}
							else if(val == ENCRYPT_WEP)
							{
									//if(wepHandler(wp, tmpBuf, wlan_idx) < 0)
									if(wepHandler(wp, tmpBuf, 0) < 0)	/*WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode: Concurrent SS 2G/5G */
									{
											goto ss_err;
									}
							}
							else if(val > ENCRYPT_WEP && val <= ENCRYPT_WPA2_MIXED)
							{
									//if(wpaHandler(wp, tmpBuf, wlan_idx) < 0)
									if(wpaHandler(wp, tmpBuf, 0) < 0)	/*WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode: Concurrent SS 2G/5G */
									{
											goto ss_err;
									}
							}
#if 1 /* WNC-MR0000-[Voyager]-Libera-20140114- WPS2.0 client only support WPA2, so avoid setting WPA to wsc_conf */	
						if (val == ENCRYPT_WPA){
							val_wps = ENCRYPT_WPA2_MIXED;
						}
#endif
						apmib_set(MIB_WLAN_SSID, (void *)strSSID);	//vxd ssid
						/* MR000-libera-20130125 - fixed WPS encryption is asynchronous issue -start */						
						apmib_set(MIB_WLAN_WSC_SSID, (void *)strSSID);	//vxd wsc_ssid
						apmib_set(MIB_WLAN_WSC_ENC, (void *)&val_wps);		//vxd wsc_enc
						/* MR000-libera-20130125 - fixed WPS encryption is asynchronous issue -end */
						vwlan_idx=ori_vwlan_idx;						
					}
#endif
#if 0
					/* setting for wlan0 */					
                    if(val == ENCRYPT_DISABLED)
                    {
                            ENCRYPT_T encrypt = ENCRYPT_DISABLED;
                            apmib_set( MIB_WLAN_ENCRYPT, (void *)&encrypt);
                    }
                    else if(val == ENCRYPT_WEP)
                    {
                   	 		if(wepHandler(wp, tmpBuf, wlan_idx) < 0)
                            {
                                    goto ss_err;
                            }
                    }
                    else if(val > ENCRYPT_WEP && val <= ENCRYPT_WPA2_MIXED)
                    {
                    		if(wpaHandler(wp, tmpBuf, wlan_idx) < 0)
                            {
                                    goto ss_err;
                            }
                    }
				//	strcat(strSSID,"-ext");	//add SSID head
					apmib_set(MIB_WLAN_SSID, (void *)strSSID);
#endif				
				//	apmib_update(CURRENT_SETTING);
			}//non, WEP,WPAPSK, WPA2PSK
/* MR233-libera-20121208 - modify next button rule
		if ( pStatus->bssdb[idx].bdCap & cESS )
			net = INFRASTRUCTURE;
		else
			net = ADHOC;

		if ( apmib_set(MIB_WLAN_NETWORK_TYPE, (void *)&net) == 0) {
			strcpy(tmpBuf, ("Set MIB_WLAN_NETWORK_TYPE failed!"));
			fprintf(stderr,"#fmwlan.c- 3 Set MIB_WLAN_NETWORK_TYPE failed!\n");
			goto ss_err;
		}

		if (net == ADHOC) {
			chan = pStatus->bssdb[idx].ChannelNumber;
			if ( apmib_set( MIB_WLAN_CHANNEL, (void *)&chan) == 0) {
					strcpy(tmpBuf, ("Set channel number error!"));
				fprintf(stderr,"#fmwlan.c-Set channel number error!\n");
				goto ss_err;
			}
			int is_40m_bw = (pStatus->bssdb[idx].bdTstamp[1] & 2) ? 1 : 0;
			apmib_set(MIB_WLAN_CHANNEL_BONDING, (void *)&is_40m_bw);
		}
*/		
		apmib_update_web(CURRENT_SETTING);

/* WNC-NMR0000-JOE-PENG-20141111-Make Linear repeater basic setting page "only save GUI settings", "not try connect" and "reboot immediately" by parameter "save_config_and_reboot=1"-start */
#if 1 //reinit wlan interface and mib
		char command[50];
		if (save_config_and_reboot!=1) {
#ifdef CONFIG_CHEEPER_REPEATER
					if(nec_rpt_vxd){
						sprintf(command,"ifconfig %s-vxd down",wlanifp);
                    	system(command);
                    }
#endif
					if (funcoff==0){	//WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode
	                    sprintf(command,"ifconfig %s down",wlanifp);
	                    system(command);
	                    sprintf(command,"flash set_mib %s",wlanifp);
	                    system(command);
	                    sprintf(command,"ifconfig %s up",wlanifp);
	                    system(command);
					}
#ifdef CONFIG_CHEEPER_REPEATER
					if(nec_rpt_vxd){
						sprintf(command,"flash set_mib %s-vxd",wlanifp);
                        system(command);
						sprintf(command,"ifconfig %s-vxd up",wlanifp);
                        system(command);
                    }
#endif
		}

	#if defined(CONFIG_RTL_ULINKER)
		run_init_script_flag = 1;
	#else
		 // wlan0 entering forwarding state need some time
		if (save_config_and_reboot!=1) {
			sleep(3);
			_Start_Wlan_Applications();
		}
#if 1 /* WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode - control alive interface - Start */
		if (save_config_and_reboot!=1) {
			if(NUM_WLAN_INTERFACE == 2){	//dual radio
				if(rptEnabled==1 && funcoff==1){	//converter mode or RPT mode
					//while connecting, open wlan0-vxd and wlan1-vxd.

					/* WNC-NMR0819-Libera-And-JOE-20141031-Fix bug sometimes 2G and 5G vxd interface of converter will connect to Repeater at the same time and cause a4_sta_info in repeater errors. This results in that wired client under converter or repeater can not ping to root ap-start */
					if (!strcmp(wlanifp,"wlan0")){
						printf("[%s]func_off wlan1-vxd, func_on wlan0-vxd\n", __func__);
						system("ifconfig wlan0-vxd down");
						system("iwpriv wlan0-vxd set_mib func_off=0");
						system("ifconfig wlan0-vxd up");
						
						system("ifconfig wlan1-vxd down");
						system("iwpriv wlan1-vxd set_mib func_off=1");
						system("ifconfig wlan1-vxd up");
						sleep(3);	// wlanx-vxd entering forwarding state need some time
					}else if (!strcmp(wlanifp,"wlan1")){
						printf("[%s]func_off wlan0-vxd, func_on wlan1-vxd\n", __func__);
						system("ifconfig wlan1-vxd down");
						system("iwpriv wlan1-vxd set_mib func_off=0");
						system("ifconfig wlan1-vxd up");

						system("ifconfig wlan0-vxd down");
						system("iwpriv wlan0-vxd set_mib func_off=1");
						system("ifconfig wlan0-vxd up");
						sleep(3);	// wlanx-vxd entering forwarding state need some time
					}else{
						 printf("@ERROR@ Other interface: %s File: %s, Func: %s, Line: %d @@\n", wlanifp, __FILE__,__FUNCTION__ , __LINE__);
					}
					/* WNC-NMR0819-Libera-And-JOE-20141031-Fix bug sometimes 2G and 5G vxd interface of converter will connect to Repeater at the same time and cause a4_sta_info in repeater errors. This results in that wired client under converter or repeater can not ping to root ap-end */

#if 1	/*WNC-NMR000-[Linear]-Libera-20140619- IOCTL: SUPPORT_CLIENT_MIXED_SECURITY*/
					if (val == ENCRYPT_WPA2_MIXED){
						system("iwpriv wlan0-vxd set_mib clnt_mixed_security=1");
						system("iwpriv wlan1-vxd set_mib clnt_mixed_security=1");
					}else{
						if (val != ENCRYPT_DISABLED){	
							system("iwpriv wlan0-vxd set_mib clnt_mixed_security=0");
							system("iwpriv wlan1-vxd set_mib clnt_mixed_security=0");
						}
					}
#endif	/*WNC-NMR000-[Linear]-Libera-20140619- IOCTL: SUPPORT_CLIENT_MIXED_SECURITY -End*/
				}
			}
		}
#endif
#endif
#endif
/* WNC-NMR0000-JOE-PENG-20141111-Make Linear repeater basic setting page "only save GUI settings", "not try connect" and "reboot immediately" by parameter "save_config_and_reboot=1"-end */

#if 1		
		/* check connection state for wlan0-vxd */
		wait_time = 0;
		status = 0;
		
		/* WNC-NMR0000-JOE-PENG-20140911-Fix bug 2253 (STRING_OVERFLOW) in StaticCodeCheck_Linear_Delta1.xls -start */
		//strcpy(WLAN_IF,wlanifp);
		strncpy(WLAN_IF,wlanifp, 20);
		/* WNC-NMR0000-JOE-PENG-20140911-Fix bug 2253 (STRING_OVERFLOW) in StaticCodeCheck_Linear_Delta1.xls -end */
		if(nec_rpt_vxd && !strstr(WLAN_IF,"-vxd"))
			strcat(WLAN_IF,"-vxd");

		bss_info bss;
		apmib_get( MIB_WLAN_ENCRYPT, (void *)&encrypt);

		/* WNC-NMR0000-JOE-PENG-20141111-Make Linear repeater basic setting page "only save GUI settings", "not try connect" and "reboot immediately" by parameter "save_config_and_reboot=1"-start */
		if (save_config_and_reboot!=1) {
			if (encrypt == ENCRYPT_DISABLED || encrypt == ENCRYPT_WPA || encrypt == ENCRYPT_WPA2 || encrypt == ENCRYPT_WPA2_MIXED || encrypt == ENCRYPT_WEP) {
				//bss_info bss;
				wait_time = 0;

			//	max_wait_time=15;	//Need more test, especially for 802.1x client mode
				max_wait_time=20;

				while (wait_time++ < max_wait_time) {
					getWlBssInfo(WLAN_IF, &bss);
					printf("[%s]-[%d] bss.state[%d]\n", WLAN_IF, wait_time, bss.state);
					if (bss.state == STATE_CONNECTED){
						break;
					}
					sleep(1);
				}
				if (wait_time > max_wait_time)
					status = 1;
			}
		}
		/* WNC-NMR0000-JOE-PENG-20141111-Make Linear repeater basic setting page "only save GUI settings", "not try connect" and "reboot immediately" by parameter "save_config_and_reboot=1"-end */

/* WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode - connect to next radio - Start */
		if(NUM_WLAN_INTERFACE == 2){
			/* WNC-NMR0000-JOE-PENG-20141111-Make Linear repeater basic setting page "only save GUI settings", "not try connect" and "reboot immediately" by parameter "save_config_and_reboot=1"-start */
			if (save_config_and_reboot!=1) {
				if (wlanif_both==1 && status==1 && try_cunt==0){
					//swap interface.
					if (!strcmp(wlanifp,"wlan0")){
					//	robk_profile_config_setting(&old_repeater_config_info); /* WNC-NMR786-[Linear]-Libera-20141008-fixed the function: Can be set value after connection failed --*/
						strcpy(wlanifp, "wlan1");
					}else if (!strcmp(wlanifp,"wlan1")){
					//	robk_profile_config_setting(&old_repeater_config_info); /* WNC-NMR786-[Linear]-Libera-20141008-fixed the function: Can be set value after connection failed --*/
						strcpy(wlanifp, "wlan0");
					}
					try_cunt=1;
					goto connect_next_radio;
				}
			} else {
				/* If save_config_and_reboot is 1 and wlanif_both is 1 (Save parameter to 2 radio), then always jump to next radio and save config */
				if (wlanif_both==1 && try_cunt==0){
					//swap interface.
					if (!strcmp(wlanifp,"wlan0")){
						strcpy(wlanifp, "wlan1");
					}else if (!strcmp(wlanifp,"wlan1")){
						strcpy(wlanifp, "wlan0");
					}
					try_cunt=1;
					goto connect_next_radio;
				}
			}
			/* WNC-NMR0000-JOE-PENG-20141111-Make Linear repeater basic setting page "only save GUI settings", "not try connect" and "reboot immediately" by parameter "save_config_and_reboot=1"-end */
		}
/* WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode - connect to next radio - End */

		/* WNC-NMR0000-JOE-PENG-20141111-Make Linear repeater basic setting page "only save GUI settings", "not try connect" and "reboot immediately" by parameter "save_config_and_reboot=1"-start */
		if (save_config_and_reboot==1) {
			/* Always set status to 0 (Connect successfully) if save_config_and_reboot is 1 */
			status = 0;
		}
		/* WNC-NMR0000-JOE-PENG-20141111-Make Linear repeater basic setting page "only save GUI settings", "not try connect" and "reboot immediately" by parameter "save_config_and_reboot=1"-end */

		if (status){	/* Connect failed */
			printf("\nConnect failed!.\n");
			system("rm -f /var/rptonnecting");
			/* WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode -Start */
			pMsg =  (unsigned char *)"ƵȤ̵LAN ³ǤޤǤ<br>ͤȿǤ[]ľ[]򲡤Ƥ";
			/* WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode - End */
//WNC-NMR875-JDR230-YUAN-I-CHOU-20141205, Remove "bring up VAP" here, conn_mgmt would handle it.
//#if 1	/* WNC-NMR758&760-[Linear]-Libera-20140916- on connecting (or disconnect), init wlan0-va0, and wlan1-va0 for issue deauth to client. */
#if 0
//WNC-NMR875-JDR230-YUAN-I-CHOU-20141205, Remove "bring up VAP" here, conn_mgmt would handle it End.
{
		if(NUM_WLAN_INTERFACE == 2){	//dual radio
			if (access("/tmp/MODE_RPT", F_OK) == 0) {	//RPT mode
					if (wlan0_disabled==0){
						system("ifconfig wlan0-va0 up");
					}
					if (wlan1_disabled==0){
						system("ifconfig wlan1-va0 up");
					}
			}
		}
}
#endif	/* WNC-NMR758&760-[Linear]-Libera-20140916- on connecting (or disconnect), init wlan0-va0, and wlan1-va0 for issue deauth to client.-end */

		}else{	/* Connect successfully */
			printf("\nConnect successfully! Please wait while rebooting.\n");
			//system("rm -f /var/rptonnecting");		/* WNC-NMR000-[Linear]-Libera-20140729- SPEC: Repeater mode - Step2 - connection management - keep IP until reboot*/
			pMsg =  (unsigned char *)"ƵưԤäƤޤƵưŸڤʤǤ"; /* WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode -Start */
			//submitUrl="/status.htm";	
			submitUrl=NULL;	//go to /index.htm  //Rita--
#if 1	/* WNC-NMR786-[Linear]-Libera-20141008-fixed the function: Can be set value after connection failed-start */
		if(NUM_WLAN_INTERFACE == 2){
			/* WNC-NMR0000-JOE-PENG-20141111-Make Linear repeater basic setting page "only save GUI settings", "not try connect" and "reboot immediately" by parameter "save_config_and_reboot=1"-start */
			/* If save_config_and_reboot is 1, we do not execute "try connection". */
			/* In this case, the GUI settings need to save to flash MIB of two radios if wlanif_both and try_cunt are 1 */
			if (save_config_and_reboot!=1) {
				if (wlanif_both==1 && try_cunt==1){ //unknown band to connect and two band has be tried 
					//Roll back another band's setting for avoiding same SSID between two band.
					if (!strcmp(wlanifp,"wlan0")){
						robk_profile_config_setting(&old_repeater_config_info,1);	/* WNC-NMR773-[Linear]-Libera-20141002- Specified SSID setting issue-not reflected at other setting */
					}else if (!strcmp(wlanifp,"wlan1")){
						robk_profile_config_setting(&old_repeater_config_info,0);	/* WNC-NMR773-[Linear]-Libera-20141002- Specified SSID setting issue-not reflected at other setting */
					}
				}
			}
			/* WNC-NMR0000-JOE-PENG-20141111-Make Linear repeater basic setting page "only save GUI settings", "not try connect" and "reboot immediately" by parameter "save_config_and_reboot=1"-end */
		}
#endif	/* WNC-NMR786-[Linear]-Libera-20141008-fixed the function: Can be set value after connection failed-end */
#if 0	/* WNC-NMR806 -[Linear]-Libera-20141022- modify behavior to meet bug806 case-start*/
#if 1	/* WNC-NMR000-[Linear]-Libera-20140729- SPEC: Repeater mode - Step2- band priority-start*/
			if(wlanif_both==0){	//detect AP (by site survey)
				int intVal = 0;
				int orig_wlan_idx=0;
				int orig_vwlan_idx=0;				
/* WNC-NMR730-[Linear]-Libera-20140808- MIB_WLAN_WSC_PRIORITY should get from wlanx-vxd-start*/
				orig_wlan_idx=wlan_idx;
				orig_vwlan_idx=vwlan_idx;		
				vwlan_idx=NUM_VWLAN_INTERFACE;
				apmib_get(MIB_WLAN_WSC_PRIORITY, (void *)&intVal);
				wlan_idx=orig_wlan_idx;
				vwlan_idx=orig_vwlan_idx;
/* WNC-NMR730-[Linear]-Libera-20140808- MIB_WLAN_WSC_PRIORITY should get from wlanx-vxd-end*/
				orig_wlan_idx=wlan_idx;
				orig_vwlan_idx=vwlan_idx;	
				if(intVal==2){/*5GHz*/
					if(!strcmp(wlanifp,"wlan0")){
						int count1=0;
						intVal=1;// 2G link, change to 2G
						/* Set WPS priority to vxd interface of each radio */
						for(count1=0;count1<NUM_WLAN_INTERFACE;count1++)
						{
							wlan_idx=count1;
							vwlan_idx = NUM_VWLAN_INTERFACE; // vxd interface
							apmib_set(MIB_WLAN_WSC_PRIORITY, (void *)&intVal);
						}
						wlan_idx=orig_wlan_idx;
						vwlan_idx=orig_vwlan_idx;
					}						
				}else{/*2GHz*/
					if(!strcmp(wlanifp,"wlan1")){
						int count1=0;
						intVal=2;// 5G link, change to 5G
						/* Set WPS priority to vxd interface of each radio */
						for(count1=0;count1<NUM_WLAN_INTERFACE;count1++)
						{
							wlan_idx=count1;
							vwlan_idx = NUM_VWLAN_INTERFACE; // vxd interface
							apmib_set(MIB_WLAN_WSC_PRIORITY, (void *)&intVal);
						}
						wlan_idx=orig_wlan_idx;
						vwlan_idx=orig_vwlan_idx;
					}
				}
				
			}
#endif	/* WNC-NMR000-[Linear]-Libera-20140729- SPEC: Repeater mode - Step2- band priority-end*/
#endif	/* WNC-NMR806 -[Linear]-Libera-20141022- modify behavior to meet bug806 case-end*/
#if 1	/* WNC-NMR000-[Linear]-Libera-20140729- SPEC: Repeater mode - Step2-copy to wlanx-va1(STA I/F)*/
			if (access("/tmp/MODE_RPT", F_OK) == 0) {		//Repeater mode
				int orig_wlan_idx=0;
				int orig_vwlan_idx=0;
				orig_wlan_idx=wlan_idx;
				orig_vwlan_idx=vwlan_idx;

				/* setting for wlan0-va1(Real)--[mapping]--wlan0-va0(GUI) */ 		
				fprintf(stderr, "@ Connection OK --> copy %s-vxd to %s-va1 @\n",wlanifp,wlanifp);
				if (!strcmp(wlanifp,"wlan0")){
					wlan_idx=0;
					vwlan_idx=2;
				}else if (!strcmp(wlanifp,"wlan1")){;
					wlan_idx=1;
					vwlan_idx=2;					
				}

				if(val == ENCRYPT_DISABLED)	 /* WNC-NMR726-[Linear]-Libera-20140819- spec. issue - copy NoEncryption and ssid to wlanX-va0 */
				{
						ENCRYPT_T encrypt = ENCRYPT_DISABLED;
						apmib_set( MIB_WLAN_ENCRYPT, (void *)&encrypt);
				}
				else if(val > ENCRYPT_WEP && val <= ENCRYPT_WPA2_MIXED)
				{
						//if(wpaHandler(wp, tmpBuf, wlan_idx) < 0)
						if(wpaHandler(wp, tmpBuf, 0) < 0)	/*WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode: Concurrent SS 2G/5G */
						{
								goto ss_err;
						}
									
						int intVal=0;
#if 0	//security type judged by GUI
						strVal = req_get_cstream_var(wp, "ciphersuite_4_staif", "");						
											
							if (!strcmp(strVal, "WPA/WPA2-PSK(TKIP/AES)")){
								intVal =   WPA_CIPHER_MIXED; 
								ENCRYPT_T encrypt = ENCRYPT_WPA2_MIXED;
								apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&intVal);
								apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&intVal);
								apmib_set(MIB_WLAN_ENCRYPT, (void *)&encrypt);
							} else if (!strcmp(strVal, "WPA/WPA2-PSK(AES)")){
								intVal =   WPA_CIPHER_AES;
								ENCRYPT_T encrypt = ENCRYPT_WPA2_MIXED;
								apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&intVal);
								apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&intVal);
								apmib_set(MIB_WLAN_ENCRYPT, (void *)&encrypt);
							} else if (!strcmp(strVal, "WPA2-PSK(AES)")){
								intVal =   WPA_CIPHER_AES;
								ENCRYPT_T encrypt = ENCRYPT_WPA2;
								apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&intVal);
								apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&intVal);
								apmib_set(MIB_WLAN_ENCRYPT, (void *)&encrypt);
							}					
#else	//security type judged by driver		/* WNC-NMR000-[Linear]-Libera-20140729- SPEC: Repeater mode - Step2 - target AP security type -start*/
						/* WNC-NMR0000-JOE-PENG-20141111-Make Linear repeater basic setting page "only save GUI settings", "not try connect" and "reboot immediately" by parameter "save_config_and_reboot=1"-start */
						if (save_config_and_reboot!=1) {
							//security type judged by driver
							if (val == ENCRYPT_WPA2_MIXED){ 	//GUI-AP I/F
								/*WPA/WPA2-PSK(TKIP/AES)*/
								intVal =   WPA_CIPHER_MIXED; 
								ENCRYPT_T encrypt = ENCRYPT_WPA2_MIXED;
								apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&intVal);
								apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&intVal);
								apmib_set(MIB_WLAN_ENCRYPT, (void *)&encrypt);							
								printf("[%s]: WPA/WPA2-PSK(TKIP/AES), Line: %d\n",__FUNCTION__, __LINE__);
							} else if (val == ENCRYPT_WPA2){	//GUI-AP I/F$
								printf("[%s]: dot11EnablePSK=%d, dot11WPA2Cipher=%d, dot11WPACipher=%d @@\n",__FUNCTION__,bss.dot11EnablePSK,bss.dot11WPA2Cipher,bss.dot11WPACipher);
							
								//Target AP security type
								if (bss.dot11EnablePSK==3 && bss.dot11WPA2Cipher==10 && bss.dot11WPACipher==10){	//WPA/WPA2-PSK(TKIP/AES)
									/*WPA/WPA2-PSK(AES)*/
									intVal =   WPA_CIPHER_AES;
									ENCRYPT_T encrypt = ENCRYPT_WPA2_MIXED;
									apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&intVal);
									apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&intVal);
									apmib_set(MIB_WLAN_ENCRYPT, (void *)&encrypt);
									printf("[%s]: WPA/WPA2-PSK(AES), Line: %d\n",__FUNCTION__, __LINE__);
								} else if (bss.dot11EnablePSK==3 && bss.dot11WPA2Cipher==8 && bss.dot11WPACipher==8){	//WPA/WPA2-PSK(AES)
									/*WPA/WPA2-PSK(AES)*/
									intVal =   WPA_CIPHER_AES;
									ENCRYPT_T encrypt = ENCRYPT_WPA2_MIXED;
									apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&intVal);
									apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&intVal);
									apmib_set(MIB_WLAN_ENCRYPT, (void *)&encrypt);
									printf("[%s]: WPA/WPA2-PSK(AES), Line: %d\n",__FUNCTION__, __LINE__);
								} else if (bss.dot11EnablePSK==2 && bss.dot11WPA2Cipher==8 && bss.dot11WPACipher==0){	//WPA2-PSK(AES)
									/*WPA2-PSK(AES)*/
									intVal =   WPA_CIPHER_AES;
									ENCRYPT_T encrypt = ENCRYPT_WPA2;
									apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&intVal);
									apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&intVal);
									apmib_set(MIB_WLAN_ENCRYPT, (void *)&encrypt);
									printf("[%s]: libera: WPA2-PSK(AES), Line: %d\n",__FUNCTION__, __LINE__);
								}
							}
						} else {
							//security type judged by GUI

							/* If save_config_and_reboot is 1, we do not execute "Try connection". so security type is judged by GUI setting */
							strVal = req_get_cstream_var(wp, "ciphersuite_4_staif", "");						
											
							if (!strcmp(strVal, "WPA/WPA2-PSK(TKIP/AES)")){
								intVal =   WPA_CIPHER_MIXED; 
								ENCRYPT_T encrypt = ENCRYPT_WPA2_MIXED;
								apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&intVal);
								apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&intVal);
								apmib_set(MIB_WLAN_ENCRYPT, (void *)&encrypt);
							} else if (!strcmp(strVal, "WPA/WPA2-PSK(AES)")){
								intVal =   WPA_CIPHER_AES;
								ENCRYPT_T encrypt = ENCRYPT_WPA2_MIXED;
								apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&intVal);
								apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&intVal);
								apmib_set(MIB_WLAN_ENCRYPT, (void *)&encrypt);
							} else if (!strcmp(strVal, "WPA2-PSK(AES)")){
								intVal =   WPA_CIPHER_AES;
								ENCRYPT_T encrypt = ENCRYPT_WPA2;
								apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&intVal);
								apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&intVal);
								apmib_set(MIB_WLAN_ENCRYPT, (void *)&encrypt);
							}
						}
						/* WNC-NMR0000-JOE-PENG-20141111-Make Linear repeater basic setting page "only save GUI settings", "not try connect" and "reboot immediately" by parameter "save_config_and_reboot=1"-end */
#endif	/* WNC-NMR000-[Linear]-Libera-20140729- SPEC: Repeater mode - Step2 - target AP security type -end*/
					//	apmib_set(MIB_WLAN_SSID, (void *)strSSID);	 /* WNC-NMR726-[Linear]-Libera-20140819- spec. issue - copy NoEncryption and ssid to wlanX-va0 */		
				}
				apmib_set(MIB_WLAN_SSID, (void *)strSSID);	 /* WNC-NMR726-[Linear]-Libera-20140819- spec. issue - copy NoEncryption and ssid to wlanX-va0 */
				wlan_idx=orig_wlan_idx;
				vwlan_idx=orig_vwlan_idx;						
			}
#else /*Cheeper*/	//if vxd connection is successful copy wlan0-vxd value to wlan0
								/* setting for wlan0 */ 		
								//fprintf(stderr, "@connection OK --> copy vxd to wlan0 @, vwlan_idx=%d\n",vwlan_idx);
								if(val == ENCRYPT_DISABLED)
								{
										ENCRYPT_T encrypt = ENCRYPT_DISABLED;
										apmib_set( MIB_WLAN_ENCRYPT, (void *)&encrypt);
								}
								else if(val == ENCRYPT_WEP)
								{
										//if(wepHandler(wp, tmpBuf, wlan_idx) < 0)
										if(wepHandler(wp, tmpBuf, 0) < 0)	/*WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode: Concurrent SS 2G/5G */
										{
												goto ss_err;
										}
								}
								else if(val > ENCRYPT_WEP && val <= ENCRYPT_WPA2_MIXED)
								{
										//if(wpaHandler(wp, tmpBuf, wlan_idx) < 0)
										if(wpaHandler(wp, tmpBuf, 0) < 0)	/*WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode: Concurrent SS 2G/5G */
										{
												goto ss_err;
										}
										int intVal;
										ENCRYPT_T encrypt = ENCRYPT_WPA2_MIXED;
										intVal =   WPA_CIPHER_MIXED;	/* WNC-NMR0272-Libera-20121217-add default setting for CIPHER =auto */
										apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&intVal);
										apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&intVal);
										apmib_set(MIB_WLAN_ENCRYPT, (void *)&encrypt);										
								}
							//	strcat(strSSID,"-ext"); //add SSID head
								apmib_set(MIB_WLAN_SSID, (void *)strSSID);
#endif
#if 1 /* WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode - control alive interface - Start */
			int fun_off=0;
			char terminal_if[16], use_if[16];
			if(NUM_WLAN_INTERFACE == 2){
				if (status!=1){	/* Connect successfully */
					if(rptEnabled==1 && funcoff==1){	//converter mode or RPT mode
						if (!strcmp(wlanifp,"wlan0")){			//use wlan0-vxd
							strcpy(terminal_if,"wlan1-vxd");	//fun_off wlan1-vxd
						}else if (!strcmp(wlanifp,"wlan1")){	//use wlan1-vxd
							strcpy(terminal_if,"wlan0-vxd");	//fun_off wlan0-vxd
						}else{
							goto unknowif;
						}
						ori_vwlan_idx=vwlan_idx;
						wlan_orig = wlan_idx;

						sprintf(use_if, "%s-vxd", wlanifp);
						SetWlan_idx(use_if);
						fun_off=0;	//interface on
						apmib_set( MIB_WLAN_FUNC_OFF,  (void *)&fun_off);
						
						SetWlan_idx(terminal_if);
						fun_off=1;	//interface close
						apmib_set( MIB_WLAN_FUNC_OFF,  (void *)&fun_off);

						wlan_idx = wlan_orig;
						vwlan_idx = ori_vwlan_idx;
					}
				}
			}
			unknowif:
#endif
#if 1	//method 2 of auto channel 
			channelIdx=0;	//Cheeper spec. for wlan0 auto channel
			apmib_set( MIB_WLAN_CHANNEL,  (void *)&channelIdx);
			apmib_update_web(CURRENT_SETTING);
			//apmib_update(CURRENT_SETTING);
#endif											
		}
#endif

#if defined(CONFIG_POCKET_AP_SUPPORT)
			if(!status)
			{
				pMsg = "Connect successfully! Please wait while rebooting.";
				OK_MSG1(pMsg, submitUrl);
				sleep(2);
				system("reboot");
			}
#elif defined(CONFIG_POCKET_ROUTER_SUPPORT) || defined(CONFIG_RTL_ULINKER)
			{
#ifndef NO_ACTION
				run_init_script("all");
#endif
				REBOOT_WAIT("/wizard.htm");
				//REBOOT_WAIT("/wlsurvey.htm");

			}
#else
			{
				/* WNC-MR0000-Rita-20121130-reboot countDown page when repeater is connected */
				/* WNC-NMR0000-JOE-PENG-20140606-Correct messages of converter mode site survey page according to section 4.4.36 of Linear Spec. V1.1.0-start */
				if(!status){ //connected
					//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140916, Fix bug 2701 (UNINIT) in StaticCodeCheck_Linear_Delta1.xls
					//char lan_ip_buf[30];
					char lan_ip_buf[30] = {0};
					char lan_ip[30];
					int reboot_wait = 50;	
					/* WNC-NMR0000-JOE-PENG-20140724-Implemen section 4.4.38 site survey page of Linear step 2 (repeater mode) */
					//int wifi_mode=WIFI_MODE_AP;

					apmib_get( MIB_IP_ADDR,  (void *)lan_ip_buf) ;
					sprintf(lan_ip,"%s",inet_ntoa(*((struct in_addr *)lan_ip_buf)) );

					/* WNC-NMR0000-JOE-PENG-20140724-Implemen section 4.4.38 site survey page of Linear step 2 (repeater mode)-start */
#if 1
					OK_MSG_BEBOOT_CONVERTER(pMsg,submitUrl,reboot_wait,lan_ip);
#else
					if (lw_get_wifi_mode(&wifi_mode) == 1) {
						if (wifi_mode==WIFI_MODE_CLIENT) {
							OK_MSG_BEBOOT_CONVERTER(pMsg,submitUrl,reboot_wait,lan_ip);
						} else {
							OK_MSG_BEBOOT_RP(pMsg,submitUrl,reboot_wait,lan_ip);
						}
					} else {
						OK_MSG_BEBOOT_RP(pMsg,submitUrl,reboot_wait,lan_ip); 
					}
#endif
					/* WNC-NMR0000-JOE-PENG-20140724-Implemen section 4.4.38 site survey page of Linear step 2 (repeater mode)-end */
					reboot_device();
				} else { //disconnected
					/* WNC-NMR0000-JOE-PENG-20140813-Fix bug that site survey page does not recover old setting value if Wi-Fi vxd inerface connection fails and user chooses recovering setting-start */
#if 1
					ERR_MSG1_CONVERTER(pMsg, submitUrl);
#else
					int wifi_mode=WIFI_MODE_AP;
					
					if (lw_get_wifi_mode(&wifi_mode) == 1) {
						if (wifi_mode==WIFI_MODE_CLIENT) {
							ERR_MSG1_CONVERTER(pMsg, submitUrl); 
						} else {
							OK_MSGs(pMsg, submitUrl); 
						}
					} else {
						OK_MSGs(pMsg, submitUrl); 
					}
#endif

					/* Save new repeater setting after repeater connection test fail */
					save_repeater_config_setting(&new_repeater_config_info);

					/* Set old repeater setting after repeater connection test fail */
					set_repeater_config_setting(&old_repeater_config_info);

					/* killall conn_mgmt before restart wlanX-vxd interface */
					system("killall conn_mgmt");

					/* Restart wlanX-vxd interface */
					{
						int count1=0;
						char temp_command[50]={0};

						for(count1=0;count1<NUM_WLAN_INTERFACE;count1++) {
							sprintf(temp_command,"ifconfig wlan%d-vxd down",count1);
							system(temp_command);
						}

						for(count1=0;count1<NUM_WLAN_INTERFACE;count1++) {
							sprintf(temp_command,"flash set_mib wlan%d-vxd",count1);
							system(temp_command);
						}

						for(count1=0;count1<NUM_WLAN_INTERFACE;count1++) {
							sprintf(temp_command,"ifconfig wlan%d-vxd up",count1);
							system(temp_command);
						}
					}
					/* WNC-NMR0000-JOE-PENG-20140813-Fix bug that site survey page does not recover old setting value if Wi-Fi vxd inerface connection fails and user chooses recovering setting-end */

					/* WNC-NMR0000-JOE-PENG-20140724-Implemen section 4.4.38 site survey page of Linear step 2 (repeater mode)-start */

					/* WNC-NMR0000-JOE-PENG-20140813-Fix bug that site survey page does not recover old setting value if Wi-Fi vxd inerface connection fails and user chooses recovering setting-start */
					/* Restart Wi-Fi driver according to original setting */
					/* _Start_Wlan_Applications() will also execute command "conn_mgmt&". */
					_Start_Wlan_Applications(); 
					//system("conn_mgmt&");	/* WNC-NMR000-[Linear]-Libera-20140729- SPEC: Repeater mode - Step2 - connection management*/
					/* WNC-NMR0000-JOE-PENG-20140813-Fix bug that site survey page does not recover old setting value if Wi-Fi vxd inerface connection fails and user chooses recovering setting-end */
					/* WNC-NMR0000-JOE-PENG-20140724-Implemen section 4.4.38 site survey page of Linear step 2 (repeater mode)-end */

					/* WNC-NMR000-[Linear]-Libera-20140729- SPEC: Repeater mode - Step2 - connection management (Force DHCP)-start */
					struct stat status;
					if (stat(FORCE_DHCP_S, &status) == 0){
						system("iwpriv wlan0-vxd set_mib func_off=1");
						if(NUM_WLAN_INTERFACE == 2){
							system("iwpriv wlan1-vxd set_mib func_off=1");
						}
					}
					/* WNC-NMR000-[Linear]-Libera-20140729- SPEC: Repeater mode - Step2 - connection management (Force DHCP)-end */
				}
				/* WNC-NMR0000-JOE-PENG-20140606-Correct messages of converter mode site survey page according to section 4.4.36 of Linear Spec. V1.1.0-end */
				/* WNC-MR0000-Rita-2012113-End */
			}
#endif
	//	}	/* MR233-libera-20121208 - modify next button rule*/
#if defined(CONFIG_CHEEPER_REPEATER)	/*recover wlan0 interface*/
		if(nec_rpt_vxd)
		{
			char*ptmp;
			SetWlan_idx(wlanifp_bak);			
			ptmp=strstr(WLAN_IF,"-vxd");
			if(ptmp)
				memset(ptmp,0,sizeof(char)*strlen("-vxd"));
		}
#endif
	}
#endif	
	return;

ss_err:
	ERR_MSG(tmpBuf);
}

/* WNC-NMR0000-JOE-PENG-20140606-Correct messages of converter mode site survey page according to section 4.4.36 of Linear Spec. V1.1.0-start */
/* This form is used to save converter mode related MIB and reboot device */
void formWlWncSiteSurveyReboot(request *wp, char *path, char *query)
{
	//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140916, Fix bug 2553 (UNINIT) in StaticCodeCheck_Linear_Delta1.xls
	//char lan_ip_buf[30];
	char lan_ip_buf[30] = {0};
	char lan_ip[30];
	int reboot_wait = 50;	
	/* WNC-NMR0000-JOE-PENG-20140724-Implemen section 4.4.38 site survey page of Linear step 2 (repeater mode) */
	//int wifi_mode=WIFI_MODE_AP;
 	char *submitUrl;
	unsigned char *pMsg=NULL;
	char tmpBuf[100];

	/* WNC-NMR0000-JOE-PENG-20140813-Fix bug that site survey page does not recover old setting value if Wi-Fi vxd inerface connection fails and user chooses recovering setting-start */
	/* Set new repeater setting after repeater connection test fail and user still want to save setting and reboot */
	set_repeater_config_setting(&new_repeater_config_info);
	/* WNC-NMR0000-JOE-PENG-20140813-Fix bug that site survey page does not recover old setting value if Wi-Fi vxd inerface connection fails and user chooses recovering setting-end */

	submitUrl = req_get_cstream_var(wp, ("submit-url"), "");

	/* Set response message and reboot device */
	system("rm -f /var/rptonnecting");
	pMsg =  (unsigned char *)"ƵưԤäƤޤƵưŸڤʤǤ";
	
	apmib_get( MIB_IP_ADDR,  (void *)lan_ip_buf) ;
	sprintf(lan_ip,"%s",inet_ntoa(*((struct in_addr *)lan_ip_buf)) );
	
/* WNC-NMR0000-JOE-PENG-20140724-Implemen section 4.4.38 site survey page of Linear step 2 (repeater mode)-start */
#if 1
	OK_MSG_BEBOOT_CONVERTER(pMsg,submitUrl,reboot_wait,lan_ip);
#else
	if (lw_get_wifi_mode(&wifi_mode) == 1) {
		if (wifi_mode==WIFI_MODE_CLIENT) {
			OK_MSG_BEBOOT_CONVERTER(pMsg,submitUrl,reboot_wait,lan_ip);
		} else {
			OK_MSG_BEBOOT_RP(pMsg,submitUrl,reboot_wait,lan_ip);
		}
	} else {
		OK_MSG_BEBOOT_RP(pMsg,submitUrl,reboot_wait,lan_ip); 
	}
#endif
/* WNC-NMR0000-JOE-PENG-20140724-Implemen section 4.4.38 site survey page of Linear step 2 (repeater mode)-end */
	reboot_device();

	return;
}
/* WNC-NMR0000-JOE-PENG-20140606-Correct messages of converter mode site survey page according to section 4.4.36 of Linear Spec. V1.1.0-end */

/* WNC-Rita-20121205-hidden page for repeater WLAN setting */	/* WNC-MR0000-[Voyager]-Libera-20131210- repeater mode */
void formWlWncWlan(request *wp, char *path, char *query)
{
 	char *submitUrl,*tmpStr;
	char varName[20];
	char tmpBuf[100];
	int val;

	submitUrl = req_get_cstream_var(wp, ("submit-url"), "");

	//SSID
	sprintf(varName, "ssid0");
   	tmpStr = req_get_cstream_var(wp, varName, "");
	if ( tmpStr[0] ) {
		if ( apmib_set(MIB_WLAN_SSID, (void *)tmpStr) == 0) {
   	 			strcpy(tmpBuf, ("Set SSID error!"));
				goto setErr_wlan;
		}
	}

	//Encryption
	sprintf(varName, "method00");
	tmpStr = req_get_cstream_var(wp, varName, "");
	if(tmpStr[0])
	{
		val = atoi(tmpStr);
		if(val == ENCRYPT_DISABLED)
			{
				ENCRYPT_T encrypt = ENCRYPT_DISABLED;
				apmib_set( MIB_WLAN_ENCRYPT, (void *)&encrypt);
			}
			else if(val == ENCRYPT_WEP)
			{
				if(wepWncHandler(wp, tmpBuf, 0) < 0)
				{
					goto setErr_wlan;
				}
			}
			else if(val > ENCRYPT_WEP && val <= WSC_AUTH_WPA2PSKMIXED)
			{
				if(wpaWncHandler(wp, tmpBuf, 0) < 0)
				{
					goto setErr_wlan;
				}
			}
	}

////////////
	apmib_update_web(CURRENT_SETTING);

#ifndef NO_ACTION
	run_init_script("all");
#endif

	submitUrl = req_get_cstream_var(wp, ("wlan-url"), "");   // hidden page
		OK_MSG(submitUrl);
	return ;
setErr_wlan:
fprintf(stderr, "###ERROR:=%s###\n", tmpBuf);
	ERR_MSG(tmpBuf);
	return ;

PopupErr_WncWlan:
	POP_ERR_MSG(tmpBuf);
	return ;

}

#endif

/////////////////////////////////////////////////////////////////////////////
int wlSiteSurveyTbl(request *wp, int argc, char **argv)
{
	int nBytesSent=0, i;
#ifdef CONFIG_RTK_MESH 
	int mesh_enable = 0; 
    char meshidbuf[40];
#endif 
	BssDscr *pBss;
	char tmpBuf[MAX_MSG_BUFFER_SIZE], ssidbuf[40], tmp1Buf[10], tmp2Buf[20], wpa_tkip_aes[20],wpa2_tkip_aes[20], tmp3Buf[128];
	WLAN_MODE_T mode;
	bss_info bss;

	if (pStatus==NULL) {
		pStatus = calloc(1, sizeof(SS_STATUS_T));
		if ( pStatus == NULL ) {
			printf("Allocate buffer failed!\n");
			return 0;
		}
	}

	pStatus->number = 0; // request BSS DB

	if ( getWlSiteSurveyResult(WLAN_IF, pStatus) < 0 ) {
		//ERR_MSG("Read site-survey status failed!");
		req_format_write(wp, "Read site-survey status failed!");
		free(pStatus); //sc_yang
		pStatus = NULL;
		return 0;
	}

	if ( !apmib_get( MIB_WLAN_MODE, (void *)&mode) ) {
		printf("Get MIB_WLAN_MODE MIB failed!");
		return 0;
	}
#ifdef CONFIG_RTK_MESH
    if(mode == AP_MESH_MODE || mode == MESH_MODE) {
        if( !apmib_get( MIB_WLAN_MESH_ENABLE, (void *)&mesh_enable) ) {
    		return 0;
    	}
    }
#endif
	if ( getWlBssInfo(WLAN_IF, &bss) < 0) {
		printf("Get bssinfo failed!");
		return 0;
	}

// ==== inserted by GANTOE for site survey 2008/12/26 ==== 
//#ifdef CONFIG_RTK_MESH
#if 0
	if(mesh_enable) 
	{ 
		nBytesSent += req_format_write(wp, ("<tr>" 
		"<td align=center width=\"30%%\" bgcolor=\"#808080\"><font size=\"2\"><b>MESHID</b></font></td>\n" 
		"<td align=center width=\"20%%\" bgcolor=\"#808080\"><font size=\"2\"><b>MAC ADDR</b></font></td>\n" 
		"<td align=center width=\"10%%\" bgcolor=\"#808080\"><font size=\"2\"><b>Channel</b></font></td>\n")); 
		nBytesSent += req_format_write(wp, ("<td align=center width=\"10%%\" bgcolor=\"#808080\"><font size=\"2\"><b>Select</b></font></td></tr>\n")); 

		for (i=0; i<pStatus->number && pStatus->number!=0xff; i++) 
		{ 
			pBss = &pStatus->bssdb[i]; 
			if(pBss->bdMeshId.Length == 0)
				continue; 

			memcpy(meshidbuf, pBss->bdMeshIdBuf - 2, pBss->bdMeshId.Length); // the problem of padding still exists 
			meshidbuf[pBss->bdMeshId.Length] = '\0'; 

			snprintf(tmpBuf, 200, ("%02x:%02x:%02x:%02x:%02x:%02x"), 
				pBss->bdBssId[0], pBss->bdBssId[1], pBss->bdBssId[2], 
				pBss->bdBssId[3], pBss->bdBssId[4], pBss->bdBssId[5]); 
			memcpy(ssidbuf, pBss->bdSsIdBuf, pBss->bdSsId.Length); 
			ssidbuf[pBss->bdSsId.Length] = '\0'; 
			
			nBytesSent += req_format_write(wp, ("<tr>" 
				"<td align=left width=\"30%%\" bgcolor=\"#C0C0C0\"><pre><font size=\"2\">%s</td>\n" 
				"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n" 
				"<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%d</td>\n"), 
				meshidbuf, tmpBuf, pBss->ChannelNumber); 
            
			nBytesSent += req_format_write(wp, 
			("<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\"><input type=\"radio\" name=" 
				"\"select\" value=\"sel%d\" onClick=\"enableConnect()\"></td></tr>\n"), i); 
		} 
	} 
	else 
#endif 
	{ 
		int rptEnabled=0;
#if defined(CONFIG_SMART_REPEATER)
		int opmode=0;
		apmib_get(MIB_OP_MODE, (void *)&opmode);
#endif
		if(wlan_idx == 0)
			apmib_get(MIB_REPEATER_ENABLED1, (void *)&rptEnabled);
		else
			apmib_get(MIB_REPEATER_ENABLED2, (void *)&rptEnabled);
		
	nBytesSent += req_format_write(wp, ("<tr class=\"tbl_head\">"
	"<td align=center width=\"30%%\" ><font size=\"2\"><b>SSID</b></font></td>\n"
	"<td align=center width=\"20%%\" ><font size=\"2\"><b>BSSID</b></font></td>\n"
	"<td align=center width=\"10%%\" ><font size=\"2\"><b>Channel</b></font></td>\n"
      	"<td align=center width=\"20%%\" ><font size=\"2\"><b>Type</b></font></td>\n"
      	"<td align=center width=\"10%%\" ><font size=\"2\"><b>Encrypt</b></font></td>\n"
	"<td align=center width=\"10%%\" ><font size=\"2\"><b>Signal</b></font></td>\n"));
	if( (mode == CLIENT_MODE )
#if defined(CONFIG_RTL_ULINKER)
		|| ((mode == AP_MODE || mode == AP_WDS_MODE) && rptEnabled == 1)
#endif
#if defined(CONFIG_SMART_REPEATER)
		||( ((mode == AP_MODE) || mode == AP_WDS_MODE || mode == AP_MESH_MODE || mode == MESH_MODE) && (rptEnabled == 1) 
		//&& (opmode == WISP_MODE)
	)
#endif
	)
	{
		nBytesSent += req_format_write(wp, ("<td align=center width=\"10%%\"><font size=\"2\"><b>Select</b></font></td></tr>\n"));
	}
	else
		nBytesSent += req_format_write(wp, ("</tr>\n"));

	for (i=0; i<pStatus->number && pStatus->number!=0xff; i++) {
		pBss = &pStatus->bssdb[i];
		snprintf(tmpBuf, 200, ("%02x:%02x:%02x:%02x:%02x:%02x"),
			pBss->bdBssId[0], pBss->bdBssId[1], pBss->bdBssId[2],
			pBss->bdBssId[3], pBss->bdBssId[4], pBss->bdBssId[5]);

		memcpy(ssidbuf, pBss->bdSsIdBuf, pBss->bdSsId.Length);
		ssidbuf[pBss->bdSsId.Length] = '\0';
		translateChar(ssidbuf,tmp3Buf,sizeof(tmp3Buf));

#if defined(CONFIG_RTK_MESH)
        if(mesh_enable) {
            if(pBss->bdSsId.Length == 0) {
                continue;
            }        
        }
#endif


		if (pBss->network==BAND_11B)
			strcpy(tmp1Buf, (" (B)"));
		else if (pBss->network==BAND_11G)
			strcpy(tmp1Buf, (" (G)"));	
		else if (pBss->network==(BAND_11G|BAND_11B))
			strcpy(tmp1Buf, (" (B+G)"));
		else if (pBss->network==(BAND_11N))
			strcpy(tmp1Buf, (" (N)"));		
		else if (pBss->network==(BAND_11G|BAND_11N))
			strcpy(tmp1Buf, (" (G+N)"));	
		else if (pBss->network==(BAND_11G|BAND_11B | BAND_11N))
			strcpy(tmp1Buf, (" (B+G+N)"));	
		else if(pBss->network== BAND_11A)
			strcpy(tmp1Buf, (" (A)"));
		else if(pBss->network== (BAND_11A | BAND_11N))
			strcpy(tmp1Buf, (" (A+N)"));	
		else if(pBss->network== (BAND_5G_11AC | BAND_11N))
			strcpy(tmp1Buf, (" (AC+N)"));	
		else if(pBss->network== (BAND_11A | BAND_5G_11AC))
			strcpy(tmp1Buf, (" (A+AC)"));							
		else if(pBss->network== (BAND_11A |BAND_11N | BAND_5G_11AC))
			strcpy(tmp1Buf, (" (A+N+AC)"));	
		else if(pBss->network == (BAND_11B | BAND_11G | BAND_11N | BAND_5G_11AC))
			strcpy(tmp1Buf,("(B+G+N+AC)"));
		else
			sprintf(tmp1Buf, (" -%d-"),pBss->network);

		memset(wpa_tkip_aes,0x00,sizeof(wpa_tkip_aes));
		memset(wpa2_tkip_aes,0x00,sizeof(wpa2_tkip_aes));
		
		if ((pBss->bdCap & cPrivacy) == 0)
			sprintf(tmp2Buf, "no");
		else {
			if (pBss->bdTstamp[0] == 0)
				sprintf(tmp2Buf, "WEP");
#if defined(CONFIG_RTL_WAPI_SUPPORT)
			else if (pBss->bdTstamp[0] == SECURITY_INFO_WAPI)
				sprintf(tmp2Buf, "WAPI");
#endif
			else {
				int wpa_exist = 0, idx = 0;
				if (pBss->bdTstamp[0] & 0x0000ffff) {
					idx = sprintf(tmp2Buf, "WPA");
					if (((pBss->bdTstamp[0] & 0x0000f000) >> 12) == 0x4)
						idx += sprintf(tmp2Buf+idx, "-PSK");
					else if(((pBss->bdTstamp[0] & 0x0000f000) >> 12) == 0x2)
						idx += sprintf(tmp2Buf+idx, "-1X");
					wpa_exist = 1;

					if (((pBss->bdTstamp[0] & 0x00000f00) >> 8) == 0x5)
						sprintf(wpa_tkip_aes,"%s","aes/tkip");
					else if (((pBss->bdTstamp[0] & 0x00000f00) >> 8) == 0x4)
						sprintf(wpa_tkip_aes,"%s","aes");
					else if (((pBss->bdTstamp[0] & 0x00000f00) >> 8) == 0x1)
						sprintf(wpa_tkip_aes,"%s","tkip");
				}
				if (pBss->bdTstamp[0] & 0xffff0000) {
					if (wpa_exist)
						idx += sprintf(tmp2Buf+idx, "/");
					idx += sprintf(tmp2Buf+idx, "WPA2");
					if (((pBss->bdTstamp[0] & 0xf0000000) >> 28) == 0x4)
						idx += sprintf(tmp2Buf+idx, "-PSK");
					else if (((pBss->bdTstamp[0] & 0xf0000000) >> 28) == 0x2)
						idx += sprintf(tmp2Buf+idx, "-1X");

					if (((pBss->bdTstamp[1]&0x600)==0x600) || ((pBss->bdTstamp[1]&0x600)==0x400)){
						idx += sprintf(tmp2Buf+idx, "-PMF");
					}
					
					if (((pBss->bdTstamp[0] & 0x0f000000) >> 24) == 0x5)
						sprintf(wpa2_tkip_aes,"%s","aes/tkip");
					else if (((pBss->bdTstamp[0] & 0x0f000000) >> 24) == 0x4)
						sprintf(wpa2_tkip_aes,"%s","aes");
					else if (((pBss->bdTstamp[0] & 0x0f000000) >> 24) == 0x1)
						sprintf(wpa2_tkip_aes,"%s","tkip");
				}
			}
		}

#if 0
		if( mesh_enable && (pBss->bdMeshId.Length > 0) )
		{
			nBytesSent += req_format_write(wp, ("<tr>"
			"<td align=left width=\"20%%\" bgcolor=\"#C0C0C0\"><pre><font size=\"2\">%s</td>\n"
			"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
			"<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%d%s</td>\n"     
      			"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
			"<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
			"<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%d</td>\n"),
			ssidbuf, tmpBuf, pBss->ChannelNumber, tmp1Buf, "Mesh Node", tmp2Buf, pBss->rssi);
		}
		else
#endif
		{
			nBytesSent += req_format_write(wp, ("<tr class=\"tbl_body\">"
			"<td align=center width=\"20%%\" ><font size=\"2\">%s</td>\n"
			"<td align=center width=\"20%%\" ><font size=\"2\">%s</td>\n"
			"<td align=center width=\"10%%\" ><font size=\"2\">%d%s</td>\n"     
      			"<td align=center width=\"20%%\" ><font size=\"2\">%s</td>\n"
			"<td align=center width=\"10%%\" ><font size=\"2\">%s</td>\n"
			"<td align=center width=\"10%%\" ><font size=\"2\">%d</td>\n"),
			tmp3Buf, tmpBuf, pBss->ChannelNumber, tmp1Buf,
			((pBss->bdCap & cIBSS) ? "Ad hoc" : "AP"), tmp2Buf, pBss->rssi);
		}

		if( ( mode == CLIENT_MODE )
#if defined(CONFIG_RTL_ULINKER)
		|| ((mode == AP_MODE || mode == AP_WDS_MODE) && rptEnabled == 1)
#endif
#if defined(CONFIG_SMART_REPEATER)
		||((mode == AP_MODE || mode == AP_WDS_MODE || mode == AP_MESH_MODE || mode == MESH_MODE) && (rptEnabled == 1) 
		//&& (opmode == WISP_MODE)
		)
#endif

		)
		{
			//use bssid, not ssid, and we will transfer bssid to ssid in formWlSiteSurvey()
			//because if ssid contains ", getElementById() will cut off the string after "
			nBytesSent += req_format_write(wp,
			("<td align=center width=\"10%%\" <input type=\"hidden\" id=\"realSSID_%d\" value=\"%s\"> <input type=\"hidden\" id=\"selSSID_%d\" value=\"%s\" > <input type=\"hidden\" id=\"selChannel_%d\" value=\"%d\" > <input type=\"hidden\" id=\"selEncrypt_%d\" value=\"%s\" > <input type=\"hidden\" id=\"wpa_tkip_aes_%d\" value=\"%s\" > <input type=\"hidden\" id=\"wpa2_tkip_aes_%d\" value=\"%s\" > <input type=\"radio\" name="
//			"\"select\" value=\"sel%d\" onClick=\"enableConnect(%d, 0)\"></td></tr>\n"), i,ssidbuf,i,pBss->ChannelNumber,i,tmp2Buf,i,wpa_tkip_aes,i,wpa2_tkip_aes ,i,i);			
			"\"select\" value=\"sel%d\" onClick=\"enableConnect(%d, 0, %d)\"></td></tr>\n"), i,tmp3Buf, i,tmpBuf,i,pBss->ChannelNumber,i,tmp2Buf,i,wpa_tkip_aes,i,wpa2_tkip_aes ,i,i, pBss->bdTstamp[2]);
		}
		else
			nBytesSent += req_format_write(wp, ("</tr>\n"));
	}

	if( pStatus->number == 0 )
	{
		if (( mode == CLIENT_MODE )
#if defined(CONFIG_RTL_ULINKER)
		|| ((mode == AP_MODE || mode == AP_WDS_MODE)&& rptEnabled == 1)
#endif
#if defined(CONFIG_SMART_REPEATER)
		||( (mode == AP_MODE  || mode == AP_WDS_MODE) && (rptEnabled == 1) 
		//&& (opmode == WISP_MODE)
		)
#endif
		)
		{
			nBytesSent += req_format_write(wp, ("<tr class=\"tbl_body\">"
	                "<td align=center width=\"20%%\" ><font size=\"2\">None</td>\n"
	                "<td align=center width=\"20%%\" ><font size=\"2\"></td>\n"
	                "<td align=center width=\"10%%\" ><font size=\"2\"></td>\n"
	                "<td align=center width=\"20%%\" ><font size=\"2\"></td>\n"
	                "<td align=center width=\"10%%\" ><font size=\"2\"></td>\n"
	                "<td align=center width=\"10%%\" ><font size=\"2\"></td>\n"
	                "<td align=center width=\"20%%\" ><font size=\"2\"></td>\n"
	                "</tr>\n"));
		}
		else
		{
			nBytesSent += req_format_write(wp, ("<tr class=\"tbl_body\">"
			"<td align=center width=\"20%%\" ><font size=\"2\">None</td>\n"
			"<td align=center width=\"20%%\" ><font size=\"2\"></td>\n"
			"<td align=center width=\"10%%\" ><font size=\"2\"></td>\n"
			"<td align=center width=\"20%%\" ><font size=\"2\"></td>\n"
			"<td align=center width=\"10%%\" ><font size=\"2\"></td>\n"
			"<td align=center width=\"10%%\" ><font size=\"2\"></td>\n"
			"</tr>\n"));
		}
	}
	nBytesSent += req_format_write(wp, ("</table>\n"));

#ifdef CONFIG_RTK_MESH
	if(mesh_enable) 
	{ 
		int mesh_count = 0;

		nBytesSent += req_format_write(wp, ("<table border=\"1\" width=\"500\">"
		"<tr class=\"tbl_head\"><h4><font><br><br>List of Mesh Points</font></tr><tr>"
		"<td align=center width=\"30%%\" ><font size=\"2\"><b>Mesh ID</b></font></td>\n" 
		"<td align=center width=\"20%%\" ><font size=\"2\"><b>MAC Adddress</b></font></td>\n" 
		"<td align=center width=\"10%%\" ><font size=\"2\"><b>Channel</b></font></td>\n")); 
		nBytesSent += req_format_write(wp, ("<td align=center width=\"10%%\"><font size=\"2\"><b>Select</b></font></td></tr>\n"));

		for (i=0; i<pStatus->number && pStatus->number!=0xff; i++) 
		{
			pBss = &pStatus->bssdb[i]; 
			if(pBss->bdMeshId.Length == 0)
				continue; 
			mesh_count++;
			memcpy(meshidbuf, pBss->bdMeshIdBuf - 2, pBss->bdMeshId.Length); // the problem of padding still exists
			meshidbuf[pBss->bdMeshId.Length] = '\0'; 

			snprintf(tmpBuf, 200, ("%02x:%02x:%02x:%02x:%02x:%02x"), 
				pBss->bdBssId[0], pBss->bdBssId[1], pBss->bdBssId[2], 
				pBss->bdBssId[3], pBss->bdBssId[4], pBss->bdBssId[5]); 
			memcpy(ssidbuf, pBss->bdSsIdBuf, pBss->bdSsId.Length); 
			ssidbuf[pBss->bdSsId.Length] = '\0'; 
			
			nBytesSent += req_format_write(wp, ("<tr class=\"tbl_body\">" 
				"<td align=left width=\"30%%\" ><font size=\"2\">%s</td>\n" 
				"<td align=center width=\"20%%\" ><font size=\"2\">%s</td>\n" 
				"<td align=center width=\"10%%\" ><font size=\"2\">%d</td>\n"), 
				meshidbuf, tmpBuf, pBss->ChannelNumber); 
            
			nBytesSent += req_format_write(wp, 
			("<td align=center width=\"10%%\" >"
             "<input type=\"hidden\" id=\"selSSID_%d\" value=\"%s\" >"
             "<input type=\"hidden\" id=\"selEncrypt_%d\" value=\"%s\" >"
             "<input type=\"hidden\" id=\"selChannel_%d\" value=\"%d\" >"
			 "<input type=\"radio\" name=\"select\" value=\"sel%d\" onClick=\"enableConnect(%d, 1)\">"              
             "</td></tr>\n"),i, ssidbuf,  i, "no", i, pBss->ChannelNumber, i, i); 
		}
		if( mesh_count == 0 )
		{
			nBytesSent += req_format_write(wp, ("<tr>"
			"<td align=center width=\"30%%\"><font size=\"2\">None</td>\n"
			"<td align=center width=\"20%%\" ><font size=\"2\"></td>\n"
			"<td align=center width=\"10%%\" ><font size=\"2\"></td>\n"
			"<td align=center width=\"10%%\" ><font size=\"2\"></td>\n"));
		}
		nBytesSent += req_format_write(wp, ("</table>")); 
	}
#endif
	} 
	return nBytesSent;
}

#ifdef CONFIG_CHEEPER_REPEATER	/* WNC-MR0000-Libera-Jan-20121101- new spec. - Repeater mode *//* WNC-MR0000-[Voyager]-Libera-20131210- repeater mode */
/* WNC-NMR0000-JOE-PENG-20140926-Modify signal strength according to section 6.3.2 of Linear Spec. V2.6.0-start */
#define BSS_BW_SHIFT	5	
#define HT_CHANNEL_WIDTH_AC_80 2
/* WNC-NMR0000-JOE-PENG-20140926-Modify signal strength according to section 6.3.2 of Linear Spec. V2.6.0-end */

typedef struct _SSEntry {
    unsigned char bdBssId[6];
    unsigned char bdSsIdBuf[SSID_LEN];
    OCTET_STRING  bdSsId;

#if defined(CONFIG_RTK_MESH) || defined(CONFIG_RTL_819X) 
	//by GANTOE for site survey 2008/12/26
//	unsigned char bdMeshIdBuf[MESHID_LEN]; 
//	OCTET_STRING bdMeshId; 
#endif 
//    BssType bdType;
//    unsigned short bdBcnPer;			// beacon period in Time Units
//    unsigned char bdDtimPer;			// DTIM period in beacon periods
    unsigned long bdTstamp[2];			// 8 Octets from ProbeRsp/Beacon
//    IbssParms bdIbssParms;			// empty if infrastructure BSS
    unsigned short bdCap;				// capability information
    unsigned char ChannelNumber;			// channel number
//    unsigned long bdBrates;
//    unsigned long bdSupportRates;		
//    unsigned char bdsa[6];			// SA address
//    unsigned char rssi, sq;			// RSSI and signal strength
    unsigned char rssi;			// RSSI
    unsigned char network;			// 1: 11B, 2: 11G, 4:11G
	// P2P_SUPPORT
//	unsigned char	p2pdevname[33];		
//	unsigned char	p2prole;	
//	unsigned short	p2pwscconfig;		
//	unsigned char	p2paddress[6];	
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140731, Modify for SpecChangeRequest2.3.0.zip
//	unsigned char	stage;
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140731, Modify for SpecChangeRequest2.3.0.zip End
//WNC-NMR820-JDR230-YUAN-I-CHOU-20141029, Don't send ECMv1/2 if AP only support ECMv1
//	unsigned char	ecmv1_only;
//WNC-NMR820-JDR230-YUAN-I-CHOU-20141029, Don't send ECMv1/2 if AP only support ECMv1 End
	int wlan_idx;
	int associatable;
} SSEntry, *pSSEntry;

int dupSSEntry(pSSEntry dest, pBssDscr src, int wlan, int associatable) {

	if (dest == NULL || src == NULL) {
		return -1;
	}
	memcpy(dest->bdBssId, src->bdBssId, 6);
	memcpy(dest->bdSsIdBuf, src->bdSsIdBuf, SSID_LEN);
	dest->bdSsId = src->bdSsId;
	memcpy(dest->bdTstamp, src->bdTstamp, sizeof(dest->bdTstamp));
	dest->bdCap = src->bdCap;
	dest->ChannelNumber = src->ChannelNumber;
	dest->rssi = src->rssi;
	dest->network = src->network;
	dest->wlan_idx = wlan;
	dest->associatable = associatable;
}

int compSSEntry(const void *p1, const void *p2) {
	return ((pSSEntry)p2)->rssi - ((pSSEntry)p1)->rssi;
}
int wlSiteSurveyWncTbl(request *wp, int argc, char **argv)
{
	int nBytesSent=0, i=0, j=0;/* WNC-NMR821-[Linear]-Libera-20141029- Consider one band site survey in dual band*/
	int intVal = 0;
	int enableRadio = 0;
	int associatable = 0;

	int ssnum = 0;
	pSSEntry sslist = NULL, pBss = NULL;

	int wlan_orig = 0, vwlan_orig = 0;	
	/* WNC-NMR0245-JOE-PENG-20121211-Fix bug that SSID set as script wouldn't be displayed on wlsurvey page. */
	/* Increase size of temp buffer "ssidbuf" from 40 to 500 because we want to translate */
	/* special character in SSID to HTML control code by function translate_control_code() */
/* WNC-NMR0265-HENGI-CHEN-20121214-Fix bug Space character of SSID wouldn't be dipslayed */
	char tmpBuf[100], ssidbuf[500], ssidbuf2[500], tmp1Buf[32], tmp2Buf[32], wpa_tkip_aes[20],wpa2_tkip_aes[20];
/* WNC-NMR0265-HENGI-CHEN-20121214-End */
	WLAN_MODE_T mode;
	bss_info bss;

#if 1 /* WNC-NMR000-[Linear]-Libera-20141105- Connect to which BSSID now? */
    int wsc_priority=1;
	unsigned char connect_bssid[12+1]={0};
	char buffer[64];
	int wlan0_status=0, wlan1_status=0;
	char file_path1[] = "/proc/%s/sta_info";
#endif	//#if 1 /* WNC-NMR000-[Linear]-Libera-20141105- Connect to which BSSID now? */



	if (pStatus==NULL) {
		pStatus = calloc(1, sizeof(SS_STATUS_T));
		if ( pStatus == NULL ) {
			printf("Allocate buffer failed!\n");
			return 0;
		}
	}

//	pStatus->number = 0; // request BSS DB
	//strcat(WLAN_IF,"-vxd");

	wlan_orig = wlan_idx;
	vwlan_orig = vwlan_idx;
	for (i = 0; i < NUM_WLAN_INTERFACE; i++) {
		wlan_idx = i;
		vwlan_idx = 0;
		apmib_get(MIB_WLAN_WLAN_DISABLED, &intVal);
		if (intVal == 0) {
			enableRadio |=  (0x1 << i);	
			if ( !apmib_get( MIB_WLAN_MODE, (void *)&intVal) ) {
				printf("Get MIB_WLAN_MODE MIB failed!");
				return 0;
			}
			if (intVal == AP_MODE) {
				if(wlan_idx == 0) {
					if ( !apmib_get(MIB_REPEATER_ENABLED1, (void *)&intVal)) {
						printf("Get MIB_REPEATER_ENABLED1 MIB failed!");
						return 0;
					}
				} else {
					if ( !apmib_get(MIB_REPEATER_ENABLED2, (void *)&intVal)) {
						printf("Get MIB_REPEATER_ENABLED2 MIB failed!");
						return 0;
					}
				}
				if (intVal != 0) {
					associatable |=  (0x1 << i);	
				}
				
			} else if (intVal == CLIENT_MODE) {
				associatable |=  (0x1 << i);	
			}
		}
	}
                
#if 1 /* WNC-NMR000-[Linear]-Libera-20141105- Connect to which BSSID now? */
	if (!check_conn_state("wlan0-vxd")){     //wlan0-vxd
		wlan0_status=1;
		printf("Wlan0-vxd connect ok!!, Func: %s, Line: %d\n",__FUNCTION__,__LINE__);
	}

	if (!check_conn_state("wlan1-vxd")){     //wlan1-vxd
		wlan1_status=1;
		printf("Wlan1-vxd connect ok!!, Func: %s, Line: %d\n",__FUNCTION__,__LINE__);
	}
	printf ("[%s]: STA connects successfully, [00]connect_bssid=%s\n",__FILE__,connect_bssid);
	if (wlan0_status==1 && wlan1_status==1) {  // both connect
		/*choose first priority band*/
		wlan_idx=0;
		vwlan_idx = NUM_VWLAN_INTERFACE; // vxd interface
		apmib_get(MIB_WLAN_WSC_PRIORITY,(void *)&wsc_priority);  // 1: 2.4G, 2: 5G

		/* get MAC */
		memset(buffer, 0x0, 64);
		if (wsc_priority==2){       //5G
			snprintf(buffer, sizeof(buffer), file_path1, "wlan1-vxd");
			if ((lw_get_string_in_file(buffer, "hwaddr: ", connect_bssid, 13) == 1)) {
				printf ("[%s]: STA connects successfully, [5G/2.4G]connect_bssid=%s\n",__FILE__,connect_bssid);
			}
		}else{       //2G                                 
			snprintf(buffer, sizeof(buffer), file_path1, "wlan0-vxd");
			if ((lw_get_string_in_file(buffer, "hwaddr: ", connect_bssid, 13) == 1)) {
				printf ("[%s]: STA connects successfully, [2.4G/5G]connect_bssid=%s\n",__FILE__,connect_bssid);
			}       
		}
	}
	else if (wlan0_status==1 & wlan1_status==0) {     //connect to 2.4G
		/* get MAC */
		memset(buffer, 0x0, 64);
		snprintf(buffer, sizeof(buffer), file_path1, "wlan0-vxd");
		if ((lw_get_string_in_file(buffer, "hwaddr: ", connect_bssid, 13) == 1)) {
			printf ("[%s]: STA connects successfully, [2.4G]connect_bssid=%s\n",__FILE__,connect_bssid);
		}       
	}
	else if (wlan0_status==0 & wlan1_status==1) {     //connect to 5G
		/* get MAC */
		memset(buffer, 0x0, 64);
		snprintf(buffer, sizeof(buffer), file_path1, "wlan1-vxd");
		if ((lw_get_string_in_file(buffer, "hwaddr: ", connect_bssid, 13) == 1)) {
			printf ("[%s]: STA connects successfully, [5G]connect_bssid=%s\n",__FILE__,connect_bssid);
		}       
	}
	else {       //both disconnect
		printf ("[%s]: STA connects NG !\n",__FILE__);
	}
                
#endif	//#if 1 /* WNC-NMR000-[Linear]-Libera-20141105- Connect to which BSSID now? */

	wlan_idx = wlan_orig;
	vwlan_idx = vwlan_orig;


	for (i = 0; i < NUM_WLAN_INTERFACE; i++) {
		if ((enableRadio >> i) & 0x1) {
		
			sprintf(WLAN_IF, "wlan%d", i);
			pStatus->number = 0;
			if ( getWlSiteSurveyResult(WLAN_IF, pStatus) < 0 ) {
				//ERR_MSG("Read site-survey status failed!");
				req_format_write(wp, "Read site-survey status failed!");
				free(pStatus); //sc_yang
				pStatus = NULL;
				return 0;
			}
			if (pStatus->number != 0xFF && pStatus->number > 0) {
				sslist = realloc(sslist, (ssnum+pStatus->number)*sizeof(SSEntry));
				if(sslist == NULL) {
					return 0;
				}
				for (j=0;j<pStatus->number;j++) {
// WNC-NMR0872-JDR231-HENG-I-CHEN-2014-12-23: Don't copy WPA/WPA2 Enterprise AP #BEGIN
					if (((pStatus->bssdb[j].bdTstamp[0] & 0x0000f000) >> 12) == 0x2) {
						continue;	/* ignore WPA/WPA2 Enterprise */
					} else if (((pStatus->bssdb[j].bdTstamp[0] & 0xf0000000) >> 28) == 0x2) {
						continue;	/* ignore WPA/WPA2 Enterprise */
					}
// WNC-NMR0872-JDR231-HENG-I-CHEN-2014-12-23: Don't copy WPA/WPA2 Enterprise AP #END
					dupSSEntry(&sslist[ssnum++], &pStatus->bssdb[j], i, (associatable > i)&0x1);
				}
			}
		}	
	}

	
// WNC-NMR0872-JDR231-HENG-I-CHEN-2014-12-23: Use Javascript in wlstabasic.htm to print message that warn over 32 AP #BEGIN
	nBytesSent += req_format_write(wp, "%s", "<TABLE id=siteSurveyList border=1 width=500>\n");
// WNC-NMR0872-JDR231-HENG-I-CHEN-2014-12-23: Use Javascript in wlstabasic.htm to print message that warn over 32 AP #END

	if (sslist == NULL) {
		nBytesSent += req_format_write(wp, ("<tr>"
			"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">ƵĤޤ</td>\n"	/* MR231-libera-20121208 - delete <pre> flag*/
			"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"
			"<td align=center width=\"30%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"
			//"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"
			"<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"
			"<td align=center width=\"30%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"
			"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"
			"</tr>\n"));
	} else {
		int lastone = 0;
		int connected_AP_found = 0;

		qsort(sslist, ssnum, sizeof(SSEntry), compSSEntry);
		nBytesSent += req_format_write(wp, ("<tr>"
			"<td align=center width=\"20%%\" bgcolor=\"#808080\"><font size=\"2\"><b>ͥåȥ̾(SSID)</b></font></td>\n"
			"<td align=center width=\"20%%\" bgcolor=\"#808080\"><font size=\"2\"><b>BSSID</b></font></td>\n"
			"<td align=center width=\"30%%\" bgcolor=\"#808080\"><font size=\"2\"><b>ѥͥ</b></font></td>\n"
//      	"<td align=center width=\"20%%\" bgcolor=\"#808080\"><font size=\"2\"><b>Type</b></font></td>\n"
	      	"<td align=center width=\"10%%\" bgcolor=\"#808080\"><font size=\"2\"><b>Ź沽⡼</b></font></td>\n"
			"<td align=center width=\"40%%\" bgcolor=\"#808080\"><font size=\"2\"><b>٥</b></font></td>\n"));
	
		if (associatable != 0 ) {
			nBytesSent += req_format_write(wp, ("<td align=center width=\"15%%\" bgcolor=\"#808080\"><font size=\"2\"><b></b></font></td></tr>\n"));
		} else {
			nBytesSent += req_format_write(wp, ("</tr>\n"));
		}
		
		for (i=0; i < ssnum; i++) {
			pBss = &sslist[i];
			
			if (connected_AP_found == 0) {
				snprintf(tmpBuf, 100, ("%02x%02x%02x%02x%02x%02x"),
					pBss->bdBssId[0], pBss->bdBssId[1], pBss->bdBssId[2],
					pBss->bdBssId[3], pBss->bdBssId[4], pBss->bdBssId[5]);

				if (strncasecmp(tmpBuf, connect_bssid, 12) == 0) {
					connected_AP_found = 1;		
				}
			} 

			if (i >= 31) {
				if (connected_AP_found == 0)
				{
					if (i < ssnum-1) {
						continue;
					} else {
						pBss = &sslist[31];
					}
				}
				if (i > 31)
					i = 31;
				lastone = 1;
			}
			snprintf(tmpBuf, 100, ("%02x:%02x:%02x:%02x:%02x:%02x"),
				pBss->bdBssId[0], pBss->bdBssId[1], pBss->bdBssId[2],
				pBss->bdBssId[3], pBss->bdBssId[4], pBss->bdBssId[5]);

			memcpy(ssidbuf, pBss->bdSsIdBuf, pBss->bdSsId.Length);
			ssidbuf[pBss->bdSsId.Length] = '\0';
	        /* WNC-NMR0265-HENGI-CHEN-20121214-Fix bug Space character of SSID wouldn't be dipslayed */
			strcpy(ssidbuf2, ssidbuf);
	        /* WNC-NMR0265-HENGI-CHEN-20121214-End */

			/* WNC-NMR0245-JOE-PENG-20121211-Fix bug that SSID set as script wouldn't be displayed on wlsurvey page. */
			/* WNC-NMR0247-JOE-PENG-20121211-Fix bug that when script character is set as SSID, GUI would be wrong on Status page. */
			/* WNC-NMR0248-JOE-PENG-20121211-Fix bug that symbol characters are display in Select column on wlsurvey page. */
			/* Translate special character in SSID to HTML control code */
	        /* WNC-NMR0265-HENGI-CHEN-20121214-Fix bug Space character of SSID wouldn't be dipslayed */
			translate_control_code_and_space(ssidbuf);
			translate_control_code(ssidbuf2);
	        /* WNC-NMR0265-HENGI-CHEN-20121214-End */

#if 1	/* WNC-MR0000-Rita-20121123-If channel width is 40MHz (802.11n) show the channel as "control & extension" */
		//	if( pBss->network & BAND_11N ){
			if (pBss->network==(BAND_11G|BAND_11B | BAND_11N)){
				#define BIT(x)	(1 << (x))
				if ((pBss->bdTstamp[1] & (BIT(1) | BIT(2))) == (BIT(1) | BIT(2))) {
					//HT40 lower
					sprintf(tmp1Buf, "%d&%d (11n 2.4GHz)", pBss->ChannelNumber, pBss->ChannelNumber - 4);/* WNC-MR0000-[Voyager]-Libera-20140207- SPEC.1.2 Channel format change */
					//pBss->sndchoff = HT_2NDCH_OFFSET_BELOW;
				} else if ((pBss->bdTstamp[1] & (BIT(1) | BIT(2))) == BIT(1)) {
					//HT40 upper
					sprintf(tmp1Buf, "%d&%d (11n 2.4GHz)", pBss->ChannelNumber, pBss->ChannelNumber + 4);/* WNC-MR0000-[Voyager]-Libera-20140207- SPEC.1.2 Channel format change */
					//pBss->sndchoff =HT_2NDCH_OFFSET_ABOVE;
				} else {
					//HT20
					sprintf(tmp1Buf, "%d (11n 2.4GHz)", pBss->ChannelNumber);/* WNC-MR0000-[Voyager]-Libera-20140207- SPEC.1.2 Channel format change */
					//pBss->sndchoff = HT_2NDCH_OFFSET_DONTCARE;
				}
			} 
			else if (pBss->network== BAND_11A)
			{
				sprintf(tmp1Buf, "%d (11a 5GHz)", pBss->ChannelNumber);
			}
			else if (pBss->network== (BAND_11A | BAND_11N))
			{
				/* WNC-NMR000-[Linear]-Libera-20140804- show 11a/n/ac channel - start */
				if ((pBss->bdTstamp[1] & (BIT(1) | BIT(2))) == (BIT(1) | BIT(2))) {
					//HT40 lower
					sprintf(tmp1Buf, "%d&%d (11n 5GHz)", pBss->ChannelNumber, pBss->ChannelNumber - 4);
					//pBss->sndchoff = HT_2NDCH_OFFSET_BELOW;
				} else if ((pBss->bdTstamp[1] & (BIT(1) | BIT(2))) == BIT(1)) {
					//HT40 upper
					sprintf(tmp1Buf, "%d&%d (11n 5GHz)", pBss->ChannelNumber, pBss->ChannelNumber + 4);
					//pBss->sndchoff =HT_2NDCH_OFFSET_ABOVE;
				} else {
					//HT20
					sprintf(tmp1Buf, "%d (11n 5GHz)", pBss->ChannelNumber);
					//pBss->sndchoff = HT_2NDCH_OFFSET_DONTCARE;
				}
				/* WNC-NMR000-[Linear]-Libera-20140804- show 11a/n/ac channel -end */
			}
			else if (pBss->network== (BAND_11A | BAND_11N | BAND_5G_11AC))
			{
				/* WNC-NMR000-[Linear]-Libera-20140804- show 11a/n/ac channel - start */	
				//t_stamp[1], b5-b7 = channel width information, mapping to _HT_CHANNEL_WIDTH_AC
				if ((pBss->bdTstamp[1] & (HT_CHANNEL_WIDTH_AC_80 << BSS_BW_SHIFT)) == (HT_CHANNEL_WIDTH_AC_80 << BSS_BW_SHIFT)) {	/*AC HT80*/
					/* WNC-MR0000-[Linear]-Libera-20140704-start*/

					/* WNC-NMR0808-JOE-PENG-20141024-[Linear][Request] Request for Channel display about control and extension Ch-start */
#if 0
					if ((36<=pBss->ChannelNumber) && (pBss->ChannelNumber<=48))	
						sprintf(tmp1Buf, "36&40&44&48 (11ac 5GHz)");
					else if ((52<=pBss->ChannelNumber) && (pBss->ChannelNumber<=64))
						sprintf(tmp1Buf, "52&56&60&64 (11ac 5GHz)");
					else if ((100<=pBss->ChannelNumber) && (pBss->ChannelNumber<=112))
						sprintf(tmp1Buf, "100&104&108&112 (11ac 5GHz)");
					else if ((116<=pBss->ChannelNumber) && (pBss->ChannelNumber<=128))
						sprintf(tmp1Buf, "116&120&124&128 (11ac 5GHz)");			
					else
						sprintf(tmp1Buf, "%d (11ac 5GHz)", pBss->ChannelNumber);
#endif

					/* WNC-NMR0835-JOE-PENG-20141031- [Linear](CNV) There is a wrong display in channel of AP detection results-start */
					switch (pBss->ChannelNumber) {
						case 36:
							strncpy(tmp1Buf, "36&40&44&48 (11ac 5GHz)", sizeof(tmp1Buf));
							break;
						case 40:
							strncpy(tmp1Buf, "40&36&44&48 (11ac 5GHz)", sizeof(tmp1Buf));
							break;
						case 44:
							strncpy(tmp1Buf, "44&36&40&48 (11ac 5GHz)", sizeof(tmp1Buf));
							break;
						case 48:
							strncpy(tmp1Buf, "48&36&40&44 (11ac 5GHz)", sizeof(tmp1Buf));
							break;
						case 52:
							strncpy(tmp1Buf, "52&56&60&64 (11ac 5GHz)", sizeof(tmp1Buf));
							break;
						case 56:
							strncpy(tmp1Buf, "56&52&60&64 (11ac 5GHz)", sizeof(tmp1Buf));
							break;
						case 60:
							strncpy(tmp1Buf, "60&52&56&64 (11ac 5GHz)", sizeof(tmp1Buf));
							break;
						case 64:
							strncpy(tmp1Buf, "64&52&56&60 (11ac 5GHz)", sizeof(tmp1Buf));
							break;
						case 100:
							strncpy(tmp1Buf, "100&104&108&112 (11ac 5GHz)", sizeof(tmp1Buf));
							break;
						case 104:
							strncpy(tmp1Buf, "104&100&108&112 (11ac 5GHz)", sizeof(tmp1Buf));
							break;
						case 108:
							strncpy(tmp1Buf, "108&100&104&112 (11ac 5GHz)", sizeof(tmp1Buf));
							break;
						case 112:
							strncpy(tmp1Buf, "112&100&104&108 (11ac 5GHz)", sizeof(tmp1Buf));
							break;
						case 116:
							strncpy(tmp1Buf, "116&120&124&128 (11ac 5GHz)", sizeof(tmp1Buf));
							break;
						case 120:
							strncpy(tmp1Buf, "120&116&124&128 (11ac 5GHz)", sizeof(tmp1Buf));
							break;
						case 124:
							strncpy(tmp1Buf, "124&116&120&128 (11ac 5GHz)", sizeof(tmp1Buf));
							break;
						case 128:
							strncpy(tmp1Buf, "128&116&120&124 (11ac 5GHz)", sizeof(tmp1Buf));
							break;
						default:
							snprintf(tmp1Buf, sizeof(tmp1Buf), "%d (11ac 5GHz)", pBss->ChannelNumber);
							break;
					}
					/* WNC-NMR0835-JOE-PENG-20141031- [Linear](CNV) There is a wrong display in channel of AP detection results-end */
					/* WNC-NMR0808-JOE-PENG-20141024-[Linear][Request] Request for Channel display about control and extension Ch-end */
					/* WNC-MR0000-[Linear]-Libera-20140704-end*/	
				}
				else if (pBss->bdTstamp[1] & BIT(1)){	/*AC HT40*/
					if ((pBss->bdTstamp[1] & (BIT(1) | BIT(2))) == (BIT(1) | BIT(2))) {
						//HT40 lower
						sprintf(tmp1Buf, "%d&%d (11ac 5GHz)", pBss->ChannelNumber, pBss->ChannelNumber - 4);
					} else if ((pBss->bdTstamp[1] & (BIT(1) | BIT(2))) == BIT(1)) {
						//HT40 upper
						sprintf(tmp1Buf, "%d&%d (11ac 5GHz)", pBss->ChannelNumber, pBss->ChannelNumber + 4);
					}
				}
				else{	/*AC HT20*/
					/* WNC-MR0000-[Linear]-Libera-20140704-start*/
					sprintf(tmp1Buf, "%d (11ac 5GHz)", pBss->ChannelNumber);
					/* WNC-MR0000-[Linear]-Libera-20140704-end*/
				}
					/* WNC-NMR000-[Linear]-Libera-20140804- show 11a/n/ac channel - end */		
			}
			else 
			{
				/* WNC-MR0000-[Voyager]-Libera-20140207- SPEC.1.2 Channel format change -Start*/	 
				if (pBss->network==BAND_11B)
					sprintf(tmp1Buf, "%d (11b 2.4GHz)", pBss->ChannelNumber);
				else if (pBss->network==(BAND_11G|BAND_11B)||pBss->network==BAND_11G)
					sprintf(tmp1Buf, "%d (11g 2.4GHz)", pBss->ChannelNumber);
				/* WNC-MR0000-[Voyager]-Libera-20140207- SPEC.1.2 Channel format change -End*/			
			}
#else //Reltek
			if (pBss->network==BAND_11B)
				strcpy(tmp1Buf, (" (B)"));
			else if (pBss->network==BAND_11G)
				strcpy(tmp1Buf, (" (G)"));
			else if (pBss->network==(BAND_11G|BAND_11B))
				strcpy(tmp1Buf, (" (B+G)"));
			else if (pBss->network==(BAND_11N))
				strcpy(tmp1Buf, (" (N)"));
			else if (pBss->network==(BAND_11G|BAND_11N))
				strcpy(tmp1Buf, (" (G+N)"));
			else if (pBss->network==(BAND_11G|BAND_11B | BAND_11N))
				strcpy(tmp1Buf, (" (B+G+N)"));
			else if(pBss->network== BAND_11A)
				strcpy(tmp1Buf, (" (A)"));
			else if(pBss->network== (BAND_11A | BAND_11N))
				strcpy(tmp1Buf, (" (A+N)"));
			else
				sprintf(tmp1Buf, (" -%d-"),pBss->network);
#endif
			memset(wpa_tkip_aes,0x00,sizeof(wpa_tkip_aes));
			memset(wpa2_tkip_aes,0x00,sizeof(wpa2_tkip_aes));

			if ((pBss->bdCap & cPrivacy) == 0){
				sprintf(tmp2Buf, "Ź沽̵");
			}
			else 
			{
				if (pBss->bdTstamp[0] == 0)
					sprintf(tmp2Buf, "WEP");

				else {
					int wpa_exist = 0, idx = 0;
					if (pBss->bdTstamp[0] & 0x0000ffff) {
						idx = sprintf(tmp2Buf, "WPA");
						if (((pBss->bdTstamp[0] & 0x0000f000) >> 12) == 0x4)
							idx += sprintf(tmp2Buf+idx, "-PSK");
						else if(((pBss->bdTstamp[0] & 0x0000f000) >> 12) == 0x2){
							continue;	/* WNC-MR554-[Voyager]-Libera-20140212- ignore WPA/WPA2 Enterprise */
							idx += sprintf(tmp2Buf+idx, "-1X");
						}
						wpa_exist = 1;

						if (((pBss->bdTstamp[0] & 0x00000f00) >> 8) == 0x5){
							idx += sprintf(tmp2Buf+idx, "(TKIP/AES)");
							sprintf(wpa_tkip_aes,"%s","aes/tkip");
						}
						else if (((pBss->bdTstamp[0] & 0x00000f00) >> 8) == 0x4){
							idx += sprintf(tmp2Buf+idx, "(AES)");
							sprintf(wpa_tkip_aes,"%s","aes");
						}
						else if (((pBss->bdTstamp[0] & 0x00000f00) >> 8) == 0x1){
							idx += sprintf(tmp2Buf+idx, "(TKIP)");
							sprintf(wpa_tkip_aes,"%s","tkip");
						}
					}
					if (pBss->bdTstamp[0] & 0xffff0000) {
						if (wpa_exist){
							memset(tmp2Buf,0x00,sizeof(tmp2Buf));
							idx = sprintf(tmp2Buf, "WPA/WPA2");
							if (((pBss->bdTstamp[0] & 0xf0000000) >> 28) == 0x4)
								idx += sprintf(tmp2Buf+idx, "-PSK");
							else if (((pBss->bdTstamp[0] & 0xf0000000) >> 28) == 0x2){
								continue;	/* WNC-MR554-[Voyager]-Libera-20140212- ignore WPA/WPA2 Enterprise */
								idx += sprintf(tmp2Buf+idx, "-1X");
							}
							if (((pBss->bdTstamp[0] & 0x0f000000) >> 24) == 0x5){
								idx += sprintf(tmp2Buf+idx, "(TKIP/AES)");
								sprintf(wpa2_tkip_aes,"%s","aes/tkip");
							}
							else if (((pBss->bdTstamp[0] & 0x0f000000) >> 24) == 0x4){
								idx += sprintf(tmp2Buf+idx, "(AES)");
								sprintf(wpa2_tkip_aes,"%s","aes");
							}
							else if (((pBss->bdTstamp[0] & 0x0f000000) >> 24) == 0x1){
								idx += sprintf(tmp2Buf+idx, "(TKIP)");
								sprintf(wpa2_tkip_aes,"%s","tkip");
							}
						}else{
							idx += sprintf(tmp2Buf+idx, "WPA2");
							if (((pBss->bdTstamp[0] & 0xf0000000) >> 28) == 0x4)
								idx += sprintf(tmp2Buf+idx, "-PSK");
							else if (((pBss->bdTstamp[0] & 0xf0000000) >> 28) == 0x2){
								continue;	/* WNC-MR554-[Voyager]-Libera-20140212- ignore WPA/WPA2 Enterprise */
								idx += sprintf(tmp2Buf+idx, "-1X");
							}
							if (((pBss->bdTstamp[0] & 0x0f000000) >> 24) == 0x5){
								idx += sprintf(tmp2Buf+idx, "(TKIP/AES)");
								sprintf(wpa2_tkip_aes,"%s","aes/tkip");
							}
							else if (((pBss->bdTstamp[0] & 0x0f000000) >> 24) == 0x4){
								idx += sprintf(tmp2Buf+idx, "(AES)");
								sprintf(wpa2_tkip_aes,"%s","aes");
							}
							else if (((pBss->bdTstamp[0] & 0x0f000000) >> 24) == 0x1){
								idx += sprintf(tmp2Buf+idx, "(TKIP)");
								sprintf(wpa2_tkip_aes,"%s","tkip");
							}
						}
					}
				}
			}

			{
				nBytesSent += req_format_write(wp, ("<tr>"
					"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"	/* MR231-libera-20121208 - delete <pre> flag*/
					"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
				//	"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%d%s</td>\n"	//Rita --
					"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"	//Rita ++
		      	//	"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"	//type
					"<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"),
					ssidbuf, tmpBuf,tmp1Buf, tmp2Buf); //Rita ++
				//	ssidbuf, tmpBuf, pBss->ChannelNumber, tmp1Buf, tmp2Buf, pBss->rssi);	//Rita --
	            /* WNC-MR0000-Rita-20121129-for NEC specification to express rssi with strong, medium and weak */
#if 1
				/* WNC-NMR0293-Rita-20130129-New request-RSSI subtract 5*/
				// WNC-NMR0000-JDR230-HENG-I-CHEN-20131014, rssi is unsigned char
				/* WNC-NMR0000-JOE-PENG-20140205-Modify signal strength in site survey page according to section 6.3.2 signal strength of Spec. V1.4.0-start */
#if 1
				if( pBss->rssi < 5 )
					pBss->rssi = 0;
				else
					pBss->rssi -= 5;
#endif
				/* WNC-NMR0000-JOE-PENG-20140205-Modify signal strength in site survey page according to section 6.3.2 signal strength of Spec. V1.4.0-end */
				// WNC-NMR0000-JDR230-HENG-I-CHEN-20131014 End
				/* WNC-NMR0293-Rita-20130129-End*/
				/* WNC-NMR0000-Rita-20121219-New RSSI Spec.*/
				/* WNC-NMR0000-JOE-PENG-20140205-Modify signal strength in site survey page according to section 6.3.2 signal strength of Spec. V1.4.0-start */
				/* WNC-NMR0000-JOE-PENG-20140213-Modify siginal strength (section 6.3.2) of Voyager according to attachment (value.png) of NEC mail [WNCSW:0359]-start */
				/* WNC-NMR0000-JOE-PENG-20140926-Modify signal strength according to section 6.3.2 of Linear Spec. V2.6.0 -start */
				#define BIT(x)	(1 << (x))

				if (pBss->wlan_idx == 0) {//2G
					if ((pBss->bdTstamp[1] & BIT(1)) == BIT(1)) { //HT40
						if( 19 <= pBss->rssi)	  
							nBytesSent += req_format_write(wp,("<td align=center width=\"15%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"));
						else if(15 <= pBss->rssi && pBss->rssi <= 18) 
							nBytesSent += req_format_write(wp,("<td align=center width=\"15%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n")); 
						else if(pBss->rssi <= 14) 
							nBytesSent += req_format_write(wp,("<td align=center width=\"15%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"));
					} else { //HT20
						if( 28 <= pBss->rssi)     
							nBytesSent += req_format_write(wp,("<td align=center width=\"15%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"));
						else if(18 <= pBss->rssi && pBss->rssi <= 27) 
							nBytesSent += req_format_write(wp,("<td align=center width=\"15%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n")); 
						else if(pBss->rssi <= 17) 
							nBytesSent += req_format_write(wp,("<td align=center width=\"15%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"));
					}
				} else if (pBss->wlan_idx == 1){//5G
					if ((pBss->bdTstamp[1] & (HT_CHANNEL_WIDTH_AC_80 << BSS_BW_SHIFT)) == (HT_CHANNEL_WIDTH_AC_80 << BSS_BW_SHIFT)) {/*AC HT80*/
						if( 18 <= pBss->rssi)     
							nBytesSent += req_format_write(wp,("<td align=center width=\"15%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"));
						else if(14 <= pBss->rssi && pBss->rssi <= 17) 
							nBytesSent += req_format_write(wp,("<td align=center width=\"15%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n")); 
						else if(pBss->rssi <= 13) 
							nBytesSent += req_format_write(wp,("<td align=center width=\"15%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"));
					} else {
						if ((pBss->bdTstamp[1] & BIT(1)) == BIT(1)) { //HT40
							if( 20 <= pBss->rssi)	  
								nBytesSent += req_format_write(wp,("<td align=center width=\"15%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"));
							else if(15 <= pBss->rssi && pBss->rssi <= 19) 
								nBytesSent += req_format_write(wp,("<td align=center width=\"15%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n")); 
							else if(pBss->rssi <= 14) 
								nBytesSent += req_format_write(wp,("<td align=center width=\"15%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"));
						} else { //HT20
							if( 21 <= pBss->rssi)     
								nBytesSent += req_format_write(wp,("<td align=center width=\"15%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"));
							else if(15 <= pBss->rssi && pBss->rssi <= 20) 
								nBytesSent += req_format_write(wp,("<td align=center width=\"15%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n")); 
							else if(pBss->rssi <= 14) 
								nBytesSent += req_format_write(wp,("<td align=center width=\"15%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"));
						}
					}
				}
				
				/* WNC-NMR0000-JOE-PENG-20140926-Modify signal strength according to section 6.3.2 of Linear Spec. V2.6.0 -end */
				/* WNC-NMR0000-JOE-PENG-20140213-Modify siginal strength (section 6.3.2) of Voyager according to attachment (value.png) of NEC mail [WNCSW:0359]-end */
				/* WNC-NMR0000-JOE-PENG-20140205-Modify signal strength in site survey page according to section 6.3.2 signal strength of Spec. V1.4.0-end */
				/* WNC-NMR0000-Rita-20121219-End.*/
#else
				if(pBss->rssi > 65)     //66 ~ 100
					nBytesSent += req_format_write(wp,(
						"<td align=center width=\"15%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"));
				else if(45 < pBss->rssi && pBss->rssi <= 65) //46~65
					nBytesSent += req_format_write(wp,(
						"<td align=center width=\"15%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n")); 
				else if(pBss->rssi <= 45) //0 ~ 45
					nBytesSent += req_format_write(wp,(
						"<td align=center width=\"15%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"));
				/* WNC-MR0000-Rita-20121129-End*/
#endif
			}

			if (pBss->associatable) {
				/* WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode: not support WEP, but can display in SS -Start*/
				if (!strncmp(tmp2Buf,"WEP",3)) {
					nBytesSent += req_format_write(wp,
						("<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\"> <input type=\"hidden\" id=\"selSSID_%d\" value=\"%s\" > <input type=\"hidden\" id=\"selChannel_%d\" value=\"%d\" > <input type=\"hidden\" id=\"selEncrypt_%d\" value=\"%s\" > <input type=\"hidden\" id=\"wpa_tkip_aes_%d\" value=\"%s\" > <input type=\"hidden\" id=\"wpa2_tkip_aes_%d\" value=\"%s\" > <input type=\"hidden\" name="
						"\"select\" value=\"sel%d\" onClick=\"enableConnect(%d)\"></td>"), i,ssidbuf2,i,pBss->ChannelNumber,i,tmp2Buf,i,wpa_tkip_aes,i,wpa2_tkip_aes ,i,i);
				} else {
					/* WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode -End*/		
					/* WNC-NMR0265-HENGI-CHEN-20121214-Fix bug Space character of SSID wouldn't be dipslayed */
					nBytesSent += req_format_write(wp,
						("<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\"> <input type=\"hidden\" id=\"selSSID_%d\" value=\"%s\" > <input type=\"hidden\" id=\"selChannel_%d\" value=\"%d\" > <input type=\"hidden\" id=\"selEncrypt_%d\" value=\"%s\" > <input type=\"hidden\" id=\"wpa_tkip_aes_%d\" value=\"%s\" > <input type=\"hidden\" id=\"wpa2_tkip_aes_%d\" value=\"%s\" > <input type=\"radio\" name="
						"\"select\" value=\"sel%d\" onClick=\"enableConnect(%d)\"></td>"), i,ssidbuf2,i,pBss->ChannelNumber,i,tmp2Buf,i,wpa_tkip_aes,i,wpa2_tkip_aes ,i,i);
					/* WNC-NMR0265-HENGI-CHEN-20121214-End */
				}
			}
				
			nBytesSent += req_format_write(wp, ("</tr>\n"));
			if (lastone) {
// WNC-NMR0872-JDR231-HENG-I-CHEN-2014-12-23: Use Javascript in wlstabasic.htm to print message that warn over 32 AP #BEGIN
				if (ssnum > 32) {
					nBytesSent += req_format_write(wp, ("<tr height=0></tr>\n"));

				}
// WNC-NMR0872-JDR231-HENG-I-CHEN-2014-12-23: Use Javascript in wlstabasic.htm to print message that warn over 32 AP #END
				break;
			}
		}	//start to add entries to table -end.
		free(sslist);
	}
	
	nBytesSent += req_format_write(wp, "%s", "</TABLE>");
// WNC-NMR0872-JDR231-HENG-I-CHEN-2014-12-23: Use Javascript in wlstabasic.htm to print message that warn over 32 AP #BEGIN
//	if (ssnum >= 32) {
//		nBytesSent += req_format_write(wp, "%s",
//"<span class=message_normal_s><font color=\"red\">縡ǽ(32)Ķ륢ݥȤ򸡽Фޤ<BR>"
//"ꥹȤɽʤݥȤˤ³Ǥʤǽޤ</font></span>");
//	}
// WNC-NMR0872-JDR231-HENG-I-CHEN-2014-12-23: Use Javascript in wlstabasic.htm to print message that warn over 32 AP #END

	return nBytesSent;
}

#if 1 /* WNC-NMR0000-Jog-Lin-20151217, for site survey responsive GUI*/
int wlSiteSurveyEntry(request *wp, int argc, char **argv)
{
	int nBytesSent=0, i=0, j=0;/* WNC-NMR821-[Linear]-Libera-20141029- Consider one band site survey in dual band*/
	int intVal = 0;
	int enableRadio = 0;
	int associatable = 0;

	int ssnum = 0;
	pSSEntry sslist = NULL, pBss = NULL;

	int wlan_orig = 0, vwlan_orig = 0;	
	/* WNC-NMR0245-JOE-PENG-20121211-Fix bug that SSID set as script wouldn't be displayed on wlsurvey page. */
	/* Increase size of temp buffer "ssidbuf" from 40 to 500 because we want to translate */
	/* special character in SSID to HTML control code by function translate_control_code() */
/* WNC-NMR0265-HENGI-CHEN-20121214-Fix bug Space character of SSID wouldn't be dipslayed */
	char tmpBuf[100], ssidbuf[500], ssidbuf2[500], tmp1Buf[32], tmp2Buf[32], wpa_tkip_aes[20],wpa2_tkip_aes[20];
/* WNC-NMR0265-HENGI-CHEN-20121214-End */
	WLAN_MODE_T mode;
	bss_info bss;
	/* WNC-Jog-20160226, check over 32 AP flag */
	int more_ap = 0;

#if 1 /* WNC-NMR000-[Linear]-Libera-20141105- Connect to which BSSID now? */
	int wsc_priority=1;
	unsigned char connect_bssid[12+1]={0};
	char buffer[64];
	int wlan0_status=0, wlan1_status=0;
	char file_path1[] = "/proc/%s/sta_info";
#endif	//#if 1 /* WNC-NMR000-[Linear]-Libera-20141105- Connect to which BSSID now? */

	if (pStatus==NULL) {
		pStatus = calloc(1, sizeof(SS_STATUS_T));
		if ( pStatus == NULL ) {
			printf("Allocate buffer failed!\n");
			return 0;
		}
	}

//	pStatus->number = 0; // request BSS DB
	//strcat(WLAN_IF,"-vxd");

	wlan_orig = wlan_idx;
	vwlan_orig = vwlan_idx;
	for (i = 0; i < NUM_WLAN_INTERFACE; i++) {
		wlan_idx = i;
		vwlan_idx = 0;
		apmib_get(MIB_WLAN_WLAN_DISABLED, &intVal);
		if (intVal == 0) {
			enableRadio |=  (0x1 << i);	
			if ( !apmib_get( MIB_WLAN_MODE, (void *)&intVal) ) {
				printf("Get MIB_WLAN_MODE MIB failed!");
				return 0;
			}
			if (intVal == AP_MODE) {
				if(wlan_idx == 0) {
					if ( !apmib_get(MIB_REPEATER_ENABLED1, (void *)&intVal)) {
						printf("Get MIB_REPEATER_ENABLED1 MIB failed!");
						return 0;
					}
				} else {
					if ( !apmib_get(MIB_REPEATER_ENABLED2, (void *)&intVal)) {
						printf("Get MIB_REPEATER_ENABLED2 MIB failed!");
						return 0;
					}
				}
				if (intVal != 0) {
					associatable |=  (0x1 << i);	
				}
				
			} else if (intVal == CLIENT_MODE) {
				associatable |=  (0x1 << i);	
			}
		}
	}
                
#if 1 /* WNC-NMR000-[Linear]-Libera-20141105- Connect to which BSSID now? */
	if (!check_conn_state("wlan0-vxd")){     //wlan0-vxd
		wlan0_status=1;
		printf("Wlan0-vxd connect ok!!, Func: %s, Line: %d\n",__FUNCTION__,__LINE__);
	}

	if (!check_conn_state("wlan1-vxd")){     //wlan1-vxd
		wlan1_status=1;
		printf("Wlan1-vxd connect ok!!, Func: %s, Line: %d\n",__FUNCTION__,__LINE__);
	}
	//printf ("[%s]: STA connects successfully, [00]connect_bssid=%s\n",__FILE__,connect_bssid);
	if (wlan0_status==1 && wlan1_status==1) {  // both connect
		/*choose first priority band*/
		wlan_idx=0;
		vwlan_idx = NUM_VWLAN_INTERFACE; // vxd interface
		apmib_get(MIB_WLAN_WSC_PRIORITY,(void *)&wsc_priority);  // 1: 2.4G, 2: 5G

		/* get MAC */
		memset(buffer, 0x0, 64);
		if (wsc_priority==2){       //5G
			snprintf(buffer, sizeof(buffer), file_path1, "wlan1-vxd");
			if ((lw_get_string_in_file(buffer, "hwaddr: ", connect_bssid, 13) == 1)) {
				printf ("[%s]: STA connects successfully, [5G/2.4G]connect_bssid=%s\n",__FILE__,connect_bssid);
			}
		}else{       //2G                                 
			snprintf(buffer, sizeof(buffer), file_path1, "wlan0-vxd");
			if ((lw_get_string_in_file(buffer, "hwaddr: ", connect_bssid, 13) == 1)) {
				printf ("[%s]: STA connects successfully, [2.4G/5G]connect_bssid=%s\n",__FILE__,connect_bssid);
			}       
		}
	}
	else if (wlan0_status==1 & wlan1_status==0) {     //connect to 2.4G
		/* get MAC */
		memset(buffer, 0x0, 64);
		snprintf(buffer, sizeof(buffer), file_path1, "wlan0-vxd");
		if ((lw_get_string_in_file(buffer, "hwaddr: ", connect_bssid, 13) == 1)) {
			printf ("[%s]: STA connects successfully, [2.4G]connect_bssid=%s\n",__FILE__,connect_bssid);
		}       
	}
	else if (wlan0_status==0 & wlan1_status==1) {     //connect to 5G
		/* get MAC */
		memset(buffer, 0x0, 64);
		snprintf(buffer, sizeof(buffer), file_path1, "wlan1-vxd");
		if ((lw_get_string_in_file(buffer, "hwaddr: ", connect_bssid, 13) == 1)) {
			printf ("[%s]: STA connects successfully, [5G]connect_bssid=%s\n",__FILE__,connect_bssid);
		}       
	}
	else {       //both disconnect
		printf ("[%s]: STA connects NG !\n",__FILE__);
	}
                
#endif	//#if 1 /* WNC-NMR000-[Linear]-Libera-20141105- Connect to which BSSID now? */

	wlan_idx = wlan_orig;
	vwlan_idx = vwlan_orig;

	for (i = 0; i < NUM_WLAN_INTERFACE; i++) 
	{
		if ((enableRadio >> i) & 0x1) 
		{
			sprintf(WLAN_IF, "wlan%d", i);
			pStatus->number = 0;
			if ( getWlSiteSurveyResult(WLAN_IF, pStatus) < 0 )
			{
				//ERR_MSG("Read site-survey status failed!");
				req_format_write(wp, "Read site-survey status failed!");
				free(pStatus); //sc_yang
				pStatus = NULL;
				return 0;
			}

			if (pStatus->number != 0xFF && pStatus->number > 0)
			{
				sslist = realloc(sslist, (ssnum+pStatus->number)*sizeof(SSEntry));
				if(sslist == NULL) 
				{
					return 0;
				}
				for (j=0;j<pStatus->number;j++) 
				{
// WNC-NMR0872-JDR231-HENG-I-CHEN-2014-12-23: Don't copy WPA/WPA2 Enterprise AP #BEGIN
					if (((pStatus->bssdb[j].bdTstamp[0] & 0x0000f000) >> 12) == 0x2) {
						continue;	/* ignore WPA/WPA2 Enterprise */
					} else if (((pStatus->bssdb[j].bdTstamp[0] & 0xf0000000) >> 28) == 0x2) {
						continue;	/* ignore WPA/WPA2 Enterprise */
					}
// WNC-NMR0872-JDR231-HENG-I-CHEN-2014-12-23: Don't copy WPA/WPA2 Enterprise AP #END
					dupSSEntry(&sslist[ssnum++], &pStatus->bssdb[j], i, (associatable > i)&0x1);
				}
			}
		}	
	}

	nBytesSent += req_format_write(wp, "new Array(");

	if (sslist == NULL) 
	{
/* WNC-NMR0000-Jog-Lin-20151217, move to web page and do nothing for survey responsive GUI */	
#if 0		
		nBytesSent += req_format_write(wp, ("<tr>"
			"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">ƵĤޤ</td>\n"	/* MR231-libera-20121208 - delete <pre> flag*/
			"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"
			"<td align=center width=\"30%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"
			//"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"
			"<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"
			"<td align=center width=\"30%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"
			"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"
			"</tr>\n"));
#endif
	} 
	else
	{
		int lastone = 0;
		int connected_AP_found = 0;

		qsort(sslist, ssnum, sizeof(SSEntry), compSSEntry);

		for (i=0; i < ssnum; i++)
		{
			more_ap = 0;
			pBss = &sslist[i];
			
			if (connected_AP_found == 0) 
			{
				snprintf(tmpBuf, 100, ("%02x%02x%02x%02x%02x%02x"),
					pBss->bdBssId[0], pBss->bdBssId[1], pBss->bdBssId[2],
					pBss->bdBssId[3], pBss->bdBssId[4], pBss->bdBssId[5]);

				if (strncasecmp(tmpBuf, connect_bssid, 12) == 0) 
				{
					connected_AP_found = 1;		
				}
			} 
			
			/* WNC-Jog-20160226
			  * Used to meet Spec. "Be sure to show the connected AP with no relation of signal strength"
			  */
			if (i >= 31)
			{
				if (connected_AP_found == 0)
				{
					if (i < ssnum-1)
					{
						continue;
					} else {
						pBss = &sslist[31];
					}
				}
				if (i > 31)
					i = 31;
				lastone = 1;
				more_ap = 1;
			}
			snprintf(tmpBuf, 100, ("%02x:%02x:%02x:%02x:%02x:%02x"),
				pBss->bdBssId[0], pBss->bdBssId[1], pBss->bdBssId[2],
				pBss->bdBssId[3], pBss->bdBssId[4], pBss->bdBssId[5]);

			memcpy(ssidbuf, pBss->bdSsIdBuf, pBss->bdSsId.Length);
			ssidbuf[pBss->bdSsId.Length] = '\0';
	        /* WNC-NMR0265-HENGI-CHEN-20121214-Fix bug Space character of SSID wouldn't be dipslayed */
			strcpy(ssidbuf2, ssidbuf);
	        /* WNC-NMR0265-HENGI-CHEN-20121214-End */

			/* WNC-NMR0245-JOE-PENG-20121211-Fix bug that SSID set as script wouldn't be displayed on wlsurvey page. */
			/* WNC-NMR0247-JOE-PENG-20121211-Fix bug that when script character is set as SSID, GUI would be wrong on Status page. */
			/* WNC-NMR0248-JOE-PENG-20121211-Fix bug that symbol characters are display in Select column on wlsurvey page. */
			/* Translate special character in SSID to HTML control code */
	        /* WNC-NMR0265-HENGI-CHEN-20121214-Fix bug Space character of SSID wouldn't be dipslayed */
			translate_control_code_and_space(ssidbuf);
			translate_control_code_and_space(ssidbuf2);	/* WNC-NMR1514-[Spider]-Libera-20160329- transform Special characters between javascript and html-v2 */
	        /* WNC-NMR0265-HENGI-CHEN-20121214-End */

#if 1	/* WNC-MR0000-Rita-20121123-If channel width is 40MHz (802.11n) show the channel as "control & extension" */
		//	if( pBss->network & BAND_11N ){
			if (pBss->network==(BAND_11G|BAND_11B | BAND_11N))
			{
				#define BIT(x)	(1 << (x))
				if ((pBss->bdTstamp[1] & (BIT(1) | BIT(2))) == (BIT(1) | BIT(2))) 
				{
					//HT40 lower
					sprintf(tmp1Buf, "%d&%d (11n 2.4GHz)", pBss->ChannelNumber, pBss->ChannelNumber - 4);/* WNC-MR0000-[Voyager]-Libera-20140207- SPEC.1.2 Channel format change */
					//pBss->sndchoff = HT_2NDCH_OFFSET_BELOW;
				}
				else if ((pBss->bdTstamp[1] & (BIT(1) | BIT(2))) == BIT(1))
				{
					//HT40 upper
					sprintf(tmp1Buf, "%d&%d (11n 2.4GHz)", pBss->ChannelNumber, pBss->ChannelNumber + 4);/* WNC-MR0000-[Voyager]-Libera-20140207- SPEC.1.2 Channel format change */
					//pBss->sndchoff =HT_2NDCH_OFFSET_ABOVE;
				}
				else
				{
					//HT20
					sprintf(tmp1Buf, "%d (11n 2.4GHz)", pBss->ChannelNumber);/* WNC-MR0000-[Voyager]-Libera-20140207- SPEC.1.2 Channel format change */
					//pBss->sndchoff = HT_2NDCH_OFFSET_DONTCARE;
				}
			} 
			else if (pBss->network== BAND_11A)
			{
				sprintf(tmp1Buf, "%d (11a 5GHz)", pBss->ChannelNumber);
			}
			else if (pBss->network== (BAND_11A | BAND_11N))
			{
				/* WNC-NMR000-[Linear]-Libera-20140804- show 11a/n/ac channel - start */
				if ((pBss->bdTstamp[1] & (BIT(1) | BIT(2))) == (BIT(1) | BIT(2))) {
					//HT40 lower
					sprintf(tmp1Buf, "%d&%d (11n 5GHz)", pBss->ChannelNumber, pBss->ChannelNumber - 4);
					//pBss->sndchoff = HT_2NDCH_OFFSET_BELOW;
				} else if ((pBss->bdTstamp[1] & (BIT(1) | BIT(2))) == BIT(1)) {
					//HT40 upper
					sprintf(tmp1Buf, "%d&%d (11n 5GHz)", pBss->ChannelNumber, pBss->ChannelNumber + 4);
					//pBss->sndchoff =HT_2NDCH_OFFSET_ABOVE;
				} else {
					//HT20
					sprintf(tmp1Buf, "%d (11n 5GHz)", pBss->ChannelNumber);
					//pBss->sndchoff = HT_2NDCH_OFFSET_DONTCARE;
				}
				/* WNC-NMR000-[Linear]-Libera-20140804- show 11a/n/ac channel -end */
			}
			else if (pBss->network== (BAND_11A | BAND_11N | BAND_5G_11AC))
			{
				/* WNC-NMR000-[Linear]-Libera-20140804- show 11a/n/ac channel - start */	
				//t_stamp[1], b5-b7 = channel width information, mapping to _HT_CHANNEL_WIDTH_AC
				if ((pBss->bdTstamp[1] & (HT_CHANNEL_WIDTH_AC_80 << BSS_BW_SHIFT)) == (HT_CHANNEL_WIDTH_AC_80 << BSS_BW_SHIFT)) {	/*AC HT80*/
					/* WNC-MR0000-[Linear]-Libera-20140704-start*/

					/* WNC-NMR0808-JOE-PENG-20141024-[Linear][Request] Request for Channel display about control and extension Ch-start */
#if 0
					if ((36<=pBss->ChannelNumber) && (pBss->ChannelNumber<=48))	
						sprintf(tmp1Buf, "36&40&44&48 (11ac 5GHz)");
					else if ((52<=pBss->ChannelNumber) && (pBss->ChannelNumber<=64))
						sprintf(tmp1Buf, "52&56&60&64 (11ac 5GHz)");
					else if ((100<=pBss->ChannelNumber) && (pBss->ChannelNumber<=112))
						sprintf(tmp1Buf, "100&104&108&112 (11ac 5GHz)");
					else if ((116<=pBss->ChannelNumber) && (pBss->ChannelNumber<=128))
						sprintf(tmp1Buf, "116&120&124&128 (11ac 5GHz)");			
					else
						sprintf(tmp1Buf, "%d (11ac 5GHz)", pBss->ChannelNumber);
#endif

					/* WNC-NMR0835-JOE-PENG-20141031- [Linear](CNV) There is a wrong display in channel of AP detection results-start */
					switch (pBss->ChannelNumber) {
						case 36:
							strncpy(tmp1Buf, "36&40&44&48 (11ac 5GHz)", sizeof(tmp1Buf));
							break;
						case 40:
							strncpy(tmp1Buf, "40&36&44&48 (11ac 5GHz)", sizeof(tmp1Buf));
							break;
						case 44:
							strncpy(tmp1Buf, "44&36&40&48 (11ac 5GHz)", sizeof(tmp1Buf));
							break;
						case 48:
							strncpy(tmp1Buf, "48&36&40&44 (11ac 5GHz)", sizeof(tmp1Buf));
							break;
						case 52:
							strncpy(tmp1Buf, "52&56&60&64 (11ac 5GHz)", sizeof(tmp1Buf));
							break;
						case 56:
							strncpy(tmp1Buf, "56&52&60&64 (11ac 5GHz)", sizeof(tmp1Buf));
							break;
						case 60:
							strncpy(tmp1Buf, "60&52&56&64 (11ac 5GHz)", sizeof(tmp1Buf));
							break;
						case 64:
							strncpy(tmp1Buf, "64&52&56&60 (11ac 5GHz)", sizeof(tmp1Buf));
							break;
						case 100:
							strncpy(tmp1Buf, "100&104&108&112 (11ac 5GHz)", sizeof(tmp1Buf));
							break;
						case 104:
							strncpy(tmp1Buf, "104&100&108&112 (11ac 5GHz)", sizeof(tmp1Buf));
							break;
						case 108:
							strncpy(tmp1Buf, "108&100&104&112 (11ac 5GHz)", sizeof(tmp1Buf));
							break;
						case 112:
							strncpy(tmp1Buf, "112&100&104&108 (11ac 5GHz)", sizeof(tmp1Buf));
							break;
						case 116:
							strncpy(tmp1Buf, "116&120&124&128 (11ac 5GHz)", sizeof(tmp1Buf));
							break;
						case 120:
							strncpy(tmp1Buf, "120&116&124&128 (11ac 5GHz)", sizeof(tmp1Buf));
							break;
						case 124:
							strncpy(tmp1Buf, "124&116&120&128 (11ac 5GHz)", sizeof(tmp1Buf));
							break;
						case 128:
							strncpy(tmp1Buf, "128&116&120&124 (11ac 5GHz)", sizeof(tmp1Buf));
							break;
						default:
							snprintf(tmp1Buf, sizeof(tmp1Buf), "%d (11ac 5GHz)", pBss->ChannelNumber);
							break;
					}
					/* WNC-NMR0835-JOE-PENG-20141031- [Linear](CNV) There is a wrong display in channel of AP detection results-end */
					/* WNC-NMR0808-JOE-PENG-20141024-[Linear][Request] Request for Channel display about control and extension Ch-end */
					/* WNC-MR0000-[Linear]-Libera-20140704-end*/	
				}
				else if (pBss->bdTstamp[1] & BIT(1))
				{	/*AC HT40*/
					if ((pBss->bdTstamp[1] & (BIT(1) | BIT(2))) == (BIT(1) | BIT(2))) 
					{
						//HT40 lower
						sprintf(tmp1Buf, "%d&%d (11ac 5GHz)", pBss->ChannelNumber, pBss->ChannelNumber - 4);
					}
					else if ((pBss->bdTstamp[1] & (BIT(1) | BIT(2))) == BIT(1)) 
					{
						//HT40 upper
						sprintf(tmp1Buf, "%d&%d (11ac 5GHz)", pBss->ChannelNumber, pBss->ChannelNumber + 4);
					}
				}
				else
				{	/*AC HT20*/
					/* WNC-MR0000-[Linear]-Libera-20140704-start*/
					sprintf(tmp1Buf, "%d (11ac 5GHz)", pBss->ChannelNumber);
					/* WNC-MR0000-[Linear]-Libera-20140704-end*/
				}
					/* WNC-NMR000-[Linear]-Libera-20140804- show 11a/n/ac channel - end */		
			}
			else 
			{
				/* WNC-MR0000-[Voyager]-Libera-20140207- SPEC.1.2 Channel format change -Start*/	 
				if (pBss->network==BAND_11B)
					sprintf(tmp1Buf, "%d (11b 2.4GHz)", pBss->ChannelNumber);
				else if (pBss->network==(BAND_11G|BAND_11B)||pBss->network==BAND_11G)
					sprintf(tmp1Buf, "%d (11g 2.4GHz)", pBss->ChannelNumber);
				/* WNC-MR0000-[Voyager]-Libera-20140207- SPEC.1.2 Channel format change -End*/			
			}
#else //Reltek
			if (pBss->network==BAND_11B)
				strcpy(tmp1Buf, (" (B)"));
			else if (pBss->network==BAND_11G)
				strcpy(tmp1Buf, (" (G)"));
			else if (pBss->network==(BAND_11G|BAND_11B))
				strcpy(tmp1Buf, (" (B+G)"));
			else if (pBss->network==(BAND_11N))
				strcpy(tmp1Buf, (" (N)"));
			else if (pBss->network==(BAND_11G|BAND_11N))
				strcpy(tmp1Buf, (" (G+N)"));
			else if (pBss->network==(BAND_11G|BAND_11B | BAND_11N))
				strcpy(tmp1Buf, (" (B+G+N)"));
			else if(pBss->network== BAND_11A)
				strcpy(tmp1Buf, (" (A)"));
			else if(pBss->network== (BAND_11A | BAND_11N))
				strcpy(tmp1Buf, (" (A+N)"));
			else
				sprintf(tmp1Buf, (" -%d-"),pBss->network);
#endif
			memset(wpa_tkip_aes,0x00,sizeof(wpa_tkip_aes));
			memset(wpa2_tkip_aes,0x00,sizeof(wpa2_tkip_aes));

			if ((pBss->bdCap & cPrivacy) == 0){
				sprintf(tmp2Buf, "Ź沽̵");
			}
			else 
			{
				if (pBss->bdTstamp[0] == 0)
					sprintf(tmp2Buf, "WEP");

				else {
					int wpa_exist = 0, idx = 0;
					if (pBss->bdTstamp[0] & 0x0000ffff) {
						idx = sprintf(tmp2Buf, "WPA");
						if (((pBss->bdTstamp[0] & 0x0000f000) >> 12) == 0x4)
							idx += sprintf(tmp2Buf+idx, "-PSK");
						else if(((pBss->bdTstamp[0] & 0x0000f000) >> 12) == 0x2){
							continue;	/* WNC-MR554-[Voyager]-Libera-20140212- ignore WPA/WPA2 Enterprise */
							idx += sprintf(tmp2Buf+idx, "-1X");
						}
						wpa_exist = 1;

						if (((pBss->bdTstamp[0] & 0x00000f00) >> 8) == 0x5){
							idx += sprintf(tmp2Buf+idx, "(TKIP/AES)");
							sprintf(wpa_tkip_aes,"%s","aes/tkip");
						}
						else if (((pBss->bdTstamp[0] & 0x00000f00) >> 8) == 0x4){
							idx += sprintf(tmp2Buf+idx, "(AES)");
							sprintf(wpa_tkip_aes,"%s","aes");
						}
						else if (((pBss->bdTstamp[0] & 0x00000f00) >> 8) == 0x1){
							idx += sprintf(tmp2Buf+idx, "(TKIP)");
							sprintf(wpa_tkip_aes,"%s","tkip");
						}
					}
					if (pBss->bdTstamp[0] & 0xffff0000) {
						if (wpa_exist){
							memset(tmp2Buf,0x00,sizeof(tmp2Buf));
							idx = sprintf(tmp2Buf, "WPA/WPA2");
							if (((pBss->bdTstamp[0] & 0xf0000000) >> 28) == 0x4)
								idx += sprintf(tmp2Buf+idx, "-PSK");
							else if (((pBss->bdTstamp[0] & 0xf0000000) >> 28) == 0x2){
								continue;	/* WNC-MR554-[Voyager]-Libera-20140212- ignore WPA/WPA2 Enterprise */
								idx += sprintf(tmp2Buf+idx, "-1X");
							}
							if (((pBss->bdTstamp[0] & 0x0f000000) >> 24) == 0x5){
								idx += sprintf(tmp2Buf+idx, "(TKIP/AES)");
								sprintf(wpa2_tkip_aes,"%s","aes/tkip");
							}
							else if (((pBss->bdTstamp[0] & 0x0f000000) >> 24) == 0x4){
								idx += sprintf(tmp2Buf+idx, "(AES)");
								sprintf(wpa2_tkip_aes,"%s","aes");
							}
							else if (((pBss->bdTstamp[0] & 0x0f000000) >> 24) == 0x1){
								idx += sprintf(tmp2Buf+idx, "(TKIP)");
								sprintf(wpa2_tkip_aes,"%s","tkip");
							}
						}else{
							idx += sprintf(tmp2Buf+idx, "WPA2");
							if (((pBss->bdTstamp[0] & 0xf0000000) >> 28) == 0x4)
								idx += sprintf(tmp2Buf+idx, "-PSK");
							else if (((pBss->bdTstamp[0] & 0xf0000000) >> 28) == 0x2){
								continue;	/* WNC-MR554-[Voyager]-Libera-20140212- ignore WPA/WPA2 Enterprise */
								idx += sprintf(tmp2Buf+idx, "-1X");
							}
							if (((pBss->bdTstamp[0] & 0x0f000000) >> 24) == 0x5){
								idx += sprintf(tmp2Buf+idx, "(TKIP/AES)");
								sprintf(wpa2_tkip_aes,"%s","aes/tkip");
							}
							else if (((pBss->bdTstamp[0] & 0x0f000000) >> 24) == 0x4){
								idx += sprintf(tmp2Buf+idx, "(AES)");
								sprintf(wpa2_tkip_aes,"%s","aes");
							}
							else if (((pBss->bdTstamp[0] & 0x0f000000) >> 24) == 0x1){
								idx += sprintf(tmp2Buf+idx, "(TKIP)");
								sprintf(wpa2_tkip_aes,"%s","tkip");
							}
						}
					}
				}
			}

			{
				if  (i != 0)
				{
					nBytesSent += req_format_write(wp, ",");
				}
				nBytesSent += req_format_write(wp, "{wlan_idx: %d, ssid: \'%s\', bssid: \'%s\', encrypt_str: \'%s\', channel_str: \'%s\', channel: %d, more_ap: %d,",
					pBss->wlan_idx, ssidbuf2, tmpBuf, tmp2Buf, tmp1Buf, pBss->ChannelNumber, more_ap);
	            /* WNC-MR0000-Rita-20121129-for NEC specification to express rssi with strong, medium and weak */
#if 1
				/* WNC-NMR0293-Rita-20130129-New request-RSSI subtract 5*/
				// WNC-NMR0000-JDR230-HENG-I-CHEN-20131014, rssi is unsigned char
				/* WNC-NMR0000-JOE-PENG-20140205-Modify signal strength in site survey page according to section 6.3.2 signal strength of Spec. V1.4.0-start */
#if 1
				if( pBss->rssi < 5 )
					pBss->rssi = 0;
				else
					pBss->rssi -= 5;
#endif
				/* WNC-NMR0000-JOE-PENG-20140205-Modify signal strength in site survey page according to section 6.3.2 signal strength of Spec. V1.4.0-end */
				// WNC-NMR0000-JDR230-HENG-I-CHEN-20131014 End
				/* WNC-NMR0293-Rita-20130129-End*/
				/* WNC-NMR0000-Rita-20121219-New RSSI Spec.*/
				/* WNC-NMR0000-JOE-PENG-20140205-Modify signal strength in site survey page according to section 6.3.2 signal strength of Spec. V1.4.0-start */
				/* WNC-NMR0000-JOE-PENG-20140213-Modify siginal strength (section 6.3.2) of Voyager according to attachment (value.png) of NEC mail [WNCSW:0359]-start */
				/* WNC-NMR0000-JOE-PENG-20140926-Modify signal strength according to section 6.3.2 of Linear Spec. V2.6.0 -start */
				#define BIT(x)	(1 << (x))

				if (pBss->wlan_idx == 0)
				{//2G
					if ((pBss->bdTstamp[1] & BIT(1)) == BIT(1))
					{ //HT40
						req_format_write(wp, " mode: \'ht40\', rssi: %d", pBss->rssi);
					}
					else
					{ //HT20
						req_format_write(wp, " mode: \'ht20\', rssi: %d", pBss->rssi);
					}
				} 
				else if (pBss->wlan_idx == 1)
				{//5G
					if ((pBss->bdTstamp[1] & (HT_CHANNEL_WIDTH_AC_80 << BSS_BW_SHIFT)) == (HT_CHANNEL_WIDTH_AC_80 << BSS_BW_SHIFT))
					{/*AC HT80*/
						req_format_write(wp, " mode: \'vht80\', rssi: %d", pBss->rssi);
					}
					else
					{
						if ((pBss->bdTstamp[1] & BIT(1)) == BIT(1))
						{ //HT40
							req_format_write(wp, " mode: \'ht40\', rssi: %d", pBss->rssi);
						}
						else
						{ //HT20
							req_format_write(wp, " mode: \'ht20\', rssi: %d", pBss->rssi);
						}
					}
				}

				nBytesSent += req_format_write(wp, "}");
				
				/* WNC-NMR0000-JOE-PENG-20140926-Modify signal strength according to section 6.3.2 of Linear Spec. V2.6.0 -end */
				/* WNC-NMR0000-JOE-PENG-20140213-Modify siginal strength (section 6.3.2) of Voyager according to attachment (value.png) of NEC mail [WNCSW:0359]-end */
				/* WNC-NMR0000-JOE-PENG-20140205-Modify signal strength in site survey page according to section 6.3.2 signal strength of Spec. V1.4.0-end */
				/* WNC-NMR0000-Rita-20121219-End.*/
#else
				if(pBss->rssi > 65)     //66 ~ 100
					nBytesSent += req_format_write(wp,(
						"<td align=center width=\"15%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"));
				else if(45 < pBss->rssi && pBss->rssi <= 65) //46~65
					nBytesSent += req_format_write(wp,(
						"<td align=center width=\"15%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n")); 
				else if(pBss->rssi <= 45) //0 ~ 45
					nBytesSent += req_format_write(wp,(
						"<td align=center width=\"15%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"));
				/* WNC-MR0000-Rita-20121129-End*/
#endif
			}
			
			if (lastone) {
// WNC-NMR0872-JDR231-HENG-I-CHEN-2014-12-23: Use Javascript in wlstabasic.htm to print message that warn over 32 AP #BEGIN
				if (ssnum > 32) {
				}
// WNC-NMR0872-JDR231-HENG-I-CHEN-2014-12-23: Use Javascript in wlstabasic.htm to print message that warn over 32 AP #END
				break;
			}
		}	
		free(sslist);
	}
	
	nBytesSent += req_format_write(wp, ");");

	return nBytesSent;
}
#endif /* WNC-NMR0000-Jog-Lin-20151217, end */

#if 0	// WNC-NMR0872-JDR231-HENG-I-CHEN-2014-12-11: Sort site survey result
// WNC-NMR0872-JDR231-HENG-I-CHEN-2014-12-11: Sort site survey result #END
int wlSiteSurveyWncTbl(request *wp, int argc, char **argv)
{
	int nBytesSent=0, i=0;/* WNC-NMR821-[Linear]-Libera-20141029- Consider one band site survey in dual band*/

	BssDscr *pBss;
	/* WNC-NMR0245-JOE-PENG-20121211-Fix bug that SSID set as script wouldn't be displayed on wlsurvey page. */
	/* Increase size of temp buffer "ssidbuf" from 40 to 500 because we want to translate */
	/* special character in SSID to HTML control code by function translate_control_code() */
/* WNC-NMR0265-HENGI-CHEN-20121214-Fix bug Space character of SSID wouldn't be dipslayed */
	char tmpBuf[100], ssidbuf[500], ssidbuf2[500], tmp1Buf[32], tmp2Buf[32], wpa_tkip_aes[20],wpa2_tkip_aes[20];
/* WNC-NMR0265-HENGI-CHEN-20121214-End */
	WLAN_MODE_T mode;
	bss_info bss;

	if (pStatus==NULL) {
		pStatus = calloc(1, sizeof(SS_STATUS_T));
		if ( pStatus == NULL ) {
			printf("Allocate buffer failed!\n");
			return 0;
		}
	}

//	pStatus->number = 0; // request BSS DB
	//strcat(WLAN_IF,"-vxd");

#if 1
/*WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode: Concurrent SS 2G/5G -Start*/	
	int ss_cunt=0;
	int link2ndRadioEntry=0;
	int _2ndEntrystart=0;
	int _1st_nmb=0;
	int _2nd_scan=0;
	
	if(NUM_WLAN_INTERFACE == 2){
		int wlan0_disable=0, wlan1_disable=0;
		int wlan_orig=0;

		wlan_orig = wlan_idx;
		SetWlan_idx("wlan0");
		apmib_get(MIB_WLAN_WLAN_DISABLED, &wlan0_disable);
		SetWlan_idx("wlan1");
		apmib_get(MIB_WLAN_WLAN_DISABLED, &wlan1_disable);
		wlan_idx = wlan_orig;


		if (wlan0_disable==1 && wlan1_disable==0){
			strcpy(WLAN_IF,"wlan1");
			ss_cunt=1;
		}else if (wlan0_disable==0 && wlan1_disable==1){
			strcpy(WLAN_IF,"wlan0");
			ss_cunt=1;
		}else if(wlan0_disable==0 && wlan1_disable==0){
			strcpy(WLAN_IF,"wlan0");
			ss_cunt=2;
		}else{
			ss_cunt=0;
			printf("Wlan disable!!, Func: %s\n",__FUNCTION__);
			return 0;
		}
	}
// do ss start
#endif
	while(ss_cunt){
	ss_again2:
		pStatus->number = 0; // request BSS DB
		{	// ss and get ss-info -start
			if ( getWlSiteSurveyResult(WLAN_IF, pStatus) < 0 ) {
				//ERR_MSG("Read site-survey status failed!");
				req_format_write(wp, "Read site-survey status failed!");
				free(pStatus); //sc_yang
				pStatus = NULL;
				return 0;
			}

			if ( !apmib_get( MIB_WLAN_MODE, (void *)&mode) ) {
				printf("Get MIB_WLAN_MODE MIB failed!");
				return 0;
			}

			if ( getWlBssInfo(WLAN_IF, &bss) < 0) {
				printf("Get bssinfo failed!");
				return 0;
			}
		}	// ss and get ss-info -end
	// ==== inserted by GANTOE for site survey 2008/12/26 ====
		{
			int rptEnabled=0;
#if defined(CONFIG_SMART_REPEATER)
			int opmode=0;
			apmib_get(MIB_OP_MODE, (void *)&opmode);
#endif
			if(wlan_idx == 0)
				apmib_get(MIB_REPEATER_ENABLED1, (void *)&rptEnabled);
			else
				apmib_get(MIB_REPEATER_ENABLED2, (void *)&rptEnabled);
				
			if(link2ndRadioEntry!=1){	// Head of SS Table - start
				nBytesSent += req_format_write(wp, ("<tr>"
				"<td align=center width=\"20%%\" bgcolor=\"#808080\"><font size=\"2\"><b>ͥåȥ̾(SSID)</b></font></td>\n"
				"<td align=center width=\"20%%\" bgcolor=\"#808080\"><font size=\"2\"><b>BSSID</b></font></td>\n"
				"<td align=center width=\"30%%\" bgcolor=\"#808080\"><font size=\"2\"><b>ѥͥ</b></font></td>\n"
			//      	"<td align=center width=\"20%%\" bgcolor=\"#808080\"><font size=\"2\"><b>Type</b></font></td>\n"
			      	"<td align=center width=\"10%%\" bgcolor=\"#808080\"><font size=\"2\"><b>Ź沽⡼</b></font></td>\n"
				"<td align=center width=\"40%%\" bgcolor=\"#808080\"><font size=\"2\"><b>٥</b></font></td>\n"));

				if( (mode == CLIENT_MODE )
#if defined(CONFIG_CHEEPER_REPEATER)
					|| (mode == AP_MODE && rptEnabled == 1)
#endif
				)
				{
					nBytesSent += req_format_write(wp, ("<td align=center width=\"15%%\" bgcolor=\"#808080\"><font size=\"2\"><b></b></font></td></tr>\n"));
				}
				else
					nBytesSent += req_format_write(wp, ("</tr>\n"));
			}	// Head of SS Table - End

		{//start to add entries to table. -start
			if (_2nd_scan==1 && pStatus->number==0 ){	//scan_2nd and ss_num=0 
				if(_2ndEntrystart!=0)	//if scan_1st!=0 break, else continue to add empty table.	/* WNC-NMR821-[Linear]-Libera-20141029- Consider one band site survey in dual band*/
					break;
			}
				
			if(link2ndRadioEntry!=1){
				/* WNC-NMR821-[Linear]-Libera-20141029- Consider one band site survey in dual band-start*/
				if (pStatus->number==0){	//scan_1st is 0, set scan_2nd first no=0
					_1st_nmb=pStatus->number;
				}else{	/* WNC-NMR821-[Linear]-Libera-20141029- Consider one band site survey in dual band-end*/
					_1st_nmb = pStatus->number;
					_1st_nmb--;	//last one of first radio ss.
				}
				
			}
			
			/* WNC-NMR821-[Linear]-Libera-20141029- Consider one band site survey in dual band-start*/
			if (ss_cunt==2 && (pStatus->number==0)){	//should scan twice(2G/5G) but first band ss_num=0
				goto band5_continue;
			}
			/* WNC-NMR821-[Linear]-Libera-20141029- Consider one band site survey in dual band-end*/

			for (i=0; i<pStatus->number && pStatus->number!=0xff; i++) {
				pBss = &pStatus->bssdb[i];
				snprintf(tmpBuf, 100, ("%02x:%02x:%02x:%02x:%02x:%02x"),
					pBss->bdBssId[0], pBss->bdBssId[1], pBss->bdBssId[2],
					pBss->bdBssId[3], pBss->bdBssId[4], pBss->bdBssId[5]);

				memcpy(ssidbuf, pBss->bdSsIdBuf, pBss->bdSsId.Length);
				ssidbuf[pBss->bdSsId.Length] = '\0';
		        /* WNC-NMR0265-HENGI-CHEN-20121214-Fix bug Space character of SSID wouldn't be dipslayed */
				strcpy(ssidbuf2, ssidbuf);
		        /* WNC-NMR0265-HENGI-CHEN-20121214-End */

				/* WNC-NMR0245-JOE-PENG-20121211-Fix bug that SSID set as script wouldn't be displayed on wlsurvey page. */
				/* WNC-NMR0247-JOE-PENG-20121211-Fix bug that when script character is set as SSID, GUI would be wrong on Status page. */
				/* WNC-NMR0248-JOE-PENG-20121211-Fix bug that symbol characters are display in Select column on wlsurvey page. */
				/* Translate special character in SSID to HTML control code */
		        /* WNC-NMR0265-HENGI-CHEN-20121214-Fix bug Space character of SSID wouldn't be dipslayed */
				translate_control_code_and_space(ssidbuf);
				translate_control_code(ssidbuf2);
		        /* WNC-NMR0265-HENGI-CHEN-20121214-End */

#if 1	/* WNC-MR0000-Rita-20121123-If channel width is 40MHz (802.11n) show the channel as "control & extension" */
		//	if( pBss->network & BAND_11N ){
			if (pBss->network==(BAND_11G|BAND_11B | BAND_11N)){
				#define BIT(x)	(1 << (x))
				if ((pBss->bdTstamp[1] & (BIT(1) | BIT(2))) == (BIT(1) | BIT(2))) {
					//HT40 lower
					sprintf(tmp1Buf, "%d&%d (11n 2.4GHz)", pBss->ChannelNumber, pBss->ChannelNumber - 4);/* WNC-MR0000-[Voyager]-Libera-20140207- SPEC.1.2 Channel format change */
					//pBss->sndchoff = HT_2NDCH_OFFSET_BELOW;
				} else if ((pBss->bdTstamp[1] & (BIT(1) | BIT(2))) == BIT(1)) {
					//HT40 upper
					sprintf(tmp1Buf, "%d&%d (11n 2.4GHz)", pBss->ChannelNumber, pBss->ChannelNumber + 4);/* WNC-MR0000-[Voyager]-Libera-20140207- SPEC.1.2 Channel format change */
					//pBss->sndchoff =HT_2NDCH_OFFSET_ABOVE;
				} else {
					//HT20
					sprintf(tmp1Buf, "%d (11n 2.4GHz)", pBss->ChannelNumber);/* WNC-MR0000-[Voyager]-Libera-20140207- SPEC.1.2 Channel format change */
					//pBss->sndchoff = HT_2NDCH_OFFSET_DONTCARE;
				}
			} 
			else if (pBss->network== BAND_11A)
			{
				sprintf(tmp1Buf, "%d (11a 5GHz)", pBss->ChannelNumber);
			}
			else if (pBss->network== (BAND_11A | BAND_11N))
			{
				/* WNC-NMR000-[Linear]-Libera-20140804- show 11a/n/ac channel - start */
				if ((pBss->bdTstamp[1] & (BIT(1) | BIT(2))) == (BIT(1) | BIT(2))) {
					//HT40 lower
					sprintf(tmp1Buf, "%d&%d (11n 5GHz)", pBss->ChannelNumber, pBss->ChannelNumber - 4);
					//pBss->sndchoff = HT_2NDCH_OFFSET_BELOW;
				} else if ((pBss->bdTstamp[1] & (BIT(1) | BIT(2))) == BIT(1)) {
					//HT40 upper
					sprintf(tmp1Buf, "%d&%d (11n 5GHz)", pBss->ChannelNumber, pBss->ChannelNumber + 4);
					//pBss->sndchoff =HT_2NDCH_OFFSET_ABOVE;
				} else {
					//HT20
					sprintf(tmp1Buf, "%d (11n 5GHz)", pBss->ChannelNumber);
					//pBss->sndchoff = HT_2NDCH_OFFSET_DONTCARE;
				}
				/* WNC-NMR000-[Linear]-Libera-20140804- show 11a/n/ac channel -end */
			}
			else if (pBss->network== (BAND_11A | BAND_11N | BAND_5G_11AC))
			{
				/* WNC-NMR000-[Linear]-Libera-20140804- show 11a/n/ac channel - start */	
				//t_stamp[1], b5-b7 = channel width information, mapping to _HT_CHANNEL_WIDTH_AC
				if ((pBss->bdTstamp[1] & (HT_CHANNEL_WIDTH_AC_80 << BSS_BW_SHIFT)) == (HT_CHANNEL_WIDTH_AC_80 << BSS_BW_SHIFT)) {	/*AC HT80*/
					/* WNC-MR0000-[Linear]-Libera-20140704-start*/

			/* WNC-NMR0808-JOE-PENG-20141024-[Linear][Request] Request for Channel display about control and extension Ch-start */
#if 0
			if ((36<=pBss->ChannelNumber) && (pBss->ChannelNumber<=48))	
				sprintf(tmp1Buf, "36&40&44&48 (11ac 5GHz)");
			else if ((52<=pBss->ChannelNumber) && (pBss->ChannelNumber<=64))
				sprintf(tmp1Buf, "52&56&60&64 (11ac 5GHz)");
			else if ((100<=pBss->ChannelNumber) && (pBss->ChannelNumber<=112))
				sprintf(tmp1Buf, "100&104&108&112 (11ac 5GHz)");
			else if ((116<=pBss->ChannelNumber) && (pBss->ChannelNumber<=128))
				sprintf(tmp1Buf, "116&120&124&128 (11ac 5GHz)");			
			else
				sprintf(tmp1Buf, "%d (11ac 5GHz)", pBss->ChannelNumber);
#endif

			/* WNC-NMR0835-JOE-PENG-20141031- [Linear](CNV) There is a wrong display in channel of AP detection results-start */
			switch (pBss->ChannelNumber) {
				case 36:
					strncpy(tmp1Buf, "36&40&44&48 (11ac 5GHz)", sizeof(tmp1Buf));
					break;
				case 40:
					strncpy(tmp1Buf, "40&36&44&48 (11ac 5GHz)", sizeof(tmp1Buf));
					break;
				case 44:
					strncpy(tmp1Buf, "44&36&40&48 (11ac 5GHz)", sizeof(tmp1Buf));
					break;
				case 48:
					strncpy(tmp1Buf, "48&36&40&44 (11ac 5GHz)", sizeof(tmp1Buf));
					break;
				case 52:
					strncpy(tmp1Buf, "52&56&60&64 (11ac 5GHz)", sizeof(tmp1Buf));
					break;
				case 56:
					strncpy(tmp1Buf, "56&52&60&64 (11ac 5GHz)", sizeof(tmp1Buf));
					break;
				case 60:
					strncpy(tmp1Buf, "60&52&56&64 (11ac 5GHz)", sizeof(tmp1Buf));
					break;
				case 64:
					strncpy(tmp1Buf, "64&52&56&60 (11ac 5GHz)", sizeof(tmp1Buf));
					break;
				case 100:
					strncpy(tmp1Buf, "100&104&108&112 (11ac 5GHz)", sizeof(tmp1Buf));
					break;
				case 104:
					strncpy(tmp1Buf, "104&100&108&112 (11ac 5GHz)", sizeof(tmp1Buf));
					break;
				case 108:
					strncpy(tmp1Buf, "108&100&104&112 (11ac 5GHz)", sizeof(tmp1Buf));
					break;
				case 112:
					strncpy(tmp1Buf, "112&100&104&108 (11ac 5GHz)", sizeof(tmp1Buf));
					break;
				case 116:
					strncpy(tmp1Buf, "116&120&124&128 (11ac 5GHz)", sizeof(tmp1Buf));
					break;
				case 120:
					strncpy(tmp1Buf, "120&116&124&128 (11ac 5GHz)", sizeof(tmp1Buf));
					break;
				case 124:
					strncpy(tmp1Buf, "124&116&120&128 (11ac 5GHz)", sizeof(tmp1Buf));
					break;
				case 128:
					strncpy(tmp1Buf, "128&116&120&124 (11ac 5GHz)", sizeof(tmp1Buf));
					break;
				default:
					snprintf(tmp1Buf, sizeof(tmp1Buf), "%d (11ac 5GHz)", pBss->ChannelNumber);
					break;
			}
			/* WNC-NMR0835-JOE-PENG-20141031- [Linear](CNV) There is a wrong display in channel of AP detection results-end */
			/* WNC-NMR0808-JOE-PENG-20141024-[Linear][Request] Request for Channel display about control and extension Ch-end */
			/* WNC-MR0000-[Linear]-Libera-20140704-end*/	
				}
				else if (pBss->bdTstamp[1] & BIT(1)){	/*AC HT40*/
					if ((pBss->bdTstamp[1] & (BIT(1) | BIT(2))) == (BIT(1) | BIT(2))) {
						//HT40 lower
						sprintf(tmp1Buf, "%d&%d (11ac 5GHz)", pBss->ChannelNumber, pBss->ChannelNumber - 4);
					} else if ((pBss->bdTstamp[1] & (BIT(1) | BIT(2))) == BIT(1)) {
						//HT40 upper
						sprintf(tmp1Buf, "%d&%d (11ac 5GHz)", pBss->ChannelNumber, pBss->ChannelNumber + 4);
					}
				}
				else{	/*AC HT20*/
					/* WNC-MR0000-[Linear]-Libera-20140704-start*/
					sprintf(tmp1Buf, "%d (11ac 5GHz)", pBss->ChannelNumber);
					/* WNC-MR0000-[Linear]-Libera-20140704-end*/
				}
				/* WNC-NMR000-[Linear]-Libera-20140804- show 11a/n/ac channel - end */		
			}
			 else 
			 {
		/* WNC-MR0000-[Voyager]-Libera-20140207- SPEC.1.2 Channel format change -Start*/	 
				if (pBss->network==BAND_11B)
					sprintf(tmp1Buf, "%d (11b 2.4GHz)", pBss->ChannelNumber);
				else if (pBss->network==(BAND_11G|BAND_11B)||pBss->network==BAND_11G)
					sprintf(tmp1Buf, "%d (11g 2.4GHz)", pBss->ChannelNumber);
		/* WNC-MR0000-[Voyager]-Libera-20140207- SPEC.1.2 Channel format change -End*/			
			 }
#else //Reltek
				if (pBss->network==BAND_11B)
					strcpy(tmp1Buf, (" (B)"));
				else if (pBss->network==BAND_11G)
					strcpy(tmp1Buf, (" (G)"));
				else if (pBss->network==(BAND_11G|BAND_11B))
					strcpy(tmp1Buf, (" (B+G)"));
				else if (pBss->network==(BAND_11N))
					strcpy(tmp1Buf, (" (N)"));
				else if (pBss->network==(BAND_11G|BAND_11N))
					strcpy(tmp1Buf, (" (G+N)"));
				else if (pBss->network==(BAND_11G|BAND_11B | BAND_11N))
					strcpy(tmp1Buf, (" (B+G+N)"));
				else if(pBss->network== BAND_11A)
					strcpy(tmp1Buf, (" (A)"));
				else if(pBss->network== (BAND_11A | BAND_11N))
					strcpy(tmp1Buf, (" (A+N)"));
				else
					sprintf(tmp1Buf, (" -%d-"),pBss->network);
#endif
				memset(wpa_tkip_aes,0x00,sizeof(wpa_tkip_aes));
				memset(wpa2_tkip_aes,0x00,sizeof(wpa2_tkip_aes));

				if ((pBss->bdCap & cPrivacy) == 0){
					sprintf(tmp2Buf, "Ź沽̵");
					}
				else 
					{
					if (pBss->bdTstamp[0] == 0)
						sprintf(tmp2Buf, "WEP");

					else {
						int wpa_exist = 0, idx = 0;
						if (pBss->bdTstamp[0] & 0x0000ffff) {
							idx = sprintf(tmp2Buf, "WPA");
							if (((pBss->bdTstamp[0] & 0x0000f000) >> 12) == 0x4)
								idx += sprintf(tmp2Buf+idx, "-PSK");
							else if(((pBss->bdTstamp[0] & 0x0000f000) >> 12) == 0x2){
								continue;	/* WNC-MR554-[Voyager]-Libera-20140212- ignore WPA/WPA2 Enterprise */
								idx += sprintf(tmp2Buf+idx, "-1X");
								}
							wpa_exist = 1;

							if (((pBss->bdTstamp[0] & 0x00000f00) >> 8) == 0x5){
								idx += sprintf(tmp2Buf+idx, "(TKIP/AES)");
								sprintf(wpa_tkip_aes,"%s","aes/tkip");
							}
							else if (((pBss->bdTstamp[0] & 0x00000f00) >> 8) == 0x4){
								idx += sprintf(tmp2Buf+idx, "(AES)");
								sprintf(wpa_tkip_aes,"%s","aes");
							}
							else if (((pBss->bdTstamp[0] & 0x00000f00) >> 8) == 0x1){
								idx += sprintf(tmp2Buf+idx, "(TKIP)");
								sprintf(wpa_tkip_aes,"%s","tkip");
							}
						}
						if (pBss->bdTstamp[0] & 0xffff0000) {
							if (wpa_exist){
								memset(tmp2Buf,0x00,sizeof(tmp2Buf));
								idx = sprintf(tmp2Buf, "WPA/WPA2");
								if (((pBss->bdTstamp[0] & 0xf0000000) >> 28) == 0x4)
									idx += sprintf(tmp2Buf+idx, "-PSK");
								else if (((pBss->bdTstamp[0] & 0xf0000000) >> 28) == 0x2){
									continue;	/* WNC-MR554-[Voyager]-Libera-20140212- ignore WPA/WPA2 Enterprise */
									idx += sprintf(tmp2Buf+idx, "-1X");
								}
								if (((pBss->bdTstamp[0] & 0x0f000000) >> 24) == 0x5){
									idx += sprintf(tmp2Buf+idx, "(TKIP/AES)");
									sprintf(wpa2_tkip_aes,"%s","aes/tkip");
								}
								else if (((pBss->bdTstamp[0] & 0x0f000000) >> 24) == 0x4){
									idx += sprintf(tmp2Buf+idx, "(AES)");
									sprintf(wpa2_tkip_aes,"%s","aes");
								}
								else if (((pBss->bdTstamp[0] & 0x0f000000) >> 24) == 0x1){
									idx += sprintf(tmp2Buf+idx, "(TKIP)");
									sprintf(wpa2_tkip_aes,"%s","tkip");
								}
							}else{
								idx += sprintf(tmp2Buf+idx, "WPA2");
								if (((pBss->bdTstamp[0] & 0xf0000000) >> 28) == 0x4)
									idx += sprintf(tmp2Buf+idx, "-PSK");
								else if (((pBss->bdTstamp[0] & 0xf0000000) >> 28) == 0x2){
									continue;	/* WNC-MR554-[Voyager]-Libera-20140212- ignore WPA/WPA2 Enterprise */
									idx += sprintf(tmp2Buf+idx, "-1X");
								}
								if (((pBss->bdTstamp[0] & 0x0f000000) >> 24) == 0x5){
									idx += sprintf(tmp2Buf+idx, "(TKIP/AES)");
									sprintf(wpa2_tkip_aes,"%s","aes/tkip");
								}
								else if (((pBss->bdTstamp[0] & 0x0f000000) >> 24) == 0x4){
									idx += sprintf(tmp2Buf+idx, "(AES)");
									sprintf(wpa2_tkip_aes,"%s","aes");
								}
								else if (((pBss->bdTstamp[0] & 0x0f000000) >> 24) == 0x1){
									idx += sprintf(tmp2Buf+idx, "(TKIP)");
									sprintf(wpa2_tkip_aes,"%s","tkip");
								}
							}
						}
					}
				}


				{
					nBytesSent += req_format_write(wp, ("<tr>"
					"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"	/* MR231-libera-20121208 - delete <pre> flag*/
					"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
				//	"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%d%s</td>\n"	//Rita --
					"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"	//Rita ++
		      	//		"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"	//type
					"<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"),
					ssidbuf, tmpBuf,tmp1Buf, tmp2Buf); //Rita ++
				//	ssidbuf, tmpBuf, pBss->ChannelNumber, tmp1Buf, tmp2Buf, pBss->rssi);	//Rita --
		            /* WNC-MR0000-Rita-20121129-for NEC specification to express rssi with strong, medium and weak */
				#if 1
				/* WNC-NMR0293-Rita-20130129-New request-RSSI subtract 5*/
				// WNC-NMR0000-JDR230-HENG-I-CHEN-20131014, rssi is unsigned char
		/* WNC-NMR0000-JOE-PENG-20140205-Modify signal strength in site survey page according to section 6.3.2 signal strength of Spec. V1.4.0-start */
#if 1
				if( pBss->rssi < 5 )
					pBss->rssi = 0;
				else
					pBss->rssi -= 5;
#endif
		/* WNC-NMR0000-JOE-PENG-20140205-Modify signal strength in site survey page according to section 6.3.2 signal strength of Spec. V1.4.0-end */
				// WNC-NMR0000-JDR230-HENG-I-CHEN-20131014 End
				/* WNC-NMR0293-Rita-20130129-End*/
				/* WNC-NMR0000-Rita-20121219-New RSSI Spec.*/
				/* WNC-NMR0000-JOE-PENG-20140205-Modify signal strength in site survey page according to section 6.3.2 signal strength of Spec. V1.4.0-start */
				/* WNC-NMR0000-JOE-PENG-20140213-Modify siginal strength (section 6.3.2) of Voyager according to attachment (value.png) of NEC mail [WNCSW:0359]-start */
				/* WNC-NMR0000-JOE-PENG-20140926-Modify signal strength according to section 6.3.2 of Linear Spec. V2.6.0 -start */
				#define BIT(x)	(1 << (x))

				if (!strcmp(WLAN_IF,"wlan0")){//2G
					if ((pBss->bdTstamp[1] & BIT(1)) == BIT(1)) { //HT40
						if( 19 <= pBss->rssi)	  
							nBytesSent += req_format_write(wp,("<td align=center width=\"15%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"));
						else if(15 <= pBss->rssi && pBss->rssi <= 18) 
							nBytesSent += req_format_write(wp,("<td align=center width=\"15%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n")); 
						else if(pBss->rssi <= 14) 
							nBytesSent += req_format_write(wp,("<td align=center width=\"15%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"));
					} else { //HT20
						if( 28 <= pBss->rssi)     
							nBytesSent += req_format_write(wp,("<td align=center width=\"15%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"));
						else if(18 <= pBss->rssi && pBss->rssi <= 27) 
							nBytesSent += req_format_write(wp,("<td align=center width=\"15%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n")); 
						else if(pBss->rssi <= 17) 
							nBytesSent += req_format_write(wp,("<td align=center width=\"15%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"));
					}
				}else if (!strcmp(WLAN_IF,"wlan1")){//5G
					if ((pBss->bdTstamp[1] & (HT_CHANNEL_WIDTH_AC_80 << BSS_BW_SHIFT)) == (HT_CHANNEL_WIDTH_AC_80 << BSS_BW_SHIFT)) {/*AC HT80*/
							if( 18 <= pBss->rssi)     
								nBytesSent += req_format_write(wp,("<td align=center width=\"15%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"));
							else if(14 <= pBss->rssi && pBss->rssi <= 17) 
								nBytesSent += req_format_write(wp,("<td align=center width=\"15%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n")); 
							else if(pBss->rssi <= 13) 
								nBytesSent += req_format_write(wp,("<td align=center width=\"15%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"));
					} else {
						if ((pBss->bdTstamp[1] & BIT(1)) == BIT(1)) { //HT40
							if( 20 <= pBss->rssi)	  
								nBytesSent += req_format_write(wp,("<td align=center width=\"15%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"));
							else if(15 <= pBss->rssi && pBss->rssi <= 19) 
								nBytesSent += req_format_write(wp,("<td align=center width=\"15%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n")); 
							else if(pBss->rssi <= 14) 
								nBytesSent += req_format_write(wp,("<td align=center width=\"15%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"));
						} else { //HT20
							if( 21 <= pBss->rssi)     
								nBytesSent += req_format_write(wp,("<td align=center width=\"15%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"));
							else if(15 <= pBss->rssi && pBss->rssi <= 20) 
								nBytesSent += req_format_write(wp,("<td align=center width=\"15%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n")); 
							else if(pBss->rssi <= 14) 
								nBytesSent += req_format_write(wp,("<td align=center width=\"15%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"));
						}
					}
				}
				
				/* WNC-NMR0000-JOE-PENG-20140926-Modify signal strength according to section 6.3.2 of Linear Spec. V2.6.0 -end */
				/* WNC-NMR0000-JOE-PENG-20140213-Modify siginal strength (section 6.3.2) of Voyager according to attachment (value.png) of NEC mail [WNCSW:0359]-end */
				/* WNC-NMR0000-JOE-PENG-20140205-Modify signal strength in site survey page according to section 6.3.2 signal strength of Spec. V1.4.0-end */
				 /* WNC-NMR0000-Rita-20121219-End.*/
				#else
		            if(pBss->rssi > 65)     //66 ~ 100
		                nBytesSent += req_format_write(wp,(
		                "<td align=center width=\"15%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"));
		            else if(45 < pBss->rssi && pBss->rssi <= 65) //46~65
		                nBytesSent += req_format_write(wp,(
		                "<td align=center width=\"15%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n")); 
		            else if(pBss->rssi <= 45) //0 ~ 45
		               nBytesSent += req_format_write(wp,(
		                "<td align=center width=\"15%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"));
		            /* WNC-MR0000-Rita-20121129-End*/
				#endif
				}

				if( ( mode == CLIENT_MODE )
#if defined(CONFIG_CHEEPER_REPEATER)
				|| (mode == AP_MODE && rptEnabled == 1)
#endif
#if defined(CONFIG_RTL_ULINKER)
				|| (mode == AP_MODE && rptEnabled == 1)
#endif
#if defined(CONFIG_SMART_REPEATER)
				||( (mode == AP_MODE) && (rptEnabled == 1) && (opmode == WISP_MODE))
#endif

				)
				{	// APs' info.
					if(link2ndRadioEntry!=1){		
					/* WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode: not support WEP, but can display in SS -Start*/
								if (!strncmp(tmp2Buf,"WEP",3)){
								nBytesSent += req_format_write(wp,
								("<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\"> <input type=\"hidden\" id=\"selSSID_%d\" value=\"%s\" > <input type=\"hidden\" id=\"selChannel_%d\" value=\"%d\" > <input type=\"hidden\" id=\"selEncrypt_%d\" value=\"%s\" > <input type=\"hidden\" id=\"wpa_tkip_aes_%d\" value=\"%s\" > <input type=\"hidden\" id=\"wpa2_tkip_aes_%d\" value=\"%s\" > <input type=\"hidden\" name="
								"\"select\" value=\"sel%d\" onClick=\"enableConnect(%d)\"></td></tr>\n"), i,ssidbuf2,i,pBss->ChannelNumber,i,tmp2Buf,i,wpa_tkip_aes,i,wpa2_tkip_aes ,i,i);
								}else{
					/* WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode -End*/		
					/* WNC-NMR0265-HENGI-CHEN-20121214-Fix bug Space character of SSID wouldn't be dipslayed */
								nBytesSent += req_format_write(wp,
								("<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\"> <input type=\"hidden\" id=\"selSSID_%d\" value=\"%s\" > <input type=\"hidden\" id=\"selChannel_%d\" value=\"%d\" > <input type=\"hidden\" id=\"selEncrypt_%d\" value=\"%s\" > <input type=\"hidden\" id=\"wpa_tkip_aes_%d\" value=\"%s\" > <input type=\"hidden\" id=\"wpa2_tkip_aes_%d\" value=\"%s\" > <input type=\"radio\" name="
								"\"select\" value=\"sel%d\" onClick=\"enableConnect(%d)\"></td></tr>\n"), i,ssidbuf2,i,pBss->ChannelNumber,i,tmp2Buf,i,wpa_tkip_aes,i,wpa2_tkip_aes ,i,i);
					/* WNC-NMR0265-HENGI-CHEN-20121214-End */
								}
					}else{	//add second radio entry info
					/* WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode: not support WEP, but can display in SS -Start*/
								if (!strncmp(tmp2Buf,"WEP",3)){
								nBytesSent += req_format_write(wp,
								("<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\"> <input type=\"hidden\" id=\"selSSID_%d\" value=\"%s\" > <input type=\"hidden\" id=\"selChannel_%d\" value=\"%d\" > <input type=\"hidden\" id=\"selEncrypt_%d\" value=\"%s\" > <input type=\"hidden\" id=\"wpa_tkip_aes_%d\" value=\"%s\" > <input type=\"hidden\" id=\"wpa2_tkip_aes_%d\" value=\"%s\" > <input type=\"hidden\" name="
								"\"select\" value=\"sel%d\" onClick=\"enableConnect(%d)\"></td></tr>\n"), _2ndEntrystart+i,ssidbuf2,_2ndEntrystart+i,pBss->ChannelNumber,_2ndEntrystart+i,tmp2Buf,_2ndEntrystart+i,wpa_tkip_aes,_2ndEntrystart+i,wpa2_tkip_aes ,_2ndEntrystart+i,_2ndEntrystart+i);
								}else{
					/* WNC-NMR000-[Linear]-Libera-20140528- SPEC: Converter mode -End*/		
					/* WNC-NMR0265-HENGI-CHEN-20121214-Fix bug Space character of SSID wouldn't be dipslayed */
								nBytesSent += req_format_write(wp,
								("<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\"> <input type=\"hidden\" id=\"selSSID_%d\" value=\"%s\" > <input type=\"hidden\" id=\"selChannel_%d\" value=\"%d\" > <input type=\"hidden\" id=\"selEncrypt_%d\" value=\"%s\" > <input type=\"hidden\" id=\"wpa_tkip_aes_%d\" value=\"%s\" > <input type=\"hidden\" id=\"wpa2_tkip_aes_%d\" value=\"%s\" > <input type=\"radio\" name="
								"\"select\" value=\"sel%d\" onClick=\"enableConnect(%d)\"></td></tr>\n"), _2ndEntrystart+i,ssidbuf2,_2ndEntrystart+i,pBss->ChannelNumber,_2ndEntrystart+i,tmp2Buf,_2ndEntrystart+i,wpa_tkip_aes,_2ndEntrystart+i,wpa2_tkip_aes ,_2ndEntrystart+i,_2ndEntrystart+i);
					/* WNC-NMR0265-HENGI-CHEN-20121214-End */
								}
					}

					//second radio AP info - start
					band5_continue:	/* WNC-NMR821-[Linear]-Libera-20141029- Consider one band site survey in dual band*/
					if(ss_cunt==2 && i==_1st_nmb){
						//swap interface.
						if (!strcmp(WLAN_IF,"wlan0")){
							strcpy(WLAN_IF, "wlan1");
						}else if (!strcmp(WLAN_IF,"wlan1")){
							strcpy(WLAN_IF, "wlan0");
						}else{
							break;
						}
						ss_cunt=0;
						link2ndRadioEntry=1;
						_2ndEntrystart = pStatus->number;
						_2nd_scan=1;
						
						goto ss_again2;
					}
					//second radio AP info -end
				}
				else
					nBytesSent += req_format_write(wp, ("</tr>\n"));
			}
		}	//start to add entries to table -end.

	/////////////////////////////////////////////////////////////////////////////
		// SiteSurvey --> Non AP
		if( pStatus->number == 0 || pStatus->number == 0xff )	/* WNC-NMR0237-Libera-20121212 */
		{
			if (( mode == CLIENT_MODE )
#if defined(CONFIG_CHEEPER_REPEATER)
			|| (mode == AP_MODE && rptEnabled == 1)
#endif
#if defined(CONFIG_RTL_ULINKER)
			|| (mode == AP_MODE && rptEnabled == 1)
#endif
#if defined(CONFIG_SMART_REPEATER)
			||( (mode == AP_MODE) && (rptEnabled == 1) && (opmode == WISP_MODE))
#endif
			)
			{
				nBytesSent += req_format_write(wp, ("<tr>"
		                "<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">ƵĤޤ</td>\n"	/* MR231-libera-20121208 - delete <pre> flag*/
		                "<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"
		                "<td align=center width=\"30%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"
		            //    "<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"
		                "<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"
		                "<td align=center width=\"30%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"
		                "<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"
		                "</tr>\n"));
			}
			else
			{
				nBytesSent += req_format_write(wp, ("<tr>"
				"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">None</td>\n"	/* MR231-libera-20121208 - delete <pre> flag*/
				"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"
				"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"
			//	"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"
				"<td align=center width=\"10%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"
				"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"
				"</tr>\n"));
			}
		}

// WNC-NMR0863-JDR231-HENG-I-CHEN-2014-11-27: remove unnecessary </table> tag #BEGIN
//		nBytesSent += req_format_write(wp, ("</table>\n"));
// WNC-NMR0863-JDR231-HENG-I-CHEN-2014-11-27: remove unnecessary </table> tag #END

		}
		
		break;	//break ss_count while
	}	//while 	end
	return nBytesSent;
}
// WNC-NMR0872-JDR231-HENG-I-CHEN-2014-12-11: Sort site survey result #BEGIN
#endif	//#if 0	// WNC-NMR0872-JDR231-HENG-I-CHEN-2014-12-11: Sort site survey result
// WNC-NMR0872-JDR231-HENG-I-CHEN-2014-12-11: Sort site survey result #END
#endif	/* WNC-MR0000-Libera-Jan-20121101- new spec. - Repeater mode */

#if 0	/* WNC-MR0000-Libera-Jan-20121101- new spec. - Repeater mode */
int wlSiteSurveyWncTbl(request *wp, int argc, char **argv)
{
	int nBytesSent=0, i;

	BssDscr *pBss;
	/* WNC-NMR0245-JOE-PENG-20121211-Fix bug that SSID set as script wouldn't be displayed on wlsurvey page. */
	/* Increase size of temp buffer "ssidbuf" from 40 to 500 because we want to translate */
	/* special character in SSID to HTML control code by function translate_control_code() */
/* WNC-NMR0265-HENGI-CHEN-20121214-Fix bug Space character of SSID wouldn't be dipslayed */
	char tmpBuf[100], ssidbuf[500], ssidbuf2[500], tmp1Buf[10], tmp2Buf[32], tmp3Buf[32], wpa_tkip_aes[20],wpa2_tkip_aes[20];
/* WNC-NMR0265-HENGI-CHEN-20121214-End */


	WLAN_MODE_T mode;
	bss_info bss;

	if (pStatus==NULL) {
		pStatus = calloc(1, sizeof(SS_STATUS_T));
		if ( pStatus == NULL ) {
			printf("Allocate buffer failed!\n");
			return 0;
		}
	}

	pStatus->number = 0; // request BSS DB
	//strcat(WLAN_IF,"-vxd");


	if ( getWlSiteSurveyResult(WLAN_IF, pStatus) < 0 ) {
		//ERR_MSG("Read site-survey status failed!");
		req_format_write(wp, "Read site-survey status failed!");
		free(pStatus); //sc_yang
		pStatus = NULL;
		return 0;
	}

	if ( !apmib_get( MIB_WLAN_MODE, (void *)&mode) ) {
		printf("Get MIB_WLAN_MODE MIB failed!");
		return 0;
	}

	if ( getWlBssInfo(WLAN_IF, &bss) < 0) {
		printf("Get bssinfo failed!");
		return 0;
	}

// ==== inserted by GANTOE for site survey 2008/12/26 ====

	{
		int rptEnabled=0;
#if defined(CONFIG_SMART_REPEATER)
		int opmode=0;
		apmib_get(MIB_OP_MODE, (void *)&opmode);
#endif
		if(wlan_idx == 0)
			apmib_get(MIB_REPEATER_ENABLED1, (void *)&rptEnabled);
		else
			apmib_get(MIB_REPEATER_ENABLED2, (void *)&rptEnabled);

	nBytesSent += req_format_write(wp, ("<tr>"
	"<td align=center width=\"25%%\" bgcolor=\"#808080\"><font size=\"2\"><b>ͥåȥ̾<BR>(SSID)</b></font></td>\n"
	"<td align=center width=\"20%%\" bgcolor=\"#808080\"><font size=\"2\"><b>BSSID</b></font></td>\n"
	"<td align=center width=\"15%%\" bgcolor=\"#808080\"><font size=\"2\"><b>ѥͥ</b></font></td>\n"
   	"<td align=center width=\"10%%\" bgcolor=\"#808080\"><font size=\"2\"><b>Ź沽⡼</b></font></td>\n"
	"<td align=center width=\"10%%\" bgcolor=\"#808080\"><font size=\"2\"><b>٥</b></font></td>\n"
	"<td align=center width=\"10%%\" bgcolor=\"#808080\"><font size=\"2\"><b></b></font></td></tr>\n"));

	for (i=0; i<pStatus->number && pStatus->number!=0xff; i++) {
		pBss = &pStatus->bssdb[i];
		snprintf(tmpBuf, 100, ("%02x:%02x:%02x:%02x:%02x:%02x"),
			pBss->bdBssId[0], pBss->bdBssId[1], pBss->bdBssId[2],
			pBss->bdBssId[3], pBss->bdBssId[4], pBss->bdBssId[5]);

		memcpy(ssidbuf, pBss->bdSsIdBuf, pBss->bdSsId.Length);
		ssidbuf[pBss->bdSsId.Length] = '\0';
        /* WNC-NMR0265-HENGI-CHEN-20121214-Fix bug Space character of SSID wouldn't be dipslayed */
		strcpy(ssidbuf2, ssidbuf);
        /* WNC-NMR0265-HENGI-CHEN-20121214-End */

		/* WNC-NMR0245-JOE-PENG-20121211-Fix bug that SSID set as script wouldn't be displayed on wlsurvey page. */
		/* WNC-NMR0247-JOE-PENG-20121211-Fix bug that when script character is set as SSID, GUI would be wrong on Status page. */
		/* WNC-NMR0248-JOE-PENG-20121211-Fix bug that symbol characters are display in Select column on wlsurvey page. */
		/* Translate special character in SSID to HTML control code */
        /* WNC-NMR0265-HENGI-CHEN-20121214-Fix bug Space character of SSID wouldn't be dipslayed */
		translate_control_code_and_space(ssidbuf);
		translate_control_code(ssidbuf2);
        /* WNC-NMR0265-HENGI-CHEN-20121214-End */

#if 1	/* WNC-MR0000-Rita-20121123-If channel width is 40MHz (802.11n) show the channel as "control & extension" */
	if( pBss->network & BAND_11N ){
		#define BIT(x)	(1 << (x))
		if ((pBss->bdTstamp[1] & (BIT(1) | BIT(2))) == (BIT(1) | BIT(2))) {
			//HT40 lower
			sprintf(tmp1Buf, "%d&%d", pBss->ChannelNumber, pBss->ChannelNumber - 4);
			//pBss->sndchoff = HT_2NDCH_OFFSET_BELOW;
		} else if ((pBss->bdTstamp[1] & (BIT(1) | BIT(2))) == BIT(1)) {
			//HT40 upper
			sprintf(tmp1Buf, "%d&%d", pBss->ChannelNumber, pBss->ChannelNumber + 4);
			//pBss->sndchoff =HT_2NDCH_OFFSET_ABOVE;
		} else {
			//HT20
			sprintf(tmp1Buf, "%d", pBss->ChannelNumber);
			//pBss->sndchoff = HT_2NDCH_OFFSET_DONTCARE;
		}
		#if 0
		 /* Channel width is 40MHz */
		 /* WNC-NMR0000-JOE-PENG-20120713-Implement NEC spec. request CheeperSW0706: Change order of extension and control channel */
		 /* If channel width is set to 40Mhz */
		 /* then show the channel as below according to NEC's spec. */
		 /*  If original channel is between 1 and 4, then show "<channel>&<channel>+4" */
		 /*  If original channel is bigger than 5, then show "<channel>&<channel>-4" */
		 /*  other case, show original channel */
		 if ((pBss->ChannelNumber >= 1) && (pBss->ChannelNumber <= 4)) {
			 sprintf(tmp1Buf, "%d&%d", pBss->ChannelNumber, pBss->ChannelNumber + 4);
		 } else if (pBss->ChannelNumber >= 5) {
			 sprintf(tmp1Buf, "%d&%d", pBss->ChannelNumber, pBss->ChannelNumber - 4);
		 } else {
			 sprintf(tmp1Buf, "%d", pBss->ChannelNumber);
		 }
		 /* WNC-NMR0000-JOE-PENG-20120713-end */
		 #endif
	 } else {
		 sprintf(tmp1Buf, "%d", pBss->ChannelNumber);
	 }
#else //Reltek
		if (pBss->network==BAND_11B)
			strcpy(tmp1Buf, (" (B)"));
		else if (pBss->network==BAND_11G)
			strcpy(tmp1Buf, (" (G)"));
		else if (pBss->network==(BAND_11G|BAND_11B))
			strcpy(tmp1Buf, (" (B+G)"));
		else if (pBss->network==(BAND_11N))
			strcpy(tmp1Buf, (" (N)"));
		else if (pBss->network==(BAND_11G|BAND_11N))
			strcpy(tmp1Buf, (" (G+N)"));
		else if (pBss->network==(BAND_11G|BAND_11B | BAND_11N))
			strcpy(tmp1Buf, (" (B+G+N)"));
		else if(pBss->network== BAND_11A)
			strcpy(tmp1Buf, (" (A)"));
		else if(pBss->network== (BAND_11A | BAND_11N))
			strcpy(tmp1Buf, (" (A+N)"));
		else
			sprintf(tmp1Buf, (" -%d-"),pBss->network);
#endif
		memset(wpa_tkip_aes,0x00,sizeof(wpa_tkip_aes));
		memset(wpa2_tkip_aes,0x00,sizeof(wpa2_tkip_aes));

		if ((pBss->bdCap & cPrivacy) == 0){
			sprintf(tmp2Buf, "Ź沽̵");
			sprintf(tmp3Buf, "None");
			}
		else 
			{
			if (pBss->bdTstamp[0] == 0) {
				sprintf(tmp2Buf, "WEP");
				sprintf(tmp3Buf, "WEP");
			} else {
				int wpa_exist = 0, idx = 0;
				if (pBss->bdTstamp[0] & 0x0000ffff) {
					idx = sprintf(tmp2Buf, "WPA");
					if (((pBss->bdTstamp[0] & 0x0000f000) >> 12) == 0x4)
						idx += sprintf(tmp2Buf+idx, "-PSK");
					else if(((pBss->bdTstamp[0] & 0x0000f000) >> 12) == 0x2)
						idx += sprintf(tmp2Buf+idx, "-1X");
					wpa_exist = 1;
					if (((pBss->bdTstamp[0] & 0x00000f00) >> 8) == 0x5){
						idx += sprintf(tmp2Buf+idx, "(AES/TKIP)");
						sprintf(wpa_tkip_aes,"%s","aes/tkip");
					}
					else if (((pBss->bdTstamp[0] & 0x00000f00) >> 8) == 0x4){
						idx += sprintf(tmp2Buf+idx, "(AES)");
						sprintf(wpa_tkip_aes,"%s","aes");
					}
					else if (((pBss->bdTstamp[0] & 0x00000f00) >> 8) == 0x1){
						idx += sprintf(tmp2Buf+idx, "(TKIP)");
						sprintf(wpa_tkip_aes,"%s","tkip");
					}

					strcpy(tmp3Buf, tmp2Buf);

				}
				if (pBss->bdTstamp[0] & 0xffff0000) {
					if (wpa_exist){
						memset(tmp2Buf,0x00,sizeof(tmp2Buf));
						idx = sprintf(tmp2Buf, "WPA/WPA2");
						if (((pBss->bdTstamp[0] & 0xf0000000) >> 28) == 0x4)
							idx += sprintf(tmp2Buf+idx, "-PSK");
						else if (((pBss->bdTstamp[0] & 0xf0000000) >> 28) == 0x2)
							idx += sprintf(tmp2Buf+idx, "-1X");
					
						if (((pBss->bdTstamp[0] & 0x0f000000) >> 24) == 0x5){
							idx += sprintf(tmp2Buf+idx, "(AES/TKIP)");
							sprintf(wpa2_tkip_aes,"%s","aes/tkip");
						}
						else if (((pBss->bdTstamp[0] & 0x0f000000) >> 24) == 0x4){
							idx += sprintf(tmp2Buf+idx, "(AES)");
							sprintf(wpa2_tkip_aes,"%s","aes");
						}
						else if (((pBss->bdTstamp[0] & 0x0f000000) >> 24) == 0x1){
							idx += sprintf(tmp2Buf+idx, "(TKIP)");
							sprintf(wpa2_tkip_aes,"%s","tkip");
						}

						strcpy(tmp3Buf, tmp2Buf);

					}else{
						idx += sprintf(tmp2Buf+idx, "WPA2");
						if (((pBss->bdTstamp[0] & 0xf0000000) >> 28) == 0x4)
							idx += sprintf(tmp2Buf+idx, "-PSK");
						else if (((pBss->bdTstamp[0] & 0xf0000000) >> 28) == 0x2)
							idx += sprintf(tmp2Buf+idx, "-1X");

						if (((pBss->bdTstamp[0] & 0x0f000000) >> 24) == 0x5){
							idx += sprintf(tmp2Buf+idx, "(AES/TKIP)");
							sprintf(wpa2_tkip_aes,"%s","aes/tkip");
						}
						else if (((pBss->bdTstamp[0] & 0x0f000000) >> 24) == 0x4){
							idx += sprintf(tmp2Buf+idx, "(AES)");
							sprintf(wpa2_tkip_aes,"%s","aes");
						}
						else if (((pBss->bdTstamp[0] & 0x0f000000) >> 24) == 0x1){
							idx += sprintf(tmp2Buf+idx, "(TKIP)");
							sprintf(wpa2_tkip_aes,"%s","tkip");
						}

						strcpy(tmp3Buf, tmp2Buf);
						
					}
				}
			}
		}


		{
			nBytesSent += req_format_write(wp, ("<tr>"
			"<td align=center bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"	/* MR231-libera-20121208 - delete <pre> flag*/
			"<td align=center bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"
		//	"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%d%s</td>\n"	//Rita --
			"<td align=center bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"	//Rita ++
      	//		"<td align=center width=\"20%%\" bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"	//type
			"<td align=center bgcolor=\"#C0C0C0\"><font size=\"2\">%s</td>\n"),
			ssidbuf, tmpBuf,tmp1Buf, tmp2Buf); //Rita ++
		//	ssidbuf, tmpBuf, pBss->ChannelNumber, tmp1Buf, tmp2Buf, pBss->rssi);	//Rita --
            /* WNC-MR0000-Rita-20121129-for NEC specification to express rssi with strong, medium and weak */
		#if 1
		/* WNC-NMR0293-Rita-20130129-New request-RSSI subtract 5*/
		// WNC-NMR0000-JDR230-HENG-I-CHEN-20131014, rssi is unsigned char
		if( pBss->rssi < 5 )
			pBss->rssi = 0;
		else
			pBss->rssi -= 5;
		// WNC-NMR0000-JDR230-HENG-I-CHEN-20131014 End
		/* WNC-NMR0293-Rita-20130129-End*/
		/* WNC-NMR0000-Rita-20121219-New RSSI Spec.*/
			#define BIT(x)	(1 << (x))
			if ((pBss->bdTstamp[1] & BIT(1)) == BIT(1)) { //HT40
				if( 20 <= pBss->rssi)	  
					nBytesSent += req_format_write(wp,(
					"<td align=center bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"));
				else if(11 <= pBss->rssi && pBss->rssi <= 19) 
					nBytesSent += req_format_write(wp,(
					"<td align=center bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n")); 
				else if(pBss->rssi <= 10) 
					nBytesSent += req_format_write(wp,(
					"<td align=center bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"));
			} else { //HT20
				if( 28 <= pBss->rssi)     
                	nBytesSent += req_format_write(wp,(
                	"<td align=center bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"));
            	else if(14 <= pBss->rssi && pBss->rssi <= 27) 
              	  	nBytesSent += req_format_write(wp,(
               	 	"<td align=center bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n")); 
            	else if(pBss->rssi <= 13) 
               		nBytesSent += req_format_write(wp,(
               	 	"<td align=center bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"));
			}
		 /* WNC-NMR0000-Rita-20121219-End.*/
		#else
            if(pBss->rssi > 65)     //66 ~ 100
                nBytesSent += req_format_write(wp,(
                "<td align=center bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"));
            else if(45 < pBss->rssi && pBss->rssi <= 65) //46~65
                nBytesSent += req_format_write(wp,(
                "<td align=center bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n")); 
            else if(pBss->rssi <= 45) //0 ~ 45
               nBytesSent += req_format_write(wp,(
                "<td align=center bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"));
            /* WNC-MR0000-Rita-20121129-End*/
		#endif
		}

#if 0
		if( ( mode == CLIENT_MODE )
#if defined(CONFIG_CHEEPER_REPEATER)
		|| (mode == AP_MODE && rptEnabled == 1)
#endif
#if defined(CONFIG_RTL_ULINKER)
		|| (mode == AP_MODE && rptEnabled == 1)
#endif
#if defined(CONFIG_SMART_REPEATER)
		||( (mode == AP_MODE) && (rptEnabled == 1) && (opmode == WISP_MODE))
#endif

		)
#endif		
		// APs' info.
/* WNC-NMR0265-HENGI-CHEN-20121214-Fix bug Space character of SSID wouldn't be dipslayed */
		nBytesSent += req_format_write(wp,
		("<td align=center bgcolor=\"#C0C0C0\">"
		 "<input type=\"hidden\" id=\"selSSID_%d\" value=\"%s\" >"
		 "<input type=\"hidden\" id=\"selEncrypt_%d\" value=\"%s\" >"
		 "<input type=\"radio\" name=\"select\" value=\"sel%d\" onClick=\"enableConnect(%d)\">"
		 "</td></tr>\n"), 
		 i, ssidbuf2,
		 i, tmp3Buf, 
		 i, i);
/* WNC-NMR0265-HENGI-CHEN-20121214-End */
	}
/////////////////////////////////////////////////////////////////////////////
	// SiteSurvey --> Non AP
	if( pStatus->number == 0 || pStatus->number == 0xff )	/* WNC-NMR0237-Libera-20121212 */
	{
		nBytesSent += req_format_write(wp, ("<tr>"
                "<td align=center bgcolor=\"#C0C0C0\"><font size=\"2\">ƵĤޤ</td>\n"	/* MR231-libera-20121208 - delete <pre> flag*/
                "<td align=center bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"
                "<td align=center bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"
                "<td align=center bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"
                "<td align=center bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"
                "<td align=center bgcolor=\"#C0C0C0\"><font size=\"2\"></td>\n"
                "</tr>\n"));
	}
	nBytesSent += req_format_write(wp, ("</table>\n"));

	}
	return nBytesSent;
}
#endif	/* WNC-MR0000-Libera-Jan-20121101- new spec. - Repeater mode */
#ifdef CONFIG_RTK_MESH
/////////////////////////////////////////////////////////////////////////////
void formWlMesh(request *wp, char *path, char *query)
{
	char *strAddMac, *strDelMac, *strDelAllMac, *strVal, *submitUrl, *strEnabled;
	char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};
	int entryNum, i, enabled;
	WDS_T macEntry;

	strAddMac = req_get_cstream_var(wp, ("addWdsMac"), "");
	strDelMac = req_get_cstream_var(wp, ("deleteSelWdsMac"), "");
	strDelAllMac = req_get_cstream_var(wp, ("deleteAllWdsMac"), "");
	strEnabled = req_get_cstream_var(wp, ("wlanWdsEnabled"), "");

	if (strAddMac[0]) {
		if ( !strcmp(strEnabled, "ON"))
			enabled = 1;
		else
			enabled = 0;
		if ( apmib_set( MIB_WLAN_WDS_ENABLED, (void *)&enabled) == 0) {
  			strcpy(tmpBuf, ("Set enabled flag error!"));
			goto setErr_wds;
		}

		strVal = req_get_cstream_var(wp, ("mac"), "");
		if ( !strVal[0] )
			goto setWds_ret;

		if (strlen(strVal)!=12 || !string_to_hex(strVal, macEntry.macAddr, 12)) {
			strcpy(tmpBuf, ("Error! Invalid MAC address."));
			goto setErr_wds;
		}

		strVal = req_get_cstream_var(wp, ("comment"), "");
		if ( strVal[0] ) {
			if (strlen(strVal) > COMMENT_LEN-1) {
				strcpy(tmpBuf, ("Error! Comment length too long."));
				goto setErr_wds;
			}
			strcpy(macEntry.comment, strVal);
		}
		else
			macEntry.comment[0] = '\0';

		if ( !apmib_get(MIB_WLAN_WDS_NUM, (void *)&entryNum)) {
			strcpy(tmpBuf, ("Get entry number error!"));
			goto setErr_wds;
		}
		if ( (entryNum + 1) > MAX_WDS_NUM) {
			strcpy(tmpBuf, ("Cannot add new entry because table is full!"));
			goto setErr_wds;
		}

		// set to MIB. try to delete it first to avoid duplicate case
		apmib_set(MIB_WLAN_WDS_DEL, (void *)&macEntry);
		if ( apmib_set(MIB_WLAN_WDS_ADD, (void *)&macEntry) == 0) {
			strcpy(tmpBuf, ("Add table entry error!"));
			goto setErr_wds;
		}
	}

	/* Delete entry */
	if (strDelMac[0]) {
		if ( !apmib_get(MIB_WLAN_WDS_NUM, (void *)&entryNum)) {
			strcpy(tmpBuf, ("Get entry number error!"));
			goto setErr_wds;
		}
		for (i=entryNum; i>0; i--) {
			snprintf(tmpBuf, 20, "select%d", i);

			strVal = req_get_cstream_var(wp, tmpBuf, "");
			if ( !strcmp(strVal, "ON") ) {

				*((char *)&macEntry) = (char)i;
				if ( !apmib_get(MIB_WLAN_WDS, (void *)&macEntry)) {
					strcpy(tmpBuf, ("Get table entry error!"));
					goto setErr_wds;
				}
				if ( !apmib_set(MIB_WLAN_WDS_DEL, (void *)&macEntry)) {
					strcpy(tmpBuf, ("Delete table entry error!"));
					goto setErr_wds;
				}
			}
		}
	}

	/* Delete all entry */
	if ( strDelAllMac[0]) {
		if ( !apmib_set(MIB_WLAN_WDS_DELALL, (void *)&macEntry)) {
			strcpy(tmpBuf, ("Delete all table error!"));
			goto setErr_wds;
		}
	}

setWds_ret:
	apmib_update(CURRENT_SETTING);

#ifndef NO_ACTION
	run_init_script("bridge");
#endif

	submitUrl = req_get_cstream_var(wp, ("submit-url"), "");   // hidden page
	OK_MSG( submitUrl );
  	return;

setErr_wds:
	ERR_MSG(tmpBuf);
}

#endif // CONFIG_RTK_MESH


/////////////////////////////////////////////////////////////////////////////
void formWlWds(request *wp, char *path, char *query)
{
	char *strRate, *strAddMac, *strDelMac, *strDelAllMac, *strVal, *submitUrl, *strEnabled, *strSaveApply;
	char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};
	int entryNum=0, i, enabled, val, j; //WNC-NMR0000-Rita-20130306-Error_513,Error_525-fix warnings of cppcheck (uninitialized value).
	WDS_T macEntry, macEntrytmp;

	int maxWDSNum;

	memset(&macEntry,0,sizeof(WDS_T)); //WNC-NMR0000-Rita-20130306-Error_519,Error_546-fix warnings of cppcheck (uninitialized value).
#ifdef CONFIG_RTL8196B_GW_8M
	maxWDSNum = 4;
#else
	maxWDSNum = MAX_WDS_NUM;
#endif

	strSaveApply = req_get_cstream_var(wp, ("save_apply"), "");

	strAddMac = req_get_cstream_var(wp, ("addWdsMac"), "");
	strDelMac = req_get_cstream_var(wp, ("deleteSelWdsMac"), "");
	strDelAllMac = req_get_cstream_var(wp, ("deleteAllWdsMac"), "");
	strEnabled = req_get_cstream_var(wp, ("wlanWdsEnabled"), "");

	if (strAddMac[0] || strSaveApply[0]) {
		if ( !strcmp(strEnabled, "ON"))
			enabled = 1;
		else
			enabled = 0;
		if ( apmib_set( MIB_WLAN_WDS_ENABLED, (void *)&enabled) == 0) {
  			strcpy(tmpBuf, ("Set enabled flag error!"));
			goto setErr_wds;
		}

		strVal = req_get_cstream_var(wp, ("mac"), "");
		if ( !strVal[0] )
			goto setWds_ret;

		if (strlen(strVal)!=12 || !string_to_hex(strVal, macEntry.macAddr, 12)) {
			strcpy(tmpBuf, ("Error! Invalid MAC address."));
			goto setErr_wds;
		}

		strVal = req_get_cstream_var(wp, ("comment"), "");
		if ( strVal[0] ) {
			if (strlen(strVal) > COMMENT_LEN-1) {
				strcpy(tmpBuf, ("Error! Comment length too long."));
				goto setErr_wds;
			}
			strcpy( (char *)macEntry.comment, strVal);
		}
		else
			macEntry.comment[0] = '\0';


		
		strRate = req_get_cstream_var(wp, "txRate", "");
		if ( strRate[0] ) {
			if ( strRate[0] == '0' ) { // auto
				macEntry.fixedTxRate =0;
			}else  {
				val = atoi(strRate);

				printf("\n\nwds txRate val=%d\n\n", val);

				if(val < 30)
				val = 1 << (val-1);
				else
					val = ((1 <<31) + (val-30) ); 
					
				macEntry.fixedTxRate = val;
			}
		}
	

		
		if ( !apmib_get(MIB_WLAN_WDS_NUM, (void *)&entryNum)) {
			strcpy(tmpBuf, ("Get entry number error!"));
			goto setErr_wds;
		}
		if ( (entryNum + 1) > maxWDSNum) {
			strcpy(tmpBuf, ("Cannot add new entry because table is full!"));
			goto setErr_wds;
		}
		
		//add same rule check
		for(j=1;j<=entryNum;j++)
		{
			memset(&macEntrytmp, 0x00, sizeof(macEntrytmp));
			*((char *)&macEntrytmp) = (char)j;
			if ( apmib_get(MIB_WLAN_WDS, (void *)&macEntrytmp))
			{
				if (!memcmp(macEntrytmp.macAddr, macEntry.macAddr, 6))
				{
					strcpy(tmpBuf, ("rule already exist!"));
					goto setErr_wds;
				}
					
			}
		}
		
		// set to MIB. try to delete it first to avoid duplicate case
		apmib_set(MIB_WLAN_WDS_DEL, (void *)&macEntry);
		if ( apmib_set(MIB_WLAN_WDS_ADD, (void *)&macEntry) == 0) {
			strcpy(tmpBuf, ("Add table entry error!"));
			goto setErr_wds;
		}
	}

	/* Delete entry */
	if (strDelMac[0]) {
		if ( !apmib_get(MIB_WLAN_WDS_NUM, (void *)&entryNum)) {
			strcpy(tmpBuf, ("Get entry number error!"));
			goto setErr_wds;
		}
		for (i=entryNum; i>0; i--) {
			snprintf(tmpBuf, 20, "select%d", i);

			strVal = req_get_cstream_var(wp, tmpBuf, "");
			if ( !strcmp(strVal, "ON") ) {

				*((char *)&macEntry) = (char)i;
				if ( !apmib_get(MIB_WLAN_WDS, (void *)&macEntry)) {
					strcpy(tmpBuf, ("Get table entry error!"));
					goto setErr_wds;
				}
				if ( !apmib_set(MIB_WLAN_WDS_DEL, (void *)&macEntry)) {
					strcpy(tmpBuf, ("Delete table entry error!"));
					goto setErr_wds;
				}
			}
		}
	}

	/* Delete all entry */
	if ( strDelAllMac[0]) {
		if ( !apmib_set(MIB_WLAN_WDS_DELALL, (void *)&macEntry)) {
			strcpy(tmpBuf, ("Delete all table error!"));
			goto setErr_wds;
		}
	}

setWds_ret:
	apmib_update_web(CURRENT_SETTING);

#ifndef NO_ACTION
	run_init_script("bridge");
#endif

	submitUrl = req_get_cstream_var(wp, ("submit-url"), "");   // hidden page
	OK_MSG( submitUrl );
  	return;

setErr_wds:
	ERR_MSG(tmpBuf);
}

#if defined(WLAN_PROFILE)
/*
int wlProfileTblList(request *wp, int argc, char **argv)
{
	int nBytesSent=0, entryNum, i;
	WLAN_PROFILE_T entry;
	char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};
	int profile_num_id, profile_tbl_id;

	if(wlan_idx == 0)
	{
		profile_num_id = MIB_PROFILE_NUM1;
		profile_tbl_id = MIB_PROFILE_TBL1;
	}
	else
	{
		profile_num_id = MIB_PROFILE_NUM2;
		profile_tbl_id = MIB_PROFILE_TBL2;
	}
	
	apmib_get(profile_num_id, (void *)&entryNum);

	nBytesSent += req_format_write(wp, ("<tr class=\"tbl_head\">"
      	"<td align=center width=\"\" ><font size=\"2\"><b>SSID</b></font></td>\n"
      	"<td align=center width=\"\" ><font size=\"2\"><b>Encrypt</b></font></td>\n"
      	"<td align=center width=\"20%%\"><font size=\"2\"><b>Select</b></font></td></tr>\n"));

	for (i=1; i<=entryNum; i++) {
		unsigned char wlSecurityBuf[43]={0};
		
		*((char *)&entry) = (char)i;
		if ( !apmib_get(profile_tbl_id, (void *)&entry))
			return -1;

		if(entry.encryption == WEP64 || entry.encryption == WEP128)
		{
			sprintf(wlSecurityBuf, "%s", "WEP");
		}
		else if(entry.encryption == 3 ) //WPA
		{
			sprintf(wlSecurityBuf, "%s", "WPA/");
			if(entry.wpa_cipher == 2)
				strcat(wlSecurityBuf, "TKIP");
			else
				strcat(wlSecurityBuf, "AES");
		}
		else if(entry.encryption == 4 ) //WPA2
		{
			sprintf(wlSecurityBuf, "%s", "WPA2/");
			if(entry.wpa_cipher == 2)
				strcat(wlSecurityBuf, "TKIP");
			else
				strcat(wlSecurityBuf, "AES");
		}
		//NMR0000-[Aero]-20161011-patch: fmwlan-3411b.c-start
		else if(entry.encryption == 6) //WPA-MIXED
		{
		    sprintf(wlSecurityBuf, "%s", "WPA-MIXED");
		    if(entry.wpa_cipher == 10)
		        strcat(wlSecurityBuf, "  TKIP+AES");
		}
		//NMR0000-[Aero]-20161011-patch: fmwlan-3411b.c-end
		else
			sprintf(wlSecurityBuf, "%s", "OPEN");

		
		nBytesSent += req_format_write(wp, ("<tr class=\"tbl_body\">"
      			"<td align=center width=\"35%%\" ><font size=\"2\">%s</td>\n"
      			"<td align=center width=\"30%%\" ><font size=\"2\">%s</td>\n"
       			"<td align=center width=\"10%%\" ><input type=\"checkbox\" name=\"select%d\" value=\"ON\"></td></tr>\n"),
				entry.ssid,wlSecurityBuf, i);
	}
	return nBytesSent;
}
*/
/* WNC-NMR0000-HENG-I-CHEN-20130709-Modify for NEC wlan profiles GUI */
int wlProfileTblList(request *wp, int argc, char **argv)
{
	//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140916, Fix bug 2511 (UNINIT) in StaticCodeCheck_Linear_Delta1.xls
	//int nBytesSent=0, i, entryNum;
	int nBytesSent = 0, i, entryNum = 0;
	WLAN_PROFILE_T entry;
	int profile_tbl_id;
	char encryptStr[32];
/* WNC-NMR0000-HENG-I-CHEN-20130816: convert string for javascript */
	char nameStr[256];
/* WNC-NMR0000-HENG-I-CHEN-20130816: End */

	profile_tbl_id = MIB_PROFILE_TBL1;
	
	apmib_get(MIB_PROFILE_NUM1, (void *)&entryNum);

	for (i=1; i<= entryNum; i++) {
		
		*((char *)&entry) = (char)i;
		if ( !apmib_get(profile_tbl_id, (void *)&entry))
			return -1;

/* WNC-NMR0000-HENG-I-CHEN-20130816: convert string for javascript */
		convert_for_javascript(entry.profileName, nameStr, 255); 

		nBytesSent += req_format_write(wp, 
			("profiles[%d] = new profile(false, %d, \"%s\", %s);\n"),
				i, i, nameStr, (entry.active)?"true":"false");
/* WNC-NMR0000-HENG-I-CHEN-20130816: End */
	} 

	for (; i<=8; i++)
	{
		nBytesSent += req_format_write(wp, 
			("profiles[%d] = new profile(true, %d, \"\", false);\n"), i, i);
	}
	
	return nBytesSent;
}


// WNC-NMR0000-JDR230-HENG-I-CHEN-20130802-Add function to handle single profile
void formWlanSelectProfile(request *wp, char *path, char *query) {

	char *strVal;
	int emptyProfile = 0;

	strVal = req_get_cstream_var(wp, ("emptyProfile"), NULL);
	
	if (strVal) {
		emptyProfile = atoi(strVal);
	}

	strVal = req_get_cstream_var(wp, ("profileIndex"), "");
	
	if (strVal[0]) {
		profile_index = atoi(strVal);

		
		memset(&temp_profile, 0x00, sizeof(WLAN_PROFILE_T));

		if (!emptyProfile) {
		
			*((char *)&temp_profile) = (char)profile_index;
			if ( !apmib_get(MIB_PROFILE_TBL1, (void *)&temp_profile))
				goto setErr_SelectProfile;
		} else {
			strcpy(temp_profile.profileName, "BBХݥ");
			temp_profile.wispType = 16;
			temp_profile.encryption = 0;
			temp_profile.wepKeyType = KEY_ASCII;
			temp_profile.wispAutoLogin = 1;
// WNC-NMR0472-JDR230-HENG-I-CHEN-20130826: Fix bug 472, active new profile when it is created.
			temp_profile.active = true;
// WNC-NMR0472-JDR230-HENG-I-CHEN-20130826: End
		}

		send_redirect_perm(wp, WLAN_EDIT_PROFILE_PAGE);

  		return;
	}

setErr_SelectProfile:
	ERR_MSG("SELECTPROFILE FAILED");

}

void formWlanDeleteProfile(request *wp, char *path, char *query) {

	char *strIndex;

	strIndex = req_get_cstream_var(wp, ("profileIndex"), "");
	
	if (strIndex[0]) {
		profile_index = atoi(strIndex);

		memset(&temp_profile, 0x00, sizeof(WLAN_PROFILE_T));
		*((char *)&temp_profile) = (char)profile_index;
		if ( !apmib_get(MIB_PROFILE_TBL1, (void *)&temp_profile))
			goto setErr_ProfileDelete;

		apmib_set(MIB_PROFILE_DEL1, (void *)&temp_profile);
		
		apmib_update_web(CURRENT_SETTING);

		send_redirect_perm(wp, WLAN_PROFILE_LIST_PAGE);

  		return;
	}

	
setErr_ProfileDelete:
	ERR_MSG("DELETE PROFILE FAILED");

}
// WNC-NMR0000-JDR230-HENG-I-CHEN-20130802-End

void formWlanSetProfile(request *wp, char *path, char *query) {

	char *strVal, *submitUrl;
	int i, j, idx, entryNum=0;
	WLAN_PROFILE_T entry, newEntries[MAX_WLAN_PROFILE_NUM];
	char varName[20];
	char tmpBuf[MAX_MSG_BUFFER_SIZE];
	int invalid;
	int isSetConnect = 0;
	
	submitUrl = req_get_cstream_var(wp, ("submit-url"), "");   // hidden page
	
// WNC-NMR0000-JDR230-HENG-I-CHEN-20130802-Seprate Wlan profile settings to two pages
	apmib_get(MIB_PROFILE_NUM1, (void *)&entryNum);
// WNC-NMR0000-JDR230-HENG-I-CHEN-20130802-End

	memset(newEntries, 0x00, sizeof(WLAN_PROFILE_T)*MAX_WLAN_PROFILE_NUM);


	for (i=1, j=0 ; i<=MAX_WLAN_PROFILE_NUM; i++)
	{
	
		sprintf(varName, "profileEmpty%d", i);
		strVal = req_get_cstream_var(wp, varName, NULL);

		if (!strVal) {
			sprintf(tmpBuf, ("Cannot find profile No.%d!"), i);
			goto setErr_ProfilesSet;
		}

		invalid = atoi(strVal);
		
		if (invalid)
			continue;
		
// WNC-NMR0000-JDR230-HENG-I-CHEN-20130802-Seprate Wlan profile settings to two pages
		sprintf(varName, "profile%d", i);
		strVal = req_get_cstream_var(wp, varName, NULL);

		if (!strVal) {
			sprintf(tmpBuf, ("Cannot find profile No.%d!"), i);
			goto setErr_ProfilesSet;
		}
		
		idx = atoi(strVal);
		if (idx < 1 || idx > MAX_WLAN_PROFILE_NUM) {
			sprintf(tmpBuf, ("Cannot find profile No.%d!"), i);
			goto setErr_ProfilesSet;
		}
		
		if (idx <= entryNum) {
			*((char *)(newEntries+j)) = (char)(idx);
			apmib_get(MIB_PROFILE_TBL1, (void *)(newEntries+j));
			sprintf(varName, "enable%d", i);
			strVal = req_get_cstream_var(wp, varName, NULL);

	
			if (!strVal)
				newEntries[j].active = false;
			else
				newEntries[j].active = true;

			j++;
		}
// WNC-NMR0000-JDR230-HENG-I-CHEN-20130802-End
		
	}		

	apmib_set(MIB_PROFILE_DELALL1, (void *)&newEntries);

	for (i=0; i<j; i++) {
		apmib_set(MIB_PROFILE_ADD1, (void *)(newEntries+i));
		if (newEntries[i].active == true)
			isSetConnect = 1;			

	}

	apmib_set(MIB_IS_SET_CONNECT, (void*)&isSetConnect);
	
	apmib_update_web(CURRENT_SETTING);

//WNC-NMR0000-JDR230-HENG-I-CHEN-20130710-Add special reboot warning message for wirelss profile setting
	OK_MSG_PROFILE(submitUrl);
//WNC-NMR0000-JDR230-HENG-I-CHEN-End

	return;
	
setErr_ProfilesSet:
	ERR_MSG("PROFILES SET FAILED");

}
/* WNC-NMR0000-HENG-I-CHEN-20130709-End */

// WNC-NMR0000-JDR230-HENG-I-CHEN-20130802-Add function to handle single profile
int getSelectProfile(request *wp, int argc, char **argv)
{


	char *var_name, buffer[64];


	int nBytesSent=0;
	//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140916, Fix bug 2589, 2591 (UNINIT) in StaticCodeCheck_Linear_Delta1.xls
	//char encryptStr[32];
	char encryptStr[32] = {0};
	char keyLenStr[32];
	char keyTypeStr[32];
	char keyStr[128];
/* WNC-NMR0000-HENG-I-CHEN-20130816: convert string for javascript */
	char nameStr[256];
/* WNC-NMR0000-HENG-I-CHEN-20130816: End */
/* WNC-NMR0000-HENG-I-CHEN-20130816: Fix SSID, loginID and password can't display special character */
    char ssidStr[256];
	char loginStr[1024];
	char passStr[512];
/* WNC-NMR0000-HENG-I-CHEN-20130816: End */

	if (temp_profile.encryption == 0) {
		strcpy(encryptStr, "None");
		strcpy(keyLenStr, "128");
		strcpy(keyTypeStr, "ASCII");
		strcpy(keyStr, "");
	} else if (temp_profile.encryption == WEP64 || temp_profile.encryption == WEP128) {
/* WNC-NMR0000-HENG-I-CHEN-20130722-Change Profile HEX Wep Key from binery to string */
		int keylen = 0;
		strcpy(encryptStr, "WEP");
		if (temp_profile.encryption == WEP128) {
			keylen = 13;
			strcpy(keyLenStr, "128");
		} else {
			keylen = 5;
			strcpy(keyLenStr, "64");
		}
		if (temp_profile.wepKeyType==KEY_ASCII) {
			strcpy(keyTypeStr, "ASCII");
			strcpy(keyStr, temp_profile.wepKey1);
		} else {
			strcpy(keyTypeStr, "HEX");
			convert_bin_to_str(temp_profile.wepKey1, keylen, keyStr);
		}
/* WNC-NMR0000-HENG-I-CHEN-20130722-End */			
	} else {
		if (temp_profile.encryption == 3) {
			strcpy(encryptStr, "WPA-PSK");
		} else if (temp_profile.encryption == 4) {
			strcpy(encryptStr, "WPA2-PSK");
		}
/* WNC-NMR0000-JDR230-HENG-I-CHEN-20130717-Fix wpa chipher for wlan profile */
		if (temp_profile.wpa_cipher == 2 /*WPA_CIPHER_TKIP*/ ) {
/* WNC-NMR0000-JDR230-HENG-I-CHEN-20130717-End */
			strcat(encryptStr, "(TKIP)");
		} else {
			strcat(encryptStr, "(AES)");
		}
			
		strcpy(keyLenStr, "128");
		strcpy(keyTypeStr, "ASCII");
		strcpy(keyStr, temp_profile.wpaPSK);
	} 

/* WNC-NMR0000-HENG-I-CHEN-20130816: Fix SSID, loginID and password can't display special character */
/* WNC-NMR0000-HENG-I-CHEN-20130816: convert string for javascript */
	convert_for_javascript(temp_profile.profileName, nameStr, 255);
	convert_to_hexstr(temp_profile.ssid, MAX_SSID_LEN, ssidStr);
	convert_to_hexstr(temp_profile.wispLogin, 128, loginStr);
	convert_to_hexstr(temp_profile.wispPass, 64, passStr);

	nBytesSent += req_format_write(wp, 
		("new profile(false, %d, \"%s\", %s, %d, \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", %s, \"%s\", \"%s\");\n"),
			 profile_index, nameStr, (temp_profile.active)?"true":"false",
			 temp_profile.wispType, ssidStr, encryptStr, keyLenStr, keyTypeStr, keyStr,
			(temp_profile.wispAutoLogin)?"true":"false", loginStr, passStr);
/* WNC-NMR0000-HENG-I-CHEN-20130816: End */
/* WNC-NMR0000-HENG-I-CHEN-20130816: End */
 
	return nBytesSent;
}
// WNC-NMR0000-JDR230-HENG-I-CHEN-20130802-End
int wlProfileList(request *wp, int argc, char **argv)
{
	int nBytesSent=0, entryNum=0, i;//WNC-NMR0000-Rita-20130305-Error_439,Error_463-fix warnings of cppcheck (uninitialized value).
	WLAN_PROFILE_T entry;
	int profile_num_id, profile_tbl_id, profile_enabled_id, wlProfileEnabled=0;//WNC-NMR0000-Rita-20130305-Error_436-fix warnings of cppcheck (uninitialized value).
	
	if(wlan_idx == 0)
	{
		profile_num_id = MIB_PROFILE_NUM1;
		profile_tbl_id = MIB_PROFILE_TBL1;
		profile_enabled_id = MIB_PROFILE_ENABLED1;
	}
	else
	{
		profile_num_id = MIB_PROFILE_NUM2;
		profile_tbl_id = MIB_PROFILE_TBL2;
		profile_enabled_id = MIB_PROFILE_ENABLED2;
	}

	apmib_get( profile_enabled_id, (void *)&wlProfileEnabled);
	if(wlProfileEnabled == 0)
	{
		req_format_write(wp,"%s","//wireless profile disabled");
		return 0;
	}
	
	apmib_get(profile_num_id, (void *)&entryNum);


	for (i=1; i<=entryNum; i++) {		
		unsigned char encryptBuf[43]={0};
		unsigned char wepBuf[43]={0};
		unsigned char ssidBuf[128]={0};	
		int wpaCipherVal = 0;
		
		sprintf(wepBuf, "%d", 0); 
		//Ssid|Encrypt|Authtype|wep|Wepkeytype|wpaCipher|wpa2Cipher|Pskformat

		memset(&entry, 0x00, sizeof(WLAN_PROFILE_T));
		*((char *)&entry) = (char)i;
		if ( !apmib_get(profile_tbl_id, (void *)&entry))
			return -1;

		if(entry.encryption == WEP64 || entry.encryption == WEP128)
		{
			sprintf(encryptBuf, "%d", 1);
			if(entry.encryption == WEP64)
				sprintf(wepBuf, "%d", 1);
			else
				sprintf(wepBuf, "%d", 2); //128
		}
		else if(entry.encryption == 3 ) //WPA
		{
			sprintf(encryptBuf, "%d", 2);
		}
		else if(entry.encryption == 4 ) //WPA2
		{
			sprintf(encryptBuf, "%d", 4);
		}
		else
		{
			sprintf(encryptBuf, "%d", 0);
		}

		if(entry.wpa_cipher == 2)
			wpaCipherVal = 1;
		else
			wpaCipherVal = 2;

		translateChar(entry.ssid, ssidBuf, sizeof(ssidBuf));
		translate_control_code(entry.wpaPSK);
		//Ssid|Encrypt|Authtype|wep|Wepkeytype|wpaCipher|wpa2Cipher|Pskformat|Wpapsk
		nBytesSent += req_format_write(wp, ("token[%d] =\'%s|%s|%d|%s|%d|%d|%d|%d|%s\';\n"),(i-1), ssidBuf,encryptBuf, entry.auth, wepBuf, entry.wepKeyType, wpaCipherVal, wpaCipherVal, entry.wpaPSKFormat, entry.wpaPSK );
	}
	return nBytesSent;

}
#endif //#if defined(WLAN_PROFILE)
/////////////////////////////////////////////////////////////////////////////
int wlWdsList(request *wp, int argc, char **argv)
{
	int nBytesSent=0, entryNum=0, i;//WNC-NMR0000-Rita-20130305-Error_417-fix warnings of cppcheck (uninitialized value).
	WDS_T entry;
	char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};
	char txrate[20];
	int rateid=0;

	if ( !apmib_get(MIB_WLAN_WDS_NUM, (void *)&entryNum)) {
  		fprintf(stderr, "Get table entry error!\n");
		return -1;
	}

	nBytesSent += req_format_write(wp, ("<tr class=\"tbl_head\">"
      	"<td align=center width=\"35%%\" ><font size=\"2\"><b>MAC Address</b></font></td>\n"
      	"<td align=center width=\"25%%\" ><font size=\"2\"><b>Tx Rate (Mbps)</b></font></td>\n"
      	"<td align=center width=\"30%%\" ><font size=\"2\"><b>Comment</b></font></td>\n"
      	"<td align=center width=\"10%%\" ><font size=\"2\"><b>Select</b></font></td></tr>\n"));

	for (i=1; i<=entryNum; i++) {
		*((char *)&entry) = (char)i;
		if ( !apmib_get(MIB_WLAN_WDS, (void *)&entry))
			return -1;

		snprintf(tmpBuf, MAX_MSG_BUFFER_SIZE, ("%02x:%02x:%02x:%02x:%02x:%02x"),
			entry.macAddr[0], entry.macAddr[1], entry.macAddr[2],
			entry.macAddr[3], entry.macAddr[4], entry.macAddr[5]);

		if(entry.fixedTxRate == 0){	
				sprintf(txrate, "%s","Auto"); 
		}else{
			for(rateid=0; rateid<48;rateid++){
				if(tx_fixed_rate[rateid].id == entry.fixedTxRate){
					sprintf(txrate, "%s", tx_fixed_rate[rateid].rate);
					break;
				}
			}
		}	
		nBytesSent += req_format_write(wp, ("<tr class=\"tbl_body\">"
      			"<td align=center width=\"35%%\" ><font size=\"2\">%s</td>\n"
      			"<td align=center width=\"25%%\" ><font size=\"2\">%s</td>\n"
      			"<td align=center width=\"30%%\" ><font size=\"2\">%s</td>\n"
       			"<td align=center width=\"10%%\" ><input type=\"checkbox\" name=\"select%d\" value=\"ON\"></td></tr>\n"),
				tmpBuf, txrate, entry.comment,i);
	}
	return nBytesSent;
}


/////////////////////////////////////////////////////////////////////////////
void formWdsEncrypt(request *wp, char *path, char *query)
{
   	char *strVal, *submitUrl;
	char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};
	WDS_ENCRYPT_T encrypt;
	int intVal=0, keyLen=0, oldFormat=0, oldPskLen, len, i; //WNC-NMR0000-Rita-20130306-Error_475,Error_514,Error_517-fix warnings of cppcheck (uninitialized value).
	char charArray[16]={'0' ,'1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
	char key[100];
	char varName[20];

	sprintf(varName, "encrypt%d", wlan_idx);
	strVal = req_get_cstream_var(wp, varName, "");
	if (strVal[0]) {
		encrypt = strVal[0] - '0';
		if (encrypt != WDS_ENCRYPT_DISABLED && encrypt != WDS_ENCRYPT_WEP64 &&
			encrypt != WDS_ENCRYPT_WEP128 && encrypt != WDS_ENCRYPT_TKIP &&
				encrypt != WDS_ENCRYPT_AES) {
 			strcpy(tmpBuf, ("encrypt value not validt!"));
			goto setErr_wdsEncrypt;
		}
		apmib_set( MIB_WLAN_WDS_ENCRYPT, (void *)&encrypt);
	}
	else
		apmib_get( MIB_WLAN_WDS_ENCRYPT, (void *)&encrypt);

	if (encrypt == WDS_ENCRYPT_WEP64 || encrypt == WDS_ENCRYPT_WEP128) {
		sprintf(varName, "format%d", wlan_idx);
		strVal = req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			if (strVal[0]!='0' && strVal[0]!='1') {
				strcpy(tmpBuf, ("Invalid wep key format value!"));
				goto setErr_wdsEncrypt;
		}
			intVal = strVal[0] - '0';
			apmib_set( MIB_WLAN_WDS_WEP_FORMAT, (void *)&intVal);
		}
		else
			apmib_get( MIB_WLAN_WDS_WEP_FORMAT, (void *)&intVal);

		if (encrypt == WDS_ENCRYPT_WEP64)
			keyLen = WEP64_KEY_LEN;
		else if (encrypt == WDS_ENCRYPT_WEP128)
			keyLen = WEP128_KEY_LEN;

		if (intVal == 1) // hex
			keyLen <<= 1;

		sprintf(varName, "wepKey%d", wlan_idx);
		strVal = req_get_cstream_var(wp, varName, "");
		if  (strVal[0]) {
			if (strlen(strVal) != keyLen) {
				strcpy(tmpBuf, ("Invalid wep key length!"));
				goto setErr_wdsEncrypt;
		}
			if ( !isAllStar(strVal) ) {
				if (intVal == 0) { // ascii
					for (i=0; i<keyLen; i++) {
						key[i*2] = charArray[(strVal[i]>>4)&0xf];
						key[i*2+1] = charArray[strVal[i]&0xf];
				}
					key[i*2] = '\0';
			}
				else  // hex
					strcpy(key, strVal);
				apmib_set( MIB_WLAN_WDS_WEP_KEY, (void *)key);
			}
		}
	}
	if (encrypt == WDS_ENCRYPT_TKIP || encrypt == WDS_ENCRYPT_AES) {
		sprintf(varName, "pskFormat%d", wlan_idx);
		strVal = req_get_cstream_var(wp, varName, "");
		if (strVal[0]) {
			if (strVal[0]!='0' && strVal[0]!='1') {
				strcpy(tmpBuf, ("Invalid wep key format value!"));
				goto setErr_wdsEncrypt;
				}
			intVal = strVal[0] - '0';
			}
			else
			apmib_get( MIB_WLAN_WDS_PSK_FORMAT, (void *)&intVal);


		// remember current psk format and length to compare to default case "****"
		apmib_get(MIB_WLAN_WDS_PSK_FORMAT, (void *)&oldFormat);
		apmib_get(MIB_WLAN_WDS_PSK, (void *)tmpBuf);
		oldPskLen = strlen(tmpBuf);

		sprintf(varName, "pskValue%d", wlan_idx);
		strVal = req_get_cstream_var(wp, varName, "");
		len = strlen(strVal);
		if (len > 0 && oldFormat == intVal && len == oldPskLen ) {
			if(!strcmp(strVal,tmpBuf))
				goto save_wdsEcrypt;
		}
		if (intVal==1) { // hex
			if (len!=MAX_PSK_LEN || !string_to_hex(strVal, tmpBuf, MAX_PSK_LEN)) {
				strcpy(tmpBuf, ("Error! invalid psk value."));
				goto setErr_wdsEncrypt;
	}
				}
		else { // passphras
			if (len==0 || len > (MAX_PSK_LEN-1) ) {
				strcpy(tmpBuf, ("Error! invalid psk value."));
				goto setErr_wdsEncrypt;
			}
		}
		apmib_set( MIB_WLAN_WDS_PSK_FORMAT, (void *)&intVal);
		apmib_set( MIB_WLAN_WDS_PSK, (void *)strVal);
	}

save_wdsEcrypt:
	intVal = 1;
	apmib_set( MIB_WLAN_WDS_ENABLED, (void *)&intVal);

	apmib_update_web(CURRENT_SETTING);

#ifndef NO_ACTION
	run_init_script("bridge");
#endif

	submitUrl = req_get_cstream_var(wp, ("submit-url"), "");   // hidden page
	OK_MSG(submitUrl);

	return;

setErr_wdsEncrypt:
	ERR_MSG(tmpBuf);
}


/////////////////////////////////////////////////////////////////////////////
int wdsList(request *wp, int argc, char **argv)
{
	int nBytesSent=0, i;
	WDS_INFO_Tp pInfo;
	char *buff;
	char txrate[20];
	int rateid=0;
	int short_gi=0;
	int channel_bandwidth=0;

	buff = calloc(1, sizeof(WDS_INFO_T)*MAX_STA_NUM);
	if ( buff == 0 ) {
		printf("Allocate buffer failed!\n");
		return 0;
	}

	if ( getWdsInfo(WLAN_IF, buff) < 0 ) {
		printf("Read wlan sta info failed!\n");
		return 0;
	}
	apmib_get(MIB_WLAN_CHANNEL_BONDING, (void *)&channel_bandwidth);
	apmib_get(MIB_WLAN_SHORT_GI, (void *)&short_gi);

	for (i=0; i<MAX_WDS_NUM; i++) {
		pInfo = (WDS_INFO_Tp)&buff[i*sizeof(WDS_INFO_T)];

		if (pInfo->state == STATE_WDS_EMPTY)
			break;
		if(pInfo->txOperaRate >= 0xA0) {
			rateid = pInfo->txOperaRate - 0xA0;
			sprintf(txrate, "%d", VHT_MCS_DATA_RATE[channel_bandwidth][short_gi][rateid]>>1);
			
		}
		else if((pInfo->txOperaRate & 0x80) != 0x80){	
			if(pInfo->txOperaRate%2){
				sprintf(txrate, "%d%s",pInfo->txOperaRate/2, ".5"); 
			}else{
				sprintf(txrate, "%d",pInfo->txOperaRate/2); 
			}
		}else{
		
			if(channel_bandwidth ==0){ //20M
				if(short_gi==0){//long
					for(rateid=0; rateid<16;rateid++){
						if(rate_11n_table_20M_LONG[rateid].id == pInfo->txOperaRate){
							sprintf(txrate, "%s", rate_11n_table_20M_LONG[rateid].rate);
							break;
						}
					}
				}else if(short_gi==1){//short
					for(rateid=0; rateid<16;rateid++){
						if(rate_11n_table_20M_SHORT[rateid].id == pInfo->txOperaRate){
							sprintf(txrate, "%s", rate_11n_table_20M_SHORT[rateid].rate);
							break;
						}
					}
				}
			}else if(channel_bandwidth ==1){ //40
					if(short_gi==0){//long
						for(rateid=0; rateid<16;rateid++){
							if(rate_11n_table_40M_LONG[rateid].id == pInfo->txOperaRate){
								sprintf(txrate, "%s", rate_11n_table_40M_LONG[rateid].rate);
								break;
							}
						}
					}else if(short_gi==1){//short
						for(rateid=0; rateid<16;rateid++){
							if(rate_11n_table_40M_SHORT[rateid].id == pInfo->txOperaRate){
								sprintf(txrate, "%s", rate_11n_table_40M_SHORT[rateid].rate);
								break;
							}
						}
					}	
			}
		}	
		nBytesSent += req_format_write(wp,
	   		"<tr class=\"tbl_body\"><td><font size=2>%02x:%02x:%02x:%02x:%02x:%02x</td>"
			"<td><font size=2>%d</td>"
	     		"<td><font size=2>%d</td>"
			"<td><font size=2>%d</td>"
			"<td><font size=2>%s</td>",
			pInfo->addr[0],pInfo->addr[1],pInfo->addr[2],pInfo->addr[3],pInfo->addr[4],pInfo->addr[5],
			pInfo->tx_packets, pInfo->tx_errors, pInfo->rx_packets,
			txrate);
	}

	free(buff);

	return nBytesSent;
}

#ifdef WLAN_EASY_CONFIG
/////////////////////////////////////////////////////////////////////////////
void sigHandler_autoconf(int signo)
{
	int val, reinit=1;
	char tmpbuf[MAX_MSG_BUFFER_SIZE]={0};	
	
	apmib_get( MIB_WLAN_MODE, (void *)&val);	
	if (val == AP_MODE || val == AP_WDS_MODE) {	
		apmib_get(MIB_WLAN_EASYCFG_KEY, (void *)tmpbuf);	
		if (strlen(tmpbuf) > 0) // key already installed
			reinit = 0;		
	}

#ifdef WIFI_SIMPLE_CONFIG	
{
	#define REINIT_WEB_FILE		("/tmp/reinit_web")
	struct stat status;

	if (stat(REINIT_WEB_FILE, &status) == 0) { // file existed
        unlink(REINIT_WEB_FILE);
		reinit = 0;		
	}
}
#endif
	
	if (reinit) { // re-init system
		wait_config = 1;
#ifdef REBOOT_CHECK
	run_init_script_flag = 1;
#endif		
#ifndef NO_ACTION
		run_init_script("all");
#endif		
		wait_config = CONFIG_SUCCESS;
	}
	if (apmib_reinit() == 0) 
		printf(("Re-initialize AP MIB failed!\n"));	
}

/////////////////////////////////////////////////////////////////////////////
void formAutoCfg(request *wp, char *path, char *query)
{
   	char *strVal, *submitUrl;
 	int isButtonPress=0, isSave=0, isDelete=0, isDoConfigButton=0, isDoConfigQuestion=0;
	int mode, val, isAP, mode_old, enable, enable_old, wlan_disabled, i, isAdhoc, first=0;
	char tmpBuf[200], wlan_interface_set[100]={0}, hashBuf[33];
	
	strVal = req_get_cstream_var(wp, ("cfgEnabled"), "");
	if ( !strcmp(strVal, "ON"))
		enable = 1;
	else
		enable = 0;

	apmib_get( MIB_WLAN_EASYCFG_ENABLED, (void *)&enable_old);
	apmib_get( MIB_WLAN_WLAN_DISABLED, (void *)&wlan_disabled);

	strVal = req_get_cstream_var(wp, ("buttonClicked"), "");
	if (strVal[0])
		isButtonPress = 1;
	else {
		strVal = req_get_cstream_var(wp, ("save"), "");
		if (strVal[0])
			isSave = 1;
		else {
			strVal = req_get_cstream_var(wp, ("deletekey"), "");
			if (strVal[0])
				isDelete = 1;
			else {
				strVal = req_get_cstream_var(wp, ("doConfigButton"), "");
				if (strVal[0])
					isDoConfigButton = 1;
				else {
					strVal = req_get_cstream_var(wp, ("doConfigQuestion"), "");
					if (strVal[0])
						isDoConfigQuestion = 1;		
					else {
						strcpy(tmpBuf, ("Error, no action is defined!"));
						goto setErr_autocfg;
					}
				}
			}
		}
	}

	apmib_get( MIB_WLAN_MODE, (void *)&val);
	if (val == AP_MODE || val == AP_WDS_MODE) 
		isAP = 1;
	else 
		isAP = 0;

	apmib_set( MIB_WLAN_EASYCFG_WLAN_MODE, (void *)&val);

	apmib_get( MIB_WLAN_EASYCFG_MODE, (void *)&mode_old);
	
	if (isAP && isDoConfigQuestion) {
		strcpy(tmpBuf, ("Error, invalid action request!"));
		goto setErr_autocfg;
	}

	if (!isAP && isButtonPress ) {
		strcpy(tmpBuf, ("Error, invalid action request!"));
		goto setErr_autocfg;
	}

	for (i=0; i<wlan_num; i++) {
		sprintf(tmpBuf, "wlan%d ", i);
		strcat(wlan_interface_set, tmpBuf);
	}

	strVal = req_get_cstream_var(wp, ("mode"), "");
	if ( strVal[0] ) {
		if (strVal[0]!= '1' && strVal[0]!= '2' && strVal[0]!= '3'
#ifdef CONFIG_RTL_P2P_SUPPORT
		&&  strVal[0]!= '8'
#endif
		) {
  			strcpy(tmpBuf, ("Invalid mode value!"));
			goto setErr_autocfg;
		}
		mode = strVal[0] - '0';
	}
	else
		mode = mode_old;

	if (enable != enable_old) {
		int modify=0, aval, cipher;
		unsigned char tmp1[100], tmp2[100];
		
		apmib_set( MIB_WLAN_EASYCFG_ENABLED, (void *)&enable);
		
		apmib_get( MIB_WLAN_EASYCFG_KEY, (void *)&tmpBuf);	
		if (enable && strlen(tmpBuf) > 0) { /* key installed */
			/* see if current setting diff with AUTOCFG value. */
			/* if modify, flush AUTOCFG value */
			apmib_get( MIB_WLAN_WPA_AUTH, (void *)&val);			
			if (val != WPA_AUTH_PSK) 
				modify = 1;
		
			apmib_get( MIB_WLAN_EASYCFG_SSID, (void *)&tmp1);
			apmib_get( MIB_WLAN_SSID, (void *)&tmp2);		
			if ( strcmp(tmp1, tmp2))
				modify = 1;			
		
			if (!modify ) {		
				apmib_get( MIB_WLAN_ENCRYPT, (void *)&val);
				apmib_get( MIB_WLAN_EASYCFG_ALG_REQ, (void *)&aval);	
				apmib_get( MIB_WLAN_WPA_CIPHER_SUITE, (void *)&cipher);
				
				if ( !(val & ENCRYPT_WPA) && !(val & ENCRYPT_WPA2)) 
					modify = 1;		
				if (val & ENCRYPT_WPA) {
					if ((aval & ACF_ALGORITHM_WPA_TKIP) && !(cipher & WPA_CIPHER_TKIP))
						modify = 1;
					if ((aval & ACF_ALGORITHM_WPA_AES) && !(cipher & WPA_CIPHER_AES))
						modify = 1;					
				}
			 	if (val & ENCRYPT_WPA2) {
					if ((aval & ACF_ALGORITHM_WPA2_TKIP) && !(cipher & WPA_CIPHER_TKIP))
						modify = 1;
					if ((aval & ACF_ALGORITHM_WPA2_AES) && !(cipher & WPA_CIPHER_AES))
						modify = 1;					
				}
			}		
			if (!modify) {
				apmib_get( MIB_WLAN_EASYCFG_ROLE, (void *)&val);	
				if (isAP) {
					if (val != ROLE_SERVER)
						modify = 1;
				}
				else {					
					apmib_get( MIB_WLAN_NETWORK_TYPE, (void *)&isAdhoc);
					if (val == ROLE_SERVER)
						modify = 1;
					else {
						if ((val == ROLE_CLIENT) && isAdhoc)
							modify = 1;
						else if ((val == ROLE_ADHOC) && !isAdhoc)
							modify = 1;
					}
				}				
			}			
			
			if (modify) {
				tmpBuf[0] = '\0';
				apmib_set(MIB_WLAN_EASYCFG_KEY, (void *)tmpBuf);
				apmib_set(MIB_WLAN_EASYCFG_DIGEST, (void *)tmpBuf);	
			}
		}
	}

	if ((isDoConfigButton || isDoConfigQuestion) && !wlan_disabled) {
		if ((mode & MODE_QUESTION) && isDoConfigQuestion ) {
			MD5_CONTEXT md5ctx;
			unsigned char hash[16];
			int i;
			const char *hex = "0123456789abcdef";
			char *r;

			strVal = req_get_cstream_var(wp, ("firstCfg"), "");
			if ( !strcmp(strVal, "ON"))
				first = 1;
			else
				first = 0;

			tmpBuf[0]='\0';
			strVal = req_get_cstream_var(wp, ("q1"), "");
			strcat(tmpBuf, strVal);
			strVal = req_get_cstream_var(wp, ("q1ans"), "");
			strcat(tmpBuf, strVal);

			strVal = req_get_cstream_var(wp, ("q2"), "");
			strcat(tmpBuf, strVal);
			strVal = req_get_cstream_var(wp, ("q2ans"), "");
			strcat(tmpBuf, strVal);

			MD5Init(&md5ctx);
			MD5Update(&md5ctx, tmpBuf, (unsigned int)strlen(tmpBuf));
			MD5Final(hash, &md5ctx);

			/*
 			 *  Prepare the resulting hash string
 			 */
   			for (i = 0, r = hashBuf; i < 16; i++) {
             		*r++ = toupper(hex[hash[i] >> 4]);
               		*r++ = toupper(hex[hash[i] & 0xF]);
   			}
			*r = '\0';
			apmib_get( MIB_WLAN_NETWORK_TYPE, (void *)&isAdhoc);
#if 0			
			if (!isAP && isAdhoc) {
				char tmpBuf1[100];
				apmib_get( MIB_WLAN_EASYCFG_KEY, (void *)tmpBuf1);
				apmib_get( MIB_WLAN_EASYCFG_DIGEST, (void *)tmpBuf);
				if (tmpBuf1[0] && tmpBuf[0] && strcmp(hashBuf, tmpBuf)) {
		  			strcpy(tmpBuf, ("The question selection or answer of Q&A mode is not matched with installed value!"));
					goto setErr_autocfg;					
				}				
			}
#endif			
		}
	}
	
	if (mode != mode_old)
		apmib_set( MIB_WLAN_EASYCFG_MODE, (void *)&mode);

	if (isDelete) {
		tmpBuf[0] = '\0';
		apmib_set(MIB_WLAN_EASYCFG_KEY, (void *)tmpBuf);
		apmib_set(MIB_WLAN_EASYCFG_DIGEST, (void *)tmpBuf);
	}

	if (enable != enable_old || mode != mode_old || isDelete) {
		apmib_update_web(CURRENT_SETTING);
#ifndef NO_ACTION
		if (!wlan_disabled) {	
			sprintf(tmpBuf, "%s/%s start %s %s", _CONFIG_SCRIPT_PATH, 
				_WLAN_APP_SCRIPT_PROG, wlan_interface_set, BRIDGE_IF);
			system( tmpBuf );			
			sleep(2);
		}
#endif		
	}
	
#ifndef NO_ACTION	
	if (isButtonPress && !wlan_disabled) {
		sprintf(tmpBuf, "%s/%s -w wlan%d -press_button", _CONFIG_SCRIPT_PATH, 
			_AUTO_CONFIG_DAEMON_PROG, wlan_idx);
		system( tmpBuf );
	}

	if ((isDoConfigButton || isDoConfigQuestion) && !wlan_disabled) {
		if ((mode & MODE_QUESTION) && isDoConfigQuestion ) {
			sprintf(tmpBuf, "%s/%s start %s %s %s", _CONFIG_SCRIPT_PATH,
				_WLAN_APP_SCRIPT_PROG, wlan_interface_set, BRIDGE_IF, hashBuf);
			if (first)
				strcat(tmpBuf, " qfirst");
			system( tmpBuf );				
			sleep(2);
		}
		else {
			
			sprintf(tmpBuf, "%s/%s -w wlan%d -press_button", _CONFIG_SCRIPT_PATH, 
				_AUTO_CONFIG_DAEMON_PROG, wlan_idx);
			system( tmpBuf );
		}

		wait_config = 1;		
		while (wait_config <= DO_CONFIG_WAIT_TIME &&
					wait_config != CONFIG_SUCCESS) {
			wait_config++;						
			sleep(1);			
		}
		
		submitUrl = req_get_cstream_var(wp, ("submit-url"), "");   // hidden page
		
		if (wait_config == CONFIG_SUCCESS) {
			OK_MSG1(("Do Auto-Config successfully!"), submitUrl);
		}
		else {
			sprintf(tmpBuf, "%s/%s -w wlan%d -release_button", _CONFIG_SCRIPT_PATH, 
				_AUTO_CONFIG_DAEMON_PROG, wlan_idx);
			system( tmpBuf );
			
			OK_MSG1(("Do Auto-Config failed!"), submitUrl);			
			
			if (!isAP) {
				sprintf(tmpBuf, "%s/%s start %s %s", _CONFIG_SCRIPT_PATH,
					_WLAN_APP_SCRIPT_PROG, wlan_interface_set, BRIDGE_IF);		
				system( tmpBuf );	
			}						
		}
		
		wait_config = CONFIG_SUCCESS;		

		return;
	}
#endif

	submitUrl = req_get_cstream_var(wp, ("submit-url"), "");   // hidden page
	
	if (wlan_disabled && (isButtonPress || isDoConfigButton || isDoConfigQuestion)) {
		OK_MSG1(("The wireless interface is disabled, can't proceed the request!"), submitUrl);	
	}
	else {	
		if (isButtonPress) {
			OK_MSG1(("Waiting for client Auto-Config request..."), submitUrl);
		}
		else {		
			OK_MSG(submitUrl);
		}
	}
	return;

setErr_autocfg:
	ERR_MSG(tmpBuf);
}
#endif // WLAN_EASY_CONFIG


#ifdef WIFI_SIMPLE_CONFIG
#ifndef WLAN_EASY_CONFIG
void sigHandler_autoconf(int signo)
{
	#define REINIT_WEB_FILE		("/tmp/reinit_web")
	struct stat status;
	int reinit=1;

	if (stat(REINIT_WEB_FILE, &status) == 0) { // file existed
        unlink(REINIT_WEB_FILE);
		reinit = 0;		
	}	
	if (reinit) { // re-init system
#ifdef REBOOT_CHECK
	run_init_script_flag = 1;
#endif		
#if defined(CONFIG_DOMAIN_NAME_QUERY_SUPPORT)
	Start_Domain_Query_Process=0;
#endif
/* WNC-MR0209-Steven Yuan-20120816- change simple reboot to normal reboot after WPS done. - START*/
#if defined(WLAN_PROFILE)
	//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140916, Fix bug 2552, 2554 (UNINIT) in StaticCodeCheck_Linear_Delta1.xls
	//int profile_enabled_id, profileEnabledVal, wlan_mode;
	int profile_enabled_id, profileEnabledVal = 0, wlan_mode = 0;
	if(wlan_idx == 0)
		profile_enabled_id = MIB_PROFILE_ENABLED1;
	else
		profile_enabled_id = MIB_PROFILE_ENABLED2;

	apmib_get( profile_enabled_id, (void *)&profileEnabledVal);
	apmib_get(MIB_WLAN_MODE, (void *)&wlan_mode);
	if((profileEnabledVal == 1) && (wlan_mode == CLIENT_MODE))
	{
		char tmpBuf[128]="wps_client_profile";
		request *wp=NULL;
		addWlProfileHandler(wp, tmpBuf, wlan_idx);
		apmib_update(CURRENT_SETTING);
	}
#endif
#if 0
#ifndef NO_ACTION
		run_init_script("all");
#endif
#else
	reboot_device();		
#endif
/* WNC-MR0209-Steven Yuan-20120816- change simple reboot to normal reboot after WPS done. -END */
	}
	apmib_reinit();
}
#endif //!WLAN_EASY_CONFIG

static void update_wps_configured(int reset_flag)
{
	int is_configured=0, encrypt1=0, encrypt2, auth, disabled=0, iVal=0, format=0, shared_type=0;
	//WNC-NMR0000-Rita-20130305-Error_582_584_553_539_490_446_445_412-fix warnings of cppcheck (uninitialized value).
	char ssid1[100]={0};//WNC-NMR0000-Rita-20130305-Error_403-fix warnings of cppcheck (uninitialized value).
	unsigned char tmpbuf[MAX_MSG_BUFFER_SIZE]={0};	
	
	if (wps_config_info.caller_id == CALLED_FROM_WLANHANDLER) {
		apmib_get(MIB_WLAN_SSID, (void *)ssid1);
		apmib_get(MIB_WLAN_MODE, (void *)&iVal);
		if (strcmp(ssid1, (char *)wps_config_info.ssid) || (iVal != wps_config_info.wlan_mode)) {
			apmib_set(MIB_WLAN_WSC_SSID, (void *)ssid1);
			goto configuration_changed;
		}

		return;
	}
	else if (wps_config_info.caller_id == CALLED_FROM_ADVANCEHANDLER) {
		apmib_get(MIB_WLAN_AUTH_TYPE, (void *)&shared_type);
		apmib_get(MIB_WLAN_ENCRYPT, (void *)&encrypt1);
		if (encrypt1 == ENCRYPT_WEP && 
			shared_type != wps_config_info.shared_type) {
			if (shared_type == AUTH_OPEN || shared_type == AUTH_BOTH) {
				if (wps_config_info.shared_type == AUTH_SHARED) {
					auth = WSC_AUTH_OPEN;
					apmib_set(MIB_WLAN_WSC_AUTH, (void *)&auth);
					goto configuration_changed;
				}
			}
			else {
				if (wps_config_info.shared_type == AUTH_OPEN ||
					wps_config_info.shared_type == AUTH_BOTH) {
					auth = WSC_AUTH_SHARED;
					apmib_set(MIB_WLAN_WSC_AUTH, (void *)&auth);
					goto configuration_changed;
				}
			}
		}

		return;
	}

	apmib_get(MIB_WLAN_ENCRYPT, (void *)&encrypt1);
	if (encrypt1 == ENCRYPT_DISABLED) {
		auth = WSC_AUTH_OPEN;
		encrypt2 = WSC_ENCRYPT_NONE;
	}
	else if (encrypt1 == ENCRYPT_WEP) {
		apmib_get(MIB_WLAN_AUTH_TYPE, (void *)&shared_type);
		if (shared_type == AUTH_OPEN || shared_type == AUTH_BOTH)
			auth = WSC_AUTH_OPEN;
		else
			auth = WSC_AUTH_SHARED;
		encrypt2 = WSC_ENCRYPT_WEP;		
	}
	else if (encrypt1 == ENCRYPT_WPA) {
		auth = WSC_AUTH_WPAPSK;
		apmib_get(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&encrypt1);
		if (encrypt1 == WPA_CIPHER_TKIP)
			encrypt2 = WSC_ENCRYPT_TKIP;		
		else if (encrypt1 == WPA_CIPHER_AES)
			encrypt2 = WSC_ENCRYPT_AES;		
		else 
			encrypt2 = WSC_ENCRYPT_TKIPAES;				
	}
	else if (encrypt1 == ENCRYPT_WPA2) {
		auth = WSC_AUTH_WPA2PSK;
		apmib_get(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&encrypt1);
		if (encrypt1 == WPA_CIPHER_TKIP)
			encrypt2 = WSC_ENCRYPT_TKIP;		
		else if (encrypt1 == WPA_CIPHER_AES)
			encrypt2 = WSC_ENCRYPT_AES;		
		else 
			encrypt2 = WSC_ENCRYPT_TKIPAES;				
	}
	else {
		auth = WSC_AUTH_WPA2PSKMIXED;
		encrypt2 = WSC_ENCRYPT_TKIPAES;			

// When mixed mode, if no WPA2-AES, try to use WPA-AES or WPA2-TKIP
		apmib_get(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&encrypt1);
		apmib_get(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&iVal);
		if (!(iVal &	WPA_CIPHER_AES)) {
			if (encrypt1 &	WPA_CIPHER_AES) {			
				//auth = WSC_AUTH_WPAPSK;
				encrypt2 = WSC_ENCRYPT_AES;	
				//printf("%s %d : %d\n",__FUNCTION__,__LINE__ ,encrypt2);
			}
			else{
				encrypt2 = WSC_ENCRYPT_TKIP;	
				//printf("%s %d : %d\n",__FUNCTION__,__LINE__ ,encrypt2);
			}
		}
//-------------------------------------------- david+2008-01-03
		if(encrypt1==WPA_CIPHER_AES && iVal ==WPA_CIPHER_AES){
			encrypt2 = WSC_ENCRYPT_AES;	
			printf("%s %d\n",__FUNCTION__,__LINE__);			
		}
		//printf("%s %d :auth=0x%02X\n",__FUNCTION__,__LINE__ ,auth);		
		// for correct wsc_auth wsc_encry value when security is mixed mode
	}
	apmib_set(MIB_WLAN_WSC_AUTH, (void *)&auth);
	apmib_set(MIB_WLAN_WSC_ENC, (void *)&encrypt2);

	apmib_get(MIB_WLAN_ENCRYPT, (void *)&encrypt1);
	if (encrypt1 == ENCRYPT_WPA || encrypt1 == ENCRYPT_WPA2 || encrypt1 == ENCRYPT_WPA2_MIXED) {
		apmib_get(MIB_WLAN_WPA_AUTH, (void *)&format);
		if (format & 2) { // PSK
			apmib_get(MIB_WLAN_WPA_PSK, (void *)tmpbuf);
			apmib_set(MIB_WLAN_WSC_PSK, (void *)tmpbuf);					
		}		
	}
	if (reset_flag) {
		reset_flag = 0;
		apmib_set(MIB_WLAN_WSC_CONFIGBYEXTREG, (void *)&reset_flag);		
	}	

	if (wps_config_info.caller_id == CALLED_FROM_WEPHANDLER) {
		apmib_get(MIB_WLAN_ENCRYPT, (void *)&auth);
		if (wps_config_info.auth != auth)
			goto configuration_changed;

		apmib_get(MIB_WLAN_WEP, (void *)&encrypt2);
		if (wps_config_info.wep_enc != encrypt2)
			goto configuration_changed;
		
		apmib_get(MIB_WLAN_WEP_DEFAULT_KEY, (void *)&iVal);
		if (wps_config_info.KeyId != iVal)
			goto configuration_changed;
		
		apmib_get(MIB_WLAN_WEP64_KEY1, (void *)tmpbuf);
		if (strcmp((char *)wps_config_info.wep64Key1, (char *)tmpbuf))
			goto configuration_changed;

		apmib_get(MIB_WLAN_WEP64_KEY2, (void *)tmpbuf);
		if (strcmp((char *)wps_config_info.wep64Key2, (char *)tmpbuf))
			goto configuration_changed;

		apmib_get(MIB_WLAN_WEP64_KEY3, (void *)tmpbuf);
		if (strcmp((char *)wps_config_info.wep64Key3, (char *)tmpbuf))
			goto configuration_changed;

		apmib_get(MIB_WLAN_WEP64_KEY4, (void *)tmpbuf);
		if (strcmp((char *)wps_config_info.wep64Key4, (char *)tmpbuf))
			goto configuration_changed;

		apmib_get(MIB_WLAN_WEP128_KEY1, (void *)tmpbuf);
		if (strcmp((char *)wps_config_info.wep128Key1, (char *)tmpbuf))
			goto configuration_changed;

		apmib_get(MIB_WLAN_WEP128_KEY2, (void *)tmpbuf);
		if (strcmp((char *)wps_config_info.wep128Key2, (char *)tmpbuf))
			goto configuration_changed;

		apmib_get(MIB_WLAN_WEP128_KEY3, (void *)tmpbuf);
		if (strcmp((char *)wps_config_info.wep128Key3,(char *)tmpbuf))
			goto configuration_changed;

		apmib_get(MIB_WLAN_WEP128_KEY4, (void *)tmpbuf);
		if (strcmp((char *)wps_config_info.wep128Key4, (char *)tmpbuf))
			goto configuration_changed;

		return;
	}
	else if (wps_config_info.caller_id == CALLED_FROM_WPAHANDLER) {
		apmib_get(MIB_WLAN_ENCRYPT, (void *)&auth);
		if (wps_config_info.auth != auth)
			goto configuration_changed;
		
		apmib_get(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&encrypt1);
		if (wps_config_info.wpa_enc != encrypt1)
			goto configuration_changed;
		
		apmib_get(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&encrypt2);
		if (wps_config_info.wpa2_enc != encrypt2)
			goto configuration_changed;
		
		apmib_get(MIB_WLAN_WPA_PSK, (void *)tmpbuf);
		if (strcmp((char *)wps_config_info.wpaPSK, (char *)tmpbuf))
			goto configuration_changed;

		return;
	}
	else
		return;
	
configuration_changed:	
	reset_flag = 0;
	apmib_set(MIB_WLAN_WSC_CONFIGBYEXTREG, (void *)&reset_flag);
	apmib_get(MIB_WLAN_WSC_DISABLE, (void *)&disabled);	
	apmib_get(MIB_WLAN_WSC_CONFIGURED, (void *)&is_configured);
	//if (!is_configured && !disabled) { //We do not care wsc is enable for disable--20081223
	if (!is_configured) {
		is_configured = 1;
		apmib_set(MIB_WLAN_WSC_CONFIGURED, (void *)&is_configured);
#if defined(CONFIG_RTL_92D_SUPPORT)
		if(wlan_idx==0){
			wlan_idx = 1;
			apmib_set(MIB_WLAN_WSC_CONFIGURED, (void *)&is_configured);
			wlan_idx = 0;			
		}else if(wlan_idx == 1){
			wlan_idx = 0;
			apmib_set(MIB_WLAN_WSC_CONFIGURED, (void *)&is_configured);
			wlan_idx = 1;			
		}
#endif
	}
}

#if 0
static void convert_hex_to_ascii(unsigned long code, char *out)
{
	*out++ = '0' + ((code / 10000000) % 10);  
	*out++ = '0' + ((code / 1000000) % 10);
	*out++ = '0' + ((code / 100000) % 10);
	*out++ = '0' + ((code / 10000) % 10);
	*out++ = '0' + ((code / 1000) % 10);
	*out++ = '0' + ((code / 100) % 10);
	*out++ = '0' + ((code / 10) % 10);
	*out++ = '0' + ((code / 1) % 10);
	*out = '\0';
}

static int compute_pin_checksum(unsigned long int PIN)
{
	unsigned long int accum = 0;
	int digit;
	
	PIN *= 10;
	accum += 3 * ((PIN / 10000000) % 10); 	
	accum += 1 * ((PIN / 1000000) % 10);
	accum += 3 * ((PIN / 100000) % 10);
	accum += 1 * ((PIN / 10000) % 10); 
	accum += 3 * ((PIN / 1000) % 10); 
	accum += 1 * ((PIN / 100) % 10); 
	accum += 3 * ((PIN / 10) % 10);

	digit = (accum % 10);
	return (10 - digit) % 10;
}
#endif

////////////////////////////////////////////////////////////////////////////////
void apmib_reset_wlan_to_default(unsigned char *wlanif_name)
{
	SetWlan_idx(wlanif_name);
	memcpy(&pMib->wlan[wlan_idx][vwlan_idx], &pMibDef->wlan[wlan_idx][vwlan_idx], sizeof(CONFIG_WLAN_SETTING_T));	
	if(strstr((char *)wlanif_name,"vxd") != 0)
	{
		if(wlan_idx == 0)
		{
			sprintf((char *)pMib->repeaterSSID1, (char *)pMib->wlan[wlan_idx][vwlan_idx].ssid);
			pMib->wlan[wlan_idx][vwlan_idx].wlanDisabled = !pMib->repeaterEnabled1;			
		}
		else
		{
			sprintf((char *)pMib->repeaterSSID2, (char *)pMib->wlan[wlan_idx][vwlan_idx].ssid);
			pMib->wlan[wlan_idx][vwlan_idx].wlanDisabled = !pMib->repeaterEnabled2;			
		}
	}
}

void updateVapWscDisable(int wlan_root,int value)
{
	int i=0;
	int wlanif_idx = 0;
	char ifname[20];
	
	for(i=0;i<(NUM_VWLAN_INTERFACE-1);i++) // vap0~vap3
	{
		memset(ifname,0x00,sizeof(ifname));
		sprintf(ifname,"wlan%d-va%d",wlan_root,i);
		SetWlan_idx(ifname);
		apmib_set(MIB_WLAN_WSC_DISABLE, (void *)&value);
	}
	memset(ifname,0x00,sizeof(ifname));
	sprintf(ifname,"wlan%d-vxd",wlan_root);
	SetWlan_idx(ifname);
	apmib_set(MIB_WLAN_WSC_DISABLE, (void *)&value);
	
	memset(ifname,0x00,sizeof(ifname));
	sprintf(ifname,"wlan%d",wlan_root);
	SetWlan_idx(ifname);
}

/* WNC-NMR2289-[Rafale]-Libera-20170220-request: WPS PIN enable/disable-start */
void updateVapWscMethod(int wlan_root,int value)
{
	int i=0;
	int wlanif_idx = 0;
	char ifname[20];
	
	for(i=0;i<(NUM_VWLAN_INTERFACE-1);i++) // vap0~vap3
	{
		memset(ifname,0x00,sizeof(ifname));
		sprintf(ifname,"wlan%d-va%d",wlan_root,i);
		SetWlan_idx(ifname);
		apmib_set(MIB_WLAN_WSC_METHOD, (void *)&value);
	}
	memset(ifname,0x00,sizeof(ifname));
	sprintf(ifname,"wlan%d-vxd",wlan_root);
	SetWlan_idx(ifname);
	apmib_set(MIB_WLAN_WSC_METHOD, (void *)&value);
	
	memset(ifname,0x00,sizeof(ifname));
	sprintf(ifname,"wlan%d",wlan_root);
	SetWlan_idx(ifname);
}
/* WNC-NMR2289-[Rafale]-Libera-20170220-request: WPS PIN enable/disable-end */

void formWsc(request *wp, char *path, char *query)
{
	char *strVal, *submitUrl, *strResetUnCfg, *wlanIf;
#if 0 /* WNC-MR2278-Libera-20170215-reject system command from fake POST*/		
	char *targetAPSsid, *targetAPMac; /* WPS2DOTX */
#endif
	/*WPS2DOTX ;check if unlock button be clicked ; brute force attack */
	char  *unlockclicked;
	char *strCfg;	/* WNC-Voyager-Libera-20131125- Spec.: user can switch status UnConfigured or Configured*/
	int intVal=0;//WNC-NMR0000-Rita-20130310-Error_581,Error_605,Error_615-fix warnings of cppcheck (uninitialized value).
	char tmpbuf[200],breadcrumb[100],title[100],explain[30];
	int mode=0; //WNC-NMR0000-Rita-20130310-Error_576,Error_579-fix warnings of cppcheck (uninitialized value).
	int reset_to_unconfig_state_flag = 0;
	int wlanIdx=0;
#if 0	/* WNC-MR000-Libera-20130703- Pocket spec.: change interface: wlan0->wlan0-va0, wlan0-va0->wlan0-va1 */
	int wlan_old = 0;
    int vwlan_old =0;
#endif

	// 1104
	int tmpint;	
	char ifname[30];

	// WPS2DOTX ; 2011-0428
    int idx,idx2;
	char pincodestr_b[20];	
	// WPS2DOTX ; 2011-0428
/* WNC-MR0000-Libera-20120523-  spec. 1.6.0 redirect to top page*/
	int opmode;
	apmib_get( MIB_OP_MODE, (void *)&opmode);
/* WNC-MR0000-Libera-20120523-  spec. 1.6.0 redirect to top page -END*/

#if 1	/* WNC-NMR000-[Aero/Thalys]-Libera-20160823- Server side input check-start */
	char *pinKey;
	int pin_no=0;
	strVal = req_get_cstream_var(wp, ("setPIN"), "");
	if (strVal[0]) {
		//strVal='\0';
		pinKey = req_get_cstream_var(wp, ("peerPin"), "");
		if (pinKey[0]) {
			if (lw_PINCheck(pinKey)){
				printf("[error][pin]: Func: %s, Line: %d\n",__FUNCTION__ , __LINE__);
				send_redirect_perm(wp, LW_GUI_INPUT_ERR_PAGE);
				return -1;
			}
		}else{
			printf("[error][psk]:NULL Func: %s, Line: %d\n",__FUNCTION__ , __LINE__);
			send_redirect_perm(wp, LW_GUI_INPUT_ERR_PAGE);
			return -1;
		}
	}
#endif	/* WNC-NMR000-[Aero/Thalys]-Libera-20160823- Server side input check-end */

/*wnc-20170221-for fine tune code: move here -start*/
#if defined(FOR_DUAL_BAND)
	int wlanDisabled[2];
	int wlanMode[2];		
	int wlanPhyBand[2];
	int wlanMacPhy[2];
	int wlanif;
	int isSwapWlwanIf = 0;
	int wlan0_mode=1, wlan1_mode=1;
	int wlan0_disable=0, wlan1_disable=0;
	int wlan_orig;

	wlan_orig = wlan_idx;
	SetWlan_idx("wlan0");
	apmib_get(MIB_WLAN_MODE, &wlan0_mode);
	apmib_get(MIB_WLAN_WLAN_DISABLED, &wlan0_disable);
	SetWlan_idx("wlan1");
	apmib_get(MIB_WLAN_MODE, &wlan1_mode);
	apmib_get(MIB_WLAN_WLAN_DISABLED, &wlan1_disable);

	//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20130814, fix coverity error 823
	memset(tmpbuf, 0x00, sizeof(tmpbuf));
	//sprintf(tmpbuf, "wlan%d", wlan_idx);
	snprintf(tmpbuf, sizeof(tmpbuf), "wlan%d", wlan_idx);	//2426
	SetWlan_idx(tmpbuf);
	wlan_idx = wlan_orig;
#endif
/*wnc-20170221-for fine tune code: move here -end*/

/* WNC-NMR0000-Rita-20130309-Apply WPS to both dual radios */
for(wlanIdx=0; wlanIdx<NUM_WLAN_INTERFACE; wlanIdx++){
		unsigned char wlanIff[10];
		memset(wlanIff,0x00,sizeof(wlanIff));
		//sprintf(wlanIff, "wlan%d",wlanIdx);
		snprintf(wlanIff, sizeof(wlanIff), "wlan%d", wlanIdx);	//2426
		SetWlan_idx(wlanIff);

	memset(ifname,'\0',30);

/* WNC-MR0000-Libera-20120308- get lan ip -start*/
	char lan_ip_buf[30], lan_ip[30];
	apmib_get( MIB_IP_ADDR,  (void *)lan_ip_buf) ;
	//sprintf(lan_ip,"%s",inet_ntoa(*((struct in_addr *)lan_ip_buf)) );
	snprintf(lan_ip, sizeof(lan_ip), "%s", inet_ntoa(*((struct in_addr *)lan_ip_buf)));	//2426
/* WNC-MR0000-Libera-20120308- get lan ip -end*/

// WNC-MR000-Libera-20130325- WPS not use WEP,ACL -start
int trigger_wlan1=0;
if(isFileExist("/var/wscd-wlan1.fifo")){
	trigger_wlan1=1;
}
/* WNC-NMR000-[Linear]-Libera-20140502- SPEC.v0.2.0- WPS: for Dual Radios -Start */
int trigger_wlan0=0;
if(isFileExist("/var/wscd-wlan0.fifo")){
	trigger_wlan0=1;
}
/* WNC-NMR000-[Linear]-Libera-20140502- SPEC.v0.2.0- WPS: for Dual Radios -End */
// WNC-MR000-Libera-20130325- WPS not use WEP,ACL -end

//displayPostDate(wp->post_data);

	/* support  special MAC , 2011-0505 WPS2DOTX */
#if 0 /* WNC-MR2278-Libera-20170215-reject system command from fake POST*/	
	targetAPMac = req_get_cstream_var(wp, "targetAPMac", (""));
	targetAPSsid = req_get_cstream_var(wp, "targetAPSsid", (""));
#endif	
	/* support  special SSID , 2011-0505 WPS2DOTX */	
	submitUrl = req_get_cstream_var(wp, ("submit-url"), "");
	/* NMR2281-20170214-Modify message and prevent multiple starting in [WPS(PIN覡)]-start*/
	if ((lw_is_rakuraku_running()==1) || (lw_is_wps_running()==1) || (lw_is_fw_updating()==1) ) {	/* NMR2281-20170214-Modify message and prevent multiple starting in [WPS(PIN覡)] */

		/* If RakuRaku or WPS is running, do not exeute site survey and return directly. */
		/* Site survey page knows RakuRaku or WPS is running by ASP GET function and will pop up warning message. */
		if (submitUrl[0])
			send_redirect_perm(wp, "/cgi_html_903.html");
	
		return;
	}
	/* NMR2281-20170214-Modify message and prevent multiple starting in [WPS(PIN覡)]-end */

	strResetUnCfg = req_get_cstream_var(wp, ("resetUnCfg"), "");	//NEC product doesn't use it after Pocket.
	if(strResetUnCfg[0] && strResetUnCfg[0]=='1')// reset to unconfig state. Keith
	{				
//#if defined(FOR_DUAL_BAND) //  ; both reset two unterface (wlan0 AND wlan1)
#if defined(CONFIG_RTL_92D_SUPPORT)
		wlanif = whichWlanIfIs(PHYBAND_5G);
		
		if(wlanif != 0)
		{
			swapWlanMibSetting(0,1);
			isSwapWlwanIf = 1;
		}
		wlanDisabled[0] = pMib->wlan[0][0].wlanDisabled;
		wlanDisabled[1] = pMib->wlan[1][0].wlanDisabled;
		wlanMode[0] = pMib->wlan[0][0].wlanMode;
		wlanMode[1] = pMib->wlan[1][0].wlanMode;
		wlanMacPhy[0] = pMib->wlan[0][0].macPhyMode;
		wlanMacPhy[1] = pMib->wlan[1][0].macPhyMode;

		//printf("(%s,%d)Reset to OOB ...\n",__FUNCTION__ , __LINE__);//Realtek patch start [CheeperSW:0257]
		printf("(%s,%d)Reset to UnConfigured ...\n",__FUNCTION__ , __LINE__);//Realtek patch start [CheeperSW:0257]
		if(wlanMode[0] != CLIENT_MODE)
		{
		//Realtek patch start [CheeperSW:0257] -start
		//	apmib_reset_wlan_to_default("wlan0");	
			pMib->wlan[0][0].wscConfigByExtReg = reset_to_unconfig_state_flag;
			pMib->wlan[0][0].wscConfigured = reset_to_unconfig_state_flag;
			printf("wscConfigByExtReg0=%d, wscConfigured0=%d \n",pMib->wlan[0][0].wscConfigByExtReg ,pMib->wlan[0][0].wscConfigured);
		//Realtek patch start [CheeperSW:0257] -end	
			pMib->wlan[0][0].wlanDisabled = wlanDisabled[0];
			pMib->wlan[0][0].macPhyMode = wlanMacPhy[0];
		}
		if(wlanMode[1] != CLIENT_MODE)
		{
			//Realtek patch start [CheeperSW:0257] -start
			//	apmib_reset_wlan_to_default("wlan1");	
				pMib->wlan[1][0].wscConfigByExtReg = reset_to_unconfig_state_flag;
				pMib->wlan[1][0].wscConfigured = reset_to_unconfig_state_flag;
				printf("wscConfigByExtReg1=%d, wscConfigured1=%d \n",pMib->wlan[1][0].wscConfigByExtReg ,pMib->wlan[1][0].wscConfigured);
			//Realtek patch start [CheeperSW:0257] -end 
			pMib->wlan[1][0].wlanDisabled = wlanDisabled[1];
			pMib->wlan[1][0].macPhyMode = wlanMacPhy[1];
		}
		
		if(isSwapWlwanIf == 1)
		{
			swapWlanMibSetting(0,1);
			isSwapWlwanIf = 0;
		}
		
#else
//		wlanIf = req_get_cstream_var(wp, ("wlanIf"), "");
//		if(wlanIf[0])
#ifdef CONFIG_RTL_8881A_SELECTIVE
		mode=pMib->wlan[0][0].wlanMode;
		tmpint=pMib->wlan[0][0].wlanBand;
#endif
//Realtek patch start [CheeperSW:0257]
//		apmib_reset_wlan_to_default((unsigned char *)"wlan0");
		apmib_set(MIB_WLAN_WSC_CONFIGBYEXTREG, (void *)&reset_to_unconfig_state_flag);
		apmib_set(MIB_WLAN_WSC_CONFIGURED, (void *)&reset_to_unconfig_state_flag);
//Realtek patch End [CheeperSW:0257]
#ifdef CONFIG_RTL_8881A_SELECTIVE
		pMib->wlan[0][0].wlanMode=mode;
		pMib->wlan[0][0].wlanBand=tmpint;
#endif
//		else
//			printf("Reset wlan to default fail!! No wlan name. %s,%d\n",__FUNCTION__ , __LINE__);

#if 0	/* WNC-MR000-Libera-20130703- Pocket spec.: change interface: wlan0->wlan0-va0, wlan0-va0->wlan0-va1 */
		wlan_old = wlan_idx;
		vwlan_old = vwlan_idx;
		SetWlan_idx("wlan0-va0");
		apmib_set(MIB_WLAN_WSC_CONFIGBYEXTREG, (void *)&reset_to_unconfig_state_flag);
		apmib_set(MIB_WLAN_WSC_CONFIGURED, (void *)&reset_to_unconfig_state_flag);
		wlan_idx = wlan_old;
		vwlan_idx = vwlan_old;
#endif

#endif

#ifdef REBOOT_CHECK
		strVal = req_get_cstream_var(wp, ("disableWPS"), "");
		if ( !strcmp(strVal, "ON"))
			intVal = 1;
		else
			intVal = 0;
		apmib_set(MIB_WLAN_WSC_DISABLE, (void *)&intVal);
		updateVapWscDisable(wlan_idx,intVal);
/*WNC-MR0000-JOE-PENG-20120606-Modification for specification V1.8.0 section 6.10 Reboot Now */
#if 0
		//REBOOT_WAIT(submitUrl);
		WPS_REBOOT_WAIT(submitUrl);	/* WNC-MR0000-Libera-20120523- for NEC v1.6.0 spec. */
		run_init_script_flag = 1;
#endif
/*WNC-MR0000-JOE-PENG-20120606-end */
#endif

		apmib_update_web(CURRENT_SETTING);
/*WNC-MR0000-JOE-PENG-20120606-Modification for specification V1.8.0 section 6.10 Reboot Now */
#if 1
		formReboot(wp, path, query);
#else
#ifndef NO_ACTION
		run_init_script("bridge");
#endif
#endif
/*WNC-MR0000-JOE-PENG-20120606-end */
		return;
	}
#if 1	/* WNC-MR0000-[Voyager]-Libera-20140205- spec.1.3. Add message for WPS status change */
	//change WPS state
	strResetUnCfg = req_get_cstream_var(wp, ("resetCfg"), "");
	if(strResetUnCfg[0] && strResetUnCfg[0]=='1')// reset WPS state.
	{
		/* WNC-Voyager-Libera-20131125- Spec.: user can switch status UnConfigured or Configured - Start*/
		/* WNC-MR561-[Voyager]-Libera-20140218- SPEC.1.5 Change the reboot and config method -Start */
		int wscEr=0;
		strVal = req_get_cstream_var(wp, ("disableWPS"), "");
		if ( !strcmp(strVal, "ON")){
			strCfg = req_get_cstream_var(wp, ("config_h"), "");
			
			strVal = req_get_cstream_var(wp, ("wscER_h"), "");
			if(strVal[0] && strVal[0]=='2')
				wscEr=2;
			else
				wscEr=0;
				
			if(NUM_WLAN_INTERFACE == 2){/* WNC-NMR000-[Linear]-Libera-20140502- SPEC.v0.2.0- WPS: for Dual Radios -Start */
#if defined(FOR_DUAL_BAND)
				wlan_orig = wlan_idx;
				SetWlan_idx("wlan0");
				apmib_set(MIB_WLAN_WSC_CFG_BY_EXREG_DISABLE, (void *)&wscEr);
				SetWlan_idx("wlan1");
				apmib_set(MIB_WLAN_WSC_CFG_BY_EXREG_DISABLE, (void *)&wscEr);
				wlan_idx = wlan_orig;
#endif				
			}else{
				apmib_set(MIB_WLAN_WSC_CFG_BY_EXREG_DISABLE, (void *)&wscEr);
			}
			
			if (!strcmp(strCfg,"on")){	//Configured
				reset_to_unconfig_state_flag=0;
				if(NUM_WLAN_INTERFACE == 2){/* WNC-NMR000-[Linear]-Libera-20140502- SPEC.v0.2.0- WPS: for Dual Radios -Start */
#if defined(FOR_DUAL_BAND)
					wlan_orig = wlan_idx;				
					SetWlan_idx("wlan0");
					apmib_set(MIB_WLAN_WSC_CONFIGBYEXTREG, (void *)&reset_to_unconfig_state_flag);
					SetWlan_idx("wlan1");
					apmib_set(MIB_WLAN_WSC_CONFIGBYEXTREG, (void *)&reset_to_unconfig_state_flag);
					wlan_idx = wlan_orig;
#endif					
				}else{
					apmib_set(MIB_WLAN_WSC_CONFIGBYEXTREG, (void *)&reset_to_unconfig_state_flag);
				}
				
				reset_to_unconfig_state_flag=1;
				if(NUM_WLAN_INTERFACE == 2){/* WNC-NMR000-[Linear]-Libera-20140502- SPEC.v0.2.0- WPS: for Dual Radios -Start */
#if defined(FOR_DUAL_BAND)
					wlan_orig = wlan_idx;					
					SetWlan_idx("wlan0");
					apmib_set(MIB_WLAN_WSC_CONFIGURED, (void *)&reset_to_unconfig_state_flag);
					SetWlan_idx("wlan1");
					apmib_set(MIB_WLAN_WSC_CONFIGURED, (void *)&reset_to_unconfig_state_flag);
					wlan_idx = wlan_orig;
#endif
				}else{
					apmib_set(MIB_WLAN_WSC_CONFIGURED, (void *)&reset_to_unconfig_state_flag);
				}
			}else if (!strcmp(strCfg,"off")){	//UnConfigured
				reset_to_unconfig_state_flag=0;
				if(NUM_WLAN_INTERFACE == 2){/* WNC-NMR000-[Linear]-Libera-20140502- SPEC.v0.2.0- WPS: for Dual Radios -Start */
#if defined(FOR_DUAL_BAND)
					wlan_orig = wlan_idx;					
					SetWlan_idx("wlan0");
					apmib_set(MIB_WLAN_WSC_CONFIGBYEXTREG, (void *)&reset_to_unconfig_state_flag);
					apmib_set(MIB_WLAN_WSC_CONFIGURED, (void *)&reset_to_unconfig_state_flag);
					SetWlan_idx("wlan1");
					apmib_set(MIB_WLAN_WSC_CONFIGBYEXTREG, (void *)&reset_to_unconfig_state_flag);
					apmib_set(MIB_WLAN_WSC_CONFIGURED, (void *)&reset_to_unconfig_state_flag);
					wlan_idx = wlan_orig;
#endif					
				}else{
					apmib_set(MIB_WLAN_WSC_CONFIGBYEXTREG, (void *)&reset_to_unconfig_state_flag);
					apmib_set(MIB_WLAN_WSC_CONFIGURED, (void *)&reset_to_unconfig_state_flag);
				}
			}
		}else{
			strCfg = req_get_cstream_var(wp, ("config"), "");
			strVal = req_get_cstream_var(wp, ("wscER"), "");
			if(strVal[0] && strVal[0]=='2')
				wscEr=2;
			else
				wscEr=0;
			
			if(NUM_WLAN_INTERFACE == 2){/* WNC-NMR000-[Linear]-Libera-20140502- SPEC.v0.2.0- WPS: for Dual Radios -Start */
#if defined(FOR_DUAL_BAND)
				wlan_orig = wlan_idx;				
				SetWlan_idx("wlan0");
				apmib_set(MIB_WLAN_WSC_CFG_BY_EXREG_DISABLE, (void *)&wscEr);
				SetWlan_idx("wlan1");
				apmib_set(MIB_WLAN_WSC_CFG_BY_EXREG_DISABLE, (void *)&wscEr);
				wlan_idx = wlan_orig;
#endif				
			}else{
				apmib_set(MIB_WLAN_WSC_CFG_BY_EXREG_DISABLE, (void *)&wscEr);
			}
			
			if (!strcmp(strCfg,"on")){	//Configured
				reset_to_unconfig_state_flag=0;
				if(NUM_WLAN_INTERFACE == 2){/* WNC-NMR000-[Linear]-Libera-20140502- SPEC.v0.2.0- WPS: for Dual Radios -Start */
#if defined(FOR_DUAL_BAND)
					wlan_orig = wlan_idx;					
					SetWlan_idx("wlan0");
					apmib_set(MIB_WLAN_WSC_CONFIGBYEXTREG, (void *)&reset_to_unconfig_state_flag);
					SetWlan_idx("wlan1");
					apmib_set(MIB_WLAN_WSC_CONFIGBYEXTREG, (void *)&reset_to_unconfig_state_flag);	
					wlan_idx = wlan_orig;
#endif
				}else{
					apmib_set(MIB_WLAN_WSC_CONFIGBYEXTREG, (void *)&reset_to_unconfig_state_flag);
				}
				
				reset_to_unconfig_state_flag=1;
				if(NUM_WLAN_INTERFACE == 2){/* WNC-NMR000-[Linear]-Libera-20140502- SPEC.v0.2.0- WPS: for Dual Radios -Start */
#if defined(FOR_DUAL_BAND)
					wlan_orig = wlan_idx;					
					SetWlan_idx("wlan0");
					apmib_set(MIB_WLAN_WSC_CONFIGURED, (void *)&reset_to_unconfig_state_flag);
					SetWlan_idx("wlan1");
					apmib_set(MIB_WLAN_WSC_CONFIGURED, (void *)&reset_to_unconfig_state_flag);
					wlan_idx = wlan_orig;
#endif					
				}else{
					apmib_set(MIB_WLAN_WSC_CONFIGURED, (void *)&reset_to_unconfig_state_flag);
				}				
			}else if (!strcmp(strCfg,"off")){	//UnConfigured
				reset_to_unconfig_state_flag=0;
				if(NUM_WLAN_INTERFACE == 2){/* WNC-NMR000-[Linear]-Libera-20140502- SPEC.v0.2.0- WPS: for Dual Radios -Start */
#if defined(FOR_DUAL_BAND)
					wlan_orig = wlan_idx;				
					SetWlan_idx("wlan0");
					apmib_set(MIB_WLAN_WSC_CONFIGBYEXTREG, (void *)&reset_to_unconfig_state_flag);
					apmib_set(MIB_WLAN_WSC_CONFIGURED, (void *)&reset_to_unconfig_state_flag);
					SetWlan_idx("wlan1");
					apmib_set(MIB_WLAN_WSC_CONFIGBYEXTREG, (void *)&reset_to_unconfig_state_flag);
					apmib_set(MIB_WLAN_WSC_CONFIGURED, (void *)&reset_to_unconfig_state_flag);
					wlan_idx = wlan_orig;
#endif					
				}else{
					apmib_set(MIB_WLAN_WSC_CONFIGBYEXTREG, (void *)&reset_to_unconfig_state_flag);
					apmib_set(MIB_WLAN_WSC_CONFIGURED, (void *)&reset_to_unconfig_state_flag);
				}
			}
		}
		/* WNC-MR561-[Voyager]-Libera-20140218- SPEC.1.5 Change the reboot and config method - End*/
		/* WNC-Voyager-Libera-20131125- Spec.: user can switch status UnConfigured or Configured - End*/
#ifdef REBOOT_CHECK
		strVal = req_get_cstream_var(wp, ("disableWPS"), "");
#if 1		/* WNC-NMR2289-[Rafale]-Libera-20170220-request: WPS PIN enable/disable */
		if ( !strcmp(strVal, "ON"))
			intVal = 2;
		else
			intVal = 3;
		apmib_set(MIB_WLAN_WSC_METHOD, (void *)&intVal);
		
		updateVapWscMethod(wlan_idx,intVal);
#else	// WPS enable/disable
		if ( !strcmp(strVal, "ON"))
			intVal = 1;
		else
			intVal = 0;
		apmib_set(MIB_WLAN_WSC_DISABLE, (void *)&intVal);
		updateVapWscDisable(wlan_idx,intVal);
#endif		
#endif

		apmib_update_web(CURRENT_SETTING);
		formReboot(wp, path, query);
		return;
	}
#endif

//libera -- , spec. changed by D02-0000040692_V1.4.0_Pocket_SW_SpecChangeRequest
#if 1 /* WNC-MR000-Libera-20130619- new spec: Disable configured by exReg - start */	// 20130731-spec.V1.6.0 recover
		strVal = req_get_cstream_var(wp, ("wscER"), "");	//(0: allow unconfig/config state, 1:allow unconfig state, 2:deny)
		if ( !strcmp(strVal, "2")){
			intVal = 2;	// deny : disable ERgeg config.
		}else if ( !strcmp(strVal, "1")){
			intVal = 1;	// allow unconfig state
		}else if ( !strcmp(strVal, "0")){
			intVal = 0;	// allow unconfig/config state
		}else{	//original vale	/* WNC-MR494-Libera-20130906 - [Pocket] new request */
			apmib_get(MIB_WLAN_WSC_CFG_BY_EXREG_DISABLE, (void *)&intVal);
		}
#if 1	/*wnc-20170221-for fine tune code.*/

/* WNC-NMR2289-[Rafale]-Libera-20170220-request: WPS PIN enable/disable-start */
		strVal = req_get_cstream_var(wp, ("disableWPS"), "");
		if ( !strcmp(strVal, "ON")){
			intVal = 2; //spec: PIN disable -> ER disabled
#if 1	//if PIN=OFF, change status to Configured.
			int is_configured=0, reset_flag = 0, disabled=0;
			apmib_set(MIB_WLAN_WSC_CONFIGBYEXTREG, (void *)&reset_flag);
			apmib_get(MIB_WLAN_WSC_DISABLE, (void *)&disabled); 
			apmib_get(MIB_WLAN_WSC_CONFIGURED, (void *)&is_configured);
			
			if (!is_configured) {
				is_configured = 1;
				apmib_set(MIB_WLAN_WSC_CONFIGURED, (void *)&is_configured);
			}
#endif			
		}
/* WNC-NMR2289-[Rafale]-Libera-20170220-request: WPS PIN enable/disable-end */

		apmib_set(MIB_WLAN_WSC_CFG_BY_EXREG_DISABLE, (void *)&intVal);
#else
		if(NUM_WLAN_INTERFACE == 2){/* WNC-NMR000-[Linear]-Libera-20140502- SPEC.v0.2.0- WPS: for Dual Radios -Start */
#if defined(FOR_DUAL_BAND)
			wlan_orig = wlan_idx;		
			SetWlan_idx("wlan0");
			apmib_set(MIB_WLAN_WSC_CFG_BY_EXREG_DISABLE, (void *)&intVal);
			SetWlan_idx("wlan1");
			apmib_set(MIB_WLAN_WSC_CFG_BY_EXREG_DISABLE, (void *)&intVal);
			wlan_idx = wlan_orig;
#endif			
		}else{		
			apmib_set(MIB_WLAN_WSC_CFG_BY_EXREG_DISABLE, (void *)&intVal);
		}
#endif
#if 0	/* WNC-MR000-Libera-20130703- Pocket spec.: change interface: wlan0->wlan0-va0, wlan0-va0->wlan0-va1 */
		wlan_old = wlan_idx;
		vwlan_old = vwlan_idx;
		SetWlan_idx("wlan0-va0");
		apmib_set(MIB_WLAN_WSC_CFG_BY_EXREG_DISABLE, (void *)&intVal);
		wlan_idx = wlan_old;
		vwlan_idx = vwlan_old;
#endif
		
#endif /* WNC-MR000-Libera-20130619- new spec: Disable configured by exReg - end */

#if defined(UNIVERSAL_REPEATER) && defined(CONFIG_REPEATER_WPS_SUPPORT)
	strResetUnCfg = req_get_cstream_var(wp, ("resetRptUnCfg"), "");	//NEC product doesn't use it.
	if(strResetUnCfg[0] && strResetUnCfg[0]=='1')// reset to unconfig state. Keith
	{
		wlanIf = req_get_cstream_var(wp, ("wlanIf"), "");
		if(wlanIf[0])
			apmib_reset_wlan_to_default((unsigned char *)wlanIf);
		else
			printf("Reset wlan to default fail!! No wlan name. %s,%d\n",__FUNCTION__ , __LINE__);		

#ifdef REBOOT_CHECK
		strVal = req_get_cstream_var(wp, ("disableWPS"), "");
		if ( !strcmp(strVal, "ON"))
			intVal = 1;
		else
			intVal = 0;
		apmib_set(MIB_WLAN_WSC_DISABLE, (void *)&intVal);
		updateVapWscDisable(wlan_idx, intVal);
		REBOOT_WAIT(submitUrl);
		run_init_script_flag = 1;
#endif		

		apmib_update_web(CURRENT_SETTING);
		
#ifndef NO_ACTION
		run_init_script("bridge");
#endif
		return;
	}
#endif //#if defined(UNIVERSAL_REPEATER) && defined(CONFIG_REPEATER_WPS_SUPPORT)


	/*WPS2DOTX ;check if unlock button be clicked ; brute force attack */
	unlockclicked = req_get_cstream_var(wp, ("unlockautolockdown"), "");
	if(unlockclicked[0])
	{

#if defined(FOR_DUAL_BAND)	// WNC-MR359-Libera-20130330- when radio is single 5GHz, we use wlan1 to unlock; brute force attack - start
		if ((wlan0_disable==1 && wlan1_disable==0)||(trigger_wlan1==1)){
			wlan_orig = wlan_idx;
			SetWlan_idx("wlan1");
			//sprintf(tmpbuf, "%s -sig_unlock wlan%d", _WSC_DAEMON_PROG,wlan_idx);
			snprintf(tmpbuf, sizeof(tmpbuf), "%s -sig_unlock wlan%d",_WSC_DAEMON_PROG, wlan_idx);	//2426
			wlan_idx = wlan_orig;
		}
		else
#endif	// WNC-MR359-Libera-20130330- when radio is single 5GHz, we use wlan1 to unlock; brute force attack -end
		{
#if 0	/* WNC-MR000-Libera-20130703- Pocket spec.: change interface: wlan0->wlan0-va0, wlan0-va0->wlan0-va1 */
			sprintf(tmpbuf, "%s -sig_unlock wlan%d-va0", _WSC_DAEMON_PROG, wlan_idx);
#else
			//sprintf(tmpbuf, "%s -sig_unlock wlan%d", _WSC_DAEMON_PROG,wlan_idx);
			snprintf(tmpbuf, sizeof(tmpbuf), "%s -sig_unlock wlan%d",_WSC_DAEMON_PROG, wlan_idx);	//2426

#endif
		}
		printf("%s\n",tmpbuf);
		system(tmpbuf);	
#if 1	/* WNC-NMR000-[Aero/Thalys]-Libera-20160606- responsive GUI porting*/
		if (submitUrl[0])
			send_redirect_perm(wp, submitUrl);
#else	//original
		OK_MSG2(UNLOCK_MSG, ((mode==AP_MODE) ? "client" : "AP"), submitUrl);	
#endif
		return;
	}
	/*WPS2DOTX ;check if unlock button be clicked ; brute force attack */
	apmib_get(MIB_WLAN_MODE, (void *)&mode);	
	strVal = req_get_cstream_var(wp, ("triggerPBC"), "");	//for SW PBC button-NEC product doesn't use it after Linear.
	if (strVal[0]) {
		apmib_get(MIB_WLAN_WSC_DISABLE, (void *)&intVal);
		if (intVal) {
			intVal = 0;
			apmib_set(MIB_WLAN_WSC_DISABLE, (void *)&intVal);
                        updateVapWscDisable(wlan_idx, intVal);
			apmib_update_web(CURRENT_SETTING);	// update to flash	
			system("echo 1 > /var/wps_start_pbc");
#ifndef NO_ACTION
			run_init_script("bridge");
#endif			
		}
		else {
#ifndef NO_ACTION
#if defined(FOR_DUAL_BAND)	// WNC-MR334-Libera-20130318- when radio is single 5GHz, we use wlan1 to trigger WPS -start
			if ((wlan0_disable==1 && wlan1_disable==0)||(trigger_wlan1==1)){	// WNC-MR000-Libera-20130325- WPS not use WEP,ACL
				wlan_orig = wlan_idx;
				SetWlan_idx("wlan1");
				//sprintf(tmpbuf, "%s -sig_pbc wlan%d", _WSC_DAEMON_PROG,wlan_idx);
				snprintf(tmpbuf, sizeof(tmpbuf), "%s -sig_pbc wlan%d", _WSC_DAEMON_PROG, wlan_idx);	//2426
				wlan_idx = wlan_orig;
			}
			else if ((wlan1_disable==1 && wlan0_disable==0)||(trigger_wlan0==1)){	/* WNC-NMR000-[Linear]-Libera-20140502- SPEC.v0.2.0- WPS: for Dual Radios  */
				wlan_orig = wlan_idx;
				SetWlan_idx("wlan0");
				//sprintf(tmpbuf, "%s -sig_pbc wlan%d", _WSC_DAEMON_PROG,wlan_idx);
				snprintf(tmpbuf, sizeof(tmpbuf), "%s -sig_pbc wlan%d", _WSC_DAEMON_PROG, wlan_idx);	//2426
				wlan_idx = wlan_orig;
			}
			else
#endif	// WNC-MR334-Libera-20130318- when radio is single 5GHz, we use wlan1 to trigger WPS -end
			{
#if 0	/* WNC-MR000-Libera-20130703- Pocket spec.: change interface: wlan0->wlan0-va0, wlan0-va0->wlan0-va1 */
#if 1 	/* WNC-MR000-Libera-20130711- Pocket spec: 5.14.10 Operation for wlan0-vxd */
				if ( isVxdInterfaceExist("wlan0-vxd")){
					//printf("[PBC] wlan0-vxd is up, let it down!\n");
					system("ifconfig wlan0-vxd down");
				}
#endif
				sprintf(tmpbuf, "%s -sig_pbc wlan%d-va0", _WSC_DAEMON_PROG, wlan_idx);
#else
				//sprintf(tmpbuf, "%s -sig_pbc wlan%d", _WSC_DAEMON_PROG,wlan_idx);
				snprintf(tmpbuf, sizeof(tmpbuf), "%s -sig_pbc wlan%d", _WSC_DAEMON_PROG, wlan_idx);	//2426
#endif
			}
			system(tmpbuf);
#endif
		}

/* WNC-MRXXXX-JOE-PENG-20120319-Modification for NEC GUI customization */
#if 1	/* WNC-MR0000-Libera-20120412-  Modification for NEC GUI customization*/
	//	OK_MSG2(START_PBC_MSG, ((mode==AP_MODE) ? "饤Ȥ" : "AP"), submitUrl);
		sprintf(breadcrumb,"WPS(PBC)->WPS(ץåܥ)");
		sprintf(title,"WPS(ץåܥ)");
		sprintf(explain,"WPS(ץåܥ)򥹥Ȥޤ<br><br>2ʬWi-FiüWPS¹ԤƤ");
#if 1	/* WNC-MR0000-Libera-20120523-  spec. 1.6.0 redirect to top page*/
	//	int opmode;
	//	apmib_get( MIB_OP_MODE, (void *)&opmode);
			if (opmode == GATEWAY_MODE) {
				OK_MSG_NEC(breadcrumb, title, explain, lan_ip, "home_detail.htm");
			} else if (opmode == BRIDGE_MODE) {
				/* WNC-NMR0000-JOE-PENG-20140430-Modify 4.1 structure of page according to Linear Spec-start */
				//OK_MSG_NEC(breadcrumb, title, explain, lan_ip, "home_detail_bridge.htm");
				/* WNC-NMR0000-JOE-PENG-20140521-Modify codes of boa detecting system mode (Gateway/Bridge/Converter/Repeater)-start */
				int wifi_mode=WIFI_MODE_AP;
				
				if (lw_get_wifi_mode(&wifi_mode) == 1) {
					switch (wifi_mode) {
						case WIFI_MODE_AP:
							OK_MSG_NEC(breadcrumb, title, explain, lan_ip, "home_detail_bridge.htm");
							break;
						case WIFI_MODE_CLIENT:
							OK_MSG_NEC(breadcrumb, title, explain, lan_ip, "home_detail_converter.htm");
							break;
						case WIFI_MODE_REPEATER:
							OK_MSG_NEC(breadcrumb, title, explain, lan_ip, "home_detail_repeater.htm");
							break;
						default:
							OK_MSG_NEC(breadcrumb, title, explain, lan_ip, "home_detail_bridge.htm");
							break;
					}	
				} else {
					OK_MSG_NEC(breadcrumb, title, explain, lan_ip, "home_detail_bridge.htm");
				}
				/* WNC-NMR0000-JOE-PENG-20140521-Modify codes of boa detecting system mode (Gateway/Bridge/Converter/Repeater)-end */
				/* WNC-NMR0000-JOE-PENG-20140430-Modify 4.1 structure of page according to Linear Spec-end */
			} else {
				OK_MSG_NEC(breadcrumb, title, explain, lan_ip, "index.htm");
			}
#endif
		/* WNC-MR0000-JOE-PENG-20120522-Modification for specification 1.6 */
//		OK_MSG_NEC(breadcrumb,title,explain,lan_ip,"index.htm");
#else
		OK_MSG2(START_PBC_MSG, ((mode==AP_MODE) ? "client" : "AP"), submitUrl);
#endif
/* WNC-MRXXXX-JOE-PENG-20120319-end */
		return;
	}
#if defined(UNIVERSAL_REPEATER) && defined(CONFIG_REPEATER_WPS_SUPPORT)	
	strVal = req_get_cstream_var(wp, ("triggerRptPBC"), "");	//NEC product doesn't use it.
	if (strVal[0]) {
		apmib_get(MIB_WLAN_WSC_DISABLE, (void *)&intVal);
		if (intVal) {
			intVal = 0;
			apmib_set(MIB_WLAN_WSC_DISABLE, (void *)&intVal);
			updateVapWscDisable(wlan_idx, intVal);
			apmib_update_web(CURRENT_SETTING);	// update to flash	
			system("echo 1 > /var/wps_start_pbc");
#ifndef NO_ACTION
			run_init_script("bridge");
#endif			
		}
		else {			
#ifndef NO_ACTION		
			//sprintf(tmpbuf, "%s -sig_pbc wlan%d-vxd", _WSC_DAEMON_PROG,wlan_idx);
			snprintf(tmpbuf, sizeof(tmpbuf), "%s -sig_pbc wlan%d-vxd", _WSC_DAEMON_PROG,wlan_idx); //2426
			system(tmpbuf);
#endif
		}
/* WNC-MRXXXX-JOE-PENG-20120319-Modification for NEC GUI customization */
#if 1	/* WNC-MR0000-Libera-20120412-  Modification for NEC GUI customization*/
	//	OK_MSG2(START_PBC_MSG, ((mode==AP_MODE) ? "饤Ȥ" : "AP"), submitUrl);
		sprintf(breadcrumb,"WPS(PBC)->WPS(ץåܥ)");
		sprintf(title,"WPS(ץåܥ)");
		sprintf(explain,"WPS(ץåܥ)򥹥Ȥޤ<br><br>2ʬWi-FiüWPS¹ԤƤ");

#if 1	/* WNC-MR0000-Libera-20120523-  spec. 1.6.0 redirect to top page*/
	//	int opmode;
	//	apmib_get( MIB_OP_MODE, (void *)&opmode);
			if (opmode == GATEWAY_MODE) {
				OK_MSG_NEC(breadcrumb, title, explain, lan_ip, "home_detail.htm");
			} else if (opmode == BRIDGE_MODE) {
				/* WNC-NMR0000-JOE-PENG-20140430-Modify 4.1 structure of page according to Linear Spec-start */
				//OK_MSG_NEC(breadcrumb, title, explain, lan_ip, "home_detail_bridge.htm");
				/* WNC-NMR0000-JOE-PENG-20140521-Modify codes of boa detecting system mode (Gateway/Bridge/Converter/Repeater)-start */
				int wifi_mode=WIFI_MODE_AP;
				
				if (lw_get_wifi_mode(&wifi_mode) == 1) {
					switch (wifi_mode) {
						case WIFI_MODE_AP:
							OK_MSG_NEC(breadcrumb, title, explain, lan_ip, "home_detail_bridge.htm");
							break;
						case WIFI_MODE_CLIENT:
							OK_MSG_NEC(breadcrumb, title, explain, lan_ip, "home_detail_converter.htm");
							break;
						case WIFI_MODE_REPEATER:
							OK_MSG_NEC(breadcrumb, title, explain, lan_ip, "home_detail_repeater.htm");
							break;
						default:
							OK_MSG_NEC(breadcrumb, title, explain, lan_ip, "home_detail_bridge.htm");
							break;
					}	
				} else {
					OK_MSG_NEC(breadcrumb, title, explain, lan_ip, "home_detail_bridge.htm");
				}
				/* WNC-NMR0000-JOE-PENG-20140521-Modify codes of boa detecting system mode (Gateway/Bridge/Converter/Repeater)-end */
				/* WNC-NMR0000-JOE-PENG-20140430-Modify 4.1 structure of page according to Linear Spec-end */
			} else {
				OK_MSG_NEC(breadcrumb, title, explain, lan_ip, "index.htm");
			}
#endif
		/* WNC-MR0000-JOE-PENG-20120522-Modification for specification 1.6 */
	//	OK_MSG_NEC(breadcrumb,title,explain,lan_ip,"index.htm");
#else
		OK_MSG2(START_PBC_MSG, ((mode==AP_MODE) ? "client" : "AP"), submitUrl);
#endif
/* WNC-MRXXXX-JOE-PENG-20120319-end */
		return;
	}
#endif //#if defined(UNIVERSAL_REPEATER) && defined(CONFIG_REPEATER_WPS_SUPPORT)

/* support  special SSID , 2011-0505 WPS2DOTX */
	strVal = req_get_cstream_var(wp, ("stopwsc"), (""));
	if (strVal[0]) {
		//vxd/vap WPS don't support stop feature now.
		//sprintf(tmpbuf, "echo wlan%d > /tmp/wscd_cancel ", wlan_idx);
		snprintf(tmpbuf, sizeof(tmpbuf), "echo wlan%d > /tmp/wscd_cancel ", wlan_idx);	//2426
		system(tmpbuf);	
		//OK_MSG2(STOP_MSG, ((mode==AP_MODE) ? "client" : "AP"), submitUrl);
		return;
	}
/* support  special SSID , 2011-0505 WPS2DOTX */

	strVal = req_get_cstream_var(wp, ("triggerPIN"), "");	//NEC product doesn't use it.
	if (strVal[0]) {
		int local_pin_changed = 0;		
		strVal = req_get_cstream_var(wp, ("localPin"), "");
		if (strVal[0]) {
#if 1	/* WNC-MR0000-[Voyager]-Libera-20131216- new MIB for software PIN code of WPS */			
			apmib_get(MIB_WLAN_WSC_SW_PIN, (void *)tmpbuf);	
#else	//HW PIN
			apmib_get(MIB_HW_WSC_PIN, (void *)tmpbuf);
#endif
			if (strcmp(tmpbuf, strVal)) {
				
#if 1 /* WNC-MR0000-[Voyager]-Libera-20131216- new MIB for software PIN code of WPS */				
				apmib_set(MIB_WLAN_WSC_SW_PIN, (void *)strVal);
#else	//HW PIN
				apmib_set(MIB_HW_WSC_PIN, (void *)strVal);
#endif
#if 0	/* WNC-MR000-Libera-20130703- Pocket spec.: change interface: wlan0->wlan0-va0, wlan0-va0->wlan0-va1 */
				wlan_old = wlan_idx;
				vwlan_old = vwlan_idx;
				SetWlan_idx("wlan0-va0");
				apmib_set(MIB_HW_WSC_PIN, (void *)strVal);
				wlan_idx = wlan_old;
				vwlan_idx = vwlan_old;
#endif
				local_pin_changed = 1;
			}
		}
		apmib_get(MIB_WLAN_WSC_DISABLE, (void *)&intVal);
		if (intVal) {
			char localpin[100]={0};//WNC-NMR0000-Rita-20130310-Error_602-fix warnings of cppcheck (uninitialized value).
			intVal = 0;
			apmib_set(MIB_WLAN_WSC_DISABLE, (void *)&intVal);
			updateVapWscDisable(wlan_idx, intVal);
			apmib_update_web(CURRENT_SETTING);	// update to flash	
			system("echo 1 > /var/wps_start_pin");

#ifndef NO_ACTION
			if (local_pin_changed) {
				apmib_get(MIB_HW_WSC_PIN, (void *)localpin);
				//sprintf(tmpbuf, "echo %s > /var/wps_local_pin", localpin);
				snprintf(tmpbuf, sizeof(tmpbuf), "echo %s > /var/wps_local_pin", localpin);	//2426
				system(tmpbuf);
			}
			run_init_script("bridge");			
#endif			
		}
		else {		
#ifndef NO_ACTION		
			if (local_pin_changed) {
				system("echo 1 > /var/wps_start_pin");
				
				apmib_update_web(CURRENT_SETTING);					
				run_init_script("bridge");
			}
			else {

				/* support  special MAC , 2011-0505 ;WPS2DOTX*/
#if 0 /* WNC-MR2278-Libera-20170215-reject system command from fake POST*/	
				
				if(targetAPMac[0]){
					unsigned char targetAPMacFilter[20];
					int idx = 0;
					int idx2 = 0;					
					//printf("before ,mac =%s len=%d \n",targetAPMac , strlen(targetAPMac));
					for(idx;idx<strlen(targetAPMac);idx++){
						if( _is_hex(targetAPMac[idx])){
							targetAPMacFilter[idx2]=targetAPMac[idx];
							idx2++;
						}
					}
					
					targetAPMacFilter[idx2]='\0';
					
					if(strlen(targetAPMacFilter)!=12){
						printf("invaild MAC Addr Len\n\n");
					}else{					
						sprintf(tmpbuf, "iwpriv wlan%d set_mib wsc_specmac=%s ",wlan_idx, targetAPMacFilter);
						//printf("tmpbuf=%s\n",tmpbuf);
						system(tmpbuf);						
					}											
					
				}
				if(targetAPSsid[0]){					
					if(strlen(targetAPSsid)<= 32){
						translate_control_code_sprintf(targetAPSsid);
						sprintf(tmpbuf, "iwpriv wlan%d set_mib wsc_specssid=\"%s\" ",wlan_idx, targetAPSsid);
						system(tmpbuf);						
					}else{					
						printf("invaild SSID Len\n");
					}											
					
				}
#endif
				/* support  special SSID , 2011-0505 WPS2DOTX */
#if defined(FOR_DUAL_BAND)
				if( (wlan0_mode == 0) && (wlan1_mode == 0) && (wlan0_disable == 0) && (wlan1_disable == 0))
						//sprintf(tmpbuf, "%s -sig_start %s", _WSC_DAEMON_PROG, "wlan0-wlan1");
						snprintf(tmpbuf, sizeof(tmpbuf), "%s -sig_start %s", _WSC_DAEMON_PROG, "wlan0-wlan1");	//2426
				else
				{
#if 1	// WNC-MR359-Libera-20130330- when radio is single 5GHz, we use wlan1 to trigger - start
						if ((wlan0_disable==1 && wlan1_disable==0)||(trigger_wlan1==1)){
							wlan_orig = wlan_idx;
							SetWlan_idx("wlan1");
							//sprintf(tmpbuf, "%s -sig_start wlan%d", _WSC_DAEMON_PROG,wlan_idx);
							snprintf(tmpbuf, sizeof(tmpbuf), "%s -sig_start wlan%d",_WSC_DAEMON_PROG,wlan_idx);	//2426
							wlan_idx = wlan_orig;
						}
						else
#endif	// WNC-MR359-Libera-20130330- when radio is single 5GHz, we use wlan1 to trigger -end
						{
							//sprintf(tmpbuf, "%s -sig_start wlan%d", _WSC_DAEMON_PROG,wlan_idx);
							snprintf(tmpbuf, sizeof(tmpbuf), "%s -sig_start wlan%d",_WSC_DAEMON_PROG,wlan_idx);	//2426
						}
				}
				system(tmpbuf);
#else

#if 0	/* WNC-MR000-Libera-20130703- Pocket spec.: change interface: wlan0->wlan0-va0, wlan0-va0->wlan0-va1 */
#if 1 	/* WNC-MR000-Libera-20130711- Pocket spec: 5.14.10 Operation for wlan0-vxd */
				if ( isVxdInterfaceExist("wlan0-vxd")){
					//printf("[WSC] wlan0-vxd is up, let it down!\n");
					system("ifconfig wlan0-vxd down");
				}
#endif
				sprintf(tmpbuf, "%s -sig_start wlan%d-va0", _WSC_DAEMON_PROG, wlan_idx);
#else
				//sprintf(tmpbuf, "%s -sig_start wlan%d", _WSC_DAEMON_PROG,wlan_idx);
				snprintf(tmpbuf, sizeof(tmpbuf), "%s -sig_start wlan%d",_WSC_DAEMON_PROG,wlan_idx); //2426
#endif
				system(tmpbuf);
#endif
			}			
#endif
		}
		OK_MSG2(START_PIN_MSG, ((mode==AP_MODE) ? "client" : "AP"), submitUrl);
		return;
	}
	
#if defined(UNIVERSAL_REPEATER) && defined(CONFIG_REPEATER_WPS_SUPPORT)
	strVal = req_get_cstream_var(wp, ("triggerRptPIN"), "");	//NEC product doesn't use it.

	if (strVal[0]) {
		int local_pin_changed = 0;		
		strVal = req_get_cstream_var(wp, ("localPin"), "");
		if (strVal[0]) {
			
#if 1 	/* WNC-MR0000-[Voyager]-Libera-20131216- new MIB for software PIN code of WPS */			
			apmib_get(MIB_WLAN_WSC_SW_PIN, (void *)tmpbuf);
#else	//HW PIN
			apmib_get(MIB_HW_WSC_PIN, (void *)tmpbuf);
#endif
			if (strcmp(tmpbuf, strVal)) {
				
#if 1	/* WNC-MR0000-[Voyager]-Libera-20131216- new MIB for software PIN code of WPS */
				apmib_set(MIB_WLAN_WSC_SW_PIN, (void *)strVal);	
#else	//HW PIN
				apmib_set(MIB_HW_WSC_PIN, (void *)strVal);
#endif
				local_pin_changed = 1;
			}
		}
		apmib_get(MIB_WLAN_WSC_DISABLE, (void *)&intVal);
		if (intVal) {
			//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140916, Fix bug 2699 (UNINIT) in StaticCodeCheck_Linear_Delta1.xls
			//char localpin[100];
			char localpin[100] = {0};
			intVal = 0;			
			apmib_set(MIB_WLAN_WSC_DISABLE, (void *)&intVal);
			apmib_update_web(CURRENT_SETTING);	// update to flash	
			system("echo 1 > /var/wps_start_pin");

#ifndef NO_ACTION
			if (local_pin_changed) {
				apmib_get(MIB_HW_WSC_PIN, (void *)localpin);
				sprintf(tmpbuf, "echo %s > /var/wps_local_pin", localpin);
				system(tmpbuf);
			}
			run_init_script("bridge");			
#endif			
		}
		else {		
#ifndef NO_ACTION		
			if (local_pin_changed) {
				system("echo 1 > /var/wps_start_pin");
				
				apmib_update_web(CURRENT_SETTING);					
				run_init_script("bridge");
			}
			else {
				sprintf(tmpbuf, "%s -sig_start wlan%d-vxd", _WSC_DAEMON_PROG,wlan_idx);
				system(tmpbuf);
			}			
#endif
		}
		OK_MSG2(START_PIN_MSG, ((mode==AP_MODE) ? "client" : "AP"), submitUrl);
		return;
	}
#endif //#if defined(UNIVERSAL_REPEATER) && defined(CONFIG_REPEATER_WPS_SUPPORT)		
	
	strVal = req_get_cstream_var(wp, ("setPIN"), "");	//SW PIN button trigger.
	if (strVal[0]) {		
		strVal = req_get_cstream_var(wp, ("peerPin"), "");
		if (strVal[0]) {
			apmib_get(MIB_WLAN_WSC_DISABLE, (void *)&intVal);
			if (intVal) {
				intVal = 0;
				apmib_set(MIB_WLAN_WSC_DISABLE, (void *)&intVal);
#if 0	/* WNC-MR000-Libera-20130703- Pocket spec.: change interface: wlan0->wlan0-va0, wlan0-va0->wlan0-va1 */
				wlan_old = wlan_idx;
				vwlan_old = vwlan_idx;
				SetWlan_idx("wlan0-va0");
				apmib_set(MIB_WLAN_WSC_DISABLE, (void *)&intVal);
				wlan_idx = wlan_old;
				vwlan_idx = vwlan_old;
#endif	
				apmib_update_web(CURRENT_SETTING);

				//sprintf(tmpbuf, "echo %s > /var/wps_peer_pin", strVal);
				snprintf(tmpbuf, sizeof(tmpbuf), "echo %s > /var/wps_peer_pin",strVal); //2426
				system(tmpbuf);

#ifndef NO_ACTION
				run_init_script("bridge");
#endif					
			}
			else {			
#ifndef NO_ACTION
				// WPS2DOTX ; 2011-0428 ; support the format pin code 1234-5670 (include "-")
				memset(pincodestr_b,'\0',20);				
				//printf("before filter pin code =%s , len =%d\n", strVal ,strlen(strVal));
				idx2=0;
				for(idx=0 ; idx <strlen(strVal) ; idx++){
					//printf("strVal[%d]=%x\n",idx,strVal[idx]);	
					if(strVal[idx] >= '0' && strVal[idx]<= '9'){
						pincodestr_b[idx2]=strVal[idx];	
						idx2++;
					}
				}

				//printf("after filter pin code =%s , len =%d\n", pincodestr_b ,strlen(pincodestr_b));
#if defined(FOR_DUAL_BAND)	// WNC-MR336-Libera-20130318- when radio is single 5GHz, we use wlan1 to trigger WPS -start
				if ((wlan0_disable==1 && wlan1_disable==0)||(trigger_wlan1==1)){	// WNC-MR000-Libera-20130325- WPS not use WEP,ACL
					wlan_orig = wlan_idx;
					SetWlan_idx("wlan1");
					//sprintf(tmpbuf, "iwpriv wlan%d set_mib pin=%s", wlan_idx, pincodestr_b);
					snprintf(tmpbuf, sizeof(tmpbuf), "iwpriv wlan%d set_mib pin=%s", wlan_idx, pincodestr_b);	//2426
					wlan_idx = wlan_orig;
				}
				else if ((wlan1_disable==1 && wlan0_disable==0)||(trigger_wlan0==1)){	/* WNC-NMR000-[Linear]-Libera-20140502- SPEC.v0.2.0- WPS: for Dual Radios  */
					wlan_orig = wlan_idx;
					SetWlan_idx("wlan0");
					//sprintf(tmpbuf, "iwpriv wlan%d set_mib pin=%s", wlan_idx, pincodestr_b);					
					snprintf(tmpbuf, sizeof(tmpbuf), "iwpriv wlan%d set_mib pin=%s", wlan_idx, pincodestr_b);	//2426
					wlan_idx = wlan_orig;
				}				
				else
#endif	// WNC-MR336-Libera-20130318- when radio is single 5GHz, we use wlan1 to trigger WPS -end
				{
				//sprintf(tmpbuf, "iwpriv %s set_mib pin=%s", WLAN_IF, pincodestr_b);		//Realtek
#if 0	/* WNC-MR000-Libera-20130703- Pocket spec.: change interface: wlan0->wlan0-va0, wlan0-va0->wlan0-va1 */
#if 1 	/* WNC-MR000-Libera-20130711- Pocket spec: 5.14.10 Operation for wlan0-vxd */
				if ( isVxdInterfaceExist("wlan0-vxd")){
					//printf("[PIN] wlan0-vxd is up, let it down!\n");
					system("ifconfig wlan0-vxd down");
				}
#endif
				sprintf(tmpbuf, "iwpriv wlan%d-va0 set_mib pin=%s", wlan_idx, pincodestr_b);
#else
				
				//sprintf(tmpbuf, "iwpriv wlan%d set_mib pin=%s", wlan_idx, pincodestr_b);	// WNC-MR419-Libera-20130509 - modified interface correctly		
				snprintf(tmpbuf, sizeof(tmpbuf), "iwpriv wlan%d set_mib pin=%s", wlan_idx, pincodestr_b);	//2426
#endif
				//printf("tmpbuf=%s\n",tmpbuf);
				}
				system(tmpbuf);
				// WPS2DOTX ; 2011-0428 ; support the format pin code 1234-5670 (include "-")				
#endif
			}

#if 1	/* WNC-NMR000-[Aero/Thalys]-Libera-20160606- responsive GUI porting*/
		if (submitUrl[0])
			send_redirect_perm(wp, submitUrl);

#else	/* WNC-MR0000-Libera-20120412-  Modification for NEC GUI customization*/
//		OK_MSG1(SET_PIN_MSG, submitUrl);
		sprintf(breadcrumb,"WPS(PIN)->WPS(PIN)");
		sprintf(title,"WPS(PIN)");
		sprintf(explain,"WPS(PIN)򥹥Ȥޤ<br><br>2ʬWi-FiüWPS¹ԤƤ");

#if 1	/* WNC-MR0000-Libera-20120523-  spec. 1.6.0 redirect to top page*/
	//	int opmode;
	//	apmib_get( MIB_OP_MODE, (void *)&opmode);
			if (opmode == GATEWAY_MODE) {
				OK_MSG_NEC(breadcrumb, title, explain, lan_ip, "home_detail.htm");
			} else if (opmode == BRIDGE_MODE) {
				/* WNC-NMR0000-JOE-PENG-20140430-Modify 4.1 structure of page according to Linear Spec-start */
				//OK_MSG_NEC(breadcrumb, title, explain, lan_ip, "home_detail_bridge.htm");
				/* WNC-NMR0000-JOE-PENG-20140521-Modify codes of boa detecting system mode (Gateway/Bridge/Converter/Repeater)-start */
				int wifi_mode=WIFI_MODE_AP;
				
				if (lw_get_wifi_mode(&wifi_mode) == 1) {
					switch (wifi_mode) {
						case WIFI_MODE_AP:
							OK_MSG_NEC(breadcrumb, title, explain, lan_ip, "home_detail_bridge.htm");
							break;
						case WIFI_MODE_CLIENT:
							OK_MSG_NEC(breadcrumb, title, explain, lan_ip, "home_detail_converter.htm");
							break;
						case WIFI_MODE_REPEATER:
							OK_MSG_NEC(breadcrumb, title, explain, lan_ip, "home_detail_repeater.htm");
							break;
						default:
							OK_MSG_NEC(breadcrumb, title, explain, lan_ip, "home_detail_bridge.htm");
							break;
					}	
				} else {
					OK_MSG_NEC(breadcrumb, title, explain, lan_ip, "home_detail_bridge.htm");
				}
				/* WNC-NMR0000-JOE-PENG-20140521-Modify codes of boa detecting system mode (Gateway/Bridge/Converter/Repeater)-end */
				/* WNC-NMR0000-JOE-PENG-20140430-Modify 4.1 structure of page according to Linear Spec-end */
			} else {
				OK_MSG_NEC(breadcrumb, title, explain, lan_ip, "index.htm");
			}
#endif

		/* WNC-MR0000-JOE-PENG-20120522-Modification for specification 1.6 */
//		OK_MSG_NEC(breadcrumb,title,explain,lan_ip,"index.htm");
#endif

			return;
		}
	}

#if 0	/* WNC-MR2278-Libera-20170215-reject system command from fake POST*/
#if defined(UNIVERSAL_REPEATER) && defined(CONFIG_REPEATER_WPS_SUPPORT)
	strVal = req_get_cstream_var(wp, ("setRptPIN"), "");
	if (strVal[0]) {		
		strVal = req_get_cstream_var(wp, ("peerRptPin"), "");
		if (strVal[0]) {
			apmib_get(MIB_WLAN_WSC_DISABLE, (void *)&intVal);
			if (intVal) {
				intVal = 0;
				apmib_set(MIB_WLAN_WSC_DISABLE, (void *)&intVal);
				apmib_update_web(CURRENT_SETTING);	

				sprintf(tmpbuf, "echo %s > /var/wps_peer_pin", strVal);
				system(tmpbuf);

#ifndef NO_ACTION
				run_init_script("bridge");
#endif					
			}
			else {			
#ifndef NO_ACTION
				sprintf(tmpbuf, "iwpriv wlan%d-vxd set_mib pin=%s", wlan_idx, strVal);
				system(tmpbuf);
#endif
			}
			OK_MSG1(SET_PIN_MSG, submitUrl);			
			return;
		}
	}
#endif //#if defined(UNIVERSAL_REPEATER) && defined(CONFIG_REPEATER_WPS_SUPPORT)
#endif

	strVal = req_get_cstream_var(wp, ("disableWPS"), "");
	if ( !strcmp(strVal, "ON")){
		/* WNC-NMR2289-[Rafale]-Libera-20170220-request: WPS PIN enable/disable-start */
		//intVal = 1;	//wsc disable
		intVal = 2;	//PIN disable
		/* WNC-NMR2289-[Rafale]-Libera-20170220-request: WPS PIN enable/disable-end */
#if 0		/* WNC-NMR2289-[Rafale]-Libera-20170220-request: WPS PIN enable/disable-- */
		/* WNC-MR561-[Voyager]-Libera-20140218- SPEC.1.5 Change the reboot and config method -Start */
		int wscEr=0;
		strVal = req_get_cstream_var(wp, ("wscER_h"), "");
		if(strVal[0] && strVal[0]=='2')
			wscEr=2;
		else
			wscEr=0;
		apmib_set(MIB_WLAN_WSC_CFG_BY_EXREG_DISABLE, (void *)&wscEr);
		/* WNC-MR561-[Voyager]-Libera-20140218- SPEC.1.5 Change the reboot and config method -End */
#endif		
	}else{
		
		/* WNC-NMR2289-[Rafale]-Libera-20170220-request: WPS PIN enable/disable-start */
		//intVal = 0;	//wsc enable
		intVal = 3;	//PIN enable
		/* WNC-NMR2289-[Rafale]-Libera-20170220-request: WPS PIN enable/disable-end */		
	}
	// 1104
	//sprintf(ifname,"wlan%d",wlan_idx);
	snprintf(ifname, sizeof(ifname), "wlan%d", wlan_idx);	//2426
	SetWlan_idx(ifname);
	

#if 1		/* WNC-NMR2289-[Rafale]-Libera-20170220-request: WPS PIN enable/disable */
	apmib_set(MIB_WLAN_WSC_METHOD, (void *)&intVal);	
	updateVapWscMethod(wlan_idx,intVal);
#else	// WPS enable/disable

	apmib_set(MIB_WLAN_WSC_DISABLE, (void *)&intVal);
	updateVapWscDisable(wlan_idx, intVal);
#endif
	strVal = req_get_cstream_var(wp, ("localPin"), "");
	if (strVal[0]){

#if 1	/* WNC-MR0000-[Voyager]-Libera-20131216- new MIB for software PIN code of WPS -Start*/		
	if (NUM_WLAN_INTERFACE == 2){	/* WNC-NMR000-[Linear]-Libera-20140502- SPEC.v0.2.0- WPS: for Dual Radios  */
#if defined(FOR_DUAL_BAND)	
		wlan_orig = wlan_idx;
		SetWlan_idx("wlan0");
			apmib_set(MIB_WLAN_WSC_SW_PIN, (void *)strVal);
		SetWlan_idx("wlan1");
			apmib_set(MIB_WLAN_WSC_SW_PIN, (void *)strVal);
		wlan_idx = wlan_orig;
#endif	
/* WNC-NMR000-[Linear]-Libera-20140502- SPEC.v0.2.0- WPS: for Dual Radios -End*/
	}else{
		apmib_set(MIB_WLAN_WSC_SW_PIN, (void *)strVal);
	}
#if 0	/* WNC-NMR000-[Aero/Thalys]-Libera-20160606- responsive GUI porting*/	/* NMR1778-[Aero]-20161014-GUI IOT (win7+chrome) : delete this part*/
	if (submitUrl[0])
		send_redirect_perm(wp, submitUrl);
#endif
		
#else	//HW PIN
		apmib_set(MIB_HW_WSC_PIN, (void *)strVal);
		apmib_update(HW_SETTING);	/* WNC-MR0000-Libera-20120531-fixed pin number save fails */
#endif
	}
//	update_wps_configured(0);
}//End of for loop
	apmib_update_web(CURRENT_SETTING);	// update to flash
	
#ifndef NO_ACTION
	run_init_script("bridge");
#endif

#if 1	/* WNC-NMR000-[Aero/Thalys]-Libera-20160606- responsive GUI porting*/	
	formReboot(wp, path, query);
#else	//other project
	OK_MSG(submitUrl);
#endif
}
////////////////////////////////////////////////////////////////////////
#endif // WIFI_SIMPLE_CONFIG


void formWlanRedirect(request *wp, char *path, char *query)
{
	char *redirectUrl;
	char *strWlanId;
	
        redirectUrl= req_get_cstream_var(wp, ("redirect-url"), "");   // hidden page
        strWlanId= req_get_cstream_var(wp, ("wlan_id"), "");   // hidden page
	if(strWlanId[0]){
		wlan_idx = atoi(strWlanId);
		sprintf(WLAN_IF, "wlan%d", wlan_idx);
	}
#ifdef MBSSID	
	mssid_idx = 0;
#endif
        if (redirectUrl[0])
                send_redirect_perm(wp,redirectUrl);
}

void formWlanRedirect2(request *wp, char *redirectUrl, char *strWlanId)
{
	if(strWlanId){
		wlan_idx = atoi(strWlanId);
		sprintf(WLAN_IF, "wlan%d", wlan_idx);
	}
#ifdef MBSSID	
	mssid_idx = 0;
#endif
        if (redirectUrl)
                send_redirect_perm(wp,redirectUrl);
}

#ifdef CONFIG_RTL_WAPI_SUPPORT
void formWapiReKey(request *wp, char * path, char * query)
{
	char *webpage, *strVal;
	char tmpBuf[200];
	int val;
	int mPolicy,policy;
	/*get Mcast Ucast*/
	webpage=req_get_cstream_var(wp,("next_webpage"),"");

	strVal=req_get_cstream_var(wp,("KEY_TYPE"),"");
//	printf("KEY_TYPE %s \n",strVal);
	strVal=req_get_cstream_var(wp,("MAC"),"");
//	printf("MAC %s \n",strVal);

	/*1: off  2: time 3: packet 4:time+packet*/
	strVal=req_get_cstream_var(wp,("REKEY_M_POLICY"),"");
	if(strVal)
	{
		mPolicy=strVal[0]-'0';
		if(!apmib_set(MIB_WLAN_WAPI_MCASTREKEY,(void *)&mPolicy))
		{
			strcpy(tmpBuf,"Can not set MCAST key policy!");
			goto setErr_rekey;

		}
//		printf("REKEY_M_POLICY %s \n",strVal);
	}
	
	strVal=req_get_cstream_var(wp,("REKEY_M_TIME"),"");
	if(strVal)
	{
		val=atoi(strVal);
		if(!apmib_set(MIB_WLAN_WAPI_MCAST_TIME,(void *)&val))
		{
			strcpy(tmpBuf,"Can not set MCAST TIME!");
			goto setErr_rekey;
		}
//		printf("REKEY_M_TIME %s \n",strVal);
	}
	
	strVal=req_get_cstream_var(wp,("REKEY_M_PACKET"),"");
	if(strVal)
	{
		val=atoi(strVal);
		if(!apmib_set(MIB_WLAN_WAPI_MCAST_PACKETS,(void *)&val))
		{
			strcpy(tmpBuf,"Can not set MCAST Packet!");
			goto setErr_rekey;
		}
//		printf("REKEY_M_PACKET %s \n",strVal);
	}	
	
	strVal=req_get_cstream_var(wp,("REKEY_POLICY"),"");
	if(strVal)
	{
		policy=strVal[0]-'0';
		if(!apmib_set(MIB_WLAN_WAPI_UCASTREKEY,(void *)&policy))
		{
			strcpy(tmpBuf,"Can not set ucast key policy!");
			goto setErr_rekey;
		}
//		printf("REKEY_POLICY %s \n",strVal);
	}

	strVal=req_get_cstream_var(wp,("REKEY_TIME"),"");
	if(strVal)
	{
		val=atoi(strVal);
		if(!apmib_set(MIB_WLAN_WAPI_UCAST_TIME,(void *)&val))
		{
			strcpy(tmpBuf,"Can not set ucast time!");
			goto setErr_rekey;
		}
//		printf("REKEY_TIME %s \n",strVal);
	}
	
	strVal=req_get_cstream_var(wp,("REKEY_PACKET"),"");
	if(strVal)
	{
		val=atoi(strVal);
		if(!apmib_set(MIB_WLAN_WAPI_UCAST_PACKETS,(void *)&val))
		{
			strcpy(tmpBuf,"Can not set ucast Packet!");
			goto setErr_rekey;
		}
//		printf("REKEY_PACKET %s \n",strVal);
	}
	
	apmib_update_web(CURRENT_SETTING);	// update configuration to flash
#ifndef NO_ACTION
	run_init_script("all");                
#endif
	OK_MSG(webpage);
//	send_redirect_perm(wp, webpage);
	return;
setErr_rekey:
	ERR_MSG(tmpBuf);
}
#define TMP_CERT "/var/tmp/tmp.cert"
#define AP_CERT "/var/myca/ap.cert"	//From local AS
#define CA_CERT "/var/myca/CA.cert"
#define CA4AP_CERT "/var/myca/ca4ap.cert"		//From local AS
#define CERT_START "-----BEGIN CERTIFICATE-----"
#define CERT_END "-----END CERTIFICATE-----"
#define PRIV_KEY_START "-----BEGIN EC PRIVATE KEY-----"
#define PRIV_KEY_END "-----END EC PRIVATE KEY-----"
#define CA_PRIV_KEY	"/var/myca/CA.key"


#define AP_CERT_AS0 "/var/myca/ap_as0.cert"	//From remote AS0
#define CA4AP_CERT_AS0 "/var/myca/ca4ap_as0.cert"		//From remote AS0
#define AP_CERT_AS1 "/var/myca/ap_as1.cert"	//From remote AS1
#define CA4AP_CERT_AS1 "/var/myca/ca4ap_as1.cert"		//From remote AS1

//Add for ASU certificate
#define ASU_CERT "/var/myca/asu.cert"
#define ASU_CERT_AS0 "/var/myca/asu_as0.cert"
#define ASU_CERT_AS1"/var/myca/asu_as1.cert"

#define CERT_VERIFY_RESULT "/var/myca/certVerifyResult"
#define TMP_USER_CERT_DER "/var/tmp/user.der"
#define TMP_CA_CERT_DER     "/var/tmp/ca.der"
#define TMP_CA_CERT_PEM     "/var/tmp/ca.cert"

#define TMP_MSG 				"/var/tmp/msg.txt"			//source data
#define TMP_SIG					"/var/tmp/sig.txt"				//signature(input)
#define TMP_SIG_OUT				"/var/tmp/sig_out.txt"				//signature(output)
#define TMP_SIG_VERIFY_RES		"/var/tmp/sigVerifyRes.txt"		//signature verify result: if this file exist, verify OK; else verify wrong.
//Add for verify CA signature

#if 0  //for debug
static void outPut(unsigned char *buf, int len)
{
	if(buf==NULL || len<1)
	{
		printf("%s:%d invalid!\n", __FUNCTION__,__LINE__);
		return;
	}
	int i;
	for(i=0; i<len; i++)
	{
		if(i!=0 && i%16==0)
			printf("\n");

		printf("%02x ", buf[i]);
	}
	printf("\n");
}
#endif
static int readFile2Str(unsigned char *str, int *strLen, const char *tmpFile)
{
	int fd, ret, toRet;	
	fd=-1;

	if(tmpFile==NULL || str==NULL || strLen==NULL)
	{
		printf("%s(%d)\n",__FUNCTION__,__LINE__);//Added for test
		toRet=-1;
		goto err;
	}
	
	if((fd=open(tmpFile, O_RDONLY))<0)
	{
		printf("open %s error.\n", tmpFile);//Added for test
		toRet=-1;
		goto err;
	}

	if((ret=read(fd, (void *)str, 1200))<0)
	{
		printf("%s(%d),error: read file failed.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=-1;
		goto err;
	}

	*strLen=ret;

	toRet=0;

err:
	if(fd!=-1)
		close(fd);
	
	return toRet;
}

static int storeStr2File(const char * tmpFile, const unsigned char * str, const int strLen)
{
	int fd=-1;
	int ret, toRet;

	if(tmpFile==NULL  || str==NULL)
	{
		printf("%s(%d)\n",__FUNCTION__,__LINE__);//Added for test
		toRet=-1;
		goto err;
	}	
	
	if((fd=open(tmpFile, O_WRONLY | O_CREAT | O_TRUNC))<0)
	{
		printf("open %s error.\n", tmpFile);//Added for test
		toRet=-1;
		goto err;
	}

	ret=write(fd, (void *)str, strLen);
	if((ret==-1)||(ret< strLen))
	{
		printf("%s(%d), error: write file failed.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=-1;
		goto err;
	}

	toRet=0;
err:
	if(fd!=-1)
		close(fd);	
	return toRet;
}

static int verifyMsgSignature(char *msg, int msgLen, char *msgSig, int msgSigLen, char *pubKeyFile, char *verifyOK)
{
	int ret, toRet=-1;
	unsigned char tmpBuf[256];

	* verifyOK=0;//Initial
	
	ret=storeStr2File(TMP_MSG, msg, msgLen);
	if(ret<0)
	{
		printf("%s(%d),storeStr2File failed.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=-1;
		goto err;
	}
	ret=storeStr2File(TMP_SIG, msgSig, msgSigLen);
	if(ret<0)
	{
		printf("%s(%d),storeStr2File failed.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=-1;
		goto err;
	}

	//ecdsatest -verify -m TMP_MSG -s TMP_SIG -k pubKeyFile
	sprintf(tmpBuf, "ecdsatest -verify -m %s -s %s -k %s", TMP_MSG, TMP_SIG, pubKeyFile);
	system(tmpBuf);

	if(isFileExist(TMP_SIG_VERIFY_RES)==1)
	{
		*verifyOK=1;	//signature verify OK
		system("rm -f /var/tmp/sigVerifyRes.txt > /dev/null 2>&1");
		toRet=0;
	}	
err:	
	return toRet;		
}

int verifyCaSignature(char *ca_filename, char *user_filename)
{
	int retval, bufX509CertLen, ret, tempLen, xLen, yLen;
	unsigned char tmpBuf[256], bufX509Cert[1200];
	unsigned char baseCertData[1200], inSignValue[256], certData[1200];
	int getLength=0;
	unsigned short baseCerDataLen=0;
	char verifyRes;
	int offset=0;
	if(isFileExist(ca_filename)!=1)
	{		
		printf("the %s is not exist!\n",ca_filename);
		retval=-1;
		goto check_ERR;
	}
	if(isFileExist(user_filename)!=1)
	{		
		printf("the %s is not exist!\n",user_filename);
		retval=-1;
		goto check_ERR;
	}	
	
	sprintf(tmpBuf, "ecdsatest -pem2der -in %s -out %s", user_filename, TMP_USER_CERT_DER);
	system(tmpBuf);

	ret=readFile2Str(bufX509Cert, &bufX509CertLen, TMP_USER_CERT_DER);

	if(ret<0)
	{
		printf("%s:%d read file %s fails!\n",__FUNCTION__, __LINE__, TMP_USER_CERT_DER);
		retval=-1;
		goto check_ERR;
	}

//	printf("############%s:%d User Cert:\n", __FUNCTION__,__LINE__);
//	outPut(bufX509Cert, bufX509CertLen);	
//	printf("##################\n");
	
	//skip first length
	getLength++;
	if((bufX509Cert[getLength] & 0x80) == 0x80)
		tempLen = (bufX509Cert[getLength] & 0x7f);
	else
		tempLen = bufX509Cert[getLength];

	getLength += 1 + tempLen;

	//get second length
	getLength++;
	if((bufX509Cert[getLength] & 0x80) == 0x80)
		tempLen = bufX509Cert[getLength] & 0x7f;
	else
		tempLen = bufX509Cert[getLength];

	memcpy(&baseCerDataLen, bufX509Cert+getLength+1, tempLen);
	getLength += 1 + tempLen;
	
	memcpy(baseCertData, bufX509Cert+4, baseCerDataLen+4);
	
//	printf("############%s:%d baseCertData:\n", __FUNCTION__,__LINE__);
//	outPut(baseCertData, baseCerDataLen+4);
//	printf("#######################\n");
	
	//skip base Cert field 
	getLength+=baseCerDataLen;

	//skip signAlg field
	getLength++;
	tempLen=bufX509Cert[getLength];
//	printf("\n tempLen=%d\n", tempLen);
	getLength+=1+tempLen;

	//get X signature value
	getLength+=6;
	xLen=tempLen=bufX509Cert[getLength];
	if(xLen==0x19 && bufX509Cert[getLength+1]==0)
	{
		offset=1;
		xLen-=offset;
	}

//	printf("\n xLen=%d\n", xLen);
	
	memcpy(inSignValue, bufX509Cert+getLength+1+offset, xLen);
	getLength+=1+tempLen;

	//get Y signature value 
	getLength++;
	yLen=tempLen=bufX509Cert[getLength];
	if(yLen==0x19 && bufX509Cert[getLength+1]==0)
	{
		offset=1;
		yLen-=offset;
	}
	
//	printf("\n yLen=%d\n", yLen);	
	memcpy(inSignValue+xLen, bufX509Cert+getLength+1+offset, yLen);

//	printf("############%s:%d inSignValue:\n", __FUNCTION__,__LINE__);
//	outPut(inSignValue, xLen+yLen);
//	printf("#######################\n");
	
	ret=verifyMsgSignature(baseCertData, baseCerDataLen+4, inSignValue, xLen+yLen, ca_filename, &verifyRes);
	if(ret<0  || verifyRes!=1) 
	{
		printf("%s(%d),signMsg failed!\n",__FUNCTION__,__LINE__);
		retval=-1;
		goto check_ERR;
	}		
	retval=0;
	
check_ERR:
	return retval;	
}
void formUploadWapiCert(request *wp, char * path, char * query)	// Only for Local AS
{
	/*save asu and user cert*/
	char *submitUrl,*strVal,*CertStart;
	unsigned int CertLength=0;
	char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};
	char cmd[128];
	FILE *fp;
	int check_res;
	
	int val =0;
	char * auth_mode;	
	
	auth_mode = req_get_cstream_var_in_mime(wp, ("auth_mode"), "",NULL);
	submitUrl = req_get_cstream_var_in_mime(wp, ("submit-url"), "",NULL);   // hidden page
	strVal = req_get_cstream_var_in_mime(wp, ("uploadcerttype"), "",NULL);

	int cert_sel=1;
	apmib_set(MIB_WLAN_WAPI_CERT_SEL, (void*)&cert_sel);
	if(!strcmp(auth_mode,"three_certification"))
	{
	//printf("val =3\n");
		val =3;		
	}else
	{
	//printf("val =2\n");
		val =2;
	}
	if(!apmib_set(MIB_WLAN_WAPI_AUTH_MODE_2or3_CERT,(void*)&val))
	{
			strcpy(tmpBuf, "Set Search MIB Index Error!");
			goto upload_ERR;
	}
	if(NULL == strstr(wp->upload_data,CERT_START) || NULL ==strstr(wp->upload_data,CERT_END))
	{
		strcpy(tmpBuf,"Not a Cert File!");
		goto upload_ERR;
	}
	fp=fopen(TMP_CERT,"w");
	if(NULL == fp)
	{
		strcpy(tmpBuf,"Can not open tmp cert!");
		goto upload_ERR;
	}
	else
	{
		if(!strcmp(strVal,"ca"))
		{
			CertStart = req_get_cstream_var_in_mime(wp,("ca_binary"),"",&CertLength);
		}else
		if(!strcmp(strVal,"user"))
		{
			CertStart = req_get_cstream_var_in_mime(wp,("user_binary"),"",&CertLength);
		}else
		if(!strcmp(strVal,"asu"))
		{
			CertStart = req_get_cstream_var_in_mime(wp,("asu_binary"),"",&CertLength);
		}else
		{
			strcpy(tmpBuf,"Unknown Cert File!");
			goto upload_ERR;
		}
		fwrite(CertStart,CertLength,0x1,fp);
		fclose(fp);
		strcpy(cmd,"cp ");
		strcat(cmd,TMP_CERT);
		strcat(cmd," ");
		if(!strcmp(strVal,"user"))
		{
			strcat(cmd,AP_CERT);
			system(cmd);
			if(val==3)
			{
				check_res=verifyCaSignature(CA4AP_CERT,AP_CERT);	
				if(check_res<0)
				{
					sprintf(tmpBuf,"Maybe this cert is valid! First, make sure you have installed CA cert; Second, try to install this cert three times!");//Added for test
					system("rm -f /var/myca/ap.cert"); //rm AP_CERT
					goto upload_ERR;
				}
			}
			system("storeWapiFiles -apCert");
//			system("storeWapiFiles -oneUser");
		}else
		if(!strcmp(strVal,"asu"))
		{
		//	strcat(cmd,CA_CERT);
		//	system(cmd);
		//	system("storeWapiFiles -caCert");
		
		//	strcat(cmd,CA4AP_CERT);
			strcat(cmd,ASU_CERT);
			system(cmd);

			//Add for check asu certificate
			if(val==3)
			{
				check_res=verifyCaSignature(CA4AP_CERT,ASU_CERT);
				if(check_res<0)
				{
					sprintf(tmpBuf,"Maybe this cert is valid! First, make sure you have installed CA cert; Second, try to install this cert three times!");//Added for test
					system("rm -f /var/myca/asu.cert"); //rm AP_CERT
					goto upload_ERR;
				}
			}
			
			system("storeWapiFiles -asuCert");
		}
		if(!strcmp(strVal,"ca"))
		{
			strcat(cmd,CA4AP_CERT);
			system(cmd);
			system("storeWapiFiles -ca4apCert");
			if(val==2)
			{
				/*if local as .copy private key for ASU*/
				sprintf(tmpBuf,"cp %s %s ; cat %s >> %s",CA4AP_CERT,ASU_CERT,CA_PRIV_KEY,ASU_CERT);
 				//sprintf(tmpBuf,"cp %s %s",CA4AP_CERT,ASU_CERT);

				system(tmpBuf);			
				
				system("storeWapiFiles -asuCert");
			}
			//system("storeWapiFiles -caCertAS0");
		}		
	}
	/*check if user or asu cerification*/
	strcpy(tmpBuf,"Cerification Install Success!");
	OK_MSG1(tmpBuf, submitUrl);
	return;
upload_ERR:
	ERR_MSG(tmpBuf);
}

void formUploadWapiCertAS0(request *wp, char * path, char * query)	// Only for Remote AS0
{
		/*save asu and user cert*/
	char *submitUrl,*strVal,*CertStart;
	unsigned int CertLength=0;
	char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};
	char cmd[128];
	FILE *fp;
	int check_res;
	
	int val =0;
	char * auth_mode;	
	
	auth_mode = req_get_cstream_var_in_mime(wp, ("auth_mode"), "",NULL);
	submitUrl = req_get_cstream_var_in_mime(wp, ("submit-url"), "",NULL);   // hidden page
	strVal = req_get_cstream_var_in_mime(wp, ("uploadcerttype"), "",NULL);

	int cert_sel=0;
	apmib_set(MIB_WLAN_WAPI_CERT_SEL, (void*)&cert_sel);	
	if(!strcmp(auth_mode,"three_certification"))
	{
	//printf("val =3\n");
		val =3;		
	}else
	{
	//printf("val =2\n");
		val =2;
	}
	if(!apmib_set(MIB_WLAN_WAPI_AUTH_MODE_2or3_CERT,(void*)&val))
	{
			strcpy(tmpBuf, "Set Search MIB Index Error!");
			goto upload_ERR;
	}
	if(NULL == strstr(wp->upload_data,CERT_START) || NULL ==strstr(wp->upload_data,CERT_END))
	{
		strcpy(tmpBuf,"Not a Cert File!");
		goto upload_ERR;
	}
	fp=fopen(TMP_CERT,"w");
	if(NULL == fp)
	{
		strcpy(tmpBuf,"Can not open tmp cert!");
		goto upload_ERR;
	}
	else
	{
		if(!strcmp(strVal,"ca"))
		{
			CertStart = req_get_cstream_var_in_mime(wp,("ca_binary"),"",&CertLength);
		}else
		if(!strcmp(strVal,"user"))
		{
			CertStart = req_get_cstream_var_in_mime(wp,("user_binary"),"",&CertLength);
		}else
		if(!strcmp(strVal,"asu"))
		{
			CertStart = req_get_cstream_var_in_mime(wp,("asu_binary"),"",&CertLength);
		}else
		{
			strcpy(tmpBuf,"Unknown Cert File!");
			goto upload_ERR;
		}		
		fwrite(CertStart,CertLength,0x1,fp);
		fclose(fp);
		strcpy(cmd,"cp ");
		strcat(cmd,TMP_CERT);
		strcat(cmd," ");
		if(!strcmp(strVal,"user"))
		{
			strcat(cmd,AP_CERT_AS0);
			system(cmd);
			if(val==3)
			{
				check_res=verifyCaSignature(CA4AP_CERT_AS0, AP_CERT_AS0);	
				if(check_res<0)
				{
					sprintf(tmpBuf,"Maybe this cert is valid! First, make sure you have installed CA cert; Second, try to install this cert three times!");//Added for test
					system("rm -f /var/myca/ap.cert"); //rm AP_CERT
					goto upload_ERR;
				}
			}
			system("storeWapiFiles -apCertAS0");
//			system("storeWapiFiles -oneUser");
		}else
		if(!strcmp(strVal,"asu"))
		{
			//strcat(cmd,CA4AP_CERT_AS0);
			strcat(cmd, ASU_CERT_AS0);
			system(cmd);
			//system("storeWapiFiles -ca4apCertAS0");
			system("storeWapiFiles -asuCertAS0");
		}
		if(!strcmp(strVal,"ca"))
		{
			strcat(cmd,CA4AP_CERT_AS0);
			//strcat(cmd, CA_CERT_AS0);
			system(cmd);
			system("storeWapiFiles -ca4apCertAS0");
			if(val==2)
			{
//				sprintf(tmpBuf,"cp %s %s ; cat %s >> %s",CA4AP_CERT_AS0,ASU_CERT_AS0,CA_PRIV_KEY,ASU_CERT_AS0);
				sprintf(tmpBuf,"cp %s %s",CA4AP_CERT_AS0,ASU_CERT_AS0);

				system(tmpBuf);
				
				system("storeWapiFiles -asuCertAS0");
			}
			//system("storeWapiFiles -caCertAS0");
		}		
	}
	/*check if user or asu cerification*/
	strcpy(tmpBuf,"Cerification Install Success!");
	OK_MSG1(tmpBuf, submitUrl);
	return;
upload_ERR:
	ERR_MSG(tmpBuf);

}

void formUploadWapiCertAS1(request *wp, char * path, char * query)	// Only for Remote AS1
{
		/*save asu and user cert*/
	char *submitUrl,*strVal,*CertStart;
	unsigned int CertLength=0;
	char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};
	char cmd[128];
	FILE *fp;
	int check_res;
	
	int val =0;
	char * auth_mode;	
	
	auth_mode = req_get_cstream_var_in_mime(wp, ("auth_mode"), "",NULL);
	submitUrl = req_get_cstream_var_in_mime(wp, ("submit-url"), "",NULL);   // hidden page
	strVal = req_get_cstream_var_in_mime(wp, ("uploadcerttype"), "",NULL);

	int cert_sel=0;
	apmib_set(MIB_WLAN_WAPI_CERT_SEL, (void*)&cert_sel);
	if(!strcmp(auth_mode,"three_certification"))
	{
	//printf("val =3\n");
		val =3;		
	}else
	{
	//printf("val =2\n");
		val =2;
	}
	if(!apmib_set(MIB_WLAN_WAPI_AUTH_MODE_2or3_CERT,(void*)&val))
	{
			strcpy(tmpBuf, "Set Search MIB Index Error!");
			goto upload_ERR;
	}
	if(NULL == strstr(wp->upload_data,CERT_START) || NULL ==strstr(wp->upload_data,CERT_END))
	{
		strcpy(tmpBuf,"Not a Cert File!");
		goto upload_ERR;
	}
	fp=fopen(TMP_CERT,"w");
	if(NULL == fp)
	{
		strcpy(tmpBuf,"Can not open tmp cert!");
		goto upload_ERR;
	}
	else
	{
		if(!strcmp(strVal,"ca"))
		{
			CertStart = req_get_cstream_var_in_mime(wp,("ca_binary"),"",&CertLength);
		}else
		if(!strcmp(strVal,"user"))
		{
			CertStart = req_get_cstream_var_in_mime(wp,("user_binary"),"",&CertLength);
		}else
		if(!strcmp(strVal,"asu"))
		{
			CertStart = req_get_cstream_var_in_mime(wp,("asu_binary"),"",&CertLength);
		}else
		{
			strcpy(tmpBuf,"Unknown Cert File!");
			goto upload_ERR;
		}
		fwrite(CertStart,CertLength,0x1,fp);
		fclose(fp);
		strcpy(cmd,"cp ");
		strcat(cmd,TMP_CERT);
		strcat(cmd," ");
		if(!strcmp(strVal,"user"))
		{
			strcat(cmd,AP_CERT_AS1);
			system(cmd);
			
			//Add for check user certificate
			if(val==3)
			{
				check_res=verifyCaSignature(CA4AP_CERT_AS1, AP_CERT_AS1);	
				if(check_res<0)
				{
					sprintf(tmpBuf,"Maybe this cert is valid! First, make sure you have installed CA cert; Second, try to install this cert three times!");//Added for test
					system("rm -f /var/myca/ap.cert"); //rm AP_CERT
					goto upload_ERR;
				}		
			}			
			
			system("storeWapiFiles -apCertAS1");
		}
		if(!strcmp(strVal,"asu"))
		{
			//strcat(cmd,CA4AP_CERT_AS1);
			strcat(cmd,ASU_CERT_AS1);
			system(cmd);
			system("storeWapiFiles -asuCertAS1");
		}
		if(!strcmp(strVal,"ca"))
		{
			strcat(cmd,CA4AP_CERT_AS1);
			//strcat(cmd, CA_CERT_AS0);
			system(cmd);
			system("storeWapiFiles -ca4apCertAS1");

			if(val==2)
			{
//				sprintf(tmpBuf,"cp %s %s ; cat %s >> %s",CA4AP_CERT_AS1,ASU_CERT_AS1,CA_PRIV_KEY,ASU_CERT_AS1);
				sprintf(tmpBuf,"cp %s %s",CA4AP_CERT_AS1,ASU_CERT_AS1);

				system(tmpBuf);
				system("storeWapiFiles -asuCertAS1");
			}				
			//system("storeWapiFiles -caCertAS0");
		}
	}
	/*check if user or asu cerification*/
	strcpy(tmpBuf,"Cerification Install Success!");
	OK_MSG1(tmpBuf, submitUrl);
	return;
upload_ERR:
	ERR_MSG(tmpBuf);

}

char *getCertSerial(char *src, char *val)
{
	int len=0;

	while (*src && *src!=':') {
		*val++ = *src++;
		len++;
	}
	if (len == 0)
		return NULL;

	*val = '\0';

	if (*src==':')
		src++;

	return src;
}
void formWapiCertManagement(request *wp, char * path, char * query)
{
	char *strVal, sn[32], *webpage;
	char tmpBuf[200];
	// 1---revoke  2----unrevoke 3----del  4---active 5---search 6--clearall
	int operation;
	int val=0;
	webpage=req_get_cstream_var(wp,("next_webpage"),"");
	strVal=req_get_cstream_var(wp,("CERT_MNG"),"");
//	printf("CERT_MNG %s\n",strVal);
	/*Search  Revoke*/
	if(strVal)
		operation=strVal[0] -'0';
	else
		return;
	if(1 == operation)
	{
		/*get the serial no  122345:34244:343424:*/
		strVal=req_get_cstream_var(wp,("CERT_SN"),"");
//		printf("strVal=%s\n",strVal);//Added for test

		strVal=getCertSerial(strVal,sn);
		while(strVal)
		{
			/*call revoke API*/
			strcpy(tmpBuf," revokeUserCert.sh ");
			strcat(tmpBuf,sn);

			strVal=getCertSerial(strVal,sn);
			if(strVal!=NULL)
			{
				//There is more serial to revoke
				strcat(tmpBuf," option");
			}
			
//			printf("tmpBuf=%s\n",tmpBuf);//Added for test
			system(tmpBuf);
		}			
	}
	/*search*/
	if(5 == operation)
	{
		/*set search index*/
		strVal=req_get_cstream_var(wp,("SELECT1"),"");
		if(strVal)
		{
			val=strVal[0]-'0';
			if(!apmib_set(MIB_WLAN_WAPI_SEARCHINDEX,(void*)&val))
			{
				strcpy(tmpBuf, ("Set Search Index Error!"));
				goto setErr_cert;
			}
		}
//		printf("SELECT1 %s\n",strVal);
		strVal=req_get_cstream_var(wp,("CERT_INFO"),"");
		if(!apmib_set(MIB_WLAN_WAPI_SEARCHINFO,(void*)strVal))
		{
			strcpy(tmpBuf, ("Set Search Info Error!"));
			goto setErr_cert;
		}
//		printf("CERT_INFO %s\n",strVal);
		/*set search key*/
	}

	if(6 == operation)
	{
		system("initCAFiles.sh");
		val=1;
		apmib_set(MIB_WLAN_WAPI_CA_INIT,(void *)&val);
		
		//Keith add for update current time to MIB
	  
	  //if(time_mode == 0) //Manual Mode
	  { 
	   time_t current_secs;
	   int cur_time;
	   struct tm * tm_time;
	   
	   time(&current_secs);
	   tm_time = localtime(&current_secs);
	   cur_time = tm_time->tm_year+ 1900;
	   apmib_set( MIB_SYSTIME_YEAR, (void *)&cur_time);
	   cur_time = tm_time->tm_mon;
	   apmib_set( MIB_SYSTIME_MON, (void *)&cur_time);
	   cur_time = tm_time->tm_mday;
	   apmib_set( MIB_SYSTIME_DAY, (void *)&cur_time);
	   cur_time = tm_time->tm_hour;
	   apmib_set( MIB_SYSTIME_HOUR, (void *)&cur_time);
	   cur_time = tm_time->tm_min;
	   apmib_set( MIB_SYSTIME_MIN, (void *)&cur_time);
	   cur_time = tm_time->tm_sec;
	   apmib_set( MIB_SYSTIME_SEC, (void *)&cur_time);
	   
	   apmib_update_web(CURRENT_SETTING);
	  }

	}
	/*sync to flash*/
	apmib_update_web(CURRENT_SETTING);	// update configuration to flash

	send_redirect_perm(wp, webpage);
	return;
setErr_cert:
	ERR_MSG(tmpBuf);
}

//Apply Realtek Patch. [CheeperSW:0676]
//extern void log_boaform(char *form);
extern void log_boaform(char *form, request *req);
//Apply Realtek Patch End. [CheeperSW:0676]
#define WAPI_USER_CERT  "/var/myca/user.cert"
void formWapiCertDistribute(request *wp, char * path, char * query)
{
	char *strVal, *strName,*strTime, *webpage, *certSubType;
	int count=0;
	char tmpbuf[200], certNameBuf[128];
	struct stat status;
	int index;
	
	/*only 40 actived cert allowed*/
	CERTS_DB_ENTRY_Tp cert=(CERTS_DB_ENTRY_Tp)malloc(128*sizeof(CERTS_DB_ENTRY_T));
	/*update wapiCertInfo*/
	count=searchWapiCert(cert,5,"0");
	free(cert);
	if(count >= 40)
	{
		ERR_MSG("Too many active certifications. Please revoke unused certifications!");
		return;
	}
	/*generate a cert. Call generate API*/
	strVal=req_get_cstream_var(wp,("cert_type"),"");
//	printf("cert_type %s\n",strVal);
	strName=req_get_cstream_var(wp,("cert_name"),"");
//	printf("cert_name %s\n",strName);
	strcpy(certNameBuf, strName);

	certSubType=req_get_cstream_var(wp,("cert_subtype"),"");
//	printf("cert_subtype %s\n",certSubType);
	index=atoi(certSubType);
	if(index==0)
		strcat(certNameBuf, "@ASU");
	else if(index==1)
		strcat(certNameBuf, "@AE");
	else
		strcat(certNameBuf, "@ASUE");
//	printf("cert_name %s\n",certNameBuf);
	strTime=req_get_cstream_var(wp,("certPeriod"),"");
//	printf("certPeriod %s\n",strTime);
	strVal=req_get_cstream_var(wp,("time_unit"),"");
//	printf("time_unit %s\n",strVal);
	webpage=req_get_cstream_var(wp,("nextwebpage"),"");
//	printf("webpage %s\n",webpage);
	system("rm -f /var/myca/user.cert");
	system("rm -f /web/user.cer");

	/*To generate user.cert*/
	strcpy(tmpbuf,"genUserCert.sh ");
//	strcat(tmpbuf,strName);
	strcat(tmpbuf,certNameBuf); 
	strcat(tmpbuf," ");
	strcat(tmpbuf,strTime);
//	printf("tmpbuf :%s\n",tmpbuf);
	system(tmpbuf);

	sleep(1);
	
	if ( stat(WAPI_USER_CERT, &status) < 0 ) {
		printf("WAPI cert not generated!\n");
	}
	system("cp /var/myca/user.cert /web/user.cer");
	sleep(1);
	
	//Keith add for update current time to MIB
	//if(time_mode == 0) //Manual Mode
	{	
		time_t current_secs;
		int cur_time;
		struct tm * tm_time;
		
		time(&current_secs);
		tm_time = localtime(&current_secs);
		cur_time = tm_time->tm_year+ 1900;
		apmib_set( MIB_SYSTIME_YEAR, (void *)&cur_time);
		cur_time = tm_time->tm_mon;
		apmib_set( MIB_SYSTIME_MON, (void *)&cur_time);
		cur_time = tm_time->tm_mday;
		apmib_set( MIB_SYSTIME_DAY, (void *)&cur_time);
		cur_time = tm_time->tm_hour;
		apmib_set( MIB_SYSTIME_HOUR, (void *)&cur_time);
		cur_time = tm_time->tm_min;
		apmib_set( MIB_SYSTIME_MIN, (void *)&cur_time);
		cur_time = tm_time->tm_sec;
		apmib_set( MIB_SYSTIME_SEC, (void *)&cur_time);
		
		apmib_update_web(CURRENT_SETTING);
	}
	
		
	send_redirect_perm(wp, webpage);
#ifdef CSRF_SECURITY_PATCH
//Apply Realtek Patch. [CheeperSW:0676]
//	log_boaform("formWapiCertDistribute");	//To set formWapiCertDistribute valid at security_tbl
	log_boaform("formWapiCertDistribute", wp);	//To set formWapiCertDistribute valid at security_tbl
//Apply Realtek Patch End. [CheeperSW:0676]
#endif
	return;
}
#endif

#ifdef CONFIG_RTL_802_1X_CLIENT_SUPPORT
#define RS_CERT_START "-----BEGIN CERTIFICATE-----"
#define RS_CERT_END "-----END CERTIFICATE-----"

#define RS_RSA_PRIV_KEY_START "-----BEGIN RSA PRIVATE KEY-----"
#define RS_RSA_PRIV_KEY_END "-----END RSA PRIVATE KEY-----"
#define RS_PRIV_KEY_TIP "PRIVATE KEY-----"



void formUpload8021xUserCert(request *wp, char * path, char * query)
{
	char *submitUrl,*strVal, *deleteAllCerts, *user_certstart,*ca_certstart;
	char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};
	int user_cert_len,ca_cert_len;
	char cmd[256];
	FILE *fp;
	char tryFormChange;
	char line[256];
	unsigned char userKeyPass[MAX_RS_USER_CERT_PASS_LEN+1];
	char certOk, userKeyOk;
	int wlanIdx_5G,wlanIdx_2G,rsBandSel;

	wlanIdx_5G=whichWlanIfIs(PHYBAND_5G);
	wlanIdx_2G=whichWlanIfIs(PHYBAND_2G);
	if(wlan_idx==wlanIdx_5G){
		rsBandSel=PHYBAND_5G;
		if ( !apmib_set(MIB_WLAN_RS_BAND_SEL, (void *)&rsBandSel)) {
			strcpy(tmpBuf, ("Set MIB_WLAN_RS_BAND_SEL error!"));
			goto upload_ERR;
		}
	}
	else if(wlan_idx==wlanIdx_2G){
		rsBandSel=PHYBAND_2G;
		if ( !apmib_set(MIB_WLAN_RS_BAND_SEL, (void *)&rsBandSel)) {
			strcpy(tmpBuf, ("Set MIB_WLAN_RS_BAND_SEL error!"));
			goto upload_ERR;
		}
	}
	else{
		rsBandSel=PHYBAND_OFF;
		if ( !apmib_set(MIB_WLAN_RS_BAND_SEL, (void *)&rsBandSel)) {
			strcpy(tmpBuf, ("Set MIB_WLAN_RS_BAND_SEL error!"));
			goto upload_ERR;
		}
	}

	if((rsBandSel != PHYBAND_5G) && (rsBandSel != PHYBAND_2G)){
		strcpy(tmpBuf, ("Wrong rsBandSel !"));
		goto upload_ERR;
	}
	
	//printf("---%s:%d---sizeof(upload_data)=%d	upload_len=%d\n",__FUNCTION__,__LINE__,wp->upload_data,wp->upload_len);
	
	strVal = req_get_cstream_var_in_mime(wp, ("uploadCertType"), "",NULL);
	submitUrl = req_get_cstream_var_in_mime(wp, ("submit-url"), "",NULL);   // hidden page
	deleteAllCerts = req_get_cstream_var_in_mime(wp, ("delAllCerts"), "",NULL);   // hidden page

	if(deleteAllCerts[0]=='1')
	{
		//To delete all 802.1x certs
		if(rsBandSel == PHYBAND_5G){
			system("rsCert -rst_5g");
			strcpy(tmpBuf,"Delete all 802.1x cerificates of 5GHz success!");
		}
		else{
			system("rsCert -rst_2g");
			strcpy(tmpBuf,"Delete all 802.1x cerificates of 2.4GHz success!");
		}
	}
	else
	{
		//Initial
		tryFormChange=0;
		certOk=0;
		userKeyOk=0;	
	
		if(NULL == strstr(wp->upload_data,RS_CERT_START)|| NULL ==strstr(wp->upload_data,RS_CERT_END))
		{
			//printf("---%s:%d---No 802.1x cert inclued in upload file!\n",__FUNCTION__,__LINE__);
			strcpy(tmpBuf,"No 802.1x cert inclued in upload file!");
			tryFormChange=1;
		}

		if((tryFormChange==0)&&(!strcmp(strVal,"user")))
		{
			//if(NULL == strstr(wp->upload_data,RS_PRIV_KEY_TIP))				
			if((NULL ==strstr(wp->upload_data,RS_RSA_PRIV_KEY_START)) || (NULL ==strstr(wp->upload_data,RS_RSA_PRIV_KEY_END)))
			{			
				//printf("---%s:%d---No 802.1x private key inclued in upload file!\n",__FUNCTION__,__LINE__);
				strcpy(tmpBuf,"No 802.1x private key inclued in upload file!");
				tryFormChange=1;
			}
		}	
		if(!strcmp(strVal,"user"))
		{		
			user_certstart= req_get_cstream_var_in_mime(wp, ("radiusUserCert"), "",&user_cert_len);			
			
			if(tryFormChange==0)
			{
				if(rsBandSel == PHYBAND_5G){
					fp=fopen(RS_USER_CERT_5G,"w");
					if(NULL == fp)
					{
						sprintf(tmpBuf,"Can not open tmp RS cert(%s)!", RS_USER_CERT_5G);
						goto upload_ERR;
					}
				}
				else{
					fp=fopen(RS_USER_CERT_2G,"w");
					if(NULL == fp)
					{
						sprintf(tmpBuf,"Can not open tmp RS cert(%s)!", RS_USER_CERT_2G);
						goto upload_ERR;
					}
				}				 
				fwrite(user_certstart,user_cert_len,0x1,fp);
				
				fclose(fp);
			}
			else
			{
				//To store user cert in tmp file: RS_USER_CERT_TMP
				fp=fopen(RS_USER_CERT_TMP,"w");
				if(NULL == fp)
				{
					sprintf(tmpBuf,"[2] Can not open tmp user cert(%s)!", RS_USER_CERT_TMP);
					goto upload_ERR;
				}
				fwrite(user_certstart,user_cert_len,0x1,fp);	
				fclose(fp);

				// try change user cert form from pfx to pem
				memset(userKeyPass, 0, sizeof(userKeyPass));
				apmib_get( MIB_WLAN_RS_USER_CERT_PASSWD, (void *)userKeyPass);
				if(rsBandSel == PHYBAND_5G){
					sprintf(cmd, "openssl pkcs12 -in %s -nodes -out %s -passin pass:%s", RS_USER_CERT_TMP, RS_USER_CERT_5G, userKeyPass);
				}
				else{
					sprintf(cmd, "openssl pkcs12 -in %s -nodes -out %s -passin pass:%s", RS_USER_CERT_TMP, RS_USER_CERT_2G, userKeyPass);
				}
				system(cmd);
				
				sleep(3); // wait for system(cmd) and avoid to open file failure;

				if(rsBandSel == PHYBAND_5G){
					fp=fopen(RS_USER_CERT_5G,"r");
					if(NULL == fp)
					{
						sprintf(tmpBuf,"[2] Can not open tmp user cert(%s)!Maybe you should upload your user certificate once again", RS_USER_CERT_5G);
						goto upload_ERR;
					}
				}
				else{
					fp=fopen(RS_USER_CERT_2G,"r");
					if(NULL == fp)
					{
						sprintf(tmpBuf,"[2] Can not open tmp user cert(%s)!Maybe you should upload your user certificate once again", RS_USER_CERT_2G);
						goto upload_ERR;
					}
				}
				while (fgets(line, sizeof(line), fp))
				{
					if((NULL != strstr(line,RS_CERT_START) ) || (NULL != strstr(line,RS_CERT_END) ))
						certOk=1;					
					//if(NULL != strstr(line,RS_PRIV_KEY_TIP))					
					if((NULL !=strstr(line,RS_RSA_PRIV_KEY_START)) || (NULL !=strstr(line,RS_RSA_PRIV_KEY_END)))
						userKeyOk=1;

					if((certOk == 1) && (userKeyOk == 1))
						break;
				}

				if((certOk != 1) || (userKeyOk != 1))
				{
					if(rsBandSel == PHYBAND_5G){
						sprintf(cmd, "rm -rf %s", RS_USER_CERT_5G);
					}
					else{
						sprintf(cmd, "rm -rf %s", RS_USER_CERT_2G);
					}
					system(cmd);
					
					sprintf(tmpBuf,"Upload user cert failed. Please make sure: 1) uploaded file in pem or pfx form, 2) uploaded file contain user cert and user key, 3) if any [User Key Password], please set it firstly at [Security] webpage for wlan client mode wpa/wpa2 enterprise.");
					
					if(userKeyOk!=1)
						strcat(tmpBuf, "\n\nPlease check the [User Key Password] is right!\n");
						
					goto upload_ERR;
				}

				fclose(fp);
			}

			//To store 802.1x user cert
			if(rsBandSel == PHYBAND_5G){
				system("rsCert -wrUser_5g");
			}
			else{
				system("rsCert -wrUser_2g");
			}
			strcpy(tmpBuf,"802.1x user cerificate and user key upload success!");
		}
		else if(!strcmp(strVal,"root"))
		{		
			ca_certstart= req_get_cstream_var_in_mime(wp, ("radiusRootCert"), "",&ca_cert_len);

			if(tryFormChange == 0)
			{
				if(rsBandSel == PHYBAND_5G){
					fp=fopen(RS_ROOT_CERT_5G,"w");
					if(NULL == fp)
					{
						sprintf(tmpBuf,"Can not open tmp RS cert(%s)!", RS_ROOT_CERT_5G);
						goto upload_ERR;
					}
				}
				else{
					fp=fopen(RS_ROOT_CERT_2G,"w");
					if(NULL == fp)
					{
						sprintf(tmpBuf,"Can not open tmp RS cert(%s)!", RS_ROOT_CERT_2G);
						goto upload_ERR;
					}
				}
				fwrite(ca_certstart,ca_cert_len,0x1,fp);				
				fclose(fp);
			}
			else
			{
				// To store ca cert in tmp file: RS_ROOT_CERT_TMP
				fp=fopen(RS_ROOT_CERT_TMP,"w");
				if(NULL == fp)
				{
					sprintf(tmpBuf,"Can not open tmp RS cert(%s)!", RS_ROOT_CERT_TMP);
					goto upload_ERR;
				}
				fwrite(ca_certstart,ca_cert_len,0x1,fp);				
				fclose(fp);
				
				// try change ca cert form from der to pem
				if(rsBandSel == PHYBAND_5G){
					sprintf(cmd, "openssl x509 -inform DER -in %s -outform PEM -out %s",RS_ROOT_CERT_TMP,RS_ROOT_CERT_5G);
				}
				else{
					sprintf(cmd, "openssl x509 -inform DER -in %s -outform PEM -out %s",RS_ROOT_CERT_TMP,RS_ROOT_CERT_2G);
				}
				system(cmd);
				
				sleep(3);	// wait for system(cmd) and avoid to open file failure;

				if(rsBandSel == PHYBAND_5G){
					fp=fopen(RS_ROOT_CERT_5G,"r");
					if(NULL == fp)
					{
						sprintf(tmpBuf,"[2] Can not open tmp RS cert(%s)!\nMaybe you should upload your root certificate once again!", RS_ROOT_CERT_5G);
						goto upload_ERR;
					}
				}
				else{
					fp=fopen(RS_ROOT_CERT_2G,"r");
					if(NULL == fp)
					{
						sprintf(tmpBuf,"[2] Can not open tmp RS cert(%s)!\nMaybe you should upload your root certificate once again!", RS_ROOT_CERT_2G);
						goto upload_ERR;
					}
				}

				while (fgets(line, sizeof(line), fp))
				{
					if((NULL != strstr(line,RS_CERT_START) ) || (NULL != strstr(line,RS_CERT_END) ))
					{
						certOk=1;
						break;
					}
				}

				if(certOk != 1)
				{
					if(rsBandSel == PHYBAND_5G){
						sprintf(cmd, "rm -rf %s", RS_ROOT_CERT_5G);
					}
					else{
						sprintf(cmd, "rm -rf %s", RS_ROOT_CERT_2G);
					}
					system(cmd);
					
					strcpy(tmpBuf,"[2] No 802.1x cert inclued in upload file!");
					goto upload_ERR;
				}
				
				fclose(fp);
			}

			//To store 802.1x root cert
			if(rsBandSel == PHYBAND_5G){
				system("rsCert -wrRoot_5g");
			}
			else{
				system("rsCert -wrRoot_2g");
			}
			strcpy(tmpBuf,"802.1x root cerificate upload success!");
		}
		else
		{
			sprintf(tmpBuf,"Upload cert type(%s) is not supported!", strVal);
			goto upload_ERR;
		}
	}
	
	OK_MSG1(tmpBuf, submitUrl);
	return;
	
upload_ERR:
	if(fp != NULL)
		fclose(fp);
	
	ERR_MSG(tmpBuf);
}
#endif


#ifdef TLS_CLIENT
#define MAXFNAME	60
#undef WEB_PAGE_OFFSET
#define WEB_PAGE_OFFSET 0x10000

//#define DWORD_SWAP(v) (v)
//#define WORD_SWAP(v) (v)
#define __PACK__	__attribute__ ((packed))
char *tag="CERT";
/////////////////////////////////////////////////////////////////////////////
static int compress(char *inFile, char *outFile)
{
	char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};

	//sprintf(tmpBuf, "bzip2 -9 -c %s > %s", inFile, outFile);
	sprintf(tmpBuf, "cat %s > %s", inFile, outFile);
	system(tmpBuf);
	return 0;
}

//////////////////////////////////////////////////////////////////////////////
#if 0
static unsigned char CHECKSUM(unsigned char *data, int len)
{
	int i;
	unsigned char sum=0;

	for (i=0; i<len; i++)
		sum += data[i];

	sum = ~sum + 1;
	return sum;
}
#endif

/////////////////////////////////////////////////////////////////////////////
#if 0
static int lookfor_cert_dir(FILE *lp, char *dirpath, int is_for_web)
{
	char file[MAXFNAME];
	char *p;
	struct stat sbuf;

	fseek(lp, 0L, SEEK_SET);
	dirpath[0] = '\0';

	while (fgets(file, sizeof(file), lp) != NULL) {
		if ((p = strchr(file, '\n')) || (p = strchr(file, '\r'))) {
			*p = '\0';
		}
		if (*file == '\0') {
			continue;
		}
		if (stat(file, &sbuf) == 0 && sbuf.st_mode & S_IFDIR) {
			continue;
		}
		if (is_for_web)
			p=strstr(file, "home.htm");

		else
			p=strrchr(file, '/');
		if (p) {

			*p = '\0';
			strcpy(dirpath, file);
// for debug
//printf("Found dir=%s\n", dirpath);
			return 0;
		}
	}
	//printf("error\n");
	return -1;
}
#endif
/////////////////////////////////////////////////////////////////////////////
static void strip_dirpath(char *file, char *dirpath)
{
	char *p, tmpBuf[MAXFNAME];

	if ((p=strstr(file, dirpath))) {
		strcpy(tmpBuf, &p[strlen(dirpath)]);
		strcpy(file, tmpBuf);
	}
// for debug
//printf("adding file %s\n", file);
}
int makeCertImage(char *outFile, char *fileList)
{
	int fh;
	struct stat sbuf;
	FILE *lp;
	char file[MAXFNAME];
	char tmpFile[100], dirpath[100];
	char buf[512];
	FILE_ENTRY_T entry;
	unsigned char	*p;
	int i, len, fd, nFile, pad=0;
	IMG_HEADER_T head;
	char *tmpFile1 = "/var/tmp/cert" ;
	
	fh = open(tmpFile1, O_RDWR|O_CREAT|O_TRUNC);
	if (fh == -1) {
		printf("Create output file error %s!\n", tmpFile1);
		return 0;
	}
	lseek(fh, 0L, SEEK_SET);

	if ((lp = fopen(fileList, "r")) == NULL) {
		printf("Can't open file list %s\n!", fileList);
		return 0;
	}
#if 0	
	if (lookfor_cert_dir(lp, dirpath, 0)<0) {
		printf("Can't find cert dir\n");
		fclose(lp);
		return 0;
	}
#else
	strcpy(dirpath, "/etc/1x");
#endif	
	fseek(lp, 0L, SEEK_SET);
	nFile = 0;
	while (fgets(file, sizeof(file), lp) != NULL) {
		if ((p = strchr(file, '\n')) || (p = strchr(file, '\r'))) {
			*p = '\0';
		}
		if (*file == '\0') {
			continue;
		}
		if (stat(file, &sbuf) == 0 && sbuf.st_mode & S_IFDIR) {
			continue;
		}

		if ((fd = open(file, O_RDONLY)) < 0) {
			printf("Can't open file %s\n", file);
			exit(1);
		}
		lseek(fd, 0L, SEEK_SET);

		strip_dirpath(file, dirpath);

		strcpy(entry.name, file);
//#ifndef __mips__	
		entry.size = DWORD_SWAP(sbuf.st_size);
//#else		
		//entry.size = (sbuf.st_size);
//#endif		

		if ( write(fh, (const void *)&entry, sizeof(entry))!=sizeof(entry) ) {
			printf("Write file failed!\n");
			return 0;
		}

		i = 0;
		while ((len = read(fd, buf, sizeof(buf))) > 0) {
			if ( write(fh, (const void *)buf, len)!=len ) {
				printf("Write file failed!\n");
				exit(1);
			}
			i += len;
		}
		close(fd);
		if ( i != sbuf.st_size ) {
			printf("Size mismatch in file %s!\n", file );
		}

		nFile++;
	}

	fclose(lp);
	close(fh);
	sync();

// for debug -------------
#if 0
sprintf(tmpFile, "cp %s web.lst -f", outFile);
system(tmpFile);
#endif
//-------------------------

	sprintf(tmpFile, "%sXXXXXX",  tmpFile1);
	mkstemp(tmpFile);

	if ( compress(tmpFile1, tmpFile) < 0) {
		printf("compress file error!\n");
		return 0;
	}

	// append header
	if (stat(tmpFile, &sbuf) != 0) {
		printf("Create file error!\n");
		return 0;
	}
	if((sbuf.st_size+1)%2)
		pad = 1;
	p = malloc(sbuf.st_size + 1 + pad);
	memset(p, 0 , sbuf.st_size + 1);
	if ( p == NULL ) {
		printf("allocate buffer failed!\n");
		return 0;
	}

	memcpy(head.signature, tag, 4);
	head.len = sbuf.st_size + 1 + pad;
//#ifndef __mips__	
	head.len = DWORD_SWAP(head.len);
	head.startAddr = DWORD_SWAP(WEB_PAGE_OFFSET);
	head.burnAddr = DWORD_SWAP(WEB_PAGE_OFFSET);
//#else
	//head.len = (head.len);
	//head.startAddr = (WEB_PAGE_OFFSET);
	//head.burnAddr = (WEB_PAGE_OFFSET);
//#endif		

	if ((fd = open(tmpFile, O_RDONLY)) < 0) {
		printf("Can't open file %s\n", tmpFile);
		return 0;
	}
	lseek(fd, 0L, SEEK_SET);
	if ( read(fd, p, sbuf.st_size) != sbuf.st_size ) {
		printf("read file error!\n");
		return 0;;
	}
	close(fd);

	p[sbuf.st_size + pad] = CHECKSUM(p, (sbuf.st_size+pad));

	fh = open(outFile, O_RDWR|O_CREAT|O_TRUNC);
	if (fh == -1) {
		printf("Create output file error %s!\n", outFile );
		return 0;
	}
#ifdef __mips__
	lseek(fh, CERT_PAGE_OFFSET , SEEK_SET);
#endif
	if ( write(fh, &head, sizeof(head)) != sizeof(head)) {
		printf("write header failed!\n");
		return 0;
	}

	if ( write(fh, p, (sbuf.st_size+1+pad) ) != (sbuf.st_size+1+pad)) {
		printf("write data failed!\n");
		return 0;
	}

	close(fh);
	chmod(outFile,  DEFFILEMODE);

	sync();

	free(p);
	unlink(tmpFile);

	return 0;
}


#define CERT_PATH "/etc/1x/"
void formCertUpload(request *wp, char * path, char * query)
{
    FILE *       fp;
    int          numWrite;
    char tmpBuf[200];
    int intVal, entryNum, i=0, add_entry=0, update_image=1;
    char *submitUrl, *strVal, *loadroot, *name, *loaduser, *strDelRoot, 
    		*strDelAllRoot,*strDelUser, *strDelAllUser, *strSelectCa;
    char fileName[50];
    int num_id, get_id, add_id, del_id, delall_id, max_num,index_id;
    CERTROOT_T rootEntry;
    CERTUSER_T userEntry;
    void *pEntry;

     	submitUrl = req_get_cstream_var(wp, ("url"), "");   // hidden page
     	loadroot =  req_get_cstream_var(wp, ("loadroot"), ""); 
     	loaduser =  req_get_cstream_var(wp, ("loaduser"), ""); 
     	name =  req_get_cstream_var(wp, ("name"), "");
     	strDelRoot =   req_get_cstream_var(wp, ("deleteSelRoot"), "");
     	strDelAllRoot =   req_get_cstream_var(wp, ("deleteAllRoot"), "");
	strDelUser =   req_get_cstream_var(wp, ("deleteSelUser"), "");
     	strDelAllUser =   req_get_cstream_var(wp, ("deleteAllUser"), "");     	
     	strSelectCa =   req_get_cstream_var(wp, ("selectca"), ""); 
     	memset(&rootEntry, '\0', sizeof(rootEntry));
     	
     	if(loadroot[0] || strDelRoot[0] || strDelAllRoot[0] || strSelectCa[0]){
		num_id = MIB_CERTROOT_TBL_NUM;
		max_num = MAX_CERTROOT_NUM;
		add_id = MIB_CERTROOT_ADD;
		del_id = MIB_CERTROOT_DEL ;
		delall_id = MIB_CERTROOT_DELALL ;
		get_id = MIB_CERTROOT_TBL ;
		index_id = MIB_ROOT_IDX;
		memset(&rootEntry, '\0', sizeof(rootEntry));
		pEntry = (void *) & rootEntry ;
			
	}
	else if(loaduser[0] || strDelUser[0] || strDelAllUser[0]){
		num_id = MIB_CERTUSER_TBL_NUM;
		max_num = MAX_CERTUSER_NUM;
		add_id = MIB_CERTUSER_ADD;
		del_id = MIB_CERTUSER_DEL ;
		delall_id = MIB_CERTUSER_DELALL ;
		get_id = MIB_CERTUSER_TBL ;
		index_id = MIB_USER_IDX;
		memset(&userEntry, '\0', sizeof(userEntry));
		pEntry = (void *) & userEntry ;
	}
	else{
		strcpy(tmpBuf, "error handle\n");
		goto  ret_upload;
	}

	if(strSelectCa[0]){ //set ca index
		
		strVal = req_get_cstream_var(wp, "rootSelect", "");
		if ( !apmib_get(MIB_CERTROOT_TBL_NUM, (void *)&entryNum)) {
				strcpy(tmpBuf, ("Get entry number error!"));
				goto ret_upload;
		}
		if ( strVal[0] ) {
			intVal =  atoi(strVal) ;
			if ( !apmib_set(MIB_ROOT_IDX, (void *)&intVal)) {
				strcpy(tmpBuf, ("Set CA select error!"));
				goto ret_upload;
			}
			if( intVal <= entryNum){
				pEntry = (void *) &rootEntry ;
				*((char *)pEntry) = (char)intVal;
				if ( !apmib_get(MIB_CERTROOT_TBL, (void *)pEntry)){
					sprintf(tmpBuf, "Get Mib Root CA  entry %d error\n", intVal);
					goto ret_upload;      
				}
			}
			else{
					sprintf(tmpBuf, "invalid Root CA entry %d select\n",intVal );
					goto ret_upload;      
			}
		}
		strVal = req_get_cstream_var(wp, "userSelect", "");
		if ( !apmib_get(MIB_CERTUSER_TBL_NUM, (void *)&entryNum)) {
				strcpy(tmpBuf, ("Get entry number error!"));
				goto ret_upload;
		}
		if ( strVal[0] ) {
			intVal =  atoi(strVal) ;
			if ( !apmib_set(MIB_USER_IDX, (void *)&intVal)) {
				strcpy(tmpBuf, ("Set User select error!"));
				goto ret_upload;
			}
			if( intVal <= entryNum){
				pEntry = (void *) &userEntry ;
				*((char *)pEntry) = (char)intVal;
				if ( !apmib_get(MIB_CERTUSER_TBL, (void *)pEntry)){
					sprintf(tmpBuf, "Get Mib User entry entry %d error\n",i );
					goto ret_upload;      
				}
			}
			else{
					sprintf(tmpBuf, "invalid User entry select %d\n", i);
					goto ret_upload;      
			}
		}	
#if 0
		//printf(" ca files %s %s\n", rootEntry.comment, userEntry.comment); //for debug
		sprintf(tmpBuf, "openssl pkcs12 -des3 -in /etc/1x/%s.pfx -out /etc/1x/user.pem   -passout pass:realtek -passin pass:realtek", userEntry.comment);
		system(tmpBuf);
		sprintf(tmpBuf, "openssl x509 -inform PEM -outform DER -in /etc/1x/user.pem -out /etc/1x/user.der");
		system(tmpBuf);
		sprintf(tmpBuf, "openssl x509 -inform DER -in /etc/1x/%s.cer -outform PEM -out /etc/1x/root.pem", rootEntry.comment);
		system(tmpBuf);
#endif
		update_image=0;
	}
	
     	if(loadroot[0] || loaduser[0]){		//Add entry
		// get entry number to see if it exceeds max
		
		if ( !apmib_get(num_id, (void *)&intVal)) {
				strcpy(tmpBuf, ("Get entry number error!"));
				goto ret_upload;
		}
		if ( (intVal + 1) > max_num) {
			strcpy(tmpBuf, ("Cannot add new entry because table is full!"));
			goto ret_upload;
		}     		
		if(wp->post_data_len == 0){
			strcpy(tmpBuf, ("Error ! Upload file length is 0 !"));
			goto  ret_upload;
		 }
		 
		 for(i=1 ; i <= intVal ; i++) //check the duplicate entry
		 {
		 	*((char *)pEntry) = (char)i;
			if ( !apmib_get(get_id, (void *)pEntry)){
				sprintf(tmpBuf, "Get Mib CA entry %d error\n", i);
				goto ret_upload;      
			}
			if(loadroot[0] && !strcmp(rootEntry.comment,name)){
				sprintf(tmpBuf, "Error! Duplicate Root CA name %s with entry %d\n", name, i);
				goto ret_upload;
			}
			if(loaduser[0] && !strcmp(userEntry.comment,name)){
				sprintf(tmpBuf, "Error! Duplicate User CA name %s with entry %d\n", name, i);
				goto ret_upload;
			}
		 }
		 if(loaduser[0]){
			strVal = req_get_cstream_var(wp, "pass", "");
			if(strVal[0])
				strcpy(userEntry.pass, strVal);
		 }
		 if(loadroot[0]){
		     	strcpy(fileName, CERT_PATH);
		     	strcat(fileName, name);
			strcat(fileName,".cer");
			strcpy(rootEntry.comment, name);
		 }
		 else{
		     	strcpy(fileName, CERT_PATH);
		     	strcat(fileName, name);
		     	strcat(fileName, ".pfx");
		     	strcpy(userEntry.comment, name);
		 }  
		 if ((fp = fopen(fileName, "w+b")) != NULL) {
			numWrite = fwrite(wp->post_data,1, wp->post_data_len, fp);
			if(numWrite < 0) perror("write error");
			if (numWrite == wp->post_data_len)
				sprintf(tmpBuf, ("Update successfully (size = %d bytes)!<br>"), wp->post_data_len);
			else
				sprintf(tmpBuf, ("Writesize=%d %dbytes."), wp->post_data_len, numWrite);
		 }
		 else {
			sprintf(tmpBuf, ("open file error"));
			goto ret_upload;
		 }
		    	
		fclose(fp);
		if ( apmib_set(add_id, (void *)pEntry) == 0) {
			strcpy(tmpBuf, ("Add table entry error!"));
			goto ret_upload;
		}
		add_entry =1 ;
		
    	}
    	/* Delete entry */
	if (strDelRoot[0] || strDelUser[0]) {
		if ( !apmib_get(num_id, (void *)&entryNum)) {
			strcpy(tmpBuf, ("Get entry number error!"));
			goto ret_upload;
		}

		strVal = req_get_cstream_var(wp, "selectcert", "");
		if ( strVal[0] ) {
			*((char *)pEntry) = atoi(strVal);
			if ( !apmib_get(get_id, (void *)pEntry)) {
				strcpy(tmpBuf, ("Get table entry error!"));
				goto ret_upload;
			}
			if ( !apmib_set(del_id, (void *)pEntry)) {
				strcpy(tmpBuf, ("Delete table entry error!"));
				goto ret_upload;
			}
		}
		if(strDelRoot[0])
			sprintf(tmpBuf, "rm -f %s%s.cer", CERT_PATH, rootEntry.comment);
		else			
			sprintf(tmpBuf, "rm -f %s%s.pfx", CERT_PATH, userEntry.comment);
		
		system(tmpBuf);
	}
	/* Delete all entry */
	if ( strDelAllRoot[0] || strDelAllUser[0]) {
		if ( !apmib_set(delall_id, pEntry)) {
			strcpy(tmpBuf, ("Delete all table error!"));
			goto ret_upload;
		}
		if(strDelAllRoot[0])
			system("rm -f /etc/1x/*.cer");
		else
			system("rm -f /etc/1x/*.pfx");
	}
	apmib_update_web(CURRENT_SETTING);	// update configuration to flash
	if(update_image){
		system("find   /etc/1x/*.pfx  -type f > /var/tmp/cert.list"); 
		system("find   /etc/1x/*.cer  -type f >> /var/tmp/cert.list"); 
#ifdef __mips__
		makeCertImage(FLASH_DEVICE_NAME, "/tmp/cert.list");
#else
		makeCertImage("cert.img", "/var/tmp/cert.list");
#endif
		system("rm -f /var/tmp/cert.list");

	}
#ifndef NO_ACTION
	else
		run_init_script("bridge");
#endif
		
	if(add_entry){
		OK_MSG1(tmpBuf, submitUrl);
	}
	else
	{
		if (submitUrl[0])
			send_redirect_perm(wp, submitUrl);
	}			
    return;

ret_upload:
    ERR_MSG(tmpBuf);
}

int certRootList(request *wp, int argc, char **argv)
{
	int	nBytesSent=0, entryNum, i;
	CERTROOT_T entry;

	if ( !apmib_get(MIB_CERTROOT_TBL_NUM, (void *)&entryNum)) {
  		fprintf(stderr, "Get table entry error!\n");
		return -1;
	}

	nBytesSent += req_format_write(wp, ("<tr class=\"tbl_head\">"
      	"<td align=center width=\"30%%\" ><font size=\"2\"><b>Name</b></font></td>\n"
      	"<td align=center width=\"20%%\" ><font size=\"2\"><b>Select</b></font></td></tr>\n"));

	for (i=1; i<=entryNum; i++) {
		*((char *)&entry) = (char)i;
		if ( !apmib_get(MIB_CERTROOT_TBL, (void *)&entry))
			return -1;

		nBytesSent += req_format_write(wp, ("<tr class=\"tbl_body\">"
			"<td align=center width=\"30%%\" ><font size=\"2\">%s</td>\n"
      			"<td align=center width=\"20%%\" ><input type=\"radio\" name=\"selectcert\" value=\"%d\" onClick=\"selectcaClick(this)\">"
      			"</td></tr>\n"), entry.comment, i);
	}
	return nBytesSent;
}

int certUserList(request *wp, int argc, char **argv)
{
	int	nBytesSent=0, entryNum, i;
	CERTUSER_T entry;

	if ( !apmib_get(MIB_CERTUSER_TBL_NUM, (void *)&entryNum)) {
  		fprintf(stderr, "Get table entry error!\n");
		return -1;
	}

	nBytesSent += req_format_write(wp, ("<tr class=\"tbl_head\">"
      	"<td align=center width=\"30%%\" ><font size=\"2\"><b>Name</b></font></td>\n"
      	"<td align=center width=\"20%%\" ><font size=\"2\"><b>Select</b></font></td></tr>\n"));

	for (i=1; i<=entryNum; i++) {
		*((char *)&entry) = (char)i;
		if ( !apmib_get(MIB_CERTUSER_TBL, (void *)&entry))
			return -1;

		nBytesSent += req_format_write(wp, ("<tr class=\"tbl_body\">"
			"<td align=center width=\"30%%\" ><font size=\"2\">%s</td>\n"
      			"<td align=center width=\"20%%\" ><input type=\"radio\" name=\"selectcert\" value=\"%d\" onClick=\"selectprClick(this)\"></td></tr>\n"), entry.comment, i);
	}
	return nBytesSent;
}
#endif

#if defined(CONFIG_RTL_P2P_SUPPORT)

int getWifiP2PState(request *wp, int argc, char **argv)
{
	int nBytesSent=0, i;
	int intVal;
	P2P_SS_STATUS_Tp pP2PStatus=NULL;
	
	if (pP2PStatus==NULL) {
		pP2PStatus = calloc(1, sizeof(P2P_SS_STATUS_Tp));
		if ( pP2PStatus == NULL ) {
			printf("Allocate buffer failed!\n");
			return 0;
		}
	}
	
    //P2P_DEBUG("wlan_idx=[%d]\n",wlan_idx);	    
	sprintf(WLAN_IF,"wlan%d",wlan_idx);
	if ( getWlP2PStateEvent(WLAN_IF, pP2PStatus) < 0)
	{
		SDEBUG("getWlP2PStateEvent fail\n");
		nBytesSent += req_format_write(wp,("None"));
	}
	else
	{
		unsigned char line_buffer[100]={0};
		
			
		//printf("\r\n p2p_status_event=[%d|%d|%d],__[%s-%u]\r\n",
		//pP2PStatus->p2p_status,pP2PStatus->p2p_event,pP2PStatus->p2p_wsc_method,__FILE__,__LINE__);	
		sprintf(line_buffer,"%d|%d|%d|%d|%s",pP2PStatus->p2p_status,pP2PStatus->p2p_event,pP2PStatus->p2p_wsc_method, pP2PStatus->p2p_role);
//printf("\r\n line_buffer=[%s],__[%s-%u]\r\n",line_buffer,__FILE__,__LINE__);		
		nBytesSent += req_format_write(wp,"%s",line_buffer);
	}
	
	if(pP2PStatus)
		free(pP2PStatus);
	
	return nBytesSent;
}



void formWiFiDirect(request *wp, char *path, char *query)
{
	char *submitUrl,*strTmp;
	char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};
	int valTmp;
	int wlanBand2G5GSelect;
	char syscmd[50];
	int needapply = 0;
	
	//displayPostDate(wp->post_data);	
#if 0	
	strTmp= req_get_cstream_var(wp, ("p2p_op_channel"), "");
	if(strTmp[0])
	{
		valTmp = atoi(strTmp);		
		
#if defined(CONFIG_RTL_92D_SUPPORT)		
		apmib_get(MIB_WLAN_BAND2G5G_SELECT,(void *)&wlanBand2G5GSelect);
	
		if(wlanBand2G5GSelect == BANDMODESINGLE)
		{
			int phyBandSelect = PHYBAND_OFF;
			int wlanif;
			
			if(valTmp > 11) // 5g band
			{
				phyBandSelect = PHYBAND_5G;				
			}
			else
			{
				phyBandSelect = PHYBAND_2G;				
			}
						
			wlanif = whichWlanIfIs(phyBandSelect);			
				
			if(wlanif != 0)
			{
				int val;
				val = 1;
				apmib_set(MIB_WLAN_WLAN_DISABLED, (void *)&val); //close original interface
				
				swapWlanMibSetting(0,wlanif);
				
				val = 0;
				apmib_set(MIB_WLAN_WLAN_DISABLED, (void *)&val); //enable after interface							
			}
		}
#endif //#if defined(CONFIG_RTL_92D_SUPPORT)
			
		apmib_set(MIB_WLAN_P2P_OPERATION_CHANNEL, (void *)&valTmp); 				
		sprintf(syscmd,"iwpriv wlan%d p2pcmd opch,%d",wlan_idx,valTmp);
		system(syscmd);
		needapply = 1;
	}
#endif	
	strTmp= req_get_cstream_var(wp, ("p2p_type"), "");
	if(strTmp[0])
	{
		valTmp = atoi(strTmp);
	
		if(valTmp == 0)
			valTmp = P2P_DEVICE;
		else
			valTmp = P2P_TMP_GO;
			
		//apmib_set(MIB_WLAN_P2P_TYPE, (void *)&valTmp);
		if(valTmp == P2P_TMP_GO)
		{
			sprintf(syscmd,"iwpriv wlan%d p2pcmd asgo",wlan_idx );
			//P2P_DEBUG("%s\n",syscmd);
			system(syscmd);
		}
		else
		{
			//apmib_set(MIB_WLAN_SSID, "");
			sprintf(syscmd,"iwpriv wlan%d p2pcmd bakdev",wlan_idx );
			//P2P_DEBUG("%s\n",syscmd);			
			system(syscmd);
		}

		//needapply = 1;		
	}
	
	strTmp= req_get_cstream_var(wp, ("p2p_intent"), "");
	if(strTmp[0])
	{
		valTmp = atoi(strTmp);			
		apmib_set(MIB_WLAN_P2P_INTENT, (void *)&valTmp); 		
		sprintf(syscmd,"iwpriv wlan%d p2pcmd intent,%d",wlan_idx ,valTmp);
		system(syscmd);
		needapply = 1;		
	}
	
	strTmp= req_get_cstream_var(wp, ("p2p_listen_channel"), "");
	if(strTmp[0])
	{
		valTmp = atoi(strTmp);
			
		apmib_set(MIB_WLAN_P2P_LISTEN_CHANNEL, (void *)&valTmp); 
		sprintf(syscmd,"iwpriv wlan%d p2pcmd dwellch,%d",wlan_idx ,valTmp);
		system(syscmd);
		needapply = 1;		
	}
	
	strTmp= req_get_cstream_var(wp, ("dev_name"), "");
	if(strTmp[0])
	{					
		apmib_set(MIB_DEVICE_NAME, (void *)strTmp); 				
		char device_name[64];
		char *space;
		char *p_dev_name = device_name;
		strcpy(device_name,strTmp);
		while(space = strchr(p_dev_name,' '))
		{
			char tmp_name[64];
			strcpy(tmp_name,space);
			strcpy(space+1,tmp_name);
			*space = '\\';
			p_dev_name = space+2;
		}
		sprintf(syscmd,"iwpriv wlan%d p2pcmd devname,%s",wlan_idx ,device_name);
		system(syscmd);
		needapply = 1;		
	}


	if(	needapply == 1){
		sprintf(syscmd,"iwpriv wlan%d p2pcmd apply",wlan_idx );
		system(syscmd);
	}


	
	strTmp= req_get_cstream_var(wp, ("p2p_action"), "");
	if(strTmp[0])
	{
		
		//printf("\r\n action=[%s],__[%s-%u]\r\n",strTmp,__FILE__,__LINE__);
		if(strcmp(strTmp,"p2pBackToDevice") == 0)
		{
			int valTmp = P2P_DEVICE;
			int valTmp2 = 0;
			
			unsigned char ssidstr[33];

			strcpy(ssidstr,"");
		
			apmib_set( MIB_WLAN_P2P_TYPE, (void *)&valTmp);		
			apmib_set( MIB_WLAN_SSID, (void *)ssidstr);
			apmib_set( MIB_WLAN_WPA_PSK, (void *)ssidstr);		
			apmib_set( MIB_WLAN_AUTH_TYPE, (void *)&valTmp2);
			apmib_set( MIB_WLAN_ENCRYPT, (void *)&valTmp2);
			apmib_set( MIB_WLAN_WPA_CIPHER_SUITE, (void *)&valTmp2);
			apmib_set( MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&valTmp2);
			apmib_set( MIB_WLAN_WSC_CONFIGURED, (void *)&valTmp2);		
			apmib_update_web(CURRENT_SETTING);	// update to flash					

			sprintf(syscmd,"iwpriv wlan%d p2pcmd bakdev",wlan_idx );
			//P2P_DEBUG("cmd[%s]\n",syscmd);
			system(syscmd);


		}
		else if(strcmp(strTmp,"p2pWSCSelect") == 0)
		{
			P2P_PROVISION_COMM_T p2pProvisionComm;			
			
			
			strTmp= req_get_cstream_var(wp, ("wscProvsionMethod"), "");
			if(strTmp[0])
			{
				int wscProvsionMethod;
				
				wscProvsionMethod = atoi(strTmp);


				if(wscProvsionMethod == 1) //display
					p2pProvisionComm.wsc_config_method = CONFIG_METHOD_DISPLAY;
				else if(wscProvsionMethod == 2) //keypad
					p2pProvisionComm.wsc_config_method = CONFIG_METHOD_KEYPAD;
				else if(wscProvsionMethod == 4) //pbc
					p2pProvisionComm.wsc_config_method = CONFIG_METHOD_PBC;
			}
			
			strTmp= req_get_cstream_var(wp, ("wscProvsionDevMac"), "");
			if(strTmp[0])
			{	
				if (strlen(strTmp)!=12 || !string_to_hex(strTmp, p2pProvisionComm.dev_address, 12)) 
				{
					strcpy(tmpBuf, ("Error! Invalid MAC address."));
				
				}
				

			}
			
			strTmp= req_get_cstream_var(wp, ("wscProvsionDevChannel"), "");
			if(strTmp[0])
			{			
				p2pProvisionComm.channel = atoi(strTmp);				
			}
			
			sprintf(WLAN_IF,"wlan%d",wlan_idx);
			
			if ( sendP2PProvisionCommInfo(WLAN_IF, &p2pProvisionComm) < 0)
			{
				P2P_DEBUG("SendP2PProvisionCommInfo fail\n");
			}
			
			
			return;
		}
		else if(strcmp(strTmp,"p2pWSCConnect") == 0)
		{
			P2P_WSC_CONFIRM_T p2pWscConfirm;
			
			memset(&p2pWscConfirm, 0x00, sizeof(P2P_WSC_CONFIRM_T));
			
			strTmp= req_get_cstream_var(wp, ("wscProvsionMethod"), "");
			if(strTmp[0])
			{
				int wscProvsionMethod;
				
				wscProvsionMethod = atoi(strTmp);
				
				if(wscProvsionMethod == 1) //display
					p2pWscConfirm.wsc_config_method = 0x8;
				else if(wscProvsionMethod == 2) //keypad
					p2pWscConfirm.wsc_config_method = 0x100;
				else if(wscProvsionMethod == 4) //pbc
					p2pWscConfirm.wsc_config_method = 0x80;
			}
			
			strTmp= req_get_cstream_var(wp, ("wscPinCode"), "");
			if(strTmp[0])
			{			
				sprintf(p2pWscConfirm.pincode, "%s", strTmp);
			}

			// 0316 add
			strTmp= req_get_cstream_var(wp, ("wscProvsionDevMac"), "");
			if(strTmp[0])
			{	
				if (strlen(strTmp)!=12 || !string_to_hex(strTmp, p2pWscConfirm.dev_address, 12)) 
				{
					strcpy(tmpBuf, ("Error! Invalid MAC address."));
				
				}
				

			}
			
			sprintf(WLAN_IF,"wlan%d",wlan_idx);
			if ( sendP2PWscConfirm(WLAN_IF, &p2pWscConfirm) < 0)
			{
				P2P_DEBUG("SendP2PWscConfirm fail\n");
			}
			
			return;
		}
		
	}

	
	submitUrl = req_get_cstream_var(wp, ("submit-url"), "");   // hidden page
	
	apmib_update_web(CURRENT_SETTING);
	
	if(run_init_script_flag == 1)
	{
		char tmpMsg[300];
		char lan_ip_buf[30]={0}, lan_ip[30]={0};

/* WNC-MRXXXX-JOE-PENG-20120319-Modification for NEC GUI customization */
#if 1
		sprintf(tmpMsg, "%s","ѹޤ<br>ƵưԤäƤޤƵưܾʤŸڤʤǤ");
#else
		/* Codes here are Realtek original codes */
		sprintf(tmpMsg, "%s","Change setting successfully!<br><br>Do not turn off or reboot the Router during this time.");
#endif
/* WNC-MRXXXX-JOE-PENG-20120319-end */
		apmib_get( MIB_IP_ADDR,  (void *)lan_ip_buf) ;
	  sprintf(lan_ip,"%s",inet_ntoa(*((struct in_addr *)lan_ip_buf)) );
		OK_MSG_FW(tmpMsg, submitUrl,APPLY_COUNTDOWN_TIME,lan_ip);		
		run_init_script("all");
	}
	else
	{
		if(needReboot == 1)
		{
		run_init_script("all");
		OK_MSG(submitUrl);
	}
		else
		{
			send_redirect_perm(wp, submitUrl);
		}
	}
	
	return;

setErr_WifiDirect:
	ERR_MSG(tmpBuf);
	
}

void formWlP2PScan(request *wp, char *path, char *query)
{
 	char *submitUrl, *refresh, *strVal;
	int status;

	unsigned char res, *pMsg=NULL;
	int wait_time, max_wait_time=5;
	char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};

	//displayPostDate(wp->post_data);	

	submitUrl = req_get_cstream_var(wp, ("submit-url"), "");

	refresh = req_get_cstream_var(wp, ("refresh"), "");
	if ( refresh[0] ) {
		// issue scan request
        strVal = req_get_cstream_var(wp, ("ifname"), "");
        if(strVal[0])
        {
            sprintf(WLAN_IF,"%s",strVal);               
        }

        P2P_DEBUG("WLAN_IF=[%s]\n",WLAN_IF);        
		wait_time = 0;
		while (1) 
		{
			 
			switch(getWlP2PScanRequest(WLAN_IF, &status)) 
			{ 
				case -2: 
					printf("-2\n"); 
					strcpy(tmpBuf, ("Auto scan running!!please wait...")); 
					goto ss_err; 
					break; 
				case -1: 
					printf("-2\n"); 
					strcpy(tmpBuf, ("Site-survey request failed!")); 
					goto ss_err; 
					break; 
				default: 
					break; 
			} 

//printf("\r\n status=[%d],__[%s-%u]\r\n",status,__FILE__,__LINE__);

			if (status != 0) // not ready
			{	
				if (wait_time++ > 5) 
				{
					strcpy(tmpBuf, ("scan request timeout!"));
					P2P_DEBUG("Scan request timeout\n");
					goto ss_err;
				}
				sleep(1);
			}
			else
				break;
		}
		
		
		wait_time = 0;
		while (1) {
			res = 1;	// only request request status
			
			if ( getWlP2PScanResult(WLAN_IF, (SS_STATUS_Tp)&res) < 0 ) 
			{
			
			}

			if (res == 0xff)    // in progress
			{

					
				if (wait_time++ > 20) 			
				{
					strcpy(tmpBuf, ("scan timeout!"));
					if(pStatus)
					{
						free(pStatus);
						pStatus = NULL;
					}
					goto ss_err;
				}
//printf("\r\n wait_time=[%d],__[%s-%u]\r\n",wait_time,__FILE__,__LINE__);				
				sleep(1);
			}
			else
				break;
		}
//printf("\r\n submitUrl=[%s],__[%s-%u]\r\n",submitUrl,__FILE__,__LINE__);

		if (submitUrl[0])
			send_redirect_perm(wp, submitUrl);

		return;
	}
	
	return;
	
ss_err:
	ERR_MSG(tmpBuf);
}

int wlP2PScanTbl(request *wp, int argc, char **argv)
{
	int nBytesSent=0, i;
	BssDscr *pBss;	
	char tmpBuf[MAX_MSG_BUFFER_SIZE], tmpBuf2[MAX_MSG_BUFFER_SIZE], p2pTypeStr[5];

	//printf("\r\n __[%s-%u]\r\n",__FILE__,__LINE__);

	if (pStatus==NULL) {
		pStatus = calloc(1, sizeof(SS_STATUS_T));
		if ( pStatus == NULL ) {
			printf("Allocate buffer failed!\n");
			return 0;
		}
	}

	pStatus->number = 0; // request BSS DB

	if ( getWlP2PScanResult(WLAN_IF, pStatus) < 0 ) {
		//ERR_MSG("Read site-survey status failed!");
		//printf("\r\n getWlP2PScanResult() fail.__[%s-%u]\r\n",__FILE__,__LINE__);		
		//req_format_write(wp, "Read site-survey status failed!");
		free(pStatus); //sc_yang
		pStatus = NULL;
		return 0;
	}

	nBytesSent += req_format_write(wp, ("<tr class=\"tbl_head\">"
	"<td align=center width=\"30%%\" ><font size=\"2\"><b>Device Name</b></font></td>\n"
	"<td align=center width=\"10%%\" ><font size=\"2\"><b>Channel</b></font></td>\n"
	"<td align=center width=\"30%%\" ><font size=\"2\"><b>Device address</b></font></td>\n"
  "<td align=center width=\"15%%\" ><font size=\"2\"><b>Role</b></font></td>\n"));
	
	nBytesSent += req_format_write(wp, ("<td align=center width=\"10%%\" ><font size=\"2\"><b>Select</b></font></td></tr>\n"));


	

//printf("\r\n pStatus->number=[%d],__[%s-%u]\r\n",pStatus->number,__FILE__,__LINE__);

	for (i=0; i<pStatus->number && pStatus->number!=0xff; i++) 
	{
		pBss = &pStatus->bssdb[i];
		snprintf(tmpBuf, MAX_MSG_BUFFER_SIZE, ("%02x:%02x:%02x:%02x:%02x:%02x"),
			pBss->p2paddress[0], pBss->p2paddress[1], pBss->p2paddress[2],
			pBss->p2paddress[3], pBss->p2paddress[4], pBss->p2paddress[5]);
			
		snprintf(tmpBuf2, MAX_MSG_BUFFER_SIZE, ("%02x%02x%02x%02x%02x%02x"),
			pBss->p2paddress[0], pBss->p2paddress[1], pBss->p2paddress[2],
			pBss->p2paddress[3], pBss->p2paddress[4], pBss->p2paddress[5]);
			
//printf("\r\n pBss->p2prole=[%d],__[%s-%u]\r\n",pBss->p2prole,__FILE__,__LINE__);
	
		memset(p2pTypeStr, 0x00, sizeof(p2pTypeStr));

	   if(pBss->p2prole == R_P2P_DEVICE)
	   {
	       strcpy(p2pTypeStr,"DEV");
	   }
	   else if(pBss->p2prole == R_P2P_GO)// 1:GO
	   {
	       strcpy(p2pTypeStr,"GO");
	   }else{
	       strcpy(p2pTypeStr,"?D");
	   }




		nBytesSent += req_format_write(wp, ("<tr class=\"tbl_body\">"
		"<td align=center ><font size=\"2\">%s</td>\n"
		"<td align=center ><font size=\"2\">%d</td>\n"
		"<td align=center ><font size=\"2\">%s</td>\n"     
    "<td align=center ><font size=\"2\">%s</td>\n"),
		pBss->p2pdevname, pBss->ChannelNumber, tmpBuf, p2pTypeStr);

		nBytesSent += req_format_write(wp,("\
		<td align=center > \
		<input type=\"radio\" name=""\"select\" value=\"sel%d\" onClick=\"p2pSelect(%d)\"> \
		</td></tr>\n\
		<input type=\"hidden\" id=\"selDeviceName_%d\" value=\"%s\" > \
		<input type=\"hidden\" id=\"selChannel_%d\" value=\"%d\" > \
		<input type=\"hidden\" id=\"selMacAddr_%d\" value=\"%s\" > \
		<input type=\"hidden\" id=\"selRole_%d\" value=\"%s\" > \
		<input type=\"hidden\" id=\"selWSCMethod_%d\" value=\"%d\" > \
		"),
		 i,i,i,pBss->p2pdevname,i,pBss->ChannelNumber,i,tmpBuf2,i,p2pTypeStr,i,pBss->p2pwscconfig);
		
	}

	if( pStatus->number == 0 )
	{
		nBytesSent += req_format_write(wp, "<tr>"
    "<td align=center ><font size=\"2\">None</td>\n"
    "<td align=center ><font size=\"2\"></td>\n"
    "<td align=center ><font size=\"2\"></td>\n"
    "<td align=center ><font size=\"2\"></td>\n"
    "<td align=center ><font size=\"2\"></td>\n"
    "</tr>\n");
	}
	return nBytesSent;
}


void p2p_dhcp_process(void)
{

    int Ret = 0;

    /*no any interface need to query P2P state*/
    if(p2p_query_which_interface==0){    
       // SDEBUG("\n");
        return;
    }
    
    /*after wlan mode be changed execue once , check which interface we should check; expect just run once */
    if(p2p_query_which_interface==255){
        //SDEBUG("once\n");

        int wlan0_mode=0;
        int wlan1_mode=0;        
        int wlan_idx_backup=0;            

        p2p_query_which_interface=0;
            
        wlan_idx_backup = wlan_idx;        
        wlan_idx=0;
      	apmib_get(MIB_WLAN_MODE,(void *)&wlan0_mode);
        #ifdef FOR_DUAL_BAND
        wlan_idx=1;
      	apmib_get(MIB_WLAN_MODE,(void *)&wlan1_mode);    
        #endif      
        wlan_idx = wlan_idx_backup;

        if(wlan0_mode==P2P_SUPPORT_MODE){
            p2p_query_which_interface=1; //wlan0
        }
        if(wlan1_mode==P2P_SUPPORT_MODE){
            p2p_query_which_interface=2; //wlan1
        }        
        if((wlan0_mode==P2P_SUPPORT_MODE) && (wlan1_mode==P2P_SUPPORT_MODE)){
            printf("[%s %s %d] !!!both interface P2P are enabled!!!",__FILE__,__FUNCTION__,__LINE__);
        }

    }
    /*after wlan mode be changed execue once , check which interface we should check; expect just run once */


    
    if(p2p_query_which_interface==1){           
        //SDEBUG("query[wlan%d]\n",p2p_query_which_interface-1);                
    	Ret = getClientConnectState("wlan0");		
    }else if(p2p_query_which_interface==2){       
        //SDEBUG("query[wlan%d]\n",p2p_query_which_interface-1);        
    	Ret = getClientConnectState("wlan1");		        
    }else{
        return;
    }

    
	if(Ret == P2P_S_CLIENT_CONNECTED_DHCPC)
	{	
        system("killall -9 udhcpd 2> /dev/null");
        system("killall -9 udhcpc 2> /dev/null");
		P2P_DEBUG(" ... Web server start udhcpc ...\n");
		set_lan_dhcpc("br0");	
        
	}else if(Ret == P2P_S_preGO2GO_DHCPD){	
        system("killall -9 udhcpd 2> /dev/null");
        system("killall -9 udhcpc 2> /dev/null");
		P2P_DEBUG(" ...Web server start udhcpd ...\n");	
		set_lan_dhcpd("br0", 2);		
        
	}else if(Ret == P2P_S_back2dev){
		int valTmp = P2P_DEVICE;
		int valTmp2 = 0;
		int tmpint,tmpint2;		
		unsigned char ssidstr[33];
		unsigned char syscmd[50];
		tmpint = wlan_idx ;
		tmpint2 = vwlan_idx ;		
		strcpy(ssidstr,"");
		vwlan_idx = 0;

        if(p2p_query_which_interface==1){           
            wlan_idx=0;	
        }else if(p2p_query_which_interface==2){       
            wlan_idx=1;	        
        }      
					
		apmib_set( MIB_WLAN_P2P_TYPE, (void *)&valTmp);		
		apmib_set( MIB_WLAN_SSID, (void *)ssidstr);
		apmib_set( MIB_WLAN_WPA_PSK, (void *)ssidstr);		
		apmib_set( MIB_WLAN_AUTH_TYPE, (void *)&valTmp2);
		apmib_set( MIB_WLAN_ENCRYPT, (void *)&valTmp2);
		apmib_set( MIB_WLAN_WPA_CIPHER_SUITE, (void *)&valTmp2);
		apmib_set( MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&valTmp2);
		apmib_set( MIB_WLAN_WSC_CONFIGURED, (void *)&valTmp2);		
		apmib_update_web(CURRENT_SETTING);	// update to flash					




		sprintf(syscmd,"iwpriv wlan%d p2pcmd bakdev",wlan_idx);            

        wlan_idx = tmpint ;		
		vwlan_idx = tmpint2 ;
		P2P_DEBUG("syscmd=[%s]\n",syscmd);
		system(syscmd);		
	}
	
}


#endif // #if defined(CONFIG_RTL_P2P_SUPPORT)

void getWlProfileInfo(request *wp, int argc, char **argv)
{
#if defined(WLAN_PROFILE)
	char	*name;
	int idx;
	int profile_enabled_id, profile_num_id, profile_tbl_id;
	int entryNum = 0; //WNC-NMR0000-Rita-20130306-Error_476-fix warnings of cppcheck (uninitialized value).
	WLAN_PROFILE_T entry;
	int wlProfileEnabled = 0; //WNC-NMR0000-Rita-20130305-Error_460-fix warnings of cppcheck (uninitialized value).
	int buffer[64];
	name = argv[0];
	idx = atoi(argv[1]);
	
	if (name == NULL) {
   		fprintf(stderr, "Insufficient args\n");
   		return -1;
   	}

	if(wlan_idx == 0)
	{
		profile_enabled_id = MIB_PROFILE_ENABLED1;
		profile_num_id = MIB_PROFILE_NUM1;
		profile_tbl_id = MIB_PROFILE_TBL1;
	}
	else
	{
		profile_enabled_id = MIB_PROFILE_ENABLED2;
		profile_num_id = MIB_PROFILE_NUM2;
		profile_tbl_id = MIB_PROFILE_TBL2;
	}

	apmib_get( profile_enabled_id, (void *)&wlProfileEnabled);
	if(wlProfileEnabled == 0)
	{
		req_format_write(wp,"%s","0");
		return 0;
	}
	
	apmib_get(profile_num_id, (void *)&entryNum);
	if(idx > entryNum)
	{
		req_format_write(wp,"%s","0");
		return 0;
	}
	
	*((char *)&entry) = (char)idx;
	if ( !apmib_get(profile_tbl_id, (void *)&entry))
	{
		req_format_write(wp,"%s","0");
		return 0;
	}
		
//////MENU//////////////////////////////////////////////////
	if(!strcmp(name,"wlProfileTblEnable"))
	{
		req_format_write(wp,"%d",1);
		return 0;
	}
	else if(!strcmp(name,"wlProfileSSID"))
	{
		sprintf(buffer,"%s",entry.ssid);
		translate_control_code(buffer);
		req_format_write(wp,"%s",buffer);
		return 0;
	}
	
#endif //#if defined(WLAN_PROFILE)
	
	return 0;
}
int bssid_to_ssid(char *bssid,char *ssidbuf)
{
	 BssDscr *pBss=NULL;
    char tmpBuf[200];
    int k;
	for (k=0; k<pStatus->number && pStatus->number!=0xff; k++) 
    {
        pBss = &pStatus->bssdb[k];
        snprintf(tmpBuf, 200, ("%02x:%02x:%02x:%02x:%02x:%02x"),
            pBss->bdBssId[0], pBss->bdBssId[1], pBss->bdBssId[2],
            pBss->bdBssId[3], pBss->bdBssId[4], pBss->bdBssId[5]);

        if(strcmp(bssid, tmpBuf)==0)
        {
            memcpy(ssidbuf, pBss->bdSsIdBuf, pBss->bdSsId.Length);
            ssidbuf[pBss->bdSsId.Length] = '\0';	
            return 0;
        }		
    }
	return -1;
}

#ifdef FAST_BSS_TRANSITION	
void formFt(request *wp, char *path, char *query)
{
	char *strVal, *submitUrl;
	char tmpbuf[256]={0};
	FTKH_T khEntry={0},khEntryTmp={0};
	int idx, i, entryNum, intVal, deleted=0;

	submitUrl = req_get_cstream_var(wp, "submit-url", "");
#if defined(CONFIG_RTL_92D_SUPPORT) 
	strVal = req_get_cstream_var(wp, "wlan_idx", "");
	if ( strVal[0] ) {
		//printf("wlan_idx=%d\n", strVal[0]-'0');
		wlan_idx = strVal[0]-'0';
	}
#endif //CONFIG_RTL_92D_SUPPORT || WLAN_DUALBAND_CONCURRENT

	// check which interface is selected
	strVal = req_get_cstream_var(wp, "ftSSID", "");
	if (strVal[0]) {
		idx = strVal[0]-'0';
		if (idx<0 || idx > NUM_VWLAN_INTERFACE) {
			strcpy(tmpbuf, "Error! Not support this SSID TYPE.");
			goto setErr_ft;
		}
		vwlan_idx=idx;
	} 
	
	

	// for driver configurateion
	strVal = req_get_cstream_var(wp, "ftSaveConfig", "");
	if (strVal[0]) {
		// 802.11r related settings
		strVal = req_get_cstream_var(wp, "ft_enable", "");
		if (strVal[0])
		{
			intVal= atoi(strVal);
			apmib_set(MIB_WLAN_FT_ENABLE,(void*)&intVal);
		}

		strVal = req_get_cstream_var(wp, "ft_mdid", "");
		if (strVal[0])
		{
			strncpy(tmpbuf, strVal, 4);
			apmib_set(MIB_WLAN_FT_MDID,(void*)tmpbuf);
		}

		strVal = req_get_cstream_var(wp, "ft_over_ds", "");
		if (strVal[0])
		{
			intVal= atoi(strVal);
			apmib_set(MIB_WLAN_FT_OVER_DS,(void*)&intVal);
		}

		strVal = req_get_cstream_var(wp, "ft_res_request", "");
		if (strVal[0])
		{
			intVal= atoi(strVal);
			apmib_set(MIB_WLAN_FT_RES_REQUEST,(void*)&intVal);
		}

		strVal = req_get_cstream_var(wp, "ft_r0key_timeout", "");
		if (strVal[0])
		{
			intVal= atoi(strVal);
			apmib_set(MIB_WLAN_FT_R0KEY_TO,(void*)&intVal);
		}

		strVal = req_get_cstream_var(wp, "ft_reasoc_timeout", "");
		if (strVal[0])
		{
			intVal= atoi(strVal);
			apmib_set(MIB_WLAN_FT_REASOC_TO,(void*)&intVal);
		}

		strVal = req_get_cstream_var(wp, "ft_r0kh_id", "");
		if (strVal[0])
		{
			strncpy(tmpbuf, strVal, 48);
			apmib_set(MIB_WLAN_FT_R0KH_ID,(void*)tmpbuf);
		}

		strVal = req_get_cstream_var(wp, "ft_push", "");
		if (strVal[0])
		{
			intVal= atoi(strVal);
			apmib_set(MIB_WLAN_FT_PUSH,(void*)&intVal);
		}

		// save changes
		apmib_update_web(CURRENT_SETTING);
		goto setOk_ft;
	}

	// for R0KH/R1KH configuration
	apmib_get(MIB_WLAN_FTKH_NUM,(void*)&entryNum);
	/* Add entry */
	strVal = req_get_cstream_var(wp, "ftAddKH", "");
	if (strVal[0]) {
		if ( entryNum >= MAX_VWLAN_FTKH_NUM ) {
			strcpy(tmpbuf, "Cannot add new entry because table is full!");
			goto setErr_ft;
		}

		memset(&khEntry, 0, sizeof(khEntry));
		strVal = req_get_cstream_var(wp, "kh_mac", "");
		if (!strVal[0]) {
			strcpy(tmpbuf, "Error! No mac address to set.");
			goto setErr_ft;
		}
		if (strlen(strVal)!=12 || !string_to_hex(strVal, khEntry.macAddr, 12)) {
			strcpy(tmpbuf, "Error! Invalid MAC address.");
			goto setErr_ft;
		}


		strVal = req_get_cstream_var(wp, "kh_nas_id", "");
		if (!strVal[0]) {
			strcpy(tmpbuf, "Error! No NAS identifier to set.");
			goto setErr_ft;
		}
		strncpy(khEntry.nas_id, strVal, 48);

		strVal = req_get_cstream_var(wp, "kh_kek", "");
		if (!strVal[0]) {
			strcpy(tmpbuf, "Error! No R0KH/R1KH key to set.");
			goto setErr_ft;
		}
		strncpy(khEntry.key, strVal, 32);


        #ifdef DOT11K
        strVal = req_get_cstream_var(wp, "kh_opclass", "");
        if (!strVal[0]) {
            strcpy(tmpbuf, "Error! No Op Class to set.");
            goto setErr_ft;
        }
        khEntry.opclass = atoi(strVal);

        strVal = req_get_cstream_var(wp, "kh_channel", "");
        if (!strVal[0]) {
            strcpy(tmpbuf, "Error! No Channel to set.");
            goto setErr_ft;
        }
        khEntry.channel = atoi(strVal); 
        #endif
        
		// set to MIB. Check if entry exists
		for (i=1; i<=entryNum; i++) {
			
			*((char*)(&khEntryTmp))=(char)i;
			if (!apmib_get(MIB_WLAN_FTKH,(void*)&khEntryTmp)) {
				strcpy(tmpbuf, "Error! Get MIB_MBSSIB_TBL error.");
				goto setErr_ft;
			}
		
			if (!memcmp(khEntry.macAddr, khEntryTmp.macAddr, 6))
			{
				strcpy(tmpbuf, "Entry already exists!");
				goto setErr_ft;
			}
		}

		if(entryNum+1>MAX_FTKH_NUM)
		{
			strcpy(tmpbuf, "Error! Table Full.");
			goto setErr_ft;
		}
		// add new KH entry
		intVal = apmib_set(MIB_WLAN_FTKH_ADD,(void*)&khEntry);
		if (intVal == 0) {
			strcpy(tmpbuf, "Error! Add chain record.");
			goto setErr_ft;
		}
		//printf("%s:%d mac=%02x%02x%02x%02x%02x%02x kh_nas_id=%s\n",__FUNCTION__,__LINE__,khEntry.macAddr[0],khEntry.macAddr[1],khEntry.macAddr[2]
		//	,khEntry.macAddr[3],khEntry.macAddr[4],khEntry.macAddr[5],khEntry.nas_id);

		

		// generate new ft.conf and update to FT daemon
		apmib_update_web(CURRENT_SETTING);
		goto setOk_ft;
	}

	/* Delete selected entry */
	strVal = req_get_cstream_var(wp, "ftDelSelKh", "");
	if (strVal[0]) {
		
		for (i=entryNum; i>0; i--) {
			*((char*)(&khEntryTmp))=(char)i;
			if (!apmib_get(MIB_WLAN_FTKH,(void*)&khEntryTmp)) {
				strcpy(tmpbuf, "Error! Get MIB_MBSSIB_TBL error.");
				goto setErr_ft;
			}
			

			snprintf(tmpbuf, 20, "kh_entry_%d", i);
			strVal = req_get_cstream_var(wp, tmpbuf, "");

			if (!strcmp(strVal, "ON")) {
				deleted++;
				if(apmib_set(MIB_WLAN_FTKH_DEL,(void*)&khEntryTmp)==0)
				{
					strcpy(tmpbuf,"Delete chain record error!");
					goto setErr_ft;
				}
			}
		}
		if (deleted <= 0) {
			strcpy(tmpbuf, "There is no item selected to delete!");
			goto setErr_ft;
		}

		apmib_update_web(CURRENT_SETTING);
		goto setOk_ft;
	}

	/* Delete all entry */
	strVal = req_get_cstream_var(wp, "ftDelAllKh", "");
	if (strVal[0]) {
		
		if(apmib_set(MIB_WLAN_FTKH_DELALL,(void*)&khEntryTmp)==0)
		{
			strcpy(tmpbuf,"Delete chain record error!");
			goto setErr_ft;
		}
		apmib_update_web(CURRENT_SETTING);
		goto setOk_ft;
	}
	send_redirect_perm(wp,submitUrl);
	return;
setOk_ft:
	OK_MSG(submitUrl);
	return;

setErr_ft:
	ERR_MSG(tmpbuf);
	return;
}

#endif
#ifdef CONFIG_APP_ACCESSTIMER
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-01-12: Implement Access Timer feature #BEGIN
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #BEGIN
#define MWF_BAND_5G	1
#define MWF_BAND_2G	2

// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Fix bug Wi-Fi management get connection status #BEGIN
//#define MWF_VAP_PRIMARY_SSID	0
//#define MWF_VAP_SECONDARY_SSID	1
// For Repater PRIAMARY_SSID is va0
#if 1/*WNC-NMR1736-[Aero/Thalys]-Libera-20160606- responsive GUI porting: Accesstimer/UMWA: consider wlanx */
#define MWF_VAP_PRIMARY_SSID	0
#define MWF_VAP_SECONDARY_SSID	1
#else	//spdier (rpt mode)
#define MWF_VAP_PRIMARY_SSID	1
#define MWF_VAP_SECONDARY_SSID	2
#endif
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Fix bug Wi-Fi management get connection status #END

typedef struct mac {
	unsigned char addr[6];
	char status;
	unsigned char band;
	unsigned char vap;
	unsigned char network;
	unsigned char ht_info;
	unsigned char rssi;
	unsigned char chan;
	unsigned char sndchoff;
	char ssid[MAX_SSID_LEN];
	unsigned int fail_reason;
	int encrypt;
	int always_notify;
	struct tm first;
} mac_addr;

typedef struct _mwf_entry {
	unsigned char addr[6];
	char registered;
	char category;
	char name[33];
	char permit;
	char timeinfo[8];
	char connection;
	char band;
	char strength;
	char macfilter;		
	unsigned int fail_reason;		
} mwf_entry;

typedef struct _mwf_table {
	int size;
	int num;
	mwf_entry *data;
} mwf_table;


#define MWF_CREATE	0x1

void mwf_table_init(mwf_table *table) {
	table->num = 0;
	table->size = 0;
	table->data = NULL;
}

void mwf_table_free(mwf_table *table) {
	free(table->data);
	mwf_table_init(table);
}

mwf_entry* find_mwf_entry(mwf_table* table, unsigned char *mac, int flag) {
	int i = 0;
	
	unsigned char empty_mac[6] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
	
	if (table->data == NULL) {
		if (flag & MWF_CREATE) {
			table->data = malloc(8*sizeof(mwf_entry));
			if (table->data) {
				memset(&table->data[0], 0, sizeof(mwf_entry));
				memcpy(table->data[0].addr, mac, 6);
				table->data[0].category = -1;
				table->data[0].permit = -1;
// WNC-NMR01815-D2R031-HENG-I-CHEN-20161006: Get name from DHCP option for new entry #BEGIN
				memset(table->data[0].name, 0, 33);
				getNameByDhcp(mac, table->data[0].name);
// WNC-NMR01815-D2R031-HENG-I-CHEN-20161006: Get name from DHCP option for new entry #END
				table->size = 8;
				table->num = 1;
			}
		}
		return table->data;
	}
	
	for (i = 0; i < table->num ; i++ ) {
		if ( memcmp(table->data[i].addr, mac, 6) == 0 ) {
			return &table->data[i];
		}
	}
	
	if (flag & MWF_CREATE) {
		if (table->num == table->size) {		
			mwf_entry *new = NULL;
			new = realloc(table->data, (table->size+8)*sizeof(mwf_entry));
			if (new) {
				table->data = new;
				table->size += 8;
			} else {
				return NULL;
			}
		}

		i = table->num++;
		memset(&table->data[i], 0, sizeof(mwf_entry));
		memcpy(table->data[i].addr, mac, 6);
// WNC-NMR01815-D2R031-HENG-I-CHEN-20161006: Get name from DHCP option for new entry #BEGIN
		memset(table->data[i].name, 0, 33);
		getNameByDhcp(mac, table->data[i].name);
// WNC-NMR01815-D2R031-HENG-I-CHEN-20161006: Get name from DHCP option for new entry #END
		table->data[i].category = -1;
		table->data[i].permit = -1;
		return &table->data[i];
	} 
	
	return NULL;
}

unsigned char signal_strength(unsigned char band, unsigned char ht_info, unsigned char rssi) {

	unsigned char ret = 0;
	/* NMR2144-20161201-[request] RSSI modification-start */
	if (band == MWF_BAND_2G) {
		if ((ht_info & BIT(0)) == BIT(0)) { //HT40
			if (rssi >= 18)	
				ret = 4;
			else if (rssi >= 14 && rssi <= 17) 
				ret = 3;
			else if (rssi <= 13)
				ret = 2;
		} else { //HT20
			if (rssi >= 22)     
				ret = 4;
			else if (rssi >= 15 && rssi <= 21) 
				ret = 3;
			else if (rssi <= 14)
				ret = 2;
		}
	} else if (band == MWF_BAND_5G){
		if ((ht_info & BIT(2)) == BIT(2)) { //HT80
			if (rssi >= 18)	
				ret = 4;
			else if (rssi >= 15 && rssi <= 17) 
				ret = 3;
			else if (rssi <= 14)
				ret = 2;
		} else if ((ht_info & BIT(0)) == BIT(0)) { //HT40
			if (rssi >= 20)	
				ret = 4;
			else if (rssi >= 15 && rssi <= 19) 
				ret = 3;
			else if (rssi <= 14)
				ret = 2;
		} else { //HT20
			if (rssi >= 21)     
				ret = 4;
			else if (rssi >= 15 && rssi <= 20) 
				ret = 3;
			else if (rssi <= 14)
				ret = 2;
		}
	}
	/* NMR2144-20161201-[request] RSSI modification-end */
	return ret;
}
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #END

char* getStaChannel(unsigned char channel, unsigned char ht_info, unsigned char sndchoff) {

	static char buf[256];
	
	memset(buf, 0, 256);
	
	if ((ht_info & BIT(2)) == BIT(2)) { //HT80
		unsigned char i;
		unsigned char endChan = (channel + 12)/16*16;
		unsigned char startChan = endChan - 12;

		snprintf(buf, sizeof(buf), "%d", channel);
				
		for (i=startChan ; i <= endChan ; i+=4) {
			if (i != channel) {
				snprintf(buf+strlen(buf), sizeof(buf)-strlen(buf), "&%d", i);
			}
		}
		return buf;
	} else if ((ht_info & BIT(0)) == BIT(0)) { //HT40
		if (sndchoff == 1) {	 
			snprintf(buf, sizeof(buf), "%d&%d", channel, channel-4);
		} else if (sndchoff == 2){
			snprintf(buf, sizeof(buf), "%d&%d", channel, channel+4);
		} else {
			snprintf(buf, sizeof(buf), "%d", channel);
		}
		return buf;
	} else { //HT20
		snprintf(buf, sizeof(buf), "%d", channel);
		return buf;
	}
}

int compMac(mac_addr *staA, mac_addr *staB) {
	int i;
	for (i=0;i<6;i++) {
		if (staA->addr[i] != staB->addr[i])
			return (staA->addr[i] - staB->addr[i]);
	}
	return 0;
}

int getAssocatedStaions(mac_addr *staList) {
	int i, j, k, staNum = 0;
	WLAN_STA_INFO_Tp staInfo;
	char *buff;
	char ifbuf[32];

	                                                   
	buff = calloc(1, sizeof(WLAN_STA_INFO_T) * (MAX_STA_NUM+1)* NUM_WLAN_INTERFACE);
	if ( buff == 0 ) {
		printf("Allocate buffer failed!\n");
		return 0;
	}
	
	/*WNC-NMR1736-[Aero/Thalys]-Libera-20160606- responsive GUI porting: Accesstimer/UMWA: consider wlanx -start */	
	int rptmode =0;
	if (access("/tmp/MODE_RPT", F_OK) == 0) {	//RPT mode
		rptmode=1;
	}else if ((access("/tmp/MODE_RPT", F_OK) != 0) && (access("/tmp/MODE_CNV", F_OK) != 0)) {	//RT/BR mode
		rptmode=2;
	}
	/*WNC-NMR1736-[Aero/Thalys]-Libera-20160606- responsive GUI porting: Accesstimer/UMWA: consider wlanx -end */	

	for(k=0; k<NUM_WLAN_INTERFACE; k++) {
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Fix bug Wi-Fi management get connection status #BEGIN
#if 0	//for Repeater (Spider...)
		for(j=1;j<2;j++) {
#else	//for all	 WNC-NMR1736-[Aero/Thalys]-Libera-20160606- responsive GUI porting: Accesstimer/UMWA: consider wlanx
		for(j=0;j<rptmode;j++) {
#endif
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Fix bug Wi-Fi management get connection status #END
			bss_info bss;
			
			if (j == 0) {
				/*WNC-NMR1736-[Aero/Thalys]-Libera-20160606- responsive GUI porting: Accesstimer/UMWA: consider wlanx -start */
				if(rptmode==1){ //RPT
					snprintf(ifbuf, sizeof(ifbuf), "wlan%d-va%d", k, j);	//repeater mode's pri is wlanx-va0
				}else{
				/*WNC-NMR1736-[Aero/Thalys]-Libera-20160606- responsive GUI porting: Accesstimer/UMWA: consider wlanx -end */
					snprintf(ifbuf, sizeof(ifbuf), "wlan%d", k);
				}
			} else {
				snprintf(ifbuf, sizeof(ifbuf), "wlan%d-va%d", k, j-1);
			}
			if ( getWlBssInfo(ifbuf, &bss) < 0)
				return -1;
		
			memset(buff, 0, sizeof(WLAN_STA_INFO_T) * (MAX_STA_NUM+1));
			if ( getWlStaInfo(ifbuf, (WLAN_STA_INFO_Tp)buff ) < 0 ) {
				printf("Read wlan sta info failed!\n");
				return 0;
			}
	
			staInfo = (WLAN_STA_INFO_Tp)&(buff[0]);
	
			for (i=1; i<=MAX_STA_NUM; i++) {
		
				if (staInfo[i].aid && (staInfo[i].flag & STA_INFO_FLAG_ASOC)) {
// WNC-NMR01369-D2R031-HENG-I-CHEN-20160224: set inAuthorizing when WPA PSK negotiation is not completed #BEGIN
					if (staInfo[i].inAuthorizing)
						continue;
// WNC-NMR01369-D2R031-HENG-I-CHEN-20160224: set inAuthorizing when WPA PSK negotiation is not completed #END
				    memcpy(staList[staNum].addr, staInfo[i].addr, 6);
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Fix bug Wi-Fi management get connection status #BEGIN

				    staList[staNum].status = 1;
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Fix bug Wi-Fi management get connection status #END
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #BEGIN
					if (k == 0)
					    staList[staNum].band = MWF_BAND_2G;
					else if (k == 1)
					    staList[staNum].band = MWF_BAND_5G;					
					staList[staNum].vap = j;					
				    staList[staNum].ht_info = staInfo[i].ht_info;
				    staList[staNum].rssi = staInfo[i].rssi;
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #END
					staList[staNum].network = staInfo[i].network;
					staList[staNum].chan = bss.channel;
					staList[staNum].sndchoff = bss.sndchoff;
					memset(staList[staNum].ssid, 0, SSID_LEN+1);
					strncpy(staList[staNum].ssid, bss.ssid, SSID_LEN);
#if 0					
					switch(bss.dot11EnablePSK) {
						case 0:
							staList[staNum].encrypt = 0;
							break;
						case 1:
							staList[staNum].encrypt = BIT(0) | BIT(4) | BIT(8);
							if(bss.dot11WPACipher == 10) {
								staList[staNum].encrypt |= (BIT(6) | BIT(7));
							} else if(bss.dot11WPACipher == 8) {
								staList[staNum].encrypt |= BIT(7);
							} else if(bss.dot11WPACipher == 2) {
								staList[staNum].encrypt |=  BIT(7);
							}
							break;
						case 2:
							staList[staNum].encrypt = BIT(0) | BIT(5) | BIT(8);
							if(bss.dot11WPA2Cipher == 10) {
								staList[staNum].encrypt |= (BIT(6) | BIT(7));
							} else if(bss.dot11WPA2Cipher == 8) {
								staList[staNum].encrypt |= BIT(7);
							} else if(bss.dot11WPA2Cipher == 2) {
								staList[staNum].encrypt |=  BIT(7);
							}
							break;
						case 3:
							staList[staNum].encrypt = BIT(0) | BIT(4) | BIT(5) | BIT(8);
							if(bss.dot11WPA2Cipher == 10) {
								staList[staNum].encrypt |= (BIT(6) | BIT(7));
							} else if(bss.dot11WPA2Cipher == 8) {
								staList[staNum].encrypt |= BIT(7);
							} else if(bss.dot11WPA2Cipher == 2) {
								staList[staNum].encrypt |=  BIT(7);
							}
							break;
					}
#else
					switch(staInfo[i].auth_type) {
						case STATS_PSK_WPA:
							staList[staNum].encrypt = BIT(0) | BIT(4) | BIT(8);
							break;
						case STATS_PSK_WPA2:
							staList[staNum].encrypt = BIT(0) | BIT(5) | BIT(8);
							break;
						default:
							break;
					}

					switch (staInfo[i].cipher_type) {
						case DOT11_ENC_NONE:
							staList[staNum].encrypt = 0;
							break;
// WNC-NMR01800-D2R031-HENG-I-CHEN-20161006: Add WEP encryption #BEGIN
						case DOT11_ENC_WEP40:
							staList[staNum].encrypt |= BIT(2);
							break;
						case DOT11_ENC_WEP104:
							staList[staNum].encrypt |= BIT(2) | BIT(3);
							break;
// WNC-NMR01800-D2R031-HENG-I-CHEN-20161006: Add WEP encryption #END
						case DOT11_ENC_TKIP:
							staList[staNum].encrypt |= BIT(6);
							break;
						case DOT11_ENC_CCMP:
							staList[staNum].encrypt |= BIT(7);
							break;
					}
#endif					
					staNum++;
				}
			}
		}
	}
//	console_printf("%s %d staNum %d\n", __func__, __LINE__, staNum);
	usleep(100);
	free(buff);
/*	if (staNum > 1) {
		qsort(staList, staNum, sizeof(mac_addr), compMac);
		
		j=0;
		
		for(i=1;i<staNum;i++) {
			if (compMac(&staList[i], &staList[j]) == 0) {
				continue;
			}
			j++;
			memcpy(&staList[j], &staList[i], sizeof(mac_addr));
		}
		for (i=j+1;i<staNum;i++) {
			memset(&staList[i], 0, sizeof(mac_addr));
		}
		staNum = j+1;
	}
*/	
	return staNum;
}
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-01-12: Implement Access Timer feature #END
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-01-27: Implement Access Timer feature #BEGIN
int getTimeslot(unsigned char * timer, int index) {
	int byte, bit;
	unsigned char c;
	byte = index / 8;
	bit = index % 8;
	c = timer[byte];
	return ((c >> (7-bit)) & 0x1);
}
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-01-27: Implement Access Timer feature #END

struct dhcpOfferedAddr {
	u_int8_t chaddr[16];
	u_int32_t yiaddr;	/* network order */
	u_int32_t expires;	/* host order */
#if defined(CONFIG_RTL8186_KB) || defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL865X_SC) || defined(CONFIG_RTL865X_AC) || defined(CONFIG_RTL865X_KLD)
	char hostname[64]; /* Brad add for get hostname of client */
	u_int32_t isUnAvailableCurr;	/* Brad add for WEB GUI check */
#endif
/* WNC-NMR0000-JOE-PENG-20131224-Add DHCP option 12 and 60 to DHCP server lease file used by Access-Timer function-start */
	char wnc_hostname[64]; /* DHCP option 12 (DHCP_HOST_NAME) */
	char wnc_vendor[64]; /* DHCP option 60 (DHCP_VENDOR) */
/* WNC-NMR0000-JOE-PENG-20131224-Add DHCP option 12 and 60 to DHCP server lease file used by Access-Timer function-end */
};
	
int getNameByDhcp(unsigned char *mac, char* name) {
	
	FILE *fp;
	struct dhcpOfferedAddr lease;
	int ret;
		
	system("killall -SIGUSR1 udhcpd");
	
	fp = fopen("/var/udhcpd.leases_for_access_timer", "r");
	if (!fp)
		return -1;
	
	do {	
		ret = fread(&lease, sizeof(struct dhcpOfferedAddr), 1, fp);
		if (ret != 1) {
		 	fclose(fp);
			return -1;
		}
		if (memcmp(lease.chaddr, mac, 6) == 0) {
			fclose(fp);
			if (strncmp(lease.wnc_vendor, "PS", 2) == 0 ||
				// XBOX 360 user "xbox 360" as vendor
				strncasecmp(lease.wnc_vendor, "XBOX", 4) == 0 ) {
				memset(name, 0, 33);

				/* WNC-NMR0000-JOE-PENG-20140911-Fix bug 2043 (STRING_NULL) in StaticCodeCheck_Linear_Delta1.xls */
				lease.wnc_vendor[sizeof(lease.wnc_vendor)-1]= '\0';
				if (strlen(lease.wnc_vendor) > 31) {
					strncpy(name, lease.wnc_vendor, 28);
					strncat(name, "...", 3);
				} else {
					strncpy(name, lease.wnc_vendor, 31);
				}
			} else if (strncmp(lease.wnc_hostname, "android", 7) == 0 ||
						strncmp(lease.wnc_hostname, "Android", 7) == 0 ){
				strlcpy(name, "Android", 33);
			} else if (*lease.wnc_hostname != 0) {
				memset(name, 0, 33);
				/* WNC-NMR0000-JOE-PENG-20140911-Fix bug 2045 (STRING_NULL) in StaticCodeCheck_Linear_Delta1.xls */
				/* WNC-NMR2442-Libera-20170707-device name must be ASCII 0x20-0x7e-start */	
				if(lw_Ascii_207e_Check(lease.wnc_hostname)){					
					//printf("[@DHCP device name@] out of ascii range!, File: %s, Func: %s, Line: %d @@\n",__FILE__,__FUNCTION__ , __LINE__);
					memset(name, 0, 33);
				}else{ 
				/* WNC-NMR2442-Libera-20170707-device name must be ASCII 0x20-0x7e-end */
					//printf("[@DHCP device name@] lease.wnc_hostname=%s, File: %s, Func: %s, Line: %d @@\n",lease.wnc_hostname,__FILE__,__FUNCTION__ , __LINE__);
					lease.wnc_hostname[sizeof(lease.wnc_hostname)-1]= '\0';
					if (strlen(lease.wnc_hostname) > 31) {
						strncpy(name, lease.wnc_hostname, 28);
						strncat(name, "...", 3);
					} else {
						strncpy(name, lease.wnc_hostname, 31);
					}
				}
			}
			return 0;
		}
		
	} while(ret == 1);
	
	fclose(fp);
	return 0;
	
}

typedef enum { REGISTERED=1, INIQUITOUS=2, NO_REGISTERED=3 } WIFI_LOG_T;
struct wifi_log_ram * get_wifi_log_ram_entry (unsigned char *mac) 
{
	FILE *logfp = NULL;
	static struct wifi_log_ram entry;
	
	if (mac == NULL) {
		return NULL;
	}
	
	logfp = fopen("/var/wifi_sta_log", "r");
	if (logfp) {
		int readlen = 0;
		int logi = 0, logm = 0, logn = 0;
		D_LOG_rTB_Tp wifi_ram_log = NULL;

		wifi_ram_log = malloc(sizeof(D_LOG_rTB_T));
		if (wifi_ram_log == NULL) {
			fclose(logfp);
			return NULL;
		}
		readlen = fread(wifi_ram_log, sizeof(D_LOG_rTB_T), 1, logfp);
		if (readlen != 1)
		{
			free(wifi_ram_log);
			wifi_ram_log = NULL;
			fclose(logfp);
			return NULL;
		}
			
		fclose(logfp);
			
		while (logm < MAX_WIFI_RAM_LOG_NUM) {
			
			if (logm < MAX_WIFI_RGST_RAM_LOG_NUM) {
			logi = 0;
				logm = MAX_WIFI_RGST_RAM_LOG_NUM;
				logn = 0 + wifi_ram_log->rgst_num;
			} else if (logm < MAX_WIFI_RGST_RAM_LOG_NUM + MAX_WIFI_INQTS_RAM_LOG_NUM) {
				logi = MAX_WIFI_RGST_RAM_LOG_NUM;
				logm = MAX_WIFI_RGST_RAM_LOG_NUM + MAX_WIFI_INQTS_RAM_LOG_NUM;
				logn = MAX_WIFI_RGST_RAM_LOG_NUM + wifi_ram_log->inqts_num;
			} else if (logm < MAX_WIFI_RGST_RAM_LOG_NUM + MAX_WIFI_INQTS_RAM_LOG_NUM + MAX_WIFI_NRGST_RAM_LOG_NUM) {
				logi = MAX_WIFI_RGST_RAM_LOG_NUM + MAX_WIFI_INQTS_RAM_LOG_NUM;
				logm = MAX_WIFI_RGST_RAM_LOG_NUM + MAX_WIFI_INQTS_RAM_LOG_NUM + MAX_WIFI_NRGST_RAM_LOG_NUM;
				logn = MAX_WIFI_RGST_RAM_LOG_NUM + MAX_WIFI_INQTS_RAM_LOG_NUM + wifi_ram_log->nrgst_num;
			} else if (logm < MAX_WIFI_RGST_RAM_LOG_NUM + MAX_WIFI_INQTS_RAM_LOG_NUM + MAX_WIFI_NRGST_RAM_LOG_NUM + MAX_WIFI_NRGST_RAM_A_LOG_NUM) {
				logi = MAX_WIFI_RGST_RAM_LOG_NUM + MAX_WIFI_INQTS_RAM_LOG_NUM + MAX_WIFI_NRGST_RAM_LOG_NUM;
				logm = MAX_WIFI_RGST_RAM_LOG_NUM + MAX_WIFI_INQTS_RAM_LOG_NUM + MAX_WIFI_NRGST_RAM_LOG_NUM + MAX_WIFI_NRGST_RAM_A_LOG_NUM;
				logn = MAX_WIFI_RGST_RAM_LOG_NUM + MAX_WIFI_INQTS_RAM_LOG_NUM + MAX_WIFI_NRGST_RAM_LOG_NUM + wifi_ram_log->nrgstA_num;
//			} else if (logm < MAX_WIFI_RGST_RAM_LOG_NUM + MAX_WIFI_INQTS_RAM_LOG_NUM + MAX_WIFI_NRGST_RAM_A_LOG_NUM + MAX_WIFI_NRGST_RAM_B_LOG_NUM) {
//				logi = MAX_WIFI_RGST_RAM_LOG_NUM + MAX_WIFI_INQTS_RAM_LOG_NUM + MAX_WIFI_NRGST_RAM_A_LOG_NUM;
//				logm = MAX_WIFI_RGST_RAM_LOG_NUM + MAX_WIFI_INQTS_RAM_LOG_NUM + MAX_WIFI_NRGST_RAM_A_LOG_NUM + MAX_WIFI_NRGST_RAM_B_LOG_NUM;
//				logn = MAX_WIFI_RGST_RAM_LOG_NUM + MAX_WIFI_INQTS_RAM_LOG_NUM + MAX_WIFI_NRGST_RAM_A_LOG_NUM + wifi_ram_log->nrgstB_num;
			} else {
				break;
			}
			for (;logi<logn;logi++) {

				if (memcmp(mac, wifi_ram_log->wifi_node[logi].addr, 6) == 0) {
					memcpy(&entry, &(wifi_ram_log->wifi_node[logi]), sizeof(struct wifi_log_ram));
					free(wifi_ram_log);
					wifi_ram_log = NULL;
					return &entry;
				}
			}
		}
		free(wifi_ram_log);
		wifi_ram_log = NULL;
	} else {
		return NULL;
	}
}	

int accesstimer_guardmsg = 0;

// WNC-NMR0000-JDR230-HENG-I-CHEN-2014-01-05: Implement Access Timer feature #BEGIN
int getAccesstimer(request *wp, int argc, char **argv) {

	if (argv[0] == NULL) {
		return 0;
	} else if (strcmp(argv[0], "time") == 0) {
		time_t curtime;
		struct tm * tm_time;
		
		time(&curtime);
		tm_time = localtime(&curtime);
	
		return req_format_write(wp, "%.2d:%.2d", tm_time->tm_hour, tm_time->tm_min); //hh:mm
	} else if (strcmp(argv[0], "timeslot") == 0) {
		time_t curtime;
		struct tm * tm_time;
		
		time(&curtime);
		tm_time = localtime(&curtime);
	
		return req_format_write(wp, "%.2d:%.2d", tm_time->tm_hour, tm_time->tm_min/30*30); //hh:mm
	} else if (strcmp(argv[0], "state") == 0) {
		int enabled = 0;
		
		apmib_get(MIB_ACCESS_TIMER_ENABLED, (void *)&enabled);

		return req_format_write(wp, "%s", enabled?"enabled":"disabled");
	} else if (strcmp(argv[0], "wlsch_onoff") == 0) {
		int i;
		
		for(i=1; i<=MAX_SCHEDULE_NUM ; i++)
		{
			SCHEDULE_T entry;
			memset(&entry, '\0', sizeof(entry));
	
			*((char *)&entry) = (char)i;
			apmib_get(MIB_WLAN_SCHEDULE_TBL, (void *)&entry);
	
			if (entry.eco) {
				return req_format_write(wp, "1");
			}
		}
		return req_format_write(wp, "0");
	
	} else if (strcmp(argv[0], "list") == 0) {
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-01-12: Implement Access Timer feature #BEGIN
		int i, j, stanum = 0;      	
        mac_addr stalist[MAX_STA_NUM*2];
//        char tmpStr[8400];
//        char tmpStr2[6400];
		int ret = 0;
        char staStr[256];
        char buffer[256];
        int status;
        ACCESS_TIMER_T entry;
        INIQUITOUS_STA_T entry2;
        int entryNum;
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-01-27: Implement Access Timer feature #BEGIN
        struct tm* ctm;
       	time_t currentTime;
        int	cDay, cWeekDay, cTimeSlot;  
        unsigned char *todayTimer;
        int restrict_type;
        char untilStr[8];
		
		FILE *logfp;
 
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #BEGIN
        int band;
        int strength;
		
		mwf_table mwf_tbl;
		mwf_table_init(&mwf_tbl);
		mwf_entry *mwfp;
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #END
		currentTime = time(NULL);
		
		ctm = localtime(&currentTime);
		cDay = ctm->tm_year*10000 + ctm->tm_mon*100 + ctm->tm_mday;
		cWeekDay = ctm->tm_wday;
        cTimeSlot = ctm->tm_hour*2+ctm->tm_min/30;  
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-01-27: Implement Access Timer feature #END
		
//		strlcpy(tmpStr, "", sizeof(tmpStr));
//		strlcpy(tmpStr2, "", sizeof(tmpStr2));

		if ( !apmib_get(MIB_ACCESS_TIMER_TBL_NUM, (void *)&entryNum)) {
//  		strlcpy(tmpBuf, "Get table entry error!", sizeof(tmpStr));
			return -1;
		}

		for (i=1;i<=entryNum;i++) {
			*((char *)&entry) = (char)i;
			if ( !apmib_get(MIB_ACCESS_TIMER_TBL, (void *)&entry))
			{
				fprintf(stderr,"Get access timer entry fail\n");
				return -1;
			}
			
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-01-27: Implement Access Timer feature #BEGIN
			if (entry.category == 0) {
				restrict_type = 4;
				memset(untilStr, 0, 8);
			} else {
				switch(cWeekDay) {
					case 0:
						todayTimer = entry.timer_sun;
						break;		
					case 1:
						todayTimer = entry.timer_mon;
						break;		
					case 2:
						todayTimer = entry.timer_tue;
						break;		
					case 3:
						todayTimer = entry.timer_wed;
						break;		
					case 4:
						todayTimer = entry.timer_thu;
						break;		
					case 5:
						todayTimer = entry.timer_fri;
						break;		
					case 6:
						todayTimer = entry.timer_sat;
						break;
					default:
						todayTimer = NULL;		
				}
				
				if (todayTimer) {
					if (getTimeslot(todayTimer,cTimeSlot) == 1) {
						if (entry.timer_tmpday == cDay) {
							if (getTimeslot(entry.timer_tmp,cTimeSlot)) {
								restrict_type = 2;
								for(j=cTimeSlot+1;j<48;j++) {
									if (!getTimeslot(entry.timer_tmp, j) || 
										getTimeslot(todayTimer,j) == 0) {
										break;
									}
								}
							} else {
								restrict_type = 1;
								for(j=cTimeSlot+1;j<48;j++) {
									if (getTimeslot(entry.timer_tmp, j) ||
										getTimeslot(todayTimer, j) == 0 ) {
										break;
									}
								}
							}
						} else {
							restrict_type = 1;
							for(j=cTimeSlot+1;j<48;j++) {
								if (getTimeslot(todayTimer, j) == 0) {
									break;
								}
							}
						}
					} else if (getTimeslot(todayTimer,cTimeSlot) == 0) {
						if (entry.timer_tmpday == cDay) {
							if (getTimeslot(entry.timer_tmp,cTimeSlot)) {
								restrict_type = 3;
								for(j=cTimeSlot+1;j<48;j++) {
									if (!getTimeslot(entry.timer_tmp, j) ||
										getTimeslot(todayTimer, j) == 1) {
										break;
									}
								}
							} else {
								restrict_type = 0;
								for(j=cTimeSlot+1;j<48;j++) {
									if (getTimeslot(entry.timer_tmp, j) ||
										getTimeslot(todayTimer, j) == 1) {
										break;
									}
								}
							}
						} else {
							restrict_type = 0;
							for(j=cTimeSlot+1;j<48;j++) {
								if (getTimeslot(todayTimer, j) == 1) {
									break;
								}
							}
						}
					}
					snprintf(untilStr, sizeof(untilStr), "%.2d:%.2d", j/2, j%2*30);
				}
			}
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-01-27: Implement Access Timer feature #END

// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #BEGIN
//			memcpy(buffer, entry.name, 33);
//			translate_control_code_and_space(buffer);

			mwfp = find_mwf_entry(&mwf_tbl, entry.macAddr, MWF_CREATE);
			if (mwfp) {
				mwfp->registered = 1;
				mwfp->category = entry.category;
				strncpy(mwfp->name, entry.name, 33);
				mwfp->permit = restrict_type;
				strncpy(mwfp->timeinfo, untilStr, 8);
			}
//			status = 0;

//			for(j=0;j<stanum;j++) {
//				if (memcmp(stalist[j].addr, entry.macAddr, 6) == 0) {
//					status = 1;
//					stalist[j].status = 1;
//					band = stalist[j].band;
//					strength = signal_strength(stalist[j].band, stalist[j].ht_info, stalist[j].rssi);
//					break;
//				}
//			}
			
			
//			snprintf(staStr, sizeof(staStr), ", [\"%.2x:%.2x:%.2x:%.2x:%.2x:%.2x\", 1, %d, \"%s\", %d, \"%s\", %d, %d, %d, 0]\n",
//				entry.macAddr[0], entry.macAddr[1], entry.macAddr[2],
//				entry.macAddr[3], entry.macAddr[4], entry.macAddr[5], 
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-01-27: Implement Access Timer feature #BEGIN
//				entry.category, buffer, restrict_type, untilStr, status, band, strength);
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-01-27: Implement Access Timer feature #END
//			if (status) {
//				strlcat(tmpStr, staStr, sizeof(tmpStr));
//			} else {
//				strlcat(tmpStr2, staStr, sizeof(tmpStr2));
//			}
		}

		if ( !apmib_get(MIB_INIQUITOUS_STA_TBL_NUM, (void *)&entryNum)) {
//  		strlcpy(tmpBuf, "Get table entry error!", sizeof(tmpBuf));
			return -1;
		}

		for (i=1;i<=entryNum;i++) {
			*((char *)&entry2) = (char)i;
			if ( !apmib_get(MIB_INIQUITOUS_STA_TBL, (void *)&entry2))
			{
				fprintf(stderr,"Get iniquitous client entry fail\n");
				return -1;
			}

			mwfp = find_mwf_entry(&mwf_tbl, entry2.macAddr, MWF_CREATE);
			if (mwfp) {
				mwfp->registered = 1;
				mwfp->category = 2;
				strncpy(mwfp->name, entry2.name, 33);
				mwfp->permit = -1;
				strncpy(mwfp->timeinfo, "", 8);
			}
		}
#if 0 /* WNC-NMR2616-Libera-20160818-UMWA panel of unregistered only show from mwf database-move to below-start */ 
		stanum = getAssocatedStaions(stalist);                                                 
																							   
//		console_printf("%s %d stanum %d\n", __func__, __LINE__, stanum);
		usleep(100);
		
/*
		for(i=0;i<stanum;i++) {
			console_printf("%d %.2x:%.2x:%.2x:%.2x:%.2x:%.2x\n", i,
			stalist[i].addr[0], stalist[i].addr[1], stalist[i].addr[2],
			stalist[i].addr[3], stalist[i].addr[4], stalist[i].addr[5]);
		}
*/

//		strlcat(tmpStr, tmpStr2, sizeof(tmpStr));
		j = 1;
		for(i=0;i<stanum;i++) {
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Fix bug Wi-Fi management get connection status #BEGIN
//			if (stalist[i].status == 0) {
			if (stalist[i].status == 1) {
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Fix bug Wi-Fi management get connection status #END
//				char nameBuf[1024];
				
//				memset(nameBuf, 0, 1024);
//				getNameByDhcp(stalist[i].addr, nameBuf);
//				if (nameBuf[0] == 0) {
//					snprintf(nameBuf, sizeof(nameBuf), "ü%d", j++);
//				} else {
//					translate_control_code_and_space(nameBuf);
//				}
				
				mwfp = find_mwf_entry(&mwf_tbl, stalist[i].addr, MWF_CREATE);
				if (mwfp) {
					mwfp->connection = 1;
					mwfp->strength = signal_strength(stalist[i].band, stalist[i].ht_info, stalist[i].rssi);
					mwfp->band = stalist[i].band;
				}
				
//				snprintf(staStr, sizeof(staStr), ", [\"%.2x:%.2x:%.2x:%.2x:%.2x:%.2x\", 0, -1, \"%s\", 4, \"\", 1, %d, %d, 0]\n",
//					stalist[i].addr[0], stalist[i].addr[1], stalist[i].addr[2],
//					stalist[i].addr[3], stalist[i].addr[4], stalist[i].addr[5], nameBuf,
//					stalist[i].band, signal_strength(stalist[i].band, stalist[i].ht_info, stalist[i].rssi));
//				strlcat(tmpStr, staStr, sizeof(tmpStr));
			}
		}
#endif	/* WNC-NMR2616-Libera-20160818-UMWA panel of unregistered only show from mwf database-move to below-end */
		{
			int macFilterEntryNum=0;
			MACFILTER_T macFilterEntry;

			if ( !apmib_get(MIB_WLAN_MACAC_NUM, (void *)&macFilterEntryNum)) {
		  		fprintf(stderr, "Get table entry error!\n");
				return -1;
			}

			for (i=1; i<=macFilterEntryNum; i++) {
				*((char *)&macFilterEntry) = (char)i;
				if ( !apmib_get(MIB_WLAN_MACAC_ADDR, (void *)&macFilterEntry))
					return -1;

				mwfp = find_mwf_entry(&mwf_tbl, macFilterEntry.macAddr, MWF_CREATE);
				if (mwfp) {
					mwfp->macfilter = 1;
				}
			}
		}
		
		logfp = fopen("/dev/mtdblock2", "r");
		if (logfp) {
			int readlen = 0;
			int logi = 0, logm = 0, logn = 0;
			D_LOG_TB_Tp wifi_log = NULL;

			wifi_log = malloc(sizeof(D_LOG_TB_T));
			if (wifi_log == NULL) {
				fclose(logfp);
				return -1;
			}
			readlen = fread(wifi_log, sizeof(D_LOG_TB_T), 1, logfp);
			if (readlen != 1)
			{
				free(wifi_log);
				wifi_log = NULL;
				fclose(logfp);
				return -1;
			}
			
			fclose(logfp);
			
			while (logm < MAX_WIFI_LOG_NUM) {
			
				if (logm < MAX_WIFI_RGST_LOG_NUM) {
					logi = 0;
					logm = MAX_WIFI_RGST_LOG_NUM;
					logn = 0 + wifi_log->rgst_num;
				} else if (logm < MAX_WIFI_RGST_LOG_NUM + MAX_WIFI_INQTS_LOG_NUM) {
					logi = MAX_WIFI_RGST_LOG_NUM;
					logm = MAX_WIFI_RGST_LOG_NUM + MAX_WIFI_INQTS_LOG_NUM;
					logn = MAX_WIFI_RGST_LOG_NUM + wifi_log->inqts_num;
				} else if (logm < MAX_WIFI_RGST_LOG_NUM + MAX_WIFI_INQTS_LOG_NUM + MAX_WIFI_NRGST_LOG_NUM) {
					logi = MAX_WIFI_RGST_LOG_NUM + MAX_WIFI_INQTS_LOG_NUM;
					logm = MAX_WIFI_RGST_LOG_NUM + MAX_WIFI_INQTS_LOG_NUM + MAX_WIFI_NRGST_LOG_NUM;
					logn = MAX_WIFI_RGST_LOG_NUM + MAX_WIFI_INQTS_LOG_NUM + wifi_log->nrgst_num;
				} else {
					break;
				}
				for (;logi<logn;logi++) {
			
					mwfp = find_mwf_entry(&mwf_tbl, wifi_log->wifi_node[logi].addr, MWF_CREATE);
					if (mwfp) {
						if (mwfp->connection == 1)
							continue;
						if (strncmp(wifi_log->wifi_node[logi].date, "new", 15) == 0 ||
							strncmp(wifi_log->wifi_node[logi].date, "unspecified", 15) == 0 )
							continue;
						mwfp->connection = 2;
						if (wifi_log->wifi_node[logi].band == 2) {
							mwfp->band = MWF_BAND_2G;
						} else if (wifi_log->wifi_node[logi].band == 5) {
							mwfp->band = MWF_BAND_5G;
						}
					}
				}
			}
			free(wifi_log);
			wifi_log = NULL;
		}

		logfp = fopen("/var/wifi_sta_log", "r");
		if (logfp) {
			int readlen = 0;
			int logi = 0, logm = 0, logn = 0;
			D_LOG_rTB_Tp wifi_ram_log = NULL;

			wifi_ram_log = malloc(sizeof(D_LOG_rTB_T));
			if (wifi_ram_log == NULL) {
				fclose(logfp);
				return -1;
			}
			readlen = fread(wifi_ram_log, sizeof(D_LOG_rTB_T), 1, logfp);
			if (readlen != 1)
			{
				free(wifi_ram_log);
				wifi_ram_log = NULL;
				fclose(logfp);
				return -1;
			}
			
			fclose(logfp);
			
			while (logm < MAX_WIFI_RAM_LOG_NUM) {
			
				if (logm < MAX_WIFI_RGST_RAM_LOG_NUM) {
					logi = 0;
					logm = MAX_WIFI_RGST_RAM_LOG_NUM;
					logn = 0 + wifi_ram_log->rgst_num;
				} else if (logm < MAX_WIFI_RGST_RAM_LOG_NUM + MAX_WIFI_INQTS_RAM_LOG_NUM) {
					logi = MAX_WIFI_RGST_RAM_LOG_NUM;
					logm = MAX_WIFI_RGST_RAM_LOG_NUM + MAX_WIFI_INQTS_RAM_LOG_NUM;
					logn = MAX_WIFI_RGST_RAM_LOG_NUM + wifi_ram_log->inqts_num;
				} else if (logm < MAX_WIFI_RGST_RAM_LOG_NUM + MAX_WIFI_INQTS_RAM_LOG_NUM + MAX_WIFI_NRGST_RAM_LOG_NUM) {
					logi = MAX_WIFI_RGST_RAM_LOG_NUM + MAX_WIFI_INQTS_RAM_LOG_NUM;
					logm = MAX_WIFI_RGST_RAM_LOG_NUM + MAX_WIFI_INQTS_RAM_LOG_NUM + MAX_WIFI_NRGST_RAM_LOG_NUM;
					logn = MAX_WIFI_RGST_RAM_LOG_NUM + MAX_WIFI_INQTS_RAM_LOG_NUM + wifi_ram_log->nrgst_num;
				} else if (logm < MAX_WIFI_RGST_RAM_LOG_NUM + MAX_WIFI_INQTS_RAM_LOG_NUM + MAX_WIFI_NRGST_RAM_LOG_NUM + MAX_WIFI_NRGST_RAM_A_LOG_NUM) {
					logi = MAX_WIFI_RGST_RAM_LOG_NUM + MAX_WIFI_INQTS_RAM_LOG_NUM + MAX_WIFI_NRGST_RAM_LOG_NUM;
					logm = MAX_WIFI_RGST_RAM_LOG_NUM + MAX_WIFI_INQTS_RAM_LOG_NUM + MAX_WIFI_NRGST_RAM_LOG_NUM + MAX_WIFI_NRGST_RAM_A_LOG_NUM;
					logn = MAX_WIFI_RGST_RAM_LOG_NUM + MAX_WIFI_INQTS_RAM_LOG_NUM + MAX_WIFI_NRGST_RAM_LOG_NUM + wifi_ram_log->nrgstA_num;
//				} else if (logm < MAX_WIFI_RGST_RAM_LOG_NUM + MAX_WIFI_INQTS_RAM_LOG_NUM + MAX_WIFI_NRGST_RAM_A_LOG_NUM + MAX_WIFI_NRGST_RAM_B_LOG_NUM) {
//					logi = MAX_WIFI_RGST_RAM_LOG_NUM + MAX_WIFI_INQTS_RAM_LOG_NUM + MAX_WIFI_NRGST_RAM_A_LOG_NUM;
//					logm = MAX_WIFI_RGST_RAM_LOG_NUM + MAX_WIFI_INQTS_RAM_LOG_NUM + MAX_WIFI_NRGST_RAM_A_LOG_NUM + MAX_WIFI_NRGST_RAM_B_LOG_NUM;
//					logn = MAX_WIFI_RGST_RAM_LOG_NUM + MAX_WIFI_INQTS_RAM_LOG_NUM + MAX_WIFI_NRGST_RAM_A_LOG_NUM + wifi_ram_log->nrgstB_num;
				} else {
					break;
				}
				for (;logi<logn;logi++) {
			
					mwfp = find_mwf_entry(&mwf_tbl, wifi_ram_log->wifi_node[logi].addr, MWF_CREATE);
					if (mwfp) {
						if (mwfp->connection == 1)
							continue;
						if (wifi_ram_log->wifi_node[logi].band == 2) {
							mwfp->band = MWF_BAND_2G;
						} else if (wifi_ram_log->wifi_node[logi].band == 5) {
							mwfp->band = MWF_BAND_5G;
						}
						if (wifi_ram_log->wifi_node[logi].status != 0) 
							continue;
						/* NMR1605-20160426-Fix bug 1605 [Spider] Connected client is displayed as Failed client even if it doesn't try to connect-start */
						if (wifi_ram_log->wifi_node[logi].reason != 0) {
							mwfp->connection = -1;
						}
						/* NMR1605-20160426-Fix bug 1605 [Spider] Connected client is displayed as Failed client even if it doesn't try to connect-end */
						mwfp->fail_reason = wifi_ram_log->wifi_node[logi].reason;
					}
				}
			}
			free(wifi_ram_log);
			wifi_ram_log = NULL;
		}

#if 1 /* WNC-NMR2616-Libera-20160818-UMWA panel of unregistered only show from mwf database-move to below-start */ 
		stanum = getAssocatedStaions(stalist);                                                 
																							   
		//console_printf("%s %d stanum %d\n", __func__, __LINE__, stanum);
		usleep(100);
		
	/*	for(i=0;i<stanum;i++) {
			console_printf("%d %.2x:%.2x:%.2x:%.2x:%.2x:%.2x\n", i,
			stalist[i].addr[0], stalist[i].addr[1], stalist[i].addr[2],
			stalist[i].addr[3], stalist[i].addr[4], stalist[i].addr[5]);
		}
	*/

//		strlcat(tmpStr, tmpStr2, sizeof(tmpStr));
		j = 1;
		for(i=0;i<stanum;i++) {
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Fix bug Wi-Fi management get connection status #BEGIN
//			if (stalist[i].status == 0) {
			if (stalist[i].status == 1) {
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Fix bug Wi-Fi management get connection status #END
//				char nameBuf[1024];
				
//				memset(nameBuf, 0, 1024);
//				getNameByDhcp(stalist[i].addr, nameBuf);
//				if (nameBuf[0] == 0) {
//					snprintf(nameBuf, sizeof(nameBuf), "ü%d", j++);
//				} else {
//					translate_control_code_and_space(nameBuf);
//				}
				/* WNC-NMR2616-Libera-20160818-UMWA panel of unregistered only show from mwf database-start */
				//mwfp = find_mwf_entry(&mwf_tbl, stalist[i].addr, MWF_CREATE);
				mwfp = find_mwf_entry(&mwf_tbl, stalist[i].addr, 0);
				/* WNC-NMR2616-Libera-20160818-UMWA panel of unregistered only show from mwf database-end */
				if (mwfp) {
					mwfp->connection = 1;
					mwfp->strength = signal_strength(stalist[i].band, stalist[i].ht_info, stalist[i].rssi);
					mwfp->band = stalist[i].band;
				}
				
//				snprintf(staStr, sizeof(staStr), ", [\"%.2x:%.2x:%.2x:%.2x:%.2x:%.2x\", 0, -1, \"%s\", 4, \"\", 1, %d, %d, 0]\n",
//					stalist[i].addr[0], stalist[i].addr[1], stalist[i].addr[2],
//					stalist[i].addr[3], stalist[i].addr[4], stalist[i].addr[5], nameBuf,
//					stalist[i].band, signal_strength(stalist[i].band, stalist[i].ht_info, stalist[i].rssi));
//				strlcat(tmpStr, staStr, sizeof(tmpStr));
			}
		}
#endif	/* WNC-NMR2616-Libera-20160818-UMWA panel of unregistered only show from mwf database-move to below-end */
		
		for (i = 0; i < mwf_tbl.num; i++) {
			mwfp = &mwf_tbl.data[i];

			memcpy(buffer, mwfp->name, 33);
			translate_control_code_and_space(buffer);
			
// WNC-NMR01370-D2R031-HENG-I-CHEN-20160224: show always allow for unregister station #BEGIN
			if (mwfp->registered == 0) {
				mwfp->permit = 4;
				memset(mwfp->timeinfo, 0, 8);
			}
// WNC-NMR01370-D2R031-HENG-I-CHEN-20160224: show always allow for unregister station #END
			snprintf(staStr, sizeof(staStr), ", [\"%.2x:%.2x:%.2x:%.2x:%.2x:%.2x\", %d, %d, \"%s\", %d, \"%s\", %d, %d, %d, %d, %d]\n",
				mwfp->addr[0], mwfp->addr[1], mwfp->addr[2],
				mwfp->addr[3], mwfp->addr[4], mwfp->addr[5], 
				mwfp->registered, mwfp->category, buffer, mwfp->permit, mwfp->timeinfo,
				mwfp->connection, mwfp->band, mwfp->strength, mwfp->macfilter, mwfp->fail_reason);

		//	strlcat(tmpStr, staStr, sizeof(tmpStr));
			ret += req_format_write(wp, "%s", staStr);
		}
		mwf_table_free(&mwf_tbl);
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #END
		
//		return req_format_write(wp, "%s", tmpStr);
		return ret;
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-01-12: Implement Access Timer feature #END
	} else if (strcmp(argv[0], "regNum") == 0) {
        int entryNum = 0;

		if ( !apmib_get(MIB_ACCESS_TIMER_TBL_NUM, (void *)&entryNum)) {
			return -1;
		}

		return req_format_write(wp, "%d", entryNum);
	} else if (strcmp(argv[0], "guardmsg") == 0) {
		int ret = req_format_write(wp, "%d", accesstimer_guardmsg);
		accesstimer_guardmsg = 0;
		return ret;
	}
	return 0;
}

// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #BEGIN
int getIniquitousSta(request *wp, int argc, char **argv) {

	if (argv[0] == NULL) {
		return 0;
	} else if (strcmp(argv[0], "regNum") == 0) {
        int entryNum = 0;

		if ( !apmib_get(MIB_INIQUITOUS_STA_TBL_NUM, (void *)&entryNum)) {
			return -1;
		}

		return req_format_write(wp, "%d", entryNum);
	}
	return 0;
}
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #END

void formAccesstimerSet(request *wp, char *path, char *query) {
	//char *submitUrl,*strVal;
	char *strVal;
	int enabled = 0;

    SCHEDULE_T entry[MAX_SCHEDULE_NUM];

	//submitUrl = req_get_cstream_var(wp, ("submit-url"), "");
	strVal = req_get_cstream_var(wp, ("accesstimer_state"), "");
//	console_printf("%s %d accesstimer_state: %s\n", __FUNCTION__, __LINE__, strVal);
	if (strcmp(strVal, "enabled") == 0) {
		int i, j;
		int wlan_idx_keep = wlan_idx;
		char *wlanif[8];
		
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-01-12: Implement Access Timer feature #BEGIN
		memset(entry, '\0', (sizeof(SCHEDULE_T)*MAX_SCHEDULE_NUM));
		for(i=0; i<MAX_SCHEDULE_NUM ; i++)
		{

			*((char *)&entry[i]) = (char)(i+1);
			apmib_get(MIB_WLAN_SCHEDULE_TBL, (void *)&entry[i]);

			entry[i].eco = 0;
		}
	
		for(j=0; j<NUM_WLAN_INTERFACE ; j++)
		{
			char *wlanif[8];
			snprintf(wlanif, sizeof(wlanif), "wlan%d", j);
			
			SetWlan_idx(wlanif);
		
			if ( !apmib_set(MIB_WLAN_SCHEDULE_DELALL, (void *)&entry[0])) {
//				strlcpy(tmpBuf, ("Delete table entry error!"), sizeof(tmpBuf));
				goto setErr_AccesstimerSet;
			}

			for(i=0; i<MAX_SCHEDULE_NUM ; i++)
			{
				if ( apmib_set(MIB_WLAN_SCHEDULE_ADD, (void *)&entry[i]) == 0)
				{
//					strlcpy(tmpBuf, ("MIB_WLAN_SCHEDULE_ADD error!"), sizeof(tmpBuf));
					goto setErr_AccesstimerSet;
				}
			}
	
		}
		
		snprintf(wlanif, sizeof(wlanif), "wlan%d", wlan_idx_keep);
		SetWlan_idx(wlanif);

		enabled = 1;
		apmib_set(MIB_ACCESS_TIMER_ENABLED, (void *)&enabled);
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-01-12: Implement Access Timer feature #END
		
	} else {
		enabled = 0;
		apmib_set(MIB_ACCESS_TIMER_ENABLED, (void *)&enabled);
	}
	
	apmib_update_web(CURRENT_SETTING);

	//formRebootCheckAccessTimer(wp, path, query);
	//OK_MSG(submitUrl);
    //REBOOT_ACCESSTIMER(submitUrl);
	{
		char lan_ip_buf[30];
		char lan_ip[30];
		char *pMsg=NULL;
		int reboot_wait = 50;

		memset(lan_ip_buf, 0, 30);
		
		apmib_get( MIB_IP_ADDR,  (void *)lan_ip_buf) ;
		snprintf(lan_ip, sizeof(lan_ip),"%s",inet_ntoa(*((struct in_addr *)lan_ip_buf)) );
		OK_MSG_BEBOOT_ACCESSTIMER(pMsg,submitUrl,reboot_wait,lan_ip);
		sleep(1); 
		reboot_device();
	}    
setErr_AccesstimerSet:
	return;          
}
// WNC-NMR0000-JDR230-HENG-I-CHEN-2014-01-05: Implement Access Timer feature #END

// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-01-12: Implement Access Timer feature #BEGIN
ACCESS_TIMER_T temp_entry;
int newAccessTimerEntry = 0;
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #BEGIN
INIQUITOUS_STA_T temp_entry2;
mac_addr temp_entry3;
int manualAccessTimerEntry = 0;
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #END

// WNC-NMR0000-JDR230-HENG-I-CHEN-2014-01-05: Implement Access Timer feature #BEGIN
int getAccesstimerSta(request *wp, int argc, char **argv) {

	if (argv[0] == NULL) {
		return 0;
	} else if (strcmp(argv[0], "category") == 0) {
		int selected = 0;
		if (argc > 1) {
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #BEGIN
			if (newAccessTimerEntry == 1) {
				if (strcmp(argv[1], "new") == 0)
					selected = 1; 
			} else if (strcmp(argv[1], "adult") == 0) {
				if (temp_entry.category == 0)
					selected = 1; 
			} else if (strcmp(argv[1], "child") == 0) {
				if (temp_entry.category == 1)
					selected = 1; 
			} else if (strcmp(argv[1], "iniquitous") == 0) {
				if (temp_entry.category == 2)
					selected = 1; 
			} 
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #END
			return req_format_write(wp, "%s", selected?" selected":"");
		} else {
			int retValue;
			
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #BEGIN
			if (newAccessTimerEntry == 0) {
				switch(temp_entry.category) {
					case 0:
						retValue = 1;
						break;
					case 1:
						retValue = 2;
						break;
					case 2:
						retValue = 3;
						break;
					default:
						retValue = 0;
						break;
				}
			} else {
				retValue = 0;
			}
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #END
			return req_format_write(wp, "%d", retValue);
		}
	} else if (strcmp(argv[0], "new") == 0) {
		return req_format_write(wp, "%d", newAccessTimerEntry);
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #BEGIN
	} else if (strcmp(argv[0], "manual") == 0) {
		return req_format_write(wp, "%d", manualAccessTimerEntry);
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #END
	} else if (strcmp(argv[0], "addr") == 0) {
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #BEGIN
		if (manualAccessTimerEntry == 0) {
			return req_format_write(wp, "%.2x:%.2x:%.2x:%.2x:%.2x:%.2x",
				temp_entry.macAddr[0], temp_entry.macAddr[1], temp_entry.macAddr[2],
				temp_entry.macAddr[3], temp_entry.macAddr[4], temp_entry.macAddr[5]);
		} else {
			return req_format_write(wp, "");
		}
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #END
	} else if (strcmp(argv[0], "name") == 0) {
		char nameBuf[1024];
		memset(nameBuf, 0, 1024);
		strncpy(nameBuf, temp_entry.name, 32);
		/* WNC-NMR2584-Libera-20170725- space translate issue-rollback 2441-start */
		translate_control_code(nameBuf); 
		//translate_control_code_and_space(nameBuf);	//NMR2441:  fine tune for considering space character.
		/* WNC-NMR2584-Libera-20170725- space translate issue-rollback 2441-end */
		return req_format_write(wp, "%s", nameBuf);
// WNC-NMR0733-JDR231-HENG-I-CHEN-2014-08-26: Replace space character in name by &nbsp; #BEGIN
	} else if (strcmp(argv[0], "name2") == 0) {
		char nameBuf[1024];
		memset(nameBuf, 0, 1024);
		strncpy(nameBuf, temp_entry.name, 32);
		translate_control_code_and_space(nameBuf);
		return req_format_write(wp, "%s", nameBuf);
// WNC-NMR0733-JDR231-HENG-I-CHEN-2014-08-26: Replace space character in name by &nbsp; #END
	} else if (strcmp(argv[0], "namelist") == 0) {
        char tmpStr[6400];
        ACCESS_TIMER_T entry;
		INIQUITOUS_STA_T entry2;
        int entryNum = 0;
		char nameBuf[256];
		int i;
		int nn = 0;
		
		strlcpy(tmpStr, "[", sizeof(tmpStr));

		if ( !apmib_get(MIB_ACCESS_TIMER_TBL_NUM, (void *)&entryNum)) {
			fprintf(stderr, "Get table entry error!");
			return -1;
		}

		for (i=1;i<=entryNum;i++) {
			*((char *)&entry) = (char)i;
			if ( !apmib_get(MIB_ACCESS_TIMER_TBL, (void *)&entry))
			{
				fprintf(stderr,"Get access timer entry fail\n");
				return -1;
			}
			if (memcmp(entry.macAddr, temp_entry.macAddr, 6) == 0) {
				continue;
			}
			
			if (entry.name[0]) {
				if (nn != 0) {
					strlcat(tmpStr, ", ", sizeof(tmpStr));
				}
				strlcpy(nameBuf, ReplaceSpecialCharForJavaScript(entry.name), sizeof(nameBuf));
				strlcat(tmpStr, "\"", sizeof(tmpStr)); 
				strlcat(tmpStr, nameBuf, sizeof(tmpStr)); 
				strlcat(tmpStr, "\"", sizeof(tmpStr)); 
				nn ++;
			}
		}
		if ( !apmib_get(MIB_INIQUITOUS_STA_TBL_NUM, (void *)&entryNum)) {
			fprintf(stderr, "Get table entry error!");
			return -1;
		}

		for (i=1;i<=entryNum;i++) {
			*((char *)&entry2) = (char)i;
			if ( !apmib_get(MIB_INIQUITOUS_STA_TBL, (void *)&entry2))
			{
				fprintf(stderr,"Get iniquitout client entry fail\n");
				return -1;
			}
			if (memcmp(entry2.macAddr, temp_entry2.macAddr, 6) == 0) {
				continue;
			}
			
			if (entry2.name[0]) {
				if (nn != 0) {
					strlcat(tmpStr, ", ", sizeof(tmpStr));
				}
				strlcpy(nameBuf, ReplaceSpecialCharForJavaScript(entry2.name), sizeof(nameBuf));
				strlcat(tmpStr, "\"", sizeof(tmpStr)); 
				strlcat(tmpStr, nameBuf, sizeof(tmpStr)); 
				strlcat(tmpStr, "\"", sizeof(tmpStr)); 
				nn ++;
			}
		}
		strlcat(tmpStr, "]", sizeof(tmpStr));			
		return req_format_write(wp, "%s", tmpStr);
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #BEGIN
	} else if (strcmp(argv[0], "maclist") == 0) {
        char tmpStr[6400];
        ACCESS_TIMER_T entry;
		INIQUITOUS_STA_T entry2;
		int entryNum = 0;
		char strBuf[256];
		int i;
		int mn = 0;
		
		strlcpy(tmpStr, "[", sizeof(tmpStr));

		if ( !apmib_get(MIB_ACCESS_TIMER_TBL_NUM, (void *)&entryNum)) {
			fprintf(stderr, "Get table entry error!");
			return -1;
		}

		for (i=1;i<=entryNum;i++) {
			*((char *)&entry) = (char)i;
			if ( !apmib_get(MIB_ACCESS_TIMER_TBL, (void *)&entry))
			{
				fprintf(stderr,"Get access timer entry fail\n");
				return -1;
			}
			if (memcmp(entry.macAddr, temp_entry.macAddr, 6) == 0) {
				continue;
			}
			if (mn != 0) {
				strlcat(tmpStr, ", ", sizeof(tmpStr));
			}
			snprintf(strBuf, sizeof(strBuf), "%.2X:%.2X:%.2X:%.2X:%.2X:%.2X", 
				entry.macAddr[0], entry.macAddr[1], entry.macAddr[2],
				entry.macAddr[3], entry.macAddr[4], entry.macAddr[5]);
			strlcat(tmpStr, "\"", sizeof(tmpStr)); 
			strlcat(tmpStr, strBuf, sizeof(tmpStr)); 
			strlcat(tmpStr, "\"", sizeof(tmpStr)); 
			mn++;
		}

		if ( !apmib_get(MIB_INIQUITOUS_STA_TBL_NUM, (void *)&entryNum)) {
			fprintf(stderr, "Get table entry error!");
			return -1;
		}

		for (i=1;i<=entryNum;i++) {
			*((char *)&entry2) = (char)i;
			if ( !apmib_get(MIB_INIQUITOUS_STA_TBL, (void *)&entry2))
			{
				fprintf(stderr,"Get iniquitout client entry fail\n");
				return -1;
			}
			if (memcmp(entry2.macAddr, temp_entry2.macAddr, 6) == 0) {
				continue;
			}
			
			if (mn != 0) {
				strlcat(tmpStr, ", ", sizeof(tmpStr));
			}
			snprintf(strBuf, sizeof(strBuf), "%.2X:%.2X:%.2X:%.2X:%.2X:%.2X", 
				entry2.macAddr[0], entry2.macAddr[1], entry2.macAddr[2],
				entry2.macAddr[3], entry2.macAddr[4], entry2.macAddr[5]);
			strlcat(tmpStr, "\"", sizeof(tmpStr)); 
			strlcat(tmpStr, strBuf, sizeof(tmpStr)); 
			strlcat(tmpStr, "\"", sizeof(tmpStr)); 
			mn++;
		}
		strlcat(tmpStr, "]", sizeof(tmpStr));			
		return req_format_write(wp, "%s", tmpStr);
	} else if (strcmp(argv[0], "band") == 0) {
		char bandbuf[8] = "";
		if (memcmp(temp_entry3.addr, temp_entry.macAddr, 6) == 0) {
			if (temp_entry3.band == MWF_BAND_5G) {
				strlcpy(bandbuf, "5G", sizeof(bandbuf));
				if (temp_entry3.vap == MWF_VAP_PRIMARY_SSID) {
					strlcat(bandbuf, "pri", sizeof(bandbuf));
				} else if (temp_entry3.vap == MWF_VAP_SECONDARY_SSID) {
					strlcat(bandbuf, "sec", sizeof(bandbuf));
				}
			} else if (temp_entry3.band == MWF_BAND_2G) {
				strlcpy(bandbuf, "2G", sizeof(bandbuf));
				if (temp_entry3.vap == MWF_VAP_PRIMARY_SSID) {
					strlcat(bandbuf, "pri", sizeof(bandbuf));
				} else if (temp_entry3.vap == MWF_VAP_SECONDARY_SSID) {
					strlcat(bandbuf, "sec", sizeof(bandbuf));
				}
			}
		}
		return req_format_write(wp, "%s", bandbuf);
	} else if (strcmp(argv[0], "singal_strength") == 0) {
		int ss = 0;
		if (temp_entry3.status == 1 && memcmp(temp_entry3.addr, temp_entry.macAddr, 6) == 0) {
			ss = signal_strength(temp_entry3.band, temp_entry3.ht_info, temp_entry3.rssi);
		}
		return req_format_write(wp, "%d", ss);
	} else if (strcmp(argv[0], "network") == 0) {
		if (temp_entry3.status == 1 && memcmp(temp_entry3.addr, temp_entry.macAddr, 6) == 0) {
			char netStr[64];
			if (temp_entry3.network & BAND_5G_11AC) {
				strlcpy(netStr, "11ac", sizeof(netStr));
			} else if (temp_entry3.network & BAND_11N) {
				strlcpy(netStr, "11n", sizeof(netStr));
			} else if (temp_entry3.network & BAND_11A) {
				strlcpy(netStr, "11a", sizeof(netStr));
			} else if (temp_entry3.network & BAND_11G) {
				strlcpy(netStr, "11g", sizeof(netStr));
			} else if (temp_entry3.network & BAND_11B) {
				strlcpy(netStr, "11b", sizeof(netStr));
			}
			return req_format_write(wp, "%s", netStr);
		}
	} else if (strcmp(argv[0], "channel") == 0) {
		if (temp_entry3.status == 1 && memcmp(temp_entry3.addr, temp_entry.macAddr, 6) == 0) {
			return req_format_write(wp, "%s", getStaChannel(temp_entry3.chan, temp_entry3.ht_info, temp_entry3.sndchoff));
		}
	} else if (strcmp(argv[0], "conn_status") == 0) {
		int cs = 0;
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Fix bug Wi-Fi management get connection status #BEGIN
		if (memcmp(temp_entry3.addr, temp_entry.macAddr, 6) == 0) {
			cs = temp_entry3.status;
		}
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Fix bug Wi-Fi management get connection status #END
		return req_format_write(wp, "%d", cs);
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #END
	} else if (strcmp(argv[0], "ssid") == 0) {

		if (temp_entry3.status == 1 && memcmp(temp_entry3.addr, temp_entry.macAddr, 6) == 0) {
			char tmpbuf[256] = "";
	
			memset(tmpbuf, 0, 256);
			strncpy(tmpbuf, temp_entry3.ssid, MAX_SSID_LEN);
			translate_control_code_and_space(tmpbuf);
			return req_format_write(wp, "%s", tmpbuf);
		}
	} else if (strcmp(argv[0], "encrypt") == 0) {

		if (temp_entry3.status == 1 && memcmp(temp_entry3.addr, temp_entry.macAddr, 6) == 0) {
			char encBuf[256] = "";
			if (temp_entry3.encrypt & BIT(0)) {
				if (temp_entry3.encrypt & BIT(4) && temp_entry3.encrypt & BIT(5)) {
					strlcpy(encBuf, "WPA/WPA2", sizeof(encBuf));
				} else if (temp_entry3.encrypt & BIT(5)) {
					strlcpy(encBuf, "WPA2", sizeof(encBuf));
				} else if (temp_entry3.encrypt & BIT(4)) {
					strlcpy(encBuf, "WPA", sizeof(encBuf));
				}
				
				if (temp_entry3.encrypt & BIT(8)) {
					strlcat(encBuf, "-PSK", sizeof(encBuf));
				}

				if (temp_entry3.encrypt & BIT(6) && temp_entry3.encrypt & BIT(7)) {
					strlcat(encBuf, "(TKIP/AES)", sizeof(encBuf));
				} else if (temp_entry3.encrypt & BIT(6)) {
					strlcat(encBuf, "(TKIP)", sizeof(encBuf));
				} else if (temp_entry3.encrypt & BIT(7)) {
					strlcat(encBuf, "(AES)", sizeof(encBuf));
				}
// WNC-NMR01800-D2R031-HENG-I-CHEN-20161006: Add WEP encryption #BEGIN
			} else if (temp_entry3.encrypt & BIT(2)) {
				strlcpy(encBuf, "WEP", sizeof(encBuf));
				if (temp_entry3.encrypt & BIT(3)) {
					strlcat(encBuf, "(128bit)", sizeof(encBuf));
				} else {
					strlcat(encBuf, "(64bit)", sizeof(encBuf));
				}
// WNC-NMR01800-D2R031-HENG-I-CHEN-20161006: Add WEP encryption #END
			} else {
				strlcpy(encBuf, "None", sizeof(encBuf));
			}
			return req_format_write(wp, "%s", encBuf);
		}
	} else if (strcmp(argv[0], "first") == 0) {

		if (memcmp(temp_entry3.addr, temp_entry.macAddr, 6) == 0) {
			return req_format_write(wp, "{ 'year':%d, 'month':%d, 'day':%d, 'hour':%d, 'minute':%d }", 
				temp_entry3.first.tm_year, temp_entry3.first.tm_mon, temp_entry3.first.tm_mday, 
				temp_entry3.first.tm_hour, temp_entry3.first.tm_min);
		} else {
			return req_format_write(wp, "undefined");
		}
	} else if (strcmp(argv[0], "always_notify") == 0) {
		int always_notify = 0;

		if (memcmp(temp_entry3.addr, temp_entry.macAddr, 6) == 0) {
			always_notify = temp_entry3.always_notify;
		}
		return req_format_write(wp, "%d", always_notify);
	} else if (strcmp(argv[0], "fail_reason") == 0) {
		int fail_reason = 0;

		if (memcmp(temp_entry3.addr, temp_entry.macAddr, 6) == 0) {
			fail_reason = temp_entry3.fail_reason;
		}
		return req_format_write(wp, "%d", fail_reason);
	}
	return 0;
}

void parse_date(char *datestr, struct tm *temp_tm) {

	char *cp;
	char tempBuf[8] = "";
	
	memset (temp_tm, 0, sizeof(struct tm));
	cp = datestr;
	
	strncpy(tempBuf, cp, 4);
	tempBuf[4] = 0;
	temp_tm->tm_year = atoi(tempBuf);
	cp+=4;
	strncpy(tempBuf, cp, 2);
	tempBuf[2] = 0;
	temp_tm->tm_mon = atoi(tempBuf);
	cp+=2;
	strncpy(tempBuf, cp, 2);
	tempBuf[2] = 0;
	temp_tm->tm_mday = atoi(tempBuf);
	cp+=2;
	strncpy(tempBuf, cp, 2);
	tempBuf[2] = 0;
	temp_tm->tm_hour = atoi(tempBuf);
	cp+=2;
	strncpy(tempBuf, cp, 2);
	tempBuf[2] = 0;
	temp_tm->tm_min = atoi(tempBuf);
}

// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #BEGIN
int getMwfEntry(char* macStr) {

	unsigned char mac[6];
	int entryNum = 0;
	int i = 0;
	mac_addr stalist[MAX_STA_NUM*2];
	int stanum = 0;

	ACCESS_TIMER_T at_entry;
	INIQUITOUS_STA_T is_entry;
	struct wifi_log wl_entry;
	struct wifi_log_ram *wlr_entry = NULL;

	newAccessTimerEntry = 1;
	memset(&temp_entry, 0, sizeof(ACCESS_TIMER_T));
	memset(&temp_entry2, 0, sizeof(INIQUITOUS_STA_T));
	memset(&temp_entry3, 0, sizeof(mac_addr));
	temp_entry.category = -1;

// WNC-NMR01365-D2R031-HENG-I-CHEN-20160224: fix Wifi Management add new station #BEGIN
	if (macStr != NULL ) {
		if (*macStr == 0)
			return 0;
// WNC-NMR01365-D2R031-HENG-I-CHEN-20160224: fix Wifi Management add new station #BEGIN

		if (macStrToBin(mac, macStr) < 0) {
			fprintf(stderr,"Wrong station address\n");
			return -1;
		}
	
		memcpy(temp_entry.macAddr, mac, 6);

		if ( !apmib_get(MIB_ACCESS_TIMER_TBL_NUM, (void *)&entryNum)) {
	//  		strlcpy(tmpBuf, "Get table entry error!", sizeof(tmpBuf));
			return -1;
		}
	
		for (i=1;i<=entryNum;i++) {
			*((char *)&at_entry) = (char)i;
			if ( !apmib_get(MIB_ACCESS_TIMER_TBL, (void *)&at_entry))
			{
				fprintf(stderr,"Get access timer entry fail\n");
				return -1;
			}
			if (memcmp(mac, at_entry.macAddr, 6) == 0) {
				break;
			}
		}
	
		if (i <= entryNum ) {
			memcpy(&temp_entry, &at_entry, sizeof( ACCESS_TIMER_T ));
			newAccessTimerEntry = 0;
			
			if (get_wfbk_Data(mac, REGISTER_OFFSET, &wl_entry) == 0) {
				memcpy(temp_entry3.addr, mac, 6);
				if (strncmp(wl_entry.date, "new", 15) != 0) {
					temp_entry3.status = 2;
					if (strncmp(wl_entry.date, "unspecified", 15) != 0) {
						parse_date(wl_entry.date, &(temp_entry3.first));
					}
					if (wl_entry.band == 2) {
						temp_entry3.band = MWF_BAND_2G;
					} else if (wl_entry.band == 5) {
						temp_entry3.band = MWF_BAND_5G;
					}
				}
				if (wl_entry.ntf_tp[0] == 'n') {
					temp_entry3.always_notify = 1;
				} else {
					temp_entry3.always_notify = 0;
				}
			}
			 
		} else {
			if ( !apmib_get(MIB_INIQUITOUS_STA_TBL_NUM, (void *)&entryNum)) {
	//  		strlcpy(tmpBuf, "Get table entry error!", sizeof(tmpBuf));
				return -1;
			}
		
			for (i=1;i<=entryNum;i++) {
				*((char *)&is_entry) = (char)i;
				if ( !apmib_get(MIB_INIQUITOUS_STA_TBL, (void *)&is_entry))
				{
					fprintf(stderr,"Get iniquitous client entry fail\n");
					return -1;
				}
				if (memcmp(mac, is_entry.macAddr, 6) == 0) {
					newAccessTimerEntry = 0;
					memset(&temp_entry, 0, sizeof(ACCESS_TIMER_T));
					memcpy(&temp_entry2, &is_entry, sizeof(INIQUITOUS_STA_T));
					memcpy(temp_entry.macAddr, is_entry.macAddr, 6);
					strlcpy(temp_entry.name, is_entry.name, sizeof(temp_entry.name));
					temp_entry.category = 2;

					if (get_wfbk_Data(mac, INIQUITOUS_OFFSET, &wl_entry) == 0) {
						memcpy(temp_entry3.addr, mac, 6);		
						if (strncmp(wl_entry.date, "new", 15) != 0) {
							temp_entry3.status = 2;
							if (strncmp(wl_entry.date, "unspecified", 15) != 0) {
								parse_date(wl_entry.date, &(temp_entry3.first));
							}
							if (wl_entry.band == 2) {
								temp_entry3.band = MWF_BAND_2G;
							} else if (wl_entry.band == 5) {
								temp_entry3.band = MWF_BAND_5G;
							}
						}
						if (wl_entry.ntf_tp[0] == 'n') {
							temp_entry3.always_notify = 1;
						} else {
							temp_entry3.always_notify = 0;
						}
					}
					break;
				}
			}
		
			if (i > entryNum) {
				memset(&temp_entry, 0, sizeof(ACCESS_TIMER_T));
				memcpy(temp_entry.macAddr, mac, 6);
				getNameByDhcp(mac, temp_entry.name);
				temp_entry.category = -1;
//				getNameByDhcp(temp_entry.macAddr, temp_entry.name);
				if (get_wfbk_Data(mac, NO_REGISTER_OFFSET, &wl_entry) == 0) {
					memcpy(temp_entry3.addr, mac, 6);
					if (strncmp(wl_entry.date, "new", 15) != 0) {
						temp_entry3.status = 2;
						if (strncmp(wl_entry.date, "unspecified", 15) != 0) {
							parse_date(wl_entry.date, &(temp_entry3.first));
						}
						if (wl_entry.band == 2) {
							temp_entry3.band = MWF_BAND_2G;
						} else if (wl_entry.band == 5) {
							temp_entry3.band = MWF_BAND_5G;
						}
					}
					if (wl_entry.ntf_tp[0] == 'n') {
						temp_entry3.always_notify = 1;
					} else {
						temp_entry3.always_notify = 0;
					}
				}
			}
		}

		wlr_entry = get_wifi_log_ram_entry(mac);
		if (wlr_entry) {
			if (wlr_entry->band == 2) {
				temp_entry3.band = MWF_BAND_2G;
			} else if (wlr_entry->band == 5) {
				temp_entry3.band = MWF_BAND_5G;
			}
			/* NMR1605-20160426-Fix bug 1605 [Spider] Connected client is displayed as Failed client even if it doesn't try to connect */
			if (wlr_entry->status == 0 && wlr_entry->reason != 0)	{
				memcpy(temp_entry3.addr, mac, 6);
				temp_entry3.status = -1;
				temp_entry3.fail_reason = wlr_entry->reason;
			}
		}

		stanum = getAssocatedStaions(stalist);

// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Fix bug Wi-Fi management get connection status #BEGIN
//		console_printf("getAssocatedStaions get %d stations\n", stanum);

		for(i=0;i<stanum;i++) {
//			console_printf("%d %.2x:%.2x:%.2x:%.2x:%.2x:%.2x status : %d\n", i,
//			stalist[i].addr[0], stalist[i].addr[1], stalist[i].addr[2],
//			stalist[i].addr[3], stalist[i].addr[4], stalist[i].addr[5],
//			stalist[i].status);
			
			if (stalist[i].status != 0 && memcmp(mac, stalist[i].addr, 6) == 0) {
				memcpy(&temp_entry3, &stalist[i], sizeof(mac_addr)-sizeof(int)-sizeof(struct tm));
//				if (temp_entry3.status == 2) {
//					struct tm first = temp_entry3.first;
//					memcpy(&temp_entry3, &stalist[i], sizeof(mac_addr));
//					temp_entry3.first = first;
//				} else {
//					memcpy(&temp_entry3, &stalist[i], sizeof(mac_addr));
//				}
				break;				
			}
		}
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Fix bug Wi-Fi management get connection status #END
	}
	return 0;
}
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #END

void formAccesstimerStaSet(request *wp, char *path, char *query) {
	//char *submitUrl,*strVal;
	char *strVal;
	int i;
	unsigned char sta_mac[6];
	int entryNum = 0;

	//submitUrl = req_get_cstream_var(wp, ("submit-url"), "");
	strVal = req_get_cstream_var(wp, ("sta"), "");

// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #BEGIN
	if (*strVal == 0) {
		manualAccessTimerEntry = 1;
	} else {
		manualAccessTimerEntry = 0;
	}
	
	if (getMwfEntry(strVal) < 0)
		return -1;
	
	send_redirect_perm(wp, MWF_REGISTER_PAGE);
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #END
		
	return;
}

int mwf_mac_filter_act_ssid(int act, unsigned char *mac) {
	int i, entryNum=0;
	MACFILTER_T entry;

	if ( !apmib_get(MIB_WLAN_MACAC_NUM, (void *)&entryNum)) {
  		fprintf(stderr, "Get table entry error!\n");
		return -1;
	}
	
	for (i=entryNum; i>0; i--) {
		
		*((char *)&entry) = (char)i;
		apmib_get(MIB_WLAN_MACAC_ADDR, (void *)&entry);
		
		if(!memcmp(entry.macAddr, mac, 6)){
			if (act == 0) {
				apmib_set(MIB_WLAN_AC_ADDR_DEL, (void *)&entry);
			}
			return 0;
		}
	}
	
	if (act == 1) {
		memset(&entry, 0, sizeof(MACFILTER_T));
		memcpy(entry.macAddr, mac, 6);
		apmib_set(MIB_WLAN_AC_ADDR_ADD, (void *)&entry);
	}
	
	return 0;
}

int mwf_mac_filter_act(int act, unsigned char *mac) {

	int ri, vi = 0;
	int if_num = 3;	/* NMR2203-20161227-[request]-Unite condition in each operation mode about UMWA and MAC filter*/
	/* WNC-NMR2496-Libera-20170712 - feature: [wdf:wifi_notify] add entry command for rakuraku-start */
	int temp_wlan_idx=0, temp_vwlan_idx=0;
	
	temp_wlan_idx=wlan_idx;
	temp_vwlan_idx=vwlan_idx;
	/* WNC-NMR2496-Libera-20170712 - feature: [wdf:wifi_notify] add entry command for rakuraku-end */
	for (ri=0; ri<NUM_WLAN_INTERFACE; ri++) {
		unsigned char wlanif[10];

		/* NMR2203-20161227-[request]-Unite condition in each operation mode about UMWA and MAC filter-start */
		if (access("/tmp/MODE_RPT", F_OK) == 0) {
			system("rm /tmp/MIB_MAPPING");
		}
		/* NMR2203-20161227-[request]-Unite condition in each operation mode about UMWA and MAC filter-end */
		//for (vi = 1; vi < 2; vi ++ ) {
		//for (vi = 0; vi < 2; vi ++ ) {	/* WNC-NMR1847-[Aero]-20160923- Accesstimer/UMWA: consider wlanx -v2 */
		for (vi = 0; vi < if_num; vi ++ ) {	/* NMR2203-20161227-[request]-Unite condition in each operation mode about UMWA and MAC filter*/	
			if (vi == 0)
				snprintf(wlanif, sizeof(wlanif), "wlan%d", ri);
			else
				snprintf(wlanif, sizeof(wlanif), "wlan%d-va%d", ri, vi-1);

			console_printf("set wlan to %s\n", wlanif);
			SetWlan_idx(wlanif);
			mwf_mac_filter_act_ssid(act, mac);
		}
		/* NMR2203-20161227-[request]-Unite condition in each operation mode about UMWA and MAC filter-start */
		if (access("/tmp/MODE_RPT", F_OK) == 0) {
			system("touch /tmp/MIB_MAPPING");
		}
		/* NMR2203-20161227-[request]-Unite condition in each operation mode about UMWA and MAC filter-end */
	}

	/* WNC-NMR2496-Libera-20170712 - feature: [wdf:wifi_notify] add entry command for rakuraku-start */
	wlan_idx=temp_wlan_idx;
	vwlan_idx=temp_vwlan_idx;
	/* WNC-NMR2496-Libera-20170712 - feature: [wdf:wifi_notify] add entry command for rakuraku-end */
}

void formAccesstimerStaReg(request *wp, char *path, char *query) {
	char *submitUrl,*strVal;
	int i;
	int hb, lb;
	unsigned char sta_mac[6];
	int entryNum = 0;
	ACCESS_TIMER_T entry;
	int action = -1;
	int scheduleReset = 0;
// WNC-NMR0666-JDR231-HENG-I-CHEN-2014-05-16: Save after confirm that popup in setting page #BEGIN
	int goToScheduler = 0;
// WNC-NMR0666-JDR231-HENG-I-CHEN-2014-05-16: Save after confirm that popup in setting page #END
	int get_wifi_log = 0;
	struct wifi_log wl_entry;
	/*[WDF] 1processing: trigger sent log-start */
	unsigned char	ntf_tp_old[2];
	char cmdBuffer[128]={0};
	struct wifi_log_ram wifi_data_r;
	memset(ntf_tp_old, '\0', sizeof(ntf_tp_old));	/* WNC-NMR1615-[Spider]-Libera-20160512-not sent notification after track function turns ON*/
	/*[WDF] 1processing: trigger sent log-end */

	memset(&wl_entry, 0, sizeof(struct wifi_log));

	submitUrl = req_get_cstream_var(wp, ("submit-url"), "");
	strVal = req_get_cstream_var(wp, ("addr"), "");

// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #BEGIN
	if (macStrToBin(sta_mac, strVal) < 0) {
		fprintf(stderr,"Wrong station address\n");
		return;
	}
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #BEGIN

// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #BEGIN
	if (manualAccessTimerEntry == 1) {
		memcpy(temp_entry.macAddr, sta_mac, 6);
// WNC-NMR01365-D2R031-HENG-I-CHEN-20160224: fix Wifi Management add new station #BEGIN
		manualAccessTimerEntry = 0;
// WNC-NMR01365-D2R031-HENG-I-CHEN-20160224: fix Wifi Management add new station #END
	} else {
		if (memcmp(sta_mac, temp_entry.macAddr, 6) != 0) {
			accesstimer_guardmsg = 6;

			if (strcmp(submitUrl, "../kodomo_frame.html") == 0) {
				return req_format_write(wp, "<script> top.redirectTo(\"%s\"); location.href=\"./kodomo_frame.html\"; </script>", MWF_PORTAL_PAGE);
			} else { 
				return send_redirect_perm(wp, MWF_PORTAL_PAGE);
			}
		}
	}
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #END

	strVal = req_get_cstream_var(wp, ("scheduleReset"), "");
	scheduleReset = atoi(strVal);
	if (scheduleReset > 0) {
		memset(temp_entry.timer_sun, 0xFF, 6);
		memset(temp_entry.timer_mon, 0xFF, 6);
		memset(temp_entry.timer_tue, 0xFF, 6);
		memset(temp_entry.timer_wed, 0xFF, 6);
		memset(temp_entry.timer_thu, 0xFF, 6);
		memset(temp_entry.timer_fri, 0xFF, 6);
		memset(temp_entry.timer_sat, 0xFF, 6);
		memset(temp_entry.timer_tmp, 0x00, 6);
	} else if (scheduleReset < 0) {
		memset(temp_entry.timer_sun, 0x00, 6);
		memset(temp_entry.timer_mon, 0x00, 6);
		memset(temp_entry.timer_tue, 0x00, 6);
		memset(temp_entry.timer_wed, 0x00, 6);
		memset(temp_entry.timer_thu, 0x00, 6);
		memset(temp_entry.timer_fri, 0x00, 6);
		memset(temp_entry.timer_sat, 0x00, 6);
		memset(temp_entry.timer_tmp, 0x00, 6);
	}
	
	strVal = req_get_cstream_var(wp, ("action"), "");
	
	action = atoi(strVal);
	if (action > 0) {
		strVal = req_get_cstream_var(wp, ("name"), "");
		memset(temp_entry.name, 0, 33);
		strncpy(temp_entry.name, strVal, 32);
		strVal = req_get_cstream_var(wp, ("category"), "");
		if (strcmp(strVal, "adult") == 0) {
			temp_entry.category = 0;
		} else if (strcmp(strVal, "child") == 0) {
			if (temp_entry.category != 1) {
				memset(temp_entry.timer_sun, 0x00, 6);
				memset(temp_entry.timer_mon, 0x00, 6);
				memset(temp_entry.timer_tue, 0x00, 6);
				memset(temp_entry.timer_wed, 0x00, 6);
				memset(temp_entry.timer_thu, 0x00, 6);
				memset(temp_entry.timer_fri, 0x00, 6);
				memset(temp_entry.timer_sat, 0x00, 6);
				memset(temp_entry.timer_tmp, 0x00, 6);
			}
			temp_entry.category = 1;
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #BEGIN
		} else if (strcmp(strVal, "iniquitous") == 0) {
			temp_entry.category = 2;
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #END
		}
// WNC-NMR0666-JDR231-HENG-I-CHEN-2014-05-16: Save after confirm that popup in setting page #BEGIN
		strVal = req_get_cstream_var(wp, ("goToScheduler"), "");
		goToScheduler = atoi(strVal);
// WNC-NMR0666-JDR231-HENG-I-CHEN-2014-05-16: Save after confirm that popup in setting page #BEGIN
	}

// WNC-NMR0666-JDR231-HENG-I-CHEN-2014-05-16: Save after confirm that popup in setting page #BEGIN
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-01-27: Implement Access Timer feature #BEGIN
//	if ((action == 2 ) || (action == 1 && temp_entry.category == 1 && newAccessTimerEntry == 1)) {
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-01-27: Implement Access Timer feature #END
//		send_redirect_perm(wp, ACCESS_TIMER_SCHEDULE_PAGE);
//		req_format_write(wp, "<script>  top.redirectTo(\"%s\"); location.href=\"./kodomo_frame.html\";  </script>", ACCESS_TIMER_SCHEDULE_PAGE);
//		req_format_write(wp, "<script> parent.showOK(\"%s\"); location.href=\"./kodomo_frame.html\";  </script>", ACCESS_TIMER_SCHEDULE_PAGE);
//
//		return;
//	} else 	if (action == 3) {
//		send_redirect_perm(wp, ACCESS_TIMER_TEMPORARY_PAGE);
//		req_format_write(wp, "<script>  top.redirectTo(\"%s\"); location.href=\"./kodomo_frame.html\";  </script>", ACCESS_TIMER_TEMPORARY_PAGE);
//		req_format_write(wp, "<script> parent.showOK(\"%s\"); location.href=\"./kodomo_frame.html\";  </script>", ACCESS_TIMER_TEMPORARY_PAGE);
//
//		return;
//	} 
// WNC-NMR0666-JDR231-HENG-I-CHEN-2014-05-16: Save after confirm that popup in setting page #END

	if ( !apmib_get(MIB_ACCESS_TIMER_TBL_NUM, (void *)&entryNum)) {
//  		strlcpy(tmpBuf, "Get table entry error!", sizeof(tmpBuf));
		return;
	}
	
	for (i=1;i<=entryNum;i++) {
		*((char *)&entry) = (char)i;
		if ( !apmib_get(MIB_ACCESS_TIMER_TBL, (void *)&entry))
		{
			fprintf(stderr,"Get access timer entry fail\n");
			return;
		}
		if (memcmp(sta_mac, entry.macAddr, 6) == 0) {
			break;
		}
	}
	
	if (i <= entryNum ) {
		if ( !apmib_set(MIB_ACCESS_TIMER_DEL, (void *)&entry)) {
			fprintf(stderr, "Delete table entry error!");
			return;
		}
		mwf_mac_filter_act(0, sta_mac);
		if (get_wfbk_Data(sta_mac, REGISTER_OFFSET, &wl_entry) == 0) {
			get_wifi_log = 1;
			strncpy(ntf_tp_old,wl_entry.ntf_tp,1);	/*[WDF] 1processing: trigger sent log */
			delete_from_wfbk_flash(sta_mac, REGISTER_OFFSET);
		}
	}

// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #BEGIN
	if ( !apmib_get(MIB_INIQUITOUS_STA_TBL_NUM, (void *)&entryNum)) {
//  		strlcpy(tmpBuf, "Get table entry error!", sizeof(tmpBuf));
		return;
	}
	
	for (i=1;i<=entryNum;i++) {
		*((char *)&entry) = (char)i;
		if ( !apmib_get(MIB_INIQUITOUS_STA_TBL, (void *)&entry))
		{
			fprintf(stderr,"Get iniquitous client entry fail\n");
			return;
		}
		if (memcmp(sta_mac, entry.macAddr, 6) == 0) {
			break;
		}
	}
	
	if (i <= entryNum ) {
		if ( !apmib_set(MIB_INIQUITOUS_STA_DEL, (void *)&entry)) {
			fprintf(stderr, "Delete table entry error!");
			return;
		}
		if (get_wfbk_Data(sta_mac, INIQUITOUS_OFFSET, &wl_entry) == 0) {
			get_wifi_log = 1;
			strncpy(ntf_tp_old,wl_entry.ntf_tp,1);	/*[WDF] 1processing: trigger sent log */
			delete_from_wfbk_flash(sta_mac, INIQUITOUS_OFFSET);
		}
		
	}
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #END

		if ( !apmib_get(MIB_ACCESS_TIMER_TBL_NUM, (void *)&entryNum)) {
//  		strlcpy(tmpBuf, "Get table entry error!", sizeof(tmpBuf));
			return -1;
		}

	if (get_wifi_log == 0) {
		if (get_wfbk_Data(sta_mac, NO_REGISTER_OFFSET, &wl_entry) == 0) {
			strncpy(ntf_tp_old,wl_entry.ntf_tp,1);	/*[WDF] 1processing: trigger sent log */
			get_wifi_log = 1;
			delete_from_wfbk_flash(sta_mac, NO_REGISTER_OFFSET);
		}
	}

//	if (get_wifi_log)
	//{
		char *valBuf;
		int always_notify = 0;
		char char_notify = 'r';
		
		valBuf = req_get_cstream_var(wp, ("WIFI_NOTIFICATION"), "off");
		if (strcmp(valBuf, "on") == 0)
			always_notify = 1;
		else 
			always_notify = 0;

/* [WDF]: if ON/OFF of "Notification of the second or later connection" is changed.--> clear notification has sent-start */
		if (!strcmp(ntf_tp_old,"r")){
			if(always_notify==1){
				/* update notify flag in RAM-> 0 */
				console_printf("[WDF][%s] track function is change! update notify flag in RAM-> 0 ,line=%d\n",__FUNCTION__,__LINE__);
				if(update_to_wfbk_ram(sta_mac,CLEAR_R_NOTIFY_FLAG, 0)){
					printf("[WDF][formAccesstimerStaReg] ERROR: update_to_wfbk_ram NG!, line=%d\n",__LINE__);
					return -1;
				}
			}
		}else{
			if(always_notify!=1){
				/* update notify flag in RAM-> 0 */
				console_printf("[WDF][%s] track function is change! update notify flag in RAM-> 0 ,line=%d\n",__FUNCTION__,__LINE__);
				if(update_to_wfbk_ram(sta_mac,CLEAR_R_NOTIFY_FLAG, 0)){
					printf("[WDF][formAccesstimerStaReg] ERROR: update_to_wfbk_ram NG!, line=%d\n",__LINE__);
					return -1;
				}
			}
		}
/* [WDF]: if ON/OFF of "Notification of the second or later connection" is changed.--> clear notification has sent-end */
		if (always_notify) {
			char_notify = 'n';
			if (get_wifi_log == 0) {
				memcpy(wl_entry.addr, sta_mac, MACADDRLEN);
				strlcpy(wl_entry.date, "new", sizeof(wl_entry.date));
				//wl_entry.is_1st_notify_sent = 0;
				get_wifi_log = 1;
			}
		}
		wl_entry.ntf_tp[0] = char_notify;
	//}

	if (action != 0) {
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #BEGIN
		if ( temp_entry.category == 2 ) {
			memset(&temp_entry2, 0, sizeof(INIQUITOUS_STA_T));
			memcpy(temp_entry2.macAddr, temp_entry.macAddr, 6);
			strlcpy(temp_entry2.name, temp_entry.name, sizeof(temp_entry2.name));

			if ( !apmib_set(MIB_INIQUITOUS_STA_ADD, (void *)&temp_entry2)) {
				fprintf(stderr, "Add table entry error!");
				return;
			}
			if (get_wifi_log) {
				update_to_wfbk_flash(&wl_entry, INIQUITOUS_OFFSET, sizeof(struct wifi_log));
			}
		} else {
			if ( !apmib_set(MIB_ACCESS_TIMER_ADD, (void *)&temp_entry)) {
				fprintf(stderr, "Add table entry error!");
				return;
			}
			mwf_mac_filter_act(1, sta_mac);
			if (get_wifi_log) {
				update_to_wfbk_flash(&wl_entry, REGISTER_OFFSET, sizeof(struct wifi_log));
			}
		}
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #END
//	} else {
//		if (get_wifi_log) {
//			update_to_wfbk_flash(&wl_entry, NO_REGISTER_OFFSET, sizeof(struct wifi_log));
//		}
	}


	/*[WDF] 1processing: trigger sent log-start */
	if (always_notify) {
		if(!memcmp(ntf_tp_old,"r",1)){
			int cs = 0;
			int band =0;
			if (memcmp(temp_entry3.addr, temp_entry.macAddr, 6) == 0) {
				cs = temp_entry3.status;
			}
			printf("[%s] connect_status(cs)=%d, line=%d\n",__FUNCTION__,cs,__LINE__);
			if (cs==1){
				/* update to /var/wifi_notification/wifi_event */
				memset(cmdBuffer,0, sizeof(cmdBuffer));
				snprintf(cmdBuffer, sizeof(cmdBuffer), "echo \"MAC:%02x%02x%02x%02x%02x%02x\" > %s",sta_mac[0], sta_mac[1], sta_mac[2],
					sta_mac[3], sta_mac[4], sta_mac[5], POSITION_OF_WIFI_EVENT);
				system(cmdBuffer);

				if (!get_r_wfbk_Data(sta_mac,UPDATE_R_ALL,&wifi_data_r)){
					/*[WDF] 1processing: trigger sent log */
					printf("[WDF][formAccesstimerStaReg] got get_r_wfbk_Data ok!\n");
					
				}else{
					printf("[WDF][formAccesstimerStaReg] without this MAC in flash or Error.\n");
				}
				if(wifi_data_r.band == 5){
					band=1;
				}else{
					band=0;
						}
				snprintf(cmdBuffer, sizeof(cmdBuffer), "echo \"ifname:wlan%d-va0\" >> %s",band, POSITION_OF_WIFI_EVENT);
				system(cmdBuffer);
				system("killall -SIGUSR1 wdf");
			}
		}
	}	
	/*[WDF] 1processing: trigger sent log-end */

	struct wifi_log_ram *wlr_entry = NULL;

	wlr_entry = get_wifi_log_ram_entry(sta_mac);
	if (wlr_entry) {
		if (action != 0) {
			struct wifi_log_ram wlr_temp_entry;
	
			memcpy(&wlr_temp_entry, wlr_entry, sizeof(struct wifi_log_ram));
			delete_from_wfbk_ram(sta_mac, UPDATE_R_ALL);
			if (temp_entry.category == 0 || temp_entry.category == 1) {
				update_to_wfbk_ram(&wlr_temp_entry, REGISTER_OFFSET, sizeof(struct wifi_log_ram));
			} else if (temp_entry.category == 2 ) {
				update_to_wfbk_ram(&wlr_temp_entry, INIQUITOUS_OFFSET, sizeof(struct wifi_log_ram));
			}
		} else {
			delete_from_wfbk_ram(sta_mac, UPDATE_R_ALL);
		}
	}


    apmib_update_web(CURRENT_SETTING);
	system("/bin/accesstimer &");

// WNC-NMR0666-JDR231-HENG-I-CHEN-2014-05-16: Save after confirm that popup in setting page #BEGIN
	if (action == 0) {	// delete some STA from UMWA.
		/* WNC-NMR1632-[Spider]-Libera-20160503-new function: kick connecting STA-Author:hengi-start */
		sleep(5);	//accesstimer prepare.../* NMR2224-[Aero]-Libera-20161230- give enough time to prepare D-ACL in driver. */
		int ifi = 0;
		char cmdbuf[64] = "";
		/*WNC-NMR1736-[Aero/Thalys]-Libera-20160606- responsive GUI porting: Accesstimer/UMWA: consider wlanx -start */
		if (access("/tmp/MODE_RPT", F_OK) == 0) {	//RPT mode
			for ( ifi = 0; ifi < NUM_WLAN_INTERFACE; ifi++) {
				snprintf (cmdbuf, sizeof(cmdbuf), "iwpriv wlan%d-va0 set_mib kick_mac=%.2x%.2x%.2x%.2x%.2x%.2x", 
					ifi, sta_mac[0], sta_mac[1], sta_mac[2], sta_mac[3], sta_mac[4], sta_mac[5]);
				system(cmdbuf);
				//printf("@@ cmdbuf:%s, Func: %s, Line: %d @@\n",cmdbuf, __FUNCTION__ , __LINE__);
			}
		}else if ((access("/tmp/MODE_RPT", F_OK) != 0) && (access("/tmp/MODE_CNV", F_OK) != 0)) {	//RT/BR mode
			for ( ifi = 0; ifi < NUM_WLAN_INTERFACE; ifi++) {
				snprintf (cmdbuf, sizeof(cmdbuf), "iwpriv wlan%d set_mib kick_mac=%.2x%.2x%.2x%.2x%.2x%.2x", 
					ifi, sta_mac[0], sta_mac[1], sta_mac[2], sta_mac[3], sta_mac[4], sta_mac[5]);
				system(cmdbuf);
				//printf("@@ cmdbuf:%s, Func: %s, Line: %d @@\n",cmdbuf, __FUNCTION__ , __LINE__);
				snprintf (cmdbuf, sizeof(cmdbuf), "iwpriv wlan%d-va0 set_mib kick_mac=%.2x%.2x%.2x%.2x%.2x%.2x", 
					ifi, sta_mac[0], sta_mac[1], sta_mac[2], sta_mac[3], sta_mac[4], sta_mac[5]);
				system(cmdbuf);
				//printf("@@ cmdbuf:%s, Func: %s, Line: %d @@\n",cmdbuf, __FUNCTION__ , __LINE__);
			}
		}
		/*WNC-NMR1736-[Aero/Thalys]-Libera-20160606- responsive GUI porting: Accesstimer/UMWA: consider wlanx -end */		

		
		/* WNC-NMR1632-[Spider]-Libera-20160503-new function: kick connecting STA-Author:hengi-end */
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #BEGIN
		send_redirect_perm(wp, MWF_PORTAL_PAGE);
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #END
	} else if (action == 1) {
		if (temp_entry.category == 0) {
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #BEGIN
			req_format_write(wp, "<script> parent.showOK(\"%s\"); location.href=\"./kodomo_frame.html\";  </script>", MWF_PORTAL_PAGE);
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #END
		} else if (newAccessTimerEntry == 0) {
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #BEGIN
//			send_redirect_perm(wp, MWF_PORTAL_PAGE);
			req_format_write(wp, "<script> parent.showOK(\"%s\"); location.href=\"./kodomo_frame.html\";  </script>", MWF_PORTAL_PAGE);
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #END
		} else if (goToScheduler == 1) {
			send_redirect_perm(wp, ACCESS_TIMER_SCHEDULE_PAGE);
		} else {
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #BEGIN
//			send_redirect_perm(wp, MWF_PORTAL_PAGE);
			req_format_write(wp, "<script> parent.showOK(\"%s\"); location.href=\"./kodomo_frame.html\";  </script>", MWF_PORTAL_PAGE);
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #END
		}
	} else if (action == 2 ) {
		send_redirect_perm(wp, ACCESS_TIMER_SCHEDULE_PAGE);
	} else if (action == 3 ) {
		send_redirect_perm(wp, ACCESS_TIMER_TEMPORARY_PAGE);
	}
// WNC-NMR0666-JDR231-HENG-I-CHEN-2014-05-16: Save after confirm that popup in setting page #END

	return;
}
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-01-12: Implement Access Timer feature #END
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-01-27: Implement Access Timer feature #BEGIN
char *toBitStr(unsigned char *data, int len) {
	static bitString[4096];
	int i;
	char *cp;
	
	memset(bitString, 0, 4096);
	cp = bitString;
	for(i=0;i<len;i++) {
		if(data[i] & 0x80) {
			*cp++ = '1';	
		} else {
			*cp++ = '0';	
		}
		if(data[i] & 0x40) {
			*cp++ = '1';	
		} else {
			*cp++ = '0';	
		}
		if(data[i] & 0x20) {
			*cp++ = '1';	
		} else {
			*cp++ = '0';	
		}
		if(data[i] & 0x10) {
			*cp++ = '1';	
		} else {
			*cp++ = '0';	
		}
		if(data[i] & 0x08) {
			*cp++ = '1';	
		} else {
			*cp++ = '0';	
		}
		if(data[i] & 0x04) {
			*cp++ = '1';	
		} else {
			*cp++ = '0';	
		}
		if(data[i] & 0x02) {
			*cp++ = '1';	
		} else {
			*cp++ = '0';	
		}
		if(data[i] & 0x01) {
			*cp++ = '1';	
		} else {
			*cp++ = '0';	
		}
	}
	*cp = 0;
	return bitString;	
}

// WNC-NMR0598-HENG-I-CHEN-20160811-Don't update MIB to flash when only temporary permit changed #BEGIN
int accessTimerEntrySaveCheck(ACCESS_TIMER_T *old, ACCESS_TIMER_T *new) {
	ACCESS_TIMER_T old_entry, new_entry;

	memcpy(&old_entry, old, sizeof(ACCESS_TIMER_T));
	memcpy(&new_entry, new, sizeof(ACCESS_TIMER_T));

	old_entry.timer_tmpday = 0;
	memset(old_entry.timer_tmp, 0x00, 6);
	new_entry.timer_tmpday = 0;
	memset(new_entry.timer_tmp, 0x00, 6);

	return memcmp(&old_entry, &new_entry, sizeof(ACCESS_TIMER_T));
}
// WNC-NMR0598-HENG-I-CHEN-20160811-Don't update MIB to flash when only temporary permit changed #END

int accessTimerAddEntry(void) {
	int i, entryNum = 0;
	ACCESS_TIMER_T entry;
// WNC-NMR0598-HENG-I-CHEN-20160811-Don't update MIB to flash when only temporary permit changed #BEGIN
	int needSave = 1;
// WNC-NMR0598-HENG-I-CHEN-20160811-Don't update MIB to flash when only temporary permit changed #END
	
	if ( !apmib_get(MIB_ACCESS_TIMER_TBL_NUM, (void *)&entryNum)) {
		fprintf(stderr, "Get table entry error!");
		return -1;
	}
	
	for (i=1;i<=entryNum;i++) {
		*((char *)&entry) = (char)i;
		if ( !apmib_get(MIB_ACCESS_TIMER_TBL, (void *)&entry))
		{
			fprintf(stderr,"Get access timer entry fail\n");
			return -1;
		}
		if (memcmp(temp_entry.macAddr, entry.macAddr, 6) == 0) {
			break;
		}
	}
	
	if (i <= entryNum ) {
// WNC-NMR0598-HENG-I-CHEN-20160811-Don't update MIB to flash when only temporary permit changed #BEGIN
		needSave = accessTimerEntrySaveCheck(&entry, &temp_entry);
// WNC-NMR0598-HENG-I-CHEN-20160811-Don't update MIB to flash when only temporary permit changed #END
		if ( !apmib_set(MIB_ACCESS_TIMER_DEL, (void *)&entry)) {
			fprintf(stderr, "Delete table entry error!");
			return -1;
		}
	}
	
	if ( !apmib_set(MIB_ACCESS_TIMER_ADD, (void *)&temp_entry)) {
		fprintf(stderr, "Add table entry error!");
		return -1;
	}

// WNC-NMR0598-HENG-I-CHEN-20160811-Don't update MIB to flash when only temporary permit changed #BEGIN
	if (needSave) {
	    apmib_update_web(CURRENT_SETTING);
	}
// WNC-NMR0598-HENG-I-CHEN-20160811-Don't update MIB to flash when only temporary permit changed #END

	system("/bin/accesstimer &");
    return 0;
}

int getAccesstimerSchedule(request *wp, int argc, char **argv) {
	if (argv[0] == NULL) {
		return 0;
	} else if (strcmp(argv[0], "userlist") == 0) {
		int i;      	
        char tmpStr[8192];
        char nameBuf[256];
        ACCESS_TIMER_T entry;
        int entryNum = 0 ;

		strlcpy(tmpStr, "", sizeof(tmpStr));

		if ( !apmib_get(MIB_ACCESS_TIMER_TBL_NUM, (void *)&entryNum)) {
			return -1;
		}

		for (i=1;i<=entryNum;i++) {
			*((char *)&entry) = (char)i;
			if ( !apmib_get(MIB_ACCESS_TIMER_TBL, (void *)&entry))
			{
				fprintf(stderr,"Get access timer entry fail\n");
				return -1;
			}
			
			if (memcmp(temp_entry.macAddr, entry.macAddr, 6) == 0) {
				continue;
			}
			
			if (entry.category == 0) {
				continue;
			}

			memset(nameBuf, 0, 256);
			strncpy(nameBuf, entry.name, 32);
			translate_control_code_and_space(nameBuf);
			strlcat(tmpStr, "<option>", sizeof(tmpStr));
			strlcat(tmpStr, nameBuf, sizeof(tmpStr));
			strlcat(tmpStr, "</option>\n", sizeof(tmpStr));
		}

		return req_format_write(wp, "%s", tmpStr);

	} else if (strcmp(argv[0], "schedule") == 0) {
		int i;      	
        char tmpStr[512];

		memset(tmpStr, 0, sizeof(tmpStr));
		strlcpy(tmpStr, "var InitSet = {\n", sizeof(tmpStr));
		strlcat(tmpStr, "'ID_SUN':'", sizeof(tmpStr));
		strncat(tmpStr, toBitStr(temp_entry.timer_sun, 6), 48);
		strlcat(tmpStr, "',\n", sizeof(tmpStr));
		strlcat(tmpStr, "'ID_MON':'", sizeof(tmpStr));
		strncat(tmpStr, toBitStr(temp_entry.timer_mon, 6), 48);
		strlcat(tmpStr, "',\n", sizeof(tmpStr));
		strlcat(tmpStr, "'ID_TUE':'", sizeof(tmpStr));
		strncat(tmpStr, toBitStr(temp_entry.timer_tue, 6), 48);
		strlcat(tmpStr, "',\n", sizeof(tmpStr));
		strlcat(tmpStr, "'ID_WED':'", sizeof(tmpStr));
		strncat(tmpStr, toBitStr(temp_entry.timer_wed, 6), 48);
		strlcat(tmpStr, "',\n", sizeof(tmpStr));
		strlcat(tmpStr, "'ID_THU':'", sizeof(tmpStr));
		strncat(tmpStr, toBitStr(temp_entry.timer_thu, 6), 48);
		strlcat(tmpStr, "',\n", sizeof(tmpStr));
		strlcat(tmpStr, "'ID_FRI':'", sizeof(tmpStr));
		strncat(tmpStr, toBitStr(temp_entry.timer_fri, 6), 48);
		strlcat(tmpStr, "',\n", sizeof(tmpStr));
		strlcat(tmpStr, "'ID_SAT':'", sizeof(tmpStr));
		strncat(tmpStr, toBitStr(temp_entry.timer_sat, 6), 48);
		strlcat(tmpStr, "'\n};\n", sizeof(tmpStr));

		return req_format_write(wp, "%s", tmpStr);

	} else if (strcmp(argv[0], "copylist") == 0) {
		int i,j;      	
        char tmpStr[512];
//        char staStr[512];
        ACCESS_TIMER_T entry;
        int entryNum = 0;

		strlcpy(tmpStr, "", sizeof(tmpStr));

		if ( !apmib_get(MIB_ACCESS_TIMER_TBL_NUM, (void *)&entryNum)) {
//  		strlcpy(tmpBuf, "Get table entry error!", sizeof(tmpBuf));
			return -1;
		}

		j = 1;
		for (i=1;i<=entryNum;i++) {
			*((char *)&entry) = (char)i;
			if ( !apmib_get(MIB_ACCESS_TIMER_TBL, (void *)&entry))
			{
				fprintf(stderr,"Get access timer entry fail\n");
				return -1;
			}
			
			if (memcmp(temp_entry.macAddr, entry.macAddr, 6) == 0) {
				continue;
			}
			
			if (entry.category == 0) {
				continue;
			}

			snprintf(tmpStr, sizeof(tmpStr), "var Copy%d = {\n", j);
			strlcat(tmpStr, "'ID_SUN':'", sizeof(tmpStr));
			strncat(tmpStr, toBitStr(entry.timer_sun, 6), 48);
			strlcat(tmpStr, "',\n", sizeof(tmpStr));
			strlcat(tmpStr, "'ID_MON':'", sizeof(tmpStr));
			strncat(tmpStr, toBitStr(entry.timer_mon, 6), 48);
			strlcat(tmpStr, "',\n", sizeof(tmpStr));
			strlcat(tmpStr, "'ID_TUE':'", sizeof(tmpStr));
			strncat(tmpStr, toBitStr(entry.timer_tue, 6), 48);
			strlcat(tmpStr, "',\n", sizeof(tmpStr));
			strlcat(tmpStr, "'ID_WED':'", sizeof(tmpStr));
			strncat(tmpStr, toBitStr(entry.timer_wed, 6), 48);
			strlcat(tmpStr, "',\n", sizeof(tmpStr));
			strlcat(tmpStr, "'ID_THU':'", sizeof(tmpStr));
			strncat(tmpStr, toBitStr(entry.timer_thu, 6), 48);
			strlcat(tmpStr, "',\n", sizeof(tmpStr));
			strlcat(tmpStr, "'ID_FRI':'", sizeof(tmpStr));
			strncat(tmpStr, toBitStr(entry.timer_fri, 6), 48);
			strlcat(tmpStr, "',\n", sizeof(tmpStr));
			strlcat(tmpStr, "'ID_SAT':'", sizeof(tmpStr));
			strncat(tmpStr, toBitStr(entry.timer_sat, 6), 48);
			strlcat(tmpStr, "'\n};\n", sizeof(tmpStr));
			req_format_write(wp, "%s", tmpStr);
			j++;
		}

		return 0;
	}
	return 0;
}

int getScheduleByte(char *cp) {
	char convertStr[9];
	int value;
	
	if (strlen(cp) < 8)
		return -1;
	
	memset(convertStr, 0, 9);

	strncpy(convertStr, cp, 8);
	
	value = strtol(convertStr, NULL, 2);

	if (value > 0xFF)
		value = -1;
		
	return value;	
}

void formAccessstimerSchedulerSet(request *wp, char *path, char *query) {
	//char *submitUrl,*strVal;
	char *strVal;
	char *cp;
	int i,j;
	int ret;
	int tmp_wday = -1;
	int hb, lb;
	unsigned char sta_mac[6];

	//submitUrl = req_get_cstream_var(wp, ("submit-url"), "");

	strVal = req_get_cstream_var(wp, ("addr"), "");
	for (i=0;i<6;i++) {
		hb =  getHex(strVal[i*3]);
		lb =  getHex(strVal[i*3+1]);
		if (hb < 0 || lb < 0)
		{
			fprintf(stderr,"Wrong station address\n");
			return;
		}
		sta_mac[i] = hb*16+lb;
	}
	
	if (memcmp(sta_mac, temp_entry.macAddr, 6) != 0) {
		accesstimer_guardmsg = 6;
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #BEGIN
		return req_format_write(wp, "<script>  top.redirectTo(\"%s\"); location.href=\"./kodomo_frame.html\";  </script>", MWF_PORTAL_PAGE);
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #END
	}

	if (temp_entry.timer_tmpday) {
		struct tm* ctm;
		time_t currentTime;
		int today;
 
		currentTime = time(NULL);
		ctm = localtime(&currentTime);
		today = ctm->tm_year *10000 + ctm->tm_mon *100 + ctm->tm_mday;
		if (today != temp_entry.timer_tmpday) {
			temp_entry.timer_tmpday = 0;
		} else {
			tmp_wday = ctm->tm_wday;
		}
	}
	
	strVal = req_get_cstream_var(wp, ("sun"), "");
	cp = strVal;
	for (i=0;i<6;i++) {
		ret = getScheduleByte(cp);
		if (ret < 0)
			return -1;
		if (tmp_wday == 0) {
			temp_entry.timer_tmp[i] ^= ((temp_entry.timer_sun[i] ^ ret) & temp_entry.timer_tmp[i]);
		}
		temp_entry.timer_sun[i] = ret;
		cp+=8;
	}
	strVal = req_get_cstream_var(wp, ("mon"), "");
	cp = strVal;
	for (i=0;i<6;i++) {
		ret = getScheduleByte(cp);
		if (ret < 0)
			return -1;
		if (tmp_wday == 1) {
			temp_entry.timer_tmp[i] ^= ((temp_entry.timer_mon[i] ^ ret) & temp_entry.timer_tmp[i]);
		}
		temp_entry.timer_mon[i] = ret;
		cp+=8;
	}
	strVal = req_get_cstream_var(wp, ("tue"), "");
	cp = strVal;
	for (i=0;i<6;i++) {
		ret = getScheduleByte(cp);
		if (ret < 0)
			return -1;
		if (tmp_wday == 2) {
			temp_entry.timer_tmp[i] ^= ((temp_entry.timer_tue[i] ^ ret) & temp_entry.timer_tmp[i]);
		}
		temp_entry.timer_tue[i] = ret;
		cp+=8;
	}
	strVal = req_get_cstream_var(wp, ("wed"), "");
	cp = strVal;
	for (i=0;i<6;i++) {
		ret = getScheduleByte(cp);
		if (ret < 0)
			return -1;
		if (tmp_wday == 3) {
			temp_entry.timer_tmp[i] ^= ((temp_entry.timer_wed[i] ^ ret) & temp_entry.timer_tmp[i]);
		}
		temp_entry.timer_wed[i] = ret;
		cp+=8;
	}
	strVal = req_get_cstream_var(wp, ("thu"), "");
	cp = strVal;
	for (i=0;i<6;i++) {
		ret = getScheduleByte(cp);
		if (ret < 0)
			return -1;
		if (tmp_wday == 4) {
			temp_entry.timer_tmp[i] ^= ((temp_entry.timer_thu[i] ^ ret) & temp_entry.timer_tmp[i]);
		}
		temp_entry.timer_thu[i] = ret;
		cp+=8;
	}
	strVal = req_get_cstream_var(wp, ("fri"), "");
	cp = strVal;
	for (i=0;i<6;i++) {
		ret = getScheduleByte(cp);
		if (ret < 0)
			return -1;
		if (tmp_wday == 5) {
			temp_entry.timer_tmp[i] ^= ((temp_entry.timer_fri[i] ^ ret) & temp_entry.timer_tmp[i]);
		}
		temp_entry.timer_fri[i] = ret;
		cp+=8;
	}
	strVal = req_get_cstream_var(wp, ("sat"), "");
	cp = strVal;
	for (i=0;i<6;i++) {
		ret = getScheduleByte(cp);
		if (ret < 0)
			return -1;
		if (tmp_wday == 6) {
			temp_entry.timer_tmp[i] ^= ((temp_entry.timer_sat[i] ^ ret) & temp_entry.timer_tmp[i]);
		}
		temp_entry.timer_sat[i] = ret;
		cp+=8;
	}
	
	if (accessTimerAddEntry() < 0)
		return -1;
	
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #BEGIN
	//send_redirect_perm(wp, MWF_PORTAL_PAGE);
	req_format_write(wp, "<script> parent.showOK(\"%s\"); location.href=\"./kodomo_frame.html\"; </script>", MWF_PORTAL_PAGE);
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #END
	return 0;
	
}
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-01-27: Implement Access Timer feature #END

// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-02-06: Implement Access Timer feature #BEGIN
int getAccesstimerTemporary(request *wp, int argc, char **argv) {

	if (argv[0] == NULL) {
		return 0;
	} else if (strcmp(argv[0], "weekday") == 0) {
        struct tm* ctm;
       	time_t currentTime;
       	char tmpStr[8];
 
		currentTime = time(NULL);
		
		ctm = localtime(&currentTime);
		switch(ctm->tm_wday) {
			case 0:
				strlcpy(tmpStr,"'sun'", sizeof(tmpStr));
				break;
			case 1:
				strlcpy(tmpStr,"'mon'", sizeof(tmpStr));
				break;
			case 2:
				strlcpy(tmpStr,"'tue'", sizeof(tmpStr));
				break;
			case 3:
				strlcpy(tmpStr,"'wed'", sizeof(tmpStr));
				break;
			case 4:
				strlcpy(tmpStr,"'thu'", sizeof(tmpStr));
				break;
			case 5:
				strlcpy(tmpStr,"'fri'", sizeof(tmpStr));
				break;
			case 6:
				strlcpy(tmpStr,"'sat'", sizeof(tmpStr));
				break;
			default:
				strlcpy(tmpStr,"false", sizeof(tmpStr));
				break;
				
		}
		return req_format_write(wp, "%s", tmpStr);

	} else if (strcmp(argv[0], "permit") == 0) {
       	char tmpStr[256];
		
		memset(tmpStr, 0, 256);
		if (temp_entry.timer_tmpday) {
			struct tm* ctm;
			time_t currentTime;
			int today;
 
			currentTime = time(NULL);
			ctm = localtime(&currentTime);
			today = ctm->tm_year *10000 + ctm->tm_mon *100 + ctm->tm_mday;
			if (today != temp_entry.timer_tmpday) {
				temp_entry.timer_tmpday = 0;
			}
		}
		
		if (temp_entry.timer_tmpday) {
			snprintf(tmpStr, sizeof(tmpStr), "var TempPermit = \"%s\";\n", toBitStr(temp_entry.timer_tmp, 6));
		} else {
			strlcpy(tmpStr, "var TempPermit = \"", sizeof(tmpStr));
			//memset(tmpStr+strlen(tmpStr), '0', 48);
			memset(tmpStr+strlen(tmpStr), 0x30, 48);	/* WNC-NMR000-[Linear]-Libera-20140926-coverity-error-894- NO_EFFECT */
			strlcat(tmpStr, "\";\n", sizeof(tmpStr));
		}
		
		return req_format_write(wp, "%s", tmpStr);
	}
	return 0;
}

void formAccessstimerTemporarySet(request *wp, char *path, char *query) {
	//char *submitUrl,*strVal;
	char *strVal;
	char *cp;
	int i,j;
	int ret;

	int hb, lb;
	unsigned char sta_mac[6];
	unsigned char original[6];
	unsigned char *current;
	int setweek;

	//submitUrl = req_get_cstream_var(wp, ("submit-url"), "");

	strVal = req_get_cstream_var(wp, ("addr"), "");
	for (i=0;i<6;i++) {
		hb =  getHex(strVal[i*3]);
		lb =  getHex(strVal[i*3+1]);
		if (hb < 0 || lb < 0)
		{
			fprintf(stderr,"Wrong station address\n");
			return;
		}
		sta_mac[i] = hb*16+lb;
	}
	
	if (memcmp(sta_mac, temp_entry.macAddr, 6) != 0) {
		accesstimer_guardmsg = 6;
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #BEGIN
		return req_format_write(wp, "<script>  top.redirectTo(\"%s\"); location.href=\"./kodomo_frame.html\";  </script>", MWF_PORTAL_PAGE);
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #END
	}

	strVal = req_get_cstream_var(wp, ("week"), "");
	if (strcmp(strVal, "sun") == 0) {
		setweek = 0;
		current = temp_entry.timer_sun; 
	} else if (strcmp(strVal, "mon") == 0) {
		setweek = 1;
		current = temp_entry.timer_mon; 
	} else if (strcmp(strVal, "tue") == 0) {
		setweek = 2;
		current = temp_entry.timer_tue; 
	} else if (strcmp(strVal, "wed") == 0) {
		setweek = 3;
		current = temp_entry.timer_wed; 
	} else if (strcmp(strVal, "thu") == 0) {
		setweek = 4;
		current = temp_entry.timer_thu; 
	} else if (strcmp(strVal, "fri") == 0) {
		setweek = 5;
		current = temp_entry.timer_fri; 
	} else if (strcmp(strVal, "sat") == 0) {
		setweek = 6;
		current = temp_entry.timer_sat; 
	}
			
	strVal = req_get_cstream_var(wp, ("init"), "");
	cp = strVal;
	for (i=0;i<6;i++) {
		ret = getScheduleByte(cp);
		if (ret < 0)
			return -1;
		original[i] = ret;
		cp+=8;
	}
	
	strVal = req_get_cstream_var(wp, ("tempPermit"), "");
	cp = strVal;
	for (i=0;i<6;i++) {
		ret = getScheduleByte(cp);
		if (ret < 0)
			return -1;
		temp_entry.timer_tmp[i] = ret & (~(original[i] ^ current[i]));
		cp+=8;
	}
	if (temp_entry.timer_tmp[0] == 0 &&
		temp_entry.timer_tmp[1] == 0 &&
		temp_entry.timer_tmp[2] == 0 &&
		temp_entry.timer_tmp[3] == 0 &&
		temp_entry.timer_tmp[4] == 0 &&
		temp_entry.timer_tmp[5] == 0 ) {
		temp_entry.timer_tmpday = 0;
	} else {
		struct tm* ctm;
		time_t currentTime;
 
		currentTime = time(NULL);
		ctm = localtime(&currentTime);
		if (ctm->tm_wday == setweek)
			temp_entry.timer_tmpday = ctm->tm_year *10000 + ctm->tm_mon *100 + ctm->tm_mday;
		else
			temp_entry.timer_tmpday = 0;
	}
	if (accessTimerAddEntry() < 0)
		return -1;
	
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #BEGIN
//	send_redirect_perm(wp, MWF_PORTAL_PAGE);
	req_format_write(wp, "<script> parent.showOK(\"%s\"); location.href=\"./kodomo_frame.htm\"; </script>", MWF_PORTAL_PAGE);
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #END
	return 0;
	
}
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-02-06: Implement Access Timer feature #END
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-03-04: Implement Access Timer feature #BEGIN
void formAccesstimerStaSetCategory(request *wp, char *path, char *query) {
	//char *submitUrl,*strVal;
	char *strVal;
	int i;
	int hb, lb;
	unsigned char sta_mac[6];
	int entryNum;
	ACCESS_TIMER_T entry;
	int action = -1;

	//submitUrl = req_get_cstream_var(wp, ("submit-url"), "");
	strVal = req_get_cstream_var(wp, ("addr"), "");

	for (i=0;i<6;i++) {
		hb =  getHex(strVal[i*3]);
		lb =  getHex(strVal[i*3+1]);
		if (hb < 0 || lb < 0)
		{
			fprintf(stderr,"Wrong station address\n");
			return;
		}
		sta_mac[i] = hb*16+lb;
	}
	
	if (memcmp(sta_mac, temp_entry.macAddr, 6) != 0) {
		accesstimer_guardmsg = 6;
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #BEGIN
		return req_format_write(wp, "<script>  top.redirectTo(\"%s\"); location.href=\"./kodomo_frame.html\";  </script>", MWF_PORTAL_PAGE);
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #END
	}

	strVal = req_get_cstream_var(wp, ("category"), "");
	if (strcmp(strVal, "adult") == 0) {
		memset(temp_entry.timer_sun, 0xFF, 6);
		memset(temp_entry.timer_mon, 0xFF, 6);
		memset(temp_entry.timer_tue, 0xFF, 6);
		memset(temp_entry.timer_wed, 0xFF, 6);
		memset(temp_entry.timer_thu, 0xFF, 6);
		memset(temp_entry.timer_fri, 0xFF, 6);
		memset(temp_entry.timer_sat, 0xFF, 6);
		memset(temp_entry.timer_tmp, 0x00, 6);
		temp_entry.category = 0;
	} else if (strcmp(strVal, "child") == 0) {
		memset(temp_entry.timer_sun, 0x00, 6);
		memset(temp_entry.timer_mon, 0x00, 6);
		memset(temp_entry.timer_tue, 0x00, 6);
		memset(temp_entry.timer_wed, 0x00, 6);
		memset(temp_entry.timer_thu, 0x00, 6);
		memset(temp_entry.timer_fri, 0x00, 6);
		memset(temp_entry.timer_sat, 0x00, 6);
		memset(temp_entry.timer_tmp, 0x00, 6);
		temp_entry.category = 1;
	}

	send_redirect_perm(wp, ACCESS_TIMER_FRAME_PAGE);
}
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-03-04: Implement Access Timer feature #END
void formAccesstimerGoto(request *wp, char *path, char *query) {
	//char *submitUrl,*strVal;
	char *strVal;
	int i;
	int hb, lb;
	unsigned char sta_mac[6];
	int entryNum;
	ACCESS_TIMER_T entry;
	int action = -1;

	//submitUrl = req_get_cstream_var(wp, ("submit-url"), "");
	strVal = req_get_cstream_var(wp, ("sta"), "");
	
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #BEGIN
	if (getMwfEntry(strVal) < 0)
		return -1;
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #END

	strVal = req_get_cstream_var(wp, ("showMsg"), "");
	accesstimer_guardmsg = atoi(strVal);

	strVal = req_get_cstream_var(wp, ("gotoUrl"), "");

	send_redirect_perm(wp, strVal);
}

int set_unspecified_connection_time()
{

	FILE *logfp = fopen("/dev/mtdblock2", "r");

	if (logfp) {
		int readlen = 0;
		int logi = 0, logm = 0, logn = 0, offset = 0;
		D_LOG_TB_Tp wifi_log = NULL;
		unsigned char	current_time[16];

		wifi_log = malloc(sizeof(D_LOG_TB_T));
		if (wifi_log == NULL) {
			fclose(logfp);
			return -1;
		}
		readlen = fread(wifi_log, sizeof(D_LOG_TB_T), 1, logfp);
		if (readlen != 1)
		{
			free(wifi_log);
			wifi_log = NULL;
			fclose(logfp);
			return -1;
		}
		
		fclose(logfp);
		
		strncpy(current_time, lw_get_system_time_for_sensor_notify(), sizeof(current_time)-1);

		while (logm < MAX_WIFI_LOG_NUM) {
		
			if (logm < MAX_WIFI_RGST_LOG_NUM) {
				logi = 0;
				logm = MAX_WIFI_RGST_LOG_NUM;
				logn = 0 + wifi_log->rgst_num;
				offset = REGISTER_OFFSET;
			} else if (logm < MAX_WIFI_RGST_LOG_NUM + MAX_WIFI_INQTS_LOG_NUM) {
				logi = MAX_WIFI_RGST_LOG_NUM;
				logm = MAX_WIFI_RGST_LOG_NUM + MAX_WIFI_INQTS_LOG_NUM;
				logn = MAX_WIFI_RGST_LOG_NUM + wifi_log->inqts_num;
				offset = INIQUITOUS_OFFSET;
			} else if (logm < MAX_WIFI_RGST_LOG_NUM + MAX_WIFI_INQTS_LOG_NUM + MAX_WIFI_NRGST_LOG_NUM) {
				logi = MAX_WIFI_RGST_LOG_NUM + MAX_WIFI_INQTS_LOG_NUM;
				logm = MAX_WIFI_RGST_LOG_NUM + MAX_WIFI_INQTS_LOG_NUM + MAX_WIFI_NRGST_LOG_NUM;
				logn = MAX_WIFI_RGST_LOG_NUM + MAX_WIFI_INQTS_LOG_NUM + wifi_log->nrgst_num;
				offset = NO_REGISTER_OFFSET;
			} else {
				break;
			}
			for (;logi<logn;logi++) {
		
				if (strncmp(wifi_log->wifi_node[logi].date, "unspecified", 15) == 0) {
					strncpy(wifi_log->wifi_node[logi].date, current_time, 15);
					update_time_to_wfbk_flash(&(wifi_log->wifi_node[logi]), offset, sizeof (struct wifi_log));
				}
			}
		}
		free(wifi_log);
		wifi_log = NULL;
	}
		
	return 0;
}

#endif	//#ifdef CONFIG_APP_ACCESSTIMER
